-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db27-28710311-0
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2021-01-14 21:13:01','Actividad Generica 1','000001',NULL),(2,NULL,'2021-01-14 21:13:01','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,2271,40719,9,2,1,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',3500.00,NULL,NULL,1,'2021-07-15 23:10:55','2021-07-15 23:11:05','2021-07-15 23:11:05'),(2,2271,40719,8,15,NULL,1,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',0.00,NULL,NULL,1,'2021-07-16 21:37:23','2021-07-16 21:37:23',NULL),(3,2271,40719,8,2,2,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',2000.00,NULL,NULL,1,'2021-07-23 00:43:13','2021-07-23 00:43:13',NULL),(4,2271,40719,8,2,3,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',1500.00,NULL,NULL,1,'2021-07-23 01:05:37','2021-07-23 01:05:37',NULL),(5,2271,40719,8,2,4,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',1500.00,NULL,NULL,1,'2021-07-23 01:06:24','2021-07-23 01:06:24',NULL),(6,2271,40719,8,2,5,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',1500.00,NULL,NULL,1,'2021-07-23 01:14:59','2021-07-23 01:14:59',NULL);
/*!40000 ALTER TABLE `balance_libro` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro_details`
--

DROP TABLE IF EXISTS `balance_libro_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `balance_libro_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_details_person_id_foreign` (`person_id`),
  KEY `balance_libro_details_period_id_foreign` (`period_id`),
  KEY `balance_libro_details_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_details_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_libro_details_saldo_id_foreign` (`saldo_id`),
  KEY `balance_libro_details_balance_libro_id_foreign` (`balance_libro_id`),
  CONSTRAINT `balance_libro_details_balance_libro_id_foreign` FOREIGN KEY (`balance_libro_id`) REFERENCES `balance_libro` (`id`) ON DELETE CASCADE,
  CONSTRAINT `balance_libro_details_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_details_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `balance_libro_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro_details`
--

LOCK TABLES `balance_libro_details` WRITE;
/*!40000 ALTER TABLE `balance_libro_details` DISABLE KEYS */;
INSERT INTO `balance_libro_details` VALUES (1,2271,1,40719,9,2,218,2,3500.00,NULL,'2021-07-15 23:10:55','2021-07-15 23:11:05','2021-07-15 23:11:05'),(2,2271,1,40719,9,2,13,1,3500.00,NULL,'2021-07-15 23:10:55','2021-07-15 23:11:05','2021-07-15 23:11:05'),(3,2271,3,40719,8,2,218,2,2000.00,NULL,'2021-07-23 00:43:13','2021-07-23 00:43:13',NULL),(4,2271,3,40719,8,2,13,1,2000.00,NULL,'2021-07-23 00:43:13','2021-07-23 00:43:13',NULL),(5,2271,4,40719,8,2,218,2,1500.00,NULL,'2021-07-23 01:05:37','2021-07-23 01:05:37',NULL),(6,2271,4,40719,8,2,13,1,1500.00,NULL,'2021-07-23 01:05:37','2021-07-23 01:05:37',NULL),(7,2271,5,40719,8,2,218,2,1500.00,NULL,'2021-07-23 01:06:24','2021-07-23 01:06:24',NULL),(8,2271,5,40719,8,2,13,1,1500.00,NULL,'2021-07-23 01:06:24','2021-07-23 01:06:24',NULL),(9,2271,6,40719,8,2,218,2,1500.00,NULL,'2021-07-23 01:14:59','2021-07-23 01:14:59',NULL),(10,2271,6,40719,8,2,13,1,1500.00,NULL,'2021-07-23 01:14:59','2021-07-23 01:14:59',NULL);
/*!40000 ALTER TABLE `balance_libro_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs`
--

DROP TABLE IF EXISTS `blogs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fecha` date NOT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `blogs_categoria_sub_id` int(10) unsigned NOT NULL,
  `path` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `titulo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `contenido` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autor` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `publicar` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  KEY `blogs_blogs_categoria_sub_id_foreign` (`blogs_categoria_sub_id`),
  CONSTRAINT `blogs_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`),
  CONSTRAINT `blogs_blogs_categoria_sub_id_foreign` FOREIGN KEY (`blogs_categoria_sub_id`) REFERENCES `blogs_categorias_sub` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs`
--

LOCK TABLES `blogs` WRITE;
/*!40000 ALTER TABLE `blogs` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias`
--

DROP TABLE IF EXISTS `blogs_categorias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias`
--

LOCK TABLES `blogs_categorias` WRITE;
/*!40000 ALTER TABLE `blogs_categorias` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias_sub`
--

DROP TABLE IF EXISTS `blogs_categorias_sub`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias_sub` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_categorias_sub_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  CONSTRAINT `blogs_categorias_sub_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias_sub`
--

LOCK TABLES `blogs_categorias_sub` WRITE;
/*!40000 ALTER TABLE `blogs_categorias_sub` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias_sub` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_alicuotas`
--

DROP TABLE IF EXISTS `bs_per_alicuotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_alicuotas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `anio` int(10) unsigned NOT NULL,
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `desde` decimal(16,2) NOT NULL DEFAULT '0.00',
  `hasta` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `mas_porcentaje` decimal(16,4) NOT NULL DEFAULT '0.0000',
  `excedente` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_alicuotas`
--

LOCK TABLES `bs_per_alicuotas` WRITE;
/*!40000 ALTER TABLE `bs_per_alicuotas` DISABLE KEYS */;
INSERT INTO `bs_per_alicuotas` VALUES (1,2017,950000.00,0.00,999999999.99,0.00,0.0050,950000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,2018,1050000.00,0.00,999999999.99,0.00,0.0025,1050000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,2019,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2019-11-19 21:09:50','2021-01-14 21:13:00',NULL),(4,2019,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2019-11-19 21:09:50','2021-01-14 21:13:00',NULL),(5,2019,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2019-11-19 21:09:50','2021-01-14 21:13:00',NULL),(6,2019,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2021-01-14 21:13:00','2021-01-14 21:13:00',NULL),(7,2020,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2021-06-15 20:38:09','2021-06-30 13:07:52',NULL),(8,2020,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2021-06-15 20:38:09','2021-06-30 13:07:52',NULL),(9,2020,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2021-06-15 20:38:09','2021-06-30 13:07:52',NULL),(10,2020,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2021-06-15 20:38:09','2021-06-30 13:07:52',NULL);
/*!40000 ALTER TABLE `bs_per_alicuotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_ddjjs`
--

DROP TABLE IF EXISTS `bs_per_ddjjs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_ddjjs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `anio` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `total_bienes_gravados` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total_bienes_exentos` decimal(16,2) NOT NULL DEFAULT '0.00',
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `base_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto_determinado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_pagar` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_favor` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_per_ddjjs_person_id_foreign` (`person_id`),
  CONSTRAINT `bs_per_ddjjs_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_ddjjs`
--

LOCK TABLES `bs_per_ddjjs` WRITE;
/*!40000 ALTER TABLE `bs_per_ddjjs` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_per_ddjjs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_conceptos`
--

DROP TABLE IF EXISTS `bs_pers_conceptos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_conceptos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_conceptos`
--

LOCK TABLES `bs_pers_conceptos` WRITE;
/*!40000 ALTER TABLE `bs_pers_conceptos` DISABLE KEYS */;
INSERT INTO `bs_pers_conceptos` VALUES (1,'Inmuebles',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,'Derechos Reales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,'Naves y Aeronaves',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(4,'Automotores y otros rodados',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(5,'Dinero y depósitos en dinero',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(6,'Títulos, acciones, cuotas o participaciones sociales y otros títulos valores',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(7,'Patrimonio de empresas o explotaciones unipersonales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(8,'Créditos y debentures',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(9,'Derechos de propiedad científica, literaria o artística, marcas, patentes y sus licencias',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(10,'Otros Bienes (incluye semovientes, antigüedades, objetos de colección, objetos de arte, ...)',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(11,'Objetos Personales y del Hogar',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL);
/*!40000 ALTER TABLE `bs_pers_conceptos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_anticipos`
--

DROP TABLE IF EXISTS `bs_pers_detail_anticipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_anticipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ganan_concepto_anticipo_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_anticipos_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` (`ganan_concepto_anticipo_id`),
  CONSTRAINT `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` FOREIGN KEY (`ganan_concepto_anticipo_id`) REFERENCES `ganan_conceptos_anticipos` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_anticipos`
--

LOCK TABLES `bs_pers_detail_anticipos` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_bienes`
--

DROP TABLE IF EXISTS `bs_pers_detail_bienes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_bienes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `bs_pers_concepto_id` int(10) unsigned NOT NULL,
  `concepto` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe_gravado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `importe_exento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_bienes_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` (`bs_pers_concepto_id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` FOREIGN KEY (`bs_pers_concepto_id`) REFERENCES `bs_pers_conceptos` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_bienes`
--

LOCK TABLES `bs_pers_detail_bienes` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calle`
--

DROP TABLE IF EXISTS `calle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calle` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `localidad_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `desdealt` int(10) unsigned DEFAULT NULL,
  `hastaalt` int(10) unsigned DEFAULT NULL,
  `codpostal` int(10) unsigned DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calle_localidad_id_foreign` (`localidad_id`),
  CONSTRAINT `calle_localidad_id_foreign` FOREIGN KEY (`localidad_id`) REFERENCES `localidad` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calle`
--

LOCK TABLES `calle` WRITE;
/*!40000 ALTER TABLE `calle` DISABLE KEYS */;
INSERT INTO `calle` VALUES (1,NULL,1,'Ramon Falcon',6800,7500,1408,1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL);
/*!40000 ALTER TABLE `calle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_iibb`
--

DROP TABLE IF EXISTS `categorias_iibb`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_iibb` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `impuesto` decimal(16,2) DEFAULT NULL,
  `anual` decimal(16,2) DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_iibb`
--

LOCK TABLES `categorias_iibb` WRITE;
/*!40000 ALTER TABLE `categorias_iibb` DISABLE KEYS */;
INSERT INTO `categorias_iibb` VALUES (1,'A',1045.00,6270.00,208739.25,30,3300,NULL,'1',NULL,NULL,NULL),(2,'B',1565.00,9390.00,313108.87,45,5000,NULL,'1',NULL,NULL,NULL),(3,'C',2090.00,12540.00,417478.51,60,6700,NULL,'1',NULL,NULL,NULL),(4,'D',3130.00,18780.00,626217.78,85,10000,NULL,'1',NULL,NULL,NULL),(5,'E',4175.00,25050.00,834957.00,110,13000,NULL,'1',NULL,NULL,NULL),(6,'F',5220.00,31320.00,1043696.27,150,16500,NULL,'1',NULL,NULL,NULL),(7,'G',6260.00,37560.00,1252435.53,200,20000,NULL,'1',NULL,NULL,NULL),(8,'H',8700.00,52200.00,1739493.79,200,20000,NULL,'1',NULL,NULL,NULL);
/*!40000 ALTER TABLE `categorias_iibb` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_monotributo`
--

DROP TABLE IF EXISTS `categorias_monotributo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_monotributo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `facMensual` decimal(16,2) DEFAULT NULL,
  `actividad` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `empleados` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `alquileres` decimal(16,2) DEFAULT NULL,
  `impuesto_servicio` decimal(16,2) DEFAULT NULL,
  `impuesto_venta` decimal(16,2) DEFAULT NULL,
  `sipa` decimal(16,2) DEFAULT NULL,
  `obraSocial` decimal(16,2) DEFAULT NULL,
  `totalServicio` decimal(16,2) DEFAULT NULL,
  `totalVenta` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `desde` date DEFAULT NULL,
  `hasta` date DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_monotributo`
--

LOCK TABLES `categorias_monotributo` WRITE;
/*!40000 ALTER TABLE `categorias_monotributo` DISABLE KEYS */;
INSERT INTO `categorias_monotributo` VALUES (1,'A',370000.00,30833.00,'No Excluida','0',30,3330,105916.77,228.63,228.63,1008.72,1408.87,2646.22,2646.22,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(2,'B',550000.00,45833.00,'No Excluida','0',45,5000,105916.77,440.49,440.49,1109.59,1408.87,2958.95,2958.95,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(3,'C',770000.00,64166.00,'No Excluida','0',60,6700,211833.52,753.19,696.01,1220.56,1408.87,3382.62,3325.44,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(4,'D',1060000.00,88333.00,'No Excluida','0',85,10000,211833.52,1237.37,1143.23,1342.61,1408.87,3988.85,3894.71,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(5,'E',1400000.00,116666.00,'No Excluida','0',110,13000,263951.28,2353.69,1825.79,1476.88,1408.87,5239.44,4711.54,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(6,'F',1750000.00,145833.00,'No Excluida','0',150,16500,264791.88,3238.03,2383.95,1624.56,1408.87,6271.46,5417.38,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(7,'G',2100000.00,175000.00,'No Excluida','0',200,20000,317750.28,4118.99,2972.36,1787.01,1408.87,7314.87,6168.24,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(8,'H',2600000.00,216666.00,'No Excluida','0',200,20000,423667.03,9414.80,7296.50,1965.71,1408.87,12789.38,10671.08,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(9,'I',2910000.00,242500.00,'Venta de Bs Muebles','0',200,20000,423667.03,NULL,11768.52,2162.29,1408.87,NULL,15339.68,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(10,'J',3335000.00,277916.00,'Venta de Bs Muebles','0',200,20000,423667.03,NULL,13829.70,2378.53,1408.87,NULL,17617.10,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(11,'K',3700000.00,308333.00,'Venta de Bs Muebles','0',200,20000,423667.03,NULL,15887.51,2616.36,1408.87,NULL,19912.74,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(12,'Monotributo Social',208739.25,17394.94,'No Excluida','0',0,0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,NULL,'2018-01-01',NULL,'1','2020-02-27 02:46:40','2020-02-27 02:46:40',NULL);
/*!40000 ALTER TABLE `categorias_monotributo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `charlas_details`
--

DROP TABLE IF EXISTS `charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `charla` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `charlas_details`
--

LOCK TABLES `charlas_details` WRITE;
/*!40000 ALTER TABLE `charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `charlas_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `CharlaDetail_BD` BEFORE DELETE ON `charlas_details` FOR EACH ROW insert into back_up_charlas_details (charla,person_id,modificado)
values(old.charla,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `claves`
--

DROP TABLE IF EXISTS `claves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves`
--

LOCK TABLES `claves` WRITE;
/*!40000 ALTER TABLE `claves` DISABLE KEYS */;
INSERT INTO `claves` VALUES (1,'Clave Fiscal',NULL,NULL),(2,'Clave Ciudad',NULL,NULL),(3,'Clave ARBA',NULL,NULL),(4,'Clave ANSES',NULL,NULL),(5,'Catedral',NULL,NULL),(6,'CEMIBA',NULL,NULL),(7,'COMPRA ARG',NULL,NULL),(8,'Consejo Ciencias Economicas',NULL,NULL),(9,'Correo',NULL,NULL),(10,'CUR',NULL,NULL),(11,'Firma Digital',NULL,NULL),(12,'Interbanking',NULL,NULL),(13,'Banco Citibank',NULL,NULL),(14,'Banco Ciudad',NULL,NULL),(15,'Banco Frances',NULL,NULL),(16,'Banco Galicia',NULL,NULL),(17,'Banco HSBC',NULL,NULL),(18,'Banco Itau',NULL,NULL),(19,'Banco Nacion',NULL,NULL),(20,'Banco Macro',NULL,NULL),(21,'Banco Patagonia',NULL,NULL),(22,'Banco Provincia',NULL,NULL),(23,'Banco Santander',NULL,NULL),(24,'Banco Supervielle',NULL,NULL),(25,'Seguridad e Higiene',NULL,NULL),(26,'Sindicato - ANSES',NULL,NULL),(27,'Sindicato - AOT',NULL,NULL),(28,'Sindicato - ATSA',NULL,NULL),(29,'Sindicato - Camioneros',NULL,NULL),(30,'Sindicato - Guinchero',NULL,NULL),(31,'Sindicato - IERIC',NULL,NULL),(32,'Sindicato - La Estrella',NULL,NULL),(33,'Sindicato - Nemesis',NULL,NULL),(34,'Sindicato - Pasta',NULL,NULL),(35,'Sindicato - SEC',NULL,NULL),(36,'Sindicato - SICOP',NULL,NULL),(37,'Sindicato - SOCAYA',NULL,NULL),(38,'Sindicato - UTHGRA',NULL,NULL),(39,'Sindicato - INACAP',NULL,NULL),(40,'Sindicato - Otro',NULL,NULL),(41,'Otra',NULL,NULL),(42,'Prisma - Firma Digital',NULL,NULL),(43,'Sindicato - FATSA',NULL,NULL);
/*!40000 ALTER TABLE `claves` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claves_details`
--

DROP TABLE IF EXISTS `claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `claves_details_clave_id_foreign` (`clave_id`),
  KEY `claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_details`
--

LOCK TABLES `claves_details` WRITE;
/*!40000 ALTER TABLE `claves_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `claves_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `ClavesDetail_BD` BEFORE DELETE ON `claves_details` FOR EACH ROW insert into back_up_claves_details (clave,valor,comentario,clave_id,person_id,modificado)
values(old.clave,old.valor,old.comentario,old.clave_id,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `claves_mails`
--

DROP TABLE IF EXISTS `claves_mails`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_mails` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_mails`
--

LOCK TABLES `claves_mails` WRITE;
/*!40000 ALTER TABLE `claves_mails` DISABLE KEYS */;
INSERT INTO `claves_mails` VALUES (1,'Listado de Claves',1,'Claves','claves_mails/claves_listado',NULL,NULL),(3,'Listado de Mails',2,'Mails','claves_mails/mails_listado',NULL,NULL),(5,'Listado de Charlas',3,'Charlas','claves_mails/charlas_listado',NULL,NULL);
/*!40000 ALTER TABLE `claves_mails` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cm_articulos_regimenes`
--

DROP TABLE IF EXISTS `cm_articulos_regimenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cm_articulos_regimenes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `codigo` int(11) DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cm_articulos_regimenes`
--

LOCK TABLES `cm_articulos_regimenes` WRITE;
/*!40000 ALTER TABLE `cm_articulos_regimenes` DISABLE KEYS */;
INSERT INTO `cm_articulos_regimenes` VALUES (1,NULL,'Articulo 2',2,1,'2021-07-26 03:41:25','2021-07-29 08:37:36',NULL),(2,NULL,'Articulo 6',6,0,'2021-07-26 03:41:25','2021-07-29 08:37:36',NULL),(3,NULL,'Articulo 7',7,0,'2021-07-26 03:41:25','2021-07-29 08:37:36',NULL),(4,NULL,'Articulo 8',8,0,'2021-07-26 03:41:25','2021-07-29 08:37:36',NULL),(5,NULL,'Articulo 9',9,0,'2021-07-26 03:41:25','2021-07-29 08:37:36',NULL),(6,NULL,'Articulo 10',10,0,'2021-07-26 03:41:25','2021-07-29 08:37:36',NULL),(7,NULL,'Articulo 11',11,0,'2021-07-26 03:41:25','2021-07-29 08:37:36',NULL),(8,NULL,'Articulo 12',12,0,'2021-07-26 03:41:25','2021-07-29 08:37:36',NULL),(9,NULL,'Articulo 13',13,0,'2021-07-26 03:41:25','2021-07-29 08:37:36',NULL),(10,NULL,'Articulo 14',14,1,'2021-07-26 03:41:25','2021-07-29 08:37:36',NULL);
/*!40000 ALTER TABLE `cm_articulos_regimenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condiciones_venta`
--

DROP TABLE IF EXISTS `condiciones_venta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condiciones_venta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condiciones_venta`
--

LOCK TABLES `condiciones_venta` WRITE;
/*!40000 ALTER TABLE `condiciones_venta` DISABLE KEYS */;
INSERT INTO `condiciones_venta` VALUES (1,'Contado',NULL,NULL),(2,'Tarjeta de Debito',NULL,NULL),(3,'Tarjeta de Credito',NULL,NULL),(4,'Cuenta Corriente',NULL,NULL),(5,'Cheque',NULL,NULL),(6,'Ticket',NULL,NULL),(7,'Transferencia',NULL,NULL),(8,'Otra',NULL,NULL);
/*!40000 ALTER TABLE `condiciones_venta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_asientos`
--

DROP TABLE IF EXISTS `conta_asientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_asientos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `debe_cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `haber_cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `ctactecheque_id` int(10) unsigned DEFAULT NULL,
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `adjunto` text COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `radioChecked` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `CuentaTipo_id` int(10) unsigned DEFAULT NULL,
  `CentroCosto_id` int(10) unsigned DEFAULT NULL,
  `pagado` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_asientos_person_id_foreign` (`person_id`),
  KEY `conta_asientos_period_id_foreign` (`period_id`),
  KEY `conta_asientos_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `conta_asientos_cuentatipo_id_foreign` (`CuentaTipo_id`),
  KEY `conta_asientos_centrocosto_id_foreign` (`CentroCosto_id`),
  KEY `conta_asientos_ctactecheque_id_foreign` (`ctactecheque_id`),
  KEY `conta_asientos_haber_cta_cte_tesoreria_cuenta_id_foreign` (`haber_cta_cte_tesoreria_cuenta_id`),
  KEY `conta_asientos_debe_cta_cte_tesoreria_cuenta_id_foreign` (`debe_cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `conta_asientos_centrocosto_id_foreign` FOREIGN KEY (`CentroCosto_id`) REFERENCES `ctactegastos_centrocosto` (`id`),
  CONSTRAINT `conta_asientos_ctactecheque_id_foreign` FOREIGN KEY (`ctactecheque_id`) REFERENCES `ctacte_cheques` (`id`),
  CONSTRAINT `conta_asientos_cuentatipo_id_foreign` FOREIGN KEY (`CuentaTipo_id`) REFERENCES `ctactegastos_cuenta_tipo` (`idCuentaTipo`),
  CONSTRAINT `conta_asientos_debe_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`debe_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_haber_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`haber_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `conta_asientos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `conta_asientos_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_asientos`
--

LOCK TABLES `conta_asientos` WRITE;
/*!40000 ALTER TABLE `conta_asientos` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_asientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_asientos_details`
--

DROP TABLE IF EXISTS `conta_asientos_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_asientos_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_asientos_details_conta_asiento_id_foreign` (`conta_asiento_id`),
  KEY `conta_asientos_details_person_id_foreign` (`person_id`),
  KEY `conta_asientos_details_period_id_foreign` (`period_id`),
  KEY `conta_asientos_details_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `conta_asientos_details_saldo_id_foreign` (`saldo_id`),
  KEY `conta_asientos_details_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `conta_asientos_details_conta_asiento_id_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `conta_asientos_details_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `conta_asientos_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `conta_asientos_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `conta_asientos_details_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_asientos_details`
--

LOCK TABLES `conta_asientos_details` WRITE;
/*!40000 ALTER TABLE `conta_asientos_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_asientos_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_plan_cuenta`
--

DROP TABLE IF EXISTS `conta_plan_cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_plan_cuenta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `codigo` int(11) NOT NULL,
  `tipo_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `padre` int(11) NOT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rubro` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `no_editable` int(11) NOT NULL DEFAULT '1',
  `tes_cta_cte` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_origen` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_destino` tinyint(1) NOT NULL DEFAULT '0',
  `conta_asientos` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_plan_cuenta_tipo_cuenta_id_foreign` (`tipo_cuenta_id`),
  KEY `conta_plan_cuenta_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `conta_plan_cuenta_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `conta_plan_cuenta_tipo_cuenta_id_foreign` FOREIGN KEY (`tipo_cuenta_id`) REFERENCES `conta_tipo_cuentas` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=482 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_plan_cuenta`
--

LOCK TABLES `conta_plan_cuenta` WRITE;
/*!40000 ALTER TABLE `conta_plan_cuenta` DISABLE KEYS */;
INSERT INTO `conta_plan_cuenta` VALUES (1,NULL,1000000,1,1,0,'ACTIVO','Activo',NULL,1,1,0,0,0,0,NULL),(2,NULL,1100000,2,1,1000000,'ACTIVO CORRIENTE','Activo',NULL,1,1,0,0,0,0,NULL),(3,NULL,1110000,3,1,1100000,'CAJA Y BANCOS','Activo',NULL,1,1,0,0,0,0,NULL),(4,NULL,1110100,4,1,1110000,'CAJAS','Activo',NULL,1,1,0,0,0,0,NULL),(5,NULL,1110101,5,1,1110100,'Caja Oficina','Activo',NULL,0,1,0,0,0,0,NULL),(6,NULL,1110102,5,1,1110100,'Caja Casa','Activo',NULL,0,1,0,0,0,0,NULL),(7,NULL,1110103,5,1,1110100,'Caja Dolares Casa','Activo',NULL,0,1,0,0,0,0,NULL),(8,NULL,1110104,5,1,1110100,'Banco Santander 015-372795/5','Activo',NULL,0,1,0,0,0,0,NULL),(9,NULL,1110200,4,1,1110000,'BANCOS','Activo',NULL,1,1,0,0,0,0,NULL),(10,NULL,1110201,5,1,1110200,'Banco Santander Rio Cta Corriente','Activo',NULL,1,2,1,1,1,0,NULL),(11,NULL,1110202,5,1,1110200,'Banco Santander Rio Cta Corriente DOLARES','Activo',NULL,1,2,1,1,1,0,NULL),(12,NULL,1130000,3,1,1100000,'CREDITOS POR VENTAS','Activo',NULL,1,1,0,0,0,0,NULL),(13,NULL,1130101,5,1,1130100,'Clientes - Deudores','Activo',NULL,1,2,0,0,0,1,NULL),(14,NULL,1130102,5,1,1130100,'Deudores por ventas comunes','Activo',NULL,1,1,0,0,0,1,NULL),(15,NULL,1130103,5,1,1130100,'Deudores por ventas morosos','Activo',NULL,1,1,0,0,0,1,NULL),(16,NULL,1130104,5,1,1130100,'Deudores en gestión judicial','Activo',NULL,1,1,0,0,0,1,NULL),(17,NULL,1130105,5,1,1130100,'Previsión deudores incobrables','Activo',NULL,1,1,0,0,0,1,NULL),(18,NULL,1140000,3,1,1100000,'OTROS CREDITOS','Activo',NULL,1,1,0,0,0,0,NULL),(19,NULL,1140100,4,1,1140000,'Retenciones Sufridas','Activo',NULL,1,1,0,0,0,0,NULL),(20,NULL,1140301,5,1,1140300,'Anticipos Impuesto a las Ganancias','Activo',NULL,1,2,0,0,1,1,NULL),(21,NULL,1140102,5,1,1140100,'Retenciones Ingr. Brutos','Activo',NULL,0,1,0,0,0,0,NULL),(22,NULL,1140329,5,1,1140300,'Anticipo Impto.Ganancia Mínima Presunta','Activo',NULL,1,1,0,0,0,1,NULL),(23,NULL,1140105,5,1,1140100,'Retenciones Impuesto a las Ganancias','Activo',NULL,1,2,1,0,0,1,NULL),(24,NULL,1140106,5,1,1140100,'Impuesto a las Ganancias (Saldo a favor)','Activo',NULL,1,1,0,0,0,1,NULL),(25,NULL,1140107,5,1,1140100,'Retenciones de IVA','Activo',NULL,1,2,1,0,0,1,NULL),(26,NULL,1140200,4,1,1140000,'CREDITOS DIVERSOS','Activo',NULL,1,1,0,0,0,0,NULL),(27,NULL,1140201,5,1,1140200,'Anticipos de proveedores','Activo',NULL,1,1,0,0,0,1,NULL),(28,NULL,1140205,5,1,1140200,'Depósito en garantía alquileres','Activo',NULL,1,1,0,0,0,1,NULL),(29,NULL,1140206,5,1,1140200,'Derechos adquiridos a devengar','Activo',NULL,1,1,0,0,0,1,NULL),(30,NULL,1140207,5,1,1140200,'Intereses a devengar','Activo',NULL,1,1,0,0,0,1,NULL),(31,NULL,1140208,5,1,1140200,'Cuentas a rendir - Directores','Activo',NULL,1,1,0,0,0,1,NULL),(32,NULL,1140210,5,1,1140200,'Alquileres no devengados','Activo',NULL,1,1,0,0,0,1,NULL),(33,NULL,1150000,3,1,1100000,'BIENES DE CAMBIO','Activo',NULL,1,1,0,0,0,0,NULL),(34,NULL,1150400,4,1,1150000,'MERCADERIA DE REVENTA','Activo',NULL,1,1,0,0,0,0,NULL),(35,NULL,1200000,2,1,1000000,'ACTIVO NO CORRIENTE','Activo',NULL,1,1,0,0,0,0,NULL),(36,NULL,1220000,3,1,1200000,'BIENES DE USO','Activo',NULL,1,1,0,0,0,0,NULL),(37,NULL,1220100,4,1,1220000,'EQUIPOS DE COMPUTACION','Activo',NULL,1,1,0,0,0,0,NULL),(38,NULL,1220101,5,1,1220100,'Equipos de computación valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(39,NULL,1220102,5,1,1220100,'Equipos de computación ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(40,NULL,1220108,5,1,1220100,'Amortización Acumulada Equipos de comput.','Activo',NULL,1,1,0,0,0,1,NULL),(41,NULL,1220200,4,1,1220000,'INSTALACIONES','Activo',NULL,1,1,0,0,0,0,NULL),(42,NULL,1220201,5,1,1220200,'Instalaciones valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(43,NULL,1220202,5,1,1220200,'Instalaciones ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(44,NULL,1220206,5,1,1220200,'Amortización Acumulada Instalaciones','Activo',NULL,1,1,0,0,0,1,NULL),(45,NULL,1220300,4,1,1220000,'MUEBLES Y UTILES','Activo',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (46,NULL,1220301,5,1,1220300,'Muebles y utiles valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(47,NULL,1220302,5,1,1220300,'Muebles y utiles ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(48,NULL,1220306,5,1,1220300,'Amortización Acumulada Muebles y Útiles','Activo',NULL,1,1,0,0,0,1,NULL),(49,NULL,1230000,3,1,1200000,'ACTIVOS INTANGIBLES','Activo',NULL,1,1,0,0,0,0,NULL),(50,NULL,1230101,5,1,1230100,'Gastos de organización valores historicos','Activo',NULL,1,1,0,0,0,1,NULL),(51,NULL,1230102,5,1,1230100,'Gastos de organización ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(52,NULL,1230103,5,1,1230100,'Amortización acumulada gs. de organización','Activo',NULL,1,1,0,0,0,1,NULL),(53,NULL,2000000,1,2,0,'PASIVO','Pasivo',NULL,1,1,0,0,0,0,NULL),(54,NULL,2100000,2,2,2000000,'PASIVO CORRIENTE','Pasivo',NULL,1,1,0,0,0,0,NULL),(55,NULL,2110000,3,2,2100000,'Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(56,NULL,2110100,4,2,2110000,'Comerciales','Pasivo',NULL,1,1,0,0,0,0,NULL),(57,NULL,2110101,5,2,2110100,'Proveedores en Cta. Cte. locales','Pasivo',NULL,1,2,0,0,0,1,NULL),(58,NULL,2110102,5,2,2110100,'Proveedores en cta. cte. exterior','Pasivo',NULL,1,1,0,0,0,1,NULL),(59,NULL,2110103,5,2,2110100,'Derechos de exhibición a devengar','Pasivo',NULL,1,1,0,0,0,1,NULL),(60,NULL,2110104,5,2,2110100,'Cheques emitidos ','Pasivo',NULL,1,2,1,1,1,1,NULL),(61,NULL,2110200,4,2,2110000,'REMUNERACIONES Y CARGAS SOCIALES','Pasivo',NULL,1,1,0,0,0,0,NULL),(62,NULL,2110201,5,2,2110200,'Sueldos y Jornales a pagar','Pasivo',NULL,1,2,0,0,1,1,NULL),(63,NULL,2110202,5,2,2110200,'Cargas sociales a pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(64,NULL,2110203,5,2,2110200,'Sindicatos a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(65,NULL,2110300,4,2,2110000,'CARGAS FISCALES','Pasivo',NULL,1,1,0,0,0,0,NULL),(67,NULL,2110301,5,2,2110300,'IVA Debito Fiscal','Pasivo',NULL,1,2,0,0,0,1,NULL),(68,NULL,1140222,5,1,1140200,'IVA Credito Fiscal','Activo',NULL,1,2,0,0,0,1,NULL),(69,NULL,2110303,5,2,2110300,'Impuestos Internos','Pasivo',NULL,1,1,0,0,0,1,NULL),(70,NULL,2110304,5,2,2110300,'Impuestos al Combustible','Pasivo',NULL,1,1,0,0,0,1,NULL),(71,NULL,2110601,5,2,2110600,'IVA Retenciones de terceros','Pasivo',NULL,1,1,0,0,0,1,NULL),(72,NULL,2110306,5,2,2110300,'IVA Percepciones realiz.por terceros','Pasivo',NULL,1,2,0,0,0,1,NULL),(73,NULL,2110307,5,2,2110300,'IVA Saldo a favor','Pasivo',NULL,1,1,0,0,0,1,NULL),(74,NULL,2110308,5,2,2110300,'IVA a pagar','Pasivo',NULL,1,2,0,0,0,1,NULL),(75,NULL,2110309,5,2,2110300,'Percepciones Ingresos Brutos','Pasivo',NULL,1,1,0,0,0,1,NULL),(76,NULL,2110310,5,2,2110300,'Otros Pagos AFIP','Pasivo',NULL,1,1,0,0,0,1,NULL),(78,NULL,2110350,5,2,2110300,'Impuesto a los Ingresos Brutos Pasivo','Pasivo',NULL,1,1,0,0,0,1,NULL),(79,NULL,2110313,5,2,2110300,'Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(80,NULL,2110314,5,2,2110300,'Impuesto a la Ganancia Mínima Presunta','Pasivo',NULL,1,1,0,0,0,1,NULL),(81,NULL,2110602,5,2,2110600,'AFIP - Retenciones Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(82,NULL,2110316,5,2,2110300,'AFIP - Plan de Facilidades Decreto 338/02','Pasivo',NULL,1,1,0,0,0,1,NULL),(83,NULL,2200000,2,2,2000000,'PASIVO NO CORRIENTE','Pasivo',NULL,1,1,0,0,0,0,NULL),(84,NULL,3000000,1,2,0,'PATRIMONIO NETO','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(85,NULL,3100000,2,2,3000000,'APORTE DE LOS PROPIETARIOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(86,NULL,3110100,4,2,3110000,'CAPITAL SOCIAL','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(87,NULL,3110101,5,2,3110100,'Acciones en circulación','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(88,NULL,3110102,5,2,3110100,'Ajuste del Capital','Patrimonio Neto',NULL,1,2,0,0,0,1,NULL),(89,NULL,3110103,5,2,3110100,'Aportes Irrevocables Futuras Suscripciones','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(90,NULL,3400000,2,2,3000000,'RESULTADOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(91,NULL,3410101,5,2,3410100,'Resultado del ejercicio','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (92,NULL,3410102,5,2,3410100,'Resultado ejercicios anteriores','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(93,NULL,3410103,5,2,3410100,'A.R.E.A.','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(94,NULL,4000000,1,2,0,'INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(95,NULL,4100000,2,2,4000000,'INGRESOS ORDINARIOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(96,NULL,4110101,5,2,4110100,'VENTAS','Result. Positivo',NULL,1,2,0,0,0,1,NULL),(97,NULL,4110102,5,2,4110100,'Honorarios','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(98,NULL,4110103,5,2,4110100,'Sueldo Vane','Result. Positivo',NULL,0,1,0,0,0,0,NULL),(99,NULL,4110104,5,2,4110100,'Descuentos obtenidos','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(100,NULL,4110105,5,2,4110100,'Reintegros por exportaciones','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(101,NULL,4120000,3,2,4100000,'OTROS INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(102,NULL,4120101,5,2,4120100,'Intereses Cobrados','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(103,NULL,4120102,5,2,4120100,'Diferencias de cambio','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(104,NULL,4120103,5,2,4120100,'Descuentos obtenidos','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(107,NULL,5000000,1,1,0,'GASTOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(108,NULL,5100000,2,1,5000000,'GASTOS ORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(109,NULL,5110100,4,1,5110000,'ASIENTO DE SUELDO','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(110,NULL,5110101,5,1,5110100,'Sueldos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(111,NULL,5110102,5,1,5110100,'Contribuciones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(112,NULL,5110103,5,1,5110100,'Sindicato','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(113,NULL,5120100,4,1,5120000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(114,NULL,5120101,5,1,5120100,'ACA','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(115,NULL,5120102,5,1,5120100,'Aereos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(116,NULL,5120103,5,1,5120100,'Alquiler','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(117,NULL,5120104,5,1,5120100,'AGUA AYSA','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(118,NULL,5120105,5,1,5120100,'TV Cablevision','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(119,NULL,5120106,5,1,5120100,'Caja Jubilacion Consejo','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(120,NULL,5120107,5,1,5120100,'Celulares','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(121,NULL,5120108,5,1,5120100,'Cheques','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(122,NULL,5120109,5,1,5120100,'Club la Nacion','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(123,NULL,5120110,5,1,5120100,'Comida','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(124,NULL,5120111,5,1,5120100,'Diario Clarin','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(125,NULL,5120112,5,1,5120100,'Digital Ocean','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(126,NULL,5120113,5,1,5120100,'Fletes y acarreos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(127,NULL,5120114,5,1,5120100,'Luz Edesur','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(128,NULL,5120115,5,1,5120100,'Movilidad y Viáticos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(129,NULL,5120116,5,1,5120100,'Mantenimiento','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(130,NULL,5120117,5,1,5120100,'IVA No Computable','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(131,NULL,5120118,5,1,5120100,'Entretenimiento','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(132,NULL,5120119,5,1,5120100,'Amortización Bienes de Uso','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(133,NULL,5120120,5,1,5120100,'Errepar','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(134,NULL,5120121,5,1,5120100,'Hosting Página Web To Webs','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(135,NULL,5120122,5,1,5120100,'Gastos varios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(136,NULL,5120123,5,1,5120100,'Ajuste por redondeo','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(137,NULL,5120124,5,1,5120100,'Deudores Incobrables','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(138,NULL,5120125,5,1,5120100,'Faby Goncalves','Result. Negativo',NULL,0,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (139,NULL,5130100,4,1,5130000,'GASTOS FINANCIEROS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(140,NULL,5130101,5,1,5130100,'Intereses y Gastos bancarios','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(141,NULL,5130102,5,1,5130100,'Intereses Proveedores','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(142,NULL,5130103,5,1,5130100,'Damian Financiera','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(143,NULL,5130104,5,1,5130100,'Diferencias de cambio','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(144,NULL,5130105,5,1,5130100,'Diferencia de Cambio Bces. en M.Extranjera','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(145,NULL,5130106,5,1,5130100,'Diferencia tipo cambio Vendedor/Comprador','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(146,NULL,5130107,5,1,5130100,'Diferencia por conversion en Bce. en Mon. Extranj.','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(147,NULL,5130108,5,1,5130100,'Diferencia de cambio CMV','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(148,NULL,5130109,5,1,5130100,'Diferencia de cambio PT','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(149,NULL,5130110,5,1,5130100,'Resultado por Exposición a la Inflación','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(150,NULL,5130111,5,1,5130100,'Diferencia de cambio PE','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(151,NULL,5130112,5,1,5130100,'Diferencia de cambio Ds.Vtas.','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(152,NULL,5130113,5,1,5130100,'Diferencia de cambio ME','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(153,NULL,5130114,5,1,5130100,'Descuentos otorgados','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(154,NULL,5140100,4,1,5140000,'IMPUESTOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(155,NULL,5140101,5,1,5140100,'Impuesto a las Ganancias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(156,NULL,5140164,5,1,5140100,'Impuesto a los Ingresos Brutos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(157,NULL,5140102,5,1,5140100,'Impuesto al Debito y Credito Bancario','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(158,NULL,5200000,2,1,5000000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(159,NULL,5210101,5,1,5210100,'Pérdida por venta bienes de uso','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(160,NULL,5210102,5,1,5210100,'Inversiones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(161,NULL,5210103,5,1,5210100,'Amortizaciones extraordinarias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(162,NULL,1140103,5,1,1140100,'Retenciones SUSS','Activo',NULL,1,2,1,0,0,1,NULL),(163,NULL,1110122,5,1,1110100,'Banco Patagonia Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(164,NULL,1110106,5,1,1110100,'Banco HSBC','Activo',NULL,0,1,0,0,0,0,NULL),(165,NULL,1110123,5,1,1110100,'Banco Ciudad Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(166,NULL,1110124,5,1,1110100,'Banco Nacion Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(167,NULL,1110109,5,1,1110100,'Banco Galicia Vane','Activo',NULL,0,1,0,0,0,0,NULL),(168,NULL,1110110,5,1,1110100,'Banco Frances Vane','Activo',NULL,0,1,0,0,0,0,NULL),(169,NULL,1110111,5,1,1110100,'Banco Patagonia In Time SRL','Activo',NULL,0,1,0,0,0,0,NULL),(170,NULL,1110112,5,1,1110100,'Banco Ciudad In Time SRL','Activo',NULL,0,1,0,0,0,0,NULL),(171,NULL,1110113,5,1,1110100,'Banco Provincia In Time SRL','Activo',NULL,0,1,0,0,0,0,NULL),(172,NULL,1110114,5,1,1110100,'Banco Macro PedimeOnline','Activo',NULL,0,1,0,0,0,0,NULL),(173,NULL,1110115,5,1,1110100,'Banco Patagonia Problema Resuelto','Activo',NULL,0,1,0,0,0,0,NULL),(174,NULL,1110116,5,1,1110100,'Banco Patagonia Graciela','Activo',NULL,0,1,0,0,0,0,NULL),(175,NULL,1110117,5,1,1110100,'Banco Patagonia Omar','Activo',NULL,0,1,0,0,0,0,NULL),(176,NULL,1110118,5,1,1110100,'Cheques','Activo',NULL,1,2,1,1,1,0,NULL),(177,NULL,5120126,5,1,5120100,'Gisela Larzabal','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(178,NULL,5120127,5,1,5120100,'Google','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(179,NULL,5120128,5,1,5120100,'Seguro Moto','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(180,NULL,5120129,5,1,5120100,'Sueldo Agustina','Result. Negativo',NULL,0,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (181,NULL,5120130,5,1,5120100,'Sueldo Betty','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(182,NULL,5120131,5,1,5120100,'Sueldo Elizabet','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(183,NULL,5120132,5,1,5120100,'Sueldo Florencia','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(184,NULL,5120133,5,1,5120100,'Sueldo Graciela','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(185,NULL,5120134,5,1,5120100,'Sueldo Franco Sanchez','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(186,NULL,5120135,5,1,5120100,'Sueldo Santiago Sanchez','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(187,NULL,5120136,5,1,5120100,'Sueldo Jose Luis','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(188,NULL,5120137,5,1,5120100,'Publicidad','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(189,NULL,5120138,5,1,5120100,'Las Nieves','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(190,NULL,5120139,5,1,5120100,'Sueldo Lidia','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(191,NULL,5120140,5,1,5120100,'Cargas Sociales','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(192,NULL,5120141,5,1,5120100,'Honorarios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(193,NULL,5120142,5,1,5120100,'Telefono Fijo','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(194,NULL,5120143,5,1,5120100,'ONE DRIVE','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(195,NULL,5120144,5,1,5120100,'OSDE','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(196,NULL,5120145,5,1,5120100,'SAS Constitucion','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(197,NULL,5120146,5,1,5120100,'Seguro de Vida Zurich','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(198,NULL,5120147,5,1,5120100,'Seguros','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(199,NULL,5120148,5,1,5120100,'Internet','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(200,NULL,5120149,5,1,5120100,'Seguro de Retiro Zurich','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(201,NULL,5140165,5,1,5140100,'Monotributo','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(202,NULL,5140104,5,1,5140100,'IVA In Time SRL','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(203,NULL,5140105,5,1,5140100,'Autonomos','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(204,NULL,5140106,5,1,5140100,'Multas Impositivas','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(207,NULL,5120150,5,1,5120100,'Vanesa Gastos','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(208,NULL,5140166,5,1,5140100,'Impuesto a los Ingresos Brutos - BS AS','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(209,NULL,5140107,5,1,5140100,'SIRCREB','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(210,NULL,5140108,5,1,5140100,'Consejo Ciencias Economicas','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(211,NULL,5120152,5,1,5120100,'Albano Andres','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(212,NULL,5120153,5,1,5120100,'Tarjeta Visa','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(213,NULL,5120154,5,1,5120100,'Tarjeta American Express','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(214,NULL,5120155,5,1,5120100,'Tarjeta Mastercard','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(215,NULL,5120156,5,1,5120100,'Tarjeta Shopping','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(216,NULL,5120157,5,1,5120100,'Tarjeta Cencosud','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(217,NULL,5120158,5,1,5120100,'Compras','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(218,NULL,4110106,5,2,4110100,'Ventas No Gravadas','Result. Positivo',NULL,1,2,0,0,0,1,NULL),(219,NULL,6110103,5,1,6110100,'Pagos AFIP','Movimiento',NULL,1,2,0,0,1,1,NULL),(220,NULL,5140167,5,1,5140100,'Perc IVA -RG3337','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(221,NULL,5140109,5,1,5140100,'Imps. Internos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(222,NULL,5140110,5,1,5140100,'Imp. Gasoil','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(223,NULL,5140111,5,1,5140100,'Imp. Hídricos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(224,NULL,5140112,5,1,5140100,'ITC','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(225,NULL,5140113,5,1,5140100,'Perc IIBB  Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(226,NULL,5140114,5,1,5140100,'Perc IIBB  Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (227,NULL,5140115,5,1,5140100,'Perc IIBB  Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(228,NULL,5140116,5,1,5140100,'Perc IIBB  Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(229,NULL,5140117,5,1,5140100,'Perc IIBB  Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(230,NULL,5140118,5,1,5140100,'Perc IIBB  Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(231,NULL,5140119,5,1,5140100,'Perc IIBB  Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(232,NULL,5140120,5,1,5140100,'Perc IIBB  Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(233,NULL,5140121,5,1,5140100,'Perc IIBB  Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(234,NULL,5140122,5,1,5140100,'Perc IIBB  Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(235,NULL,5140123,5,1,5140100,'Perc IIBB  La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(236,NULL,5140124,5,1,5140100,'Perc IIBB  La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(237,NULL,5140125,5,1,5140100,'Perc IIBB  Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(238,NULL,5140126,5,1,5140100,'Perc IIBB  Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(239,NULL,5140127,5,1,5140100,'Perc IIBB  Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(240,NULL,5140128,5,1,5140100,'Perc IIBB  Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(241,NULL,5140129,5,1,5140100,'Perc IIBB  Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(242,NULL,5140130,5,1,5140100,'Perc IIBB  Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(243,NULL,5140131,5,1,5140100,'Perc IIBB  San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(244,NULL,5140132,5,1,5140100,'Perc IIBB  San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(245,NULL,5140133,5,1,5140100,'Perc IIBB  Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(246,NULL,5140134,5,1,5140100,'Perc IIBB  Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(247,NULL,5140135,5,1,5140100,'Perc IIBB  Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(248,NULL,5140136,5,1,5140100,'Perc IIBB  Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(249,NULL,5140137,5,1,5140100,'Perc IIBB  Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(250,NULL,5140138,5,1,5140100,'Compras No Gravadas','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(251,NULL,1140108,5,1,1140100,'Retenciones de IIBB Buenos Aires','Activo',NULL,1,2,1,0,0,1,NULL),(252,NULL,1140109,5,1,1140100,'Retenciones de IIBB Capital Federal','Activo',NULL,1,2,1,0,0,1,NULL),(253,NULL,1140110,5,1,1140100,'Retenciones de IIBB Catamarca','Activo',NULL,1,2,1,0,0,1,NULL),(254,NULL,1140111,5,1,1140100,'Retenciones de IIBB Chaco','Activo',NULL,1,2,1,0,0,1,NULL),(255,NULL,1140112,5,1,1140100,'Retenciones de IIBB Chubut','Activo',NULL,1,2,1,0,0,1,NULL),(256,NULL,1140113,5,1,1140100,'Retenciones de IIBB Córdoba','Activo',NULL,1,2,1,0,0,1,NULL),(257,NULL,1140114,5,1,1140100,'Retenciones de IIBB Corrientes','Activo',NULL,1,2,1,0,0,1,NULL),(258,NULL,1140115,5,1,1140100,'Retenciones de IIBB Entre Ríos','Activo',NULL,1,2,1,0,0,1,NULL),(259,NULL,1140116,5,1,1140100,'Retenciones de IIBB Formosa','Activo',NULL,1,2,1,0,0,1,NULL),(260,NULL,1140117,5,1,1140100,'Retenciones de IIBB Jujuy','Activo',NULL,1,2,1,0,0,1,NULL),(261,NULL,1140118,5,1,1140100,'Retenciones de IIBB La Pampa','Activo',NULL,1,2,1,0,0,1,NULL),(262,NULL,1140119,5,1,1140100,'Retenciones de IIBB La Rioja','Activo',NULL,1,2,1,0,0,1,NULL),(263,NULL,1140120,5,1,1140100,'Retenciones de IIBB Mendoza','Activo',NULL,1,2,1,0,0,1,NULL),(264,NULL,1140121,5,1,1140100,'Retenciones de IIBB Misiones','Activo',NULL,1,2,1,0,0,1,NULL),(265,NULL,1140122,5,1,1140100,'Retenciones de IIBB Neuquén','Activo',NULL,1,2,1,0,0,1,NULL),(266,NULL,1140123,5,1,1140100,'Retenciones de IIBB Pascua Lama','Activo',NULL,1,2,1,0,0,1,NULL),(267,NULL,1140124,5,1,1140100,'Retenciones de IIBB Río Negro','Activo',NULL,1,2,1,0,0,1,NULL),(268,NULL,1140125,5,1,1140100,'Retenciones de IIBB Salta','Activo',NULL,1,2,1,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (269,NULL,1140126,5,1,1140100,'Retenciones de IIBB San Juan','Activo',NULL,1,2,1,0,0,1,NULL),(270,NULL,1140127,5,1,1140100,'Retenciones de IIBB San Luis','Activo',NULL,1,2,1,0,0,1,NULL),(271,NULL,1140128,5,1,1140100,'Retenciones de IIBB Santa Cruz','Activo',NULL,1,2,1,0,0,1,NULL),(272,NULL,1140129,5,1,1140100,'Retenciones de IIBB Santa Fe','Activo',NULL,1,2,1,0,0,1,NULL),(273,NULL,1140130,5,1,1140100,'Retenciones de IIBB Santiago del Estero','Activo',NULL,1,2,1,0,0,1,NULL),(274,NULL,1140131,5,1,1140100,'Retenciones de IIBB Tierra del Fuego','Activo',NULL,1,2,1,0,0,1,NULL),(275,NULL,1140132,5,1,1140100,'Retenciones de IIBB Tucuman','Activo',NULL,1,2,1,0,0,1,NULL),(276,NULL,5140168,5,1,5140100,'SIRCREB Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(277,NULL,5140139,5,1,5140100,'SIRCREB Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(278,NULL,5140140,5,1,5140100,'SIRCREB Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(279,NULL,5140141,5,1,5140100,'SIRCREB Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(280,NULL,5140142,5,1,5140100,'SIRCREB Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(281,NULL,5140143,5,1,5140100,'SIRCREB Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(282,NULL,5140144,5,1,5140100,'SIRCREB Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(283,NULL,5140145,5,1,5140100,'SIRCREB Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(284,NULL,5140146,5,1,5140100,'SIRCREB Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(285,NULL,5140147,5,1,5140100,'SIRCREB Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(286,NULL,5140148,5,1,5140100,'SIRCREB La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(287,NULL,5140149,5,1,5140100,'SIRCREB La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(288,NULL,5140150,5,1,5140100,'SIRCREB Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(289,NULL,5140151,5,1,5140100,'SIRCREB Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(290,NULL,5140152,5,1,5140100,'SIRCREB Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(291,NULL,5140153,5,1,5140100,'SIRCREB Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(292,NULL,5140154,5,1,5140100,'SIRCREB Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(293,NULL,5140155,5,1,5140100,'SIRCREB Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(294,NULL,5140156,5,1,5140100,'SIRCREB San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(295,NULL,5140157,5,1,5140100,'SIRCREB San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(296,NULL,5140158,5,1,5140100,'SIRCREB Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(297,NULL,5140159,5,1,5140100,'SIRCREB Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(298,NULL,5140160,5,1,5140100,'SIRCREB Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(299,NULL,5140161,5,1,5140100,'SIRCREB Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(300,NULL,5140162,5,1,5140100,'SIRCREB Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(301,NULL,1140326,5,1,1140300,'IIBB a Favor Buenos Aires','Activo',NULL,1,2,0,0,0,1,NULL),(302,NULL,1140302,5,1,1140300,'IIBB a Favor Capital Federal','Activo',NULL,1,2,0,0,0,1,NULL),(303,NULL,1140303,5,1,1140300,'IIBB a Favor Catamarca','Activo',NULL,1,2,0,0,0,1,NULL),(304,NULL,1140304,5,1,1140300,'IIBB a Favor Chaco','Activo',NULL,1,2,0,0,0,1,NULL),(305,NULL,1140305,5,1,1140300,'IIBB a Favor Chubut','Activo',NULL,1,2,0,0,0,1,NULL),(306,NULL,1140306,5,1,1140300,'IIBB a Favor Córdoba','Activo',NULL,1,2,0,0,0,1,NULL),(307,NULL,1140307,5,1,1140300,'IIBB a Favor Corrientes','Activo',NULL,1,2,0,0,0,1,NULL),(308,NULL,1140308,5,1,1140300,'IIBB a Favor Entre Ríos','Activo',NULL,1,2,0,0,0,1,NULL),(309,NULL,1140309,5,1,1140300,'IIBB a Favor Formosa','Activo',NULL,1,2,0,0,0,1,NULL),(310,NULL,1140310,5,1,1140300,'IIBB a Favor Jujuy','Activo',NULL,1,2,0,0,0,1,NULL),(311,NULL,1140311,5,1,1140300,'IIBB a Favor La Pampa','Activo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (312,NULL,1140312,5,1,1140300,'IIBB a Favor La Rioja','Activo',NULL,1,2,0,0,0,1,NULL),(313,NULL,1140313,5,1,1140300,'IIBB a Favor Mendoza','Activo',NULL,1,2,0,0,0,1,NULL),(314,NULL,1140314,5,1,1140300,'IIBB a Favor Misiones','Activo',NULL,1,2,0,0,0,1,NULL),(315,NULL,1140315,5,1,1140300,'IIBB a Favor Neuquén','Activo',NULL,1,2,0,0,0,1,NULL),(316,NULL,1140316,5,1,1140300,'IIBB a Favor Pascua Lama','Activo',NULL,1,2,0,0,0,1,NULL),(317,NULL,1140317,5,1,1140300,'IIBB a Favor Río Negro','Activo',NULL,1,2,0,0,0,1,NULL),(318,NULL,1140318,5,1,1140300,'IIBB a Favor Salta','Activo',NULL,1,2,0,0,0,1,NULL),(319,NULL,1140319,5,1,1140300,'IIBB a Favor San Juan','Activo',NULL,1,2,0,0,0,1,NULL),(320,NULL,1140320,5,1,1140300,'IIBB a Favor San Luis','Activo',NULL,1,2,0,0,0,1,NULL),(321,NULL,1140321,5,1,1140300,'IIBB a Favor Santa Cruz','Activo',NULL,1,2,0,0,0,1,NULL),(322,NULL,1140322,5,1,1140300,'IIBB a Favor Santa Fe','Activo',NULL,1,2,0,0,0,1,NULL),(323,NULL,1140323,5,1,1140300,'IIBB a Favor Santiago del Estero','Activo',NULL,1,2,0,0,0,1,NULL),(324,NULL,1140324,5,1,1140300,'IIBB a Favor Tierra del Fuego','Activo',NULL,1,2,0,0,0,1,NULL),(325,NULL,1140325,5,1,1140300,'IIBB a Favor Tucuman','Activo',NULL,1,2,0,0,0,1,NULL),(326,NULL,2110317,5,2,2110300,'IIBB a Pagar Buenos Aires','Pasivo',NULL,1,2,0,0,0,1,NULL),(327,NULL,2110318,5,2,2110300,'IIBB a Pagar Capital Federal','Pasivo',NULL,1,2,0,0,0,1,NULL),(328,NULL,2110319,5,2,2110300,'IIBB a Pagar Catamarca','Pasivo',NULL,1,2,0,0,0,1,NULL),(329,NULL,2110320,5,2,2110300,'IIBB a Pagar Chaco','Pasivo',NULL,1,2,0,0,0,1,NULL),(330,NULL,2110321,5,2,2110300,'IIBB a Pagar Chubut','Pasivo',NULL,1,2,0,0,0,1,NULL),(331,NULL,2110322,5,2,2110300,'IIBB a Pagar Córdoba','Pasivo',NULL,1,2,0,0,0,1,NULL),(332,NULL,2110323,5,2,2110300,'IIBB a Pagar Corrientes','Pasivo',NULL,1,2,0,0,0,1,NULL),(333,NULL,2110324,5,2,2110300,'IIBB a Pagar Entre Ríos','Pasivo',NULL,1,2,0,0,0,1,NULL),(334,NULL,2110325,5,2,2110300,'IIBB a Pagar Formosa','Pasivo',NULL,1,2,0,0,0,1,NULL),(335,NULL,2110326,5,2,2110300,'IIBB a Pagar Jujuy','Pasivo',NULL,1,2,0,0,0,1,NULL),(336,NULL,2110327,5,2,2110300,'IIBB a Pagar La Pampa','Pasivo',NULL,1,2,0,0,0,1,NULL),(337,NULL,2110328,5,2,2110300,'IIBB a Pagar La Rioja','Pasivo',NULL,1,2,0,0,0,1,NULL),(338,NULL,2110329,5,2,2110300,'IIBB a Pagar Mendoza','Pasivo',NULL,1,2,0,0,0,1,NULL),(339,NULL,2110330,5,2,2110300,'IIBB a Pagar Misiones','Pasivo',NULL,1,2,0,0,0,1,NULL),(340,NULL,2110331,5,2,2110300,'IIBB a Pagar Neuquén','Pasivo',NULL,1,2,0,0,0,1,NULL),(341,NULL,2110332,5,2,2110300,'IIBB a Pagar Pascua Lama','Pasivo',NULL,1,2,0,0,0,1,NULL),(342,NULL,2110333,5,2,2110300,'IIBB a Pagar Río Negro','Pasivo',NULL,1,2,0,0,0,1,NULL),(343,NULL,2110334,5,2,2110300,'IIBB a Pagar Salta','Pasivo',NULL,1,2,0,0,0,1,NULL),(344,NULL,2110335,5,2,2110300,'IIBB a Pagar San Juan','Pasivo',NULL,1,2,0,0,0,1,NULL),(345,NULL,2110336,5,2,2110300,'IIBB a Pagar San Luis','Pasivo',NULL,1,2,0,0,0,1,NULL),(346,NULL,2110337,5,2,2110300,'IIBB a Pagar Santa Cruz','Pasivo',NULL,1,2,0,0,0,1,NULL),(347,NULL,2110338,5,2,2110300,'IIBB a Pagar Santa Fe','Pasivo',NULL,1,2,0,0,0,1,NULL),(348,NULL,2110339,5,2,2110300,'IIBB a Pagar Santiago del Estero','Pasivo',NULL,1,2,0,0,0,1,NULL),(349,NULL,2110340,5,2,2110300,'IIBB a Pagar Tierra del Fuego','Pasivo',NULL,1,2,0,0,0,1,NULL),(350,NULL,2110341,5,2,2110300,'IIBB a Pagar Tucuman','Pasivo',NULL,1,2,0,0,0,1,NULL),(351,NULL,6110101,5,1,6110100,'BANCO SIRCREB','Movimiento',NULL,1,2,0,0,1,1,NULL),(352,NULL,6110102,5,1,6110100,'Compensacion','Movimiento',NULL,1,2,0,0,0,1,NULL),(353,NULL,1140327,5,1,1140300,'IVA Saldo Tecnico','Activo',NULL,1,2,0,0,0,1,NULL),(354,NULL,1140328,5,1,1140300,'IVA Saldo Libre Disponibilidad','Activo',NULL,1,2,0,0,0,1,NULL),(355,NULL,6000000,1,1,0,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(356,NULL,6100000,2,1,6000000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(357,NULL,6110000,3,1,6100000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (358,NULL,4110000,3,2,4100000,'Ingresos Operativos','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(359,NULL,1110120,5,1,1110100,'Caja en Pesos','Activo',NULL,1,2,1,1,1,0,NULL),(360,NULL,1140211,5,1,1140200,'Retenciones Bancarias de Ganancias a Favor','Activo',NULL,1,2,0,0,1,1,NULL),(361,NULL,1220104,5,1,1220100,'Equipos de Computación','Activo',NULL,1,1,0,0,0,1,NULL),(362,NULL,1220105,5,1,1220100,'Computadoras','Activo',NULL,1,1,0,0,0,1,NULL),(363,NULL,1220304,5,1,1220300,'Muebles y Utiles','Activo',NULL,1,1,0,0,0,1,NULL),(364,NULL,2110105,5,2,2110100,'Anticipo de Clientes','Pasivo',NULL,1,2,0,0,1,1,NULL),(365,NULL,2110401,5,2,2110400,'Provision Honorarios','Pasivo',NULL,1,1,0,0,0,1,NULL),(366,NULL,2110106,5,2,2110100,'Cta. Cte Directores','Pasivo',NULL,1,1,0,0,0,1,NULL),(367,NULL,2110107,5,2,2110100,'Provisión Honorarios Directores','Pasivo',NULL,1,1,0,0,0,1,NULL),(368,NULL,2110110,5,2,2110100,'Cuenta Particular Socio 1','Pasivo',NULL,1,1,0,0,0,1,NULL),(369,NULL,3110104,5,2,3110100,'Capital','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(370,NULL,1120000,3,1,1100000,'INVERSIONES','Activo',NULL,1,1,0,0,0,0,NULL),(371,NULL,1160000,3,1,1100000,'OTROS ACTIVOS','Activo',NULL,1,1,0,0,0,0,NULL),(372,NULL,1160100,4,1,1160000,'OTROS','Activo',NULL,1,1,0,0,0,0,NULL),(373,NULL,2110400,4,2,2110000,'Provision de Honorarios','Pasivo',NULL,1,1,0,0,0,0,NULL),(374,NULL,3410100,4,1,3410000,'RESULTADOS ACUMULADOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(375,NULL,3420000,3,1,3400000,'GANACIAS RESERVADAS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(376,NULL,3420100,4,1,3420000,'Rerva Legal','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(377,NULL,1220400,4,1,1220000,'INMUEBLES','Activo',NULL,1,1,0,0,0,0,NULL),(378,NULL,1220500,4,1,1220000,'RODADOS','Activo',NULL,1,1,0,0,0,0,NULL),(379,NULL,1220600,4,1,1220000,'MAQUINARIAS','Activo',NULL,1,1,0,0,0,0,NULL),(380,NULL,1220204,5,1,1220200,'Instalaciones','Activo',NULL,1,1,0,0,0,1,NULL),(381,NULL,3420101,5,2,3420100,'Reserva Legal','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(382,NULL,3420102,5,2,3420100,'Reserva Legal','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(383,NULL,3410105,5,2,3410100,'Resultado no asignado','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(384,NULL,1110121,5,1,1110100,'Caja en Dolares','Activo',NULL,1,2,1,1,1,0,NULL),(385,NULL,1120100,4,1,1120000,'TEMPORARIAS','Activo',NULL,1,1,0,0,0,0,NULL),(386,NULL,1120101,5,1,1120100,'PLAZO FIJO','Activo',NULL,1,1,0,0,0,1,NULL),(387,NULL,1120200,4,1,1120000,'PERMANENTES','Activo',NULL,1,1,0,0,0,0,NULL),(388,NULL,1120201,5,1,1120200,'ACCIONES','Activo',NULL,1,1,0,0,0,1,NULL),(389,NULL,1220401,5,1,1220400,'Inmuebles','Activo',NULL,1,1,0,0,0,1,NULL),(390,NULL,1220501,5,1,1220500,'Vehiculos','Activo',NULL,1,1,0,0,0,1,NULL),(391,NULL,1220601,5,1,1220600,'Maquinarias','Activo',NULL,1,1,0,0,0,1,NULL),(392,NULL,1150401,5,1,1150400,'MERCADERIAS','Activo',NULL,1,1,0,0,0,1,NULL),(393,NULL,1160101,5,1,1160100,'OTROS','Activo',NULL,1,1,0,0,0,1,NULL),(394,NULL,1230100,4,1,1230000,'INTANGIBLES','Activo',NULL,1,1,0,0,0,0,NULL),(395,NULL,2110119,5,2,2110100,'Cuenta Particular Socio 2','Pasivo',NULL,1,1,0,0,0,1,NULL),(396,NULL,5120160,5,1,5120100,'Comisiones Y gastos Bancarios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(397,NULL,4110100,4,2,4110000,'Ingresos Operativos','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(398,NULL,4120100,4,2,4120000,'OTROS INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(399,NULL,5110000,3,1,5100000,'GASTOS ORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(400,NULL,5120000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(401,NULL,5130000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(402,NULL,5140000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(403,NULL,5210000,3,1,5200000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(404,NULL,5210100,4,1,5210000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (405,NULL,6110100,4,1,6110000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(406,NULL,1130100,4,1,1130000,'Operaciones Ordinarias','Activo',NULL,1,1,0,0,0,0,NULL),(407,NULL,3110000,3,2,3100000,'CAPITAL SOCIAL','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(408,NULL,3410000,3,2,3400000,'RESULTADOS ANTERIORES','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(409,NULL,5110101,5,2,5110000,'IVA Crédito Fiscal No computable','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(410,NULL,1110203,5,1,1110200,'Banco ICBC Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(411,NULL,2110342,5,2,2110300,'Provisión Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(412,NULL,5120107,5,2,5120000,'Amortización Muebles y Útiles','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(413,NULL,5120102,5,2,5120000,'Amortización Equipos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(414,NULL,1220109,5,1,1220100,'Amortizacion Acumulada Equipos','Activo',NULL,1,1,0,0,0,1,NULL),(415,NULL,1220602,5,1,1220600,'Amortización Acumulada Maquinarias','Activo',NULL,1,1,0,0,0,1,NULL),(416,NULL,1160102,5,1,1160100,'Materias Primas','Activo',NULL,1,1,0,0,0,1,NULL),(417,NULL,1110204,5,1,1110200,'Banco Itaú Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(418,NULL,2110113,5,2,2110100,'Deudas Bancarias','Pasivo',NULL,1,2,0,1,1,1,NULL),(419,NULL,1220502,5,1,1220500,'Rodados','Activo',NULL,1,1,0,0,0,1,NULL),(420,NULL,1220503,5,1,1220500,'Amortización Acumulada Rodados','Activo',NULL,1,1,0,0,0,1,NULL),(421,NULL,5120105,5,2,5120000,'Amortización Rodados','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(422,NULL,5120109,5,2,5120000,'Amortización Maquinarias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(423,NULL,1220504,5,1,1220500,'Accesorios','Activo',NULL,1,1,0,0,0,1,NULL),(424,NULL,1220505,5,1,1220500,'Amortización Acumulada Accesorios','Activo',NULL,1,1,0,0,0,1,NULL),(425,NULL,1110205,5,1,1110200,'Banco Galicia Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(426,NULL,3420101,5,2,3420000,'Reserva Facultativa','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(427,NULL,1140212,5,1,1140200,'Créditos por Impuestos Diferidos','Activo',NULL,1,1,0,0,0,1,NULL),(428,NULL,1160103,5,1,1160100,'Fondo de Comercio','Activo',NULL,1,1,0,0,0,1,NULL),(429,NULL,1160104,5,1,1160100,'Amortizacion Acumulada Fondo de Comercio','Activo',NULL,1,1,0,0,0,1,NULL),(430,NULL,1140213,5,1,1140200,'Intereses a devengar AGIP','Activo',NULL,1,1,0,0,0,1,NULL),(431,NULL,2110343,5,2,2110300,'PFP IIBB','Pasivo',NULL,1,1,0,0,0,1,NULL),(432,NULL,1140330,5,1,1140300,'Pago a Cuenta ITC','Activo',NULL,1,2,0,0,0,1,NULL),(433,NULL,2110114,5,2,2110100,'Préstamo','Pasivo',NULL,1,2,0,1,1,1,NULL),(434,NULL,1160106,5,1,1160100,'Productos','Activo',NULL,1,1,0,0,0,1,NULL),(435,NULL,2110345,5,2,2110300,'Intereses a devengar PFP','Pasivo',NULL,1,1,0,0,0,1,NULL),(436,NULL,1110206,5,1,1110200,'Banco Provincia Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(437,NULL,1140215,5,1,1140200,'Imp. Ley 25413 Cred 0.6%','Activo',NULL,1,1,0,0,0,1,NULL),(438,NULL,2110402,5,2,2110400,'Honorarios Directorio a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(439,NULL,3110101,5,2,3110100,'Reserva para Futuras Inversiones','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(440,NULL,1130106,5,1,1130100,'TEAC - Trabajos Ejecutados a Certificar','Activo',NULL,1,1,0,0,0,1,NULL),(441,NULL,2110115,5,2,2110100,'Leasing','Pasivo',NULL,1,2,0,1,1,1,NULL),(442,NULL,1110207,5,1,1110200,'Banco Comafi Cta. Cte','Activo',NULL,1,2,1,1,1,0,NULL),(443,NULL,2110500,4,2,2110000,'Deudas Financieras','Pasivo',NULL,1,1,0,0,0,0,NULL),(444,NULL,2110501,5,2,2110500,'Banco Santander Rio Cta Cte','Pasivo',NULL,1,1,0,0,0,1,NULL),(446,NULL,2210000,3,2,2200000,'Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(447,NULL,2210100,4,2,2210000,'Otras Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(448,NULL,2210101,5,2,2210100,'Planes de Pagos AFIP','Pasivo',NULL,1,2,0,1,1,1,NULL),(449,NULL,2110502,5,2,2110500,'Leasing','Pasivo',NULL,1,1,0,0,0,1,NULL),(450,NULL,6110101,5,1,6110000,'Cheques Rechazados','Movimiento',NULL,1,2,0,0,1,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (451,NULL,1110208,5,1,1110200,'Banco Patagonia Taxes Software','Activo',NULL,1,2,1,1,1,0,NULL),(452,NULL,1110209,5,1,1110200,'Banco Macro Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(453,NULL,1120202,5,1,1120200,'Inversión Central Caribe','Activo',NULL,1,1,0,0,0,1,NULL),(454,NULL,1120102,5,1,1120100,'Otras Inversiones','Activo',NULL,1,1,0,0,0,1,NULL),(455,NULL,1140216,5,1,1140200,'Otros Créditos','Activo',NULL,1,1,0,0,0,1,NULL),(456,NULL,2110403,5,2,2110400,'Provisión Honorarios Socio Gerente','Pasivo',NULL,1,1,0,0,0,1,NULL),(457,NULL,1110210,5,1,1110200,'Cheque Diferido Banco Santander Rio','Activo',NULL,1,2,1,1,1,0,NULL),(458,NULL,1110211,5,1,1110200,'Cheque Diferido Banco Macro','Activo',NULL,1,2,1,1,1,0,NULL),(459,NULL,2110204,5,2,2110200,'Moratoria SUSS a pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(460,NULL,2110344,5,2,2110300,'Impuestos Municipales a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(461,NULL,5110103,5,2,5110000,'Amortización Instalaciones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(462,NULL,5120110,5,2,5120000,'Amortización Equipos de comput.','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(463,NULL,2110118,5,2,2110100,'Cuenta Particular Socio 3','Pasivo',NULL,1,1,0,0,0,1,NULL),(464,NULL,2110120,5,2,2110100,'Cuenta Particular Socio 4','Pasivo',NULL,1,1,0,0,0,1,NULL),(465,NULL,3110102,5,2,3110100,'Otras Reservas','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(466,NULL,1140331,5,1,1140300,'IGMP (Saldo a Favor)','Activo',NULL,1,1,0,0,0,1,NULL),(467,NULL,5110104,5,2,5110000,'Interés','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(468,NULL,1150402,5,1,1150400,'Productos en Proceso','Activo',NULL,1,1,0,0,0,1,NULL),(469,NULL,2110205,5,2,2110200,'Depósitos en Garantía Socio Gerente','Pasivo',NULL,1,1,0,0,0,1,NULL),(470,NULL,2110346,5,2,2110300,'Fondos Embargados','Pasivo',NULL,1,1,0,0,0,1,NULL),(471,NULL,2110347,5,2,2110300,'Cuota Solid.','Pasivo',NULL,1,1,0,0,0,1,NULL),(472,NULL,1140332,5,1,1140300,'Anticipo Honorarios Directores','Activo',NULL,1,1,0,0,0,1,NULL),(473,NULL,2110348,5,2,2110300,'SICORE a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(474,NULL,1110212,5,1,1110200,'Banco Credicoop Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(475,NULL,1110213,5,1,1110200,'Banco Superville Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(476,NULL,5110105,5,2,5110000,'RECPAM','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(477,NULL,1110125,5,1,1110100,'Caja Reales','Activo',NULL,1,2,1,1,1,0,NULL),(478,NULL,5140169,5,1,5140100,'CO2 - Imp. Al Carbono','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(479,NULL,1140300,4,1,1140000,'Anticipo de Impuestos','Activo',NULL,1,1,0,0,0,0,NULL),(480,NULL,2110600,4,2,2110000,'Retenciones Efectuadas','Pasivo',NULL,1,1,0,0,0,0,NULL),(481,NULL,4200000,2,2,4000000,'INGRESOS EXTRAORDINARIOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL);
/*!40000 ALTER TABLE `conta_plan_cuenta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_asientos`
--

DROP TABLE IF EXISTS `conta_tipo_asientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_asientos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `orden` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_asientos`
--

LOCK TABLES `conta_tipo_asientos` WRITE;
/*!40000 ALTER TABLE `conta_tipo_asientos` DISABLE KEYS */;
INSERT INTO `conta_tipo_asientos` VALUES (1,'Sueldos',NULL,NULL,NULL,11),(2,'Ingresos',NULL,NULL,NULL,9),(3,'Egresos',NULL,NULL,NULL,10),(4,'Amortizaciones',NULL,NULL,NULL,4),(5,'Banco',NULL,NULL,NULL,15),(6,'Ganancias',NULL,NULL,NULL,12),(7,'Retenciones',NULL,NULL,NULL,13),(8,'SIRCREB',NULL,NULL,NULL,14),(9,'Compensaciones',NULL,NULL,NULL,16),(10,'Pagos AFIP',NULL,NULL,NULL,17),(11,'Ajustes',NULL,NULL,NULL,3),(12,'Saldos Iniciales',NULL,NULL,NULL,1),(13,'Cancelacion de Iniciales',NULL,NULL,NULL,2),(14,'Patrimonio Neto',NULL,NULL,NULL,8),(15,'Liquidaciones IVA',NULL,NULL,NULL,18),(16,'Liquidacion IIBB',NULL,NULL,NULL,19),(17,'Asientos de Cierre',NULL,NULL,NULL,5),(18,'Reclasificacion',NULL,NULL,NULL,6),(19,'Otros',NULL,NULL,NULL,7),(20,'Cobranzas','2019-10-02 03:20:37','2019-10-02 03:20:37',NULL,NULL),(21,'Pagos','2019-10-02 03:20:37','2019-10-02 03:20:37',NULL,NULL),(22,'Tesoreria','2019-10-19 02:10:24','2019-10-19 02:10:24',NULL,NULL),(23,'Ajuste por Inflacion','2020-03-01 06:39:20','2020-03-01 06:39:20',NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_asientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_cuentas`
--

DROP TABLE IF EXISTS `conta_tipo_cuentas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_cuentas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo_cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_cuentas`
--

LOCK TABLES `conta_tipo_cuentas` WRITE;
/*!40000 ALTER TABLE `conta_tipo_cuentas` DISABLE KEYS */;
INSERT INTO `conta_tipo_cuentas` VALUES (1,'Rubro',NULL,NULL,NULL),(2,'SubRubro',NULL,NULL,NULL),(3,'Grupo',NULL,NULL,NULL),(4,'SubGrupo',NULL,NULL,NULL),(5,'Cuenta',NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_cuentas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_saldos`
--

DROP TABLE IF EXISTS `conta_tipo_saldos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_saldos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `saldo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_saldos`
--

LOCK TABLES `conta_tipo_saldos` WRITE;
/*!40000 ALTER TABLE `conta_tipo_saldos` DISABLE KEYS */;
INSERT INTO `conta_tipo_saldos` VALUES (1,'Deudor',NULL,NULL,NULL),(2,'Acreedor',NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_saldos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `control_cuits_afip`
--

DROP TABLE IF EXISTS `control_cuits_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `control_cuits_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `field_name1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuit` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `error` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `control_cuits_afip_person_id_foreign` (`person_id`),
  CONSTRAINT `control_cuits_afip_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `control_cuits_afip`
--

LOCK TABLES `control_cuits_afip` WRITE;
/*!40000 ALTER TABLE `control_cuits_afip` DISABLE KEYS */;
/*!40000 ALTER TABLE `control_cuits_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `control_general`
--

DROP TABLE IF EXISTS `control_general`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `control_general` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `control_general_description_unique` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `control_general`
--

LOCK TABLES `control_general` WRITE;
/*!40000 ALTER TABLE `control_general` DISABLE KEYS */;
INSERT INTO `control_general` VALUES (1,'Ingresos - Egresos - Resultado',1,'Proyeccion Ganancias','control_general/proyecGanancias',NULL,NULL),(2,'IVA',2,'IVA','control_general/iva',NULL,NULL),(3,'IIBB',3,'IIBB','control_general/iibb',NULL,NULL),(4,'Por Mes',4,'Vto. Impuestos','control_general/vto',NULL,NULL),(5,'Por Impuesto',4,'Vto. Impuestos','control_general/vtoPorImpuestos',NULL,NULL);
/*!40000 ALTER TABLE `control_general` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente`
--

DROP TABLE IF EXISTS `cta_cte_cliente`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `compensado` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_cliente_person_id_foreign` (`person_id`),
  KEY `cta_cte_cliente_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `cta_cte_cliente_period_id_foreign` (`period_id`),
  KEY `cta_cte_cliente_saldo_id_foreign` (`saldo_id`),
  KEY `cta_cte_cliente_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `cta_cte_cliente_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `cta_cte_cliente_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_cliente_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_cliente_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `cta_cte_cliente_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente`
--

LOCK TABLES `cta_cte_cliente` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente` DISABLE KEYS */;
INSERT INTO `cta_cte_cliente` VALUES (1,2271,2,40719,40724,13,9,1,0,'2021-07-15',3500.00,'Factura C N°: 0000-00000000',NULL,'2021-07-15 23:10:55','2021-07-15 23:11:05','2021-07-15 23:11:05'),(2,2271,2,40719,40727,13,8,1,0,'2021-06-01',2000.00,'Factura C N°: 0000-00000000',NULL,'2021-07-23 00:43:13','2021-07-23 00:43:13',NULL),(3,2271,2,40719,40727,13,8,1,0,'2021-06-01',1500.00,'Factura C N°: 0003-00000000',NULL,'2021-07-23 01:05:37','2021-07-23 01:05:37',NULL),(4,2271,2,40719,40727,13,8,1,0,'2021-06-01',1500.00,'Factura C N°: 0003-00000000',NULL,'2021-07-23 01:06:24','2021-07-23 01:06:24',NULL),(5,2271,2,40719,40727,13,8,1,0,'2021-06-01',1500.00,'Factura C N°: 0003-00000000',NULL,'2021-07-23 01:14:59','2021-07-23 01:14:59',NULL);
/*!40000 ALTER TABLE `cta_cte_cliente` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente_details`
--

DROP TABLE IF EXISTS `cta_cte_cliente_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_cliente_details_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_cliente_details_person_id_foreign` (`person_id`),
  KEY `cta_cte_cliente_details_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `cta_cte_cliente_details_period_id_foreign` (`period_id`),
  KEY `cta_cte_cliente_details_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `cta_cte_cliente_details_saldo_id_foreign` (`saldo_id`),
  KEY `cta_cte_cliente_details_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `cta_cte_cliente_details_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `cta_cte_cliente_details_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_cliente_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_cliente_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_details_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `cta_cte_cliente_details_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente_details`
--

LOCK TABLES `cta_cte_cliente_details` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_cliente_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente_pivot_receipt`
--

DROP TABLE IF EXISTS `cta_cte_cliente_pivot_receipt`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente_pivot_receipt` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cta_cte_cliente_id` int(10) unsigned NOT NULL,
  `receipt_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente_pivot_receipt`
--

LOCK TABLES `cta_cte_cliente_pivot_receipt` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente_pivot_receipt` DISABLE KEYS */;
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (1,2,2,NULL,NULL,NULL),(2,3,3,NULL,NULL,NULL),(3,4,4,NULL,NULL,NULL),(4,5,5,NULL,NULL,NULL);
/*!40000 ALTER TABLE `cta_cte_cliente_pivot_receipt` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL,
  `fecha` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_tesoreria_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_period_id_foreign` (`period_id`),
  KEY `cta_cte_tesoreria_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  CONSTRAINT `cta_cte_tesoreria_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `cta_cte_tesoreria_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_tesoreria_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria`
--

LOCK TABLES `cta_cte_tesoreria` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_cuentas`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_cuentas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_cuentas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cheque3ros` tinyint(1) NOT NULL DEFAULT '0',
  `cheque_emitidos` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cta_cte` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_origen` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_destino` tinyint(1) NOT NULL DEFAULT '0',
  `conta_asientos` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_cuentas_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_cuentas_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=757 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_cuentas`
--

LOCK TABLES `cta_cte_tesoreria_cuentas` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuentas` DISABLE KEYS */;
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (13,NULL,13,NULL,'Clientes - Deudores',0,0,0,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(20,NULL,20,NULL,'Anticipos Impuesto a las Ganancias',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(23,NULL,23,NULL,'Retenciones Impuesto a las Ganancias',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(25,NULL,25,NULL,'Retenciones de IVA',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(57,NULL,57,NULL,'Proveedores en Cta. Cte. locales',0,0,0,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(60,NULL,60,NULL,'Cheques emitidos ',0,1,1,1,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(62,NULL,62,NULL,'Sueldos y Jornales a pagar',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(140,NULL,140,NULL,'Intereses y Gastos bancarios',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(162,NULL,162,NULL,'Retenciones SUSS',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(176,NULL,176,NULL,'Cheques en Cartera',1,0,1,1,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(201,NULL,201,NULL,'Monotributo',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(203,NULL,203,NULL,'Autonomos',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(219,NULL,219,NULL,'Pagos AFIP',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(251,NULL,251,NULL,'Retenciones de IIBB Buenos Aires',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(252,NULL,252,NULL,'Retenciones de IIBB Capital Federal',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(253,NULL,253,NULL,'Retenciones de IIBB Catamarca',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(254,NULL,254,NULL,'Retenciones de IIBB Chaco',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(255,NULL,255,NULL,'Retenciones de IIBB Chubut',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(256,NULL,256,NULL,'Retenciones de IIBB Córdoba',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(257,NULL,257,NULL,'Retenciones de IIBB Corrientes',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(258,NULL,258,NULL,'Retenciones de IIBB Entre Ríos',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(259,NULL,259,NULL,'Retenciones de IIBB Formosa',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(260,NULL,260,NULL,'Retenciones de IIBB Jujuy',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(261,NULL,261,NULL,'Retenciones de IIBB La Pampa',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(262,NULL,262,NULL,'Retenciones de IIBB La Rioja',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(263,NULL,263,NULL,'Retenciones de IIBB Mendoza',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(264,NULL,264,NULL,'Retenciones de IIBB Misiones',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(265,NULL,265,NULL,'Retenciones de IIBB Neuquén',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(266,NULL,266,NULL,'Retenciones de IIBB Pascua Lama',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(267,NULL,267,NULL,'Retenciones de IIBB Río Negro',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(268,NULL,268,NULL,'Retenciones de IIBB Salta',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(269,NULL,269,NULL,'Retenciones de IIBB San Juan',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(270,NULL,270,NULL,'Retenciones de IIBB San Luis',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(271,NULL,271,NULL,'Retenciones de IIBB Santa Cruz',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(272,NULL,272,NULL,'Retenciones de IIBB Santa Fe',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(273,NULL,273,NULL,'Retenciones de IIBB Santiago del Estero',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (274,NULL,274,NULL,'Retenciones de IIBB Tierra del Fuego',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(275,NULL,275,NULL,'Retenciones de IIBB Tucuman',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(351,NULL,351,NULL,'BANCO SIRCREB',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(359,NULL,359,NULL,'Caja en Pesos',0,0,1,1,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(360,NULL,360,NULL,'Retenciones Bancarias de Ganancias a Favor',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(364,NULL,364,NULL,'Anticipo de Clientes',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(384,NULL,384,NULL,'Caja en Dolares',0,0,1,1,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(409,NULL,409,NULL,'IVA Crédito Fiscal No computable',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(418,NULL,418,NULL,'Deudas Bancarias',0,0,0,1,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(433,NULL,433,NULL,'Préstamo',0,0,0,1,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(441,NULL,441,NULL,'Leasing',0,0,0,1,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(448,NULL,448,NULL,'Planes de Pagos AFIP',0,0,0,1,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(450,NULL,450,NULL,'Cheques Rechazados',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(467,NULL,467,NULL,'Interés',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(468,0,14,NULL,'Deudores por ventas comunes',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(469,0,15,NULL,'Deudores por ventas morosos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(470,0,16,NULL,'Deudores en gestión judicial',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(471,0,17,NULL,'Previsión deudores incobrables',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(472,0,22,NULL,'Anticipo Impto.Ganancia Mínima Presunta',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(473,0,24,NULL,'Impuesto a las Ganancias (Saldo a favor)',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(474,0,27,NULL,'Anticipos de proveedores',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(475,0,28,NULL,'Depósito en garantía alquileres',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(476,0,29,NULL,'Derechos adquiridos a devengar',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(477,0,30,NULL,'Intereses a devengar',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(478,0,31,NULL,'Cuentas a rendir - Directores',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(479,0,32,NULL,'Alquileres no devengados',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(480,0,38,NULL,'Equipos de computación valores históricos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(481,0,39,NULL,'Equipos de computación ajuste',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(482,0,40,NULL,'Amortización Acumulada Equipos de comput.',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(483,0,42,NULL,'Instalaciones valores históricos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(484,0,43,NULL,'Instalaciones ajuste',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(485,0,44,NULL,'Amortización Acumulada Instalaciones',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(486,0,46,NULL,'Muebles y utiles valores históricos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(487,0,47,NULL,'Muebles y utiles ajuste',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(488,0,48,NULL,'Amortización Acumulada Muebles y Útiles',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(489,0,50,NULL,'Gastos de organización valores historicos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (490,0,51,NULL,'Gastos de organización ajuste',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(491,0,52,NULL,'Amortización acumulada gs. de organización',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(492,0,58,NULL,'Proveedores en cta. cte. exterior',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(493,0,59,NULL,'Derechos de exhibición a devengar',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(494,0,63,NULL,'Cargas sociales a pagar',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(495,0,64,NULL,'Sindicatos a Pagar',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(496,0,67,NULL,'IVA Debito Fiscal',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(497,0,68,NULL,'IVA Credito Fiscal',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(498,0,69,NULL,'Impuestos Internos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(499,0,70,NULL,'Impuestos al Combustible',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(500,0,71,NULL,'IVA Retenciones de terceros',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(501,0,72,NULL,'IVA Percepciones realiz.por terceros',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(502,0,73,NULL,'IVA Saldo a favor',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(503,0,74,NULL,'IVA a pagar',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(504,0,75,NULL,'Percepciones Ingresos Brutos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(505,0,76,NULL,'Otros Pagos AFIP',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(506,0,78,NULL,'Impuesto a los Ingresos Brutos Pasivo',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(507,0,79,NULL,'Impuesto a las Ganancias',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(508,0,80,NULL,'Impuesto a la Ganancia Mínima Presunta',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(509,0,81,NULL,'AFIP - Retenciones Impuesto a las Ganancias',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(510,0,82,NULL,'AFIP - Plan de Facilidades Decreto 338/02',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(511,0,87,NULL,'Acciones en circulación',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(512,0,88,NULL,'Ajuste del Capital',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(513,0,89,NULL,'Aportes Irrevocables Futuras Suscripciones',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(514,0,91,NULL,'Resultado del ejercicio',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(515,0,92,NULL,'Resultado ejercicios anteriores',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(516,0,93,NULL,'A.R.E.A.',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(517,0,96,NULL,'VENTAS',0,0,0,0,1,1,'2020-02-06 17:23:07','2021-01-14 21:13:00',NULL),(518,0,97,NULL,'Honorarios',0,0,0,0,1,1,'2020-02-06 17:23:07','2021-01-14 21:13:00',NULL),(519,0,99,NULL,'Descuentos obtenidos',0,0,0,0,1,1,'2020-02-06 17:23:07','2021-01-14 21:13:00',NULL),(520,0,100,NULL,'Reintegros por exportaciones',0,0,0,0,1,1,'2020-02-06 17:23:07','2021-01-14 21:13:00',NULL),(521,0,102,NULL,'Intereses Cobrados',0,0,0,0,1,1,'2020-02-06 17:23:07','2021-01-14 21:13:00',NULL),(522,0,103,NULL,'Diferencias de cambio',0,0,0,0,1,1,'2020-02-06 17:23:07','2021-01-14 21:13:00',NULL),(523,0,104,NULL,'Descuentos obtenidos',0,0,0,0,1,1,'2020-02-06 17:23:07','2021-01-14 21:13:00',NULL),(524,0,110,NULL,'Sueldos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(525,0,111,NULL,'Contribuciones',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(526,0,112,NULL,'Sindicato',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(527,0,114,NULL,'ACA',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (528,0,115,NULL,'Aereos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(529,0,116,NULL,'Alquiler',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(530,0,117,NULL,'AGUA AYSA',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(531,0,118,NULL,'TV Cablevision',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(532,0,119,NULL,'Caja Jubilacion Consejo',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(533,0,120,NULL,'Celulares',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(534,0,121,NULL,'Cheques',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(535,0,123,NULL,'Comida',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(536,0,126,NULL,'Fletes y acarreos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(537,0,127,NULL,'Luz Edesur',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(538,0,128,NULL,'Movilidad y Viáticos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(539,0,129,NULL,'Mantenimiento',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(540,0,130,NULL,'IVA No Computable',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(541,0,131,NULL,'Entretenimiento',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(542,0,132,NULL,'Amortización Bienes de Uso',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(543,0,135,NULL,'Gastos varios',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(544,0,136,NULL,'Ajuste por redondeo',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(545,0,137,NULL,'Deudores Incobrables',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(546,0,141,NULL,'Intereses Proveedores',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(547,0,143,NULL,'Diferencias de cambio',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(548,0,144,NULL,'Diferencia de Cambio Bces. en M.Extranjera',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(549,0,145,NULL,'Diferencia tipo cambio Vendedor/Comprador',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(550,0,146,NULL,'Diferencia por conversion en Bce. en Mon. Extranj.',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(551,0,147,NULL,'Diferencia de cambio CMV',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(552,0,148,NULL,'Diferencia de cambio PT',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(553,0,149,NULL,'Resultado por Exposición a la Inflación',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(554,0,150,NULL,'Diferencia de cambio PE',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(555,0,151,NULL,'Diferencia de cambio Ds.Vtas.',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(556,0,152,NULL,'Diferencia de cambio ME',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(557,0,153,NULL,'Descuentos otorgados',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(558,0,155,NULL,'Impuesto a las Ganancias',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(559,0,156,NULL,'Impuesto a los Ingresos Brutos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(560,0,157,NULL,'Impuesto al Debito y Credito Bancario',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(561,0,159,NULL,'Pérdida por venta bienes de uso',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(562,0,160,NULL,'Inversiones',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(563,0,161,NULL,'Amortizaciones extraordinarias',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(564,0,178,NULL,'Google',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(565,0,188,NULL,'Publicidad',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(566,0,191,NULL,'Cargas Sociales',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (567,0,192,NULL,'Honorarios',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(568,0,193,NULL,'Telefono Fijo',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(569,0,198,NULL,'Seguros',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(570,0,199,NULL,'Internet',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(571,0,204,NULL,'Multas Impositivas',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(572,0,208,NULL,'Impuesto a los Ingresos Brutos - BS AS',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(573,0,209,NULL,'SIRCREB',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(574,0,212,NULL,'Tarjeta Visa',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(575,0,213,NULL,'Tarjeta American Express',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(576,0,214,NULL,'Tarjeta Mastercard',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(577,0,215,NULL,'Tarjeta Shopping',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(578,0,216,NULL,'Tarjeta Cencosud',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(579,0,217,NULL,'Compras',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(580,0,218,NULL,'Ventas No Gravadas',0,0,0,0,1,1,'2020-02-06 17:23:07','2021-01-14 21:13:00',NULL),(581,0,220,NULL,'Perc IVA -RG3337',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(582,0,221,NULL,'Imps. Internos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(583,0,222,NULL,'Imp. Gasoil',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(584,0,223,NULL,'Imp. Hídricos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(585,0,224,NULL,'ITC',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(586,0,225,NULL,'Perc IIBB  Buenos Aires',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(587,0,226,NULL,'Perc IIBB  Capital Federal',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(588,0,227,NULL,'Perc IIBB  Catamarca',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(589,0,228,NULL,'Perc IIBB  Chaco',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(590,0,229,NULL,'Perc IIBB  Chubut',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(591,0,230,NULL,'Perc IIBB  Córdoba',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(592,0,231,NULL,'Perc IIBB  Corrientes',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(593,0,232,NULL,'Perc IIBB  Entre Ríos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(594,0,233,NULL,'Perc IIBB  Formosa',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(595,0,234,NULL,'Perc IIBB  Jujuy',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(596,0,235,NULL,'Perc IIBB  La Pampa',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(597,0,236,NULL,'Perc IIBB  La Rioja',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(598,0,237,NULL,'Perc IIBB  Mendoza',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(599,0,238,NULL,'Perc IIBB  Misiones',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(600,0,239,NULL,'Perc IIBB  Neuquén',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(601,0,240,NULL,'Perc IIBB  Pascua Lama',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(602,0,241,NULL,'Perc IIBB  Río Negro',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(603,0,242,NULL,'Perc IIBB  Salta',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(604,0,243,NULL,'Perc IIBB  San Juan',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(605,0,244,NULL,'Perc IIBB  San Luis',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(606,0,245,NULL,'Perc IIBB  Santa Cruz',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (607,0,246,NULL,'Perc IIBB  Santa Fe',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(608,0,247,NULL,'Perc IIBB  Santiago del Estero',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(609,0,248,NULL,'Perc IIBB  Tierra del Fuego',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(610,0,249,NULL,'Perc IIBB  Tucuman',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(611,0,250,NULL,'Compras No Gravadas',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(612,0,276,NULL,'SIRCREB Buenos Aires',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(613,0,277,NULL,'SIRCREB Capital Federal',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(614,0,278,NULL,'SIRCREB Catamarca',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(615,0,279,NULL,'SIRCREB Chaco',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(616,0,280,NULL,'SIRCREB Chubut',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(617,0,281,NULL,'SIRCREB Córdoba',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(618,0,282,NULL,'SIRCREB Corrientes',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(619,0,283,NULL,'SIRCREB Entre Ríos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(620,0,284,NULL,'SIRCREB Formosa',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(621,0,285,NULL,'SIRCREB Jujuy',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(622,0,286,NULL,'SIRCREB La Pampa',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(623,0,287,NULL,'SIRCREB La Rioja',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(624,0,288,NULL,'SIRCREB Mendoza',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(625,0,289,NULL,'SIRCREB Misiones',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(626,0,290,NULL,'SIRCREB Neuquén',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(627,0,291,NULL,'SIRCREB Pascua Lama',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(628,0,292,NULL,'SIRCREB Río Negro',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(629,0,293,NULL,'SIRCREB Salta',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(630,0,294,NULL,'SIRCREB San Juan',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(631,0,295,NULL,'SIRCREB San Luis',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(632,0,296,NULL,'SIRCREB Santa Cruz',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(633,0,297,NULL,'SIRCREB Santa Fe',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(634,0,298,NULL,'SIRCREB Santiago del Estero',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(635,0,299,NULL,'SIRCREB Tierra del Fuego',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(636,0,300,NULL,'SIRCREB Tucuman',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(637,0,301,NULL,'IIBB a Favor Buenos Aires',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(638,0,302,NULL,'IIBB a Favor Capital Federal',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(639,0,303,NULL,'IIBB a Favor Catamarca',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(640,0,304,NULL,'IIBB a Favor Chaco',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(641,0,305,NULL,'IIBB a Favor Chubut',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(642,0,306,NULL,'IIBB a Favor Córdoba',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(643,0,307,NULL,'IIBB a Favor Corrientes',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(644,0,308,NULL,'IIBB a Favor Entre Ríos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(645,0,309,NULL,'IIBB a Favor Formosa',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(646,0,310,NULL,'IIBB a Favor Jujuy',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (647,0,311,NULL,'IIBB a Favor La Pampa',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(648,0,312,NULL,'IIBB a Favor La Rioja',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(649,0,313,NULL,'IIBB a Favor Mendoza',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(650,0,314,NULL,'IIBB a Favor Misiones',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(651,0,315,NULL,'IIBB a Favor Neuquén',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(652,0,316,NULL,'IIBB a Favor Pascua Lama',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(653,0,317,NULL,'IIBB a Favor Río Negro',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(654,0,318,NULL,'IIBB a Favor Salta',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(655,0,319,NULL,'IIBB a Favor San Juan',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(656,0,320,NULL,'IIBB a Favor San Luis',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(657,0,321,NULL,'IIBB a Favor Santa Cruz',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(658,0,322,NULL,'IIBB a Favor Santa Fe',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(659,0,323,NULL,'IIBB a Favor Santiago del Estero',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(660,0,324,NULL,'IIBB a Favor Tierra del Fuego',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(661,0,325,NULL,'IIBB a Favor Tucuman',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(662,0,326,NULL,'IIBB a Pagar Buenos Aires',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(663,0,327,NULL,'IIBB a Pagar Capital Federal',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(664,0,328,NULL,'IIBB a Pagar Catamarca',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(665,0,329,NULL,'IIBB a Pagar Chaco',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(666,0,330,NULL,'IIBB a Pagar Chubut',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(667,0,331,NULL,'IIBB a Pagar Córdoba',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(668,0,332,NULL,'IIBB a Pagar Corrientes',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(669,0,333,NULL,'IIBB a Pagar Entre Ríos',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(670,0,334,NULL,'IIBB a Pagar Formosa',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(671,0,335,NULL,'IIBB a Pagar Jujuy',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(672,0,336,NULL,'IIBB a Pagar La Pampa',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(673,0,337,NULL,'IIBB a Pagar La Rioja',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(674,0,338,NULL,'IIBB a Pagar Mendoza',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(675,0,339,NULL,'IIBB a Pagar Misiones',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(676,0,340,NULL,'IIBB a Pagar Neuquén',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(677,0,341,NULL,'IIBB a Pagar Pascua Lama',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(678,0,342,NULL,'IIBB a Pagar Río Negro',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(679,0,343,NULL,'IIBB a Pagar Salta',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(680,0,344,NULL,'IIBB a Pagar San Juan',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(681,0,345,NULL,'IIBB a Pagar San Luis',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(682,0,346,NULL,'IIBB a Pagar Santa Cruz',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(683,0,347,NULL,'IIBB a Pagar Santa Fe',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(684,0,348,NULL,'IIBB a Pagar Santiago del Estero',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (685,0,349,NULL,'IIBB a Pagar Tierra del Fuego',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(686,0,350,NULL,'IIBB a Pagar Tucuman',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(687,0,352,NULL,'Compensacion',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(688,0,353,NULL,'IVA Saldo Tecnico',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(689,0,354,NULL,'IVA Saldo Libre Disponibilidad',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(690,0,361,NULL,'Equipos de Computación',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(691,0,362,NULL,'Computadoras',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(692,0,363,NULL,'Muebles y Utiles',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(693,0,365,NULL,'Provision Honorarios',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(694,0,366,NULL,'Cta. Cte Directores',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(695,0,367,NULL,'Provisión Honorarios Directores',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(696,0,368,NULL,'Cuenta Particular Socio 1',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(697,0,369,NULL,'Capital',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(698,0,380,NULL,'Instalaciones',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(699,0,381,NULL,'Reserva Legal',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(700,0,382,NULL,'Reserva Legal',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(701,0,383,NULL,'Resultado no asignado',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(702,0,386,NULL,'PLAZO FIJO',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(703,0,388,NULL,'ACCIONES',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(704,0,389,NULL,'Inmuebles',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(705,0,390,NULL,'Vehiculos',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(706,0,391,NULL,'Maquinarias',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(707,0,392,NULL,'MERCADERIAS',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(708,0,393,NULL,'OTROS',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(709,0,395,NULL,'Cuenta Particular Socio 2',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(710,0,396,NULL,'Comisiones Y gastos Bancarios',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(711,0,411,NULL,'Provisión Impuesto a las Ganancias',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(712,0,412,NULL,'Amortización Muebles y Útiles',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(713,0,413,NULL,'Amortización Equipos',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(714,0,414,NULL,'Amortizacion Acumulada Equipos',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(715,0,415,NULL,'Amortización Acumulada Maquinarias',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(716,0,416,NULL,'Materias Primas',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(717,0,419,NULL,'Rodados',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(718,0,420,NULL,'Amortización Acumulada Rodados',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(719,0,421,NULL,'Amortización Rodados',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(720,0,422,NULL,'Amortización Maquinarias',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(721,0,423,NULL,'Accesorios',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(722,0,424,NULL,'Amortización Acumulada Accesorios',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(723,0,426,NULL,'Reserva Facultativa',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (724,0,427,NULL,'Créditos por Impuestos Diferidos',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(725,0,428,NULL,'Fondo de Comercio',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(726,0,429,NULL,'Amortizacion Acumulada Fondo de Comercio',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(727,0,430,NULL,'Intereses a devengar AGIP',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(728,0,431,NULL,'PFP IIBB',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(729,0,434,NULL,'Productos',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(730,0,435,NULL,'Intereses a devengar PFP',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(731,0,437,NULL,'Imp. Ley 25413 Cred 0.6%',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(732,0,438,NULL,'Honorarios Directorio a Pagar',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(733,0,439,NULL,'Reserva para Futuras Inversiones',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(734,0,440,NULL,'TEAC - Trabajos Ejecutados a Certificar',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(735,0,444,NULL,'Banco Santander Rio Cta Cte',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(736,0,449,NULL,'Leasing',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(737,0,453,NULL,'Inversión Central Caribe',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(738,0,454,NULL,'Otras Inversiones',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(739,0,455,NULL,'Otros Créditos',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(740,0,456,NULL,'Provisión Honorarios Socio Gerente',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(741,0,459,NULL,'Moratoria SUSS a pagar',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(742,0,460,NULL,'Impuestos Municipales a Pagar',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(743,0,461,NULL,'Amortización Instalaciones',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(744,0,462,NULL,'Amortización Equipos de comput.',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(745,0,463,NULL,'Cuenta Particular Socio 3',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(746,0,464,NULL,'Cuenta Particular Socio 4',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(747,0,465,NULL,'Otras Reservas',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(748,0,466,NULL,'IGMP (Saldo a Favor)',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(749,0,468,NULL,'Productos en Proceso',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(750,0,469,NULL,'Depósitos en Garantía Socio Gerente',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(751,0,470,NULL,'Fondos Embargados',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(752,0,471,NULL,'Cuota Solid.',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(753,0,472,NULL,'Anticipo Honorarios Directores',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(754,0,473,NULL,'SICORE a Pagar',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(755,0,476,NULL,'RECPAM',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(756,0,478,NULL,'CO2 - Imp. Al Carbono',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL);
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuentas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_detail`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `fecha` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_detail_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `cta_cte_tesoreria_detail_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_detail_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_detail_period_id_foreign` (`period_id`),
  KEY `cta_cte_tesoreria_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `cta_cte_tesoreria_detail_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_detail`
--

LOCK TABLES `cta_cte_tesoreria_detail` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctacte_bancos`
--

DROP TABLE IF EXISTS `ctacte_bancos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctacte_bancos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `codigoBCRA` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctacte_bancos`
--

LOCK TABLES `ctacte_bancos` WRITE;
/*!40000 ALTER TABLE `ctacte_bancos` DISABLE KEYS */;
INSERT INTO `ctacte_bancos` VALUES (1,NULL,'BANCO DE GALICIA Y BUENOS AIRES S.A.',7,NULL,NULL,NULL),(2,NULL,'BANCO DE LA NACION ARGENTINA',11,NULL,NULL,NULL),(3,NULL,'BANCO DE LA PROVINCIA DE BUENOS AIRES',14,NULL,NULL,NULL),(4,NULL,'INDUSTRIAL AND COMMERCIAL BANK OF CHINA',15,NULL,NULL,NULL),(5,NULL,'CITIBANK N.A.',16,NULL,NULL,NULL),(6,NULL,'BBVA BANCO FRANCES S.A.',17,NULL,NULL,NULL),(7,NULL,'THE BANK OF TOKYO-MITSUBISHI UFJ, LTD.',18,NULL,NULL,NULL),(8,NULL,'BANCO DE LA PROVINCIA DE CORDOBA S.A.',20,NULL,NULL,NULL),(9,NULL,'BANCO SUPERVIELLE S.A.',27,NULL,NULL,NULL),(10,NULL,'BANCO DE LA CIUDAD DE BUENOS AIRES',29,NULL,NULL,NULL),(11,NULL,'BANCO PATAGONIA S.A.',34,NULL,NULL,NULL),(12,NULL,'BANCO HIPOTECARIO S.A.',44,NULL,NULL,NULL),(13,NULL,'BANCO DE SAN JUAN S.A.',45,NULL,NULL,NULL),(14,NULL,'BANCO DEL TUCUMAN S.A.',60,NULL,NULL,NULL),(15,NULL,'BANCO MUNICIPAL DE ROSARIO',65,NULL,NULL,NULL),(16,NULL,'BANCO SANTANDER RIO S.A.',72,NULL,NULL,NULL),(17,NULL,'BANCO DEL CHUBUT S.A.',83,NULL,NULL,NULL),(18,NULL,'BANCO DE SANTA CRUZ S.A.',86,NULL,NULL,NULL),(19,NULL,'BANCO DE LA PAMPA SOCIEDAD DE ECONOMÍA M',93,NULL,NULL,NULL),(20,NULL,'BANCO DE CORRIENTES S.A.',94,NULL,NULL,NULL),(21,NULL,'BANCO PROVINCIA DEL NEUQUÉN SOCIEDAD ANÓ',97,NULL,NULL,NULL),(22,NULL,'BANCO INTERFINANZAS S.A.',147,NULL,NULL,NULL),(23,NULL,'HSBC BANK ARGENTINA S.A.',150,NULL,NULL,NULL),(24,NULL,'JPMORGAN CHASE BANK, NATIONAL ASSOCIATIO',165,NULL,NULL,NULL),(25,NULL,'BANCO CREDICOOP COOPERATIVO LIMITADO',191,NULL,NULL,NULL),(26,NULL,'BANCO DE VALORES S.A.',198,NULL,NULL,NULL),(27,NULL,'BANCO ROELA S.A.',247,NULL,NULL,NULL),(28,NULL,'BANCO MARIVA S.A.',254,NULL,NULL,NULL),(29,NULL,'BANCO ITAU ARGENTINA S.A.',259,NULL,NULL,NULL),(30,NULL,'BANK OF AMERICA, NATIONAL ASSOCIATION',262,NULL,NULL,NULL),(31,NULL,'BNP PARIBAS',266,NULL,NULL,NULL),(32,NULL,'BANCO PROVINCIA DE TIERRA DEL FUEGO',268,NULL,NULL,NULL),(33,NULL,'BANCO DE LA REPUBLICA ORIENTAL DEL URUGU',269,NULL,NULL,NULL),(34,NULL,'BANCO SAENZ S.A.',277,NULL,NULL,NULL),(35,NULL,'BANCO MERIDIAN S.A.',281,NULL,NULL,NULL),(36,NULL,'BANCO MACRO S.A.',285,NULL,NULL,NULL),(37,NULL,'BANCO COMAFI SOCIEDAD ANONIMA',299,NULL,NULL,NULL),(38,NULL,'BANCO DE INVERSION Y COMERCIO EXTERIOR S',300,NULL,NULL,NULL),(39,NULL,'BANCO PIANO S.A.',301,NULL,NULL,NULL),(40,NULL,'BANCO JULIO SOCIEDAD ANONIMA',305,NULL,NULL,NULL),(41,NULL,'BANCO RIOJA SOCIEDAD ANONIMA UNIPERSONAL',309,NULL,NULL,NULL),(42,NULL,'BANCO DEL SOL S.A.',310,NULL,NULL,NULL),(43,NULL,'NUEVO BANCO DEL CHACO S. A.',311,NULL,NULL,NULL),(44,NULL,'BANCO VOII S.A.',312,NULL,NULL,NULL),(45,NULL,'BANCO DE FORMOSA S.A.',315,NULL,NULL,NULL),(46,NULL,'BANCO CMF S.A.',319,NULL,NULL,NULL),(47,NULL,'BANCO DE SANTIAGO DEL ESTERO S.A.',321,NULL,NULL,NULL),(48,NULL,'BANCO INDUSTRIAL S.A.',322,NULL,NULL,NULL),(49,NULL,'NUEVO BANCO DE SANTA FE SOCIEDAD ANONIMA',330,NULL,NULL,NULL),(50,NULL,'BANCO CETELEM ARGENTINA S.A.',331,NULL,NULL,NULL),(51,NULL,'BANCO DE SERVICIOS FINANCIEROS S.A.',332,NULL,NULL,NULL),(52,NULL,'BANCO BRADESCO ARGENTINA S.A.U.',336,NULL,NULL,NULL),(53,NULL,'BANCO DE SERVICIOS Y TRANSACCIONES S.A.',338,NULL,NULL,NULL),(54,NULL,'RCI BANQUE S.A.',339,NULL,NULL,NULL),(55,NULL,'BACS BANCO DE CREDITO Y SECURITIZACION S',340,NULL,NULL,NULL),(56,NULL,'BANCO MASVENTAS S.A.',341,NULL,NULL,NULL),(57,NULL,'BANCO WANAP S.A.',384,NULL,NULL,NULL),(58,NULL,'NUEVO BANCO DE ENTRE RÍOS S.A.',386,NULL,NULL,NULL),(59,NULL,'BANCO COLUMBIA S.A.',389,NULL,NULL,NULL),(60,NULL,'BANCO BICA S.A.',426,NULL,NULL,NULL),(61,NULL,'BANCO COINAG S.A.',431,NULL,NULL,NULL),(62,NULL,'BANCO DE COMERCIO S.A.',432,NULL,NULL,NULL),(63,NULL,'FORD CREDIT COMPAÑIA FINANCIERA S.A.',44059,NULL,NULL,NULL),(64,NULL,'COMPAÑIA FINANCIERA ARGENTINA S.A.',44077,NULL,NULL,NULL),(65,NULL,'VOLKWAGEN FINANCIAL SERVICES CIA.FIN.S.A',44088,NULL,NULL,NULL),(66,NULL,'CORDIAL COMPAÑÍA FINANCIERA S.A.',44090,NULL,NULL,NULL),(67,NULL,'FCA COMPAÑIA FINANCIERA S.A.',44092,NULL,NULL,NULL);
INSERT INTO `ctacte_bancos` VALUES (68,NULL,'GPAT COMPAÑIA FINANCIERA S.A.',44093,NULL,NULL,NULL),(69,NULL,'MERCEDES-BENZ COMPAÑÍA FINANCIERA ARGENT',44094,NULL,NULL,NULL),(70,NULL,'ROMBO COMPAÑÍA FINANCIERA S.A.',44095,NULL,NULL,NULL),(71,NULL,'JOHN DEERE CREDIT COMPAÑÍA FINANCIERA S.',44096,NULL,NULL,NULL),(72,NULL,'PSA FINANCE ARGENTINA COMPAÑÍA FINANCIER',44098,NULL,NULL,NULL),(73,NULL,'TOYOTA COMPAÑÍA FINANCIERA DE ARGENTINA',44099,NULL,NULL,NULL),(74,NULL,'FINANDINO COMPAÑIA FINANCIERA S.A.',44100,NULL,NULL,NULL),(75,NULL,'MONTEMAR COMPAÑIA FINANCIERA S.A.',45056,NULL,NULL,NULL),(76,NULL,'MULTIFINANZAS COMPAÑIA FINANCIERA S.A.',45072,NULL,NULL,NULL),(77,NULL,'CAJA DE CREDITO \"CUENCA\" COOPERATIVA LIM',65203,NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctacte_bancos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctacte_bancos_datos`
--

DROP TABLE IF EXISTS `ctacte_bancos_datos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctacte_bancos_datos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cuenta_conta_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuit` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `titular` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `num_cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cbu` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alias` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ctacte_bancos_datos_cuenta_conta_id_foreign` (`cuenta_conta_id`),
  CONSTRAINT `ctacte_bancos_datos_cuenta_conta_id_foreign` FOREIGN KEY (`cuenta_conta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctacte_bancos_datos`
--

LOCK TABLES `ctacte_bancos_datos` WRITE;
/*!40000 ALTER TABLE `ctacte_bancos_datos` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctacte_bancos_datos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctacte_cheques`
--

DROP TABLE IF EXISTS `ctacte_cheques`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctacte_cheques` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `asiento_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuenta_conta_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id2` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id2` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) DEFAULT NULL,
  `cheque3ros` tinyint(1) NOT NULL DEFAULT '0',
  `cheque_emitidos` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `fecha_cobro` date DEFAULT NULL,
  `banco_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `titular` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abierto_cruzado` int(11) NOT NULL DEFAULT '1',
  `numero` int(10) unsigned DEFAULT NULL,
  `foto` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ctacte_cheques_asiento_id_foreign` (`asiento_id`),
  KEY `ctacte_cheques_cuenta_conta_id_foreign` (`cuenta_conta_id`),
  KEY `ctacte_cheques_banco_id_foreign` (`banco_id`),
  KEY `ctacte_cheques_person_id_foreign` (`person_id`),
  KEY `ctacte_cheques_cta_cte_cliente_id2_foreign` (`cta_cte_cliente_id2`),
  KEY `ctacte_cheques_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_tesorer_id` (`cta_cte_tesoreria_id`),
  KEY `ctacte_cheques_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `ctacte_cheques_nf_cta_cte_id2_foreign` (`nf_cta_cte_id2`),
  KEY `ctacte_cheques_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `cta_cte_tesorer_id` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `ctacte_cheques_banco_id_foreign` FOREIGN KEY (`banco_id`) REFERENCES `ctacte_bancos` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_cliente_id2_foreign` FOREIGN KEY (`cta_cte_cliente_id2`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctacte_cheques_cuenta_conta_id_foreign` FOREIGN KEY (`cuenta_conta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `ctacte_cheques_nf_cta_cte_id2_foreign` FOREIGN KEY (`nf_cta_cte_id2`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `ctacte_cheques_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `ctacte_cheques_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctacte_cheques`
--

LOCK TABLES `ctacte_cheques` WRITE;
/*!40000 ALTER TABLE `ctacte_cheques` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctacte_cheques` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_centrocosto`
--

DROP TABLE IF EXISTS `ctactegastos_centrocosto`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_centrocosto` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_centrocosto`
--

LOCK TABLES `ctactegastos_centrocosto` WRITE;
/*!40000 ALTER TABLE `ctactegastos_centrocosto` DISABLE KEYS */;
INSERT INTO `ctactegastos_centrocosto` VALUES (1,NULL,'OFICINA',NULL,NULL,NULL),(2,NULL,'FIJO',NULL,NULL,NULL),(3,NULL,'VARIABLE',NULL,NULL,NULL),(4,NULL,'GISELA',NULL,NULL,NULL),(5,NULL,'LIA',NULL,NULL,NULL),(6,NULL,'PADRES',NULL,NULL,NULL),(7,NULL,'CASA',NULL,NULL,NULL),(8,NULL,'VANESA',NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctactegastos_centrocosto` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_cuenta_tipo`
--

DROP TABLE IF EXISTS `ctactegastos_cuenta_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_cuenta_tipo` (
  `idCuentaTipo` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `idTipo` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`idCuentaTipo`),
  KEY `ctactegastos_cuenta_tipo_idtipo_foreign` (`idTipo`),
  KEY `ctactegastos_cuenta_tipo_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `ctactegastos_cuenta_tipo_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctactegastos_cuenta_tipo_idtipo_foreign` FOREIGN KEY (`idTipo`) REFERENCES `ctactegastos_tiposdegastos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_cuenta_tipo`
--

LOCK TABLES `ctactegastos_cuenta_tipo` WRITE;
/*!40000 ALTER TABLE `ctactegastos_cuenta_tipo` DISABLE KEYS */;
INSERT INTO `ctactegastos_cuenta_tipo` VALUES (1,NULL,NULL,3,NULL,NULL,NULL),(2,NULL,NULL,6,NULL,NULL,NULL),(3,NULL,NULL,3,NULL,NULL,NULL),(4,NULL,NULL,4,NULL,NULL,NULL),(5,NULL,NULL,5,NULL,NULL,NULL),(6,NULL,NULL,3,NULL,NULL,NULL),(7,NULL,NULL,4,NULL,NULL,NULL),(8,NULL,NULL,3,NULL,NULL,NULL),(9,NULL,NULL,4,NULL,NULL,NULL),(10,NULL,NULL,7,NULL,NULL,NULL),(11,NULL,NULL,8,NULL,NULL,NULL),(12,NULL,NULL,3,NULL,NULL,NULL),(13,NULL,NULL,3,NULL,NULL,NULL),(14,NULL,NULL,4,NULL,NULL,NULL),(15,NULL,NULL,1,NULL,NULL,NULL),(16,NULL,NULL,2,NULL,NULL,NULL),(17,NULL,NULL,5,NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctactegastos_cuenta_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_mensuales`
--

DROP TABLE IF EXISTS `ctactegastos_mensuales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_mensuales` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `CuentaTipo_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL DEFAULT '13',
  `TipoDeGasto_id` int(10) unsigned NOT NULL,
  `CentroCosto_id` int(10) unsigned NOT NULL,
  `gasto_cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL DEFAULT '13',
  `monto` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ctactegastos_mensuales_cuentatipo_id_foreign` (`CuentaTipo_id`),
  KEY `ctactegastos_mensuales_tipodegasto_id_foreign` (`TipoDeGasto_id`),
  KEY `ctactegastos_mensuales_centrocosto_id_foreign` (`CentroCosto_id`),
  KEY `ctactegastos_mensuales_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `ctactegastos_mensuales_gasto_cta_cte_tesoreria_cuenta_id_foreign` (`gasto_cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `ctactegastos_mensuales_centrocosto_id_foreign` FOREIGN KEY (`CentroCosto_id`) REFERENCES `ctactegastos_centrocosto` (`id`),
  CONSTRAINT `ctactegastos_mensuales_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctactegastos_mensuales_cuentatipo_id_foreign` FOREIGN KEY (`CuentaTipo_id`) REFERENCES `ctactegastos_cuenta_tipo` (`idCuentaTipo`),
  CONSTRAINT `ctactegastos_mensuales_gasto_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`gasto_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctactegastos_mensuales_tipodegasto_id_foreign` FOREIGN KEY (`TipoDeGasto_id`) REFERENCES `ctactegastos_tiposdegastos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_mensuales`
--

LOCK TABLES `ctactegastos_mensuales` WRITE;
/*!40000 ALTER TABLE `ctactegastos_mensuales` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctactegastos_mensuales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_tiposdegastos`
--

DROP TABLE IF EXISTS `ctactegastos_tiposdegastos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_tiposdegastos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_tiposdegastos`
--

LOCK TABLES `ctactegastos_tiposdegastos` WRITE;
/*!40000 ALTER TABLE `ctactegastos_tiposdegastos` DISABLE KEYS */;
INSERT INTO `ctactegastos_tiposdegastos` VALUES (1,NULL,'Oficina',NULL,NULL,NULL),(2,NULL,'Personales',NULL,NULL,NULL),(3,NULL,'Tarjeta VISA',NULL,NULL,NULL),(4,NULL,'Tarjeta Mastercard',NULL,NULL,NULL),(5,NULL,'Debito Automatico',NULL,NULL,NULL),(6,NULL,'American Express',NULL,NULL,NULL),(7,NULL,'Tarjeta Shopping',NULL,NULL,NULL),(8,NULL,'Tarjeta Cencosud',NULL,NULL,NULL),(9,NULL,'Tarjeta Coto',NULL,NULL,NULL),(10,NULL,'Tarjeta Nativa',NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctactegastos_tiposdegastos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cursos`
--

DROP TABLE IF EXISTS `cursos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cursos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `fecha` date DEFAULT NULL,
  `hora` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `profesor` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cant_clases` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `duracion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `adjuntos` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `link_zoom` longtext COLLATE utf8mb4_unicode_ci,
  `cod_zoom` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contraseña_zoom` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `link_youtube` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `materiales` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cursos`
--

LOCK TABLES `cursos` WRITE;
/*!40000 ALTER TABLE `cursos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cursos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cursos_detail`
--

DROP TABLE IF EXISTS `cursos_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cursos_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `curso_id` int(10) unsigned NOT NULL,
  `field_name1` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `celular` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cursos_detail_curso_id_foreign` (`curso_id`),
  CONSTRAINT `cursos_detail_curso_id_foreign` FOREIGN KEY (`curso_id`) REFERENCES `cursos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cursos_detail`
--

LOCK TABLES `cursos_detail` WRITE;
/*!40000 ALTER TABLE `cursos_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `cursos_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `data_types`
--

DROP TABLE IF EXISTS `data_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `data_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `data_types_description_unique` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `data_types`
--

LOCK TABLES `data_types` WRITE;
/*!40000 ALTER TABLE `data_types` DISABLE KEYS */;
INSERT INTO `data_types` VALUES (1,'Comprobantes XLS',1,'Importación','XLS','data/imports/receipts/xls',NULL,NULL),(2,'CITI-Ventas',1,'Importación','TXT','data/imports/receipts/CitiVentas',NULL,NULL),(3,'CITI Compras',2,'Exportación','TXT','data/exports/receipts/citi',NULL,NULL),(4,'CITI Ventas',2,'Exportación','TXT','data/exports/receipts/CitiVentasExport',NULL,NULL),(5,'Convenio Multilateral',2,'Exportación','TXT','data/exports/receipts/convenio',NULL,NULL),(6,'Libro IVA Digital',2,'Exportación','TXT','data/exports/receipts/libro_iva_digital',NULL,'2019-11-20 21:43:44'),(7,'Mis Comprobantes',1,'Importacion','','data/imports/receipts/mis_comprobantes',NULL,NULL),(8,'Consulta AFIP',3,'AFIP','','data/afip/index','2019-12-06 14:49:55','2019-12-06 14:49:55');
/*!40000 ALTER TABLE `data_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `deudas_impositivas`
--

DROP TABLE IF EXISTS `deudas_impositivas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `deudas_impositivas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `vto_impuesto_id` int(10) unsigned NOT NULL,
  `periodo_deuda` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `concepto` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `deudas_impositivas_vto_impuesto_id_foreign` (`vto_impuesto_id`),
  KEY `deudas_impositivas_person_id_foreign` (`person_id`),
  CONSTRAINT `deudas_impositivas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `deudas_impositivas_vto_impuesto_id_foreign` FOREIGN KEY (`vto_impuesto_id`) REFERENCES `vto_impuestos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `deudas_impositivas`
--

LOCK TABLES `deudas_impositivas` WRITE;
/*!40000 ALTER TABLE `deudas_impositivas` DISABLE KEYS */;
/*!40000 ALTER TABLE `deudas_impositivas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ejer_anteriores`
--

DROP TABLE IF EXISTS `ejer_anteriores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ejer_anteriores` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `anio` int(11) NOT NULL,
  `ventas` decimal(16,2) DEFAULT NULL,
  `compras` decimal(16,2) DEFAULT NULL,
  `sueldos` decimal(16,2) DEFAULT NULL,
  `impuesto` decimal(16,2) DEFAULT NULL,
  `apagar` decimal(16,2) DEFAULT NULL,
  `afavor` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ejer_anteriores_person_id_foreign` (`person_id`),
  CONSTRAINT `ejer_anteriores_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ejer_anteriores`
--

LOCK TABLES `ejer_anteriores` WRITE;
/*!40000 ALTER TABLE `ejer_anteriores` DISABLE KEYS */;
/*!40000 ALTER TABLE `ejer_anteriores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estado_civil`
--

DROP TABLE IF EXISTS `estado_civil`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estado_civil` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `estado_civil_descripcion_unique` (`descripcion`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estado_civil`
--

LOCK TABLES `estado_civil` WRITE;
/*!40000 ALTER TABLE `estado_civil` DISABLE KEYS */;
INSERT INTO `estado_civil` VALUES (1,NULL,'Separado Legal',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(2,NULL,'Separado de Hecho',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(3,NULL,'Divorciado',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(4,NULL,'Convivencia',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(5,NULL,'Soltero',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(6,NULL,'Casado',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(7,NULL,'Viudo',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL);
/*!40000 ALTER TABLE `estado_civil` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fa_masiva`
--

DROP TABLE IF EXISTS `fa_masiva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fa_masiva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `person_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fa_masiva`
--

LOCK TABLES `fa_masiva` WRITE;
/*!40000 ALTER TABLE `fa_masiva` DISABLE KEYS */;
/*!40000 ALTER TABLE `fa_masiva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fa_masiva_detalle`
--

DROP TABLE IF EXISTS `fa_masiva_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fa_masiva_detalle` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fa_masiva_id` int(11) NOT NULL,
  `cliente_id` int(11) NOT NULL,
  `tipo_comprobante_id` int(10) unsigned NOT NULL DEFAULT '1',
  `zone_id` int(10) unsigned NOT NULL DEFAULT '22',
  `activity_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cond_frente_iva_id` int(10) unsigned NOT NULL DEFAULT '1',
  `system_tax_id` int(10) unsigned NOT NULL DEFAULT '1',
  `concepto_id` int(10) unsigned NOT NULL DEFAULT '1',
  `renglon1` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe1` decimal(20,2) DEFAULT NULL,
  `renglon2` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe2` decimal(20,2) DEFAULT NULL,
  `renglon3` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe3` decimal(20,2) DEFAULT NULL,
  `punto_venta_id` int(11) DEFAULT NULL,
  `fecha_comprobante` date DEFAULT NULL,
  `fecha_facturado_desde` date DEFAULT NULL,
  `fecha_facturado_hasta` date DEFAULT NULL,
  `fecha_vencimiento_pago` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fa_masiva_detalle_concepto_id_foreign` (`concepto_id`),
  KEY `fa_masiva_detalle_system_tax_id_foreign` (`system_tax_id`),
  KEY `fa_masiva_detalle_cond_frente_iva_id_foreign` (`cond_frente_iva_id`),
  KEY `fa_masiva_detalle_zone_id_foreign` (`zone_id`),
  KEY `fa_masiva_detalle_tipo_comprobante_id_foreign` (`tipo_comprobante_id`),
  KEY `fa_masiva_detalle_activity_id_foreign` (`activity_id`),
  CONSTRAINT `fa_masiva_detalle_activity_id_foreign` FOREIGN KEY (`activity_id`) REFERENCES `activities` (`id`),
  CONSTRAINT `fa_masiva_detalle_concepto_id_foreign` FOREIGN KEY (`concepto_id`) REFERENCES `fact_elec_conceptos_afip` (`id`),
  CONSTRAINT `fa_masiva_detalle_cond_frente_iva_id_foreign` FOREIGN KEY (`cond_frente_iva_id`) REFERENCES `fac_elec_cond_frente_iva` (`id`),
  CONSTRAINT `fa_masiva_detalle_system_tax_id_foreign` FOREIGN KEY (`system_tax_id`) REFERENCES `system_taxes` (`id`),
  CONSTRAINT `fa_masiva_detalle_tipo_comprobante_id_foreign` FOREIGN KEY (`tipo_comprobante_id`) REFERENCES `receipt_types` (`id`),
  CONSTRAINT `fa_masiva_detalle_zone_id_foreign` FOREIGN KEY (`zone_id`) REFERENCES `zones` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fa_masiva_detalle`
--

LOCK TABLES `fa_masiva_detalle` WRITE;
/*!40000 ALTER TABLE `fa_masiva_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `fa_masiva_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fac_elec_cond_frente_iva`
--

DROP TABLE IF EXISTS `fac_elec_cond_frente_iva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fac_elec_cond_frente_iva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `fac_elec_cond_frente_iva_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fac_elec_cond_frente_iva`
--

LOCK TABLES `fac_elec_cond_frente_iva` WRITE;
/*!40000 ALTER TABLE `fac_elec_cond_frente_iva` DISABLE KEYS */;
INSERT INTO `fac_elec_cond_frente_iva` VALUES (1,'IVA Responsable Inscripto','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(2,'IVA Sujeto Exento','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(3,'Consumidor Final','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(4,'Responsable Monotributo','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(5,'Proveedor del Exterior','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(6,'Cliente del Exterior','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(7,'IVA Liberado - Ley Nº 19.640','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(8,'IVA Responsable Inscripto - Agente de Percepción','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(9,'Monotributista Social','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(10,'IVA No Alcanzado','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL);
/*!40000 ALTER TABLE `fac_elec_cond_frente_iva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fac_elec_unidad_medidas`
--

DROP TABLE IF EXISTS `fac_elec_unidad_medidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fac_elec_unidad_medidas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `fac_elec_unidad_medidas_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fac_elec_unidad_medidas`
--

LOCK TABLES `fac_elec_unidad_medidas` WRITE;
/*!40000 ALTER TABLE `fac_elec_unidad_medidas` DISABLE KEYS */;
INSERT INTO `fac_elec_unidad_medidas` VALUES (1,'Grs','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(2,'Kg','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(3,'Mts','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(4,'Mts2','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(5,'Mts3','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(6,'Lts','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(7,'1000 Kwh','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(8,'Unidades','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(9,'Pares','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(10,'Doc','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(11,'Quilates','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(12,'Millares','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(13,'Milimetros','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(14,'Mm 3','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(15,'Km','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(16,'Hectolitros','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(17,'Cm','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(18,'Cm 3','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL);
/*!40000 ALTER TABLE `fac_elec_unidad_medidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_conceptos_afip`
--

DROP TABLE IF EXISTS `fact_elec_conceptos_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_conceptos_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `afip_comprobante_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_conceptos_afip`
--

LOCK TABLES `fact_elec_conceptos_afip` WRITE;
/*!40000 ALTER TABLE `fact_elec_conceptos_afip` DISABLE KEYS */;
INSERT INTO `fact_elec_conceptos_afip` VALUES (1,1,'Producto','2019-03-13 13:29:34','2019-03-13 13:29:34'),(2,2,'Servicios','2019-03-13 13:29:34','2019-03-13 13:29:34'),(3,3,'Productos y Servicios','2019-03-13 13:29:34','2019-03-13 13:29:34');
/*!40000 ALTER TABLE `fact_elec_conceptos_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_puntos_venta`
--

DROP TABLE IF EXISTS `fact_elec_puntos_venta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_puntos_venta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `direccion` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `codigo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '0000',
  `codigo_postal` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zone_id` int(11) DEFAULT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_puntos_venta_person_id_foreign` (`person_id`),
  CONSTRAINT `fact_elec_puntos_venta_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_puntos_venta`
--

LOCK TABLES `fact_elec_puntos_venta` WRITE;
/*!40000 ALTER TABLE `fact_elec_puntos_venta` DISABLE KEYS */;
INSERT INTO `fact_elec_puntos_venta` VALUES (1,2271,'Menzoza 664 -Jose Marmol','2021-07-15 23:07:22','2021-07-23 01:02:16',40719,'3','1846',23,NULL,NULL),(5,2271,'Amenedo 4302- Barrio San Jose','2021-07-23 00:59:13','2021-07-23 01:00:10',40726,'5','1846',23,NULL,NULL);
/*!40000 ALTER TABLE `fact_elec_puntos_venta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_receipt_details`
--

DROP TABLE IF EXISTS `fact_elec_receipt_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_receipt_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fact_elec_receipt_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `cantidad` decimal(20,2) NOT NULL,
  `unidad_medida` text COLLATE utf8mb4_unicode_ci,
  `precio_unitario` decimal(20,2) NOT NULL,
  `neto_gravado` decimal(20,2) NOT NULL,
  `bonificacion_porcentaje` decimal(20,2) DEFAULT NULL,
  `bonificacion_monto` decimal(20,2) DEFAULT NULL,
  `bonificacion_subtotal` decimal(20,2) DEFAULT NULL,
  `system_tax_id` int(10) unsigned NOT NULL DEFAULT '1',
  `iva_monto` decimal(20,2) DEFAULT NULL,
  `iva_subtotal` decimal(20,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `codigo` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_receipt_details_fact_elec_receipt_id_foreign` (`fact_elec_receipt_id`),
  KEY `fact_elec_receipt_details_system_tax_id_foreign` (`system_tax_id`),
  CONSTRAINT `fact_elec_receipt_details_fact_elec_receipt_id_foreign` FOREIGN KEY (`fact_elec_receipt_id`) REFERENCES `fact_elec_receipts` (`id`),
  CONSTRAINT `fact_elec_receipt_details_system_tax_id_foreign` FOREIGN KEY (`system_tax_id`) REFERENCES `system_taxes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_receipt_details`
--

LOCK TABLES `fact_elec_receipt_details` WRITE;
/*!40000 ALTER TABLE `fact_elec_receipt_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `fact_elec_receipt_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_receipts`
--

DROP TABLE IF EXISTS `fact_elec_receipts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_receipts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `fecha_comprobante` date NOT NULL,
  `fecha_facturado_desde` date DEFAULT NULL,
  `fecha_facturado_hasta` date DEFAULT NULL,
  `fecha_vencimiento_pago` date DEFAULT NULL,
  `concepto_id` int(10) unsigned NOT NULL,
  `punto_venta_id` int(10) unsigned NOT NULL,
  `tipo_comprobante_id` int(10) unsigned NOT NULL,
  `condiciones_venta` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comprobante_asoc` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `cae` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cae_vencimiento` date DEFAULT NULL,
  `nro_comprobante_afip` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha_proceso_afip` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_receptor` int(10) unsigned NOT NULL,
  `condicion_venta_id` int(11) DEFAULT NULL,
  `cond_frente_iva_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cbu` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `opcion_transferencia` longtext COLLATE utf8mb4_unicode_ci,
  `alias_cbu` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_receipts_user_id_foreign` (`user_id`),
  KEY `fact_elec_receipts_punto_venta_id_foreign` (`punto_venta_id`),
  KEY `fact_elec_receipts_tipo_comprobante_id_foreign` (`tipo_comprobante_id`),
  KEY `fact_elec_receipts_person_id_foreign` (`person_id`),
  KEY `fact_elec_receipts_person_id_receptor_foreign` (`person_id_receptor`),
  KEY `fact_elec_receipts_cond_frente_iva_id_foreign` (`cond_frente_iva_id`),
  CONSTRAINT `fact_elec_receipts_cond_frente_iva_id_foreign` FOREIGN KEY (`cond_frente_iva_id`) REFERENCES `fac_elec_cond_frente_iva` (`id`),
  CONSTRAINT `fact_elec_receipts_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `fact_elec_receipts_person_id_receptor_foreign` FOREIGN KEY (`person_id_receptor`) REFERENCES `persons` (`id`),
  CONSTRAINT `fact_elec_receipts_punto_venta_id_foreign` FOREIGN KEY (`punto_venta_id`) REFERENCES `fact_elec_puntos_venta` (`id`),
  CONSTRAINT `fact_elec_receipts_tipo_comprobante_id_foreign` FOREIGN KEY (`tipo_comprobante_id`) REFERENCES `receipt_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_receipts`
--

LOCK TABLES `fact_elec_receipts` WRITE;
/*!40000 ALTER TABLE `fact_elec_receipts` DISABLE KEYS */;
INSERT INTO `fact_elec_receipts` VALUES (1,2271,'2021-07-15','2021-07-15','2021-07-15','2021-07-15',3,1,7,'','{\"Tipo\":null,\"PtoVta\":null,\"Nro\":null,\"CbteFch\":\"07-15-2021\",\"anula_comp_rechazado\":\"N\"}','2021-07-15 23:10:55','2021-07-15 23:11:05',NULL,NULL,NULL,NULL,40719,40724,4,1,NULL,NULL,NULL,3500.00,'2021-07-15 23:11:05'),(2,2271,'2021-06-01','2021-06-30','2021-07-22','2021-07-22',2,1,7,'','{\"Tipo\":null,\"PtoVta\":null,\"Nro\":null,\"CbteFch\":\"07-22-2021\",\"anula_comp_rechazado\":\"N\"}','2021-07-23 00:43:13','2021-07-23 00:43:16',NULL,NULL,NULL,NULL,40719,40727,1,4,NULL,NULL,NULL,2000.00,'2021-07-23 00:43:16'),(3,2271,'2021-06-01','2021-06-30','2021-07-22','2021-07-22',2,1,7,'','{\"Tipo\":null,\"PtoVta\":null,\"Nro\":null,\"CbteFch\":\"07-22-2021\",\"anula_comp_rechazado\":\"N\"}','2021-07-23 01:05:37','2021-07-23 01:05:39',NULL,NULL,NULL,NULL,40719,40727,1,3,NULL,NULL,NULL,1500.00,'2021-07-23 01:05:39'),(4,2271,'2021-06-01','2021-06-30','2021-07-22','2021-07-22',2,1,7,'','{\"Tipo\":null,\"PtoVta\":null,\"Nro\":null,\"CbteFch\":\"07-22-2021\",\"anula_comp_rechazado\":\"N\"}','2021-07-23 01:06:24','2021-07-23 01:06:27',NULL,NULL,NULL,NULL,40719,40727,1,3,NULL,NULL,NULL,1500.00,'2021-07-23 01:06:27'),(5,2271,'2021-06-01','2021-06-30','2021-07-22','2021-07-22',2,1,7,'','{\"Tipo\":null,\"PtoVta\":null,\"Nro\":null,\"CbteFch\":\"07-22-2021\",\"anula_comp_rechazado\":\"N\"}','2021-07-23 01:14:59','2021-07-23 01:15:01',NULL,NULL,NULL,NULL,40719,40727,1,3,NULL,NULL,NULL,1500.00,'2021-07-23 01:15:01');
/*!40000 ALTER TABLE `fact_elec_receipts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_tipos_docs_afip`
--

DROP TABLE IF EXISTS `fact_elec_tipos_docs_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_tipos_docs_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `afip_tipo_doc_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=100 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_tipos_docs_afip`
--

LOCK TABLES `fact_elec_tipos_docs_afip` WRITE;
/*!40000 ALTER TABLE `fact_elec_tipos_docs_afip` DISABLE KEYS */;
INSERT INTO `fact_elec_tipos_docs_afip` VALUES (1,1,'CI Buenos Aires','2019-03-13 13:29:34','2019-03-13 13:29:34'),(2,2,'CI Catamarca','2019-03-13 13:29:34','2019-03-13 13:29:34'),(3,3,'CI Córdoba','2019-03-13 13:29:34','2019-03-13 13:29:34'),(4,4,'CI Corrientes','2019-03-13 13:29:34','2019-03-13 13:29:34'),(5,5,'CI Entre Ríos','2019-03-13 13:29:34','2019-03-13 13:29:34'),(6,6,'CI Jujuy','2019-03-13 13:29:34','2019-03-13 13:29:34'),(7,7,'CI Mendoza','2019-03-13 13:29:34','2019-03-13 13:29:34'),(8,8,'CI La Rioja','2019-03-13 13:29:34','2019-03-13 13:29:34'),(9,9,'CI Salta','2019-03-13 13:29:34','2019-03-13 13:29:34'),(10,10,'CI San Juan','2019-03-13 13:29:34','2019-03-13 13:29:34'),(11,11,'CI San Luis','2019-03-13 13:29:34','2019-03-13 13:29:34'),(12,12,'CI Santa Fe','2019-03-13 13:29:34','2019-03-13 13:29:34'),(13,13,'CI Santiago del Estero','2019-03-13 13:29:34','2019-03-13 13:29:34'),(14,14,'CI Tucumán','2019-03-13 13:29:34','2019-03-13 13:29:34'),(16,16,'CI Chaco','2019-03-13 13:29:34','2019-03-13 13:29:34'),(17,17,'CI Chubut','2019-03-13 13:29:34','2019-03-13 13:29:34'),(18,18,'CI Formosa','2019-03-13 13:29:34','2019-03-13 13:29:34'),(19,19,'CI Misiones','2019-03-13 13:29:34','2019-03-13 13:29:34'),(20,20,'CI Neuquén','2019-03-13 13:29:34','2019-03-13 13:29:34'),(21,21,'CI La Pampa','2019-03-13 13:29:34','2019-03-13 13:29:34'),(22,22,'CI Río Negro','2019-03-13 13:29:34','2019-03-13 13:29:34'),(23,23,'CI Santa Cruz','2019-03-13 13:29:34','2019-03-13 13:29:34'),(24,24,'CI Tierra del Fuego','2019-03-13 13:29:34','2019-03-13 13:29:34'),(80,80,'CUIT','2019-03-13 13:29:34','2019-03-13 13:29:34'),(86,86,'CUIL','2019-03-13 13:29:34','2019-03-13 13:29:34'),(87,87,'CDI','2019-03-13 13:29:34','2019-03-13 13:29:34'),(89,89,'LE','2019-03-13 13:29:34','2019-03-13 13:29:34'),(90,90,'LC','2019-03-13 13:29:34','2019-03-13 13:29:34'),(91,91,'CI Extranjera','2019-03-13 13:29:34','2019-03-13 13:29:34'),(92,92,'en trámite','2019-03-13 13:29:34','2019-03-13 13:29:34'),(93,93,'Acta Nacimiento','2019-03-13 13:29:34','2019-03-13 13:29:34'),(94,94,'Pasaporte','2019-03-13 13:29:34','2019-03-13 13:29:34'),(95,95,'CI Bs. As. RNP','2019-03-13 13:29:34','2019-03-13 13:29:34'),(96,96,'DNI','2019-03-13 13:29:34','2019-03-13 13:29:34'),(97,0,'CI Policía Federal','2019-03-13 13:29:34','2019-03-13 13:29:34'),(99,99,'Doc. (Otro)','2019-03-13 13:29:34','2019-03-13 13:29:34');
/*!40000 ALTER TABLE `fact_elec_tipos_docs_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=65 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
INSERT INTO `failed_jobs` VALUES (1,NULL,'database','default','{\"uuid\":\"7318b4fd-c9f7-4188-94ab-d02fc09d8812\",\"displayName\":\"App\\\\Mail\\\\EmailGenerico\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"delay\":null,\"timeout\":null,\"timeoutAt\":null,\"data\":{\"commandName\":\"Illuminate\\\\Mail\\\\SendQueuedMailable\",\"command\":\"O:34:\\\"Illuminate\\\\Mail\\\\SendQueuedMailable\\\":3:{s:8:\\\"mailable\\\";O:22:\\\"App\\\\Mail\\\\EmailGenerico\\\":27:{s:4:\\\"info\\\";a:5:{s:6:\\\"nombre\\\";s:14:\\\"Natalio Javier\\\";s:8:\\\"apellido\\\";s:7:\\\"Ramirez\\\";s:5:\\\"email\\\";s:25:\\\"javier@ryasociados.com.ar\\\";s:7:\\\"celular\\\";s:10:\\\"3772406541\\\";s:4:\\\"cuit\\\";s:13:\\\"20-22995948-5\\\";}s:31:\\\"\\u0000App\\\\Mail\\\\EmailGenerico\\u0000options\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":5:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:4:\\\"from\\\";s:19:\\\"hernan@taxes.com.ar\\\";s:4:\\\"name\\\";s:24:\\\"Hernan de Taxes Software\\\";s:5:\\\"vista\\\";s:52:\\\"landing2.view.prueba_gratis.mail_confirmacion_correo\\\";s:7:\\\"subject\\\";s:39:\\\"Confirmacion de Correo - Taxes Software\\\";}s:6:\\\"locale\\\";N;s:4:\\\"from\\\";a:0:{}s:2:\\\"to\\\";a:1:{i:0;a:2:{s:4:\\\"name\\\";N;s:7:\\\"address\\\";s:25:\\\"javier@ryasociados.com.ar\\\";}}s:2:\\\"cc\\\";a:0:{}s:3:\\\"bcc\\\";a:0:{}s:7:\\\"replyTo\\\";a:0:{}s:7:\\\"subject\\\";N;s:11:\\\"\\u0000*\\u0000markdown\\\";N;s:7:\\\"\\u0000*\\u0000html\\\";N;s:4:\\\"view\\\";N;s:8:\\\"textView\\\";N;s:8:\\\"viewData\\\";a:0:{}s:11:\\\"attachments\\\";a:0:{}s:14:\\\"rawAttachments\\\";a:0:{}s:15:\\\"diskAttachments\\\";a:0:{}s:9:\\\"callbacks\\\";a:0:{}s:5:\\\"theme\\\";N;s:6:\\\"mailer\\\";s:8:\\\"sendgrid\\\";s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:5:\\\"delay\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;}\"}}','ErrorException: Trying to get property \'id\' of non-object in /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php:16\nStack trace:\n#0 /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php(16): Illuminate\\Foundation\\Bootstrap\\HandleExceptions->handleError(8, \'Trying to get p...\', \'/home/forge/tax...\', 16, Array)\n#1 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(356): App\\Queue\\DatabaseJob->fire()\n#2 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(306): Illuminate\\Queue\\Worker->process(\'database\', Object(App\\Queue\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#3 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(132): Illuminate\\Queue\\Worker->runJob(Object(App\\Queue\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#4 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(112): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#5 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(96): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#6 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#7 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#8 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#9 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#10 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#11 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(134): Illuminate\\Container\\Container->call(Array)\n#12 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(256): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#13 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(121): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#14 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(971): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#15 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(290): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#16 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(166): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#17 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Application.php(93): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(129): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#19 /home/forge/taxes.com.ar/artisan(35): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#20 {main}','2021-07-23 14:14:44',NULL);
INSERT INTO `failed_jobs` VALUES (2,NULL,'database','default','{\"uuid\":\"a099e550-b89f-4575-8100-234fd971b57d\",\"displayName\":\"App\\\\Mail\\\\EmailGenerico\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"delay\":null,\"timeout\":null,\"timeoutAt\":null,\"data\":{\"commandName\":\"Illuminate\\\\Mail\\\\SendQueuedMailable\",\"command\":\"O:34:\\\"Illuminate\\\\Mail\\\\SendQueuedMailable\\\":3:{s:8:\\\"mailable\\\";O:22:\\\"App\\\\Mail\\\\EmailGenerico\\\":27:{s:4:\\\"info\\\";a:5:{s:6:\\\"nombre\\\";s:5:\\\"PEDRO\\\";s:8:\\\"apellido\\\";s:6:\\\"BORRAS\\\";s:5:\\\"email\\\";s:25:\\\"pedroaborras@yahoo.com.ar\\\";s:7:\\\"celular\\\";s:10:\\\"3416507446\\\";s:4:\\\"cuit\\\";s:13:\\\"20-22087751-6\\\";}s:31:\\\"\\u0000App\\\\Mail\\\\EmailGenerico\\u0000options\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":5:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:4:\\\"from\\\";s:19:\\\"hernan@taxes.com.ar\\\";s:4:\\\"name\\\";s:24:\\\"Hernan de Taxes Software\\\";s:5:\\\"vista\\\";s:52:\\\"landing2.view.prueba_gratis.mail_confirmacion_correo\\\";s:7:\\\"subject\\\";s:39:\\\"Confirmacion de Correo - Taxes Software\\\";}s:6:\\\"locale\\\";N;s:4:\\\"from\\\";a:0:{}s:2:\\\"to\\\";a:1:{i:0;a:2:{s:4:\\\"name\\\";N;s:7:\\\"address\\\";s:25:\\\"pedroaborras@yahoo.com.ar\\\";}}s:2:\\\"cc\\\";a:0:{}s:3:\\\"bcc\\\";a:0:{}s:7:\\\"replyTo\\\";a:0:{}s:7:\\\"subject\\\";N;s:11:\\\"\\u0000*\\u0000markdown\\\";N;s:7:\\\"\\u0000*\\u0000html\\\";N;s:4:\\\"view\\\";N;s:8:\\\"textView\\\";N;s:8:\\\"viewData\\\";a:0:{}s:11:\\\"attachments\\\";a:0:{}s:14:\\\"rawAttachments\\\";a:0:{}s:15:\\\"diskAttachments\\\";a:0:{}s:9:\\\"callbacks\\\";a:0:{}s:5:\\\"theme\\\";N;s:6:\\\"mailer\\\";s:8:\\\"sendgrid\\\";s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:5:\\\"delay\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;}\"}}','ErrorException: Trying to get property \'id\' of non-object in /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php:16\nStack trace:\n#0 /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php(16): Illuminate\\Foundation\\Bootstrap\\HandleExceptions->handleError(8, \'Trying to get p...\', \'/home/forge/tax...\', 16, Array)\n#1 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(356): App\\Queue\\DatabaseJob->fire()\n#2 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(306): Illuminate\\Queue\\Worker->process(\'database\', Object(App\\Queue\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#3 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(132): Illuminate\\Queue\\Worker->runJob(Object(App\\Queue\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#4 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(112): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#5 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(96): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#6 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#7 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#8 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#9 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#10 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#11 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(134): Illuminate\\Container\\Container->call(Array)\n#12 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(256): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#13 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(121): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#14 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(971): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#15 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(290): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#16 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(166): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#17 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Application.php(93): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(129): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#19 /home/forge/taxes.com.ar/artisan(35): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#20 {main}','2021-07-23 15:07:37',NULL);
INSERT INTO `failed_jobs` VALUES (3,NULL,'database','default','{\"uuid\":\"58539286-8a26-4992-af01-d9f31554a420\",\"displayName\":\"App\\\\Mail\\\\Fact_Electronica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"delay\":null,\"timeout\":null,\"timeoutAt\":null,\"data\":{\"commandName\":\"Illuminate\\\\Mail\\\\SendQueuedMailable\",\"command\":\"O:34:\\\"Illuminate\\\\Mail\\\\SendQueuedMailable\\\":3:{s:8:\\\"mailable\\\";O:25:\\\"App\\\\Mail\\\\Fact_Electronica\\\":27:{s:11:\\\"informacion\\\";a:6:{s:12:\\\"ruta_logo_fa\\\";N;s:4:\\\"mail\\\";s:23:\\\"info@masquecontable.com\\\";s:18:\\\"name_quien_factura\\\";s:19:\\\"MICAELA AILIN CORIA\\\";s:7:\\\"cliente\\\";O:17:\\\"App\\\\Models\\\\Person\\\":27:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:7:\\\"persons\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:40727;s:7:\\\"user_id\\\";i:5115;s:11:\\\"field_name1\\\";s:13:\\\"BOLLO RICHARD\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"20-27325843-5\\\";s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-07-05 13:17:06\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-07-05 13:17:06\\\";s:11:\\\"activity_id\\\";i:1;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";i:1;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:40727;s:7:\\\"user_id\\\";i:5115;s:11:\\\"field_name1\\\";s:13:\\\"BOLLO RICHARD\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"20-27325843-5\\\";s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-07-05 13:17:06\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-07-05 13:17:06\\\";s:11:\\\"activity_id\\\";i:1;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";i:1;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}s:14:\\\"nombre_del_pdf\\\";s:28:\\\"Factura N\\u00b00004-00000006.pdf\\\";s:9:\\\"body_mail\\\";s:155:\\\"Estimado cliente, se env\\u00eda adjunta la factura de honorarios correspondientes al mes de Julio 2021.\\nMuchas gracias por seguir eligiendo nuestros servicios.\\\";}s:3:\\\"pdf\\\";O:26:\\\"Barryvdh\\\\Snappy\\\\PdfWrapper\\\":4:{s:9:\\\"\\u0000*\\u0000snappy\\\";O:35:\\\"Barryvdh\\\\Snappy\\\\IlluminateSnappyPdf\\\":10:{s:26:\\\"\\u0000*\\u0000optionsWithContentCheck\\\";a:4:{s:11:\\\"header-html\\\";s:4:\\\"html\\\";s:11:\\\"footer-html\\\";s:4:\\\"html\\\";s:5:\\\"cover\\\";s:4:\\\"html\\\";s:15:\\\"xsl-style-sheet\\\";s:3:\\\"xsl\\\";}s:36:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000binary\\\";s:76:\\\"\\/home\\/forge\\/taxes.com.ar\\/vendor\\/h4cc\\/wkhtmltopdf-amd64\\/bin\\/wkhtmltopdf-amd64\\\";s:37:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000options\\\";a:132:{s:7:\\\"collate\\\";N;s:10:\\\"no-collate\\\";N;s:10:\\\"cookie-jar\\\";N;s:6:\\\"copies\\\";i:1;s:3:\\\"dpi\\\";N;s:13:\\\"extended-help\\\";N;s:9:\\\"grayscale\\\";N;s:4:\\\"help\\\";N;s:7:\\\"htmldoc\\\";N;s:18:\\\"ignore-load-errors\\\";N;s:9:\\\"image-dpi\\\";N;s:13:\\\"image-quality\\\";N;s:7:\\\"license\\\";N;s:9:\\\"log-level\\\";N;s:10:\\\"lowquality\\\";b:1;s:7:\\\"manpage\\\";N;s:13:\\\"margin-bottom\\\";N;s:11:\\\"margin-left\\\";N;s:12:\\\"margin-right\\\";N;s:10:\\\"margin-top\\\";N;s:11:\\\"orientation\\\";N;s:11:\\\"page-height\\\";N;s:9:\\\"page-size\\\";s:2:\\\"a4\\\";s:10:\\\"page-width\\\";N;s:18:\\\"no-pdf-compression\\\";N;s:5:\\\"quiet\\\";N;s:20:\\\"read-args-from-stdin\\\";N;s:6:\\\"readme\\\";N;s:5:\\\"title\\\";N;s:11:\\\"use-xserver\\\";N;s:7:\\\"version\\\";N;s:20:\\\"dump-default-toc-xsl\\\";N;s:12:\\\"dump-outline\\\";N;s:7:\\\"outline\\\";N;s:10:\\\"no-outline\\\";N;s:13:\\\"outline-depth\\\";N;s:13:\\\"output-format\\\";N;s:5:\\\"allow\\\";N;s:10:\\\"background\\\";N;s:13:\\\"no-background\\\";N;s:16:\\\"bypass-proxy-for\\\";N;s:9:\\\"cache-dir\\\";N;s:20:\\\"checkbox-checked-svg\\\";N;s:12:\\\"checkbox-svg\\\";N;s:6:\\\"cookie\\\";N;s:13:\\\"custom-header\\\";N;s:25:\\\"custom-header-propagation\\\";N;s:28:\\\"no-custom-header-propagation\\\";N;s:16:\\\"debug-javascript\\\";N;s:19:\\\"no-debug-javascript\\\";N;s:14:\\\"default-header\\\";N;s:8:\\\"encoding\\\";N;s:22:\\\"disable-external-links\\\";N;s:21:\\\"enable-external-links\\\";N;s:13:\\\"disable-forms\\\";N;s:12:\\\"enable-forms\\\";N;s:6:\\\"images\\\";N;s:9:\\\"no-images\\\";N;s:22:\\\"disable-internal-links\\\";N;s:21:\\\"enable-internal-links\\\";N;s:18:\\\"disable-javascript\\\";N;s:17:\\\"enable-javascript\\\";N;s:16:\\\"javascript-delay\\\";N;s:19:\\\"keep-relative-links\\\";N;s:19:\\\"load-error-handling\\\";N;s:25:\\\"load-media-error-handling\\\";N;s:25:\\\"disable-local-file-access\\\";N;s:24:\\\"enable-local-file-access\\\";N;s:17:\\\"minimum-font-size\\\";N;s:20:\\\"exclude-from-outline\\\";N;s:18:\\\"include-in-outline\\\";N;s:11:\\\"page-offset\\\";N;s:8:\\\"password\\\";N;s:15:\\\"disable-plugins\\\";N;s:14:\\\"enable-plugins\\\";N;s:4:\\\"post\\\";N;s:9:\\\"post-file\\\";N;s:16:\\\"print-media-type\\\";N;s:19:\\\"no-print-media-type\\\";N;s:5:\\\"proxy\\\";N;s:21:\\\"proxy-hostname-lookup\\\";N;s:23:\\\"radiobutton-checked-svg\\\";N;s:15:\\\"radiobutton-svg\\\";N;s:14:\\\"redirect-delay\\\";N;s:22:\\\"resolve-relative-links\\\";N;s:10:\\\"run-script\\\";N;s:23:\\\"disable-smart-shrinking\\\";N;s:22:\\\"enable-smart-shrinking\\\";N;s:12:\\\"ssl-crt-path\\\";N;s:16:\\\"ssl-key-password\\\";N;s:12:\\\"ssl-key-path\\\";N;s:17:\\\"stop-slow-scripts\\\";N;s:20:\\\"no-stop-slow-scripts\\\";N;s:22:\\\"disable-toc-back-links\\\";N;s:21:\\\"enable-toc-back-links\\\";N;s:16:\\\"user-style-sheet\\\";N;s:8:\\\"username\\\";N;s:13:\\\"viewport-size\\\";N;s:13:\\\"window-status\\\";N;s:4:\\\"zoom\\\";N;s:13:\\\"footer-center\\\";s:25:\\\"Pagina [page] de [toPage]\\\";s:16:\\\"footer-font-name\\\";N;s:16:\\\"footer-font-size\\\";i:8;s:11:\\\"footer-html\\\";N;s:11:\\\"footer-left\\\";s:0:\\\"\\\";s:11:\\\"footer-line\\\";N;s:14:\\\"no-footer-line\\\";N;s:12:\\\"footer-right\\\";N;s:14:\\\"footer-spacing\\\";N;s:13:\\\"header-center\\\";N;s:16:\\\"header-font-name\\\";N;s:16:\\\"header-font-size\\\";N;s:11:\\\"header-html\\\";N;s:11:\\\"header-left\\\";N;s:11:\\\"header-line\\\";N;s:14:\\\"no-header-line\\\";N;s:12:\\\"header-right\\\";N;s:14:\\\"header-spacing\\\";N;s:7:\\\"replace\\\";N;s:5:\\\"cover\\\";N;s:3:\\\"toc\\\";N;s:20:\\\"disable-dotted-lines\\\";N;s:9:\\\"toc-depth\\\";N;s:13:\\\"toc-font-name\\\";N;s:16:\\\"toc-l1-font-size\\\";N;s:15:\\\"toc-header-text\\\";N;s:20:\\\"toc-header-font-name\\\";N;s:20:\\\"toc-header-font-size\\\";N;s:21:\\\"toc-level-indentation\\\";N;s:17:\\\"disable-toc-links\\\";N;s:20:\\\"toc-text-size-shrink\\\";N;s:15:\\\"xsl-style-sheet\\\";N;}s:33:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000env\\\";N;s:37:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000timeout\\\";b:0;s:46:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000defaultExtension\\\";s:3:\\\"pdf\\\";s:18:\\\"\\u0000*\\u0000temporaryFolder\\\";N;s:14:\\\"temporaryFiles\\\";a:0:{}s:36:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000logger\\\";O:18:\\\"Psr\\\\Log\\\\NullLogger\\\":0:{}s:2:\\\"fs\\\";O:32:\\\"Illuminate\\\\Filesystem\\\\Filesystem\\\":0:{}}s:10:\\\"\\u0000*\\u0000options\\\";a:0:{}s:4:\\\"html\\\";s:22306:\\\"<!DOCTYPE html>\\n<html lang=\\\"en\\\">\\n    <head>\\n        <meta charset=\\\"utf-8\\\">\\n    <\\/head>\\n    <style>\\n        .subtotales_conceptos{\\n            width:30%;\\n            text-align: right;\\n        }\\n        .subtotales_importes{\\n            text-align: right;\\n        }\\n        .table-totales, .table-totales tr, .table-totales th{\\n            border: 1px solid;\\n        }\\n\\n    <\\/style>\\n    <body>\\n    <div style=\\\"max-height:840px\\\">\\n        <div style=\\\"width: 100%; height:270px\\\"> <!-- Datos de la empresa -->\\n            <table class=\\\"display\\\" cellspacing=\\\"0\\\" width=\\\"100%\\\" style=\\\"border:  1px solid;\\\">\\n                <tr style=\\\"\\\">\\n                    <th colspan=\\\"2\\\" rowspan=\\\"2\\\" style=\\\"width:45%;margin:0;height:150px;\\\">\\n                                                <img src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/img\\/\\/27377183504\\/logo_punto_venta_0000.png\\\"\\/>\\n                                            <\\/th>\\n                    <th style=\\\"border:  1px solid;text-align: center; width:10%\\\" colspan=\\\"2\\\">\\n                        <span style=\\\"font-size: 60px;\\\">C<\\/span> <br \\/> <span style=\\\"font-size: 14px;\\\">cod. 11<\\/span>\\n                    <\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"font-size: 28px;text-align: center;width:45%\\\">\\n                        Factura\\n                        <br>\\n                        0004 - 00000006\\n                    <\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th><\\/th>\\n                    <th style=\\\"border:  1px 1px 1px 0px solid;\\\" colspan=\\\"2\\\"><\\/th>\\n                    <th><\\/th>\\n                <\\/tr>\\n                <tr>\\n\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                                                    Raz&oacute;n Social:\\n                            <span style=\\\"font-weight: normal;\\\">MICAELA AILIN CORIA<\\/span>\\n                                            <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">Fecha de Emisi&oacute;n: <span style=\\\"font-weight: normal;\\\">15\\/07\\/2021<\\/span><\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Domicilio Comercial: <span style=\\\"font-weight: normal;\\\">Victor Guillet esq. Arturo M Bas, C.P.:5800,\\n                        C\\u00f3rdoba<\\/span>\\n                    <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">CUIT: <span style=\\\"font-weight: normal;\\\">27-37718350-4<\\/span><\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Condici&oacute;n frente al IVA: <span style=\\\"font-weight: normal;\\\">Monotributo<\\/span>\\n                    <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Ingresos Brutos: <span style=\\\"font-weight: normal;\\\"><\\/span>\\n                        <br>\\n                        Fecha de Inicio de Actividades: <span style=\\\"font-weight: normal;\\\">09\\/07\\/2021<\\/span>\\n                    <\\/th>\\n                <\\/tr>\\n            <\\/table>\\n        <\\/div>\\n\\n        <table style=\\\"text-align: center; width: 100%;border: solid 1px;\\\"> <!-- Fechas -->\\n            <thead>\\n                <tr>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Per\\u00edodo Facturado Desde: 01\\/07\\/2021<\\/small><\\/th>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Per\\u00edodo Facturado Hasta: 31\\/07\\/2021<\\/small><\\/th>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Fecha Vto. Pago: 15\\/07\\/2021<\\/small><\\/th>\\n                <\\/tr>\\n            <\\/thead>\\n        <\\/table>\\n        \\n        <table style=\\\"width: 100%; margin-top: 1%;border: solid 1px;\\\"> <!-- Datos Clientes -->\\n            <tr>\\n                <th style=\\\"text-align:left;\\\"colspan=\\\"12\\\">\\n                    CUIT: <span style=\\\"font-weight: normal;\\\">20-27325843-5<\\/span>\\n                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\\n                    Apellido y Nombre \\/ Raz&oacute;n Social: <span style=\\\"font-weight: normal;\\\">\\n                    BOLLO RICHARD<\\/span>\\n                <\\/th>\\n            <\\/tr>\\n            <tr>\\n                <th style=\\\"text-align:left; width:50%\\\">\\n                    Condici&oacute;n Frente al IVA: <span style=\\\"font-weight: normal;\\\">IVA Responsable Inscripto<\\/span>\\n                <\\/th>\\n                <th style=\\\"text-align:left; width:50%\\\" colspan=\\\"4\\\">\\n                    Domicilio Comercial:\\n                    <span style=\\\"font-weight: normal;\\\">\\n                    --------\\n                    <\\/span>\\n                <\\/th>\\n            <\\/tr>\\n            <tr style=\\\"text-align:left\\\">\\n                <th>Condici&oacute;n de Venta: <span style=\\\"font-weight: normal;\\\">Cuenta Corriente<\\/span><\\/th>\\n            <\\/tr>\\n        <\\/table>\\n\\n        <div style=\\\"border: 1px solid;margin-top: 1%;min-height:600px;\\\">\\n        <table style=\\\"text-align: center; width: 100%; margin-top: 1%;\\\"> <!-- Body -->\\n            <tr style=\\\"border-bottom: 1px solid;font-size: 15px\\\">\\n                <th>C&oacute;digo<\\/th>\\n                <th style=\\\"width: 25%;\\\">Detalle<\\/th>\\n                <th>Cantidad<\\/th>\\n                <th>U.Medida<\\/th>\\n                <th>Precio U.<\\/th>\\n                <th>Bonif. (%)<\\/th>\\n                <th>Precio Bonif.<\\/th>\\n                <th>Subtotal<\\/th>\\n                            <\\/tr>\\n            <tbody>\\n                                                                                <tr style=\\\"font-size: 12px;\\\">\\n                        <td>\\n                            \\n                        <\\/td>\\n                        <td>\\n                            Honorarios profesionales Julio 2021\\n                        <\\/td>\\n                        <td>\\n                            1.00\\n                        <\\/td>\\n                        <td>\\n                            Unidades\\n                        <\\/td>\\n                        <td>                            5.900,00\\n                                                    <\\/td>\\n                        <td>\\n                            0,00%\\n                        <\\/td>\\n                        <td>\\n                            0,00\\n                        <\\/td>\\n                        <td>\\n                            5.900,00\\n                        <\\/td>\\n                                            <\\/tr>\\n                    \\n            <\\/tbody>\\n        <\\/table>\\n        <\\/div>\\n\\n        \\n\\n        <div style=\\\"height:200px;margin-top: 1%;\\\"> <!-- Totales -->\\n              <!-- Es factura B o C -->\\n                <table class=\\\"table-totales\\\" cellspacing=\\\"0\\\" width=\\\"100%\\\">\\n                    <tr>\\n                        <th style=\\\"width:50%; text-align:left;\\\">\\n\\n<!--                                <span style=\\\"width:100%;\\\"><img src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/barcodes\\/71304902466075.png\\\"><\\/span>\\n                                <span style=\\\"text-align:center;\\\">2737718350411000471304902466075202107250<\\/span>-->\\n                        <\\/th>\\n                        <th class=\\\"subtotales_conceptos\\\">TOTAL:<\\/th>\\n                        <th class=\\\"subtotales_importes\\\">$ 5.900,00<\\/th>\\n                    <\\/tr>\\n                <\\/table>\\n                <br>\\n                <table cellspacing=\\\"0\\\" width=\\\"100%\\\" style=\\\"border: none\\\">\\n                    <tr>\\n                        <th style=\\\"width:50%; text-align:left;\\\">\\n\\n                            <?xml version=\\\"1.0\\\" encoding=\\\"UTF-8\\\"?>\\n<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" version=\\\"1.1\\\" width=\\\"100\\\" height=\\\"100\\\" viewBox=\\\"0 0 100 100\\\"><rect x=\\\"0\\\" y=\\\"0\\\" width=\\\"100\\\" height=\\\"100\\\" fill=\\\"#ffffff\\\"\\/><g transform=\\\"scale(1.754)\\\"><g transform=\\\"translate(0,0)\\\"><path fill-rule=\\\"evenodd\\\" d=\\\"M8 0L8 1L9 1L9 2L8 2L8 5L9 5L9 4L10 4L10 5L12 5L12 4L11 4L11 3L12 3L12 0L11 0L11 2L10 2L10 1L9 1L9 0ZM14 0L14 2L13 2L13 4L14 4L14 3L15 3L15 5L17 5L17 4L16 4L16 3L17 3L17 2L18 2L18 1L17 1L17 2L15 2L15 1L16 1L16 0ZM22 0L22 1L23 1L23 2L22 2L22 3L21 3L21 4L20 4L20 5L21 5L21 4L22 4L22 10L21 10L21 11L20 11L20 12L19 12L19 10L20 10L20 9L21 9L21 8L20 8L20 7L21 7L21 6L20 6L20 7L19 7L19 6L18 6L18 7L17 7L17 6L16 6L16 7L15 7L15 6L14 6L14 5L13 5L13 6L12 6L12 7L11 7L11 6L10 6L10 7L9 7L9 6L8 6L8 7L9 7L9 8L8 8L8 9L9 9L9 10L10 10L10 11L9 11L9 13L8 13L8 10L6 10L6 11L5 11L5 13L4 13L4 15L3 15L3 13L2 13L2 12L4 12L4 10L5 10L5 9L4 9L4 8L0 8L0 9L1 9L1 10L0 10L0 11L1 11L1 12L0 12L0 13L2 13L2 17L4 17L4 18L3 18L3 19L2 19L2 18L1 18L1 22L0 22L0 23L1 23L1 22L3 22L3 24L2 24L2 25L4 25L4 27L3 27L3 28L4 28L4 31L3 31L3 29L2 29L2 28L0 28L0 30L2 30L2 31L0 31L0 32L2 32L2 33L0 33L0 34L2 34L2 35L1 35L1 36L0 36L0 41L1 41L1 42L2 42L2 40L1 40L1 38L3 38L3 39L4 39L4 42L5 42L5 43L8 43L8 41L7 41L7 40L11 40L11 39L10 39L10 38L12 38L12 39L13 39L13 40L12 40L12 42L13 42L13 41L14 41L14 39L15 39L15 38L17 38L17 39L16 39L16 40L15 40L15 42L16 42L16 43L17 43L17 45L18 45L18 46L16 46L16 45L14 45L14 44L13 44L13 43L11 43L11 42L10 42L10 41L9 41L9 43L10 43L10 44L5 44L5 45L10 45L10 46L9 46L9 47L8 47L8 48L6 48L6 49L8 49L8 50L11 50L11 49L12 49L12 51L10 51L10 52L9 52L9 53L8 53L8 57L9 57L9 55L11 55L11 52L12 52L12 51L13 51L13 52L14 52L14 51L15 51L15 53L14 53L14 54L15 54L15 53L16 53L16 54L17 54L17 55L18 55L18 56L17 56L17 57L18 57L18 56L19 56L19 57L21 57L21 55L22 55L22 53L21 53L21 54L20 54L20 51L21 51L21 52L23 52L23 50L24 50L24 53L25 53L25 54L23 54L23 56L22 56L22 57L24 57L24 56L26 56L26 55L25 55L25 54L27 54L27 53L31 53L31 54L33 54L33 55L32 55L32 56L34 56L34 57L36 57L36 55L38 55L38 56L37 56L37 57L44 57L44 56L43 56L43 55L42 55L42 56L41 56L41 55L40 55L40 54L42 54L42 53L40 53L40 52L43 52L43 53L45 53L45 52L46 52L46 51L45 51L45 49L47 49L47 48L48 48L48 50L47 50L47 53L46 53L46 54L44 54L44 55L45 55L45 56L46 56L46 57L47 57L47 56L48 56L48 57L49 57L49 56L48 56L48 55L50 55L50 57L51 57L51 55L50 55L50 54L49 54L49 53L51 53L51 54L52 54L52 53L55 53L55 54L56 54L56 53L57 53L57 51L56 51L56 49L57 49L57 48L56 48L56 49L55 49L55 51L53 51L53 49L54 49L54 48L53 48L53 46L54 46L54 45L56 45L56 46L55 46L55 47L57 47L57 44L53 44L53 46L52 46L52 43L51 43L51 44L50 44L50 42L51 42L51 41L50 41L50 40L51 40L51 39L52 39L52 38L51 38L51 37L50 37L50 36L51 36L51 35L52 35L52 37L54 37L54 38L53 38L53 39L54 39L54 41L53 41L53 40L52 40L52 42L54 42L54 43L55 43L55 42L57 42L57 40L56 40L56 38L57 38L57 31L56 31L56 30L57 30L57 27L56 27L56 24L57 24L57 21L56 21L56 20L53 20L53 19L54 19L54 18L55 18L55 14L54 14L54 10L53 10L53 9L55 9L55 10L56 10L56 11L55 11L55 12L57 12L57 8L56 8L56 9L55 9L55 8L52 8L52 10L51 10L51 11L50 11L50 10L49 10L49 9L50 9L50 8L48 8L48 7L49 7L49 6L48 6L48 7L47 7L47 5L48 5L48 0L45 0L45 1L43 1L43 0L39 0L39 1L41 1L41 4L40 4L40 5L39 5L39 2L38 2L38 1L37 1L37 2L36 2L36 1L32 1L32 2L31 2L31 0L30 0L30 1L29 1L29 0L28 0L28 1L26 1L26 0L24 0L24 1L23 1L23 0ZM19 1L19 2L21 2L21 1ZM25 1L25 2L23 2L23 3L22 3L22 4L23 4L23 3L24 3L24 5L23 5L23 10L22 10L22 11L21 11L21 12L22 12L22 13L23 13L23 14L24 14L24 16L23 16L23 15L22 15L22 14L20 14L20 13L19 13L19 12L18 12L18 10L19 10L19 9L20 9L20 8L18 8L18 9L17 9L17 8L15 8L15 7L14 7L14 6L13 6L13 7L14 7L14 9L13 9L13 8L11 8L11 7L10 7L10 8L9 8L9 9L13 9L13 10L12 10L12 12L11 12L11 11L10 11L10 12L11 12L11 13L10 13L10 15L9 15L9 14L8 14L8 13L5 13L5 14L8 14L8 15L4 15L4 17L5 17L5 18L4 18L4 19L5 19L5 18L7 18L7 19L6 19L6 20L5 20L5 21L6 21L6 22L7 22L7 23L6 23L6 24L7 24L7 25L6 25L6 26L9 26L9 25L10 25L10 24L9 24L9 22L8 22L8 21L6 21L6 20L9 20L9 21L10 21L10 19L11 19L11 20L12 20L12 21L11 21L11 22L10 22L10 23L12 23L12 24L11 24L11 25L12 25L12 27L13 27L13 28L11 28L11 27L9 27L9 30L10 30L10 32L8 32L8 31L5 31L5 33L4 33L4 32L3 32L3 31L2 31L2 32L3 32L3 33L4 33L4 34L3 34L3 35L2 35L2 36L1 36L1 37L3 37L3 38L4 38L4 36L7 36L7 37L6 37L6 38L5 38L5 39L6 39L6 40L7 40L7 39L9 39L9 38L7 38L7 37L8 37L8 36L9 36L9 37L10 37L10 36L11 36L11 35L12 35L12 34L11 34L11 29L12 29L12 30L13 30L13 31L12 31L12 32L13 32L13 35L15 35L15 34L16 34L16 35L17 35L17 36L16 36L16 37L17 37L17 38L18 38L18 39L17 39L17 40L16 40L16 41L17 41L17 42L18 42L18 43L20 43L20 44L19 44L19 46L18 46L18 47L17 47L17 48L18 48L18 47L20 47L20 48L19 48L19 50L17 50L17 49L16 49L16 48L15 48L15 47L16 47L16 46L15 46L15 47L14 47L14 48L13 48L13 47L11 47L11 48L10 48L10 49L11 49L11 48L12 48L12 49L14 49L14 50L15 50L15 49L16 49L16 53L17 53L17 52L18 52L18 53L19 53L19 52L18 52L18 51L20 51L20 48L22 48L22 49L23 49L23 48L22 48L22 47L24 47L24 46L22 46L22 44L23 44L23 45L25 45L25 46L27 46L27 44L28 44L28 47L26 47L26 48L24 48L24 50L25 50L25 49L26 49L26 48L28 48L28 47L29 47L29 48L30 48L30 47L32 47L32 50L31 50L31 51L32 51L32 50L33 50L33 51L35 51L35 52L36 52L36 53L35 53L35 55L34 55L34 56L35 56L35 55L36 55L36 53L37 53L37 54L38 54L38 55L39 55L39 56L40 56L40 55L39 55L39 53L37 53L37 51L38 51L38 52L40 52L40 50L41 50L41 51L42 51L42 50L43 50L43 51L44 51L44 49L45 49L45 48L46 48L46 46L47 46L47 45L48 45L48 44L49 44L49 42L50 42L50 41L47 41L47 42L48 42L48 43L46 43L46 44L45 44L45 42L46 42L46 40L47 40L47 39L48 39L48 38L47 38L47 37L48 37L48 36L50 36L50 33L51 33L51 31L50 31L50 33L48 33L48 31L46 31L46 32L45 32L45 31L44 31L44 32L43 32L43 29L44 29L44 30L45 30L45 29L44 29L44 27L46 27L46 29L47 29L47 30L48 30L48 27L47 27L47 24L48 24L48 26L50 26L50 25L51 25L51 23L52 23L52 25L53 25L53 27L55 27L55 29L54 29L54 28L53 28L53 29L54 29L54 32L53 32L53 31L52 31L52 34L54 34L54 32L55 32L55 35L54 35L54 37L55 37L55 38L54 38L54 39L55 39L55 38L56 38L56 36L55 36L55 35L56 35L56 32L55 32L55 30L56 30L56 27L55 27L55 22L56 22L56 21L55 21L55 22L54 22L54 21L53 21L53 22L51 22L51 21L52 21L52 20L51 20L51 19L50 19L50 20L49 20L49 17L50 17L50 18L51 18L51 17L52 17L52 19L53 19L53 17L54 17L54 14L52 14L52 13L53 13L53 10L52 10L52 11L51 11L51 12L52 12L52 13L51 13L51 15L49 15L49 17L47 17L47 16L46 16L46 15L47 15L47 13L48 13L48 14L50 14L50 12L49 12L49 10L48 10L48 8L47 8L47 9L46 9L46 10L48 10L48 11L46 11L46 12L47 12L47 13L46 13L46 14L45 14L45 12L44 12L44 13L43 13L43 12L42 12L42 13L41 13L41 9L44 9L44 10L43 10L43 11L45 11L45 7L46 7L46 5L47 5L47 3L46 3L46 2L47 2L47 1L45 1L45 3L44 3L44 5L43 5L43 4L41 4L41 7L42 7L42 8L41 8L41 9L39 9L39 8L38 8L38 9L37 9L37 8L35 8L35 7L36 7L36 6L37 6L37 7L38 7L38 6L37 6L37 5L38 5L38 3L37 3L37 5L35 5L35 4L34 4L34 5L33 5L33 7L32 7L32 4L33 4L33 3L34 3L34 2L33 2L33 3L31 3L31 8L32 8L32 9L31 9L31 10L33 10L33 11L34 11L34 10L35 10L35 13L34 13L34 14L32 14L32 15L33 15L33 17L30 17L30 18L28 18L28 19L27 19L27 17L29 17L29 16L30 16L30 15L29 15L29 13L30 13L30 14L31 14L31 13L33 13L33 12L31 12L31 11L26 11L26 12L25 12L25 11L24 11L24 8L25 8L25 10L27 10L27 9L26 9L26 8L25 8L25 7L26 7L26 6L25 6L25 5L26 5L26 4L25 4L25 2L26 2L26 3L28 3L28 4L30 4L30 3L29 3L29 2L26 2L26 1ZM9 2L9 3L10 3L10 2ZM18 3L18 5L19 5L19 3ZM45 3L45 5L46 5L46 3ZM27 5L27 8L30 8L30 5ZM42 5L42 7L43 7L43 8L44 8L44 7L45 7L45 6L44 6L44 7L43 7L43 5ZM24 6L24 7L25 7L25 6ZM28 6L28 7L29 7L29 6ZM34 6L34 7L35 7L35 6ZM39 6L39 7L40 7L40 6ZM6 8L6 9L7 9L7 8ZM3 9L3 10L4 10L4 9ZM14 9L14 11L15 11L15 13L13 13L13 12L12 12L12 13L13 13L13 15L12 15L12 16L11 16L11 17L10 17L10 16L9 16L9 17L10 17L10 18L11 18L11 19L12 19L12 20L13 20L13 19L15 19L15 18L17 18L17 17L18 17L18 19L16 19L16 20L14 20L14 21L15 21L15 23L16 23L16 24L14 24L14 23L13 23L13 21L12 21L12 23L13 23L13 24L12 24L12 25L13 25L13 26L14 26L14 28L16 28L16 30L15 30L15 29L13 29L13 30L15 30L15 31L13 31L13 32L14 32L14 34L15 34L15 31L17 31L17 32L18 32L18 28L19 28L19 30L20 30L20 28L19 28L19 27L21 27L21 28L23 28L23 30L22 30L22 29L21 29L21 30L22 30L22 31L20 31L20 33L21 33L21 32L22 32L22 35L26 35L26 36L25 36L25 37L27 37L27 35L28 35L28 37L29 37L29 39L30 39L30 38L31 38L31 40L27 40L27 42L29 42L29 41L30 41L30 44L29 44L29 43L28 43L28 44L29 44L29 45L30 45L30 46L31 46L31 45L32 45L32 47L33 47L33 46L34 46L34 48L33 48L33 50L34 50L34 48L35 48L35 47L36 47L36 49L35 49L35 51L36 51L36 49L37 49L37 48L38 48L38 45L37 45L37 47L36 47L36 45L35 45L35 46L34 46L34 45L32 45L32 43L31 43L31 41L33 41L33 43L35 43L35 44L37 44L37 42L38 42L38 44L39 44L39 47L40 47L40 45L41 45L41 48L42 48L42 49L43 49L43 48L45 48L45 45L44 45L44 44L43 44L43 43L42 43L42 45L41 45L41 43L40 43L40 44L39 44L39 42L38 42L38 41L37 41L37 42L36 42L36 40L35 40L35 39L38 39L38 40L39 40L39 41L40 41L40 42L42 42L42 41L43 41L43 42L45 42L45 40L46 40L46 38L45 38L45 37L46 37L46 36L48 36L48 35L49 35L49 34L48 34L48 33L47 33L47 32L46 32L46 33L44 33L44 35L43 35L43 32L42 32L42 33L41 33L41 31L40 31L40 30L41 30L41 29L43 29L43 27L42 27L42 28L41 28L41 26L40 26L40 25L39 25L39 24L40 24L40 23L41 23L41 25L42 25L42 24L43 24L43 25L44 25L44 26L45 26L45 25L44 25L44 24L47 24L47 23L48 23L48 22L49 22L49 20L48 20L48 18L47 18L47 17L46 17L46 16L45 16L45 15L44 15L44 14L42 14L42 15L41 15L41 13L40 13L40 10L39 10L39 13L38 13L38 12L37 12L37 9L36 9L36 13L35 13L35 15L39 15L39 16L38 16L38 17L37 17L37 19L36 19L36 18L35 18L35 17L36 17L36 16L35 16L35 17L33 17L33 18L31 18L31 19L35 19L35 20L37 20L37 22L36 22L36 21L35 21L35 22L32 22L32 20L30 20L30 19L28 19L28 20L27 20L27 19L25 19L25 18L24 18L24 19L22 19L22 18L21 18L21 19L20 19L20 16L19 16L19 17L18 17L18 16L17 16L17 14L18 14L18 12L17 12L17 11L16 11L16 10L15 10L15 9ZM28 9L28 10L30 10L30 9ZM1 10L1 11L2 11L2 10ZM6 11L6 12L7 12L7 11ZM23 12L23 13L24 13L24 12ZM26 12L26 14L25 14L25 16L24 16L24 17L25 17L25 16L26 16L26 15L27 15L27 12ZM15 13L15 14L14 14L14 15L13 15L13 18L12 18L12 19L13 19L13 18L14 18L14 15L15 15L15 16L16 16L16 14L17 14L17 13ZM36 13L36 14L38 14L38 13ZM39 13L39 15L40 15L40 13ZM0 14L0 15L1 15L1 14ZM19 14L19 15L20 15L20 14ZM28 15L28 16L29 16L29 15ZM42 15L42 16L39 16L39 17L38 17L38 18L41 18L41 17L42 17L42 18L43 18L43 22L44 22L44 23L45 23L45 22L44 22L44 21L46 21L46 22L48 22L48 21L47 21L47 20L45 20L45 19L46 19L46 17L44 17L44 18L43 18L43 17L42 17L42 16L43 16L43 15ZM52 15L52 16L53 16L53 15ZM5 16L5 17L8 17L8 16ZM56 16L56 18L57 18L57 16ZM18 19L18 20L17 20L17 21L16 21L16 23L18 23L18 22L19 22L19 23L20 23L20 24L19 24L19 25L18 25L18 26L17 26L17 25L16 25L16 26L15 26L15 25L14 25L14 26L15 26L15 27L16 27L16 28L17 28L17 27L19 27L19 25L20 25L20 24L22 24L22 25L23 25L23 26L24 26L24 27L25 27L25 29L24 29L24 32L25 32L25 34L26 34L26 35L27 35L27 34L30 34L30 35L29 35L29 36L30 36L30 35L31 35L31 38L33 38L33 36L32 36L32 34L31 34L31 33L33 33L33 34L36 34L36 35L37 35L37 34L38 34L38 36L37 36L37 37L39 37L39 38L38 38L38 39L40 39L40 41L42 41L42 38L44 38L44 39L45 39L45 38L44 38L44 37L45 37L45 36L46 36L46 34L47 34L47 33L46 33L46 34L45 34L45 36L41 36L41 35L42 35L42 34L39 34L39 33L40 33L40 32L38 32L38 31L37 31L37 32L35 32L35 33L33 33L33 32L34 32L34 30L33 30L33 31L32 31L32 30L31 30L31 33L30 33L30 31L26 31L26 32L25 32L25 29L26 29L26 25L25 25L25 23L26 23L26 24L28 24L28 26L31 26L31 27L33 27L33 28L34 28L34 29L35 29L35 31L36 31L36 29L37 29L37 30L39 30L39 29L41 29L41 28L38 28L38 29L37 29L37 27L38 27L38 24L39 24L39 23L38 23L38 24L37 24L37 26L35 26L35 25L36 25L36 23L35 23L35 25L34 25L34 23L33 23L33 24L32 24L32 22L31 22L31 23L30 23L30 20L29 20L29 21L28 21L28 22L27 22L27 21L25 21L25 23L22 23L22 19L21 19L21 21L20 21L20 19ZM24 19L24 20L25 20L25 19ZM37 19L37 20L38 20L38 19ZM39 19L39 20L40 20L40 19ZM41 19L41 20L42 20L42 19ZM3 20L3 22L4 22L4 20ZM33 20L33 21L34 21L34 20ZM50 20L50 21L51 21L51 20ZM17 21L17 22L18 22L18 21ZM19 21L19 22L20 22L20 21ZM23 21L23 22L24 22L24 21ZM38 21L38 22L40 22L40 21ZM26 22L26 23L27 23L27 22ZM53 22L53 23L54 23L54 22ZM4 23L4 24L5 24L5 23ZM49 23L49 25L50 25L50 23ZM0 24L0 26L1 26L1 24ZM31 24L31 26L34 26L34 25L32 25L32 24ZM39 26L39 27L40 27L40 26ZM5 27L5 30L8 30L8 27ZM27 27L27 30L30 30L30 27ZM49 27L49 30L52 30L52 27ZM6 28L6 29L7 29L7 28ZM10 28L10 29L11 29L11 28ZM28 28L28 29L29 29L29 28ZM31 28L31 29L32 29L32 28ZM35 28L35 29L36 29L36 28ZM50 28L50 29L51 29L51 28ZM22 31L22 32L23 32L23 31ZM6 32L6 33L5 33L5 34L4 34L4 35L3 35L3 36L4 36L4 35L7 35L7 34L10 34L10 35L9 35L9 36L10 36L10 35L11 35L11 34L10 34L10 33L8 33L8 32ZM26 32L26 33L27 33L27 32ZM37 32L37 33L38 33L38 32ZM6 33L6 34L7 34L7 33ZM23 33L23 34L24 34L24 33ZM17 34L17 35L18 35L18 34ZM19 34L19 35L20 35L20 38L21 38L21 37L22 37L22 38L24 38L24 36L23 36L23 37L22 37L22 36L21 36L21 34ZM12 36L12 38L13 38L13 39L14 39L14 37L13 37L13 36ZM18 36L18 38L19 38L19 36ZM34 36L34 39L33 39L33 40L34 40L34 39L35 39L35 38L36 38L36 37L35 37L35 36ZM39 36L39 37L40 37L40 39L41 39L41 37L40 37L40 36ZM6 38L6 39L7 39L7 38ZM26 38L26 39L28 39L28 38ZM50 38L50 39L51 39L51 38ZM18 39L18 40L20 40L20 39ZM21 39L21 40L22 40L22 39ZM24 39L24 40L23 40L23 42L24 42L24 41L25 41L25 44L26 44L26 41L25 41L25 39ZM55 40L55 41L54 41L54 42L55 42L55 41L56 41L56 40ZM6 41L6 42L7 42L7 41ZM18 41L18 42L20 42L20 41ZM21 41L21 43L22 43L22 41ZM2 43L2 44L3 44L3 46L2 46L2 47L1 47L1 45L0 45L0 48L5 48L5 47L7 47L7 46L5 46L5 47L3 47L3 46L4 46L4 44L3 44L3 43ZM23 43L23 44L24 44L24 43ZM11 44L11 46L14 46L14 45L12 45L12 44ZM20 44L20 45L21 45L21 44ZM30 44L30 45L31 45L31 44ZM43 45L43 47L42 47L42 48L43 48L43 47L44 47L44 45ZM49 45L49 48L50 48L50 46L51 46L51 45ZM20 46L20 47L21 47L21 46ZM51 47L51 48L52 48L52 47ZM14 48L14 49L15 49L15 48ZM39 48L39 49L38 49L38 51L39 51L39 50L40 50L40 48ZM27 49L27 52L30 52L30 49ZM49 49L49 52L52 52L52 49ZM21 50L21 51L22 51L22 50ZM28 50L28 51L29 51L29 50ZM50 50L50 51L51 51L51 50ZM25 51L25 52L26 52L26 51ZM55 51L55 53L56 53L56 51ZM31 52L31 53L32 53L32 52ZM33 52L33 54L34 54L34 52ZM9 53L9 54L10 54L10 53ZM12 53L12 56L13 56L13 57L14 57L14 56L15 56L15 55L14 55L14 56L13 56L13 53ZM18 54L18 55L19 55L19 54ZM47 54L47 55L48 55L48 54ZM27 55L27 57L31 57L31 56L30 56L30 55L29 55L29 56L28 56L28 55ZM53 55L53 56L52 56L52 57L55 57L55 56L54 56L54 55ZM56 55L56 56L57 56L57 55ZM0 0L0 7L7 7L7 0ZM1 1L1 6L6 6L6 1ZM2 2L2 5L5 5L5 2ZM50 0L50 7L57 7L57 0ZM51 1L51 6L56 6L56 1ZM52 2L52 5L55 5L55 2ZM0 50L0 57L7 57L7 50ZM1 51L1 56L6 56L6 51ZM2 52L2 55L5 55L5 52Z\\\" fill=\\\"#000000\\\"\\/><\\/g><\\/g><\\/svg>\\n\\n                            <span style=\\\"width:50%;\\\">\\n                                <img style=\\\"max-height: 70px\\\"\\n                                     src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/img\\/AfipComprobanteAutorizado.png\\\">\\n                            <\\/span>\\n                        <\\/th>\\n                        <th style=\\\"text-align:right;\\\">\\n                            <p>CAE N&#186;: 71304902466075<br>\\n                                Fecha Vto. CAE:  25\\/07\\/2021\\n                            <\\/p>\\n                        <\\/th>\\n                    <\\/tr>\\n                <\\/table>\\n                    <\\/div>\\n    <\\/div>\\n\\n    <\\/body>\\n<\\/html>\\\";s:4:\\\"file\\\";N;}s:6:\\\"locale\\\";N;s:4:\\\"from\\\";a:0:{}s:2:\\\"to\\\";a:1:{i:0;a:2:{s:4:\\\"name\\\";N;s:7:\\\"address\\\";s:25:\\\"limpiezaorbol@hotmail.com\\\";}}s:2:\\\"cc\\\";a:0:{}s:3:\\\"bcc\\\";a:1:{i:0;a:2:{s:4:\\\"name\\\";N;s:7:\\\"address\\\";s:23:\\\"info@masquecontable.com\\\";}}s:7:\\\"replyTo\\\";a:0:{}s:7:\\\"subject\\\";N;s:11:\\\"\\u0000*\\u0000markdown\\\";N;s:7:\\\"\\u0000*\\u0000html\\\";N;s:4:\\\"view\\\";N;s:8:\\\"textView\\\";N;s:8:\\\"viewData\\\";a:0:{}s:11:\\\"attachments\\\";a:0:{}s:14:\\\"rawAttachments\\\";a:0:{}s:15:\\\"diskAttachments\\\";a:0:{}s:9:\\\"callbacks\\\";a:0:{}s:5:\\\"theme\\\";N;s:6:\\\"mailer\\\";s:8:\\\"sendgrid\\\";s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:5:\\\"delay\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;}\"}}','ErrorException: Trying to get property \'id\' of non-object in /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php:16\nStack trace:\n#0 /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php(16): Illuminate\\Foundation\\Bootstrap\\HandleExceptions->handleError(8, \'Trying to get p...\', \'/home/forge/tax...\', 16, Array)\n#1 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(356): App\\Queue\\DatabaseJob->fire()\n#2 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(306): Illuminate\\Queue\\Worker->process(\'database\', Object(App\\Queue\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#3 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(132): Illuminate\\Queue\\Worker->runJob(Object(App\\Queue\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#4 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(112): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#5 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(96): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#6 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#7 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#8 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#9 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#10 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#11 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(134): Illuminate\\Container\\Container->call(Array)\n#12 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(256): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#13 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(121): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#14 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(971): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#15 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(290): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#16 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(166): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#17 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Application.php(93): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(129): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#19 /home/forge/taxes.com.ar/artisan(35): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#20 {main}','2021-07-23 18:03:50',NULL);
INSERT INTO `failed_jobs` VALUES (4,NULL,'database','default','{\"uuid\":\"64c62ff2-d7b4-42c2-b7e3-b81834ddb2b4\",\"displayName\":\"App\\\\Mail\\\\Fact_Electronica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"delay\":null,\"timeout\":null,\"timeoutAt\":null,\"data\":{\"commandName\":\"Illuminate\\\\Mail\\\\SendQueuedMailable\",\"command\":\"O:34:\\\"Illuminate\\\\Mail\\\\SendQueuedMailable\\\":3:{s:8:\\\"mailable\\\";O:25:\\\"App\\\\Mail\\\\Fact_Electronica\\\":27:{s:11:\\\"informacion\\\";a:6:{s:12:\\\"ruta_logo_fa\\\";N;s:4:\\\"mail\\\";s:23:\\\"info@masquecontable.com\\\";s:18:\\\"name_quien_factura\\\";s:19:\\\"MICAELA AILIN CORIA\\\";s:7:\\\"cliente\\\";O:17:\\\"App\\\\Models\\\\Person\\\":27:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:7:\\\"persons\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:40750;s:7:\\\"user_id\\\";i:5117;s:11:\\\"field_name1\\\";s:24:\\\"BOVA CARDOSO JUAN MANUEL\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"20-33108455-8\\\";s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-07-05 19:34:21\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-07-21 16:40:14\\\";s:11:\\\"activity_id\\\";i:1;s:7:\\\"address\\\";s:86:\\\"Direccion\\r\\n20 1690\\r\\nCod. Postal\\r\\n1900\\r\\nProvincia\\r\\nBUENOS AIRES\\r\\nTipo Domicilio\\r\\nFISCAL\\\";s:14:\\\"person_type_id\\\";i:1;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:40750;s:7:\\\"user_id\\\";i:5117;s:11:\\\"field_name1\\\";s:24:\\\"BOVA CARDOSO JUAN MANUEL\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"20-33108455-8\\\";s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-07-05 19:34:21\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-07-21 16:40:14\\\";s:11:\\\"activity_id\\\";i:1;s:7:\\\"address\\\";s:86:\\\"Direccion\\r\\n20 1690\\r\\nCod. Postal\\r\\n1900\\r\\nProvincia\\r\\nBUENOS AIRES\\r\\nTipo Domicilio\\r\\nFISCAL\\\";s:14:\\\"person_type_id\\\";i:1;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}s:14:\\\"nombre_del_pdf\\\";s:28:\\\"Factura N\\u00b00004-00000007.pdf\\\";s:9:\\\"body_mail\\\";s:155:\\\"Estimado cliente, se env\\u00eda adjunta la factura de honorarios correspondientes al mes de Julio 2021.\\nMuchas gracias por seguir eligiendo nuestros servicios.\\\";}s:3:\\\"pdf\\\";O:26:\\\"Barryvdh\\\\Snappy\\\\PdfWrapper\\\":4:{s:9:\\\"\\u0000*\\u0000snappy\\\";O:35:\\\"Barryvdh\\\\Snappy\\\\IlluminateSnappyPdf\\\":10:{s:26:\\\"\\u0000*\\u0000optionsWithContentCheck\\\";a:4:{s:11:\\\"header-html\\\";s:4:\\\"html\\\";s:11:\\\"footer-html\\\";s:4:\\\"html\\\";s:5:\\\"cover\\\";s:4:\\\"html\\\";s:15:\\\"xsl-style-sheet\\\";s:3:\\\"xsl\\\";}s:36:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000binary\\\";s:76:\\\"\\/home\\/forge\\/taxes.com.ar\\/vendor\\/h4cc\\/wkhtmltopdf-amd64\\/bin\\/wkhtmltopdf-amd64\\\";s:37:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000options\\\";a:132:{s:7:\\\"collate\\\";N;s:10:\\\"no-collate\\\";N;s:10:\\\"cookie-jar\\\";N;s:6:\\\"copies\\\";i:1;s:3:\\\"dpi\\\";N;s:13:\\\"extended-help\\\";N;s:9:\\\"grayscale\\\";N;s:4:\\\"help\\\";N;s:7:\\\"htmldoc\\\";N;s:18:\\\"ignore-load-errors\\\";N;s:9:\\\"image-dpi\\\";N;s:13:\\\"image-quality\\\";N;s:7:\\\"license\\\";N;s:9:\\\"log-level\\\";N;s:10:\\\"lowquality\\\";b:1;s:7:\\\"manpage\\\";N;s:13:\\\"margin-bottom\\\";N;s:11:\\\"margin-left\\\";N;s:12:\\\"margin-right\\\";N;s:10:\\\"margin-top\\\";N;s:11:\\\"orientation\\\";N;s:11:\\\"page-height\\\";N;s:9:\\\"page-size\\\";s:2:\\\"a4\\\";s:10:\\\"page-width\\\";N;s:18:\\\"no-pdf-compression\\\";N;s:5:\\\"quiet\\\";N;s:20:\\\"read-args-from-stdin\\\";N;s:6:\\\"readme\\\";N;s:5:\\\"title\\\";N;s:11:\\\"use-xserver\\\";N;s:7:\\\"version\\\";N;s:20:\\\"dump-default-toc-xsl\\\";N;s:12:\\\"dump-outline\\\";N;s:7:\\\"outline\\\";N;s:10:\\\"no-outline\\\";N;s:13:\\\"outline-depth\\\";N;s:13:\\\"output-format\\\";N;s:5:\\\"allow\\\";N;s:10:\\\"background\\\";N;s:13:\\\"no-background\\\";N;s:16:\\\"bypass-proxy-for\\\";N;s:9:\\\"cache-dir\\\";N;s:20:\\\"checkbox-checked-svg\\\";N;s:12:\\\"checkbox-svg\\\";N;s:6:\\\"cookie\\\";N;s:13:\\\"custom-header\\\";N;s:25:\\\"custom-header-propagation\\\";N;s:28:\\\"no-custom-header-propagation\\\";N;s:16:\\\"debug-javascript\\\";N;s:19:\\\"no-debug-javascript\\\";N;s:14:\\\"default-header\\\";N;s:8:\\\"encoding\\\";N;s:22:\\\"disable-external-links\\\";N;s:21:\\\"enable-external-links\\\";N;s:13:\\\"disable-forms\\\";N;s:12:\\\"enable-forms\\\";N;s:6:\\\"images\\\";N;s:9:\\\"no-images\\\";N;s:22:\\\"disable-internal-links\\\";N;s:21:\\\"enable-internal-links\\\";N;s:18:\\\"disable-javascript\\\";N;s:17:\\\"enable-javascript\\\";N;s:16:\\\"javascript-delay\\\";N;s:19:\\\"keep-relative-links\\\";N;s:19:\\\"load-error-handling\\\";N;s:25:\\\"load-media-error-handling\\\";N;s:25:\\\"disable-local-file-access\\\";N;s:24:\\\"enable-local-file-access\\\";N;s:17:\\\"minimum-font-size\\\";N;s:20:\\\"exclude-from-outline\\\";N;s:18:\\\"include-in-outline\\\";N;s:11:\\\"page-offset\\\";N;s:8:\\\"password\\\";N;s:15:\\\"disable-plugins\\\";N;s:14:\\\"enable-plugins\\\";N;s:4:\\\"post\\\";N;s:9:\\\"post-file\\\";N;s:16:\\\"print-media-type\\\";N;s:19:\\\"no-print-media-type\\\";N;s:5:\\\"proxy\\\";N;s:21:\\\"proxy-hostname-lookup\\\";N;s:23:\\\"radiobutton-checked-svg\\\";N;s:15:\\\"radiobutton-svg\\\";N;s:14:\\\"redirect-delay\\\";N;s:22:\\\"resolve-relative-links\\\";N;s:10:\\\"run-script\\\";N;s:23:\\\"disable-smart-shrinking\\\";N;s:22:\\\"enable-smart-shrinking\\\";N;s:12:\\\"ssl-crt-path\\\";N;s:16:\\\"ssl-key-password\\\";N;s:12:\\\"ssl-key-path\\\";N;s:17:\\\"stop-slow-scripts\\\";N;s:20:\\\"no-stop-slow-scripts\\\";N;s:22:\\\"disable-toc-back-links\\\";N;s:21:\\\"enable-toc-back-links\\\";N;s:16:\\\"user-style-sheet\\\";N;s:8:\\\"username\\\";N;s:13:\\\"viewport-size\\\";N;s:13:\\\"window-status\\\";N;s:4:\\\"zoom\\\";N;s:13:\\\"footer-center\\\";s:25:\\\"Pagina [page] de [toPage]\\\";s:16:\\\"footer-font-name\\\";N;s:16:\\\"footer-font-size\\\";i:8;s:11:\\\"footer-html\\\";N;s:11:\\\"footer-left\\\";s:0:\\\"\\\";s:11:\\\"footer-line\\\";N;s:14:\\\"no-footer-line\\\";N;s:12:\\\"footer-right\\\";N;s:14:\\\"footer-spacing\\\";N;s:13:\\\"header-center\\\";N;s:16:\\\"header-font-name\\\";N;s:16:\\\"header-font-size\\\";N;s:11:\\\"header-html\\\";N;s:11:\\\"header-left\\\";N;s:11:\\\"header-line\\\";N;s:14:\\\"no-header-line\\\";N;s:12:\\\"header-right\\\";N;s:14:\\\"header-spacing\\\";N;s:7:\\\"replace\\\";N;s:5:\\\"cover\\\";N;s:3:\\\"toc\\\";N;s:20:\\\"disable-dotted-lines\\\";N;s:9:\\\"toc-depth\\\";N;s:13:\\\"toc-font-name\\\";N;s:16:\\\"toc-l1-font-size\\\";N;s:15:\\\"toc-header-text\\\";N;s:20:\\\"toc-header-font-name\\\";N;s:20:\\\"toc-header-font-size\\\";N;s:21:\\\"toc-level-indentation\\\";N;s:17:\\\"disable-toc-links\\\";N;s:20:\\\"toc-text-size-shrink\\\";N;s:15:\\\"xsl-style-sheet\\\";N;}s:33:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000env\\\";N;s:37:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000timeout\\\";b:0;s:46:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000defaultExtension\\\";s:3:\\\"pdf\\\";s:18:\\\"\\u0000*\\u0000temporaryFolder\\\";N;s:14:\\\"temporaryFiles\\\";a:0:{}s:36:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000logger\\\";O:18:\\\"Psr\\\\Log\\\\NullLogger\\\":0:{}s:2:\\\"fs\\\";O:32:\\\"Illuminate\\\\Filesystem\\\\Filesystem\\\":0:{}}s:10:\\\"\\u0000*\\u0000options\\\";a:0:{}s:4:\\\"html\\\";s:22270:\\\"<!DOCTYPE html>\\n<html lang=\\\"en\\\">\\n    <head>\\n        <meta charset=\\\"utf-8\\\">\\n    <\\/head>\\n    <style>\\n        .subtotales_conceptos{\\n            width:30%;\\n            text-align: right;\\n        }\\n        .subtotales_importes{\\n            text-align: right;\\n        }\\n        .table-totales, .table-totales tr, .table-totales th{\\n            border: 1px solid;\\n        }\\n\\n    <\\/style>\\n    <body>\\n    <div style=\\\"max-height:840px\\\">\\n        <div style=\\\"width: 100%; height:270px\\\"> <!-- Datos de la empresa -->\\n            <table class=\\\"display\\\" cellspacing=\\\"0\\\" width=\\\"100%\\\" style=\\\"border:  1px solid;\\\">\\n                <tr style=\\\"\\\">\\n                    <th colspan=\\\"2\\\" rowspan=\\\"2\\\" style=\\\"width:45%;margin:0;height:150px;\\\">\\n                                                <img src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/img\\/\\/27377183504\\/logo_punto_venta_0000.png\\\"\\/>\\n                                            <\\/th>\\n                    <th style=\\\"border:  1px solid;text-align: center; width:10%\\\" colspan=\\\"2\\\">\\n                        <span style=\\\"font-size: 60px;\\\">C<\\/span> <br \\/> <span style=\\\"font-size: 14px;\\\">cod. 11<\\/span>\\n                    <\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"font-size: 28px;text-align: center;width:45%\\\">\\n                        Factura\\n                        <br>\\n                        0004 - 00000007\\n                    <\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th><\\/th>\\n                    <th style=\\\"border:  1px 1px 1px 0px solid;\\\" colspan=\\\"2\\\"><\\/th>\\n                    <th><\\/th>\\n                <\\/tr>\\n                <tr>\\n\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                                                    Raz&oacute;n Social:\\n                            <span style=\\\"font-weight: normal;\\\">MICAELA AILIN CORIA<\\/span>\\n                                            <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">Fecha de Emisi&oacute;n: <span style=\\\"font-weight: normal;\\\">15\\/07\\/2021<\\/span><\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Domicilio Comercial: <span style=\\\"font-weight: normal;\\\">Victor Guillet esq. Arturo M Bas, C.P.:5800,\\n                        C\\u00f3rdoba<\\/span>\\n                    <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">CUIT: <span style=\\\"font-weight: normal;\\\">27-37718350-4<\\/span><\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Condici&oacute;n frente al IVA: <span style=\\\"font-weight: normal;\\\">Monotributo<\\/span>\\n                    <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Ingresos Brutos: <span style=\\\"font-weight: normal;\\\"><\\/span>\\n                        <br>\\n                        Fecha de Inicio de Actividades: <span style=\\\"font-weight: normal;\\\">09\\/07\\/2021<\\/span>\\n                    <\\/th>\\n                <\\/tr>\\n            <\\/table>\\n        <\\/div>\\n\\n        <table style=\\\"text-align: center; width: 100%;border: solid 1px;\\\"> <!-- Fechas -->\\n            <thead>\\n                <tr>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Per\\u00edodo Facturado Desde: 01\\/07\\/2021<\\/small><\\/th>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Per\\u00edodo Facturado Hasta: 31\\/07\\/2021<\\/small><\\/th>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Fecha Vto. Pago: 15\\/07\\/2021<\\/small><\\/th>\\n                <\\/tr>\\n            <\\/thead>\\n        <\\/table>\\n        \\n        <table style=\\\"width: 100%; margin-top: 1%;border: solid 1px;\\\"> <!-- Datos Clientes -->\\n            <tr>\\n                <th style=\\\"text-align:left;\\\"colspan=\\\"12\\\">\\n                    CUIT: <span style=\\\"font-weight: normal;\\\">20-33108455-8<\\/span>\\n                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\\n                    Apellido y Nombre \\/ Raz&oacute;n Social: <span style=\\\"font-weight: normal;\\\">\\n                    BOVA CARDOSO JUAN MANUEL<\\/span>\\n                <\\/th>\\n            <\\/tr>\\n            <tr>\\n                <th style=\\\"text-align:left; width:50%\\\">\\n                    Condici&oacute;n Frente al IVA: <span style=\\\"font-weight: normal;\\\">Responsable Monotributo<\\/span>\\n                <\\/th>\\n                <th style=\\\"text-align:left; width:50%\\\" colspan=\\\"4\\\">\\n                    Domicilio Comercial:\\n                    <span style=\\\"font-weight: normal;\\\">\\n                    Direccion\\r\\n20 1690\\r\\nCod. Postal\\r\\n1900\\r\\nProvincia\\r\\nBUENOS AIRES\\r\\nTipo Domicilio\\r\\nFISCAL\\n                    <\\/span>\\n                <\\/th>\\n            <\\/tr>\\n            <tr style=\\\"text-align:left\\\">\\n                <th>Condici&oacute;n de Venta: <span style=\\\"font-weight: normal;\\\">Cuenta Corriente<\\/span><\\/th>\\n            <\\/tr>\\n        <\\/table>\\n\\n        <div style=\\\"border: 1px solid;margin-top: 1%;min-height:600px;\\\">\\n        <table style=\\\"text-align: center; width: 100%; margin-top: 1%;\\\"> <!-- Body -->\\n            <tr style=\\\"border-bottom: 1px solid;font-size: 15px\\\">\\n                <th>C&oacute;digo<\\/th>\\n                <th style=\\\"width: 25%;\\\">Detalle<\\/th>\\n                <th>Cantidad<\\/th>\\n                <th>U.Medida<\\/th>\\n                <th>Precio U.<\\/th>\\n                <th>Bonif. (%)<\\/th>\\n                <th>Precio Bonif.<\\/th>\\n                <th>Subtotal<\\/th>\\n                            <\\/tr>\\n            <tbody>\\n                                                                                <tr style=\\\"font-size: 12px;\\\">\\n                        <td>\\n                            \\n                        <\\/td>\\n                        <td>\\n                            Honorarios profesionales Julio 2021\\n                        <\\/td>\\n                        <td>\\n                            1.00\\n                        <\\/td>\\n                        <td>\\n                            Unidades\\n                        <\\/td>\\n                        <td>                            2.950,00\\n                                                    <\\/td>\\n                        <td>\\n                            0,00%\\n                        <\\/td>\\n                        <td>\\n                            0,00\\n                        <\\/td>\\n                        <td>\\n                            2.950,00\\n                        <\\/td>\\n                                            <\\/tr>\\n                    \\n            <\\/tbody>\\n        <\\/table>\\n        <\\/div>\\n\\n        \\n\\n        <div style=\\\"height:200px;margin-top: 1%;\\\"> <!-- Totales -->\\n              <!-- Es factura B o C -->\\n                <table class=\\\"table-totales\\\" cellspacing=\\\"0\\\" width=\\\"100%\\\">\\n                    <tr>\\n                        <th style=\\\"width:50%; text-align:left;\\\">\\n\\n<!--                                <span style=\\\"width:100%;\\\"><img src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/barcodes\\/71304902467592.png\\\"><\\/span>\\n                                <span style=\\\"text-align:center;\\\">2737718350411000471304902467592202107251<\\/span>-->\\n                        <\\/th>\\n                        <th class=\\\"subtotales_conceptos\\\">TOTAL:<\\/th>\\n                        <th class=\\\"subtotales_importes\\\">$ 2.950,00<\\/th>\\n                    <\\/tr>\\n                <\\/table>\\n                <br>\\n                <table cellspacing=\\\"0\\\" width=\\\"100%\\\" style=\\\"border: none\\\">\\n                    <tr>\\n                        <th style=\\\"width:50%; text-align:left;\\\">\\n\\n                            <?xml version=\\\"1.0\\\" encoding=\\\"UTF-8\\\"?>\\n<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" version=\\\"1.1\\\" width=\\\"100\\\" height=\\\"100\\\" viewBox=\\\"0 0 100 100\\\"><rect x=\\\"0\\\" y=\\\"0\\\" width=\\\"100\\\" height=\\\"100\\\" fill=\\\"#ffffff\\\"\\/><g transform=\\\"scale(1.754)\\\"><g transform=\\\"translate(0,0)\\\"><path fill-rule=\\\"evenodd\\\" d=\\\"M8 0L8 1L10 1L10 0ZM11 0L11 2L8 2L8 5L9 5L9 4L12 4L12 7L11 7L11 6L10 6L10 7L9 7L9 6L8 6L8 7L9 7L9 8L8 8L8 9L7 9L7 8L6 8L6 9L4 9L4 8L0 8L0 9L4 9L4 11L3 11L3 13L2 13L2 12L1 12L1 11L2 11L2 10L1 10L1 11L0 11L0 13L1 13L1 14L0 14L0 15L1 15L1 14L2 14L2 17L4 17L4 16L6 16L6 17L7 17L7 18L6 18L6 19L5 19L5 18L3 18L3 19L0 19L0 20L1 20L1 22L2 22L2 23L1 23L1 24L0 24L0 25L1 25L1 26L0 26L0 27L1 27L1 28L0 28L0 29L1 29L1 28L2 28L2 29L4 29L4 30L3 30L3 31L7 31L7 32L6 32L6 33L3 33L3 32L2 32L2 31L0 31L0 32L2 32L2 33L0 33L0 37L1 37L1 35L3 35L3 36L2 36L2 38L0 38L0 40L1 40L1 41L0 41L0 42L5 42L5 43L7 43L7 44L5 44L5 45L3 45L3 44L4 44L4 43L0 43L0 45L1 45L1 46L0 46L0 48L5 48L5 47L7 47L7 48L6 48L6 49L8 49L8 50L9 50L9 51L10 51L10 50L9 50L9 49L10 49L10 48L11 48L11 51L12 51L12 53L13 53L13 52L14 52L14 51L12 51L12 50L14 50L14 49L15 49L15 53L16 53L16 54L17 54L17 55L18 55L18 56L17 56L17 57L18 57L18 56L19 56L19 57L21 57L21 56L19 56L19 55L20 55L20 51L21 51L21 52L23 52L23 50L24 50L24 53L25 53L25 54L23 54L23 56L22 56L22 57L24 57L24 56L26 56L26 55L25 55L25 54L27 54L27 53L31 53L31 54L33 54L33 55L32 55L32 56L34 56L34 57L36 57L36 55L38 55L38 56L37 56L37 57L44 57L44 56L43 56L43 55L42 55L42 56L41 56L41 55L40 55L40 54L42 54L42 53L40 53L40 52L43 52L43 53L45 53L45 52L46 52L46 51L45 51L45 49L47 49L47 48L48 48L48 50L47 50L47 53L46 53L46 54L44 54L44 55L45 55L45 56L46 56L46 57L48 57L48 55L49 55L49 54L50 54L50 57L51 57L51 54L52 54L52 53L55 53L55 54L56 54L56 53L57 53L57 51L56 51L56 49L57 49L57 48L56 48L56 49L55 49L55 51L53 51L53 49L54 49L54 48L53 48L53 46L54 46L54 45L56 45L56 46L55 46L55 47L57 47L57 44L53 44L53 46L52 46L52 43L51 43L51 44L50 44L50 42L51 42L51 41L50 41L50 40L52 40L52 42L54 42L54 43L55 43L55 42L57 42L57 40L56 40L56 38L57 38L57 31L56 31L56 30L57 30L57 27L56 27L56 24L57 24L57 21L56 21L56 20L53 20L53 19L54 19L54 18L55 18L55 14L54 14L54 10L53 10L53 9L55 9L55 10L56 10L56 11L55 11L55 12L57 12L57 8L56 8L56 9L55 9L55 8L52 8L52 10L51 10L51 11L50 11L50 10L49 10L49 9L50 9L50 8L48 8L48 7L49 7L49 6L48 6L48 7L47 7L47 5L48 5L48 0L45 0L45 1L43 1L43 0L39 0L39 1L41 1L41 4L40 4L40 5L39 5L39 2L38 2L38 1L37 1L37 2L36 2L36 1L32 1L32 2L31 2L31 0L30 0L30 1L29 1L29 0L28 0L28 1L26 1L26 0L24 0L24 1L23 1L23 0L22 0L22 1L23 1L23 2L22 2L22 3L21 3L21 4L20 4L20 5L21 5L21 4L22 4L22 10L21 10L21 11L20 11L20 12L19 12L19 10L20 10L20 9L21 9L21 8L20 8L20 7L21 7L21 6L20 6L20 7L19 7L19 6L18 6L18 7L17 7L17 6L16 6L16 7L15 7L15 6L14 6L14 5L13 5L13 4L14 4L14 3L15 3L15 5L17 5L17 4L16 4L16 3L17 3L17 2L18 2L18 1L17 1L17 2L15 2L15 1L16 1L16 0L14 0L14 2L13 2L13 0ZM19 1L19 2L21 2L21 1ZM25 1L25 2L23 2L23 3L22 3L22 4L23 4L23 3L24 3L24 5L23 5L23 10L22 10L22 11L21 11L21 12L22 12L22 13L23 13L23 14L24 14L24 16L23 16L23 15L22 15L22 14L20 14L20 13L19 13L19 12L18 12L18 10L19 10L19 9L20 9L20 8L18 8L18 9L17 9L17 8L15 8L15 7L14 7L14 6L13 6L13 7L14 7L14 9L13 9L13 8L11 8L11 7L10 7L10 8L9 8L9 9L8 9L8 10L7 10L7 9L6 9L6 10L7 10L7 11L6 11L6 12L5 12L5 13L3 13L3 15L5 15L5 14L8 14L8 15L9 15L9 17L8 17L8 16L7 16L7 15L6 15L6 16L7 16L7 17L8 17L8 20L7 20L7 19L6 19L6 20L5 20L5 21L6 21L6 22L7 22L7 21L8 21L8 24L7 24L7 23L6 23L6 24L7 24L7 25L5 25L5 24L4 24L4 25L3 25L3 24L2 24L2 26L9 26L9 27L11 27L11 26L9 26L9 25L10 25L10 24L9 24L9 20L10 20L10 21L11 21L11 22L10 22L10 23L11 23L11 22L12 22L12 21L13 21L13 23L14 23L14 24L16 24L16 23L18 23L18 22L19 22L19 23L20 23L20 24L19 24L19 25L18 25L18 26L17 26L17 25L16 25L16 26L15 26L15 25L14 25L14 27L13 27L13 25L12 25L12 24L11 24L11 25L12 25L12 27L13 27L13 28L12 28L12 29L9 29L9 31L8 31L8 33L9 33L9 34L7 34L7 33L6 33L6 34L7 34L7 35L6 35L6 36L3 36L3 37L6 37L6 38L7 38L7 39L5 39L5 40L7 40L7 41L6 41L6 42L7 42L7 43L8 43L8 44L7 44L7 45L6 45L6 46L8 46L8 44L9 44L9 43L13 43L13 42L15 42L15 43L14 43L14 44L15 44L15 45L16 45L16 46L18 46L18 47L17 47L17 48L18 48L18 47L20 47L20 48L19 48L19 50L17 50L17 49L16 49L16 48L15 48L15 49L16 49L16 53L17 53L17 52L18 52L18 53L19 53L19 52L18 52L18 51L20 51L20 48L22 48L22 49L23 49L23 48L22 48L22 47L24 47L24 46L22 46L22 44L23 44L23 45L25 45L25 46L27 46L27 44L28 44L28 47L26 47L26 48L24 48L24 50L25 50L25 49L26 49L26 48L28 48L28 47L29 47L29 48L30 48L30 47L32 47L32 50L31 50L31 51L32 51L32 50L33 50L33 51L35 51L35 52L36 52L36 53L35 53L35 55L34 55L34 56L35 56L35 55L36 55L36 53L37 53L37 54L38 54L38 55L39 55L39 56L40 56L40 55L39 55L39 53L37 53L37 51L38 51L38 52L40 52L40 50L41 50L41 51L42 51L42 50L43 50L43 51L44 51L44 49L45 49L45 48L46 48L46 46L47 46L47 45L48 45L48 44L49 44L49 42L50 42L50 41L47 41L47 42L48 42L48 43L46 43L46 44L45 44L45 42L46 42L46 40L47 40L47 39L48 39L48 38L47 38L47 37L49 37L49 38L50 38L50 39L51 39L51 38L52 38L52 40L53 40L53 41L54 41L54 42L55 42L55 41L56 41L56 40L55 40L55 41L54 41L54 39L55 39L55 38L56 38L56 36L55 36L55 35L56 35L56 32L55 32L55 30L56 30L56 27L55 27L55 22L56 22L56 21L55 21L55 22L54 22L54 21L53 21L53 22L51 22L51 21L52 21L52 20L51 20L51 19L50 19L50 20L49 20L49 19L47 19L47 20L45 20L45 19L46 19L46 17L47 17L47 18L49 18L49 17L50 17L50 18L51 18L51 17L54 17L54 14L52 14L52 13L53 13L53 10L52 10L52 11L51 11L51 12L52 12L52 13L51 13L51 15L49 15L49 17L47 17L47 16L46 16L46 15L47 15L47 13L48 13L48 14L50 14L50 12L49 12L49 10L48 10L48 8L47 8L47 9L46 9L46 10L48 10L48 11L46 11L46 12L47 12L47 13L46 13L46 14L45 14L45 12L44 12L44 13L43 13L43 12L42 12L42 13L41 13L41 9L44 9L44 10L43 10L43 11L45 11L45 7L46 7L46 5L47 5L47 3L46 3L46 2L47 2L47 1L45 1L45 3L44 3L44 5L43 5L43 4L41 4L41 7L42 7L42 8L41 8L41 9L39 9L39 8L38 8L38 9L37 9L37 8L35 8L35 7L36 7L36 6L37 6L37 7L38 7L38 6L37 6L37 5L38 5L38 3L37 3L37 5L35 5L35 4L34 4L34 5L33 5L33 7L32 7L32 4L33 4L33 3L34 3L34 2L33 2L33 3L31 3L31 8L32 8L32 9L31 9L31 10L33 10L33 11L34 11L34 10L35 10L35 13L34 13L34 14L32 14L32 15L33 15L33 17L30 17L30 18L28 18L28 19L27 19L27 17L29 17L29 16L30 16L30 15L29 15L29 13L30 13L30 14L31 14L31 13L33 13L33 12L31 12L31 11L26 11L26 12L25 12L25 11L24 11L24 8L25 8L25 10L27 10L27 9L26 9L26 8L25 8L25 7L26 7L26 6L25 6L25 5L26 5L26 4L25 4L25 2L26 2L26 3L28 3L28 4L30 4L30 3L29 3L29 2L26 2L26 1ZM11 2L11 3L12 3L12 4L13 4L13 3L12 3L12 2ZM18 3L18 5L19 5L19 3ZM45 3L45 5L46 5L46 3ZM27 5L27 8L30 8L30 5ZM42 5L42 7L43 7L43 8L44 8L44 7L45 7L45 6L44 6L44 7L43 7L43 5ZM24 6L24 7L25 7L25 6ZM28 6L28 7L29 7L29 6ZM34 6L34 7L35 7L35 6ZM39 6L39 7L40 7L40 6ZM9 9L9 11L10 11L10 10L11 10L11 12L9 12L9 13L8 13L8 11L7 11L7 12L6 12L6 13L8 13L8 14L10 14L10 17L9 17L9 19L10 19L10 18L11 18L11 15L12 15L12 16L13 16L13 15L14 15L14 18L13 18L13 19L12 19L12 20L11 20L11 21L12 21L12 20L13 20L13 19L15 19L15 18L17 18L17 17L18 17L18 19L16 19L16 20L14 20L14 21L15 21L15 23L16 23L16 21L17 21L17 22L18 22L18 21L17 21L17 20L18 20L18 19L20 19L20 21L19 21L19 22L20 22L20 21L21 21L21 19L22 19L22 23L25 23L25 25L26 25L26 29L25 29L25 27L24 27L24 26L23 26L23 25L22 25L22 24L20 24L20 25L19 25L19 27L17 27L17 28L16 28L16 27L15 27L15 28L14 28L14 30L13 30L13 29L12 29L12 30L13 30L13 31L12 31L12 32L11 32L11 33L12 33L12 34L13 34L13 33L14 33L14 32L15 32L15 31L17 31L17 32L18 32L18 28L19 28L19 30L20 30L20 28L19 28L19 27L22 27L22 28L23 28L23 30L22 30L22 29L21 29L21 30L22 30L22 31L20 31L20 33L21 33L21 32L22 32L22 35L26 35L26 36L25 36L25 37L27 37L27 35L28 35L28 37L29 37L29 39L30 39L30 38L31 38L31 40L27 40L27 42L29 42L29 41L30 41L30 44L29 44L29 43L28 43L28 44L29 44L29 45L30 45L30 46L31 46L31 45L32 45L32 47L33 47L33 46L34 46L34 48L33 48L33 50L34 50L34 48L35 48L35 47L36 47L36 49L35 49L35 51L36 51L36 49L37 49L37 48L38 48L38 45L37 45L37 47L36 47L36 45L35 45L35 46L34 46L34 45L32 45L32 43L31 43L31 41L33 41L33 43L35 43L35 44L37 44L37 42L38 42L38 44L39 44L39 47L40 47L40 45L41 45L41 48L42 48L42 49L43 49L43 48L45 48L45 45L44 45L44 44L43 44L43 43L42 43L42 45L41 45L41 43L40 43L40 44L39 44L39 42L38 42L38 41L37 41L37 42L36 42L36 40L35 40L35 39L38 39L38 40L39 40L39 41L40 41L40 42L42 42L42 41L43 41L43 42L45 42L45 40L46 40L46 38L45 38L45 37L46 37L46 36L48 36L48 35L49 35L49 34L48 34L48 33L50 33L50 38L51 38L51 35L52 35L52 37L54 37L54 38L53 38L53 39L54 39L54 38L55 38L55 37L54 37L54 35L55 35L55 32L54 32L54 29L55 29L55 27L53 27L53 25L52 25L52 23L51 23L51 25L50 25L50 23L49 23L49 25L50 25L50 26L48 26L48 23L47 23L47 22L46 22L46 21L44 21L44 22L43 22L43 18L44 18L44 17L46 17L46 16L45 16L45 15L44 15L44 14L42 14L42 15L41 15L41 13L40 13L40 10L39 10L39 13L38 13L38 12L37 12L37 9L36 9L36 13L35 13L35 15L39 15L39 16L38 16L38 17L37 17L37 19L36 19L36 18L35 18L35 17L36 17L36 16L35 16L35 17L33 17L33 18L31 18L31 19L35 19L35 20L37 20L37 22L36 22L36 21L35 21L35 22L32 22L32 20L30 20L30 19L28 19L28 20L27 20L27 19L25 19L25 18L24 18L24 19L22 19L22 18L21 18L21 19L20 19L20 16L19 16L19 17L18 17L18 16L17 16L17 14L18 14L18 12L17 12L17 11L16 11L16 10L15 10L15 9L14 9L14 11L15 11L15 13L13 13L13 12L12 12L12 10L13 10L13 9ZM28 9L28 10L30 10L30 9ZM23 12L23 13L24 13L24 12ZM26 12L26 14L25 14L25 16L24 16L24 17L25 17L25 16L26 16L26 15L27 15L27 12ZM11 13L11 14L13 14L13 13ZM15 13L15 14L14 14L14 15L15 15L15 16L16 16L16 14L17 14L17 13ZM36 13L36 14L38 14L38 13ZM39 13L39 15L40 15L40 13ZM19 14L19 15L20 15L20 14ZM28 15L28 16L29 16L29 15ZM42 15L42 16L39 16L39 17L38 17L38 18L41 18L41 17L42 17L42 18L43 18L43 17L42 17L42 16L43 16L43 15ZM52 15L52 16L53 16L53 15ZM50 16L50 17L51 17L51 16ZM56 16L56 18L57 18L57 16ZM52 18L52 19L53 19L53 18ZM24 19L24 20L25 20L25 19ZM37 19L37 20L38 20L38 19ZM39 19L39 20L40 20L40 19ZM41 19L41 20L42 20L42 19ZM6 20L6 21L7 21L7 20ZM29 20L29 21L28 21L28 22L27 22L27 21L25 21L25 23L26 23L26 24L28 24L28 26L31 26L31 27L33 27L33 28L34 28L34 29L35 29L35 31L36 31L36 29L37 29L37 30L39 30L39 29L41 29L41 30L40 30L40 31L41 31L41 33L42 33L42 32L43 32L43 35L44 35L44 33L46 33L46 34L45 34L45 36L41 36L41 35L42 35L42 34L39 34L39 33L40 33L40 32L38 32L38 31L37 31L37 32L35 32L35 33L33 33L33 32L34 32L34 30L33 30L33 31L32 31L32 30L31 30L31 33L30 33L30 31L26 31L26 32L25 32L25 29L24 29L24 32L25 32L25 34L26 34L26 35L27 35L27 34L30 34L30 35L29 35L29 36L30 36L30 35L31 35L31 38L33 38L33 36L32 36L32 34L31 34L31 33L33 33L33 34L36 34L36 35L37 35L37 34L38 34L38 36L37 36L37 37L39 37L39 38L38 38L38 39L40 39L40 41L42 41L42 38L44 38L44 39L45 39L45 38L44 38L44 37L45 37L45 36L46 36L46 34L47 34L47 33L48 33L48 31L46 31L46 32L45 32L45 31L44 31L44 32L43 32L43 29L44 29L44 30L45 30L45 29L44 29L44 27L46 27L46 29L47 29L47 30L48 30L48 27L47 27L47 23L45 23L45 22L44 22L44 23L45 23L45 24L44 24L44 25L43 25L43 24L42 24L42 25L41 25L41 23L40 23L40 24L39 24L39 23L38 23L38 24L37 24L37 26L35 26L35 25L36 25L36 23L35 23L35 25L34 25L34 23L33 23L33 24L32 24L32 22L31 22L31 23L30 23L30 20ZM33 20L33 21L34 21L34 20ZM47 20L47 21L48 21L48 22L49 22L49 20ZM50 20L50 21L51 21L51 20ZM23 21L23 22L24 22L24 21ZM38 21L38 22L40 22L40 21ZM3 22L3 23L4 23L4 22ZM26 22L26 23L27 23L27 22ZM53 22L53 23L54 23L54 22ZM8 24L8 25L9 25L9 24ZM31 24L31 26L34 26L34 25L32 25L32 24ZM38 24L38 27L37 27L37 29L38 29L38 28L41 28L41 29L43 29L43 27L42 27L42 28L41 28L41 26L40 26L40 25L39 25L39 24ZM45 24L45 25L44 25L44 26L45 26L45 25L46 25L46 24ZM39 26L39 27L40 27L40 26ZM5 27L5 30L8 30L8 27ZM27 27L27 30L30 30L30 27ZM49 27L49 30L52 30L52 27ZM6 28L6 29L7 29L7 28ZM15 28L15 30L16 30L16 28ZM28 28L28 29L29 29L29 28ZM31 28L31 29L32 29L32 28ZM35 28L35 29L36 29L36 28ZM50 28L50 29L51 29L51 28ZM53 28L53 29L54 29L54 28ZM10 30L10 31L9 31L9 33L10 33L10 31L11 31L11 30ZM13 31L13 32L12 32L12 33L13 33L13 32L14 32L14 31ZM22 31L22 32L23 32L23 31ZM50 31L50 33L51 33L51 31ZM52 31L52 34L54 34L54 32L53 32L53 31ZM26 32L26 33L27 33L27 32ZM37 32L37 33L38 33L38 32ZM46 32L46 33L47 33L47 32ZM23 33L23 34L24 34L24 33ZM3 34L3 35L4 35L4 34ZM9 34L9 35L11 35L11 34ZM15 34L15 37L14 37L14 35L13 35L13 37L12 37L12 36L9 36L9 37L8 37L8 39L9 39L9 40L12 40L12 42L13 42L13 41L14 41L14 39L15 39L15 38L17 38L17 39L16 39L16 40L15 40L15 42L16 42L16 43L17 43L17 45L18 45L18 46L19 46L19 44L20 44L20 45L21 45L21 44L22 44L22 43L21 43L21 44L20 44L20 43L18 43L18 42L20 42L20 41L18 41L18 42L17 42L17 41L16 41L16 40L17 40L17 39L18 39L18 40L19 40L19 39L21 39L21 40L22 40L22 39L21 39L21 37L22 37L22 38L24 38L24 36L23 36L23 37L22 37L22 36L21 36L21 34L19 34L19 35L20 35L20 38L19 38L19 36L18 36L18 38L17 38L17 37L16 37L16 36L17 36L17 35L18 35L18 34L17 34L17 35L16 35L16 34ZM6 36L6 37L7 37L7 36ZM34 36L34 39L33 39L33 40L34 40L34 39L35 39L35 38L36 38L36 37L35 37L35 36ZM39 36L39 37L40 37L40 39L41 39L41 37L40 37L40 36ZM9 37L9 38L10 38L10 39L11 39L11 38L12 38L12 37L11 37L11 38L10 38L10 37ZM13 37L13 39L14 39L14 37ZM18 38L18 39L19 39L19 38ZM26 38L26 39L28 39L28 38ZM3 39L3 41L4 41L4 39ZM24 39L24 40L23 40L23 42L24 42L24 41L25 41L25 44L26 44L26 41L25 41L25 39ZM8 41L8 42L10 42L10 41ZM21 41L21 42L22 42L22 41ZM23 43L23 44L24 44L24 43ZM10 44L10 47L8 47L8 48L10 48L10 47L11 47L11 48L12 48L12 47L11 47L11 46L13 46L13 47L15 47L15 46L14 46L14 45L13 45L13 44ZM30 44L30 45L31 45L31 44ZM43 45L43 47L42 47L42 48L43 48L43 47L44 47L44 45ZM49 45L49 48L50 48L50 46L51 46L51 45ZM1 46L1 47L2 47L2 46ZM3 46L3 47L5 47L5 46ZM20 46L20 47L21 47L21 46ZM51 47L51 48L52 48L52 47ZM13 48L13 49L14 49L14 48ZM39 48L39 49L38 49L38 51L39 51L39 50L40 50L40 48ZM27 49L27 52L30 52L30 49ZM49 49L49 52L52 52L52 49ZM21 50L21 51L22 51L22 50ZM28 50L28 51L29 51L29 50ZM50 50L50 51L51 51L51 50ZM25 51L25 52L26 52L26 51ZM55 51L55 53L56 53L56 51ZM31 52L31 53L32 53L32 52ZM33 52L33 54L34 54L34 52ZM8 53L8 57L9 57L9 55L11 55L11 56L13 56L13 57L14 57L14 56L15 56L15 55L14 55L14 56L13 56L13 55L11 55L11 54L9 54L9 53ZM21 53L21 55L22 55L22 53ZM50 53L50 54L51 54L51 53ZM18 54L18 55L19 55L19 54ZM47 54L47 55L48 55L48 54ZM53 54L53 56L52 56L52 57L55 57L55 56L54 56L54 54ZM27 55L27 57L31 57L31 56L30 56L30 55L29 55L29 56L28 56L28 55ZM56 55L56 56L57 56L57 55ZM0 0L0 7L7 7L7 0ZM1 1L1 6L6 6L6 1ZM2 2L2 5L5 5L5 2ZM50 0L50 7L57 7L57 0ZM51 1L51 6L56 6L56 1ZM52 2L52 5L55 5L55 2ZM0 50L0 57L7 57L7 50ZM1 51L1 56L6 56L6 51ZM2 52L2 55L5 55L5 52Z\\\" fill=\\\"#000000\\\"\\/><\\/g><\\/g><\\/svg>\\n\\n                            <span style=\\\"width:50%;\\\">\\n                                <img style=\\\"max-height: 70px\\\"\\n                                     src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/img\\/AfipComprobanteAutorizado.png\\\">\\n                            <\\/span>\\n                        <\\/th>\\n                        <th style=\\\"text-align:right;\\\">\\n                            <p>CAE N&#186;: 71304902467592<br>\\n                                Fecha Vto. CAE:  25\\/07\\/2021\\n                            <\\/p>\\n                        <\\/th>\\n                    <\\/tr>\\n                <\\/table>\\n                    <\\/div>\\n    <\\/div>\\n\\n    <\\/body>\\n<\\/html>\\\";s:4:\\\"file\\\";N;}s:6:\\\"locale\\\";N;s:4:\\\"from\\\";a:0:{}s:2:\\\"to\\\";a:1:{i:0;a:2:{s:4:\\\"name\\\";N;s:7:\\\"address\\\";s:23:\\\"bovacardosojm@gmail.com\\\";}}s:2:\\\"cc\\\";a:0:{}s:3:\\\"bcc\\\";a:1:{i:0;a:2:{s:4:\\\"name\\\";N;s:7:\\\"address\\\";s:23:\\\"info@masquecontable.com\\\";}}s:7:\\\"replyTo\\\";a:0:{}s:7:\\\"subject\\\";N;s:11:\\\"\\u0000*\\u0000markdown\\\";N;s:7:\\\"\\u0000*\\u0000html\\\";N;s:4:\\\"view\\\";N;s:8:\\\"textView\\\";N;s:8:\\\"viewData\\\";a:0:{}s:11:\\\"attachments\\\";a:0:{}s:14:\\\"rawAttachments\\\";a:0:{}s:15:\\\"diskAttachments\\\";a:0:{}s:9:\\\"callbacks\\\";a:0:{}s:5:\\\"theme\\\";N;s:6:\\\"mailer\\\";s:8:\\\"sendgrid\\\";s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:5:\\\"delay\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;}\"}}','ErrorException: Trying to get property \'id\' of non-object in /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php:16\nStack trace:\n#0 /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php(16): Illuminate\\Foundation\\Bootstrap\\HandleExceptions->handleError(8, \'Trying to get p...\', \'/home/forge/tax...\', 16, Array)\n#1 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(356): App\\Queue\\DatabaseJob->fire()\n#2 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(306): Illuminate\\Queue\\Worker->process(\'database\', Object(App\\Queue\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#3 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(132): Illuminate\\Queue\\Worker->runJob(Object(App\\Queue\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#4 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(112): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#5 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(96): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#6 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#7 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#8 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#9 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#10 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#11 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(134): Illuminate\\Container\\Container->call(Array)\n#12 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(256): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#13 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(121): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#14 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(971): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#15 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(290): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#16 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(166): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#17 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Application.php(93): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(129): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#19 /home/forge/taxes.com.ar/artisan(35): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#20 {main}','2021-07-23 18:04:00',NULL);
INSERT INTO `failed_jobs` VALUES (5,NULL,'database','default','{\"uuid\":\"78f41741-4173-41bf-bf4c-c8c5cdeff022\",\"displayName\":\"App\\\\Mail\\\\Fact_Electronica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"delay\":null,\"timeout\":null,\"timeoutAt\":null,\"data\":{\"commandName\":\"Illuminate\\\\Mail\\\\SendQueuedMailable\",\"command\":\"O:34:\\\"Illuminate\\\\Mail\\\\SendQueuedMailable\\\":3:{s:8:\\\"mailable\\\";O:25:\\\"App\\\\Mail\\\\Fact_Electronica\\\":27:{s:11:\\\"informacion\\\";a:6:{s:12:\\\"ruta_logo_fa\\\";N;s:4:\\\"mail\\\";s:23:\\\"info@masquecontable.com\\\";s:18:\\\"name_quien_factura\\\";s:19:\\\"MICAELA AILIN CORIA\\\";s:7:\\\"cliente\\\";O:17:\\\"App\\\\Models\\\\Person\\\":27:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:7:\\\"persons\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:40728;s:7:\\\"user_id\\\";i:5115;s:11:\\\"field_name1\\\";s:14:\\\"CASTILLO PABLO\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"20-37387128-2\\\";s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-07-05 13:19:56\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-07-05 13:19:56\\\";s:11:\\\"activity_id\\\";i:1;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";i:1;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:40728;s:7:\\\"user_id\\\";i:5115;s:11:\\\"field_name1\\\";s:14:\\\"CASTILLO PABLO\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"20-37387128-2\\\";s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-07-05 13:19:56\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-07-05 13:19:56\\\";s:11:\\\"activity_id\\\";i:1;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";i:1;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}s:14:\\\"nombre_del_pdf\\\";s:28:\\\"Factura N\\u00b00004-00000008.pdf\\\";s:9:\\\"body_mail\\\";s:155:\\\"Estimado cliente, se env\\u00eda adjunta la factura de honorarios correspondientes al mes de Julio 2021.\\nMuchas gracias por seguir eligiendo nuestros servicios.\\\";}s:3:\\\"pdf\\\";O:26:\\\"Barryvdh\\\\Snappy\\\\PdfWrapper\\\":4:{s:9:\\\"\\u0000*\\u0000snappy\\\";O:35:\\\"Barryvdh\\\\Snappy\\\\IlluminateSnappyPdf\\\":10:{s:26:\\\"\\u0000*\\u0000optionsWithContentCheck\\\";a:4:{s:11:\\\"header-html\\\";s:4:\\\"html\\\";s:11:\\\"footer-html\\\";s:4:\\\"html\\\";s:5:\\\"cover\\\";s:4:\\\"html\\\";s:15:\\\"xsl-style-sheet\\\";s:3:\\\"xsl\\\";}s:36:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000binary\\\";s:76:\\\"\\/home\\/forge\\/taxes.com.ar\\/vendor\\/h4cc\\/wkhtmltopdf-amd64\\/bin\\/wkhtmltopdf-amd64\\\";s:37:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000options\\\";a:132:{s:7:\\\"collate\\\";N;s:10:\\\"no-collate\\\";N;s:10:\\\"cookie-jar\\\";N;s:6:\\\"copies\\\";i:1;s:3:\\\"dpi\\\";N;s:13:\\\"extended-help\\\";N;s:9:\\\"grayscale\\\";N;s:4:\\\"help\\\";N;s:7:\\\"htmldoc\\\";N;s:18:\\\"ignore-load-errors\\\";N;s:9:\\\"image-dpi\\\";N;s:13:\\\"image-quality\\\";N;s:7:\\\"license\\\";N;s:9:\\\"log-level\\\";N;s:10:\\\"lowquality\\\";b:1;s:7:\\\"manpage\\\";N;s:13:\\\"margin-bottom\\\";N;s:11:\\\"margin-left\\\";N;s:12:\\\"margin-right\\\";N;s:10:\\\"margin-top\\\";N;s:11:\\\"orientation\\\";N;s:11:\\\"page-height\\\";N;s:9:\\\"page-size\\\";s:2:\\\"a4\\\";s:10:\\\"page-width\\\";N;s:18:\\\"no-pdf-compression\\\";N;s:5:\\\"quiet\\\";N;s:20:\\\"read-args-from-stdin\\\";N;s:6:\\\"readme\\\";N;s:5:\\\"title\\\";N;s:11:\\\"use-xserver\\\";N;s:7:\\\"version\\\";N;s:20:\\\"dump-default-toc-xsl\\\";N;s:12:\\\"dump-outline\\\";N;s:7:\\\"outline\\\";N;s:10:\\\"no-outline\\\";N;s:13:\\\"outline-depth\\\";N;s:13:\\\"output-format\\\";N;s:5:\\\"allow\\\";N;s:10:\\\"background\\\";N;s:13:\\\"no-background\\\";N;s:16:\\\"bypass-proxy-for\\\";N;s:9:\\\"cache-dir\\\";N;s:20:\\\"checkbox-checked-svg\\\";N;s:12:\\\"checkbox-svg\\\";N;s:6:\\\"cookie\\\";N;s:13:\\\"custom-header\\\";N;s:25:\\\"custom-header-propagation\\\";N;s:28:\\\"no-custom-header-propagation\\\";N;s:16:\\\"debug-javascript\\\";N;s:19:\\\"no-debug-javascript\\\";N;s:14:\\\"default-header\\\";N;s:8:\\\"encoding\\\";N;s:22:\\\"disable-external-links\\\";N;s:21:\\\"enable-external-links\\\";N;s:13:\\\"disable-forms\\\";N;s:12:\\\"enable-forms\\\";N;s:6:\\\"images\\\";N;s:9:\\\"no-images\\\";N;s:22:\\\"disable-internal-links\\\";N;s:21:\\\"enable-internal-links\\\";N;s:18:\\\"disable-javascript\\\";N;s:17:\\\"enable-javascript\\\";N;s:16:\\\"javascript-delay\\\";N;s:19:\\\"keep-relative-links\\\";N;s:19:\\\"load-error-handling\\\";N;s:25:\\\"load-media-error-handling\\\";N;s:25:\\\"disable-local-file-access\\\";N;s:24:\\\"enable-local-file-access\\\";N;s:17:\\\"minimum-font-size\\\";N;s:20:\\\"exclude-from-outline\\\";N;s:18:\\\"include-in-outline\\\";N;s:11:\\\"page-offset\\\";N;s:8:\\\"password\\\";N;s:15:\\\"disable-plugins\\\";N;s:14:\\\"enable-plugins\\\";N;s:4:\\\"post\\\";N;s:9:\\\"post-file\\\";N;s:16:\\\"print-media-type\\\";N;s:19:\\\"no-print-media-type\\\";N;s:5:\\\"proxy\\\";N;s:21:\\\"proxy-hostname-lookup\\\";N;s:23:\\\"radiobutton-checked-svg\\\";N;s:15:\\\"radiobutton-svg\\\";N;s:14:\\\"redirect-delay\\\";N;s:22:\\\"resolve-relative-links\\\";N;s:10:\\\"run-script\\\";N;s:23:\\\"disable-smart-shrinking\\\";N;s:22:\\\"enable-smart-shrinking\\\";N;s:12:\\\"ssl-crt-path\\\";N;s:16:\\\"ssl-key-password\\\";N;s:12:\\\"ssl-key-path\\\";N;s:17:\\\"stop-slow-scripts\\\";N;s:20:\\\"no-stop-slow-scripts\\\";N;s:22:\\\"disable-toc-back-links\\\";N;s:21:\\\"enable-toc-back-links\\\";N;s:16:\\\"user-style-sheet\\\";N;s:8:\\\"username\\\";N;s:13:\\\"viewport-size\\\";N;s:13:\\\"window-status\\\";N;s:4:\\\"zoom\\\";N;s:13:\\\"footer-center\\\";s:25:\\\"Pagina [page] de [toPage]\\\";s:16:\\\"footer-font-name\\\";N;s:16:\\\"footer-font-size\\\";i:8;s:11:\\\"footer-html\\\";N;s:11:\\\"footer-left\\\";s:0:\\\"\\\";s:11:\\\"footer-line\\\";N;s:14:\\\"no-footer-line\\\";N;s:12:\\\"footer-right\\\";N;s:14:\\\"footer-spacing\\\";N;s:13:\\\"header-center\\\";N;s:16:\\\"header-font-name\\\";N;s:16:\\\"header-font-size\\\";N;s:11:\\\"header-html\\\";N;s:11:\\\"header-left\\\";N;s:11:\\\"header-line\\\";N;s:14:\\\"no-header-line\\\";N;s:12:\\\"header-right\\\";N;s:14:\\\"header-spacing\\\";N;s:7:\\\"replace\\\";N;s:5:\\\"cover\\\";N;s:3:\\\"toc\\\";N;s:20:\\\"disable-dotted-lines\\\";N;s:9:\\\"toc-depth\\\";N;s:13:\\\"toc-font-name\\\";N;s:16:\\\"toc-l1-font-size\\\";N;s:15:\\\"toc-header-text\\\";N;s:20:\\\"toc-header-font-name\\\";N;s:20:\\\"toc-header-font-size\\\";N;s:21:\\\"toc-level-indentation\\\";N;s:17:\\\"disable-toc-links\\\";N;s:20:\\\"toc-text-size-shrink\\\";N;s:15:\\\"xsl-style-sheet\\\";N;}s:33:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000env\\\";N;s:37:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000timeout\\\";b:0;s:46:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000defaultExtension\\\";s:3:\\\"pdf\\\";s:18:\\\"\\u0000*\\u0000temporaryFolder\\\";N;s:14:\\\"temporaryFiles\\\";a:0:{}s:36:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000logger\\\";O:18:\\\"Psr\\\\Log\\\\NullLogger\\\":0:{}s:2:\\\"fs\\\";O:32:\\\"Illuminate\\\\Filesystem\\\\Filesystem\\\":0:{}}s:10:\\\"\\u0000*\\u0000options\\\";a:0:{}s:4:\\\"html\\\";s:22234:\\\"<!DOCTYPE html>\\n<html lang=\\\"en\\\">\\n    <head>\\n        <meta charset=\\\"utf-8\\\">\\n    <\\/head>\\n    <style>\\n        .subtotales_conceptos{\\n            width:30%;\\n            text-align: right;\\n        }\\n        .subtotales_importes{\\n            text-align: right;\\n        }\\n        .table-totales, .table-totales tr, .table-totales th{\\n            border: 1px solid;\\n        }\\n\\n    <\\/style>\\n    <body>\\n    <div style=\\\"max-height:840px\\\">\\n        <div style=\\\"width: 100%; height:270px\\\"> <!-- Datos de la empresa -->\\n            <table class=\\\"display\\\" cellspacing=\\\"0\\\" width=\\\"100%\\\" style=\\\"border:  1px solid;\\\">\\n                <tr style=\\\"\\\">\\n                    <th colspan=\\\"2\\\" rowspan=\\\"2\\\" style=\\\"width:45%;margin:0;height:150px;\\\">\\n                                                <img src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/img\\/\\/27377183504\\/logo_punto_venta_0000.png\\\"\\/>\\n                                            <\\/th>\\n                    <th style=\\\"border:  1px solid;text-align: center; width:10%\\\" colspan=\\\"2\\\">\\n                        <span style=\\\"font-size: 60px;\\\">C<\\/span> <br \\/> <span style=\\\"font-size: 14px;\\\">cod. 11<\\/span>\\n                    <\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"font-size: 28px;text-align: center;width:45%\\\">\\n                        Factura\\n                        <br>\\n                        0004 - 00000008\\n                    <\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th><\\/th>\\n                    <th style=\\\"border:  1px 1px 1px 0px solid;\\\" colspan=\\\"2\\\"><\\/th>\\n                    <th><\\/th>\\n                <\\/tr>\\n                <tr>\\n\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                                                    Raz&oacute;n Social:\\n                            <span style=\\\"font-weight: normal;\\\">MICAELA AILIN CORIA<\\/span>\\n                                            <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">Fecha de Emisi&oacute;n: <span style=\\\"font-weight: normal;\\\">15\\/07\\/2021<\\/span><\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Domicilio Comercial: <span style=\\\"font-weight: normal;\\\">Victor Guillet esq. Arturo M Bas, C.P.:5800,\\n                        C\\u00f3rdoba<\\/span>\\n                    <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">CUIT: <span style=\\\"font-weight: normal;\\\">27-37718350-4<\\/span><\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Condici&oacute;n frente al IVA: <span style=\\\"font-weight: normal;\\\">Monotributo<\\/span>\\n                    <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Ingresos Brutos: <span style=\\\"font-weight: normal;\\\"><\\/span>\\n                        <br>\\n                        Fecha de Inicio de Actividades: <span style=\\\"font-weight: normal;\\\">09\\/07\\/2021<\\/span>\\n                    <\\/th>\\n                <\\/tr>\\n            <\\/table>\\n        <\\/div>\\n\\n        <table style=\\\"text-align: center; width: 100%;border: solid 1px;\\\"> <!-- Fechas -->\\n            <thead>\\n                <tr>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Per\\u00edodo Facturado Desde: 01\\/07\\/2021<\\/small><\\/th>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Per\\u00edodo Facturado Hasta: 31\\/07\\/2021<\\/small><\\/th>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Fecha Vto. Pago: 15\\/07\\/2021<\\/small><\\/th>\\n                <\\/tr>\\n            <\\/thead>\\n        <\\/table>\\n        \\n        <table style=\\\"width: 100%; margin-top: 1%;border: solid 1px;\\\"> <!-- Datos Clientes -->\\n            <tr>\\n                <th style=\\\"text-align:left;\\\"colspan=\\\"12\\\">\\n                    CUIT: <span style=\\\"font-weight: normal;\\\">20-37387128-2<\\/span>\\n                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\\n                    Apellido y Nombre \\/ Raz&oacute;n Social: <span style=\\\"font-weight: normal;\\\">\\n                    CASTILLO PABLO<\\/span>\\n                <\\/th>\\n            <\\/tr>\\n            <tr>\\n                <th style=\\\"text-align:left; width:50%\\\">\\n                    Condici&oacute;n Frente al IVA: <span style=\\\"font-weight: normal;\\\">Responsable Monotributo<\\/span>\\n                <\\/th>\\n                <th style=\\\"text-align:left; width:50%\\\" colspan=\\\"4\\\">\\n                    Domicilio Comercial:\\n                    <span style=\\\"font-weight: normal;\\\">\\n                    --------\\n                    <\\/span>\\n                <\\/th>\\n            <\\/tr>\\n            <tr style=\\\"text-align:left\\\">\\n                <th>Condici&oacute;n de Venta: <span style=\\\"font-weight: normal;\\\">Cuenta Corriente<\\/span><\\/th>\\n            <\\/tr>\\n        <\\/table>\\n\\n        <div style=\\\"border: 1px solid;margin-top: 1%;min-height:600px;\\\">\\n        <table style=\\\"text-align: center; width: 100%; margin-top: 1%;\\\"> <!-- Body -->\\n            <tr style=\\\"border-bottom: 1px solid;font-size: 15px\\\">\\n                <th>C&oacute;digo<\\/th>\\n                <th style=\\\"width: 25%;\\\">Detalle<\\/th>\\n                <th>Cantidad<\\/th>\\n                <th>U.Medida<\\/th>\\n                <th>Precio U.<\\/th>\\n                <th>Bonif. (%)<\\/th>\\n                <th>Precio Bonif.<\\/th>\\n                <th>Subtotal<\\/th>\\n                            <\\/tr>\\n            <tbody>\\n                                                                                <tr style=\\\"font-size: 12px;\\\">\\n                        <td>\\n                            \\n                        <\\/td>\\n                        <td>\\n                            Honorarios profesionales Julio 2021\\n                        <\\/td>\\n                        <td>\\n                            1.00\\n                        <\\/td>\\n                        <td>\\n                            Unidades\\n                        <\\/td>\\n                        <td>                            2.950,00\\n                                                    <\\/td>\\n                        <td>\\n                            0,00%\\n                        <\\/td>\\n                        <td>\\n                            0,00\\n                        <\\/td>\\n                        <td>\\n                            2.950,00\\n                        <\\/td>\\n                                            <\\/tr>\\n                    \\n            <\\/tbody>\\n        <\\/table>\\n        <\\/div>\\n\\n        \\n\\n        <div style=\\\"height:200px;margin-top: 1%;\\\"> <!-- Totales -->\\n              <!-- Es factura B o C -->\\n                <table class=\\\"table-totales\\\" cellspacing=\\\"0\\\" width=\\\"100%\\\">\\n                    <tr>\\n                        <th style=\\\"width:50%; text-align:left;\\\">\\n\\n<!--                                <span style=\\\"width:100%;\\\"><img src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/barcodes\\/71304902469785.png\\\"><\\/span>\\n                                <span style=\\\"text-align:center;\\\">2737718350411000471304902469785202107255<\\/span>-->\\n                        <\\/th>\\n                        <th class=\\\"subtotales_conceptos\\\">TOTAL:<\\/th>\\n                        <th class=\\\"subtotales_importes\\\">$ 2.950,00<\\/th>\\n                    <\\/tr>\\n                <\\/table>\\n                <br>\\n                <table cellspacing=\\\"0\\\" width=\\\"100%\\\" style=\\\"border: none\\\">\\n                    <tr>\\n                        <th style=\\\"width:50%; text-align:left;\\\">\\n\\n                            <?xml version=\\\"1.0\\\" encoding=\\\"UTF-8\\\"?>\\n<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" version=\\\"1.1\\\" width=\\\"100\\\" height=\\\"100\\\" viewBox=\\\"0 0 100 100\\\"><rect x=\\\"0\\\" y=\\\"0\\\" width=\\\"100\\\" height=\\\"100\\\" fill=\\\"#ffffff\\\"\\/><g transform=\\\"scale(1.754)\\\"><g transform=\\\"translate(0,0)\\\"><path fill-rule=\\\"evenodd\\\" d=\\\"M8 0L8 1L10 1L10 0ZM11 0L11 2L12 2L12 3L9 3L9 2L8 2L8 5L10 5L10 4L11 4L11 6L10 6L10 7L9 7L9 6L8 6L8 7L9 7L9 8L8 8L8 10L6 10L6 11L5 11L5 10L4 10L4 11L3 11L3 12L4 12L4 13L3 13L3 14L4 14L4 13L5 13L5 12L6 12L6 13L8 13L8 14L5 14L5 15L2 15L2 17L8 17L8 16L9 16L9 15L8 15L8 14L10 14L10 17L9 17L9 18L10 18L10 19L11 19L11 15L12 15L12 16L13 16L13 15L14 15L14 18L13 18L13 19L12 19L12 22L11 22L11 23L10 23L10 20L9 20L9 23L8 23L8 21L7 21L7 20L8 20L8 18L6 18L6 19L4 19L4 18L3 18L3 19L2 19L2 20L1 20L1 19L0 19L0 20L1 20L1 21L0 21L0 22L1 22L1 21L2 21L2 22L3 22L3 21L4 21L4 23L5 23L5 24L3 24L3 25L4 25L4 26L2 26L2 23L1 23L1 24L0 24L0 25L1 25L1 27L0 27L0 28L1 28L1 29L0 29L0 30L2 30L2 31L0 31L0 32L2 32L2 33L0 33L0 37L3 37L3 38L4 38L4 39L5 39L5 40L4 40L4 41L3 41L3 40L2 40L2 38L0 38L0 40L1 40L1 41L0 41L0 42L5 42L5 43L7 43L7 44L5 44L5 45L3 45L3 44L4 44L4 43L0 43L0 44L2 44L2 45L0 45L0 48L5 48L5 47L10 47L10 48L6 48L6 49L8 49L8 50L9 50L9 53L8 53L8 57L9 57L9 55L12 55L12 56L13 56L13 57L14 57L14 56L15 56L15 55L14 55L14 56L13 56L13 53L14 53L14 54L15 54L15 53L16 53L16 54L17 54L17 55L18 55L18 56L17 56L17 57L18 57L18 56L19 56L19 57L21 57L21 56L19 56L19 55L18 55L18 54L20 54L20 51L21 51L21 52L23 52L23 50L24 50L24 53L25 53L25 54L23 54L23 56L22 56L22 57L24 57L24 56L26 56L26 55L25 55L25 54L27 54L27 53L31 53L31 54L33 54L33 55L32 55L32 56L34 56L34 57L36 57L36 55L38 55L38 56L37 56L37 57L44 57L44 56L43 56L43 55L42 55L42 56L41 56L41 55L40 55L40 54L42 54L42 53L40 53L40 52L43 52L43 53L45 53L45 52L46 52L46 51L45 51L45 49L47 49L47 48L48 48L48 50L47 50L47 53L46 53L46 54L44 54L44 55L45 55L45 56L46 56L46 57L47 57L47 54L48 54L48 55L49 55L49 54L50 54L50 57L51 57L51 54L52 54L52 53L55 53L55 54L56 54L56 53L57 53L57 51L56 51L56 49L57 49L57 48L56 48L56 49L55 49L55 51L53 51L53 49L54 49L54 48L53 48L53 46L54 46L54 45L56 45L56 46L55 46L55 47L57 47L57 44L53 44L53 46L52 46L52 43L51 43L51 44L50 44L50 42L51 42L51 41L50 41L50 40L51 40L51 39L52 39L52 38L51 38L51 39L50 39L50 36L51 36L51 35L52 35L52 37L54 37L54 38L53 38L53 39L54 39L54 41L53 41L53 40L52 40L52 42L54 42L54 43L55 43L55 42L57 42L57 40L56 40L56 38L57 38L57 31L56 31L56 30L57 30L57 27L56 27L56 24L57 24L57 21L56 21L56 20L53 20L53 19L54 19L54 18L55 18L55 14L54 14L54 10L53 10L53 9L55 9L55 10L56 10L56 11L55 11L55 12L57 12L57 8L56 8L56 9L55 9L55 8L52 8L52 10L51 10L51 11L50 11L50 10L49 10L49 9L50 9L50 8L48 8L48 7L49 7L49 6L48 6L48 7L47 7L47 5L48 5L48 0L45 0L45 1L43 1L43 0L39 0L39 1L41 1L41 4L40 4L40 5L39 5L39 2L38 2L38 1L37 1L37 2L36 2L36 1L32 1L32 2L31 2L31 0L30 0L30 1L29 1L29 0L28 0L28 1L26 1L26 0L24 0L24 1L23 1L23 0L22 0L22 1L23 1L23 2L22 2L22 3L21 3L21 4L20 4L20 5L21 5L21 4L22 4L22 10L21 10L21 11L20 11L20 12L19 12L19 10L20 10L20 9L21 9L21 8L20 8L20 7L21 7L21 6L20 6L20 7L19 7L19 6L18 6L18 7L17 7L17 6L16 6L16 7L15 7L15 6L14 6L14 5L13 5L13 4L14 4L14 3L15 3L15 5L17 5L17 4L16 4L16 3L17 3L17 2L18 2L18 1L17 1L17 2L15 2L15 1L16 1L16 0L14 0L14 2L13 2L13 0ZM19 1L19 2L21 2L21 1ZM25 1L25 2L23 2L23 3L22 3L22 4L23 4L23 3L24 3L24 5L23 5L23 10L22 10L22 11L21 11L21 12L22 12L22 13L23 13L23 14L24 14L24 16L23 16L23 15L22 15L22 14L20 14L20 13L19 13L19 12L18 12L18 10L19 10L19 9L20 9L20 8L18 8L18 9L17 9L17 8L15 8L15 7L14 7L14 6L13 6L13 5L12 5L12 6L11 6L11 7L10 7L10 8L9 8L9 9L13 9L13 10L12 10L12 12L13 12L13 13L15 13L15 14L14 14L14 15L15 15L15 16L16 16L16 14L17 14L17 16L18 16L18 17L17 17L17 18L15 18L15 19L13 19L13 22L12 22L12 23L14 23L14 24L16 24L16 23L18 23L18 22L19 22L19 23L20 23L20 24L19 24L19 25L18 25L18 26L17 26L17 25L16 25L16 26L15 26L15 25L14 25L14 26L15 26L15 27L16 27L16 28L14 28L14 29L13 29L13 30L12 30L12 33L11 33L11 31L10 31L10 30L11 30L11 29L12 29L12 28L11 28L11 29L10 29L10 28L9 28L9 29L10 29L10 30L9 30L9 31L4 31L4 28L2 28L2 27L1 27L1 28L2 28L2 30L3 30L3 31L4 31L4 32L3 32L3 33L6 33L6 34L7 34L7 35L6 35L6 36L5 36L5 37L4 37L4 36L3 36L3 35L4 35L4 34L3 34L3 35L2 35L2 36L3 36L3 37L4 37L4 38L5 38L5 37L6 37L6 38L7 38L7 39L6 39L6 40L7 40L7 41L6 41L6 42L7 42L7 43L8 43L8 44L7 44L7 45L5 45L5 46L3 46L3 47L5 47L5 46L7 46L7 45L8 45L8 46L10 46L10 47L11 47L11 48L10 48L10 49L9 49L9 50L10 50L10 51L11 51L11 52L10 52L10 53L9 53L9 54L11 54L11 53L12 53L12 51L13 51L13 50L12 50L12 51L11 51L11 48L12 48L12 47L11 47L11 45L10 45L10 44L11 44L11 43L13 43L13 44L12 44L12 45L13 45L13 47L15 47L15 49L14 49L14 48L13 48L13 49L14 49L14 50L15 50L15 49L16 49L16 53L17 53L17 52L18 52L18 53L19 53L19 52L18 52L18 51L20 51L20 48L22 48L22 49L23 49L23 48L22 48L22 47L24 47L24 46L22 46L22 44L21 44L21 43L24 43L24 44L23 44L23 45L25 45L25 46L27 46L27 44L28 44L28 47L26 47L26 48L24 48L24 50L25 50L25 49L26 49L26 48L28 48L28 47L29 47L29 48L30 48L30 47L32 47L32 50L31 50L31 51L32 51L32 50L33 50L33 51L35 51L35 52L36 52L36 53L35 53L35 55L34 55L34 56L35 56L35 55L36 55L36 53L37 53L37 54L38 54L38 55L39 55L39 56L40 56L40 55L39 55L39 53L37 53L37 51L38 51L38 52L40 52L40 50L41 50L41 51L42 51L42 50L43 50L43 51L44 51L44 49L45 49L45 48L46 48L46 46L47 46L47 45L48 45L48 44L49 44L49 42L50 42L50 41L47 41L47 42L48 42L48 43L46 43L46 44L45 44L45 42L46 42L46 40L47 40L47 39L48 39L48 38L49 38L49 37L48 37L48 36L50 36L50 33L51 33L51 31L50 31L50 33L48 33L48 31L46 31L46 32L45 32L45 31L44 31L44 32L43 32L43 29L44 29L44 30L45 30L45 29L44 29L44 27L46 27L46 29L47 29L47 30L48 30L48 27L47 27L47 25L45 25L45 24L46 24L46 23L45 23L45 22L44 22L44 21L46 21L46 22L47 22L47 23L48 23L48 26L50 26L50 25L51 25L51 23L52 23L52 25L53 25L53 27L55 27L55 29L54 29L54 28L53 28L53 29L54 29L54 32L53 32L53 31L52 31L52 34L54 34L54 32L55 32L55 35L54 35L54 37L55 37L55 38L54 38L54 39L55 39L55 38L56 38L56 36L55 36L55 35L56 35L56 32L55 32L55 30L56 30L56 27L55 27L55 22L56 22L56 21L55 21L55 22L54 22L54 21L53 21L53 22L51 22L51 21L52 21L52 20L51 20L51 19L50 19L50 20L49 20L49 22L48 22L48 21L47 21L47 20L45 20L45 19L46 19L46 17L47 17L47 19L48 19L48 18L49 18L49 17L50 17L50 18L51 18L51 17L52 17L52 19L53 19L53 17L54 17L54 14L52 14L52 13L53 13L53 10L52 10L52 11L51 11L51 12L52 12L52 13L51 13L51 17L50 17L50 15L49 15L49 17L47 17L47 16L46 16L46 15L47 15L47 13L48 13L48 14L50 14L50 12L49 12L49 10L48 10L48 8L47 8L47 9L46 9L46 10L48 10L48 11L46 11L46 12L47 12L47 13L46 13L46 14L45 14L45 12L44 12L44 13L43 13L43 12L42 12L42 13L41 13L41 9L44 9L44 10L43 10L43 11L45 11L45 7L46 7L46 5L47 5L47 3L46 3L46 2L47 2L47 1L45 1L45 3L44 3L44 5L43 5L43 4L41 4L41 7L42 7L42 8L41 8L41 9L39 9L39 8L38 8L38 9L37 9L37 8L35 8L35 7L36 7L36 6L37 6L37 7L38 7L38 6L37 6L37 5L38 5L38 3L37 3L37 5L35 5L35 4L34 4L34 5L33 5L33 7L32 7L32 4L33 4L33 3L34 3L34 2L33 2L33 3L31 3L31 8L32 8L32 9L31 9L31 10L33 10L33 11L34 11L34 10L35 10L35 13L34 13L34 14L32 14L32 15L33 15L33 17L30 17L30 18L28 18L28 19L27 19L27 17L29 17L29 16L30 16L30 15L29 15L29 13L30 13L30 14L31 14L31 13L33 13L33 12L31 12L31 11L26 11L26 12L25 12L25 11L24 11L24 8L25 8L25 10L27 10L27 9L26 9L26 8L25 8L25 7L26 7L26 6L25 6L25 5L26 5L26 4L25 4L25 2L26 2L26 3L28 3L28 4L30 4L30 3L29 3L29 2L26 2L26 1ZM18 3L18 5L19 5L19 3ZM45 3L45 5L46 5L46 3ZM27 5L27 8L30 8L30 5ZM42 5L42 7L43 7L43 8L44 8L44 7L45 7L45 6L44 6L44 7L43 7L43 5ZM12 6L12 7L11 7L11 8L12 8L12 7L13 7L13 9L14 9L14 11L15 11L15 13L17 13L17 14L18 14L18 12L17 12L17 11L16 11L16 10L15 10L15 9L14 9L14 7L13 7L13 6ZM24 6L24 7L25 7L25 6ZM28 6L28 7L29 7L29 6ZM34 6L34 7L35 7L35 6ZM39 6L39 7L40 7L40 6ZM0 8L0 9L4 9L4 8ZM6 8L6 9L7 9L7 8ZM28 9L28 10L30 10L30 9ZM36 9L36 13L35 13L35 15L39 15L39 16L38 16L38 17L37 17L37 19L36 19L36 18L35 18L35 17L36 17L36 16L35 16L35 17L33 17L33 18L31 18L31 19L35 19L35 20L37 20L37 22L36 22L36 21L35 21L35 22L32 22L32 20L30 20L30 19L28 19L28 20L27 20L27 19L25 19L25 18L24 18L24 19L22 19L22 18L21 18L21 19L20 19L20 16L19 16L19 17L18 17L18 19L16 19L16 20L14 20L14 21L15 21L15 23L16 23L16 21L17 21L17 22L18 22L18 21L17 21L17 20L18 20L18 19L20 19L20 21L19 21L19 22L20 22L20 21L21 21L21 19L22 19L22 23L25 23L25 25L26 25L26 29L25 29L25 27L24 27L24 26L23 26L23 25L22 25L22 24L20 24L20 25L19 25L19 27L17 27L17 28L16 28L16 30L13 30L13 31L14 31L14 32L13 32L13 33L12 33L12 34L13 34L13 33L14 33L14 32L15 32L15 31L17 31L17 32L18 32L18 28L19 28L19 30L20 30L20 28L19 28L19 27L21 27L21 26L23 26L23 30L22 30L22 29L21 29L21 30L22 30L22 31L20 31L20 33L21 33L21 32L22 32L22 35L26 35L26 36L25 36L25 37L27 37L27 35L28 35L28 37L29 37L29 39L30 39L30 38L31 38L31 40L27 40L27 42L29 42L29 41L30 41L30 44L29 44L29 43L28 43L28 44L29 44L29 45L30 45L30 46L31 46L31 45L32 45L32 47L33 47L33 46L34 46L34 48L33 48L33 50L34 50L34 48L35 48L35 47L36 47L36 49L35 49L35 51L36 51L36 49L37 49L37 48L38 48L38 45L37 45L37 47L36 47L36 45L35 45L35 46L34 46L34 45L32 45L32 43L31 43L31 41L33 41L33 43L35 43L35 44L37 44L37 42L38 42L38 44L39 44L39 47L40 47L40 45L41 45L41 48L42 48L42 49L43 49L43 48L45 48L45 45L44 45L44 44L43 44L43 43L42 43L42 45L41 45L41 43L40 43L40 44L39 44L39 42L38 42L38 41L37 41L37 42L36 42L36 40L35 40L35 39L38 39L38 40L39 40L39 41L40 41L40 42L42 42L42 41L43 41L43 42L45 42L45 40L46 40L46 38L45 38L45 37L46 37L46 36L48 36L48 35L49 35L49 34L48 34L48 33L47 33L47 32L46 32L46 33L44 33L44 35L43 35L43 32L42 32L42 33L41 33L41 31L40 31L40 30L41 30L41 29L43 29L43 27L42 27L42 28L41 28L41 26L40 26L40 25L39 25L39 24L40 24L40 23L41 23L41 25L42 25L42 24L43 24L43 25L44 25L44 26L45 26L45 25L44 25L44 24L45 24L45 23L44 23L44 22L43 22L43 18L44 18L44 17L46 17L46 16L45 16L45 15L44 15L44 14L42 14L42 15L41 15L41 13L40 13L40 10L39 10L39 13L38 13L38 12L37 12L37 9ZM1 10L1 11L0 11L0 13L2 13L2 10ZM8 10L8 13L9 13L9 11L10 11L10 14L11 14L11 11L10 11L10 10ZM6 11L6 12L7 12L7 11ZM23 12L23 13L24 13L24 12ZM26 12L26 14L25 14L25 16L24 16L24 17L25 17L25 16L26 16L26 15L27 15L27 12ZM36 13L36 14L38 14L38 13ZM39 13L39 15L40 15L40 13ZM0 14L0 15L1 15L1 14ZM19 14L19 15L20 15L20 14ZM5 15L5 16L7 16L7 15ZM28 15L28 16L29 16L29 15ZM42 15L42 16L39 16L39 17L38 17L38 18L41 18L41 17L42 17L42 18L43 18L43 17L42 17L42 16L43 16L43 15ZM52 15L52 16L53 16L53 15ZM56 16L56 18L57 18L57 16ZM6 19L6 20L5 20L5 21L6 21L6 22L7 22L7 21L6 21L6 20L7 20L7 19ZM24 19L24 20L25 20L25 19ZM37 19L37 20L38 20L38 19ZM39 19L39 20L40 20L40 19ZM41 19L41 20L42 20L42 19ZM2 20L2 21L3 21L3 20ZM29 20L29 21L28 21L28 22L27 22L27 21L25 21L25 23L26 23L26 24L28 24L28 26L31 26L31 27L33 27L33 28L34 28L34 29L35 29L35 31L36 31L36 29L37 29L37 30L39 30L39 29L41 29L41 28L38 28L38 29L37 29L37 27L38 27L38 24L39 24L39 23L38 23L38 24L37 24L37 26L35 26L35 25L36 25L36 23L35 23L35 25L34 25L34 23L33 23L33 24L32 24L32 22L31 22L31 23L30 23L30 20ZM33 20L33 21L34 21L34 20ZM50 20L50 21L51 21L51 20ZM23 21L23 22L24 22L24 21ZM38 21L38 22L40 22L40 21ZM26 22L26 23L27 23L27 22ZM53 22L53 23L54 23L54 22ZM6 23L6 24L7 24L7 25L6 25L6 26L9 26L9 27L11 27L11 26L9 26L9 25L10 25L10 24L9 24L9 25L8 25L8 23ZM49 23L49 25L50 25L50 23ZM11 24L11 25L12 25L12 27L13 27L13 25L12 25L12 24ZM31 24L31 26L34 26L34 25L32 25L32 24ZM39 26L39 27L40 27L40 26ZM5 27L5 30L8 30L8 27ZM27 27L27 30L30 30L30 27ZM49 27L49 30L52 30L52 27ZM6 28L6 29L7 29L7 28ZM28 28L28 29L29 29L29 28ZM31 28L31 29L32 29L32 28ZM35 28L35 29L36 29L36 28ZM50 28L50 29L51 29L51 28ZM24 29L24 32L25 32L25 34L26 34L26 35L27 35L27 34L30 34L30 35L29 35L29 36L30 36L30 35L31 35L31 38L33 38L33 36L32 36L32 34L31 34L31 33L33 33L33 34L36 34L36 35L37 35L37 34L38 34L38 36L37 36L37 37L39 37L39 38L38 38L38 39L40 39L40 41L42 41L42 38L44 38L44 39L45 39L45 38L44 38L44 37L45 37L45 36L46 36L46 34L47 34L47 33L46 33L46 34L45 34L45 36L41 36L41 35L42 35L42 34L39 34L39 33L40 33L40 32L38 32L38 31L37 31L37 32L35 32L35 33L33 33L33 32L34 32L34 30L33 30L33 31L32 31L32 30L31 30L31 33L30 33L30 31L26 31L26 32L25 32L25 29ZM9 31L9 33L8 33L8 32L6 32L6 33L7 33L7 34L9 34L9 36L11 36L11 37L8 37L8 36L6 36L6 37L7 37L7 38L9 38L9 39L8 39L8 40L12 40L12 42L13 42L13 43L14 43L14 44L15 44L15 43L14 43L14 42L13 42L13 41L14 41L14 39L15 39L15 38L17 38L17 39L16 39L16 40L15 40L15 42L16 42L16 43L17 43L17 45L18 45L18 46L17 46L17 47L18 47L18 48L16 48L16 49L17 49L17 50L19 50L19 48L20 48L20 47L21 47L21 46L20 46L20 47L18 47L18 46L19 46L19 44L20 44L20 45L21 45L21 44L20 44L20 43L18 43L18 42L20 42L20 41L18 41L18 42L17 42L17 41L16 41L16 40L17 40L17 39L18 39L18 40L20 40L20 39L18 39L18 38L19 38L19 36L18 36L18 38L17 38L17 37L16 37L16 36L17 36L17 35L18 35L18 34L17 34L17 35L16 35L16 34L15 34L15 35L13 35L13 36L15 36L15 37L14 37L14 39L13 39L13 37L12 37L12 36L11 36L11 35L10 35L10 34L9 34L9 33L10 33L10 31ZM22 31L22 32L23 32L23 31ZM26 32L26 33L27 33L27 32ZM37 32L37 33L38 33L38 32ZM23 33L23 34L24 34L24 33ZM19 34L19 35L20 35L20 38L21 38L21 37L22 37L22 38L24 38L24 36L23 36L23 37L22 37L22 36L21 36L21 34ZM34 36L34 39L33 39L33 40L34 40L34 39L35 39L35 38L36 38L36 37L35 37L35 36ZM39 36L39 37L40 37L40 39L41 39L41 37L40 37L40 36ZM11 37L11 38L10 38L10 39L11 39L11 38L12 38L12 37ZM26 38L26 39L28 39L28 38ZM12 39L12 40L13 40L13 39ZM21 39L21 40L22 40L22 39ZM24 39L24 40L23 40L23 42L24 42L24 41L25 41L25 44L26 44L26 41L25 41L25 39ZM55 40L55 41L54 41L54 42L55 42L55 41L56 41L56 40ZM8 41L8 42L10 42L10 43L9 43L9 44L10 44L10 43L11 43L11 42L10 42L10 41ZM21 41L21 42L22 42L22 41ZM30 44L30 45L31 45L31 44ZM14 45L14 46L16 46L16 45ZM43 45L43 47L42 47L42 48L43 48L43 47L44 47L44 45ZM49 45L49 48L50 48L50 46L51 46L51 45ZM1 46L1 47L2 47L2 46ZM51 47L51 48L52 48L52 47ZM39 48L39 49L38 49L38 51L39 51L39 50L40 50L40 48ZM27 49L27 52L30 52L30 49ZM49 49L49 52L52 52L52 49ZM21 50L21 51L22 51L22 50ZM28 50L28 51L29 51L29 50ZM50 50L50 51L51 51L51 50ZM14 51L14 52L15 52L15 51ZM25 51L25 52L26 52L26 51ZM55 51L55 53L56 53L56 51ZM31 52L31 53L32 53L32 52ZM33 52L33 54L34 54L34 52ZM21 53L21 55L22 55L22 53ZM50 53L50 54L51 54L51 53ZM53 54L53 56L52 56L52 57L55 57L55 56L54 56L54 54ZM27 55L27 57L31 57L31 56L30 56L30 55L29 55L29 56L28 56L28 55ZM56 55L56 56L57 56L57 55ZM0 0L0 7L7 7L7 0ZM1 1L1 6L6 6L6 1ZM2 2L2 5L5 5L5 2ZM50 0L50 7L57 7L57 0ZM51 1L51 6L56 6L56 1ZM52 2L52 5L55 5L55 2ZM0 50L0 57L7 57L7 50ZM1 51L1 56L6 56L6 51ZM2 52L2 55L5 55L5 52Z\\\" fill=\\\"#000000\\\"\\/><\\/g><\\/g><\\/svg>\\n\\n                            <span style=\\\"width:50%;\\\">\\n                                <img style=\\\"max-height: 70px\\\"\\n                                     src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/img\\/AfipComprobanteAutorizado.png\\\">\\n                            <\\/span>\\n                        <\\/th>\\n                        <th style=\\\"text-align:right;\\\">\\n                            <p>CAE N&#186;: 71304902469785<br>\\n                                Fecha Vto. CAE:  25\\/07\\/2021\\n                            <\\/p>\\n                        <\\/th>\\n                    <\\/tr>\\n                <\\/table>\\n                    <\\/div>\\n    <\\/div>\\n\\n    <\\/body>\\n<\\/html>\\\";s:4:\\\"file\\\";N;}s:6:\\\"locale\\\";N;s:4:\\\"from\\\";a:0:{}s:2:\\\"to\\\";a:1:{i:0;a:2:{s:4:\\\"name\\\";N;s:7:\\\"address\\\";s:27:\\\"pablo.-castillo@hotmail.com\\\";}}s:2:\\\"cc\\\";a:0:{}s:3:\\\"bcc\\\";a:1:{i:0;a:2:{s:4:\\\"name\\\";N;s:7:\\\"address\\\";s:23:\\\"info@masquecontable.com\\\";}}s:7:\\\"replyTo\\\";a:0:{}s:7:\\\"subject\\\";N;s:11:\\\"\\u0000*\\u0000markdown\\\";N;s:7:\\\"\\u0000*\\u0000html\\\";N;s:4:\\\"view\\\";N;s:8:\\\"textView\\\";N;s:8:\\\"viewData\\\";a:0:{}s:11:\\\"attachments\\\";a:0:{}s:14:\\\"rawAttachments\\\";a:0:{}s:15:\\\"diskAttachments\\\";a:0:{}s:9:\\\"callbacks\\\";a:0:{}s:5:\\\"theme\\\";N;s:6:\\\"mailer\\\";s:8:\\\"sendgrid\\\";s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:5:\\\"delay\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;}\"}}','ErrorException: Trying to get property \'id\' of non-object in /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php:16\nStack trace:\n#0 /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php(16): Illuminate\\Foundation\\Bootstrap\\HandleExceptions->handleError(8, \'Trying to get p...\', \'/home/forge/tax...\', 16, Array)\n#1 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(356): App\\Queue\\DatabaseJob->fire()\n#2 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(306): Illuminate\\Queue\\Worker->process(\'database\', Object(App\\Queue\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#3 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(132): Illuminate\\Queue\\Worker->runJob(Object(App\\Queue\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#4 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(112): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#5 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(96): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#6 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#7 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#8 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#9 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#10 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#11 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(134): Illuminate\\Container\\Container->call(Array)\n#12 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(256): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#13 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(121): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#14 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(971): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#15 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(290): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#16 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(166): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#17 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Application.php(93): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(129): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#19 /home/forge/taxes.com.ar/artisan(35): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#20 {main}','2021-07-23 18:04:00',NULL);
INSERT INTO `failed_jobs` VALUES (6,NULL,'database','default','{\"uuid\":\"da23ba2d-75e8-4753-a6e5-14ea5118e613\",\"displayName\":\"App\\\\Mail\\\\Fact_Electronica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"delay\":null,\"timeout\":null,\"timeoutAt\":null,\"data\":{\"commandName\":\"Illuminate\\\\Mail\\\\SendQueuedMailable\",\"command\":\"O:34:\\\"Illuminate\\\\Mail\\\\SendQueuedMailable\\\":3:{s:8:\\\"mailable\\\";O:25:\\\"App\\\\Mail\\\\Fact_Electronica\\\":27:{s:11:\\\"informacion\\\";a:6:{s:12:\\\"ruta_logo_fa\\\";N;s:4:\\\"mail\\\";s:23:\\\"info@masquecontable.com\\\";s:18:\\\"name_quien_factura\\\";s:19:\\\"MICAELA AILIN CORIA\\\";s:7:\\\"cliente\\\";O:17:\\\"App\\\\Models\\\\Person\\\":27:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:7:\\\"persons\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:40729;s:7:\\\"user_id\\\";i:5115;s:11:\\\"field_name1\\\";s:17:\\\"CASTRO NORA EDITH\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-20569456-6\\\";s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-07-05 18:32:12\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-07-05 18:32:12\\\";s:11:\\\"activity_id\\\";i:1;s:7:\\\"address\\\";s:116:\\\"Direccion\\r\\nGRANADEROS 35 Piso:02\\r\\nCod. Postal\\r\\n1406\\r\\nProvincia\\r\\nCIUDAD AUTONOMA BUENOS AIRES\\r\\nTipo Domicilio\\r\\nFISCAL\\\";s:14:\\\"person_type_id\\\";i:1;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:40729;s:7:\\\"user_id\\\";i:5115;s:11:\\\"field_name1\\\";s:17:\\\"CASTRO NORA EDITH\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-20569456-6\\\";s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-07-05 18:32:12\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-07-05 18:32:12\\\";s:11:\\\"activity_id\\\";i:1;s:7:\\\"address\\\";s:116:\\\"Direccion\\r\\nGRANADEROS 35 Piso:02\\r\\nCod. Postal\\r\\n1406\\r\\nProvincia\\r\\nCIUDAD AUTONOMA BUENOS AIRES\\r\\nTipo Domicilio\\r\\nFISCAL\\\";s:14:\\\"person_type_id\\\";i:1;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}s:14:\\\"nombre_del_pdf\\\";s:28:\\\"Factura N\\u00b00004-00000009.pdf\\\";s:9:\\\"body_mail\\\";s:155:\\\"Estimado cliente, se env\\u00eda adjunta la factura de honorarios correspondientes al mes de Julio 2021.\\nMuchas gracias por seguir eligiendo nuestros servicios.\\\";}s:3:\\\"pdf\\\";O:26:\\\"Barryvdh\\\\Snappy\\\\PdfWrapper\\\":4:{s:9:\\\"\\u0000*\\u0000snappy\\\";O:35:\\\"Barryvdh\\\\Snappy\\\\IlluminateSnappyPdf\\\":10:{s:26:\\\"\\u0000*\\u0000optionsWithContentCheck\\\";a:4:{s:11:\\\"header-html\\\";s:4:\\\"html\\\";s:11:\\\"footer-html\\\";s:4:\\\"html\\\";s:5:\\\"cover\\\";s:4:\\\"html\\\";s:15:\\\"xsl-style-sheet\\\";s:3:\\\"xsl\\\";}s:36:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000binary\\\";s:76:\\\"\\/home\\/forge\\/taxes.com.ar\\/vendor\\/h4cc\\/wkhtmltopdf-amd64\\/bin\\/wkhtmltopdf-amd64\\\";s:37:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000options\\\";a:132:{s:7:\\\"collate\\\";N;s:10:\\\"no-collate\\\";N;s:10:\\\"cookie-jar\\\";N;s:6:\\\"copies\\\";i:1;s:3:\\\"dpi\\\";N;s:13:\\\"extended-help\\\";N;s:9:\\\"grayscale\\\";N;s:4:\\\"help\\\";N;s:7:\\\"htmldoc\\\";N;s:18:\\\"ignore-load-errors\\\";N;s:9:\\\"image-dpi\\\";N;s:13:\\\"image-quality\\\";N;s:7:\\\"license\\\";N;s:9:\\\"log-level\\\";N;s:10:\\\"lowquality\\\";b:1;s:7:\\\"manpage\\\";N;s:13:\\\"margin-bottom\\\";N;s:11:\\\"margin-left\\\";N;s:12:\\\"margin-right\\\";N;s:10:\\\"margin-top\\\";N;s:11:\\\"orientation\\\";N;s:11:\\\"page-height\\\";N;s:9:\\\"page-size\\\";s:2:\\\"a4\\\";s:10:\\\"page-width\\\";N;s:18:\\\"no-pdf-compression\\\";N;s:5:\\\"quiet\\\";N;s:20:\\\"read-args-from-stdin\\\";N;s:6:\\\"readme\\\";N;s:5:\\\"title\\\";N;s:11:\\\"use-xserver\\\";N;s:7:\\\"version\\\";N;s:20:\\\"dump-default-toc-xsl\\\";N;s:12:\\\"dump-outline\\\";N;s:7:\\\"outline\\\";N;s:10:\\\"no-outline\\\";N;s:13:\\\"outline-depth\\\";N;s:13:\\\"output-format\\\";N;s:5:\\\"allow\\\";N;s:10:\\\"background\\\";N;s:13:\\\"no-background\\\";N;s:16:\\\"bypass-proxy-for\\\";N;s:9:\\\"cache-dir\\\";N;s:20:\\\"checkbox-checked-svg\\\";N;s:12:\\\"checkbox-svg\\\";N;s:6:\\\"cookie\\\";N;s:13:\\\"custom-header\\\";N;s:25:\\\"custom-header-propagation\\\";N;s:28:\\\"no-custom-header-propagation\\\";N;s:16:\\\"debug-javascript\\\";N;s:19:\\\"no-debug-javascript\\\";N;s:14:\\\"default-header\\\";N;s:8:\\\"encoding\\\";N;s:22:\\\"disable-external-links\\\";N;s:21:\\\"enable-external-links\\\";N;s:13:\\\"disable-forms\\\";N;s:12:\\\"enable-forms\\\";N;s:6:\\\"images\\\";N;s:9:\\\"no-images\\\";N;s:22:\\\"disable-internal-links\\\";N;s:21:\\\"enable-internal-links\\\";N;s:18:\\\"disable-javascript\\\";N;s:17:\\\"enable-javascript\\\";N;s:16:\\\"javascript-delay\\\";N;s:19:\\\"keep-relative-links\\\";N;s:19:\\\"load-error-handling\\\";N;s:25:\\\"load-media-error-handling\\\";N;s:25:\\\"disable-local-file-access\\\";N;s:24:\\\"enable-local-file-access\\\";N;s:17:\\\"minimum-font-size\\\";N;s:20:\\\"exclude-from-outline\\\";N;s:18:\\\"include-in-outline\\\";N;s:11:\\\"page-offset\\\";N;s:8:\\\"password\\\";N;s:15:\\\"disable-plugins\\\";N;s:14:\\\"enable-plugins\\\";N;s:4:\\\"post\\\";N;s:9:\\\"post-file\\\";N;s:16:\\\"print-media-type\\\";N;s:19:\\\"no-print-media-type\\\";N;s:5:\\\"proxy\\\";N;s:21:\\\"proxy-hostname-lookup\\\";N;s:23:\\\"radiobutton-checked-svg\\\";N;s:15:\\\"radiobutton-svg\\\";N;s:14:\\\"redirect-delay\\\";N;s:22:\\\"resolve-relative-links\\\";N;s:10:\\\"run-script\\\";N;s:23:\\\"disable-smart-shrinking\\\";N;s:22:\\\"enable-smart-shrinking\\\";N;s:12:\\\"ssl-crt-path\\\";N;s:16:\\\"ssl-key-password\\\";N;s:12:\\\"ssl-key-path\\\";N;s:17:\\\"stop-slow-scripts\\\";N;s:20:\\\"no-stop-slow-scripts\\\";N;s:22:\\\"disable-toc-back-links\\\";N;s:21:\\\"enable-toc-back-links\\\";N;s:16:\\\"user-style-sheet\\\";N;s:8:\\\"username\\\";N;s:13:\\\"viewport-size\\\";N;s:13:\\\"window-status\\\";N;s:4:\\\"zoom\\\";N;s:13:\\\"footer-center\\\";s:25:\\\"Pagina [page] de [toPage]\\\";s:16:\\\"footer-font-name\\\";N;s:16:\\\"footer-font-size\\\";i:8;s:11:\\\"footer-html\\\";N;s:11:\\\"footer-left\\\";s:0:\\\"\\\";s:11:\\\"footer-line\\\";N;s:14:\\\"no-footer-line\\\";N;s:12:\\\"footer-right\\\";N;s:14:\\\"footer-spacing\\\";N;s:13:\\\"header-center\\\";N;s:16:\\\"header-font-name\\\";N;s:16:\\\"header-font-size\\\";N;s:11:\\\"header-html\\\";N;s:11:\\\"header-left\\\";N;s:11:\\\"header-line\\\";N;s:14:\\\"no-header-line\\\";N;s:12:\\\"header-right\\\";N;s:14:\\\"header-spacing\\\";N;s:7:\\\"replace\\\";N;s:5:\\\"cover\\\";N;s:3:\\\"toc\\\";N;s:20:\\\"disable-dotted-lines\\\";N;s:9:\\\"toc-depth\\\";N;s:13:\\\"toc-font-name\\\";N;s:16:\\\"toc-l1-font-size\\\";N;s:15:\\\"toc-header-text\\\";N;s:20:\\\"toc-header-font-name\\\";N;s:20:\\\"toc-header-font-size\\\";N;s:21:\\\"toc-level-indentation\\\";N;s:17:\\\"disable-toc-links\\\";N;s:20:\\\"toc-text-size-shrink\\\";N;s:15:\\\"xsl-style-sheet\\\";N;}s:33:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000env\\\";N;s:37:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000timeout\\\";b:0;s:46:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000defaultExtension\\\";s:3:\\\"pdf\\\";s:18:\\\"\\u0000*\\u0000temporaryFolder\\\";N;s:14:\\\"temporaryFiles\\\";a:0:{}s:36:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000logger\\\";O:18:\\\"Psr\\\\Log\\\\NullLogger\\\":0:{}s:2:\\\"fs\\\";O:32:\\\"Illuminate\\\\Filesystem\\\\Filesystem\\\":0:{}}s:10:\\\"\\u0000*\\u0000options\\\";a:0:{}s:4:\\\"html\\\";s:22108:\\\"<!DOCTYPE html>\\n<html lang=\\\"en\\\">\\n    <head>\\n        <meta charset=\\\"utf-8\\\">\\n    <\\/head>\\n    <style>\\n        .subtotales_conceptos{\\n            width:30%;\\n            text-align: right;\\n        }\\n        .subtotales_importes{\\n            text-align: right;\\n        }\\n        .table-totales, .table-totales tr, .table-totales th{\\n            border: 1px solid;\\n        }\\n\\n    <\\/style>\\n    <body>\\n    <div style=\\\"max-height:840px\\\">\\n        <div style=\\\"width: 100%; height:270px\\\"> <!-- Datos de la empresa -->\\n            <table class=\\\"display\\\" cellspacing=\\\"0\\\" width=\\\"100%\\\" style=\\\"border:  1px solid;\\\">\\n                <tr style=\\\"\\\">\\n                    <th colspan=\\\"2\\\" rowspan=\\\"2\\\" style=\\\"width:45%;margin:0;height:150px;\\\">\\n                                                <img src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/img\\/\\/27377183504\\/logo_punto_venta_0000.png\\\"\\/>\\n                                            <\\/th>\\n                    <th style=\\\"border:  1px solid;text-align: center; width:10%\\\" colspan=\\\"2\\\">\\n                        <span style=\\\"font-size: 60px;\\\">C<\\/span> <br \\/> <span style=\\\"font-size: 14px;\\\">cod. 11<\\/span>\\n                    <\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"font-size: 28px;text-align: center;width:45%\\\">\\n                        Factura\\n                        <br>\\n                        0004 - 00000009\\n                    <\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th><\\/th>\\n                    <th style=\\\"border:  1px 1px 1px 0px solid;\\\" colspan=\\\"2\\\"><\\/th>\\n                    <th><\\/th>\\n                <\\/tr>\\n                <tr>\\n\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                                                    Raz&oacute;n Social:\\n                            <span style=\\\"font-weight: normal;\\\">MICAELA AILIN CORIA<\\/span>\\n                                            <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">Fecha de Emisi&oacute;n: <span style=\\\"font-weight: normal;\\\">15\\/07\\/2021<\\/span><\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Domicilio Comercial: <span style=\\\"font-weight: normal;\\\">Victor Guillet esq. Arturo M Bas, C.P.:5800,\\n                        C\\u00f3rdoba<\\/span>\\n                    <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">CUIT: <span style=\\\"font-weight: normal;\\\">27-37718350-4<\\/span><\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Condici&oacute;n frente al IVA: <span style=\\\"font-weight: normal;\\\">Monotributo<\\/span>\\n                    <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Ingresos Brutos: <span style=\\\"font-weight: normal;\\\"><\\/span>\\n                        <br>\\n                        Fecha de Inicio de Actividades: <span style=\\\"font-weight: normal;\\\">09\\/07\\/2021<\\/span>\\n                    <\\/th>\\n                <\\/tr>\\n            <\\/table>\\n        <\\/div>\\n\\n        <table style=\\\"text-align: center; width: 100%;border: solid 1px;\\\"> <!-- Fechas -->\\n            <thead>\\n                <tr>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Per\\u00edodo Facturado Desde: 01\\/07\\/2021<\\/small><\\/th>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Per\\u00edodo Facturado Hasta: 31\\/07\\/2021<\\/small><\\/th>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Fecha Vto. Pago: 15\\/07\\/2021<\\/small><\\/th>\\n                <\\/tr>\\n            <\\/thead>\\n        <\\/table>\\n        \\n        <table style=\\\"width: 100%; margin-top: 1%;border: solid 1px;\\\"> <!-- Datos Clientes -->\\n            <tr>\\n                <th style=\\\"text-align:left;\\\"colspan=\\\"12\\\">\\n                    CUIT: <span style=\\\"font-weight: normal;\\\">27-20569456-6<\\/span>\\n                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\\n                    Apellido y Nombre \\/ Raz&oacute;n Social: <span style=\\\"font-weight: normal;\\\">\\n                    CASTRO NORA EDITH<\\/span>\\n                <\\/th>\\n            <\\/tr>\\n            <tr>\\n                <th style=\\\"text-align:left; width:50%\\\">\\n                    Condici&oacute;n Frente al IVA: <span style=\\\"font-weight: normal;\\\">Responsable Monotributo<\\/span>\\n                <\\/th>\\n                <th style=\\\"text-align:left; width:50%\\\" colspan=\\\"4\\\">\\n                    Domicilio Comercial:\\n                    <span style=\\\"font-weight: normal;\\\">\\n                    Direccion\\r\\nGRANADEROS 35 Piso:02\\r\\nCod. Postal\\r\\n1406\\r\\nProvincia\\r\\nCIUDAD AUTONOMA BUENOS AIRES\\r\\nTipo Domicilio\\r\\nFISCAL\\n                    <\\/span>\\n                <\\/th>\\n            <\\/tr>\\n            <tr style=\\\"text-align:left\\\">\\n                <th>Condici&oacute;n de Venta: <span style=\\\"font-weight: normal;\\\">Cuenta Corriente<\\/span><\\/th>\\n            <\\/tr>\\n        <\\/table>\\n\\n        <div style=\\\"border: 1px solid;margin-top: 1%;min-height:600px;\\\">\\n        <table style=\\\"text-align: center; width: 100%; margin-top: 1%;\\\"> <!-- Body -->\\n            <tr style=\\\"border-bottom: 1px solid;font-size: 15px\\\">\\n                <th>C&oacute;digo<\\/th>\\n                <th style=\\\"width: 25%;\\\">Detalle<\\/th>\\n                <th>Cantidad<\\/th>\\n                <th>U.Medida<\\/th>\\n                <th>Precio U.<\\/th>\\n                <th>Bonif. (%)<\\/th>\\n                <th>Precio Bonif.<\\/th>\\n                <th>Subtotal<\\/th>\\n                            <\\/tr>\\n            <tbody>\\n                                                                                <tr style=\\\"font-size: 12px;\\\">\\n                        <td>\\n                            \\n                        <\\/td>\\n                        <td>\\n                            Honorarios profesionales Julio 2021\\n                        <\\/td>\\n                        <td>\\n                            1.00\\n                        <\\/td>\\n                        <td>\\n                            Unidades\\n                        <\\/td>\\n                        <td>                            2.950,00\\n                                                    <\\/td>\\n                        <td>\\n                            0,00%\\n                        <\\/td>\\n                        <td>\\n                            0,00\\n                        <\\/td>\\n                        <td>\\n                            2.950,00\\n                        <\\/td>\\n                                            <\\/tr>\\n                    \\n            <\\/tbody>\\n        <\\/table>\\n        <\\/div>\\n\\n        \\n\\n        <div style=\\\"height:200px;margin-top: 1%;\\\"> <!-- Totales -->\\n              <!-- Es factura B o C -->\\n                <table class=\\\"table-totales\\\" cellspacing=\\\"0\\\" width=\\\"100%\\\">\\n                    <tr>\\n                        <th style=\\\"width:50%; text-align:left;\\\">\\n\\n<!--                                <span style=\\\"width:100%;\\\"><img src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/barcodes\\/71304902471683.png\\\"><\\/span>\\n                                <span style=\\\"text-align:center;\\\">2737718350411000471304902471683202107259<\\/span>-->\\n                        <\\/th>\\n                        <th class=\\\"subtotales_conceptos\\\">TOTAL:<\\/th>\\n                        <th class=\\\"subtotales_importes\\\">$ 2.950,00<\\/th>\\n                    <\\/tr>\\n                <\\/table>\\n                <br>\\n                <table cellspacing=\\\"0\\\" width=\\\"100%\\\" style=\\\"border: none\\\">\\n                    <tr>\\n                        <th style=\\\"width:50%; text-align:left;\\\">\\n\\n                            <?xml version=\\\"1.0\\\" encoding=\\\"UTF-8\\\"?>\\n<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" version=\\\"1.1\\\" width=\\\"100\\\" height=\\\"100\\\" viewBox=\\\"0 0 100 100\\\"><rect x=\\\"0\\\" y=\\\"0\\\" width=\\\"100\\\" height=\\\"100\\\" fill=\\\"#ffffff\\\"\\/><g transform=\\\"scale(1.754)\\\"><g transform=\\\"translate(0,0)\\\"><path fill-rule=\\\"evenodd\\\" d=\\\"M8 0L8 1L10 1L10 0ZM11 0L11 2L8 2L8 5L9 5L9 3L11 3L11 2L12 2L12 4L14 4L14 3L15 3L15 5L17 5L17 4L16 4L16 3L17 3L17 2L18 2L18 1L17 1L17 2L15 2L15 1L16 1L16 0L14 0L14 2L13 2L13 0ZM22 0L22 1L23 1L23 2L22 2L22 3L21 3L21 4L20 4L20 5L21 5L21 4L22 4L22 10L21 10L21 11L20 11L20 12L19 12L19 10L20 10L20 9L21 9L21 8L20 8L20 7L21 7L21 6L20 6L20 7L19 7L19 6L18 6L18 7L17 7L17 6L16 6L16 7L15 7L15 6L14 6L14 5L11 5L11 6L10 6L10 7L9 7L9 6L8 6L8 7L9 7L9 8L8 8L8 9L7 9L7 8L6 8L6 9L5 9L5 11L3 11L3 14L4 14L4 13L5 13L5 12L6 12L6 13L8 13L8 14L5 14L5 15L8 15L8 16L6 16L6 17L5 17L5 16L4 16L4 15L2 15L2 17L4 17L4 18L3 18L3 19L2 19L2 18L1 18L1 19L2 19L2 20L1 20L1 21L0 21L0 22L1 22L1 21L2 21L2 20L4 20L4 23L3 23L3 22L2 22L2 23L1 23L1 24L0 24L0 25L1 25L1 26L0 26L0 28L1 28L1 30L3 30L3 31L0 31L0 32L2 32L2 33L0 33L0 34L2 34L2 35L3 35L3 36L0 36L0 40L1 40L1 41L0 41L0 45L1 45L1 46L0 46L0 48L5 48L5 47L7 47L7 48L6 48L6 49L8 49L8 50L9 50L9 49L10 49L10 48L11 48L11 51L12 51L12 52L13 52L13 54L15 54L15 53L16 53L16 54L17 54L17 55L18 55L18 56L17 56L17 57L18 57L18 56L19 56L19 57L21 57L21 56L19 56L19 55L18 55L18 54L20 54L20 51L21 51L21 52L23 52L23 50L24 50L24 53L25 53L25 54L23 54L23 56L22 56L22 57L24 57L24 56L26 56L26 55L25 55L25 54L27 54L27 53L31 53L31 54L33 54L33 55L32 55L32 56L34 56L34 57L36 57L36 55L38 55L38 56L37 56L37 57L44 57L44 56L43 56L43 55L42 55L42 56L41 56L41 55L40 55L40 54L42 54L42 53L40 53L40 52L43 52L43 53L45 53L45 52L46 52L46 51L45 51L45 49L47 49L47 48L48 48L48 50L47 50L47 53L46 53L46 54L44 54L44 55L45 55L45 56L46 56L46 57L48 57L48 55L49 55L49 54L50 54L50 57L51 57L51 54L52 54L52 53L55 53L55 54L56 54L56 53L57 53L57 51L56 51L56 49L57 49L57 48L56 48L56 49L55 49L55 51L53 51L53 49L54 49L54 48L53 48L53 46L54 46L54 45L56 45L56 46L55 46L55 47L57 47L57 44L53 44L53 46L52 46L52 43L51 43L51 44L50 44L50 42L51 42L51 41L50 41L50 40L52 40L52 42L54 42L54 43L55 43L55 42L57 42L57 40L56 40L56 38L57 38L57 31L56 31L56 30L57 30L57 27L56 27L56 24L57 24L57 21L56 21L56 20L53 20L53 19L54 19L54 18L55 18L55 14L54 14L54 10L53 10L53 9L55 9L55 10L56 10L56 11L55 11L55 12L57 12L57 8L56 8L56 9L55 9L55 8L52 8L52 10L51 10L51 11L50 11L50 10L49 10L49 9L50 9L50 8L48 8L48 7L49 7L49 6L48 6L48 7L47 7L47 5L48 5L48 0L45 0L45 1L43 1L43 0L39 0L39 1L41 1L41 4L40 4L40 5L39 5L39 2L38 2L38 1L37 1L37 2L36 2L36 1L32 1L32 2L31 2L31 0L30 0L30 1L29 1L29 0L28 0L28 1L26 1L26 0L24 0L24 1L23 1L23 0ZM19 1L19 2L21 2L21 1ZM25 1L25 2L23 2L23 3L22 3L22 4L23 4L23 3L24 3L24 5L23 5L23 10L22 10L22 13L23 13L23 14L24 14L24 16L23 16L23 15L22 15L22 14L20 14L20 13L19 13L19 12L18 12L18 10L19 10L19 9L20 9L20 8L18 8L18 9L17 9L17 8L15 8L15 7L14 7L14 6L13 6L13 7L12 7L12 6L11 6L11 7L10 7L10 8L9 8L9 9L13 9L13 10L12 10L12 13L11 13L11 10L10 10L10 11L9 11L9 10L7 10L7 9L6 9L6 10L7 10L7 11L6 11L6 12L7 12L7 11L8 11L8 13L9 13L9 12L10 12L10 13L11 13L11 18L9 18L9 19L8 19L8 18L7 18L7 17L6 17L6 18L4 18L4 19L6 19L6 20L5 20L5 21L6 21L6 22L7 22L7 21L8 21L8 23L9 23L9 21L10 21L10 23L12 23L12 24L11 24L11 25L12 25L12 27L14 27L14 28L15 28L15 29L14 29L14 30L16 30L16 28L17 28L17 27L19 27L19 28L18 28L18 32L17 32L17 31L15 31L15 32L14 32L14 31L13 31L13 30L12 30L12 29L13 29L13 28L11 28L11 27L9 27L9 28L11 28L11 29L10 29L10 30L9 30L9 31L10 31L10 33L9 33L9 32L8 32L8 33L9 33L9 34L7 34L7 33L6 33L6 32L7 32L7 31L5 31L5 32L4 32L4 31L3 31L3 33L6 33L6 34L7 34L7 35L6 35L6 36L4 36L4 38L3 38L3 37L2 37L2 40L3 40L3 41L4 41L4 40L7 40L7 41L6 41L6 42L7 42L7 43L5 43L5 42L2 42L2 43L4 43L4 46L3 46L3 44L1 44L1 45L2 45L2 46L1 46L1 47L2 47L2 46L3 46L3 47L5 47L5 44L7 44L7 43L8 43L8 45L13 45L13 47L12 47L12 48L13 48L13 49L14 49L14 50L15 50L15 49L16 49L16 53L17 53L17 52L18 52L18 53L19 53L19 52L18 52L18 51L20 51L20 48L22 48L22 49L23 49L23 48L22 48L22 47L24 47L24 46L22 46L22 43L24 43L24 44L23 44L23 45L25 45L25 46L27 46L27 44L28 44L28 47L26 47L26 48L24 48L24 50L25 50L25 49L26 49L26 48L28 48L28 47L29 47L29 48L30 48L30 47L32 47L32 50L31 50L31 51L32 51L32 50L33 50L33 51L35 51L35 52L36 52L36 53L35 53L35 55L34 55L34 56L35 56L35 55L36 55L36 53L37 53L37 54L38 54L38 55L39 55L39 56L40 56L40 55L39 55L39 53L37 53L37 51L38 51L38 52L40 52L40 50L41 50L41 51L42 51L42 50L43 50L43 51L44 51L44 49L45 49L45 48L46 48L46 46L47 46L47 45L48 45L48 44L49 44L49 42L50 42L50 41L47 41L47 42L48 42L48 43L46 43L46 44L45 44L45 42L46 42L46 40L47 40L47 39L48 39L48 38L47 38L47 37L50 37L50 33L51 33L51 31L50 31L50 33L48 33L48 31L46 31L46 32L45 32L45 31L44 31L44 32L43 32L43 29L44 29L44 30L45 30L45 29L44 29L44 27L46 27L46 29L47 29L47 30L48 30L48 27L47 27L47 25L45 25L45 24L44 24L44 25L43 25L43 24L42 24L42 25L41 25L41 23L40 23L40 24L39 24L39 23L38 23L38 24L37 24L37 26L35 26L35 25L36 25L36 23L35 23L35 25L34 25L34 23L33 23L33 24L32 24L32 22L35 22L35 21L36 21L36 22L37 22L37 20L38 20L38 19L37 19L37 17L38 17L38 18L41 18L41 17L42 17L42 18L43 18L43 22L44 22L44 23L45 23L45 22L44 22L44 21L46 21L46 22L47 22L47 23L48 23L48 26L50 26L50 25L51 25L51 23L52 23L52 25L53 25L53 27L55 27L55 29L54 29L54 28L53 28L53 29L54 29L54 32L53 32L53 31L52 31L52 34L54 34L54 32L55 32L55 35L54 35L54 37L52 37L52 35L51 35L51 38L50 38L50 39L52 39L52 40L53 40L53 41L54 41L54 42L55 42L55 41L56 41L56 40L55 40L55 41L54 41L54 39L55 39L55 38L56 38L56 36L55 36L55 35L56 35L56 32L55 32L55 30L56 30L56 27L55 27L55 23L54 23L54 22L51 22L51 21L52 21L52 20L51 20L51 19L53 19L53 18L51 18L51 17L54 17L54 14L52 14L52 13L53 13L53 10L52 10L52 11L51 11L51 12L52 12L52 13L51 13L51 15L50 15L50 16L49 16L49 17L47 17L47 16L46 16L46 15L47 15L47 13L48 13L48 14L50 14L50 12L49 12L49 10L48 10L48 8L47 8L47 9L46 9L46 10L48 10L48 11L46 11L46 12L47 12L47 13L46 13L46 14L45 14L45 12L44 12L44 13L43 13L43 12L42 12L42 13L41 13L41 9L44 9L44 10L43 10L43 11L45 11L45 7L46 7L46 5L47 5L47 3L46 3L46 2L47 2L47 1L45 1L45 3L44 3L44 5L43 5L43 4L41 4L41 7L42 7L42 8L41 8L41 9L39 9L39 8L38 8L38 9L37 9L37 8L35 8L35 7L36 7L36 6L37 6L37 7L38 7L38 6L37 6L37 5L38 5L38 3L37 3L37 5L35 5L35 4L34 4L34 5L33 5L33 7L32 7L32 4L33 4L33 3L34 3L34 2L33 2L33 3L31 3L31 8L32 8L32 9L31 9L31 10L33 10L33 11L34 11L34 10L35 10L35 13L34 13L34 14L32 14L32 15L33 15L33 17L30 17L30 18L28 18L28 19L27 19L27 17L29 17L29 16L30 16L30 15L29 15L29 13L30 13L30 14L31 14L31 13L33 13L33 12L31 12L31 11L26 11L26 12L25 12L25 11L24 11L24 8L25 8L25 10L27 10L27 9L26 9L26 8L25 8L25 7L26 7L26 6L25 6L25 5L26 5L26 4L25 4L25 2L26 2L26 3L28 3L28 4L30 4L30 3L29 3L29 2L26 2L26 1ZM18 3L18 5L19 5L19 3ZM45 3L45 5L46 5L46 3ZM27 5L27 8L30 8L30 5ZM42 5L42 7L43 7L43 8L44 8L44 7L45 7L45 6L44 6L44 7L43 7L43 5ZM24 6L24 7L25 7L25 6ZM28 6L28 7L29 7L29 6ZM34 6L34 7L35 7L35 6ZM39 6L39 7L40 7L40 6ZM11 7L11 8L12 8L12 7ZM13 7L13 9L14 9L14 11L15 11L15 13L12 13L12 14L13 14L13 15L14 15L14 18L13 18L13 19L12 19L12 22L13 22L13 19L15 19L15 18L17 18L17 17L18 17L18 19L16 19L16 20L14 20L14 21L15 21L15 23L16 23L16 24L14 24L14 23L13 23L13 24L12 24L12 25L13 25L13 26L14 26L14 25L15 25L15 26L16 26L16 25L17 25L17 26L18 26L18 25L19 25L19 27L21 27L21 26L22 26L22 27L23 27L23 30L22 30L22 29L21 29L21 30L22 30L22 31L20 31L20 33L21 33L21 32L22 32L22 35L26 35L26 36L25 36L25 37L27 37L27 35L28 35L28 37L29 37L29 39L30 39L30 38L31 38L31 40L27 40L27 42L29 42L29 41L30 41L30 44L29 44L29 43L28 43L28 44L29 44L29 45L30 45L30 46L31 46L31 45L32 45L32 47L33 47L33 46L34 46L34 48L33 48L33 50L34 50L34 48L35 48L35 47L36 47L36 49L35 49L35 51L36 51L36 49L37 49L37 48L38 48L38 45L37 45L37 47L36 47L36 45L35 45L35 46L34 46L34 45L32 45L32 43L31 43L31 41L33 41L33 43L35 43L35 44L37 44L37 42L38 42L38 44L39 44L39 47L40 47L40 45L41 45L41 48L42 48L42 49L43 49L43 48L45 48L45 45L44 45L44 44L43 44L43 43L42 43L42 45L41 45L41 43L40 43L40 44L39 44L39 42L38 42L38 41L37 41L37 42L36 42L36 40L35 40L35 39L38 39L38 40L39 40L39 41L40 41L40 42L42 42L42 41L43 41L43 42L45 42L45 40L46 40L46 38L45 38L45 37L46 37L46 36L48 36L48 35L49 35L49 34L48 34L48 33L47 33L47 32L46 32L46 33L44 33L44 35L43 35L43 32L42 32L42 33L41 33L41 31L40 31L40 30L41 30L41 29L43 29L43 27L42 27L42 28L41 28L41 26L40 26L40 25L39 25L39 24L38 24L38 27L37 27L37 29L36 29L36 28L35 28L35 29L34 29L34 28L33 28L33 27L31 27L31 26L34 26L34 25L32 25L32 24L31 24L31 26L28 26L28 24L26 24L26 23L27 23L27 22L28 22L28 21L29 21L29 20L30 20L30 23L31 23L31 22L32 22L32 20L30 20L30 19L28 19L28 20L27 20L27 19L25 19L25 18L24 18L24 19L22 19L22 18L21 18L21 19L20 19L20 16L19 16L19 17L18 17L18 16L17 16L17 14L18 14L18 12L17 12L17 11L16 11L16 10L15 10L15 9L14 9L14 7ZM0 8L0 9L4 9L4 8ZM28 9L28 10L30 10L30 9ZM36 9L36 13L35 13L35 15L39 15L39 16L38 16L38 17L39 17L39 16L42 16L42 17L43 17L43 18L44 18L44 17L46 17L46 19L45 19L45 20L47 20L47 21L48 21L48 22L49 22L49 20L50 20L50 21L51 21L51 20L50 20L50 19L51 19L51 18L50 18L50 17L49 17L49 20L47 20L47 17L46 17L46 16L45 16L45 15L44 15L44 14L42 14L42 15L41 15L41 13L40 13L40 10L39 10L39 13L38 13L38 12L37 12L37 9ZM0 10L0 11L1 11L1 13L2 13L2 10ZM23 12L23 13L24 13L24 12ZM26 12L26 14L25 14L25 16L24 16L24 17L25 17L25 16L26 16L26 15L27 15L27 12ZM15 13L15 14L14 14L14 15L15 15L15 16L16 16L16 14L17 14L17 13ZM36 13L36 14L38 14L38 13ZM39 13L39 15L40 15L40 13ZM0 14L0 15L1 15L1 14ZM8 14L8 15L9 15L9 16L8 16L8 17L10 17L10 14ZM19 14L19 15L20 15L20 14ZM28 15L28 16L29 16L29 15ZM42 15L42 16L43 16L43 15ZM52 15L52 16L53 16L53 15ZM35 16L35 17L33 17L33 18L31 18L31 19L35 19L35 20L37 20L37 19L36 19L36 18L35 18L35 17L36 17L36 16ZM56 16L56 18L57 18L57 16ZM6 18L6 19L7 19L7 20L6 20L6 21L7 21L7 20L8 20L8 19L7 19L7 18ZM9 19L9 20L11 20L11 19ZM18 19L18 20L17 20L17 21L16 21L16 23L18 23L18 22L19 22L19 23L20 23L20 24L19 24L19 25L20 25L20 24L22 24L22 25L23 25L23 26L24 26L24 27L25 27L25 29L24 29L24 32L25 32L25 34L26 34L26 35L27 35L27 34L30 34L30 35L29 35L29 36L30 36L30 35L31 35L31 38L33 38L33 36L32 36L32 34L31 34L31 33L33 33L33 34L36 34L36 35L37 35L37 34L38 34L38 36L37 36L37 37L39 37L39 38L38 38L38 39L40 39L40 41L42 41L42 38L44 38L44 39L45 39L45 38L44 38L44 37L45 37L45 36L46 36L46 34L47 34L47 33L46 33L46 34L45 34L45 36L41 36L41 35L42 35L42 34L39 34L39 33L40 33L40 32L38 32L38 31L37 31L37 32L35 32L35 33L33 33L33 32L34 32L34 30L33 30L33 31L32 31L32 30L31 30L31 33L30 33L30 31L26 31L26 32L25 32L25 29L26 29L26 25L25 25L25 23L26 23L26 22L27 22L27 21L25 21L25 23L22 23L22 19L21 19L21 21L20 21L20 19ZM24 19L24 20L25 20L25 19ZM39 19L39 20L40 20L40 19ZM41 19L41 20L42 20L42 19ZM33 20L33 21L34 21L34 20ZM17 21L17 22L18 22L18 21ZM19 21L19 22L20 22L20 21ZM23 21L23 22L24 22L24 21ZM38 21L38 22L40 22L40 21ZM55 21L55 22L56 22L56 21ZM6 23L6 24L7 24L7 25L5 25L5 24L4 24L4 25L3 25L3 24L2 24L2 26L9 26L9 25L10 25L10 24L7 24L7 23ZM49 23L49 25L50 25L50 23ZM44 25L44 26L45 26L45 25ZM39 26L39 27L40 27L40 26ZM1 27L1 28L2 28L2 27ZM5 27L5 30L8 30L8 27ZM15 27L15 28L16 28L16 27ZM27 27L27 30L30 30L30 27ZM49 27L49 30L52 30L52 27ZM6 28L6 29L7 29L7 28ZM19 28L19 30L20 30L20 28ZM28 28L28 29L29 29L29 28ZM31 28L31 29L32 29L32 28ZM38 28L38 29L37 29L37 30L39 30L39 29L41 29L41 28ZM50 28L50 29L51 29L51 28ZM3 29L3 30L4 30L4 29ZM35 29L35 31L36 31L36 29ZM10 30L10 31L12 31L12 30ZM22 31L22 32L23 32L23 31ZM11 32L11 33L12 33L12 34L13 34L13 33L14 33L14 32L13 32L13 33L12 33L12 32ZM26 32L26 33L27 33L27 32ZM37 32L37 33L38 33L38 32ZM23 33L23 34L24 34L24 33ZM3 34L3 35L4 35L4 34ZM9 34L9 36L10 36L10 37L7 37L7 36L6 36L6 37L5 37L5 38L4 38L4 39L5 39L5 38L6 38L6 39L7 39L7 38L8 38L8 39L9 39L9 40L11 40L11 39L10 39L10 37L11 37L11 38L12 38L12 42L13 42L13 41L14 41L14 39L15 39L15 38L17 38L17 39L16 39L16 40L15 40L15 42L14 42L14 43L11 43L11 44L14 44L14 46L15 46L15 47L13 47L13 48L14 48L14 49L15 49L15 47L16 47L16 45L15 45L15 42L16 42L16 43L17 43L17 45L18 45L18 46L17 46L17 47L18 47L18 48L16 48L16 49L17 49L17 50L19 50L19 48L20 48L20 47L21 47L21 46L20 46L20 47L18 47L18 46L19 46L19 44L20 44L20 45L21 45L21 44L20 44L20 43L18 43L18 42L20 42L20 41L18 41L18 42L17 42L17 41L16 41L16 40L17 40L17 39L18 39L18 40L19 40L19 39L18 39L18 38L19 38L19 36L18 36L18 38L17 38L17 37L16 37L16 36L17 36L17 35L18 35L18 34L17 34L17 35L16 35L16 34L14 34L14 36L15 36L15 37L14 37L14 39L13 39L13 38L12 38L12 36L11 36L11 35L10 35L10 34ZM19 34L19 35L20 35L20 39L21 39L21 40L22 40L22 39L21 39L21 37L22 37L22 38L24 38L24 36L23 36L23 37L22 37L22 36L21 36L21 34ZM34 36L34 39L33 39L33 40L34 40L34 39L35 39L35 38L36 38L36 37L35 37L35 36ZM39 36L39 37L40 37L40 39L41 39L41 37L40 37L40 36ZM6 37L6 38L7 38L7 37ZM54 37L54 38L52 38L52 39L54 39L54 38L55 38L55 37ZM26 38L26 39L28 39L28 38ZM24 39L24 40L23 40L23 42L24 42L24 41L25 41L25 44L26 44L26 41L25 41L25 39ZM8 41L8 42L9 42L9 43L10 43L10 41ZM21 41L21 42L22 42L22 41ZM30 44L30 45L31 45L31 44ZM6 45L6 46L7 46L7 47L9 47L9 48L10 48L10 47L11 47L11 46L10 46L10 47L9 47L9 46L7 46L7 45ZM43 45L43 47L42 47L42 48L43 48L43 47L44 47L44 45ZM49 45L49 48L50 48L50 46L51 46L51 45ZM51 47L51 48L52 48L52 47ZM39 48L39 49L38 49L38 51L39 51L39 50L40 50L40 48ZM27 49L27 52L30 52L30 49ZM49 49L49 52L52 52L52 49ZM12 50L12 51L13 51L13 50ZM21 50L21 51L22 51L22 50ZM28 50L28 51L29 51L29 50ZM50 50L50 51L51 51L51 50ZM9 51L9 53L8 53L8 57L9 57L9 55L11 55L11 56L13 56L13 57L14 57L14 56L15 56L15 55L14 55L14 56L13 56L13 55L12 55L12 53L11 53L11 52L10 52L10 51ZM25 51L25 52L26 52L26 51ZM55 51L55 53L56 53L56 51ZM14 52L14 53L15 53L15 52ZM31 52L31 53L32 53L32 52ZM33 52L33 54L34 54L34 52ZM10 53L10 54L11 54L11 53ZM21 53L21 55L22 55L22 53ZM50 53L50 54L51 54L51 53ZM47 54L47 55L48 55L48 54ZM27 55L27 57L31 57L31 56L30 56L30 55L29 55L29 56L28 56L28 55ZM53 55L53 56L52 56L52 57L55 57L55 56L54 56L54 55ZM56 55L56 56L57 56L57 55ZM0 0L0 7L7 7L7 0ZM1 1L1 6L6 6L6 1ZM2 2L2 5L5 5L5 2ZM50 0L50 7L57 7L57 0ZM51 1L51 6L56 6L56 1ZM52 2L52 5L55 5L55 2ZM0 50L0 57L7 57L7 50ZM1 51L1 56L6 56L6 51ZM2 52L2 55L5 55L5 52Z\\\" fill=\\\"#000000\\\"\\/><\\/g><\\/g><\\/svg>\\n\\n                            <span style=\\\"width:50%;\\\">\\n                                <img style=\\\"max-height: 70px\\\"\\n                                     src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/img\\/AfipComprobanteAutorizado.png\\\">\\n                            <\\/span>\\n                        <\\/th>\\n                        <th style=\\\"text-align:right;\\\">\\n                            <p>CAE N&#186;: 71304902471683<br>\\n                                Fecha Vto. CAE:  25\\/07\\/2021\\n                            <\\/p>\\n                        <\\/th>\\n                    <\\/tr>\\n                <\\/table>\\n                    <\\/div>\\n    <\\/div>\\n\\n    <\\/body>\\n<\\/html>\\\";s:4:\\\"file\\\";N;}s:6:\\\"locale\\\";N;s:4:\\\"from\\\";a:0:{}s:2:\\\"to\\\";a:1:{i:0;a:2:{s:4:\\\"name\\\";N;s:7:\\\"address\\\";s:23:\\\"noyecastro@yahoo.com.ar\\\";}}s:2:\\\"cc\\\";a:0:{}s:3:\\\"bcc\\\";a:1:{i:0;a:2:{s:4:\\\"name\\\";N;s:7:\\\"address\\\";s:23:\\\"info@masquecontable.com\\\";}}s:7:\\\"replyTo\\\";a:0:{}s:7:\\\"subject\\\";N;s:11:\\\"\\u0000*\\u0000markdown\\\";N;s:7:\\\"\\u0000*\\u0000html\\\";N;s:4:\\\"view\\\";N;s:8:\\\"textView\\\";N;s:8:\\\"viewData\\\";a:0:{}s:11:\\\"attachments\\\";a:0:{}s:14:\\\"rawAttachments\\\";a:0:{}s:15:\\\"diskAttachments\\\";a:0:{}s:9:\\\"callbacks\\\";a:0:{}s:5:\\\"theme\\\";N;s:6:\\\"mailer\\\";s:8:\\\"sendgrid\\\";s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:5:\\\"delay\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;}\"}}','ErrorException: Trying to get property \'id\' of non-object in /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php:16\nStack trace:\n#0 /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php(16): Illuminate\\Foundation\\Bootstrap\\HandleExceptions->handleError(8, \'Trying to get p...\', \'/home/forge/tax...\', 16, Array)\n#1 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(356): App\\Queue\\DatabaseJob->fire()\n#2 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(306): Illuminate\\Queue\\Worker->process(\'database\', Object(App\\Queue\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#3 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(132): Illuminate\\Queue\\Worker->runJob(Object(App\\Queue\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#4 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(112): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#5 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(96): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#6 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#7 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#8 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#9 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#10 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#11 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(134): Illuminate\\Container\\Container->call(Array)\n#12 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(256): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#13 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(121): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#14 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(971): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#15 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(290): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#16 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(166): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#17 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Application.php(93): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(129): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#19 /home/forge/taxes.com.ar/artisan(35): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#20 {main}','2021-07-23 18:04:00',NULL);
INSERT INTO `failed_jobs` VALUES (7,NULL,'database','default','{\"uuid\":\"f70e65c8-46d8-4ebe-b45b-604ccfa6f003\",\"displayName\":\"App\\\\Mail\\\\Fact_Electronica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"delay\":null,\"timeout\":null,\"timeoutAt\":null,\"data\":{\"commandName\":\"Illuminate\\\\Mail\\\\SendQueuedMailable\",\"command\":\"O:34:\\\"Illuminate\\\\Mail\\\\SendQueuedMailable\\\":3:{s:8:\\\"mailable\\\";O:25:\\\"App\\\\Mail\\\\Fact_Electronica\\\":27:{s:11:\\\"informacion\\\";a:6:{s:12:\\\"ruta_logo_fa\\\";N;s:4:\\\"mail\\\";s:23:\\\"info@masquecontable.com\\\";s:18:\\\"name_quien_factura\\\";s:19:\\\"MICAELA AILIN CORIA\\\";s:7:\\\"cliente\\\";O:17:\\\"App\\\\Models\\\\Person\\\":27:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:7:\\\"persons\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:40806;s:7:\\\"user_id\\\";i:5115;s:11:\\\"field_name1\\\";s:16:\\\"CATALINA ASENSIO\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-03885196-4\\\";s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-07-13 11:45:54\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-07-13 11:45:54\\\";s:11:\\\"activity_id\\\";i:1;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";i:1;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:40806;s:7:\\\"user_id\\\";i:5115;s:11:\\\"field_name1\\\";s:16:\\\"CATALINA ASENSIO\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-03885196-4\\\";s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-07-13 11:45:54\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-07-13 11:45:54\\\";s:11:\\\"activity_id\\\";i:1;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";i:1;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}s:14:\\\"nombre_del_pdf\\\";s:28:\\\"Factura N\\u00b00004-00000010.pdf\\\";s:9:\\\"body_mail\\\";s:155:\\\"Estimado cliente, se env\\u00eda adjunta la factura de honorarios correspondientes al mes de Julio 2021.\\nMuchas gracias por seguir eligiendo nuestros servicios.\\\";}s:3:\\\"pdf\\\";O:26:\\\"Barryvdh\\\\Snappy\\\\PdfWrapper\\\":4:{s:9:\\\"\\u0000*\\u0000snappy\\\";O:35:\\\"Barryvdh\\\\Snappy\\\\IlluminateSnappyPdf\\\":10:{s:26:\\\"\\u0000*\\u0000optionsWithContentCheck\\\";a:4:{s:11:\\\"header-html\\\";s:4:\\\"html\\\";s:11:\\\"footer-html\\\";s:4:\\\"html\\\";s:5:\\\"cover\\\";s:4:\\\"html\\\";s:15:\\\"xsl-style-sheet\\\";s:3:\\\"xsl\\\";}s:36:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000binary\\\";s:76:\\\"\\/home\\/forge\\/taxes.com.ar\\/vendor\\/h4cc\\/wkhtmltopdf-amd64\\/bin\\/wkhtmltopdf-amd64\\\";s:37:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000options\\\";a:132:{s:7:\\\"collate\\\";N;s:10:\\\"no-collate\\\";N;s:10:\\\"cookie-jar\\\";N;s:6:\\\"copies\\\";i:1;s:3:\\\"dpi\\\";N;s:13:\\\"extended-help\\\";N;s:9:\\\"grayscale\\\";N;s:4:\\\"help\\\";N;s:7:\\\"htmldoc\\\";N;s:18:\\\"ignore-load-errors\\\";N;s:9:\\\"image-dpi\\\";N;s:13:\\\"image-quality\\\";N;s:7:\\\"license\\\";N;s:9:\\\"log-level\\\";N;s:10:\\\"lowquality\\\";b:1;s:7:\\\"manpage\\\";N;s:13:\\\"margin-bottom\\\";N;s:11:\\\"margin-left\\\";N;s:12:\\\"margin-right\\\";N;s:10:\\\"margin-top\\\";N;s:11:\\\"orientation\\\";N;s:11:\\\"page-height\\\";N;s:9:\\\"page-size\\\";s:2:\\\"a4\\\";s:10:\\\"page-width\\\";N;s:18:\\\"no-pdf-compression\\\";N;s:5:\\\"quiet\\\";N;s:20:\\\"read-args-from-stdin\\\";N;s:6:\\\"readme\\\";N;s:5:\\\"title\\\";N;s:11:\\\"use-xserver\\\";N;s:7:\\\"version\\\";N;s:20:\\\"dump-default-toc-xsl\\\";N;s:12:\\\"dump-outline\\\";N;s:7:\\\"outline\\\";N;s:10:\\\"no-outline\\\";N;s:13:\\\"outline-depth\\\";N;s:13:\\\"output-format\\\";N;s:5:\\\"allow\\\";N;s:10:\\\"background\\\";N;s:13:\\\"no-background\\\";N;s:16:\\\"bypass-proxy-for\\\";N;s:9:\\\"cache-dir\\\";N;s:20:\\\"checkbox-checked-svg\\\";N;s:12:\\\"checkbox-svg\\\";N;s:6:\\\"cookie\\\";N;s:13:\\\"custom-header\\\";N;s:25:\\\"custom-header-propagation\\\";N;s:28:\\\"no-custom-header-propagation\\\";N;s:16:\\\"debug-javascript\\\";N;s:19:\\\"no-debug-javascript\\\";N;s:14:\\\"default-header\\\";N;s:8:\\\"encoding\\\";N;s:22:\\\"disable-external-links\\\";N;s:21:\\\"enable-external-links\\\";N;s:13:\\\"disable-forms\\\";N;s:12:\\\"enable-forms\\\";N;s:6:\\\"images\\\";N;s:9:\\\"no-images\\\";N;s:22:\\\"disable-internal-links\\\";N;s:21:\\\"enable-internal-links\\\";N;s:18:\\\"disable-javascript\\\";N;s:17:\\\"enable-javascript\\\";N;s:16:\\\"javascript-delay\\\";N;s:19:\\\"keep-relative-links\\\";N;s:19:\\\"load-error-handling\\\";N;s:25:\\\"load-media-error-handling\\\";N;s:25:\\\"disable-local-file-access\\\";N;s:24:\\\"enable-local-file-access\\\";N;s:17:\\\"minimum-font-size\\\";N;s:20:\\\"exclude-from-outline\\\";N;s:18:\\\"include-in-outline\\\";N;s:11:\\\"page-offset\\\";N;s:8:\\\"password\\\";N;s:15:\\\"disable-plugins\\\";N;s:14:\\\"enable-plugins\\\";N;s:4:\\\"post\\\";N;s:9:\\\"post-file\\\";N;s:16:\\\"print-media-type\\\";N;s:19:\\\"no-print-media-type\\\";N;s:5:\\\"proxy\\\";N;s:21:\\\"proxy-hostname-lookup\\\";N;s:23:\\\"radiobutton-checked-svg\\\";N;s:15:\\\"radiobutton-svg\\\";N;s:14:\\\"redirect-delay\\\";N;s:22:\\\"resolve-relative-links\\\";N;s:10:\\\"run-script\\\";N;s:23:\\\"disable-smart-shrinking\\\";N;s:22:\\\"enable-smart-shrinking\\\";N;s:12:\\\"ssl-crt-path\\\";N;s:16:\\\"ssl-key-password\\\";N;s:12:\\\"ssl-key-path\\\";N;s:17:\\\"stop-slow-scripts\\\";N;s:20:\\\"no-stop-slow-scripts\\\";N;s:22:\\\"disable-toc-back-links\\\";N;s:21:\\\"enable-toc-back-links\\\";N;s:16:\\\"user-style-sheet\\\";N;s:8:\\\"username\\\";N;s:13:\\\"viewport-size\\\";N;s:13:\\\"window-status\\\";N;s:4:\\\"zoom\\\";N;s:13:\\\"footer-center\\\";s:25:\\\"Pagina [page] de [toPage]\\\";s:16:\\\"footer-font-name\\\";N;s:16:\\\"footer-font-size\\\";i:8;s:11:\\\"footer-html\\\";N;s:11:\\\"footer-left\\\";s:0:\\\"\\\";s:11:\\\"footer-line\\\";N;s:14:\\\"no-footer-line\\\";N;s:12:\\\"footer-right\\\";N;s:14:\\\"footer-spacing\\\";N;s:13:\\\"header-center\\\";N;s:16:\\\"header-font-name\\\";N;s:16:\\\"header-font-size\\\";N;s:11:\\\"header-html\\\";N;s:11:\\\"header-left\\\";N;s:11:\\\"header-line\\\";N;s:14:\\\"no-header-line\\\";N;s:12:\\\"header-right\\\";N;s:14:\\\"header-spacing\\\";N;s:7:\\\"replace\\\";N;s:5:\\\"cover\\\";N;s:3:\\\"toc\\\";N;s:20:\\\"disable-dotted-lines\\\";N;s:9:\\\"toc-depth\\\";N;s:13:\\\"toc-font-name\\\";N;s:16:\\\"toc-l1-font-size\\\";N;s:15:\\\"toc-header-text\\\";N;s:20:\\\"toc-header-font-name\\\";N;s:20:\\\"toc-header-font-size\\\";N;s:21:\\\"toc-level-indentation\\\";N;s:17:\\\"disable-toc-links\\\";N;s:20:\\\"toc-text-size-shrink\\\";N;s:15:\\\"xsl-style-sheet\\\";N;}s:33:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000env\\\";N;s:37:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000timeout\\\";b:0;s:46:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000defaultExtension\\\";s:3:\\\"pdf\\\";s:18:\\\"\\u0000*\\u0000temporaryFolder\\\";N;s:14:\\\"temporaryFiles\\\";a:0:{}s:36:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000logger\\\";O:18:\\\"Psr\\\\Log\\\\NullLogger\\\":0:{}s:2:\\\"fs\\\";O:32:\\\"Illuminate\\\\Filesystem\\\\Filesystem\\\":0:{}}s:10:\\\"\\u0000*\\u0000options\\\";a:0:{}s:4:\\\"html\\\";s:22147:\\\"<!DOCTYPE html>\\n<html lang=\\\"en\\\">\\n    <head>\\n        <meta charset=\\\"utf-8\\\">\\n    <\\/head>\\n    <style>\\n        .subtotales_conceptos{\\n            width:30%;\\n            text-align: right;\\n        }\\n        .subtotales_importes{\\n            text-align: right;\\n        }\\n        .table-totales, .table-totales tr, .table-totales th{\\n            border: 1px solid;\\n        }\\n\\n    <\\/style>\\n    <body>\\n    <div style=\\\"max-height:840px\\\">\\n        <div style=\\\"width: 100%; height:270px\\\"> <!-- Datos de la empresa -->\\n            <table class=\\\"display\\\" cellspacing=\\\"0\\\" width=\\\"100%\\\" style=\\\"border:  1px solid;\\\">\\n                <tr style=\\\"\\\">\\n                    <th colspan=\\\"2\\\" rowspan=\\\"2\\\" style=\\\"width:45%;margin:0;height:150px;\\\">\\n                                                <img src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/img\\/\\/27377183504\\/logo_punto_venta_0000.png\\\"\\/>\\n                                            <\\/th>\\n                    <th style=\\\"border:  1px solid;text-align: center; width:10%\\\" colspan=\\\"2\\\">\\n                        <span style=\\\"font-size: 60px;\\\">C<\\/span> <br \\/> <span style=\\\"font-size: 14px;\\\">cod. 11<\\/span>\\n                    <\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"font-size: 28px;text-align: center;width:45%\\\">\\n                        Factura\\n                        <br>\\n                        0004 - 00000010\\n                    <\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th><\\/th>\\n                    <th style=\\\"border:  1px 1px 1px 0px solid;\\\" colspan=\\\"2\\\"><\\/th>\\n                    <th><\\/th>\\n                <\\/tr>\\n                <tr>\\n\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                                                    Raz&oacute;n Social:\\n                            <span style=\\\"font-weight: normal;\\\">MICAELA AILIN CORIA<\\/span>\\n                                            <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">Fecha de Emisi&oacute;n: <span style=\\\"font-weight: normal;\\\">15\\/07\\/2021<\\/span><\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Domicilio Comercial: <span style=\\\"font-weight: normal;\\\">Victor Guillet esq. Arturo M Bas, C.P.:5800,\\n                        C\\u00f3rdoba<\\/span>\\n                    <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">CUIT: <span style=\\\"font-weight: normal;\\\">27-37718350-4<\\/span><\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Condici&oacute;n frente al IVA: <span style=\\\"font-weight: normal;\\\">Monotributo<\\/span>\\n                    <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Ingresos Brutos: <span style=\\\"font-weight: normal;\\\"><\\/span>\\n                        <br>\\n                        Fecha de Inicio de Actividades: <span style=\\\"font-weight: normal;\\\">09\\/07\\/2021<\\/span>\\n                    <\\/th>\\n                <\\/tr>\\n            <\\/table>\\n        <\\/div>\\n\\n        <table style=\\\"text-align: center; width: 100%;border: solid 1px;\\\"> <!-- Fechas -->\\n            <thead>\\n                <tr>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Per\\u00edodo Facturado Desde: 01\\/07\\/2021<\\/small><\\/th>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Per\\u00edodo Facturado Hasta: 31\\/07\\/2021<\\/small><\\/th>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Fecha Vto. Pago: 15\\/07\\/2021<\\/small><\\/th>\\n                <\\/tr>\\n            <\\/thead>\\n        <\\/table>\\n        \\n        <table style=\\\"width: 100%; margin-top: 1%;border: solid 1px;\\\"> <!-- Datos Clientes -->\\n            <tr>\\n                <th style=\\\"text-align:left;\\\"colspan=\\\"12\\\">\\n                    CUIT: <span style=\\\"font-weight: normal;\\\">27-03885196-4<\\/span>\\n                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\\n                    Apellido y Nombre \\/ Raz&oacute;n Social: <span style=\\\"font-weight: normal;\\\">\\n                    CATALINA ASENSIO<\\/span>\\n                <\\/th>\\n            <\\/tr>\\n            <tr>\\n                <th style=\\\"text-align:left; width:50%\\\">\\n                    Condici&oacute;n Frente al IVA: <span style=\\\"font-weight: normal;\\\">Consumidor Final<\\/span>\\n                <\\/th>\\n                <th style=\\\"text-align:left; width:50%\\\" colspan=\\\"4\\\">\\n                    Domicilio Comercial:\\n                    <span style=\\\"font-weight: normal;\\\">\\n                    --------\\n                    <\\/span>\\n                <\\/th>\\n            <\\/tr>\\n            <tr style=\\\"text-align:left\\\">\\n                <th>Condici&oacute;n de Venta: <span style=\\\"font-weight: normal;\\\">Cuenta Corriente<\\/span><\\/th>\\n            <\\/tr>\\n        <\\/table>\\n\\n        <div style=\\\"border: 1px solid;margin-top: 1%;min-height:600px;\\\">\\n        <table style=\\\"text-align: center; width: 100%; margin-top: 1%;\\\"> <!-- Body -->\\n            <tr style=\\\"border-bottom: 1px solid;font-size: 15px\\\">\\n                <th>C&oacute;digo<\\/th>\\n                <th style=\\\"width: 25%;\\\">Detalle<\\/th>\\n                <th>Cantidad<\\/th>\\n                <th>U.Medida<\\/th>\\n                <th>Precio U.<\\/th>\\n                <th>Bonif. (%)<\\/th>\\n                <th>Precio Bonif.<\\/th>\\n                <th>Subtotal<\\/th>\\n                            <\\/tr>\\n            <tbody>\\n                                                                                <tr style=\\\"font-size: 12px;\\\">\\n                        <td>\\n                            \\n                        <\\/td>\\n                        <td>\\n                            Honorarios profesionales Julio 2021\\n                        <\\/td>\\n                        <td>\\n                            1.00\\n                        <\\/td>\\n                        <td>\\n                            Unidades\\n                        <\\/td>\\n                        <td>                            2.100,00\\n                                                    <\\/td>\\n                        <td>\\n                            0,00%\\n                        <\\/td>\\n                        <td>\\n                            0,00\\n                        <\\/td>\\n                        <td>\\n                            2.100,00\\n                        <\\/td>\\n                                            <\\/tr>\\n                    \\n            <\\/tbody>\\n        <\\/table>\\n        <\\/div>\\n\\n        \\n\\n        <div style=\\\"height:200px;margin-top: 1%;\\\"> <!-- Totales -->\\n              <!-- Es factura B o C -->\\n                <table class=\\\"table-totales\\\" cellspacing=\\\"0\\\" width=\\\"100%\\\">\\n                    <tr>\\n                        <th style=\\\"width:50%; text-align:left;\\\">\\n\\n<!--                                <span style=\\\"width:100%;\\\"><img src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/barcodes\\/71304902473481.png\\\"><\\/span>\\n                                <span style=\\\"text-align:center;\\\">2737718350411000471304902473481202107259<\\/span>-->\\n                        <\\/th>\\n                        <th class=\\\"subtotales_conceptos\\\">TOTAL:<\\/th>\\n                        <th class=\\\"subtotales_importes\\\">$ 2.100,00<\\/th>\\n                    <\\/tr>\\n                <\\/table>\\n                <br>\\n                <table cellspacing=\\\"0\\\" width=\\\"100%\\\" style=\\\"border: none\\\">\\n                    <tr>\\n                        <th style=\\\"width:50%; text-align:left;\\\">\\n\\n                            <?xml version=\\\"1.0\\\" encoding=\\\"UTF-8\\\"?>\\n<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" version=\\\"1.1\\\" width=\\\"100\\\" height=\\\"100\\\" viewBox=\\\"0 0 100 100\\\"><rect x=\\\"0\\\" y=\\\"0\\\" width=\\\"100\\\" height=\\\"100\\\" fill=\\\"#ffffff\\\"\\/><g transform=\\\"scale(1.754)\\\"><g transform=\\\"translate(0,0)\\\"><path fill-rule=\\\"evenodd\\\" d=\\\"M8 0L8 1L10 1L10 0ZM14 0L14 2L12 2L12 1L11 1L11 2L12 2L12 3L11 3L11 5L12 5L12 4L14 4L14 3L15 3L15 5L17 5L17 4L16 4L16 3L17 3L17 2L18 2L18 1L17 1L17 2L15 2L15 1L16 1L16 0ZM22 0L22 1L23 1L23 2L22 2L22 3L21 3L21 4L20 4L20 5L21 5L21 4L22 4L22 10L21 10L21 11L20 11L20 12L19 12L19 10L20 10L20 9L21 9L21 8L20 8L20 7L21 7L21 6L20 6L20 7L19 7L19 6L18 6L18 7L17 7L17 6L16 6L16 7L15 7L15 6L14 6L14 5L13 5L13 6L12 6L12 8L13 8L13 9L9 9L9 8L10 8L10 7L11 7L11 6L10 6L10 7L9 7L9 6L8 6L8 7L9 7L9 8L8 8L8 9L7 9L7 8L6 8L6 9L4 9L4 8L0 8L0 9L1 9L1 10L0 10L0 12L1 12L1 13L2 13L2 15L3 15L3 16L2 16L2 17L4 17L4 18L3 18L3 19L2 19L2 18L1 18L1 20L0 20L0 23L1 23L1 24L0 24L0 25L1 25L1 24L2 24L2 23L3 23L3 25L2 25L2 27L3 27L3 28L1 28L1 26L0 26L0 29L2 29L2 30L3 30L3 31L0 31L0 32L2 32L2 33L0 33L0 35L1 35L1 36L2 36L2 37L0 37L0 38L2 38L2 39L0 39L0 44L2 44L2 43L1 43L1 42L5 42L5 43L7 43L7 44L6 44L6 45L5 45L5 44L4 44L4 43L3 43L3 46L2 46L2 45L0 45L0 48L5 48L5 47L8 47L8 48L6 48L6 49L8 49L8 50L11 50L11 51L9 51L9 53L8 53L8 57L9 57L9 55L11 55L11 56L12 56L12 55L11 55L11 54L12 54L12 53L14 53L14 54L15 54L15 53L16 53L16 54L17 54L17 55L18 55L18 56L17 56L17 57L18 57L18 56L19 56L19 57L21 57L21 56L19 56L19 55L18 55L18 54L20 54L20 51L21 51L21 52L23 52L23 50L24 50L24 53L25 53L25 54L23 54L23 56L22 56L22 57L24 57L24 56L26 56L26 55L25 55L25 54L27 54L27 53L31 53L31 54L33 54L33 55L32 55L32 56L34 56L34 57L36 57L36 55L38 55L38 56L37 56L37 57L44 57L44 56L43 56L43 55L42 55L42 56L41 56L41 55L40 55L40 54L42 54L42 53L40 53L40 52L43 52L43 53L45 53L45 52L46 52L46 51L45 51L45 49L47 49L47 48L48 48L48 50L47 50L47 53L46 53L46 54L44 54L44 55L45 55L45 56L46 56L46 57L47 57L47 54L48 54L48 55L49 55L49 54L50 54L50 57L51 57L51 54L52 54L52 53L55 53L55 54L54 54L54 55L53 55L53 56L52 56L52 57L55 57L55 56L54 56L54 55L55 55L55 54L56 54L56 53L57 53L57 51L56 51L56 49L57 49L57 48L56 48L56 49L55 49L55 51L53 51L53 49L54 49L54 48L53 48L53 46L54 46L54 45L56 45L56 46L55 46L55 47L57 47L57 44L53 44L53 46L52 46L52 43L51 43L51 44L50 44L50 42L51 42L51 41L50 41L50 40L52 40L52 42L54 42L54 43L55 43L55 42L57 42L57 40L56 40L56 38L57 38L57 31L56 31L56 30L57 30L57 27L56 27L56 24L57 24L57 21L56 21L56 20L53 20L53 19L54 19L54 18L55 18L55 14L54 14L54 10L53 10L53 9L55 9L55 10L56 10L56 11L55 11L55 12L57 12L57 8L56 8L56 9L55 9L55 8L52 8L52 10L51 10L51 11L50 11L50 10L49 10L49 9L50 9L50 8L48 8L48 7L49 7L49 6L48 6L48 7L47 7L47 5L48 5L48 0L45 0L45 1L43 1L43 0L39 0L39 1L41 1L41 4L40 4L40 5L39 5L39 2L38 2L38 1L37 1L37 2L36 2L36 1L32 1L32 2L31 2L31 0L30 0L30 1L29 1L29 0L28 0L28 1L26 1L26 0L24 0L24 1L23 1L23 0ZM19 1L19 2L21 2L21 1ZM25 1L25 2L23 2L23 3L22 3L22 4L23 4L23 3L24 3L24 5L23 5L23 10L22 10L22 13L23 13L23 14L24 14L24 16L23 16L23 15L22 15L22 14L20 14L20 13L19 13L19 12L18 12L18 10L19 10L19 9L20 9L20 8L18 8L18 9L17 9L17 8L15 8L15 7L14 7L14 6L13 6L13 7L14 7L14 9L13 9L13 10L12 10L12 13L11 13L11 16L12 16L12 18L10 18L10 20L9 20L9 21L10 21L10 20L11 20L11 22L10 22L10 23L11 23L11 22L13 22L13 23L14 23L14 24L16 24L16 23L18 23L18 22L19 22L19 23L20 23L20 24L19 24L19 25L18 25L18 26L17 26L17 25L16 25L16 26L15 26L15 25L14 25L14 26L13 26L13 25L12 25L12 24L11 24L11 25L12 25L12 27L14 27L14 28L10 28L10 29L13 29L13 32L14 32L14 33L13 33L13 35L12 35L12 34L10 34L10 35L12 35L12 36L11 36L11 37L13 37L13 36L14 36L14 34L16 34L16 35L17 35L17 36L16 36L16 37L17 37L17 38L15 38L15 37L14 37L14 38L13 38L13 39L12 39L12 38L10 38L10 36L9 36L9 34L7 34L7 33L6 33L6 32L7 32L7 31L5 31L5 32L4 32L4 31L3 31L3 33L4 33L4 34L3 34L3 35L2 35L2 34L1 34L1 35L2 35L2 36L3 36L3 35L4 35L4 36L7 36L7 37L6 37L6 38L5 38L5 37L2 37L2 38L3 38L3 39L2 39L2 40L1 40L1 41L3 41L3 40L4 40L4 39L6 39L6 40L9 40L9 41L10 41L10 42L11 42L11 43L10 43L10 44L9 44L9 42L7 42L7 41L6 41L6 42L7 42L7 43L8 43L8 45L9 45L9 47L12 47L12 50L13 50L13 49L14 49L14 48L13 48L13 46L14 46L14 47L15 47L15 49L16 49L16 53L17 53L17 51L20 51L20 48L22 48L22 49L23 49L23 48L22 48L22 47L24 47L24 46L22 46L22 44L23 44L23 45L25 45L25 46L27 46L27 44L28 44L28 47L26 47L26 48L24 48L24 50L25 50L25 49L26 49L26 48L28 48L28 47L29 47L29 48L30 48L30 47L32 47L32 50L31 50L31 51L32 51L32 50L33 50L33 51L35 51L35 52L36 52L36 53L35 53L35 55L34 55L34 56L35 56L35 55L36 55L36 53L37 53L37 54L38 54L38 55L39 55L39 56L40 56L40 55L39 55L39 53L37 53L37 51L38 51L38 52L40 52L40 50L41 50L41 51L42 51L42 50L43 50L43 51L44 51L44 49L45 49L45 48L46 48L46 46L47 46L47 45L48 45L48 44L49 44L49 42L50 42L50 41L47 41L47 43L46 43L46 44L45 44L45 42L46 42L46 40L47 40L47 37L48 37L48 38L49 38L49 36L50 36L50 37L51 37L51 38L50 38L50 39L51 39L51 38L52 38L52 40L53 40L53 41L54 41L54 42L55 42L55 41L56 41L56 40L55 40L55 41L54 41L54 39L55 39L55 38L56 38L56 36L55 36L55 35L56 35L56 32L55 32L55 30L56 30L56 27L55 27L55 23L54 23L54 22L51 22L51 21L52 21L52 20L51 20L51 19L50 19L50 20L49 20L49 17L50 17L50 18L52 18L52 17L54 17L54 14L52 14L52 13L53 13L53 10L52 10L52 11L51 11L51 12L52 12L52 13L51 13L51 17L50 17L50 15L49 15L49 17L47 17L47 16L46 16L46 15L47 15L47 13L48 13L48 14L50 14L50 12L49 12L49 10L48 10L48 8L47 8L47 9L46 9L46 10L48 10L48 11L46 11L46 12L47 12L47 13L46 13L46 14L45 14L45 12L44 12L44 13L43 13L43 12L42 12L42 13L41 13L41 9L44 9L44 10L43 10L43 11L45 11L45 7L46 7L46 5L47 5L47 3L46 3L46 2L47 2L47 1L45 1L45 3L44 3L44 5L43 5L43 4L41 4L41 7L42 7L42 8L41 8L41 9L39 9L39 8L38 8L38 9L37 9L37 8L35 8L35 7L36 7L36 6L37 6L37 7L38 7L38 6L37 6L37 5L38 5L38 3L37 3L37 5L35 5L35 4L34 4L34 5L33 5L33 7L32 7L32 4L33 4L33 3L34 3L34 2L33 2L33 3L31 3L31 8L32 8L32 9L31 9L31 10L33 10L33 11L34 11L34 10L35 10L35 13L34 13L34 14L32 14L32 15L33 15L33 17L30 17L30 18L28 18L28 19L27 19L27 17L29 17L29 16L30 16L30 15L29 15L29 13L30 13L30 14L31 14L31 13L33 13L33 12L31 12L31 11L26 11L26 12L25 12L25 11L24 11L24 8L25 8L25 10L27 10L27 9L26 9L26 8L25 8L25 7L26 7L26 6L25 6L25 5L26 5L26 4L25 4L25 2L26 2L26 3L28 3L28 4L30 4L30 3L29 3L29 2L26 2L26 1ZM8 2L8 5L10 5L10 4L9 4L9 2ZM18 3L18 5L19 5L19 3ZM45 3L45 5L46 5L46 3ZM27 5L27 8L30 8L30 5ZM42 5L42 7L43 7L43 8L44 8L44 7L45 7L45 6L44 6L44 7L43 7L43 5ZM24 6L24 7L25 7L25 6ZM28 6L28 7L29 7L29 6ZM34 6L34 7L35 7L35 6ZM39 6L39 7L40 7L40 6ZM2 9L2 10L1 10L1 12L2 12L2 13L3 13L3 14L4 14L4 13L5 13L5 15L4 15L4 16L5 16L5 18L4 18L4 19L5 19L5 18L7 18L7 19L6 19L6 20L5 20L5 21L6 21L6 22L7 22L7 23L6 23L6 24L7 24L7 23L8 23L8 24L9 24L9 25L10 25L10 24L9 24L9 22L7 22L7 21L8 21L8 20L7 20L7 19L9 19L9 17L8 17L8 16L9 16L9 14L8 14L8 13L9 13L9 12L10 12L10 11L11 11L11 10L10 10L10 11L8 11L8 13L6 13L6 12L7 12L7 11L6 11L6 12L5 12L5 11L4 11L4 9ZM6 9L6 10L7 10L7 9ZM14 9L14 11L15 11L15 13L12 13L12 14L13 14L13 15L12 15L12 16L13 16L13 15L14 15L14 18L13 18L13 19L15 19L15 18L17 18L17 17L18 17L18 19L16 19L16 20L14 20L14 21L15 21L15 23L16 23L16 21L17 21L17 22L18 22L18 21L17 21L17 20L18 20L18 19L20 19L20 21L19 21L19 22L20 22L20 21L21 21L21 19L22 19L22 23L25 23L25 25L26 25L26 29L25 29L25 27L24 27L24 26L23 26L23 25L22 25L22 24L20 24L20 25L19 25L19 27L17 27L17 28L16 28L16 27L15 27L15 26L14 26L14 27L15 27L15 28L16 28L16 30L15 30L15 31L17 31L17 32L18 32L18 28L19 28L19 30L20 30L20 28L19 28L19 27L21 27L21 26L22 26L22 28L23 28L23 30L22 30L22 29L21 29L21 30L22 30L22 31L20 31L20 33L21 33L21 32L22 32L22 35L26 35L26 36L25 36L25 37L27 37L27 35L28 35L28 37L29 37L29 39L30 39L30 38L31 38L31 40L27 40L27 42L29 42L29 41L30 41L30 44L29 44L29 43L28 43L28 44L29 44L29 45L30 45L30 46L31 46L31 45L32 45L32 47L33 47L33 46L34 46L34 48L33 48L33 50L34 50L34 48L35 48L35 47L36 47L36 49L35 49L35 51L36 51L36 49L37 49L37 48L38 48L38 45L37 45L37 47L36 47L36 45L35 45L35 46L34 46L34 45L32 45L32 43L31 43L31 41L33 41L33 43L35 43L35 44L37 44L37 42L38 42L38 44L39 44L39 47L40 47L40 45L41 45L41 48L42 48L42 49L43 49L43 48L45 48L45 45L44 45L44 44L43 44L43 43L42 43L42 45L41 45L41 43L40 43L40 44L39 44L39 42L38 42L38 41L37 41L37 42L36 42L36 40L35 40L35 39L38 39L38 40L39 40L39 41L40 41L40 42L42 42L42 41L43 41L43 42L45 42L45 40L46 40L46 38L45 38L45 37L46 37L46 36L48 36L48 35L49 35L49 34L48 34L48 33L50 33L50 36L51 36L51 35L52 35L52 37L54 37L54 38L53 38L53 39L54 39L54 38L55 38L55 37L54 37L54 35L55 35L55 32L54 32L54 29L55 29L55 27L53 27L53 25L52 25L52 23L51 23L51 25L50 25L50 23L49 23L49 25L50 25L50 26L48 26L48 24L47 24L47 23L48 23L48 22L49 22L49 20L47 20L47 17L46 17L46 16L45 16L45 15L44 15L44 14L42 14L42 15L41 15L41 13L40 13L40 10L39 10L39 13L38 13L38 12L37 12L37 9L36 9L36 13L35 13L35 15L39 15L39 16L38 16L38 17L37 17L37 19L36 19L36 18L35 18L35 17L36 17L36 16L35 16L35 17L33 17L33 18L31 18L31 19L35 19L35 20L37 20L37 22L36 22L36 21L35 21L35 22L32 22L32 20L30 20L30 19L28 19L28 20L27 20L27 19L25 19L25 18L24 18L24 19L22 19L22 18L21 18L21 19L20 19L20 16L19 16L19 17L18 17L18 16L17 16L17 14L18 14L18 12L17 12L17 11L16 11L16 10L15 10L15 9ZM28 9L28 10L30 10L30 9ZM3 11L3 13L4 13L4 11ZM23 12L23 13L24 13L24 12ZM26 12L26 14L25 14L25 16L24 16L24 17L25 17L25 16L26 16L26 15L27 15L27 12ZM15 13L15 14L14 14L14 15L15 15L15 16L16 16L16 14L17 14L17 13ZM36 13L36 14L38 14L38 13ZM39 13L39 15L40 15L40 13ZM0 14L0 15L1 15L1 14ZM6 14L6 15L5 15L5 16L6 16L6 17L7 17L7 16L8 16L8 14ZM19 14L19 15L20 15L20 14ZM6 15L6 16L7 16L7 15ZM28 15L28 16L29 16L29 15ZM42 15L42 16L39 16L39 17L38 17L38 18L41 18L41 17L42 17L42 18L43 18L43 22L44 22L44 23L45 23L45 22L44 22L44 21L46 21L46 22L48 22L48 21L47 21L47 20L45 20L45 19L46 19L46 17L44 17L44 18L43 18L43 17L42 17L42 16L43 16L43 15ZM52 15L52 16L53 16L53 15ZM56 16L56 18L57 18L57 16ZM11 19L11 20L12 20L12 21L13 21L13 20L12 20L12 19ZM24 19L24 20L25 20L25 19ZM37 19L37 20L38 20L38 19ZM39 19L39 20L40 20L40 19ZM41 19L41 20L42 20L42 19ZM2 20L2 22L1 22L1 23L2 23L2 22L3 22L3 23L4 23L4 22L3 22L3 21L4 21L4 20ZM6 20L6 21L7 21L7 20ZM29 20L29 21L28 21L28 22L27 22L27 21L25 21L25 23L26 23L26 24L28 24L28 26L31 26L31 27L33 27L33 28L34 28L34 29L35 29L35 31L36 31L36 29L37 29L37 30L39 30L39 29L41 29L41 30L40 30L40 31L41 31L41 33L42 33L42 32L43 32L43 35L44 35L44 33L46 33L46 34L45 34L45 36L41 36L41 35L42 35L42 34L39 34L39 33L40 33L40 32L38 32L38 31L37 31L37 32L35 32L35 33L33 33L33 32L34 32L34 30L33 30L33 31L32 31L32 30L31 30L31 33L30 33L30 31L26 31L26 32L25 32L25 29L24 29L24 32L25 32L25 34L26 34L26 35L27 35L27 34L30 34L30 35L29 35L29 36L30 36L30 35L31 35L31 38L33 38L33 36L32 36L32 34L31 34L31 33L33 33L33 34L36 34L36 35L37 35L37 34L38 34L38 36L37 36L37 37L39 37L39 38L38 38L38 39L40 39L40 41L42 41L42 38L44 38L44 39L45 39L45 38L44 38L44 37L45 37L45 36L46 36L46 34L47 34L47 33L48 33L48 31L46 31L46 32L45 32L45 31L44 31L44 32L43 32L43 29L44 29L44 30L45 30L45 29L44 29L44 27L46 27L46 29L47 29L47 30L48 30L48 27L47 27L47 24L46 24L46 25L45 25L45 24L44 24L44 25L43 25L43 24L42 24L42 25L41 25L41 23L40 23L40 24L39 24L39 23L38 23L38 24L37 24L37 26L35 26L35 25L36 25L36 23L35 23L35 25L34 25L34 23L33 23L33 24L32 24L32 22L31 22L31 23L30 23L30 20ZM33 20L33 21L34 21L34 20ZM50 20L50 21L51 21L51 20ZM23 21L23 22L24 22L24 21ZM38 21L38 22L40 22L40 21ZM55 21L55 22L56 22L56 21ZM26 22L26 23L27 23L27 22ZM4 24L4 26L3 26L3 27L4 27L4 26L5 26L5 24ZM31 24L31 26L34 26L34 25L32 25L32 24ZM38 24L38 27L37 27L37 29L38 29L38 28L41 28L41 29L43 29L43 27L42 27L42 28L41 28L41 26L40 26L40 25L39 25L39 24ZM6 25L6 26L7 26L7 25ZM44 25L44 26L45 26L45 25ZM39 26L39 27L40 27L40 26ZM5 27L5 30L8 30L8 27ZM27 27L27 30L30 30L30 27ZM49 27L49 30L52 30L52 27ZM6 28L6 29L7 29L7 28ZM28 28L28 29L29 29L29 28ZM31 28L31 29L32 29L32 28ZM35 28L35 29L36 29L36 28ZM50 28L50 29L51 29L51 28ZM53 28L53 29L54 29L54 28ZM10 30L10 31L8 31L8 33L9 33L9 32L10 32L10 33L12 33L12 30ZM10 31L10 32L11 32L11 31ZM22 31L22 32L23 32L23 31ZM50 31L50 33L51 33L51 31ZM52 31L52 34L54 34L54 32L53 32L53 31ZM26 32L26 33L27 33L27 32ZM37 32L37 33L38 33L38 32ZM46 32L46 33L47 33L47 32ZM23 33L23 34L24 34L24 33ZM4 34L4 35L7 35L7 34ZM17 34L17 35L18 35L18 34ZM19 34L19 35L20 35L20 38L21 38L21 37L22 37L22 38L24 38L24 36L23 36L23 37L22 37L22 36L21 36L21 34ZM8 36L8 37L9 37L9 36ZM18 36L18 38L17 38L17 39L16 39L16 40L15 40L15 42L14 42L14 43L11 43L11 44L10 44L10 45L11 45L11 44L13 44L13 45L14 45L14 43L15 43L15 42L16 42L16 43L17 43L17 45L18 45L18 46L17 46L17 47L16 47L16 49L17 49L17 50L19 50L19 48L20 48L20 47L21 47L21 46L20 46L20 47L18 47L18 46L19 46L19 44L20 44L20 45L21 45L21 44L20 44L20 43L18 43L18 42L20 42L20 41L18 41L18 42L17 42L17 41L16 41L16 40L17 40L17 39L18 39L18 40L19 40L19 39L18 39L18 38L19 38L19 36ZM34 36L34 39L33 39L33 40L34 40L34 39L35 39L35 38L36 38L36 37L35 37L35 36ZM39 36L39 37L40 37L40 39L41 39L41 37L40 37L40 36ZM6 38L6 39L7 39L7 38ZM8 38L8 39L9 39L9 40L11 40L11 39L10 39L10 38ZM14 38L14 39L13 39L13 40L12 40L12 42L13 42L13 41L14 41L14 39L15 39L15 38ZM26 38L26 39L28 39L28 38ZM21 39L21 40L22 40L22 39ZM24 39L24 40L23 40L23 42L24 42L24 41L25 41L25 44L26 44L26 41L25 41L25 39ZM21 41L21 42L22 42L22 41ZM23 43L23 44L24 44L24 43ZM30 44L30 45L31 45L31 44ZM4 45L4 46L3 46L3 47L5 47L5 45ZM6 45L6 46L7 46L7 45ZM15 45L15 46L16 46L16 45ZM43 45L43 47L42 47L42 48L43 48L43 47L44 47L44 45ZM49 45L49 48L50 48L50 46L51 46L51 45ZM1 46L1 47L2 47L2 46ZM17 47L17 48L18 48L18 47ZM51 47L51 48L52 48L52 47ZM10 48L10 49L11 49L11 48ZM39 48L39 49L38 49L38 51L39 51L39 50L40 50L40 48ZM27 49L27 52L30 52L30 49ZM49 49L49 52L52 52L52 49ZM21 50L21 51L22 51L22 50ZM28 50L28 51L29 51L29 50ZM50 50L50 51L51 51L51 50ZM11 51L11 52L10 52L10 53L9 53L9 54L11 54L11 52L14 52L14 51ZM25 51L25 52L26 52L26 51ZM55 51L55 53L56 53L56 51ZM18 52L18 53L19 53L19 52ZM31 52L31 53L32 53L32 52ZM33 52L33 54L34 54L34 52ZM21 53L21 55L22 55L22 53ZM50 53L50 54L51 54L51 53ZM14 55L14 56L13 56L13 57L14 57L14 56L15 56L15 55ZM27 55L27 57L31 57L31 56L30 56L30 55L29 55L29 56L28 56L28 55ZM56 55L56 56L57 56L57 55ZM0 0L0 7L7 7L7 0ZM1 1L1 6L6 6L6 1ZM2 2L2 5L5 5L5 2ZM50 0L50 7L57 7L57 0ZM51 1L51 6L56 6L56 1ZM52 2L52 5L55 5L55 2ZM0 50L0 57L7 57L7 50ZM1 51L1 56L6 56L6 51ZM2 52L2 55L5 55L5 52Z\\\" fill=\\\"#000000\\\"\\/><\\/g><\\/g><\\/svg>\\n\\n                            <span style=\\\"width:50%;\\\">\\n                                <img style=\\\"max-height: 70px\\\"\\n                                     src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/img\\/AfipComprobanteAutorizado.png\\\">\\n                            <\\/span>\\n                        <\\/th>\\n                        <th style=\\\"text-align:right;\\\">\\n                            <p>CAE N&#186;: 71304902473481<br>\\n                                Fecha Vto. CAE:  25\\/07\\/2021\\n                            <\\/p>\\n                        <\\/th>\\n                    <\\/tr>\\n                <\\/table>\\n                    <\\/div>\\n    <\\/div>\\n\\n    <\\/body>\\n<\\/html>\\\";s:4:\\\"file\\\";N;}s:6:\\\"locale\\\";N;s:4:\\\"from\\\";a:0:{}s:2:\\\"to\\\";a:1:{i:0;a:2:{s:4:\\\"name\\\";N;s:7:\\\"address\\\";s:20:\\\"ahaseney@hotmail.com\\\";}}s:2:\\\"cc\\\";a:0:{}s:3:\\\"bcc\\\";a:1:{i:0;a:2:{s:4:\\\"name\\\";N;s:7:\\\"address\\\";s:23:\\\"info@masquecontable.com\\\";}}s:7:\\\"replyTo\\\";a:0:{}s:7:\\\"subject\\\";N;s:11:\\\"\\u0000*\\u0000markdown\\\";N;s:7:\\\"\\u0000*\\u0000html\\\";N;s:4:\\\"view\\\";N;s:8:\\\"textView\\\";N;s:8:\\\"viewData\\\";a:0:{}s:11:\\\"attachments\\\";a:0:{}s:14:\\\"rawAttachments\\\";a:0:{}s:15:\\\"diskAttachments\\\";a:0:{}s:9:\\\"callbacks\\\";a:0:{}s:5:\\\"theme\\\";N;s:6:\\\"mailer\\\";s:8:\\\"sendgrid\\\";s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:5:\\\"delay\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;}\"}}','ErrorException: Trying to get property \'id\' of non-object in /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php:16\nStack trace:\n#0 /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php(16): Illuminate\\Foundation\\Bootstrap\\HandleExceptions->handleError(8, \'Trying to get p...\', \'/home/forge/tax...\', 16, Array)\n#1 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(356): App\\Queue\\DatabaseJob->fire()\n#2 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(306): Illuminate\\Queue\\Worker->process(\'database\', Object(App\\Queue\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#3 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(132): Illuminate\\Queue\\Worker->runJob(Object(App\\Queue\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#4 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(112): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#5 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(96): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#6 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#7 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#8 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#9 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#10 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#11 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(134): Illuminate\\Container\\Container->call(Array)\n#12 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(256): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#13 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(121): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#14 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(971): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#15 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(290): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#16 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(166): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#17 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Application.php(93): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(129): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#19 /home/forge/taxes.com.ar/artisan(35): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#20 {main}','2021-07-23 18:04:00',NULL);
INSERT INTO `failed_jobs` VALUES (8,NULL,'database','default','{\"uuid\":\"401b648a-dbea-4e85-9fa3-84b7573c3808\",\"displayName\":\"App\\\\Mail\\\\Fact_Electronica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"delay\":null,\"timeout\":null,\"timeoutAt\":null,\"data\":{\"commandName\":\"Illuminate\\\\Mail\\\\SendQueuedMailable\",\"command\":\"O:34:\\\"Illuminate\\\\Mail\\\\SendQueuedMailable\\\":3:{s:8:\\\"mailable\\\";O:25:\\\"App\\\\Mail\\\\Fact_Electronica\\\":27:{s:11:\\\"informacion\\\";a:6:{s:12:\\\"ruta_logo_fa\\\";N;s:4:\\\"mail\\\";s:23:\\\"info@masquecontable.com\\\";s:18:\\\"name_quien_factura\\\";s:19:\\\"MICAELA AILIN CORIA\\\";s:7:\\\"cliente\\\";O:17:\\\"App\\\\Models\\\\Person\\\":27:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:7:\\\"persons\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:40737;s:7:\\\"user_id\\\";i:5117;s:11:\\\"field_name1\\\";s:21:\\\"DUCAU SALERNO MICAELA\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-42498957-1\\\";s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-07-05 18:49:50\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-07-17 21:22:28\\\";s:11:\\\"activity_id\\\";i:1;s:7:\\\"address\\\";s:99:\\\"Direccion\\r\\nJOSE INGENIEROS 2870\\r\\nCod. Postal\\r\\n1636\\r\\nProvincia\\r\\nBUENOS AIRES\\r\\nTipo Domicilio\\r\\nFISCAL\\\";s:14:\\\"person_type_id\\\";i:1;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:40737;s:7:\\\"user_id\\\";i:5117;s:11:\\\"field_name1\\\";s:21:\\\"DUCAU SALERNO MICAELA\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-42498957-1\\\";s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-07-05 18:49:50\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-07-17 21:22:28\\\";s:11:\\\"activity_id\\\";i:1;s:7:\\\"address\\\";s:99:\\\"Direccion\\r\\nJOSE INGENIEROS 2870\\r\\nCod. Postal\\r\\n1636\\r\\nProvincia\\r\\nBUENOS AIRES\\r\\nTipo Domicilio\\r\\nFISCAL\\\";s:14:\\\"person_type_id\\\";i:1;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}s:14:\\\"nombre_del_pdf\\\";s:28:\\\"Factura N\\u00b00004-00000011.pdf\\\";s:9:\\\"body_mail\\\";s:155:\\\"Estimado cliente, se env\\u00eda adjunta la factura de honorarios correspondientes al mes de Julio 2021.\\nMuchas gracias por seguir eligiendo nuestros servicios.\\\";}s:3:\\\"pdf\\\";O:26:\\\"Barryvdh\\\\Snappy\\\\PdfWrapper\\\":4:{s:9:\\\"\\u0000*\\u0000snappy\\\";O:35:\\\"Barryvdh\\\\Snappy\\\\IlluminateSnappyPdf\\\":10:{s:26:\\\"\\u0000*\\u0000optionsWithContentCheck\\\";a:4:{s:11:\\\"header-html\\\";s:4:\\\"html\\\";s:11:\\\"footer-html\\\";s:4:\\\"html\\\";s:5:\\\"cover\\\";s:4:\\\"html\\\";s:15:\\\"xsl-style-sheet\\\";s:3:\\\"xsl\\\";}s:36:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000binary\\\";s:76:\\\"\\/home\\/forge\\/taxes.com.ar\\/vendor\\/h4cc\\/wkhtmltopdf-amd64\\/bin\\/wkhtmltopdf-amd64\\\";s:37:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000options\\\";a:132:{s:7:\\\"collate\\\";N;s:10:\\\"no-collate\\\";N;s:10:\\\"cookie-jar\\\";N;s:6:\\\"copies\\\";i:1;s:3:\\\"dpi\\\";N;s:13:\\\"extended-help\\\";N;s:9:\\\"grayscale\\\";N;s:4:\\\"help\\\";N;s:7:\\\"htmldoc\\\";N;s:18:\\\"ignore-load-errors\\\";N;s:9:\\\"image-dpi\\\";N;s:13:\\\"image-quality\\\";N;s:7:\\\"license\\\";N;s:9:\\\"log-level\\\";N;s:10:\\\"lowquality\\\";b:1;s:7:\\\"manpage\\\";N;s:13:\\\"margin-bottom\\\";N;s:11:\\\"margin-left\\\";N;s:12:\\\"margin-right\\\";N;s:10:\\\"margin-top\\\";N;s:11:\\\"orientation\\\";N;s:11:\\\"page-height\\\";N;s:9:\\\"page-size\\\";s:2:\\\"a4\\\";s:10:\\\"page-width\\\";N;s:18:\\\"no-pdf-compression\\\";N;s:5:\\\"quiet\\\";N;s:20:\\\"read-args-from-stdin\\\";N;s:6:\\\"readme\\\";N;s:5:\\\"title\\\";N;s:11:\\\"use-xserver\\\";N;s:7:\\\"version\\\";N;s:20:\\\"dump-default-toc-xsl\\\";N;s:12:\\\"dump-outline\\\";N;s:7:\\\"outline\\\";N;s:10:\\\"no-outline\\\";N;s:13:\\\"outline-depth\\\";N;s:13:\\\"output-format\\\";N;s:5:\\\"allow\\\";N;s:10:\\\"background\\\";N;s:13:\\\"no-background\\\";N;s:16:\\\"bypass-proxy-for\\\";N;s:9:\\\"cache-dir\\\";N;s:20:\\\"checkbox-checked-svg\\\";N;s:12:\\\"checkbox-svg\\\";N;s:6:\\\"cookie\\\";N;s:13:\\\"custom-header\\\";N;s:25:\\\"custom-header-propagation\\\";N;s:28:\\\"no-custom-header-propagation\\\";N;s:16:\\\"debug-javascript\\\";N;s:19:\\\"no-debug-javascript\\\";N;s:14:\\\"default-header\\\";N;s:8:\\\"encoding\\\";N;s:22:\\\"disable-external-links\\\";N;s:21:\\\"enable-external-links\\\";N;s:13:\\\"disable-forms\\\";N;s:12:\\\"enable-forms\\\";N;s:6:\\\"images\\\";N;s:9:\\\"no-images\\\";N;s:22:\\\"disable-internal-links\\\";N;s:21:\\\"enable-internal-links\\\";N;s:18:\\\"disable-javascript\\\";N;s:17:\\\"enable-javascript\\\";N;s:16:\\\"javascript-delay\\\";N;s:19:\\\"keep-relative-links\\\";N;s:19:\\\"load-error-handling\\\";N;s:25:\\\"load-media-error-handling\\\";N;s:25:\\\"disable-local-file-access\\\";N;s:24:\\\"enable-local-file-access\\\";N;s:17:\\\"minimum-font-size\\\";N;s:20:\\\"exclude-from-outline\\\";N;s:18:\\\"include-in-outline\\\";N;s:11:\\\"page-offset\\\";N;s:8:\\\"password\\\";N;s:15:\\\"disable-plugins\\\";N;s:14:\\\"enable-plugins\\\";N;s:4:\\\"post\\\";N;s:9:\\\"post-file\\\";N;s:16:\\\"print-media-type\\\";N;s:19:\\\"no-print-media-type\\\";N;s:5:\\\"proxy\\\";N;s:21:\\\"proxy-hostname-lookup\\\";N;s:23:\\\"radiobutton-checked-svg\\\";N;s:15:\\\"radiobutton-svg\\\";N;s:14:\\\"redirect-delay\\\";N;s:22:\\\"resolve-relative-links\\\";N;s:10:\\\"run-script\\\";N;s:23:\\\"disable-smart-shrinking\\\";N;s:22:\\\"enable-smart-shrinking\\\";N;s:12:\\\"ssl-crt-path\\\";N;s:16:\\\"ssl-key-password\\\";N;s:12:\\\"ssl-key-path\\\";N;s:17:\\\"stop-slow-scripts\\\";N;s:20:\\\"no-stop-slow-scripts\\\";N;s:22:\\\"disable-toc-back-links\\\";N;s:21:\\\"enable-toc-back-links\\\";N;s:16:\\\"user-style-sheet\\\";N;s:8:\\\"username\\\";N;s:13:\\\"viewport-size\\\";N;s:13:\\\"window-status\\\";N;s:4:\\\"zoom\\\";N;s:13:\\\"footer-center\\\";s:25:\\\"Pagina [page] de [toPage]\\\";s:16:\\\"footer-font-name\\\";N;s:16:\\\"footer-font-size\\\";i:8;s:11:\\\"footer-html\\\";N;s:11:\\\"footer-left\\\";s:0:\\\"\\\";s:11:\\\"footer-line\\\";N;s:14:\\\"no-footer-line\\\";N;s:12:\\\"footer-right\\\";N;s:14:\\\"footer-spacing\\\";N;s:13:\\\"header-center\\\";N;s:16:\\\"header-font-name\\\";N;s:16:\\\"header-font-size\\\";N;s:11:\\\"header-html\\\";N;s:11:\\\"header-left\\\";N;s:11:\\\"header-line\\\";N;s:14:\\\"no-header-line\\\";N;s:12:\\\"header-right\\\";N;s:14:\\\"header-spacing\\\";N;s:7:\\\"replace\\\";N;s:5:\\\"cover\\\";N;s:3:\\\"toc\\\";N;s:20:\\\"disable-dotted-lines\\\";N;s:9:\\\"toc-depth\\\";N;s:13:\\\"toc-font-name\\\";N;s:16:\\\"toc-l1-font-size\\\";N;s:15:\\\"toc-header-text\\\";N;s:20:\\\"toc-header-font-name\\\";N;s:20:\\\"toc-header-font-size\\\";N;s:21:\\\"toc-level-indentation\\\";N;s:17:\\\"disable-toc-links\\\";N;s:20:\\\"toc-text-size-shrink\\\";N;s:15:\\\"xsl-style-sheet\\\";N;}s:33:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000env\\\";N;s:37:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000timeout\\\";b:0;s:46:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000defaultExtension\\\";s:3:\\\"pdf\\\";s:18:\\\"\\u0000*\\u0000temporaryFolder\\\";N;s:14:\\\"temporaryFiles\\\";a:0:{}s:36:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000logger\\\";O:18:\\\"Psr\\\\Log\\\\NullLogger\\\":0:{}s:2:\\\"fs\\\";O:32:\\\"Illuminate\\\\Filesystem\\\\Filesystem\\\":0:{}}s:10:\\\"\\u0000*\\u0000options\\\";a:0:{}s:4:\\\"html\\\";s:22100:\\\"<!DOCTYPE html>\\n<html lang=\\\"en\\\">\\n    <head>\\n        <meta charset=\\\"utf-8\\\">\\n    <\\/head>\\n    <style>\\n        .subtotales_conceptos{\\n            width:30%;\\n            text-align: right;\\n        }\\n        .subtotales_importes{\\n            text-align: right;\\n        }\\n        .table-totales, .table-totales tr, .table-totales th{\\n            border: 1px solid;\\n        }\\n\\n    <\\/style>\\n    <body>\\n    <div style=\\\"max-height:840px\\\">\\n        <div style=\\\"width: 100%; height:270px\\\"> <!-- Datos de la empresa -->\\n            <table class=\\\"display\\\" cellspacing=\\\"0\\\" width=\\\"100%\\\" style=\\\"border:  1px solid;\\\">\\n                <tr style=\\\"\\\">\\n                    <th colspan=\\\"2\\\" rowspan=\\\"2\\\" style=\\\"width:45%;margin:0;height:150px;\\\">\\n                                                <img src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/img\\/\\/27377183504\\/logo_punto_venta_0000.png\\\"\\/>\\n                                            <\\/th>\\n                    <th style=\\\"border:  1px solid;text-align: center; width:10%\\\" colspan=\\\"2\\\">\\n                        <span style=\\\"font-size: 60px;\\\">C<\\/span> <br \\/> <span style=\\\"font-size: 14px;\\\">cod. 11<\\/span>\\n                    <\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"font-size: 28px;text-align: center;width:45%\\\">\\n                        Factura\\n                        <br>\\n                        0004 - 00000011\\n                    <\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th><\\/th>\\n                    <th style=\\\"border:  1px 1px 1px 0px solid;\\\" colspan=\\\"2\\\"><\\/th>\\n                    <th><\\/th>\\n                <\\/tr>\\n                <tr>\\n\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                                                    Raz&oacute;n Social:\\n                            <span style=\\\"font-weight: normal;\\\">MICAELA AILIN CORIA<\\/span>\\n                                            <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">Fecha de Emisi&oacute;n: <span style=\\\"font-weight: normal;\\\">15\\/07\\/2021<\\/span><\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Domicilio Comercial: <span style=\\\"font-weight: normal;\\\">Victor Guillet esq. Arturo M Bas, C.P.:5800,\\n                        C\\u00f3rdoba<\\/span>\\n                    <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">CUIT: <span style=\\\"font-weight: normal;\\\">27-37718350-4<\\/span><\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Condici&oacute;n frente al IVA: <span style=\\\"font-weight: normal;\\\">Monotributo<\\/span>\\n                    <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Ingresos Brutos: <span style=\\\"font-weight: normal;\\\"><\\/span>\\n                        <br>\\n                        Fecha de Inicio de Actividades: <span style=\\\"font-weight: normal;\\\">09\\/07\\/2021<\\/span>\\n                    <\\/th>\\n                <\\/tr>\\n            <\\/table>\\n        <\\/div>\\n\\n        <table style=\\\"text-align: center; width: 100%;border: solid 1px;\\\"> <!-- Fechas -->\\n            <thead>\\n                <tr>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Per\\u00edodo Facturado Desde: 01\\/07\\/2021<\\/small><\\/th>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Per\\u00edodo Facturado Hasta: 31\\/07\\/2021<\\/small><\\/th>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Fecha Vto. Pago: 15\\/07\\/2021<\\/small><\\/th>\\n                <\\/tr>\\n            <\\/thead>\\n        <\\/table>\\n        \\n        <table style=\\\"width: 100%; margin-top: 1%;border: solid 1px;\\\"> <!-- Datos Clientes -->\\n            <tr>\\n                <th style=\\\"text-align:left;\\\"colspan=\\\"12\\\">\\n                    CUIT: <span style=\\\"font-weight: normal;\\\">27-42498957-1<\\/span>\\n                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\\n                    Apellido y Nombre \\/ Raz&oacute;n Social: <span style=\\\"font-weight: normal;\\\">\\n                    DUCAU SALERNO MICAELA<\\/span>\\n                <\\/th>\\n            <\\/tr>\\n            <tr>\\n                <th style=\\\"text-align:left; width:50%\\\">\\n                    Condici&oacute;n Frente al IVA: <span style=\\\"font-weight: normal;\\\">Responsable Monotributo<\\/span>\\n                <\\/th>\\n                <th style=\\\"text-align:left; width:50%\\\" colspan=\\\"4\\\">\\n                    Domicilio Comercial:\\n                    <span style=\\\"font-weight: normal;\\\">\\n                    Direccion\\r\\nJOSE INGENIEROS 2870\\r\\nCod. Postal\\r\\n1636\\r\\nProvincia\\r\\nBUENOS AIRES\\r\\nTipo Domicilio\\r\\nFISCAL\\n                    <\\/span>\\n                <\\/th>\\n            <\\/tr>\\n            <tr style=\\\"text-align:left\\\">\\n                <th>Condici&oacute;n de Venta: <span style=\\\"font-weight: normal;\\\">Cuenta Corriente<\\/span><\\/th>\\n            <\\/tr>\\n        <\\/table>\\n\\n        <div style=\\\"border: 1px solid;margin-top: 1%;min-height:600px;\\\">\\n        <table style=\\\"text-align: center; width: 100%; margin-top: 1%;\\\"> <!-- Body -->\\n            <tr style=\\\"border-bottom: 1px solid;font-size: 15px\\\">\\n                <th>C&oacute;digo<\\/th>\\n                <th style=\\\"width: 25%;\\\">Detalle<\\/th>\\n                <th>Cantidad<\\/th>\\n                <th>U.Medida<\\/th>\\n                <th>Precio U.<\\/th>\\n                <th>Bonif. (%)<\\/th>\\n                <th>Precio Bonif.<\\/th>\\n                <th>Subtotal<\\/th>\\n                            <\\/tr>\\n            <tbody>\\n                                                                                <tr style=\\\"font-size: 12px;\\\">\\n                        <td>\\n                            \\n                        <\\/td>\\n                        <td>\\n                            Honorarios profesionales Julio 2021\\n                        <\\/td>\\n                        <td>\\n                            1.00\\n                        <\\/td>\\n                        <td>\\n                            Unidades\\n                        <\\/td>\\n                        <td>                            2.950,00\\n                                                    <\\/td>\\n                        <td>\\n                            0,00%\\n                        <\\/td>\\n                        <td>\\n                            0,00\\n                        <\\/td>\\n                        <td>\\n                            2.950,00\\n                        <\\/td>\\n                                            <\\/tr>\\n                    \\n            <\\/tbody>\\n        <\\/table>\\n        <\\/div>\\n\\n        \\n\\n        <div style=\\\"height:200px;margin-top: 1%;\\\"> <!-- Totales -->\\n              <!-- Es factura B o C -->\\n                <table class=\\\"table-totales\\\" cellspacing=\\\"0\\\" width=\\\"100%\\\">\\n                    <tr>\\n                        <th style=\\\"width:50%; text-align:left;\\\">\\n\\n<!--                                <span style=\\\"width:100%;\\\"><img src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/barcodes\\/71304902475454.png\\\"><\\/span>\\n                                <span style=\\\"text-align:center;\\\">2737718350411000471304902475454202107251<\\/span>-->\\n                        <\\/th>\\n                        <th class=\\\"subtotales_conceptos\\\">TOTAL:<\\/th>\\n                        <th class=\\\"subtotales_importes\\\">$ 2.950,00<\\/th>\\n                    <\\/tr>\\n                <\\/table>\\n                <br>\\n                <table cellspacing=\\\"0\\\" width=\\\"100%\\\" style=\\\"border: none\\\">\\n                    <tr>\\n                        <th style=\\\"width:50%; text-align:left;\\\">\\n\\n                            <?xml version=\\\"1.0\\\" encoding=\\\"UTF-8\\\"?>\\n<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" version=\\\"1.1\\\" width=\\\"100\\\" height=\\\"100\\\" viewBox=\\\"0 0 100 100\\\"><rect x=\\\"0\\\" y=\\\"0\\\" width=\\\"100\\\" height=\\\"100\\\" fill=\\\"#ffffff\\\"\\/><g transform=\\\"scale(1.754)\\\"><g transform=\\\"translate(0,0)\\\"><path fill-rule=\\\"evenodd\\\" d=\\\"M8 0L8 1L10 1L10 0ZM11 0L11 2L12 2L12 8L13 8L13 9L9 9L9 8L10 8L10 7L11 7L11 6L10 6L10 7L9 7L9 6L8 6L8 7L9 7L9 8L8 8L8 11L7 11L7 10L6 10L6 11L3 11L3 12L4 12L4 13L5 13L5 12L6 12L6 13L8 13L8 14L5 14L5 15L4 15L4 14L3 14L3 13L1 13L1 14L0 14L0 15L1 15L1 14L2 14L2 15L3 15L3 16L2 16L2 17L4 17L4 18L3 18L3 19L0 19L0 22L2 22L2 21L3 21L3 20L4 20L4 23L1 23L1 24L0 24L0 25L1 25L1 26L0 26L0 27L1 27L1 28L4 28L4 29L3 29L3 30L2 30L2 31L0 31L0 32L2 32L2 33L0 33L0 34L1 34L1 35L0 35L0 36L1 36L1 35L3 35L3 37L4 37L4 36L5 36L5 39L4 39L4 38L3 38L3 40L2 40L2 38L0 38L0 40L1 40L1 41L0 41L0 43L1 43L1 44L0 44L0 45L1 45L1 46L0 46L0 48L5 48L5 47L7 47L7 48L6 48L6 49L8 49L8 50L9 50L9 49L10 49L10 48L11 48L11 50L10 50L10 51L9 51L9 53L8 53L8 57L9 57L9 55L11 55L11 54L12 54L12 55L13 55L13 53L14 53L14 54L15 54L15 53L16 53L16 54L17 54L17 55L18 55L18 56L17 56L17 57L18 57L18 56L19 56L19 57L21 57L21 55L22 55L22 53L21 53L21 55L20 55L20 51L21 51L21 52L23 52L23 50L24 50L24 53L25 53L25 54L23 54L23 56L22 56L22 57L24 57L24 56L26 56L26 55L25 55L25 54L27 54L27 53L31 53L31 54L33 54L33 55L32 55L32 56L34 56L34 57L36 57L36 55L38 55L38 56L37 56L37 57L44 57L44 56L43 56L43 55L42 55L42 56L41 56L41 55L40 55L40 54L42 54L42 53L40 53L40 52L43 52L43 53L45 53L45 52L46 52L46 51L45 51L45 49L47 49L47 48L48 48L48 50L47 50L47 53L46 53L46 54L44 54L44 55L45 55L45 56L46 56L46 57L47 57L47 54L48 54L48 55L49 55L49 54L50 54L50 57L51 57L51 54L52 54L52 53L53 53L53 54L54 54L54 55L53 55L53 56L52 56L52 57L55 57L55 56L54 56L54 55L55 55L55 54L56 54L56 53L57 53L57 51L56 51L56 49L57 49L57 48L56 48L56 49L55 49L55 51L53 51L53 49L54 49L54 48L53 48L53 46L54 46L54 45L56 45L56 46L55 46L55 47L57 47L57 44L53 44L53 46L52 46L52 43L51 43L51 44L50 44L50 42L51 42L51 41L50 41L50 40L52 40L52 42L54 42L54 43L55 43L55 42L57 42L57 40L56 40L56 38L57 38L57 31L56 31L56 30L57 30L57 27L56 27L56 24L57 24L57 21L56 21L56 20L53 20L53 19L54 19L54 18L55 18L55 14L54 14L54 10L53 10L53 9L55 9L55 10L56 10L56 11L55 11L55 12L57 12L57 8L56 8L56 9L55 9L55 8L52 8L52 10L51 10L51 11L50 11L50 10L49 10L49 9L50 9L50 8L48 8L48 7L49 7L49 6L48 6L48 7L47 7L47 5L48 5L48 0L45 0L45 1L43 1L43 0L39 0L39 1L41 1L41 4L40 4L40 5L39 5L39 2L38 2L38 1L37 1L37 2L36 2L36 1L32 1L32 2L31 2L31 0L30 0L30 1L29 1L29 0L28 0L28 1L26 1L26 0L24 0L24 1L23 1L23 0L22 0L22 1L23 1L23 2L22 2L22 3L21 3L21 4L20 4L20 5L21 5L21 4L22 4L22 10L21 10L21 11L20 11L20 12L19 12L19 10L20 10L20 9L21 9L21 8L20 8L20 7L21 7L21 6L20 6L20 7L19 7L19 6L18 6L18 7L17 7L17 6L16 6L16 7L15 7L15 6L14 6L14 5L13 5L13 4L14 4L14 3L15 3L15 5L17 5L17 4L16 4L16 3L17 3L17 2L18 2L18 1L17 1L17 2L15 2L15 1L16 1L16 0L14 0L14 2L13 2L13 0ZM19 1L19 2L21 2L21 1ZM25 1L25 2L23 2L23 3L22 3L22 4L23 4L23 3L24 3L24 5L23 5L23 10L22 10L22 13L23 13L23 14L24 14L24 16L23 16L23 15L22 15L22 14L20 14L20 13L19 13L19 12L18 12L18 10L19 10L19 9L20 9L20 8L18 8L18 9L17 9L17 8L15 8L15 7L14 7L14 6L13 6L13 7L14 7L14 9L13 9L13 10L12 10L12 12L11 12L11 13L10 13L10 14L8 14L8 20L7 20L7 19L6 19L6 20L5 20L5 21L6 21L6 22L7 22L7 21L8 21L8 23L6 23L6 24L8 24L8 25L10 25L10 24L9 24L9 22L10 22L10 23L12 23L12 24L11 24L11 25L12 25L12 27L13 27L13 25L12 25L12 24L13 24L13 23L14 23L14 24L16 24L16 23L18 23L18 22L19 22L19 23L20 23L20 24L19 24L19 25L18 25L18 26L17 26L17 25L16 25L16 26L15 26L15 25L14 25L14 27L16 27L16 28L15 28L15 29L14 29L14 28L11 28L11 26L9 26L9 29L11 29L11 31L10 31L10 30L9 30L9 31L10 31L10 33L9 33L9 32L8 32L8 31L4 31L4 30L3 30L3 31L4 31L4 32L3 32L3 33L6 33L6 34L7 34L7 35L6 35L6 36L8 36L8 37L6 37L6 38L8 38L8 37L10 37L10 36L9 36L9 34L11 34L11 38L10 38L10 39L11 39L11 38L13 38L13 39L14 39L14 41L13 41L13 42L12 42L12 40L7 40L7 39L6 39L6 40L7 40L7 41L6 41L6 42L7 42L7 43L5 43L5 42L1 42L1 43L4 43L4 44L3 44L3 45L4 45L4 44L5 44L5 46L3 46L3 47L5 47L5 46L7 46L7 47L8 47L8 48L10 48L10 47L15 47L15 49L14 49L14 48L13 48L13 49L14 49L14 50L15 50L15 49L16 49L16 53L17 53L17 51L20 51L20 48L22 48L22 49L23 49L23 48L22 48L22 47L24 47L24 46L22 46L22 44L23 44L23 45L25 45L25 46L27 46L27 44L28 44L28 47L26 47L26 48L24 48L24 50L25 50L25 49L26 49L26 48L28 48L28 47L29 47L29 48L30 48L30 47L32 47L32 50L31 50L31 51L32 51L32 50L33 50L33 51L35 51L35 52L36 52L36 53L35 53L35 55L34 55L34 56L35 56L35 55L36 55L36 53L37 53L37 54L38 54L38 55L39 55L39 56L40 56L40 55L39 55L39 53L37 53L37 51L38 51L38 52L40 52L40 50L41 50L41 51L42 51L42 50L43 50L43 51L44 51L44 49L45 49L45 48L46 48L46 46L47 46L47 45L48 45L48 44L49 44L49 42L50 42L50 41L47 41L47 42L48 42L48 43L46 43L46 44L45 44L45 42L46 42L46 40L47 40L47 39L48 39L48 38L47 38L47 37L49 37L49 38L50 38L50 39L52 39L52 40L53 40L53 41L54 41L54 42L55 42L55 41L56 41L56 40L55 40L55 41L54 41L54 39L55 39L55 38L56 38L56 36L55 36L55 35L56 35L56 32L55 32L55 30L56 30L56 27L55 27L55 23L54 23L54 22L51 22L51 21L52 21L52 20L51 20L51 19L53 19L53 18L52 18L52 17L54 17L54 14L52 14L52 13L53 13L53 10L52 10L52 11L51 11L51 12L52 12L52 13L51 13L51 17L50 17L50 18L51 18L51 19L50 19L50 20L49 20L49 17L47 17L47 16L46 16L46 15L47 15L47 13L48 13L48 14L50 14L50 12L49 12L49 10L48 10L48 8L47 8L47 9L46 9L46 10L48 10L48 11L46 11L46 12L47 12L47 13L46 13L46 14L45 14L45 12L44 12L44 13L43 13L43 12L42 12L42 13L41 13L41 9L44 9L44 10L43 10L43 11L45 11L45 7L46 7L46 5L47 5L47 3L46 3L46 2L47 2L47 1L45 1L45 3L44 3L44 5L43 5L43 4L41 4L41 7L42 7L42 8L41 8L41 9L39 9L39 8L38 8L38 9L37 9L37 8L35 8L35 7L36 7L36 6L37 6L37 7L38 7L38 6L37 6L37 5L38 5L38 3L37 3L37 5L35 5L35 4L34 4L34 5L33 5L33 7L32 7L32 4L33 4L33 3L34 3L34 2L33 2L33 3L31 3L31 8L32 8L32 9L31 9L31 10L33 10L33 11L34 11L34 10L35 10L35 13L34 13L34 14L32 14L32 15L33 15L33 17L30 17L30 18L28 18L28 19L27 19L27 17L29 17L29 16L30 16L30 15L29 15L29 13L30 13L30 14L31 14L31 13L33 13L33 12L31 12L31 11L26 11L26 12L25 12L25 11L24 11L24 8L25 8L25 10L27 10L27 9L26 9L26 8L25 8L25 7L26 7L26 6L25 6L25 5L26 5L26 4L25 4L25 2L26 2L26 3L28 3L28 4L30 4L30 3L29 3L29 2L26 2L26 1ZM8 2L8 5L9 5L9 2ZM10 3L10 5L11 5L11 3ZM18 3L18 5L19 5L19 3ZM45 3L45 5L46 5L46 3ZM27 5L27 8L30 8L30 5ZM42 5L42 7L43 7L43 8L44 8L44 7L45 7L45 6L44 6L44 7L43 7L43 5ZM24 6L24 7L25 7L25 6ZM28 6L28 7L29 7L29 6ZM34 6L34 7L35 7L35 6ZM39 6L39 7L40 7L40 6ZM0 8L0 9L4 9L4 10L5 10L5 9L4 9L4 8ZM6 8L6 9L7 9L7 8ZM14 9L14 11L15 11L15 13L11 13L11 14L10 14L10 17L9 17L9 19L10 19L10 18L11 18L11 14L12 14L12 15L14 15L14 18L13 18L13 19L12 19L12 21L13 21L13 19L15 19L15 18L17 18L17 17L18 17L18 19L16 19L16 20L14 20L14 21L15 21L15 23L16 23L16 21L17 21L17 22L18 22L18 21L17 21L17 20L18 20L18 19L20 19L20 21L19 21L19 22L20 22L20 21L21 21L21 19L22 19L22 23L25 23L25 25L26 25L26 29L25 29L25 27L24 27L24 26L23 26L23 25L22 25L22 24L20 24L20 25L19 25L19 27L17 27L17 28L16 28L16 30L14 30L14 29L12 29L12 31L11 31L11 33L12 33L12 34L13 34L13 37L14 37L14 39L15 39L15 38L17 38L17 39L16 39L16 40L15 40L15 42L16 42L16 43L17 43L17 45L18 45L18 46L17 46L17 47L16 47L16 45L15 45L15 44L13 44L13 43L14 43L14 42L13 42L13 43L11 43L11 44L12 44L12 46L13 46L13 45L15 45L15 47L16 47L16 49L17 49L17 50L19 50L19 48L20 48L20 47L21 47L21 46L20 46L20 47L18 47L18 46L19 46L19 44L20 44L20 45L21 45L21 44L20 44L20 43L18 43L18 42L20 42L20 41L18 41L18 42L17 42L17 41L16 41L16 40L17 40L17 39L18 39L18 40L20 40L20 38L21 38L21 37L22 37L22 38L24 38L24 36L23 36L23 37L22 37L22 36L21 36L21 34L19 34L19 35L20 35L20 38L19 38L19 36L18 36L18 38L17 38L17 37L16 37L16 36L17 36L17 35L18 35L18 34L17 34L17 35L16 35L16 34L13 34L13 33L14 33L14 32L15 32L15 31L17 31L17 32L18 32L18 28L19 28L19 30L20 30L20 28L19 28L19 27L23 27L23 30L22 30L22 29L21 29L21 30L22 30L22 31L20 31L20 33L21 33L21 32L22 32L22 35L26 35L26 36L25 36L25 37L27 37L27 35L28 35L28 37L29 37L29 39L30 39L30 38L31 38L31 40L27 40L27 42L29 42L29 41L30 41L30 44L29 44L29 43L28 43L28 44L29 44L29 45L30 45L30 46L31 46L31 45L32 45L32 47L33 47L33 46L34 46L34 48L33 48L33 50L34 50L34 48L35 48L35 47L36 47L36 49L35 49L35 51L36 51L36 49L37 49L37 48L38 48L38 45L37 45L37 47L36 47L36 45L35 45L35 46L34 46L34 45L32 45L32 43L31 43L31 41L33 41L33 43L35 43L35 44L37 44L37 42L38 42L38 44L39 44L39 47L40 47L40 45L41 45L41 48L42 48L42 49L43 49L43 48L45 48L45 45L44 45L44 44L43 44L43 43L42 43L42 45L41 45L41 43L40 43L40 44L39 44L39 42L38 42L38 41L37 41L37 42L36 42L36 40L35 40L35 39L38 39L38 40L39 40L39 41L40 41L40 42L42 42L42 41L43 41L43 42L45 42L45 40L46 40L46 38L45 38L45 37L46 37L46 36L48 36L48 35L49 35L49 34L48 34L48 33L50 33L50 38L51 38L51 35L52 35L52 37L54 37L54 38L53 38L53 39L54 39L54 38L55 38L55 37L54 37L54 35L55 35L55 32L54 32L54 29L55 29L55 27L53 27L53 25L52 25L52 23L51 23L51 25L50 25L50 23L49 23L49 25L50 25L50 26L48 26L48 23L47 23L47 22L46 22L46 21L44 21L44 22L43 22L43 18L44 18L44 17L46 17L46 19L45 19L45 20L47 20L47 21L48 21L48 22L49 22L49 20L47 20L47 19L48 19L48 18L47 18L47 17L46 17L46 16L45 16L45 15L44 15L44 14L42 14L42 15L41 15L41 13L40 13L40 10L39 10L39 13L38 13L38 12L37 12L37 9L36 9L36 13L35 13L35 15L39 15L39 16L38 16L38 17L37 17L37 19L36 19L36 18L35 18L35 17L36 17L36 16L35 16L35 17L33 17L33 18L31 18L31 19L35 19L35 20L37 20L37 22L36 22L36 21L35 21L35 22L32 22L32 20L30 20L30 19L28 19L28 20L27 20L27 19L25 19L25 18L24 18L24 19L22 19L22 18L21 18L21 19L20 19L20 16L19 16L19 17L18 17L18 16L17 16L17 14L18 14L18 12L17 12L17 11L16 11L16 10L15 10L15 9ZM28 9L28 10L30 10L30 9ZM1 10L1 11L0 11L0 12L2 12L2 10ZM9 10L9 11L8 11L8 13L9 13L9 11L10 11L10 10ZM6 11L6 12L7 12L7 11ZM23 12L23 13L24 13L24 12ZM26 12L26 14L25 14L25 16L24 16L24 17L25 17L25 16L26 16L26 15L27 15L27 12ZM15 13L15 14L14 14L14 15L15 15L15 16L16 16L16 14L17 14L17 13ZM36 13L36 14L38 14L38 13ZM39 13L39 15L40 15L40 13ZM19 14L19 15L20 15L20 14ZM5 15L5 17L6 17L6 18L7 18L7 17L6 17L6 16L7 16L7 15ZM28 15L28 16L29 16L29 15ZM42 15L42 16L39 16L39 17L38 17L38 18L41 18L41 17L42 17L42 18L43 18L43 17L42 17L42 16L43 16L43 15ZM49 15L49 16L50 16L50 15ZM52 15L52 16L53 16L53 15ZM56 16L56 18L57 18L57 16ZM24 19L24 20L25 20L25 19ZM37 19L37 20L38 20L38 19ZM39 19L39 20L40 20L40 19ZM41 19L41 20L42 20L42 19ZM6 20L6 21L7 21L7 20ZM9 20L9 21L11 21L11 20ZM29 20L29 21L28 21L28 22L27 22L27 21L25 21L25 23L26 23L26 24L28 24L28 26L31 26L31 27L33 27L33 28L34 28L34 29L35 29L35 31L36 31L36 29L37 29L37 30L39 30L39 29L41 29L41 30L40 30L40 31L41 31L41 33L42 33L42 32L43 32L43 35L44 35L44 33L46 33L46 34L45 34L45 36L41 36L41 35L42 35L42 34L39 34L39 33L40 33L40 32L38 32L38 31L37 31L37 32L35 32L35 33L33 33L33 32L34 32L34 30L33 30L33 31L32 31L32 30L31 30L31 33L30 33L30 31L26 31L26 32L25 32L25 29L24 29L24 32L25 32L25 34L26 34L26 35L27 35L27 34L30 34L30 35L29 35L29 36L30 36L30 35L31 35L31 38L33 38L33 36L32 36L32 34L31 34L31 33L33 33L33 34L36 34L36 35L37 35L37 34L38 34L38 36L37 36L37 37L39 37L39 38L38 38L38 39L40 39L40 41L42 41L42 38L44 38L44 39L45 39L45 38L44 38L44 37L45 37L45 36L46 36L46 34L47 34L47 33L48 33L48 31L46 31L46 32L45 32L45 31L44 31L44 32L43 32L43 29L44 29L44 30L45 30L45 29L44 29L44 27L46 27L46 29L47 29L47 30L48 30L48 27L47 27L47 24L46 24L46 23L45 23L45 22L44 22L44 23L45 23L45 24L44 24L44 25L43 25L43 24L42 24L42 25L41 25L41 23L40 23L40 24L39 24L39 23L38 23L38 24L37 24L37 26L35 26L35 25L36 25L36 23L35 23L35 25L34 25L34 23L33 23L33 24L32 24L32 22L31 22L31 23L30 23L30 20ZM33 20L33 21L34 21L34 20ZM50 20L50 21L51 21L51 20ZM23 21L23 22L24 22L24 21ZM38 21L38 22L40 22L40 21ZM55 21L55 22L56 22L56 21ZM12 22L12 23L13 23L13 22ZM26 22L26 23L27 23L27 22ZM4 23L4 24L5 24L5 23ZM2 24L2 26L4 26L4 25L3 25L3 24ZM31 24L31 26L34 26L34 25L32 25L32 24ZM38 24L38 27L37 27L37 29L38 29L38 28L41 28L41 29L43 29L43 27L42 27L42 28L41 28L41 26L40 26L40 25L39 25L39 24ZM5 25L5 26L7 26L7 25ZM44 25L44 26L45 26L45 25ZM39 26L39 27L40 27L40 26ZM5 27L5 30L8 30L8 27ZM27 27L27 30L30 30L30 27ZM49 27L49 30L52 30L52 27ZM6 28L6 29L7 29L7 28ZM28 28L28 29L29 29L29 28ZM31 28L31 29L32 29L32 28ZM35 28L35 29L36 29L36 28ZM50 28L50 29L51 29L51 28ZM53 28L53 29L54 29L54 28ZM13 31L13 32L12 32L12 33L13 33L13 32L14 32L14 31ZM22 31L22 32L23 32L23 31ZM50 31L50 33L51 33L51 31ZM52 31L52 34L54 34L54 32L53 32L53 31ZM6 32L6 33L7 33L7 34L9 34L9 33L8 33L8 32ZM26 32L26 33L27 33L27 32ZM37 32L37 33L38 33L38 32ZM46 32L46 33L47 33L47 32ZM23 33L23 34L24 34L24 33ZM3 34L3 35L4 35L4 34ZM14 35L14 37L15 37L15 35ZM34 36L34 39L33 39L33 40L34 40L34 39L35 39L35 38L36 38L36 37L35 37L35 36ZM39 36L39 37L40 37L40 39L41 39L41 37L40 37L40 36ZM18 38L18 39L19 39L19 38ZM26 38L26 39L28 39L28 38ZM21 39L21 40L22 40L22 39ZM24 39L24 40L23 40L23 42L24 42L24 41L25 41L25 44L26 44L26 41L25 41L25 39ZM3 40L3 41L4 41L4 40ZM8 41L8 42L10 42L10 41ZM21 41L21 42L22 42L22 41ZM7 43L7 44L6 44L6 45L7 45L7 46L8 46L8 45L7 45L7 44L8 44L8 43ZM23 43L23 44L24 44L24 43ZM30 44L30 45L31 45L31 44ZM9 45L9 47L10 47L10 46L11 46L11 45ZM43 45L43 47L42 47L42 48L43 48L43 47L44 47L44 45ZM49 45L49 48L50 48L50 46L51 46L51 45ZM1 46L1 47L2 47L2 46ZM17 47L17 48L18 48L18 47ZM51 47L51 48L52 48L52 47ZM39 48L39 49L38 49L38 51L39 51L39 50L40 50L40 48ZM27 49L27 52L30 52L30 49ZM49 49L49 52L52 52L52 49ZM12 50L12 51L10 51L10 52L12 52L12 53L13 53L13 52L12 52L12 51L13 51L13 50ZM21 50L21 51L22 51L22 50ZM28 50L28 51L29 51L29 50ZM50 50L50 51L51 51L51 50ZM14 51L14 52L15 52L15 51ZM25 51L25 52L26 52L26 51ZM55 51L55 53L54 53L54 54L55 54L55 53L56 53L56 51ZM18 52L18 53L19 53L19 52ZM31 52L31 53L32 53L32 52ZM33 52L33 54L34 54L34 52ZM9 53L9 54L11 54L11 53ZM50 53L50 54L51 54L51 53ZM18 54L18 55L19 55L19 54ZM14 55L14 56L13 56L13 57L14 57L14 56L15 56L15 55ZM27 55L27 57L31 57L31 56L30 56L30 55L29 55L29 56L28 56L28 55ZM56 55L56 56L57 56L57 55ZM48 56L48 57L49 57L49 56ZM0 0L0 7L7 7L7 0ZM1 1L1 6L6 6L6 1ZM2 2L2 5L5 5L5 2ZM50 0L50 7L57 7L57 0ZM51 1L51 6L56 6L56 1ZM52 2L52 5L55 5L55 2ZM0 50L0 57L7 57L7 50ZM1 51L1 56L6 56L6 51ZM2 52L2 55L5 55L5 52Z\\\" fill=\\\"#000000\\\"\\/><\\/g><\\/g><\\/svg>\\n\\n                            <span style=\\\"width:50%;\\\">\\n                                <img style=\\\"max-height: 70px\\\"\\n                                     src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/img\\/AfipComprobanteAutorizado.png\\\">\\n                            <\\/span>\\n                        <\\/th>\\n                        <th style=\\\"text-align:right;\\\">\\n                            <p>CAE N&#186;: 71304902475454<br>\\n                                Fecha Vto. CAE:  25\\/07\\/2021\\n                            <\\/p>\\n                        <\\/th>\\n                    <\\/tr>\\n                <\\/table>\\n                    <\\/div>\\n    <\\/div>\\n\\n    <\\/body>\\n<\\/html>\\\";s:4:\\\"file\\\";N;}s:6:\\\"locale\\\";N;s:4:\\\"from\\\";a:0:{}s:2:\\\"to\\\";a:1:{i:0;a:2:{s:4:\\\"name\\\";N;s:7:\\\"address\\\";s:19:\\\"micaducau@gmail.com\\\";}}s:2:\\\"cc\\\";a:0:{}s:3:\\\"bcc\\\";a:1:{i:0;a:2:{s:4:\\\"name\\\";N;s:7:\\\"address\\\";s:23:\\\"info@masquecontable.com\\\";}}s:7:\\\"replyTo\\\";a:0:{}s:7:\\\"subject\\\";N;s:11:\\\"\\u0000*\\u0000markdown\\\";N;s:7:\\\"\\u0000*\\u0000html\\\";N;s:4:\\\"view\\\";N;s:8:\\\"textView\\\";N;s:8:\\\"viewData\\\";a:0:{}s:11:\\\"attachments\\\";a:0:{}s:14:\\\"rawAttachments\\\";a:0:{}s:15:\\\"diskAttachments\\\";a:0:{}s:9:\\\"callbacks\\\";a:0:{}s:5:\\\"theme\\\";N;s:6:\\\"mailer\\\";s:8:\\\"sendgrid\\\";s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:5:\\\"delay\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;}\"}}','ErrorException: Trying to get property \'id\' of non-object in /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php:16\nStack trace:\n#0 /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php(16): Illuminate\\Foundation\\Bootstrap\\HandleExceptions->handleError(8, \'Trying to get p...\', \'/home/forge/tax...\', 16, Array)\n#1 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(356): App\\Queue\\DatabaseJob->fire()\n#2 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(306): Illuminate\\Queue\\Worker->process(\'database\', Object(App\\Queue\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#3 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(132): Illuminate\\Queue\\Worker->runJob(Object(App\\Queue\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#4 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(112): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#5 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(96): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#6 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#7 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#8 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#9 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#10 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#11 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(134): Illuminate\\Container\\Container->call(Array)\n#12 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(256): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#13 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(121): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#14 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(971): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#15 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(290): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#16 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(166): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#17 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Application.php(93): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(129): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#19 /home/forge/taxes.com.ar/artisan(35): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#20 {main}','2021-07-23 18:04:00',NULL);
INSERT INTO `failed_jobs` VALUES (9,NULL,'database','default','{\"uuid\":\"fa682d2f-eedc-4767-95f2-a2058239fc59\",\"displayName\":\"App\\\\Mail\\\\Fact_Electronica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"delay\":null,\"timeout\":null,\"timeoutAt\":null,\"data\":{\"commandName\":\"Illuminate\\\\Mail\\\\SendQueuedMailable\",\"command\":\"O:34:\\\"Illuminate\\\\Mail\\\\SendQueuedMailable\\\":3:{s:8:\\\"mailable\\\";O:25:\\\"App\\\\Mail\\\\Fact_Electronica\\\":27:{s:11:\\\"informacion\\\";a:6:{s:12:\\\"ruta_logo_fa\\\";N;s:4:\\\"mail\\\";s:23:\\\"info@masquecontable.com\\\";s:18:\\\"name_quien_factura\\\";s:19:\\\"MICAELA AILIN CORIA\\\";s:7:\\\"cliente\\\";O:17:\\\"App\\\\Models\\\\Person\\\":27:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:7:\\\"persons\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:40802;s:7:\\\"user_id\\\";i:5115;s:11:\\\"field_name1\\\";s:20:\\\"FLER VIRGINIA FAUSTA\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-37701633-0\\\";s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-07-09 10:39:14\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-07-09 10:39:14\\\";s:11:\\\"activity_id\\\";i:1;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";i:1;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:40802;s:7:\\\"user_id\\\";i:5115;s:11:\\\"field_name1\\\";s:20:\\\"FLER VIRGINIA FAUSTA\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-37701633-0\\\";s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-07-09 10:39:14\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-07-09 10:39:14\\\";s:11:\\\"activity_id\\\";i:1;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";i:1;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}s:14:\\\"nombre_del_pdf\\\";s:28:\\\"Factura N\\u00b00004-00000012.pdf\\\";s:9:\\\"body_mail\\\";s:155:\\\"Estimado cliente, se env\\u00eda adjunta la factura de honorarios correspondientes al mes de Julio 2021.\\nMuchas gracias por seguir eligiendo nuestros servicios.\\\";}s:3:\\\"pdf\\\";O:26:\\\"Barryvdh\\\\Snappy\\\\PdfWrapper\\\":4:{s:9:\\\"\\u0000*\\u0000snappy\\\";O:35:\\\"Barryvdh\\\\Snappy\\\\IlluminateSnappyPdf\\\":10:{s:26:\\\"\\u0000*\\u0000optionsWithContentCheck\\\";a:4:{s:11:\\\"header-html\\\";s:4:\\\"html\\\";s:11:\\\"footer-html\\\";s:4:\\\"html\\\";s:5:\\\"cover\\\";s:4:\\\"html\\\";s:15:\\\"xsl-style-sheet\\\";s:3:\\\"xsl\\\";}s:36:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000binary\\\";s:76:\\\"\\/home\\/forge\\/taxes.com.ar\\/vendor\\/h4cc\\/wkhtmltopdf-amd64\\/bin\\/wkhtmltopdf-amd64\\\";s:37:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000options\\\";a:132:{s:7:\\\"collate\\\";N;s:10:\\\"no-collate\\\";N;s:10:\\\"cookie-jar\\\";N;s:6:\\\"copies\\\";i:1;s:3:\\\"dpi\\\";N;s:13:\\\"extended-help\\\";N;s:9:\\\"grayscale\\\";N;s:4:\\\"help\\\";N;s:7:\\\"htmldoc\\\";N;s:18:\\\"ignore-load-errors\\\";N;s:9:\\\"image-dpi\\\";N;s:13:\\\"image-quality\\\";N;s:7:\\\"license\\\";N;s:9:\\\"log-level\\\";N;s:10:\\\"lowquality\\\";b:1;s:7:\\\"manpage\\\";N;s:13:\\\"margin-bottom\\\";N;s:11:\\\"margin-left\\\";N;s:12:\\\"margin-right\\\";N;s:10:\\\"margin-top\\\";N;s:11:\\\"orientation\\\";N;s:11:\\\"page-height\\\";N;s:9:\\\"page-size\\\";s:2:\\\"a4\\\";s:10:\\\"page-width\\\";N;s:18:\\\"no-pdf-compression\\\";N;s:5:\\\"quiet\\\";N;s:20:\\\"read-args-from-stdin\\\";N;s:6:\\\"readme\\\";N;s:5:\\\"title\\\";N;s:11:\\\"use-xserver\\\";N;s:7:\\\"version\\\";N;s:20:\\\"dump-default-toc-xsl\\\";N;s:12:\\\"dump-outline\\\";N;s:7:\\\"outline\\\";N;s:10:\\\"no-outline\\\";N;s:13:\\\"outline-depth\\\";N;s:13:\\\"output-format\\\";N;s:5:\\\"allow\\\";N;s:10:\\\"background\\\";N;s:13:\\\"no-background\\\";N;s:16:\\\"bypass-proxy-for\\\";N;s:9:\\\"cache-dir\\\";N;s:20:\\\"checkbox-checked-svg\\\";N;s:12:\\\"checkbox-svg\\\";N;s:6:\\\"cookie\\\";N;s:13:\\\"custom-header\\\";N;s:25:\\\"custom-header-propagation\\\";N;s:28:\\\"no-custom-header-propagation\\\";N;s:16:\\\"debug-javascript\\\";N;s:19:\\\"no-debug-javascript\\\";N;s:14:\\\"default-header\\\";N;s:8:\\\"encoding\\\";N;s:22:\\\"disable-external-links\\\";N;s:21:\\\"enable-external-links\\\";N;s:13:\\\"disable-forms\\\";N;s:12:\\\"enable-forms\\\";N;s:6:\\\"images\\\";N;s:9:\\\"no-images\\\";N;s:22:\\\"disable-internal-links\\\";N;s:21:\\\"enable-internal-links\\\";N;s:18:\\\"disable-javascript\\\";N;s:17:\\\"enable-javascript\\\";N;s:16:\\\"javascript-delay\\\";N;s:19:\\\"keep-relative-links\\\";N;s:19:\\\"load-error-handling\\\";N;s:25:\\\"load-media-error-handling\\\";N;s:25:\\\"disable-local-file-access\\\";N;s:24:\\\"enable-local-file-access\\\";N;s:17:\\\"minimum-font-size\\\";N;s:20:\\\"exclude-from-outline\\\";N;s:18:\\\"include-in-outline\\\";N;s:11:\\\"page-offset\\\";N;s:8:\\\"password\\\";N;s:15:\\\"disable-plugins\\\";N;s:14:\\\"enable-plugins\\\";N;s:4:\\\"post\\\";N;s:9:\\\"post-file\\\";N;s:16:\\\"print-media-type\\\";N;s:19:\\\"no-print-media-type\\\";N;s:5:\\\"proxy\\\";N;s:21:\\\"proxy-hostname-lookup\\\";N;s:23:\\\"radiobutton-checked-svg\\\";N;s:15:\\\"radiobutton-svg\\\";N;s:14:\\\"redirect-delay\\\";N;s:22:\\\"resolve-relative-links\\\";N;s:10:\\\"run-script\\\";N;s:23:\\\"disable-smart-shrinking\\\";N;s:22:\\\"enable-smart-shrinking\\\";N;s:12:\\\"ssl-crt-path\\\";N;s:16:\\\"ssl-key-password\\\";N;s:12:\\\"ssl-key-path\\\";N;s:17:\\\"stop-slow-scripts\\\";N;s:20:\\\"no-stop-slow-scripts\\\";N;s:22:\\\"disable-toc-back-links\\\";N;s:21:\\\"enable-toc-back-links\\\";N;s:16:\\\"user-style-sheet\\\";N;s:8:\\\"username\\\";N;s:13:\\\"viewport-size\\\";N;s:13:\\\"window-status\\\";N;s:4:\\\"zoom\\\";N;s:13:\\\"footer-center\\\";s:25:\\\"Pagina [page] de [toPage]\\\";s:16:\\\"footer-font-name\\\";N;s:16:\\\"footer-font-size\\\";i:8;s:11:\\\"footer-html\\\";N;s:11:\\\"footer-left\\\";s:0:\\\"\\\";s:11:\\\"footer-line\\\";N;s:14:\\\"no-footer-line\\\";N;s:12:\\\"footer-right\\\";N;s:14:\\\"footer-spacing\\\";N;s:13:\\\"header-center\\\";N;s:16:\\\"header-font-name\\\";N;s:16:\\\"header-font-size\\\";N;s:11:\\\"header-html\\\";N;s:11:\\\"header-left\\\";N;s:11:\\\"header-line\\\";N;s:14:\\\"no-header-line\\\";N;s:12:\\\"header-right\\\";N;s:14:\\\"header-spacing\\\";N;s:7:\\\"replace\\\";N;s:5:\\\"cover\\\";N;s:3:\\\"toc\\\";N;s:20:\\\"disable-dotted-lines\\\";N;s:9:\\\"toc-depth\\\";N;s:13:\\\"toc-font-name\\\";N;s:16:\\\"toc-l1-font-size\\\";N;s:15:\\\"toc-header-text\\\";N;s:20:\\\"toc-header-font-name\\\";N;s:20:\\\"toc-header-font-size\\\";N;s:21:\\\"toc-level-indentation\\\";N;s:17:\\\"disable-toc-links\\\";N;s:20:\\\"toc-text-size-shrink\\\";N;s:15:\\\"xsl-style-sheet\\\";N;}s:33:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000env\\\";N;s:37:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000timeout\\\";b:0;s:46:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000defaultExtension\\\";s:3:\\\"pdf\\\";s:18:\\\"\\u0000*\\u0000temporaryFolder\\\";N;s:14:\\\"temporaryFiles\\\";a:0:{}s:36:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000logger\\\";O:18:\\\"Psr\\\\Log\\\\NullLogger\\\":0:{}s:2:\\\"fs\\\";O:32:\\\"Illuminate\\\\Filesystem\\\\Filesystem\\\":0:{}}s:10:\\\"\\u0000*\\u0000options\\\";a:0:{}s:4:\\\"html\\\";s:22022:\\\"<!DOCTYPE html>\\n<html lang=\\\"en\\\">\\n    <head>\\n        <meta charset=\\\"utf-8\\\">\\n    <\\/head>\\n    <style>\\n        .subtotales_conceptos{\\n            width:30%;\\n            text-align: right;\\n        }\\n        .subtotales_importes{\\n            text-align: right;\\n        }\\n        .table-totales, .table-totales tr, .table-totales th{\\n            border: 1px solid;\\n        }\\n\\n    <\\/style>\\n    <body>\\n    <div style=\\\"max-height:840px\\\">\\n        <div style=\\\"width: 100%; height:270px\\\"> <!-- Datos de la empresa -->\\n            <table class=\\\"display\\\" cellspacing=\\\"0\\\" width=\\\"100%\\\" style=\\\"border:  1px solid;\\\">\\n                <tr style=\\\"\\\">\\n                    <th colspan=\\\"2\\\" rowspan=\\\"2\\\" style=\\\"width:45%;margin:0;height:150px;\\\">\\n                                                <img src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/img\\/\\/27377183504\\/logo_punto_venta_0000.png\\\"\\/>\\n                                            <\\/th>\\n                    <th style=\\\"border:  1px solid;text-align: center; width:10%\\\" colspan=\\\"2\\\">\\n                        <span style=\\\"font-size: 60px;\\\">C<\\/span> <br \\/> <span style=\\\"font-size: 14px;\\\">cod. 11<\\/span>\\n                    <\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"font-size: 28px;text-align: center;width:45%\\\">\\n                        Factura\\n                        <br>\\n                        0004 - 00000012\\n                    <\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th><\\/th>\\n                    <th style=\\\"border:  1px 1px 1px 0px solid;\\\" colspan=\\\"2\\\"><\\/th>\\n                    <th><\\/th>\\n                <\\/tr>\\n                <tr>\\n\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                                                    Raz&oacute;n Social:\\n                            <span style=\\\"font-weight: normal;\\\">MICAELA AILIN CORIA<\\/span>\\n                                            <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">Fecha de Emisi&oacute;n: <span style=\\\"font-weight: normal;\\\">15\\/07\\/2021<\\/span><\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Domicilio Comercial: <span style=\\\"font-weight: normal;\\\">Victor Guillet esq. Arturo M Bas, C.P.:5800,\\n                        C\\u00f3rdoba<\\/span>\\n                    <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">CUIT: <span style=\\\"font-weight: normal;\\\">27-37718350-4<\\/span><\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Condici&oacute;n frente al IVA: <span style=\\\"font-weight: normal;\\\">Monotributo<\\/span>\\n                    <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Ingresos Brutos: <span style=\\\"font-weight: normal;\\\"><\\/span>\\n                        <br>\\n                        Fecha de Inicio de Actividades: <span style=\\\"font-weight: normal;\\\">09\\/07\\/2021<\\/span>\\n                    <\\/th>\\n                <\\/tr>\\n            <\\/table>\\n        <\\/div>\\n\\n        <table style=\\\"text-align: center; width: 100%;border: solid 1px;\\\"> <!-- Fechas -->\\n            <thead>\\n                <tr>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Per\\u00edodo Facturado Desde: 01\\/07\\/2021<\\/small><\\/th>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Per\\u00edodo Facturado Hasta: 31\\/07\\/2021<\\/small><\\/th>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Fecha Vto. Pago: 15\\/07\\/2021<\\/small><\\/th>\\n                <\\/tr>\\n            <\\/thead>\\n        <\\/table>\\n        \\n        <table style=\\\"width: 100%; margin-top: 1%;border: solid 1px;\\\"> <!-- Datos Clientes -->\\n            <tr>\\n                <th style=\\\"text-align:left;\\\"colspan=\\\"12\\\">\\n                    CUIT: <span style=\\\"font-weight: normal;\\\">27-37701633-0<\\/span>\\n                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\\n                    Apellido y Nombre \\/ Raz&oacute;n Social: <span style=\\\"font-weight: normal;\\\">\\n                    FLER VIRGINIA FAUSTA<\\/span>\\n                <\\/th>\\n            <\\/tr>\\n            <tr>\\n                <th style=\\\"text-align:left; width:50%\\\">\\n                    Condici&oacute;n Frente al IVA: <span style=\\\"font-weight: normal;\\\">Responsable Monotributo<\\/span>\\n                <\\/th>\\n                <th style=\\\"text-align:left; width:50%\\\" colspan=\\\"4\\\">\\n                    Domicilio Comercial:\\n                    <span style=\\\"font-weight: normal;\\\">\\n                    --------\\n                    <\\/span>\\n                <\\/th>\\n            <\\/tr>\\n            <tr style=\\\"text-align:left\\\">\\n                <th>Condici&oacute;n de Venta: <span style=\\\"font-weight: normal;\\\">Cuenta Corriente<\\/span><\\/th>\\n            <\\/tr>\\n        <\\/table>\\n\\n        <div style=\\\"border: 1px solid;margin-top: 1%;min-height:600px;\\\">\\n        <table style=\\\"text-align: center; width: 100%; margin-top: 1%;\\\"> <!-- Body -->\\n            <tr style=\\\"border-bottom: 1px solid;font-size: 15px\\\">\\n                <th>C&oacute;digo<\\/th>\\n                <th style=\\\"width: 25%;\\\">Detalle<\\/th>\\n                <th>Cantidad<\\/th>\\n                <th>U.Medida<\\/th>\\n                <th>Precio U.<\\/th>\\n                <th>Bonif. (%)<\\/th>\\n                <th>Precio Bonif.<\\/th>\\n                <th>Subtotal<\\/th>\\n                            <\\/tr>\\n            <tbody>\\n                                                                                <tr style=\\\"font-size: 12px;\\\">\\n                        <td>\\n                            \\n                        <\\/td>\\n                        <td>\\n                            Honorarios profesionales Julio 2021\\n                        <\\/td>\\n                        <td>\\n                            1.00\\n                        <\\/td>\\n                        <td>\\n                            Unidades\\n                        <\\/td>\\n                        <td>                            1.700,00\\n                                                    <\\/td>\\n                        <td>\\n                            0,00%\\n                        <\\/td>\\n                        <td>\\n                            0,00\\n                        <\\/td>\\n                        <td>\\n                            1.700,00\\n                        <\\/td>\\n                                            <\\/tr>\\n                    \\n            <\\/tbody>\\n        <\\/table>\\n        <\\/div>\\n\\n        \\n\\n        <div style=\\\"height:200px;margin-top: 1%;\\\"> <!-- Totales -->\\n              <!-- Es factura B o C -->\\n                <table class=\\\"table-totales\\\" cellspacing=\\\"0\\\" width=\\\"100%\\\">\\n                    <tr>\\n                        <th style=\\\"width:50%; text-align:left;\\\">\\n\\n<!--                                <span style=\\\"width:100%;\\\"><img src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/barcodes\\/71304902477354.png\\\"><\\/span>\\n                                <span style=\\\"text-align:center;\\\">2737718350411000471304902477354202107252<\\/span>-->\\n                        <\\/th>\\n                        <th class=\\\"subtotales_conceptos\\\">TOTAL:<\\/th>\\n                        <th class=\\\"subtotales_importes\\\">$ 1.700,00<\\/th>\\n                    <\\/tr>\\n                <\\/table>\\n                <br>\\n                <table cellspacing=\\\"0\\\" width=\\\"100%\\\" style=\\\"border: none\\\">\\n                    <tr>\\n                        <th style=\\\"width:50%; text-align:left;\\\">\\n\\n                            <?xml version=\\\"1.0\\\" encoding=\\\"UTF-8\\\"?>\\n<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" version=\\\"1.1\\\" width=\\\"100\\\" height=\\\"100\\\" viewBox=\\\"0 0 100 100\\\"><rect x=\\\"0\\\" y=\\\"0\\\" width=\\\"100\\\" height=\\\"100\\\" fill=\\\"#ffffff\\\"\\/><g transform=\\\"scale(1.754)\\\"><g transform=\\\"translate(0,0)\\\"><path fill-rule=\\\"evenodd\\\" d=\\\"M8 0L8 1L9 1L9 0ZM12 0L12 1L13 1L13 0ZM14 0L14 2L13 2L13 4L12 4L12 2L11 2L11 1L10 1L10 2L11 2L11 3L9 3L9 2L8 2L8 5L9 5L9 4L10 4L10 5L11 5L11 6L10 6L10 7L9 7L9 6L8 6L8 7L9 7L9 8L8 8L8 9L9 9L9 13L8 13L8 10L6 10L6 9L7 9L7 8L6 8L6 9L5 9L5 10L4 10L4 11L5 11L5 12L3 12L3 13L8 13L8 14L6 14L6 15L8 15L8 14L9 14L9 13L10 13L10 16L8 16L8 18L5 18L5 17L7 17L7 16L5 16L5 17L4 17L4 15L5 15L5 14L2 14L2 15L3 15L3 16L2 16L2 17L4 17L4 18L3 18L3 19L2 19L2 18L1 18L1 19L0 19L0 20L1 20L1 19L2 19L2 21L1 21L1 24L0 24L0 25L1 25L1 24L3 24L3 23L2 23L2 22L4 22L4 25L2 25L2 27L1 27L1 26L0 26L0 27L1 27L1 28L4 28L4 29L1 29L1 30L2 30L2 31L0 31L0 32L2 32L2 33L0 33L0 34L1 34L1 35L0 35L0 36L1 36L1 37L3 37L3 38L4 38L4 37L3 37L3 36L4 36L4 35L3 35L3 34L4 34L4 33L7 33L7 34L5 34L5 35L7 35L7 34L11 34L11 36L10 36L10 35L9 35L9 38L8 38L8 39L9 39L9 40L3 40L3 44L4 44L4 42L5 42L5 43L7 43L7 42L9 42L9 43L8 43L8 45L9 45L9 46L10 46L10 48L11 48L11 49L13 49L13 50L14 50L14 49L13 49L13 48L14 48L14 47L12 47L12 48L11 48L11 45L12 45L12 46L14 46L14 45L15 45L15 46L16 46L16 49L15 49L15 51L13 51L13 52L10 52L10 51L11 51L11 50L9 50L9 48L8 48L8 46L5 46L5 47L3 47L3 45L2 45L2 44L1 44L1 45L0 45L0 48L5 48L5 47L7 47L7 48L6 48L6 49L8 49L8 50L9 50L9 53L8 53L8 57L9 57L9 55L12 55L12 56L13 56L13 57L14 57L14 56L15 56L15 55L14 55L14 56L13 56L13 55L12 55L12 54L10 54L10 53L13 53L13 54L15 54L15 53L16 53L16 54L17 54L17 55L18 55L18 56L17 56L17 57L18 57L18 56L19 56L19 57L21 57L21 55L22 55L22 53L21 53L21 55L20 55L20 51L21 51L21 52L23 52L23 50L24 50L24 53L25 53L25 54L23 54L23 56L22 56L22 57L24 57L24 56L26 56L26 55L25 55L25 54L27 54L27 53L31 53L31 54L33 54L33 55L32 55L32 56L34 56L34 57L36 57L36 55L38 55L38 56L37 56L37 57L44 57L44 56L43 56L43 55L42 55L42 56L41 56L41 55L40 55L40 54L42 54L42 53L40 53L40 52L43 52L43 53L45 53L45 52L46 52L46 51L45 51L45 49L47 49L47 48L48 48L48 50L47 50L47 53L46 53L46 54L44 54L44 55L45 55L45 56L46 56L46 57L48 57L48 56L49 56L49 55L50 55L50 57L51 57L51 55L50 55L50 53L51 53L51 54L52 54L52 53L55 53L55 54L56 54L56 53L57 53L57 51L56 51L56 49L57 49L57 48L56 48L56 49L55 49L55 51L53 51L53 49L54 49L54 48L53 48L53 46L54 46L54 45L56 45L56 46L55 46L55 47L57 47L57 44L53 44L53 46L52 46L52 43L51 43L51 44L50 44L50 42L51 42L51 41L50 41L50 40L51 40L51 39L52 39L52 38L51 38L51 37L49 37L49 38L48 38L48 39L47 39L47 40L46 40L46 38L45 38L45 37L46 37L46 36L48 36L48 35L49 35L49 34L48 34L48 33L50 33L50 36L51 36L51 35L52 35L52 37L54 37L54 38L53 38L53 39L54 39L54 41L53 41L53 40L52 40L52 42L54 42L54 43L55 43L55 42L57 42L57 40L56 40L56 38L57 38L57 31L56 31L56 30L57 30L57 27L56 27L56 24L57 24L57 21L56 21L56 20L53 20L53 19L54 19L54 18L55 18L55 14L54 14L54 10L53 10L53 9L55 9L55 10L56 10L56 11L55 11L55 12L57 12L57 8L56 8L56 9L55 9L55 8L52 8L52 10L51 10L51 11L50 11L50 10L49 10L49 9L50 9L50 8L48 8L48 7L49 7L49 6L48 6L48 7L47 7L47 5L48 5L48 0L45 0L45 1L43 1L43 0L39 0L39 1L41 1L41 4L40 4L40 5L39 5L39 2L38 2L38 1L37 1L37 2L36 2L36 1L32 1L32 2L31 2L31 0L30 0L30 1L29 1L29 0L28 0L28 1L26 1L26 0L24 0L24 1L23 1L23 0L22 0L22 1L23 1L23 2L22 2L22 3L21 3L21 4L20 4L20 5L21 5L21 4L22 4L22 10L21 10L21 11L20 11L20 12L19 12L19 10L20 10L20 9L21 9L21 8L20 8L20 7L21 7L21 6L20 6L20 7L19 7L19 6L18 6L18 7L17 7L17 6L16 6L16 7L15 7L15 6L14 6L14 5L13 5L13 4L14 4L14 3L15 3L15 5L17 5L17 4L16 4L16 3L17 3L17 2L18 2L18 1L17 1L17 2L15 2L15 1L16 1L16 0ZM19 1L19 2L21 2L21 1ZM25 1L25 2L23 2L23 3L22 3L22 4L23 4L23 3L24 3L24 5L23 5L23 10L22 10L22 13L23 13L23 14L24 14L24 16L23 16L23 15L22 15L22 14L20 14L20 13L19 13L19 12L18 12L18 10L19 10L19 9L20 9L20 8L18 8L18 9L17 9L17 8L15 8L15 7L14 7L14 6L13 6L13 5L12 5L12 6L11 6L11 7L10 7L10 8L9 8L9 9L13 9L13 10L12 10L12 12L11 12L11 11L10 11L10 13L12 13L12 15L11 15L11 16L10 16L10 17L9 17L9 18L8 18L8 19L9 19L9 21L8 21L8 20L7 20L7 19L6 19L6 20L5 20L5 21L6 21L6 22L7 22L7 21L8 21L8 23L5 23L5 25L4 25L4 26L3 26L3 27L4 27L4 26L7 26L7 25L10 25L10 24L8 24L8 23L9 23L9 21L10 21L10 20L12 20L12 19L9 19L9 18L12 18L12 17L13 17L13 18L14 18L14 15L15 15L15 16L16 16L16 14L17 14L17 16L18 16L18 17L17 17L17 18L15 18L15 19L13 19L13 22L10 22L10 23L14 23L14 24L16 24L16 23L18 23L18 22L19 22L19 23L20 23L20 24L19 24L19 25L18 25L18 26L17 26L17 25L16 25L16 26L15 26L15 25L14 25L14 28L15 28L15 30L13 30L13 32L12 32L12 33L11 33L11 31L12 31L12 30L10 30L10 29L13 29L13 28L11 28L11 26L9 26L9 30L10 30L10 32L8 32L8 33L11 33L11 34L12 34L12 35L13 35L13 36L12 36L12 37L11 37L11 38L10 38L10 39L11 39L11 40L9 40L9 41L10 41L10 43L15 43L15 45L16 45L16 46L18 46L18 47L17 47L17 48L18 48L18 47L20 47L20 48L19 48L19 50L17 50L17 49L16 49L16 53L17 53L17 51L20 51L20 48L22 48L22 49L23 49L23 48L22 48L22 47L24 47L24 46L22 46L22 44L21 44L21 41L22 41L22 43L24 43L24 44L23 44L23 45L25 45L25 46L27 46L27 44L28 44L28 47L26 47L26 48L24 48L24 50L25 50L25 49L26 49L26 48L28 48L28 47L29 47L29 48L30 48L30 47L32 47L32 50L31 50L31 51L32 51L32 50L33 50L33 51L35 51L35 52L36 52L36 53L35 53L35 55L34 55L34 56L35 56L35 55L36 55L36 53L37 53L37 54L38 54L38 55L39 55L39 56L40 56L40 55L39 55L39 53L37 53L37 51L38 51L38 52L40 52L40 50L41 50L41 51L42 51L42 50L43 50L43 51L44 51L44 49L45 49L45 48L46 48L46 46L47 46L47 45L48 45L48 44L49 44L49 42L50 42L50 41L49 41L49 42L47 42L47 43L46 43L46 44L45 44L45 42L46 42L46 40L45 40L45 42L43 42L43 41L42 41L42 38L44 38L44 39L45 39L45 38L44 38L44 37L45 37L45 36L46 36L46 34L47 34L47 33L48 33L48 31L46 31L46 32L45 32L45 31L44 31L44 32L43 32L43 29L44 29L44 30L45 30L45 29L44 29L44 27L46 27L46 29L47 29L47 30L48 30L48 27L47 27L47 24L48 24L48 26L50 26L50 25L51 25L51 23L52 23L52 25L53 25L53 27L55 27L55 29L54 29L54 28L53 28L53 29L54 29L54 32L53 32L53 31L52 31L52 34L54 34L54 32L55 32L55 35L54 35L54 37L55 37L55 38L54 38L54 39L55 39L55 38L56 38L56 36L55 36L55 35L56 35L56 32L55 32L55 30L56 30L56 27L55 27L55 23L54 23L54 22L51 22L51 21L52 21L52 20L51 20L51 19L53 19L53 17L54 17L54 14L52 14L52 13L53 13L53 10L52 10L52 11L51 11L51 12L52 12L52 13L51 13L51 15L49 15L49 17L47 17L47 16L46 16L46 15L47 15L47 13L48 13L48 14L50 14L50 12L49 12L49 10L48 10L48 8L47 8L47 9L46 9L46 10L48 10L48 11L46 11L46 12L47 12L47 13L46 13L46 14L45 14L45 12L44 12L44 13L43 13L43 12L42 12L42 13L41 13L41 9L44 9L44 10L43 10L43 11L45 11L45 7L46 7L46 5L47 5L47 3L46 3L46 2L47 2L47 1L45 1L45 3L44 3L44 5L43 5L43 4L41 4L41 7L42 7L42 8L41 8L41 9L39 9L39 8L38 8L38 9L37 9L37 8L35 8L35 7L36 7L36 6L37 6L37 7L38 7L38 6L37 6L37 5L38 5L38 3L37 3L37 5L35 5L35 4L34 4L34 5L33 5L33 7L32 7L32 4L33 4L33 3L34 3L34 2L33 2L33 3L31 3L31 8L32 8L32 9L31 9L31 10L33 10L33 11L34 11L34 10L35 10L35 13L34 13L34 14L32 14L32 15L33 15L33 17L30 17L30 18L28 18L28 19L27 19L27 17L29 17L29 16L30 16L30 15L29 15L29 13L30 13L30 14L31 14L31 13L33 13L33 12L31 12L31 11L26 11L26 12L25 12L25 11L24 11L24 8L25 8L25 10L27 10L27 9L26 9L26 8L25 8L25 7L26 7L26 6L25 6L25 5L26 5L26 4L25 4L25 2L26 2L26 3L28 3L28 4L30 4L30 3L29 3L29 2L26 2L26 1ZM18 3L18 5L19 5L19 3ZM45 3L45 5L46 5L46 3ZM27 5L27 8L30 8L30 5ZM42 5L42 7L43 7L43 8L44 8L44 7L45 7L45 6L44 6L44 7L43 7L43 5ZM12 6L12 7L11 7L11 8L13 8L13 9L14 9L14 11L15 11L15 13L13 13L13 12L12 12L12 13L13 13L13 15L14 15L14 14L15 14L15 13L17 13L17 14L18 14L18 12L17 12L17 11L16 11L16 10L15 10L15 9L14 9L14 7L13 7L13 6ZM24 6L24 7L25 7L25 6ZM28 6L28 7L29 7L29 6ZM34 6L34 7L35 7L35 6ZM39 6L39 7L40 7L40 6ZM0 8L0 11L1 11L1 9L4 9L4 8ZM28 9L28 10L30 10L30 9ZM36 9L36 13L35 13L35 15L39 15L39 16L38 16L38 17L37 17L37 19L36 19L36 18L35 18L35 17L36 17L36 16L35 16L35 17L33 17L33 18L31 18L31 19L35 19L35 20L37 20L37 22L36 22L36 21L35 21L35 22L32 22L32 20L30 20L30 19L28 19L28 20L27 20L27 19L25 19L25 18L24 18L24 19L22 19L22 18L21 18L21 19L20 19L20 16L19 16L19 17L18 17L18 19L16 19L16 20L14 20L14 21L15 21L15 23L16 23L16 21L17 21L17 22L18 22L18 21L17 21L17 20L18 20L18 19L20 19L20 21L19 21L19 22L20 22L20 21L21 21L21 19L22 19L22 23L25 23L25 25L26 25L26 29L25 29L25 27L24 27L24 26L23 26L23 25L22 25L22 24L20 24L20 25L19 25L19 27L17 27L17 28L16 28L16 27L15 27L15 28L16 28L16 30L15 30L15 31L17 31L17 32L18 32L18 28L19 28L19 30L20 30L20 28L19 28L19 27L22 27L22 28L23 28L23 30L22 30L22 29L21 29L21 30L22 30L22 31L20 31L20 33L21 33L21 32L22 32L22 35L26 35L26 36L25 36L25 37L27 37L27 35L28 35L28 37L29 37L29 39L30 39L30 38L31 38L31 40L27 40L27 42L29 42L29 41L30 41L30 44L29 44L29 43L28 43L28 44L29 44L29 45L30 45L30 46L31 46L31 45L32 45L32 47L33 47L33 46L34 46L34 48L33 48L33 50L34 50L34 48L35 48L35 47L36 47L36 49L35 49L35 51L36 51L36 49L37 49L37 48L38 48L38 45L37 45L37 47L36 47L36 45L35 45L35 46L34 46L34 45L32 45L32 43L31 43L31 41L33 41L33 43L35 43L35 44L37 44L37 42L38 42L38 44L39 44L39 47L40 47L40 45L41 45L41 48L42 48L42 49L43 49L43 48L45 48L45 45L44 45L44 44L43 44L43 43L42 43L42 45L41 45L41 43L40 43L40 44L39 44L39 42L38 42L38 41L37 41L37 42L36 42L36 40L35 40L35 39L38 39L38 40L39 40L39 41L40 41L40 42L42 42L42 41L40 41L40 39L41 39L41 37L40 37L40 36L39 36L39 37L37 37L37 36L38 36L38 34L37 34L37 35L36 35L36 34L33 34L33 33L35 33L35 32L37 32L37 33L38 33L38 32L40 32L40 33L39 33L39 34L42 34L42 35L41 35L41 36L45 36L45 34L46 34L46 33L47 33L47 32L46 32L46 33L44 33L44 35L43 35L43 32L42 32L42 33L41 33L41 31L40 31L40 30L41 30L41 29L43 29L43 27L42 27L42 28L41 28L41 26L40 26L40 25L39 25L39 24L40 24L40 23L41 23L41 25L42 25L42 24L43 24L43 25L44 25L44 26L45 26L45 25L46 25L46 24L47 24L47 23L48 23L48 22L49 22L49 20L50 20L50 21L51 21L51 20L50 20L50 19L51 19L51 18L52 18L52 17L51 17L51 16L50 16L50 17L49 17L49 20L48 20L48 18L47 18L47 17L46 17L46 16L45 16L45 15L44 15L44 14L42 14L42 15L41 15L41 13L40 13L40 10L39 10L39 13L38 13L38 12L37 12L37 9ZM2 10L2 11L3 11L3 10ZM5 10L5 11L6 11L6 12L7 12L7 11L6 11L6 10ZM1 12L1 13L0 13L0 15L1 15L1 13L2 13L2 12ZM23 12L23 13L24 13L24 12ZM26 12L26 14L25 14L25 16L24 16L24 17L25 17L25 16L26 16L26 15L27 15L27 12ZM36 13L36 14L38 14L38 13ZM39 13L39 15L40 15L40 13ZM19 14L19 15L20 15L20 14ZM28 15L28 16L29 16L29 15ZM42 15L42 16L39 16L39 17L38 17L38 18L41 18L41 17L42 17L42 18L43 18L43 22L44 22L44 23L45 23L45 24L44 24L44 25L45 25L45 24L46 24L46 23L45 23L45 22L44 22L44 21L46 21L46 22L48 22L48 21L47 21L47 20L45 20L45 19L46 19L46 17L44 17L44 18L43 18L43 17L42 17L42 16L43 16L43 15ZM52 15L52 16L53 16L53 15ZM11 16L11 17L12 17L12 16ZM56 16L56 18L57 18L57 16ZM50 17L50 18L51 18L51 17ZM24 19L24 20L25 20L25 19ZM37 19L37 20L38 20L38 19ZM39 19L39 20L40 20L40 19ZM41 19L41 20L42 20L42 19ZM6 20L6 21L7 21L7 20ZM29 20L29 21L28 21L28 22L27 22L27 21L25 21L25 23L26 23L26 24L28 24L28 26L31 26L31 27L33 27L33 28L34 28L34 29L35 29L35 31L36 31L36 29L37 29L37 30L39 30L39 29L41 29L41 28L38 28L38 29L37 29L37 27L38 27L38 24L39 24L39 23L38 23L38 24L37 24L37 26L35 26L35 25L36 25L36 23L35 23L35 25L34 25L34 23L33 23L33 24L32 24L32 22L31 22L31 23L30 23L30 20ZM33 20L33 21L34 21L34 20ZM23 21L23 22L24 22L24 21ZM38 21L38 22L40 22L40 21ZM55 21L55 22L56 22L56 21ZM26 22L26 23L27 23L27 22ZM49 23L49 25L50 25L50 23ZM6 24L6 25L7 25L7 24ZM11 24L11 25L12 25L12 27L13 27L13 25L12 25L12 24ZM31 24L31 26L34 26L34 25L32 25L32 24ZM39 26L39 27L40 27L40 26ZM5 27L5 30L8 30L8 27ZM27 27L27 30L30 30L30 27ZM49 27L49 30L52 30L52 27ZM6 28L6 29L7 29L7 28ZM28 28L28 29L29 29L29 28ZM31 28L31 29L32 29L32 28ZM35 28L35 29L36 29L36 28ZM50 28L50 29L51 29L51 28ZM24 29L24 32L25 32L25 34L26 34L26 35L27 35L27 34L30 34L30 35L29 35L29 36L30 36L30 35L31 35L31 38L33 38L33 36L32 36L32 34L31 34L31 33L33 33L33 32L34 32L34 30L33 30L33 31L32 31L32 30L31 30L31 33L30 33L30 31L26 31L26 32L25 32L25 29ZM3 30L3 31L2 31L2 32L3 32L3 33L4 33L4 30ZM6 31L6 32L7 32L7 31ZM22 31L22 32L23 32L23 31ZM37 31L37 32L38 32L38 31ZM50 31L50 33L51 33L51 31ZM13 32L13 33L14 33L14 35L15 35L15 36L14 36L14 37L12 37L12 38L14 38L14 39L12 39L12 42L13 42L13 41L14 41L14 39L15 39L15 38L17 38L17 39L16 39L16 40L15 40L15 42L16 42L16 43L17 43L17 45L18 45L18 46L19 46L19 44L20 44L20 45L21 45L21 44L20 44L20 43L18 43L18 42L20 42L20 41L18 41L18 42L17 42L17 41L16 41L16 40L17 40L17 39L18 39L18 40L20 40L20 38L21 38L21 37L22 37L22 38L24 38L24 36L23 36L23 37L22 37L22 36L21 36L21 34L19 34L19 35L20 35L20 38L19 38L19 36L18 36L18 38L17 38L17 37L16 37L16 36L17 36L17 35L18 35L18 34L17 34L17 35L16 35L16 34L15 34L15 32ZM26 32L26 33L27 33L27 32ZM23 33L23 34L24 34L24 33ZM1 35L1 36L3 36L3 35ZM6 36L6 37L5 37L5 38L6 38L6 39L7 39L7 38L6 38L6 37L8 37L8 36ZM34 36L34 39L33 39L33 40L34 40L34 39L35 39L35 38L36 38L36 37L35 37L35 36ZM39 37L39 38L38 38L38 39L40 39L40 37ZM18 38L18 39L19 39L19 38ZM26 38L26 39L28 39L28 38ZM50 38L50 39L51 39L51 38ZM0 39L0 41L1 41L1 42L0 42L0 43L2 43L2 41L1 41L1 40L2 40L2 39ZM21 39L21 40L22 40L22 39ZM24 39L24 40L23 40L23 42L24 42L24 41L25 41L25 44L26 44L26 41L25 41L25 39ZM55 40L55 41L54 41L54 42L55 42L55 41L56 41L56 40ZM6 41L6 42L7 42L7 41ZM6 44L6 45L7 45L7 44ZM9 44L9 45L11 45L11 44ZM13 44L13 45L14 45L14 44ZM30 44L30 45L31 45L31 44ZM1 45L1 47L2 47L2 45ZM43 45L43 47L42 47L42 48L43 48L43 47L44 47L44 45ZM49 45L49 48L50 48L50 46L51 46L51 45ZM20 46L20 47L21 47L21 46ZM51 47L51 48L52 48L52 47ZM39 48L39 49L38 49L38 51L39 51L39 50L40 50L40 48ZM27 49L27 52L30 52L30 49ZM49 49L49 52L52 52L52 49ZM21 50L21 51L22 51L22 50ZM28 50L28 51L29 51L29 50ZM50 50L50 51L51 51L51 50ZM25 51L25 52L26 52L26 51ZM55 51L55 53L56 53L56 51ZM14 52L14 53L15 53L15 52ZM18 52L18 53L19 53L19 52ZM31 52L31 53L32 53L32 52ZM33 52L33 54L34 54L34 52ZM18 54L18 55L19 55L19 54ZM47 54L47 55L48 55L48 54ZM53 54L53 56L52 56L52 57L55 57L55 56L54 56L54 54ZM27 55L27 57L31 57L31 56L30 56L30 55L29 55L29 56L28 56L28 55ZM56 55L56 56L57 56L57 55ZM0 0L0 7L7 7L7 0ZM1 1L1 6L6 6L6 1ZM2 2L2 5L5 5L5 2ZM50 0L50 7L57 7L57 0ZM51 1L51 6L56 6L56 1ZM52 2L52 5L55 5L55 2ZM0 50L0 57L7 57L7 50ZM1 51L1 56L6 56L6 51ZM2 52L2 55L5 55L5 52Z\\\" fill=\\\"#000000\\\"\\/><\\/g><\\/g><\\/svg>\\n\\n                            <span style=\\\"width:50%;\\\">\\n                                <img style=\\\"max-height: 70px\\\"\\n                                     src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/img\\/AfipComprobanteAutorizado.png\\\">\\n                            <\\/span>\\n                        <\\/th>\\n                        <th style=\\\"text-align:right;\\\">\\n                            <p>CAE N&#186;: 71304902477354<br>\\n                                Fecha Vto. CAE:  25\\/07\\/2021\\n                            <\\/p>\\n                        <\\/th>\\n                    <\\/tr>\\n                <\\/table>\\n                    <\\/div>\\n    <\\/div>\\n\\n    <\\/body>\\n<\\/html>\\\";s:4:\\\"file\\\";N;}s:6:\\\"locale\\\";N;s:4:\\\"from\\\";a:0:{}s:2:\\\"to\\\";a:1:{i:0;a:2:{s:4:\\\"name\\\";N;s:7:\\\"address\\\";s:18:\\\"vitufler@gmail.com\\\";}}s:2:\\\"cc\\\";a:0:{}s:3:\\\"bcc\\\";a:1:{i:0;a:2:{s:4:\\\"name\\\";N;s:7:\\\"address\\\";s:23:\\\"info@masquecontable.com\\\";}}s:7:\\\"replyTo\\\";a:0:{}s:7:\\\"subject\\\";N;s:11:\\\"\\u0000*\\u0000markdown\\\";N;s:7:\\\"\\u0000*\\u0000html\\\";N;s:4:\\\"view\\\";N;s:8:\\\"textView\\\";N;s:8:\\\"viewData\\\";a:0:{}s:11:\\\"attachments\\\";a:0:{}s:14:\\\"rawAttachments\\\";a:0:{}s:15:\\\"diskAttachments\\\";a:0:{}s:9:\\\"callbacks\\\";a:0:{}s:5:\\\"theme\\\";N;s:6:\\\"mailer\\\";s:8:\\\"sendgrid\\\";s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:5:\\\"delay\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;}\"}}','ErrorException: Trying to get property \'id\' of non-object in /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php:16\nStack trace:\n#0 /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php(16): Illuminate\\Foundation\\Bootstrap\\HandleExceptions->handleError(8, \'Trying to get p...\', \'/home/forge/tax...\', 16, Array)\n#1 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(356): App\\Queue\\DatabaseJob->fire()\n#2 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(306): Illuminate\\Queue\\Worker->process(\'database\', Object(App\\Queue\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#3 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(132): Illuminate\\Queue\\Worker->runJob(Object(App\\Queue\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#4 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(112): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#5 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(96): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#6 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#7 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#8 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#9 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#10 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#11 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(134): Illuminate\\Container\\Container->call(Array)\n#12 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(256): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#13 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(121): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#14 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(971): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#15 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(290): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#16 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(166): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#17 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Application.php(93): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(129): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#19 /home/forge/taxes.com.ar/artisan(35): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#20 {main}','2021-07-23 18:04:00',NULL);
INSERT INTO `failed_jobs` VALUES (10,NULL,'database','default','{\"uuid\":\"1843ed9f-6ff0-4044-9a3d-31b7121ed5a3\",\"displayName\":\"App\\\\Mail\\\\Fact_Electronica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"delay\":null,\"timeout\":null,\"timeoutAt\":null,\"data\":{\"commandName\":\"Illuminate\\\\Mail\\\\SendQueuedMailable\",\"command\":\"O:34:\\\"Illuminate\\\\Mail\\\\SendQueuedMailable\\\":3:{s:8:\\\"mailable\\\";O:25:\\\"App\\\\Mail\\\\Fact_Electronica\\\":27:{s:11:\\\"informacion\\\";a:6:{s:12:\\\"ruta_logo_fa\\\";N;s:4:\\\"mail\\\";s:23:\\\"info@masquecontable.com\\\";s:18:\\\"name_quien_factura\\\";s:19:\\\"MICAELA AILIN CORIA\\\";s:7:\\\"cliente\\\";O:17:\\\"App\\\\Models\\\\Person\\\":27:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:7:\\\"persons\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:40738;s:7:\\\"user_id\\\";i:5115;s:11:\\\"field_name1\\\";s:20:\\\"GARCIA CAMILA AYELEN\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-39101206-2\\\";s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-07-05 18:52:25\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-07-05 18:52:25\\\";s:11:\\\"activity_id\\\";i:1;s:7:\\\"address\\\";s:98:\\\"Direccion\\r\\nCORONEL MOLDES 5225\\r\\nCod. Postal\\r\\n1765\\r\\nProvincia\\r\\nBUENOS AIRES\\r\\nTipo Domicilio\\r\\nFISCAL\\\";s:14:\\\"person_type_id\\\";i:1;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:40738;s:7:\\\"user_id\\\";i:5115;s:11:\\\"field_name1\\\";s:20:\\\"GARCIA CAMILA AYELEN\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-39101206-2\\\";s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-07-05 18:52:25\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-07-05 18:52:25\\\";s:11:\\\"activity_id\\\";i:1;s:7:\\\"address\\\";s:98:\\\"Direccion\\r\\nCORONEL MOLDES 5225\\r\\nCod. Postal\\r\\n1765\\r\\nProvincia\\r\\nBUENOS AIRES\\r\\nTipo Domicilio\\r\\nFISCAL\\\";s:14:\\\"person_type_id\\\";i:1;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}s:14:\\\"nombre_del_pdf\\\";s:28:\\\"Factura N\\u00b00004-00000013.pdf\\\";s:9:\\\"body_mail\\\";s:155:\\\"Estimado cliente, se env\\u00eda adjunta la factura de honorarios correspondientes al mes de Julio 2021.\\nMuchas gracias por seguir eligiendo nuestros servicios.\\\";}s:3:\\\"pdf\\\";O:26:\\\"Barryvdh\\\\Snappy\\\\PdfWrapper\\\":4:{s:9:\\\"\\u0000*\\u0000snappy\\\";O:35:\\\"Barryvdh\\\\Snappy\\\\IlluminateSnappyPdf\\\":10:{s:26:\\\"\\u0000*\\u0000optionsWithContentCheck\\\";a:4:{s:11:\\\"header-html\\\";s:4:\\\"html\\\";s:11:\\\"footer-html\\\";s:4:\\\"html\\\";s:5:\\\"cover\\\";s:4:\\\"html\\\";s:15:\\\"xsl-style-sheet\\\";s:3:\\\"xsl\\\";}s:36:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000binary\\\";s:76:\\\"\\/home\\/forge\\/taxes.com.ar\\/vendor\\/h4cc\\/wkhtmltopdf-amd64\\/bin\\/wkhtmltopdf-amd64\\\";s:37:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000options\\\";a:132:{s:7:\\\"collate\\\";N;s:10:\\\"no-collate\\\";N;s:10:\\\"cookie-jar\\\";N;s:6:\\\"copies\\\";i:1;s:3:\\\"dpi\\\";N;s:13:\\\"extended-help\\\";N;s:9:\\\"grayscale\\\";N;s:4:\\\"help\\\";N;s:7:\\\"htmldoc\\\";N;s:18:\\\"ignore-load-errors\\\";N;s:9:\\\"image-dpi\\\";N;s:13:\\\"image-quality\\\";N;s:7:\\\"license\\\";N;s:9:\\\"log-level\\\";N;s:10:\\\"lowquality\\\";b:1;s:7:\\\"manpage\\\";N;s:13:\\\"margin-bottom\\\";N;s:11:\\\"margin-left\\\";N;s:12:\\\"margin-right\\\";N;s:10:\\\"margin-top\\\";N;s:11:\\\"orientation\\\";N;s:11:\\\"page-height\\\";N;s:9:\\\"page-size\\\";s:2:\\\"a4\\\";s:10:\\\"page-width\\\";N;s:18:\\\"no-pdf-compression\\\";N;s:5:\\\"quiet\\\";N;s:20:\\\"read-args-from-stdin\\\";N;s:6:\\\"readme\\\";N;s:5:\\\"title\\\";N;s:11:\\\"use-xserver\\\";N;s:7:\\\"version\\\";N;s:20:\\\"dump-default-toc-xsl\\\";N;s:12:\\\"dump-outline\\\";N;s:7:\\\"outline\\\";N;s:10:\\\"no-outline\\\";N;s:13:\\\"outline-depth\\\";N;s:13:\\\"output-format\\\";N;s:5:\\\"allow\\\";N;s:10:\\\"background\\\";N;s:13:\\\"no-background\\\";N;s:16:\\\"bypass-proxy-for\\\";N;s:9:\\\"cache-dir\\\";N;s:20:\\\"checkbox-checked-svg\\\";N;s:12:\\\"checkbox-svg\\\";N;s:6:\\\"cookie\\\";N;s:13:\\\"custom-header\\\";N;s:25:\\\"custom-header-propagation\\\";N;s:28:\\\"no-custom-header-propagation\\\";N;s:16:\\\"debug-javascript\\\";N;s:19:\\\"no-debug-javascript\\\";N;s:14:\\\"default-header\\\";N;s:8:\\\"encoding\\\";N;s:22:\\\"disable-external-links\\\";N;s:21:\\\"enable-external-links\\\";N;s:13:\\\"disable-forms\\\";N;s:12:\\\"enable-forms\\\";N;s:6:\\\"images\\\";N;s:9:\\\"no-images\\\";N;s:22:\\\"disable-internal-links\\\";N;s:21:\\\"enable-internal-links\\\";N;s:18:\\\"disable-javascript\\\";N;s:17:\\\"enable-javascript\\\";N;s:16:\\\"javascript-delay\\\";N;s:19:\\\"keep-relative-links\\\";N;s:19:\\\"load-error-handling\\\";N;s:25:\\\"load-media-error-handling\\\";N;s:25:\\\"disable-local-file-access\\\";N;s:24:\\\"enable-local-file-access\\\";N;s:17:\\\"minimum-font-size\\\";N;s:20:\\\"exclude-from-outline\\\";N;s:18:\\\"include-in-outline\\\";N;s:11:\\\"page-offset\\\";N;s:8:\\\"password\\\";N;s:15:\\\"disable-plugins\\\";N;s:14:\\\"enable-plugins\\\";N;s:4:\\\"post\\\";N;s:9:\\\"post-file\\\";N;s:16:\\\"print-media-type\\\";N;s:19:\\\"no-print-media-type\\\";N;s:5:\\\"proxy\\\";N;s:21:\\\"proxy-hostname-lookup\\\";N;s:23:\\\"radiobutton-checked-svg\\\";N;s:15:\\\"radiobutton-svg\\\";N;s:14:\\\"redirect-delay\\\";N;s:22:\\\"resolve-relative-links\\\";N;s:10:\\\"run-script\\\";N;s:23:\\\"disable-smart-shrinking\\\";N;s:22:\\\"enable-smart-shrinking\\\";N;s:12:\\\"ssl-crt-path\\\";N;s:16:\\\"ssl-key-password\\\";N;s:12:\\\"ssl-key-path\\\";N;s:17:\\\"stop-slow-scripts\\\";N;s:20:\\\"no-stop-slow-scripts\\\";N;s:22:\\\"disable-toc-back-links\\\";N;s:21:\\\"enable-toc-back-links\\\";N;s:16:\\\"user-style-sheet\\\";N;s:8:\\\"username\\\";N;s:13:\\\"viewport-size\\\";N;s:13:\\\"window-status\\\";N;s:4:\\\"zoom\\\";N;s:13:\\\"footer-center\\\";s:25:\\\"Pagina [page] de [toPage]\\\";s:16:\\\"footer-font-name\\\";N;s:16:\\\"footer-font-size\\\";i:8;s:11:\\\"footer-html\\\";N;s:11:\\\"footer-left\\\";s:0:\\\"\\\";s:11:\\\"footer-line\\\";N;s:14:\\\"no-footer-line\\\";N;s:12:\\\"footer-right\\\";N;s:14:\\\"footer-spacing\\\";N;s:13:\\\"header-center\\\";N;s:16:\\\"header-font-name\\\";N;s:16:\\\"header-font-size\\\";N;s:11:\\\"header-html\\\";N;s:11:\\\"header-left\\\";N;s:11:\\\"header-line\\\";N;s:14:\\\"no-header-line\\\";N;s:12:\\\"header-right\\\";N;s:14:\\\"header-spacing\\\";N;s:7:\\\"replace\\\";N;s:5:\\\"cover\\\";N;s:3:\\\"toc\\\";N;s:20:\\\"disable-dotted-lines\\\";N;s:9:\\\"toc-depth\\\";N;s:13:\\\"toc-font-name\\\";N;s:16:\\\"toc-l1-font-size\\\";N;s:15:\\\"toc-header-text\\\";N;s:20:\\\"toc-header-font-name\\\";N;s:20:\\\"toc-header-font-size\\\";N;s:21:\\\"toc-level-indentation\\\";N;s:17:\\\"disable-toc-links\\\";N;s:20:\\\"toc-text-size-shrink\\\";N;s:15:\\\"xsl-style-sheet\\\";N;}s:33:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000env\\\";N;s:37:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000timeout\\\";b:0;s:46:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000defaultExtension\\\";s:3:\\\"pdf\\\";s:18:\\\"\\u0000*\\u0000temporaryFolder\\\";N;s:14:\\\"temporaryFiles\\\";a:0:{}s:36:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000logger\\\";O:18:\\\"Psr\\\\Log\\\\NullLogger\\\":0:{}s:2:\\\"fs\\\";O:32:\\\"Illuminate\\\\Filesystem\\\\Filesystem\\\":0:{}}s:10:\\\"\\u0000*\\u0000options\\\";a:0:{}s:4:\\\"html\\\";s:22834:\\\"<!DOCTYPE html>\\n<html lang=\\\"en\\\">\\n    <head>\\n        <meta charset=\\\"utf-8\\\">\\n    <\\/head>\\n    <style>\\n        .subtotales_conceptos{\\n            width:30%;\\n            text-align: right;\\n        }\\n        .subtotales_importes{\\n            text-align: right;\\n        }\\n        .table-totales, .table-totales tr, .table-totales th{\\n            border: 1px solid;\\n        }\\n\\n    <\\/style>\\n    <body>\\n    <div style=\\\"max-height:840px\\\">\\n        <div style=\\\"width: 100%; height:270px\\\"> <!-- Datos de la empresa -->\\n            <table class=\\\"display\\\" cellspacing=\\\"0\\\" width=\\\"100%\\\" style=\\\"border:  1px solid;\\\">\\n                <tr style=\\\"\\\">\\n                    <th colspan=\\\"2\\\" rowspan=\\\"2\\\" style=\\\"width:45%;margin:0;height:150px;\\\">\\n                                                <img src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/img\\/\\/27377183504\\/logo_punto_venta_0000.png\\\"\\/>\\n                                            <\\/th>\\n                    <th style=\\\"border:  1px solid;text-align: center; width:10%\\\" colspan=\\\"2\\\">\\n                        <span style=\\\"font-size: 60px;\\\">C<\\/span> <br \\/> <span style=\\\"font-size: 14px;\\\">cod. 11<\\/span>\\n                    <\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"font-size: 28px;text-align: center;width:45%\\\">\\n                        Factura\\n                        <br>\\n                        0004 - 00000013\\n                    <\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th><\\/th>\\n                    <th style=\\\"border:  1px 1px 1px 0px solid;\\\" colspan=\\\"2\\\"><\\/th>\\n                    <th><\\/th>\\n                <\\/tr>\\n                <tr>\\n\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                                                    Raz&oacute;n Social:\\n                            <span style=\\\"font-weight: normal;\\\">MICAELA AILIN CORIA<\\/span>\\n                                            <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">Fecha de Emisi&oacute;n: <span style=\\\"font-weight: normal;\\\">15\\/07\\/2021<\\/span><\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Domicilio Comercial: <span style=\\\"font-weight: normal;\\\">Victor Guillet esq. Arturo M Bas, C.P.:5800,\\n                        C\\u00f3rdoba<\\/span>\\n                    <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">CUIT: <span style=\\\"font-weight: normal;\\\">27-37718350-4<\\/span><\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Condici&oacute;n frente al IVA: <span style=\\\"font-weight: normal;\\\">Monotributo<\\/span>\\n                    <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Ingresos Brutos: <span style=\\\"font-weight: normal;\\\"><\\/span>\\n                        <br>\\n                        Fecha de Inicio de Actividades: <span style=\\\"font-weight: normal;\\\">09\\/07\\/2021<\\/span>\\n                    <\\/th>\\n                <\\/tr>\\n            <\\/table>\\n        <\\/div>\\n\\n        <table style=\\\"text-align: center; width: 100%;border: solid 1px;\\\"> <!-- Fechas -->\\n            <thead>\\n                <tr>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Per\\u00edodo Facturado Desde: 01\\/07\\/2021<\\/small><\\/th>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Per\\u00edodo Facturado Hasta: 31\\/07\\/2021<\\/small><\\/th>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Fecha Vto. Pago: 15\\/07\\/2021<\\/small><\\/th>\\n                <\\/tr>\\n            <\\/thead>\\n        <\\/table>\\n        \\n        <table style=\\\"width: 100%; margin-top: 1%;border: solid 1px;\\\"> <!-- Datos Clientes -->\\n            <tr>\\n                <th style=\\\"text-align:left;\\\"colspan=\\\"12\\\">\\n                    CUIT: <span style=\\\"font-weight: normal;\\\">27-39101206-2<\\/span>\\n                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\\n                    Apellido y Nombre \\/ Raz&oacute;n Social: <span style=\\\"font-weight: normal;\\\">\\n                    GARCIA CAMILA AYELEN<\\/span>\\n                <\\/th>\\n            <\\/tr>\\n            <tr>\\n                <th style=\\\"text-align:left; width:50%\\\">\\n                    Condici&oacute;n Frente al IVA: <span style=\\\"font-weight: normal;\\\">Responsable Monotributo<\\/span>\\n                <\\/th>\\n                <th style=\\\"text-align:left; width:50%\\\" colspan=\\\"4\\\">\\n                    Domicilio Comercial:\\n                    <span style=\\\"font-weight: normal;\\\">\\n                    Direccion\\r\\nCORONEL MOLDES 5225\\r\\nCod. Postal\\r\\n1765\\r\\nProvincia\\r\\nBUENOS AIRES\\r\\nTipo Domicilio\\r\\nFISCAL\\n                    <\\/span>\\n                <\\/th>\\n            <\\/tr>\\n            <tr style=\\\"text-align:left\\\">\\n                <th>Condici&oacute;n de Venta: <span style=\\\"font-weight: normal;\\\">Cuenta Corriente<\\/span><\\/th>\\n            <\\/tr>\\n        <\\/table>\\n\\n        <div style=\\\"border: 1px solid;margin-top: 1%;min-height:600px;\\\">\\n        <table style=\\\"text-align: center; width: 100%; margin-top: 1%;\\\"> <!-- Body -->\\n            <tr style=\\\"border-bottom: 1px solid;font-size: 15px\\\">\\n                <th>C&oacute;digo<\\/th>\\n                <th style=\\\"width: 25%;\\\">Detalle<\\/th>\\n                <th>Cantidad<\\/th>\\n                <th>U.Medida<\\/th>\\n                <th>Precio U.<\\/th>\\n                <th>Bonif. (%)<\\/th>\\n                <th>Precio Bonif.<\\/th>\\n                <th>Subtotal<\\/th>\\n                            <\\/tr>\\n            <tbody>\\n                                                                                <tr style=\\\"font-size: 12px;\\\">\\n                        <td>\\n                            \\n                        <\\/td>\\n                        <td>\\n                            Honorarios profesionales Julio 2021\\n                        <\\/td>\\n                        <td>\\n                            1.00\\n                        <\\/td>\\n                        <td>\\n                            Unidades\\n                        <\\/td>\\n                        <td>                            2.950,00\\n                                                    <\\/td>\\n                        <td>\\n                            0,00%\\n                        <\\/td>\\n                        <td>\\n                            0,00\\n                        <\\/td>\\n                        <td>\\n                            2.950,00\\n                        <\\/td>\\n                                            <\\/tr>\\n                    \\n            <\\/tbody>\\n        <\\/table>\\n        <\\/div>\\n\\n        \\n\\n        <div style=\\\"height:200px;margin-top: 1%;\\\"> <!-- Totales -->\\n              <!-- Es factura B o C -->\\n                <table class=\\\"table-totales\\\" cellspacing=\\\"0\\\" width=\\\"100%\\\">\\n                    <tr>\\n                        <th style=\\\"width:50%; text-align:left;\\\">\\n\\n<!--                                <span style=\\\"width:100%;\\\"><img src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/barcodes\\/71304902479254.png\\\"><\\/span>\\n                                <span style=\\\"text-align:center;\\\">2737718350411000471304902479254202107253<\\/span>-->\\n                        <\\/th>\\n                        <th class=\\\"subtotales_conceptos\\\">TOTAL:<\\/th>\\n                        <th class=\\\"subtotales_importes\\\">$ 2.950,00<\\/th>\\n                    <\\/tr>\\n                <\\/table>\\n                <br>\\n                <table cellspacing=\\\"0\\\" width=\\\"100%\\\" style=\\\"border: none\\\">\\n                    <tr>\\n                        <th style=\\\"width:50%; text-align:left;\\\">\\n\\n                            <?xml version=\\\"1.0\\\" encoding=\\\"UTF-8\\\"?>\\n<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" version=\\\"1.1\\\" width=\\\"100\\\" height=\\\"100\\\" viewBox=\\\"0 0 100 100\\\"><rect x=\\\"0\\\" y=\\\"0\\\" width=\\\"100\\\" height=\\\"100\\\" fill=\\\"#ffffff\\\"\\/><g transform=\\\"scale(1.754)\\\"><g transform=\\\"translate(0,0)\\\"><path fill-rule=\\\"evenodd\\\" d=\\\"M9 0L9 1L8 1L8 2L9 2L9 3L8 3L8 4L9 4L9 5L8 5L8 7L9 7L9 6L10 6L10 7L11 7L11 6L12 6L12 7L13 7L13 8L12 8L12 9L11 9L11 8L6 8L6 9L7 9L7 10L6 10L6 11L5 11L5 12L4 12L4 13L2 13L2 12L0 12L0 13L2 13L2 14L1 14L1 15L3 15L3 16L4 16L4 17L3 17L3 19L4 19L4 20L1 20L1 19L0 19L0 21L1 21L1 22L0 22L0 26L2 26L2 27L1 27L1 29L0 29L0 30L1 30L1 29L2 29L2 28L4 28L4 30L3 30L3 31L1 31L1 32L0 32L0 34L3 34L3 35L5 35L5 36L6 36L6 37L8 37L8 35L9 35L9 33L7 33L7 32L6 32L6 33L5 33L5 32L3 32L3 31L8 31L8 32L9 32L9 30L10 30L10 31L11 31L11 30L10 30L10 29L9 29L9 28L11 28L11 29L12 29L12 31L15 31L15 33L17 33L17 32L16 32L16 31L18 31L18 33L22 33L22 34L21 34L21 35L20 35L20 34L18 34L18 37L16 37L16 36L15 36L15 34L13 34L13 32L10 32L10 33L12 33L12 34L10 34L10 35L12 35L12 36L9 36L9 37L12 37L12 38L10 38L10 39L9 39L9 40L8 40L8 41L7 41L7 40L6 40L6 41L5 41L5 38L4 38L4 37L3 37L3 36L1 36L1 35L0 35L0 36L1 36L1 38L2 38L2 39L0 39L0 41L2 41L2 42L0 42L0 45L1 45L1 46L0 46L0 48L5 48L5 47L7 47L7 48L6 48L6 49L8 49L8 51L9 51L9 52L8 52L8 57L11 57L11 56L10 56L10 55L13 55L13 54L16 54L16 53L13 53L13 52L16 52L16 51L17 51L17 52L18 52L18 53L17 53L17 56L16 56L16 55L15 55L15 57L19 57L19 56L20 56L20 57L22 57L22 54L23 54L23 55L25 55L25 56L23 56L23 57L26 57L26 56L27 56L27 55L25 55L25 53L26 53L26 54L29 54L29 53L30 53L30 54L31 54L31 52L33 52L33 53L32 53L32 54L33 54L33 55L35 55L35 54L34 54L34 53L35 53L35 51L37 51L37 52L36 52L36 53L37 53L37 54L36 54L36 56L35 56L35 57L37 57L37 55L38 55L38 51L40 51L40 52L41 52L41 54L44 54L44 56L45 56L45 57L46 57L46 56L47 56L47 54L48 54L48 55L49 55L49 54L48 54L48 53L52 53L52 54L53 54L53 55L54 55L54 56L53 56L53 57L54 57L54 56L55 56L55 57L56 57L56 56L55 56L55 55L54 55L54 54L55 54L55 53L54 53L54 54L53 54L53 52L55 52L55 50L57 50L57 48L56 48L56 46L57 46L57 43L56 43L56 46L54 46L54 44L55 44L55 41L54 41L54 40L56 40L56 39L55 39L55 38L54 38L54 36L55 36L55 35L53 35L53 34L52 34L52 33L53 33L53 32L52 32L52 33L50 33L50 34L52 34L52 35L47 35L47 34L48 34L48 33L47 33L47 34L46 34L46 32L45 32L45 31L47 31L47 32L48 32L48 31L49 31L49 32L51 32L51 31L54 31L54 32L55 32L55 33L54 33L54 34L55 34L55 33L56 33L56 34L57 34L57 32L56 32L56 30L57 30L57 29L54 29L54 28L55 28L55 26L57 26L57 25L56 25L56 24L57 24L57 23L56 23L56 22L57 22L57 21L56 21L56 22L55 22L55 21L54 21L54 20L55 20L55 19L54 19L54 16L55 16L55 15L56 15L56 14L57 14L57 13L56 13L56 14L55 14L55 13L54 13L54 12L55 12L55 10L57 10L57 9L56 9L56 8L55 8L55 10L54 10L54 11L51 11L51 10L49 10L49 9L50 9L50 8L49 8L49 6L48 6L48 8L49 8L49 9L48 9L48 12L49 12L49 11L50 11L50 13L51 13L51 14L50 14L50 15L52 15L52 16L51 16L51 17L52 17L52 16L53 16L53 19L52 19L52 18L49 18L49 17L48 17L48 18L49 18L49 19L47 19L47 18L46 18L46 17L45 17L45 18L46 18L46 20L45 20L45 19L44 19L44 20L43 20L43 21L42 21L42 19L43 19L43 17L44 17L44 16L45 16L45 15L46 15L46 16L49 16L49 15L48 15L48 14L49 14L49 13L48 13L48 14L45 14L45 13L47 13L47 10L46 10L46 9L45 9L45 10L44 10L44 8L45 8L45 6L46 6L46 8L47 8L47 5L48 5L48 0L45 0L45 2L44 2L44 1L43 1L43 0L39 0L39 1L36 1L36 2L35 2L35 1L34 1L34 2L32 2L32 3L33 3L33 4L37 4L37 3L36 3L36 2L38 2L38 4L39 4L39 5L38 5L38 7L37 7L37 5L36 5L36 7L37 7L37 8L36 8L36 10L33 10L33 11L32 11L32 10L31 10L31 6L32 6L32 8L33 8L33 9L35 9L35 8L34 8L34 7L35 7L35 5L31 5L31 3L30 3L30 2L29 2L29 0L28 0L28 2L27 2L27 3L25 3L25 2L24 2L24 3L23 3L23 4L22 4L22 1L23 1L23 0L22 0L22 1L21 1L21 6L20 6L20 5L18 5L18 4L19 4L19 3L20 3L20 1L18 1L18 4L16 4L16 3L15 3L15 2L16 2L16 0L14 0L14 1L15 1L15 2L14 2L14 3L13 3L13 4L11 4L11 5L10 5L10 4L9 4L9 3L11 3L11 2L9 2L9 1L10 1L10 0ZM11 0L11 1L13 1L13 0ZM24 0L24 1L26 1L26 0ZM30 0L30 1L31 1L31 0ZM40 1L40 2L42 2L42 3L44 3L44 4L45 4L45 5L44 5L44 6L43 6L43 5L39 5L39 7L38 7L38 8L37 8L37 10L36 10L36 11L33 11L33 12L32 12L32 11L31 11L31 10L30 10L30 9L28 9L28 10L27 10L27 9L25 9L25 8L22 8L22 9L20 9L20 10L19 10L19 9L15 9L15 8L16 8L16 6L15 6L15 5L16 5L16 4L15 4L15 3L14 3L14 4L13 4L13 5L12 5L12 6L13 6L13 7L14 7L14 6L15 6L15 8L13 8L13 11L14 11L14 12L13 12L13 13L12 13L12 14L11 14L11 12L10 12L10 15L9 15L9 11L8 11L8 10L9 10L9 9L8 9L8 10L7 10L7 11L6 11L6 12L5 12L5 13L4 13L4 14L3 14L3 15L4 15L4 14L5 14L5 13L6 13L6 14L7 14L7 15L6 15L6 16L7 16L7 17L5 17L5 18L4 18L4 19L5 19L5 20L4 20L4 21L3 21L3 22L1 22L1 24L2 24L2 25L3 25L3 24L4 24L4 25L5 25L5 26L7 26L7 25L8 25L8 26L9 26L9 27L11 27L11 26L12 26L12 24L11 24L11 23L12 23L12 22L11 22L11 21L10 21L10 20L11 20L11 19L12 19L12 21L13 21L13 24L15 24L15 23L16 23L16 24L17 24L17 21L18 21L18 24L19 24L19 25L20 25L20 26L19 26L19 28L22 28L22 29L19 29L19 30L18 30L18 31L19 31L19 32L22 32L22 33L23 33L23 36L22 36L22 37L23 37L23 39L22 39L22 41L20 41L20 40L21 40L21 37L20 37L20 36L19 36L19 37L18 37L18 38L19 38L19 39L20 39L20 40L19 40L19 41L17 41L17 40L18 40L18 39L17 39L17 40L16 40L16 39L14 39L14 40L15 40L15 41L14 41L14 42L15 42L15 43L13 43L13 39L12 39L12 41L11 41L11 40L10 40L10 41L9 41L9 42L7 42L7 41L6 41L6 42L7 42L7 43L6 43L6 44L5 44L5 41L3 41L3 39L2 39L2 41L3 41L3 42L2 42L2 43L1 43L1 44L3 44L3 45L2 45L2 46L1 46L1 47L2 47L2 46L3 46L3 47L5 47L5 46L4 46L4 44L5 44L5 45L6 45L6 46L7 46L7 47L10 47L10 50L9 50L9 51L11 51L11 54L13 54L13 53L12 53L12 51L11 51L11 50L13 50L13 51L14 51L14 50L13 50L13 49L14 49L14 46L15 46L15 47L16 47L16 48L15 48L15 51L16 51L16 50L17 50L17 51L18 51L18 50L22 50L22 51L23 51L23 52L22 52L22 53L18 53L18 56L19 56L19 54L20 54L20 56L21 56L21 54L22 54L22 53L23 53L23 54L24 54L24 53L25 53L25 52L26 52L26 50L24 50L24 49L26 49L26 48L27 48L27 47L28 47L28 48L32 48L32 49L33 49L33 50L36 50L36 48L37 48L37 50L40 50L40 51L43 51L43 50L45 50L45 48L44 48L44 47L45 47L45 46L47 46L47 47L46 47L46 48L47 48L47 49L46 49L46 50L47 50L47 49L48 49L48 48L49 48L49 47L52 47L52 48L54 48L54 49L56 49L56 48L54 48L54 47L52 47L52 46L53 46L53 45L52 45L52 44L53 44L53 43L54 43L54 42L53 42L53 41L52 41L52 42L50 42L50 43L51 43L51 45L50 45L50 44L47 44L47 43L45 43L45 42L44 42L44 41L45 41L45 40L44 40L44 41L43 41L43 40L42 40L42 39L46 39L46 40L47 40L47 41L46 41L46 42L48 42L48 43L49 43L49 42L48 42L48 41L49 41L49 40L47 40L47 39L53 39L53 40L54 40L54 39L53 39L53 37L52 37L52 36L53 36L53 35L52 35L52 36L49 36L49 37L50 37L50 38L48 38L48 36L47 36L47 35L46 35L46 38L45 38L45 36L44 36L44 35L45 35L45 34L44 34L44 33L45 33L45 32L44 32L44 33L43 33L43 32L40 32L40 31L43 31L43 30L48 30L48 29L47 29L47 28L48 28L48 27L46 27L46 28L44 28L44 27L45 27L45 24L44 24L44 23L43 23L43 22L44 22L44 21L45 21L45 20L44 20L44 21L43 21L43 22L41 22L41 23L42 23L42 25L43 25L43 26L44 26L44 27L43 27L43 28L42 28L42 26L41 26L41 24L40 24L40 21L41 21L41 20L39 20L39 19L37 19L37 18L39 18L39 15L38 15L38 14L39 14L39 12L40 12L40 13L41 13L41 12L40 12L40 11L42 11L42 13L43 13L43 14L40 14L40 15L42 15L42 17L43 17L43 15L45 15L45 14L44 14L44 13L45 13L45 12L46 12L46 10L45 10L45 12L44 12L44 10L41 10L41 9L42 9L42 6L43 6L43 7L44 7L44 6L45 6L45 5L47 5L47 3L46 3L46 4L45 4L45 3L44 3L44 2L43 2L43 1ZM46 1L46 2L47 2L47 1ZM34 2L34 3L35 3L35 2ZM24 3L24 4L23 4L23 5L22 5L22 6L21 6L21 7L22 7L22 6L23 6L23 7L24 7L24 4L25 4L25 7L26 7L26 4L25 4L25 3ZM28 3L28 4L30 4L30 3ZM39 3L39 4L41 4L41 3ZM14 4L14 5L15 5L15 4ZM17 5L17 8L19 8L19 7L20 7L20 6L19 6L19 7L18 7L18 5ZM27 5L27 8L30 8L30 5ZM28 6L28 7L29 7L29 6ZM33 6L33 7L34 7L34 6ZM40 6L40 8L41 8L41 6ZM0 8L0 9L5 9L5 8ZM51 8L51 9L52 9L52 10L53 10L53 9L54 9L54 8L53 8L53 9L52 9L52 8ZM14 9L14 10L15 10L15 9ZM22 9L22 10L23 10L23 11L22 11L22 12L21 12L21 10L20 10L20 11L19 11L19 13L18 13L18 12L15 12L15 15L14 15L14 16L15 16L15 15L16 15L16 17L17 17L17 15L16 15L16 13L18 13L18 15L19 15L19 13L22 13L22 14L21 14L21 15L22 15L22 14L23 14L23 17L22 17L22 16L18 16L18 17L21 17L21 20L19 20L19 19L20 19L20 18L18 18L18 21L19 21L19 22L20 22L20 23L21 23L21 24L20 24L20 25L22 25L22 26L20 26L20 27L23 27L23 28L25 28L25 27L26 27L26 30L25 30L25 29L22 29L22 31L24 31L24 32L23 32L23 33L24 33L24 34L25 34L25 35L24 35L24 36L23 36L23 37L24 37L24 40L25 40L25 39L27 39L27 38L28 38L28 39L31 39L31 42L30 42L30 43L26 43L26 42L25 42L25 41L22 41L22 42L21 42L21 43L19 43L19 45L18 45L18 44L16 44L16 43L18 43L18 42L16 42L16 43L15 43L15 46L16 46L16 47L17 47L17 46L16 46L16 45L18 45L18 47L19 47L19 45L22 45L22 46L21 46L21 48L20 48L20 49L22 49L22 50L23 50L23 49L24 49L24 46L25 46L25 47L26 47L26 46L25 46L25 45L26 45L26 44L28 44L28 45L27 45L27 46L28 46L28 45L30 45L30 46L29 46L29 47L31 47L31 44L33 44L33 45L32 45L32 46L33 46L33 49L34 49L34 47L35 47L35 46L36 46L36 47L39 47L39 49L40 49L40 48L42 48L42 49L41 49L41 50L43 50L43 47L39 47L39 46L40 46L40 45L39 45L39 46L38 46L38 44L36 44L36 45L35 45L35 44L34 44L34 43L37 43L37 40L36 40L36 41L35 41L35 39L36 39L36 37L37 37L37 38L38 38L38 37L37 37L37 36L36 36L36 35L39 35L39 39L38 39L38 41L39 41L39 42L38 42L38 43L39 43L39 44L42 44L42 43L39 43L39 42L40 42L40 41L39 41L39 40L40 40L40 38L43 38L43 37L40 37L40 36L42 36L42 34L43 34L43 33L40 33L40 32L39 32L39 34L36 34L36 35L35 35L35 34L34 34L34 35L35 35L35 38L34 38L34 41L35 41L35 42L33 42L33 43L31 43L31 42L32 42L32 40L33 40L33 37L34 37L34 36L33 36L33 35L31 35L31 34L33 34L33 33L32 33L32 32L35 32L35 30L34 30L34 31L33 31L33 29L32 29L32 32L31 32L31 34L30 34L30 35L31 35L31 36L28 36L28 35L29 35L29 34L28 34L28 35L27 35L27 34L25 34L25 33L29 33L29 32L30 32L30 31L31 31L31 28L33 28L33 27L35 27L35 26L33 26L33 27L32 27L32 24L34 24L34 25L35 25L35 24L34 24L34 23L35 23L35 22L36 22L36 21L37 21L37 23L38 23L38 21L39 21L39 20L38 20L38 21L37 21L37 20L36 20L36 21L35 21L35 20L34 20L34 19L36 19L36 18L37 18L37 16L36 16L36 18L32 18L32 16L33 16L33 17L34 17L34 16L33 16L33 15L36 15L36 14L37 14L37 13L38 13L38 11L39 11L39 10L38 10L38 11L37 11L37 12L36 12L36 14L33 14L33 15L30 15L30 14L32 14L32 13L30 13L30 14L28 14L28 13L27 13L27 12L29 12L29 10L28 10L28 11L27 11L27 12L26 12L26 13L27 13L27 14L26 14L26 15L25 15L25 13L24 13L24 12L25 12L25 11L26 11L26 10L25 10L25 9L24 9L24 10L23 10L23 9ZM0 10L0 11L1 11L1 10ZM2 10L2 11L4 11L4 10ZM10 10L10 11L12 11L12 10ZM17 10L17 11L18 11L18 10ZM24 10L24 11L23 11L23 12L22 12L22 13L23 13L23 12L24 12L24 11L25 11L25 10ZM30 11L30 12L31 12L31 11ZM56 11L56 12L57 12L57 11ZM6 12L6 13L8 13L8 12ZM33 12L33 13L35 13L35 12ZM43 12L43 13L44 13L44 12ZM52 12L52 13L53 13L53 16L54 16L54 15L55 15L55 14L54 14L54 13L53 13L53 12ZM13 13L13 14L12 14L12 15L10 15L10 16L9 16L9 15L7 15L7 16L8 16L8 17L7 17L7 18L6 18L6 19L7 19L7 20L6 20L6 21L4 21L4 22L3 22L3 23L2 23L2 24L3 24L3 23L4 23L4 24L5 24L5 22L6 22L6 23L8 23L8 25L9 25L9 22L8 22L8 20L9 20L9 19L10 19L10 18L9 18L9 17L12 17L12 18L13 18L13 19L14 19L14 20L13 20L13 21L15 21L15 22L14 22L14 23L15 23L15 22L16 22L16 21L15 21L15 20L17 20L17 19L15 19L15 17L13 17L13 16L12 16L12 15L13 15L13 14L14 14L14 13ZM24 15L24 17L23 17L23 18L22 18L22 19L23 19L23 20L22 20L22 21L20 21L20 22L22 22L22 21L23 21L23 24L22 24L22 25L25 25L25 26L29 26L29 25L31 25L31 24L30 24L30 23L34 23L34 22L35 22L35 21L34 21L34 20L32 20L32 19L31 19L31 18L29 18L29 17L31 17L31 16L30 16L30 15L29 15L29 16L28 16L28 15L26 15L26 16L25 16L25 15ZM0 16L0 18L2 18L2 17L1 17L1 16ZM26 16L26 17L24 17L24 20L23 20L23 21L24 21L24 22L25 22L25 21L24 21L24 20L26 20L26 21L27 21L27 24L25 24L25 23L24 23L24 24L25 24L25 25L28 25L28 24L29 24L29 23L30 23L30 22L32 22L32 21L30 21L30 22L29 22L29 23L28 23L28 21L27 21L27 20L29 20L29 19L28 19L28 18L27 18L27 20L26 20L26 19L25 19L25 18L26 18L26 17L28 17L28 16ZM40 16L40 17L41 17L41 16ZM55 17L55 18L57 18L57 17ZM8 18L8 19L9 19L9 18ZM30 19L30 20L31 20L31 19ZM51 19L51 20L52 20L52 21L53 21L53 20L52 20L52 19ZM56 19L56 20L57 20L57 19ZM48 20L48 21L46 21L46 22L45 22L45 23L46 23L46 24L47 24L47 23L46 23L46 22L48 22L48 21L49 21L49 24L48 24L48 25L46 25L46 26L48 26L48 25L49 25L49 26L52 26L52 25L55 25L55 24L56 24L56 23L55 23L55 22L54 22L54 23L53 23L53 22L52 22L52 23L50 23L50 22L51 22L51 21L49 21L49 20ZM6 21L6 22L7 22L7 21ZM52 23L52 24L51 24L51 25L52 25L52 24L53 24L53 23ZM54 23L54 24L55 24L55 23ZM6 24L6 25L7 25L7 24ZM10 24L10 26L11 26L11 24ZM36 24L36 25L37 25L37 24ZM38 24L38 25L39 25L39 24ZM43 24L43 25L44 25L44 24ZM49 24L49 25L50 25L50 24ZM15 25L15 26L17 26L17 27L16 27L16 28L17 28L17 29L16 29L16 30L17 30L17 29L18 29L18 28L17 28L17 27L18 27L18 25ZM3 26L3 27L4 27L4 26ZM36 26L36 27L37 27L37 28L36 28L36 29L37 29L37 30L36 30L36 31L40 31L40 30L38 30L38 29L40 29L40 28L41 28L41 27L40 27L40 26ZM53 26L53 27L54 27L54 26ZM5 27L5 30L8 30L8 27ZM27 27L27 30L30 30L30 27ZM49 27L49 30L52 30L52 27ZM56 27L56 28L57 28L57 27ZM6 28L6 29L7 29L7 28ZM28 28L28 29L29 29L29 28ZM50 28L50 29L51 29L51 28ZM42 29L42 30L43 30L43 29ZM24 30L24 31L25 31L25 30ZM54 30L54 31L55 31L55 30ZM28 31L28 32L29 32L29 31ZM24 32L24 33L25 33L25 32ZM36 32L36 33L37 33L37 32ZM6 33L6 34L5 34L5 35L6 35L6 36L7 36L7 35L8 35L8 34L7 34L7 33ZM6 34L6 35L7 35L7 34ZM40 34L40 35L41 35L41 34ZM56 35L56 37L57 37L57 35ZM12 36L12 37L14 37L14 38L16 38L16 37L14 37L14 36ZM24 36L24 37L25 37L25 38L26 38L26 37L25 37L25 36ZM27 36L27 37L28 37L28 38L31 38L31 39L32 39L32 37L33 37L33 36L31 36L31 37L28 37L28 36ZM51 37L51 38L52 38L52 37ZM6 38L6 39L8 39L8 38ZM46 38L46 39L47 39L47 38ZM26 40L26 41L27 41L27 40ZM28 40L28 41L29 41L29 40ZM41 40L41 42L43 42L43 41L42 41L42 40ZM10 41L10 43L7 43L7 44L6 44L6 45L7 45L7 44L8 44L8 46L9 46L9 45L10 45L10 44L11 44L11 41ZM56 41L56 42L57 42L57 41ZM22 42L22 43L23 43L23 44L22 44L22 45L24 45L24 43L25 43L25 42ZM30 43L30 44L31 44L31 43ZM44 43L44 44L45 44L45 45L44 45L44 46L45 46L45 45L47 45L47 46L49 46L49 45L47 45L47 44L45 44L45 43ZM12 44L12 45L11 45L11 46L12 46L12 45L13 45L13 46L14 46L14 44ZM34 45L34 46L35 46L35 45ZM36 45L36 46L37 46L37 45ZM41 45L41 46L43 46L43 45ZM51 45L51 46L52 46L52 45ZM22 46L22 49L23 49L23 46ZM12 47L12 48L11 48L11 49L13 49L13 47ZM47 47L47 48L48 48L48 47ZM16 48L16 49L19 49L19 48ZM27 49L27 52L30 52L30 49ZM49 49L49 52L52 52L52 49ZM28 50L28 51L29 51L29 50ZM50 50L50 51L51 51L51 50ZM53 50L53 51L54 51L54 50ZM20 51L20 52L21 52L21 51ZM24 51L24 52L23 52L23 53L24 53L24 52L25 52L25 51ZM46 51L46 54L47 54L47 53L48 53L48 52L47 52L47 51ZM56 51L56 52L57 52L57 51ZM44 52L44 54L45 54L45 52ZM9 53L9 54L10 54L10 53ZM39 54L39 56L38 56L38 57L39 57L39 56L41 56L41 57L42 57L42 55L40 55L40 54ZM50 54L50 55L51 55L51 56L48 56L48 57L52 57L52 55L51 55L51 54ZM30 55L30 56L29 56L29 57L30 57L30 56L31 56L31 57L32 57L32 56L31 56L31 55ZM45 55L45 56L46 56L46 55ZM12 56L12 57L13 57L13 56ZM33 56L33 57L34 57L34 56ZM0 0L0 7L7 7L7 0ZM1 1L1 6L6 6L6 1ZM2 2L2 5L5 5L5 2ZM50 0L50 7L57 7L57 0ZM51 1L51 6L56 6L56 1ZM52 2L52 5L55 5L55 2ZM0 50L0 57L7 57L7 50ZM1 51L1 56L6 56L6 51ZM2 52L2 55L5 55L5 52Z\\\" fill=\\\"#000000\\\"\\/><\\/g><\\/g><\\/svg>\\n\\n                            <span style=\\\"width:50%;\\\">\\n                                <img style=\\\"max-height: 70px\\\"\\n                                     src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/img\\/AfipComprobanteAutorizado.png\\\">\\n                            <\\/span>\\n                        <\\/th>\\n                        <th style=\\\"text-align:right;\\\">\\n                            <p>CAE N&#186;: 71304902479254<br>\\n                                Fecha Vto. CAE:  25\\/07\\/2021\\n                            <\\/p>\\n                        <\\/th>\\n                    <\\/tr>\\n                <\\/table>\\n                    <\\/div>\\n    <\\/div>\\n\\n    <\\/body>\\n<\\/html>\\\";s:4:\\\"file\\\";N;}s:6:\\\"locale\\\";N;s:4:\\\"from\\\";a:0:{}s:2:\\\"to\\\";a:1:{i:0;a:2:{s:4:\\\"name\\\";N;s:7:\\\"address\\\";s:26:\\\"Garciacamila1909@gmail.com\\\";}}s:2:\\\"cc\\\";a:0:{}s:3:\\\"bcc\\\";a:1:{i:0;a:2:{s:4:\\\"name\\\";N;s:7:\\\"address\\\";s:23:\\\"info@masquecontable.com\\\";}}s:7:\\\"replyTo\\\";a:0:{}s:7:\\\"subject\\\";N;s:11:\\\"\\u0000*\\u0000markdown\\\";N;s:7:\\\"\\u0000*\\u0000html\\\";N;s:4:\\\"view\\\";N;s:8:\\\"textView\\\";N;s:8:\\\"viewData\\\";a:0:{}s:11:\\\"attachments\\\";a:0:{}s:14:\\\"rawAttachments\\\";a:0:{}s:15:\\\"diskAttachments\\\";a:0:{}s:9:\\\"callbacks\\\";a:0:{}s:5:\\\"theme\\\";N;s:6:\\\"mailer\\\";s:8:\\\"sendgrid\\\";s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:5:\\\"delay\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;}\"}}','ErrorException: Trying to get property \'id\' of non-object in /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php:16\nStack trace:\n#0 /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php(16): Illuminate\\Foundation\\Bootstrap\\HandleExceptions->handleError(8, \'Trying to get p...\', \'/home/forge/tax...\', 16, Array)\n#1 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(356): App\\Queue\\DatabaseJob->fire()\n#2 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(306): Illuminate\\Queue\\Worker->process(\'database\', Object(App\\Queue\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#3 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(132): Illuminate\\Queue\\Worker->runJob(Object(App\\Queue\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#4 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(112): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#5 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(96): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#6 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#7 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#8 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#9 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#10 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#11 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(134): Illuminate\\Container\\Container->call(Array)\n#12 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(256): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#13 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(121): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#14 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(971): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#15 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(290): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#16 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(166): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#17 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Application.php(93): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(129): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#19 /home/forge/taxes.com.ar/artisan(35): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#20 {main}','2021-07-23 18:04:00',NULL);
INSERT INTO `failed_jobs` VALUES (11,NULL,'database','default','{\"uuid\":\"b3115ed1-cfac-45a9-81bf-b2540d975b80\",\"displayName\":\"App\\\\Mail\\\\Fact_Electronica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"delay\":null,\"timeout\":null,\"timeoutAt\":null,\"data\":{\"commandName\":\"Illuminate\\\\Mail\\\\SendQueuedMailable\",\"command\":\"O:34:\\\"Illuminate\\\\Mail\\\\SendQueuedMailable\\\":3:{s:8:\\\"mailable\\\";O:25:\\\"App\\\\Mail\\\\Fact_Electronica\\\":27:{s:11:\\\"informacion\\\";a:6:{s:12:\\\"ruta_logo_fa\\\";N;s:4:\\\"mail\\\";s:23:\\\"info@masquecontable.com\\\";s:18:\\\"name_quien_factura\\\";s:19:\\\"MICAELA AILIN CORIA\\\";s:7:\\\"cliente\\\";O:17:\\\"App\\\\Models\\\\Person\\\":27:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:7:\\\"persons\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:40739;s:7:\\\"user_id\\\";i:5117;s:11:\\\"field_name1\\\";s:32:\\\"HEREDIA MARTINEZ FACUNDO ALBERTO\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"20-26597566-7\\\";s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-07-05 18:58:43\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-07-18 20:06:07\\\";s:11:\\\"activity_id\\\";i:1;s:7:\\\"address\\\";s:98:\\\"Direccion\\r\\nROQUE SAENZ PE&#209;A 81\\r\\nCod. Postal\\r\\n5152\\r\\nProvincia\\r\\nCORDOBA\\r\\nTipo Domicilio\\r\\nFISCAL\\\";s:14:\\\"person_type_id\\\";i:1;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:40739;s:7:\\\"user_id\\\";i:5117;s:11:\\\"field_name1\\\";s:32:\\\"HEREDIA MARTINEZ FACUNDO ALBERTO\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"20-26597566-7\\\";s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-07-05 18:58:43\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-07-18 20:06:07\\\";s:11:\\\"activity_id\\\";i:1;s:7:\\\"address\\\";s:98:\\\"Direccion\\r\\nROQUE SAENZ PE&#209;A 81\\r\\nCod. Postal\\r\\n5152\\r\\nProvincia\\r\\nCORDOBA\\r\\nTipo Domicilio\\r\\nFISCAL\\\";s:14:\\\"person_type_id\\\";i:1;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}s:14:\\\"nombre_del_pdf\\\";s:28:\\\"Factura N\\u00b00004-00000014.pdf\\\";s:9:\\\"body_mail\\\";s:155:\\\"Estimado cliente, se env\\u00eda adjunta la factura de honorarios correspondientes al mes de Julio 2021.\\nMuchas gracias por seguir eligiendo nuestros servicios.\\\";}s:3:\\\"pdf\\\";O:26:\\\"Barryvdh\\\\Snappy\\\\PdfWrapper\\\":4:{s:9:\\\"\\u0000*\\u0000snappy\\\";O:35:\\\"Barryvdh\\\\Snappy\\\\IlluminateSnappyPdf\\\":10:{s:26:\\\"\\u0000*\\u0000optionsWithContentCheck\\\";a:4:{s:11:\\\"header-html\\\";s:4:\\\"html\\\";s:11:\\\"footer-html\\\";s:4:\\\"html\\\";s:5:\\\"cover\\\";s:4:\\\"html\\\";s:15:\\\"xsl-style-sheet\\\";s:3:\\\"xsl\\\";}s:36:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000binary\\\";s:76:\\\"\\/home\\/forge\\/taxes.com.ar\\/vendor\\/h4cc\\/wkhtmltopdf-amd64\\/bin\\/wkhtmltopdf-amd64\\\";s:37:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000options\\\";a:132:{s:7:\\\"collate\\\";N;s:10:\\\"no-collate\\\";N;s:10:\\\"cookie-jar\\\";N;s:6:\\\"copies\\\";i:1;s:3:\\\"dpi\\\";N;s:13:\\\"extended-help\\\";N;s:9:\\\"grayscale\\\";N;s:4:\\\"help\\\";N;s:7:\\\"htmldoc\\\";N;s:18:\\\"ignore-load-errors\\\";N;s:9:\\\"image-dpi\\\";N;s:13:\\\"image-quality\\\";N;s:7:\\\"license\\\";N;s:9:\\\"log-level\\\";N;s:10:\\\"lowquality\\\";b:1;s:7:\\\"manpage\\\";N;s:13:\\\"margin-bottom\\\";N;s:11:\\\"margin-left\\\";N;s:12:\\\"margin-right\\\";N;s:10:\\\"margin-top\\\";N;s:11:\\\"orientation\\\";N;s:11:\\\"page-height\\\";N;s:9:\\\"page-size\\\";s:2:\\\"a4\\\";s:10:\\\"page-width\\\";N;s:18:\\\"no-pdf-compression\\\";N;s:5:\\\"quiet\\\";N;s:20:\\\"read-args-from-stdin\\\";N;s:6:\\\"readme\\\";N;s:5:\\\"title\\\";N;s:11:\\\"use-xserver\\\";N;s:7:\\\"version\\\";N;s:20:\\\"dump-default-toc-xsl\\\";N;s:12:\\\"dump-outline\\\";N;s:7:\\\"outline\\\";N;s:10:\\\"no-outline\\\";N;s:13:\\\"outline-depth\\\";N;s:13:\\\"output-format\\\";N;s:5:\\\"allow\\\";N;s:10:\\\"background\\\";N;s:13:\\\"no-background\\\";N;s:16:\\\"bypass-proxy-for\\\";N;s:9:\\\"cache-dir\\\";N;s:20:\\\"checkbox-checked-svg\\\";N;s:12:\\\"checkbox-svg\\\";N;s:6:\\\"cookie\\\";N;s:13:\\\"custom-header\\\";N;s:25:\\\"custom-header-propagation\\\";N;s:28:\\\"no-custom-header-propagation\\\";N;s:16:\\\"debug-javascript\\\";N;s:19:\\\"no-debug-javascript\\\";N;s:14:\\\"default-header\\\";N;s:8:\\\"encoding\\\";N;s:22:\\\"disable-external-links\\\";N;s:21:\\\"enable-external-links\\\";N;s:13:\\\"disable-forms\\\";N;s:12:\\\"enable-forms\\\";N;s:6:\\\"images\\\";N;s:9:\\\"no-images\\\";N;s:22:\\\"disable-internal-links\\\";N;s:21:\\\"enable-internal-links\\\";N;s:18:\\\"disable-javascript\\\";N;s:17:\\\"enable-javascript\\\";N;s:16:\\\"javascript-delay\\\";N;s:19:\\\"keep-relative-links\\\";N;s:19:\\\"load-error-handling\\\";N;s:25:\\\"load-media-error-handling\\\";N;s:25:\\\"disable-local-file-access\\\";N;s:24:\\\"enable-local-file-access\\\";N;s:17:\\\"minimum-font-size\\\";N;s:20:\\\"exclude-from-outline\\\";N;s:18:\\\"include-in-outline\\\";N;s:11:\\\"page-offset\\\";N;s:8:\\\"password\\\";N;s:15:\\\"disable-plugins\\\";N;s:14:\\\"enable-plugins\\\";N;s:4:\\\"post\\\";N;s:9:\\\"post-file\\\";N;s:16:\\\"print-media-type\\\";N;s:19:\\\"no-print-media-type\\\";N;s:5:\\\"proxy\\\";N;s:21:\\\"proxy-hostname-lookup\\\";N;s:23:\\\"radiobutton-checked-svg\\\";N;s:15:\\\"radiobutton-svg\\\";N;s:14:\\\"redirect-delay\\\";N;s:22:\\\"resolve-relative-links\\\";N;s:10:\\\"run-script\\\";N;s:23:\\\"disable-smart-shrinking\\\";N;s:22:\\\"enable-smart-shrinking\\\";N;s:12:\\\"ssl-crt-path\\\";N;s:16:\\\"ssl-key-password\\\";N;s:12:\\\"ssl-key-path\\\";N;s:17:\\\"stop-slow-scripts\\\";N;s:20:\\\"no-stop-slow-scripts\\\";N;s:22:\\\"disable-toc-back-links\\\";N;s:21:\\\"enable-toc-back-links\\\";N;s:16:\\\"user-style-sheet\\\";N;s:8:\\\"username\\\";N;s:13:\\\"viewport-size\\\";N;s:13:\\\"window-status\\\";N;s:4:\\\"zoom\\\";N;s:13:\\\"footer-center\\\";s:25:\\\"Pagina [page] de [toPage]\\\";s:16:\\\"footer-font-name\\\";N;s:16:\\\"footer-font-size\\\";i:8;s:11:\\\"footer-html\\\";N;s:11:\\\"footer-left\\\";s:0:\\\"\\\";s:11:\\\"footer-line\\\";N;s:14:\\\"no-footer-line\\\";N;s:12:\\\"footer-right\\\";N;s:14:\\\"footer-spacing\\\";N;s:13:\\\"header-center\\\";N;s:16:\\\"header-font-name\\\";N;s:16:\\\"header-font-size\\\";N;s:11:\\\"header-html\\\";N;s:11:\\\"header-left\\\";N;s:11:\\\"header-line\\\";N;s:14:\\\"no-header-line\\\";N;s:12:\\\"header-right\\\";N;s:14:\\\"header-spacing\\\";N;s:7:\\\"replace\\\";N;s:5:\\\"cover\\\";N;s:3:\\\"toc\\\";N;s:20:\\\"disable-dotted-lines\\\";N;s:9:\\\"toc-depth\\\";N;s:13:\\\"toc-font-name\\\";N;s:16:\\\"toc-l1-font-size\\\";N;s:15:\\\"toc-header-text\\\";N;s:20:\\\"toc-header-font-name\\\";N;s:20:\\\"toc-header-font-size\\\";N;s:21:\\\"toc-level-indentation\\\";N;s:17:\\\"disable-toc-links\\\";N;s:20:\\\"toc-text-size-shrink\\\";N;s:15:\\\"xsl-style-sheet\\\";N;}s:33:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000env\\\";N;s:37:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000timeout\\\";b:0;s:46:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000defaultExtension\\\";s:3:\\\"pdf\\\";s:18:\\\"\\u0000*\\u0000temporaryFolder\\\";N;s:14:\\\"temporaryFiles\\\";a:0:{}s:36:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000logger\\\";O:18:\\\"Psr\\\\Log\\\\NullLogger\\\":0:{}s:2:\\\"fs\\\";O:32:\\\"Illuminate\\\\Filesystem\\\\Filesystem\\\":0:{}}s:10:\\\"\\u0000*\\u0000options\\\";a:0:{}s:4:\\\"html\\\";s:22175:\\\"<!DOCTYPE html>\\n<html lang=\\\"en\\\">\\n    <head>\\n        <meta charset=\\\"utf-8\\\">\\n    <\\/head>\\n    <style>\\n        .subtotales_conceptos{\\n            width:30%;\\n            text-align: right;\\n        }\\n        .subtotales_importes{\\n            text-align: right;\\n        }\\n        .table-totales, .table-totales tr, .table-totales th{\\n            border: 1px solid;\\n        }\\n\\n    <\\/style>\\n    <body>\\n    <div style=\\\"max-height:840px\\\">\\n        <div style=\\\"width: 100%; height:270px\\\"> <!-- Datos de la empresa -->\\n            <table class=\\\"display\\\" cellspacing=\\\"0\\\" width=\\\"100%\\\" style=\\\"border:  1px solid;\\\">\\n                <tr style=\\\"\\\">\\n                    <th colspan=\\\"2\\\" rowspan=\\\"2\\\" style=\\\"width:45%;margin:0;height:150px;\\\">\\n                                                <img src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/img\\/\\/27377183504\\/logo_punto_venta_0000.png\\\"\\/>\\n                                            <\\/th>\\n                    <th style=\\\"border:  1px solid;text-align: center; width:10%\\\" colspan=\\\"2\\\">\\n                        <span style=\\\"font-size: 60px;\\\">C<\\/span> <br \\/> <span style=\\\"font-size: 14px;\\\">cod. 11<\\/span>\\n                    <\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"font-size: 28px;text-align: center;width:45%\\\">\\n                        Factura\\n                        <br>\\n                        0004 - 00000014\\n                    <\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th><\\/th>\\n                    <th style=\\\"border:  1px 1px 1px 0px solid;\\\" colspan=\\\"2\\\"><\\/th>\\n                    <th><\\/th>\\n                <\\/tr>\\n                <tr>\\n\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                                                    Raz&oacute;n Social:\\n                            <span style=\\\"font-weight: normal;\\\">MICAELA AILIN CORIA<\\/span>\\n                                            <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">Fecha de Emisi&oacute;n: <span style=\\\"font-weight: normal;\\\">15\\/07\\/2021<\\/span><\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Domicilio Comercial: <span style=\\\"font-weight: normal;\\\">Victor Guillet esq. Arturo M Bas, C.P.:5800,\\n                        C\\u00f3rdoba<\\/span>\\n                    <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">CUIT: <span style=\\\"font-weight: normal;\\\">27-37718350-4<\\/span><\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Condici&oacute;n frente al IVA: <span style=\\\"font-weight: normal;\\\">Monotributo<\\/span>\\n                    <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Ingresos Brutos: <span style=\\\"font-weight: normal;\\\"><\\/span>\\n                        <br>\\n                        Fecha de Inicio de Actividades: <span style=\\\"font-weight: normal;\\\">09\\/07\\/2021<\\/span>\\n                    <\\/th>\\n                <\\/tr>\\n            <\\/table>\\n        <\\/div>\\n\\n        <table style=\\\"text-align: center; width: 100%;border: solid 1px;\\\"> <!-- Fechas -->\\n            <thead>\\n                <tr>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Per\\u00edodo Facturado Desde: 01\\/07\\/2021<\\/small><\\/th>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Per\\u00edodo Facturado Hasta: 31\\/07\\/2021<\\/small><\\/th>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Fecha Vto. Pago: 15\\/07\\/2021<\\/small><\\/th>\\n                <\\/tr>\\n            <\\/thead>\\n        <\\/table>\\n        \\n        <table style=\\\"width: 100%; margin-top: 1%;border: solid 1px;\\\"> <!-- Datos Clientes -->\\n            <tr>\\n                <th style=\\\"text-align:left;\\\"colspan=\\\"12\\\">\\n                    CUIT: <span style=\\\"font-weight: normal;\\\">20-26597566-7<\\/span>\\n                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\\n                    Apellido y Nombre \\/ Raz&oacute;n Social: <span style=\\\"font-weight: normal;\\\">\\n                    HEREDIA MARTINEZ FACUNDO ALBERTO<\\/span>\\n                <\\/th>\\n            <\\/tr>\\n            <tr>\\n                <th style=\\\"text-align:left; width:50%\\\">\\n                    Condici&oacute;n Frente al IVA: <span style=\\\"font-weight: normal;\\\">IVA Responsable Inscripto<\\/span>\\n                <\\/th>\\n                <th style=\\\"text-align:left; width:50%\\\" colspan=\\\"4\\\">\\n                    Domicilio Comercial:\\n                    <span style=\\\"font-weight: normal;\\\">\\n                    Direccion\\r\\nROQUE SAENZ PE&amp;#209;A 81\\r\\nCod. Postal\\r\\n5152\\r\\nProvincia\\r\\nCORDOBA\\r\\nTipo Domicilio\\r\\nFISCAL\\n                    <\\/span>\\n                <\\/th>\\n            <\\/tr>\\n            <tr style=\\\"text-align:left\\\">\\n                <th>Condici&oacute;n de Venta: <span style=\\\"font-weight: normal;\\\">Cuenta Corriente<\\/span><\\/th>\\n            <\\/tr>\\n        <\\/table>\\n\\n        <div style=\\\"border: 1px solid;margin-top: 1%;min-height:600px;\\\">\\n        <table style=\\\"text-align: center; width: 100%; margin-top: 1%;\\\"> <!-- Body -->\\n            <tr style=\\\"border-bottom: 1px solid;font-size: 15px\\\">\\n                <th>C&oacute;digo<\\/th>\\n                <th style=\\\"width: 25%;\\\">Detalle<\\/th>\\n                <th>Cantidad<\\/th>\\n                <th>U.Medida<\\/th>\\n                <th>Precio U.<\\/th>\\n                <th>Bonif. (%)<\\/th>\\n                <th>Precio Bonif.<\\/th>\\n                <th>Subtotal<\\/th>\\n                            <\\/tr>\\n            <tbody>\\n                                                                                <tr style=\\\"font-size: 12px;\\\">\\n                        <td>\\n                            \\n                        <\\/td>\\n                        <td>\\n                            Honorarios profesionales Julio 2021\\n                        <\\/td>\\n                        <td>\\n                            1.00\\n                        <\\/td>\\n                        <td>\\n                            Unidades\\n                        <\\/td>\\n                        <td>                            8.625,00\\n                                                    <\\/td>\\n                        <td>\\n                            0,00%\\n                        <\\/td>\\n                        <td>\\n                            0,00\\n                        <\\/td>\\n                        <td>\\n                            8.625,00\\n                        <\\/td>\\n                                            <\\/tr>\\n                    \\n            <\\/tbody>\\n        <\\/table>\\n        <\\/div>\\n\\n        \\n\\n        <div style=\\\"height:200px;margin-top: 1%;\\\"> <!-- Totales -->\\n              <!-- Es factura B o C -->\\n                <table class=\\\"table-totales\\\" cellspacing=\\\"0\\\" width=\\\"100%\\\">\\n                    <tr>\\n                        <th style=\\\"width:50%; text-align:left;\\\">\\n\\n<!--                                <span style=\\\"width:100%;\\\"><img src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/barcodes\\/71304902481149.png\\\"><\\/span>\\n                                <span style=\\\"text-align:center;\\\">2737718350411000471304902481149202107257<\\/span>-->\\n                        <\\/th>\\n                        <th class=\\\"subtotales_conceptos\\\">TOTAL:<\\/th>\\n                        <th class=\\\"subtotales_importes\\\">$ 8.625,00<\\/th>\\n                    <\\/tr>\\n                <\\/table>\\n                <br>\\n                <table cellspacing=\\\"0\\\" width=\\\"100%\\\" style=\\\"border: none\\\">\\n                    <tr>\\n                        <th style=\\\"width:50%; text-align:left;\\\">\\n\\n                            <?xml version=\\\"1.0\\\" encoding=\\\"UTF-8\\\"?>\\n<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" version=\\\"1.1\\\" width=\\\"100\\\" height=\\\"100\\\" viewBox=\\\"0 0 100 100\\\"><rect x=\\\"0\\\" y=\\\"0\\\" width=\\\"100\\\" height=\\\"100\\\" fill=\\\"#ffffff\\\"\\/><g transform=\\\"scale(1.754)\\\"><g transform=\\\"translate(0,0)\\\"><path fill-rule=\\\"evenodd\\\" d=\\\"M8 0L8 1L9 1L9 0ZM11 0L11 1L10 1L10 2L8 2L8 5L11 5L11 6L10 6L10 7L9 7L9 6L8 6L8 7L9 7L9 8L8 8L8 9L9 9L9 10L8 10L8 11L7 11L7 10L6 10L6 9L7 9L7 8L6 8L6 9L4 9L4 8L0 8L0 10L1 10L1 11L2 11L2 12L3 12L3 13L2 13L2 15L3 15L3 16L2 16L2 17L4 17L4 18L3 18L3 19L2 19L2 18L0 18L0 24L1 24L1 19L2 19L2 21L3 21L3 20L4 20L4 23L3 23L3 24L2 24L2 25L0 25L0 26L1 26L1 27L0 27L0 30L1 30L1 29L3 29L3 30L4 30L4 31L3 31L3 32L2 32L2 31L0 31L0 32L2 32L2 33L0 33L0 34L1 34L1 35L3 35L3 36L4 36L4 35L3 35L3 34L5 34L5 32L4 32L4 31L7 31L7 32L6 32L6 33L7 33L7 34L6 34L6 35L5 35L5 36L6 36L6 37L5 37L5 38L6 38L6 39L7 39L7 40L5 40L5 39L4 39L4 37L3 37L3 38L2 38L2 39L1 39L1 38L0 38L0 39L1 39L1 40L2 40L2 39L3 39L3 41L2 41L2 42L3 42L3 43L1 43L1 41L0 41L0 43L1 43L1 44L3 44L3 45L0 45L0 48L5 48L5 47L7 47L7 48L6 48L6 49L8 49L8 50L11 50L11 48L12 48L12 50L14 50L14 49L13 49L13 48L12 48L12 47L10 47L10 49L9 49L9 48L8 48L8 47L9 47L9 46L12 46L12 44L14 44L14 43L15 43L15 42L16 42L16 43L17 43L17 45L18 45L18 46L17 46L17 47L15 47L15 48L16 48L16 49L15 49L15 51L10 51L10 52L9 52L9 53L8 53L8 57L9 57L9 55L11 55L11 56L13 56L13 57L14 57L14 56L15 56L15 55L14 55L14 56L13 56L13 54L10 54L10 53L11 53L11 52L12 52L12 53L14 53L14 54L15 54L15 53L16 53L16 54L17 54L17 55L18 55L18 56L17 56L17 57L18 57L18 56L19 56L19 57L21 57L21 55L22 55L22 53L21 53L21 55L18 55L18 54L20 54L20 51L21 51L21 52L23 52L23 50L24 50L24 53L25 53L25 54L23 54L23 56L22 56L22 57L24 57L24 56L26 56L26 55L25 55L25 54L27 54L27 53L31 53L31 54L33 54L33 55L32 55L32 56L34 56L34 57L36 57L36 55L38 55L38 56L37 56L37 57L44 57L44 56L43 56L43 55L42 55L42 56L41 56L41 55L40 55L40 54L42 54L42 53L40 53L40 52L43 52L43 53L45 53L45 52L46 52L46 51L45 51L45 49L47 49L47 48L48 48L48 50L47 50L47 53L46 53L46 54L44 54L44 55L45 55L45 56L46 56L46 57L48 57L48 56L47 56L47 54L48 54L48 55L49 55L49 54L52 54L52 53L55 53L55 54L56 54L56 53L57 53L57 51L56 51L56 49L57 49L57 48L56 48L56 49L55 49L55 51L53 51L53 49L54 49L54 48L53 48L53 46L54 46L54 45L56 45L56 46L55 46L55 47L57 47L57 44L53 44L53 46L52 46L52 43L51 43L51 44L50 44L50 42L51 42L51 41L50 41L50 40L51 40L51 39L50 39L50 36L51 36L51 35L52 35L52 37L54 37L54 38L53 38L53 39L54 39L54 41L53 41L53 40L52 40L52 42L54 42L54 43L55 43L55 42L57 42L57 40L56 40L56 38L57 38L57 31L56 31L56 30L57 30L57 27L56 27L56 24L57 24L57 21L56 21L56 20L53 20L53 19L54 19L54 18L55 18L55 14L54 14L54 10L53 10L53 9L55 9L55 10L56 10L56 11L55 11L55 12L57 12L57 8L56 8L56 9L55 9L55 8L52 8L52 10L51 10L51 11L50 11L50 10L49 10L49 9L50 9L50 8L48 8L48 10L46 10L46 9L47 9L47 5L48 5L48 0L45 0L45 1L43 1L43 0L39 0L39 1L41 1L41 4L40 4L40 5L39 5L39 2L38 2L38 1L37 1L37 2L36 2L36 1L32 1L32 2L31 2L31 0L30 0L30 1L29 1L29 0L28 0L28 1L26 1L26 0L24 0L24 1L23 1L23 0L22 0L22 1L23 1L23 2L22 2L22 3L21 3L21 4L20 4L20 5L21 5L21 4L22 4L22 12L21 12L21 11L20 11L20 12L19 12L19 10L20 10L20 9L21 9L21 8L20 8L20 7L21 7L21 6L20 6L20 7L19 7L19 6L18 6L18 7L17 7L17 6L16 6L16 7L15 7L15 6L14 6L14 5L11 5L11 4L14 4L14 3L15 3L15 5L17 5L17 4L16 4L16 3L17 3L17 2L18 2L18 1L17 1L17 2L15 2L15 1L16 1L16 0L14 0L14 2L13 2L13 0ZM19 1L19 2L21 2L21 1ZM25 1L25 2L23 2L23 3L22 3L22 4L23 4L23 3L24 3L24 5L23 5L23 12L22 12L22 13L23 13L23 14L24 14L24 16L23 16L23 15L22 15L22 14L20 14L20 13L19 13L19 12L18 12L18 10L19 10L19 9L20 9L20 8L18 8L18 9L17 9L17 8L15 8L15 7L14 7L14 6L13 6L13 7L12 7L12 6L11 6L11 7L10 7L10 8L9 8L9 9L13 9L13 10L12 10L12 12L13 12L13 13L15 13L15 14L14 14L14 15L13 15L13 16L12 16L12 18L11 18L11 17L10 17L10 15L9 15L9 14L11 14L11 10L9 10L9 11L8 11L8 13L6 13L6 12L7 12L7 11L5 11L5 10L4 10L4 9L2 9L2 11L3 11L3 12L4 12L4 13L5 13L5 14L8 14L8 16L9 16L9 17L8 17L8 18L7 18L7 17L5 17L5 16L7 16L7 15L4 15L4 17L5 17L5 18L7 18L7 19L6 19L6 20L5 20L5 21L6 21L6 22L7 22L7 23L6 23L6 24L5 24L5 23L4 23L4 26L3 26L3 25L2 25L2 26L3 26L3 27L4 27L4 26L7 26L7 25L6 25L6 24L8 24L8 22L9 22L9 18L11 18L11 19L10 19L10 20L11 20L11 22L10 22L10 23L11 23L11 25L12 25L12 27L14 27L14 28L13 28L13 29L15 29L15 30L16 30L16 28L17 28L17 27L19 27L19 28L18 28L18 32L17 32L17 31L14 31L14 30L13 30L13 32L12 32L12 30L11 30L11 26L9 26L9 30L11 30L11 32L12 32L12 33L10 33L10 32L9 32L9 31L8 31L8 33L10 33L10 34L7 34L7 35L6 35L6 36L7 36L7 37L6 37L6 38L7 38L7 39L8 39L8 40L9 40L9 41L6 41L6 42L7 42L7 43L5 43L5 42L4 42L4 41L3 41L3 42L4 42L4 45L3 45L3 47L5 47L5 46L4 46L4 45L5 45L5 44L7 44L7 45L6 45L6 46L7 46L7 45L8 45L8 44L7 44L7 43L10 43L10 44L9 44L9 45L11 45L11 43L13 43L13 42L15 42L15 40L16 40L16 41L17 41L17 42L18 42L18 43L20 43L20 44L19 44L19 46L18 46L18 47L17 47L17 48L18 48L18 47L20 47L20 48L19 48L19 50L17 50L17 49L16 49L16 53L17 53L17 51L20 51L20 48L22 48L22 49L23 49L23 48L22 48L22 47L24 47L24 46L22 46L22 44L23 44L23 45L25 45L25 46L27 46L27 44L28 44L28 47L26 47L26 48L24 48L24 50L25 50L25 49L26 49L26 48L28 48L28 47L29 47L29 48L30 48L30 47L32 47L32 50L31 50L31 51L32 51L32 50L33 50L33 51L35 51L35 52L36 52L36 53L35 53L35 55L34 55L34 56L35 56L35 55L36 55L36 53L37 53L37 54L38 54L38 55L39 55L39 56L40 56L40 55L39 55L39 53L37 53L37 51L38 51L38 52L40 52L40 50L41 50L41 51L42 51L42 50L43 50L43 51L44 51L44 49L45 49L45 48L46 48L46 46L47 46L47 45L48 45L48 44L49 44L49 42L50 42L50 41L49 41L49 40L48 40L48 41L49 41L49 42L47 42L47 43L46 43L46 44L45 44L45 42L46 42L46 40L47 40L47 39L48 39L48 36L50 36L50 33L51 33L51 31L50 31L50 33L48 33L48 31L46 31L46 32L45 32L45 31L44 31L44 32L43 32L43 29L44 29L44 30L45 30L45 29L44 29L44 27L46 27L46 29L47 29L47 30L48 30L48 27L47 27L47 25L46 25L46 24L44 24L44 25L43 25L43 24L42 24L42 25L41 25L41 23L40 23L40 24L39 24L39 23L38 23L38 24L37 24L37 26L35 26L35 25L36 25L36 23L35 23L35 25L34 25L34 23L33 23L33 24L32 24L32 22L35 22L35 21L36 21L36 22L37 22L37 20L38 20L38 19L37 19L37 17L38 17L38 18L41 18L41 17L42 17L42 18L43 18L43 22L44 22L44 23L45 23L45 22L44 22L44 21L46 21L46 22L48 22L48 21L47 21L47 20L49 20L49 23L47 23L47 24L48 24L48 26L50 26L50 25L51 25L51 23L52 23L52 25L53 25L53 27L55 27L55 29L54 29L54 28L53 28L53 29L54 29L54 32L53 32L53 31L52 31L52 34L54 34L54 32L55 32L55 35L54 35L54 37L55 37L55 38L54 38L54 39L55 39L55 38L56 38L56 36L55 36L55 35L56 35L56 32L55 32L55 30L56 30L56 27L55 27L55 22L56 22L56 21L55 21L55 22L54 22L54 21L53 21L53 22L51 22L51 21L52 21L52 20L51 20L51 19L53 19L53 18L51 18L51 17L54 17L54 14L52 14L52 13L53 13L53 10L52 10L52 11L51 11L51 12L52 12L52 13L51 13L51 17L50 17L50 18L51 18L51 19L50 19L50 20L49 20L49 17L47 17L47 16L46 16L46 15L47 15L47 13L48 13L48 14L50 14L50 12L49 12L49 10L48 10L48 11L46 11L46 12L47 12L47 13L46 13L46 14L45 14L45 12L44 12L44 13L43 13L43 12L42 12L42 13L41 13L41 9L44 9L44 10L43 10L43 11L45 11L45 7L46 7L46 5L47 5L47 3L46 3L46 2L47 2L47 1L46 1L46 2L45 2L45 3L44 3L44 5L43 5L43 4L41 4L41 7L42 7L42 8L41 8L41 9L39 9L39 8L38 8L38 9L37 9L37 8L35 8L35 7L36 7L36 6L37 6L37 7L38 7L38 6L37 6L37 5L38 5L38 3L37 3L37 5L35 5L35 4L34 4L34 5L33 5L33 7L32 7L32 4L33 4L33 3L34 3L34 2L33 2L33 3L31 3L31 8L32 8L32 9L31 9L31 10L33 10L33 11L34 11L34 10L35 10L35 13L34 13L34 14L32 14L32 15L33 15L33 17L30 17L30 18L28 18L28 19L27 19L27 17L29 17L29 16L30 16L30 15L29 15L29 13L30 13L30 14L31 14L31 13L33 13L33 12L31 12L31 11L26 11L26 12L25 12L25 11L24 11L24 8L25 8L25 10L27 10L27 9L26 9L26 8L25 8L25 7L26 7L26 6L25 6L25 5L26 5L26 4L25 4L25 2L26 2L26 3L28 3L28 4L30 4L30 3L29 3L29 2L26 2L26 1ZM10 2L10 4L11 4L11 3L13 3L13 2ZM18 3L18 5L19 5L19 3ZM45 3L45 5L46 5L46 3ZM27 5L27 8L30 8L30 5ZM42 5L42 7L43 7L43 8L44 8L44 7L45 7L45 6L44 6L44 7L43 7L43 5ZM24 6L24 7L25 7L25 6ZM28 6L28 7L29 7L29 6ZM34 6L34 7L35 7L35 6ZM39 6L39 7L40 7L40 6ZM48 6L48 7L49 7L49 6ZM13 7L13 9L14 9L14 11L15 11L15 13L17 13L17 14L16 14L16 16L15 16L15 15L14 15L14 18L12 18L12 20L13 20L13 19L15 19L15 18L17 18L17 17L18 17L18 19L16 19L16 20L14 20L14 21L15 21L15 23L16 23L16 24L14 24L14 23L12 23L12 25L13 25L13 26L14 26L14 25L15 25L15 26L16 26L16 25L17 25L17 26L18 26L18 25L19 25L19 27L21 27L21 26L22 26L22 27L23 27L23 30L22 30L22 29L21 29L21 30L22 30L22 31L20 31L20 33L21 33L21 32L22 32L22 35L26 35L26 36L25 36L25 37L27 37L27 35L28 35L28 37L29 37L29 39L30 39L30 38L31 38L31 40L27 40L27 42L29 42L29 41L30 41L30 44L29 44L29 43L28 43L28 44L29 44L29 45L30 45L30 46L31 46L31 45L32 45L32 47L33 47L33 46L34 46L34 48L33 48L33 50L34 50L34 48L35 48L35 47L36 47L36 49L35 49L35 51L36 51L36 49L37 49L37 48L38 48L38 45L37 45L37 47L36 47L36 45L35 45L35 46L34 46L34 45L32 45L32 43L31 43L31 41L33 41L33 43L35 43L35 44L37 44L37 42L38 42L38 44L39 44L39 47L40 47L40 45L41 45L41 48L42 48L42 49L43 49L43 48L45 48L45 45L44 45L44 44L43 44L43 43L42 43L42 45L41 45L41 43L40 43L40 44L39 44L39 42L38 42L38 41L37 41L37 42L36 42L36 40L35 40L35 39L38 39L38 40L39 40L39 41L40 41L40 42L42 42L42 41L43 41L43 42L45 42L45 40L46 40L46 38L45 38L45 37L46 37L46 36L48 36L48 35L49 35L49 34L48 34L48 33L47 33L47 32L46 32L46 33L44 33L44 35L43 35L43 32L42 32L42 33L41 33L41 31L40 31L40 30L41 30L41 29L43 29L43 27L42 27L42 28L41 28L41 26L40 26L40 25L39 25L39 24L38 24L38 27L37 27L37 29L36 29L36 28L35 28L35 29L34 29L34 28L33 28L33 27L31 27L31 26L34 26L34 25L32 25L32 24L31 24L31 26L28 26L28 24L26 24L26 23L27 23L27 22L28 22L28 21L29 21L29 20L30 20L30 23L31 23L31 22L32 22L32 20L30 20L30 19L28 19L28 20L27 20L27 19L25 19L25 18L24 18L24 19L22 19L22 18L21 18L21 19L20 19L20 16L19 16L19 17L18 17L18 16L17 16L17 14L18 14L18 12L17 12L17 11L16 11L16 10L15 10L15 9L14 9L14 7ZM28 9L28 10L30 10L30 9ZM36 9L36 13L35 13L35 15L39 15L39 16L38 16L38 17L39 17L39 16L42 16L42 17L43 17L43 18L44 18L44 17L46 17L46 19L45 19L45 20L47 20L47 17L46 17L46 16L45 16L45 15L44 15L44 14L42 14L42 15L41 15L41 13L40 13L40 10L39 10L39 13L38 13L38 12L37 12L37 9ZM4 11L4 12L5 12L5 11ZM0 12L0 15L1 15L1 12ZM23 12L23 13L24 13L24 12ZM26 12L26 14L25 14L25 16L24 16L24 17L25 17L25 16L26 16L26 15L27 15L27 12ZM8 13L8 14L9 14L9 13ZM36 13L36 14L38 14L38 13ZM39 13L39 15L40 15L40 13ZM19 14L19 15L20 15L20 14ZM28 15L28 16L29 16L29 15ZM42 15L42 16L43 16L43 15ZM49 15L49 16L50 16L50 15ZM52 15L52 16L53 16L53 15ZM35 16L35 17L33 17L33 18L31 18L31 19L35 19L35 20L37 20L37 19L36 19L36 18L35 18L35 17L36 17L36 16ZM56 16L56 18L57 18L57 16ZM7 19L7 20L6 20L6 21L7 21L7 22L8 22L8 21L7 21L7 20L8 20L8 19ZM18 19L18 20L17 20L17 21L16 21L16 23L18 23L18 22L19 22L19 23L20 23L20 24L19 24L19 25L20 25L20 24L22 24L22 25L23 25L23 26L24 26L24 27L25 27L25 29L24 29L24 32L25 32L25 34L26 34L26 35L27 35L27 34L30 34L30 35L29 35L29 36L30 36L30 35L31 35L31 38L33 38L33 36L32 36L32 34L31 34L31 33L33 33L33 34L36 34L36 35L37 35L37 34L38 34L38 36L37 36L37 37L39 37L39 38L38 38L38 39L40 39L40 41L42 41L42 38L44 38L44 39L45 39L45 38L44 38L44 37L45 37L45 36L46 36L46 34L47 34L47 33L46 33L46 34L45 34L45 36L41 36L41 35L42 35L42 34L39 34L39 33L40 33L40 32L38 32L38 31L37 31L37 32L35 32L35 33L33 33L33 32L34 32L34 30L33 30L33 31L32 31L32 30L31 30L31 33L30 33L30 31L26 31L26 32L25 32L25 29L26 29L26 25L25 25L25 23L26 23L26 22L27 22L27 21L25 21L25 23L22 23L22 19L21 19L21 21L20 21L20 19ZM24 19L24 20L25 20L25 19ZM39 19L39 20L40 20L40 19ZM41 19L41 20L42 20L42 19ZM33 20L33 21L34 21L34 20ZM50 20L50 21L51 21L51 20ZM12 21L12 22L13 22L13 21ZM17 21L17 22L18 22L18 21ZM19 21L19 22L20 22L20 21ZM23 21L23 22L24 22L24 21ZM38 21L38 22L40 22L40 21ZM53 22L53 23L54 23L54 22ZM49 23L49 25L50 25L50 23ZM9 24L9 25L10 25L10 24ZM44 25L44 26L45 26L45 25ZM39 26L39 27L40 27L40 26ZM1 27L1 28L2 28L2 27ZM5 27L5 30L8 30L8 27ZM15 27L15 28L16 28L16 27ZM27 27L27 30L30 30L30 27ZM49 27L49 30L52 30L52 27ZM3 28L3 29L4 29L4 28ZM6 28L6 29L7 29L7 28ZM19 28L19 30L20 30L20 28ZM28 28L28 29L29 29L29 28ZM31 28L31 29L32 29L32 28ZM38 28L38 29L37 29L37 30L39 30L39 29L41 29L41 28ZM50 28L50 29L51 29L51 28ZM35 29L35 31L36 31L36 29ZM22 31L22 32L23 32L23 31ZM3 32L3 33L4 33L4 32ZM14 32L14 33L12 33L12 35L13 35L13 36L11 36L11 34L10 34L10 35L9 35L9 36L8 36L8 38L9 38L9 40L12 40L12 42L13 42L13 41L14 41L14 39L15 39L15 38L17 38L17 39L16 39L16 40L17 40L17 39L18 39L18 40L19 40L19 39L18 39L18 38L19 38L19 36L18 36L18 38L17 38L17 37L16 37L16 36L17 36L17 35L18 35L18 34L17 34L17 35L16 35L16 34L14 34L14 33L15 33L15 32ZM26 32L26 33L27 33L27 32ZM37 32L37 33L38 33L38 32ZM23 33L23 34L24 34L24 33ZM19 34L19 35L20 35L20 38L21 38L21 37L22 37L22 38L24 38L24 36L23 36L23 37L22 37L22 36L21 36L21 34ZM14 35L14 36L15 36L15 35ZM1 36L1 37L2 37L2 36ZM9 36L9 38L10 38L10 39L11 39L11 38L12 38L12 37L10 37L10 36ZM34 36L34 39L33 39L33 40L34 40L34 39L35 39L35 38L36 38L36 37L35 37L35 36ZM39 36L39 37L40 37L40 39L41 39L41 37L40 37L40 36ZM14 37L14 38L13 38L13 39L12 39L12 40L13 40L13 39L14 39L14 38L15 38L15 37ZM26 38L26 39L28 39L28 38ZM20 39L20 40L22 40L22 39ZM24 39L24 40L23 40L23 42L24 42L24 41L25 41L25 44L26 44L26 41L25 41L25 39ZM55 40L55 41L54 41L54 42L55 42L55 41L56 41L56 40ZM9 41L9 42L10 42L10 43L11 43L11 42L10 42L10 41ZM18 41L18 42L20 42L20 41ZM21 41L21 44L20 44L20 45L21 45L21 44L22 44L22 41ZM23 43L23 44L24 44L24 43ZM30 44L30 45L31 45L31 44ZM13 45L13 46L16 46L16 45ZM43 45L43 47L42 47L42 48L43 48L43 47L44 47L44 45ZM49 45L49 48L50 48L50 46L51 46L51 45ZM1 46L1 47L2 47L2 46ZM20 46L20 47L21 47L21 46ZM51 47L51 48L52 48L52 47ZM39 48L39 49L38 49L38 51L39 51L39 50L40 50L40 48ZM27 49L27 52L30 52L30 49ZM49 49L49 52L52 52L52 49ZM21 50L21 51L22 51L22 50ZM28 50L28 51L29 51L29 50ZM50 50L50 51L51 51L51 50ZM25 51L25 52L26 52L26 51ZM55 51L55 53L56 53L56 51ZM14 52L14 53L15 53L15 52ZM18 52L18 53L19 53L19 52ZM31 52L31 53L32 53L32 52ZM33 52L33 54L34 54L34 52ZM27 55L27 57L31 57L31 56L30 56L30 55L29 55L29 56L28 56L28 55ZM50 55L50 57L51 57L51 55ZM53 55L53 56L52 56L52 57L55 57L55 56L54 56L54 55ZM56 55L56 56L57 56L57 55ZM0 0L0 7L7 7L7 0ZM1 1L1 6L6 6L6 1ZM2 2L2 5L5 5L5 2ZM50 0L50 7L57 7L57 0ZM51 1L51 6L56 6L56 1ZM52 2L52 5L55 5L55 2ZM0 50L0 57L7 57L7 50ZM1 51L1 56L6 56L6 51ZM2 52L2 55L5 55L5 52Z\\\" fill=\\\"#000000\\\"\\/><\\/g><\\/g><\\/svg>\\n\\n                            <span style=\\\"width:50%;\\\">\\n                                <img style=\\\"max-height: 70px\\\"\\n                                     src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/img\\/AfipComprobanteAutorizado.png\\\">\\n                            <\\/span>\\n                        <\\/th>\\n                        <th style=\\\"text-align:right;\\\">\\n                            <p>CAE N&#186;: 71304902481149<br>\\n                                Fecha Vto. CAE:  25\\/07\\/2021\\n                            <\\/p>\\n                        <\\/th>\\n                    <\\/tr>\\n                <\\/table>\\n                    <\\/div>\\n    <\\/div>\\n\\n    <\\/body>\\n<\\/html>\\\";s:4:\\\"file\\\";N;}s:6:\\\"locale\\\";N;s:4:\\\"from\\\";a:0:{}s:2:\\\"to\\\";a:1:{i:0;a:2:{s:4:\\\"name\\\";N;s:7:\\\"address\\\";s:23:\\\"Natinietotano@gmail.com\\\";}}s:2:\\\"cc\\\";a:0:{}s:3:\\\"bcc\\\";a:1:{i:0;a:2:{s:4:\\\"name\\\";N;s:7:\\\"address\\\";s:23:\\\"info@masquecontable.com\\\";}}s:7:\\\"replyTo\\\";a:0:{}s:7:\\\"subject\\\";N;s:11:\\\"\\u0000*\\u0000markdown\\\";N;s:7:\\\"\\u0000*\\u0000html\\\";N;s:4:\\\"view\\\";N;s:8:\\\"textView\\\";N;s:8:\\\"viewData\\\";a:0:{}s:11:\\\"attachments\\\";a:0:{}s:14:\\\"rawAttachments\\\";a:0:{}s:15:\\\"diskAttachments\\\";a:0:{}s:9:\\\"callbacks\\\";a:0:{}s:5:\\\"theme\\\";N;s:6:\\\"mailer\\\";s:8:\\\"sendgrid\\\";s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:5:\\\"delay\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;}\"}}','ErrorException: Trying to get property \'id\' of non-object in /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php:16\nStack trace:\n#0 /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php(16): Illuminate\\Foundation\\Bootstrap\\HandleExceptions->handleError(8, \'Trying to get p...\', \'/home/forge/tax...\', 16, Array)\n#1 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(356): App\\Queue\\DatabaseJob->fire()\n#2 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(306): Illuminate\\Queue\\Worker->process(\'database\', Object(App\\Queue\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#3 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(132): Illuminate\\Queue\\Worker->runJob(Object(App\\Queue\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#4 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(112): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#5 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(96): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#6 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#7 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#8 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#9 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#10 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#11 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(134): Illuminate\\Container\\Container->call(Array)\n#12 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(256): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#13 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(121): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#14 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(971): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#15 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(290): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#16 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(166): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#17 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Application.php(93): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(129): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#19 /home/forge/taxes.com.ar/artisan(35): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#20 {main}','2021-07-23 18:04:10',NULL);
INSERT INTO `failed_jobs` VALUES (12,NULL,'database','default','{\"uuid\":\"3758de85-dcdc-424c-9c22-42d4b7fcfc17\",\"displayName\":\"App\\\\Mail\\\\Fact_Electronica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"delay\":null,\"timeout\":null,\"timeoutAt\":null,\"data\":{\"commandName\":\"Illuminate\\\\Mail\\\\SendQueuedMailable\",\"command\":\"O:34:\\\"Illuminate\\\\Mail\\\\SendQueuedMailable\\\":3:{s:8:\\\"mailable\\\";O:25:\\\"App\\\\Mail\\\\Fact_Electronica\\\":27:{s:11:\\\"informacion\\\";a:6:{s:12:\\\"ruta_logo_fa\\\";N;s:4:\\\"mail\\\";s:23:\\\"info@masquecontable.com\\\";s:18:\\\"name_quien_factura\\\";s:19:\\\"MICAELA AILIN CORIA\\\";s:7:\\\"cliente\\\";O:17:\\\"App\\\\Models\\\\Person\\\":27:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:7:\\\"persons\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:41110;s:7:\\\"user_id\\\";i:5115;s:11:\\\"field_name1\\\";s:18:\\\"HORUS NETWORKS SAS\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"30-71711395-7\\\";s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-07-14 11:07:00\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-07-14 11:07:00\\\";s:11:\\\"activity_id\\\";i:1;s:7:\\\"address\\\";s:100:\\\"Direccion\\r\\nLOPEZ Y PLANES VICENTE 184\\r\\nCod. Postal\\r\\n5800\\r\\nProvincia\\r\\nCORDOBA\\r\\nTipo Domicilio\\r\\nFISCAL\\\";s:14:\\\"person_type_id\\\";i:2;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:41110;s:7:\\\"user_id\\\";i:5115;s:11:\\\"field_name1\\\";s:18:\\\"HORUS NETWORKS SAS\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"30-71711395-7\\\";s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-07-14 11:07:00\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-07-14 11:07:00\\\";s:11:\\\"activity_id\\\";i:1;s:7:\\\"address\\\";s:100:\\\"Direccion\\r\\nLOPEZ Y PLANES VICENTE 184\\r\\nCod. Postal\\r\\n5800\\r\\nProvincia\\r\\nCORDOBA\\r\\nTipo Domicilio\\r\\nFISCAL\\\";s:14:\\\"person_type_id\\\";i:2;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}s:14:\\\"nombre_del_pdf\\\";s:28:\\\"Factura N\\u00b00004-00000015.pdf\\\";s:9:\\\"body_mail\\\";s:155:\\\"Estimado cliente, se env\\u00eda adjunta la factura de honorarios correspondientes al mes de Julio 2021.\\nMuchas gracias por seguir eligiendo nuestros servicios.\\\";}s:3:\\\"pdf\\\";O:26:\\\"Barryvdh\\\\Snappy\\\\PdfWrapper\\\":4:{s:9:\\\"\\u0000*\\u0000snappy\\\";O:35:\\\"Barryvdh\\\\Snappy\\\\IlluminateSnappyPdf\\\":10:{s:26:\\\"\\u0000*\\u0000optionsWithContentCheck\\\";a:4:{s:11:\\\"header-html\\\";s:4:\\\"html\\\";s:11:\\\"footer-html\\\";s:4:\\\"html\\\";s:5:\\\"cover\\\";s:4:\\\"html\\\";s:15:\\\"xsl-style-sheet\\\";s:3:\\\"xsl\\\";}s:36:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000binary\\\";s:76:\\\"\\/home\\/forge\\/taxes.com.ar\\/vendor\\/h4cc\\/wkhtmltopdf-amd64\\/bin\\/wkhtmltopdf-amd64\\\";s:37:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000options\\\";a:132:{s:7:\\\"collate\\\";N;s:10:\\\"no-collate\\\";N;s:10:\\\"cookie-jar\\\";N;s:6:\\\"copies\\\";i:1;s:3:\\\"dpi\\\";N;s:13:\\\"extended-help\\\";N;s:9:\\\"grayscale\\\";N;s:4:\\\"help\\\";N;s:7:\\\"htmldoc\\\";N;s:18:\\\"ignore-load-errors\\\";N;s:9:\\\"image-dpi\\\";N;s:13:\\\"image-quality\\\";N;s:7:\\\"license\\\";N;s:9:\\\"log-level\\\";N;s:10:\\\"lowquality\\\";b:1;s:7:\\\"manpage\\\";N;s:13:\\\"margin-bottom\\\";N;s:11:\\\"margin-left\\\";N;s:12:\\\"margin-right\\\";N;s:10:\\\"margin-top\\\";N;s:11:\\\"orientation\\\";N;s:11:\\\"page-height\\\";N;s:9:\\\"page-size\\\";s:2:\\\"a4\\\";s:10:\\\"page-width\\\";N;s:18:\\\"no-pdf-compression\\\";N;s:5:\\\"quiet\\\";N;s:20:\\\"read-args-from-stdin\\\";N;s:6:\\\"readme\\\";N;s:5:\\\"title\\\";N;s:11:\\\"use-xserver\\\";N;s:7:\\\"version\\\";N;s:20:\\\"dump-default-toc-xsl\\\";N;s:12:\\\"dump-outline\\\";N;s:7:\\\"outline\\\";N;s:10:\\\"no-outline\\\";N;s:13:\\\"outline-depth\\\";N;s:13:\\\"output-format\\\";N;s:5:\\\"allow\\\";N;s:10:\\\"background\\\";N;s:13:\\\"no-background\\\";N;s:16:\\\"bypass-proxy-for\\\";N;s:9:\\\"cache-dir\\\";N;s:20:\\\"checkbox-checked-svg\\\";N;s:12:\\\"checkbox-svg\\\";N;s:6:\\\"cookie\\\";N;s:13:\\\"custom-header\\\";N;s:25:\\\"custom-header-propagation\\\";N;s:28:\\\"no-custom-header-propagation\\\";N;s:16:\\\"debug-javascript\\\";N;s:19:\\\"no-debug-javascript\\\";N;s:14:\\\"default-header\\\";N;s:8:\\\"encoding\\\";N;s:22:\\\"disable-external-links\\\";N;s:21:\\\"enable-external-links\\\";N;s:13:\\\"disable-forms\\\";N;s:12:\\\"enable-forms\\\";N;s:6:\\\"images\\\";N;s:9:\\\"no-images\\\";N;s:22:\\\"disable-internal-links\\\";N;s:21:\\\"enable-internal-links\\\";N;s:18:\\\"disable-javascript\\\";N;s:17:\\\"enable-javascript\\\";N;s:16:\\\"javascript-delay\\\";N;s:19:\\\"keep-relative-links\\\";N;s:19:\\\"load-error-handling\\\";N;s:25:\\\"load-media-error-handling\\\";N;s:25:\\\"disable-local-file-access\\\";N;s:24:\\\"enable-local-file-access\\\";N;s:17:\\\"minimum-font-size\\\";N;s:20:\\\"exclude-from-outline\\\";N;s:18:\\\"include-in-outline\\\";N;s:11:\\\"page-offset\\\";N;s:8:\\\"password\\\";N;s:15:\\\"disable-plugins\\\";N;s:14:\\\"enable-plugins\\\";N;s:4:\\\"post\\\";N;s:9:\\\"post-file\\\";N;s:16:\\\"print-media-type\\\";N;s:19:\\\"no-print-media-type\\\";N;s:5:\\\"proxy\\\";N;s:21:\\\"proxy-hostname-lookup\\\";N;s:23:\\\"radiobutton-checked-svg\\\";N;s:15:\\\"radiobutton-svg\\\";N;s:14:\\\"redirect-delay\\\";N;s:22:\\\"resolve-relative-links\\\";N;s:10:\\\"run-script\\\";N;s:23:\\\"disable-smart-shrinking\\\";N;s:22:\\\"enable-smart-shrinking\\\";N;s:12:\\\"ssl-crt-path\\\";N;s:16:\\\"ssl-key-password\\\";N;s:12:\\\"ssl-key-path\\\";N;s:17:\\\"stop-slow-scripts\\\";N;s:20:\\\"no-stop-slow-scripts\\\";N;s:22:\\\"disable-toc-back-links\\\";N;s:21:\\\"enable-toc-back-links\\\";N;s:16:\\\"user-style-sheet\\\";N;s:8:\\\"username\\\";N;s:13:\\\"viewport-size\\\";N;s:13:\\\"window-status\\\";N;s:4:\\\"zoom\\\";N;s:13:\\\"footer-center\\\";s:25:\\\"Pagina [page] de [toPage]\\\";s:16:\\\"footer-font-name\\\";N;s:16:\\\"footer-font-size\\\";i:8;s:11:\\\"footer-html\\\";N;s:11:\\\"footer-left\\\";s:0:\\\"\\\";s:11:\\\"footer-line\\\";N;s:14:\\\"no-footer-line\\\";N;s:12:\\\"footer-right\\\";N;s:14:\\\"footer-spacing\\\";N;s:13:\\\"header-center\\\";N;s:16:\\\"header-font-name\\\";N;s:16:\\\"header-font-size\\\";N;s:11:\\\"header-html\\\";N;s:11:\\\"header-left\\\";N;s:11:\\\"header-line\\\";N;s:14:\\\"no-header-line\\\";N;s:12:\\\"header-right\\\";N;s:14:\\\"header-spacing\\\";N;s:7:\\\"replace\\\";N;s:5:\\\"cover\\\";N;s:3:\\\"toc\\\";N;s:20:\\\"disable-dotted-lines\\\";N;s:9:\\\"toc-depth\\\";N;s:13:\\\"toc-font-name\\\";N;s:16:\\\"toc-l1-font-size\\\";N;s:15:\\\"toc-header-text\\\";N;s:20:\\\"toc-header-font-name\\\";N;s:20:\\\"toc-header-font-size\\\";N;s:21:\\\"toc-level-indentation\\\";N;s:17:\\\"disable-toc-links\\\";N;s:20:\\\"toc-text-size-shrink\\\";N;s:15:\\\"xsl-style-sheet\\\";N;}s:33:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000env\\\";N;s:37:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000timeout\\\";b:0;s:46:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000defaultExtension\\\";s:3:\\\"pdf\\\";s:18:\\\"\\u0000*\\u0000temporaryFolder\\\";N;s:14:\\\"temporaryFiles\\\";a:0:{}s:36:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000logger\\\";O:18:\\\"Psr\\\\Log\\\\NullLogger\\\":0:{}s:2:\\\"fs\\\";O:32:\\\"Illuminate\\\\Filesystem\\\\Filesystem\\\":0:{}}s:10:\\\"\\u0000*\\u0000options\\\";a:0:{}s:4:\\\"html\\\";s:22234:\\\"<!DOCTYPE html>\\n<html lang=\\\"en\\\">\\n    <head>\\n        <meta charset=\\\"utf-8\\\">\\n    <\\/head>\\n    <style>\\n        .subtotales_conceptos{\\n            width:30%;\\n            text-align: right;\\n        }\\n        .subtotales_importes{\\n            text-align: right;\\n        }\\n        .table-totales, .table-totales tr, .table-totales th{\\n            border: 1px solid;\\n        }\\n\\n    <\\/style>\\n    <body>\\n    <div style=\\\"max-height:840px\\\">\\n        <div style=\\\"width: 100%; height:270px\\\"> <!-- Datos de la empresa -->\\n            <table class=\\\"display\\\" cellspacing=\\\"0\\\" width=\\\"100%\\\" style=\\\"border:  1px solid;\\\">\\n                <tr style=\\\"\\\">\\n                    <th colspan=\\\"2\\\" rowspan=\\\"2\\\" style=\\\"width:45%;margin:0;height:150px;\\\">\\n                                                <img src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/img\\/\\/27377183504\\/logo_punto_venta_0000.png\\\"\\/>\\n                                            <\\/th>\\n                    <th style=\\\"border:  1px solid;text-align: center; width:10%\\\" colspan=\\\"2\\\">\\n                        <span style=\\\"font-size: 60px;\\\">C<\\/span> <br \\/> <span style=\\\"font-size: 14px;\\\">cod. 11<\\/span>\\n                    <\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"font-size: 28px;text-align: center;width:45%\\\">\\n                        Factura\\n                        <br>\\n                        0004 - 00000015\\n                    <\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th><\\/th>\\n                    <th style=\\\"border:  1px 1px 1px 0px solid;\\\" colspan=\\\"2\\\"><\\/th>\\n                    <th><\\/th>\\n                <\\/tr>\\n                <tr>\\n\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                                                    Raz&oacute;n Social:\\n                            <span style=\\\"font-weight: normal;\\\">MICAELA AILIN CORIA<\\/span>\\n                                            <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">Fecha de Emisi&oacute;n: <span style=\\\"font-weight: normal;\\\">15\\/07\\/2021<\\/span><\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Domicilio Comercial: <span style=\\\"font-weight: normal;\\\">Victor Guillet esq. Arturo M Bas, C.P.:5800,\\n                        C\\u00f3rdoba<\\/span>\\n                    <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">CUIT: <span style=\\\"font-weight: normal;\\\">27-37718350-4<\\/span><\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Condici&oacute;n frente al IVA: <span style=\\\"font-weight: normal;\\\">Monotributo<\\/span>\\n                    <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Ingresos Brutos: <span style=\\\"font-weight: normal;\\\"><\\/span>\\n                        <br>\\n                        Fecha de Inicio de Actividades: <span style=\\\"font-weight: normal;\\\">09\\/07\\/2021<\\/span>\\n                    <\\/th>\\n                <\\/tr>\\n            <\\/table>\\n        <\\/div>\\n\\n        <table style=\\\"text-align: center; width: 100%;border: solid 1px;\\\"> <!-- Fechas -->\\n            <thead>\\n                <tr>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Per\\u00edodo Facturado Desde: 01\\/07\\/2021<\\/small><\\/th>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Per\\u00edodo Facturado Hasta: 31\\/07\\/2021<\\/small><\\/th>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Fecha Vto. Pago: 15\\/07\\/2021<\\/small><\\/th>\\n                <\\/tr>\\n            <\\/thead>\\n        <\\/table>\\n        \\n        <table style=\\\"width: 100%; margin-top: 1%;border: solid 1px;\\\"> <!-- Datos Clientes -->\\n            <tr>\\n                <th style=\\\"text-align:left;\\\"colspan=\\\"12\\\">\\n                    CUIT: <span style=\\\"font-weight: normal;\\\">30-71711395-7<\\/span>\\n                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\\n                    Apellido y Nombre \\/ Raz&oacute;n Social: <span style=\\\"font-weight: normal;\\\">\\n                    HORUS NETWORKS SAS<\\/span>\\n                <\\/th>\\n            <\\/tr>\\n            <tr>\\n                <th style=\\\"text-align:left; width:50%\\\">\\n                    Condici&oacute;n Frente al IVA: <span style=\\\"font-weight: normal;\\\">IVA Responsable Inscripto<\\/span>\\n                <\\/th>\\n                <th style=\\\"text-align:left; width:50%\\\" colspan=\\\"4\\\">\\n                    Domicilio Comercial:\\n                    <span style=\\\"font-weight: normal;\\\">\\n                    Direccion\\r\\nLOPEZ Y PLANES VICENTE 184\\r\\nCod. Postal\\r\\n5800\\r\\nProvincia\\r\\nCORDOBA\\r\\nTipo Domicilio\\r\\nFISCAL\\n                    <\\/span>\\n                <\\/th>\\n            <\\/tr>\\n            <tr style=\\\"text-align:left\\\">\\n                <th>Condici&oacute;n de Venta: <span style=\\\"font-weight: normal;\\\">Cuenta Corriente<\\/span><\\/th>\\n            <\\/tr>\\n        <\\/table>\\n\\n        <div style=\\\"border: 1px solid;margin-top: 1%;min-height:600px;\\\">\\n        <table style=\\\"text-align: center; width: 100%; margin-top: 1%;\\\"> <!-- Body -->\\n            <tr style=\\\"border-bottom: 1px solid;font-size: 15px\\\">\\n                <th>C&oacute;digo<\\/th>\\n                <th style=\\\"width: 25%;\\\">Detalle<\\/th>\\n                <th>Cantidad<\\/th>\\n                <th>U.Medida<\\/th>\\n                <th>Precio U.<\\/th>\\n                <th>Bonif. (%)<\\/th>\\n                <th>Precio Bonif.<\\/th>\\n                <th>Subtotal<\\/th>\\n                            <\\/tr>\\n            <tbody>\\n                                                                                <tr style=\\\"font-size: 12px;\\\">\\n                        <td>\\n                            \\n                        <\\/td>\\n                        <td>\\n                            Honorarios profesionales Julio 2021\\n                        <\\/td>\\n                        <td>\\n                            1.00\\n                        <\\/td>\\n                        <td>\\n                            Unidades\\n                        <\\/td>\\n                        <td>                            7.500,00\\n                                                    <\\/td>\\n                        <td>\\n                            0,00%\\n                        <\\/td>\\n                        <td>\\n                            0,00\\n                        <\\/td>\\n                        <td>\\n                            7.500,00\\n                        <\\/td>\\n                                            <\\/tr>\\n                    \\n            <\\/tbody>\\n        <\\/table>\\n        <\\/div>\\n\\n        \\n\\n        <div style=\\\"height:200px;margin-top: 1%;\\\"> <!-- Totales -->\\n              <!-- Es factura B o C -->\\n                <table class=\\\"table-totales\\\" cellspacing=\\\"0\\\" width=\\\"100%\\\">\\n                    <tr>\\n                        <th style=\\\"width:50%; text-align:left;\\\">\\n\\n<!--                                <span style=\\\"width:100%;\\\"><img src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/barcodes\\/71304902482577.png\\\"><\\/span>\\n                                <span style=\\\"text-align:center;\\\">2737718350411000471304902482577202107257<\\/span>-->\\n                        <\\/th>\\n                        <th class=\\\"subtotales_conceptos\\\">TOTAL:<\\/th>\\n                        <th class=\\\"subtotales_importes\\\">$ 7.500,00<\\/th>\\n                    <\\/tr>\\n                <\\/table>\\n                <br>\\n                <table cellspacing=\\\"0\\\" width=\\\"100%\\\" style=\\\"border: none\\\">\\n                    <tr>\\n                        <th style=\\\"width:50%; text-align:left;\\\">\\n\\n                            <?xml version=\\\"1.0\\\" encoding=\\\"UTF-8\\\"?>\\n<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" version=\\\"1.1\\\" width=\\\"100\\\" height=\\\"100\\\" viewBox=\\\"0 0 100 100\\\"><rect x=\\\"0\\\" y=\\\"0\\\" width=\\\"100\\\" height=\\\"100\\\" fill=\\\"#ffffff\\\"\\/><g transform=\\\"scale(1.754)\\\"><g transform=\\\"translate(0,0)\\\"><path fill-rule=\\\"evenodd\\\" d=\\\"M8 0L8 1L9 1L9 2L8 2L8 5L11 5L11 6L10 6L10 7L9 7L9 6L8 6L8 7L9 7L9 8L8 8L8 9L7 9L7 8L6 8L6 9L7 9L7 10L6 10L6 11L7 11L7 12L6 12L6 13L1 13L1 14L0 14L0 15L1 15L1 14L2 14L2 15L3 15L3 16L2 16L2 17L4 17L4 18L3 18L3 19L2 19L2 20L3 20L3 21L2 21L2 22L1 22L1 20L0 20L0 22L1 22L1 23L2 23L2 24L1 24L1 25L2 25L2 26L1 26L1 28L0 28L0 30L1 30L1 28L2 28L2 27L3 27L3 29L2 29L2 31L0 31L0 32L2 32L2 33L0 33L0 36L1 36L1 37L0 37L0 39L1 39L1 40L2 40L2 41L1 41L1 42L0 42L0 43L1 43L1 42L2 42L2 43L3 43L3 44L2 44L2 45L0 45L0 48L5 48L5 47L7 47L7 46L8 46L8 45L9 45L9 43L10 43L10 41L9 41L9 40L11 40L11 39L10 39L10 36L8 36L8 37L9 37L9 39L7 39L7 38L5 38L5 40L4 40L4 39L1 39L1 38L3 38L3 37L2 37L2 35L3 35L3 36L5 36L5 37L7 37L7 36L6 36L6 35L7 35L7 34L9 34L9 35L12 35L12 36L11 36L11 38L12 38L12 42L13 42L13 41L14 41L14 39L15 39L15 38L17 38L17 39L16 39L16 40L15 40L15 42L16 42L16 43L17 43L17 45L18 45L18 46L17 46L17 47L16 47L16 45L15 45L15 44L14 44L14 45L13 45L13 43L11 43L11 44L10 44L10 45L11 45L11 44L12 44L12 45L13 45L13 47L11 47L11 46L10 46L10 48L11 48L11 50L10 50L10 49L9 49L9 47L8 47L8 48L6 48L6 49L8 49L8 50L9 50L9 53L8 53L8 57L9 57L9 55L12 55L12 56L13 56L13 57L14 57L14 56L15 56L15 55L14 55L14 56L13 56L13 55L12 55L12 54L13 54L13 53L12 53L12 54L11 54L11 53L10 53L10 52L11 52L11 51L14 51L14 52L15 52L15 53L16 53L16 54L17 54L17 55L18 55L18 56L17 56L17 57L18 57L18 56L19 56L19 57L21 57L21 55L22 55L22 53L21 53L21 54L20 54L20 51L21 51L21 52L23 52L23 50L24 50L24 53L25 53L25 54L23 54L23 56L22 56L22 57L24 57L24 56L26 56L26 55L25 55L25 54L27 54L27 53L31 53L31 54L33 54L33 55L32 55L32 56L34 56L34 57L36 57L36 55L38 55L38 56L37 56L37 57L44 57L44 56L43 56L43 55L42 55L42 56L41 56L41 55L40 55L40 54L42 54L42 53L40 53L40 52L43 52L43 53L45 53L45 52L46 52L46 51L45 51L45 49L47 49L47 48L48 48L48 50L47 50L47 53L46 53L46 54L44 54L44 55L45 55L45 56L46 56L46 57L47 57L47 54L48 54L48 56L49 56L49 55L50 55L50 57L51 57L51 54L52 54L52 53L53 53L53 56L52 56L52 57L55 57L55 56L54 56L54 53L55 53L55 54L56 54L56 53L57 53L57 51L56 51L56 49L57 49L57 48L56 48L56 49L55 49L55 51L53 51L53 49L54 49L54 48L53 48L53 46L54 46L54 45L56 45L56 46L55 46L55 47L57 47L57 44L53 44L53 46L52 46L52 43L51 43L51 44L50 44L50 42L51 42L51 41L50 41L50 40L52 40L52 42L54 42L54 43L55 43L55 42L57 42L57 40L56 40L56 38L57 38L57 31L56 31L56 30L57 30L57 27L56 27L56 24L57 24L57 21L56 21L56 20L53 20L53 19L54 19L54 18L55 18L55 14L54 14L54 10L53 10L53 9L55 9L55 10L56 10L56 12L57 12L57 8L56 8L56 9L55 9L55 8L52 8L52 10L51 10L51 11L50 11L50 10L49 10L49 9L50 9L50 8L48 8L48 7L49 7L49 6L48 6L48 7L47 7L47 5L48 5L48 0L45 0L45 1L43 1L43 0L39 0L39 1L41 1L41 4L40 4L40 5L39 5L39 2L38 2L38 1L37 1L37 2L36 2L36 1L32 1L32 2L31 2L31 0L30 0L30 1L29 1L29 0L28 0L28 1L26 1L26 0L24 0L24 1L23 1L23 0L22 0L22 1L23 1L23 2L22 2L22 3L21 3L21 4L20 4L20 5L21 5L21 4L22 4L22 12L21 12L21 11L20 11L20 12L19 12L19 10L20 10L20 9L21 9L21 8L20 8L20 7L21 7L21 6L20 6L20 7L19 7L19 6L18 6L18 7L17 7L17 6L16 6L16 7L15 7L15 6L14 6L14 5L13 5L13 4L14 4L14 3L15 3L15 5L17 5L17 4L16 4L16 3L17 3L17 2L18 2L18 1L17 1L17 2L15 2L15 1L16 1L16 0L14 0L14 2L13 2L13 0ZM10 1L10 2L12 2L12 1ZM19 1L19 2L21 2L21 1ZM25 1L25 2L23 2L23 3L22 3L22 4L23 4L23 3L24 3L24 5L23 5L23 12L22 12L22 13L23 13L23 14L24 14L24 16L23 16L23 15L22 15L22 14L20 14L20 13L19 13L19 12L18 12L18 10L19 10L19 9L20 9L20 8L18 8L18 9L17 9L17 8L15 8L15 7L14 7L14 6L13 6L13 5L12 5L12 6L11 6L11 7L10 7L10 8L9 8L9 9L8 9L8 10L9 10L9 9L13 9L13 10L12 10L12 12L13 12L13 13L11 13L11 11L10 11L10 12L9 12L9 11L8 11L8 13L6 13L6 14L8 14L8 15L6 15L6 16L7 16L7 17L5 17L5 18L4 18L4 19L5 19L5 18L7 18L7 17L8 17L8 16L10 16L10 18L9 18L9 19L10 19L10 18L12 18L12 20L11 20L11 21L10 21L10 20L9 20L9 21L6 21L6 20L8 20L8 19L6 19L6 20L5 20L5 21L6 21L6 22L9 22L9 21L10 21L10 23L11 23L11 25L12 25L12 27L13 27L13 25L12 25L12 24L13 24L13 23L14 23L14 24L16 24L16 23L18 23L18 22L19 22L19 23L20 23L20 24L19 24L19 25L18 25L18 26L17 26L17 25L16 25L16 26L15 26L15 25L14 25L14 26L15 26L15 27L16 27L16 28L15 28L15 30L16 30L16 28L17 28L17 27L19 27L19 28L18 28L18 32L17 32L17 31L15 31L15 33L14 33L14 35L13 35L13 32L14 32L14 28L13 28L13 30L12 30L12 29L11 29L11 28L10 28L10 29L9 29L9 30L11 30L11 31L9 31L9 32L8 32L8 31L5 31L5 32L8 32L8 33L9 33L9 34L11 34L11 33L10 33L10 32L11 32L11 31L12 31L12 35L13 35L13 36L15 36L15 34L16 34L16 35L17 35L17 36L16 36L16 37L17 37L17 38L18 38L18 39L17 39L17 40L16 40L16 41L17 41L17 42L18 42L18 43L20 43L20 44L19 44L19 46L18 46L18 47L17 47L17 48L18 48L18 47L20 47L20 48L19 48L19 50L17 50L17 49L16 49L16 48L15 48L15 46L14 46L14 50L15 50L15 49L16 49L16 53L17 53L17 51L20 51L20 48L22 48L22 49L23 49L23 48L22 48L22 47L24 47L24 46L22 46L22 44L23 44L23 45L25 45L25 46L27 46L27 44L28 44L28 47L26 47L26 48L24 48L24 50L25 50L25 49L26 49L26 48L28 48L28 47L29 47L29 48L30 48L30 47L32 47L32 50L31 50L31 51L32 51L32 50L33 50L33 51L35 51L35 52L36 52L36 53L35 53L35 55L34 55L34 56L35 56L35 55L36 55L36 53L37 53L37 54L38 54L38 55L39 55L39 56L40 56L40 55L39 55L39 53L37 53L37 51L38 51L38 52L40 52L40 50L41 50L41 51L42 51L42 50L43 50L43 51L44 51L44 49L45 49L45 48L46 48L46 46L47 46L47 45L48 45L48 44L49 44L49 42L50 42L50 41L49 41L49 42L48 42L48 41L47 41L47 43L46 43L46 44L45 44L45 42L46 42L46 40L47 40L47 37L48 37L48 38L49 38L49 37L51 37L51 38L50 38L50 39L51 39L51 38L54 38L54 39L52 39L52 40L53 40L53 41L54 41L54 42L55 42L55 41L56 41L56 40L55 40L55 41L54 41L54 39L55 39L55 38L56 38L56 36L55 36L55 35L56 35L56 32L55 32L55 30L56 30L56 27L55 27L55 22L56 22L56 21L55 21L55 22L54 22L54 21L53 21L53 22L51 22L51 21L52 21L52 20L51 20L51 19L53 19L53 17L54 17L54 14L52 14L52 13L53 13L53 10L52 10L52 11L51 11L51 12L52 12L52 13L51 13L51 15L49 15L49 16L51 16L51 17L50 17L50 18L51 18L51 19L50 19L50 20L49 20L49 19L47 19L47 20L45 20L45 19L46 19L46 17L47 17L47 18L49 18L49 17L47 17L47 16L46 16L46 15L47 15L47 13L48 13L48 14L50 14L50 12L49 12L49 10L48 10L48 8L47 8L47 9L46 9L46 10L48 10L48 11L46 11L46 12L47 12L47 13L46 13L46 14L45 14L45 12L44 12L44 13L43 13L43 12L42 12L42 13L41 13L41 9L44 9L44 10L43 10L43 11L45 11L45 7L46 7L46 5L47 5L47 3L46 3L46 2L47 2L47 1L45 1L45 3L44 3L44 5L43 5L43 4L41 4L41 7L42 7L42 8L41 8L41 9L39 9L39 8L38 8L38 9L37 9L37 8L35 8L35 7L36 7L36 6L37 6L37 7L38 7L38 6L37 6L37 5L38 5L38 3L37 3L37 5L35 5L35 4L34 4L34 5L33 5L33 7L32 7L32 4L33 4L33 3L34 3L34 2L33 2L33 3L31 3L31 8L32 8L32 9L31 9L31 10L33 10L33 11L34 11L34 10L35 10L35 13L34 13L34 14L32 14L32 15L33 15L33 17L30 17L30 18L28 18L28 19L27 19L27 17L29 17L29 16L30 16L30 15L29 15L29 13L30 13L30 14L31 14L31 13L33 13L33 12L31 12L31 11L26 11L26 12L25 12L25 11L24 11L24 8L25 8L25 10L27 10L27 9L26 9L26 8L25 8L25 7L26 7L26 6L25 6L25 5L26 5L26 4L25 4L25 2L26 2L26 3L28 3L28 4L30 4L30 3L29 3L29 2L26 2L26 1ZM11 3L11 4L12 4L12 3ZM18 3L18 5L19 5L19 3ZM45 3L45 5L46 5L46 3ZM27 5L27 8L30 8L30 5ZM42 5L42 7L43 7L43 8L44 8L44 7L45 7L45 6L44 6L44 7L43 7L43 5ZM12 6L12 7L13 7L13 9L14 9L14 11L15 11L15 13L13 13L13 15L14 15L14 18L13 18L13 17L12 17L12 18L13 18L13 19L15 19L15 18L17 18L17 17L18 17L18 19L16 19L16 20L14 20L14 21L15 21L15 23L16 23L16 21L17 21L17 22L18 22L18 21L17 21L17 20L18 20L18 19L20 19L20 21L19 21L19 22L20 22L20 21L21 21L21 19L22 19L22 23L25 23L25 25L26 25L26 29L25 29L25 27L24 27L24 26L23 26L23 25L22 25L22 24L20 24L20 25L19 25L19 27L21 27L21 28L23 28L23 30L22 30L22 29L21 29L21 30L22 30L22 31L20 31L20 33L21 33L21 32L22 32L22 35L26 35L26 36L25 36L25 37L27 37L27 35L28 35L28 37L29 37L29 39L30 39L30 38L31 38L31 40L27 40L27 42L29 42L29 41L30 41L30 44L29 44L29 43L28 43L28 44L29 44L29 45L30 45L30 46L31 46L31 45L32 45L32 47L33 47L33 46L34 46L34 48L33 48L33 50L34 50L34 48L35 48L35 47L36 47L36 49L35 49L35 51L36 51L36 49L37 49L37 48L38 48L38 45L37 45L37 47L36 47L36 45L35 45L35 46L34 46L34 45L32 45L32 43L31 43L31 41L33 41L33 43L35 43L35 44L37 44L37 42L38 42L38 44L39 44L39 47L40 47L40 45L41 45L41 48L42 48L42 49L43 49L43 48L45 48L45 45L44 45L44 44L43 44L43 43L42 43L42 45L41 45L41 43L40 43L40 44L39 44L39 42L38 42L38 41L37 41L37 42L36 42L36 40L35 40L35 39L38 39L38 40L39 40L39 41L40 41L40 42L42 42L42 41L43 41L43 42L45 42L45 40L46 40L46 38L45 38L45 37L46 37L46 36L48 36L48 35L49 35L49 34L48 34L48 33L50 33L50 36L51 36L51 35L52 35L52 37L54 37L54 38L55 38L55 37L54 37L54 35L55 35L55 32L54 32L54 29L55 29L55 27L53 27L53 25L52 25L52 23L51 23L51 25L50 25L50 23L49 23L49 25L50 25L50 26L48 26L48 24L47 24L47 23L48 23L48 22L49 22L49 20L47 20L47 21L48 21L48 22L46 22L46 21L44 21L44 22L43 22L43 18L44 18L44 17L46 17L46 16L45 16L45 15L44 15L44 14L42 14L42 15L41 15L41 13L40 13L40 10L39 10L39 13L38 13L38 12L37 12L37 9L36 9L36 13L35 13L35 15L39 15L39 16L38 16L38 17L37 17L37 19L36 19L36 18L35 18L35 17L36 17L36 16L35 16L35 17L33 17L33 18L31 18L31 19L35 19L35 20L37 20L37 22L36 22L36 21L35 21L35 22L32 22L32 20L30 20L30 19L28 19L28 20L27 20L27 19L25 19L25 18L24 18L24 19L22 19L22 18L21 18L21 19L20 19L20 16L19 16L19 17L18 17L18 16L17 16L17 14L18 14L18 12L17 12L17 11L16 11L16 10L15 10L15 9L14 9L14 7L13 7L13 6ZM24 6L24 7L25 7L25 6ZM28 6L28 7L29 7L29 6ZM34 6L34 7L35 7L35 6ZM39 6L39 7L40 7L40 6ZM0 8L0 10L2 10L2 11L0 11L0 12L2 12L2 11L3 11L3 12L4 12L4 11L5 11L5 9L4 9L4 8ZM3 9L3 10L4 10L4 9ZM28 9L28 10L30 10L30 9ZM23 12L23 13L24 13L24 12ZM26 12L26 14L25 14L25 16L24 16L24 17L25 17L25 16L26 16L26 15L27 15L27 12ZM8 13L8 14L9 14L9 13ZM10 13L10 14L11 14L11 15L10 15L10 16L11 16L11 15L12 15L12 14L11 14L11 13ZM15 13L15 14L14 14L14 15L15 15L15 16L16 16L16 14L17 14L17 13ZM36 13L36 14L38 14L38 13ZM39 13L39 15L40 15L40 13ZM4 14L4 15L5 15L5 14ZM19 14L19 15L20 15L20 14ZM28 15L28 16L29 16L29 15ZM42 15L42 16L39 16L39 17L38 17L38 18L41 18L41 17L42 17L42 18L43 18L43 17L42 17L42 16L43 16L43 15ZM52 15L52 16L53 16L53 15ZM56 16L56 18L57 18L57 16ZM51 17L51 18L52 18L52 17ZM0 18L0 19L1 19L1 18ZM24 19L24 20L25 20L25 19ZM37 19L37 20L38 20L38 19ZM39 19L39 20L40 20L40 19ZM41 19L41 20L42 20L42 19ZM29 20L29 21L28 21L28 22L27 22L27 21L25 21L25 23L26 23L26 24L28 24L28 26L31 26L31 27L33 27L33 28L34 28L34 29L35 29L35 31L36 31L36 29L37 29L37 30L39 30L39 29L41 29L41 30L40 30L40 31L41 31L41 33L42 33L42 32L43 32L43 35L44 35L44 33L46 33L46 34L45 34L45 36L41 36L41 35L42 35L42 34L39 34L39 33L40 33L40 32L38 32L38 31L37 31L37 32L35 32L35 33L33 33L33 32L34 32L34 30L33 30L33 31L32 31L32 30L31 30L31 33L30 33L30 31L26 31L26 32L25 32L25 29L24 29L24 32L25 32L25 34L26 34L26 35L27 35L27 34L30 34L30 35L29 35L29 36L30 36L30 35L31 35L31 38L33 38L33 36L32 36L32 34L31 34L31 33L33 33L33 34L36 34L36 35L37 35L37 34L38 34L38 36L37 36L37 37L39 37L39 38L38 38L38 39L40 39L40 41L42 41L42 38L44 38L44 39L45 39L45 38L44 38L44 37L45 37L45 36L46 36L46 34L47 34L47 33L48 33L48 31L46 31L46 32L45 32L45 31L44 31L44 32L43 32L43 29L44 29L44 30L45 30L45 29L44 29L44 27L46 27L46 29L47 29L47 30L48 30L48 27L47 27L47 25L46 25L46 24L44 24L44 25L43 25L43 24L42 24L42 25L41 25L41 23L40 23L40 24L39 24L39 23L38 23L38 24L37 24L37 26L35 26L35 25L36 25L36 23L35 23L35 25L34 25L34 23L33 23L33 24L32 24L32 22L31 22L31 23L30 23L30 20ZM33 20L33 21L34 21L34 20ZM50 20L50 21L51 21L51 20ZM3 21L3 25L4 25L4 21ZM12 21L12 22L11 22L11 23L12 23L12 22L13 22L13 21ZM23 21L23 22L24 22L24 21ZM38 21L38 22L40 22L40 21ZM26 22L26 23L27 23L27 22ZM44 22L44 23L45 23L45 22ZM53 22L53 23L54 23L54 22ZM6 23L6 24L5 24L5 25L6 25L6 26L7 26L7 25L6 25L6 24L7 24L7 23ZM8 24L8 25L10 25L10 24ZM31 24L31 26L34 26L34 25L32 25L32 24ZM38 24L38 27L37 27L37 29L38 29L38 28L41 28L41 29L43 29L43 27L42 27L42 28L41 28L41 26L40 26L40 25L39 25L39 24ZM44 25L44 26L45 26L45 25ZM3 26L3 27L4 27L4 26ZM21 26L21 27L22 27L22 26ZM39 26L39 27L40 27L40 26ZM5 27L5 30L8 30L8 27ZM27 27L27 30L30 30L30 27ZM49 27L49 30L52 30L52 27ZM6 28L6 29L7 29L7 28ZM19 28L19 30L20 30L20 28ZM28 28L28 29L29 29L29 28ZM31 28L31 29L32 29L32 28ZM35 28L35 29L36 29L36 28ZM50 28L50 29L51 29L51 28ZM53 28L53 29L54 29L54 28ZM2 31L2 32L3 32L3 33L4 33L4 34L3 34L3 35L4 35L4 34L5 34L5 35L6 35L6 34L7 34L7 33L6 33L6 34L5 34L5 33L4 33L4 31ZM22 31L22 32L23 32L23 31ZM50 31L50 33L51 33L51 31ZM52 31L52 34L54 34L54 32L53 32L53 31ZM26 32L26 33L27 33L27 32ZM37 32L37 33L38 33L38 32ZM46 32L46 33L47 33L47 32ZM23 33L23 34L24 34L24 33ZM1 34L1 35L2 35L2 34ZM17 34L17 35L18 35L18 34ZM19 34L19 35L20 35L20 39L18 39L18 40L20 40L20 39L21 39L21 40L22 40L22 39L21 39L21 37L22 37L22 38L24 38L24 36L23 36L23 37L22 37L22 36L21 36L21 34ZM18 36L18 38L19 38L19 36ZM34 36L34 39L33 39L33 40L34 40L34 39L35 39L35 38L36 38L36 37L35 37L35 36ZM39 36L39 37L40 37L40 39L41 39L41 37L40 37L40 36ZM12 37L12 38L13 38L13 39L14 39L14 37ZM26 38L26 39L28 39L28 38ZM6 39L6 40L7 40L7 41L6 41L6 42L7 42L7 43L5 43L5 42L4 42L4 44L3 44L3 45L2 45L2 46L1 46L1 47L2 47L2 46L3 46L3 47L5 47L5 46L7 46L7 45L5 45L5 44L8 44L8 43L9 43L9 42L8 42L8 40L7 40L7 39ZM24 39L24 40L23 40L23 42L24 42L24 41L25 41L25 44L26 44L26 41L25 41L25 39ZM3 40L3 41L4 41L4 40ZM18 41L18 42L20 42L20 41ZM21 41L21 42L22 42L22 41ZM21 43L21 44L20 44L20 45L21 45L21 44L22 44L22 43ZM23 43L23 44L24 44L24 43ZM30 44L30 45L31 45L31 44ZM43 45L43 47L42 47L42 48L43 48L43 47L44 47L44 45ZM49 45L49 48L50 48L50 46L51 46L51 45ZM20 46L20 47L21 47L21 46ZM51 47L51 48L52 48L52 47ZM12 48L12 50L13 50L13 48ZM39 48L39 49L38 49L38 51L39 51L39 50L40 50L40 48ZM27 49L27 52L30 52L30 49ZM49 49L49 52L52 52L52 49ZM21 50L21 51L22 51L22 50ZM28 50L28 51L29 51L29 50ZM50 50L50 51L51 51L51 50ZM25 51L25 52L26 52L26 51ZM55 51L55 53L56 53L56 51ZM18 52L18 53L19 53L19 52ZM31 52L31 53L32 53L32 52ZM33 52L33 54L34 54L34 52ZM49 53L49 54L51 54L51 53ZM18 54L18 55L19 55L19 54ZM27 55L27 57L31 57L31 56L30 56L30 55L29 55L29 56L28 56L28 55ZM56 55L56 56L57 56L57 55ZM0 0L0 7L7 7L7 0ZM1 1L1 6L6 6L6 1ZM2 2L2 5L5 5L5 2ZM50 0L50 7L57 7L57 0ZM51 1L51 6L56 6L56 1ZM52 2L52 5L55 5L55 2ZM0 50L0 57L7 57L7 50ZM1 51L1 56L6 56L6 51ZM2 52L2 55L5 55L5 52Z\\\" fill=\\\"#000000\\\"\\/><\\/g><\\/g><\\/svg>\\n\\n                            <span style=\\\"width:50%;\\\">\\n                                <img style=\\\"max-height: 70px\\\"\\n                                     src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/img\\/AfipComprobanteAutorizado.png\\\">\\n                            <\\/span>\\n                        <\\/th>\\n                        <th style=\\\"text-align:right;\\\">\\n                            <p>CAE N&#186;: 71304902482577<br>\\n                                Fecha Vto. CAE:  25\\/07\\/2021\\n                            <\\/p>\\n                        <\\/th>\\n                    <\\/tr>\\n                <\\/table>\\n                    <\\/div>\\n    <\\/div>\\n\\n    <\\/body>\\n<\\/html>\\\";s:4:\\\"file\\\";N;}s:6:\\\"locale\\\";N;s:4:\\\"from\\\";a:0:{}s:2:\\\"to\\\";a:1:{i:0;a:2:{s:4:\\\"name\\\";N;s:7:\\\"address\\\";s:20:\\\"horusrioiv@gmail.com\\\";}}s:2:\\\"cc\\\";a:0:{}s:3:\\\"bcc\\\";a:1:{i:0;a:2:{s:4:\\\"name\\\";N;s:7:\\\"address\\\";s:23:\\\"info@masquecontable.com\\\";}}s:7:\\\"replyTo\\\";a:0:{}s:7:\\\"subject\\\";N;s:11:\\\"\\u0000*\\u0000markdown\\\";N;s:7:\\\"\\u0000*\\u0000html\\\";N;s:4:\\\"view\\\";N;s:8:\\\"textView\\\";N;s:8:\\\"viewData\\\";a:0:{}s:11:\\\"attachments\\\";a:0:{}s:14:\\\"rawAttachments\\\";a:0:{}s:15:\\\"diskAttachments\\\";a:0:{}s:9:\\\"callbacks\\\";a:0:{}s:5:\\\"theme\\\";N;s:6:\\\"mailer\\\";s:8:\\\"sendgrid\\\";s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:5:\\\"delay\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;}\"}}','ErrorException: Trying to get property \'id\' of non-object in /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php:16\nStack trace:\n#0 /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php(16): Illuminate\\Foundation\\Bootstrap\\HandleExceptions->handleError(8, \'Trying to get p...\', \'/home/forge/tax...\', 16, Array)\n#1 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(356): App\\Queue\\DatabaseJob->fire()\n#2 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(306): Illuminate\\Queue\\Worker->process(\'database\', Object(App\\Queue\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#3 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(132): Illuminate\\Queue\\Worker->runJob(Object(App\\Queue\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#4 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(112): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#5 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(96): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#6 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#7 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#8 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#9 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#10 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#11 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(134): Illuminate\\Container\\Container->call(Array)\n#12 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(256): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#13 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(121): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#14 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(971): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#15 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(290): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#16 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(166): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#17 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Application.php(93): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(129): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#19 /home/forge/taxes.com.ar/artisan(35): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#20 {main}','2021-07-23 18:04:10',NULL);
INSERT INTO `failed_jobs` VALUES (13,NULL,'database','default','{\"uuid\":\"5e06062b-a5b6-4ec2-9624-546595160ce6\",\"displayName\":\"App\\\\Mail\\\\Fact_Electronica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"delay\":null,\"timeout\":null,\"timeoutAt\":null,\"data\":{\"commandName\":\"Illuminate\\\\Mail\\\\SendQueuedMailable\",\"command\":\"O:34:\\\"Illuminate\\\\Mail\\\\SendQueuedMailable\\\":3:{s:8:\\\"mailable\\\";O:25:\\\"App\\\\Mail\\\\Fact_Electronica\\\":27:{s:11:\\\"informacion\\\";a:6:{s:12:\\\"ruta_logo_fa\\\";N;s:4:\\\"mail\\\";s:23:\\\"info@masquecontable.com\\\";s:18:\\\"name_quien_factura\\\";s:19:\\\"MICAELA AILIN CORIA\\\";s:7:\\\"cliente\\\";O:17:\\\"App\\\\Models\\\\Person\\\":27:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:7:\\\"persons\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:40803;s:7:\\\"user_id\\\";i:5115;s:11:\\\"field_name1\\\";s:18:\\\"IACOBELLI VIRGINIA\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-28596463-1\\\";s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-07-09 10:46:07\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-07-09 10:46:07\\\";s:11:\\\"activity_id\\\";i:1;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";i:1;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:40803;s:7:\\\"user_id\\\";i:5115;s:11:\\\"field_name1\\\";s:18:\\\"IACOBELLI VIRGINIA\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-28596463-1\\\";s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-07-09 10:46:07\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-07-09 10:46:07\\\";s:11:\\\"activity_id\\\";i:1;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";i:1;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}s:14:\\\"nombre_del_pdf\\\";s:28:\\\"Factura N\\u00b00004-00000016.pdf\\\";s:9:\\\"body_mail\\\";s:155:\\\"Estimado cliente, se env\\u00eda adjunta la factura de honorarios correspondientes al mes de Julio 2021.\\nMuchas gracias por seguir eligiendo nuestros servicios.\\\";}s:3:\\\"pdf\\\";O:26:\\\"Barryvdh\\\\Snappy\\\\PdfWrapper\\\":4:{s:9:\\\"\\u0000*\\u0000snappy\\\";O:35:\\\"Barryvdh\\\\Snappy\\\\IlluminateSnappyPdf\\\":10:{s:26:\\\"\\u0000*\\u0000optionsWithContentCheck\\\";a:4:{s:11:\\\"header-html\\\";s:4:\\\"html\\\";s:11:\\\"footer-html\\\";s:4:\\\"html\\\";s:5:\\\"cover\\\";s:4:\\\"html\\\";s:15:\\\"xsl-style-sheet\\\";s:3:\\\"xsl\\\";}s:36:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000binary\\\";s:76:\\\"\\/home\\/forge\\/taxes.com.ar\\/vendor\\/h4cc\\/wkhtmltopdf-amd64\\/bin\\/wkhtmltopdf-amd64\\\";s:37:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000options\\\";a:132:{s:7:\\\"collate\\\";N;s:10:\\\"no-collate\\\";N;s:10:\\\"cookie-jar\\\";N;s:6:\\\"copies\\\";i:1;s:3:\\\"dpi\\\";N;s:13:\\\"extended-help\\\";N;s:9:\\\"grayscale\\\";N;s:4:\\\"help\\\";N;s:7:\\\"htmldoc\\\";N;s:18:\\\"ignore-load-errors\\\";N;s:9:\\\"image-dpi\\\";N;s:13:\\\"image-quality\\\";N;s:7:\\\"license\\\";N;s:9:\\\"log-level\\\";N;s:10:\\\"lowquality\\\";b:1;s:7:\\\"manpage\\\";N;s:13:\\\"margin-bottom\\\";N;s:11:\\\"margin-left\\\";N;s:12:\\\"margin-right\\\";N;s:10:\\\"margin-top\\\";N;s:11:\\\"orientation\\\";N;s:11:\\\"page-height\\\";N;s:9:\\\"page-size\\\";s:2:\\\"a4\\\";s:10:\\\"page-width\\\";N;s:18:\\\"no-pdf-compression\\\";N;s:5:\\\"quiet\\\";N;s:20:\\\"read-args-from-stdin\\\";N;s:6:\\\"readme\\\";N;s:5:\\\"title\\\";N;s:11:\\\"use-xserver\\\";N;s:7:\\\"version\\\";N;s:20:\\\"dump-default-toc-xsl\\\";N;s:12:\\\"dump-outline\\\";N;s:7:\\\"outline\\\";N;s:10:\\\"no-outline\\\";N;s:13:\\\"outline-depth\\\";N;s:13:\\\"output-format\\\";N;s:5:\\\"allow\\\";N;s:10:\\\"background\\\";N;s:13:\\\"no-background\\\";N;s:16:\\\"bypass-proxy-for\\\";N;s:9:\\\"cache-dir\\\";N;s:20:\\\"checkbox-checked-svg\\\";N;s:12:\\\"checkbox-svg\\\";N;s:6:\\\"cookie\\\";N;s:13:\\\"custom-header\\\";N;s:25:\\\"custom-header-propagation\\\";N;s:28:\\\"no-custom-header-propagation\\\";N;s:16:\\\"debug-javascript\\\";N;s:19:\\\"no-debug-javascript\\\";N;s:14:\\\"default-header\\\";N;s:8:\\\"encoding\\\";N;s:22:\\\"disable-external-links\\\";N;s:21:\\\"enable-external-links\\\";N;s:13:\\\"disable-forms\\\";N;s:12:\\\"enable-forms\\\";N;s:6:\\\"images\\\";N;s:9:\\\"no-images\\\";N;s:22:\\\"disable-internal-links\\\";N;s:21:\\\"enable-internal-links\\\";N;s:18:\\\"disable-javascript\\\";N;s:17:\\\"enable-javascript\\\";N;s:16:\\\"javascript-delay\\\";N;s:19:\\\"keep-relative-links\\\";N;s:19:\\\"load-error-handling\\\";N;s:25:\\\"load-media-error-handling\\\";N;s:25:\\\"disable-local-file-access\\\";N;s:24:\\\"enable-local-file-access\\\";N;s:17:\\\"minimum-font-size\\\";N;s:20:\\\"exclude-from-outline\\\";N;s:18:\\\"include-in-outline\\\";N;s:11:\\\"page-offset\\\";N;s:8:\\\"password\\\";N;s:15:\\\"disable-plugins\\\";N;s:14:\\\"enable-plugins\\\";N;s:4:\\\"post\\\";N;s:9:\\\"post-file\\\";N;s:16:\\\"print-media-type\\\";N;s:19:\\\"no-print-media-type\\\";N;s:5:\\\"proxy\\\";N;s:21:\\\"proxy-hostname-lookup\\\";N;s:23:\\\"radiobutton-checked-svg\\\";N;s:15:\\\"radiobutton-svg\\\";N;s:14:\\\"redirect-delay\\\";N;s:22:\\\"resolve-relative-links\\\";N;s:10:\\\"run-script\\\";N;s:23:\\\"disable-smart-shrinking\\\";N;s:22:\\\"enable-smart-shrinking\\\";N;s:12:\\\"ssl-crt-path\\\";N;s:16:\\\"ssl-key-password\\\";N;s:12:\\\"ssl-key-path\\\";N;s:17:\\\"stop-slow-scripts\\\";N;s:20:\\\"no-stop-slow-scripts\\\";N;s:22:\\\"disable-toc-back-links\\\";N;s:21:\\\"enable-toc-back-links\\\";N;s:16:\\\"user-style-sheet\\\";N;s:8:\\\"username\\\";N;s:13:\\\"viewport-size\\\";N;s:13:\\\"window-status\\\";N;s:4:\\\"zoom\\\";N;s:13:\\\"footer-center\\\";s:25:\\\"Pagina [page] de [toPage]\\\";s:16:\\\"footer-font-name\\\";N;s:16:\\\"footer-font-size\\\";i:8;s:11:\\\"footer-html\\\";N;s:11:\\\"footer-left\\\";s:0:\\\"\\\";s:11:\\\"footer-line\\\";N;s:14:\\\"no-footer-line\\\";N;s:12:\\\"footer-right\\\";N;s:14:\\\"footer-spacing\\\";N;s:13:\\\"header-center\\\";N;s:16:\\\"header-font-name\\\";N;s:16:\\\"header-font-size\\\";N;s:11:\\\"header-html\\\";N;s:11:\\\"header-left\\\";N;s:11:\\\"header-line\\\";N;s:14:\\\"no-header-line\\\";N;s:12:\\\"header-right\\\";N;s:14:\\\"header-spacing\\\";N;s:7:\\\"replace\\\";N;s:5:\\\"cover\\\";N;s:3:\\\"toc\\\";N;s:20:\\\"disable-dotted-lines\\\";N;s:9:\\\"toc-depth\\\";N;s:13:\\\"toc-font-name\\\";N;s:16:\\\"toc-l1-font-size\\\";N;s:15:\\\"toc-header-text\\\";N;s:20:\\\"toc-header-font-name\\\";N;s:20:\\\"toc-header-font-size\\\";N;s:21:\\\"toc-level-indentation\\\";N;s:17:\\\"disable-toc-links\\\";N;s:20:\\\"toc-text-size-shrink\\\";N;s:15:\\\"xsl-style-sheet\\\";N;}s:33:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000env\\\";N;s:37:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000timeout\\\";b:0;s:46:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000defaultExtension\\\";s:3:\\\"pdf\\\";s:18:\\\"\\u0000*\\u0000temporaryFolder\\\";N;s:14:\\\"temporaryFiles\\\";a:0:{}s:36:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000logger\\\";O:18:\\\"Psr\\\\Log\\\\NullLogger\\\":0:{}s:2:\\\"fs\\\";O:32:\\\"Illuminate\\\\Filesystem\\\\Filesystem\\\":0:{}}s:10:\\\"\\u0000*\\u0000options\\\";a:0:{}s:4:\\\"html\\\";s:22604:\\\"<!DOCTYPE html>\\n<html lang=\\\"en\\\">\\n    <head>\\n        <meta charset=\\\"utf-8\\\">\\n    <\\/head>\\n    <style>\\n        .subtotales_conceptos{\\n            width:30%;\\n            text-align: right;\\n        }\\n        .subtotales_importes{\\n            text-align: right;\\n        }\\n        .table-totales, .table-totales tr, .table-totales th{\\n            border: 1px solid;\\n        }\\n\\n    <\\/style>\\n    <body>\\n    <div style=\\\"max-height:840px\\\">\\n        <div style=\\\"width: 100%; height:270px\\\"> <!-- Datos de la empresa -->\\n            <table class=\\\"display\\\" cellspacing=\\\"0\\\" width=\\\"100%\\\" style=\\\"border:  1px solid;\\\">\\n                <tr style=\\\"\\\">\\n                    <th colspan=\\\"2\\\" rowspan=\\\"2\\\" style=\\\"width:45%;margin:0;height:150px;\\\">\\n                                                <img src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/img\\/\\/27377183504\\/logo_punto_venta_0000.png\\\"\\/>\\n                                            <\\/th>\\n                    <th style=\\\"border:  1px solid;text-align: center; width:10%\\\" colspan=\\\"2\\\">\\n                        <span style=\\\"font-size: 60px;\\\">C<\\/span> <br \\/> <span style=\\\"font-size: 14px;\\\">cod. 11<\\/span>\\n                    <\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"font-size: 28px;text-align: center;width:45%\\\">\\n                        Factura\\n                        <br>\\n                        0004 - 00000016\\n                    <\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th><\\/th>\\n                    <th style=\\\"border:  1px 1px 1px 0px solid;\\\" colspan=\\\"2\\\"><\\/th>\\n                    <th><\\/th>\\n                <\\/tr>\\n                <tr>\\n\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                                                    Raz&oacute;n Social:\\n                            <span style=\\\"font-weight: normal;\\\">MICAELA AILIN CORIA<\\/span>\\n                                            <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">Fecha de Emisi&oacute;n: <span style=\\\"font-weight: normal;\\\">15\\/07\\/2021<\\/span><\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Domicilio Comercial: <span style=\\\"font-weight: normal;\\\">Victor Guillet esq. Arturo M Bas, C.P.:5800,\\n                        C\\u00f3rdoba<\\/span>\\n                    <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">CUIT: <span style=\\\"font-weight: normal;\\\">27-37718350-4<\\/span><\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Condici&oacute;n frente al IVA: <span style=\\\"font-weight: normal;\\\">Monotributo<\\/span>\\n                    <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Ingresos Brutos: <span style=\\\"font-weight: normal;\\\"><\\/span>\\n                        <br>\\n                        Fecha de Inicio de Actividades: <span style=\\\"font-weight: normal;\\\">09\\/07\\/2021<\\/span>\\n                    <\\/th>\\n                <\\/tr>\\n            <\\/table>\\n        <\\/div>\\n\\n        <table style=\\\"text-align: center; width: 100%;border: solid 1px;\\\"> <!-- Fechas -->\\n            <thead>\\n                <tr>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Per\\u00edodo Facturado Desde: 01\\/07\\/2021<\\/small><\\/th>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Per\\u00edodo Facturado Hasta: 31\\/07\\/2021<\\/small><\\/th>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Fecha Vto. Pago: 15\\/07\\/2021<\\/small><\\/th>\\n                <\\/tr>\\n            <\\/thead>\\n        <\\/table>\\n        \\n        <table style=\\\"width: 100%; margin-top: 1%;border: solid 1px;\\\"> <!-- Datos Clientes -->\\n            <tr>\\n                <th style=\\\"text-align:left;\\\"colspan=\\\"12\\\">\\n                    CUIT: <span style=\\\"font-weight: normal;\\\">27-28596463-1<\\/span>\\n                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\\n                    Apellido y Nombre \\/ Raz&oacute;n Social: <span style=\\\"font-weight: normal;\\\">\\n                    IACOBELLI VIRGINIA<\\/span>\\n                <\\/th>\\n            <\\/tr>\\n            <tr>\\n                <th style=\\\"text-align:left; width:50%\\\">\\n                    Condici&oacute;n Frente al IVA: <span style=\\\"font-weight: normal;\\\">Consumidor Final<\\/span>\\n                <\\/th>\\n                <th style=\\\"text-align:left; width:50%\\\" colspan=\\\"4\\\">\\n                    Domicilio Comercial:\\n                    <span style=\\\"font-weight: normal;\\\">\\n                    --------\\n                    <\\/span>\\n                <\\/th>\\n            <\\/tr>\\n            <tr style=\\\"text-align:left\\\">\\n                <th>Condici&oacute;n de Venta: <span style=\\\"font-weight: normal;\\\">Cuenta Corriente<\\/span><\\/th>\\n            <\\/tr>\\n        <\\/table>\\n\\n        <div style=\\\"border: 1px solid;margin-top: 1%;min-height:600px;\\\">\\n        <table style=\\\"text-align: center; width: 100%; margin-top: 1%;\\\"> <!-- Body -->\\n            <tr style=\\\"border-bottom: 1px solid;font-size: 15px\\\">\\n                <th>C&oacute;digo<\\/th>\\n                <th style=\\\"width: 25%;\\\">Detalle<\\/th>\\n                <th>Cantidad<\\/th>\\n                <th>U.Medida<\\/th>\\n                <th>Precio U.<\\/th>\\n                <th>Bonif. (%)<\\/th>\\n                <th>Precio Bonif.<\\/th>\\n                <th>Subtotal<\\/th>\\n                            <\\/tr>\\n            <tbody>\\n                                                                                <tr style=\\\"font-size: 12px;\\\">\\n                        <td>\\n                            \\n                        <\\/td>\\n                        <td>\\n                            Honorarios profesionales Julio 2021\\n                        <\\/td>\\n                        <td>\\n                            1.00\\n                        <\\/td>\\n                        <td>\\n                            Unidades\\n                        <\\/td>\\n                        <td>                            1.700,00\\n                                                    <\\/td>\\n                        <td>\\n                            0,00%\\n                        <\\/td>\\n                        <td>\\n                            0,00\\n                        <\\/td>\\n                        <td>\\n                            1.700,00\\n                        <\\/td>\\n                                            <\\/tr>\\n                    \\n            <\\/tbody>\\n        <\\/table>\\n        <\\/div>\\n\\n        \\n\\n        <div style=\\\"height:200px;margin-top: 1%;\\\"> <!-- Totales -->\\n              <!-- Es factura B o C -->\\n                <table class=\\\"table-totales\\\" cellspacing=\\\"0\\\" width=\\\"100%\\\">\\n                    <tr>\\n                        <th style=\\\"width:50%; text-align:left;\\\">\\n\\n<!--                                <span style=\\\"width:100%;\\\"><img src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/barcodes\\/71304902484304.png\\\"><\\/span>\\n                                <span style=\\\"text-align:center;\\\">2737718350411000471304902484304202107257<\\/span>-->\\n                        <\\/th>\\n                        <th class=\\\"subtotales_conceptos\\\">TOTAL:<\\/th>\\n                        <th class=\\\"subtotales_importes\\\">$ 1.700,00<\\/th>\\n                    <\\/tr>\\n                <\\/table>\\n                <br>\\n                <table cellspacing=\\\"0\\\" width=\\\"100%\\\" style=\\\"border: none\\\">\\n                    <tr>\\n                        <th style=\\\"width:50%; text-align:left;\\\">\\n\\n                            <?xml version=\\\"1.0\\\" encoding=\\\"UTF-8\\\"?>\\n<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" version=\\\"1.1\\\" width=\\\"100\\\" height=\\\"100\\\" viewBox=\\\"0 0 100 100\\\"><rect x=\\\"0\\\" y=\\\"0\\\" width=\\\"100\\\" height=\\\"100\\\" fill=\\\"#ffffff\\\"\\/><g transform=\\\"scale(1.754)\\\"><g transform=\\\"translate(0,0)\\\"><path fill-rule=\\\"evenodd\\\" d=\\\"M12 0L12 1L11 1L11 2L10 2L10 1L8 1L8 2L10 2L10 5L8 5L8 7L9 7L9 6L10 6L10 7L11 7L11 5L12 5L12 3L13 3L13 4L14 4L14 5L15 5L15 6L14 6L14 7L13 7L13 6L12 6L12 9L11 9L11 8L6 8L6 9L5 9L5 8L0 8L0 10L1 10L1 9L5 9L5 11L4 11L4 10L3 10L3 13L1 13L1 12L0 12L0 13L1 13L1 15L3 15L3 16L4 16L4 17L3 17L3 19L4 19L4 20L2 20L2 17L1 17L1 16L0 16L0 21L1 21L1 20L2 20L2 21L3 21L3 23L2 23L2 22L0 22L0 28L2 28L2 29L3 29L3 28L4 28L4 30L2 30L2 31L1 31L1 32L0 32L0 34L3 34L3 35L4 35L4 36L3 36L3 38L4 38L4 39L2 39L2 37L1 37L1 38L0 38L0 40L2 40L2 41L3 41L3 40L4 40L4 41L5 41L5 45L4 45L4 44L3 44L3 43L4 43L4 42L3 42L3 43L2 43L2 42L1 42L1 41L0 41L0 42L1 42L1 43L0 43L0 44L1 44L1 46L0 46L0 48L5 48L5 47L7 47L7 48L6 48L6 49L8 49L8 51L9 51L9 52L8 52L8 57L11 57L11 56L12 56L12 57L13 57L13 53L15 53L15 54L16 54L16 53L15 53L15 52L16 52L16 51L17 51L17 52L18 52L18 53L17 53L17 56L16 56L16 55L15 55L15 57L19 57L19 56L18 56L18 53L22 53L22 54L21 54L21 56L20 56L20 57L22 57L22 54L23 54L23 55L25 55L25 56L23 56L23 57L26 57L26 56L27 56L27 55L25 55L25 53L26 53L26 54L29 54L29 53L30 53L30 54L31 54L31 52L33 52L33 53L32 53L32 54L33 54L33 55L35 55L35 54L34 54L34 53L35 53L35 51L37 51L37 52L36 52L36 53L37 53L37 54L36 54L36 56L35 56L35 57L37 57L37 55L38 55L38 51L40 51L40 52L41 52L41 54L44 54L44 56L45 56L45 57L46 57L46 56L47 56L47 57L52 57L52 55L51 55L51 56L49 56L49 55L50 55L50 54L48 54L48 53L52 53L52 54L53 54L53 52L55 52L55 50L57 50L57 48L56 48L56 46L57 46L57 43L56 43L56 46L54 46L54 44L55 44L55 41L54 41L54 40L56 40L56 39L55 39L55 38L54 38L54 36L55 36L55 35L53 35L53 34L52 34L52 33L53 33L53 32L52 32L52 33L50 33L50 34L52 34L52 35L47 35L47 34L48 34L48 33L47 33L47 34L46 34L46 32L45 32L45 31L47 31L47 32L48 32L48 31L49 31L49 32L51 32L51 31L54 31L54 32L55 32L55 33L54 33L54 34L55 34L55 33L56 33L56 34L57 34L57 32L56 32L56 30L57 30L57 29L54 29L54 28L55 28L55 26L57 26L57 25L56 25L56 24L57 24L57 23L56 23L56 22L57 22L57 21L56 21L56 22L55 22L55 21L54 21L54 20L55 20L55 19L54 19L54 16L55 16L55 15L56 15L56 14L57 14L57 13L56 13L56 14L55 14L55 13L54 13L54 12L55 12L55 10L57 10L57 9L56 9L56 8L55 8L55 10L54 10L54 11L51 11L51 10L49 10L49 9L50 9L50 8L49 8L49 6L48 6L48 8L49 8L49 9L48 9L48 12L49 12L49 11L50 11L50 13L51 13L51 14L50 14L50 16L49 16L49 15L48 15L48 14L49 14L49 13L48 13L48 14L45 14L45 13L47 13L47 10L46 10L46 9L45 9L45 10L44 10L44 8L45 8L45 6L46 6L46 8L47 8L47 5L48 5L48 0L45 0L45 2L44 2L44 1L43 1L43 0L39 0L39 1L36 1L36 2L35 2L35 1L34 1L34 2L32 2L32 3L33 3L33 4L37 4L37 3L36 3L36 2L38 2L38 4L39 4L39 5L38 5L38 7L37 7L37 5L36 5L36 7L37 7L37 8L36 8L36 10L33 10L33 11L32 11L32 10L31 10L31 6L32 6L32 8L33 8L33 9L35 9L35 8L34 8L34 7L35 7L35 5L31 5L31 3L30 3L30 2L29 2L29 0L28 0L28 2L27 2L27 3L25 3L25 2L24 2L24 3L23 3L23 4L22 4L22 1L23 1L23 0L22 0L22 1L21 1L21 6L20 6L20 5L18 5L18 4L19 4L19 3L20 3L20 1L18 1L18 4L16 4L16 3L15 3L15 2L16 2L16 0L14 0L14 1L15 1L15 2L14 2L14 3L13 3L13 0ZM24 0L24 1L26 1L26 0ZM30 0L30 1L31 1L31 0ZM40 1L40 2L42 2L42 3L44 3L44 4L45 4L45 5L44 5L44 6L43 6L43 5L39 5L39 7L38 7L38 8L37 8L37 10L36 10L36 11L33 11L33 12L32 12L32 11L31 11L31 10L30 10L30 9L28 9L28 10L27 10L27 9L25 9L25 8L22 8L22 9L20 9L20 10L19 10L19 9L15 9L15 8L16 8L16 6L15 6L15 8L13 8L13 11L14 11L14 12L13 12L13 13L10 13L10 12L11 12L11 11L12 11L12 10L11 10L11 11L8 11L8 10L7 10L7 9L6 9L6 10L7 10L7 11L6 11L6 12L8 12L8 13L6 13L6 14L5 14L5 13L3 13L3 15L6 15L6 16L5 16L5 17L4 17L4 19L5 19L5 20L4 20L4 21L6 21L6 22L5 22L5 24L7 24L7 25L4 25L4 23L3 23L3 24L2 24L2 23L1 23L1 27L2 27L2 26L7 26L7 25L8 25L8 26L9 26L9 27L11 27L11 26L12 26L12 24L15 24L15 23L16 23L16 24L17 24L17 21L18 21L18 24L19 24L19 25L20 25L20 26L19 26L19 28L21 28L21 27L22 27L22 29L19 29L19 30L18 30L18 31L16 31L16 32L17 32L17 33L15 33L15 34L14 34L14 31L15 31L15 27L14 27L14 26L13 26L13 27L14 27L14 30L13 30L13 28L12 28L12 30L13 30L13 33L11 33L11 34L10 34L10 35L8 35L8 34L7 34L7 33L9 33L9 32L12 32L12 31L11 31L11 30L10 30L10 29L11 29L11 28L9 28L9 30L10 30L10 31L8 31L8 32L7 32L7 31L2 31L2 32L4 32L4 35L5 35L5 36L7 36L7 35L8 35L8 36L11 36L11 37L8 37L8 38L7 38L7 37L4 37L4 38L5 38L5 39L6 39L6 40L5 40L5 41L6 41L6 42L7 42L7 43L6 43L6 44L7 44L7 45L5 45L5 46L3 46L3 44L2 44L2 43L1 43L1 44L2 44L2 46L1 46L1 47L2 47L2 46L3 46L3 47L5 47L5 46L11 46L11 47L10 47L10 48L9 48L9 49L10 49L10 52L9 52L9 54L10 54L10 53L11 53L11 52L12 52L12 53L13 53L13 52L14 52L14 51L16 51L16 50L17 50L17 51L18 51L18 50L22 50L22 51L23 51L23 52L22 52L22 53L23 53L23 54L24 54L24 53L25 53L25 52L26 52L26 50L24 50L24 49L26 49L26 48L27 48L27 47L28 47L28 48L32 48L32 49L33 49L33 50L36 50L36 48L37 48L37 50L40 50L40 51L43 51L43 50L45 50L45 48L44 48L44 47L45 47L45 46L47 46L47 47L46 47L46 48L47 48L47 49L46 49L46 50L47 50L47 49L48 49L48 48L49 48L49 47L52 47L52 48L54 48L54 49L56 49L56 48L54 48L54 47L52 47L52 46L53 46L53 45L52 45L52 44L53 44L53 43L54 43L54 42L53 42L53 41L52 41L52 42L50 42L50 43L51 43L51 45L50 45L50 44L47 44L47 43L49 43L49 40L47 40L47 39L51 39L51 38L50 38L50 37L52 37L52 39L53 39L53 40L54 40L54 39L53 39L53 37L52 37L52 36L53 36L53 35L52 35L52 36L50 36L50 37L48 37L48 36L47 36L47 35L46 35L46 38L45 38L45 36L44 36L44 35L45 35L45 34L44 34L44 33L45 33L45 32L44 32L44 33L43 33L43 32L40 32L40 31L43 31L43 30L48 30L48 29L47 29L47 28L48 28L48 27L46 27L46 28L44 28L44 27L45 27L45 25L46 25L46 26L48 26L48 25L49 25L49 26L52 26L52 25L55 25L55 24L56 24L56 23L55 23L55 22L54 22L54 23L53 23L53 22L52 22L52 23L50 23L50 22L51 22L51 21L49 21L49 20L48 20L48 19L49 19L49 18L51 18L51 20L52 20L52 21L53 21L53 20L52 20L52 19L53 19L53 16L54 16L54 15L55 15L55 14L54 14L54 13L53 13L53 12L52 12L52 13L53 13L53 16L52 16L52 15L51 15L51 16L50 16L50 17L49 17L49 16L46 16L46 15L45 15L45 14L44 14L44 13L45 13L45 12L46 12L46 10L45 10L45 12L44 12L44 10L41 10L41 9L42 9L42 6L43 6L43 7L44 7L44 6L45 6L45 5L47 5L47 3L46 3L46 4L45 4L45 3L44 3L44 2L43 2L43 1ZM46 1L46 2L47 2L47 1ZM34 2L34 3L35 3L35 2ZM8 3L8 4L9 4L9 3ZM14 3L14 4L15 4L15 5L16 5L16 4L15 4L15 3ZM24 3L24 4L23 4L23 5L22 5L22 6L21 6L21 7L22 7L22 6L23 6L23 7L24 7L24 4L25 4L25 7L26 7L26 4L25 4L25 3ZM28 3L28 4L30 4L30 3ZM39 3L39 4L41 4L41 3ZM17 5L17 8L19 8L19 7L20 7L20 6L19 6L19 7L18 7L18 5ZM27 5L27 8L30 8L30 5ZM28 6L28 7L29 7L29 6ZM33 6L33 7L34 7L34 6ZM40 6L40 8L41 8L41 6ZM51 8L51 9L52 9L52 10L53 10L53 9L54 9L54 8L53 8L53 9L52 9L52 8ZM14 9L14 10L15 10L15 9ZM22 9L22 10L20 10L20 11L19 11L19 13L18 13L18 12L15 12L15 15L14 15L14 16L15 16L15 15L16 15L16 17L17 17L17 15L16 15L16 13L18 13L18 15L19 15L19 13L22 13L22 14L21 14L21 15L22 15L22 14L23 14L23 17L22 17L22 16L18 16L18 17L21 17L21 20L19 20L19 19L20 19L20 18L18 18L18 21L19 21L19 22L20 22L20 23L21 23L21 24L20 24L20 25L22 25L22 26L23 26L23 28L25 28L25 27L26 27L26 30L25 30L25 29L22 29L22 31L24 31L24 32L23 32L23 33L22 33L22 32L19 32L19 31L18 31L18 33L22 33L22 34L21 34L21 35L20 35L20 34L18 34L18 37L16 37L16 36L15 36L15 35L14 35L14 34L12 34L12 35L11 35L11 36L12 36L12 37L13 37L13 38L10 38L10 39L7 39L7 38L6 38L6 39L7 39L7 40L6 40L6 41L8 41L8 42L9 42L9 41L10 41L10 42L11 42L11 41L12 41L12 40L13 40L13 44L14 44L14 47L17 47L17 46L16 46L16 45L18 45L18 47L19 47L19 45L22 45L22 46L21 46L21 48L20 48L20 49L22 49L22 50L23 50L23 49L24 49L24 46L25 46L25 47L26 47L26 46L25 46L25 45L26 45L26 44L28 44L28 45L27 45L27 46L28 46L28 45L30 45L30 46L29 46L29 47L31 47L31 44L33 44L33 45L32 45L32 46L33 46L33 49L34 49L34 47L35 47L35 46L36 46L36 47L39 47L39 49L40 49L40 48L42 48L42 49L41 49L41 50L43 50L43 47L39 47L39 46L40 46L40 45L39 45L39 46L38 46L38 44L36 44L36 45L35 45L35 44L34 44L34 43L37 43L37 40L36 40L36 41L35 41L35 39L36 39L36 37L37 37L37 38L38 38L38 37L37 37L37 36L36 36L36 35L39 35L39 39L38 39L38 41L39 41L39 42L38 42L38 43L39 43L39 44L42 44L42 43L39 43L39 42L40 42L40 41L39 41L39 40L40 40L40 38L43 38L43 37L40 37L40 36L42 36L42 34L43 34L43 33L40 33L40 32L39 32L39 34L36 34L36 35L35 35L35 34L34 34L34 35L35 35L35 38L34 38L34 41L35 41L35 42L33 42L33 43L31 43L31 42L32 42L32 40L33 40L33 37L34 37L34 36L33 36L33 35L31 35L31 34L33 34L33 33L32 33L32 32L35 32L35 30L34 30L34 31L33 31L33 29L32 29L32 32L31 32L31 34L30 34L30 35L31 35L31 36L28 36L28 35L29 35L29 34L28 34L28 35L27 35L27 34L25 34L25 33L29 33L29 32L30 32L30 31L31 31L31 28L33 28L33 27L35 27L35 26L33 26L33 27L32 27L32 24L34 24L34 25L35 25L35 24L34 24L34 23L35 23L35 22L36 22L36 21L37 21L37 23L38 23L38 21L39 21L39 20L41 20L41 21L40 21L40 24L41 24L41 26L42 26L42 28L43 28L43 27L44 27L44 26L43 26L43 25L44 25L44 24L46 24L46 23L47 23L47 22L46 22L46 21L48 21L48 24L47 24L47 25L48 25L48 24L49 24L49 25L50 25L50 24L49 24L49 21L48 21L48 20L47 20L47 19L48 19L48 18L49 18L49 17L48 17L48 18L46 18L46 17L45 17L45 18L46 18L46 20L45 20L45 19L44 19L44 20L43 20L43 21L42 21L42 19L43 19L43 17L44 17L44 16L45 16L45 15L43 15L43 17L42 17L42 15L40 15L40 14L43 14L43 13L44 13L44 12L43 12L43 13L42 13L42 11L40 11L40 12L39 12L39 14L38 14L38 15L39 15L39 18L37 18L37 16L36 16L36 18L32 18L32 16L33 16L33 17L34 17L34 16L33 16L33 15L36 15L36 14L37 14L37 13L38 13L38 11L39 11L39 10L38 10L38 11L37 11L37 12L36 12L36 14L33 14L33 15L30 15L30 14L32 14L32 13L30 13L30 14L28 14L28 13L27 13L27 12L29 12L29 10L28 10L28 11L27 11L27 12L26 12L26 13L27 13L27 14L26 14L26 15L25 15L25 13L24 13L24 12L25 12L25 11L26 11L26 10L25 10L25 9L24 9L24 10L23 10L23 9ZM17 10L17 11L18 11L18 10ZM24 10L24 11L22 11L22 13L23 13L23 12L24 12L24 11L25 11L25 10ZM30 11L30 12L31 12L31 11ZM56 11L56 12L57 12L57 11ZM33 12L33 13L35 13L35 12ZM40 12L40 13L41 13L41 12ZM13 13L13 14L14 14L14 13ZM6 14L6 15L7 15L7 14ZM9 14L9 15L8 15L8 17L7 17L7 16L6 16L6 17L5 17L5 18L6 18L6 19L7 19L7 20L6 20L6 21L7 21L7 22L6 22L6 23L9 23L9 22L8 22L8 21L9 21L9 20L10 20L10 18L11 18L11 21L10 21L10 22L12 22L12 21L15 21L15 22L14 22L14 23L15 23L15 22L16 22L16 21L15 21L15 20L17 20L17 19L15 19L15 17L13 17L13 16L12 16L12 17L13 17L13 18L11 18L11 17L9 17L9 15L10 15L10 16L11 16L11 15L12 15L12 14L11 14L11 15L10 15L10 14ZM24 15L24 17L23 17L23 18L22 18L22 19L23 19L23 20L22 20L22 21L20 21L20 22L22 22L22 21L23 21L23 24L22 24L22 25L25 25L25 26L29 26L29 25L31 25L31 24L30 24L30 23L34 23L34 22L35 22L35 21L36 21L36 20L37 20L37 21L38 21L38 20L39 20L39 19L37 19L37 18L36 18L36 19L34 19L34 20L32 20L32 19L31 19L31 18L29 18L29 17L31 17L31 16L30 16L30 15L29 15L29 16L28 16L28 15L26 15L26 16L25 16L25 15ZM26 16L26 17L24 17L24 20L23 20L23 21L24 21L24 22L25 22L25 21L24 21L24 20L26 20L26 21L27 21L27 24L25 24L25 23L24 23L24 24L25 24L25 25L28 25L28 24L29 24L29 23L30 23L30 22L32 22L32 21L30 21L30 22L29 22L29 23L28 23L28 21L27 21L27 20L29 20L29 19L28 19L28 18L27 18L27 20L26 20L26 19L25 19L25 18L26 18L26 17L28 17L28 16ZM40 16L40 17L41 17L41 16ZM51 16L51 17L52 17L52 16ZM6 17L6 18L7 18L7 19L8 19L8 20L9 20L9 19L8 19L8 18L7 18L7 17ZM55 17L55 18L57 18L57 17ZM12 19L12 20L14 20L14 19ZM30 19L30 20L31 20L31 19ZM56 19L56 20L57 20L57 19ZM34 20L34 21L35 21L35 20ZM44 20L44 21L43 21L43 22L41 22L41 23L42 23L42 25L43 25L43 24L44 24L44 23L43 23L43 22L44 22L44 21L45 21L45 20ZM45 22L45 23L46 23L46 22ZM52 23L52 24L51 24L51 25L52 25L52 24L53 24L53 23ZM54 23L54 24L55 24L55 23ZM10 24L10 26L11 26L11 24ZM36 24L36 25L37 25L37 24ZM38 24L38 25L39 25L39 24ZM15 25L15 26L17 26L17 27L16 27L16 28L17 28L17 29L16 29L16 30L17 30L17 29L18 29L18 28L17 28L17 27L18 27L18 25ZM20 26L20 27L21 27L21 26ZM36 26L36 27L37 27L37 28L36 28L36 29L37 29L37 30L36 30L36 31L40 31L40 30L38 30L38 29L40 29L40 28L41 28L41 27L40 27L40 26ZM53 26L53 27L54 27L54 26ZM5 27L5 30L8 30L8 27ZM27 27L27 30L30 30L30 27ZM49 27L49 30L52 30L52 27ZM56 27L56 28L57 28L57 27ZM6 28L6 29L7 29L7 28ZM28 28L28 29L29 29L29 28ZM50 28L50 29L51 29L51 28ZM0 29L0 30L1 30L1 29ZM42 29L42 30L43 30L43 29ZM24 30L24 31L25 31L25 30ZM54 30L54 31L55 31L55 30ZM28 31L28 32L29 32L29 31ZM5 32L5 33L7 33L7 32ZM24 32L24 33L23 33L23 36L22 36L22 37L23 37L23 39L22 39L22 41L20 41L20 40L21 40L21 37L20 37L20 36L19 36L19 37L18 37L18 38L19 38L19 39L20 39L20 40L19 40L19 41L17 41L17 40L18 40L18 39L17 39L17 40L16 40L16 39L14 39L14 40L15 40L15 41L14 41L14 44L15 44L15 43L16 43L16 44L18 44L18 45L19 45L19 43L21 43L21 44L22 44L22 45L24 45L24 43L25 43L25 42L26 42L26 43L30 43L30 44L31 44L31 43L30 43L30 42L31 42L31 39L32 39L32 37L33 37L33 36L31 36L31 37L28 37L28 36L27 36L27 37L28 37L28 38L27 38L27 39L25 39L25 40L24 40L24 37L25 37L25 38L26 38L26 37L25 37L25 36L24 36L24 35L25 35L25 34L24 34L24 33L25 33L25 32ZM36 32L36 33L37 33L37 32ZM6 34L6 35L7 35L7 34ZM40 34L40 35L41 35L41 34ZM12 35L12 36L13 36L13 37L15 37L15 38L16 38L16 37L15 37L15 36L13 36L13 35ZM56 35L56 37L57 37L57 35ZM23 36L23 37L24 37L24 36ZM47 37L47 38L46 38L46 39L42 39L42 40L41 40L41 42L43 42L43 41L44 41L44 42L45 42L45 43L44 43L44 44L45 44L45 45L44 45L44 46L45 46L45 45L47 45L47 46L49 46L49 45L47 45L47 44L45 44L45 43L47 43L47 42L48 42L48 41L47 41L47 40L46 40L46 39L47 39L47 38L48 38L48 37ZM28 38L28 39L31 39L31 38ZM8 40L8 41L9 41L9 40ZM10 40L10 41L11 41L11 40ZM26 40L26 41L27 41L27 40ZM28 40L28 41L29 41L29 40ZM42 40L42 41L43 41L43 40ZM44 40L44 41L45 41L45 40ZM22 41L22 42L21 42L21 43L22 43L22 44L23 44L23 43L22 43L22 42L25 42L25 41ZM46 41L46 42L47 42L47 41ZM56 41L56 42L57 42L57 41ZM16 42L16 43L18 43L18 42ZM10 43L10 44L9 44L9 45L10 45L10 44L11 44L11 43ZM34 45L34 46L35 46L35 45ZM36 45L36 46L37 46L37 45ZM41 45L41 46L43 46L43 45ZM51 45L51 46L52 46L52 45ZM12 46L12 48L11 48L11 50L12 50L12 51L14 51L14 50L15 50L15 49L13 49L13 46ZM22 46L22 49L23 49L23 46ZM47 47L47 48L48 48L48 47ZM16 48L16 49L19 49L19 48ZM27 49L27 52L30 52L30 49ZM49 49L49 52L52 52L52 49ZM28 50L28 51L29 51L29 50ZM50 50L50 51L51 51L51 50ZM53 50L53 51L54 51L54 50ZM20 51L20 52L21 52L21 51ZM24 51L24 52L23 52L23 53L24 53L24 52L25 52L25 51ZM46 51L46 54L47 54L47 56L48 56L48 54L47 54L47 53L48 53L48 52L47 52L47 51ZM56 51L56 52L57 52L57 51ZM44 52L44 54L45 54L45 52ZM54 53L54 54L55 54L55 53ZM11 54L11 55L10 55L10 56L11 56L11 55L12 55L12 54ZM39 54L39 56L38 56L38 57L39 57L39 56L41 56L41 57L42 57L42 55L40 55L40 54ZM30 55L30 56L29 56L29 57L30 57L30 56L31 56L31 57L32 57L32 56L31 56L31 55ZM45 55L45 56L46 56L46 55ZM54 55L54 56L53 56L53 57L54 57L54 56L55 56L55 57L56 57L56 56L55 56L55 55ZM33 56L33 57L34 57L34 56ZM0 0L0 7L7 7L7 0ZM1 1L1 6L6 6L6 1ZM2 2L2 5L5 5L5 2ZM50 0L50 7L57 7L57 0ZM51 1L51 6L56 6L56 1ZM52 2L52 5L55 5L55 2ZM0 50L0 57L7 57L7 50ZM1 51L1 56L6 56L6 51ZM2 52L2 55L5 55L5 52Z\\\" fill=\\\"#000000\\\"\\/><\\/g><\\/g><\\/svg>\\n\\n                            <span style=\\\"width:50%;\\\">\\n                                <img style=\\\"max-height: 70px\\\"\\n                                     src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/img\\/AfipComprobanteAutorizado.png\\\">\\n                            <\\/span>\\n                        <\\/th>\\n                        <th style=\\\"text-align:right;\\\">\\n                            <p>CAE N&#186;: 71304902484304<br>\\n                                Fecha Vto. CAE:  25\\/07\\/2021\\n                            <\\/p>\\n                        <\\/th>\\n                    <\\/tr>\\n                <\\/table>\\n                    <\\/div>\\n    <\\/div>\\n\\n    <\\/body>\\n<\\/html>\\\";s:4:\\\"file\\\";N;}s:6:\\\"locale\\\";N;s:4:\\\"from\\\";a:0:{}s:2:\\\"to\\\";a:1:{i:0;a:2:{s:4:\\\"name\\\";N;s:7:\\\"address\\\";s:23:\\\"v.iacobelli@hotmail.com\\\";}}s:2:\\\"cc\\\";a:0:{}s:3:\\\"bcc\\\";a:1:{i:0;a:2:{s:4:\\\"name\\\";N;s:7:\\\"address\\\";s:23:\\\"info@masquecontable.com\\\";}}s:7:\\\"replyTo\\\";a:0:{}s:7:\\\"subject\\\";N;s:11:\\\"\\u0000*\\u0000markdown\\\";N;s:7:\\\"\\u0000*\\u0000html\\\";N;s:4:\\\"view\\\";N;s:8:\\\"textView\\\";N;s:8:\\\"viewData\\\";a:0:{}s:11:\\\"attachments\\\";a:0:{}s:14:\\\"rawAttachments\\\";a:0:{}s:15:\\\"diskAttachments\\\";a:0:{}s:9:\\\"callbacks\\\";a:0:{}s:5:\\\"theme\\\";N;s:6:\\\"mailer\\\";s:8:\\\"sendgrid\\\";s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:5:\\\"delay\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;}\"}}','ErrorException: Trying to get property \'id\' of non-object in /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php:16\nStack trace:\n#0 /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php(16): Illuminate\\Foundation\\Bootstrap\\HandleExceptions->handleError(8, \'Trying to get p...\', \'/home/forge/tax...\', 16, Array)\n#1 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(356): App\\Queue\\DatabaseJob->fire()\n#2 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(306): Illuminate\\Queue\\Worker->process(\'database\', Object(App\\Queue\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#3 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(132): Illuminate\\Queue\\Worker->runJob(Object(App\\Queue\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#4 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(112): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#5 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(96): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#6 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#7 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#8 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#9 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#10 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#11 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(134): Illuminate\\Container\\Container->call(Array)\n#12 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(256): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#13 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(121): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#14 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(971): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#15 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(290): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#16 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(166): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#17 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Application.php(93): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(129): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#19 /home/forge/taxes.com.ar/artisan(35): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#20 {main}','2021-07-23 18:04:10',NULL);
INSERT INTO `failed_jobs` VALUES (14,NULL,'database','default','{\"uuid\":\"f9071425-ec9c-4606-ad7d-1f34ebe38563\",\"displayName\":\"App\\\\Mail\\\\Fact_Electronica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"delay\":null,\"timeout\":null,\"timeoutAt\":null,\"data\":{\"commandName\":\"Illuminate\\\\Mail\\\\SendQueuedMailable\",\"command\":\"O:34:\\\"Illuminate\\\\Mail\\\\SendQueuedMailable\\\":3:{s:8:\\\"mailable\\\";O:25:\\\"App\\\\Mail\\\\Fact_Electronica\\\":27:{s:11:\\\"informacion\\\";a:6:{s:12:\\\"ruta_logo_fa\\\";N;s:4:\\\"mail\\\";s:23:\\\"info@masquecontable.com\\\";s:18:\\\"name_quien_factura\\\";s:19:\\\"MICAELA AILIN CORIA\\\";s:7:\\\"cliente\\\";O:17:\\\"App\\\\Models\\\\Person\\\":27:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:7:\\\"persons\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:40740;s:7:\\\"user_id\\\";i:5117;s:11:\\\"field_name1\\\";s:19:\\\"LUGO VICTORIA PAULA\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-32743577-4\\\";s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-07-05 19:02:06\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-07-23 12:20:37\\\";s:11:\\\"activity_id\\\";i:1;s:7:\\\"address\\\";s:96:\\\"Direccion\\r\\nALVEAR 259 Dpto:3\\r\\nCod. Postal\\r\\n1878\\r\\nProvincia\\r\\nBUENOS AIRES\\r\\nTipo Domicilio\\r\\nFISCAL\\\";s:14:\\\"person_type_id\\\";i:1;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:40740;s:7:\\\"user_id\\\";i:5117;s:11:\\\"field_name1\\\";s:19:\\\"LUGO VICTORIA PAULA\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-32743577-4\\\";s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-07-05 19:02:06\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-07-23 12:20:37\\\";s:11:\\\"activity_id\\\";i:1;s:7:\\\"address\\\";s:96:\\\"Direccion\\r\\nALVEAR 259 Dpto:3\\r\\nCod. Postal\\r\\n1878\\r\\nProvincia\\r\\nBUENOS AIRES\\r\\nTipo Domicilio\\r\\nFISCAL\\\";s:14:\\\"person_type_id\\\";i:1;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}s:14:\\\"nombre_del_pdf\\\";s:28:\\\"Factura N\\u00b00004-00000017.pdf\\\";s:9:\\\"body_mail\\\";s:155:\\\"Estimado cliente, se env\\u00eda adjunta la factura de honorarios correspondientes al mes de Julio 2021.\\nMuchas gracias por seguir eligiendo nuestros servicios.\\\";}s:3:\\\"pdf\\\";O:26:\\\"Barryvdh\\\\Snappy\\\\PdfWrapper\\\":4:{s:9:\\\"\\u0000*\\u0000snappy\\\";O:35:\\\"Barryvdh\\\\Snappy\\\\IlluminateSnappyPdf\\\":10:{s:26:\\\"\\u0000*\\u0000optionsWithContentCheck\\\";a:4:{s:11:\\\"header-html\\\";s:4:\\\"html\\\";s:11:\\\"footer-html\\\";s:4:\\\"html\\\";s:5:\\\"cover\\\";s:4:\\\"html\\\";s:15:\\\"xsl-style-sheet\\\";s:3:\\\"xsl\\\";}s:36:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000binary\\\";s:76:\\\"\\/home\\/forge\\/taxes.com.ar\\/vendor\\/h4cc\\/wkhtmltopdf-amd64\\/bin\\/wkhtmltopdf-amd64\\\";s:37:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000options\\\";a:132:{s:7:\\\"collate\\\";N;s:10:\\\"no-collate\\\";N;s:10:\\\"cookie-jar\\\";N;s:6:\\\"copies\\\";i:1;s:3:\\\"dpi\\\";N;s:13:\\\"extended-help\\\";N;s:9:\\\"grayscale\\\";N;s:4:\\\"help\\\";N;s:7:\\\"htmldoc\\\";N;s:18:\\\"ignore-load-errors\\\";N;s:9:\\\"image-dpi\\\";N;s:13:\\\"image-quality\\\";N;s:7:\\\"license\\\";N;s:9:\\\"log-level\\\";N;s:10:\\\"lowquality\\\";b:1;s:7:\\\"manpage\\\";N;s:13:\\\"margin-bottom\\\";N;s:11:\\\"margin-left\\\";N;s:12:\\\"margin-right\\\";N;s:10:\\\"margin-top\\\";N;s:11:\\\"orientation\\\";N;s:11:\\\"page-height\\\";N;s:9:\\\"page-size\\\";s:2:\\\"a4\\\";s:10:\\\"page-width\\\";N;s:18:\\\"no-pdf-compression\\\";N;s:5:\\\"quiet\\\";N;s:20:\\\"read-args-from-stdin\\\";N;s:6:\\\"readme\\\";N;s:5:\\\"title\\\";N;s:11:\\\"use-xserver\\\";N;s:7:\\\"version\\\";N;s:20:\\\"dump-default-toc-xsl\\\";N;s:12:\\\"dump-outline\\\";N;s:7:\\\"outline\\\";N;s:10:\\\"no-outline\\\";N;s:13:\\\"outline-depth\\\";N;s:13:\\\"output-format\\\";N;s:5:\\\"allow\\\";N;s:10:\\\"background\\\";N;s:13:\\\"no-background\\\";N;s:16:\\\"bypass-proxy-for\\\";N;s:9:\\\"cache-dir\\\";N;s:20:\\\"checkbox-checked-svg\\\";N;s:12:\\\"checkbox-svg\\\";N;s:6:\\\"cookie\\\";N;s:13:\\\"custom-header\\\";N;s:25:\\\"custom-header-propagation\\\";N;s:28:\\\"no-custom-header-propagation\\\";N;s:16:\\\"debug-javascript\\\";N;s:19:\\\"no-debug-javascript\\\";N;s:14:\\\"default-header\\\";N;s:8:\\\"encoding\\\";N;s:22:\\\"disable-external-links\\\";N;s:21:\\\"enable-external-links\\\";N;s:13:\\\"disable-forms\\\";N;s:12:\\\"enable-forms\\\";N;s:6:\\\"images\\\";N;s:9:\\\"no-images\\\";N;s:22:\\\"disable-internal-links\\\";N;s:21:\\\"enable-internal-links\\\";N;s:18:\\\"disable-javascript\\\";N;s:17:\\\"enable-javascript\\\";N;s:16:\\\"javascript-delay\\\";N;s:19:\\\"keep-relative-links\\\";N;s:19:\\\"load-error-handling\\\";N;s:25:\\\"load-media-error-handling\\\";N;s:25:\\\"disable-local-file-access\\\";N;s:24:\\\"enable-local-file-access\\\";N;s:17:\\\"minimum-font-size\\\";N;s:20:\\\"exclude-from-outline\\\";N;s:18:\\\"include-in-outline\\\";N;s:11:\\\"page-offset\\\";N;s:8:\\\"password\\\";N;s:15:\\\"disable-plugins\\\";N;s:14:\\\"enable-plugins\\\";N;s:4:\\\"post\\\";N;s:9:\\\"post-file\\\";N;s:16:\\\"print-media-type\\\";N;s:19:\\\"no-print-media-type\\\";N;s:5:\\\"proxy\\\";N;s:21:\\\"proxy-hostname-lookup\\\";N;s:23:\\\"radiobutton-checked-svg\\\";N;s:15:\\\"radiobutton-svg\\\";N;s:14:\\\"redirect-delay\\\";N;s:22:\\\"resolve-relative-links\\\";N;s:10:\\\"run-script\\\";N;s:23:\\\"disable-smart-shrinking\\\";N;s:22:\\\"enable-smart-shrinking\\\";N;s:12:\\\"ssl-crt-path\\\";N;s:16:\\\"ssl-key-password\\\";N;s:12:\\\"ssl-key-path\\\";N;s:17:\\\"stop-slow-scripts\\\";N;s:20:\\\"no-stop-slow-scripts\\\";N;s:22:\\\"disable-toc-back-links\\\";N;s:21:\\\"enable-toc-back-links\\\";N;s:16:\\\"user-style-sheet\\\";N;s:8:\\\"username\\\";N;s:13:\\\"viewport-size\\\";N;s:13:\\\"window-status\\\";N;s:4:\\\"zoom\\\";N;s:13:\\\"footer-center\\\";s:25:\\\"Pagina [page] de [toPage]\\\";s:16:\\\"footer-font-name\\\";N;s:16:\\\"footer-font-size\\\";i:8;s:11:\\\"footer-html\\\";N;s:11:\\\"footer-left\\\";s:0:\\\"\\\";s:11:\\\"footer-line\\\";N;s:14:\\\"no-footer-line\\\";N;s:12:\\\"footer-right\\\";N;s:14:\\\"footer-spacing\\\";N;s:13:\\\"header-center\\\";N;s:16:\\\"header-font-name\\\";N;s:16:\\\"header-font-size\\\";N;s:11:\\\"header-html\\\";N;s:11:\\\"header-left\\\";N;s:11:\\\"header-line\\\";N;s:14:\\\"no-header-line\\\";N;s:12:\\\"header-right\\\";N;s:14:\\\"header-spacing\\\";N;s:7:\\\"replace\\\";N;s:5:\\\"cover\\\";N;s:3:\\\"toc\\\";N;s:20:\\\"disable-dotted-lines\\\";N;s:9:\\\"toc-depth\\\";N;s:13:\\\"toc-font-name\\\";N;s:16:\\\"toc-l1-font-size\\\";N;s:15:\\\"toc-header-text\\\";N;s:20:\\\"toc-header-font-name\\\";N;s:20:\\\"toc-header-font-size\\\";N;s:21:\\\"toc-level-indentation\\\";N;s:17:\\\"disable-toc-links\\\";N;s:20:\\\"toc-text-size-shrink\\\";N;s:15:\\\"xsl-style-sheet\\\";N;}s:33:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000env\\\";N;s:37:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000timeout\\\";b:0;s:46:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000defaultExtension\\\";s:3:\\\"pdf\\\";s:18:\\\"\\u0000*\\u0000temporaryFolder\\\";N;s:14:\\\"temporaryFiles\\\";a:0:{}s:36:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000logger\\\";O:18:\\\"Psr\\\\Log\\\\NullLogger\\\":0:{}s:2:\\\"fs\\\";O:32:\\\"Illuminate\\\\Filesystem\\\\Filesystem\\\":0:{}}s:10:\\\"\\u0000*\\u0000options\\\";a:0:{}s:4:\\\"html\\\";s:22133:\\\"<!DOCTYPE html>\\n<html lang=\\\"en\\\">\\n    <head>\\n        <meta charset=\\\"utf-8\\\">\\n    <\\/head>\\n    <style>\\n        .subtotales_conceptos{\\n            width:30%;\\n            text-align: right;\\n        }\\n        .subtotales_importes{\\n            text-align: right;\\n        }\\n        .table-totales, .table-totales tr, .table-totales th{\\n            border: 1px solid;\\n        }\\n\\n    <\\/style>\\n    <body>\\n    <div style=\\\"max-height:840px\\\">\\n        <div style=\\\"width: 100%; height:270px\\\"> <!-- Datos de la empresa -->\\n            <table class=\\\"display\\\" cellspacing=\\\"0\\\" width=\\\"100%\\\" style=\\\"border:  1px solid;\\\">\\n                <tr style=\\\"\\\">\\n                    <th colspan=\\\"2\\\" rowspan=\\\"2\\\" style=\\\"width:45%;margin:0;height:150px;\\\">\\n                                                <img src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/img\\/\\/27377183504\\/logo_punto_venta_0000.png\\\"\\/>\\n                                            <\\/th>\\n                    <th style=\\\"border:  1px solid;text-align: center; width:10%\\\" colspan=\\\"2\\\">\\n                        <span style=\\\"font-size: 60px;\\\">C<\\/span> <br \\/> <span style=\\\"font-size: 14px;\\\">cod. 11<\\/span>\\n                    <\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"font-size: 28px;text-align: center;width:45%\\\">\\n                        Factura\\n                        <br>\\n                        0004 - 00000017\\n                    <\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th><\\/th>\\n                    <th style=\\\"border:  1px 1px 1px 0px solid;\\\" colspan=\\\"2\\\"><\\/th>\\n                    <th><\\/th>\\n                <\\/tr>\\n                <tr>\\n\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                                                    Raz&oacute;n Social:\\n                            <span style=\\\"font-weight: normal;\\\">MICAELA AILIN CORIA<\\/span>\\n                                            <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">Fecha de Emisi&oacute;n: <span style=\\\"font-weight: normal;\\\">15\\/07\\/2021<\\/span><\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Domicilio Comercial: <span style=\\\"font-weight: normal;\\\">Victor Guillet esq. Arturo M Bas, C.P.:5800,\\n                        C\\u00f3rdoba<\\/span>\\n                    <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">CUIT: <span style=\\\"font-weight: normal;\\\">27-37718350-4<\\/span><\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Condici&oacute;n frente al IVA: <span style=\\\"font-weight: normal;\\\">Monotributo<\\/span>\\n                    <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Ingresos Brutos: <span style=\\\"font-weight: normal;\\\"><\\/span>\\n                        <br>\\n                        Fecha de Inicio de Actividades: <span style=\\\"font-weight: normal;\\\">09\\/07\\/2021<\\/span>\\n                    <\\/th>\\n                <\\/tr>\\n            <\\/table>\\n        <\\/div>\\n\\n        <table style=\\\"text-align: center; width: 100%;border: solid 1px;\\\"> <!-- Fechas -->\\n            <thead>\\n                <tr>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Per\\u00edodo Facturado Desde: 01\\/07\\/2021<\\/small><\\/th>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Per\\u00edodo Facturado Hasta: 31\\/07\\/2021<\\/small><\\/th>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Fecha Vto. Pago: 15\\/07\\/2021<\\/small><\\/th>\\n                <\\/tr>\\n            <\\/thead>\\n        <\\/table>\\n        \\n        <table style=\\\"width: 100%; margin-top: 1%;border: solid 1px;\\\"> <!-- Datos Clientes -->\\n            <tr>\\n                <th style=\\\"text-align:left;\\\"colspan=\\\"12\\\">\\n                    CUIT: <span style=\\\"font-weight: normal;\\\">27-32743577-4<\\/span>\\n                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\\n                    Apellido y Nombre \\/ Raz&oacute;n Social: <span style=\\\"font-weight: normal;\\\">\\n                    LUGO VICTORIA PAULA<\\/span>\\n                <\\/th>\\n            <\\/tr>\\n            <tr>\\n                <th style=\\\"text-align:left; width:50%\\\">\\n                    Condici&oacute;n Frente al IVA: <span style=\\\"font-weight: normal;\\\">Responsable Monotributo<\\/span>\\n                <\\/th>\\n                <th style=\\\"text-align:left; width:50%\\\" colspan=\\\"4\\\">\\n                    Domicilio Comercial:\\n                    <span style=\\\"font-weight: normal;\\\">\\n                    Direccion\\r\\nALVEAR 259 Dpto:3\\r\\nCod. Postal\\r\\n1878\\r\\nProvincia\\r\\nBUENOS AIRES\\r\\nTipo Domicilio\\r\\nFISCAL\\n                    <\\/span>\\n                <\\/th>\\n            <\\/tr>\\n            <tr style=\\\"text-align:left\\\">\\n                <th>Condici&oacute;n de Venta: <span style=\\\"font-weight: normal;\\\">Cuenta Corriente<\\/span><\\/th>\\n            <\\/tr>\\n        <\\/table>\\n\\n        <div style=\\\"border: 1px solid;margin-top: 1%;min-height:600px;\\\">\\n        <table style=\\\"text-align: center; width: 100%; margin-top: 1%;\\\"> <!-- Body -->\\n            <tr style=\\\"border-bottom: 1px solid;font-size: 15px\\\">\\n                <th>C&oacute;digo<\\/th>\\n                <th style=\\\"width: 25%;\\\">Detalle<\\/th>\\n                <th>Cantidad<\\/th>\\n                <th>U.Medida<\\/th>\\n                <th>Precio U.<\\/th>\\n                <th>Bonif. (%)<\\/th>\\n                <th>Precio Bonif.<\\/th>\\n                <th>Subtotal<\\/th>\\n                            <\\/tr>\\n            <tbody>\\n                                                                                <tr style=\\\"font-size: 12px;\\\">\\n                        <td>\\n                            \\n                        <\\/td>\\n                        <td>\\n                            Honorarios profesionales Julio 2021\\n                        <\\/td>\\n                        <td>\\n                            1.00\\n                        <\\/td>\\n                        <td>\\n                            Unidades\\n                        <\\/td>\\n                        <td>                            2.950,00\\n                                                    <\\/td>\\n                        <td>\\n                            0,00%\\n                        <\\/td>\\n                        <td>\\n                            0,00\\n                        <\\/td>\\n                        <td>\\n                            2.950,00\\n                        <\\/td>\\n                                            <\\/tr>\\n                    \\n            <\\/tbody>\\n        <\\/table>\\n        <\\/div>\\n\\n        \\n\\n        <div style=\\\"height:200px;margin-top: 1%;\\\"> <!-- Totales -->\\n              <!-- Es factura B o C -->\\n                <table class=\\\"table-totales\\\" cellspacing=\\\"0\\\" width=\\\"100%\\\">\\n                    <tr>\\n                        <th style=\\\"width:50%; text-align:left;\\\">\\n\\n<!--                                <span style=\\\"width:100%;\\\"><img src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/barcodes\\/71304902485732.png\\\"><\\/span>\\n                                <span style=\\\"text-align:center;\\\">2737718350411000471304902485732202107257<\\/span>-->\\n                        <\\/th>\\n                        <th class=\\\"subtotales_conceptos\\\">TOTAL:<\\/th>\\n                        <th class=\\\"subtotales_importes\\\">$ 2.950,00<\\/th>\\n                    <\\/tr>\\n                <\\/table>\\n                <br>\\n                <table cellspacing=\\\"0\\\" width=\\\"100%\\\" style=\\\"border: none\\\">\\n                    <tr>\\n                        <th style=\\\"width:50%; text-align:left;\\\">\\n\\n                            <?xml version=\\\"1.0\\\" encoding=\\\"UTF-8\\\"?>\\n<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" version=\\\"1.1\\\" width=\\\"100\\\" height=\\\"100\\\" viewBox=\\\"0 0 100 100\\\"><rect x=\\\"0\\\" y=\\\"0\\\" width=\\\"100\\\" height=\\\"100\\\" fill=\\\"#ffffff\\\"\\/><g transform=\\\"scale(1.754)\\\"><g transform=\\\"translate(0,0)\\\"><path fill-rule=\\\"evenodd\\\" d=\\\"M8 0L8 1L9 1L9 2L8 2L8 5L9 5L9 3L10 3L10 4L11 4L11 5L12 5L12 4L11 4L11 3L10 3L10 2L12 2L12 3L13 3L13 4L14 4L14 3L15 3L15 5L17 5L17 4L16 4L16 3L17 3L17 2L18 2L18 1L17 1L17 2L15 2L15 1L16 1L16 0L14 0L14 2L13 2L13 0L11 0L11 1L10 1L10 0ZM22 0L22 1L23 1L23 2L22 2L22 3L21 3L21 4L20 4L20 5L21 5L21 4L22 4L22 12L21 12L21 11L20 11L20 12L19 12L19 10L20 10L20 9L21 9L21 8L20 8L20 7L21 7L21 6L20 6L20 7L19 7L19 6L18 6L18 7L17 7L17 6L16 6L16 7L15 7L15 6L14 6L14 5L13 5L13 6L12 6L12 7L11 7L11 6L10 6L10 7L9 7L9 6L8 6L8 7L9 7L9 8L8 8L8 10L4 10L4 11L3 11L3 12L4 12L4 13L3 13L3 14L2 14L2 15L3 15L3 16L2 16L2 17L4 17L4 18L3 18L3 19L1 19L1 18L0 18L0 20L1 20L1 21L2 21L2 22L3 22L3 23L1 23L1 24L0 24L0 25L1 25L1 28L2 28L2 30L4 30L4 32L6 32L6 33L3 33L3 31L0 31L0 32L2 32L2 33L0 33L0 34L1 34L1 35L3 35L3 36L2 36L2 38L0 38L0 40L1 40L1 41L0 41L0 44L1 44L1 45L0 45L0 48L5 48L5 47L7 47L7 48L6 48L6 49L8 49L8 50L9 50L9 49L10 49L10 48L11 48L11 51L12 51L12 52L13 52L13 53L11 53L11 54L10 54L10 51L9 51L9 53L8 53L8 57L9 57L9 55L11 55L11 56L12 56L12 55L11 55L11 54L15 54L15 53L16 53L16 54L17 54L17 55L18 55L18 56L17 56L17 57L18 57L18 56L19 56L19 57L21 57L21 55L22 55L22 53L21 53L21 54L20 54L20 51L21 51L21 52L23 52L23 50L24 50L24 53L25 53L25 54L23 54L23 56L22 56L22 57L24 57L24 56L26 56L26 55L25 55L25 54L27 54L27 53L31 53L31 54L33 54L33 55L32 55L32 56L34 56L34 57L36 57L36 55L38 55L38 56L37 56L37 57L44 57L44 56L43 56L43 55L42 55L42 56L41 56L41 55L40 55L40 54L42 54L42 53L40 53L40 52L43 52L43 53L45 53L45 52L46 52L46 51L45 51L45 49L47 49L47 48L48 48L48 50L47 50L47 53L46 53L46 54L44 54L44 55L45 55L45 56L46 56L46 57L48 57L48 56L47 56L47 54L48 54L48 55L49 55L49 54L50 54L50 57L51 57L51 54L52 54L52 53L55 53L55 54L56 54L56 53L57 53L57 51L56 51L56 49L57 49L57 48L56 48L56 49L55 49L55 51L53 51L53 49L54 49L54 48L53 48L53 46L54 46L54 45L56 45L56 46L55 46L55 47L57 47L57 44L53 44L53 46L52 46L52 43L51 43L51 44L50 44L50 42L51 42L51 41L50 41L50 40L52 40L52 42L54 42L54 43L55 43L55 42L57 42L57 40L56 40L56 38L57 38L57 31L56 31L56 30L57 30L57 27L56 27L56 24L57 24L57 21L56 21L56 20L53 20L53 19L54 19L54 18L55 18L55 14L54 14L54 10L53 10L53 9L55 9L55 10L56 10L56 11L55 11L55 12L57 12L57 8L56 8L56 9L55 9L55 8L52 8L52 10L51 10L51 11L50 11L50 10L49 10L49 9L50 9L50 8L48 8L48 7L49 7L49 6L48 6L48 7L47 7L47 5L48 5L48 0L45 0L45 1L43 1L43 0L39 0L39 1L41 1L41 4L40 4L40 5L39 5L39 2L38 2L38 1L37 1L37 2L36 2L36 1L32 1L32 2L31 2L31 0L30 0L30 1L29 1L29 0L28 0L28 1L26 1L26 0L24 0L24 1L23 1L23 0ZM19 1L19 2L21 2L21 1ZM25 1L25 2L23 2L23 3L22 3L22 4L23 4L23 3L24 3L24 5L23 5L23 12L22 12L22 13L23 13L23 14L24 14L24 16L23 16L23 15L22 15L22 14L20 14L20 13L19 13L19 12L18 12L18 10L19 10L19 9L20 9L20 8L18 8L18 9L17 9L17 8L15 8L15 7L14 7L14 6L13 6L13 7L12 7L12 8L11 8L11 7L10 7L10 8L9 8L9 9L13 9L13 10L12 10L12 14L11 14L11 15L13 15L13 16L11 16L11 18L10 18L10 19L11 19L11 20L12 20L12 22L10 22L10 23L11 23L11 25L12 25L12 27L16 27L16 28L14 28L14 30L16 30L16 28L17 28L17 27L19 27L19 28L18 28L18 32L17 32L17 31L15 31L15 32L14 32L14 31L12 31L12 30L13 30L13 28L12 28L12 30L11 30L11 26L9 26L9 29L10 29L10 30L9 30L9 31L6 31L6 32L8 32L8 33L9 33L9 34L7 34L7 33L6 33L6 34L7 34L7 35L6 35L6 36L3 36L3 37L4 37L4 38L3 38L3 41L4 41L4 39L5 39L5 37L6 37L6 38L9 38L9 34L10 34L10 39L11 39L11 40L7 40L7 39L6 39L6 40L7 40L7 41L6 41L6 42L7 42L7 43L5 43L5 42L2 42L2 43L1 43L1 44L2 44L2 43L4 43L4 44L7 44L7 45L6 45L6 46L7 46L7 47L8 47L8 48L10 48L10 47L11 47L11 48L12 48L12 47L11 47L11 46L13 46L13 47L15 47L15 46L14 46L14 45L16 45L16 46L18 46L18 47L17 47L17 48L18 48L18 47L20 47L20 48L19 48L19 50L17 50L17 49L16 49L16 48L15 48L15 49L14 49L14 48L13 48L13 49L14 49L14 50L15 50L15 49L16 49L16 53L17 53L17 51L20 51L20 48L22 48L22 49L23 49L23 48L22 48L22 47L24 47L24 46L22 46L22 44L21 44L21 43L24 43L24 44L23 44L23 45L25 45L25 46L27 46L27 44L28 44L28 47L26 47L26 48L24 48L24 50L25 50L25 49L26 49L26 48L28 48L28 47L29 47L29 48L30 48L30 47L32 47L32 50L31 50L31 51L32 51L32 50L33 50L33 51L35 51L35 52L36 52L36 53L35 53L35 55L34 55L34 56L35 56L35 55L36 55L36 53L37 53L37 54L38 54L38 55L39 55L39 56L40 56L40 55L39 55L39 53L37 53L37 51L38 51L38 52L40 52L40 50L41 50L41 51L42 51L42 50L43 50L43 51L44 51L44 49L45 49L45 48L46 48L46 46L47 46L47 45L48 45L48 44L49 44L49 42L50 42L50 41L47 41L47 42L48 42L48 43L46 43L46 44L45 44L45 42L46 42L46 40L47 40L47 39L48 39L48 37L50 37L50 39L52 39L52 40L53 40L53 41L54 41L54 42L55 42L55 41L56 41L56 40L55 40L55 41L54 41L54 39L55 39L55 38L56 38L56 36L55 36L55 35L56 35L56 32L55 32L55 30L56 30L56 27L55 27L55 23L54 23L54 22L51 22L51 21L52 21L52 20L51 20L51 19L53 19L53 17L54 17L54 14L52 14L52 13L53 13L53 10L52 10L52 11L51 11L51 12L52 12L52 13L51 13L51 15L50 15L50 16L49 16L49 17L47 17L47 16L46 16L46 15L47 15L47 13L48 13L48 14L50 14L50 12L49 12L49 10L48 10L48 8L47 8L47 9L46 9L46 10L48 10L48 11L46 11L46 12L47 12L47 13L46 13L46 14L45 14L45 12L44 12L44 13L43 13L43 12L42 12L42 13L41 13L41 9L44 9L44 10L43 10L43 11L45 11L45 7L46 7L46 5L47 5L47 3L46 3L46 2L47 2L47 1L45 1L45 3L44 3L44 5L43 5L43 4L41 4L41 7L42 7L42 8L41 8L41 9L39 9L39 8L38 8L38 9L37 9L37 8L35 8L35 7L36 7L36 6L37 6L37 7L38 7L38 6L37 6L37 5L38 5L38 3L37 3L37 5L35 5L35 4L34 4L34 5L33 5L33 7L32 7L32 4L33 4L33 3L34 3L34 2L33 2L33 3L31 3L31 8L32 8L32 9L31 9L31 10L33 10L33 11L34 11L34 10L35 10L35 13L34 13L34 14L32 14L32 15L33 15L33 17L30 17L30 18L28 18L28 19L27 19L27 17L29 17L29 16L30 16L30 15L29 15L29 13L30 13L30 14L31 14L31 13L33 13L33 12L31 12L31 11L26 11L26 12L25 12L25 11L24 11L24 8L25 8L25 10L27 10L27 9L26 9L26 8L25 8L25 7L26 7L26 6L25 6L25 5L26 5L26 4L25 4L25 2L26 2L26 3L28 3L28 4L30 4L30 3L29 3L29 2L26 2L26 1ZM18 3L18 5L19 5L19 3ZM45 3L45 5L46 5L46 3ZM27 5L27 8L30 8L30 5ZM42 5L42 7L43 7L43 8L44 8L44 7L45 7L45 6L44 6L44 7L43 7L43 5ZM24 6L24 7L25 7L25 6ZM28 6L28 7L29 7L29 6ZM34 6L34 7L35 7L35 6ZM39 6L39 7L40 7L40 6ZM13 7L13 9L14 9L14 11L15 11L15 13L13 13L13 15L14 15L14 18L13 18L13 19L12 19L12 20L13 20L13 19L15 19L15 18L17 18L17 17L18 17L18 19L16 19L16 20L14 20L14 21L15 21L15 23L16 23L16 24L14 24L14 23L13 23L13 22L12 22L12 23L13 23L13 24L12 24L12 25L13 25L13 26L14 26L14 25L15 25L15 26L16 26L16 25L17 25L17 26L18 26L18 25L19 25L19 27L23 27L23 30L22 30L22 29L21 29L21 30L22 30L22 31L20 31L20 33L21 33L21 32L22 32L22 35L26 35L26 36L25 36L25 37L27 37L27 35L28 35L28 37L29 37L29 39L30 39L30 38L31 38L31 40L27 40L27 42L29 42L29 41L30 41L30 44L29 44L29 43L28 43L28 44L29 44L29 45L30 45L30 46L31 46L31 45L32 45L32 47L33 47L33 46L34 46L34 48L33 48L33 50L34 50L34 48L35 48L35 47L36 47L36 49L35 49L35 51L36 51L36 49L37 49L37 48L38 48L38 45L37 45L37 47L36 47L36 45L35 45L35 46L34 46L34 45L32 45L32 43L31 43L31 41L33 41L33 43L35 43L35 44L37 44L37 42L38 42L38 44L39 44L39 47L40 47L40 45L41 45L41 48L42 48L42 49L43 49L43 48L45 48L45 45L44 45L44 44L43 44L43 43L42 43L42 45L41 45L41 43L40 43L40 44L39 44L39 42L38 42L38 41L37 41L37 42L36 42L36 40L35 40L35 39L38 39L38 40L39 40L39 41L40 41L40 42L42 42L42 41L43 41L43 42L45 42L45 40L46 40L46 38L45 38L45 37L46 37L46 36L48 36L48 35L49 35L49 34L48 34L48 33L50 33L50 36L51 36L51 35L52 35L52 37L54 37L54 38L53 38L53 39L54 39L54 38L55 38L55 37L54 37L54 35L55 35L55 32L54 32L54 29L55 29L55 27L53 27L53 25L52 25L52 23L51 23L51 25L50 25L50 23L49 23L49 25L50 25L50 26L48 26L48 23L47 23L47 22L46 22L46 21L44 21L44 22L43 22L43 18L44 18L44 17L46 17L46 19L45 19L45 20L47 20L47 21L48 21L48 22L49 22L49 20L50 20L50 21L51 21L51 20L50 20L50 19L51 19L51 18L52 18L52 17L51 17L51 16L50 16L50 17L49 17L49 20L47 20L47 19L48 19L48 18L47 18L47 17L46 17L46 16L45 16L45 15L44 15L44 14L42 14L42 15L41 15L41 13L40 13L40 10L39 10L39 13L38 13L38 12L37 12L37 9L36 9L36 13L35 13L35 15L39 15L39 16L38 16L38 17L37 17L37 19L36 19L36 18L35 18L35 17L36 17L36 16L35 16L35 17L33 17L33 18L31 18L31 19L35 19L35 20L37 20L37 22L36 22L36 21L35 21L35 22L32 22L32 20L30 20L30 19L28 19L28 20L27 20L27 19L25 19L25 18L24 18L24 19L22 19L22 18L21 18L21 19L20 19L20 16L19 16L19 17L18 17L18 16L17 16L17 14L18 14L18 12L17 12L17 11L16 11L16 10L15 10L15 9L14 9L14 7ZM0 8L0 9L4 9L4 8ZM6 8L6 9L7 9L7 8ZM28 9L28 10L30 10L30 9ZM8 10L8 13L6 13L6 12L7 12L7 11L6 11L6 12L5 12L5 13L4 13L4 15L5 15L5 14L8 14L8 15L9 15L9 17L8 17L8 18L9 18L9 17L10 17L10 14L8 14L8 13L10 13L10 11L11 11L11 10L10 10L10 11L9 11L9 10ZM0 11L0 12L2 12L2 11ZM23 12L23 13L24 13L24 12ZM26 12L26 14L25 14L25 16L24 16L24 17L25 17L25 16L26 16L26 15L27 15L27 12ZM15 13L15 14L14 14L14 15L15 15L15 16L16 16L16 14L17 14L17 13ZM36 13L36 14L38 14L38 13ZM39 13L39 15L40 15L40 13ZM0 14L0 15L1 15L1 14ZM19 14L19 15L20 15L20 14ZM6 15L6 16L5 16L5 18L4 18L4 19L5 19L5 18L7 18L7 17L6 17L6 16L7 16L7 15ZM28 15L28 16L29 16L29 15ZM42 15L42 16L39 16L39 17L38 17L38 18L41 18L41 17L42 17L42 18L43 18L43 17L42 17L42 16L43 16L43 15ZM52 15L52 16L53 16L53 15ZM56 16L56 18L57 18L57 16ZM50 17L50 18L51 18L51 17ZM6 19L6 20L5 20L5 21L6 21L6 22L7 22L7 21L8 21L8 23L5 23L5 24L4 24L4 25L3 25L3 24L2 24L2 26L4 26L4 25L5 25L5 26L7 26L7 25L8 25L8 24L9 24L9 25L10 25L10 24L9 24L9 19L8 19L8 20L7 20L7 19ZM18 19L18 20L17 20L17 21L16 21L16 23L18 23L18 22L19 22L19 23L20 23L20 24L19 24L19 25L20 25L20 24L22 24L22 25L23 25L23 26L24 26L24 27L25 27L25 29L24 29L24 32L25 32L25 34L26 34L26 35L27 35L27 34L30 34L30 35L29 35L29 36L30 36L30 35L31 35L31 38L33 38L33 36L32 36L32 34L31 34L31 33L33 33L33 34L36 34L36 35L37 35L37 34L38 34L38 36L37 36L37 37L39 37L39 38L38 38L38 39L40 39L40 41L42 41L42 38L44 38L44 39L45 39L45 38L44 38L44 37L45 37L45 36L46 36L46 34L47 34L47 33L48 33L48 31L46 31L46 32L45 32L45 31L44 31L44 32L43 32L43 29L44 29L44 30L45 30L45 29L44 29L44 27L46 27L46 29L47 29L47 30L48 30L48 27L47 27L47 24L46 24L46 25L45 25L45 24L44 24L44 25L43 25L43 24L42 24L42 25L41 25L41 23L40 23L40 24L39 24L39 23L38 23L38 24L37 24L37 26L35 26L35 25L36 25L36 23L35 23L35 25L34 25L34 23L33 23L33 24L32 24L32 22L31 22L31 23L30 23L30 20L29 20L29 21L28 21L28 22L27 22L27 21L25 21L25 23L22 23L22 19L21 19L21 21L20 21L20 19ZM24 19L24 20L25 20L25 19ZM37 19L37 20L38 20L38 19ZM39 19L39 20L40 20L40 19ZM41 19L41 20L42 20L42 19ZM3 20L3 21L4 21L4 20ZM6 20L6 21L7 21L7 20ZM33 20L33 21L34 21L34 20ZM17 21L17 22L18 22L18 21ZM19 21L19 22L20 22L20 21ZM23 21L23 22L24 22L24 21ZM38 21L38 22L40 22L40 21ZM55 21L55 22L56 22L56 21ZM26 22L26 23L25 23L25 25L26 25L26 29L25 29L25 32L26 32L26 33L27 33L27 32L26 32L26 31L30 31L30 33L31 33L31 30L32 30L32 31L33 31L33 30L34 30L34 32L33 32L33 33L35 33L35 32L37 32L37 33L38 33L38 32L40 32L40 33L39 33L39 34L42 34L42 35L41 35L41 36L45 36L45 34L46 34L46 33L47 33L47 32L46 32L46 33L44 33L44 35L43 35L43 32L42 32L42 33L41 33L41 31L40 31L40 30L41 30L41 29L43 29L43 27L42 27L42 28L41 28L41 26L40 26L40 25L39 25L39 24L38 24L38 27L37 27L37 29L36 29L36 28L35 28L35 29L34 29L34 28L33 28L33 27L31 27L31 26L34 26L34 25L32 25L32 24L31 24L31 26L28 26L28 24L26 24L26 23L27 23L27 22ZM44 22L44 23L45 23L45 22ZM5 24L5 25L7 25L7 24ZM44 25L44 26L45 26L45 25ZM39 26L39 27L40 27L40 26ZM5 27L5 30L8 30L8 27ZM27 27L27 30L30 30L30 27ZM49 27L49 30L52 30L52 27ZM3 28L3 29L4 29L4 28ZM6 28L6 29L7 29L7 28ZM19 28L19 30L20 30L20 28ZM28 28L28 29L29 29L29 28ZM31 28L31 29L32 29L32 28ZM38 28L38 29L37 29L37 30L39 30L39 29L41 29L41 28ZM50 28L50 29L51 29L51 28ZM53 28L53 29L54 29L54 28ZM0 29L0 30L1 30L1 29ZM35 29L35 31L36 31L36 29ZM10 30L10 31L9 31L9 33L10 33L10 31L11 31L11 33L12 33L12 34L13 34L13 35L14 35L14 34L13 34L13 33L14 33L14 32L13 32L13 33L12 33L12 31L11 31L11 30ZM22 31L22 32L23 32L23 31ZM37 31L37 32L38 32L38 31ZM50 31L50 33L51 33L51 31ZM52 31L52 34L54 34L54 32L53 32L53 31ZM23 33L23 34L24 34L24 33ZM3 34L3 35L4 35L4 34ZM15 34L15 36L14 36L14 39L13 39L13 40L12 40L12 42L13 42L13 41L14 41L14 39L15 39L15 38L17 38L17 39L16 39L16 40L15 40L15 42L14 42L14 44L13 44L13 43L11 43L11 42L10 42L10 41L8 41L8 42L9 42L9 43L10 43L10 44L13 44L13 45L14 45L14 44L15 44L15 42L16 42L16 43L17 43L17 45L18 45L18 46L19 46L19 44L20 44L20 45L21 45L21 44L20 44L20 43L18 43L18 42L20 42L20 41L18 41L18 42L17 42L17 41L16 41L16 40L17 40L17 39L18 39L18 40L19 40L19 39L21 39L21 40L22 40L22 39L21 39L21 37L22 37L22 38L24 38L24 36L23 36L23 37L22 37L22 36L21 36L21 34L19 34L19 35L20 35L20 38L19 38L19 36L18 36L18 38L17 38L17 37L16 37L16 36L17 36L17 35L18 35L18 34L17 34L17 35L16 35L16 34ZM6 36L6 37L7 37L7 36ZM12 36L12 37L13 37L13 36ZM34 36L34 39L33 39L33 40L34 40L34 39L35 39L35 38L36 38L36 37L35 37L35 36ZM39 36L39 37L40 37L40 39L41 39L41 37L40 37L40 36ZM18 38L18 39L19 39L19 38ZM26 38L26 39L28 39L28 38ZM24 39L24 40L23 40L23 42L24 42L24 41L25 41L25 44L26 44L26 41L25 41L25 39ZM21 41L21 42L22 42L22 41ZM7 43L7 44L8 44L8 43ZM30 44L30 45L31 45L31 44ZM1 45L1 47L2 47L2 45ZM4 45L4 46L3 46L3 47L5 47L5 45ZM8 45L8 47L10 47L10 46L11 46L11 45ZM43 45L43 47L42 47L42 48L43 48L43 47L44 47L44 45ZM49 45L49 48L50 48L50 46L51 46L51 45ZM20 46L20 47L21 47L21 46ZM51 47L51 48L52 48L52 47ZM39 48L39 49L38 49L38 51L39 51L39 50L40 50L40 48ZM27 49L27 52L30 52L30 49ZM49 49L49 52L52 52L52 49ZM12 50L12 51L13 51L13 52L14 52L14 53L15 53L15 52L14 52L14 51L13 51L13 50ZM21 50L21 51L22 51L22 50ZM28 50L28 51L29 51L29 50ZM50 50L50 51L51 51L51 50ZM25 51L25 52L26 52L26 51ZM55 51L55 53L56 53L56 51ZM18 52L18 53L19 53L19 52ZM31 52L31 53L32 53L32 52ZM33 52L33 54L34 54L34 52ZM50 53L50 54L51 54L51 53ZM18 54L18 55L19 55L19 56L20 56L20 55L19 55L19 54ZM53 54L53 56L52 56L52 57L55 57L55 56L54 56L54 54ZM14 55L14 56L13 56L13 57L14 57L14 56L15 56L15 55ZM27 55L27 57L31 57L31 56L30 56L30 55L29 55L29 56L28 56L28 55ZM56 55L56 56L57 56L57 55ZM0 0L0 7L7 7L7 0ZM1 1L1 6L6 6L6 1ZM2 2L2 5L5 5L5 2ZM50 0L50 7L57 7L57 0ZM51 1L51 6L56 6L56 1ZM52 2L52 5L55 5L55 2ZM0 50L0 57L7 57L7 50ZM1 51L1 56L6 56L6 51ZM2 52L2 55L5 55L5 52Z\\\" fill=\\\"#000000\\\"\\/><\\/g><\\/g><\\/svg>\\n\\n                            <span style=\\\"width:50%;\\\">\\n                                <img style=\\\"max-height: 70px\\\"\\n                                     src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/img\\/AfipComprobanteAutorizado.png\\\">\\n                            <\\/span>\\n                        <\\/th>\\n                        <th style=\\\"text-align:right;\\\">\\n                            <p>CAE N&#186;: 71304902485732<br>\\n                                Fecha Vto. CAE:  25\\/07\\/2021\\n                            <\\/p>\\n                        <\\/th>\\n                    <\\/tr>\\n                <\\/table>\\n                    <\\/div>\\n    <\\/div>\\n\\n    <\\/body>\\n<\\/html>\\\";s:4:\\\"file\\\";N;}s:6:\\\"locale\\\";N;s:4:\\\"from\\\";a:0:{}s:2:\\\"to\\\";a:1:{i:0;a:2:{s:4:\\\"name\\\";N;s:7:\\\"address\\\";s:24:\\\"hisandherskids@gmail.com\\\";}}s:2:\\\"cc\\\";a:0:{}s:3:\\\"bcc\\\";a:1:{i:0;a:2:{s:4:\\\"name\\\";N;s:7:\\\"address\\\";s:23:\\\"info@masquecontable.com\\\";}}s:7:\\\"replyTo\\\";a:0:{}s:7:\\\"subject\\\";N;s:11:\\\"\\u0000*\\u0000markdown\\\";N;s:7:\\\"\\u0000*\\u0000html\\\";N;s:4:\\\"view\\\";N;s:8:\\\"textView\\\";N;s:8:\\\"viewData\\\";a:0:{}s:11:\\\"attachments\\\";a:0:{}s:14:\\\"rawAttachments\\\";a:0:{}s:15:\\\"diskAttachments\\\";a:0:{}s:9:\\\"callbacks\\\";a:0:{}s:5:\\\"theme\\\";N;s:6:\\\"mailer\\\";s:8:\\\"sendgrid\\\";s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:5:\\\"delay\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;}\"}}','ErrorException: Trying to get property \'id\' of non-object in /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php:16\nStack trace:\n#0 /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php(16): Illuminate\\Foundation\\Bootstrap\\HandleExceptions->handleError(8, \'Trying to get p...\', \'/home/forge/tax...\', 16, Array)\n#1 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(356): App\\Queue\\DatabaseJob->fire()\n#2 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(306): Illuminate\\Queue\\Worker->process(\'database\', Object(App\\Queue\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#3 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(132): Illuminate\\Queue\\Worker->runJob(Object(App\\Queue\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#4 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(112): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#5 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(96): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#6 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#7 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#8 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#9 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#10 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#11 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(134): Illuminate\\Container\\Container->call(Array)\n#12 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(256): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#13 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(121): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#14 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(971): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#15 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(290): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#16 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(166): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#17 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Application.php(93): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(129): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#19 /home/forge/taxes.com.ar/artisan(35): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#20 {main}','2021-07-23 18:04:10',NULL);
INSERT INTO `failed_jobs` VALUES (15,NULL,'database','default','{\"uuid\":\"a6ebb8c7-53e8-4467-859e-07536b4179aa\",\"displayName\":\"App\\\\Mail\\\\Fact_Electronica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"delay\":null,\"timeout\":null,\"timeoutAt\":null,\"data\":{\"commandName\":\"Illuminate\\\\Mail\\\\SendQueuedMailable\",\"command\":\"O:34:\\\"Illuminate\\\\Mail\\\\SendQueuedMailable\\\":3:{s:8:\\\"mailable\\\";O:25:\\\"App\\\\Mail\\\\Fact_Electronica\\\":27:{s:11:\\\"informacion\\\";a:6:{s:12:\\\"ruta_logo_fa\\\";N;s:4:\\\"mail\\\";s:23:\\\"info@masquecontable.com\\\";s:18:\\\"name_quien_factura\\\";s:19:\\\"MICAELA AILIN CORIA\\\";s:7:\\\"cliente\\\";O:17:\\\"App\\\\Models\\\\Person\\\":27:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:7:\\\"persons\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:40723;s:7:\\\"user_id\\\";i:5117;s:11:\\\"field_name1\\\";s:14:\\\"MARCOS AIRALDI\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"20-40364036-1\\\";s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-07-05 12:44:11\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-07-19 13:56:08\\\";s:11:\\\"activity_id\\\";i:1;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";i:1;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:40723;s:7:\\\"user_id\\\";i:5117;s:11:\\\"field_name1\\\";s:14:\\\"MARCOS AIRALDI\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"20-40364036-1\\\";s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-07-05 12:44:11\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-07-19 13:56:08\\\";s:11:\\\"activity_id\\\";i:1;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";i:1;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}s:14:\\\"nombre_del_pdf\\\";s:28:\\\"Factura N\\u00b00004-00000018.pdf\\\";s:9:\\\"body_mail\\\";s:155:\\\"Estimado cliente, se env\\u00eda adjunta la factura de honorarios correspondientes al mes de Julio 2021.\\nMuchas gracias por seguir eligiendo nuestros servicios.\\\";}s:3:\\\"pdf\\\";O:26:\\\"Barryvdh\\\\Snappy\\\\PdfWrapper\\\":4:{s:9:\\\"\\u0000*\\u0000snappy\\\";O:35:\\\"Barryvdh\\\\Snappy\\\\IlluminateSnappyPdf\\\":10:{s:26:\\\"\\u0000*\\u0000optionsWithContentCheck\\\";a:4:{s:11:\\\"header-html\\\";s:4:\\\"html\\\";s:11:\\\"footer-html\\\";s:4:\\\"html\\\";s:5:\\\"cover\\\";s:4:\\\"html\\\";s:15:\\\"xsl-style-sheet\\\";s:3:\\\"xsl\\\";}s:36:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000binary\\\";s:76:\\\"\\/home\\/forge\\/taxes.com.ar\\/vendor\\/h4cc\\/wkhtmltopdf-amd64\\/bin\\/wkhtmltopdf-amd64\\\";s:37:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000options\\\";a:132:{s:7:\\\"collate\\\";N;s:10:\\\"no-collate\\\";N;s:10:\\\"cookie-jar\\\";N;s:6:\\\"copies\\\";i:1;s:3:\\\"dpi\\\";N;s:13:\\\"extended-help\\\";N;s:9:\\\"grayscale\\\";N;s:4:\\\"help\\\";N;s:7:\\\"htmldoc\\\";N;s:18:\\\"ignore-load-errors\\\";N;s:9:\\\"image-dpi\\\";N;s:13:\\\"image-quality\\\";N;s:7:\\\"license\\\";N;s:9:\\\"log-level\\\";N;s:10:\\\"lowquality\\\";b:1;s:7:\\\"manpage\\\";N;s:13:\\\"margin-bottom\\\";N;s:11:\\\"margin-left\\\";N;s:12:\\\"margin-right\\\";N;s:10:\\\"margin-top\\\";N;s:11:\\\"orientation\\\";N;s:11:\\\"page-height\\\";N;s:9:\\\"page-size\\\";s:2:\\\"a4\\\";s:10:\\\"page-width\\\";N;s:18:\\\"no-pdf-compression\\\";N;s:5:\\\"quiet\\\";N;s:20:\\\"read-args-from-stdin\\\";N;s:6:\\\"readme\\\";N;s:5:\\\"title\\\";N;s:11:\\\"use-xserver\\\";N;s:7:\\\"version\\\";N;s:20:\\\"dump-default-toc-xsl\\\";N;s:12:\\\"dump-outline\\\";N;s:7:\\\"outline\\\";N;s:10:\\\"no-outline\\\";N;s:13:\\\"outline-depth\\\";N;s:13:\\\"output-format\\\";N;s:5:\\\"allow\\\";N;s:10:\\\"background\\\";N;s:13:\\\"no-background\\\";N;s:16:\\\"bypass-proxy-for\\\";N;s:9:\\\"cache-dir\\\";N;s:20:\\\"checkbox-checked-svg\\\";N;s:12:\\\"checkbox-svg\\\";N;s:6:\\\"cookie\\\";N;s:13:\\\"custom-header\\\";N;s:25:\\\"custom-header-propagation\\\";N;s:28:\\\"no-custom-header-propagation\\\";N;s:16:\\\"debug-javascript\\\";N;s:19:\\\"no-debug-javascript\\\";N;s:14:\\\"default-header\\\";N;s:8:\\\"encoding\\\";N;s:22:\\\"disable-external-links\\\";N;s:21:\\\"enable-external-links\\\";N;s:13:\\\"disable-forms\\\";N;s:12:\\\"enable-forms\\\";N;s:6:\\\"images\\\";N;s:9:\\\"no-images\\\";N;s:22:\\\"disable-internal-links\\\";N;s:21:\\\"enable-internal-links\\\";N;s:18:\\\"disable-javascript\\\";N;s:17:\\\"enable-javascript\\\";N;s:16:\\\"javascript-delay\\\";N;s:19:\\\"keep-relative-links\\\";N;s:19:\\\"load-error-handling\\\";N;s:25:\\\"load-media-error-handling\\\";N;s:25:\\\"disable-local-file-access\\\";N;s:24:\\\"enable-local-file-access\\\";N;s:17:\\\"minimum-font-size\\\";N;s:20:\\\"exclude-from-outline\\\";N;s:18:\\\"include-in-outline\\\";N;s:11:\\\"page-offset\\\";N;s:8:\\\"password\\\";N;s:15:\\\"disable-plugins\\\";N;s:14:\\\"enable-plugins\\\";N;s:4:\\\"post\\\";N;s:9:\\\"post-file\\\";N;s:16:\\\"print-media-type\\\";N;s:19:\\\"no-print-media-type\\\";N;s:5:\\\"proxy\\\";N;s:21:\\\"proxy-hostname-lookup\\\";N;s:23:\\\"radiobutton-checked-svg\\\";N;s:15:\\\"radiobutton-svg\\\";N;s:14:\\\"redirect-delay\\\";N;s:22:\\\"resolve-relative-links\\\";N;s:10:\\\"run-script\\\";N;s:23:\\\"disable-smart-shrinking\\\";N;s:22:\\\"enable-smart-shrinking\\\";N;s:12:\\\"ssl-crt-path\\\";N;s:16:\\\"ssl-key-password\\\";N;s:12:\\\"ssl-key-path\\\";N;s:17:\\\"stop-slow-scripts\\\";N;s:20:\\\"no-stop-slow-scripts\\\";N;s:22:\\\"disable-toc-back-links\\\";N;s:21:\\\"enable-toc-back-links\\\";N;s:16:\\\"user-style-sheet\\\";N;s:8:\\\"username\\\";N;s:13:\\\"viewport-size\\\";N;s:13:\\\"window-status\\\";N;s:4:\\\"zoom\\\";N;s:13:\\\"footer-center\\\";s:25:\\\"Pagina [page] de [toPage]\\\";s:16:\\\"footer-font-name\\\";N;s:16:\\\"footer-font-size\\\";i:8;s:11:\\\"footer-html\\\";N;s:11:\\\"footer-left\\\";s:0:\\\"\\\";s:11:\\\"footer-line\\\";N;s:14:\\\"no-footer-line\\\";N;s:12:\\\"footer-right\\\";N;s:14:\\\"footer-spacing\\\";N;s:13:\\\"header-center\\\";N;s:16:\\\"header-font-name\\\";N;s:16:\\\"header-font-size\\\";N;s:11:\\\"header-html\\\";N;s:11:\\\"header-left\\\";N;s:11:\\\"header-line\\\";N;s:14:\\\"no-header-line\\\";N;s:12:\\\"header-right\\\";N;s:14:\\\"header-spacing\\\";N;s:7:\\\"replace\\\";N;s:5:\\\"cover\\\";N;s:3:\\\"toc\\\";N;s:20:\\\"disable-dotted-lines\\\";N;s:9:\\\"toc-depth\\\";N;s:13:\\\"toc-font-name\\\";N;s:16:\\\"toc-l1-font-size\\\";N;s:15:\\\"toc-header-text\\\";N;s:20:\\\"toc-header-font-name\\\";N;s:20:\\\"toc-header-font-size\\\";N;s:21:\\\"toc-level-indentation\\\";N;s:17:\\\"disable-toc-links\\\";N;s:20:\\\"toc-text-size-shrink\\\";N;s:15:\\\"xsl-style-sheet\\\";N;}s:33:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000env\\\";N;s:37:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000timeout\\\";b:0;s:46:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000defaultExtension\\\";s:3:\\\"pdf\\\";s:18:\\\"\\u0000*\\u0000temporaryFolder\\\";N;s:14:\\\"temporaryFiles\\\";a:0:{}s:36:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000logger\\\";O:18:\\\"Psr\\\\Log\\\\NullLogger\\\":0:{}s:2:\\\"fs\\\";O:32:\\\"Illuminate\\\\Filesystem\\\\Filesystem\\\":0:{}}s:10:\\\"\\u0000*\\u0000options\\\";a:0:{}s:4:\\\"html\\\";s:22167:\\\"<!DOCTYPE html>\\n<html lang=\\\"en\\\">\\n    <head>\\n        <meta charset=\\\"utf-8\\\">\\n    <\\/head>\\n    <style>\\n        .subtotales_conceptos{\\n            width:30%;\\n            text-align: right;\\n        }\\n        .subtotales_importes{\\n            text-align: right;\\n        }\\n        .table-totales, .table-totales tr, .table-totales th{\\n            border: 1px solid;\\n        }\\n\\n    <\\/style>\\n    <body>\\n    <div style=\\\"max-height:840px\\\">\\n        <div style=\\\"width: 100%; height:270px\\\"> <!-- Datos de la empresa -->\\n            <table class=\\\"display\\\" cellspacing=\\\"0\\\" width=\\\"100%\\\" style=\\\"border:  1px solid;\\\">\\n                <tr style=\\\"\\\">\\n                    <th colspan=\\\"2\\\" rowspan=\\\"2\\\" style=\\\"width:45%;margin:0;height:150px;\\\">\\n                                                <img src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/img\\/\\/27377183504\\/logo_punto_venta_0000.png\\\"\\/>\\n                                            <\\/th>\\n                    <th style=\\\"border:  1px solid;text-align: center; width:10%\\\" colspan=\\\"2\\\">\\n                        <span style=\\\"font-size: 60px;\\\">C<\\/span> <br \\/> <span style=\\\"font-size: 14px;\\\">cod. 11<\\/span>\\n                    <\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"font-size: 28px;text-align: center;width:45%\\\">\\n                        Factura\\n                        <br>\\n                        0004 - 00000018\\n                    <\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th><\\/th>\\n                    <th style=\\\"border:  1px 1px 1px 0px solid;\\\" colspan=\\\"2\\\"><\\/th>\\n                    <th><\\/th>\\n                <\\/tr>\\n                <tr>\\n\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                                                    Raz&oacute;n Social:\\n                            <span style=\\\"font-weight: normal;\\\">MICAELA AILIN CORIA<\\/span>\\n                                            <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">Fecha de Emisi&oacute;n: <span style=\\\"font-weight: normal;\\\">15\\/07\\/2021<\\/span><\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Domicilio Comercial: <span style=\\\"font-weight: normal;\\\">Victor Guillet esq. Arturo M Bas, C.P.:5800,\\n                        C\\u00f3rdoba<\\/span>\\n                    <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">CUIT: <span style=\\\"font-weight: normal;\\\">27-37718350-4<\\/span><\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Condici&oacute;n frente al IVA: <span style=\\\"font-weight: normal;\\\">Monotributo<\\/span>\\n                    <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Ingresos Brutos: <span style=\\\"font-weight: normal;\\\"><\\/span>\\n                        <br>\\n                        Fecha de Inicio de Actividades: <span style=\\\"font-weight: normal;\\\">09\\/07\\/2021<\\/span>\\n                    <\\/th>\\n                <\\/tr>\\n            <\\/table>\\n        <\\/div>\\n\\n        <table style=\\\"text-align: center; width: 100%;border: solid 1px;\\\"> <!-- Fechas -->\\n            <thead>\\n                <tr>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Per\\u00edodo Facturado Desde: 01\\/07\\/2021<\\/small><\\/th>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Per\\u00edodo Facturado Hasta: 31\\/07\\/2021<\\/small><\\/th>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Fecha Vto. Pago: 15\\/07\\/2021<\\/small><\\/th>\\n                <\\/tr>\\n            <\\/thead>\\n        <\\/table>\\n        \\n        <table style=\\\"width: 100%; margin-top: 1%;border: solid 1px;\\\"> <!-- Datos Clientes -->\\n            <tr>\\n                <th style=\\\"text-align:left;\\\"colspan=\\\"12\\\">\\n                    CUIT: <span style=\\\"font-weight: normal;\\\">20-40364036-1<\\/span>\\n                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\\n                    Apellido y Nombre \\/ Raz&oacute;n Social: <span style=\\\"font-weight: normal;\\\">\\n                    MARCOS AIRALDI<\\/span>\\n                <\\/th>\\n            <\\/tr>\\n            <tr>\\n                <th style=\\\"text-align:left; width:50%\\\">\\n                    Condici&oacute;n Frente al IVA: <span style=\\\"font-weight: normal;\\\">Responsable Monotributo<\\/span>\\n                <\\/th>\\n                <th style=\\\"text-align:left; width:50%\\\" colspan=\\\"4\\\">\\n                    Domicilio Comercial:\\n                    <span style=\\\"font-weight: normal;\\\">\\n                    --------\\n                    <\\/span>\\n                <\\/th>\\n            <\\/tr>\\n            <tr style=\\\"text-align:left\\\">\\n                <th>Condici&oacute;n de Venta: <span style=\\\"font-weight: normal;\\\">Cuenta Corriente<\\/span><\\/th>\\n            <\\/tr>\\n        <\\/table>\\n\\n        <div style=\\\"border: 1px solid;margin-top: 1%;min-height:600px;\\\">\\n        <table style=\\\"text-align: center; width: 100%; margin-top: 1%;\\\"> <!-- Body -->\\n            <tr style=\\\"border-bottom: 1px solid;font-size: 15px\\\">\\n                <th>C&oacute;digo<\\/th>\\n                <th style=\\\"width: 25%;\\\">Detalle<\\/th>\\n                <th>Cantidad<\\/th>\\n                <th>U.Medida<\\/th>\\n                <th>Precio U.<\\/th>\\n                <th>Bonif. (%)<\\/th>\\n                <th>Precio Bonif.<\\/th>\\n                <th>Subtotal<\\/th>\\n                            <\\/tr>\\n            <tbody>\\n                                                                                <tr style=\\\"font-size: 12px;\\\">\\n                        <td>\\n                            \\n                        <\\/td>\\n                        <td>\\n                            Honorarios profesionales Julio 2021\\n                        <\\/td>\\n                        <td>\\n                            1.00\\n                        <\\/td>\\n                        <td>\\n                            Unidades\\n                        <\\/td>\\n                        <td>                            2.950,00\\n                                                    <\\/td>\\n                        <td>\\n                            0,00%\\n                        <\\/td>\\n                        <td>\\n                            0,00\\n                        <\\/td>\\n                        <td>\\n                            2.950,00\\n                        <\\/td>\\n                                            <\\/tr>\\n                    \\n            <\\/tbody>\\n        <\\/table>\\n        <\\/div>\\n\\n        \\n\\n        <div style=\\\"height:200px;margin-top: 1%;\\\"> <!-- Totales -->\\n              <!-- Es factura B o C -->\\n                <table class=\\\"table-totales\\\" cellspacing=\\\"0\\\" width=\\\"100%\\\">\\n                    <tr>\\n                        <th style=\\\"width:50%; text-align:left;\\\">\\n\\n<!--                                <span style=\\\"width:100%;\\\"><img src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/barcodes\\/71304902487289.png\\\"><\\/span>\\n                                <span style=\\\"text-align:center;\\\">2737718350411000471304902487289202107254<\\/span>-->\\n                        <\\/th>\\n                        <th class=\\\"subtotales_conceptos\\\">TOTAL:<\\/th>\\n                        <th class=\\\"subtotales_importes\\\">$ 2.950,00<\\/th>\\n                    <\\/tr>\\n                <\\/table>\\n                <br>\\n                <table cellspacing=\\\"0\\\" width=\\\"100%\\\" style=\\\"border: none\\\">\\n                    <tr>\\n                        <th style=\\\"width:50%; text-align:left;\\\">\\n\\n                            <?xml version=\\\"1.0\\\" encoding=\\\"UTF-8\\\"?>\\n<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" version=\\\"1.1\\\" width=\\\"100\\\" height=\\\"100\\\" viewBox=\\\"0 0 100 100\\\"><rect x=\\\"0\\\" y=\\\"0\\\" width=\\\"100\\\" height=\\\"100\\\" fill=\\\"#ffffff\\\"\\/><g transform=\\\"scale(1.754)\\\"><g transform=\\\"translate(0,0)\\\"><path fill-rule=\\\"evenodd\\\" d=\\\"M8 0L8 1L10 1L10 4L11 4L11 2L12 2L12 4L14 4L14 3L15 3L15 5L17 5L17 4L16 4L16 3L17 3L17 2L18 2L18 1L17 1L17 2L15 2L15 1L16 1L16 0L14 0L14 2L13 2L13 0L11 0L11 1L10 1L10 0ZM22 0L22 1L23 1L23 2L22 2L22 3L21 3L21 4L20 4L20 5L21 5L21 4L22 4L22 12L21 12L21 11L20 11L20 12L19 12L19 10L20 10L20 9L21 9L21 8L20 8L20 7L21 7L21 6L20 6L20 7L19 7L19 6L18 6L18 7L17 7L17 6L16 6L16 7L15 7L15 6L14 6L14 5L11 5L11 6L10 6L10 7L9 7L9 6L8 6L8 7L9 7L9 8L8 8L8 9L7 9L7 8L6 8L6 9L4 9L4 8L0 8L0 9L4 9L4 11L3 11L3 13L2 13L2 12L1 12L1 11L2 11L2 10L1 10L1 11L0 11L0 13L2 13L2 14L3 14L3 16L2 16L2 17L4 17L4 18L3 18L3 19L2 19L2 20L1 20L1 18L0 18L0 20L1 20L1 21L0 21L0 22L2 22L2 20L4 20L4 22L3 22L3 23L1 23L1 24L0 24L0 25L1 25L1 26L0 26L0 28L1 28L1 30L2 30L2 31L0 31L0 32L2 32L2 33L0 33L0 34L1 34L1 37L3 37L3 39L4 39L4 38L5 38L5 39L7 39L7 40L4 40L4 41L3 41L3 40L2 40L2 38L0 38L0 40L1 40L1 41L0 41L0 42L5 42L5 43L7 43L7 44L4 44L4 43L2 43L2 47L1 47L1 44L0 44L0 48L5 48L5 47L7 47L7 46L8 46L8 47L10 47L10 48L6 48L6 49L8 49L8 50L9 50L9 49L10 49L10 48L11 48L11 50L10 50L10 51L12 51L12 52L13 52L13 53L14 53L14 54L15 54L15 53L16 53L16 54L17 54L17 55L18 55L18 56L17 56L17 57L18 57L18 56L19 56L19 57L21 57L21 56L19 56L19 55L18 55L18 54L20 54L20 51L21 51L21 52L23 52L23 50L24 50L24 53L25 53L25 54L23 54L23 56L22 56L22 57L24 57L24 56L26 56L26 55L25 55L25 54L27 54L27 53L31 53L31 54L33 54L33 55L32 55L32 56L34 56L34 57L36 57L36 55L38 55L38 56L37 56L37 57L44 57L44 56L43 56L43 55L42 55L42 56L41 56L41 55L40 55L40 54L42 54L42 53L40 53L40 52L43 52L43 53L45 53L45 52L46 52L46 51L45 51L45 49L47 49L47 48L48 48L48 50L47 50L47 53L46 53L46 54L44 54L44 55L45 55L45 56L46 56L46 57L47 57L47 56L48 56L48 55L49 55L49 54L50 54L50 57L51 57L51 54L52 54L52 53L53 53L53 54L54 54L54 55L53 55L53 56L52 56L52 57L55 57L55 56L54 56L54 55L55 55L55 54L56 54L56 53L57 53L57 51L56 51L56 49L57 49L57 48L56 48L56 49L55 49L55 51L53 51L53 49L54 49L54 48L53 48L53 46L54 46L54 45L56 45L56 46L55 46L55 47L57 47L57 44L53 44L53 46L52 46L52 43L51 43L51 44L50 44L50 42L51 42L51 41L50 41L50 40L52 40L52 42L54 42L54 43L55 43L55 42L57 42L57 40L56 40L56 38L57 38L57 31L56 31L56 30L57 30L57 27L56 27L56 24L57 24L57 21L56 21L56 20L53 20L53 19L54 19L54 18L55 18L55 14L54 14L54 10L53 10L53 9L55 9L55 10L56 10L56 11L55 11L55 12L57 12L57 8L56 8L56 9L55 9L55 8L52 8L52 10L51 10L51 11L50 11L50 10L49 10L49 9L50 9L50 8L48 8L48 7L49 7L49 6L48 6L48 7L47 7L47 5L48 5L48 0L45 0L45 1L43 1L43 0L39 0L39 1L41 1L41 4L40 4L40 5L39 5L39 2L38 2L38 1L37 1L37 2L36 2L36 1L32 1L32 2L31 2L31 0L30 0L30 1L29 1L29 0L28 0L28 1L26 1L26 0L24 0L24 1L23 1L23 0ZM19 1L19 2L21 2L21 1ZM25 1L25 2L23 2L23 3L22 3L22 4L23 4L23 3L24 3L24 5L23 5L23 12L22 12L22 13L23 13L23 14L24 14L24 16L23 16L23 15L22 15L22 14L20 14L20 13L19 13L19 12L18 12L18 10L19 10L19 9L20 9L20 8L18 8L18 9L17 9L17 8L15 8L15 7L14 7L14 6L13 6L13 7L14 7L14 9L13 9L13 8L11 8L11 7L12 7L12 6L11 6L11 7L10 7L10 8L9 8L9 9L8 9L8 10L7 10L7 9L6 9L6 10L5 10L5 11L6 11L6 12L5 12L5 13L3 13L3 14L4 14L4 15L5 15L5 16L7 16L7 17L5 17L5 18L4 18L4 19L5 19L5 18L7 18L7 17L8 17L8 18L9 18L9 17L10 17L10 14L11 14L11 15L12 15L12 16L11 16L11 18L10 18L10 19L11 19L11 20L10 20L10 23L11 23L11 25L12 25L12 27L13 27L13 28L12 28L12 29L11 29L11 26L9 26L9 28L10 28L10 29L9 29L9 31L8 31L8 33L9 33L9 34L7 34L7 33L6 33L6 32L7 32L7 31L6 31L6 32L3 32L3 31L2 31L2 32L3 32L3 33L6 33L6 34L7 34L7 35L6 35L6 36L5 36L5 37L6 37L6 38L7 38L7 37L6 37L6 36L8 36L8 37L9 37L9 38L8 38L8 40L7 40L7 41L6 41L6 42L7 42L7 43L8 43L8 44L7 44L7 45L4 45L4 46L3 46L3 47L5 47L5 46L7 46L7 45L8 45L8 46L10 46L10 47L11 47L11 48L13 48L13 49L14 49L14 50L12 50L12 51L15 51L15 49L16 49L16 53L17 53L17 51L20 51L20 48L22 48L22 49L23 49L23 48L22 48L22 47L24 47L24 46L22 46L22 43L24 43L24 44L23 44L23 45L25 45L25 46L27 46L27 44L28 44L28 47L26 47L26 48L24 48L24 50L25 50L25 49L26 49L26 48L28 48L28 47L29 47L29 48L30 48L30 47L32 47L32 50L31 50L31 51L32 51L32 50L33 50L33 51L35 51L35 52L36 52L36 53L35 53L35 55L34 55L34 56L35 56L35 55L36 55L36 53L37 53L37 54L38 54L38 55L39 55L39 56L40 56L40 55L39 55L39 53L37 53L37 51L38 51L38 52L40 52L40 50L41 50L41 51L42 51L42 50L43 50L43 51L44 51L44 49L45 49L45 48L46 48L46 46L47 46L47 45L48 45L48 44L49 44L49 42L50 42L50 41L47 41L47 42L48 42L48 43L46 43L46 44L45 44L45 42L46 42L46 40L47 40L47 39L48 39L48 38L50 38L50 39L52 39L52 40L53 40L53 41L54 41L54 42L55 42L55 41L56 41L56 40L55 40L55 41L54 41L54 39L55 39L55 38L56 38L56 36L55 36L55 35L56 35L56 32L55 32L55 30L56 30L56 27L55 27L55 22L56 22L56 21L55 21L55 22L54 22L54 21L53 21L53 22L51 22L51 21L52 21L52 20L51 20L51 19L50 19L50 20L49 20L49 17L50 17L50 18L51 18L51 17L52 17L52 19L53 19L53 17L54 17L54 14L52 14L52 13L53 13L53 10L52 10L52 11L51 11L51 12L52 12L52 13L51 13L51 15L50 15L50 16L49 16L49 17L47 17L47 16L46 16L46 15L47 15L47 13L48 13L48 14L50 14L50 12L49 12L49 10L48 10L48 8L47 8L47 9L46 9L46 10L48 10L48 11L46 11L46 12L47 12L47 13L46 13L46 14L45 14L45 12L44 12L44 13L43 13L43 12L42 12L42 13L41 13L41 9L44 9L44 10L43 10L43 11L45 11L45 7L46 7L46 5L47 5L47 3L46 3L46 2L47 2L47 1L45 1L45 3L44 3L44 5L43 5L43 4L41 4L41 7L42 7L42 8L41 8L41 9L39 9L39 8L38 8L38 9L37 9L37 8L35 8L35 7L36 7L36 6L37 6L37 7L38 7L38 6L37 6L37 5L38 5L38 3L37 3L37 5L35 5L35 4L34 4L34 5L33 5L33 7L32 7L32 4L33 4L33 3L34 3L34 2L33 2L33 3L31 3L31 8L32 8L32 9L31 9L31 10L33 10L33 11L34 11L34 10L35 10L35 13L34 13L34 14L32 14L32 15L33 15L33 17L30 17L30 18L28 18L28 19L27 19L27 17L29 17L29 16L30 16L30 15L29 15L29 13L30 13L30 14L31 14L31 13L33 13L33 12L31 12L31 11L26 11L26 12L25 12L25 11L24 11L24 8L25 8L25 10L27 10L27 9L26 9L26 8L25 8L25 7L26 7L26 6L25 6L25 5L26 5L26 4L25 4L25 2L26 2L26 3L28 3L28 4L30 4L30 3L29 3L29 2L26 2L26 1ZM8 2L8 5L9 5L9 2ZM18 3L18 5L19 5L19 3ZM45 3L45 5L46 5L46 3ZM27 5L27 8L30 8L30 5ZM42 5L42 7L43 7L43 8L44 8L44 7L45 7L45 6L44 6L44 7L43 7L43 5ZM24 6L24 7L25 7L25 6ZM28 6L28 7L29 7L29 6ZM34 6L34 7L35 7L35 6ZM39 6L39 7L40 7L40 6ZM9 9L9 10L10 10L10 11L9 11L9 12L12 12L12 13L11 13L11 14L12 14L12 15L14 15L14 18L13 18L13 19L12 19L12 21L11 21L11 22L12 22L12 21L13 21L13 19L15 19L15 18L17 18L17 17L18 17L18 19L16 19L16 20L14 20L14 21L15 21L15 23L16 23L16 24L14 24L14 23L13 23L13 24L12 24L12 25L13 25L13 26L14 26L14 27L15 27L15 28L14 28L14 29L12 29L12 30L10 30L10 31L9 31L9 33L10 33L10 31L14 31L14 32L13 32L13 33L12 33L12 32L11 32L11 33L12 33L12 34L13 34L13 33L14 33L14 32L15 32L15 31L17 31L17 32L18 32L18 28L19 28L19 30L20 30L20 28L19 28L19 27L22 27L22 28L23 28L23 30L22 30L22 29L21 29L21 30L22 30L22 31L20 31L20 33L21 33L21 32L22 32L22 35L26 35L26 36L25 36L25 37L27 37L27 35L28 35L28 37L29 37L29 39L30 39L30 38L31 38L31 40L27 40L27 42L29 42L29 41L30 41L30 44L29 44L29 43L28 43L28 44L29 44L29 45L30 45L30 46L31 46L31 45L32 45L32 47L33 47L33 46L34 46L34 48L33 48L33 50L34 50L34 48L35 48L35 47L36 47L36 49L35 49L35 51L36 51L36 49L37 49L37 48L38 48L38 45L37 45L37 47L36 47L36 45L35 45L35 46L34 46L34 45L32 45L32 43L31 43L31 41L33 41L33 43L35 43L35 44L37 44L37 42L38 42L38 44L39 44L39 47L40 47L40 45L41 45L41 48L42 48L42 49L43 49L43 48L45 48L45 45L44 45L44 44L43 44L43 43L42 43L42 45L41 45L41 43L40 43L40 44L39 44L39 42L38 42L38 41L37 41L37 42L36 42L36 40L35 40L35 39L38 39L38 40L39 40L39 41L40 41L40 42L42 42L42 41L43 41L43 42L45 42L45 40L46 40L46 38L45 38L45 37L46 37L46 36L48 36L48 35L49 35L49 34L48 34L48 33L50 33L50 36L49 36L49 37L50 37L50 38L51 38L51 37L50 37L50 36L51 36L51 35L52 35L52 37L54 37L54 38L52 38L52 39L54 39L54 38L55 38L55 37L54 37L54 35L55 35L55 32L54 32L54 29L55 29L55 27L53 27L53 25L52 25L52 23L51 23L51 25L50 25L50 23L49 23L49 25L50 25L50 26L48 26L48 23L47 23L47 22L46 22L46 21L44 21L44 22L43 22L43 18L44 18L44 17L46 17L46 19L45 19L45 20L47 20L47 21L48 21L48 22L49 22L49 20L47 20L47 17L46 17L46 16L45 16L45 15L44 15L44 14L42 14L42 15L41 15L41 13L40 13L40 10L39 10L39 13L38 13L38 12L37 12L37 9L36 9L36 13L35 13L35 15L39 15L39 16L38 16L38 17L37 17L37 19L36 19L36 18L35 18L35 17L36 17L36 16L35 16L35 17L33 17L33 18L31 18L31 19L35 19L35 20L37 20L37 22L36 22L36 21L35 21L35 22L32 22L32 20L30 20L30 19L28 19L28 20L27 20L27 19L25 19L25 18L24 18L24 19L22 19L22 18L21 18L21 19L20 19L20 16L19 16L19 17L18 17L18 16L17 16L17 14L18 14L18 12L17 12L17 11L16 11L16 10L15 10L15 9L14 9L14 11L15 11L15 13L13 13L13 12L12 12L12 10L13 10L13 9ZM28 9L28 10L30 10L30 9ZM6 10L6 11L7 11L7 12L6 12L6 13L8 13L8 14L5 14L5 15L8 15L8 17L9 17L9 15L8 15L8 14L10 14L10 13L8 13L8 11L7 11L7 10ZM23 12L23 13L24 13L24 12ZM26 12L26 14L25 14L25 16L24 16L24 17L25 17L25 16L26 16L26 15L27 15L27 12ZM12 13L12 14L13 14L13 13ZM15 13L15 14L14 14L14 15L15 15L15 16L16 16L16 14L17 14L17 13ZM36 13L36 14L38 14L38 13ZM39 13L39 15L40 15L40 13ZM0 14L0 15L1 15L1 14ZM19 14L19 15L20 15L20 14ZM28 15L28 16L29 16L29 15ZM42 15L42 16L39 16L39 17L38 17L38 18L41 18L41 17L42 17L42 18L43 18L43 17L42 17L42 16L43 16L43 15ZM52 15L52 16L53 16L53 15ZM56 16L56 18L57 18L57 16ZM6 19L6 20L5 20L5 21L6 21L6 22L7 22L7 21L8 21L8 23L9 23L9 19L8 19L8 20L7 20L7 19ZM18 19L18 20L17 20L17 21L16 21L16 23L18 23L18 22L19 22L19 23L20 23L20 24L19 24L19 25L18 25L18 26L17 26L17 25L16 25L16 26L15 26L15 25L14 25L14 26L15 26L15 27L16 27L16 28L15 28L15 30L16 30L16 28L17 28L17 27L19 27L19 25L20 25L20 24L22 24L22 25L23 25L23 26L24 26L24 27L25 27L25 29L24 29L24 32L25 32L25 34L26 34L26 35L27 35L27 34L30 34L30 35L29 35L29 36L30 36L30 35L31 35L31 38L33 38L33 36L32 36L32 34L31 34L31 33L33 33L33 34L36 34L36 35L37 35L37 34L38 34L38 36L37 36L37 37L39 37L39 38L38 38L38 39L40 39L40 41L42 41L42 38L44 38L44 39L45 39L45 38L44 38L44 37L45 37L45 36L46 36L46 34L47 34L47 33L48 33L48 31L46 31L46 32L45 32L45 31L44 31L44 32L43 32L43 29L44 29L44 30L45 30L45 29L44 29L44 27L46 27L46 29L47 29L47 30L48 30L48 27L47 27L47 24L46 24L46 23L45 23L45 22L44 22L44 23L45 23L45 24L44 24L44 25L43 25L43 24L42 24L42 25L41 25L41 23L40 23L40 24L39 24L39 23L38 23L38 24L37 24L37 26L35 26L35 25L36 25L36 23L35 23L35 25L34 25L34 23L33 23L33 24L32 24L32 22L31 22L31 23L30 23L30 20L29 20L29 21L28 21L28 22L27 22L27 21L25 21L25 23L22 23L22 19L21 19L21 21L20 21L20 19ZM24 19L24 20L25 20L25 19ZM37 19L37 20L38 20L38 19ZM39 19L39 20L40 20L40 19ZM41 19L41 20L42 20L42 19ZM6 20L6 21L7 21L7 20ZM33 20L33 21L34 21L34 20ZM50 20L50 21L51 21L51 20ZM17 21L17 22L18 22L18 21ZM19 21L19 22L20 22L20 21ZM23 21L23 22L24 22L24 21ZM38 21L38 22L40 22L40 21ZM26 22L26 23L25 23L25 25L26 25L26 29L25 29L25 32L26 32L26 33L27 33L27 32L26 32L26 31L30 31L30 33L31 33L31 30L32 30L32 31L33 31L33 30L34 30L34 32L33 32L33 33L35 33L35 32L37 32L37 33L38 33L38 32L40 32L40 33L39 33L39 34L42 34L42 35L41 35L41 36L45 36L45 34L46 34L46 33L47 33L47 32L46 32L46 33L44 33L44 35L43 35L43 32L42 32L42 33L41 33L41 31L40 31L40 30L41 30L41 29L43 29L43 27L42 27L42 28L41 28L41 26L40 26L40 25L39 25L39 24L38 24L38 27L37 27L37 29L36 29L36 28L35 28L35 29L34 29L34 28L33 28L33 27L31 27L31 26L34 26L34 25L32 25L32 24L31 24L31 26L28 26L28 24L26 24L26 23L27 23L27 22ZM53 22L53 23L54 23L54 22ZM4 23L4 24L7 24L7 25L6 25L6 26L7 26L7 25L8 25L8 24L7 24L7 23ZM2 24L2 26L5 26L5 25L3 25L3 24ZM9 24L9 25L10 25L10 24ZM44 25L44 26L45 26L45 25ZM39 26L39 27L40 27L40 26ZM1 27L1 28L2 28L2 29L3 29L3 28L2 28L2 27ZM5 27L5 30L8 30L8 27ZM27 27L27 30L30 30L30 27ZM49 27L49 30L52 30L52 27ZM6 28L6 29L7 29L7 28ZM28 28L28 29L29 29L29 28ZM31 28L31 29L32 29L32 28ZM38 28L38 29L37 29L37 30L39 30L39 29L41 29L41 28ZM50 28L50 29L51 29L51 28ZM53 28L53 29L54 29L54 28ZM35 29L35 31L36 31L36 29ZM22 31L22 32L23 32L23 31ZM37 31L37 32L38 32L38 31ZM50 31L50 33L51 33L51 31ZM52 31L52 34L54 34L54 32L53 32L53 31ZM23 33L23 34L24 34L24 33ZM3 34L3 35L2 35L2 36L3 36L3 37L4 37L4 36L3 36L3 35L4 35L4 34ZM9 34L9 37L10 37L10 38L9 38L9 40L11 40L11 39L10 39L10 38L11 38L11 37L10 37L10 35L11 35L11 34ZM14 34L14 35L15 35L15 36L12 36L12 37L13 37L13 38L14 38L14 39L12 39L12 42L13 42L13 41L14 41L14 39L15 39L15 38L17 38L17 39L16 39L16 40L15 40L15 42L16 42L16 43L17 43L17 45L18 45L18 46L17 46L17 47L18 47L18 48L16 48L16 49L17 49L17 50L19 50L19 48L20 48L20 47L21 47L21 46L20 46L20 47L18 47L18 46L19 46L19 44L20 44L20 45L21 45L21 44L20 44L20 43L18 43L18 42L20 42L20 41L18 41L18 42L17 42L17 41L16 41L16 40L17 40L17 39L18 39L18 40L19 40L19 39L18 39L18 38L19 38L19 36L18 36L18 38L17 38L17 37L16 37L16 36L17 36L17 35L18 35L18 34L17 34L17 35L16 35L16 34ZM19 34L19 35L20 35L20 38L21 38L21 37L22 37L22 38L24 38L24 36L23 36L23 37L22 37L22 36L21 36L21 34ZM34 36L34 39L33 39L33 40L34 40L34 39L35 39L35 38L36 38L36 37L35 37L35 36ZM39 36L39 37L40 37L40 39L41 39L41 37L40 37L40 36ZM26 38L26 39L28 39L28 38ZM20 39L20 40L22 40L22 39ZM24 39L24 40L23 40L23 42L24 42L24 41L25 41L25 44L26 44L26 41L25 41L25 39ZM8 41L8 42L9 42L9 43L10 43L10 41ZM21 41L21 43L22 43L22 41ZM11 43L11 44L8 44L8 45L10 45L10 46L13 46L13 44L14 44L14 46L16 46L16 45L15 45L15 44L14 44L14 43ZM11 44L11 45L12 45L12 44ZM30 44L30 45L31 45L31 44ZM43 45L43 47L42 47L42 48L43 48L43 47L44 47L44 45ZM49 45L49 48L50 48L50 46L51 46L51 45ZM13 47L13 48L14 48L14 49L15 49L15 47ZM51 47L51 48L52 48L52 47ZM39 48L39 49L38 49L38 51L39 51L39 50L40 50L40 48ZM27 49L27 52L30 52L30 49ZM49 49L49 52L52 52L52 49ZM21 50L21 51L22 51L22 50ZM28 50L28 51L29 51L29 50ZM50 50L50 51L51 51L51 50ZM25 51L25 52L26 52L26 51ZM55 51L55 53L54 53L54 54L55 54L55 53L56 53L56 51ZM10 52L10 53L11 53L11 52ZM18 52L18 53L19 53L19 52ZM31 52L31 53L32 53L32 52ZM33 52L33 54L34 54L34 52ZM8 53L8 57L9 57L9 55L13 55L13 54L9 54L9 53ZM21 53L21 55L22 55L22 53ZM50 53L50 54L51 54L51 53ZM47 54L47 55L48 55L48 54ZM14 55L14 56L13 56L13 57L14 57L14 56L15 56L15 55ZM27 55L27 57L31 57L31 56L30 56L30 55L29 55L29 56L28 56L28 55ZM56 55L56 56L57 56L57 55ZM0 0L0 7L7 7L7 0ZM1 1L1 6L6 6L6 1ZM2 2L2 5L5 5L5 2ZM50 0L50 7L57 7L57 0ZM51 1L51 6L56 6L56 1ZM52 2L52 5L55 5L55 2ZM0 50L0 57L7 57L7 50ZM1 51L1 56L6 56L6 51ZM2 52L2 55L5 55L5 52Z\\\" fill=\\\"#000000\\\"\\/><\\/g><\\/g><\\/svg>\\n\\n                            <span style=\\\"width:50%;\\\">\\n                                <img style=\\\"max-height: 70px\\\"\\n                                     src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/img\\/AfipComprobanteAutorizado.png\\\">\\n                            <\\/span>\\n                        <\\/th>\\n                        <th style=\\\"text-align:right;\\\">\\n                            <p>CAE N&#186;: 71304902487289<br>\\n                                Fecha Vto. CAE:  25\\/07\\/2021\\n                            <\\/p>\\n                        <\\/th>\\n                    <\\/tr>\\n                <\\/table>\\n                    <\\/div>\\n    <\\/div>\\n\\n    <\\/body>\\n<\\/html>\\\";s:4:\\\"file\\\";N;}s:6:\\\"locale\\\";N;s:4:\\\"from\\\";a:0:{}s:2:\\\"to\\\";a:1:{i:0;a:2:{s:4:\\\"name\\\";N;s:7:\\\"address\\\";s:24:\\\"marcos.airaldi@gmail.com\\\";}}s:2:\\\"cc\\\";a:0:{}s:3:\\\"bcc\\\";a:1:{i:0;a:2:{s:4:\\\"name\\\";N;s:7:\\\"address\\\";s:23:\\\"info@masquecontable.com\\\";}}s:7:\\\"replyTo\\\";a:0:{}s:7:\\\"subject\\\";N;s:11:\\\"\\u0000*\\u0000markdown\\\";N;s:7:\\\"\\u0000*\\u0000html\\\";N;s:4:\\\"view\\\";N;s:8:\\\"textView\\\";N;s:8:\\\"viewData\\\";a:0:{}s:11:\\\"attachments\\\";a:0:{}s:14:\\\"rawAttachments\\\";a:0:{}s:15:\\\"diskAttachments\\\";a:0:{}s:9:\\\"callbacks\\\";a:0:{}s:5:\\\"theme\\\";N;s:6:\\\"mailer\\\";s:8:\\\"sendgrid\\\";s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:5:\\\"delay\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;}\"}}','ErrorException: Trying to get property \'id\' of non-object in /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php:16\nStack trace:\n#0 /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php(16): Illuminate\\Foundation\\Bootstrap\\HandleExceptions->handleError(8, \'Trying to get p...\', \'/home/forge/tax...\', 16, Array)\n#1 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(356): App\\Queue\\DatabaseJob->fire()\n#2 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(306): Illuminate\\Queue\\Worker->process(\'database\', Object(App\\Queue\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#3 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(132): Illuminate\\Queue\\Worker->runJob(Object(App\\Queue\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#4 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(112): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#5 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(96): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#6 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#7 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#8 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#9 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#10 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#11 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(134): Illuminate\\Container\\Container->call(Array)\n#12 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(256): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#13 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(121): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#14 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(971): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#15 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(290): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#16 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(166): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#17 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Application.php(93): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(129): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#19 /home/forge/taxes.com.ar/artisan(35): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#20 {main}','2021-07-23 18:04:10',NULL);
INSERT INTO `failed_jobs` VALUES (16,NULL,'database','default','{\"uuid\":\"06607af7-f7ae-46e3-943b-84309866413b\",\"displayName\":\"App\\\\Mail\\\\Fact_Electronica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"delay\":null,\"timeout\":null,\"timeoutAt\":null,\"data\":{\"commandName\":\"Illuminate\\\\Mail\\\\SendQueuedMailable\",\"command\":\"O:34:\\\"Illuminate\\\\Mail\\\\SendQueuedMailable\\\":3:{s:8:\\\"mailable\\\";O:25:\\\"App\\\\Mail\\\\Fact_Electronica\\\":27:{s:11:\\\"informacion\\\";a:6:{s:12:\\\"ruta_logo_fa\\\";N;s:4:\\\"mail\\\";s:23:\\\"info@masquecontable.com\\\";s:18:\\\"name_quien_factura\\\";s:19:\\\"MICAELA AILIN CORIA\\\";s:7:\\\"cliente\\\";O:17:\\\"App\\\\Models\\\\Person\\\":27:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:7:\\\"persons\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:40741;s:7:\\\"user_id\\\";i:5115;s:11:\\\"field_name1\\\";s:21:\\\"MARTIN FELIX NORBERTO\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"20-37109286-3\\\";s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-07-05 19:04:49\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-07-05 19:04:49\\\";s:11:\\\"activity_id\\\";i:1;s:7:\\\"address\\\";s:91:\\\"Direccion\\r\\nLETTIERI 835\\r\\nCod. Postal\\r\\n1742\\r\\nProvincia\\r\\nBUENOS AIRES\\r\\nTipo Domicilio\\r\\nFISCAL\\\";s:14:\\\"person_type_id\\\";i:1;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:40741;s:7:\\\"user_id\\\";i:5115;s:11:\\\"field_name1\\\";s:21:\\\"MARTIN FELIX NORBERTO\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"20-37109286-3\\\";s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-07-05 19:04:49\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-07-05 19:04:49\\\";s:11:\\\"activity_id\\\";i:1;s:7:\\\"address\\\";s:91:\\\"Direccion\\r\\nLETTIERI 835\\r\\nCod. Postal\\r\\n1742\\r\\nProvincia\\r\\nBUENOS AIRES\\r\\nTipo Domicilio\\r\\nFISCAL\\\";s:14:\\\"person_type_id\\\";i:1;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}s:14:\\\"nombre_del_pdf\\\";s:28:\\\"Factura N\\u00b00004-00000019.pdf\\\";s:9:\\\"body_mail\\\";s:155:\\\"Estimado cliente, se env\\u00eda adjunta la factura de honorarios correspondientes al mes de Julio 2021.\\nMuchas gracias por seguir eligiendo nuestros servicios.\\\";}s:3:\\\"pdf\\\";O:26:\\\"Barryvdh\\\\Snappy\\\\PdfWrapper\\\":4:{s:9:\\\"\\u0000*\\u0000snappy\\\";O:35:\\\"Barryvdh\\\\Snappy\\\\IlluminateSnappyPdf\\\":10:{s:26:\\\"\\u0000*\\u0000optionsWithContentCheck\\\";a:4:{s:11:\\\"header-html\\\";s:4:\\\"html\\\";s:11:\\\"footer-html\\\";s:4:\\\"html\\\";s:5:\\\"cover\\\";s:4:\\\"html\\\";s:15:\\\"xsl-style-sheet\\\";s:3:\\\"xsl\\\";}s:36:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000binary\\\";s:76:\\\"\\/home\\/forge\\/taxes.com.ar\\/vendor\\/h4cc\\/wkhtmltopdf-amd64\\/bin\\/wkhtmltopdf-amd64\\\";s:37:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000options\\\";a:132:{s:7:\\\"collate\\\";N;s:10:\\\"no-collate\\\";N;s:10:\\\"cookie-jar\\\";N;s:6:\\\"copies\\\";i:1;s:3:\\\"dpi\\\";N;s:13:\\\"extended-help\\\";N;s:9:\\\"grayscale\\\";N;s:4:\\\"help\\\";N;s:7:\\\"htmldoc\\\";N;s:18:\\\"ignore-load-errors\\\";N;s:9:\\\"image-dpi\\\";N;s:13:\\\"image-quality\\\";N;s:7:\\\"license\\\";N;s:9:\\\"log-level\\\";N;s:10:\\\"lowquality\\\";b:1;s:7:\\\"manpage\\\";N;s:13:\\\"margin-bottom\\\";N;s:11:\\\"margin-left\\\";N;s:12:\\\"margin-right\\\";N;s:10:\\\"margin-top\\\";N;s:11:\\\"orientation\\\";N;s:11:\\\"page-height\\\";N;s:9:\\\"page-size\\\";s:2:\\\"a4\\\";s:10:\\\"page-width\\\";N;s:18:\\\"no-pdf-compression\\\";N;s:5:\\\"quiet\\\";N;s:20:\\\"read-args-from-stdin\\\";N;s:6:\\\"readme\\\";N;s:5:\\\"title\\\";N;s:11:\\\"use-xserver\\\";N;s:7:\\\"version\\\";N;s:20:\\\"dump-default-toc-xsl\\\";N;s:12:\\\"dump-outline\\\";N;s:7:\\\"outline\\\";N;s:10:\\\"no-outline\\\";N;s:13:\\\"outline-depth\\\";N;s:13:\\\"output-format\\\";N;s:5:\\\"allow\\\";N;s:10:\\\"background\\\";N;s:13:\\\"no-background\\\";N;s:16:\\\"bypass-proxy-for\\\";N;s:9:\\\"cache-dir\\\";N;s:20:\\\"checkbox-checked-svg\\\";N;s:12:\\\"checkbox-svg\\\";N;s:6:\\\"cookie\\\";N;s:13:\\\"custom-header\\\";N;s:25:\\\"custom-header-propagation\\\";N;s:28:\\\"no-custom-header-propagation\\\";N;s:16:\\\"debug-javascript\\\";N;s:19:\\\"no-debug-javascript\\\";N;s:14:\\\"default-header\\\";N;s:8:\\\"encoding\\\";N;s:22:\\\"disable-external-links\\\";N;s:21:\\\"enable-external-links\\\";N;s:13:\\\"disable-forms\\\";N;s:12:\\\"enable-forms\\\";N;s:6:\\\"images\\\";N;s:9:\\\"no-images\\\";N;s:22:\\\"disable-internal-links\\\";N;s:21:\\\"enable-internal-links\\\";N;s:18:\\\"disable-javascript\\\";N;s:17:\\\"enable-javascript\\\";N;s:16:\\\"javascript-delay\\\";N;s:19:\\\"keep-relative-links\\\";N;s:19:\\\"load-error-handling\\\";N;s:25:\\\"load-media-error-handling\\\";N;s:25:\\\"disable-local-file-access\\\";N;s:24:\\\"enable-local-file-access\\\";N;s:17:\\\"minimum-font-size\\\";N;s:20:\\\"exclude-from-outline\\\";N;s:18:\\\"include-in-outline\\\";N;s:11:\\\"page-offset\\\";N;s:8:\\\"password\\\";N;s:15:\\\"disable-plugins\\\";N;s:14:\\\"enable-plugins\\\";N;s:4:\\\"post\\\";N;s:9:\\\"post-file\\\";N;s:16:\\\"print-media-type\\\";N;s:19:\\\"no-print-media-type\\\";N;s:5:\\\"proxy\\\";N;s:21:\\\"proxy-hostname-lookup\\\";N;s:23:\\\"radiobutton-checked-svg\\\";N;s:15:\\\"radiobutton-svg\\\";N;s:14:\\\"redirect-delay\\\";N;s:22:\\\"resolve-relative-links\\\";N;s:10:\\\"run-script\\\";N;s:23:\\\"disable-smart-shrinking\\\";N;s:22:\\\"enable-smart-shrinking\\\";N;s:12:\\\"ssl-crt-path\\\";N;s:16:\\\"ssl-key-password\\\";N;s:12:\\\"ssl-key-path\\\";N;s:17:\\\"stop-slow-scripts\\\";N;s:20:\\\"no-stop-slow-scripts\\\";N;s:22:\\\"disable-toc-back-links\\\";N;s:21:\\\"enable-toc-back-links\\\";N;s:16:\\\"user-style-sheet\\\";N;s:8:\\\"username\\\";N;s:13:\\\"viewport-size\\\";N;s:13:\\\"window-status\\\";N;s:4:\\\"zoom\\\";N;s:13:\\\"footer-center\\\";s:25:\\\"Pagina [page] de [toPage]\\\";s:16:\\\"footer-font-name\\\";N;s:16:\\\"footer-font-size\\\";i:8;s:11:\\\"footer-html\\\";N;s:11:\\\"footer-left\\\";s:0:\\\"\\\";s:11:\\\"footer-line\\\";N;s:14:\\\"no-footer-line\\\";N;s:12:\\\"footer-right\\\";N;s:14:\\\"footer-spacing\\\";N;s:13:\\\"header-center\\\";N;s:16:\\\"header-font-name\\\";N;s:16:\\\"header-font-size\\\";N;s:11:\\\"header-html\\\";N;s:11:\\\"header-left\\\";N;s:11:\\\"header-line\\\";N;s:14:\\\"no-header-line\\\";N;s:12:\\\"header-right\\\";N;s:14:\\\"header-spacing\\\";N;s:7:\\\"replace\\\";N;s:5:\\\"cover\\\";N;s:3:\\\"toc\\\";N;s:20:\\\"disable-dotted-lines\\\";N;s:9:\\\"toc-depth\\\";N;s:13:\\\"toc-font-name\\\";N;s:16:\\\"toc-l1-font-size\\\";N;s:15:\\\"toc-header-text\\\";N;s:20:\\\"toc-header-font-name\\\";N;s:20:\\\"toc-header-font-size\\\";N;s:21:\\\"toc-level-indentation\\\";N;s:17:\\\"disable-toc-links\\\";N;s:20:\\\"toc-text-size-shrink\\\";N;s:15:\\\"xsl-style-sheet\\\";N;}s:33:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000env\\\";N;s:37:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000timeout\\\";b:0;s:46:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000defaultExtension\\\";s:3:\\\"pdf\\\";s:18:\\\"\\u0000*\\u0000temporaryFolder\\\";N;s:14:\\\"temporaryFiles\\\";a:0:{}s:36:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000logger\\\";O:18:\\\"Psr\\\\Log\\\\NullLogger\\\":0:{}s:2:\\\"fs\\\";O:32:\\\"Illuminate\\\\Filesystem\\\\Filesystem\\\":0:{}}s:10:\\\"\\u0000*\\u0000options\\\";a:0:{}s:4:\\\"html\\\";s:22284:\\\"<!DOCTYPE html>\\n<html lang=\\\"en\\\">\\n    <head>\\n        <meta charset=\\\"utf-8\\\">\\n    <\\/head>\\n    <style>\\n        .subtotales_conceptos{\\n            width:30%;\\n            text-align: right;\\n        }\\n        .subtotales_importes{\\n            text-align: right;\\n        }\\n        .table-totales, .table-totales tr, .table-totales th{\\n            border: 1px solid;\\n        }\\n\\n    <\\/style>\\n    <body>\\n    <div style=\\\"max-height:840px\\\">\\n        <div style=\\\"width: 100%; height:270px\\\"> <!-- Datos de la empresa -->\\n            <table class=\\\"display\\\" cellspacing=\\\"0\\\" width=\\\"100%\\\" style=\\\"border:  1px solid;\\\">\\n                <tr style=\\\"\\\">\\n                    <th colspan=\\\"2\\\" rowspan=\\\"2\\\" style=\\\"width:45%;margin:0;height:150px;\\\">\\n                                                <img src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/img\\/\\/27377183504\\/logo_punto_venta_0000.png\\\"\\/>\\n                                            <\\/th>\\n                    <th style=\\\"border:  1px solid;text-align: center; width:10%\\\" colspan=\\\"2\\\">\\n                        <span style=\\\"font-size: 60px;\\\">C<\\/span> <br \\/> <span style=\\\"font-size: 14px;\\\">cod. 11<\\/span>\\n                    <\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"font-size: 28px;text-align: center;width:45%\\\">\\n                        Factura\\n                        <br>\\n                        0004 - 00000019\\n                    <\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th><\\/th>\\n                    <th style=\\\"border:  1px 1px 1px 0px solid;\\\" colspan=\\\"2\\\"><\\/th>\\n                    <th><\\/th>\\n                <\\/tr>\\n                <tr>\\n\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                                                    Raz&oacute;n Social:\\n                            <span style=\\\"font-weight: normal;\\\">MICAELA AILIN CORIA<\\/span>\\n                                            <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">Fecha de Emisi&oacute;n: <span style=\\\"font-weight: normal;\\\">15\\/07\\/2021<\\/span><\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Domicilio Comercial: <span style=\\\"font-weight: normal;\\\">Victor Guillet esq. Arturo M Bas, C.P.:5800,\\n                        C\\u00f3rdoba<\\/span>\\n                    <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">CUIT: <span style=\\\"font-weight: normal;\\\">27-37718350-4<\\/span><\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Condici&oacute;n frente al IVA: <span style=\\\"font-weight: normal;\\\">Monotributo<\\/span>\\n                    <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Ingresos Brutos: <span style=\\\"font-weight: normal;\\\"><\\/span>\\n                        <br>\\n                        Fecha de Inicio de Actividades: <span style=\\\"font-weight: normal;\\\">09\\/07\\/2021<\\/span>\\n                    <\\/th>\\n                <\\/tr>\\n            <\\/table>\\n        <\\/div>\\n\\n        <table style=\\\"text-align: center; width: 100%;border: solid 1px;\\\"> <!-- Fechas -->\\n            <thead>\\n                <tr>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Per\\u00edodo Facturado Desde: 01\\/07\\/2021<\\/small><\\/th>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Per\\u00edodo Facturado Hasta: 31\\/07\\/2021<\\/small><\\/th>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Fecha Vto. Pago: 15\\/07\\/2021<\\/small><\\/th>\\n                <\\/tr>\\n            <\\/thead>\\n        <\\/table>\\n        \\n        <table style=\\\"width: 100%; margin-top: 1%;border: solid 1px;\\\"> <!-- Datos Clientes -->\\n            <tr>\\n                <th style=\\\"text-align:left;\\\"colspan=\\\"12\\\">\\n                    CUIT: <span style=\\\"font-weight: normal;\\\">20-37109286-3<\\/span>\\n                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\\n                    Apellido y Nombre \\/ Raz&oacute;n Social: <span style=\\\"font-weight: normal;\\\">\\n                    MARTIN FELIX NORBERTO<\\/span>\\n                <\\/th>\\n            <\\/tr>\\n            <tr>\\n                <th style=\\\"text-align:left; width:50%\\\">\\n                    Condici&oacute;n Frente al IVA: <span style=\\\"font-weight: normal;\\\">Responsable Monotributo<\\/span>\\n                <\\/th>\\n                <th style=\\\"text-align:left; width:50%\\\" colspan=\\\"4\\\">\\n                    Domicilio Comercial:\\n                    <span style=\\\"font-weight: normal;\\\">\\n                    Direccion\\r\\nLETTIERI 835\\r\\nCod. Postal\\r\\n1742\\r\\nProvincia\\r\\nBUENOS AIRES\\r\\nTipo Domicilio\\r\\nFISCAL\\n                    <\\/span>\\n                <\\/th>\\n            <\\/tr>\\n            <tr style=\\\"text-align:left\\\">\\n                <th>Condici&oacute;n de Venta: <span style=\\\"font-weight: normal;\\\">Cuenta Corriente<\\/span><\\/th>\\n            <\\/tr>\\n        <\\/table>\\n\\n        <div style=\\\"border: 1px solid;margin-top: 1%;min-height:600px;\\\">\\n        <table style=\\\"text-align: center; width: 100%; margin-top: 1%;\\\"> <!-- Body -->\\n            <tr style=\\\"border-bottom: 1px solid;font-size: 15px\\\">\\n                <th>C&oacute;digo<\\/th>\\n                <th style=\\\"width: 25%;\\\">Detalle<\\/th>\\n                <th>Cantidad<\\/th>\\n                <th>U.Medida<\\/th>\\n                <th>Precio U.<\\/th>\\n                <th>Bonif. (%)<\\/th>\\n                <th>Precio Bonif.<\\/th>\\n                <th>Subtotal<\\/th>\\n                            <\\/tr>\\n            <tbody>\\n                                                                                <tr style=\\\"font-size: 12px;\\\">\\n                        <td>\\n                            \\n                        <\\/td>\\n                        <td>\\n                            Honorarios profesionales Julio 2021\\n                        <\\/td>\\n                        <td>\\n                            1.00\\n                        <\\/td>\\n                        <td>\\n                            Unidades\\n                        <\\/td>\\n                        <td>                            2.950,00\\n                                                    <\\/td>\\n                        <td>\\n                            0,00%\\n                        <\\/td>\\n                        <td>\\n                            0,00\\n                        <\\/td>\\n                        <td>\\n                            2.950,00\\n                        <\\/td>\\n                                            <\\/tr>\\n                    \\n            <\\/tbody>\\n        <\\/table>\\n        <\\/div>\\n\\n        \\n\\n        <div style=\\\"height:200px;margin-top: 1%;\\\"> <!-- Totales -->\\n              <!-- Es factura B o C -->\\n                <table class=\\\"table-totales\\\" cellspacing=\\\"0\\\" width=\\\"100%\\\">\\n                    <tr>\\n                        <th style=\\\"width:50%; text-align:left;\\\">\\n\\n<!--                                <span style=\\\"width:100%;\\\"><img src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/barcodes\\/71304902488777.png\\\"><\\/span>\\n                                <span style=\\\"text-align:center;\\\">2737718350411000471304902488777202107255<\\/span>-->\\n                        <\\/th>\\n                        <th class=\\\"subtotales_conceptos\\\">TOTAL:<\\/th>\\n                        <th class=\\\"subtotales_importes\\\">$ 2.950,00<\\/th>\\n                    <\\/tr>\\n                <\\/table>\\n                <br>\\n                <table cellspacing=\\\"0\\\" width=\\\"100%\\\" style=\\\"border: none\\\">\\n                    <tr>\\n                        <th style=\\\"width:50%; text-align:left;\\\">\\n\\n                            <?xml version=\\\"1.0\\\" encoding=\\\"UTF-8\\\"?>\\n<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" version=\\\"1.1\\\" width=\\\"100\\\" height=\\\"100\\\" viewBox=\\\"0 0 100 100\\\"><rect x=\\\"0\\\" y=\\\"0\\\" width=\\\"100\\\" height=\\\"100\\\" fill=\\\"#ffffff\\\"\\/><g transform=\\\"scale(1.754)\\\"><g transform=\\\"translate(0,0)\\\"><path fill-rule=\\\"evenodd\\\" d=\\\"M8 0L8 1L9 1L9 2L8 2L8 5L10 5L10 4L9 4L9 3L11 3L11 6L10 6L10 7L9 7L9 6L8 6L8 7L9 7L9 8L8 8L8 9L9 9L9 11L10 11L10 12L12 12L12 10L13 10L13 9L14 9L14 11L15 11L15 13L13 13L13 14L12 14L12 13L8 13L8 10L5 10L5 9L4 9L4 8L0 8L0 9L4 9L4 10L5 10L5 11L3 11L3 12L4 12L4 13L5 13L5 12L6 12L6 13L8 13L8 14L5 14L5 15L4 15L4 14L3 14L3 13L2 13L2 10L0 10L0 11L1 11L1 14L0 14L0 15L1 15L1 14L3 14L3 16L2 16L2 17L4 17L4 16L5 16L5 15L7 15L7 16L6 16L6 17L7 17L7 18L6 18L6 19L5 19L5 18L3 18L3 19L2 19L2 18L0 18L0 19L2 19L2 20L1 20L1 21L0 21L0 22L2 22L2 23L1 23L1 24L0 24L0 25L1 25L1 26L0 26L0 27L1 27L1 28L0 28L0 30L1 30L1 29L3 29L3 30L4 30L4 31L5 31L5 32L6 32L6 33L3 33L3 32L2 32L2 31L0 31L0 32L2 32L2 33L0 33L0 36L1 36L1 37L0 37L0 40L1 40L1 41L0 41L0 43L1 43L1 42L5 42L5 43L7 43L7 44L4 44L4 43L2 43L2 44L4 44L4 45L3 45L3 46L2 46L2 47L1 47L1 44L0 44L0 48L5 48L5 47L7 47L7 48L6 48L6 49L8 49L8 50L9 50L9 53L8 53L8 57L9 57L9 55L11 55L11 56L12 56L12 54L15 54L15 53L16 53L16 54L17 54L17 55L18 55L18 56L17 56L17 57L18 57L18 56L19 56L19 57L21 57L21 55L22 55L22 53L21 53L21 54L20 54L20 51L21 51L21 52L23 52L23 50L24 50L24 53L25 53L25 54L23 54L23 56L22 56L22 57L24 57L24 56L26 56L26 55L25 55L25 54L27 54L27 53L31 53L31 54L33 54L33 55L32 55L32 56L34 56L34 57L36 57L36 55L38 55L38 56L37 56L37 57L44 57L44 56L43 56L43 55L42 55L42 56L41 56L41 55L40 55L40 54L42 54L42 53L40 53L40 52L43 52L43 53L45 53L45 52L46 52L46 51L45 51L45 49L47 49L47 48L48 48L48 50L47 50L47 53L46 53L46 54L44 54L44 55L45 55L45 56L46 56L46 57L47 57L47 56L49 56L49 54L50 54L50 57L51 57L51 54L52 54L52 53L55 53L55 54L56 54L56 53L57 53L57 51L56 51L56 49L57 49L57 48L56 48L56 49L55 49L55 51L53 51L53 49L54 49L54 48L53 48L53 46L54 46L54 45L56 45L56 46L55 46L55 47L57 47L57 44L53 44L53 46L52 46L52 43L51 43L51 44L50 44L50 42L51 42L51 41L50 41L50 40L51 40L51 39L52 39L52 38L51 38L51 35L52 35L52 37L54 37L54 38L53 38L53 39L54 39L54 41L53 41L53 40L52 40L52 42L54 42L54 43L55 43L55 42L57 42L57 40L56 40L56 38L57 38L57 31L56 31L56 30L57 30L57 27L56 27L56 24L57 24L57 21L56 21L56 20L53 20L53 19L54 19L54 18L55 18L55 14L54 14L54 10L53 10L53 9L55 9L55 10L56 10L56 11L55 11L55 12L57 12L57 8L56 8L56 9L55 9L55 8L52 8L52 10L51 10L51 11L50 11L50 10L49 10L49 9L50 9L50 8L48 8L48 7L49 7L49 6L48 6L48 7L47 7L47 5L48 5L48 0L45 0L45 1L43 1L43 0L39 0L39 1L41 1L41 4L40 4L40 5L39 5L39 2L38 2L38 1L37 1L37 2L36 2L36 1L32 1L32 2L31 2L31 0L30 0L30 1L29 1L29 0L28 0L28 1L26 1L26 0L24 0L24 1L23 1L23 0L22 0L22 1L23 1L23 2L22 2L22 3L21 3L21 4L20 4L20 5L21 5L21 4L22 4L22 12L21 12L21 11L20 11L20 12L19 12L19 10L20 10L20 9L21 9L21 8L20 8L20 7L21 7L21 6L20 6L20 7L19 7L19 6L18 6L18 7L17 7L17 6L16 6L16 7L15 7L15 6L14 6L14 5L13 5L13 4L14 4L14 3L15 3L15 5L17 5L17 4L16 4L16 3L17 3L17 2L18 2L18 1L17 1L17 2L15 2L15 1L16 1L16 0L14 0L14 2L13 2L13 0L11 0L11 2L10 2L10 0ZM19 1L19 2L21 2L21 1ZM25 1L25 2L23 2L23 3L22 3L22 4L23 4L23 3L24 3L24 5L23 5L23 12L22 12L22 13L23 13L23 14L24 14L24 16L23 16L23 15L22 15L22 14L20 14L20 13L19 13L19 12L18 12L18 10L19 10L19 9L20 9L20 8L18 8L18 9L17 9L17 8L15 8L15 7L14 7L14 6L13 6L13 5L12 5L12 6L11 6L11 7L10 7L10 8L9 8L9 9L13 9L13 8L11 8L11 7L12 7L12 6L13 6L13 7L14 7L14 9L15 9L15 10L16 10L16 11L17 11L17 12L18 12L18 14L17 14L17 13L15 13L15 14L14 14L14 15L11 15L11 19L10 19L10 18L7 18L7 19L6 19L6 20L5 20L5 21L6 21L6 22L7 22L7 21L8 21L8 23L5 23L5 24L4 24L4 25L3 25L3 24L2 24L2 26L1 26L1 27L2 27L2 26L4 26L4 25L5 25L5 26L7 26L7 25L10 25L10 24L8 24L8 23L9 23L9 22L10 22L10 23L11 23L11 25L12 25L12 27L13 27L13 28L12 28L12 29L11 29L11 28L9 28L9 31L10 31L10 33L9 33L9 32L8 32L8 31L6 31L6 32L8 32L8 33L9 33L9 34L7 34L7 33L6 33L6 34L7 34L7 35L6 35L6 36L5 36L5 37L6 37L6 38L7 38L7 37L8 37L8 38L9 38L9 37L10 37L10 39L11 39L11 37L12 37L12 36L13 36L13 38L12 38L12 40L8 40L8 39L5 39L5 40L7 40L7 41L6 41L6 42L7 42L7 43L8 43L8 44L9 44L9 43L10 43L10 47L9 47L9 46L8 46L8 47L9 47L9 48L10 48L10 49L9 49L9 50L11 50L11 48L12 48L12 47L15 47L15 49L14 49L14 48L13 48L13 49L14 49L14 50L12 50L12 51L11 51L11 52L10 52L10 53L9 53L9 54L10 54L10 53L11 53L11 54L12 54L12 51L15 51L15 49L16 49L16 53L17 53L17 51L20 51L20 48L22 48L22 49L23 49L23 48L22 48L22 47L24 47L24 46L22 46L22 44L21 44L21 43L24 43L24 44L23 44L23 45L25 45L25 46L27 46L27 44L28 44L28 47L26 47L26 48L24 48L24 50L25 50L25 49L26 49L26 48L28 48L28 47L29 47L29 48L30 48L30 47L32 47L32 50L31 50L31 51L32 51L32 50L33 50L33 51L35 51L35 52L36 52L36 53L35 53L35 55L34 55L34 56L35 56L35 55L36 55L36 53L37 53L37 54L38 54L38 55L39 55L39 56L40 56L40 55L39 55L39 53L37 53L37 51L38 51L38 52L40 52L40 50L41 50L41 51L42 51L42 50L43 50L43 51L44 51L44 49L45 49L45 48L46 48L46 46L47 46L47 45L48 45L48 44L49 44L49 42L50 42L50 41L47 41L47 42L48 42L48 43L46 43L46 44L45 44L45 42L46 42L46 40L47 40L47 37L48 37L48 38L49 38L49 37L50 37L50 33L51 33L51 31L50 31L50 33L48 33L48 31L46 31L46 32L45 32L45 31L44 31L44 32L43 32L43 29L44 29L44 30L45 30L45 29L44 29L44 27L46 27L46 29L47 29L47 30L48 30L48 27L47 27L47 25L46 25L46 23L45 23L45 22L44 22L44 21L46 21L46 22L47 22L47 23L48 23L48 26L50 26L50 25L51 25L51 23L52 23L52 25L53 25L53 27L55 27L55 29L54 29L54 28L53 28L53 29L54 29L54 32L53 32L53 31L52 31L52 34L54 34L54 32L55 32L55 35L54 35L54 37L55 37L55 38L54 38L54 39L55 39L55 38L56 38L56 36L55 36L55 35L56 35L56 32L55 32L55 30L56 30L56 27L55 27L55 22L56 22L56 21L55 21L55 22L54 22L54 21L53 21L53 22L51 22L51 21L52 21L52 20L51 20L51 19L50 19L50 20L49 20L49 17L50 17L50 18L51 18L51 17L54 17L54 14L52 14L52 13L53 13L53 10L52 10L52 11L51 11L51 12L52 12L52 13L51 13L51 15L49 15L49 17L47 17L47 16L46 16L46 15L47 15L47 13L48 13L48 14L50 14L50 12L49 12L49 10L48 10L48 8L47 8L47 9L46 9L46 10L48 10L48 11L46 11L46 12L47 12L47 13L46 13L46 14L45 14L45 12L44 12L44 13L43 13L43 12L42 12L42 13L41 13L41 9L44 9L44 10L43 10L43 11L45 11L45 7L46 7L46 5L47 5L47 3L46 3L46 2L47 2L47 1L45 1L45 3L44 3L44 5L43 5L43 4L41 4L41 7L42 7L42 8L41 8L41 9L39 9L39 8L38 8L38 9L37 9L37 8L35 8L35 7L36 7L36 6L37 6L37 7L38 7L38 6L37 6L37 5L38 5L38 3L37 3L37 5L35 5L35 4L34 4L34 5L33 5L33 7L32 7L32 4L33 4L33 3L34 3L34 2L33 2L33 3L31 3L31 8L32 8L32 9L31 9L31 10L33 10L33 11L34 11L34 10L35 10L35 13L34 13L34 14L32 14L32 15L33 15L33 17L30 17L30 18L28 18L28 19L27 19L27 17L29 17L29 16L30 16L30 15L29 15L29 13L30 13L30 14L31 14L31 13L33 13L33 12L31 12L31 11L26 11L26 12L25 12L25 11L24 11L24 8L25 8L25 10L27 10L27 9L26 9L26 8L25 8L25 7L26 7L26 6L25 6L25 5L26 5L26 4L25 4L25 2L26 2L26 3L28 3L28 4L30 4L30 3L29 3L29 2L26 2L26 1ZM11 2L11 3L12 3L12 2ZM18 3L18 5L19 5L19 3ZM45 3L45 5L46 5L46 3ZM27 5L27 8L30 8L30 5ZM42 5L42 7L43 7L43 8L44 8L44 7L45 7L45 6L44 6L44 7L43 7L43 5ZM24 6L24 7L25 7L25 6ZM28 6L28 7L29 7L29 6ZM34 6L34 7L35 7L35 6ZM39 6L39 7L40 7L40 6ZM6 8L6 9L7 9L7 8ZM28 9L28 10L30 10L30 9ZM36 9L36 13L35 13L35 15L39 15L39 16L38 16L38 17L37 17L37 19L36 19L36 18L35 18L35 17L36 17L36 16L35 16L35 17L33 17L33 18L31 18L31 19L35 19L35 20L37 20L37 22L36 22L36 21L35 21L35 22L32 22L32 20L30 20L30 19L28 19L28 20L27 20L27 19L25 19L25 18L24 18L24 19L22 19L22 18L21 18L21 19L20 19L20 16L19 16L19 17L18 17L18 16L17 16L17 14L16 14L16 16L15 16L15 15L14 15L14 18L13 18L13 19L12 19L12 21L11 21L11 20L9 20L9 21L11 21L11 23L12 23L12 25L13 25L13 27L14 27L14 28L16 28L16 30L15 30L15 29L14 29L14 30L12 30L12 31L14 31L14 32L13 32L13 33L12 33L12 32L11 32L11 33L12 33L12 34L13 34L13 36L14 36L14 37L15 37L15 38L14 38L14 39L13 39L13 40L12 40L12 42L13 42L13 43L11 43L11 42L10 42L10 41L8 41L8 42L10 42L10 43L11 43L11 47L10 47L10 48L11 48L11 47L12 47L12 46L13 46L13 45L12 45L12 44L13 44L13 43L15 43L15 42L16 42L16 43L17 43L17 45L18 45L18 46L17 46L17 47L18 47L18 48L16 48L16 49L17 49L17 50L19 50L19 48L20 48L20 47L21 47L21 46L20 46L20 47L18 47L18 46L19 46L19 44L20 44L20 45L21 45L21 44L20 44L20 43L18 43L18 42L20 42L20 41L18 41L18 42L17 42L17 41L16 41L16 40L17 40L17 39L18 39L18 40L20 40L20 39L21 39L21 40L22 40L22 39L21 39L21 37L22 37L22 38L24 38L24 36L23 36L23 37L22 37L22 36L21 36L21 34L19 34L19 35L20 35L20 39L18 39L18 38L19 38L19 36L18 36L18 38L17 38L17 37L16 37L16 36L17 36L17 35L18 35L18 34L17 34L17 35L16 35L16 34L13 34L13 33L14 33L14 32L15 32L15 31L17 31L17 32L18 32L18 28L19 28L19 30L20 30L20 28L19 28L19 27L21 27L21 28L22 28L22 27L21 27L21 26L23 26L23 30L22 30L22 29L21 29L21 30L22 30L22 31L20 31L20 33L21 33L21 32L22 32L22 35L26 35L26 36L25 36L25 37L27 37L27 35L28 35L28 37L29 37L29 39L30 39L30 38L31 38L31 40L27 40L27 42L29 42L29 41L30 41L30 44L29 44L29 43L28 43L28 44L29 44L29 45L30 45L30 46L31 46L31 45L32 45L32 47L33 47L33 46L34 46L34 48L33 48L33 50L34 50L34 48L35 48L35 47L36 47L36 49L35 49L35 51L36 51L36 49L37 49L37 48L38 48L38 45L37 45L37 47L36 47L36 45L35 45L35 46L34 46L34 45L32 45L32 43L31 43L31 41L33 41L33 43L35 43L35 44L37 44L37 42L38 42L38 44L39 44L39 47L40 47L40 45L41 45L41 48L42 48L42 49L43 49L43 48L45 48L45 45L44 45L44 44L43 44L43 43L42 43L42 45L41 45L41 43L40 43L40 44L39 44L39 42L38 42L38 41L37 41L37 42L36 42L36 40L35 40L35 39L38 39L38 40L39 40L39 41L40 41L40 42L42 42L42 41L43 41L43 42L45 42L45 40L46 40L46 38L45 38L45 37L46 37L46 36L48 36L48 37L49 37L49 36L48 36L48 35L49 35L49 34L48 34L48 33L47 33L47 32L46 32L46 33L44 33L44 35L43 35L43 32L42 32L42 33L41 33L41 31L40 31L40 30L41 30L41 29L43 29L43 27L42 27L42 28L41 28L41 26L40 26L40 25L39 25L39 24L40 24L40 23L41 23L41 25L42 25L42 24L43 24L43 25L44 25L44 26L45 26L45 25L44 25L44 24L45 24L45 23L44 23L44 22L43 22L43 18L44 18L44 17L46 17L46 19L45 19L45 20L47 20L47 21L48 21L48 22L49 22L49 20L47 20L47 17L46 17L46 16L45 16L45 15L44 15L44 14L42 14L42 15L41 15L41 13L40 13L40 10L39 10L39 13L38 13L38 12L37 12L37 9ZM10 10L10 11L11 11L11 10ZM6 11L6 12L7 12L7 11ZM23 12L23 13L24 13L24 12ZM26 12L26 14L25 14L25 16L24 16L24 17L25 17L25 16L26 16L26 15L27 15L27 12ZM36 13L36 14L38 14L38 13ZM39 13L39 15L40 15L40 13ZM8 14L8 16L9 16L9 17L10 17L10 14ZM19 14L19 15L20 15L20 14ZM28 15L28 16L29 16L29 15ZM42 15L42 16L39 16L39 17L38 17L38 18L41 18L41 17L42 17L42 18L43 18L43 17L42 17L42 16L43 16L43 15ZM52 15L52 16L53 16L53 15ZM50 16L50 17L51 17L51 16ZM56 16L56 18L57 18L57 16ZM17 17L17 18L15 18L15 19L13 19L13 21L12 21L12 23L14 23L14 24L16 24L16 23L18 23L18 22L19 22L19 23L20 23L20 24L19 24L19 25L18 25L18 26L17 26L17 25L16 25L16 26L15 26L15 25L14 25L14 27L16 27L16 28L17 28L17 27L19 27L19 25L20 25L20 24L22 24L22 25L23 25L23 26L24 26L24 27L25 27L25 29L24 29L24 32L25 32L25 34L26 34L26 35L27 35L27 34L30 34L30 35L29 35L29 36L30 36L30 35L31 35L31 38L33 38L33 36L32 36L32 34L31 34L31 33L33 33L33 34L36 34L36 35L37 35L37 34L38 34L38 36L37 36L37 37L39 37L39 38L38 38L38 39L40 39L40 41L42 41L42 38L44 38L44 39L45 39L45 38L44 38L44 37L45 37L45 36L46 36L46 34L47 34L47 33L46 33L46 34L45 34L45 36L41 36L41 35L42 35L42 34L39 34L39 33L40 33L40 32L38 32L38 31L37 31L37 32L35 32L35 33L33 33L33 32L34 32L34 30L33 30L33 31L32 31L32 30L31 30L31 33L30 33L30 31L26 31L26 32L25 32L25 29L26 29L26 25L25 25L25 23L26 23L26 24L28 24L28 26L31 26L31 27L33 27L33 28L34 28L34 29L35 29L35 31L36 31L36 29L37 29L37 30L39 30L39 29L41 29L41 28L38 28L38 29L37 29L37 27L38 27L38 24L39 24L39 23L38 23L38 24L37 24L37 26L35 26L35 25L36 25L36 23L35 23L35 25L34 25L34 23L33 23L33 24L32 24L32 22L31 22L31 23L30 23L30 20L29 20L29 21L28 21L28 22L27 22L27 21L25 21L25 23L22 23L22 19L21 19L21 21L20 21L20 19L18 19L18 17ZM52 18L52 19L53 19L53 18ZM7 19L7 20L6 20L6 21L7 21L7 20L8 20L8 19ZM16 19L16 20L14 20L14 21L15 21L15 23L16 23L16 21L17 21L17 22L18 22L18 21L17 21L17 20L18 20L18 19ZM24 19L24 20L25 20L25 19ZM37 19L37 20L38 20L38 19ZM39 19L39 20L40 20L40 19ZM41 19L41 20L42 20L42 19ZM2 20L2 22L3 22L3 23L4 23L4 22L3 22L3 20ZM33 20L33 21L34 21L34 20ZM50 20L50 21L51 21L51 20ZM19 21L19 22L20 22L20 21ZM23 21L23 22L24 22L24 21ZM38 21L38 22L40 22L40 21ZM26 22L26 23L27 23L27 22ZM53 22L53 23L54 23L54 22ZM49 23L49 25L50 25L50 23ZM5 24L5 25L7 25L7 24ZM31 24L31 26L34 26L34 25L32 25L32 24ZM39 26L39 27L40 27L40 26ZM5 27L5 30L8 30L8 27ZM27 27L27 30L30 30L30 27ZM49 27L49 30L52 30L52 27ZM3 28L3 29L4 29L4 28ZM6 28L6 29L7 29L7 28ZM28 28L28 29L29 29L29 28ZM31 28L31 29L32 29L32 28ZM35 28L35 29L36 29L36 28ZM50 28L50 29L51 29L51 28ZM10 30L10 31L11 31L11 30ZM22 31L22 32L23 32L23 31ZM26 32L26 33L27 33L27 32ZM37 32L37 33L38 33L38 32ZM23 33L23 34L24 34L24 33ZM1 34L1 36L2 36L2 37L3 37L3 38L2 38L2 39L3 39L3 41L4 41L4 39L3 39L3 38L4 38L4 36L3 36L3 35L4 35L4 34L3 34L3 35L2 35L2 34ZM9 34L9 36L10 36L10 34ZM14 35L14 36L15 36L15 35ZM6 36L6 37L7 37L7 36ZM34 36L34 39L33 39L33 40L34 40L34 39L35 39L35 38L36 38L36 37L35 37L35 36ZM39 36L39 37L40 37L40 39L41 39L41 37L40 37L40 36ZM15 38L15 39L14 39L14 41L13 41L13 42L15 42L15 40L16 40L16 39L17 39L17 38ZM26 38L26 39L28 39L28 38ZM50 38L50 39L51 39L51 38ZM24 39L24 40L23 40L23 42L24 42L24 41L25 41L25 44L26 44L26 41L25 41L25 39ZM55 40L55 41L54 41L54 42L55 42L55 41L56 41L56 40ZM21 41L21 42L22 42L22 41ZM30 44L30 45L31 45L31 44ZM6 45L6 46L7 46L7 45ZM14 45L14 46L15 46L15 47L16 47L16 45ZM43 45L43 47L42 47L42 48L43 48L43 47L44 47L44 45ZM49 45L49 48L50 48L50 46L51 46L51 45ZM3 46L3 47L5 47L5 46ZM51 47L51 48L52 48L52 47ZM39 48L39 49L38 49L38 51L39 51L39 50L40 50L40 48ZM27 49L27 52L30 52L30 49ZM49 49L49 52L52 52L52 49ZM21 50L21 51L22 51L22 50ZM28 50L28 51L29 51L29 50ZM50 50L50 51L51 51L51 50ZM25 51L25 52L26 52L26 51ZM55 51L55 53L56 53L56 51ZM13 52L13 53L15 53L15 52ZM18 52L18 53L19 53L19 52ZM31 52L31 53L32 53L32 52ZM33 52L33 54L34 54L34 52ZM50 53L50 54L51 54L51 53ZM18 54L18 55L19 55L19 54ZM47 54L47 55L48 55L48 54ZM53 54L53 56L52 56L52 57L55 57L55 56L54 56L54 54ZM14 55L14 56L13 56L13 57L14 57L14 56L15 56L15 55ZM27 55L27 57L31 57L31 56L30 56L30 55L29 55L29 56L28 56L28 55ZM56 55L56 56L57 56L57 55ZM0 0L0 7L7 7L7 0ZM1 1L1 6L6 6L6 1ZM2 2L2 5L5 5L5 2ZM50 0L50 7L57 7L57 0ZM51 1L51 6L56 6L56 1ZM52 2L52 5L55 5L55 2ZM0 50L0 57L7 57L7 50ZM1 51L1 56L6 56L6 51ZM2 52L2 55L5 55L5 52Z\\\" fill=\\\"#000000\\\"\\/><\\/g><\\/g><\\/svg>\\n\\n                            <span style=\\\"width:50%;\\\">\\n                                <img style=\\\"max-height: 70px\\\"\\n                                     src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/img\\/AfipComprobanteAutorizado.png\\\">\\n                            <\\/span>\\n                        <\\/th>\\n                        <th style=\\\"text-align:right;\\\">\\n                            <p>CAE N&#186;: 71304902488777<br>\\n                                Fecha Vto. CAE:  25\\/07\\/2021\\n                            <\\/p>\\n                        <\\/th>\\n                    <\\/tr>\\n                <\\/table>\\n                    <\\/div>\\n    <\\/div>\\n\\n    <\\/body>\\n<\\/html>\\\";s:4:\\\"file\\\";N;}s:6:\\\"locale\\\";N;s:4:\\\"from\\\";a:0:{}s:2:\\\"to\\\";a:1:{i:0;a:2:{s:4:\\\"name\\\";N;s:7:\\\"address\\\";s:25:\\\"martinfelix1408@gmail.com\\\";}}s:2:\\\"cc\\\";a:0:{}s:3:\\\"bcc\\\";a:1:{i:0;a:2:{s:4:\\\"name\\\";N;s:7:\\\"address\\\";s:23:\\\"info@masquecontable.com\\\";}}s:7:\\\"replyTo\\\";a:0:{}s:7:\\\"subject\\\";N;s:11:\\\"\\u0000*\\u0000markdown\\\";N;s:7:\\\"\\u0000*\\u0000html\\\";N;s:4:\\\"view\\\";N;s:8:\\\"textView\\\";N;s:8:\\\"viewData\\\";a:0:{}s:11:\\\"attachments\\\";a:0:{}s:14:\\\"rawAttachments\\\";a:0:{}s:15:\\\"diskAttachments\\\";a:0:{}s:9:\\\"callbacks\\\";a:0:{}s:5:\\\"theme\\\";N;s:6:\\\"mailer\\\";s:8:\\\"sendgrid\\\";s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:5:\\\"delay\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;}\"}}','ErrorException: Trying to get property \'id\' of non-object in /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php:16\nStack trace:\n#0 /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php(16): Illuminate\\Foundation\\Bootstrap\\HandleExceptions->handleError(8, \'Trying to get p...\', \'/home/forge/tax...\', 16, Array)\n#1 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(356): App\\Queue\\DatabaseJob->fire()\n#2 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(306): Illuminate\\Queue\\Worker->process(\'database\', Object(App\\Queue\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#3 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(132): Illuminate\\Queue\\Worker->runJob(Object(App\\Queue\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#4 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(112): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#5 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(96): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#6 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#7 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#8 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#9 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#10 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#11 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(134): Illuminate\\Container\\Container->call(Array)\n#12 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(256): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#13 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(121): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#14 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(971): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#15 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(290): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#16 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(166): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#17 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Application.php(93): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(129): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#19 /home/forge/taxes.com.ar/artisan(35): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#20 {main}','2021-07-23 18:04:10',NULL);
INSERT INTO `failed_jobs` VALUES (17,NULL,'database','default','{\"uuid\":\"97d53766-acc9-481f-bd59-3078251bcf18\",\"displayName\":\"App\\\\Mail\\\\Fact_Electronica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"delay\":null,\"timeout\":null,\"timeoutAt\":null,\"data\":{\"commandName\":\"Illuminate\\\\Mail\\\\SendQueuedMailable\",\"command\":\"O:34:\\\"Illuminate\\\\Mail\\\\SendQueuedMailable\\\":3:{s:8:\\\"mailable\\\";O:25:\\\"App\\\\Mail\\\\Fact_Electronica\\\":27:{s:11:\\\"informacion\\\";a:6:{s:12:\\\"ruta_logo_fa\\\";N;s:4:\\\"mail\\\";s:23:\\\"info@masquecontable.com\\\";s:18:\\\"name_quien_factura\\\";s:19:\\\"MICAELA AILIN CORIA\\\";s:7:\\\"cliente\\\";O:17:\\\"App\\\\Models\\\\Person\\\":27:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:7:\\\"persons\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:40742;s:7:\\\"user_id\\\";i:5115;s:11:\\\"field_name1\\\";s:24:\\\"PAPURELLO CLAUDIA ANDREA\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-25557154-6\\\";s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-07-05 19:08:03\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-07-05 19:08:03\\\";s:11:\\\"activity_id\\\";i:1;s:7:\\\"address\\\";s:129:\\\"Direccion\\r\\nPEDRAZA MANUELA 2833 Piso:2 Dpto:D\\r\\nCod. Postal\\r\\n1429\\r\\nProvincia\\r\\nCIUDAD AUTONOMA BUENOS AIRES\\r\\nTipo Domicilio\\r\\nFISCAL\\\";s:14:\\\"person_type_id\\\";i:1;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:40742;s:7:\\\"user_id\\\";i:5115;s:11:\\\"field_name1\\\";s:24:\\\"PAPURELLO CLAUDIA ANDREA\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-25557154-6\\\";s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-07-05 19:08:03\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-07-05 19:08:03\\\";s:11:\\\"activity_id\\\";i:1;s:7:\\\"address\\\";s:129:\\\"Direccion\\r\\nPEDRAZA MANUELA 2833 Piso:2 Dpto:D\\r\\nCod. Postal\\r\\n1429\\r\\nProvincia\\r\\nCIUDAD AUTONOMA BUENOS AIRES\\r\\nTipo Domicilio\\r\\nFISCAL\\\";s:14:\\\"person_type_id\\\";i:1;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}s:14:\\\"nombre_del_pdf\\\";s:28:\\\"Factura N\\u00b00004-00000020.pdf\\\";s:9:\\\"body_mail\\\";s:155:\\\"Estimado cliente, se env\\u00eda adjunta la factura de honorarios correspondientes al mes de Julio 2021.\\nMuchas gracias por seguir eligiendo nuestros servicios.\\\";}s:3:\\\"pdf\\\";O:26:\\\"Barryvdh\\\\Snappy\\\\PdfWrapper\\\":4:{s:9:\\\"\\u0000*\\u0000snappy\\\";O:35:\\\"Barryvdh\\\\Snappy\\\\IlluminateSnappyPdf\\\":10:{s:26:\\\"\\u0000*\\u0000optionsWithContentCheck\\\";a:4:{s:11:\\\"header-html\\\";s:4:\\\"html\\\";s:11:\\\"footer-html\\\";s:4:\\\"html\\\";s:5:\\\"cover\\\";s:4:\\\"html\\\";s:15:\\\"xsl-style-sheet\\\";s:3:\\\"xsl\\\";}s:36:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000binary\\\";s:76:\\\"\\/home\\/forge\\/taxes.com.ar\\/vendor\\/h4cc\\/wkhtmltopdf-amd64\\/bin\\/wkhtmltopdf-amd64\\\";s:37:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000options\\\";a:132:{s:7:\\\"collate\\\";N;s:10:\\\"no-collate\\\";N;s:10:\\\"cookie-jar\\\";N;s:6:\\\"copies\\\";i:1;s:3:\\\"dpi\\\";N;s:13:\\\"extended-help\\\";N;s:9:\\\"grayscale\\\";N;s:4:\\\"help\\\";N;s:7:\\\"htmldoc\\\";N;s:18:\\\"ignore-load-errors\\\";N;s:9:\\\"image-dpi\\\";N;s:13:\\\"image-quality\\\";N;s:7:\\\"license\\\";N;s:9:\\\"log-level\\\";N;s:10:\\\"lowquality\\\";b:1;s:7:\\\"manpage\\\";N;s:13:\\\"margin-bottom\\\";N;s:11:\\\"margin-left\\\";N;s:12:\\\"margin-right\\\";N;s:10:\\\"margin-top\\\";N;s:11:\\\"orientation\\\";N;s:11:\\\"page-height\\\";N;s:9:\\\"page-size\\\";s:2:\\\"a4\\\";s:10:\\\"page-width\\\";N;s:18:\\\"no-pdf-compression\\\";N;s:5:\\\"quiet\\\";N;s:20:\\\"read-args-from-stdin\\\";N;s:6:\\\"readme\\\";N;s:5:\\\"title\\\";N;s:11:\\\"use-xserver\\\";N;s:7:\\\"version\\\";N;s:20:\\\"dump-default-toc-xsl\\\";N;s:12:\\\"dump-outline\\\";N;s:7:\\\"outline\\\";N;s:10:\\\"no-outline\\\";N;s:13:\\\"outline-depth\\\";N;s:13:\\\"output-format\\\";N;s:5:\\\"allow\\\";N;s:10:\\\"background\\\";N;s:13:\\\"no-background\\\";N;s:16:\\\"bypass-proxy-for\\\";N;s:9:\\\"cache-dir\\\";N;s:20:\\\"checkbox-checked-svg\\\";N;s:12:\\\"checkbox-svg\\\";N;s:6:\\\"cookie\\\";N;s:13:\\\"custom-header\\\";N;s:25:\\\"custom-header-propagation\\\";N;s:28:\\\"no-custom-header-propagation\\\";N;s:16:\\\"debug-javascript\\\";N;s:19:\\\"no-debug-javascript\\\";N;s:14:\\\"default-header\\\";N;s:8:\\\"encoding\\\";N;s:22:\\\"disable-external-links\\\";N;s:21:\\\"enable-external-links\\\";N;s:13:\\\"disable-forms\\\";N;s:12:\\\"enable-forms\\\";N;s:6:\\\"images\\\";N;s:9:\\\"no-images\\\";N;s:22:\\\"disable-internal-links\\\";N;s:21:\\\"enable-internal-links\\\";N;s:18:\\\"disable-javascript\\\";N;s:17:\\\"enable-javascript\\\";N;s:16:\\\"javascript-delay\\\";N;s:19:\\\"keep-relative-links\\\";N;s:19:\\\"load-error-handling\\\";N;s:25:\\\"load-media-error-handling\\\";N;s:25:\\\"disable-local-file-access\\\";N;s:24:\\\"enable-local-file-access\\\";N;s:17:\\\"minimum-font-size\\\";N;s:20:\\\"exclude-from-outline\\\";N;s:18:\\\"include-in-outline\\\";N;s:11:\\\"page-offset\\\";N;s:8:\\\"password\\\";N;s:15:\\\"disable-plugins\\\";N;s:14:\\\"enable-plugins\\\";N;s:4:\\\"post\\\";N;s:9:\\\"post-file\\\";N;s:16:\\\"print-media-type\\\";N;s:19:\\\"no-print-media-type\\\";N;s:5:\\\"proxy\\\";N;s:21:\\\"proxy-hostname-lookup\\\";N;s:23:\\\"radiobutton-checked-svg\\\";N;s:15:\\\"radiobutton-svg\\\";N;s:14:\\\"redirect-delay\\\";N;s:22:\\\"resolve-relative-links\\\";N;s:10:\\\"run-script\\\";N;s:23:\\\"disable-smart-shrinking\\\";N;s:22:\\\"enable-smart-shrinking\\\";N;s:12:\\\"ssl-crt-path\\\";N;s:16:\\\"ssl-key-password\\\";N;s:12:\\\"ssl-key-path\\\";N;s:17:\\\"stop-slow-scripts\\\";N;s:20:\\\"no-stop-slow-scripts\\\";N;s:22:\\\"disable-toc-back-links\\\";N;s:21:\\\"enable-toc-back-links\\\";N;s:16:\\\"user-style-sheet\\\";N;s:8:\\\"username\\\";N;s:13:\\\"viewport-size\\\";N;s:13:\\\"window-status\\\";N;s:4:\\\"zoom\\\";N;s:13:\\\"footer-center\\\";s:25:\\\"Pagina [page] de [toPage]\\\";s:16:\\\"footer-font-name\\\";N;s:16:\\\"footer-font-size\\\";i:8;s:11:\\\"footer-html\\\";N;s:11:\\\"footer-left\\\";s:0:\\\"\\\";s:11:\\\"footer-line\\\";N;s:14:\\\"no-footer-line\\\";N;s:12:\\\"footer-right\\\";N;s:14:\\\"footer-spacing\\\";N;s:13:\\\"header-center\\\";N;s:16:\\\"header-font-name\\\";N;s:16:\\\"header-font-size\\\";N;s:11:\\\"header-html\\\";N;s:11:\\\"header-left\\\";N;s:11:\\\"header-line\\\";N;s:14:\\\"no-header-line\\\";N;s:12:\\\"header-right\\\";N;s:14:\\\"header-spacing\\\";N;s:7:\\\"replace\\\";N;s:5:\\\"cover\\\";N;s:3:\\\"toc\\\";N;s:20:\\\"disable-dotted-lines\\\";N;s:9:\\\"toc-depth\\\";N;s:13:\\\"toc-font-name\\\";N;s:16:\\\"toc-l1-font-size\\\";N;s:15:\\\"toc-header-text\\\";N;s:20:\\\"toc-header-font-name\\\";N;s:20:\\\"toc-header-font-size\\\";N;s:21:\\\"toc-level-indentation\\\";N;s:17:\\\"disable-toc-links\\\";N;s:20:\\\"toc-text-size-shrink\\\";N;s:15:\\\"xsl-style-sheet\\\";N;}s:33:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000env\\\";N;s:37:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000timeout\\\";b:0;s:46:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000defaultExtension\\\";s:3:\\\"pdf\\\";s:18:\\\"\\u0000*\\u0000temporaryFolder\\\";N;s:14:\\\"temporaryFiles\\\";a:0:{}s:36:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000logger\\\";O:18:\\\"Psr\\\\Log\\\\NullLogger\\\":0:{}s:2:\\\"fs\\\";O:32:\\\"Illuminate\\\\Filesystem\\\\Filesystem\\\":0:{}}s:10:\\\"\\u0000*\\u0000options\\\";a:0:{}s:4:\\\"html\\\";s:22096:\\\"<!DOCTYPE html>\\n<html lang=\\\"en\\\">\\n    <head>\\n        <meta charset=\\\"utf-8\\\">\\n    <\\/head>\\n    <style>\\n        .subtotales_conceptos{\\n            width:30%;\\n            text-align: right;\\n        }\\n        .subtotales_importes{\\n            text-align: right;\\n        }\\n        .table-totales, .table-totales tr, .table-totales th{\\n            border: 1px solid;\\n        }\\n\\n    <\\/style>\\n    <body>\\n    <div style=\\\"max-height:840px\\\">\\n        <div style=\\\"width: 100%; height:270px\\\"> <!-- Datos de la empresa -->\\n            <table class=\\\"display\\\" cellspacing=\\\"0\\\" width=\\\"100%\\\" style=\\\"border:  1px solid;\\\">\\n                <tr style=\\\"\\\">\\n                    <th colspan=\\\"2\\\" rowspan=\\\"2\\\" style=\\\"width:45%;margin:0;height:150px;\\\">\\n                                                <img src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/img\\/\\/27377183504\\/logo_punto_venta_0000.png\\\"\\/>\\n                                            <\\/th>\\n                    <th style=\\\"border:  1px solid;text-align: center; width:10%\\\" colspan=\\\"2\\\">\\n                        <span style=\\\"font-size: 60px;\\\">C<\\/span> <br \\/> <span style=\\\"font-size: 14px;\\\">cod. 11<\\/span>\\n                    <\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"font-size: 28px;text-align: center;width:45%\\\">\\n                        Factura\\n                        <br>\\n                        0004 - 00000020\\n                    <\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th><\\/th>\\n                    <th style=\\\"border:  1px 1px 1px 0px solid;\\\" colspan=\\\"2\\\"><\\/th>\\n                    <th><\\/th>\\n                <\\/tr>\\n                <tr>\\n\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                                                    Raz&oacute;n Social:\\n                            <span style=\\\"font-weight: normal;\\\">MICAELA AILIN CORIA<\\/span>\\n                                            <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">Fecha de Emisi&oacute;n: <span style=\\\"font-weight: normal;\\\">15\\/07\\/2021<\\/span><\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Domicilio Comercial: <span style=\\\"font-weight: normal;\\\">Victor Guillet esq. Arturo M Bas, C.P.:5800,\\n                        C\\u00f3rdoba<\\/span>\\n                    <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">CUIT: <span style=\\\"font-weight: normal;\\\">27-37718350-4<\\/span><\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Condici&oacute;n frente al IVA: <span style=\\\"font-weight: normal;\\\">Monotributo<\\/span>\\n                    <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Ingresos Brutos: <span style=\\\"font-weight: normal;\\\"><\\/span>\\n                        <br>\\n                        Fecha de Inicio de Actividades: <span style=\\\"font-weight: normal;\\\">09\\/07\\/2021<\\/span>\\n                    <\\/th>\\n                <\\/tr>\\n            <\\/table>\\n        <\\/div>\\n\\n        <table style=\\\"text-align: center; width: 100%;border: solid 1px;\\\"> <!-- Fechas -->\\n            <thead>\\n                <tr>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Per\\u00edodo Facturado Desde: 01\\/07\\/2021<\\/small><\\/th>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Per\\u00edodo Facturado Hasta: 31\\/07\\/2021<\\/small><\\/th>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Fecha Vto. Pago: 15\\/07\\/2021<\\/small><\\/th>\\n                <\\/tr>\\n            <\\/thead>\\n        <\\/table>\\n        \\n        <table style=\\\"width: 100%; margin-top: 1%;border: solid 1px;\\\"> <!-- Datos Clientes -->\\n            <tr>\\n                <th style=\\\"text-align:left;\\\"colspan=\\\"12\\\">\\n                    CUIT: <span style=\\\"font-weight: normal;\\\">27-25557154-6<\\/span>\\n                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\\n                    Apellido y Nombre \\/ Raz&oacute;n Social: <span style=\\\"font-weight: normal;\\\">\\n                    PAPURELLO CLAUDIA ANDREA<\\/span>\\n                <\\/th>\\n            <\\/tr>\\n            <tr>\\n                <th style=\\\"text-align:left; width:50%\\\">\\n                    Condici&oacute;n Frente al IVA: <span style=\\\"font-weight: normal;\\\">Responsable Monotributo<\\/span>\\n                <\\/th>\\n                <th style=\\\"text-align:left; width:50%\\\" colspan=\\\"4\\\">\\n                    Domicilio Comercial:\\n                    <span style=\\\"font-weight: normal;\\\">\\n                    Direccion\\r\\nPEDRAZA MANUELA 2833 Piso:2 Dpto:D\\r\\nCod. Postal\\r\\n1429\\r\\nProvincia\\r\\nCIUDAD AUTONOMA BUENOS AIRES\\r\\nTipo Domicilio\\r\\nFISCAL\\n                    <\\/span>\\n                <\\/th>\\n            <\\/tr>\\n            <tr style=\\\"text-align:left\\\">\\n                <th>Condici&oacute;n de Venta: <span style=\\\"font-weight: normal;\\\">Cuenta Corriente<\\/span><\\/th>\\n            <\\/tr>\\n        <\\/table>\\n\\n        <div style=\\\"border: 1px solid;margin-top: 1%;min-height:600px;\\\">\\n        <table style=\\\"text-align: center; width: 100%; margin-top: 1%;\\\"> <!-- Body -->\\n            <tr style=\\\"border-bottom: 1px solid;font-size: 15px\\\">\\n                <th>C&oacute;digo<\\/th>\\n                <th style=\\\"width: 25%;\\\">Detalle<\\/th>\\n                <th>Cantidad<\\/th>\\n                <th>U.Medida<\\/th>\\n                <th>Precio U.<\\/th>\\n                <th>Bonif. (%)<\\/th>\\n                <th>Precio Bonif.<\\/th>\\n                <th>Subtotal<\\/th>\\n                            <\\/tr>\\n            <tbody>\\n                                                                                <tr style=\\\"font-size: 12px;\\\">\\n                        <td>\\n                            \\n                        <\\/td>\\n                        <td>\\n                            Honorarios profesionales Julio 2021\\n                        <\\/td>\\n                        <td>\\n                            1.00\\n                        <\\/td>\\n                        <td>\\n                            Unidades\\n                        <\\/td>\\n                        <td>                            2.950,00\\n                                                    <\\/td>\\n                        <td>\\n                            0,00%\\n                        <\\/td>\\n                        <td>\\n                            0,00\\n                        <\\/td>\\n                        <td>\\n                            2.950,00\\n                        <\\/td>\\n                                            <\\/tr>\\n                    \\n            <\\/tbody>\\n        <\\/table>\\n        <\\/div>\\n\\n        \\n\\n        <div style=\\\"height:200px;margin-top: 1%;\\\"> <!-- Totales -->\\n              <!-- Es factura B o C -->\\n                <table class=\\\"table-totales\\\" cellspacing=\\\"0\\\" width=\\\"100%\\\">\\n                    <tr>\\n                        <th style=\\\"width:50%; text-align:left;\\\">\\n\\n<!--                                <span style=\\\"width:100%;\\\"><img src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/barcodes\\/71304902490057.png\\\"><\\/span>\\n                                <span style=\\\"text-align:center;\\\">2737718350411000471304902490057202107253<\\/span>-->\\n                        <\\/th>\\n                        <th class=\\\"subtotales_conceptos\\\">TOTAL:<\\/th>\\n                        <th class=\\\"subtotales_importes\\\">$ 2.950,00<\\/th>\\n                    <\\/tr>\\n                <\\/table>\\n                <br>\\n                <table cellspacing=\\\"0\\\" width=\\\"100%\\\" style=\\\"border: none\\\">\\n                    <tr>\\n                        <th style=\\\"width:50%; text-align:left;\\\">\\n\\n                            <?xml version=\\\"1.0\\\" encoding=\\\"UTF-8\\\"?>\\n<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" version=\\\"1.1\\\" width=\\\"100\\\" height=\\\"100\\\" viewBox=\\\"0 0 100 100\\\"><rect x=\\\"0\\\" y=\\\"0\\\" width=\\\"100\\\" height=\\\"100\\\" fill=\\\"#ffffff\\\"\\/><g transform=\\\"scale(1.754)\\\"><g transform=\\\"translate(0,0)\\\"><path fill-rule=\\\"evenodd\\\" d=\\\"M8 0L8 1L9 1L9 2L8 2L8 5L12 5L12 7L11 7L11 6L10 6L10 7L9 7L9 6L8 6L8 7L9 7L9 8L8 8L8 9L7 9L7 8L6 8L6 9L5 9L5 10L4 10L4 11L3 11L3 12L4 12L4 13L5 13L5 12L6 12L6 13L8 13L8 14L5 14L5 15L4 15L4 16L2 16L2 17L4 17L4 16L5 16L5 15L8 15L8 14L10 14L10 17L9 17L9 16L8 16L8 17L9 17L9 18L6 18L6 17L7 17L7 16L6 16L6 17L5 17L5 18L3 18L3 19L1 19L1 18L0 18L0 19L1 19L1 21L0 21L0 22L1 22L1 21L3 21L3 22L2 22L2 23L1 23L1 24L0 24L0 25L1 25L1 27L0 27L0 29L2 29L2 31L0 31L0 32L2 32L2 33L0 33L0 34L1 34L1 35L0 35L0 40L1 40L1 41L0 41L0 42L5 42L5 43L7 43L7 44L5 44L5 45L2 45L2 47L1 47L1 45L0 45L0 48L5 48L5 47L7 47L7 46L5 46L5 45L8 45L8 46L9 46L9 47L8 47L8 48L6 48L6 49L8 49L8 50L9 50L9 49L10 49L10 48L11 48L11 51L12 51L12 52L13 52L13 53L12 53L12 54L13 54L13 53L14 53L14 52L15 52L15 53L16 53L16 54L17 54L17 55L18 55L18 56L17 56L17 57L18 57L18 56L19 56L19 57L21 57L21 55L22 55L22 53L21 53L21 55L20 55L20 51L21 51L21 52L23 52L23 50L24 50L24 53L25 53L25 54L23 54L23 56L22 56L22 57L24 57L24 56L26 56L26 55L25 55L25 54L27 54L27 53L31 53L31 54L33 54L33 55L32 55L32 56L34 56L34 57L36 57L36 55L38 55L38 56L37 56L37 57L44 57L44 56L43 56L43 55L42 55L42 56L41 56L41 55L40 55L40 54L42 54L42 53L40 53L40 52L43 52L43 53L45 53L45 52L46 52L46 51L45 51L45 49L47 49L47 48L48 48L48 50L47 50L47 53L46 53L46 54L44 54L44 55L45 55L45 56L46 56L46 57L47 57L47 54L48 54L48 55L49 55L49 54L50 54L50 57L51 57L51 54L52 54L52 53L55 53L55 54L56 54L56 53L57 53L57 51L56 51L56 49L57 49L57 48L56 48L56 49L55 49L55 51L53 51L53 49L54 49L54 48L53 48L53 46L54 46L54 45L56 45L56 46L55 46L55 47L57 47L57 44L53 44L53 46L52 46L52 43L51 43L51 44L50 44L50 42L51 42L51 41L50 41L50 40L51 40L51 39L54 39L54 41L53 41L53 40L52 40L52 42L54 42L54 43L55 43L55 42L57 42L57 40L56 40L56 38L57 38L57 31L56 31L56 30L57 30L57 27L56 27L56 24L57 24L57 21L56 21L56 20L53 20L53 19L54 19L54 18L55 18L55 14L54 14L54 10L53 10L53 9L55 9L55 10L56 10L56 11L55 11L55 12L57 12L57 8L56 8L56 9L55 9L55 8L52 8L52 10L51 10L51 11L50 11L50 10L49 10L49 9L50 9L50 8L48 8L48 7L49 7L49 6L48 6L48 7L47 7L47 5L48 5L48 0L45 0L45 1L43 1L43 0L39 0L39 1L41 1L41 4L40 4L40 5L39 5L39 2L38 2L38 1L37 1L37 2L36 2L36 1L32 1L32 2L31 2L31 0L30 0L30 1L29 1L29 0L28 0L28 1L26 1L26 0L24 0L24 1L23 1L23 0L22 0L22 1L23 1L23 2L22 2L22 3L21 3L21 4L20 4L20 5L21 5L21 4L22 4L22 11L20 11L20 12L19 12L19 10L20 10L20 9L21 9L21 8L20 8L20 7L21 7L21 6L20 6L20 7L19 7L19 6L18 6L18 7L17 7L17 6L16 6L16 7L15 7L15 6L14 6L14 5L13 5L13 4L14 4L14 3L15 3L15 5L17 5L17 4L16 4L16 3L17 3L17 2L18 2L18 1L17 1L17 2L15 2L15 1L16 1L16 0L14 0L14 2L13 2L13 0L11 0L11 1L10 1L10 0ZM19 1L19 2L21 2L21 1ZM25 1L25 2L23 2L23 3L22 3L22 4L23 4L23 3L24 3L24 5L23 5L23 12L22 12L22 13L23 13L23 14L24 14L24 16L23 16L23 15L22 15L22 14L20 14L20 13L19 13L19 12L18 12L18 10L19 10L19 9L20 9L20 8L18 8L18 9L17 9L17 8L15 8L15 7L14 7L14 6L13 6L13 7L12 7L12 8L11 8L11 7L10 7L10 8L9 8L9 9L13 9L13 10L12 10L12 12L11 12L11 10L8 10L8 13L11 13L11 14L13 14L13 13L15 13L15 14L14 14L14 15L13 15L13 16L12 16L12 15L11 15L11 20L10 20L10 18L9 18L9 19L8 19L8 20L7 20L7 19L6 19L6 18L5 18L5 19L6 19L6 20L5 20L5 21L6 21L6 22L7 22L7 21L8 21L8 23L5 23L5 24L8 24L8 23L9 23L9 22L10 22L10 23L11 23L11 25L12 25L12 27L14 27L14 28L9 28L9 31L10 31L10 33L9 33L9 32L8 32L8 33L9 33L9 34L7 34L7 33L6 33L6 32L7 32L7 31L5 31L5 32L3 32L3 33L6 33L6 34L7 34L7 35L6 35L6 36L7 36L7 37L6 37L6 38L5 38L5 39L6 39L6 40L7 40L7 41L6 41L6 42L7 42L7 43L8 43L8 44L9 44L9 43L10 43L10 42L11 42L11 43L14 43L14 44L15 44L15 45L13 45L13 47L12 47L12 46L10 46L10 47L9 47L9 48L10 48L10 47L12 47L12 48L13 48L13 49L14 49L14 50L12 50L12 51L15 51L15 49L16 49L16 53L17 53L17 52L18 52L18 53L19 53L19 51L20 51L20 48L22 48L22 49L23 49L23 48L22 48L22 47L24 47L24 46L22 46L22 44L23 44L23 45L25 45L25 46L27 46L27 44L28 44L28 47L26 47L26 48L24 48L24 50L25 50L25 49L26 49L26 48L28 48L28 47L29 47L29 48L30 48L30 47L32 47L32 50L31 50L31 51L32 51L32 50L33 50L33 51L35 51L35 52L36 52L36 53L35 53L35 55L34 55L34 56L35 56L35 55L36 55L36 53L37 53L37 54L38 54L38 55L39 55L39 56L40 56L40 55L39 55L39 53L37 53L37 51L38 51L38 52L40 52L40 50L41 50L41 51L42 51L42 50L43 50L43 51L44 51L44 49L45 49L45 48L46 48L46 46L47 46L47 45L48 45L48 44L49 44L49 42L50 42L50 41L47 41L47 42L48 42L48 43L46 43L46 44L45 44L45 42L46 42L46 40L47 40L47 39L48 39L48 38L47 38L47 37L49 37L49 36L50 36L50 39L51 39L51 38L54 38L54 39L55 39L55 38L56 38L56 36L55 36L55 35L56 35L56 32L55 32L55 30L56 30L56 27L55 27L55 23L54 23L54 22L51 22L51 21L52 21L52 20L51 20L51 19L53 19L53 18L51 18L51 17L54 17L54 14L52 14L52 13L53 13L53 10L52 10L52 11L51 11L51 12L52 12L52 13L51 13L51 15L50 15L50 16L51 16L51 17L50 17L50 18L51 18L51 19L50 19L50 20L49 20L49 19L48 19L48 18L49 18L49 17L47 17L47 16L46 16L46 15L47 15L47 13L48 13L48 14L50 14L50 12L49 12L49 10L48 10L48 8L47 8L47 9L46 9L46 10L48 10L48 11L46 11L46 12L47 12L47 13L46 13L46 14L45 14L45 12L44 12L44 13L43 13L43 12L42 12L42 13L41 13L41 9L44 9L44 10L43 10L43 11L45 11L45 7L46 7L46 5L47 5L47 3L46 3L46 2L47 2L47 1L45 1L45 3L44 3L44 5L43 5L43 4L41 4L41 7L42 7L42 8L41 8L41 9L39 9L39 8L38 8L38 9L37 9L37 8L35 8L35 7L36 7L36 6L37 6L37 7L38 7L38 6L37 6L37 5L38 5L38 3L37 3L37 5L35 5L35 4L34 4L34 5L33 5L33 7L32 7L32 4L33 4L33 3L34 3L34 2L33 2L33 3L31 3L31 8L32 8L32 9L31 9L31 10L33 10L33 11L34 11L34 10L35 10L35 13L34 13L34 14L32 14L32 15L33 15L33 17L30 17L30 18L28 18L28 19L27 19L27 17L29 17L29 16L30 16L30 15L29 15L29 13L30 13L30 14L31 14L31 13L33 13L33 12L31 12L31 11L26 11L26 12L25 12L25 11L24 11L24 8L25 8L25 10L27 10L27 9L26 9L26 8L25 8L25 7L26 7L26 6L25 6L25 5L26 5L26 4L25 4L25 2L26 2L26 3L28 3L28 4L30 4L30 3L29 3L29 2L26 2L26 1ZM9 2L9 4L10 4L10 2ZM11 2L11 3L12 3L12 4L13 4L13 3L12 3L12 2ZM18 3L18 5L19 5L19 3ZM45 3L45 5L46 5L46 3ZM27 5L27 8L30 8L30 5ZM42 5L42 7L43 7L43 8L44 8L44 7L45 7L45 6L44 6L44 7L43 7L43 5ZM24 6L24 7L25 7L25 6ZM28 6L28 7L29 7L29 6ZM34 6L34 7L35 7L35 6ZM39 6L39 7L40 7L40 6ZM13 7L13 9L14 9L14 11L15 11L15 13L17 13L17 14L16 14L16 16L15 16L15 15L14 15L14 18L13 18L13 19L12 19L12 20L11 20L11 21L12 21L12 22L13 22L13 19L15 19L15 18L17 18L17 17L18 17L18 19L16 19L16 20L14 20L14 21L15 21L15 23L16 23L16 24L14 24L14 23L12 23L12 25L13 25L13 26L14 26L14 25L15 25L15 26L16 26L16 25L17 25L17 26L18 26L18 25L19 25L19 27L17 27L17 28L16 28L16 27L15 27L15 28L16 28L16 30L14 30L14 29L13 29L13 30L10 30L10 31L12 31L12 32L11 32L11 33L12 33L12 34L13 34L13 36L14 36L14 37L11 37L11 39L10 39L10 37L9 37L9 40L11 40L11 39L13 39L13 40L12 40L12 42L13 42L13 41L14 41L14 39L15 39L15 38L17 38L17 39L16 39L16 40L15 40L15 42L16 42L16 43L17 43L17 45L18 45L18 46L17 46L17 47L16 47L16 49L17 49L17 50L19 50L19 48L20 48L20 47L21 47L21 46L20 46L20 47L18 47L18 46L19 46L19 44L20 44L20 45L21 45L21 44L20 44L20 43L18 43L18 42L20 42L20 41L18 41L18 42L17 42L17 41L16 41L16 40L17 40L17 39L18 39L18 40L20 40L20 39L21 39L21 40L22 40L22 39L21 39L21 37L22 37L22 38L24 38L24 36L23 36L23 37L22 37L22 36L21 36L21 34L19 34L19 35L20 35L20 39L18 39L18 38L19 38L19 36L18 36L18 38L17 38L17 37L16 37L16 36L17 36L17 35L18 35L18 34L17 34L17 35L16 35L16 34L13 34L13 33L14 33L14 32L15 32L15 31L17 31L17 32L18 32L18 28L19 28L19 30L20 30L20 28L19 28L19 27L21 27L21 28L22 28L22 27L23 27L23 30L22 30L22 29L21 29L21 30L22 30L22 31L20 31L20 33L21 33L21 32L22 32L22 35L26 35L26 36L25 36L25 37L27 37L27 35L28 35L28 37L29 37L29 39L30 39L30 38L31 38L31 40L27 40L27 42L29 42L29 41L30 41L30 44L29 44L29 43L28 43L28 44L29 44L29 45L30 45L30 46L31 46L31 45L32 45L32 47L33 47L33 46L34 46L34 48L33 48L33 50L34 50L34 48L35 48L35 47L36 47L36 49L35 49L35 51L36 51L36 49L37 49L37 48L38 48L38 45L37 45L37 47L36 47L36 45L35 45L35 46L34 46L34 45L32 45L32 43L31 43L31 41L33 41L33 43L35 43L35 44L37 44L37 42L38 42L38 44L39 44L39 47L40 47L40 45L41 45L41 48L42 48L42 49L43 49L43 48L45 48L45 45L44 45L44 44L43 44L43 43L42 43L42 45L41 45L41 43L40 43L40 44L39 44L39 42L38 42L38 41L37 41L37 42L36 42L36 40L35 40L35 39L38 39L38 40L39 40L39 41L40 41L40 42L42 42L42 41L43 41L43 42L45 42L45 40L46 40L46 38L45 38L45 37L46 37L46 36L48 36L48 35L49 35L49 34L48 34L48 33L50 33L50 36L51 36L51 35L52 35L52 37L54 37L54 38L55 38L55 37L54 37L54 35L55 35L55 32L54 32L54 29L55 29L55 27L53 27L53 25L52 25L52 23L51 23L51 25L50 25L50 23L49 23L49 25L50 25L50 26L48 26L48 23L47 23L47 22L46 22L46 21L44 21L44 22L43 22L43 18L44 18L44 17L46 17L46 19L45 19L45 20L47 20L47 21L48 21L48 22L49 22L49 20L47 20L47 17L46 17L46 16L45 16L45 15L44 15L44 14L42 14L42 15L41 15L41 13L40 13L40 10L39 10L39 13L38 13L38 12L37 12L37 9L36 9L36 13L35 13L35 15L39 15L39 16L38 16L38 17L37 17L37 19L36 19L36 18L35 18L35 17L36 17L36 16L35 16L35 17L33 17L33 18L31 18L31 19L35 19L35 20L37 20L37 22L36 22L36 21L35 21L35 22L32 22L32 20L30 20L30 19L28 19L28 20L27 20L27 19L25 19L25 18L24 18L24 19L22 19L22 18L21 18L21 19L20 19L20 16L19 16L19 17L18 17L18 16L17 16L17 14L18 14L18 12L17 12L17 11L16 11L16 10L15 10L15 9L14 9L14 7ZM0 8L0 9L4 9L4 8ZM6 9L6 10L7 10L7 9ZM28 9L28 10L30 10L30 9ZM1 10L1 11L0 11L0 15L1 15L1 14L3 14L3 13L2 13L2 12L1 12L1 11L2 11L2 10ZM6 11L6 12L7 12L7 11ZM23 12L23 13L24 13L24 12ZM26 12L26 14L25 14L25 16L24 16L24 17L25 17L25 16L26 16L26 15L27 15L27 12ZM36 13L36 14L38 14L38 13ZM39 13L39 15L40 15L40 13ZM19 14L19 15L20 15L20 14ZM28 15L28 16L29 16L29 15ZM42 15L42 16L39 16L39 17L38 17L38 18L41 18L41 17L42 17L42 18L43 18L43 17L42 17L42 16L43 16L43 15ZM52 15L52 16L53 16L53 15ZM56 16L56 18L57 18L57 16ZM18 19L18 20L17 20L17 21L16 21L16 23L18 23L18 22L19 22L19 23L20 23L20 24L19 24L19 25L20 25L20 24L22 24L22 25L23 25L23 26L24 26L24 27L25 27L25 29L24 29L24 32L25 32L25 34L26 34L26 35L27 35L27 34L30 34L30 35L29 35L29 36L30 36L30 35L31 35L31 38L33 38L33 36L32 36L32 34L31 34L31 33L33 33L33 34L36 34L36 35L37 35L37 34L38 34L38 36L37 36L37 37L39 37L39 38L38 38L38 39L40 39L40 41L42 41L42 38L44 38L44 39L45 39L45 38L44 38L44 37L45 37L45 36L46 36L46 34L47 34L47 33L48 33L48 31L46 31L46 32L45 32L45 31L44 31L44 32L43 32L43 29L44 29L44 30L45 30L45 29L44 29L44 27L46 27L46 29L47 29L47 30L48 30L48 27L47 27L47 25L45 25L45 24L44 24L44 25L43 25L43 24L42 24L42 25L41 25L41 23L40 23L40 24L39 24L39 23L38 23L38 24L37 24L37 26L35 26L35 25L36 25L36 23L35 23L35 25L34 25L34 23L33 23L33 24L32 24L32 22L31 22L31 23L30 23L30 20L29 20L29 21L28 21L28 22L27 22L27 21L25 21L25 23L22 23L22 19L21 19L21 21L20 21L20 19ZM24 19L24 20L25 20L25 19ZM37 19L37 20L38 20L38 19ZM39 19L39 20L40 20L40 19ZM41 19L41 20L42 20L42 19ZM6 20L6 21L7 21L7 20ZM33 20L33 21L34 21L34 20ZM50 20L50 21L51 21L51 20ZM17 21L17 22L18 22L18 21ZM19 21L19 22L20 22L20 21ZM23 21L23 22L24 22L24 21ZM38 21L38 22L40 22L40 21ZM55 21L55 22L56 22L56 21ZM3 22L3 23L2 23L2 26L4 26L4 25L3 25L3 23L4 23L4 22ZM26 22L26 23L25 23L25 25L26 25L26 29L25 29L25 32L26 32L26 33L27 33L27 32L26 32L26 31L30 31L30 33L31 33L31 30L32 30L32 31L33 31L33 30L34 30L34 32L33 32L33 33L35 33L35 32L37 32L37 33L38 33L38 32L40 32L40 33L39 33L39 34L42 34L42 35L41 35L41 36L45 36L45 34L46 34L46 33L47 33L47 32L46 32L46 33L44 33L44 35L43 35L43 32L42 32L42 33L41 33L41 31L40 31L40 30L41 30L41 29L43 29L43 27L42 27L42 28L41 28L41 26L40 26L40 25L39 25L39 24L38 24L38 27L37 27L37 29L36 29L36 28L35 28L35 29L34 29L34 28L33 28L33 27L31 27L31 26L34 26L34 25L32 25L32 24L31 24L31 26L28 26L28 24L26 24L26 23L27 23L27 22ZM44 22L44 23L45 23L45 22ZM9 24L9 25L10 25L10 24ZM6 25L6 26L8 26L8 25ZM44 25L44 26L45 26L45 25ZM9 26L9 27L10 27L10 26ZM21 26L21 27L22 27L22 26ZM39 26L39 27L40 27L40 26ZM1 27L1 28L2 28L2 27ZM5 27L5 30L8 30L8 27ZM27 27L27 30L30 30L30 27ZM49 27L49 30L52 30L52 27ZM3 28L3 29L4 29L4 28ZM6 28L6 29L7 29L7 28ZM28 28L28 29L29 29L29 28ZM31 28L31 29L32 29L32 28ZM38 28L38 29L37 29L37 30L39 30L39 29L41 29L41 28ZM50 28L50 29L51 29L51 28ZM53 28L53 29L54 29L54 28ZM35 29L35 31L36 31L36 29ZM3 30L3 31L4 31L4 30ZM13 31L13 32L12 32L12 33L13 33L13 32L14 32L14 31ZM22 31L22 32L23 32L23 31ZM37 31L37 32L38 32L38 31ZM50 31L50 33L51 33L51 31ZM52 31L52 34L54 34L54 32L53 32L53 31ZM23 33L23 34L24 34L24 33ZM3 34L3 35L1 35L1 36L2 36L2 37L3 37L3 38L2 38L2 40L3 40L3 41L4 41L4 40L3 40L3 38L4 38L4 37L5 37L5 36L3 36L3 35L4 35L4 34ZM10 34L10 35L9 35L9 36L10 36L10 35L11 35L11 34ZM34 36L34 39L33 39L33 40L34 40L34 39L35 39L35 38L36 38L36 37L35 37L35 36ZM39 36L39 37L40 37L40 39L41 39L41 37L40 37L40 36ZM6 38L6 39L7 39L7 40L8 40L8 38ZM13 38L13 39L14 39L14 38ZM26 38L26 39L28 39L28 38ZM24 39L24 40L23 40L23 42L24 42L24 41L25 41L25 44L26 44L26 41L25 41L25 39ZM55 40L55 41L54 41L54 42L55 42L55 41L56 41L56 40ZM8 41L8 42L10 42L10 41ZM21 41L21 43L22 43L22 41ZM1 43L1 44L4 44L4 43ZM23 43L23 44L24 44L24 43ZM30 44L30 45L31 45L31 44ZM15 45L15 46L16 46L16 45ZM43 45L43 47L42 47L42 48L43 48L43 47L44 47L44 45ZM49 45L49 48L50 48L50 46L51 46L51 45ZM3 46L3 47L5 47L5 46ZM13 47L13 48L14 48L14 49L15 49L15 47ZM17 47L17 48L18 48L18 47ZM51 47L51 48L52 48L52 47ZM39 48L39 49L38 49L38 51L39 51L39 50L40 50L40 48ZM27 49L27 52L30 52L30 49ZM49 49L49 52L52 52L52 49ZM21 50L21 51L22 51L22 50ZM28 50L28 51L29 51L29 50ZM50 50L50 51L51 51L51 50ZM9 51L9 52L10 52L10 51ZM25 51L25 52L26 52L26 51ZM55 51L55 53L56 53L56 51ZM31 52L31 53L32 53L32 52ZM33 52L33 54L34 54L34 52ZM8 53L8 57L9 57L9 55L11 55L11 56L13 56L13 57L14 57L14 56L15 56L15 55L14 55L14 56L13 56L13 55L11 55L11 54L10 54L10 53ZM50 53L50 54L51 54L51 53ZM18 54L18 55L19 55L19 54ZM27 55L27 57L31 57L31 56L30 56L30 55L29 55L29 56L28 56L28 55ZM53 55L53 56L52 56L52 57L55 57L55 56L54 56L54 55ZM56 55L56 56L57 56L57 55ZM0 0L0 7L7 7L7 0ZM1 1L1 6L6 6L6 1ZM2 2L2 5L5 5L5 2ZM50 0L50 7L57 7L57 0ZM51 1L51 6L56 6L56 1ZM52 2L52 5L55 5L55 2ZM0 50L0 57L7 57L7 50ZM1 51L1 56L6 56L6 51ZM2 52L2 55L5 55L5 52Z\\\" fill=\\\"#000000\\\"\\/><\\/g><\\/g><\\/svg>\\n\\n                            <span style=\\\"width:50%;\\\">\\n                                <img style=\\\"max-height: 70px\\\"\\n                                     src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/img\\/AfipComprobanteAutorizado.png\\\">\\n                            <\\/span>\\n                        <\\/th>\\n                        <th style=\\\"text-align:right;\\\">\\n                            <p>CAE N&#186;: 71304902490057<br>\\n                                Fecha Vto. CAE:  25\\/07\\/2021\\n                            <\\/p>\\n                        <\\/th>\\n                    <\\/tr>\\n                <\\/table>\\n                    <\\/div>\\n    <\\/div>\\n\\n    <\\/body>\\n<\\/html>\\\";s:4:\\\"file\\\";N;}s:6:\\\"locale\\\";N;s:4:\\\"from\\\";a:0:{}s:2:\\\"to\\\";a:1:{i:0;a:2:{s:4:\\\"name\\\";N;s:7:\\\"address\\\";s:27:\\\"claudia.papurello@gmail.com\\\";}}s:2:\\\"cc\\\";a:0:{}s:3:\\\"bcc\\\";a:1:{i:0;a:2:{s:4:\\\"name\\\";N;s:7:\\\"address\\\";s:23:\\\"info@masquecontable.com\\\";}}s:7:\\\"replyTo\\\";a:0:{}s:7:\\\"subject\\\";N;s:11:\\\"\\u0000*\\u0000markdown\\\";N;s:7:\\\"\\u0000*\\u0000html\\\";N;s:4:\\\"view\\\";N;s:8:\\\"textView\\\";N;s:8:\\\"viewData\\\";a:0:{}s:11:\\\"attachments\\\";a:0:{}s:14:\\\"rawAttachments\\\";a:0:{}s:15:\\\"diskAttachments\\\";a:0:{}s:9:\\\"callbacks\\\";a:0:{}s:5:\\\"theme\\\";N;s:6:\\\"mailer\\\";s:8:\\\"sendgrid\\\";s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:5:\\\"delay\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;}\"}}','ErrorException: Trying to get property \'id\' of non-object in /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php:16\nStack trace:\n#0 /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php(16): Illuminate\\Foundation\\Bootstrap\\HandleExceptions->handleError(8, \'Trying to get p...\', \'/home/forge/tax...\', 16, Array)\n#1 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(356): App\\Queue\\DatabaseJob->fire()\n#2 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(306): Illuminate\\Queue\\Worker->process(\'database\', Object(App\\Queue\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#3 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(132): Illuminate\\Queue\\Worker->runJob(Object(App\\Queue\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#4 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(112): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#5 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(96): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#6 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#7 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#8 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#9 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#10 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#11 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(134): Illuminate\\Container\\Container->call(Array)\n#12 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(256): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#13 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(121): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#14 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(971): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#15 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(290): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#16 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(166): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#17 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Application.php(93): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(129): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#19 /home/forge/taxes.com.ar/artisan(35): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#20 {main}','2021-07-23 18:04:10',NULL);
INSERT INTO `failed_jobs` VALUES (18,NULL,'database','default','{\"uuid\":\"548a7a03-2bbd-4310-a51a-8d03c18ef5ac\",\"displayName\":\"App\\\\Mail\\\\Fact_Electronica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"delay\":null,\"timeout\":null,\"timeoutAt\":null,\"data\":{\"commandName\":\"Illuminate\\\\Mail\\\\SendQueuedMailable\",\"command\":\"O:34:\\\"Illuminate\\\\Mail\\\\SendQueuedMailable\\\":3:{s:8:\\\"mailable\\\";O:25:\\\"App\\\\Mail\\\\Fact_Electronica\\\":27:{s:11:\\\"informacion\\\";a:6:{s:12:\\\"ruta_logo_fa\\\";N;s:4:\\\"mail\\\";s:23:\\\"info@masquecontable.com\\\";s:18:\\\"name_quien_factura\\\";s:19:\\\"MICAELA AILIN CORIA\\\";s:7:\\\"cliente\\\";O:17:\\\"App\\\\Models\\\\Person\\\":27:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:7:\\\"persons\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:40743;s:7:\\\"user_id\\\";i:5117;s:11:\\\"field_name1\\\";s:19:\\\"PEREZ HEREDIA LUCIA\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-32386687-8\\\";s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-07-05 19:11:46\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-07-21 20:43:55\\\";s:11:\\\"activity_id\\\";i:1;s:7:\\\"address\\\";s:135:\\\"Direccion\\r\\nPERON, JUAN TTE.GRAL. 3460 Piso:4 Dpto:C\\r\\nCod. Postal\\r\\n1198\\r\\nProvincia\\r\\nCIUDAD AUTONOMA BUENOS AIRES\\r\\nTipo Domicilio\\r\\nFISCAL\\\";s:14:\\\"person_type_id\\\";i:1;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:40743;s:7:\\\"user_id\\\";i:5117;s:11:\\\"field_name1\\\";s:19:\\\"PEREZ HEREDIA LUCIA\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-32386687-8\\\";s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-07-05 19:11:46\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-07-21 20:43:55\\\";s:11:\\\"activity_id\\\";i:1;s:7:\\\"address\\\";s:135:\\\"Direccion\\r\\nPERON, JUAN TTE.GRAL. 3460 Piso:4 Dpto:C\\r\\nCod. Postal\\r\\n1198\\r\\nProvincia\\r\\nCIUDAD AUTONOMA BUENOS AIRES\\r\\nTipo Domicilio\\r\\nFISCAL\\\";s:14:\\\"person_type_id\\\";i:1;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}s:14:\\\"nombre_del_pdf\\\";s:28:\\\"Factura N\\u00b00004-00000021.pdf\\\";s:9:\\\"body_mail\\\";s:155:\\\"Estimado cliente, se env\\u00eda adjunta la factura de honorarios correspondientes al mes de Julio 2021.\\nMuchas gracias por seguir eligiendo nuestros servicios.\\\";}s:3:\\\"pdf\\\";O:26:\\\"Barryvdh\\\\Snappy\\\\PdfWrapper\\\":4:{s:9:\\\"\\u0000*\\u0000snappy\\\";O:35:\\\"Barryvdh\\\\Snappy\\\\IlluminateSnappyPdf\\\":10:{s:26:\\\"\\u0000*\\u0000optionsWithContentCheck\\\";a:4:{s:11:\\\"header-html\\\";s:4:\\\"html\\\";s:11:\\\"footer-html\\\";s:4:\\\"html\\\";s:5:\\\"cover\\\";s:4:\\\"html\\\";s:15:\\\"xsl-style-sheet\\\";s:3:\\\"xsl\\\";}s:36:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000binary\\\";s:76:\\\"\\/home\\/forge\\/taxes.com.ar\\/vendor\\/h4cc\\/wkhtmltopdf-amd64\\/bin\\/wkhtmltopdf-amd64\\\";s:37:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000options\\\";a:132:{s:7:\\\"collate\\\";N;s:10:\\\"no-collate\\\";N;s:10:\\\"cookie-jar\\\";N;s:6:\\\"copies\\\";i:1;s:3:\\\"dpi\\\";N;s:13:\\\"extended-help\\\";N;s:9:\\\"grayscale\\\";N;s:4:\\\"help\\\";N;s:7:\\\"htmldoc\\\";N;s:18:\\\"ignore-load-errors\\\";N;s:9:\\\"image-dpi\\\";N;s:13:\\\"image-quality\\\";N;s:7:\\\"license\\\";N;s:9:\\\"log-level\\\";N;s:10:\\\"lowquality\\\";b:1;s:7:\\\"manpage\\\";N;s:13:\\\"margin-bottom\\\";N;s:11:\\\"margin-left\\\";N;s:12:\\\"margin-right\\\";N;s:10:\\\"margin-top\\\";N;s:11:\\\"orientation\\\";N;s:11:\\\"page-height\\\";N;s:9:\\\"page-size\\\";s:2:\\\"a4\\\";s:10:\\\"page-width\\\";N;s:18:\\\"no-pdf-compression\\\";N;s:5:\\\"quiet\\\";N;s:20:\\\"read-args-from-stdin\\\";N;s:6:\\\"readme\\\";N;s:5:\\\"title\\\";N;s:11:\\\"use-xserver\\\";N;s:7:\\\"version\\\";N;s:20:\\\"dump-default-toc-xsl\\\";N;s:12:\\\"dump-outline\\\";N;s:7:\\\"outline\\\";N;s:10:\\\"no-outline\\\";N;s:13:\\\"outline-depth\\\";N;s:13:\\\"output-format\\\";N;s:5:\\\"allow\\\";N;s:10:\\\"background\\\";N;s:13:\\\"no-background\\\";N;s:16:\\\"bypass-proxy-for\\\";N;s:9:\\\"cache-dir\\\";N;s:20:\\\"checkbox-checked-svg\\\";N;s:12:\\\"checkbox-svg\\\";N;s:6:\\\"cookie\\\";N;s:13:\\\"custom-header\\\";N;s:25:\\\"custom-header-propagation\\\";N;s:28:\\\"no-custom-header-propagation\\\";N;s:16:\\\"debug-javascript\\\";N;s:19:\\\"no-debug-javascript\\\";N;s:14:\\\"default-header\\\";N;s:8:\\\"encoding\\\";N;s:22:\\\"disable-external-links\\\";N;s:21:\\\"enable-external-links\\\";N;s:13:\\\"disable-forms\\\";N;s:12:\\\"enable-forms\\\";N;s:6:\\\"images\\\";N;s:9:\\\"no-images\\\";N;s:22:\\\"disable-internal-links\\\";N;s:21:\\\"enable-internal-links\\\";N;s:18:\\\"disable-javascript\\\";N;s:17:\\\"enable-javascript\\\";N;s:16:\\\"javascript-delay\\\";N;s:19:\\\"keep-relative-links\\\";N;s:19:\\\"load-error-handling\\\";N;s:25:\\\"load-media-error-handling\\\";N;s:25:\\\"disable-local-file-access\\\";N;s:24:\\\"enable-local-file-access\\\";N;s:17:\\\"minimum-font-size\\\";N;s:20:\\\"exclude-from-outline\\\";N;s:18:\\\"include-in-outline\\\";N;s:11:\\\"page-offset\\\";N;s:8:\\\"password\\\";N;s:15:\\\"disable-plugins\\\";N;s:14:\\\"enable-plugins\\\";N;s:4:\\\"post\\\";N;s:9:\\\"post-file\\\";N;s:16:\\\"print-media-type\\\";N;s:19:\\\"no-print-media-type\\\";N;s:5:\\\"proxy\\\";N;s:21:\\\"proxy-hostname-lookup\\\";N;s:23:\\\"radiobutton-checked-svg\\\";N;s:15:\\\"radiobutton-svg\\\";N;s:14:\\\"redirect-delay\\\";N;s:22:\\\"resolve-relative-links\\\";N;s:10:\\\"run-script\\\";N;s:23:\\\"disable-smart-shrinking\\\";N;s:22:\\\"enable-smart-shrinking\\\";N;s:12:\\\"ssl-crt-path\\\";N;s:16:\\\"ssl-key-password\\\";N;s:12:\\\"ssl-key-path\\\";N;s:17:\\\"stop-slow-scripts\\\";N;s:20:\\\"no-stop-slow-scripts\\\";N;s:22:\\\"disable-toc-back-links\\\";N;s:21:\\\"enable-toc-back-links\\\";N;s:16:\\\"user-style-sheet\\\";N;s:8:\\\"username\\\";N;s:13:\\\"viewport-size\\\";N;s:13:\\\"window-status\\\";N;s:4:\\\"zoom\\\";N;s:13:\\\"footer-center\\\";s:25:\\\"Pagina [page] de [toPage]\\\";s:16:\\\"footer-font-name\\\";N;s:16:\\\"footer-font-size\\\";i:8;s:11:\\\"footer-html\\\";N;s:11:\\\"footer-left\\\";s:0:\\\"\\\";s:11:\\\"footer-line\\\";N;s:14:\\\"no-footer-line\\\";N;s:12:\\\"footer-right\\\";N;s:14:\\\"footer-spacing\\\";N;s:13:\\\"header-center\\\";N;s:16:\\\"header-font-name\\\";N;s:16:\\\"header-font-size\\\";N;s:11:\\\"header-html\\\";N;s:11:\\\"header-left\\\";N;s:11:\\\"header-line\\\";N;s:14:\\\"no-header-line\\\";N;s:12:\\\"header-right\\\";N;s:14:\\\"header-spacing\\\";N;s:7:\\\"replace\\\";N;s:5:\\\"cover\\\";N;s:3:\\\"toc\\\";N;s:20:\\\"disable-dotted-lines\\\";N;s:9:\\\"toc-depth\\\";N;s:13:\\\"toc-font-name\\\";N;s:16:\\\"toc-l1-font-size\\\";N;s:15:\\\"toc-header-text\\\";N;s:20:\\\"toc-header-font-name\\\";N;s:20:\\\"toc-header-font-size\\\";N;s:21:\\\"toc-level-indentation\\\";N;s:17:\\\"disable-toc-links\\\";N;s:20:\\\"toc-text-size-shrink\\\";N;s:15:\\\"xsl-style-sheet\\\";N;}s:33:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000env\\\";N;s:37:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000timeout\\\";b:0;s:46:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000defaultExtension\\\";s:3:\\\"pdf\\\";s:18:\\\"\\u0000*\\u0000temporaryFolder\\\";N;s:14:\\\"temporaryFiles\\\";a:0:{}s:36:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000logger\\\";O:18:\\\"Psr\\\\Log\\\\NullLogger\\\":0:{}s:2:\\\"fs\\\";O:32:\\\"Illuminate\\\\Filesystem\\\\Filesystem\\\":0:{}}s:10:\\\"\\u0000*\\u0000options\\\";a:0:{}s:4:\\\"html\\\";s:22817:\\\"<!DOCTYPE html>\\n<html lang=\\\"en\\\">\\n    <head>\\n        <meta charset=\\\"utf-8\\\">\\n    <\\/head>\\n    <style>\\n        .subtotales_conceptos{\\n            width:30%;\\n            text-align: right;\\n        }\\n        .subtotales_importes{\\n            text-align: right;\\n        }\\n        .table-totales, .table-totales tr, .table-totales th{\\n            border: 1px solid;\\n        }\\n\\n    <\\/style>\\n    <body>\\n    <div style=\\\"max-height:840px\\\">\\n        <div style=\\\"width: 100%; height:270px\\\"> <!-- Datos de la empresa -->\\n            <table class=\\\"display\\\" cellspacing=\\\"0\\\" width=\\\"100%\\\" style=\\\"border:  1px solid;\\\">\\n                <tr style=\\\"\\\">\\n                    <th colspan=\\\"2\\\" rowspan=\\\"2\\\" style=\\\"width:45%;margin:0;height:150px;\\\">\\n                                                <img src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/img\\/\\/27377183504\\/logo_punto_venta_0000.png\\\"\\/>\\n                                            <\\/th>\\n                    <th style=\\\"border:  1px solid;text-align: center; width:10%\\\" colspan=\\\"2\\\">\\n                        <span style=\\\"font-size: 60px;\\\">C<\\/span> <br \\/> <span style=\\\"font-size: 14px;\\\">cod. 11<\\/span>\\n                    <\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"font-size: 28px;text-align: center;width:45%\\\">\\n                        Factura\\n                        <br>\\n                        0004 - 00000021\\n                    <\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th><\\/th>\\n                    <th style=\\\"border:  1px 1px 1px 0px solid;\\\" colspan=\\\"2\\\"><\\/th>\\n                    <th><\\/th>\\n                <\\/tr>\\n                <tr>\\n\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                                                    Raz&oacute;n Social:\\n                            <span style=\\\"font-weight: normal;\\\">MICAELA AILIN CORIA<\\/span>\\n                                            <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">Fecha de Emisi&oacute;n: <span style=\\\"font-weight: normal;\\\">15\\/07\\/2021<\\/span><\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Domicilio Comercial: <span style=\\\"font-weight: normal;\\\">Victor Guillet esq. Arturo M Bas, C.P.:5800,\\n                        C\\u00f3rdoba<\\/span>\\n                    <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">CUIT: <span style=\\\"font-weight: normal;\\\">27-37718350-4<\\/span><\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Condici&oacute;n frente al IVA: <span style=\\\"font-weight: normal;\\\">Monotributo<\\/span>\\n                    <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Ingresos Brutos: <span style=\\\"font-weight: normal;\\\"><\\/span>\\n                        <br>\\n                        Fecha de Inicio de Actividades: <span style=\\\"font-weight: normal;\\\">09\\/07\\/2021<\\/span>\\n                    <\\/th>\\n                <\\/tr>\\n            <\\/table>\\n        <\\/div>\\n\\n        <table style=\\\"text-align: center; width: 100%;border: solid 1px;\\\"> <!-- Fechas -->\\n            <thead>\\n                <tr>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Per\\u00edodo Facturado Desde: 01\\/07\\/2021<\\/small><\\/th>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Per\\u00edodo Facturado Hasta: 31\\/07\\/2021<\\/small><\\/th>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Fecha Vto. Pago: 15\\/07\\/2021<\\/small><\\/th>\\n                <\\/tr>\\n            <\\/thead>\\n        <\\/table>\\n        \\n        <table style=\\\"width: 100%; margin-top: 1%;border: solid 1px;\\\"> <!-- Datos Clientes -->\\n            <tr>\\n                <th style=\\\"text-align:left;\\\"colspan=\\\"12\\\">\\n                    CUIT: <span style=\\\"font-weight: normal;\\\">27-32386687-8<\\/span>\\n                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\\n                    Apellido y Nombre \\/ Raz&oacute;n Social: <span style=\\\"font-weight: normal;\\\">\\n                    PEREZ HEREDIA LUCIA<\\/span>\\n                <\\/th>\\n            <\\/tr>\\n            <tr>\\n                <th style=\\\"text-align:left; width:50%\\\">\\n                    Condici&oacute;n Frente al IVA: <span style=\\\"font-weight: normal;\\\">Responsable Monotributo<\\/span>\\n                <\\/th>\\n                <th style=\\\"text-align:left; width:50%\\\" colspan=\\\"4\\\">\\n                    Domicilio Comercial:\\n                    <span style=\\\"font-weight: normal;\\\">\\n                    Direccion\\r\\nPERON, JUAN TTE.GRAL. 3460 Piso:4 Dpto:C\\r\\nCod. Postal\\r\\n1198\\r\\nProvincia\\r\\nCIUDAD AUTONOMA BUENOS AIRES\\r\\nTipo Domicilio\\r\\nFISCAL\\n                    <\\/span>\\n                <\\/th>\\n            <\\/tr>\\n            <tr style=\\\"text-align:left\\\">\\n                <th>Condici&oacute;n de Venta: <span style=\\\"font-weight: normal;\\\">Cuenta Corriente<\\/span><\\/th>\\n            <\\/tr>\\n        <\\/table>\\n\\n        <div style=\\\"border: 1px solid;margin-top: 1%;min-height:600px;\\\">\\n        <table style=\\\"text-align: center; width: 100%; margin-top: 1%;\\\"> <!-- Body -->\\n            <tr style=\\\"border-bottom: 1px solid;font-size: 15px\\\">\\n                <th>C&oacute;digo<\\/th>\\n                <th style=\\\"width: 25%;\\\">Detalle<\\/th>\\n                <th>Cantidad<\\/th>\\n                <th>U.Medida<\\/th>\\n                <th>Precio U.<\\/th>\\n                <th>Bonif. (%)<\\/th>\\n                <th>Precio Bonif.<\\/th>\\n                <th>Subtotal<\\/th>\\n                            <\\/tr>\\n            <tbody>\\n                                                                                <tr style=\\\"font-size: 12px;\\\">\\n                        <td>\\n                            \\n                        <\\/td>\\n                        <td>\\n                            Honorarios profesionales Julio 2021\\n                        <\\/td>\\n                        <td>\\n                            1.00\\n                        <\\/td>\\n                        <td>\\n                            Unidades\\n                        <\\/td>\\n                        <td>                            2.950,00\\n                                                    <\\/td>\\n                        <td>\\n                            0,00%\\n                        <\\/td>\\n                        <td>\\n                            0,00\\n                        <\\/td>\\n                        <td>\\n                            2.950,00\\n                        <\\/td>\\n                                            <\\/tr>\\n                    \\n            <\\/tbody>\\n        <\\/table>\\n        <\\/div>\\n\\n        \\n\\n        <div style=\\\"height:200px;margin-top: 1%;\\\"> <!-- Totales -->\\n              <!-- Es factura B o C -->\\n                <table class=\\\"table-totales\\\" cellspacing=\\\"0\\\" width=\\\"100%\\\">\\n                    <tr>\\n                        <th style=\\\"width:50%; text-align:left;\\\">\\n\\n<!--                                <span style=\\\"width:100%;\\\"><img src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/barcodes\\/71304902491456.png\\\"><\\/span>\\n                                <span style=\\\"text-align:center;\\\">2737718350411000471304902491456202107253<\\/span>-->\\n                        <\\/th>\\n                        <th class=\\\"subtotales_conceptos\\\">TOTAL:<\\/th>\\n                        <th class=\\\"subtotales_importes\\\">$ 2.950,00<\\/th>\\n                    <\\/tr>\\n                <\\/table>\\n                <br>\\n                <table cellspacing=\\\"0\\\" width=\\\"100%\\\" style=\\\"border: none\\\">\\n                    <tr>\\n                        <th style=\\\"width:50%; text-align:left;\\\">\\n\\n                            <?xml version=\\\"1.0\\\" encoding=\\\"UTF-8\\\"?>\\n<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" version=\\\"1.1\\\" width=\\\"100\\\" height=\\\"100\\\" viewBox=\\\"0 0 100 100\\\"><rect x=\\\"0\\\" y=\\\"0\\\" width=\\\"100\\\" height=\\\"100\\\" fill=\\\"#ffffff\\\"\\/><g transform=\\\"scale(1.754)\\\"><g transform=\\\"translate(0,0)\\\"><path fill-rule=\\\"evenodd\\\" d=\\\"M9 0L9 1L8 1L8 2L9 2L9 3L8 3L8 4L9 4L9 3L10 3L10 5L8 5L8 7L9 7L9 6L10 6L10 7L11 7L11 5L12 5L12 9L11 9L11 8L6 8L6 9L8 9L8 11L9 11L9 10L10 10L10 12L12 12L12 15L13 15L13 14L14 14L14 13L13 13L13 12L14 12L14 11L13 11L13 8L15 8L15 9L14 9L14 10L15 10L15 9L19 9L19 10L20 10L20 11L19 11L19 13L18 13L18 12L15 12L15 15L14 15L14 16L15 16L15 15L16 15L16 17L17 17L17 15L16 15L16 13L18 13L18 15L19 15L19 13L22 13L22 14L21 14L21 15L22 15L22 14L23 14L23 17L22 17L22 16L18 16L18 17L21 17L21 20L19 20L19 19L20 19L20 18L18 18L18 21L17 21L17 24L16 24L16 23L15 23L15 22L16 22L16 21L15 21L15 20L17 20L17 19L15 19L15 17L13 17L13 16L11 16L11 15L10 15L10 14L9 14L9 15L10 15L10 16L9 16L9 17L12 17L12 18L13 18L13 19L14 19L14 20L13 20L13 21L12 21L12 19L10 19L10 21L9 21L9 22L8 22L8 20L9 20L9 19L7 19L7 18L6 18L6 17L8 17L8 15L7 15L7 14L6 14L6 13L8 13L8 12L6 12L6 11L7 11L7 10L5 10L5 12L3 12L3 15L4 15L4 16L6 16L6 17L5 17L5 18L6 18L6 19L7 19L7 20L6 20L6 21L4 21L4 20L5 20L5 19L4 19L4 17L3 17L3 19L4 19L4 20L2 20L2 17L1 17L1 16L0 16L0 19L1 19L1 20L0 20L0 26L1 26L1 27L0 27L0 29L1 29L1 27L2 27L2 29L3 29L3 28L4 28L4 30L3 30L3 32L2 32L2 31L1 31L1 32L0 32L0 34L3 34L3 35L5 35L5 36L1 36L1 35L0 35L0 38L1 38L1 37L2 37L2 38L3 38L3 37L4 37L4 38L6 38L6 39L4 39L4 40L3 40L3 39L0 39L0 41L2 41L2 42L1 42L1 43L0 43L0 44L1 44L1 45L3 45L3 46L2 46L2 47L1 47L1 46L0 46L0 48L5 48L5 47L8 47L8 46L6 46L6 45L9 45L9 44L10 44L10 45L12 45L12 46L13 46L13 45L12 45L12 44L11 44L11 43L10 43L10 42L11 42L11 41L12 41L12 40L13 40L13 43L14 43L14 44L15 44L15 46L14 46L14 49L13 49L13 48L12 48L12 47L11 47L11 49L13 49L13 50L10 50L10 47L9 47L9 48L6 48L6 49L8 49L8 51L10 51L10 52L8 52L8 57L11 57L11 56L12 56L12 57L13 57L13 56L12 56L12 55L13 55L13 53L14 53L14 54L16 54L16 53L15 53L15 52L16 52L16 51L17 51L17 50L16 50L16 51L15 51L15 52L13 52L13 50L15 50L15 48L16 48L16 49L19 49L19 48L16 48L16 47L15 47L15 46L16 46L16 45L18 45L18 47L19 47L19 45L22 45L22 46L21 46L21 48L20 48L20 49L22 49L22 50L18 50L18 51L19 51L19 52L18 52L18 53L17 53L17 56L16 56L16 55L15 55L15 57L19 57L19 56L20 56L20 57L22 57L22 54L23 54L23 55L25 55L25 56L23 56L23 57L26 57L26 56L27 56L27 55L25 55L25 53L26 53L26 54L29 54L29 53L30 53L30 54L31 54L31 52L33 52L33 53L32 53L32 54L33 54L33 55L35 55L35 54L34 54L34 53L35 53L35 51L37 51L37 52L36 52L36 53L37 53L37 54L36 54L36 56L35 56L35 57L37 57L37 55L38 55L38 51L40 51L40 52L41 52L41 54L44 54L44 56L45 56L45 57L46 57L46 56L47 56L47 57L52 57L52 55L51 55L51 54L50 54L50 55L51 55L51 56L47 56L47 54L48 54L48 55L49 55L49 54L48 54L48 53L52 53L52 54L53 54L53 55L54 55L54 56L53 56L53 57L54 57L54 56L55 56L55 57L56 57L56 56L55 56L55 55L54 55L54 54L55 54L55 53L54 53L54 54L53 54L53 52L55 52L55 50L57 50L57 48L56 48L56 46L57 46L57 43L56 43L56 46L54 46L54 44L55 44L55 41L54 41L54 40L56 40L56 39L55 39L55 38L54 38L54 36L55 36L55 35L53 35L53 34L52 34L52 33L53 33L53 32L52 32L52 33L50 33L50 34L52 34L52 35L47 35L47 34L48 34L48 33L47 33L47 34L46 34L46 32L45 32L45 31L47 31L47 32L48 32L48 31L49 31L49 32L51 32L51 31L54 31L54 32L55 32L55 33L54 33L54 34L55 34L55 33L56 33L56 34L57 34L57 32L56 32L56 30L57 30L57 29L54 29L54 28L55 28L55 26L57 26L57 25L56 25L56 24L57 24L57 23L56 23L56 22L57 22L57 21L56 21L56 22L55 22L55 21L54 21L54 20L55 20L55 19L54 19L54 16L55 16L55 15L56 15L56 14L57 14L57 13L56 13L56 14L55 14L55 13L54 13L54 12L55 12L55 10L57 10L57 9L56 9L56 8L55 8L55 10L54 10L54 11L51 11L51 10L49 10L49 9L50 9L50 8L49 8L49 6L48 6L48 8L49 8L49 9L48 9L48 12L49 12L49 11L50 11L50 13L51 13L51 14L50 14L50 16L51 16L51 17L52 17L52 18L49 18L49 17L48 17L48 18L46 18L46 17L45 17L45 18L46 18L46 20L45 20L45 19L44 19L44 20L43 20L43 21L42 21L42 19L43 19L43 17L44 17L44 16L45 16L45 15L46 15L46 16L49 16L49 15L48 15L48 14L49 14L49 13L48 13L48 14L45 14L45 13L47 13L47 10L46 10L46 9L45 9L45 10L44 10L44 8L45 8L45 6L46 6L46 8L47 8L47 5L48 5L48 0L45 0L45 2L44 2L44 1L43 1L43 0L39 0L39 1L36 1L36 2L35 2L35 1L34 1L34 2L32 2L32 3L33 3L33 4L37 4L37 3L36 3L36 2L38 2L38 4L39 4L39 5L38 5L38 7L37 7L37 5L36 5L36 7L37 7L37 8L36 8L36 10L33 10L33 11L32 11L32 10L31 10L31 6L32 6L32 8L33 8L33 9L35 9L35 8L34 8L34 7L35 7L35 5L31 5L31 3L30 3L30 2L29 2L29 0L28 0L28 2L27 2L27 3L25 3L25 2L24 2L24 3L23 3L23 4L22 4L22 1L23 1L23 0L22 0L22 1L21 1L21 6L20 6L20 5L18 5L18 4L19 4L19 3L20 3L20 1L18 1L18 4L16 4L16 3L15 3L15 2L16 2L16 0L14 0L14 1L15 1L15 2L14 2L14 3L13 3L13 4L11 4L11 2L10 2L10 0ZM11 0L11 1L13 1L13 0ZM24 0L24 1L26 1L26 0ZM30 0L30 1L31 1L31 0ZM40 1L40 2L42 2L42 3L44 3L44 4L45 4L45 5L44 5L44 6L43 6L43 5L39 5L39 7L38 7L38 8L37 8L37 10L36 10L36 11L33 11L33 12L32 12L32 11L31 11L31 10L30 10L30 9L28 9L28 10L27 10L27 9L25 9L25 8L22 8L22 9L20 9L20 10L22 10L22 9L23 9L23 10L24 10L24 11L21 11L21 12L22 12L22 13L23 13L23 12L24 12L24 13L25 13L25 15L24 15L24 17L23 17L23 18L22 18L22 19L23 19L23 20L22 20L22 21L20 21L20 22L19 22L19 21L18 21L18 24L19 24L19 25L20 25L20 26L19 26L19 28L22 28L22 29L19 29L19 30L18 30L18 31L16 31L16 32L17 32L17 33L15 33L15 31L13 31L13 30L11 30L11 31L10 31L10 30L9 30L9 32L8 32L8 31L6 31L6 32L5 32L5 31L4 31L4 32L5 32L5 33L6 33L6 34L5 34L5 35L6 35L6 36L7 36L7 35L8 35L8 37L6 37L6 38L8 38L8 37L9 37L9 39L6 39L6 40L5 40L5 41L3 41L3 40L2 40L2 41L3 41L3 42L2 42L2 44L3 44L3 45L4 45L4 46L3 46L3 47L5 47L5 45L4 45L4 44L5 44L5 41L6 41L6 42L7 42L7 43L6 43L6 44L7 44L7 43L9 43L9 42L10 42L10 41L11 41L11 40L10 40L10 41L9 41L9 42L7 42L7 41L8 41L8 40L9 40L9 39L10 39L10 37L9 37L9 35L10 35L10 36L11 36L11 37L13 37L13 38L11 38L11 39L13 39L13 38L14 38L14 37L15 37L15 38L16 38L16 37L18 37L18 38L19 38L19 39L20 39L20 40L19 40L19 41L17 41L17 40L18 40L18 39L17 39L17 40L16 40L16 39L14 39L14 40L15 40L15 41L14 41L14 42L15 42L15 43L16 43L16 44L18 44L18 45L19 45L19 43L22 43L22 45L24 45L24 43L25 43L25 42L26 42L26 43L30 43L30 44L31 44L31 47L29 47L29 46L30 46L30 45L28 45L28 44L26 44L26 45L25 45L25 46L24 46L24 49L23 49L23 46L22 46L22 49L23 49L23 50L22 50L22 51L23 51L23 52L22 52L22 53L18 53L18 56L19 56L19 54L20 54L20 56L21 56L21 54L22 54L22 53L23 53L23 54L24 54L24 53L25 53L25 52L26 52L26 50L24 50L24 49L26 49L26 48L27 48L27 47L28 47L28 48L32 48L32 49L33 49L33 50L36 50L36 48L37 48L37 50L40 50L40 51L43 51L43 50L45 50L45 48L44 48L44 47L45 47L45 46L47 46L47 47L46 47L46 48L47 48L47 49L46 49L46 50L47 50L47 49L48 49L48 48L49 48L49 47L52 47L52 48L54 48L54 49L56 49L56 48L54 48L54 47L52 47L52 46L53 46L53 45L52 45L52 44L53 44L53 43L54 43L54 42L53 42L53 41L52 41L52 42L50 42L50 43L51 43L51 45L50 45L50 44L47 44L47 43L45 43L45 42L44 42L44 41L45 41L45 40L44 40L44 41L43 41L43 40L42 40L42 39L46 39L46 40L47 40L47 41L46 41L46 42L48 42L48 43L49 43L49 42L48 42L48 41L49 41L49 40L47 40L47 39L46 39L46 38L48 38L48 39L51 39L51 38L50 38L50 37L52 37L52 38L53 38L53 37L52 37L52 36L53 36L53 35L52 35L52 36L50 36L50 37L49 37L49 38L48 38L48 36L47 36L47 35L46 35L46 38L45 38L45 36L44 36L44 35L45 35L45 34L44 34L44 33L45 33L45 32L44 32L44 33L43 33L43 32L40 32L40 31L43 31L43 30L48 30L48 29L47 29L47 28L48 28L48 27L46 27L46 28L44 28L44 27L45 27L45 24L44 24L44 23L43 23L43 22L44 22L44 21L45 21L45 20L44 20L44 21L43 21L43 22L41 22L41 23L42 23L42 25L43 25L43 26L44 26L44 27L43 27L43 28L42 28L42 26L41 26L41 24L40 24L40 21L41 21L41 20L39 20L39 19L37 19L37 18L39 18L39 15L38 15L38 14L39 14L39 12L40 12L40 13L41 13L41 12L40 12L40 11L42 11L42 13L43 13L43 14L40 14L40 15L42 15L42 17L43 17L43 15L45 15L45 14L44 14L44 13L45 13L45 12L46 12L46 10L45 10L45 12L44 12L44 10L41 10L41 9L42 9L42 6L43 6L43 7L44 7L44 6L45 6L45 5L47 5L47 3L46 3L46 4L45 4L45 3L44 3L44 2L43 2L43 1ZM46 1L46 2L47 2L47 1ZM34 2L34 3L35 3L35 2ZM14 3L14 4L13 4L13 7L14 7L14 6L15 6L15 8L16 8L16 6L15 6L15 5L16 5L16 4L15 4L15 3ZM24 3L24 4L23 4L23 5L22 5L22 6L21 6L21 7L22 7L22 6L23 6L23 7L24 7L24 4L25 4L25 7L26 7L26 4L25 4L25 3ZM28 3L28 4L30 4L30 3ZM39 3L39 4L41 4L41 3ZM14 4L14 5L15 5L15 4ZM17 5L17 8L19 8L19 7L20 7L20 6L19 6L19 7L18 7L18 5ZM27 5L27 8L30 8L30 5ZM28 6L28 7L29 7L29 6ZM33 6L33 7L34 7L34 6ZM40 6L40 8L41 8L41 6ZM0 8L0 9L5 9L5 8ZM51 8L51 9L52 9L52 10L53 10L53 9L54 9L54 8L53 8L53 9L52 9L52 8ZM24 9L24 10L25 10L25 11L24 11L24 12L25 12L25 11L26 11L26 10L25 10L25 9ZM0 10L0 11L1 11L1 12L0 12L0 14L1 14L1 15L2 15L2 14L1 14L1 13L2 13L2 11L4 11L4 10L2 10L2 11L1 11L1 10ZM11 10L11 11L12 11L12 10ZM17 10L17 11L18 11L18 10ZM28 10L28 11L27 11L27 12L26 12L26 13L27 13L27 14L26 14L26 15L25 15L25 16L26 16L26 17L24 17L24 20L23 20L23 21L22 21L22 22L20 22L20 23L21 23L21 24L20 24L20 25L22 25L22 26L20 26L20 27L22 27L22 26L23 26L23 28L25 28L25 27L26 27L26 30L25 30L25 29L22 29L22 31L24 31L24 32L23 32L23 33L22 33L22 32L19 32L19 31L18 31L18 33L22 33L22 34L21 34L21 35L20 35L20 34L18 34L18 37L19 37L19 36L20 36L20 37L21 37L21 38L20 38L20 39L21 39L21 40L20 40L20 41L22 41L22 42L25 42L25 41L22 41L22 39L23 39L23 37L24 37L24 40L25 40L25 39L27 39L27 38L28 38L28 39L31 39L31 42L30 42L30 43L31 43L31 44L33 44L33 45L32 45L32 46L33 46L33 49L34 49L34 47L35 47L35 46L36 46L36 47L39 47L39 49L40 49L40 48L42 48L42 49L41 49L41 50L43 50L43 47L39 47L39 46L40 46L40 45L39 45L39 46L38 46L38 44L36 44L36 45L35 45L35 44L34 44L34 43L37 43L37 40L36 40L36 41L35 41L35 39L36 39L36 37L37 37L37 38L38 38L38 37L37 37L37 36L36 36L36 35L39 35L39 39L38 39L38 41L39 41L39 42L38 42L38 43L39 43L39 44L42 44L42 43L39 43L39 42L40 42L40 41L39 41L39 40L40 40L40 38L43 38L43 37L40 37L40 36L42 36L42 34L43 34L43 33L40 33L40 32L39 32L39 34L36 34L36 35L35 35L35 34L34 34L34 35L35 35L35 38L34 38L34 41L35 41L35 42L33 42L33 43L31 43L31 42L32 42L32 40L33 40L33 37L34 37L34 36L33 36L33 35L31 35L31 34L33 34L33 33L32 33L32 32L35 32L35 30L34 30L34 31L33 31L33 29L32 29L32 32L31 32L31 34L30 34L30 35L31 35L31 36L28 36L28 35L29 35L29 34L28 34L28 35L27 35L27 34L25 34L25 33L29 33L29 32L30 32L30 31L31 31L31 28L33 28L33 27L35 27L35 26L33 26L33 27L32 27L32 24L34 24L34 25L35 25L35 24L34 24L34 23L35 23L35 22L36 22L36 21L37 21L37 23L38 23L38 21L39 21L39 20L38 20L38 21L37 21L37 20L36 20L36 21L35 21L35 20L34 20L34 19L36 19L36 18L37 18L37 16L36 16L36 18L32 18L32 16L33 16L33 17L34 17L34 16L33 16L33 15L36 15L36 14L37 14L37 13L38 13L38 11L39 11L39 10L38 10L38 11L37 11L37 12L36 12L36 14L33 14L33 15L30 15L30 14L32 14L32 13L30 13L30 14L28 14L28 13L27 13L27 12L29 12L29 10ZM30 11L30 12L31 12L31 11ZM56 11L56 12L57 12L57 11ZM5 12L5 13L4 13L4 14L5 14L5 13L6 13L6 12ZM33 12L33 13L35 13L35 12ZM43 12L43 13L44 13L44 12ZM52 12L52 13L53 13L53 16L52 16L52 15L51 15L51 16L52 16L52 17L53 17L53 16L54 16L54 15L55 15L55 14L54 14L54 13L53 13L53 12ZM6 15L6 16L7 16L7 15ZM26 15L26 16L28 16L28 17L26 17L26 18L25 18L25 19L26 19L26 20L24 20L24 21L23 21L23 24L22 24L22 25L25 25L25 26L29 26L29 25L31 25L31 24L30 24L30 23L34 23L34 22L35 22L35 21L34 21L34 20L32 20L32 19L31 19L31 18L29 18L29 17L31 17L31 16L30 16L30 15L29 15L29 16L28 16L28 15ZM40 16L40 17L41 17L41 16ZM55 17L55 18L57 18L57 17ZM27 18L27 20L26 20L26 21L27 21L27 24L25 24L25 23L24 23L24 24L25 24L25 25L28 25L28 24L29 24L29 23L30 23L30 22L32 22L32 21L30 21L30 22L29 22L29 23L28 23L28 21L27 21L27 20L29 20L29 19L28 19L28 18ZM48 18L48 19L49 19L49 18ZM52 18L52 19L51 19L51 20L52 20L52 21L53 21L53 20L52 20L52 19L53 19L53 18ZM30 19L30 20L31 20L31 19ZM56 19L56 20L57 20L57 19ZM1 20L1 24L2 24L2 25L3 25L3 24L4 24L4 26L3 26L3 27L4 27L4 26L5 26L5 24L8 24L8 25L6 25L6 26L9 26L9 29L12 29L12 28L11 28L11 27L10 27L10 24L11 24L11 26L12 26L12 21L10 21L10 22L9 22L9 24L8 24L8 23L6 23L6 22L7 22L7 21L6 21L6 22L5 22L5 24L4 24L4 23L2 23L2 20ZM48 20L48 21L46 21L46 22L45 22L45 23L46 23L46 22L48 22L48 21L49 21L49 24L48 24L48 25L47 25L47 24L46 24L46 26L48 26L48 25L49 25L49 26L52 26L52 25L55 25L55 24L56 24L56 23L55 23L55 22L54 22L54 23L53 23L53 22L52 22L52 23L50 23L50 22L51 22L51 21L49 21L49 20ZM3 21L3 22L4 22L4 21ZM13 21L13 24L15 24L15 23L14 23L14 22L15 22L15 21ZM24 21L24 22L25 22L25 21ZM52 23L52 24L51 24L51 25L52 25L52 24L53 24L53 23ZM54 23L54 24L55 24L55 23ZM36 24L36 25L37 25L37 24ZM38 24L38 25L39 25L39 24ZM43 24L43 25L44 25L44 24ZM49 24L49 25L50 25L50 24ZM15 25L15 26L17 26L17 27L16 27L16 28L17 28L17 29L16 29L16 30L17 30L17 29L18 29L18 28L17 28L17 27L18 27L18 25ZM13 26L13 27L14 27L14 26ZM36 26L36 27L37 27L37 28L36 28L36 29L37 29L37 30L36 30L36 31L40 31L40 30L38 30L38 29L40 29L40 28L41 28L41 27L40 27L40 26ZM53 26L53 27L54 27L54 26ZM5 27L5 30L8 30L8 27ZM27 27L27 30L30 30L30 27ZM49 27L49 30L52 30L52 27ZM56 27L56 28L57 28L57 27ZM6 28L6 29L7 29L7 28ZM13 28L13 29L14 29L14 30L15 30L15 28ZM28 28L28 29L29 29L29 28ZM50 28L50 29L51 29L51 28ZM42 29L42 30L43 30L43 29ZM24 30L24 31L25 31L25 30ZM54 30L54 31L55 31L55 30ZM12 31L12 32L10 32L10 33L12 33L12 34L10 34L10 35L12 35L12 36L13 36L13 37L14 37L14 36L15 36L15 37L16 37L16 36L15 36L15 35L14 35L14 34L13 34L13 31ZM28 31L28 32L29 32L29 31ZM6 32L6 33L7 33L7 34L6 34L6 35L7 35L7 34L8 34L8 35L9 35L9 33L7 33L7 32ZM24 32L24 33L23 33L23 36L22 36L22 37L23 37L23 36L24 36L24 37L25 37L25 38L26 38L26 37L25 37L25 36L24 36L24 35L25 35L25 34L24 34L24 33L25 33L25 32ZM36 32L36 33L37 33L37 32ZM40 34L40 35L41 35L41 34ZM56 35L56 37L57 37L57 35ZM27 36L27 37L28 37L28 38L31 38L31 39L32 39L32 37L33 37L33 36L31 36L31 37L28 37L28 36ZM52 39L52 40L54 40L54 39ZM6 40L6 41L7 41L7 40ZM26 40L26 41L27 41L27 40ZM28 40L28 41L29 41L29 40ZM41 40L41 42L43 42L43 41L42 41L42 40ZM56 41L56 42L57 42L57 41ZM16 42L16 43L18 43L18 42ZM44 43L44 44L45 44L45 45L44 45L44 46L45 46L45 45L47 45L47 46L49 46L49 45L47 45L47 44L45 44L45 43ZM27 45L27 46L28 46L28 45ZM34 45L34 46L35 46L35 45ZM36 45L36 46L37 46L37 45ZM41 45L41 46L43 46L43 45ZM51 45L51 46L52 46L52 45ZM25 46L25 47L26 47L26 46ZM47 47L47 48L48 48L48 47ZM27 49L27 52L30 52L30 49ZM49 49L49 52L52 52L52 49ZM28 50L28 51L29 51L29 50ZM50 50L50 51L51 51L51 50ZM53 50L53 51L54 51L54 50ZM11 51L11 52L12 52L12 53L11 53L11 55L10 55L10 56L11 56L11 55L12 55L12 53L13 53L13 52L12 52L12 51ZM20 51L20 52L21 52L21 51ZM24 51L24 52L23 52L23 53L24 53L24 52L25 52L25 51ZM46 51L46 54L47 54L47 53L48 53L48 52L47 52L47 51ZM56 51L56 52L57 52L57 51ZM44 52L44 54L45 54L45 52ZM39 54L39 56L38 56L38 57L39 57L39 56L41 56L41 57L42 57L42 55L40 55L40 54ZM30 55L30 56L29 56L29 57L30 57L30 56L31 56L31 57L32 57L32 56L31 56L31 55ZM45 55L45 56L46 56L46 55ZM33 56L33 57L34 57L34 56ZM0 0L0 7L7 7L7 0ZM1 1L1 6L6 6L6 1ZM2 2L2 5L5 5L5 2ZM50 0L50 7L57 7L57 0ZM51 1L51 6L56 6L56 1ZM52 2L52 5L55 5L55 2ZM0 50L0 57L7 57L7 50ZM1 51L1 56L6 56L6 51ZM2 52L2 55L5 55L5 52Z\\\" fill=\\\"#000000\\\"\\/><\\/g><\\/g><\\/svg>\\n\\n                            <span style=\\\"width:50%;\\\">\\n                                <img style=\\\"max-height: 70px\\\"\\n                                     src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/img\\/AfipComprobanteAutorizado.png\\\">\\n                            <\\/span>\\n                        <\\/th>\\n                        <th style=\\\"text-align:right;\\\">\\n                            <p>CAE N&#186;: 71304902491456<br>\\n                                Fecha Vto. CAE:  25\\/07\\/2021\\n                            <\\/p>\\n                        <\\/th>\\n                    <\\/tr>\\n                <\\/table>\\n                    <\\/div>\\n    <\\/div>\\n\\n    <\\/body>\\n<\\/html>\\\";s:4:\\\"file\\\";N;}s:6:\\\"locale\\\";N;s:4:\\\"from\\\";a:0:{}s:2:\\\"to\\\";a:1:{i:0;a:2:{s:4:\\\"name\\\";N;s:7:\\\"address\\\";s:26:\\\"info@luciaperezheredia.com\\\";}}s:2:\\\"cc\\\";a:0:{}s:3:\\\"bcc\\\";a:1:{i:0;a:2:{s:4:\\\"name\\\";N;s:7:\\\"address\\\";s:23:\\\"info@masquecontable.com\\\";}}s:7:\\\"replyTo\\\";a:0:{}s:7:\\\"subject\\\";N;s:11:\\\"\\u0000*\\u0000markdown\\\";N;s:7:\\\"\\u0000*\\u0000html\\\";N;s:4:\\\"view\\\";N;s:8:\\\"textView\\\";N;s:8:\\\"viewData\\\";a:0:{}s:11:\\\"attachments\\\";a:0:{}s:14:\\\"rawAttachments\\\";a:0:{}s:15:\\\"diskAttachments\\\";a:0:{}s:9:\\\"callbacks\\\";a:0:{}s:5:\\\"theme\\\";N;s:6:\\\"mailer\\\";s:8:\\\"sendgrid\\\";s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:5:\\\"delay\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;}\"}}','ErrorException: Trying to get property \'id\' of non-object in /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php:16\nStack trace:\n#0 /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php(16): Illuminate\\Foundation\\Bootstrap\\HandleExceptions->handleError(8, \'Trying to get p...\', \'/home/forge/tax...\', 16, Array)\n#1 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(356): App\\Queue\\DatabaseJob->fire()\n#2 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(306): Illuminate\\Queue\\Worker->process(\'database\', Object(App\\Queue\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#3 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(132): Illuminate\\Queue\\Worker->runJob(Object(App\\Queue\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#4 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(112): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#5 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(96): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#6 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#7 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#8 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#9 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#10 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#11 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(134): Illuminate\\Container\\Container->call(Array)\n#12 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(256): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#13 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(121): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#14 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(971): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#15 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(290): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#16 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(166): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#17 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Application.php(93): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(129): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#19 /home/forge/taxes.com.ar/artisan(35): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#20 {main}','2021-07-23 18:04:10',NULL);
INSERT INTO `failed_jobs` VALUES (19,NULL,'database','default','{\"uuid\":\"31c1e5ab-99a1-4edb-86d2-61bd69aec609\",\"displayName\":\"App\\\\Mail\\\\Fact_Electronica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"delay\":null,\"timeout\":null,\"timeoutAt\":null,\"data\":{\"commandName\":\"Illuminate\\\\Mail\\\\SendQueuedMailable\",\"command\":\"O:34:\\\"Illuminate\\\\Mail\\\\SendQueuedMailable\\\":3:{s:8:\\\"mailable\\\";O:25:\\\"App\\\\Mail\\\\Fact_Electronica\\\":27:{s:11:\\\"informacion\\\";a:6:{s:12:\\\"ruta_logo_fa\\\";N;s:4:\\\"mail\\\";s:23:\\\"info@masquecontable.com\\\";s:18:\\\"name_quien_factura\\\";s:19:\\\"MICAELA AILIN CORIA\\\";s:7:\\\"cliente\\\";O:17:\\\"App\\\\Models\\\\Person\\\":27:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:7:\\\"persons\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:41104;s:7:\\\"user_id\\\";i:5115;s:11:\\\"field_name1\\\";s:12:\\\"PRIETO KAREN\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-95599271-2\\\";s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-07-14 10:24:59\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-07-14 10:24:59\\\";s:11:\\\"activity_id\\\";i:1;s:7:\\\"address\\\";s:113:\\\"Direccion\\r\\nCORREA 2260 Dpto:3\\r\\nCod. Postal\\r\\n1429\\r\\nProvincia\\r\\nCIUDAD AUTONOMA BUENOS AIRES\\r\\nTipo Domicilio\\r\\nFISCAL\\\";s:14:\\\"person_type_id\\\";i:1;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:41104;s:7:\\\"user_id\\\";i:5115;s:11:\\\"field_name1\\\";s:12:\\\"PRIETO KAREN\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-95599271-2\\\";s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-07-14 10:24:59\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-07-14 10:24:59\\\";s:11:\\\"activity_id\\\";i:1;s:7:\\\"address\\\";s:113:\\\"Direccion\\r\\nCORREA 2260 Dpto:3\\r\\nCod. Postal\\r\\n1429\\r\\nProvincia\\r\\nCIUDAD AUTONOMA BUENOS AIRES\\r\\nTipo Domicilio\\r\\nFISCAL\\\";s:14:\\\"person_type_id\\\";i:1;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}s:14:\\\"nombre_del_pdf\\\";s:28:\\\"Factura N\\u00b00004-00000022.pdf\\\";s:9:\\\"body_mail\\\";s:155:\\\"Estimado cliente, se env\\u00eda adjunta la factura de honorarios correspondientes al mes de Julio 2021.\\nMuchas gracias por seguir eligiendo nuestros servicios.\\\";}s:3:\\\"pdf\\\";O:26:\\\"Barryvdh\\\\Snappy\\\\PdfWrapper\\\":4:{s:9:\\\"\\u0000*\\u0000snappy\\\";O:35:\\\"Barryvdh\\\\Snappy\\\\IlluminateSnappyPdf\\\":10:{s:26:\\\"\\u0000*\\u0000optionsWithContentCheck\\\";a:4:{s:11:\\\"header-html\\\";s:4:\\\"html\\\";s:11:\\\"footer-html\\\";s:4:\\\"html\\\";s:5:\\\"cover\\\";s:4:\\\"html\\\";s:15:\\\"xsl-style-sheet\\\";s:3:\\\"xsl\\\";}s:36:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000binary\\\";s:76:\\\"\\/home\\/forge\\/taxes.com.ar\\/vendor\\/h4cc\\/wkhtmltopdf-amd64\\/bin\\/wkhtmltopdf-amd64\\\";s:37:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000options\\\";a:132:{s:7:\\\"collate\\\";N;s:10:\\\"no-collate\\\";N;s:10:\\\"cookie-jar\\\";N;s:6:\\\"copies\\\";i:1;s:3:\\\"dpi\\\";N;s:13:\\\"extended-help\\\";N;s:9:\\\"grayscale\\\";N;s:4:\\\"help\\\";N;s:7:\\\"htmldoc\\\";N;s:18:\\\"ignore-load-errors\\\";N;s:9:\\\"image-dpi\\\";N;s:13:\\\"image-quality\\\";N;s:7:\\\"license\\\";N;s:9:\\\"log-level\\\";N;s:10:\\\"lowquality\\\";b:1;s:7:\\\"manpage\\\";N;s:13:\\\"margin-bottom\\\";N;s:11:\\\"margin-left\\\";N;s:12:\\\"margin-right\\\";N;s:10:\\\"margin-top\\\";N;s:11:\\\"orientation\\\";N;s:11:\\\"page-height\\\";N;s:9:\\\"page-size\\\";s:2:\\\"a4\\\";s:10:\\\"page-width\\\";N;s:18:\\\"no-pdf-compression\\\";N;s:5:\\\"quiet\\\";N;s:20:\\\"read-args-from-stdin\\\";N;s:6:\\\"readme\\\";N;s:5:\\\"title\\\";N;s:11:\\\"use-xserver\\\";N;s:7:\\\"version\\\";N;s:20:\\\"dump-default-toc-xsl\\\";N;s:12:\\\"dump-outline\\\";N;s:7:\\\"outline\\\";N;s:10:\\\"no-outline\\\";N;s:13:\\\"outline-depth\\\";N;s:13:\\\"output-format\\\";N;s:5:\\\"allow\\\";N;s:10:\\\"background\\\";N;s:13:\\\"no-background\\\";N;s:16:\\\"bypass-proxy-for\\\";N;s:9:\\\"cache-dir\\\";N;s:20:\\\"checkbox-checked-svg\\\";N;s:12:\\\"checkbox-svg\\\";N;s:6:\\\"cookie\\\";N;s:13:\\\"custom-header\\\";N;s:25:\\\"custom-header-propagation\\\";N;s:28:\\\"no-custom-header-propagation\\\";N;s:16:\\\"debug-javascript\\\";N;s:19:\\\"no-debug-javascript\\\";N;s:14:\\\"default-header\\\";N;s:8:\\\"encoding\\\";N;s:22:\\\"disable-external-links\\\";N;s:21:\\\"enable-external-links\\\";N;s:13:\\\"disable-forms\\\";N;s:12:\\\"enable-forms\\\";N;s:6:\\\"images\\\";N;s:9:\\\"no-images\\\";N;s:22:\\\"disable-internal-links\\\";N;s:21:\\\"enable-internal-links\\\";N;s:18:\\\"disable-javascript\\\";N;s:17:\\\"enable-javascript\\\";N;s:16:\\\"javascript-delay\\\";N;s:19:\\\"keep-relative-links\\\";N;s:19:\\\"load-error-handling\\\";N;s:25:\\\"load-media-error-handling\\\";N;s:25:\\\"disable-local-file-access\\\";N;s:24:\\\"enable-local-file-access\\\";N;s:17:\\\"minimum-font-size\\\";N;s:20:\\\"exclude-from-outline\\\";N;s:18:\\\"include-in-outline\\\";N;s:11:\\\"page-offset\\\";N;s:8:\\\"password\\\";N;s:15:\\\"disable-plugins\\\";N;s:14:\\\"enable-plugins\\\";N;s:4:\\\"post\\\";N;s:9:\\\"post-file\\\";N;s:16:\\\"print-media-type\\\";N;s:19:\\\"no-print-media-type\\\";N;s:5:\\\"proxy\\\";N;s:21:\\\"proxy-hostname-lookup\\\";N;s:23:\\\"radiobutton-checked-svg\\\";N;s:15:\\\"radiobutton-svg\\\";N;s:14:\\\"redirect-delay\\\";N;s:22:\\\"resolve-relative-links\\\";N;s:10:\\\"run-script\\\";N;s:23:\\\"disable-smart-shrinking\\\";N;s:22:\\\"enable-smart-shrinking\\\";N;s:12:\\\"ssl-crt-path\\\";N;s:16:\\\"ssl-key-password\\\";N;s:12:\\\"ssl-key-path\\\";N;s:17:\\\"stop-slow-scripts\\\";N;s:20:\\\"no-stop-slow-scripts\\\";N;s:22:\\\"disable-toc-back-links\\\";N;s:21:\\\"enable-toc-back-links\\\";N;s:16:\\\"user-style-sheet\\\";N;s:8:\\\"username\\\";N;s:13:\\\"viewport-size\\\";N;s:13:\\\"window-status\\\";N;s:4:\\\"zoom\\\";N;s:13:\\\"footer-center\\\";s:25:\\\"Pagina [page] de [toPage]\\\";s:16:\\\"footer-font-name\\\";N;s:16:\\\"footer-font-size\\\";i:8;s:11:\\\"footer-html\\\";N;s:11:\\\"footer-left\\\";s:0:\\\"\\\";s:11:\\\"footer-line\\\";N;s:14:\\\"no-footer-line\\\";N;s:12:\\\"footer-right\\\";N;s:14:\\\"footer-spacing\\\";N;s:13:\\\"header-center\\\";N;s:16:\\\"header-font-name\\\";N;s:16:\\\"header-font-size\\\";N;s:11:\\\"header-html\\\";N;s:11:\\\"header-left\\\";N;s:11:\\\"header-line\\\";N;s:14:\\\"no-header-line\\\";N;s:12:\\\"header-right\\\";N;s:14:\\\"header-spacing\\\";N;s:7:\\\"replace\\\";N;s:5:\\\"cover\\\";N;s:3:\\\"toc\\\";N;s:20:\\\"disable-dotted-lines\\\";N;s:9:\\\"toc-depth\\\";N;s:13:\\\"toc-font-name\\\";N;s:16:\\\"toc-l1-font-size\\\";N;s:15:\\\"toc-header-text\\\";N;s:20:\\\"toc-header-font-name\\\";N;s:20:\\\"toc-header-font-size\\\";N;s:21:\\\"toc-level-indentation\\\";N;s:17:\\\"disable-toc-links\\\";N;s:20:\\\"toc-text-size-shrink\\\";N;s:15:\\\"xsl-style-sheet\\\";N;}s:33:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000env\\\";N;s:37:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000timeout\\\";b:0;s:46:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000defaultExtension\\\";s:3:\\\"pdf\\\";s:18:\\\"\\u0000*\\u0000temporaryFolder\\\";N;s:14:\\\"temporaryFiles\\\";a:0:{}s:36:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000logger\\\";O:18:\\\"Psr\\\\Log\\\\NullLogger\\\":0:{}s:2:\\\"fs\\\";O:32:\\\"Illuminate\\\\Filesystem\\\\Filesystem\\\":0:{}}s:10:\\\"\\u0000*\\u0000options\\\";a:0:{}s:4:\\\"html\\\";s:22178:\\\"<!DOCTYPE html>\\n<html lang=\\\"en\\\">\\n    <head>\\n        <meta charset=\\\"utf-8\\\">\\n    <\\/head>\\n    <style>\\n        .subtotales_conceptos{\\n            width:30%;\\n            text-align: right;\\n        }\\n        .subtotales_importes{\\n            text-align: right;\\n        }\\n        .table-totales, .table-totales tr, .table-totales th{\\n            border: 1px solid;\\n        }\\n\\n    <\\/style>\\n    <body>\\n    <div style=\\\"max-height:840px\\\">\\n        <div style=\\\"width: 100%; height:270px\\\"> <!-- Datos de la empresa -->\\n            <table class=\\\"display\\\" cellspacing=\\\"0\\\" width=\\\"100%\\\" style=\\\"border:  1px solid;\\\">\\n                <tr style=\\\"\\\">\\n                    <th colspan=\\\"2\\\" rowspan=\\\"2\\\" style=\\\"width:45%;margin:0;height:150px;\\\">\\n                                                <img src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/img\\/\\/27377183504\\/logo_punto_venta_0000.png\\\"\\/>\\n                                            <\\/th>\\n                    <th style=\\\"border:  1px solid;text-align: center; width:10%\\\" colspan=\\\"2\\\">\\n                        <span style=\\\"font-size: 60px;\\\">C<\\/span> <br \\/> <span style=\\\"font-size: 14px;\\\">cod. 11<\\/span>\\n                    <\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"font-size: 28px;text-align: center;width:45%\\\">\\n                        Factura\\n                        <br>\\n                        0004 - 00000022\\n                    <\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th><\\/th>\\n                    <th style=\\\"border:  1px 1px 1px 0px solid;\\\" colspan=\\\"2\\\"><\\/th>\\n                    <th><\\/th>\\n                <\\/tr>\\n                <tr>\\n\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                                                    Raz&oacute;n Social:\\n                            <span style=\\\"font-weight: normal;\\\">MICAELA AILIN CORIA<\\/span>\\n                                            <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">Fecha de Emisi&oacute;n: <span style=\\\"font-weight: normal;\\\">15\\/07\\/2021<\\/span><\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Domicilio Comercial: <span style=\\\"font-weight: normal;\\\">Victor Guillet esq. Arturo M Bas, C.P.:5800,\\n                        C\\u00f3rdoba<\\/span>\\n                    <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">CUIT: <span style=\\\"font-weight: normal;\\\">27-37718350-4<\\/span><\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Condici&oacute;n frente al IVA: <span style=\\\"font-weight: normal;\\\">Monotributo<\\/span>\\n                    <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Ingresos Brutos: <span style=\\\"font-weight: normal;\\\"><\\/span>\\n                        <br>\\n                        Fecha de Inicio de Actividades: <span style=\\\"font-weight: normal;\\\">09\\/07\\/2021<\\/span>\\n                    <\\/th>\\n                <\\/tr>\\n            <\\/table>\\n        <\\/div>\\n\\n        <table style=\\\"text-align: center; width: 100%;border: solid 1px;\\\"> <!-- Fechas -->\\n            <thead>\\n                <tr>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Per\\u00edodo Facturado Desde: 01\\/07\\/2021<\\/small><\\/th>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Per\\u00edodo Facturado Hasta: 31\\/07\\/2021<\\/small><\\/th>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Fecha Vto. Pago: 15\\/07\\/2021<\\/small><\\/th>\\n                <\\/tr>\\n            <\\/thead>\\n        <\\/table>\\n        \\n        <table style=\\\"width: 100%; margin-top: 1%;border: solid 1px;\\\"> <!-- Datos Clientes -->\\n            <tr>\\n                <th style=\\\"text-align:left;\\\"colspan=\\\"12\\\">\\n                    CUIT: <span style=\\\"font-weight: normal;\\\">27-95599271-2<\\/span>\\n                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\\n                    Apellido y Nombre \\/ Raz&oacute;n Social: <span style=\\\"font-weight: normal;\\\">\\n                    PRIETO KAREN<\\/span>\\n                <\\/th>\\n            <\\/tr>\\n            <tr>\\n                <th style=\\\"text-align:left; width:50%\\\">\\n                    Condici&oacute;n Frente al IVA: <span style=\\\"font-weight: normal;\\\">Responsable Monotributo<\\/span>\\n                <\\/th>\\n                <th style=\\\"text-align:left; width:50%\\\" colspan=\\\"4\\\">\\n                    Domicilio Comercial:\\n                    <span style=\\\"font-weight: normal;\\\">\\n                    Direccion\\r\\nCORREA 2260 Dpto:3\\r\\nCod. Postal\\r\\n1429\\r\\nProvincia\\r\\nCIUDAD AUTONOMA BUENOS AIRES\\r\\nTipo Domicilio\\r\\nFISCAL\\n                    <\\/span>\\n                <\\/th>\\n            <\\/tr>\\n            <tr style=\\\"text-align:left\\\">\\n                <th>Condici&oacute;n de Venta: <span style=\\\"font-weight: normal;\\\">Cuenta Corriente<\\/span><\\/th>\\n            <\\/tr>\\n        <\\/table>\\n\\n        <div style=\\\"border: 1px solid;margin-top: 1%;min-height:600px;\\\">\\n        <table style=\\\"text-align: center; width: 100%; margin-top: 1%;\\\"> <!-- Body -->\\n            <tr style=\\\"border-bottom: 1px solid;font-size: 15px\\\">\\n                <th>C&oacute;digo<\\/th>\\n                <th style=\\\"width: 25%;\\\">Detalle<\\/th>\\n                <th>Cantidad<\\/th>\\n                <th>U.Medida<\\/th>\\n                <th>Precio U.<\\/th>\\n                <th>Bonif. (%)<\\/th>\\n                <th>Precio Bonif.<\\/th>\\n                <th>Subtotal<\\/th>\\n                            <\\/tr>\\n            <tbody>\\n                                                                                <tr style=\\\"font-size: 12px;\\\">\\n                        <td>\\n                            \\n                        <\\/td>\\n                        <td>\\n                            Honorarios profesionales Julio 2021\\n                        <\\/td>\\n                        <td>\\n                            1.00\\n                        <\\/td>\\n                        <td>\\n                            Unidades\\n                        <\\/td>\\n                        <td>                            1.700,00\\n                                                    <\\/td>\\n                        <td>\\n                            0,00%\\n                        <\\/td>\\n                        <td>\\n                            0,00\\n                        <\\/td>\\n                        <td>\\n                            1.700,00\\n                        <\\/td>\\n                                            <\\/tr>\\n                    \\n            <\\/tbody>\\n        <\\/table>\\n        <\\/div>\\n\\n        \\n\\n        <div style=\\\"height:200px;margin-top: 1%;\\\"> <!-- Totales -->\\n              <!-- Es factura B o C -->\\n                <table class=\\\"table-totales\\\" cellspacing=\\\"0\\\" width=\\\"100%\\\">\\n                    <tr>\\n                        <th style=\\\"width:50%; text-align:left;\\\">\\n\\n<!--                                <span style=\\\"width:100%;\\\"><img src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/barcodes\\/71304902493314.png\\\"><\\/span>\\n                                <span style=\\\"text-align:center;\\\">2737718350411000471304902493314202107254<\\/span>-->\\n                        <\\/th>\\n                        <th class=\\\"subtotales_conceptos\\\">TOTAL:<\\/th>\\n                        <th class=\\\"subtotales_importes\\\">$ 1.700,00<\\/th>\\n                    <\\/tr>\\n                <\\/table>\\n                <br>\\n                <table cellspacing=\\\"0\\\" width=\\\"100%\\\" style=\\\"border: none\\\">\\n                    <tr>\\n                        <th style=\\\"width:50%; text-align:left;\\\">\\n\\n                            <?xml version=\\\"1.0\\\" encoding=\\\"UTF-8\\\"?>\\n<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" version=\\\"1.1\\\" width=\\\"100\\\" height=\\\"100\\\" viewBox=\\\"0 0 100 100\\\"><rect x=\\\"0\\\" y=\\\"0\\\" width=\\\"100\\\" height=\\\"100\\\" fill=\\\"#ffffff\\\"\\/><g transform=\\\"scale(1.754)\\\"><g transform=\\\"translate(0,0)\\\"><path fill-rule=\\\"evenodd\\\" d=\\\"M8 0L8 1L9 1L9 2L8 2L8 5L11 5L11 6L10 6L10 7L9 7L9 6L8 6L8 7L9 7L9 8L8 8L8 9L9 9L9 10L6 10L6 9L7 9L7 8L6 8L6 9L4 9L4 8L0 8L0 11L1 11L1 9L4 9L4 11L5 11L5 12L4 12L4 13L8 13L8 14L6 14L6 15L5 15L5 14L4 14L4 15L5 15L5 17L10 17L10 16L11 16L11 17L12 17L12 18L6 18L6 19L5 19L5 18L3 18L3 19L2 19L2 20L4 20L4 21L3 21L3 22L4 22L4 23L2 23L2 22L1 22L1 24L0 24L0 25L1 25L1 24L6 24L6 25L7 25L7 24L8 24L8 21L10 21L10 20L11 20L11 19L12 19L12 21L11 21L11 23L10 23L10 22L9 22L9 24L10 24L10 25L8 25L8 26L5 26L5 25L2 25L2 26L1 26L1 28L0 28L0 30L3 30L3 32L2 32L2 31L0 31L0 32L2 32L2 33L0 33L0 35L1 35L1 36L0 36L0 37L1 37L1 36L2 36L2 35L3 35L3 36L4 36L4 35L3 35L3 34L4 34L4 33L7 33L7 34L5 34L5 35L7 35L7 34L10 34L10 35L9 35L9 36L6 36L6 37L7 37L7 38L6 38L6 39L5 39L5 37L4 37L4 40L3 40L3 39L0 39L0 41L1 41L1 42L0 42L0 44L1 44L1 45L0 45L0 48L5 48L5 47L7 47L7 48L6 48L6 49L8 49L8 50L9 50L9 48L8 48L8 47L9 47L9 46L8 46L8 45L7 45L7 44L4 44L4 42L5 42L5 43L7 43L7 42L10 42L10 41L9 41L9 40L11 40L11 39L12 39L12 42L13 42L13 41L14 41L14 39L15 39L15 38L17 38L17 39L16 39L16 40L15 40L15 42L14 42L14 43L11 43L11 44L12 44L12 46L14 46L14 45L13 45L13 44L15 44L15 42L16 42L16 43L17 43L17 45L18 45L18 46L16 46L16 45L15 45L15 46L16 46L16 49L15 49L15 50L14 50L14 49L13 49L13 48L14 48L14 47L12 47L12 48L11 48L11 46L10 46L10 48L11 48L11 49L13 49L13 50L14 50L14 51L15 51L15 52L14 52L14 53L11 53L11 52L10 52L10 53L8 53L8 57L9 57L9 55L12 55L12 54L15 54L15 53L16 53L16 54L17 54L17 55L18 55L18 56L17 56L17 57L18 57L18 56L19 56L19 57L21 57L21 55L22 55L22 53L21 53L21 55L20 55L20 51L21 51L21 52L23 52L23 50L24 50L24 53L25 53L25 54L23 54L23 56L22 56L22 57L24 57L24 56L26 56L26 55L25 55L25 54L27 54L27 53L31 53L31 54L33 54L33 55L32 55L32 56L34 56L34 57L36 57L36 55L38 55L38 56L37 56L37 57L44 57L44 56L43 56L43 55L42 55L42 56L41 56L41 55L40 55L40 54L42 54L42 53L40 53L40 52L43 52L43 53L45 53L45 52L46 52L46 51L45 51L45 49L47 49L47 48L48 48L48 50L47 50L47 53L46 53L46 54L44 54L44 55L45 55L45 56L46 56L46 57L47 57L47 56L49 56L49 55L50 55L50 57L51 57L51 55L50 55L50 53L51 53L51 54L52 54L52 53L54 53L54 54L53 54L53 56L52 56L52 57L55 57L55 56L54 56L54 55L55 55L55 54L56 54L56 53L57 53L57 51L56 51L56 49L57 49L57 48L56 48L56 49L55 49L55 51L53 51L53 49L54 49L54 48L53 48L53 46L54 46L54 45L56 45L56 46L55 46L55 47L57 47L57 44L53 44L53 46L52 46L52 43L51 43L51 44L50 44L50 42L51 42L51 41L50 41L50 40L51 40L51 39L54 39L54 41L53 41L53 40L52 40L52 42L54 42L54 43L55 43L55 42L57 42L57 40L56 40L56 38L57 38L57 31L56 31L56 30L57 30L57 27L56 27L56 24L57 24L57 21L56 21L56 20L53 20L53 19L54 19L54 18L55 18L55 14L54 14L54 10L53 10L53 9L55 9L55 10L56 10L56 11L55 11L55 12L57 12L57 8L56 8L56 9L55 9L55 8L52 8L52 10L51 10L51 11L50 11L50 10L49 10L49 9L50 9L50 8L48 8L48 7L49 7L49 6L48 6L48 7L47 7L47 5L48 5L48 0L45 0L45 1L43 1L43 0L39 0L39 1L41 1L41 4L40 4L40 5L39 5L39 2L38 2L38 1L37 1L37 2L36 2L36 1L32 1L32 2L31 2L31 0L30 0L30 1L29 1L29 0L28 0L28 1L26 1L26 0L24 0L24 1L23 1L23 0L22 0L22 1L23 1L23 2L22 2L22 3L21 3L21 4L20 4L20 5L21 5L21 4L22 4L22 11L20 11L20 12L19 12L19 10L20 10L20 9L21 9L21 8L20 8L20 7L21 7L21 6L20 6L20 7L19 7L19 6L18 6L18 7L17 7L17 6L16 6L16 7L15 7L15 6L14 6L14 5L12 5L12 4L14 4L14 3L15 3L15 5L17 5L17 4L16 4L16 3L17 3L17 2L18 2L18 1L17 1L17 2L15 2L15 1L16 1L16 0L14 0L14 2L13 2L13 3L12 3L12 2L11 2L11 3L10 3L10 4L9 4L9 2L10 2L10 1L9 1L9 0ZM12 0L12 1L13 1L13 0ZM19 1L19 2L21 2L21 1ZM25 1L25 2L23 2L23 3L22 3L22 4L23 4L23 3L24 3L24 5L23 5L23 12L22 12L22 13L23 13L23 14L24 14L24 16L23 16L23 15L22 15L22 14L20 14L20 13L19 13L19 12L18 12L18 10L19 10L19 9L20 9L20 8L18 8L18 9L17 9L17 8L15 8L15 7L14 7L14 6L13 6L13 7L12 7L12 6L11 6L11 7L10 7L10 8L9 8L9 9L13 9L13 10L12 10L12 12L11 12L11 13L12 13L12 12L13 12L13 13L15 13L15 14L14 14L14 15L13 15L13 14L12 14L12 15L11 15L11 16L12 16L12 17L13 17L13 18L14 18L14 15L15 15L15 16L16 16L16 14L17 14L17 16L18 16L18 17L17 17L17 18L15 18L15 19L13 19L13 21L12 21L12 22L13 22L13 23L14 23L14 24L16 24L16 23L18 23L18 22L19 22L19 23L20 23L20 24L19 24L19 25L18 25L18 26L17 26L17 25L16 25L16 26L15 26L15 25L14 25L14 26L15 26L15 27L14 27L14 28L15 28L15 30L14 30L14 29L12 29L12 28L11 28L11 26L10 26L10 27L9 27L9 28L10 28L10 32L9 32L9 31L8 31L8 33L11 33L11 34L12 34L12 35L15 35L15 34L16 34L16 35L17 35L17 36L16 36L16 37L17 37L17 38L18 38L18 39L17 39L17 40L16 40L16 41L17 41L17 42L18 42L18 43L20 43L20 44L19 44L19 46L18 46L18 47L17 47L17 48L18 48L18 47L20 47L20 48L19 48L19 50L17 50L17 49L16 49L16 53L17 53L17 52L18 52L18 53L19 53L19 51L20 51L20 48L22 48L22 49L23 49L23 48L22 48L22 47L24 47L24 46L22 46L22 44L21 44L21 41L22 41L22 43L24 43L24 44L23 44L23 45L25 45L25 46L27 46L27 44L28 44L28 47L26 47L26 48L24 48L24 50L25 50L25 49L26 49L26 48L28 48L28 47L29 47L29 48L30 48L30 47L32 47L32 50L31 50L31 51L32 51L32 50L33 50L33 51L35 51L35 52L36 52L36 53L35 53L35 55L34 55L34 56L35 56L35 55L36 55L36 53L37 53L37 54L38 54L38 55L39 55L39 56L40 56L40 55L39 55L39 53L37 53L37 51L38 51L38 52L40 52L40 50L41 50L41 51L42 51L42 50L43 50L43 51L44 51L44 49L45 49L45 48L46 48L46 46L47 46L47 45L48 45L48 44L49 44L49 42L50 42L50 41L49 41L49 42L47 42L47 43L46 43L46 44L45 44L45 42L46 42L46 40L47 40L47 39L48 39L48 37L50 37L50 33L51 33L51 31L50 31L50 33L48 33L48 31L46 31L46 32L45 32L45 31L44 31L44 32L43 32L43 29L44 29L44 30L45 30L45 29L44 29L44 27L46 27L46 29L47 29L47 30L48 30L48 27L47 27L47 25L45 25L45 24L46 24L46 23L45 23L45 22L44 22L44 21L46 21L46 22L48 22L48 23L47 23L47 24L48 24L48 26L50 26L50 25L51 25L51 23L52 23L52 25L53 25L53 27L55 27L55 29L54 29L54 28L53 28L53 29L54 29L54 32L53 32L53 31L52 31L52 34L54 34L54 32L55 32L55 35L54 35L54 37L52 37L52 35L51 35L51 38L50 38L50 39L51 39L51 38L54 38L54 39L55 39L55 38L56 38L56 36L55 36L55 35L56 35L56 32L55 32L55 30L56 30L56 27L55 27L55 23L54 23L54 22L51 22L51 21L52 21L52 20L51 20L51 19L53 19L53 18L51 18L51 17L54 17L54 14L52 14L52 13L53 13L53 10L52 10L52 11L51 11L51 12L52 12L52 13L51 13L51 17L50 17L50 18L51 18L51 19L50 19L50 20L49 20L49 19L48 19L48 20L49 20L49 22L48 22L48 21L47 21L47 20L45 20L45 19L46 19L46 17L47 17L47 18L49 18L49 17L47 17L47 16L46 16L46 15L47 15L47 13L48 13L48 14L50 14L50 12L49 12L49 10L48 10L48 8L47 8L47 9L46 9L46 10L48 10L48 11L46 11L46 12L47 12L47 13L46 13L46 14L45 14L45 12L44 12L44 13L43 13L43 12L42 12L42 13L41 13L41 9L44 9L44 10L43 10L43 11L45 11L45 7L46 7L46 5L47 5L47 3L46 3L46 2L47 2L47 1L45 1L45 3L44 3L44 5L43 5L43 4L41 4L41 7L42 7L42 8L41 8L41 9L39 9L39 8L38 8L38 9L37 9L37 8L35 8L35 7L36 7L36 6L37 6L37 7L38 7L38 6L37 6L37 5L38 5L38 3L37 3L37 5L35 5L35 4L34 4L34 5L33 5L33 7L32 7L32 4L33 4L33 3L34 3L34 2L33 2L33 3L31 3L31 8L32 8L32 9L31 9L31 10L33 10L33 11L34 11L34 10L35 10L35 13L34 13L34 14L32 14L32 15L33 15L33 17L30 17L30 18L28 18L28 19L27 19L27 17L29 17L29 16L30 16L30 15L29 15L29 13L30 13L30 14L31 14L31 13L33 13L33 12L31 12L31 11L26 11L26 12L25 12L25 11L24 11L24 8L25 8L25 10L27 10L27 9L26 9L26 8L25 8L25 7L26 7L26 6L25 6L25 5L26 5L26 4L25 4L25 2L26 2L26 3L28 3L28 4L30 4L30 3L29 3L29 2L26 2L26 1ZM18 3L18 5L19 5L19 3ZM45 3L45 5L46 5L46 3ZM27 5L27 8L30 8L30 5ZM42 5L42 7L43 7L43 8L44 8L44 7L45 7L45 6L44 6L44 7L43 7L43 5ZM24 6L24 7L25 7L25 6ZM28 6L28 7L29 7L29 6ZM34 6L34 7L35 7L35 6ZM39 6L39 7L40 7L40 6ZM13 7L13 9L14 9L14 11L15 11L15 13L17 13L17 14L18 14L18 12L17 12L17 11L16 11L16 10L15 10L15 9L14 9L14 7ZM28 9L28 10L30 10L30 9ZM36 9L36 13L35 13L35 15L39 15L39 16L38 16L38 17L37 17L37 19L36 19L36 18L35 18L35 17L36 17L36 16L35 16L35 17L33 17L33 18L31 18L31 19L35 19L35 20L37 20L37 22L36 22L36 21L35 21L35 22L32 22L32 20L30 20L30 19L28 19L28 20L27 20L27 19L25 19L25 18L24 18L24 19L22 19L22 18L21 18L21 19L20 19L20 16L19 16L19 17L18 17L18 19L16 19L16 20L14 20L14 21L15 21L15 23L16 23L16 21L17 21L17 22L18 22L18 21L17 21L17 20L18 20L18 19L20 19L20 21L19 21L19 22L20 22L20 21L21 21L21 19L22 19L22 23L25 23L25 25L26 25L26 29L25 29L25 27L24 27L24 26L23 26L23 25L22 25L22 24L20 24L20 25L19 25L19 27L17 27L17 28L16 28L16 27L15 27L15 28L16 28L16 30L15 30L15 31L17 31L17 32L18 32L18 28L19 28L19 30L20 30L20 28L19 28L19 27L21 27L21 26L22 26L22 28L23 28L23 30L22 30L22 29L21 29L21 30L22 30L22 31L20 31L20 33L21 33L21 32L22 32L22 35L26 35L26 36L25 36L25 37L27 37L27 35L28 35L28 37L29 37L29 39L30 39L30 38L31 38L31 40L27 40L27 42L29 42L29 41L30 41L30 44L29 44L29 43L28 43L28 44L29 44L29 45L30 45L30 46L31 46L31 45L32 45L32 47L33 47L33 46L34 46L34 48L33 48L33 50L34 50L34 48L35 48L35 47L36 47L36 49L35 49L35 51L36 51L36 49L37 49L37 48L38 48L38 45L37 45L37 47L36 47L36 45L35 45L35 46L34 46L34 45L32 45L32 43L31 43L31 41L33 41L33 43L35 43L35 44L37 44L37 42L38 42L38 44L39 44L39 47L40 47L40 45L41 45L41 48L42 48L42 49L43 49L43 48L45 48L45 45L44 45L44 44L43 44L43 43L42 43L42 45L41 45L41 43L40 43L40 44L39 44L39 42L38 42L38 41L37 41L37 42L36 42L36 40L35 40L35 39L38 39L38 40L39 40L39 41L40 41L40 42L42 42L42 41L43 41L43 42L45 42L45 40L46 40L46 38L45 38L45 37L46 37L46 36L48 36L48 35L49 35L49 34L48 34L48 33L47 33L47 32L46 32L46 33L44 33L44 35L43 35L43 32L42 32L42 33L41 33L41 31L40 31L40 30L41 30L41 29L43 29L43 27L42 27L42 28L41 28L41 26L40 26L40 25L39 25L39 24L40 24L40 23L41 23L41 25L42 25L42 24L43 24L43 25L44 25L44 26L45 26L45 25L44 25L44 24L45 24L45 23L44 23L44 22L43 22L43 18L44 18L44 17L46 17L46 16L45 16L45 15L44 15L44 14L42 14L42 15L41 15L41 13L40 13L40 10L39 10L39 13L38 13L38 12L37 12L37 9ZM2 10L2 11L3 11L3 10ZM5 10L5 11L6 11L6 12L7 12L7 11L6 11L6 10ZM9 10L9 11L8 11L8 13L9 13L9 14L8 14L8 15L6 15L6 16L10 16L10 12L9 12L9 11L10 11L10 10ZM0 12L0 15L1 15L1 12ZM23 12L23 13L24 13L24 12ZM26 12L26 14L25 14L25 16L24 16L24 17L25 17L25 16L26 16L26 15L27 15L27 12ZM36 13L36 14L38 14L38 13ZM39 13L39 15L40 15L40 13ZM19 14L19 15L20 15L20 14ZM12 15L12 16L13 16L13 15ZM28 15L28 16L29 16L29 15ZM42 15L42 16L39 16L39 17L38 17L38 18L41 18L41 17L42 17L42 18L43 18L43 17L42 17L42 16L43 16L43 15ZM49 15L49 16L50 16L50 15ZM52 15L52 16L53 16L53 15ZM2 16L2 17L4 17L4 16ZM56 16L56 18L57 18L57 16ZM0 18L0 21L1 21L1 18ZM6 19L6 20L5 20L5 21L6 21L6 22L7 22L7 21L8 21L8 20L7 20L7 19ZM9 19L9 20L10 20L10 19ZM24 19L24 20L25 20L25 19ZM37 19L37 20L38 20L38 19ZM39 19L39 20L40 20L40 19ZM41 19L41 20L42 20L42 19ZM6 20L6 21L7 21L7 20ZM29 20L29 21L28 21L28 22L27 22L27 21L25 21L25 23L26 23L26 24L28 24L28 26L31 26L31 27L33 27L33 28L34 28L34 29L35 29L35 31L36 31L36 29L37 29L37 30L39 30L39 29L41 29L41 28L38 28L38 29L37 29L37 27L38 27L38 24L39 24L39 23L38 23L38 24L37 24L37 26L35 26L35 25L36 25L36 23L35 23L35 25L34 25L34 23L33 23L33 24L32 24L32 22L31 22L31 23L30 23L30 20ZM33 20L33 21L34 21L34 20ZM50 20L50 21L51 21L51 20ZM23 21L23 22L24 22L24 21ZM38 21L38 22L40 22L40 21ZM55 21L55 22L56 22L56 21ZM26 22L26 23L27 23L27 22ZM6 23L6 24L7 24L7 23ZM11 23L11 25L12 25L12 27L13 27L13 25L12 25L12 23ZM49 23L49 25L50 25L50 23ZM31 24L31 26L34 26L34 25L32 25L32 24ZM3 26L3 27L4 27L4 26ZM39 26L39 27L40 27L40 26ZM5 27L5 30L8 30L8 27ZM27 27L27 30L30 30L30 27ZM49 27L49 30L52 30L52 27ZM2 28L2 29L3 29L3 28ZM6 28L6 29L7 29L7 28ZM28 28L28 29L29 29L29 28ZM31 28L31 29L32 29L32 28ZM35 28L35 29L36 29L36 28ZM50 28L50 29L51 29L51 28ZM11 29L11 30L12 30L12 31L13 31L13 30L12 30L12 29ZM24 29L24 32L25 32L25 34L26 34L26 35L27 35L27 34L30 34L30 35L29 35L29 36L30 36L30 35L31 35L31 38L33 38L33 36L32 36L32 34L31 34L31 33L33 33L33 34L36 34L36 35L37 35L37 34L38 34L38 36L37 36L37 37L39 37L39 38L38 38L38 39L40 39L40 41L42 41L42 38L44 38L44 39L45 39L45 38L44 38L44 37L45 37L45 36L46 36L46 34L47 34L47 33L46 33L46 34L45 34L45 36L41 36L41 35L42 35L42 34L39 34L39 33L40 33L40 32L38 32L38 31L37 31L37 32L35 32L35 33L33 33L33 32L34 32L34 30L33 30L33 31L32 31L32 30L31 30L31 33L30 33L30 31L26 31L26 32L25 32L25 29ZM6 31L6 32L7 32L7 31ZM22 31L22 32L23 32L23 31ZM3 32L3 33L4 33L4 32ZM11 32L11 33L12 33L12 32ZM13 32L13 33L14 33L14 34L15 34L15 32ZM26 32L26 33L27 33L27 32ZM37 32L37 33L38 33L38 32ZM23 33L23 34L24 34L24 33ZM1 34L1 35L2 35L2 34ZM17 34L17 35L18 35L18 34ZM19 34L19 35L20 35L20 38L19 38L19 36L18 36L18 38L19 38L19 39L18 39L18 40L20 40L20 38L21 38L21 37L22 37L22 38L24 38L24 36L23 36L23 37L22 37L22 36L21 36L21 34ZM12 36L12 37L11 37L11 38L10 38L10 37L8 37L8 38L7 38L7 39L6 39L6 40L8 40L8 39L9 39L9 38L10 38L10 39L11 39L11 38L12 38L12 39L14 39L14 38L15 38L15 36ZM34 36L34 39L33 39L33 40L34 40L34 39L35 39L35 38L36 38L36 37L35 37L35 36ZM39 36L39 37L40 37L40 39L41 39L41 37L40 37L40 36ZM2 37L2 38L3 38L3 37ZM12 37L12 38L14 38L14 37ZM54 37L54 38L55 38L55 37ZM26 38L26 39L28 39L28 38ZM21 39L21 40L22 40L22 39ZM24 39L24 40L23 40L23 42L24 42L24 41L25 41L25 44L26 44L26 41L25 41L25 39ZM1 40L1 41L2 41L2 46L1 46L1 47L2 47L2 46L3 46L3 47L5 47L5 46L4 46L4 45L3 45L3 40ZM55 40L55 41L54 41L54 42L55 42L55 41L56 41L56 40ZM6 41L6 42L7 42L7 41ZM18 41L18 42L20 42L20 41ZM8 43L8 44L9 44L9 45L10 45L10 43ZM20 44L20 45L21 45L21 44ZM30 44L30 45L31 45L31 44ZM6 45L6 46L7 46L7 47L8 47L8 46L7 46L7 45ZM43 45L43 47L42 47L42 48L43 48L43 47L44 47L44 45ZM49 45L49 48L50 48L50 46L51 46L51 45ZM20 46L20 47L21 47L21 46ZM51 47L51 48L52 48L52 47ZM39 48L39 49L38 49L38 51L39 51L39 50L40 50L40 48ZM27 49L27 52L30 52L30 49ZM49 49L49 52L52 52L52 49ZM21 50L21 51L22 51L22 50ZM28 50L28 51L29 51L29 50ZM50 50L50 51L51 51L51 50ZM25 51L25 52L26 52L26 51ZM55 51L55 53L56 53L56 51ZM31 52L31 53L32 53L32 52ZM33 52L33 54L34 54L34 52ZM10 53L10 54L11 54L11 53ZM18 54L18 55L19 55L19 56L20 56L20 55L19 55L19 54ZM47 54L47 55L48 55L48 54ZM14 55L14 56L13 56L13 57L14 57L14 56L15 56L15 55ZM27 55L27 57L31 57L31 56L30 56L30 55L29 55L29 56L28 56L28 55ZM56 55L56 56L57 56L57 55ZM0 0L0 7L7 7L7 0ZM1 1L1 6L6 6L6 1ZM2 2L2 5L5 5L5 2ZM50 0L50 7L57 7L57 0ZM51 1L51 6L56 6L56 1ZM52 2L52 5L55 5L55 2ZM0 50L0 57L7 57L7 50ZM1 51L1 56L6 56L6 51ZM2 52L2 55L5 55L5 52Z\\\" fill=\\\"#000000\\\"\\/><\\/g><\\/g><\\/svg>\\n\\n                            <span style=\\\"width:50%;\\\">\\n                                <img style=\\\"max-height: 70px\\\"\\n                                     src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/img\\/AfipComprobanteAutorizado.png\\\">\\n                            <\\/span>\\n                        <\\/th>\\n                        <th style=\\\"text-align:right;\\\">\\n                            <p>CAE N&#186;: 71304902493314<br>\\n                                Fecha Vto. CAE:  25\\/07\\/2021\\n                            <\\/p>\\n                        <\\/th>\\n                    <\\/tr>\\n                <\\/table>\\n                    <\\/div>\\n    <\\/div>\\n\\n    <\\/body>\\n<\\/html>\\\";s:4:\\\"file\\\";N;}s:6:\\\"locale\\\";N;s:4:\\\"from\\\";a:0:{}s:2:\\\"to\\\";a:1:{i:0;a:2:{s:4:\\\"name\\\";N;s:7:\\\"address\\\";s:27:\\\"karenprietocastro@gmail.com\\\";}}s:2:\\\"cc\\\";a:0:{}s:3:\\\"bcc\\\";a:1:{i:0;a:2:{s:4:\\\"name\\\";N;s:7:\\\"address\\\";s:23:\\\"info@masquecontable.com\\\";}}s:7:\\\"replyTo\\\";a:0:{}s:7:\\\"subject\\\";N;s:11:\\\"\\u0000*\\u0000markdown\\\";N;s:7:\\\"\\u0000*\\u0000html\\\";N;s:4:\\\"view\\\";N;s:8:\\\"textView\\\";N;s:8:\\\"viewData\\\";a:0:{}s:11:\\\"attachments\\\";a:0:{}s:14:\\\"rawAttachments\\\";a:0:{}s:15:\\\"diskAttachments\\\";a:0:{}s:9:\\\"callbacks\\\";a:0:{}s:5:\\\"theme\\\";N;s:6:\\\"mailer\\\";s:8:\\\"sendgrid\\\";s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:5:\\\"delay\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;}\"}}','ErrorException: Trying to get property \'id\' of non-object in /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php:16\nStack trace:\n#0 /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php(16): Illuminate\\Foundation\\Bootstrap\\HandleExceptions->handleError(8, \'Trying to get p...\', \'/home/forge/tax...\', 16, Array)\n#1 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(356): App\\Queue\\DatabaseJob->fire()\n#2 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(306): Illuminate\\Queue\\Worker->process(\'database\', Object(App\\Queue\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#3 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(132): Illuminate\\Queue\\Worker->runJob(Object(App\\Queue\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#4 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(112): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#5 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(96): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#6 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#7 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#8 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#9 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#10 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#11 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(134): Illuminate\\Container\\Container->call(Array)\n#12 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(256): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#13 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(121): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#14 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(971): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#15 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(290): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#16 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(166): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#17 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Application.php(93): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(129): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#19 /home/forge/taxes.com.ar/artisan(35): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#20 {main}','2021-07-23 18:04:10',NULL);
INSERT INTO `failed_jobs` VALUES (20,NULL,'database','default','{\"uuid\":\"188a6d27-4113-4d8d-8c81-5de04414bba9\",\"displayName\":\"App\\\\Mail\\\\Fact_Electronica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"delay\":null,\"timeout\":null,\"timeoutAt\":null,\"data\":{\"commandName\":\"Illuminate\\\\Mail\\\\SendQueuedMailable\",\"command\":\"O:34:\\\"Illuminate\\\\Mail\\\\SendQueuedMailable\\\":3:{s:8:\\\"mailable\\\";O:25:\\\"App\\\\Mail\\\\Fact_Electronica\\\":27:{s:11:\\\"informacion\\\";a:6:{s:12:\\\"ruta_logo_fa\\\";N;s:4:\\\"mail\\\";s:23:\\\"info@masquecontable.com\\\";s:18:\\\"name_quien_factura\\\";s:19:\\\"MICAELA AILIN CORIA\\\";s:7:\\\"cliente\\\";O:17:\\\"App\\\\Models\\\\Person\\\":27:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:7:\\\"persons\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:19:{s:2:\\\"id\\\";i:41105;s:7:\\\"user_id\\\";i:5115;s:11:\\\"field_name1\\\";s:23:\\\"RATTAZZI NATALIA ROMINA\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-32933499-1\\\";s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-07-14 10:36:05\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-07-14 10:36:05\\\";s:11:\\\"activity_id\\\";i:1;s:7:\\\"address\\\";s:89:\\\"Direccion\\r\\nPJE. LANIN 1661\\r\\nCod. Postal\\r\\n5800\\r\\nProvincia\\r\\nCORDOBA\\r\\nTipo Domicilio\\r\\nFISCAL\\\";s:14:\\\"person_type_id\\\";i:1;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:19:{s:2:\\\"id\\\";i:41105;s:7:\\\"user_id\\\";i:5115;s:11:\\\"field_name1\\\";s:23:\\\"RATTAZZI NATALIA ROMINA\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-32933499-1\\\";s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-07-14 10:36:05\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-07-14 10:36:05\\\";s:11:\\\"activity_id\\\";i:1;s:7:\\\"address\\\";s:89:\\\"Direccion\\r\\nPJE. LANIN 1661\\r\\nCod. Postal\\r\\n5800\\r\\nProvincia\\r\\nCORDOBA\\r\\nTipo Domicilio\\r\\nFISCAL\\\";s:14:\\\"person_type_id\\\";i:1;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}s:14:\\\"nombre_del_pdf\\\";s:28:\\\"Factura N\\u00b00004-00000023.pdf\\\";s:9:\\\"body_mail\\\";s:155:\\\"Estimado cliente, se env\\u00eda adjunta la factura de honorarios correspondientes al mes de Julio 2021.\\nMuchas gracias por seguir eligiendo nuestros servicios.\\\";}s:3:\\\"pdf\\\";O:26:\\\"Barryvdh\\\\Snappy\\\\PdfWrapper\\\":4:{s:9:\\\"\\u0000*\\u0000snappy\\\";O:35:\\\"Barryvdh\\\\Snappy\\\\IlluminateSnappyPdf\\\":10:{s:26:\\\"\\u0000*\\u0000optionsWithContentCheck\\\";a:4:{s:11:\\\"header-html\\\";s:4:\\\"html\\\";s:11:\\\"footer-html\\\";s:4:\\\"html\\\";s:5:\\\"cover\\\";s:4:\\\"html\\\";s:15:\\\"xsl-style-sheet\\\";s:3:\\\"xsl\\\";}s:36:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000binary\\\";s:76:\\\"\\/home\\/forge\\/taxes.com.ar\\/vendor\\/h4cc\\/wkhtmltopdf-amd64\\/bin\\/wkhtmltopdf-amd64\\\";s:37:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000options\\\";a:132:{s:7:\\\"collate\\\";N;s:10:\\\"no-collate\\\";N;s:10:\\\"cookie-jar\\\";N;s:6:\\\"copies\\\";i:1;s:3:\\\"dpi\\\";N;s:13:\\\"extended-help\\\";N;s:9:\\\"grayscale\\\";N;s:4:\\\"help\\\";N;s:7:\\\"htmldoc\\\";N;s:18:\\\"ignore-load-errors\\\";N;s:9:\\\"image-dpi\\\";N;s:13:\\\"image-quality\\\";N;s:7:\\\"license\\\";N;s:9:\\\"log-level\\\";N;s:10:\\\"lowquality\\\";b:1;s:7:\\\"manpage\\\";N;s:13:\\\"margin-bottom\\\";N;s:11:\\\"margin-left\\\";N;s:12:\\\"margin-right\\\";N;s:10:\\\"margin-top\\\";N;s:11:\\\"orientation\\\";N;s:11:\\\"page-height\\\";N;s:9:\\\"page-size\\\";s:2:\\\"a4\\\";s:10:\\\"page-width\\\";N;s:18:\\\"no-pdf-compression\\\";N;s:5:\\\"quiet\\\";N;s:20:\\\"read-args-from-stdin\\\";N;s:6:\\\"readme\\\";N;s:5:\\\"title\\\";N;s:11:\\\"use-xserver\\\";N;s:7:\\\"version\\\";N;s:20:\\\"dump-default-toc-xsl\\\";N;s:12:\\\"dump-outline\\\";N;s:7:\\\"outline\\\";N;s:10:\\\"no-outline\\\";N;s:13:\\\"outline-depth\\\";N;s:13:\\\"output-format\\\";N;s:5:\\\"allow\\\";N;s:10:\\\"background\\\";N;s:13:\\\"no-background\\\";N;s:16:\\\"bypass-proxy-for\\\";N;s:9:\\\"cache-dir\\\";N;s:20:\\\"checkbox-checked-svg\\\";N;s:12:\\\"checkbox-svg\\\";N;s:6:\\\"cookie\\\";N;s:13:\\\"custom-header\\\";N;s:25:\\\"custom-header-propagation\\\";N;s:28:\\\"no-custom-header-propagation\\\";N;s:16:\\\"debug-javascript\\\";N;s:19:\\\"no-debug-javascript\\\";N;s:14:\\\"default-header\\\";N;s:8:\\\"encoding\\\";N;s:22:\\\"disable-external-links\\\";N;s:21:\\\"enable-external-links\\\";N;s:13:\\\"disable-forms\\\";N;s:12:\\\"enable-forms\\\";N;s:6:\\\"images\\\";N;s:9:\\\"no-images\\\";N;s:22:\\\"disable-internal-links\\\";N;s:21:\\\"enable-internal-links\\\";N;s:18:\\\"disable-javascript\\\";N;s:17:\\\"enable-javascript\\\";N;s:16:\\\"javascript-delay\\\";N;s:19:\\\"keep-relative-links\\\";N;s:19:\\\"load-error-handling\\\";N;s:25:\\\"load-media-error-handling\\\";N;s:25:\\\"disable-local-file-access\\\";N;s:24:\\\"enable-local-file-access\\\";N;s:17:\\\"minimum-font-size\\\";N;s:20:\\\"exclude-from-outline\\\";N;s:18:\\\"include-in-outline\\\";N;s:11:\\\"page-offset\\\";N;s:8:\\\"password\\\";N;s:15:\\\"disable-plugins\\\";N;s:14:\\\"enable-plugins\\\";N;s:4:\\\"post\\\";N;s:9:\\\"post-file\\\";N;s:16:\\\"print-media-type\\\";N;s:19:\\\"no-print-media-type\\\";N;s:5:\\\"proxy\\\";N;s:21:\\\"proxy-hostname-lookup\\\";N;s:23:\\\"radiobutton-checked-svg\\\";N;s:15:\\\"radiobutton-svg\\\";N;s:14:\\\"redirect-delay\\\";N;s:22:\\\"resolve-relative-links\\\";N;s:10:\\\"run-script\\\";N;s:23:\\\"disable-smart-shrinking\\\";N;s:22:\\\"enable-smart-shrinking\\\";N;s:12:\\\"ssl-crt-path\\\";N;s:16:\\\"ssl-key-password\\\";N;s:12:\\\"ssl-key-path\\\";N;s:17:\\\"stop-slow-scripts\\\";N;s:20:\\\"no-stop-slow-scripts\\\";N;s:22:\\\"disable-toc-back-links\\\";N;s:21:\\\"enable-toc-back-links\\\";N;s:16:\\\"user-style-sheet\\\";N;s:8:\\\"username\\\";N;s:13:\\\"viewport-size\\\";N;s:13:\\\"window-status\\\";N;s:4:\\\"zoom\\\";N;s:13:\\\"footer-center\\\";s:25:\\\"Pagina [page] de [toPage]\\\";s:16:\\\"footer-font-name\\\";N;s:16:\\\"footer-font-size\\\";i:8;s:11:\\\"footer-html\\\";N;s:11:\\\"footer-left\\\";s:0:\\\"\\\";s:11:\\\"footer-line\\\";N;s:14:\\\"no-footer-line\\\";N;s:12:\\\"footer-right\\\";N;s:14:\\\"footer-spacing\\\";N;s:13:\\\"header-center\\\";N;s:16:\\\"header-font-name\\\";N;s:16:\\\"header-font-size\\\";N;s:11:\\\"header-html\\\";N;s:11:\\\"header-left\\\";N;s:11:\\\"header-line\\\";N;s:14:\\\"no-header-line\\\";N;s:12:\\\"header-right\\\";N;s:14:\\\"header-spacing\\\";N;s:7:\\\"replace\\\";N;s:5:\\\"cover\\\";N;s:3:\\\"toc\\\";N;s:20:\\\"disable-dotted-lines\\\";N;s:9:\\\"toc-depth\\\";N;s:13:\\\"toc-font-name\\\";N;s:16:\\\"toc-l1-font-size\\\";N;s:15:\\\"toc-header-text\\\";N;s:20:\\\"toc-header-font-name\\\";N;s:20:\\\"toc-header-font-size\\\";N;s:21:\\\"toc-level-indentation\\\";N;s:17:\\\"disable-toc-links\\\";N;s:20:\\\"toc-text-size-shrink\\\";N;s:15:\\\"xsl-style-sheet\\\";N;}s:33:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000env\\\";N;s:37:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000timeout\\\";b:0;s:46:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000defaultExtension\\\";s:3:\\\"pdf\\\";s:18:\\\"\\u0000*\\u0000temporaryFolder\\\";N;s:14:\\\"temporaryFiles\\\";a:0:{}s:36:\\\"\\u0000Knp\\\\Snappy\\\\AbstractGenerator\\u0000logger\\\";O:18:\\\"Psr\\\\Log\\\\NullLogger\\\":0:{}s:2:\\\"fs\\\";O:32:\\\"Illuminate\\\\Filesystem\\\\Filesystem\\\":0:{}}s:10:\\\"\\u0000*\\u0000options\\\";a:0:{}s:4:\\\"html\\\";s:22149:\\\"<!DOCTYPE html>\\n<html lang=\\\"en\\\">\\n    <head>\\n        <meta charset=\\\"utf-8\\\">\\n    <\\/head>\\n    <style>\\n        .subtotales_conceptos{\\n            width:30%;\\n            text-align: right;\\n        }\\n        .subtotales_importes{\\n            text-align: right;\\n        }\\n        .table-totales, .table-totales tr, .table-totales th{\\n            border: 1px solid;\\n        }\\n\\n    <\\/style>\\n    <body>\\n    <div style=\\\"max-height:840px\\\">\\n        <div style=\\\"width: 100%; height:270px\\\"> <!-- Datos de la empresa -->\\n            <table class=\\\"display\\\" cellspacing=\\\"0\\\" width=\\\"100%\\\" style=\\\"border:  1px solid;\\\">\\n                <tr style=\\\"\\\">\\n                    <th colspan=\\\"2\\\" rowspan=\\\"2\\\" style=\\\"width:45%;margin:0;height:150px;\\\">\\n                                                <img src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/img\\/\\/27377183504\\/logo_punto_venta_0000.png\\\"\\/>\\n                                            <\\/th>\\n                    <th style=\\\"border:  1px solid;text-align: center; width:10%\\\" colspan=\\\"2\\\">\\n                        <span style=\\\"font-size: 60px;\\\">C<\\/span> <br \\/> <span style=\\\"font-size: 14px;\\\">cod. 11<\\/span>\\n                    <\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"font-size: 28px;text-align: center;width:45%\\\">\\n                        Factura\\n                        <br>\\n                        0004 - 00000023\\n                    <\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th><\\/th>\\n                    <th style=\\\"border:  1px 1px 1px 0px solid;\\\" colspan=\\\"2\\\"><\\/th>\\n                    <th><\\/th>\\n                <\\/tr>\\n                <tr>\\n\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                                                    Raz&oacute;n Social:\\n                            <span style=\\\"font-weight: normal;\\\">MICAELA AILIN CORIA<\\/span>\\n                                            <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">Fecha de Emisi&oacute;n: <span style=\\\"font-weight: normal;\\\">15\\/07\\/2021<\\/span><\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Domicilio Comercial: <span style=\\\"font-weight: normal;\\\">Victor Guillet esq. Arturo M Bas, C.P.:5800,\\n                        C\\u00f3rdoba<\\/span>\\n                    <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">CUIT: <span style=\\\"font-weight: normal;\\\">27-37718350-4<\\/span><\\/th>\\n                <\\/tr>\\n                <tr>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Condici&oacute;n frente al IVA: <span style=\\\"font-weight: normal;\\\">Monotributo<\\/span>\\n                    <\\/th>\\n                    <th style=\\\"border-right: 1px solid;\\\"><\\/th>\\n                    <th><\\/th>\\n                    <th colspan=\\\"2\\\" style=\\\"text-align:left\\\">\\n                        Ingresos Brutos: <span style=\\\"font-weight: normal;\\\"><\\/span>\\n                        <br>\\n                        Fecha de Inicio de Actividades: <span style=\\\"font-weight: normal;\\\">09\\/07\\/2021<\\/span>\\n                    <\\/th>\\n                <\\/tr>\\n            <\\/table>\\n        <\\/div>\\n\\n        <table style=\\\"text-align: center; width: 100%;border: solid 1px;\\\"> <!-- Fechas -->\\n            <thead>\\n                <tr>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Per\\u00edodo Facturado Desde: 01\\/07\\/2021<\\/small><\\/th>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Per\\u00edodo Facturado Hasta: 31\\/07\\/2021<\\/small><\\/th>\\n                    <th style=\\\"width: 33%;font-size: 14px;text-align: center;\\\"><small>Fecha Vto. Pago: 15\\/07\\/2021<\\/small><\\/th>\\n                <\\/tr>\\n            <\\/thead>\\n        <\\/table>\\n        \\n        <table style=\\\"width: 100%; margin-top: 1%;border: solid 1px;\\\"> <!-- Datos Clientes -->\\n            <tr>\\n                <th style=\\\"text-align:left;\\\"colspan=\\\"12\\\">\\n                    CUIT: <span style=\\\"font-weight: normal;\\\">27-32933499-1<\\/span>\\n                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\\n                    Apellido y Nombre \\/ Raz&oacute;n Social: <span style=\\\"font-weight: normal;\\\">\\n                    RATTAZZI NATALIA ROMINA<\\/span>\\n                <\\/th>\\n            <\\/tr>\\n            <tr>\\n                <th style=\\\"text-align:left; width:50%\\\">\\n                    Condici&oacute;n Frente al IVA: <span style=\\\"font-weight: normal;\\\">IVA Responsable Inscripto<\\/span>\\n                <\\/th>\\n                <th style=\\\"text-align:left; width:50%\\\" colspan=\\\"4\\\">\\n                    Domicilio Comercial:\\n                    <span style=\\\"font-weight: normal;\\\">\\n                    Direccion\\r\\nPJE. LANIN 1661\\r\\nCod. Postal\\r\\n5800\\r\\nProvincia\\r\\nCORDOBA\\r\\nTipo Domicilio\\r\\nFISCAL\\n                    <\\/span>\\n                <\\/th>\\n            <\\/tr>\\n            <tr style=\\\"text-align:left\\\">\\n                <th>Condici&oacute;n de Venta: <span style=\\\"font-weight: normal;\\\">Cuenta Corriente<\\/span><\\/th>\\n            <\\/tr>\\n        <\\/table>\\n\\n        <div style=\\\"border: 1px solid;margin-top: 1%;min-height:600px;\\\">\\n        <table style=\\\"text-align: center; width: 100%; margin-top: 1%;\\\"> <!-- Body -->\\n            <tr style=\\\"border-bottom: 1px solid;font-size: 15px\\\">\\n                <th>C&oacute;digo<\\/th>\\n                <th style=\\\"width: 25%;\\\">Detalle<\\/th>\\n                <th>Cantidad<\\/th>\\n                <th>U.Medida<\\/th>\\n                <th>Precio U.<\\/th>\\n                <th>Bonif. (%)<\\/th>\\n                <th>Precio Bonif.<\\/th>\\n                <th>Subtotal<\\/th>\\n                            <\\/tr>\\n            <tbody>\\n                                                                                <tr style=\\\"font-size: 12px;\\\">\\n                        <td>\\n                            \\n                        <\\/td>\\n                        <td>\\n                            Honorarios profesionales Julio 2021\\n                        <\\/td>\\n                        <td>\\n                            1.00\\n                        <\\/td>\\n                        <td>\\n                            Unidades\\n                        <\\/td>\\n                        <td>                            5.200,00\\n                                                    <\\/td>\\n                        <td>\\n                            0,00%\\n                        <\\/td>\\n                        <td>\\n                            0,00\\n                        <\\/td>\\n                        <td>\\n                            5.200,00\\n                        <\\/td>\\n                                            <\\/tr>\\n                    \\n            <\\/tbody>\\n        <\\/table>\\n        <\\/div>\\n\\n        \\n\\n        <div style=\\\"height:200px;margin-top: 1%;\\\"> <!-- Totales -->\\n              <!-- Es factura B o C -->\\n                <table class=\\\"table-totales\\\" cellspacing=\\\"0\\\" width=\\\"100%\\\">\\n                    <tr>\\n                        <th style=\\\"width:50%; text-align:left;\\\">\\n\\n<!--                                <span style=\\\"width:100%;\\\"><img src=\\\"\\/home\\/forge\\/taxes.com.ar\\/public\\/storage\\/barcodes\\/71304902495049.png\\\"><\\/span>\\n                                <span style=\\\"text-align:center;\\\">2737718350411000471304902495049202107253<\\/span>-->\\n                        <\\/th>\\n                        <th class=\\\"subtotales_conceptos\\\">TOTAL:<\\/th>\\n                        <th class=\\\"subtotales_importes\\\">$ 5.200,00<\\/th>\\n                    <\\/tr>\\n                <\\/table>\\n                <br>\\n                <table cellspacing=\\\"0\\\" width=\\\"100%\\\" style=\\\"border: none\\\">\\n                    <tr>\\n                        <th style=\\\"width:50%; text-align:left;\\\">\\n\\n                            <?xml version=\\\"1.0\\\" encoding=\\\"UTF-8\\\"?>\\n<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" version=\\\"1.1\\\" width=\\\"100\\\" height=\\\"100\\\" viewBox=\\\"0 0 100 100\\\"><rect x=\\\"0\\\" y=\\\"0\\\" width=\\\"100\\\" height=\\\"100\\\" fill=\\\"#ffffff\\\"\\/><g transform=\\\"scale(1.754)\\\"><g transform=\\\"translate(0,0)\\\"><path fill-rule=\\\"evenodd\\\" d=\\\"M8 0L8 1L10 1L10 0ZM14 0L14 2L13 2L13 1L12 1L12 2L11 2L11 3L10 3L10 2L8 2L8 5L10 5L10 4L11 4L11 3L12 3L12 5L11 5L11 6L10 6L10 7L9 7L9 6L8 6L8 7L9 7L9 8L8 8L8 9L7 9L7 8L6 8L6 9L7 9L7 10L5 10L5 9L4 9L4 8L0 8L0 9L1 9L1 11L0 11L0 15L1 15L1 13L2 13L2 12L3 12L3 13L4 13L4 16L2 16L2 17L4 17L4 18L3 18L3 19L2 19L2 18L0 18L0 19L2 19L2 22L4 22L4 23L1 23L1 22L0 22L0 25L1 25L1 27L0 27L0 30L1 30L1 27L4 27L4 29L3 29L3 28L2 28L2 29L3 29L3 30L2 30L2 31L0 31L0 32L2 32L2 33L0 33L0 34L1 34L1 35L0 35L0 41L1 41L1 42L2 42L2 41L1 41L1 38L2 38L2 39L3 39L3 38L4 38L4 37L3 37L3 36L5 36L5 34L6 34L6 35L7 35L7 34L10 34L10 33L11 33L11 32L12 32L12 34L15 34L15 36L14 36L14 35L12 35L12 36L11 36L11 35L9 35L9 37L10 37L10 38L9 38L9 40L12 40L12 42L13 42L13 43L11 43L11 42L10 42L10 41L8 41L8 38L6 38L6 37L8 37L8 36L6 36L6 37L5 37L5 39L7 39L7 40L4 40L4 41L3 41L3 42L5 42L5 43L7 43L7 44L4 44L4 43L0 43L0 44L1 44L1 46L0 46L0 48L5 48L5 47L8 47L8 48L6 48L6 49L8 49L8 50L9 50L9 51L10 51L10 52L9 52L9 53L8 53L8 57L9 57L9 55L11 55L11 56L12 56L12 55L13 55L13 54L14 54L14 53L16 53L16 54L17 54L17 55L18 55L18 56L17 56L17 57L18 57L18 56L19 56L19 57L21 57L21 55L22 55L22 53L21 53L21 55L18 55L18 54L20 54L20 51L21 51L21 52L23 52L23 50L24 50L24 53L25 53L25 54L23 54L23 56L22 56L22 57L24 57L24 56L26 56L26 55L25 55L25 54L27 54L27 53L31 53L31 54L33 54L33 55L32 55L32 56L34 56L34 57L36 57L36 55L38 55L38 56L37 56L37 57L44 57L44 56L43 56L43 55L42 55L42 56L41 56L41 55L40 55L40 54L42 54L42 53L40 53L40 52L43 52L43 53L45 53L45 52L46 52L46 51L45 51L45 49L47 49L47 48L48 48L48 50L47 50L47 53L46 53L46 54L44 54L44 55L45 55L45 56L46 56L46 57L48 57L48 55L50 55L50 57L51 57L51 55L50 55L50 54L49 54L49 53L51 53L51 54L52 54L52 53L55 53L55 54L56 54L56 53L57 53L57 51L56 51L56 49L57 49L57 48L56 48L56 49L55 49L55 51L53 51L53 49L54 49L54 48L53 48L53 46L54 46L54 45L56 45L56 46L55 46L55 47L57 47L57 44L53 44L53 46L52 46L52 43L51 43L51 44L50 44L50 42L51 42L51 41L50 41L50 40L52 40L52 42L54 42L54 43L55 43L55 42L57 42L57 40L56 40L56 38L57 38L57 31L56 31L56 30L57 30L57 27L56 27L56 24L57 24L57 21L56 21L56 20L53 20L53 19L54 19L54 18L55 18L55 14L54 14L54 10L53 10L53 9L55 9L55 10L56 10L56 11L55 11L55 12L57 12L57 8L56 8L56 9L55 9L55 8L52 8L52 10L51 10L51 11L50 11L50 10L49 10L49 9L50 9L50 8L48 8L48 7L49 7L49 6L48 6L48 7L47 7L47 5L48 5L48 0L45 0L45 1L43 1L43 0L39 0L39 1L41 1L41 4L40 4L40 5L39 5L39 2L38 2L38 1L37 1L37 2L36 2L36 1L32 1L32 2L31 2L31 0L30 0L30 1L29 1L29 0L28 0L28 1L26 1L26 0L24 0L24 1L23 1L23 0L22 0L22 1L23 1L23 2L22 2L22 3L21 3L21 4L20 4L20 5L21 5L21 4L22 4L22 11L20 11L20 12L19 12L19 10L20 10L20 9L21 9L21 8L20 8L20 7L21 7L21 6L20 6L20 7L19 7L19 6L18 6L18 7L17 7L17 6L16 6L16 7L15 7L15 6L14 6L14 5L13 5L13 4L14 4L14 3L15 3L15 5L17 5L17 4L16 4L16 3L17 3L17 2L18 2L18 1L17 1L17 2L15 2L15 1L16 1L16 0ZM19 1L19 2L21 2L21 1ZM25 1L25 2L23 2L23 3L22 3L22 4L23 4L23 3L24 3L24 5L23 5L23 12L22 12L22 13L23 13L23 14L24 14L24 16L23 16L23 15L22 15L22 14L20 14L20 13L19 13L19 12L18 12L18 10L19 10L19 9L20 9L20 8L18 8L18 9L17 9L17 8L15 8L15 7L14 7L14 6L13 6L13 5L12 5L12 6L11 6L11 7L10 7L10 8L9 8L9 9L8 9L8 10L7 10L7 11L5 11L5 10L3 10L3 9L2 9L2 11L3 11L3 12L4 12L4 13L5 13L5 16L7 16L7 17L6 17L6 18L4 18L4 19L6 19L6 20L5 20L5 21L6 21L6 22L7 22L7 21L8 21L8 20L7 20L7 19L6 19L6 18L9 18L9 20L10 20L10 21L9 21L9 22L8 22L8 23L6 23L6 24L5 24L5 23L4 23L4 24L1 24L1 25L4 25L4 26L5 26L5 25L6 25L6 26L8 26L8 24L9 24L9 25L10 25L10 24L9 24L9 22L10 22L10 23L11 23L11 25L12 25L12 27L16 27L16 28L14 28L14 29L15 29L15 30L16 30L16 28L17 28L17 27L19 27L19 28L18 28L18 32L17 32L17 31L15 31L15 32L14 32L14 33L15 33L15 34L16 34L16 35L17 35L17 36L16 36L16 37L17 37L17 38L15 38L15 37L14 37L14 36L12 36L12 38L10 38L10 39L12 39L12 40L13 40L13 39L14 39L14 41L13 41L13 42L14 42L14 43L13 43L13 45L14 45L14 46L13 46L13 47L15 47L15 48L11 48L11 46L12 46L12 45L11 45L11 46L8 46L8 47L9 47L9 48L10 48L10 49L9 49L9 50L10 50L10 51L11 51L11 53L9 53L9 54L11 54L11 53L12 53L12 54L13 54L13 53L12 53L12 52L13 52L13 49L14 49L14 52L15 52L15 49L16 49L16 53L17 53L17 52L18 52L18 53L19 53L19 51L20 51L20 48L22 48L22 49L23 49L23 48L22 48L22 47L24 47L24 46L22 46L22 44L23 44L23 45L25 45L25 46L27 46L27 44L28 44L28 47L26 47L26 48L24 48L24 50L25 50L25 49L26 49L26 48L28 48L28 47L29 47L29 48L30 48L30 47L32 47L32 50L31 50L31 51L32 51L32 50L33 50L33 51L35 51L35 52L36 52L36 53L35 53L35 55L34 55L34 56L35 56L35 55L36 55L36 53L37 53L37 54L38 54L38 55L39 55L39 56L40 56L40 55L39 55L39 53L37 53L37 51L38 51L38 52L40 52L40 50L41 50L41 51L42 51L42 50L43 50L43 51L44 51L44 49L45 49L45 48L46 48L46 46L47 46L47 45L48 45L48 44L49 44L49 42L50 42L50 41L4