-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db27-29007005-3
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-08-17 20:42:21','Actividad Generica 1','000001',NULL),(2,NULL,'2022-08-17 20:42:21','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL),('2023-1','2023-01',2023,1,'2023-01-01','2023-01-31',1202.9790,NULL,NULL,NULL),('2023-2','2023-02',2023,2,'2023-02-01','2023-02-28',1282.7091,NULL,NULL,NULL),('2023-3','2023-03',2023,3,'2023-03-01','2023-03-31',1381.1601,NULL,NULL,NULL),('2023-4','2023-04',2023,4,'2023-04-01','2023-04-30',1497.2147,NULL,NULL,NULL),('2023-5','2023-05',2023,5,'2023-05-01','2023-05-31',1613.5895,NULL,NULL,NULL),('2023-6','2023-06',2023,6,'2023-06-01','2023-06-30',1709.6115,NULL,NULL,NULL),('2023-7','2023-07',2023,7,'2023-07-01','2023-07-31',1818.0838,NULL,NULL,NULL),('2023-8','2023-08',2023,8,'2023-08-01','2023-08-31',2044.2832,NULL,NULL,NULL),('2023-9','2023-09',2023,9,'2023-09-01','2023-09-30',2304.9242,NULL,NULL,NULL),('2023-10','2023-10',2023,10,'2023-10-01','2023-10-31',2496.2730,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_recibidas`
--

DROP TABLE IF EXISTS `api_recibidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_recibidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` json NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_recibidas_person_id_foreign` (`person_id`),
  CONSTRAINT `api_recibidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_recibidas`
--

LOCK TABLES `api_recibidas` WRITE;
/*!40000 ALTER TABLE `api_recibidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_recibidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
INSERT INTO `back_up_charlas_details` VALUES (1,'',40882,'2025-01-18'),(2,'',40882,'2025-01-18'),(3,'',40899,'2025-04-17');
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=107 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
INSERT INTO `back_up_claves_details` VALUES (1,NULL,'V1l4sf3d3r3r',NULL,1,40720,'2022-10-22'),(2,NULL,'V1l4sf3d3r3r',NULL,1,40720,'2022-10-22'),(3,NULL,'V1l4sf3d3r3r',NULL,1,40720,'2022-10-22'),(4,NULL,'V1l4sf3d3r3r',NULL,1,40720,'2022-10-22'),(5,NULL,'V1l4sf3d3r3r',NULL,1,40720,'2022-10-22'),(6,NULL,'V1l4sf3d3r3r',NULL,1,40720,'2022-10-22'),(7,NULL,'V1l4sf3d3r3r',NULL,1,40720,'2022-10-22'),(8,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2022-10-22'),(9,NULL,'V1l4sf3d3r3r',NULL,1,40720,'2022-10-23'),(10,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2022-10-23'),(11,NULL,'V1l4sf3d3r3r',NULL,1,40720,'2022-10-23'),(12,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2022-10-23'),(13,NULL,'V1l4sf3d3r3r',NULL,1,40720,'2022-12-21'),(14,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2022-12-21'),(15,NULL,'V1l4sf3d3r3r',NULL,1,40720,'2022-12-21'),(16,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2022-12-21'),(17,NULL,'V1l4sf3d3r3r',NULL,1,40720,'2022-12-21'),(18,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2022-12-21'),(19,NULL,'V1l4sf3d3r3r',NULL,1,40720,'2022-12-21'),(20,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2022-12-21'),(21,NULL,'V1l4sf3d3r3r',NULL,1,40720,'2022-12-21'),(22,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2022-12-21'),(23,NULL,'V1l4sf3d3r3r',NULL,1,40720,'2022-12-21'),(24,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2022-12-21'),(25,NULL,'V1l4sf3d3r3r',NULL,1,40720,'2022-12-21'),(26,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2022-12-21'),(27,NULL,'V1l4sf3d3r3r',NULL,1,40720,'2023-01-23'),(28,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2023-01-23'),(29,NULL,'V1l4sf3d3r3r',NULL,1,40720,'2023-01-23'),(30,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2023-01-23'),(31,NULL,'F3d3r3rv1l4s',NULL,1,40720,'2023-01-23'),(32,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2023-01-23'),(33,NULL,'F3d3r3rv1l4s',NULL,1,40720,'2023-01-23'),(34,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2023-01-23'),(35,NULL,'F3d3r3rv1l4s',NULL,1,40720,'2023-01-23'),(36,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2023-01-23'),(37,NULL,'F3d3r3rv1l4s',NULL,1,40720,'2023-02-20'),(38,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2023-02-20'),(39,NULL,'F3d3r3rv1l4s',NULL,1,40720,'2023-04-19'),(40,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2023-04-19'),(41,'AFIP','VianoDa0409',NULL,1,40719,'2023-05-12'),(42,'AFIP','VianoDa0409',NULL,1,40719,'2023-05-13'),(43,'AFIP','VianoDa0409',NULL,1,40719,'2023-05-13'),(44,'AFIP','VianoDa0409',NULL,1,40719,'2023-05-13'),(45,'AFIP','VianoDa0409',NULL,1,40719,'2023-05-16'),(46,'AFIP','VianoDa0409',NULL,1,40719,'2023-05-16'),(47,'AFIP','F3d3r3rv1l4s',NULL,1,40720,'2023-05-16'),(48,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2023-05-16'),(49,'AFIP','F3d3r3rv1l4s',NULL,1,40720,'2023-05-23'),(50,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2023-05-23'),(51,'AFIP','VianoDa0409',NULL,1,40719,'2023-06-17'),(52,'AFIP','F3d3r3rv1l4s',NULL,1,40720,'2023-06-19'),(53,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2023-06-19'),(54,'AFIP','F3d3r3rv1l4s',NULL,1,40720,'2023-07-13'),(55,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2023-07-13'),(56,'AFIP','VianoDa0409',NULL,1,40719,'2023-07-15'),(57,'AFIP','VianoDa0409',NULL,1,40719,'2023-07-15'),(58,'AFIP','VianoDa0409',NULL,1,40719,'2023-08-17'),(59,'AFIP','VianoDa0409',NULL,1,40719,'2023-09-15'),(60,'AFIP','F3d3r3rv1l4s',NULL,1,40720,'2023-10-19'),(61,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2023-10-19'),(62,'AFIP','F3d3r3rv1l4s',NULL,1,40720,'2023-10-19'),(63,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2023-10-19'),(64,'AFIP','f3d3r3rv1l4S',NULL,1,40720,'2023-11-18'),(65,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2023-11-18'),(66,'AFIP','f3d3r3rv1l4S',NULL,1,40720,'2023-12-20'),(67,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2023-12-20'),(68,'AFIP','f3d3r3rv1l4S',NULL,1,40720,'2024-01-15'),(69,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2024-01-15'),(70,'AFIP','f3d3r3rv1l4S',NULL,1,40720,'2024-03-16'),(71,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2024-03-16'),(72,'AFIP','f3d3r3rv1l4S',NULL,1,40720,'2024-04-18');
INSERT INTO `back_up_claves_details` VALUES (73,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2024-04-18'),(74,'AFIP','f3d3r3rv1l4S',NULL,1,40720,'2024-07-15'),(75,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2024-07-15'),(76,'AFIP','f3d3r3rv1l4S',NULL,1,40720,'2024-07-15'),(77,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2024-07-15'),(78,'AFIP','f3d3r3rv1l4S',NULL,1,40720,'2024-08-17'),(79,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2024-08-17'),(80,'AFIP','f3d3r3rv1l4S',NULL,1,40720,'2024-09-14'),(81,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2024-09-14'),(82,'AFIP','f3d3r3rv1l4S',NULL,1,40720,'2024-10-21'),(83,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2024-10-21'),(84,'AFIP','VianoDa0409',NULL,1,40719,'2024-12-12'),(85,'AFIP','VianoDa0409',NULL,1,40719,'2024-12-13'),(86,'AFIP','VianoDa0409',NULL,1,40719,'2024-12-13'),(87,'AFIP','f3d3r3rv1l4S',NULL,1,40720,'2024-12-13'),(88,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2024-12-13'),(89,'AFIP','f3d3r3rv1l4S',NULL,1,40720,'2025-01-18'),(90,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2025-01-18'),(91,'AFIP','f3d3r3rv1l4S',NULL,1,40720,'2025-01-18'),(92,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2025-01-18'),(93,'AFIP','f3d3r3rv1l4S',NULL,1,40720,'2025-01-22'),(94,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2025-01-22'),(95,'AFIP','f3d3r3rv1l4S',NULL,1,40720,'2025-01-22'),(96,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2025-01-22'),(97,'AFIP','VianoDa0409',NULL,1,40719,'2025-01-27'),(98,'AFIP','ViCami0409',NULL,1,40719,'2025-01-27'),(99,'AFIP','f3d3r3rv1l4S',NULL,1,40720,'2025-02-19'),(100,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2025-02-19'),(101,'AFIP','ViCami0409',NULL,1,40719,'2025-02-19'),(102,'AFIP','ViCami0409',NULL,1,40719,'2025-03-20'),(103,'AFIP','f3d3r3rv1l4S',NULL,1,40720,'2025-03-20'),(104,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2025-03-20'),(105,'AFIP','f3d3r3rv1l4S',NULL,1,40720,'2025-05-19'),(106,'Rentas Nqn','Leonardo1973',NULL,41,40720,'2025-05-19');
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=68 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2022-10-22'),(2,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2022-10-22'),(3,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2022-10-22'),(4,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2022-10-22'),(5,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2022-10-22'),(6,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2022-10-22'),(7,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2022-10-22'),(8,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2022-10-23'),(9,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2022-10-23'),(10,'danielaviano322@hotmail.com','2994022597',NULL,1,40719,'2022-10-23'),(11,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2022-12-21'),(12,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2022-12-21'),(13,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2022-12-21'),(14,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2022-12-21'),(15,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2022-12-21'),(16,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2022-12-21'),(17,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2022-12-21'),(18,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2023-01-23'),(19,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2023-01-23'),(20,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2023-01-23'),(21,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2023-01-23'),(22,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2023-01-23'),(23,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2023-02-20'),(24,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2023-04-19'),(25,'danielaviano322@hotmail.com','2994022597','',1,40719,'2023-05-12'),(26,'danielaviano322@hotmail.com','2994022597','',1,40719,'2023-05-12'),(27,'danielaviano322@hotmail.com','2994022597','',1,40719,'2023-05-13'),(28,'danielaviano322@hotmail.com','2994022597','',1,40719,'2023-05-13'),(29,'danielaviano322@hotmail.com','2994022597','',1,40719,'2023-05-13'),(30,'danielaviano322@hotmail.com','2994022597','',1,40719,'2023-05-16'),(31,'danielaviano322@hotmail.com','2994022597',NULL,1,40719,'2023-05-16'),(32,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2023-05-16'),(33,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2023-05-23'),(34,'danielaviano322@hotmail.com','2994022597',NULL,1,40719,'2023-06-17'),(35,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2023-06-19'),(36,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2023-07-13'),(37,'danielaviano322@hotmail.com','2994022597',NULL,1,40719,'2023-07-15'),(38,'danielaviano322@hotmail.com','2994022597',NULL,1,40719,'2023-07-15'),(39,'danielaviano322@hotmail.com','2994022597',NULL,1,40719,'2023-08-17'),(40,'danielaviano322@hotmail.com','2994022597',NULL,1,40719,'2023-09-15'),(41,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2023-10-19'),(42,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2023-10-19'),(43,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2023-11-18'),(44,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2023-12-20'),(45,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2024-01-15'),(46,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2024-03-16'),(47,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2024-04-18'),(48,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2024-07-15'),(49,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2024-07-15'),(50,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2024-08-17'),(51,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2024-09-14'),(52,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2024-10-21'),(53,'danielaviano322@hotmail.com','2994022597',NULL,1,40719,'2024-12-12'),(54,'danielaviano322@hotmail.com','2994022597','',1,40719,'2024-12-13'),(55,'danielaviano322@hotmail.com','2994022597','',1,40719,'2024-12-13'),(56,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2024-12-13'),(57,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2025-01-18'),(58,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2025-01-18');
INSERT INTO `back_up_mails_details` VALUES (59,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2025-01-22'),(60,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2025-01-22'),(61,'danielaviano322@hotmail.com','2994022597','',1,40719,'2025-01-27'),(62,'danielaviano322@hotmail.com','2994022597','',1,40719,'2025-01-27'),(63,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2025-02-19'),(64,'danielaviano322@hotmail.com','2994022597','',1,40719,'2025-02-19'),(65,'danielaviano322@hotmail.com','2994022597','',1,40719,'2025-03-20'),(66,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2025-03-20'),(67,'leoglowa@yahoo.com.ar','2995284292','',1,40720,'2025-05-19');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `origin_id` bigint(20) unsigned DEFAULT NULL,
  `origin_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2833 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,7566,40720,1524,2,1,'App\\Models\\Receipt',1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',109080.74,NULL,NULL,1,'2022-08-19 17:24:23','2022-08-19 17:24:23',NULL),(2,7566,40720,1524,2,2,'App\\Models\\Receipt',2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',112933.47,NULL,NULL,1,'2022-08-19 17:27:19','2022-08-19 17:27:19',NULL),(3,7566,40720,1524,2,3,'App\\Models\\Receipt',3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',6793.16,NULL,NULL,1,'2022-08-19 17:32:07','2022-08-19 17:32:07',NULL),(4,7566,40720,1524,2,4,'App\\Models\\Receipt',4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',5074.01,NULL,NULL,1,'2022-08-19 17:35:00','2022-08-19 17:35:00',NULL),(5,7566,40720,1524,2,5,'App\\Models\\Receipt',5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',206985.15,NULL,NULL,1,'2022-08-19 17:44:24','2022-08-19 17:44:24',NULL),(6,7566,40720,1524,3,6,'App\\Models\\Receipt',6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',45999.00,NULL,NULL,1,'2022-08-19 17:51:49','2022-08-19 17:51:49',NULL),(7,7566,40720,1524,3,7,'App\\Models\\Receipt',7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',6900.00,NULL,NULL,1,'2022-08-19 17:55:03','2022-08-19 17:55:03',NULL),(8,7566,40720,1524,3,8,'App\\Models\\Receipt',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',2140.01,NULL,NULL,1,'2022-08-19 18:00:01','2022-08-19 18:00:01',NULL),(9,7566,40720,1524,3,9,'App\\Models\\Receipt',9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',2016.37,NULL,NULL,1,'2022-08-19 18:04:26','2022-08-19 18:04:26',NULL),(10,7566,40720,1524,3,10,'App\\Models\\Receipt',10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',6801.79,NULL,NULL,1,'2022-08-19 18:08:32','2022-08-19 18:09:23','2022-08-19 18:09:23'),(11,7566,40720,1524,3,10,'App\\Models\\Receipt',10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',6801.82,NULL,NULL,1,'2022-08-19 18:09:23','2023-11-18 12:30:55','2023-11-18 12:30:55'),(12,7566,40720,1524,3,11,'App\\Models\\Receipt',11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',8027.67,NULL,NULL,1,'2022-08-19 18:11:54','2023-11-18 12:30:45','2023-11-18 12:30:45'),(13,7566,40720,1524,3,12,'App\\Models\\Receipt',12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',6692.62,NULL,NULL,1,'2022-08-19 18:13:33','2023-11-18 12:30:34','2023-11-18 12:30:34'),(14,7566,40720,1524,3,13,'App\\Models\\Receipt',13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',23931.28,NULL,NULL,1,'2022-08-19 18:20:41','2023-11-18 12:30:10','2023-11-18 12:30:10'),(15,7566,40720,1524,3,14,'App\\Models\\Receipt',14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',845.00,NULL,NULL,1,'2022-08-19 18:21:47','2023-11-18 12:29:54','2023-11-18 12:29:54'),(16,7566,40720,1524,3,15,'App\\Models\\Receipt',15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1765.00,NULL,NULL,1,'2022-08-19 18:23:17','2022-08-22 16:57:04','2022-08-22 16:57:04'),(17,7566,40720,1524,3,16,'App\\Models\\Receipt',16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1405.00,NULL,NULL,1,'2022-08-19 18:24:44','2022-08-22 16:57:32','2022-08-22 16:57:32'),(18,7566,40720,1524,3,17,'App\\Models\\Receipt',17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',5343.97,NULL,NULL,1,'2022-08-19 18:30:31','2022-08-22 19:02:03','2022-08-22 19:02:03'),(19,7566,40720,1524,3,18,'App\\Models\\Receipt',18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',4802.60,NULL,NULL,1,'2022-08-19 18:32:28','2022-08-22 19:01:39','2022-08-22 19:01:39'),(20,7566,40720,1524,3,19,'App\\Models\\Receipt',19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',11600.00,NULL,NULL,1,'2022-08-19 18:34:43','2022-08-22 19:00:57','2022-08-22 19:00:57'),(21,7566,40720,1524,8,20,'App\\Models\\Receipt',20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',26895.40,NULL,NULL,1,'2022-08-19 18:40:50','2022-08-19 18:40:50',NULL);
INSERT INTO `balance_libro` VALUES (22,7566,40720,1524,8,21,'App\\Models\\Receipt',21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',37.69,NULL,NULL,1,'2022-08-19 18:41:05','2022-08-19 18:41:05',NULL),(23,7566,40720,1524,3,22,'App\\Models\\Receipt',22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2400.00,NULL,NULL,1,'2022-08-19 19:10:59','2022-08-22 19:00:40','2022-08-22 19:00:40'),(24,7566,40720,1524,3,23,'App\\Models\\Receipt',23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5041.90,NULL,NULL,1,'2022-08-19 19:16:06','2022-08-22 19:00:25','2022-08-22 19:00:25'),(25,7566,40720,1524,3,24,'App\\Models\\Receipt',24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',4527.67,NULL,NULL,1,'2022-08-19 19:18:29','2022-08-22 18:53:23','2022-08-22 18:53:23'),(26,7566,40720,1524,3,25,'App\\Models\\Receipt',25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5696.44,NULL,NULL,1,'2022-08-19 19:24:11','2022-08-22 16:55:09','2022-08-22 16:55:09'),(27,7566,40720,1524,3,26,'App\\Models\\Receipt',26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',10875.00,NULL,NULL,1,'2022-08-19 19:27:20','2022-08-22 18:52:51','2022-08-22 18:52:51'),(28,7566,40720,1524,3,27,'App\\Models\\Receipt',27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',34561.42,NULL,NULL,1,'2022-08-19 19:29:31','2022-08-22 18:52:25','2022-08-22 18:52:25'),(29,7566,40720,1524,7,28,'App\\Models\\Receipt',28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',943.18,NULL,NULL,1,'2022-08-19 19:31:41','2022-08-19 19:31:41',NULL),(30,7566,40720,1524,7,29,'App\\Models\\Receipt',29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',3421.24,NULL,NULL,1,'2022-08-19 19:34:35','2022-08-19 19:34:35',NULL),(31,7566,40720,1524,7,30,'App\\Models\\Receipt',30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5456.20,NULL,NULL,1,'2022-08-19 19:35:53','2022-08-19 19:35:53',NULL),(32,7566,40720,1524,7,31,'App\\Models\\Receipt',31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',459.59,NULL,NULL,1,'2022-08-19 19:37:04','2022-08-19 19:37:04',NULL),(33,7566,40720,1524,7,32,'App\\Models\\Receipt',32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',3112.03,NULL,NULL,1,'2022-08-19 19:38:05','2022-08-19 19:38:05',NULL),(34,7566,40720,1524,7,33,'App\\Models\\Receipt',33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',3045.21,NULL,NULL,1,'2022-08-19 20:03:28','2022-08-19 20:03:28',NULL),(35,7566,40720,1524,7,34,'App\\Models\\Receipt',34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',155.86,NULL,NULL,1,'2022-08-19 20:04:22','2022-08-19 20:04:22',NULL),(36,7566,40720,1524,7,35,'App\\Models\\Receipt',35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',512.86,NULL,NULL,1,'2022-08-19 20:04:59','2022-08-19 20:04:59',NULL),(37,7566,40720,1524,7,36,'App\\Models\\Receipt',36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',16699.58,NULL,NULL,1,'2022-08-19 20:06:14','2022-08-19 20:06:14',NULL),(38,7566,40720,1524,3,25,'App\\Models\\Receipt',25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5696.44,NULL,NULL,1,'2022-08-22 16:55:09','2022-08-22 18:53:04','2022-08-22 18:53:04'),(39,7566,40720,1524,3,15,'App\\Models\\Receipt',15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1765.00,NULL,NULL,1,'2022-08-22 16:57:04','2022-08-22 16:57:04',NULL),(40,7566,40720,1524,3,16,'App\\Models\\Receipt',16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1405.00,NULL,NULL,1,'2022-08-22 16:57:32','2022-08-22 19:02:31','2022-08-22 19:02:31'),(41,7566,40720,1524,3,27,'App\\Models\\Receipt',27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',34561.42,NULL,NULL,1,'2022-08-22 18:52:25','2022-08-22 18:52:25',NULL),(42,7566,40720,1524,3,26,'App\\Models\\Receipt',26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',10875.00,NULL,NULL,1,'2022-08-22 18:52:51','2022-08-22 18:52:51',NULL);
INSERT INTO `balance_libro` VALUES (43,7566,40720,1524,3,25,'App\\Models\\Receipt',25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5696.44,NULL,NULL,1,'2022-08-22 18:53:04','2022-08-22 18:53:04',NULL),(44,7566,40720,1524,3,24,'App\\Models\\Receipt',24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',4527.67,NULL,NULL,1,'2022-08-22 18:53:23','2022-08-22 18:53:23',NULL),(45,7566,40720,1524,3,23,'App\\Models\\Receipt',23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',5041.90,NULL,NULL,1,'2022-08-22 19:00:25','2022-08-22 19:00:25',NULL),(46,7566,40720,1524,3,22,'App\\Models\\Receipt',22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',2400.00,NULL,NULL,1,'2022-08-22 19:00:40','2022-08-22 19:00:40',NULL),(47,7566,40720,1524,3,19,'App\\Models\\Receipt',19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',11600.00,NULL,NULL,1,'2022-08-22 19:00:57','2022-08-22 20:24:10','2022-08-22 20:24:10'),(48,7566,40720,1524,3,18,'App\\Models\\Receipt',18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',4802.60,NULL,NULL,1,'2022-08-22 19:01:39','2022-08-22 19:01:39',NULL),(49,7566,40720,1524,3,17,'App\\Models\\Receipt',17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',5343.97,NULL,NULL,1,'2022-08-22 19:02:03','2022-08-22 19:02:03',NULL),(50,7566,40720,1524,3,16,'App\\Models\\Receipt',16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1405.00,NULL,NULL,1,'2022-08-22 19:02:31','2022-08-22 19:02:31',NULL),(51,7566,40720,1524,3,37,'App\\Models\\Receipt',37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',29500.01,NULL,NULL,1,'2022-08-22 19:13:27','2022-08-22 19:15:37','2022-08-22 19:15:37'),(52,7566,40720,1524,3,37,'App\\Models\\Receipt',37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',29500.01,NULL,NULL,1,'2022-08-22 19:15:37','2022-08-22 19:15:37',NULL),(53,7566,40720,1524,3,38,'App\\Models\\Receipt',38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',136.13,NULL,NULL,1,'2022-08-22 19:24:08','2022-08-22 19:25:47','2022-08-22 19:25:47'),(54,7566,40720,1524,3,38,'App\\Models\\Receipt',38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',11250.00,NULL,NULL,1,'2022-08-22 19:25:47','2022-08-22 19:25:47',NULL),(55,7566,40720,1524,3,19,'App\\Models\\Receipt',19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',11600.00,NULL,NULL,1,'2022-08-22 20:24:10','2022-08-22 20:24:10',NULL),(56,7566,40720,1526,2,39,'App\\Models\\Receipt',39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',136708.14,NULL,NULL,1,'2022-10-22 20:46:25','2022-10-22 20:46:25',NULL),(57,7566,40720,1526,2,40,'App\\Models\\Receipt',40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',128462.76,NULL,NULL,1,'2022-10-22 20:46:25','2022-10-22 20:46:25',NULL),(58,7566,40720,1526,2,41,'App\\Models\\Receipt',41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',6961.17,NULL,NULL,1,'2022-10-22 20:46:25','2022-10-22 20:46:25',NULL),(59,7566,40720,1526,2,42,'App\\Models\\Receipt',42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',5792.60,NULL,NULL,1,'2022-10-22 20:46:25','2022-10-22 20:46:25',NULL),(60,7566,40720,1526,2,43,'App\\Models\\Receipt',43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',248448.11,NULL,NULL,1,'2022-10-22 20:46:25','2022-10-22 20:46:25',NULL),(61,7566,40720,1525,2,44,'App\\Models\\Receipt',44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',115700.54,NULL,NULL,1,'2022-10-22 20:48:03','2022-10-22 20:48:03',NULL),(62,7566,40720,1525,2,45,'App\\Models\\Receipt',45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',120276.72,NULL,NULL,1,'2022-10-22 20:48:03','2022-10-22 20:48:03',NULL),(63,7566,40720,1525,2,46,'App\\Models\\Receipt',46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',5611.56,NULL,NULL,1,'2022-10-22 20:48:03','2022-10-22 20:48:03',NULL);
INSERT INTO `balance_libro` VALUES (64,7566,40720,1525,2,47,'App\\Models\\Receipt',47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',4643.22,NULL,NULL,1,'2022-10-22 20:48:03','2022-10-22 20:48:03',NULL),(65,7566,40720,1525,2,48,'App\\Models\\Receipt',48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',227341.84,NULL,NULL,1,'2022-10-22 20:48:03','2022-10-22 20:48:03',NULL),(66,7566,40720,1525,3,49,'App\\Models\\Receipt',49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',2400.00,NULL,NULL,1,'2022-10-22 21:17:18','2022-10-22 22:45:53','2022-10-22 22:45:53'),(67,7566,40720,1525,3,50,'App\\Models\\Receipt',50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',3900.00,NULL,NULL,1,'2022-10-22 21:17:18','2022-10-22 21:17:18',NULL),(68,7566,40720,1525,3,51,'App\\Models\\Receipt',51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',1950.00,NULL,NULL,1,'2022-10-22 21:17:18','2022-10-22 21:17:18',NULL),(69,7566,40720,1525,3,52,'App\\Models\\Receipt',52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',3009.98,NULL,NULL,1,'2022-10-22 21:17:18','2022-10-22 22:24:30','2022-10-22 22:24:30'),(70,7566,40720,1525,3,53,'App\\Models\\Receipt',53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',4000.00,NULL,NULL,1,'2022-10-22 21:17:18','2022-10-22 21:17:18',NULL),(71,7566,40720,1525,3,54,'App\\Models\\Receipt',54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',2880.00,NULL,NULL,1,'2022-10-22 21:17:18','2022-10-22 21:17:18',NULL),(72,7566,40720,1525,3,55,'App\\Models\\Receipt',55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',2900.00,NULL,NULL,1,'2022-10-22 21:17:18','2022-10-22 21:17:18',NULL),(73,7566,40720,1525,3,56,'App\\Models\\Receipt',56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',1694.50,NULL,NULL,1,'2022-10-22 21:17:18','2023-11-18 12:38:32','2023-11-18 12:38:32'),(74,7566,40720,1525,3,57,'App\\Models\\Receipt',57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',3484.20,NULL,NULL,1,'2022-10-22 21:17:18','2022-10-22 22:27:26','2022-10-22 22:27:26'),(75,7566,40720,1525,3,58,'App\\Models\\Receipt',58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',2720.00,NULL,NULL,1,'2022-10-22 21:17:18','2022-10-22 21:17:18',NULL),(76,7566,40720,1525,3,59,'App\\Models\\Receipt',59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',4688.00,NULL,NULL,1,'2022-10-22 21:17:18','2022-10-22 21:17:18',NULL),(77,7566,40720,1525,3,60,'App\\Models\\Receipt',60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',2520.00,NULL,NULL,1,'2022-10-22 21:17:18','2022-10-22 21:17:18',NULL),(78,7566,40720,1525,3,61,'App\\Models\\Receipt',61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',3684.92,NULL,NULL,1,'2022-10-22 21:23:57','2022-10-22 21:23:57',NULL),(79,7566,40720,1525,3,62,'App\\Models\\Receipt',62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',2400.00,NULL,NULL,1,'2022-10-22 21:27:16','2022-10-22 22:04:30','2022-10-22 22:04:30'),(80,7566,40720,1525,3,63,'App\\Models\\Receipt',63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',4840.44,NULL,NULL,1,'2022-10-22 21:28:47','2022-10-22 21:28:47',NULL),(81,7566,40720,1525,3,64,'App\\Models\\Receipt',64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',13900.00,NULL,NULL,1,'2022-10-22 21:30:13','2022-10-22 22:04:59','2022-10-22 22:04:59'),(82,7566,40720,1525,3,65,'App\\Models\\Receipt',65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',5484.10,NULL,NULL,1,'2022-10-22 21:31:47','2022-10-22 22:06:03','2022-10-22 22:06:03'),(83,7566,40720,1525,3,66,'App\\Models\\Receipt',66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-15','2022-08-15',17298.99,NULL,NULL,1,'2022-10-22 21:33:20','2022-10-22 21:33:20',NULL),(84,7566,40720,1525,3,67,'App\\Models\\Receipt',67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',4500.00,NULL,NULL,1,'2022-10-22 21:34:38','2022-10-22 21:34:38',NULL);
INSERT INTO `balance_libro` VALUES (85,7566,40720,1525,3,68,'App\\Models\\Receipt',68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',5847.97,NULL,NULL,1,'2022-10-22 21:37:50','2022-10-22 21:37:50',NULL),(86,7566,40720,1525,3,69,'App\\Models\\Receipt',69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',2870.00,NULL,NULL,1,'2022-10-22 21:39:17','2022-10-22 21:39:17',NULL),(87,7566,40720,1525,3,70,'App\\Models\\Receipt',70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',39325.00,NULL,NULL,1,'2022-10-22 21:40:21','2022-10-22 21:40:21',NULL),(88,7566,40720,1525,3,71,'App\\Models\\Receipt',71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',24200.00,NULL,NULL,1,'2022-10-22 21:40:52','2022-10-22 21:40:52',NULL),(89,7566,40720,1525,3,72,'App\\Models\\Receipt',72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',30734.00,NULL,NULL,1,'2022-10-22 21:42:24','2022-10-22 21:42:24',NULL),(90,7566,40720,1525,3,73,'App\\Models\\Receipt',73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',3500.00,NULL,NULL,1,'2022-10-22 21:43:11','2022-10-22 21:43:11',NULL),(91,7566,40720,1525,3,74,'App\\Models\\Receipt',74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',21175.00,NULL,NULL,1,'2022-10-22 21:44:03','2022-10-22 21:44:03',NULL),(92,7566,40720,1525,3,75,'App\\Models\\Receipt',75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-14','2022-08-14',3684.92,NULL,NULL,1,'2022-10-22 21:45:36','2022-10-22 22:34:11','2022-10-22 22:34:11'),(93,7566,40720,1525,7,76,'App\\Models\\Receipt',76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',779.13,NULL,NULL,1,'2022-10-22 21:49:33','2022-10-22 21:49:33',NULL),(94,7566,40720,1525,7,77,'App\\Models\\Receipt',77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',17.29,NULL,NULL,1,'2022-10-22 21:49:33','2022-10-22 21:49:33',NULL),(95,7566,40720,1525,7,78,'App\\Models\\Receipt',78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',898.34,NULL,NULL,1,'2022-10-22 21:49:33','2022-10-22 21:49:33',NULL),(96,7566,40720,1525,7,79,'App\\Models\\Receipt',79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',48.38,NULL,NULL,1,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(97,7566,40720,1525,7,80,'App\\Models\\Receipt',80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',11.40,NULL,NULL,1,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(98,7566,40720,1525,7,81,'App\\Models\\Receipt',81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',213.19,NULL,NULL,1,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(99,7566,40720,1525,7,82,'App\\Models\\Receipt',82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',3872.27,NULL,NULL,1,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(100,7566,40720,1525,7,83,'App\\Models\\Receipt',83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',349.19,NULL,NULL,1,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(101,7566,40720,1525,7,84,'App\\Models\\Receipt',84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',3.75,NULL,NULL,1,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(102,7566,40720,1525,7,85,'App\\Models\\Receipt',85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',1744.26,NULL,NULL,1,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(103,7566,40720,1525,7,86,'App\\Models\\Receipt',86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',315.69,NULL,NULL,1,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(104,7566,40720,1525,7,87,'App\\Models\\Receipt',87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',48.39,NULL,NULL,1,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(105,7566,40720,1525,7,88,'App\\Models\\Receipt',88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',6177.58,NULL,NULL,1,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL);
INSERT INTO `balance_libro` VALUES (106,7566,40720,1525,7,89,'App\\Models\\Receipt',89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',90.11,NULL,NULL,1,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(107,7566,40720,1525,7,90,'App\\Models\\Receipt',90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',603.79,NULL,NULL,1,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(108,7566,40720,1525,7,91,'App\\Models\\Receipt',91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',147.95,NULL,NULL,1,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(109,7566,40720,1525,7,92,'App\\Models\\Receipt',92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',2268.54,NULL,NULL,1,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(110,7566,40720,1525,7,93,'App\\Models\\Receipt',93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',1026.03,NULL,NULL,1,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(111,7566,40720,1525,8,94,'App\\Models\\Receipt',94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',28.39,NULL,NULL,1,'2022-10-22 21:50:53','2022-10-22 21:50:53',NULL),(112,7566,40720,1525,8,95,'App\\Models\\Receipt',95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',20260.50,NULL,NULL,1,'2022-10-22 21:50:53','2022-10-22 21:50:53',NULL),(113,7566,40720,1525,3,64,'App\\Models\\Receipt',64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',13900.00,NULL,NULL,1,'2022-10-22 22:04:59','2022-10-22 22:05:20','2022-10-22 22:05:20'),(114,7566,40720,1526,3,64,'App\\Models\\Receipt',64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',13900.00,NULL,NULL,1,'2022-10-22 22:05:20','2022-10-22 23:41:45','2022-10-22 23:41:45'),(115,7566,40720,1526,3,65,'App\\Models\\Receipt',65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',5484.10,NULL,NULL,1,'2022-10-22 22:06:03','2022-10-22 23:41:54','2022-10-22 23:41:54'),(116,7566,40720,1525,3,52,'App\\Models\\Receipt',52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',3009.98,NULL,NULL,1,'2022-10-22 22:24:30','2022-10-22 22:24:30',NULL),(117,7566,40720,1525,3,57,'App\\Models\\Receipt',57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',3484.20,NULL,NULL,1,'2022-10-22 22:27:26','2023-11-18 12:38:47','2023-11-18 12:38:47'),(118,7566,40720,1525,3,96,'App\\Models\\Receipt',96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',5484.10,NULL,NULL,1,'2022-10-22 22:35:56','2022-10-22 22:35:56',NULL),(119,7566,40720,1525,3,97,'App\\Models\\Receipt',97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',13900.00,NULL,NULL,1,'2022-10-22 22:37:19','2022-10-22 22:37:36','2022-10-22 22:37:36'),(120,7566,40720,1525,3,97,'App\\Models\\Receipt',97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',13900.00,NULL,NULL,1,'2022-10-22 22:37:36','2022-10-22 22:37:36',NULL),(121,7566,40720,1525,3,49,'App\\Models\\Receipt',49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',2400.00,NULL,NULL,1,'2022-10-22 22:45:53','2022-10-22 22:45:53',NULL),(122,7566,40720,1525,7,98,'App\\Models\\Receipt',98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',109.42,NULL,NULL,1,'2022-10-22 23:22:36','2022-10-22 23:22:36',NULL),(123,7566,40720,1525,7,99,'App\\Models\\Receipt',99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',22.55,NULL,NULL,1,'2022-10-22 23:23:08','2022-10-22 23:23:08',NULL),(124,7566,40720,1525,7,100,'App\\Models\\Receipt',100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',39.65,NULL,NULL,1,'2022-10-22 23:23:39','2022-10-22 23:23:39',NULL),(125,7566,40720,1525,7,101,'App\\Models\\Receipt',101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',0.27,NULL,NULL,1,'2022-10-22 23:24:59','2022-10-22 23:24:59',NULL),(126,7566,40720,1525,7,102,'App\\Models\\Receipt',102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1.23,NULL,NULL,1,'2022-10-22 23:25:33','2022-10-22 23:25:33',NULL);
INSERT INTO `balance_libro` VALUES (127,7566,40720,1525,7,103,'App\\Models\\Receipt',103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',3292.24,NULL,NULL,1,'2022-10-22 23:26:43','2022-10-22 23:26:43',NULL),(128,7566,40720,1525,7,104,'App\\Models\\Receipt',104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',209.85,NULL,NULL,1,'2022-10-22 23:27:22','2022-10-22 23:27:22',NULL),(129,7566,40720,1525,7,105,'App\\Models\\Receipt',105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',385.58,NULL,NULL,1,'2022-10-22 23:27:56','2022-10-22 23:27:56',NULL),(130,7566,40720,1525,7,106,'App\\Models\\Receipt',106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',30.83,NULL,NULL,1,'2022-10-22 23:28:30','2022-10-22 23:28:30',NULL),(131,7566,40720,1525,7,107,'App\\Models\\Receipt',107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',125.78,NULL,NULL,1,'2022-10-22 23:28:58','2022-10-22 23:28:58',NULL),(132,7566,40720,1525,7,108,'App\\Models\\Receipt',108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',18.78,NULL,NULL,1,'2022-10-22 23:29:22','2022-10-22 23:29:22',NULL),(133,7566,40720,1525,7,109,'App\\Models\\Receipt',109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',1043.86,NULL,NULL,1,'2022-10-22 23:29:55','2022-10-22 23:29:55',NULL),(134,7566,40720,1525,7,110,'App\\Models\\Receipt',110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',10.08,NULL,NULL,1,'2022-10-22 23:30:21','2022-10-22 23:30:21',NULL),(135,7566,40720,1525,7,111,'App\\Models\\Receipt',111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',13.15,NULL,NULL,1,'2022-10-22 23:30:50','2022-10-22 23:30:50',NULL),(136,7566,40720,1525,7,112,'App\\Models\\Receipt',112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',270.87,NULL,NULL,1,'2022-10-22 23:31:16','2022-10-22 23:31:16',NULL),(137,7566,40720,1525,7,113,'App\\Models\\Receipt',113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',0.15,NULL,NULL,1,'2022-10-22 23:31:43','2022-10-22 23:31:43',NULL),(138,7566,40720,1525,7,114,'App\\Models\\Receipt',114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',6072.86,NULL,NULL,1,'2022-10-22 23:32:29','2022-10-22 23:32:29',NULL),(139,7566,40720,1525,7,115,'App\\Models\\Receipt',115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',96.86,NULL,NULL,1,'2022-10-22 23:33:02','2022-10-22 23:33:02',NULL),(140,7566,40720,1525,7,116,'App\\Models\\Receipt',116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',72.75,NULL,NULL,1,'2022-10-22 23:33:42','2022-10-22 23:33:42',NULL),(141,7566,40720,1525,7,117,'App\\Models\\Receipt',117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',806.73,NULL,NULL,1,'2022-10-22 23:34:06','2022-10-22 23:34:06',NULL),(142,7566,40720,1525,7,118,'App\\Models\\Receipt',118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',44.41,NULL,NULL,1,'2022-10-22 23:34:27','2022-10-22 23:34:27',NULL),(143,7566,40720,1525,7,119,'App\\Models\\Receipt',119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',2.37,NULL,NULL,1,'2022-10-22 23:34:53','2022-10-22 23:34:53',NULL),(144,7566,40720,1525,7,120,'App\\Models\\Receipt',120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',10.09,NULL,NULL,1,'2022-10-22 23:35:14','2022-10-22 23:35:14',NULL),(145,7566,40720,1525,7,121,'App\\Models\\Receipt',121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',187.15,NULL,NULL,1,'2022-10-22 23:35:37','2022-10-22 23:35:37',NULL),(146,7566,40720,1525,7,122,'App\\Models\\Receipt',122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',0.72,NULL,NULL,1,'2022-10-22 23:36:02','2022-10-22 23:36:02',NULL),(147,7566,40720,1526,3,123,'App\\Models\\Receipt',123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',2600.00,NULL,NULL,1,'2022-10-22 23:50:06','2022-10-22 23:58:23','2022-10-22 23:58:23');
INSERT INTO `balance_libro` VALUES (148,7566,40720,1526,3,124,'App\\Models\\Receipt',124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',11250.00,NULL,NULL,1,'2022-10-22 23:50:06','2022-10-23 00:35:43','2022-10-23 00:35:43'),(149,7566,40720,1526,3,125,'App\\Models\\Receipt',125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',1770.00,NULL,NULL,1,'2022-10-22 23:50:06','2022-10-22 23:50:06',NULL),(150,7566,40720,1526,3,126,'App\\Models\\Receipt',126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',1800.01,NULL,NULL,1,'2022-10-22 23:50:06','2022-10-23 00:14:50','2022-10-23 00:14:50'),(151,7566,40720,1526,3,127,'App\\Models\\Receipt',127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',4235.46,NULL,NULL,1,'2022-10-22 23:50:06','2022-10-22 23:50:06',NULL),(152,7566,40720,1526,3,128,'App\\Models\\Receipt',128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',3170.00,NULL,NULL,1,'2022-10-22 23:50:07','2022-10-22 23:50:07',NULL),(153,7566,40720,1526,3,129,'App\\Models\\Receipt',129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',4799.70,NULL,NULL,1,'2022-10-22 23:50:07','2022-10-23 00:09:05','2022-10-23 00:09:05'),(154,7566,40720,1526,3,130,'App\\Models\\Receipt',130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',4500.00,NULL,NULL,1,'2022-10-22 23:50:07','2022-10-23 00:27:37','2022-10-23 00:27:37'),(155,7566,40720,1526,3,131,'App\\Models\\Receipt',131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',1350.00,NULL,NULL,1,'2022-10-22 23:50:07','2022-10-22 23:50:07',NULL),(156,7566,40720,1526,3,132,'App\\Models\\Receipt',132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',5313.01,NULL,NULL,1,'2022-10-22 23:50:07','2022-10-23 00:41:29','2022-10-23 00:41:29'),(157,7566,40720,1526,3,133,'App\\Models\\Receipt',133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',4664.24,NULL,NULL,1,'2022-10-22 23:50:07','2022-10-23 00:20:58','2022-10-23 00:20:58'),(158,7566,40720,1526,3,134,'App\\Models\\Receipt',134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',3499.98,NULL,NULL,1,'2022-10-22 23:50:07','2022-10-23 00:10:28','2022-10-23 00:10:28'),(159,7566,40720,1526,3,135,'App\\Models\\Receipt',135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',3281.66,NULL,NULL,1,'2022-10-22 23:50:07','2022-10-23 00:13:56','2022-10-23 00:13:56'),(160,7566,40720,1526,3,136,'App\\Models\\Receipt',136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',950.00,NULL,NULL,1,'2022-10-22 23:50:07','2022-10-22 23:50:07',NULL),(161,7566,40720,1526,3,137,'App\\Models\\Receipt',137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',6552.08,NULL,NULL,1,'2022-10-22 23:50:07','2022-10-23 00:13:13','2022-10-23 00:13:13'),(162,7566,40720,1526,3,138,'App\\Models\\Receipt',138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',44346.50,NULL,NULL,1,'2022-10-22 23:50:07','2022-10-23 00:14:26','2022-10-23 00:14:26'),(163,7566,40720,1526,3,139,'App\\Models\\Receipt',139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',1530.00,NULL,NULL,1,'2022-10-22 23:50:07','2022-10-22 23:50:07',NULL),(164,7566,40720,1526,3,140,'App\\Models\\Receipt',140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',16025.95,NULL,NULL,1,'2022-10-22 23:53:33','2022-10-22 23:53:33',NULL),(165,7566,40720,1526,3,141,'App\\Models\\Receipt',141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',21065.95,NULL,NULL,1,'2022-10-22 23:55:32','2022-10-22 23:55:32',NULL),(166,7566,40720,1526,3,142,'App\\Models\\Receipt',142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',5243.84,NULL,NULL,1,'2022-10-22 23:57:18','2022-10-22 23:57:18',NULL),(167,7566,40720,1526,3,123,'App\\Models\\Receipt',123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',2600.00,NULL,NULL,1,'2022-10-22 23:58:23','2022-10-23 00:21:26','2022-10-23 00:21:26');
INSERT INTO `balance_libro` VALUES (168,7566,40720,1526,3,143,'App\\Models\\Receipt',143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',2320.00,NULL,NULL,1,'2022-10-23 00:05:59','2022-10-23 00:05:59',NULL),(169,7566,40720,1526,3,144,'App\\Models\\Receipt',144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',3700.00,NULL,NULL,1,'2022-10-23 00:06:48','2022-10-23 00:06:48',NULL),(170,7566,40720,1526,3,145,'App\\Models\\Receipt',145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',5545.50,NULL,NULL,1,'2022-10-23 00:07:57','2022-10-23 00:07:57',NULL),(171,7566,40720,1526,3,129,'App\\Models\\Receipt',129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',4799.70,NULL,NULL,1,'2022-10-23 00:09:05','2023-11-18 12:39:25','2023-11-18 12:39:25'),(172,7566,40720,1526,3,134,'App\\Models\\Receipt',134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',3499.98,NULL,NULL,1,'2022-10-23 00:10:28','2022-10-23 00:10:28',NULL),(173,7566,40720,1526,3,146,'App\\Models\\Receipt',146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',5243.15,NULL,NULL,1,'2022-10-23 00:11:55','2022-10-23 00:11:55',NULL),(174,7566,40720,1526,3,137,'App\\Models\\Receipt',137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',6552.08,NULL,NULL,1,'2022-10-23 00:13:13','2022-10-23 00:13:13',NULL),(175,7566,40720,1526,3,135,'App\\Models\\Receipt',135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',3281.66,NULL,NULL,1,'2022-10-23 00:13:56','2022-10-23 00:52:37','2022-10-23 00:52:37'),(176,7566,40720,1526,3,138,'App\\Models\\Receipt',138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',44346.50,NULL,NULL,1,'2022-10-23 00:14:26','2022-10-23 00:14:26',NULL),(177,7566,40720,1526,3,126,'App\\Models\\Receipt',126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',1800.01,NULL,NULL,1,'2022-10-23 00:14:50','2022-10-23 00:31:44','2022-10-23 00:31:44'),(178,7566,40720,1526,3,147,'App\\Models\\Receipt',147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-24','2022-09-24',5700.81,NULL,NULL,1,'2022-10-23 00:15:59','2022-10-23 00:15:59',NULL),(179,7566,40720,1526,3,148,'App\\Models\\Receipt',148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',5043.10,NULL,NULL,1,'2022-10-23 00:16:44','2022-10-23 00:16:44',NULL),(180,7566,40720,1526,3,133,'App\\Models\\Receipt',133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',4664.24,NULL,NULL,1,'2022-10-23 00:20:58','2022-10-23 00:20:58',NULL),(181,7566,40720,1526,3,123,'App\\Models\\Receipt',123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',2600.00,NULL,NULL,1,'2022-10-23 00:21:26','2022-10-23 00:21:26',NULL),(182,7566,40720,1526,3,130,'App\\Models\\Receipt',130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',4500.00,NULL,NULL,1,'2022-10-23 00:27:37','2022-10-23 00:27:37',NULL),(183,7566,40720,1526,3,126,'App\\Models\\Receipt',126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',1800.01,NULL,NULL,1,'2022-10-23 00:31:44','2022-10-23 00:31:44',NULL),(184,7566,40720,1526,3,124,'App\\Models\\Receipt',124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',11250.00,NULL,NULL,1,'2022-10-23 00:35:43','2022-10-23 00:39:38','2022-10-23 00:39:38'),(185,7566,40720,1526,3,124,'App\\Models\\Receipt',124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',11250.00,NULL,NULL,1,'2022-10-23 00:39:38','2022-10-23 00:39:38',NULL),(186,7566,40720,1526,3,132,'App\\Models\\Receipt',132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',5313.01,NULL,NULL,1,'2022-10-23 00:41:29','2022-10-23 00:41:29',NULL),(187,7566,40720,1526,3,149,'App\\Models\\Receipt',149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',21417.00,NULL,NULL,1,'2022-10-23 00:44:51','2022-10-23 00:44:51',NULL),(188,7566,40720,1526,3,150,'App\\Models\\Receipt',150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',27225.00,NULL,NULL,1,'2022-10-23 00:45:47','2022-10-23 00:45:47',NULL);
INSERT INTO `balance_libro` VALUES (189,7566,40720,1526,7,151,'App\\Models\\Receipt',151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',1163.55,NULL,NULL,1,'2022-10-23 00:48:42','2022-10-23 00:48:42',NULL),(190,7566,40720,1526,7,152,'App\\Models\\Receipt',152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',213.20,NULL,NULL,1,'2022-10-23 00:48:42','2022-10-23 00:48:42',NULL),(191,7566,40720,1526,7,153,'App\\Models\\Receipt',153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',141.28,NULL,NULL,1,'2022-10-23 00:48:42','2022-10-23 00:48:42',NULL),(192,7566,40720,1526,7,154,'App\\Models\\Receipt',154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',1462.98,NULL,NULL,1,'2022-10-23 00:48:42','2022-10-23 00:48:42',NULL),(193,7566,40720,1526,7,155,'App\\Models\\Receipt',155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',6758.42,NULL,NULL,1,'2022-10-23 00:48:42','2022-10-23 00:48:42',NULL),(194,7566,40720,1526,7,156,'App\\Models\\Receipt',156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',390.68,NULL,NULL,1,'2022-10-23 00:48:42','2022-10-23 00:48:42',NULL),(195,7566,40720,1526,7,157,'App\\Models\\Receipt',157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',804.26,NULL,NULL,1,'2022-10-23 00:48:42','2022-10-23 00:48:42',NULL),(196,7566,40720,1526,7,158,'App\\Models\\Receipt',158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',1447.58,NULL,NULL,1,'2022-10-23 00:48:42','2022-10-23 00:48:42',NULL),(197,7566,40720,1526,7,159,'App\\Models\\Receipt',159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',6847.05,NULL,NULL,1,'2022-10-23 00:48:42','2022-10-23 00:48:42',NULL),(198,7566,40720,1526,7,160,'App\\Models\\Receipt',160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',2303.89,NULL,NULL,1,'2022-10-23 00:48:42','2022-10-23 00:48:42',NULL),(199,7566,40720,1526,7,161,'App\\Models\\Receipt',161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',922.89,NULL,NULL,1,'2022-10-23 00:48:43','2022-10-23 00:48:43',NULL),(200,7566,40720,1526,3,135,'App\\Models\\Receipt',135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',3281.66,NULL,NULL,1,'2022-10-23 00:52:37','2022-10-23 00:52:37',NULL),(201,7566,40720,1526,7,162,'App\\Models\\Receipt',162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',102.54,NULL,NULL,1,'2022-10-23 00:56:45','2022-10-23 00:56:45',NULL),(202,7566,40720,1526,7,163,'App\\Models\\Receipt',163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',29.43,NULL,NULL,1,'2022-10-23 00:57:09','2022-10-23 00:57:09',NULL),(203,7566,40720,1526,7,164,'App\\Models\\Receipt',164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',39.65,NULL,NULL,1,'2022-10-23 00:57:33','2022-10-23 00:57:33',NULL),(204,7566,40720,1526,7,165,'App\\Models\\Receipt',165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',188.36,NULL,NULL,1,'2022-10-23 00:58:15','2022-10-23 00:58:15',NULL),(205,7566,40720,1526,7,166,'App\\Models\\Receipt',166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',392.94,NULL,NULL,1,'2022-10-23 00:58:41','2022-10-23 00:58:41',NULL),(206,7566,40720,1526,7,167,'App\\Models\\Receipt',167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',3899.92,NULL,NULL,1,'2022-10-23 00:59:18','2022-10-23 00:59:18',NULL),(207,7566,40720,1526,7,168,'App\\Models\\Receipt',168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',1228.18,NULL,NULL,1,'2022-10-23 00:59:47','2022-10-23 00:59:47',NULL),(208,7566,40720,1526,7,169,'App\\Models\\Receipt',169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',232.90,NULL,NULL,1,'2022-10-23 01:00:09','2022-10-23 01:00:09',NULL),(209,7566,40720,1526,7,170,'App\\Models\\Receipt',170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',81.39,NULL,NULL,1,'2022-10-23 01:00:34','2022-10-23 01:00:34',NULL);
INSERT INTO `balance_libro` VALUES (210,7566,40720,1526,7,171,'App\\Models\\Receipt',171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',148.65,NULL,NULL,1,'2022-10-23 01:01:13','2022-10-23 01:01:13',NULL),(211,7566,40720,1526,7,172,'App\\Models\\Receipt',172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',1408.01,NULL,NULL,1,'2022-10-23 01:01:44','2022-10-23 01:01:44',NULL),(212,7566,40720,1526,7,173,'App\\Models\\Receipt',173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',6705.55,NULL,NULL,1,'2022-10-23 01:02:11','2022-10-23 01:02:11',NULL),(213,7566,40720,1526,7,174,'App\\Models\\Receipt',174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',212.27,NULL,NULL,1,'2022-10-23 01:02:44','2022-10-23 01:02:44',NULL),(214,7566,40720,1526,7,175,'App\\Models\\Receipt',175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',29.43,NULL,NULL,1,'2022-10-23 01:03:07','2022-10-23 01:03:07',NULL),(215,7566,40720,1526,7,176,'App\\Models\\Receipt',176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',44.42,NULL,NULL,1,'2022-10-23 01:03:30','2022-10-23 01:03:30',NULL),(216,7566,40720,1526,7,177,'App\\Models\\Receipt',177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',242.40,NULL,NULL,1,'2022-10-23 01:04:00','2022-10-23 01:04:00',NULL),(217,7566,40720,1525,7,178,'App\\Models\\Receipt',178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',638.45,NULL,NULL,1,'2022-10-23 01:09:56','2022-10-23 01:09:56',NULL),(218,7566,40720,1525,7,179,'App\\Models\\Receipt',179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',3757.71,NULL,NULL,1,'2022-10-23 01:09:56','2022-10-23 01:09:56',NULL),(219,7566,40720,1525,7,180,'App\\Models\\Receipt',180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',569.01,NULL,NULL,1,'2022-10-23 01:09:56','2022-10-23 01:09:56',NULL),(220,7566,40720,1526,7,181,'App\\Models\\Receipt',181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',354.88,NULL,NULL,1,'2022-10-23 01:11:03','2022-10-23 01:11:03',NULL),(221,7566,40720,1526,7,182,'App\\Models\\Receipt',182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',4106.58,NULL,NULL,1,'2022-10-23 01:11:03','2022-10-23 01:11:03',NULL),(222,7566,40720,1526,7,183,'App\\Models\\Receipt',183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',879.28,NULL,NULL,1,'2022-10-23 01:11:03','2022-10-23 01:11:03',NULL),(223,7566,40720,1526,7,184,'App\\Models\\Receipt',184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',916.24,NULL,NULL,1,'2022-10-23 01:11:03','2022-10-23 01:11:03',NULL),(224,7566,40720,1527,2,185,'App\\Models\\Receipt',185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',119205.76,NULL,NULL,1,'2022-12-19 17:06:32','2022-12-19 17:06:32',NULL),(225,7566,40720,1527,2,186,'App\\Models\\Receipt',186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',155942.48,NULL,NULL,1,'2022-12-19 17:06:32','2022-12-19 17:06:32',NULL),(226,7566,40720,1527,2,187,'App\\Models\\Receipt',187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',6215.35,NULL,NULL,1,'2022-12-19 17:06:32','2022-12-19 17:06:32',NULL),(227,7566,40720,1527,2,188,'App\\Models\\Receipt',188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',6215.35,NULL,NULL,1,'2022-12-19 17:06:32','2022-12-19 17:06:32',NULL),(228,7566,40720,1527,2,189,'App\\Models\\Receipt',189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',6643.08,NULL,NULL,1,'2022-12-19 17:06:32','2022-12-19 17:06:32',NULL),(229,7566,40720,1527,2,190,'App\\Models\\Receipt',190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',6215.35,NULL,NULL,1,'2022-12-19 17:06:32','2022-12-19 17:06:32',NULL),(230,7566,40720,1527,2,191,'App\\Models\\Receipt',191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',10322.11,NULL,NULL,1,'2022-12-19 17:06:32','2022-12-19 17:06:32',NULL);
INSERT INTO `balance_libro` VALUES (231,7566,40720,1527,2,192,'App\\Models\\Receipt',192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',237485.43,NULL,NULL,1,'2022-12-19 17:06:32','2022-12-19 17:06:32',NULL),(232,7566,40720,1528,2,193,'App\\Models\\Receipt',193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',146251.48,NULL,NULL,1,'2022-12-19 17:12:20','2022-12-19 17:12:20',NULL),(233,7566,40720,1528,2,194,'App\\Models\\Receipt',194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',142693.80,NULL,NULL,1,'2022-12-19 17:12:20','2022-12-19 17:12:20',NULL),(234,7566,40720,1528,2,195,'App\\Models\\Receipt',195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',6176.78,NULL,NULL,1,'2022-12-19 17:12:20','2022-12-19 17:12:20',NULL),(235,7566,40720,1528,2,196,'App\\Models\\Receipt',196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',6336.06,NULL,NULL,1,'2022-12-19 17:12:20','2022-12-19 17:38:46','2022-12-19 17:38:46'),(236,7566,40720,1528,2,197,'App\\Models\\Receipt',197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',250267.62,NULL,NULL,1,'2022-12-19 17:12:20','2022-12-19 17:38:36','2022-12-19 17:38:36'),(237,7566,40720,1528,3,198,'App\\Models\\Receipt',198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',3080.01,NULL,NULL,1,'2022-12-19 17:15:55','2022-12-20 19:02:03','2022-12-20 19:02:03'),(238,7566,40720,1528,3,199,'App\\Models\\Receipt',199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',11250.00,NULL,NULL,1,'2022-12-19 17:15:55','2022-12-20 19:33:33','2022-12-20 19:33:33'),(239,7566,40720,1528,3,200,'App\\Models\\Receipt',200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',2400.00,NULL,NULL,1,'2022-12-19 17:15:55','2022-12-20 19:28:49','2022-12-20 19:28:49'),(240,7566,40720,1528,3,201,'App\\Models\\Receipt',201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',1535.62,NULL,NULL,1,'2022-12-19 17:15:55','2022-12-20 19:01:26','2022-12-20 19:01:26'),(241,7566,40720,1528,3,202,'App\\Models\\Receipt',202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',10974.66,NULL,NULL,1,'2022-12-19 17:15:55','2022-12-20 18:34:38','2022-12-20 18:34:38'),(242,7566,40720,1528,3,203,'App\\Models\\Receipt',203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',18103.44,NULL,NULL,1,'2022-12-19 17:15:55','2022-12-20 18:18:04','2022-12-20 18:18:04'),(243,7566,40720,1528,3,204,'App\\Models\\Receipt',204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',2750.00,NULL,NULL,1,'2022-12-19 17:15:55','2022-12-20 18:17:01','2022-12-20 18:17:01'),(244,7566,40720,1528,3,205,'App\\Models\\Receipt',205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',13160.00,NULL,NULL,1,'2022-12-19 17:15:55','2022-12-20 18:16:15','2022-12-20 18:16:15'),(245,7566,40720,1528,3,206,'App\\Models\\Receipt',206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',3750.00,NULL,NULL,1,'2022-12-19 17:15:55','2022-12-20 18:15:50','2022-12-20 18:15:50'),(246,7566,40720,1528,3,207,'App\\Models\\Receipt',207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',6590.00,NULL,NULL,1,'2022-12-19 17:15:56','2022-12-20 18:13:17','2022-12-20 18:13:17'),(247,7566,40720,1528,3,208,'App\\Models\\Receipt',208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',11000.00,NULL,NULL,1,'2022-12-19 17:15:56','2022-12-20 18:12:49','2022-12-20 18:12:49'),(248,7566,40720,1528,3,209,'App\\Models\\Receipt',209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',4073.80,NULL,NULL,1,'2022-12-19 17:15:56','2022-12-20 18:36:09','2022-12-20 18:36:09'),(249,7566,40720,1528,3,210,'App\\Models\\Receipt',210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',5542.35,NULL,NULL,1,'2022-12-19 17:15:56','2022-12-20 19:02:39','2022-12-20 19:02:39'),(250,7566,40720,1528,3,211,'App\\Models\\Receipt',211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',16666.16,NULL,NULL,1,'2022-12-19 17:15:56','2022-12-20 20:05:57','2022-12-20 20:05:57');
INSERT INTO `balance_libro` VALUES (251,7566,40720,1528,3,212,'App\\Models\\Receipt',212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',17730.00,NULL,NULL,1,'2022-12-19 17:15:56','2022-12-20 20:08:27','2022-12-20 20:08:27'),(252,7566,40720,1528,3,213,'App\\Models\\Receipt',213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',5860.00,NULL,NULL,1,'2022-12-19 17:15:56','2022-12-20 19:05:46','2022-12-20 19:05:46'),(253,7566,40720,1528,3,214,'App\\Models\\Receipt',214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-20','2022-11-20',4700.00,NULL,NULL,1,'2022-12-19 17:15:56','2022-12-20 18:10:39','2022-12-20 18:10:39'),(254,7566,40720,1528,3,215,'App\\Models\\Receipt',215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',2330.00,NULL,NULL,1,'2022-12-19 17:15:56','2022-12-20 18:10:09','2022-12-20 18:10:09'),(255,7566,40720,1528,3,216,'App\\Models\\Receipt',216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',18958.62,NULL,NULL,1,'2022-12-19 17:15:56','2022-12-20 18:08:37','2022-12-20 18:08:37'),(256,7566,40720,1528,3,217,'App\\Models\\Receipt',217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',3550.00,NULL,NULL,1,'2022-12-19 17:15:56','2022-12-20 18:06:49','2022-12-20 18:06:49'),(257,7566,40720,1528,3,218,'App\\Models\\Receipt',218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',5000.00,NULL,NULL,1,'2022-12-19 17:15:56','2022-12-20 18:05:59','2022-12-20 18:05:59'),(258,7566,40720,1528,8,219,'App\\Models\\Receipt',219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',296.50,NULL,NULL,1,'2022-12-19 17:23:39','2022-12-19 17:27:50','2022-12-19 17:27:50'),(259,7566,40720,1528,7,220,'App\\Models\\Receipt',220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',84.02,NULL,NULL,1,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(260,7566,40720,1528,7,221,'App\\Models\\Receipt',221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',1589.44,NULL,NULL,1,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(261,7566,40720,1528,7,222,'App\\Models\\Receipt',222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',367.00,NULL,NULL,1,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(262,7566,40720,1528,7,223,'App\\Models\\Receipt',223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',809.82,NULL,NULL,1,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(263,7566,40720,1528,7,224,'App\\Models\\Receipt',224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',857.60,NULL,NULL,1,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(264,7566,40720,1528,7,225,'App\\Models\\Receipt',225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',7063.27,NULL,NULL,1,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(265,7566,40720,1528,7,226,'App\\Models\\Receipt',226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',1286.10,NULL,NULL,1,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(266,7566,40720,1528,7,227,'App\\Models\\Receipt',227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',1453.31,NULL,NULL,1,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(267,7566,40720,1528,7,228,'App\\Models\\Receipt',228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',7910.21,NULL,NULL,1,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(268,7566,40720,1528,7,229,'App\\Models\\Receipt',229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',114.49,NULL,NULL,1,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(269,7566,40720,1528,7,230,'App\\Models\\Receipt',230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',2470.76,NULL,NULL,1,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(270,7566,40720,1528,7,231,'App\\Models\\Receipt',231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',849.69,NULL,NULL,1,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL);
INSERT INTO `balance_libro` VALUES (271,7566,40720,1528,7,232,'App\\Models\\Receipt',232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',148.49,NULL,NULL,1,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(272,7566,40720,1528,7,233,'App\\Models\\Receipt',233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',1586.19,NULL,NULL,1,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(273,7566,40720,1528,8,219,'App\\Models\\Receipt',219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',296.50,NULL,NULL,1,'2022-12-19 17:27:50','2022-12-19 17:27:50',NULL),(274,7566,40720,1528,2,197,'App\\Models\\Receipt',197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',250267.62,NULL,NULL,1,'2022-12-19 17:38:36','2022-12-19 17:38:36',NULL),(275,7566,40720,1528,2,196,'App\\Models\\Receipt',196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',6336.06,NULL,NULL,1,'2022-12-19 17:38:46','2022-12-19 17:38:46',NULL),(276,7566,40720,1528,3,218,'App\\Models\\Receipt',218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',5000.00,NULL,NULL,1,'2022-12-20 18:05:59','2022-12-20 18:05:59',NULL),(277,7566,40720,1528,3,217,'App\\Models\\Receipt',217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',3550.00,NULL,NULL,1,'2022-12-20 18:06:49','2022-12-20 18:06:49',NULL),(278,7566,40720,1528,3,216,'App\\Models\\Receipt',216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',19563.74,NULL,NULL,1,'2022-12-20 18:08:37','2022-12-20 18:09:23','2022-12-20 18:09:23'),(279,7566,40720,1528,3,216,'App\\Models\\Receipt',216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',18958.62,NULL,NULL,1,'2022-12-20 18:09:23','2022-12-20 18:10:48','2022-12-20 18:10:48'),(280,7566,40720,1528,3,215,'App\\Models\\Receipt',215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',2330.00,NULL,NULL,1,'2022-12-20 18:10:09','2022-12-20 18:10:09',NULL),(281,7566,40720,1528,3,214,'App\\Models\\Receipt',214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-20','2022-11-20',4700.00,NULL,NULL,1,'2022-12-20 18:10:39','2022-12-20 18:10:39',NULL),(282,7566,40720,1528,3,216,'App\\Models\\Receipt',216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',18958.62,NULL,NULL,1,'2022-12-20 18:10:48','2022-12-20 18:10:48',NULL),(283,7566,40720,1528,3,208,'App\\Models\\Receipt',208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',11000.00,NULL,NULL,1,'2022-12-20 18:12:49','2022-12-20 18:12:49',NULL),(284,7566,40720,1528,3,206,'App\\Models\\Receipt',206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',3750.00,NULL,NULL,1,'2022-12-20 18:15:50','2022-12-20 18:15:50',NULL),(285,7566,40720,1528,3,205,'App\\Models\\Receipt',205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',13160.00,NULL,NULL,1,'2022-12-20 18:16:15','2022-12-20 18:16:15',NULL),(286,7566,40720,1528,3,204,'App\\Models\\Receipt',204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',2750.00,NULL,NULL,1,'2022-12-20 18:17:01','2022-12-20 19:29:16','2022-12-20 19:29:16'),(287,7566,40720,1528,3,203,'App\\Models\\Receipt',203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',18103.44,NULL,NULL,1,'2022-12-20 18:18:04','2022-12-20 18:18:04',NULL),(288,7566,40720,1528,3,234,'App\\Models\\Receipt',234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',5200.00,NULL,NULL,1,'2022-12-20 18:29:55','2022-12-20 18:29:55',NULL),(289,7566,40720,1528,3,235,'App\\Models\\Receipt',235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',7000.00,NULL,NULL,1,'2022-12-20 18:31:49','2022-12-20 18:31:49',NULL),(290,7566,40720,1528,3,236,'App\\Models\\Receipt',236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',8500.00,NULL,NULL,1,'2022-12-20 18:32:47','2022-12-20 18:32:47',NULL),(291,7566,40720,1528,3,202,'App\\Models\\Receipt',202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',10974.66,NULL,NULL,1,'2022-12-20 18:34:38','2022-12-20 18:34:38',NULL);
INSERT INTO `balance_libro` VALUES (292,7566,40720,1528,3,209,'App\\Models\\Receipt',209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',4073.80,NULL,NULL,1,'2022-12-20 18:36:09','2022-12-20 18:36:09',NULL),(293,7566,40720,1528,3,237,'App\\Models\\Receipt',237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',14498.00,NULL,NULL,1,'2022-12-20 18:39:10','2022-12-20 18:39:10',NULL),(294,7566,40720,1528,3,238,'App\\Models\\Receipt',238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',6616.22,NULL,NULL,1,'2022-12-20 18:41:45','2022-12-20 18:42:06','2022-12-20 18:42:06'),(295,7566,40720,1528,3,238,'App\\Models\\Receipt',238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',6503.72,NULL,NULL,1,'2022-12-20 18:42:06','2022-12-20 18:42:06',NULL),(296,7566,40720,1528,3,239,'App\\Models\\Receipt',239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',6501.33,NULL,NULL,1,'2022-12-20 18:43:53','2022-12-20 18:43:53',NULL),(297,7566,40720,1528,3,240,'App\\Models\\Receipt',240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',4050.00,NULL,NULL,1,'2022-12-20 18:44:47','2022-12-20 18:44:47',NULL),(298,7566,40720,1528,3,241,'App\\Models\\Receipt',241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',4950.00,NULL,NULL,1,'2022-12-20 18:45:10','2022-12-20 18:45:10',NULL),(299,7566,40720,1528,3,242,'App\\Models\\Receipt',242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',7398.00,NULL,NULL,1,'2022-12-20 18:45:32','2022-12-20 18:45:32',NULL),(300,7566,40720,1528,3,243,'App\\Models\\Receipt',243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',9310.00,NULL,NULL,1,'2022-12-20 18:50:18','2022-12-20 18:52:44','2022-12-20 18:52:44'),(301,7566,40720,1528,3,243,'App\\Models\\Receipt',243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',9310.00,NULL,NULL,1,'2022-12-20 18:52:44','2022-12-20 18:52:44',NULL),(302,7566,40720,1528,3,244,'App\\Models\\Receipt',244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',6251.54,NULL,NULL,1,'2022-12-20 18:55:18','2022-12-20 18:55:18',NULL),(303,7566,40720,1528,3,245,'App\\Models\\Receipt',245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',7058.16,NULL,NULL,1,'2022-12-20 18:56:03','2022-12-20 20:34:29','2022-12-20 20:34:29'),(304,7566,40720,1528,3,246,'App\\Models\\Receipt',246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',7200.39,NULL,NULL,1,'2022-12-20 18:57:42','2022-12-20 18:57:42',NULL),(305,7566,40720,1528,3,201,'App\\Models\\Receipt',201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',1535.62,NULL,NULL,1,'2022-12-20 19:01:26','2022-12-20 19:32:08','2022-12-20 19:32:08'),(306,7566,40720,1528,3,198,'App\\Models\\Receipt',198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',3080.01,NULL,NULL,1,'2022-12-20 19:02:03','2022-12-20 19:27:28','2022-12-20 19:27:28'),(307,7566,40720,1528,3,247,'App\\Models\\Receipt',247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',5542.35,NULL,NULL,1,'2022-12-20 19:04:27','2022-12-20 19:04:27',NULL),(308,7566,40720,1528,3,213,'App\\Models\\Receipt',213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',5860.00,NULL,NULL,1,'2022-12-20 19:05:46','2023-11-18 12:37:24','2023-11-18 12:37:24'),(309,7566,40720,1528,3,248,'App\\Models\\Receipt',248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',21175.00,NULL,NULL,1,'2022-12-20 19:07:02','2022-12-20 19:07:02',NULL),(310,7566,40720,1528,3,249,'App\\Models\\Receipt',249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',30734.00,NULL,NULL,1,'2022-12-20 19:07:30','2022-12-20 19:07:30',NULL),(311,7566,40720,1528,3,250,'App\\Models\\Receipt',250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',36300.00,NULL,NULL,1,'2022-12-20 19:09:38','2022-12-20 19:09:38',NULL),(312,7566,40720,1528,3,251,'App\\Models\\Receipt',251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',27225.00,NULL,NULL,1,'2022-12-20 19:10:07','2022-12-20 19:10:07',NULL);
INSERT INTO `balance_libro` VALUES (313,7566,40720,1528,3,198,'App\\Models\\Receipt',198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',3080.01,NULL,NULL,1,'2022-12-20 19:27:28','2022-12-20 19:27:28',NULL),(314,7566,40720,1528,3,200,'App\\Models\\Receipt',200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',2400.00,NULL,NULL,1,'2022-12-20 19:28:49','2022-12-20 19:29:32','2022-12-20 19:29:32'),(315,7566,40720,1528,3,204,'App\\Models\\Receipt',204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',2750.00,NULL,NULL,1,'2022-12-20 19:29:16','2022-12-20 19:29:16',NULL),(316,7566,40720,1528,3,200,'App\\Models\\Receipt',200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',2400.00,NULL,NULL,1,'2022-12-20 19:29:32','2022-12-20 19:29:32',NULL),(317,7566,40720,1528,3,201,'App\\Models\\Receipt',201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',1535.62,NULL,NULL,1,'2022-12-20 19:32:08','2022-12-20 20:14:51','2022-12-20 20:14:51'),(318,7566,40720,1528,3,199,'App\\Models\\Receipt',199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',11250.00,NULL,NULL,1,'2022-12-20 19:33:33','2022-12-20 19:33:33',NULL),(319,7566,40720,1528,3,201,'App\\Models\\Receipt',201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',1535.62,NULL,NULL,1,'2022-12-20 20:14:51','2022-12-20 20:14:51',NULL),(320,7566,40720,1528,3,245,'App\\Models\\Receipt',245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',7058.16,NULL,NULL,1,'2022-12-20 20:34:29','2022-12-20 20:34:29',NULL),(321,7566,40720,1528,7,252,'App\\Models\\Receipt',252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',122.08,NULL,NULL,1,'2022-12-20 20:40:28','2022-12-20 20:40:28',NULL),(322,7566,40720,1528,7,253,'App\\Models\\Receipt',253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',35.04,NULL,NULL,1,'2022-12-20 20:41:56','2022-12-20 20:41:56',NULL),(323,7566,40720,1528,7,254,'App\\Models\\Receipt',254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',84.83,NULL,NULL,1,'2022-12-20 20:42:26','2022-12-20 20:42:26',NULL),(324,7566,40720,1528,7,255,'App\\Models\\Receipt',255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',39.37,NULL,NULL,1,'2022-12-20 20:42:46','2022-12-20 20:42:46',NULL),(325,7566,40720,1528,7,256,'App\\Models\\Receipt',256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',1.23,NULL,NULL,1,'2022-12-20 20:43:08','2022-12-20 20:43:08',NULL),(326,7566,40720,1528,7,257,'App\\Models\\Receipt',257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',330.46,NULL,NULL,1,'2022-12-20 20:45:25','2022-12-20 20:45:25',NULL),(327,7566,40720,1528,7,258,'App\\Models\\Receipt',258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',30.93,NULL,NULL,1,'2022-12-20 20:45:50','2022-12-20 20:45:50',NULL),(328,7566,40720,1528,7,259,'App\\Models\\Receipt',259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',173.12,NULL,NULL,1,'2022-12-20 20:46:18','2022-12-20 20:46:18',NULL),(329,7566,40720,1528,7,260,'App\\Models\\Receipt',260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',4057.58,NULL,NULL,1,'2022-12-20 20:47:03','2022-12-20 20:47:03',NULL),(330,7566,40720,1528,7,261,'App\\Models\\Receipt',261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',436.09,NULL,NULL,1,'2022-12-20 20:47:46','2022-12-20 20:47:46',NULL),(331,7566,40720,1528,7,262,'App\\Models\\Receipt',262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',23.85,NULL,NULL,1,'2022-12-20 20:48:15','2022-12-20 20:48:15',NULL),(332,7566,40720,1528,7,263,'App\\Models\\Receipt',263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',1395.68,NULL,NULL,1,'2022-12-20 20:48:37','2022-12-20 20:48:37',NULL),(333,7566,40720,1528,7,264,'App\\Models\\Receipt',264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',221.02,NULL,NULL,1,'2022-12-20 20:49:43','2022-12-20 20:49:43',NULL);
INSERT INTO `balance_libro` VALUES (334,7566,40720,1528,7,265,'App\\Models\\Receipt',265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',70.00,NULL,NULL,1,'2022-12-20 20:50:05','2022-12-20 20:50:05',NULL),(335,7566,40720,1528,7,266,'App\\Models\\Receipt',266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',1379.65,NULL,NULL,1,'2022-12-20 20:50:33','2022-12-20 20:50:33',NULL),(336,7566,40720,1528,7,267,'App\\Models\\Receipt',267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',165.84,NULL,NULL,1,'2022-12-20 20:50:53','2022-12-20 20:50:53',NULL),(337,7566,40720,1528,7,268,'App\\Models\\Receipt',268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',76.46,NULL,NULL,1,'2022-12-20 20:51:19','2022-12-20 20:51:19',NULL),(338,7566,40720,1528,7,269,'App\\Models\\Receipt',269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',331.13,NULL,NULL,1,'2022-12-20 20:51:37','2022-12-20 20:51:37',NULL),(339,7566,40720,1528,7,270,'App\\Models\\Receipt',270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',17.50,NULL,NULL,1,'2022-12-20 20:52:00','2022-12-20 20:52:00',NULL),(340,7566,40720,1528,7,271,'App\\Models\\Receipt',271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',136.81,NULL,NULL,1,'2022-12-20 20:52:34','2022-12-20 20:52:34',NULL),(341,7566,40720,1528,7,272,'App\\Models\\Receipt',272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',6617.48,NULL,NULL,1,'2022-12-20 20:53:40','2022-12-20 20:53:40',NULL),(342,7566,40720,1529,2,273,'App\\Models\\Receipt',273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',126833.58,NULL,NULL,1,'2023-01-14 10:33:03','2023-01-14 10:33:03',NULL),(343,7566,40720,1529,2,274,'App\\Models\\Receipt',274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',185337.32,NULL,NULL,1,'2023-01-14 10:33:03','2023-01-14 10:33:03',NULL),(344,7566,40720,1529,2,275,'App\\Models\\Receipt',275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',4525.98,NULL,NULL,1,'2023-01-14 10:33:03','2023-01-14 10:33:03',NULL),(345,7566,40720,1529,2,276,'App\\Models\\Receipt',276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',7979.73,NULL,NULL,1,'2023-01-14 10:33:03','2023-01-14 10:33:03',NULL),(346,7566,40720,1529,2,277,'App\\Models\\Receipt',277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',247189.58,NULL,NULL,1,'2023-01-14 10:33:03','2023-01-14 10:33:03',NULL),(347,7566,40720,1529,3,278,'App\\Models\\Receipt',278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',3080.01,NULL,NULL,1,'2023-01-14 10:53:23','2023-01-14 11:06:08','2023-01-14 11:06:08'),(348,7566,40720,1529,3,279,'App\\Models\\Receipt',279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',11250.00,NULL,NULL,1,'2023-01-14 10:53:23','2023-01-14 10:53:23',NULL),(349,7566,40720,1529,3,280,'App\\Models\\Receipt',280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',2850.00,NULL,NULL,1,'2023-01-14 10:53:23','2023-01-14 10:53:23',NULL),(350,7566,40720,1529,3,281,'App\\Models\\Receipt',281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',1730.00,NULL,NULL,1,'2023-01-14 10:53:23','2023-01-14 10:53:23',NULL),(351,7566,40720,1529,3,282,'App\\Models\\Receipt',282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',6769.85,NULL,NULL,1,'2023-01-14 10:53:23','2023-01-14 11:00:02','2023-01-14 11:00:02'),(352,7566,40720,1529,3,283,'App\\Models\\Receipt',283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',15454.27,NULL,NULL,1,'2023-01-14 10:53:23','2023-01-14 11:09:48','2023-01-14 11:09:48'),(353,7566,40720,1529,3,284,'App\\Models\\Receipt',284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',17607.18,NULL,NULL,1,'2023-01-14 10:53:23','2023-01-14 10:57:30','2023-01-14 10:57:30'),(354,7566,40720,1529,3,285,'App\\Models\\Receipt',285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',2230.00,NULL,NULL,1,'2023-01-14 10:53:23','2023-01-14 10:53:23',NULL);
INSERT INTO `balance_libro` VALUES (355,7566,40720,1529,3,286,'App\\Models\\Receipt',286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',22152.78,NULL,NULL,1,'2023-01-14 10:53:24','2023-01-14 11:01:12','2023-01-14 11:01:12'),(356,7566,40720,1529,3,287,'App\\Models\\Receipt',287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',2230.00,NULL,NULL,1,'2023-01-14 10:53:24','2023-01-14 11:00:37','2023-01-14 11:00:37'),(357,7566,40720,1529,3,288,'App\\Models\\Receipt',288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',9334.32,NULL,NULL,1,'2023-01-14 10:53:24','2023-01-14 10:58:46','2023-01-14 10:58:46'),(358,7566,40720,1529,3,289,'App\\Models\\Receipt',289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',14000.00,NULL,NULL,1,'2023-01-14 10:53:24','2023-01-14 11:00:25','2023-01-14 11:00:25'),(359,7566,40720,1529,3,284,'App\\Models\\Receipt',284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',17607.18,NULL,NULL,1,'2023-01-14 10:57:30','2023-01-14 10:57:30',NULL),(360,7566,40720,1529,3,288,'App\\Models\\Receipt',288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',9782.04,NULL,NULL,1,'2023-01-14 10:58:46','2023-01-14 10:59:01','2023-01-14 10:59:01'),(361,7566,40720,1529,3,288,'App\\Models\\Receipt',288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',9782.04,NULL,NULL,1,'2023-01-14 10:59:01','2023-01-23 20:01:56','2023-01-23 20:01:56'),(362,7566,40720,1529,3,282,'App\\Models\\Receipt',282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',6769.84,NULL,NULL,1,'2023-01-14 11:00:02','2023-01-14 11:00:02',NULL),(363,7566,40720,1529,3,289,'App\\Models\\Receipt',289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',14000.00,NULL,NULL,1,'2023-01-14 11:00:25','2023-01-14 11:00:25',NULL),(364,7566,40720,1529,3,287,'App\\Models\\Receipt',287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',2230.01,NULL,NULL,1,'2023-01-14 11:00:37','2023-01-14 11:00:37',NULL),(365,7566,40720,1529,3,286,'App\\Models\\Receipt',286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',22152.78,NULL,NULL,1,'2023-01-14 11:01:12','2023-01-14 11:01:12',NULL),(366,7566,40720,1529,3,278,'App\\Models\\Receipt',278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',3080.01,NULL,NULL,1,'2023-01-14 11:06:08','2023-01-23 20:13:49','2023-01-23 20:13:49'),(367,7566,40720,1529,3,290,'App\\Models\\Receipt',290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',5542.35,NULL,NULL,1,'2023-01-14 11:08:22','2023-01-23 20:14:06','2023-01-23 20:14:06'),(368,7566,40720,1529,3,283,'App\\Models\\Receipt',283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',15967.54,NULL,NULL,1,'2023-01-14 11:09:48','2023-01-14 11:10:59','2023-01-14 11:10:59'),(369,7566,40720,1529,3,283,'App\\Models\\Receipt',283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',15454.27,NULL,NULL,1,'2023-01-14 11:10:59','2023-01-14 11:10:59',NULL),(370,7566,40720,1529,3,291,'App\\Models\\Receipt',291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',6701.02,NULL,NULL,1,'2023-01-14 11:15:42','2023-01-14 11:15:42',NULL),(371,7566,40720,1529,3,292,'App\\Models\\Receipt',292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',7260.81,NULL,NULL,1,'2023-01-14 11:17:06','2023-01-14 11:17:06',NULL),(372,7566,40720,1529,3,293,'App\\Models\\Receipt',293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',6352.65,NULL,NULL,1,'2023-01-14 11:17:53','2023-01-14 11:17:53',NULL),(373,7566,40720,1529,3,294,'App\\Models\\Receipt',294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',6286.32,NULL,NULL,1,'2023-01-14 11:20:30','2023-01-14 11:20:30',NULL),(374,7566,40720,1529,3,295,'App\\Models\\Receipt',295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',2650.00,NULL,NULL,1,'2023-01-14 11:22:18','2023-01-14 11:22:18',NULL);
INSERT INTO `balance_libro` VALUES (375,7566,40720,1529,3,296,'App\\Models\\Receipt',296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',38838.58,NULL,NULL,1,'2023-01-14 11:24:30','2023-01-14 11:24:30',NULL),(376,7566,40720,1529,3,297,'App\\Models\\Receipt',297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',36905.00,NULL,NULL,1,'2023-01-14 11:24:54','2023-01-14 11:24:54',NULL),(377,7566,40720,1529,3,298,'App\\Models\\Receipt',298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',41140.00,NULL,NULL,1,'2023-01-14 11:25:25','2023-01-14 11:25:25',NULL),(378,7566,40720,1529,7,299,'App\\Models\\Receipt',299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',511.81,NULL,NULL,1,'2023-01-14 11:29:33','2023-01-14 11:29:33',NULL),(379,7566,40720,1529,7,300,'App\\Models\\Receipt',300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',78.88,NULL,NULL,1,'2023-01-14 11:29:33','2023-01-14 11:29:33',NULL),(380,7566,40720,1529,7,301,'App\\Models\\Receipt',301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',3549.22,NULL,NULL,1,'2023-01-14 11:29:33','2023-01-14 11:29:33',NULL),(381,7566,40720,1529,7,302,'App\\Models\\Receipt',302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',329.09,NULL,NULL,1,'2023-01-14 11:29:33','2023-01-14 11:29:33',NULL),(382,7566,40720,1529,7,303,'App\\Models\\Receipt',303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',4676.37,NULL,NULL,1,'2023-01-14 11:29:33','2023-01-14 11:29:33',NULL),(383,7566,40720,1529,7,304,'App\\Models\\Receipt',304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',8614.66,NULL,NULL,1,'2023-01-14 11:29:33','2023-01-14 11:29:33',NULL),(384,7566,40720,1529,7,305,'App\\Models\\Receipt',305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',181.33,NULL,NULL,1,'2023-01-14 11:29:33','2023-01-14 11:29:33',NULL),(385,7566,40720,1529,7,306,'App\\Models\\Receipt',306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',628.40,NULL,NULL,1,'2023-01-14 11:29:33','2023-01-14 11:29:33',NULL),(386,7566,40720,1529,7,307,'App\\Models\\Receipt',307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',3035.51,NULL,NULL,1,'2023-01-14 11:29:33','2023-01-14 11:29:33',NULL),(387,7566,40720,1529,7,308,'App\\Models\\Receipt',308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',1537.47,NULL,NULL,1,'2023-01-14 11:29:33','2023-01-14 11:29:33',NULL),(388,7566,40720,1529,7,309,'App\\Models\\Receipt',309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',2219.20,NULL,NULL,1,'2023-01-14 11:29:33','2023-01-14 11:29:33',NULL),(389,7566,40720,1529,7,310,'App\\Models\\Receipt',310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',1231.61,NULL,NULL,1,'2023-01-14 11:29:33','2023-01-14 11:29:33',NULL),(390,7566,40720,1529,8,311,'App\\Models\\Receipt',311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',441.46,NULL,NULL,1,'2023-01-14 12:01:19','2023-01-14 12:01:19',NULL),(391,7566,40720,1529,3,312,'App\\Models\\Receipt',312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',42168.52,NULL,NULL,1,'2023-01-23 19:33:39','2023-01-23 19:34:31','2023-01-23 19:34:31'),(392,7566,40720,1529,3,312,'App\\Models\\Receipt',312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',42299.53,NULL,NULL,1,'2023-01-23 19:34:31','2023-01-23 19:34:31',NULL),(393,7566,40720,1529,3,288,'App\\Models\\Receipt',288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',9334.32,NULL,NULL,1,'2023-01-23 20:01:56','2023-01-23 20:01:56',NULL),(394,7566,40720,1529,3,278,'App\\Models\\Receipt',278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',3080.01,NULL,NULL,1,'2023-01-23 20:13:49','2023-01-23 20:13:49',NULL),(395,7566,40720,1529,3,290,'App\\Models\\Receipt',290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',5542.35,NULL,NULL,1,'2023-01-23 20:14:06','2023-01-23 20:14:06',NULL);
INSERT INTO `balance_libro` VALUES (396,7566,40720,1533,2,313,'App\\Models\\Receipt',313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',164818.55,NULL,NULL,1,'2023-02-20 16:17:15','2023-02-20 16:17:15',NULL),(397,7566,40720,1533,2,314,'App\\Models\\Receipt',314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',187010.91,NULL,NULL,1,'2023-02-20 16:17:15','2023-02-20 16:17:15',NULL),(398,7566,40720,1533,2,315,'App\\Models\\Receipt',315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',6290.57,NULL,NULL,1,'2023-02-20 16:17:15','2023-02-20 16:17:15',NULL),(399,7566,40720,1533,2,316,'App\\Models\\Receipt',316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',8312.59,NULL,NULL,1,'2023-02-20 16:17:15','2023-02-20 16:17:15',NULL),(400,7566,40720,1533,2,317,'App\\Models\\Receipt',317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',304407.37,NULL,NULL,1,'2023-02-20 16:17:15','2023-02-20 16:17:15',NULL),(401,7566,40720,1533,7,318,'App\\Models\\Receipt',318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',66.82,NULL,NULL,1,'2023-02-20 16:26:06','2023-02-20 16:26:06',NULL),(402,7566,40720,1533,7,319,'App\\Models\\Receipt',319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',71.39,NULL,NULL,1,'2023-02-20 16:26:06','2023-02-20 16:26:06',NULL),(403,7566,40720,1533,7,320,'App\\Models\\Receipt',320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',657.76,NULL,NULL,1,'2023-02-20 16:26:06','2023-02-20 16:26:06',NULL),(404,7566,40720,1533,7,321,'App\\Models\\Receipt',321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',873.40,NULL,NULL,1,'2023-02-20 16:26:06','2023-02-20 16:26:06',NULL),(405,7566,40720,1533,7,322,'App\\Models\\Receipt',322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',3175.06,NULL,NULL,1,'2023-02-20 16:26:06','2023-02-20 16:26:06',NULL),(406,7566,40720,1533,7,323,'App\\Models\\Receipt',323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',1923.79,NULL,NULL,1,'2023-02-20 16:26:06','2023-02-20 16:26:06',NULL),(407,7566,40720,1533,7,324,'App\\Models\\Receipt',324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',5454.38,NULL,NULL,1,'2023-02-20 16:26:06','2023-02-20 16:26:06',NULL),(408,7566,40720,1533,7,325,'App\\Models\\Receipt',325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2148.38,NULL,NULL,1,'2023-02-20 16:26:06','2023-02-20 16:26:06',NULL),(409,7566,40720,1533,7,326,'App\\Models\\Receipt',326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',66.84,NULL,NULL,1,'2023-02-20 16:26:06','2023-02-20 16:26:06',NULL),(410,7566,40720,1533,7,327,'App\\Models\\Receipt',327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',703.17,NULL,NULL,1,'2023-02-20 16:26:07','2023-02-20 16:26:07',NULL),(411,7566,40720,1533,7,328,'App\\Models\\Receipt',328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',156.56,NULL,NULL,1,'2023-02-20 16:26:07','2023-02-20 16:26:07',NULL),(412,7566,40720,1533,7,329,'App\\Models\\Receipt',329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',2229.04,NULL,NULL,1,'2023-02-20 16:26:07','2023-02-20 16:26:07',NULL),(413,7566,40720,1533,7,330,'App\\Models\\Receipt',330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',6947.91,NULL,NULL,1,'2023-02-20 16:26:07','2023-02-20 16:26:07',NULL),(414,7566,40720,1533,7,331,'App\\Models\\Receipt',331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2283.12,NULL,NULL,1,'2023-02-20 16:26:07','2023-02-20 16:26:07',NULL),(415,7566,40720,1533,7,332,'App\\Models\\Receipt',332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',1350.90,NULL,NULL,1,'2023-02-20 16:26:07','2023-02-20 16:26:07',NULL),(416,7566,40720,1533,8,333,'App\\Models\\Receipt',333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',441.57,NULL,NULL,1,'2023-02-20 16:28:25','2023-02-20 16:28:25',NULL);
INSERT INTO `balance_libro` VALUES (417,7566,40720,1533,3,334,'App\\Models\\Receipt',334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',16666.16,NULL,NULL,1,'2023-02-20 16:35:13','2023-02-20 17:34:56','2023-02-20 17:34:56'),(418,7566,40720,1533,3,335,'App\\Models\\Receipt',335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',3300.00,NULL,NULL,1,'2023-02-20 16:35:13','2023-02-20 17:37:48','2023-02-20 17:37:48'),(419,7566,40720,1533,3,336,'App\\Models\\Receipt',336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',5736.83,NULL,NULL,1,'2023-02-20 16:35:13','2023-02-20 17:37:25','2023-02-20 17:37:25'),(420,7566,40720,1533,3,337,'App\\Models\\Receipt',337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',11250.00,NULL,NULL,1,'2023-02-20 16:35:13','2023-02-20 17:38:35','2023-02-20 17:38:35'),(421,7566,40720,1533,3,338,'App\\Models\\Receipt',338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',3361.24,NULL,NULL,1,'2023-02-20 16:35:13','2023-02-20 18:32:45','2023-02-20 18:32:45'),(422,7566,40720,1533,3,339,'App\\Models\\Receipt',339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',14220.00,NULL,NULL,1,'2023-02-20 16:35:13','2023-02-20 17:41:13','2023-02-20 17:41:13'),(423,7566,40720,1533,3,340,'App\\Models\\Receipt',340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',7805.13,NULL,NULL,1,'2023-02-20 16:35:13','2023-02-20 17:49:06','2023-02-20 17:49:06'),(424,7566,40720,1533,3,341,'App\\Models\\Receipt',341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',7846.98,NULL,NULL,1,'2023-02-20 16:35:13','2023-02-20 17:50:27','2023-02-20 17:50:27'),(425,7566,40720,1533,3,342,'App\\Models\\Receipt',342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',4050.23,NULL,NULL,1,'2023-02-20 16:35:13','2023-02-20 17:55:09','2023-02-20 17:55:09'),(426,7566,40720,1533,3,343,'App\\Models\\Receipt',343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',5793.00,NULL,NULL,1,'2023-02-20 16:35:13','2023-02-20 17:57:15','2023-02-20 17:57:15'),(427,7566,40720,1533,3,344,'App\\Models\\Receipt',344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',2640.00,NULL,NULL,1,'2023-02-20 16:35:14','2023-02-20 17:58:14','2023-02-20 17:58:14'),(428,7566,40720,1533,3,345,'App\\Models\\Receipt',345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',5038.98,NULL,NULL,1,'2023-02-20 16:35:14','2023-02-20 18:03:11','2023-02-20 18:03:11'),(429,7566,40720,1533,3,346,'App\\Models\\Receipt',346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',1470.00,NULL,NULL,1,'2023-02-20 16:35:14','2023-02-20 18:05:59','2023-02-20 18:05:59'),(430,7566,40720,1533,3,347,'App\\Models\\Receipt',347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',6895.67,NULL,NULL,1,'2023-02-20 16:35:14','2023-02-20 18:33:12','2023-02-20 18:33:12'),(431,7566,40720,1533,3,348,'App\\Models\\Receipt',348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',2200.00,NULL,NULL,1,'2023-02-20 16:35:14','2023-02-20 18:07:33','2023-02-20 18:07:33'),(432,7566,40720,1533,3,349,'App\\Models\\Receipt',349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',2200.00,NULL,NULL,1,'2023-02-20 16:35:14','2023-02-20 18:33:39','2023-02-20 18:33:39'),(433,7566,40720,1533,3,350,'App\\Models\\Receipt',350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',2200.00,NULL,NULL,1,'2023-02-20 16:35:14','2023-02-20 18:33:29','2023-02-20 18:33:29'),(434,7566,40720,1533,3,351,'App\\Models\\Receipt',351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',2699.82,NULL,NULL,1,'2023-02-20 16:35:14','2023-02-20 18:11:56','2023-02-20 18:11:56'),(435,7566,40720,1533,3,352,'App\\Models\\Receipt',352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',10805.44,NULL,NULL,1,'2023-02-20 16:35:14','2023-02-20 18:17:14','2023-02-20 18:17:14');
INSERT INTO `balance_libro` VALUES (436,7566,40720,1533,3,353,'App\\Models\\Receipt',353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',16380.34,NULL,NULL,1,'2023-02-20 16:35:14','2023-02-20 18:19:10','2023-02-20 18:19:10'),(437,7566,40720,1533,3,354,'App\\Models\\Receipt',354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',1580.00,NULL,NULL,1,'2023-02-20 16:35:14','2023-02-20 18:19:45','2023-02-20 18:19:45'),(438,7566,40720,1533,3,355,'App\\Models\\Receipt',355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',6608.00,NULL,NULL,1,'2023-02-20 16:35:14','2023-02-20 18:31:21','2023-02-20 18:31:21'),(439,7566,40720,1533,3,356,'App\\Models\\Receipt',356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2200.00,NULL,NULL,1,'2023-02-20 16:35:14','2023-02-20 18:23:17','2023-02-20 18:23:17'),(440,7566,40720,1533,3,357,'App\\Models\\Receipt',357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',4180.00,NULL,NULL,1,'2023-02-20 16:35:14','2023-02-20 18:24:32','2023-02-20 18:24:32'),(441,7566,40720,1533,3,358,'App\\Models\\Receipt',358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',832.30,NULL,NULL,1,'2023-02-20 16:35:14','2023-11-18 12:32:36','2023-11-18 12:32:36'),(442,7566,40720,1533,3,359,'App\\Models\\Receipt',359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',7370.00,NULL,NULL,1,'2023-02-20 16:35:14','2023-02-20 18:27:02','2023-02-20 18:27:02'),(443,7566,40720,1533,3,360,'App\\Models\\Receipt',360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',3386.84,NULL,NULL,1,'2023-02-20 16:35:14','2023-02-20 18:28:44','2023-02-20 18:28:44'),(444,7566,40720,1533,3,361,'App\\Models\\Receipt',361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2142.00,NULL,NULL,1,'2023-02-20 16:35:14','2023-02-20 18:29:35','2023-02-20 18:29:35'),(445,7566,40720,1533,3,336,'App\\Models\\Receipt',336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',5736.83,NULL,NULL,1,'2023-02-20 17:37:25','2023-02-20 17:38:00','2023-02-20 17:38:00'),(446,7566,40720,1533,3,335,'App\\Models\\Receipt',335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',3300.00,NULL,NULL,1,'2023-02-20 17:37:48','2023-02-20 19:34:45','2023-02-20 19:34:45'),(447,7566,40720,1533,3,336,'App\\Models\\Receipt',336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',5736.83,NULL,NULL,1,'2023-02-20 17:38:00','2023-02-20 17:38:00',NULL),(448,7566,40720,1533,3,337,'App\\Models\\Receipt',337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',11250.00,NULL,NULL,1,'2023-02-20 17:38:35','2023-02-20 17:38:35',NULL),(449,7566,40720,1533,3,339,'App\\Models\\Receipt',339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',14220.00,NULL,NULL,1,'2023-02-20 17:41:13','2023-02-20 17:41:13',NULL),(450,7566,40720,1533,3,341,'App\\Models\\Receipt',341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',4444.35,NULL,NULL,1,'2023-02-20 17:50:27','2023-02-20 17:50:55','2023-02-20 17:50:55'),(451,7566,40720,1533,3,341,'App\\Models\\Receipt',341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',7846.98,NULL,NULL,1,'2023-02-20 17:50:55','2023-02-20 17:50:55',NULL),(452,7566,40720,1533,3,342,'App\\Models\\Receipt',342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',4050.23,NULL,NULL,1,'2023-02-20 17:55:09','2023-02-20 17:55:09',NULL),(453,7566,40720,1533,3,343,'App\\Models\\Receipt',343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',5793.00,NULL,NULL,1,'2023-02-20 17:57:15','2023-02-20 17:57:15',NULL),(454,7566,40720,1533,3,344,'App\\Models\\Receipt',344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',2640.00,NULL,NULL,1,'2023-02-20 17:58:14','2023-02-20 17:58:14',NULL),(455,7566,40720,1533,3,345,'App\\Models\\Receipt',345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',5038.98,NULL,NULL,1,'2023-02-20 18:03:11','2023-02-20 18:03:25','2023-02-20 18:03:25');
INSERT INTO `balance_libro` VALUES (456,7566,40720,1533,3,345,'App\\Models\\Receipt',345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',5038.98,NULL,NULL,1,'2023-02-20 18:03:25','2023-11-18 12:29:03','2023-11-18 12:29:03'),(457,7566,40720,1533,3,346,'App\\Models\\Receipt',346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',1470.00,NULL,NULL,1,'2023-02-20 18:05:59','2023-02-20 18:05:59',NULL),(458,7566,40720,1533,3,348,'App\\Models\\Receipt',348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',2200.00,NULL,NULL,1,'2023-02-20 18:07:33','2023-02-20 18:07:33',NULL),(459,7566,40720,1533,3,351,'App\\Models\\Receipt',351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',2699.82,NULL,NULL,1,'2023-02-20 18:11:56','2023-02-20 18:11:56',NULL),(460,7566,40720,1533,3,352,'App\\Models\\Receipt',352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',10805.44,NULL,NULL,1,'2023-02-20 18:17:14','2023-11-18 12:32:11','2023-11-18 12:32:11'),(461,7566,40720,1533,3,353,'App\\Models\\Receipt',353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',16380.34,NULL,NULL,1,'2023-02-20 18:19:10','2023-11-18 12:32:00','2023-11-18 12:32:00'),(462,7566,40720,1533,3,354,'App\\Models\\Receipt',354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',1580.01,NULL,NULL,1,'2023-02-20 18:19:45','2023-02-20 18:19:45',NULL),(463,7566,40720,1533,3,356,'App\\Models\\Receipt',356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2200.00,NULL,NULL,1,'2023-02-20 18:23:17','2023-02-20 18:23:17',NULL),(464,7566,40720,1533,3,357,'App\\Models\\Receipt',357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',4180.00,NULL,NULL,1,'2023-02-20 18:24:32','2023-02-20 18:24:32',NULL),(465,7566,40720,1533,3,359,'App\\Models\\Receipt',359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',7370.00,NULL,NULL,1,'2023-02-20 18:27:02','2023-11-18 12:33:19','2023-11-18 12:33:19'),(466,7566,40720,1533,3,360,'App\\Models\\Receipt',360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',3386.85,NULL,NULL,1,'2023-02-20 18:28:44','2023-02-20 18:28:44',NULL),(467,7566,40720,1533,3,361,'App\\Models\\Receipt',361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2142.00,NULL,NULL,1,'2023-02-20 18:29:35','2023-02-20 18:29:35',NULL),(468,7566,40720,1533,3,355,'App\\Models\\Receipt',355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',6608.00,NULL,NULL,1,'2023-02-20 18:31:21','2023-02-20 18:31:39','2023-02-20 18:31:39'),(469,7566,40720,1533,3,355,'App\\Models\\Receipt',355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',6608.00,NULL,NULL,1,'2023-02-20 18:31:39','2023-02-20 18:31:39',NULL),(470,7566,40720,1533,3,362,'App\\Models\\Receipt',362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',6950.00,NULL,NULL,1,'2023-02-20 18:44:02','2023-02-20 18:44:02',NULL),(471,7566,40720,1533,3,363,'App\\Models\\Receipt',363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',46403.50,NULL,NULL,1,'2023-02-20 19:00:21','2023-02-20 19:02:22','2023-02-20 19:02:22'),(472,7566,40720,1533,3,364,'App\\Models\\Receipt',364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',26741.00,NULL,NULL,1,'2023-02-20 19:00:57','2023-02-20 19:01:57','2023-02-20 19:01:57'),(473,7566,40720,1533,3,365,'App\\Models\\Receipt',365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',43560.00,NULL,NULL,1,'2023-02-20 19:01:33','2023-02-20 19:01:33',NULL),(474,7566,40720,1533,3,364,'App\\Models\\Receipt',364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',26741.00,NULL,NULL,1,'2023-02-20 19:01:57','2023-02-20 19:01:57',NULL),(475,7566,40720,1533,3,363,'App\\Models\\Receipt',363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',46403.50,NULL,NULL,1,'2023-02-20 19:02:22','2023-02-20 19:02:22',NULL);
INSERT INTO `balance_libro` VALUES (476,7566,40720,1533,3,366,'App\\Models\\Receipt',366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',2400.00,NULL,NULL,1,'2023-02-20 19:05:35','2023-02-20 19:05:35',NULL),(477,7566,40720,1533,3,367,'App\\Models\\Receipt',367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',2600.00,NULL,NULL,1,'2023-02-20 19:05:59','2023-02-20 19:05:59',NULL),(478,7566,40720,1533,3,368,'App\\Models\\Receipt',368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5900.00,NULL,NULL,1,'2023-02-20 19:08:08','2023-02-20 19:08:08',NULL),(479,7566,40720,1533,3,369,'App\\Models\\Receipt',369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',3720.00,NULL,NULL,1,'2023-02-20 19:08:52','2023-02-20 19:08:52',NULL),(480,7566,40720,1533,3,370,'App\\Models\\Receipt',370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',7506.36,NULL,NULL,1,'2023-02-20 19:09:49','2023-02-20 19:10:26','2023-02-20 19:10:26'),(481,7566,40720,1533,3,370,'App\\Models\\Receipt',370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',7562.48,NULL,NULL,1,'2023-02-20 19:10:26','2023-02-20 19:10:26',NULL),(482,7566,40720,1533,3,371,'App\\Models\\Receipt',371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',7002.15,NULL,NULL,1,'2023-02-20 19:11:29','2023-02-20 19:11:29',NULL),(483,7566,40720,1533,3,372,'App\\Models\\Receipt',372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',3125.51,NULL,NULL,1,'2023-02-20 19:13:16','2023-02-20 19:13:16',NULL),(484,7566,40720,1533,3,373,'App\\Models\\Receipt',373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',5383.27,NULL,NULL,1,'2023-02-20 19:14:54','2023-02-20 19:14:54',NULL),(485,7566,40720,1533,3,335,'App\\Models\\Receipt',335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',3300.00,NULL,NULL,1,'2023-02-20 19:34:45','2023-02-20 19:34:45',NULL),(486,7566,40720,1534,2,374,'App\\Models\\Receipt',374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',163435.85,NULL,NULL,1,'2023-03-19 11:52:53','2023-03-19 11:52:53',NULL),(487,7566,40720,1534,2,375,'App\\Models\\Receipt',375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',196157.69,NULL,NULL,1,'2023-03-19 11:52:53','2023-03-19 11:52:53',NULL),(488,7566,40720,1534,2,376,'App\\Models\\Receipt',376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',4824.60,NULL,NULL,1,'2023-03-19 11:52:53','2023-03-19 11:52:53',NULL),(489,7566,40720,1534,2,377,'App\\Models\\Receipt',377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',9365.85,NULL,NULL,1,'2023-03-19 11:52:53','2023-03-19 11:52:53',NULL),(490,7566,40720,1534,2,378,'App\\Models\\Receipt',378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',293325.80,NULL,NULL,1,'2023-03-19 11:52:53','2023-03-19 11:52:53',NULL),(491,7566,40720,1534,2,379,'App\\Models\\Receipt',379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',160544.86,NULL,NULL,1,'2023-03-19 11:52:53','2023-03-19 11:52:53',NULL),(492,7566,40720,1534,3,380,'App\\Models\\Receipt',380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',16666.16,NULL,NULL,1,'2023-03-19 11:54:23','2023-03-19 12:35:32','2023-03-19 12:35:32'),(493,7566,40720,1534,3,381,'App\\Models\\Receipt',381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',3300.00,NULL,NULL,1,'2023-03-19 11:54:24','2023-03-19 13:17:38','2023-03-19 13:17:38'),(494,7566,40720,1534,3,382,'App\\Models\\Receipt',382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',11250.00,NULL,NULL,1,'2023-03-19 11:54:24','2023-03-19 12:41:57','2023-03-19 12:41:57'),(495,7566,40720,1534,3,383,'App\\Models\\Receipt',383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',2950.00,NULL,NULL,1,'2023-03-19 11:54:24','2023-03-19 11:54:24',NULL),(496,7566,40720,1534,3,384,'App\\Models\\Receipt',384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',4000.00,NULL,NULL,1,'2023-03-19 11:54:24','2023-03-19 11:54:24',NULL);
INSERT INTO `balance_libro` VALUES (497,7566,40720,1534,3,385,'App\\Models\\Receipt',385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',4827.06,NULL,NULL,1,'2023-03-19 11:54:24','2023-03-19 13:16:17','2023-03-19 13:16:17'),(498,7566,40720,1534,3,386,'App\\Models\\Receipt',386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',3249.48,NULL,NULL,1,'2023-03-19 11:54:24','2023-03-19 13:14:59','2023-03-19 13:14:59'),(499,7566,40720,1534,3,387,'App\\Models\\Receipt',387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',3800.00,NULL,NULL,1,'2023-03-19 11:54:24','2023-03-19 11:54:24',NULL),(500,7566,40720,1534,3,388,'App\\Models\\Receipt',388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',3000.00,NULL,NULL,1,'2023-03-19 11:54:24','2023-03-19 13:08:09','2023-03-19 13:08:09'),(501,7566,40720,1534,3,389,'App\\Models\\Receipt',389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',2900.00,NULL,NULL,1,'2023-03-19 11:54:24','2023-03-19 12:45:21','2023-03-19 12:45:21'),(502,7566,40720,1534,3,390,'App\\Models\\Receipt',390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',2640.00,NULL,NULL,1,'2023-03-19 11:54:24','2023-03-19 11:54:24',NULL),(503,7566,40720,1534,3,391,'App\\Models\\Receipt',391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',5960.00,NULL,NULL,1,'2023-03-19 11:54:24','2023-03-19 12:45:33','2023-03-19 12:45:33'),(504,7566,40720,1534,3,392,'App\\Models\\Receipt',392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',15820.00,NULL,NULL,1,'2023-03-19 11:54:24','2023-03-19 12:45:46','2023-03-19 12:45:46'),(505,7566,40720,1534,3,393,'App\\Models\\Receipt',393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',5231.47,NULL,NULL,1,'2023-03-19 11:54:24','2023-03-19 12:46:23','2023-03-19 12:46:23'),(506,7566,40720,1534,3,394,'App\\Models\\Receipt',394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',5520.02,NULL,NULL,1,'2023-03-19 11:54:24','2023-03-19 13:06:01','2023-03-19 13:06:01'),(507,7566,40720,1534,3,395,'App\\Models\\Receipt',395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',5520.02,NULL,NULL,1,'2023-03-19 11:54:24','2023-03-19 13:05:00','2023-03-19 13:05:00'),(508,7566,40720,1534,3,396,'App\\Models\\Receipt',396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',9696.33,NULL,NULL,1,'2023-03-19 11:54:24','2023-03-19 13:04:22','2023-03-19 13:04:22'),(509,7566,40720,1534,3,397,'App\\Models\\Receipt',397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',3300.00,NULL,NULL,1,'2023-03-19 11:54:24','2023-03-19 11:54:24',NULL),(510,7566,40720,1534,3,398,'App\\Models\\Receipt',398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',13790.84,NULL,NULL,1,'2023-03-19 11:54:24','2023-03-19 13:03:07','2023-03-19 13:03:07'),(511,7566,40720,1534,3,399,'App\\Models\\Receipt',399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',7964.88,NULL,NULL,1,'2023-03-19 11:54:24','2023-03-19 12:55:38','2023-03-19 12:55:38'),(512,7566,40720,1534,3,400,'App\\Models\\Receipt',400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',2200.00,NULL,NULL,1,'2023-03-19 11:54:24','2023-03-19 11:54:24',NULL),(513,7566,40720,1534,3,401,'App\\Models\\Receipt',401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',3278.69,NULL,NULL,1,'2023-03-19 11:54:24','2023-03-19 12:46:40','2023-03-19 12:46:40'),(514,7566,40720,1534,3,402,'App\\Models\\Receipt',402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',37504.01,NULL,NULL,1,'2023-03-19 11:54:24','2023-03-19 12:46:58','2023-03-19 12:46:58'),(515,7566,40720,1534,3,403,'App\\Models\\Receipt',403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',2540.00,NULL,NULL,1,'2023-03-19 11:54:24','2023-03-19 12:44:46','2023-03-19 12:44:46'),(516,7566,40720,1534,3,404,'App\\Models\\Receipt',404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',6570.06,NULL,NULL,1,'2023-03-19 11:54:24','2023-03-19 12:52:18','2023-03-19 12:52:18');
INSERT INTO `balance_libro` VALUES (517,7566,40720,1534,3,405,'App\\Models\\Receipt',405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',10500.00,NULL,NULL,1,'2023-03-19 11:54:24','2023-03-19 12:39:15','2023-03-19 12:39:15'),(518,7566,40720,1534,3,406,'App\\Models\\Receipt',406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',10800.00,NULL,NULL,1,'2023-03-19 11:54:24','2023-03-19 12:51:11','2023-03-19 12:51:11'),(519,7566,40720,1534,3,407,'App\\Models\\Receipt',407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',7000.00,NULL,NULL,1,'2023-03-19 11:54:24','2023-03-19 12:41:16','2023-03-19 12:41:16'),(520,7566,40720,1534,3,408,'App\\Models\\Receipt',408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',498.90,NULL,NULL,1,'2023-03-19 11:54:24','2023-03-19 12:47:19','2023-03-19 12:47:19'),(521,7566,40720,1534,3,409,'App\\Models\\Receipt',409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',7200.00,NULL,NULL,1,'2023-03-19 11:54:24','2023-03-19 12:48:32','2023-03-19 12:48:32'),(522,7566,40720,1534,7,410,'App\\Models\\Receipt',410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',4395.30,NULL,NULL,1,'2023-03-19 11:58:38','2023-03-19 11:58:38',NULL),(523,7566,40720,1534,7,411,'App\\Models\\Receipt',411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',863.51,NULL,NULL,1,'2023-03-19 11:58:38','2023-03-19 11:58:38',NULL),(524,7566,40720,1534,7,412,'App\\Models\\Receipt',412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',3132.16,NULL,NULL,1,'2023-03-19 11:58:38','2023-03-19 11:58:38',NULL),(525,7566,40720,1534,7,413,'App\\Models\\Receipt',413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',4309.12,NULL,NULL,1,'2023-03-19 11:58:38','2023-03-19 11:58:38',NULL),(526,7566,40720,1534,7,414,'App\\Models\\Receipt',414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',837.85,NULL,NULL,1,'2023-03-19 11:58:38','2023-03-19 11:58:38',NULL),(527,7566,40720,1534,7,415,'App\\Models\\Receipt',415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',155.76,NULL,NULL,1,'2023-03-19 11:58:38','2023-03-19 11:58:38',NULL),(528,7566,40720,1534,7,416,'App\\Models\\Receipt',416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',1210.15,NULL,NULL,1,'2023-03-19 11:58:38','2023-03-19 11:58:38',NULL),(529,7566,40720,1534,7,417,'App\\Models\\Receipt',417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',669.86,NULL,NULL,1,'2023-03-19 11:58:38','2023-03-19 11:58:38',NULL),(530,7566,40720,1534,7,418,'App\\Models\\Receipt',418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',10651.05,NULL,NULL,1,'2023-03-19 11:58:38','2023-03-19 11:58:38',NULL),(531,7566,40720,1534,7,419,'App\\Models\\Receipt',419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',2633.51,NULL,NULL,1,'2023-03-19 11:58:38','2023-03-19 11:58:38',NULL),(532,7566,40720,1534,7,420,'App\\Models\\Receipt',420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',1170.16,NULL,NULL,1,'2023-03-19 11:58:38','2023-03-19 11:58:38',NULL),(533,7566,40720,1534,8,421,'App\\Models\\Receipt',421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',100.57,NULL,NULL,1,'2023-03-19 12:09:24','2023-03-19 12:09:24',NULL),(534,7566,40720,1534,3,405,'App\\Models\\Receipt',405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',10500.00,NULL,NULL,1,'2023-03-19 12:39:15','2023-03-19 12:51:26','2023-03-19 12:51:26'),(535,7566,40720,1534,3,407,'App\\Models\\Receipt',407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',7000.00,NULL,NULL,1,'2023-03-19 12:41:16','2023-03-19 12:50:08','2023-03-19 12:50:08'),(536,7566,40720,1534,3,382,'App\\Models\\Receipt',382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',11250.00,NULL,NULL,1,'2023-03-19 12:41:57','2023-03-19 12:41:57',NULL);
INSERT INTO `balance_libro` VALUES (537,7566,40720,1534,3,403,'App\\Models\\Receipt',403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',2540.00,NULL,NULL,1,'2023-03-19 12:44:46','2023-03-19 12:52:50','2023-03-19 12:52:50'),(538,7566,40720,1534,3,409,'App\\Models\\Receipt',409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',7200.00,NULL,NULL,1,'2023-03-19 12:48:32','2023-03-19 12:48:32',NULL),(539,7566,40720,1534,3,406,'App\\Models\\Receipt',406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',10800.00,NULL,NULL,1,'2023-03-19 12:51:11','2023-03-19 12:51:11',NULL),(540,7566,40720,1534,3,404,'App\\Models\\Receipt',404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',6570.06,NULL,NULL,1,'2023-03-19 12:52:18','2023-03-19 12:52:18',NULL),(541,7566,40720,1534,3,403,'App\\Models\\Receipt',403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',2540.00,NULL,NULL,1,'2023-03-19 12:52:50','2023-03-19 12:52:50',NULL),(542,7566,40720,1534,3,399,'App\\Models\\Receipt',399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',4827.06,NULL,NULL,1,'2023-03-19 12:55:38','2023-03-19 12:57:05','2023-03-19 12:57:05'),(543,7566,40720,1534,3,422,'App\\Models\\Receipt',422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',6895.67,NULL,NULL,1,'2023-03-19 13:00:12','2023-03-19 16:02:56','2023-03-19 16:02:56'),(544,7566,40720,1534,3,398,'App\\Models\\Receipt',398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',13790.84,NULL,NULL,1,'2023-03-19 13:03:07','2023-03-19 15:47:44','2023-03-19 15:47:44'),(545,7566,40720,1534,3,396,'App\\Models\\Receipt',396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',9696.33,NULL,NULL,1,'2023-03-19 13:04:22','2023-03-19 13:04:22',NULL),(546,7566,40720,1534,3,395,'App\\Models\\Receipt',395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',5520.02,NULL,NULL,1,'2023-03-19 13:05:00','2023-03-19 13:05:00',NULL),(547,7566,40720,1534,3,388,'App\\Models\\Receipt',388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',3000.00,NULL,NULL,1,'2023-03-19 13:08:09','2023-03-19 13:13:20','2023-03-19 13:13:20'),(548,7566,40720,1534,3,388,'App\\Models\\Receipt',388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',3000.00,NULL,NULL,1,'2023-03-19 13:13:20','2023-03-19 13:13:20',NULL),(549,7566,40720,1534,3,386,'App\\Models\\Receipt',386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',3249.48,NULL,NULL,1,'2023-03-19 13:14:59','2023-03-19 13:14:59',NULL),(550,7566,40720,1534,3,385,'App\\Models\\Receipt',385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',4827.06,NULL,NULL,1,'2023-03-19 13:16:17','2023-03-19 16:04:06','2023-03-19 16:04:06'),(551,7566,40720,1534,3,381,'App\\Models\\Receipt',381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',3300.00,NULL,NULL,1,'2023-03-19 13:17:38','2023-03-19 16:02:08','2023-03-19 16:02:08'),(552,7566,40720,1534,3,423,'App\\Models\\Receipt',423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',2500.01,NULL,NULL,1,'2023-03-19 13:20:49','2023-03-19 13:27:01','2023-03-19 13:27:01'),(553,7566,40720,1534,3,424,'App\\Models\\Receipt',424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',5000.00,NULL,NULL,1,'2023-03-19 13:21:17','2023-03-19 13:26:32','2023-03-19 13:26:32'),(554,7566,40720,1534,3,425,'App\\Models\\Receipt',425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',2600.00,NULL,NULL,1,'2023-03-19 13:21:47','2023-03-19 13:21:47',NULL),(555,7566,40720,1534,3,426,'App\\Models\\Receipt',426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',6380.00,NULL,NULL,1,'2023-03-19 13:24:18','2023-03-19 13:24:18',NULL),(556,7566,40720,1534,3,427,'App\\Models\\Receipt',427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',7965.79,NULL,NULL,1,'2023-03-19 13:25:40','2023-03-19 13:25:40',NULL);
INSERT INTO `balance_libro` VALUES (557,7566,40720,1534,3,424,'App\\Models\\Receipt',424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',5000.00,NULL,NULL,1,'2023-03-19 13:26:32','2023-03-19 13:26:32',NULL),(558,7566,40720,1534,3,423,'App\\Models\\Receipt',423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',2500.01,NULL,NULL,1,'2023-03-19 13:27:01','2023-03-19 13:27:01',NULL),(559,7566,40720,1534,3,428,'App\\Models\\Receipt',428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',7400.56,NULL,NULL,1,'2023-03-19 13:28:24','2023-03-19 13:28:24',NULL),(560,7566,40720,1534,3,429,'App\\Models\\Receipt',429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',8001.00,NULL,NULL,1,'2023-03-19 13:29:34','2023-03-19 13:29:34',NULL),(561,7566,40720,1534,3,430,'App\\Models\\Receipt',430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',2580.00,NULL,NULL,1,'2023-03-19 13:31:05','2023-03-19 13:31:05',NULL),(562,7566,40720,1534,3,431,'App\\Models\\Receipt',431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',6000.00,NULL,NULL,1,'2023-03-19 13:32:24','2023-03-19 13:32:24',NULL),(563,7566,40720,1534,3,432,'App\\Models\\Receipt',432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',36300.00,NULL,NULL,1,'2023-03-19 13:33:25','2023-03-19 13:39:06','2023-03-19 13:39:06'),(564,7566,40720,1534,3,433,'App\\Models\\Receipt',433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',32065.00,NULL,NULL,1,'2023-03-19 13:33:50','2023-03-19 13:38:47','2023-03-19 13:38:47'),(565,7566,40720,1534,3,434,'App\\Models\\Receipt',434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',46948.00,NULL,NULL,1,'2023-03-19 13:34:10','2023-03-19 13:38:22','2023-03-19 13:38:22'),(566,7566,40720,1534,3,435,'App\\Models\\Receipt',435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',10520.47,NULL,NULL,1,'2023-03-19 13:35:56','2023-03-19 13:35:56',NULL),(567,7566,40720,1534,3,436,'App\\Models\\Receipt',436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',2819.99,NULL,NULL,1,'2023-03-19 13:37:27','2023-03-19 13:37:27',NULL),(568,7566,40720,1534,3,434,'App\\Models\\Receipt',434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',46948.00,NULL,NULL,1,'2023-03-19 13:38:22','2023-03-19 13:38:22',NULL),(569,7566,40720,1534,3,433,'App\\Models\\Receipt',433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',32065.00,NULL,NULL,1,'2023-03-19 13:38:47','2023-03-19 13:38:47',NULL),(570,7566,40720,1534,3,432,'App\\Models\\Receipt',432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',36300.00,NULL,NULL,1,'2023-03-19 13:39:06','2023-03-19 13:39:06',NULL),(571,7566,40720,1534,3,398,'App\\Models\\Receipt',398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',13790.84,NULL,NULL,1,'2023-03-19 15:47:44','2023-03-19 15:47:44',NULL),(572,7566,40720,1534,3,381,'App\\Models\\Receipt',381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',3300.00,NULL,NULL,1,'2023-03-19 16:02:08','2023-03-19 16:03:31','2023-03-19 16:03:31'),(573,7566,40720,1534,3,422,'App\\Models\\Receipt',422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',6895.67,NULL,NULL,1,'2023-03-19 16:02:56','2023-03-19 16:02:56',NULL),(574,7566,40720,1534,3,381,'App\\Models\\Receipt',381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',3300.00,NULL,NULL,1,'2023-03-19 16:03:31','2023-03-19 16:03:31',NULL),(575,7566,40720,1534,3,385,'App\\Models\\Receipt',385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',4827.06,NULL,NULL,1,'2023-03-19 16:04:06','2023-03-19 16:04:06',NULL),(576,7566,40720,1534,3,437,'App\\Models\\Receipt',437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',2900.00,NULL,NULL,1,'2023-03-22 19:05:32','2023-03-22 19:05:32',NULL),(577,7566,40720,1534,3,438,'App\\Models\\Receipt',438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',5960.00,NULL,NULL,1,'2023-03-22 19:07:09','2023-03-22 19:07:09',NULL);
INSERT INTO `balance_libro` VALUES (578,7566,40720,1534,3,439,'App\\Models\\Receipt',439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',15820.00,NULL,NULL,1,'2023-03-22 19:08:11','2023-03-22 19:08:11',NULL),(579,7566,40720,1534,3,440,'App\\Models\\Receipt',440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',5231.47,NULL,NULL,1,'2023-03-22 19:08:59','2023-03-22 19:08:59',NULL),(580,7566,40720,1534,3,441,'App\\Models\\Receipt',441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',5520.02,NULL,NULL,1,'2023-03-22 19:09:51','2023-03-22 19:09:51',NULL),(581,7566,40720,1534,3,442,'App\\Models\\Receipt',442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',3278.69,NULL,NULL,1,'2023-03-22 19:11:43','2023-03-22 19:11:43',NULL),(582,7566,40720,1534,3,443,'App\\Models\\Receipt',443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',37504.01,NULL,NULL,1,'2023-03-22 19:13:32','2023-03-22 19:13:32',NULL),(583,7566,40720,1534,3,444,'App\\Models\\Receipt',444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',498.90,NULL,NULL,1,'2023-03-22 19:16:10','2023-03-22 19:16:10',NULL),(584,7566,40720,1534,3,445,'App\\Models\\Receipt',445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',10500.00,NULL,NULL,1,'2023-03-22 19:17:04','2023-03-22 19:17:04',NULL),(585,7566,40720,1534,3,446,'App\\Models\\Receipt',446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',7000.00,NULL,NULL,1,'2023-03-22 19:17:40','2023-03-22 19:17:40',NULL),(586,7566,40720,1535,2,447,'App\\Models\\Receipt',447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',211451.58,NULL,NULL,1,'2023-04-19 11:01:22','2023-04-19 11:01:22',NULL),(587,7566,40720,1535,2,448,'App\\Models\\Receipt',448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',3475.81,NULL,NULL,1,'2023-04-19 11:01:22','2023-04-19 11:01:22',NULL),(588,7566,40720,1535,2,449,'App\\Models\\Receipt',449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',9622.21,NULL,NULL,1,'2023-04-19 11:01:22','2023-04-19 11:01:22',NULL),(589,7566,40720,1535,2,450,'App\\Models\\Receipt',450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',351966.48,NULL,NULL,1,'2023-04-19 11:01:22','2023-04-19 11:01:22',NULL),(590,7566,40720,1535,3,451,'App\\Models\\Receipt',451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',16666.16,NULL,NULL,1,'2023-04-19 11:01:44','2023-04-19 11:17:51','2023-04-19 11:17:51'),(591,7566,40720,1535,3,452,'App\\Models\\Receipt',452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',3300.00,NULL,NULL,1,'2023-04-19 11:01:44','2023-04-19 11:18:41','2023-04-19 11:18:41'),(592,7566,40720,1535,3,453,'App\\Models\\Receipt',453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',2120.00,NULL,NULL,1,'2023-04-19 11:01:44','2023-04-19 11:01:44',NULL),(593,7566,40720,1535,3,454,'App\\Models\\Receipt',454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',7666.85,NULL,NULL,1,'2023-04-19 11:01:44','2023-04-19 11:24:47','2023-04-19 11:24:47'),(594,7566,40720,1535,3,455,'App\\Models\\Receipt',455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',11250.00,NULL,NULL,1,'2023-04-19 11:01:44','2023-04-19 11:01:44',NULL),(595,7566,40720,1535,3,456,'App\\Models\\Receipt',456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',2000.00,NULL,NULL,1,'2023-04-19 11:01:44','2023-04-19 11:42:10','2023-04-19 11:42:10'),(596,7566,40720,1535,3,457,'App\\Models\\Receipt',457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',2500.00,NULL,NULL,1,'2023-04-19 11:01:45','2023-04-19 11:01:45',NULL),(597,7566,40720,1535,3,458,'App\\Models\\Receipt',458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',2540.00,NULL,NULL,1,'2023-04-19 11:01:45','2023-04-19 11:01:45',NULL),(598,7566,40720,1535,3,459,'App\\Models\\Receipt',459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',7964.88,NULL,NULL,1,'2023-04-19 11:01:45','2023-04-19 11:20:30','2023-04-19 11:20:30');
INSERT INTO `balance_libro` VALUES (599,7566,40720,1535,3,460,'App\\Models\\Receipt',460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',2640.00,NULL,NULL,1,'2023-04-19 11:01:45','2023-04-19 11:01:45',NULL),(600,7566,40720,1535,3,461,'App\\Models\\Receipt',461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',2900.00,NULL,NULL,1,'2023-04-19 11:01:45','2023-04-19 11:01:45',NULL),(601,7566,40720,1535,3,462,'App\\Models\\Receipt',462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',3618.56,NULL,NULL,1,'2023-04-19 11:01:45','2023-04-19 11:36:02','2023-04-19 11:36:02'),(602,7566,40720,1535,3,463,'App\\Models\\Receipt',463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',3000.00,NULL,NULL,1,'2023-04-19 11:01:45','2023-04-19 11:01:45',NULL),(603,7566,40720,1535,3,464,'App\\Models\\Receipt',464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',5400.00,NULL,NULL,1,'2023-04-19 11:01:45','2023-04-19 11:35:28','2023-04-19 11:35:28'),(604,7566,40720,1535,3,465,'App\\Models\\Receipt',465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',11143.32,NULL,NULL,1,'2023-04-19 11:01:45','2023-04-19 11:28:41','2023-04-19 11:28:41'),(605,7566,40720,1535,3,466,'App\\Models\\Receipt',466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',21000.00,NULL,NULL,1,'2023-04-19 11:01:45','2023-04-19 11:01:45',NULL),(606,7566,40720,1535,3,467,'App\\Models\\Receipt',467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',6284.50,NULL,NULL,1,'2023-04-19 11:01:45','2023-04-19 11:31:11','2023-04-19 11:31:11'),(607,7566,40720,1535,7,468,'App\\Models\\Receipt',468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',4745.27,NULL,NULL,1,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(608,7566,40720,1535,7,469,'App\\Models\\Receipt',469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',95.69,NULL,NULL,1,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(609,7566,40720,1535,7,470,'App\\Models\\Receipt',470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',1239.75,NULL,NULL,1,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(610,7566,40720,1535,7,471,'App\\Models\\Receipt',471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',593.26,NULL,NULL,1,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(611,7566,40720,1535,7,472,'App\\Models\\Receipt',472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',5429.92,NULL,NULL,1,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(612,7566,40720,1535,7,473,'App\\Models\\Receipt',473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',839.48,NULL,NULL,1,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(613,7566,40720,1535,7,474,'App\\Models\\Receipt',474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',3887.27,NULL,NULL,1,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(614,7566,40720,1535,7,475,'App\\Models\\Receipt',475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',60.50,NULL,NULL,1,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(615,7566,40720,1535,7,476,'App\\Models\\Receipt',476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',482.59,NULL,NULL,1,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(616,7566,40720,1535,7,477,'App\\Models\\Receipt',477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',2924.42,NULL,NULL,1,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(617,7566,40720,1535,7,478,'App\\Models\\Receipt',478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',11591.53,NULL,NULL,1,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(618,7566,40720,1535,7,479,'App\\Models\\Receipt',479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',2802.19,NULL,NULL,1,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(619,7566,40720,1535,7,480,'App\\Models\\Receipt',480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',1518.20,NULL,NULL,1,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL);
INSERT INTO `balance_libro` VALUES (620,7566,40720,1535,7,481,'App\\Models\\Receipt',481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',587.56,NULL,NULL,1,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(621,7566,40720,1535,8,482,'App\\Models\\Receipt',482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',99.71,NULL,NULL,1,'2023-04-19 11:06:53','2023-04-19 11:06:53',NULL),(622,7566,40720,1535,3,452,'App\\Models\\Receipt',452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',3300.00,NULL,NULL,1,'2023-04-19 11:18:41','2023-04-19 11:18:41',NULL),(623,7566,40720,1535,3,483,'App\\Models\\Receipt',483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',7964.88,NULL,NULL,1,'2023-04-19 11:22:25','2023-04-19 11:22:25',NULL),(624,7566,40720,1535,3,454,'App\\Models\\Receipt',454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',7666.85,NULL,NULL,1,'2023-04-19 11:24:47','2023-04-19 11:24:47',NULL),(625,7566,40720,1535,3,465,'App\\Models\\Receipt',465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',11143.33,NULL,NULL,1,'2023-04-19 11:28:41','2023-04-19 11:28:41',NULL),(626,7566,40720,1535,3,467,'App\\Models\\Receipt',467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',6284.50,NULL,NULL,1,'2023-04-19 11:31:11','2023-04-19 11:31:11',NULL),(627,7566,40720,1535,3,464,'App\\Models\\Receipt',464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',5400.00,NULL,NULL,1,'2023-04-19 11:35:28','2023-04-19 11:35:28',NULL),(628,7566,40720,1535,3,484,'App\\Models\\Receipt',484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',41140.00,NULL,NULL,1,'2023-04-19 11:43:57','2023-04-19 11:43:57',NULL),(629,7566,40720,1535,3,485,'App\\Models\\Receipt',485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',36905.00,NULL,NULL,1,'2023-04-19 11:44:28','2023-04-19 11:44:28',NULL),(630,7566,40720,1535,3,486,'App\\Models\\Receipt',486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',38838.58,NULL,NULL,1,'2023-04-19 11:44:51','2023-04-19 11:45:16','2023-04-19 11:45:16'),(631,7566,40720,1535,3,486,'App\\Models\\Receipt',486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',38838.58,NULL,NULL,1,'2023-04-19 11:45:16','2023-04-19 11:45:16',NULL),(632,7566,40720,1535,3,487,'App\\Models\\Receipt',487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',8940.76,NULL,NULL,1,'2023-04-19 11:46:17','2023-04-19 11:46:17',NULL),(633,7566,40720,1535,3,488,'App\\Models\\Receipt',488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',5850.00,NULL,NULL,1,'2023-04-19 11:46:46','2023-04-19 12:48:29','2023-04-19 12:48:29'),(634,7566,40720,1535,3,489,'App\\Models\\Receipt',489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',5602.29,NULL,NULL,1,'2023-04-19 11:47:48','2023-04-19 11:47:48',NULL),(635,7566,40720,1535,3,490,'App\\Models\\Receipt',490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',10474.99,NULL,NULL,1,'2023-04-19 11:48:23','2023-04-19 11:49:52','2023-04-19 11:49:52'),(636,7566,40720,1535,3,491,'App\\Models\\Receipt',491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',17030.00,NULL,NULL,1,'2023-04-19 11:49:28','2023-04-19 11:49:28',NULL),(637,7566,40720,1535,3,490,'App\\Models\\Receipt',490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',10474.99,NULL,NULL,1,'2023-04-19 11:49:52','2023-04-19 11:49:52',NULL),(638,7566,40720,1535,3,492,'App\\Models\\Receipt',492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',8197.52,NULL,NULL,1,'2023-04-19 11:51:25','2023-04-19 11:51:25',NULL),(639,7566,40720,1535,3,493,'App\\Models\\Receipt',493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',8520.44,NULL,NULL,1,'2023-04-19 11:52:06','2023-04-19 11:52:06',NULL),(640,7566,40720,1535,3,494,'App\\Models\\Receipt',494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',2389.13,NULL,NULL,1,'2023-04-19 11:53:45','2023-04-19 12:47:35','2023-04-19 12:47:35');
INSERT INTO `balance_libro` VALUES (641,7566,40720,1535,3,495,'App\\Models\\Receipt',495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',2900.00,NULL,NULL,1,'2023-04-19 11:54:35','2023-04-19 11:54:35',NULL),(642,7566,40720,1535,3,496,'App\\Models\\Receipt',496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',2840.00,NULL,NULL,1,'2023-04-19 11:55:10','2023-04-19 11:55:10',NULL),(643,7566,40720,1535,3,497,'App\\Models\\Receipt',497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',2640.00,NULL,NULL,1,'2023-04-19 11:55:41','2023-04-19 11:55:41',NULL),(644,7566,40720,1535,3,494,'App\\Models\\Receipt',494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',2389.13,NULL,NULL,1,'2023-04-19 12:47:35','2023-04-19 12:47:35',NULL),(645,7566,40720,1535,3,488,'App\\Models\\Receipt',488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',5850.00,NULL,NULL,1,'2023-04-19 12:48:29','2023-04-19 12:48:29',NULL),(646,7566,40719,22,2,498,'App\\Models\\Receipt',498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',3500.00,NULL,NULL,1,'2023-05-12 20:44:13','2023-05-12 20:46:10','2023-05-12 20:46:10'),(647,7566,40719,22,2,499,'App\\Models\\Receipt',499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',40000.00,NULL,NULL,1,'2023-05-12 20:44:13','2023-05-12 20:46:10','2023-05-12 20:46:10'),(648,7566,40719,22,2,500,'App\\Models\\Receipt',500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',13000.00,NULL,NULL,1,'2023-05-12 20:44:13','2023-05-12 20:46:10','2023-05-12 20:46:10'),(649,7566,40719,22,2,501,'App\\Models\\Receipt',501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',7000.00,NULL,NULL,1,'2023-05-12 20:44:13','2023-05-12 20:46:10','2023-05-12 20:46:10'),(650,7566,40719,22,2,502,'App\\Models\\Receipt',502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',12600.00,NULL,NULL,1,'2023-05-12 20:44:13','2023-05-12 20:46:10','2023-05-12 20:46:10'),(651,7566,40719,22,2,503,'App\\Models\\Receipt',503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',15600.00,NULL,NULL,1,'2023-05-12 20:44:13','2023-05-12 20:46:10','2023-05-12 20:46:10'),(652,7566,40719,22,2,504,'App\\Models\\Receipt',504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',11000.00,NULL,NULL,1,'2023-05-12 20:44:13','2023-05-12 20:46:10','2023-05-12 20:46:10'),(653,7566,40719,22,2,505,'App\\Models\\Receipt',505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',13000.00,NULL,NULL,1,'2023-05-12 20:44:13','2023-05-12 20:45:56','2023-05-12 20:45:56'),(654,7566,40719,22,2,506,'App\\Models\\Receipt',506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',17340.00,NULL,NULL,1,'2023-05-12 20:44:13','2023-05-12 20:45:53','2023-05-12 20:45:53'),(655,7566,40719,22,2,507,'App\\Models\\Receipt',507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',15600.00,NULL,NULL,1,'2023-05-12 20:44:13','2023-05-12 20:45:46','2023-05-12 20:45:46'),(656,7566,40719,22,2,508,'App\\Models\\Receipt',508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',13000.00,NULL,NULL,1,'2023-05-12 20:44:13','2023-05-12 20:45:42','2023-05-12 20:45:42'),(657,7566,40719,22,2,509,'App\\Models\\Receipt',509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',13000.00,NULL,NULL,1,'2023-05-12 20:44:13','2023-05-12 20:45:38','2023-05-12 20:45:38'),(658,7566,40719,22,2,510,'App\\Models\\Receipt',510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',15600.00,NULL,NULL,1,'2023-05-12 20:44:13','2023-05-12 20:45:35','2023-05-12 20:45:35'),(659,7566,40719,22,2,511,'App\\Models\\Receipt',511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',10000.00,NULL,NULL,1,'2023-05-12 20:44:13','2023-05-12 20:45:31','2023-05-12 20:45:31'),(660,7566,40719,22,2,512,'App\\Models\\Receipt',512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',13000.00,NULL,NULL,1,'2023-05-12 20:44:13','2023-05-12 20:45:27','2023-05-12 20:45:27');
INSERT INTO `balance_libro` VALUES (661,7566,40719,22,2,513,'App\\Models\\Receipt',513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',26000.00,NULL,NULL,1,'2023-05-12 20:44:13','2023-05-12 20:45:23','2023-05-12 20:45:23'),(662,7566,40719,21,2,514,'App\\Models\\Receipt',514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',3500.00,NULL,NULL,1,'2023-05-12 20:46:49','2023-05-12 20:46:49',NULL),(663,7566,40719,21,2,515,'App\\Models\\Receipt',515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',40000.00,NULL,NULL,1,'2023-05-12 20:46:49','2023-05-12 20:46:49',NULL),(664,7566,40719,21,2,516,'App\\Models\\Receipt',516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',13000.00,NULL,NULL,1,'2023-05-12 20:46:49','2023-05-12 20:46:49',NULL),(665,7566,40719,21,2,517,'App\\Models\\Receipt',517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',7000.00,NULL,NULL,1,'2023-05-12 20:46:49','2023-05-12 20:46:49',NULL),(666,7566,40719,21,2,518,'App\\Models\\Receipt',518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',12600.00,NULL,NULL,1,'2023-05-12 20:46:49','2023-05-12 20:46:49',NULL),(667,7566,40719,21,2,519,'App\\Models\\Receipt',519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',15600.00,NULL,NULL,1,'2023-05-12 20:46:49','2023-05-12 20:46:49',NULL),(668,7566,40719,21,2,520,'App\\Models\\Receipt',520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',11000.00,NULL,NULL,1,'2023-05-12 20:46:49','2023-05-12 20:46:49',NULL),(669,7566,40719,21,2,521,'App\\Models\\Receipt',521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',13000.00,NULL,NULL,1,'2023-05-12 20:46:49','2023-05-12 20:46:49',NULL),(670,7566,40719,21,2,522,'App\\Models\\Receipt',522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',17340.00,NULL,NULL,1,'2023-05-12 20:46:50','2023-05-12 20:46:50',NULL),(671,7566,40719,21,2,523,'App\\Models\\Receipt',523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',15600.00,NULL,NULL,1,'2023-05-12 20:46:50','2023-05-12 20:46:50',NULL),(672,7566,40719,21,2,524,'App\\Models\\Receipt',524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',13000.00,NULL,NULL,1,'2023-05-12 20:46:50','2023-05-12 20:46:50',NULL),(673,7566,40719,21,2,525,'App\\Models\\Receipt',525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',13000.00,NULL,NULL,1,'2023-05-12 20:46:50','2023-05-12 20:46:50',NULL),(674,7566,40719,21,2,526,'App\\Models\\Receipt',526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',15600.00,NULL,NULL,1,'2023-05-12 20:46:50','2023-05-12 20:46:50',NULL),(675,7566,40719,21,2,527,'App\\Models\\Receipt',527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',10000.00,NULL,NULL,1,'2023-05-12 20:46:50','2023-05-12 20:46:50',NULL),(676,7566,40719,21,2,528,'App\\Models\\Receipt',528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',13000.00,NULL,NULL,1,'2023-05-12 20:46:50','2023-05-12 20:46:50',NULL),(677,7566,40719,21,2,529,'App\\Models\\Receipt',529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',26000.00,NULL,NULL,1,'2023-05-12 20:46:50','2023-05-12 20:46:50',NULL),(678,7566,40719,21,3,530,'App\\Models\\Receipt',530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',39658.63,NULL,NULL,1,'2023-05-12 20:51:50','2023-05-12 20:53:47','2023-05-12 20:53:47'),(679,7566,40719,21,3,531,'App\\Models\\Receipt',531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',19000.00,NULL,NULL,1,'2023-05-12 20:51:51','2023-05-12 20:53:33','2023-05-12 20:53:33'),(680,7566,40719,21,3,532,'App\\Models\\Receipt',532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',9647.34,NULL,NULL,1,'2023-05-12 20:51:51','2023-05-12 20:53:19','2023-05-12 20:53:19'),(681,7566,40719,21,3,533,'App\\Models\\Receipt',533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',34337.72,NULL,NULL,1,'2023-05-12 20:51:51','2023-05-12 20:53:04','2023-05-12 20:53:04');
INSERT INTO `balance_libro` VALUES (682,7566,40719,21,3,534,'App\\Models\\Receipt',534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',6000.00,NULL,NULL,1,'2023-05-12 20:51:51','2023-05-12 20:52:46','2023-05-12 20:52:46'),(683,7566,40719,21,3,534,'App\\Models\\Receipt',534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',6000.00,NULL,NULL,1,'2023-05-12 20:52:46','2023-05-12 20:52:46',NULL),(684,7566,40719,21,3,533,'App\\Models\\Receipt',533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-23','2023-04-23',32963.22,NULL,NULL,1,'2023-05-12 20:53:04','2023-05-12 20:53:04',NULL),(685,7566,40719,21,3,532,'App\\Models\\Receipt',532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',9647.34,NULL,NULL,1,'2023-05-12 20:53:19','2023-05-12 20:53:19',NULL),(686,7566,40719,21,3,531,'App\\Models\\Receipt',531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',19000.00,NULL,NULL,1,'2023-05-12 20:53:33','2023-05-12 20:53:33',NULL),(687,7566,40719,21,3,530,'App\\Models\\Receipt',530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',39658.63,NULL,NULL,1,'2023-05-12 20:53:47','2023-05-12 20:53:47',NULL),(688,7566,40719,9,2,535,'App\\Models\\Receipt',535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2500.00,NULL,NULL,1,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(689,7566,40719,9,2,536,'App\\Models\\Receipt',536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2500.00,NULL,NULL,1,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(690,7566,40719,9,2,537,'App\\Models\\Receipt',537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2500.00,NULL,NULL,1,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(691,7566,40719,9,2,538,'App\\Models\\Receipt',538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2000.00,NULL,NULL,1,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(692,7566,40719,9,2,539,'App\\Models\\Receipt',539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3000.00,NULL,NULL,1,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(693,7566,40719,9,2,540,'App\\Models\\Receipt',540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3500.00,NULL,NULL,1,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(694,7566,40719,9,2,541,'App\\Models\\Receipt',541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2000.00,NULL,NULL,1,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(695,7566,40719,9,2,542,'App\\Models\\Receipt',542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',7000.00,NULL,NULL,1,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(696,7566,40719,9,2,543,'App\\Models\\Receipt',543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',3500.00,NULL,NULL,1,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(697,7566,40719,9,2,544,'App\\Models\\Receipt',544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2500.00,NULL,NULL,1,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(698,7566,40719,9,2,545,'App\\Models\\Receipt',545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2000.00,NULL,NULL,1,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(699,7566,40719,9,2,546,'App\\Models\\Receipt',546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2000.00,NULL,NULL,1,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(700,7566,40719,9,2,547,'App\\Models\\Receipt',547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2500.00,NULL,NULL,1,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(701,7566,40719,9,2,548,'App\\Models\\Receipt',548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',2500.00,NULL,NULL,1,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(702,7566,40719,9,2,549,'App\\Models\\Receipt',549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',5000.00,NULL,NULL,1,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL);
INSERT INTO `balance_libro` VALUES (703,7566,40719,10,2,550,'App\\Models\\Receipt',550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',2500.00,NULL,NULL,1,'2023-05-12 21:19:24','2023-05-12 21:19:24',NULL),(704,7566,40719,10,2,551,'App\\Models\\Receipt',551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',3000.00,NULL,NULL,1,'2023-05-12 21:19:24','2023-05-12 21:19:24',NULL),(705,7566,40719,10,2,552,'App\\Models\\Receipt',552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',3000.00,NULL,NULL,1,'2023-05-12 21:19:24','2023-05-12 21:19:24',NULL),(706,7566,40719,10,2,553,'App\\Models\\Receipt',553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',5000.00,NULL,NULL,1,'2023-05-12 21:19:24','2023-05-12 21:19:24',NULL),(707,7566,40719,10,2,554,'App\\Models\\Receipt',554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',2500.00,NULL,NULL,1,'2023-05-12 21:19:24','2023-05-12 21:19:24',NULL),(708,7566,40719,10,2,555,'App\\Models\\Receipt',555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',3000.00,NULL,NULL,1,'2023-05-12 21:19:24','2023-05-12 21:19:24',NULL),(709,7566,40719,10,2,556,'App\\Models\\Receipt',556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',3500.00,NULL,NULL,1,'2023-05-12 21:19:24','2023-05-12 21:19:24',NULL),(710,7566,40719,10,2,557,'App\\Models\\Receipt',557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',2000.00,NULL,NULL,1,'2023-05-12 21:19:24','2023-05-12 21:19:24',NULL),(711,7566,40719,10,2,558,'App\\Models\\Receipt',558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',7000.00,NULL,NULL,1,'2023-05-12 21:19:24','2023-05-12 21:19:24',NULL),(712,7566,40719,10,2,559,'App\\Models\\Receipt',559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',3500.00,NULL,NULL,1,'2023-05-12 21:19:24','2023-05-12 21:19:24',NULL),(713,7566,40719,10,2,560,'App\\Models\\Receipt',560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',3000.00,NULL,NULL,1,'2023-05-12 21:19:25','2023-05-12 21:19:25',NULL),(714,7566,40719,10,2,561,'App\\Models\\Receipt',561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',2500.00,NULL,NULL,1,'2023-05-12 21:19:25','2023-05-12 21:19:25',NULL),(715,7566,40719,10,2,562,'App\\Models\\Receipt',562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',2000.00,NULL,NULL,1,'2023-05-12 21:19:25','2023-05-12 21:19:25',NULL),(716,7566,40719,10,2,563,'App\\Models\\Receipt',563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',2500.00,NULL,NULL,1,'2023-05-12 21:19:25','2023-05-12 21:19:25',NULL),(717,7566,40719,10,2,564,'App\\Models\\Receipt',564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',2000.00,NULL,NULL,1,'2023-05-12 21:19:25','2023-05-12 21:19:25',NULL),(718,7566,40719,10,2,565,'App\\Models\\Receipt',565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',2500.00,NULL,NULL,1,'2023-05-12 21:19:25','2023-05-12 21:19:25',NULL),(719,7566,40719,10,2,566,'App\\Models\\Receipt',566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',2500.00,NULL,NULL,1,'2023-05-12 21:19:25','2023-05-12 21:19:25',NULL),(720,7566,40719,10,2,567,'App\\Models\\Receipt',567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',2000.00,NULL,NULL,1,'2023-05-12 21:19:25','2023-05-12 21:19:25',NULL),(721,7566,40719,10,2,568,'App\\Models\\Receipt',568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',2500.00,NULL,NULL,1,'2023-05-12 21:19:25','2023-05-12 21:19:25',NULL),(722,7566,40719,12,2,569,'App\\Models\\Receipt',569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',3000.00,NULL,NULL,1,'2023-05-12 21:20:11','2023-05-12 21:20:11',NULL),(723,7566,40719,12,2,570,'App\\Models\\Receipt',570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',2000.00,NULL,NULL,1,'2023-05-12 21:20:12','2023-05-12 21:20:12',NULL);
INSERT INTO `balance_libro` VALUES (724,7566,40719,12,2,571,'App\\Models\\Receipt',571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',7000.00,NULL,NULL,1,'2023-05-12 21:20:12','2023-05-12 21:20:12',NULL),(725,7566,40719,12,2,572,'App\\Models\\Receipt',572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',3500.00,NULL,NULL,1,'2023-05-12 21:20:12','2023-05-12 21:20:12',NULL),(726,7566,40719,12,2,573,'App\\Models\\Receipt',573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',3000.00,NULL,NULL,1,'2023-05-12 21:20:12','2023-05-12 21:20:12',NULL),(727,7566,40719,12,2,574,'App\\Models\\Receipt',574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',2500.00,NULL,NULL,1,'2023-05-12 21:20:12','2023-05-12 21:20:12',NULL),(728,7566,40719,12,2,575,'App\\Models\\Receipt',575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',2000.00,NULL,NULL,1,'2023-05-12 21:20:12','2023-05-12 21:20:12',NULL),(729,7566,40719,12,2,576,'App\\Models\\Receipt',576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',2500.00,NULL,NULL,1,'2023-05-12 21:20:12','2023-05-12 21:20:12',NULL),(730,7566,40719,12,2,577,'App\\Models\\Receipt',577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',2500.00,NULL,NULL,1,'2023-05-12 21:20:12','2023-05-12 21:20:12',NULL),(731,7566,40719,12,2,578,'App\\Models\\Receipt',578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',2500.00,NULL,NULL,1,'2023-05-12 21:20:12','2023-05-12 21:20:12',NULL),(732,7566,40719,12,2,579,'App\\Models\\Receipt',579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',2500.00,NULL,NULL,1,'2023-05-12 21:20:12','2023-05-12 21:20:12',NULL),(733,7566,40719,12,2,580,'App\\Models\\Receipt',580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',3000.00,NULL,NULL,1,'2023-05-12 21:20:12','2023-05-12 21:20:12',NULL),(734,7566,40719,12,2,581,'App\\Models\\Receipt',581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',2500.00,NULL,NULL,1,'2023-05-12 21:20:12','2023-05-12 21:20:12',NULL),(735,7566,40719,13,2,582,'App\\Models\\Receipt',582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',2500.00,NULL,NULL,1,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(736,7566,40719,13,2,583,'App\\Models\\Receipt',583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',3000.00,NULL,NULL,1,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(737,7566,40719,13,2,584,'App\\Models\\Receipt',584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',5000.00,NULL,NULL,1,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(738,7566,40719,13,2,585,'App\\Models\\Receipt',585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',2500.00,NULL,NULL,1,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(739,7566,40719,13,2,586,'App\\Models\\Receipt',586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',3000.00,NULL,NULL,1,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(740,7566,40719,13,2,587,'App\\Models\\Receipt',587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',2000.00,NULL,NULL,1,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(741,7566,40719,13,2,588,'App\\Models\\Receipt',588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',5000.00,NULL,NULL,1,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(742,7566,40719,13,2,589,'App\\Models\\Receipt',589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',3500.00,NULL,NULL,1,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(743,7566,40719,13,2,590,'App\\Models\\Receipt',590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',3000.00,NULL,NULL,1,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(744,7566,40719,13,2,591,'App\\Models\\Receipt',591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',2500.00,NULL,NULL,1,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL);
INSERT INTO `balance_libro` VALUES (745,7566,40719,13,2,592,'App\\Models\\Receipt',592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',2000.00,NULL,NULL,1,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(746,7566,40719,13,2,593,'App\\Models\\Receipt',593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',2500.00,NULL,NULL,1,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(747,7566,40719,13,2,594,'App\\Models\\Receipt',594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',2500.00,NULL,NULL,1,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(748,7566,40719,13,2,595,'App\\Models\\Receipt',595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',2500.00,NULL,NULL,1,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(749,7566,40719,14,2,596,'App\\Models\\Receipt',596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3000.00,NULL,NULL,1,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(750,7566,40719,14,2,597,'App\\Models\\Receipt',597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3600.00,NULL,NULL,1,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(751,7566,40719,14,2,598,'App\\Models\\Receipt',598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',6000.00,NULL,NULL,1,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(752,7566,40719,14,2,599,'App\\Models\\Receipt',599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3000.00,NULL,NULL,1,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(753,7566,40719,14,2,600,'App\\Models\\Receipt',600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',14000.00,NULL,NULL,1,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(754,7566,40719,14,2,601,'App\\Models\\Receipt',601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3600.00,NULL,NULL,1,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(755,7566,40719,14,2,602,'App\\Models\\Receipt',602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2500.00,NULL,NULL,1,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(756,7566,40719,14,2,603,'App\\Models\\Receipt',603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',4180.00,NULL,NULL,1,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(757,7566,40719,14,2,604,'App\\Models\\Receipt',604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3600.00,NULL,NULL,1,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(758,7566,40719,14,2,605,'App\\Models\\Receipt',605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3000.00,NULL,NULL,1,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(759,7566,40719,14,2,606,'App\\Models\\Receipt',606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2400.00,NULL,NULL,1,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(760,7566,40719,14,2,607,'App\\Models\\Receipt',607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3000.00,NULL,NULL,1,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(761,7566,40719,14,2,608,'App\\Models\\Receipt',608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3000.00,NULL,NULL,1,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(762,7566,40719,14,2,609,'App\\Models\\Receipt',609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3000.00,NULL,NULL,1,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(763,7566,40719,11,2,610,'App\\Models\\Receipt',610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',2500.00,NULL,NULL,1,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(764,7566,40719,11,2,611,'App\\Models\\Receipt',611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',3000.00,NULL,NULL,1,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(765,7566,40719,11,2,612,'App\\Models\\Receipt',612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',3000.00,NULL,NULL,1,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL);
INSERT INTO `balance_libro` VALUES (766,7566,40719,11,2,613,'App\\Models\\Receipt',613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',5000.00,NULL,NULL,1,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(767,7566,40719,11,2,614,'App\\Models\\Receipt',614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',2500.00,NULL,NULL,1,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(768,7566,40719,11,2,615,'App\\Models\\Receipt',615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',2500.00,NULL,NULL,1,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(769,7566,40719,11,2,616,'App\\Models\\Receipt',616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',3500.00,NULL,NULL,1,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(770,7566,40719,11,2,617,'App\\Models\\Receipt',617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',2000.00,NULL,NULL,1,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(771,7566,40719,11,2,618,'App\\Models\\Receipt',618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',7000.00,NULL,NULL,1,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(772,7566,40719,11,2,619,'App\\Models\\Receipt',619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',3500.00,NULL,NULL,1,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(773,7566,40719,11,2,620,'App\\Models\\Receipt',620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',3000.00,NULL,NULL,1,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(774,7566,40719,11,2,621,'App\\Models\\Receipt',621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',2500.00,NULL,NULL,1,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(775,7566,40719,11,2,622,'App\\Models\\Receipt',622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',2000.00,NULL,NULL,1,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(776,7566,40719,11,2,623,'App\\Models\\Receipt',623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',2500.00,NULL,NULL,1,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(777,7566,40719,11,2,624,'App\\Models\\Receipt',624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',2500.00,NULL,NULL,1,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(778,7566,40719,11,2,625,'App\\Models\\Receipt',625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',3500.00,NULL,NULL,1,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(779,7566,40719,11,2,626,'App\\Models\\Receipt',626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',2500.00,NULL,NULL,1,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(780,7566,40719,11,2,627,'App\\Models\\Receipt',627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',3500.00,NULL,NULL,1,'2023-05-12 21:22:46','2023-05-12 21:22:46',NULL),(781,7566,40720,1536,2,628,'App\\Models\\Receipt',628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',154839.15,NULL,NULL,1,'2023-05-16 17:50:42','2023-05-16 17:50:42',NULL),(782,7566,40720,1536,2,629,'App\\Models\\Receipt',629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',261554.73,NULL,NULL,1,'2023-05-16 17:50:42','2023-05-16 17:50:42',NULL),(783,7566,40720,1536,2,630,'App\\Models\\Receipt',630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',5126.52,NULL,NULL,1,'2023-05-16 17:50:42','2023-05-16 17:50:42',NULL),(784,7566,40720,1536,2,631,'App\\Models\\Receipt',631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',10386.30,NULL,NULL,1,'2023-05-16 17:50:42','2023-05-16 17:50:42',NULL),(785,7566,40720,1536,2,632,'App\\Models\\Receipt',632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',4568.06,NULL,NULL,1,'2023-05-16 17:50:42','2023-05-16 17:50:42',NULL),(786,7566,40720,1536,2,633,'App\\Models\\Receipt',633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',317066.11,NULL,NULL,1,'2023-05-16 17:50:42','2023-05-16 17:50:42',NULL);
INSERT INTO `balance_libro` VALUES (787,7566,40720,1536,3,634,'App\\Models\\Receipt',634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',16666.16,NULL,NULL,1,'2023-05-16 17:50:53','2023-05-16 20:03:41','2023-05-16 20:03:41'),(788,7566,40720,1536,3,635,'App\\Models\\Receipt',635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',498.90,NULL,NULL,1,'2023-05-16 17:50:53','2023-05-16 18:43:56','2023-05-16 18:43:56'),(789,7566,40720,1536,3,636,'App\\Models\\Receipt',636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',3400.00,NULL,NULL,1,'2023-05-16 17:50:53','2023-05-16 17:50:53',NULL),(790,7566,40720,1536,3,637,'App\\Models\\Receipt',637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',2140.00,NULL,NULL,1,'2023-05-16 17:50:53','2023-05-16 17:50:53',NULL),(791,7566,40720,1536,3,638,'App\\Models\\Receipt',638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',10500.00,NULL,NULL,1,'2023-05-16 17:50:53','2023-05-16 18:42:40','2023-05-16 18:42:40'),(792,7566,40720,1536,3,639,'App\\Models\\Receipt',639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',11250.00,NULL,NULL,1,'2023-05-16 17:50:53','2023-05-16 18:49:00','2023-05-16 18:49:00'),(793,7566,40720,1536,3,640,'App\\Models\\Receipt',640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',6486.97,NULL,NULL,1,'2023-05-16 17:50:53','2023-05-16 18:10:06','2023-05-16 18:10:06'),(794,7566,40720,1536,3,641,'App\\Models\\Receipt',641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',40000.00,NULL,NULL,1,'2023-05-16 17:50:54','2023-05-16 18:47:51','2023-05-16 18:47:51'),(795,7566,40720,1536,3,642,'App\\Models\\Receipt',642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',2500.00,NULL,NULL,1,'2023-05-16 17:50:54','2023-05-16 18:17:03','2023-05-16 18:17:03'),(796,7566,40720,1536,3,643,'App\\Models\\Receipt',643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',5433.88,NULL,NULL,1,'2023-05-16 17:50:54','2023-05-16 18:07:02','2023-05-16 18:07:02'),(797,7566,40720,1536,3,644,'App\\Models\\Receipt',644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',17999.00,NULL,NULL,1,'2023-05-16 17:50:54','2023-05-16 18:14:16','2023-05-16 18:14:16'),(798,7566,40720,1536,3,645,'App\\Models\\Receipt',645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',9408.22,NULL,NULL,1,'2023-05-16 17:50:54','2023-05-16 18:41:50','2023-05-16 18:41:50'),(799,7566,40720,1536,3,646,'App\\Models\\Receipt',646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',7500.00,NULL,NULL,1,'2023-05-16 17:50:54','2023-05-16 18:34:45','2023-05-16 18:34:45'),(800,7566,40720,1536,3,647,'App\\Models\\Receipt',647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',5000.00,NULL,NULL,1,'2023-05-16 17:50:54','2023-05-16 18:16:20','2023-05-16 18:16:20'),(801,7566,40720,1536,3,648,'App\\Models\\Receipt',648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',14000.00,NULL,NULL,1,'2023-05-16 17:50:54','2023-05-16 17:50:54',NULL),(802,7566,40720,1536,3,649,'App\\Models\\Receipt',649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',14000.00,NULL,NULL,1,'2023-05-16 17:50:54','2023-05-16 18:43:27','2023-05-16 18:43:27'),(803,7566,40720,1536,3,650,'App\\Models\\Receipt',650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',7964.88,NULL,NULL,1,'2023-05-16 18:06:35','2023-05-16 18:06:35',NULL),(804,7566,40720,1536,3,640,'App\\Models\\Receipt',640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',6486.97,NULL,NULL,1,'2023-05-16 18:10:06','2023-05-16 18:10:06',NULL),(805,7566,40720,1536,3,644,'App\\Models\\Receipt',644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',17999.00,NULL,NULL,1,'2023-05-16 18:14:16','2023-05-16 18:14:16',NULL),(806,7566,40720,1536,3,647,'App\\Models\\Receipt',647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',5000.00,NULL,NULL,1,'2023-05-16 18:16:20','2023-05-16 18:16:20',NULL);
INSERT INTO `balance_libro` VALUES (807,7566,40720,1536,3,642,'App\\Models\\Receipt',642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',2500.01,NULL,NULL,1,'2023-05-16 18:17:03','2023-05-16 18:17:03',NULL),(808,7566,40720,1536,3,651,'App\\Models\\Receipt',651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',980.00,NULL,NULL,1,'2023-05-16 18:22:16','2023-05-16 18:22:16',NULL),(809,7566,40720,1536,3,652,'App\\Models\\Receipt',652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',59290.00,NULL,NULL,1,'2023-05-16 18:29:45','2023-05-16 18:29:45',NULL),(810,7566,40720,1536,3,653,'App\\Models\\Receipt',653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',58685.00,NULL,NULL,1,'2023-05-16 18:30:30','2023-05-16 18:30:30',NULL),(811,7566,40720,1536,3,654,'App\\Models\\Receipt',654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',8066.17,NULL,NULL,1,'2023-05-16 18:33:09','2023-05-16 18:33:09',NULL),(812,7566,40720,1536,3,646,'App\\Models\\Receipt',646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',7500.00,NULL,NULL,1,'2023-05-16 18:34:45','2023-05-16 18:34:45',NULL),(813,7566,40720,1536,3,655,'App\\Models\\Receipt',655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',12585.00,NULL,NULL,1,'2023-05-16 18:37:56','2023-05-16 18:37:56',NULL),(814,7566,40720,1536,3,656,'App\\Models\\Receipt',656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',800.00,NULL,NULL,1,'2023-05-16 18:38:29','2023-05-16 18:38:29',NULL),(815,7566,40720,1536,3,657,'App\\Models\\Receipt',657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',10759.01,NULL,NULL,1,'2023-05-16 18:38:58','2023-05-16 18:38:58',NULL),(816,7566,40720,1536,3,645,'App\\Models\\Receipt',645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',9408.22,NULL,NULL,1,'2023-05-16 18:41:50','2023-05-16 18:41:50',NULL),(817,7566,40720,1536,3,638,'App\\Models\\Receipt',638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',10500.00,NULL,NULL,1,'2023-05-16 18:42:40','2023-05-16 18:42:40',NULL),(818,7566,40720,1536,3,649,'App\\Models\\Receipt',649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',14000.00,NULL,NULL,1,'2023-05-16 18:43:27','2023-05-16 18:43:27',NULL),(819,7566,40720,1536,3,635,'App\\Models\\Receipt',635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',498.90,NULL,NULL,1,'2023-05-16 18:43:56','2023-05-16 18:43:56',NULL),(820,7566,40720,1536,3,641,'App\\Models\\Receipt',641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',40000.00,NULL,NULL,1,'2023-05-16 18:47:51','2023-05-16 18:47:51',NULL),(821,7566,40720,1536,3,639,'App\\Models\\Receipt',639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',11250.00,NULL,NULL,1,'2023-05-16 18:49:00','2023-05-16 18:49:00',NULL),(822,7566,40720,1536,7,658,'App\\Models\\Receipt',658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',95.65,NULL,NULL,1,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL),(823,7566,40720,1536,7,659,'App\\Models\\Receipt',659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',561.87,NULL,NULL,1,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL),(824,7566,40720,1536,7,660,'App\\Models\\Receipt',660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',833.13,NULL,NULL,1,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL),(825,7566,40720,1536,7,661,'App\\Models\\Receipt',661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',7694.57,NULL,NULL,1,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL),(826,7566,40720,1536,7,662,'App\\Models\\Receipt',662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',4515.67,NULL,NULL,1,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL),(827,7566,40720,1536,7,663,'App\\Models\\Receipt',663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',711.78,NULL,NULL,1,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL);
INSERT INTO `balance_libro` VALUES (828,7566,40720,1536,7,664,'App\\Models\\Receipt',664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',84.02,NULL,NULL,1,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL),(829,7566,40720,1536,7,665,'App\\Models\\Receipt',665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',262.05,NULL,NULL,1,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL),(830,7566,40720,1536,7,666,'App\\Models\\Receipt',666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',108.98,NULL,NULL,1,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL),(831,7566,40720,1536,7,667,'App\\Models\\Receipt',667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',2901.11,NULL,NULL,1,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL),(832,7566,40720,1536,7,668,'App\\Models\\Receipt',668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',8318.57,NULL,NULL,1,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL),(833,7566,40720,1536,7,669,'App\\Models\\Receipt',669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',2463.72,NULL,NULL,1,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL),(834,7566,40720,1536,7,670,'App\\Models\\Receipt',670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',1540.85,NULL,NULL,1,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL),(835,7566,40720,1536,8,671,'App\\Models\\Receipt',671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',381.74,NULL,NULL,1,'2023-05-16 19:56:25','2023-05-16 19:56:25',NULL),(836,7566,40720,1537,2,672,'App\\Models\\Receipt',672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',183457.03,NULL,NULL,1,'2023-06-17 12:29:56','2023-06-17 12:29:56',NULL),(837,7566,40720,1537,2,673,'App\\Models\\Receipt',673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',211607.30,NULL,NULL,1,'2023-06-17 12:29:56','2023-06-17 12:29:56',NULL),(838,7566,40720,1537,2,674,'App\\Models\\Receipt',674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',9972.54,NULL,NULL,1,'2023-06-17 12:29:56','2023-06-17 12:29:56',NULL),(839,7566,40720,1537,2,675,'App\\Models\\Receipt',675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',5126.52,NULL,NULL,1,'2023-06-17 12:29:56','2023-06-17 12:29:56',NULL),(840,7566,40720,1537,2,676,'App\\Models\\Receipt',676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',14148.27,NULL,NULL,1,'2023-06-17 12:29:56','2023-06-17 12:29:56',NULL),(841,7566,40720,1537,2,677,'App\\Models\\Receipt',677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',358268.08,NULL,NULL,1,'2023-06-17 12:29:56','2023-06-17 12:29:56',NULL),(842,7566,40720,1537,3,678,'App\\Models\\Receipt',678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',16666.16,NULL,NULL,1,'2023-06-17 12:30:07','2023-06-17 13:29:51','2023-06-17 13:29:51'),(843,7566,40720,1537,3,679,'App\\Models\\Receipt',679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',3400.00,NULL,NULL,1,'2023-06-17 12:30:07','2023-06-17 13:30:23','2023-06-17 13:30:23'),(844,7566,40720,1537,3,680,'App\\Models\\Receipt',680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',5000.00,NULL,NULL,1,'2023-06-17 12:30:07','2023-06-19 11:45:29','2023-06-19 11:45:29'),(845,7566,40720,1537,3,681,'App\\Models\\Receipt',681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',4903.03,NULL,NULL,1,'2023-06-17 12:30:07','2023-06-17 13:33:13','2023-06-17 13:33:13'),(846,7566,40720,1537,3,682,'App\\Models\\Receipt',682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',11250.00,NULL,NULL,1,'2023-06-17 12:30:07','2023-06-17 13:33:49','2023-06-17 13:33:49'),(847,7566,40720,1537,3,683,'App\\Models\\Receipt',683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',7119.35,NULL,NULL,1,'2023-06-17 12:30:08','2023-06-19 11:08:47','2023-06-19 11:08:47');
INSERT INTO `balance_libro` VALUES (848,7566,40720,1537,3,684,'App\\Models\\Receipt',684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',6410.00,NULL,NULL,1,'2023-06-17 12:30:08','2023-06-17 13:37:36','2023-06-17 13:37:36'),(849,7566,40720,1537,3,685,'App\\Models\\Receipt',685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',2050.00,NULL,NULL,1,'2023-06-17 12:30:08','2023-06-17 12:30:08',NULL),(850,7566,40720,1537,3,686,'App\\Models\\Receipt',686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-07','2023-05-07',7000.00,NULL,NULL,1,'2023-06-17 12:30:08','2023-06-17 13:31:36','2023-06-17 13:31:36'),(851,7566,40720,1537,3,687,'App\\Models\\Receipt',687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',4400.00,NULL,NULL,1,'2023-06-17 12:30:08','2023-06-17 13:37:06','2023-06-17 13:37:06'),(852,7566,40720,1537,3,688,'App\\Models\\Receipt',688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',698.98,NULL,NULL,1,'2023-06-17 12:30:08','2023-06-17 12:30:08',NULL),(853,7566,40720,1537,3,689,'App\\Models\\Receipt',689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',12000.00,NULL,NULL,1,'2023-06-17 12:30:08','2023-06-17 13:40:34','2023-06-17 13:40:34'),(854,7566,40720,1537,3,690,'App\\Models\\Receipt',690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',4200.00,NULL,NULL,1,'2023-06-17 12:30:08','2023-06-17 13:35:14','2023-06-17 13:35:14'),(855,7566,40720,1537,3,691,'App\\Models\\Receipt',691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',8000.00,NULL,NULL,1,'2023-06-17 12:30:08','2023-06-17 13:42:01','2023-06-17 13:42:01'),(856,7566,40720,1537,3,692,'App\\Models\\Receipt',692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',1900.01,NULL,NULL,1,'2023-06-17 12:30:08','2023-06-17 13:32:07','2023-06-17 13:32:07'),(857,7566,40720,1537,3,693,'App\\Models\\Receipt',693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',3950.00,NULL,NULL,1,'2023-06-17 12:30:08','2023-06-17 12:30:08',NULL),(858,7566,40720,1537,3,694,'App\\Models\\Receipt',694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-14','2023-05-14',6766.53,NULL,NULL,1,'2023-06-17 12:30:08','2023-06-19 10:59:31','2023-06-19 10:59:31'),(859,7566,40720,1537,3,695,'App\\Models\\Receipt',695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',2650.00,NULL,NULL,1,'2023-06-17 12:30:08','2023-06-17 13:38:06','2023-06-17 13:38:06'),(860,7566,40720,1537,3,696,'App\\Models\\Receipt',696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',5100.15,NULL,NULL,1,'2023-06-17 12:30:08','2023-06-17 13:43:09','2023-06-17 13:43:09'),(861,7566,40720,1537,3,697,'App\\Models\\Receipt',697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',3077.54,NULL,NULL,1,'2023-06-17 12:30:08','2023-06-17 13:44:27','2023-06-17 13:44:27'),(862,7566,40720,1537,3,698,'App\\Models\\Receipt',698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',17500.00,NULL,NULL,1,'2023-06-17 12:30:08','2023-06-17 13:45:01','2023-06-17 13:45:01'),(863,7566,40720,1537,7,699,'App\\Models\\Receipt',699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',2359.12,NULL,NULL,1,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(864,7566,40720,1537,7,700,'App\\Models\\Receipt',700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',574.74,NULL,NULL,1,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(865,7566,40720,1537,7,701,'App\\Models\\Receipt',701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',928.78,NULL,NULL,1,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(866,7566,40720,1537,7,702,'App\\Models\\Receipt',702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',4412.55,NULL,NULL,1,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(867,7566,40720,1537,7,703,'App\\Models\\Receipt',703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',2597.03,NULL,NULL,1,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL);
INSERT INTO `balance_libro` VALUES (868,7566,40720,1537,7,704,'App\\Models\\Receipt',704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',711.78,NULL,NULL,1,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(869,7566,40720,1537,7,705,'App\\Models\\Receipt',705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',289.76,NULL,NULL,1,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(870,7566,40720,1537,7,706,'App\\Models\\Receipt',706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',108.98,NULL,NULL,1,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(871,7566,40720,1537,7,707,'App\\Models\\Receipt',707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',150.12,NULL,NULL,1,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(872,7566,40720,1537,7,708,'App\\Models\\Receipt',708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',11593.44,NULL,NULL,1,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(873,7566,40720,1537,7,709,'App\\Models\\Receipt',709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',4525.57,NULL,NULL,1,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(874,7566,40720,1537,7,710,'App\\Models\\Receipt',710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',2644.11,NULL,NULL,1,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(875,7566,40720,1537,7,711,'App\\Models\\Receipt',711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',1046.61,NULL,NULL,1,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(876,7566,40720,1537,7,712,'App\\Models\\Receipt',712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',99.64,NULL,NULL,1,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(877,7566,40720,1537,7,713,'App\\Models\\Receipt',713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',1441.23,NULL,NULL,1,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(878,7566,40720,1537,7,714,'App\\Models\\Receipt',714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',5462.68,NULL,NULL,1,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(879,7566,40720,1537,3,679,'App\\Models\\Receipt',679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',3400.00,NULL,NULL,1,'2023-06-17 13:30:23','2023-06-17 13:30:23',NULL),(880,7566,40720,1537,3,686,'App\\Models\\Receipt',686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-07','2023-05-07',7000.00,NULL,NULL,1,'2023-06-17 13:31:36','2023-06-17 13:31:36',NULL),(881,7566,40720,1537,3,692,'App\\Models\\Receipt',692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',1900.01,NULL,NULL,1,'2023-06-17 13:32:07','2023-06-19 11:43:36','2023-06-19 11:43:36'),(882,7566,40720,1537,3,681,'App\\Models\\Receipt',681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',4903.03,NULL,NULL,1,'2023-06-17 13:33:13','2023-06-17 13:33:13',NULL),(883,7566,40720,1537,3,682,'App\\Models\\Receipt',682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',11250.00,NULL,NULL,1,'2023-06-17 13:33:49','2023-06-17 13:33:49',NULL),(884,7566,40720,1537,3,690,'App\\Models\\Receipt',690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',42000.00,NULL,NULL,1,'2023-06-17 13:35:14','2023-06-17 13:36:33','2023-06-17 13:36:33'),(885,7566,40720,1537,3,690,'App\\Models\\Receipt',690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',4200.01,NULL,NULL,1,'2023-06-17 13:36:33','2023-06-17 13:38:47','2023-06-17 13:38:47'),(886,7566,40720,1537,3,687,'App\\Models\\Receipt',687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',4400.00,NULL,NULL,1,'2023-06-17 13:37:06','2023-06-17 13:39:04','2023-06-17 13:39:04'),(887,7566,40720,1537,3,684,'App\\Models\\Receipt',684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',6410.00,NULL,NULL,1,'2023-06-17 13:37:36','2023-06-17 13:39:22','2023-06-17 13:39:22'),(888,7566,40720,1537,3,695,'App\\Models\\Receipt',695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',2650.00,NULL,NULL,1,'2023-06-17 13:38:06','2023-06-17 13:38:06',NULL);
INSERT INTO `balance_libro` VALUES (889,7566,40720,1537,3,690,'App\\Models\\Receipt',690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',4200.01,NULL,NULL,1,'2023-06-17 13:38:47','2023-06-17 13:38:47',NULL),(890,7566,40720,1537,3,687,'App\\Models\\Receipt',687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',4400.00,NULL,NULL,1,'2023-06-17 13:39:04','2023-06-17 13:39:04',NULL),(891,7566,40720,1537,3,684,'App\\Models\\Receipt',684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',6410.00,NULL,NULL,1,'2023-06-17 13:39:22','2023-06-17 13:39:22',NULL),(892,7566,40720,1537,3,689,'App\\Models\\Receipt',689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',12000.00,NULL,NULL,1,'2023-06-17 13:40:34','2023-06-17 13:40:34',NULL),(893,7566,40720,1537,3,691,'App\\Models\\Receipt',691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',8000.00,NULL,NULL,1,'2023-06-17 13:42:01','2023-06-17 13:42:01',NULL),(894,7566,40720,1537,3,696,'App\\Models\\Receipt',696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',5100.15,NULL,NULL,1,'2023-06-17 13:43:09','2023-06-17 13:43:09',NULL),(895,7566,40720,1537,3,697,'App\\Models\\Receipt',697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-26','2023-05-26',3077.54,NULL,NULL,1,'2023-06-17 13:44:27','2023-06-17 13:44:27',NULL),(896,7566,40720,1537,3,698,'App\\Models\\Receipt',698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',17500.00,NULL,NULL,1,'2023-06-17 13:45:01','2023-06-17 13:45:01',NULL),(897,7566,40720,1537,3,715,'App\\Models\\Receipt',715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',4650.01,NULL,NULL,1,'2023-06-17 13:47:36','2023-06-17 13:47:36',NULL),(898,7566,40720,1537,3,716,'App\\Models\\Receipt',716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',13860.01,NULL,NULL,1,'2023-06-17 13:48:38','2023-06-17 13:48:38',NULL),(899,7566,40720,1537,3,717,'App\\Models\\Receipt',717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',12013.33,NULL,NULL,1,'2023-06-17 13:50:09','2023-06-17 13:50:09',NULL),(900,7566,40720,1537,3,718,'App\\Models\\Receipt',718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-28','2023-05-28',8685.15,NULL,NULL,1,'2023-06-17 13:51:16','2023-06-17 13:51:16',NULL),(901,7566,40720,1537,3,719,'App\\Models\\Receipt',719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',6699.90,NULL,NULL,1,'2023-06-17 13:52:33','2023-06-17 13:52:33',NULL),(902,7566,40720,1537,3,720,'App\\Models\\Receipt',720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',28314.00,NULL,NULL,1,'2023-06-17 13:53:23','2023-06-17 13:53:23',NULL),(903,7566,40720,1537,3,721,'App\\Models\\Receipt',721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',45738.00,NULL,NULL,1,'2023-06-17 13:53:59','2023-06-17 13:53:59',NULL),(904,7566,40720,1537,3,722,'App\\Models\\Receipt',722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',6450.00,NULL,NULL,1,'2023-06-17 13:55:03','2023-06-17 13:55:03',NULL),(905,7566,40720,1537,3,723,'App\\Models\\Receipt',723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',42350.00,NULL,NULL,1,'2023-06-17 13:55:54','2023-06-17 13:55:54',NULL),(906,7566,40720,1537,3,724,'App\\Models\\Receipt',724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',5433.88,NULL,NULL,1,'2023-06-19 11:10:22','2023-06-19 11:10:52','2023-06-19 11:10:52'),(907,7566,40720,1537,3,724,'App\\Models\\Receipt',724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',5433.88,NULL,NULL,1,'2023-06-19 11:10:52','2023-06-19 11:10:52',NULL),(908,7566,40720,1537,3,725,'App\\Models\\Receipt',725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',7119.35,NULL,NULL,1,'2023-06-19 11:14:47','2023-06-19 11:14:47',NULL),(909,7566,40720,1537,3,692,'App\\Models\\Receipt',692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',1900.01,NULL,NULL,1,'2023-06-19 11:43:36','2023-06-19 11:43:36',NULL);
INSERT INTO `balance_libro` VALUES (910,7566,40720,1537,3,680,'App\\Models\\Receipt',680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',5000.00,NULL,NULL,1,'2023-06-19 11:45:29','2023-06-19 11:46:37','2023-06-19 11:46:37'),(911,7566,40720,1537,3,680,'App\\Models\\Receipt',680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',5000.00,NULL,NULL,1,'2023-06-19 11:46:37','2023-06-19 11:46:37',NULL),(912,7566,40720,1538,2,726,'App\\Models\\Receipt',726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',198979.36,NULL,NULL,1,'2023-07-13 16:44:29','2023-07-13 16:44:29',NULL),(913,7566,40720,1538,2,727,'App\\Models\\Receipt',727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',275378.42,NULL,NULL,1,'2023-07-13 16:44:29','2023-07-13 16:44:29',NULL),(914,7566,40720,1538,2,728,'App\\Models\\Receipt',728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',2419.84,NULL,NULL,1,'2023-07-13 16:44:29','2023-07-13 16:44:29',NULL),(915,7566,40720,1538,2,729,'App\\Models\\Receipt',729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',11523.05,NULL,NULL,1,'2023-07-13 16:44:30','2023-07-13 16:44:30',NULL),(916,7566,40720,1538,2,730,'App\\Models\\Receipt',730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',5327.69,NULL,NULL,1,'2023-07-13 16:44:30','2023-07-13 16:44:30',NULL),(917,7566,40720,1538,2,731,'App\\Models\\Receipt',731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',2419.84,NULL,NULL,1,'2023-07-13 16:44:30','2023-07-13 16:44:30',NULL),(918,7566,40720,1538,2,732,'App\\Models\\Receipt',732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',394310.35,NULL,NULL,1,'2023-07-13 16:44:30','2023-07-13 16:44:30',NULL),(919,7566,40720,1538,3,733,'App\\Models\\Receipt',733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',16666.16,NULL,NULL,1,'2023-07-13 16:44:46','2023-07-13 16:46:05','2023-07-13 16:46:05'),(920,7566,40720,1538,3,734,'App\\Models\\Receipt',734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',3530.00,NULL,NULL,1,'2023-07-13 16:44:46','2023-07-13 16:51:55','2023-07-13 16:51:55'),(921,7566,40720,1538,3,735,'App\\Models\\Receipt',735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',11250.00,NULL,NULL,1,'2023-07-13 16:44:46','2023-07-13 16:52:53','2023-07-13 16:52:53'),(922,7566,40720,1538,3,736,'App\\Models\\Receipt',736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',7924.36,NULL,NULL,1,'2023-07-13 16:44:46','2023-07-13 16:54:42','2023-07-13 16:54:42'),(923,7566,40720,1538,3,737,'App\\Models\\Receipt',737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',1500.00,NULL,NULL,1,'2023-07-13 16:44:47','2023-07-13 16:44:47',NULL),(924,7566,40720,1538,3,738,'App\\Models\\Receipt',738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',2100.00,NULL,NULL,1,'2023-07-13 16:44:47','2023-07-13 16:57:21','2023-07-13 16:57:21'),(925,7566,40720,1538,3,739,'App\\Models\\Receipt',739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',1600.00,NULL,NULL,1,'2023-07-13 16:44:47','2023-07-13 16:44:47',NULL),(926,7566,40720,1538,3,740,'App\\Models\\Receipt',740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',12000.00,NULL,NULL,1,'2023-07-13 16:44:47','2023-07-15 10:17:44','2023-07-15 10:17:44'),(927,7566,40720,1538,3,741,'App\\Models\\Receipt',741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',12988.41,NULL,NULL,1,'2023-07-13 16:44:47','2023-07-13 17:10:13','2023-07-13 17:10:13'),(928,7566,40720,1538,3,742,'App\\Models\\Receipt',742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',4550.00,NULL,NULL,1,'2023-07-13 16:44:47','2023-07-13 16:44:47',NULL),(929,7566,40720,1538,3,743,'App\\Models\\Receipt',743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',30000.00,NULL,NULL,1,'2023-07-13 16:44:47','2023-07-13 17:21:57','2023-07-13 17:21:57');
INSERT INTO `balance_libro` VALUES (930,7566,40720,1538,3,744,'App\\Models\\Receipt',744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',3974.86,NULL,NULL,1,'2023-07-13 16:44:47','2023-07-13 17:12:52','2023-07-13 17:12:52'),(931,7566,40720,1538,3,745,'App\\Models\\Receipt',745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',30000.00,NULL,NULL,1,'2023-07-13 16:44:47','2023-11-18 12:34:14','2023-11-18 12:34:14'),(932,7566,40720,1538,3,746,'App\\Models\\Receipt',746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',2488.20,NULL,NULL,1,'2023-07-13 16:44:47','2023-07-13 17:13:28','2023-07-13 17:13:28'),(933,7566,40720,1538,3,747,'App\\Models\\Receipt',747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',7711.77,NULL,NULL,1,'2023-07-13 16:44:47','2023-07-15 10:51:32','2023-07-15 10:51:32'),(934,7566,40720,1538,3,748,'App\\Models\\Receipt',748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',3400.00,NULL,NULL,1,'2023-07-13 16:44:47','2023-07-13 16:44:47',NULL),(935,7566,40720,1538,3,749,'App\\Models\\Receipt',749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',2300.00,NULL,NULL,1,'2023-07-13 16:44:48','2023-07-13 16:44:48',NULL),(936,7566,40720,1538,3,750,'App\\Models\\Receipt',750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',9800.00,NULL,NULL,1,'2023-07-13 16:44:48','2023-07-13 16:44:48',NULL),(937,7566,40720,1538,3,751,'App\\Models\\Receipt',751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',5900.00,NULL,NULL,1,'2023-07-13 16:44:48','2023-07-13 17:33:53','2023-07-13 17:33:53'),(938,7566,40720,1538,3,752,'App\\Models\\Receipt',752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-18','2023-06-18',999.00,NULL,NULL,1,'2023-07-13 16:44:48','2023-07-13 16:44:48',NULL),(939,7566,40720,1538,3,753,'App\\Models\\Receipt',753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',2300.00,NULL,NULL,1,'2023-07-13 16:44:48','2023-07-13 16:44:48',NULL),(940,7566,40720,1538,3,754,'App\\Models\\Receipt',754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',5300.01,NULL,NULL,1,'2023-07-13 16:44:48','2023-07-13 16:44:48',NULL),(941,7566,40720,1538,3,755,'App\\Models\\Receipt',755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',53000.00,NULL,NULL,1,'2023-07-13 16:44:48','2023-07-13 17:37:12','2023-07-13 17:37:12'),(942,7566,40720,1538,3,756,'App\\Models\\Receipt',756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',4500.00,NULL,NULL,1,'2023-07-13 16:44:48','2023-07-13 17:33:09','2023-07-13 17:33:09'),(943,7566,40720,1538,3,757,'App\\Models\\Receipt',757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',23775.28,NULL,NULL,1,'2023-07-13 16:44:48','2023-07-13 17:39:02','2023-07-13 17:39:02'),(944,7566,40720,1538,3,758,'App\\Models\\Receipt',758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',2300.00,NULL,NULL,1,'2023-07-13 16:44:48','2023-07-13 16:44:48',NULL),(945,7566,40720,1538,3,759,'App\\Models\\Receipt',759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',12000.00,NULL,NULL,1,'2023-07-13 16:44:48','2023-07-13 16:44:48',NULL),(946,7566,40720,1538,3,760,'App\\Models\\Receipt',760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',12000.00,NULL,NULL,1,'2023-07-13 16:44:48','2023-07-13 16:44:48',NULL),(947,7566,40720,1538,3,761,'App\\Models\\Receipt',761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',3180.55,NULL,NULL,1,'2023-07-13 16:44:49','2023-07-15 10:04:44','2023-07-15 10:04:44'),(948,7566,40720,1538,3,762,'App\\Models\\Receipt',762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',4600.00,NULL,NULL,1,'2023-07-13 16:44:49','2023-07-15 10:05:42','2023-07-15 10:05:42'),(949,7566,40720,1538,3,734,'App\\Models\\Receipt',734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',3530.01,NULL,NULL,1,'2023-07-13 16:51:55','2023-07-13 16:51:55',NULL);
INSERT INTO `balance_libro` VALUES (950,7566,40720,1538,3,735,'App\\Models\\Receipt',735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',11250.00,NULL,NULL,1,'2023-07-13 16:52:53','2023-07-13 16:52:53',NULL),(951,7566,40720,1538,3,736,'App\\Models\\Receipt',736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',7924.36,NULL,NULL,1,'2023-07-13 16:54:42','2023-07-13 16:54:42',NULL),(952,7566,40720,1538,3,738,'App\\Models\\Receipt',738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',2100.00,NULL,NULL,1,'2023-07-13 16:57:21','2023-11-18 12:33:49','2023-11-18 12:33:49'),(953,7566,40720,1538,3,741,'App\\Models\\Receipt',741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',12988.41,NULL,NULL,1,'2023-07-13 17:10:13','2023-07-13 17:10:13',NULL),(954,7566,40720,1538,3,744,'App\\Models\\Receipt',744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',3974.86,NULL,NULL,1,'2023-07-13 17:12:52','2023-07-13 17:12:52',NULL),(955,7566,40720,1538,3,746,'App\\Models\\Receipt',746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',2488.20,NULL,NULL,1,'2023-07-13 17:13:28','2023-07-13 17:13:50','2023-07-13 17:13:50'),(956,7566,40720,1538,3,746,'App\\Models\\Receipt',746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',2488.20,NULL,NULL,1,'2023-07-13 17:13:50','2023-07-13 17:13:50',NULL),(957,7566,40720,1538,3,763,'App\\Models\\Receipt',763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',34303.50,NULL,NULL,1,'2023-07-13 17:16:31','2023-07-13 17:16:31',NULL),(958,7566,40720,1538,3,764,'App\\Models\\Receipt',764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',34848.00,NULL,NULL,1,'2023-07-13 17:17:27','2023-07-13 17:17:27',NULL),(959,7566,40720,1538,3,765,'App\\Models\\Receipt',765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',46669.70,NULL,NULL,1,'2023-07-13 17:18:17','2023-07-13 17:18:17',NULL),(960,7566,40720,1538,3,743,'App\\Models\\Receipt',743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',30000.00,NULL,NULL,1,'2023-07-13 17:21:57','2023-07-13 17:21:57',NULL),(961,7566,40720,1538,3,766,'App\\Models\\Receipt',766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-14','2023-05-14',6766.53,NULL,NULL,1,'2023-07-13 17:26:47','2023-07-13 17:26:47',NULL),(962,7566,40720,1538,3,756,'App\\Models\\Receipt',756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',4500.00,NULL,NULL,1,'2023-07-13 17:33:09','2023-07-13 17:33:09',NULL),(963,7566,40720,1538,3,751,'App\\Models\\Receipt',751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',5900.00,NULL,NULL,1,'2023-07-13 17:33:53','2023-07-13 17:33:53',NULL),(964,7566,40720,1538,3,755,'App\\Models\\Receipt',755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',53000.00,NULL,NULL,1,'2023-07-13 17:37:12','2023-07-15 10:17:55','2023-07-15 10:17:55'),(965,7566,40720,1538,3,757,'App\\Models\\Receipt',757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',23775.28,NULL,NULL,1,'2023-07-13 17:39:02','2023-07-15 10:29:08','2023-07-15 10:29:08'),(966,7566,40720,1538,3,761,'App\\Models\\Receipt',761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',3180.55,NULL,NULL,1,'2023-07-15 10:04:44','2023-07-15 10:04:44',NULL),(967,7566,40720,1538,3,762,'App\\Models\\Receipt',762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',4600.00,NULL,NULL,1,'2023-07-15 10:05:42','2023-07-15 10:05:42',NULL),(968,7566,40720,1538,3,767,'App\\Models\\Receipt',767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',2880.01,NULL,NULL,1,'2023-07-15 10:06:54','2023-07-15 10:06:54',NULL),(969,7566,40720,1538,3,768,'App\\Models\\Receipt',768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',5606.67,NULL,NULL,1,'2023-07-15 10:08:33','2023-07-15 10:08:33',NULL),(970,7566,40720,1538,3,740,'App\\Models\\Receipt',740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',12000.00,NULL,NULL,1,'2023-07-15 10:17:44','2023-07-15 10:19:09','2023-07-15 10:19:09');
INSERT INTO `balance_libro` VALUES (971,7566,40720,1538,3,755,'App\\Models\\Receipt',755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',53000.00,NULL,NULL,1,'2023-07-15 10:17:55','2023-07-15 10:18:50','2023-07-15 10:18:50'),(972,7566,40720,1538,3,755,'App\\Models\\Receipt',755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',53000.00,NULL,NULL,1,'2023-07-15 10:18:50','2023-07-15 10:18:50',NULL),(973,7566,40720,1538,3,740,'App\\Models\\Receipt',740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',12000.00,NULL,NULL,1,'2023-07-15 10:19:09','2023-07-15 10:19:09',NULL),(974,7566,40720,1538,3,757,'App\\Models\\Receipt',757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',23775.28,NULL,NULL,1,'2023-07-15 10:29:08','2023-07-15 10:57:53','2023-07-15 10:57:53'),(975,7566,40720,1538,7,769,'App\\Models\\Receipt',769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',6624.22,NULL,NULL,1,'2023-07-15 10:30:35','2023-07-15 10:30:35',NULL),(976,7566,40720,1538,7,770,'App\\Models\\Receipt',770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',1023.48,NULL,NULL,1,'2023-07-15 10:30:35','2023-07-15 10:30:35',NULL),(977,7566,40720,1538,7,771,'App\\Models\\Receipt',771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',144.55,NULL,NULL,1,'2023-07-15 10:30:35','2023-07-15 10:30:35',NULL),(978,7566,40720,1538,7,772,'App\\Models\\Receipt',772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',4460.07,NULL,NULL,1,'2023-07-15 10:30:35','2023-07-15 10:30:35',NULL),(979,7566,40720,1538,7,773,'App\\Models\\Receipt',773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',4061.65,NULL,NULL,1,'2023-07-15 10:30:35','2023-07-15 10:30:35',NULL),(980,7566,40720,1538,7,774,'App\\Models\\Receipt',774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',60.49,NULL,NULL,1,'2023-07-15 10:30:35','2023-07-15 10:30:35',NULL),(981,7566,40720,1538,7,775,'App\\Models\\Receipt',775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',739.71,NULL,NULL,1,'2023-07-15 10:30:35','2023-07-15 10:30:35',NULL),(982,7566,40720,1538,7,776,'App\\Models\\Receipt',776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',4497.59,NULL,NULL,1,'2023-07-15 10:30:35','2023-07-15 10:30:35',NULL),(983,7566,40720,1538,7,777,'App\\Models\\Receipt',777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',477.17,NULL,NULL,1,'2023-07-15 10:30:36','2023-07-15 10:30:36',NULL),(984,7566,40720,1538,7,778,'App\\Models\\Receipt',778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',12823.02,NULL,NULL,1,'2023-07-15 10:30:36','2023-07-15 10:30:36',NULL),(985,7566,40720,1538,7,779,'App\\Models\\Receipt',779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',127.50,NULL,NULL,1,'2023-07-15 10:30:36','2023-07-15 10:30:36',NULL),(986,7566,40720,1538,7,780,'App\\Models\\Receipt',780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',3218.95,NULL,NULL,1,'2023-07-15 10:30:36','2023-07-15 10:30:36',NULL),(987,7566,40720,1538,7,781,'App\\Models\\Receipt',781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',2133.04,NULL,NULL,1,'2023-07-15 10:30:36','2023-07-15 10:30:36',NULL),(988,7566,40720,1538,3,757,'App\\Models\\Receipt',757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',23775.28,NULL,NULL,1,'2023-07-15 10:57:53','2023-07-15 10:57:53',NULL),(989,7566,40720,1539,2,782,'App\\Models\\Receipt',782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',173054.68,NULL,NULL,1,'2023-08-17 17:19:57','2023-08-17 17:19:57',NULL),(990,7566,40720,1539,2,783,'App\\Models\\Receipt',783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',285586.87,NULL,NULL,1,'2023-08-17 17:19:57','2023-08-17 17:19:57',NULL),(991,7566,40720,1539,2,784,'App\\Models\\Receipt',784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',7487.92,NULL,NULL,1,'2023-08-17 17:19:57','2023-08-17 17:19:57',NULL);
INSERT INTO `balance_libro` VALUES (992,7566,40720,1539,2,785,'App\\Models\\Receipt',785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',11858.76,NULL,NULL,1,'2023-08-17 17:19:57','2023-08-17 17:19:57',NULL),(993,7566,40720,1539,2,786,'App\\Models\\Receipt',786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',404929.17,NULL,NULL,1,'2023-08-17 17:19:57','2023-08-17 17:19:57',NULL),(994,7566,40720,1539,3,787,'App\\Models\\Receipt',787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',16666.16,NULL,NULL,1,'2023-08-17 17:20:07','2023-08-17 17:29:14','2023-08-17 17:29:14'),(995,7566,40720,1539,3,788,'App\\Models\\Receipt',788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',3530.00,NULL,NULL,1,'2023-08-17 17:20:07','2023-08-17 17:29:43','2023-08-17 17:29:43'),(996,7566,40720,1539,3,789,'App\\Models\\Receipt',789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',11250.00,NULL,NULL,1,'2023-08-17 17:20:07','2023-08-17 17:31:13','2023-08-17 17:31:13'),(997,7566,40720,1539,3,790,'App\\Models\\Receipt',790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',8500.67,NULL,NULL,1,'2023-08-17 17:20:07','2023-08-17 17:48:40','2023-08-17 17:48:40'),(998,7566,40720,1539,3,791,'App\\Models\\Receipt',791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',6000.00,NULL,NULL,1,'2023-08-17 17:20:07','2023-08-17 17:52:05','2023-08-17 17:52:05'),(999,7566,40720,1539,3,792,'App\\Models\\Receipt',792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',2150.00,NULL,NULL,1,'2023-08-17 17:20:07','2023-08-17 17:52:46','2023-08-17 17:52:46'),(1000,7566,40720,1539,3,793,'App\\Models\\Receipt',793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',182.60,NULL,NULL,1,'2023-08-17 17:20:07','2023-08-18 18:57:47','2023-08-18 18:57:47'),(1001,7566,40720,1539,3,794,'App\\Models\\Receipt',794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',88999.00,NULL,NULL,1,'2023-08-17 17:20:08','2023-08-17 17:58:14','2023-08-17 17:58:14'),(1002,7566,40720,1539,3,795,'App\\Models\\Receipt',795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',12000.00,NULL,NULL,1,'2023-08-17 17:20:08','2023-08-17 18:00:26','2023-08-17 18:00:26'),(1003,7566,40720,1539,3,796,'App\\Models\\Receipt',796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',2500.00,NULL,NULL,1,'2023-08-17 17:20:08','2023-08-17 17:20:08',NULL),(1004,7566,40720,1539,3,797,'App\\Models\\Receipt',797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',8540.00,NULL,NULL,1,'2023-08-17 17:20:08','2023-08-17 18:02:29','2023-08-17 18:02:29'),(1005,7566,40720,1539,3,798,'App\\Models\\Receipt',798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',65660.00,NULL,NULL,1,'2023-08-17 17:20:08','2023-08-18 19:00:08','2023-08-18 19:00:08'),(1006,7566,40720,1539,3,799,'App\\Models\\Receipt',799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',2300.00,NULL,NULL,1,'2023-08-17 17:20:08','2023-08-17 17:20:08',NULL),(1007,7566,40720,1539,3,800,'App\\Models\\Receipt',800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',2500.00,NULL,NULL,1,'2023-08-17 17:20:08','2023-08-17 17:20:08',NULL),(1008,7566,40720,1539,3,801,'App\\Models\\Receipt',801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',26213.82,NULL,NULL,1,'2023-08-17 17:20:08','2023-08-17 18:11:07','2023-08-17 18:11:07'),(1009,7566,40720,1539,3,802,'App\\Models\\Receipt',802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',999.00,NULL,NULL,1,'2023-08-17 17:20:08','2023-08-17 17:20:08',NULL),(1010,7566,40720,1539,3,803,'App\\Models\\Receipt',803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',4800.00,NULL,NULL,1,'2023-08-17 17:20:08','2023-08-17 18:15:37','2023-08-17 18:15:37'),(1011,7566,40720,1539,3,804,'App\\Models\\Receipt',804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',6042.24,NULL,NULL,1,'2023-08-17 17:20:08','2023-08-18 18:09:09','2023-08-18 18:09:09');
INSERT INTO `balance_libro` VALUES (1012,7566,40720,1539,3,805,'App\\Models\\Receipt',805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',4800.00,NULL,NULL,1,'2023-08-17 17:20:08','2023-08-17 17:20:08',NULL),(1013,7566,40720,1539,3,806,'App\\Models\\Receipt',806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-23','2023-07-23',10500.00,NULL,NULL,1,'2023-08-17 17:20:08','2023-08-17 17:20:08',NULL),(1014,7566,40720,1539,3,807,'App\\Models\\Receipt',807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-25','2023-07-25',10000.00,NULL,NULL,1,'2023-08-17 17:20:09','2023-08-17 17:20:09',NULL),(1015,7566,40720,1539,3,808,'App\\Models\\Receipt',808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',61277.57,NULL,NULL,1,'2023-08-17 17:20:09','2023-08-18 18:17:38','2023-08-18 18:17:38'),(1016,7566,40720,1539,3,809,'App\\Models\\Receipt',809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',12000.00,NULL,NULL,1,'2023-08-17 17:20:09','2023-08-17 17:20:09',NULL),(1017,7566,40720,1539,3,810,'App\\Models\\Receipt',810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',122800.00,NULL,NULL,1,'2023-08-17 17:20:09','2023-08-18 18:33:24','2023-08-18 18:33:24'),(1018,7566,40720,1539,3,811,'App\\Models\\Receipt',811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-30','2023-07-30',8000.00,NULL,NULL,1,'2023-08-17 17:20:09','2023-08-17 17:20:09',NULL),(1019,7566,40720,1539,7,812,'App\\Models\\Receipt',812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',5350.09,NULL,NULL,1,'2023-08-17 17:20:51','2023-08-17 17:20:51',NULL),(1020,7566,40720,1539,7,813,'App\\Models\\Receipt',813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',138.85,NULL,NULL,1,'2023-08-17 17:20:51','2023-08-17 17:20:51',NULL),(1021,7566,40720,1539,7,814,'App\\Models\\Receipt',814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-25','2023-07-25',1225.91,NULL,NULL,1,'2023-08-17 17:20:51','2023-08-17 17:20:51',NULL),(1022,7566,40720,1539,7,815,'App\\Models\\Receipt',815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',108.11,NULL,NULL,1,'2023-08-17 17:20:51','2023-08-17 17:20:51',NULL),(1023,7566,40720,1539,7,816,'App\\Models\\Receipt',816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',98.27,NULL,NULL,1,'2023-08-17 17:20:51','2023-08-17 17:20:51',NULL),(1024,7566,40720,1539,7,817,'App\\Models\\Receipt',817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',6093.30,NULL,NULL,1,'2023-08-17 17:20:51','2023-08-17 17:20:51',NULL),(1025,7566,40720,1539,7,818,'App\\Models\\Receipt',818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',3983.78,NULL,NULL,1,'2023-08-17 17:20:51','2023-08-17 17:20:51',NULL),(1026,7566,40720,1539,7,819,'App\\Models\\Receipt',819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',1565.32,NULL,NULL,1,'2023-08-17 17:20:52','2023-08-17 17:20:52',NULL),(1027,7566,40720,1539,7,820,'App\\Models\\Receipt',820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',108.12,NULL,NULL,1,'2023-08-17 17:20:52','2023-08-17 17:20:52',NULL),(1028,7566,40720,1539,7,821,'App\\Models\\Receipt',821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',4547.80,NULL,NULL,1,'2023-08-17 17:20:52','2023-08-17 17:20:52',NULL),(1029,7566,40720,1539,7,822,'App\\Models\\Receipt',822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',1145.60,NULL,NULL,1,'2023-08-17 17:20:52','2023-08-17 17:20:52',NULL),(1030,7566,40720,1539,7,823,'App\\Models\\Receipt',823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',12777.78,NULL,NULL,1,'2023-08-17 17:20:52','2023-08-17 17:20:52',NULL),(1031,7566,40720,1539,7,824,'App\\Models\\Receipt',824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',272.06,NULL,NULL,1,'2023-08-17 17:20:52','2023-08-17 17:20:52',NULL),(1032,7566,40720,1539,7,825,'App\\Models\\Receipt',825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',1039.64,NULL,NULL,1,'2023-08-17 17:20:52','2023-08-17 17:20:52',NULL);
INSERT INTO `balance_libro` VALUES (1033,7566,40720,1539,7,826,'App\\Models\\Receipt',826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',3281.50,NULL,NULL,1,'2023-08-17 17:20:52','2023-08-17 17:20:52',NULL),(1034,7566,40720,1539,7,827,'App\\Models\\Receipt',827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',414.72,NULL,NULL,1,'2023-08-17 17:20:52','2023-08-17 17:20:52',NULL),(1035,7566,40720,1539,7,828,'App\\Models\\Receipt',828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',1391.10,NULL,NULL,1,'2023-08-17 17:20:52','2023-08-17 17:20:52',NULL),(1036,7566,40720,1539,3,788,'App\\Models\\Receipt',788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',3530.01,NULL,NULL,1,'2023-08-17 17:29:43','2023-08-17 17:29:43',NULL),(1037,7566,40720,1539,3,789,'App\\Models\\Receipt',789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',11250.00,NULL,NULL,1,'2023-08-17 17:31:13','2023-08-17 17:31:13',NULL),(1038,7566,40720,1539,3,790,'App\\Models\\Receipt',790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',8500.67,NULL,NULL,1,'2023-08-17 17:48:40','2023-08-17 17:48:40',NULL),(1039,7566,40720,1539,3,791,'App\\Models\\Receipt',791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',6000.00,NULL,NULL,1,'2023-08-17 17:52:05','2023-08-17 17:52:05',NULL),(1040,7566,40720,1539,3,792,'App\\Models\\Receipt',792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',2150.00,NULL,NULL,1,'2023-08-17 17:52:46','2023-08-17 17:52:46',NULL),(1041,7566,40720,1539,3,794,'App\\Models\\Receipt',794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',88999.00,NULL,NULL,1,'2023-08-17 17:58:14','2023-11-18 12:34:40','2023-11-18 12:34:40'),(1042,7566,40720,1539,3,795,'App\\Models\\Receipt',795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',12000.00,NULL,NULL,1,'2023-08-17 18:00:26','2023-08-17 18:00:26',NULL),(1043,7566,40720,1539,3,797,'App\\Models\\Receipt',797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',8540.00,NULL,NULL,1,'2023-08-17 18:02:29','2023-08-17 18:02:29',NULL),(1044,7566,40720,1539,3,801,'App\\Models\\Receipt',801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',26213.82,NULL,NULL,1,'2023-08-17 18:11:07','2023-08-17 18:11:07',NULL),(1045,7566,40720,1539,3,803,'App\\Models\\Receipt',803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',4800.00,NULL,NULL,1,'2023-08-17 18:15:37','2023-11-18 12:35:02','2023-11-18 12:35:02'),(1046,7566,40720,1539,3,829,'App\\Models\\Receipt',829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',7711.77,NULL,NULL,1,'2023-08-18 18:11:02','2023-08-18 18:11:45','2023-08-18 18:11:45'),(1047,7566,40720,1539,3,829,'App\\Models\\Receipt',829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',7711.77,NULL,NULL,1,'2023-08-18 18:11:45','2023-08-18 18:11:45',NULL),(1048,7566,40720,1539,3,808,'App\\Models\\Receipt',808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',10570.36,NULL,NULL,1,'2023-08-18 18:17:38','2023-08-18 18:20:01','2023-08-18 18:20:01'),(1049,7566,40720,1539,3,808,'App\\Models\\Receipt',808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',61277.56,NULL,NULL,1,'2023-08-18 18:20:01','2023-08-18 18:20:01',NULL),(1050,7566,40720,1539,3,810,'App\\Models\\Receipt',810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',122800.00,NULL,NULL,1,'2023-08-18 18:33:24','2023-08-18 18:33:24',NULL),(1051,7566,40720,1539,3,830,'App\\Models\\Receipt',830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',10715.23,NULL,NULL,1,'2023-08-18 18:35:17','2023-08-18 18:35:17',NULL),(1052,7566,40720,1539,3,831,'App\\Models\\Receipt',831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',8670.90,NULL,NULL,1,'2023-08-18 18:36:14','2023-08-18 18:36:48','2023-08-18 18:36:48');
INSERT INTO `balance_libro` VALUES (1053,7566,40720,1539,3,831,'App\\Models\\Receipt',831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-29','2023-07-29',8670.90,NULL,NULL,1,'2023-08-18 18:36:48','2023-08-18 18:36:48',NULL),(1054,7566,40720,1539,3,832,'App\\Models\\Receipt',832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',26900.00,NULL,NULL,1,'2023-08-18 18:39:32','2023-08-18 18:39:32',NULL),(1055,7566,40720,1539,3,833,'App\\Models\\Receipt',833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',37933.50,NULL,NULL,1,'2023-08-18 18:40:24','2023-08-18 18:40:24',NULL),(1056,7566,40720,1539,3,834,'App\\Models\\Receipt',834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',51667.00,NULL,NULL,1,'2023-08-18 18:40:58','2023-08-18 18:40:58',NULL),(1057,7566,40720,1539,3,835,'App\\Models\\Receipt',835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',26015.00,NULL,NULL,1,'2023-08-18 18:42:39','2023-08-18 18:42:39',NULL),(1058,7566,40720,1539,3,836,'App\\Models\\Receipt',836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-29','2023-07-29',8544.00,NULL,NULL,1,'2023-08-18 18:43:18','2023-08-18 18:43:18',NULL),(1059,7566,40720,1539,3,837,'App\\Models\\Receipt',837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',6970.00,NULL,NULL,1,'2023-08-18 18:44:18','2023-08-18 18:44:18',NULL),(1060,7566,40720,1540,2,838,'App\\Models\\Receipt',838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',207978.02,NULL,NULL,1,'2023-09-15 15:48:03','2023-09-15 15:48:03',NULL),(1061,7566,40720,1540,2,839,'App\\Models\\Receipt',839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',306117.83,NULL,NULL,1,'2023-09-15 15:48:03','2023-09-15 15:48:03',NULL),(1062,7566,40720,1540,2,840,'App\\Models\\Receipt',840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-09','2023-08-09',10329.23,NULL,NULL,1,'2023-09-15 15:48:03','2023-09-15 15:48:03',NULL),(1063,7566,40720,1540,2,841,'App\\Models\\Receipt',841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-09','2023-08-09',4186.06,NULL,NULL,1,'2023-09-15 15:48:03','2023-09-15 15:48:03',NULL),(1064,7566,40720,1540,2,842,'App\\Models\\Receipt',842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',413162.55,NULL,NULL,1,'2023-09-15 15:48:03','2023-09-15 15:48:03',NULL),(1065,7566,40720,1540,3,843,'App\\Models\\Receipt',843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',16666.16,NULL,NULL,1,'2023-09-15 15:48:19','2023-09-15 15:49:11','2023-09-15 15:49:11'),(1066,7566,40720,1540,3,844,'App\\Models\\Receipt',844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',3800.00,NULL,NULL,1,'2023-09-15 15:48:19','2023-09-15 15:48:19',NULL),(1067,7566,40720,1540,3,845,'App\\Models\\Receipt',845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',11250.00,NULL,NULL,1,'2023-09-15 15:48:19','2023-09-15 15:48:19',NULL),(1068,7566,40720,1540,3,846,'App\\Models\\Receipt',846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',5000.00,NULL,NULL,1,'2023-09-15 15:48:19','2023-09-15 15:48:19',NULL),(1069,7566,40720,1540,3,847,'App\\Models\\Receipt',847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',2988.70,NULL,NULL,1,'2023-09-15 15:48:19','2023-09-15 15:57:51','2023-09-15 15:57:51'),(1070,7566,40720,1540,3,848,'App\\Models\\Receipt',848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',9385.99,NULL,NULL,1,'2023-09-15 15:48:19','2023-09-15 15:59:32','2023-09-15 15:59:32'),(1071,7566,40720,1540,3,849,'App\\Models\\Receipt',849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',33571.66,NULL,NULL,1,'2023-09-15 15:48:19','2023-09-15 16:01:37','2023-09-15 16:01:37'),(1072,7566,40720,1540,3,850,'App\\Models\\Receipt',850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-09','2023-08-09',24100.01,NULL,NULL,1,'2023-09-15 15:48:19','2023-09-15 15:48:19',NULL);
INSERT INTO `balance_libro` VALUES (1073,7566,40720,1540,3,851,'App\\Models\\Receipt',851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-09','2023-08-09',13211.15,NULL,NULL,1,'2023-09-15 15:48:19','2023-09-15 17:20:38','2023-09-15 17:20:38'),(1074,7566,40720,1540,3,852,'App\\Models\\Receipt',852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',14700.00,NULL,NULL,1,'2023-09-15 15:48:19','2023-09-15 16:04:55','2023-09-15 16:04:55'),(1075,7566,40720,1540,3,853,'App\\Models\\Receipt',853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',2800.00,NULL,NULL,1,'2023-09-15 15:48:19','2023-09-15 15:48:19',NULL),(1076,7566,40720,1540,3,854,'App\\Models\\Receipt',854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-12','2023-08-12',2800.00,NULL,NULL,1,'2023-09-15 15:48:19','2023-09-15 15:48:19',NULL),(1077,7566,40720,1540,3,855,'App\\Models\\Receipt',855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',2580.00,NULL,NULL,1,'2023-09-15 15:48:20','2023-09-15 16:44:55','2023-09-15 16:44:55'),(1078,7566,40720,1540,3,856,'App\\Models\\Receipt',856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',61672.32,NULL,NULL,1,'2023-09-15 15:48:20','2023-09-15 16:52:25','2023-09-15 16:52:25'),(1079,7566,40720,1540,3,857,'App\\Models\\Receipt',857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',2700.00,NULL,NULL,1,'2023-09-15 15:48:20','2023-09-15 15:48:20',NULL),(1080,7566,40720,1540,3,858,'App\\Models\\Receipt',858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',2700.01,NULL,NULL,1,'2023-09-15 15:48:20','2023-09-15 15:48:20',NULL),(1081,7566,40720,1540,3,859,'App\\Models\\Receipt',859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',3200.00,NULL,NULL,1,'2023-09-15 15:48:20','2023-09-15 15:48:20',NULL),(1082,7566,40720,1540,3,860,'App\\Models\\Receipt',860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-19','2023-08-19',4770.11,NULL,NULL,1,'2023-09-15 15:48:20','2023-09-15 16:09:59','2023-09-15 16:09:59'),(1083,7566,40720,1540,3,861,'App\\Models\\Receipt',861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-19','2023-08-19',3200.00,NULL,NULL,1,'2023-09-15 15:48:20','2023-09-15 15:48:20',NULL),(1084,7566,40720,1540,3,862,'App\\Models\\Receipt',862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-19','2023-08-19',1912.00,NULL,NULL,1,'2023-09-15 15:48:20','2023-09-15 16:10:54','2023-09-15 16:10:54'),(1085,7566,40720,1540,3,863,'App\\Models\\Receipt',863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',3200.00,NULL,NULL,1,'2023-09-15 15:48:20','2023-09-15 15:48:20',NULL),(1086,7566,40720,1540,3,864,'App\\Models\\Receipt',864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',9599.41,NULL,NULL,1,'2023-09-15 15:48:20','2023-09-15 16:11:49','2023-09-15 16:11:49'),(1087,7566,40720,1540,3,865,'App\\Models\\Receipt',865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',33988.90,NULL,NULL,1,'2023-09-15 15:48:20','2023-09-15 16:14:24','2023-09-15 16:14:24'),(1088,7566,40720,1540,3,866,'App\\Models\\Receipt',866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',3150.00,NULL,NULL,1,'2023-09-15 15:48:20','2023-09-15 15:48:20',NULL),(1089,7566,40720,1540,3,867,'App\\Models\\Receipt',867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',3600.00,NULL,NULL,1,'2023-09-15 15:48:20','2023-09-15 15:48:20',NULL),(1090,7566,40720,1540,3,868,'App\\Models\\Receipt',868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',3150.00,NULL,NULL,1,'2023-09-15 15:48:20','2023-09-15 15:48:20',NULL),(1091,7566,40720,1540,3,869,'App\\Models\\Receipt',869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-25','2023-08-25',13000.00,NULL,NULL,1,'2023-09-15 15:48:20','2023-09-15 16:17:02','2023-09-15 16:17:02'),(1092,7566,40720,1540,3,870,'App\\Models\\Receipt',870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-25','2023-08-25',3150.00,NULL,NULL,1,'2023-09-15 15:48:20','2023-09-15 15:48:20',NULL);
INSERT INTO `balance_libro` VALUES (1093,7566,40720,1540,3,871,'App\\Models\\Receipt',871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-27','2023-08-27',13300.00,NULL,NULL,1,'2023-09-15 15:48:20','2023-09-15 16:18:46','2023-09-15 16:18:46'),(1094,7566,40720,1540,3,872,'App\\Models\\Receipt',872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',3150.00,NULL,NULL,1,'2023-09-15 15:48:21','2023-09-15 15:48:21',NULL),(1095,7566,40720,1540,3,873,'App\\Models\\Receipt',873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',3150.00,NULL,NULL,1,'2023-09-15 15:48:21','2023-09-15 15:48:21',NULL),(1096,7566,40720,1540,3,874,'App\\Models\\Receipt',874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',3350.00,NULL,NULL,1,'2023-09-15 15:48:21','2023-09-15 15:48:21',NULL),(1097,7566,40720,1540,3,847,'App\\Models\\Receipt',847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',2988.70,NULL,NULL,1,'2023-09-15 15:57:51','2023-09-15 15:57:51',NULL),(1098,7566,40720,1540,3,848,'App\\Models\\Receipt',848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',9385.99,NULL,NULL,1,'2023-09-15 15:59:32','2023-09-15 15:59:32',NULL),(1099,7566,40720,1540,3,849,'App\\Models\\Receipt',849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',33571.67,NULL,NULL,1,'2023-09-15 16:01:37','2023-11-18 12:32:47','2023-11-18 12:32:47'),(1100,7566,40720,1540,3,852,'App\\Models\\Receipt',852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',14700.00,NULL,NULL,1,'2023-09-15 16:04:55','2023-09-15 16:04:55',NULL),(1101,7566,40720,1540,3,860,'App\\Models\\Receipt',860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-19','2023-08-19',4770.11,NULL,NULL,1,'2023-09-15 16:09:59','2023-09-15 16:09:59',NULL),(1102,7566,40720,1540,3,862,'App\\Models\\Receipt',862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-19','2023-08-19',1912.01,NULL,NULL,1,'2023-09-15 16:10:54','2023-09-15 16:10:54',NULL),(1103,7566,40720,1540,3,864,'App\\Models\\Receipt',864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',9599.41,NULL,NULL,1,'2023-09-15 16:11:49','2023-09-15 16:11:49',NULL),(1104,7566,40720,1540,3,865,'App\\Models\\Receipt',865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',33988.90,NULL,NULL,1,'2023-09-15 16:14:24','2023-11-18 12:36:24','2023-11-18 12:36:24'),(1105,7566,40720,1540,3,869,'App\\Models\\Receipt',869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-25','2023-08-25',13000.00,NULL,NULL,1,'2023-09-15 16:17:02','2023-11-18 12:37:14','2023-11-18 12:37:14'),(1106,7566,40720,1540,3,871,'App\\Models\\Receipt',871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-27','2023-08-27',13300.01,NULL,NULL,1,'2023-09-15 16:18:46','2023-09-15 16:18:46',NULL),(1107,7566,40720,1540,3,875,'App\\Models\\Receipt',875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',57838.00,NULL,NULL,1,'2023-09-15 16:21:58','2023-09-15 16:21:58',NULL),(1108,7566,40720,1540,3,876,'App\\Models\\Receipt',876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',29040.00,NULL,NULL,1,'2023-09-15 16:22:27','2023-09-15 16:22:27',NULL),(1109,7566,40720,1540,3,877,'App\\Models\\Receipt',877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',11630.00,NULL,NULL,1,'2023-09-15 16:23:30','2023-09-15 16:23:30',NULL),(1110,7566,40720,1540,3,878,'App\\Models\\Receipt',878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',4580.00,NULL,NULL,1,'2023-09-15 16:24:00','2023-09-15 16:24:00',NULL),(1111,7566,40720,1540,3,879,'App\\Models\\Receipt',879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-21','2023-08-21',11001.40,NULL,NULL,1,'2023-09-15 16:24:56','2023-09-15 16:24:56',NULL),(1112,7566,40720,1540,3,880,'App\\Models\\Receipt',880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',31460.00,NULL,NULL,1,'2023-09-15 16:25:37','2023-09-15 16:25:37',NULL),(1113,7566,40720,1540,7,881,'App\\Models\\Receipt',881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-31','2023-08-31',3181.35,NULL,NULL,1,'2023-09-15 16:30:57','2023-09-15 16:30:57',NULL);
INSERT INTO `balance_libro` VALUES (1114,7566,40720,1540,7,882,'App\\Models\\Receipt',882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-29','2023-08-29',280.89,NULL,NULL,1,'2023-09-15 16:30:57','2023-09-15 16:30:57',NULL),(1115,7566,40720,1540,7,883,'App\\Models\\Receipt',883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-24','2023-08-24',218.55,NULL,NULL,1,'2023-09-15 16:30:57','2023-09-15 16:30:57',NULL),(1116,7566,40720,1540,7,884,'App\\Models\\Receipt',884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',505.83,NULL,NULL,1,'2023-09-15 16:30:57','2023-09-15 16:30:57',NULL),(1117,7566,40720,1540,7,885,'App\\Models\\Receipt',885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-22','2023-08-22',7178.14,NULL,NULL,1,'2023-09-15 16:30:57','2023-09-15 16:30:57',NULL),(1118,7566,40720,1540,7,886,'App\\Models\\Receipt',886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',91.92,NULL,NULL,1,'2023-09-15 16:30:57','2023-09-15 16:30:57',NULL),(1119,7566,40720,1540,7,887,'App\\Models\\Receipt',887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',4161.27,NULL,NULL,1,'2023-09-15 16:30:57','2023-09-15 16:30:57',NULL),(1120,7566,40720,1540,7,888,'App\\Models\\Receipt',888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',102.86,NULL,NULL,1,'2023-09-15 16:30:57','2023-09-15 16:30:57',NULL),(1121,7566,40720,1540,7,889,'App\\Models\\Receipt',889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',4717.61,NULL,NULL,1,'2023-09-15 16:30:57','2023-09-15 16:30:57',NULL),(1122,7566,40720,1540,7,890,'App\\Models\\Receipt',890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',581.20,NULL,NULL,1,'2023-09-15 16:30:57','2023-09-15 16:30:57',NULL),(1123,7566,40720,1540,7,891,'App\\Models\\Receipt',891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',962.99,NULL,NULL,1,'2023-09-15 16:30:57','2023-09-15 16:30:57',NULL),(1124,7566,40720,1540,7,892,'App\\Models\\Receipt',892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-09','2023-08-09',15063.23,NULL,NULL,1,'2023-09-15 16:30:57','2023-09-15 16:30:57',NULL),(1125,7566,40720,1540,7,893,'App\\Models\\Receipt',893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',951.28,NULL,NULL,1,'2023-09-15 16:30:57','2023-09-15 16:30:57',NULL),(1126,7566,40720,1540,7,894,'App\\Models\\Receipt',894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',127.50,NULL,NULL,1,'2023-09-15 16:30:57','2023-09-15 16:30:57',NULL),(1127,7566,40720,1540,7,895,'App\\Models\\Receipt',895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',3614.45,NULL,NULL,1,'2023-09-15 16:30:57','2023-09-15 16:30:57',NULL),(1128,7566,40720,1540,7,896,'App\\Models\\Receipt',896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',1607.06,NULL,NULL,1,'2023-09-15 16:30:57','2023-09-15 16:30:57',NULL),(1129,7566,40720,1540,7,897,'App\\Models\\Receipt',897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',996.67,NULL,NULL,1,'2023-09-15 16:30:57','2023-09-15 16:30:57',NULL),(1130,7566,40720,1540,7,898,'App\\Models\\Receipt',898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',867.63,NULL,NULL,1,'2023-09-15 16:30:57','2023-09-15 16:30:57',NULL),(1131,7566,40720,1540,3,856,'App\\Models\\Receipt',856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',61672.32,NULL,NULL,1,'2023-09-15 16:52:25','2023-09-15 16:55:52','2023-09-15 16:55:52'),(1132,7566,40720,1540,3,856,'App\\Models\\Receipt',856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',61672.32,NULL,NULL,1,'2023-09-15 16:55:52','2023-11-18 12:36:01','2023-11-18 12:36:01'),(1133,7566,40720,1540,3,851,'App\\Models\\Receipt',851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-09','2023-08-09',12750.25,NULL,NULL,1,'2023-09-15 17:20:38','2023-09-15 17:20:38',NULL),(1134,7566,40720,1541,2,899,'App\\Models\\Receipt',899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',321436.68,NULL,NULL,1,'2023-10-19 17:28:54','2023-10-19 17:28:54',NULL);
INSERT INTO `balance_libro` VALUES (1135,7566,40720,1541,2,900,'App\\Models\\Receipt',900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',236481.49,NULL,NULL,1,'2023-10-19 17:28:54','2023-10-19 17:28:54',NULL),(1136,7566,40720,1541,2,901,'App\\Models\\Receipt',901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',3632.11,NULL,NULL,1,'2023-10-19 17:28:54','2023-10-19 17:28:54',NULL),(1137,7566,40720,1541,2,902,'App\\Models\\Receipt',902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-17','2023-09-17',434460.52,NULL,NULL,1,'2023-10-19 17:28:54','2023-10-19 17:28:54',NULL),(1138,7566,40720,1541,2,903,'App\\Models\\Receipt',903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',4186.07,NULL,NULL,1,'2023-10-19 17:28:54','2023-10-19 17:28:54',NULL),(1139,7566,40720,1541,2,904,'App\\Models\\Receipt',904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',11427.64,NULL,NULL,1,'2023-10-19 17:28:54','2023-10-19 17:28:54',NULL),(1140,7566,40720,1541,2,905,'App\\Models\\Receipt',905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',4186.06,NULL,NULL,1,'2023-10-19 17:28:54','2023-10-19 17:28:54',NULL),(1141,7566,40720,1541,2,906,'App\\Models\\Receipt',906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',16210.04,NULL,NULL,1,'2023-10-19 17:28:54','2023-10-19 17:28:54',NULL),(1142,7566,40720,1541,3,907,'App\\Models\\Receipt',907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',4200.00,NULL,NULL,1,'2023-10-19 17:29:26','2023-10-19 17:29:26',NULL),(1143,7566,40720,1541,3,908,'App\\Models\\Receipt',908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',11814.10,NULL,NULL,1,'2023-10-19 17:29:26','2023-10-19 18:01:23','2023-10-19 18:01:23'),(1144,7566,40720,1541,3,909,'App\\Models\\Receipt',909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',10700.00,NULL,NULL,1,'2023-10-19 17:29:26','2023-10-19 17:29:26',NULL),(1145,7566,40720,1541,3,910,'App\\Models\\Receipt',910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',6400.00,NULL,NULL,1,'2023-10-19 17:29:26','2023-10-19 17:29:26',NULL),(1146,7566,40720,1541,3,911,'App\\Models\\Receipt',911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',16666.16,NULL,NULL,1,'2023-10-19 17:29:26','2023-10-19 17:30:27','2023-10-19 17:30:27'),(1147,7566,40720,1541,3,912,'App\\Models\\Receipt',912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',11250.00,NULL,NULL,1,'2023-10-19 17:29:26','2023-10-19 17:29:26',NULL),(1148,7566,40720,1541,3,913,'App\\Models\\Receipt',913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-02','2023-09-02',13520.00,NULL,NULL,1,'2023-10-19 17:29:26','2023-10-19 18:40:43','2023-10-19 18:40:43'),(1149,7566,40720,1541,3,914,'App\\Models\\Receipt',914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-03','2023-09-03',10613.24,NULL,NULL,1,'2023-10-19 17:29:26','2023-10-19 18:03:59','2023-10-19 18:03:59'),(1150,7566,40720,1541,3,915,'App\\Models\\Receipt',915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',3200.00,NULL,NULL,1,'2023-10-19 17:29:26','2023-10-19 17:29:26',NULL),(1151,7566,40720,1541,3,916,'App\\Models\\Receipt',916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',9000.00,NULL,NULL,1,'2023-10-19 17:29:26','2023-10-19 17:29:26',NULL),(1152,7566,40720,1541,3,917,'App\\Models\\Receipt',917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',5528.00,NULL,NULL,1,'2023-10-19 17:29:26','2023-10-19 18:41:52','2023-10-19 18:41:52'),(1153,7566,40720,1541,3,918,'App\\Models\\Receipt',918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-06','2023-09-06',3150.00,NULL,NULL,1,'2023-10-19 17:29:26','2023-10-19 17:29:26',NULL),(1154,7566,40720,1541,3,919,'App\\Models\\Receipt',919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-06','2023-09-06',5529.00,NULL,NULL,1,'2023-10-19 17:29:27','2023-10-19 18:41:36','2023-10-19 18:41:36');
INSERT INTO `balance_libro` VALUES (1155,7566,40720,1541,3,920,'App\\Models\\Receipt',920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',3150.00,NULL,NULL,1,'2023-10-19 17:29:27','2023-10-19 17:29:27',NULL),(1156,7566,40720,1541,3,921,'App\\Models\\Receipt',921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-09','2023-09-09',7149.47,NULL,NULL,1,'2023-10-19 17:29:27','2023-10-19 17:40:05','2023-10-19 17:40:05'),(1157,7566,40720,1541,3,922,'App\\Models\\Receipt',922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-10','2023-09-10',2362.52,NULL,NULL,1,'2023-10-19 17:29:27','2023-10-19 17:44:25','2023-10-19 17:44:25'),(1158,7566,40720,1541,3,923,'App\\Models\\Receipt',923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-11','2023-09-11',9100.00,NULL,NULL,1,'2023-10-19 17:29:27','2023-10-19 17:29:27',NULL),(1159,7566,40720,1541,3,924,'App\\Models\\Receipt',924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',3200.00,NULL,NULL,1,'2023-10-19 17:29:27','2023-10-19 17:29:27',NULL),(1160,7566,40720,1541,3,925,'App\\Models\\Receipt',925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-14','2023-09-14',3150.00,NULL,NULL,1,'2023-10-19 17:29:27','2023-10-19 17:29:27',NULL),(1161,7566,40720,1541,3,926,'App\\Models\\Receipt',926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-15','2023-09-15',13160.00,NULL,NULL,1,'2023-10-19 17:29:27','2023-10-19 17:43:44','2023-10-19 17:43:44'),(1162,7566,40720,1541,3,927,'App\\Models\\Receipt',927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-15','2023-09-15',22000.00,NULL,NULL,1,'2023-10-19 17:29:27','2023-10-19 17:29:27',NULL),(1163,7566,40720,1541,3,928,'App\\Models\\Receipt',928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-16','2023-09-16',6445.00,NULL,NULL,1,'2023-10-19 17:29:27','2023-10-19 18:40:26','2023-10-19 18:40:26'),(1164,7566,40720,1541,3,929,'App\\Models\\Receipt',929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-19','2023-09-19',999.00,NULL,NULL,1,'2023-10-19 17:29:27','2023-10-19 17:29:27',NULL),(1165,7566,40720,1541,3,930,'App\\Models\\Receipt',930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-20','2023-09-20',7323.59,NULL,NULL,1,'2023-10-19 17:29:27','2023-10-19 17:42:27','2023-10-19 17:42:27'),(1166,7566,40720,1541,3,931,'App\\Models\\Receipt',931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-20','2023-09-20',10889.00,NULL,NULL,1,'2023-10-19 17:29:27','2023-10-19 18:41:16','2023-10-19 18:41:16'),(1167,7566,40720,1541,3,932,'App\\Models\\Receipt',932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-21','2023-09-21',11304.38,NULL,NULL,1,'2023-10-19 17:29:27','2023-10-19 19:21:33','2023-10-19 19:21:33'),(1168,7566,40720,1541,3,933,'App\\Models\\Receipt',933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-23','2023-09-23',6440.00,NULL,NULL,1,'2023-10-19 17:29:28','2023-10-19 18:40:12','2023-10-19 18:40:12'),(1169,7566,40720,1541,3,934,'App\\Models\\Receipt',934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-24','2023-09-24',21900.01,NULL,NULL,1,'2023-10-19 17:29:28','2023-10-19 18:42:24','2023-10-19 18:42:24'),(1170,7566,40720,1541,3,935,'App\\Models\\Receipt',935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-25','2023-09-25',9000.00,NULL,NULL,1,'2023-10-19 17:29:28','2023-10-19 17:29:28',NULL),(1171,7566,40720,1541,3,936,'App\\Models\\Receipt',936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',3150.00,NULL,NULL,1,'2023-10-19 17:29:28','2023-10-19 17:29:28',NULL),(1172,7566,40720,1541,3,937,'App\\Models\\Receipt',937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',23122.39,NULL,NULL,1,'2023-10-19 17:29:28','2023-10-19 18:01:54','2023-10-19 18:01:54'),(1173,7566,40720,1541,3,938,'App\\Models\\Receipt',938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-09','2023-09-09',11899.27,NULL,NULL,1,'2023-10-19 17:33:23','2023-10-19 17:33:23',NULL),(1174,7566,40720,1541,3,939,'App\\Models\\Receipt',939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',11595.40,NULL,NULL,1,'2023-10-19 17:34:14','2023-10-19 17:34:14',NULL);
INSERT INTO `balance_libro` VALUES (1175,7566,40720,1541,3,940,'App\\Models\\Receipt',940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-21','2023-09-21',49005.00,NULL,NULL,1,'2023-10-19 17:36:54','2023-10-19 17:36:54',NULL),(1176,7566,40720,1541,3,941,'App\\Models\\Receipt',941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-15','2023-09-15',68365.00,NULL,NULL,1,'2023-10-19 17:37:29','2023-10-19 17:37:29',NULL),(1177,7566,40720,1541,3,942,'App\\Models\\Receipt',942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-11','2023-09-11',49458.75,NULL,NULL,1,'2023-10-19 17:38:07','2023-10-19 17:38:07',NULL),(1178,7566,40720,1541,3,943,'App\\Models\\Receipt',943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',64130.00,NULL,NULL,1,'2023-10-19 17:38:33','2023-10-19 17:38:33',NULL),(1179,7566,40720,1541,3,921,'App\\Models\\Receipt',921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-09','2023-09-09',6976.50,NULL,NULL,1,'2023-10-19 17:40:05','2023-10-19 17:41:33','2023-10-19 17:41:33'),(1180,7566,40720,1541,3,921,'App\\Models\\Receipt',921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-09','2023-09-09',7149.47,NULL,NULL,1,'2023-10-19 17:41:33','2023-10-19 17:41:33',NULL),(1181,7566,40720,1541,3,930,'App\\Models\\Receipt',930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-20','2023-09-20',7323.60,NULL,NULL,1,'2023-10-19 17:42:27','2023-10-19 17:42:27',NULL),(1182,7566,40720,1541,3,926,'App\\Models\\Receipt',926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-15','2023-09-15',13160.00,NULL,NULL,1,'2023-10-19 17:43:44','2023-10-19 17:43:44',NULL),(1183,7566,40720,1541,3,922,'App\\Models\\Receipt',922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-10','2023-09-10',2362.52,NULL,NULL,1,'2023-10-19 17:44:25','2023-10-19 17:44:25',NULL),(1184,7566,40720,1541,3,908,'App\\Models\\Receipt',908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',11814.10,NULL,NULL,1,'2023-10-19 18:01:23','2023-10-19 18:39:08','2023-10-19 18:39:08'),(1185,7566,40720,1541,3,937,'App\\Models\\Receipt',937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',23122.39,NULL,NULL,1,'2023-10-19 18:01:54','2023-10-19 18:38:49','2023-10-19 18:38:49'),(1186,7566,40720,1541,3,914,'App\\Models\\Receipt',914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-03','2023-09-03',10613.24,NULL,NULL,1,'2023-10-19 18:03:59','2023-10-19 18:03:59',NULL),(1187,7566,40720,1541,3,937,'App\\Models\\Receipt',937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',23122.39,NULL,NULL,1,'2023-10-19 18:38:49','2023-10-19 18:38:49',NULL),(1188,7566,40720,1541,3,908,'App\\Models\\Receipt',908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-01','2023-09-01',11814.10,NULL,NULL,1,'2023-10-19 18:39:08','2023-10-19 18:39:08',NULL),(1189,7566,40720,1541,3,933,'App\\Models\\Receipt',933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-23','2023-09-23',6440.00,NULL,NULL,1,'2023-10-19 18:40:12','2023-10-19 18:40:12',NULL),(1190,7566,40720,1541,3,928,'App\\Models\\Receipt',928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-16','2023-09-16',6445.00,NULL,NULL,1,'2023-10-19 18:40:26','2023-10-19 18:40:26',NULL),(1191,7566,40720,1541,3,913,'App\\Models\\Receipt',913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-02','2023-09-02',13520.00,NULL,NULL,1,'2023-10-19 18:40:43','2023-10-19 18:40:43',NULL),(1192,7566,40720,1541,3,931,'App\\Models\\Receipt',931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-20','2023-09-20',10889.00,NULL,NULL,1,'2023-10-19 18:41:16','2023-10-19 18:41:16',NULL),(1193,7566,40720,1541,3,919,'App\\Models\\Receipt',919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-06','2023-09-06',5529.01,NULL,NULL,1,'2023-10-19 18:41:36','2023-10-19 18:41:36',NULL),(1194,7566,40720,1541,3,917,'App\\Models\\Receipt',917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',5528.01,NULL,NULL,1,'2023-10-19 18:41:52','2023-10-19 18:41:52',NULL),(1195,7566,40720,1541,3,934,'App\\Models\\Receipt',934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-24','2023-09-24',21900.02,NULL,NULL,1,'2023-10-19 18:42:24','2023-10-19 18:42:24',NULL);
INSERT INTO `balance_libro` VALUES (1196,7566,40720,1541,7,944,'App\\Models\\Receipt',944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-30','2023-09-30',372.73,NULL,NULL,1,'2023-10-19 18:45:32','2023-10-19 18:45:32',NULL),(1197,7566,40720,1541,7,945,'App\\Models\\Receipt',945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-29','2023-09-29',842.36,NULL,NULL,1,'2023-10-19 18:45:32','2023-10-19 18:45:32',NULL),(1198,7566,40720,1541,7,946,'App\\Models\\Receipt',946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-27','2023-09-27',245.98,NULL,NULL,1,'2023-10-19 18:45:32','2023-10-19 18:45:32',NULL),(1199,7566,40720,1541,7,947,'App\\Models\\Receipt',947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-26','2023-09-26',613.98,NULL,NULL,1,'2023-10-19 18:45:32','2023-10-19 18:45:32',NULL),(1200,7566,40720,1541,7,948,'App\\Models\\Receipt',948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-22','2023-09-22',2352.34,NULL,NULL,1,'2023-10-19 18:45:32','2023-10-19 18:45:32',NULL),(1201,7566,40720,1541,7,949,'App\\Models\\Receipt',949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-21','2023-09-21',367.24,NULL,NULL,1,'2023-10-19 18:45:32','2023-10-19 18:45:32',NULL),(1202,7566,40720,1541,7,950,'App\\Models\\Receipt',950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-20','2023-09-20',6872.82,NULL,NULL,1,'2023-10-19 18:45:32','2023-10-19 18:45:32',NULL),(1203,7566,40720,1541,7,951,'App\\Models\\Receipt',951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-14','2023-09-14',16176.87,NULL,NULL,1,'2023-10-19 18:45:32','2023-10-19 18:45:32',NULL),(1204,7566,40720,1541,7,952,'App\\Models\\Receipt',952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-13','2023-09-13',138.84,NULL,NULL,1,'2023-10-19 18:45:32','2023-10-19 18:45:32',NULL),(1205,7566,40720,1541,7,953,'App\\Models\\Receipt',953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-12','2023-09-12',136.91,NULL,NULL,1,'2023-10-19 18:45:32','2023-10-19 18:45:32',NULL),(1206,7566,40720,1541,7,954,'App\\Models\\Receipt',954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-11','2023-09-11',5611.70,NULL,NULL,1,'2023-10-19 18:45:32','2023-10-19 18:45:32',NULL),(1207,7566,40720,1541,7,955,'App\\Models\\Receipt',955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-08','2023-09-08',838.79,NULL,NULL,1,'2023-10-19 18:45:32','2023-10-19 18:45:32',NULL),(1208,7566,40720,1541,7,956,'App\\Models\\Receipt',956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-06','2023-09-06',642.02,NULL,NULL,1,'2023-10-19 18:45:32','2023-10-19 18:45:32',NULL),(1209,7566,40720,1541,7,957,'App\\Models\\Receipt',957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',4203.17,NULL,NULL,1,'2023-10-19 18:45:32','2023-10-19 18:45:32',NULL),(1210,7566,40720,1541,7,958,'App\\Models\\Receipt',958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-05','2023-09-05',1085.50,NULL,NULL,1,'2023-10-19 18:45:32','2023-10-19 18:45:32',NULL),(1211,7566,40720,1541,7,959,'App\\Models\\Receipt',959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-04','2023-09-04',2032.26,NULL,NULL,1,'2023-10-19 18:45:32','2023-10-19 18:45:32',NULL),(1212,7566,40720,1542,2,960,'App\\Models\\Receipt',960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-01','2023-10-01',236442.40,NULL,NULL,1,'2023-11-18 09:45:01','2023-11-18 09:45:01',NULL),(1213,7566,40720,1542,2,961,'App\\Models\\Receipt',961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',298524.39,NULL,NULL,1,'2023-11-18 09:45:01','2023-11-18 09:45:01',NULL),(1214,7566,40720,1542,2,962,'App\\Models\\Receipt',962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-09','2023-10-09',11970.95,NULL,NULL,1,'2023-11-18 09:45:01','2023-11-18 09:45:01',NULL),(1215,7566,40720,1542,2,963,'App\\Models\\Receipt',963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-24','2023-10-24',7363.33,NULL,NULL,1,'2023-11-18 09:45:01','2023-11-18 09:45:01',NULL),(1216,7566,40720,1542,2,964,'App\\Models\\Receipt',964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-09','2023-10-09',4504.12,NULL,NULL,1,'2023-11-18 09:45:01','2023-11-18 09:45:01',NULL);
INSERT INTO `balance_libro` VALUES (1217,7566,40720,1542,2,965,'App\\Models\\Receipt',965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-09','2023-10-09',3632.11,NULL,NULL,1,'2023-11-18 09:45:01','2023-11-18 09:45:01',NULL),(1218,7566,40720,1542,2,966,'App\\Models\\Receipt',966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',531736.09,NULL,NULL,1,'2023-11-18 09:45:01','2023-11-18 09:45:01',NULL),(1219,7566,40720,1542,3,967,'App\\Models\\Receipt',967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-01','2023-10-01',4200.00,NULL,NULL,1,'2023-11-18 09:45:16','2023-11-18 10:02:07','2023-11-18 10:02:07'),(1220,7566,40720,1542,3,968,'App\\Models\\Receipt',968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-01','2023-10-01',6140.00,NULL,NULL,1,'2023-11-18 09:45:16','2023-11-18 10:02:52','2023-11-18 10:02:52'),(1221,7566,40720,1542,3,969,'App\\Models\\Receipt',969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-01','2023-10-01',16666.16,NULL,NULL,1,'2023-11-18 09:45:16','2023-11-18 10:01:12','2023-11-18 10:01:12'),(1222,7566,40720,1542,3,970,'App\\Models\\Receipt',970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',12000.00,NULL,NULL,1,'2023-11-18 09:45:16','2023-11-18 09:45:16',NULL),(1223,7566,40720,1542,3,971,'App\\Models\\Receipt',971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',4800.00,NULL,NULL,1,'2023-11-18 09:45:16','2023-11-18 09:45:16',NULL),(1224,7566,40720,1542,3,972,'App\\Models\\Receipt',972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',3150.00,NULL,NULL,1,'2023-11-18 09:45:16','2023-11-18 09:45:16',NULL),(1225,7566,40720,1542,3,973,'App\\Models\\Receipt',973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',11639.08,NULL,NULL,1,'2023-11-18 09:45:16','2023-11-18 10:06:07','2023-11-18 10:06:07'),(1226,7566,40720,1542,3,974,'App\\Models\\Receipt',974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-04','2023-10-04',11250.00,NULL,NULL,1,'2023-11-18 09:45:16','2023-11-18 09:45:16',NULL),(1227,7566,40720,1542,3,975,'App\\Models\\Receipt',975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-09','2023-10-09',3100.00,NULL,NULL,1,'2023-11-18 09:45:17','2023-11-18 09:45:17',NULL),(1228,7566,40720,1542,3,976,'App\\Models\\Receipt',976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',6780.00,NULL,NULL,1,'2023-11-18 09:45:17','2023-11-18 09:45:17',NULL),(1229,7566,40720,1542,3,977,'App\\Models\\Receipt',977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',3000.00,NULL,NULL,1,'2023-11-18 09:45:17','2023-11-18 09:45:17',NULL),(1230,7566,40720,1542,3,978,'App\\Models\\Receipt',978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',3780.00,NULL,NULL,1,'2023-11-18 09:45:17','2023-11-18 09:45:17',NULL),(1231,7566,40720,1542,3,979,'App\\Models\\Receipt',979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',6780.00,NULL,NULL,1,'2023-11-18 09:45:17','2023-11-18 09:45:17',NULL),(1232,7566,40720,1542,3,980,'App\\Models\\Receipt',980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-11','2023-10-11',3150.00,NULL,NULL,1,'2023-11-18 09:45:17','2023-11-18 09:45:17',NULL),(1233,7566,40720,1542,3,981,'App\\Models\\Receipt',981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-12','2023-10-12',4400.00,NULL,NULL,1,'2023-11-18 09:45:17','2023-11-18 09:45:17',NULL),(1234,7566,40720,1542,3,982,'App\\Models\\Receipt',982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-12','2023-10-12',11650.00,NULL,NULL,1,'2023-11-18 09:45:17','2023-11-18 09:45:17',NULL),(1235,7566,40720,1542,3,983,'App\\Models\\Receipt',983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-13','2023-10-13',2400.00,NULL,NULL,1,'2023-11-18 09:45:17','2023-11-18 09:45:17',NULL),(1236,7566,40720,1542,3,984,'App\\Models\\Receipt',984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-13','2023-10-13',999.00,NULL,NULL,1,'2023-11-18 09:45:17','2023-11-18 09:45:17',NULL),(1237,7566,40720,1542,3,985,'App\\Models\\Receipt',985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-14','2023-10-14',4600.00,NULL,NULL,1,'2023-11-18 09:45:17','2023-11-18 09:45:17',NULL);
INSERT INTO `balance_libro` VALUES (1238,7566,40720,1542,3,986,'App\\Models\\Receipt',986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-14','2023-10-14',3200.00,NULL,NULL,1,'2023-11-18 09:45:17','2023-11-18 09:45:17',NULL),(1239,7566,40720,1542,3,987,'App\\Models\\Receipt',987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',22000.00,NULL,NULL,1,'2023-11-18 09:45:17','2023-11-18 09:45:17',NULL),(1240,7566,40720,1542,3,988,'App\\Models\\Receipt',988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',8906.49,NULL,NULL,1,'2023-11-18 09:45:17','2023-11-18 10:13:13','2023-11-18 10:13:13'),(1241,7566,40720,1542,3,989,'App\\Models\\Receipt',989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',4450.00,NULL,NULL,1,'2023-11-18 09:45:17','2023-11-18 09:45:17',NULL),(1242,7566,40720,1542,3,990,'App\\Models\\Receipt',990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',3500.00,NULL,NULL,1,'2023-11-18 09:45:17','2023-11-18 09:45:17',NULL),(1243,7566,40720,1542,3,991,'App\\Models\\Receipt',991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-19','2023-10-19',12304.31,NULL,NULL,1,'2023-11-18 09:45:17','2023-11-18 10:16:23','2023-11-18 10:16:23'),(1244,7566,40720,1542,3,992,'App\\Models\\Receipt',992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-19','2023-10-19',64518.07,NULL,NULL,1,'2023-11-18 09:45:17','2023-11-18 10:17:44','2023-11-18 10:17:44'),(1245,7566,40720,1542,3,993,'App\\Models\\Receipt',993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-19','2023-10-19',59500.00,NULL,NULL,1,'2023-11-18 09:45:18','2023-11-18 10:18:59','2023-11-18 10:18:59'),(1246,7566,40720,1542,3,994,'App\\Models\\Receipt',994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-20','2023-10-20',10000.00,NULL,NULL,1,'2023-11-18 09:45:18','2023-11-18 09:45:18',NULL),(1247,7566,40720,1542,3,995,'App\\Models\\Receipt',995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-21','2023-10-21',13680.96,NULL,NULL,1,'2023-11-18 09:45:18','2023-11-18 10:25:27','2023-11-18 10:25:27'),(1248,7566,40720,1542,3,996,'App\\Models\\Receipt',996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',13400.00,NULL,NULL,1,'2023-11-18 09:45:18','2023-11-18 10:40:38','2023-11-18 10:40:38'),(1249,7566,40720,1542,3,997,'App\\Models\\Receipt',997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',3500.00,NULL,NULL,1,'2023-11-18 09:45:18','2023-11-18 09:45:18',NULL),(1250,7566,40720,1542,3,998,'App\\Models\\Receipt',998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-26','2023-10-26',5000.00,NULL,NULL,1,'2023-11-18 09:45:18','2023-11-18 09:45:18',NULL),(1251,7566,40720,1542,3,999,'App\\Models\\Receipt',999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-27','2023-10-27',3615.50,NULL,NULL,1,'2023-11-18 09:45:18','2023-11-18 10:42:29','2023-11-18 10:42:29'),(1252,7566,40720,1542,3,1000,'App\\Models\\Receipt',1000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-27','2023-10-27',6703.17,NULL,NULL,1,'2023-11-18 09:45:18','2023-11-18 10:42:14','2023-11-18 10:42:14'),(1253,7566,40720,1542,3,1001,'App\\Models\\Receipt',1001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-28','2023-10-28',19900.00,NULL,NULL,1,'2023-11-18 09:45:18','2023-11-18 09:45:18',NULL),(1254,7566,40720,1542,3,1002,'App\\Models\\Receipt',1002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-28','2023-10-28',5666.08,NULL,NULL,1,'2023-11-18 09:45:18','2023-11-18 10:14:03','2023-11-18 10:14:03'),(1255,7566,40720,1542,3,1003,'App\\Models\\Receipt',1003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-29','2023-10-29',20550.00,NULL,NULL,1,'2023-11-18 09:45:18','2023-11-18 09:45:18',NULL),(1256,7566,40720,1542,3,1004,'App\\Models\\Receipt',1004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-31','2023-10-31',3500.00,NULL,NULL,1,'2023-11-18 09:45:18','2023-11-18 09:45:18',NULL),(1257,7566,40720,1542,7,1005,'App\\Models\\Receipt',1005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-26','2023-10-26',108.15,NULL,NULL,1,'2023-11-18 09:45:54','2023-11-18 09:45:54',NULL);
INSERT INTO `balance_libro` VALUES (1258,7566,40720,1542,7,1006,'App\\Models\\Receipt',1006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',2011.72,NULL,NULL,1,'2023-11-18 09:45:54','2023-11-18 09:45:54',NULL),(1259,7566,40720,1542,7,1007,'App\\Models\\Receipt',1007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',1022.35,NULL,NULL,1,'2023-11-18 09:45:54','2023-11-18 09:45:54',NULL),(1260,7566,40720,1542,7,1008,'App\\Models\\Receipt',1008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-23','2023-10-23',784.68,NULL,NULL,1,'2023-11-18 09:45:54','2023-11-18 09:45:54',NULL),(1261,7566,40720,1542,7,1009,'App\\Models\\Receipt',1009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-20','2023-10-20',4718.83,NULL,NULL,1,'2023-11-18 09:45:54','2023-11-18 09:45:54',NULL),(1262,7566,40720,1542,7,1010,'App\\Models\\Receipt',1010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',2445.32,NULL,NULL,1,'2023-11-18 09:45:54','2023-11-18 09:45:54',NULL),(1263,7566,40720,1542,7,1011,'App\\Models\\Receipt',1011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-17','2023-10-17',1525.55,NULL,NULL,1,'2023-11-18 09:45:54','2023-11-18 09:45:54',NULL),(1264,7566,40720,1542,7,1012,'App\\Models\\Receipt',1012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-12','2023-10-12',775.25,NULL,NULL,1,'2023-11-18 09:45:54','2023-11-18 09:45:54',NULL),(1265,7566,40720,1542,7,1013,'App\\Models\\Receipt',1013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-11','2023-10-11',347.49,NULL,NULL,1,'2023-11-18 09:45:54','2023-11-18 09:45:54',NULL),(1266,7566,40720,1542,7,1014,'App\\Models\\Receipt',1014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',249.62,NULL,NULL,1,'2023-11-18 09:45:54','2023-11-18 09:45:54',NULL),(1267,7566,40720,1542,7,1015,'App\\Models\\Receipt',1015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-10','2023-10-10',1129.65,NULL,NULL,1,'2023-11-18 09:45:54','2023-11-18 09:45:54',NULL),(1268,7566,40720,1542,7,1016,'App\\Models\\Receipt',1016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-09','2023-10-09',21635.86,NULL,NULL,1,'2023-11-18 09:45:54','2023-11-18 09:45:54',NULL),(1269,7566,40720,1542,7,1017,'App\\Models\\Receipt',1017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-06','2023-10-06',385.23,NULL,NULL,1,'2023-11-18 09:45:54','2023-11-18 09:45:54',NULL),(1270,7566,40720,1542,7,1018,'App\\Models\\Receipt',1018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-05','2023-10-05',5052.65,NULL,NULL,1,'2023-11-18 09:45:54','2023-11-18 09:45:54',NULL),(1271,7566,40720,1542,7,1019,'App\\Models\\Receipt',1019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-04','2023-10-04',1444.23,NULL,NULL,1,'2023-11-18 09:45:54','2023-11-18 09:45:54',NULL),(1272,7566,40720,1542,7,1020,'App\\Models\\Receipt',1020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',463.48,NULL,NULL,1,'2023-11-18 09:45:54','2023-11-18 09:45:54',NULL),(1273,7566,40720,1542,7,1021,'App\\Models\\Receipt',1021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-02','2023-10-02',2885.71,NULL,NULL,1,'2023-11-18 09:45:55','2023-11-18 09:45:55',NULL),(1274,7566,40720,1542,3,967,'App\\Models\\Receipt',967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-01','2023-10-01',4199.99,NULL,NULL,1,'2023-11-18 10:02:07','2023-11-18 10:02:07',NULL),(1275,7566,40720,1542,3,968,'App\\Models\\Receipt',968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-01','2023-10-01',6140.00,NULL,NULL,1,'2023-11-18 10:02:52','2023-11-18 10:02:52',NULL),(1276,7566,40720,1542,3,973,'App\\Models\\Receipt',973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',9566.35,NULL,NULL,1,'2023-11-18 10:06:07','2023-11-18 10:07:31','2023-11-18 10:07:31'),(1277,7566,40720,1542,3,973,'App\\Models\\Receipt',973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',11639.08,NULL,NULL,1,'2023-11-18 10:07:31','2023-11-18 10:07:31',NULL),(1278,7566,40720,1542,3,988,'App\\Models\\Receipt',988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-18','2023-10-18',8906.49,NULL,NULL,1,'2023-11-18 10:13:13','2023-11-18 10:13:13',NULL);
INSERT INTO `balance_libro` VALUES (1279,7566,40720,1542,3,1002,'App\\Models\\Receipt',1002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-28','2023-10-28',5666.08,NULL,NULL,1,'2023-11-18 10:14:03','2023-11-18 10:14:21','2023-11-18 10:14:21'),(1280,7566,40720,1542,3,1002,'App\\Models\\Receipt',1002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-28','2023-10-28',5666.08,NULL,NULL,1,'2023-11-18 10:14:21','2023-11-18 10:14:21',NULL),(1281,7566,40720,1542,3,991,'App\\Models\\Receipt',991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-19','2023-10-19',12304.31,NULL,NULL,1,'2023-11-18 10:16:23','2023-11-18 10:16:23',NULL),(1282,7566,40720,1542,3,992,'App\\Models\\Receipt',992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-19','2023-10-19',64518.07,NULL,NULL,1,'2023-11-18 10:17:44','2023-11-18 10:17:44',NULL),(1283,7566,40720,1542,3,993,'App\\Models\\Receipt',993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-19','2023-10-19',59500.00,NULL,NULL,1,'2023-11-18 10:18:59','2023-11-18 10:18:59',NULL),(1284,7566,40720,1542,3,1022,'App\\Models\\Receipt',1022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-09-21','2023-09-21',11304.38,NULL,NULL,1,'2023-11-18 10:26:38','2023-11-18 10:26:38',NULL),(1285,7566,40720,1542,3,996,'App\\Models\\Receipt',996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',13400.00,NULL,NULL,1,'2023-11-18 10:40:38','2023-11-18 12:38:02','2023-11-18 12:38:02'),(1286,7566,40720,1542,3,1000,'App\\Models\\Receipt',1000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-27','2023-10-27',6703.17,NULL,NULL,1,'2023-11-18 10:42:14','2023-11-18 12:41:00','2023-11-18 12:41:00'),(1287,7566,40720,1542,3,999,'App\\Models\\Receipt',999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-27','2023-10-27',3615.50,NULL,NULL,1,'2023-11-18 10:42:29','2023-11-18 12:38:22','2023-11-18 12:38:22'),(1288,7566,40720,1542,3,1023,'App\\Models\\Receipt',1023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',14350.00,NULL,NULL,1,'2023-11-18 10:44:38','2023-11-18 10:44:38',NULL),(1289,7566,40720,1542,3,1024,'App\\Models\\Receipt',1024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-03','2023-10-03',3890.00,NULL,NULL,1,'2023-11-18 10:45:43','2023-11-18 10:45:43',NULL),(1290,7566,40720,1542,3,1025,'App\\Models\\Receipt',1025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-14','2023-10-14',68123.00,NULL,NULL,1,'2023-11-18 10:46:31','2023-11-18 10:46:31',NULL),(1291,7566,40720,1542,3,1026,'App\\Models\\Receipt',1026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-21','2023-10-21',70180.00,NULL,NULL,1,'2023-11-18 10:46:58','2023-11-18 10:46:58',NULL),(1292,7566,40720,1542,3,1027,'App\\Models\\Receipt',1027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-26','2023-10-26',93472.50,NULL,NULL,1,'2023-11-18 10:47:24','2023-11-18 10:47:24',NULL),(1293,7566,40720,1533,3,345,'App\\Models\\Receipt',345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',5038.98,NULL,NULL,1,'2023-11-18 12:29:03','2023-11-18 12:29:03',NULL),(1294,7566,40720,1524,3,14,'App\\Models\\Receipt',14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',845.00,NULL,NULL,1,'2023-11-18 12:29:54','2023-11-18 12:29:54',NULL),(1295,7566,40720,1524,3,13,'App\\Models\\Receipt',13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',23931.28,NULL,NULL,1,'2023-11-18 12:30:10','2023-11-18 12:30:10',NULL),(1296,7566,40720,1524,3,12,'App\\Models\\Receipt',12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',6692.62,NULL,NULL,1,'2023-11-18 12:30:34','2023-11-18 12:30:34',NULL),(1297,7566,40720,1524,3,11,'App\\Models\\Receipt',11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',8027.67,NULL,NULL,1,'2023-11-18 12:30:45','2023-11-18 12:30:45',NULL),(1298,7566,40720,1524,3,10,'App\\Models\\Receipt',10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',6801.82,NULL,NULL,1,'2023-11-18 12:30:55','2023-11-18 12:30:55',NULL),(1299,7566,40720,1533,3,353,'App\\Models\\Receipt',353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',16380.34,NULL,NULL,1,'2023-11-18 12:32:00','2023-11-18 12:32:00',NULL);
INSERT INTO `balance_libro` VALUES (1300,7566,40720,1533,3,352,'App\\Models\\Receipt',352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',10805.44,NULL,NULL,1,'2023-11-18 12:32:11','2023-11-18 12:32:11',NULL),(1301,7566,40720,1533,3,358,'App\\Models\\Receipt',358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',832.30,NULL,NULL,1,'2023-11-18 12:32:36','2023-11-18 12:32:36',NULL),(1302,7566,40720,1540,3,849,'App\\Models\\Receipt',849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',33571.67,NULL,NULL,1,'2023-11-18 12:32:47','2023-11-18 12:35:22','2023-11-18 12:35:22'),(1303,7566,40720,1533,3,359,'App\\Models\\Receipt',359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',7370.00,NULL,NULL,1,'2023-11-18 12:33:19','2023-11-18 12:33:19',NULL),(1304,7566,40720,1538,3,738,'App\\Models\\Receipt',738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',2100.00,NULL,NULL,1,'2023-11-18 12:33:49','2023-11-18 12:33:49',NULL),(1305,7566,40720,1538,3,745,'App\\Models\\Receipt',745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',30000.00,NULL,NULL,1,'2023-11-18 12:34:14','2023-11-18 12:34:14',NULL),(1306,7566,40720,1539,3,794,'App\\Models\\Receipt',794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',88999.00,NULL,NULL,1,'2023-11-18 12:34:40','2023-11-18 12:34:40',NULL),(1307,7566,40720,1539,3,803,'App\\Models\\Receipt',803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',4800.00,NULL,NULL,1,'2023-11-18 12:35:02','2023-11-18 12:35:02',NULL),(1308,7566,40720,1540,3,849,'App\\Models\\Receipt',849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',33571.67,NULL,NULL,1,'2023-11-18 12:35:22','2023-11-18 12:35:22',NULL),(1309,7566,40720,1540,3,856,'App\\Models\\Receipt',856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',61672.32,NULL,NULL,1,'2023-11-18 12:36:01','2023-11-18 12:36:01',NULL),(1310,7566,40720,1540,3,865,'App\\Models\\Receipt',865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-23','2023-08-23',33988.90,NULL,NULL,1,'2023-11-18 12:36:24','2023-11-18 12:36:24',NULL),(1311,7566,40720,1540,3,869,'App\\Models\\Receipt',869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-25','2023-08-25',13000.00,NULL,NULL,1,'2023-11-18 12:37:14','2023-11-18 12:37:14',NULL),(1312,7566,40720,1528,3,213,'App\\Models\\Receipt',213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',5860.00,NULL,NULL,1,'2023-11-18 12:37:24','2023-11-18 12:37:24',NULL),(1313,7566,40720,1542,3,996,'App\\Models\\Receipt',996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-25','2023-10-25',13400.00,NULL,NULL,1,'2023-11-18 12:38:02','2023-11-18 12:38:02',NULL),(1314,7566,40720,1542,3,999,'App\\Models\\Receipt',999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-27','2023-10-27',3615.50,NULL,NULL,1,'2023-11-18 12:38:22','2023-11-18 12:38:22',NULL),(1315,7566,40720,1525,3,56,'App\\Models\\Receipt',56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',1694.50,NULL,NULL,1,'2023-11-18 12:38:32','2023-11-18 12:38:32',NULL),(1316,7566,40720,1525,3,57,'App\\Models\\Receipt',57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',3484.20,NULL,NULL,1,'2023-11-18 12:38:47','2023-11-18 12:38:47',NULL),(1317,7566,40720,1526,3,129,'App\\Models\\Receipt',129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',4799.70,NULL,NULL,1,'2023-11-18 12:39:25','2023-11-18 12:39:25',NULL),(1318,7566,40720,1542,3,1000,'App\\Models\\Receipt',1000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-27','2023-10-27',6703.17,NULL,NULL,1,'2023-11-18 12:41:00','2023-11-18 12:41:00',NULL),(1319,7566,40720,1543,2,1028,'App\\Models\\Receipt',1028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',3632.11,NULL,NULL,1,'2023-12-20 17:13:20','2023-12-20 17:13:20',NULL),(1320,7566,40720,1543,2,1029,'App\\Models\\Receipt',1029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',14065.61,NULL,NULL,1,'2023-12-20 17:13:20','2023-12-20 17:13:20',NULL);
INSERT INTO `balance_libro` VALUES (1321,7566,40720,1543,2,1030,'App\\Models\\Receipt',1030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',322909.90,NULL,NULL,1,'2023-12-20 17:13:20','2023-12-20 17:13:20',NULL),(1322,7566,40720,1543,2,1031,'App\\Models\\Receipt',1031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',7363.33,NULL,NULL,1,'2023-12-20 17:13:20','2023-12-20 17:13:20',NULL),(1323,7566,40720,1543,2,1032,'App\\Models\\Receipt',1032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',295569.85,NULL,NULL,1,'2023-12-20 17:13:20','2023-12-20 17:13:20',NULL),(1324,7566,40720,1543,2,1033,'App\\Models\\Receipt',1033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',10829.57,NULL,NULL,1,'2023-12-20 17:13:20','2023-12-20 17:13:20',NULL),(1325,7566,40720,1543,2,1034,'App\\Models\\Receipt',1034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',566331.20,NULL,NULL,1,'2023-12-20 17:13:20','2023-12-20 17:13:20',NULL),(1326,7566,40720,1543,3,1035,'App\\Models\\Receipt',1035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',4200.00,NULL,NULL,1,'2023-12-20 17:13:38','2023-12-20 17:13:38',NULL),(1327,7566,40720,1543,3,1036,'App\\Models\\Receipt',1036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',3800.00,NULL,NULL,1,'2023-12-20 17:13:38','2023-12-20 17:13:38',NULL),(1328,7566,40720,1543,3,1037,'App\\Models\\Receipt',1037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',4500.00,NULL,NULL,1,'2023-12-20 17:13:38','2023-12-20 17:13:38',NULL),(1329,7566,40720,1543,3,1038,'App\\Models\\Receipt',1038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',9485.61,NULL,NULL,1,'2023-12-20 17:13:38','2023-12-20 19:01:57','2023-12-20 19:01:57'),(1330,7566,40720,1543,3,1039,'App\\Models\\Receipt',1039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',3900.00,NULL,NULL,1,'2023-12-20 17:13:38','2023-12-20 17:13:38',NULL),(1331,7566,40720,1543,3,1040,'App\\Models\\Receipt',1040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',3400.00,NULL,NULL,1,'2023-12-20 17:13:38','2023-12-20 17:13:38',NULL),(1332,7566,40720,1543,3,1041,'App\\Models\\Receipt',1041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',18201.99,NULL,NULL,1,'2023-12-20 17:13:38','2023-12-20 17:38:44','2023-12-20 17:38:44'),(1333,7566,40720,1543,3,1042,'App\\Models\\Receipt',1042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',11250.00,NULL,NULL,1,'2023-12-20 17:13:38','2023-12-20 17:13:38',NULL),(1334,7566,40720,1543,3,1043,'App\\Models\\Receipt',1043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',4000.00,NULL,NULL,1,'2023-12-20 17:13:39','2023-12-20 17:13:39',NULL),(1335,7566,40720,1543,3,1044,'App\\Models\\Receipt',1044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-05','2023-11-05',16683.79,NULL,NULL,1,'2023-12-20 17:13:39','2023-12-20 17:37:16','2023-12-20 17:37:16'),(1336,7566,40720,1543,3,1045,'App\\Models\\Receipt',1045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',3500.00,NULL,NULL,1,'2023-12-20 17:13:39','2023-12-20 17:13:39',NULL),(1337,7566,40720,1543,3,1046,'App\\Models\\Receipt',1046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',3500.00,NULL,NULL,1,'2023-12-20 17:13:39','2023-12-20 17:13:39',NULL),(1338,7566,40720,1543,3,1047,'App\\Models\\Receipt',1047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',3900.00,NULL,NULL,1,'2023-12-20 17:13:39','2023-12-20 17:13:39',NULL),(1339,7566,40720,1543,3,1048,'App\\Models\\Receipt',1048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',3500.00,NULL,NULL,1,'2023-12-20 17:13:39','2023-12-20 17:13:39',NULL),(1340,7566,40720,1543,3,1049,'App\\Models\\Receipt',1049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',8747.80,NULL,NULL,1,'2023-12-20 17:13:39','2023-12-20 17:36:28','2023-12-20 17:36:28');
INSERT INTO `balance_libro` VALUES (1341,7566,40720,1543,3,1050,'App\\Models\\Receipt',1050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-12','2023-11-12',999.00,NULL,NULL,1,'2023-12-20 17:13:39','2023-12-20 17:13:39',NULL),(1342,7566,40720,1543,3,1051,'App\\Models\\Receipt',1051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',4100.00,NULL,NULL,1,'2023-12-20 17:13:39','2023-12-20 17:13:39',NULL),(1343,7566,40720,1543,3,1052,'App\\Models\\Receipt',1052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',49333.55,NULL,NULL,1,'2023-12-20 17:13:39','2023-12-20 17:13:39',NULL),(1344,7566,40720,1543,3,1053,'App\\Models\\Receipt',1053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',3500.00,NULL,NULL,1,'2023-12-20 17:13:39','2023-12-20 17:13:39',NULL),(1345,7566,40720,1543,3,1054,'App\\Models\\Receipt',1054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',5635.34,NULL,NULL,1,'2023-12-20 17:13:39','2023-12-20 17:35:37','2023-12-20 17:35:37'),(1346,7566,40720,1543,3,1055,'App\\Models\\Receipt',1055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',47899.99,NULL,NULL,1,'2023-12-20 17:13:39','2023-12-20 17:34:32','2023-12-20 17:34:32'),(1347,7566,40720,1543,3,1056,'App\\Models\\Receipt',1056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',1450.00,NULL,NULL,1,'2023-12-20 17:13:39','2023-12-20 17:33:25','2023-12-20 17:33:25'),(1348,7566,40720,1543,3,1057,'App\\Models\\Receipt',1057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',4100.00,NULL,NULL,1,'2023-12-20 17:13:39','2023-12-20 17:13:39',NULL),(1349,7566,40720,1543,3,1058,'App\\Models\\Receipt',1058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',28000.00,NULL,NULL,1,'2023-12-20 17:13:39','2023-12-20 17:13:39',NULL),(1350,7566,40720,1543,3,1059,'App\\Models\\Receipt',1059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-18','2023-11-18',3500.00,NULL,NULL,1,'2023-12-20 17:13:40','2023-12-20 17:13:40',NULL),(1351,7566,40720,1543,3,1060,'App\\Models\\Receipt',1060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',3500.00,NULL,NULL,1,'2023-12-20 17:13:40','2023-12-20 17:13:40',NULL),(1352,7566,40720,1543,3,1061,'App\\Models\\Receipt',1061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',57000.00,NULL,NULL,1,'2023-12-20 17:13:40','2023-12-20 17:33:06','2023-12-20 17:33:06'),(1353,7566,40720,1543,3,1062,'App\\Models\\Receipt',1062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',11500.00,NULL,NULL,1,'2023-12-20 17:13:40','2023-12-20 17:32:43','2023-12-20 17:32:43'),(1354,7566,40720,1543,3,1063,'App\\Models\\Receipt',1063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',17142.55,NULL,NULL,1,'2023-12-20 17:13:40','2023-12-20 17:29:45','2023-12-20 17:29:45'),(1355,7566,40720,1543,3,1064,'App\\Models\\Receipt',1064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',3500.00,NULL,NULL,1,'2023-12-20 17:13:40','2023-12-20 17:13:40',NULL),(1356,7566,40720,1543,3,1065,'App\\Models\\Receipt',1065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',5000.00,NULL,NULL,1,'2023-12-20 17:13:40','2023-12-20 17:13:40',NULL),(1357,7566,40720,1543,3,1066,'App\\Models\\Receipt',1066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',9060.00,NULL,NULL,1,'2023-12-20 17:13:40','2023-12-20 17:13:40',NULL),(1358,7566,40720,1543,3,1067,'App\\Models\\Receipt',1067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',19027.45,NULL,NULL,1,'2023-12-20 17:13:40','2023-12-20 17:27:34','2023-12-20 17:27:34'),(1359,7566,40720,1543,3,1068,'App\\Models\\Receipt',1068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',76845.47,NULL,NULL,1,'2023-12-20 17:13:40','2023-12-20 17:26:30','2023-12-20 17:26:30'),(1360,7566,40720,1543,3,1069,'App\\Models\\Receipt',1069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-25','2023-11-25',5700.00,NULL,NULL,1,'2023-12-20 17:13:40','2023-12-20 17:13:40',NULL);
INSERT INTO `balance_libro` VALUES (1361,7566,40720,1543,3,1070,'App\\Models\\Receipt',1070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',11700.00,NULL,NULL,1,'2023-12-20 17:13:40','2023-12-20 17:13:40',NULL),(1362,7566,40720,1543,3,1071,'App\\Models\\Receipt',1071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',25000.00,NULL,NULL,1,'2023-12-20 17:13:40','2023-12-20 17:13:40',NULL),(1363,7566,40720,1543,3,1072,'App\\Models\\Receipt',1072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',6700.00,NULL,NULL,1,'2023-12-20 17:13:40','2023-12-20 17:25:27','2023-12-20 17:25:27'),(1364,7566,40720,1543,3,1073,'App\\Models\\Receipt',1073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',1350.01,NULL,NULL,1,'2023-12-20 17:13:40','2023-12-20 17:24:30','2023-12-20 17:24:30'),(1365,7566,40720,1543,3,1072,'App\\Models\\Receipt',1072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',6700.00,NULL,NULL,1,'2023-12-20 17:25:27','2023-12-20 17:25:27',NULL),(1366,7566,40720,1543,3,1067,'App\\Models\\Receipt',1067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',19027.45,NULL,NULL,1,'2023-12-20 17:27:34','2023-12-20 17:27:34',NULL),(1367,7566,40720,1543,3,1074,'App\\Models\\Receipt',1074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-10-21','2023-10-21',13680.96,NULL,NULL,1,'2023-12-20 17:31:33','2023-12-20 17:31:33',NULL),(1368,7566,40720,1543,3,1062,'App\\Models\\Receipt',1062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',11500.00,NULL,NULL,1,'2023-12-20 17:32:43','2023-12-20 18:01:45','2023-12-20 18:01:45'),(1369,7566,40720,1543,3,1061,'App\\Models\\Receipt',1061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',57000.00,NULL,NULL,1,'2023-12-20 17:33:06','2023-12-20 17:33:06',NULL),(1370,7566,40720,1543,3,1055,'App\\Models\\Receipt',1055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',47899.99,NULL,NULL,1,'2023-12-20 17:34:32','2023-12-20 17:34:52','2023-12-20 17:34:52'),(1371,7566,40720,1543,3,1055,'App\\Models\\Receipt',1055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',47899.99,NULL,NULL,1,'2023-12-20 17:34:52','2023-12-20 17:34:52',NULL),(1372,7566,40720,1543,3,1054,'App\\Models\\Receipt',1054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',5635.34,NULL,NULL,1,'2023-12-20 17:35:37','2023-12-20 17:35:37',NULL),(1373,7566,40720,1543,3,1049,'App\\Models\\Receipt',1049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-11','2023-11-11',8747.80,NULL,NULL,1,'2023-12-20 17:36:28','2023-12-20 17:36:28',NULL),(1374,7566,40720,1543,3,1044,'App\\Models\\Receipt',1044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-05','2023-11-05',17197.10,NULL,NULL,1,'2023-12-20 17:37:16','2023-12-20 18:52:48','2023-12-20 18:52:48'),(1375,7566,40720,1543,3,1041,'App\\Models\\Receipt',1041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',18201.99,NULL,NULL,1,'2023-12-20 17:38:44','2023-12-20 17:38:44',NULL),(1376,7566,40720,1543,3,1075,'App\\Models\\Receipt',1075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',12000.11,NULL,NULL,1,'2023-12-20 17:39:58','2023-12-20 17:39:58',NULL),(1377,7566,40720,1543,3,1076,'App\\Models\\Receipt',1076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',4970.00,NULL,NULL,1,'2023-12-20 17:40:59','2023-12-20 17:40:59',NULL),(1378,7566,40720,1543,3,1077,'App\\Models\\Receipt',1077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-04','2023-11-04',13551.34,NULL,NULL,1,'2023-12-20 17:42:15','2023-12-20 17:42:15',NULL),(1379,7566,40720,1543,3,1078,'App\\Models\\Receipt',1078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',16941.68,NULL,NULL,1,'2023-12-20 17:43:01','2023-12-20 17:43:01',NULL),(1380,7566,40720,1543,3,1079,'App\\Models\\Receipt',1079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',782.63,NULL,NULL,1,'2023-12-20 17:49:44','2023-12-20 17:51:50','2023-12-20 17:51:50');
INSERT INTO `balance_libro` VALUES (1381,7566,40720,1543,3,1079,'App\\Models\\Receipt',1079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',78262.80,NULL,NULL,1,'2023-12-20 17:51:50','2023-12-20 17:53:21','2023-12-20 17:53:21'),(1382,7566,40720,1543,3,1079,'App\\Models\\Receipt',1079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',89540.00,NULL,NULL,1,'2023-12-20 17:53:21','2023-12-20 19:11:29','2023-12-20 19:11:29'),(1383,7566,40720,1543,3,1080,'App\\Models\\Receipt',1080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-30','2023-11-30',67760.00,NULL,NULL,1,'2023-12-20 17:56:24','2023-12-20 17:56:24',NULL),(1384,7566,40720,1543,3,1081,'App\\Models\\Receipt',1081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-26','2023-11-26',22000.00,NULL,NULL,1,'2023-12-20 17:57:15','2023-12-20 17:57:15',NULL),(1385,7566,40720,1543,3,1082,'App\\Models\\Receipt',1082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',13650.00,NULL,NULL,1,'2023-12-20 17:58:02','2023-12-20 17:58:02',NULL),(1386,7566,40720,1543,3,1062,'App\\Models\\Receipt',1062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',11500.00,NULL,NULL,1,'2023-12-20 18:01:45','2023-12-20 18:01:45',NULL),(1387,7566,40720,1543,3,1044,'App\\Models\\Receipt',1044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-05','2023-11-05',16683.80,NULL,NULL,1,'2023-12-20 18:52:48','2023-12-20 18:52:48',NULL),(1388,7566,40720,1543,3,1038,'App\\Models\\Receipt',1038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',9485.61,NULL,NULL,1,'2023-12-20 19:01:57','2023-12-20 19:01:57',NULL),(1389,7566,40720,1543,3,1083,'App\\Models\\Receipt',1083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',78262.80,NULL,NULL,1,'2023-12-20 19:07:41','2023-12-20 19:07:41',NULL),(1390,7566,40720,1543,3,1084,'App\\Models\\Receipt',1084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',52200.00,NULL,NULL,1,'2023-12-20 19:09:32','2023-12-20 19:09:32',NULL),(1391,7566,40720,1543,3,1079,'App\\Models\\Receipt',1079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',89540.00,NULL,NULL,1,'2023-12-20 19:11:29','2023-12-20 19:11:29',NULL),(1392,7566,40720,1543,7,1085,'App\\Models\\Receipt',1085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-29','2023-11-29',6445.83,NULL,NULL,1,'2023-12-20 19:39:24','2023-12-20 19:39:24',NULL),(1393,7566,40720,1543,7,1086,'App\\Models\\Receipt',1086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',123.76,NULL,NULL,1,'2023-12-20 19:39:24','2023-12-20 19:39:24',NULL),(1394,7566,40720,1543,7,1087,'App\\Models\\Receipt',1087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-28','2023-11-28',1022.35,NULL,NULL,1,'2023-12-20 19:39:24','2023-12-20 19:39:24',NULL),(1395,7566,40720,1543,7,1088,'App\\Models\\Receipt',1088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-27','2023-11-27',393.87,NULL,NULL,1,'2023-12-20 19:39:24','2023-12-20 19:39:24',NULL),(1396,7566,40720,1543,7,1089,'App\\Models\\Receipt',1089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-24','2023-11-24',934.76,NULL,NULL,1,'2023-12-20 19:39:24','2023-12-20 19:39:24',NULL),(1397,7566,40720,1543,7,1090,'App\\Models\\Receipt',1090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-23','2023-11-23',815.85,NULL,NULL,1,'2023-12-20 19:39:24','2023-12-20 19:39:24',NULL),(1398,7566,40720,1543,7,1091,'App\\Models\\Receipt',1091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-22','2023-11-22',8734.89,NULL,NULL,1,'2023-12-20 19:39:24','2023-12-20 19:39:24',NULL),(1399,7566,40720,1543,7,1092,'App\\Models\\Receipt',1092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',10071.66,NULL,NULL,1,'2023-12-20 19:39:24','2023-12-20 19:39:24',NULL),(1400,7566,40720,1543,7,1093,'App\\Models\\Receipt',1093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-17','2023-11-17',1422.00,NULL,NULL,1,'2023-12-20 19:39:24','2023-12-20 19:39:24',NULL),(1401,7566,40720,1543,7,1094,'App\\Models\\Receipt',1094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-16','2023-11-16',136.91,NULL,NULL,1,'2023-12-20 19:39:24','2023-12-20 19:39:24',NULL);
INSERT INTO `balance_libro` VALUES (1402,7566,40720,1543,7,1095,'App\\Models\\Receipt',1095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-14','2023-11-14',123.76,NULL,NULL,1,'2023-12-20 19:39:24','2023-12-20 19:39:24',NULL),(1403,7566,40720,1543,7,1096,'App\\Models\\Receipt',1096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-13','2023-11-13',5970.81,NULL,NULL,1,'2023-12-20 19:39:24','2023-12-20 19:39:24',NULL),(1404,7566,40720,1543,7,1097,'App\\Models\\Receipt',1097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-09','2023-11-09',19949.61,NULL,NULL,1,'2023-12-20 19:39:24','2023-12-20 19:39:24',NULL),(1405,7566,40720,1543,7,1098,'App\\Models\\Receipt',1098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-08','2023-11-08',347.49,NULL,NULL,1,'2023-12-20 19:39:24','2023-12-20 19:39:24',NULL),(1406,7566,40720,1543,7,1099,'App\\Models\\Receipt',1099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-07','2023-11-07',287.03,NULL,NULL,1,'2023-12-20 19:39:24','2023-12-20 19:39:24',NULL),(1407,7566,40720,1543,7,1100,'App\\Models\\Receipt',1100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-06','2023-11-06',5326.40,NULL,NULL,1,'2023-12-20 19:39:25','2023-12-20 19:39:25',NULL),(1408,7566,40720,1543,7,1101,'App\\Models\\Receipt',1101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-03','2023-11-03',1565.90,NULL,NULL,1,'2023-12-20 19:39:25','2023-12-20 19:39:25',NULL),(1409,7566,40720,1543,7,1102,'App\\Models\\Receipt',1102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',618.85,NULL,NULL,1,'2023-12-20 19:39:25','2023-12-20 19:39:25',NULL),(1410,7566,40720,1543,7,1103,'App\\Models\\Receipt',1103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-02','2023-11-02',504.29,NULL,NULL,1,'2023-12-20 19:39:25','2023-12-20 19:39:25',NULL),(1411,7566,40720,1543,7,1104,'App\\Models\\Receipt',1104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-01','2023-11-01',4554.95,NULL,NULL,1,'2023-12-20 19:39:25','2023-12-20 19:39:25',NULL),(1412,7566,40720,1544,2,1105,'App\\Models\\Receipt',1105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',3632.09,NULL,NULL,1,'2024-01-15 17:12:15','2024-01-15 17:12:15',NULL),(1413,7566,40720,1544,2,1106,'App\\Models\\Receipt',1106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',303637.21,NULL,NULL,1,'2024-01-15 17:12:15','2024-01-15 17:12:15',NULL),(1414,7566,40720,1544,2,1107,'App\\Models\\Receipt',1107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',488496.65,NULL,NULL,1,'2024-01-15 17:12:15','2024-01-15 17:12:15',NULL),(1415,7566,40720,1544,2,1108,'App\\Models\\Receipt',1108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',7363.41,NULL,NULL,1,'2024-01-15 17:12:15','2024-01-15 17:12:15',NULL),(1416,7566,40720,1544,2,1109,'App\\Models\\Receipt',1109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',6529.91,NULL,NULL,1,'2024-01-15 17:12:15','2024-01-15 17:12:15',NULL),(1417,7566,40720,1544,2,1110,'App\\Models\\Receipt',1110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',629549.53,NULL,NULL,1,'2024-01-15 17:12:15','2024-01-15 17:12:15',NULL),(1418,7566,40720,1544,3,1111,'App\\Models\\Receipt',1111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',4400.00,NULL,NULL,1,'2024-01-15 17:21:28','2024-01-15 17:21:28',NULL),(1419,7566,40720,1544,3,1112,'App\\Models\\Receipt',1112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',8090.00,NULL,NULL,1,'2024-01-15 17:21:29','2024-01-15 17:59:03','2024-01-15 17:59:03'),(1420,7566,40720,1544,3,1113,'App\\Models\\Receipt',1113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',76845.47,NULL,NULL,1,'2024-01-15 17:21:29','2024-01-15 18:05:06','2024-01-15 18:05:06'),(1421,7566,40720,1544,3,1114,'App\\Models\\Receipt',1114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',4300.00,NULL,NULL,1,'2024-01-15 17:21:29','2024-01-15 17:21:29',NULL),(1422,7566,40720,1544,3,1115,'App\\Models\\Receipt',1115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-02','2023-12-02',12000.00,NULL,NULL,1,'2024-01-15 17:21:29','2024-01-15 17:21:29',NULL);
INSERT INTO `balance_libro` VALUES (1423,7566,40720,1544,3,1116,'App\\Models\\Receipt',1116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-03','2023-12-03',15796.62,NULL,NULL,1,'2024-01-15 17:21:29','2024-01-15 17:44:24','2024-01-15 17:44:24'),(1424,7566,40720,1544,3,1117,'App\\Models\\Receipt',1117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-03','2023-12-03',15863.19,NULL,NULL,1,'2024-01-15 17:21:29','2024-01-15 17:32:23','2024-01-15 17:32:23'),(1425,7566,40720,1544,3,1118,'App\\Models\\Receipt',1118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',2680.00,NULL,NULL,1,'2024-01-15 17:21:29','2024-01-15 17:21:29',NULL),(1426,7566,40720,1544,3,1119,'App\\Models\\Receipt',1119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',999.00,NULL,NULL,1,'2024-01-15 17:21:29','2024-01-15 18:06:08','2024-01-15 18:06:08'),(1427,7566,40720,1544,3,1120,'App\\Models\\Receipt',1120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',11250.00,NULL,NULL,1,'2024-01-15 17:21:29','2024-01-15 17:21:29',NULL),(1428,7566,40720,1544,3,1121,'App\\Models\\Receipt',1121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',14300.00,NULL,NULL,1,'2024-01-15 17:21:29','2024-01-15 17:21:29',NULL),(1429,7566,40720,1544,3,1122,'App\\Models\\Receipt',1122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',14300.00,NULL,NULL,1,'2024-01-15 17:21:29','2024-01-15 17:21:29',NULL),(1430,7566,40720,1544,3,1123,'App\\Models\\Receipt',1123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',4000.00,NULL,NULL,1,'2024-01-15 17:21:29','2024-01-15 17:21:29',NULL),(1431,7566,40720,1544,3,1124,'App\\Models\\Receipt',1124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',4900.00,NULL,NULL,1,'2024-01-15 17:21:29','2024-01-15 17:21:29',NULL),(1432,7566,40720,1544,3,1125,'App\\Models\\Receipt',1125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-09','2023-12-09',40999.00,NULL,NULL,1,'2024-01-15 17:21:29','2024-01-15 17:42:27','2024-01-15 17:42:27'),(1433,7566,40720,1544,3,1126,'App\\Models\\Receipt',1126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',5800.00,NULL,NULL,1,'2024-01-15 17:21:30','2024-01-15 17:21:30',NULL),(1434,7566,40720,1544,3,1127,'App\\Models\\Receipt',1127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',6160.00,NULL,NULL,1,'2024-01-15 17:21:30','2024-01-15 17:21:30',NULL),(1435,7566,40720,1544,3,1128,'App\\Models\\Receipt',1128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-14','2023-12-14',9000.00,NULL,NULL,1,'2024-01-15 17:21:30','2024-01-15 17:36:55','2024-01-15 17:36:55'),(1436,7566,40720,1544,3,1129,'App\\Models\\Receipt',1129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',9400.00,NULL,NULL,1,'2024-01-15 17:21:30','2024-01-15 17:21:30',NULL),(1437,7566,40720,1544,3,1130,'App\\Models\\Receipt',1130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',28000.00,NULL,NULL,1,'2024-01-15 17:21:30','2024-01-15 17:21:30',NULL),(1438,7566,40720,1544,3,1131,'App\\Models\\Receipt',1131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-16','2023-12-16',3900.00,NULL,NULL,1,'2024-01-15 17:21:30','2024-01-15 17:21:30',NULL),(1439,7566,40720,1544,3,1132,'App\\Models\\Receipt',1132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-17','2023-12-17',19794.49,NULL,NULL,1,'2024-01-15 17:21:30','2024-01-15 17:41:26','2024-01-15 17:41:26'),(1440,7566,40720,1544,3,1133,'App\\Models\\Receipt',1133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',4500.00,NULL,NULL,1,'2024-01-15 17:21:30','2024-01-15 17:21:30',NULL),(1441,7566,40720,1544,3,1134,'App\\Models\\Receipt',1134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',4000.00,NULL,NULL,1,'2024-01-15 17:21:30','2024-01-15 17:21:30',NULL),(1442,7566,40720,1544,3,1135,'App\\Models\\Receipt',1135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',17178.50,NULL,NULL,1,'2024-01-15 17:21:30','2024-01-15 17:54:21','2024-01-15 17:54:21');
INSERT INTO `balance_libro` VALUES (1443,7566,40720,1544,3,1136,'App\\Models\\Receipt',1136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',6770.00,NULL,NULL,1,'2024-01-15 17:21:30','2024-01-15 18:09:07','2024-01-15 18:09:07'),(1444,7566,40720,1544,3,1137,'App\\Models\\Receipt',1137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',8800.00,NULL,NULL,1,'2024-01-15 17:21:30','2024-01-15 17:21:30',NULL),(1445,7566,40720,1544,3,1138,'App\\Models\\Receipt',1138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',21255.10,NULL,NULL,1,'2024-01-15 17:21:30','2024-01-15 18:16:07','2024-01-15 18:16:07'),(1446,7566,40720,1544,3,1139,'App\\Models\\Receipt',1139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',9000.00,NULL,NULL,1,'2024-01-15 17:21:30','2024-01-15 17:21:30',NULL),(1447,7566,40720,1544,3,1117,'App\\Models\\Receipt',1117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-03','2023-12-03',1545.99,NULL,NULL,1,'2024-01-15 17:32:23','2024-01-15 17:34:03','2024-01-15 17:34:03'),(1448,7566,40720,1544,3,1117,'App\\Models\\Receipt',1117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-03','2023-12-03',15863.19,NULL,NULL,1,'2024-01-15 17:34:03','2024-01-15 17:34:57','2024-01-15 17:34:57'),(1449,7566,40720,1544,3,1117,'App\\Models\\Receipt',1117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-03','2023-12-03',15863.19,NULL,NULL,1,'2024-01-15 17:34:57','2024-01-15 17:34:57',NULL),(1450,7566,40720,1544,3,1128,'App\\Models\\Receipt',1128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-14','2023-12-14',9000.00,NULL,NULL,1,'2024-01-15 17:36:55','2024-01-15 17:36:55',NULL),(1451,7566,40720,1544,3,1132,'App\\Models\\Receipt',1132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-17','2023-12-17',19794.49,NULL,NULL,1,'2024-01-15 17:41:26','2024-01-15 17:41:26',NULL),(1452,7566,40720,1544,3,1125,'App\\Models\\Receipt',1125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-09','2023-12-09',40999.00,NULL,NULL,1,'2024-01-15 17:42:27','2024-01-15 17:42:27',NULL),(1453,7566,40720,1544,3,1116,'App\\Models\\Receipt',1116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-03','2023-12-03',15796.62,NULL,NULL,1,'2024-01-15 17:44:24','2024-01-15 17:44:24',NULL),(1454,7566,40720,1544,3,1140,'App\\Models\\Receipt',1140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',16200.00,NULL,NULL,1,'2024-01-15 17:47:45','2024-01-15 17:47:45',NULL),(1455,7566,40720,1544,3,1141,'App\\Models\\Receipt',1141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-23','2023-12-23',7750.00,NULL,NULL,1,'2024-01-15 17:49:52','2024-01-15 17:49:52',NULL),(1456,7566,40720,1544,3,1142,'App\\Models\\Receipt',1142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',7150.00,NULL,NULL,1,'2024-01-15 17:50:34','2024-01-15 17:50:34',NULL),(1457,7566,40720,1544,3,1143,'App\\Models\\Receipt',1143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-08','2023-12-08',6650.00,NULL,NULL,1,'2024-01-15 17:51:05','2024-01-15 17:51:05',NULL),(1458,7566,40720,1544,3,1135,'App\\Models\\Receipt',1135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',17178.50,NULL,NULL,1,'2024-01-15 17:54:21','2024-01-15 17:54:21',NULL),(1459,7566,40720,1544,3,1144,'App\\Models\\Receipt',1144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-02','2023-12-02',8000.01,NULL,NULL,1,'2024-01-15 17:57:58','2024-01-15 17:57:58',NULL),(1460,7566,40720,1544,3,1112,'App\\Models\\Receipt',1112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',8090.00,NULL,NULL,1,'2024-01-15 17:59:03','2024-01-15 17:59:03',NULL),(1461,7566,40720,1544,3,1145,'App\\Models\\Receipt',1145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',16740.40,NULL,NULL,1,'2024-01-15 18:00:37','2024-01-15 18:00:37',NULL),(1462,7566,40720,1544,3,1146,'App\\Models\\Receipt',1146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',100430.00,NULL,NULL,1,'2024-01-15 18:01:35','2024-01-15 18:01:35',NULL);
INSERT INTO `balance_libro` VALUES (1463,7566,40720,1544,3,1147,'App\\Models\\Receipt',1147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',131890.00,NULL,NULL,1,'2024-01-15 18:02:07','2024-01-15 18:02:07',NULL),(1464,7566,40720,1544,3,1148,'App\\Models\\Receipt',1148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',11100.00,NULL,NULL,1,'2024-01-15 18:02:53','2024-01-15 18:02:53',NULL),(1465,7566,40720,1544,3,1149,'App\\Models\\Receipt',1149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-30','2023-12-30',19700.00,NULL,NULL,1,'2024-01-15 18:03:39','2024-01-15 18:03:39',NULL),(1466,7566,40720,1544,3,1150,'App\\Models\\Receipt',1150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-30','2023-12-30',25712.02,NULL,NULL,1,'2024-01-15 18:04:29','2024-01-15 18:04:29',NULL),(1467,7566,40720,1544,3,1119,'App\\Models\\Receipt',1119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',999.00,NULL,NULL,1,'2024-01-15 18:06:08','2024-01-15 18:06:08',NULL),(1468,7566,40720,1544,3,1136,'App\\Models\\Receipt',1136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',6770.01,NULL,NULL,1,'2024-01-15 18:09:07','2024-01-15 18:11:38','2024-01-15 18:11:38'),(1469,7566,40720,1544,3,1151,'App\\Models\\Receipt',1151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-11-21','2023-11-21',17142.55,NULL,NULL,1,'2024-01-15 18:25:22','2024-01-15 18:25:22',NULL),(1470,7566,40720,1544,7,1152,'App\\Models\\Receipt',1152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',638.97,NULL,NULL,1,'2024-01-15 18:27:27','2024-01-15 18:27:27',NULL),(1471,7566,40720,1544,7,1153,'App\\Models\\Receipt',1153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-28','2023-12-28',424.25,NULL,NULL,1,'2024-01-15 18:27:27','2024-01-15 18:27:27',NULL),(1472,7566,40720,1544,7,1154,'App\\Models\\Receipt',1154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-27','2023-12-27',1022.36,NULL,NULL,1,'2024-01-15 18:27:27','2024-01-15 18:27:27',NULL),(1473,7566,40720,1544,7,1155,'App\\Models\\Receipt',1155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-26','2023-12-26',1839.44,NULL,NULL,1,'2024-01-15 18:27:28','2024-01-15 18:27:28',NULL),(1474,7566,40720,1544,7,1156,'App\\Models\\Receipt',1156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-22','2023-12-22',581.73,NULL,NULL,1,'2024-01-15 18:27:28','2024-01-15 18:27:28',NULL),(1475,7566,40720,1544,7,1157,'App\\Models\\Receipt',1157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',6813.81,NULL,NULL,1,'2024-01-15 18:27:28','2024-01-15 18:27:28',NULL),(1476,7566,40720,1544,7,1158,'App\\Models\\Receipt',1158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-18','2023-12-18',9163.62,NULL,NULL,1,'2024-01-15 18:27:28','2024-01-15 18:27:28',NULL),(1477,7566,40720,1544,7,1159,'App\\Models\\Receipt',1159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-14','2023-12-14',289.15,NULL,NULL,1,'2024-01-15 18:27:28','2024-01-15 18:27:28',NULL),(1478,7566,40720,1544,7,1160,'App\\Models\\Receipt',1160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-13','2023-12-13',225.77,NULL,NULL,1,'2024-01-15 18:27:28','2024-01-15 18:27:28',NULL),(1479,7566,40720,1544,7,1161,'App\\Models\\Receipt',1161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-12','2023-12-12',1514.92,NULL,NULL,1,'2024-01-15 18:27:28','2024-01-15 18:27:28',NULL),(1480,7566,40720,1544,7,1162,'App\\Models\\Receipt',1162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',23989.37,NULL,NULL,1,'2024-01-15 18:27:28','2024-01-15 18:27:28',NULL),(1481,7566,40720,1544,7,1163,'App\\Models\\Receipt',1163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',3589.88,NULL,NULL,1,'2024-01-15 18:27:28','2024-01-15 18:27:28',NULL),(1482,7566,40720,1544,7,1164,'App\\Models\\Receipt',1164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',6177.45,NULL,NULL,1,'2024-01-15 18:27:28','2024-01-15 18:27:28',NULL),(1483,7566,40720,1544,7,1165,'App\\Models\\Receipt',1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',504.29,NULL,NULL,1,'2024-01-15 18:27:28','2024-01-15 18:27:28',NULL);
INSERT INTO `balance_libro` VALUES (1484,7566,40720,1544,7,1166,'App\\Models\\Receipt',1166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',2382.56,NULL,NULL,1,'2024-01-15 18:27:28','2024-01-15 18:27:28',NULL),(1485,7566,40720,1544,7,1167,'App\\Models\\Receipt',1167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',545.78,NULL,NULL,1,'2024-01-15 18:27:28','2024-01-15 18:27:28',NULL),(1486,7566,40720,1548,2,1168,'App\\Models\\Receipt',1168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-01','2024-01-01',397174.18,NULL,NULL,1,'2024-02-09 21:12:45','2024-02-09 21:12:45',NULL),(1487,7566,40720,1548,2,1169,'App\\Models\\Receipt',1169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-02','2024-01-02',3632.12,NULL,NULL,1,'2024-02-09 21:12:46','2024-02-09 21:12:46',NULL),(1488,7566,40720,1548,2,1170,'App\\Models\\Receipt',1170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-02','2024-01-02',419010.78,NULL,NULL,1,'2024-02-09 21:12:46','2024-02-09 21:12:46',NULL),(1489,7566,40720,1548,2,1171,'App\\Models\\Receipt',1171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-08','2024-01-08',13918.24,NULL,NULL,1,'2024-02-09 21:12:46','2024-02-09 21:12:46',NULL),(1490,7566,40720,1548,2,1172,'App\\Models\\Receipt',1172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-16','2024-01-16',704216.91,NULL,NULL,1,'2024-02-09 21:12:46','2024-02-09 21:12:46',NULL),(1491,7566,40720,1548,3,1173,'App\\Models\\Receipt',1173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-01','2024-01-01',5000.00,NULL,NULL,1,'2024-02-09 21:17:13','2024-02-09 21:17:13',NULL),(1492,7566,40720,1548,3,1174,'App\\Models\\Receipt',1174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-01','2024-01-01',76845.47,NULL,NULL,1,'2024-02-09 21:17:13','2024-02-09 21:17:55','2024-02-09 21:17:55'),(1493,7566,40720,1548,3,1175,'App\\Models\\Receipt',1175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',999.00,NULL,NULL,1,'2024-02-09 21:17:13','2024-02-09 21:17:13',NULL),(1494,7566,40720,1548,3,1176,'App\\Models\\Receipt',1176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',19754.63,NULL,NULL,1,'2024-02-09 21:17:13','2024-02-10 17:16:18','2024-02-10 17:16:18'),(1495,7566,40720,1548,3,1177,'App\\Models\\Receipt',1177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-04','2024-01-04',5000.00,NULL,NULL,1,'2024-02-09 21:17:13','2024-02-09 21:17:13',NULL),(1496,7566,40720,1548,3,1178,'App\\Models\\Receipt',1178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-04','2024-01-04',11250.00,NULL,NULL,1,'2024-02-09 21:17:14','2024-02-09 21:17:14',NULL),(1497,7566,40720,1548,3,1179,'App\\Models\\Receipt',1179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-06','2024-01-06',9500.00,NULL,NULL,1,'2024-02-09 21:17:14','2024-02-09 21:17:14',NULL),(1498,7566,40720,1548,3,1180,'App\\Models\\Receipt',1180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-10','2024-01-10',48415.87,NULL,NULL,1,'2024-02-09 21:17:14','2024-02-10 17:19:31','2024-02-10 17:19:31'),(1499,7566,40720,1548,3,1181,'App\\Models\\Receipt',1181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-10','2024-01-10',4400.00,NULL,NULL,1,'2024-02-09 21:17:14','2024-02-09 21:17:14',NULL),(1500,7566,40720,1548,3,1182,'App\\Models\\Receipt',1182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-11','2024-01-11',8900.00,NULL,NULL,1,'2024-02-09 21:17:14','2024-02-09 21:17:14',NULL),(1501,7566,40720,1548,3,1183,'App\\Models\\Receipt',1183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-12','2024-01-12',31000.00,NULL,NULL,1,'2024-02-09 21:17:14','2024-02-09 21:17:14',NULL),(1502,7566,40720,1548,3,1184,'App\\Models\\Receipt',1184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-13','2024-01-13',30450.00,NULL,NULL,1,'2024-02-09 21:17:14','2024-02-09 21:17:14',NULL),(1503,7566,40720,1548,3,1185,'App\\Models\\Receipt',1185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-15','2024-01-15',5560.00,NULL,NULL,1,'2024-02-09 21:17:14','2024-02-09 21:17:14',NULL);
INSERT INTO `balance_libro` VALUES (1504,7566,40720,1548,3,1186,'App\\Models\\Receipt',1186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-15','2024-01-15',4400.00,NULL,NULL,1,'2024-02-09 21:17:14','2024-02-09 21:17:14',NULL),(1505,7566,40720,1548,3,1187,'App\\Models\\Receipt',1187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-17','2024-01-17',6788.27,NULL,NULL,1,'2024-02-09 21:17:14','2024-02-10 17:24:30','2024-02-10 17:24:30'),(1506,7566,40720,1548,3,1188,'App\\Models\\Receipt',1188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-17','2024-01-17',46013.43,NULL,NULL,1,'2024-02-09 21:17:14','2024-02-10 17:23:03','2024-02-10 17:23:03'),(1507,7566,40720,1548,3,1189,'App\\Models\\Receipt',1189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-18','2024-01-18',11200.00,NULL,NULL,1,'2024-02-09 21:17:14','2024-02-09 21:17:14',NULL),(1508,7566,40720,1548,3,1190,'App\\Models\\Receipt',1190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-18','2024-01-18',11200.00,NULL,NULL,1,'2024-02-09 21:17:14','2024-02-09 21:17:14',NULL),(1509,7566,40720,1548,3,1191,'App\\Models\\Receipt',1191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-18','2024-01-18',9000.00,NULL,NULL,1,'2024-02-09 21:17:14','2024-02-09 21:17:14',NULL),(1510,7566,40720,1548,3,1192,'App\\Models\\Receipt',1192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-18','2024-01-18',34353.12,NULL,NULL,1,'2024-02-09 21:17:14','2024-02-09 21:17:40','2024-02-09 21:17:40'),(1511,7566,40720,1548,3,1193,'App\\Models\\Receipt',1193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-20','2024-01-20',29100.00,NULL,NULL,1,'2024-02-09 21:17:14','2024-02-09 21:17:14',NULL),(1512,7566,40720,1548,3,1194,'App\\Models\\Receipt',1194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-21','2024-01-21',27412.05,NULL,NULL,1,'2024-02-09 21:17:14','2024-02-10 17:26:56','2024-02-10 17:26:56'),(1513,7566,40720,1548,3,1195,'App\\Models\\Receipt',1195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-26','2024-01-26',4800.00,NULL,NULL,1,'2024-02-09 21:17:15','2024-02-09 21:17:15',NULL),(1514,7566,40720,1548,3,1196,'App\\Models\\Receipt',1196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',27039.20,NULL,NULL,1,'2024-02-09 21:17:15','2024-02-10 17:30:38','2024-02-10 17:30:38'),(1515,7566,40720,1548,3,1197,'App\\Models\\Receipt',1197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',28000.00,NULL,NULL,1,'2024-02-09 21:17:15','2024-02-09 21:17:15',NULL),(1516,7566,40720,1548,7,1198,'App\\Models\\Receipt',1198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-29','2024-01-29',9172.05,NULL,NULL,1,'2024-02-09 21:22:06','2024-02-09 21:22:06',NULL),(1517,7566,40720,1548,7,1199,'App\\Models\\Receipt',1199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-25','2024-01-25',2301.11,NULL,NULL,1,'2024-02-09 21:22:06','2024-02-09 21:22:06',NULL),(1518,7566,40720,1548,7,1200,'App\\Models\\Receipt',1200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-23','2024-01-23',10396.10,NULL,NULL,1,'2024-02-09 21:22:06','2024-02-09 21:22:06',NULL),(1519,7566,40720,1548,7,1201,'App\\Models\\Receipt',1201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-19','2024-01-19',61.28,NULL,NULL,1,'2024-02-09 21:22:06','2024-02-09 21:22:06',NULL),(1520,7566,40720,1548,7,1202,'App\\Models\\Receipt',1202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-18','2024-01-18',6256.61,NULL,NULL,1,'2024-02-09 21:22:06','2024-02-09 21:22:06',NULL),(1521,7566,40720,1548,7,1203,'App\\Models\\Receipt',1203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-17','2024-01-17',2160.94,NULL,NULL,1,'2024-02-09 21:22:06','2024-02-09 21:22:06',NULL),(1522,7566,40720,1548,7,1204,'App\\Models\\Receipt',1204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-16','2024-01-16',170.79,NULL,NULL,1,'2024-02-09 21:22:06','2024-02-09 21:22:06',NULL),(1523,7566,40720,1548,7,1205,'App\\Models\\Receipt',1205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-12','2024-01-12',697.81,NULL,NULL,1,'2024-02-09 21:22:06','2024-02-09 21:22:06',NULL);
INSERT INTO `balance_libro` VALUES (1524,7566,40720,1548,7,1206,'App\\Models\\Receipt',1206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-11','2024-01-11',11029.17,NULL,NULL,1,'2024-02-09 21:22:07','2024-02-09 21:22:07',NULL),(1525,7566,40720,1548,7,1207,'App\\Models\\Receipt',1207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-09','2024-01-09',22471.90,NULL,NULL,1,'2024-02-09 21:22:07','2024-02-09 21:22:07',NULL),(1526,7566,40720,1548,7,1208,'App\\Models\\Receipt',1208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-08','2024-01-08',483.65,NULL,NULL,1,'2024-02-09 21:22:07','2024-02-09 21:22:07',NULL),(1527,7566,40720,1548,7,1209,'App\\Models\\Receipt',1209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-04','2024-01-04',8331.40,NULL,NULL,1,'2024-02-09 21:22:07','2024-02-09 21:22:07',NULL),(1528,7566,40720,1548,7,1210,'App\\Models\\Receipt',1210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',2705.78,NULL,NULL,1,'2024-02-09 21:22:07','2024-02-09 21:22:07',NULL),(1529,7566,40720,1548,7,1211,'App\\Models\\Receipt',1211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',504.29,NULL,NULL,1,'2024-02-09 21:22:07','2024-02-09 21:22:07',NULL),(1530,7566,40720,1548,7,1212,'App\\Models\\Receipt',1212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-02','2024-01-02',7573.76,NULL,NULL,1,'2024-02-09 21:22:07','2024-02-09 21:22:07',NULL),(1531,7566,40720,1548,3,1176,'App\\Models\\Receipt',1176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',19754.63,NULL,NULL,1,'2024-02-10 17:16:18','2024-02-10 17:16:18',NULL),(1532,7566,40720,1548,3,1180,'App\\Models\\Receipt',1180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-10','2024-01-10',48415.88,NULL,NULL,1,'2024-02-10 17:19:31','2024-02-10 17:19:31',NULL),(1533,7566,40720,1548,3,1188,'App\\Models\\Receipt',1188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-17','2024-01-17',46013.43,NULL,NULL,1,'2024-02-10 17:23:03','2024-02-10 17:23:03',NULL),(1534,7566,40720,1548,3,1187,'App\\Models\\Receipt',1187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-17','2024-01-17',6788.28,NULL,NULL,1,'2024-02-10 17:24:30','2024-02-10 17:24:30',NULL),(1535,7566,40720,1548,3,1213,'App\\Models\\Receipt',1213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',21255.10,NULL,NULL,1,'2024-02-10 17:29:20','2024-02-10 17:29:20',NULL),(1536,7566,40720,1548,3,1196,'App\\Models\\Receipt',1196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',27039.20,NULL,NULL,1,'2024-02-10 17:30:38','2024-02-10 17:30:38',NULL),(1537,7566,40720,1548,3,1214,'App\\Models\\Receipt',1214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-14','2024-01-14',9950.00,NULL,NULL,1,'2024-02-10 17:32:28','2024-02-10 17:32:28',NULL),(1538,7566,40720,1548,3,1215,'App\\Models\\Receipt',1215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-11','2024-01-11',102850.00,NULL,NULL,1,'2024-02-10 17:33:09','2024-02-10 17:33:09',NULL),(1539,7566,40720,1548,3,1216,'App\\Models\\Receipt',1216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-15','2024-01-15',33272.25,NULL,NULL,1,'2024-02-10 17:34:40','2024-02-10 17:34:40',NULL),(1540,7566,40720,1548,3,1217,'App\\Models\\Receipt',1217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-31','2024-01-31',131890.00,NULL,NULL,1,'2024-02-10 17:36:34','2024-02-10 17:36:34',NULL),(1541,7566,40720,1548,3,1218,'App\\Models\\Receipt',1218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-26','2024-01-26',35001.05,NULL,NULL,1,'2024-02-10 17:37:19','2024-02-10 17:37:19',NULL),(1542,7566,40720,1548,3,1219,'App\\Models\\Receipt',1219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-13','2024-01-13',19200.00,NULL,NULL,1,'2024-02-10 17:38:01','2024-02-10 17:38:01',NULL),(1543,7566,40720,1548,3,1220,'App\\Models\\Receipt',1220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-05','2024-01-05',26500.00,NULL,NULL,1,'2024-02-10 17:38:33','2024-02-10 17:38:33',NULL),(1544,7566,40720,1548,3,1221,'App\\Models\\Receipt',1221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-03','2024-01-03',4400.00,NULL,NULL,1,'2024-02-10 17:39:10','2024-02-10 17:39:10',NULL);
INSERT INTO `balance_libro` VALUES (1545,7566,40720,1549,2,1222,'App\\Models\\Receipt',1222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',7970.44,NULL,NULL,1,'2024-03-16 11:37:14','2024-03-16 11:37:14',NULL),(1546,7566,40720,1549,2,1223,'App\\Models\\Receipt',1223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',284988.99,NULL,NULL,1,'2024-03-16 11:37:14','2024-03-16 11:37:14',NULL),(1547,7566,40720,1549,2,1224,'App\\Models\\Receipt',1224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',3632.09,NULL,NULL,1,'2024-03-16 11:37:14','2024-03-16 11:37:14',NULL),(1548,7566,40720,1549,2,1225,'App\\Models\\Receipt',1225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',603648.50,NULL,NULL,1,'2024-03-16 11:37:14','2024-03-16 11:37:14',NULL),(1549,7566,40720,1549,2,1226,'App\\Models\\Receipt',1226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-03','2024-02-03',173008.33,NULL,NULL,1,'2024-03-16 11:37:14','2024-03-16 11:37:14',NULL),(1550,7566,40720,1549,2,1227,'App\\Models\\Receipt',1227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-05','2024-02-05',10040.79,NULL,NULL,1,'2024-03-16 11:37:14','2024-03-16 11:37:14',NULL),(1551,7566,40720,1549,2,1228,'App\\Models\\Receipt',1228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-05','2024-02-05',10146.54,NULL,NULL,1,'2024-03-16 11:37:14','2024-03-16 11:37:14',NULL),(1552,7566,40720,1549,2,1229,'App\\Models\\Receipt',1229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-16','2024-02-16',752997.87,NULL,NULL,1,'2024-03-16 11:37:14','2024-03-16 11:37:14',NULL),(1553,7566,40720,1549,2,1230,'App\\Models\\Receipt',1230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-26','2024-02-26',13206.22,NULL,NULL,1,'2024-03-16 11:37:14','2024-03-16 11:37:14',NULL),(1554,7566,40720,1549,3,1231,'App\\Models\\Receipt',1231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',6500.00,NULL,NULL,1,'2024-03-16 11:37:30','2024-03-16 11:37:30',NULL),(1555,7566,40720,1549,3,1232,'App\\Models\\Receipt',1232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',76845.47,NULL,NULL,1,'2024-03-16 11:37:30','2024-03-16 11:47:46','2024-03-16 11:47:46'),(1556,7566,40720,1549,3,1233,'App\\Models\\Receipt',1233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-03','2024-02-03',23569.31,NULL,NULL,1,'2024-03-16 11:37:31','2024-03-16 11:59:50','2024-03-16 11:59:50'),(1557,7566,40720,1549,3,1234,'App\\Models\\Receipt',1234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-03','2024-02-03',2499.10,NULL,NULL,1,'2024-03-16 11:37:31','2024-03-18 17:07:17','2024-03-18 17:07:17'),(1558,7566,40720,1549,3,1235,'App\\Models\\Receipt',1235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-05','2024-02-05',14335.45,NULL,NULL,1,'2024-03-16 11:37:31','2024-03-16 12:04:06','2024-03-16 12:04:06'),(1559,7566,40720,1549,3,1236,'App\\Models\\Receipt',1236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-05','2024-02-05',8100.00,NULL,NULL,1,'2024-03-16 11:37:31','2024-03-16 11:37:31',NULL),(1560,7566,40720,1549,3,1237,'App\\Models\\Receipt',1237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-05','2024-02-05',11250.00,NULL,NULL,1,'2024-03-16 11:37:31','2024-03-16 11:37:31',NULL),(1561,7566,40720,1549,3,1238,'App\\Models\\Receipt',1238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-06','2024-02-06',4500.00,NULL,NULL,1,'2024-03-16 11:37:31','2024-03-16 11:37:31',NULL),(1562,7566,40720,1549,3,1239,'App\\Models\\Receipt',1239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-07','2024-02-07',10860.00,NULL,NULL,1,'2024-03-16 11:37:31','2024-03-16 11:37:31',NULL),(1563,7566,40720,1549,3,1240,'App\\Models\\Receipt',1240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-08','2024-02-08',12450.00,NULL,NULL,1,'2024-03-16 11:37:31','2024-03-16 11:37:31',NULL),(1564,7566,40720,1549,3,1241,'App\\Models\\Receipt',1241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-09','2024-02-09',5600.00,NULL,NULL,1,'2024-03-16 11:37:31','2024-03-16 11:37:31',NULL);
INSERT INTO `balance_libro` VALUES (1565,7566,40720,1549,3,1242,'App\\Models\\Receipt',1242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-10','2024-02-10',7000.00,NULL,NULL,1,'2024-03-16 11:37:31','2024-03-16 11:37:31',NULL),(1566,7566,40720,1549,3,1243,'App\\Models\\Receipt',1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-13','2024-02-13',18880.91,NULL,NULL,1,'2024-03-16 11:37:31','2024-03-16 12:13:20','2024-03-16 12:13:20'),(1567,7566,40720,1549,3,1244,'App\\Models\\Receipt',1244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',10000.00,NULL,NULL,1,'2024-03-16 11:37:31','2024-03-16 11:37:31',NULL),(1568,7566,40720,1549,3,1245,'App\\Models\\Receipt',1245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',34262.87,NULL,NULL,1,'2024-03-16 11:37:31','2024-03-16 12:21:09','2024-03-16 12:21:09'),(1569,7566,40720,1549,3,1246,'App\\Models\\Receipt',1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-27','2024-02-27',41200.00,NULL,NULL,1,'2024-03-16 11:37:31','2024-03-16 12:26:59','2024-03-16 12:26:59'),(1570,7566,40720,1549,3,1247,'App\\Models\\Receipt',1247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-27','2024-02-27',23500.00,NULL,NULL,1,'2024-03-16 11:37:31','2024-03-16 12:28:33','2024-03-16 12:28:33'),(1571,7566,40720,1549,3,1248,'App\\Models\\Receipt',1248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',22739.10,NULL,NULL,1,'2024-03-16 11:37:32','2024-03-16 12:07:04','2024-03-16 12:07:04'),(1572,7566,40720,1549,7,1249,'App\\Models\\Receipt',1249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-29','2024-02-29',1107.72,NULL,NULL,1,'2024-03-16 11:38:03','2024-03-16 11:38:03',NULL),(1573,7566,40720,1549,7,1250,'App\\Models\\Receipt',1250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',122.59,NULL,NULL,1,'2024-03-16 11:38:03','2024-03-16 11:38:03',NULL),(1574,7566,40720,1549,7,1251,'App\\Models\\Receipt',1251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-27','2024-02-27',1833.59,NULL,NULL,1,'2024-03-16 11:38:03','2024-03-16 11:38:03',NULL),(1575,7566,40720,1549,7,1252,'App\\Models\\Receipt',1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-27','2024-02-27',1492.87,NULL,NULL,1,'2024-03-16 11:38:03','2024-03-16 11:38:03',NULL),(1576,7566,40720,1549,7,1253,'App\\Models\\Receipt',1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-26','2024-02-26',9362.07,NULL,NULL,1,'2024-03-16 11:38:03','2024-03-16 11:38:03',NULL),(1577,7566,40720,1549,7,1254,'App\\Models\\Receipt',1254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-22','2024-02-22',2372.20,NULL,NULL,1,'2024-03-16 11:38:03','2024-03-16 11:38:03',NULL),(1578,7566,40720,1549,7,1255,'App\\Models\\Receipt',1255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',1337.95,NULL,NULL,1,'2024-03-16 11:38:04','2024-03-16 11:38:04',NULL),(1579,7566,40720,1549,7,1256,'App\\Models\\Receipt',1256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-20','2024-02-20',13814.77,NULL,NULL,1,'2024-03-16 11:38:04','2024-03-16 11:38:04',NULL),(1580,7566,40720,1549,7,1257,'App\\Models\\Receipt',1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-16','2024-02-16',890.36,NULL,NULL,1,'2024-03-16 11:38:04','2024-03-16 11:38:04',NULL),(1581,7566,40720,1549,7,1258,'App\\Models\\Receipt',1258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-15','2024-02-15',1102.79,NULL,NULL,1,'2024-03-16 11:38:04','2024-03-16 11:38:04',NULL),(1582,7566,40720,1549,7,1259,'App\\Models\\Receipt',1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-14','2024-02-14',12876.08,NULL,NULL,1,'2024-03-16 11:38:04','2024-03-16 11:38:04',NULL),(1583,7566,40720,1549,7,1260,'App\\Models\\Receipt',1260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-08','2024-02-08',3190.83,NULL,NULL,1,'2024-03-16 11:38:04','2024-03-16 11:38:04',NULL),(1584,7566,40720,1549,7,1261,'App\\Models\\Receipt',1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-07','2024-02-07',33131.92,NULL,NULL,1,'2024-03-16 11:38:04','2024-03-16 11:38:04',NULL);
INSERT INTO `balance_libro` VALUES (1585,7566,40720,1549,7,1262,'App\\Models\\Receipt',1262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-06','2024-02-06',7461.02,NULL,NULL,1,'2024-03-16 11:38:04','2024-03-16 11:38:04',NULL),(1586,7566,40720,1549,7,1263,'App\\Models\\Receipt',1263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-05','2024-02-05',1610.93,NULL,NULL,1,'2024-03-16 11:38:04','2024-03-16 11:38:04',NULL),(1587,7566,40720,1549,7,1264,'App\\Models\\Receipt',1264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-05','2024-02-05',772.40,NULL,NULL,1,'2024-03-16 11:38:04','2024-03-16 11:38:04',NULL),(1588,7566,40720,1549,7,1265,'App\\Models\\Receipt',1265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-02','2024-02-02',14204.58,NULL,NULL,1,'2024-03-16 11:38:04','2024-03-16 11:38:04',NULL),(1589,7566,40720,1549,7,1266,'App\\Models\\Receipt',1266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-01','2024-02-01',893.82,NULL,NULL,1,'2024-03-16 11:38:04','2024-03-16 11:38:04',NULL),(1590,7566,40720,1549,3,1233,'App\\Models\\Receipt',1233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-03','2024-02-03',23569.31,NULL,NULL,1,'2024-03-16 11:59:50','2024-03-16 11:59:50',NULL),(1591,7566,40720,1549,3,1235,'App\\Models\\Receipt',1235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-05','2024-02-05',14335.46,NULL,NULL,1,'2024-03-16 12:04:06','2024-03-16 12:04:06',NULL),(1592,7566,40720,1549,3,1248,'App\\Models\\Receipt',1248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-28','2024-02-28',22739.10,NULL,NULL,1,'2024-03-16 12:07:04','2024-03-16 12:07:04',NULL),(1593,7566,40720,1549,3,1243,'App\\Models\\Receipt',1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-13','2024-02-13',18880.91,NULL,NULL,1,'2024-03-16 12:13:20','2024-03-16 12:13:20',NULL),(1594,7566,40720,1550,3,1245,'App\\Models\\Receipt',1245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',34262.87,NULL,NULL,1,'2024-03-16 12:21:09','2024-03-16 12:22:11','2024-03-16 12:22:11'),(1595,7566,40720,1549,3,1267,'App\\Models\\Receipt',1267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-01-21','2024-01-21',27412.05,NULL,NULL,1,'2024-03-16 12:23:49','2024-03-16 12:23:49',NULL),(1596,7566,40720,1549,3,1246,'App\\Models\\Receipt',1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-27','2024-02-27',41200.00,NULL,NULL,1,'2024-03-16 12:26:59','2024-03-16 12:26:59',NULL),(1597,7566,40720,1549,3,1247,'App\\Models\\Receipt',1247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-27','2024-02-27',23500.00,NULL,NULL,1,'2024-03-16 12:28:33','2024-03-16 12:28:33',NULL),(1598,7566,40720,1549,3,1268,'App\\Models\\Receipt',1268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-19','2024-02-19',104060.00,NULL,NULL,1,'2024-03-16 12:30:19','2024-03-16 12:33:15','2024-03-16 12:33:15'),(1599,7566,40720,1549,3,1269,'App\\Models\\Receipt',1269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-16','2024-02-16',127050.00,NULL,NULL,1,'2024-03-16 12:32:43','2024-03-18 17:39:03','2024-03-18 17:39:03'),(1600,7566,40720,1549,3,1268,'App\\Models\\Receipt',1268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-19','2024-02-19',104060.00,NULL,NULL,1,'2024-03-16 12:33:15','2024-03-16 12:33:15',NULL),(1601,7566,40720,1549,3,1270,'App\\Models\\Receipt',1270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-03','2024-02-03',11650.00,NULL,NULL,1,'2024-03-16 12:42:32','2024-03-16 12:42:32',NULL),(1602,7566,40720,1549,3,1271,'App\\Models\\Receipt',1271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-10','2024-02-10',32270.49,NULL,NULL,1,'2024-03-16 12:43:56','2024-03-16 12:43:56',NULL),(1603,7566,40720,1549,3,1272,'App\\Models\\Receipt',1272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-10','2024-02-10',13590.00,NULL,NULL,1,'2024-03-16 12:45:01','2024-03-16 12:45:01',NULL),(1604,7566,40720,1549,3,1234,'App\\Models\\Receipt',1234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-03','2024-02-03',2561.06,NULL,NULL,1,'2024-03-18 17:07:17','2024-03-18 17:07:39','2024-03-18 17:07:39');
INSERT INTO `balance_libro` VALUES (1605,7566,40720,1549,3,1234,'App\\Models\\Receipt',1234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-03','2024-02-03',2561.06,NULL,NULL,1,'2024-03-18 17:07:39','2024-03-18 17:07:39',NULL),(1606,7566,40720,1549,3,1269,'App\\Models\\Receipt',1269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-16','2024-02-16',127050.00,NULL,NULL,1,'2024-03-18 17:39:03','2024-03-18 17:39:03',NULL),(1607,7566,40720,1550,2,1273,'App\\Models\\Receipt',1273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',479412.82,NULL,NULL,1,'2024-04-17 21:30:10','2024-04-17 21:30:10',NULL),(1608,7566,40720,1550,2,1274,'App\\Models\\Receipt',1274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',3632.09,NULL,NULL,1,'2024-04-17 21:30:10','2024-04-17 21:30:10',NULL),(1609,7566,40720,1550,2,1275,'App\\Models\\Receipt',1275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',750012.50,NULL,NULL,1,'2024-04-17 21:30:10','2024-04-17 21:30:10',NULL),(1610,7566,40720,1550,2,1276,'App\\Models\\Receipt',1276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-12','2024-03-12',16529.14,NULL,NULL,1,'2024-04-17 21:30:11','2024-04-17 21:30:11',NULL),(1611,7566,40720,1550,2,1277,'App\\Models\\Receipt',1277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-12','2024-03-12',14176.05,NULL,NULL,1,'2024-04-17 21:30:11','2024-04-17 21:30:11',NULL),(1612,7566,40720,1550,2,1278,'App\\Models\\Receipt',1278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-18','2024-03-18',949524.00,NULL,NULL,1,'2024-04-17 21:30:11','2024-04-17 21:30:11',NULL),(1613,7566,40720,1550,2,1279,'App\\Models\\Receipt',1279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-26','2024-03-26',14038.23,NULL,NULL,1,'2024-04-17 21:30:11','2024-04-17 21:30:11',NULL),(1614,7566,40720,1550,3,1280,'App\\Models\\Receipt',1280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',6500.00,NULL,NULL,1,'2024-04-17 21:30:41','2024-04-17 21:30:41',NULL),(1615,7566,40720,1550,3,1281,'App\\Models\\Receipt',1281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-01','2024-03-01',76845.47,NULL,NULL,1,'2024-04-17 21:30:41','2024-04-18 18:09:09','2024-04-18 18:09:09'),(1616,7566,40720,1550,3,1282,'App\\Models\\Receipt',1282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-03','2024-03-03',38419.89,NULL,NULL,1,'2024-04-17 21:30:41','2024-04-18 18:11:10','2024-04-18 18:11:10'),(1617,7566,40720,1550,3,1283,'App\\Models\\Receipt',1283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',2499.10,NULL,NULL,1,'2024-04-17 21:30:41','2024-04-22 19:05:24','2024-04-22 19:05:24'),(1618,7566,40720,1550,3,1284,'App\\Models\\Receipt',1284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-07','2024-03-07',51900.00,NULL,NULL,1,'2024-04-17 21:30:41','2024-04-18 18:15:11','2024-04-18 18:15:11'),(1619,7566,40720,1550,3,1285,'App\\Models\\Receipt',1285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-07','2024-03-07',187824.02,NULL,NULL,1,'2024-04-17 21:30:41','2024-04-17 21:30:41',NULL),(1620,7566,40720,1550,3,1286,'App\\Models\\Receipt',1286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-08','2024-03-08',12000.00,NULL,NULL,1,'2024-04-17 21:30:41','2024-04-17 21:30:41',NULL),(1621,7566,40720,1550,3,1287,'App\\Models\\Receipt',1287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-08','2024-03-08',190000.00,NULL,NULL,1,'2024-04-17 21:30:41','2024-04-18 18:18:23','2024-04-18 18:18:23'),(1622,7566,40720,1550,3,1288,'App\\Models\\Receipt',1288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-09','2024-03-09',40354.46,NULL,NULL,1,'2024-04-17 21:30:41','2024-04-18 18:19:43','2024-04-18 18:19:43'),(1623,7566,40720,1550,3,1289,'App\\Models\\Receipt',1289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-09','2024-03-09',6500.00,NULL,NULL,1,'2024-04-17 21:30:41','2024-04-17 21:30:41',NULL),(1624,7566,40720,1550,3,1290,'App\\Models\\Receipt',1290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-11','2024-03-11',81700.00,NULL,NULL,1,'2024-04-17 21:30:41','2024-04-17 21:30:41',NULL);
INSERT INTO `balance_libro` VALUES (1625,7566,40720,1550,3,1291,'App\\Models\\Receipt',1291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-12','2024-03-12',6500.00,NULL,NULL,1,'2024-04-17 21:30:41','2024-04-17 21:30:41',NULL),(1626,7566,40720,1550,3,1292,'App\\Models\\Receipt',1292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-14','2024-03-14',6500.00,NULL,NULL,1,'2024-04-17 21:30:41','2024-04-17 21:30:41',NULL),(1627,7566,40720,1550,3,1293,'App\\Models\\Receipt',1293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-14','2024-03-14',7400.00,NULL,NULL,1,'2024-04-17 21:30:41','2024-04-17 21:30:41',NULL),(1628,7566,40720,1550,3,1294,'App\\Models\\Receipt',1294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-16','2024-03-16',44557.42,NULL,NULL,1,'2024-04-17 21:30:42','2024-04-18 18:28:19','2024-04-18 18:28:19'),(1629,7566,40720,1550,3,1295,'App\\Models\\Receipt',1295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-18','2024-03-18',13000.00,NULL,NULL,1,'2024-04-17 21:30:42','2024-04-17 21:30:42',NULL),(1630,7566,40720,1550,3,1296,'App\\Models\\Receipt',1296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-20','2024-03-20',6500.00,NULL,NULL,1,'2024-04-17 21:30:42','2024-04-17 21:30:42',NULL),(1631,7566,40720,1550,3,1297,'App\\Models\\Receipt',1297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-20','2024-03-20',5222.66,NULL,NULL,1,'2024-04-17 21:30:42','2024-04-18 18:21:10','2024-04-18 18:21:10'),(1632,7566,40720,1550,3,1298,'App\\Models\\Receipt',1298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-21','2024-03-21',39409.76,NULL,NULL,1,'2024-04-17 21:30:42','2024-04-18 18:30:34','2024-04-18 18:30:34'),(1633,7566,40720,1550,3,1299,'App\\Models\\Receipt',1299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-21','2024-03-21',6500.00,NULL,NULL,1,'2024-04-17 21:30:42','2024-04-17 21:30:42',NULL),(1634,7566,40720,1550,3,1300,'App\\Models\\Receipt',1300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-21','2024-03-21',6271.74,NULL,NULL,1,'2024-04-17 21:30:42','2024-04-22 19:06:57','2024-04-22 19:06:57'),(1635,7566,40720,1550,3,1301,'App\\Models\\Receipt',1301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-22','2024-03-22',27398.79,NULL,NULL,1,'2024-04-17 21:30:42','2024-04-17 21:30:42',NULL),(1636,7566,40720,1550,3,1302,'App\\Models\\Receipt',1302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-22','2024-03-22',6500.00,NULL,NULL,1,'2024-04-17 21:30:42','2024-04-17 21:30:42',NULL),(1637,7566,40720,1550,3,1303,'App\\Models\\Receipt',1303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-27','2024-03-27',9300.00,NULL,NULL,1,'2024-04-17 21:30:42','2024-04-17 21:30:42',NULL),(1638,7566,40720,1550,3,1304,'App\\Models\\Receipt',1304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-28','2024-03-28',37428.54,NULL,NULL,1,'2024-04-17 21:30:42','2024-04-22 18:05:15','2024-04-22 18:05:15'),(1639,7566,40720,1550,3,1305,'App\\Models\\Receipt',1305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-30','2024-03-30',2499.10,NULL,NULL,1,'2024-04-17 21:30:42','2024-04-17 21:30:42',NULL),(1640,7566,40720,1550,7,1306,'App\\Models\\Receipt',1306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-30','2024-03-30',1055.04,NULL,NULL,1,'2024-04-18 18:04:12','2024-04-18 18:04:12',NULL),(1641,7566,40720,1550,7,1307,'App\\Models\\Receipt',1307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-27','2024-03-27',1949.11,NULL,NULL,1,'2024-04-18 18:04:12','2024-04-18 18:04:12',NULL),(1642,7566,40720,1550,7,1308,'App\\Models\\Receipt',1308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-26','2024-03-26',5799.36,NULL,NULL,1,'2024-04-18 18:04:12','2024-04-18 18:04:12',NULL),(1643,7566,40720,1550,7,1309,'App\\Models\\Receipt',1309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',4563.92,NULL,NULL,1,'2024-04-18 18:04:12','2024-04-18 18:04:12',NULL),(1644,7566,40720,1550,7,1310,'App\\Models\\Receipt',1310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-21','2024-03-21',3245.73,NULL,NULL,1,'2024-04-18 18:04:12','2024-04-18 18:04:12',NULL);
INSERT INTO `balance_libro` VALUES (1645,7566,40720,1550,7,1311,'App\\Models\\Receipt',1311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-19','2024-03-19',699.34,NULL,NULL,1,'2024-04-18 18:04:12','2024-04-18 18:04:12',NULL),(1646,7566,40720,1550,7,1312,'App\\Models\\Receipt',1312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-18','2024-03-18',7079.13,NULL,NULL,1,'2024-04-18 18:04:13','2024-04-18 18:04:13',NULL),(1647,7566,40720,1550,7,1313,'App\\Models\\Receipt',1313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',245.94,NULL,NULL,1,'2024-04-18 18:04:13','2024-04-18 18:04:13',NULL),(1648,7566,40720,1550,7,1314,'App\\Models\\Receipt',1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-13','2024-03-13',2069.03,NULL,NULL,1,'2024-04-18 18:04:13','2024-04-18 18:04:13',NULL),(1649,7566,40720,1550,7,1315,'App\\Models\\Receipt',1315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-11','2024-03-11',2194.99,NULL,NULL,1,'2024-04-18 18:04:13','2024-04-18 18:04:13',NULL),(1650,7566,40720,1550,7,1316,'App\\Models\\Receipt',1316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-08','2024-03-08',32486.71,NULL,NULL,1,'2024-04-18 18:04:13','2024-04-18 18:04:13',NULL),(1651,7566,40720,1550,7,1317,'App\\Models\\Receipt',1317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-07','2024-03-07',3345.49,NULL,NULL,1,'2024-04-18 18:04:13','2024-04-18 18:04:13',NULL),(1652,7566,40720,1550,7,1318,'App\\Models\\Receipt',1318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',1755.85,NULL,NULL,1,'2024-04-18 18:04:13','2024-04-18 18:04:13',NULL),(1653,7566,40720,1550,7,1319,'App\\Models\\Receipt',1319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-05','2024-03-05',8281.01,NULL,NULL,1,'2024-04-18 18:04:13','2024-04-18 18:04:13',NULL),(1654,7566,40720,1550,7,1320,'App\\Models\\Receipt',1320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-04','2024-03-04',504.29,NULL,NULL,1,'2024-04-18 18:04:13','2024-04-18 18:04:13',NULL),(1655,7566,40720,1550,7,1321,'App\\Models\\Receipt',1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-04','2024-03-04',16813.11,NULL,NULL,1,'2024-04-18 18:04:13','2024-04-18 18:04:13',NULL),(1656,7566,40720,1550,3,1282,'App\\Models\\Receipt',1282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-03','2024-03-03',38419.89,NULL,NULL,1,'2024-04-18 18:11:10','2024-04-18 18:11:10',NULL),(1657,7566,40720,1550,3,1284,'App\\Models\\Receipt',1284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-07','2024-03-07',51900.00,NULL,NULL,1,'2024-04-18 18:15:11','2024-04-18 18:15:11',NULL),(1658,7566,40720,1550,3,1287,'App\\Models\\Receipt',1287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-08','2024-03-08',190000.00,NULL,NULL,1,'2024-04-18 18:18:23','2024-04-18 18:18:23',NULL),(1659,7566,40720,1550,3,1288,'App\\Models\\Receipt',1288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-09','2024-03-09',40354.46,NULL,NULL,1,'2024-04-18 18:19:43','2024-04-18 18:19:43',NULL),(1660,7566,40720,1550,3,1297,'App\\Models\\Receipt',1297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-20','2024-03-20',5222.66,NULL,NULL,1,'2024-04-18 18:21:10','2024-04-18 18:21:10',NULL),(1661,7566,40720,1550,3,1294,'App\\Models\\Receipt',1294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-16','2024-03-16',44557.42,NULL,NULL,1,'2024-04-18 18:28:19','2024-04-18 18:28:19',NULL),(1662,7566,40720,1550,3,1322,'App\\Models\\Receipt',1322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-02-21','2024-02-21',34262.87,NULL,NULL,1,'2024-04-18 18:32:22','2024-04-18 18:32:22',NULL),(1663,7566,40720,1550,3,1323,'App\\Models\\Receipt',1323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',100430.00,NULL,NULL,1,'2024-04-22 17:40:43','2024-04-22 18:26:31','2024-04-22 18:26:31'),(1664,7566,40720,1550,3,1324,'App\\Models\\Receipt',1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-13','2024-03-13',36303.02,NULL,NULL,1,'2024-04-22 17:41:54','2024-04-22 17:41:54',NULL),(1665,7566,40720,1550,3,1325,'App\\Models\\Receipt',1325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-25','2024-03-25',100430.00,NULL,NULL,1,'2024-04-22 17:44:40','2024-04-22 17:44:40',NULL);
INSERT INTO `balance_libro` VALUES (1666,7566,40720,1550,3,1326,'App\\Models\\Receipt',1326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-15','2024-03-15',131890.00,NULL,NULL,1,'2024-04-22 17:45:16','2024-04-22 17:45:16',NULL),(1667,7566,40720,1550,3,1327,'App\\Models\\Receipt',1327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-28','2024-03-28',21223.00,NULL,NULL,1,'2024-04-22 17:46:15','2024-04-22 17:46:15',NULL),(1668,7566,40720,1550,3,1328,'App\\Models\\Receipt',1328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-16','2024-03-16',8150.00,NULL,NULL,1,'2024-04-22 17:47:33','2024-04-22 17:53:17','2024-04-22 17:53:17'),(1669,7566,40720,1550,3,1329,'App\\Models\\Receipt',1329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-23','2024-03-23',9870.00,NULL,NULL,1,'2024-04-22 17:48:16','2024-04-22 17:48:16',NULL),(1670,7566,40720,1550,3,1330,'App\\Models\\Receipt',1330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-22','2024-03-22',7846.35,NULL,NULL,1,'2024-04-22 17:49:27','2024-04-22 17:49:27',NULL),(1671,7566,40720,1550,3,1331,'App\\Models\\Receipt',1331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-31','2024-03-31',23469.95,NULL,NULL,1,'2024-04-22 17:50:07','2024-04-22 17:50:07',NULL),(1672,7566,40720,1550,3,1332,'App\\Models\\Receipt',1332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-11','2024-03-11',6960.00,NULL,NULL,1,'2024-04-22 17:52:35','2024-04-22 17:52:35',NULL),(1673,7566,40720,1550,3,1328,'App\\Models\\Receipt',1328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-16','2024-03-16',8150.00,NULL,NULL,1,'2024-04-22 17:53:17','2024-04-22 17:53:17',NULL),(1674,7566,40720,1550,3,1283,'App\\Models\\Receipt',1283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-06','2024-03-06',2561.06,NULL,NULL,1,'2024-04-22 19:05:24','2024-04-22 19:05:24',NULL),(1675,7566,40720,1550,3,1300,'App\\Models\\Receipt',1300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-21','2024-03-21',6120.00,NULL,NULL,1,'2024-04-22 19:06:57','2024-04-22 19:07:31','2024-04-22 19:07:31'),(1676,7566,40720,1550,3,1300,'App\\Models\\Receipt',1300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-21','2024-03-21',6271.74,NULL,NULL,1,'2024-04-22 19:07:31','2024-04-22 19:07:31',NULL),(1677,7566,40720,1551,2,1333,'App\\Models\\Receipt',1333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',656520.05,NULL,NULL,1,'2024-05-20 16:31:55','2024-05-20 16:31:55',NULL),(1678,7566,40720,1551,2,1334,'App\\Models\\Receipt',1334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-03','2024-04-03',3632.11,NULL,NULL,1,'2024-05-20 16:31:55','2024-05-20 16:31:55',NULL),(1679,7566,40720,1551,2,1335,'App\\Models\\Receipt',1335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-03','2024-04-03',18428.57,NULL,NULL,1,'2024-05-20 16:31:55','2024-05-20 16:31:55',NULL),(1680,7566,40720,1551,2,1336,'App\\Models\\Receipt',1336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-03','2024-04-03',645582.92,NULL,NULL,1,'2024-05-20 16:31:55','2024-05-20 16:31:55',NULL),(1681,7566,40720,1551,2,1337,'App\\Models\\Receipt',1337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-16','2024-04-16',998224.00,NULL,NULL,1,'2024-05-20 16:31:55','2024-05-20 16:31:55',NULL),(1682,7566,40720,1551,2,1338,'App\\Models\\Receipt',1338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',17670.34,NULL,NULL,1,'2024-05-20 16:31:56','2024-05-20 16:31:56',NULL),(1683,7566,40720,1551,7,1339,'App\\Models\\Receipt',1339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-29','2024-04-29',7507.90,NULL,NULL,1,'2024-05-20 16:38:33','2024-05-20 16:38:33',NULL),(1684,7566,40720,1551,7,1340,'App\\Models\\Receipt',1340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-25','2024-04-25',1609.10,NULL,NULL,1,'2024-05-20 16:38:33','2024-05-20 16:38:33',NULL),(1685,7566,40720,1551,7,1341,'App\\Models\\Receipt',1341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-24','2024-04-24',245.94,NULL,NULL,1,'2024-05-20 16:38:33','2024-05-20 16:38:33',NULL),(1686,7566,40720,1551,7,1342,'App\\Models\\Receipt',1342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-23','2024-04-23',3441.44,NULL,NULL,1,'2024-05-20 16:38:33','2024-05-20 16:38:33',NULL);
INSERT INTO `balance_libro` VALUES (1687,7566,40720,1551,7,1343,'App\\Models\\Receipt',1343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-19','2024-04-19',6676.58,NULL,NULL,1,'2024-05-20 16:38:33','2024-05-20 16:38:33',NULL),(1688,7566,40720,1551,7,1344,'App\\Models\\Receipt',1344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-18','2024-04-18',183.43,NULL,NULL,1,'2024-05-20 16:38:33','2024-05-20 16:38:33',NULL),(1689,7566,40720,1551,7,1345,'App\\Models\\Receipt',1345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-17','2024-04-17',7053.03,NULL,NULL,1,'2024-05-20 16:38:33','2024-05-20 16:38:33',NULL),(1690,7566,40720,1551,7,1346,'App\\Models\\Receipt',1346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-16','2024-04-16',1295.59,NULL,NULL,1,'2024-05-20 16:38:33','2024-05-20 16:38:33',NULL),(1691,7566,40720,1551,7,1347,'App\\Models\\Receipt',1347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-15','2024-04-15',556.27,NULL,NULL,1,'2024-05-20 16:38:33','2024-05-20 16:38:33',NULL),(1692,7566,40720,1551,7,1348,'App\\Models\\Receipt',1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-10','2024-04-10',35002.94,NULL,NULL,1,'2024-05-20 16:38:33','2024-05-20 16:38:33',NULL),(1693,7566,40720,1551,7,1349,'App\\Models\\Receipt',1349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-08','2024-04-08',1974.62,NULL,NULL,1,'2024-05-20 16:38:33','2024-05-20 16:38:33',NULL),(1694,7566,40720,1551,7,1350,'App\\Models\\Receipt',1350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-05','2024-04-05',1911.03,NULL,NULL,1,'2024-05-20 16:38:33','2024-05-20 16:38:33',NULL),(1695,7566,40720,1551,7,1351,'App\\Models\\Receipt',1351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',504.29,NULL,NULL,1,'2024-05-20 16:38:33','2024-05-20 16:38:33',NULL),(1696,7566,40720,1551,7,1352,'App\\Models\\Receipt',1352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',8140.55,NULL,NULL,1,'2024-05-20 16:38:33','2024-05-20 16:38:33',NULL),(1697,7566,40720,1551,7,1353,'App\\Models\\Receipt',1353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-03','2024-04-03',32142.94,NULL,NULL,1,'2024-05-20 16:38:33','2024-05-20 16:38:33',NULL),(1698,7566,40720,1551,3,1354,'App\\Models\\Receipt',1354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',7500.00,NULL,NULL,1,'2024-05-20 16:45:23','2024-05-20 16:46:20','2024-05-20 16:46:20'),(1699,7566,40720,1551,3,1355,'App\\Models\\Receipt',1355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',76845.47,NULL,NULL,1,'2024-05-20 16:45:23','2024-05-20 17:47:49','2024-05-20 17:47:49'),(1700,7566,40720,1551,3,1356,'App\\Models\\Receipt',1356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-03','2024-04-03',6000.00,NULL,NULL,1,'2024-05-20 16:45:23','2024-05-20 16:45:23',NULL),(1701,7566,40720,1551,3,1357,'App\\Models\\Receipt',1357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-03','2024-04-03',36537.26,NULL,NULL,1,'2024-05-20 16:45:23','2024-05-20 16:55:50','2024-05-20 16:55:50'),(1702,7566,40720,1551,3,1358,'App\\Models\\Receipt',1358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-04','2024-04-04',8000.00,NULL,NULL,1,'2024-05-20 16:45:23','2024-05-20 16:45:23',NULL),(1703,7566,40720,1551,3,1359,'App\\Models\\Receipt',1359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-11','2024-04-11',9200.00,NULL,NULL,1,'2024-05-20 16:45:23','2024-05-20 16:45:23',NULL),(1704,7566,40720,1551,3,1360,'App\\Models\\Receipt',1360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-12','2024-04-12',14250.00,NULL,NULL,1,'2024-05-20 16:45:24','2024-05-20 16:45:24',NULL),(1705,7566,40720,1551,3,1361,'App\\Models\\Receipt',1361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-13','2024-04-13',37512.20,NULL,NULL,1,'2024-05-20 16:45:24','2024-05-20 17:11:56','2024-05-20 17:11:56'),(1706,7566,40720,1551,3,1362,'App\\Models\\Receipt',1362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-13','2024-04-13',7500.00,NULL,NULL,1,'2024-05-20 16:45:24','2024-05-20 17:47:21','2024-05-20 17:47:21');
INSERT INTO `balance_libro` VALUES (1707,7566,40720,1551,3,1363,'App\\Models\\Receipt',1363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-15','2024-04-15',8700.00,NULL,NULL,1,'2024-05-20 16:45:24','2024-05-20 17:48:11','2024-05-20 17:48:11'),(1708,7566,40720,1551,3,1364,'App\\Models\\Receipt',1364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-16','2024-04-16',11854.33,NULL,NULL,1,'2024-05-20 16:45:24','2024-05-20 17:09:36','2024-05-20 17:09:36'),(1709,7566,40720,1551,3,1365,'App\\Models\\Receipt',1365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-16','2024-04-16',40850.00,NULL,NULL,1,'2024-05-20 16:45:24','2024-05-20 16:45:24',NULL),(1710,7566,40720,1551,3,1366,'App\\Models\\Receipt',1366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-17','2024-04-17',7500.00,NULL,NULL,1,'2024-05-20 16:45:24','2024-05-20 16:45:24',NULL),(1711,7566,40720,1551,3,1367,'App\\Models\\Receipt',1367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-20','2024-04-20',7500.00,NULL,NULL,1,'2024-05-20 16:45:24','2024-05-20 16:45:24',NULL),(1712,7566,40720,1551,3,1368,'App\\Models\\Receipt',1368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-21','2024-04-21',15412.85,NULL,NULL,1,'2024-05-20 16:45:24','2024-05-20 17:07:08','2024-05-20 17:07:08'),(1713,7566,40720,1551,3,1369,'App\\Models\\Receipt',1369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-21','2024-04-21',28052.18,NULL,NULL,1,'2024-05-20 16:45:24','2024-05-20 16:57:08','2024-05-20 16:57:08'),(1714,7566,40720,1551,3,1370,'App\\Models\\Receipt',1370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-22','2024-04-22',4500.00,NULL,NULL,1,'2024-05-20 16:45:24','2024-05-20 16:45:24',NULL),(1715,7566,40720,1551,3,1371,'App\\Models\\Receipt',1371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-22','2024-04-22',7500.00,NULL,NULL,1,'2024-05-20 16:45:24','2024-05-20 16:45:24',NULL),(1716,7566,40720,1551,3,1372,'App\\Models\\Receipt',1372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-24','2024-04-24',7500.00,NULL,NULL,1,'2024-05-20 16:45:24','2024-05-20 16:45:24',NULL),(1717,7566,40720,1551,3,1373,'App\\Models\\Receipt',1373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-25','2024-04-25',18750.00,NULL,NULL,1,'2024-05-20 16:45:24','2024-05-20 16:45:24',NULL),(1718,7566,40720,1551,3,1374,'App\\Models\\Receipt',1374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-26','2024-04-26',30500.00,NULL,NULL,1,'2024-05-20 16:45:24','2024-05-20 16:45:24',NULL),(1719,7566,40720,1551,3,1375,'App\\Models\\Receipt',1375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-27','2024-04-27',23416.39,NULL,NULL,1,'2024-05-20 16:45:25','2024-05-20 17:05:54','2024-05-20 17:05:54'),(1720,7566,40720,1551,3,1376,'App\\Models\\Receipt',1376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-27','2024-04-27',45490.00,NULL,NULL,1,'2024-05-20 16:45:25','2024-05-20 16:48:07','2024-05-20 16:48:07'),(1721,7566,40720,1551,3,1377,'App\\Models\\Receipt',1377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-28','2024-04-28',20990.00,NULL,NULL,1,'2024-05-20 16:45:25','2024-05-20 16:45:25',NULL),(1722,7566,40720,1551,3,1378,'App\\Models\\Receipt',1378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-29','2024-04-29',22500.00,NULL,NULL,1,'2024-05-20 16:45:25','2024-05-20 16:45:25',NULL),(1723,7566,40720,1551,3,1379,'App\\Models\\Receipt',1379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-29','2024-04-29',2499.10,NULL,NULL,1,'2024-05-20 16:45:25','2024-05-20 19:48:01','2024-05-20 19:48:01'),(1724,7566,40720,1551,3,1380,'App\\Models\\Receipt',1380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',8700.00,NULL,NULL,1,'2024-05-20 16:45:25','2024-05-20 16:45:25',NULL),(1725,7566,40720,1551,3,1381,'App\\Models\\Receipt',1381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',8700.00,NULL,NULL,1,'2024-05-20 16:45:25','2024-05-20 17:47:09','2024-05-20 17:47:09'),(1726,7566,40720,1551,3,1382,'App\\Models\\Receipt',1382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',8700.00,NULL,NULL,1,'2024-05-20 16:45:25','2024-05-20 17:46:55','2024-05-20 17:46:55');
INSERT INTO `balance_libro` VALUES (1727,7566,40720,1551,3,1354,'App\\Models\\Receipt',1354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-01','2024-04-01',7500.00,NULL,NULL,1,'2024-05-20 16:46:20','2024-05-20 16:46:20',NULL),(1728,7566,40720,1551,3,1376,'App\\Models\\Receipt',1376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-27','2024-04-27',45490.00,NULL,NULL,1,'2024-05-20 16:48:07','2024-05-20 19:23:46','2024-05-20 19:23:46'),(1729,7566,40720,1551,3,1357,'App\\Models\\Receipt',1357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-03','2024-04-03',36537.26,NULL,NULL,1,'2024-05-20 16:55:50','2024-05-20 16:55:50',NULL),(1730,7566,40720,1551,3,1383,'App\\Models\\Receipt',1383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-03-21','2024-03-21',39409.76,NULL,NULL,1,'2024-05-20 17:00:24','2024-05-20 17:00:24',NULL),(1731,7566,40720,1551,3,1375,'App\\Models\\Receipt',1375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-27','2024-04-27',23416.39,NULL,NULL,1,'2024-05-20 17:05:54','2024-05-20 17:05:54',NULL),(1732,7566,40720,1551,3,1368,'App\\Models\\Receipt',1368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-21','2024-04-21',15412.85,NULL,NULL,1,'2024-05-20 17:07:08','2024-05-20 17:07:08',NULL),(1733,7566,40720,1551,3,1364,'App\\Models\\Receipt',1364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-16','2024-04-16',11854.33,NULL,NULL,1,'2024-05-20 17:09:36','2024-05-20 17:09:36',NULL),(1734,7566,40720,1551,3,1361,'App\\Models\\Receipt',1361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-13','2024-04-13',37512.26,NULL,NULL,1,'2024-05-20 17:11:56','2024-05-20 17:11:56',NULL),(1735,7566,40720,1551,3,1384,'App\\Models\\Receipt',1384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-05','2024-04-05',10081.87,NULL,NULL,1,'2024-05-20 17:18:54','2024-05-20 17:18:54',NULL),(1736,7566,40720,1551,3,1385,'App\\Models\\Receipt',1385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-13','2024-04-13',37412.44,NULL,NULL,1,'2024-05-20 17:19:54','2024-05-20 17:19:54',NULL),(1737,7566,40720,1551,3,1386,'App\\Models\\Receipt',1386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-27','2024-04-27',6251.24,NULL,NULL,1,'2024-05-20 17:20:45','2024-05-20 17:20:45',NULL),(1738,7566,40720,1551,3,1387,'App\\Models\\Receipt',1387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-15','2024-04-15',31900.00,NULL,NULL,1,'2024-05-20 17:22:09','2024-05-20 17:22:09',NULL),(1739,7566,40720,1551,3,1388,'App\\Models\\Receipt',1388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-08','2024-04-08',8970.00,NULL,NULL,1,'2024-05-20 17:25:03','2024-05-20 17:25:03',NULL),(1740,7566,40720,1551,3,1389,'App\\Models\\Receipt',1389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-15','2024-04-15',6599.99,NULL,NULL,1,'2024-05-20 17:25:42','2024-05-20 17:25:42',NULL),(1741,7566,40720,1551,3,1390,'App\\Models\\Receipt',1390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-16','2024-04-16',3420.02,NULL,NULL,1,'2024-05-20 17:27:56','2024-05-20 17:27:56',NULL),(1742,7566,40720,1551,3,1391,'App\\Models\\Receipt',1391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-02','2024-04-02',3790.00,NULL,NULL,1,'2024-05-20 17:28:31','2024-05-20 17:28:31',NULL),(1743,7566,40720,1551,3,1392,'App\\Models\\Receipt',1392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-30','2024-04-30',163350.00,NULL,NULL,1,'2024-05-20 17:29:18','2024-05-20 17:29:18',NULL),(1744,7566,40720,1551,3,1393,'App\\Models\\Receipt',1393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-13','2024-04-13',68970.00,NULL,NULL,1,'2024-05-20 17:29:49','2024-05-20 20:06:05','2024-05-20 20:06:05'),(1745,7566,40720,1551,3,1394,'App\\Models\\Receipt',1394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-28','2024-04-28',6400.00,NULL,NULL,1,'2024-05-20 17:31:35','2024-05-20 17:31:35',NULL),(1746,7566,40720,1551,3,1395,'App\\Models\\Receipt',1395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-08','2024-04-08',22530.01,NULL,NULL,1,'2024-05-20 17:33:16','2024-05-20 17:33:16',NULL);
INSERT INTO `balance_libro` VALUES (1747,7566,40720,1551,3,1396,'App\\Models\\Receipt',1396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-09','2024-04-09',14499.97,NULL,NULL,1,'2024-05-20 17:34:57','2024-05-20 17:34:57',NULL),(1748,7566,40720,1551,3,1397,'App\\Models\\Receipt',1397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-18','2024-04-18',9720.01,NULL,NULL,1,'2024-05-20 17:35:53','2024-05-20 17:35:53',NULL),(1749,7566,40720,1551,3,1398,'App\\Models\\Receipt',1398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-06','2024-04-06',32300.01,NULL,NULL,1,'2024-05-20 17:37:11','2024-05-20 17:37:11',NULL),(1750,7566,40720,1551,3,1376,'App\\Models\\Receipt',1376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-27','2024-04-27',45490.00,NULL,NULL,1,'2024-05-20 19:23:46','2024-05-20 19:23:46',NULL),(1751,7566,40720,1551,3,1379,'App\\Models\\Receipt',1379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-29','2024-04-29',2561.06,NULL,NULL,1,'2024-05-20 19:48:01','2024-05-20 19:48:01',NULL),(1752,7566,40720,1551,3,1399,'App\\Models\\Receipt',1399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-13','2024-04-13',68970.00,NULL,NULL,1,'2024-05-20 20:06:56','2024-05-20 20:06:56',NULL),(1753,7566,40720,1552,2,1400,'App\\Models\\Receipt',1400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-01','2024-05-01',510692.37,NULL,NULL,1,'2024-06-14 19:34:02','2024-06-14 19:34:02',NULL),(1754,7566,40720,1552,2,1401,'App\\Models\\Receipt',1401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-02','2024-05-02',775994.33,NULL,NULL,1,'2024-06-14 19:34:03','2024-06-14 20:15:12','2024-06-14 20:15:12'),(1755,7566,40720,1552,2,1402,'App\\Models\\Receipt',1402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-08','2024-05-08',25517.51,NULL,NULL,1,'2024-06-14 19:34:03','2024-06-14 20:18:46','2024-06-14 20:18:46'),(1756,7566,40720,1552,2,1403,'App\\Models\\Receipt',1403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-16','2024-05-16',1100543.46,NULL,NULL,1,'2024-06-14 19:34:03','2024-06-14 19:34:03',NULL),(1757,7566,40720,1552,2,1404,'App\\Models\\Receipt',1404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-20','2024-05-20',3632.24,NULL,NULL,1,'2024-06-14 19:34:03','2024-06-14 20:20:07','2024-06-14 20:20:07'),(1758,7566,40720,1552,2,1405,'App\\Models\\Receipt',1405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-27','2024-05-27',14407.19,NULL,NULL,1,'2024-06-14 19:34:03','2024-06-14 19:35:25','2024-06-14 19:35:25'),(1759,7566,40720,1552,2,1405,'App\\Models\\Receipt',1405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-27','2024-05-27',14407.19,NULL,NULL,1,'2024-06-14 19:35:25','2024-06-14 19:35:25',NULL),(1760,7566,40720,1552,3,1406,'App\\Models\\Receipt',1406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-01','2024-05-01',8300.00,NULL,NULL,1,'2024-06-14 19:47:04','2024-06-14 19:47:04',NULL),(1761,7566,40720,1552,3,1407,'App\\Models\\Receipt',1407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-01','2024-05-01',76845.47,NULL,NULL,1,'2024-06-14 19:47:04','2024-06-14 19:47:46','2024-06-14 19:47:46'),(1762,7566,40720,1552,3,1408,'App\\Models\\Receipt',1408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-02','2024-05-02',7500.00,NULL,NULL,1,'2024-06-14 19:47:04','2024-06-14 19:47:04',NULL),(1763,7566,40720,1552,3,1409,'App\\Models\\Receipt',1409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-03','2024-05-03',35245.47,NULL,NULL,1,'2024-06-14 19:47:04','2024-06-14 20:03:55','2024-06-14 20:03:55'),(1764,7566,40720,1552,3,1410,'App\\Models\\Receipt',1410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-06','2024-05-06',7500.00,NULL,NULL,1,'2024-06-14 19:47:04','2024-06-14 19:47:04',NULL),(1765,7566,40720,1552,3,1411,'App\\Models\\Receipt',1411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-10','2024-05-10',7500.00,NULL,NULL,1,'2024-06-14 19:47:04','2024-06-14 19:47:04',NULL),(1766,7566,40720,1552,3,1412,'App\\Models\\Receipt',1412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-15','2024-05-15',17740.00,NULL,NULL,1,'2024-06-14 19:47:04','2024-06-14 19:47:04',NULL);
INSERT INTO `balance_libro` VALUES (1767,7566,40720,1552,3,1413,'App\\Models\\Receipt',1413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-15','2024-05-15',10500.01,NULL,NULL,1,'2024-06-14 19:47:04','2024-06-14 19:47:04',NULL),(1768,7566,40720,1552,3,1414,'App\\Models\\Receipt',1414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-17','2024-05-17',20550.00,NULL,NULL,1,'2024-06-14 19:47:05','2024-06-14 19:47:05',NULL),(1769,7566,40720,1552,3,1415,'App\\Models\\Receipt',1415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-17','2024-05-17',2293.84,NULL,NULL,1,'2024-06-14 19:47:05','2024-06-14 19:48:45','2024-06-14 19:48:45'),(1770,7566,40720,1552,3,1416,'App\\Models\\Receipt',1416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-18','2024-05-18',41565.44,NULL,NULL,1,'2024-06-14 19:47:05','2024-06-14 20:02:05','2024-06-14 20:02:05'),(1771,7566,40720,1552,3,1417,'App\\Models\\Receipt',1417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-19','2024-05-19',25400.00,NULL,NULL,1,'2024-06-14 19:47:05','2024-06-14 19:47:05',NULL),(1772,7566,40720,1552,3,1418,'App\\Models\\Receipt',1418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-21','2024-05-21',7800.00,NULL,NULL,1,'2024-06-14 19:47:05','2024-06-14 19:47:05',NULL),(1773,7566,40720,1552,3,1419,'App\\Models\\Receipt',1419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-21','2024-05-21',29762.82,NULL,NULL,1,'2024-06-14 19:47:05','2024-06-14 20:06:15','2024-06-14 20:06:15'),(1774,7566,40720,1552,3,1420,'App\\Models\\Receipt',1420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-22','2024-05-22',7800.00,NULL,NULL,1,'2024-06-14 19:47:05','2024-06-14 19:47:05',NULL),(1775,7566,40720,1552,3,1421,'App\\Models\\Receipt',1421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-22','2024-05-22',10600.00,NULL,NULL,1,'2024-06-14 19:47:05','2024-06-14 19:47:05',NULL),(1776,7566,40720,1552,3,1422,'App\\Models\\Receipt',1422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-23','2024-05-23',10780.00,NULL,NULL,1,'2024-06-14 19:47:05','2024-06-14 19:47:05',NULL),(1777,7566,40720,1552,3,1423,'App\\Models\\Receipt',1423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-24','2024-05-24',16100.00,NULL,NULL,1,'2024-06-14 19:47:05','2024-06-14 19:47:05',NULL),(1778,7566,40720,1552,3,1424,'App\\Models\\Receipt',1424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-26','2024-05-26',131990.00,NULL,NULL,1,'2024-06-14 19:47:05','2024-06-14 19:59:54','2024-06-14 19:59:54'),(1779,7566,40720,1552,3,1425,'App\\Models\\Receipt',1425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-26','2024-05-26',35943.57,NULL,NULL,1,'2024-06-14 19:47:06','2024-06-14 19:48:16','2024-06-14 19:48:16'),(1780,7566,40720,1552,3,1426,'App\\Models\\Receipt',1426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-27','2024-05-27',8500.00,NULL,NULL,1,'2024-06-14 19:47:06','2024-06-14 19:47:06',NULL),(1781,7566,40720,1552,3,1427,'App\\Models\\Receipt',1427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-27','2024-05-27',12200.00,NULL,NULL,1,'2024-06-14 19:47:06','2024-06-14 19:47:06',NULL),(1782,7566,40720,1552,3,1428,'App\\Models\\Receipt',1428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-29','2024-05-29',3999.00,NULL,NULL,1,'2024-06-14 19:47:06','2024-06-14 19:47:06',NULL),(1783,7566,40720,1552,3,1429,'App\\Models\\Receipt',1429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',9700.00,NULL,NULL,1,'2024-06-14 19:47:06','2024-06-14 19:47:06',NULL),(1784,7566,40720,1552,3,1430,'App\\Models\\Receipt',1430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-20','2024-05-20',24300.01,NULL,NULL,1,'2024-06-14 19:50:31','2024-06-14 19:50:31',NULL),(1785,7566,40720,1552,3,1431,'App\\Models\\Receipt',1431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-31','2024-05-31',24900.00,NULL,NULL,1,'2024-06-14 19:51:35','2024-06-14 19:51:35',NULL),(1786,7566,40720,1552,3,1432,'App\\Models\\Receipt',1432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-03','2024-05-03',2500.00,NULL,NULL,1,'2024-06-14 19:52:35','2024-06-14 19:52:35',NULL);
INSERT INTO `balance_libro` VALUES (1787,7566,40720,1552,3,1433,'App\\Models\\Receipt',1433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-25','2024-05-25',38925.83,NULL,NULL,1,'2024-06-14 19:53:29','2024-06-14 19:53:29',NULL),(1788,7566,40720,1552,3,1434,'App\\Models\\Receipt',1434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-01','2024-05-01',39322.06,NULL,NULL,1,'2024-06-14 19:54:13','2024-06-14 19:54:13',NULL),(1789,7566,40720,1552,3,1435,'App\\Models\\Receipt',1435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-13','2024-05-13',91960.00,NULL,NULL,1,'2024-06-14 19:54:53','2024-06-14 19:54:53',NULL),(1790,7566,40720,1552,3,1436,'App\\Models\\Receipt',1436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-22','2024-05-22',145200.00,NULL,NULL,1,'2024-06-14 19:55:31','2024-06-14 19:55:31',NULL),(1791,7566,40720,1552,3,1424,'App\\Models\\Receipt',1424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-26','2024-05-26',131990.00,NULL,NULL,1,'2024-06-14 19:59:54','2024-06-14 19:59:54',NULL),(1792,7566,40720,1552,3,1416,'App\\Models\\Receipt',1416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-18','2024-05-18',39886.19,NULL,NULL,1,'2024-06-14 20:02:05','2024-06-14 20:02:33','2024-06-14 20:02:33'),(1793,7566,40720,1552,3,1416,'App\\Models\\Receipt',1416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-18','2024-05-18',41565.44,NULL,NULL,1,'2024-06-14 20:02:33','2024-06-14 20:02:33',NULL),(1794,7566,40720,1552,3,1409,'App\\Models\\Receipt',1409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-03','2024-05-03',35245.47,NULL,NULL,1,'2024-06-14 20:03:55','2024-06-14 20:03:55',NULL),(1795,7566,40720,1552,3,1437,'App\\Models\\Receipt',1437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-04-21','2024-04-21',28052.18,NULL,NULL,1,'2024-06-14 20:07:35','2024-06-14 20:07:35',NULL),(1796,7566,40720,1552,7,1438,'App\\Models\\Receipt',1438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-30','2024-05-30',1435.01,NULL,NULL,1,'2024-06-14 20:12:12','2024-06-14 20:12:12',NULL),(1797,7566,40720,1552,7,1439,'App\\Models\\Receipt',1439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-29','2024-05-29',3206.46,NULL,NULL,1,'2024-06-14 20:12:12','2024-06-14 20:12:12',NULL),(1798,7566,40720,1552,7,1440,'App\\Models\\Receipt',1440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-28','2024-05-28',13019.10,NULL,NULL,1,'2024-06-14 20:12:12','2024-06-14 20:12:12',NULL),(1799,7566,40720,1552,7,1441,'App\\Models\\Receipt',1441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-28','2024-05-28',2000.34,NULL,NULL,1,'2024-06-14 20:12:12','2024-06-14 20:12:12',NULL),(1800,7566,40720,1552,7,1442,'App\\Models\\Receipt',1442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-27','2024-05-27',884.27,NULL,NULL,1,'2024-06-14 20:12:12','2024-06-14 20:12:12',NULL),(1801,7566,40720,1552,7,1443,'App\\Models\\Receipt',1443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-22','2024-05-22',4546.72,NULL,NULL,1,'2024-06-14 20:12:12','2024-06-14 20:12:12',NULL),(1802,7566,40720,1552,7,1444,'App\\Models\\Receipt',1444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-21','2024-05-21',504.31,NULL,NULL,1,'2024-06-14 20:12:12','2024-06-14 20:12:12',NULL),(1803,7566,40720,1552,7,1445,'App\\Models\\Receipt',1445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-20','2024-05-20',4977.72,NULL,NULL,1,'2024-06-14 20:12:12','2024-06-14 20:12:12',NULL),(1804,7566,40720,1552,7,1446,'App\\Models\\Receipt',1446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-17','2024-05-17',3956.48,NULL,NULL,1,'2024-06-14 20:12:12','2024-06-14 20:12:12',NULL),(1805,7566,40720,1552,7,1447,'App\\Models\\Receipt',1447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-14','2024-05-14',1504.34,NULL,NULL,1,'2024-06-14 20:12:12','2024-06-14 20:12:12',NULL),(1806,7566,40720,1552,7,1448,'App\\Models\\Receipt',1448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-13','2024-05-13',2464.84,NULL,NULL,1,'2024-06-14 20:12:12','2024-06-14 20:12:12',NULL),(1807,7566,40720,1552,7,1449,'App\\Models\\Receipt',1449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-09','2024-05-09',34377.49,NULL,NULL,1,'2024-06-14 20:12:12','2024-06-14 20:12:12',NULL);
INSERT INTO `balance_libro` VALUES (1808,7566,40720,1552,7,1450,'App\\Models\\Receipt',1450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-08','2024-05-08',1928.75,NULL,NULL,1,'2024-06-14 20:12:12','2024-06-14 20:12:12',NULL),(1809,7566,40720,1552,7,1451,'App\\Models\\Receipt',1451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-07','2024-05-07',3276.04,NULL,NULL,1,'2024-06-14 20:12:13','2024-06-14 20:12:13',NULL),(1810,7566,40720,1552,7,1452,'App\\Models\\Receipt',1452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-06','2024-05-06',26029.36,NULL,NULL,1,'2024-06-14 20:12:13','2024-06-14 20:12:13',NULL),(1811,7566,40720,1552,7,1453,'App\\Models\\Receipt',1453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-03','2024-05-03',14292.75,NULL,NULL,1,'2024-06-14 20:12:13','2024-06-14 20:12:13',NULL),(1812,7566,40720,1552,7,1454,'App\\Models\\Receipt',1454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-02','2024-05-02',987.11,NULL,NULL,1,'2024-06-14 20:12:13','2024-06-14 20:12:13',NULL),(1813,7566,40720,1552,7,1455,'App\\Models\\Receipt',1455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-02','2024-05-02',2453.40,NULL,NULL,1,'2024-06-14 20:12:13','2024-06-14 20:12:13',NULL),(1814,7566,40720,1552,2,1401,'App\\Models\\Receipt',1401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-02','2024-05-02',775994.33,NULL,NULL,1,'2024-06-14 20:15:12','2024-06-14 20:15:12',NULL),(1815,7566,40720,1552,2,1402,'App\\Models\\Receipt',1402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-08','2024-05-08',25517.52,NULL,NULL,1,'2024-06-14 20:18:46','2024-06-14 20:18:46',NULL),(1816,7566,40720,1552,2,1404,'App\\Models\\Receipt',1404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-20','2024-05-20',3632.24,NULL,NULL,1,'2024-06-14 20:20:07','2024-06-14 20:20:07',NULL),(1817,7566,40720,1553,2,1456,'App\\Models\\Receipt',1456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',618325.52,NULL,NULL,1,'2024-07-15 18:46:41','2024-07-15 19:43:21','2024-07-15 19:43:21'),(1818,7566,40720,1553,2,1457,'App\\Models\\Receipt',1457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',841860.65,NULL,NULL,1,'2024-07-15 18:46:41','2024-07-15 19:44:08','2024-07-15 19:44:08'),(1819,7566,40720,1553,2,1458,'App\\Models\\Receipt',1458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',26099.36,NULL,NULL,1,'2024-07-15 18:46:41','2024-07-15 19:44:54','2024-07-15 19:44:54'),(1820,7566,40720,1553,2,1459,'App\\Models\\Receipt',1459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',39537.44,NULL,NULL,1,'2024-07-15 18:46:41','2024-07-15 18:46:41',NULL),(1821,7566,40720,1553,2,1460,'App\\Models\\Receipt',1460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-16','2024-06-16',1213773.60,NULL,NULL,1,'2024-07-15 18:46:41','2024-07-15 19:45:31','2024-07-15 19:45:31'),(1822,7566,40720,1553,2,1461,'App\\Models\\Receipt',1461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-27','2024-06-27',15459.73,NULL,NULL,1,'2024-07-15 18:46:41','2024-07-15 19:46:00','2024-07-15 19:46:00'),(1823,7566,40720,1553,3,1462,'App\\Models\\Receipt',1462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',8300.00,NULL,NULL,1,'2024-07-15 18:47:46','2024-07-15 18:47:46',NULL),(1824,7566,40720,1553,3,1463,'App\\Models\\Receipt',1463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',14300.00,NULL,NULL,1,'2024-07-15 18:47:46','2024-07-15 18:47:46',NULL),(1825,7566,40720,1553,3,1464,'App\\Models\\Receipt',1464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',14300.00,NULL,NULL,1,'2024-07-15 18:47:46','2024-07-15 18:47:46',NULL),(1826,7566,40720,1553,3,1465,'App\\Models\\Receipt',1465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',35191.69,NULL,NULL,1,'2024-07-15 18:47:46','2024-07-15 20:36:17','2024-07-15 20:36:17'),(1827,7566,40720,1553,3,1466,'App\\Models\\Receipt',1466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',14300.00,NULL,NULL,1,'2024-07-15 18:47:46','2024-07-15 18:47:46',NULL);
INSERT INTO `balance_libro` VALUES (1828,7566,40720,1553,3,1467,'App\\Models\\Receipt',1467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',76845.47,NULL,NULL,1,'2024-07-15 18:47:46','2024-07-15 21:13:30','2024-07-15 21:13:30'),(1829,7566,40720,1553,3,1468,'App\\Models\\Receipt',1468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',39745.74,NULL,NULL,1,'2024-07-15 18:47:46','2024-07-15 20:13:28','2024-07-15 20:13:28'),(1830,7566,40720,1553,3,1469,'App\\Models\\Receipt',1469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-04','2024-06-04',8500.00,NULL,NULL,1,'2024-07-15 18:47:46','2024-07-15 18:47:46',NULL),(1831,7566,40720,1553,3,1470,'App\\Models\\Receipt',1470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-05','2024-06-05',18600.00,NULL,NULL,1,'2024-07-15 18:47:46','2024-07-15 18:47:46',NULL),(1832,7566,40720,1553,3,1471,'App\\Models\\Receipt',1471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-06','2024-06-06',12400.00,NULL,NULL,1,'2024-07-15 18:47:46','2024-07-15 18:47:46',NULL),(1833,7566,40720,1553,3,1472,'App\\Models\\Receipt',1472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-07','2024-06-07',8500.00,NULL,NULL,1,'2024-07-15 18:47:46','2024-07-15 18:47:46',NULL),(1834,7566,40720,1553,3,1473,'App\\Models\\Receipt',1473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-08','2024-06-08',30686.46,NULL,NULL,1,'2024-07-15 18:47:46','2024-07-15 20:28:17','2024-07-15 20:28:17'),(1835,7566,40720,1553,3,1474,'App\\Models\\Receipt',1474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-10','2024-06-10',11700.00,NULL,NULL,1,'2024-07-15 18:47:47','2024-07-15 18:47:47',NULL),(1836,7566,40720,1553,3,1475,'App\\Models\\Receipt',1475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-11','2024-06-11',7800.00,NULL,NULL,1,'2024-07-15 18:47:47','2024-07-15 18:47:47',NULL),(1837,7566,40720,1553,3,1476,'App\\Models\\Receipt',1476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-11','2024-06-11',130000.00,NULL,NULL,1,'2024-07-15 18:47:47','2024-07-15 18:47:47',NULL),(1838,7566,40720,1553,3,1477,'App\\Models\\Receipt',1477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-12','2024-06-12',8200.00,NULL,NULL,1,'2024-07-15 18:47:47','2024-07-15 18:47:47',NULL),(1839,7566,40720,1553,3,1478,'App\\Models\\Receipt',1478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-13','2024-06-13',11064.05,NULL,NULL,1,'2024-07-15 18:47:47','2024-07-15 20:35:24','2024-07-15 20:35:24'),(1840,7566,40720,1553,3,1479,'App\\Models\\Receipt',1479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',8500.00,NULL,NULL,1,'2024-07-15 18:47:47','2024-07-15 18:47:47',NULL),(1841,7566,40720,1553,3,1480,'App\\Models\\Receipt',1480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',14300.00,NULL,NULL,1,'2024-07-15 18:47:47','2024-07-15 18:47:47',NULL),(1842,7566,40720,1553,3,1481,'App\\Models\\Receipt',1481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-16','2024-06-16',79150.00,NULL,NULL,1,'2024-07-15 18:47:47','2024-07-15 20:55:19','2024-07-15 20:55:19'),(1843,7566,40720,1553,3,1482,'App\\Models\\Receipt',1482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-17','2024-06-17',37175.18,NULL,NULL,1,'2024-07-15 18:47:47','2024-07-15 20:34:05','2024-07-15 20:34:05'),(1844,7566,40720,1553,3,1483,'App\\Models\\Receipt',1483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-20','2024-06-20',9633.06,NULL,NULL,1,'2024-07-15 18:47:47','2024-07-15 20:32:14','2024-07-15 20:32:14'),(1845,7566,40720,1553,3,1484,'App\\Models\\Receipt',1484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-21','2024-06-21',12600.00,NULL,NULL,1,'2024-07-15 18:47:47','2024-07-15 18:47:47',NULL),(1846,7566,40720,1553,3,1485,'App\\Models\\Receipt',1485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-21','2024-06-21',31575.77,NULL,NULL,1,'2024-07-15 18:47:47','2024-07-15 20:16:49','2024-07-15 20:16:49'),(1847,7566,40720,1553,3,1486,'App\\Models\\Receipt',1486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-22','2024-06-22',19406.72,NULL,NULL,1,'2024-07-15 18:47:47','2024-07-15 20:31:29','2024-07-15 20:31:29');
INSERT INTO `balance_libro` VALUES (1848,7566,40720,1553,3,1487,'App\\Models\\Receipt',1487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-22','2024-06-22',17000.00,NULL,NULL,1,'2024-07-15 18:47:47','2024-07-15 18:47:47',NULL),(1849,7566,40720,1553,3,1488,'App\\Models\\Receipt',1488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-26','2024-06-26',8500.00,NULL,NULL,1,'2024-07-15 18:47:47','2024-07-15 18:47:47',NULL),(1850,7566,40720,1553,3,1489,'App\\Models\\Receipt',1489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-27','2024-06-27',25500.00,NULL,NULL,1,'2024-07-15 18:47:47','2024-07-15 18:47:47',NULL),(1851,7566,40720,1553,3,1490,'App\\Models\\Receipt',1490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',9600.00,NULL,NULL,1,'2024-07-15 18:47:48','2024-07-15 18:47:48',NULL),(1852,7566,40720,1553,3,1491,'App\\Models\\Receipt',1491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-29','2024-06-29',3999.00,NULL,NULL,1,'2024-07-15 18:47:48','2024-07-15 20:48:13','2024-07-15 20:48:13'),(1853,7566,40720,1553,2,1456,'App\\Models\\Receipt',1456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',618325.52,NULL,NULL,1,'2024-07-15 19:43:21','2024-07-15 19:43:21',NULL),(1854,7566,40720,1553,2,1457,'App\\Models\\Receipt',1457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',841860.65,NULL,NULL,1,'2024-07-15 19:44:08','2024-07-15 19:44:08',NULL),(1855,7566,40720,1553,2,1458,'App\\Models\\Receipt',1458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',26099.36,NULL,NULL,1,'2024-07-15 19:44:54','2024-07-15 19:44:54',NULL),(1856,7566,40720,1553,2,1460,'App\\Models\\Receipt',1460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-16','2024-06-16',1213773.60,NULL,NULL,1,'2024-07-15 19:45:31','2024-07-15 19:45:31',NULL),(1857,7566,40720,1553,2,1461,'App\\Models\\Receipt',1461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-27','2024-06-27',15459.73,NULL,NULL,1,'2024-07-15 19:46:00','2024-07-15 19:46:00',NULL),(1858,7566,40720,1553,7,1492,'App\\Models\\Receipt',1492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',2146.48,NULL,NULL,1,'2024-07-15 19:50:08','2024-07-15 19:50:08',NULL),(1859,7566,40720,1553,7,1493,'App\\Models\\Receipt',1493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-28','2024-06-28',10974.67,NULL,NULL,1,'2024-07-15 19:50:08','2024-07-15 19:50:08',NULL),(1860,7566,40720,1553,7,1494,'App\\Models\\Receipt',1494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-26','2024-06-26',1764.22,NULL,NULL,1,'2024-07-15 19:50:08','2024-07-15 19:50:08',NULL),(1861,7566,40720,1553,7,1495,'App\\Models\\Receipt',1495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-25','2024-06-25',289.15,NULL,NULL,1,'2024-07-15 19:50:08','2024-07-15 19:50:08',NULL),(1862,7566,40720,1553,7,1496,'App\\Models\\Receipt',1496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-24','2024-06-24',24988.59,NULL,NULL,1,'2024-07-15 19:50:08','2024-07-15 19:50:08',NULL),(1863,7566,40720,1553,7,1497,'App\\Models\\Receipt',1497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-19','2024-06-19',3182.15,NULL,NULL,1,'2024-07-15 19:50:08','2024-07-15 19:50:08',NULL),(1864,7566,40720,1553,7,1498,'App\\Models\\Receipt',1498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-18','2024-06-18',758.71,NULL,NULL,1,'2024-07-15 19:50:08','2024-07-15 19:50:08',NULL),(1865,7566,40720,1553,7,1499,'App\\Models\\Receipt',1499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',2859.64,NULL,NULL,1,'2024-07-15 19:50:08','2024-07-15 19:50:08',NULL),(1866,7566,40720,1553,7,1500,'App\\Models\\Receipt',1500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-13','2024-06-13',4759.79,NULL,NULL,1,'2024-07-15 19:50:08','2024-07-15 19:50:08',NULL),(1867,7566,40720,1553,7,1501,'App\\Models\\Receipt',1501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-12','2024-06-12',612.61,NULL,NULL,1,'2024-07-15 19:50:08','2024-07-15 19:50:08',NULL),(1868,7566,40720,1553,7,1502,'App\\Models\\Receipt',1502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-11','2024-06-11',792.90,NULL,NULL,1,'2024-07-15 19:50:08','2024-07-15 19:50:08',NULL);
INSERT INTO `balance_libro` VALUES (1869,7566,40720,1553,7,1503,'App\\Models\\Receipt',1503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-10','2024-06-10',2039.50,NULL,NULL,1,'2024-07-15 19:50:08','2024-07-15 19:50:08',NULL),(1870,7566,40720,1553,7,1504,'App\\Models\\Receipt',1504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-07','2024-06-07',37355.26,NULL,NULL,1,'2024-07-15 19:50:08','2024-07-15 19:50:08',NULL),(1871,7566,40720,1553,7,1505,'App\\Models\\Receipt',1505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-06','2024-06-06',645.79,NULL,NULL,1,'2024-07-15 19:50:08','2024-07-15 19:50:08',NULL),(1872,7566,40720,1553,7,1506,'App\\Models\\Receipt',1506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-05','2024-06-05',14812.60,NULL,NULL,1,'2024-07-15 19:50:08','2024-07-15 19:50:08',NULL),(1873,7566,40720,1553,7,1507,'App\\Models\\Receipt',1507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-04','2024-06-04',7858.29,NULL,NULL,1,'2024-07-15 19:50:08','2024-07-15 19:50:08',NULL),(1874,7566,40720,1553,7,1508,'App\\Models\\Receipt',1508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',5574.84,NULL,NULL,1,'2024-07-15 19:50:08','2024-07-15 19:50:08',NULL),(1875,7566,40720,1553,3,1468,'App\\Models\\Receipt',1468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-03','2024-06-03',39745.74,NULL,NULL,1,'2024-07-15 20:13:28','2024-07-15 20:13:28',NULL),(1876,7566,40720,1553,3,1509,'App\\Models\\Receipt',1509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-21','2024-05-21',28803.49,NULL,NULL,1,'2024-07-15 20:17:59','2024-07-15 20:19:28','2024-07-15 20:19:28'),(1877,7566,40720,1553,3,1509,'App\\Models\\Receipt',1509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-05-21','2024-05-21',29762.82,NULL,NULL,1,'2024-07-15 20:19:28','2024-07-15 20:19:28',NULL),(1878,7566,40720,1553,3,1473,'App\\Models\\Receipt',1473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-08','2024-06-08',29742.92,NULL,NULL,1,'2024-07-15 20:28:17','2024-07-15 20:29:30','2024-07-15 20:29:30'),(1879,7566,40720,1553,3,1473,'App\\Models\\Receipt',1473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-08','2024-06-08',30686.46,NULL,NULL,1,'2024-07-15 20:29:30','2024-07-15 20:30:31','2024-07-15 20:30:31'),(1880,7566,40720,1553,3,1473,'App\\Models\\Receipt',1473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-08','2024-06-08',30686.46,NULL,NULL,1,'2024-07-15 20:30:31','2024-07-15 20:30:31',NULL),(1881,7566,40720,1553,3,1486,'App\\Models\\Receipt',1486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-22','2024-06-22',19406.72,NULL,NULL,1,'2024-07-15 20:31:29','2024-07-15 20:31:29',NULL),(1882,7566,40720,1553,3,1483,'App\\Models\\Receipt',1483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-20','2024-06-20',9633.07,NULL,NULL,1,'2024-07-15 20:32:14','2024-07-15 20:32:14',NULL),(1883,7566,40720,1553,3,1482,'App\\Models\\Receipt',1482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-17','2024-06-17',37175.18,NULL,NULL,1,'2024-07-15 20:34:05','2024-07-15 20:34:15','2024-07-15 20:34:15'),(1884,7566,40720,1553,3,1482,'App\\Models\\Receipt',1482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-17','2024-06-17',37175.18,NULL,NULL,1,'2024-07-15 20:34:15','2024-07-15 20:34:15',NULL),(1885,7566,40720,1553,3,1478,'App\\Models\\Receipt',1478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-13','2024-06-13',11064.05,NULL,NULL,1,'2024-07-15 20:35:24','2024-07-15 20:35:24',NULL),(1886,7566,40720,1553,3,1465,'App\\Models\\Receipt',1465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',34327.39,NULL,NULL,1,'2024-07-15 20:36:17','2024-07-15 20:37:51','2024-07-15 20:37:51'),(1887,7566,40720,1553,3,1465,'App\\Models\\Receipt',1465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-01','2024-06-01',35191.69,NULL,NULL,1,'2024-07-15 20:37:51','2024-07-15 20:37:51',NULL),(1888,7566,40720,1553,3,1491,'App\\Models\\Receipt',1491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-29','2024-06-29',4118.97,NULL,NULL,1,'2024-07-15 20:48:13','2024-07-15 20:52:50','2024-07-15 20:52:50');
INSERT INTO `balance_libro` VALUES (1889,7566,40720,1553,3,1491,'App\\Models\\Receipt',1491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-29','2024-06-29',4118.97,NULL,NULL,1,'2024-07-15 20:52:50','2024-07-15 20:53:10','2024-07-15 20:53:10'),(1890,7566,40720,1553,3,1491,'App\\Models\\Receipt',1491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-29','2024-06-29',4118.97,NULL,NULL,1,'2024-07-15 20:53:10','2024-07-15 20:53:10',NULL),(1891,7566,40720,1553,3,1481,'App\\Models\\Receipt',1481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-16','2024-06-16',79150.00,NULL,NULL,1,'2024-07-15 20:55:19','2024-07-15 20:55:19',NULL),(1892,7566,40720,1553,3,1510,'App\\Models\\Receipt',1510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-10','2024-06-10',80645.00,NULL,NULL,1,'2024-07-15 20:56:53','2024-07-15 20:56:53',NULL),(1893,7566,40720,1553,3,1511,'App\\Models\\Receipt',1511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-15','2024-06-15',38492.22,NULL,NULL,1,'2024-07-15 20:58:02','2024-07-15 20:58:02',NULL),(1894,7566,40720,1553,3,1512,'App\\Models\\Receipt',1512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-10','2024-06-10',268620.00,NULL,NULL,1,'2024-07-15 20:58:58','2024-07-15 20:58:58',NULL),(1895,7566,40720,1553,3,1513,'App\\Models\\Receipt',1513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-17','2024-06-17',9700.00,NULL,NULL,1,'2024-07-15 20:59:40','2024-07-15 20:59:40',NULL),(1896,7566,40720,1553,3,1514,'App\\Models\\Receipt',1514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-19','2024-06-19',128260.00,NULL,NULL,1,'2024-07-15 21:00:26','2024-07-15 21:00:26',NULL),(1897,7566,40720,1553,3,1515,'App\\Models\\Receipt',1515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-14','2024-06-14',187550.00,NULL,NULL,1,'2024-07-15 21:01:29','2024-07-15 21:01:29',NULL),(1898,7566,40720,1553,3,1516,'App\\Models\\Receipt',1516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-09','2024-06-09',19300.00,NULL,NULL,1,'2024-07-16 19:16:32','2024-07-16 19:16:32',NULL),(1899,7566,40720,1554,2,1517,'App\\Models\\Receipt',1517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',668155.67,NULL,NULL,1,'2024-08-17 10:12:41','2024-08-17 10:16:20','2024-08-17 10:16:20'),(1900,7566,40720,1554,2,1518,'App\\Models\\Receipt',1518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-02','2024-07-02',859018.71,NULL,NULL,1,'2024-08-17 10:12:41','2024-08-17 10:16:01','2024-08-17 10:16:01'),(1901,7566,40720,1554,2,1519,'App\\Models\\Receipt',1519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-03','2024-07-03',18508.50,NULL,NULL,1,'2024-08-17 10:12:41','2024-08-17 10:15:40','2024-08-17 10:15:40'),(1902,7566,40720,1554,2,1520,'App\\Models\\Receipt',1520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-16','2024-07-16',1267045.06,NULL,NULL,1,'2024-08-17 10:12:41','2024-08-17 10:15:16','2024-08-17 10:15:16'),(1903,7566,40720,1554,2,1521,'App\\Models\\Receipt',1521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-29','2024-07-29',3530.10,NULL,NULL,1,'2024-08-17 10:12:41','2024-08-17 10:14:58','2024-08-17 10:14:58'),(1904,7566,40720,1554,2,1521,'App\\Models\\Receipt',1521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-29','2024-07-29',3530.10,NULL,NULL,1,'2024-08-17 10:14:58','2024-08-17 10:14:58',NULL),(1905,7566,40720,1554,2,1520,'App\\Models\\Receipt',1520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-16','2024-07-16',1267045.06,NULL,NULL,1,'2024-08-17 10:15:16','2024-08-17 10:15:16',NULL),(1906,7566,40720,1554,2,1519,'App\\Models\\Receipt',1519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-03','2024-07-03',18508.50,NULL,NULL,1,'2024-08-17 10:15:40','2024-08-17 10:15:40',NULL),(1907,7566,40720,1554,2,1518,'App\\Models\\Receipt',1518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-02','2024-07-02',859018.71,NULL,NULL,1,'2024-08-17 10:16:01','2024-08-17 10:16:01',NULL),(1908,7566,40720,1554,2,1517,'App\\Models\\Receipt',1517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',668155.67,NULL,NULL,1,'2024-08-17 10:16:20','2024-08-17 10:16:20',NULL);
INSERT INTO `balance_libro` VALUES (1909,7566,40720,1554,3,1522,'App\\Models\\Receipt',1522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',11400.00,NULL,NULL,1,'2024-08-17 10:17:33','2024-08-17 10:17:33',NULL),(1910,7566,40720,1554,3,1523,'App\\Models\\Receipt',1523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',1150.00,NULL,NULL,1,'2024-08-17 10:17:33','2024-08-17 10:17:33',NULL),(1911,7566,40720,1554,3,1524,'App\\Models\\Receipt',1524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',76845.47,NULL,NULL,1,'2024-08-17 10:17:33','2024-08-17 10:20:07','2024-08-17 10:20:07'),(1912,7566,40720,1554,3,1525,'App\\Models\\Receipt',1525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-02','2024-07-02',42006.96,NULL,NULL,1,'2024-08-17 10:17:34','2024-08-17 11:11:01','2024-08-17 11:11:01'),(1913,7566,40720,1554,3,1526,'App\\Models\\Receipt',1526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-03','2024-07-03',43831.35,NULL,NULL,1,'2024-08-17 10:17:34','2024-08-17 11:35:56','2024-08-17 11:35:56'),(1914,7566,40720,1554,3,1527,'App\\Models\\Receipt',1527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-07','2024-07-07',35542.14,NULL,NULL,1,'2024-08-17 10:17:34','2024-08-17 11:28:18','2024-08-17 11:28:18'),(1915,7566,40720,1554,3,1528,'App\\Models\\Receipt',1528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-13','2024-07-13',21170.00,NULL,NULL,1,'2024-08-17 10:17:34','2024-08-17 10:17:34',NULL),(1916,7566,40720,1554,3,1529,'App\\Models\\Receipt',1529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-14','2024-07-14',2167.16,NULL,NULL,1,'2024-08-17 10:17:34','2024-08-17 11:22:28','2024-08-17 11:22:28'),(1917,7566,40720,1554,3,1530,'App\\Models\\Receipt',1530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-14','2024-07-14',206.21,NULL,NULL,1,'2024-08-17 10:17:34','2024-08-17 10:20:29','2024-08-17 10:20:29'),(1918,7566,40720,1554,3,1531,'App\\Models\\Receipt',1531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-18','2024-07-18',9000.00,NULL,NULL,1,'2024-08-17 10:17:34','2024-08-17 10:17:34',NULL),(1919,7566,40720,1554,3,1532,'App\\Models\\Receipt',1532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-19','2024-07-19',65000.00,NULL,NULL,1,'2024-08-17 10:17:34','2024-08-17 10:17:34',NULL),(1920,7566,40720,1554,3,1533,'App\\Models\\Receipt',1533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-20','2024-07-20',62027.26,NULL,NULL,1,'2024-08-17 10:17:34','2024-08-17 11:27:13','2024-08-17 11:27:13'),(1921,7566,40720,1554,3,1534,'App\\Models\\Receipt',1534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-20','2024-07-20',18000.00,NULL,NULL,1,'2024-08-17 10:17:34','2024-08-17 10:17:34',NULL),(1922,7566,40720,1554,3,1535,'App\\Models\\Receipt',1535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-21','2024-07-21',33468.26,NULL,NULL,1,'2024-08-17 10:17:34','2024-08-17 11:45:40','2024-08-17 11:45:40'),(1923,7566,40720,1554,3,1536,'App\\Models\\Receipt',1536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-23','2024-07-23',7800.00,NULL,NULL,1,'2024-08-17 10:17:35','2024-08-17 10:17:35',NULL),(1924,7566,40720,1554,3,1537,'App\\Models\\Receipt',1537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-25','2024-07-25',9500.00,NULL,NULL,1,'2024-08-17 10:17:35','2024-08-17 10:17:35',NULL),(1925,7566,40720,1554,3,1538,'App\\Models\\Receipt',1538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-26','2024-07-26',8400.00,NULL,NULL,1,'2024-08-17 10:17:35','2024-08-17 10:17:35',NULL),(1926,7566,40720,1554,3,1539,'App\\Models\\Receipt',1539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-27','2024-07-27',18146.74,NULL,NULL,1,'2024-08-17 10:17:35','2024-08-17 11:32:57','2024-08-17 11:32:57'),(1927,7566,40720,1554,3,1540,'App\\Models\\Receipt',1540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-27','2024-07-27',440106.43,NULL,NULL,1,'2024-08-17 10:17:35','2024-08-17 11:31:47','2024-08-17 11:31:47'),(1928,7566,40720,1554,3,1541,'App\\Models\\Receipt',1541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-27','2024-07-27',5098.00,NULL,NULL,1,'2024-08-17 10:17:35','2024-08-17 11:34:13','2024-08-17 11:34:13');
INSERT INTO `balance_libro` VALUES (1929,7566,40720,1554,3,1542,'App\\Models\\Receipt',1542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-28','2024-07-28',20977.76,NULL,NULL,1,'2024-08-17 10:17:35','2024-08-17 11:15:38','2024-08-17 11:15:38'),(1930,7566,40720,1554,3,1543,'App\\Models\\Receipt',1543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-28','2024-07-28',3999.00,NULL,NULL,1,'2024-08-17 10:17:35','2024-08-17 11:52:01','2024-08-17 11:52:01'),(1931,7566,40720,1554,7,1544,'App\\Models\\Receipt',1544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-30','2024-07-30',490.13,NULL,NULL,1,'2024-08-17 10:28:00','2024-08-17 10:28:00',NULL),(1932,7566,40720,1554,7,1545,'App\\Models\\Receipt',1545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-30','2024-07-30',2903.29,NULL,NULL,1,'2024-08-17 10:28:00','2024-08-17 10:28:00',NULL),(1933,7566,40720,1554,7,1546,'App\\Models\\Receipt',1546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-29','2024-07-29',9812.59,NULL,NULL,1,'2024-08-17 10:28:01','2024-08-17 10:28:01',NULL),(1934,7566,40720,1554,7,1547,'App\\Models\\Receipt',1547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-26','2024-07-26',476.57,NULL,NULL,1,'2024-08-17 10:28:01','2024-08-17 10:28:01',NULL),(1935,7566,40720,1554,7,1548,'App\\Models\\Receipt',1548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-24','2024-07-24',3486.35,NULL,NULL,1,'2024-08-17 10:28:01','2024-08-17 10:28:01',NULL),(1936,7566,40720,1554,7,1549,'App\\Models\\Receipt',1549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-23','2024-07-23',1517.84,NULL,NULL,1,'2024-08-17 10:28:01','2024-08-17 10:28:01',NULL),(1937,7566,40720,1554,7,1550,'App\\Models\\Receipt',1550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-22','2024-07-22',23835.20,NULL,NULL,1,'2024-08-17 10:28:01','2024-08-17 10:28:01',NULL),(1938,7566,40720,1554,7,1551,'App\\Models\\Receipt',1551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-18','2024-07-18',6596.88,NULL,NULL,1,'2024-08-17 10:28:01','2024-08-17 10:28:01',NULL),(1939,7566,40720,1554,7,1552,'App\\Models\\Receipt',1552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-17','2024-07-17',5021.90,NULL,NULL,1,'2024-08-17 10:28:01','2024-08-17 10:28:01',NULL),(1940,7566,40720,1554,7,1553,'App\\Models\\Receipt',1553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-15','2024-07-15',109.23,NULL,NULL,1,'2024-08-17 10:28:02','2024-08-17 10:28:02',NULL),(1941,7566,40720,1554,7,1554,'App\\Models\\Receipt',1554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-12','2024-07-12',818.98,NULL,NULL,1,'2024-08-17 10:28:02','2024-08-17 10:28:02',NULL),(1942,7566,40720,1554,7,1555,'App\\Models\\Receipt',1555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-11','2024-07-11',25250.27,NULL,NULL,1,'2024-08-17 10:28:02','2024-08-17 10:28:02',NULL),(1943,7566,40720,1554,7,1556,'App\\Models\\Receipt',1556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-10','2024-07-10',7902.68,NULL,NULL,1,'2024-08-17 10:28:02','2024-08-17 10:28:02',NULL),(1944,7566,40720,1554,7,1557,'App\\Models\\Receipt',1557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-08','2024-07-08',2166.91,NULL,NULL,1,'2024-08-17 10:28:02','2024-08-17 10:28:02',NULL),(1945,7566,40720,1554,7,1558,'App\\Models\\Receipt',1558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-05','2024-07-05',1399.61,NULL,NULL,1,'2024-08-17 10:28:02','2024-08-17 10:28:02',NULL),(1946,7566,40720,1554,7,1559,'App\\Models\\Receipt',1559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-04','2024-07-04',8774.59,NULL,NULL,1,'2024-08-17 10:28:02','2024-08-17 10:28:02',NULL),(1947,7566,40720,1554,7,1560,'App\\Models\\Receipt',1560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-03','2024-07-03',4205.94,NULL,NULL,1,'2024-08-17 10:28:02','2024-08-17 10:28:02',NULL),(1948,7566,40720,1554,7,1561,'App\\Models\\Receipt',1561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-02','2024-07-02',3719.60,NULL,NULL,1,'2024-08-17 10:28:02','2024-08-17 10:28:02',NULL),(1949,7566,40720,1554,7,1562,'App\\Models\\Receipt',1562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-01','2024-07-01',1388.06,NULL,NULL,1,'2024-08-17 10:28:03','2024-08-17 10:28:03',NULL);
INSERT INTO `balance_libro` VALUES (1950,7566,40720,1554,3,1563,'App\\Models\\Receipt',1563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-15','2024-07-15',29499.99,NULL,NULL,1,'2024-08-17 10:31:33','2024-08-17 10:34:44','2024-08-17 10:34:44'),(1951,7566,40720,1554,3,1564,'App\\Models\\Receipt',1564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-19','2024-07-19',435600.00,NULL,NULL,1,'2024-08-17 10:34:06','2024-08-17 10:34:06',NULL),(1952,7566,40720,1554,3,1563,'App\\Models\\Receipt',1563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-15','2024-07-15',29499.99,NULL,NULL,1,'2024-08-17 10:34:44','2024-08-17 10:34:44',NULL),(1953,7566,40720,1554,3,1565,'App\\Models\\Receipt',1565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-24','2024-07-24',157300.00,NULL,NULL,1,'2024-08-17 10:36:09','2024-08-17 10:36:09',NULL),(1954,7566,40720,1554,3,1566,'App\\Models\\Receipt',1566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-13','2024-07-13',15300.00,NULL,NULL,1,'2024-08-17 10:36:49','2024-08-17 10:36:49',NULL),(1955,7566,40720,1554,3,1567,'App\\Models\\Receipt',1567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-19','2024-07-19',10960.00,NULL,NULL,1,'2024-08-17 10:38:29','2024-08-17 10:38:29',NULL),(1956,7566,40720,1554,3,1568,'App\\Models\\Receipt',1568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-13','2024-07-13',30007.97,NULL,NULL,1,'2024-08-17 10:39:22','2024-08-17 10:39:22',NULL),(1957,7566,40720,1554,3,1569,'App\\Models\\Receipt',1569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-07','2024-07-07',8800.00,NULL,NULL,1,'2024-08-17 10:39:59','2024-08-17 10:39:59',NULL),(1958,7566,40720,1554,3,1570,'App\\Models\\Receipt',1570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-09','2024-07-09',12700.00,NULL,NULL,1,'2024-08-17 10:40:37','2024-08-17 10:40:37',NULL),(1959,7566,40720,1554,3,1525,'App\\Models\\Receipt',1525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-02','2024-07-02',42006.96,NULL,NULL,1,'2024-08-17 11:11:01','2024-08-17 11:11:01',NULL),(1960,7566,40720,1554,3,1542,'App\\Models\\Receipt',1542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-28','2024-07-28',20977.76,NULL,NULL,1,'2024-08-17 11:15:38','2024-08-17 11:15:38',NULL),(1961,7566,40720,1554,3,1529,'App\\Models\\Receipt',1529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-14','2024-07-14',2167.17,NULL,NULL,1,'2024-08-17 11:22:28','2024-08-17 11:22:28',NULL),(1962,7566,40720,1554,3,1533,'App\\Models\\Receipt',1533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-20','2024-07-20',62027.26,NULL,NULL,1,'2024-08-17 11:27:13','2024-08-17 11:27:13',NULL),(1963,7566,40720,1554,3,1527,'App\\Models\\Receipt',1527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-07','2024-07-07',35542.14,NULL,NULL,1,'2024-08-17 11:28:18','2024-08-17 11:28:18',NULL),(1964,7566,40720,1554,3,1540,'App\\Models\\Receipt',1540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-27','2024-07-27',440106.44,NULL,NULL,1,'2024-08-17 11:31:47','2024-08-17 12:01:58','2024-08-17 12:01:58'),(1965,7566,40720,1554,3,1539,'App\\Models\\Receipt',1539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-27','2024-07-27',18146.74,NULL,NULL,1,'2024-08-17 11:32:57','2024-08-17 11:32:57',NULL),(1966,7566,40720,1554,3,1541,'App\\Models\\Receipt',1541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-27','2024-07-27',5098.00,NULL,NULL,1,'2024-08-17 11:34:13','2024-08-17 11:34:13',NULL),(1967,7566,40720,1554,3,1526,'App\\Models\\Receipt',1526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-03','2024-07-03',43831.35,NULL,NULL,1,'2024-08-17 11:35:56','2024-08-17 11:35:56',NULL),(1968,7566,40720,1554,3,1571,'App\\Models\\Receipt',1571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-06-21','2024-06-21',31575.77,NULL,NULL,1,'2024-08-17 11:47:20','2024-08-17 11:47:20',NULL),(1969,7566,40720,1554,3,1543,'App\\Models\\Receipt',1543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-28','2024-07-28',4098.15,NULL,NULL,1,'2024-08-17 11:52:01','2024-08-17 11:52:24','2024-08-17 11:52:24');
INSERT INTO `balance_libro` VALUES (1970,7566,40720,1554,3,1543,'App\\Models\\Receipt',1543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-28','2024-07-28',4098.15,NULL,NULL,1,'2024-08-17 11:52:24','2024-08-17 11:52:24',NULL),(1971,7566,40720,1554,3,1540,'App\\Models\\Receipt',1540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-27','2024-07-27',440106.44,NULL,NULL,1,'2024-08-17 12:01:58','2024-08-17 12:01:58',NULL),(1972,7566,40720,1555,7,1572,'App\\Models\\Receipt',1572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',15627.60,NULL,NULL,1,'2024-09-14 10:18:33','2024-09-14 10:18:33',NULL),(1973,7566,40720,1555,7,1573,'App\\Models\\Receipt',1573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-29','2024-08-29',672.07,NULL,NULL,1,'2024-09-14 10:18:33','2024-09-14 10:18:33',NULL),(1974,7566,40720,1555,7,1574,'App\\Models\\Receipt',1574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-28','2024-08-28',490.13,NULL,NULL,1,'2024-09-14 10:18:33','2024-09-14 10:18:33',NULL),(1975,7566,40720,1555,7,1575,'App\\Models\\Receipt',1575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-28','2024-08-28',12341.74,NULL,NULL,1,'2024-09-14 10:18:33','2024-09-14 10:18:33',NULL),(1976,7566,40720,1555,7,1576,'App\\Models\\Receipt',1576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-27','2024-08-27',3299.85,NULL,NULL,1,'2024-09-14 10:18:33','2024-09-14 10:18:33',NULL),(1977,7566,40720,1555,7,1577,'App\\Models\\Receipt',1577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-23','2024-08-23',1632.24,NULL,NULL,1,'2024-09-14 10:18:34','2024-09-14 10:18:34',NULL),(1978,7566,40720,1555,7,1578,'App\\Models\\Receipt',1578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-21','2024-08-21',4593.40,NULL,NULL,1,'2024-09-14 10:18:34','2024-09-14 10:18:34',NULL),(1979,7566,40720,1555,7,1579,'App\\Models\\Receipt',1579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-20','2024-08-20',818.35,NULL,NULL,1,'2024-09-14 10:18:34','2024-09-14 10:18:34',NULL),(1980,7566,40720,1555,7,1580,'App\\Models\\Receipt',1580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-19','2024-08-19',15009.28,NULL,NULL,1,'2024-09-14 10:18:34','2024-09-14 10:18:34',NULL),(1981,7566,40720,1555,7,1581,'App\\Models\\Receipt',1581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-16','2024-08-16',471.89,NULL,NULL,1,'2024-09-14 10:18:34','2024-09-14 10:18:34',NULL),(1982,7566,40720,1555,7,1582,'App\\Models\\Receipt',1582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-15','2024-08-15',2312.79,NULL,NULL,1,'2024-09-14 10:18:34','2024-09-14 10:18:34',NULL),(1983,7566,40720,1555,7,1583,'App\\Models\\Receipt',1583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-14','2024-08-14',2254.08,NULL,NULL,1,'2024-09-14 10:18:34','2024-09-14 10:18:34',NULL),(1984,7566,40720,1555,7,1584,'App\\Models\\Receipt',1584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-13','2024-08-13',2228.59,NULL,NULL,1,'2024-09-14 10:18:34','2024-09-14 10:18:34',NULL),(1985,7566,40720,1555,7,1585,'App\\Models\\Receipt',1585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-12','2024-08-12',9257.80,NULL,NULL,1,'2024-09-14 10:18:35','2024-09-14 10:18:35',NULL),(1986,7566,40720,1555,7,1586,'App\\Models\\Receipt',1586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-09','2024-08-09',35351.87,NULL,NULL,1,'2024-09-14 10:18:35','2024-09-14 10:18:35',NULL),(1987,7566,40720,1555,7,1587,'App\\Models\\Receipt',1587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-08','2024-08-08',5906.61,NULL,NULL,1,'2024-09-14 10:18:35','2024-09-14 10:18:35',NULL),(1988,7566,40720,1555,7,1588,'App\\Models\\Receipt',1588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-07','2024-08-07',1525.55,NULL,NULL,1,'2024-09-14 10:18:35','2024-09-14 10:18:35',NULL),(1989,7566,40720,1555,7,1589,'App\\Models\\Receipt',1589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-06','2024-08-06',1602.66,NULL,NULL,1,'2024-09-14 10:18:35','2024-09-14 10:18:35',NULL),(1990,7566,40720,1555,7,1590,'App\\Models\\Receipt',1590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-05','2024-08-05',13422.17,NULL,NULL,1,'2024-09-14 10:18:35','2024-09-14 10:18:35',NULL);
INSERT INTO `balance_libro` VALUES (1991,7566,40720,1555,7,1591,'App\\Models\\Receipt',1591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-02','2024-08-02',1656.35,NULL,NULL,1,'2024-09-14 10:18:35','2024-09-14 10:18:35',NULL),(1992,7566,40720,1555,7,1592,'App\\Models\\Receipt',1592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-02','2024-08-02',4561.90,NULL,NULL,1,'2024-09-14 10:18:36','2024-09-14 10:18:36',NULL),(1993,7566,40720,1555,7,1593,'App\\Models\\Receipt',1593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',1803.59,NULL,NULL,1,'2024-09-14 10:18:36','2024-09-14 10:18:36',NULL),(1994,7566,40720,1555,2,1594,'App\\Models\\Receipt',1594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',792160.23,NULL,NULL,1,'2024-09-14 10:19:00','2024-09-14 10:24:54','2024-09-14 10:24:54'),(1995,7566,40720,1555,2,1595,'App\\Models\\Receipt',1595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',787843.17,NULL,NULL,1,'2024-09-14 10:19:00','2024-09-14 10:24:17','2024-09-14 10:24:17'),(1996,7566,40720,1555,2,1596,'App\\Models\\Receipt',1596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',11929.63,NULL,NULL,1,'2024-09-14 10:19:00','2024-09-14 10:23:48','2024-09-14 10:23:48'),(1997,7566,40720,1555,2,1597,'App\\Models\\Receipt',1597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-02','2024-08-02',20004.02,NULL,NULL,1,'2024-09-14 10:19:00','2024-09-14 10:26:05','2024-09-14 10:26:05'),(1998,7566,40720,1555,2,1598,'App\\Models\\Receipt',1598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-02','2024-08-02',34774.84,NULL,NULL,1,'2024-09-14 10:19:00','2024-09-14 10:19:00',NULL),(1999,7566,40720,1555,2,1599,'App\\Models\\Receipt',1599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-16','2024-08-16',1383258.93,NULL,NULL,1,'2024-09-14 10:19:00','2024-09-14 10:22:44','2024-09-14 10:22:44'),(2000,7566,40720,1555,2,1600,'App\\Models\\Receipt',1600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-27','2024-08-27',3530.11,NULL,NULL,1,'2024-09-14 10:19:00','2024-09-14 10:22:03','2024-09-14 10:22:03'),(2001,7566,40720,1555,2,1601,'App\\Models\\Receipt',1601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',11929.63,NULL,NULL,1,'2024-09-14 10:19:00','2024-09-14 10:21:34','2024-09-14 10:21:34'),(2002,7566,40720,1555,3,1602,'App\\Models\\Receipt',1602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',11400.00,NULL,NULL,1,'2024-09-14 10:19:14','2024-09-14 10:19:14',NULL),(2003,7566,40720,1555,3,1603,'App\\Models\\Receipt',1603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',76845.47,NULL,NULL,1,'2024-09-14 10:19:14','2024-09-14 10:37:17','2024-09-14 10:37:17'),(2004,7566,40720,1555,3,1604,'App\\Models\\Receipt',1604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-03','2024-08-03',37352.05,NULL,NULL,1,'2024-09-14 10:19:14','2024-09-14 11:32:39','2024-09-14 11:32:39'),(2005,7566,40720,1555,3,1605,'App\\Models\\Receipt',1605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-03','2024-08-03',47189.49,NULL,NULL,1,'2024-09-14 10:19:14','2024-09-14 10:49:46','2024-09-14 10:49:46'),(2006,7566,40720,1555,3,1606,'App\\Models\\Receipt',1606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-06','2024-08-06',10500.00,NULL,NULL,1,'2024-09-14 10:19:14','2024-09-14 10:19:14',NULL),(2007,7566,40720,1555,3,1607,'App\\Models\\Receipt',1607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-07','2024-08-07',6700.00,NULL,NULL,1,'2024-09-14 10:19:15','2024-09-14 10:19:15',NULL),(2008,7566,40720,1555,3,1608,'App\\Models\\Receipt',1608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-09','2024-08-09',6700.00,NULL,NULL,1,'2024-09-14 10:19:15','2024-09-14 10:19:15',NULL),(2009,7566,40720,1555,3,1609,'App\\Models\\Receipt',1609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-10','2024-08-10',48154.73,NULL,NULL,1,'2024-09-14 10:19:15','2024-09-14 11:30:04','2024-09-14 11:30:04'),(2010,7566,40720,1555,3,1610,'App\\Models\\Receipt',1610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-10','2024-08-10',11000.00,NULL,NULL,1,'2024-09-14 10:19:15','2024-09-14 10:19:15',NULL);
INSERT INTO `balance_libro` VALUES (2011,7566,40720,1555,3,1611,'App\\Models\\Receipt',1611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-13','2024-08-13',13850.00,NULL,NULL,1,'2024-09-14 10:19:15','2024-09-14 10:19:15',NULL),(2012,7566,40720,1555,3,1612,'App\\Models\\Receipt',1612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-14','2024-08-14',9350.00,NULL,NULL,1,'2024-09-14 10:19:15','2024-09-14 10:19:15',NULL),(2013,7566,40720,1555,3,1613,'App\\Models\\Receipt',1613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-15','2024-08-15',13850.00,NULL,NULL,1,'2024-09-14 10:19:15','2024-09-14 10:19:15',NULL),(2014,7566,40720,1555,3,1614,'App\\Models\\Receipt',1614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-16','2024-08-16',7800.00,NULL,NULL,1,'2024-09-14 10:19:15','2024-09-14 10:19:15',NULL),(2015,7566,40720,1555,3,1615,'App\\Models\\Receipt',1615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-18','2024-08-18',33988.22,NULL,NULL,1,'2024-09-14 10:19:15','2024-09-14 11:33:13','2024-09-14 11:33:13'),(2016,7566,40720,1555,3,1616,'App\\Models\\Receipt',1616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-20','2024-08-20',9000.00,NULL,NULL,1,'2024-09-14 10:19:15','2024-09-14 10:19:15',NULL),(2017,7566,40720,1555,3,1617,'App\\Models\\Receipt',1617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-20','2024-08-20',24000.00,NULL,NULL,1,'2024-09-14 10:19:15','2024-09-14 10:19:15',NULL),(2018,7566,40720,1555,3,1618,'App\\Models\\Receipt',1618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-21','2024-08-21',10300.00,NULL,NULL,1,'2024-09-14 10:19:16','2024-09-14 10:19:16',NULL),(2019,7566,40720,1555,3,1619,'App\\Models\\Receipt',1619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-21','2024-08-21',34803.80,NULL,NULL,1,'2024-09-14 10:19:16','2024-09-14 10:46:08','2024-09-14 10:46:08'),(2020,7566,40720,1555,3,1620,'App\\Models\\Receipt',1620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-25','2024-08-25',35970.00,NULL,NULL,1,'2024-09-14 10:19:16','2024-09-14 10:19:16',NULL),(2021,7566,40720,1555,3,1621,'App\\Models\\Receipt',1621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-27','2024-08-27',28175.02,NULL,NULL,1,'2024-09-14 10:19:16','2024-09-14 11:28:49','2024-09-14 11:28:49'),(2022,7566,40720,1555,3,1622,'App\\Models\\Receipt',1622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-27','2024-08-27',3999.00,NULL,NULL,1,'2024-09-14 10:19:16','2024-09-14 11:59:38','2024-09-14 11:59:38'),(2023,7566,40720,1555,3,1623,'App\\Models\\Receipt',1623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',30100.00,NULL,NULL,1,'2024-09-14 10:19:16','2024-09-14 10:19:16',NULL),(2024,7566,40720,1555,2,1601,'App\\Models\\Receipt',1601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-30','2024-08-30',11929.63,NULL,NULL,1,'2024-09-14 10:21:34','2024-09-14 10:21:34',NULL),(2025,7566,40720,1555,2,1600,'App\\Models\\Receipt',1600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-27','2024-08-27',3530.11,NULL,NULL,1,'2024-09-14 10:22:03','2024-09-14 10:22:03',NULL),(2026,7566,40720,1555,2,1599,'App\\Models\\Receipt',1599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-16','2024-08-16',1383258.93,NULL,NULL,1,'2024-09-14 10:22:44','2024-09-14 10:22:44',NULL),(2027,7566,40720,1555,2,1596,'App\\Models\\Receipt',1596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',11929.63,NULL,NULL,1,'2024-09-14 10:23:48','2024-09-14 10:23:48',NULL),(2028,7566,40720,1555,2,1595,'App\\Models\\Receipt',1595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',787843.17,NULL,NULL,1,'2024-09-14 10:24:17','2024-09-14 10:24:17',NULL),(2029,7566,40720,1555,2,1594,'App\\Models\\Receipt',1594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-01','2024-08-01',792160.23,NULL,NULL,1,'2024-09-14 10:24:54','2024-09-14 10:24:54',NULL),(2030,7566,40720,1555,2,1597,'App\\Models\\Receipt',1597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-02','2024-08-02',20004.02,NULL,NULL,1,'2024-09-14 10:26:05','2024-09-14 10:26:05',NULL);
INSERT INTO `balance_libro` VALUES (2031,7566,40720,1555,3,1624,'App\\Models\\Receipt',1624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-07-21','2024-07-21',33468.26,NULL,NULL,1,'2024-09-14 10:47:49','2024-09-14 10:47:49',NULL),(2032,7566,40720,1555,3,1605,'App\\Models\\Receipt',1605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-03','2024-08-03',47189.49,NULL,NULL,1,'2024-09-14 10:49:46','2024-09-14 10:49:46',NULL),(2033,7566,40720,1555,3,1625,'App\\Models\\Receipt',1625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-18','2024-08-18',277332.00,NULL,NULL,1,'2024-09-14 11:16:02','2024-09-14 11:16:02',NULL),(2034,7566,40720,1555,3,1626,'App\\Models\\Receipt',1626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-12','2024-08-12',353925.00,NULL,NULL,1,'2024-09-14 11:16:33','2024-09-14 11:16:33',NULL),(2035,7566,40720,1555,3,1627,'App\\Models\\Receipt',1627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-11','2024-08-11',8000.00,NULL,NULL,1,'2024-09-14 11:17:36','2024-09-14 11:17:36',NULL),(2036,7566,40720,1555,3,1628,'App\\Models\\Receipt',1628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-03','2024-08-03',33016.02,NULL,NULL,1,'2024-09-14 11:18:32','2024-09-14 11:18:32',NULL),(2037,7566,40720,1555,3,1629,'App\\Models\\Receipt',1629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-04','2024-08-04',20600.00,NULL,NULL,1,'2024-09-14 11:19:15','2024-09-14 11:19:15',NULL),(2038,7566,40720,1555,3,1630,'App\\Models\\Receipt',1630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-15','2024-08-15',283956.07,NULL,NULL,1,'2024-09-14 11:22:00','2024-09-14 11:22:00',NULL),(2039,7566,40720,1555,3,1631,'App\\Models\\Receipt',1631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-21','2024-08-21',33700.00,NULL,NULL,1,'2024-09-14 11:22:43','2024-09-14 11:22:43',NULL),(2040,7566,40720,1555,3,1632,'App\\Models\\Receipt',1632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-07','2024-08-07',10900.01,NULL,NULL,1,'2024-09-14 11:23:06','2024-09-14 11:23:06',NULL),(2041,7566,40720,1555,3,1633,'App\\Models\\Receipt',1633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-21','2024-08-21',39324.80,NULL,NULL,1,'2024-09-14 11:24:08','2024-09-14 12:29:04','2024-09-14 12:29:04'),(2042,7566,40720,1555,3,1634,'App\\Models\\Receipt',1634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-02','2024-08-02',7400.00,NULL,NULL,1,'2024-09-14 11:24:58','2024-09-14 11:24:58',NULL),(2043,7566,40720,1555,3,1635,'App\\Models\\Receipt',1635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-12','2024-08-12',10000.00,NULL,NULL,1,'2024-09-14 11:25:45','2024-09-14 11:25:45',NULL),(2044,7566,40720,1555,3,1636,'App\\Models\\Receipt',1636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-22','2024-08-22',7050.00,NULL,NULL,1,'2024-09-14 11:26:13','2024-09-14 11:26:13',NULL),(2045,7566,40720,1555,3,1637,'App\\Models\\Receipt',1637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-29','2024-08-29',10600.00,NULL,NULL,1,'2024-09-14 11:26:42','2024-09-14 11:26:42',NULL),(2046,7566,40720,1555,3,1621,'App\\Models\\Receipt',1621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-27','2024-08-27',28175.02,NULL,NULL,1,'2024-09-14 11:28:49','2024-09-14 11:28:49',NULL),(2047,7566,40720,1555,3,1609,'App\\Models\\Receipt',1609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-10','2024-08-10',47764.09,NULL,NULL,1,'2024-09-14 11:30:04','2024-09-14 11:31:44','2024-09-14 11:31:44'),(2048,7566,40720,1555,3,1609,'App\\Models\\Receipt',1609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-10','2024-08-10',48154.73,NULL,NULL,1,'2024-09-14 11:31:44','2024-09-14 11:31:44',NULL),(2049,7566,40720,1555,3,1604,'App\\Models\\Receipt',1604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-03','2024-08-03',37352.05,NULL,NULL,1,'2024-09-14 11:32:39','2024-09-14 11:32:39',NULL),(2050,7566,40720,1555,3,1615,'App\\Models\\Receipt',1615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-18','2024-08-18',34772.35,NULL,NULL,1,'2024-09-14 11:33:13','2024-09-14 11:33:48','2024-09-14 11:33:48');
INSERT INTO `balance_libro` VALUES (2051,7566,40720,1555,3,1615,'App\\Models\\Receipt',1615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-18','2024-08-18',33988.22,NULL,NULL,1,'2024-09-14 11:33:48','2024-09-14 11:33:48',NULL),(2052,7566,40720,1555,3,1622,'App\\Models\\Receipt',1622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-27','2024-08-27',4098.15,NULL,NULL,1,'2024-09-14 11:59:38','2024-09-14 11:59:38',NULL),(2053,7566,40720,1555,3,1638,'App\\Models\\Receipt',1638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-21','2024-08-21',39324.80,NULL,NULL,1,'2024-09-14 12:30:35','2024-09-14 12:30:35',NULL),(2054,7566,40720,1556,7,1639,'App\\Models\\Receipt',1639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',23487.23,NULL,NULL,1,'2024-10-17 18:18:23','2024-10-17 18:18:23',NULL),(2055,7566,40720,1556,7,1640,'App\\Models\\Receipt',1640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-27','2024-09-27',471.89,NULL,NULL,1,'2024-10-17 18:18:24','2024-10-17 18:18:24',NULL),(2056,7566,40720,1556,7,1641,'App\\Models\\Receipt',1641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-26','2024-09-26',914.54,NULL,NULL,1,'2024-10-17 18:18:24','2024-10-17 18:18:24',NULL),(2057,7566,40720,1556,7,1642,'App\\Models\\Receipt',1642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-24','2024-09-24',6526.20,NULL,NULL,1,'2024-10-17 18:18:24','2024-10-17 18:18:24',NULL),(2058,7566,40720,1556,7,1643,'App\\Models\\Receipt',1643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-19','2024-09-19',1303.31,NULL,NULL,1,'2024-10-17 18:18:24','2024-10-17 18:18:24',NULL),(2059,7566,40720,1556,7,1644,'App\\Models\\Receipt',1644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-18','2024-09-18',21275.96,NULL,NULL,1,'2024-10-17 18:18:24','2024-10-17 18:18:24',NULL),(2060,7566,40720,1556,7,1645,'App\\Models\\Receipt',1645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-17','2024-09-17',2038.59,NULL,NULL,1,'2024-10-17 18:18:24','2024-10-17 18:18:24',NULL),(2061,7566,40720,1556,7,1646,'App\\Models\\Receipt',1646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-16','2024-09-16',4623.27,NULL,NULL,1,'2024-10-17 18:18:24','2024-10-17 18:18:24',NULL),(2062,7566,40720,1556,7,1647,'App\\Models\\Receipt',1647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-12','2024-09-12',109.22,NULL,NULL,1,'2024-10-17 18:18:24','2024-10-17 18:18:24',NULL),(2063,7566,40720,1556,7,1648,'App\\Models\\Receipt',1648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-11','2024-09-11',2686.55,NULL,NULL,1,'2024-10-17 18:18:24','2024-10-17 18:18:24',NULL),(2064,7566,40720,1556,7,1649,'App\\Models\\Receipt',1649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-10','2024-09-10',1070.76,NULL,NULL,1,'2024-10-17 18:18:24','2024-10-17 18:18:24',NULL),(2065,7566,40720,1556,7,1650,'App\\Models\\Receipt',1650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-10','2024-09-10',10536.42,NULL,NULL,1,'2024-10-17 18:18:24','2024-10-17 18:18:24',NULL),(2066,7566,40720,1556,7,1651,'App\\Models\\Receipt',1651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-09','2024-09-09',32401.60,NULL,NULL,1,'2024-10-17 18:18:24','2024-10-17 18:18:24',NULL),(2067,7566,40720,1556,7,1652,'App\\Models\\Receipt',1652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-04','2024-09-04',17790.46,NULL,NULL,1,'2024-10-17 18:18:24','2024-10-17 18:18:24',NULL),(2068,7566,40720,1556,7,1653,'App\\Models\\Receipt',1653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-03','2024-09-03',4808.04,NULL,NULL,1,'2024-10-17 18:18:24','2024-10-17 18:18:24',NULL),(2069,7566,40720,1556,7,1654,'App\\Models\\Receipt',1654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-02','2024-09-02',1656.35,NULL,NULL,1,'2024-10-17 18:18:25','2024-10-17 18:18:25',NULL),(2070,7566,40720,1556,7,1655,'App\\Models\\Receipt',1655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-02','2024-09-02',1937.66,NULL,NULL,1,'2024-10-17 18:18:25','2024-10-17 18:18:25',NULL),(2071,7566,40720,1556,2,1656,'App\\Models\\Receipt',1656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-01','2024-09-01',828742.72,NULL,NULL,1,'2024-10-17 18:18:52','2024-10-17 18:35:27','2024-10-17 18:35:27');
INSERT INTO `balance_libro` VALUES (2072,7566,40720,1556,2,1657,'App\\Models\\Receipt',1657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-02','2024-09-02',970117.73,NULL,NULL,1,'2024-10-17 18:18:52','2024-10-17 18:18:52',NULL),(2073,7566,40720,1556,2,1658,'App\\Models\\Receipt',1658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-04','2024-09-04',21069.60,NULL,NULL,1,'2024-10-17 18:18:52','2024-10-17 18:46:59','2024-10-17 18:46:59'),(2074,7566,40720,1556,2,1659,'App\\Models\\Receipt',1659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-09','2024-09-09',7712.06,NULL,NULL,1,'2024-10-17 18:18:52','2024-10-17 18:49:37','2024-10-17 18:49:37'),(2075,7566,40720,1556,2,1660,'App\\Models\\Receipt',1660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-17','2024-09-17',1497636.65,NULL,NULL,1,'2024-10-17 18:18:52','2024-10-17 18:18:52',NULL),(2076,7566,40720,1556,3,1661,'App\\Models\\Receipt',1661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-01','2024-09-01',12500.00,NULL,NULL,1,'2024-10-17 18:19:11','2024-10-17 18:19:11',NULL),(2077,7566,40720,1556,3,1662,'App\\Models\\Receipt',1662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-01','2024-09-01',76845.47,NULL,NULL,1,'2024-10-17 18:19:11','2024-10-21 18:04:30','2024-10-21 18:04:30'),(2078,7566,40720,1556,3,1663,'App\\Models\\Receipt',1663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-03','2024-09-03',42726.29,NULL,NULL,1,'2024-10-17 18:19:11','2024-10-17 19:50:00','2024-10-17 19:50:00'),(2079,7566,40720,1556,3,1664,'App\\Models\\Receipt',1664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-04','2024-09-04',11100.00,NULL,NULL,1,'2024-10-17 18:19:11','2024-10-17 18:19:11',NULL),(2080,7566,40720,1556,3,1665,'App\\Models\\Receipt',1665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-09','2024-09-09',24000.00,NULL,NULL,1,'2024-10-17 18:19:11','2024-10-17 18:19:11',NULL),(2081,7566,40720,1556,3,1666,'App\\Models\\Receipt',1666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-10','2024-09-10',11100.00,NULL,NULL,1,'2024-10-17 18:19:11','2024-10-17 18:19:11',NULL),(2082,7566,40720,1556,3,1667,'App\\Models\\Receipt',1667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-12','2024-09-12',9300.00,NULL,NULL,1,'2024-10-17 18:19:11','2024-10-17 18:19:11',NULL),(2083,7566,40720,1556,3,1668,'App\\Models\\Receipt',1668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-13','2024-09-13',9300.00,NULL,NULL,1,'2024-10-17 18:19:11','2024-10-17 18:19:11',NULL),(2084,7566,40720,1556,3,1669,'App\\Models\\Receipt',1669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-13','2024-09-13',141300.00,NULL,NULL,1,'2024-10-17 18:19:11','2024-10-17 18:19:11',NULL),(2085,7566,40720,1556,3,1670,'App\\Models\\Receipt',1670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-15','2024-09-15',25349.89,NULL,NULL,1,'2024-10-17 18:19:11','2024-10-17 19:45:18','2024-10-17 19:45:18'),(2086,7566,40720,1556,3,1671,'App\\Models\\Receipt',1671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-17','2024-09-17',9900.00,NULL,NULL,1,'2024-10-17 18:19:11','2024-10-17 18:19:11',NULL),(2087,7566,40720,1556,3,1672,'App\\Models\\Receipt',1672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-17','2024-09-17',12000.00,NULL,NULL,1,'2024-10-17 18:19:11','2024-10-17 18:19:11',NULL),(2088,7566,40720,1556,3,1673,'App\\Models\\Receipt',1673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-18','2024-09-18',6600.00,NULL,NULL,1,'2024-10-17 18:19:11','2024-10-17 18:19:11',NULL),(2089,7566,40720,1556,3,1674,'App\\Models\\Receipt',1674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-18','2024-09-18',9300.00,NULL,NULL,1,'2024-10-17 18:19:11','2024-10-17 18:19:11',NULL),(2090,7566,40720,1556,3,1675,'App\\Models\\Receipt',1675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-19','2024-09-19',9300.00,NULL,NULL,1,'2024-10-17 18:19:12','2024-10-17 18:19:12',NULL),(2091,7566,40720,1556,3,1676,'App\\Models\\Receipt',1676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-20','2024-09-20',9300.00,NULL,NULL,1,'2024-10-17 18:19:12','2024-10-17 18:19:12',NULL);
INSERT INTO `balance_libro` VALUES (2092,7566,40720,1556,3,1677,'App\\Models\\Receipt',1677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-21','2024-09-21',36190.49,NULL,NULL,1,'2024-10-17 18:19:12','2024-10-17 19:21:31','2024-10-17 19:21:31'),(2093,7566,40720,1556,3,1678,'App\\Models\\Receipt',1678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-22','2024-09-22',46908.88,NULL,NULL,1,'2024-10-17 18:19:12','2024-10-17 19:43:02','2024-10-17 19:43:02'),(2094,7566,40720,1556,3,1679,'App\\Models\\Receipt',1679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-23','2024-09-23',10700.00,NULL,NULL,1,'2024-10-17 18:19:12','2024-10-17 18:19:12',NULL),(2095,7566,40720,1556,3,1680,'App\\Models\\Receipt',1680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-24','2024-09-24',9300.00,NULL,NULL,1,'2024-10-17 18:19:12','2024-10-17 18:19:12',NULL),(2096,7566,40720,1556,3,1681,'App\\Models\\Receipt',1681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-25','2024-09-25',2354.29,NULL,NULL,1,'2024-10-17 18:19:12','2024-10-17 19:48:47','2024-10-17 19:48:47'),(2097,7566,40720,1556,3,1682,'App\\Models\\Receipt',1682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-26','2024-09-26',5999.00,NULL,NULL,1,'2024-10-17 18:19:12','2024-10-21 18:35:07','2024-10-21 18:35:07'),(2098,7566,40720,1556,3,1683,'App\\Models\\Receipt',1683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-28','2024-09-28',9700.00,NULL,NULL,1,'2024-10-17 18:19:12','2024-10-17 18:19:12',NULL),(2099,7566,40720,1556,3,1684,'App\\Models\\Receipt',1684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-28','2024-09-28',37579.85,NULL,NULL,1,'2024-10-17 18:19:12','2024-10-17 19:40:29','2024-10-17 19:40:29'),(2100,7566,40720,1556,3,1685,'App\\Models\\Receipt',1685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-30','2024-09-30',12000.00,NULL,NULL,1,'2024-10-17 18:19:12','2024-10-17 18:19:12',NULL),(2101,7566,40720,1556,2,1656,'App\\Models\\Receipt',1656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-01','2024-09-01',828742.72,NULL,NULL,1,'2024-10-17 18:35:27','2024-10-17 18:35:27',NULL),(2102,7566,40720,1556,2,1658,'App\\Models\\Receipt',1658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-04','2024-09-04',21069.62,NULL,NULL,1,'2024-10-17 18:46:59','2024-10-17 18:48:24','2024-10-17 18:48:24'),(2103,7566,40720,1556,2,1658,'App\\Models\\Receipt',1658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-04','2024-09-04',21069.61,NULL,NULL,1,'2024-10-17 18:48:24','2024-10-17 18:48:24',NULL),(2104,7566,40720,1556,2,1659,'App\\Models\\Receipt',1659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-09','2024-09-09',7712.06,NULL,NULL,1,'2024-10-17 18:49:37','2024-10-17 18:50:07','2024-10-17 18:50:07'),(2105,7566,40720,1556,2,1659,'App\\Models\\Receipt',1659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-09','2024-09-09',7712.08,NULL,NULL,1,'2024-10-17 18:50:07','2024-10-17 18:50:07',NULL),(2106,7566,40720,1556,3,1686,'App\\Models\\Receipt',1686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-08-21','2024-08-21',34803.80,NULL,NULL,1,'2024-10-17 19:23:27','2024-10-17 19:23:27',NULL),(2107,7566,40720,1556,3,1684,'App\\Models\\Receipt',1684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-28','2024-09-28',37579.85,NULL,NULL,1,'2024-10-17 19:40:29','2024-10-17 19:40:29',NULL),(2108,7566,40720,1556,3,1678,'App\\Models\\Receipt',1678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-22','2024-09-22',46908.87,NULL,NULL,1,'2024-10-17 19:43:02','2024-10-17 19:43:02',NULL),(2109,7566,40720,1556,3,1670,'App\\Models\\Receipt',1670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-15','2024-09-15',25349.89,NULL,NULL,1,'2024-10-17 19:45:18','2024-10-17 19:47:59','2024-10-17 19:47:59'),(2110,7566,40720,1556,3,1670,'App\\Models\\Receipt',1670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-15','2024-09-15',25349.89,NULL,NULL,1,'2024-10-17 19:47:59','2024-10-17 19:47:59',NULL),(2111,7566,40720,1556,3,1681,'App\\Models\\Receipt',1681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-25','2024-09-25',2366.18,NULL,NULL,1,'2024-10-17 19:48:47','2024-10-17 19:48:47',NULL);
INSERT INTO `balance_libro` VALUES (2112,7566,40720,1556,3,1663,'App\\Models\\Receipt',1663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-03','2024-09-03',42726.29,NULL,NULL,1,'2024-10-17 19:50:00','2024-10-17 19:50:00',NULL),(2113,7566,40720,1556,3,1687,'App\\Models\\Receipt',1687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-20','2024-09-20',48402.58,NULL,NULL,1,'2024-10-18 18:08:18','2024-10-18 18:08:18',NULL),(2114,7566,40720,1556,3,1688,'App\\Models\\Receipt',1688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-13','2024-09-13',15800.00,NULL,NULL,1,'2024-10-21 17:11:28','2024-10-21 17:11:28',NULL),(2115,7566,40720,1556,3,1689,'App\\Models\\Receipt',1689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-16','2024-09-16',396880.00,NULL,NULL,1,'2024-10-21 17:13:41','2024-10-21 17:13:41',NULL),(2116,7566,40720,1556,3,1690,'App\\Models\\Receipt',1690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-09','2024-09-09',471900.00,NULL,NULL,1,'2024-10-21 17:14:07','2024-10-21 17:14:07',NULL),(2117,7566,40720,1556,3,1691,'App\\Models\\Receipt',1691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-05','2024-09-05',3200.00,NULL,NULL,1,'2024-10-21 17:15:04','2024-10-21 17:15:04',NULL),(2118,7566,40720,1556,3,1692,'App\\Models\\Receipt',1692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-06','2024-09-06',8800.00,NULL,NULL,1,'2024-10-21 17:15:44','2024-10-21 17:15:44',NULL),(2119,7566,40720,1556,3,1693,'App\\Models\\Receipt',1693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-01','2024-09-01',4400.00,NULL,NULL,1,'2024-10-21 17:16:19','2024-10-21 17:16:19',NULL),(2120,7566,40720,1556,3,1682,'App\\Models\\Receipt',1682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-26','2024-09-26',6147.74,NULL,NULL,1,'2024-10-21 18:35:07','2024-10-21 18:35:07',NULL),(2121,7566,40720,1557,2,1694,'App\\Models\\Receipt',1694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-01','2024-10-01',825316.73,NULL,NULL,1,'2024-11-19 17:30:19','2024-11-19 17:37:37','2024-11-19 17:37:37'),(2122,7566,40720,1557,2,1695,'App\\Models\\Receipt',1695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-02','2024-10-02',17103.60,NULL,NULL,1,'2024-11-19 17:30:19','2024-11-19 17:37:15','2024-11-19 17:37:15'),(2123,7566,40720,1557,2,1696,'App\\Models\\Receipt',1696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-02','2024-10-02',942870.43,NULL,NULL,1,'2024-11-19 17:30:19','2024-11-19 17:36:41','2024-11-19 17:36:41'),(2124,7566,40720,1557,2,1697,'App\\Models\\Receipt',1697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-02','2024-10-02',29635.20,NULL,NULL,1,'2024-11-19 17:30:19','2024-11-19 17:36:13','2024-11-19 17:36:13'),(2125,7566,40720,1557,2,1698,'App\\Models\\Receipt',1698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-07','2024-10-07',7712.06,NULL,NULL,1,'2024-11-19 17:30:19','2024-11-19 17:35:47','2024-11-19 17:35:47'),(2126,7566,40720,1557,2,1699,'App\\Models\\Receipt',1699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-16','2024-10-16',1729730.10,NULL,NULL,1,'2024-11-19 17:30:19','2024-11-19 17:35:19','2024-11-19 17:35:19'),(2127,7566,40720,1557,3,1700,'App\\Models\\Receipt',1700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-01','2024-10-01',825316.73,NULL,NULL,1,'2024-11-19 17:30:30','2024-11-19 19:21:06','2024-11-19 19:21:06'),(2128,7566,40720,1557,3,1701,'App\\Models\\Receipt',1701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-02','2024-10-02',17103.60,NULL,NULL,1,'2024-11-19 17:30:30','2024-11-19 19:21:27','2024-11-19 19:21:27'),(2129,7566,40720,1557,3,1702,'App\\Models\\Receipt',1702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-02','2024-10-02',942870.43,NULL,NULL,1,'2024-11-19 17:30:30','2024-11-19 19:21:51','2024-11-19 19:21:51'),(2130,7566,40720,1557,3,1703,'App\\Models\\Receipt',1703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-02','2024-10-02',29635.20,NULL,NULL,1,'2024-11-19 17:30:30','2024-11-19 19:22:56','2024-11-19 19:22:56'),(2131,7566,40720,1557,3,1704,'App\\Models\\Receipt',1704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-07','2024-10-07',7712.06,NULL,NULL,1,'2024-11-19 17:30:30','2024-11-19 19:22:31','2024-11-19 19:22:31');
INSERT INTO `balance_libro` VALUES (2132,7566,40720,1557,3,1705,'App\\Models\\Receipt',1705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-16','2024-10-16',1729730.10,NULL,NULL,1,'2024-11-19 17:30:31','2024-11-19 19:20:37','2024-11-19 19:20:37'),(2133,7566,40720,1557,3,1706,'App\\Models\\Receipt',1706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-01','2024-10-01',14500.00,NULL,NULL,1,'2024-11-19 17:30:49','2024-11-19 18:07:57','2024-11-19 18:07:57'),(2134,7566,40720,1557,3,1707,'App\\Models\\Receipt',1707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-01','2024-10-01',3187.65,NULL,NULL,1,'2024-11-19 17:30:49','2024-11-19 18:00:22','2024-11-19 18:00:22'),(2135,7566,40720,1557,3,1708,'App\\Models\\Receipt',1708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-01','2024-10-01',23027.18,NULL,NULL,1,'2024-11-19 17:30:49','2024-11-19 17:59:54','2024-11-19 17:59:54'),(2136,7566,40720,1557,3,1709,'App\\Models\\Receipt',1709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-01','2024-10-01',76845.47,NULL,NULL,1,'2024-11-19 17:30:49','2024-11-19 17:41:53','2024-11-19 17:41:53'),(2137,7566,40720,1557,3,1710,'App\\Models\\Receipt',1710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-02','2024-10-02',18550.00,NULL,NULL,1,'2024-11-19 17:30:49','2024-11-19 17:30:49',NULL),(2138,7566,40720,1557,3,1711,'App\\Models\\Receipt',1711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-03','2024-10-03',45998.11,NULL,NULL,1,'2024-11-19 17:30:49','2024-11-19 18:13:47','2024-11-19 18:13:47'),(2139,7566,40720,1557,3,1712,'App\\Models\\Receipt',1712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-04','2024-10-04',10300.00,NULL,NULL,1,'2024-11-19 17:30:49','2024-11-19 17:30:49',NULL),(2140,7566,40720,1557,3,1713,'App\\Models\\Receipt',1713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-04','2024-10-04',20000.00,NULL,NULL,1,'2024-11-19 17:30:49','2024-11-19 18:53:47','2024-11-19 18:53:47'),(2141,7566,40720,1557,3,1714,'App\\Models\\Receipt',1714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-05','2024-10-05',50947.26,NULL,NULL,1,'2024-11-19 17:30:50','2024-11-19 18:06:47','2024-11-19 18:06:47'),(2142,7566,40720,1557,3,1715,'App\\Models\\Receipt',1715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-07','2024-10-07',12000.00,NULL,NULL,1,'2024-11-19 17:30:50','2024-11-19 17:30:50',NULL),(2143,7566,40720,1557,3,1716,'App\\Models\\Receipt',1716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-09','2024-10-09',12000.00,NULL,NULL,1,'2024-11-19 17:30:50','2024-11-19 17:30:50',NULL),(2144,7566,40720,1557,3,1717,'App\\Models\\Receipt',1717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-10','2024-10-10',12000.00,NULL,NULL,1,'2024-11-19 17:30:50','2024-11-19 17:30:50',NULL),(2145,7566,40720,1557,3,1718,'App\\Models\\Receipt',1718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-11','2024-10-11',4499.09,NULL,NULL,1,'2024-11-19 17:30:50','2024-11-19 18:07:32','2024-11-19 18:07:32'),(2146,7566,40720,1557,3,1719,'App\\Models\\Receipt',1719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-13','2024-10-13',18383.48,NULL,NULL,1,'2024-11-19 17:30:50','2024-11-19 18:05:29','2024-11-19 18:05:29'),(2147,7566,40720,1557,3,1720,'App\\Models\\Receipt',1720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-15','2024-10-15',121000.00,NULL,NULL,1,'2024-11-19 17:30:50','2024-11-19 17:30:50',NULL),(2148,7566,40720,1557,3,1721,'App\\Models\\Receipt',1721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-16','2024-10-16',8700.00,NULL,NULL,1,'2024-11-19 17:30:50','2024-11-19 17:30:50',NULL),(2149,7566,40720,1557,3,1722,'App\\Models\\Receipt',1722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-18','2024-10-18',12000.00,NULL,NULL,1,'2024-11-19 17:30:50','2024-11-19 17:30:50',NULL),(2150,7566,40720,1557,3,1723,'App\\Models\\Receipt',1723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-18','2024-10-18',76300.00,NULL,NULL,1,'2024-11-19 17:30:50','2024-11-22 20:08:44','2024-11-22 20:08:44'),(2151,7566,40720,1557,3,1724,'App\\Models\\Receipt',1724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-19','2024-10-19',63446.22,NULL,NULL,1,'2024-11-19 17:30:50','2024-11-19 18:04:41','2024-11-19 18:04:41');
INSERT INTO `balance_libro` VALUES (2152,7566,40720,1557,3,1725,'App\\Models\\Receipt',1725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-20','2024-10-20',17384.24,NULL,NULL,1,'2024-11-19 17:30:50','2024-11-19 18:03:41','2024-11-19 18:03:41'),(2153,7566,40720,1557,3,1726,'App\\Models\\Receipt',1726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-21','2024-10-21',12000.00,NULL,NULL,1,'2024-11-19 17:30:50','2024-11-19 17:30:50',NULL),(2154,7566,40720,1557,3,1727,'App\\Models\\Receipt',1727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-21','2024-10-21',41058.41,NULL,NULL,1,'2024-11-19 17:30:50','2024-11-19 18:08:41','2024-11-19 18:08:41'),(2155,7566,40720,1557,3,1728,'App\\Models\\Receipt',1728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-23','2024-10-23',12000.00,NULL,NULL,1,'2024-11-19 17:30:50','2024-11-19 17:30:50',NULL),(2156,7566,40720,1557,3,1729,'App\\Models\\Receipt',1729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-26','2024-10-26',5999.00,NULL,NULL,1,'2024-11-19 17:30:50','2024-11-21 17:29:47','2024-11-21 17:29:47'),(2157,7566,40720,1557,3,1730,'App\\Models\\Receipt',1730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-27','2024-10-27',21720.75,NULL,NULL,1,'2024-11-19 17:30:51','2024-11-19 18:02:47','2024-11-19 18:02:47'),(2158,7566,40720,1557,3,1731,'App\\Models\\Receipt',1731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-28','2024-10-28',14000.00,NULL,NULL,1,'2024-11-19 17:30:51','2024-11-19 17:30:51',NULL),(2159,7566,40720,1557,3,1732,'App\\Models\\Receipt',1732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-28','2024-10-28',14000.00,NULL,NULL,1,'2024-11-19 17:30:51','2024-11-19 17:30:51',NULL),(2160,7566,40720,1557,3,1733,'App\\Models\\Receipt',1733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-29','2024-10-29',10300.00,NULL,NULL,1,'2024-11-19 17:30:51','2024-11-19 17:30:51',NULL),(2161,7566,40720,1557,2,1699,'App\\Models\\Receipt',1699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-16','2024-10-16',1729730.10,NULL,NULL,1,'2024-11-19 17:35:19','2024-11-19 17:35:19',NULL),(2162,7566,40720,1557,2,1698,'App\\Models\\Receipt',1698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-07','2024-10-07',7712.08,NULL,NULL,1,'2024-11-19 17:35:47','2024-11-19 17:35:47',NULL),(2163,7566,40720,1557,2,1697,'App\\Models\\Receipt',1697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-02','2024-10-02',29635.20,NULL,NULL,1,'2024-11-19 17:36:13','2024-11-19 17:36:13',NULL),(2164,7566,40720,1557,2,1696,'App\\Models\\Receipt',1696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-02','2024-10-02',942870.43,NULL,NULL,1,'2024-11-19 17:36:41','2024-11-19 17:36:41',NULL),(2165,7566,40720,1557,2,1695,'App\\Models\\Receipt',1695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-02','2024-10-02',17103.60,NULL,NULL,1,'2024-11-19 17:37:15','2024-11-19 17:37:15',NULL),(2166,7566,40720,1557,2,1694,'App\\Models\\Receipt',1694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-01','2024-10-01',825316.74,NULL,NULL,1,'2024-11-19 17:37:37','2024-11-19 17:37:37',NULL),(2167,7566,40720,1557,3,1708,'App\\Models\\Receipt',1708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-01','2024-10-01',23027.18,NULL,NULL,1,'2024-11-19 17:59:54','2024-11-19 17:59:54',NULL),(2168,7566,40720,1557,3,1707,'App\\Models\\Receipt',1707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-01','2024-10-01',3064.10,NULL,NULL,1,'2024-11-19 18:00:22','2024-11-19 18:00:48','2024-11-19 18:00:48'),(2169,7566,40720,1557,3,1707,'App\\Models\\Receipt',1707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-01','2024-10-01',3187.65,NULL,NULL,1,'2024-11-19 18:00:49','2024-11-19 18:00:49',NULL),(2170,7566,40720,1557,3,1730,'App\\Models\\Receipt',1730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-27','2024-10-27',21720.75,NULL,NULL,1,'2024-11-19 18:02:47','2024-11-19 18:02:47',NULL),(2171,7566,40720,1557,3,1725,'App\\Models\\Receipt',1725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-20','2024-10-20',17384.24,NULL,NULL,1,'2024-11-19 18:03:41','2024-11-19 18:03:41',NULL);
INSERT INTO `balance_libro` VALUES (2172,7566,40720,1557,3,1724,'App\\Models\\Receipt',1724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-19','2024-10-19',63446.22,NULL,NULL,1,'2024-11-19 18:04:41','2024-11-19 18:04:41',NULL),(2173,7566,40720,1557,3,1719,'App\\Models\\Receipt',1719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-13','2024-10-13',18383.48,NULL,NULL,1,'2024-11-19 18:05:29','2024-11-19 18:05:29',NULL),(2174,7566,40720,1557,3,1714,'App\\Models\\Receipt',1714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-05','2024-10-05',50947.26,NULL,NULL,1,'2024-11-19 18:06:47','2024-11-19 18:06:47',NULL),(2175,7566,40720,1557,3,1718,'App\\Models\\Receipt',1718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-11','2024-10-11',4499.09,NULL,NULL,1,'2024-11-19 18:07:32','2024-11-19 18:07:32',NULL),(2176,7566,40720,1557,3,1706,'App\\Models\\Receipt',1706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-01','2024-10-01',14500.00,NULL,NULL,1,'2024-11-19 18:07:57','2024-11-19 18:07:57',NULL),(2177,7566,40720,1557,3,1734,'App\\Models\\Receipt',1734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-21','2024-09-21',3.50,NULL,NULL,1,'2024-11-19 18:10:36','2024-11-19 18:12:25','2024-11-19 18:12:25'),(2178,7566,40720,1557,3,1734,'App\\Models\\Receipt',1734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-09-21','2024-09-21',36190.49,NULL,NULL,1,'2024-11-19 18:12:25','2024-11-19 18:12:25',NULL),(2179,7566,40720,1557,3,1711,'App\\Models\\Receipt',1711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-03','2024-10-03',45998.11,NULL,NULL,1,'2024-11-19 18:13:47','2024-11-19 18:13:47',NULL),(2180,7566,40720,1557,3,1735,'App\\Models\\Receipt',1735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',36000.00,NULL,NULL,1,'2024-11-19 18:29:11','2024-11-19 18:29:11',NULL),(2181,7566,40720,1557,3,1736,'App\\Models\\Receipt',1736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-11','2024-10-11',10099.99,NULL,NULL,1,'2024-11-19 18:29:44','2024-11-19 18:29:44',NULL),(2182,7566,40720,1557,3,1737,'App\\Models\\Receipt',1737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',10800.00,NULL,NULL,1,'2024-11-19 18:30:11','2024-11-19 18:30:11',NULL),(2183,7566,40720,1557,3,1738,'App\\Models\\Receipt',1738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-30','2024-10-30',22599.99,NULL,NULL,1,'2024-11-19 18:30:33','2024-11-19 18:30:33',NULL),(2184,7566,40720,1557,3,1739,'App\\Models\\Receipt',1739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-26','2024-10-26',35000.98,NULL,NULL,1,'2024-11-19 18:31:20','2024-11-19 18:31:20',NULL),(2185,7566,40720,1557,3,1740,'App\\Models\\Receipt',1740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-27','2024-10-27',14400.00,NULL,NULL,1,'2024-11-19 18:32:02','2024-11-19 18:32:02',NULL),(2186,7566,40720,1557,3,1741,'App\\Models\\Receipt',1741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-08','2024-10-08',38300.00,NULL,NULL,1,'2024-11-19 18:32:32','2024-11-19 18:32:32',NULL),(2187,7566,40720,1557,3,1742,'App\\Models\\Receipt',1742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-11','2024-10-11',225060.00,NULL,NULL,1,'2024-11-19 18:33:04','2024-11-19 18:33:04',NULL),(2188,7566,40720,1557,3,1743,'App\\Models\\Receipt',1743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-16','2024-10-16',260150.00,NULL,NULL,1,'2024-11-19 18:33:46','2024-11-19 18:33:46',NULL),(2189,7566,40720,1557,3,1744,'App\\Models\\Receipt',1744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-21','2024-10-21',381150.00,NULL,NULL,1,'2024-11-19 18:34:24','2024-11-19 18:34:24',NULL),(2190,7566,40720,1557,3,1745,'App\\Models\\Receipt',1745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-13','2024-10-13',42044.65,NULL,NULL,1,'2024-11-19 18:35:30','2024-11-19 18:35:30',NULL),(2191,7566,40720,1557,7,1746,'App\\Models\\Receipt',1746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-31','2024-10-31',12450.34,NULL,NULL,1,'2024-11-19 18:38:09','2024-11-19 18:38:09',NULL),(2192,7566,40720,1557,7,1747,'App\\Models\\Receipt',1747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-29','2024-10-29',10735.77,NULL,NULL,1,'2024-11-19 18:38:09','2024-11-19 18:38:09',NULL);
INSERT INTO `balance_libro` VALUES (2193,7566,40720,1557,7,1748,'App\\Models\\Receipt',1748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-23','2024-10-23',4775.93,NULL,NULL,1,'2024-11-19 18:38:09','2024-11-19 18:38:09',NULL),(2194,7566,40720,1557,7,1749,'App\\Models\\Receipt',1749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-22','2024-10-22',522.38,NULL,NULL,1,'2024-11-19 18:38:09','2024-11-19 18:38:09',NULL),(2195,7566,40720,1557,7,1750,'App\\Models\\Receipt',1750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-21','2024-10-21',661.50,NULL,NULL,1,'2024-11-19 18:38:09','2024-11-19 18:38:09',NULL),(2196,7566,40720,1557,7,1751,'App\\Models\\Receipt',1751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-18','2024-10-18',13820.70,NULL,NULL,1,'2024-11-19 18:38:09','2024-11-19 18:38:09',NULL),(2197,7566,40720,1557,7,1752,'App\\Models\\Receipt',1752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-17','2024-10-17',6139.26,NULL,NULL,1,'2024-11-19 18:38:09','2024-11-19 18:38:09',NULL),(2198,7566,40720,1557,7,1753,'App\\Models\\Receipt',1753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-16','2024-10-16',546.91,NULL,NULL,1,'2024-11-19 18:38:09','2024-11-19 18:38:09',NULL),(2199,7566,40720,1557,7,1754,'App\\Models\\Receipt',1754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-15','2024-10-15',519.07,NULL,NULL,1,'2024-11-19 18:38:09','2024-11-19 18:38:09',NULL),(2200,7566,40720,1557,7,1755,'App\\Models\\Receipt',1755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-14','2024-10-14',3126.54,NULL,NULL,1,'2024-11-19 18:38:09','2024-11-19 18:38:09',NULL),(2201,7566,40720,1557,7,1756,'App\\Models\\Receipt',1756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-10','2024-10-10',10019.75,NULL,NULL,1,'2024-11-19 18:38:09','2024-11-19 18:38:09',NULL),(2202,7566,40720,1557,7,1757,'App\\Models\\Receipt',1757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-09','2024-10-09',3074.66,NULL,NULL,1,'2024-11-19 18:38:09','2024-11-19 18:38:09',NULL),(2203,7566,40720,1557,7,1758,'App\\Models\\Receipt',1758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-08','2024-10-08',1070.76,NULL,NULL,1,'2024-11-19 18:38:09','2024-11-19 18:38:09',NULL),(2204,7566,40720,1557,7,1759,'App\\Models\\Receipt',1759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-08','2024-10-08',38426.64,NULL,NULL,1,'2024-11-19 18:38:09','2024-11-19 18:38:09',NULL),(2205,7566,40720,1557,7,1760,'App\\Models\\Receipt',1760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-07','2024-10-07',356.68,NULL,NULL,1,'2024-11-19 18:38:09','2024-11-19 18:38:09',NULL),(2206,7566,40720,1557,7,1761,'App\\Models\\Receipt',1761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-04','2024-10-04',8433.81,NULL,NULL,1,'2024-11-19 18:38:09','2024-11-19 18:38:09',NULL),(2207,7566,40720,1557,7,1762,'App\\Models\\Receipt',1762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-03','2024-10-03',4114.64,NULL,NULL,1,'2024-11-19 18:38:09','2024-11-19 18:38:09',NULL),(2208,7566,40720,1557,7,1763,'App\\Models\\Receipt',1763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-03','2024-10-03',5146.09,NULL,NULL,1,'2024-11-19 18:38:10','2024-11-19 18:38:10',NULL),(2209,7566,40720,1557,7,1764,'App\\Models\\Receipt',1764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-02','2024-10-02',11016.75,NULL,NULL,1,'2024-11-19 18:38:10','2024-11-19 18:38:10',NULL),(2210,7566,40720,1557,3,1713,'App\\Models\\Receipt',1713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-04','2024-10-04',20000.00,NULL,NULL,1,'2024-11-19 18:53:47','2024-11-19 18:53:47',NULL),(2211,7566,40720,1557,3,1729,'App\\Models\\Receipt',1729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-26','2024-10-26',6147.74,NULL,NULL,1,'2024-11-21 17:29:47','2024-11-22 18:44:29','2024-11-22 18:44:29'),(2212,7566,40720,1557,3,1729,'App\\Models\\Receipt',1729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-26','2024-10-26',6147.74,NULL,NULL,1,'2024-11-22 18:44:29','2024-11-22 18:44:29',NULL),(2213,7566,40720,1557,3,1723,'App\\Models\\Receipt',1723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-18','2024-10-18',76300.00,NULL,NULL,1,'2024-11-22 20:08:44','2024-11-22 20:08:44',NULL);
INSERT INTO `balance_libro` VALUES (2214,7566,40720,1559,2,1765,'App\\Models\\Receipt',1765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-01','2024-11-01',35042.28,NULL,NULL,1,'2024-12-13 16:17:38','2024-12-13 16:24:16','2024-12-13 16:24:16'),(2215,7566,40720,1559,2,1766,'App\\Models\\Receipt',1766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-01','2024-11-01',934750.51,NULL,NULL,1,'2024-12-13 16:17:39','2024-12-13 16:24:02','2024-12-13 16:24:02'),(2216,7566,40720,1559,2,1767,'App\\Models\\Receipt',1767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-04','2024-11-04',13090.02,NULL,NULL,1,'2024-12-13 16:17:39','2024-12-13 16:23:54','2024-12-13 16:23:54'),(2217,7566,40720,1559,2,1768,'App\\Models\\Receipt',1768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-04','2024-11-04',934672.97,NULL,NULL,1,'2024-12-13 16:17:39','2024-12-13 16:23:47','2024-12-13 16:23:47'),(2218,7566,40720,1559,2,1769,'App\\Models\\Receipt',1769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-04','2024-11-04',47975.10,NULL,NULL,1,'2024-12-13 16:17:39','2024-12-13 16:23:39','2024-12-13 16:23:39'),(2219,7566,40720,1559,2,1770,'App\\Models\\Receipt',1770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-11','2024-11-11',7712.06,NULL,NULL,1,'2024-12-13 16:17:39','2024-12-13 16:23:30','2024-12-13 16:23:30'),(2220,7566,40720,1559,2,1771,'App\\Models\\Receipt',1771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-16','2024-11-16',1796734.42,NULL,NULL,1,'2024-12-13 16:17:39','2024-12-13 16:23:23','2024-12-13 16:23:23'),(2221,7566,40720,1559,2,1772,'App\\Models\\Receipt',1772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-25','2024-11-25',17705.54,NULL,NULL,1,'2024-12-13 16:17:39','2024-12-13 16:22:42','2024-12-13 16:22:42'),(2222,7566,40720,1559,2,1773,'App\\Models\\Receipt',1773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',17336.78,NULL,NULL,1,'2024-12-13 16:17:39','2024-12-13 16:22:31','2024-12-13 16:22:31'),(2223,7566,40720,1558,3,1774,'App\\Models\\Receipt',1774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-01','2024-11-01',15000.00,NULL,NULL,1,'2024-12-13 16:21:33','2024-12-13 16:21:33',NULL),(2224,7566,40720,1558,3,1775,'App\\Models\\Receipt',1775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-01','2024-11-01',40500.00,NULL,NULL,1,'2024-12-13 16:21:33','2024-12-13 16:21:33',NULL),(2225,7566,40720,1558,3,1776,'App\\Models\\Receipt',1776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-01','2024-11-01',121000.00,NULL,NULL,1,'2024-12-13 16:21:33','2024-12-13 16:21:33',NULL),(2226,7566,40720,1558,3,1777,'App\\Models\\Receipt',1777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-01','2024-11-01',151798.00,NULL,NULL,1,'2024-12-13 16:21:33','2024-12-13 17:35:37','2024-12-13 17:35:37'),(2227,7566,40720,1558,3,1778,'App\\Models\\Receipt',1778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-02','2024-11-02',26660.00,NULL,NULL,1,'2024-12-13 16:21:34','2024-12-13 16:21:34',NULL),(2228,7566,40720,1558,3,1779,'App\\Models\\Receipt',1779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-03','2024-11-03',48900.99,NULL,NULL,1,'2024-12-13 16:21:34','2024-12-13 17:31:26','2024-12-13 17:31:26'),(2229,7566,40720,1558,3,1780,'App\\Models\\Receipt',1780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-04','2024-11-04',42000.00,NULL,NULL,1,'2024-12-13 16:21:34','2024-12-13 16:21:34',NULL),(2230,7566,40720,1558,3,1781,'App\\Models\\Receipt',1781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-05','2024-11-05',27600.00,NULL,NULL,1,'2024-12-13 16:21:34','2024-12-13 16:21:34',NULL),(2231,7566,40720,1558,3,1782,'App\\Models\\Receipt',1782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-05','2024-11-05',6900.00,NULL,NULL,1,'2024-12-13 16:21:34','2024-12-13 16:21:34',NULL),(2232,7566,40720,1558,3,1783,'App\\Models\\Receipt',1783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-06','2024-11-06',26500.00,NULL,NULL,1,'2024-12-13 16:21:34','2024-12-13 16:21:34',NULL),(2233,7566,40720,1558,3,1784,'App\\Models\\Receipt',1784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-07','2024-11-07',7000.00,NULL,NULL,1,'2024-12-13 16:21:34','2024-12-13 16:21:34',NULL);
INSERT INTO `balance_libro` VALUES (2234,7566,40720,1558,3,1785,'App\\Models\\Receipt',1785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-09','2024-11-09',46800.00,NULL,NULL,1,'2024-12-13 16:21:35','2024-12-13 16:21:35',NULL),(2235,7566,40720,1558,3,1786,'App\\Models\\Receipt',1786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-10','2024-11-10',54700.00,NULL,NULL,1,'2024-12-13 16:21:35','2024-12-13 16:21:35',NULL),(2236,7566,40720,1558,3,1787,'App\\Models\\Receipt',1787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-12','2024-11-12',157294.85,NULL,NULL,1,'2024-12-13 16:21:35','2024-12-13 16:26:25','2024-12-13 16:26:25'),(2237,7566,40720,1558,3,1788,'App\\Models\\Receipt',1788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-13','2024-11-13',10500.00,NULL,NULL,1,'2024-12-13 16:21:35','2024-12-13 16:21:35',NULL),(2238,7566,40720,1558,3,1789,'App\\Models\\Receipt',1789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-16','2024-11-16',27735.77,NULL,NULL,1,'2024-12-13 16:21:35','2024-12-13 17:25:43','2024-12-13 17:25:43'),(2239,7566,40720,1558,3,1790,'App\\Models\\Receipt',1790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-16','2024-11-16',76300.00,NULL,NULL,1,'2024-12-13 16:21:35','2024-12-13 16:21:35',NULL),(2240,7566,40720,1558,3,1791,'App\\Models\\Receipt',1791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-20','2024-11-20',29700.00,NULL,NULL,1,'2024-12-13 16:21:35','2024-12-13 16:21:35',NULL),(2241,7566,40720,1558,3,1792,'App\\Models\\Receipt',1792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-21','2024-11-21',41058.41,NULL,NULL,1,'2024-12-13 16:21:35','2024-12-13 17:28:16','2024-12-13 17:28:16'),(2242,7566,40720,1558,3,1793,'App\\Models\\Receipt',1793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-22','2024-11-22',23700.00,NULL,NULL,1,'2024-12-13 16:21:36','2024-12-13 16:21:36',NULL),(2243,7566,40720,1558,3,1794,'App\\Models\\Receipt',1794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-23','2024-11-23',41266.02,NULL,NULL,1,'2024-12-13 16:21:36','2024-12-13 17:26:32','2024-12-13 17:26:32'),(2244,7566,40720,1558,3,1795,'App\\Models\\Receipt',1795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-25','2024-11-25',5999.00,NULL,NULL,1,'2024-12-13 16:21:36','2024-12-13 17:23:25','2024-12-13 17:23:25'),(2245,7566,40720,1558,3,1796,'App\\Models\\Receipt',1796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-26','2024-11-26',10500.00,NULL,NULL,1,'2024-12-13 16:21:36','2024-12-13 16:21:36',NULL),(2246,7566,40720,1558,3,1797,'App\\Models\\Receipt',1797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-26','2024-11-26',1791.92,NULL,NULL,1,'2024-12-13 16:21:36','2024-12-13 18:10:21','2024-12-13 18:10:21'),(2247,7566,40720,1558,3,1798,'App\\Models\\Receipt',1798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-28','2024-11-28',14400.00,NULL,NULL,1,'2024-12-13 16:21:36','2024-12-13 16:21:36',NULL),(2248,7566,40720,1558,3,1799,'App\\Models\\Receipt',1799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',10500.00,NULL,NULL,1,'2024-12-13 16:21:36','2024-12-13 16:21:36',NULL),(2249,7566,40720,1558,3,1800,'App\\Models\\Receipt',1800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',23688.01,NULL,NULL,1,'2024-12-13 16:21:36','2024-12-13 17:27:05','2024-12-13 17:27:05'),(2250,7566,40720,1558,2,1801,'App\\Models\\Receipt',1801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-01','2024-11-01',35042.28,NULL,NULL,1,'2024-12-13 16:24:59','2024-12-13 16:42:50','2024-12-13 16:42:50'),(2251,7566,40720,1558,2,1802,'App\\Models\\Receipt',1802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-01','2024-11-01',934750.51,NULL,NULL,1,'2024-12-13 16:24:59','2024-12-13 16:43:55','2024-12-13 16:43:55'),(2252,7566,40720,1558,2,1803,'App\\Models\\Receipt',1803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-04','2024-11-04',13090.02,NULL,NULL,1,'2024-12-13 16:24:59','2024-12-13 16:44:52','2024-12-13 16:44:52'),(2253,7566,40720,1558,2,1804,'App\\Models\\Receipt',1804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-04','2024-11-04',934672.97,NULL,NULL,1,'2024-12-13 16:25:00','2024-12-13 16:25:00',NULL);
INSERT INTO `balance_libro` VALUES (2254,7566,40720,1558,2,1805,'App\\Models\\Receipt',1805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-04','2024-11-04',47975.10,NULL,NULL,1,'2024-12-13 16:25:00','2024-12-13 16:25:00',NULL),(2255,7566,40720,1558,2,1806,'App\\Models\\Receipt',1806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-11','2024-11-11',7712.06,NULL,NULL,1,'2024-12-13 16:25:00','2024-12-13 16:45:55','2024-12-13 16:45:55'),(2256,7566,40720,1558,2,1807,'App\\Models\\Receipt',1807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-16','2024-11-16',1796734.42,NULL,NULL,1,'2024-12-13 16:25:00','2024-12-13 16:25:00',NULL),(2257,7566,40720,1558,2,1808,'App\\Models\\Receipt',1808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-25','2024-11-25',17705.54,NULL,NULL,1,'2024-12-13 16:25:00','2024-12-13 16:46:41','2024-12-13 16:46:41'),(2258,7566,40720,1558,2,1809,'App\\Models\\Receipt',1809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',17336.78,NULL,NULL,1,'2024-12-13 16:25:00','2024-12-13 16:47:12','2024-12-13 16:47:12'),(2259,7566,40720,1558,7,1810,'App\\Models\\Receipt',1810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',920.94,NULL,NULL,1,'2024-12-13 16:35:56','2024-12-13 16:35:56',NULL),(2260,7566,40720,1558,7,1811,'App\\Models\\Receipt',1811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-26','2024-11-26',6004.49,NULL,NULL,1,'2024-12-13 16:35:56','2024-12-13 16:35:56',NULL),(2261,7566,40720,1558,7,1812,'App\\Models\\Receipt',1812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-26','2024-11-26',2458.29,NULL,NULL,1,'2024-12-13 16:35:56','2024-12-13 16:35:56',NULL),(2262,7566,40720,1558,7,1813,'App\\Models\\Receipt',1813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-25','2024-11-25',6746.94,NULL,NULL,1,'2024-12-13 16:35:56','2024-12-13 16:35:56',NULL),(2263,7566,40720,1558,7,1814,'App\\Models\\Receipt',1814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-21','2024-11-21',6602.57,NULL,NULL,1,'2024-12-13 16:35:56','2024-12-13 16:35:56',NULL),(2264,7566,40720,1558,7,1815,'App\\Models\\Receipt',1815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-20','2024-11-20',15873.05,NULL,NULL,1,'2024-12-13 16:35:56','2024-12-13 16:35:56',NULL),(2265,7566,40720,1558,7,1816,'App\\Models\\Receipt',1816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-19','2024-11-19',1082.65,NULL,NULL,1,'2024-12-13 16:35:56','2024-12-13 16:35:56',NULL),(2266,7566,40720,1558,7,1817,'App\\Models\\Receipt',1817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-14','2024-11-14',542.30,NULL,NULL,1,'2024-12-13 16:35:57','2024-12-13 16:35:57',NULL),(2267,7566,40720,1558,7,1818,'App\\Models\\Receipt',1818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-13','2024-11-13',5984.39,NULL,NULL,1,'2024-12-13 16:35:57','2024-12-13 16:35:57',NULL),(2268,7566,40720,1558,7,1819,'App\\Models\\Receipt',1819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-12','2024-11-12',3253.34,NULL,NULL,1,'2024-12-13 16:35:57','2024-12-13 16:35:57',NULL),(2269,7566,40720,1558,7,1820,'App\\Models\\Receipt',1820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-12','2024-11-12',1070.76,NULL,NULL,1,'2024-12-13 16:35:57','2024-12-13 16:35:57',NULL),(2270,7566,40720,1558,7,1821,'App\\Models\\Receipt',1821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-11','2024-11-11',10939.11,NULL,NULL,1,'2024-12-13 16:35:57','2024-12-13 16:35:57',NULL),(2271,7566,40720,1558,7,1822,'App\\Models\\Receipt',1822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-08','2024-11-08',33230.96,NULL,NULL,1,'2024-12-13 16:35:57','2024-12-13 16:35:57',NULL),(2272,7566,40720,1558,7,1823,'App\\Models\\Receipt',1823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-07','2024-11-07',2197.42,NULL,NULL,1,'2024-12-13 16:35:57','2024-12-13 16:35:57',NULL),(2273,7566,40720,1558,7,1824,'App\\Models\\Receipt',1824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-06','2024-11-06',8997.34,NULL,NULL,1,'2024-12-13 16:35:57','2024-12-13 16:35:57',NULL);
INSERT INTO `balance_libro` VALUES (2274,7566,40720,1558,7,1825,'App\\Models\\Receipt',1825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-04','2024-11-04',20484.33,NULL,NULL,1,'2024-12-13 16:35:57','2024-12-13 16:35:57',NULL),(2275,7566,40720,1558,7,1826,'App\\Models\\Receipt',1826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-04','2024-11-04',4865.37,NULL,NULL,1,'2024-12-13 16:35:57','2024-12-13 16:35:57',NULL),(2276,7566,40720,1558,7,1827,'App\\Models\\Receipt',1827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-01','2024-11-01',839.13,NULL,NULL,1,'2024-12-13 16:35:57','2024-12-13 16:35:57',NULL),(2277,7566,40720,1558,2,1801,'App\\Models\\Receipt',1801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-01','2024-11-01',35042.30,NULL,NULL,1,'2024-12-13 16:42:50','2024-12-13 16:43:16','2024-12-13 16:43:16'),(2278,7566,40720,1558,2,1801,'App\\Models\\Receipt',1801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-01','2024-11-01',35042.28,NULL,NULL,1,'2024-12-13 16:43:16','2024-12-13 16:43:16',NULL),(2279,7566,40720,1558,2,1802,'App\\Models\\Receipt',1802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-01','2024-11-01',934750.51,NULL,NULL,1,'2024-12-13 16:43:55','2024-12-13 16:44:23','2024-12-13 16:44:23'),(2280,7566,40720,1558,2,1802,'App\\Models\\Receipt',1802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-01','2024-11-01',934750.51,NULL,NULL,1,'2024-12-13 16:44:23','2024-12-13 16:44:23',NULL),(2281,7566,40720,1558,2,1803,'App\\Models\\Receipt',1803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-04','2024-11-04',13090.03,NULL,NULL,1,'2024-12-13 16:44:52','2024-12-13 16:45:05','2024-12-13 16:45:05'),(2282,7566,40720,1558,2,1803,'App\\Models\\Receipt',1803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-04','2024-11-04',13090.02,NULL,NULL,1,'2024-12-13 16:45:05','2024-12-13 16:45:05',NULL),(2283,7566,40720,1558,2,1806,'App\\Models\\Receipt',1806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-11','2024-11-11',7712.06,NULL,NULL,1,'2024-12-13 16:45:55','2024-12-13 16:45:55',NULL),(2284,7566,40720,1558,2,1808,'App\\Models\\Receipt',1808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-25','2024-11-25',17705.54,NULL,NULL,1,'2024-12-13 16:46:41','2024-12-13 16:46:41',NULL),(2285,7566,40720,1558,2,1809,'App\\Models\\Receipt',1809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-29','2024-11-29',17336.78,NULL,NULL,1,'2024-12-13 16:47:12','2024-12-13 16:47:12',NULL),(2286,7566,40720,1558,3,1795,'App\\Models\\Receipt',1795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-25','2024-11-25',6147.74,NULL,NULL,1,'2024-12-13 17:23:25','2024-12-13 17:23:25',NULL),(2287,7566,40720,1558,3,1789,'App\\Models\\Receipt',1789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-16','2024-11-16',27735.77,NULL,NULL,1,'2024-12-13 17:25:43','2024-12-13 17:25:43',NULL),(2288,7566,40720,1558,3,1794,'App\\Models\\Receipt',1794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-23','2024-11-23',41266.02,NULL,NULL,1,'2024-12-13 17:26:32','2024-12-13 17:26:32',NULL),(2289,7566,40720,1558,3,1800,'App\\Models\\Receipt',1800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-30','2024-11-30',23688.01,NULL,NULL,1,'2024-12-13 17:27:05','2024-12-13 17:27:05',NULL),(2290,7566,40720,1558,3,1828,'App\\Models\\Receipt',1828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-10-21','2024-10-21',41058.41,NULL,NULL,1,'2024-12-13 17:29:47','2024-12-13 17:29:47',NULL),(2291,7566,40720,1558,3,1779,'App\\Models\\Receipt',1779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-03','2024-11-03',48900.99,NULL,NULL,1,'2024-12-13 17:31:26','2024-12-13 17:31:26',NULL),(2292,7566,40720,1559,2,1829,'App\\Models\\Receipt',1829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-01','2024-12-01',901533.54,NULL,NULL,1,'2025-01-18 11:24:08','2025-01-18 11:37:21','2025-01-18 11:37:21'),(2293,7566,40720,1559,2,1830,'App\\Models\\Receipt',1830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-04','2024-12-04',13053.93,NULL,NULL,1,'2025-01-18 11:24:08','2025-01-18 11:37:53','2025-01-18 11:37:53');
INSERT INTO `balance_libro` VALUES (2294,7566,40720,1559,2,1831,'App\\Models\\Receipt',1831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-04','2024-12-04',890927.02,NULL,NULL,1,'2025-01-18 11:24:08','2025-01-18 11:40:09','2025-01-18 11:40:09'),(2295,7566,40720,1559,2,1832,'App\\Models\\Receipt',1832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-11','2024-12-11',7712.08,NULL,NULL,1,'2025-01-18 11:24:08','2025-01-18 11:46:11','2025-01-18 11:46:11'),(2296,7566,40720,1559,2,1833,'App\\Models\\Receipt',1833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-17','2024-12-17',1898596.55,NULL,NULL,1,'2025-01-18 11:24:08','2025-01-18 11:40:41','2025-01-18 11:40:41'),(2297,7566,40720,1559,3,1834,'App\\Models\\Receipt',1834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-01','2024-12-01',901533.54,NULL,NULL,1,'2025-01-18 11:24:24','2025-01-18 11:55:00','2025-01-18 11:55:00'),(2298,7566,40720,1559,3,1835,'App\\Models\\Receipt',1835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-04','2024-12-04',13053.93,NULL,NULL,1,'2025-01-18 11:24:24','2025-01-18 11:55:13','2025-01-18 11:55:13'),(2299,7566,40720,1559,3,1836,'App\\Models\\Receipt',1836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-04','2024-12-04',890927.02,NULL,NULL,1,'2025-01-18 11:24:24','2025-01-18 11:54:38','2025-01-18 11:54:38'),(2300,7566,40720,1559,3,1837,'App\\Models\\Receipt',1837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-11','2024-12-11',7712.08,NULL,NULL,1,'2025-01-18 11:24:24','2025-01-18 11:54:20','2025-01-18 11:54:20'),(2301,7566,40720,1559,3,1838,'App\\Models\\Receipt',1838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-17','2024-12-17',1898596.55,NULL,NULL,1,'2025-01-18 11:24:24','2025-01-18 11:53:56','2025-01-18 11:53:56'),(2302,7566,40720,1559,3,1839,'App\\Models\\Receipt',1839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-01','2024-12-01',15400.00,NULL,NULL,1,'2025-01-18 11:24:34','2025-01-18 11:24:34',NULL),(2303,7566,40720,1559,3,1840,'App\\Models\\Receipt',1840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-01','2024-12-01',157294.85,NULL,NULL,1,'2025-01-18 11:24:34','2025-01-18 11:51:31','2025-01-18 11:51:31'),(2304,7566,40720,1559,3,1841,'App\\Models\\Receipt',1841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-02','2024-12-02',14000.00,NULL,NULL,1,'2025-01-18 11:24:34','2025-01-18 11:24:34',NULL),(2305,7566,40720,1559,3,1842,'App\\Models\\Receipt',1842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-02','2024-12-02',121000.00,NULL,NULL,1,'2025-01-18 11:24:34','2025-01-18 11:24:34',NULL),(2306,7566,40720,1559,3,1843,'App\\Models\\Receipt',1843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-03','2024-12-03',10500.00,NULL,NULL,1,'2025-01-18 11:24:34','2025-01-18 11:24:34',NULL),(2307,7566,40720,1559,3,1844,'App\\Models\\Receipt',1844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-03','2024-12-03',51842.88,NULL,NULL,1,'2025-01-18 11:24:34','2025-01-18 12:28:34','2025-01-18 12:28:34'),(2308,7566,40720,1559,3,1845,'App\\Models\\Receipt',1845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-08','2024-12-08',66971.42,NULL,NULL,1,'2025-01-18 11:24:34','2025-01-18 12:23:42','2025-01-18 12:23:42'),(2309,7566,40720,1559,3,1846,'App\\Models\\Receipt',1846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-09','2024-12-09',13500.00,NULL,NULL,1,'2025-01-18 11:24:34','2025-01-18 11:24:34',NULL),(2310,7566,40720,1559,3,1847,'App\\Models\\Receipt',1847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-10','2024-12-10',10500.00,NULL,NULL,1,'2025-01-18 11:24:34','2025-01-18 11:24:34',NULL),(2311,7566,40720,1559,3,1848,'App\\Models\\Receipt',1848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-11','2024-12-11',13500.00,NULL,NULL,1,'2025-01-18 11:24:35','2025-01-18 11:24:35',NULL),(2312,7566,40720,1559,3,1849,'App\\Models\\Receipt',1849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-13','2024-12-13',14100.00,NULL,NULL,1,'2025-01-18 11:24:35','2025-01-18 11:24:35',NULL),(2313,7566,40720,1559,3,1850,'App\\Models\\Receipt',1850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-16','2024-12-16',98307.52,NULL,NULL,1,'2025-01-18 11:24:35','2025-01-18 12:22:58','2025-01-18 12:22:58');
INSERT INTO `balance_libro` VALUES (2314,7566,40720,1559,3,1851,'App\\Models\\Receipt',1851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-19','2024-12-19',28200.00,NULL,NULL,1,'2025-01-18 11:24:35','2025-01-18 12:17:36','2025-01-18 12:17:36'),(2315,7566,40720,1559,3,1852,'App\\Models\\Receipt',1852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-21','2024-12-21',44142.83,NULL,NULL,1,'2025-01-18 11:24:35','2025-01-18 12:26:03','2025-01-18 12:26:03'),(2316,7566,40720,1559,3,1853,'App\\Models\\Receipt',1853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-26','2024-12-26',119000.00,NULL,NULL,1,'2025-01-18 11:24:35','2025-01-18 12:32:31','2025-01-18 12:32:31'),(2317,7566,40720,1559,3,1854,'App\\Models\\Receipt',1854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-28','2024-12-28',64975.72,NULL,NULL,1,'2025-01-18 11:24:35','2025-01-18 12:22:09','2025-01-18 12:22:09'),(2318,7566,40720,1559,3,1855,'App\\Models\\Receipt',1855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-29','2024-12-29',8300.83,NULL,NULL,1,'2025-01-18 11:24:35','2025-01-18 12:20:49','2025-01-18 12:20:49'),(2319,7566,40720,1559,3,1856,'App\\Models\\Receipt',1856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-30','2024-12-30',7000.00,NULL,NULL,1,'2025-01-18 11:24:35','2025-01-18 11:24:35',NULL),(2320,7566,40720,1559,3,1857,'App\\Models\\Receipt',1857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-30','2024-12-30',4864.99,NULL,NULL,1,'2025-01-18 11:24:35','2025-01-18 12:20:08','2025-01-18 12:20:08'),(2321,7566,40720,1559,2,1829,'App\\Models\\Receipt',1829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-01','2024-12-01',901533.54,NULL,NULL,1,'2025-01-18 11:37:21','2025-01-18 11:46:38','2025-01-18 11:46:38'),(2322,7566,40720,1559,2,1830,'App\\Models\\Receipt',1830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-04','2024-12-04',13053.93,NULL,NULL,1,'2025-01-18 11:37:53','2025-01-18 11:46:32','2025-01-18 11:46:32'),(2323,7566,40720,1559,2,1831,'App\\Models\\Receipt',1831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-04','2024-12-04',890927.02,NULL,NULL,1,'2025-01-18 11:40:09','2025-01-18 11:46:24','2025-01-18 11:46:24'),(2324,7566,40720,1559,2,1833,'App\\Models\\Receipt',1833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-17','2024-12-17',1898596.55,NULL,NULL,1,'2025-01-18 11:40:41','2025-01-18 11:45:59','2025-01-18 11:45:59'),(2325,7566,40720,1559,7,1858,'App\\Models\\Receipt',1858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-30','2024-12-30',16728.86,NULL,NULL,1,'2025-01-18 11:45:20','2025-01-18 11:45:20',NULL),(2326,7566,40720,1559,7,1859,'App\\Models\\Receipt',1859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-26','2024-12-26',2093.60,NULL,NULL,1,'2025-01-18 11:45:20','2025-01-18 11:45:20',NULL),(2327,7566,40720,1559,7,1860,'App\\Models\\Receipt',1860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-23','2024-12-23',3371.48,NULL,NULL,1,'2025-01-18 11:45:20','2025-01-18 11:45:20',NULL),(2328,7566,40720,1559,7,1861,'App\\Models\\Receipt',1861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-20','2024-12-20',13828.95,NULL,NULL,1,'2025-01-18 11:45:20','2025-01-18 11:45:20',NULL),(2329,7566,40720,1559,7,1862,'App\\Models\\Receipt',1862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-19','2024-12-19',21582.20,NULL,NULL,1,'2025-01-18 11:45:20','2025-01-18 11:45:20',NULL),(2330,7566,40720,1559,7,1863,'App\\Models\\Receipt',1863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-18','2024-12-18',633.11,NULL,NULL,1,'2025-01-18 11:45:20','2025-01-18 11:45:20',NULL),(2331,7566,40720,1559,7,1864,'App\\Models\\Receipt',1864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-17','2024-12-17',10833.19,NULL,NULL,1,'2025-01-18 11:45:20','2025-01-18 11:45:20',NULL),(2332,7566,40720,1559,7,1865,'App\\Models\\Receipt',1865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-13','2024-12-13',3678.98,NULL,NULL,1,'2025-01-18 11:45:20','2025-01-18 11:45:20',NULL),(2333,7566,40720,1559,7,1866,'App\\Models\\Receipt',1866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-12','2024-12-12',1070.77,NULL,NULL,1,'2025-01-18 11:45:20','2025-01-18 11:45:20',NULL);
INSERT INTO `balance_libro` VALUES (2334,7566,40720,1559,7,1867,'App\\Models\\Receipt',1867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-12','2024-12-12',13048.40,NULL,NULL,1,'2025-01-18 11:45:20','2025-01-18 11:45:20',NULL),(2335,7566,40720,1559,7,1868,'App\\Models\\Receipt',1868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-11','2024-12-11',848.48,NULL,NULL,1,'2025-01-18 11:45:20','2025-01-18 11:45:20',NULL),(2336,7566,40720,1559,7,1869,'App\\Models\\Receipt',1869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-10','2024-12-10',12213.27,NULL,NULL,1,'2025-01-18 11:45:20','2025-01-18 11:45:20',NULL),(2337,7566,40720,1559,7,1870,'App\\Models\\Receipt',1870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-06','2024-12-06',16287.12,NULL,NULL,1,'2025-01-18 11:45:20','2025-01-18 11:45:20',NULL),(2338,7566,40720,1559,7,1871,'App\\Models\\Receipt',1871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-05','2024-12-05',24746.27,NULL,NULL,1,'2025-01-18 11:45:20','2025-01-18 11:45:20',NULL),(2339,7566,40720,1559,7,1872,'App\\Models\\Receipt',1872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-04','2024-12-04',14091.98,NULL,NULL,1,'2025-01-18 11:45:20','2025-01-18 11:45:20',NULL),(2340,7566,40720,1559,7,1873,'App\\Models\\Receipt',1873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-03','2024-12-03',14155.40,NULL,NULL,1,'2025-01-18 11:45:20','2025-01-18 11:45:20',NULL),(2341,7566,40720,1559,7,1874,'App\\Models\\Receipt',1874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-02','2024-12-02',2407.09,NULL,NULL,1,'2025-01-18 11:45:20','2025-01-18 11:45:20',NULL),(2342,7566,40720,1559,7,1875,'App\\Models\\Receipt',1875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-02','2024-12-02',19298.59,NULL,NULL,1,'2025-01-18 11:45:21','2025-01-18 11:45:21',NULL),(2343,7566,40720,1559,2,1876,'App\\Models\\Receipt',1876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-01','2024-12-01',901533.54,NULL,NULL,1,'2025-01-18 11:48:05','2025-01-18 11:50:20','2025-01-18 11:50:20'),(2344,7566,40720,1559,2,1877,'App\\Models\\Receipt',1877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-04','2024-12-04',13053.93,NULL,NULL,1,'2025-01-18 11:48:05','2025-01-18 11:50:00','2025-01-18 11:50:00'),(2345,7566,40720,1559,2,1878,'App\\Models\\Receipt',1878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-04','2024-12-04',890927.02,NULL,NULL,1,'2025-01-18 11:48:05','2025-01-18 11:49:40','2025-01-18 11:49:40'),(2346,7566,40720,1559,2,1879,'App\\Models\\Receipt',1879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-11','2024-12-11',7712.08,NULL,NULL,1,'2025-01-18 11:48:05','2025-01-18 11:49:22','2025-01-18 11:49:22'),(2347,7566,40720,1559,2,1880,'App\\Models\\Receipt',1880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-17','2024-12-17',1898596.55,NULL,NULL,1,'2025-01-18 11:48:05','2025-01-18 11:48:47','2025-01-18 11:48:47'),(2348,7566,40720,1559,2,1880,'App\\Models\\Receipt',1880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-17','2024-12-17',1898596.55,NULL,NULL,1,'2025-01-18 11:48:47','2025-01-18 11:48:47',NULL),(2349,7566,40720,1559,2,1879,'App\\Models\\Receipt',1879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-11','2024-12-11',7712.08,NULL,NULL,1,'2025-01-18 11:49:22','2025-01-18 11:49:22',NULL),(2350,7566,40720,1559,2,1878,'App\\Models\\Receipt',1878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-04','2024-12-04',890927.02,NULL,NULL,1,'2025-01-18 11:49:40','2025-01-18 11:49:40',NULL),(2351,7566,40720,1559,2,1877,'App\\Models\\Receipt',1877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-04','2024-12-04',13053.93,NULL,NULL,1,'2025-01-18 11:50:00','2025-01-18 11:50:00',NULL),(2352,7566,40720,1559,2,1876,'App\\Models\\Receipt',1876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-01','2024-12-01',901533.54,NULL,NULL,1,'2025-01-18 11:50:20','2025-01-18 11:50:20',NULL),(2353,7566,40720,1559,3,1881,'App\\Models\\Receipt',1881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-01','2024-11-01',144900.00,NULL,NULL,1,'2025-01-18 11:58:14','2025-01-18 11:58:14',NULL);
INSERT INTO `balance_libro` VALUES (2354,7566,40720,1559,3,1882,'App\\Models\\Receipt',1882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-07','2024-12-07',41021.00,NULL,NULL,1,'2025-01-18 11:59:06','2025-01-18 11:59:06',NULL),(2355,7566,40720,1559,3,1883,'App\\Models\\Receipt',1883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-18','2024-11-18',12870.00,NULL,NULL,1,'2025-01-18 12:00:34','2025-01-18 12:00:34',NULL),(2356,7566,40720,1559,3,1884,'App\\Models\\Receipt',1884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-18','2024-11-18',4700.00,NULL,NULL,1,'2025-01-18 12:02:37','2025-01-18 12:02:37',NULL),(2357,7566,40720,1559,3,1885,'App\\Models\\Receipt',1885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-20','2024-11-20',10500.00,NULL,NULL,1,'2025-01-18 12:03:09','2025-01-18 12:03:09',NULL),(2358,7566,40720,1559,3,1886,'App\\Models\\Receipt',1886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-08','2024-11-08',15300.00,NULL,NULL,1,'2025-01-18 12:03:46','2025-01-18 12:03:46',NULL),(2359,7566,40720,1559,3,1887,'App\\Models\\Receipt',1887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-15','2024-12-15',4700.00,NULL,NULL,1,'2025-01-18 12:04:34','2025-01-18 12:04:34',NULL),(2360,7566,40720,1559,3,1888,'App\\Models\\Receipt',1888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-14','2024-12-14',28900.00,NULL,NULL,1,'2025-01-18 12:05:19','2025-01-18 12:05:19',NULL),(2361,7566,40720,1559,3,1889,'App\\Models\\Receipt',1889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-20','2024-12-20',396880.00,NULL,NULL,1,'2025-01-18 12:07:08','2025-01-18 12:07:08',NULL),(2362,7566,40720,1559,3,1890,'App\\Models\\Receipt',1890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-12','2024-12-12',471900.00,NULL,NULL,1,'2025-01-18 12:07:30','2025-01-18 12:07:30',NULL),(2363,7566,40720,1559,3,1891,'App\\Models\\Receipt',1891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-13','2024-12-13',51700.00,NULL,NULL,1,'2025-01-18 12:08:05','2025-01-18 12:08:05',NULL),(2364,7566,40720,1559,3,1892,'App\\Models\\Receipt',1892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-20','2024-11-20',18950.00,NULL,NULL,1,'2025-01-18 12:08:41','2025-01-18 12:08:41',NULL),(2365,7566,40720,1559,3,1893,'App\\Models\\Receipt',1893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-15','2024-11-15',36199.99,NULL,NULL,1,'2025-01-18 12:09:02','2025-01-18 12:09:02',NULL),(2366,7566,40720,1559,3,1894,'App\\Models\\Receipt',1894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-14','2024-11-14',157300.00,NULL,NULL,1,'2025-01-18 12:11:10','2025-01-18 12:11:10',NULL),(2367,7566,40720,1559,3,1895,'App\\Models\\Receipt',1895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-08','2024-11-08',435600.00,NULL,NULL,1,'2025-01-18 12:11:41','2025-01-18 12:11:41',NULL),(2368,7566,40720,1559,3,1896,'App\\Models\\Receipt',1896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-20','2024-11-20',43006.95,NULL,NULL,1,'2025-01-18 12:12:55','2025-01-18 12:12:55',NULL),(2369,7566,40720,1559,3,1897,'App\\Models\\Receipt',1897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-08','2024-11-08',47279.39,NULL,NULL,1,'2025-01-18 12:13:59','2025-01-18 12:13:59',NULL),(2370,7566,40720,1559,3,1898,'App\\Models\\Receipt',1898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-21','2024-12-21',46376.66,NULL,NULL,1,'2025-01-18 12:14:42','2025-01-18 12:14:42',NULL),(2371,7566,40720,1559,3,1851,'App\\Models\\Receipt',1851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-19','2024-12-19',28200.00,NULL,NULL,1,'2025-01-18 12:17:36','2025-01-18 12:17:36',NULL),(2372,7566,40720,1559,3,1857,'App\\Models\\Receipt',1857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-30','2024-12-30',4864.99,NULL,NULL,1,'2025-01-18 12:20:08','2025-01-18 12:20:08',NULL),(2373,7566,40720,1559,3,1855,'App\\Models\\Receipt',1855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-29','2024-12-29',8300.82,NULL,NULL,1,'2025-01-18 12:20:49','2025-01-18 12:20:49',NULL),(2374,7566,40720,1559,3,1854,'App\\Models\\Receipt',1854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-28','2024-12-28',64975.73,NULL,NULL,1,'2025-01-18 12:22:09','2025-01-18 12:22:09',NULL);
INSERT INTO `balance_libro` VALUES (2375,7566,40720,1559,3,1850,'App\\Models\\Receipt',1850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-16','2024-12-16',98307.51,NULL,NULL,1,'2025-01-18 12:22:58','2025-01-18 12:22:58',NULL),(2376,7566,40720,1559,3,1845,'App\\Models\\Receipt',1845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-08','2024-12-08',66971.41,NULL,NULL,1,'2025-01-18 12:23:42','2025-01-18 12:23:42',NULL),(2377,7566,40720,1559,3,1899,'App\\Models\\Receipt',1899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-11-21','2024-11-21',41058.41,NULL,NULL,1,'2025-01-18 12:27:24','2025-01-18 12:27:24',NULL),(2378,7566,40720,1559,3,1844,'App\\Models\\Receipt',1844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-03','2024-12-03',51842.88,NULL,NULL,1,'2025-01-18 12:28:34','2025-01-18 12:28:34',NULL),(2379,7566,40720,1559,3,1853,'App\\Models\\Receipt',1853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-26','2024-12-26',119000.00,NULL,NULL,1,'2025-01-18 12:32:31','2025-01-18 12:32:31',NULL),(2380,7566,40720,1559,8,1900,'App\\Models\\Receipt',1900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-18','2025-01-18',4716.95,NULL,NULL,1,'2025-01-18 12:49:46','2025-01-18 12:49:46',NULL),(2381,7566,40720,1559,8,1901,'App\\Models\\Receipt',1901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-18','2025-01-18',173281.76,NULL,NULL,1,'2025-01-18 12:49:46','2025-01-18 12:49:46',NULL),(2382,7566,40720,1563,2,1902,'App\\Models\\Receipt',1902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-01','2025-01-01',910253.66,NULL,NULL,1,'2025-02-19 19:29:35','2025-02-19 19:34:40','2025-02-19 19:34:40'),(2383,7566,40720,1563,2,1903,'App\\Models\\Receipt',1903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-02','2025-01-02',36314.86,NULL,NULL,1,'2025-02-19 19:29:35','2025-02-19 19:34:17','2025-02-19 19:34:17'),(2384,7566,40720,1563,2,1904,'App\\Models\\Receipt',1904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-06','2025-01-06',13643.62,NULL,NULL,1,'2025-02-19 19:29:35','2025-02-19 19:33:50','2025-02-19 19:33:50'),(2385,7566,40720,1563,2,1905,'App\\Models\\Receipt',1905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-06','2025-01-06',7648.85,NULL,NULL,1,'2025-02-19 19:29:35','2025-02-19 19:33:23','2025-02-19 19:33:23'),(2386,7566,40720,1563,2,1906,'App\\Models\\Receipt',1906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-06','2025-01-06',1350013.46,NULL,NULL,1,'2025-02-19 19:29:35','2025-02-19 19:32:42','2025-02-19 19:32:42'),(2387,7566,40720,1563,2,1907,'App\\Models\\Receipt',1907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-06','2025-01-06',47594.32,NULL,NULL,1,'2025-02-19 19:29:35','2025-02-19 19:29:35',NULL),(2388,7566,40720,1563,2,1908,'App\\Models\\Receipt',1908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-16','2025-01-16',1802916.58,NULL,NULL,1,'2025-02-19 19:29:35','2025-02-19 19:37:05','2025-02-19 19:37:05'),(2389,7566,40720,1563,3,1909,'App\\Models\\Receipt',1909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-01','2025-01-01',15800.00,NULL,NULL,1,'2025-02-19 19:29:50','2025-02-19 19:29:50',NULL),(2390,7566,40720,1563,3,1910,'App\\Models\\Receipt',1910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-01','2025-01-01',157294.85,NULL,NULL,1,'2025-02-19 19:29:50','2025-02-19 20:02:44','2025-02-19 20:02:44'),(2391,7566,40720,1563,3,1911,'App\\Models\\Receipt',1911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-02','2025-01-02',8205.86,NULL,NULL,1,'2025-02-19 19:29:50','2025-02-19 19:42:11','2025-02-19 19:42:11'),(2392,7566,40720,1563,3,1912,'App\\Models\\Receipt',1912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-03','2025-01-03',54745.76,NULL,NULL,1,'2025-02-19 19:29:50','2025-02-19 19:44:49','2025-02-19 19:44:49'),(2393,7566,40720,1563,3,1913,'App\\Models\\Receipt',1913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-04','2025-01-04',65676.23,NULL,NULL,1,'2025-02-19 19:29:50','2025-02-19 19:41:39','2025-02-19 19:41:39'),(2394,7566,40720,1563,3,1914,'App\\Models\\Receipt',1914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-06','2025-01-06',121000.00,NULL,NULL,1,'2025-02-19 19:29:50','2025-02-19 20:05:12','2025-02-19 20:05:12');
INSERT INTO `balance_libro` VALUES (2395,7566,40720,1563,3,1915,'App\\Models\\Receipt',1915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-09','2025-01-09',20700.00,NULL,NULL,1,'2025-02-19 19:29:50','2025-02-19 19:29:50',NULL),(2396,7566,40720,1563,3,1916,'App\\Models\\Receipt',1916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-09','2025-01-09',7998.93,NULL,NULL,1,'2025-02-19 19:29:50','2025-02-19 20:04:55','2025-02-19 20:04:55'),(2397,7566,40720,1563,3,1917,'App\\Models\\Receipt',1917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-14','2025-01-14',21800.00,NULL,NULL,1,'2025-02-19 19:29:50','2025-02-19 19:29:50',NULL),(2398,7566,40720,1563,3,1918,'App\\Models\\Receipt',1918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-21','2025-01-21',44142.83,NULL,NULL,1,'2025-02-19 19:29:50','2025-02-19 19:43:37','2025-02-19 19:43:37'),(2399,7566,40720,1563,3,1919,'App\\Models\\Receipt',1919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-23','2025-01-23',69112.50,NULL,NULL,1,'2025-02-19 19:29:50','2025-02-19 20:02:25','2025-02-19 20:02:25'),(2400,7566,40720,1563,3,1920,'App\\Models\\Receipt',1920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-27','2025-01-27',15921.44,NULL,NULL,1,'2025-02-19 19:29:50','2025-02-19 19:40:15','2025-02-19 19:40:15'),(2401,7566,40720,1563,3,1921,'App\\Models\\Receipt',1921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',15000.00,NULL,NULL,1,'2025-02-19 19:29:50','2025-02-19 19:29:50',NULL),(2402,7566,40720,1563,3,1922,'App\\Models\\Receipt',1922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',75650.00,NULL,NULL,1,'2025-02-19 19:29:50','2025-02-19 19:29:50',NULL),(2403,7566,40720,1563,7,1923,'App\\Models\\Receipt',1923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',1724.63,NULL,NULL,1,'2025-02-19 19:30:32','2025-02-19 19:30:32',NULL),(2404,7566,40720,1563,7,1924,'App\\Models\\Receipt',1924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-30','2025-01-30',10353.32,NULL,NULL,1,'2025-02-19 19:30:32','2025-02-19 19:30:32',NULL),(2405,7566,40720,1563,7,1925,'App\\Models\\Receipt',1925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-28','2025-01-28',3116.10,NULL,NULL,1,'2025-02-19 19:30:32','2025-02-19 19:30:32',NULL),(2406,7566,40720,1563,7,1926,'App\\Models\\Receipt',1926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-23','2025-01-23',2141.79,NULL,NULL,1,'2025-02-19 19:30:32','2025-02-19 19:30:32',NULL),(2407,7566,40720,1563,7,1927,'App\\Models\\Receipt',1927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-22','2025-01-22',7207.60,NULL,NULL,1,'2025-02-19 19:30:32','2025-02-19 19:30:32',NULL),(2408,7566,40720,1563,7,1928,'App\\Models\\Receipt',1928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-20','2025-01-20',24735.41,NULL,NULL,1,'2025-02-19 19:30:32','2025-02-19 19:30:32',NULL),(2409,7566,40720,1563,7,1929,'App\\Models\\Receipt',1929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-17','2025-01-17',1145.05,NULL,NULL,1,'2025-02-19 19:30:32','2025-02-19 19:30:32',NULL),(2410,7566,40720,1563,7,1930,'App\\Models\\Receipt',1930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-16','2025-01-16',3165.54,NULL,NULL,1,'2025-02-19 19:30:32','2025-02-19 19:30:32',NULL),(2411,7566,40720,1563,7,1931,'App\\Models\\Receipt',1931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-15','2025-01-15',722.11,NULL,NULL,1,'2025-02-19 19:30:32','2025-02-19 19:30:32',NULL),(2412,7566,40720,1563,7,1932,'App\\Models\\Receipt',1932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-14','2025-01-14',633.11,NULL,NULL,1,'2025-02-19 19:30:32','2025-02-19 19:30:32',NULL),(2413,7566,40720,1563,7,1933,'App\\Models\\Receipt',1933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-13','2025-01-13',17820.71,NULL,NULL,1,'2025-02-19 19:30:32','2025-02-19 19:30:32',NULL),(2414,7566,40720,1563,7,1934,'App\\Models\\Receipt',1934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-10','2025-01-10',6323.78,NULL,NULL,1,'2025-02-19 19:30:32','2025-02-19 19:30:32',NULL);
INSERT INTO `balance_libro` VALUES (2415,7566,40720,1563,7,1935,'App\\Models\\Receipt',1935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-09','2025-01-09',1006.66,NULL,NULL,1,'2025-02-19 19:30:32','2025-02-19 19:30:32',NULL),(2416,7566,40720,1563,7,1936,'App\\Models\\Receipt',1936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-08','2025-01-08',34165.03,NULL,NULL,1,'2025-02-19 19:30:32','2025-02-19 19:30:32',NULL),(2417,7566,40720,1563,7,1937,'App\\Models\\Receipt',1937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-07','2025-01-07',1061.99,NULL,NULL,1,'2025-02-19 19:30:32','2025-02-19 19:30:32',NULL),(2418,7566,40720,1563,7,1938,'App\\Models\\Receipt',1938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-07','2025-01-07',890.91,NULL,NULL,1,'2025-02-19 19:30:32','2025-02-19 19:30:32',NULL),(2419,7566,40720,1563,7,1939,'App\\Models\\Receipt',1939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-06','2025-01-06',18287.70,NULL,NULL,1,'2025-02-19 19:30:32','2025-02-19 19:30:32',NULL),(2420,7566,40720,1563,7,1940,'App\\Models\\Receipt',1940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-03','2025-01-03',5042.06,NULL,NULL,1,'2025-02-19 19:30:32','2025-02-19 19:30:32',NULL),(2421,7566,40720,1563,7,1941,'App\\Models\\Receipt',1941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-03','2025-01-03',16925.84,NULL,NULL,1,'2025-02-19 19:30:32','2025-02-19 19:30:32',NULL),(2422,7566,40720,1563,7,1942,'App\\Models\\Receipt',1942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-02','2025-01-02',1385.35,NULL,NULL,1,'2025-02-19 19:30:32','2025-02-19 19:30:32',NULL),(2423,7566,40720,1563,2,1906,'App\\Models\\Receipt',1906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-06','2025-01-06',1350013.46,NULL,NULL,1,'2025-02-19 19:32:42','2025-02-19 19:32:42',NULL),(2424,7566,40720,1563,2,1905,'App\\Models\\Receipt',1905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-06','2025-01-06',7648.85,NULL,NULL,1,'2025-02-19 19:33:23','2025-02-19 19:33:23',NULL),(2425,7566,40720,1563,2,1904,'App\\Models\\Receipt',1904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-06','2025-01-06',13643.62,NULL,NULL,1,'2025-02-19 19:33:50','2025-02-19 19:33:50',NULL),(2426,7566,40720,1563,2,1903,'App\\Models\\Receipt',1903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-02','2025-01-02',36314.86,NULL,NULL,1,'2025-02-19 19:34:17','2025-02-19 19:34:17',NULL),(2427,7566,40720,1563,2,1902,'App\\Models\\Receipt',1902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-01','2025-01-01',910253.66,NULL,NULL,1,'2025-02-19 19:34:40','2025-02-19 19:34:40',NULL),(2428,7566,40720,1563,2,1908,'App\\Models\\Receipt',1908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-16','2025-01-16',1802916.58,NULL,NULL,1,'2025-02-19 19:37:05','2025-02-19 19:37:05',NULL),(2429,7566,40720,1563,3,1920,'App\\Models\\Receipt',1920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-27','2025-01-27',15921.44,NULL,NULL,1,'2025-02-19 19:40:15','2025-02-20 20:03:04','2025-02-20 20:03:04'),(2430,7566,40720,1563,3,1913,'App\\Models\\Receipt',1913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-04','2025-01-04',65676.23,NULL,NULL,1,'2025-02-19 19:41:39','2025-02-20 20:02:28','2025-02-20 20:02:28'),(2431,7566,40720,1563,3,1911,'App\\Models\\Receipt',1911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-02','2025-01-02',8205.86,NULL,NULL,1,'2025-02-19 19:42:11','2025-02-20 20:01:56','2025-02-20 20:01:56'),(2432,7566,40720,1563,3,1912,'App\\Models\\Receipt',1912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-03','2025-01-03',54745.76,NULL,NULL,1,'2025-02-19 19:44:49','2025-02-20 20:04:27','2025-02-20 20:04:27'),(2433,7566,40720,1563,3,1943,'App\\Models\\Receipt',1943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2024-12-21','2024-12-21',44142.83,NULL,NULL,1,'2025-02-19 19:46:28','2025-02-19 19:46:28',NULL),(2434,7566,40720,1563,3,1919,'App\\Models\\Receipt',1919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-23','2025-01-23',69112.50,NULL,NULL,1,'2025-02-19 20:02:25','2025-02-19 20:02:25',NULL);
INSERT INTO `balance_libro` VALUES (2435,7566,40720,1563,3,1916,'App\\Models\\Receipt',1916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-09','2025-01-09',8197.25,NULL,NULL,1,'2025-02-19 20:04:55','2025-02-19 20:04:55',NULL),(2436,7566,40720,1563,3,1914,'App\\Models\\Receipt',1914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-06','2025-01-06',121000.00,NULL,NULL,1,'2025-02-19 20:05:12','2025-02-19 20:05:12',NULL),(2437,7566,40720,1563,3,1944,'App\\Models\\Receipt',1944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-16','2025-01-16',13300.00,NULL,NULL,1,'2025-02-19 20:07:58','2025-02-19 20:07:58',NULL),(2438,7566,40720,1563,3,1945,'App\\Models\\Receipt',1945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-16','2025-01-16',57400.00,NULL,NULL,1,'2025-02-19 20:08:51','2025-02-19 20:08:51',NULL),(2439,7566,40720,1563,3,1946,'App\\Models\\Receipt',1946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-31','2025-01-31',52001.94,NULL,NULL,1,'2025-02-19 20:09:51','2025-02-19 20:09:51',NULL),(2440,7566,40720,1563,3,1947,'App\\Models\\Receipt',1947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-18','2025-01-18',47895.94,NULL,NULL,1,'2025-02-19 20:10:39','2025-02-19 20:10:39',NULL),(2441,7566,40720,1563,3,1948,'App\\Models\\Receipt',1948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-04','2025-01-04',52427.74,NULL,NULL,1,'2025-02-19 20:11:26','2025-02-19 20:11:26',NULL),(2442,7566,40720,1563,8,1949,'App\\Models\\Receipt',1949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-19','2025-02-19',5015.88,NULL,NULL,1,'2025-02-19 20:21:24','2025-02-19 20:21:24',NULL),(2443,7566,40720,1563,8,1950,'App\\Models\\Receipt',1950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-19','2025-02-19',22200.02,NULL,NULL,1,'2025-02-19 20:21:24','2025-02-19 20:21:24',NULL),(2444,7566,40719,49,2,1951,'App\\Models\\Receipt',1951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-19','2025-02-19',32000.00,NULL,NULL,1,'2025-02-19 21:20:41','2025-02-19 21:20:41',NULL),(2445,7566,40720,1563,3,1911,'App\\Models\\Receipt',1911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-02','2025-01-02',8205.86,NULL,NULL,1,'2025-02-20 20:01:56','2025-02-20 20:02:42','2025-02-20 20:02:42'),(2446,7566,40720,1563,3,1913,'App\\Models\\Receipt',1913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-04','2025-01-04',65676.23,NULL,NULL,1,'2025-02-20 20:02:28','2025-02-20 20:02:28',NULL),(2447,7566,40720,1563,3,1911,'App\\Models\\Receipt',1911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-02','2025-01-02',8205.86,NULL,NULL,1,'2025-02-20 20:02:42','2025-02-20 20:02:42',NULL),(2448,7566,40720,1563,3,1920,'App\\Models\\Receipt',1920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-27','2025-01-27',15921.44,NULL,NULL,1,'2025-02-20 20:03:04','2025-02-20 20:03:04',NULL),(2449,7566,40720,1563,3,1912,'App\\Models\\Receipt',1912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-03','2025-01-03',56470.26,NULL,NULL,1,'2025-02-20 20:04:27','2025-02-20 20:07:48','2025-02-20 20:07:48'),(2450,7566,40720,1563,3,1912,'App\\Models\\Receipt',1912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-03','2025-01-03',54745.76,NULL,NULL,1,'2025-02-20 20:07:48','2025-02-20 20:09:08','2025-02-20 20:09:08'),(2451,7566,40720,1563,3,1912,'App\\Models\\Receipt',1912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-03','2025-01-03',54745.76,NULL,NULL,1,'2025-02-20 20:09:08','2025-02-20 20:09:08',NULL),(2452,NULL,40719,49,2,1952,'App\\Models\\Receipt',1952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',36000.00,NULL,NULL,1,'2025-03-05 20:45:09','2025-03-05 20:45:09',NULL),(2453,NULL,40719,49,2,1953,'App\\Models\\Receipt',1953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',77000.00,NULL,NULL,1,'2025-03-05 20:45:10','2025-03-05 20:45:10',NULL),(2454,NULL,40719,49,2,1954,'App\\Models\\Receipt',1954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',36000.00,NULL,NULL,1,'2025-03-05 20:45:12','2025-03-05 20:45:12',NULL);
INSERT INTO `balance_libro` VALUES (2455,NULL,40719,49,2,1955,'App\\Models\\Receipt',1955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',45200.00,NULL,NULL,1,'2025-03-05 20:45:13','2025-03-05 20:45:13',NULL),(2456,NULL,40719,49,2,1956,'App\\Models\\Receipt',1956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',36000.00,NULL,NULL,1,'2025-03-05 20:45:14','2025-03-05 20:45:14',NULL),(2457,NULL,40719,49,2,1957,'App\\Models\\Receipt',1957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',84000.00,NULL,NULL,1,'2025-03-05 20:45:15','2025-03-05 20:45:15',NULL),(2458,NULL,40719,49,2,1958,'App\\Models\\Receipt',1958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',255000.00,NULL,NULL,1,'2025-03-05 20:45:16','2025-03-05 20:45:16',NULL),(2459,NULL,40719,49,2,1959,'App\\Models\\Receipt',1959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',155500.44,NULL,NULL,1,'2025-03-05 20:45:18','2025-03-05 20:45:18',NULL),(2460,NULL,40719,49,2,1960,'App\\Models\\Receipt',1960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',45600.00,NULL,NULL,1,'2025-03-05 20:45:19','2025-03-05 20:45:19',NULL),(2461,NULL,40719,49,2,1961,'App\\Models\\Receipt',1961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',197000.00,NULL,NULL,1,'2025-03-05 20:45:20','2025-03-05 20:45:20',NULL),(2462,NULL,40719,49,2,1962,'App\\Models\\Receipt',1962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',42000.00,NULL,NULL,1,'2025-03-05 20:45:21','2025-03-05 20:45:21',NULL),(2463,NULL,40719,49,2,1963,'App\\Models\\Receipt',1963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',39000.00,NULL,NULL,1,'2025-03-05 20:45:22','2025-03-05 20:45:22',NULL),(2464,NULL,40719,49,2,1964,'App\\Models\\Receipt',1964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',39800.00,NULL,NULL,1,'2025-03-05 20:45:23','2025-03-05 20:45:23',NULL),(2465,NULL,40719,49,2,1965,'App\\Models\\Receipt',1965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',36000.00,NULL,NULL,1,'2025-03-05 20:45:25','2025-03-05 20:45:25',NULL),(2466,NULL,40719,49,2,1966,'App\\Models\\Receipt',1966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',155879.00,NULL,NULL,1,'2025-03-05 20:45:26','2025-03-05 20:45:26',NULL),(2467,NULL,40719,49,2,1967,'App\\Models\\Receipt',1967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',41100.00,NULL,NULL,1,'2025-03-05 20:45:27','2025-03-05 20:45:27',NULL),(2468,NULL,40719,49,2,1968,'App\\Models\\Receipt',1968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',36000.00,NULL,NULL,1,'2025-03-05 20:45:28','2025-03-05 20:45:28',NULL),(2469,NULL,40719,49,2,1969,'App\\Models\\Receipt',1969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',44500.00,NULL,NULL,1,'2025-03-05 20:45:29','2025-03-05 20:45:29',NULL),(2470,NULL,40719,49,2,1970,'App\\Models\\Receipt',1970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',42000.00,NULL,NULL,1,'2025-03-05 20:45:30','2025-03-05 20:45:30',NULL),(2471,NULL,40719,49,2,1971,'App\\Models\\Receipt',1971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',16000.00,NULL,NULL,1,'2025-03-05 20:45:31','2025-03-05 20:45:31',NULL),(2472,NULL,40719,49,2,1972,'App\\Models\\Receipt',1972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',36000.00,NULL,NULL,1,'2025-03-05 20:46:35','2025-03-05 20:46:35',NULL),(2473,NULL,40719,49,2,1973,'App\\Models\\Receipt',1973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',77000.00,NULL,NULL,1,'2025-03-05 20:46:36','2025-03-05 20:46:36',NULL),(2474,NULL,40719,49,2,1974,'App\\Models\\Receipt',1974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',36000.00,NULL,NULL,1,'2025-03-05 20:46:37','2025-03-05 20:46:37',NULL),(2475,NULL,40719,49,2,1975,'App\\Models\\Receipt',1975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',45200.00,NULL,NULL,1,'2025-03-05 20:46:38','2025-03-05 20:46:38',NULL);
INSERT INTO `balance_libro` VALUES (2476,NULL,40719,49,2,1976,'App\\Models\\Receipt',1976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',36000.00,NULL,NULL,1,'2025-03-05 20:46:39','2025-03-05 20:46:39',NULL),(2477,NULL,40719,49,2,1977,'App\\Models\\Receipt',1977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',84000.00,NULL,NULL,1,'2025-03-05 20:46:41','2025-03-05 20:46:41',NULL),(2478,NULL,40719,49,2,1978,'App\\Models\\Receipt',1978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',255000.00,NULL,NULL,1,'2025-03-05 20:46:42','2025-03-05 20:46:42',NULL),(2479,NULL,40719,49,2,1979,'App\\Models\\Receipt',1979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',155500.44,NULL,NULL,1,'2025-03-05 20:46:43','2025-03-05 20:46:43',NULL),(2480,NULL,40719,49,2,1980,'App\\Models\\Receipt',1980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',45600.00,NULL,NULL,1,'2025-03-05 20:46:44','2025-03-05 20:46:44',NULL),(2481,NULL,40719,49,2,1981,'App\\Models\\Receipt',1981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',197000.00,NULL,NULL,1,'2025-03-05 20:46:45','2025-03-05 20:46:45',NULL),(2482,NULL,40719,49,2,1982,'App\\Models\\Receipt',1982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',42000.00,NULL,NULL,1,'2025-03-05 20:46:46','2025-03-05 20:46:46',NULL),(2483,NULL,40719,49,2,1983,'App\\Models\\Receipt',1983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',39000.00,NULL,NULL,1,'2025-03-05 20:46:47','2025-03-05 20:46:47',NULL),(2484,NULL,40719,49,2,1984,'App\\Models\\Receipt',1984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',39800.00,NULL,NULL,1,'2025-03-05 20:46:48','2025-03-05 20:46:48',NULL),(2485,NULL,40719,49,2,1985,'App\\Models\\Receipt',1985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',36000.00,NULL,NULL,1,'2025-03-05 20:46:50','2025-03-05 20:46:50',NULL),(2486,NULL,40719,49,2,1986,'App\\Models\\Receipt',1986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',155879.00,NULL,NULL,1,'2025-03-05 20:46:51','2025-03-05 20:46:51',NULL),(2487,NULL,40719,49,2,1987,'App\\Models\\Receipt',1987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',41100.00,NULL,NULL,1,'2025-03-05 20:46:52','2025-03-05 20:46:52',NULL),(2488,NULL,40719,49,2,1988,'App\\Models\\Receipt',1988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',36000.00,NULL,NULL,1,'2025-03-05 20:46:53','2025-03-05 20:46:53',NULL),(2489,NULL,40719,49,2,1989,'App\\Models\\Receipt',1989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',44500.00,NULL,NULL,1,'2025-03-05 20:46:54','2025-03-05 20:46:54',NULL),(2490,NULL,40719,49,2,1990,'App\\Models\\Receipt',1990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',42000.00,NULL,NULL,1,'2025-03-05 20:46:55','2025-03-05 20:46:55',NULL),(2491,NULL,40719,49,2,1991,'App\\Models\\Receipt',1991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',16000.00,NULL,NULL,1,'2025-03-05 20:46:56','2025-03-05 20:46:56',NULL),(2492,7566,40719,49,2,1992,'App\\Models\\Receipt',1992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',36000.00,NULL,NULL,1,'2025-03-05 21:01:25','2025-03-05 21:03:17','2025-03-05 21:03:17'),(2493,7566,40719,49,2,1992,'App\\Models\\Receipt',1992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',36000.00,NULL,NULL,1,'2025-03-05 21:03:17','2025-03-05 21:04:25','2025-03-05 21:04:25'),(2494,7566,40719,49,2,1992,'App\\Models\\Receipt',1992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',36000.00,NULL,NULL,1,'2025-03-05 21:04:25','2025-03-23 17:44:57','2025-03-23 17:44:57'),(2495,7566,40719,49,2,1993,'App\\Models\\Receipt',1993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',77000.00,NULL,NULL,1,'2025-03-05 21:17:29','2025-03-05 21:23:22','2025-03-05 21:23:22');
INSERT INTO `balance_libro` VALUES (2496,7566,40719,49,2,1994,'App\\Models\\Receipt',1994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',36000.00,NULL,NULL,1,'2025-03-05 21:19:26','2025-03-05 21:21:06','2025-03-05 21:21:06'),(2497,7566,40719,49,2,1995,'App\\Models\\Receipt',1995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',45200.00,NULL,NULL,1,'2025-03-05 21:20:27','2025-03-05 21:24:01','2025-03-05 21:24:01'),(2498,7566,40719,49,2,1994,'App\\Models\\Receipt',1994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',36000.00,NULL,NULL,1,'2025-03-05 21:21:06','2025-03-05 21:23:36','2025-03-05 21:23:36'),(2499,7566,40719,49,2,1996,'App\\Models\\Receipt',1996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',36000.00,NULL,NULL,1,'2025-03-05 21:22:45','2025-03-05 21:24:21','2025-03-05 21:24:21'),(2500,7566,40719,49,2,1993,'App\\Models\\Receipt',1993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',77000.00,NULL,NULL,1,'2025-03-05 21:23:22','2025-03-23 17:44:57','2025-03-23 17:44:57'),(2501,7566,40719,49,2,1994,'App\\Models\\Receipt',1994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',36000.00,NULL,NULL,1,'2025-03-05 21:23:36','2025-03-23 17:44:46','2025-03-23 17:44:46'),(2502,7566,40719,49,2,1995,'App\\Models\\Receipt',1995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',45200.00,NULL,NULL,1,'2025-03-05 21:24:01','2025-03-23 17:44:46','2025-03-23 17:44:46'),(2503,7566,40719,49,2,1996,'App\\Models\\Receipt',1996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',36000.00,NULL,NULL,1,'2025-03-05 21:24:21','2025-03-23 17:44:46','2025-03-23 17:44:46'),(2504,7566,40719,49,2,1997,'App\\Models\\Receipt',1997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',255000.00,NULL,NULL,1,'2025-03-10 17:00:45','2025-03-23 17:44:46','2025-03-23 17:44:46'),(2505,7566,40719,49,2,1998,'App\\Models\\Receipt',1998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',84000.00,NULL,NULL,1,'2025-03-10 17:01:40','2025-03-23 17:44:46','2025-03-23 17:44:46'),(2506,7566,40719,49,2,1999,'App\\Models\\Receipt',1999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',155500.44,NULL,NULL,1,'2025-03-10 17:02:36','2025-03-23 17:44:46','2025-03-23 17:44:46'),(2507,7566,40719,49,2,2000,'App\\Models\\Receipt',2000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',45600.00,NULL,NULL,1,'2025-03-10 17:03:20','2025-03-23 17:44:46','2025-03-23 17:44:46'),(2508,7566,40719,49,2,2001,'App\\Models\\Receipt',2001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',197000.00,NULL,NULL,1,'2025-03-10 17:04:16','2025-03-23 17:44:24','2025-03-23 17:44:24'),(2509,7566,40719,49,2,2002,'App\\Models\\Receipt',2002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',42000.00,NULL,NULL,1,'2025-03-10 17:04:57','2025-03-23 17:44:24','2025-03-23 17:44:24'),(2510,7566,40719,49,2,2003,'App\\Models\\Receipt',2003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',39000.00,NULL,NULL,1,'2025-03-10 17:05:27','2025-03-23 17:44:24','2025-03-23 17:44:24'),(2511,7566,40719,49,2,2004,'App\\Models\\Receipt',2004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',39800.00,NULL,NULL,1,'2025-03-10 17:06:12','2025-03-23 17:44:24','2025-03-23 17:44:24'),(2512,7566,40719,49,2,2005,'App\\Models\\Receipt',2005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',36000.00,NULL,NULL,1,'2025-03-10 17:06:56','2025-03-23 17:44:24','2025-03-23 17:44:24'),(2513,7566,40719,49,2,2006,'App\\Models\\Receipt',2006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',155879.00,NULL,NULL,1,'2025-03-10 17:08:08','2025-03-23 17:44:24','2025-03-23 17:44:24'),(2514,7566,40719,49,2,2007,'App\\Models\\Receipt',2007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',41100.00,NULL,NULL,1,'2025-03-10 17:08:45','2025-03-23 17:44:24','2025-03-23 17:44:24');
INSERT INTO `balance_libro` VALUES (2515,7566,40719,49,2,2008,'App\\Models\\Receipt',2008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',36000.00,NULL,NULL,1,'2025-03-10 17:09:21','2025-03-23 17:44:10','2025-03-23 17:44:10'),(2516,7566,40719,49,2,2009,'App\\Models\\Receipt',2009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',44500.00,NULL,NULL,1,'2025-03-10 17:10:02','2025-03-23 17:44:10','2025-03-23 17:44:10'),(2517,7566,40719,49,2,2010,'App\\Models\\Receipt',2010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',42000.00,NULL,NULL,1,'2025-03-10 17:10:39','2025-03-23 17:44:10','2025-03-23 17:44:10'),(2518,7566,40719,49,2,2011,'App\\Models\\Receipt',2011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',16000.00,NULL,NULL,1,'2025-03-10 17:11:30','2025-03-23 17:44:10','2025-03-23 17:44:10'),(2519,7566,40719,49,2,2012,'App\\Models\\Receipt',2012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',77000.00,NULL,NULL,1,'2025-03-10 17:41:17','2025-03-23 17:43:57','2025-03-23 17:43:57'),(2520,7566,40719,49,2,2013,'App\\Models\\Receipt',2013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',77000.00,NULL,NULL,1,'2025-03-10 17:47:32','2025-03-23 17:43:26','2025-03-23 17:43:26'),(2521,7566,40720,1564,2,2014,'App\\Models\\Receipt',2014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-01','2025-02-01',1125701.36,NULL,NULL,1,'2025-03-20 17:47:01','2025-03-20 18:00:18','2025-03-20 18:00:18'),(2522,7566,40720,1564,2,2015,'App\\Models\\Receipt',2015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-06','2025-02-06',1092965.91,NULL,NULL,1,'2025-03-20 17:47:01','2025-03-20 17:57:42','2025-03-20 17:57:42'),(2523,7566,40720,1564,2,2016,'App\\Models\\Receipt',2016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-06','2025-02-06',36314.90,NULL,NULL,1,'2025-03-20 17:47:01','2025-03-20 17:59:46','2025-03-20 17:59:46'),(2524,7566,40720,1564,2,2017,'App\\Models\\Receipt',2017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-06','2025-02-06',19796.14,NULL,NULL,1,'2025-03-20 17:47:01','2025-03-20 17:58:45','2025-03-20 17:58:45'),(2525,7566,40720,1564,2,2018,'App\\Models\\Receipt',2018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-10','2025-02-10',8098.89,NULL,NULL,1,'2025-03-20 17:47:01','2025-03-20 17:57:01','2025-03-20 17:57:01'),(2526,7566,40720,1564,2,2019,'App\\Models\\Receipt',2019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-15','2025-02-15',1909223.78,NULL,NULL,1,'2025-03-20 17:47:01','2025-03-20 17:53:55','2025-03-20 17:53:55'),(2527,7566,40720,1564,2,2020,'App\\Models\\Receipt',2020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',20592.11,NULL,NULL,1,'2025-03-20 17:47:01','2025-03-20 17:53:18','2025-03-20 17:53:18'),(2528,7566,40720,1564,3,2021,'App\\Models\\Receipt',2021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-01','2025-02-01',16300.00,NULL,NULL,1,'2025-03-20 17:47:27','2025-03-20 17:47:27',NULL),(2529,7566,40720,1564,3,2022,'App\\Models\\Receipt',2022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-01','2025-02-01',53137.16,NULL,NULL,1,'2025-03-20 17:47:28','2025-03-20 18:31:39','2025-03-20 18:31:39'),(2530,7566,40720,1564,3,2023,'App\\Models\\Receipt',2023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-03','2025-02-03',57139.06,NULL,NULL,1,'2025-03-20 17:47:28','2025-03-20 18:34:48','2025-03-20 18:34:48'),(2531,7566,40720,1564,3,2024,'App\\Models\\Receipt',2024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-03','2025-02-03',134243.45,NULL,NULL,1,'2025-03-20 17:47:28','2025-03-20 17:47:28',NULL),(2532,7566,40720,1564,3,2025,'App\\Models\\Receipt',2025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-07','2025-02-07',19300.00,NULL,NULL,1,'2025-03-20 17:47:28','2025-03-20 17:47:28',NULL),(2533,7566,40720,1564,3,2026,'App\\Models\\Receipt',2026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-08','2025-02-08',7998.93,NULL,NULL,1,'2025-03-20 17:47:28','2025-03-20 19:36:47','2025-03-20 19:36:47');
INSERT INTO `balance_libro` VALUES (2534,7566,40720,1564,3,2027,'App\\Models\\Receipt',2027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-09','2025-02-09',81900.00,NULL,NULL,1,'2025-03-20 17:47:28','2025-03-20 18:39:20','2025-03-20 18:39:20'),(2535,7566,40720,1564,3,2028,'App\\Models\\Receipt',2028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-13','2025-02-13',36536.25,NULL,NULL,1,'2025-03-20 17:47:28','2025-03-20 18:30:05','2025-03-20 18:30:05'),(2536,7566,40720,1564,3,2029,'App\\Models\\Receipt',2029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-15','2025-02-15',77350.00,NULL,NULL,1,'2025-03-20 17:47:28','2025-03-20 17:47:28',NULL),(2537,7566,40720,1564,3,2030,'App\\Models\\Receipt',2030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-15','2025-02-15',27000.00,NULL,NULL,1,'2025-03-20 17:47:28','2025-03-20 17:47:28',NULL),(2538,7566,40720,1564,3,2031,'App\\Models\\Receipt',2031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-20','2025-02-20',20700.00,NULL,NULL,1,'2025-03-20 17:47:28','2025-03-20 17:47:28',NULL),(2539,7566,40720,1564,3,2032,'App\\Models\\Receipt',2032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-21','2025-02-21',92452.00,NULL,NULL,1,'2025-03-20 17:47:28','2025-03-20 18:37:27','2025-03-20 18:37:27'),(2540,7566,40720,1564,3,2033,'App\\Models\\Receipt',2033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-21','2025-02-21',44142.83,NULL,NULL,1,'2025-03-20 17:47:28','2025-03-20 18:35:26','2025-03-20 18:35:26'),(2541,7566,40720,1564,3,2034,'App\\Models\\Receipt',2034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-22','2025-02-22',30324.41,NULL,NULL,1,'2025-03-20 17:47:28','2025-03-20 18:33:05','2025-03-20 18:33:05'),(2542,7566,40720,1564,3,2035,'App\\Models\\Receipt',2035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-23','2025-02-23',14186.97,NULL,NULL,1,'2025-03-20 17:47:28','2025-03-20 18:26:11','2025-03-20 18:26:11'),(2543,7566,40720,1564,3,2036,'App\\Models\\Receipt',2036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',255000.00,NULL,NULL,1,'2025-03-20 17:47:28','2025-03-20 17:47:28',NULL),(2544,7566,40720,1564,3,2037,'App\\Models\\Receipt',2037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',255000.00,NULL,NULL,1,'2025-03-20 17:47:28','2025-03-20 17:47:28',NULL),(2545,7566,40720,1564,2,2020,'App\\Models\\Receipt',2020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',20592.11,NULL,NULL,1,'2025-03-20 17:53:18','2025-03-20 17:53:18',NULL),(2546,7566,40720,1564,2,2019,'App\\Models\\Receipt',2019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-15','2025-02-15',1909223.78,NULL,NULL,1,'2025-03-20 17:53:55','2025-03-20 17:53:55',NULL),(2547,7566,40720,1564,2,2018,'App\\Models\\Receipt',2018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-10','2025-02-10',8098.89,NULL,NULL,1,'2025-03-20 17:57:01','2025-03-20 17:57:01',NULL),(2548,7566,40720,1564,2,2015,'App\\Models\\Receipt',2015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-06','2025-02-06',1092965.91,NULL,NULL,1,'2025-03-20 17:57:42','2025-03-20 17:57:42',NULL),(2549,7566,40720,1564,2,2017,'App\\Models\\Receipt',2017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-06','2025-02-06',19796.14,NULL,NULL,1,'2025-03-20 17:58:45','2025-03-20 17:58:45',NULL),(2550,7566,40720,1564,2,2016,'App\\Models\\Receipt',2016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-06','2025-02-06',36314.90,NULL,NULL,1,'2025-03-20 17:59:46','2025-03-20 17:59:46',NULL),(2551,7566,40720,1564,2,2014,'App\\Models\\Receipt',2014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-01','2025-02-01',1125701.36,NULL,NULL,1,'2025-03-20 18:00:18','2025-03-20 18:00:18',NULL),(2552,7566,40720,1564,3,2035,'App\\Models\\Receipt',2035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-23','2025-02-23',14186.97,NULL,NULL,1,'2025-03-20 18:26:11','2025-03-20 18:26:11',NULL),(2553,7566,40720,1564,3,2028,'App\\Models\\Receipt',2028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-13','2025-02-13',36536.26,NULL,NULL,1,'2025-03-20 18:30:05','2025-03-20 18:30:05',NULL);
INSERT INTO `balance_libro` VALUES (2554,7566,40720,1564,3,2022,'App\\Models\\Receipt',2022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-01','2025-02-01',53137.16,NULL,NULL,1,'2025-03-20 18:31:39','2025-03-20 18:31:39',NULL),(2555,7566,40720,1564,3,2034,'App\\Models\\Receipt',2034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-22','2025-02-22',30324.41,NULL,NULL,1,'2025-03-20 18:33:05','2025-03-20 18:33:05',NULL),(2556,7566,40720,1564,3,2023,'App\\Models\\Receipt',2023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-03','2025-02-03',57139.06,NULL,NULL,1,'2025-03-20 18:34:48','2025-03-20 18:34:48',NULL),(2557,7566,40720,1564,3,2033,'App\\Models\\Receipt',2033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-21','2025-02-21',44142.83,NULL,NULL,1,'2025-03-20 18:35:26','2025-03-20 18:47:42','2025-03-20 18:47:42'),(2558,7566,40720,1564,3,2032,'App\\Models\\Receipt',2032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-21','2025-02-21',92452.00,NULL,NULL,1,'2025-03-20 18:37:27','2025-03-20 18:37:27',NULL),(2559,7566,40720,1564,3,2027,'App\\Models\\Receipt',2027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-09','2025-02-09',81900.00,NULL,NULL,1,'2025-03-20 18:39:20','2025-03-20 18:39:20',NULL),(2560,7566,40720,1564,3,2033,'App\\Models\\Receipt',2033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-21','2025-01-21',44142.83,NULL,NULL,1,'2025-03-20 18:47:42','2025-03-20 18:48:07','2025-03-20 18:48:07'),(2561,7566,40720,1564,3,2033,'App\\Models\\Receipt',2033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-21','2025-01-21',44142.83,NULL,NULL,1,'2025-03-20 18:48:07','2025-03-23 12:18:15','2025-03-23 12:18:15'),(2562,7566,40720,1564,3,2038,'App\\Models\\Receipt',2038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-13','2025-02-13',48890.00,NULL,NULL,1,'2025-03-20 18:50:04','2025-03-20 18:50:04',NULL),(2563,7566,40720,1564,3,2039,'App\\Models\\Receipt',2039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-02','2025-02-02',8849.99,NULL,NULL,1,'2025-03-20 18:51:27','2025-03-20 18:51:27',NULL),(2564,7566,40720,1564,3,2040,'App\\Models\\Receipt',2040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-17','2025-02-17',23099.99,NULL,NULL,1,'2025-03-20 18:51:58','2025-03-20 18:51:58',NULL),(2565,7566,40720,1564,3,2041,'App\\Models\\Receipt',2041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-12','2025-02-12',68274.96,NULL,NULL,1,'2025-03-20 18:52:54','2025-03-20 18:55:16','2025-03-20 18:55:16'),(2566,7566,40720,1564,3,2042,'App\\Models\\Receipt',2042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-27','2025-02-27',56003.04,NULL,NULL,1,'2025-03-20 18:53:51','2025-03-20 18:53:51',NULL),(2567,7566,40720,1564,3,2041,'App\\Models\\Receipt',2041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-12','2025-02-12',68274.96,NULL,NULL,1,'2025-03-20 18:55:16','2025-03-20 18:55:16',NULL),(2568,7566,40720,1564,3,2026,'App\\Models\\Receipt',2026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-08','2025-02-08',8197.25,NULL,NULL,1,'2025-03-20 19:36:47','2025-03-20 19:36:47',NULL),(2569,7566,40720,1564,7,2043,'App\\Models\\Receipt',2043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-28','2025-02-28',2193.72,NULL,NULL,1,'2025-03-20 19:37:59','2025-03-20 19:37:59',NULL),(2570,7566,40720,1564,7,2044,'App\\Models\\Receipt',2044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-27','2025-02-27',632.42,NULL,NULL,1,'2025-03-20 19:38:00','2025-03-20 19:38:00',NULL),(2571,7566,40720,1564,7,2045,'App\\Models\\Receipt',2045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-25','2025-02-25',29629.97,NULL,NULL,1,'2025-03-20 19:38:00','2025-03-20 19:38:00',NULL),(2572,7566,40720,1564,7,2046,'App\\Models\\Receipt',2046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-24','2025-02-24',3324.71,NULL,NULL,1,'2025-03-20 19:38:00','2025-03-20 19:38:00',NULL),(2573,7566,40720,1564,7,2047,'App\\Models\\Receipt',2047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-20','2025-02-20',10496.29,NULL,NULL,1,'2025-03-20 19:38:00','2025-03-20 19:38:00',NULL);
INSERT INTO `balance_libro` VALUES (2574,7566,40720,1564,7,2048,'App\\Models\\Receipt',2048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-19','2025-02-19',3156.45,NULL,NULL,1,'2025-03-20 19:38:00','2025-03-20 19:38:00',NULL),(2575,7566,40720,1564,7,2049,'App\\Models\\Receipt',2049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-14','2025-02-14',4021.42,NULL,NULL,1,'2025-03-20 19:38:00','2025-03-20 19:38:00',NULL),(2576,7566,40720,1564,7,2050,'App\\Models\\Receipt',2050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-13','2025-02-13',4669.72,NULL,NULL,1,'2025-03-20 19:38:00','2025-03-20 19:38:00',NULL),(2577,7566,40720,1564,7,2051,'App\\Models\\Receipt',2051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-12','2025-02-12',11311.74,NULL,NULL,1,'2025-03-20 19:38:00','2025-03-20 19:38:00',NULL),(2578,7566,40720,1564,7,2052,'App\\Models\\Receipt',2052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-11','2025-02-11',1124.47,NULL,NULL,1,'2025-03-20 19:38:00','2025-03-20 19:38:00',NULL),(2579,7566,40720,1564,7,2053,'App\\Models\\Receipt',2053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-11','2025-02-11',515.46,NULL,NULL,1,'2025-03-20 19:38:00','2025-03-20 19:38:00',NULL),(2580,7566,40720,1564,7,2054,'App\\Models\\Receipt',2054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-10','2025-02-10',2285.98,NULL,NULL,1,'2025-03-20 19:38:00','2025-03-20 19:38:00',NULL),(2581,7566,40720,1564,7,2055,'App\\Models\\Receipt',2055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-07','2025-02-07',5042.07,NULL,NULL,1,'2025-03-20 19:38:00','2025-03-20 19:38:00',NULL),(2582,7566,40720,1564,7,2056,'App\\Models\\Receipt',2056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-07','2025-02-07',18142.59,NULL,NULL,1,'2025-03-20 19:38:00','2025-03-20 19:38:00',NULL),(2583,7566,40720,1564,7,2057,'App\\Models\\Receipt',2057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-06','2025-02-06',33443.10,NULL,NULL,1,'2025-03-20 19:38:00','2025-03-20 19:38:00',NULL),(2584,7566,40720,1564,7,2058,'App\\Models\\Receipt',2058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-05','2025-02-05',9089.07,NULL,NULL,1,'2025-03-20 19:38:00','2025-03-20 19:38:00',NULL),(2585,7566,40720,1564,7,2059,'App\\Models\\Receipt',2059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-04','2025-02-04',12624.47,NULL,NULL,1,'2025-03-20 19:38:00','2025-03-20 19:38:00',NULL),(2586,7566,40720,1564,7,2060,'App\\Models\\Receipt',2060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-03','2025-02-03',7886.09,NULL,NULL,1,'2025-03-20 19:38:00','2025-03-20 19:38:00',NULL),(2587,7566,40720,1564,3,2033,'App\\Models\\Receipt',2033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-01-21','2025-01-21',44142.83,NULL,NULL,1,'2025-03-23 12:18:15','2025-03-23 12:21:34','2025-03-23 12:21:34'),(2588,7566,40720,1564,3,2033,'App\\Models\\Receipt',2033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-05','2025-02-05',44142.83,NULL,NULL,1,'2025-03-23 12:21:34','2025-03-23 12:21:34',NULL),(2589,7566,40719,50,2,2061,'App\\Models\\Receipt',2061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-23','2025-03-23',36000.00,NULL,NULL,1,'2025-03-23 17:57:03','2025-03-23 17:57:03',NULL),(2590,7566,40719,50,2,2062,'App\\Models\\Receipt',2062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-23','2025-03-23',77000.00,NULL,NULL,1,'2025-03-23 18:01:42','2025-03-23 18:01:42',NULL),(2591,7566,40719,50,2,2063,'App\\Models\\Receipt',2063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-23','2025-03-23',36000.00,NULL,NULL,1,'2025-03-23 18:07:20','2025-03-23 18:07:20',NULL),(2592,7566,40719,50,2,2064,'App\\Models\\Receipt',2064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-23','2025-03-23',45200.00,NULL,NULL,1,'2025-03-23 18:31:53','2025-03-23 18:31:53',NULL),(2593,7566,40719,50,2,2065,'App\\Models\\Receipt',2065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-23','2025-03-23',36000.00,NULL,NULL,1,'2025-03-23 18:33:51','2025-03-23 18:33:51',NULL),(2594,7566,40719,50,2,2066,'App\\Models\\Receipt',2066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-23','2025-03-23',84000.00,NULL,NULL,1,'2025-03-23 18:34:56','2025-03-23 18:34:56',NULL);
INSERT INTO `balance_libro` VALUES (2595,7566,40719,50,2,2067,'App\\Models\\Receipt',2067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-23','2025-03-23',255000.00,NULL,NULL,1,'2025-03-23 18:35:59','2025-03-23 18:35:59',NULL),(2596,7566,40719,50,2,2068,'App\\Models\\Receipt',2068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-23','2025-03-23',155500.44,NULL,NULL,1,'2025-03-23 18:39:00','2025-03-23 18:39:00',NULL),(2597,7566,40719,50,2,2069,'App\\Models\\Receipt',2069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-23','2025-03-23',45600.00,NULL,NULL,1,'2025-03-23 18:40:20','2025-03-23 18:40:20',NULL),(2598,7566,40719,50,2,2070,'App\\Models\\Receipt',2070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-23','2025-03-23',197000.00,NULL,NULL,1,'2025-03-23 18:42:48','2025-03-23 18:42:48',NULL),(2599,7566,40719,50,2,2071,'App\\Models\\Receipt',2071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-23','2025-03-23',42000.00,NULL,NULL,1,'2025-03-23 18:44:05','2025-03-23 18:44:05',NULL),(2600,7566,40719,50,2,2072,'App\\Models\\Receipt',2072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-23','2025-03-23',39000.00,NULL,NULL,1,'2025-03-23 18:45:26','2025-03-23 18:45:26',NULL),(2601,7566,40719,50,2,2073,'App\\Models\\Receipt',2073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-23','2025-03-23',39800.00,NULL,NULL,1,'2025-03-23 18:46:52','2025-03-23 18:46:52',NULL),(2602,7566,40719,50,2,2074,'App\\Models\\Receipt',2074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-23','2025-03-23',36000.00,NULL,NULL,1,'2025-03-23 18:49:02','2025-03-23 18:49:02',NULL),(2603,7566,40719,50,2,2075,'App\\Models\\Receipt',2075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-23','2025-03-23',155879.00,NULL,NULL,1,'2025-03-23 18:50:00','2025-03-23 18:50:00',NULL),(2604,7566,40719,50,2,2076,'App\\Models\\Receipt',2076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-23','2025-03-23',41100.00,NULL,NULL,1,'2025-03-23 18:51:05','2025-03-23 18:51:05',NULL),(2605,7566,40719,50,2,2077,'App\\Models\\Receipt',2077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-23','2025-03-23',36000.00,NULL,NULL,1,'2025-03-23 18:52:02','2025-03-23 18:52:02',NULL),(2606,7566,40719,50,2,2078,'App\\Models\\Receipt',2078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-23','2025-03-23',44500.00,NULL,NULL,1,'2025-03-23 18:53:04','2025-03-23 18:53:04',NULL),(2607,7566,40719,50,2,2079,'App\\Models\\Receipt',2079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-23','2025-03-23',42000.00,NULL,NULL,1,'2025-03-23 18:53:59','2025-03-23 18:53:59',NULL),(2608,7566,40719,50,2,2080,'App\\Models\\Receipt',2080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-23','2025-03-23',16000.00,NULL,NULL,1,'2025-03-23 18:55:01','2025-03-23 18:55:01',NULL),(2609,NULL,40719,50,2,2081,'App\\Models\\Receipt',2081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',13000.00,NULL,NULL,1,'2025-04-09 18:49:31','2025-04-09 18:49:31',NULL),(2610,NULL,40719,50,2,2082,'App\\Models\\Receipt',2082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',21000.00,NULL,NULL,1,'2025-04-09 18:49:33','2025-04-09 18:49:33',NULL),(2611,NULL,40719,50,2,2083,'App\\Models\\Receipt',2083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',13000.00,NULL,NULL,1,'2025-04-09 18:49:34','2025-04-09 18:49:34',NULL),(2612,NULL,40719,50,2,2084,'App\\Models\\Receipt',2084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',16000.00,NULL,NULL,1,'2025-04-09 18:49:35','2025-04-09 18:49:35',NULL),(2613,NULL,40719,50,2,2085,'App\\Models\\Receipt',2085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',13000.00,NULL,NULL,1,'2025-04-09 18:49:36','2025-04-09 18:49:36',NULL),(2614,NULL,40719,50,2,2086,'App\\Models\\Receipt',2086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',18000.00,NULL,NULL,1,'2025-04-09 18:49:37','2025-04-09 18:49:37',NULL),(2615,NULL,40719,50,2,2087,'App\\Models\\Receipt',2087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',18000.00,NULL,NULL,1,'2025-04-09 18:49:38','2025-04-09 18:49:38',NULL);
INSERT INTO `balance_libro` VALUES (2616,NULL,40719,50,2,2088,'App\\Models\\Receipt',2088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',30000.00,NULL,NULL,1,'2025-04-09 18:49:39','2025-04-09 18:49:39',NULL),(2617,NULL,40719,50,2,2089,'App\\Models\\Receipt',2089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',15000.00,NULL,NULL,1,'2025-04-09 18:49:40','2025-04-09 18:49:40',NULL),(2618,NULL,40719,50,2,2090,'App\\Models\\Receipt',2090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',42221.31,NULL,NULL,1,'2025-04-09 18:49:41','2025-04-09 18:49:41',NULL),(2619,NULL,40719,50,2,2091,'App\\Models\\Receipt',2091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',92000.00,NULL,NULL,1,'2025-04-09 18:49:42','2025-04-09 18:49:42',NULL),(2620,NULL,40719,50,2,2092,'App\\Models\\Receipt',2092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',16300.00,NULL,NULL,1,'2025-04-09 18:49:44','2025-04-09 18:49:44',NULL),(2621,NULL,40719,50,2,2093,'App\\Models\\Receipt',2093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',20000.00,NULL,NULL,1,'2025-04-09 18:49:45','2025-04-09 18:49:45',NULL),(2622,NULL,40719,50,2,2094,'App\\Models\\Receipt',2094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',17000.00,NULL,NULL,1,'2025-04-09 18:49:46','2025-04-09 18:49:46',NULL),(2623,NULL,40719,50,2,2095,'App\\Models\\Receipt',2095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',69584.48,NULL,NULL,1,'2025-04-09 18:49:46','2025-04-09 18:49:46',NULL),(2624,NULL,40719,50,2,2096,'App\\Models\\Receipt',2096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',14000.00,NULL,NULL,1,'2025-04-09 18:49:48','2025-04-09 18:49:48',NULL),(2625,NULL,40719,50,2,2097,'App\\Models\\Receipt',2097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',13500.00,NULL,NULL,1,'2025-04-09 18:49:49','2025-04-09 18:49:49',NULL),(2626,NULL,40719,50,2,2098,'App\\Models\\Receipt',2098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',15000.00,NULL,NULL,1,'2025-04-09 18:49:50','2025-04-09 18:49:50',NULL),(2627,NULL,40719,50,2,2099,'App\\Models\\Receipt',2099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',14000.00,NULL,NULL,1,'2025-04-09 18:49:51','2025-04-09 18:49:51',NULL),(2628,NULL,40719,50,2,2100,'App\\Models\\Receipt',2100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',12000.00,NULL,NULL,1,'2025-04-09 18:49:52','2025-04-09 18:49:52',NULL),(2629,NULL,40719,50,2,2101,'App\\Models\\Receipt',2101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',51679.00,NULL,NULL,1,'2025-04-09 18:49:53','2025-04-09 18:49:53',NULL),(2630,NULL,40719,50,2,2102,'App\\Models\\Receipt',2102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',13700.00,NULL,NULL,1,'2025-04-09 18:49:54','2025-04-09 18:49:54',NULL),(2631,NULL,40719,50,2,2103,'App\\Models\\Receipt',2103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',13000.00,NULL,NULL,1,'2025-04-09 18:49:55','2025-04-09 18:49:55',NULL),(2632,NULL,40719,50,2,2104,'App\\Models\\Receipt',2104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',16000.00,NULL,NULL,1,'2025-04-09 18:49:57','2025-04-09 18:49:57',NULL),(2633,NULL,40719,50,2,2105,'App\\Models\\Receipt',2105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',15000.00,NULL,NULL,1,'2025-04-09 18:49:58','2025-04-09 18:49:58',NULL),(2634,NULL,40719,51,2,2106,'App\\Models\\Receipt',2106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-10','2025-04-10',13000.00,NULL,NULL,1,'2025-04-10 18:59:34','2025-04-10 18:59:34',NULL),(2635,NULL,40719,51,2,2107,'App\\Models\\Receipt',2107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-10','2025-04-10',21000.00,NULL,NULL,1,'2025-04-10 18:59:35','2025-04-10 18:59:35',NULL),(2636,NULL,40719,51,2,2108,'App\\Models\\Receipt',2108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-10','2025-04-10',13000.00,NULL,NULL,1,'2025-04-10 18:59:37','2025-04-10 18:59:37',NULL);
INSERT INTO `balance_libro` VALUES (2637,NULL,40719,51,2,2109,'App\\Models\\Receipt',2109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-10','2025-04-10',17000.00,NULL,NULL,1,'2025-04-10 18:59:38','2025-04-10 18:59:38',NULL),(2638,NULL,40719,51,2,2110,'App\\Models\\Receipt',2110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-10','2025-04-10',13000.00,NULL,NULL,1,'2025-04-10 18:59:39','2025-04-10 18:59:39',NULL),(2639,NULL,40719,51,2,2111,'App\\Models\\Receipt',2111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-10','2025-04-10',18000.00,NULL,NULL,1,'2025-04-10 18:59:40','2025-04-10 18:59:40',NULL),(2640,NULL,40719,51,2,2112,'App\\Models\\Receipt',2112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-10','2025-04-10',30000.00,NULL,NULL,1,'2025-04-10 18:59:41','2025-04-10 18:59:41',NULL),(2641,NULL,40719,51,2,2113,'App\\Models\\Receipt',2113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-10','2025-04-10',15000.00,NULL,NULL,1,'2025-04-10 18:59:42','2025-04-10 18:59:42',NULL),(2642,NULL,40719,51,2,2114,'App\\Models\\Receipt',2114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-10','2025-04-10',42221.31,NULL,NULL,1,'2025-04-10 18:59:43','2025-04-10 18:59:43',NULL),(2643,NULL,40719,51,2,2115,'App\\Models\\Receipt',2115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-10','2025-04-10',92000.00,NULL,NULL,1,'2025-04-10 18:59:44','2025-04-10 18:59:44',NULL),(2644,NULL,40719,51,2,2116,'App\\Models\\Receipt',2116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-10','2025-04-10',16300.00,NULL,NULL,1,'2025-04-10 18:59:46','2025-04-10 18:59:46',NULL),(2645,NULL,40719,51,2,2117,'App\\Models\\Receipt',2117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-10','2025-04-10',18800.00,NULL,NULL,1,'2025-04-10 18:59:47','2025-04-10 18:59:47',NULL),(2646,NULL,40719,51,2,2118,'App\\Models\\Receipt',2118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-10','2025-04-10',69584.48,NULL,NULL,1,'2025-04-10 18:59:48','2025-04-10 18:59:48',NULL),(2647,NULL,40719,51,2,2119,'App\\Models\\Receipt',2119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-10','2025-04-10',15000.00,NULL,NULL,1,'2025-04-10 18:59:49','2025-04-10 18:59:49',NULL),(2648,NULL,40719,51,2,2120,'App\\Models\\Receipt',2120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-10','2025-04-10',14500.00,NULL,NULL,1,'2025-04-10 18:59:50','2025-04-10 18:59:50',NULL),(2649,NULL,40719,51,2,2121,'App\\Models\\Receipt',2121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-10','2025-04-10',16300.00,NULL,NULL,1,'2025-04-10 18:59:51','2025-04-10 18:59:51',NULL),(2650,NULL,40719,51,2,2122,'App\\Models\\Receipt',2122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-10','2025-04-10',14000.00,NULL,NULL,1,'2025-04-10 18:59:52','2025-04-10 18:59:52',NULL),(2651,NULL,40719,51,2,2123,'App\\Models\\Receipt',2123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-10','2025-04-10',12000.00,NULL,NULL,1,'2025-04-10 18:59:54','2025-04-10 18:59:54',NULL),(2652,NULL,40719,51,2,2124,'App\\Models\\Receipt',2124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-10','2025-04-10',51679.00,NULL,NULL,1,'2025-04-10 18:59:55','2025-04-10 18:59:55',NULL),(2653,NULL,40719,51,2,2125,'App\\Models\\Receipt',2125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-10','2025-04-10',14700.00,NULL,NULL,1,'2025-04-10 18:59:56','2025-04-10 18:59:56',NULL),(2654,NULL,40719,51,2,2126,'App\\Models\\Receipt',2126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-10','2025-04-10',13000.00,NULL,NULL,1,'2025-04-10 18:59:57','2025-04-10 18:59:57',NULL),(2655,NULL,40719,51,2,2127,'App\\Models\\Receipt',2127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-10','2025-04-10',18000.00,NULL,NULL,1,'2025-04-10 18:59:58','2025-04-10 18:59:58',NULL),(2656,NULL,40719,51,2,2128,'App\\Models\\Receipt',2128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-10','2025-04-10',15000.00,NULL,NULL,1,'2025-04-10 18:59:59','2025-04-10 18:59:59',NULL),(2657,NULL,40719,51,2,2129,'App\\Models\\Receipt',2129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-10','2025-04-10',12000.00,NULL,NULL,1,'2025-04-10 19:00:00','2025-04-10 19:00:00',NULL);
INSERT INTO `balance_libro` VALUES (2658,NULL,40719,51,2,2130,'App\\Models\\Receipt',2130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-10','2025-04-10',106958.96,NULL,NULL,1,'2025-04-10 19:00:01','2025-04-10 19:00:01',NULL),(2659,7566,40720,1565,2,2131,'App\\Models\\Receipt',2131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-01','2025-03-01',931432.40,NULL,NULL,1,'2025-04-17 18:17:32','2025-04-17 18:56:33','2025-04-17 18:56:33'),(2660,7566,40720,1565,2,2132,'App\\Models\\Receipt',2132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-07','2025-03-07',1105012.32,NULL,NULL,1,'2025-04-17 18:17:32','2025-04-17 18:54:49','2025-04-17 18:54:49'),(2661,7566,40720,1565,2,2133,'App\\Models\\Receipt',2133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-07','2025-03-07',9680.00,NULL,NULL,1,'2025-04-17 18:17:32','2025-04-17 18:17:32',NULL),(2662,7566,40720,1565,2,2134,'App\\Models\\Receipt',2134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-07','2025-03-07',21878.30,NULL,NULL,1,'2025-04-17 18:17:33','2025-04-17 18:17:33',NULL),(2663,7566,40720,1565,2,2135,'App\\Models\\Receipt',2135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-11','2025-03-11',25804.42,NULL,NULL,1,'2025-04-17 18:17:33','2025-04-17 18:53:57','2025-04-17 18:53:57'),(2664,7566,40720,1565,2,2136,'App\\Models\\Receipt',2136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-18','2025-03-18',1993336.37,NULL,NULL,1,'2025-04-17 18:17:33','2025-04-17 18:17:33',NULL),(2665,7566,40720,1565,2,2137,'App\\Models\\Receipt',2137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-18','2025-03-18',1993336.37,NULL,NULL,1,'2025-04-17 18:17:33','2025-04-17 18:17:33',NULL),(2666,7566,40720,1565,2,2138,'App\\Models\\Receipt',2138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-18','2025-03-18',1993336.37,NULL,NULL,1,'2025-04-17 18:17:33','2025-04-18 11:05:31','2025-04-18 11:05:31'),(2667,7566,40720,1565,3,2139,'App\\Models\\Receipt',2139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-01','2025-03-01',16700.00,NULL,NULL,1,'2025-04-17 18:17:57','2025-04-17 19:40:37','2025-04-17 19:40:37'),(2668,7566,40720,1565,3,2140,'App\\Models\\Receipt',2140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-01','2025-03-01',79900.41,NULL,NULL,1,'2025-04-17 18:17:57','2025-04-17 19:25:16','2025-04-17 19:25:16'),(2669,7566,40720,1565,3,2141,'App\\Models\\Receipt',2141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-01','2025-03-01',194999.99,NULL,NULL,1,'2025-04-17 18:17:57','2025-04-17 19:27:45','2025-04-17 19:27:45'),(2670,7566,40720,1565,3,2142,'App\\Models\\Receipt',2142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-01','2025-03-01',157294.85,NULL,NULL,1,'2025-04-17 18:17:57','2025-04-17 18:58:17','2025-04-17 18:58:17'),(2671,7566,40720,1565,3,2143,'App\\Models\\Receipt',2143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-03','2025-03-03',17346.61,NULL,NULL,1,'2025-04-17 18:17:57','2025-04-17 19:33:15','2025-04-17 19:33:15'),(2672,7566,40720,1565,3,2144,'App\\Models\\Receipt',2144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-03','2025-03-03',59446.01,NULL,NULL,1,'2025-04-17 18:17:57','2025-04-17 19:40:10','2025-04-17 19:40:10'),(2673,7566,40720,1565,3,2145,'App\\Models\\Receipt',2145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-05','2025-03-05',134243.45,NULL,NULL,1,'2025-04-17 18:17:57','2025-04-17 18:17:57',NULL),(2674,7566,40720,1565,3,2146,'App\\Models\\Receipt',2146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-09','2025-03-09',30586.76,NULL,NULL,1,'2025-04-17 18:17:57','2025-04-17 19:32:12','2025-04-17 19:32:12'),(2675,7566,40720,1565,3,2147,'App\\Models\\Receipt',2147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-10','2025-03-10',7998.93,NULL,NULL,1,'2025-04-17 18:17:57','2025-04-17 19:55:49','2025-04-17 19:55:49'),(2676,7566,40720,1565,3,2148,'App\\Models\\Receipt',2148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-11','2025-03-11',10945.11,NULL,NULL,1,'2025-04-17 18:17:57','2025-04-17 19:31:26','2025-04-17 19:31:26');
INSERT INTO `balance_libro` VALUES (2677,7566,40720,1565,3,2149,'App\\Models\\Receipt',2149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-13','2025-03-13',70000.00,NULL,NULL,1,'2025-04-17 18:17:57','2025-04-17 19:18:50','2025-04-17 19:18:50'),(2678,7566,40720,1565,3,2150,'App\\Models\\Receipt',2150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-14','2025-03-14',400000.00,NULL,NULL,1,'2025-04-17 18:17:57','2025-04-17 20:07:14','2025-04-17 20:07:14'),(2679,7566,40720,1565,3,2151,'App\\Models\\Receipt',2151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-15','2025-03-15',225000.00,NULL,NULL,1,'2025-04-17 18:17:57','2025-04-17 19:13:19','2025-04-17 19:13:19'),(2680,7566,40720,1565,3,2152,'App\\Models\\Receipt',2152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-15','2025-03-15',145000.00,NULL,NULL,1,'2025-04-17 18:17:57','2025-04-17 19:13:36','2025-04-17 19:13:36'),(2681,7566,40720,1565,3,2153,'App\\Models\\Receipt',2153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-17','2025-03-17',16500.00,NULL,NULL,1,'2025-04-17 18:17:57','2025-04-17 18:17:57',NULL),(2682,7566,40720,1565,3,2154,'App\\Models\\Receipt',2154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-17','2025-03-17',28984.67,NULL,NULL,1,'2025-04-17 18:17:57','2025-04-17 19:30:16','2025-04-17 19:30:16'),(2683,7566,40720,1565,3,2155,'App\\Models\\Receipt',2155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-18','2025-03-18',123800.00,NULL,NULL,1,'2025-04-17 18:17:57','2025-04-18 10:51:10','2025-04-18 10:51:10'),(2684,7566,40720,1565,3,2156,'App\\Models\\Receipt',2156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-21','2025-03-21',45246.39,NULL,NULL,1,'2025-04-17 18:17:58','2025-04-17 19:35:21','2025-04-17 19:35:21'),(2685,7566,40720,1565,3,2157,'App\\Models\\Receipt',2157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-23','2025-03-23',17423.27,NULL,NULL,1,'2025-04-17 18:17:58','2025-04-17 19:29:29','2025-04-17 19:29:29'),(2686,7566,40720,1565,3,2158,'App\\Models\\Receipt',2158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-23','2025-03-23',255000.00,NULL,NULL,1,'2025-04-17 18:17:58','2025-04-17 19:43:15','2025-04-17 19:43:15'),(2687,7566,40720,1565,3,2159,'App\\Models\\Receipt',2159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-26','2025-03-26',400000.00,NULL,NULL,1,'2025-04-17 18:17:58','2025-04-17 20:06:20','2025-04-17 20:06:20'),(2688,7566,40720,1565,3,2160,'App\\Models\\Receipt',2160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-27','2025-03-27',55717.96,NULL,NULL,1,'2025-04-17 18:17:58','2025-04-17 19:04:37','2025-04-17 19:04:37'),(2689,7566,40720,1565,3,2161,'App\\Models\\Receipt',2161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-28','2025-03-28',14648.40,NULL,NULL,1,'2025-04-17 18:17:58','2025-04-17 19:28:17','2025-04-17 19:28:17'),(2690,7566,40720,1565,3,2162,'App\\Models\\Receipt',2162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',92000.00,NULL,NULL,1,'2025-04-17 18:17:58','2025-04-17 19:42:55','2025-04-17 19:42:55'),(2691,7566,40720,1565,2,2135,'App\\Models\\Receipt',2135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-11','2025-03-11',25804.40,NULL,NULL,1,'2025-04-17 18:53:57','2025-04-17 18:53:57',NULL),(2692,7566,40720,1565,2,2132,'App\\Models\\Receipt',2132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-07','2025-03-07',1105012.32,NULL,NULL,1,'2025-04-17 18:54:49','2025-04-17 18:54:49',NULL),(2693,7566,40720,1565,2,2131,'App\\Models\\Receipt',2131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-01','2025-03-01',931432.40,NULL,NULL,1,'2025-04-17 18:56:33','2025-04-17 18:56:33',NULL),(2694,7566,40720,1565,3,2160,'App\\Models\\Receipt',2160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-27','2025-03-27',55717.96,NULL,NULL,1,'2025-04-17 19:04:37','2025-04-18 11:54:47','2025-04-18 11:54:47'),(2695,7566,40720,1565,3,2151,'App\\Models\\Receipt',2151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-15','2025-03-15',225000.00,NULL,NULL,1,'2025-04-17 19:13:19','2025-04-17 19:13:19',NULL);
INSERT INTO `balance_libro` VALUES (2696,7566,40720,1565,3,2152,'App\\Models\\Receipt',2152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-15','2025-03-15',145000.00,NULL,NULL,1,'2025-04-17 19:13:36','2025-04-17 19:13:36',NULL),(2697,7566,40720,1565,3,2163,'App\\Models\\Receipt',2163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-04','2025-03-04',39990.00,NULL,NULL,1,'2025-04-17 19:16:18','2025-04-17 19:16:18',NULL),(2698,7566,40720,1565,3,2164,'App\\Models\\Receipt',2164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-13','2025-03-13',15699.99,NULL,NULL,1,'2025-04-17 19:17:44','2025-04-17 19:17:44',NULL),(2699,7566,40720,1565,3,2149,'App\\Models\\Receipt',2149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-13','2025-03-13',70000.00,NULL,NULL,1,'2025-04-17 19:18:50','2025-04-17 19:18:50',NULL),(2700,7566,40720,1565,3,2140,'App\\Models\\Receipt',2140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-01','2025-03-01',79900.41,NULL,NULL,1,'2025-04-17 19:25:16','2025-04-17 19:25:16',NULL),(2701,7566,40720,1565,3,2141,'App\\Models\\Receipt',2141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-01','2025-03-01',194999.99,NULL,NULL,1,'2025-04-17 19:27:45','2025-04-17 19:27:45',NULL),(2702,7566,40720,1565,3,2161,'App\\Models\\Receipt',2161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-28','2025-03-28',14648.40,NULL,NULL,1,'2025-04-17 19:28:17','2025-04-17 19:28:17',NULL),(2703,7566,40720,1565,3,2157,'App\\Models\\Receipt',2157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-23','2025-03-23',17423.27,NULL,NULL,1,'2025-04-17 19:29:29','2025-04-17 19:30:35','2025-04-17 19:30:35'),(2704,7566,40720,1565,3,2154,'App\\Models\\Receipt',2154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-17','2025-03-17',28984.67,NULL,NULL,1,'2025-04-17 19:30:16','2025-04-17 19:32:43','2025-04-17 19:32:43'),(2705,7566,40720,1565,3,2157,'App\\Models\\Receipt',2157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-23','2025-03-23',17423.27,NULL,NULL,1,'2025-04-17 19:30:35','2025-04-17 19:32:29','2025-04-17 19:32:29'),(2706,7566,40720,1565,3,2148,'App\\Models\\Receipt',2148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-11','2025-03-11',10945.11,NULL,NULL,1,'2025-04-17 19:31:26','2025-04-17 19:32:52','2025-04-17 19:32:52'),(2707,7566,40720,1565,3,2146,'App\\Models\\Receipt',2146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-09','2025-03-09',30586.76,NULL,NULL,1,'2025-04-17 19:32:12','2025-04-17 19:33:49','2025-04-17 19:33:49'),(2708,7566,40720,1565,3,2157,'App\\Models\\Receipt',2157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-23','2025-03-23',17423.27,NULL,NULL,1,'2025-04-17 19:32:29','2025-04-17 19:32:29',NULL),(2709,7566,40720,1565,3,2154,'App\\Models\\Receipt',2154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-17','2025-03-17',28984.67,NULL,NULL,1,'2025-04-17 19:32:43','2025-04-17 19:32:43',NULL),(2710,7566,40720,1565,3,2148,'App\\Models\\Receipt',2148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-11','2025-03-11',10945.11,NULL,NULL,1,'2025-04-17 19:32:52','2025-04-17 19:32:52',NULL),(2711,7566,40720,1565,3,2143,'App\\Models\\Receipt',2143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-03','2025-03-03',17346.61,NULL,NULL,1,'2025-04-17 19:33:15','2025-04-17 19:34:24','2025-04-17 19:34:24'),(2712,7566,40720,1565,3,2146,'App\\Models\\Receipt',2146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-09','2025-03-09',30586.76,NULL,NULL,1,'2025-04-17 19:33:49','2025-04-17 19:33:49',NULL),(2713,7566,40720,1565,3,2143,'App\\Models\\Receipt',2143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-03','2025-03-03',17346.61,NULL,NULL,1,'2025-04-17 19:34:24','2025-04-17 19:34:24',NULL),(2714,7566,40720,1565,3,2165,'App\\Models\\Receipt',2165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-02-21','2025-02-21',44142.83,NULL,NULL,1,'2025-04-17 19:36:51','2025-04-17 19:36:51',NULL),(2715,7566,40720,1565,3,2144,'App\\Models\\Receipt',2144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-03','2025-03-03',59446.01,NULL,NULL,1,'2025-04-17 19:40:10','2025-04-17 19:40:10',NULL);
INSERT INTO `balance_libro` VALUES (2716,7566,40720,1565,3,2139,'App\\Models\\Receipt',2139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-01','2025-03-01',16700.00,NULL,NULL,1,'2025-04-17 19:40:37','2025-04-17 19:40:37',NULL),(2717,7566,40720,1565,3,2162,'App\\Models\\Receipt',2162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',92000.00,NULL,NULL,1,'2025-04-17 19:42:55','2025-04-17 19:42:55',NULL),(2718,7566,40720,1565,3,2158,'App\\Models\\Receipt',2158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-23','2025-03-23',255000.00,NULL,NULL,1,'2025-04-17 19:43:15','2025-04-17 19:43:15',NULL),(2719,7566,40720,1565,7,2166,'App\\Models\\Receipt',2166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-31','2025-03-31',5834.70,NULL,NULL,1,'2025-04-17 19:44:43','2025-04-17 19:44:43',NULL),(2720,7566,40720,1565,7,2167,'App\\Models\\Receipt',2167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-28','2025-03-28',8297.76,NULL,NULL,1,'2025-04-17 19:44:43','2025-04-17 19:44:43',NULL),(2721,7566,40720,1565,7,2168,'App\\Models\\Receipt',2168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-27','2025-03-27',632.43,NULL,NULL,1,'2025-04-17 19:44:43','2025-04-17 19:44:43',NULL),(2722,7566,40720,1565,7,2169,'App\\Models\\Receipt',2169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-25','2025-03-25',1980.20,NULL,NULL,1,'2025-04-17 19:44:43','2025-04-17 19:44:43',NULL),(2723,7566,40720,1565,7,2170,'App\\Models\\Receipt',2170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-19','2025-03-19',3156.46,NULL,NULL,1,'2025-04-17 19:44:43','2025-04-17 19:44:43',NULL),(2724,7566,40720,1565,7,2171,'App\\Models\\Receipt',2171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-18','2025-03-18',2554.66,NULL,NULL,1,'2025-04-17 19:44:43','2025-04-17 19:44:43',NULL),(2725,7566,40720,1565,7,2172,'App\\Models\\Receipt',2172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-17','2025-03-17',42407.59,NULL,NULL,1,'2025-04-17 19:44:43','2025-04-17 19:44:43',NULL),(2726,7566,40720,1565,7,2173,'App\\Models\\Receipt',2173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-14','2025-03-14',1294.59,NULL,NULL,1,'2025-04-17 19:44:43','2025-04-17 19:44:43',NULL),(2727,7566,40720,1565,7,2174,'App\\Models\\Receipt',2174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-12','2025-03-12',3582.76,NULL,NULL,1,'2025-04-17 19:44:43','2025-04-17 19:44:43',NULL),(2728,7566,40720,1565,7,2175,'App\\Models\\Receipt',2175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-12','2025-03-12',12182.02,NULL,NULL,1,'2025-04-17 19:44:43','2025-04-17 19:44:43',NULL),(2729,7566,40720,1565,7,2176,'App\\Models\\Receipt',2176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-11','2025-03-11',515.46,NULL,NULL,1,'2025-04-17 19:44:43','2025-04-17 19:44:43',NULL),(2730,7566,40720,1565,7,2177,'App\\Models\\Receipt',2177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-10','2025-03-10',45739.08,NULL,NULL,1,'2025-04-17 19:44:43','2025-04-17 19:44:43',NULL),(2731,7566,40720,1565,7,2178,'App\\Models\\Receipt',2178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-07','2025-03-07',32446.67,NULL,NULL,1,'2025-04-17 19:44:43','2025-04-17 19:44:43',NULL),(2732,7566,40720,1565,7,2179,'App\\Models\\Receipt',2179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-06','2025-03-06',3503.33,NULL,NULL,1,'2025-04-17 19:44:43','2025-04-17 19:44:43',NULL),(2733,7566,40720,1565,7,2180,'App\\Models\\Receipt',2180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-05','2025-03-05',2859.07,NULL,NULL,1,'2025-04-17 19:44:43','2025-04-17 19:44:43',NULL),(2734,7566,40720,1565,7,2181,'App\\Models\\Receipt',2181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-05','2025-03-05',33526.05,NULL,NULL,1,'2025-04-17 19:44:43','2025-04-17 19:44:43',NULL),(2735,7566,40720,1565,3,2147,'App\\Models\\Receipt',2147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-10','2025-03-10',8197.25,NULL,NULL,1,'2025-04-17 19:55:49','2025-04-17 19:55:49',NULL),(2736,7566,40720,1565,3,2182,'App\\Models\\Receipt',2182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-12','2025-03-12',56664.20,NULL,NULL,1,'2025-04-17 20:03:02','2025-04-17 20:03:02',NULL);
INSERT INTO `balance_libro` VALUES (2737,7566,40720,1565,3,2159,'App\\Models\\Receipt',2159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-26','2025-03-26',400000.00,NULL,NULL,1,'2025-04-17 20:06:20','2025-04-17 20:06:20',NULL),(2738,7566,40720,1565,3,2150,'App\\Models\\Receipt',2150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-14','2025-03-14',400000.00,NULL,NULL,1,'2025-04-17 20:07:14','2025-04-17 20:07:14',NULL),(2739,7566,40720,1565,3,2155,'App\\Models\\Receipt',2155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-18','2025-03-18',123800.00,NULL,NULL,1,'2025-04-18 10:51:10','2025-04-18 10:51:10',NULL),(2740,7566,40720,1565,2,2138,'App\\Models\\Receipt',2138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-18','2025-03-18',1993336.37,NULL,NULL,1,'2025-04-18 11:05:31','2025-04-18 11:07:54','2025-04-18 11:07:54'),(2741,7566,40720,1565,2,2138,'App\\Models\\Receipt',2138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-18','2025-03-18',1993336.37,NULL,NULL,1,'2025-04-18 11:07:54','2025-04-18 11:09:20','2025-04-18 11:09:20'),(2742,7566,40720,1565,2,2138,'App\\Models\\Receipt',2138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-18','2025-03-18',1993336.37,NULL,NULL,1,'2025-04-18 11:09:20','2025-04-18 11:09:20',NULL),(2743,7566,40720,1565,3,2160,'App\\Models\\Receipt',2160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-27','2025-03-27',55717.96,NULL,NULL,1,'2025-04-18 11:54:47','2025-04-18 11:54:47',NULL),(2744,7566,40720,1566,2,2183,'App\\Models\\Receipt',2183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-01','2025-04-01',1184027.94,NULL,NULL,1,'2025-05-19 17:48:14','2025-05-19 18:07:41','2025-05-19 18:07:41'),(2745,7566,40720,1566,2,2184,'App\\Models\\Receipt',2184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-02','2025-04-02',38297.65,NULL,NULL,1,'2025-05-19 17:48:14','2025-05-19 17:48:14',NULL),(2746,7566,40720,1566,2,2185,'App\\Models\\Receipt',2185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-02','2025-04-02',72611.66,NULL,NULL,1,'2025-05-19 17:48:14','2025-05-19 17:48:14',NULL),(2747,7566,40720,1566,2,2186,'App\\Models\\Receipt',2186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-02','2025-04-02',1397773.29,NULL,NULL,1,'2025-05-19 17:48:14','2025-05-19 18:08:51','2025-05-19 18:08:51'),(2748,7566,40720,1566,2,2187,'App\\Models\\Receipt',2187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-07','2025-04-07',8098.93,NULL,NULL,1,'2025-05-19 17:48:15','2025-05-19 17:48:15',NULL),(2749,7566,40720,1566,2,2188,'App\\Models\\Receipt',2188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-07','2025-04-07',30307.25,NULL,NULL,1,'2025-05-19 17:48:15','2025-05-19 18:09:56','2025-05-19 18:09:56'),(2750,7566,40720,1566,2,2189,'App\\Models\\Receipt',2189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-16','2025-04-16',2083707.11,NULL,NULL,1,'2025-05-19 17:48:15','2025-05-19 18:10:28','2025-05-19 18:10:28'),(2751,7566,40720,1566,3,2190,'App\\Models\\Receipt',2190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-01','2025-04-01',17100.00,NULL,NULL,1,'2025-05-19 17:56:47','2025-05-19 17:56:47',NULL),(2752,7566,40720,1566,3,2191,'App\\Models\\Receipt',2191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-01','2025-04-01',18500.00,NULL,NULL,1,'2025-05-19 17:56:47','2025-05-19 19:20:34','2025-05-19 19:20:34'),(2753,7566,40720,1566,3,2192,'App\\Models\\Receipt',2192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-01','2025-04-01',157294.85,NULL,NULL,1,'2025-05-19 17:56:47','2025-05-19 17:57:26','2025-05-19 17:57:26'),(2754,7566,40720,1566,3,2193,'App\\Models\\Receipt',2193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-03','2025-04-03',18500.00,NULL,NULL,1,'2025-05-19 17:56:47','2025-05-19 19:20:59','2025-05-19 19:20:59'),(2755,7566,40720,1566,3,2194,'App\\Models\\Receipt',2194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-03','2025-04-03',61556.68,NULL,NULL,1,'2025-05-19 17:56:47','2025-05-19 18:32:09','2025-05-19 18:32:09'),(2756,7566,40720,1566,3,2195,'App\\Models\\Receipt',2195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-05','2025-04-05',18821.41,NULL,NULL,1,'2025-05-19 17:56:47','2025-05-19 18:28:18','2025-05-19 18:28:18');
INSERT INTO `balance_libro` VALUES (2757,7566,40720,1566,3,2196,'App\\Models\\Receipt',2196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-06','2025-04-06',40526.85,NULL,NULL,1,'2025-05-19 17:56:48','2025-05-19 18:27:39','2025-05-19 18:27:39'),(2758,7566,40720,1566,3,2197,'App\\Models\\Receipt',2197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-07','2025-04-07',134243.45,NULL,NULL,1,'2025-05-19 17:56:48','2025-05-19 17:56:48',NULL),(2759,7566,40720,1566,3,2198,'App\\Models\\Receipt',2198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-09','2025-04-09',7998.93,NULL,NULL,1,'2025-05-19 17:56:48','2025-05-19 19:33:03','2025-05-19 19:33:03'),(2760,7566,40720,1566,3,2199,'App\\Models\\Receipt',2199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-10','2025-04-10',92000.00,NULL,NULL,1,'2025-05-19 17:56:48','2025-05-19 17:56:48',NULL),(2761,7566,40720,1566,3,2200,'App\\Models\\Receipt',2200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-11','2025-04-11',46200.00,NULL,NULL,1,'2025-05-19 17:56:48','2025-05-19 17:56:48',NULL),(2762,7566,40720,1566,3,2201,'App\\Models\\Receipt',2201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-12','2025-04-12',266600.00,NULL,NULL,1,'2025-05-19 17:56:48','2025-05-19 18:22:04','2025-05-19 18:22:04'),(2763,7566,40720,1566,3,2202,'App\\Models\\Receipt',2202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-13','2025-04-13',18047.19,NULL,NULL,1,'2025-05-19 17:56:48','2025-05-19 18:26:56','2025-05-19 18:26:56'),(2764,7566,40720,1566,3,2203,'App\\Models\\Receipt',2203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-13','2025-04-13',33440.00,NULL,NULL,1,'2025-05-19 17:56:48','2025-05-19 18:21:37','2025-05-19 18:21:37'),(2765,7566,40720,1566,3,2204,'App\\Models\\Receipt',2204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-18','2025-04-18',31753.62,NULL,NULL,1,'2025-05-19 17:56:48','2025-05-19 18:25:47','2025-05-19 18:25:47'),(2766,7566,40720,1566,3,2205,'App\\Models\\Receipt',2205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-20','2025-04-20',19415.99,NULL,NULL,1,'2025-05-19 17:56:48','2025-05-19 18:24:19','2025-05-19 18:24:19'),(2767,7566,40720,1566,3,2206,'App\\Models\\Receipt',2206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-21','2025-04-21',55384.15,NULL,NULL,1,'2025-05-19 17:56:48','2025-05-19 18:29:05','2025-05-19 18:29:05'),(2768,7566,40720,1566,3,2207,'App\\Models\\Receipt',2207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-27','2025-04-27',98100.00,NULL,NULL,1,'2025-05-19 17:56:48','2025-05-19 17:56:48',NULL),(2769,7566,40720,1566,3,2208,'App\\Models\\Receipt',2208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',29305.65,NULL,NULL,1,'2025-05-19 17:56:48','2025-05-19 18:22:57','2025-05-19 18:22:57'),(2770,7566,40720,1566,7,2209,'App\\Models\\Receipt',2209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-29','2025-04-29',3684.07,NULL,NULL,1,'2025-05-19 17:59:35','2025-05-19 17:59:35',NULL),(2771,7566,40720,1566,7,2210,'App\\Models\\Receipt',2210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',7570.64,NULL,NULL,1,'2025-05-19 17:59:35','2025-05-19 17:59:35',NULL),(2772,7566,40720,1566,7,2211,'App\\Models\\Receipt',2211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-24','2025-04-24',1860.79,NULL,NULL,1,'2025-05-19 17:59:35','2025-05-19 17:59:35',NULL),(2773,7566,40720,1566,7,2212,'App\\Models\\Receipt',2212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-23','2025-04-23',4588.58,NULL,NULL,1,'2025-05-19 17:59:35','2025-05-19 17:59:35',NULL),(2774,7566,40720,1566,7,2213,'App\\Models\\Receipt',2213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-22','2025-04-22',1319.19,NULL,NULL,1,'2025-05-19 17:59:35','2025-05-19 17:59:35',NULL),(2775,7566,40720,1566,7,2214,'App\\Models\\Receipt',2214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-21','2025-04-21',20082.32,NULL,NULL,1,'2025-05-19 17:59:36','2025-05-19 17:59:36',NULL),(2776,7566,40720,1566,7,2215,'App\\Models\\Receipt',2215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-16','2025-04-16',4312.54,NULL,NULL,1,'2025-05-19 17:59:36','2025-05-19 17:59:36',NULL);
INSERT INTO `balance_libro` VALUES (2777,7566,40720,1566,7,2216,'App\\Models\\Receipt',2216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-15','2025-04-15',1907.87,NULL,NULL,1,'2025-05-19 17:59:36','2025-05-19 17:59:36',NULL),(2778,7566,40720,1566,7,2217,'App\\Models\\Receipt',2217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-14','2025-04-14',1147.88,NULL,NULL,1,'2025-05-19 17:59:36','2025-05-19 17:59:36',NULL),(2779,7566,40720,1566,7,2218,'App\\Models\\Receipt',2218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-11','2025-04-11',22930.79,NULL,NULL,1,'2025-05-19 17:59:36','2025-05-19 17:59:36',NULL),(2780,7566,40720,1566,7,2219,'App\\Models\\Receipt',2219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-10','2025-04-10',17321.75,NULL,NULL,1,'2025-05-19 17:59:36','2025-05-19 17:59:36',NULL),(2781,7566,40720,1566,7,2220,'App\\Models\\Receipt',2220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-09','2025-04-09',3042.04,NULL,NULL,1,'2025-05-19 17:59:36','2025-05-19 17:59:36',NULL),(2782,7566,40720,1566,7,2221,'App\\Models\\Receipt',2221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-08','2025-04-08',1124.48,NULL,NULL,1,'2025-05-19 17:59:36','2025-05-19 17:59:36',NULL),(2783,7566,40720,1566,7,2222,'App\\Models\\Receipt',2222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-08','2025-04-08',40695.84,NULL,NULL,1,'2025-05-19 17:59:36','2025-05-19 17:59:36',NULL),(2784,7566,40720,1566,7,2223,'App\\Models\\Receipt',2223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-07','2025-04-07',17212.14,NULL,NULL,1,'2025-05-19 17:59:36','2025-05-19 17:59:36',NULL),(2785,7566,40720,1566,7,2224,'App\\Models\\Receipt',2224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-03','2025-04-03',5317.36,NULL,NULL,1,'2025-05-19 17:59:36','2025-05-19 17:59:36',NULL),(2786,7566,40720,1566,7,2225,'App\\Models\\Receipt',2225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-03','2025-04-03',15989.29,NULL,NULL,1,'2025-05-19 17:59:36','2025-05-19 17:59:36',NULL),(2787,7566,40720,1566,2,2183,'App\\Models\\Receipt',2183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-01','2025-04-01',1184027.94,NULL,NULL,1,'2025-05-19 18:07:41','2025-05-19 18:07:41',NULL),(2788,7566,40720,1566,2,2186,'App\\Models\\Receipt',2186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-02','2025-04-02',1397773.29,NULL,NULL,1,'2025-05-19 18:08:51','2025-05-19 18:08:51',NULL),(2789,7566,40720,1566,2,2188,'App\\Models\\Receipt',2188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-07','2025-04-07',30307.27,NULL,NULL,1,'2025-05-19 18:09:56','2025-05-19 18:09:56',NULL),(2790,7566,40720,1566,2,2189,'App\\Models\\Receipt',2189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-16','2025-04-16',2083707.11,NULL,NULL,1,'2025-05-19 18:10:28','2025-05-19 18:10:28',NULL),(2791,7566,40720,1566,3,2226,'App\\Models\\Receipt',2226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-01','2025-04-01',33500.00,NULL,NULL,1,'2025-05-19 18:18:55','2025-05-19 18:18:55',NULL),(2792,7566,40720,1566,3,2227,'App\\Models\\Receipt',2227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-23','2025-04-23',13799.99,NULL,NULL,1,'2025-05-19 18:19:37','2025-05-19 18:19:37',NULL),(2793,7566,40720,1566,3,2228,'App\\Models\\Receipt',2228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-25','2025-04-25',55343.99,NULL,NULL,1,'2025-05-19 18:20:31','2025-05-19 18:20:31',NULL),(2794,7566,40720,1566,3,2229,'App\\Models\\Receipt',2229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-25','2025-04-25',47007.01,NULL,NULL,1,'2025-05-19 18:21:06','2025-05-19 18:21:06',NULL),(2795,7566,40720,1566,3,2203,'App\\Models\\Receipt',2203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-13','2025-04-13',33440.00,NULL,NULL,1,'2025-05-19 18:21:37','2025-05-19 18:21:37',NULL),(2796,7566,40720,1566,3,2201,'App\\Models\\Receipt',2201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-12','2025-04-12',266600.00,NULL,NULL,1,'2025-05-19 18:22:04','2025-05-19 18:22:04',NULL),(2797,7566,40720,1566,3,2208,'App\\Models\\Receipt',2208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-28','2025-04-28',29305.65,NULL,NULL,1,'2025-05-19 18:22:57','2025-05-19 18:22:57',NULL);
INSERT INTO `balance_libro` VALUES (2798,7566,40720,1566,3,2205,'App\\Models\\Receipt',2205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-20','2025-04-20',19415.98,NULL,NULL,1,'2025-05-19 18:24:19','2025-05-19 18:25:00','2025-05-19 18:25:00'),(2799,7566,40720,1566,3,2205,'App\\Models\\Receipt',2205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-20','2025-04-20',19415.98,NULL,NULL,1,'2025-05-19 18:25:00','2025-05-19 18:25:00',NULL),(2800,7566,40720,1566,3,2204,'App\\Models\\Receipt',2204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-18','2025-04-18',31753.62,NULL,NULL,1,'2025-05-19 18:25:47','2025-05-19 18:25:47',NULL),(2801,7566,40720,1566,3,2202,'App\\Models\\Receipt',2202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-13','2025-04-13',18047.19,NULL,NULL,1,'2025-05-19 18:26:56','2025-05-19 18:26:56',NULL),(2802,7566,40720,1566,3,2196,'App\\Models\\Receipt',2196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-06','2025-04-06',40526.85,NULL,NULL,1,'2025-05-19 18:27:39','2025-05-19 18:27:39',NULL),(2803,7566,40720,1566,3,2195,'App\\Models\\Receipt',2195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-05','2025-04-05',18821.42,NULL,NULL,1,'2025-05-19 18:28:18','2025-05-19 18:28:18',NULL),(2804,7566,40720,1566,3,2230,'App\\Models\\Receipt',2230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-03-21','2025-03-21',45246.39,NULL,NULL,1,'2025-05-19 18:30:47','2025-05-19 18:30:47',NULL),(2805,7566,40720,1566,3,2194,'App\\Models\\Receipt',2194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-03','2025-04-03',61556.68,NULL,NULL,1,'2025-05-19 18:32:09','2025-05-19 18:32:09',NULL),(2806,7566,40720,1566,3,2191,'App\\Models\\Receipt',2191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-01','2025-04-01',18500.00,NULL,NULL,1,'2025-05-19 19:20:34','2025-05-19 19:20:34',NULL),(2807,7566,40720,1566,3,2193,'App\\Models\\Receipt',2193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-03','2025-04-03',18500.00,NULL,NULL,1,'2025-05-19 19:20:59','2025-05-19 19:20:59',NULL),(2808,7566,40720,1566,3,2198,'App\\Models\\Receipt',2198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-04-09','2025-04-09',8197.25,NULL,NULL,1,'2025-05-19 19:33:03','2025-05-19 19:33:03',NULL),(2809,7566,40719,52,2,2231,'App\\Models\\Receipt',2231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',13000.00,NULL,NULL,1,'2025-05-21 19:50:21','2025-05-21 19:50:21',NULL),(2810,7566,40719,52,2,2232,'App\\Models\\Receipt',2232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',18000.00,NULL,NULL,1,'2025-05-21 19:52:28','2025-05-21 19:52:28',NULL),(2811,7566,40719,52,2,2233,'App\\Models\\Receipt',2233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',21000.00,NULL,NULL,1,'2025-05-21 19:53:20','2025-05-21 19:53:20',NULL),(2812,7566,40719,52,2,2234,'App\\Models\\Receipt',2234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',13000.00,NULL,NULL,1,'2025-05-21 19:54:35','2025-05-21 19:54:35',NULL),(2813,7566,40719,52,2,2235,'App\\Models\\Receipt',2235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',44200.09,NULL,NULL,1,'2025-05-21 19:57:48','2025-05-21 19:57:48',NULL),(2814,7566,40719,52,2,2236,'App\\Models\\Receipt',2236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',17000.00,NULL,NULL,1,'2025-05-21 19:58:35','2025-05-21 19:58:35',NULL),(2815,7566,40719,52,2,2237,'App\\Models\\Receipt',2237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',13000.00,NULL,NULL,1,'2025-05-21 19:59:24','2025-05-21 19:59:24',NULL),(2816,7566,40719,52,2,2238,'App\\Models\\Receipt',2238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',30000.00,NULL,NULL,1,'2025-05-21 20:00:29','2025-05-21 20:00:29',NULL),(2817,7566,40719,52,2,2239,'App\\Models\\Receipt',2239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',57221.31,NULL,NULL,1,'2025-05-21 20:01:51','2025-05-21 20:01:51',NULL),(2818,7566,40719,52,2,2240,'App\\Models\\Receipt',2240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',92000.00,NULL,NULL,1,'2025-05-21 20:02:45','2025-05-21 20:02:45',NULL);
INSERT INTO `balance_libro` VALUES (2819,7566,40719,52,2,2241,'App\\Models\\Receipt',2241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',18000.00,NULL,NULL,1,'2025-05-21 20:03:36','2025-05-21 20:03:36',NULL),(2820,7566,40719,52,2,2242,'App\\Models\\Receipt',2242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',18800.00,NULL,NULL,1,'2025-05-21 20:04:23','2025-05-21 20:04:23',NULL),(2821,7566,40719,52,2,2243,'App\\Models\\Receipt',2243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',69584.48,NULL,NULL,1,'2025-05-21 20:05:13','2025-05-21 20:05:13',NULL),(2822,7566,40719,52,2,2244,'App\\Models\\Receipt',2244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',15000.00,NULL,NULL,1,'2025-05-21 20:05:59','2025-05-21 20:05:59',NULL),(2823,7566,40719,52,2,2245,'App\\Models\\Receipt',2245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',14500.00,NULL,NULL,1,'2025-05-21 20:06:44','2025-05-21 20:06:44',NULL),(2824,7566,40719,52,2,2246,'App\\Models\\Receipt',2246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',16300.00,NULL,NULL,1,'2025-05-21 20:07:24','2025-05-21 20:07:24',NULL),(2825,7566,40719,52,2,2247,'App\\Models\\Receipt',2247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',14000.00,NULL,NULL,1,'2025-05-21 20:08:09','2025-05-21 20:08:09',NULL),(2826,7566,40719,52,2,2248,'App\\Models\\Receipt',2248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',63679.00,NULL,NULL,1,'2025-05-21 20:09:11','2025-05-21 20:09:11',NULL),(2827,7566,40719,52,2,2249,'App\\Models\\Receipt',2249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',12000.00,NULL,NULL,1,'2025-05-21 20:10:18','2025-05-21 20:10:18',NULL),(2828,7566,40719,52,2,2250,'App\\Models\\Receipt',2250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',14700.00,NULL,NULL,1,'2025-05-21 20:11:14','2025-05-21 20:11:14',NULL),(2829,7566,40719,52,2,2251,'App\\Models\\Receipt',2251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',12000.00,NULL,NULL,1,'2025-05-21 20:12:45','2025-05-21 20:12:45',NULL),(2830,7566,40719,52,2,2252,'App\\Models\\Receipt',2252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',13000.00,NULL,NULL,1,'2025-05-21 20:13:32','2025-05-21 20:13:32',NULL),(2831,7566,40719,52,2,2253,'App\\Models\\Receipt',2253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',189769.69,NULL,NULL,1,'2025-05-21 20:15:22','2025-05-21 20:15:22',NULL),(2832,7566,40719,52,2,2254,'App\\Models\\Receipt',2254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2025-05-21','2025-05-21',15000.00,NULL,NULL,1,'2025-05-21 20:16:07','2025-05-21 20:16:07',NULL);
/*!40000 ALTER TABLE `balance_libro` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro_details`
--

DROP TABLE IF EXISTS `balance_libro_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `balance_libro_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_details_person_id_foreign` (`person_id`),
  KEY `balance_libro_details_period_id_foreign` (`period_id`),
  KEY `balance_libro_details_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_details_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_libro_details_saldo_id_foreign` (`saldo_id`),
  KEY `balance_libro_details_balance_libro_id_foreign` (`balance_libro_id`),
  CONSTRAINT `balance_libro_details_balance_libro_id_foreign` FOREIGN KEY (`balance_libro_id`) REFERENCES `balance_libro` (`id`) ON DELETE CASCADE,
  CONSTRAINT `balance_libro_details_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_details_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `balance_libro_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8874 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro_details`
--

LOCK TABLES `balance_libro_details` WRITE;
/*!40000 ALTER TABLE `balance_libro_details` DISABLE KEYS */;
INSERT INTO `balance_libro_details` VALUES (1,7566,1,40720,1524,2,96,2,90149.37,NULL,'2022-08-19 17:24:23','2022-08-19 17:24:23',NULL),(2,7566,1,40720,1524,2,67,2,18931.37,NULL,'2022-08-19 17:24:23','2022-08-19 17:24:23',NULL),(3,7566,1,40720,1524,2,13,1,109080.74,NULL,'2022-08-19 17:24:23','2022-08-19 17:24:23',NULL),(4,7566,2,40720,1524,2,96,2,93333.45,NULL,'2022-08-19 17:27:19','2022-08-19 17:27:19',NULL),(5,7566,2,40720,1524,2,67,2,19600.02,NULL,'2022-08-19 17:27:19','2022-08-19 17:27:19',NULL),(6,7566,2,40720,1524,2,13,1,112933.47,NULL,'2022-08-19 17:27:19','2022-08-19 17:27:19',NULL),(7,7566,3,40720,1524,2,96,2,5614.18,NULL,'2022-08-19 17:32:07','2022-08-19 17:32:07',NULL),(8,7566,3,40720,1524,2,67,2,1178.98,NULL,'2022-08-19 17:32:07','2022-08-19 17:32:07',NULL),(9,7566,3,40720,1524,2,13,1,6793.16,NULL,'2022-08-19 17:32:07','2022-08-19 17:32:07',NULL),(10,7566,4,40720,1524,2,96,2,4193.40,NULL,'2022-08-19 17:35:00','2022-08-19 17:35:00',NULL),(11,7566,4,40720,1524,2,67,2,880.61,NULL,'2022-08-19 17:35:00','2022-08-19 17:35:00',NULL),(12,7566,4,40720,1524,2,13,1,5074.01,NULL,'2022-08-19 17:35:00','2022-08-19 17:35:00',NULL),(13,7566,5,40720,1524,2,96,2,171062.11,NULL,'2022-08-19 17:44:24','2022-08-19 17:44:24',NULL),(14,7566,5,40720,1524,2,67,2,35923.04,NULL,'2022-08-19 17:44:24','2022-08-19 17:44:24',NULL),(15,7566,5,40720,1524,2,13,1,206985.15,NULL,'2022-08-19 17:44:24','2022-08-19 17:44:24',NULL),(16,7566,6,40720,1524,3,38,1,38015.70,NULL,'2022-08-19 17:51:49','2022-08-19 17:51:49',NULL),(17,7566,6,40720,1524,3,68,1,7983.30,NULL,'2022-08-19 17:51:49','2022-08-19 17:51:49',NULL),(18,7566,6,40720,1524,3,57,2,45999.00,NULL,'2022-08-19 17:51:49','2022-08-19 17:51:49',NULL),(19,7566,7,40720,1524,3,135,1,5702.48,NULL,'2022-08-19 17:55:03','2022-08-19 17:55:03',NULL),(20,7566,7,40720,1524,3,68,1,1197.52,NULL,'2022-08-19 17:55:03','2022-08-19 17:55:03',NULL),(21,7566,7,40720,1524,3,57,2,6900.00,NULL,'2022-08-19 17:55:03','2022-08-19 17:55:03',NULL),(22,7566,8,40720,1524,3,217,1,1768.60,NULL,'2022-08-19 18:00:01','2022-08-19 18:00:01',NULL),(23,7566,8,40720,1524,3,68,1,371.41,NULL,'2022-08-19 18:00:01','2022-08-19 18:00:01',NULL),(24,7566,8,40720,1524,3,57,2,2140.01,NULL,'2022-08-19 18:00:01','2022-08-19 18:00:01',NULL),(25,7566,9,40720,1524,3,128,1,1638.49,NULL,'2022-08-19 18:04:26','2022-08-19 18:04:26',NULL),(26,7566,9,40720,1524,3,68,1,344.08,NULL,'2022-08-19 18:04:26','2022-08-19 18:04:26',NULL),(27,7566,9,40720,1524,3,223,1,17.42,NULL,'2022-08-19 18:04:26','2022-08-19 18:04:26',NULL),(28,7566,9,40720,1524,3,241,1,16.38,NULL,'2022-08-19 18:04:26','2022-08-19 18:04:26',NULL),(29,7566,9,40720,1524,3,57,2,2016.37,NULL,'2022-08-19 18:04:26','2022-08-19 18:04:26',NULL),(30,7566,10,40720,1524,3,217,1,4804.38,NULL,'2022-08-19 18:08:32','2022-08-19 18:09:23','2022-08-19 18:09:23'),(31,7566,10,40720,1524,3,68,1,1008.92,NULL,'2022-08-19 18:08:32','2022-08-19 18:09:23','2022-08-19 18:09:23'),(32,7566,10,40720,1524,3,217,1,753.89,NULL,'2022-08-19 18:08:32','2022-08-19 18:09:23','2022-08-19 18:09:23'),(33,7566,10,40720,1524,3,68,1,79.16,NULL,'2022-08-19 18:08:32','2022-08-19 18:09:23','2022-08-19 18:09:23'),(34,7566,10,40720,1524,3,220,1,155.44,NULL,'2022-08-19 18:08:32','2022-08-19 18:09:23','2022-08-19 18:09:23'),(35,7566,10,40720,1524,3,57,2,6801.79,NULL,'2022-08-19 18:08:32','2022-08-19 18:09:23','2022-08-19 18:09:23'),(36,7566,11,40720,1524,3,217,1,4804.38,NULL,'2022-08-19 18:09:23','2023-11-18 12:30:55','2023-11-18 12:30:55'),(37,7566,11,40720,1524,3,68,1,1008.92,NULL,'2022-08-19 18:09:23','2023-11-18 12:30:55','2023-11-18 12:30:55'),(38,7566,11,40720,1524,3,217,1,753.89,NULL,'2022-08-19 18:09:23','2023-11-18 12:30:55','2023-11-18 12:30:55'),(39,7566,11,40720,1524,3,68,1,79.16,NULL,'2022-08-19 18:09:23','2023-11-18 12:30:55','2023-11-18 12:30:55'),(40,7566,11,40720,1524,3,217,1,0.03,NULL,'2022-08-19 18:09:23','2023-11-18 12:30:55','2023-11-18 12:30:55'),(41,7566,11,40720,1524,3,220,1,155.44,NULL,'2022-08-19 18:09:23','2023-11-18 12:30:55','2023-11-18 12:30:55');
INSERT INTO `balance_libro_details` VALUES (42,7566,11,40720,1524,3,57,2,6801.82,NULL,'2022-08-19 18:09:23','2023-11-18 12:30:55','2023-11-18 12:30:55'),(43,7566,12,40720,1524,3,217,1,5993.45,NULL,'2022-08-19 18:11:54','2023-11-18 12:30:45','2023-11-18 12:30:45'),(44,7566,12,40720,1524,3,68,1,1258.62,NULL,'2022-08-19 18:11:54','2023-11-18 12:30:45','2023-11-18 12:30:45'),(45,7566,12,40720,1524,3,217,1,498.52,NULL,'2022-08-19 18:11:54','2023-11-18 12:30:45','2023-11-18 12:30:45'),(46,7566,12,40720,1524,3,68,1,52.34,NULL,'2022-08-19 18:11:54','2023-11-18 12:30:45','2023-11-18 12:30:45'),(47,7566,12,40720,1524,3,217,1,37.45,NULL,'2022-08-19 18:11:54','2023-11-18 12:30:45','2023-11-18 12:30:45'),(48,7566,12,40720,1524,3,220,1,187.28,NULL,'2022-08-19 18:11:54','2023-11-18 12:30:45','2023-11-18 12:30:45'),(49,7566,12,40720,1524,3,57,2,8027.67,NULL,'2022-08-19 18:11:54','2023-11-18 12:30:45','2023-11-18 12:30:45'),(50,7566,12,40720,1524,3,136,1,0.01,NULL,'2022-08-19 18:11:54','2023-11-18 12:30:45','2023-11-18 12:30:45'),(51,7566,13,40720,1524,3,217,1,3521.71,NULL,'2022-08-19 18:13:33','2023-11-18 12:30:34','2023-11-18 12:30:34'),(52,7566,13,40720,1524,3,68,1,739.56,NULL,'2022-08-19 18:13:33','2023-11-18 12:30:34','2023-11-18 12:30:34'),(53,7566,13,40720,1524,3,217,1,2076.52,NULL,'2022-08-19 18:13:33','2023-11-18 12:30:34','2023-11-18 12:30:34'),(54,7566,13,40720,1524,3,68,1,218.03,NULL,'2022-08-19 18:13:33','2023-11-18 12:30:34','2023-11-18 12:30:34'),(55,7566,13,40720,1524,3,220,1,136.80,NULL,'2022-08-19 18:13:33','2023-11-18 12:30:34','2023-11-18 12:30:34'),(56,7566,13,40720,1524,3,57,2,6692.62,NULL,'2022-08-19 18:13:33','2023-11-18 12:30:34','2023-11-18 12:30:34'),(57,7566,14,40720,1524,3,217,1,17026.27,NULL,'2022-08-19 18:20:41','2023-11-18 12:30:10','2023-11-18 12:30:10'),(58,7566,14,40720,1524,3,68,1,3575.52,NULL,'2022-08-19 18:20:41','2023-11-18 12:30:10','2023-11-18 12:30:10'),(59,7566,14,40720,1524,3,217,1,2269.79,NULL,'2022-08-19 18:20:41','2023-11-18 12:30:10','2023-11-18 12:30:10'),(60,7566,14,40720,1524,3,68,1,238.33,NULL,'2022-08-19 18:20:41','2023-11-18 12:30:10','2023-11-18 12:30:10'),(61,7566,14,40720,1524,3,217,1,83.59,NULL,'2022-08-19 18:20:41','2023-11-18 12:30:10','2023-11-18 12:30:10'),(62,7566,14,40720,1524,3,220,1,544.83,NULL,'2022-08-19 18:20:41','2023-11-18 12:30:10','2023-11-18 12:30:10'),(63,7566,14,40720,1524,3,239,1,192.96,NULL,'2022-08-19 18:20:41','2023-11-18 12:30:10','2023-11-18 12:30:10'),(64,7566,14,40720,1524,3,57,2,23931.28,NULL,'2022-08-19 18:20:41','2023-11-18 12:30:10','2023-11-18 12:30:10'),(65,7566,14,40720,1524,3,136,2,0.01,NULL,'2022-08-19 18:20:41','2023-11-18 12:30:10','2023-11-18 12:30:10'),(66,7566,15,40720,1524,3,217,1,698.34,NULL,'2022-08-19 18:21:47','2023-11-18 12:29:54','2023-11-18 12:29:54'),(67,7566,15,40720,1524,3,68,1,146.65,NULL,'2022-08-19 18:21:47','2023-11-18 12:29:54','2023-11-18 12:29:54'),(68,7566,15,40720,1524,3,217,1,0.01,NULL,'2022-08-19 18:21:47','2023-11-18 12:29:54','2023-11-18 12:29:54'),(69,7566,15,40720,1524,3,57,2,845.00,NULL,'2022-08-19 18:21:47','2023-11-18 12:29:54','2023-11-18 12:29:54'),(70,7566,16,40720,1524,3,128,1,1458.68,NULL,'2022-08-19 18:23:17','2022-08-22 16:57:04','2022-08-22 16:57:04'),(71,7566,16,40720,1524,3,68,1,306.32,NULL,'2022-08-19 18:23:17','2022-08-22 16:57:04','2022-08-22 16:57:04'),(72,7566,16,40720,1524,3,57,2,1765.00,NULL,'2022-08-19 18:23:17','2022-08-22 16:57:04','2022-08-22 16:57:04'),(73,7566,17,40720,1524,3,128,1,1161.16,NULL,'2022-08-19 18:24:44','2022-08-22 16:57:32','2022-08-22 16:57:32'),(74,7566,17,40720,1524,3,68,1,243.84,NULL,'2022-08-19 18:24:44','2022-08-22 16:57:32','2022-08-22 16:57:32'),(75,7566,17,40720,1524,3,57,2,1405.00,NULL,'2022-08-19 18:24:44','2022-08-22 16:57:32','2022-08-22 16:57:32'),(76,7566,18,40720,1524,3,128,1,4342.71,NULL,'2022-08-19 18:30:31','2022-08-22 19:02:03','2022-08-22 19:02:03'),(77,7566,18,40720,1524,3,68,1,911.97,NULL,'2022-08-19 18:30:31','2022-08-22 19:02:03','2022-08-22 19:02:03');
INSERT INTO `balance_libro_details` VALUES (78,7566,18,40720,1524,3,221,1,45.41,NULL,'2022-08-19 18:30:31','2022-08-22 19:02:03','2022-08-22 19:02:03'),(79,7566,18,40720,1524,3,239,1,43.88,NULL,'2022-08-19 18:30:31','2022-08-22 19:02:03','2022-08-22 19:02:03'),(80,7566,18,40720,1524,3,57,2,5343.97,NULL,'2022-08-19 18:30:31','2022-08-22 19:02:03','2022-08-22 19:02:03'),(81,7566,19,40720,1524,3,128,1,3934.00,NULL,'2022-08-19 18:32:28','2022-08-22 19:01:39','2022-08-22 19:01:39'),(82,7566,19,40720,1524,3,68,1,826.14,NULL,'2022-08-19 18:32:28','2022-08-22 19:01:39','2022-08-22 19:01:39'),(83,7566,19,40720,1524,3,221,1,42.46,NULL,'2022-08-19 18:32:28','2022-08-22 19:01:39','2022-08-22 19:01:39'),(84,7566,19,40720,1524,3,57,2,4802.60,NULL,'2022-08-19 18:32:28','2022-08-22 19:01:39','2022-08-22 19:01:39'),(85,7566,20,40720,1524,3,217,1,9586.78,NULL,'2022-08-19 18:34:43','2022-08-22 19:00:57','2022-08-22 19:00:57'),(86,7566,20,40720,1524,3,68,1,2013.22,NULL,'2022-08-19 18:34:43','2022-08-22 19:00:57','2022-08-22 19:00:57'),(87,7566,20,40720,1524,3,57,2,11600.00,NULL,'2022-08-19 18:34:43','2022-08-22 19:00:57','2022-08-22 19:00:57'),(88,7566,21,40720,1524,8,292,1,26895.40,NULL,'2022-08-19 18:40:50','2022-08-19 18:40:50',NULL),(89,7566,21,40720,1524,8,351,2,26895.40,NULL,'2022-08-19 18:40:50','2022-08-19 18:40:50',NULL),(90,7566,22,40720,1524,8,290,1,37.69,NULL,'2022-08-19 18:41:05','2022-08-19 18:41:05',NULL),(91,7566,22,40720,1524,8,351,2,37.69,NULL,'2022-08-19 18:41:05','2022-08-19 18:41:05',NULL),(92,7566,23,40720,1524,3,199,1,1983.47,NULL,'2022-08-19 19:10:59','2022-08-22 19:00:40','2022-08-22 19:00:40'),(93,7566,23,40720,1524,3,68,1,416.53,NULL,'2022-08-19 19:10:59','2022-08-22 19:00:40','2022-08-22 19:00:40'),(94,7566,23,40720,1524,3,57,2,2400.00,NULL,'2022-08-19 19:10:59','2022-08-22 19:00:40','2022-08-22 19:00:40'),(95,7566,24,40720,1524,3,128,1,4097.16,NULL,'2022-08-19 19:16:06','2022-08-22 19:00:25','2022-08-22 19:00:25'),(96,7566,24,40720,1524,3,68,1,860.40,NULL,'2022-08-19 19:16:06','2022-08-22 19:00:25','2022-08-22 19:00:25'),(97,7566,24,40720,1524,3,128,1,0.05,NULL,'2022-08-19 19:16:06','2022-08-22 19:00:25','2022-08-22 19:00:25'),(98,7566,24,40720,1524,3,221,1,42.89,NULL,'2022-08-19 19:16:06','2022-08-22 19:00:25','2022-08-22 19:00:25'),(99,7566,24,40720,1524,3,239,1,41.40,NULL,'2022-08-19 19:16:06','2022-08-22 19:00:25','2022-08-22 19:00:25'),(100,7566,24,40720,1524,3,57,2,5041.90,NULL,'2022-08-19 19:16:06','2022-08-22 19:00:25','2022-08-22 19:00:25'),(101,7566,25,40720,1524,3,135,1,3593.39,NULL,'2022-08-19 19:18:29','2022-08-22 18:53:23','2022-08-22 18:53:23'),(102,7566,25,40720,1524,3,68,1,754.61,NULL,'2022-08-19 19:18:29','2022-08-22 18:53:23','2022-08-22 18:53:23'),(103,7566,25,40720,1524,3,220,1,107.80,NULL,'2022-08-19 19:18:29','2022-08-22 18:53:23','2022-08-22 18:53:23'),(104,7566,25,40720,1524,3,239,1,71.87,NULL,'2022-08-19 19:18:29','2022-08-22 18:53:23','2022-08-22 18:53:23'),(105,7566,25,40720,1524,3,57,2,4527.67,NULL,'2022-08-19 19:18:29','2022-08-22 18:53:23','2022-08-22 18:53:23'),(106,7566,26,40720,1524,3,217,1,4669.20,NULL,'2022-08-19 19:24:11','2022-08-22 16:55:09','2022-08-22 16:55:09'),(107,7566,26,40720,1524,3,68,1,980.53,NULL,'2022-08-19 19:24:11','2022-08-22 16:55:09','2022-08-22 16:55:09'),(108,7566,26,40720,1524,3,217,1,0.02,NULL,'2022-08-19 19:24:11','2022-08-22 16:55:09','2022-08-22 16:55:09'),(109,7566,26,40720,1524,3,239,1,46.69,NULL,'2022-08-19 19:24:11','2022-08-22 16:55:09','2022-08-22 16:55:09'),(110,7566,26,40720,1524,3,57,2,5696.44,NULL,'2022-08-19 19:24:11','2022-08-22 16:55:09','2022-08-22 16:55:09'),(111,7566,27,40720,1524,3,217,1,8987.60,NULL,'2022-08-19 19:27:20','2022-08-22 18:52:51','2022-08-22 18:52:51'),(112,7566,27,40720,1524,3,68,1,1887.40,NULL,'2022-08-19 19:27:20','2022-08-22 18:52:51','2022-08-22 18:52:51'),(113,7566,27,40720,1524,3,57,2,10875.00,NULL,'2022-08-19 19:27:20','2022-08-22 18:52:51','2022-08-22 18:52:51');
INSERT INTO `balance_libro_details` VALUES (114,7566,28,40720,1524,3,217,1,27584.56,NULL,'2022-08-19 19:29:31','2022-08-22 18:52:25','2022-08-22 18:52:25'),(115,7566,28,40720,1524,3,68,1,5792.76,NULL,'2022-08-19 19:29:31','2022-08-22 18:52:25','2022-08-22 18:52:25'),(116,7566,28,40720,1524,3,217,1,80.71,NULL,'2022-08-19 19:29:31','2022-08-22 18:52:25','2022-08-22 18:52:25'),(117,7566,28,40720,1524,3,220,1,827.54,NULL,'2022-08-19 19:29:31','2022-08-22 18:52:25','2022-08-22 18:52:25'),(118,7566,28,40720,1524,3,239,1,275.85,NULL,'2022-08-19 19:29:31','2022-08-22 18:52:25','2022-08-22 18:52:25'),(119,7566,28,40720,1524,3,57,2,34561.42,NULL,'2022-08-19 19:29:31','2022-08-22 18:52:25','2022-08-22 18:52:25'),(120,7566,29,40720,1524,7,25,1,943.18,NULL,'2022-08-19 19:31:41','2022-08-19 19:31:41',NULL),(121,7566,29,40720,1524,7,13,2,943.18,NULL,'2022-08-19 19:31:41','2022-08-19 19:31:41',NULL),(122,7566,30,40720,1524,7,23,1,3421.24,NULL,'2022-08-19 19:34:35','2022-08-19 19:34:35',NULL),(123,7566,30,40720,1524,7,13,2,3421.24,NULL,'2022-08-19 19:34:35','2022-08-19 19:34:35',NULL),(124,7566,31,40720,1524,7,267,1,5456.20,NULL,'2022-08-19 19:35:54','2022-08-19 19:35:54',NULL),(125,7566,31,40720,1524,7,13,2,5456.20,NULL,'2022-08-19 19:35:54','2022-08-19 19:35:54',NULL),(126,7566,32,40720,1524,7,23,1,459.59,NULL,'2022-08-19 19:37:04','2022-08-19 19:37:04',NULL),(127,7566,32,40720,1524,7,13,2,459.59,NULL,'2022-08-19 19:37:04','2022-08-19 19:37:04',NULL),(128,7566,33,40720,1524,7,267,1,3112.03,NULL,'2022-08-19 19:38:05','2022-08-19 19:38:05',NULL),(129,7566,33,40720,1524,7,13,2,3112.03,NULL,'2022-08-19 19:38:05','2022-08-19 19:38:05',NULL),(130,7566,34,40720,1524,7,267,1,3045.21,NULL,'2022-08-19 20:03:28','2022-08-19 20:03:28',NULL),(131,7566,34,40720,1524,7,13,2,3045.21,NULL,'2022-08-19 20:03:28','2022-08-19 20:03:28',NULL),(132,7566,35,40720,1524,7,265,1,155.86,NULL,'2022-08-19 20:04:22','2022-08-19 20:04:22',NULL),(133,7566,35,40720,1524,7,13,2,155.86,NULL,'2022-08-19 20:04:22','2022-08-19 20:04:22',NULL),(134,7566,36,40720,1524,7,23,1,512.86,NULL,'2022-08-19 20:04:59','2022-08-19 20:04:59',NULL),(135,7566,36,40720,1524,7,13,2,512.86,NULL,'2022-08-19 20:04:59','2022-08-19 20:04:59',NULL),(136,7566,37,40720,1524,7,25,1,16699.58,NULL,'2022-08-19 20:06:14','2022-08-19 20:06:14',NULL),(137,7566,37,40720,1524,7,13,2,16699.58,NULL,'2022-08-19 20:06:14','2022-08-19 20:06:14',NULL),(138,7566,38,40720,1524,3,482,1,4669.20,NULL,'2022-08-22 16:55:09','2022-08-22 18:53:04','2022-08-22 18:53:04'),(139,7566,38,40720,1524,3,68,1,980.53,NULL,'2022-08-22 16:55:09','2022-08-22 18:53:04','2022-08-22 18:53:04'),(140,7566,38,40720,1524,3,482,1,0.02,NULL,'2022-08-22 16:55:09','2022-08-22 18:53:04','2022-08-22 18:53:04'),(141,7566,38,40720,1524,3,239,1,46.69,NULL,'2022-08-22 16:55:09','2022-08-22 18:53:04','2022-08-22 18:53:04'),(142,7566,38,40720,1524,3,57,2,5696.44,NULL,'2022-08-22 16:55:09','2022-08-22 18:53:04','2022-08-22 18:53:04'),(143,7566,39,40720,1524,3,483,1,1458.68,NULL,'2022-08-22 16:57:04','2022-08-22 16:57:04',NULL),(144,7566,39,40720,1524,3,68,1,306.32,NULL,'2022-08-22 16:57:04','2022-08-22 16:57:04',NULL),(145,7566,39,40720,1524,3,57,2,1765.00,NULL,'2022-08-22 16:57:04','2022-08-22 16:57:04',NULL),(146,7566,40,40720,1524,3,483,1,1161.16,NULL,'2022-08-22 16:57:32','2022-08-22 19:02:31','2022-08-22 19:02:31'),(147,7566,40,40720,1524,3,68,1,243.84,NULL,'2022-08-22 16:57:32','2022-08-22 19:02:31','2022-08-22 19:02:31'),(148,7566,40,40720,1524,3,57,2,1405.00,NULL,'2022-08-22 16:57:32','2022-08-22 19:02:31','2022-08-22 19:02:31'),(149,7566,41,40720,1524,3,483,1,27584.56,NULL,'2022-08-22 18:52:25','2022-08-22 18:52:25',NULL),(150,7566,41,40720,1524,3,68,1,5792.76,NULL,'2022-08-22 18:52:25','2022-08-22 18:52:25',NULL),(151,7566,41,40720,1524,3,483,1,80.71,NULL,'2022-08-22 18:52:25','2022-08-22 18:52:25',NULL),(152,7566,41,40720,1524,3,220,1,827.54,NULL,'2022-08-22 18:52:25','2022-08-22 18:52:25',NULL),(153,7566,41,40720,1524,3,239,1,275.85,NULL,'2022-08-22 18:52:25','2022-08-22 18:52:25',NULL);
INSERT INTO `balance_libro_details` VALUES (154,7566,41,40720,1524,3,57,2,34561.42,NULL,'2022-08-22 18:52:25','2022-08-22 18:52:25',NULL),(155,7566,42,40720,1524,3,135,1,8987.60,NULL,'2022-08-22 18:52:51','2022-08-22 18:52:51',NULL),(156,7566,42,40720,1524,3,68,1,1887.40,NULL,'2022-08-22 18:52:51','2022-08-22 18:52:51',NULL),(157,7566,42,40720,1524,3,57,2,10875.00,NULL,'2022-08-22 18:52:51','2022-08-22 18:52:51',NULL),(158,7566,43,40720,1524,3,482,1,4669.20,NULL,'2022-08-22 18:53:04','2022-08-22 18:53:04',NULL),(159,7566,43,40720,1524,3,68,1,980.53,NULL,'2022-08-22 18:53:04','2022-08-22 18:53:04',NULL),(160,7566,43,40720,1524,3,482,1,0.02,NULL,'2022-08-22 18:53:04','2022-08-22 18:53:04',NULL),(161,7566,43,40720,1524,3,239,1,46.69,NULL,'2022-08-22 18:53:04','2022-08-22 18:53:04',NULL),(162,7566,43,40720,1524,3,57,2,5696.44,NULL,'2022-08-22 18:53:04','2022-08-22 18:53:04',NULL),(163,7566,44,40720,1524,3,482,1,3593.39,NULL,'2022-08-22 18:53:23','2022-08-22 18:53:23',NULL),(164,7566,44,40720,1524,3,68,1,754.61,NULL,'2022-08-22 18:53:23','2022-08-22 18:53:23',NULL),(165,7566,44,40720,1524,3,220,1,107.80,NULL,'2022-08-22 18:53:23','2022-08-22 18:53:23',NULL),(166,7566,44,40720,1524,3,239,1,71.87,NULL,'2022-08-22 18:53:23','2022-08-22 18:53:23',NULL),(167,7566,44,40720,1524,3,57,2,4527.67,NULL,'2022-08-22 18:53:23','2022-08-22 18:53:23',NULL),(168,7566,45,40720,1524,3,484,1,4097.16,NULL,'2022-08-22 19:00:25','2022-08-22 19:00:25',NULL),(169,7566,45,40720,1524,3,68,1,860.40,NULL,'2022-08-22 19:00:25','2022-08-22 19:00:25',NULL),(170,7566,45,40720,1524,3,484,1,0.05,NULL,'2022-08-22 19:00:25','2022-08-22 19:00:25',NULL),(171,7566,45,40720,1524,3,221,1,42.89,NULL,'2022-08-22 19:00:25','2022-08-22 19:00:25',NULL),(172,7566,45,40720,1524,3,239,1,41.40,NULL,'2022-08-22 19:00:25','2022-08-22 19:00:25',NULL),(173,7566,45,40720,1524,3,57,2,5041.90,NULL,'2022-08-22 19:00:25','2022-08-22 19:00:25',NULL),(174,7566,46,40720,1524,3,199,1,1983.47,NULL,'2022-08-22 19:00:40','2022-08-22 19:00:40',NULL),(175,7566,46,40720,1524,3,68,1,416.53,NULL,'2022-08-22 19:00:40','2022-08-22 19:00:40',NULL),(176,7566,46,40720,1524,3,57,2,2400.00,NULL,'2022-08-22 19:00:40','2022-08-22 19:00:40',NULL),(177,7566,47,40720,1524,3,135,1,9586.78,NULL,'2022-08-22 19:00:57','2022-08-22 20:24:10','2022-08-22 20:24:10'),(178,7566,47,40720,1524,3,68,1,2013.22,NULL,'2022-08-22 19:00:57','2022-08-22 20:24:10','2022-08-22 20:24:10'),(179,7566,47,40720,1524,3,57,2,11600.00,NULL,'2022-08-22 19:00:57','2022-08-22 20:24:10','2022-08-22 20:24:10'),(180,7566,48,40720,1524,3,484,1,3934.00,NULL,'2022-08-22 19:01:39','2022-08-22 19:01:39',NULL),(181,7566,48,40720,1524,3,68,1,826.14,NULL,'2022-08-22 19:01:39','2022-08-22 19:01:39',NULL),(182,7566,48,40720,1524,3,221,1,42.46,NULL,'2022-08-22 19:01:39','2022-08-22 19:01:39',NULL),(183,7566,48,40720,1524,3,57,2,4802.60,NULL,'2022-08-22 19:01:39','2022-08-22 19:01:39',NULL),(184,7566,49,40720,1524,3,484,1,4342.71,NULL,'2022-08-22 19:02:03','2022-08-22 19:02:03',NULL),(185,7566,49,40720,1524,3,68,1,911.97,NULL,'2022-08-22 19:02:03','2022-08-22 19:02:03',NULL),(186,7566,49,40720,1524,3,221,1,45.41,NULL,'2022-08-22 19:02:03','2022-08-22 19:02:03',NULL),(187,7566,49,40720,1524,3,239,1,43.88,NULL,'2022-08-22 19:02:03','2022-08-22 19:02:03',NULL),(188,7566,49,40720,1524,3,57,2,5343.97,NULL,'2022-08-22 19:02:03','2022-08-22 19:02:03',NULL),(189,7566,50,40720,1524,3,483,1,1161.16,NULL,'2022-08-22 19:02:31','2022-08-22 19:02:31',NULL),(190,7566,50,40720,1524,3,68,1,243.84,NULL,'2022-08-22 19:02:31','2022-08-22 19:02:31',NULL),(191,7566,50,40720,1524,3,57,2,1405.00,NULL,'2022-08-22 19:02:31','2022-08-22 19:02:31',NULL),(192,7566,51,40720,1524,3,135,1,24380.17,NULL,'2022-08-22 19:13:27','2022-08-22 19:15:37','2022-08-22 19:15:37'),(193,7566,51,40720,1524,3,68,1,5119.84,NULL,'2022-08-22 19:13:27','2022-08-22 19:15:37','2022-08-22 19:15:37'),(194,7566,51,40720,1524,3,57,2,29500.01,NULL,'2022-08-22 19:13:27','2022-08-22 19:15:37','2022-08-22 19:15:37');
INSERT INTO `balance_libro_details` VALUES (195,7566,52,40720,1524,3,485,1,24380.17,NULL,'2022-08-22 19:15:37','2022-08-22 19:15:37',NULL),(196,7566,52,40720,1524,3,68,1,5119.84,NULL,'2022-08-22 19:15:37','2022-08-22 19:15:37',NULL),(197,7566,52,40720,1524,3,57,2,29500.01,NULL,'2022-08-22 19:15:37','2022-08-22 19:15:37',NULL),(198,7566,53,40720,1524,3,116,1,112.50,NULL,'2022-08-22 19:24:08','2022-08-22 19:25:47','2022-08-22 19:25:47'),(199,7566,53,40720,1524,3,68,1,23.63,NULL,'2022-08-22 19:24:08','2022-08-22 19:25:47','2022-08-22 19:25:47'),(200,7566,53,40720,1524,3,57,2,136.13,NULL,'2022-08-22 19:24:08','2022-08-22 19:25:47','2022-08-22 19:25:47'),(201,7566,54,40720,1524,3,116,1,11250.00,NULL,'2022-08-22 19:25:47','2022-08-22 19:25:47',NULL),(202,7566,54,40720,1524,3,57,2,11250.00,NULL,'2022-08-22 19:25:47','2022-08-22 19:25:47',NULL),(203,7566,55,40720,1524,3,135,1,9586.78,NULL,'2022-08-22 20:24:10','2022-08-22 20:24:10',NULL),(204,7566,55,40720,1524,3,68,1,2013.22,NULL,'2022-08-22 20:24:10','2022-08-22 20:24:10',NULL),(205,7566,55,40720,1524,3,57,2,11600.00,NULL,'2022-08-22 20:24:10','2022-08-22 20:24:10',NULL),(206,7566,56,40720,1526,2,96,2,112981.93,NULL,'2022-10-22 20:46:25','2022-10-22 20:46:25',NULL),(207,7566,56,40720,1526,2,67,2,23726.21,NULL,'2022-10-22 20:46:25','2022-10-22 20:46:25',NULL),(208,7566,56,40720,1526,2,13,1,136708.14,NULL,'2022-10-22 20:46:25','2022-10-22 20:46:25',NULL),(209,7566,57,40720,1526,2,96,2,106167.57,NULL,'2022-10-22 20:46:25','2022-10-22 20:46:25',NULL),(210,7566,57,40720,1526,2,67,2,22295.19,NULL,'2022-10-22 20:46:25','2022-10-22 20:46:25',NULL),(211,7566,57,40720,1526,2,13,1,128462.76,NULL,'2022-10-22 20:46:25','2022-10-22 20:46:25',NULL),(212,7566,58,40720,1526,2,96,2,5753.03,NULL,'2022-10-22 20:46:25','2022-10-22 20:46:25',NULL),(213,7566,58,40720,1526,2,67,2,1208.14,NULL,'2022-10-22 20:46:25','2022-10-22 20:46:25',NULL),(214,7566,58,40720,1526,2,13,1,6961.17,NULL,'2022-10-22 20:46:25','2022-10-22 20:46:25',NULL),(215,7566,59,40720,1526,2,96,2,4787.27,NULL,'2022-10-22 20:46:25','2022-10-22 20:46:25',NULL),(216,7566,59,40720,1526,2,67,2,1005.33,NULL,'2022-10-22 20:46:25','2022-10-22 20:46:25',NULL),(217,7566,59,40720,1526,2,13,1,5792.60,NULL,'2022-10-22 20:46:25','2022-10-22 20:46:25',NULL),(218,7566,60,40720,1526,2,96,2,205329.02,NULL,'2022-10-22 20:46:25','2022-10-22 20:46:25',NULL),(219,7566,60,40720,1526,2,67,2,43119.09,NULL,'2022-10-22 20:46:25','2022-10-22 20:46:25',NULL),(220,7566,60,40720,1526,2,13,1,248448.11,NULL,'2022-10-22 20:46:25','2022-10-22 20:46:25',NULL),(221,7566,61,40720,1525,2,96,2,95620.28,NULL,'2022-10-22 20:48:03','2022-10-22 20:48:03',NULL),(222,7566,61,40720,1525,2,67,2,20080.26,NULL,'2022-10-22 20:48:03','2022-10-22 20:48:03',NULL),(223,7566,61,40720,1525,2,13,1,115700.54,NULL,'2022-10-22 20:48:03','2022-10-22 20:48:03',NULL),(224,7566,62,40720,1525,2,96,2,99402.25,NULL,'2022-10-22 20:48:03','2022-10-22 20:48:03',NULL),(225,7566,62,40720,1525,2,67,2,20874.47,NULL,'2022-10-22 20:48:03','2022-10-22 20:48:03',NULL),(226,7566,62,40720,1525,2,13,1,120276.72,NULL,'2022-10-22 20:48:03','2022-10-22 20:48:03',NULL),(227,7566,63,40720,1525,2,96,2,4637.65,NULL,'2022-10-22 20:48:03','2022-10-22 20:48:03',NULL),(228,7566,63,40720,1525,2,67,2,973.91,NULL,'2022-10-22 20:48:03','2022-10-22 20:48:03',NULL),(229,7566,63,40720,1525,2,13,1,5611.56,NULL,'2022-10-22 20:48:03','2022-10-22 20:48:03',NULL),(230,7566,64,40720,1525,2,96,2,3837.37,NULL,'2022-10-22 20:48:03','2022-10-22 20:48:03',NULL),(231,7566,64,40720,1525,2,67,2,805.85,NULL,'2022-10-22 20:48:03','2022-10-22 20:48:03',NULL),(232,7566,64,40720,1525,2,13,1,4643.22,NULL,'2022-10-22 20:48:03','2022-10-22 20:48:03',NULL),(233,7566,65,40720,1525,2,96,2,187885.82,NULL,'2022-10-22 20:48:03','2022-10-22 20:48:03',NULL),(234,7566,65,40720,1525,2,67,2,39456.02,NULL,'2022-10-22 20:48:03','2022-10-22 20:48:03',NULL),(235,7566,65,40720,1525,2,13,1,227341.84,NULL,'2022-10-22 20:48:03','2022-10-22 20:48:03',NULL);
INSERT INTO `balance_libro_details` VALUES (236,7566,66,40720,1525,3,217,1,1983.47,NULL,'2022-10-22 21:17:18','2022-10-22 22:45:53','2022-10-22 22:45:53'),(237,7566,66,40720,1525,3,68,1,416.53,NULL,'2022-10-22 21:17:18','2022-10-22 22:45:53','2022-10-22 22:45:53'),(238,7566,66,40720,1525,3,57,2,2400.00,NULL,'2022-10-22 21:17:18','2022-10-22 22:45:53','2022-10-22 22:45:53'),(239,7566,67,40720,1525,3,217,1,3223.14,NULL,'2022-10-22 21:17:18','2022-10-22 21:17:18',NULL),(240,7566,67,40720,1525,3,68,1,676.86,NULL,'2022-10-22 21:17:18','2022-10-22 21:17:18',NULL),(241,7566,67,40720,1525,3,57,2,3900.00,NULL,'2022-10-22 21:17:18','2022-10-22 21:17:18',NULL),(242,7566,68,40720,1525,3,217,1,1611.57,NULL,'2022-10-22 21:17:18','2022-10-22 21:17:18',NULL),(243,7566,68,40720,1525,3,68,1,338.43,NULL,'2022-10-22 21:17:18','2022-10-22 21:17:18',NULL),(244,7566,68,40720,1525,3,57,2,1950.00,NULL,'2022-10-22 21:17:18','2022-10-22 21:17:18',NULL),(245,7566,69,40720,1525,3,217,1,2697.26,NULL,'2022-10-22 21:17:18','2022-10-22 22:24:30','2022-10-22 22:24:30'),(246,7566,69,40720,1525,3,68,1,312.72,NULL,'2022-10-22 21:17:18','2022-10-22 22:24:30','2022-10-22 22:24:30'),(247,7566,69,40720,1525,3,57,2,3009.98,NULL,'2022-10-22 21:17:18','2022-10-22 22:24:30','2022-10-22 22:24:30'),(248,7566,70,40720,1525,3,217,1,3305.79,NULL,'2022-10-22 21:17:18','2022-10-22 21:17:18',NULL),(249,7566,70,40720,1525,3,68,1,694.21,NULL,'2022-10-22 21:17:18','2022-10-22 21:17:18',NULL),(250,7566,70,40720,1525,3,57,2,4000.00,NULL,'2022-10-22 21:17:18','2022-10-22 21:17:18',NULL),(251,7566,71,40720,1525,3,217,1,2380.17,NULL,'2022-10-22 21:17:18','2022-10-22 21:17:18',NULL),(252,7566,71,40720,1525,3,68,1,499.83,NULL,'2022-10-22 21:17:18','2022-10-22 21:17:18',NULL),(253,7566,71,40720,1525,3,57,2,2880.00,NULL,'2022-10-22 21:17:18','2022-10-22 21:17:18',NULL),(254,7566,72,40720,1525,3,217,1,2396.69,NULL,'2022-10-22 21:17:18','2022-10-22 21:17:18',NULL),(255,7566,72,40720,1525,3,68,1,503.31,NULL,'2022-10-22 21:17:18','2022-10-22 21:17:18',NULL),(256,7566,72,40720,1525,3,57,2,2900.00,NULL,'2022-10-22 21:17:18','2022-10-22 21:17:18',NULL),(257,7566,73,40720,1525,3,217,1,1400.41,NULL,'2022-10-22 21:17:18','2023-11-18 12:38:32','2023-11-18 12:38:32'),(258,7566,73,40720,1525,3,68,1,294.09,NULL,'2022-10-22 21:17:18','2023-11-18 12:38:32','2023-11-18 12:38:32'),(259,7566,73,40720,1525,3,57,2,1694.50,NULL,'2022-10-22 21:17:18','2023-11-18 12:38:32','2023-11-18 12:38:32'),(260,7566,74,40720,1525,3,217,1,3109.93,NULL,'2022-10-22 21:17:18','2022-10-22 22:27:26','2022-10-22 22:27:26'),(261,7566,74,40720,1525,3,68,1,374.27,NULL,'2022-10-22 21:17:18','2022-10-22 22:27:26','2022-10-22 22:27:26'),(262,7566,74,40720,1525,3,57,2,3484.20,NULL,'2022-10-22 21:17:18','2022-10-22 22:27:26','2022-10-22 22:27:26'),(263,7566,75,40720,1525,3,217,1,2247.93,NULL,'2022-10-22 21:17:18','2022-10-22 21:17:18',NULL),(264,7566,75,40720,1525,3,68,1,472.07,NULL,'2022-10-22 21:17:18','2022-10-22 21:17:18',NULL),(265,7566,75,40720,1525,3,57,2,2720.00,NULL,'2022-10-22 21:17:18','2022-10-22 21:17:18',NULL),(266,7566,76,40720,1525,3,217,1,4242.53,NULL,'2022-10-22 21:17:18','2022-10-22 21:17:18',NULL),(267,7566,76,40720,1525,3,68,1,445.47,NULL,'2022-10-22 21:17:18','2022-10-22 21:17:18',NULL),(268,7566,76,40720,1525,3,57,2,4688.00,NULL,'2022-10-22 21:17:18','2022-10-22 21:17:18',NULL),(269,7566,77,40720,1525,3,217,1,2082.64,NULL,'2022-10-22 21:17:18','2022-10-22 21:17:18',NULL),(270,7566,77,40720,1525,3,68,1,437.36,NULL,'2022-10-22 21:17:18','2022-10-22 21:17:18',NULL),(271,7566,77,40720,1525,3,57,2,2520.00,NULL,'2022-10-22 21:17:18','2022-10-22 21:17:18',NULL),(272,7566,78,40720,1525,3,199,1,2947.93,NULL,'2022-10-22 21:23:57','2022-10-22 21:23:57',NULL),(273,7566,78,40720,1525,3,68,1,619.07,NULL,'2022-10-22 21:23:57','2022-10-22 21:23:57',NULL),(274,7566,78,40720,1525,3,220,1,88.44,NULL,'2022-10-22 21:23:57','2022-10-22 21:23:57',NULL),(275,7566,78,40720,1525,3,241,1,29.48,NULL,'2022-10-22 21:23:57','2022-10-22 21:23:57',NULL);
INSERT INTO `balance_libro_details` VALUES (276,7566,78,40720,1525,3,57,2,3684.92,NULL,'2022-10-22 21:23:57','2022-10-22 21:23:57',NULL),(277,7566,79,40720,1525,3,199,1,1983.47,NULL,'2022-10-22 21:27:16','2022-10-22 22:04:30','2022-10-22 22:04:30'),(278,7566,79,40720,1525,3,68,1,416.53,NULL,'2022-10-22 21:27:16','2022-10-22 22:04:30','2022-10-22 22:04:30'),(279,7566,79,40720,1525,3,57,2,2400.00,NULL,'2022-10-22 21:27:16','2022-10-22 22:04:30','2022-10-22 22:04:30'),(280,7566,80,40720,1525,3,484,1,3933.48,NULL,'2022-10-22 21:28:47','2022-10-22 21:28:47',NULL),(281,7566,80,40720,1525,3,68,1,826.03,NULL,'2022-10-22 21:28:47','2022-10-22 21:28:47',NULL),(282,7566,80,40720,1525,3,484,1,41.18,NULL,'2022-10-22 21:28:47','2022-10-22 21:28:47',NULL),(283,7566,80,40720,1525,3,239,1,39.75,NULL,'2022-10-22 21:28:47','2022-10-22 21:28:47',NULL),(284,7566,80,40720,1525,3,57,2,4840.44,NULL,'2022-10-22 21:28:47','2022-10-22 21:28:47',NULL),(285,7566,81,40720,1525,3,485,1,11487.60,NULL,'2022-10-22 21:30:13','2022-10-22 22:04:59','2022-10-22 22:04:59'),(286,7566,81,40720,1525,3,68,1,2412.40,NULL,'2022-10-22 21:30:13','2022-10-22 22:04:59','2022-10-22 22:04:59'),(287,7566,81,40720,1525,3,57,2,13900.00,NULL,'2022-10-22 21:30:13','2022-10-22 22:04:59','2022-10-22 22:04:59'),(288,7566,82,40720,1525,3,484,1,4492.24,NULL,'2022-10-22 21:31:47','2022-10-22 22:06:03','2022-10-22 22:06:03'),(289,7566,82,40720,1525,3,68,1,943.37,NULL,'2022-10-22 21:31:47','2022-10-22 22:06:03','2022-10-22 22:06:03'),(290,7566,82,40720,1525,3,484,1,48.49,NULL,'2022-10-22 21:31:47','2022-10-22 22:06:03','2022-10-22 22:06:03'),(291,7566,82,40720,1525,3,57,2,5484.10,NULL,'2022-10-22 21:31:47','2022-10-22 22:06:03','2022-10-22 22:06:03'),(292,7566,83,40720,1525,3,135,1,14296.69,NULL,'2022-10-22 21:33:20','2022-10-22 21:33:20',NULL),(293,7566,83,40720,1525,3,68,1,3002.30,NULL,'2022-10-22 21:33:20','2022-10-22 21:33:20',NULL),(294,7566,83,40720,1525,3,57,2,17298.99,NULL,'2022-10-22 21:33:20','2022-10-22 21:33:20',NULL),(295,7566,84,40720,1525,3,135,1,3719.01,NULL,'2022-10-22 21:34:38','2022-10-22 21:34:38',NULL),(296,7566,84,40720,1525,3,68,1,780.99,NULL,'2022-10-22 21:34:38','2022-10-22 21:34:38',NULL),(297,7566,84,40720,1525,3,57,2,4500.00,NULL,'2022-10-22 21:34:38','2022-10-22 21:34:38',NULL),(298,7566,85,40720,1525,3,484,1,4755.74,NULL,'2022-10-22 21:37:50','2022-10-22 21:37:50',NULL),(299,7566,85,40720,1525,3,68,1,998.71,NULL,'2022-10-22 21:37:50','2022-10-22 21:37:50',NULL),(300,7566,85,40720,1525,3,484,1,45.96,NULL,'2022-10-22 21:37:50','2022-10-22 21:37:50',NULL),(301,7566,85,40720,1525,3,241,1,47.56,NULL,'2022-10-22 21:37:50','2022-10-22 21:37:50',NULL),(302,7566,85,40720,1525,3,57,2,5847.97,NULL,'2022-10-22 21:37:50','2022-10-22 21:37:50',NULL),(303,7566,86,40720,1525,3,135,1,2371.90,NULL,'2022-10-22 21:39:17','2022-10-22 21:39:17',NULL),(304,7566,86,40720,1525,3,68,1,498.10,NULL,'2022-10-22 21:39:17','2022-10-22 21:39:17',NULL),(305,7566,86,40720,1525,3,57,2,2870.00,NULL,'2022-10-22 21:39:17','2022-10-22 21:39:17',NULL),(306,7566,87,40720,1525,3,485,1,32500.00,NULL,'2022-10-22 21:40:21','2022-10-22 21:40:21',NULL),(307,7566,87,40720,1525,3,68,1,6825.00,NULL,'2022-10-22 21:40:21','2022-10-22 21:40:21',NULL),(308,7566,87,40720,1525,3,57,2,39325.00,NULL,'2022-10-22 21:40:21','2022-10-22 21:40:21',NULL),(309,7566,88,40720,1525,3,485,1,20000.00,NULL,'2022-10-22 21:40:52','2022-10-22 21:40:52',NULL),(310,7566,88,40720,1525,3,68,1,4200.00,NULL,'2022-10-22 21:40:52','2022-10-22 21:40:52',NULL),(311,7566,88,40720,1525,3,57,2,24200.00,NULL,'2022-10-22 21:40:52','2022-10-22 21:40:52',NULL),(312,7566,89,40720,1525,3,482,1,25400.00,NULL,'2022-10-22 21:42:24','2022-10-22 21:42:24',NULL),(313,7566,89,40720,1525,3,68,1,5334.00,NULL,'2022-10-22 21:42:24','2022-10-22 21:42:24',NULL),(314,7566,89,40720,1525,3,57,2,30734.00,NULL,'2022-10-22 21:42:24','2022-10-22 21:42:24',NULL),(315,7566,90,40720,1525,3,135,1,2892.56,NULL,'2022-10-22 21:43:11','2022-10-22 21:43:11',NULL);
INSERT INTO `balance_libro_details` VALUES (316,7566,90,40720,1525,3,68,1,607.44,NULL,'2022-10-22 21:43:11','2022-10-22 21:43:11',NULL),(317,7566,90,40720,1525,3,57,2,3500.00,NULL,'2022-10-22 21:43:11','2022-10-22 21:43:11',NULL),(318,7566,91,40720,1525,3,482,1,17500.00,NULL,'2022-10-22 21:44:03','2022-10-22 21:44:03',NULL),(319,7566,91,40720,1525,3,68,1,3675.00,NULL,'2022-10-22 21:44:03','2022-10-22 21:44:03',NULL),(320,7566,91,40720,1525,3,57,2,21175.00,NULL,'2022-10-22 21:44:03','2022-10-22 21:44:03',NULL),(321,7566,92,40720,1525,3,199,1,2947.93,NULL,'2022-10-22 21:45:36','2022-10-22 22:34:11','2022-10-22 22:34:11'),(322,7566,92,40720,1525,3,68,1,619.07,NULL,'2022-10-22 21:45:36','2022-10-22 22:34:11','2022-10-22 22:34:11'),(323,7566,92,40720,1525,3,220,1,88.44,NULL,'2022-10-22 21:45:36','2022-10-22 22:34:11','2022-10-22 22:34:11'),(324,7566,92,40720,1525,3,241,1,29.48,NULL,'2022-10-22 21:45:36','2022-10-22 22:34:11','2022-10-22 22:34:11'),(325,7566,92,40720,1525,3,57,2,3684.92,NULL,'2022-10-22 21:45:36','2022-10-22 22:34:11','2022-10-22 22:34:11'),(326,7566,93,40720,1525,7,25,1,779.13,NULL,'2022-10-22 21:49:33','2022-10-22 21:49:33',NULL),(327,7566,93,40720,1525,7,13,2,779.13,NULL,'2022-10-22 21:49:33','2022-10-22 21:49:33',NULL),(328,7566,94,40720,1525,7,25,1,17.29,NULL,'2022-10-22 21:49:33','2022-10-22 21:49:33',NULL),(329,7566,94,40720,1525,7,13,2,17.29,NULL,'2022-10-22 21:49:33','2022-10-22 21:49:33',NULL),(330,7566,95,40720,1525,7,25,1,898.34,NULL,'2022-10-22 21:49:33','2022-10-22 21:49:33',NULL),(331,7566,95,40720,1525,7,13,2,898.34,NULL,'2022-10-22 21:49:33','2022-10-22 21:49:33',NULL),(332,7566,96,40720,1525,7,25,1,48.38,NULL,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(333,7566,96,40720,1525,7,13,2,48.38,NULL,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(334,7566,97,40720,1525,7,25,1,11.40,NULL,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(335,7566,97,40720,1525,7,13,2,11.40,NULL,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(336,7566,98,40720,1525,7,25,1,213.19,NULL,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(337,7566,98,40720,1525,7,13,2,213.19,NULL,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(338,7566,99,40720,1525,7,25,1,3872.27,NULL,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(339,7566,99,40720,1525,7,13,2,3872.27,NULL,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(340,7566,100,40720,1525,7,25,1,349.19,NULL,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(341,7566,100,40720,1525,7,13,2,349.19,NULL,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(342,7566,101,40720,1525,7,25,1,3.75,NULL,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(343,7566,101,40720,1525,7,13,2,3.75,NULL,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(344,7566,102,40720,1525,7,25,1,1744.26,NULL,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(345,7566,102,40720,1525,7,13,2,1744.26,NULL,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(346,7566,103,40720,1525,7,25,1,315.69,NULL,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(347,7566,103,40720,1525,7,13,2,315.69,NULL,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(348,7566,104,40720,1525,7,25,1,48.39,NULL,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(349,7566,104,40720,1525,7,13,2,48.39,NULL,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(350,7566,105,40720,1525,7,25,1,6177.58,NULL,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(351,7566,105,40720,1525,7,13,2,6177.58,NULL,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(352,7566,106,40720,1525,7,25,1,90.11,NULL,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(353,7566,106,40720,1525,7,13,2,90.11,NULL,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(354,7566,107,40720,1525,7,25,1,603.79,NULL,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(355,7566,107,40720,1525,7,13,2,603.79,NULL,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(356,7566,108,40720,1525,7,25,1,147.95,NULL,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL);
INSERT INTO `balance_libro_details` VALUES (357,7566,108,40720,1525,7,13,2,147.95,NULL,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(358,7566,109,40720,1525,7,25,1,2268.54,NULL,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(359,7566,109,40720,1525,7,13,2,2268.54,NULL,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(360,7566,110,40720,1525,7,25,1,1026.03,NULL,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(361,7566,110,40720,1525,7,13,2,1026.03,NULL,'2022-10-22 21:49:34','2022-10-22 21:49:34',NULL),(362,7566,111,40720,1525,8,290,1,28.39,NULL,'2022-10-22 21:50:53','2022-10-22 21:50:53',NULL),(363,7566,111,40720,1525,8,351,2,28.39,NULL,'2022-10-22 21:50:53','2022-10-22 21:50:53',NULL),(364,7566,112,40720,1525,8,292,1,20260.50,NULL,'2022-10-22 21:50:53','2022-10-22 21:50:53',NULL),(365,7566,112,40720,1525,8,351,2,20260.50,NULL,'2022-10-22 21:50:53','2022-10-22 21:50:53',NULL),(366,7566,113,40720,1525,3,485,1,11487.60,NULL,'2022-10-22 22:04:59','2022-10-22 22:05:20','2022-10-22 22:05:20'),(367,7566,113,40720,1525,3,68,1,2412.40,NULL,'2022-10-22 22:04:59','2022-10-22 22:05:20','2022-10-22 22:05:20'),(368,7566,113,40720,1525,3,57,2,13900.00,NULL,'2022-10-22 22:04:59','2022-10-22 22:05:20','2022-10-22 22:05:20'),(369,7566,114,40720,1526,3,485,1,11487.60,NULL,'2022-10-22 22:05:20','2022-10-22 23:41:45','2022-10-22 23:41:45'),(370,7566,114,40720,1526,3,68,1,2412.40,NULL,'2022-10-22 22:05:20','2022-10-22 23:41:45','2022-10-22 23:41:45'),(371,7566,114,40720,1526,3,57,2,13900.00,NULL,'2022-10-22 22:05:20','2022-10-22 23:41:45','2022-10-22 23:41:45'),(372,7566,115,40720,1526,3,484,1,4492.24,NULL,'2022-10-22 22:06:03','2022-10-22 23:41:54','2022-10-22 23:41:54'),(373,7566,115,40720,1526,3,68,1,943.37,NULL,'2022-10-22 22:06:03','2022-10-22 23:41:54','2022-10-22 23:41:54'),(374,7566,115,40720,1526,3,484,1,48.49,NULL,'2022-10-22 22:06:03','2022-10-22 23:41:54','2022-10-22 23:41:54'),(375,7566,115,40720,1526,3,57,2,5484.10,NULL,'2022-10-22 22:06:03','2022-10-22 23:41:54','2022-10-22 23:41:54'),(376,7566,116,40720,1525,3,217,1,280.97,NULL,'2022-10-22 22:24:30','2022-10-22 22:24:30',NULL),(377,7566,116,40720,1525,3,68,1,59.00,NULL,'2022-10-22 22:24:30','2022-10-22 22:24:30',NULL),(378,7566,116,40720,1525,3,217,1,2416.29,NULL,'2022-10-22 22:24:30','2022-10-22 22:24:30',NULL),(379,7566,116,40720,1525,3,68,1,253.71,NULL,'2022-10-22 22:24:30','2022-10-22 22:24:30',NULL),(380,7566,116,40720,1525,3,217,1,0.01,NULL,'2022-10-22 22:24:30','2022-10-22 22:24:30',NULL),(381,7566,116,40720,1525,3,57,2,3009.98,NULL,'2022-10-22 22:24:30','2022-10-22 22:24:30',NULL),(382,7566,117,40720,1525,3,217,1,454.54,NULL,'2022-10-22 22:27:26','2023-11-18 12:38:47','2023-11-18 12:38:47'),(383,7566,117,40720,1525,3,68,1,95.45,NULL,'2022-10-22 22:27:26','2023-11-18 12:38:47','2023-11-18 12:38:47'),(384,7566,117,40720,1525,3,217,1,2655.39,NULL,'2022-10-22 22:27:26','2023-11-18 12:38:47','2023-11-18 12:38:47'),(385,7566,117,40720,1525,3,68,1,278.82,NULL,'2022-10-22 22:27:26','2023-11-18 12:38:47','2023-11-18 12:38:47'),(386,7566,117,40720,1525,3,57,2,3484.20,NULL,'2022-10-22 22:27:26','2023-11-18 12:38:47','2023-11-18 12:38:47'),(387,7566,118,40720,1525,3,484,1,4492.24,NULL,'2022-10-22 22:35:56','2022-10-22 22:35:56',NULL),(388,7566,118,40720,1525,3,68,1,943.37,NULL,'2022-10-22 22:35:56','2022-10-22 22:35:56',NULL),(389,7566,118,40720,1525,3,484,1,48.49,NULL,'2022-10-22 22:35:56','2022-10-22 22:35:56',NULL),(390,7566,118,40720,1525,3,57,2,5484.10,NULL,'2022-10-22 22:35:56','2022-10-22 22:35:56',NULL),(391,7566,119,40720,1525,3,485,1,11487.60,NULL,'2022-10-22 22:37:19','2022-10-22 22:37:36','2022-10-22 22:37:36'),(392,7566,119,40720,1525,3,68,1,2412.40,NULL,'2022-10-22 22:37:19','2022-10-22 22:37:36','2022-10-22 22:37:36'),(393,7566,119,40720,1525,3,57,2,13900.00,NULL,'2022-10-22 22:37:19','2022-10-22 22:37:36','2022-10-22 22:37:36'),(394,7566,120,40720,1525,3,485,1,11487.60,NULL,'2022-10-22 22:37:36','2022-10-22 22:37:36',NULL);
INSERT INTO `balance_libro_details` VALUES (395,7566,120,40720,1525,3,68,1,2412.40,NULL,'2022-10-22 22:37:36','2022-10-22 22:37:36',NULL),(396,7566,120,40720,1525,3,57,2,13900.00,NULL,'2022-10-22 22:37:36','2022-10-22 22:37:36',NULL),(397,7566,121,40720,1525,3,199,1,1983.47,NULL,'2022-10-22 22:45:53','2022-10-22 22:45:53',NULL),(398,7566,121,40720,1525,3,68,1,416.53,NULL,'2022-10-22 22:45:53','2022-10-22 22:45:53',NULL),(399,7566,121,40720,1525,3,57,2,2400.00,NULL,'2022-10-22 22:45:53','2022-10-22 22:45:53',NULL),(400,7566,122,40720,1525,7,265,1,109.42,NULL,'2022-10-22 23:22:36','2022-10-22 23:22:36',NULL),(401,7566,122,40720,1525,7,13,2,109.42,NULL,'2022-10-22 23:22:36','2022-10-22 23:22:36',NULL),(402,7566,123,40720,1525,7,265,1,22.55,NULL,'2022-10-22 23:23:08','2022-10-22 23:23:08',NULL),(403,7566,123,40720,1525,7,13,2,22.55,NULL,'2022-10-22 23:23:08','2022-10-22 23:23:08',NULL),(404,7566,124,40720,1525,7,265,1,39.65,NULL,'2022-10-22 23:23:39','2022-10-22 23:23:39',NULL),(405,7566,124,40720,1525,7,13,2,39.65,NULL,'2022-10-22 23:23:39','2022-10-22 23:23:39',NULL),(406,7566,125,40720,1525,7,265,1,0.27,NULL,'2022-10-22 23:24:59','2022-10-22 23:24:59',NULL),(407,7566,125,40720,1525,7,13,2,0.27,NULL,'2022-10-22 23:24:59','2022-10-22 23:24:59',NULL),(408,7566,126,40720,1525,7,265,1,1.23,NULL,'2022-10-22 23:25:33','2022-10-22 23:25:33',NULL),(409,7566,126,40720,1525,7,13,2,1.23,NULL,'2022-10-22 23:25:33','2022-10-22 23:25:33',NULL),(410,7566,127,40720,1525,7,267,1,3292.24,NULL,'2022-10-22 23:26:43','2022-10-22 23:26:43',NULL),(411,7566,127,40720,1525,7,13,2,3292.24,NULL,'2022-10-22 23:26:43','2022-10-22 23:26:43',NULL),(412,7566,128,40720,1525,7,267,1,209.85,NULL,'2022-10-22 23:27:22','2022-10-22 23:27:22',NULL),(413,7566,128,40720,1525,7,13,2,209.85,NULL,'2022-10-22 23:27:22','2022-10-22 23:27:22',NULL),(414,7566,129,40720,1525,7,267,1,385.58,NULL,'2022-10-22 23:27:56','2022-10-22 23:27:56',NULL),(415,7566,129,40720,1525,7,13,2,385.58,NULL,'2022-10-22 23:27:56','2022-10-22 23:27:56',NULL),(416,7566,130,40720,1525,7,267,1,30.83,NULL,'2022-10-22 23:28:30','2022-10-22 23:28:30',NULL),(417,7566,130,40720,1525,7,13,2,30.83,NULL,'2022-10-22 23:28:30','2022-10-22 23:28:30',NULL),(418,7566,131,40720,1525,7,267,1,125.78,NULL,'2022-10-22 23:28:58','2022-10-22 23:28:58',NULL),(419,7566,131,40720,1525,7,13,2,125.78,NULL,'2022-10-22 23:28:58','2022-10-22 23:28:58',NULL),(420,7566,132,40720,1525,7,267,1,18.78,NULL,'2022-10-22 23:29:22','2022-10-22 23:29:22',NULL),(421,7566,132,40720,1525,7,13,2,18.78,NULL,'2022-10-22 23:29:22','2022-10-22 23:29:22',NULL),(422,7566,133,40720,1525,7,267,1,1043.86,NULL,'2022-10-22 23:29:55','2022-10-22 23:29:55',NULL),(423,7566,133,40720,1525,7,13,2,1043.86,NULL,'2022-10-22 23:29:55','2022-10-22 23:29:55',NULL),(424,7566,134,40720,1525,7,267,1,10.08,NULL,'2022-10-22 23:30:21','2022-10-22 23:30:21',NULL),(425,7566,134,40720,1525,7,13,2,10.08,NULL,'2022-10-22 23:30:21','2022-10-22 23:30:21',NULL),(426,7566,135,40720,1525,7,267,1,13.15,NULL,'2022-10-22 23:30:50','2022-10-22 23:30:50',NULL),(427,7566,135,40720,1525,7,13,2,13.15,NULL,'2022-10-22 23:30:50','2022-10-22 23:30:50',NULL),(428,7566,136,40720,1525,7,267,1,270.87,NULL,'2022-10-22 23:31:16','2022-10-22 23:31:16',NULL),(429,7566,136,40720,1525,7,13,2,270.87,NULL,'2022-10-22 23:31:16','2022-10-22 23:31:16',NULL),(430,7566,137,40720,1525,7,267,1,0.15,NULL,'2022-10-22 23:31:43','2022-10-22 23:31:43',NULL),(431,7566,137,40720,1525,7,13,2,0.15,NULL,'2022-10-22 23:31:43','2022-10-22 23:31:43',NULL),(432,7566,138,40720,1525,7,267,1,6072.86,NULL,'2022-10-22 23:32:29','2022-10-22 23:32:29',NULL),(433,7566,138,40720,1525,7,13,2,6072.86,NULL,'2022-10-22 23:32:29','2022-10-22 23:32:29',NULL),(434,7566,139,40720,1525,7,267,1,96.86,NULL,'2022-10-22 23:33:02','2022-10-22 23:33:02',NULL),(435,7566,139,40720,1525,7,13,2,96.86,NULL,'2022-10-22 23:33:02','2022-10-22 23:33:02',NULL),(436,7566,140,40720,1525,7,267,1,72.75,NULL,'2022-10-22 23:33:42','2022-10-22 23:33:42',NULL);
INSERT INTO `balance_libro_details` VALUES (437,7566,140,40720,1525,7,13,2,72.75,NULL,'2022-10-22 23:33:42','2022-10-22 23:33:42',NULL),(438,7566,141,40720,1525,7,267,1,806.73,NULL,'2022-10-22 23:34:06','2022-10-22 23:34:06',NULL),(439,7566,141,40720,1525,7,13,2,806.73,NULL,'2022-10-22 23:34:06','2022-10-22 23:34:06',NULL),(440,7566,142,40720,1525,7,267,1,44.41,NULL,'2022-10-22 23:34:27','2022-10-22 23:34:27',NULL),(441,7566,142,40720,1525,7,13,2,44.41,NULL,'2022-10-22 23:34:27','2022-10-22 23:34:27',NULL),(442,7566,143,40720,1525,7,267,1,2.37,NULL,'2022-10-22 23:34:53','2022-10-22 23:34:53',NULL),(443,7566,143,40720,1525,7,13,2,2.37,NULL,'2022-10-22 23:34:53','2022-10-22 23:34:53',NULL),(444,7566,144,40720,1525,7,267,1,10.09,NULL,'2022-10-22 23:35:14','2022-10-22 23:35:14',NULL),(445,7566,144,40720,1525,7,13,2,10.09,NULL,'2022-10-22 23:35:14','2022-10-22 23:35:14',NULL),(446,7566,145,40720,1525,7,267,1,187.15,NULL,'2022-10-22 23:35:37','2022-10-22 23:35:37',NULL),(447,7566,145,40720,1525,7,13,2,187.15,NULL,'2022-10-22 23:35:37','2022-10-22 23:35:37',NULL),(448,7566,146,40720,1525,7,267,1,0.72,NULL,'2022-10-22 23:36:02','2022-10-22 23:36:02',NULL),(449,7566,146,40720,1525,7,13,2,0.72,NULL,'2022-10-22 23:36:02','2022-10-22 23:36:02',NULL),(450,7566,147,40720,1526,3,217,1,2148.76,NULL,'2022-10-22 23:50:06','2022-10-22 23:58:23','2022-10-22 23:58:23'),(451,7566,147,40720,1526,3,68,1,451.24,NULL,'2022-10-22 23:50:06','2022-10-22 23:58:23','2022-10-22 23:58:23'),(452,7566,147,40720,1526,3,57,2,2600.00,NULL,'2022-10-22 23:50:06','2022-10-22 23:58:23','2022-10-22 23:58:23'),(453,7566,148,40720,1526,3,250,1,11250.00,NULL,'2022-10-22 23:50:06','2022-10-23 00:35:43','2022-10-23 00:35:43'),(454,7566,148,40720,1526,3,57,2,11250.00,NULL,'2022-10-22 23:50:06','2022-10-23 00:35:43','2022-10-23 00:35:43'),(455,7566,149,40720,1526,3,217,1,1462.81,NULL,'2022-10-22 23:50:06','2022-10-22 23:50:06',NULL),(456,7566,149,40720,1526,3,68,1,307.19,NULL,'2022-10-22 23:50:06','2022-10-22 23:50:06',NULL),(457,7566,149,40720,1526,3,57,2,1770.00,NULL,'2022-10-22 23:50:06','2022-10-22 23:50:06',NULL),(458,7566,150,40720,1526,3,217,1,1487.61,NULL,'2022-10-22 23:50:06','2022-10-23 00:14:50','2022-10-23 00:14:50'),(459,7566,150,40720,1526,3,68,1,312.40,NULL,'2022-10-22 23:50:06','2022-10-23 00:14:50','2022-10-23 00:14:50'),(460,7566,150,40720,1526,3,57,2,1800.01,NULL,'2022-10-22 23:50:06','2022-10-23 00:14:50','2022-10-23 00:14:50'),(461,7566,151,40720,1526,3,217,1,3833.00,NULL,'2022-10-22 23:50:06','2022-10-22 23:50:06',NULL),(462,7566,151,40720,1526,3,68,1,402.46,NULL,'2022-10-22 23:50:06','2022-10-22 23:50:06',NULL),(463,7566,151,40720,1526,3,57,2,4235.46,NULL,'2022-10-22 23:50:06','2022-10-22 23:50:06',NULL),(464,7566,152,40720,1526,3,217,1,2619.83,NULL,'2022-10-22 23:50:07','2022-10-22 23:50:07',NULL),(465,7566,152,40720,1526,3,68,1,550.17,NULL,'2022-10-22 23:50:07','2022-10-22 23:50:07',NULL),(466,7566,152,40720,1526,3,57,2,3170.00,NULL,'2022-10-22 23:50:07','2022-10-22 23:50:07',NULL),(467,7566,153,40720,1526,3,217,1,4315.35,NULL,'2022-10-22 23:50:07','2022-10-23 00:09:05','2022-10-23 00:09:05'),(468,7566,153,40720,1526,3,68,1,484.35,NULL,'2022-10-22 23:50:07','2022-10-23 00:09:05','2022-10-23 00:09:05'),(469,7566,153,40720,1526,3,57,2,4799.70,NULL,'2022-10-22 23:50:07','2022-10-23 00:09:05','2022-10-23 00:09:05'),(470,7566,154,40720,1526,3,250,1,4500.00,NULL,'2022-10-22 23:50:07','2022-10-23 00:27:37','2022-10-23 00:27:37'),(471,7566,154,40720,1526,3,57,2,4500.00,NULL,'2022-10-22 23:50:07','2022-10-23 00:27:37','2022-10-23 00:27:37'),(472,7566,155,40720,1526,3,217,1,1115.70,NULL,'2022-10-22 23:50:07','2022-10-22 23:50:07',NULL),(473,7566,155,40720,1526,3,68,1,234.30,NULL,'2022-10-22 23:50:07','2022-10-22 23:50:07',NULL),(474,7566,155,40720,1526,3,57,2,1350.00,NULL,'2022-10-22 23:50:07','2022-10-22 23:50:07',NULL),(475,7566,156,40720,1526,3,217,1,4250.41,NULL,'2022-10-22 23:50:07','2022-10-23 00:41:29','2022-10-23 00:41:29');
INSERT INTO `balance_libro_details` VALUES (476,7566,156,40720,1526,3,68,1,892.59,NULL,'2022-10-22 23:50:07','2022-10-23 00:41:29','2022-10-23 00:41:29'),(477,7566,156,40720,1526,3,217,1,170.01,NULL,'2022-10-22 23:50:07','2022-10-23 00:41:29','2022-10-23 00:41:29'),(478,7566,156,40720,1526,3,57,2,5313.01,NULL,'2022-10-22 23:50:07','2022-10-23 00:41:29','2022-10-23 00:41:29'),(479,7566,157,40720,1526,3,217,1,3731.40,NULL,'2022-10-22 23:50:07','2022-10-23 00:20:58','2022-10-23 00:20:58'),(480,7566,157,40720,1526,3,68,1,783.59,NULL,'2022-10-22 23:50:07','2022-10-23 00:20:58','2022-10-23 00:20:58'),(481,7566,157,40720,1526,3,217,1,149.25,NULL,'2022-10-22 23:50:07','2022-10-23 00:20:58','2022-10-23 00:20:58'),(482,7566,157,40720,1526,3,57,2,4664.24,NULL,'2022-10-22 23:50:07','2022-10-23 00:20:58','2022-10-23 00:20:58'),(483,7566,158,40720,1526,3,217,1,2970.61,NULL,'2022-10-22 23:50:07','2022-10-23 00:10:28','2022-10-23 00:10:28'),(484,7566,158,40720,1526,3,68,1,529.37,NULL,'2022-10-22 23:50:07','2022-10-23 00:10:28','2022-10-23 00:10:28'),(485,7566,158,40720,1526,3,57,2,3499.98,NULL,'2022-10-22 23:50:07','2022-10-23 00:10:28','2022-10-23 00:10:28'),(486,7566,159,40720,1526,3,217,1,2543.92,NULL,'2022-10-22 23:50:07','2022-10-23 00:13:56','2022-10-23 00:13:56'),(487,7566,159,40720,1526,3,68,1,534.22,NULL,'2022-10-22 23:50:07','2022-10-23 00:13:56','2022-10-23 00:13:56'),(488,7566,159,40720,1526,3,217,1,203.52,NULL,'2022-10-22 23:50:07','2022-10-23 00:13:56','2022-10-23 00:13:56'),(489,7566,159,40720,1526,3,57,2,3281.66,NULL,'2022-10-22 23:50:07','2022-10-23 00:13:56','2022-10-23 00:13:56'),(490,7566,160,40720,1526,3,217,1,785.12,NULL,'2022-10-22 23:50:07','2022-10-22 23:50:07',NULL),(491,7566,160,40720,1526,3,68,1,164.88,NULL,'2022-10-22 23:50:07','2022-10-22 23:50:07',NULL),(492,7566,160,40720,1526,3,57,2,950.00,NULL,'2022-10-22 23:50:07','2022-10-22 23:50:07',NULL),(493,7566,161,40720,1526,3,217,1,5901.22,NULL,'2022-10-22 23:50:07','2022-10-23 00:13:13','2022-10-23 00:13:13'),(494,7566,161,40720,1526,3,68,1,650.87,NULL,'2022-10-22 23:50:07','2022-10-23 00:13:13','2022-10-23 00:13:13'),(495,7566,161,40720,1526,3,217,1,-0.01,NULL,'2022-10-22 23:50:07','2022-10-23 00:13:13','2022-10-23 00:13:13'),(496,7566,161,40720,1526,3,57,2,6552.08,NULL,'2022-10-22 23:50:07','2022-10-23 00:13:13','2022-10-23 00:13:13'),(497,7566,162,40720,1526,3,217,1,36650.00,NULL,'2022-10-22 23:50:07','2022-10-23 00:14:26','2022-10-23 00:14:26'),(498,7566,162,40720,1526,3,68,1,7696.50,NULL,'2022-10-22 23:50:07','2022-10-23 00:14:26','2022-10-23 00:14:26'),(499,7566,162,40720,1526,3,57,2,44346.50,NULL,'2022-10-22 23:50:07','2022-10-23 00:14:26','2022-10-23 00:14:26'),(500,7566,163,40720,1526,3,217,1,1264.46,NULL,'2022-10-22 23:50:07','2022-10-22 23:50:07',NULL),(501,7566,163,40720,1526,3,68,1,265.54,NULL,'2022-10-22 23:50:07','2022-10-22 23:50:07',NULL),(502,7566,163,40720,1526,3,57,2,1530.00,NULL,'2022-10-22 23:50:07','2022-10-22 23:50:07',NULL),(503,7566,164,40720,1526,3,135,1,12719.01,NULL,'2022-10-22 23:53:33','2022-10-22 23:53:33',NULL),(504,7566,164,40720,1526,3,68,1,2670.99,NULL,'2022-10-22 23:53:33','2022-10-22 23:53:33',NULL),(505,7566,164,40720,1526,3,220,1,381.57,NULL,'2022-10-22 23:53:33','2022-10-22 23:53:33',NULL),(506,7566,164,40720,1526,3,239,1,254.38,NULL,'2022-10-22 23:53:33','2022-10-22 23:53:33',NULL),(507,7566,164,40720,1526,3,57,2,16025.95,NULL,'2022-10-22 23:53:33','2022-10-22 23:53:33',NULL),(508,7566,165,40720,1526,3,135,1,16719.01,NULL,'2022-10-22 23:55:32','2022-10-22 23:55:32',NULL),(509,7566,165,40720,1526,3,68,1,3510.99,NULL,'2022-10-22 23:55:32','2022-10-22 23:55:32',NULL),(510,7566,165,40720,1526,3,220,1,501.57,NULL,'2022-10-22 23:55:32','2022-10-22 23:55:32',NULL),(511,7566,165,40720,1526,3,239,1,334.38,NULL,'2022-10-22 23:55:32','2022-10-22 23:55:32',NULL),(512,7566,165,40720,1526,3,57,2,21065.95,NULL,'2022-10-22 23:55:32','2022-10-22 23:55:32',NULL),(513,7566,166,40720,1526,3,484,1,4264.83,NULL,'2022-10-22 23:57:18','2022-10-22 23:57:18',NULL);
INSERT INTO `balance_libro_details` VALUES (514,7566,166,40720,1526,3,68,1,895.61,NULL,'2022-10-22 23:57:18','2022-10-22 23:57:18',NULL),(515,7566,166,40720,1526,3,484,1,40.35,NULL,'2022-10-22 23:57:18','2022-10-22 23:57:18',NULL),(516,7566,166,40720,1526,3,239,1,43.05,NULL,'2022-10-22 23:57:18','2022-10-22 23:57:18',NULL),(517,7566,166,40720,1526,3,57,2,5243.84,NULL,'2022-10-22 23:57:18','2022-10-22 23:57:18',NULL),(518,7566,167,40720,1526,3,199,1,2148.76,NULL,'2022-10-22 23:58:23','2022-10-23 00:21:26','2022-10-23 00:21:26'),(519,7566,167,40720,1526,3,68,1,451.24,NULL,'2022-10-22 23:58:23','2022-10-23 00:21:26','2022-10-23 00:21:26'),(520,7566,167,40720,1526,3,57,2,2600.00,NULL,'2022-10-22 23:58:23','2022-10-23 00:21:26','2022-10-23 00:21:26'),(521,7566,168,40720,1526,3,135,1,1917.35,NULL,'2022-10-23 00:05:59','2022-10-23 00:05:59',NULL),(522,7566,168,40720,1526,3,68,1,402.64,NULL,'2022-10-23 00:05:59','2022-10-23 00:05:59',NULL),(523,7566,168,40720,1526,3,135,1,0.01,NULL,'2022-10-23 00:05:59','2022-10-23 00:05:59',NULL),(524,7566,168,40720,1526,3,57,2,2320.00,NULL,'2022-10-23 00:05:59','2022-10-23 00:05:59',NULL),(525,7566,169,40720,1526,3,135,1,3057.85,NULL,'2022-10-23 00:06:48','2022-10-23 00:06:48',NULL),(526,7566,169,40720,1526,3,68,1,642.15,NULL,'2022-10-23 00:06:48','2022-10-23 00:06:48',NULL),(527,7566,169,40720,1526,3,57,2,3700.00,NULL,'2022-10-23 00:06:48','2022-10-23 00:06:48',NULL),(528,7566,170,40720,1526,3,484,1,4509.77,NULL,'2022-10-23 00:07:57','2022-10-23 00:07:57',NULL),(529,7566,170,40720,1526,3,68,1,947.05,NULL,'2022-10-23 00:07:57','2022-10-23 00:07:57',NULL),(530,7566,170,40720,1526,3,484,1,43.58,NULL,'2022-10-23 00:07:57','2022-10-23 00:07:57',NULL),(531,7566,170,40720,1526,3,241,1,45.10,NULL,'2022-10-23 00:07:57','2022-10-23 00:07:57',NULL),(532,7566,170,40720,1526,3,57,2,5545.50,NULL,'2022-10-23 00:07:57','2022-10-23 00:07:57',NULL),(533,7566,171,40720,1526,3,217,1,297.52,NULL,'2022-10-23 00:09:05','2023-11-18 12:39:25','2023-11-18 12:39:25'),(534,7566,171,40720,1526,3,68,1,62.48,NULL,'2022-10-23 00:09:05','2023-11-18 12:39:25','2023-11-18 12:39:25'),(535,7566,171,40720,1526,3,217,1,4017.83,NULL,'2022-10-23 00:09:05','2023-11-18 12:39:25','2023-11-18 12:39:25'),(536,7566,171,40720,1526,3,68,1,421.87,NULL,'2022-10-23 00:09:05','2023-11-18 12:39:25','2023-11-18 12:39:25'),(537,7566,171,40720,1526,3,57,2,4799.70,NULL,'2022-10-23 00:09:05','2023-11-18 12:39:25','2023-11-18 12:39:25'),(538,7566,172,40720,1526,3,217,1,2071.06,NULL,'2022-10-23 00:10:28','2022-10-23 00:10:28',NULL),(539,7566,172,40720,1526,3,68,1,434.92,NULL,'2022-10-23 00:10:28','2022-10-23 00:10:28',NULL),(540,7566,172,40720,1526,3,217,1,899.55,NULL,'2022-10-23 00:10:28','2022-10-23 00:10:28',NULL),(541,7566,172,40720,1526,3,68,1,94.45,NULL,'2022-10-23 00:10:28','2022-10-23 00:10:28',NULL),(542,7566,172,40720,1526,3,57,2,3499.98,NULL,'2022-10-23 00:10:28','2022-10-23 00:10:28',NULL),(543,7566,173,40720,1526,3,484,1,4264.26,NULL,'2022-10-23 00:11:55','2022-10-23 00:11:55',NULL),(544,7566,173,40720,1526,3,68,1,895.49,NULL,'2022-10-23 00:11:55','2022-10-23 00:11:55',NULL),(545,7566,173,40720,1526,3,484,1,40.35,NULL,'2022-10-23 00:11:55','2022-10-23 00:11:55',NULL),(546,7566,173,40720,1526,3,239,1,43.05,NULL,'2022-10-23 00:11:55','2022-10-23 00:11:55',NULL),(547,7566,173,40720,1526,3,57,2,5243.15,NULL,'2022-10-23 00:11:55','2022-10-23 00:11:55',NULL),(548,7566,174,40720,1526,3,217,1,297.51,NULL,'2022-10-23 00:13:13','2022-10-23 00:13:13',NULL),(549,7566,174,40720,1526,3,68,1,62.48,NULL,'2022-10-23 00:13:13','2022-10-23 00:13:13',NULL),(550,7566,174,40720,1526,3,217,1,5603.70,NULL,'2022-10-23 00:13:13','2022-10-23 00:13:13',NULL),(551,7566,174,40720,1526,3,68,1,588.39,NULL,'2022-10-23 00:13:13','2022-10-23 00:13:13',NULL),(552,7566,174,40720,1526,3,57,2,6552.08,NULL,'2022-10-23 00:13:13','2022-10-23 00:13:13',NULL),(553,7566,175,40720,1526,3,217,1,2543.92,NULL,'2022-10-23 00:13:56','2022-10-23 00:52:37','2022-10-23 00:52:37');
INSERT INTO `balance_libro_details` VALUES (554,7566,175,40720,1526,3,68,1,534.22,NULL,'2022-10-23 00:13:56','2022-10-23 00:52:37','2022-10-23 00:52:37'),(555,7566,175,40720,1526,3,220,1,127.20,NULL,'2022-10-23 00:13:56','2022-10-23 00:52:37','2022-10-23 00:52:37'),(556,7566,175,40720,1526,3,241,1,76.32,NULL,'2022-10-23 00:13:56','2022-10-23 00:52:37','2022-10-23 00:52:37'),(557,7566,175,40720,1526,3,57,2,3281.66,NULL,'2022-10-23 00:13:56','2022-10-23 00:52:37','2022-10-23 00:52:37'),(558,7566,176,40720,1526,3,135,1,36650.00,NULL,'2022-10-23 00:14:26','2022-10-23 00:14:26',NULL),(559,7566,176,40720,1526,3,68,1,7696.50,NULL,'2022-10-23 00:14:26','2022-10-23 00:14:26',NULL),(560,7566,176,40720,1526,3,57,2,44346.50,NULL,'2022-10-23 00:14:26','2022-10-23 00:14:26',NULL),(561,7566,177,40720,1526,3,135,1,1487.61,NULL,'2022-10-23 00:14:50','2022-10-23 00:31:44','2022-10-23 00:31:44'),(562,7566,177,40720,1526,3,68,1,312.40,NULL,'2022-10-23 00:14:50','2022-10-23 00:31:44','2022-10-23 00:31:44'),(563,7566,177,40720,1526,3,57,2,1800.01,NULL,'2022-10-23 00:14:50','2022-10-23 00:31:44','2022-10-23 00:31:44'),(564,7566,178,40720,1526,3,484,1,4673.52,NULL,'2022-10-23 00:15:59','2022-10-23 00:15:59',NULL),(565,7566,178,40720,1526,3,68,1,981.44,NULL,'2022-10-23 00:15:59','2022-10-23 00:15:59',NULL),(566,7566,178,40720,1526,3,484,1,45.85,NULL,'2022-10-23 00:15:59','2022-10-23 00:15:59',NULL),(567,7566,178,40720,1526,3,57,2,5700.81,NULL,'2022-10-23 00:15:59','2022-10-23 00:15:59',NULL),(568,7566,179,40720,1526,3,484,1,4101.56,NULL,'2022-10-23 00:16:44','2022-10-23 00:16:44',NULL),(569,7566,179,40720,1526,3,68,1,861.33,NULL,'2022-10-23 00:16:44','2022-10-23 00:16:44',NULL),(570,7566,179,40720,1526,3,484,1,38.81,NULL,'2022-10-23 00:16:44','2022-10-23 00:16:44',NULL),(571,7566,179,40720,1526,3,239,1,41.40,NULL,'2022-10-23 00:16:44','2022-10-23 00:16:44',NULL),(572,7566,179,40720,1526,3,57,2,5043.10,NULL,'2022-10-23 00:16:44','2022-10-23 00:16:44',NULL),(573,7566,180,40720,1526,3,199,1,3731.40,NULL,'2022-10-23 00:20:58','2022-10-23 00:20:58',NULL),(574,7566,180,40720,1526,3,68,1,783.59,NULL,'2022-10-23 00:20:58','2022-10-23 00:20:58',NULL),(575,7566,180,40720,1526,3,220,1,111.94,NULL,'2022-10-23 00:20:58','2022-10-23 00:20:58',NULL),(576,7566,180,40720,1526,3,241,1,37.31,NULL,'2022-10-23 00:20:58','2022-10-23 00:20:58',NULL),(577,7566,180,40720,1526,3,57,2,4664.24,NULL,'2022-10-23 00:20:58','2022-10-23 00:20:58',NULL),(578,7566,181,40720,1526,3,199,1,2148.76,NULL,'2022-10-23 00:21:26','2022-10-23 00:21:26',NULL),(579,7566,181,40720,1526,3,68,1,451.24,NULL,'2022-10-23 00:21:26','2022-10-23 00:21:26',NULL),(580,7566,181,40720,1526,3,57,2,2600.00,NULL,'2022-10-23 00:21:26','2022-10-23 00:21:26',NULL),(581,7566,182,40720,1526,3,135,1,4500.00,NULL,'2022-10-23 00:27:37','2022-10-23 00:27:37',NULL),(582,7566,182,40720,1526,3,57,2,4500.00,NULL,'2022-10-23 00:27:37','2022-10-23 00:27:37',NULL),(583,7566,183,40720,1526,3,135,1,1487.61,NULL,'2022-10-23 00:31:44','2022-10-23 00:31:44',NULL),(584,7566,183,40720,1526,3,68,1,312.40,NULL,'2022-10-23 00:31:44','2022-10-23 00:31:44',NULL),(585,7566,183,40720,1526,3,57,2,1800.01,NULL,'2022-10-23 00:31:44','2022-10-23 00:31:44',NULL),(586,7566,184,40720,1526,3,116,1,11250.00,NULL,'2022-10-23 00:35:43','2022-10-23 00:39:38','2022-10-23 00:39:38'),(587,7566,184,40720,1526,3,57,2,11250.00,NULL,'2022-10-23 00:35:43','2022-10-23 00:39:38','2022-10-23 00:39:38'),(588,7566,185,40720,1526,3,116,1,11250.00,NULL,'2022-10-23 00:39:38','2022-10-23 00:39:38',NULL),(589,7566,185,40720,1526,3,57,2,11250.00,NULL,'2022-10-23 00:39:38','2022-10-23 00:39:38',NULL),(590,7566,186,40720,1526,3,217,1,4250.41,NULL,'2022-10-23 00:41:29','2022-10-23 00:41:29',NULL),(591,7566,186,40720,1526,3,68,1,892.59,NULL,'2022-10-23 00:41:29','2022-10-23 00:41:29',NULL),(592,7566,186,40720,1526,3,220,1,127.51,NULL,'2022-10-23 00:41:29','2022-10-23 00:41:29',NULL),(593,7566,186,40720,1526,3,239,1,42.50,NULL,'2022-10-23 00:41:29','2022-10-23 00:41:29',NULL);
INSERT INTO `balance_libro_details` VALUES (594,7566,186,40720,1526,3,57,2,5313.01,NULL,'2022-10-23 00:41:29','2022-10-23 00:41:29',NULL),(595,7566,187,40720,1526,3,482,1,17700.00,NULL,'2022-10-23 00:44:51','2022-10-23 00:44:51',NULL),(596,7566,187,40720,1526,3,68,1,3717.00,NULL,'2022-10-23 00:44:51','2022-10-23 00:44:51',NULL),(597,7566,187,40720,1526,3,57,2,21417.00,NULL,'2022-10-23 00:44:51','2022-10-23 00:44:51',NULL),(598,7566,188,40720,1526,3,482,1,22500.00,NULL,'2022-10-23 00:45:47','2022-10-23 00:45:47',NULL),(599,7566,188,40720,1526,3,68,1,4725.00,NULL,'2022-10-23 00:45:47','2022-10-23 00:45:47',NULL),(600,7566,188,40720,1526,3,57,2,27225.00,NULL,'2022-10-23 00:45:47','2022-10-23 00:45:47',NULL),(601,7566,189,40720,1526,7,25,1,1163.55,NULL,'2022-10-23 00:48:42','2022-10-23 00:48:42',NULL),(602,7566,189,40720,1526,7,13,2,1163.55,NULL,'2022-10-23 00:48:42','2022-10-23 00:48:42',NULL),(603,7566,190,40720,1526,7,25,1,213.20,NULL,'2022-10-23 00:48:42','2022-10-23 00:48:42',NULL),(604,7566,190,40720,1526,7,13,2,213.20,NULL,'2022-10-23 00:48:42','2022-10-23 00:48:42',NULL),(605,7566,191,40720,1526,7,25,1,141.28,NULL,'2022-10-23 00:48:42','2022-10-23 00:48:42',NULL),(606,7566,191,40720,1526,7,13,2,141.28,NULL,'2022-10-23 00:48:42','2022-10-23 00:48:42',NULL),(607,7566,192,40720,1526,7,25,1,1462.98,NULL,'2022-10-23 00:48:42','2022-10-23 00:48:42',NULL),(608,7566,192,40720,1526,7,13,2,1462.98,NULL,'2022-10-23 00:48:42','2022-10-23 00:48:42',NULL),(609,7566,193,40720,1526,7,25,1,6758.42,NULL,'2022-10-23 00:48:42','2022-10-23 00:48:42',NULL),(610,7566,193,40720,1526,7,13,2,6758.42,NULL,'2022-10-23 00:48:42','2022-10-23 00:48:42',NULL),(611,7566,194,40720,1526,7,25,1,390.68,NULL,'2022-10-23 00:48:42','2022-10-23 00:48:42',NULL),(612,7566,194,40720,1526,7,13,2,390.68,NULL,'2022-10-23 00:48:42','2022-10-23 00:48:42',NULL),(613,7566,195,40720,1526,7,25,1,804.26,NULL,'2022-10-23 00:48:42','2022-10-23 00:48:42',NULL),(614,7566,195,40720,1526,7,13,2,804.26,NULL,'2022-10-23 00:48:42','2022-10-23 00:48:42',NULL),(615,7566,196,40720,1526,7,25,1,1447.58,NULL,'2022-10-23 00:48:42','2022-10-23 00:48:42',NULL),(616,7566,196,40720,1526,7,13,2,1447.58,NULL,'2022-10-23 00:48:42','2022-10-23 00:48:42',NULL),(617,7566,197,40720,1526,7,25,1,6847.05,NULL,'2022-10-23 00:48:42','2022-10-23 00:48:42',NULL),(618,7566,197,40720,1526,7,13,2,6847.05,NULL,'2022-10-23 00:48:42','2022-10-23 00:48:42',NULL),(619,7566,198,40720,1526,7,25,1,2303.89,NULL,'2022-10-23 00:48:42','2022-10-23 00:48:42',NULL),(620,7566,198,40720,1526,7,13,2,2303.89,NULL,'2022-10-23 00:48:42','2022-10-23 00:48:42',NULL),(621,7566,199,40720,1526,7,25,1,922.89,NULL,'2022-10-23 00:48:43','2022-10-23 00:48:43',NULL),(622,7566,199,40720,1526,7,13,2,922.89,NULL,'2022-10-23 00:48:43','2022-10-23 00:48:43',NULL),(623,7566,200,40720,1526,3,217,1,2543.92,NULL,'2022-10-23 00:52:37','2022-10-23 00:52:37',NULL),(624,7566,200,40720,1526,3,68,1,534.22,NULL,'2022-10-23 00:52:37','2022-10-23 00:52:37',NULL),(625,7566,200,40720,1526,3,220,1,76.32,NULL,'2022-10-23 00:52:37','2022-10-23 00:52:37',NULL),(626,7566,200,40720,1526,3,241,1,127.20,NULL,'2022-10-23 00:52:37','2022-10-23 00:52:37',NULL),(627,7566,200,40720,1526,3,57,2,3281.66,NULL,'2022-10-23 00:52:37','2022-10-23 00:52:37',NULL),(628,7566,201,40720,1526,7,265,1,102.54,NULL,'2022-10-23 00:56:45','2022-10-23 00:56:45',NULL),(629,7566,201,40720,1526,7,13,2,102.54,NULL,'2022-10-23 00:56:45','2022-10-23 00:56:45',NULL),(630,7566,202,40720,1526,7,265,1,29.43,NULL,'2022-10-23 00:57:09','2022-10-23 00:57:09',NULL),(631,7566,202,40720,1526,7,13,2,29.43,NULL,'2022-10-23 00:57:09','2022-10-23 00:57:09',NULL),(632,7566,203,40720,1526,7,265,1,39.65,NULL,'2022-10-23 00:57:33','2022-10-23 00:57:33',NULL),(633,7566,203,40720,1526,7,13,2,39.65,NULL,'2022-10-23 00:57:33','2022-10-23 00:57:33',NULL),(634,7566,204,40720,1526,7,267,1,188.36,NULL,'2022-10-23 00:58:15','2022-10-23 00:58:15',NULL),(635,7566,204,40720,1526,7,13,2,188.36,NULL,'2022-10-23 00:58:15','2022-10-23 00:58:15',NULL);
INSERT INTO `balance_libro_details` VALUES (636,7566,205,40720,1526,7,267,1,392.94,NULL,'2022-10-23 00:58:41','2022-10-23 00:58:41',NULL),(637,7566,205,40720,1526,7,13,2,392.94,NULL,'2022-10-23 00:58:41','2022-10-23 00:58:41',NULL),(638,7566,206,40720,1526,7,267,1,3899.92,NULL,'2022-10-23 00:59:18','2022-10-23 00:59:18',NULL),(639,7566,206,40720,1526,7,13,2,3899.92,NULL,'2022-10-23 00:59:18','2022-10-23 00:59:18',NULL),(640,7566,207,40720,1526,7,267,1,1228.18,NULL,'2022-10-23 00:59:47','2022-10-23 00:59:47',NULL),(641,7566,207,40720,1526,7,13,2,1228.18,NULL,'2022-10-23 00:59:47','2022-10-23 00:59:47',NULL),(642,7566,208,40720,1526,7,267,1,232.90,NULL,'2022-10-23 01:00:09','2022-10-23 01:00:09',NULL),(643,7566,208,40720,1526,7,13,2,232.90,NULL,'2022-10-23 01:00:09','2022-10-23 01:00:09',NULL),(644,7566,209,40720,1526,7,267,1,81.39,NULL,'2022-10-23 01:00:34','2022-10-23 01:00:34',NULL),(645,7566,209,40720,1526,7,13,2,81.39,NULL,'2022-10-23 01:00:34','2022-10-23 01:00:34',NULL),(646,7566,210,40720,1526,7,267,1,148.65,NULL,'2022-10-23 01:01:13','2022-10-23 01:01:13',NULL),(647,7566,210,40720,1526,7,13,2,148.65,NULL,'2022-10-23 01:01:13','2022-10-23 01:01:13',NULL),(648,7566,211,40720,1526,7,267,1,1408.01,NULL,'2022-10-23 01:01:44','2022-10-23 01:01:44',NULL),(649,7566,211,40720,1526,7,13,2,1408.01,NULL,'2022-10-23 01:01:44','2022-10-23 01:01:44',NULL),(650,7566,212,40720,1526,7,267,1,6705.55,NULL,'2022-10-23 01:02:11','2022-10-23 01:02:11',NULL),(651,7566,212,40720,1526,7,13,2,6705.55,NULL,'2022-10-23 01:02:11','2022-10-23 01:02:11',NULL),(652,7566,213,40720,1526,7,267,1,212.27,NULL,'2022-10-23 01:02:44','2022-10-23 01:02:44',NULL),(653,7566,213,40720,1526,7,13,2,212.27,NULL,'2022-10-23 01:02:44','2022-10-23 01:02:44',NULL),(654,7566,214,40720,1526,7,267,1,29.43,NULL,'2022-10-23 01:03:07','2022-10-23 01:03:07',NULL),(655,7566,214,40720,1526,7,13,2,29.43,NULL,'2022-10-23 01:03:07','2022-10-23 01:03:07',NULL),(656,7566,215,40720,1526,7,267,1,44.42,NULL,'2022-10-23 01:03:30','2022-10-23 01:03:30',NULL),(657,7566,215,40720,1526,7,13,2,44.42,NULL,'2022-10-23 01:03:30','2022-10-23 01:03:30',NULL),(658,7566,216,40720,1526,7,267,1,242.40,NULL,'2022-10-23 01:04:00','2022-10-23 01:04:00',NULL),(659,7566,216,40720,1526,7,13,2,242.40,NULL,'2022-10-23 01:04:00','2022-10-23 01:04:00',NULL),(660,7566,217,40720,1525,7,23,1,638.45,NULL,'2022-10-23 01:09:56','2022-10-23 01:09:56',NULL),(661,7566,217,40720,1525,7,13,2,638.45,NULL,'2022-10-23 01:09:56','2022-10-23 01:09:56',NULL),(662,7566,218,40720,1525,7,23,1,3757.71,NULL,'2022-10-23 01:09:56','2022-10-23 01:09:56',NULL),(663,7566,218,40720,1525,7,13,2,3757.71,NULL,'2022-10-23 01:09:56','2022-10-23 01:09:56',NULL),(664,7566,219,40720,1525,7,23,1,569.01,NULL,'2022-10-23 01:09:56','2022-10-23 01:09:56',NULL),(665,7566,219,40720,1525,7,13,2,569.01,NULL,'2022-10-23 01:09:56','2022-10-23 01:09:56',NULL),(666,7566,220,40720,1526,7,23,1,354.88,NULL,'2022-10-23 01:11:03','2022-10-23 01:11:03',NULL),(667,7566,220,40720,1526,7,13,2,354.88,NULL,'2022-10-23 01:11:03','2022-10-23 01:11:03',NULL),(668,7566,221,40720,1526,7,23,1,4106.58,NULL,'2022-10-23 01:11:03','2022-10-23 01:11:03',NULL),(669,7566,221,40720,1526,7,13,2,4106.58,NULL,'2022-10-23 01:11:03','2022-10-23 01:11:03',NULL),(670,7566,222,40720,1526,7,23,1,879.28,NULL,'2022-10-23 01:11:03','2022-10-23 01:11:03',NULL),(671,7566,222,40720,1526,7,13,2,879.28,NULL,'2022-10-23 01:11:03','2022-10-23 01:11:03',NULL),(672,7566,223,40720,1526,7,23,1,916.24,NULL,'2022-10-23 01:11:03','2022-10-23 01:11:03',NULL),(673,7566,223,40720,1526,7,13,2,916.24,NULL,'2022-10-23 01:11:03','2022-10-23 01:11:03',NULL),(674,7566,224,40720,1527,2,96,2,98517.16,NULL,'2022-12-19 17:06:32','2022-12-19 17:06:32',NULL),(675,7566,224,40720,1527,2,67,2,20688.60,NULL,'2022-12-19 17:06:32','2022-12-19 17:06:32',NULL),(676,7566,224,40720,1527,2,13,1,119205.76,NULL,'2022-12-19 17:06:32','2022-12-19 17:06:32',NULL),(677,7566,225,40720,1527,2,96,2,128878.08,NULL,'2022-12-19 17:06:32','2022-12-19 17:06:32',NULL);
INSERT INTO `balance_libro_details` VALUES (678,7566,225,40720,1527,2,67,2,27064.40,NULL,'2022-12-19 17:06:32','2022-12-19 17:06:32',NULL),(679,7566,225,40720,1527,2,13,1,155942.48,NULL,'2022-12-19 17:06:32','2022-12-19 17:06:32',NULL),(680,7566,226,40720,1527,2,96,2,5136.65,NULL,'2022-12-19 17:06:32','2022-12-19 17:06:32',NULL),(681,7566,226,40720,1527,2,67,2,1078.70,NULL,'2022-12-19 17:06:32','2022-12-19 17:06:32',NULL),(682,7566,226,40720,1527,2,13,1,6215.35,NULL,'2022-12-19 17:06:32','2022-12-19 17:06:32',NULL),(683,7566,227,40720,1527,2,96,2,5136.65,NULL,'2022-12-19 17:06:32','2022-12-19 17:06:32',NULL),(684,7566,227,40720,1527,2,67,2,1078.70,NULL,'2022-12-19 17:06:32','2022-12-19 17:06:32',NULL),(685,7566,227,40720,1527,2,13,1,6215.35,NULL,'2022-12-19 17:06:32','2022-12-19 17:06:32',NULL),(686,7566,228,40720,1527,2,96,2,5490.15,NULL,'2022-12-19 17:06:32','2022-12-19 17:06:32',NULL),(687,7566,228,40720,1527,2,67,2,1152.93,NULL,'2022-12-19 17:06:32','2022-12-19 17:06:32',NULL),(688,7566,228,40720,1527,2,13,1,6643.08,NULL,'2022-12-19 17:06:32','2022-12-19 17:06:32',NULL),(689,7566,229,40720,1527,2,96,1,5136.65,NULL,'2022-12-19 17:06:32','2022-12-19 17:06:32',NULL),(690,7566,229,40720,1527,2,68,1,1078.70,NULL,'2022-12-19 17:06:32','2022-12-19 17:06:32',NULL),(691,7566,229,40720,1527,2,13,2,6215.35,NULL,'2022-12-19 17:06:32','2022-12-19 17:06:32',NULL),(692,7566,230,40720,1527,2,218,2,0.00,NULL,'2022-12-19 17:06:32','2022-12-19 17:06:32',NULL),(693,7566,230,40720,1527,2,218,2,10322.11,NULL,'2022-12-19 17:06:32','2022-12-19 17:06:32',NULL),(694,7566,230,40720,1527,2,13,1,10322.11,NULL,'2022-12-19 17:06:32','2022-12-19 17:06:32',NULL),(695,7566,231,40720,1527,2,96,2,196268.95,NULL,'2022-12-19 17:06:32','2022-12-19 17:06:32',NULL),(696,7566,231,40720,1527,2,67,2,41216.48,NULL,'2022-12-19 17:06:32','2022-12-19 17:06:32',NULL),(697,7566,231,40720,1527,2,13,1,237485.43,NULL,'2022-12-19 17:06:32','2022-12-19 17:06:32',NULL),(698,7566,232,40720,1528,2,96,2,120868.99,NULL,'2022-12-19 17:12:20','2022-12-19 17:12:20',NULL),(699,7566,232,40720,1528,2,67,2,25382.49,NULL,'2022-12-19 17:12:20','2022-12-19 17:12:20',NULL),(700,7566,232,40720,1528,2,13,1,146251.48,NULL,'2022-12-19 17:12:20','2022-12-19 17:12:20',NULL),(701,7566,233,40720,1528,2,96,2,117928.76,NULL,'2022-12-19 17:12:20','2022-12-19 17:12:20',NULL),(702,7566,233,40720,1528,2,67,2,24765.04,NULL,'2022-12-19 17:12:20','2022-12-19 17:12:20',NULL),(703,7566,233,40720,1528,2,13,1,142693.80,NULL,'2022-12-19 17:12:20','2022-12-19 17:12:20',NULL),(704,7566,234,40720,1528,2,96,2,5104.78,NULL,'2022-12-19 17:12:20','2022-12-19 17:12:20',NULL),(705,7566,234,40720,1528,2,67,2,1072.00,NULL,'2022-12-19 17:12:20','2022-12-19 17:12:20',NULL),(706,7566,234,40720,1528,2,13,1,6176.78,NULL,'2022-12-19 17:12:20','2022-12-19 17:12:20',NULL),(707,7566,235,40720,1528,2,96,2,5236.41,NULL,'2022-12-19 17:12:20','2022-12-19 17:38:46','2022-12-19 17:38:46'),(708,7566,235,40720,1528,2,67,2,1099.65,NULL,'2022-12-19 17:12:20','2022-12-19 17:38:46','2022-12-19 17:38:46'),(709,7566,235,40720,1528,2,13,1,6336.06,NULL,'2022-12-19 17:12:20','2022-12-19 17:38:46','2022-12-19 17:38:46'),(710,7566,236,40720,1528,2,96,2,206832.74,NULL,'2022-12-19 17:12:20','2022-12-19 17:38:36','2022-12-19 17:38:36'),(711,7566,236,40720,1528,2,67,2,43434.88,NULL,'2022-12-19 17:12:20','2022-12-19 17:38:36','2022-12-19 17:38:36'),(712,7566,236,40720,1528,2,13,1,250267.62,NULL,'2022-12-19 17:12:20','2022-12-19 17:38:36','2022-12-19 17:38:36'),(713,7566,237,40720,1528,3,217,1,2545.46,NULL,'2022-12-19 17:15:55','2022-12-20 19:02:03','2022-12-20 19:02:03'),(714,7566,237,40720,1528,3,68,1,534.55,NULL,'2022-12-19 17:15:55','2022-12-20 19:02:03','2022-12-20 19:02:03'),(715,7566,237,40720,1528,3,57,2,3080.01,NULL,'2022-12-19 17:15:55','2022-12-20 19:02:03','2022-12-20 19:02:03'),(716,7566,238,40720,1528,3,250,1,11250.00,NULL,'2022-12-19 17:15:55','2022-12-20 19:33:33','2022-12-20 19:33:33');
INSERT INTO `balance_libro_details` VALUES (717,7566,238,40720,1528,3,57,2,11250.00,NULL,'2022-12-19 17:15:55','2022-12-20 19:33:33','2022-12-20 19:33:33'),(718,7566,239,40720,1528,3,217,1,1983.47,NULL,'2022-12-19 17:15:55','2022-12-20 19:28:49','2022-12-20 19:28:49'),(719,7566,239,40720,1528,3,68,1,416.53,NULL,'2022-12-19 17:15:55','2022-12-20 19:28:49','2022-12-20 19:28:49'),(720,7566,239,40720,1528,3,57,2,2400.00,NULL,'2022-12-19 17:15:55','2022-12-20 19:28:49','2022-12-20 19:28:49'),(721,7566,240,40720,1528,3,217,1,1116.60,NULL,'2022-12-19 17:15:55','2022-12-20 19:01:26','2022-12-20 19:01:26'),(722,7566,240,40720,1528,3,68,1,301.48,NULL,'2022-12-19 17:15:55','2022-12-20 19:01:26','2022-12-20 19:01:26'),(723,7566,240,40720,1528,3,217,1,117.54,NULL,'2022-12-19 17:15:55','2022-12-20 19:01:26','2022-12-20 19:01:26'),(724,7566,240,40720,1528,3,57,2,1535.62,NULL,'2022-12-19 17:15:55','2022-12-20 19:01:26','2022-12-20 19:01:26'),(725,7566,241,40720,1528,3,217,1,9931.81,NULL,'2022-12-19 17:15:55','2022-12-20 18:34:38','2022-12-20 18:34:38'),(726,7566,241,40720,1528,3,68,1,1042.84,NULL,'2022-12-19 17:15:55','2022-12-20 18:34:38','2022-12-20 18:34:38'),(727,7566,241,40720,1528,3,217,1,0.01,NULL,'2022-12-19 17:15:55','2022-12-20 18:34:38','2022-12-20 18:34:38'),(728,7566,241,40720,1528,3,57,2,10974.66,NULL,'2022-12-19 17:15:55','2022-12-20 18:34:38','2022-12-20 18:34:38'),(729,7566,242,40720,1528,3,217,1,14430.05,NULL,'2022-12-19 17:15:55','2022-12-20 18:18:04','2022-12-20 18:18:04'),(730,7566,242,40720,1528,3,68,1,3030.31,NULL,'2022-12-19 17:15:55','2022-12-20 18:18:04','2022-12-20 18:18:04'),(731,7566,242,40720,1528,3,217,1,643.08,NULL,'2022-12-19 17:15:55','2022-12-20 18:18:04','2022-12-20 18:18:04'),(732,7566,242,40720,1528,3,57,2,18103.44,NULL,'2022-12-19 17:15:55','2022-12-20 18:18:04','2022-12-20 18:18:04'),(733,7566,243,40720,1528,3,217,1,2272.73,NULL,'2022-12-19 17:15:55','2022-12-20 18:17:01','2022-12-20 18:17:01'),(734,7566,243,40720,1528,3,68,1,477.27,NULL,'2022-12-19 17:15:55','2022-12-20 18:17:01','2022-12-20 18:17:01'),(735,7566,243,40720,1528,3,57,2,2750.00,NULL,'2022-12-19 17:15:55','2022-12-20 18:17:01','2022-12-20 18:17:01'),(736,7566,244,40720,1528,3,217,1,10876.03,NULL,'2022-12-19 17:15:55','2022-12-20 18:16:14','2022-12-20 18:16:14'),(737,7566,244,40720,1528,3,68,1,2283.97,NULL,'2022-12-19 17:15:55','2022-12-20 18:16:14','2022-12-20 18:16:14'),(738,7566,244,40720,1528,3,57,2,13160.00,NULL,'2022-12-19 17:15:55','2022-12-20 18:16:14','2022-12-20 18:16:14'),(739,7566,245,40720,1528,3,217,1,3099.17,NULL,'2022-12-19 17:15:55','2022-12-20 18:15:50','2022-12-20 18:15:50'),(740,7566,245,40720,1528,3,68,1,650.83,NULL,'2022-12-19 17:15:55','2022-12-20 18:15:50','2022-12-20 18:15:50'),(741,7566,245,40720,1528,3,57,2,3750.00,NULL,'2022-12-19 17:15:55','2022-12-20 18:15:50','2022-12-20 18:15:50'),(742,7566,246,40720,1528,3,217,1,5446.28,NULL,'2022-12-19 17:15:56','2022-12-20 18:13:17','2022-12-20 18:13:17'),(743,7566,246,40720,1528,3,68,1,1143.72,NULL,'2022-12-19 17:15:56','2022-12-20 18:13:17','2022-12-20 18:13:17'),(744,7566,246,40720,1528,3,57,2,6590.00,NULL,'2022-12-19 17:15:56','2022-12-20 18:13:17','2022-12-20 18:13:17'),(745,7566,247,40720,1528,3,217,1,9090.91,NULL,'2022-12-19 17:15:56','2022-12-20 18:12:49','2022-12-20 18:12:49'),(746,7566,247,40720,1528,3,68,1,1909.09,NULL,'2022-12-19 17:15:56','2022-12-20 18:12:49','2022-12-20 18:12:49'),(747,7566,247,40720,1528,3,57,2,11000.00,NULL,'2022-12-19 17:15:56','2022-12-20 18:12:49','2022-12-20 18:12:49'),(748,7566,248,40720,1528,3,217,1,3669.42,NULL,'2022-12-19 17:15:56','2022-12-20 18:36:09','2022-12-20 18:36:09'),(749,7566,248,40720,1528,3,68,1,404.38,NULL,'2022-12-19 17:15:56','2022-12-20 18:36:09','2022-12-20 18:36:09'),(750,7566,248,40720,1528,3,57,2,4073.80,NULL,'2022-12-19 17:15:56','2022-12-20 18:36:09','2022-12-20 18:36:09'),(751,7566,249,40720,1528,3,217,1,4433.88,NULL,'2022-12-19 17:15:56','2022-12-20 19:02:39','2022-12-20 19:02:39');
INSERT INTO `balance_libro_details` VALUES (752,7566,249,40720,1528,3,68,1,931.11,NULL,'2022-12-19 17:15:56','2022-12-20 19:02:39','2022-12-20 19:02:39'),(753,7566,249,40720,1528,3,217,1,177.36,NULL,'2022-12-19 17:15:56','2022-12-20 19:02:39','2022-12-20 19:02:39'),(754,7566,249,40720,1528,3,57,2,5542.35,NULL,'2022-12-19 17:15:56','2022-12-20 19:02:39','2022-12-20 19:02:39'),(755,7566,250,40720,1528,3,250,1,0.00,NULL,'2022-12-19 17:15:56','2022-12-20 20:05:57','2022-12-20 20:05:57'),(756,7566,250,40720,1528,3,250,1,16666.16,NULL,'2022-12-19 17:15:56','2022-12-20 20:05:57','2022-12-20 20:05:57'),(757,7566,250,40720,1528,3,57,2,16666.16,NULL,'2022-12-19 17:15:56','2022-12-20 20:05:57','2022-12-20 20:05:57'),(758,7566,251,40720,1528,3,217,1,14652.89,NULL,'2022-12-19 17:15:56','2022-12-20 20:08:27','2022-12-20 20:08:27'),(759,7566,251,40720,1528,3,68,1,3077.11,NULL,'2022-12-19 17:15:56','2022-12-20 20:08:27','2022-12-20 20:08:27'),(760,7566,251,40720,1528,3,57,2,17730.00,NULL,'2022-12-19 17:15:56','2022-12-20 20:08:27','2022-12-20 20:08:27'),(761,7566,252,40720,1528,3,217,1,5303.17,NULL,'2022-12-19 17:15:56','2022-12-20 19:05:46','2022-12-20 19:05:46'),(762,7566,252,40720,1528,3,68,1,556.83,NULL,'2022-12-19 17:15:56','2022-12-20 19:05:46','2022-12-20 19:05:46'),(763,7566,252,40720,1528,3,57,2,5860.00,NULL,'2022-12-19 17:15:56','2022-12-20 19:05:46','2022-12-20 19:05:46'),(764,7566,253,40720,1528,3,217,1,3884.30,NULL,'2022-12-19 17:15:56','2022-12-20 18:10:39','2022-12-20 18:10:39'),(765,7566,253,40720,1528,3,68,1,815.70,NULL,'2022-12-19 17:15:56','2022-12-20 18:10:39','2022-12-20 18:10:39'),(766,7566,253,40720,1528,3,57,2,4700.00,NULL,'2022-12-19 17:15:56','2022-12-20 18:10:39','2022-12-20 18:10:39'),(767,7566,254,40720,1528,3,217,1,1925.62,NULL,'2022-12-19 17:15:56','2022-12-20 18:10:09','2022-12-20 18:10:09'),(768,7566,254,40720,1528,3,68,1,404.38,NULL,'2022-12-19 17:15:56','2022-12-20 18:10:09','2022-12-20 18:10:09'),(769,7566,254,40720,1528,3,57,2,2330.00,NULL,'2022-12-19 17:15:56','2022-12-20 18:10:09','2022-12-20 18:10:09'),(770,7566,255,40720,1528,3,217,1,15128.09,NULL,'2022-12-19 17:15:56','2022-12-20 18:08:37','2022-12-20 18:08:37'),(771,7566,255,40720,1528,3,68,1,3176.90,NULL,'2022-12-19 17:15:56','2022-12-20 18:08:37','2022-12-20 18:08:37'),(772,7566,255,40720,1528,3,217,1,653.63,NULL,'2022-12-19 17:15:56','2022-12-20 18:08:37','2022-12-20 18:08:37'),(773,7566,255,40720,1528,3,57,2,18958.62,NULL,'2022-12-19 17:15:56','2022-12-20 18:08:37','2022-12-20 18:08:37'),(774,7566,256,40720,1528,3,217,1,2933.88,NULL,'2022-12-19 17:15:56','2022-12-20 18:06:49','2022-12-20 18:06:49'),(775,7566,256,40720,1528,3,68,1,616.12,NULL,'2022-12-19 17:15:56','2022-12-20 18:06:49','2022-12-20 18:06:49'),(776,7566,256,40720,1528,3,57,2,3550.00,NULL,'2022-12-19 17:15:56','2022-12-20 18:06:49','2022-12-20 18:06:49'),(777,7566,257,40720,1528,3,250,1,5000.00,NULL,'2022-12-19 17:15:56','2022-12-20 18:05:59','2022-12-20 18:05:59'),(778,7566,257,40720,1528,3,57,2,5000.00,NULL,'2022-12-19 17:15:56','2022-12-20 18:05:59','2022-12-20 18:05:59'),(779,7566,258,40720,1528,8,290,1,296.50,NULL,'2022-12-19 17:23:39','2022-12-19 17:27:50','2022-12-19 17:27:50'),(780,7566,258,40720,1528,8,351,2,296.50,NULL,'2022-12-19 17:23:39','2022-12-19 17:27:50','2022-12-19 17:27:50'),(781,7566,259,40720,1528,7,25,1,84.02,NULL,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(782,7566,259,40720,1528,7,13,2,84.02,NULL,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(783,7566,260,40720,1528,7,25,1,1589.44,NULL,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(784,7566,260,40720,1528,7,13,2,1589.44,NULL,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(785,7566,261,40720,1528,7,25,1,367.00,NULL,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(786,7566,261,40720,1528,7,13,2,367.00,NULL,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(787,7566,262,40720,1528,7,25,1,809.82,NULL,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(788,7566,262,40720,1528,7,13,2,809.82,NULL,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL);
INSERT INTO `balance_libro_details` VALUES (789,7566,263,40720,1528,7,25,1,857.60,NULL,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(790,7566,263,40720,1528,7,13,2,857.60,NULL,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(791,7566,264,40720,1528,7,25,1,7063.27,NULL,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(792,7566,264,40720,1528,7,13,2,7063.27,NULL,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(793,7566,265,40720,1528,7,25,1,1286.10,NULL,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(794,7566,265,40720,1528,7,13,2,1286.10,NULL,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(795,7566,266,40720,1528,7,25,1,1453.31,NULL,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(796,7566,266,40720,1528,7,13,2,1453.31,NULL,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(797,7566,267,40720,1528,7,25,1,7910.21,NULL,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(798,7566,267,40720,1528,7,13,2,7910.21,NULL,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(799,7566,268,40720,1528,7,25,1,114.49,NULL,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(800,7566,268,40720,1528,7,13,2,114.49,NULL,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(801,7566,269,40720,1528,7,25,1,2470.76,NULL,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(802,7566,269,40720,1528,7,13,2,2470.76,NULL,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(803,7566,270,40720,1528,7,25,1,849.69,NULL,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(804,7566,270,40720,1528,7,13,2,849.69,NULL,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(805,7566,271,40720,1528,7,25,1,148.49,NULL,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(806,7566,271,40720,1528,7,13,2,148.49,NULL,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(807,7566,272,40720,1528,7,25,1,1586.19,NULL,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(808,7566,272,40720,1528,7,13,2,1586.19,NULL,'2022-12-19 17:26:29','2022-12-19 17:26:29',NULL),(809,7566,273,40720,1528,8,290,1,296.50,NULL,'2022-12-19 17:27:50','2022-12-19 17:27:50',NULL),(810,7566,273,40720,1528,8,351,2,296.50,NULL,'2022-12-19 17:27:50','2022-12-19 17:27:50',NULL),(811,7566,274,40720,1528,2,96,2,206832.74,NULL,'2022-12-19 17:38:36','2022-12-19 17:38:36',NULL),(812,7566,274,40720,1528,2,67,2,43434.88,NULL,'2022-12-19 17:38:36','2022-12-19 17:38:36',NULL),(813,7566,274,40720,1528,2,13,1,250267.62,NULL,'2022-12-19 17:38:36','2022-12-19 17:38:36',NULL),(814,7566,275,40720,1528,2,96,2,5236.41,NULL,'2022-12-19 17:38:46','2022-12-19 17:38:46',NULL),(815,7566,275,40720,1528,2,67,2,1099.65,NULL,'2022-12-19 17:38:46','2022-12-19 17:38:46',NULL),(816,7566,275,40720,1528,2,13,1,6336.06,NULL,'2022-12-19 17:38:46','2022-12-19 17:38:46',NULL),(817,7566,276,40720,1528,3,135,1,5000.00,NULL,'2022-12-20 18:05:59','2022-12-20 18:05:59',NULL),(818,7566,276,40720,1528,3,57,2,5000.00,NULL,'2022-12-20 18:05:59','2022-12-20 18:05:59',NULL),(819,7566,277,40720,1528,3,483,1,2933.88,NULL,'2022-12-20 18:06:49','2022-12-20 18:06:49',NULL),(820,7566,277,40720,1528,3,68,1,616.11,NULL,'2022-12-20 18:06:49','2022-12-20 18:06:49',NULL),(821,7566,277,40720,1528,3,483,1,0.01,NULL,'2022-12-20 18:06:49','2022-12-20 18:06:49',NULL),(822,7566,277,40720,1528,3,57,2,3550.00,NULL,'2022-12-20 18:06:49','2022-12-20 18:06:49',NULL),(823,7566,278,40720,1528,3,135,1,15128.09,NULL,'2022-12-20 18:08:37','2022-12-20 18:09:23','2022-12-20 18:09:23'),(824,7566,278,40720,1528,3,68,1,3176.90,NULL,'2022-12-20 18:08:37','2022-12-20 18:09:23','2022-12-20 18:09:23'),(825,7566,278,40720,1528,3,135,1,653.63,NULL,'2022-12-20 18:08:37','2022-12-20 18:09:23','2022-12-20 18:09:23'),(826,7566,278,40720,1528,3,220,1,453.84,NULL,'2022-12-20 18:08:37','2022-12-20 18:09:23','2022-12-20 18:09:23'),(827,7566,278,40720,1528,3,239,1,151.28,NULL,'2022-12-20 18:08:37','2022-12-20 18:09:23','2022-12-20 18:09:23'),(828,7566,278,40720,1528,3,57,2,19563.74,NULL,'2022-12-20 18:08:37','2022-12-20 18:09:23','2022-12-20 18:09:23');
INSERT INTO `balance_libro_details` VALUES (829,7566,279,40720,1528,3,135,1,15128.09,NULL,'2022-12-20 18:09:23','2022-12-20 18:10:48','2022-12-20 18:10:48'),(830,7566,279,40720,1528,3,68,1,3176.90,NULL,'2022-12-20 18:09:23','2022-12-20 18:10:48','2022-12-20 18:10:48'),(831,7566,279,40720,1528,3,135,1,48.51,NULL,'2022-12-20 18:09:23','2022-12-20 18:10:48','2022-12-20 18:10:48'),(832,7566,279,40720,1528,3,220,1,453.84,NULL,'2022-12-20 18:09:23','2022-12-20 18:10:48','2022-12-20 18:10:48'),(833,7566,279,40720,1528,3,239,1,151.28,NULL,'2022-12-20 18:09:23','2022-12-20 18:10:48','2022-12-20 18:10:48'),(834,7566,279,40720,1528,3,57,2,18958.62,NULL,'2022-12-20 18:09:23','2022-12-20 18:10:48','2022-12-20 18:10:48'),(835,7566,280,40720,1528,3,483,1,1925.62,NULL,'2022-12-20 18:10:09','2022-12-20 18:10:09',NULL),(836,7566,280,40720,1528,3,68,1,404.38,NULL,'2022-12-20 18:10:09','2022-12-20 18:10:09',NULL),(837,7566,280,40720,1528,3,57,2,2330.00,NULL,'2022-12-20 18:10:09','2022-12-20 18:10:09',NULL),(838,7566,281,40720,1528,3,483,1,3884.30,NULL,'2022-12-20 18:10:39','2022-12-20 18:10:39',NULL),(839,7566,281,40720,1528,3,68,1,815.70,NULL,'2022-12-20 18:10:39','2022-12-20 18:10:39',NULL),(840,7566,281,40720,1528,3,57,2,4700.00,NULL,'2022-12-20 18:10:39','2022-12-20 18:10:39',NULL),(841,7566,282,40720,1528,3,135,1,15128.09,NULL,'2022-12-20 18:10:48','2022-12-20 18:10:48',NULL),(842,7566,282,40720,1528,3,68,1,3176.90,NULL,'2022-12-20 18:10:48','2022-12-20 18:10:48',NULL),(843,7566,282,40720,1528,3,135,1,48.51,NULL,'2022-12-20 18:10:48','2022-12-20 18:10:48',NULL),(844,7566,282,40720,1528,3,220,1,453.84,NULL,'2022-12-20 18:10:48','2022-12-20 18:10:48',NULL),(845,7566,282,40720,1528,3,239,1,151.28,NULL,'2022-12-20 18:10:48','2022-12-20 18:10:48',NULL),(846,7566,282,40720,1528,3,57,2,18958.62,NULL,'2022-12-20 18:10:48','2022-12-20 18:10:48',NULL),(847,7566,283,40720,1528,3,135,1,9090.91,NULL,'2022-12-20 18:12:49','2022-12-20 18:12:49',NULL),(848,7566,283,40720,1528,3,68,1,1909.09,NULL,'2022-12-20 18:12:49','2022-12-20 18:12:49',NULL),(849,7566,283,40720,1528,3,57,2,11000.00,NULL,'2022-12-20 18:12:49','2022-12-20 18:12:49',NULL),(850,7566,284,40720,1528,3,135,1,3099.17,NULL,'2022-12-20 18:15:50','2022-12-20 18:15:50',NULL),(851,7566,284,40720,1528,3,68,1,650.83,NULL,'2022-12-20 18:15:51','2022-12-20 18:15:51',NULL),(852,7566,284,40720,1528,3,57,2,3750.00,NULL,'2022-12-20 18:15:51','2022-12-20 18:15:51',NULL),(853,7566,285,40720,1528,3,135,1,10876.03,NULL,'2022-12-20 18:16:15','2022-12-20 18:16:15',NULL),(854,7566,285,40720,1528,3,68,1,2283.97,NULL,'2022-12-20 18:16:15','2022-12-20 18:16:15',NULL),(855,7566,285,40720,1528,3,57,2,13160.00,NULL,'2022-12-20 18:16:15','2022-12-20 18:16:15',NULL),(856,7566,286,40720,1528,3,135,1,2272.73,NULL,'2022-12-20 18:17:01','2022-12-20 19:29:16','2022-12-20 19:29:16'),(857,7566,286,40720,1528,3,68,1,477.27,NULL,'2022-12-20 18:17:01','2022-12-20 19:29:16','2022-12-20 19:29:16'),(858,7566,286,40720,1528,3,57,2,2750.00,NULL,'2022-12-20 18:17:01','2022-12-20 19:29:16','2022-12-20 19:29:16'),(859,7566,287,40720,1528,3,135,1,14430.05,NULL,'2022-12-20 18:18:04','2022-12-20 18:18:04',NULL),(860,7566,287,40720,1528,3,68,1,3030.31,NULL,'2022-12-20 18:18:04','2022-12-20 18:18:04',NULL),(861,7566,287,40720,1528,3,135,1,65.88,NULL,'2022-12-20 18:18:04','2022-12-20 18:18:04',NULL),(862,7566,287,40720,1528,3,220,1,432.90,NULL,'2022-12-20 18:18:04','2022-12-20 18:18:04',NULL),(863,7566,287,40720,1528,3,239,1,144.30,NULL,'2022-12-20 18:18:04','2022-12-20 18:18:04',NULL),(864,7566,287,40720,1528,3,57,2,18103.44,NULL,'2022-12-20 18:18:04','2022-12-20 18:18:04',NULL),(865,7566,288,40720,1528,3,135,1,4297.52,NULL,'2022-12-20 18:29:55','2022-12-20 18:29:55',NULL),(866,7566,288,40720,1528,3,68,1,902.48,NULL,'2022-12-20 18:29:55','2022-12-20 18:29:55',NULL),(867,7566,288,40720,1528,3,57,2,5200.00,NULL,'2022-12-20 18:29:55','2022-12-20 18:29:55',NULL),(868,7566,289,40720,1528,3,135,1,5785.12,NULL,'2022-12-20 18:31:49','2022-12-20 18:31:49',NULL);
INSERT INTO `balance_libro_details` VALUES (869,7566,289,40720,1528,3,68,1,1214.88,NULL,'2022-12-20 18:31:49','2022-12-20 18:31:49',NULL),(870,7566,289,40720,1528,3,57,2,7000.00,NULL,'2022-12-20 18:31:49','2022-12-20 18:31:49',NULL),(871,7566,290,40720,1528,3,135,1,7024.79,NULL,'2022-12-20 18:32:47','2022-12-20 18:32:47',NULL),(872,7566,290,40720,1528,3,68,1,1475.21,NULL,'2022-12-20 18:32:47','2022-12-20 18:32:47',NULL),(873,7566,290,40720,1528,3,57,2,8500.00,NULL,'2022-12-20 18:32:47','2022-12-20 18:32:47',NULL),(874,7566,291,40720,1528,3,135,1,9931.81,NULL,'2022-12-20 18:34:38','2022-12-20 18:34:38',NULL),(875,7566,291,40720,1528,3,68,1,1042.84,NULL,'2022-12-20 18:34:38','2022-12-20 18:34:38',NULL),(876,7566,291,40720,1528,3,135,1,0.01,NULL,'2022-12-20 18:34:38','2022-12-20 18:34:38',NULL),(877,7566,291,40720,1528,3,57,2,10974.66,NULL,'2022-12-20 18:34:38','2022-12-20 18:34:38',NULL),(878,7566,292,40720,1528,3,135,1,181.82,NULL,'2022-12-20 18:36:09','2022-12-20 18:36:09',NULL),(879,7566,292,40720,1528,3,68,1,38.18,NULL,'2022-12-20 18:36:09','2022-12-20 18:36:09',NULL),(880,7566,292,40720,1528,3,135,1,3487.60,NULL,'2022-12-20 18:36:09','2022-12-20 18:36:09',NULL),(881,7566,292,40720,1528,3,68,1,366.20,NULL,'2022-12-20 18:36:09','2022-12-20 18:36:09',NULL),(882,7566,292,40720,1528,3,57,2,4073.80,NULL,'2022-12-20 18:36:09','2022-12-20 18:36:09',NULL),(883,7566,293,40720,1528,3,135,1,11981.82,NULL,'2022-12-20 18:39:10','2022-12-20 18:39:10',NULL),(884,7566,293,40720,1528,3,68,1,2516.18,NULL,'2022-12-20 18:39:10','2022-12-20 18:39:10',NULL),(885,7566,293,40720,1528,3,57,2,14498.00,NULL,'2022-12-20 18:39:10','2022-12-20 18:39:10',NULL),(886,7566,294,40720,1528,3,484,1,5282.00,NULL,'2022-12-20 18:41:45','2022-12-20 18:42:06','2022-12-20 18:42:06'),(887,7566,294,40720,1528,3,68,1,1109.22,NULL,'2022-12-20 18:41:45','2022-12-20 18:42:06','2022-12-20 18:42:06'),(888,7566,294,40720,1528,3,484,1,172.18,NULL,'2022-12-20 18:41:45','2022-12-20 18:42:06','2022-12-20 18:42:06'),(889,7566,294,40720,1528,3,241,1,52.82,NULL,'2022-12-20 18:41:45','2022-12-20 18:42:06','2022-12-20 18:42:06'),(890,7566,294,40720,1528,3,57,2,6616.22,NULL,'2022-12-20 18:41:45','2022-12-20 18:42:06','2022-12-20 18:42:06'),(891,7566,295,40720,1528,3,484,1,5282.00,NULL,'2022-12-20 18:42:06','2022-12-20 18:42:06',NULL),(892,7566,295,40720,1528,3,68,1,1109.22,NULL,'2022-12-20 18:42:06','2022-12-20 18:42:06',NULL),(893,7566,295,40720,1528,3,484,1,59.68,NULL,'2022-12-20 18:42:06','2022-12-20 18:42:06',NULL),(894,7566,295,40720,1528,3,241,1,52.82,NULL,'2022-12-20 18:42:06','2022-12-20 18:42:06',NULL),(895,7566,295,40720,1528,3,57,2,6503.72,NULL,'2022-12-20 18:42:06','2022-12-20 18:42:06',NULL),(896,7566,296,40720,1528,3,484,1,5325.39,NULL,'2022-12-20 18:43:53','2022-12-20 18:43:53',NULL),(897,7566,296,40720,1528,3,68,1,1118.33,NULL,'2022-12-20 18:43:53','2022-12-20 18:43:53',NULL),(898,7566,296,40720,1528,3,484,1,57.61,NULL,'2022-12-20 18:43:53','2022-12-20 18:43:53',NULL),(899,7566,296,40720,1528,3,57,2,6501.33,NULL,'2022-12-20 18:43:53','2022-12-20 18:43:53',NULL),(900,7566,297,40720,1528,3,135,1,3347.11,NULL,'2022-12-20 18:44:47','2022-12-20 18:44:47',NULL),(901,7566,297,40720,1528,3,68,1,702.89,NULL,'2022-12-20 18:44:47','2022-12-20 18:44:47',NULL),(902,7566,297,40720,1528,3,57,2,4050.00,NULL,'2022-12-20 18:44:47','2022-12-20 18:44:47',NULL),(903,7566,298,40720,1528,3,135,1,4090.91,NULL,'2022-12-20 18:45:10','2022-12-20 18:45:10',NULL),(904,7566,298,40720,1528,3,68,1,859.09,NULL,'2022-12-20 18:45:10','2022-12-20 18:45:10',NULL),(905,7566,298,40720,1528,3,57,2,4950.00,NULL,'2022-12-20 18:45:10','2022-12-20 18:45:10',NULL),(906,7566,299,40720,1528,3,135,1,6114.05,NULL,'2022-12-20 18:45:32','2022-12-20 18:45:32',NULL),(907,7566,299,40720,1528,3,68,1,1283.95,NULL,'2022-12-20 18:45:32','2022-12-20 18:45:32',NULL),(908,7566,299,40720,1528,3,57,2,7398.00,NULL,'2022-12-20 18:45:32','2022-12-20 18:45:32',NULL),(909,7566,300,40720,1528,3,483,1,7694.21,NULL,'2022-12-20 18:50:18','2022-12-20 18:52:44','2022-12-20 18:52:44');
INSERT INTO `balance_libro_details` VALUES (910,7566,300,40720,1528,3,68,1,1615.78,NULL,'2022-12-20 18:50:18','2022-12-20 18:52:44','2022-12-20 18:52:44'),(911,7566,300,40720,1528,3,483,1,0.01,NULL,'2022-12-20 18:50:18','2022-12-20 18:52:44','2022-12-20 18:52:44'),(912,7566,300,40720,1528,3,57,2,9310.00,NULL,'2022-12-20 18:50:18','2022-12-20 18:52:44','2022-12-20 18:52:44'),(913,7566,301,40720,1528,3,483,1,7694.21,NULL,'2022-12-20 18:52:44','2022-12-20 18:52:44',NULL),(914,7566,301,40720,1528,3,68,1,1615.78,NULL,'2022-12-20 18:52:44','2022-12-20 18:52:44',NULL),(915,7566,301,40720,1528,3,483,1,0.01,NULL,'2022-12-20 18:52:44','2022-12-20 18:52:44',NULL),(916,7566,301,40720,1528,3,57,2,9310.00,NULL,'2022-12-20 18:52:44','2022-12-20 18:52:44',NULL),(917,7566,302,40720,1528,3,484,1,5080.20,NULL,'2022-12-20 18:55:18','2022-12-20 18:55:18',NULL),(918,7566,302,40720,1528,3,68,1,1066.84,NULL,'2022-12-20 18:55:18','2022-12-20 18:55:18',NULL),(919,7566,302,40720,1528,3,484,1,53.17,NULL,'2022-12-20 18:55:18','2022-12-20 18:55:18',NULL),(920,7566,302,40720,1528,3,239,1,51.33,NULL,'2022-12-20 18:55:18','2022-12-20 18:55:18',NULL),(921,7566,302,40720,1528,3,57,2,6251.54,NULL,'2022-12-20 18:55:18','2022-12-20 18:55:18',NULL),(922,7566,303,40720,1528,3,484,1,5736.49,NULL,'2022-12-20 18:56:03','2022-12-20 20:34:29','2022-12-20 20:34:29'),(923,7566,303,40720,1528,3,68,1,1204.66,NULL,'2022-12-20 18:56:03','2022-12-20 20:34:29','2022-12-20 20:34:29'),(924,7566,303,40720,1528,3,484,1,59.05,NULL,'2022-12-20 18:56:03','2022-12-20 20:34:29','2022-12-20 20:34:29'),(925,7566,303,40720,1528,3,239,1,57.96,NULL,'2022-12-20 18:56:03','2022-12-20 20:34:29','2022-12-20 20:34:29'),(926,7566,303,40720,1528,3,57,2,7058.16,NULL,'2022-12-20 18:56:03','2022-12-20 20:34:29','2022-12-20 20:34:29'),(927,7566,304,40720,1528,3,484,1,5898.01,NULL,'2022-12-20 18:57:42','2022-12-20 18:57:42',NULL),(928,7566,304,40720,1528,3,68,1,1238.58,NULL,'2022-12-20 18:57:42','2022-12-20 18:57:42',NULL),(929,7566,304,40720,1528,3,484,1,63.80,NULL,'2022-12-20 18:57:42','2022-12-20 18:57:42',NULL),(930,7566,304,40720,1528,3,57,2,7200.39,NULL,'2022-12-20 18:57:42','2022-12-20 18:57:42',NULL),(931,7566,305,40720,1528,3,193,1,1116.60,NULL,'2022-12-20 19:01:26','2022-12-20 19:32:08','2022-12-20 19:32:08'),(932,7566,305,40720,1528,3,68,1,301.48,NULL,'2022-12-20 19:01:26','2022-12-20 19:32:08','2022-12-20 19:32:08'),(933,7566,305,40720,1528,3,193,1,58.77,NULL,'2022-12-20 19:01:26','2022-12-20 19:32:08','2022-12-20 19:32:08'),(934,7566,305,40720,1528,3,241,1,58.77,NULL,'2022-12-20 19:01:26','2022-12-20 19:32:08','2022-12-20 19:32:08'),(935,7566,305,40720,1528,3,57,2,1535.62,NULL,'2022-12-20 19:01:26','2022-12-20 19:32:08','2022-12-20 19:32:08'),(936,7566,306,40720,1528,3,217,1,2545.46,NULL,'2022-12-20 19:02:03','2022-12-20 19:27:28','2022-12-20 19:27:28'),(937,7566,306,40720,1528,3,68,1,534.55,NULL,'2022-12-20 19:02:03','2022-12-20 19:27:28','2022-12-20 19:27:28'),(938,7566,306,40720,1528,3,57,2,3080.01,NULL,'2022-12-20 19:02:03','2022-12-20 19:27:28','2022-12-20 19:27:28'),(939,7566,307,40720,1528,3,199,1,4433.88,NULL,'2022-12-20 19:04:27','2022-12-20 19:04:27',NULL),(940,7566,307,40720,1528,3,68,1,931.11,NULL,'2022-12-20 19:04:27','2022-12-20 19:04:27',NULL),(941,7566,307,40720,1528,3,220,1,133.02,NULL,'2022-12-20 19:04:27','2022-12-20 19:04:27',NULL),(942,7566,307,40720,1528,3,241,1,44.34,NULL,'2022-12-20 19:04:27','2022-12-20 19:04:27',NULL),(943,7566,307,40720,1528,3,57,2,5542.35,NULL,'2022-12-20 19:04:27','2022-12-20 19:04:27',NULL),(944,7566,308,40720,1528,3,135,1,5303.17,NULL,'2022-12-20 19:05:46','2023-11-18 12:37:24','2023-11-18 12:37:24'),(945,7566,308,40720,1528,3,68,1,556.83,NULL,'2022-12-20 19:05:46','2023-11-18 12:37:24','2023-11-18 12:37:24'),(946,7566,308,40720,1528,3,57,2,5860.00,NULL,'2022-12-20 19:05:46','2023-11-18 12:37:24','2023-11-18 12:37:24'),(947,7566,309,40720,1528,3,482,1,17500.00,NULL,'2022-12-20 19:07:02','2022-12-20 19:07:02',NULL);
INSERT INTO `balance_libro_details` VALUES (948,7566,309,40720,1528,3,68,1,3675.00,NULL,'2022-12-20 19:07:02','2022-12-20 19:07:02',NULL),(949,7566,309,40720,1528,3,57,2,21175.00,NULL,'2022-12-20 19:07:02','2022-12-20 19:07:02',NULL),(950,7566,310,40720,1528,3,482,1,25400.00,NULL,'2022-12-20 19:07:30','2022-12-20 19:07:30',NULL),(951,7566,310,40720,1528,3,68,1,5334.00,NULL,'2022-12-20 19:07:30','2022-12-20 19:07:30',NULL),(952,7566,310,40720,1528,3,57,2,30734.00,NULL,'2022-12-20 19:07:30','2022-12-20 19:07:30',NULL),(953,7566,311,40720,1528,3,485,1,30000.00,NULL,'2022-12-20 19:09:38','2022-12-20 19:09:38',NULL),(954,7566,311,40720,1528,3,68,1,6300.00,NULL,'2022-12-20 19:09:38','2022-12-20 19:09:38',NULL),(955,7566,311,40720,1528,3,57,2,36300.00,NULL,'2022-12-20 19:09:38','2022-12-20 19:09:38',NULL),(956,7566,312,40720,1528,3,485,1,22500.00,NULL,'2022-12-20 19:10:07','2022-12-20 19:10:07',NULL),(957,7566,312,40720,1528,3,68,1,4725.00,NULL,'2022-12-20 19:10:07','2022-12-20 19:10:07',NULL),(958,7566,312,40720,1528,3,57,2,27225.00,NULL,'2022-12-20 19:10:07','2022-12-20 19:10:07',NULL),(959,7566,313,40720,1528,3,199,1,2545.46,NULL,'2022-12-20 19:27:28','2022-12-20 19:27:28',NULL),(960,7566,313,40720,1528,3,68,1,534.55,NULL,'2022-12-20 19:27:28','2022-12-20 19:27:28',NULL),(961,7566,313,40720,1528,3,57,2,3080.01,NULL,'2022-12-20 19:27:28','2022-12-20 19:27:28',NULL),(962,7566,314,40720,1528,3,483,1,1983.47,NULL,'2022-12-20 19:28:49','2022-12-20 19:29:32','2022-12-20 19:29:32'),(963,7566,314,40720,1528,3,68,1,416.53,NULL,'2022-12-20 19:28:49','2022-12-20 19:29:32','2022-12-20 19:29:32'),(964,7566,314,40720,1528,3,57,2,2400.00,NULL,'2022-12-20 19:28:49','2022-12-20 19:29:32','2022-12-20 19:29:32'),(965,7566,315,40720,1528,3,483,1,2272.73,NULL,'2022-12-20 19:29:16','2022-12-20 19:29:16',NULL),(966,7566,315,40720,1528,3,68,1,477.27,NULL,'2022-12-20 19:29:16','2022-12-20 19:29:16',NULL),(967,7566,315,40720,1528,3,57,2,2750.00,NULL,'2022-12-20 19:29:16','2022-12-20 19:29:16',NULL),(968,7566,316,40720,1528,3,483,1,1983.47,NULL,'2022-12-20 19:29:32','2022-12-20 19:29:32',NULL),(969,7566,316,40720,1528,3,68,1,416.53,NULL,'2022-12-20 19:29:32','2022-12-20 19:29:32',NULL),(970,7566,316,40720,1528,3,57,2,2400.00,NULL,'2022-12-20 19:29:32','2022-12-20 19:29:32',NULL),(971,7566,317,40720,1528,3,193,1,1116.60,NULL,'2022-12-20 19:32:08','2022-12-20 20:14:51','2022-12-20 20:14:51'),(972,7566,317,40720,1528,3,68,1,301.48,NULL,'2022-12-20 19:32:08','2022-12-20 20:14:51','2022-12-20 20:14:51'),(973,7566,317,40720,1528,3,193,1,58.77,NULL,'2022-12-20 19:32:08','2022-12-20 20:14:51','2022-12-20 20:14:51'),(974,7566,317,40720,1528,3,241,1,58.77,NULL,'2022-12-20 19:32:08','2022-12-20 20:14:51','2022-12-20 20:14:51'),(975,7566,317,40720,1528,3,57,2,1535.62,NULL,'2022-12-20 19:32:08','2022-12-20 20:14:51','2022-12-20 20:14:51'),(976,7566,318,40720,1528,3,116,1,11250.00,NULL,'2022-12-20 19:33:33','2022-12-20 19:33:33',NULL),(977,7566,318,40720,1528,3,57,2,11250.00,NULL,'2022-12-20 19:33:33','2022-12-20 19:33:33',NULL),(978,7566,319,40720,1528,3,193,1,1116.60,NULL,'2022-12-20 20:14:51','2022-12-20 20:14:51',NULL),(979,7566,319,40720,1528,3,68,1,301.48,NULL,'2022-12-20 20:14:51','2022-12-20 20:14:51',NULL),(980,7566,319,40720,1528,3,193,1,58.77,NULL,'2022-12-20 20:14:51','2022-12-20 20:14:51',NULL),(981,7566,319,40720,1528,3,241,1,58.77,NULL,'2022-12-20 20:14:51','2022-12-20 20:14:51',NULL),(982,7566,319,40720,1528,3,57,2,1535.62,NULL,'2022-12-20 20:14:51','2022-12-20 20:14:51',NULL),(983,7566,320,40720,1528,3,484,1,5736.49,NULL,'2022-12-20 20:34:29','2022-12-20 20:34:29',NULL),(984,7566,320,40720,1528,3,68,1,1204.66,NULL,'2022-12-20 20:34:29','2022-12-20 20:34:29',NULL),(985,7566,320,40720,1528,3,484,1,59.05,NULL,'2022-12-20 20:34:29','2022-12-20 20:34:29',NULL),(986,7566,320,40720,1528,3,239,1,57.96,NULL,'2022-12-20 20:34:29','2022-12-20 20:34:29',NULL),(987,7566,320,40720,1528,3,57,2,7058.16,NULL,'2022-12-20 20:34:29','2022-12-20 20:34:29',NULL);
INSERT INTO `balance_libro_details` VALUES (988,7566,321,40720,1528,7,265,1,122.08,NULL,'2022-12-20 20:40:28','2022-12-20 20:40:28',NULL),(989,7566,321,40720,1528,7,13,2,122.08,NULL,'2022-12-20 20:40:28','2022-12-20 20:40:28',NULL),(990,7566,322,40720,1528,7,265,1,35.04,NULL,'2022-12-20 20:41:56','2022-12-20 20:41:56',NULL),(991,7566,322,40720,1528,7,13,2,35.04,NULL,'2022-12-20 20:41:56','2022-12-20 20:41:56',NULL),(992,7566,323,40720,1528,7,265,1,84.83,NULL,'2022-12-20 20:42:26','2022-12-20 20:42:26',NULL),(993,7566,323,40720,1528,7,13,2,84.83,NULL,'2022-12-20 20:42:26','2022-12-20 20:42:26',NULL),(994,7566,324,40720,1528,7,265,1,39.37,NULL,'2022-12-20 20:42:46','2022-12-20 20:42:46',NULL),(995,7566,324,40720,1528,7,13,2,39.37,NULL,'2022-12-20 20:42:46','2022-12-20 20:42:46',NULL),(996,7566,325,40720,1528,7,265,1,1.23,NULL,'2022-12-20 20:43:08','2022-12-20 20:43:08',NULL),(997,7566,325,40720,1528,7,13,2,1.23,NULL,'2022-12-20 20:43:08','2022-12-20 20:43:08',NULL),(998,7566,326,40720,1528,7,267,1,330.46,NULL,'2022-12-20 20:45:25','2022-12-20 20:45:25',NULL),(999,7566,326,40720,1528,7,13,2,330.46,NULL,'2022-12-20 20:45:25','2022-12-20 20:45:25',NULL),(1000,7566,327,40720,1528,7,267,1,30.93,NULL,'2022-12-20 20:45:50','2022-12-20 20:45:50',NULL),(1001,7566,327,40720,1528,7,13,2,30.93,NULL,'2022-12-20 20:45:50','2022-12-20 20:45:50',NULL),(1002,7566,328,40720,1528,7,267,1,173.12,NULL,'2022-12-20 20:46:18','2022-12-20 20:46:18',NULL),(1003,7566,328,40720,1528,7,13,2,173.12,NULL,'2022-12-20 20:46:18','2022-12-20 20:46:18',NULL),(1004,7566,329,40720,1528,7,267,1,4057.58,NULL,'2022-12-20 20:47:03','2022-12-20 20:47:03',NULL),(1005,7566,329,40720,1528,7,13,2,4057.58,NULL,'2022-12-20 20:47:03','2022-12-20 20:47:03',NULL),(1006,7566,330,40720,1528,7,267,1,436.09,NULL,'2022-12-20 20:47:46','2022-12-20 20:47:46',NULL),(1007,7566,330,40720,1528,7,13,2,436.09,NULL,'2022-12-20 20:47:46','2022-12-20 20:47:46',NULL),(1008,7566,331,40720,1528,7,267,1,23.85,NULL,'2022-12-20 20:48:15','2022-12-20 20:48:15',NULL),(1009,7566,331,40720,1528,7,13,2,23.85,NULL,'2022-12-20 20:48:15','2022-12-20 20:48:15',NULL),(1010,7566,332,40720,1528,7,267,1,1395.68,NULL,'2022-12-20 20:48:37','2022-12-20 20:48:37',NULL),(1011,7566,332,40720,1528,7,13,2,1395.68,NULL,'2022-12-20 20:48:37','2022-12-20 20:48:37',NULL),(1012,7566,333,40720,1528,7,267,1,221.02,NULL,'2022-12-20 20:49:43','2022-12-20 20:49:43',NULL),(1013,7566,333,40720,1528,7,13,2,221.02,NULL,'2022-12-20 20:49:43','2022-12-20 20:49:43',NULL),(1014,7566,334,40720,1528,7,267,1,70.00,NULL,'2022-12-20 20:50:05','2022-12-20 20:50:05',NULL),(1015,7566,334,40720,1528,7,13,2,70.00,NULL,'2022-12-20 20:50:05','2022-12-20 20:50:05',NULL),(1016,7566,335,40720,1528,7,267,1,1379.65,NULL,'2022-12-20 20:50:33','2022-12-20 20:50:33',NULL),(1017,7566,335,40720,1528,7,13,2,1379.65,NULL,'2022-12-20 20:50:33','2022-12-20 20:50:33',NULL),(1018,7566,336,40720,1528,7,267,1,165.84,NULL,'2022-12-20 20:50:53','2022-12-20 20:50:53',NULL),(1019,7566,336,40720,1528,7,13,2,165.84,NULL,'2022-12-20 20:50:53','2022-12-20 20:50:53',NULL),(1020,7566,337,40720,1528,7,267,1,76.46,NULL,'2022-12-20 20:51:19','2022-12-20 20:51:19',NULL),(1021,7566,337,40720,1528,7,13,2,76.46,NULL,'2022-12-20 20:51:19','2022-12-20 20:51:19',NULL),(1022,7566,338,40720,1528,7,267,1,331.13,NULL,'2022-12-20 20:51:37','2022-12-20 20:51:37',NULL),(1023,7566,338,40720,1528,7,13,2,331.13,NULL,'2022-12-20 20:51:37','2022-12-20 20:51:37',NULL),(1024,7566,339,40720,1528,7,267,1,17.50,NULL,'2022-12-20 20:52:00','2022-12-20 20:52:00',NULL),(1025,7566,339,40720,1528,7,13,2,17.50,NULL,'2022-12-20 20:52:00','2022-12-20 20:52:00',NULL),(1026,7566,340,40720,1528,7,267,1,136.81,NULL,'2022-12-20 20:52:34','2022-12-20 20:52:34',NULL),(1027,7566,340,40720,1528,7,13,2,136.81,NULL,'2022-12-20 20:52:34','2022-12-20 20:52:34',NULL),(1028,7566,341,40720,1528,7,267,1,6617.48,NULL,'2022-12-20 20:53:40','2022-12-20 20:53:40',NULL),(1029,7566,341,40720,1528,7,13,2,6617.48,NULL,'2022-12-20 20:53:40','2022-12-20 20:53:40',NULL);
INSERT INTO `balance_libro_details` VALUES (1030,7566,342,40720,1529,2,96,2,104821.14,NULL,'2023-01-14 10:33:03','2023-01-14 10:33:03',NULL),(1031,7566,342,40720,1529,2,67,2,22012.44,NULL,'2023-01-14 10:33:03','2023-01-14 10:33:03',NULL),(1032,7566,342,40720,1529,2,13,1,126833.58,NULL,'2023-01-14 10:33:03','2023-01-14 10:33:03',NULL),(1033,7566,343,40720,1529,2,96,2,153171.34,NULL,'2023-01-14 10:33:03','2023-01-14 10:33:03',NULL),(1034,7566,343,40720,1529,2,67,2,32165.98,NULL,'2023-01-14 10:33:03','2023-01-14 10:33:03',NULL),(1035,7566,343,40720,1529,2,13,1,185337.32,NULL,'2023-01-14 10:33:03','2023-01-14 10:33:03',NULL),(1036,7566,344,40720,1529,2,96,2,3740.48,NULL,'2023-01-14 10:33:03','2023-01-14 10:33:03',NULL),(1037,7566,344,40720,1529,2,67,2,785.50,NULL,'2023-01-14 10:33:03','2023-01-14 10:33:03',NULL),(1038,7566,344,40720,1529,2,13,1,4525.98,NULL,'2023-01-14 10:33:03','2023-01-14 10:33:03',NULL),(1039,7566,345,40720,1529,2,96,2,6594.82,NULL,'2023-01-14 10:33:03','2023-01-14 10:33:03',NULL),(1040,7566,345,40720,1529,2,67,2,1384.91,NULL,'2023-01-14 10:33:03','2023-01-14 10:33:03',NULL),(1041,7566,345,40720,1529,2,13,1,7979.73,NULL,'2023-01-14 10:33:03','2023-01-14 10:33:03',NULL),(1042,7566,346,40720,1529,2,96,2,204288.91,NULL,'2023-01-14 10:33:03','2023-01-14 10:33:03',NULL),(1043,7566,346,40720,1529,2,67,2,42900.67,NULL,'2023-01-14 10:33:03','2023-01-14 10:33:03',NULL),(1044,7566,346,40720,1529,2,13,1,247189.58,NULL,'2023-01-14 10:33:03','2023-01-14 10:33:03',NULL),(1045,7566,347,40720,1529,3,217,1,2545.46,NULL,'2023-01-14 10:53:23','2023-01-14 11:06:08','2023-01-14 11:06:08'),(1046,7566,347,40720,1529,3,68,1,534.55,NULL,'2023-01-14 10:53:23','2023-01-14 11:06:08','2023-01-14 11:06:08'),(1047,7566,347,40720,1529,3,57,2,3080.01,NULL,'2023-01-14 10:53:23','2023-01-14 11:06:08','2023-01-14 11:06:08'),(1048,7566,348,40720,1529,3,116,1,11250.00,NULL,'2023-01-14 10:53:23','2023-01-14 10:53:23',NULL),(1049,7566,348,40720,1529,3,57,2,11250.00,NULL,'2023-01-14 10:53:23','2023-01-14 10:53:23',NULL),(1050,7566,349,40720,1529,3,483,1,2355.37,NULL,'2023-01-14 10:53:23','2023-01-14 10:53:23',NULL),(1051,7566,349,40720,1529,3,68,1,494.63,NULL,'2023-01-14 10:53:23','2023-01-14 10:53:23',NULL),(1052,7566,349,40720,1529,3,57,2,2850.00,NULL,'2023-01-14 10:53:23','2023-01-14 10:53:23',NULL),(1053,7566,350,40720,1529,3,483,1,1429.75,NULL,'2023-01-14 10:53:23','2023-01-14 10:53:23',NULL),(1054,7566,350,40720,1529,3,68,1,300.25,NULL,'2023-01-14 10:53:23','2023-01-14 10:53:23',NULL),(1055,7566,350,40720,1529,3,57,2,1730.00,NULL,'2023-01-14 10:53:23','2023-01-14 10:53:23',NULL),(1056,7566,351,40720,1529,3,217,1,6045.99,NULL,'2023-01-14 10:53:23','2023-01-14 11:00:02','2023-01-14 11:00:02'),(1057,7566,351,40720,1529,3,68,1,723.86,NULL,'2023-01-14 10:53:23','2023-01-14 11:00:02','2023-01-14 11:00:02'),(1058,7566,351,40720,1529,3,57,2,6769.85,NULL,'2023-01-14 10:53:23','2023-01-14 11:00:02','2023-01-14 11:00:02'),(1059,7566,352,40720,1529,3,217,1,12265.29,NULL,'2023-01-14 10:53:23','2023-01-14 11:09:48','2023-01-14 11:09:48'),(1060,7566,352,40720,1529,3,68,1,2575.71,NULL,'2023-01-14 10:53:23','2023-01-14 11:09:48','2023-01-14 11:09:48'),(1061,7566,352,40720,1529,3,217,1,613.27,NULL,'2023-01-14 10:53:23','2023-01-14 11:09:48','2023-01-14 11:09:48'),(1062,7566,352,40720,1529,3,57,2,15454.27,NULL,'2023-01-14 10:53:23','2023-01-14 11:09:48','2023-01-14 11:09:48'),(1063,7566,353,40720,1529,3,217,1,14072.30,NULL,'2023-01-14 10:53:23','2023-01-14 10:57:30','2023-01-14 10:57:30'),(1064,7566,353,40720,1529,3,68,1,2955.18,NULL,'2023-01-14 10:53:23','2023-01-14 10:57:30','2023-01-14 10:57:30'),(1065,7566,353,40720,1529,3,217,1,579.70,NULL,'2023-01-14 10:53:23','2023-01-14 10:57:30','2023-01-14 10:57:30'),(1066,7566,353,40720,1529,3,57,2,17607.18,NULL,'2023-01-14 10:53:23','2023-01-14 10:57:30','2023-01-14 10:57:30'),(1067,7566,354,40720,1529,3,483,1,1842.98,NULL,'2023-01-14 10:53:23','2023-01-14 10:53:23',NULL),(1068,7566,354,40720,1529,3,68,1,387.02,NULL,'2023-01-14 10:53:23','2023-01-14 10:53:23',NULL);
INSERT INTO `balance_libro_details` VALUES (1069,7566,354,40720,1529,3,57,2,2230.00,NULL,'2023-01-14 10:53:23','2023-01-14 10:53:23',NULL),(1070,7566,355,40720,1529,3,217,1,18308.08,NULL,'2023-01-14 10:53:24','2023-01-14 11:01:12','2023-01-14 11:01:12'),(1071,7566,355,40720,1529,3,68,1,3844.70,NULL,'2023-01-14 10:53:24','2023-01-14 11:01:12','2023-01-14 11:01:12'),(1072,7566,355,40720,1529,3,57,2,22152.78,NULL,'2023-01-14 10:53:24','2023-01-14 11:01:12','2023-01-14 11:01:12'),(1073,7566,356,40720,1529,3,483,1,1842.98,NULL,'2023-01-14 10:53:24','2023-01-14 11:00:37','2023-01-14 11:00:37'),(1074,7566,356,40720,1529,3,68,1,387.02,NULL,'2023-01-14 10:53:24','2023-01-14 11:00:37','2023-01-14 11:00:37'),(1075,7566,356,40720,1529,3,57,2,2230.00,NULL,'2023-01-14 10:53:24','2023-01-14 11:00:37','2023-01-14 11:00:37'),(1076,7566,357,40720,1529,3,217,1,8447.35,NULL,'2023-01-14 10:53:24','2023-01-14 10:58:46','2023-01-14 10:58:46'),(1077,7566,357,40720,1529,3,68,1,886.97,NULL,'2023-01-14 10:53:24','2023-01-14 10:58:46','2023-01-14 10:58:46'),(1078,7566,357,40720,1529,3,57,2,9334.32,NULL,'2023-01-14 10:53:24','2023-01-14 10:58:46','2023-01-14 10:58:46'),(1079,7566,358,40720,1529,3,250,1,14000.00,NULL,'2023-01-14 10:53:24','2023-01-14 11:00:25','2023-01-14 11:00:25'),(1080,7566,358,40720,1529,3,57,2,14000.00,NULL,'2023-01-14 10:53:24','2023-01-14 11:00:25','2023-01-14 11:00:25'),(1081,7566,359,40720,1529,3,135,1,14072.30,NULL,'2023-01-14 10:57:30','2023-01-14 10:57:30',NULL),(1082,7566,359,40720,1529,3,68,1,2955.18,NULL,'2023-01-14 10:57:30','2023-01-14 10:57:30',NULL),(1083,7566,359,40720,1529,3,135,1,16.81,NULL,'2023-01-14 10:57:30','2023-01-14 10:57:30',NULL),(1084,7566,359,40720,1529,3,220,1,422.17,NULL,'2023-01-14 10:57:30','2023-01-14 10:57:30',NULL),(1085,7566,359,40720,1529,3,239,1,140.72,NULL,'2023-01-14 10:57:30','2023-01-14 10:57:30',NULL),(1086,7566,359,40720,1529,3,57,2,17607.18,NULL,'2023-01-14 10:57:30','2023-01-14 10:57:30',NULL),(1087,7566,360,40720,1529,3,135,1,370.02,NULL,'2023-01-14 10:58:46','2023-01-14 10:59:01','2023-01-14 10:59:01'),(1088,7566,360,40720,1529,3,68,1,77.70,NULL,'2023-01-14 10:58:46','2023-01-14 10:59:01','2023-01-14 10:59:01'),(1089,7566,360,40720,1529,3,135,1,8447.35,NULL,'2023-01-14 10:58:46','2023-01-14 10:59:01','2023-01-14 10:59:01'),(1090,7566,360,40720,1529,3,68,1,886.97,NULL,'2023-01-14 10:58:46','2023-01-14 10:59:01','2023-01-14 10:59:01'),(1091,7566,360,40720,1529,3,57,2,9782.04,NULL,'2023-01-14 10:58:46','2023-01-14 10:59:01','2023-01-14 10:59:01'),(1092,7566,361,40720,1529,3,135,1,370.02,NULL,'2023-01-14 10:59:01','2023-01-23 20:01:56','2023-01-23 20:01:56'),(1093,7566,361,40720,1529,3,68,1,77.70,NULL,'2023-01-14 10:59:01','2023-01-23 20:01:56','2023-01-23 20:01:56'),(1094,7566,361,40720,1529,3,135,1,8447.35,NULL,'2023-01-14 10:59:01','2023-01-23 20:01:56','2023-01-23 20:01:56'),(1095,7566,361,40720,1529,3,68,1,886.97,NULL,'2023-01-14 10:59:01','2023-01-23 20:01:56','2023-01-23 20:01:56'),(1096,7566,361,40720,1529,3,57,2,9782.04,NULL,'2023-01-14 10:59:01','2023-01-23 20:01:56','2023-01-23 20:01:56'),(1097,7566,362,40720,1529,3,135,1,847.94,NULL,'2023-01-14 11:00:02','2023-01-14 11:00:02',NULL),(1098,7566,362,40720,1529,3,68,1,178.07,NULL,'2023-01-14 11:00:02','2023-01-14 11:00:02',NULL),(1099,7566,362,40720,1529,3,135,1,5198.04,NULL,'2023-01-14 11:00:02','2023-01-14 11:00:02',NULL),(1100,7566,362,40720,1529,3,68,1,545.79,NULL,'2023-01-14 11:00:02','2023-01-14 11:00:02',NULL),(1101,7566,362,40720,1529,3,57,2,6769.84,NULL,'2023-01-14 11:00:02','2023-01-14 11:00:02',NULL),(1102,7566,363,40720,1529,3,192,1,14000.00,NULL,'2023-01-14 11:00:25','2023-01-14 11:00:25',NULL),(1103,7566,363,40720,1529,3,57,2,14000.00,NULL,'2023-01-14 11:00:25','2023-01-14 11:00:25',NULL),(1104,7566,364,40720,1529,3,483,1,1842.98,NULL,'2023-01-14 11:00:37','2023-01-14 11:00:37',NULL),(1105,7566,364,40720,1529,3,68,1,387.03,NULL,'2023-01-14 11:00:37','2023-01-14 11:00:37',NULL);
INSERT INTO `balance_libro_details` VALUES (1106,7566,364,40720,1529,3,57,2,2230.01,NULL,'2023-01-14 11:00:37','2023-01-14 11:00:37',NULL),(1107,7566,365,40720,1529,3,135,1,18308.08,NULL,'2023-01-14 11:01:12','2023-01-14 11:01:12',NULL),(1108,7566,365,40720,1529,3,68,1,3844.70,NULL,'2023-01-14 11:01:12','2023-01-14 11:01:12',NULL),(1109,7566,365,40720,1529,3,57,2,22152.78,NULL,'2023-01-14 11:01:12','2023-01-14 11:01:12',NULL),(1110,7566,366,40720,1529,3,199,1,2545.46,NULL,'2023-01-14 11:06:08','2023-01-23 20:13:49','2023-01-23 20:13:49'),(1111,7566,366,40720,1529,3,68,1,534.55,NULL,'2023-01-14 11:06:08','2023-01-23 20:13:49','2023-01-23 20:13:49'),(1112,7566,366,40720,1529,3,57,2,3080.01,NULL,'2023-01-14 11:06:08','2023-01-23 20:13:49','2023-01-23 20:13:49'),(1113,7566,367,40720,1529,3,199,1,4433.88,NULL,'2023-01-14 11:08:22','2023-01-23 20:14:06','2023-01-23 20:14:06'),(1114,7566,367,40720,1529,3,68,1,931.11,NULL,'2023-01-14 11:08:22','2023-01-23 20:14:06','2023-01-23 20:14:06'),(1115,7566,367,40720,1529,3,220,1,133.02,NULL,'2023-01-14 11:08:22','2023-01-23 20:14:06','2023-01-23 20:14:06'),(1116,7566,367,40720,1529,3,241,1,44.34,NULL,'2023-01-14 11:08:22','2023-01-23 20:14:06','2023-01-23 20:14:06'),(1117,7566,367,40720,1529,3,57,2,5542.35,NULL,'2023-01-14 11:08:22','2023-01-23 20:14:06','2023-01-23 20:14:06'),(1118,7566,368,40720,1529,3,135,1,12265.29,NULL,'2023-01-14 11:09:48','2023-01-14 11:10:59','2023-01-14 11:10:59'),(1119,7566,368,40720,1529,3,68,1,2575.71,NULL,'2023-01-14 11:09:48','2023-01-14 11:10:59','2023-01-14 11:10:59'),(1120,7566,368,40720,1529,3,135,1,613.27,NULL,'2023-01-14 11:09:48','2023-01-14 11:10:59','2023-01-14 11:10:59'),(1121,7566,368,40720,1529,3,220,1,367.96,NULL,'2023-01-14 11:09:48','2023-01-14 11:10:59','2023-01-14 11:10:59'),(1122,7566,368,40720,1529,3,239,1,145.31,NULL,'2023-01-14 11:09:48','2023-01-14 11:10:59','2023-01-14 11:10:59'),(1123,7566,368,40720,1529,3,57,2,15967.54,NULL,'2023-01-14 11:09:48','2023-01-14 11:10:59','2023-01-14 11:10:59'),(1124,7566,369,40720,1529,3,135,1,12265.29,NULL,'2023-01-14 11:10:59','2023-01-14 11:10:59',NULL),(1125,7566,369,40720,1529,3,68,1,2575.71,NULL,'2023-01-14 11:10:59','2023-01-14 11:10:59',NULL),(1126,7566,369,40720,1529,3,220,1,367.96,NULL,'2023-01-14 11:10:59','2023-01-14 11:10:59',NULL),(1127,7566,369,40720,1529,3,239,1,245.31,NULL,'2023-01-14 11:10:59','2023-01-14 11:10:59',NULL),(1128,7566,369,40720,1529,3,57,2,15454.27,NULL,'2023-01-14 11:10:59','2023-01-14 11:10:59',NULL),(1129,7566,370,40720,1529,3,484,1,5491.70,NULL,'2023-01-14 11:15:42','2023-01-14 11:15:42',NULL),(1130,7566,370,40720,1529,3,68,1,1153.26,NULL,'2023-01-14 11:15:42','2023-01-14 11:15:42',NULL),(1131,7566,370,40720,1529,3,484,1,56.06,NULL,'2023-01-14 11:15:42','2023-01-14 11:15:42',NULL),(1132,7566,370,40720,1529,3,57,2,6701.02,NULL,'2023-01-14 11:15:42','2023-01-14 11:15:42',NULL),(1133,7566,371,40720,1529,3,484,1,5904.02,NULL,'2023-01-14 11:17:06','2023-01-14 11:17:06',NULL),(1134,7566,371,40720,1529,3,68,1,1239.84,NULL,'2023-01-14 11:17:06','2023-01-14 11:17:06',NULL),(1135,7566,371,40720,1529,3,484,1,57.34,NULL,'2023-01-14 11:17:06','2023-01-14 11:17:06',NULL),(1136,7566,371,40720,1529,3,239,1,59.61,NULL,'2023-01-14 11:17:06','2023-01-14 11:17:06',NULL),(1137,7566,371,40720,1529,3,57,2,7260.81,NULL,'2023-01-14 11:17:06','2023-01-14 11:17:06',NULL),(1138,7566,372,40720,1529,3,484,1,5164.77,NULL,'2023-01-14 11:17:53','2023-01-14 11:17:53',NULL),(1139,7566,372,40720,1529,3,68,1,1084.60,NULL,'2023-01-14 11:17:53','2023-01-14 11:17:53',NULL),(1140,7566,372,40720,1529,3,484,1,51.12,NULL,'2023-01-14 11:17:53','2023-01-14 11:17:53',NULL),(1141,7566,372,40720,1529,3,239,1,52.16,NULL,'2023-01-14 11:17:53','2023-01-14 11:17:53',NULL),(1142,7566,372,40720,1529,3,57,2,6352.65,NULL,'2023-01-14 11:17:53','2023-01-14 11:17:53',NULL),(1143,7566,373,40720,1529,3,484,1,5111.42,NULL,'2023-01-14 11:20:30','2023-01-14 11:20:30',NULL),(1144,7566,373,40720,1529,3,68,1,1073.40,NULL,'2023-01-14 11:20:30','2023-01-14 11:20:30',NULL);
INSERT INTO `balance_libro_details` VALUES (1145,7566,373,40720,1529,3,484,1,50.39,NULL,'2023-01-14 11:20:30','2023-01-14 11:20:30',NULL),(1146,7566,373,40720,1529,3,241,1,51.11,NULL,'2023-01-14 11:20:30','2023-01-14 11:20:30',NULL),(1147,7566,373,40720,1529,3,57,2,6286.32,NULL,'2023-01-14 11:20:30','2023-01-14 11:20:30',NULL),(1148,7566,374,40720,1529,3,484,1,2190.08,NULL,'2023-01-14 11:22:18','2023-01-14 11:22:18',NULL),(1149,7566,374,40720,1529,3,68,1,459.92,NULL,'2023-01-14 11:22:18','2023-01-14 11:22:18',NULL),(1150,7566,374,40720,1529,3,57,2,2650.00,NULL,'2023-01-14 11:22:18','2023-01-14 11:22:18',NULL),(1151,7566,375,40720,1529,3,482,1,32098.00,NULL,'2023-01-14 11:24:30','2023-01-14 11:24:30',NULL),(1152,7566,375,40720,1529,3,68,1,6740.58,NULL,'2023-01-14 11:24:30','2023-01-14 11:24:30',NULL),(1153,7566,375,40720,1529,3,57,2,38838.58,NULL,'2023-01-14 11:24:30','2023-01-14 11:24:30',NULL),(1154,7566,376,40720,1529,3,482,1,30500.00,NULL,'2023-01-14 11:24:54','2023-01-14 11:24:54',NULL),(1155,7566,376,40720,1529,3,68,1,6405.00,NULL,'2023-01-14 11:24:54','2023-01-14 11:24:54',NULL),(1156,7566,376,40720,1529,3,57,2,36905.00,NULL,'2023-01-14 11:24:54','2023-01-14 11:24:54',NULL),(1157,7566,377,40720,1529,3,482,1,34000.00,NULL,'2023-01-14 11:25:25','2023-01-14 11:25:25',NULL),(1158,7566,377,40720,1529,3,68,1,7140.00,NULL,'2023-01-14 11:25:25','2023-01-14 11:25:25',NULL),(1159,7566,377,40720,1529,3,57,2,41140.00,NULL,'2023-01-14 11:25:25','2023-01-14 11:25:25',NULL),(1160,7566,378,40720,1529,7,25,1,511.81,NULL,'2023-01-14 11:29:33','2023-01-14 11:29:33',NULL),(1161,7566,378,40720,1529,7,13,2,511.81,NULL,'2023-01-14 11:29:33','2023-01-14 11:29:33',NULL),(1162,7566,379,40720,1529,7,25,1,78.88,NULL,'2023-01-14 11:29:33','2023-01-14 11:29:33',NULL),(1163,7566,379,40720,1529,7,13,2,78.88,NULL,'2023-01-14 11:29:33','2023-01-14 11:29:33',NULL),(1164,7566,380,40720,1529,7,25,1,3549.22,NULL,'2023-01-14 11:29:33','2023-01-14 11:29:33',NULL),(1165,7566,380,40720,1529,7,13,2,3549.22,NULL,'2023-01-14 11:29:33','2023-01-14 11:29:33',NULL),(1166,7566,381,40720,1529,7,25,1,329.09,NULL,'2023-01-14 11:29:33','2023-01-14 11:29:33',NULL),(1167,7566,381,40720,1529,7,13,2,329.09,NULL,'2023-01-14 11:29:33','2023-01-14 11:29:33',NULL),(1168,7566,382,40720,1529,7,25,1,4676.37,NULL,'2023-01-14 11:29:33','2023-01-14 11:29:33',NULL),(1169,7566,382,40720,1529,7,13,2,4676.37,NULL,'2023-01-14 11:29:33','2023-01-14 11:29:33',NULL),(1170,7566,383,40720,1529,7,25,1,8614.66,NULL,'2023-01-14 11:29:33','2023-01-14 11:29:33',NULL),(1171,7566,383,40720,1529,7,13,2,8614.66,NULL,'2023-01-14 11:29:33','2023-01-14 11:29:33',NULL),(1172,7566,384,40720,1529,7,25,1,181.33,NULL,'2023-01-14 11:29:33','2023-01-14 11:29:33',NULL),(1173,7566,384,40720,1529,7,13,2,181.33,NULL,'2023-01-14 11:29:33','2023-01-14 11:29:33',NULL),(1174,7566,385,40720,1529,7,25,1,628.40,NULL,'2023-01-14 11:29:33','2023-01-14 11:29:33',NULL),(1175,7566,385,40720,1529,7,13,2,628.40,NULL,'2023-01-14 11:29:33','2023-01-14 11:29:33',NULL),(1176,7566,386,40720,1529,7,25,1,3035.51,NULL,'2023-01-14 11:29:33','2023-01-14 11:29:33',NULL),(1177,7566,386,40720,1529,7,13,2,3035.51,NULL,'2023-01-14 11:29:33','2023-01-14 11:29:33',NULL),(1178,7566,387,40720,1529,7,25,1,1537.47,NULL,'2023-01-14 11:29:33','2023-01-14 11:29:33',NULL),(1179,7566,387,40720,1529,7,13,2,1537.47,NULL,'2023-01-14 11:29:33','2023-01-14 11:29:33',NULL),(1180,7566,388,40720,1529,7,25,1,2219.20,NULL,'2023-01-14 11:29:33','2023-01-14 11:29:33',NULL),(1181,7566,388,40720,1529,7,13,2,2219.20,NULL,'2023-01-14 11:29:33','2023-01-14 11:29:33',NULL),(1182,7566,389,40720,1529,7,25,1,1231.61,NULL,'2023-01-14 11:29:33','2023-01-14 11:29:33',NULL),(1183,7566,389,40720,1529,7,13,2,1231.61,NULL,'2023-01-14 11:29:33','2023-01-14 11:29:33',NULL),(1184,7566,390,40720,1529,8,290,1,441.46,NULL,'2023-01-14 12:01:19','2023-01-14 12:01:19',NULL),(1185,7566,390,40720,1529,8,351,2,441.46,NULL,'2023-01-14 12:01:19','2023-01-14 12:01:19',NULL);
INSERT INTO `balance_libro_details` VALUES (1186,7566,391,40720,1529,3,135,1,33485.64,NULL,'2023-01-23 19:33:39','2023-01-23 19:34:31','2023-01-23 19:34:31'),(1187,7566,391,40720,1529,3,68,1,7031.98,NULL,'2023-01-23 19:33:39','2023-01-23 19:34:31','2023-01-23 19:34:31'),(1188,7566,391,40720,1529,3,135,1,275.64,NULL,'2023-01-23 19:33:39','2023-01-23 19:34:31','2023-01-23 19:34:31'),(1189,7566,391,40720,1529,3,68,1,28.94,NULL,'2023-01-23 19:33:39','2023-01-23 19:34:31','2023-01-23 19:34:31'),(1190,7566,391,40720,1529,3,220,1,1008.70,NULL,'2023-01-23 19:33:39','2023-01-23 19:34:31','2023-01-23 19:34:31'),(1191,7566,391,40720,1529,3,239,1,337.61,NULL,'2023-01-23 19:33:39','2023-01-23 19:34:31','2023-01-23 19:34:31'),(1192,7566,391,40720,1529,3,57,2,42168.52,NULL,'2023-01-23 19:33:39','2023-01-23 19:34:31','2023-01-23 19:34:31'),(1193,7566,391,40720,1529,3,136,1,0.01,NULL,'2023-01-23 19:33:39','2023-01-23 19:34:31','2023-01-23 19:34:31'),(1194,7566,392,40720,1529,3,135,1,33485.64,NULL,'2023-01-23 19:34:31','2023-01-23 19:34:31',NULL),(1195,7566,392,40720,1529,3,68,1,7031.98,NULL,'2023-01-23 19:34:31','2023-01-23 19:34:31',NULL),(1196,7566,392,40720,1529,3,135,1,275.64,NULL,'2023-01-23 19:34:31','2023-01-23 19:34:31',NULL),(1197,7566,392,40720,1529,3,68,1,28.94,NULL,'2023-01-23 19:34:31','2023-01-23 19:34:31',NULL),(1198,7566,392,40720,1529,3,135,1,131.01,NULL,'2023-01-23 19:34:31','2023-01-23 19:34:31',NULL),(1199,7566,392,40720,1529,3,220,1,1008.70,NULL,'2023-01-23 19:34:31','2023-01-23 19:34:31',NULL),(1200,7566,392,40720,1529,3,239,1,337.61,NULL,'2023-01-23 19:34:31','2023-01-23 19:34:31',NULL),(1201,7566,392,40720,1529,3,57,2,42299.53,NULL,'2023-01-23 19:34:31','2023-01-23 19:34:31',NULL),(1202,7566,392,40720,1529,3,136,1,0.01,NULL,'2023-01-23 19:34:31','2023-01-23 19:34:31',NULL),(1203,7566,393,40720,1529,3,135,1,8447.35,NULL,'2023-01-23 20:01:56','2023-01-23 20:01:56',NULL),(1204,7566,393,40720,1529,3,68,1,886.97,NULL,'2023-01-23 20:01:56','2023-01-23 20:01:56',NULL),(1205,7566,393,40720,1529,3,57,2,9334.32,NULL,'2023-01-23 20:01:56','2023-01-23 20:01:56',NULL),(1206,7566,394,40720,1529,3,199,1,2545.46,NULL,'2023-01-23 20:13:49','2023-01-23 20:13:49',NULL),(1207,7566,394,40720,1529,3,68,1,534.55,NULL,'2023-01-23 20:13:49','2023-01-23 20:13:49',NULL),(1208,7566,394,40720,1529,3,57,2,3080.01,NULL,'2023-01-23 20:13:49','2023-01-23 20:13:49',NULL),(1209,7566,395,40720,1529,3,199,1,4433.88,NULL,'2023-01-23 20:14:06','2023-01-23 20:14:06',NULL),(1210,7566,395,40720,1529,3,68,1,931.11,NULL,'2023-01-23 20:14:06','2023-01-23 20:14:06',NULL),(1211,7566,395,40720,1529,3,220,1,133.02,NULL,'2023-01-23 20:14:06','2023-01-23 20:14:06',NULL),(1212,7566,395,40720,1529,3,241,1,44.34,NULL,'2023-01-23 20:14:06','2023-01-23 20:14:06',NULL),(1213,7566,395,40720,1529,3,57,2,5542.35,NULL,'2023-01-23 20:14:06','2023-01-23 20:14:06',NULL),(1214,7566,396,40720,1533,2,96,2,136213.68,NULL,'2023-02-20 16:17:15','2023-02-20 16:17:15',NULL),(1215,7566,396,40720,1533,2,67,2,28604.87,NULL,'2023-02-20 16:17:15','2023-02-20 16:17:15',NULL),(1216,7566,396,40720,1533,2,13,1,164818.55,NULL,'2023-02-20 16:17:15','2023-02-20 16:17:15',NULL),(1217,7566,397,40720,1533,2,96,2,154554.47,NULL,'2023-02-20 16:17:15','2023-02-20 16:17:15',NULL),(1218,7566,397,40720,1533,2,67,2,32456.44,NULL,'2023-02-20 16:17:15','2023-02-20 16:17:15',NULL),(1219,7566,397,40720,1533,2,13,1,187010.91,NULL,'2023-02-20 16:17:15','2023-02-20 16:17:15',NULL),(1220,7566,398,40720,1533,2,96,2,5198.82,NULL,'2023-02-20 16:17:15','2023-02-20 16:17:15',NULL),(1221,7566,398,40720,1533,2,67,2,1091.75,NULL,'2023-02-20 16:17:15','2023-02-20 16:17:15',NULL),(1222,7566,398,40720,1533,2,13,1,6290.57,NULL,'2023-02-20 16:17:15','2023-02-20 16:17:15',NULL),(1223,7566,399,40720,1533,2,96,2,6869.91,NULL,'2023-02-20 16:17:15','2023-02-20 16:17:15',NULL),(1224,7566,399,40720,1533,2,67,2,1442.68,NULL,'2023-02-20 16:17:15','2023-02-20 16:17:15',NULL),(1225,7566,399,40720,1533,2,13,1,8312.59,NULL,'2023-02-20 16:17:15','2023-02-20 16:17:15',NULL);
INSERT INTO `balance_libro_details` VALUES (1226,7566,400,40720,1533,2,96,2,251576.34,NULL,'2023-02-20 16:17:15','2023-02-20 16:17:15',NULL),(1227,7566,400,40720,1533,2,67,2,52831.03,NULL,'2023-02-20 16:17:15','2023-02-20 16:17:15',NULL),(1228,7566,400,40720,1533,2,13,1,304407.37,NULL,'2023-02-20 16:17:15','2023-02-20 16:17:15',NULL),(1229,7566,401,40720,1533,7,25,1,66.82,NULL,'2023-02-20 16:26:06','2023-02-20 16:26:06',NULL),(1230,7566,401,40720,1533,7,13,2,66.82,NULL,'2023-02-20 16:26:06','2023-02-20 16:26:06',NULL),(1231,7566,402,40720,1533,7,25,1,71.39,NULL,'2023-02-20 16:26:06','2023-02-20 16:26:06',NULL),(1232,7566,402,40720,1533,7,13,2,71.39,NULL,'2023-02-20 16:26:06','2023-02-20 16:26:06',NULL),(1233,7566,403,40720,1533,7,25,1,657.76,NULL,'2023-02-20 16:26:06','2023-02-20 16:26:06',NULL),(1234,7566,403,40720,1533,7,13,2,657.76,NULL,'2023-02-20 16:26:06','2023-02-20 16:26:06',NULL),(1235,7566,404,40720,1533,7,25,1,873.40,NULL,'2023-02-20 16:26:06','2023-02-20 16:26:06',NULL),(1236,7566,404,40720,1533,7,13,2,873.40,NULL,'2023-02-20 16:26:06','2023-02-20 16:26:06',NULL),(1237,7566,405,40720,1533,7,25,1,3175.06,NULL,'2023-02-20 16:26:06','2023-02-20 16:26:06',NULL),(1238,7566,405,40720,1533,7,13,2,3175.06,NULL,'2023-02-20 16:26:06','2023-02-20 16:26:06',NULL),(1239,7566,406,40720,1533,7,25,1,1923.79,NULL,'2023-02-20 16:26:06','2023-02-20 16:26:06',NULL),(1240,7566,406,40720,1533,7,13,2,1923.79,NULL,'2023-02-20 16:26:06','2023-02-20 16:26:06',NULL),(1241,7566,407,40720,1533,7,25,1,5454.38,NULL,'2023-02-20 16:26:06','2023-02-20 16:26:06',NULL),(1242,7566,407,40720,1533,7,13,2,5454.38,NULL,'2023-02-20 16:26:06','2023-02-20 16:26:06',NULL),(1243,7566,408,40720,1533,7,25,1,2148.38,NULL,'2023-02-20 16:26:06','2023-02-20 16:26:06',NULL),(1244,7566,408,40720,1533,7,13,2,2148.38,NULL,'2023-02-20 16:26:06','2023-02-20 16:26:06',NULL),(1245,7566,409,40720,1533,7,25,1,66.84,NULL,'2023-02-20 16:26:06','2023-02-20 16:26:06',NULL),(1246,7566,409,40720,1533,7,13,2,66.84,NULL,'2023-02-20 16:26:06','2023-02-20 16:26:06',NULL),(1247,7566,410,40720,1533,7,25,1,703.17,NULL,'2023-02-20 16:26:07','2023-02-20 16:26:07',NULL),(1248,7566,410,40720,1533,7,13,2,703.17,NULL,'2023-02-20 16:26:07','2023-02-20 16:26:07',NULL),(1249,7566,411,40720,1533,7,25,1,156.56,NULL,'2023-02-20 16:26:07','2023-02-20 16:26:07',NULL),(1250,7566,411,40720,1533,7,13,2,156.56,NULL,'2023-02-20 16:26:07','2023-02-20 16:26:07',NULL),(1251,7566,412,40720,1533,7,25,1,2229.04,NULL,'2023-02-20 16:26:07','2023-02-20 16:26:07',NULL),(1252,7566,412,40720,1533,7,13,2,2229.04,NULL,'2023-02-20 16:26:07','2023-02-20 16:26:07',NULL),(1253,7566,413,40720,1533,7,25,1,6947.91,NULL,'2023-02-20 16:26:07','2023-02-20 16:26:07',NULL),(1254,7566,413,40720,1533,7,13,2,6947.91,NULL,'2023-02-20 16:26:07','2023-02-20 16:26:07',NULL),(1255,7566,414,40720,1533,7,25,1,2283.12,NULL,'2023-02-20 16:26:07','2023-02-20 16:26:07',NULL),(1256,7566,414,40720,1533,7,13,2,2283.12,NULL,'2023-02-20 16:26:07','2023-02-20 16:26:07',NULL),(1257,7566,415,40720,1533,7,25,1,1350.90,NULL,'2023-02-20 16:26:07','2023-02-20 16:26:07',NULL),(1258,7566,415,40720,1533,7,13,2,1350.90,NULL,'2023-02-20 16:26:07','2023-02-20 16:26:07',NULL),(1259,7566,416,40720,1533,8,290,1,441.57,NULL,'2023-02-20 16:28:25','2023-02-20 16:28:25',NULL),(1260,7566,416,40720,1533,8,351,2,441.57,NULL,'2023-02-20 16:28:25','2023-02-20 16:28:25',NULL),(1261,7566,417,40720,1533,3,250,1,0.00,NULL,'2023-02-20 16:35:13','2023-02-20 17:34:56','2023-02-20 17:34:56'),(1262,7566,417,40720,1533,3,250,1,16666.16,NULL,'2023-02-20 16:35:13','2023-02-20 17:34:56','2023-02-20 17:34:56'),(1263,7566,417,40720,1533,3,57,2,16666.16,NULL,'2023-02-20 16:35:13','2023-02-20 17:34:56','2023-02-20 17:34:56'),(1264,7566,418,40720,1533,3,199,1,2727.27,NULL,'2023-02-20 16:35:13','2023-02-20 17:37:48','2023-02-20 17:37:48'),(1265,7566,418,40720,1533,3,68,1,572.73,NULL,'2023-02-20 16:35:13','2023-02-20 17:37:48','2023-02-20 17:37:48');
INSERT INTO `balance_libro_details` VALUES (1266,7566,418,40720,1533,3,57,2,3300.00,NULL,'2023-02-20 16:35:13','2023-02-20 17:37:48','2023-02-20 17:37:48'),(1267,7566,419,40720,1533,3,217,1,4436.05,NULL,'2023-02-20 16:35:13','2023-02-20 17:37:25','2023-02-20 17:37:25'),(1268,7566,419,40720,1533,3,68,1,931.57,NULL,'2023-02-20 16:35:13','2023-02-20 17:37:25','2023-02-20 17:37:25'),(1269,7566,419,40720,1533,3,217,1,369.21,NULL,'2023-02-20 16:35:13','2023-02-20 17:37:25','2023-02-20 17:37:25'),(1270,7566,419,40720,1533,3,57,2,5736.83,NULL,'2023-02-20 16:35:13','2023-02-20 17:37:25','2023-02-20 17:37:25'),(1271,7566,420,40720,1533,3,116,1,11250.00,NULL,'2023-02-20 16:35:13','2023-02-20 17:38:35','2023-02-20 17:38:35'),(1272,7566,420,40720,1533,3,57,2,11250.00,NULL,'2023-02-20 16:35:13','2023-02-20 17:38:35','2023-02-20 17:38:35'),(1273,7566,421,40720,1533,3,193,1,2469.08,NULL,'2023-02-20 16:35:13','2023-02-20 18:32:45','2023-02-20 18:32:45'),(1274,7566,421,40720,1533,3,68,1,610.19,NULL,'2023-02-20 16:35:13','2023-02-20 18:32:45','2023-02-20 18:32:45'),(1275,7566,421,40720,1533,3,193,1,281.97,NULL,'2023-02-20 16:35:13','2023-02-20 18:32:45','2023-02-20 18:32:45'),(1276,7566,421,40720,1533,3,57,2,3361.24,NULL,'2023-02-20 16:35:13','2023-02-20 18:32:45','2023-02-20 18:32:45'),(1277,7566,422,40720,1533,3,217,1,11752.07,NULL,'2023-02-20 16:35:13','2023-02-20 17:41:13','2023-02-20 17:41:13'),(1278,7566,422,40720,1533,3,68,1,2467.93,NULL,'2023-02-20 16:35:13','2023-02-20 17:41:13','2023-02-20 17:41:13'),(1279,7566,422,40720,1533,3,57,2,14220.00,NULL,'2023-02-20 16:35:13','2023-02-20 17:41:13','2023-02-20 17:41:13'),(1280,7566,423,40720,1533,3,217,1,6463.95,NULL,'2023-02-20 16:35:13','2023-02-20 17:49:06','2023-02-20 17:49:06'),(1281,7566,423,40720,1533,3,68,1,1341.18,NULL,'2023-02-20 16:35:13','2023-02-20 17:49:06','2023-02-20 17:49:06'),(1282,7566,423,40720,1533,3,57,2,7805.13,NULL,'2023-02-20 16:35:13','2023-02-20 17:49:06','2023-02-20 17:49:06'),(1283,7566,424,40720,1533,3,217,1,6755.02,NULL,'2023-02-20 16:35:13','2023-02-20 17:50:27','2023-02-20 17:50:27'),(1284,7566,424,40720,1533,3,68,1,1091.96,NULL,'2023-02-20 16:35:13','2023-02-20 17:50:27','2023-02-20 17:50:27'),(1285,7566,424,40720,1533,3,57,2,7846.98,NULL,'2023-02-20 16:35:13','2023-02-20 17:50:27','2023-02-20 17:50:27'),(1286,7566,425,40720,1533,3,217,1,3347.30,NULL,'2023-02-20 16:35:13','2023-02-20 17:55:09','2023-02-20 17:55:09'),(1287,7566,425,40720,1533,3,68,1,702.93,NULL,'2023-02-20 16:35:13','2023-02-20 17:55:09','2023-02-20 17:55:09'),(1288,7566,425,40720,1533,3,57,2,4050.23,NULL,'2023-02-20 16:35:13','2023-02-20 17:55:09','2023-02-20 17:55:09'),(1289,7566,426,40720,1533,3,217,1,5221.33,NULL,'2023-02-20 16:35:13','2023-02-20 17:57:15','2023-02-20 17:57:15'),(1290,7566,426,40720,1533,3,68,1,571.67,NULL,'2023-02-20 16:35:13','2023-02-20 17:57:15','2023-02-20 17:57:15'),(1291,7566,426,40720,1533,3,57,2,5793.00,NULL,'2023-02-20 16:35:13','2023-02-20 17:57:15','2023-02-20 17:57:15'),(1292,7566,427,40720,1533,3,483,1,2181.82,NULL,'2023-02-20 16:35:14','2023-02-20 17:58:14','2023-02-20 17:58:14'),(1293,7566,427,40720,1533,3,68,1,458.18,NULL,'2023-02-20 16:35:14','2023-02-20 17:58:14','2023-02-20 17:58:14'),(1294,7566,427,40720,1533,3,57,2,2640.00,NULL,'2023-02-20 16:35:14','2023-02-20 17:58:14','2023-02-20 17:58:14'),(1295,7566,428,40720,1533,3,217,1,4030.50,NULL,'2023-02-20 16:35:14','2023-02-20 18:03:11','2023-02-20 18:03:11'),(1296,7566,428,40720,1533,3,68,1,846.41,NULL,'2023-02-20 16:35:14','2023-02-20 18:03:11','2023-02-20 18:03:11'),(1297,7566,428,40720,1533,3,217,1,162.07,NULL,'2023-02-20 16:35:14','2023-02-20 18:03:11','2023-02-20 18:03:11'),(1298,7566,428,40720,1533,3,57,2,5038.98,NULL,'2023-02-20 16:35:14','2023-02-20 18:03:11','2023-02-20 18:03:11'),(1299,7566,429,40720,1533,3,217,1,1214.88,NULL,'2023-02-20 16:35:14','2023-02-20 18:05:59','2023-02-20 18:05:59'),(1300,7566,429,40720,1533,3,68,1,255.12,NULL,'2023-02-20 16:35:14','2023-02-20 18:05:59','2023-02-20 18:05:59');
INSERT INTO `balance_libro_details` VALUES (1301,7566,429,40720,1533,3,57,2,1470.00,NULL,'2023-02-20 16:35:14','2023-02-20 18:05:59','2023-02-20 18:05:59'),(1302,7566,430,40720,1533,3,217,1,5516.53,NULL,'2023-02-20 16:35:14','2023-02-20 18:33:12','2023-02-20 18:33:12'),(1303,7566,430,40720,1533,3,68,1,1158.47,NULL,'2023-02-20 16:35:14','2023-02-20 18:33:12','2023-02-20 18:33:12'),(1304,7566,430,40720,1533,3,217,1,220.67,NULL,'2023-02-20 16:35:14','2023-02-20 18:33:12','2023-02-20 18:33:12'),(1305,7566,430,40720,1533,3,57,2,6895.67,NULL,'2023-02-20 16:35:14','2023-02-20 18:33:12','2023-02-20 18:33:12'),(1306,7566,431,40720,1533,3,483,1,1818.18,NULL,'2023-02-20 16:35:14','2023-02-20 18:07:33','2023-02-20 18:07:33'),(1307,7566,431,40720,1533,3,68,1,381.82,NULL,'2023-02-20 16:35:14','2023-02-20 18:07:33','2023-02-20 18:07:33'),(1308,7566,431,40720,1533,3,57,2,2200.00,NULL,'2023-02-20 16:35:14','2023-02-20 18:07:33','2023-02-20 18:07:33'),(1309,7566,432,40720,1533,3,483,1,1818.18,NULL,'2023-02-20 16:35:14','2023-02-20 18:33:39','2023-02-20 18:33:39'),(1310,7566,432,40720,1533,3,68,1,381.82,NULL,'2023-02-20 16:35:14','2023-02-20 18:33:39','2023-02-20 18:33:39'),(1311,7566,432,40720,1533,3,57,2,2200.00,NULL,'2023-02-20 16:35:14','2023-02-20 18:33:39','2023-02-20 18:33:39'),(1312,7566,433,40720,1533,3,483,2,1818.18,NULL,'2023-02-20 16:35:14','2023-02-20 18:33:29','2023-02-20 18:33:29'),(1313,7566,433,40720,1533,3,67,2,381.82,NULL,'2023-02-20 16:35:14','2023-02-20 18:33:29','2023-02-20 18:33:29'),(1314,7566,433,40720,1533,3,57,1,2200.00,NULL,'2023-02-20 16:35:14','2023-02-20 18:33:29','2023-02-20 18:33:29'),(1315,7566,434,40720,1533,3,217,1,2443.28,NULL,'2023-02-20 16:35:14','2023-02-20 18:11:56','2023-02-20 18:11:56'),(1316,7566,434,40720,1533,3,68,1,256.54,NULL,'2023-02-20 16:35:14','2023-02-20 18:11:56','2023-02-20 18:11:56'),(1317,7566,434,40720,1533,3,57,2,2699.82,NULL,'2023-02-20 16:35:14','2023-02-20 18:11:56','2023-02-20 18:11:56'),(1318,7566,435,40720,1533,3,217,1,7035.92,NULL,'2023-02-20 16:35:14','2023-02-20 18:17:14','2023-02-20 18:17:14'),(1319,7566,435,40720,1533,3,68,1,924.00,NULL,'2023-02-20 16:35:14','2023-02-20 18:17:14','2023-02-20 18:17:14'),(1320,7566,435,40720,1533,3,217,1,2845.52,NULL,'2023-02-20 16:35:14','2023-02-20 18:17:14','2023-02-20 18:17:14'),(1321,7566,435,40720,1533,3,57,2,10805.44,NULL,'2023-02-20 16:35:14','2023-02-20 18:17:14','2023-02-20 18:17:14'),(1322,7566,436,40720,1533,3,217,1,11544.63,NULL,'2023-02-20 16:35:14','2023-02-20 18:19:10','2023-02-20 18:19:10'),(1323,7566,436,40720,1533,3,68,1,1485.88,NULL,'2023-02-20 16:35:14','2023-02-20 18:19:10','2023-02-20 18:19:10'),(1324,7566,436,40720,1533,3,217,1,3349.83,NULL,'2023-02-20 16:35:14','2023-02-20 18:19:10','2023-02-20 18:19:10'),(1325,7566,436,40720,1533,3,57,2,16380.34,NULL,'2023-02-20 16:35:14','2023-02-20 18:19:10','2023-02-20 18:19:10'),(1326,7566,437,40720,1533,3,483,1,1305.79,NULL,'2023-02-20 16:35:14','2023-02-20 18:19:45','2023-02-20 18:19:45'),(1327,7566,437,40720,1533,3,68,1,274.21,NULL,'2023-02-20 16:35:14','2023-02-20 18:19:45','2023-02-20 18:19:45'),(1328,7566,437,40720,1533,3,57,2,1580.00,NULL,'2023-02-20 16:35:14','2023-02-20 18:19:45','2023-02-20 18:19:45'),(1329,7566,438,40720,1533,3,217,1,5461.16,NULL,'2023-02-20 16:35:14','2023-02-20 18:31:21','2023-02-20 18:31:21'),(1330,7566,438,40720,1533,3,68,1,1146.84,NULL,'2023-02-20 16:35:14','2023-02-20 18:31:21','2023-02-20 18:31:21'),(1331,7566,438,40720,1533,3,57,2,6608.00,NULL,'2023-02-20 16:35:14','2023-02-20 18:31:21','2023-02-20 18:31:21'),(1332,7566,439,40720,1533,3,217,1,1818.18,NULL,'2023-02-20 16:35:14','2023-02-20 18:23:17','2023-02-20 18:23:17'),(1333,7566,439,40720,1533,3,68,1,381.82,NULL,'2023-02-20 16:35:14','2023-02-20 18:23:17','2023-02-20 18:23:17'),(1334,7566,439,40720,1533,3,57,2,2200.00,NULL,'2023-02-20 16:35:14','2023-02-20 18:23:17','2023-02-20 18:23:17'),(1335,7566,440,40720,1533,3,217,1,3761.60,NULL,'2023-02-20 16:35:14','2023-02-20 18:24:32','2023-02-20 18:24:32');
INSERT INTO `balance_libro_details` VALUES (1336,7566,440,40720,1533,3,68,1,418.40,NULL,'2023-02-20 16:35:14','2023-02-20 18:24:32','2023-02-20 18:24:32'),(1337,7566,440,40720,1533,3,57,2,4180.00,NULL,'2023-02-20 16:35:14','2023-02-20 18:24:32','2023-02-20 18:24:32'),(1338,7566,441,40720,1533,3,217,1,687.85,NULL,'2023-02-20 16:35:14','2023-11-18 12:32:36','2023-11-18 12:32:36'),(1339,7566,441,40720,1533,3,68,1,144.45,NULL,'2023-02-20 16:35:14','2023-11-18 12:32:36','2023-11-18 12:32:36'),(1340,7566,441,40720,1533,3,57,2,832.30,NULL,'2023-02-20 16:35:14','2023-11-18 12:32:36','2023-11-18 12:32:36'),(1341,7566,442,40720,1533,3,217,1,6090.91,NULL,'2023-02-20 16:35:14','2023-02-20 18:27:02','2023-02-20 18:27:02'),(1342,7566,442,40720,1533,3,68,1,1279.09,NULL,'2023-02-20 16:35:14','2023-02-20 18:27:02','2023-02-20 18:27:02'),(1343,7566,442,40720,1533,3,57,2,7370.00,NULL,'2023-02-20 16:35:14','2023-02-20 18:27:02','2023-02-20 18:27:02'),(1344,7566,443,40720,1533,3,217,1,3065.02,NULL,'2023-02-20 16:35:14','2023-02-20 18:28:44','2023-02-20 18:28:44'),(1345,7566,443,40720,1533,3,68,1,321.83,NULL,'2023-02-20 16:35:14','2023-02-20 18:28:44','2023-02-20 18:28:44'),(1346,7566,443,40720,1533,3,217,1,-0.01,NULL,'2023-02-20 16:35:14','2023-02-20 18:28:44','2023-02-20 18:28:44'),(1347,7566,443,40720,1533,3,57,2,3386.84,NULL,'2023-02-20 16:35:14','2023-02-20 18:28:44','2023-02-20 18:28:44'),(1348,7566,444,40720,1533,3,217,1,1938.46,NULL,'2023-02-20 16:35:14','2023-02-20 18:29:35','2023-02-20 18:29:35'),(1349,7566,444,40720,1533,3,68,1,203.54,NULL,'2023-02-20 16:35:14','2023-02-20 18:29:35','2023-02-20 18:29:35'),(1350,7566,444,40720,1533,3,57,2,2142.00,NULL,'2023-02-20 16:35:14','2023-02-20 18:29:35','2023-02-20 18:29:35'),(1351,7566,445,40720,1533,3,135,1,4436.05,NULL,'2023-02-20 17:37:25','2023-02-20 17:38:00','2023-02-20 17:38:00'),(1352,7566,445,40720,1533,3,68,1,931.57,NULL,'2023-02-20 17:37:25','2023-02-20 17:38:00','2023-02-20 17:38:00'),(1353,7566,445,40720,1533,3,135,1,13.32,NULL,'2023-02-20 17:37:25','2023-02-20 17:38:00','2023-02-20 17:38:00'),(1354,7566,445,40720,1533,3,220,1,133.21,NULL,'2023-02-20 17:37:25','2023-02-20 17:38:00','2023-02-20 17:38:00'),(1355,7566,445,40720,1533,3,241,1,222.68,NULL,'2023-02-20 17:37:25','2023-02-20 17:38:00','2023-02-20 17:38:00'),(1356,7566,445,40720,1533,3,57,2,5736.83,NULL,'2023-02-20 17:37:25','2023-02-20 17:38:00','2023-02-20 17:38:00'),(1357,7566,446,40720,1533,3,199,1,2727.27,NULL,'2023-02-20 17:37:48','2023-02-20 19:34:45','2023-02-20 19:34:45'),(1358,7566,446,40720,1533,3,68,1,572.73,NULL,'2023-02-20 17:37:48','2023-02-20 19:34:45','2023-02-20 19:34:45'),(1359,7566,446,40720,1533,3,57,2,3300.00,NULL,'2023-02-20 17:37:48','2023-02-20 19:34:45','2023-02-20 19:34:45'),(1360,7566,447,40720,1533,3,135,1,4436.05,NULL,'2023-02-20 17:38:00','2023-02-20 17:38:00',NULL),(1361,7566,447,40720,1533,3,68,1,931.57,NULL,'2023-02-20 17:38:00','2023-02-20 17:38:00',NULL),(1362,7566,447,40720,1533,3,135,1,13.32,NULL,'2023-02-20 17:38:00','2023-02-20 17:38:00',NULL),(1363,7566,447,40720,1533,3,220,1,133.21,NULL,'2023-02-20 17:38:00','2023-02-20 17:38:00',NULL),(1364,7566,447,40720,1533,3,241,1,222.68,NULL,'2023-02-20 17:38:00','2023-02-20 17:38:00',NULL),(1365,7566,447,40720,1533,3,57,2,5736.83,NULL,'2023-02-20 17:38:00','2023-02-20 17:38:00',NULL),(1366,7566,448,40720,1533,3,116,1,11250.00,NULL,'2023-02-20 17:38:35','2023-02-20 17:38:35',NULL),(1367,7566,448,40720,1533,3,57,2,11250.00,NULL,'2023-02-20 17:38:35','2023-02-20 17:38:35',NULL),(1368,7566,449,40720,1533,3,135,1,11752.07,NULL,'2023-02-20 17:41:13','2023-02-20 17:41:13',NULL),(1369,7566,449,40720,1533,3,68,1,2467.93,NULL,'2023-02-20 17:41:13','2023-02-20 17:41:13',NULL),(1370,7566,449,40720,1533,3,57,2,14220.00,NULL,'2023-02-20 17:41:13','2023-02-20 17:41:13',NULL),(1371,7566,450,40720,1533,3,135,1,3644.61,NULL,'2023-02-20 17:50:27','2023-02-20 17:50:55','2023-02-20 17:50:55'),(1372,7566,450,40720,1533,3,68,1,765.37,NULL,'2023-02-20 17:50:27','2023-02-20 17:50:55','2023-02-20 17:50:55');
INSERT INTO `balance_libro_details` VALUES (1373,7566,450,40720,1533,3,135,1,31.10,NULL,'2023-02-20 17:50:27','2023-02-20 17:50:55','2023-02-20 17:50:55'),(1374,7566,450,40720,1533,3,68,1,3.27,NULL,'2023-02-20 17:50:27','2023-02-20 17:50:55','2023-02-20 17:50:55'),(1375,7566,450,40720,1533,3,57,2,4444.35,NULL,'2023-02-20 17:50:27','2023-02-20 17:50:55','2023-02-20 17:50:55'),(1376,7566,451,40720,1533,3,135,1,3644.61,NULL,'2023-02-20 17:50:55','2023-02-20 17:50:55',NULL),(1377,7566,451,40720,1533,3,68,1,765.37,NULL,'2023-02-20 17:50:55','2023-02-20 17:50:55',NULL),(1378,7566,451,40720,1533,3,135,1,3110.41,NULL,'2023-02-20 17:50:55','2023-02-20 17:50:55',NULL),(1379,7566,451,40720,1533,3,68,1,326.59,NULL,'2023-02-20 17:50:55','2023-02-20 17:50:55',NULL),(1380,7566,451,40720,1533,3,57,2,7846.98,NULL,'2023-02-20 17:50:55','2023-02-20 17:50:55',NULL),(1381,7566,452,40720,1533,3,483,1,3347.30,NULL,'2023-02-20 17:55:09','2023-02-20 17:55:09',NULL),(1382,7566,452,40720,1533,3,68,1,702.93,NULL,'2023-02-20 17:55:09','2023-02-20 17:55:09',NULL),(1383,7566,452,40720,1533,3,57,2,4050.23,NULL,'2023-02-20 17:55:09','2023-02-20 17:55:09',NULL),(1384,7566,453,40720,1533,3,135,1,223.14,NULL,'2023-02-20 17:57:15','2023-02-20 17:57:15',NULL),(1385,7566,453,40720,1533,3,68,1,46.86,NULL,'2023-02-20 17:57:15','2023-02-20 17:57:15',NULL),(1386,7566,453,40720,1533,3,135,1,4998.19,NULL,'2023-02-20 17:57:15','2023-02-20 17:57:15',NULL),(1387,7566,453,40720,1533,3,68,1,524.81,NULL,'2023-02-20 17:57:15','2023-02-20 17:57:15',NULL),(1388,7566,453,40720,1533,3,57,2,5793.00,NULL,'2023-02-20 17:57:15','2023-02-20 17:57:15',NULL),(1389,7566,454,40720,1533,3,483,1,2181.82,NULL,'2023-02-20 17:58:14','2023-02-20 17:58:14',NULL),(1390,7566,454,40720,1533,3,68,1,458.18,NULL,'2023-02-20 17:58:14','2023-02-20 17:58:14',NULL),(1391,7566,454,40720,1533,3,57,2,2640.00,NULL,'2023-02-20 17:58:14','2023-02-20 17:58:14',NULL),(1392,7566,455,40720,1533,3,217,1,4030.50,NULL,'2023-02-20 18:03:11','2023-02-20 18:03:25','2023-02-20 18:03:25'),(1393,7566,455,40720,1533,3,68,1,846.41,NULL,'2023-02-20 18:03:11','2023-02-20 18:03:25','2023-02-20 18:03:25'),(1394,7566,455,40720,1533,3,217,1,41.16,NULL,'2023-02-20 18:03:11','2023-02-20 18:03:25','2023-02-20 18:03:25'),(1395,7566,455,40720,1533,3,220,1,120.92,NULL,'2023-02-20 18:03:11','2023-02-20 18:03:25','2023-02-20 18:03:25'),(1396,7566,455,40720,1533,3,57,2,5038.98,NULL,'2023-02-20 18:03:11','2023-02-20 18:03:25','2023-02-20 18:03:25'),(1397,7566,455,40720,1533,3,136,2,0.01,NULL,'2023-02-20 18:03:11','2023-02-20 18:03:25','2023-02-20 18:03:25'),(1398,7566,456,40720,1533,3,217,1,4030.50,NULL,'2023-02-20 18:03:25','2023-11-18 12:29:03','2023-11-18 12:29:03'),(1399,7566,456,40720,1533,3,68,1,846.41,NULL,'2023-02-20 18:03:25','2023-11-18 12:29:03','2023-11-18 12:29:03'),(1400,7566,456,40720,1533,3,217,1,41.16,NULL,'2023-02-20 18:03:25','2023-11-18 12:29:03','2023-11-18 12:29:03'),(1401,7566,456,40720,1533,3,220,1,120.92,NULL,'2023-02-20 18:03:25','2023-11-18 12:29:03','2023-11-18 12:29:03'),(1402,7566,456,40720,1533,3,57,2,5038.98,NULL,'2023-02-20 18:03:25','2023-11-18 12:29:03','2023-11-18 12:29:03'),(1403,7566,456,40720,1533,3,136,2,0.01,NULL,'2023-02-20 18:03:25','2023-11-18 12:29:03','2023-11-18 12:29:03'),(1404,7566,457,40720,1533,3,135,1,1214.88,NULL,'2023-02-20 18:05:59','2023-02-20 18:05:59',NULL),(1405,7566,457,40720,1533,3,68,1,255.12,NULL,'2023-02-20 18:05:59','2023-02-20 18:05:59',NULL),(1406,7566,457,40720,1533,3,57,2,1470.00,NULL,'2023-02-20 18:05:59','2023-02-20 18:05:59',NULL),(1407,7566,458,40720,1533,3,483,1,1818.18,NULL,'2023-02-20 18:07:33','2023-02-20 18:07:33',NULL),(1408,7566,458,40720,1533,3,68,1,381.82,NULL,'2023-02-20 18:07:33','2023-02-20 18:07:33',NULL),(1409,7566,458,40720,1533,3,57,2,2200.00,NULL,'2023-02-20 18:07:33','2023-02-20 18:07:33',NULL),(1410,7566,459,40720,1533,3,135,1,2443.28,NULL,'2023-02-20 18:11:56','2023-02-20 18:11:56',NULL),(1411,7566,459,40720,1533,3,68,1,256.54,NULL,'2023-02-20 18:11:56','2023-02-20 18:11:56',NULL);
INSERT INTO `balance_libro_details` VALUES (1412,7566,459,40720,1533,3,57,2,2699.82,NULL,'2023-02-20 18:11:56','2023-02-20 18:11:56',NULL),(1413,7566,460,40720,1533,3,217,1,1764.04,NULL,'2023-02-20 18:17:14','2023-11-18 12:32:11','2023-11-18 12:32:11'),(1414,7566,460,40720,1533,3,68,1,370.45,NULL,'2023-02-20 18:17:14','2023-11-18 12:32:11','2023-11-18 12:32:11'),(1415,7566,460,40720,1533,3,217,1,5271.88,NULL,'2023-02-20 18:17:14','2023-11-18 12:32:11','2023-11-18 12:32:11'),(1416,7566,460,40720,1533,3,68,1,553.55,NULL,'2023-02-20 18:17:14','2023-11-18 12:32:11','2023-11-18 12:32:11'),(1417,7566,460,40720,1533,3,217,1,2796.06,NULL,'2023-02-20 18:17:14','2023-11-18 12:32:11','2023-11-18 12:32:11'),(1418,7566,460,40720,1533,3,241,1,49.46,NULL,'2023-02-20 18:17:14','2023-11-18 12:32:11','2023-11-18 12:32:11'),(1419,7566,460,40720,1533,3,57,2,10805.44,NULL,'2023-02-20 18:17:14','2023-11-18 12:32:11','2023-11-18 12:32:11'),(1420,7566,461,40720,1533,3,217,1,2606.64,NULL,'2023-02-20 18:19:10','2023-11-18 12:32:00','2023-11-18 12:32:00'),(1421,7566,461,40720,1533,3,68,1,547.39,NULL,'2023-02-20 18:19:10','2023-11-18 12:32:00','2023-11-18 12:32:00'),(1422,7566,461,40720,1533,3,217,1,8937.99,NULL,'2023-02-20 18:19:10','2023-11-18 12:32:00','2023-11-18 12:32:00'),(1423,7566,461,40720,1533,3,68,1,938.49,NULL,'2023-02-20 18:19:10','2023-11-18 12:32:00','2023-11-18 12:32:00'),(1424,7566,461,40720,1533,3,217,1,3274.50,NULL,'2023-02-20 18:19:10','2023-11-18 12:32:00','2023-11-18 12:32:00'),(1425,7566,461,40720,1533,3,241,1,75.33,NULL,'2023-02-20 18:19:10','2023-11-18 12:32:00','2023-11-18 12:32:00'),(1426,7566,461,40720,1533,3,57,2,16380.34,NULL,'2023-02-20 18:19:10','2023-11-18 12:32:00','2023-11-18 12:32:00'),(1427,7566,462,40720,1533,3,483,1,1305.79,NULL,'2023-02-20 18:19:45','2023-02-20 18:19:45',NULL),(1428,7566,462,40720,1533,3,68,1,274.22,NULL,'2023-02-20 18:19:45','2023-02-20 18:19:45',NULL),(1429,7566,462,40720,1533,3,57,2,1580.01,NULL,'2023-02-20 18:19:45','2023-02-20 18:19:45',NULL),(1430,7566,463,40720,1533,3,482,1,1818.18,NULL,'2023-02-20 18:23:17','2023-02-20 18:23:17',NULL),(1431,7566,463,40720,1533,3,68,1,381.82,NULL,'2023-02-20 18:23:17','2023-02-20 18:23:17',NULL),(1432,7566,463,40720,1533,3,57,2,2200.00,NULL,'2023-02-20 18:23:17','2023-02-20 18:23:17',NULL),(1433,7566,464,40720,1533,3,135,1,223.14,NULL,'2023-02-20 18:24:32','2023-02-20 18:24:32',NULL),(1434,7566,464,40720,1533,3,68,1,46.86,NULL,'2023-02-20 18:24:32','2023-02-20 18:24:32',NULL),(1435,7566,464,40720,1533,3,135,1,3538.46,NULL,'2023-02-20 18:24:32','2023-02-20 18:24:32',NULL),(1436,7566,464,40720,1533,3,68,1,371.54,NULL,'2023-02-20 18:24:32','2023-02-20 18:24:32',NULL),(1437,7566,464,40720,1533,3,57,2,4180.00,NULL,'2023-02-20 18:24:32','2023-02-20 18:24:32',NULL),(1438,7566,465,40720,1533,3,217,1,6090.91,NULL,'2023-02-20 18:27:02','2023-11-18 12:33:19','2023-11-18 12:33:19'),(1439,7566,465,40720,1533,3,68,1,1279.09,NULL,'2023-02-20 18:27:02','2023-11-18 12:33:19','2023-11-18 12:33:19'),(1440,7566,465,40720,1533,3,57,2,7370.00,NULL,'2023-02-20 18:27:02','2023-11-18 12:33:19','2023-11-18 12:33:19'),(1441,7566,466,40720,1533,3,135,1,3065.02,NULL,'2023-02-20 18:28:44','2023-02-20 18:28:44',NULL),(1442,7566,466,40720,1533,3,68,1,321.83,NULL,'2023-02-20 18:28:44','2023-02-20 18:28:44',NULL),(1443,7566,466,40720,1533,3,57,2,3386.85,NULL,'2023-02-20 18:28:44','2023-02-20 18:28:44',NULL),(1444,7566,467,40720,1533,3,135,1,1938.46,NULL,'2023-02-20 18:29:35','2023-02-20 18:29:35',NULL),(1445,7566,467,40720,1533,3,68,1,203.54,NULL,'2023-02-20 18:29:35','2023-02-20 18:29:35',NULL),(1446,7566,467,40720,1533,3,57,2,2142.00,NULL,'2023-02-20 18:29:35','2023-02-20 18:29:35',NULL),(1447,7566,468,40720,1533,3,217,1,5461.16,NULL,'2023-02-20 18:31:21','2023-02-20 18:31:39','2023-02-20 18:31:39'),(1448,7566,468,40720,1533,3,68,1,1146.84,NULL,'2023-02-20 18:31:21','2023-02-20 18:31:39','2023-02-20 18:31:39'),(1449,7566,468,40720,1533,3,57,2,6608.00,NULL,'2023-02-20 18:31:21','2023-02-20 18:31:39','2023-02-20 18:31:39');
INSERT INTO `balance_libro_details` VALUES (1450,7566,469,40720,1533,3,135,1,5461.16,NULL,'2023-02-20 18:31:39','2023-02-20 18:31:39',NULL),(1451,7566,469,40720,1533,3,68,1,1146.84,NULL,'2023-02-20 18:31:39','2023-02-20 18:31:39',NULL),(1452,7566,469,40720,1533,3,57,2,6608.00,NULL,'2023-02-20 18:31:39','2023-02-20 18:31:39',NULL),(1453,7566,470,40720,1533,3,135,1,5743.80,NULL,'2023-02-20 18:44:02','2023-02-20 18:44:02',NULL),(1454,7566,470,40720,1533,3,68,1,1206.20,NULL,'2023-02-20 18:44:02','2023-02-20 18:44:02',NULL),(1455,7566,470,40720,1533,3,57,2,6950.00,NULL,'2023-02-20 18:44:02','2023-02-20 18:44:02',NULL),(1456,7566,471,40720,1533,3,482,1,38350.00,NULL,'2023-02-20 19:00:21','2023-02-20 19:02:22','2023-02-20 19:02:22'),(1457,7566,471,40720,1533,3,68,1,8053.50,NULL,'2023-02-20 19:00:21','2023-02-20 19:02:22','2023-02-20 19:02:22'),(1458,7566,471,40720,1533,3,57,2,46403.50,NULL,'2023-02-20 19:00:21','2023-02-20 19:02:22','2023-02-20 19:02:22'),(1459,7566,472,40720,1533,3,482,1,22100.00,NULL,'2023-02-20 19:00:57','2023-02-20 19:01:57','2023-02-20 19:01:57'),(1460,7566,472,40720,1533,3,68,1,4641.00,NULL,'2023-02-20 19:00:57','2023-02-20 19:01:57','2023-02-20 19:01:57'),(1461,7566,472,40720,1533,3,57,2,26741.00,NULL,'2023-02-20 19:00:57','2023-02-20 19:01:57','2023-02-20 19:01:57'),(1462,7566,473,40720,1533,3,482,1,36000.00,NULL,'2023-02-20 19:01:33','2023-02-20 19:01:33',NULL),(1463,7566,473,40720,1533,3,68,1,7560.00,NULL,'2023-02-20 19:01:33','2023-02-20 19:01:33',NULL),(1464,7566,473,40720,1533,3,57,2,43560.00,NULL,'2023-02-20 19:01:33','2023-02-20 19:01:33',NULL),(1465,7566,474,40720,1533,3,482,1,22100.00,NULL,'2023-02-20 19:01:57','2023-02-20 19:01:57',NULL),(1466,7566,474,40720,1533,3,68,1,4641.00,NULL,'2023-02-20 19:01:57','2023-02-20 19:01:57',NULL),(1467,7566,474,40720,1533,3,57,2,26741.00,NULL,'2023-02-20 19:01:57','2023-02-20 19:01:57',NULL),(1468,7566,475,40720,1533,3,482,1,38350.00,NULL,'2023-02-20 19:02:22','2023-02-20 19:02:22',NULL),(1469,7566,475,40720,1533,3,68,1,8053.50,NULL,'2023-02-20 19:02:22','2023-02-20 19:02:22',NULL),(1470,7566,475,40720,1533,3,57,2,46403.50,NULL,'2023-02-20 19:02:22','2023-02-20 19:02:22',NULL),(1471,7566,476,40720,1533,3,135,1,1983.47,NULL,'2023-02-20 19:05:35','2023-02-20 19:05:35',NULL),(1472,7566,476,40720,1533,3,68,1,416.53,NULL,'2023-02-20 19:05:35','2023-02-20 19:05:35',NULL),(1473,7566,476,40720,1533,3,57,2,2400.00,NULL,'2023-02-20 19:05:35','2023-02-20 19:05:35',NULL),(1474,7566,477,40720,1533,3,135,1,2148.76,NULL,'2023-02-20 19:05:59','2023-02-20 19:05:59',NULL),(1475,7566,477,40720,1533,3,68,1,451.24,NULL,'2023-02-20 19:05:59','2023-02-20 19:05:59',NULL),(1476,7566,477,40720,1533,3,57,2,2600.00,NULL,'2023-02-20 19:05:59','2023-02-20 19:05:59',NULL),(1477,7566,478,40720,1533,3,135,1,4876.03,NULL,'2023-02-20 19:08:08','2023-02-20 19:08:08',NULL),(1478,7566,478,40720,1533,3,68,1,1023.97,NULL,'2023-02-20 19:08:08','2023-02-20 19:08:08',NULL),(1479,7566,478,40720,1533,3,57,2,5900.00,NULL,'2023-02-20 19:08:08','2023-02-20 19:08:08',NULL),(1480,7566,479,40720,1533,3,135,1,3074.38,NULL,'2023-02-20 19:08:52','2023-02-20 19:08:52',NULL),(1481,7566,479,40720,1533,3,68,1,645.62,NULL,'2023-02-20 19:08:52','2023-02-20 19:08:52',NULL),(1482,7566,479,40720,1533,3,57,2,3720.00,NULL,'2023-02-20 19:08:52','2023-02-20 19:08:52',NULL),(1483,7566,480,40720,1533,3,484,1,6152.31,NULL,'2023-02-20 19:09:49','2023-02-20 19:10:26','2023-02-20 19:10:26'),(1484,7566,480,40720,1533,3,68,1,1291.99,NULL,'2023-02-20 19:09:49','2023-02-20 19:10:26','2023-02-20 19:10:26'),(1485,7566,480,40720,1533,3,239,1,62.06,NULL,'2023-02-20 19:09:49','2023-02-20 19:10:26','2023-02-20 19:10:26'),(1486,7566,480,40720,1533,3,57,2,7506.36,NULL,'2023-02-20 19:09:49','2023-02-20 19:10:26','2023-02-20 19:10:26'),(1487,7566,481,40720,1533,3,484,1,6152.31,NULL,'2023-02-20 19:10:26','2023-02-20 19:10:26',NULL),(1488,7566,481,40720,1533,3,68,1,1291.99,NULL,'2023-02-20 19:10:26','2023-02-20 19:10:26',NULL);
INSERT INTO `balance_libro_details` VALUES (1489,7566,481,40720,1533,3,484,1,56.10,NULL,'2023-02-20 19:10:26','2023-02-20 19:10:26',NULL),(1490,7566,481,40720,1533,3,239,1,62.08,NULL,'2023-02-20 19:10:26','2023-02-20 19:10:26',NULL),(1491,7566,481,40720,1533,3,57,2,7562.48,NULL,'2023-02-20 19:10:26','2023-02-20 19:10:26',NULL),(1492,7566,482,40720,1533,3,484,1,5741.44,NULL,'2023-02-20 19:11:29','2023-02-20 19:11:29',NULL),(1493,7566,482,40720,1533,3,68,1,1205.70,NULL,'2023-02-20 19:11:29','2023-02-20 19:11:29',NULL),(1494,7566,482,40720,1533,3,484,1,55.01,NULL,'2023-02-20 19:11:29','2023-02-20 19:11:29',NULL),(1495,7566,482,40720,1533,3,57,2,7002.15,NULL,'2023-02-20 19:11:29','2023-02-20 19:11:29',NULL),(1496,7566,483,40720,1533,3,484,1,2541.36,NULL,'2023-02-20 19:13:16','2023-02-20 19:13:16',NULL),(1497,7566,483,40720,1533,3,68,1,533.69,NULL,'2023-02-20 19:13:16','2023-02-20 19:13:16',NULL),(1498,7566,483,40720,1533,3,484,1,25.05,NULL,'2023-02-20 19:13:16','2023-02-20 19:13:16',NULL),(1499,7566,483,40720,1533,3,241,1,25.41,NULL,'2023-02-20 19:13:16','2023-02-20 19:13:16',NULL),(1500,7566,483,40720,1533,3,57,2,3125.51,NULL,'2023-02-20 19:13:16','2023-02-20 19:13:16',NULL),(1501,7566,484,40720,1533,3,484,1,3327.19,NULL,'2023-02-20 19:14:54','2023-02-20 19:14:54',NULL),(1502,7566,484,40720,1533,3,68,1,698.71,NULL,'2023-02-20 19:14:54','2023-02-20 19:14:54',NULL),(1503,7566,484,40720,1533,3,484,1,1324.10,NULL,'2023-02-20 19:14:54','2023-02-20 19:14:54',NULL),(1504,7566,484,40720,1533,3,241,1,33.27,NULL,'2023-02-20 19:14:54','2023-02-20 19:14:54',NULL),(1505,7566,484,40720,1533,3,57,2,5383.27,NULL,'2023-02-20 19:14:54','2023-02-20 19:14:54',NULL),(1506,7566,485,40720,1533,3,199,1,2727.27,NULL,'2023-02-20 19:34:45','2023-02-20 19:34:45',NULL),(1507,7566,485,40720,1533,3,68,1,572.73,NULL,'2023-02-20 19:34:45','2023-02-20 19:34:45',NULL),(1508,7566,485,40720,1533,3,57,2,3300.00,NULL,'2023-02-20 19:34:45','2023-02-20 19:34:45',NULL),(1509,7566,486,40720,1534,2,96,2,135070.95,NULL,'2023-03-19 11:52:53','2023-03-19 11:52:53',NULL),(1510,7566,486,40720,1534,2,67,2,28364.90,NULL,'2023-03-19 11:52:53','2023-03-19 11:52:53',NULL),(1511,7566,486,40720,1534,2,13,1,163435.85,NULL,'2023-03-19 11:52:53','2023-03-19 11:52:53',NULL),(1512,7566,487,40720,1534,2,96,2,162113.79,NULL,'2023-03-19 11:52:53','2023-03-19 11:52:53',NULL),(1513,7566,487,40720,1534,2,67,2,34043.90,NULL,'2023-03-19 11:52:53','2023-03-19 11:52:53',NULL),(1514,7566,487,40720,1534,2,13,1,196157.69,NULL,'2023-03-19 11:52:53','2023-03-19 11:52:53',NULL),(1515,7566,488,40720,1534,2,96,2,3987.27,NULL,'2023-03-19 11:52:53','2023-03-19 11:52:53',NULL),(1516,7566,488,40720,1534,2,67,2,837.33,NULL,'2023-03-19 11:52:53','2023-03-19 11:52:53',NULL),(1517,7566,488,40720,1534,2,13,1,4824.60,NULL,'2023-03-19 11:52:53','2023-03-19 11:52:53',NULL),(1518,7566,489,40720,1534,2,96,2,7740.37,NULL,'2023-03-19 11:52:53','2023-03-19 11:52:53',NULL),(1519,7566,489,40720,1534,2,67,2,1625.48,NULL,'2023-03-19 11:52:53','2023-03-19 11:52:53',NULL),(1520,7566,489,40720,1534,2,13,1,9365.85,NULL,'2023-03-19 11:52:53','2023-03-19 11:52:53',NULL),(1521,7566,490,40720,1534,2,96,2,242418.02,NULL,'2023-03-19 11:52:53','2023-03-19 11:52:53',NULL),(1522,7566,490,40720,1534,2,67,2,50907.78,NULL,'2023-03-19 11:52:53','2023-03-19 11:52:53',NULL),(1523,7566,490,40720,1534,2,13,1,293325.80,NULL,'2023-03-19 11:52:53','2023-03-19 11:52:53',NULL),(1524,7566,491,40720,1534,2,96,2,132681.70,NULL,'2023-03-19 11:52:53','2023-03-19 11:52:53',NULL),(1525,7566,491,40720,1534,2,67,2,27863.16,NULL,'2023-03-19 11:52:53','2023-03-19 11:52:53',NULL),(1526,7566,491,40720,1534,2,13,1,160544.86,NULL,'2023-03-19 11:52:53','2023-03-19 11:52:53',NULL),(1527,7566,492,40720,1534,3,250,1,0.00,NULL,'2023-03-19 11:54:23','2023-03-19 12:35:32','2023-03-19 12:35:32'),(1528,7566,492,40720,1534,3,250,1,16666.16,NULL,'2023-03-19 11:54:23','2023-03-19 12:35:32','2023-03-19 12:35:32'),(1529,7566,492,40720,1534,3,57,2,16666.16,NULL,'2023-03-19 11:54:23','2023-03-19 12:35:32','2023-03-19 12:35:32');
INSERT INTO `balance_libro_details` VALUES (1530,7566,493,40720,1534,3,199,1,2727.27,NULL,'2023-03-19 11:54:24','2023-03-19 13:17:38','2023-03-19 13:17:38'),(1531,7566,493,40720,1534,3,68,1,572.73,NULL,'2023-03-19 11:54:24','2023-03-19 13:17:38','2023-03-19 13:17:38'),(1532,7566,493,40720,1534,3,57,2,3300.00,NULL,'2023-03-19 11:54:24','2023-03-19 13:17:38','2023-03-19 13:17:38'),(1533,7566,494,40720,1534,3,116,1,11250.00,NULL,'2023-03-19 11:54:24','2023-03-19 12:41:57','2023-03-19 12:41:57'),(1534,7566,494,40720,1534,3,57,2,11250.00,NULL,'2023-03-19 11:54:24','2023-03-19 12:41:57','2023-03-19 12:41:57'),(1535,7566,495,40720,1534,3,483,1,2438.02,NULL,'2023-03-19 11:54:24','2023-03-19 11:54:24',NULL),(1536,7566,495,40720,1534,3,68,1,511.98,NULL,'2023-03-19 11:54:24','2023-03-19 11:54:24',NULL),(1537,7566,495,40720,1534,3,57,2,2950.00,NULL,'2023-03-19 11:54:24','2023-03-19 11:54:24',NULL),(1538,7566,496,40720,1534,3,483,1,3305.79,NULL,'2023-03-19 11:54:24','2023-03-19 11:54:24',NULL),(1539,7566,496,40720,1534,3,68,1,694.21,NULL,'2023-03-19 11:54:24','2023-03-19 11:54:24',NULL),(1540,7566,496,40720,1534,3,57,2,4000.00,NULL,'2023-03-19 11:54:24','2023-03-19 11:54:24',NULL),(1541,7566,497,40720,1534,3,193,1,3618.47,NULL,'2023-03-19 11:54:24','2023-03-19 13:16:17','2023-03-19 13:16:17'),(1542,7566,497,40720,1534,3,68,1,842.77,NULL,'2023-03-19 11:54:24','2023-03-19 13:16:17','2023-03-19 13:16:17'),(1543,7566,497,40720,1534,3,193,1,365.82,NULL,'2023-03-19 11:54:24','2023-03-19 13:16:17','2023-03-19 13:16:17'),(1544,7566,497,40720,1534,3,57,2,4827.06,NULL,'2023-03-19 11:54:24','2023-03-19 13:16:17','2023-03-19 13:16:17'),(1545,7566,498,40720,1534,3,135,1,2940.71,NULL,'2023-03-19 11:54:24','2023-03-19 13:14:59','2023-03-19 13:14:59'),(1546,7566,498,40720,1534,3,68,1,308.77,NULL,'2023-03-19 11:54:24','2023-03-19 13:14:59','2023-03-19 13:14:59'),(1547,7566,498,40720,1534,3,57,2,3249.48,NULL,'2023-03-19 11:54:24','2023-03-19 13:14:59','2023-03-19 13:14:59'),(1548,7566,499,40720,1534,3,483,1,3140.50,NULL,'2023-03-19 11:54:24','2023-03-19 11:54:24',NULL),(1549,7566,499,40720,1534,3,68,1,659.50,NULL,'2023-03-19 11:54:24','2023-03-19 11:54:24',NULL),(1550,7566,499,40720,1534,3,57,2,3800.00,NULL,'2023-03-19 11:54:24','2023-03-19 11:54:24',NULL),(1551,7566,500,40720,1534,3,217,1,2479.34,NULL,'2023-03-19 11:54:24','2023-03-19 13:08:09','2023-03-19 13:08:09'),(1552,7566,500,40720,1534,3,68,1,520.66,NULL,'2023-03-19 11:54:24','2023-03-19 13:08:09','2023-03-19 13:08:09'),(1553,7566,500,40720,1534,3,57,2,3000.00,NULL,'2023-03-19 11:54:24','2023-03-19 13:08:09','2023-03-19 13:08:09'),(1554,7566,501,40720,1534,3,217,1,2396.69,NULL,'2023-03-19 11:54:24','2023-03-19 12:45:21','2023-03-19 12:45:21'),(1555,7566,501,40720,1534,3,68,1,503.31,NULL,'2023-03-19 11:54:24','2023-03-19 12:45:21','2023-03-19 12:45:21'),(1556,7566,501,40720,1534,3,57,2,2900.00,NULL,'2023-03-19 11:54:24','2023-03-19 12:45:21','2023-03-19 12:45:21'),(1557,7566,502,40720,1534,3,483,1,2181.82,NULL,'2023-03-19 11:54:24','2023-03-19 11:54:24',NULL),(1558,7566,502,40720,1534,3,68,1,458.18,NULL,'2023-03-19 11:54:24','2023-03-19 11:54:24',NULL),(1559,7566,502,40720,1534,3,57,2,2640.00,NULL,'2023-03-19 11:54:24','2023-03-19 11:54:24',NULL),(1560,7566,503,40720,1534,3,217,1,4925.62,NULL,'2023-03-19 11:54:24','2023-03-19 12:45:33','2023-03-19 12:45:33'),(1561,7566,503,40720,1534,3,68,1,1034.38,NULL,'2023-03-19 11:54:24','2023-03-19 12:45:33','2023-03-19 12:45:33'),(1562,7566,503,40720,1534,3,57,2,5960.00,NULL,'2023-03-19 11:54:24','2023-03-19 12:45:33','2023-03-19 12:45:33'),(1563,7566,504,40720,1534,3,135,1,13074.38,NULL,'2023-03-19 11:54:24','2023-03-19 12:45:46','2023-03-19 12:45:46'),(1564,7566,504,40720,1534,3,68,1,2745.62,NULL,'2023-03-19 11:54:24','2023-03-19 12:45:46','2023-03-19 12:45:46'),(1565,7566,504,40720,1534,3,57,2,15820.00,NULL,'2023-03-19 11:54:24','2023-03-19 12:45:46','2023-03-19 12:45:46'),(1566,7566,505,40720,1534,3,135,1,4734.36,NULL,'2023-03-19 11:54:24','2023-03-19 12:46:23','2023-03-19 12:46:23');
INSERT INTO `balance_libro_details` VALUES (1567,7566,505,40720,1534,3,68,1,497.11,NULL,'2023-03-19 11:54:24','2023-03-19 12:46:23','2023-03-19 12:46:23'),(1568,7566,505,40720,1534,3,57,2,5231.47,NULL,'2023-03-19 11:54:24','2023-03-19 12:46:23','2023-03-19 12:46:23'),(1569,7566,506,40720,1534,3,483,1,4562.00,NULL,'2023-03-19 11:54:24','2023-03-19 13:06:01','2023-03-19 13:06:01'),(1570,7566,506,40720,1534,3,68,1,958.02,NULL,'2023-03-19 11:54:24','2023-03-19 13:06:01','2023-03-19 13:06:01'),(1571,7566,506,40720,1534,3,57,2,5520.02,NULL,'2023-03-19 11:54:24','2023-03-19 13:06:01','2023-03-19 13:06:01'),(1572,7566,507,40720,1534,3,483,1,4562.00,NULL,'2023-03-19 11:54:24','2023-03-19 13:05:00','2023-03-19 13:05:00'),(1573,7566,507,40720,1534,3,68,1,958.02,NULL,'2023-03-19 11:54:24','2023-03-19 13:05:00','2023-03-19 13:05:00'),(1574,7566,507,40720,1534,3,57,2,5520.02,NULL,'2023-03-19 11:54:24','2023-03-19 13:05:00','2023-03-19 13:05:00'),(1575,7566,508,40720,1534,3,135,1,7819.62,NULL,'2023-03-19 11:54:24','2023-03-19 13:04:22','2023-03-19 13:04:22'),(1576,7566,508,40720,1534,3,68,1,1642.12,NULL,'2023-03-19 11:54:24','2023-03-19 13:04:22','2023-03-19 13:04:22'),(1577,7566,508,40720,1534,3,135,1,234.59,NULL,'2023-03-19 11:54:24','2023-03-19 13:04:22','2023-03-19 13:04:22'),(1578,7566,508,40720,1534,3,57,2,9696.33,NULL,'2023-03-19 11:54:24','2023-03-19 13:04:22','2023-03-19 13:04:22'),(1579,7566,509,40720,1534,3,483,1,2727.27,NULL,'2023-03-19 11:54:24','2023-03-19 11:54:24',NULL),(1580,7566,509,40720,1534,3,68,1,572.73,NULL,'2023-03-19 11:54:24','2023-03-19 11:54:24',NULL),(1581,7566,509,40720,1534,3,57,2,3300.00,NULL,'2023-03-19 11:54:24','2023-03-19 11:54:24',NULL),(1582,7566,510,40720,1534,3,217,1,11533.78,NULL,'2023-03-19 11:54:24','2023-03-19 13:03:07','2023-03-19 13:03:07'),(1583,7566,510,40720,1534,3,68,1,1459.28,NULL,'2023-03-19 11:54:24','2023-03-19 13:03:07','2023-03-19 13:03:07'),(1584,7566,510,40720,1534,3,217,1,797.78,NULL,'2023-03-19 11:54:24','2023-03-19 13:03:07','2023-03-19 13:03:07'),(1585,7566,510,40720,1534,3,57,2,13790.84,NULL,'2023-03-19 11:54:24','2023-03-19 13:03:07','2023-03-19 13:03:07'),(1586,7566,511,40720,1534,3,217,1,6371.90,NULL,'2023-03-19 11:54:24','2023-03-19 12:55:38','2023-03-19 12:55:38'),(1587,7566,511,40720,1534,3,68,1,1338.10,NULL,'2023-03-19 11:54:24','2023-03-19 12:55:38','2023-03-19 12:55:38'),(1588,7566,511,40720,1534,3,217,1,254.88,NULL,'2023-03-19 11:54:24','2023-03-19 12:55:38','2023-03-19 12:55:38'),(1589,7566,511,40720,1534,3,57,2,7964.88,NULL,'2023-03-19 11:54:24','2023-03-19 12:55:38','2023-03-19 12:55:38'),(1590,7566,512,40720,1534,3,483,1,1818.18,NULL,'2023-03-19 11:54:24','2023-03-19 11:54:24',NULL),(1591,7566,512,40720,1534,3,68,1,381.82,NULL,'2023-03-19 11:54:24','2023-03-19 11:54:24',NULL),(1592,7566,512,40720,1534,3,57,2,2200.00,NULL,'2023-03-19 11:54:24','2023-03-19 11:54:24',NULL),(1593,7566,513,40720,1534,3,135,1,2967.14,NULL,'2023-03-19 11:54:24','2023-03-19 12:46:40','2023-03-19 12:46:40'),(1594,7566,513,40720,1534,3,68,1,311.55,NULL,'2023-03-19 11:54:24','2023-03-19 12:46:40','2023-03-19 12:46:40'),(1595,7566,513,40720,1534,3,57,2,3278.69,NULL,'2023-03-19 11:54:24','2023-03-19 12:46:40','2023-03-19 12:46:40'),(1596,7566,514,40720,1534,3,135,1,29985.93,NULL,'2023-03-19 11:54:24','2023-03-19 12:46:58','2023-03-19 12:46:58'),(1597,7566,514,40720,1534,3,68,1,6297.04,NULL,'2023-03-19 11:54:24','2023-03-19 12:46:58','2023-03-19 12:46:58'),(1598,7566,514,40720,1534,3,135,1,1221.04,NULL,'2023-03-19 11:54:24','2023-03-19 12:46:58','2023-03-19 12:46:58'),(1599,7566,514,40720,1534,3,57,2,37504.01,NULL,'2023-03-19 11:54:24','2023-03-19 12:46:58','2023-03-19 12:46:58'),(1600,7566,515,40720,1534,3,483,1,2099.17,NULL,'2023-03-19 11:54:24','2023-03-19 12:44:46','2023-03-19 12:44:46'),(1601,7566,515,40720,1534,3,68,1,440.83,NULL,'2023-03-19 11:54:24','2023-03-19 12:44:46','2023-03-19 12:44:46'),(1602,7566,515,40720,1534,3,57,2,2540.00,NULL,'2023-03-19 11:54:24','2023-03-19 12:44:46','2023-03-19 12:44:46');
INSERT INTO `balance_libro_details` VALUES (1603,7566,516,40720,1534,3,483,1,5429.80,NULL,'2023-03-19 11:54:24','2023-03-19 12:52:18','2023-03-19 12:52:18'),(1604,7566,516,40720,1534,3,68,1,1140.26,NULL,'2023-03-19 11:54:24','2023-03-19 12:52:18','2023-03-19 12:52:18'),(1605,7566,516,40720,1534,3,57,2,6570.06,NULL,'2023-03-19 11:54:24','2023-03-19 12:52:18','2023-03-19 12:52:18'),(1606,7566,517,40720,1534,3,250,1,10500.00,NULL,'2023-03-19 11:54:24','2023-03-19 12:39:15','2023-03-19 12:39:15'),(1607,7566,517,40720,1534,3,57,2,10500.00,NULL,'2023-03-19 11:54:24','2023-03-19 12:39:15','2023-03-19 12:39:15'),(1608,7566,518,40720,1534,3,217,1,8925.62,NULL,'2023-03-19 11:54:24','2023-03-19 12:51:11','2023-03-19 12:51:11'),(1609,7566,518,40720,1534,3,68,1,1874.38,NULL,'2023-03-19 11:54:24','2023-03-19 12:51:11','2023-03-19 12:51:11'),(1610,7566,518,40720,1534,3,57,2,10800.00,NULL,'2023-03-19 11:54:24','2023-03-19 12:51:11','2023-03-19 12:51:11'),(1611,7566,519,40720,1534,3,250,1,7000.00,NULL,'2023-03-19 11:54:24','2023-03-19 12:41:16','2023-03-19 12:41:16'),(1612,7566,519,40720,1534,3,57,2,7000.00,NULL,'2023-03-19 11:54:24','2023-03-19 12:41:16','2023-03-19 12:41:16'),(1613,7566,520,40720,1534,3,217,1,412.31,NULL,'2023-03-19 11:54:24','2023-03-19 12:47:19','2023-03-19 12:47:19'),(1614,7566,520,40720,1534,3,68,1,86.59,NULL,'2023-03-19 11:54:24','2023-03-19 12:47:19','2023-03-19 12:47:19'),(1615,7566,520,40720,1534,3,57,2,498.90,NULL,'2023-03-19 11:54:24','2023-03-19 12:47:19','2023-03-19 12:47:19'),(1616,7566,521,40720,1534,3,217,1,5950.41,NULL,'2023-03-19 11:54:24','2023-03-19 12:48:32','2023-03-19 12:48:32'),(1617,7566,521,40720,1534,3,68,1,1249.59,NULL,'2023-03-19 11:54:24','2023-03-19 12:48:32','2023-03-19 12:48:32'),(1618,7566,521,40720,1534,3,57,2,7200.00,NULL,'2023-03-19 11:54:24','2023-03-19 12:48:32','2023-03-19 12:48:32'),(1619,7566,522,40720,1534,7,25,1,4395.30,NULL,'2023-03-19 11:58:38','2023-03-19 11:58:38',NULL),(1620,7566,522,40720,1534,7,13,2,4395.30,NULL,'2023-03-19 11:58:38','2023-03-19 11:58:38',NULL),(1621,7566,523,40720,1534,7,25,1,863.51,NULL,'2023-03-19 11:58:38','2023-03-19 11:58:38',NULL),(1622,7566,523,40720,1534,7,13,2,863.51,NULL,'2023-03-19 11:58:38','2023-03-19 11:58:38',NULL),(1623,7566,524,40720,1534,7,25,1,3132.16,NULL,'2023-03-19 11:58:38','2023-03-19 11:58:38',NULL),(1624,7566,524,40720,1534,7,13,2,3132.16,NULL,'2023-03-19 11:58:38','2023-03-19 11:58:38',NULL),(1625,7566,525,40720,1534,7,25,1,4309.12,NULL,'2023-03-19 11:58:38','2023-03-19 11:58:38',NULL),(1626,7566,525,40720,1534,7,13,2,4309.12,NULL,'2023-03-19 11:58:38','2023-03-19 11:58:38',NULL),(1627,7566,526,40720,1534,7,25,1,837.85,NULL,'2023-03-19 11:58:38','2023-03-19 11:58:38',NULL),(1628,7566,526,40720,1534,7,13,2,837.85,NULL,'2023-03-19 11:58:38','2023-03-19 11:58:38',NULL),(1629,7566,527,40720,1534,7,25,1,155.76,NULL,'2023-03-19 11:58:38','2023-03-19 11:58:38',NULL),(1630,7566,527,40720,1534,7,13,2,155.76,NULL,'2023-03-19 11:58:38','2023-03-19 11:58:38',NULL),(1631,7566,528,40720,1534,7,25,1,1210.15,NULL,'2023-03-19 11:58:38','2023-03-19 11:58:38',NULL),(1632,7566,528,40720,1534,7,13,2,1210.15,NULL,'2023-03-19 11:58:38','2023-03-19 11:58:38',NULL),(1633,7566,529,40720,1534,7,25,1,669.86,NULL,'2023-03-19 11:58:38','2023-03-19 11:58:38',NULL),(1634,7566,529,40720,1534,7,13,2,669.86,NULL,'2023-03-19 11:58:38','2023-03-19 11:58:38',NULL),(1635,7566,530,40720,1534,7,25,1,10651.05,NULL,'2023-03-19 11:58:38','2023-03-19 11:58:38',NULL),(1636,7566,530,40720,1534,7,13,2,10651.05,NULL,'2023-03-19 11:58:38','2023-03-19 11:58:38',NULL),(1637,7566,531,40720,1534,7,25,1,2633.51,NULL,'2023-03-19 11:58:38','2023-03-19 11:58:38',NULL),(1638,7566,531,40720,1534,7,13,2,2633.51,NULL,'2023-03-19 11:58:38','2023-03-19 11:58:38',NULL),(1639,7566,532,40720,1534,7,25,1,1170.16,NULL,'2023-03-19 11:58:38','2023-03-19 11:58:38',NULL),(1640,7566,532,40720,1534,7,13,2,1170.16,NULL,'2023-03-19 11:58:38','2023-03-19 11:58:38',NULL);
INSERT INTO `balance_libro_details` VALUES (1641,7566,533,40720,1534,8,290,1,100.57,NULL,'2023-03-19 12:09:24','2023-03-19 12:09:24',NULL),(1642,7566,533,40720,1534,8,351,2,100.57,NULL,'2023-03-19 12:09:24','2023-03-19 12:09:24',NULL),(1643,7566,534,40720,1534,3,135,1,10500.00,NULL,'2023-03-19 12:39:15','2023-03-19 12:51:26','2023-03-19 12:51:26'),(1644,7566,534,40720,1534,3,57,2,10500.00,NULL,'2023-03-19 12:39:15','2023-03-19 12:51:26','2023-03-19 12:51:26'),(1645,7566,535,40720,1534,3,250,1,7000.00,NULL,'2023-03-19 12:41:16','2023-03-19 12:50:08','2023-03-19 12:50:08'),(1646,7566,535,40720,1534,3,57,2,7000.00,NULL,'2023-03-19 12:41:16','2023-03-19 12:50:08','2023-03-19 12:50:08'),(1647,7566,536,40720,1534,3,116,1,11250.00,NULL,'2023-03-19 12:41:57','2023-03-19 12:41:57',NULL),(1648,7566,536,40720,1534,3,57,2,11250.00,NULL,'2023-03-19 12:41:57','2023-03-19 12:41:57',NULL),(1649,7566,537,40720,1534,3,483,1,2099.17,NULL,'2023-03-19 12:44:46','2023-03-19 12:52:50','2023-03-19 12:52:50'),(1650,7566,537,40720,1534,3,68,1,440.83,NULL,'2023-03-19 12:44:46','2023-03-19 12:52:50','2023-03-19 12:52:50'),(1651,7566,537,40720,1534,3,57,2,2540.00,NULL,'2023-03-19 12:44:46','2023-03-19 12:52:50','2023-03-19 12:52:50'),(1652,7566,538,40720,1534,3,483,1,5950.41,NULL,'2023-03-19 12:48:32','2023-03-19 12:48:32',NULL),(1653,7566,538,40720,1534,3,68,1,1249.59,NULL,'2023-03-19 12:48:32','2023-03-19 12:48:32',NULL),(1654,7566,538,40720,1534,3,57,2,7200.00,NULL,'2023-03-19 12:48:32','2023-03-19 12:48:32',NULL),(1655,7566,539,40720,1534,3,483,1,8925.62,NULL,'2023-03-19 12:51:11','2023-03-19 12:51:11',NULL),(1656,7566,539,40720,1534,3,68,1,1874.38,NULL,'2023-03-19 12:51:11','2023-03-19 12:51:11',NULL),(1657,7566,539,40720,1534,3,57,2,10800.00,NULL,'2023-03-19 12:51:11','2023-03-19 12:51:11',NULL),(1658,7566,540,40720,1534,3,483,1,5429.80,NULL,'2023-03-19 12:52:18','2023-03-19 12:52:18',NULL),(1659,7566,540,40720,1534,3,68,1,1140.26,NULL,'2023-03-19 12:52:18','2023-03-19 12:52:18',NULL),(1660,7566,540,40720,1534,3,57,2,6570.06,NULL,'2023-03-19 12:52:18','2023-03-19 12:52:18',NULL),(1661,7566,541,40720,1534,3,483,1,2099.17,NULL,'2023-03-19 12:52:50','2023-03-19 12:52:50',NULL),(1662,7566,541,40720,1534,3,68,1,440.83,NULL,'2023-03-19 12:52:50','2023-03-19 12:52:50',NULL),(1663,7566,541,40720,1534,3,57,2,2540.00,NULL,'2023-03-19 12:52:50','2023-03-19 12:52:50',NULL),(1664,7566,542,40720,1534,3,217,1,1381.47,NULL,'2023-03-19 12:55:38','2023-03-19 12:57:05','2023-03-19 12:57:05'),(1665,7566,542,40720,1534,3,68,1,373.00,NULL,'2023-03-19 12:55:38','2023-03-19 12:57:05','2023-03-19 12:57:05'),(1666,7566,542,40720,1534,3,217,1,2237.00,NULL,'2023-03-19 12:55:38','2023-03-19 12:57:05','2023-03-19 12:57:05'),(1667,7566,542,40720,1534,3,68,1,469.77,NULL,'2023-03-19 12:55:38','2023-03-19 12:57:05','2023-03-19 12:57:05'),(1668,7566,542,40720,1534,3,217,1,72.71,NULL,'2023-03-19 12:55:38','2023-03-19 12:57:05','2023-03-19 12:57:05'),(1669,7566,542,40720,1534,3,220,1,108.55,NULL,'2023-03-19 12:55:38','2023-03-19 12:57:05','2023-03-19 12:57:05'),(1670,7566,542,40720,1534,3,241,1,184.56,NULL,'2023-03-19 12:55:38','2023-03-19 12:57:05','2023-03-19 12:57:05'),(1671,7566,542,40720,1534,3,57,2,4827.06,NULL,'2023-03-19 12:55:38','2023-03-19 12:57:05','2023-03-19 12:57:05'),(1672,7566,543,40720,1534,3,199,1,5516.53,NULL,'2023-03-19 13:00:12','2023-03-19 16:02:56','2023-03-19 16:02:56'),(1673,7566,543,40720,1534,3,68,1,1158.47,NULL,'2023-03-19 13:00:12','2023-03-19 16:02:56','2023-03-19 16:02:56'),(1674,7566,543,40720,1534,3,220,1,165.50,NULL,'2023-03-19 13:00:12','2023-03-19 16:02:56','2023-03-19 16:02:56'),(1675,7566,543,40720,1534,3,241,1,55.17,NULL,'2023-03-19 13:00:12','2023-03-19 16:02:56','2023-03-19 16:02:56'),(1676,7566,543,40720,1534,3,57,2,6895.67,NULL,'2023-03-19 13:00:12','2023-03-19 16:02:56','2023-03-19 16:02:56'),(1677,7566,544,40720,1534,3,217,1,2364.14,NULL,'2023-03-19 13:03:07','2023-03-19 15:47:44','2023-03-19 15:47:44');
INSERT INTO `balance_libro_details` VALUES (1678,7566,544,40720,1534,3,68,1,496.47,NULL,'2023-03-19 13:03:07','2023-03-19 15:47:44','2023-03-19 15:47:44'),(1679,7566,544,40720,1534,3,217,1,9169.64,NULL,'2023-03-19 13:03:07','2023-03-19 15:47:44','2023-03-19 15:47:44'),(1680,7566,544,40720,1534,3,68,1,962.81,NULL,'2023-03-19 13:03:07','2023-03-19 15:47:44','2023-03-19 15:47:44'),(1681,7566,544,40720,1534,3,217,1,12.02,NULL,'2023-03-19 13:03:07','2023-03-19 15:47:44','2023-03-19 15:47:44'),(1682,7566,544,40720,1534,3,220,1,208.47,NULL,'2023-03-19 13:03:07','2023-03-19 15:47:44','2023-03-19 15:47:44'),(1683,7566,544,40720,1534,3,241,1,577.29,NULL,'2023-03-19 13:03:07','2023-03-19 15:47:44','2023-03-19 15:47:44'),(1684,7566,544,40720,1534,3,57,2,13790.84,NULL,'2023-03-19 13:03:07','2023-03-19 15:47:44','2023-03-19 15:47:44'),(1685,7566,545,40720,1534,3,135,1,7819.62,NULL,'2023-03-19 13:04:22','2023-03-19 13:04:22',NULL),(1686,7566,545,40720,1534,3,68,1,1642.12,NULL,'2023-03-19 13:04:22','2023-03-19 13:04:22',NULL),(1687,7566,545,40720,1534,3,220,1,234.59,NULL,'2023-03-19 13:04:22','2023-03-19 13:04:22',NULL),(1688,7566,545,40720,1534,3,57,2,9696.33,NULL,'2023-03-19 13:04:22','2023-03-19 13:04:22',NULL),(1689,7566,546,40720,1534,3,483,1,4562.00,NULL,'2023-03-19 13:05:00','2023-03-19 13:05:00',NULL),(1690,7566,546,40720,1534,3,68,1,958.02,NULL,'2023-03-19 13:05:00','2023-03-19 13:05:00',NULL),(1691,7566,546,40720,1534,3,57,2,5520.02,NULL,'2023-03-19 13:05:00','2023-03-19 13:05:00',NULL),(1692,7566,547,40720,1534,3,217,1,2479.34,NULL,'2023-03-19 13:08:09','2023-03-19 13:13:20','2023-03-19 13:13:20'),(1693,7566,547,40720,1534,3,68,1,520.66,NULL,'2023-03-19 13:08:09','2023-03-19 13:13:20','2023-03-19 13:13:20'),(1694,7566,547,40720,1534,3,57,2,3000.00,NULL,'2023-03-19 13:08:09','2023-03-19 13:13:20','2023-03-19 13:13:20'),(1695,7566,548,40720,1534,3,115,1,2479.34,NULL,'2023-03-19 13:13:20','2023-03-19 13:13:20',NULL),(1696,7566,548,40720,1534,3,68,1,520.66,NULL,'2023-03-19 13:13:20','2023-03-19 13:13:20',NULL),(1697,7566,548,40720,1534,3,57,2,3000.00,NULL,'2023-03-19 13:13:20','2023-03-19 13:13:20',NULL),(1698,7566,549,40720,1534,3,135,1,2940.71,NULL,'2023-03-19 13:14:59','2023-03-19 13:14:59',NULL),(1699,7566,549,40720,1534,3,68,1,308.77,NULL,'2023-03-19 13:14:59','2023-03-19 13:14:59',NULL),(1700,7566,549,40720,1534,3,57,2,3249.48,NULL,'2023-03-19 13:14:59','2023-03-19 13:14:59',NULL),(1701,7566,550,40720,1534,3,193,1,1381.47,NULL,'2023-03-19 13:16:17','2023-03-19 16:04:06','2023-03-19 16:04:06'),(1702,7566,550,40720,1534,3,68,1,373.00,NULL,'2023-03-19 13:16:17','2023-03-19 16:04:06','2023-03-19 16:04:06'),(1703,7566,550,40720,1534,3,193,1,2237.00,NULL,'2023-03-19 13:16:17','2023-03-19 16:04:06','2023-03-19 16:04:06'),(1704,7566,550,40720,1534,3,68,1,469.77,NULL,'2023-03-19 13:16:17','2023-03-19 16:04:06','2023-03-19 16:04:06'),(1705,7566,550,40720,1534,3,193,1,72.71,NULL,'2023-03-19 13:16:17','2023-03-19 16:04:06','2023-03-19 16:04:06'),(1706,7566,550,40720,1534,3,220,1,108.55,NULL,'2023-03-19 13:16:17','2023-03-19 16:04:06','2023-03-19 16:04:06'),(1707,7566,550,40720,1534,3,241,1,184.56,NULL,'2023-03-19 13:16:17','2023-03-19 16:04:06','2023-03-19 16:04:06'),(1708,7566,550,40720,1534,3,57,2,4827.06,NULL,'2023-03-19 13:16:17','2023-03-19 16:04:06','2023-03-19 16:04:06'),(1709,7566,551,40720,1534,3,199,1,2727.27,NULL,'2023-03-19 13:17:38','2023-03-19 16:02:08','2023-03-19 16:02:08'),(1710,7566,551,40720,1534,3,68,1,572.73,NULL,'2023-03-19 13:17:38','2023-03-19 16:02:08','2023-03-19 16:02:08'),(1711,7566,551,40720,1534,3,57,2,3300.00,NULL,'2023-03-19 13:17:38','2023-03-19 16:02:08','2023-03-19 16:02:08'),(1712,7566,552,40720,1534,3,483,1,2066.12,NULL,'2023-03-19 13:20:49','2023-03-19 13:27:01','2023-03-19 13:27:01'),(1713,7566,552,40720,1534,3,68,1,433.89,NULL,'2023-03-19 13:20:49','2023-03-19 13:27:01','2023-03-19 13:27:01'),(1714,7566,552,40720,1534,3,57,2,2500.01,NULL,'2023-03-19 13:20:49','2023-03-19 13:27:01','2023-03-19 13:27:01');
INSERT INTO `balance_libro_details` VALUES (1715,7566,553,40720,1534,3,483,1,4132.23,NULL,'2023-03-19 13:21:17','2023-03-19 13:26:32','2023-03-19 13:26:32'),(1716,7566,553,40720,1534,3,68,1,867.77,NULL,'2023-03-19 13:21:17','2023-03-19 13:26:32','2023-03-19 13:26:32'),(1717,7566,553,40720,1534,3,57,2,5000.00,NULL,'2023-03-19 13:21:17','2023-03-19 13:26:32','2023-03-19 13:26:32'),(1718,7566,554,40720,1534,3,483,1,2148.76,NULL,'2023-03-19 13:21:47','2023-03-19 13:21:47',NULL),(1719,7566,554,40720,1534,3,68,1,451.24,NULL,'2023-03-19 13:21:47','2023-03-19 13:21:47',NULL),(1720,7566,554,40720,1534,3,57,2,2600.00,NULL,'2023-03-19 13:21:47','2023-03-19 13:21:47',NULL),(1721,7566,555,40720,1534,3,135,1,5272.73,NULL,'2023-03-19 13:24:18','2023-03-19 13:24:18',NULL),(1722,7566,555,40720,1534,3,68,1,1107.27,NULL,'2023-03-19 13:24:18','2023-03-19 13:24:18',NULL),(1723,7566,555,40720,1534,3,57,2,6380.00,NULL,'2023-03-19 13:24:18','2023-03-19 13:24:18',NULL),(1724,7566,556,40720,1534,3,484,1,6480.41,NULL,'2023-03-19 13:25:40','2023-03-19 13:25:40',NULL),(1725,7566,556,40720,1534,3,68,1,1360.89,NULL,'2023-03-19 13:25:40','2023-03-19 13:25:40',NULL),(1726,7566,556,40720,1534,3,484,1,59.09,NULL,'2023-03-19 13:25:40','2023-03-19 13:25:40',NULL),(1727,7566,556,40720,1534,3,239,1,65.40,NULL,'2023-03-19 13:25:40','2023-03-19 13:25:40',NULL),(1728,7566,556,40720,1534,3,57,2,7965.79,NULL,'2023-03-19 13:25:40','2023-03-19 13:25:40',NULL),(1729,7566,557,40720,1534,3,483,1,4132.23,NULL,'2023-03-19 13:26:32','2023-03-19 13:26:32',NULL),(1730,7566,557,40720,1534,3,68,1,867.77,NULL,'2023-03-19 13:26:32','2023-03-19 13:26:32',NULL),(1731,7566,557,40720,1534,3,57,2,5000.00,NULL,'2023-03-19 13:26:32','2023-03-19 13:26:32',NULL),(1732,7566,558,40720,1534,3,483,1,2066.12,NULL,'2023-03-19 13:27:01','2023-03-19 13:27:01',NULL),(1733,7566,558,40720,1534,3,68,1,433.89,NULL,'2023-03-19 13:27:01','2023-03-19 13:27:01',NULL),(1734,7566,558,40720,1534,3,57,2,2500.01,NULL,'2023-03-19 13:27:01','2023-03-19 13:27:01',NULL),(1735,7566,559,40720,1534,3,484,1,6068.11,NULL,'2023-03-19 13:28:24','2023-03-19 13:28:24',NULL),(1736,7566,559,40720,1534,3,68,1,1274.30,NULL,'2023-03-19 13:28:24','2023-03-19 13:28:24',NULL),(1737,7566,559,40720,1534,3,484,1,58.15,NULL,'2023-03-19 13:28:24','2023-03-19 13:28:24',NULL),(1738,7566,559,40720,1534,3,57,2,7400.56,NULL,'2023-03-19 13:28:24','2023-03-19 13:28:24',NULL),(1739,7566,560,40720,1534,3,484,1,6563.44,NULL,'2023-03-19 13:29:34','2023-03-19 13:29:34',NULL),(1740,7566,560,40720,1534,3,68,1,1378.32,NULL,'2023-03-19 13:29:34','2023-03-19 13:29:34',NULL),(1741,7566,560,40720,1534,3,484,1,59.24,NULL,'2023-03-19 13:29:34','2023-03-19 13:29:34',NULL),(1742,7566,560,40720,1534,3,57,2,8001.00,NULL,'2023-03-19 13:29:34','2023-03-19 13:29:34',NULL),(1743,7566,561,40720,1534,3,484,1,2132.23,NULL,'2023-03-19 13:31:05','2023-03-19 13:31:05',NULL),(1744,7566,561,40720,1534,3,68,1,447.77,NULL,'2023-03-19 13:31:05','2023-03-19 13:31:05',NULL),(1745,7566,561,40720,1534,3,57,2,2580.00,NULL,'2023-03-19 13:31:05','2023-03-19 13:31:05',NULL),(1746,7566,562,40720,1534,3,482,1,4958.68,NULL,'2023-03-19 13:32:24','2023-03-19 13:32:24',NULL),(1747,7566,562,40720,1534,3,68,1,1041.32,NULL,'2023-03-19 13:32:24','2023-03-19 13:32:24',NULL),(1748,7566,562,40720,1534,3,57,2,6000.00,NULL,'2023-03-19 13:32:24','2023-03-19 13:32:24',NULL),(1749,7566,563,40720,1534,3,485,1,30000.00,NULL,'2023-03-19 13:33:25','2023-03-19 13:39:06','2023-03-19 13:39:06'),(1750,7566,563,40720,1534,3,68,1,6300.00,NULL,'2023-03-19 13:33:25','2023-03-19 13:39:06','2023-03-19 13:39:06'),(1751,7566,563,40720,1534,3,57,2,36300.00,NULL,'2023-03-19 13:33:25','2023-03-19 13:39:06','2023-03-19 13:39:06'),(1752,7566,564,40720,1534,3,485,1,26500.00,NULL,'2023-03-19 13:33:50','2023-03-19 13:38:47','2023-03-19 13:38:47'),(1753,7566,564,40720,1534,3,68,1,5565.00,NULL,'2023-03-19 13:33:50','2023-03-19 13:38:47','2023-03-19 13:38:47'),(1754,7566,564,40720,1534,3,57,2,32065.00,NULL,'2023-03-19 13:33:50','2023-03-19 13:38:47','2023-03-19 13:38:47');
INSERT INTO `balance_libro_details` VALUES (1755,7566,565,40720,1534,3,485,1,38800.00,NULL,'2023-03-19 13:34:10','2023-03-19 13:38:22','2023-03-19 13:38:22'),(1756,7566,565,40720,1534,3,68,1,8148.00,NULL,'2023-03-19 13:34:10','2023-03-19 13:38:22','2023-03-19 13:38:22'),(1757,7566,565,40720,1534,3,57,2,46948.00,NULL,'2023-03-19 13:34:10','2023-03-19 13:38:22','2023-03-19 13:38:22'),(1758,7566,566,40720,1534,3,135,1,8694.60,NULL,'2023-03-19 13:35:56','2023-03-19 13:35:56',NULL),(1759,7566,566,40720,1534,3,68,1,1825.87,NULL,'2023-03-19 13:35:56','2023-03-19 13:35:56',NULL),(1760,7566,566,40720,1534,3,57,2,10520.47,NULL,'2023-03-19 13:35:56','2023-03-19 13:35:56',NULL),(1761,7566,567,40720,1534,3,135,1,2330.57,NULL,'2023-03-19 13:37:27','2023-03-19 13:37:27',NULL),(1762,7566,567,40720,1534,3,68,1,489.42,NULL,'2023-03-19 13:37:27','2023-03-19 13:37:27',NULL),(1763,7566,567,40720,1534,3,57,2,2819.99,NULL,'2023-03-19 13:37:27','2023-03-19 13:37:27',NULL),(1764,7566,568,40720,1534,3,485,1,38800.00,NULL,'2023-03-19 13:38:22','2023-03-19 13:38:22',NULL),(1765,7566,568,40720,1534,3,68,1,8148.00,NULL,'2023-03-19 13:38:22','2023-03-19 13:38:22',NULL),(1766,7566,568,40720,1534,3,57,2,46948.00,NULL,'2023-03-19 13:38:22','2023-03-19 13:38:22',NULL),(1767,7566,569,40720,1534,3,485,1,26500.00,NULL,'2023-03-19 13:38:47','2023-03-19 13:38:47',NULL),(1768,7566,569,40720,1534,3,68,1,5565.00,NULL,'2023-03-19 13:38:47','2023-03-19 13:38:47',NULL),(1769,7566,569,40720,1534,3,57,2,32065.00,NULL,'2023-03-19 13:38:47','2023-03-19 13:38:47',NULL),(1770,7566,570,40720,1534,3,485,1,30000.00,NULL,'2023-03-19 13:39:06','2023-03-19 13:39:06',NULL),(1771,7566,570,40720,1534,3,68,1,6300.00,NULL,'2023-03-19 13:39:06','2023-03-19 13:39:06',NULL),(1772,7566,570,40720,1534,3,57,2,36300.00,NULL,'2023-03-19 13:39:06','2023-03-19 13:39:06',NULL),(1773,7566,571,40720,1534,3,135,1,2364.14,NULL,'2023-03-19 15:47:44','2023-03-19 15:47:44',NULL),(1774,7566,571,40720,1534,3,68,1,496.47,NULL,'2023-03-19 15:47:44','2023-03-19 15:47:44',NULL),(1775,7566,571,40720,1534,3,135,1,9169.64,NULL,'2023-03-19 15:47:44','2023-03-19 15:47:44',NULL),(1776,7566,571,40720,1534,3,68,1,962.81,NULL,'2023-03-19 15:47:44','2023-03-19 15:47:44',NULL),(1777,7566,571,40720,1534,3,135,1,12.02,NULL,'2023-03-19 15:47:44','2023-03-19 15:47:44',NULL),(1778,7566,571,40720,1534,3,220,1,208.47,NULL,'2023-03-19 15:47:44','2023-03-19 15:47:44',NULL),(1779,7566,571,40720,1534,3,241,1,577.29,NULL,'2023-03-19 15:47:44','2023-03-19 15:47:44',NULL),(1780,7566,571,40720,1534,3,57,2,13790.84,NULL,'2023-03-19 15:47:44','2023-03-19 15:47:44',NULL),(1781,7566,572,40720,1534,3,199,1,2727.27,NULL,'2023-03-19 16:02:08','2023-03-19 16:03:31','2023-03-19 16:03:31'),(1782,7566,572,40720,1534,3,68,1,572.73,NULL,'2023-03-19 16:02:08','2023-03-19 16:03:31','2023-03-19 16:03:31'),(1783,7566,572,40720,1534,3,57,2,3300.00,NULL,'2023-03-19 16:02:08','2023-03-19 16:03:31','2023-03-19 16:03:31'),(1784,7566,573,40720,1534,3,199,1,5516.53,NULL,'2023-03-19 16:02:56','2023-03-19 16:02:56',NULL),(1785,7566,573,40720,1534,3,68,1,1158.47,NULL,'2023-03-19 16:02:56','2023-03-19 16:02:56',NULL),(1786,7566,573,40720,1534,3,220,1,165.50,NULL,'2023-03-19 16:02:56','2023-03-19 16:02:56',NULL),(1787,7566,573,40720,1534,3,241,1,55.17,NULL,'2023-03-19 16:02:56','2023-03-19 16:02:56',NULL),(1788,7566,573,40720,1534,3,57,2,6895.67,NULL,'2023-03-19 16:02:56','2023-03-19 16:02:56',NULL),(1789,7566,574,40720,1534,3,199,1,2727.27,NULL,'2023-03-19 16:03:31','2023-03-19 16:03:31',NULL),(1790,7566,574,40720,1534,3,68,1,572.73,NULL,'2023-03-19 16:03:31','2023-03-19 16:03:31',NULL),(1791,7566,574,40720,1534,3,57,2,3300.00,NULL,'2023-03-19 16:03:31','2023-03-19 16:03:31',NULL),(1792,7566,575,40720,1534,3,193,1,1381.47,NULL,'2023-03-19 16:04:06','2023-03-19 16:04:06',NULL),(1793,7566,575,40720,1534,3,68,1,373.00,NULL,'2023-03-19 16:04:06','2023-03-19 16:04:06',NULL),(1794,7566,575,40720,1534,3,193,1,2237.00,NULL,'2023-03-19 16:04:06','2023-03-19 16:04:06',NULL);
INSERT INTO `balance_libro_details` VALUES (1795,7566,575,40720,1534,3,68,1,469.77,NULL,'2023-03-19 16:04:06','2023-03-19 16:04:06',NULL),(1796,7566,575,40720,1534,3,193,1,72.71,NULL,'2023-03-19 16:04:06','2023-03-19 16:04:06',NULL),(1797,7566,575,40720,1534,3,220,1,108.55,NULL,'2023-03-19 16:04:06','2023-03-19 16:04:06',NULL),(1798,7566,575,40720,1534,3,241,1,184.56,NULL,'2023-03-19 16:04:06','2023-03-19 16:04:06',NULL),(1799,7566,575,40720,1534,3,57,2,4827.06,NULL,'2023-03-19 16:04:06','2023-03-19 16:04:06',NULL),(1800,7566,576,40720,1534,3,135,1,2396.69,NULL,'2023-03-22 19:05:32','2023-03-22 19:05:32',NULL),(1801,7566,576,40720,1534,3,68,1,503.30,NULL,'2023-03-22 19:05:32','2023-03-22 19:05:32',NULL),(1802,7566,576,40720,1534,3,135,1,0.01,NULL,'2023-03-22 19:05:32','2023-03-22 19:05:32',NULL),(1803,7566,576,40720,1534,3,57,2,2900.00,NULL,'2023-03-22 19:05:32','2023-03-22 19:05:32',NULL),(1804,7566,577,40720,1534,3,135,1,4925.62,NULL,'2023-03-22 19:07:09','2023-03-22 19:07:09',NULL),(1805,7566,577,40720,1534,3,68,1,1034.38,NULL,'2023-03-22 19:07:09','2023-03-22 19:07:09',NULL),(1806,7566,577,40720,1534,3,57,2,5960.00,NULL,'2023-03-22 19:07:09','2023-03-22 19:07:09',NULL),(1807,7566,578,40720,1534,3,135,1,13074.38,NULL,'2023-03-22 19:08:11','2023-03-22 19:08:11',NULL),(1808,7566,578,40720,1534,3,68,1,2745.62,NULL,'2023-03-22 19:08:11','2023-03-22 19:08:11',NULL),(1809,7566,578,40720,1534,3,57,2,15820.00,NULL,'2023-03-22 19:08:11','2023-03-22 19:08:11',NULL),(1810,7566,579,40720,1534,3,135,1,4734.36,NULL,'2023-03-22 19:08:59','2023-03-22 19:08:59',NULL),(1811,7566,579,40720,1534,3,68,1,497.11,NULL,'2023-03-22 19:08:59','2023-03-22 19:08:59',NULL),(1812,7566,579,40720,1534,3,57,2,5231.47,NULL,'2023-03-22 19:08:59','2023-03-22 19:08:59',NULL),(1813,7566,580,40720,1534,3,483,1,4562.00,NULL,'2023-03-22 19:09:51','2023-03-22 19:09:51',NULL),(1814,7566,580,40720,1534,3,68,1,958.02,NULL,'2023-03-22 19:09:51','2023-03-22 19:09:51',NULL),(1815,7566,580,40720,1534,3,57,2,5520.02,NULL,'2023-03-22 19:09:51','2023-03-22 19:09:51',NULL),(1816,7566,581,40720,1534,3,135,1,2967.14,NULL,'2023-03-22 19:11:43','2023-03-22 19:11:43',NULL),(1817,7566,581,40720,1534,3,68,1,311.55,NULL,'2023-03-22 19:11:43','2023-03-22 19:11:43',NULL),(1818,7566,581,40720,1534,3,57,2,3278.69,NULL,'2023-03-22 19:11:43','2023-03-22 19:11:43',NULL),(1819,7566,582,40720,1534,3,135,1,29985.93,NULL,'2023-03-22 19:13:32','2023-03-22 19:13:32',NULL),(1820,7566,582,40720,1534,3,68,1,6297.05,NULL,'2023-03-22 19:13:32','2023-03-22 19:13:32',NULL),(1821,7566,582,40720,1534,3,135,1,21.59,NULL,'2023-03-22 19:13:32','2023-03-22 19:13:32',NULL),(1822,7566,582,40720,1534,3,220,1,899.58,NULL,'2023-03-22 19:13:32','2023-03-22 19:13:32',NULL),(1823,7566,582,40720,1534,3,239,1,299.86,NULL,'2023-03-22 19:13:32','2023-03-22 19:13:32',NULL),(1824,7566,582,40720,1534,3,57,2,37504.01,NULL,'2023-03-22 19:13:32','2023-03-22 19:13:32',NULL),(1825,7566,583,40720,1534,3,135,1,412.31,NULL,'2023-03-22 19:16:10','2023-03-22 19:16:10',NULL),(1826,7566,583,40720,1534,3,68,1,86.59,NULL,'2023-03-22 19:16:10','2023-03-22 19:16:10',NULL),(1827,7566,583,40720,1534,3,57,2,498.90,NULL,'2023-03-22 19:16:10','2023-03-22 19:16:10',NULL),(1828,7566,584,40720,1534,3,135,1,10500.00,NULL,'2023-03-22 19:17:04','2023-03-22 19:17:04',NULL),(1829,7566,584,40720,1534,3,57,2,10500.00,NULL,'2023-03-22 19:17:04','2023-03-22 19:17:04',NULL),(1830,7566,585,40720,1534,3,135,1,7000.00,NULL,'2023-03-22 19:17:40','2023-03-22 19:17:40',NULL),(1831,7566,585,40720,1534,3,57,2,7000.00,NULL,'2023-03-22 19:17:40','2023-03-22 19:17:40',NULL),(1832,7566,586,40720,1535,2,96,2,174753.37,NULL,'2023-04-19 11:01:22','2023-04-19 11:01:22',NULL),(1833,7566,586,40720,1535,2,67,2,36698.21,NULL,'2023-04-19 11:01:22','2023-04-19 11:01:22',NULL),(1834,7566,586,40720,1535,2,13,1,211451.58,NULL,'2023-04-19 11:01:22','2023-04-19 11:01:22',NULL),(1835,7566,587,40720,1535,2,96,2,2872.57,NULL,'2023-04-19 11:01:22','2023-04-19 11:01:22',NULL);
INSERT INTO `balance_libro_details` VALUES (1836,7566,587,40720,1535,2,67,2,603.24,NULL,'2023-04-19 11:01:22','2023-04-19 11:01:22',NULL),(1837,7566,587,40720,1535,2,13,1,3475.81,NULL,'2023-04-19 11:01:22','2023-04-19 11:01:22',NULL),(1838,7566,588,40720,1535,2,96,2,7952.24,NULL,'2023-04-19 11:01:22','2023-04-19 11:01:22',NULL),(1839,7566,588,40720,1535,2,67,2,1669.97,NULL,'2023-04-19 11:01:22','2023-04-19 11:01:22',NULL),(1840,7566,588,40720,1535,2,13,1,9622.21,NULL,'2023-04-19 11:01:22','2023-04-19 11:01:22',NULL),(1841,7566,589,40720,1535,2,96,2,290881.39,NULL,'2023-04-19 11:01:22','2023-04-19 11:01:22',NULL),(1842,7566,589,40720,1535,2,67,2,61085.09,NULL,'2023-04-19 11:01:22','2023-04-19 11:01:22',NULL),(1843,7566,589,40720,1535,2,13,1,351966.48,NULL,'2023-04-19 11:01:22','2023-04-19 11:01:22',NULL),(1844,7566,590,40720,1535,3,250,1,0.00,NULL,'2023-04-19 11:01:44','2023-04-19 11:17:51','2023-04-19 11:17:51'),(1845,7566,590,40720,1535,3,250,1,16666.16,NULL,'2023-04-19 11:01:44','2023-04-19 11:17:51','2023-04-19 11:17:51'),(1846,7566,590,40720,1535,3,57,2,16666.16,NULL,'2023-04-19 11:01:44','2023-04-19 11:17:51','2023-04-19 11:17:51'),(1847,7566,591,40720,1535,3,199,1,2727.27,NULL,'2023-04-19 11:01:44','2023-04-19 11:18:41','2023-04-19 11:18:41'),(1848,7566,591,40720,1535,3,68,1,572.73,NULL,'2023-04-19 11:01:44','2023-04-19 11:18:41','2023-04-19 11:18:41'),(1849,7566,591,40720,1535,3,57,2,3300.00,NULL,'2023-04-19 11:01:44','2023-04-19 11:18:41','2023-04-19 11:18:41'),(1850,7566,592,40720,1535,3,483,1,1752.07,NULL,'2023-04-19 11:01:44','2023-04-19 11:01:44',NULL),(1851,7566,592,40720,1535,3,68,1,367.93,NULL,'2023-04-19 11:01:44','2023-04-19 11:01:44',NULL),(1852,7566,592,40720,1535,3,57,2,2120.00,NULL,'2023-04-19 11:01:44','2023-04-19 11:01:44',NULL),(1853,7566,593,40720,1535,3,193,1,5533.00,NULL,'2023-04-19 11:01:44','2023-04-19 11:24:47','2023-04-19 11:24:47'),(1854,7566,593,40720,1535,3,68,1,1437.45,NULL,'2023-04-19 11:01:44','2023-04-19 11:24:47','2023-04-19 11:24:47'),(1855,7566,593,40720,1535,3,193,1,696.40,NULL,'2023-04-19 11:01:44','2023-04-19 11:24:47','2023-04-19 11:24:47'),(1856,7566,593,40720,1535,3,57,2,7666.85,NULL,'2023-04-19 11:01:44','2023-04-19 11:24:47','2023-04-19 11:24:47'),(1857,7566,594,40720,1535,3,116,1,11250.00,NULL,'2023-04-19 11:01:44','2023-04-19 11:01:44',NULL),(1858,7566,594,40720,1535,3,57,2,11250.00,NULL,'2023-04-19 11:01:44','2023-04-19 11:01:44',NULL),(1859,7566,595,40720,1535,3,193,2,1443.36,NULL,'2023-04-19 11:01:44','2023-04-19 11:42:10','2023-04-19 11:42:10'),(1860,7566,595,40720,1535,3,67,2,374.97,NULL,'2023-04-19 11:01:44','2023-04-19 11:42:10','2023-04-19 11:42:10'),(1861,7566,595,40720,1535,3,193,2,181.67,NULL,'2023-04-19 11:01:44','2023-04-19 11:42:10','2023-04-19 11:42:10'),(1862,7566,595,40720,1535,3,57,1,2000.00,NULL,'2023-04-19 11:01:44','2023-04-19 11:42:10','2023-04-19 11:42:10'),(1863,7566,596,40720,1535,3,483,1,2066.12,NULL,'2023-04-19 11:01:45','2023-04-19 11:01:45',NULL),(1864,7566,596,40720,1535,3,68,1,433.88,NULL,'2023-04-19 11:01:45','2023-04-19 11:01:45',NULL),(1865,7566,596,40720,1535,3,57,2,2500.00,NULL,'2023-04-19 11:01:45','2023-04-19 11:01:45',NULL),(1866,7566,597,40720,1535,3,483,1,2099.17,NULL,'2023-04-19 11:01:45','2023-04-19 11:01:45',NULL),(1867,7566,597,40720,1535,3,68,1,440.83,NULL,'2023-04-19 11:01:45','2023-04-19 11:01:45',NULL),(1868,7566,597,40720,1535,3,57,2,2540.00,NULL,'2023-04-19 11:01:45','2023-04-19 11:01:45',NULL),(1869,7566,598,40720,1535,3,199,1,6371.90,NULL,'2023-04-19 11:01:45','2023-04-19 11:20:30','2023-04-19 11:20:30'),(1870,7566,598,40720,1535,3,68,1,1338.10,NULL,'2023-04-19 11:01:45','2023-04-19 11:20:30','2023-04-19 11:20:30'),(1871,7566,598,40720,1535,3,199,1,254.88,NULL,'2023-04-19 11:01:45','2023-04-19 11:20:30','2023-04-19 11:20:30'),(1872,7566,598,40720,1535,3,57,2,7964.88,NULL,'2023-04-19 11:01:45','2023-04-19 11:20:30','2023-04-19 11:20:30'),(1873,7566,599,40720,1535,3,483,1,2181.82,NULL,'2023-04-19 11:01:45','2023-04-19 11:01:45',NULL);
INSERT INTO `balance_libro_details` VALUES (1874,7566,599,40720,1535,3,68,1,458.18,NULL,'2023-04-19 11:01:45','2023-04-19 11:01:45',NULL),(1875,7566,599,40720,1535,3,57,2,2640.00,NULL,'2023-04-19 11:01:45','2023-04-19 11:01:45',NULL),(1876,7566,600,40720,1535,3,483,1,2396.69,NULL,'2023-04-19 11:01:45','2023-04-19 11:01:45',NULL),(1877,7566,600,40720,1535,3,68,1,503.31,NULL,'2023-04-19 11:01:45','2023-04-19 11:01:45',NULL),(1878,7566,600,40720,1535,3,57,2,2900.00,NULL,'2023-04-19 11:01:45','2023-04-19 11:01:45',NULL),(1879,7566,601,40720,1535,3,199,2,2894.84,NULL,'2023-04-19 11:01:45','2023-04-19 11:36:02','2023-04-19 11:36:02'),(1880,7566,601,40720,1535,3,67,2,607.92,NULL,'2023-04-19 11:01:45','2023-04-19 11:36:02','2023-04-19 11:36:02'),(1881,7566,601,40720,1535,3,199,2,115.80,NULL,'2023-04-19 11:01:45','2023-04-19 11:36:02','2023-04-19 11:36:02'),(1882,7566,601,40720,1535,3,57,1,3618.56,NULL,'2023-04-19 11:01:45','2023-04-19 11:36:02','2023-04-19 11:36:02'),(1883,7566,602,40720,1535,3,483,1,2479.34,NULL,'2023-04-19 11:01:45','2023-04-19 11:01:45',NULL),(1884,7566,602,40720,1535,3,68,1,520.66,NULL,'2023-04-19 11:01:45','2023-04-19 11:01:45',NULL),(1885,7566,602,40720,1535,3,57,2,3000.00,NULL,'2023-04-19 11:01:45','2023-04-19 11:01:45',NULL),(1886,7566,603,40720,1535,3,250,1,5400.00,NULL,'2023-04-19 11:01:45','2023-04-19 11:35:28','2023-04-19 11:35:28'),(1887,7566,603,40720,1535,3,57,2,5400.00,NULL,'2023-04-19 11:01:45','2023-04-19 11:35:28','2023-04-19 11:35:28'),(1888,7566,604,40720,1535,3,135,1,9285.89,NULL,'2023-04-19 11:01:45','2023-04-19 11:28:41','2023-04-19 11:28:41'),(1889,7566,604,40720,1535,3,68,1,1544.00,NULL,'2023-04-19 11:01:45','2023-04-19 11:28:41','2023-04-19 11:28:41'),(1890,7566,604,40720,1535,3,135,1,313.43,NULL,'2023-04-19 11:01:45','2023-04-19 11:28:41','2023-04-19 11:28:41'),(1891,7566,604,40720,1535,3,57,2,11143.32,NULL,'2023-04-19 11:01:45','2023-04-19 11:28:41','2023-04-19 11:28:41'),(1892,7566,605,40720,1535,3,135,1,21000.00,NULL,'2023-04-19 11:01:45','2023-04-19 11:01:45',NULL),(1893,7566,605,40720,1535,3,57,2,21000.00,NULL,'2023-04-19 11:01:45','2023-04-19 11:01:45',NULL),(1894,7566,606,40720,1535,3,135,1,5174.56,NULL,'2023-04-19 11:01:45','2023-04-19 11:31:11','2023-04-19 11:31:11'),(1895,7566,606,40720,1535,3,68,1,719.00,NULL,'2023-04-19 11:01:45','2023-04-19 11:31:11','2023-04-19 11:31:11'),(1896,7566,606,40720,1535,3,135,1,390.94,NULL,'2023-04-19 11:01:45','2023-04-19 11:31:11','2023-04-19 11:31:11'),(1897,7566,606,40720,1535,3,57,2,6284.50,NULL,'2023-04-19 11:01:45','2023-04-19 11:31:11','2023-04-19 11:31:11'),(1898,7566,607,40720,1535,7,25,1,4745.27,NULL,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(1899,7566,607,40720,1535,7,13,2,4745.27,NULL,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(1900,7566,608,40720,1535,7,25,1,95.69,NULL,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(1901,7566,608,40720,1535,7,13,2,95.69,NULL,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(1902,7566,609,40720,1535,7,25,1,1239.75,NULL,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(1903,7566,609,40720,1535,7,13,2,1239.75,NULL,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(1904,7566,610,40720,1535,7,25,1,593.26,NULL,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(1905,7566,610,40720,1535,7,13,2,593.26,NULL,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(1906,7566,611,40720,1535,7,25,1,5429.92,NULL,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(1907,7566,611,40720,1535,7,13,2,5429.92,NULL,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(1908,7566,612,40720,1535,7,25,1,839.48,NULL,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(1909,7566,612,40720,1535,7,13,2,839.48,NULL,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(1910,7566,613,40720,1535,7,25,1,3887.27,NULL,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(1911,7566,613,40720,1535,7,13,2,3887.27,NULL,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(1912,7566,614,40720,1535,7,25,1,60.50,NULL,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL);
INSERT INTO `balance_libro_details` VALUES (1913,7566,614,40720,1535,7,13,2,60.50,NULL,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(1914,7566,615,40720,1535,7,25,1,482.59,NULL,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(1915,7566,615,40720,1535,7,13,2,482.59,NULL,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(1916,7566,616,40720,1535,7,25,1,2924.42,NULL,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(1917,7566,616,40720,1535,7,13,2,2924.42,NULL,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(1918,7566,617,40720,1535,7,25,1,11591.53,NULL,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(1919,7566,617,40720,1535,7,13,2,11591.53,NULL,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(1920,7566,618,40720,1535,7,25,1,2802.19,NULL,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(1921,7566,618,40720,1535,7,13,2,2802.19,NULL,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(1922,7566,619,40720,1535,7,25,1,1518.20,NULL,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(1923,7566,619,40720,1535,7,13,2,1518.20,NULL,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(1924,7566,620,40720,1535,7,25,1,587.56,NULL,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(1925,7566,620,40720,1535,7,13,2,587.56,NULL,'2023-04-19 11:04:33','2023-04-19 11:04:33',NULL),(1926,7566,621,40720,1535,8,290,1,99.71,NULL,'2023-04-19 11:06:53','2023-04-19 11:06:53',NULL),(1927,7566,621,40720,1535,8,351,2,99.71,NULL,'2023-04-19 11:06:53','2023-04-19 11:06:53',NULL),(1928,7566,622,40720,1535,3,199,1,2727.27,NULL,'2023-04-19 11:18:41','2023-04-19 11:18:41',NULL),(1929,7566,622,40720,1535,3,68,1,572.73,NULL,'2023-04-19 11:18:41','2023-04-19 11:18:41',NULL),(1930,7566,622,40720,1535,3,57,2,3300.00,NULL,'2023-04-19 11:18:41','2023-04-19 11:18:41',NULL),(1931,7566,623,40720,1535,3,199,1,6371.90,NULL,'2023-04-19 11:22:25','2023-04-19 11:22:25',NULL),(1932,7566,623,40720,1535,3,68,1,1338.10,NULL,'2023-04-19 11:22:25','2023-04-19 11:22:25',NULL),(1933,7566,623,40720,1535,3,220,1,191.16,NULL,'2023-04-19 11:22:25','2023-04-19 11:22:25',NULL),(1934,7566,623,40720,1535,3,241,1,63.72,NULL,'2023-04-19 11:22:25','2023-04-19 11:22:25',NULL),(1935,7566,623,40720,1535,3,57,2,7964.88,NULL,'2023-04-19 11:22:25','2023-04-19 11:22:25',NULL),(1936,7566,624,40720,1535,3,193,1,4592.00,NULL,'2023-04-19 11:24:47','2023-04-19 11:24:47',NULL),(1937,7566,624,40720,1535,3,68,1,1239.84,NULL,'2023-04-19 11:24:47','2023-04-19 11:24:47',NULL),(1938,7566,624,40720,1535,3,193,1,941.00,NULL,'2023-04-19 11:24:47','2023-04-19 11:24:47',NULL),(1939,7566,624,40720,1535,3,68,1,197.61,NULL,'2023-04-19 11:24:47','2023-04-19 11:24:47',NULL),(1940,7566,624,40720,1535,3,193,1,241.68,NULL,'2023-04-19 11:24:47','2023-04-19 11:24:47',NULL),(1941,7566,624,40720,1535,3,220,1,165.99,NULL,'2023-04-19 11:24:47','2023-04-19 11:24:47',NULL),(1942,7566,624,40720,1535,3,241,1,288.73,NULL,'2023-04-19 11:24:47','2023-04-19 11:24:47',NULL),(1943,7566,624,40720,1535,3,57,2,7666.85,NULL,'2023-04-19 11:24:47','2023-04-19 11:24:47',NULL),(1944,7566,625,40720,1535,3,135,1,5418.92,NULL,'2023-04-19 11:28:41','2023-04-19 11:28:41',NULL),(1945,7566,625,40720,1535,3,68,1,1137.97,NULL,'2023-04-19 11:28:41','2023-04-19 11:28:41',NULL),(1946,7566,625,40720,1535,3,135,1,3866.97,NULL,'2023-04-19 11:28:41','2023-04-19 11:28:41',NULL),(1947,7566,625,40720,1535,3,68,1,406.03,NULL,'2023-04-19 11:28:41','2023-04-19 11:28:41',NULL),(1948,7566,625,40720,1535,3,220,1,220.57,NULL,'2023-04-19 11:28:41','2023-04-19 11:28:41',NULL),(1949,7566,625,40720,1535,3,239,1,92.86,NULL,'2023-04-19 11:28:41','2023-04-19 11:28:41',NULL),(1950,7566,625,40720,1535,3,57,2,11143.33,NULL,'2023-04-19 11:28:41','2023-04-19 11:28:41',NULL),(1951,7566,625,40720,1535,3,136,1,0.01,NULL,'2023-04-19 11:28:41','2023-04-19 11:28:41',NULL),(1952,7566,626,40720,1535,3,135,1,1673.09,NULL,'2023-04-19 11:31:11','2023-04-19 11:31:11',NULL),(1953,7566,626,40720,1535,3,68,1,351.35,NULL,'2023-04-19 11:31:11','2023-04-19 11:31:11',NULL);
INSERT INTO `balance_libro_details` VALUES (1954,7566,626,40720,1535,3,135,1,3501.47,NULL,'2023-04-19 11:31:11','2023-04-19 11:31:11',NULL),(1955,7566,626,40720,1535,3,68,1,367.65,NULL,'2023-04-19 11:31:11','2023-04-19 11:31:11',NULL),(1956,7566,626,40720,1535,3,135,1,28.10,NULL,'2023-04-19 11:31:11','2023-04-19 11:31:11',NULL),(1957,7566,626,40720,1535,3,220,1,102.71,NULL,'2023-04-19 11:31:11','2023-04-19 11:31:11',NULL),(1958,7566,626,40720,1535,3,241,1,260.13,NULL,'2023-04-19 11:31:11','2023-04-19 11:31:11',NULL),(1959,7566,626,40720,1535,3,57,2,6284.50,NULL,'2023-04-19 11:31:11','2023-04-19 11:31:11',NULL),(1960,7566,627,40720,1535,3,135,1,5400.00,NULL,'2023-04-19 11:35:28','2023-04-19 11:35:28',NULL),(1961,7566,627,40720,1535,3,57,2,5400.00,NULL,'2023-04-19 11:35:28','2023-04-19 11:35:28',NULL),(1962,7566,628,40720,1535,3,482,1,34000.00,NULL,'2023-04-19 11:43:57','2023-04-19 11:43:57',NULL),(1963,7566,628,40720,1535,3,68,1,7140.00,NULL,'2023-04-19 11:43:57','2023-04-19 11:43:57',NULL),(1964,7566,628,40720,1535,3,57,2,41140.00,NULL,'2023-04-19 11:43:57','2023-04-19 11:43:57',NULL),(1965,7566,629,40720,1535,3,482,1,30500.00,NULL,'2023-04-19 11:44:28','2023-04-19 11:44:28',NULL),(1966,7566,629,40720,1535,3,68,1,6405.00,NULL,'2023-04-19 11:44:28','2023-04-19 11:44:28',NULL),(1967,7566,629,40720,1535,3,57,2,36905.00,NULL,'2023-04-19 11:44:28','2023-04-19 11:44:28',NULL),(1968,7566,630,40720,1535,3,482,1,32098.00,NULL,'2023-04-19 11:44:51','2023-04-19 11:45:16','2023-04-19 11:45:16'),(1969,7566,630,40720,1535,3,68,1,6740.58,NULL,'2023-04-19 11:44:51','2023-04-19 11:45:16','2023-04-19 11:45:16'),(1970,7566,630,40720,1535,3,57,2,38838.58,NULL,'2023-04-19 11:44:51','2023-04-19 11:45:16','2023-04-19 11:45:16'),(1971,7566,631,40720,1535,3,482,1,32098.00,NULL,'2023-04-19 11:45:16','2023-04-19 11:45:16',NULL),(1972,7566,631,40720,1535,3,68,1,6740.58,NULL,'2023-04-19 11:45:16','2023-04-19 11:45:16',NULL),(1973,7566,631,40720,1535,3,57,2,38838.58,NULL,'2023-04-19 11:45:16','2023-04-19 11:45:16',NULL),(1974,7566,632,40720,1535,3,135,1,7389.06,NULL,'2023-04-19 11:46:17','2023-04-19 11:46:17',NULL),(1975,7566,632,40720,1535,3,68,1,1551.70,NULL,'2023-04-19 11:46:17','2023-04-19 11:46:17',NULL),(1976,7566,632,40720,1535,3,57,2,8940.76,NULL,'2023-04-19 11:46:17','2023-04-19 11:46:17',NULL),(1977,7566,633,40720,1535,3,135,1,4834.71,NULL,'2023-04-19 11:46:46','2023-04-19 12:48:29','2023-04-19 12:48:29'),(1978,7566,633,40720,1535,3,68,1,1015.29,NULL,'2023-04-19 11:46:46','2023-04-19 12:48:29','2023-04-19 12:48:29'),(1979,7566,633,40720,1535,3,57,2,5850.00,NULL,'2023-04-19 11:46:46','2023-04-19 12:48:29','2023-04-19 12:48:29'),(1980,7566,634,40720,1535,3,484,1,4597.69,NULL,'2023-04-19 11:47:48','2023-04-19 11:47:48',NULL),(1981,7566,634,40720,1535,3,68,1,965.51,NULL,'2023-04-19 11:47:48','2023-04-19 11:47:48',NULL),(1982,7566,634,40720,1535,3,484,1,39.09,NULL,'2023-04-19 11:47:48','2023-04-19 11:47:48',NULL),(1983,7566,634,40720,1535,3,57,2,5602.29,NULL,'2023-04-19 11:47:48','2023-04-19 11:47:48',NULL),(1984,7566,635,40720,1535,3,484,1,8657.02,NULL,'2023-04-19 11:48:23','2023-04-19 11:49:52','2023-04-19 11:49:52'),(1985,7566,635,40720,1535,3,68,1,1817.97,NULL,'2023-04-19 11:48:23','2023-04-19 11:49:52','2023-04-19 11:49:52'),(1986,7566,635,40720,1535,3,57,2,10474.99,NULL,'2023-04-19 11:48:23','2023-04-19 11:49:52','2023-04-19 11:49:52'),(1987,7566,636,40720,1535,3,135,1,14074.38,NULL,'2023-04-19 11:49:28','2023-04-19 11:49:28',NULL),(1988,7566,636,40720,1535,3,68,1,2955.62,NULL,'2023-04-19 11:49:28','2023-04-19 11:49:28',NULL),(1989,7566,636,40720,1535,3,57,2,17030.00,NULL,'2023-04-19 11:49:28','2023-04-19 11:49:28',NULL),(1990,7566,637,40720,1535,3,135,1,8657.02,NULL,'2023-04-19 11:49:52','2023-04-19 11:49:52',NULL),(1991,7566,637,40720,1535,3,68,1,1817.97,NULL,'2023-04-19 11:49:52','2023-04-19 11:49:52',NULL),(1992,7566,637,40720,1535,3,57,2,10474.99,NULL,'2023-04-19 11:49:52','2023-04-19 11:49:52',NULL);
INSERT INTO `balance_libro_details` VALUES (1993,7566,638,40720,1535,3,484,1,6671.37,NULL,'2023-04-19 11:51:25','2023-04-19 11:51:25',NULL),(1994,7566,638,40720,1535,3,68,1,1400.99,NULL,'2023-04-19 11:51:25','2023-04-19 11:51:25',NULL),(1995,7566,638,40720,1535,3,484,1,58.45,NULL,'2023-04-19 11:51:25','2023-04-19 11:51:25',NULL),(1996,7566,638,40720,1535,3,241,1,66.71,NULL,'2023-04-19 11:51:25','2023-04-19 11:51:25',NULL),(1997,7566,638,40720,1535,3,57,2,8197.52,NULL,'2023-04-19 11:51:25','2023-04-19 11:51:25',NULL),(1998,7566,639,40720,1535,3,484,1,6934.17,NULL,'2023-04-19 11:52:06','2023-04-19 11:52:06',NULL),(1999,7566,639,40720,1535,3,68,1,1456.18,NULL,'2023-04-19 11:52:06','2023-04-19 11:52:06',NULL),(2000,7566,639,40720,1535,3,484,1,60.75,NULL,'2023-04-19 11:52:06','2023-04-19 11:52:06',NULL),(2001,7566,639,40720,1535,3,241,1,69.34,NULL,'2023-04-19 11:52:06','2023-04-19 11:52:06',NULL),(2002,7566,639,40720,1535,3,57,2,8520.44,NULL,'2023-04-19 11:52:06','2023-04-19 11:52:06',NULL),(2003,7566,640,40720,1535,3,135,1,1974.49,NULL,'2023-04-19 11:53:45','2023-04-19 12:47:35','2023-04-19 12:47:35'),(2004,7566,640,40720,1535,3,68,1,414.64,NULL,'2023-04-19 11:53:45','2023-04-19 12:47:35','2023-04-19 12:47:35'),(2005,7566,640,40720,1535,3,57,2,2389.13,NULL,'2023-04-19 11:53:45','2023-04-19 12:47:35','2023-04-19 12:47:35'),(2006,7566,641,40720,1535,3,484,1,2396.69,NULL,'2023-04-19 11:54:35','2023-04-19 11:54:35',NULL),(2007,7566,641,40720,1535,3,68,1,503.30,NULL,'2023-04-19 11:54:35','2023-04-19 11:54:35',NULL),(2008,7566,641,40720,1535,3,484,1,0.01,NULL,'2023-04-19 11:54:35','2023-04-19 11:54:35',NULL),(2009,7566,641,40720,1535,3,57,2,2900.00,NULL,'2023-04-19 11:54:35','2023-04-19 11:54:35',NULL),(2010,7566,642,40720,1535,3,483,1,2347.11,NULL,'2023-04-19 11:55:10','2023-04-19 11:55:10',NULL),(2011,7566,642,40720,1535,3,68,1,492.89,NULL,'2023-04-19 11:55:10','2023-04-19 11:55:10',NULL),(2012,7566,642,40720,1535,3,57,2,2840.00,NULL,'2023-04-19 11:55:10','2023-04-19 11:55:10',NULL),(2013,7566,643,40720,1535,3,483,1,2181.78,NULL,'2023-04-19 11:55:41','2023-04-19 11:55:41',NULL),(2014,7566,643,40720,1535,3,68,1,458.17,NULL,'2023-04-19 11:55:41','2023-04-19 11:55:41',NULL),(2015,7566,643,40720,1535,3,483,1,0.05,NULL,'2023-04-19 11:55:41','2023-04-19 11:55:41',NULL),(2016,7566,643,40720,1535,3,57,2,2640.00,NULL,'2023-04-19 11:55:41','2023-04-19 11:55:41',NULL),(2017,7566,644,40720,1535,3,135,1,1974.49,NULL,'2023-04-19 12:47:35','2023-04-19 12:47:35',NULL),(2018,7566,644,40720,1535,3,68,1,414.64,NULL,'2023-04-19 12:47:35','2023-04-19 12:47:35',NULL),(2019,7566,644,40720,1535,3,57,2,2389.13,NULL,'2023-04-19 12:47:35','2023-04-19 12:47:35',NULL),(2020,7566,645,40720,1535,3,135,1,4834.71,NULL,'2023-04-19 12:48:29','2023-04-19 12:48:29',NULL),(2021,7566,645,40720,1535,3,68,1,1015.29,NULL,'2023-04-19 12:48:29','2023-04-19 12:48:29',NULL),(2022,7566,645,40720,1535,3,57,2,5850.00,NULL,'2023-04-19 12:48:29','2023-04-19 12:48:29',NULL),(2023,7566,646,40719,22,2,218,2,3500.00,NULL,'2023-05-12 20:44:13','2023-05-12 20:46:10','2023-05-12 20:46:10'),(2024,7566,646,40719,22,2,13,1,3500.00,NULL,'2023-05-12 20:44:13','2023-05-12 20:46:10','2023-05-12 20:46:10'),(2025,7566,647,40719,22,2,218,2,40000.00,NULL,'2023-05-12 20:44:13','2023-05-12 20:46:10','2023-05-12 20:46:10'),(2026,7566,647,40719,22,2,13,1,40000.00,NULL,'2023-05-12 20:44:13','2023-05-12 20:46:10','2023-05-12 20:46:10'),(2027,7566,648,40719,22,2,218,2,13000.00,NULL,'2023-05-12 20:44:13','2023-05-12 20:46:10','2023-05-12 20:46:10'),(2028,7566,648,40719,22,2,13,1,13000.00,NULL,'2023-05-12 20:44:13','2023-05-12 20:46:10','2023-05-12 20:46:10'),(2029,7566,649,40719,22,2,218,2,7000.00,NULL,'2023-05-12 20:44:13','2023-05-12 20:46:10','2023-05-12 20:46:10'),(2030,7566,649,40719,22,2,13,1,7000.00,NULL,'2023-05-12 20:44:13','2023-05-12 20:46:10','2023-05-12 20:46:10'),(2031,7566,650,40719,22,2,218,2,12600.00,NULL,'2023-05-12 20:44:13','2023-05-12 20:46:10','2023-05-12 20:46:10');
INSERT INTO `balance_libro_details` VALUES (2032,7566,650,40719,22,2,13,1,12600.00,NULL,'2023-05-12 20:44:13','2023-05-12 20:46:10','2023-05-12 20:46:10'),(2033,7566,651,40719,22,2,218,2,15600.00,NULL,'2023-05-12 20:44:13','2023-05-12 20:46:10','2023-05-12 20:46:10'),(2034,7566,651,40719,22,2,13,1,15600.00,NULL,'2023-05-12 20:44:13','2023-05-12 20:46:10','2023-05-12 20:46:10'),(2035,7566,652,40719,22,2,218,2,11000.00,NULL,'2023-05-12 20:44:13','2023-05-12 20:46:10','2023-05-12 20:46:10'),(2036,7566,652,40719,22,2,13,1,11000.00,NULL,'2023-05-12 20:44:13','2023-05-12 20:46:10','2023-05-12 20:46:10'),(2037,7566,653,40719,22,2,218,2,13000.00,NULL,'2023-05-12 20:44:13','2023-05-12 20:45:56','2023-05-12 20:45:56'),(2038,7566,653,40719,22,2,13,1,13000.00,NULL,'2023-05-12 20:44:13','2023-05-12 20:45:56','2023-05-12 20:45:56'),(2039,7566,654,40719,22,2,218,2,17340.00,NULL,'2023-05-12 20:44:13','2023-05-12 20:45:53','2023-05-12 20:45:53'),(2040,7566,654,40719,22,2,13,1,17340.00,NULL,'2023-05-12 20:44:13','2023-05-12 20:45:53','2023-05-12 20:45:53'),(2041,7566,655,40719,22,2,218,2,15600.00,NULL,'2023-05-12 20:44:13','2023-05-12 20:45:46','2023-05-12 20:45:46'),(2042,7566,655,40719,22,2,13,1,15600.00,NULL,'2023-05-12 20:44:13','2023-05-12 20:45:46','2023-05-12 20:45:46'),(2043,7566,656,40719,22,2,218,2,13000.00,NULL,'2023-05-12 20:44:13','2023-05-12 20:45:42','2023-05-12 20:45:42'),(2044,7566,656,40719,22,2,13,1,13000.00,NULL,'2023-05-12 20:44:13','2023-05-12 20:45:42','2023-05-12 20:45:42'),(2045,7566,657,40719,22,2,218,2,13000.00,NULL,'2023-05-12 20:44:13','2023-05-12 20:45:38','2023-05-12 20:45:38'),(2046,7566,657,40719,22,2,13,1,13000.00,NULL,'2023-05-12 20:44:13','2023-05-12 20:45:38','2023-05-12 20:45:38'),(2047,7566,658,40719,22,2,218,2,15600.00,NULL,'2023-05-12 20:44:13','2023-05-12 20:45:35','2023-05-12 20:45:35'),(2048,7566,658,40719,22,2,13,1,15600.00,NULL,'2023-05-12 20:44:13','2023-05-12 20:45:35','2023-05-12 20:45:35'),(2049,7566,659,40719,22,2,218,2,10000.00,NULL,'2023-05-12 20:44:13','2023-05-12 20:45:31','2023-05-12 20:45:31'),(2050,7566,659,40719,22,2,13,1,10000.00,NULL,'2023-05-12 20:44:13','2023-05-12 20:45:31','2023-05-12 20:45:31'),(2051,7566,660,40719,22,2,218,2,13000.00,NULL,'2023-05-12 20:44:13','2023-05-12 20:45:27','2023-05-12 20:45:27'),(2052,7566,660,40719,22,2,13,1,13000.00,NULL,'2023-05-12 20:44:13','2023-05-12 20:45:27','2023-05-12 20:45:27'),(2053,7566,661,40719,22,2,218,2,26000.00,NULL,'2023-05-12 20:44:13','2023-05-12 20:45:23','2023-05-12 20:45:23'),(2054,7566,661,40719,22,2,13,1,26000.00,NULL,'2023-05-12 20:44:14','2023-05-12 20:45:23','2023-05-12 20:45:23'),(2055,7566,662,40719,21,2,218,2,3500.00,NULL,'2023-05-12 20:46:49','2023-05-12 20:46:49',NULL),(2056,7566,662,40719,21,2,13,1,3500.00,NULL,'2023-05-12 20:46:49','2023-05-12 20:46:49',NULL),(2057,7566,663,40719,21,2,218,2,40000.00,NULL,'2023-05-12 20:46:49','2023-05-12 20:46:49',NULL),(2058,7566,663,40719,21,2,13,1,40000.00,NULL,'2023-05-12 20:46:49','2023-05-12 20:46:49',NULL),(2059,7566,664,40719,21,2,218,2,13000.00,NULL,'2023-05-12 20:46:49','2023-05-12 20:46:49',NULL),(2060,7566,664,40719,21,2,13,1,13000.00,NULL,'2023-05-12 20:46:49','2023-05-12 20:46:49',NULL),(2061,7566,665,40719,21,2,218,2,7000.00,NULL,'2023-05-12 20:46:49','2023-05-12 20:46:49',NULL),(2062,7566,665,40719,21,2,13,1,7000.00,NULL,'2023-05-12 20:46:49','2023-05-12 20:46:49',NULL),(2063,7566,666,40719,21,2,218,2,12600.00,NULL,'2023-05-12 20:46:49','2023-05-12 20:46:49',NULL),(2064,7566,666,40719,21,2,13,1,12600.00,NULL,'2023-05-12 20:46:49','2023-05-12 20:46:49',NULL),(2065,7566,667,40719,21,2,218,2,15600.00,NULL,'2023-05-12 20:46:49','2023-05-12 20:46:49',NULL),(2066,7566,667,40719,21,2,13,1,15600.00,NULL,'2023-05-12 20:46:49','2023-05-12 20:46:49',NULL),(2067,7566,668,40719,21,2,218,2,11000.00,NULL,'2023-05-12 20:46:49','2023-05-12 20:46:49',NULL),(2068,7566,668,40719,21,2,13,1,11000.00,NULL,'2023-05-12 20:46:49','2023-05-12 20:46:49',NULL);
INSERT INTO `balance_libro_details` VALUES (2069,7566,669,40719,21,2,218,2,13000.00,NULL,'2023-05-12 20:46:49','2023-05-12 20:46:49',NULL),(2070,7566,669,40719,21,2,13,1,13000.00,NULL,'2023-05-12 20:46:49','2023-05-12 20:46:49',NULL),(2071,7566,670,40719,21,2,218,2,17340.00,NULL,'2023-05-12 20:46:50','2023-05-12 20:46:50',NULL),(2072,7566,670,40719,21,2,13,1,17340.00,NULL,'2023-05-12 20:46:50','2023-05-12 20:46:50',NULL),(2073,7566,671,40719,21,2,218,2,15600.00,NULL,'2023-05-12 20:46:50','2023-05-12 20:46:50',NULL),(2074,7566,671,40719,21,2,13,1,15600.00,NULL,'2023-05-12 20:46:50','2023-05-12 20:46:50',NULL),(2075,7566,672,40719,21,2,218,2,13000.00,NULL,'2023-05-12 20:46:50','2023-05-12 20:46:50',NULL),(2076,7566,672,40719,21,2,13,1,13000.00,NULL,'2023-05-12 20:46:50','2023-05-12 20:46:50',NULL),(2077,7566,673,40719,21,2,218,2,13000.00,NULL,'2023-05-12 20:46:50','2023-05-12 20:46:50',NULL),(2078,7566,673,40719,21,2,13,1,13000.00,NULL,'2023-05-12 20:46:50','2023-05-12 20:46:50',NULL),(2079,7566,674,40719,21,2,218,2,15600.00,NULL,'2023-05-12 20:46:50','2023-05-12 20:46:50',NULL),(2080,7566,674,40719,21,2,13,1,15600.00,NULL,'2023-05-12 20:46:50','2023-05-12 20:46:50',NULL),(2081,7566,675,40719,21,2,218,2,10000.00,NULL,'2023-05-12 20:46:50','2023-05-12 20:46:50',NULL),(2082,7566,675,40719,21,2,13,1,10000.00,NULL,'2023-05-12 20:46:50','2023-05-12 20:46:50',NULL),(2083,7566,676,40719,21,2,218,2,13000.00,NULL,'2023-05-12 20:46:50','2023-05-12 20:46:50',NULL),(2084,7566,676,40719,21,2,13,1,13000.00,NULL,'2023-05-12 20:46:50','2023-05-12 20:46:50',NULL),(2085,7566,677,40719,21,2,218,2,26000.00,NULL,'2023-05-12 20:46:50','2023-05-12 20:46:50',NULL),(2086,7566,677,40719,21,2,13,1,26000.00,NULL,'2023-05-12 20:46:50','2023-05-12 20:46:50',NULL),(2087,7566,678,40719,21,3,250,1,39658.63,NULL,'2023-05-12 20:51:50','2023-05-12 20:53:47','2023-05-12 20:53:47'),(2088,7566,678,40719,21,3,57,2,39658.63,NULL,'2023-05-12 20:51:50','2023-05-12 20:53:47','2023-05-12 20:53:47'),(2089,7566,679,40719,21,3,250,1,0.00,NULL,'2023-05-12 20:51:51','2023-05-12 20:53:33','2023-05-12 20:53:33'),(2090,7566,679,40719,21,3,250,1,19000.00,NULL,'2023-05-12 20:51:51','2023-05-12 20:53:33','2023-05-12 20:53:33'),(2091,7566,679,40719,21,3,57,2,19000.00,NULL,'2023-05-12 20:51:51','2023-05-12 20:53:33','2023-05-12 20:53:33'),(2092,7566,680,40719,21,3,217,1,7973.01,NULL,'2023-05-12 20:51:51','2023-05-12 20:53:19','2023-05-12 20:53:19'),(2093,7566,680,40719,21,3,68,1,1674.33,NULL,'2023-05-12 20:51:51','2023-05-12 20:53:19','2023-05-12 20:53:19'),(2094,7566,680,40719,21,3,57,2,9647.34,NULL,'2023-05-12 20:51:51','2023-05-12 20:53:19','2023-05-12 20:53:19'),(2095,7566,681,40719,21,3,217,1,29830.97,NULL,'2023-05-12 20:51:51','2023-05-12 20:53:04','2023-05-12 20:53:04'),(2096,7566,681,40719,21,3,68,1,4506.75,NULL,'2023-05-12 20:51:51','2023-05-12 20:53:04','2023-05-12 20:53:04'),(2097,7566,681,40719,21,3,57,2,34337.72,NULL,'2023-05-12 20:51:51','2023-05-12 20:53:04','2023-05-12 20:53:04'),(2098,7566,682,40719,21,3,217,1,4958.68,NULL,'2023-05-12 20:51:51','2023-05-12 20:52:46','2023-05-12 20:52:46'),(2099,7566,682,40719,21,3,68,1,1041.32,NULL,'2023-05-12 20:51:51','2023-05-12 20:52:46','2023-05-12 20:52:46'),(2100,7566,682,40719,21,3,57,2,6000.00,NULL,'2023-05-12 20:51:51','2023-05-12 20:52:46','2023-05-12 20:52:46'),(2101,7566,683,40719,21,3,135,1,4958.68,NULL,'2023-05-12 20:52:46','2023-05-12 20:52:46',NULL),(2102,7566,683,40719,21,3,68,1,1041.32,NULL,'2023-05-12 20:52:46','2023-05-12 20:52:46',NULL),(2103,7566,683,40719,21,3,57,2,6000.00,NULL,'2023-05-12 20:52:46','2023-05-12 20:52:46',NULL),(2104,7566,684,40719,21,3,135,1,29830.97,NULL,'2023-05-12 20:53:04','2023-05-12 20:53:04',NULL),(2105,7566,684,40719,21,3,68,1,3132.25,NULL,'2023-05-12 20:53:04','2023-05-12 20:53:04',NULL),(2106,7566,684,40719,21,3,57,2,32963.22,NULL,'2023-05-12 20:53:04','2023-05-12 20:53:04',NULL),(2107,7566,685,40719,21,3,135,1,7973.01,NULL,'2023-05-12 20:53:19','2023-05-12 20:53:19',NULL);
INSERT INTO `balance_libro_details` VALUES (2108,7566,685,40719,21,3,68,1,1674.33,NULL,'2023-05-12 20:53:19','2023-05-12 20:53:19',NULL),(2109,7566,685,40719,21,3,57,2,9647.34,NULL,'2023-05-12 20:53:19','2023-05-12 20:53:19',NULL),(2110,7566,686,40719,21,3,135,1,19000.00,NULL,'2023-05-12 20:53:33','2023-05-12 20:53:33',NULL),(2111,7566,686,40719,21,3,57,2,19000.00,NULL,'2023-05-12 20:53:33','2023-05-12 20:53:33',NULL),(2112,7566,687,40719,21,3,135,1,39658.63,NULL,'2023-05-12 20:53:47','2023-05-12 20:53:47',NULL),(2113,7566,687,40719,21,3,57,2,39658.63,NULL,'2023-05-12 20:53:47','2023-05-12 20:53:47',NULL),(2114,7566,688,40719,9,2,218,2,2500.00,NULL,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(2115,7566,688,40719,9,2,13,1,2500.00,NULL,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(2116,7566,689,40719,9,2,218,2,2500.00,NULL,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(2117,7566,689,40719,9,2,13,1,2500.00,NULL,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(2118,7566,690,40719,9,2,218,2,2500.00,NULL,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(2119,7566,690,40719,9,2,13,1,2500.00,NULL,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(2120,7566,691,40719,9,2,218,2,2000.00,NULL,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(2121,7566,691,40719,9,2,13,1,2000.00,NULL,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(2122,7566,692,40719,9,2,218,2,3000.00,NULL,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(2123,7566,692,40719,9,2,13,1,3000.00,NULL,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(2124,7566,693,40719,9,2,218,2,3500.00,NULL,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(2125,7566,693,40719,9,2,13,1,3500.00,NULL,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(2126,7566,694,40719,9,2,218,2,2000.00,NULL,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(2127,7566,694,40719,9,2,13,1,2000.00,NULL,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(2128,7566,695,40719,9,2,218,2,7000.00,NULL,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(2129,7566,695,40719,9,2,13,1,7000.00,NULL,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(2130,7566,696,40719,9,2,218,2,3500.00,NULL,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(2131,7566,696,40719,9,2,13,1,3500.00,NULL,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(2132,7566,697,40719,9,2,218,2,2500.00,NULL,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(2133,7566,697,40719,9,2,13,1,2500.00,NULL,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(2134,7566,698,40719,9,2,218,2,2000.00,NULL,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(2135,7566,698,40719,9,2,13,1,2000.00,NULL,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(2136,7566,699,40719,9,2,218,2,2000.00,NULL,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(2137,7566,699,40719,9,2,13,1,2000.00,NULL,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(2138,7566,700,40719,9,2,218,2,2500.00,NULL,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(2139,7566,700,40719,9,2,13,1,2500.00,NULL,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(2140,7566,701,40719,9,2,218,2,2500.00,NULL,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(2141,7566,701,40719,9,2,13,1,2500.00,NULL,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(2142,7566,702,40719,9,2,218,2,5000.00,NULL,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(2143,7566,702,40719,9,2,13,1,5000.00,NULL,'2023-05-12 21:18:42','2023-05-12 21:18:42',NULL),(2144,7566,703,40719,10,2,218,2,2500.00,NULL,'2023-05-12 21:19:24','2023-05-12 21:19:24',NULL),(2145,7566,703,40719,10,2,13,1,2500.00,NULL,'2023-05-12 21:19:24','2023-05-12 21:19:24',NULL),(2146,7566,704,40719,10,2,218,2,3000.00,NULL,'2023-05-12 21:19:24','2023-05-12 21:19:24',NULL),(2147,7566,704,40719,10,2,13,1,3000.00,NULL,'2023-05-12 21:19:24','2023-05-12 21:19:24',NULL),(2148,7566,705,40719,10,2,218,2,3000.00,NULL,'2023-05-12 21:19:24','2023-05-12 21:19:24',NULL),(2149,7566,705,40719,10,2,13,1,3000.00,NULL,'2023-05-12 21:19:24','2023-05-12 21:19:24',NULL);
INSERT INTO `balance_libro_details` VALUES (2150,7566,706,40719,10,2,218,2,5000.00,NULL,'2023-05-12 21:19:24','2023-05-12 21:19:24',NULL),(2151,7566,706,40719,10,2,13,1,5000.00,NULL,'2023-05-12 21:19:24','2023-05-12 21:19:24',NULL),(2152,7566,707,40719,10,2,218,2,2500.00,NULL,'2023-05-12 21:19:24','2023-05-12 21:19:24',NULL),(2153,7566,707,40719,10,2,13,1,2500.00,NULL,'2023-05-12 21:19:24','2023-05-12 21:19:24',NULL),(2154,7566,708,40719,10,2,218,2,3000.00,NULL,'2023-05-12 21:19:24','2023-05-12 21:19:24',NULL),(2155,7566,708,40719,10,2,13,1,3000.00,NULL,'2023-05-12 21:19:24','2023-05-12 21:19:24',NULL),(2156,7566,709,40719,10,2,218,2,3500.00,NULL,'2023-05-12 21:19:24','2023-05-12 21:19:24',NULL),(2157,7566,709,40719,10,2,13,1,3500.00,NULL,'2023-05-12 21:19:24','2023-05-12 21:19:24',NULL),(2158,7566,710,40719,10,2,218,2,2000.00,NULL,'2023-05-12 21:19:24','2023-05-12 21:19:24',NULL),(2159,7566,710,40719,10,2,13,1,2000.00,NULL,'2023-05-12 21:19:24','2023-05-12 21:19:24',NULL),(2160,7566,711,40719,10,2,218,2,7000.00,NULL,'2023-05-12 21:19:24','2023-05-12 21:19:24',NULL),(2161,7566,711,40719,10,2,13,1,7000.00,NULL,'2023-05-12 21:19:24','2023-05-12 21:19:24',NULL),(2162,7566,712,40719,10,2,218,2,3500.00,NULL,'2023-05-12 21:19:24','2023-05-12 21:19:24',NULL),(2163,7566,712,40719,10,2,13,1,3500.00,NULL,'2023-05-12 21:19:24','2023-05-12 21:19:24',NULL),(2164,7566,713,40719,10,2,218,2,3000.00,NULL,'2023-05-12 21:19:25','2023-05-12 21:19:25',NULL),(2165,7566,713,40719,10,2,13,1,3000.00,NULL,'2023-05-12 21:19:25','2023-05-12 21:19:25',NULL),(2166,7566,714,40719,10,2,218,2,2500.00,NULL,'2023-05-12 21:19:25','2023-05-12 21:19:25',NULL),(2167,7566,714,40719,10,2,13,1,2500.00,NULL,'2023-05-12 21:19:25','2023-05-12 21:19:25',NULL),(2168,7566,715,40719,10,2,218,2,2000.00,NULL,'2023-05-12 21:19:25','2023-05-12 21:19:25',NULL),(2169,7566,715,40719,10,2,13,1,2000.00,NULL,'2023-05-12 21:19:25','2023-05-12 21:19:25',NULL),(2170,7566,716,40719,10,2,218,2,2500.00,NULL,'2023-05-12 21:19:25','2023-05-12 21:19:25',NULL),(2171,7566,716,40719,10,2,13,1,2500.00,NULL,'2023-05-12 21:19:25','2023-05-12 21:19:25',NULL),(2172,7566,717,40719,10,2,218,2,2000.00,NULL,'2023-05-12 21:19:25','2023-05-12 21:19:25',NULL),(2173,7566,717,40719,10,2,13,1,2000.00,NULL,'2023-05-12 21:19:25','2023-05-12 21:19:25',NULL),(2174,7566,718,40719,10,2,218,2,2500.00,NULL,'2023-05-12 21:19:25','2023-05-12 21:19:25',NULL),(2175,7566,718,40719,10,2,13,1,2500.00,NULL,'2023-05-12 21:19:25','2023-05-12 21:19:25',NULL),(2176,7566,719,40719,10,2,218,2,2500.00,NULL,'2023-05-12 21:19:25','2023-05-12 21:19:25',NULL),(2177,7566,719,40719,10,2,13,1,2500.00,NULL,'2023-05-12 21:19:25','2023-05-12 21:19:25',NULL),(2178,7566,720,40719,10,2,218,1,2000.00,NULL,'2023-05-12 21:19:25','2023-05-12 21:19:25',NULL),(2179,7566,720,40719,10,2,13,2,2000.00,NULL,'2023-05-12 21:19:25','2023-05-12 21:19:25',NULL),(2180,7566,721,40719,10,2,218,1,2500.00,NULL,'2023-05-12 21:19:25','2023-05-12 21:19:25',NULL),(2181,7566,721,40719,10,2,13,2,2500.00,NULL,'2023-05-12 21:19:25','2023-05-12 21:19:25',NULL),(2182,7566,722,40719,12,2,218,2,3000.00,NULL,'2023-05-12 21:20:11','2023-05-12 21:20:11',NULL),(2183,7566,722,40719,12,2,13,1,3000.00,NULL,'2023-05-12 21:20:11','2023-05-12 21:20:11',NULL),(2184,7566,723,40719,12,2,218,2,2000.00,NULL,'2023-05-12 21:20:12','2023-05-12 21:20:12',NULL),(2185,7566,723,40719,12,2,13,1,2000.00,NULL,'2023-05-12 21:20:12','2023-05-12 21:20:12',NULL),(2186,7566,724,40719,12,2,218,2,7000.00,NULL,'2023-05-12 21:20:12','2023-05-12 21:20:12',NULL),(2187,7566,724,40719,12,2,13,1,7000.00,NULL,'2023-05-12 21:20:12','2023-05-12 21:20:12',NULL),(2188,7566,725,40719,12,2,218,2,3500.00,NULL,'2023-05-12 21:20:12','2023-05-12 21:20:12',NULL),(2189,7566,725,40719,12,2,13,1,3500.00,NULL,'2023-05-12 21:20:12','2023-05-12 21:20:12',NULL),(2190,7566,726,40719,12,2,218,2,3000.00,NULL,'2023-05-12 21:20:12','2023-05-12 21:20:12',NULL),(2191,7566,726,40719,12,2,13,1,3000.00,NULL,'2023-05-12 21:20:12','2023-05-12 21:20:12',NULL);
INSERT INTO `balance_libro_details` VALUES (2192,7566,727,40719,12,2,218,2,2500.00,NULL,'2023-05-12 21:20:12','2023-05-12 21:20:12',NULL),(2193,7566,727,40719,12,2,13,1,2500.00,NULL,'2023-05-12 21:20:12','2023-05-12 21:20:12',NULL),(2194,7566,728,40719,12,2,218,2,2000.00,NULL,'2023-05-12 21:20:12','2023-05-12 21:20:12',NULL),(2195,7566,728,40719,12,2,13,1,2000.00,NULL,'2023-05-12 21:20:12','2023-05-12 21:20:12',NULL),(2196,7566,729,40719,12,2,218,2,2500.00,NULL,'2023-05-12 21:20:12','2023-05-12 21:20:12',NULL),(2197,7566,729,40719,12,2,13,1,2500.00,NULL,'2023-05-12 21:20:12','2023-05-12 21:20:12',NULL),(2198,7566,730,40719,12,2,218,2,2500.00,NULL,'2023-05-12 21:20:12','2023-05-12 21:20:12',NULL),(2199,7566,730,40719,12,2,13,1,2500.00,NULL,'2023-05-12 21:20:12','2023-05-12 21:20:12',NULL),(2200,7566,731,40719,12,2,218,2,2500.00,NULL,'2023-05-12 21:20:12','2023-05-12 21:20:12',NULL),(2201,7566,731,40719,12,2,13,1,2500.00,NULL,'2023-05-12 21:20:12','2023-05-12 21:20:12',NULL),(2202,7566,732,40719,12,2,218,2,2500.00,NULL,'2023-05-12 21:20:12','2023-05-12 21:20:12',NULL),(2203,7566,732,40719,12,2,13,1,2500.00,NULL,'2023-05-12 21:20:12','2023-05-12 21:20:12',NULL),(2204,7566,733,40719,12,2,218,2,3000.00,NULL,'2023-05-12 21:20:12','2023-05-12 21:20:12',NULL),(2205,7566,733,40719,12,2,13,1,3000.00,NULL,'2023-05-12 21:20:12','2023-05-12 21:20:12',NULL),(2206,7566,734,40719,12,2,218,2,2500.00,NULL,'2023-05-12 21:20:12','2023-05-12 21:20:12',NULL),(2207,7566,734,40719,12,2,13,1,2500.00,NULL,'2023-05-12 21:20:12','2023-05-12 21:20:12',NULL),(2208,7566,735,40719,13,2,218,2,2500.00,NULL,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(2209,7566,735,40719,13,2,13,1,2500.00,NULL,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(2210,7566,736,40719,13,2,218,2,3000.00,NULL,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(2211,7566,736,40719,13,2,13,1,3000.00,NULL,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(2212,7566,737,40719,13,2,218,2,5000.00,NULL,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(2213,7566,737,40719,13,2,13,1,5000.00,NULL,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(2214,7566,738,40719,13,2,218,2,2500.00,NULL,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(2215,7566,738,40719,13,2,13,1,2500.00,NULL,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(2216,7566,739,40719,13,2,218,2,3000.00,NULL,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(2217,7566,739,40719,13,2,13,1,3000.00,NULL,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(2218,7566,740,40719,13,2,218,2,2000.00,NULL,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(2219,7566,740,40719,13,2,13,1,2000.00,NULL,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(2220,7566,741,40719,13,2,218,2,5000.00,NULL,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(2221,7566,741,40719,13,2,13,1,5000.00,NULL,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(2222,7566,742,40719,13,2,218,2,3500.00,NULL,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(2223,7566,742,40719,13,2,13,1,3500.00,NULL,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(2224,7566,743,40719,13,2,218,2,3000.00,NULL,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(2225,7566,743,40719,13,2,13,1,3000.00,NULL,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(2226,7566,744,40719,13,2,218,2,2500.00,NULL,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(2227,7566,744,40719,13,2,13,1,2500.00,NULL,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(2228,7566,745,40719,13,2,218,2,2000.00,NULL,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(2229,7566,745,40719,13,2,13,1,2000.00,NULL,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(2230,7566,746,40719,13,2,218,2,2500.00,NULL,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(2231,7566,746,40719,13,2,13,1,2500.00,NULL,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(2232,7566,747,40719,13,2,218,2,2500.00,NULL,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(2233,7566,747,40719,13,2,13,1,2500.00,NULL,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL);
INSERT INTO `balance_libro_details` VALUES (2234,7566,748,40719,13,2,218,2,2500.00,NULL,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(2235,7566,748,40719,13,2,13,1,2500.00,NULL,'2023-05-12 21:20:46','2023-05-12 21:20:46',NULL),(2236,7566,749,40719,14,2,218,2,3000.00,NULL,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(2237,7566,749,40719,14,2,13,1,3000.00,NULL,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(2238,7566,750,40719,14,2,218,2,3600.00,NULL,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(2239,7566,750,40719,14,2,13,1,3600.00,NULL,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(2240,7566,751,40719,14,2,218,2,6000.00,NULL,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(2241,7566,751,40719,14,2,13,1,6000.00,NULL,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(2242,7566,752,40719,14,2,218,2,3000.00,NULL,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(2243,7566,752,40719,14,2,13,1,3000.00,NULL,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(2244,7566,753,40719,14,2,218,2,14000.00,NULL,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(2245,7566,753,40719,14,2,13,1,14000.00,NULL,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(2246,7566,754,40719,14,2,218,2,3600.00,NULL,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(2247,7566,754,40719,14,2,13,1,3600.00,NULL,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(2248,7566,755,40719,14,2,218,2,2500.00,NULL,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(2249,7566,755,40719,14,2,13,1,2500.00,NULL,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(2250,7566,756,40719,14,2,218,2,4180.00,NULL,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(2251,7566,756,40719,14,2,13,1,4180.00,NULL,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(2252,7566,757,40719,14,2,218,2,3600.00,NULL,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(2253,7566,757,40719,14,2,13,1,3600.00,NULL,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(2254,7566,758,40719,14,2,218,2,3000.00,NULL,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(2255,7566,758,40719,14,2,13,1,3000.00,NULL,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(2256,7566,759,40719,14,2,218,2,2400.00,NULL,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(2257,7566,759,40719,14,2,13,1,2400.00,NULL,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(2258,7566,760,40719,14,2,218,2,3000.00,NULL,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(2259,7566,760,40719,14,2,13,1,3000.00,NULL,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(2260,7566,761,40719,14,2,218,2,3000.00,NULL,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(2261,7566,761,40719,14,2,13,1,3000.00,NULL,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(2262,7566,762,40719,14,2,218,2,3000.00,NULL,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(2263,7566,762,40719,14,2,13,1,3000.00,NULL,'2023-05-12 21:21:00','2023-05-12 21:21:00',NULL),(2264,7566,763,40719,11,2,218,2,2500.00,NULL,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(2265,7566,763,40719,11,2,13,1,2500.00,NULL,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(2266,7566,764,40719,11,2,218,2,3000.00,NULL,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(2267,7566,764,40719,11,2,13,1,3000.00,NULL,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(2268,7566,765,40719,11,2,218,2,3000.00,NULL,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(2269,7566,765,40719,11,2,13,1,3000.00,NULL,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(2270,7566,766,40719,11,2,218,2,5000.00,NULL,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(2271,7566,766,40719,11,2,13,1,5000.00,NULL,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(2272,7566,767,40719,11,2,218,2,2500.00,NULL,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(2273,7566,767,40719,11,2,13,1,2500.00,NULL,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(2274,7566,768,40719,11,2,218,2,2500.00,NULL,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(2275,7566,768,40719,11,2,13,1,2500.00,NULL,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL);
INSERT INTO `balance_libro_details` VALUES (2276,7566,769,40719,11,2,218,2,3500.00,NULL,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(2277,7566,769,40719,11,2,13,1,3500.00,NULL,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(2278,7566,770,40719,11,2,218,2,2000.00,NULL,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(2279,7566,770,40719,11,2,13,1,2000.00,NULL,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(2280,7566,771,40719,11,2,218,2,7000.00,NULL,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(2281,7566,771,40719,11,2,13,1,7000.00,NULL,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(2282,7566,772,40719,11,2,218,2,3500.00,NULL,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(2283,7566,772,40719,11,2,13,1,3500.00,NULL,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(2284,7566,773,40719,11,2,218,2,3000.00,NULL,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(2285,7566,773,40719,11,2,13,1,3000.00,NULL,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(2286,7566,774,40719,11,2,218,2,2500.00,NULL,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(2287,7566,774,40719,11,2,13,1,2500.00,NULL,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(2288,7566,775,40719,11,2,218,2,2000.00,NULL,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(2289,7566,775,40719,11,2,13,1,2000.00,NULL,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(2290,7566,776,40719,11,2,218,2,2500.00,NULL,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(2291,7566,776,40719,11,2,13,1,2500.00,NULL,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(2292,7566,777,40719,11,2,218,2,2500.00,NULL,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(2293,7566,777,40719,11,2,13,1,2500.00,NULL,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(2294,7566,778,40719,11,2,218,2,3500.00,NULL,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(2295,7566,778,40719,11,2,13,1,3500.00,NULL,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(2296,7566,779,40719,11,2,218,2,2500.00,NULL,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(2297,7566,779,40719,11,2,13,1,2500.00,NULL,'2023-05-12 21:22:45','2023-05-12 21:22:45',NULL),(2298,7566,780,40719,11,2,218,1,3500.00,NULL,'2023-05-12 21:22:46','2023-05-12 21:22:46',NULL),(2299,7566,780,40719,11,2,13,2,3500.00,NULL,'2023-05-12 21:22:46','2023-05-12 21:22:46',NULL),(2300,7566,781,40720,1536,2,96,2,127966.24,NULL,'2023-05-16 17:50:42','2023-05-16 17:50:42',NULL),(2301,7566,781,40720,1536,2,67,2,26872.91,NULL,'2023-05-16 17:50:42','2023-05-16 17:50:42',NULL),(2302,7566,781,40720,1536,2,13,1,154839.15,NULL,'2023-05-16 17:50:42','2023-05-16 17:50:42',NULL),(2303,7566,782,40720,1536,2,96,2,216160.93,NULL,'2023-05-16 17:50:42','2023-05-16 17:50:42',NULL),(2304,7566,782,40720,1536,2,67,2,45393.80,NULL,'2023-05-16 17:50:42','2023-05-16 17:50:42',NULL),(2305,7566,782,40720,1536,2,13,1,261554.73,NULL,'2023-05-16 17:50:42','2023-05-16 17:50:42',NULL),(2306,7566,783,40720,1536,2,96,2,4236.79,NULL,'2023-05-16 17:50:42','2023-05-16 17:50:42',NULL),(2307,7566,783,40720,1536,2,67,2,889.73,NULL,'2023-05-16 17:50:42','2023-05-16 17:50:42',NULL),(2308,7566,783,40720,1536,2,13,1,5126.52,NULL,'2023-05-16 17:50:42','2023-05-16 17:50:42',NULL),(2309,7566,784,40720,1536,2,96,2,8583.72,NULL,'2023-05-16 17:50:42','2023-05-16 17:50:42',NULL),(2310,7566,784,40720,1536,2,67,2,1802.58,NULL,'2023-05-16 17:50:42','2023-05-16 17:50:42',NULL),(2311,7566,784,40720,1536,2,13,1,10386.30,NULL,'2023-05-16 17:50:42','2023-05-16 17:50:42',NULL),(2312,7566,785,40720,1536,2,218,2,0.00,NULL,'2023-05-16 17:50:42','2023-05-16 17:50:42',NULL),(2313,7566,785,40720,1536,2,218,2,4568.06,NULL,'2023-05-16 17:50:42','2023-05-16 17:50:42',NULL),(2314,7566,785,40720,1536,2,13,1,4568.06,NULL,'2023-05-16 17:50:42','2023-05-16 17:50:42',NULL),(2315,7566,786,40720,1536,2,96,2,262038.11,NULL,'2023-05-16 17:50:42','2023-05-16 17:50:42',NULL),(2316,7566,786,40720,1536,2,67,2,55028.00,NULL,'2023-05-16 17:50:42','2023-05-16 17:50:42',NULL);
INSERT INTO `balance_libro_details` VALUES (2317,7566,786,40720,1536,2,13,1,317066.11,NULL,'2023-05-16 17:50:42','2023-05-16 17:50:42',NULL),(2318,7566,787,40720,1536,3,250,1,0.00,NULL,'2023-05-16 17:50:53','2023-05-16 20:03:41','2023-05-16 20:03:41'),(2319,7566,787,40720,1536,3,250,1,16666.16,NULL,'2023-05-16 17:50:53','2023-05-16 20:03:41','2023-05-16 20:03:41'),(2320,7566,787,40720,1536,3,57,2,16666.16,NULL,'2023-05-16 17:50:53','2023-05-16 20:03:41','2023-05-16 20:03:41'),(2321,7566,788,40720,1536,3,135,1,412.31,NULL,'2023-05-16 17:50:53','2023-05-16 18:43:56','2023-05-16 18:43:56'),(2322,7566,788,40720,1536,3,68,1,86.59,NULL,'2023-05-16 17:50:53','2023-05-16 18:43:56','2023-05-16 18:43:56'),(2323,7566,788,40720,1536,3,57,2,498.90,NULL,'2023-05-16 17:50:53','2023-05-16 18:43:56','2023-05-16 18:43:56'),(2324,7566,789,40720,1536,3,199,1,2809.92,NULL,'2023-05-16 17:50:53','2023-05-16 17:50:53',NULL),(2325,7566,789,40720,1536,3,68,1,590.08,NULL,'2023-05-16 17:50:53','2023-05-16 17:50:53',NULL),(2326,7566,789,40720,1536,3,57,2,3400.00,NULL,'2023-05-16 17:50:53','2023-05-16 17:50:53',NULL),(2327,7566,790,40720,1536,3,483,1,1768.60,NULL,'2023-05-16 17:50:53','2023-05-16 17:50:53',NULL),(2328,7566,790,40720,1536,3,68,1,371.40,NULL,'2023-05-16 17:50:53','2023-05-16 17:50:53',NULL),(2329,7566,790,40720,1536,3,57,2,2140.00,NULL,'2023-05-16 17:50:53','2023-05-16 17:50:53',NULL),(2330,7566,791,40720,1536,3,135,1,10500.00,NULL,'2023-05-16 17:50:53','2023-05-16 18:42:40','2023-05-16 18:42:40'),(2331,7566,791,40720,1536,3,57,2,10500.00,NULL,'2023-05-16 17:50:53','2023-05-16 18:42:40','2023-05-16 18:42:40'),(2332,7566,792,40720,1536,3,116,1,11250.00,NULL,'2023-05-16 17:50:53','2023-05-16 18:49:00','2023-05-16 18:49:00'),(2333,7566,792,40720,1536,3,57,2,11250.00,NULL,'2023-05-16 17:50:53','2023-05-16 18:49:00','2023-05-16 18:49:00'),(2334,7566,793,40720,1536,3,193,1,4707.00,NULL,'2023-05-16 17:50:53','2023-05-16 18:10:06','2023-05-16 18:10:06'),(2335,7566,793,40720,1536,3,68,1,1204.47,NULL,'2023-05-16 17:50:53','2023-05-16 18:10:06','2023-05-16 18:10:06'),(2336,7566,793,40720,1536,3,193,1,575.50,NULL,'2023-05-16 17:50:53','2023-05-16 18:10:06','2023-05-16 18:10:06'),(2337,7566,793,40720,1536,3,57,2,6486.97,NULL,'2023-05-16 17:50:53','2023-05-16 18:10:06','2023-05-16 18:10:06'),(2338,7566,794,40720,1536,3,250,1,40000.00,NULL,'2023-05-16 17:50:54','2023-05-16 18:47:51','2023-05-16 18:47:51'),(2339,7566,794,40720,1536,3,57,2,40000.00,NULL,'2023-05-16 17:50:54','2023-05-16 18:47:51','2023-05-16 18:47:51'),(2340,7566,795,40720,1536,3,483,1,2066.12,NULL,'2023-05-16 17:50:54','2023-05-16 18:17:03','2023-05-16 18:17:03'),(2341,7566,795,40720,1536,3,68,1,433.88,NULL,'2023-05-16 17:50:54','2023-05-16 18:17:03','2023-05-16 18:17:03'),(2342,7566,795,40720,1536,3,57,2,2500.00,NULL,'2023-05-16 17:50:54','2023-05-16 18:17:03','2023-05-16 18:17:03'),(2343,7566,796,40720,1536,3,199,1,4347.11,NULL,'2023-05-16 17:50:54','2023-05-16 18:07:02','2023-05-16 18:07:02'),(2344,7566,796,40720,1536,3,68,1,912.89,NULL,'2023-05-16 17:50:54','2023-05-16 18:07:02','2023-05-16 18:07:02'),(2345,7566,796,40720,1536,3,199,1,173.88,NULL,'2023-05-16 17:50:54','2023-05-16 18:07:02','2023-05-16 18:07:02'),(2346,7566,796,40720,1536,3,57,2,5433.88,NULL,'2023-05-16 17:50:54','2023-05-16 18:07:02','2023-05-16 18:07:02'),(2347,7566,797,40720,1536,3,217,1,14875.21,NULL,'2023-05-16 17:50:54','2023-05-16 18:14:16','2023-05-16 18:14:16'),(2348,7566,797,40720,1536,3,68,1,3123.79,NULL,'2023-05-16 17:50:54','2023-05-16 18:14:16','2023-05-16 18:14:16'),(2349,7566,797,40720,1536,3,57,2,17999.00,NULL,'2023-05-16 17:50:54','2023-05-16 18:14:16','2023-05-16 18:14:16'),(2350,7566,798,40720,1536,3,217,1,6666.97,NULL,'2023-05-16 17:50:54','2023-05-16 18:41:50','2023-05-16 18:41:50'),(2351,7566,798,40720,1536,3,68,1,1400.06,NULL,'2023-05-16 17:50:54','2023-05-16 18:41:50','2023-05-16 18:41:50'),(2352,7566,798,40720,1536,3,217,1,1341.19,NULL,'2023-05-16 17:50:54','2023-05-16 18:41:50','2023-05-16 18:41:50');
INSERT INTO `balance_libro_details` VALUES (2353,7566,798,40720,1536,3,57,2,9408.22,NULL,'2023-05-16 17:50:54','2023-05-16 18:41:50','2023-05-16 18:41:50'),(2354,7566,799,40720,1536,3,217,1,6198.35,NULL,'2023-05-16 17:50:54','2023-05-16 18:34:45','2023-05-16 18:34:45'),(2355,7566,799,40720,1536,3,68,1,1301.65,NULL,'2023-05-16 17:50:54','2023-05-16 18:34:45','2023-05-16 18:34:45'),(2356,7566,799,40720,1536,3,57,2,7500.00,NULL,'2023-05-16 17:50:54','2023-05-16 18:34:45','2023-05-16 18:34:45'),(2357,7566,800,40720,1536,3,217,1,4132.23,NULL,'2023-05-16 17:50:54','2023-05-16 18:16:20','2023-05-16 18:16:20'),(2358,7566,800,40720,1536,3,68,1,867.77,NULL,'2023-05-16 17:50:54','2023-05-16 18:16:20','2023-05-16 18:16:20'),(2359,7566,800,40720,1536,3,57,2,5000.00,NULL,'2023-05-16 17:50:54','2023-05-16 18:16:20','2023-05-16 18:16:20'),(2360,7566,801,40720,1536,3,135,1,14000.00,NULL,'2023-05-16 17:50:54','2023-05-16 17:50:54',NULL),(2361,7566,801,40720,1536,3,57,2,14000.00,NULL,'2023-05-16 17:50:54','2023-05-16 17:50:54',NULL),(2362,7566,802,40720,1536,3,135,1,14000.00,NULL,'2023-05-16 17:50:54','2023-05-16 18:43:27','2023-05-16 18:43:27'),(2363,7566,802,40720,1536,3,57,2,14000.00,NULL,'2023-05-16 17:50:54','2023-05-16 18:43:27','2023-05-16 18:43:27'),(2364,7566,803,40720,1536,3,199,1,6371.90,NULL,'2023-05-16 18:06:35','2023-05-16 18:06:35',NULL),(2365,7566,803,40720,1536,3,68,1,1338.10,NULL,'2023-05-16 18:06:35','2023-05-16 18:06:35',NULL),(2366,7566,803,40720,1536,3,220,1,191.16,NULL,'2023-05-16 18:06:35','2023-05-16 18:06:35',NULL),(2367,7566,803,40720,1536,3,241,1,63.72,NULL,'2023-05-16 18:06:35','2023-05-16 18:06:35',NULL),(2368,7566,803,40720,1536,3,57,2,7964.88,NULL,'2023-05-16 18:06:35','2023-05-16 18:06:35',NULL),(2369,7566,804,40720,1536,3,193,1,3600.00,NULL,'2023-05-16 18:10:06','2023-05-16 18:10:06',NULL),(2370,7566,804,40720,1536,3,68,1,972.00,NULL,'2023-05-16 18:10:06','2023-05-16 18:10:06',NULL),(2371,7566,804,40720,1536,3,193,1,1107.00,NULL,'2023-05-16 18:10:06','2023-05-16 18:10:06',NULL),(2372,7566,804,40720,1536,3,68,1,232.47,NULL,'2023-05-16 18:10:06','2023-05-16 18:10:06',NULL),(2373,7566,804,40720,1536,3,193,1,189.47,NULL,'2023-05-16 18:10:06','2023-05-16 18:10:06',NULL),(2374,7566,804,40720,1536,3,220,1,141.21,NULL,'2023-05-16 18:10:06','2023-05-16 18:10:06',NULL),(2375,7566,804,40720,1536,3,241,1,244.82,NULL,'2023-05-16 18:10:06','2023-05-16 18:10:06',NULL),(2376,7566,804,40720,1536,3,57,2,6486.97,NULL,'2023-05-16 18:10:06','2023-05-16 18:10:06',NULL),(2377,7566,805,40720,1536,3,135,1,14875.21,NULL,'2023-05-16 18:14:16','2023-05-16 18:14:16',NULL),(2378,7566,805,40720,1536,3,68,1,3123.79,NULL,'2023-05-16 18:14:16','2023-05-16 18:14:16',NULL),(2379,7566,805,40720,1536,3,57,2,17999.00,NULL,'2023-05-16 18:14:16','2023-05-16 18:14:16',NULL),(2380,7566,806,40720,1536,3,135,1,4132.23,NULL,'2023-05-16 18:16:20','2023-05-16 18:16:20',NULL),(2381,7566,806,40720,1536,3,68,1,867.77,NULL,'2023-05-16 18:16:20','2023-05-16 18:16:20',NULL),(2382,7566,806,40720,1536,3,57,2,5000.00,NULL,'2023-05-16 18:16:20','2023-05-16 18:16:20',NULL),(2383,7566,807,40720,1536,3,483,1,2066.12,NULL,'2023-05-16 18:17:03','2023-05-16 18:17:03',NULL),(2384,7566,807,40720,1536,3,68,1,433.89,NULL,'2023-05-16 18:17:03','2023-05-16 18:17:03',NULL),(2385,7566,807,40720,1536,3,57,2,2500.01,NULL,'2023-05-16 18:17:03','2023-05-16 18:17:03',NULL),(2386,7566,808,40720,1536,3,484,1,809.92,NULL,'2023-05-16 18:22:16','2023-05-16 18:22:16',NULL),(2387,7566,808,40720,1536,3,68,1,170.08,NULL,'2023-05-16 18:22:16','2023-05-16 18:22:16',NULL),(2388,7566,808,40720,1536,3,57,2,980.00,NULL,'2023-05-16 18:22:16','2023-05-16 18:22:16',NULL),(2389,7566,809,40720,1536,3,485,1,49000.00,NULL,'2023-05-16 18:29:45','2023-05-16 18:29:45',NULL),(2390,7566,809,40720,1536,3,68,1,10290.00,NULL,'2023-05-16 18:29:45','2023-05-16 18:29:45',NULL),(2391,7566,809,40720,1536,3,57,2,59290.00,NULL,'2023-05-16 18:29:45','2023-05-16 18:29:45',NULL),(2392,7566,810,40720,1536,3,485,1,48500.00,NULL,'2023-05-16 18:30:30','2023-05-16 18:30:30',NULL);
INSERT INTO `balance_libro_details` VALUES (2393,7566,810,40720,1536,3,68,1,10185.00,NULL,'2023-05-16 18:30:30','2023-05-16 18:30:30',NULL),(2394,7566,810,40720,1536,3,57,2,58685.00,NULL,'2023-05-16 18:30:30','2023-05-16 18:30:30',NULL),(2395,7566,811,40720,1536,3,484,1,6566.74,NULL,'2023-05-16 18:33:09','2023-05-16 18:33:09',NULL),(2396,7566,811,40720,1536,3,68,1,1379.02,NULL,'2023-05-16 18:33:09','2023-05-16 18:33:09',NULL),(2397,7566,811,40720,1536,3,484,1,54.74,NULL,'2023-05-16 18:33:09','2023-05-16 18:33:09',NULL),(2398,7566,811,40720,1536,3,241,1,65.67,NULL,'2023-05-16 18:33:09','2023-05-16 18:33:09',NULL),(2399,7566,811,40720,1536,3,57,2,8066.17,NULL,'2023-05-16 18:33:09','2023-05-16 18:33:09',NULL),(2400,7566,812,40720,1536,3,135,1,6198.35,NULL,'2023-05-16 18:34:45','2023-05-16 18:34:45',NULL),(2401,7566,812,40720,1536,3,68,1,1301.65,NULL,'2023-05-16 18:34:45','2023-05-16 18:34:45',NULL),(2402,7566,812,40720,1536,3,57,2,7500.00,NULL,'2023-05-16 18:34:45','2023-05-16 18:34:45',NULL),(2403,7566,813,40720,1536,3,135,1,10400.83,NULL,'2023-05-16 18:37:56','2023-05-16 18:37:56',NULL),(2404,7566,813,40720,1536,3,68,1,2184.17,NULL,'2023-05-16 18:37:56','2023-05-16 18:37:56',NULL),(2405,7566,813,40720,1536,3,57,2,12585.00,NULL,'2023-05-16 18:37:56','2023-05-16 18:37:56',NULL),(2406,7566,814,40720,1536,3,135,1,661.16,NULL,'2023-05-16 18:38:29','2023-05-16 18:38:29',NULL),(2407,7566,814,40720,1536,3,68,1,138.84,NULL,'2023-05-16 18:38:29','2023-05-16 18:38:29',NULL),(2408,7566,814,40720,1536,3,57,2,800.00,NULL,'2023-05-16 18:38:29','2023-05-16 18:38:29',NULL),(2409,7566,815,40720,1536,3,135,1,8891.74,NULL,'2023-05-16 18:38:58','2023-05-16 18:38:58',NULL),(2410,7566,815,40720,1536,3,68,1,1867.27,NULL,'2023-05-16 18:38:58','2023-05-16 18:38:58',NULL),(2411,7566,815,40720,1536,3,57,2,10759.01,NULL,'2023-05-16 18:38:58','2023-05-16 18:38:58',NULL),(2412,7566,816,40720,1536,3,484,1,6666.97,NULL,'2023-05-16 18:41:50','2023-05-16 18:41:50',NULL),(2413,7566,816,40720,1536,3,68,1,1400.06,NULL,'2023-05-16 18:41:50','2023-05-16 18:41:50',NULL),(2414,7566,816,40720,1536,3,484,1,1033.18,NULL,'2023-05-16 18:41:50','2023-05-16 18:41:50',NULL),(2415,7566,816,40720,1536,3,239,1,308.01,NULL,'2023-05-16 18:41:50','2023-05-16 18:41:50',NULL),(2416,7566,816,40720,1536,3,57,2,9408.22,NULL,'2023-05-16 18:41:50','2023-05-16 18:41:50',NULL),(2417,7566,817,40720,1536,3,135,1,10500.00,NULL,'2023-05-16 18:42:40','2023-05-16 18:42:40',NULL),(2418,7566,817,40720,1536,3,57,2,10500.00,NULL,'2023-05-16 18:42:40','2023-05-16 18:42:40',NULL),(2419,7566,818,40720,1536,3,135,1,14000.00,NULL,'2023-05-16 18:43:27','2023-05-16 18:43:27',NULL),(2420,7566,818,40720,1536,3,57,2,14000.00,NULL,'2023-05-16 18:43:27','2023-05-16 18:43:27',NULL),(2421,7566,819,40720,1536,3,135,1,412.31,NULL,'2023-05-16 18:43:56','2023-05-16 18:43:56',NULL),(2422,7566,819,40720,1536,3,68,1,86.59,NULL,'2023-05-16 18:43:56','2023-05-16 18:43:56',NULL),(2423,7566,819,40720,1536,3,57,2,498.90,NULL,'2023-05-16 18:43:56','2023-05-16 18:43:56',NULL),(2424,7566,820,40720,1536,3,192,1,40000.00,NULL,'2023-05-16 18:47:51','2023-05-16 18:47:51',NULL),(2425,7566,820,40720,1536,3,57,2,40000.00,NULL,'2023-05-16 18:47:51','2023-05-16 18:47:51',NULL),(2426,7566,821,40720,1536,3,116,1,11250.00,NULL,'2023-05-16 18:49:00','2023-05-16 18:49:00',NULL),(2427,7566,821,40720,1536,3,57,2,11250.00,NULL,'2023-05-16 18:49:00','2023-05-16 18:49:00',NULL),(2428,7566,822,40720,1536,7,25,1,95.65,NULL,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL),(2429,7566,822,40720,1536,7,13,2,95.65,NULL,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL),(2430,7566,823,40720,1536,7,25,1,561.87,NULL,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL),(2431,7566,823,40720,1536,7,13,2,561.87,NULL,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL),(2432,7566,824,40720,1536,7,25,1,833.13,NULL,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL),(2433,7566,824,40720,1536,7,13,2,833.13,NULL,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL);
INSERT INTO `balance_libro_details` VALUES (2434,7566,825,40720,1536,7,25,1,7694.57,NULL,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL),(2435,7566,825,40720,1536,7,13,2,7694.57,NULL,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL),(2436,7566,826,40720,1536,7,25,1,4515.67,NULL,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL),(2437,7566,826,40720,1536,7,13,2,4515.67,NULL,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL),(2438,7566,827,40720,1536,7,25,1,711.78,NULL,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL),(2439,7566,827,40720,1536,7,13,2,711.78,NULL,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL),(2440,7566,828,40720,1536,7,25,1,84.02,NULL,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL),(2441,7566,828,40720,1536,7,13,2,84.02,NULL,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL),(2442,7566,829,40720,1536,7,25,1,262.05,NULL,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL),(2443,7566,829,40720,1536,7,13,2,262.05,NULL,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL),(2444,7566,830,40720,1536,7,25,1,108.98,NULL,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL),(2445,7566,830,40720,1536,7,13,2,108.98,NULL,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL),(2446,7566,831,40720,1536,7,25,1,2901.11,NULL,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL),(2447,7566,831,40720,1536,7,13,2,2901.11,NULL,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL),(2448,7566,832,40720,1536,7,25,1,8318.57,NULL,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL),(2449,7566,832,40720,1536,7,13,2,8318.57,NULL,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL),(2450,7566,833,40720,1536,7,25,1,2463.72,NULL,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL),(2451,7566,833,40720,1536,7,13,2,2463.72,NULL,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL),(2452,7566,834,40720,1536,7,25,1,1540.85,NULL,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL),(2453,7566,834,40720,1536,7,13,2,1540.85,NULL,'2023-05-16 18:53:27','2023-05-16 18:53:27',NULL),(2454,7566,835,40720,1536,8,290,1,381.74,NULL,'2023-05-16 19:56:25','2023-05-16 19:56:25',NULL),(2455,7566,835,40720,1536,8,351,2,381.74,NULL,'2023-05-16 19:56:25','2023-05-16 19:56:25',NULL),(2456,7566,836,40720,1537,2,96,2,151617.38,NULL,'2023-06-17 12:29:56','2023-06-17 12:29:56',NULL),(2457,7566,836,40720,1537,2,67,2,31839.65,NULL,'2023-06-17 12:29:56','2023-06-17 12:29:56',NULL),(2458,7566,836,40720,1537,2,13,1,183457.03,NULL,'2023-06-17 12:29:56','2023-06-17 12:29:56',NULL),(2459,7566,837,40720,1537,2,96,2,174882.07,NULL,'2023-06-17 12:29:56','2023-06-17 12:29:56',NULL),(2460,7566,837,40720,1537,2,67,2,36725.23,NULL,'2023-06-17 12:29:56','2023-06-17 12:29:56',NULL),(2461,7566,837,40720,1537,2,13,1,211607.30,NULL,'2023-06-17 12:29:56','2023-06-17 12:29:56',NULL),(2462,7566,838,40720,1537,2,96,2,8241.77,NULL,'2023-06-17 12:29:56','2023-06-17 12:29:56',NULL),(2463,7566,838,40720,1537,2,67,2,1730.77,NULL,'2023-06-17 12:29:56','2023-06-17 12:29:56',NULL),(2464,7566,838,40720,1537,2,13,1,9972.54,NULL,'2023-06-17 12:29:56','2023-06-17 12:29:56',NULL),(2465,7566,839,40720,1537,2,96,2,4236.79,NULL,'2023-06-17 12:29:56','2023-06-17 12:29:56',NULL),(2466,7566,839,40720,1537,2,67,2,889.73,NULL,'2023-06-17 12:29:56','2023-06-17 12:29:56',NULL),(2467,7566,839,40720,1537,2,13,1,5126.52,NULL,'2023-06-17 12:29:56','2023-06-17 12:29:56',NULL),(2468,7566,840,40720,1537,2,218,2,0.00,NULL,'2023-06-17 12:29:56','2023-06-17 12:29:56',NULL),(2469,7566,840,40720,1537,2,218,2,14148.27,NULL,'2023-06-17 12:29:56','2023-06-17 12:29:56',NULL),(2470,7566,840,40720,1537,2,13,1,14148.27,NULL,'2023-06-17 12:29:56','2023-06-17 12:29:56',NULL),(2471,7566,841,40720,1537,2,96,2,296089.32,NULL,'2023-06-17 12:29:56','2023-06-17 12:29:56',NULL),(2472,7566,841,40720,1537,2,67,2,62178.76,NULL,'2023-06-17 12:29:56','2023-06-17 12:29:56',NULL),(2473,7566,841,40720,1537,2,13,1,358268.08,NULL,'2023-06-17 12:29:56','2023-06-17 12:29:56',NULL),(2474,7566,842,40720,1537,3,250,1,0.00,NULL,'2023-06-17 12:30:07','2023-06-17 13:29:51','2023-06-17 13:29:51');
INSERT INTO `balance_libro_details` VALUES (2475,7566,842,40720,1537,3,250,1,16666.16,NULL,'2023-06-17 12:30:07','2023-06-17 13:29:51','2023-06-17 13:29:51'),(2476,7566,842,40720,1537,3,57,2,16666.16,NULL,'2023-06-17 12:30:07','2023-06-17 13:29:51','2023-06-17 13:29:51'),(2477,7566,843,40720,1537,3,199,1,2809.92,NULL,'2023-06-17 12:30:07','2023-06-17 13:30:23','2023-06-17 13:30:23'),(2478,7566,843,40720,1537,3,68,1,590.08,NULL,'2023-06-17 12:30:07','2023-06-17 13:30:23','2023-06-17 13:30:23'),(2479,7566,843,40720,1537,3,57,2,3400.00,NULL,'2023-06-17 12:30:07','2023-06-17 13:30:23','2023-06-17 13:30:23'),(2480,7566,844,40720,1537,3,217,1,4132.23,NULL,'2023-06-17 12:30:07','2023-06-19 11:45:29','2023-06-19 11:45:29'),(2481,7566,844,40720,1537,3,68,1,867.77,NULL,'2023-06-17 12:30:07','2023-06-19 11:45:29','2023-06-19 11:45:29'),(2482,7566,844,40720,1537,3,57,2,5000.00,NULL,'2023-06-17 12:30:07','2023-06-19 11:45:29','2023-06-19 11:45:29'),(2483,7566,845,40720,1537,3,217,1,4052.09,NULL,'2023-06-17 12:30:07','2023-06-17 13:33:13','2023-06-17 13:33:13'),(2484,7566,845,40720,1537,3,68,1,850.94,NULL,'2023-06-17 12:30:07','2023-06-17 13:33:13','2023-06-17 13:33:13'),(2485,7566,845,40720,1537,3,57,2,4903.03,NULL,'2023-06-17 12:30:07','2023-06-17 13:33:13','2023-06-17 13:33:13'),(2486,7566,846,40720,1537,3,116,1,11250.00,NULL,'2023-06-17 12:30:07','2023-06-17 13:33:49','2023-06-17 13:33:49'),(2487,7566,846,40720,1537,3,57,2,11250.00,NULL,'2023-06-17 12:30:07','2023-06-17 13:33:49','2023-06-17 13:33:49'),(2488,7566,847,40720,1537,3,193,1,5157.00,NULL,'2023-06-17 12:30:08','2023-06-19 11:08:47','2023-06-19 11:08:47'),(2489,7566,847,40720,1537,3,68,1,1325.97,NULL,'2023-06-17 12:30:08','2023-06-19 11:08:47','2023-06-19 11:08:47'),(2490,7566,847,40720,1537,3,193,1,636.38,NULL,'2023-06-17 12:30:08','2023-06-19 11:08:47','2023-06-19 11:08:47'),(2491,7566,847,40720,1537,3,57,2,7119.35,NULL,'2023-06-17 12:30:08','2023-06-19 11:08:47','2023-06-19 11:08:47'),(2492,7566,848,40720,1537,3,217,1,5297.52,NULL,'2023-06-17 12:30:08','2023-06-17 13:37:36','2023-06-17 13:37:36'),(2493,7566,848,40720,1537,3,68,1,1112.48,NULL,'2023-06-17 12:30:08','2023-06-17 13:37:36','2023-06-17 13:37:36'),(2494,7566,848,40720,1537,3,57,2,6410.00,NULL,'2023-06-17 12:30:08','2023-06-17 13:37:36','2023-06-17 13:37:36'),(2495,7566,849,40720,1537,3,483,1,1694.21,NULL,'2023-06-17 12:30:08','2023-06-17 12:30:08',NULL),(2496,7566,849,40720,1537,3,68,1,355.79,NULL,'2023-06-17 12:30:08','2023-06-17 12:30:08',NULL),(2497,7566,849,40720,1537,3,57,2,2050.00,NULL,'2023-06-17 12:30:08','2023-06-17 12:30:08',NULL),(2498,7566,850,40720,1537,3,135,1,5785.12,NULL,'2023-06-17 12:30:08','2023-06-17 13:31:36','2023-06-17 13:31:36'),(2499,7566,850,40720,1537,3,68,1,1214.88,NULL,'2023-06-17 12:30:08','2023-06-17 13:31:36','2023-06-17 13:31:36'),(2500,7566,850,40720,1537,3,57,2,7000.00,NULL,'2023-06-17 12:30:08','2023-06-17 13:31:36','2023-06-17 13:31:36'),(2501,7566,851,40720,1537,3,217,1,3636.36,NULL,'2023-06-17 12:30:08','2023-06-17 13:37:06','2023-06-17 13:37:06'),(2502,7566,851,40720,1537,3,68,1,763.64,NULL,'2023-06-17 12:30:08','2023-06-17 13:37:06','2023-06-17 13:37:06'),(2503,7566,851,40720,1537,3,57,2,4400.00,NULL,'2023-06-17 12:30:08','2023-06-17 13:37:06','2023-06-17 13:37:06'),(2504,7566,852,40720,1537,3,135,1,577.67,NULL,'2023-06-17 12:30:08','2023-06-17 12:30:08',NULL),(2505,7566,852,40720,1537,3,68,1,121.31,NULL,'2023-06-17 12:30:08','2023-06-17 12:30:08',NULL),(2506,7566,852,40720,1537,3,57,2,698.98,NULL,'2023-06-17 12:30:08','2023-06-17 12:30:08',NULL),(2507,7566,853,40720,1537,3,97,1,12000.00,NULL,'2023-06-17 12:30:08','2023-06-17 13:40:34','2023-06-17 13:40:34'),(2508,7566,853,40720,1537,3,57,2,12000.00,NULL,'2023-06-17 12:30:08','2023-06-17 13:40:34','2023-06-17 13:40:34'),(2509,7566,854,40720,1537,3,217,1,3471.07,NULL,'2023-06-17 12:30:08','2023-06-17 13:35:14','2023-06-17 13:35:14'),(2510,7566,854,40720,1537,3,68,1,728.93,NULL,'2023-06-17 12:30:08','2023-06-17 13:35:14','2023-06-17 13:35:14');
INSERT INTO `balance_libro_details` VALUES (2511,7566,854,40720,1537,3,57,2,4200.00,NULL,'2023-06-17 12:30:08','2023-06-17 13:35:14','2023-06-17 13:35:14'),(2512,7566,855,40720,1537,3,250,1,8000.00,NULL,'2023-06-17 12:30:08','2023-06-17 13:42:01','2023-06-17 13:42:01'),(2513,7566,855,40720,1537,3,57,2,8000.00,NULL,'2023-06-17 12:30:08','2023-06-17 13:42:01','2023-06-17 13:42:01'),(2514,7566,856,40720,1537,3,135,1,1570.26,NULL,'2023-06-17 12:30:08','2023-06-17 13:32:07','2023-06-17 13:32:07'),(2515,7566,856,40720,1537,3,68,1,329.75,NULL,'2023-06-17 12:30:08','2023-06-17 13:32:07','2023-06-17 13:32:07'),(2516,7566,856,40720,1537,3,57,2,1900.01,NULL,'2023-06-17 12:30:08','2023-06-17 13:32:07','2023-06-17 13:32:07'),(2517,7566,857,40720,1537,3,483,1,3264.46,NULL,'2023-06-17 12:30:08','2023-06-17 12:30:08',NULL),(2518,7566,857,40720,1537,3,68,1,685.54,NULL,'2023-06-17 12:30:08','2023-06-17 12:30:08',NULL),(2519,7566,857,40720,1537,3,57,2,3950.00,NULL,'2023-06-17 12:30:08','2023-06-17 12:30:08',NULL),(2520,7566,858,40720,1537,3,199,1,5413.22,NULL,'2023-06-17 12:30:08','2023-06-19 10:59:31','2023-06-19 10:59:31'),(2521,7566,858,40720,1537,3,68,1,1136.78,NULL,'2023-06-17 12:30:08','2023-06-19 10:59:31','2023-06-19 10:59:31'),(2522,7566,858,40720,1537,3,199,1,216.53,NULL,'2023-06-17 12:30:08','2023-06-19 10:59:31','2023-06-19 10:59:31'),(2523,7566,858,40720,1537,3,57,2,6766.53,NULL,'2023-06-17 12:30:08','2023-06-19 10:59:31','2023-06-19 10:59:31'),(2524,7566,859,40720,1537,3,483,1,2190.08,NULL,'2023-06-17 12:30:08','2023-06-17 13:38:06','2023-06-17 13:38:06'),(2525,7566,859,40720,1537,3,68,1,459.92,NULL,'2023-06-17 12:30:08','2023-06-17 13:38:06','2023-06-17 13:38:06'),(2526,7566,859,40720,1537,3,57,2,2650.00,NULL,'2023-06-17 12:30:08','2023-06-17 13:38:06','2023-06-17 13:38:06'),(2527,7566,860,40720,1537,3,217,1,4215.00,NULL,'2023-06-17 12:30:08','2023-06-17 13:43:09','2023-06-17 13:43:09'),(2528,7566,860,40720,1537,3,68,1,885.15,NULL,'2023-06-17 12:30:08','2023-06-17 13:43:09','2023-06-17 13:43:09'),(2529,7566,860,40720,1537,3,57,2,5100.15,NULL,'2023-06-17 12:30:08','2023-06-17 13:43:09','2023-06-17 13:43:09'),(2530,7566,861,40720,1537,3,135,1,2385.69,NULL,'2023-06-17 12:30:08','2023-06-17 13:44:27','2023-06-17 13:44:27'),(2531,7566,861,40720,1537,3,68,1,500.99,NULL,'2023-06-17 12:30:08','2023-06-17 13:44:27','2023-06-17 13:44:27'),(2532,7566,861,40720,1537,3,135,1,190.86,NULL,'2023-06-17 12:30:08','2023-06-17 13:44:27','2023-06-17 13:44:27'),(2533,7566,861,40720,1537,3,57,2,3077.54,NULL,'2023-06-17 12:30:08','2023-06-17 13:44:27','2023-06-17 13:44:27'),(2534,7566,862,40720,1537,3,135,1,17500.00,NULL,'2023-06-17 12:30:08','2023-06-17 13:45:01','2023-06-17 13:45:01'),(2535,7566,862,40720,1537,3,57,2,17500.00,NULL,'2023-06-17 12:30:08','2023-06-17 13:45:01','2023-06-17 13:45:01'),(2536,7566,863,40720,1537,7,25,1,2359.12,NULL,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(2537,7566,863,40720,1537,7,13,2,2359.12,NULL,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(2538,7566,864,40720,1537,7,25,1,574.74,NULL,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(2539,7566,864,40720,1537,7,13,2,574.74,NULL,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(2540,7566,865,40720,1537,7,25,1,928.78,NULL,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(2541,7566,865,40720,1537,7,13,2,928.78,NULL,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(2542,7566,866,40720,1537,7,25,1,4412.55,NULL,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(2543,7566,866,40720,1537,7,13,2,4412.55,NULL,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(2544,7566,867,40720,1537,7,25,1,2597.03,NULL,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(2545,7566,867,40720,1537,7,13,2,2597.03,NULL,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(2546,7566,868,40720,1537,7,25,1,711.78,NULL,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(2547,7566,868,40720,1537,7,13,2,711.78,NULL,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL);
INSERT INTO `balance_libro_details` VALUES (2548,7566,869,40720,1537,7,25,1,289.76,NULL,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(2549,7566,869,40720,1537,7,13,2,289.76,NULL,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(2550,7566,870,40720,1537,7,25,1,108.98,NULL,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(2551,7566,870,40720,1537,7,13,2,108.98,NULL,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(2552,7566,871,40720,1537,7,25,1,150.12,NULL,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(2553,7566,871,40720,1537,7,13,2,150.12,NULL,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(2554,7566,872,40720,1537,7,25,1,11593.44,NULL,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(2555,7566,872,40720,1537,7,13,2,11593.44,NULL,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(2556,7566,873,40720,1537,7,25,1,4525.57,NULL,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(2557,7566,873,40720,1537,7,13,2,4525.57,NULL,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(2558,7566,874,40720,1537,7,25,1,2644.11,NULL,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(2559,7566,874,40720,1537,7,13,2,2644.11,NULL,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(2560,7566,875,40720,1537,7,25,1,1046.61,NULL,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(2561,7566,875,40720,1537,7,13,2,1046.61,NULL,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(2562,7566,876,40720,1537,7,25,1,99.64,NULL,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(2563,7566,876,40720,1537,7,13,2,99.64,NULL,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(2564,7566,877,40720,1537,7,25,1,1441.23,NULL,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(2565,7566,877,40720,1537,7,13,2,1441.23,NULL,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(2566,7566,878,40720,1537,7,25,1,5462.68,NULL,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(2567,7566,878,40720,1537,7,13,2,5462.68,NULL,'2023-06-17 12:47:19','2023-06-17 12:47:19',NULL),(2568,7566,879,40720,1537,3,199,1,2809.92,NULL,'2023-06-17 13:30:23','2023-06-17 13:30:23',NULL),(2569,7566,879,40720,1537,3,68,1,590.08,NULL,'2023-06-17 13:30:23','2023-06-17 13:30:23',NULL),(2570,7566,879,40720,1537,3,57,2,3400.00,NULL,'2023-06-17 13:30:23','2023-06-17 13:30:23',NULL),(2571,7566,880,40720,1537,3,135,1,5785.12,NULL,'2023-06-17 13:31:36','2023-06-17 13:31:36',NULL),(2572,7566,880,40720,1537,3,68,1,1214.88,NULL,'2023-06-17 13:31:36','2023-06-17 13:31:36',NULL),(2573,7566,880,40720,1537,3,57,2,7000.00,NULL,'2023-06-17 13:31:36','2023-06-17 13:31:36',NULL),(2574,7566,881,40720,1537,3,135,1,1570.26,NULL,'2023-06-17 13:32:07','2023-06-19 11:43:36','2023-06-19 11:43:36'),(2575,7566,881,40720,1537,3,68,1,329.75,NULL,'2023-06-17 13:32:07','2023-06-19 11:43:36','2023-06-19 11:43:36'),(2576,7566,881,40720,1537,3,57,2,1900.01,NULL,'2023-06-17 13:32:07','2023-06-19 11:43:36','2023-06-19 11:43:36'),(2577,7566,882,40720,1537,3,482,1,4052.09,NULL,'2023-06-17 13:33:13','2023-06-17 13:33:13',NULL),(2578,7566,882,40720,1537,3,68,1,850.94,NULL,'2023-06-17 13:33:13','2023-06-17 13:33:13',NULL),(2579,7566,882,40720,1537,3,57,2,4903.03,NULL,'2023-06-17 13:33:13','2023-06-17 13:33:13',NULL),(2580,7566,883,40720,1537,3,116,1,11250.00,NULL,'2023-06-17 13:33:49','2023-06-17 13:33:49',NULL),(2581,7566,883,40720,1537,3,57,2,11250.00,NULL,'2023-06-17 13:33:49','2023-06-17 13:33:49',NULL),(2582,7566,884,40720,1537,3,135,1,34710.74,NULL,'2023-06-17 13:35:14','2023-06-17 13:36:33','2023-06-17 13:36:33'),(2583,7566,884,40720,1537,3,68,1,7289.26,NULL,'2023-06-17 13:35:14','2023-06-17 13:36:33','2023-06-17 13:36:33'),(2584,7566,884,40720,1537,3,57,2,42000.00,NULL,'2023-06-17 13:35:14','2023-06-17 13:36:33','2023-06-17 13:36:33'),(2585,7566,885,40720,1537,3,135,1,3471.08,NULL,'2023-06-17 13:36:33','2023-06-17 13:38:47','2023-06-17 13:38:47'),(2586,7566,885,40720,1537,3,68,1,728.93,NULL,'2023-06-17 13:36:33','2023-06-17 13:38:47','2023-06-17 13:38:47'),(2587,7566,885,40720,1537,3,57,2,4200.01,NULL,'2023-06-17 13:36:33','2023-06-17 13:38:47','2023-06-17 13:38:47');
INSERT INTO `balance_libro_details` VALUES (2588,7566,886,40720,1537,3,135,1,3636.36,NULL,'2023-06-17 13:37:06','2023-06-17 13:39:04','2023-06-17 13:39:04'),(2589,7566,886,40720,1537,3,68,1,763.64,NULL,'2023-06-17 13:37:06','2023-06-17 13:39:04','2023-06-17 13:39:04'),(2590,7566,886,40720,1537,3,57,2,4400.00,NULL,'2023-06-17 13:37:06','2023-06-17 13:39:04','2023-06-17 13:39:04'),(2591,7566,887,40720,1537,3,135,1,5297.52,NULL,'2023-06-17 13:37:36','2023-06-17 13:39:22','2023-06-17 13:39:22'),(2592,7566,887,40720,1537,3,68,1,1112.48,NULL,'2023-06-17 13:37:36','2023-06-17 13:39:22','2023-06-17 13:39:22'),(2593,7566,887,40720,1537,3,57,2,6410.00,NULL,'2023-06-17 13:37:36','2023-06-17 13:39:22','2023-06-17 13:39:22'),(2594,7566,888,40720,1537,3,483,1,2190.08,NULL,'2023-06-17 13:38:06','2023-06-17 13:38:06',NULL),(2595,7566,888,40720,1537,3,68,1,459.92,NULL,'2023-06-17 13:38:06','2023-06-17 13:38:06',NULL),(2596,7566,888,40720,1537,3,57,2,2650.00,NULL,'2023-06-17 13:38:06','2023-06-17 13:38:06',NULL),(2597,7566,889,40720,1537,3,483,1,3471.08,NULL,'2023-06-17 13:38:47','2023-06-17 13:38:47',NULL),(2598,7566,889,40720,1537,3,68,1,728.93,NULL,'2023-06-17 13:38:47','2023-06-17 13:38:47',NULL),(2599,7566,889,40720,1537,3,57,2,4200.01,NULL,'2023-06-17 13:38:47','2023-06-17 13:38:47',NULL),(2600,7566,890,40720,1537,3,483,1,3636.36,NULL,'2023-06-17 13:39:04','2023-06-17 13:39:04',NULL),(2601,7566,890,40720,1537,3,68,1,763.64,NULL,'2023-06-17 13:39:04','2023-06-17 13:39:04',NULL),(2602,7566,890,40720,1537,3,57,2,4400.00,NULL,'2023-06-17 13:39:04','2023-06-17 13:39:04',NULL),(2603,7566,891,40720,1537,3,483,1,5297.52,NULL,'2023-06-17 13:39:22','2023-06-17 13:39:22',NULL),(2604,7566,891,40720,1537,3,68,1,1112.48,NULL,'2023-06-17 13:39:22','2023-06-17 13:39:22',NULL),(2605,7566,891,40720,1537,3,57,2,6410.00,NULL,'2023-06-17 13:39:22','2023-06-17 13:39:22',NULL),(2606,7566,892,40720,1537,3,192,1,12000.00,NULL,'2023-06-17 13:40:34','2023-06-17 13:40:34',NULL),(2607,7566,892,40720,1537,3,57,2,12000.00,NULL,'2023-06-17 13:40:34','2023-06-17 13:40:34',NULL),(2608,7566,893,40720,1537,3,135,1,8000.00,NULL,'2023-06-17 13:42:01','2023-06-17 13:42:01',NULL),(2609,7566,893,40720,1537,3,57,2,8000.00,NULL,'2023-06-17 13:42:01','2023-06-17 13:42:01',NULL),(2610,7566,894,40720,1537,3,483,1,4215.00,NULL,'2023-06-17 13:43:09','2023-06-17 13:43:09',NULL),(2611,7566,894,40720,1537,3,68,1,885.15,NULL,'2023-06-17 13:43:09','2023-06-17 13:43:09',NULL),(2612,7566,894,40720,1537,3,57,2,5100.15,NULL,'2023-06-17 13:43:09','2023-06-17 13:43:09',NULL),(2613,7566,895,40720,1537,3,135,1,2385.69,NULL,'2023-06-17 13:44:27','2023-06-17 13:44:27',NULL),(2614,7566,895,40720,1537,3,68,1,500.99,NULL,'2023-06-17 13:44:27','2023-06-17 13:44:27',NULL),(2615,7566,895,40720,1537,3,220,1,71.57,NULL,'2023-06-17 13:44:27','2023-06-17 13:44:27',NULL),(2616,7566,895,40720,1537,3,241,1,119.29,NULL,'2023-06-17 13:44:27','2023-06-17 13:44:27',NULL),(2617,7566,895,40720,1537,3,57,2,3077.54,NULL,'2023-06-17 13:44:27','2023-06-17 13:44:27',NULL),(2618,7566,896,40720,1537,3,135,1,17500.00,NULL,'2023-06-17 13:45:01','2023-06-17 13:45:01',NULL),(2619,7566,896,40720,1537,3,57,2,17500.00,NULL,'2023-06-17 13:45:01','2023-06-17 13:45:01',NULL),(2620,7566,897,40720,1537,3,135,1,3842.98,NULL,'2023-06-17 13:47:36','2023-06-17 13:47:36',NULL),(2621,7566,897,40720,1537,3,68,1,807.03,NULL,'2023-06-17 13:47:36','2023-06-17 13:47:36',NULL),(2622,7566,897,40720,1537,3,57,2,4650.01,NULL,'2023-06-17 13:47:36','2023-06-17 13:47:36',NULL),(2623,7566,898,40720,1537,3,135,1,11454.55,NULL,'2023-06-17 13:48:38','2023-06-17 13:48:38',NULL),(2624,7566,898,40720,1537,3,68,1,2405.46,NULL,'2023-06-17 13:48:38','2023-06-17 13:48:38',NULL),(2625,7566,898,40720,1537,3,57,2,13860.01,NULL,'2023-06-17 13:48:38','2023-06-17 13:48:38',NULL),(2626,7566,899,40720,1537,3,484,1,9802.77,NULL,'2023-06-17 13:50:09','2023-06-17 13:50:09',NULL),(2627,7566,899,40720,1537,3,68,1,2058.58,NULL,'2023-06-17 13:50:09','2023-06-17 13:50:09',NULL);
INSERT INTO `balance_libro_details` VALUES (2628,7566,899,40720,1537,3,484,1,53.95,NULL,'2023-06-17 13:50:09','2023-06-17 13:50:09',NULL),(2629,7566,899,40720,1537,3,241,1,98.03,NULL,'2023-06-17 13:50:09','2023-06-17 13:50:09',NULL),(2630,7566,899,40720,1537,3,57,2,12013.33,NULL,'2023-06-17 13:50:09','2023-06-17 13:50:09',NULL),(2631,7566,900,40720,1537,3,484,1,7076.28,NULL,'2023-06-17 13:51:16','2023-06-17 13:51:16',NULL),(2632,7566,900,40720,1537,3,68,1,1486.02,NULL,'2023-06-17 13:51:16','2023-06-17 13:51:16',NULL),(2633,7566,900,40720,1537,3,484,1,52.09,NULL,'2023-06-17 13:51:16','2023-06-17 13:51:16',NULL),(2634,7566,900,40720,1537,3,241,1,70.76,NULL,'2023-06-17 13:51:16','2023-06-17 13:51:16',NULL),(2635,7566,900,40720,1537,3,57,2,8685.15,NULL,'2023-06-17 13:51:16','2023-06-17 13:51:16',NULL),(2636,7566,901,40720,1537,3,484,1,5500.89,NULL,'2023-06-17 13:52:33','2023-06-17 13:52:33',NULL),(2637,7566,901,40720,1537,3,68,1,1155.19,NULL,'2023-06-17 13:52:33','2023-06-17 13:52:33',NULL),(2638,7566,901,40720,1537,3,484,1,43.82,NULL,'2023-06-17 13:52:33','2023-06-17 13:52:33',NULL),(2639,7566,901,40720,1537,3,57,2,6699.90,NULL,'2023-06-17 13:52:33','2023-06-17 13:52:33',NULL),(2640,7566,902,40720,1537,3,482,1,23400.00,NULL,'2023-06-17 13:53:23','2023-06-17 13:53:23',NULL),(2641,7566,902,40720,1537,3,68,1,4914.00,NULL,'2023-06-17 13:53:23','2023-06-17 13:53:23',NULL),(2642,7566,902,40720,1537,3,57,2,28314.00,NULL,'2023-06-17 13:53:23','2023-06-17 13:53:23',NULL),(2643,7566,903,40720,1537,3,482,1,37800.00,NULL,'2023-06-17 13:53:59','2023-06-17 13:53:59',NULL),(2644,7566,903,40720,1537,3,68,1,7938.00,NULL,'2023-06-17 13:53:59','2023-06-17 13:53:59',NULL),(2645,7566,903,40720,1537,3,57,2,45738.00,NULL,'2023-06-17 13:53:59','2023-06-17 13:53:59',NULL),(2646,7566,904,40720,1537,3,135,1,5330.58,NULL,'2023-06-17 13:55:03','2023-06-17 13:55:03',NULL),(2647,7566,904,40720,1537,3,68,1,1119.42,NULL,'2023-06-17 13:55:03','2023-06-17 13:55:03',NULL),(2648,7566,904,40720,1537,3,57,2,6450.00,NULL,'2023-06-17 13:55:03','2023-06-17 13:55:03',NULL),(2649,7566,905,40720,1537,3,485,1,35000.00,NULL,'2023-06-17 13:55:54','2023-06-17 13:55:54',NULL),(2650,7566,905,40720,1537,3,68,1,7350.00,NULL,'2023-06-17 13:55:54','2023-06-17 13:55:54',NULL),(2651,7566,905,40720,1537,3,57,2,42350.00,NULL,'2023-06-17 13:55:54','2023-06-17 13:55:54',NULL),(2652,7566,906,40720,1537,3,199,1,4347.11,NULL,'2023-06-19 11:10:22','2023-06-19 11:10:52','2023-06-19 11:10:52'),(2653,7566,906,40720,1537,3,68,1,912.89,NULL,'2023-06-19 11:10:22','2023-06-19 11:10:52','2023-06-19 11:10:52'),(2654,7566,906,40720,1537,3,220,1,130.41,NULL,'2023-06-19 11:10:22','2023-06-19 11:10:52','2023-06-19 11:10:52'),(2655,7566,906,40720,1537,3,241,1,43.47,NULL,'2023-06-19 11:10:22','2023-06-19 11:10:52','2023-06-19 11:10:52'),(2656,7566,906,40720,1537,3,57,2,5433.88,NULL,'2023-06-19 11:10:22','2023-06-19 11:10:52','2023-06-19 11:10:52'),(2657,7566,907,40720,1537,3,199,1,4347.11,NULL,'2023-06-19 11:10:52','2023-06-19 11:10:52',NULL),(2658,7566,907,40720,1537,3,68,1,912.89,NULL,'2023-06-19 11:10:52','2023-06-19 11:10:52',NULL),(2659,7566,907,40720,1537,3,220,1,130.41,NULL,'2023-06-19 11:10:52','2023-06-19 11:10:52',NULL),(2660,7566,907,40720,1537,3,241,1,43.47,NULL,'2023-06-19 11:10:52','2023-06-19 11:10:52',NULL),(2661,7566,907,40720,1537,3,57,2,5433.88,NULL,'2023-06-19 11:10:52','2023-06-19 11:10:52',NULL),(2662,7566,908,40720,1537,3,193,1,4050.00,NULL,'2023-06-19 11:14:47','2023-06-19 11:14:47',NULL),(2663,7566,908,40720,1537,3,68,1,1093.50,NULL,'2023-06-19 11:14:47','2023-06-19 11:14:47',NULL),(2664,7566,908,40720,1537,3,193,1,1107.00,NULL,'2023-06-19 11:14:47','2023-06-19 11:14:47',NULL),(2665,7566,908,40720,1537,3,68,1,232.47,NULL,'2023-06-19 11:14:47','2023-06-19 11:14:47',NULL),(2666,7566,908,40720,1537,3,193,1,213.16,NULL,'2023-06-19 11:14:47','2023-06-19 11:14:47',NULL),(2667,7566,908,40720,1537,3,220,1,154.71,NULL,'2023-06-19 11:14:47','2023-06-19 11:14:47',NULL);
INSERT INTO `balance_libro_details` VALUES (2668,7566,908,40720,1537,3,241,1,268.51,NULL,'2023-06-19 11:14:47','2023-06-19 11:14:47',NULL),(2669,7566,908,40720,1537,3,57,2,7119.35,NULL,'2023-06-19 11:14:47','2023-06-19 11:14:47',NULL),(2670,7566,909,40720,1537,3,135,1,1570.26,NULL,'2023-06-19 11:43:36','2023-06-19 11:43:36',NULL),(2671,7566,909,40720,1537,3,68,1,329.75,NULL,'2023-06-19 11:43:36','2023-06-19 11:43:36',NULL),(2672,7566,909,40720,1537,3,57,2,1900.01,NULL,'2023-06-19 11:43:36','2023-06-19 11:43:36',NULL),(2673,7566,910,40720,1537,3,135,1,4132.23,NULL,'2023-06-19 11:45:29','2023-06-19 11:46:37','2023-06-19 11:46:37'),(2674,7566,910,40720,1537,3,68,1,867.77,NULL,'2023-06-19 11:45:29','2023-06-19 11:46:37','2023-06-19 11:46:37'),(2675,7566,910,40720,1537,3,57,2,5000.00,NULL,'2023-06-19 11:45:29','2023-06-19 11:46:37','2023-06-19 11:46:37'),(2676,7566,911,40720,1537,3,135,1,4132.23,NULL,'2023-06-19 11:46:37','2023-06-19 11:46:37',NULL),(2677,7566,911,40720,1537,3,68,1,867.77,NULL,'2023-06-19 11:46:37','2023-06-19 11:46:37',NULL),(2678,7566,911,40720,1537,3,57,2,5000.00,NULL,'2023-06-19 11:46:37','2023-06-19 11:46:37',NULL),(2679,7566,912,40720,1538,2,96,2,164445.75,NULL,'2023-07-13 16:44:29','2023-07-13 16:44:29',NULL),(2680,7566,912,40720,1538,2,67,2,34533.61,NULL,'2023-07-13 16:44:29','2023-07-13 16:44:29',NULL),(2681,7566,912,40720,1538,2,13,1,198979.36,NULL,'2023-07-13 16:44:29','2023-07-13 16:44:29',NULL),(2682,7566,913,40720,1538,2,96,2,227585.47,NULL,'2023-07-13 16:44:29','2023-07-13 16:44:29',NULL),(2683,7566,913,40720,1538,2,67,2,47792.95,NULL,'2023-07-13 16:44:29','2023-07-13 16:44:29',NULL),(2684,7566,913,40720,1538,2,13,1,275378.42,NULL,'2023-07-13 16:44:29','2023-07-13 16:44:29',NULL),(2685,7566,914,40720,1538,2,96,2,1999.87,NULL,'2023-07-13 16:44:29','2023-07-13 16:44:29',NULL),(2686,7566,914,40720,1538,2,67,2,419.97,NULL,'2023-07-13 16:44:29','2023-07-13 16:44:29',NULL),(2687,7566,914,40720,1538,2,13,1,2419.84,NULL,'2023-07-13 16:44:29','2023-07-13 16:44:29',NULL),(2688,7566,915,40720,1538,2,96,2,9523.18,NULL,'2023-07-13 16:44:30','2023-07-13 16:44:30',NULL),(2689,7566,915,40720,1538,2,67,2,1999.87,NULL,'2023-07-13 16:44:30','2023-07-13 16:44:30',NULL),(2690,7566,915,40720,1538,2,13,1,11523.05,NULL,'2023-07-13 16:44:30','2023-07-13 16:44:30',NULL),(2691,7566,916,40720,1538,2,96,2,4403.05,NULL,'2023-07-13 16:44:30','2023-07-13 16:44:30',NULL),(2692,7566,916,40720,1538,2,67,2,924.64,NULL,'2023-07-13 16:44:30','2023-07-13 16:44:30',NULL),(2693,7566,916,40720,1538,2,13,1,5327.69,NULL,'2023-07-13 16:44:30','2023-07-13 16:44:30',NULL),(2694,7566,917,40720,1538,2,96,1,1999.87,NULL,'2023-07-13 16:44:30','2023-07-13 16:44:30',NULL),(2695,7566,917,40720,1538,2,68,1,419.97,NULL,'2023-07-13 16:44:30','2023-07-13 16:44:30',NULL),(2696,7566,917,40720,1538,2,13,2,2419.84,NULL,'2023-07-13 16:44:30','2023-07-13 16:44:30',NULL),(2697,7566,918,40720,1538,2,96,2,325876.32,NULL,'2023-07-13 16:44:30','2023-07-13 16:44:30',NULL),(2698,7566,918,40720,1538,2,67,2,68434.03,NULL,'2023-07-13 16:44:30','2023-07-13 16:44:30',NULL),(2699,7566,918,40720,1538,2,13,1,394310.35,NULL,'2023-07-13 16:44:30','2023-07-13 16:44:30',NULL),(2700,7566,919,40720,1538,3,250,1,0.00,NULL,'2023-07-13 16:44:46','2023-07-13 16:46:05','2023-07-13 16:46:05'),(2701,7566,919,40720,1538,3,250,1,16666.16,NULL,'2023-07-13 16:44:46','2023-07-13 16:46:05','2023-07-13 16:46:05'),(2702,7566,919,40720,1538,3,57,2,16666.16,NULL,'2023-07-13 16:44:46','2023-07-13 16:46:05','2023-07-13 16:46:05'),(2703,7566,920,40720,1538,3,199,1,2917.36,NULL,'2023-07-13 16:44:46','2023-07-13 16:51:55','2023-07-13 16:51:55'),(2704,7566,920,40720,1538,3,68,1,612.64,NULL,'2023-07-13 16:44:46','2023-07-13 16:51:55','2023-07-13 16:51:55'),(2705,7566,920,40720,1538,3,57,2,3530.00,NULL,'2023-07-13 16:44:46','2023-07-13 16:51:55','2023-07-13 16:51:55'),(2706,7566,921,40720,1538,3,116,1,11250.00,NULL,'2023-07-13 16:44:46','2023-07-13 16:52:53','2023-07-13 16:52:53');
INSERT INTO `balance_libro_details` VALUES (2707,7566,921,40720,1538,3,57,2,11250.00,NULL,'2023-07-13 16:44:46','2023-07-13 16:52:53','2023-07-13 16:52:53'),(2708,7566,922,40720,1538,3,193,1,5748.88,NULL,'2023-07-13 16:44:46','2023-07-13 16:54:42','2023-07-13 16:54:42'),(2709,7566,922,40720,1538,3,68,1,1471.86,NULL,'2023-07-13 16:44:46','2023-07-13 16:54:42','2023-07-13 16:54:42'),(2710,7566,922,40720,1538,3,193,1,703.62,NULL,'2023-07-13 16:44:46','2023-07-13 16:54:42','2023-07-13 16:54:42'),(2711,7566,922,40720,1538,3,57,2,7924.36,NULL,'2023-07-13 16:44:46','2023-07-13 16:54:42','2023-07-13 16:54:42'),(2712,7566,923,40720,1538,3,483,1,1239.67,NULL,'2023-07-13 16:44:47','2023-07-13 16:44:47',NULL),(2713,7566,923,40720,1538,3,68,1,260.33,NULL,'2023-07-13 16:44:47','2023-07-13 16:44:47',NULL),(2714,7566,923,40720,1538,3,57,2,1500.00,NULL,'2023-07-13 16:44:47','2023-07-13 16:44:47',NULL),(2715,7566,924,40720,1538,3,217,1,1735.54,NULL,'2023-07-13 16:44:47','2023-07-13 16:57:21','2023-07-13 16:57:21'),(2716,7566,924,40720,1538,3,68,1,364.46,NULL,'2023-07-13 16:44:47','2023-07-13 16:57:21','2023-07-13 16:57:21'),(2717,7566,924,40720,1538,3,57,2,2100.00,NULL,'2023-07-13 16:44:47','2023-07-13 16:57:21','2023-07-13 16:57:21'),(2718,7566,925,40720,1538,3,483,1,1322.31,NULL,'2023-07-13 16:44:47','2023-07-13 16:44:47',NULL),(2719,7566,925,40720,1538,3,68,1,277.69,NULL,'2023-07-13 16:44:47','2023-07-13 16:44:47',NULL),(2720,7566,925,40720,1538,3,57,2,1600.00,NULL,'2023-07-13 16:44:47','2023-07-13 16:44:47',NULL),(2721,7566,926,40720,1538,3,97,1,12000.00,NULL,'2023-07-13 16:44:47','2023-07-15 10:17:44','2023-07-15 10:17:44'),(2722,7566,926,40720,1538,3,57,2,12000.00,NULL,'2023-07-13 16:44:47','2023-07-15 10:17:44','2023-07-15 10:17:44'),(2723,7566,927,40720,1538,3,135,1,10390.73,NULL,'2023-07-13 16:44:47','2023-07-13 17:10:13','2023-07-13 17:10:13'),(2724,7566,927,40720,1538,3,68,1,2182.05,NULL,'2023-07-13 16:44:47','2023-07-13 17:10:13','2023-07-13 17:10:13'),(2725,7566,927,40720,1538,3,135,1,415.63,NULL,'2023-07-13 16:44:47','2023-07-13 17:10:13','2023-07-13 17:10:13'),(2726,7566,927,40720,1538,3,57,2,12988.41,NULL,'2023-07-13 16:44:47','2023-07-13 17:10:13','2023-07-13 17:10:13'),(2727,7566,928,40720,1538,3,483,1,3760.33,NULL,'2023-07-13 16:44:47','2023-07-13 16:44:47',NULL),(2728,7566,928,40720,1538,3,68,1,789.67,NULL,'2023-07-13 16:44:47','2023-07-13 16:44:47',NULL),(2729,7566,928,40720,1538,3,57,2,4550.00,NULL,'2023-07-13 16:44:47','2023-07-13 16:44:47',NULL),(2730,7566,929,40720,1538,3,217,1,24793.39,NULL,'2023-07-13 16:44:47','2023-07-13 17:21:57','2023-07-13 17:21:57'),(2731,7566,929,40720,1538,3,68,1,5206.61,NULL,'2023-07-13 16:44:47','2023-07-13 17:21:57','2023-07-13 17:21:57'),(2732,7566,929,40720,1538,3,57,2,30000.00,NULL,'2023-07-13 16:44:47','2023-07-13 17:21:57','2023-07-13 17:21:57'),(2733,7566,930,40720,1538,3,135,1,3195.35,NULL,'2023-07-13 16:44:47','2023-07-13 17:12:51','2023-07-13 17:12:51'),(2734,7566,930,40720,1538,3,68,1,671.02,NULL,'2023-07-13 16:44:47','2023-07-13 17:12:51','2023-07-13 17:12:51'),(2735,7566,930,40720,1538,3,135,1,108.49,NULL,'2023-07-13 16:44:47','2023-07-13 17:12:51','2023-07-13 17:12:51'),(2736,7566,930,40720,1538,3,57,2,3974.86,NULL,'2023-07-13 16:44:47','2023-07-13 17:12:51','2023-07-13 17:12:51'),(2737,7566,931,40720,1538,3,217,2,24793.39,NULL,'2023-07-13 16:44:47','2023-11-18 12:34:14','2023-11-18 12:34:14'),(2738,7566,931,40720,1538,3,67,2,5206.61,NULL,'2023-07-13 16:44:47','2023-11-18 12:34:14','2023-11-18 12:34:14'),(2739,7566,931,40720,1538,3,57,1,30000.00,NULL,'2023-07-13 16:44:47','2023-11-18 12:34:14','2023-11-18 12:34:14'),(2740,7566,932,40720,1538,3,135,1,2006.61,NULL,'2023-07-13 16:44:47','2023-07-13 17:13:28','2023-07-13 17:13:28'),(2741,7566,932,40720,1538,3,68,1,421.39,NULL,'2023-07-13 16:44:47','2023-07-13 17:13:28','2023-07-13 17:13:28'),(2742,7566,932,40720,1538,3,135,1,60.20,NULL,'2023-07-13 16:44:47','2023-07-13 17:13:28','2023-07-13 17:13:28');
INSERT INTO `balance_libro_details` VALUES (2743,7566,932,40720,1538,3,57,2,2488.20,NULL,'2023-07-13 16:44:47','2023-07-13 17:13:28','2023-07-13 17:13:28'),(2744,7566,933,40720,1538,3,199,1,6169.42,NULL,'2023-07-13 16:44:47','2023-07-15 10:51:32','2023-07-15 10:51:32'),(2745,7566,933,40720,1538,3,68,1,1295.58,NULL,'2023-07-13 16:44:47','2023-07-15 10:51:32','2023-07-15 10:51:32'),(2746,7566,933,40720,1538,3,199,1,246.77,NULL,'2023-07-13 16:44:47','2023-07-15 10:51:32','2023-07-15 10:51:32'),(2747,7566,933,40720,1538,3,57,2,7711.77,NULL,'2023-07-13 16:44:47','2023-07-15 10:51:32','2023-07-15 10:51:32'),(2748,7566,934,40720,1538,3,483,1,2809.92,NULL,'2023-07-13 16:44:47','2023-07-13 16:44:47',NULL),(2749,7566,934,40720,1538,3,68,1,590.08,NULL,'2023-07-13 16:44:47','2023-07-13 16:44:47',NULL),(2750,7566,934,40720,1538,3,57,2,3400.00,NULL,'2023-07-13 16:44:47','2023-07-13 16:44:47',NULL),(2751,7566,935,40720,1538,3,483,1,1900.83,NULL,'2023-07-13 16:44:48','2023-07-13 16:44:48',NULL),(2752,7566,935,40720,1538,3,68,1,399.17,NULL,'2023-07-13 16:44:48','2023-07-13 16:44:48',NULL),(2753,7566,935,40720,1538,3,57,2,2300.00,NULL,'2023-07-13 16:44:48','2023-07-13 16:44:48',NULL),(2754,7566,936,40720,1538,3,135,1,8099.17,NULL,'2023-07-13 16:44:48','2023-07-13 16:44:48',NULL),(2755,7566,936,40720,1538,3,68,1,1700.83,NULL,'2023-07-13 16:44:48','2023-07-13 16:44:48',NULL),(2756,7566,936,40720,1538,3,57,2,9800.00,NULL,'2023-07-13 16:44:48','2023-07-13 16:44:48',NULL),(2757,7566,937,40720,1538,3,217,1,4876.03,NULL,'2023-07-13 16:44:48','2023-07-13 17:33:53','2023-07-13 17:33:53'),(2758,7566,937,40720,1538,3,68,1,1023.97,NULL,'2023-07-13 16:44:48','2023-07-13 17:33:53','2023-07-13 17:33:53'),(2759,7566,937,40720,1538,3,57,2,5900.00,NULL,'2023-07-13 16:44:48','2023-07-13 17:33:53','2023-07-13 17:33:53'),(2760,7566,938,40720,1538,3,135,1,825.62,NULL,'2023-07-13 16:44:48','2023-07-13 16:44:48',NULL),(2761,7566,938,40720,1538,3,68,1,173.38,NULL,'2023-07-13 16:44:48','2023-07-13 16:44:48',NULL),(2762,7566,938,40720,1538,3,57,2,999.00,NULL,'2023-07-13 16:44:48','2023-07-13 16:44:48',NULL),(2763,7566,939,40720,1538,3,483,1,1900.83,NULL,'2023-07-13 16:44:48','2023-07-13 16:44:48',NULL),(2764,7566,939,40720,1538,3,68,1,399.17,NULL,'2023-07-13 16:44:48','2023-07-13 16:44:48',NULL),(2765,7566,939,40720,1538,3,57,2,2300.00,NULL,'2023-07-13 16:44:48','2023-07-13 16:44:48',NULL),(2766,7566,940,40720,1538,3,483,1,4380.17,NULL,'2023-07-13 16:44:48','2023-07-13 16:44:48',NULL),(2767,7566,940,40720,1538,3,68,1,919.84,NULL,'2023-07-13 16:44:48','2023-07-13 16:44:48',NULL),(2768,7566,940,40720,1538,3,57,2,5300.01,NULL,'2023-07-13 16:44:48','2023-07-13 16:44:48',NULL),(2769,7566,941,40720,1538,3,250,1,53000.00,NULL,'2023-07-13 16:44:48','2023-07-13 17:37:12','2023-07-13 17:37:12'),(2770,7566,941,40720,1538,3,57,2,53000.00,NULL,'2023-07-13 16:44:48','2023-07-13 17:37:12','2023-07-13 17:37:12'),(2771,7566,942,40720,1538,3,217,1,3719.01,NULL,'2023-07-13 16:44:48','2023-07-13 17:33:09','2023-07-13 17:33:09'),(2772,7566,942,40720,1538,3,68,1,780.99,NULL,'2023-07-13 16:44:48','2023-07-13 17:33:09','2023-07-13 17:33:09'),(2773,7566,942,40720,1538,3,57,2,4500.00,NULL,'2023-07-13 16:44:48','2023-07-13 17:33:09','2023-07-13 17:33:09'),(2774,7566,943,40720,1538,3,135,1,16234.45,NULL,'2023-07-13 16:44:48','2023-07-13 17:39:02','2023-07-13 17:39:02'),(2775,7566,943,40720,1538,3,68,1,2033.36,NULL,'2023-07-13 16:44:48','2023-07-13 17:39:02','2023-07-13 17:39:02'),(2776,7566,943,40720,1538,3,135,1,5507.47,NULL,'2023-07-13 16:44:48','2023-07-13 17:39:02','2023-07-13 17:39:02'),(2777,7566,943,40720,1538,3,57,2,23775.28,NULL,'2023-07-13 16:44:48','2023-07-13 17:39:02','2023-07-13 17:39:02'),(2778,7566,944,40720,1538,3,483,1,1900.83,NULL,'2023-07-13 16:44:48','2023-07-13 16:44:48',NULL),(2779,7566,944,40720,1538,3,68,1,399.17,NULL,'2023-07-13 16:44:48','2023-07-13 16:44:48',NULL),(2780,7566,944,40720,1538,3,57,2,2300.00,NULL,'2023-07-13 16:44:48','2023-07-13 16:44:48',NULL);
INSERT INTO `balance_libro_details` VALUES (2781,7566,945,40720,1538,3,135,1,12000.00,NULL,'2023-07-13 16:44:48','2023-07-13 16:44:48',NULL),(2782,7566,945,40720,1538,3,57,2,12000.00,NULL,'2023-07-13 16:44:48','2023-07-13 16:44:48',NULL),(2783,7566,946,40720,1538,3,135,1,12000.00,NULL,'2023-07-13 16:44:48','2023-07-13 16:44:48',NULL),(2784,7566,946,40720,1538,3,57,2,12000.00,NULL,'2023-07-13 16:44:48','2023-07-13 16:44:48',NULL),(2785,7566,947,40720,1538,3,135,1,2443.72,NULL,'2023-07-13 16:44:49','2023-07-15 10:04:44','2023-07-15 10:04:44'),(2786,7566,947,40720,1538,3,68,1,513.18,NULL,'2023-07-13 16:44:49','2023-07-15 10:04:44','2023-07-15 10:04:44'),(2787,7566,947,40720,1538,3,135,1,223.65,NULL,'2023-07-13 16:44:49','2023-07-15 10:04:44','2023-07-15 10:04:44'),(2788,7566,947,40720,1538,3,57,2,3180.55,NULL,'2023-07-13 16:44:49','2023-07-15 10:04:44','2023-07-15 10:04:44'),(2789,7566,948,40720,1538,3,217,1,3801.65,NULL,'2023-07-13 16:44:49','2023-07-15 10:05:42','2023-07-15 10:05:42'),(2790,7566,948,40720,1538,3,68,1,798.35,NULL,'2023-07-13 16:44:49','2023-07-15 10:05:42','2023-07-15 10:05:42'),(2791,7566,948,40720,1538,3,57,2,4600.00,NULL,'2023-07-13 16:44:49','2023-07-15 10:05:42','2023-07-15 10:05:42'),(2792,7566,949,40720,1538,3,199,1,2917.36,NULL,'2023-07-13 16:51:55','2023-07-13 16:51:55',NULL),(2793,7566,949,40720,1538,3,68,1,612.65,NULL,'2023-07-13 16:51:55','2023-07-13 16:51:55',NULL),(2794,7566,949,40720,1538,3,57,2,3530.01,NULL,'2023-07-13 16:51:55','2023-07-13 16:51:55',NULL),(2795,7566,950,40720,1538,3,116,1,11250.00,NULL,'2023-07-13 16:52:53','2023-07-13 16:52:53',NULL),(2796,7566,950,40720,1538,3,57,2,11250.00,NULL,'2023-07-13 16:52:53','2023-07-13 16:52:53',NULL),(2797,7566,951,40720,1538,3,193,1,4409.88,NULL,'2023-07-13 16:54:42','2023-07-13 16:54:42',NULL),(2798,7566,951,40720,1538,3,68,1,1190.67,NULL,'2023-07-13 16:54:42','2023-07-13 16:54:42',NULL),(2799,7566,951,40720,1538,3,193,1,1339.00,NULL,'2023-07-13 16:54:42','2023-07-13 16:54:42',NULL),(2800,7566,951,40720,1538,3,68,1,281.19,NULL,'2023-07-13 16:54:42','2023-07-13 16:54:42',NULL),(2801,7566,951,40720,1538,3,193,1,232.10,NULL,'2023-07-13 16:54:42','2023-07-13 16:54:42',NULL),(2802,7566,951,40720,1538,3,220,1,172.47,NULL,'2023-07-13 16:54:42','2023-07-13 16:54:42',NULL),(2803,7566,951,40720,1538,3,241,1,299.05,NULL,'2023-07-13 16:54:42','2023-07-13 16:54:42',NULL),(2804,7566,951,40720,1538,3,57,2,7924.36,NULL,'2023-07-13 16:54:42','2023-07-13 16:54:42',NULL),(2805,7566,952,40720,1538,3,217,1,1735.54,NULL,'2023-07-13 16:57:21','2023-11-18 12:33:49','2023-11-18 12:33:49'),(2806,7566,952,40720,1538,3,68,1,364.46,NULL,'2023-07-13 16:57:21','2023-11-18 12:33:49','2023-11-18 12:33:49'),(2807,7566,952,40720,1538,3,57,2,2100.00,NULL,'2023-07-13 16:57:21','2023-11-18 12:33:49','2023-11-18 12:33:49'),(2808,7566,953,40720,1538,3,135,1,10390.73,NULL,'2023-07-13 17:10:13','2023-07-13 17:10:13',NULL),(2809,7566,953,40720,1538,3,68,1,2182.05,NULL,'2023-07-13 17:10:13','2023-07-13 17:10:13',NULL),(2810,7566,953,40720,1538,3,220,1,311.72,NULL,'2023-07-13 17:10:13','2023-07-13 17:10:13',NULL),(2811,7566,953,40720,1538,3,239,1,103.91,NULL,'2023-07-13 17:10:13','2023-07-13 17:10:13',NULL),(2812,7566,953,40720,1538,3,57,2,12988.41,NULL,'2023-07-13 17:10:13','2023-07-13 17:10:13',NULL),(2813,7566,954,40720,1538,3,135,1,3195.35,NULL,'2023-07-13 17:12:52','2023-07-13 17:12:52',NULL),(2814,7566,954,40720,1538,3,68,1,671.02,NULL,'2023-07-13 17:12:52','2023-07-13 17:12:52',NULL),(2815,7566,954,40720,1538,3,135,1,12.63,NULL,'2023-07-13 17:12:52','2023-07-13 17:12:52',NULL),(2816,7566,954,40720,1538,3,220,1,95.86,NULL,'2023-07-13 17:12:52','2023-07-13 17:12:52',NULL),(2817,7566,954,40720,1538,3,57,2,3974.86,NULL,'2023-07-13 17:12:52','2023-07-13 17:12:52',NULL),(2818,7566,955,40720,1538,3,135,1,2006.61,NULL,'2023-07-13 17:13:28','2023-07-13 17:13:50','2023-07-13 17:13:50'),(2819,7566,955,40720,1538,3,68,1,421.39,NULL,'2023-07-13 17:13:28','2023-07-13 17:13:50','2023-07-13 17:13:50');
INSERT INTO `balance_libro_details` VALUES (2820,7566,955,40720,1538,3,220,1,60.20,NULL,'2023-07-13 17:13:28','2023-07-13 17:13:50','2023-07-13 17:13:50'),(2821,7566,955,40720,1538,3,57,2,2488.20,NULL,'2023-07-13 17:13:28','2023-07-13 17:13:50','2023-07-13 17:13:50'),(2822,7566,956,40720,1538,3,135,1,2006.61,NULL,'2023-07-13 17:13:50','2023-07-13 17:13:50',NULL),(2823,7566,956,40720,1538,3,68,1,421.39,NULL,'2023-07-13 17:13:50','2023-07-13 17:13:50',NULL),(2824,7566,956,40720,1538,3,220,1,60.20,NULL,'2023-07-13 17:13:50','2023-07-13 17:13:50',NULL),(2825,7566,956,40720,1538,3,57,2,2488.20,NULL,'2023-07-13 17:13:50','2023-07-13 17:13:50',NULL),(2826,7566,957,40720,1538,3,482,1,28350.00,NULL,'2023-07-13 17:16:31','2023-07-13 17:16:31',NULL),(2827,7566,957,40720,1538,3,68,1,5953.50,NULL,'2023-07-13 17:16:31','2023-07-13 17:16:31',NULL),(2828,7566,957,40720,1538,3,57,2,34303.50,NULL,'2023-07-13 17:16:31','2023-07-13 17:16:31',NULL),(2829,7566,958,40720,1538,3,482,1,28800.00,NULL,'2023-07-13 17:17:27','2023-07-13 17:17:27',NULL),(2830,7566,958,40720,1538,3,68,1,6048.00,NULL,'2023-07-13 17:17:27','2023-07-13 17:17:27',NULL),(2831,7566,958,40720,1538,3,57,2,34848.00,NULL,'2023-07-13 17:17:27','2023-07-13 17:17:27',NULL),(2832,7566,959,40720,1538,3,482,1,38570.00,NULL,'2023-07-13 17:18:17','2023-07-13 17:18:17',NULL),(2833,7566,959,40720,1538,3,68,1,8099.70,NULL,'2023-07-13 17:18:17','2023-07-13 17:18:17',NULL),(2834,7566,959,40720,1538,3,57,2,46669.70,NULL,'2023-07-13 17:18:17','2023-07-13 17:18:17',NULL),(2835,7566,960,40720,1538,3,135,1,24793.39,NULL,'2023-07-13 17:21:57','2023-07-13 17:21:57',NULL),(2836,7566,960,40720,1538,3,68,1,5206.61,NULL,'2023-07-13 17:21:57','2023-07-13 17:21:57',NULL),(2837,7566,960,40720,1538,3,57,2,30000.00,NULL,'2023-07-13 17:21:57','2023-07-13 17:21:57',NULL),(2838,7566,961,40720,1538,3,199,1,5413.22,NULL,'2023-07-13 17:26:47','2023-07-13 17:26:47',NULL),(2839,7566,961,40720,1538,3,68,1,1136.78,NULL,'2023-07-13 17:26:47','2023-07-13 17:26:47',NULL),(2840,7566,961,40720,1538,3,220,1,162.40,NULL,'2023-07-13 17:26:47','2023-07-13 17:26:47',NULL),(2841,7566,961,40720,1538,3,241,1,54.13,NULL,'2023-07-13 17:26:47','2023-07-13 17:26:47',NULL),(2842,7566,961,40720,1538,3,57,2,6766.53,NULL,'2023-07-13 17:26:47','2023-07-13 17:26:47',NULL),(2843,7566,962,40720,1538,3,483,1,3719.01,NULL,'2023-07-13 17:33:09','2023-07-13 17:33:09',NULL),(2844,7566,962,40720,1538,3,68,1,780.99,NULL,'2023-07-13 17:33:09','2023-07-13 17:33:09',NULL),(2845,7566,962,40720,1538,3,57,2,4500.00,NULL,'2023-07-13 17:33:09','2023-07-13 17:33:09',NULL),(2846,7566,963,40720,1538,3,483,1,4876.03,NULL,'2023-07-13 17:33:53','2023-07-13 17:33:53',NULL),(2847,7566,963,40720,1538,3,68,1,1023.97,NULL,'2023-07-13 17:33:53','2023-07-13 17:33:53',NULL),(2848,7566,963,40720,1538,3,57,2,5900.00,NULL,'2023-07-13 17:33:53','2023-07-13 17:33:53',NULL),(2849,7566,964,40720,1538,3,192,1,53000.00,NULL,'2023-07-13 17:37:12','2023-07-15 10:17:55','2023-07-15 10:17:55'),(2850,7566,964,40720,1538,3,57,2,53000.00,NULL,'2023-07-13 17:37:12','2023-07-15 10:17:55','2023-07-15 10:17:55'),(2851,7566,965,40720,1538,3,135,1,3130.91,NULL,'2023-07-13 17:39:02','2023-07-15 10:29:08','2023-07-15 10:29:08'),(2852,7566,965,40720,1538,3,68,1,657.49,NULL,'2023-07-13 17:39:02','2023-07-15 10:29:08','2023-07-15 10:29:08'),(2853,7566,965,40720,1538,3,135,1,13103.54,NULL,'2023-07-13 17:39:02','2023-07-15 10:29:08','2023-07-15 10:29:08'),(2854,7566,965,40720,1538,3,68,1,1375.87,NULL,'2023-07-13 17:39:02','2023-07-15 10:29:08','2023-07-15 10:29:08'),(2855,7566,965,40720,1538,3,135,1,5507.47,NULL,'2023-07-13 17:39:02','2023-07-15 10:29:08','2023-07-15 10:29:08'),(2856,7566,965,40720,1538,3,57,2,23775.28,NULL,'2023-07-13 17:39:02','2023-07-15 10:29:08','2023-07-15 10:29:08'),(2857,7566,966,40720,1538,3,135,1,2443.72,NULL,'2023-07-15 10:04:44','2023-07-15 10:04:44',NULL),(2858,7566,966,40720,1538,3,68,1,513.18,NULL,'2023-07-15 10:04:44','2023-07-15 10:04:44',NULL);
INSERT INTO `balance_libro_details` VALUES (2859,7566,966,40720,1538,3,135,1,26.81,NULL,'2023-07-15 10:04:44','2023-07-15 10:04:44',NULL),(2860,7566,966,40720,1538,3,220,1,73.31,NULL,'2023-07-15 10:04:44','2023-07-15 10:04:44',NULL),(2861,7566,966,40720,1538,3,241,1,123.53,NULL,'2023-07-15 10:04:44','2023-07-15 10:04:44',NULL),(2862,7566,966,40720,1538,3,57,2,3180.55,NULL,'2023-07-15 10:04:44','2023-07-15 10:04:44',NULL),(2863,7566,967,40720,1538,3,483,1,3801.65,NULL,'2023-07-15 10:05:42','2023-07-15 10:05:42',NULL),(2864,7566,967,40720,1538,3,68,1,798.35,NULL,'2023-07-15 10:05:42','2023-07-15 10:05:42',NULL),(2865,7566,967,40720,1538,3,57,2,4600.00,NULL,'2023-07-15 10:05:42','2023-07-15 10:05:42',NULL),(2866,7566,968,40720,1538,3,135,1,2380.17,NULL,'2023-07-15 10:06:54','2023-07-15 