-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db27-29420877-7
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-08-22 10:00:42','Actividad Generica 1','000001',NULL),(2,NULL,'2022-08-22 10:00:42','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2608 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,7638,40738,30492,2,1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',107479.30,NULL,NULL,1,'2022-11-23 15:33:52','2022-11-23 15:33:52',NULL),(2,7638,40738,30492,2,2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1196281.44,NULL,NULL,1,'2022-11-23 15:33:52','2022-11-23 15:33:52',NULL),(3,7638,40738,30492,3,3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',6610.51,NULL,NULL,1,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(4,7638,40738,30492,3,4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',7298.12,NULL,NULL,1,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(5,7638,40738,30492,3,5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',10557.98,NULL,NULL,1,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(6,7638,40738,30492,3,6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',30684.00,NULL,NULL,1,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(7,7638,40738,30492,3,7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',685.47,NULL,NULL,1,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(8,7638,40738,30492,3,8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',8155.63,NULL,NULL,1,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(9,7638,40738,30492,3,9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',4129.00,NULL,NULL,1,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(10,7638,40738,30492,3,10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-09','2022-10-09',6104.68,NULL,NULL,1,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(11,7638,40738,30492,3,11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',10862.06,NULL,NULL,1,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(12,7638,40738,30492,3,12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',19392.00,NULL,NULL,1,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(13,7638,40738,30492,3,13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',74463.40,NULL,NULL,1,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(14,7638,40738,30492,3,14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',380543.99,NULL,NULL,1,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(15,7638,40738,30492,3,15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',126739.20,NULL,NULL,1,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(16,7638,40738,30492,3,16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',252825.60,NULL,NULL,1,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(17,7638,40738,30492,3,17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',5998.00,NULL,NULL,1,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(18,7638,40738,30492,3,18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',136.00,NULL,NULL,1,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(19,7638,40738,30492,3,19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',95.00,NULL,NULL,1,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(20,7638,40738,30492,3,20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1072.73,NULL,NULL,1,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(21,7638,40738,30492,3,21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1150.00,NULL,NULL,1,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(22,7638,40738,30492,3,22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',75999.00,NULL,NULL,1,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(23,7638,40738,30492,3,23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',75999.00,NULL,NULL,1,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(24,7638,40738,30492,3,24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',180.54,NULL,NULL,1,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(25,7638,40738,30492,3,25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',2500.00,NULL,NULL,1,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL);
INSERT INTO `balance_libro` VALUES (26,7638,40738,30492,3,26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',33500.00,NULL,NULL,1,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(27,7638,40738,30492,3,27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',12600.17,NULL,NULL,1,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(28,7638,40738,30492,3,28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',12600.17,NULL,NULL,1,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(29,7638,40738,30492,3,29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',17994.64,NULL,NULL,1,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(30,7638,40738,30492,3,30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',10500.14,NULL,NULL,1,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(31,7638,40738,30492,3,31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',41339.80,NULL,NULL,1,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(32,7638,40738,30492,3,32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',689.09,NULL,NULL,1,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(33,7638,40738,30492,3,33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',106277.89,NULL,NULL,1,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(34,7638,40738,30492,3,34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',4463.06,NULL,NULL,1,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(35,7638,40738,30492,3,35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',180.00,NULL,NULL,1,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(36,7638,40738,30492,3,36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',76865.00,NULL,NULL,1,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(37,7638,40738,30492,3,37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',10000.00,NULL,NULL,1,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(38,7638,40738,30492,3,38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',257104.57,NULL,NULL,1,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(39,7638,40738,30492,3,39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',135.00,NULL,NULL,1,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(40,7638,40738,30492,3,40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',412499.99,NULL,NULL,1,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(41,7638,40738,30492,3,41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',412499.97,NULL,NULL,1,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(42,7638,40738,30492,3,42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',412499.97,NULL,NULL,1,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(43,7638,40738,30492,3,43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',412499.99,NULL,NULL,1,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(44,7638,40738,30492,3,44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',102900.00,NULL,NULL,1,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(45,7638,40738,30492,3,45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',412499.99,NULL,NULL,1,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(46,7638,40738,30492,3,46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1752.60,NULL,NULL,1,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(47,7638,40738,30492,3,47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',26.23,NULL,NULL,1,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(48,7638,40738,30492,3,48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',7998.00,NULL,NULL,1,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(49,7638,40731,19536,3,49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',100752.00,NULL,NULL,1,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(50,7638,40731,19536,3,50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',19768.95,NULL,NULL,1,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL);
INSERT INTO `balance_libro` VALUES (51,7638,40731,19536,3,51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',22457.25,NULL,NULL,1,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(52,7638,40731,19536,3,52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',7490.00,NULL,NULL,1,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(53,7638,40731,19536,3,53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',19102.41,NULL,NULL,1,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(54,7638,40731,19536,3,54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',200000.00,NULL,NULL,1,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(55,7638,40731,19536,3,55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',210994.73,NULL,NULL,1,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(56,7638,40731,19536,3,56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',277197.76,NULL,NULL,1,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(57,7638,40731,19536,3,57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',4000.00,NULL,NULL,1,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(58,7638,40731,19536,3,58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',38913.36,NULL,NULL,1,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(59,7638,40731,19536,3,59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',12473.22,NULL,NULL,1,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(60,7638,40731,19536,3,60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',737.76,NULL,NULL,1,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(61,7638,40731,19536,3,61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',290000.00,NULL,NULL,1,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(62,7638,40731,19536,3,62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',36000.00,NULL,NULL,1,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(63,7638,40731,19536,3,63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',4286.30,NULL,NULL,1,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(64,7638,40731,19536,3,64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',36574.88,NULL,NULL,1,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(65,7638,40731,19536,3,65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',100000.00,NULL,NULL,1,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(66,7638,40731,19536,3,66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',61999.19,NULL,NULL,1,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(67,7638,40731,19536,3,67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',5218.21,NULL,NULL,1,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(68,7638,40731,19536,3,68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',107378.46,NULL,NULL,1,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(69,7638,40731,19536,3,69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',282280.00,NULL,NULL,1,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(70,7638,40731,19536,3,70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',150000.00,NULL,NULL,1,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(71,7638,40731,19536,3,71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',13257.69,NULL,NULL,1,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(72,7638,40731,19536,3,72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',105913.44,NULL,NULL,1,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(73,7638,40731,19536,3,73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',123640.51,NULL,NULL,1,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(74,7638,40731,19536,3,74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',148444.70,NULL,NULL,1,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(75,7638,40731,19536,3,75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2898.20,NULL,NULL,1,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL);
INSERT INTO `balance_libro` VALUES (76,7638,40731,19536,3,76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',14702.57,NULL,NULL,1,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(77,7638,40731,19536,3,77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',7107.44,NULL,NULL,1,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(78,7638,40744,40458,2,78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',99946.00,NULL,NULL,1,'2022-11-24 13:37:43','2022-11-24 13:37:43',NULL),(79,7638,40744,40458,2,79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',130317.00,NULL,NULL,1,'2022-11-24 13:37:44','2022-11-24 13:37:44',NULL),(80,7638,40744,40458,2,80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',260150.00,NULL,NULL,1,'2022-11-24 13:37:44','2022-11-24 13:37:44',NULL),(81,7638,40744,40458,2,81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',56870.00,NULL,NULL,1,'2022-11-24 13:37:44','2022-11-24 13:37:44',NULL),(82,7638,40744,40458,2,82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',184001.07,NULL,NULL,1,'2022-11-24 13:37:44','2022-11-24 13:37:44',NULL),(83,7638,40744,40458,3,83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',1175.00,NULL,NULL,1,'2022-11-24 13:38:01','2022-11-24 13:38:01',NULL),(84,7638,40744,40458,3,84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',2168.00,NULL,NULL,1,'2022-11-24 13:38:01','2022-11-24 13:38:01',NULL),(85,7638,40744,40458,3,85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',2819.30,NULL,NULL,1,'2022-11-24 13:38:01','2022-11-24 13:38:01',NULL),(86,7638,40744,40458,3,86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1850.00,NULL,NULL,1,'2022-11-24 13:38:01','2022-11-24 13:38:01',NULL),(87,7638,40744,40458,3,87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',5919.82,NULL,NULL,1,'2022-11-24 13:38:01','2022-11-24 13:38:01',NULL),(88,7638,40744,40458,3,88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',1300.00,NULL,NULL,1,'2022-11-24 13:38:01','2022-11-24 13:38:01',NULL),(89,7638,40744,40458,3,89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',7499.00,NULL,NULL,1,'2022-11-24 13:38:01','2022-11-24 13:38:01',NULL),(90,7638,40732,21058,2,90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',519234.30,NULL,NULL,1,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(91,7638,40732,21058,2,91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',324689.68,NULL,NULL,1,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(92,7638,40732,21058,2,92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',224014.75,NULL,NULL,1,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(93,7638,40732,21058,2,93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',283607.21,NULL,NULL,1,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(94,7638,40732,21058,2,94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',46721.40,NULL,NULL,1,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(95,7638,40732,21058,2,95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',164014.92,NULL,NULL,1,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(96,7638,40732,21058,2,96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',28222.06,NULL,NULL,1,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(97,7638,40732,21058,2,97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',12564.47,NULL,NULL,1,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(98,7638,40732,21058,2,98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',8696.80,NULL,NULL,1,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(99,7638,40732,21058,2,99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',12006.58,NULL,NULL,1,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(100,7638,40732,21058,2,100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',30567.81,NULL,NULL,1,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL);
INSERT INTO `balance_libro` VALUES (101,7638,40732,21058,3,101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',18525.16,NULL,NULL,1,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(102,7638,40732,21058,3,102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',3688.08,NULL,NULL,1,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(103,7638,40732,21058,3,103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',9791.01,NULL,NULL,1,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(104,7638,40732,21058,3,104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',8268.32,NULL,NULL,1,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(105,7638,40732,21058,3,105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1354.56,NULL,NULL,1,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(106,7638,40732,21058,3,106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',3657.50,NULL,NULL,1,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(107,7638,40732,21058,3,107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',5540.44,NULL,NULL,1,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(108,7638,40732,21058,3,108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',20424.82,NULL,NULL,1,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(109,7638,40732,21058,3,109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',96000.00,NULL,NULL,1,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(110,7638,40732,21058,3,110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',14889.00,NULL,NULL,1,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(111,7638,40732,21058,3,111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',22854.00,NULL,NULL,1,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(112,7638,40732,21058,3,112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',11249.00,NULL,NULL,1,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(113,7638,40732,21058,3,113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',11249.00,NULL,NULL,1,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(114,7638,40732,21058,3,114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',5780.00,NULL,NULL,1,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(115,7638,40732,21058,3,115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',13448.60,NULL,NULL,1,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(116,7638,40732,21058,3,116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',5884.29,NULL,NULL,1,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(117,7638,40732,21058,3,117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',20424.82,NULL,NULL,1,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(118,7638,40732,21058,3,118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',460.00,NULL,NULL,1,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(119,7638,40732,21058,3,119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',850.00,NULL,NULL,1,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(120,7638,40732,21058,3,120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1150.00,NULL,NULL,1,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(121,7638,40732,21058,3,121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1150.00,NULL,NULL,1,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(122,7638,40732,21058,3,122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',4101.20,NULL,NULL,1,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(123,7638,40732,21058,3,123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',6427.00,NULL,NULL,1,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(124,7638,40732,21058,3,124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',8748.61,NULL,NULL,1,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL);
INSERT INTO `balance_libro` VALUES (125,7638,40732,21058,3,125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',11500.00,NULL,NULL,1,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(126,7638,40732,21058,3,126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',0.02,NULL,NULL,1,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(127,7638,40732,21058,3,127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',6298.85,NULL,NULL,1,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(128,7638,40747,45167,3,128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',101.62,NULL,NULL,1,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL),(129,7638,40747,45167,3,129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',37794.29,NULL,NULL,1,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL),(130,7638,40747,45167,3,130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',38203.27,NULL,NULL,1,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL),(131,7638,40747,45167,3,131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',96000.00,NULL,NULL,1,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL),(132,7638,40747,45167,3,132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',8550.00,NULL,NULL,1,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL),(133,7638,40747,45167,3,133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',13607.68,NULL,NULL,1,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL),(134,7638,40747,45167,3,134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',9007.17,NULL,NULL,1,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL),(135,7638,40747,45167,3,135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',7772.86,NULL,NULL,1,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL),(136,7638,40747,45167,3,136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',4572.98,NULL,NULL,1,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL),(137,7638,40736,27281,2,137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',890.00,NULL,NULL,1,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(138,7638,40736,27281,2,138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',1145.00,NULL,NULL,1,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(139,7638,40736,27281,2,139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',980.00,NULL,NULL,1,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(140,7638,40736,27281,2,140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',725.00,NULL,NULL,1,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(141,7638,40736,27281,2,141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',980.00,NULL,NULL,1,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(142,7638,40736,27281,2,142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',1040.00,NULL,NULL,1,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(143,7638,40736,27281,2,143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',970.00,NULL,NULL,1,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(144,7638,40736,27281,2,144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',1065.00,NULL,NULL,1,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(145,7638,40736,27281,2,145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',1245.00,NULL,NULL,1,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(146,7638,40736,27281,2,146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',919.00,NULL,NULL,1,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(147,7638,40736,27281,2,147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',1205.00,NULL,NULL,1,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(148,7638,40736,27281,2,148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',960.00,NULL,NULL,1,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(149,7638,40736,27281,2,149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',935.00,NULL,NULL,1,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL);
INSERT INTO `balance_libro` VALUES (150,7638,40736,27281,2,150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',1150.00,NULL,NULL,1,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(151,7638,40736,27281,2,151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',965.00,NULL,NULL,1,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(152,7638,40736,27281,2,152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',1035.00,NULL,NULL,1,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(153,7638,40736,27281,2,153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',1060.00,NULL,NULL,1,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(154,7638,40736,27281,2,154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',1015.00,NULL,NULL,1,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(155,7638,40736,27281,2,155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',985.00,NULL,NULL,1,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(156,7638,40736,27281,2,156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',1065.00,NULL,NULL,1,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(157,7638,40736,27281,2,157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',900.00,NULL,NULL,1,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(158,7638,40736,27281,2,158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',895.00,NULL,NULL,1,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(159,7638,40736,27281,2,159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1220.00,NULL,NULL,1,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(160,7638,40736,27281,2,160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1229.00,NULL,NULL,1,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(161,7638,40736,27281,2,161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',975.00,NULL,NULL,1,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(162,7638,40736,27281,2,162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1195.00,NULL,NULL,1,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(163,7638,40736,27281,2,163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',985.00,NULL,NULL,1,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(164,7638,40736,27281,2,164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',955.00,NULL,NULL,1,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(165,7638,40736,27281,2,165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',960.00,NULL,NULL,1,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(166,7638,40736,27281,2,166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',943.00,NULL,NULL,1,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(167,7638,40736,27281,2,167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',905.00,NULL,NULL,1,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(168,7638,40736,27281,2,168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1245.00,NULL,NULL,1,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(169,7638,40736,27281,2,169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',925.00,NULL,NULL,1,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(170,7638,40736,27281,2,170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1005.00,NULL,NULL,1,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(171,7638,40736,27281,2,171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',885.00,NULL,NULL,1,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(172,7638,40736,27281,2,172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1055.00,NULL,NULL,1,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(173,7638,40736,27281,2,173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1130.00,NULL,NULL,1,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(174,7638,40736,27281,2,174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1050.00,NULL,NULL,1,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL);
INSERT INTO `balance_libro` VALUES (175,7638,40736,27281,2,175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1140.00,NULL,NULL,1,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(176,7638,40736,27281,2,176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',885.00,NULL,NULL,1,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(177,7638,40736,27281,2,177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1010.00,NULL,NULL,1,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(178,7638,40736,27281,2,178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1145.00,NULL,NULL,1,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(179,7638,40736,27281,2,179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',730.00,NULL,NULL,1,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(180,7638,40736,27281,2,180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1070.00,NULL,NULL,1,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(181,7638,40736,27281,2,181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1240.00,NULL,NULL,1,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(182,7638,40736,27281,2,182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1260.00,NULL,NULL,1,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(183,7638,40736,27281,2,183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',860.00,NULL,NULL,1,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(184,7638,40736,27281,2,184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1260.00,NULL,NULL,1,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(185,7638,40736,27281,2,185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1090.00,NULL,NULL,1,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(186,7638,40736,27281,2,186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',1180.00,NULL,NULL,1,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(187,7638,40736,27281,2,187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',1100.00,NULL,NULL,1,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(188,7638,40736,27281,2,188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',1195.00,NULL,NULL,1,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(189,7638,40736,27281,2,189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',875.00,NULL,NULL,1,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(190,7638,40736,27281,2,190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',1390.00,NULL,NULL,1,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(191,7638,40736,27281,2,191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',1100.00,NULL,NULL,1,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(192,7638,40736,27281,2,192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',1240.00,NULL,NULL,1,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(193,7638,40736,27281,2,193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',960.00,NULL,NULL,1,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(194,7638,40736,27281,2,194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',945.00,NULL,NULL,1,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(195,7638,40736,27281,2,195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1055.00,NULL,NULL,1,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(196,7638,40736,27281,2,196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1120.00,NULL,NULL,1,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(197,7638,40736,27281,2,197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1400.00,NULL,NULL,1,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(198,7638,40736,27281,2,198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1020.00,NULL,NULL,1,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(199,7638,40736,27281,2,199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1040.00,NULL,NULL,1,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL);
INSERT INTO `balance_libro` VALUES (200,7638,40736,27281,2,200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1135.00,NULL,NULL,1,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(201,7638,40736,27281,2,201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1160.00,NULL,NULL,1,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(202,7638,40736,27281,2,202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',825.00,NULL,NULL,1,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(203,7638,40736,27281,2,203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',895.00,NULL,NULL,1,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(204,7638,40736,27281,2,204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1155.00,NULL,NULL,1,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(205,7638,40736,27281,2,205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1150.00,NULL,NULL,1,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(206,7638,40736,27281,2,206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1275.00,NULL,NULL,1,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(207,7638,40736,27281,2,207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1120.00,NULL,NULL,1,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(208,7638,40736,27281,2,208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1070.00,NULL,NULL,1,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(209,7638,40736,27281,2,209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1075.00,NULL,NULL,1,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(210,7638,40736,27281,2,210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',820.00,NULL,NULL,1,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(211,7638,40736,27281,2,211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1060.00,NULL,NULL,1,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(212,7638,40736,27281,2,212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1030.00,NULL,NULL,1,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(213,7638,40736,27281,2,213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1250.00,NULL,NULL,1,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(214,7638,40736,27281,2,214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',830.00,NULL,NULL,1,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(215,7638,40736,27281,2,215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',890.00,NULL,NULL,1,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(216,7638,40736,27281,2,216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1085.00,NULL,NULL,1,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(217,7638,40736,27281,2,217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1035.00,NULL,NULL,1,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(218,7638,40736,27281,2,218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1130.00,NULL,NULL,1,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(219,7638,40736,27281,2,219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1330.00,NULL,NULL,1,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(220,7638,40736,27281,2,220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1120.00,NULL,NULL,1,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(221,7638,40736,27281,2,221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1340.00,NULL,NULL,1,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(222,7638,40736,27281,2,222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1240.00,NULL,NULL,1,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(223,7638,40736,27281,2,223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',885.00,NULL,NULL,1,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(224,7638,40736,27281,2,224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1240.00,NULL,NULL,1,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL);
INSERT INTO `balance_libro` VALUES (225,7638,40736,27281,2,225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1005.00,NULL,NULL,1,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(226,7638,40736,27281,2,226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1035.00,NULL,NULL,1,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(227,7638,40736,27281,2,227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1075.00,NULL,NULL,1,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(228,7638,40736,27281,2,228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1085.00,NULL,NULL,1,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(229,7638,40736,27281,2,229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1111.00,NULL,NULL,1,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(230,7638,40736,27281,2,230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1195.00,NULL,NULL,1,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(231,7638,40736,27281,2,231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',940.00,NULL,NULL,1,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(232,7638,40736,27281,2,232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1075.00,NULL,NULL,1,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(233,7638,40736,27281,2,233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',780.00,NULL,NULL,1,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(234,7638,40736,27281,2,234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1170.00,NULL,NULL,1,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(235,7638,40736,27281,2,235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1245.00,NULL,NULL,1,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(236,7638,40736,27281,2,236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1155.00,NULL,NULL,1,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(237,7638,40736,27281,2,237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1115.00,NULL,NULL,1,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(238,7638,40736,27281,2,238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',1135.00,NULL,NULL,1,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(239,7638,40736,27281,2,239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',1010.00,NULL,NULL,1,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(240,7638,40736,27281,2,240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',1005.00,NULL,NULL,1,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(241,7638,40736,27281,2,241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',1175.00,NULL,NULL,1,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(242,7638,40736,27281,2,242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',1183.00,NULL,NULL,1,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(243,7638,40736,27281,2,243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',1225.00,NULL,NULL,1,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(244,7638,40736,27281,2,244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',1390.00,NULL,NULL,1,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(245,7638,40736,27281,2,245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',1215.00,NULL,NULL,1,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(246,7638,40736,27281,2,246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',960.00,NULL,NULL,1,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(247,7638,40736,27281,2,247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',1425.00,NULL,NULL,1,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(248,7638,40736,27281,2,248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',1195.00,NULL,NULL,1,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(249,7638,40736,27281,2,249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',1130.00,NULL,NULL,1,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL);
INSERT INTO `balance_libro` VALUES (250,7638,40736,27281,2,250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',1420.00,NULL,NULL,1,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(251,7638,40736,27281,2,251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',1320.00,NULL,NULL,1,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(252,7638,40736,27281,2,252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1160.00,NULL,NULL,1,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(253,7638,40736,27281,2,253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1225.00,NULL,NULL,1,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(254,7638,40736,27281,2,254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1285.00,NULL,NULL,1,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(255,7638,40736,27281,2,255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1380.00,NULL,NULL,1,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(256,7638,40736,27281,2,256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1119.00,NULL,NULL,1,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(257,7638,40736,27281,2,257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1295.00,NULL,NULL,1,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(258,7638,40736,27281,2,258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1405.00,NULL,NULL,1,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(259,7638,40736,27281,2,259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1105.00,NULL,NULL,1,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(260,7638,40736,27281,2,260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1385.00,NULL,NULL,1,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(261,7638,40736,27281,2,261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',990.00,NULL,NULL,1,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(262,7638,40736,27281,2,262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1295.00,NULL,NULL,1,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(263,7638,40736,27281,2,263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1070.00,NULL,NULL,1,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(264,7638,40736,27281,2,264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1065.00,NULL,NULL,1,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(265,7638,40736,27281,2,265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1210.00,NULL,NULL,1,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(266,7638,40736,27281,2,266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1310.00,NULL,NULL,1,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(267,7638,40736,27281,2,267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',1265.00,NULL,NULL,1,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(268,7638,40736,27281,2,268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',920.00,NULL,NULL,1,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(269,7638,40736,27281,2,269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',1285.00,NULL,NULL,1,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(270,7638,40736,27281,2,270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',1160.00,NULL,NULL,1,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(271,7638,40736,27281,2,271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',1230.00,NULL,NULL,1,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(272,7638,40736,27281,2,272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',1170.00,NULL,NULL,1,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(273,7638,40736,27281,2,273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',1255.00,NULL,NULL,1,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(274,7638,40736,27281,2,274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',1350.00,NULL,NULL,1,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL);
INSERT INTO `balance_libro` VALUES (275,7638,40736,27281,2,275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',1235.00,NULL,NULL,1,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(276,7638,40736,27281,2,276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',985.00,NULL,NULL,1,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(277,7638,40736,27281,2,277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',1200.00,NULL,NULL,1,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(278,7638,40736,27281,2,278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',1235.00,NULL,NULL,1,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(279,7638,40736,27281,2,279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',1214.00,NULL,NULL,1,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(280,7638,40736,27281,2,280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',1015.00,NULL,NULL,1,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(281,7638,40736,27281,2,281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',1315.00,NULL,NULL,1,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(282,7638,40736,27281,2,282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1020.00,NULL,NULL,1,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(283,7638,40736,27281,2,283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1060.00,NULL,NULL,1,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(284,7638,40736,27281,2,284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1480.00,NULL,NULL,1,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(285,7638,40736,27281,2,285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',950.00,NULL,NULL,1,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(286,7638,40736,27281,2,286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',920.00,NULL,NULL,1,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(287,7638,40736,27281,2,287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1305.00,NULL,NULL,1,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(288,7638,40736,27281,2,288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1255.00,NULL,NULL,1,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(289,7638,40736,27281,2,289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1170.00,NULL,NULL,1,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(290,7638,40736,27281,2,290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1230.00,NULL,NULL,1,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(291,7638,40736,27281,2,291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',835.00,NULL,NULL,1,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(292,7638,40736,27281,2,292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1220.00,NULL,NULL,1,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(293,7638,40736,27281,2,293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1380.00,NULL,NULL,1,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(294,7638,40736,27281,2,294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1185.00,NULL,NULL,1,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(295,7638,40736,27281,2,295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1220.00,NULL,NULL,1,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(296,7638,40736,27281,2,296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',870.00,NULL,NULL,1,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(297,7638,40736,27281,2,297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1005.00,NULL,NULL,1,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(298,7638,40736,27281,2,298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1130.00,NULL,NULL,1,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(299,7638,40736,27281,2,299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1030.00,NULL,NULL,1,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL);
INSERT INTO `balance_libro` VALUES (300,7638,40736,27281,2,300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1270.00,NULL,NULL,1,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(301,7638,40736,27281,2,301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',790.00,NULL,NULL,1,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(302,7638,40736,27281,2,302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1265.00,NULL,NULL,1,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(303,7638,40736,27281,2,303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1230.00,NULL,NULL,1,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(304,7638,40736,27281,2,304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1460.00,NULL,NULL,1,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(305,7638,40736,27281,2,305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',880.00,NULL,NULL,1,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(306,7638,40736,27281,2,306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1085.00,NULL,NULL,1,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(307,7638,40736,27281,2,307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1105.00,NULL,NULL,1,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(308,7638,40736,27281,2,308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',906.00,NULL,NULL,1,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(309,7638,40736,27281,2,309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1255.00,NULL,NULL,1,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(310,7638,40736,27281,2,310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1380.00,NULL,NULL,1,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(311,7638,40736,27281,2,311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',970.00,NULL,NULL,1,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(312,7638,40736,27281,2,312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1110.00,NULL,NULL,1,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(313,7638,40736,27281,2,313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',990.00,NULL,NULL,1,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(314,7638,40736,27281,2,314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1040.00,NULL,NULL,1,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(315,7638,40736,27281,2,315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1165.00,NULL,NULL,1,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(316,7638,40736,27281,2,316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1265.00,NULL,NULL,1,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(317,7638,40736,27281,2,317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1120.00,NULL,NULL,1,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(318,7638,40736,27281,2,318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1016.00,NULL,NULL,1,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(319,7638,40736,27281,2,319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',915.00,NULL,NULL,1,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(320,7638,40736,27281,2,320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1305.00,NULL,NULL,1,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(321,7638,40736,27281,2,321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1150.00,NULL,NULL,1,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(322,7638,40736,27281,2,322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',885.00,NULL,NULL,1,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(323,7638,40736,27281,2,323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1194.00,NULL,NULL,1,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(324,7638,40736,27281,2,324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1460.00,NULL,NULL,1,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL);
INSERT INTO `balance_libro` VALUES (325,7638,40736,27281,2,325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1240.00,NULL,NULL,1,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(326,7638,40736,27281,2,326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1350.00,NULL,NULL,1,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(327,7638,40736,27281,2,327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1215.00,NULL,NULL,1,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(328,7638,40736,27281,2,328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1160.00,NULL,NULL,1,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(329,7638,40736,27281,2,329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1490.00,NULL,NULL,1,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(330,7638,40736,27281,2,330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1160.00,NULL,NULL,1,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(331,7638,40736,27281,2,331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1140.00,NULL,NULL,1,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(332,7638,40736,27281,2,332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1035.00,NULL,NULL,1,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(333,7638,40736,27281,2,333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',980.00,NULL,NULL,1,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(334,7638,40736,27281,2,334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1045.00,NULL,NULL,1,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(335,7638,40736,27281,2,335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1130.00,NULL,NULL,1,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(336,7638,40736,27281,2,336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',1125.00,NULL,NULL,1,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(337,7638,40736,27281,2,337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',1190.00,NULL,NULL,1,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(338,7638,40736,27281,2,338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',990.00,NULL,NULL,1,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(339,7638,40736,27281,2,339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',1050.00,NULL,NULL,1,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(340,7638,40736,27281,2,340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',1155.00,NULL,NULL,1,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(341,7638,40736,27281,2,341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',860.00,NULL,NULL,1,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(342,7638,40736,27281,2,342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',1040.00,NULL,NULL,1,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(343,7638,40736,27281,2,343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',1105.00,NULL,NULL,1,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(344,7638,40736,27281,2,344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',980.00,NULL,NULL,1,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(345,7638,40736,27281,2,345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',870.00,NULL,NULL,1,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(346,7638,40736,27281,2,346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',1270.00,NULL,NULL,1,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(347,7638,40736,27281,2,347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',1100.00,NULL,NULL,1,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(348,7638,40736,27281,2,348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',1160.00,NULL,NULL,1,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(349,7638,40736,27281,2,349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',930.00,NULL,NULL,1,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL);
INSERT INTO `balance_libro` VALUES (350,7638,40736,27281,2,350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',1320.00,NULL,NULL,1,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(351,7638,40736,27281,2,351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',950.00,NULL,NULL,1,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(352,7638,40736,27281,2,352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',1180.00,NULL,NULL,1,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(353,7638,40736,27281,2,353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',880.00,NULL,NULL,1,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(354,7638,40736,27281,2,354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',1140.00,NULL,NULL,1,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(355,7638,40736,27281,2,355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',1150.00,NULL,NULL,1,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(356,7638,40736,27281,2,356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',1050.00,NULL,NULL,1,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(357,7638,40736,27281,2,357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',1180.00,NULL,NULL,1,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(358,7638,40736,27281,2,358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',1050.00,NULL,NULL,1,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(359,7638,40736,27281,2,359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',1430.00,NULL,NULL,1,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(360,7638,40736,27281,2,360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',975.00,NULL,NULL,1,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(361,7638,40736,27281,2,361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',1360.00,NULL,NULL,1,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(362,7638,40736,27281,2,362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',1170.00,NULL,NULL,1,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(363,7638,40736,27281,2,363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',1230.00,NULL,NULL,1,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(364,7638,40736,27281,2,364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',920.00,NULL,NULL,1,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(365,7638,40736,27281,2,365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',1300.00,NULL,NULL,1,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(366,7638,40736,27281,2,366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',1075.00,NULL,NULL,1,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(367,7638,40736,27281,2,367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',1480.00,NULL,NULL,1,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(368,7638,40736,27281,2,368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',1585.00,NULL,NULL,1,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(369,7638,40736,27281,2,369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',930.00,NULL,NULL,1,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(370,7638,40736,27281,2,370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',1185.00,NULL,NULL,1,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(371,7638,40736,27281,2,371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',890.00,NULL,NULL,1,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(372,7638,40736,27281,2,372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',1020.00,NULL,NULL,1,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(373,7638,40736,27281,2,373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',1170.00,NULL,NULL,1,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(374,7638,40736,27281,2,374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',1145.00,NULL,NULL,1,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL);
INSERT INTO `balance_libro` VALUES (375,7638,40736,27281,2,375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',1230.00,NULL,NULL,1,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(376,7638,40736,27281,2,376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',930.00,NULL,NULL,1,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(377,7638,40736,27281,2,377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',900.00,NULL,NULL,1,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(378,7638,40736,27281,2,378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',960.00,NULL,NULL,1,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(379,7638,40736,27281,2,379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',950.00,NULL,NULL,1,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(380,7638,40736,27281,2,380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1120.00,NULL,NULL,1,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(381,7638,40736,27281,2,381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1265.00,NULL,NULL,1,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(382,7638,40736,27281,2,382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1465.00,NULL,NULL,1,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(383,7638,40736,27281,2,383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1135.00,NULL,NULL,1,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(384,7638,40736,27281,2,384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1170.00,NULL,NULL,1,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(385,7638,40736,27281,2,385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1470.00,NULL,NULL,1,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(386,7638,40736,27281,2,386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',800.00,NULL,NULL,1,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(387,7638,40736,27281,2,387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1350.00,NULL,NULL,1,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(388,7638,40736,27281,2,388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1080.00,NULL,NULL,1,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(389,7638,40736,27281,2,389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1150.00,NULL,NULL,1,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(390,7638,40736,27281,2,390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',1350.00,NULL,NULL,1,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(391,7638,40736,27281,2,391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',940.00,NULL,NULL,1,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(392,7638,40736,27281,2,392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',1065.00,NULL,NULL,1,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(393,7638,40736,27281,2,393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',1350.00,NULL,NULL,1,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(394,7638,40736,27281,2,394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',970.00,NULL,NULL,1,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(395,7638,40736,27281,2,395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',1125.00,NULL,NULL,1,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(396,7638,40736,27281,2,396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',951.00,NULL,NULL,1,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(397,7638,40736,27281,2,397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',1020.00,NULL,NULL,1,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(398,7638,40736,27281,2,398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',1145.00,NULL,NULL,1,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(399,7638,40736,27281,2,399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',1140.00,NULL,NULL,1,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL);
INSERT INTO `balance_libro` VALUES (400,7638,40736,27281,2,400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1235.00,NULL,NULL,1,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(401,7638,40736,27281,2,401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1350.00,NULL,NULL,1,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(402,7638,40736,27281,2,402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1325.00,NULL,NULL,1,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(403,7638,40736,27281,2,403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1430.00,NULL,NULL,1,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(404,7638,40736,27281,2,404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1190.00,NULL,NULL,1,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(405,7638,40736,27281,2,405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1085.00,NULL,NULL,1,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(406,7638,40736,27281,2,406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1225.00,NULL,NULL,1,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(407,7638,40736,27281,2,407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1405.00,NULL,NULL,1,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(408,7638,40736,27281,2,408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1000.00,NULL,NULL,1,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(409,7638,40736,27281,2,409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1295.00,NULL,NULL,1,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(410,7638,40736,27281,2,410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1230.00,NULL,NULL,1,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(411,7638,40736,27281,2,411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1020.00,NULL,NULL,1,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(412,7638,40736,27281,2,412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1115.00,NULL,NULL,1,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(413,7638,40736,27281,2,413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1190.00,NULL,NULL,1,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(414,7638,40736,27281,2,414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1205.00,NULL,NULL,1,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(415,7638,40736,27281,2,415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1180.00,NULL,NULL,1,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(416,7638,40736,27281,2,416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1385.00,NULL,NULL,1,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(417,7638,40736,27281,2,417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1204.00,NULL,NULL,1,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(418,7638,40736,27281,2,418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1285.00,NULL,NULL,1,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(419,7638,40736,27281,2,419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1098.00,NULL,NULL,1,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(420,7638,40736,27281,2,420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1245.00,NULL,NULL,1,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(421,7638,40736,27281,2,421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1175.00,NULL,NULL,1,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(422,7638,40736,27281,2,422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1165.00,NULL,NULL,1,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(423,7638,40736,27281,2,423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1065.00,NULL,NULL,1,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(424,7638,40736,27281,2,424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1290.00,NULL,NULL,1,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL);
INSERT INTO `balance_libro` VALUES (425,7638,40736,27281,2,425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1200.00,NULL,NULL,1,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(426,7638,40736,27281,2,426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1200.00,NULL,NULL,1,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(427,7638,40736,27281,2,427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1290.00,NULL,NULL,1,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(428,7638,40736,27281,2,428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1040.00,NULL,NULL,1,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(429,7638,40736,27281,2,429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1150.00,NULL,NULL,1,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(430,7638,40736,27281,2,430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1125.00,NULL,NULL,1,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(431,7638,40736,27281,2,431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1280.00,NULL,NULL,1,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(432,7638,40736,27281,2,432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1200.00,NULL,NULL,1,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(433,7638,40736,27281,2,433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1168.00,NULL,NULL,1,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(434,7638,40736,27281,2,434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1290.00,NULL,NULL,1,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(435,7638,40736,27281,2,435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1120.00,NULL,NULL,1,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(436,7638,40736,27281,2,436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1240.00,NULL,NULL,1,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(437,7638,40736,27281,2,437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',890.00,NULL,NULL,1,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(438,7638,40736,27281,2,438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1125.00,NULL,NULL,1,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(439,7638,40736,27281,2,439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',975.00,NULL,NULL,1,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(440,7638,40736,27281,2,440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1265.00,NULL,NULL,1,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(441,7638,40736,27281,2,441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',990.00,NULL,NULL,1,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(442,7638,40736,27281,2,442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1915.00,NULL,NULL,1,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(443,7638,40736,27281,2,443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1115.00,NULL,NULL,1,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(444,7638,40736,27281,2,444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',815.00,NULL,NULL,1,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(445,7638,40736,27281,2,445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',935.00,NULL,NULL,1,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(446,7638,40736,27281,2,446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1130.00,NULL,NULL,1,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(447,7638,40736,27281,2,447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',965.00,NULL,NULL,1,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(448,7638,40736,27281,2,448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',850.00,NULL,NULL,1,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(449,7638,40736,27281,2,449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1120.00,NULL,NULL,1,'2022-11-24 13:54:41','2022-11-24 13:54:41',NULL);
INSERT INTO `balance_libro` VALUES (450,7638,40736,27281,2,450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1170.00,NULL,NULL,1,'2022-11-24 13:54:41','2022-11-24 13:54:41',NULL),(451,7638,40736,27281,2,451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1175.00,NULL,NULL,1,'2022-11-24 13:54:41','2022-11-24 13:54:41',NULL),(452,7638,40736,27281,2,452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1090.00,NULL,NULL,1,'2022-11-24 13:54:41','2022-11-24 13:54:41',NULL),(453,7638,40736,27281,2,453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',990.00,NULL,NULL,1,'2022-11-24 13:54:41','2022-11-24 13:54:41',NULL),(454,7638,40736,27281,2,454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',985.00,NULL,NULL,1,'2022-11-24 13:54:41','2022-11-24 13:54:41',NULL),(455,7638,40736,27281,2,455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1060.00,NULL,NULL,1,'2022-11-24 13:54:41','2022-11-24 13:54:41',NULL),(456,7638,40736,27281,3,456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',5248.01,NULL,NULL,1,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(457,7638,40736,27281,3,457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',24467.35,NULL,NULL,1,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(458,7638,40736,27281,3,458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',21997.11,NULL,NULL,1,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(459,7638,40736,27281,3,459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',21163.53,NULL,NULL,1,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(460,7638,40736,27281,3,460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',38204.12,NULL,NULL,1,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(461,7638,40736,27281,3,461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',4864.89,NULL,NULL,1,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(462,7638,40736,27281,3,462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',560.46,NULL,NULL,1,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(463,7638,40736,27281,3,463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',6433.80,NULL,NULL,1,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(464,7638,40736,27281,3,464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',6433.81,NULL,NULL,1,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(465,7638,40736,27281,3,465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',20677.78,NULL,NULL,1,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(466,7638,40736,27281,3,466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',25209.39,NULL,NULL,1,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(467,7638,40736,27281,3,467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',8340.02,NULL,NULL,1,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(468,7638,40736,27281,3,468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',8472.44,NULL,NULL,1,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(469,7638,40736,27281,3,469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',8472.45,NULL,NULL,1,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(470,7638,40736,27281,3,470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',165.42,NULL,NULL,1,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(471,7638,40736,27281,3,471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',15424.95,NULL,NULL,1,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(472,7638,40736,27281,3,472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',6670.74,NULL,NULL,1,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(473,7638,40736,27281,3,473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',5213.07,NULL,NULL,1,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(474,7638,40736,27281,3,474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',1009.22,NULL,NULL,1,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL);
INSERT INTO `balance_libro` VALUES (475,7638,40736,27281,3,475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',365.01,NULL,NULL,1,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(476,7638,40736,27281,3,476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',1424.85,NULL,NULL,1,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(477,7638,40736,27281,3,477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',22211.03,NULL,NULL,1,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(478,7638,40736,27281,3,478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',15333.97,NULL,NULL,1,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(479,7638,40746,43585,3,479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',4287.15,NULL,NULL,1,'2022-11-24 13:58:23','2022-11-24 13:58:23',NULL),(480,7638,40746,43585,3,480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',6600.00,NULL,NULL,1,'2022-11-24 13:58:23','2022-11-24 13:58:23',NULL),(481,7638,40746,43585,3,481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',3688.99,NULL,NULL,1,'2022-11-24 13:58:23','2022-11-24 13:58:23',NULL),(482,7638,40737,28794,2,482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',14365.00,NULL,NULL,1,'2022-11-24 14:03:39','2022-11-24 14:03:39',NULL),(483,7638,40737,28794,2,483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',37570.00,NULL,NULL,1,'2022-11-24 14:03:39','2022-11-24 14:03:39',NULL),(484,7638,40737,28794,2,484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',19337.50,NULL,NULL,1,'2022-11-24 14:03:39','2022-11-24 14:03:39',NULL),(485,7638,40737,28794,2,485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',41140.00,NULL,NULL,1,'2022-11-24 14:03:39','2022-11-24 14:03:39',NULL),(486,7638,40737,28794,2,486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',21175.00,NULL,NULL,1,'2022-11-24 14:03:39','2022-11-24 14:03:39',NULL),(487,7638,40737,28794,2,487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',37570.00,NULL,NULL,1,'2022-11-24 14:03:39','2022-11-24 14:03:39',NULL),(488,7638,40737,28794,2,488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',19337.50,NULL,NULL,1,'2022-11-24 14:03:39','2022-11-24 14:03:39',NULL),(489,7638,40737,28794,2,489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',66550.00,NULL,NULL,1,'2022-11-24 14:03:39','2022-11-24 14:03:39',NULL),(490,7638,40737,28794,2,490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',42350.00,NULL,NULL,1,'2022-11-24 14:03:39','2022-11-24 14:03:39',NULL),(491,7638,40737,28794,2,491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',12100.00,NULL,NULL,1,'2022-11-24 14:03:40','2022-11-24 14:03:40',NULL),(492,7638,40737,28794,2,492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',54450.00,NULL,NULL,1,'2022-11-24 14:03:40','2022-11-24 14:03:40',NULL),(493,7638,40737,28794,2,493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',411400.00,NULL,NULL,1,'2022-11-24 14:03:40','2022-11-24 14:03:40',NULL),(494,7638,40737,28794,2,494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',617100.00,NULL,NULL,1,'2022-11-24 14:03:40','2022-11-24 14:03:40',NULL),(495,7638,40737,28794,3,495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',2662.00,NULL,NULL,1,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(496,7638,40737,28794,3,496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',8350.63,NULL,NULL,1,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(497,7638,40737,28794,3,497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',7290.61,NULL,NULL,1,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(498,7638,40737,28794,3,498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',7290.61,NULL,NULL,1,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL);
INSERT INTO `balance_libro` VALUES (499,7638,40737,28794,3,499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',7290.61,NULL,NULL,1,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(500,7638,40737,28794,3,500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',8300.00,NULL,NULL,1,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(501,7638,40737,28794,3,501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',19390.24,NULL,NULL,1,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(502,7638,40737,28794,3,502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',2126.94,NULL,NULL,1,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(503,7638,40737,28794,3,503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',15666.99,NULL,NULL,1,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(504,7638,40737,28794,3,504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',620.08,NULL,NULL,1,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(505,7638,40737,28794,3,505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1119.99,NULL,NULL,1,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(506,7638,40737,28794,3,506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',22000.00,NULL,NULL,1,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(507,7638,40737,28794,3,507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',469.47,NULL,NULL,1,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(508,7638,40737,28794,3,508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',685.77,NULL,NULL,1,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(509,7638,40737,28794,3,509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',290.45,NULL,NULL,1,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(510,7638,40737,28794,3,510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',24000.34,NULL,NULL,1,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(511,7638,40737,28794,3,511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',2623.50,NULL,NULL,1,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(512,7638,40737,28794,3,512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',11950.49,NULL,NULL,1,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(513,7638,40737,28794,3,513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',2370.00,NULL,NULL,1,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(514,7638,40737,28794,3,514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',75000.00,NULL,NULL,1,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(515,7638,40737,28794,3,515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',48000.00,NULL,NULL,1,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(516,7638,40737,28794,3,516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',935.20,NULL,NULL,1,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(517,7638,40737,28794,3,517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',350.05,NULL,NULL,1,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(518,7638,40737,28794,3,518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',4423.01,NULL,NULL,1,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(519,7638,40737,28794,3,519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',3817.47,NULL,NULL,1,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(520,7638,40737,28794,3,520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',9100.26,NULL,NULL,1,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(521,7638,40737,28794,3,521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',39336.99,NULL,NULL,1,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(522,7638,40737,28794,3,522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',8091.62,NULL,NULL,1,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(523,7638,40737,28794,3,523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',892.51,NULL,NULL,1,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL);
INSERT INTO `balance_libro` VALUES (524,7638,40737,28794,3,524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',10500.00,NULL,NULL,1,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(525,7638,40737,28794,3,525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',867.47,NULL,NULL,1,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(526,7638,40737,28794,3,526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',766.27,NULL,NULL,1,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(527,7638,40737,28794,3,527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',2500.00,NULL,NULL,1,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(528,7638,40737,28794,3,528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',205500.00,NULL,NULL,1,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(529,7638,40737,28794,3,529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',55705.27,NULL,NULL,1,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(530,7638,40737,28794,3,530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',3146.00,NULL,NULL,1,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(531,7638,40737,28794,3,531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',4239.11,NULL,NULL,1,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(532,7638,40737,28794,3,532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',5638.60,NULL,NULL,1,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(533,7638,40737,28794,3,533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',150000.00,NULL,NULL,1,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(534,7638,40737,28794,3,534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',49900.00,NULL,NULL,1,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(535,7638,40737,28794,3,535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',150000.00,NULL,NULL,1,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(536,7638,40737,28794,3,536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1610.00,NULL,NULL,1,'2022-11-24 14:03:52','2022-11-24 14:03:52',NULL),(537,7638,40737,28794,3,537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',18340.21,NULL,NULL,1,'2022-11-24 14:03:52','2022-11-24 14:03:52',NULL),(538,7638,40737,28794,3,538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1000.00,NULL,NULL,1,'2022-11-24 14:03:52','2022-11-24 14:03:52',NULL),(539,7638,40737,28794,3,539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',3300.00,NULL,NULL,1,'2022-11-24 14:03:52','2022-11-24 14:03:52',NULL),(540,7638,40737,28794,3,540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',250.01,NULL,NULL,1,'2022-11-24 14:03:52','2022-11-24 14:03:52',NULL),(541,7638,40737,28794,3,541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1850.01,NULL,NULL,1,'2022-11-24 14:03:52','2022-11-24 14:03:52',NULL),(542,7638,40737,28794,3,542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1179.00,NULL,NULL,1,'2022-11-24 14:03:52','2022-11-24 14:03:52',NULL),(543,7638,40737,28794,3,543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',800.00,NULL,NULL,1,'2022-11-24 14:03:52','2022-11-24 14:03:52',NULL),(544,7638,40737,28794,3,544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2590.00,NULL,NULL,1,'2022-11-24 14:03:52','2022-11-24 14:03:52',NULL),(545,7638,40739,32142,2,545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',147746.43,NULL,NULL,1,'2022-11-24 14:09:05','2022-11-24 14:09:05',NULL),(546,7638,40739,32142,2,546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',201177.66,NULL,NULL,1,'2022-11-24 14:09:05','2022-11-24 14:09:05',NULL),(547,7638,40739,32142,2,547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',5281.15,NULL,NULL,1,'2022-11-24 14:09:05','2022-11-24 14:09:05',NULL);
INSERT INTO `balance_libro` VALUES (548,7638,40739,32142,2,548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',111520.96,NULL,NULL,1,'2022-11-24 14:09:05','2022-11-24 14:09:05',NULL),(549,7638,40739,32142,2,549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',352909.38,NULL,NULL,1,'2022-11-24 14:09:05','2022-11-24 14:09:05',NULL),(550,7638,40739,32142,2,550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',83755.68,NULL,NULL,1,'2022-11-24 14:09:05','2022-11-24 14:09:05',NULL),(551,7638,40739,32142,2,551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',6836.17,NULL,NULL,1,'2022-11-24 14:09:05','2022-11-24 14:09:05',NULL),(552,7638,40739,32142,2,552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',16699.53,NULL,NULL,1,'2022-11-24 14:09:06','2022-11-24 14:09:06',NULL),(553,7638,40739,32142,2,553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',201474.04,NULL,NULL,1,'2022-11-24 14:09:06','2022-11-24 14:09:06',NULL),(554,7638,40739,32142,2,554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',153525.88,NULL,NULL,1,'2022-11-24 14:09:06','2022-11-24 14:09:06',NULL),(555,7638,40739,32142,2,555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',143580.00,NULL,NULL,1,'2022-11-24 14:09:06','2022-11-24 14:09:06',NULL),(556,7638,40739,32142,3,556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',43740.00,NULL,NULL,1,'2022-11-24 14:09:17','2022-11-24 14:09:17',NULL),(557,7638,40739,32142,3,557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',3421.58,NULL,NULL,1,'2022-11-24 14:09:17','2022-11-24 14:09:17',NULL),(558,7638,40739,32142,3,558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',11651.36,NULL,NULL,1,'2022-11-24 14:09:17','2022-11-24 14:09:17',NULL),(559,7638,40739,32142,3,559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',5950.80,NULL,NULL,1,'2022-11-24 14:09:17','2022-11-24 14:09:17',NULL),(560,7638,40739,32142,3,560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',6601.51,NULL,NULL,1,'2022-11-24 14:09:17','2022-11-24 14:09:17',NULL),(561,7638,40739,32142,3,561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',5779.13,NULL,NULL,1,'2022-11-24 14:09:17','2022-11-24 14:09:17',NULL),(562,7638,40739,32142,3,562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',136.00,NULL,NULL,1,'2022-11-24 14:09:18','2022-11-24 14:09:18',NULL),(563,7638,40739,32142,3,563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',455.12,NULL,NULL,1,'2022-11-24 14:09:18','2022-11-24 14:09:18',NULL),(564,7638,40739,32142,3,564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',7398.00,NULL,NULL,1,'2022-11-24 14:09:18','2022-11-24 14:09:18',NULL),(565,7638,40739,32142,3,565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',15001.00,NULL,NULL,1,'2022-11-24 14:09:18','2022-11-24 14:09:18',NULL),(566,7638,40739,32142,3,566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',15431.80,NULL,NULL,1,'2022-11-24 14:09:18','2022-11-24 14:09:18',NULL),(567,7638,40739,32142,3,567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',2250.00,NULL,NULL,1,'2022-11-24 14:09:18','2022-11-24 14:09:18',NULL),(568,7638,40739,32142,3,568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',14500.00,NULL,NULL,1,'2022-11-24 14:09:18','2022-11-24 14:09:18',NULL),(569,7638,40739,32142,3,569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',135.00,NULL,NULL,1,'2022-11-24 14:09:18','2022-11-24 14:09:18',NULL),(570,7638,40739,32142,3,570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1820.00,NULL,NULL,1,'2022-11-24 14:09:18','2022-11-24 14:09:18',NULL),(571,7638,40748,46704,2,571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',8000.00,NULL,NULL,1,'2022-11-24 14:11:42','2022-11-24 14:11:42',NULL);
INSERT INTO `balance_libro` VALUES (572,7638,40748,46704,3,572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',26732.50,NULL,NULL,1,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(573,7638,40748,46704,3,573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',139759.90,NULL,NULL,1,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(574,7638,40748,46704,3,574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',139759.90,NULL,NULL,1,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(575,7638,40748,46704,3,575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',140108.04,NULL,NULL,1,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(576,7638,40748,46704,3,576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',75421.98,NULL,NULL,1,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(577,7638,40748,46704,3,577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',10120.50,NULL,NULL,1,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(578,7638,40748,46704,3,578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',27954.75,NULL,NULL,1,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(579,7638,40748,46704,3,579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',3049.59,NULL,NULL,1,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(580,7638,40748,46704,3,580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',44076.50,NULL,NULL,1,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(581,7638,40748,46704,3,581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',55492.76,NULL,NULL,1,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(582,7638,40748,46704,3,582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',37972.44,NULL,NULL,1,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(583,7638,40748,46704,3,583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',21775.61,NULL,NULL,1,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(584,7638,40748,46704,3,584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1693.93,NULL,NULL,1,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(585,7638,40748,46704,3,585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1693.93,NULL,NULL,1,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(586,7638,40748,46704,3,586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',26356.05,NULL,NULL,1,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(587,7638,40748,46704,3,587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',42048.00,NULL,NULL,1,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(588,7638,40748,46704,3,588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',16498.26,NULL,NULL,1,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(589,7638,40748,46704,3,589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',8399.99,NULL,NULL,1,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(590,7638,40748,46704,3,590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',102024.88,NULL,NULL,1,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(591,7638,40748,46704,3,591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',16264.46,NULL,NULL,1,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(592,7638,40748,46704,3,592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',1019.00,NULL,NULL,1,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(593,7638,40748,46704,3,593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',1019.00,NULL,NULL,1,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(594,7638,40748,46704,3,594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',21625.90,NULL,NULL,1,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(595,7638,40748,46704,3,595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',8132.23,NULL,NULL,1,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL);
INSERT INTO `balance_libro` VALUES (596,7638,40748,46704,3,596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',3049.59,NULL,NULL,1,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(597,7638,40748,46704,3,597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',10000.00,NULL,NULL,1,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(598,7638,40748,46704,3,598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',6025.93,NULL,NULL,1,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(599,7638,40748,46704,3,599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',23024.77,NULL,NULL,1,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(600,7638,40748,46704,3,600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',4850.30,NULL,NULL,1,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(601,7638,40748,46704,3,601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',3064.04,NULL,NULL,1,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(602,7638,40748,46704,3,602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',28785.16,NULL,NULL,1,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(603,7638,40748,46704,3,603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',99055.22,NULL,NULL,1,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(604,7638,40748,46704,3,604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',192163.71,NULL,NULL,1,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(605,7638,40748,46704,3,605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',6556.66,NULL,NULL,1,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(606,7638,40748,46704,3,606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',5410.93,NULL,NULL,1,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(607,7638,40748,46704,3,607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',27652.88,NULL,NULL,1,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(608,7638,40748,46704,3,608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',41000.00,NULL,NULL,1,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(609,7638,40743,38883,2,609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',7065.19,NULL,NULL,1,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(610,7638,40743,38883,2,610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',2968.13,NULL,NULL,1,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(611,7638,40743,38883,2,611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',5399.02,NULL,NULL,1,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(612,7638,40743,38883,2,612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',18729.59,NULL,NULL,1,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(613,7638,40743,38883,2,613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',70000.00,NULL,NULL,1,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(614,7638,40743,38883,2,614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',9761.07,NULL,NULL,1,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(615,7638,40743,38883,2,615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',10200.30,NULL,NULL,1,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(616,7638,40743,38883,2,616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',41377.16,NULL,NULL,1,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(617,7638,40743,38883,2,617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',86999.00,NULL,NULL,1,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(618,7638,40743,38883,2,618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',8358.68,NULL,NULL,1,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(619,7638,40743,38883,2,619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',16985.98,NULL,NULL,1,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL);
INSERT INTO `balance_libro` VALUES (620,7638,40743,38883,2,620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',2968.13,NULL,NULL,1,'2022-11-24 14:15:25','2022-11-24 14:15:25',NULL),(621,7638,40743,38883,2,621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',4278.00,NULL,NULL,1,'2022-11-24 14:15:25','2022-11-24 14:15:25',NULL),(622,7638,40743,38883,2,622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',40000.00,NULL,NULL,1,'2022-11-24 14:15:25','2022-11-24 14:15:25',NULL),(623,7638,40743,38883,2,623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',10285.00,NULL,NULL,1,'2022-11-24 14:15:25','2022-11-24 14:15:25',NULL),(624,7638,40743,38883,2,624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',13685.10,NULL,NULL,1,'2022-11-24 14:15:25','2022-11-24 14:15:25',NULL),(625,7638,40743,38883,2,625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',3680.82,NULL,NULL,1,'2022-11-24 14:15:25','2022-11-24 14:15:25',NULL),(626,7638,40743,38883,2,626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',13915.00,NULL,NULL,1,'2022-11-24 14:15:25','2022-11-24 14:15:25',NULL),(627,7638,40743,38883,2,627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',18000.00,NULL,NULL,1,'2022-11-24 14:15:25','2022-11-24 14:15:25',NULL),(628,7638,40743,38883,3,628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',24519.03,NULL,NULL,1,'2022-11-24 14:15:35','2022-11-24 14:15:35',NULL),(629,7638,40743,38883,3,629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',183676.91,NULL,NULL,1,'2022-11-24 14:15:35','2022-11-24 14:15:35',NULL),(630,7638,40743,38883,3,630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',88475.02,NULL,NULL,1,'2022-11-24 14:15:35','2022-11-24 14:15:35',NULL),(631,7638,40743,38883,3,631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',7391.35,NULL,NULL,1,'2022-11-24 14:15:35','2022-11-24 14:15:35',NULL),(632,7638,40743,38883,3,632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',194832.65,NULL,NULL,1,'2022-11-24 14:15:35','2022-11-24 14:15:35',NULL),(633,NULL,40745,42010,2,633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',1230.00,NULL,NULL,1,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(634,NULL,40745,42010,2,634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',370.00,NULL,NULL,1,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(635,NULL,40745,42010,2,635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',900.00,NULL,NULL,1,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(636,NULL,40745,42010,2,636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',1360.00,NULL,NULL,1,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(637,NULL,40745,42010,2,637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',440.00,NULL,NULL,1,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(638,NULL,40745,42010,2,638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',710.00,NULL,NULL,1,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(639,NULL,40745,42010,2,639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',5955.00,NULL,NULL,1,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(640,NULL,40745,42010,2,640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',1000.00,NULL,NULL,1,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(641,NULL,40745,42010,2,641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',100.00,NULL,NULL,1,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(642,NULL,40745,42010,2,642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',530.00,NULL,NULL,1,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(643,NULL,40745,42010,2,643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',1290.00,NULL,NULL,1,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(644,NULL,40745,42010,2,644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',720.00,NULL,NULL,1,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL);
INSERT INTO `balance_libro` VALUES (645,NULL,40745,42010,2,645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',520.00,NULL,NULL,1,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(646,NULL,40745,42010,2,646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',5820.00,NULL,NULL,1,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(647,NULL,40745,42010,2,647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',325.00,NULL,NULL,1,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(648,NULL,40745,42010,2,648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',440.00,NULL,NULL,1,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(649,NULL,40745,42010,2,649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',440.00,NULL,NULL,1,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(650,NULL,40745,42010,2,650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',760.00,NULL,NULL,1,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(651,NULL,40745,42010,2,651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',1000.00,NULL,NULL,1,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(652,NULL,40745,42010,2,652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',3750.00,NULL,NULL,1,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(653,NULL,40745,42010,2,653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',1880.00,NULL,NULL,1,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(654,NULL,40745,42010,2,654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',540.00,NULL,NULL,1,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(655,NULL,40745,42010,2,655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',1791.00,NULL,NULL,1,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(656,NULL,40745,42010,2,656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',1620.00,NULL,NULL,1,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(657,NULL,40745,42010,2,657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',730.00,NULL,NULL,1,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(658,NULL,40745,42010,2,658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',2000.00,NULL,NULL,1,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(659,NULL,40745,42010,2,659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',1600.00,NULL,NULL,1,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(660,NULL,40745,42010,2,660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',320.00,NULL,NULL,1,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(661,NULL,40745,42010,2,661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',1450.00,NULL,NULL,1,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(662,NULL,40745,42010,2,662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',760.00,NULL,NULL,1,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(663,NULL,40745,42010,2,663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',1590.00,NULL,NULL,1,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(664,NULL,40745,42010,2,664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',1500.00,NULL,NULL,1,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(665,NULL,40745,42010,2,665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',1125.00,NULL,NULL,1,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(666,NULL,40745,42010,2,666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',1100.00,NULL,NULL,1,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(667,NULL,40745,42010,2,667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',1000.00,NULL,NULL,1,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(668,NULL,40745,42010,2,668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',550.00,NULL,NULL,1,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(669,NULL,40745,42010,2,669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',3750.00,NULL,NULL,1,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL);
INSERT INTO `balance_libro` VALUES (670,NULL,40745,42010,2,670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',470.00,NULL,NULL,1,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(671,NULL,40745,42010,2,671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',540.00,NULL,NULL,1,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(672,NULL,40745,42010,2,672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',2425.00,NULL,NULL,1,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(673,NULL,40745,42010,2,673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',150.00,NULL,NULL,1,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(674,NULL,40745,42010,2,674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',480.00,NULL,NULL,1,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(675,NULL,40745,42010,2,675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',1300.00,NULL,NULL,1,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(676,NULL,40745,42010,2,676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',7800.00,NULL,NULL,1,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(677,NULL,40745,42010,2,677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',300.00,NULL,NULL,1,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(678,NULL,40745,42010,2,678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',780.00,NULL,NULL,1,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(679,NULL,40745,42010,2,679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',360.00,NULL,NULL,1,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(680,NULL,40745,42010,2,680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',3830.00,NULL,NULL,1,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(681,NULL,40745,42010,2,681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',1635.00,NULL,NULL,1,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(682,NULL,40745,42010,2,682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',920.00,NULL,NULL,1,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(683,NULL,40745,42010,2,683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',1530.00,NULL,NULL,1,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(684,NULL,40745,42010,2,684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',1835.00,NULL,NULL,1,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(685,NULL,40745,42010,2,685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',380.00,NULL,NULL,1,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(686,NULL,40745,42010,2,686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',950.00,NULL,NULL,1,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(687,NULL,40745,42010,2,687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',150.00,NULL,NULL,1,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(688,NULL,40745,42010,2,688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',840.00,NULL,NULL,1,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(689,NULL,40745,42010,2,689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',1635.00,NULL,NULL,1,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(690,NULL,40745,42010,2,690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',1750.00,NULL,NULL,1,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(691,NULL,40745,42010,2,691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',1070.00,NULL,NULL,1,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(692,NULL,40745,42010,2,692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',300.00,NULL,NULL,1,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(693,NULL,40745,42010,2,693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',920.00,NULL,NULL,1,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(694,NULL,40745,42010,2,694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',120.00,NULL,NULL,1,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL);
INSERT INTO `balance_libro` VALUES (695,NULL,40745,42010,2,695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',420.00,NULL,NULL,1,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(696,NULL,40745,42010,2,696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',390.00,NULL,NULL,1,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(697,NULL,40745,42010,2,697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',1245.00,NULL,NULL,1,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(698,NULL,40745,42010,2,698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',430.00,NULL,NULL,1,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(699,NULL,40745,42010,2,699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',570.00,NULL,NULL,1,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(700,NULL,40745,42010,2,700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',1375.00,NULL,NULL,1,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(701,NULL,40745,42010,2,701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',2570.00,NULL,NULL,1,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(702,NULL,40745,42010,2,702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',220.00,NULL,NULL,1,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(703,NULL,40745,42010,2,703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',890.00,NULL,NULL,1,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(704,NULL,40745,42010,2,704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',1150.00,NULL,NULL,1,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(705,NULL,40745,42010,2,705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',655.00,NULL,NULL,1,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(706,NULL,40745,42010,2,706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',320.00,NULL,NULL,1,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(707,NULL,40745,42010,2,707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',2125.00,NULL,NULL,1,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(708,NULL,40745,42010,2,708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',1180.00,NULL,NULL,1,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(709,NULL,40745,42010,2,709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',6110.00,NULL,NULL,1,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(710,NULL,40745,42010,2,710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',530.00,NULL,NULL,1,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(711,NULL,40745,42010,2,711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',320.00,NULL,NULL,1,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(712,NULL,40745,42010,2,712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',300.00,NULL,NULL,1,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(713,NULL,40745,42010,2,713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',800.00,NULL,NULL,1,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(714,NULL,40745,42010,2,714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',495.00,NULL,NULL,1,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(715,NULL,40745,42010,2,715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',1536.00,NULL,NULL,1,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(716,NULL,40745,42010,2,716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',775.00,NULL,NULL,1,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(717,NULL,40745,42010,2,717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',120.00,NULL,NULL,1,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(718,NULL,40745,42010,2,718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',915.00,NULL,NULL,1,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(719,NULL,40745,42010,2,719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',230.00,NULL,NULL,1,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL);
INSERT INTO `balance_libro` VALUES (720,NULL,40745,42010,2,720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',1160.00,NULL,NULL,1,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(721,NULL,40745,42010,2,721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',300.00,NULL,NULL,1,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(722,NULL,40745,42010,2,722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',1575.00,NULL,NULL,1,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(723,NULL,40745,42010,2,723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',1185.00,NULL,NULL,1,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(724,NULL,40745,42010,2,724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',620.00,NULL,NULL,1,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(725,NULL,40745,42010,2,725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',1030.00,NULL,NULL,1,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(726,NULL,40745,42010,2,726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',1305.00,NULL,NULL,1,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(727,NULL,40745,42010,2,727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',320.00,NULL,NULL,1,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(728,NULL,40745,42010,2,728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',2560.00,NULL,NULL,1,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(729,NULL,40745,42010,2,729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',2595.00,NULL,NULL,1,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(730,NULL,40745,42010,2,730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',620.00,NULL,NULL,1,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(731,NULL,40745,42010,2,731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',1000.00,NULL,NULL,1,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(732,NULL,40745,42010,2,732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',500.00,NULL,NULL,1,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(733,NULL,40745,42010,2,733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',900.00,NULL,NULL,1,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(734,NULL,40745,42010,2,734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',2040.00,NULL,NULL,1,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(735,NULL,40745,42010,2,735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',960.00,NULL,NULL,1,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(736,NULL,40745,42010,2,736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',380.00,NULL,NULL,1,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(737,NULL,40745,42010,2,737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',2400.00,NULL,NULL,1,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(738,NULL,40745,42010,2,738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',1610.00,NULL,NULL,1,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(739,NULL,40745,42010,2,739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',360.00,NULL,NULL,1,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(740,NULL,40745,42010,2,740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',450.00,NULL,NULL,1,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(741,NULL,40745,42010,2,741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',183.00,NULL,NULL,1,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(742,NULL,40745,42010,2,742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',200.00,NULL,NULL,1,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(743,NULL,40745,42010,2,743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',290.00,NULL,NULL,1,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(744,NULL,40745,42010,2,744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',210.00,NULL,NULL,1,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL);
INSERT INTO `balance_libro` VALUES (745,NULL,40745,42010,2,745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',1460.00,NULL,NULL,1,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(746,NULL,40745,42010,2,746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',130.00,NULL,NULL,1,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(747,NULL,40745,42010,2,747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',920.00,NULL,NULL,1,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(748,NULL,40745,42010,2,748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',300.00,NULL,NULL,1,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(749,NULL,40745,42010,2,749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',120.00,NULL,NULL,1,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(750,NULL,40745,42010,2,750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',730.00,NULL,NULL,1,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(751,NULL,40745,42010,2,751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',2860.00,NULL,NULL,1,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(752,NULL,40745,42010,2,752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',460.00,NULL,NULL,1,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(753,NULL,40745,42010,2,753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',980.00,NULL,NULL,1,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(754,NULL,40745,42010,2,754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',1810.00,NULL,NULL,1,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(755,NULL,40745,42010,2,755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',100.00,NULL,NULL,1,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(756,NULL,40745,42010,2,756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',2010.00,NULL,NULL,1,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(757,NULL,40745,42010,2,757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',500.00,NULL,NULL,1,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(758,NULL,40745,42010,2,758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',640.00,NULL,NULL,1,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(759,NULL,40745,42010,2,759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',290.00,NULL,NULL,1,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(760,NULL,40745,42010,2,760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',580.00,NULL,NULL,1,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(761,NULL,40745,42010,2,761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',200.00,NULL,NULL,1,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(762,NULL,40745,42010,2,762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',540.00,NULL,NULL,1,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(763,NULL,40745,42010,2,763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',425.00,NULL,NULL,1,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(764,NULL,40745,42010,2,764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',300.00,NULL,NULL,1,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(765,NULL,40745,42010,2,765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',610.00,NULL,NULL,1,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(766,NULL,40745,42010,2,766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',1010.00,NULL,NULL,1,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(767,NULL,40745,42010,2,767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',320.00,NULL,NULL,1,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(768,NULL,40745,42010,2,768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',1160.00,NULL,NULL,1,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(769,NULL,40745,42010,2,769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',500.00,NULL,NULL,1,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL);
INSERT INTO `balance_libro` VALUES (770,NULL,40745,42010,2,770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',120.00,NULL,NULL,1,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(771,NULL,40745,42010,2,771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',260.00,NULL,NULL,1,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(772,NULL,40745,42010,2,772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',330.00,NULL,NULL,1,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(773,NULL,40745,42010,2,773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',390.00,NULL,NULL,1,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(774,NULL,40745,42010,2,774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',400.00,NULL,NULL,1,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(775,NULL,40745,42010,2,775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',660.00,NULL,NULL,1,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(776,NULL,40745,42010,2,776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',850.00,NULL,NULL,1,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(777,NULL,40745,42010,2,777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',1055.00,NULL,NULL,1,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(778,NULL,40745,42010,2,778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',270.00,NULL,NULL,1,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(779,NULL,40745,42010,2,779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',4000.00,NULL,NULL,1,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(780,NULL,40745,42010,2,780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',730.00,NULL,NULL,1,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(781,NULL,40745,42010,2,781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',510.00,NULL,NULL,1,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(782,NULL,40745,42010,2,782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',1600.00,NULL,NULL,1,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(783,NULL,40745,42010,2,783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',2405.00,NULL,NULL,1,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(784,NULL,40745,42010,2,784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',1500.00,NULL,NULL,1,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(785,NULL,40745,42010,2,785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',750.00,NULL,NULL,1,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(786,NULL,40745,42010,2,786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',800.00,NULL,NULL,1,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(787,NULL,40745,42010,2,787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',2580.00,NULL,NULL,1,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(788,NULL,40745,42010,2,788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',740.00,NULL,NULL,1,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(789,NULL,40745,42010,2,789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',1460.00,NULL,NULL,1,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(790,NULL,40745,42010,2,790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',500.00,NULL,NULL,1,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(791,NULL,40745,42010,2,791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',3070.00,NULL,NULL,1,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(792,NULL,40745,42010,2,792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',710.00,NULL,NULL,1,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(793,NULL,40745,42010,2,793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',865.00,NULL,NULL,1,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(794,NULL,40745,42010,2,794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',1630.00,NULL,NULL,1,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL);
INSERT INTO `balance_libro` VALUES (795,NULL,40745,42010,2,795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',700.00,NULL,NULL,1,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(796,NULL,40745,42010,2,796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',2000.00,NULL,NULL,1,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(797,NULL,40745,42010,2,797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',2330.00,NULL,NULL,1,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(798,NULL,40745,42010,2,798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',1905.00,NULL,NULL,1,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(799,NULL,40745,42010,2,799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',500.00,NULL,NULL,1,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(800,NULL,40745,42010,2,800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',480.00,NULL,NULL,1,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(801,NULL,40745,42010,2,801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',370.00,NULL,NULL,1,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(802,NULL,40745,42010,2,802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',1250.00,NULL,NULL,1,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(803,NULL,40745,42010,2,803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',830.00,NULL,NULL,1,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(804,NULL,40745,42010,2,804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',150.00,NULL,NULL,1,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(805,NULL,40745,42010,2,805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',1375.00,NULL,NULL,1,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(806,NULL,40745,42010,2,806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',330.00,NULL,NULL,1,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(807,NULL,40745,42010,2,807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',170.00,NULL,NULL,1,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(808,NULL,40745,42010,2,808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',830.00,NULL,NULL,1,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(809,NULL,40745,42010,2,809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',475.00,NULL,NULL,1,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(810,NULL,40745,42010,2,810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',320.00,NULL,NULL,1,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(811,NULL,40745,42010,2,811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',500.00,NULL,NULL,1,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(812,NULL,40745,42010,2,812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',1505.00,NULL,NULL,1,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(813,NULL,40745,42010,2,813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',590.00,NULL,NULL,1,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(814,NULL,40745,42010,2,814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',380.00,NULL,NULL,1,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(815,NULL,40745,42010,2,815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',965.00,NULL,NULL,1,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(816,NULL,40745,42010,2,816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',1672.00,NULL,NULL,1,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(817,NULL,40745,42010,2,817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',3456.00,NULL,NULL,1,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(818,NULL,40745,42010,2,818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',460.00,NULL,NULL,1,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(819,NULL,40745,42010,2,819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',550.00,NULL,NULL,1,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL);
INSERT INTO `balance_libro` VALUES (820,NULL,40745,42010,2,820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',280.00,NULL,NULL,1,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(821,NULL,40745,42010,2,821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',300.00,NULL,NULL,1,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(822,NULL,40745,42010,2,822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',565.00,NULL,NULL,1,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(823,NULL,40745,42010,2,823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',680.00,NULL,NULL,1,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(824,NULL,40745,42010,2,824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',600.00,NULL,NULL,1,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(825,NULL,40745,42010,2,825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',3345.00,NULL,NULL,1,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(826,NULL,40745,42010,2,826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',140.00,NULL,NULL,1,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(827,NULL,40745,42010,2,827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',650.00,NULL,NULL,1,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(828,NULL,40745,42010,2,828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',730.00,NULL,NULL,1,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(829,NULL,40745,42010,2,829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1040.00,NULL,NULL,1,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(830,NULL,40745,42010,2,830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',450.00,NULL,NULL,1,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(831,NULL,40745,42010,2,831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1745.00,NULL,NULL,1,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(832,NULL,40745,42010,2,832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',525.00,NULL,NULL,1,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(833,NULL,40745,42010,2,833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',450.00,NULL,NULL,1,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(834,NULL,40745,42010,2,834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',128.00,NULL,NULL,1,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(835,NULL,40745,42010,2,835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',2730.00,NULL,NULL,1,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(836,NULL,40745,42010,2,836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',674.00,NULL,NULL,1,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(837,NULL,40745,42010,2,837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1015.00,NULL,NULL,1,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(838,NULL,40745,42010,2,838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1178.00,NULL,NULL,1,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(839,NULL,40745,42010,2,839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',340.00,NULL,NULL,1,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(840,NULL,40745,42010,2,840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',170.00,NULL,NULL,1,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(841,NULL,40745,42010,2,841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1130.00,NULL,NULL,1,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(842,NULL,40745,42010,2,842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1700.00,NULL,NULL,1,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(843,NULL,40745,42010,2,843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',100.00,NULL,NULL,1,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(844,NULL,40745,42010,2,844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',830.00,NULL,NULL,1,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL);
INSERT INTO `balance_libro` VALUES (845,NULL,40745,42010,2,845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1230.00,NULL,NULL,1,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(846,NULL,40745,42010,2,846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1140.00,NULL,NULL,1,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(847,NULL,40745,42010,2,847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1350.00,NULL,NULL,1,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(848,NULL,40745,42010,2,848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',610.00,NULL,NULL,1,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(849,NULL,40745,42010,2,849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',155.00,NULL,NULL,1,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(850,NULL,40745,42010,2,850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',785.00,NULL,NULL,1,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(851,NULL,40745,42010,2,851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',2020.00,NULL,NULL,1,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(852,NULL,40745,42010,2,852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1285.00,NULL,NULL,1,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(853,NULL,40745,42010,2,853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',750.00,NULL,NULL,1,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(854,NULL,40745,42010,2,854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1975.00,NULL,NULL,1,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(855,NULL,40745,42010,2,855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1640.00,NULL,NULL,1,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(856,NULL,40745,42010,2,856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',7630.00,NULL,NULL,1,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(857,NULL,40745,42010,2,857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',5740.00,NULL,NULL,1,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(858,NULL,40745,42010,2,858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1880.00,NULL,NULL,1,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(859,NULL,40745,42010,2,859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',2635.00,NULL,NULL,1,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(860,NULL,40745,42010,2,860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1870.00,NULL,NULL,1,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(861,NULL,40745,42010,2,861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1295.00,NULL,NULL,1,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(862,NULL,40745,42010,2,862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1805.00,NULL,NULL,1,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(863,NULL,40745,42010,2,863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1030.00,NULL,NULL,1,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(864,NULL,40745,42010,2,864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1570.00,NULL,NULL,1,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(865,NULL,40745,42010,2,865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1290.00,NULL,NULL,1,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(866,NULL,40745,42010,2,866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',2165.00,NULL,NULL,1,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(867,NULL,40745,42010,2,867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',160.00,NULL,NULL,1,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(868,NULL,40745,42010,2,868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1580.00,NULL,NULL,1,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(869,NULL,40745,42010,2,869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1290.00,NULL,NULL,1,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL);
INSERT INTO `balance_libro` VALUES (870,NULL,40745,42010,2,870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1200.00,NULL,NULL,1,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(871,NULL,40745,42010,2,871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',630.00,NULL,NULL,1,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(872,NULL,40745,42010,2,872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1030.00,NULL,NULL,1,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(873,NULL,40745,42010,2,873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',260.00,NULL,NULL,1,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(874,NULL,40745,42010,2,874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',860.00,NULL,NULL,1,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(875,NULL,40745,42010,2,875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',720.00,NULL,NULL,1,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(876,NULL,40745,42010,2,876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1360.00,NULL,NULL,1,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(877,NULL,40745,42010,2,877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1360.00,NULL,NULL,1,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(878,NULL,40745,42010,2,878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',955.55,NULL,NULL,1,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(879,NULL,40745,42010,2,879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',150.00,NULL,NULL,1,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(880,NULL,40745,42010,2,880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',630.00,NULL,NULL,1,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(881,NULL,40745,42010,2,881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',840.00,NULL,NULL,1,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(882,NULL,40745,42010,2,882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1330.00,NULL,NULL,1,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(883,NULL,40745,42010,2,883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',535.00,NULL,NULL,1,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(884,NULL,40745,42010,2,884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',890.00,NULL,NULL,1,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(885,NULL,40745,42010,2,885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',435.00,NULL,NULL,1,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(886,NULL,40745,42010,2,886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',270.00,NULL,NULL,1,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(887,NULL,40745,42010,2,887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',900.00,NULL,NULL,1,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(888,NULL,40745,42010,2,888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',395.00,NULL,NULL,1,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(889,NULL,40745,42010,2,889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',740.00,NULL,NULL,1,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(890,NULL,40745,42010,2,890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1128.00,NULL,NULL,1,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(891,NULL,40745,42010,2,891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1310.00,NULL,NULL,1,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(892,NULL,40745,42010,2,892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',2727.00,NULL,NULL,1,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(893,NULL,40745,42010,2,893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1490.00,NULL,NULL,1,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(894,NULL,40745,42010,2,894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',400.00,NULL,NULL,1,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL);
INSERT INTO `balance_libro` VALUES (895,NULL,40745,42010,2,895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',660.00,NULL,NULL,1,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(896,NULL,40745,42010,2,896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',320.00,NULL,NULL,1,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(897,NULL,40745,42010,2,897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',320.00,NULL,NULL,1,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(898,NULL,40745,42010,2,898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1030.00,NULL,NULL,1,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(899,NULL,40745,42010,2,899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1067.00,NULL,NULL,1,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(900,NULL,40745,42010,2,900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',400.00,NULL,NULL,1,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(901,NULL,40745,42010,2,901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',450.00,NULL,NULL,1,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(902,NULL,40745,42010,2,902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',4150.00,NULL,NULL,1,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(903,NULL,40745,42010,2,903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',166.00,NULL,NULL,1,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(904,NULL,40745,42010,2,904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1460.00,NULL,NULL,1,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(905,NULL,40745,42010,2,905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',300.00,NULL,NULL,1,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(906,NULL,40745,42010,2,906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',880.00,NULL,NULL,1,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(907,NULL,40745,42010,2,907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1600.00,NULL,NULL,1,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(908,NULL,40745,42010,2,908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',470.00,NULL,NULL,1,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(909,NULL,40745,42010,2,909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1290.00,NULL,NULL,1,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(910,NULL,40745,42010,2,910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1000.00,NULL,NULL,1,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(911,NULL,40745,42010,2,911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',785.00,NULL,NULL,1,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(912,NULL,40745,42010,2,912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1055.00,NULL,NULL,1,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(913,NULL,40745,42010,2,913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',140.00,NULL,NULL,1,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(914,NULL,40745,42010,2,914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',360.00,NULL,NULL,1,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(915,NULL,40745,42010,2,915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',2090.00,NULL,NULL,1,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(916,NULL,40745,42010,2,916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',280.00,NULL,NULL,1,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(917,NULL,40745,42010,2,917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',800.00,NULL,NULL,1,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(918,NULL,40745,42010,2,918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1450.00,NULL,NULL,1,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(919,NULL,40745,42010,2,919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1080.00,NULL,NULL,1,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL);
INSERT INTO `balance_libro` VALUES (920,NULL,40745,42010,2,920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',300.00,NULL,NULL,1,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(921,NULL,40745,42010,2,921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',410.00,NULL,NULL,1,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(922,NULL,40745,42010,2,922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',3160.00,NULL,NULL,1,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(923,NULL,40745,42010,2,923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',6179.00,NULL,NULL,1,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(924,NULL,40745,42010,2,924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',2700.00,NULL,NULL,1,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(925,NULL,40745,42010,2,925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',492.00,NULL,NULL,1,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(926,NULL,40745,42010,2,926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',240.00,NULL,NULL,1,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(927,NULL,40745,42010,2,927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1840.00,NULL,NULL,1,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(928,NULL,40745,42010,2,928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',870.00,NULL,NULL,1,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(929,NULL,40745,42010,2,929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1250.00,NULL,NULL,1,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(930,NULL,40745,42010,2,930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',995.00,NULL,NULL,1,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(931,NULL,40745,42010,2,931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1200.00,NULL,NULL,1,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(932,NULL,40745,42010,2,932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',630.00,NULL,NULL,1,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(933,NULL,40745,42010,2,933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',270.00,NULL,NULL,1,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(934,NULL,40745,42010,2,934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',100.00,NULL,NULL,1,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(935,NULL,40745,42010,2,935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',2060.00,NULL,NULL,1,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(936,NULL,40745,42010,2,936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',540.00,NULL,NULL,1,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(937,NULL,40745,42010,2,937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',770.00,NULL,NULL,1,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(938,NULL,40745,42010,2,938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1125.00,NULL,NULL,1,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(939,NULL,40745,42010,2,939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',560.00,NULL,NULL,1,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(940,NULL,40745,42010,2,940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',770.00,NULL,NULL,1,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(941,NULL,40745,42010,2,941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',100.00,NULL,NULL,1,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(942,NULL,40745,42010,2,942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1670.00,NULL,NULL,1,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(943,NULL,40745,42010,2,943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',820.00,NULL,NULL,1,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(944,NULL,40745,42010,2,944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1460.00,NULL,NULL,1,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL);
INSERT INTO `balance_libro` VALUES (945,NULL,40745,42010,2,945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',820.00,NULL,NULL,1,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(946,NULL,40745,42010,2,946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1010.00,NULL,NULL,1,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(947,NULL,40745,42010,2,947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1600.00,NULL,NULL,1,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(948,NULL,40745,42010,2,948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1460.00,NULL,NULL,1,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(949,NULL,40745,42010,2,949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',230.00,NULL,NULL,1,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(950,NULL,40745,42010,2,950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1540.00,NULL,NULL,1,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(951,NULL,40745,42010,2,951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1220.00,NULL,NULL,1,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(952,NULL,40745,42010,2,952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',740.00,NULL,NULL,1,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(953,NULL,40745,42010,2,953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',5245.00,NULL,NULL,1,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(954,NULL,40745,42010,2,954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',790.00,NULL,NULL,1,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(955,NULL,40745,42010,2,955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',2370.00,NULL,NULL,1,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(956,NULL,40745,42010,2,956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',230.00,NULL,NULL,1,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(957,NULL,40745,42010,2,957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',6000.00,NULL,NULL,1,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(958,NULL,40745,42010,2,958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',13120.00,NULL,NULL,1,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(959,NULL,40745,42010,2,959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1700.00,NULL,NULL,1,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(960,NULL,40745,42010,2,960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',3230.00,NULL,NULL,1,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(961,NULL,40745,42010,2,961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',750.00,NULL,NULL,1,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(962,NULL,40745,42010,2,962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1905.00,NULL,NULL,1,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(963,NULL,40745,42010,2,963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1830.00,NULL,NULL,1,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(964,NULL,40745,42010,2,964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',2510.00,NULL,NULL,1,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(965,NULL,40745,42010,2,965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1780.00,NULL,NULL,1,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(966,NULL,40745,42010,2,966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',720.00,NULL,NULL,1,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(967,NULL,40745,42010,2,967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',3600.00,NULL,NULL,1,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(968,NULL,40745,42010,2,968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',400.00,NULL,NULL,1,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(969,NULL,40745,42010,2,969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',640.00,NULL,NULL,1,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL);
INSERT INTO `balance_libro` VALUES (970,NULL,40745,42010,2,970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',965.00,NULL,NULL,1,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(971,NULL,40745,42010,2,971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',450.00,NULL,NULL,1,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(972,NULL,40745,42010,2,972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1740.00,NULL,NULL,1,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(973,NULL,40745,42010,2,973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1450.00,NULL,NULL,1,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(974,NULL,40745,42010,2,974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',850.00,NULL,NULL,1,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(975,NULL,40745,42010,2,975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',2200.00,NULL,NULL,1,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(976,NULL,40745,42010,2,976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',460.00,NULL,NULL,1,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(977,NULL,40745,42010,2,977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',330.00,NULL,NULL,1,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(978,NULL,40745,42010,2,978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1310.00,NULL,NULL,1,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(979,NULL,40745,42010,2,979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1860.00,NULL,NULL,1,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(980,NULL,40745,42010,2,980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',420.00,NULL,NULL,1,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(981,NULL,40745,42010,2,981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',120.00,NULL,NULL,1,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(982,NULL,40745,42010,2,982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',500.00,NULL,NULL,1,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(983,NULL,40745,42010,2,983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1175.00,NULL,NULL,1,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(984,NULL,40745,42010,2,984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',955.00,NULL,NULL,1,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(985,NULL,40745,42010,2,985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',690.00,NULL,NULL,1,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(986,NULL,40745,42010,2,986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',360.00,NULL,NULL,1,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(987,NULL,40745,42010,2,987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',4875.00,NULL,NULL,1,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(988,NULL,40745,42010,2,988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',450.00,NULL,NULL,1,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(989,NULL,40745,42010,2,989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',2652.00,NULL,NULL,1,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(990,NULL,40745,42010,2,990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',720.00,NULL,NULL,1,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(991,NULL,40745,42010,2,991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',570.00,NULL,NULL,1,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(992,NULL,40745,42010,2,992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',6055.00,NULL,NULL,1,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(993,NULL,40745,42010,2,993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',6200.00,NULL,NULL,1,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(994,NULL,40745,42010,2,994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',880.00,NULL,NULL,1,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL);
INSERT INTO `balance_libro` VALUES (995,NULL,40745,42010,2,995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1000.00,NULL,NULL,1,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(996,NULL,40745,42010,2,996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',235.00,NULL,NULL,1,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(997,NULL,40745,42010,2,997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',600.00,NULL,NULL,1,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(998,NULL,40745,42010,2,998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1075.00,NULL,NULL,1,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(999,NULL,40745,42010,2,999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1290.00,NULL,NULL,1,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(1000,NULL,40745,42010,2,1000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',890.00,NULL,NULL,1,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(1001,NULL,40745,42010,2,1001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',410.00,NULL,NULL,1,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(1002,NULL,40745,42010,2,1002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',410.00,NULL,NULL,1,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(1003,NULL,40745,42010,2,1003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',630.00,NULL,NULL,1,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(1004,NULL,40745,42010,2,1004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',2510.00,NULL,NULL,1,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(1005,NULL,40745,42010,2,1005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',560.00,NULL,NULL,1,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(1006,NULL,40745,42010,2,1006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1170.00,NULL,NULL,1,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(1007,NULL,40745,42010,2,1007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',920.00,NULL,NULL,1,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(1008,NULL,40745,42010,2,1008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',445.00,NULL,NULL,1,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(1009,NULL,40745,42010,2,1009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',3040.00,NULL,NULL,1,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(1010,NULL,40745,42010,2,1010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',424.00,NULL,NULL,1,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(1011,NULL,40745,42010,2,1011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',500.00,NULL,NULL,1,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(1012,NULL,40745,42010,2,1012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',8950.00,NULL,NULL,1,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(1013,NULL,40745,42010,2,1013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',600.00,NULL,NULL,1,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(1014,NULL,40745,42010,2,1014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',876.00,NULL,NULL,1,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(1015,NULL,40745,42010,2,1015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',165.00,NULL,NULL,1,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(1016,NULL,40745,42010,2,1016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',620.00,NULL,NULL,1,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(1017,NULL,40745,42010,2,1017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',1850.00,NULL,NULL,1,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(1018,NULL,40745,42010,2,1018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',1370.00,NULL,NULL,1,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL);
INSERT INTO `balance_libro` VALUES (1019,NULL,40745,42010,2,1019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',1350.00,NULL,NULL,1,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(1020,NULL,40745,42010,2,1020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',519.00,NULL,NULL,1,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(1021,NULL,40745,42010,2,1021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',550.00,NULL,NULL,1,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(1022,NULL,40745,42010,2,1022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',600.00,NULL,NULL,1,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(1023,NULL,40745,42010,2,1023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',4165.00,NULL,NULL,1,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(1024,NULL,40745,42010,2,1024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',900.00,NULL,NULL,1,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(1025,NULL,40745,42010,2,1025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',160.00,NULL,NULL,1,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(1026,NULL,40745,42010,2,1026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',100.00,NULL,NULL,1,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(1027,NULL,40745,42010,2,1027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',875.00,NULL,NULL,1,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(1028,NULL,40745,42010,2,1028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',1805.00,NULL,NULL,1,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(1029,NULL,40745,42010,2,1029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',960.00,NULL,NULL,1,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(1030,NULL,40745,42010,2,1030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',280.00,NULL,NULL,1,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(1031,NULL,40745,42010,2,1031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',1695.00,NULL,NULL,1,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(1032,NULL,40745,42010,2,1032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',1270.00,NULL,NULL,1,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(1033,NULL,40745,42010,2,1033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',250.00,NULL,NULL,1,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(1034,NULL,40745,42010,2,1034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',240.00,NULL,NULL,1,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(1035,NULL,40745,42010,2,1035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',2380.00,NULL,NULL,1,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(1036,NULL,40745,42010,2,1036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',470.00,NULL,NULL,1,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(1037,NULL,40745,42010,2,1037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',360.00,NULL,NULL,1,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(1038,NULL,40745,42010,2,1038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',1005.00,NULL,NULL,1,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(1039,NULL,40745,42010,2,1039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',1280.00,NULL,NULL,1,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(1040,NULL,40745,42010,2,1040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',840.00,NULL,NULL,1,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(1041,NULL,40745,42010,2,1041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',500.00,NULL,NULL,1,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(1042,NULL,40745,42010,2,1042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',1260.00,NULL,NULL,1,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL);
INSERT INTO `balance_libro` VALUES (1043,NULL,40745,42010,2,1043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',1360.00,NULL,NULL,1,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(1044,NULL,40745,42010,2,1044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',210.00,NULL,NULL,1,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(1045,NULL,40745,42010,2,1045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',1730.00,NULL,NULL,1,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(1046,NULL,40745,42010,2,1046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',350.00,NULL,NULL,1,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(1047,NULL,40745,42010,2,1047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',1100.00,NULL,NULL,1,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(1048,NULL,40745,42010,2,1048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',529.00,NULL,NULL,1,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(1049,NULL,40745,42010,2,1049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',200.00,NULL,NULL,1,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(1050,7638,40745,42010,3,1050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',38701.03,NULL,NULL,1,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(1051,NULL,40745,42010,2,1051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',5140.00,NULL,NULL,1,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(1052,7638,40745,42010,3,1052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',25328.29,NULL,NULL,1,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(1053,NULL,40745,42010,2,1053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',459.00,NULL,NULL,1,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(1054,7638,40745,42010,3,1054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',165.42,NULL,NULL,1,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(1055,NULL,40745,42010,2,1055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',895.00,NULL,NULL,1,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(1056,7638,40745,42010,3,1056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',20851.74,NULL,NULL,1,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(1057,NULL,40745,42010,2,1057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',622.00,NULL,NULL,1,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(1058,7638,40745,42010,3,1058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',10832.96,NULL,NULL,1,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(1059,NULL,40745,42010,2,1059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',2069.00,NULL,NULL,1,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(1060,7638,40745,42010,3,1060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',160436.13,NULL,NULL,1,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(1061,NULL,40745,42010,2,1061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',1410.00,NULL,NULL,1,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(1062,7638,40745,42010,3,1062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',53628.51,NULL,NULL,1,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(1063,NULL,40745,42010,2,1063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',140.00,NULL,NULL,1,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(1064,7638,40745,42010,3,1064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',86097.68,NULL,NULL,1,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(1065,NULL,40745,42010,2,1065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',790.00,NULL,NULL,1,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(1066,7638,40745,42010,3,1066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',32068.55,NULL,NULL,1,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL);
INSERT INTO `balance_libro` VALUES (1067,NULL,40745,42010,2,1067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',640.00,NULL,NULL,1,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(1068,7638,40745,42010,3,1068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',7058.61,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1069,NULL,40745,42010,2,1069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',970.00,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1070,7638,40745,42010,3,1070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',41573.43,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1071,NULL,40745,42010,2,1071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',530.00,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1072,7638,40745,42010,3,1072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',2073.78,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1073,NULL,40745,42010,2,1073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',1880.00,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1074,7638,40745,42010,3,1074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1345.03,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1075,NULL,40745,42010,2,1075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',2960.00,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1076,7638,40745,42010,3,1076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',608.70,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1077,NULL,40745,42010,2,1077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1000.00,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1078,NULL,40745,42010,2,1079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',690.00,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1079,7638,40745,42010,3,1078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',28990.03,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1080,NULL,40745,42010,2,1080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',210.00,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1081,7638,40745,42010,3,1081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',35000.00,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1082,NULL,40745,42010,2,1082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',600.00,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1083,7638,40745,42010,3,1083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',11226.94,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1084,NULL,40745,42010,2,1084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',2565.00,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1085,7638,40745,42010,3,1085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',16642.66,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1086,NULL,40745,42010,2,1086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',3000.00,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1087,7638,40745,42010,3,1087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',143640.00,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1088,NULL,40745,42010,2,1088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',2500.00,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1089,7638,40745,42010,3,1089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',12487.49,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1090,NULL,40745,42010,2,1090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',600.00,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL);
INSERT INTO `balance_libro` VALUES (1091,7638,40745,42010,3,1091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',33190.28,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1092,NULL,40745,42010,2,1092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1145.00,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1093,7638,40745,42010,3,1093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',14479.19,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1094,NULL,40745,42010,2,1094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1970.00,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1095,7638,40745,42010,3,1095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',99498.43,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1096,NULL,40745,42010,2,1096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',650.00,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1097,7638,40745,42010,3,1097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',15604.28,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1098,7638,40745,42010,3,1098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',4289.33,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1099,NULL,40745,42010,2,1099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',430.00,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1100,7638,40745,42010,3,1100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',2859.54,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1101,NULL,40745,42010,2,1101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',760.00,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1102,7638,40745,42010,3,1102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',13696.50,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1103,NULL,40745,42010,2,1103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',260.00,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1104,7638,40745,42010,3,1104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',10901.48,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1105,NULL,40745,42010,2,1105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',990.00,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1106,7638,40745,42010,3,1106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',529.96,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1107,NULL,40745,42010,2,1108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',187.00,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1108,7638,40745,42010,3,1107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',3161.48,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1109,NULL,40745,42010,2,1109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',400.00,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1110,7638,40745,42010,3,1110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',9024.02,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1111,NULL,40745,42010,2,1111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',602.00,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1112,7638,40745,42010,3,1112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',20273.35,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1113,NULL,40745,42010,2,1113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1596.00,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1114,7638,40745,42010,3,1114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',28453.87,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL);
INSERT INTO `balance_libro` VALUES (1115,NULL,40745,42010,2,1115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',340.00,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1116,7638,40745,42010,3,1116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',661.68,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1117,NULL,40745,42010,2,1117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1000.00,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1118,7638,40745,42010,3,1118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',9209.54,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1119,NULL,40745,42010,2,1119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',570.00,NULL,NULL,1,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(1120,7638,40745,42010,3,1120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',12594.75,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1121,NULL,40745,42010,2,1121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1050.00,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1122,7638,40745,42010,3,1122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',15446.84,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1123,NULL,40745,42010,2,1123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',870.00,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1124,7638,40745,42010,3,1124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',19667.91,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1125,NULL,40745,42010,2,1125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1005.00,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1126,7638,40745,42010,3,1126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',34370.95,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1127,7638,40745,42010,3,1127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',20808.88,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1128,NULL,40745,42010,2,1128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',100.00,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1129,7638,40745,42010,3,1129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',22987.80,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1130,NULL,40745,42010,2,1130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',840.00,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1131,7638,40745,42010,3,1131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',27288.21,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1132,7638,40745,42010,3,1132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',360.25,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1133,NULL,40745,42010,2,1133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1190.00,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1134,7638,40745,42010,3,1134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',2228.46,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1135,NULL,40745,42010,2,1135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',420.00,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1136,7638,40745,42010,3,1136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',13290.74,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1137,NULL,40745,42010,2,1137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',510.00,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1138,7638,40745,42010,3,1138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',289731.00,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL);
INSERT INTO `balance_libro` VALUES (1139,NULL,40745,42010,2,1139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',580.00,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1140,7638,40745,42010,3,1140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',543560.55,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1141,NULL,40745,42010,2,1141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',745.00,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1142,7638,40745,42010,3,1142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',667011.15,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1143,NULL,40745,42010,2,1143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',720.00,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1144,NULL,40745,42010,2,1145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',410.00,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1145,7638,40745,42010,3,1144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',3558.08,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1146,NULL,40745,42010,2,1146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1160.00,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1147,7638,40745,42010,3,1147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',12519.71,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1148,NULL,40745,42010,2,1148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',690.00,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1149,7638,40745,42010,3,1149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',28025.89,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1150,NULL,40745,42010,2,1150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',380.00,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1151,NULL,40745,42010,2,1152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',625.00,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1152,7638,40745,42010,3,1151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',3745.40,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1153,NULL,40745,42010,2,1153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',630.00,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1154,7638,40745,42010,3,1154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',8507.13,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1155,NULL,40745,42010,2,1155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',300.00,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1156,7638,40745,42010,3,1156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',7649.21,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1157,NULL,40745,42010,2,1157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',485.00,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1158,7638,40745,42010,3,1158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1468.34,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1159,7638,40745,42010,3,1159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',7426.25,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1160,NULL,40745,42010,2,1160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',398.00,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1161,7638,40745,42010,3,1161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',27694.48,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1162,NULL,40745,42010,2,1162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',2100.00,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL);
INSERT INTO `balance_libro` VALUES (1163,NULL,40745,42010,2,1163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',400.00,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1164,NULL,40745,42010,2,1164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',520.00,NULL,NULL,1,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(1165,NULL,40745,42010,2,1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',390.00,NULL,NULL,1,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(1166,NULL,40745,42010,2,1166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',400.00,NULL,NULL,1,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(1167,NULL,40745,42010,2,1167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',400.00,NULL,NULL,1,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(1168,NULL,40745,42010,2,1168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1230.00,NULL,NULL,1,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(1169,NULL,40745,42010,2,1169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',630.00,NULL,NULL,1,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(1170,NULL,40745,42010,2,1170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',475.00,NULL,NULL,1,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(1171,NULL,40745,42010,2,1171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',650.00,NULL,NULL,1,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(1172,NULL,40745,42010,2,1172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',200.00,NULL,NULL,1,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(1173,NULL,40745,42010,2,1173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',350.00,NULL,NULL,1,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(1174,NULL,40745,42010,2,1174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',790.00,NULL,NULL,1,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(1175,NULL,40745,42010,2,1175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',585.00,NULL,NULL,1,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(1176,NULL,40745,42010,2,1176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',120.00,NULL,NULL,1,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(1177,NULL,40745,42010,2,1177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1625.00,NULL,NULL,1,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(1178,NULL,40745,42010,2,1178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',2260.00,NULL,NULL,1,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(1179,NULL,40745,42010,2,1179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',500.00,NULL,NULL,1,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(1180,NULL,40745,42010,2,1180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',300.00,NULL,NULL,1,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(1181,NULL,40745,42010,2,1181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',580.00,NULL,NULL,1,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(1182,NULL,40745,42010,2,1182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',400.00,NULL,NULL,1,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(1183,NULL,40745,42010,2,1183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',370.00,NULL,NULL,1,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(1184,NULL,40745,42010,2,1184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1470.00,NULL,NULL,1,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(1185,NULL,40745,42010,2,1185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',310.00,NULL,NULL,1,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(1186,NULL,40745,42010,2,1186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',470.00,NULL,NULL,1,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL);
INSERT INTO `balance_libro` VALUES (1187,NULL,40745,42010,2,1187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1000.00,NULL,NULL,1,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(1188,NULL,40745,42010,2,1188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1370.00,NULL,NULL,1,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(1189,NULL,40745,42010,2,1189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',150.00,NULL,NULL,1,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(1190,NULL,40745,42010,2,1190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',690.00,NULL,NULL,1,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(1191,NULL,40745,42010,2,1191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',260.00,NULL,NULL,1,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(1192,NULL,40745,42010,2,1192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1310.00,NULL,NULL,1,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(1193,NULL,40745,42010,2,1193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1605.00,NULL,NULL,1,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(1194,NULL,40745,42010,2,1194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1500.00,NULL,NULL,1,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(1195,NULL,40745,42010,2,1195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1000.00,NULL,NULL,1,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(1196,NULL,40745,42010,2,1196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',2452.00,NULL,NULL,1,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(1197,NULL,40745,42010,2,1197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',420.00,NULL,NULL,1,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(1198,NULL,40745,42010,2,1198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1300.00,NULL,NULL,1,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(1199,NULL,40745,42010,2,1199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1565.00,NULL,NULL,1,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(1200,NULL,40745,42010,2,1200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1250.00,NULL,NULL,1,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(1201,NULL,40745,42010,2,1201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',90.00,NULL,NULL,1,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(1202,NULL,40745,42010,2,1202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',295.00,NULL,NULL,1,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(1203,NULL,40745,42010,2,1203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',400.00,NULL,NULL,1,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(1204,NULL,40745,42010,2,1204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1605.00,NULL,NULL,1,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(1205,NULL,40745,42010,2,1205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1330.00,NULL,NULL,1,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(1206,NULL,40745,42010,2,1206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',610.00,NULL,NULL,1,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(1207,NULL,40745,42010,2,1207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',2880.00,NULL,NULL,1,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(1208,NULL,40745,42010,2,1208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',565.00,NULL,NULL,1,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(1209,NULL,40745,42010,2,1209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1960.00,NULL,NULL,1,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(1210,NULL,40745,42010,2,1210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',2150.00,NULL,NULL,1,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL);
INSERT INTO `balance_libro` VALUES (1211,NULL,40745,42010,2,1211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1600.00,NULL,NULL,1,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(1212,NULL,40745,42010,2,1212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1525.00,NULL,NULL,1,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(1213,NULL,40745,42010,2,1213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1555.00,NULL,NULL,1,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(1214,NULL,40745,42010,2,1214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',330.00,NULL,NULL,1,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(1215,NULL,40745,42010,2,1215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',2005.00,NULL,NULL,1,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(1216,NULL,40745,42010,2,1216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',2765.00,NULL,NULL,1,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(1217,NULL,40745,42010,2,1217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1160.00,NULL,NULL,1,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(1218,NULL,40745,42010,2,1218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',3265.00,NULL,NULL,1,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(1219,NULL,40745,42010,2,1219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1820.00,NULL,NULL,1,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(1220,NULL,40745,42010,2,1220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',500.00,NULL,NULL,1,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(1221,NULL,40745,42010,2,1221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1655.00,NULL,NULL,1,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(1222,NULL,40745,42010,2,1222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',720.00,NULL,NULL,1,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(1223,NULL,40745,42010,2,1223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',335.00,NULL,NULL,1,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(1224,NULL,40745,42010,2,1224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',750.00,NULL,NULL,1,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(1225,NULL,40745,42010,2,1225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1560.00,NULL,NULL,1,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(1226,NULL,40745,42010,2,1226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',2330.00,NULL,NULL,1,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(1227,NULL,40745,42010,2,1227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1090.00,NULL,NULL,1,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(1228,NULL,40745,42010,2,1228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',750.00,NULL,NULL,1,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(1229,NULL,40745,42010,2,1229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1850.00,NULL,NULL,1,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(1230,NULL,40745,42010,2,1230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',690.00,NULL,NULL,1,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(1231,NULL,40745,42010,2,1231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',6500.00,NULL,NULL,1,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(1232,NULL,40745,42010,2,1232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',450.00,NULL,NULL,1,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(1233,NULL,40745,42010,2,1233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',300.00,NULL,NULL,1,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(1234,NULL,40745,42010,2,1234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',425.00,NULL,NULL,1,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL);
INSERT INTO `balance_libro` VALUES (1235,NULL,40745,42010,2,1235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',780.00,NULL,NULL,1,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(1236,NULL,40745,42010,2,1236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',440.00,NULL,NULL,1,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(1237,NULL,40745,42010,2,1237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1805.00,NULL,NULL,1,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(1238,NULL,40745,42010,2,1238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',250.00,NULL,NULL,1,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(1239,NULL,40745,42010,2,1239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',490.00,NULL,NULL,1,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(1240,NULL,40745,42010,2,1240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',200.00,NULL,NULL,1,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(1241,NULL,40745,42010,2,1241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1820.00,NULL,NULL,1,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(1242,NULL,40745,42010,2,1242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',2755.00,NULL,NULL,1,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(1243,NULL,40745,42010,2,1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1570.00,NULL,NULL,1,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(1244,NULL,40745,42010,2,1244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',970.00,NULL,NULL,1,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(1245,NULL,40745,42010,2,1245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',610.00,NULL,NULL,1,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(1246,NULL,40745,42010,2,1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1840.00,NULL,NULL,1,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(1247,NULL,40745,42010,2,1247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1020.00,NULL,NULL,1,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(1248,NULL,40745,42010,2,1248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',200.00,NULL,NULL,1,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(1249,NULL,40745,42010,2,1249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',500.00,NULL,NULL,1,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(1250,NULL,40745,42010,2,1250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',3000.00,NULL,NULL,1,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(1251,NULL,40745,42010,2,1251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',2310.00,NULL,NULL,1,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(1252,NULL,40745,42010,2,1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1050.00,NULL,NULL,1,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(1253,NULL,40745,42010,2,1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',660.00,NULL,NULL,1,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(1254,NULL,40745,42010,2,1254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',3000.00,NULL,NULL,1,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(1255,NULL,40745,42010,2,1255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',400.00,NULL,NULL,1,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(1256,NULL,40745,42010,2,1256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1770.00,NULL,NULL,1,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(1257,NULL,40745,42010,2,1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',460.00,NULL,NULL,1,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(1258,NULL,40745,42010,2,1258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',2585.00,NULL,NULL,1,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL);
INSERT INTO `balance_libro` VALUES (1259,NULL,40745,42010,2,1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1150.00,NULL,NULL,1,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(1260,NULL,40745,42010,2,1260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',570.00,NULL,NULL,1,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(1261,NULL,40745,42010,2,1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',640.00,NULL,NULL,1,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(1262,NULL,40745,42010,2,1262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1120.00,NULL,NULL,1,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(1263,NULL,40745,42010,2,1263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1000.00,NULL,NULL,1,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(1264,NULL,40745,42010,2,1264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',720.00,NULL,NULL,1,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(1265,NULL,40745,42010,2,1265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',150.00,NULL,NULL,1,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(1266,NULL,40745,42010,2,1266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',2880.00,NULL,NULL,1,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(1267,NULL,40745,42010,2,1267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',170.00,NULL,NULL,1,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(1268,NULL,40745,42010,2,1268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',2120.00,NULL,NULL,1,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(1269,NULL,40745,42010,2,1269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',2585.00,NULL,NULL,1,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(1270,NULL,40745,42010,2,1270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',3000.00,NULL,NULL,1,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(1271,NULL,40745,42010,2,1271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1580.00,NULL,NULL,1,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(1272,NULL,40745,42010,2,1272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1000.00,NULL,NULL,1,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(1273,NULL,40745,42010,2,1273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',560.00,NULL,NULL,1,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(1274,NULL,40745,42010,2,1274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',520.00,NULL,NULL,1,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(1275,NULL,40745,42010,2,1275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',450.00,NULL,NULL,1,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(1276,NULL,40745,42010,2,1276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',680.00,NULL,NULL,1,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(1277,NULL,40745,42010,2,1277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1880.00,NULL,NULL,1,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(1278,NULL,40745,42010,2,1278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',700.00,NULL,NULL,1,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(1279,NULL,40745,42010,2,1279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',680.00,NULL,NULL,1,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(1280,NULL,40745,42010,2,1280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',180.00,NULL,NULL,1,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(1281,NULL,40745,42010,2,1281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',600.00,NULL,NULL,1,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(1282,NULL,40745,42010,2,1282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',180.00,NULL,NULL,1,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL);
INSERT INTO `balance_libro` VALUES (1283,NULL,40745,42010,2,1283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',380.00,NULL,NULL,1,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(1284,NULL,40745,42010,2,1284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1000.00,NULL,NULL,1,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(1285,NULL,40745,42010,2,1285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',600.00,NULL,NULL,1,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(1286,NULL,40745,42010,2,1286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1090.00,NULL,NULL,1,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(1287,NULL,40745,42010,2,1287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',300.00,NULL,NULL,1,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(1288,NULL,40745,42010,2,1288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',300.00,NULL,NULL,1,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(1289,NULL,40745,42010,2,1289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',2040.00,NULL,NULL,1,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(1290,NULL,40745,42010,2,1290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',480.00,NULL,NULL,1,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(1291,NULL,40745,42010,2,1291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',290.00,NULL,NULL,1,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(1292,NULL,40745,42010,2,1292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',690.00,NULL,NULL,1,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(1293,NULL,40745,42010,2,1293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',1350.00,NULL,NULL,1,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(1294,NULL,40745,42010,2,1294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',450.00,NULL,NULL,1,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(1295,NULL,40745,42010,2,1295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',480.00,NULL,NULL,1,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(1296,NULL,40745,42010,2,1296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',1020.00,NULL,NULL,1,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(1297,NULL,40745,42010,2,1297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',1160.00,NULL,NULL,1,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(1298,NULL,40745,42010,2,1298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',260.00,NULL,NULL,1,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(1299,NULL,40745,42010,2,1299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',930.00,NULL,NULL,1,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(1300,NULL,40745,42010,2,1300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',220.00,NULL,NULL,1,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(1301,NULL,40745,42010,2,1301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',1350.00,NULL,NULL,1,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(1302,NULL,40745,42010,2,1302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',650.00,NULL,NULL,1,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(1303,NULL,40745,42010,2,1303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',690.00,NULL,NULL,1,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(1304,NULL,40745,42010,2,1304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',560.00,NULL,NULL,1,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(1305,NULL,40745,42010,2,1305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',1060.00,NULL,NULL,1,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(1306,NULL,40745,42010,2,1306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',620.00,NULL,NULL,1,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL);
INSERT INTO `balance_libro` VALUES (1307,NULL,40745,42010,2,1307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',495.00,NULL,NULL,1,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(1308,NULL,40745,42010,2,1308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',3550.00,NULL,NULL,1,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(1309,NULL,40745,42010,2,1309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',1365.00,NULL,NULL,1,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(1310,NULL,40745,42010,2,1310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',400.00,NULL,NULL,1,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(1311,NULL,40745,42010,2,1311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',350.00,NULL,NULL,1,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(1312,NULL,40745,42010,2,1312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',400.00,NULL,NULL,1,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(1313,NULL,40745,42010,2,1313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',750.00,NULL,NULL,1,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(1314,NULL,40745,42010,2,1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',1240.00,NULL,NULL,1,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(1315,NULL,40745,42010,2,1315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',650.00,NULL,NULL,1,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(1316,NULL,40745,42010,2,1316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1000.00,NULL,NULL,1,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(1317,NULL,40745,42010,2,1317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1680.00,NULL,NULL,1,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(1318,NULL,40745,42010,2,1318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',4000.00,NULL,NULL,1,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(1319,NULL,40745,42010,2,1319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',340.00,NULL,NULL,1,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(1320,NULL,40745,42010,2,1320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',900.00,NULL,NULL,1,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(1321,NULL,40745,42010,2,1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',610.00,NULL,NULL,1,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(1322,NULL,40745,42010,2,1322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',705.00,NULL,NULL,1,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(1323,NULL,40745,42010,2,1323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',290.00,NULL,NULL,1,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(1324,NULL,40745,42010,2,1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1020.00,NULL,NULL,1,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(1325,NULL,40745,42010,2,1325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',480.00,NULL,NULL,1,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(1326,NULL,40745,42010,2,1326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',500.00,NULL,NULL,1,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(1327,NULL,40745,42010,2,1327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',655.00,NULL,NULL,1,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(1328,NULL,40745,42010,2,1328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',420.00,NULL,NULL,1,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(1329,NULL,40745,42010,2,1329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',460.00,NULL,NULL,1,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(1330,NULL,40745,42010,2,1330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',485.00,NULL,NULL,1,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL);
INSERT INTO `balance_libro` VALUES (1331,NULL,40745,42010,2,1331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',2000.00,NULL,NULL,1,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(1332,NULL,40745,42010,2,1332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1365.00,NULL,NULL,1,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(1333,NULL,40745,42010,2,1333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',2365.00,NULL,NULL,1,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(1334,NULL,40745,42010,2,1334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1790.00,NULL,NULL,1,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(1335,NULL,40745,42010,2,1335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1170.00,NULL,NULL,1,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(1336,NULL,40745,42010,2,1336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',3910.00,NULL,NULL,1,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(1337,NULL,40745,42010,2,1337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',250.00,NULL,NULL,1,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(1338,NULL,40745,42010,2,1338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',950.00,NULL,NULL,1,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(1339,NULL,40745,42010,2,1339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',450.00,NULL,NULL,1,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(1340,NULL,40745,42010,2,1340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1790.00,NULL,NULL,1,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(1341,NULL,40745,42010,2,1341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',570.00,NULL,NULL,1,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(1342,NULL,40745,42010,2,1342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',180.00,NULL,NULL,1,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(1343,NULL,40745,42010,2,1343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',300.00,NULL,NULL,1,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(1344,NULL,40745,42010,2,1344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1550.00,NULL,NULL,1,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(1345,NULL,40745,42010,2,1345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',680.00,NULL,NULL,1,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(1346,NULL,40745,42010,2,1346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',700.00,NULL,NULL,1,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(1347,NULL,40745,42010,2,1347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',770.00,NULL,NULL,1,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(1348,NULL,40745,42010,2,1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',410.00,NULL,NULL,1,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(1349,NULL,40745,42010,2,1349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',450.00,NULL,NULL,1,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(1350,NULL,40745,42010,2,1350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',640.00,NULL,NULL,1,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(1351,NULL,40745,42010,2,1351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1000.00,NULL,NULL,1,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(1352,NULL,40745,42010,2,1352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',300.00,NULL,NULL,1,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(1353,NULL,40745,42010,2,1353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1100.00,NULL,NULL,1,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(1354,NULL,40745,42010,2,1354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',310.00,NULL,NULL,1,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL);
INSERT INTO `balance_libro` VALUES (1355,NULL,40745,42010,2,1355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',430.00,NULL,NULL,1,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(1356,NULL,40745,42010,2,1356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',2040.00,NULL,NULL,1,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(1357,NULL,40745,42010,2,1357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',890.00,NULL,NULL,1,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(1358,NULL,40745,42010,2,1358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',900.00,NULL,NULL,1,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(1359,NULL,40745,42010,2,1359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',320.00,NULL,NULL,1,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(1360,NULL,40745,42010,2,1360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',295.00,NULL,NULL,1,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(1361,NULL,40745,42010,2,1361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',640.00,NULL,NULL,1,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(1362,NULL,40745,42010,2,1362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',640.00,NULL,NULL,1,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(1363,NULL,40745,42010,2,1363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1000.00,NULL,NULL,1,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(1364,NULL,40745,42010,2,1364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1160.00,NULL,NULL,1,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(1365,NULL,40745,42010,2,1365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1460.00,NULL,NULL,1,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(1366,NULL,40745,42010,2,1366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',2960.00,NULL,NULL,1,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(1367,NULL,40745,42010,2,1367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',100.00,NULL,NULL,1,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(1368,NULL,40745,42010,2,1368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',450.00,NULL,NULL,1,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(1369,NULL,40745,42010,2,1369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',270.00,NULL,NULL,1,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(1370,NULL,40745,42010,2,1370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',295.00,NULL,NULL,1,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(1371,NULL,40745,42010,2,1371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',330.00,NULL,NULL,1,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(1372,NULL,40745,42010,2,1372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',580.00,NULL,NULL,1,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(1373,NULL,40745,42010,2,1373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',400.00,NULL,NULL,1,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(1374,NULL,40745,42010,2,1374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1000.00,NULL,NULL,1,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(1375,NULL,40745,42010,2,1375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',190.00,NULL,NULL,1,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(1376,NULL,40745,42010,2,1376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1980.00,NULL,NULL,1,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(1377,NULL,40745,42010,2,1377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',2230.00,NULL,NULL,1,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(1378,NULL,40745,42010,2,1378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',981.00,NULL,NULL,1,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL);
INSERT INTO `balance_libro` VALUES (1379,NULL,40745,42010,2,1379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1120.00,NULL,NULL,1,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(1380,NULL,40745,42010,2,1380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',1000.00,NULL,NULL,1,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(1381,NULL,40745,42010,2,1381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',210.00,NULL,NULL,1,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(1382,NULL,40745,42010,2,1382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',630.00,NULL,NULL,1,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(1383,NULL,40745,42010,2,1383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',530.00,NULL,NULL,1,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(1384,NULL,40745,42010,2,1384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',430.00,NULL,NULL,1,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(1385,NULL,40745,42010,2,1385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',100.00,NULL,NULL,1,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(1386,NULL,40745,42010,2,1386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',1340.00,NULL,NULL,1,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(1387,NULL,40745,42010,2,1387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',1110.00,NULL,NULL,1,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(1388,NULL,40745,42010,2,1388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',910.00,NULL,NULL,1,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(1389,NULL,40745,42010,2,1389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',990.00,NULL,NULL,1,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(1390,NULL,40745,42010,2,1390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',820.00,NULL,NULL,1,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(1391,NULL,40745,42010,2,1391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',2660.00,NULL,NULL,1,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(1392,NULL,40745,42010,2,1392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',480.00,NULL,NULL,1,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(1393,NULL,40745,42010,2,1393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',1370.00,NULL,NULL,1,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(1394,NULL,40745,42010,2,1394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',2500.00,NULL,NULL,1,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(1395,NULL,40745,42010,2,1395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',750.00,NULL,NULL,1,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(1396,NULL,40745,42010,2,1396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',1090.00,NULL,NULL,1,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(1397,NULL,40745,42010,2,1397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',2380.00,NULL,NULL,1,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(1398,NULL,40745,42010,2,1398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',340.00,NULL,NULL,1,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(1399,NULL,40745,42010,2,1399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',1060.00,NULL,NULL,1,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(1400,NULL,40745,42010,2,1400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',585.00,NULL,NULL,1,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(1401,NULL,40745,42010,2,1401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',230.00,NULL,NULL,1,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(1402,NULL,40745,42010,2,1402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',870.00,NULL,NULL,1,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL);
INSERT INTO `balance_libro` VALUES (1403,NULL,40745,42010,2,1403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',300.00,NULL,NULL,1,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(1404,NULL,40745,42010,2,1404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',810.00,NULL,NULL,1,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(1405,NULL,40745,42010,2,1405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',890.00,NULL,NULL,1,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(1406,NULL,40745,42010,2,1406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',627.00,NULL,NULL,1,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(1407,NULL,40745,42010,2,1407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',1860.00,NULL,NULL,1,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(1408,NULL,40745,42010,2,1408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',3965.00,NULL,NULL,1,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(1409,NULL,40745,42010,2,1409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',820.00,NULL,NULL,1,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(1410,NULL,40745,42010,2,1410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',1980.00,NULL,NULL,1,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(1411,NULL,40745,42010,2,1411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',2985.00,NULL,NULL,1,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(1412,NULL,40745,42010,2,1412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',1065.00,NULL,NULL,1,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(1413,NULL,40745,42010,2,1413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',1000.00,NULL,NULL,1,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(1414,NULL,40745,42010,2,1414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',1365.00,NULL,NULL,1,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(1415,NULL,40745,42010,2,1415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',265.00,NULL,NULL,1,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(1416,NULL,40745,42010,2,1416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',1475.00,NULL,NULL,1,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(1417,NULL,40745,42010,2,1417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',620.00,NULL,NULL,1,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(1418,NULL,40745,42010,2,1418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',855.00,NULL,NULL,1,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(1419,NULL,40745,42010,2,1419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',300.00,NULL,NULL,1,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(1420,NULL,40745,42010,2,1420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',400.00,NULL,NULL,1,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(1421,NULL,40745,42010,2,1421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',790.00,NULL,NULL,1,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(1422,NULL,40745,42010,2,1422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',3600.00,NULL,NULL,1,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(1423,NULL,40745,42010,2,1423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',1040.00,NULL,NULL,1,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(1424,NULL,40745,42010,2,1424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',320.00,NULL,NULL,1,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(1425,NULL,40745,42010,2,1425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',500.00,NULL,NULL,1,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(1426,NULL,40745,42010,2,1426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',720.00,NULL,NULL,1,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL);
INSERT INTO `balance_libro` VALUES (1427,NULL,40745,42010,2,1427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',12.20,NULL,NULL,1,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(1428,NULL,40745,42010,2,1428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',955.00,NULL,NULL,1,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(1429,NULL,40745,42010,2,1429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',310.00,NULL,NULL,1,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(1430,NULL,40745,42010,2,1430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',800.00,NULL,NULL,1,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(1431,NULL,40745,42010,2,1431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',120.00,NULL,NULL,1,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(1432,NULL,40745,42010,2,1432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',100.00,NULL,NULL,1,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(1433,NULL,40745,42010,2,1433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',370.00,NULL,NULL,1,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(1434,NULL,40745,42010,2,1434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',805.00,NULL,NULL,1,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(1435,NULL,40745,42010,2,1435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',260.00,NULL,NULL,1,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(1436,NULL,40745,42010,2,1436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',665.00,NULL,NULL,1,'2022-11-24 14:20:59','2022-11-24 14:20:59',NULL),(1437,NULL,40745,42010,2,1437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',870.00,NULL,NULL,1,'2022-11-24 14:20:59','2022-11-24 14:20:59',NULL),(1438,NULL,40745,42010,2,1438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',160.00,NULL,NULL,1,'2022-11-24 14:20:59','2022-11-24 14:20:59',NULL),(1439,NULL,40745,42010,2,1439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',1220.00,NULL,NULL,1,'2022-11-24 14:20:59','2022-11-24 14:20:59',NULL),(1440,NULL,40745,42010,2,1440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',2550.00,NULL,NULL,1,'2022-11-24 14:20:59','2022-11-24 14:20:59',NULL),(1441,NULL,40745,42010,2,1441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',800.00,NULL,NULL,1,'2022-11-24 14:20:59','2022-11-24 14:20:59',NULL),(1442,NULL,40745,42010,2,1442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',1860.00,NULL,NULL,1,'2022-11-24 14:20:59','2022-11-24 14:20:59',NULL),(1443,NULL,40745,42010,2,1443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',930.00,NULL,NULL,1,'2022-11-24 14:20:59','2022-11-24 14:20:59',NULL),(1444,NULL,40745,42010,2,1444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',340.00,NULL,NULL,1,'2022-11-24 14:20:59','2022-11-24 14:20:59',NULL),(1445,NULL,40745,42010,2,1445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',600.00,NULL,NULL,1,'2022-11-24 14:20:59','2022-11-24 14:20:59',NULL),(1446,NULL,40745,42010,2,1446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',590.00,NULL,NULL,1,'2022-11-24 14:20:59','2022-11-24 14:20:59',NULL),(1447,NULL,40745,42010,2,1447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',860.00,NULL,NULL,1,'2022-11-24 14:20:59','2022-11-24 14:20:59',NULL),(1448,NULL,40745,42010,2,1448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',1970.00,NULL,NULL,1,'2022-11-24 14:20:59','2022-11-24 14:20:59',NULL),(1449,NULL,40745,42010,2,1449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',515.00,NULL,NULL,1,'2022-11-24 14:20:59','2022-11-24 14:20:59',NULL),(1450,NULL,40745,42010,2,1450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',560.00,NULL,NULL,1,'2022-11-24 14:20:59','2022-11-24 14:20:59',NULL);
INSERT INTO `balance_libro` VALUES (1451,NULL,40745,42010,2,1451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',960.00,NULL,NULL,1,'2022-11-24 14:20:59','2022-11-24 14:20:59',NULL),(1452,NULL,40745,42010,2,1452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',990.00,NULL,NULL,1,'2022-11-24 14:20:59','2022-11-24 14:20:59',NULL),(1453,NULL,40745,42010,2,1453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',430.00,NULL,NULL,1,'2022-11-24 14:20:59','2022-11-24 14:20:59',NULL),(1454,NULL,40745,42010,2,1454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',600.00,NULL,NULL,1,'2022-11-24 14:20:59','2022-11-24 14:20:59',NULL),(1455,NULL,40745,42010,2,1455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',180.00,NULL,NULL,1,'2022-11-24 14:20:59','2022-11-24 14:20:59',NULL),(1456,NULL,40745,42010,2,1456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',470.00,NULL,NULL,1,'2022-11-24 14:20:59','2022-11-24 14:20:59',NULL),(1457,NULL,40745,42010,2,1457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',3115.00,NULL,NULL,1,'2022-11-24 14:20:59','2022-11-24 14:20:59',NULL),(1458,NULL,40745,42010,2,1458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',850.00,NULL,NULL,1,'2022-11-24 14:20:59','2022-11-24 14:20:59',NULL),(1459,NULL,40745,42010,2,1459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',2970.00,NULL,NULL,1,'2022-11-24 14:20:59','2022-11-24 14:20:59',NULL),(1460,NULL,40745,42010,2,1460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',535.00,NULL,NULL,1,'2022-11-24 14:20:59','2022-11-24 14:20:59',NULL),(1461,NULL,40745,42010,2,1461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',770.00,NULL,NULL,1,'2022-11-24 14:20:59','2022-11-24 14:20:59',NULL),(1462,NULL,40745,42010,2,1462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',1000.00,NULL,NULL,1,'2022-11-24 14:20:59','2022-11-24 14:20:59',NULL),(1463,NULL,40745,42010,2,1463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',720.00,NULL,NULL,1,'2022-11-24 14:20:59','2022-11-24 14:20:59',NULL),(1464,NULL,40745,42010,2,1464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',1870.00,NULL,NULL,1,'2022-11-24 14:21:00','2022-11-24 14:21:00',NULL),(1465,NULL,40745,42010,2,1465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',240.00,NULL,NULL,1,'2022-11-24 14:21:00','2022-11-24 14:21:00',NULL),(1466,NULL,40745,42010,2,1466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',1860.00,NULL,NULL,1,'2022-11-24 14:21:00','2022-11-24 14:21:00',NULL),(1467,NULL,40745,42010,2,1467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',380.00,NULL,NULL,1,'2022-11-24 14:21:00','2022-11-24 14:21:00',NULL),(1468,NULL,40745,42010,2,1468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',600.00,NULL,NULL,1,'2022-11-24 14:21:00','2022-11-24 14:21:00',NULL),(1469,NULL,40745,42010,2,1469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',1610.00,NULL,NULL,1,'2022-11-24 14:21:00','2022-11-24 14:21:00',NULL),(1470,NULL,40745,42010,2,1470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',300.00,NULL,NULL,1,'2022-11-24 14:21:00','2022-11-24 14:21:00',NULL),(1471,NULL,40745,42010,2,1471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',175.00,NULL,NULL,1,'2022-11-24 14:21:00','2022-11-24 14:21:00',NULL),(1472,NULL,40745,42010,2,1472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',870.00,NULL,NULL,1,'2022-11-24 14:21:00','2022-11-24 14:21:00',NULL),(1473,NULL,40745,42010,2,1473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',570.00,NULL,NULL,1,'2022-11-24 14:21:00','2022-11-24 14:21:00',NULL),(1474,NULL,40745,42010,2,1474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',220.00,NULL,NULL,1,'2022-11-24 14:21:00','2022-11-24 14:21:00',NULL);
INSERT INTO `balance_libro` VALUES (1475,NULL,40745,42010,2,1475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',2000.00,NULL,NULL,1,'2022-11-24 14:21:00','2022-11-24 14:21:00',NULL),(1476,NULL,40745,42010,2,1476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',500.00,NULL,NULL,1,'2022-11-24 14:21:00','2022-11-24 14:21:00',NULL),(1477,NULL,40745,42010,2,1477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',660.00,NULL,NULL,1,'2022-11-24 14:21:00','2022-11-24 14:21:00',NULL),(1478,NULL,40745,42010,2,1478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',780.00,NULL,NULL,1,'2022-11-24 14:21:00','2022-11-24 14:21:00',NULL),(1479,NULL,40745,42010,2,1479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',410.00,NULL,NULL,1,'2022-11-24 14:21:00','2022-11-24 14:21:00',NULL),(1480,NULL,40745,42010,2,1480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',4045.00,NULL,NULL,1,'2022-11-24 14:21:00','2022-11-24 14:21:00',NULL),(1481,NULL,40745,42010,2,1481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',455.00,NULL,NULL,1,'2022-11-24 14:21:00','2022-11-24 14:21:00',NULL),(1482,NULL,40745,42010,2,1482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',1160.00,NULL,NULL,1,'2022-11-24 14:21:00','2022-11-24 14:21:00',NULL),(1483,NULL,40745,42010,2,1483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',700.00,NULL,NULL,1,'2022-11-24 14:21:00','2022-11-24 14:21:00',NULL),(1484,NULL,40745,42010,2,1484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',1430.00,NULL,NULL,1,'2022-11-24 14:21:00','2022-11-24 14:21:00',NULL),(1485,NULL,40745,42010,2,1485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',900.00,NULL,NULL,1,'2022-11-24 14:21:00','2022-11-24 14:21:00',NULL),(1486,NULL,40745,42010,2,1486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',450.00,NULL,NULL,1,'2022-11-24 14:21:00','2022-11-24 14:21:00',NULL),(1487,NULL,40745,42010,2,1487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',120.00,NULL,NULL,1,'2022-11-24 14:21:00','2022-11-24 14:21:00',NULL),(1488,NULL,40745,42010,2,1488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',1950.00,NULL,NULL,1,'2022-11-24 14:21:00','2022-11-24 14:21:00',NULL),(1489,NULL,40745,42010,2,1489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',160.00,NULL,NULL,1,'2022-11-24 14:21:00','2022-11-24 14:21:00',NULL),(1490,NULL,40745,42010,2,1490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',2010.00,NULL,NULL,1,'2022-11-24 14:21:01','2022-11-24 14:21:01',NULL),(1491,NULL,40745,42010,2,1491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',465.00,NULL,NULL,1,'2022-11-24 14:21:01','2022-11-24 14:21:01',NULL),(1492,NULL,40745,42010,2,1492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',3320.00,NULL,NULL,1,'2022-11-24 14:21:01','2022-11-24 14:21:01',NULL),(1493,NULL,40745,42010,2,1493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',510.00,NULL,NULL,1,'2022-11-24 14:21:01','2022-11-24 14:21:01',NULL),(1494,NULL,40745,42010,2,1494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',1000.00,NULL,NULL,1,'2022-11-24 14:21:01','2022-11-24 14:21:01',NULL),(1495,NULL,40745,42010,2,1495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',200.00,NULL,NULL,1,'2022-11-24 14:21:01','2022-11-24 14:21:01',NULL),(1496,NULL,40745,42010,2,1496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',250.00,NULL,NULL,1,'2022-11-24 14:21:01','2022-11-24 14:21:01',NULL),(1497,NULL,40745,42010,2,1497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',575.00,NULL,NULL,1,'2022-11-24 14:21:01','2022-11-24 14:21:01',NULL),(1498,NULL,40745,42010,2,1498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',610.00,NULL,NULL,1,'2022-11-24 14:21:01','2022-11-24 14:21:01',NULL);
INSERT INTO `balance_libro` VALUES (1499,NULL,40745,42010,2,1499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',625.00,NULL,NULL,1,'2022-11-24 14:21:01','2022-11-24 14:21:01',NULL),(1500,NULL,40745,42010,2,1500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',1815.00,NULL,NULL,1,'2022-11-24 14:21:01','2022-11-24 14:21:01',NULL),(1501,NULL,40745,42010,2,1501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',1835.00,NULL,NULL,1,'2022-11-24 14:21:01','2022-11-24 14:21:01',NULL),(1502,NULL,40745,42010,2,1502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',896.00,NULL,NULL,1,'2022-11-24 14:21:01','2022-11-24 14:21:01',NULL),(1503,NULL,40745,42010,2,1503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',715.00,NULL,NULL,1,'2022-11-24 14:21:01','2022-11-24 14:21:01',NULL),(1504,NULL,40745,42010,2,1504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',1190.00,NULL,NULL,1,'2022-11-24 14:21:01','2022-11-24 14:21:01',NULL),(1505,NULL,40745,42010,2,1505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',1650.00,NULL,NULL,1,'2022-11-24 14:21:01','2022-11-24 14:21:01',NULL),(1506,NULL,40745,42010,2,1506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',610.00,NULL,NULL,1,'2022-11-24 14:21:01','2022-11-24 14:21:01',NULL),(1507,NULL,40745,42010,2,1507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',720.00,NULL,NULL,1,'2022-11-24 14:21:01','2022-11-24 14:21:01',NULL),(1508,NULL,40745,42010,2,1508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',550.00,NULL,NULL,1,'2022-11-24 14:21:01','2022-11-24 14:21:01',NULL),(1509,NULL,40745,42010,2,1509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',375.00,NULL,NULL,1,'2022-11-24 14:21:01','2022-11-24 14:21:01',NULL),(1510,NULL,40745,42010,2,1510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',610.00,NULL,NULL,1,'2022-11-24 14:21:01','2022-11-24 14:21:01',NULL),(1511,NULL,40745,42010,2,1511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',5885.00,NULL,NULL,1,'2022-11-24 14:21:01','2022-11-24 14:21:01',NULL),(1512,NULL,40745,42010,2,1512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',310.00,NULL,NULL,1,'2022-11-24 14:21:01','2022-11-24 14:21:01',NULL),(1513,NULL,40745,42010,2,1513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',500.00,NULL,NULL,1,'2022-11-24 14:21:01','2022-11-24 14:21:01',NULL),(1514,NULL,40745,42010,2,1514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',610.00,NULL,NULL,1,'2022-11-24 14:21:01','2022-11-24 14:21:01',NULL),(1515,NULL,40745,42010,2,1515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',400.00,NULL,NULL,1,'2022-11-24 14:21:01','2022-11-24 14:21:01',NULL),(1516,NULL,40745,42010,2,1516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',500.00,NULL,NULL,1,'2022-11-24 14:21:01','2022-11-24 14:21:01',NULL),(1517,NULL,40745,42010,2,1517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',500.00,NULL,NULL,1,'2022-11-24 14:21:02','2022-11-24 14:21:02',NULL),(1518,NULL,40745,42010,2,1518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',920.00,NULL,NULL,1,'2022-11-24 14:21:02','2022-11-24 14:21:02',NULL),(1519,NULL,40745,42010,2,1519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',300.00,NULL,NULL,1,'2022-11-24 14:21:02','2022-11-24 14:21:02',NULL),(1520,NULL,40745,42010,2,1520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',1342.00,NULL,NULL,1,'2022-11-24 14:21:02','2022-11-24 14:21:02',NULL),(1521,NULL,40745,42010,2,1521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',1000.00,NULL,NULL,1,'2022-11-24 14:21:02','2022-11-24 14:21:02',NULL),(1522,NULL,40745,42010,2,1522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',950.00,NULL,NULL,1,'2022-11-24 14:21:02','2022-11-24 14:21:02',NULL);
INSERT INTO `balance_libro` VALUES (1523,NULL,40745,42010,2,1523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',590.00,NULL,NULL,1,'2022-11-24 14:21:02','2022-11-24 14:21:02',NULL),(1524,NULL,40745,42010,2,1524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',327.00,NULL,NULL,1,'2022-11-24 14:21:02','2022-11-24 14:21:02',NULL),(1525,NULL,40745,42010,2,1525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',650.00,NULL,NULL,1,'2022-11-24 14:21:02','2022-11-24 14:21:02',NULL),(1526,NULL,40745,42010,2,1526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',160.00,NULL,NULL,1,'2022-11-24 14:21:02','2022-11-24 14:21:02',NULL),(1527,NULL,40745,42010,2,1527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',635.00,NULL,NULL,1,'2022-11-24 14:21:02','2022-11-24 14:21:02',NULL),(1528,NULL,40745,42010,2,1528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',1085.00,NULL,NULL,1,'2022-11-24 14:21:02','2022-11-24 14:21:02',NULL),(1529,NULL,40745,42010,2,1529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',1610.00,NULL,NULL,1,'2022-11-24 14:21:02','2022-11-24 14:21:02',NULL),(1530,NULL,40745,42010,2,1530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',1420.00,NULL,NULL,1,'2022-11-24 14:21:02','2022-11-24 14:21:02',NULL),(1531,NULL,40745,42010,2,1531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',360.00,NULL,NULL,1,'2022-11-24 14:21:02','2022-11-24 14:21:02',NULL),(1532,NULL,40745,42010,2,1532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',6480.00,NULL,NULL,1,'2022-11-24 14:21:02','2022-11-24 14:21:02',NULL),(1533,NULL,40745,42010,2,1533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',730.00,NULL,NULL,1,'2022-11-24 14:21:02','2022-11-24 14:21:02',NULL),(1534,NULL,40745,42010,2,1534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',1170.00,NULL,NULL,1,'2022-11-24 14:21:02','2022-11-24 14:21:02',NULL),(1535,NULL,40745,42010,2,1535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',1000.00,NULL,NULL,1,'2022-11-24 14:21:02','2022-11-24 14:21:02',NULL),(1536,NULL,40745,42010,2,1536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',640.00,NULL,NULL,1,'2022-11-24 14:21:02','2022-11-24 14:21:02',NULL),(1537,NULL,40745,42010,2,1537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',3335.00,NULL,NULL,1,'2022-11-24 14:21:02','2022-11-24 14:21:02',NULL),(1538,NULL,40745,42010,2,1538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',730.00,NULL,NULL,1,'2022-11-24 14:21:02','2022-11-24 14:21:02',NULL),(1539,NULL,40745,42010,2,1539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',300.00,NULL,NULL,1,'2022-11-24 14:21:02','2022-11-24 14:21:02',NULL),(1540,NULL,40745,42010,2,1540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',390.00,NULL,NULL,1,'2022-11-24 14:21:02','2022-11-24 14:21:02',NULL),(1541,NULL,40745,42010,2,1541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',1000.00,NULL,NULL,1,'2022-11-24 14:21:02','2022-11-24 14:21:02',NULL),(1542,NULL,40745,42010,2,1542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',660.00,NULL,NULL,1,'2022-11-24 14:21:02','2022-11-24 14:21:02',NULL),(1543,NULL,40745,42010,2,1543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',1030.00,NULL,NULL,1,'2022-11-24 14:21:03','2022-11-24 14:21:03',NULL),(1544,NULL,40745,42010,2,1544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',2570.00,NULL,NULL,1,'2022-11-24 14:21:03','2022-11-24 14:21:03',NULL),(1545,NULL,40745,42010,2,1545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',1840.00,NULL,NULL,1,'2022-11-24 14:21:03','2022-11-24 14:21:03',NULL),(1546,NULL,40745,42010,2,1546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',100.00,NULL,NULL,1,'2022-11-24 14:21:03','2022-11-24 14:21:03',NULL);
INSERT INTO `balance_libro` VALUES (1547,NULL,40745,42010,2,1547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',2214.00,NULL,NULL,1,'2022-11-24 14:21:03','2022-11-24 14:21:03',NULL),(1548,NULL,40745,42010,2,1548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',390.00,NULL,NULL,1,'2022-11-24 14:21:03','2022-11-24 14:21:03',NULL),(1549,NULL,40745,42010,2,1549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',1485.00,NULL,NULL,1,'2022-11-24 14:21:03','2022-11-24 14:21:03',NULL),(1550,NULL,40745,42010,2,1550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',4170.00,NULL,NULL,1,'2022-11-24 14:21:03','2022-11-24 14:21:03',NULL),(1551,NULL,40745,42010,2,1551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',130.00,NULL,NULL,1,'2022-11-24 14:21:03','2022-11-24 14:21:03',NULL),(1552,NULL,40745,42010,2,1552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',5000.00,NULL,NULL,1,'2022-11-24 14:21:03','2022-11-24 14:21:03',NULL),(1553,NULL,40745,42010,2,1553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',770.00,NULL,NULL,1,'2022-11-24 14:21:03','2022-11-24 14:21:03',NULL),(1554,NULL,40745,42010,2,1554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',1960.00,NULL,NULL,1,'2022-11-24 14:21:03','2022-11-24 14:21:03',NULL),(1555,NULL,40745,42010,2,1555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',2000.00,NULL,NULL,1,'2022-11-24 14:21:03','2022-11-24 14:21:03',NULL),(1556,NULL,40745,42010,2,1556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',580.00,NULL,NULL,1,'2022-11-24 14:21:03','2022-11-24 14:21:03',NULL),(1557,NULL,40745,42010,2,1557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',580.00,NULL,NULL,1,'2022-11-24 14:21:03','2022-11-24 14:21:03',NULL),(1558,NULL,40745,42010,2,1558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',330.00,NULL,NULL,1,'2022-11-24 14:21:03','2022-11-24 14:21:03',NULL),(1559,NULL,40745,42010,2,1559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',730.00,NULL,NULL,1,'2022-11-24 14:21:03','2022-11-24 14:21:03',NULL),(1560,NULL,40745,42010,2,1560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',560.00,NULL,NULL,1,'2022-11-24 14:21:03','2022-11-24 14:21:03',NULL),(1561,NULL,40745,42010,2,1561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',1715.00,NULL,NULL,1,'2022-11-24 14:21:03','2022-11-24 14:21:03',NULL),(1562,NULL,40745,42010,2,1562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',860.00,NULL,NULL,1,'2022-11-24 14:21:03','2022-11-24 14:21:03',NULL),(1563,NULL,40745,42010,2,1563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',960.00,NULL,NULL,1,'2022-11-24 14:21:03','2022-11-24 14:21:03',NULL),(1564,NULL,40745,42010,2,1564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',1735.00,NULL,NULL,1,'2022-11-24 14:21:03','2022-11-24 14:21:03',NULL),(1565,NULL,40745,42010,2,1565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',2860.00,NULL,NULL,1,'2022-11-24 14:21:03','2022-11-24 14:21:03',NULL),(1566,NULL,40745,42010,2,1566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',280.00,NULL,NULL,1,'2022-11-24 14:21:03','2022-11-24 14:21:03',NULL),(1567,NULL,40745,42010,2,1567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',295.00,NULL,NULL,1,'2022-11-24 14:21:03','2022-11-24 14:21:03',NULL),(1568,NULL,40745,42010,2,1568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',560.00,NULL,NULL,1,'2022-11-24 14:21:04','2022-11-24 14:21:04',NULL),(1569,NULL,40745,42010,2,1569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',790.00,NULL,NULL,1,'2022-11-24 14:21:04','2022-11-24 14:21:04',NULL),(1570,NULL,40745,42010,2,1570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',1170.00,NULL,NULL,1,'2022-11-24 14:21:04','2022-11-24 14:21:04',NULL);
INSERT INTO `balance_libro` VALUES (1571,NULL,40745,42010,2,1571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',365.00,NULL,NULL,1,'2022-11-24 14:21:04','2022-11-24 14:21:04',NULL),(1572,NULL,40745,42010,2,1572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',1700.00,NULL,NULL,1,'2022-11-24 14:21:04','2022-11-24 14:21:04',NULL),(1573,NULL,40745,42010,2,1573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',320.00,NULL,NULL,1,'2022-11-24 14:21:04','2022-11-24 14:21:04',NULL),(1574,NULL,40745,42010,2,1574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',330.00,NULL,NULL,1,'2022-11-24 14:21:04','2022-11-24 14:21:04',NULL),(1575,NULL,40745,42010,2,1575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',2150.00,NULL,NULL,1,'2022-11-24 14:21:04','2022-11-24 14:21:04',NULL),(1576,NULL,40745,42010,2,1576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',850.00,NULL,NULL,1,'2022-11-24 14:21:04','2022-11-24 14:21:04',NULL),(1577,NULL,40745,42010,2,1577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',490.00,NULL,NULL,1,'2022-11-24 14:21:04','2022-11-24 14:21:04',NULL),(1578,NULL,40745,42010,2,1578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',660.00,NULL,NULL,1,'2022-11-24 14:21:04','2022-11-24 14:21:04',NULL),(1579,NULL,40745,42010,2,1579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',440.00,NULL,NULL,1,'2022-11-24 14:21:04','2022-11-24 14:21:04',NULL),(1580,NULL,40745,42010,2,1580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',560.00,NULL,NULL,1,'2022-11-24 14:21:04','2022-11-24 14:21:04',NULL),(1581,NULL,40745,42010,2,1581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',1560.00,NULL,NULL,1,'2022-11-24 14:21:05','2022-11-24 14:21:05',NULL),(1582,NULL,40745,42010,2,1582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',3000.00,NULL,NULL,1,'2022-11-24 14:21:05','2022-11-24 14:21:05',NULL),(1583,NULL,40745,42010,2,1583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',590.00,NULL,NULL,1,'2022-11-24 14:21:05','2022-11-24 14:21:05',NULL),(1584,NULL,40745,42010,2,1584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',1200.00,NULL,NULL,1,'2022-11-24 14:21:05','2022-11-24 14:21:05',NULL),(1585,NULL,40745,42010,2,1585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',560.00,NULL,NULL,1,'2022-11-24 14:21:05','2022-11-24 14:21:05',NULL),(1586,NULL,40745,42010,2,1586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',1335.00,NULL,NULL,1,'2022-11-24 14:21:05','2022-11-24 14:21:05',NULL),(1587,NULL,40745,42010,2,1587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',395.00,NULL,NULL,1,'2022-11-24 14:21:05','2022-11-24 14:21:05',NULL),(1588,NULL,40745,42010,2,1588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1680.00,NULL,NULL,1,'2022-11-24 14:21:05','2022-11-24 14:21:05',NULL),(1589,NULL,40745,42010,2,1589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',500.00,NULL,NULL,1,'2022-11-24 14:21:05','2022-11-24 14:21:05',NULL),(1590,NULL,40745,42010,2,1590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1380.00,NULL,NULL,1,'2022-11-24 14:21:05','2022-11-24 14:21:05',NULL),(1591,NULL,40745,42010,2,1591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1525.00,NULL,NULL,1,'2022-11-24 14:21:05','2022-11-24 14:21:05',NULL),(1592,NULL,40745,42010,2,1592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1100.00,NULL,NULL,1,'2022-11-24 14:21:05','2022-11-24 14:21:05',NULL),(1593,NULL,40745,42010,2,1593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',520.00,NULL,NULL,1,'2022-11-24 14:21:05','2022-11-24 14:21:05',NULL),(1594,NULL,40745,42010,2,1594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',2140.00,NULL,NULL,1,'2022-11-24 14:21:05','2022-11-24 14:21:05',NULL);
INSERT INTO `balance_libro` VALUES (1595,NULL,40745,42010,2,1595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',6000.00,NULL,NULL,1,'2022-11-24 14:21:05','2022-11-24 14:21:05',NULL),(1596,NULL,40745,42010,2,1596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',420.00,NULL,NULL,1,'2022-11-24 14:21:05','2022-11-24 14:21:05',NULL),(1597,NULL,40745,42010,2,1597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',2360.00,NULL,NULL,1,'2022-11-24 14:21:05','2022-11-24 14:21:05',NULL),(1598,NULL,40745,42010,2,1598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',860.00,NULL,NULL,1,'2022-11-24 14:21:05','2022-11-24 14:21:05',NULL),(1599,NULL,40745,42010,2,1599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',610.00,NULL,NULL,1,'2022-11-24 14:21:05','2022-11-24 14:21:05',NULL),(1600,NULL,40745,42010,2,1600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',850.00,NULL,NULL,1,'2022-11-24 14:21:05','2022-11-24 14:21:05',NULL),(1601,NULL,40745,42010,2,1601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1530.00,NULL,NULL,1,'2022-11-24 14:21:05','2022-11-24 14:21:05',NULL),(1602,NULL,40745,42010,2,1602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',300.00,NULL,NULL,1,'2022-11-24 14:21:06','2022-11-24 14:21:06',NULL),(1603,NULL,40745,42010,2,1603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1760.00,NULL,NULL,1,'2022-11-24 14:21:06','2022-11-24 14:21:06',NULL),(1604,NULL,40745,42010,2,1604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',630.00,NULL,NULL,1,'2022-11-24 14:21:06','2022-11-24 14:21:06',NULL),(1605,NULL,40745,42010,2,1605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',2390.00,NULL,NULL,1,'2022-11-24 14:21:06','2022-11-24 14:21:06',NULL),(1606,NULL,40745,42010,2,1606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',3340.00,NULL,NULL,1,'2022-11-24 14:21:06','2022-11-24 14:21:06',NULL),(1607,NULL,40745,42010,2,1607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',2168.00,NULL,NULL,1,'2022-11-24 14:21:06','2022-11-24 14:21:06',NULL),(1608,NULL,40745,42010,2,1608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',180.00,NULL,NULL,1,'2022-11-24 14:21:06','2022-11-24 14:21:06',NULL),(1609,NULL,40745,42010,2,1609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',600.00,NULL,NULL,1,'2022-11-24 14:21:06','2022-11-24 14:21:06',NULL),(1610,NULL,40745,42010,2,1610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',530.00,NULL,NULL,1,'2022-11-24 14:21:06','2022-11-24 14:21:06',NULL),(1611,NULL,40745,42010,2,1611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',960.00,NULL,NULL,1,'2022-11-24 14:21:06','2022-11-24 14:21:06',NULL),(1612,NULL,40745,42010,2,1612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',580.00,NULL,NULL,1,'2022-11-24 14:21:06','2022-11-24 14:21:06',NULL),(1613,NULL,40745,42010,2,1613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1660.00,NULL,NULL,1,'2022-11-24 14:21:06','2022-11-24 14:21:06',NULL),(1614,NULL,40745,42010,2,1614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',3800.00,NULL,NULL,1,'2022-11-24 14:21:06','2022-11-24 14:21:06',NULL),(1615,NULL,40745,42010,2,1615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',790.00,NULL,NULL,1,'2022-11-24 14:21:06','2022-11-24 14:21:06',NULL),(1616,NULL,40745,42010,2,1616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',2015.00,NULL,NULL,1,'2022-11-24 14:21:06','2022-11-24 14:21:06',NULL),(1617,NULL,40745,42010,2,1617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',380.00,NULL,NULL,1,'2022-11-24 14:21:06','2022-11-24 14:21:06',NULL),(1618,NULL,40745,42010,2,1618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1550.00,NULL,NULL,1,'2022-11-24 14:21:06','2022-11-24 14:21:06',NULL);
INSERT INTO `balance_libro` VALUES (1619,NULL,40745,42010,2,1619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',480.00,NULL,NULL,1,'2022-11-24 14:21:06','2022-11-24 14:21:06',NULL),(1620,NULL,40745,42010,2,1620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',500.00,NULL,NULL,1,'2022-11-24 14:21:06','2022-11-24 14:21:06',NULL),(1621,NULL,40745,42010,2,1621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',2440.00,NULL,NULL,1,'2022-11-24 14:21:06','2022-11-24 14:21:06',NULL),(1622,NULL,40745,42010,2,1622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1530.00,NULL,NULL,1,'2022-11-24 14:21:06','2022-11-24 14:21:06',NULL),(1623,NULL,40745,42010,2,1623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1380.00,NULL,NULL,1,'2022-11-24 14:21:06','2022-11-24 14:21:06',NULL),(1624,NULL,40745,42010,2,1624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1500.00,NULL,NULL,1,'2022-11-24 14:21:06','2022-11-24 14:21:06',NULL),(1625,NULL,40745,42010,2,1625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',830.00,NULL,NULL,1,'2022-11-24 14:21:06','2022-11-24 14:21:06',NULL),(1626,NULL,40745,42010,2,1626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',300.00,NULL,NULL,1,'2022-11-24 14:21:06','2022-11-24 14:21:06',NULL),(1627,NULL,40745,42010,2,1627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',380.00,NULL,NULL,1,'2022-11-24 14:21:06','2022-11-24 14:21:06',NULL),(1628,NULL,40745,42010,2,1628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',2940.00,NULL,NULL,1,'2022-11-24 14:21:06','2022-11-24 14:21:06',NULL),(1629,NULL,40745,42010,2,1629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',470.00,NULL,NULL,1,'2022-11-24 14:21:07','2022-11-24 14:21:07',NULL),(1630,NULL,40745,42010,2,1630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',840.00,NULL,NULL,1,'2022-11-24 14:21:07','2022-11-24 14:21:07',NULL),(1631,NULL,40745,42010,2,1631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1600.00,NULL,NULL,1,'2022-11-24 14:21:07','2022-11-24 14:21:07',NULL),(1632,NULL,40745,42010,2,1632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1840.00,NULL,NULL,1,'2022-11-24 14:21:07','2022-11-24 14:21:07',NULL),(1633,NULL,40745,42010,2,1633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1100.00,NULL,NULL,1,'2022-11-24 14:21:07','2022-11-24 14:21:07',NULL),(1634,NULL,40745,42010,2,1634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',450.00,NULL,NULL,1,'2022-11-24 14:21:07','2022-11-24 14:21:07',NULL),(1635,NULL,40745,42010,2,1635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',3660.00,NULL,NULL,1,'2022-11-24 14:21:07','2022-11-24 14:21:07',NULL),(1636,NULL,40745,42010,2,1636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1670.00,NULL,NULL,1,'2022-11-24 14:21:07','2022-11-24 14:21:07',NULL),(1637,NULL,40745,42010,2,1637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',2975.00,NULL,NULL,1,'2022-11-24 14:21:07','2022-11-24 14:21:07',NULL),(1638,NULL,40745,42010,2,1638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1560.00,NULL,NULL,1,'2022-11-24 14:21:07','2022-11-24 14:21:07',NULL),(1639,NULL,40745,42010,2,1639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',530.00,NULL,NULL,1,'2022-11-24 14:21:07','2022-11-24 14:21:07',NULL),(1640,NULL,40745,42010,2,1640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',600.00,NULL,NULL,1,'2022-11-24 14:21:07','2022-11-24 14:21:07',NULL),(1641,NULL,40745,42010,2,1641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',463.00,NULL,NULL,1,'2022-11-24 14:21:07','2022-11-24 14:21:07',NULL),(1642,NULL,40745,42010,2,1642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',280.00,NULL,NULL,1,'2022-11-24 14:21:07','2022-11-24 14:21:07',NULL);
INSERT INTO `balance_libro` VALUES (1643,NULL,40745,42010,2,1643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',400.00,NULL,NULL,1,'2022-11-24 14:21:07','2022-11-24 14:21:07',NULL),(1644,NULL,40745,42010,2,1644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',500.00,NULL,NULL,1,'2022-11-24 14:21:07','2022-11-24 14:21:07',NULL),(1645,NULL,40745,42010,2,1645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1035.00,NULL,NULL,1,'2022-11-24 14:21:07','2022-11-24 14:21:07',NULL),(1646,NULL,40745,42010,2,1646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1060.00,NULL,NULL,1,'2022-11-24 14:21:07','2022-11-24 14:21:07',NULL),(1647,NULL,40745,42010,2,1647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1490.00,NULL,NULL,1,'2022-11-24 14:21:07','2022-11-24 14:21:07',NULL),(1648,NULL,40745,42010,2,1648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',2160.00,NULL,NULL,1,'2022-11-24 14:21:07','2022-11-24 14:21:07',NULL),(1649,NULL,40745,42010,2,1649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1090.00,NULL,NULL,1,'2022-11-24 14:21:07','2022-11-24 14:21:07',NULL),(1650,NULL,40745,42010,2,1650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',2130.00,NULL,NULL,1,'2022-11-24 14:21:07','2022-11-24 14:21:07',NULL),(1651,NULL,40745,42010,2,1651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',780.00,NULL,NULL,1,'2022-11-24 14:21:07','2022-11-24 14:21:07',NULL),(1652,NULL,40745,42010,2,1652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1390.00,NULL,NULL,1,'2022-11-24 14:21:07','2022-11-24 14:21:07',NULL),(1653,NULL,40745,42010,2,1653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1650.00,NULL,NULL,1,'2022-11-24 14:21:07','2022-11-24 14:21:07',NULL),(1654,NULL,40745,42010,2,1654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',810.00,NULL,NULL,1,'2022-11-24 14:21:07','2022-11-24 14:21:07',NULL),(1655,NULL,40745,42010,2,1655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',300.00,NULL,NULL,1,'2022-11-24 14:21:07','2022-11-24 14:21:07',NULL),(1656,NULL,40745,42010,2,1656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1750.00,NULL,NULL,1,'2022-11-24 14:21:07','2022-11-24 14:21:07',NULL),(1657,NULL,40745,42010,2,1657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',2370.00,NULL,NULL,1,'2022-11-24 14:21:07','2022-11-24 14:21:07',NULL),(1658,NULL,40745,42010,2,1658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',210.00,NULL,NULL,1,'2022-11-24 14:21:08','2022-11-24 14:21:08',NULL),(1659,NULL,40745,42010,2,1659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',430.00,NULL,NULL,1,'2022-11-24 14:21:08','2022-11-24 14:21:08',NULL),(1660,NULL,40745,42010,2,1660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1770.00,NULL,NULL,1,'2022-11-24 14:21:08','2022-11-24 14:21:08',NULL),(1661,NULL,40745,42010,2,1661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',910.00,NULL,NULL,1,'2022-11-24 14:21:08','2022-11-24 14:21:08',NULL),(1662,NULL,40745,42010,2,1662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',740.00,NULL,NULL,1,'2022-11-24 14:21:08','2022-11-24 14:21:08',NULL),(1663,NULL,40745,42010,2,1663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',850.00,NULL,NULL,1,'2022-11-24 14:21:08','2022-11-24 14:21:08',NULL),(1664,NULL,40745,42010,2,1664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',3030.00,NULL,NULL,1,'2022-11-24 14:21:08','2022-11-24 14:21:08',NULL),(1665,NULL,40745,42010,2,1665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',3090.00,NULL,NULL,1,'2022-11-24 14:21:08','2022-11-24 14:21:08',NULL),(1666,NULL,40745,42010,2,1666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',360.00,NULL,NULL,1,'2022-11-24 14:21:08','2022-11-24 14:21:08',NULL);
INSERT INTO `balance_libro` VALUES (1667,NULL,40745,42010,2,1667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1900.00,NULL,NULL,1,'2022-11-24 14:21:08','2022-11-24 14:21:08',NULL),(1668,NULL,40745,42010,2,1668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',11622.00,NULL,NULL,1,'2022-11-24 14:21:08','2022-11-24 14:21:08',NULL),(1669,NULL,40745,42010,2,1669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',2060.00,NULL,NULL,1,'2022-11-24 14:21:08','2022-11-24 14:21:08',NULL),(1670,NULL,40745,42010,2,1670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',3750.00,NULL,NULL,1,'2022-11-24 14:21:08','2022-11-24 14:21:08',NULL),(1671,NULL,40745,42010,2,1671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1020.00,NULL,NULL,1,'2022-11-24 14:21:08','2022-11-24 14:21:08',NULL),(1672,NULL,40745,42010,2,1672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1185.00,NULL,NULL,1,'2022-11-24 14:21:08','2022-11-24 14:21:08',NULL),(1673,NULL,40745,42010,2,1673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',250.00,NULL,NULL,1,'2022-11-24 14:21:08','2022-11-24 14:21:08',NULL),(1674,NULL,40745,42010,2,1674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',350.00,NULL,NULL,1,'2022-11-24 14:21:08','2022-11-24 14:21:08',NULL),(1675,NULL,40745,42010,2,1675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1050.00,NULL,NULL,1,'2022-11-24 14:21:08','2022-11-24 14:21:08',NULL),(1676,NULL,40745,42010,2,1676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',2745.00,NULL,NULL,1,'2022-11-24 14:21:08','2022-11-24 14:21:08',NULL),(1677,NULL,40745,42010,2,1677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',930.00,NULL,NULL,1,'2022-11-24 14:21:08','2022-11-24 14:21:08',NULL),(1678,NULL,40745,42010,2,1678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',380.00,NULL,NULL,1,'2022-11-24 14:21:08','2022-11-24 14:21:08',NULL),(1679,NULL,40745,42010,2,1679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',2120.00,NULL,NULL,1,'2022-11-24 14:21:08','2022-11-24 14:21:08',NULL),(1680,NULL,40745,42010,2,1680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',2420.00,NULL,NULL,1,'2022-11-24 14:21:08','2022-11-24 14:21:08',NULL),(1681,NULL,40745,42010,2,1681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',4160.00,NULL,NULL,1,'2022-11-24 14:21:08','2022-11-24 14:21:08',NULL),(1682,NULL,40745,42010,2,1682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',2490.00,NULL,NULL,1,'2022-11-24 14:21:09','2022-11-24 14:21:09',NULL),(1683,NULL,40745,42010,2,1683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',970.00,NULL,NULL,1,'2022-11-24 14:21:09','2022-11-24 14:21:09',NULL),(1684,NULL,40745,42010,2,1684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',4300.00,NULL,NULL,1,'2022-11-24 14:21:09','2022-11-24 14:21:09',NULL),(1685,NULL,40745,42010,2,1685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1150.00,NULL,NULL,1,'2022-11-24 14:21:09','2022-11-24 14:21:09',NULL),(1686,NULL,40745,42010,2,1686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',665.00,NULL,NULL,1,'2022-11-24 14:21:09','2022-11-24 14:21:09',NULL),(1687,NULL,40745,42010,2,1687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',485.00,NULL,NULL,1,'2022-11-24 14:21:09','2022-11-24 14:21:09',NULL),(1688,NULL,40745,42010,2,1688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',100.00,NULL,NULL,1,'2022-11-24 14:21:09','2022-11-24 14:21:09',NULL),(1689,NULL,40745,42010,2,1689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',400.00,NULL,NULL,1,'2022-11-24 14:21:09','2022-11-24 14:21:09',NULL),(1690,NULL,40745,42010,2,1690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',2505.00,NULL,NULL,1,'2022-11-24 14:21:09','2022-11-24 14:21:09',NULL);
INSERT INTO `balance_libro` VALUES (1691,NULL,40745,42010,2,1691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',2835.00,NULL,NULL,1,'2022-11-24 14:21:09','2022-11-24 14:21:09',NULL),(1692,NULL,40745,42010,2,1692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',2640.00,NULL,NULL,1,'2022-11-24 14:21:09','2022-11-24 14:21:09',NULL),(1693,NULL,40745,42010,2,1693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',2330.00,NULL,NULL,1,'2022-11-24 14:21:09','2022-11-24 14:21:09',NULL),(1694,NULL,40745,42010,2,1694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',150.00,NULL,NULL,1,'2022-11-24 14:21:09','2022-11-24 14:21:09',NULL),(1695,NULL,40745,42010,2,1695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',2400.00,NULL,NULL,1,'2022-11-24 14:21:09','2022-11-24 14:21:09',NULL),(1696,NULL,40745,42010,2,1696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',440.00,NULL,NULL,1,'2022-11-24 14:21:09','2022-11-24 14:21:09',NULL),(1697,NULL,40745,42010,2,1697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1050.00,NULL,NULL,1,'2022-11-24 14:21:09','2022-11-24 14:21:09',NULL),(1698,NULL,40745,42010,2,1698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',970.00,NULL,NULL,1,'2022-11-24 14:21:09','2022-11-24 14:21:09',NULL),(1699,NULL,40745,42010,2,1699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1070.00,NULL,NULL,1,'2022-11-24 14:21:09','2022-11-24 14:21:09',NULL),(1700,NULL,40745,42010,2,1700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1080.00,NULL,NULL,1,'2022-11-24 14:21:09','2022-11-24 14:21:09',NULL),(1701,NULL,40745,42010,2,1701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1370.00,NULL,NULL,1,'2022-11-24 14:21:09','2022-11-24 14:21:09',NULL),(1702,NULL,40745,42010,2,1702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',780.00,NULL,NULL,1,'2022-11-24 14:21:09','2022-11-24 14:21:09',NULL),(1703,NULL,40745,42010,2,1703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1840.00,NULL,NULL,1,'2022-11-24 14:21:09','2022-11-24 14:21:09',NULL),(1704,NULL,40745,42010,2,1704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',980.00,NULL,NULL,1,'2022-11-24 14:21:09','2022-11-24 14:21:09',NULL),(1705,NULL,40745,42010,2,1705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',425.00,NULL,NULL,1,'2022-11-24 14:21:09','2022-11-24 14:21:09',NULL),(1706,NULL,40745,42010,2,1706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1070.00,NULL,NULL,1,'2022-11-24 14:21:09','2022-11-24 14:21:09',NULL),(1707,NULL,40745,42010,2,1707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',5400.00,NULL,NULL,1,'2022-11-24 14:21:10','2022-11-24 14:21:10',NULL),(1708,NULL,40745,42010,2,1708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1080.00,NULL,NULL,1,'2022-11-24 14:21:10','2022-11-24 14:21:10',NULL),(1709,NULL,40745,42010,2,1709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',460.00,NULL,NULL,1,'2022-11-24 14:21:10','2022-11-24 14:21:10',NULL),(1710,NULL,40745,42010,2,1710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',6094.00,NULL,NULL,1,'2022-11-24 14:21:10','2022-11-24 14:21:10',NULL),(1711,NULL,40745,42010,2,1711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',280.00,NULL,NULL,1,'2022-11-24 14:21:10','2022-11-24 14:21:10',NULL),(1712,NULL,40745,42010,2,1712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',600.00,NULL,NULL,1,'2022-11-24 14:21:10','2022-11-24 14:21:10',NULL),(1713,NULL,40745,42010,2,1713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1390.00,NULL,NULL,1,'2022-11-24 14:21:10','2022-11-24 14:21:10',NULL),(1714,NULL,40745,42010,2,1714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',700.00,NULL,NULL,1,'2022-11-24 14:21:10','2022-11-24 14:21:10',NULL);
INSERT INTO `balance_libro` VALUES (1715,NULL,40745,42010,2,1715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',150.00,NULL,NULL,1,'2022-11-24 14:21:10','2022-11-24 14:21:10',NULL),(1716,NULL,40745,42010,2,1716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1110.00,NULL,NULL,1,'2022-11-24 14:21:10','2022-11-24 14:21:10',NULL),(1717,NULL,40745,42010,2,1717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1790.00,NULL,NULL,1,'2022-11-24 14:21:10','2022-11-24 14:21:10',NULL),(1718,NULL,40745,42010,2,1718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',2410.00,NULL,NULL,1,'2022-11-24 14:21:10','2022-11-24 14:21:10',NULL),(1719,NULL,40745,42010,2,1719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',600.00,NULL,NULL,1,'2022-11-24 14:21:10','2022-11-24 14:21:10',NULL),(1720,NULL,40745,42010,2,1720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',110.00,NULL,NULL,1,'2022-11-24 14:21:10','2022-11-24 14:21:10',NULL),(1721,NULL,40745,42010,2,1721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',690.00,NULL,NULL,1,'2022-11-24 14:21:10','2022-11-24 14:21:10',NULL),(1722,NULL,40745,42010,2,1722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',2540.00,NULL,NULL,1,'2022-11-24 14:21:10','2022-11-24 14:21:10',NULL),(1723,NULL,40745,42010,2,1723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',240.00,NULL,NULL,1,'2022-11-24 14:21:10','2022-11-24 14:21:10',NULL),(1724,NULL,40745,42010,2,1724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1920.00,NULL,NULL,1,'2022-11-24 14:21:10','2022-11-24 14:21:10',NULL),(1725,NULL,40745,42010,2,1725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',250.00,NULL,NULL,1,'2022-11-24 14:21:10','2022-11-24 14:21:10',NULL),(1726,NULL,40745,42010,2,1726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',120.00,NULL,NULL,1,'2022-11-24 14:21:10','2022-11-24 14:21:10',NULL),(1727,NULL,40745,42010,2,1727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',6760.00,NULL,NULL,1,'2022-11-24 14:21:10','2022-11-24 14:21:10',NULL),(1728,NULL,40745,42010,2,1728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1190.00,NULL,NULL,1,'2022-11-24 14:21:10','2022-11-24 14:21:10',NULL),(1729,NULL,40745,42010,2,1729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',675.00,NULL,NULL,1,'2022-11-24 14:21:10','2022-11-24 14:21:10',NULL),(1730,NULL,40745,42010,2,1730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',600.00,NULL,NULL,1,'2022-11-24 14:21:10','2022-11-24 14:21:10',NULL),(1731,NULL,40745,42010,2,1731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',465.00,NULL,NULL,1,'2022-11-24 14:21:10','2022-11-24 14:21:10',NULL),(1732,NULL,40745,42010,2,1732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',380.00,NULL,NULL,1,'2022-11-24 14:21:10','2022-11-24 14:21:10',NULL),(1733,NULL,40745,42010,2,1733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',150.00,NULL,NULL,1,'2022-11-24 14:21:10','2022-11-24 14:21:10',NULL),(1734,NULL,40745,42010,2,1734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',295.00,NULL,NULL,1,'2022-11-24 14:21:10','2022-11-24 14:21:10',NULL),(1735,NULL,40745,42010,2,1735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',360.00,NULL,NULL,1,'2022-11-24 14:21:10','2022-11-24 14:21:10',NULL),(1736,NULL,40745,42010,2,1736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',580.00,NULL,NULL,1,'2022-11-24 14:21:11','2022-11-24 14:21:11',NULL),(1737,NULL,40745,42010,2,1737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1090.00,NULL,NULL,1,'2022-11-24 14:21:11','2022-11-24 14:21:11',NULL),(1738,NULL,40745,42010,2,1738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',315.00,NULL,NULL,1,'2022-11-24 14:21:11','2022-11-24 14:21:11',NULL);
INSERT INTO `balance_libro` VALUES (1739,NULL,40745,42010,2,1739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1095.00,NULL,NULL,1,'2022-11-24 14:21:11','2022-11-24 14:21:11',NULL),(1740,NULL,40745,42010,2,1740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',390.00,NULL,NULL,1,'2022-11-24 14:21:11','2022-11-24 14:21:11',NULL),(1741,NULL,40745,42010,2,1741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1130.00,NULL,NULL,1,'2022-11-24 14:21:11','2022-11-24 14:21:11',NULL),(1742,NULL,40745,42010,2,1742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',465.00,NULL,NULL,1,'2022-11-24 14:21:11','2022-11-24 14:21:11',NULL),(1743,NULL,40745,42010,2,1743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',2470.00,NULL,NULL,1,'2022-11-24 14:21:11','2022-11-24 14:21:11',NULL),(1744,NULL,40745,42010,2,1744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',2005.00,NULL,NULL,1,'2022-11-24 14:21:11','2022-11-24 14:21:11',NULL),(1745,NULL,40745,42010,2,1745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',510.00,NULL,NULL,1,'2022-11-24 14:21:11','2022-11-24 14:21:11',NULL),(1746,NULL,40745,42010,2,1746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',250.00,NULL,NULL,1,'2022-11-24 14:21:11','2022-11-24 14:21:11',NULL),(1747,NULL,40745,42010,2,1747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1220.00,NULL,NULL,1,'2022-11-24 14:21:11','2022-11-24 14:21:11',NULL),(1748,NULL,40745,42010,2,1748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',4850.00,NULL,NULL,1,'2022-11-24 14:21:11','2022-11-24 14:21:11',NULL),(1749,NULL,40745,42010,2,1749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',481.00,NULL,NULL,1,'2022-11-24 14:21:11','2022-11-24 14:21:11',NULL),(1750,NULL,40745,42010,2,1750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',990.00,NULL,NULL,1,'2022-11-24 14:21:11','2022-11-24 14:21:11',NULL),(1751,NULL,40745,42010,2,1751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1310.00,NULL,NULL,1,'2022-11-24 14:21:11','2022-11-24 14:21:11',NULL),(1752,NULL,40745,42010,2,1752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1640.00,NULL,NULL,1,'2022-11-24 14:21:11','2022-11-24 14:21:11',NULL),(1753,NULL,40745,42010,2,1753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1040.00,NULL,NULL,1,'2022-11-24 14:21:11','2022-11-24 14:21:11',NULL),(1754,NULL,40745,42010,2,1754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',890.00,NULL,NULL,1,'2022-11-24 14:21:11','2022-11-24 14:21:11',NULL),(1755,NULL,40745,42010,2,1755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1075.00,NULL,NULL,1,'2022-11-24 14:21:11','2022-11-24 14:21:11',NULL),(1756,NULL,40745,42010,2,1756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',710.00,NULL,NULL,1,'2022-11-24 14:21:11','2022-11-24 14:21:11',NULL),(1757,NULL,40745,42010,2,1757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',997.00,NULL,NULL,1,'2022-11-24 14:21:11','2022-11-24 14:21:11',NULL),(1758,NULL,40745,42010,2,1758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1279.00,NULL,NULL,1,'2022-11-24 14:21:11','2022-11-24 14:21:11',NULL),(1759,NULL,40745,42010,2,1759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',610.00,NULL,NULL,1,'2022-11-24 14:21:11','2022-11-24 14:21:11',NULL),(1760,NULL,40745,42010,2,1760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',985.00,NULL,NULL,1,'2022-11-24 14:21:11','2022-11-24 14:21:11',NULL),(1761,NULL,40745,42010,2,1761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',5275.00,NULL,NULL,1,'2022-11-24 14:21:11','2022-11-24 14:21:11',NULL),(1762,NULL,40745,42010,2,1762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1240.00,NULL,NULL,1,'2022-11-24 14:21:11','2022-11-24 14:21:11',NULL);
INSERT INTO `balance_libro` VALUES (1763,NULL,40745,42010,2,1763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1280.00,NULL,NULL,1,'2022-11-24 14:21:11','2022-11-24 14:21:11',NULL),(1764,NULL,40745,42010,2,1764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1185.00,NULL,NULL,1,'2022-11-24 14:21:11','2022-11-24 14:21:11',NULL),(1765,NULL,40745,42010,2,1765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',290.00,NULL,NULL,1,'2022-11-24 14:21:12','2022-11-24 14:21:12',NULL),(1766,NULL,40745,42010,2,1766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',400.00,NULL,NULL,1,'2022-11-24 14:21:12','2022-11-24 14:21:12',NULL),(1767,NULL,40745,42010,2,1767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1110.00,NULL,NULL,1,'2022-11-24 14:21:12','2022-11-24 14:21:12',NULL),(1768,NULL,40745,42010,2,1768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1160.00,NULL,NULL,1,'2022-11-24 14:21:12','2022-11-24 14:21:12',NULL),(1769,NULL,40745,42010,2,1769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1890.00,NULL,NULL,1,'2022-11-24 14:21:12','2022-11-24 14:21:12',NULL),(1770,NULL,40745,42010,2,1770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',550.00,NULL,NULL,1,'2022-11-24 14:21:12','2022-11-24 14:21:12',NULL),(1771,NULL,40745,42010,2,1771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',765.00,NULL,NULL,1,'2022-11-24 14:21:12','2022-11-24 14:21:12',NULL),(1772,NULL,40745,42010,2,1772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1995.00,NULL,NULL,1,'2022-11-24 14:21:12','2022-11-24 14:21:12',NULL),(1773,NULL,40745,42010,2,1773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1560.00,NULL,NULL,1,'2022-11-24 14:21:12','2022-11-24 14:21:12',NULL),(1774,NULL,40745,42010,2,1774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',660.00,NULL,NULL,1,'2022-11-24 14:21:12','2022-11-24 14:21:12',NULL),(1775,NULL,40745,42010,2,1775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1600.00,NULL,NULL,1,'2022-11-24 14:21:12','2022-11-24 14:21:12',NULL),(1776,NULL,40745,42010,2,1776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',310.00,NULL,NULL,1,'2022-11-24 14:21:12','2022-11-24 14:21:12',NULL),(1777,NULL,40745,42010,2,1777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',120.00,NULL,NULL,1,'2022-11-24 14:21:12','2022-11-24 14:21:12',NULL),(1778,NULL,40745,42010,2,1778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',250.00,NULL,NULL,1,'2022-11-24 14:21:12','2022-11-24 14:21:12',NULL),(1779,NULL,40745,42010,2,1779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',850.00,NULL,NULL,1,'2022-11-24 14:21:12','2022-11-24 14:21:12',NULL),(1780,NULL,40745,42010,2,1780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',530.00,NULL,NULL,1,'2022-11-24 14:21:12','2022-11-24 14:21:12',NULL),(1781,NULL,40745,42010,2,1781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1190.00,NULL,NULL,1,'2022-11-24 14:21:12','2022-11-24 14:21:12',NULL),(1782,NULL,40745,42010,2,1782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1000.00,NULL,NULL,1,'2022-11-24 14:21:12','2022-11-24 14:21:12',NULL),(1783,NULL,40745,42010,2,1783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1550.00,NULL,NULL,1,'2022-11-24 14:21:12','2022-11-24 14:21:12',NULL),(1784,NULL,40745,42010,2,1784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1260.00,NULL,NULL,1,'2022-11-24 14:21:12','2022-11-24 14:21:12',NULL),(1785,NULL,40745,42010,2,1785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1260.00,NULL,NULL,1,'2022-11-24 14:21:12','2022-11-24 14:21:12',NULL),(1786,NULL,40745,42010,2,1786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',820.00,NULL,NULL,1,'2022-11-24 14:21:12','2022-11-24 14:21:12',NULL);
INSERT INTO `balance_libro` VALUES (1787,NULL,40745,42010,2,1787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',400.00,NULL,NULL,1,'2022-11-24 14:21:12','2022-11-24 14:21:12',NULL),(1788,NULL,40745,42010,2,1788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',300.00,NULL,NULL,1,'2022-11-24 14:21:12','2022-11-24 14:21:12',NULL),(1789,NULL,40745,42010,2,1789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',400.00,NULL,NULL,1,'2022-11-24 14:21:12','2022-11-24 14:21:12',NULL),(1790,NULL,40745,42010,2,1790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1405.00,NULL,NULL,1,'2022-11-24 14:21:12','2022-11-24 14:21:12',NULL),(1791,NULL,40745,42010,2,1791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',990.00,NULL,NULL,1,'2022-11-24 14:21:12','2022-11-24 14:21:12',NULL),(1792,NULL,40745,42010,2,1792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',2650.00,NULL,NULL,1,'2022-11-24 14:21:12','2022-11-24 14:21:12',NULL),(1793,NULL,40745,42010,2,1793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',200.00,NULL,NULL,1,'2022-11-24 14:21:12','2022-11-24 14:21:12',NULL),(1794,NULL,40745,42010,2,1794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',4780.00,NULL,NULL,1,'2022-11-24 14:21:13','2022-11-24 14:21:13',NULL),(1795,NULL,40745,42010,2,1795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',3000.00,NULL,NULL,1,'2022-11-24 14:21:13','2022-11-24 14:21:13',NULL),(1796,NULL,40745,42010,2,1796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1280.00,NULL,NULL,1,'2022-11-24 14:21:13','2022-11-24 14:21:13',NULL),(1797,NULL,40745,42010,2,1797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',200.00,NULL,NULL,1,'2022-11-24 14:21:13','2022-11-24 14:21:13',NULL),(1798,NULL,40745,42010,2,1798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',2250.00,NULL,NULL,1,'2022-11-24 14:21:13','2022-11-24 14:21:13',NULL),(1799,NULL,40745,42010,2,1799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',4150.00,NULL,NULL,1,'2022-11-24 14:21:13','2022-11-24 14:21:13',NULL),(1800,NULL,40745,42010,2,1800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1150.00,NULL,NULL,1,'2022-11-24 14:21:13','2022-11-24 14:21:13',NULL),(1801,NULL,40745,42010,2,1801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',770.00,NULL,NULL,1,'2022-11-24 14:21:13','2022-11-24 14:21:13',NULL),(1802,NULL,40745,42010,2,1802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',2565.00,NULL,NULL,1,'2022-11-24 14:21:13','2022-11-24 14:21:13',NULL),(1803,NULL,40745,42010,2,1803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',690.00,NULL,NULL,1,'2022-11-24 14:21:13','2022-11-24 14:21:13',NULL),(1804,NULL,40745,42010,2,1804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1705.00,NULL,NULL,1,'2022-11-24 14:21:13','2022-11-24 14:21:13',NULL),(1805,NULL,40745,42010,2,1805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',585.00,NULL,NULL,1,'2022-11-24 14:21:13','2022-11-24 14:21:13',NULL),(1806,NULL,40745,42010,2,1806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',590.00,NULL,NULL,1,'2022-11-24 14:21:13','2022-11-24 14:21:13',NULL),(1807,NULL,40745,42010,2,1807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',300.00,NULL,NULL,1,'2022-11-24 14:21:13','2022-11-24 14:21:13',NULL),(1808,NULL,40745,42010,2,1808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',3000.00,NULL,NULL,1,'2022-11-24 14:21:13','2022-11-24 14:21:13',NULL),(1809,NULL,40745,42010,2,1809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',3880.00,NULL,NULL,1,'2022-11-24 14:21:13','2022-11-24 14:21:13',NULL),(1810,NULL,40745,42010,2,1810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',190.00,NULL,NULL,1,'2022-11-24 14:21:13','2022-11-24 14:21:13',NULL);
INSERT INTO `balance_libro` VALUES (1811,NULL,40745,42010,2,1811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',410.00,NULL,NULL,1,'2022-11-24 14:21:13','2022-11-24 14:21:13',NULL),(1812,NULL,40745,42010,2,1812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1400.00,NULL,NULL,1,'2022-11-24 14:21:13','2022-11-24 14:21:13',NULL),(1813,NULL,40745,42010,2,1813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1480.00,NULL,NULL,1,'2022-11-24 14:21:13','2022-11-24 14:21:13',NULL),(1814,NULL,40745,42010,2,1814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',2780.00,NULL,NULL,1,'2022-11-24 14:21:13','2022-11-24 14:21:13',NULL),(1815,NULL,40745,42010,2,1815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',2160.00,NULL,NULL,1,'2022-11-24 14:21:13','2022-11-24 14:21:13',NULL),(1816,NULL,40745,42010,2,1816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',200.00,NULL,NULL,1,'2022-11-24 14:21:13','2022-11-24 14:21:13',NULL),(1817,NULL,40745,42010,2,1817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',4910.00,NULL,NULL,1,'2022-11-24 14:21:13','2022-11-24 14:21:13',NULL),(1818,NULL,40745,42010,2,1818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',2030.00,NULL,NULL,1,'2022-11-24 14:21:13','2022-11-24 14:21:13',NULL),(1819,NULL,40745,42010,2,1819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',100.00,NULL,NULL,1,'2022-11-24 14:21:13','2022-11-24 14:21:13',NULL),(1820,NULL,40745,42010,2,1820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',800.00,NULL,NULL,1,'2022-11-24 14:21:13','2022-11-24 14:21:13',NULL),(1821,NULL,40745,42010,2,1821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',800.00,NULL,NULL,1,'2022-11-24 14:21:14','2022-11-24 14:21:14',NULL),(1822,NULL,40745,42010,2,1822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1400.00,NULL,NULL,1,'2022-11-24 14:21:14','2022-11-24 14:21:14',NULL),(1823,NULL,40745,42010,2,1823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',270.00,NULL,NULL,1,'2022-11-24 14:21:14','2022-11-24 14:21:14',NULL),(1824,NULL,40745,42010,2,1824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',580.00,NULL,NULL,1,'2022-11-24 14:21:14','2022-11-24 14:21:14',NULL),(1825,NULL,40745,42010,2,1825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',600.00,NULL,NULL,1,'2022-11-24 14:21:14','2022-11-24 14:21:14',NULL),(1826,NULL,40745,42010,2,1826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',330.00,NULL,NULL,1,'2022-11-24 14:21:14','2022-11-24 14:21:14',NULL),(1827,NULL,40745,42010,2,1827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',550.00,NULL,NULL,1,'2022-11-24 14:21:14','2022-11-24 14:21:14',NULL),(1828,NULL,40745,42010,2,1828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',5980.00,NULL,NULL,1,'2022-11-24 14:21:14','2022-11-24 14:21:14',NULL),(1829,NULL,40745,42010,2,1829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1530.00,NULL,NULL,1,'2022-11-24 14:21:14','2022-11-24 14:21:14',NULL),(1830,NULL,40745,42010,2,1830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',460.00,NULL,NULL,1,'2022-11-24 14:21:14','2022-11-24 14:21:14',NULL),(1831,NULL,40745,42010,2,1831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',750.00,NULL,NULL,1,'2022-11-24 14:21:14','2022-11-24 14:21:14',NULL),(1832,NULL,40745,42010,2,1832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',3460.00,NULL,NULL,1,'2022-11-24 14:21:14','2022-11-24 14:21:14',NULL),(1833,NULL,40745,42010,2,1833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',300.00,NULL,NULL,1,'2022-11-24 14:21:14','2022-11-24 14:21:14',NULL),(1834,NULL,40745,42010,2,1834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1700.00,NULL,NULL,1,'2022-11-24 14:21:14','2022-11-24 14:21:14',NULL);
INSERT INTO `balance_libro` VALUES (1835,NULL,40745,42010,2,1835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1255.00,NULL,NULL,1,'2022-11-24 14:21:14','2022-11-24 14:21:14',NULL),(1836,NULL,40745,42010,2,1836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',850.00,NULL,NULL,1,'2022-11-24 14:21:14','2022-11-24 14:21:14',NULL),(1837,NULL,40745,42010,2,1837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1345.00,NULL,NULL,1,'2022-11-24 14:21:14','2022-11-24 14:21:14',NULL),(1838,NULL,40745,42010,2,1838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',460.00,NULL,NULL,1,'2022-11-24 14:21:14','2022-11-24 14:21:14',NULL),(1839,NULL,40745,42010,2,1839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',540.00,NULL,NULL,1,'2022-11-24 14:21:14','2022-11-24 14:21:14',NULL),(1840,NULL,40745,42010,2,1840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',1465.00,NULL,NULL,1,'2022-11-24 14:21:14','2022-11-24 14:21:14',NULL),(1841,NULL,40745,42010,2,1841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',625.00,NULL,NULL,1,'2022-11-24 14:21:14','2022-11-24 14:21:14',NULL),(1842,NULL,40745,42010,2,1842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',1100.00,NULL,NULL,1,'2022-11-24 14:21:14','2022-11-24 14:21:14',NULL),(1843,NULL,40745,42010,2,1843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',340.00,NULL,NULL,1,'2022-11-24 14:21:14','2022-11-24 14:21:14',NULL),(1844,NULL,40745,42010,2,1844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',735.00,NULL,NULL,1,'2022-11-24 14:21:14','2022-11-24 14:21:14',NULL),(1845,NULL,40745,42010,2,1845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',2970.00,NULL,NULL,1,'2022-11-24 14:21:14','2022-11-24 14:21:14',NULL),(1846,NULL,40745,42010,2,1846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',2545.00,NULL,NULL,1,'2022-11-24 14:21:14','2022-11-24 14:21:14',NULL),(1847,NULL,40745,42010,2,1847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',10395.00,NULL,NULL,1,'2022-11-24 14:21:15','2022-11-24 14:21:15',NULL),(1848,NULL,40745,42010,2,1848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',400.00,NULL,NULL,1,'2022-11-24 14:21:15','2022-11-24 14:21:15',NULL),(1849,NULL,40745,42010,2,1849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',700.00,NULL,NULL,1,'2022-11-24 14:21:15','2022-11-24 14:21:15',NULL),(1850,NULL,40745,42010,2,1850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',1480.00,NULL,NULL,1,'2022-11-24 14:21:15','2022-11-24 14:21:15',NULL),(1851,NULL,40745,42010,2,1851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',100.00,NULL,NULL,1,'2022-11-24 14:21:15','2022-11-24 14:21:15',NULL),(1852,NULL,40745,42010,2,1852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',360.00,NULL,NULL,1,'2022-11-24 14:21:15','2022-11-24 14:21:15',NULL),(1853,NULL,40745,42010,2,1853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',1100.00,NULL,NULL,1,'2022-11-24 14:21:15','2022-11-24 14:21:15',NULL),(1854,NULL,40745,42010,2,1854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',540.00,NULL,NULL,1,'2022-11-24 14:21:15','2022-11-24 14:21:15',NULL),(1855,NULL,40745,42010,2,1855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',750.00,NULL,NULL,1,'2022-11-24 14:21:15','2022-11-24 14:21:15',NULL),(1856,NULL,40745,42010,2,1856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',1000.00,NULL,NULL,1,'2022-11-24 14:21:15','2022-11-24 14:21:15',NULL),(1857,NULL,40745,42010,2,1857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',650.00,NULL,NULL,1,'2022-11-24 14:21:15','2022-11-24 14:21:15',NULL),(1858,NULL,40745,42010,2,1858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',750.00,NULL,NULL,1,'2022-11-24 14:21:15','2022-11-24 14:21:15',NULL);
INSERT INTO `balance_libro` VALUES (1859,NULL,40745,42010,2,1859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',3500.00,NULL,NULL,1,'2022-11-24 14:21:15','2022-11-24 14:21:15',NULL),(1860,NULL,40745,42010,2,1860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',600.00,NULL,NULL,1,'2022-11-24 14:21:15','2022-11-24 14:21:15',NULL),(1861,NULL,40745,42010,2,1861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',470.00,NULL,NULL,1,'2022-11-24 14:21:15','2022-11-24 14:21:15',NULL),(1862,NULL,40745,42010,2,1862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',800.00,NULL,NULL,1,'2022-11-24 14:21:16','2022-11-24 14:21:16',NULL),(1863,NULL,40745,42010,2,1863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',1500.00,NULL,NULL,1,'2022-11-24 14:21:16','2022-11-24 14:21:16',NULL),(1864,NULL,40745,42010,2,1864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',900.00,NULL,NULL,1,'2022-11-24 14:21:16','2022-11-24 14:21:16',NULL),(1865,NULL,40745,42010,2,1865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',1700.00,NULL,NULL,1,'2022-11-24 14:21:16','2022-11-24 14:21:16',NULL),(1866,NULL,40745,42010,2,1866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',950.00,NULL,NULL,1,'2022-11-24 14:21:16','2022-11-24 14:21:16',NULL),(1867,NULL,40745,42010,2,1867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',470.00,NULL,NULL,1,'2022-11-24 14:21:16','2022-11-24 14:21:16',NULL),(1868,NULL,40745,42010,2,1868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',340.00,NULL,NULL,1,'2022-11-24 14:21:16','2022-11-24 14:21:16',NULL),(1869,NULL,40745,42010,2,1869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',450.00,NULL,NULL,1,'2022-11-24 14:21:16','2022-11-24 14:21:16',NULL),(1870,NULL,40745,42010,2,1870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',2910.00,NULL,NULL,1,'2022-11-24 14:21:16','2022-11-24 14:21:16',NULL),(1871,NULL,40745,42010,2,1871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',910.00,NULL,NULL,1,'2022-11-24 14:21:16','2022-11-24 14:21:16',NULL),(1872,NULL,40745,42010,2,1872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',710.00,NULL,NULL,1,'2022-11-24 14:21:16','2022-11-24 14:21:16',NULL),(1873,NULL,40745,42010,2,1873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',270.00,NULL,NULL,1,'2022-11-24 14:21:17','2022-11-24 14:21:17',NULL),(1874,NULL,40745,42010,2,1874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',290.00,NULL,NULL,1,'2022-11-24 14:21:17','2022-11-24 14:21:17',NULL),(1875,NULL,40745,42010,2,1875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',950.00,NULL,NULL,1,'2022-11-24 14:21:17','2022-11-24 14:21:17',NULL),(1876,NULL,40745,42010,2,1876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',1510.00,NULL,NULL,1,'2022-11-24 14:21:17','2022-11-24 14:21:17',NULL),(1877,NULL,40745,42010,2,1877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',100.00,NULL,NULL,1,'2022-11-24 14:21:17','2022-11-24 14:21:17',NULL),(1878,NULL,40745,42010,2,1878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',310.00,NULL,NULL,1,'2022-11-24 14:21:17','2022-11-24 14:21:17',NULL),(1879,NULL,40745,42010,2,1879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',850.00,NULL,NULL,1,'2022-11-24 14:21:17','2022-11-24 14:21:17',NULL),(1880,NULL,40745,42010,2,1880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',268.00,NULL,NULL,1,'2022-11-24 14:21:17','2022-11-24 14:21:17',NULL),(1881,NULL,40745,42010,2,1881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',720.00,NULL,NULL,1,'2022-11-24 14:21:17','2022-11-24 14:21:17',NULL),(1882,NULL,40745,42010,2,1882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',320.00,NULL,NULL,1,'2022-11-24 14:21:17','2022-11-24 14:21:17',NULL);
INSERT INTO `balance_libro` VALUES (1883,NULL,40745,42010,2,1883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',300.00,NULL,NULL,1,'2022-11-24 14:21:17','2022-11-24 14:21:17',NULL),(1884,NULL,40745,42010,2,1884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',100.00,NULL,NULL,1,'2022-11-24 14:21:17','2022-11-24 14:21:17',NULL),(1885,NULL,40745,42010,2,1885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',550.00,NULL,NULL,1,'2022-11-24 14:21:17','2022-11-24 14:21:17',NULL),(1886,NULL,40745,42010,2,1886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',480.00,NULL,NULL,1,'2022-11-24 14:21:17','2022-11-24 14:21:17',NULL),(1887,NULL,40745,42010,2,1887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',1200.00,NULL,NULL,1,'2022-11-24 14:21:17','2022-11-24 14:21:17',NULL),(1888,NULL,40745,42010,2,1888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',340.00,NULL,NULL,1,'2022-11-24 14:21:17','2022-11-24 14:21:17',NULL),(1889,NULL,40745,42010,2,1889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',220.00,NULL,NULL,1,'2022-11-24 14:21:17','2022-11-24 14:21:17',NULL),(1890,NULL,40745,42010,2,1890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',800.00,NULL,NULL,1,'2022-11-24 14:21:17','2022-11-24 14:21:17',NULL),(1891,NULL,40745,42010,2,1891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',140.00,NULL,NULL,1,'2022-11-24 14:21:17','2022-11-24 14:21:17',NULL),(1892,NULL,40745,42010,2,1892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',560.00,NULL,NULL,1,'2022-11-24 14:21:17','2022-11-24 14:21:17',NULL),(1893,NULL,40745,42010,2,1893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',1600.00,NULL,NULL,1,'2022-11-24 14:21:17','2022-11-24 14:21:17',NULL),(1894,NULL,40745,42010,2,1894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',700.00,NULL,NULL,1,'2022-11-24 14:21:17','2022-11-24 14:21:17',NULL),(1895,NULL,40745,42010,2,1895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',200.00,NULL,NULL,1,'2022-11-24 14:21:17','2022-11-24 14:21:17',NULL),(1896,NULL,40745,42010,2,1896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',800.00,NULL,NULL,1,'2022-11-24 14:21:17','2022-11-24 14:21:17',NULL),(1897,NULL,40745,42010,2,1897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',1040.00,NULL,NULL,1,'2022-11-24 14:21:17','2022-11-24 14:21:17',NULL),(1898,NULL,40745,42010,2,1898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',200.00,NULL,NULL,1,'2022-11-24 14:21:17','2022-11-24 14:21:17',NULL),(1899,NULL,40745,42010,2,1899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',830.00,NULL,NULL,1,'2022-11-24 14:21:17','2022-11-24 14:21:17',NULL),(1900,NULL,40745,42010,2,1900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',200.00,NULL,NULL,1,'2022-11-24 14:21:18','2022-11-24 14:21:18',NULL),(1901,NULL,40745,42010,2,1901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',710.00,NULL,NULL,1,'2022-11-24 14:21:18','2022-11-24 14:21:18',NULL),(1902,NULL,40745,42010,2,1902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',280.00,NULL,NULL,1,'2022-11-24 14:21:18','2022-11-24 14:21:18',NULL),(1903,NULL,40745,42010,2,1903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',1880.00,NULL,NULL,1,'2022-11-24 14:21:18','2022-11-24 14:21:18',NULL),(1904,NULL,40745,42010,2,1904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',400.00,NULL,NULL,1,'2022-11-24 14:21:18','2022-11-24 14:21:18',NULL),(1905,NULL,40745,42010,2,1905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',2245.00,NULL,NULL,1,'2022-11-24 14:21:18','2022-11-24 14:21:18',NULL),(1906,NULL,40745,42010,2,1906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',1060.00,NULL,NULL,1,'2022-11-24 14:21:18','2022-11-24 14:21:18',NULL);
INSERT INTO `balance_libro` VALUES (1907,NULL,40745,42010,2,1907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',330.00,NULL,NULL,1,'2022-11-24 14:21:18','2022-11-24 14:21:18',NULL),(1908,NULL,40745,42010,2,1908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',740.00,NULL,NULL,1,'2022-11-24 14:21:18','2022-11-24 14:21:18',NULL),(1909,NULL,40745,42010,2,1909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',230.00,NULL,NULL,1,'2022-11-24 14:21:18','2022-11-24 14:21:18',NULL),(1910,NULL,40745,42010,2,1910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',1910.00,NULL,NULL,1,'2022-11-24 14:21:18','2022-11-24 14:21:18',NULL),(1911,NULL,40745,42010,2,1911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',530.00,NULL,NULL,1,'2022-11-24 14:21:18','2022-11-24 14:21:18',NULL),(1912,NULL,40745,42010,2,1912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',300.00,NULL,NULL,1,'2022-11-24 14:21:18','2022-11-24 14:21:18',NULL),(1913,NULL,40745,42010,2,1913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1459.00,NULL,NULL,1,'2022-11-24 14:21:18','2022-11-24 14:21:18',NULL),(1914,NULL,40745,42010,2,1914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',700.00,NULL,NULL,1,'2022-11-24 14:21:18','2022-11-24 14:21:18',NULL),(1915,NULL,40745,42010,2,1915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1230.00,NULL,NULL,1,'2022-11-24 14:21:18','2022-11-24 14:21:18',NULL),(1916,NULL,40745,42010,2,1916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',250.00,NULL,NULL,1,'2022-11-24 14:21:18','2022-11-24 14:21:18',NULL),(1917,NULL,40745,42010,2,1917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1350.00,NULL,NULL,1,'2022-11-24 14:21:18','2022-11-24 14:21:18',NULL),(1918,NULL,40745,42010,2,1918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1216.00,NULL,NULL,1,'2022-11-24 14:21:18','2022-11-24 14:21:18',NULL),(1919,NULL,40745,42010,2,1919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1710.00,NULL,NULL,1,'2022-11-24 14:21:18','2022-11-24 14:21:18',NULL),(1920,NULL,40745,42010,2,1920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',920.00,NULL,NULL,1,'2022-11-24 14:21:18','2022-11-24 14:21:18',NULL),(1921,NULL,40745,42010,2,1921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',490.00,NULL,NULL,1,'2022-11-24 14:21:18','2022-11-24 14:21:18',NULL),(1922,NULL,40745,42010,2,1922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',685.00,NULL,NULL,1,'2022-11-24 14:21:18','2022-11-24 14:21:18',NULL),(1923,NULL,40745,42010,2,1923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',260.00,NULL,NULL,1,'2022-11-24 14:21:18','2022-11-24 14:21:18',NULL),(1924,NULL,40745,42010,2,1924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1657.00,NULL,NULL,1,'2022-11-24 14:21:18','2022-11-24 14:21:18',NULL),(1925,NULL,40745,42010,2,1925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',220.00,NULL,NULL,1,'2022-11-24 14:21:18','2022-11-24 14:21:18',NULL),(1926,NULL,40745,42010,2,1926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',280.00,NULL,NULL,1,'2022-11-24 14:21:18','2022-11-24 14:21:18',NULL),(1927,NULL,40745,42010,2,1927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',800.00,NULL,NULL,1,'2022-11-24 14:21:18','2022-11-24 14:21:18',NULL),(1928,NULL,40745,42010,2,1928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',470.00,NULL,NULL,1,'2022-11-24 14:21:18','2022-11-24 14:21:18',NULL),(1929,NULL,40745,42010,2,1929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',250.00,NULL,NULL,1,'2022-11-24 14:21:18','2022-11-24 14:21:18',NULL),(1930,NULL,40745,42010,2,1930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1200.00,NULL,NULL,1,'2022-11-24 14:21:19','2022-11-24 14:21:19',NULL);
INSERT INTO `balance_libro` VALUES (1931,NULL,40745,42010,2,1931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',520.00,NULL,NULL,1,'2022-11-24 14:21:19','2022-11-24 14:21:19',NULL),(1932,NULL,40745,42010,2,1932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',810.00,NULL,NULL,1,'2022-11-24 14:21:19','2022-11-24 14:21:19',NULL),(1933,NULL,40745,42010,2,1933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1520.00,NULL,NULL,1,'2022-11-24 14:21:19','2022-11-24 14:21:19',NULL),(1934,NULL,40745,42010,2,1934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',800.00,NULL,NULL,1,'2022-11-24 14:21:19','2022-11-24 14:21:19',NULL),(1935,NULL,40745,42010,2,1935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',2341.00,NULL,NULL,1,'2022-11-24 14:21:19','2022-11-24 14:21:19',NULL),(1936,NULL,40745,42010,2,1936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',250.00,NULL,NULL,1,'2022-11-24 14:21:19','2022-11-24 14:21:19',NULL),(1937,NULL,40745,42010,2,1937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',180.00,NULL,NULL,1,'2022-11-24 14:21:19','2022-11-24 14:21:19',NULL),(1938,NULL,40745,42010,2,1938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',850.00,NULL,NULL,1,'2022-11-24 14:21:19','2022-11-24 14:21:19',NULL),(1939,NULL,40745,42010,2,1939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',680.00,NULL,NULL,1,'2022-11-24 14:21:19','2022-11-24 14:21:19',NULL),(1940,NULL,40745,42010,2,1940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',510.00,NULL,NULL,1,'2022-11-24 14:21:19','2022-11-24 14:21:19',NULL),(1941,NULL,40745,42010,2,1941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',340.00,NULL,NULL,1,'2022-11-24 14:21:19','2022-11-24 14:21:19',NULL),(1942,NULL,40745,42010,2,1942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',240.00,NULL,NULL,1,'2022-11-24 14:21:19','2022-11-24 14:21:19',NULL),(1943,NULL,40745,42010,2,1943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',840.00,NULL,NULL,1,'2022-11-24 14:21:19','2022-11-24 14:21:19',NULL),(1944,NULL,40745,42010,2,1944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',1000.00,NULL,NULL,1,'2022-11-24 14:21:19','2022-11-24 14:21:19',NULL),(1945,NULL,40745,42010,2,1945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',210.00,NULL,NULL,1,'2022-11-24 14:21:19','2022-11-24 14:21:19',NULL),(1946,NULL,40745,42010,2,1946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',630.00,NULL,NULL,1,'2022-11-24 14:21:19','2022-11-24 14:21:19',NULL),(1947,NULL,40745,42010,2,1947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',605.00,NULL,NULL,1,'2022-11-24 14:21:19','2022-11-24 14:21:19',NULL),(1948,NULL,40745,42010,2,1948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',290.00,NULL,NULL,1,'2022-11-24 14:21:19','2022-11-24 14:21:19',NULL),(1949,NULL,40745,42010,2,1949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',740.00,NULL,NULL,1,'2022-11-24 14:21:19','2022-11-24 14:21:19',NULL),(1950,NULL,40745,42010,2,1950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',1230.00,NULL,NULL,1,'2022-11-24 14:21:19','2022-11-24 14:21:19',NULL),(1951,NULL,40745,42010,2,1951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',1617.00,NULL,NULL,1,'2022-11-24 14:21:19','2022-11-24 14:21:19',NULL),(1952,NULL,40745,42010,2,1952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',1270.00,NULL,NULL,1,'2022-11-24 14:21:19','2022-11-24 14:21:19',NULL),(1953,NULL,40745,42010,2,1953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',600.00,NULL,NULL,1,'2022-11-24 14:21:19','2022-11-24 14:21:19',NULL),(1954,NULL,40745,42010,2,1954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',240.00,NULL,NULL,1,'2022-11-24 14:21:19','2022-11-24 14:21:19',NULL);
INSERT INTO `balance_libro` VALUES (1955,NULL,40745,42010,2,1955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',2410.00,NULL,NULL,1,'2022-11-24 14:21:19','2022-11-24 14:21:19',NULL),(1956,NULL,40745,42010,2,1956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1910.00,NULL,NULL,1,'2022-11-24 14:21:20','2022-11-24 14:21:20',NULL),(1957,NULL,40745,42010,2,1957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',820.00,NULL,NULL,1,'2022-11-24 14:21:20','2022-11-24 14:21:20',NULL),(1958,NULL,40745,42010,2,1958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1606.00,NULL,NULL,1,'2022-11-24 14:21:20','2022-11-24 14:21:20',NULL),(1959,NULL,40745,42010,2,1959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',900.00,NULL,NULL,1,'2022-11-24 14:21:20','2022-11-24 14:21:20',NULL),(1960,NULL,40745,42010,2,1960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1580.00,NULL,NULL,1,'2022-11-24 14:21:20','2022-11-24 14:21:20',NULL),(1961,NULL,40745,42010,2,1961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1380.00,NULL,NULL,1,'2022-11-24 14:21:20','2022-11-24 14:21:20',NULL),(1962,NULL,40745,42010,2,1962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',720.00,NULL,NULL,1,'2022-11-24 14:21:20','2022-11-24 14:21:20',NULL),(1963,NULL,40745,42010,2,1963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',340.00,NULL,NULL,1,'2022-11-24 14:21:20','2022-11-24 14:21:20',NULL),(1964,NULL,40745,42010,2,1964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',900.00,NULL,NULL,1,'2022-11-24 14:21:20','2022-11-24 14:21:20',NULL),(1965,NULL,40745,42010,2,1965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',2170.00,NULL,NULL,1,'2022-11-24 14:21:20','2022-11-24 14:21:20',NULL),(1966,NULL,40745,42010,2,1966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1230.00,NULL,NULL,1,'2022-11-24 14:21:20','2022-11-24 14:21:20',NULL),(1967,NULL,40745,42010,2,1967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1230.00,NULL,NULL,1,'2022-11-24 14:21:20','2022-11-24 14:21:20',NULL),(1968,NULL,40745,42010,2,1968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',540.00,NULL,NULL,1,'2022-11-24 14:21:20','2022-11-24 14:21:20',NULL),(1969,NULL,40745,42010,2,1969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',495.00,NULL,NULL,1,'2022-11-24 14:21:20','2022-11-24 14:21:20',NULL),(1970,NULL,40745,42010,2,1970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',340.00,NULL,NULL,1,'2022-11-24 14:21:20','2022-11-24 14:21:20',NULL),(1971,NULL,40745,42010,2,1971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',770.00,NULL,NULL,1,'2022-11-24 14:21:20','2022-11-24 14:21:20',NULL),(1972,NULL,40745,42010,2,1972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',850.00,NULL,NULL,1,'2022-11-24 14:21:20','2022-11-24 14:21:20',NULL),(1973,NULL,40745,42010,2,1973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',380.00,NULL,NULL,1,'2022-11-24 14:21:20','2022-11-24 14:21:20',NULL),(1974,NULL,40745,42010,2,1974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',270.00,NULL,NULL,1,'2022-11-24 14:21:20','2022-11-24 14:21:20',NULL),(1975,NULL,40745,42010,2,1975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',180.00,NULL,NULL,1,'2022-11-24 14:21:20','2022-11-24 14:21:20',NULL),(1976,NULL,40745,42010,2,1976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',5245.00,NULL,NULL,1,'2022-11-24 14:21:20','2022-11-24 14:21:20',NULL),(1977,NULL,40745,42010,2,1977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',800.00,NULL,NULL,1,'2022-11-24 14:21:20','2022-11-24 14:21:20',NULL),(1978,NULL,40745,42010,2,1978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',485.00,NULL,NULL,1,'2022-11-24 14:21:20','2022-11-24 14:21:20',NULL);
INSERT INTO `balance_libro` VALUES (1979,NULL,40745,42010,2,1979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1555.00,NULL,NULL,1,'2022-11-24 14:21:20','2022-11-24 14:21:20',NULL),(1980,NULL,40745,42010,2,1980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',380.00,NULL,NULL,1,'2022-11-24 14:21:20','2022-11-24 14:21:20',NULL),(1981,NULL,40745,42010,2,1981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',890.00,NULL,NULL,1,'2022-11-24 14:21:20','2022-11-24 14:21:20',NULL),(1982,NULL,40745,42010,2,1982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',3210.00,NULL,NULL,1,'2022-11-24 14:21:20','2022-11-24 14:21:20',NULL),(1983,NULL,40745,42010,2,1983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',200.00,NULL,NULL,1,'2022-11-24 14:21:20','2022-11-24 14:21:20',NULL),(1984,NULL,40745,42010,2,1984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',740.00,NULL,NULL,1,'2022-11-24 14:21:20','2022-11-24 14:21:20',NULL),(1985,NULL,40745,42010,2,1985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1730.00,NULL,NULL,1,'2022-11-24 14:21:20','2022-11-24 14:21:20',NULL),(1986,NULL,40745,42010,2,1986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1100.00,NULL,NULL,1,'2022-11-24 14:21:21','2022-11-24 14:21:21',NULL),(1987,NULL,40745,42010,2,1987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',245.00,NULL,NULL,1,'2022-11-24 14:21:21','2022-11-24 14:21:21',NULL),(1988,NULL,40745,42010,2,1988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',650.00,NULL,NULL,1,'2022-11-24 14:21:21','2022-11-24 14:21:21',NULL),(1989,NULL,40745,42010,2,1989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',700.00,NULL,NULL,1,'2022-11-24 14:21:21','2022-11-24 14:21:21',NULL),(1990,NULL,40745,42010,2,1990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1200.00,NULL,NULL,1,'2022-11-24 14:21:21','2022-11-24 14:21:21',NULL),(1991,NULL,40745,42010,2,1991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',2000.00,NULL,NULL,1,'2022-11-24 14:21:21','2022-11-24 14:21:21',NULL),(1992,NULL,40745,42010,2,1992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',630.00,NULL,NULL,1,'2022-11-24 14:21:21','2022-11-24 14:21:21',NULL),(1993,NULL,40745,42010,2,1993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',330.00,NULL,NULL,1,'2022-11-24 14:21:21','2022-11-24 14:21:21',NULL),(1994,NULL,40745,42010,2,1994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',700.00,NULL,NULL,1,'2022-11-24 14:21:21','2022-11-24 14:21:21',NULL),(1995,NULL,40745,42010,2,1995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1095.00,NULL,NULL,1,'2022-11-24 14:21:21','2022-11-24 14:21:21',NULL),(1996,NULL,40745,42010,2,1996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1340.00,NULL,NULL,1,'2022-11-24 14:21:21','2022-11-24 14:21:21',NULL),(1997,NULL,40745,42010,2,1997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1400.00,NULL,NULL,1,'2022-11-24 14:21:21','2022-11-24 14:21:21',NULL),(1998,NULL,40745,42010,2,1998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',680.00,NULL,NULL,1,'2022-11-24 14:21:21','2022-11-24 14:21:21',NULL),(1999,NULL,40745,42010,2,1999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',425.00,NULL,NULL,1,'2022-11-24 14:21:21','2022-11-24 14:21:21',NULL),(2000,NULL,40745,42010,2,2000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',910.00,NULL,NULL,1,'2022-11-24 14:21:21','2022-11-24 14:21:21',NULL),(2001,NULL,40745,42010,2,2001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1085.00,NULL,NULL,1,'2022-11-24 14:21:21','2022-11-24 14:21:21',NULL),(2002,NULL,40745,42010,2,2002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',700.00,NULL,NULL,1,'2022-11-24 14:21:21','2022-11-24 14:21:21',NULL);
INSERT INTO `balance_libro` VALUES (2003,NULL,40745,42010,2,2003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',750.00,NULL,NULL,1,'2022-11-24 14:21:21','2022-11-24 14:21:21',NULL),(2004,NULL,40745,42010,2,2004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',800.00,NULL,NULL,1,'2022-11-24 14:21:21','2022-11-24 14:21:21',NULL),(2005,NULL,40745,42010,2,2005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',890.00,NULL,NULL,1,'2022-11-24 14:21:21','2022-11-24 14:21:21',NULL),(2006,NULL,40745,42010,2,2006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1715.00,NULL,NULL,1,'2022-11-24 14:21:21','2022-11-24 14:21:21',NULL),(2007,NULL,40745,42010,2,2007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1460.00,NULL,NULL,1,'2022-11-24 14:21:21','2022-11-24 14:21:21',NULL),(2008,NULL,40745,42010,2,2008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',5450.00,NULL,NULL,1,'2022-11-24 14:21:21','2022-11-24 14:21:21',NULL),(2009,NULL,40745,42010,2,2009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1000.00,NULL,NULL,1,'2022-11-24 14:21:21','2022-11-24 14:21:21',NULL),(2010,NULL,40745,42010,2,2010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',2280.00,NULL,NULL,1,'2022-11-24 14:21:21','2022-11-24 14:21:21',NULL),(2011,NULL,40745,42010,2,2011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1190.00,NULL,NULL,1,'2022-11-24 14:21:21','2022-11-24 14:21:21',NULL),(2012,NULL,40745,42010,2,2012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1525.00,NULL,NULL,1,'2022-11-24 14:21:21','2022-11-24 14:21:21',NULL),(2013,NULL,40745,42010,2,2013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',670.00,NULL,NULL,1,'2022-11-24 14:21:21','2022-11-24 14:21:21',NULL),(2014,NULL,40745,42010,2,2014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',3585.00,NULL,NULL,1,'2022-11-24 14:21:21','2022-11-24 14:21:21',NULL),(2015,NULL,40745,42010,2,2015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',150.00,NULL,NULL,1,'2022-11-24 14:21:22','2022-11-24 14:21:22',NULL),(2016,NULL,40745,42010,2,2016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',530.00,NULL,NULL,1,'2022-11-24 14:21:22','2022-11-24 14:21:22',NULL),(2017,NULL,40745,42010,2,2017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',570.00,NULL,NULL,1,'2022-11-24 14:21:22','2022-11-24 14:21:22',NULL),(2018,NULL,40745,42010,2,2018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',390.00,NULL,NULL,1,'2022-11-24 14:21:22','2022-11-24 14:21:22',NULL),(2019,NULL,40745,42010,2,2019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',300.00,NULL,NULL,1,'2022-11-24 14:21:22','2022-11-24 14:21:22',NULL),(2020,NULL,40745,42010,2,2020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',2170.00,NULL,NULL,1,'2022-11-24 14:21:22','2022-11-24 14:21:22',NULL),(2021,NULL,40745,42010,2,2021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1250.00,NULL,NULL,1,'2022-11-24 14:21:22','2022-11-24 14:21:22',NULL),(2022,NULL,40745,42010,2,2022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',6820.00,NULL,NULL,1,'2022-11-24 14:21:22','2022-11-24 14:21:22',NULL),(2023,NULL,40745,42010,2,2023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',750.00,NULL,NULL,1,'2022-11-24 14:21:22','2022-11-24 14:21:22',NULL),(2024,NULL,40745,42010,2,2024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',785.00,NULL,NULL,1,'2022-11-24 14:21:22','2022-11-24 14:21:22',NULL),(2025,NULL,40745,42010,2,2025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',520.00,NULL,NULL,1,'2022-11-24 14:21:22','2022-11-24 14:21:22',NULL),(2026,NULL,40745,42010,2,2026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',460.00,NULL,NULL,1,'2022-11-24 14:21:22','2022-11-24 14:21:22',NULL);
INSERT INTO `balance_libro` VALUES (2027,NULL,40745,42010,2,2027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',280.00,NULL,NULL,1,'2022-11-24 14:21:22','2022-11-24 14:21:22',NULL),(2028,NULL,40745,42010,2,2028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1030.00,NULL,NULL,1,'2022-11-24 14:21:22','2022-11-24 14:21:22',NULL),(2029,NULL,40745,42010,2,2029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',2820.00,NULL,NULL,1,'2022-11-24 14:21:22','2022-11-24 14:21:22',NULL),(2030,NULL,40745,42010,2,2030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1310.00,NULL,NULL,1,'2022-11-24 14:21:22','2022-11-24 14:21:22',NULL),(2031,NULL,40745,42010,2,2031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',960.00,NULL,NULL,1,'2022-11-24 14:21:22','2022-11-24 14:21:22',NULL),(2032,NULL,40745,42010,2,2032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',3775.00,NULL,NULL,1,'2022-11-24 14:21:22','2022-11-24 14:21:22',NULL),(2033,NULL,40745,42010,2,2033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',2300.00,NULL,NULL,1,'2022-11-24 14:21:22','2022-11-24 14:21:22',NULL),(2034,NULL,40745,42010,2,2034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1530.00,NULL,NULL,1,'2022-11-24 14:21:22','2022-11-24 14:21:22',NULL),(2035,NULL,40745,42010,2,2035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1880.00,NULL,NULL,1,'2022-11-24 14:21:22','2022-11-24 14:21:22',NULL),(2036,NULL,40745,42010,2,2036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',480.00,NULL,NULL,1,'2022-11-24 14:21:22','2022-11-24 14:21:22',NULL),(2037,NULL,40745,42010,2,2037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',980.00,NULL,NULL,1,'2022-11-24 14:21:22','2022-11-24 14:21:22',NULL),(2038,NULL,40745,42010,2,2038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',680.00,NULL,NULL,1,'2022-11-24 14:21:22','2022-11-24 14:21:22',NULL),(2039,NULL,40745,42010,2,2039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1120.00,NULL,NULL,1,'2022-11-24 14:21:22','2022-11-24 14:21:22',NULL),(2040,NULL,40745,42010,2,2040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1100.00,NULL,NULL,1,'2022-11-24 14:21:22','2022-11-24 14:21:22',NULL),(2041,NULL,40745,42010,2,2041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',330.00,NULL,NULL,1,'2022-11-24 14:21:22','2022-11-24 14:21:22',NULL),(2042,NULL,40745,42010,2,2042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',340.00,NULL,NULL,1,'2022-11-24 14:21:22','2022-11-24 14:21:22',NULL),(2043,NULL,40745,42010,2,2043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',4660.00,NULL,NULL,1,'2022-11-24 14:21:22','2022-11-24 14:21:22',NULL),(2044,NULL,40745,42010,2,2044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',610.00,NULL,NULL,1,'2022-11-24 14:21:22','2022-11-24 14:21:22',NULL),(2045,NULL,40745,42010,2,2045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1740.00,NULL,NULL,1,'2022-11-24 14:21:23','2022-11-24 14:21:23',NULL),(2046,NULL,40745,42010,2,2046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',195.00,NULL,NULL,1,'2022-11-24 14:21:23','2022-11-24 14:21:23',NULL),(2047,NULL,40745,42010,2,2047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',2140.00,NULL,NULL,1,'2022-11-24 14:21:23','2022-11-24 14:21:23',NULL),(2048,NULL,40745,42010,2,2048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',510.00,NULL,NULL,1,'2022-11-24 14:21:23','2022-11-24 14:21:23',NULL),(2049,NULL,40745,42010,2,2049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',500.00,NULL,NULL,1,'2022-11-24 14:21:23','2022-11-24 14:21:23',NULL),(2050,NULL,40745,42010,2,2050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1160.00,NULL,NULL,1,'2022-11-24 14:21:23','2022-11-24 14:21:23',NULL);
INSERT INTO `balance_libro` VALUES (2051,NULL,40745,42010,2,2051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1200.00,NULL,NULL,1,'2022-11-24 14:21:23','2022-11-24 14:21:23',NULL),(2052,NULL,40745,42010,2,2052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',460.00,NULL,NULL,1,'2022-11-24 14:21:23','2022-11-24 14:21:23',NULL),(2053,NULL,40745,42010,2,2053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',410.00,NULL,NULL,1,'2022-11-24 14:21:23','2022-11-24 14:21:23',NULL),(2054,NULL,40745,42010,2,2054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',395.00,NULL,NULL,1,'2022-11-24 14:21:23','2022-11-24 14:21:23',NULL),(2055,NULL,40745,42010,2,2055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',990.00,NULL,NULL,1,'2022-11-24 14:21:23','2022-11-24 14:21:23',NULL),(2056,NULL,40745,42010,2,2056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',165.00,NULL,NULL,1,'2022-11-24 14:21:23','2022-11-24 14:21:23',NULL),(2057,NULL,40745,42010,2,2057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1205.00,NULL,NULL,1,'2022-11-24 14:21:23','2022-11-24 14:21:23',NULL),(2058,NULL,40745,42010,2,2058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',370.00,NULL,NULL,1,'2022-11-24 14:21:23','2022-11-24 14:21:23',NULL),(2059,NULL,40745,42010,2,2059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',300.00,NULL,NULL,1,'2022-11-24 14:21:23','2022-11-24 14:21:23',NULL),(2060,NULL,40745,42010,2,2060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',400.00,NULL,NULL,1,'2022-11-24 14:21:23','2022-11-24 14:21:23',NULL),(2061,NULL,40745,42010,2,2061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',650.00,NULL,NULL,1,'2022-11-24 14:21:23','2022-11-24 14:21:23',NULL),(2062,NULL,40745,42010,2,2062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',590.00,NULL,NULL,1,'2022-11-24 14:21:23','2022-11-24 14:21:23',NULL),(2063,NULL,40745,42010,2,2063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',170.00,NULL,NULL,1,'2022-11-24 14:21:23','2022-11-24 14:21:23',NULL),(2064,NULL,40745,42010,2,2064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',455.00,NULL,NULL,1,'2022-11-24 14:21:23','2022-11-24 14:21:23',NULL),(2065,NULL,40745,42010,2,2065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',455.00,NULL,NULL,1,'2022-11-24 14:21:23','2022-11-24 14:21:23',NULL),(2066,NULL,40745,42010,2,2066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',570.00,NULL,NULL,1,'2022-11-24 14:21:23','2022-11-24 14:21:23',NULL),(2067,NULL,40745,42010,2,2067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1300.00,NULL,NULL,1,'2022-11-24 14:21:23','2022-11-24 14:21:23',NULL),(2068,NULL,40745,42010,2,2068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',250.00,NULL,NULL,1,'2022-11-24 14:21:23','2022-11-24 14:21:23',NULL),(2069,NULL,40745,42010,2,2069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',640.00,NULL,NULL,1,'2022-11-24 14:21:23','2022-11-24 14:21:23',NULL),(2070,NULL,40745,42010,2,2070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',600.00,NULL,NULL,1,'2022-11-24 14:21:23','2022-11-24 14:21:23',NULL),(2071,NULL,40745,42010,2,2071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',472.00,NULL,NULL,1,'2022-11-24 14:21:23','2022-11-24 14:21:23',NULL),(2072,NULL,40745,42010,2,2072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',380.00,NULL,NULL,1,'2022-11-24 14:21:23','2022-11-24 14:21:23',NULL),(2073,NULL,40745,42010,2,2073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',300.00,NULL,NULL,1,'2022-11-24 14:21:23','2022-11-24 14:21:23',NULL),(2074,NULL,40745,42010,2,2074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',830.00,NULL,NULL,1,'2022-11-24 14:21:23','2022-11-24 14:21:23',NULL);
INSERT INTO `balance_libro` VALUES (2075,NULL,40745,42010,2,2075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1500.00,NULL,NULL,1,'2022-11-24 14:21:23','2022-11-24 14:21:23',NULL),(2076,NULL,40745,42010,2,2076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1380.00,NULL,NULL,1,'2022-11-24 14:21:24','2022-11-24 14:21:24',NULL),(2077,NULL,40745,42010,2,2077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1530.00,NULL,NULL,1,'2022-11-24 14:21:24','2022-11-24 14:21:24',NULL),(2078,NULL,40745,42010,2,2078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',2440.00,NULL,NULL,1,'2022-11-24 14:21:24','2022-11-24 14:21:24',NULL),(2079,NULL,40745,42010,2,2079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',500.00,NULL,NULL,1,'2022-11-24 14:21:24','2022-11-24 14:21:24',NULL),(2080,NULL,40745,42010,2,2080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',480.00,NULL,NULL,1,'2022-11-24 14:21:24','2022-11-24 14:21:24',NULL),(2081,NULL,40745,42010,2,2081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1550.00,NULL,NULL,1,'2022-11-24 14:21:24','2022-11-24 14:21:24',NULL),(2082,NULL,40745,42010,2,2082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',380.00,NULL,NULL,1,'2022-11-24 14:21:24','2022-11-24 14:21:24',NULL),(2083,NULL,40745,42010,2,2083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1840.00,NULL,NULL,1,'2022-11-24 14:21:24','2022-11-24 14:21:24',NULL),(2084,NULL,40745,42010,2,2084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1600.00,NULL,NULL,1,'2022-11-24 14:21:24','2022-11-24 14:21:24',NULL),(2085,NULL,40745,42010,2,2085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',840.00,NULL,NULL,1,'2022-11-24 14:21:24','2022-11-24 14:21:24',NULL),(2086,NULL,40745,42010,2,2086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',2940.00,NULL,NULL,1,'2022-11-24 14:21:24','2022-11-24 14:21:24',NULL),(2087,NULL,40745,42010,2,2087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',450.00,NULL,NULL,1,'2022-11-24 14:21:24','2022-11-24 14:21:24',NULL),(2088,NULL,40745,42010,2,2088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1100.00,NULL,NULL,1,'2022-11-24 14:21:24','2022-11-24 14:21:24',NULL),(2089,NULL,40745,42010,2,2089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1670.00,NULL,NULL,1,'2022-11-24 14:21:24','2022-11-24 14:21:24',NULL),(2090,NULL,40745,42010,2,2090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',3660.00,NULL,NULL,1,'2022-11-24 14:21:24','2022-11-24 14:21:24',NULL),(2091,NULL,40745,42010,2,2091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',2975.00,NULL,NULL,1,'2022-11-24 14:21:24','2022-11-24 14:21:24',NULL),(2092,NULL,40745,42010,2,2092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',600.00,NULL,NULL,1,'2022-11-24 14:21:24','2022-11-24 14:21:24',NULL),(2093,NULL,40745,42010,2,2093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',780.00,NULL,NULL,1,'2022-11-24 14:21:24','2022-11-24 14:21:24',NULL),(2094,NULL,40745,42010,2,2094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',2130.00,NULL,NULL,1,'2022-11-24 14:21:24','2022-11-24 14:21:24',NULL),(2095,NULL,40745,42010,2,2095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',300.00,NULL,NULL,1,'2022-11-24 14:21:24','2022-11-24 14:21:24',NULL),(2096,NULL,40745,42010,2,2096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',395.00,NULL,NULL,1,'2022-11-24 14:21:24','2022-11-24 14:21:24',NULL),(2097,NULL,40745,42010,2,2097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1680.00,NULL,NULL,1,'2022-11-24 14:21:24','2022-11-24 14:21:24',NULL),(2098,NULL,40745,42010,2,2098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',420.00,NULL,NULL,1,'2022-11-24 14:21:24','2022-11-24 14:21:24',NULL);
INSERT INTO `balance_libro` VALUES (2099,NULL,40745,42010,2,2099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',630.00,NULL,NULL,1,'2022-11-24 14:21:24','2022-11-24 14:21:24',NULL),(2100,NULL,40745,42010,2,2100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',2015.00,NULL,NULL,1,'2022-11-24 14:21:24','2022-11-24 14:21:24',NULL),(2101,NULL,40745,42010,2,2101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',790.00,NULL,NULL,1,'2022-11-24 14:21:24','2022-11-24 14:21:24',NULL),(2102,NULL,40745,42010,2,2102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',2390.00,NULL,NULL,1,'2022-11-24 14:21:24','2022-11-24 14:21:24',NULL),(2103,NULL,40745,42010,2,2103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1750.00,NULL,NULL,1,'2022-11-24 14:21:24','2022-11-24 14:21:24',NULL),(2104,NULL,40745,42010,2,2104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',500.00,NULL,NULL,1,'2022-11-24 14:21:24','2022-11-24 14:21:24',NULL),(2105,NULL,40745,42010,2,2105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1380.00,NULL,NULL,1,'2022-11-24 14:21:24','2022-11-24 14:21:24',NULL),(2106,NULL,40745,42010,2,2106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1525.00,NULL,NULL,1,'2022-11-24 14:21:24','2022-11-24 14:21:24',NULL),(2107,NULL,40745,42010,2,2107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1100.00,NULL,NULL,1,'2022-11-24 14:21:24','2022-11-24 14:21:24',NULL),(2108,NULL,40745,42010,2,2108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',520.00,NULL,NULL,1,'2022-11-24 14:21:25','2022-11-24 14:21:25',NULL),(2109,NULL,40745,42010,2,2109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2140.00,NULL,NULL,1,'2022-11-24 14:21:25','2022-11-24 14:21:25',NULL),(2110,NULL,40745,42010,2,2110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2360.00,NULL,NULL,1,'2022-11-24 14:21:25','2022-11-24 14:21:25',NULL),(2111,NULL,40745,42010,2,2111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',860.00,NULL,NULL,1,'2022-11-24 14:21:25','2022-11-24 14:21:25',NULL),(2112,NULL,40745,42010,2,2112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',610.00,NULL,NULL,1,'2022-11-24 14:21:25','2022-11-24 14:21:25',NULL),(2113,NULL,40745,42010,2,2113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',850.00,NULL,NULL,1,'2022-11-24 14:21:25','2022-11-24 14:21:25',NULL),(2114,NULL,40745,42010,2,2114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1530.00,NULL,NULL,1,'2022-11-24 14:21:25','2022-11-24 14:21:25',NULL),(2115,NULL,40745,42010,2,2115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',300.00,NULL,NULL,1,'2022-11-24 14:21:25','2022-11-24 14:21:25',NULL),(2116,NULL,40745,42010,2,2116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2168.00,NULL,NULL,1,'2022-11-24 14:21:25','2022-11-24 14:21:25',NULL),(2117,NULL,40745,42010,2,2117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2370.00,NULL,NULL,1,'2022-11-24 14:21:25','2022-11-24 14:21:25',NULL),(2118,NULL,40745,42010,2,2118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',430.00,NULL,NULL,1,'2022-11-24 14:21:25','2022-11-24 14:21:25',NULL),(2119,NULL,40745,42010,2,2119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',910.00,NULL,NULL,1,'2022-11-24 14:21:25','2022-11-24 14:21:25',NULL),(2120,NULL,40745,42010,2,2120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1490.00,NULL,NULL,1,'2022-11-24 14:21:25','2022-11-24 14:21:25',NULL),(2121,NULL,40745,42010,2,2121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',3340.00,NULL,NULL,1,'2022-11-24 14:21:25','2022-11-24 14:21:25',NULL),(2122,NULL,40745,42010,2,2122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1090.00,NULL,NULL,1,'2022-11-24 14:21:25','2022-11-24 14:21:25',NULL);
INSERT INTO `balance_libro` VALUES (2123,NULL,40745,42010,2,2123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2160.00,NULL,NULL,1,'2022-11-24 14:21:25','2022-11-24 14:21:25',NULL),(2124,NULL,40745,42010,2,2124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1760.00,NULL,NULL,1,'2022-11-24 14:21:25','2022-11-24 14:21:25',NULL),(2125,NULL,40745,42010,2,2125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',6000.00,NULL,NULL,1,'2022-11-24 14:21:25','2022-11-24 14:21:25',NULL),(2126,NULL,40745,42010,2,2126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1650.00,NULL,NULL,1,'2022-11-24 14:21:25','2022-11-24 14:21:25',NULL),(2127,NULL,40745,42010,2,2127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',580.00,NULL,NULL,1,'2022-11-24 14:21:25','2022-11-24 14:21:25',NULL),(2128,NULL,40745,42010,2,2128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',530.00,NULL,NULL,1,'2022-11-24 14:21:25','2022-11-24 14:21:25',NULL),(2129,NULL,40745,42010,2,2129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',810.00,NULL,NULL,1,'2022-11-24 14:21:25','2022-11-24 14:21:25',NULL),(2130,NULL,40745,42010,2,2130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1390.00,NULL,NULL,1,'2022-11-24 14:21:25','2022-11-24 14:21:25',NULL),(2131,NULL,40745,42010,2,2131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1770.00,NULL,NULL,1,'2022-11-24 14:21:25','2022-11-24 14:21:25',NULL),(2132,NULL,40745,42010,2,2132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',180.00,NULL,NULL,1,'2022-11-24 14:21:25','2022-11-24 14:21:25',NULL),(2133,NULL,40745,42010,2,2133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',3800.00,NULL,NULL,1,'2022-11-24 14:21:25','2022-11-24 14:21:25',NULL),(2134,NULL,40745,42010,2,2134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',210.00,NULL,NULL,1,'2022-11-24 14:21:25','2022-11-24 14:21:25',NULL),(2135,NULL,40745,42010,2,2135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',740.00,NULL,NULL,1,'2022-11-24 14:21:25','2022-11-24 14:21:25',NULL),(2136,NULL,40745,42010,2,2136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1660.00,NULL,NULL,1,'2022-11-24 14:21:25','2022-11-24 14:21:25',NULL),(2137,NULL,40745,42010,2,2137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',960.00,NULL,NULL,1,'2022-11-24 14:21:25','2022-11-24 14:21:25',NULL),(2138,NULL,40745,42010,2,2138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1270.00,NULL,NULL,1,'2022-11-24 14:21:26','2022-11-24 14:21:26',NULL),(2139,NULL,40745,42010,2,2139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2440.00,NULL,NULL,1,'2022-11-24 14:21:26','2022-11-24 14:21:26',NULL),(2140,NULL,40745,42010,2,2140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1150.00,NULL,NULL,1,'2022-11-24 14:21:26','2022-11-24 14:21:26',NULL),(2141,NULL,40745,42010,2,2141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',915.00,NULL,NULL,1,'2022-11-24 14:21:26','2022-11-24 14:21:26',NULL),(2142,NULL,40745,42010,2,2142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',615.00,NULL,NULL,1,'2022-11-24 14:21:26','2022-11-24 14:21:26',NULL),(2143,NULL,40745,42010,2,2143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',3700.00,NULL,NULL,1,'2022-11-24 14:21:26','2022-11-24 14:21:26',NULL),(2144,NULL,40745,42010,2,2144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',320.00,NULL,NULL,1,'2022-11-24 14:21:26','2022-11-24 14:21:26',NULL),(2145,NULL,40745,42010,2,2145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',240.00,NULL,NULL,1,'2022-11-24 14:21:26','2022-11-24 14:21:26',NULL),(2146,NULL,40745,42010,2,2146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1310.00,NULL,NULL,1,'2022-11-24 14:21:26','2022-11-24 14:21:26',NULL);
INSERT INTO `balance_libro` VALUES (2147,NULL,40745,42010,2,2147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',560.00,NULL,NULL,1,'2022-11-24 14:21:26','2022-11-24 14:21:26',NULL),(2148,NULL,40745,42010,2,2148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2105.00,NULL,NULL,1,'2022-11-24 14:21:26','2022-11-24 14:21:26',NULL),(2149,NULL,40745,42010,2,2149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2710.00,NULL,NULL,1,'2022-11-24 14:21:26','2022-11-24 14:21:26',NULL),(2150,NULL,40745,42010,2,2150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',500.00,NULL,NULL,1,'2022-11-24 14:21:26','2022-11-24 14:21:26',NULL),(2151,NULL,40745,42010,2,2151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',810.00,NULL,NULL,1,'2022-11-24 14:21:26','2022-11-24 14:21:26',NULL),(2152,NULL,40745,42010,2,2152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1823.00,NULL,NULL,1,'2022-11-24 14:21:26','2022-11-24 14:21:26',NULL),(2153,NULL,40745,42010,2,2153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',250.00,NULL,NULL,1,'2022-11-24 14:21:26','2022-11-24 14:21:26',NULL),(2154,NULL,40745,42010,2,2154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',980.00,NULL,NULL,1,'2022-11-24 14:21:26','2022-11-24 14:21:26',NULL),(2155,NULL,40745,42010,2,2155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',710.00,NULL,NULL,1,'2022-11-24 14:21:26','2022-11-24 14:21:26',NULL),(2156,NULL,40745,42010,2,2156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1600.00,NULL,NULL,1,'2022-11-24 14:21:26','2022-11-24 14:21:26',NULL),(2157,NULL,40745,42010,2,2157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2310.00,NULL,NULL,1,'2022-11-24 14:21:26','2022-11-24 14:21:26',NULL),(2158,NULL,40745,42010,2,2158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',9870.00,NULL,NULL,1,'2022-11-24 14:21:26','2022-11-24 14:21:26',NULL),(2159,NULL,40745,42010,2,2159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',660.00,NULL,NULL,1,'2022-11-24 14:21:26','2022-11-24 14:21:26',NULL),(2160,NULL,40745,42010,2,2160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',975.00,NULL,NULL,1,'2022-11-24 14:21:26','2022-11-24 14:21:26',NULL),(2161,NULL,40745,42010,2,2161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',650.00,NULL,NULL,1,'2022-11-24 14:21:26','2022-11-24 14:21:26',NULL),(2162,NULL,40745,42010,2,2162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1665.00,NULL,NULL,1,'2022-11-24 14:21:26','2022-11-24 14:21:26',NULL),(2163,NULL,40745,42010,2,2163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',290.00,NULL,NULL,1,'2022-11-24 14:21:26','2022-11-24 14:21:26',NULL),(2164,NULL,40745,42010,2,2164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',200.00,NULL,NULL,1,'2022-11-24 14:21:26','2022-11-24 14:21:26',NULL),(2165,NULL,40745,42010,2,2165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',850.00,NULL,NULL,1,'2022-11-24 14:21:26','2022-11-24 14:21:26',NULL),(2166,NULL,40745,42010,2,2166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',3170.00,NULL,NULL,1,'2022-11-24 14:21:26','2022-11-24 14:21:26',NULL),(2167,NULL,40745,42010,2,2167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1075.00,NULL,NULL,1,'2022-11-24 14:21:26','2022-11-24 14:21:26',NULL),(2168,NULL,40745,42010,2,2168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',785.00,NULL,NULL,1,'2022-11-24 14:21:27','2022-11-24 14:21:27',NULL),(2169,NULL,40745,42010,2,2169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',680.00,NULL,NULL,1,'2022-11-24 14:21:27','2022-11-24 14:21:27',NULL),(2170,NULL,40745,42010,2,2170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',600.00,NULL,NULL,1,'2022-11-24 14:21:27','2022-11-24 14:21:27',NULL);
INSERT INTO `balance_libro` VALUES (2171,NULL,40745,42010,2,2171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1410.00,NULL,NULL,1,'2022-11-24 14:21:27','2022-11-24 14:21:27',NULL),(2172,NULL,40745,42010,2,2172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2140.00,NULL,NULL,1,'2022-11-24 14:21:27','2022-11-24 14:21:27',NULL),(2173,NULL,40745,42010,2,2173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',550.00,NULL,NULL,1,'2022-11-24 14:21:27','2022-11-24 14:21:27',NULL),(2174,NULL,40745,42010,2,2174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',100.00,NULL,NULL,1,'2022-11-24 14:21:27','2022-11-24 14:21:27',NULL),(2175,NULL,40745,42010,2,2175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1560.00,NULL,NULL,1,'2022-11-24 14:21:27','2022-11-24 14:21:27',NULL),(2176,NULL,40745,42010,2,2176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',960.00,NULL,NULL,1,'2022-11-24 14:21:27','2022-11-24 14:21:27',NULL),(2177,NULL,40745,42010,2,2177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',600.00,NULL,NULL,1,'2022-11-24 14:21:27','2022-11-24 14:21:27',NULL),(2178,NULL,40745,42010,2,2178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1300.00,NULL,NULL,1,'2022-11-24 14:21:27','2022-11-24 14:21:27',NULL),(2179,NULL,40745,42010,2,2179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1090.00,NULL,NULL,1,'2022-11-24 14:21:27','2022-11-24 14:21:27',NULL),(2180,NULL,40745,42010,2,2180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2280.00,NULL,NULL,1,'2022-11-24 14:21:27','2022-11-24 14:21:27',NULL),(2181,NULL,40745,42010,2,2181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1330.00,NULL,NULL,1,'2022-11-24 14:21:27','2022-11-24 14:21:27',NULL),(2182,NULL,40745,42010,2,2182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',820.00,NULL,NULL,1,'2022-11-24 14:21:27','2022-11-24 14:21:27',NULL),(2183,NULL,40745,42010,2,2183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1120.00,NULL,NULL,1,'2022-11-24 14:21:27','2022-11-24 14:21:27',NULL),(2184,NULL,40745,42010,2,2184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1865.00,NULL,NULL,1,'2022-11-24 14:21:28','2022-11-24 14:21:28',NULL),(2185,NULL,40745,42010,2,2185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2730.00,NULL,NULL,1,'2022-11-24 14:21:28','2022-11-24 14:21:28',NULL),(2186,NULL,40745,42010,2,2186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1000.00,NULL,NULL,1,'2022-11-24 14:21:28','2022-11-24 14:21:28',NULL),(2187,NULL,40745,42010,2,2187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',11500.00,NULL,NULL,1,'2022-11-24 14:21:28','2022-11-24 14:21:28',NULL),(2188,NULL,40745,42010,2,2188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',400.00,NULL,NULL,1,'2022-11-24 14:21:28','2022-11-24 14:21:28',NULL),(2189,NULL,40745,42010,2,2189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',320.00,NULL,NULL,1,'2022-11-24 14:21:28','2022-11-24 14:21:28',NULL),(2190,NULL,40745,42010,2,2190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1075.00,NULL,NULL,1,'2022-11-24 14:21:28','2022-11-24 14:21:28',NULL),(2191,NULL,40745,42010,2,2191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2500.00,NULL,NULL,1,'2022-11-24 14:21:28','2022-11-24 14:21:28',NULL),(2192,NULL,40745,42010,2,2192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',860.00,NULL,NULL,1,'2022-11-24 14:21:28','2022-11-24 14:21:28',NULL),(2193,NULL,40745,42010,2,2193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2000.00,NULL,NULL,1,'2022-11-24 14:21:28','2022-11-24 14:21:28',NULL),(2194,NULL,40745,42010,2,2194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',420.00,NULL,NULL,1,'2022-11-24 14:21:28','2022-11-24 14:21:28',NULL);
INSERT INTO `balance_libro` VALUES (2195,NULL,40745,42010,2,2195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1100.00,NULL,NULL,1,'2022-11-24 14:21:28','2022-11-24 14:21:28',NULL),(2196,NULL,40745,42010,2,2196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2880.00,NULL,NULL,1,'2022-11-24 14:21:28','2022-11-24 14:21:28',NULL),(2197,NULL,40745,42010,2,2197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',538.00,NULL,NULL,1,'2022-11-24 14:21:28','2022-11-24 14:21:28',NULL),(2198,NULL,40745,42010,2,2198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',200.00,NULL,NULL,1,'2022-11-24 14:21:28','2022-11-24 14:21:28',NULL),(2199,NULL,40745,42010,2,2199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',985.00,NULL,NULL,1,'2022-11-24 14:21:28','2022-11-24 14:21:28',NULL),(2200,NULL,40745,42010,2,2200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',400.00,NULL,NULL,1,'2022-11-24 14:21:28','2022-11-24 14:21:28',NULL),(2201,NULL,40745,42010,2,2201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1400.00,NULL,NULL,1,'2022-11-24 14:21:29','2022-11-24 14:21:29',NULL),(2202,NULL,40745,42010,2,2202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',730.00,NULL,NULL,1,'2022-11-24 14:21:29','2022-11-24 14:21:29',NULL),(2203,NULL,40745,42010,2,2203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',640.00,NULL,NULL,1,'2022-11-24 14:21:29','2022-11-24 14:21:29',NULL),(2204,NULL,40745,42010,2,2204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',740.00,NULL,NULL,1,'2022-11-24 14:21:29','2022-11-24 14:21:29',NULL),(2205,NULL,40745,42010,2,2205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',870.00,NULL,NULL,1,'2022-11-24 14:21:29','2022-11-24 14:21:29',NULL),(2206,NULL,40745,42010,2,2206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1200.00,NULL,NULL,1,'2022-11-24 14:21:29','2022-11-24 14:21:29',NULL),(2207,NULL,40745,42010,2,2207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1130.00,NULL,NULL,1,'2022-11-24 14:21:29','2022-11-24 14:21:29',NULL),(2208,NULL,40745,42010,2,2208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1650.00,NULL,NULL,1,'2022-11-24 14:21:29','2022-11-24 14:21:29',NULL),(2209,NULL,40745,42010,2,2209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',880.00,NULL,NULL,1,'2022-11-24 14:21:29','2022-11-24 14:21:29',NULL),(2210,NULL,40745,42010,2,2210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2105.00,NULL,NULL,1,'2022-11-24 14:21:29','2022-11-24 14:21:29',NULL),(2211,NULL,40745,42010,2,2211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1370.00,NULL,NULL,1,'2022-11-24 14:21:29','2022-11-24 14:21:29',NULL),(2212,NULL,40745,42010,2,2212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1405.00,NULL,NULL,1,'2022-11-24 14:21:29','2022-11-24 14:21:29',NULL),(2213,NULL,40745,42010,2,2213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',650.00,NULL,NULL,1,'2022-11-24 14:21:29','2022-11-24 14:21:29',NULL),(2214,NULL,40745,42010,2,2214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',370.00,NULL,NULL,1,'2022-11-24 14:21:29','2022-11-24 14:21:29',NULL),(2215,NULL,40745,42010,2,2215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',870.00,NULL,NULL,1,'2022-11-24 14:21:29','2022-11-24 14:21:29',NULL),(2216,NULL,40745,42010,2,2216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',310.00,NULL,NULL,1,'2022-11-24 14:21:29','2022-11-24 14:21:29',NULL),(2217,NULL,40745,42010,2,2217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1725.00,NULL,NULL,1,'2022-11-24 14:21:29','2022-11-24 14:21:29',NULL),(2218,NULL,40745,42010,2,2218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',830.00,NULL,NULL,1,'2022-11-24 14:21:29','2022-11-24 14:21:29',NULL);
INSERT INTO `balance_libro` VALUES (2219,NULL,40745,42010,2,2219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',640.00,NULL,NULL,1,'2022-11-24 14:21:29','2022-11-24 14:21:29',NULL),(2220,NULL,40745,42010,2,2220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',350.00,NULL,NULL,1,'2022-11-24 14:21:29','2022-11-24 14:21:29',NULL),(2221,NULL,40745,42010,2,2221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1000.00,NULL,NULL,1,'2022-11-24 14:21:29','2022-11-24 14:21:29',NULL),(2222,NULL,40745,42010,2,2222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',700.00,NULL,NULL,1,'2022-11-24 14:21:29','2022-11-24 14:21:29',NULL),(2223,NULL,40745,42010,2,2223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1820.00,NULL,NULL,1,'2022-11-24 14:21:29','2022-11-24 14:21:29',NULL),(2224,NULL,40745,42010,2,2224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',590.00,NULL,NULL,1,'2022-11-24 14:21:29','2022-11-24 14:21:29',NULL),(2225,NULL,40745,42010,2,2225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1095.00,NULL,NULL,1,'2022-11-24 14:21:29','2022-11-24 14:21:29',NULL),(2226,NULL,40745,42010,2,2226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',4705.00,NULL,NULL,1,'2022-11-24 14:21:29','2022-11-24 14:21:29',NULL),(2227,NULL,40745,42010,2,2227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',990.00,NULL,NULL,1,'2022-11-24 14:21:29','2022-11-24 14:21:29',NULL),(2228,NULL,40745,42010,2,2228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',960.00,NULL,NULL,1,'2022-11-24 14:21:30','2022-11-24 14:21:30',NULL),(2229,NULL,40745,42010,2,2229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',463.00,NULL,NULL,1,'2022-11-24 14:21:30','2022-11-24 14:21:30',NULL),(2230,NULL,40745,42010,2,2230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',530.00,NULL,NULL,1,'2022-11-24 14:21:30','2022-11-24 14:21:30',NULL),(2231,NULL,40745,42010,2,2231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1035.00,NULL,NULL,1,'2022-11-24 14:21:30','2022-11-24 14:21:30',NULL),(2232,NULL,40745,42010,2,2232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1240.00,NULL,NULL,1,'2022-11-24 14:21:30','2022-11-24 14:21:30',NULL),(2233,NULL,40745,42010,2,2233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1530.00,NULL,NULL,1,'2022-11-24 14:21:30','2022-11-24 14:21:30',NULL),(2234,NULL,40745,42010,2,2234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',2050.00,NULL,NULL,1,'2022-11-24 14:21:30','2022-11-24 14:21:30',NULL),(2235,NULL,40745,42010,2,2235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',300.00,NULL,NULL,1,'2022-11-24 14:21:30','2022-11-24 14:21:30',NULL),(2236,NULL,40745,42010,2,2236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',600.00,NULL,NULL,1,'2022-11-24 14:21:30','2022-11-24 14:21:30',NULL),(2237,NULL,40745,42010,2,2237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',210.00,NULL,NULL,1,'2022-11-24 14:21:30','2022-11-24 14:21:30',NULL),(2238,NULL,40745,42010,2,2238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',940.00,NULL,NULL,1,'2022-11-24 14:21:30','2022-11-24 14:21:30',NULL),(2239,NULL,40745,42010,2,2239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',325.00,NULL,NULL,1,'2022-11-24 14:21:30','2022-11-24 14:21:30',NULL),(2240,NULL,40745,42010,2,2240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',770.00,NULL,NULL,1,'2022-11-24 14:21:30','2022-11-24 14:21:30',NULL),(2241,NULL,40745,42010,2,2241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',550.00,NULL,NULL,1,'2022-11-24 14:21:30','2022-11-24 14:21:30',NULL),(2242,NULL,40745,42010,2,2242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',120.00,NULL,NULL,1,'2022-11-24 14:21:30','2022-11-24 14:21:30',NULL);
INSERT INTO `balance_libro` VALUES (2243,NULL,40745,42010,2,2243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1610.00,NULL,NULL,1,'2022-11-24 14:21:30','2022-11-24 14:21:30',NULL),(2244,NULL,40745,42010,2,2244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',590.00,NULL,NULL,1,'2022-11-24 14:21:30','2022-11-24 14:21:30',NULL),(2245,NULL,40745,42010,2,2245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',180.00,NULL,NULL,1,'2022-11-24 14:21:30','2022-11-24 14:21:30',NULL),(2246,NULL,40745,42010,2,2246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1040.00,NULL,NULL,1,'2022-11-24 14:21:30','2022-11-24 14:21:30',NULL),(2247,NULL,40745,42010,2,2247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',340.00,NULL,NULL,1,'2022-11-24 14:21:30','2022-11-24 14:21:30',NULL),(2248,NULL,40745,42010,2,2248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',260.00,NULL,NULL,1,'2022-11-24 14:21:30','2022-11-24 14:21:30',NULL),(2249,NULL,40745,42010,2,2249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',920.00,NULL,NULL,1,'2022-11-24 14:21:30','2022-11-24 14:21:30',NULL),(2250,NULL,40745,42010,2,2250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',750.00,NULL,NULL,1,'2022-11-24 14:21:30','2022-11-24 14:21:30',NULL),(2251,NULL,40745,42010,2,2251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',650.00,NULL,NULL,1,'2022-11-24 14:21:30','2022-11-24 14:21:30',NULL),(2252,NULL,40745,42010,2,2252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',570.00,NULL,NULL,1,'2022-11-24 14:21:30','2022-11-24 14:21:30',NULL),(2253,NULL,40745,42010,2,2253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1040.00,NULL,NULL,1,'2022-11-24 14:21:30','2022-11-24 14:21:30',NULL),(2254,NULL,40745,42010,2,2254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',660.00,NULL,NULL,1,'2022-11-24 14:21:31','2022-11-24 14:21:31',NULL),(2255,NULL,40745,42010,2,2255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',350.00,NULL,NULL,1,'2022-11-24 14:21:31','2022-11-24 14:21:31',NULL),(2256,NULL,40745,42010,2,2256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1520.00,NULL,NULL,1,'2022-11-24 14:21:31','2022-11-24 14:21:31',NULL),(2257,NULL,40745,42010,2,2257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',450.00,NULL,NULL,1,'2022-11-24 14:21:31','2022-11-24 14:21:31',NULL),(2258,NULL,40745,42010,2,2258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1080.00,NULL,NULL,1,'2022-11-24 14:21:31','2022-11-24 14:21:31',NULL),(2259,NULL,40745,42010,2,2259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1130.00,NULL,NULL,1,'2022-11-24 14:21:31','2022-11-24 14:21:31',NULL),(2260,NULL,40745,42010,2,2260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',3465.00,NULL,NULL,1,'2022-11-24 14:21:31','2022-11-24 14:21:31',NULL),(2261,NULL,40745,42010,2,2261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',260.00,NULL,NULL,1,'2022-11-24 14:21:31','2022-11-24 14:21:31',NULL),(2262,NULL,40745,42010,2,2262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',555.00,NULL,NULL,1,'2022-11-24 14:21:31','2022-11-24 14:21:31',NULL),(2263,NULL,40745,42010,2,2263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',3000.00,NULL,NULL,1,'2022-11-24 14:21:31','2022-11-24 14:21:31',NULL),(2264,NULL,40745,42010,2,2264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',650.00,NULL,NULL,1,'2022-11-24 14:21:31','2022-11-24 14:21:31',NULL),(2265,NULL,40745,42010,2,2265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1000.00,NULL,NULL,1,'2022-11-24 14:21:31','2022-11-24 14:21:31',NULL),(2266,NULL,40745,42010,2,2266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1335.00,NULL,NULL,1,'2022-11-24 14:21:31','2022-11-24 14:21:31',NULL);
INSERT INTO `balance_libro` VALUES (2267,NULL,40745,42010,2,2267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',130.00,NULL,NULL,1,'2022-11-24 14:21:31','2022-11-24 14:21:31',NULL),(2268,NULL,40745,42010,2,2268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1040.00,NULL,NULL,1,'2022-11-24 14:21:31','2022-11-24 14:21:31',NULL),(2269,NULL,40745,42010,2,2269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',170.00,NULL,NULL,1,'2022-11-24 14:21:31','2022-11-24 14:21:31',NULL),(2270,NULL,40745,42010,2,2270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',3520.00,NULL,NULL,1,'2022-11-24 14:21:31','2022-11-24 14:21:31',NULL),(2271,NULL,40745,42010,2,2271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1618.00,NULL,NULL,1,'2022-11-24 14:21:31','2022-11-24 14:21:31',NULL),(2272,NULL,40745,42010,2,2272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',170.00,NULL,NULL,1,'2022-11-24 14:21:31','2022-11-24 14:21:31',NULL),(2273,NULL,40745,42010,2,2273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',860.00,NULL,NULL,1,'2022-11-24 14:21:31','2022-11-24 14:21:31',NULL),(2274,NULL,40745,42010,2,2274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1000.00,NULL,NULL,1,'2022-11-24 14:21:31','2022-11-24 14:21:31',NULL),(2275,NULL,40745,42010,2,2275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1260.00,NULL,NULL,1,'2022-11-24 14:21:31','2022-11-24 14:21:31',NULL),(2276,NULL,40745,42010,2,2276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',640.00,NULL,NULL,1,'2022-11-24 14:21:31','2022-11-24 14:21:31',NULL),(2277,NULL,40745,42010,2,2277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1500.00,NULL,NULL,1,'2022-11-24 14:21:31','2022-11-24 14:21:31',NULL),(2278,NULL,40745,42010,2,2278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',950.00,NULL,NULL,1,'2022-11-24 14:21:31','2022-11-24 14:21:31',NULL),(2279,NULL,40745,42010,2,2279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1630.00,NULL,NULL,1,'2022-11-24 14:21:31','2022-11-24 14:21:31',NULL),(2280,NULL,40745,42010,2,2280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',690.00,NULL,NULL,1,'2022-11-24 14:21:31','2022-11-24 14:21:31',NULL),(2281,NULL,40745,42010,2,2281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',2385.00,NULL,NULL,1,'2022-11-24 14:21:32','2022-11-24 14:21:32',NULL),(2282,NULL,40745,42010,2,2282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',560.00,NULL,NULL,1,'2022-11-24 14:21:32','2022-11-24 14:21:32',NULL),(2283,NULL,40745,42010,2,2283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',3215.00,NULL,NULL,1,'2022-11-24 14:21:32','2022-11-24 14:21:32',NULL),(2284,NULL,40745,42010,2,2284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',100.00,NULL,NULL,1,'2022-11-24 14:21:32','2022-11-24 14:21:32',NULL),(2285,NULL,40745,42010,2,2285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',1000.00,NULL,NULL,1,'2022-11-24 14:21:32','2022-11-24 14:21:32',NULL),(2286,NULL,40745,42010,2,2286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',500.00,NULL,NULL,1,'2022-11-24 14:21:32','2022-11-24 14:21:32',NULL),(2287,NULL,40745,42010,2,2287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',1700.00,NULL,NULL,1,'2022-11-24 14:21:32','2022-11-24 14:21:32',NULL),(2288,NULL,40745,42010,2,2288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',1150.00,NULL,NULL,1,'2022-11-24 14:21:32','2022-11-24 14:21:32',NULL),(2289,NULL,40745,42010,2,2289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',570.00,NULL,NULL,1,'2022-11-24 14:21:32','2022-11-24 14:21:32',NULL),(2290,NULL,40745,42010,2,2290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',450.00,NULL,NULL,1,'2022-11-24 14:21:32','2022-11-24 14:21:32',NULL);
INSERT INTO `balance_libro` VALUES (2291,NULL,40745,42010,2,2291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',3360.00,NULL,NULL,1,'2022-11-24 14:21:32','2022-11-24 14:21:32',NULL),(2292,NULL,40745,42010,2,2292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',100.00,NULL,NULL,1,'2022-11-24 14:21:32','2022-11-24 14:21:32',NULL),(2293,NULL,40745,42010,2,2293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',520.00,NULL,NULL,1,'2022-11-24 14:21:32','2022-11-24 14:21:32',NULL),(2294,NULL,40745,42010,2,2294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',2430.00,NULL,NULL,1,'2022-11-24 14:21:32','2022-11-24 14:21:32',NULL),(2295,NULL,40745,42010,2,2295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',565.00,NULL,NULL,1,'2022-11-24 14:21:32','2022-11-24 14:21:32',NULL),(2296,NULL,40745,42010,2,2296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',1212.00,NULL,NULL,1,'2022-11-24 14:21:32','2022-11-24 14:21:32',NULL),(2297,NULL,40745,42010,2,2297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',750.00,NULL,NULL,1,'2022-11-24 14:21:32','2022-11-24 14:21:32',NULL),(2298,NULL,40745,42010,2,2298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',1250.00,NULL,NULL,1,'2022-11-24 14:21:32','2022-11-24 14:21:32',NULL),(2299,NULL,40745,42010,2,2299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',1080.00,NULL,NULL,1,'2022-11-24 14:21:32','2022-11-24 14:21:32',NULL),(2300,NULL,40745,42010,2,2300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',1500.00,NULL,NULL,1,'2022-11-24 14:21:32','2022-11-24 14:21:32',NULL),(2301,NULL,40745,42010,2,2301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',1000.00,NULL,NULL,1,'2022-11-24 14:21:32','2022-11-24 14:21:32',NULL),(2302,NULL,40745,42010,2,2302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',360.00,NULL,NULL,1,'2022-11-24 14:21:32','2022-11-24 14:21:32',NULL),(2303,NULL,40745,42010,2,2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',230.00,NULL,NULL,1,'2022-11-24 14:21:32','2022-11-24 14:21:32',NULL),(2304,NULL,40745,42010,2,2304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',805.00,NULL,NULL,1,'2022-11-24 14:21:32','2022-11-24 14:21:32',NULL),(2305,NULL,40745,42010,2,2305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',295.00,NULL,NULL,1,'2022-11-24 14:21:32','2022-11-24 14:21:32',NULL),(2306,NULL,40745,42010,2,2306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',3540.00,NULL,NULL,1,'2022-11-24 14:21:32','2022-11-24 14:21:32',NULL),(2307,NULL,40745,42010,2,2307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',480.00,NULL,NULL,1,'2022-11-24 14:21:32','2022-11-24 14:21:32',NULL),(2308,NULL,40745,42010,2,2308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',1610.00,NULL,NULL,1,'2022-11-24 14:21:32','2022-11-24 14:21:32',NULL),(2309,NULL,40745,42010,2,2309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',380.00,NULL,NULL,1,'2022-11-24 14:21:33','2022-11-24 14:21:33',NULL),(2310,NULL,40745,42010,2,2310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',640.00,NULL,NULL,1,'2022-11-24 14:21:33','2022-11-24 14:21:33',NULL),(2311,NULL,40745,42010,2,2311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',680.00,NULL,NULL,1,'2022-11-24 14:21:33','2022-11-24 14:21:33',NULL),(2312,NULL,40745,42010,2,2312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',270.00,NULL,NULL,1,'2022-11-24 14:21:33','2022-11-24 14:21:33',NULL),(2313,NULL,40745,42010,2,2313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',480.00,NULL,NULL,1,'2022-11-24 14:21:33','2022-11-24 14:21:33',NULL),(2314,NULL,40745,42010,2,2314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',595.00,NULL,NULL,1,'2022-11-24 14:21:33','2022-11-24 14:21:33',NULL);
INSERT INTO `balance_libro` VALUES (2315,NULL,40745,42010,2,2315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',1710.00,NULL,NULL,1,'2022-11-24 14:21:33','2022-11-24 14:21:33',NULL),(2316,NULL,40745,42010,2,2316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',600.00,NULL,NULL,1,'2022-11-24 14:21:33','2022-11-24 14:21:33',NULL),(2317,NULL,40745,42010,2,2317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',2830.00,NULL,NULL,1,'2022-11-24 14:21:33','2022-11-24 14:21:33',NULL),(2318,NULL,40745,42010,2,2318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',400.00,NULL,NULL,1,'2022-11-24 14:21:33','2022-11-24 14:21:33',NULL),(2319,NULL,40745,42010,2,2319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',600.00,NULL,NULL,1,'2022-11-24 14:21:33','2022-11-24 14:21:33',NULL),(2320,NULL,40745,42010,2,2320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',650.00,NULL,NULL,1,'2022-11-24 14:21:33','2022-11-24 14:21:33',NULL),(2321,NULL,40745,42010,2,2321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',535.00,NULL,NULL,1,'2022-11-24 14:21:33','2022-11-24 14:21:33',NULL),(2322,NULL,40745,42010,2,2322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',715.00,NULL,NULL,1,'2022-11-24 14:21:33','2022-11-24 14:21:33',NULL),(2323,NULL,40745,42010,2,2323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',160.00,NULL,NULL,1,'2022-11-24 14:21:33','2022-11-24 14:21:33',NULL),(2324,NULL,40745,42010,2,2324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',4015.00,NULL,NULL,1,'2022-11-24 14:21:33','2022-11-24 14:21:33',NULL),(2325,NULL,40745,42010,2,2325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',880.00,NULL,NULL,1,'2022-11-24 14:21:33','2022-11-24 14:21:33',NULL),(2326,NULL,40745,42010,2,2326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',920.00,NULL,NULL,1,'2022-11-24 14:21:33','2022-11-24 14:21:33',NULL),(2327,NULL,40745,42010,2,2327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',1000.00,NULL,NULL,1,'2022-11-24 14:21:33','2022-11-24 14:21:33',NULL),(2328,NULL,40745,42010,2,2328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',460.00,NULL,NULL,1,'2022-11-24 14:21:33','2022-11-24 14:21:33',NULL),(2329,NULL,40745,42010,2,2329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',3000.00,NULL,NULL,1,'2022-11-24 14:21:33','2022-11-24 14:21:33',NULL),(2330,NULL,40745,42010,2,2330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',990.00,NULL,NULL,1,'2022-11-24 14:21:33','2022-11-24 14:21:33',NULL),(2331,NULL,40745,42010,2,2331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',1500.00,NULL,NULL,1,'2022-11-24 14:21:33','2022-11-24 14:21:33',NULL),(2332,NULL,40745,42010,2,2332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',450.00,NULL,NULL,1,'2022-11-24 14:21:33','2022-11-24 14:21:33',NULL),(2333,NULL,40745,42010,2,2333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',825.00,NULL,NULL,1,'2022-11-24 14:21:33','2022-11-24 14:21:33',NULL),(2334,NULL,40745,42010,2,2334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',1000.00,NULL,NULL,1,'2022-11-24 14:21:33','2022-11-24 14:21:33',NULL),(2335,NULL,40745,42010,2,2335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',2140.00,NULL,NULL,1,'2022-11-24 14:21:33','2022-11-24 14:21:33',NULL),(2336,NULL,40745,42010,2,2336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',1225.00,NULL,NULL,1,'2022-11-24 14:21:33','2022-11-24 14:21:33',NULL),(2337,NULL,40745,42010,2,2337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',290.00,NULL,NULL,1,'2022-11-24 14:21:33','2022-11-24 14:21:33',NULL),(2338,NULL,40745,42010,2,2338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',940.00,NULL,NULL,1,'2022-11-24 14:21:33','2022-11-24 14:21:33',NULL);
INSERT INTO `balance_libro` VALUES (2339,NULL,40745,42010,2,2339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',550.00,NULL,NULL,1,'2022-11-24 14:21:34','2022-11-24 14:21:34',NULL),(2340,NULL,40745,42010,2,2340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',60.10,NULL,NULL,1,'2022-11-24 14:21:34','2022-11-24 14:21:34',NULL),(2341,NULL,40745,42010,2,2341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',420.00,NULL,NULL,1,'2022-11-24 14:21:34','2022-11-24 14:21:34',NULL),(2342,NULL,40745,42010,2,2342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',110.00,NULL,NULL,1,'2022-11-24 14:21:34','2022-11-24 14:21:34',NULL),(2343,NULL,40745,42010,2,2343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',1185.00,NULL,NULL,1,'2022-11-24 14:21:34','2022-11-24 14:21:34',NULL),(2344,NULL,40745,42010,2,2344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',1580.00,NULL,NULL,1,'2022-11-24 14:21:34','2022-11-24 14:21:34',NULL),(2345,NULL,40745,42010,2,2345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',370.00,NULL,NULL,1,'2022-11-24 14:21:34','2022-11-24 14:21:34',NULL),(2346,NULL,40745,42010,2,2346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',150.00,NULL,NULL,1,'2022-11-24 14:21:34','2022-11-24 14:21:34',NULL),(2347,NULL,40745,42010,2,2347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',800.00,NULL,NULL,1,'2022-11-24 14:21:34','2022-11-24 14:21:34',NULL),(2348,NULL,40745,42010,2,2348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',570.00,NULL,NULL,1,'2022-11-24 14:21:34','2022-11-24 14:21:34',NULL),(2349,NULL,40745,42010,2,2349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',280.00,NULL,NULL,1,'2022-11-24 14:21:34','2022-11-24 14:21:34',NULL),(2350,NULL,40745,42010,2,2350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',1740.00,NULL,NULL,1,'2022-11-24 14:21:34','2022-11-24 14:21:34',NULL),(2351,NULL,40745,42010,2,2351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',410.00,NULL,NULL,1,'2022-11-24 14:21:34','2022-11-24 14:21:34',NULL),(2352,NULL,40745,42010,2,2352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',630.00,NULL,NULL,1,'2022-11-24 14:21:34','2022-11-24 14:21:34',NULL),(2353,NULL,40745,42010,2,2353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',1280.00,NULL,NULL,1,'2022-11-24 14:21:34','2022-11-24 14:21:34',NULL),(2354,NULL,40745,42010,2,2354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',350.00,NULL,NULL,1,'2022-11-24 14:21:34','2022-11-24 14:21:34',NULL),(2355,NULL,40745,42010,2,2355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',770.00,NULL,NULL,1,'2022-11-24 14:21:34','2022-11-24 14:21:34',NULL),(2356,NULL,40745,42010,2,2356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',1640.00,NULL,NULL,1,'2022-11-24 14:21:34','2022-11-24 14:21:34',NULL),(2357,NULL,40745,42010,2,2357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',600.00,NULL,NULL,1,'2022-11-24 14:21:34','2022-11-24 14:21:34',NULL),(2358,NULL,40745,42010,2,2358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',2205.00,NULL,NULL,1,'2022-11-24 14:21:34','2022-11-24 14:21:34',NULL),(2359,NULL,40745,42010,2,2359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',100.00,NULL,NULL,1,'2022-11-24 14:21:34','2022-11-24 14:21:34',NULL),(2360,NULL,40745,42010,2,2360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',1785.00,NULL,NULL,1,'2022-11-24 14:21:34','2022-11-24 14:21:34',NULL),(2361,NULL,40745,42010,2,2361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',715.00,NULL,NULL,1,'2022-11-24 14:21:34','2022-11-24 14:21:34',NULL),(2362,NULL,40745,42010,2,2362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',500.00,NULL,NULL,1,'2022-11-24 14:21:34','2022-11-24 14:21:34',NULL);
INSERT INTO `balance_libro` VALUES (2363,NULL,40745,42010,2,2363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',3330.00,NULL,NULL,1,'2022-11-24 14:21:34','2022-11-24 14:21:34',NULL),(2364,NULL,40745,42010,2,2364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',730.00,NULL,NULL,1,'2022-11-24 14:21:34','2022-11-24 14:21:34',NULL),(2365,NULL,40745,42010,2,2365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',670.00,NULL,NULL,1,'2022-11-24 14:21:34','2022-11-24 14:21:34',NULL),(2366,NULL,40745,42010,2,2366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',1060.00,NULL,NULL,1,'2022-11-24 14:21:34','2022-11-24 14:21:34',NULL),(2367,NULL,40745,42010,2,2367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',100.00,NULL,NULL,1,'2022-11-24 14:21:34','2022-11-24 14:21:34',NULL),(2368,NULL,40745,42010,2,2368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',1395.00,NULL,NULL,1,'2022-11-24 14:21:35','2022-11-24 14:21:35',NULL),(2369,NULL,40745,42010,2,2369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',200.00,NULL,NULL,1,'2022-11-24 14:21:35','2022-11-24 14:21:35',NULL),(2370,NULL,40745,42010,2,2370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',460.00,NULL,NULL,1,'2022-11-24 14:21:35','2022-11-24 14:21:35',NULL),(2371,NULL,40745,42010,2,2371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',650.00,NULL,NULL,1,'2022-11-24 14:21:35','2022-11-24 14:21:35',NULL),(2372,NULL,40745,42010,2,2372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',1520.00,NULL,NULL,1,'2022-11-24 14:21:35','2022-11-24 14:21:35',NULL),(2373,NULL,40745,42010,2,2373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',1540.00,NULL,NULL,1,'2022-11-24 14:21:35','2022-11-24 14:21:35',NULL),(2374,NULL,40745,42010,2,2374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',2500.00,NULL,NULL,1,'2022-11-24 14:21:35','2022-11-24 14:21:35',NULL),(2375,NULL,40745,42010,2,2375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',410.00,NULL,NULL,1,'2022-11-24 14:21:35','2022-11-24 14:21:35',NULL),(2376,NULL,40745,42010,2,2376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',7400.00,NULL,NULL,1,'2022-11-24 14:21:35','2022-11-24 14:21:35',NULL),(2377,NULL,40745,42010,2,2377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1390.00,NULL,NULL,1,'2022-11-24 14:21:35','2022-11-24 14:21:35',NULL),(2378,NULL,40745,42010,2,2378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',890.00,NULL,NULL,1,'2022-11-24 14:21:35','2022-11-24 14:21:35',NULL),(2379,NULL,40745,42010,2,2379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',600.00,NULL,NULL,1,'2022-11-24 14:21:35','2022-11-24 14:21:35',NULL),(2380,NULL,40745,42010,2,2380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',500.00,NULL,NULL,1,'2022-11-24 14:21:35','2022-11-24 14:21:35',NULL),(2381,NULL,40745,42010,2,2381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2380.00,NULL,NULL,1,'2022-11-24 14:21:35','2022-11-24 14:21:35',NULL),(2382,NULL,40745,42010,2,2382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',370.00,NULL,NULL,1,'2022-11-24 14:21:35','2022-11-24 14:21:35',NULL),(2383,NULL,40745,42010,2,2383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1330.00,NULL,NULL,1,'2022-11-24 14:21:35','2022-11-24 14:21:35',NULL),(2384,NULL,40745,42010,2,2384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',610.00,NULL,NULL,1,'2022-11-24 14:21:35','2022-11-24 14:21:35',NULL),(2385,NULL,40745,42010,2,2385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1320.00,NULL,NULL,1,'2022-11-24 14:21:35','2022-11-24 14:21:35',NULL),(2386,NULL,40745,42010,2,2386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1170.00,NULL,NULL,1,'2022-11-24 14:21:35','2022-11-24 14:21:35',NULL);
INSERT INTO `balance_libro` VALUES (2387,NULL,40745,42010,2,2387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2560.00,NULL,NULL,1,'2022-11-24 14:21:35','2022-11-24 14:21:35',NULL),(2388,NULL,40745,42010,2,2388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2940.00,NULL,NULL,1,'2022-11-24 14:21:35','2022-11-24 14:21:35',NULL),(2389,NULL,40745,42010,2,2389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',820.00,NULL,NULL,1,'2022-11-24 14:21:35','2022-11-24 14:21:35',NULL),(2390,NULL,40745,42010,2,2390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1510.00,NULL,NULL,1,'2022-11-24 14:21:35','2022-11-24 14:21:35',NULL),(2391,NULL,40745,42010,2,2391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1000.00,NULL,NULL,1,'2022-11-24 14:21:35','2022-11-24 14:21:35',NULL),(2392,NULL,40745,42010,2,2392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',200.00,NULL,NULL,1,'2022-11-24 14:21:35','2022-11-24 14:21:35',NULL),(2393,NULL,40745,42010,2,2393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',600.00,NULL,NULL,1,'2022-11-24 14:21:35','2022-11-24 14:21:35',NULL),(2394,NULL,40745,42010,2,2394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',180.00,NULL,NULL,1,'2022-11-24 14:21:35','2022-11-24 14:21:35',NULL),(2395,NULL,40745,42010,2,2395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',450.00,NULL,NULL,1,'2022-11-24 14:21:35','2022-11-24 14:21:35',NULL),(2396,NULL,40745,42010,2,2396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',810.00,NULL,NULL,1,'2022-11-24 14:21:35','2022-11-24 14:21:35',NULL),(2397,NULL,40745,42010,2,2397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',270.00,NULL,NULL,1,'2022-11-24 14:21:36','2022-11-24 14:21:36',NULL),(2398,NULL,40745,42010,2,2398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',600.00,NULL,NULL,1,'2022-11-24 14:21:36','2022-11-24 14:21:36',NULL),(2399,NULL,40745,42010,2,2399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1810.00,NULL,NULL,1,'2022-11-24 14:21:36','2022-11-24 14:21:36',NULL),(2400,NULL,40745,42010,2,2400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',150.00,NULL,NULL,1,'2022-11-24 14:21:36','2022-11-24 14:21:36',NULL),(2401,NULL,40745,42010,2,2401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',420.00,NULL,NULL,1,'2022-11-24 14:21:36','2022-11-24 14:21:36',NULL),(2402,NULL,40745,42010,2,2402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',328.00,NULL,NULL,1,'2022-11-24 14:21:36','2022-11-24 14:21:36',NULL),(2403,NULL,40745,42010,2,2403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2150.00,NULL,NULL,1,'2022-11-24 14:21:36','2022-11-24 14:21:36',NULL),(2404,NULL,40745,42010,2,2404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',710.00,NULL,NULL,1,'2022-11-24 14:21:36','2022-11-24 14:21:36',NULL),(2405,NULL,40745,42010,2,2405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1100.00,NULL,NULL,1,'2022-11-24 14:21:36','2022-11-24 14:21:36',NULL),(2406,NULL,40745,42010,2,2406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',3770.00,NULL,NULL,1,'2022-11-24 14:21:36','2022-11-24 14:21:36',NULL),(2407,NULL,40745,42010,2,2407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1150.00,NULL,NULL,1,'2022-11-24 14:21:36','2022-11-24 14:21:36',NULL),(2408,NULL,40745,42010,2,2408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1500.00,NULL,NULL,1,'2022-11-24 14:21:36','2022-11-24 14:21:36',NULL),(2409,NULL,40745,42010,2,2409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',3000.00,NULL,NULL,1,'2022-11-24 14:21:36','2022-11-24 14:21:36',NULL),(2410,NULL,40745,42010,2,2410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',200.00,NULL,NULL,1,'2022-11-24 14:21:36','2022-11-24 14:21:36',NULL);
INSERT INTO `balance_libro` VALUES (2411,NULL,40745,42010,2,2411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',830.00,NULL,NULL,1,'2022-11-24 14:21:36','2022-11-24 14:21:36',NULL),(2412,NULL,40745,42010,2,2412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1630.00,NULL,NULL,1,'2022-11-24 14:21:36','2022-11-24 14:21:36',NULL),(2413,NULL,40745,42010,2,2413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',780.00,NULL,NULL,1,'2022-11-24 14:21:36','2022-11-24 14:21:36',NULL),(2414,NULL,40745,42010,2,2414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',580.00,NULL,NULL,1,'2022-11-24 14:21:36','2022-11-24 14:21:36',NULL),(2415,NULL,40745,42010,2,2415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',640.00,NULL,NULL,1,'2022-11-24 14:21:36','2022-11-24 14:21:36',NULL),(2416,NULL,40745,42010,2,2416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',210.00,NULL,NULL,1,'2022-11-24 14:21:36','2022-11-24 14:21:36',NULL),(2417,NULL,40745,42010,2,2417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',660.00,NULL,NULL,1,'2022-11-24 14:21:36','2022-11-24 14:21:36',NULL),(2418,NULL,40745,42010,2,2418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',300.00,NULL,NULL,1,'2022-11-24 14:21:36','2022-11-24 14:21:36',NULL),(2419,NULL,40745,42010,2,2419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',590.00,NULL,NULL,1,'2022-11-24 14:21:36','2022-11-24 14:21:36',NULL),(2420,NULL,40745,42010,2,2420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',600.00,NULL,NULL,1,'2022-11-24 14:21:36','2022-11-24 14:21:36',NULL),(2421,NULL,40745,42010,2,2421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',340.00,NULL,NULL,1,'2022-11-24 14:21:36','2022-11-24 14:21:36',NULL),(2422,NULL,40745,42010,2,2422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2300.00,NULL,NULL,1,'2022-11-24 14:21:36','2022-11-24 14:21:36',NULL),(2423,NULL,40745,42010,2,2423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',7710.00,NULL,NULL,1,'2022-11-24 14:21:37','2022-11-24 14:21:37',NULL),(2424,NULL,40745,42010,2,2424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1375.00,NULL,NULL,1,'2022-11-24 14:21:37','2022-11-24 14:21:37',NULL),(2425,NULL,40745,42010,2,2425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',200.00,NULL,NULL,1,'2022-11-24 14:21:37','2022-11-24 14:21:37',NULL),(2426,NULL,40745,42010,2,2426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',720.00,NULL,NULL,1,'2022-11-24 14:21:37','2022-11-24 14:21:37',NULL),(2427,NULL,40745,42010,2,2427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',460.00,NULL,NULL,1,'2022-11-24 14:21:37','2022-11-24 14:21:37',NULL),(2428,NULL,40745,42010,2,2428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',830.00,NULL,NULL,1,'2022-11-24 14:21:37','2022-11-24 14:21:37',NULL),(2429,NULL,40745,42010,2,2429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1590.00,NULL,NULL,1,'2022-11-24 14:21:37','2022-11-24 14:21:37',NULL),(2430,NULL,40745,42010,2,2430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',250.00,NULL,NULL,1,'2022-11-24 14:21:37','2022-11-24 14:21:37',NULL),(2431,NULL,40745,42010,2,2431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1565.00,NULL,NULL,1,'2022-11-24 14:21:37','2022-11-24 14:21:37',NULL),(2432,NULL,40745,42010,2,2432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',210.00,NULL,NULL,1,'2022-11-24 14:21:37','2022-11-24 14:21:37',NULL),(2433,NULL,40745,42010,2,2433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',535.00,NULL,NULL,1,'2022-11-24 14:21:37','2022-11-24 14:21:37',NULL),(2434,NULL,40745,42010,2,2434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',890.00,NULL,NULL,1,'2022-11-24 14:21:37','2022-11-24 14:21:37',NULL);
INSERT INTO `balance_libro` VALUES (2435,NULL,40745,42010,2,2435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',360.00,NULL,NULL,1,'2022-11-24 14:21:37','2022-11-24 14:21:37',NULL),(2436,NULL,40745,42010,2,2436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',640.00,NULL,NULL,1,'2022-11-24 14:21:37','2022-11-24 14:21:37',NULL),(2437,NULL,40745,42010,2,2437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',4345.00,NULL,NULL,1,'2022-11-24 14:21:37','2022-11-24 14:21:37',NULL),(2438,NULL,40745,42010,2,2438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1150.00,NULL,NULL,1,'2022-11-24 14:21:37','2022-11-24 14:21:37',NULL),(2439,NULL,40745,42010,2,2439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1770.00,NULL,NULL,1,'2022-11-24 14:21:37','2022-11-24 14:21:37',NULL),(2440,NULL,40745,42010,2,2440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',300.00,NULL,NULL,1,'2022-11-24 14:21:37','2022-11-24 14:21:37',NULL),(2441,NULL,40745,42010,2,2441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',880.00,NULL,NULL,1,'2022-11-24 14:21:37','2022-11-24 14:21:37',NULL),(2442,NULL,40745,42010,2,2442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',655.00,NULL,NULL,1,'2022-11-24 14:21:37','2022-11-24 14:21:37',NULL),(2443,NULL,40745,42010,2,2443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1120.00,NULL,NULL,1,'2022-11-24 14:21:37','2022-11-24 14:21:37',NULL),(2444,NULL,40745,42010,2,2444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',670.00,NULL,NULL,1,'2022-11-24 14:21:37','2022-11-24 14:21:37',NULL),(2445,NULL,40745,42010,2,2445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',650.00,NULL,NULL,1,'2022-11-24 14:21:37','2022-11-24 14:21:37',NULL),(2446,NULL,40745,42010,2,2446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',775.00,NULL,NULL,1,'2022-11-24 14:21:37','2022-11-24 14:21:37',NULL),(2447,NULL,40745,42010,2,2447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',805.00,NULL,NULL,1,'2022-11-24 14:21:37','2022-11-24 14:21:37',NULL),(2448,NULL,40745,42010,2,2448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',290.00,NULL,NULL,1,'2022-11-24 14:21:37','2022-11-24 14:21:37',NULL),(2449,NULL,40745,42010,2,2449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',500.00,NULL,NULL,1,'2022-11-24 14:21:38','2022-11-24 14:21:38',NULL),(2450,NULL,40745,42010,2,2450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',200.00,NULL,NULL,1,'2022-11-24 14:21:38','2022-11-24 14:21:38',NULL),(2451,NULL,40745,42010,2,2451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',850.00,NULL,NULL,1,'2022-11-24 14:21:38','2022-11-24 14:21:38',NULL),(2452,NULL,40745,42010,2,2452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1200.00,NULL,NULL,1,'2022-11-24 14:21:38','2022-11-24 14:21:38',NULL),(2453,NULL,40745,42010,2,2453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',440.00,NULL,NULL,1,'2022-11-24 14:21:38','2022-11-24 14:21:38',NULL),(2454,NULL,40745,42010,2,2454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2885.00,NULL,NULL,1,'2022-11-24 14:21:38','2022-11-24 14:21:38',NULL),(2455,NULL,40745,42010,2,2455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1810.00,NULL,NULL,1,'2022-11-24 14:21:38','2022-11-24 14:21:38',NULL),(2456,NULL,40745,42010,2,2456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1300.00,NULL,NULL,1,'2022-11-24 14:21:38','2022-11-24 14:21:38',NULL),(2457,NULL,40745,42010,2,2457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1380.00,NULL,NULL,1,'2022-11-24 14:21:38','2022-11-24 14:21:38',NULL),(2458,NULL,40745,42010,2,2458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',600.00,NULL,NULL,1,'2022-11-24 14:21:38','2022-11-24 14:21:38',NULL);
INSERT INTO `balance_libro` VALUES (2459,NULL,40745,42010,2,2459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2625.00,NULL,NULL,1,'2022-11-24 14:21:38','2022-11-24 14:21:38',NULL),(2460,NULL,40745,42010,2,2460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',670.00,NULL,NULL,1,'2022-11-24 14:21:38','2022-11-24 14:21:38',NULL),(2461,NULL,40745,42010,2,2461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1570.00,NULL,NULL,1,'2022-11-24 14:21:38','2022-11-24 14:21:38',NULL),(2462,NULL,40745,42010,2,2462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1490.00,NULL,NULL,1,'2022-11-24 14:21:38','2022-11-24 14:21:38',NULL),(2463,NULL,40745,42010,2,2463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1600.00,NULL,NULL,1,'2022-11-24 14:21:38','2022-11-24 14:21:38',NULL),(2464,NULL,40745,42010,2,2464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1840.00,NULL,NULL,1,'2022-11-24 14:21:38','2022-11-24 14:21:38',NULL),(2465,NULL,40745,42010,2,2465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1485.00,NULL,NULL,1,'2022-11-24 14:21:38','2022-11-24 14:21:38',NULL),(2466,NULL,40745,42010,2,2466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1270.00,NULL,NULL,1,'2022-11-24 14:21:38','2022-11-24 14:21:38',NULL),(2467,NULL,40745,42010,2,2467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',800.00,NULL,NULL,1,'2022-11-24 14:21:38','2022-11-24 14:21:38',NULL),(2468,NULL,40745,42010,2,2468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',370.00,NULL,NULL,1,'2022-11-24 14:21:38','2022-11-24 14:21:38',NULL),(2469,NULL,40745,42010,2,2469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',4600.00,NULL,NULL,1,'2022-11-24 14:21:38','2022-11-24 14:21:38',NULL),(2470,NULL,40745,42010,2,2470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',600.00,NULL,NULL,1,'2022-11-24 14:21:38','2022-11-24 14:21:38',NULL),(2471,NULL,40745,42010,2,2471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2990.00,NULL,NULL,1,'2022-11-24 14:21:38','2022-11-24 14:21:38',NULL),(2472,NULL,40745,42010,2,2472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',280.00,NULL,NULL,1,'2022-11-24 14:21:39','2022-11-24 14:21:39',NULL),(2473,NULL,40745,42010,2,2473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',305.00,NULL,NULL,1,'2022-11-24 14:21:39','2022-11-24 14:21:39',NULL),(2474,NULL,40745,42010,2,2474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',200.00,NULL,NULL,1,'2022-11-24 14:21:39','2022-11-24 14:21:39',NULL),(2475,NULL,40745,42010,2,2475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',660.00,NULL,NULL,1,'2022-11-24 14:21:39','2022-11-24 14:21:39',NULL),(2476,NULL,40745,42010,2,2476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',290.00,NULL,NULL,1,'2022-11-24 14:21:39','2022-11-24 14:21:39',NULL),(2477,NULL,40745,42010,2,2477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',350.00,NULL,NULL,1,'2022-11-24 14:21:39','2022-11-24 14:21:39',NULL),(2478,NULL,40745,42010,2,2478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1635.00,NULL,NULL,1,'2022-11-24 14:21:39','2022-11-24 14:21:39',NULL),(2479,NULL,40745,42010,2,2479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',400.00,NULL,NULL,1,'2022-11-24 14:21:39','2022-11-24 14:21:39',NULL),(2480,NULL,40745,42010,2,2480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',980.00,NULL,NULL,1,'2022-11-24 14:21:39','2022-11-24 14:21:39',NULL),(2481,NULL,40745,42010,2,2481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',680.00,NULL,NULL,1,'2022-11-24 14:21:39','2022-11-24 14:21:39',NULL),(2482,NULL,40745,42010,2,2482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',3200.00,NULL,NULL,1,'2022-11-24 14:21:39','2022-11-24 14:21:39',NULL);
INSERT INTO `balance_libro` VALUES (2483,NULL,40745,42010,2,2483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2505.00,NULL,NULL,1,'2022-11-24 14:21:40','2022-11-24 14:21:40',NULL),(2484,NULL,40745,42010,2,2484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',650.00,NULL,NULL,1,'2022-11-24 14:21:40','2022-11-24 14:21:40',NULL),(2485,NULL,40745,42010,2,2485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1000.00,NULL,NULL,1,'2022-11-24 14:21:40','2022-11-24 14:21:40',NULL),(2486,NULL,40745,42010,2,2486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',150.00,NULL,NULL,1,'2022-11-24 14:21:40','2022-11-24 14:21:40',NULL),(2487,NULL,40745,42010,2,2487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',175.00,NULL,NULL,1,'2022-11-24 14:21:40','2022-11-24 14:21:40',NULL),(2488,NULL,40745,42010,2,2488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',610.00,NULL,NULL,1,'2022-11-24 14:21:40','2022-11-24 14:21:40',NULL),(2489,NULL,40745,42010,2,2489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',290.00,NULL,NULL,1,'2022-11-24 14:21:40','2022-11-24 14:21:40',NULL),(2490,NULL,40745,42010,2,2490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1000.00,NULL,NULL,1,'2022-11-24 14:21:40','2022-11-24 14:21:40',NULL),(2491,NULL,40745,42010,2,2491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',950.00,NULL,NULL,1,'2022-11-24 14:21:40','2022-11-24 14:21:40',NULL),(2492,NULL,40745,42010,2,2492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',3000.00,NULL,NULL,1,'2022-11-24 14:21:40','2022-11-24 14:21:40',NULL),(2493,NULL,40745,42010,2,2493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1115.00,NULL,NULL,1,'2022-11-24 14:21:40','2022-11-24 14:21:40',NULL),(2494,NULL,40745,42010,2,2494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1405.00,NULL,NULL,1,'2022-11-24 14:21:40','2022-11-24 14:21:40',NULL),(2495,NULL,40745,42010,2,2495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',625.00,NULL,NULL,1,'2022-11-24 14:21:40','2022-11-24 14:21:40',NULL),(2496,NULL,40745,42010,2,2496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',180.00,NULL,NULL,1,'2022-11-24 14:21:40','2022-11-24 14:21:40',NULL),(2497,NULL,40745,42010,2,2497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1385.00,NULL,NULL,1,'2022-11-24 14:21:40','2022-11-24 14:21:40',NULL),(2498,NULL,40745,42010,2,2498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',855.00,NULL,NULL,1,'2022-11-24 14:21:41','2022-11-24 14:21:41',NULL),(2499,NULL,40745,42010,2,2499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',760.00,NULL,NULL,1,'2022-11-24 14:21:41','2022-11-24 14:21:41',NULL),(2500,NULL,40745,42010,2,2500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',480.00,NULL,NULL,1,'2022-11-24 14:21:41','2022-11-24 14:21:41',NULL),(2501,NULL,40745,42010,2,2501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',6120.00,NULL,NULL,1,'2022-11-24 14:21:41','2022-11-24 14:21:41',NULL),(2502,NULL,40745,42010,2,2502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2340.00,NULL,NULL,1,'2022-11-24 14:21:41','2022-11-24 14:21:41',NULL),(2503,NULL,40745,42010,2,2503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',500.00,NULL,NULL,1,'2022-11-24 14:21:41','2022-11-24 14:21:41',NULL),(2504,NULL,40745,42010,2,2504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',200.00,NULL,NULL,1,'2022-11-24 14:21:41','2022-11-24 14:21:41',NULL),(2505,NULL,40745,42010,2,2505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',260.00,NULL,NULL,1,'2022-11-24 14:21:41','2022-11-24 14:21:41',NULL),(2506,NULL,40745,42010,2,2506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',650.00,NULL,NULL,1,'2022-11-24 14:21:41','2022-11-24 14:21:41',NULL);
INSERT INTO `balance_libro` VALUES (2507,NULL,40745,42010,2,2507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2775.00,NULL,NULL,1,'2022-11-24 14:21:41','2022-11-24 14:21:41',NULL),(2508,NULL,40745,42010,2,2508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',925.00,NULL,NULL,1,'2022-11-24 14:21:41','2022-11-24 14:21:41',NULL),(2509,NULL,40745,42010,2,2509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1950.00,NULL,NULL,1,'2022-11-24 14:21:41','2022-11-24 14:21:41',NULL),(2510,NULL,40745,42010,2,2510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',15405.00,NULL,NULL,1,'2022-11-24 14:21:41','2022-11-24 14:21:41',NULL),(2511,NULL,40745,42010,2,2511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2145.00,NULL,NULL,1,'2022-11-24 14:21:41','2022-11-24 14:21:41',NULL),(2512,7638,40734,24177,2,2512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',50000.00,NULL,NULL,1,'2022-11-24 14:25:03','2022-11-24 14:25:03',NULL),(2513,7638,40734,24177,2,2513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',5000.00,NULL,NULL,1,'2022-11-24 14:25:03','2022-11-24 14:25:03',NULL),(2514,7638,40734,24177,2,2514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',40000.00,NULL,NULL,1,'2022-11-24 14:25:04','2022-11-24 14:25:04',NULL),(2515,7638,40734,24177,2,2515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',35000.00,NULL,NULL,1,'2022-11-24 14:25:04','2022-11-24 14:25:04',NULL),(2516,7638,40734,24177,2,2516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',5000.00,NULL,NULL,1,'2022-11-24 14:25:04','2022-11-24 14:25:04',NULL),(2517,7638,40734,24177,2,2517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',200000.00,NULL,NULL,1,'2022-11-24 14:25:04','2022-11-24 14:25:04',NULL),(2518,7638,40734,24177,2,2518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',200000.00,NULL,NULL,1,'2022-11-24 14:25:04','2022-11-24 14:25:04',NULL),(2519,7638,40734,24177,2,2519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',210600.00,NULL,NULL,1,'2022-11-24 14:25:04','2022-11-24 14:25:04',NULL),(2520,7638,40734,24177,2,2520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',132500.00,NULL,NULL,1,'2022-11-24 14:25:04','2022-11-24 14:25:04',NULL),(2521,7638,40734,24177,2,2521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',84900.00,NULL,NULL,1,'2022-11-24 14:25:04','2022-11-24 14:25:04',NULL),(2522,7638,40734,24177,2,2522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',20000.00,NULL,NULL,1,'2022-11-24 14:25:04','2022-11-24 14:25:04',NULL),(2523,7638,40734,24177,3,2523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',37360.29,NULL,NULL,1,'2022-11-24 14:25:25','2022-11-24 14:25:25',NULL),(2524,7638,40734,24177,3,2524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',322928.70,NULL,NULL,1,'2022-11-24 14:25:25','2022-11-24 14:25:25',NULL),(2525,7638,40734,24177,3,2525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',241116.30,NULL,NULL,1,'2022-11-24 14:25:25','2022-11-24 14:25:25',NULL),(2526,7638,40734,24177,3,2526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',29997.52,NULL,NULL,1,'2022-11-24 14:25:25','2022-11-24 14:25:25',NULL),(2527,7638,40742,37151,2,2527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',75772.62,NULL,NULL,1,'2022-11-24 14:39:24','2022-11-24 14:39:24',NULL),(2528,7638,40742,37151,3,2528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',12742.20,NULL,NULL,1,'2022-11-24 14:39:36','2022-11-24 14:39:36',NULL),(2529,7638,40742,37151,3,2529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',13011.00,NULL,NULL,1,'2022-11-24 14:39:36','2022-11-24 14:39:36',NULL),(2530,7638,40742,37151,3,2530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',4194.56,NULL,NULL,1,'2022-11-24 14:39:36','2022-11-24 14:39:36',NULL);
INSERT INTO `balance_libro` VALUES (2531,7638,40742,37151,3,2531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',6550.00,NULL,NULL,1,'2022-11-24 14:39:36','2022-11-24 14:39:36',NULL),(2532,7638,40742,37151,3,2532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',2640.61,NULL,NULL,1,'2022-11-24 14:39:36','2022-11-24 14:39:36',NULL),(2533,7638,40742,37151,3,2533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',4066.77,NULL,NULL,1,'2022-11-24 14:39:36','2022-11-24 14:39:36',NULL),(2534,7638,40742,37151,3,2534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',3177.64,NULL,NULL,1,'2022-11-24 14:39:36','2022-11-24 14:39:36',NULL),(2535,7638,40742,37151,3,2535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',13241.00,NULL,NULL,1,'2022-11-24 14:39:36','2022-11-24 14:39:36',NULL),(2536,7638,40742,37151,3,2536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',18655.01,NULL,NULL,1,'2022-11-24 14:39:36','2022-11-24 14:39:36',NULL),(2537,7638,40742,37151,3,2537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',63999.00,NULL,NULL,1,'2022-11-24 14:39:36','2022-11-24 14:39:36',NULL),(2538,7638,40742,37151,3,2538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',18655.01,NULL,NULL,1,'2022-11-24 14:39:37','2022-11-24 14:39:37',NULL),(2539,7638,40742,37151,3,2539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',18655.01,NULL,NULL,1,'2022-11-24 14:39:37','2022-11-24 14:39:37',NULL),(2540,7638,40742,37151,3,2540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',20300.00,NULL,NULL,1,'2022-11-24 14:39:37','2022-11-24 14:39:37',NULL),(2541,7638,40742,37151,3,2541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',63999.00,NULL,NULL,1,'2022-11-24 14:39:37','2022-11-24 14:39:37',NULL),(2542,7638,40742,37151,3,2542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',63999.00,NULL,NULL,1,'2022-11-24 14:39:37','2022-11-24 14:39:37',NULL),(2543,7638,40742,37151,3,2543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',24073.00,NULL,NULL,1,'2022-11-24 14:39:37','2022-11-24 14:39:37',NULL),(2544,7638,40742,37151,3,2544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',4549.12,NULL,NULL,1,'2022-11-24 14:39:37','2022-11-24 14:39:37',NULL),(2545,7638,40733,22580,2,2545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',10500.00,NULL,NULL,1,'2022-11-24 14:43:01','2022-11-24 14:43:01',NULL),(2546,7638,40733,22580,2,2546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',85000.00,NULL,NULL,1,'2022-11-24 14:43:01','2022-11-24 14:43:01',NULL),(2547,7638,40733,22580,2,2547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',110000.00,NULL,NULL,1,'2022-11-24 14:43:01','2022-11-24 14:43:01',NULL),(2548,7638,40733,22580,2,2548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',142000.00,NULL,NULL,1,'2022-11-24 14:43:01','2022-11-24 14:43:01',NULL),(2549,7638,40733,22580,2,2549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',185000.00,NULL,NULL,1,'2022-11-24 14:43:01','2022-11-24 14:43:01',NULL),(2550,7638,40733,22580,2,2550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',75000.00,NULL,NULL,1,'2022-11-24 14:43:01','2022-11-24 14:43:01',NULL),(2551,7638,40733,22580,2,2551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',98000.00,NULL,NULL,1,'2022-11-24 14:43:01','2022-11-24 14:43:01',NULL),(2552,7638,40733,22580,2,2552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',120000.00,NULL,NULL,1,'2022-11-24 14:43:01','2022-11-24 14:43:01',NULL),(2553,7638,40733,22580,2,2553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',22000.00,NULL,NULL,1,'2022-11-24 14:43:01','2022-11-24 14:43:01',NULL),(2554,7638,40733,22580,2,2554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',200000.00,NULL,NULL,1,'2022-11-24 14:43:01','2022-11-24 14:43:01',NULL);
INSERT INTO `balance_libro` VALUES (2555,7638,40733,22580,2,2555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',200000.00,NULL,NULL,1,'2022-11-24 14:43:01','2022-11-24 14:43:01',NULL),(2556,7638,40733,22580,2,2556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',68000.00,NULL,NULL,1,'2022-11-24 14:43:01','2022-11-24 14:43:01',NULL),(2557,7638,40733,22580,3,2557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',862.33,NULL,NULL,1,'2022-11-24 14:43:11','2022-11-24 14:43:11',NULL),(2558,7638,40733,22580,3,2558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',15153.35,NULL,NULL,1,'2022-11-24 14:43:11','2022-11-24 14:43:11',NULL),(2559,7638,40733,22580,3,2559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',8361.76,NULL,NULL,1,'2022-11-24 14:43:11','2022-11-24 14:43:11',NULL),(2560,7638,40733,22580,3,2560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',3338.17,NULL,NULL,1,'2022-11-24 14:43:11','2022-11-24 14:43:11',NULL),(2561,7638,40733,22580,3,2561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',7643.33,NULL,NULL,1,'2022-11-24 14:43:11','2022-11-24 14:43:11',NULL),(2562,7638,40733,22580,3,2562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',227.57,NULL,NULL,1,'2022-11-24 14:43:11','2022-11-24 14:43:11',NULL),(2563,7638,40733,22580,3,2563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',5789.85,NULL,NULL,1,'2022-11-24 14:43:11','2022-11-24 14:43:11',NULL),(2564,7638,40733,22580,3,2564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',6814.25,NULL,NULL,1,'2022-11-24 14:43:11','2022-11-24 14:43:11',NULL),(2565,7638,40733,22580,3,2565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',23984.55,NULL,NULL,1,'2022-11-24 14:43:12','2022-11-24 14:43:12',NULL),(2566,7638,40733,22580,3,2566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',17037.86,NULL,NULL,1,'2022-11-24 14:43:12','2022-11-24 14:43:12',NULL),(2567,7638,40733,22580,3,2567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',72999.01,NULL,NULL,1,'2022-11-24 14:43:12','2022-11-24 14:43:12',NULL),(2568,7638,40733,22580,3,2568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',67451.13,NULL,NULL,1,'2022-11-24 14:43:12','2022-11-24 14:43:12',NULL),(2569,7638,40733,22580,3,2569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',2606.00,NULL,NULL,1,'2022-11-24 14:43:12','2022-11-24 14:43:12',NULL),(2570,7638,40733,22580,3,2570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',19769.75,NULL,NULL,1,'2022-11-24 14:43:12','2022-11-24 14:43:12',NULL),(2571,7638,40733,22580,3,2571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',10455.21,NULL,NULL,1,'2022-11-24 14:43:12','2022-11-24 14:43:12',NULL),(2572,7638,40733,22580,3,2572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',9835.00,NULL,NULL,1,'2022-11-24 14:43:12','2022-11-24 14:43:12',NULL),(2573,7638,40733,22580,3,2573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',22445.85,NULL,NULL,1,'2022-11-24 14:43:12','2022-11-24 14:43:12',NULL),(2574,7638,40733,22580,3,2574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',15367.00,NULL,NULL,1,'2022-11-24 14:43:12','2022-11-24 14:43:12',NULL),(2575,7638,40733,22580,3,2575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',9738.00,NULL,NULL,1,'2022-11-24 14:43:12','2022-11-24 14:43:12',NULL),(2576,7638,40733,22580,3,2576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',46525.24,NULL,NULL,1,'2022-11-24 14:43:12','2022-11-24 14:43:12',NULL),(2577,7638,40733,22580,3,2577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',101.14,NULL,NULL,1,'2022-11-24 14:43:12','2022-11-24 14:43:12',NULL),(2578,7638,40733,22580,3,2578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',14422.14,NULL,NULL,1,'2022-11-24 14:43:12','2022-11-24 14:43:12',NULL);
INSERT INTO `balance_libro` VALUES (2579,7638,40733,22580,3,2579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',5006.54,NULL,NULL,1,'2022-11-24 14:43:12','2022-11-24 14:43:12',NULL),(2580,7638,40733,22580,3,2580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',12939.98,NULL,NULL,1,'2022-11-24 14:43:12','2022-11-24 14:43:12',NULL),(2581,7638,40733,22580,3,2581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',3398.80,NULL,NULL,1,'2022-11-24 14:43:12','2022-11-24 14:43:12',NULL),(2582,7638,40733,22580,3,2582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',13481.31,NULL,NULL,1,'2022-11-24 14:43:12','2022-11-24 14:43:12',NULL),(2583,7638,40733,22580,3,2583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',31080.39,NULL,NULL,1,'2022-11-24 14:43:12','2022-11-24 14:43:12',NULL),(2584,7638,40733,22580,3,2584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',4850.64,NULL,NULL,1,'2022-11-24 14:43:12','2022-11-24 14:43:12',NULL),(2585,7638,40733,22580,3,2585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',5304.98,NULL,NULL,1,'2022-11-24 14:43:12','2022-11-24 14:43:12',NULL),(2586,7638,40733,22580,3,2586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',17957.31,NULL,NULL,1,'2022-11-24 14:43:12','2022-11-24 14:43:12',NULL),(2587,7638,40733,22580,3,2587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',14711.72,NULL,NULL,1,'2022-11-24 14:43:12','2022-11-24 14:43:12',NULL),(2588,7638,40733,22580,3,2588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',89.48,NULL,NULL,1,'2022-11-24 14:43:13','2022-11-24 14:43:13',NULL),(2589,7638,40733,22580,3,2589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',2275.96,NULL,NULL,1,'2022-11-24 14:43:13','2022-11-24 14:43:13',NULL),(2590,7638,40733,22580,3,2590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1649.99,NULL,NULL,1,'2022-11-24 14:43:13','2022-11-24 14:43:13',NULL),(2591,7638,40733,22580,3,2591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',71563.01,NULL,NULL,1,'2022-11-24 14:43:13','2022-11-24 14:43:13',NULL),(2592,7638,40733,22580,3,2592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',9795.85,NULL,NULL,1,'2022-11-24 14:43:13','2022-11-24 14:43:13',NULL),(2593,7638,40741,35629,3,2593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',11492.19,NULL,NULL,1,'2022-11-24 14:46:40','2022-11-24 14:46:40',NULL),(2594,7638,40741,35629,3,2594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',45496.57,NULL,NULL,1,'2022-11-24 14:46:40','2022-11-24 14:46:40',NULL),(2595,7638,40741,35629,3,2595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',166036.59,NULL,NULL,1,'2022-11-24 14:46:40','2022-11-24 14:46:40',NULL),(2596,7638,40741,35629,3,2596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',18168.63,NULL,NULL,1,'2022-11-24 14:46:40','2022-11-24 14:46:40',NULL),(2597,7638,40741,35629,3,2597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',240467.54,NULL,NULL,1,'2022-11-24 14:46:40','2022-11-24 14:46:40',NULL),(2598,7638,40741,35629,3,2598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',160311.69,NULL,NULL,1,'2022-11-24 14:46:40','2022-11-24 14:46:40',NULL),(2599,7638,40741,35629,3,2599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',89062.05,NULL,NULL,1,'2022-11-24 14:46:40','2022-11-24 14:46:40',NULL),(2600,7638,40741,35629,3,2600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',16869.63,NULL,NULL,1,'2022-11-24 14:46:40','2022-11-24 14:46:40',NULL),(2601,7638,40741,35629,3,2601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',278995.22,NULL,NULL,1,'2022-11-24 14:46:40','2022-11-24 14:46:40',NULL),(2602,7638,40741,35629,3,2602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',277789.50,NULL,NULL,1,'2022-11-24 14:46:40','2022-11-24 14:46:40',NULL);
INSERT INTO `balance_libro` VALUES (2603,7638,40741,35629,3,2603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',86783.96,NULL,NULL,1,'2022-11-24 14:46:40','2022-11-24 14:46:40',NULL),(2604,7638,40741,35629,3,2604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',158842.75,NULL,NULL,1,'2022-11-24 14:46:40','2022-11-24 14:46:40',NULL),(2605,7638,40741,35629,3,2605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1825.67,NULL,NULL,1,'2022-11-24 14:46:40','2022-11-24 14:46:40',NULL),(2606,7638,40741,35629,3,2606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',50244.28,NULL,NULL,1,'2022-11-24 14:46:41','2022-11-24 14:46:41',NULL),(2607,7638,40741,35629,3,2607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',87049.77,NULL,NULL,1,'2022-11-24 14:46:41','2022-11-24 14:46:41',NULL);
/*!40000 ALTER TABLE `balance_libro` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro_details`
--

DROP TABLE IF EXISTS `balance_libro_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `balance_libro_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_details_person_id_foreign` (`person_id`),
  KEY `balance_libro_details_period_id_foreign` (`period_id`),
  KEY `balance_libro_details_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_details_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_libro_details_saldo_id_foreign` (`saldo_id`),
  KEY `balance_libro_details_balance_libro_id_foreign` (`balance_libro_id`),
  CONSTRAINT `balance_libro_details_balance_libro_id_foreign` FOREIGN KEY (`balance_libro_id`) REFERENCES `balance_libro` (`id`) ON DELETE CASCADE,
  CONSTRAINT `balance_libro_details_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_details_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `balance_libro_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7972 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro_details`
--

LOCK TABLES `balance_libro_details` WRITE;
/*!40000 ALTER TABLE `balance_libro_details` DISABLE KEYS */;
INSERT INTO `balance_libro_details` VALUES (1,7638,1,40738,30492,2,96,2,88825.87,NULL,'2022-11-23 15:33:52','2022-11-23 15:33:52',NULL),(2,7638,1,40738,30492,2,67,2,18653.43,NULL,'2022-11-23 15:33:52','2022-11-23 15:33:52',NULL),(3,7638,1,40738,30492,2,13,1,107479.30,NULL,'2022-11-23 15:33:52','2022-11-23 15:33:52',NULL),(4,7638,2,40738,30492,2,96,2,988662.35,NULL,'2022-11-23 15:33:52','2022-11-23 15:33:52',NULL),(5,7638,2,40738,30492,2,67,2,207619.09,NULL,'2022-11-23 15:33:52','2022-11-23 15:33:52',NULL),(6,7638,2,40738,30492,2,13,1,1196281.44,NULL,'2022-11-23 15:33:52','2022-11-23 15:33:52',NULL),(7,7638,3,40738,30492,3,217,1,5164.46,NULL,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(8,7638,3,40738,30492,3,68,1,1084.54,NULL,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(9,7638,3,40738,30492,3,217,1,361.51,NULL,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(10,7638,3,40738,30492,3,57,2,6610.51,NULL,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(11,7638,4,40738,30492,3,217,1,5701.65,NULL,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(12,7638,4,40738,30492,3,68,1,1197.35,NULL,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(13,7638,4,40738,30492,3,217,1,399.12,NULL,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(14,7638,4,40738,30492,3,57,2,7298.12,NULL,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(15,7638,5,40738,30492,3,217,1,8725.60,NULL,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(16,7638,5,40738,30492,3,68,1,1832.38,NULL,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(17,7638,5,40738,30492,3,57,2,10557.98,NULL,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(18,7638,6,40738,30492,3,217,1,25358.68,NULL,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(19,7638,6,40738,30492,3,68,1,5325.32,NULL,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(20,7638,6,40738,30492,3,57,2,30684.00,NULL,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(21,7638,7,40738,30492,3,217,1,511.55,NULL,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(22,7638,7,40738,30492,3,68,1,107.42,NULL,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(23,7638,7,40738,30492,3,217,1,66.50,NULL,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(24,7638,7,40738,30492,3,57,2,685.47,NULL,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(25,7638,8,40738,30492,3,217,1,6740.19,NULL,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(26,7638,8,40738,30492,3,68,1,1415.44,NULL,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(27,7638,8,40738,30492,3,57,2,8155.63,NULL,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(28,7638,9,40738,30492,3,217,1,3736.65,NULL,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(29,7638,9,40738,30492,3,68,1,392.35,NULL,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(30,7638,9,40738,30492,3,57,2,4129.00,NULL,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(31,7638,10,40738,30492,3,217,1,5045.19,NULL,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(32,7638,10,40738,30492,3,68,1,1059.49,NULL,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(33,7638,10,40738,30492,3,57,2,6104.68,NULL,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(34,7638,11,40738,30492,3,217,1,8976.91,NULL,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(35,7638,11,40738,30492,3,68,1,1885.15,NULL,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(36,7638,11,40738,30492,3,57,2,10862.06,NULL,'2022-11-23 15:41:11','2022-11-23 15:41:11',NULL),(37,7638,12,40738,30492,3,217,1,17549.32,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(38,7638,12,40738,30492,3,68,1,1842.68,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(39,7638,12,40738,30492,3,57,2,19392.00,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(40,7638,13,40738,30492,3,217,1,61540.00,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(41,7638,13,40738,30492,3,68,1,12923.40,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(42,7638,13,40738,30492,3,57,2,74463.40,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL);
INSERT INTO `balance_libro_details` VALUES (43,7638,14,40738,30492,3,217,1,314499.17,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(44,7638,14,40738,30492,3,68,1,66044.82,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(45,7638,14,40738,30492,3,57,2,380543.99,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(46,7638,15,40738,30492,3,217,1,89616.00,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(47,7638,15,40738,30492,3,68,1,18819.36,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(48,7638,15,40738,30492,3,217,1,18303.84,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(49,7638,15,40738,30492,3,57,2,126739.20,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(50,7638,16,40738,30492,3,217,1,197520.00,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(51,7638,16,40738,30492,3,68,1,41479.20,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(52,7638,16,40738,30492,3,217,1,13826.40,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(53,7638,16,40738,30492,3,57,2,252825.60,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(54,7638,17,40738,30492,3,217,1,4957.02,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(55,7638,17,40738,30492,3,68,1,1040.98,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(56,7638,17,40738,30492,3,57,2,5998.00,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(57,7638,18,40738,30492,3,217,1,112.40,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(58,7638,18,40738,30492,3,68,1,23.60,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(59,7638,18,40738,30492,3,57,2,136.00,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(60,7638,19,40738,30492,3,217,1,78.51,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(61,7638,19,40738,30492,3,68,1,16.49,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(62,7638,19,40738,30492,3,57,2,95.00,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(63,7638,20,40738,30492,3,217,1,801.31,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(64,7638,20,40738,30492,3,68,1,168.26,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(65,7638,20,40738,30492,3,217,1,103.16,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(66,7638,20,40738,30492,3,57,2,1072.73,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(67,7638,21,40738,30492,3,250,1,0.00,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(68,7638,21,40738,30492,3,250,1,1150.00,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(69,7638,21,40738,30492,3,57,2,1150.00,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(70,7638,22,40738,30492,3,217,1,62809.09,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(71,7638,22,40738,30492,3,68,1,13189.91,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(72,7638,22,40738,30492,3,57,2,75999.00,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(73,7638,23,40738,30492,3,217,1,62809.09,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(74,7638,23,40738,30492,3,68,1,13189.91,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(75,7638,23,40738,30492,3,57,2,75999.00,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(76,7638,24,40738,30492,3,217,1,141.05,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(77,7638,24,40738,30492,3,68,1,29.62,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(78,7638,24,40738,30492,3,217,1,9.87,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(79,7638,24,40738,30492,3,57,2,180.54,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(80,7638,25,40738,30492,3,217,1,2262.44,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(81,7638,25,40738,30492,3,68,1,237.56,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(82,7638,25,40738,30492,3,57,2,2500.00,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(83,7638,26,40738,30492,3,217,1,27685.95,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(84,7638,26,40738,30492,3,68,1,5814.05,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL);
INSERT INTO `balance_libro_details` VALUES (85,7638,26,40738,30492,3,57,2,33500.00,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(86,7638,27,40738,30492,3,217,1,10413.36,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(87,7638,27,40738,30492,3,68,1,2186.81,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(88,7638,27,40738,30492,3,57,2,12600.17,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(89,7638,28,40738,30492,3,217,1,10413.36,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(90,7638,28,40738,30492,3,68,1,2186.81,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(91,7638,28,40738,30492,3,57,2,12600.17,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(92,7638,29,40738,30492,3,217,1,14871.60,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(93,7638,29,40738,30492,3,68,1,3123.04,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(94,7638,29,40738,30492,3,57,2,17994.64,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(95,7638,30,40738,30492,3,217,1,8677.80,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(96,7638,30,40738,30492,3,68,1,1822.34,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(97,7638,30,40738,30492,3,57,2,10500.14,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(98,7638,31,40738,30492,3,217,1,35182.81,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(99,7638,31,40738,30492,3,68,1,3694.20,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(100,7638,31,40738,30492,3,217,1,2462.79,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(101,7638,31,40738,30492,3,57,2,41339.80,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(102,7638,32,40738,30492,3,217,1,527.49,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(103,7638,32,40738,30492,3,68,1,126.68,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(104,7638,32,40738,30492,3,217,1,34.92,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(105,7638,32,40738,30492,3,57,2,689.09,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(106,7638,33,40738,30492,3,217,1,86448.60,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(107,7638,33,40738,30492,3,68,1,18154.21,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(108,7638,33,40738,30492,3,217,1,1675.08,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(109,7638,33,40738,30492,3,57,2,106277.89,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(110,7638,34,40738,30492,3,217,1,3486.77,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(111,7638,34,40738,30492,3,68,1,732.22,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(112,7638,34,40738,30492,3,217,1,244.07,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(113,7638,34,40738,30492,3,57,2,4463.06,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(114,7638,35,40738,30492,3,217,1,148.76,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(115,7638,35,40738,30492,3,68,1,31.24,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(116,7638,35,40738,30492,3,57,2,180.00,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(117,7638,36,40738,30492,3,217,1,63524.79,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(118,7638,36,40738,30492,3,68,1,13340.21,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(119,7638,36,40738,30492,3,57,2,76865.00,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(120,7638,37,40738,30492,3,217,1,9049.77,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(121,7638,37,40738,30492,3,68,1,950.23,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(122,7638,37,40738,30492,3,57,2,10000.00,NULL,'2022-11-23 15:41:12','2022-11-23 15:41:12',NULL),(123,7638,38,40738,30492,3,217,1,199839.78,NULL,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(124,7638,38,40738,30492,3,68,1,41966.35,NULL,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(125,7638,38,40738,30492,3,217,1,15298.44,NULL,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(126,7638,38,40738,30492,3,57,2,257104.57,NULL,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL);
INSERT INTO `balance_libro_details` VALUES (127,7638,39,40738,30492,3,217,1,111.57,NULL,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(128,7638,39,40738,30492,3,68,1,23.43,NULL,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(129,7638,39,40738,30492,3,57,2,135.00,NULL,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(130,7638,40,40738,30492,3,217,1,340909.08,NULL,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(131,7638,40,40738,30492,3,68,1,71590.91,NULL,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(132,7638,40,40738,30492,3,57,2,412499.99,NULL,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(133,7638,41,40738,30492,3,217,1,373303.14,NULL,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(134,7638,41,40738,30492,3,68,1,39196.83,NULL,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(135,7638,41,40738,30492,3,57,2,412499.97,NULL,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(136,7638,42,40738,30492,3,217,2,373303.14,NULL,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(137,7638,42,40738,30492,3,67,2,39196.83,NULL,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(138,7638,42,40738,30492,3,57,1,412499.97,NULL,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(139,7638,43,40738,30492,3,217,1,340909.08,NULL,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(140,7638,43,40738,30492,3,68,1,71590.91,NULL,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(141,7638,43,40738,30492,3,57,2,412499.99,NULL,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(142,7638,44,40738,30492,3,217,1,85041.32,NULL,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(143,7638,44,40738,30492,3,68,1,17858.68,NULL,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(144,7638,44,40738,30492,3,57,2,102900.00,NULL,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(145,7638,45,40738,30492,3,217,2,340909.08,NULL,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(146,7638,45,40738,30492,3,67,2,71590.91,NULL,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(147,7638,45,40738,30492,3,57,1,412499.99,NULL,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(148,7638,46,40738,30492,3,217,1,1448.43,NULL,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(149,7638,46,40738,30492,3,68,1,304.17,NULL,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(150,7638,46,40738,30492,3,57,2,1752.60,NULL,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(151,7638,47,40738,30492,3,217,1,20.98,NULL,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(152,7638,47,40738,30492,3,68,1,4.41,NULL,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(153,7638,47,40738,30492,3,217,1,0.84,NULL,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(154,7638,47,40738,30492,3,57,2,26.23,NULL,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(155,7638,48,40738,30492,3,217,1,7238.01,NULL,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(156,7638,48,40738,30492,3,68,1,759.99,NULL,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(157,7638,48,40738,30492,3,57,2,7998.00,NULL,'2022-11-23 15:41:13','2022-11-23 15:41:13',NULL),(158,7638,49,40731,19536,3,217,1,83266.10,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(159,7638,49,40731,19536,3,68,1,17485.90,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(160,7638,49,40731,19536,3,57,2,100752.00,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(161,7638,50,40731,19536,3,217,1,15815.16,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(162,7638,50,40731,19536,3,68,1,3321.18,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(163,7638,50,40731,19536,3,217,1,632.61,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(164,7638,50,40731,19536,3,57,2,19768.95,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(165,7638,51,40731,19536,3,217,1,17965.80,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(166,7638,51,40731,19536,3,68,1,3772.82,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(167,7638,51,40731,19536,3,217,1,718.63,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL);
INSERT INTO `balance_libro_details` VALUES (168,7638,51,40731,19536,3,57,2,22457.25,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(169,7638,52,40731,19536,3,217,1,6190.09,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(170,7638,52,40731,19536,3,68,1,1299.91,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(171,7638,52,40731,19536,3,57,2,7490.00,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(172,7638,53,40731,19536,3,217,1,15787.12,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(173,7638,53,40731,19536,3,68,1,3315.30,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(174,7638,53,40731,19536,3,217,1,-0.01,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(175,7638,53,40731,19536,3,57,2,19102.41,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(176,7638,54,40731,19536,3,217,1,165289.26,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(177,7638,54,40731,19536,3,68,1,34710.74,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(178,7638,54,40731,19536,3,57,2,200000.00,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(179,7638,55,40731,19536,3,217,1,174375.81,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(180,7638,55,40731,19536,3,68,1,36618.92,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(181,7638,55,40731,19536,3,57,2,210994.73,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(182,7638,56,40731,19536,3,217,1,229089.06,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(183,7638,56,40731,19536,3,68,1,48108.70,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(184,7638,56,40731,19536,3,57,2,277197.76,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(185,7638,57,40731,19536,3,217,1,3305.79,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(186,7638,57,40731,19536,3,68,1,694.21,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(187,7638,57,40731,19536,3,57,2,4000.00,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(188,7638,58,40731,19536,3,217,1,31130.69,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(189,7638,58,40731,19536,3,68,1,6537.44,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(190,7638,58,40731,19536,3,217,1,1245.23,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(191,7638,58,40731,19536,3,57,2,38913.36,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(192,7638,59,40731,19536,3,217,1,10308.45,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(193,7638,59,40731,19536,3,68,1,2164.78,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(194,7638,59,40731,19536,3,217,1,-0.01,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(195,7638,59,40731,19536,3,57,2,12473.22,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(196,7638,60,40731,19536,3,217,1,609.72,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(197,7638,60,40731,19536,3,68,1,128.04,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(198,7638,60,40731,19536,3,57,2,737.76,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(199,7638,61,40731,19536,3,217,1,239669.42,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(200,7638,61,40731,19536,3,68,1,50330.58,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(201,7638,61,40731,19536,3,57,2,290000.00,NULL,'2022-11-24 13:32:46','2022-11-24 13:32:46',NULL),(202,7638,62,40731,19536,3,217,1,29752.07,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(203,7638,62,40731,19536,3,68,1,6247.93,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(204,7638,62,40731,19536,3,57,2,36000.00,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(205,7638,63,40731,19536,3,217,1,3542.40,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(206,7638,63,40731,19536,3,68,1,743.90,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(207,7638,63,40731,19536,3,57,2,4286.30,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(208,7638,64,40731,19536,3,217,1,29259.90,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL);
INSERT INTO `balance_libro_details` VALUES (209,7638,64,40731,19536,3,68,1,6144.58,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(210,7638,64,40731,19536,3,217,1,1170.40,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(211,7638,64,40731,19536,3,57,2,36574.88,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(212,7638,65,40731,19536,3,250,1,0.00,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(213,7638,65,40731,19536,3,250,1,100000.00,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(214,7638,65,40731,19536,3,57,2,100000.00,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(215,7638,66,40731,19536,3,217,1,49599.36,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(216,7638,66,40731,19536,3,68,1,10415.86,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(217,7638,66,40731,19536,3,217,1,1983.97,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(218,7638,66,40731,19536,3,57,2,61999.19,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(219,7638,67,40731,19536,3,217,1,4312.57,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(220,7638,67,40731,19536,3,68,1,905.64,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(221,7638,67,40731,19536,3,57,2,5218.21,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(222,7638,68,40731,19536,3,217,1,88742.54,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(223,7638,68,40731,19536,3,68,1,18635.92,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(224,7638,68,40731,19536,3,57,2,107378.46,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(225,7638,69,40731,19536,3,250,1,0.00,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(226,7638,69,40731,19536,3,250,1,282280.00,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(227,7638,69,40731,19536,3,57,2,282280.00,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(228,7638,70,40731,19536,3,250,1,150000.00,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(229,7638,70,40731,19536,3,57,2,150000.00,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(230,7638,71,40731,19536,3,217,1,10606.15,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(231,7638,71,40731,19536,3,68,1,2227.29,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(232,7638,71,40731,19536,3,217,1,424.25,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(233,7638,71,40731,19536,3,57,2,13257.69,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(234,7638,72,40731,19536,3,217,1,90526.00,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(235,7638,72,40731,19536,3,68,1,15387.44,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(236,7638,72,40731,19536,3,57,2,105913.44,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(237,7638,73,40731,19536,3,217,1,102182.24,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(238,7638,73,40731,19536,3,68,1,21458.27,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(239,7638,73,40731,19536,3,57,2,123640.51,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(240,7638,74,40731,19536,3,217,1,122681.56,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(241,7638,74,40731,19536,3,68,1,25763.14,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(242,7638,74,40731,19536,3,57,2,148444.70,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(243,7638,75,40731,19536,3,217,2,2395.21,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(244,7638,75,40731,19536,3,67,2,503.00,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(245,7638,75,40731,19536,3,217,2,-0.01,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(246,7638,75,40731,19536,3,57,1,2898.20,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(247,7638,76,40731,19536,3,217,1,12150.89,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(248,7638,76,40731,19536,3,68,1,2551.69,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(249,7638,76,40731,19536,3,217,1,-0.01,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL);
INSERT INTO `balance_libro_details` VALUES (250,7638,76,40731,19536,3,57,2,14702.57,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(251,7638,77,40731,19536,3,217,1,5648.00,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(252,7638,77,40731,19536,3,68,1,1186.08,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(253,7638,77,40731,19536,3,217,1,273.36,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(254,7638,77,40731,19536,3,57,2,7107.44,NULL,'2022-11-24 13:32:47','2022-11-24 13:32:47',NULL),(255,7638,78,40744,40458,2,96,2,82600.00,NULL,'2022-11-24 13:37:43','2022-11-24 13:37:43',NULL),(256,7638,78,40744,40458,2,67,2,17346.00,NULL,'2022-11-24 13:37:43','2022-11-24 13:37:43',NULL),(257,7638,78,40744,40458,2,13,1,99946.00,NULL,'2022-11-24 13:37:43','2022-11-24 13:37:43',NULL),(258,7638,79,40744,40458,2,96,2,107700.00,NULL,'2022-11-24 13:37:44','2022-11-24 13:37:44',NULL),(259,7638,79,40744,40458,2,67,2,22617.00,NULL,'2022-11-24 13:37:44','2022-11-24 13:37:44',NULL),(260,7638,79,40744,40458,2,13,1,130317.00,NULL,'2022-11-24 13:37:44','2022-11-24 13:37:44',NULL),(261,7638,80,40744,40458,2,96,2,215000.00,NULL,'2022-11-24 13:37:44','2022-11-24 13:37:44',NULL),(262,7638,80,40744,40458,2,67,2,45150.00,NULL,'2022-11-24 13:37:44','2022-11-24 13:37:44',NULL),(263,7638,80,40744,40458,2,13,1,260150.00,NULL,'2022-11-24 13:37:44','2022-11-24 13:37:44',NULL),(264,7638,81,40744,40458,2,96,2,47000.00,NULL,'2022-11-24 13:37:44','2022-11-24 13:37:44',NULL),(265,7638,81,40744,40458,2,67,2,9870.00,NULL,'2022-11-24 13:37:44','2022-11-24 13:37:44',NULL),(266,7638,81,40744,40458,2,13,1,56870.00,NULL,'2022-11-24 13:37:44','2022-11-24 13:37:44',NULL),(267,7638,82,40744,40458,2,96,2,152067.00,NULL,'2022-11-24 13:37:44','2022-11-24 13:37:44',NULL),(268,7638,82,40744,40458,2,67,2,31934.07,NULL,'2022-11-24 13:37:44','2022-11-24 13:37:44',NULL),(269,7638,82,40744,40458,2,13,1,184001.07,NULL,'2022-11-24 13:37:44','2022-11-24 13:37:44',NULL),(270,7638,83,40744,40458,3,217,1,971.07,NULL,'2022-11-24 13:38:01','2022-11-24 13:38:01',NULL),(271,7638,83,40744,40458,3,68,1,203.93,NULL,'2022-11-24 13:38:01','2022-11-24 13:38:01',NULL),(272,7638,83,40744,40458,3,57,2,1175.00,NULL,'2022-11-24 13:38:01','2022-11-24 13:38:01',NULL),(273,7638,84,40744,40458,3,217,1,1791.74,NULL,'2022-11-24 13:38:01','2022-11-24 13:38:01',NULL),(274,7638,84,40744,40458,3,68,1,376.26,NULL,'2022-11-24 13:38:01','2022-11-24 13:38:01',NULL),(275,7638,84,40744,40458,3,57,2,2168.00,NULL,'2022-11-24 13:38:01','2022-11-24 13:38:01',NULL),(276,7638,85,40744,40458,3,217,1,2330.00,NULL,'2022-11-24 13:38:01','2022-11-24 13:38:01',NULL),(277,7638,85,40744,40458,3,68,1,489.30,NULL,'2022-11-24 13:38:01','2022-11-24 13:38:01',NULL),(278,7638,85,40744,40458,3,57,2,2819.30,NULL,'2022-11-24 13:38:01','2022-11-24 13:38:01',NULL),(279,7638,86,40744,40458,3,217,1,1528.93,NULL,'2022-11-24 13:38:01','2022-11-24 13:38:01',NULL),(280,7638,86,40744,40458,3,68,1,321.07,NULL,'2022-11-24 13:38:01','2022-11-24 13:38:01',NULL),(281,7638,86,40744,40458,3,57,2,1850.00,NULL,'2022-11-24 13:38:01','2022-11-24 13:38:01',NULL),(282,7638,87,40744,40458,3,217,1,4793.38,NULL,'2022-11-24 13:38:01','2022-11-24 13:38:01',NULL),(283,7638,87,40744,40458,3,68,1,1006.61,NULL,'2022-11-24 13:38:01','2022-11-24 13:38:01',NULL),(284,7638,87,40744,40458,3,217,1,119.83,NULL,'2022-11-24 13:38:01','2022-11-24 13:38:01',NULL),(285,7638,87,40744,40458,3,57,2,5919.82,NULL,'2022-11-24 13:38:01','2022-11-24 13:38:01',NULL),(286,7638,88,40744,40458,3,217,1,1074.38,NULL,'2022-11-24 13:38:01','2022-11-24 13:38:01',NULL),(287,7638,88,40744,40458,3,68,1,225.62,NULL,'2022-11-24 13:38:01','2022-11-24 13:38:01',NULL),(288,7638,88,40744,40458,3,57,2,1300.00,NULL,'2022-11-24 13:38:01','2022-11-24 13:38:01',NULL),(289,7638,89,40744,40458,3,217,1,6197.52,NULL,'2022-11-24 13:38:01','2022-11-24 13:38:01',NULL),(290,7638,89,40744,40458,3,68,1,1301.48,NULL,'2022-11-24 13:38:01','2022-11-24 13:38:01',NULL);
INSERT INTO `balance_libro_details` VALUES (291,7638,89,40744,40458,3,57,2,7499.00,NULL,'2022-11-24 13:38:01','2022-11-24 13:38:01',NULL),(292,7638,90,40732,21058,2,96,2,429119.26,NULL,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(293,7638,90,40732,21058,2,67,2,90115.04,NULL,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(294,7638,90,40732,21058,2,13,1,519234.30,NULL,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(295,7638,91,40732,21058,2,96,2,268338.58,NULL,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(296,7638,91,40732,21058,2,67,2,56351.10,NULL,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(297,7638,91,40732,21058,2,13,1,324689.68,NULL,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(298,7638,92,40732,21058,2,96,2,185136.16,NULL,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(299,7638,92,40732,21058,2,67,2,38878.59,NULL,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(300,7638,92,40732,21058,2,13,1,224014.75,NULL,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(301,7638,93,40732,21058,2,96,2,234386.12,NULL,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(302,7638,93,40732,21058,2,67,2,49221.09,NULL,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(303,7638,93,40732,21058,2,13,1,283607.21,NULL,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(304,7638,94,40732,21058,2,96,2,38612.73,NULL,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(305,7638,94,40732,21058,2,67,2,8108.67,NULL,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(306,7638,94,40732,21058,2,13,1,46721.40,NULL,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(307,7638,95,40732,21058,2,96,2,135549.52,NULL,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(308,7638,95,40732,21058,2,67,2,28465.40,NULL,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(309,7638,95,40732,21058,2,13,1,164014.92,NULL,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(310,7638,96,40732,21058,2,96,2,23324.02,NULL,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(311,7638,96,40732,21058,2,67,2,4898.04,NULL,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(312,7638,96,40732,21058,2,13,1,28222.06,NULL,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(313,7638,97,40732,21058,2,96,2,10383.86,NULL,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(314,7638,97,40732,21058,2,67,2,2180.61,NULL,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(315,7638,97,40732,21058,2,13,1,12564.47,NULL,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(316,7638,98,40732,21058,2,96,2,7187.44,NULL,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(317,7638,98,40732,21058,2,67,2,1509.36,NULL,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(318,7638,98,40732,21058,2,13,1,8696.80,NULL,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(319,7638,99,40732,21058,2,96,2,9922.79,NULL,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(320,7638,99,40732,21058,2,67,2,2083.79,NULL,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(321,7638,99,40732,21058,2,13,1,12006.58,NULL,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(322,7638,100,40732,21058,2,96,2,25262.65,NULL,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(323,7638,100,40732,21058,2,67,2,5305.16,NULL,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(324,7638,100,40732,21058,2,13,1,30567.81,NULL,'2022-11-24 13:41:51','2022-11-24 13:41:51',NULL),(325,7638,101,40732,21058,3,217,1,15445.26,NULL,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(326,7638,101,40732,21058,3,68,1,3079.90,NULL,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(327,7638,101,40732,21058,3,57,2,18525.16,NULL,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(328,7638,102,40732,21058,3,217,1,3048.00,NULL,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(329,7638,102,40732,21058,3,68,1,640.08,NULL,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(330,7638,102,40732,21058,3,57,2,3688.08,NULL,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(331,7638,103,40732,21058,3,217,1,7635.00,NULL,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL);
INSERT INTO `balance_libro_details` VALUES (332,7638,103,40732,21058,3,68,1,1697.91,NULL,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(333,7638,103,40732,21058,3,217,1,458.10,NULL,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(334,7638,103,40732,21058,3,57,2,9791.01,NULL,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(335,7638,104,40732,21058,3,217,1,6833.32,NULL,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(336,7638,104,40732,21058,3,68,1,1435.00,NULL,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(337,7638,104,40732,21058,3,57,2,8268.32,NULL,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(338,7638,105,40732,21058,3,217,1,1092.39,NULL,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(339,7638,105,40732,21058,3,68,1,229.40,NULL,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(340,7638,105,40732,21058,3,217,1,32.77,NULL,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(341,7638,105,40732,21058,3,57,2,1354.56,NULL,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(342,7638,106,40732,21058,3,217,1,3022.73,NULL,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(343,7638,106,40732,21058,3,68,1,634.77,NULL,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(344,7638,106,40732,21058,3,57,2,3657.50,NULL,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(345,7638,107,40732,21058,3,217,1,4578.87,NULL,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(346,7638,107,40732,21058,3,68,1,961.57,NULL,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(347,7638,107,40732,21058,3,57,2,5540.44,NULL,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(348,7638,108,40732,21058,3,217,1,16880.02,NULL,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(349,7638,108,40732,21058,3,68,1,3544.80,NULL,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(350,7638,108,40732,21058,3,57,2,20424.82,NULL,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(351,7638,109,40732,21058,3,250,1,96000.00,NULL,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(352,7638,109,40732,21058,3,57,2,96000.00,NULL,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(353,7638,110,40732,21058,3,217,1,12304.96,NULL,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(354,7638,110,40732,21058,3,68,1,2584.04,NULL,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(355,7638,110,40732,21058,3,57,2,14889.00,NULL,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(356,7638,111,40732,21058,3,217,1,19357.98,NULL,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(357,7638,111,40732,21058,3,68,1,3496.02,NULL,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(358,7638,111,40732,21058,3,57,2,22854.00,NULL,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(359,7638,112,40732,21058,3,217,1,9296.69,NULL,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(360,7638,112,40732,21058,3,68,1,1952.31,NULL,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(361,7638,112,40732,21058,3,57,2,11249.00,NULL,'2022-11-24 13:42:04','2022-11-24 13:42:04',NULL),(362,7638,113,40732,21058,3,217,1,9296.69,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(363,7638,113,40732,21058,3,68,1,1952.31,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(364,7638,113,40732,21058,3,57,2,11249.00,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(365,7638,114,40732,21058,3,217,1,4776.86,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(366,7638,114,40732,21058,3,68,1,1003.14,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(367,7638,114,40732,21058,3,57,2,5780.00,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(368,7638,115,40732,21058,3,217,1,11114.55,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(369,7638,115,40732,21058,3,68,1,2334.05,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(370,7638,115,40732,21058,3,57,2,13448.60,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(371,7638,116,40732,21058,3,217,1,4745.40,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(372,7638,116,40732,21058,3,68,1,996.53,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL);
INSERT INTO `balance_libro_details` VALUES (373,7638,116,40732,21058,3,217,1,142.36,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(374,7638,116,40732,21058,3,57,2,5884.29,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(375,7638,117,40732,21058,3,217,2,16880.02,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(376,7638,117,40732,21058,3,67,2,3544.80,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(377,7638,117,40732,21058,3,57,1,20424.82,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(378,7638,118,40732,21058,3,250,1,0.00,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(379,7638,118,40732,21058,3,250,1,460.00,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(380,7638,118,40732,21058,3,57,2,460.00,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(381,7638,119,40732,21058,3,250,1,0.00,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(382,7638,119,40732,21058,3,250,1,850.00,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(383,7638,119,40732,21058,3,57,2,850.00,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(384,7638,120,40732,21058,3,250,1,0.00,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(385,7638,120,40732,21058,3,250,1,1150.00,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(386,7638,120,40732,21058,3,57,2,1150.00,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(387,7638,121,40732,21058,3,250,2,0.00,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(388,7638,121,40732,21058,3,250,2,1150.00,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(389,7638,121,40732,21058,3,57,1,1150.00,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(390,7638,122,40732,21058,3,217,1,2993.71,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(391,7638,122,40732,21058,3,68,1,628.68,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(392,7638,122,40732,21058,3,217,1,478.81,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(393,7638,122,40732,21058,3,57,2,4101.20,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(394,7638,123,40732,21058,3,217,1,5311.57,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(395,7638,123,40732,21058,3,68,1,1115.42,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(396,7638,123,40732,21058,3,217,1,0.01,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(397,7638,123,40732,21058,3,57,2,6427.00,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(398,7638,124,40732,21058,3,217,1,7055.33,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(399,7638,124,40732,21058,3,68,1,1481.62,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(400,7638,124,40732,21058,3,217,1,211.66,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(401,7638,124,40732,21058,3,57,2,8748.61,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(402,7638,125,40732,21058,3,217,1,9504.13,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(403,7638,125,40732,21058,3,68,1,1995.87,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(404,7638,125,40732,21058,3,57,2,11500.00,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(405,7638,126,40732,21058,3,217,1,0.02,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(406,7638,126,40732,21058,3,57,2,0.02,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(407,7638,127,40732,21058,3,217,1,5079.72,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(408,7638,127,40732,21058,3,68,1,1066.74,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(409,7638,127,40732,21058,3,217,1,152.39,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(410,7638,127,40732,21058,3,57,2,6298.85,NULL,'2022-11-24 13:42:05','2022-11-24 13:42:05',NULL),(411,7638,128,40747,45167,3,217,1,83.98,NULL,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL),(412,7638,128,40747,45167,3,68,1,17.64,NULL,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL),(413,7638,128,40747,45167,3,57,2,101.62,NULL,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL);
INSERT INTO `balance_libro_details` VALUES (414,7638,129,40747,45167,3,217,1,28659.20,NULL,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL),(415,7638,129,40747,45167,3,68,1,6018.43,NULL,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL),(416,7638,129,40747,45167,3,217,1,3116.66,NULL,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL),(417,7638,129,40747,45167,3,57,2,37794.29,NULL,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL),(418,7638,130,40747,45167,3,217,1,31572.95,NULL,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL),(419,7638,130,40747,45167,3,68,1,6630.32,NULL,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL),(420,7638,130,40747,45167,3,57,2,38203.27,NULL,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL),(421,7638,131,40747,45167,3,250,1,96000.00,NULL,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL),(422,7638,131,40747,45167,3,57,2,96000.00,NULL,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL),(423,7638,132,40747,45167,3,217,1,5975.21,NULL,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL),(424,7638,132,40747,45167,3,68,1,1254.79,NULL,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL),(425,7638,132,40747,45167,3,217,1,1320.00,NULL,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL),(426,7638,132,40747,45167,3,57,2,8550.00,NULL,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL),(427,7638,133,40747,45167,3,217,1,11246.02,NULL,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL),(428,7638,133,40747,45167,3,68,1,2361.66,NULL,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL),(429,7638,133,40747,45167,3,57,2,13607.68,NULL,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL),(430,7638,134,40747,45167,3,217,1,6978.86,NULL,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL),(431,7638,134,40747,45167,3,68,1,1644.47,NULL,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL),(432,7638,134,40747,45167,3,217,1,383.84,NULL,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL),(433,7638,134,40747,45167,3,57,2,9007.17,NULL,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL),(434,7638,135,40747,45167,3,217,2,6423.85,NULL,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL),(435,7638,135,40747,45167,3,67,2,1349.01,NULL,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL),(436,7638,135,40747,45167,3,57,1,7772.86,NULL,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL),(437,7638,136,40747,45167,3,217,1,3615.00,NULL,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL),(438,7638,136,40747,45167,3,68,1,759.15,NULL,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL),(439,7638,136,40747,45167,3,217,1,198.83,NULL,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL),(440,7638,136,40747,45167,3,57,2,4572.98,NULL,'2022-11-24 13:49:17','2022-11-24 13:49:17',NULL),(441,7638,137,40736,27281,2,96,2,735.54,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(442,7638,137,40736,27281,2,67,2,154.46,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(443,7638,137,40736,27281,2,13,1,890.00,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(444,7638,138,40736,27281,2,96,2,946.28,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(445,7638,138,40736,27281,2,67,2,198.72,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(446,7638,138,40736,27281,2,13,1,1145.00,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(447,7638,139,40736,27281,2,96,2,809.91,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(448,7638,139,40736,27281,2,67,2,170.09,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(449,7638,139,40736,27281,2,13,1,980.00,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(450,7638,140,40736,27281,2,96,2,599.18,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(451,7638,140,40736,27281,2,67,2,125.82,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(452,7638,140,40736,27281,2,13,1,725.00,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(453,7638,141,40736,27281,2,96,2,809.92,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(454,7638,141,40736,27281,2,67,2,170.08,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL);
INSERT INTO `balance_libro_details` VALUES (455,7638,141,40736,27281,2,13,1,980.00,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(456,7638,142,40736,27281,2,96,2,859.50,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(457,7638,142,40736,27281,2,67,2,180.50,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(458,7638,142,40736,27281,2,13,1,1040.00,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(459,7638,143,40736,27281,2,96,2,801.65,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(460,7638,143,40736,27281,2,67,2,168.35,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(461,7638,143,40736,27281,2,13,1,970.00,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(462,7638,144,40736,27281,2,96,2,880.17,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(463,7638,144,40736,27281,2,67,2,184.83,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(464,7638,144,40736,27281,2,13,1,1065.00,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(465,7638,145,40736,27281,2,96,2,1028.92,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(466,7638,145,40736,27281,2,67,2,216.08,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(467,7638,145,40736,27281,2,13,1,1245.00,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(468,7638,146,40736,27281,2,96,2,759.50,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(469,7638,146,40736,27281,2,67,2,159.50,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(470,7638,146,40736,27281,2,13,1,919.00,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(471,7638,147,40736,27281,2,96,2,995.88,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(472,7638,147,40736,27281,2,67,2,209.12,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(473,7638,147,40736,27281,2,13,1,1205.00,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(474,7638,148,40736,27281,2,96,2,793.38,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(475,7638,148,40736,27281,2,67,2,166.62,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(476,7638,148,40736,27281,2,13,1,960.00,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(477,7638,149,40736,27281,2,96,2,772.72,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(478,7638,149,40736,27281,2,67,2,162.28,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(479,7638,149,40736,27281,2,13,1,935.00,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(480,7638,150,40736,27281,2,96,2,950.41,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(481,7638,150,40736,27281,2,67,2,199.59,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(482,7638,150,40736,27281,2,13,1,1150.00,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(483,7638,151,40736,27281,2,96,2,797.52,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(484,7638,151,40736,27281,2,67,2,167.48,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(485,7638,151,40736,27281,2,13,1,965.00,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(486,7638,152,40736,27281,2,96,2,855.37,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(487,7638,152,40736,27281,2,67,2,179.63,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(488,7638,152,40736,27281,2,13,1,1035.00,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(489,7638,153,40736,27281,2,96,2,876.03,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(490,7638,153,40736,27281,2,67,2,183.97,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(491,7638,153,40736,27281,2,13,1,1060.00,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(492,7638,154,40736,27281,2,96,2,838.84,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(493,7638,154,40736,27281,2,67,2,176.16,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(494,7638,154,40736,27281,2,13,1,1015.00,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(495,7638,155,40736,27281,2,96,2,814.05,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(496,7638,155,40736,27281,2,67,2,170.95,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL);
INSERT INTO `balance_libro_details` VALUES (497,7638,155,40736,27281,2,13,1,985.00,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(498,7638,156,40736,27281,2,96,2,880.17,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(499,7638,156,40736,27281,2,67,2,184.83,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(500,7638,156,40736,27281,2,13,1,1065.00,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(501,7638,157,40736,27281,2,96,2,743.81,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(502,7638,157,40736,27281,2,67,2,156.19,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(503,7638,157,40736,27281,2,13,1,900.00,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(504,7638,158,40736,27281,2,96,2,739.68,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(505,7638,158,40736,27281,2,67,2,155.32,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(506,7638,158,40736,27281,2,13,1,895.00,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(507,7638,159,40736,27281,2,96,2,1008.27,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(508,7638,159,40736,27281,2,67,2,211.73,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(509,7638,159,40736,27281,2,13,1,1220.00,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(510,7638,160,40736,27281,2,96,2,1015.70,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(511,7638,160,40736,27281,2,67,2,213.30,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(512,7638,160,40736,27281,2,13,1,1229.00,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(513,7638,161,40736,27281,2,96,2,805.78,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(514,7638,161,40736,27281,2,67,2,169.22,NULL,'2022-11-24 13:54:29','2022-11-24 13:54:29',NULL),(515,7638,161,40736,27281,2,13,1,975.00,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(516,7638,162,40736,27281,2,96,2,987.60,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(517,7638,162,40736,27281,2,67,2,207.40,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(518,7638,162,40736,27281,2,13,1,1195.00,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(519,7638,163,40736,27281,2,96,2,814.05,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(520,7638,163,40736,27281,2,67,2,170.95,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(521,7638,163,40736,27281,2,13,1,985.00,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(522,7638,164,40736,27281,2,96,2,789.26,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(523,7638,164,40736,27281,2,67,2,165.74,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(524,7638,164,40736,27281,2,13,1,955.00,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(525,7638,165,40736,27281,2,96,2,793.39,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(526,7638,165,40736,27281,2,67,2,166.61,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(527,7638,165,40736,27281,2,13,1,960.00,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(528,7638,166,40736,27281,2,96,2,779.34,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(529,7638,166,40736,27281,2,67,2,163.66,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(530,7638,166,40736,27281,2,13,1,943.00,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(531,7638,167,40736,27281,2,96,2,747.94,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(532,7638,167,40736,27281,2,67,2,157.06,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(533,7638,167,40736,27281,2,13,1,905.00,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(534,7638,168,40736,27281,2,96,2,1028.92,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(535,7638,168,40736,27281,2,67,2,216.08,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(536,7638,168,40736,27281,2,13,1,1245.00,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(537,7638,169,40736,27281,2,96,2,764.46,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(538,7638,169,40736,27281,2,67,2,160.54,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL);
INSERT INTO `balance_libro_details` VALUES (539,7638,169,40736,27281,2,13,1,925.00,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(540,7638,170,40736,27281,2,96,2,830.59,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(541,7638,170,40736,27281,2,67,2,174.41,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(542,7638,170,40736,27281,2,13,1,1005.00,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(543,7638,171,40736,27281,2,96,2,740.05,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(544,7638,171,40736,27281,2,67,2,144.95,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(545,7638,171,40736,27281,2,13,1,885.00,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(546,7638,172,40736,27281,2,96,2,871.90,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(547,7638,172,40736,27281,2,67,2,183.10,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(548,7638,172,40736,27281,2,13,1,1055.00,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(549,7638,173,40736,27281,2,96,2,933.87,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(550,7638,173,40736,27281,2,67,2,196.13,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(551,7638,173,40736,27281,2,13,1,1130.00,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(552,7638,174,40736,27281,2,96,2,867.77,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(553,7638,174,40736,27281,2,67,2,182.23,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(554,7638,174,40736,27281,2,13,1,1050.00,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(555,7638,175,40736,27281,2,96,2,942.15,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(556,7638,175,40736,27281,2,67,2,197.85,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(557,7638,175,40736,27281,2,13,1,1140.00,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(558,7638,176,40736,27281,2,96,2,731.41,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(559,7638,176,40736,27281,2,67,2,153.59,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(560,7638,176,40736,27281,2,13,1,885.00,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(561,7638,177,40736,27281,2,96,2,834.72,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(562,7638,177,40736,27281,2,67,2,175.28,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(563,7638,177,40736,27281,2,13,1,1010.00,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(564,7638,178,40736,27281,2,96,2,946.29,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(565,7638,178,40736,27281,2,67,2,198.71,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(566,7638,178,40736,27281,2,13,1,1145.00,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(567,7638,179,40736,27281,2,96,2,603.31,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(568,7638,179,40736,27281,2,67,2,126.69,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(569,7638,179,40736,27281,2,13,1,730.00,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(570,7638,180,40736,27281,2,96,2,884.30,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(571,7638,180,40736,27281,2,67,2,185.70,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(572,7638,180,40736,27281,2,13,1,1070.00,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(573,7638,181,40736,27281,2,96,2,1024.79,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(574,7638,181,40736,27281,2,67,2,215.21,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(575,7638,181,40736,27281,2,13,1,1240.00,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(576,7638,182,40736,27281,2,96,2,1041.33,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(577,7638,182,40736,27281,2,67,2,218.67,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(578,7638,182,40736,27281,2,13,1,1260.00,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(579,7638,183,40736,27281,2,96,2,710.74,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(580,7638,183,40736,27281,2,67,2,149.26,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL);
INSERT INTO `balance_libro_details` VALUES (581,7638,183,40736,27281,2,13,1,860.00,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(582,7638,184,40736,27281,2,96,2,1041.32,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(583,7638,184,40736,27281,2,67,2,218.68,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(584,7638,184,40736,27281,2,13,1,1260.00,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(585,7638,185,40736,27281,2,96,2,900.83,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(586,7638,185,40736,27281,2,67,2,189.17,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(587,7638,185,40736,27281,2,13,1,1090.00,NULL,'2022-11-24 13:54:30','2022-11-24 13:54:30',NULL),(588,7638,186,40736,27281,2,96,2,975.21,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(589,7638,186,40736,27281,2,67,2,204.79,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(590,7638,186,40736,27281,2,13,1,1180.00,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(591,7638,187,40736,27281,2,96,2,909.10,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(592,7638,187,40736,27281,2,67,2,190.90,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(593,7638,187,40736,27281,2,13,1,1100.00,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(594,7638,188,40736,27281,2,96,2,987.60,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(595,7638,188,40736,27281,2,67,2,207.40,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(596,7638,188,40736,27281,2,13,1,1195.00,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(597,7638,189,40736,27281,2,96,2,731.78,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(598,7638,189,40736,27281,2,67,2,143.22,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(599,7638,189,40736,27281,2,13,1,875.00,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(600,7638,190,40736,27281,2,96,2,1148.78,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(601,7638,190,40736,27281,2,67,2,241.22,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(602,7638,190,40736,27281,2,13,1,1390.00,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(603,7638,191,40736,27281,2,96,2,909.10,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(604,7638,191,40736,27281,2,67,2,190.90,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(605,7638,191,40736,27281,2,13,1,1100.00,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(606,7638,192,40736,27281,2,96,2,1024.79,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(607,7638,192,40736,27281,2,67,2,215.21,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(608,7638,192,40736,27281,2,13,1,1240.00,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(609,7638,193,40736,27281,2,96,2,793.38,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(610,7638,193,40736,27281,2,67,2,166.62,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(611,7638,193,40736,27281,2,13,1,960.00,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(612,7638,194,40736,27281,2,96,2,780.99,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(613,7638,194,40736,27281,2,67,2,164.01,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(614,7638,194,40736,27281,2,13,1,945.00,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(615,7638,195,40736,27281,2,96,2,871.91,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(616,7638,195,40736,27281,2,67,2,183.09,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(617,7638,195,40736,27281,2,13,1,1055.00,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(618,7638,196,40736,27281,2,96,2,925.63,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(619,7638,196,40736,27281,2,67,2,194.37,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(620,7638,196,40736,27281,2,13,1,1120.00,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(621,7638,197,40736,27281,2,96,2,1157.03,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(622,7638,197,40736,27281,2,67,2,242.97,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL);
INSERT INTO `balance_libro_details` VALUES (623,7638,197,40736,27281,2,13,1,1400.00,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(624,7638,198,40736,27281,2,96,2,842.98,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(625,7638,198,40736,27281,2,67,2,177.02,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(626,7638,198,40736,27281,2,13,1,1020.00,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(627,7638,199,40736,27281,2,96,2,859.51,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(628,7638,199,40736,27281,2,67,2,180.49,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(629,7638,199,40736,27281,2,13,1,1040.00,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(630,7638,200,40736,27281,2,96,2,938.02,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(631,7638,200,40736,27281,2,67,2,196.98,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(632,7638,200,40736,27281,2,13,1,1135.00,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(633,7638,201,40736,27281,2,96,2,958.68,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(634,7638,201,40736,27281,2,67,2,201.32,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(635,7638,201,40736,27281,2,13,1,1160.00,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(636,7638,202,40736,27281,2,96,2,681.83,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(637,7638,202,40736,27281,2,67,2,143.17,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(638,7638,202,40736,27281,2,13,1,825.00,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(639,7638,203,40736,27281,2,96,2,739.67,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(640,7638,203,40736,27281,2,67,2,155.33,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(641,7638,203,40736,27281,2,13,1,895.00,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(642,7638,204,40736,27281,2,96,2,954.56,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(643,7638,204,40736,27281,2,67,2,200.44,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(644,7638,204,40736,27281,2,13,1,1155.00,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(645,7638,205,40736,27281,2,96,2,950.41,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(646,7638,205,40736,27281,2,67,2,199.59,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(647,7638,205,40736,27281,2,13,1,1150.00,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(648,7638,206,40736,27281,2,96,2,1069.04,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(649,7638,206,40736,27281,2,67,2,205.96,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(650,7638,206,40736,27281,2,13,1,1275.00,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(651,7638,207,40736,27281,2,96,2,925.62,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(652,7638,207,40736,27281,2,67,2,194.38,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(653,7638,207,40736,27281,2,13,1,1120.00,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(654,7638,208,40736,27281,2,96,2,884.30,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(655,7638,208,40736,27281,2,67,2,185.70,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(656,7638,208,40736,27281,2,13,1,1070.00,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(657,7638,209,40736,27281,2,96,2,888.44,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(658,7638,209,40736,27281,2,67,2,186.56,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(659,7638,209,40736,27281,2,13,1,1075.00,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(660,7638,210,40736,27281,2,96,2,677.68,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(661,7638,210,40736,27281,2,67,2,142.32,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(662,7638,210,40736,27281,2,13,1,820.00,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(663,7638,211,40736,27281,2,96,2,876.03,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(664,7638,211,40736,27281,2,67,2,183.97,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL);
INSERT INTO `balance_libro_details` VALUES (665,7638,211,40736,27281,2,13,1,1060.00,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(666,7638,212,40736,27281,2,96,2,851.23,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(667,7638,212,40736,27281,2,67,2,178.77,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(668,7638,212,40736,27281,2,13,1,1030.00,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(669,7638,213,40736,27281,2,96,2,1033.06,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(670,7638,213,40736,27281,2,67,2,216.94,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(671,7638,213,40736,27281,2,13,1,1250.00,NULL,'2022-11-24 13:54:31','2022-11-24 13:54:31',NULL),(672,7638,214,40736,27281,2,96,2,701.27,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(673,7638,214,40736,27281,2,67,2,128.73,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(674,7638,214,40736,27281,2,13,1,830.00,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(675,7638,215,40736,27281,2,96,2,735.54,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(676,7638,215,40736,27281,2,67,2,154.46,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(677,7638,215,40736,27281,2,13,1,890.00,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(678,7638,216,40736,27281,2,96,2,896.69,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(679,7638,216,40736,27281,2,67,2,188.31,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(680,7638,216,40736,27281,2,13,1,1085.00,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(681,7638,217,40736,27281,2,96,2,855.37,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(682,7638,217,40736,27281,2,67,2,179.63,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(683,7638,217,40736,27281,2,13,1,1035.00,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(684,7638,218,40736,27281,2,96,2,933.90,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(685,7638,218,40736,27281,2,67,2,196.10,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(686,7638,218,40736,27281,2,13,1,1130.00,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(687,7638,219,40736,27281,2,96,2,1099.17,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(688,7638,219,40736,27281,2,67,2,230.83,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(689,7638,219,40736,27281,2,13,1,1330.00,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(690,7638,220,40736,27281,2,96,2,925.62,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(691,7638,220,40736,27281,2,67,2,194.38,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(692,7638,220,40736,27281,2,13,1,1120.00,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(693,7638,221,40736,27281,2,96,2,1107.45,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(694,7638,221,40736,27281,2,67,2,232.55,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(695,7638,221,40736,27281,2,13,1,1340.00,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(696,7638,222,40736,27281,2,96,2,1024.80,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(697,7638,222,40736,27281,2,67,2,215.20,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(698,7638,222,40736,27281,2,13,1,1240.00,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(699,7638,223,40736,27281,2,96,2,743.19,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(700,7638,223,40736,27281,2,67,2,141.81,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(701,7638,223,40736,27281,2,13,1,885.00,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(702,7638,224,40736,27281,2,96,2,1024.81,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(703,7638,224,40736,27281,2,67,2,215.19,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(704,7638,224,40736,27281,2,13,1,1240.00,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(705,7638,225,40736,27281,2,96,2,830.58,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(706,7638,225,40736,27281,2,67,2,174.42,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL);
INSERT INTO `balance_libro_details` VALUES (707,7638,225,40736,27281,2,13,1,1005.00,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(708,7638,226,40736,27281,2,96,2,855.38,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(709,7638,226,40736,27281,2,67,2,179.62,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(710,7638,226,40736,27281,2,13,1,1035.00,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(711,7638,227,40736,27281,2,96,2,888.43,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(712,7638,227,40736,27281,2,67,2,186.57,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(713,7638,227,40736,27281,2,13,1,1075.00,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(714,7638,228,40736,27281,2,96,2,896.70,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(715,7638,228,40736,27281,2,67,2,188.30,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(716,7638,228,40736,27281,2,13,1,1085.00,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(717,7638,229,40736,27281,2,96,2,918.19,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(718,7638,229,40736,27281,2,67,2,192.81,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(719,7638,229,40736,27281,2,13,1,1111.00,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(720,7638,230,40736,27281,2,96,2,987.61,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(721,7638,230,40736,27281,2,67,2,207.39,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(722,7638,230,40736,27281,2,13,1,1195.00,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(723,7638,231,40736,27281,2,96,2,776.86,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(724,7638,231,40736,27281,2,67,2,163.14,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(725,7638,231,40736,27281,2,13,1,940.00,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(726,7638,232,40736,27281,2,96,2,888.43,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(727,7638,232,40736,27281,2,67,2,186.57,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(728,7638,232,40736,27281,2,13,1,1075.00,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(729,7638,233,40736,27281,2,96,2,659.94,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(730,7638,233,40736,27281,2,67,2,120.06,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(731,7638,233,40736,27281,2,13,1,780.00,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(732,7638,234,40736,27281,2,96,2,966.95,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(733,7638,234,40736,27281,2,67,2,203.05,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(734,7638,234,40736,27281,2,13,1,1170.00,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(735,7638,235,40736,27281,2,96,2,1028.92,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(736,7638,235,40736,27281,2,67,2,216.08,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(737,7638,235,40736,27281,2,13,1,1245.00,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(738,7638,236,40736,27281,2,96,2,966.33,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(739,7638,236,40736,27281,2,67,2,188.67,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(740,7638,236,40736,27281,2,13,1,1155.00,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(741,7638,237,40736,27281,2,96,2,921.49,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(742,7638,237,40736,27281,2,67,2,193.51,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(743,7638,237,40736,27281,2,13,1,1115.00,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(744,7638,238,40736,27281,2,96,2,938.03,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(745,7638,238,40736,27281,2,67,2,196.97,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(746,7638,238,40736,27281,2,13,1,1135.00,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(747,7638,239,40736,27281,2,96,2,834.70,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(748,7638,239,40736,27281,2,67,2,175.30,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL);
INSERT INTO `balance_libro_details` VALUES (749,7638,239,40736,27281,2,13,1,1010.00,NULL,'2022-11-24 13:54:32','2022-11-24 13:54:32',NULL),(750,7638,240,40736,27281,2,96,2,830.59,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(751,7638,240,40736,27281,2,67,2,174.41,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(752,7638,240,40736,27281,2,13,1,1005.00,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(753,7638,241,40736,27281,2,96,2,971.08,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(754,7638,241,40736,27281,2,67,2,203.92,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(755,7638,241,40736,27281,2,13,1,1175.00,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(756,7638,242,40736,27281,2,96,2,977.69,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(757,7638,242,40736,27281,2,67,2,205.31,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(758,7638,242,40736,27281,2,13,1,1183.00,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(759,7638,243,40736,27281,2,96,2,1012.41,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(760,7638,243,40736,27281,2,67,2,212.59,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(761,7638,243,40736,27281,2,13,1,1225.00,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(762,7638,244,40736,27281,2,96,2,1148.76,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(763,7638,244,40736,27281,2,67,2,241.24,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(764,7638,244,40736,27281,2,13,1,1390.00,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(765,7638,245,40736,27281,2,96,2,1019.45,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(766,7638,245,40736,27281,2,67,2,195.55,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(767,7638,245,40736,27281,2,13,1,1215.00,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(768,7638,246,40736,27281,2,96,2,793.39,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(769,7638,246,40736,27281,2,67,2,166.61,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(770,7638,246,40736,27281,2,13,1,960.00,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(771,7638,247,40736,27281,2,96,2,1177.69,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(772,7638,247,40736,27281,2,67,2,247.31,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(773,7638,247,40736,27281,2,13,1,1425.00,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(774,7638,248,40736,27281,2,96,2,987.61,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(775,7638,248,40736,27281,2,67,2,207.39,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(776,7638,248,40736,27281,2,13,1,1195.00,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(777,7638,249,40736,27281,2,96,2,933.87,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(778,7638,249,40736,27281,2,67,2,196.13,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(779,7638,249,40736,27281,2,13,1,1130.00,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(780,7638,250,40736,27281,2,96,2,1173.55,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(781,7638,250,40736,27281,2,67,2,246.45,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(782,7638,250,40736,27281,2,13,1,1420.00,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(783,7638,251,40736,27281,2,96,2,1090.91,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(784,7638,251,40736,27281,2,67,2,229.09,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(785,7638,251,40736,27281,2,13,1,1320.00,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(786,7638,252,40736,27281,2,96,2,958.69,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(787,7638,252,40736,27281,2,67,2,201.31,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(788,7638,252,40736,27281,2,13,1,1160.00,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(789,7638,253,40736,27281,2,96,2,1012.40,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL);
INSERT INTO `balance_libro_details` VALUES (790,7638,253,40736,27281,2,67,2,212.60,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(791,7638,253,40736,27281,2,13,1,1225.00,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(792,7638,254,40736,27281,2,96,2,1061.98,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(793,7638,254,40736,27281,2,67,2,223.02,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(794,7638,254,40736,27281,2,13,1,1285.00,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(795,7638,255,40736,27281,2,96,2,1140.49,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(796,7638,255,40736,27281,2,67,2,239.51,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(797,7638,255,40736,27281,2,13,1,1380.00,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(798,7638,256,40736,27281,2,96,2,924.79,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(799,7638,256,40736,27281,2,67,2,194.21,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(800,7638,256,40736,27281,2,13,1,1119.00,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(801,7638,257,40736,27281,2,96,2,1088.70,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(802,7638,257,40736,27281,2,67,2,206.30,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(803,7638,257,40736,27281,2,13,1,1295.00,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(804,7638,258,40736,27281,2,96,2,1161.16,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(805,7638,258,40736,27281,2,67,2,243.84,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(806,7638,258,40736,27281,2,13,1,1405.00,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(807,7638,259,40736,27281,2,96,2,930.90,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(808,7638,259,40736,27281,2,67,2,174.10,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(809,7638,259,40736,27281,2,13,1,1105.00,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(810,7638,260,40736,27281,2,96,2,1144.63,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(811,7638,260,40736,27281,2,67,2,240.37,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(812,7638,260,40736,27281,2,13,1,1385.00,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(813,7638,261,40736,27281,2,96,2,818.18,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(814,7638,261,40736,27281,2,67,2,171.82,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(815,7638,261,40736,27281,2,13,1,990.00,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(816,7638,262,40736,27281,2,96,2,1088.70,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(817,7638,262,40736,27281,2,67,2,206.30,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(818,7638,262,40736,27281,2,13,1,1295.00,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(819,7638,263,40736,27281,2,96,2,884.29,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(820,7638,263,40736,27281,2,67,2,185.71,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(821,7638,263,40736,27281,2,13,1,1070.00,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(822,7638,264,40736,27281,2,96,2,880.18,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(823,7638,264,40736,27281,2,67,2,184.82,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(824,7638,264,40736,27281,2,13,1,1065.00,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(825,7638,265,40736,27281,2,96,2,1000.01,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(826,7638,265,40736,27281,2,67,2,209.99,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(827,7638,265,40736,27281,2,13,1,1210.00,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(828,7638,266,40736,27281,2,96,2,1082.65,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(829,7638,266,40736,27281,2,67,2,227.35,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(830,7638,266,40736,27281,2,13,1,1310.00,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL);
INSERT INTO `balance_libro_details` VALUES (831,7638,267,40736,27281,2,96,2,1063.51,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(832,7638,267,40736,27281,2,67,2,201.49,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(833,7638,267,40736,27281,2,13,1,1265.00,NULL,'2022-11-24 13:54:33','2022-11-24 13:54:33',NULL),(834,7638,268,40736,27281,2,96,2,760.33,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(835,7638,268,40736,27281,2,67,2,159.67,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(836,7638,268,40736,27281,2,13,1,920.00,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(837,7638,269,40736,27281,2,96,2,1062.00,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(838,7638,269,40736,27281,2,67,2,223.00,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(839,7638,269,40736,27281,2,13,1,1285.00,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(840,7638,270,40736,27281,2,96,2,958.68,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(841,7638,270,40736,27281,2,67,2,201.32,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(842,7638,270,40736,27281,2,13,1,1160.00,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(843,7638,271,40736,27281,2,96,2,1016.53,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(844,7638,271,40736,27281,2,67,2,213.47,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(845,7638,271,40736,27281,2,13,1,1230.00,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(846,7638,272,40736,27281,2,96,2,966.94,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(847,7638,272,40736,27281,2,67,2,203.06,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(848,7638,272,40736,27281,2,13,1,1170.00,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(849,7638,273,40736,27281,2,96,2,1037.20,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(850,7638,273,40736,27281,2,67,2,217.80,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(851,7638,273,40736,27281,2,13,1,1255.00,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(852,7638,274,40736,27281,2,96,2,1133.77,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(853,7638,274,40736,27281,2,67,2,216.23,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(854,7638,274,40736,27281,2,13,1,1350.00,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(855,7638,275,40736,27281,2,96,2,1020.66,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(856,7638,275,40736,27281,2,67,2,214.34,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(857,7638,275,40736,27281,2,13,1,1235.00,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(858,7638,276,40736,27281,2,96,2,829.35,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(859,7638,276,40736,27281,2,67,2,155.65,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(860,7638,276,40736,27281,2,13,1,985.00,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(861,7638,277,40736,27281,2,96,2,1009.79,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(862,7638,277,40736,27281,2,67,2,190.21,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(863,7638,277,40736,27281,2,13,1,1200.00,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(864,7638,278,40736,27281,2,96,2,1020.67,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(865,7638,278,40736,27281,2,67,2,214.33,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(866,7638,278,40736,27281,2,13,1,1235.00,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(867,7638,279,40736,27281,2,96,2,1003.30,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(868,7638,279,40736,27281,2,67,2,210.70,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(869,7638,279,40736,27281,2,13,1,1214.00,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(870,7638,280,40736,27281,2,96,2,838.84,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(871,7638,280,40736,27281,2,67,2,176.16,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL);
INSERT INTO `balance_libro_details` VALUES (872,7638,280,40736,27281,2,13,1,1015.00,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(873,7638,281,40736,27281,2,96,2,1086.78,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(874,7638,281,40736,27281,2,67,2,228.22,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(875,7638,281,40736,27281,2,13,1,1315.00,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(876,7638,282,40736,27281,2,96,2,842.98,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(877,7638,282,40736,27281,2,67,2,177.02,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(878,7638,282,40736,27281,2,13,1,1020.00,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(879,7638,283,40736,27281,2,96,2,876.03,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(880,7638,283,40736,27281,2,67,2,183.97,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(881,7638,283,40736,27281,2,13,1,1060.00,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(882,7638,284,40736,27281,2,96,2,1223.13,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(883,7638,284,40736,27281,2,67,2,256.87,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(884,7638,284,40736,27281,2,13,1,1480.00,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(885,7638,285,40736,27281,2,96,2,785.11,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(886,7638,285,40736,27281,2,67,2,164.89,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(887,7638,285,40736,27281,2,13,1,950.00,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(888,7638,286,40736,27281,2,96,2,760.33,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(889,7638,286,40736,27281,2,67,2,159.67,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(890,7638,286,40736,27281,2,13,1,920.00,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(891,7638,287,40736,27281,2,96,2,1078.52,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(892,7638,287,40736,27281,2,67,2,226.48,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(893,7638,287,40736,27281,2,13,1,1305.00,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(894,7638,288,40736,27281,2,96,2,1037.20,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(895,7638,288,40736,27281,2,67,2,217.80,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(896,7638,288,40736,27281,2,13,1,1255.00,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(897,7638,289,40736,27281,2,96,2,966.95,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(898,7638,289,40736,27281,2,67,2,203.05,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(899,7638,289,40736,27281,2,13,1,1170.00,NULL,'2022-11-24 13:54:34','2022-11-24 13:54:34',NULL),(900,7638,290,40736,27281,2,96,2,1016.53,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(901,7638,290,40736,27281,2,67,2,213.47,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(902,7638,290,40736,27281,2,13,1,1230.00,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(903,7638,291,40736,27281,2,96,2,701.88,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(904,7638,291,40736,27281,2,67,2,133.12,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(905,7638,291,40736,27281,2,13,1,835.00,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(906,7638,292,40736,27281,2,96,2,1008.26,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(907,7638,292,40736,27281,2,67,2,211.74,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(908,7638,292,40736,27281,2,13,1,1220.00,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(909,7638,293,40736,27281,2,96,2,1140.50,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(910,7638,293,40736,27281,2,67,2,239.50,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(911,7638,293,40736,27281,2,13,1,1380.00,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(912,7638,294,40736,27281,2,96,2,979.35,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL);
INSERT INTO `balance_libro_details` VALUES (913,7638,294,40736,27281,2,67,2,205.65,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(914,7638,294,40736,27281,2,13,1,1185.00,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(915,7638,295,40736,27281,2,96,2,1008.26,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(916,7638,295,40736,27281,2,67,2,211.74,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(917,7638,295,40736,27281,2,13,1,1220.00,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(918,7638,296,40736,27281,2,96,2,719.01,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(919,7638,296,40736,27281,2,67,2,150.99,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(920,7638,296,40736,27281,2,13,1,870.00,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(921,7638,297,40736,27281,2,96,2,830.58,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(922,7638,297,40736,27281,2,67,2,174.42,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(923,7638,297,40736,27281,2,13,1,1005.00,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(924,7638,298,40736,27281,2,96,2,933.89,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(925,7638,298,40736,27281,2,67,2,196.11,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(926,7638,298,40736,27281,2,13,1,1130.00,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(927,7638,299,40736,27281,2,96,2,851.25,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(928,7638,299,40736,27281,2,67,2,178.75,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(929,7638,299,40736,27281,2,13,1,1030.00,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(930,7638,300,40736,27281,2,96,2,1049.59,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(931,7638,300,40736,27281,2,67,2,220.41,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(932,7638,300,40736,27281,2,13,1,1270.00,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(933,7638,301,40736,27281,2,96,2,668.21,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(934,7638,301,40736,27281,2,67,2,121.79,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(935,7638,301,40736,27281,2,13,1,790.00,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(936,7638,302,40736,27281,2,96,2,1045.45,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(937,7638,302,40736,27281,2,67,2,219.55,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(938,7638,302,40736,27281,2,13,1,1265.00,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(939,7638,303,40736,27281,2,96,2,1016.52,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(940,7638,303,40736,27281,2,67,2,213.48,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(941,7638,303,40736,27281,2,13,1,1230.00,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(942,7638,304,40736,27281,2,96,2,1206.61,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(943,7638,304,40736,27281,2,67,2,253.39,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(944,7638,304,40736,27281,2,13,1,1460.00,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(945,7638,305,40736,27281,2,96,2,727.27,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(946,7638,305,40736,27281,2,67,2,152.73,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(947,7638,305,40736,27281,2,13,1,880.00,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(948,7638,306,40736,27281,2,96,2,896.70,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(949,7638,306,40736,27281,2,67,2,188.30,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(950,7638,306,40736,27281,2,13,1,1085.00,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(951,7638,307,40736,27281,2,96,2,913.23,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(952,7638,307,40736,27281,2,67,2,191.77,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(953,7638,307,40736,27281,2,13,1,1105.00,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(954,7638,308,40736,27281,2,96,2,748.76,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL);
INSERT INTO `balance_libro_details` VALUES (955,7638,308,40736,27281,2,67,2,157.24,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(956,7638,308,40736,27281,2,13,1,906.00,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(957,7638,309,40736,27281,2,96,2,1037.19,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(958,7638,309,40736,27281,2,67,2,217.81,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(959,7638,309,40736,27281,2,13,1,1255.00,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(960,7638,310,40736,27281,2,96,2,1140.50,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(961,7638,310,40736,27281,2,67,2,239.50,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(962,7638,310,40736,27281,2,13,1,1380.00,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(963,7638,311,40736,27281,2,96,2,801.66,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(964,7638,311,40736,27281,2,67,2,168.34,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(965,7638,311,40736,27281,2,13,1,970.00,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(966,7638,312,40736,27281,2,96,2,917.35,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(967,7638,312,40736,27281,2,67,2,192.65,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(968,7638,312,40736,27281,2,13,1,1110.00,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(969,7638,313,40736,27281,2,96,2,818.20,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(970,7638,313,40736,27281,2,67,2,171.80,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(971,7638,313,40736,27281,2,13,1,990.00,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(972,7638,314,40736,27281,2,96,2,859.49,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(973,7638,314,40736,27281,2,67,2,180.51,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(974,7638,314,40736,27281,2,13,1,1040.00,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(975,7638,315,40736,27281,2,96,2,962.81,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(976,7638,315,40736,27281,2,67,2,202.19,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(977,7638,315,40736,27281,2,13,1,1165.00,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(978,7638,316,40736,27281,2,96,2,1045.46,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(979,7638,316,40736,27281,2,67,2,219.54,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(980,7638,316,40736,27281,2,13,1,1265.00,NULL,'2022-11-24 13:54:35','2022-11-24 13:54:35',NULL),(981,7638,317,40736,27281,2,96,2,925.61,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(982,7638,317,40736,27281,2,67,2,194.39,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(983,7638,317,40736,27281,2,13,1,1120.00,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(984,7638,318,40736,27281,2,96,2,839.67,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(985,7638,318,40736,27281,2,67,2,176.33,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(986,7638,318,40736,27281,2,13,1,1016.00,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(987,7638,319,40736,27281,2,96,2,771.52,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(988,7638,319,40736,27281,2,67,2,143.48,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(989,7638,319,40736,27281,2,13,1,915.00,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(990,7638,320,40736,27281,2,96,2,1078.51,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(991,7638,320,40736,27281,2,67,2,226.49,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(992,7638,320,40736,27281,2,13,1,1305.00,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(993,7638,321,40736,27281,2,96,2,950.41,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(994,7638,321,40736,27281,2,67,2,199.59,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(995,7638,321,40736,27281,2,13,1,1150.00,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(996,7638,322,40736,27281,2,96,2,731.40,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL);
INSERT INTO `balance_libro_details` VALUES (997,7638,322,40736,27281,2,67,2,153.60,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(998,7638,322,40736,27281,2,13,1,885.00,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(999,7638,323,40736,27281,2,96,2,986.77,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1000,7638,323,40736,27281,2,67,2,207.23,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1001,7638,323,40736,27281,2,13,1,1194.00,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1002,7638,324,40736,27281,2,96,2,1206.63,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1003,7638,324,40736,27281,2,67,2,253.37,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1004,7638,324,40736,27281,2,13,1,1460.00,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1005,7638,325,40736,27281,2,96,2,1024.79,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1006,7638,325,40736,27281,2,67,2,215.21,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1007,7638,325,40736,27281,2,13,1,1240.00,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1008,7638,326,40736,27281,2,96,2,1115.70,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1009,7638,326,40736,27281,2,67,2,234.30,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1010,7638,326,40736,27281,2,13,1,1350.00,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1011,7638,327,40736,27281,2,96,2,1004.13,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1012,7638,327,40736,27281,2,67,2,210.87,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1013,7638,327,40736,27281,2,13,1,1215.00,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1014,7638,328,40736,27281,2,96,2,958.68,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1015,7638,328,40736,27281,2,67,2,201.32,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1016,7638,328,40736,27281,2,13,1,1160.00,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1017,7638,329,40736,27281,2,96,2,1231.42,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1018,7638,329,40736,27281,2,67,2,258.58,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1019,7638,329,40736,27281,2,13,1,1490.00,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1020,7638,330,40736,27281,2,96,2,958.68,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1021,7638,330,40736,27281,2,67,2,201.32,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1022,7638,330,40736,27281,2,13,1,1160.00,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1023,7638,331,40736,27281,2,96,2,942.13,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1024,7638,331,40736,27281,2,67,2,197.87,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1025,7638,331,40736,27281,2,13,1,1140.00,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1026,7638,332,40736,27281,2,96,2,855.38,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1027,7638,332,40736,27281,2,67,2,179.62,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1028,7638,332,40736,27281,2,13,1,1035.00,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1029,7638,333,40736,27281,2,96,2,825.24,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1030,7638,333,40736,27281,2,67,2,154.76,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1031,7638,333,40736,27281,2,13,1,980.00,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1032,7638,334,40736,27281,2,96,2,875.42,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1033,7638,334,40736,27281,2,67,2,169.58,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1034,7638,334,40736,27281,2,13,1,1045.00,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1035,7638,335,40736,27281,2,96,2,933.88,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1036,7638,335,40736,27281,2,67,2,196.12,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1037,7638,335,40736,27281,2,13,1,1130.00,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL);
INSERT INTO `balance_libro_details` VALUES (1038,7638,336,40736,27281,2,96,2,929.75,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1039,7638,336,40736,27281,2,67,2,195.25,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1040,7638,336,40736,27281,2,13,1,1125.00,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1041,7638,337,40736,27281,2,96,2,983.46,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1042,7638,337,40736,27281,2,67,2,206.54,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1043,7638,337,40736,27281,2,13,1,1190.00,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1044,7638,338,40736,27281,2,96,2,818.19,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1045,7638,338,40736,27281,2,67,2,171.81,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1046,7638,338,40736,27281,2,13,1,990.00,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1047,7638,339,40736,27281,2,96,2,867.77,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1048,7638,339,40736,27281,2,67,2,182.23,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1049,7638,339,40736,27281,2,13,1,1050.00,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1050,7638,340,40736,27281,2,96,2,954.54,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1051,7638,340,40736,27281,2,67,2,200.46,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1052,7638,340,40736,27281,2,13,1,1155.00,NULL,'2022-11-24 13:54:36','2022-11-24 13:54:36',NULL),(1053,7638,341,40736,27281,2,96,2,710.74,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1054,7638,341,40736,27281,2,67,2,149.26,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1055,7638,341,40736,27281,2,13,1,860.00,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1056,7638,342,40736,27281,2,96,2,859.51,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1057,7638,342,40736,27281,2,67,2,180.49,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1058,7638,342,40736,27281,2,13,1,1040.00,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1059,7638,343,40736,27281,2,96,2,931.68,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1060,7638,343,40736,27281,2,67,2,173.32,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1061,7638,343,40736,27281,2,13,1,1105.00,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1062,7638,344,40736,27281,2,96,2,809.91,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1063,7638,344,40736,27281,2,67,2,170.09,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1064,7638,344,40736,27281,2,13,1,980.00,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1065,7638,345,40736,27281,2,96,2,719.02,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1066,7638,345,40736,27281,2,67,2,150.98,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1067,7638,345,40736,27281,2,13,1,870.00,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1068,7638,346,40736,27281,2,96,2,1049.58,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1069,7638,346,40736,27281,2,67,2,220.42,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1070,7638,346,40736,27281,2,13,1,1270.00,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1071,7638,347,40736,27281,2,96,2,909.09,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1072,7638,347,40736,27281,2,67,2,190.91,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1073,7638,347,40736,27281,2,13,1,1100.00,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1074,7638,348,40736,27281,2,96,2,958.68,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1075,7638,348,40736,27281,2,67,2,201.32,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1076,7638,348,40736,27281,2,13,1,1160.00,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1077,7638,349,40736,27281,2,96,2,768.59,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1078,7638,349,40736,27281,2,67,2,161.41,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL);
INSERT INTO `balance_libro_details` VALUES (1079,7638,349,40736,27281,2,13,1,930.00,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1080,7638,350,40736,27281,2,96,2,1090.91,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1081,7638,350,40736,27281,2,67,2,229.09,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1082,7638,350,40736,27281,2,13,1,1320.00,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1083,7638,351,40736,27281,2,96,2,785.12,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1084,7638,351,40736,27281,2,67,2,164.88,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1085,7638,351,40736,27281,2,13,1,950.00,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1086,7638,352,40736,27281,2,96,2,975.20,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1087,7638,352,40736,27281,2,67,2,204.80,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1088,7638,352,40736,27281,2,13,1,1180.00,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1089,7638,353,40736,27281,2,96,2,727.27,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1090,7638,353,40736,27281,2,67,2,152.73,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1091,7638,353,40736,27281,2,13,1,880.00,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1092,7638,354,40736,27281,2,96,2,942.15,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1093,7638,354,40736,27281,2,67,2,197.85,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1094,7638,354,40736,27281,2,13,1,1140.00,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1095,7638,355,40736,27281,2,96,2,950.41,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1096,7638,355,40736,27281,2,67,2,199.59,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1097,7638,355,40736,27281,2,13,1,1150.00,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1098,7638,356,40736,27281,2,96,2,867.76,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1099,7638,356,40736,27281,2,67,2,182.24,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1100,7638,356,40736,27281,2,13,1,1050.00,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1101,7638,357,40736,27281,2,96,2,975.21,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1102,7638,357,40736,27281,2,67,2,204.79,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1103,7638,357,40736,27281,2,13,1,1180.00,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1104,7638,358,40736,27281,2,96,2,867.76,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1105,7638,358,40736,27281,2,67,2,182.24,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1106,7638,358,40736,27281,2,13,1,1050.00,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1107,7638,359,40736,27281,2,96,2,1181.82,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1108,7638,359,40736,27281,2,67,2,248.18,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1109,7638,359,40736,27281,2,13,1,1430.00,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1110,7638,360,40736,27281,2,96,2,805.79,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1111,7638,360,40736,27281,2,67,2,169.21,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1112,7638,360,40736,27281,2,13,1,975.00,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1113,7638,361,40736,27281,2,96,2,1123.97,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1114,7638,361,40736,27281,2,67,2,236.03,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1115,7638,361,40736,27281,2,13,1,1360.00,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1116,7638,362,40736,27281,2,96,2,966.94,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1117,7638,362,40736,27281,2,67,2,203.06,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1118,7638,362,40736,27281,2,13,1,1170.00,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1119,7638,363,40736,27281,2,96,2,1016.53,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL);
INSERT INTO `balance_libro_details` VALUES (1120,7638,363,40736,27281,2,67,2,213.47,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1121,7638,363,40736,27281,2,13,1,1230.00,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1122,7638,364,40736,27281,2,96,2,775.63,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1123,7638,364,40736,27281,2,67,2,144.37,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1124,7638,364,40736,27281,2,13,1,920.00,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1125,7638,365,40736,27281,2,96,2,1074.38,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1126,7638,365,40736,27281,2,67,2,225.62,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1127,7638,365,40736,27281,2,13,1,1300.00,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1128,7638,366,40736,27281,2,96,2,888.43,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1129,7638,366,40736,27281,2,67,2,186.57,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1130,7638,366,40736,27281,2,13,1,1075.00,NULL,'2022-11-24 13:54:37','2022-11-24 13:54:37',NULL),(1131,7638,367,40736,27281,2,96,2,1223.13,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1132,7638,367,40736,27281,2,67,2,256.87,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1133,7638,367,40736,27281,2,13,1,1480.00,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1134,7638,368,40736,27281,2,96,2,1309.91,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1135,7638,368,40736,27281,2,67,2,275.09,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1136,7638,368,40736,27281,2,13,1,1585.00,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1137,7638,369,40736,27281,2,96,2,768.60,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1138,7638,369,40736,27281,2,67,2,161.40,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1139,7638,369,40736,27281,2,13,1,930.00,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1140,7638,370,40736,27281,2,96,2,987.20,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1141,7638,370,40736,27281,2,67,2,197.80,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1142,7638,370,40736,27281,2,13,1,1185.00,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1143,7638,371,40736,27281,2,96,2,735.53,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1144,7638,371,40736,27281,2,67,2,154.47,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1145,7638,371,40736,27281,2,13,1,890.00,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1146,7638,372,40736,27281,2,96,2,842.96,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1147,7638,372,40736,27281,2,67,2,177.04,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1148,7638,372,40736,27281,2,13,1,1020.00,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1149,7638,373,40736,27281,2,96,2,966.95,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1150,7638,373,40736,27281,2,67,2,203.05,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1151,7638,373,40736,27281,2,13,1,1170.00,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1152,7638,374,40736,27281,2,96,2,946.29,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1153,7638,374,40736,27281,2,67,2,198.71,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1154,7638,374,40736,27281,2,13,1,1145.00,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1155,7638,375,40736,27281,2,96,2,1016.53,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1156,7638,375,40736,27281,2,67,2,213.47,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1157,7638,375,40736,27281,2,13,1,1230.00,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1158,7638,376,40736,27281,2,96,2,768.59,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1159,7638,376,40736,27281,2,67,2,161.41,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1160,7638,376,40736,27281,2,13,1,930.00,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL);
INSERT INTO `balance_libro_details` VALUES (1161,7638,377,40736,27281,2,96,2,743.80,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1162,7638,377,40736,27281,2,67,2,156.20,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1163,7638,377,40736,27281,2,13,1,900.00,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1164,7638,378,40736,27281,2,96,2,793.39,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1165,7638,378,40736,27281,2,67,2,166.61,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1166,7638,378,40736,27281,2,13,1,960.00,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1167,7638,379,40736,27281,2,96,2,785.13,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1168,7638,379,40736,27281,2,67,2,164.87,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1169,7638,379,40736,27281,2,13,1,950.00,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1170,7638,380,40736,27281,2,96,2,925.62,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1171,7638,380,40736,27281,2,67,2,194.38,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1172,7638,380,40736,27281,2,13,1,1120.00,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1173,7638,381,40736,27281,2,96,2,1045.45,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1174,7638,381,40736,27281,2,67,2,219.55,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1175,7638,381,40736,27281,2,13,1,1265.00,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1176,7638,382,40736,27281,2,96,2,1210.75,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1177,7638,382,40736,27281,2,67,2,254.25,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1178,7638,382,40736,27281,2,13,1,1465.00,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1179,7638,383,40736,27281,2,96,2,938.02,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1180,7638,383,40736,27281,2,67,2,196.98,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1181,7638,383,40736,27281,2,13,1,1135.00,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1182,7638,384,40736,27281,2,96,2,966.94,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1183,7638,384,40736,27281,2,67,2,203.06,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1184,7638,384,40736,27281,2,13,1,1170.00,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1185,7638,385,40736,27281,2,96,2,1214.87,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1186,7638,385,40736,27281,2,67,2,255.13,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1187,7638,385,40736,27281,2,13,1,1470.00,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1188,7638,386,40736,27281,2,96,2,676.47,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1189,7638,386,40736,27281,2,67,2,123.53,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1190,7638,386,40736,27281,2,13,1,800.00,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1191,7638,387,40736,27281,2,96,2,1115.69,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1192,7638,387,40736,27281,2,67,2,234.31,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1193,7638,387,40736,27281,2,13,1,1350.00,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1194,7638,388,40736,27281,2,96,2,892.55,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1195,7638,388,40736,27281,2,67,2,187.45,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1196,7638,388,40736,27281,2,13,1,1080.00,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1197,7638,389,40736,27281,2,96,2,950.42,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1198,7638,389,40736,27281,2,67,2,199.58,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1199,7638,389,40736,27281,2,13,1,1150.00,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1200,7638,390,40736,27281,2,96,2,1115.70,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1201,7638,390,40736,27281,2,67,2,234.30,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL);
INSERT INTO `balance_libro_details` VALUES (1202,7638,390,40736,27281,2,13,1,1350.00,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1203,7638,391,40736,27281,2,96,2,776.87,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1204,7638,391,40736,27281,2,67,2,163.13,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1205,7638,391,40736,27281,2,13,1,940.00,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1206,7638,392,40736,27281,2,96,2,880.18,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1207,7638,392,40736,27281,2,67,2,184.82,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1208,7638,392,40736,27281,2,13,1,1065.00,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1209,7638,393,40736,27281,2,96,2,1115.70,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1210,7638,393,40736,27281,2,67,2,234.30,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1211,7638,393,40736,27281,2,13,1,1350.00,NULL,'2022-11-24 13:54:38','2022-11-24 13:54:38',NULL),(1212,7638,394,40736,27281,2,96,2,801.66,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1213,7638,394,40736,27281,2,67,2,168.34,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1214,7638,394,40736,27281,2,13,1,970.00,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1215,7638,395,40736,27281,2,96,2,929.76,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1216,7638,395,40736,27281,2,67,2,195.24,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1217,7638,395,40736,27281,2,13,1,1125.00,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1218,7638,396,40736,27281,2,96,2,785.95,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1219,7638,396,40736,27281,2,67,2,165.05,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1220,7638,396,40736,27281,2,13,1,951.00,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1221,7638,397,40736,27281,2,96,2,842.97,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1222,7638,397,40736,27281,2,67,2,177.03,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1223,7638,397,40736,27281,2,13,1,1020.00,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1224,7638,398,40736,27281,2,96,2,946.29,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1225,7638,398,40736,27281,2,67,2,198.71,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1226,7638,398,40736,27281,2,13,1,1145.00,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1227,7638,399,40736,27281,2,96,2,942.15,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1228,7638,399,40736,27281,2,67,2,197.85,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1229,7638,399,40736,27281,2,13,1,1140.00,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1230,7638,400,40736,27281,2,96,2,1020.66,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1231,7638,400,40736,27281,2,67,2,214.34,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1232,7638,400,40736,27281,2,13,1,1235.00,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1233,7638,401,40736,27281,2,96,2,1115.71,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1234,7638,401,40736,27281,2,67,2,234.29,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1235,7638,401,40736,27281,2,13,1,1350.00,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1236,7638,402,40736,27281,2,96,2,1095.04,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1237,7638,402,40736,27281,2,67,2,229.96,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1238,7638,402,40736,27281,2,13,1,1325.00,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1239,7638,403,40736,27281,2,96,2,1181.82,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1240,7638,403,40736,27281,2,67,2,248.18,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1241,7638,403,40736,27281,2,13,1,1430.00,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1242,7638,404,40736,27281,2,96,2,983.48,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL);
INSERT INTO `balance_libro_details` VALUES (1243,7638,404,40736,27281,2,67,2,206.52,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1244,7638,404,40736,27281,2,13,1,1190.00,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1245,7638,405,40736,27281,2,96,2,896.70,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1246,7638,405,40736,27281,2,67,2,188.30,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1247,7638,405,40736,27281,2,13,1,1085.00,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1248,7638,406,40736,27281,2,96,2,1030.85,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1249,7638,406,40736,27281,2,67,2,194.15,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1250,7638,406,40736,27281,2,13,1,1225.00,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1251,7638,407,40736,27281,2,96,2,1161.16,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1252,7638,407,40736,27281,2,67,2,243.84,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1253,7638,407,40736,27281,2,13,1,1405.00,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1254,7638,408,40736,27281,2,96,2,826.45,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1255,7638,408,40736,27281,2,67,2,173.55,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1256,7638,408,40736,27281,2,13,1,1000.00,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1257,7638,409,40736,27281,2,96,2,1070.25,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1258,7638,409,40736,27281,2,67,2,224.75,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1259,7638,409,40736,27281,2,13,1,1295.00,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1260,7638,410,40736,27281,2,96,2,1016.53,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1261,7638,410,40736,27281,2,67,2,213.47,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1262,7638,410,40736,27281,2,13,1,1230.00,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1263,7638,411,40736,27281,2,96,2,842.97,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1264,7638,411,40736,27281,2,67,2,177.03,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1265,7638,411,40736,27281,2,13,1,1020.00,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1266,7638,412,40736,27281,2,96,2,921.50,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1267,7638,412,40736,27281,2,67,2,193.50,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1268,7638,412,40736,27281,2,13,1,1115.00,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1269,7638,413,40736,27281,2,96,2,983.47,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1270,7638,413,40736,27281,2,67,2,206.53,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1271,7638,413,40736,27281,2,13,1,1190.00,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1272,7638,414,40736,27281,2,96,2,1009.22,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1273,7638,414,40736,27281,2,67,2,195.78,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1274,7638,414,40736,27281,2,13,1,1205.00,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1275,7638,415,40736,27281,2,96,2,975.21,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1276,7638,415,40736,27281,2,67,2,204.79,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1277,7638,415,40736,27281,2,13,1,1180.00,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1278,7638,416,40736,27281,2,96,2,1144.63,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1279,7638,416,40736,27281,2,67,2,240.37,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1280,7638,416,40736,27281,2,13,1,1385.00,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1281,7638,417,40736,27281,2,96,2,995.04,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1282,7638,417,40736,27281,2,67,2,208.96,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1283,7638,417,40736,27281,2,13,1,1204.00,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL);
INSERT INTO `balance_libro_details` VALUES (1284,7638,418,40736,27281,2,96,2,1061.99,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1285,7638,418,40736,27281,2,67,2,223.01,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1286,7638,418,40736,27281,2,13,1,1285.00,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1287,7638,419,40736,27281,2,96,2,907.44,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1288,7638,419,40736,27281,2,67,2,190.56,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1289,7638,419,40736,27281,2,13,1,1098.00,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1290,7638,420,40736,27281,2,96,2,1028.94,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1291,7638,420,40736,27281,2,67,2,216.06,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1292,7638,420,40736,27281,2,13,1,1245.00,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1293,7638,421,40736,27281,2,96,2,971.07,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1294,7638,421,40736,27281,2,67,2,203.93,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1295,7638,421,40736,27281,2,13,1,1175.00,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1296,7638,422,40736,27281,2,96,2,962.82,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1297,7638,422,40736,27281,2,67,2,202.18,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1298,7638,422,40736,27281,2,13,1,1165.00,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1299,7638,423,40736,27281,2,96,2,880.17,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1300,7638,423,40736,27281,2,67,2,184.83,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1301,7638,423,40736,27281,2,13,1,1065.00,NULL,'2022-11-24 13:54:39','2022-11-24 13:54:39',NULL),(1302,7638,424,40736,27281,2,96,2,1066.12,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1303,7638,424,40736,27281,2,67,2,223.88,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1304,7638,424,40736,27281,2,13,1,1290.00,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1305,7638,425,40736,27281,2,96,2,991.74,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1306,7638,425,40736,27281,2,67,2,208.26,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1307,7638,425,40736,27281,2,13,1,1200.00,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1308,7638,426,40736,27281,2,96,2,991.74,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1309,7638,426,40736,27281,2,67,2,208.26,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1310,7638,426,40736,27281,2,13,1,1200.00,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1311,7638,427,40736,27281,2,96,2,1066.12,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1312,7638,427,40736,27281,2,67,2,223.88,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1313,7638,427,40736,27281,2,13,1,1290.00,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1314,7638,428,40736,27281,2,96,2,859.51,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1315,7638,428,40736,27281,2,67,2,180.49,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1316,7638,428,40736,27281,2,13,1,1040.00,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1317,7638,429,40736,27281,2,96,2,950.41,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1318,7638,429,40736,27281,2,67,2,199.59,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1319,7638,429,40736,27281,2,13,1,1150.00,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1320,7638,430,40736,27281,2,96,2,929.75,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1321,7638,430,40736,27281,2,67,2,195.25,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1322,7638,430,40736,27281,2,13,1,1125.00,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1323,7638,431,40736,27281,2,96,2,1057.86,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1324,7638,431,40736,27281,2,67,2,222.14,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL);
INSERT INTO `balance_libro_details` VALUES (1325,7638,431,40736,27281,2,13,1,1280.00,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1326,7638,432,40736,27281,2,96,2,991.74,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1327,7638,432,40736,27281,2,67,2,208.26,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1328,7638,432,40736,27281,2,13,1,1200.00,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1329,7638,433,40736,27281,2,96,2,965.30,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1330,7638,433,40736,27281,2,67,2,202.70,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1331,7638,433,40736,27281,2,13,1,1168.00,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1332,7638,434,40736,27281,2,96,2,1075.14,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1333,7638,434,40736,27281,2,67,2,214.86,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1334,7638,434,40736,27281,2,13,1,1290.00,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1335,7638,435,40736,27281,2,96,2,925.61,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1336,7638,435,40736,27281,2,67,2,194.39,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1337,7638,435,40736,27281,2,13,1,1120.00,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1338,7638,436,40736,27281,2,96,2,1024.78,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1339,7638,436,40736,27281,2,67,2,215.22,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1340,7638,436,40736,27281,2,13,1,1240.00,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1341,7638,437,40736,27281,2,96,2,735.55,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1342,7638,437,40736,27281,2,67,2,154.45,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1343,7638,437,40736,27281,2,13,1,890.00,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1344,7638,438,40736,27281,2,96,2,929.76,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1345,7638,438,40736,27281,2,67,2,195.24,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1346,7638,438,40736,27281,2,13,1,1125.00,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1347,7638,439,40736,27281,2,96,2,805.79,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1348,7638,439,40736,27281,2,67,2,169.21,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1349,7638,439,40736,27281,2,13,1,975.00,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1350,7638,440,40736,27281,2,96,2,1045.46,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1351,7638,440,40736,27281,2,67,2,219.54,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1352,7638,440,40736,27281,2,13,1,1265.00,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1353,7638,441,40736,27281,2,96,2,818.18,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1354,7638,441,40736,27281,2,67,2,171.82,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1355,7638,441,40736,27281,2,13,1,990.00,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1356,7638,442,40736,27281,2,96,2,1582.65,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1357,7638,442,40736,27281,2,67,2,332.35,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1358,7638,442,40736,27281,2,13,1,1915.00,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1359,7638,443,40736,27281,2,96,2,921.49,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1360,7638,443,40736,27281,2,67,2,193.51,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1361,7638,443,40736,27281,2,13,1,1115.00,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1362,7638,444,40736,27281,2,96,2,673.56,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1363,7638,444,40736,27281,2,67,2,141.44,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1364,7638,444,40736,27281,2,13,1,815.00,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1365,7638,445,40736,27281,2,96,2,772.73,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL);
INSERT INTO `balance_libro_details` VALUES (1366,7638,445,40736,27281,2,67,2,162.27,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1367,7638,445,40736,27281,2,13,1,935.00,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1368,7638,446,40736,27281,2,96,2,933.87,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1369,7638,446,40736,27281,2,67,2,196.13,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1370,7638,446,40736,27281,2,13,1,1130.00,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1371,7638,447,40736,27281,2,96,2,797.53,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1372,7638,447,40736,27281,2,67,2,167.47,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1373,7638,447,40736,27281,2,13,1,965.00,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1374,7638,448,40736,27281,2,96,2,702.47,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1375,7638,448,40736,27281,2,67,2,147.53,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1376,7638,448,40736,27281,2,13,1,850.00,NULL,'2022-11-24 13:54:40','2022-11-24 13:54:40',NULL),(1377,7638,449,40736,27281,2,96,2,940.93,NULL,'2022-11-24 13:54:41','2022-11-24 13:54:41',NULL),(1378,7638,449,40736,27281,2,67,2,179.07,NULL,'2022-11-24 13:54:41','2022-11-24 13:54:41',NULL),(1379,7638,449,40736,27281,2,13,1,1120.00,NULL,'2022-11-24 13:54:41','2022-11-24 13:54:41',NULL),(1380,7638,450,40736,27281,2,96,2,966.94,NULL,'2022-11-24 13:54:41','2022-11-24 13:54:41',NULL),(1381,7638,450,40736,27281,2,67,2,203.06,NULL,'2022-11-24 13:54:41','2022-11-24 13:54:41',NULL),(1382,7638,450,40736,27281,2,13,1,1170.00,NULL,'2022-11-24 13:54:41','2022-11-24 13:54:41',NULL),(1383,7638,451,40736,27281,2,96,2,971.06,NULL,'2022-11-24 13:54:41','2022-11-24 13:54:41',NULL),(1384,7638,451,40736,27281,2,67,2,203.94,NULL,'2022-11-24 13:54:41','2022-11-24 13:54:41',NULL),(1385,7638,451,40736,27281,2,13,1,1175.00,NULL,'2022-11-24 13:54:41','2022-11-24 13:54:41',NULL),(1386,7638,452,40736,27281,2,96,2,900.83,NULL,'2022-11-24 13:54:41','2022-11-24 13:54:41',NULL),(1387,7638,452,40736,27281,2,67,2,189.17,NULL,'2022-11-24 13:54:41','2022-11-24 13:54:41',NULL),(1388,7638,452,40736,27281,2,13,1,1090.00,NULL,'2022-11-24 13:54:41','2022-11-24 13:54:41',NULL),(1389,7638,453,40736,27281,2,96,2,818.19,NULL,'2022-11-24 13:54:41','2022-11-24 13:54:41',NULL),(1390,7638,453,40736,27281,2,67,2,171.81,NULL,'2022-11-24 13:54:41','2022-11-24 13:54:41',NULL),(1391,7638,453,40736,27281,2,13,1,990.00,NULL,'2022-11-24 13:54:41','2022-11-24 13:54:41',NULL),(1392,7638,454,40736,27281,2,96,2,814.06,NULL,'2022-11-24 13:54:41','2022-11-24 13:54:41',NULL),(1393,7638,454,40736,27281,2,67,2,170.94,NULL,'2022-11-24 13:54:41','2022-11-24 13:54:41',NULL),(1394,7638,454,40736,27281,2,13,1,985.00,NULL,'2022-11-24 13:54:41','2022-11-24 13:54:41',NULL),(1395,7638,455,40736,27281,2,96,2,876.03,NULL,'2022-11-24 13:54:41','2022-11-24 13:54:41',NULL),(1396,7638,455,40736,27281,2,67,2,183.97,NULL,'2022-11-24 13:54:41','2022-11-24 13:54:41',NULL),(1397,7638,455,40736,27281,2,13,1,1060.00,NULL,'2022-11-24 13:54:41','2022-11-24 13:54:41',NULL),(1398,7638,456,40736,27281,3,217,1,4337.20,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1399,7638,456,40736,27281,3,68,1,910.81,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1400,7638,456,40736,27281,3,57,2,5248.01,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1401,7638,457,40736,27281,3,217,1,19480.37,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1402,7638,457,40736,27281,3,68,1,4090.88,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1403,7638,457,40736,27281,3,217,1,896.10,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1404,7638,457,40736,27281,3,57,2,24467.35,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1405,7638,458,40736,27281,3,217,1,17513.62,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1406,7638,458,40736,27281,3,68,1,3677.86,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL);
INSERT INTO `balance_libro_details` VALUES (1407,7638,458,40736,27281,3,217,1,805.63,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1408,7638,458,40736,27281,3,57,2,21997.11,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1409,7638,459,40736,27281,3,217,1,16849.94,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1410,7638,459,40736,27281,3,68,1,3538.49,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1411,7638,459,40736,27281,3,217,1,775.10,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1412,7638,459,40736,27281,3,57,2,21163.53,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1413,7638,460,40736,27281,3,217,1,30417.29,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1414,7638,460,40736,27281,3,68,1,6387.63,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1415,7638,460,40736,27281,3,217,1,1399.20,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1416,7638,460,40736,27281,3,57,2,38204.12,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1417,7638,461,40736,27281,3,217,1,3786.26,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1418,7638,461,40736,27281,3,68,1,795.11,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1419,7638,461,40736,27281,3,217,1,283.52,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1420,7638,461,40736,27281,3,57,2,4864.89,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1421,7638,462,40736,27281,3,217,1,457.15,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1422,7638,462,40736,27281,3,68,1,96.00,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1423,7638,462,40736,27281,3,217,1,7.31,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1424,7638,462,40736,27281,3,57,2,560.46,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1425,7638,463,40736,27281,3,217,1,4953.07,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1426,7638,463,40736,27281,3,68,1,1040.15,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1427,7638,463,40736,27281,3,217,1,440.58,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1428,7638,463,40736,27281,3,57,2,6433.80,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1429,7638,464,40736,27281,3,217,2,4953.07,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1430,7638,464,40736,27281,3,67,2,1040.15,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1431,7638,464,40736,27281,3,217,2,440.59,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1432,7638,464,40736,27281,3,57,1,6433.81,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1433,7638,465,40736,27281,3,217,1,16554.55,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1434,7638,465,40736,27281,3,68,1,3476.46,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1435,7638,465,40736,27281,3,217,1,646.77,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1436,7638,465,40736,27281,3,57,2,20677.78,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1437,7638,466,40736,27281,3,217,1,20204.89,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1438,7638,466,40736,27281,3,68,1,4243.03,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1439,7638,466,40736,27281,3,217,1,761.47,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1440,7638,466,40736,27281,3,57,2,25209.39,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1441,7638,467,40736,27281,3,217,1,6892.59,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1442,7638,467,40736,27281,3,68,1,1447.43,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1443,7638,467,40736,27281,3,57,2,8340.02,NULL,'2022-11-24 13:55:04','2022-11-24 13:55:04',NULL),(1444,7638,468,40736,27281,3,217,1,6310.14,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1445,7638,468,40736,27281,3,68,1,1325.13,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1446,7638,468,40736,27281,3,217,1,837.17,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1447,7638,468,40736,27281,3,57,2,8472.44,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL);
INSERT INTO `balance_libro_details` VALUES (1448,7638,469,40736,27281,3,217,2,6310.14,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1449,7638,469,40736,27281,3,67,2,1325.13,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1450,7638,469,40736,27281,3,217,2,837.18,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1451,7638,469,40736,27281,3,57,1,8472.45,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1452,7638,470,40736,27281,3,217,1,136.71,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1453,7638,470,40736,27281,3,68,1,28.71,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1454,7638,470,40736,27281,3,57,2,165.42,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1455,7638,471,40736,27281,3,217,1,12346.32,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1456,7638,471,40736,27281,3,68,1,2592.73,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1457,7638,471,40736,27281,3,217,1,485.90,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1458,7638,471,40736,27281,3,57,2,15424.95,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1459,7638,472,40736,27281,3,217,1,4822.98,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1460,7638,472,40736,27281,3,68,1,1012.83,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1461,7638,472,40736,27281,3,217,1,834.93,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1462,7638,472,40736,27281,3,57,2,6670.74,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1463,7638,473,40736,27281,3,217,1,4308.31,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1464,7638,473,40736,27281,3,68,1,904.76,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1465,7638,473,40736,27281,3,57,2,5213.07,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1466,7638,474,40736,27281,3,217,2,834.07,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1467,7638,474,40736,27281,3,67,2,175.15,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1468,7638,474,40736,27281,3,57,1,1009.22,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1469,7638,475,40736,27281,3,217,1,297.73,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1470,7638,475,40736,27281,3,68,1,62.52,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1471,7638,475,40736,27281,3,217,1,4.76,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1472,7638,475,40736,27281,3,57,2,365.01,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1473,7638,476,40736,27281,3,217,1,1162.19,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1474,7638,476,40736,27281,3,68,1,244.06,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1475,7638,476,40736,27281,3,217,1,18.60,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1476,7638,476,40736,27281,3,57,2,1424.85,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1477,7638,477,40736,27281,3,217,1,18116.66,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1478,7638,477,40736,27281,3,68,1,3804.50,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1479,7638,477,40736,27281,3,217,1,289.87,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1480,7638,477,40736,27281,3,57,2,22211.03,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1481,7638,478,40736,27281,3,217,1,12325.97,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1482,7638,478,40736,27281,3,68,1,2588.45,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1483,7638,478,40736,27281,3,217,1,419.55,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1484,7638,478,40736,27281,3,57,2,15333.97,NULL,'2022-11-24 13:55:05','2022-11-24 13:55:05',NULL),(1485,7638,479,40746,43585,3,217,1,3471.38,NULL,'2022-11-24 13:58:23','2022-11-24 13:58:23',NULL),(1486,7638,479,40746,43585,3,68,1,728.99,NULL,'2022-11-24 13:58:23','2022-11-24 13:58:23',NULL),(1487,7638,479,40746,43585,3,217,1,86.78,NULL,'2022-11-24 13:58:23','2022-11-24 13:58:23',NULL),(1488,7638,479,40746,43585,3,57,2,4287.15,NULL,'2022-11-24 13:58:23','2022-11-24 13:58:23',NULL);
INSERT INTO `balance_libro_details` VALUES (1489,7638,480,40746,43585,3,217,1,5454.55,NULL,'2022-11-24 13:58:23','2022-11-24 13:58:23',NULL),(1490,7638,480,40746,43585,3,68,1,1145.45,NULL,'2022-11-24 13:58:23','2022-11-24 13:58:23',NULL),(1491,7638,480,40746,43585,3,57,2,6600.00,NULL,'2022-11-24 13:58:23','2022-11-24 13:58:23',NULL),(1492,7638,481,40746,43585,3,217,1,3048.75,NULL,'2022-11-24 13:58:23','2022-11-24 13:58:23',NULL),(1493,7638,481,40746,43585,3,68,1,640.24,NULL,'2022-11-24 13:58:23','2022-11-24 13:58:23',NULL),(1494,7638,481,40746,43585,3,57,2,3688.99,NULL,'2022-11-24 13:58:23','2022-11-24 13:58:23',NULL),(1495,7638,482,40737,28794,2,96,2,13000.00,NULL,'2022-11-24 14:03:39','2022-11-24 14:03:39',NULL),(1496,7638,482,40737,28794,2,67,2,1365.00,NULL,'2022-11-24 14:03:39','2022-11-24 14:03:39',NULL),(1497,7638,482,40737,28794,2,13,1,14365.00,NULL,'2022-11-24 14:03:39','2022-11-24 14:03:39',NULL),(1498,7638,483,40737,28794,2,96,2,34000.00,NULL,'2022-11-24 14:03:39','2022-11-24 14:03:39',NULL),(1499,7638,483,40737,28794,2,67,2,3570.00,NULL,'2022-11-24 14:03:39','2022-11-24 14:03:39',NULL),(1500,7638,483,40737,28794,2,13,1,37570.00,NULL,'2022-11-24 14:03:39','2022-11-24 14:03:39',NULL),(1501,7638,484,40737,28794,2,96,2,17500.00,NULL,'2022-11-24 14:03:39','2022-11-24 14:03:39',NULL),(1502,7638,484,40737,28794,2,67,2,1837.50,NULL,'2022-11-24 14:03:39','2022-11-24 14:03:39',NULL),(1503,7638,484,40737,28794,2,13,1,19337.50,NULL,'2022-11-24 14:03:39','2022-11-24 14:03:39',NULL),(1504,7638,485,40737,28794,2,96,2,37230.77,NULL,'2022-11-24 14:03:39','2022-11-24 14:03:39',NULL),(1505,7638,485,40737,28794,2,67,2,3909.23,NULL,'2022-11-24 14:03:39','2022-11-24 14:03:39',NULL),(1506,7638,485,40737,28794,2,13,1,41140.00,NULL,'2022-11-24 14:03:39','2022-11-24 14:03:39',NULL),(1507,7638,486,40737,28794,2,96,2,19162.90,NULL,'2022-11-24 14:03:39','2022-11-24 14:03:39',NULL),(1508,7638,486,40737,28794,2,67,2,2012.10,NULL,'2022-11-24 14:03:39','2022-11-24 14:03:39',NULL),(1509,7638,486,40737,28794,2,13,1,21175.00,NULL,'2022-11-24 14:03:39','2022-11-24 14:03:39',NULL),(1510,7638,487,40737,28794,2,96,1,34000.00,NULL,'2022-11-24 14:03:39','2022-11-24 14:03:39',NULL),(1511,7638,487,40737,28794,2,68,1,3570.00,NULL,'2022-11-24 14:03:39','2022-11-24 14:03:39',NULL),(1512,7638,487,40737,28794,2,13,2,37570.00,NULL,'2022-11-24 14:03:39','2022-11-24 14:03:39',NULL),(1513,7638,488,40737,28794,2,96,1,17500.00,NULL,'2022-11-24 14:03:39','2022-11-24 14:03:39',NULL),(1514,7638,488,40737,28794,2,68,1,1837.50,NULL,'2022-11-24 14:03:39','2022-11-24 14:03:39',NULL),(1515,7638,488,40737,28794,2,13,2,19337.50,NULL,'2022-11-24 14:03:39','2022-11-24 14:03:39',NULL),(1516,7638,489,40737,28794,2,96,2,60226.24,NULL,'2022-11-24 14:03:39','2022-11-24 14:03:39',NULL),(1517,7638,489,40737,28794,2,67,2,6323.76,NULL,'2022-11-24 14:03:39','2022-11-24 14:03:39',NULL),(1518,7638,489,40737,28794,2,13,1,66550.00,NULL,'2022-11-24 14:03:39','2022-11-24 14:03:39',NULL),(1519,7638,490,40737,28794,2,96,2,38325.79,NULL,'2022-11-24 14:03:39','2022-11-24 14:03:39',NULL),(1520,7638,490,40737,28794,2,67,2,4024.21,NULL,'2022-11-24 14:03:39','2022-11-24 14:03:39',NULL),(1521,7638,490,40737,28794,2,13,1,42350.00,NULL,'2022-11-24 14:03:39','2022-11-24 14:03:39',NULL),(1522,7638,491,40737,28794,2,96,2,10950.23,NULL,'2022-11-24 14:03:40','2022-11-24 14:03:40',NULL),(1523,7638,491,40737,28794,2,67,2,1149.77,NULL,'2022-11-24 14:03:40','2022-11-24 14:03:40',NULL),(1524,7638,491,40737,28794,2,13,1,12100.00,NULL,'2022-11-24 14:03:40','2022-11-24 14:03:40',NULL),(1525,7638,492,40737,28794,2,96,2,49276.02,NULL,'2022-11-24 14:03:40','2022-11-24 14:03:40',NULL),(1526,7638,492,40737,28794,2,67,2,5173.98,NULL,'2022-11-24 14:03:40','2022-11-24 14:03:40',NULL),(1527,7638,492,40737,28794,2,13,1,54450.00,NULL,'2022-11-24 14:03:40','2022-11-24 14:03:40',NULL),(1528,7638,493,40737,28794,2,96,2,372307.69,NULL,'2022-11-24 14:03:40','2022-11-24 14:03:40',NULL),(1529,7638,493,40737,28794,2,67,2,39092.31,NULL,'2022-11-24 14:03:40','2022-11-24 14:03:40',NULL);
INSERT INTO `balance_libro_details` VALUES (1530,7638,493,40737,28794,2,13,1,411400.00,NULL,'2022-11-24 14:03:40','2022-11-24 14:03:40',NULL),(1531,7638,494,40737,28794,2,96,2,558461.54,NULL,'2022-11-24 14:03:40','2022-11-24 14:03:40',NULL),(1532,7638,494,40737,28794,2,67,2,58638.46,NULL,'2022-11-24 14:03:40','2022-11-24 14:03:40',NULL),(1533,7638,494,40737,28794,2,13,1,617100.00,NULL,'2022-11-24 14:03:40','2022-11-24 14:03:40',NULL),(1534,7638,495,40737,28794,3,217,1,2200.00,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1535,7638,495,40737,28794,3,68,1,462.00,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1536,7638,495,40737,28794,3,57,2,2662.00,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1537,7638,496,40737,28794,3,217,1,6901.35,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1538,7638,496,40737,28794,3,68,1,1449.28,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1539,7638,496,40737,28794,3,57,2,8350.63,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1540,7638,497,40737,28794,3,217,1,5809.25,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1541,7638,497,40737,28794,3,68,1,1219.94,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1542,7638,497,40737,28794,3,217,1,261.42,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1543,7638,497,40737,28794,3,57,2,7290.61,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1544,7638,498,40737,28794,3,217,2,5809.25,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1545,7638,498,40737,28794,3,67,2,1219.94,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1546,7638,498,40737,28794,3,217,2,261.42,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1547,7638,498,40737,28794,3,57,1,7290.61,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1548,7638,499,40737,28794,3,217,2,5809.25,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1549,7638,499,40737,28794,3,67,2,1219.94,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1550,7638,499,40737,28794,3,217,2,261.42,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1551,7638,499,40737,28794,3,57,1,7290.61,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1552,7638,500,40737,28794,3,217,1,6859.51,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1553,7638,500,40737,28794,3,68,1,1440.50,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1554,7638,500,40737,28794,3,217,1,-0.01,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1555,7638,500,40737,28794,3,57,2,8300.00,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1556,7638,501,40737,28794,3,217,1,15450.39,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1557,7638,501,40737,28794,3,68,1,3244.58,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1558,7638,501,40737,28794,3,217,1,695.27,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1559,7638,501,40737,28794,3,57,2,19390.24,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1560,7638,502,40737,28794,3,217,1,1757.80,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1561,7638,502,40737,28794,3,68,1,369.14,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1562,7638,502,40737,28794,3,57,2,2126.94,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1563,7638,503,40737,28794,3,217,1,12483.65,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1564,7638,503,40737,28794,3,68,1,2621.58,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1565,7638,503,40737,28794,3,217,1,561.76,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1566,7638,503,40737,28794,3,57,2,15666.99,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1567,7638,504,40737,28794,3,217,1,504.13,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1568,7638,504,40737,28794,3,68,1,105.87,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1569,7638,504,40737,28794,3,217,1,10.08,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1570,7638,504,40737,28794,3,57,2,620.08,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL);
INSERT INTO `balance_libro_details` VALUES (1571,7638,505,40737,28794,3,217,1,925.61,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1572,7638,505,40737,28794,3,68,1,194.38,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1573,7638,505,40737,28794,3,57,2,1119.99,NULL,'2022-11-24 14:03:50','2022-11-24 14:03:50',NULL),(1574,7638,506,40737,28794,3,250,1,22000.00,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1575,7638,506,40737,28794,3,57,2,22000.00,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1576,7638,507,40737,28794,3,217,1,387.99,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1577,7638,507,40737,28794,3,68,1,81.48,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1578,7638,507,40737,28794,3,57,2,469.47,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1579,7638,508,40737,28794,3,217,1,566.75,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1580,7638,508,40737,28794,3,68,1,119.02,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1581,7638,508,40737,28794,3,57,2,685.77,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1582,7638,509,40737,28794,3,217,1,240.04,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1583,7638,509,40737,28794,3,68,1,50.41,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1584,7638,509,40737,28794,3,57,2,290.45,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1585,7638,510,40737,28794,3,217,1,19123.78,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1586,7638,510,40737,28794,3,68,1,4015.99,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1587,7638,510,40737,28794,3,217,1,860.57,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1588,7638,510,40737,28794,3,57,2,24000.34,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1589,7638,511,40737,28794,3,217,1,2041.64,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1590,7638,511,40737,28794,3,68,1,428.74,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1591,7638,511,40737,28794,3,217,1,153.12,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1592,7638,511,40737,28794,3,57,2,2623.50,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1593,7638,512,40737,28794,3,217,1,9876.44,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1594,7638,512,40737,28794,3,68,1,2074.05,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1595,7638,512,40737,28794,3,57,2,11950.49,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1596,7638,513,40737,28794,3,217,1,1958.68,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1597,7638,513,40737,28794,3,68,1,411.32,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1598,7638,513,40737,28794,3,57,2,2370.00,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1599,7638,514,40737,28794,3,217,1,61983.47,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1600,7638,514,40737,28794,3,68,1,13016.53,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1601,7638,514,40737,28794,3,57,2,75000.00,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1602,7638,515,40737,28794,3,217,1,39669.42,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1603,7638,515,40737,28794,3,68,1,8330.58,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1604,7638,515,40737,28794,3,57,2,48000.00,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1605,7638,516,40737,28794,3,217,1,760.33,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1606,7638,516,40737,28794,3,68,1,159.67,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1607,7638,516,40737,28794,3,217,1,15.20,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1608,7638,516,40737,28794,3,57,2,935.20,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1609,7638,517,40737,28794,3,217,1,289.30,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1610,7638,517,40737,28794,3,68,1,60.75,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1611,7638,517,40737,28794,3,57,2,350.05,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL);
INSERT INTO `balance_libro_details` VALUES (1612,7638,518,40737,28794,3,217,1,3376.41,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1613,7638,518,40737,28794,3,68,1,709.00,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1614,7638,518,40737,28794,3,217,1,337.60,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1615,7638,518,40737,28794,3,57,2,4423.01,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1616,7638,519,40737,28794,3,217,1,3154.93,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1617,7638,519,40737,28794,3,68,1,662.54,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1618,7638,519,40737,28794,3,57,2,3817.47,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1619,7638,520,40737,28794,3,217,1,7520.88,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1620,7638,520,40737,28794,3,68,1,1579.38,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1621,7638,520,40737,28794,3,57,2,9100.26,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1622,7638,521,40737,28794,3,217,1,32509.91,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1623,7638,521,40737,28794,3,68,1,6827.08,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1624,7638,521,40737,28794,3,57,2,39336.99,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1625,7638,522,40737,28794,3,217,1,6687.29,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1626,7638,522,40737,28794,3,68,1,1404.33,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1627,7638,522,40737,28794,3,57,2,8091.62,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1628,7638,523,40737,28794,3,217,1,725.62,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1629,7638,523,40737,28794,3,68,1,152.38,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1630,7638,523,40737,28794,3,217,1,14.51,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1631,7638,523,40737,28794,3,57,2,892.51,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1632,7638,524,40737,28794,3,250,1,10500.00,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1633,7638,524,40737,28794,3,57,2,10500.00,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1634,7638,525,40737,28794,3,217,1,716.92,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1635,7638,525,40737,28794,3,68,1,150.55,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1636,7638,525,40737,28794,3,57,2,867.47,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1637,7638,526,40737,28794,3,217,1,633.28,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1638,7638,526,40737,28794,3,68,1,132.99,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1639,7638,526,40737,28794,3,57,2,766.27,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1640,7638,527,40737,28794,3,217,1,2066.12,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1641,7638,527,40737,28794,3,68,1,433.88,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1642,7638,527,40737,28794,3,57,2,2500.00,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1643,7638,528,40737,28794,3,217,1,169834.71,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1644,7638,528,40737,28794,3,68,1,35665.29,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1645,7638,528,40737,28794,3,57,2,205500.00,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1646,7638,529,40737,28794,3,217,1,46063.65,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1647,7638,529,40737,28794,3,68,1,9632.60,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1648,7638,529,40737,28794,3,217,1,9.02,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1649,7638,529,40737,28794,3,57,2,55705.27,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1650,7638,530,40737,28794,3,217,1,2600.00,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1651,7638,530,40737,28794,3,68,1,546.00,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1652,7638,530,40737,28794,3,57,2,3146.00,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL);
INSERT INTO `balance_libro_details` VALUES (1653,7638,531,40737,28794,3,217,1,3503.40,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1654,7638,531,40737,28794,3,68,1,735.71,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1655,7638,531,40737,28794,3,57,2,4239.11,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1656,7638,532,40737,28794,3,217,1,4660.00,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1657,7638,532,40737,28794,3,68,1,978.60,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1658,7638,532,40737,28794,3,57,2,5638.60,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1659,7638,533,40737,28794,3,217,1,123966.94,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1660,7638,533,40737,28794,3,68,1,26033.06,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1661,7638,533,40737,28794,3,57,2,150000.00,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1662,7638,534,40737,28794,3,217,1,41239.67,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1663,7638,534,40737,28794,3,68,1,8660.33,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1664,7638,534,40737,28794,3,57,2,49900.00,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1665,7638,535,40737,28794,3,217,1,123966.94,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1666,7638,535,40737,28794,3,68,1,26033.06,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1667,7638,535,40737,28794,3,57,2,150000.00,NULL,'2022-11-24 14:03:51','2022-11-24 14:03:51',NULL),(1668,7638,536,40737,28794,3,217,1,1330.58,NULL,'2022-11-24 14:03:52','2022-11-24 14:03:52',NULL),(1669,7638,536,40737,28794,3,68,1,279.42,NULL,'2022-11-24 14:03:52','2022-11-24 14:03:52',NULL),(1670,7638,536,40737,28794,3,57,2,1610.00,NULL,'2022-11-24 14:03:52','2022-11-24 14:03:52',NULL),(1671,7638,537,40737,28794,3,217,1,14613.72,NULL,'2022-11-24 14:03:52','2022-11-24 14:03:52',NULL),(1672,7638,537,40737,28794,3,68,1,3068.88,NULL,'2022-11-24 14:03:52','2022-11-24 14:03:52',NULL),(1673,7638,537,40737,28794,3,217,1,657.61,NULL,'2022-11-24 14:03:52','2022-11-24 14:03:52',NULL),(1674,7638,537,40737,28794,3,57,2,18340.21,NULL,'2022-11-24 14:03:52','2022-11-24 14:03:52',NULL),(1675,7638,538,40737,28794,3,217,1,826.45,NULL,'2022-11-24 14:03:52','2022-11-24 14:03:52',NULL),(1676,7638,538,40737,28794,3,68,1,173.55,NULL,'2022-11-24 14:03:52','2022-11-24 14:03:52',NULL),(1677,7638,538,40737,28794,3,57,2,1000.00,NULL,'2022-11-24 14:03:52','2022-11-24 14:03:52',NULL),(1678,7638,539,40737,28794,3,217,1,2727.27,NULL,'2022-11-24 14:03:52','2022-11-24 14:03:52',NULL),(1679,7638,539,40737,28794,3,68,1,572.73,NULL,'2022-11-24 14:03:52','2022-11-24 14:03:52',NULL),(1680,7638,539,40737,28794,3,57,2,3300.00,NULL,'2022-11-24 14:03:52','2022-11-24 14:03:52',NULL),(1681,7638,540,40737,28794,3,217,1,206.62,NULL,'2022-11-24 14:03:52','2022-11-24 14:03:52',NULL),(1682,7638,540,40737,28794,3,68,1,43.39,NULL,'2022-11-24 14:03:52','2022-11-24 14:03:52',NULL),(1683,7638,540,40737,28794,3,57,2,250.01,NULL,'2022-11-24 14:03:52','2022-11-24 14:03:52',NULL),(1684,7638,541,40737,28794,3,217,1,1528.93,NULL,'2022-11-24 14:03:52','2022-11-24 14:03:52',NULL),(1685,7638,541,40737,28794,3,68,1,321.08,NULL,'2022-11-24 14:03:52','2022-11-24 14:03:52',NULL),(1686,7638,541,40737,28794,3,57,2,1850.01,NULL,'2022-11-24 14:03:52','2022-11-24 14:03:52',NULL),(1687,7638,542,40737,28794,3,217,1,974.38,NULL,'2022-11-24 14:03:52','2022-11-24 14:03:52',NULL),(1688,7638,542,40737,28794,3,68,1,204.62,NULL,'2022-11-24 14:03:52','2022-11-24 14:03:52',NULL),(1689,7638,542,40737,28794,3,57,2,1179.00,NULL,'2022-11-24 14:03:52','2022-11-24 14:03:52',NULL),(1690,7638,543,40737,28794,3,217,1,661.16,NULL,'2022-11-24 14:03:52','2022-11-24 14:03:52',NULL),(1691,7638,543,40737,28794,3,68,1,138.84,NULL,'2022-11-24 14:03:52','2022-11-24 14:03:52',NULL),(1692,7638,543,40737,28794,3,57,2,800.00,NULL,'2022-11-24 14:03:52','2022-11-24 14:03:52',NULL),(1693,7638,544,40737,28794,3,217,1,2140.50,NULL,'2022-11-24 14:03:52','2022-11-24 14:03:52',NULL);
INSERT INTO `balance_libro_details` VALUES (1694,7638,544,40737,28794,3,68,1,449.50,NULL,'2022-11-24 14:03:52','2022-11-24 14:03:52',NULL),(1695,7638,544,40737,28794,3,57,2,2590.00,NULL,'2022-11-24 14:03:52','2022-11-24 14:03:52',NULL),(1696,7638,545,40739,32142,2,218,2,0.00,NULL,'2022-11-24 14:09:05','2022-11-24 14:09:05',NULL),(1697,7638,545,40739,32142,2,218,2,147746.43,NULL,'2022-11-24 14:09:05','2022-11-24 14:09:05',NULL),(1698,7638,545,40739,32142,2,13,1,147746.43,NULL,'2022-11-24 14:09:05','2022-11-24 14:09:05',NULL),(1699,7638,546,40739,32142,2,218,2,0.00,NULL,'2022-11-24 14:09:05','2022-11-24 14:09:05',NULL),(1700,7638,546,40739,32142,2,218,2,201177.66,NULL,'2022-11-24 14:09:05','2022-11-24 14:09:05',NULL),(1701,7638,546,40739,32142,2,13,1,201177.66,NULL,'2022-11-24 14:09:05','2022-11-24 14:09:05',NULL),(1702,7638,547,40739,32142,2,218,2,0.00,NULL,'2022-11-24 14:09:05','2022-11-24 14:09:05',NULL),(1703,7638,547,40739,32142,2,218,2,5281.15,NULL,'2022-11-24 14:09:05','2022-11-24 14:09:05',NULL),(1704,7638,547,40739,32142,2,13,1,5281.15,NULL,'2022-11-24 14:09:05','2022-11-24 14:09:05',NULL),(1705,7638,548,40739,32142,2,96,2,89713.88,NULL,'2022-11-24 14:09:05','2022-11-24 14:09:05',NULL),(1706,7638,548,40739,32142,2,67,2,9419.96,NULL,'2022-11-24 14:09:05','2022-11-24 14:09:05',NULL),(1707,7638,548,40739,32142,2,218,2,12387.12,NULL,'2022-11-24 14:09:05','2022-11-24 14:09:05',NULL),(1708,7638,548,40739,32142,2,13,1,111520.96,NULL,'2022-11-24 14:09:05','2022-11-24 14:09:05',NULL),(1709,7638,549,40739,32142,2,96,2,319375.00,NULL,'2022-11-24 14:09:05','2022-11-24 14:09:05',NULL),(1710,7638,549,40739,32142,2,67,2,33534.38,NULL,'2022-11-24 14:09:05','2022-11-24 14:09:05',NULL),(1711,7638,549,40739,32142,2,13,1,352909.38,NULL,'2022-11-24 14:09:05','2022-11-24 14:09:05',NULL),(1712,7638,550,40739,32142,2,96,2,75797.00,NULL,'2022-11-24 14:09:05','2022-11-24 14:09:05',NULL),(1713,7638,550,40739,32142,2,67,2,7958.68,NULL,'2022-11-24 14:09:05','2022-11-24 14:09:05',NULL),(1714,7638,550,40739,32142,2,13,1,83755.68,NULL,'2022-11-24 14:09:05','2022-11-24 14:09:05',NULL),(1715,7638,551,40739,32142,2,96,2,1953.00,NULL,'2022-11-24 14:09:05','2022-11-24 14:09:05',NULL),(1716,7638,551,40739,32142,2,67,2,205.06,NULL,'2022-11-24 14:09:05','2022-11-24 14:09:05',NULL),(1717,7638,551,40739,32142,2,218,2,4678.11,NULL,'2022-11-24 14:09:05','2022-11-24 14:09:05',NULL),(1718,7638,551,40739,32142,2,13,1,6836.17,NULL,'2022-11-24 14:09:05','2022-11-24 14:09:05',NULL),(1719,7638,552,40739,32142,2,96,2,5258.29,NULL,'2022-11-24 14:09:06','2022-11-24 14:09:06',NULL),(1720,7638,552,40739,32142,2,67,2,552.12,NULL,'2022-11-24 14:09:06','2022-11-24 14:09:06',NULL),(1721,7638,552,40739,32142,2,218,2,10889.12,NULL,'2022-11-24 14:09:06','2022-11-24 14:09:06',NULL),(1722,7638,552,40739,32142,2,13,1,16699.53,NULL,'2022-11-24 14:09:06','2022-11-24 14:09:06',NULL),(1723,7638,553,40739,32142,2,218,2,0.00,NULL,'2022-11-24 14:09:06','2022-11-24 14:09:06',NULL),(1724,7638,553,40739,32142,2,218,2,201474.04,NULL,'2022-11-24 14:09:06','2022-11-24 14:09:06',NULL),(1725,7638,553,40739,32142,2,13,1,201474.04,NULL,'2022-11-24 14:09:06','2022-11-24 14:09:06',NULL),(1726,7638,554,40739,32142,2,218,2,0.00,NULL,'2022-11-24 14:09:06','2022-11-24 14:09:06',NULL),(1727,7638,554,40739,32142,2,218,2,153525.88,NULL,'2022-11-24 14:09:06','2022-11-24 14:09:06',NULL),(1728,7638,554,40739,32142,2,13,1,153525.88,NULL,'2022-11-24 14:09:06','2022-11-24 14:09:06',NULL),(1729,7638,555,40739,32142,2,218,2,0.00,NULL,'2022-11-24 14:09:06','2022-11-24 14:09:06',NULL),(1730,7638,555,40739,32142,2,218,2,143580.00,NULL,'2022-11-24 14:09:06','2022-11-24 14:09:06',NULL),(1731,7638,555,40739,32142,2,13,1,143580.00,NULL,'2022-11-24 14:09:06','2022-11-24 14:09:06',NULL),(1732,7638,556,40739,32142,3,217,1,36148.76,NULL,'2022-11-24 14:09:17','2022-11-24 14:09:17',NULL),(1733,7638,556,40739,32142,3,68,1,7591.23,NULL,'2022-11-24 14:09:17','2022-11-24 14:09:17',NULL),(1734,7638,556,40739,32142,3,217,1,0.01,NULL,'2022-11-24 14:09:17','2022-11-24 14:09:17',NULL);
INSERT INTO `balance_libro_details` VALUES (1735,7638,556,40739,32142,3,57,2,43740.00,NULL,'2022-11-24 14:09:17','2022-11-24 14:09:17',NULL),(1736,7638,557,40739,32142,3,217,1,2759.34,NULL,'2022-11-24 14:09:17','2022-11-24 14:09:17',NULL),(1737,7638,557,40739,32142,3,68,1,579.46,NULL,'2022-11-24 14:09:17','2022-11-24 14:09:17',NULL),(1738,7638,557,40739,32142,3,217,1,82.78,NULL,'2022-11-24 14:09:17','2022-11-24 14:09:17',NULL),(1739,7638,557,40739,32142,3,57,2,3421.58,NULL,'2022-11-24 14:09:17','2022-11-24 14:09:17',NULL),(1740,7638,558,40739,32142,3,217,1,9320.00,NULL,'2022-11-24 14:09:17','2022-11-24 14:09:17',NULL),(1741,7638,558,40739,32142,3,68,1,2051.76,NULL,'2022-11-24 14:09:17','2022-11-24 14:09:17',NULL),(1742,7638,558,40739,32142,3,217,1,279.60,NULL,'2022-11-24 14:09:17','2022-11-24 14:09:17',NULL),(1743,7638,558,40739,32142,3,57,2,11651.36,NULL,'2022-11-24 14:09:17','2022-11-24 14:09:17',NULL),(1744,7638,559,40739,32142,3,217,1,4156.99,NULL,'2022-11-24 14:09:17','2022-11-24 14:09:17',NULL),(1745,7638,559,40739,32142,3,68,1,872.97,NULL,'2022-11-24 14:09:17','2022-11-24 14:09:17',NULL),(1746,7638,559,40739,32142,3,217,1,920.84,NULL,'2022-11-24 14:09:17','2022-11-24 14:09:17',NULL),(1747,7638,559,40739,32142,3,57,2,5950.80,NULL,'2022-11-24 14:09:17','2022-11-24 14:09:17',NULL),(1748,7638,560,40739,32142,3,217,1,5441.42,NULL,'2022-11-24 14:09:17','2022-11-24 14:09:17',NULL),(1749,7638,560,40739,32142,3,68,1,1142.70,NULL,'2022-11-24 14:09:17','2022-11-24 14:09:17',NULL),(1750,7638,560,40739,32142,3,217,1,17.39,NULL,'2022-11-24 14:09:17','2022-11-24 14:09:17',NULL),(1751,7638,560,40739,32142,3,57,2,6601.51,NULL,'2022-11-24 14:09:17','2022-11-24 14:09:17',NULL),(1752,7638,561,40739,32142,3,217,1,4660.59,NULL,'2022-11-24 14:09:17','2022-11-24 14:09:17',NULL),(1753,7638,561,40739,32142,3,68,1,978.72,NULL,'2022-11-24 14:09:17','2022-11-24 14:09:17',NULL),(1754,7638,561,40739,32142,3,217,1,139.82,NULL,'2022-11-24 14:09:17','2022-11-24 14:09:17',NULL),(1755,7638,561,40739,32142,3,57,2,5779.13,NULL,'2022-11-24 14:09:17','2022-11-24 14:09:17',NULL),(1756,7638,562,40739,32142,3,217,1,112.40,NULL,'2022-11-24 14:09:18','2022-11-24 14:09:18',NULL),(1757,7638,562,40739,32142,3,68,1,23.60,NULL,'2022-11-24 14:09:18','2022-11-24 14:09:18',NULL),(1758,7638,562,40739,32142,3,57,2,136.00,NULL,'2022-11-24 14:09:18','2022-11-24 14:09:18',NULL),(1759,7638,563,40739,32142,3,217,1,347.43,NULL,'2022-11-24 14:09:18','2022-11-24 14:09:18',NULL),(1760,7638,563,40739,32142,3,68,1,72.95,NULL,'2022-11-24 14:09:18','2022-11-24 14:09:18',NULL),(1761,7638,563,40739,32142,3,217,1,34.74,NULL,'2022-11-24 14:09:18','2022-11-24 14:09:18',NULL),(1762,7638,563,40739,32142,3,57,2,455.12,NULL,'2022-11-24 14:09:18','2022-11-24 14:09:18',NULL),(1763,7638,564,40739,32142,3,217,1,6114.05,NULL,'2022-11-24 14:09:18','2022-11-24 14:09:18',NULL),(1764,7638,564,40739,32142,3,68,1,1283.95,NULL,'2022-11-24 14:09:18','2022-11-24 14:09:18',NULL),(1765,7638,564,40739,32142,3,57,2,7398.00,NULL,'2022-11-24 14:09:18','2022-11-24 14:09:18',NULL),(1766,7638,565,40739,32142,3,217,1,13575.57,NULL,'2022-11-24 14:09:18','2022-11-24 14:09:18',NULL),(1767,7638,565,40739,32142,3,68,1,1425.43,NULL,'2022-11-24 14:09:18','2022-11-24 14:09:18',NULL),(1768,7638,565,40739,32142,3,57,2,15001.00,NULL,'2022-11-24 14:09:18','2022-11-24 14:09:18',NULL),(1769,7638,566,40739,32142,3,217,1,12574.62,NULL,'2022-11-24 14:09:18','2022-11-24 14:09:18',NULL),(1770,7638,566,40739,32142,3,68,1,2513.44,NULL,'2022-11-24 14:09:18','2022-11-24 14:09:18',NULL),(1771,7638,566,40739,32142,3,217,1,343.74,NULL,'2022-11-24 14:09:18','2022-11-24 14:09:18',NULL),(1772,7638,566,40739,32142,3,57,2,15431.80,NULL,'2022-11-24 14:09:18','2022-11-24 14:09:18',NULL),(1773,7638,567,40739,32142,3,250,1,0.00,NULL,'2022-11-24 14:09:18','2022-11-24 14:09:18',NULL),(1774,7638,567,40739,32142,3,250,1,2250.00,NULL,'2022-11-24 14:09:18','2022-11-24 14:09:18',NULL),(1775,7638,567,40739,32142,3,57,2,2250.00,NULL,'2022-11-24 14:09:18','2022-11-24 14:09:18',NULL);
INSERT INTO `balance_libro_details` VALUES (1776,7638,568,40739,32142,3,217,1,11983.47,NULL,'2022-11-24 14:09:18','2022-11-24 14:09:18',NULL),(1777,7638,568,40739,32142,3,68,1,2516.53,NULL,'2022-11-24 14:09:18','2022-11-24 14:09:18',NULL),(1778,7638,568,40739,32142,3,57,2,14500.00,NULL,'2022-11-24 14:09:18','2022-11-24 14:09:18',NULL),(1779,7638,569,40739,32142,3,217,1,111.57,NULL,'2022-11-24 14:09:18','2022-11-24 14:09:18',NULL),(1780,7638,569,40739,32142,3,68,1,23.43,NULL,'2022-11-24 14:09:18','2022-11-24 14:09:18',NULL),(1781,7638,569,40739,32142,3,57,2,135.00,NULL,'2022-11-24 14:09:18','2022-11-24 14:09:18',NULL),(1782,7638,570,40739,32142,3,250,1,0.00,NULL,'2022-11-24 14:09:18','2022-11-24 14:09:18',NULL),(1783,7638,570,40739,32142,3,250,1,1820.00,NULL,'2022-11-24 14:09:18','2022-11-24 14:09:18',NULL),(1784,7638,570,40739,32142,3,57,2,1820.00,NULL,'2022-11-24 14:09:18','2022-11-24 14:09:18',NULL),(1785,7638,571,40748,46704,2,96,2,6611.57,NULL,'2022-11-24 14:11:42','2022-11-24 14:11:42',NULL),(1786,7638,571,40748,46704,2,67,2,1388.43,NULL,'2022-11-24 14:11:42','2022-11-24 14:11:42',NULL),(1787,7638,571,40748,46704,2,13,1,8000.00,NULL,'2022-11-24 14:11:42','2022-11-24 14:11:42',NULL),(1788,7638,572,40748,46704,3,217,1,22092.98,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1789,7638,572,40748,46704,3,68,1,4639.52,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1790,7638,572,40748,46704,3,57,2,26732.50,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1791,7638,573,40748,46704,3,217,1,115504.05,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1792,7638,573,40748,46704,3,68,1,24255.85,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1793,7638,573,40748,46704,3,57,2,139759.90,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1794,7638,574,40748,46704,3,217,2,115504.05,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1795,7638,574,40748,46704,3,67,2,24255.85,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1796,7638,574,40748,46704,3,57,1,139759.90,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1797,7638,575,40748,46704,3,217,1,115791.77,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1798,7638,575,40748,46704,3,68,1,24316.27,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1799,7638,575,40748,46704,3,57,2,140108.04,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1800,7638,576,40748,46704,3,217,1,62332.21,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1801,7638,576,40748,46704,3,68,1,13089.77,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1802,7638,576,40748,46704,3,57,2,75421.98,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1803,7638,577,40748,46704,3,217,1,8364.05,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1804,7638,577,40748,46704,3,68,1,1756.45,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1805,7638,577,40748,46704,3,57,2,10120.50,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1806,7638,578,40748,46704,3,217,1,22727.44,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1807,7638,578,40748,46704,3,68,1,4772.76,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1808,7638,578,40748,46704,3,217,1,454.55,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1809,7638,578,40748,46704,3,57,2,27954.75,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1810,7638,579,40748,46704,3,217,1,2479.34,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1811,7638,579,40748,46704,3,68,1,520.66,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1812,7638,579,40748,46704,3,217,1,49.59,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1813,7638,579,40748,46704,3,57,2,3049.59,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1814,7638,580,40748,46704,3,217,1,36426.86,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1815,7638,580,40748,46704,3,68,1,7649.64,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL);
INSERT INTO `balance_libro_details` VALUES (1816,7638,580,40748,46704,3,57,2,44076.50,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1817,7638,581,40748,46704,3,217,1,44933.41,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1818,7638,581,40748,46704,3,68,1,9436.02,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1819,7638,581,40748,46704,3,217,1,1123.33,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1820,7638,581,40748,46704,3,57,2,55492.76,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1821,7638,582,40748,46704,3,217,1,30871.90,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1822,7638,582,40748,46704,3,68,1,6483.10,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1823,7638,582,40748,46704,3,217,1,617.44,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1824,7638,582,40748,46704,3,57,2,37972.44,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1825,7638,583,40748,46704,3,217,1,17996.37,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1826,7638,583,40748,46704,3,68,1,3779.24,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1827,7638,583,40748,46704,3,57,2,21775.61,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1828,7638,584,40748,46704,3,217,1,1371.60,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1829,7638,584,40748,46704,3,68,1,288.04,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1830,7638,584,40748,46704,3,217,1,34.29,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1831,7638,584,40748,46704,3,57,2,1693.93,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1832,7638,585,40748,46704,3,217,1,1371.60,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1833,7638,585,40748,46704,3,68,1,288.04,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1834,7638,585,40748,46704,3,217,1,34.29,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1835,7638,585,40748,46704,3,57,2,1693.93,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1836,7638,586,40748,46704,3,217,1,21427.69,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1837,7638,586,40748,46704,3,68,1,4499.81,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1838,7638,586,40748,46704,3,217,1,428.55,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1839,7638,586,40748,46704,3,57,2,26356.05,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1840,7638,587,40748,46704,3,217,1,34750.41,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1841,7638,587,40748,46704,3,68,1,7297.59,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1842,7638,587,40748,46704,3,57,2,42048.00,NULL,'2022-11-24 14:12:06','2022-11-24 14:12:06',NULL),(1843,7638,588,40748,46704,3,217,1,13413.22,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1844,7638,588,40748,46704,3,68,1,2816.78,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1845,7638,588,40748,46704,3,217,1,268.26,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1846,7638,588,40748,46704,3,57,2,16498.26,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1847,7638,589,40748,46704,3,217,1,7601.80,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1848,7638,589,40748,46704,3,68,1,798.19,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1849,7638,589,40748,46704,3,57,2,8399.99,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1850,7638,590,40748,46704,3,217,1,81619.90,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1851,7638,590,40748,46704,3,68,1,17140.18,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1852,7638,590,40748,46704,3,217,1,3264.80,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1853,7638,590,40748,46704,3,57,2,102024.88,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1854,7638,591,40748,46704,3,217,1,13223.14,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1855,7638,591,40748,46704,3,68,1,2776.86,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1856,7638,591,40748,46704,3,217,1,264.46,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL);
INSERT INTO `balance_libro_details` VALUES (1857,7638,591,40748,46704,3,57,2,16264.46,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1858,7638,592,40748,46704,3,217,1,842.15,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1859,7638,592,40748,46704,3,68,1,176.85,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1860,7638,592,40748,46704,3,57,2,1019.00,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1861,7638,593,40748,46704,3,217,1,842.15,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1862,7638,593,40748,46704,3,68,1,176.85,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1863,7638,593,40748,46704,3,57,2,1019.00,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1864,7638,594,40748,46704,3,217,1,17872.65,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1865,7638,594,40748,46704,3,68,1,3753.25,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1866,7638,594,40748,46704,3,57,2,21625.90,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1867,7638,595,40748,46704,3,217,1,6611.57,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1868,7638,595,40748,46704,3,68,1,1388.43,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1869,7638,595,40748,46704,3,217,1,132.23,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1870,7638,595,40748,46704,3,57,2,8132.23,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1871,7638,596,40748,46704,3,217,1,2479.34,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1872,7638,596,40748,46704,3,68,1,520.66,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1873,7638,596,40748,46704,3,217,1,49.59,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1874,7638,596,40748,46704,3,57,2,3049.59,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1875,7638,597,40748,46704,3,250,1,10000.00,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1876,7638,597,40748,46704,3,57,2,10000.00,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1877,7638,598,40748,46704,3,217,1,4169.34,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1878,7638,598,40748,46704,3,68,1,875.56,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1879,7638,598,40748,46704,3,217,1,981.03,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1880,7638,598,40748,46704,3,57,2,6025.93,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1881,7638,599,40748,46704,3,217,1,19028.74,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1882,7638,599,40748,46704,3,68,1,3996.03,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1883,7638,599,40748,46704,3,57,2,23024.77,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1884,7638,600,40748,46704,3,217,1,3357.59,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1885,7638,600,40748,46704,3,68,1,705.09,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1886,7638,600,40748,46704,3,217,1,787.62,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1887,7638,600,40748,46704,3,57,2,4850.30,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1888,7638,601,40748,46704,3,217,1,2085.40,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1889,7638,601,40748,46704,3,68,1,437.93,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1890,7638,601,40748,46704,3,217,1,540.71,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1891,7638,601,40748,46704,3,57,2,3064.04,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1892,7638,602,40748,46704,3,217,1,23789.39,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1893,7638,602,40748,46704,3,68,1,4995.77,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1894,7638,602,40748,46704,3,57,2,28785.16,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1895,7638,603,40748,46704,3,217,1,81863.82,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1896,7638,603,40748,46704,3,68,1,17191.40,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1897,7638,603,40748,46704,3,57,2,99055.22,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL);
INSERT INTO `balance_libro_details` VALUES (1898,7638,604,40748,46704,3,217,1,158812.98,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1899,7638,604,40748,46704,3,68,1,33350.73,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1900,7638,604,40748,46704,3,57,2,192163.71,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1901,7638,605,40748,46704,3,217,1,5418.73,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1902,7638,605,40748,46704,3,68,1,1137.93,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1903,7638,605,40748,46704,3,57,2,6556.66,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1904,7638,606,40748,46704,3,217,2,4471.84,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1905,7638,606,40748,46704,3,67,2,939.09,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1906,7638,606,40748,46704,3,57,1,5410.93,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1907,7638,607,40748,46704,3,217,1,22853.62,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1908,7638,607,40748,46704,3,68,1,4799.26,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1909,7638,607,40748,46704,3,57,2,27652.88,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1910,7638,608,40748,46704,3,217,1,33884.30,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1911,7638,608,40748,46704,3,68,1,7115.70,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1912,7638,608,40748,46704,3,57,2,41000.00,NULL,'2022-11-24 14:12:07','2022-11-24 14:12:07',NULL),(1913,7638,609,40743,38883,2,96,2,5839.00,NULL,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(1914,7638,609,40743,38883,2,67,2,1226.19,NULL,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(1915,7638,609,40743,38883,2,13,1,7065.19,NULL,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(1916,7638,610,40743,38883,2,96,2,2453.00,NULL,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(1917,7638,610,40743,38883,2,67,2,515.13,NULL,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(1918,7638,610,40743,38883,2,13,1,2968.13,NULL,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(1919,7638,611,40743,38883,2,96,2,4462.00,NULL,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(1920,7638,611,40743,38883,2,67,2,937.02,NULL,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(1921,7638,611,40743,38883,2,13,1,5399.02,NULL,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(1922,7638,612,40743,38883,2,96,2,15479.00,NULL,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(1923,7638,612,40743,38883,2,67,2,3250.59,NULL,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(1924,7638,612,40743,38883,2,13,1,18729.59,NULL,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(1925,7638,613,40743,38883,2,96,2,57851.24,NULL,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(1926,7638,613,40743,38883,2,67,2,12148.76,NULL,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(1927,7638,613,40743,38883,2,13,1,70000.00,NULL,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(1928,7638,614,40743,38883,2,96,2,8067.00,NULL,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(1929,7638,614,40743,38883,2,67,2,1694.07,NULL,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(1930,7638,614,40743,38883,2,13,1,9761.07,NULL,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(1931,7638,615,40743,38883,2,96,2,8430.00,NULL,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(1932,7638,615,40743,38883,2,67,2,1770.30,NULL,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(1933,7638,615,40743,38883,2,13,1,10200.30,NULL,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(1934,7638,616,40743,38883,2,96,2,34196.00,NULL,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(1935,7638,616,40743,38883,2,67,2,7181.16,NULL,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(1936,7638,616,40743,38883,2,13,1,41377.16,NULL,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(1937,7638,617,40743,38883,2,96,2,71900.00,NULL,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(1938,7638,617,40743,38883,2,67,2,15099.00,NULL,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL);
INSERT INTO `balance_libro_details` VALUES (1939,7638,617,40743,38883,2,13,1,86999.00,NULL,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(1940,7638,618,40743,38883,2,96,2,6908.00,NULL,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(1941,7638,618,40743,38883,2,67,2,1450.68,NULL,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(1942,7638,618,40743,38883,2,13,1,8358.68,NULL,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(1943,7638,619,40743,38883,2,96,2,14038.00,NULL,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(1944,7638,619,40743,38883,2,67,2,2947.98,NULL,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(1945,7638,619,40743,38883,2,13,1,16985.98,NULL,'2022-11-24 14:15:24','2022-11-24 14:15:24',NULL),(1946,7638,620,40743,38883,2,96,2,2453.00,NULL,'2022-11-24 14:15:25','2022-11-24 14:15:25',NULL),(1947,7638,620,40743,38883,2,67,2,515.13,NULL,'2022-11-24 14:15:25','2022-11-24 14:15:25',NULL),(1948,7638,620,40743,38883,2,13,1,2968.13,NULL,'2022-11-24 14:15:25','2022-11-24 14:15:25',NULL),(1949,7638,621,40743,38883,2,96,2,3535.54,NULL,'2022-11-24 14:15:25','2022-11-24 14:15:25',NULL),(1950,7638,621,40743,38883,2,67,2,742.46,NULL,'2022-11-24 14:15:25','2022-11-24 14:15:25',NULL),(1951,7638,621,40743,38883,2,13,1,4278.00,NULL,'2022-11-24 14:15:25','2022-11-24 14:15:25',NULL),(1952,7638,622,40743,38883,2,96,2,33057.85,NULL,'2022-11-24 14:15:25','2022-11-24 14:15:25',NULL),(1953,7638,622,40743,38883,2,67,2,6942.15,NULL,'2022-11-24 14:15:25','2022-11-24 14:15:25',NULL),(1954,7638,622,40743,38883,2,13,1,40000.00,NULL,'2022-11-24 14:15:25','2022-11-24 14:15:25',NULL),(1955,7638,623,40743,38883,2,96,2,8500.00,NULL,'2022-11-24 14:15:25','2022-11-24 14:15:25',NULL),(1956,7638,623,40743,38883,2,67,2,1785.00,NULL,'2022-11-24 14:15:25','2022-11-24 14:15:25',NULL),(1957,7638,623,40743,38883,2,13,1,10285.00,NULL,'2022-11-24 14:15:25','2022-11-24 14:15:25',NULL),(1958,7638,624,40743,38883,2,96,2,11310.00,NULL,'2022-11-24 14:15:25','2022-11-24 14:15:25',NULL),(1959,7638,624,40743,38883,2,67,2,2375.10,NULL,'2022-11-24 14:15:25','2022-11-24 14:15:25',NULL),(1960,7638,624,40743,38883,2,13,1,13685.10,NULL,'2022-11-24 14:15:25','2022-11-24 14:15:25',NULL),(1961,7638,625,40743,38883,2,96,2,3042.00,NULL,'2022-11-24 14:15:25','2022-11-24 14:15:25',NULL),(1962,7638,625,40743,38883,2,67,2,638.82,NULL,'2022-11-24 14:15:25','2022-11-24 14:15:25',NULL),(1963,7638,625,40743,38883,2,13,1,3680.82,NULL,'2022-11-24 14:15:25','2022-11-24 14:15:25',NULL),(1964,7638,626,40743,38883,2,96,2,11500.00,NULL,'2022-11-24 14:15:25','2022-11-24 14:15:25',NULL),(1965,7638,626,40743,38883,2,67,2,2415.00,NULL,'2022-11-24 14:15:25','2022-11-24 14:15:25',NULL),(1966,7638,626,40743,38883,2,13,1,13915.00,NULL,'2022-11-24 14:15:25','2022-11-24 14:15:25',NULL),(1967,7638,627,40743,38883,2,96,2,14876.03,NULL,'2022-11-24 14:15:25','2022-11-24 14:15:25',NULL),(1968,7638,627,40743,38883,2,67,2,3123.97,NULL,'2022-11-24 14:15:25','2022-11-24 14:15:25',NULL),(1969,7638,627,40743,38883,2,13,1,18000.00,NULL,'2022-11-24 14:15:25','2022-11-24 14:15:25',NULL),(1970,7638,628,40743,38883,3,250,1,24519.03,NULL,'2022-11-24 14:15:35','2022-11-24 14:15:35',NULL),(1971,7638,628,40743,38883,3,57,2,24519.03,NULL,'2022-11-24 14:15:35','2022-11-24 14:15:35',NULL),(1972,7638,629,40743,38883,3,217,1,148726.24,NULL,'2022-11-24 14:15:35','2022-11-24 14:15:35',NULL),(1973,7638,629,40743,38883,3,68,1,31232.51,NULL,'2022-11-24 14:15:35','2022-11-24 14:15:35',NULL),(1974,7638,629,40743,38883,3,217,1,3718.16,NULL,'2022-11-24 14:15:35','2022-11-24 14:15:35',NULL),(1975,7638,629,40743,38883,3,57,2,183676.91,NULL,'2022-11-24 14:15:35','2022-11-24 14:15:35',NULL),(1976,7638,630,40743,38883,3,217,1,73119.85,NULL,'2022-11-24 14:15:35','2022-11-24 14:15:35',NULL),(1977,7638,630,40743,38883,3,68,1,15355.17,NULL,'2022-11-24 14:15:35','2022-11-24 14:15:35',NULL),(1978,7638,630,40743,38883,3,57,2,88475.02,NULL,'2022-11-24 14:15:35','2022-11-24 14:15:35',NULL),(1979,7638,631,40743,38883,3,217,2,6689.00,NULL,'2022-11-24 14:15:35','2022-11-24 14:15:35',NULL);
INSERT INTO `balance_libro_details` VALUES (1980,7638,631,40743,38883,3,67,2,702.35,NULL,'2022-11-24 14:15:35','2022-11-24 14:15:35',NULL),(1981,7638,631,40743,38883,3,57,1,7391.35,NULL,'2022-11-24 14:15:35','2022-11-24 14:15:35',NULL),(1982,7638,632,40743,38883,3,217,1,161018.71,NULL,'2022-11-24 14:15:35','2022-11-24 14:15:35',NULL),(1983,7638,632,40743,38883,3,68,1,33813.94,NULL,'2022-11-24 14:15:35','2022-11-24 14:15:35',NULL),(1984,7638,632,40743,38883,3,57,2,194832.65,NULL,'2022-11-24 14:15:35','2022-11-24 14:15:35',NULL),(1985,NULL,633,40745,42010,2,96,2,1016.53,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(1986,NULL,633,40745,42010,2,67,2,213.47,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(1987,NULL,633,40745,42010,2,13,1,1230.00,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(1988,NULL,634,40745,42010,2,96,2,305.79,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(1989,NULL,634,40745,42010,2,67,2,64.21,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(1990,NULL,634,40745,42010,2,13,1,370.00,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(1991,NULL,635,40745,42010,2,96,2,743.80,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(1992,NULL,635,40745,42010,2,67,2,156.20,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(1993,NULL,635,40745,42010,2,13,1,900.00,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(1994,NULL,636,40745,42010,2,96,2,1123.97,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(1995,NULL,636,40745,42010,2,67,2,236.03,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(1996,NULL,636,40745,42010,2,13,1,1360.00,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(1997,NULL,637,40745,42010,2,96,2,363.64,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(1998,NULL,637,40745,42010,2,67,2,76.36,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(1999,NULL,637,40745,42010,2,13,1,440.00,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2000,NULL,638,40745,42010,2,96,2,586.78,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2001,NULL,638,40745,42010,2,67,2,123.22,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2002,NULL,638,40745,42010,2,13,1,710.00,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2003,NULL,639,40745,42010,2,96,2,4921.49,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2004,NULL,639,40745,42010,2,67,2,1033.51,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2005,NULL,639,40745,42010,2,13,1,5955.00,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2006,NULL,640,40745,42010,2,96,2,826.45,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2007,NULL,640,40745,42010,2,67,2,173.55,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2008,NULL,640,40745,42010,2,13,1,1000.00,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2009,NULL,641,40745,42010,2,96,2,82.64,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2010,NULL,641,40745,42010,2,67,2,17.36,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2011,NULL,641,40745,42010,2,13,1,100.00,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2012,NULL,642,40745,42010,2,96,2,438.02,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2013,NULL,642,40745,42010,2,67,2,91.98,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2014,NULL,642,40745,42010,2,13,1,530.00,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2015,NULL,643,40745,42010,2,96,2,1066.12,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2016,NULL,643,40745,42010,2,67,2,223.88,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2017,NULL,643,40745,42010,2,13,1,1290.00,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2018,NULL,644,40745,42010,2,96,2,595.04,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2019,NULL,644,40745,42010,2,67,2,124.96,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2020,NULL,644,40745,42010,2,13,1,720.00,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL);
INSERT INTO `balance_libro_details` VALUES (2021,NULL,645,40745,42010,2,96,2,429.75,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2022,NULL,645,40745,42010,2,67,2,90.25,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2023,NULL,645,40745,42010,2,13,1,520.00,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2024,NULL,646,40745,42010,2,96,2,4809.92,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2025,NULL,646,40745,42010,2,67,2,1010.08,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2026,NULL,646,40745,42010,2,13,1,5820.00,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2027,NULL,647,40745,42010,2,96,2,268.60,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2028,NULL,647,40745,42010,2,67,2,56.40,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2029,NULL,647,40745,42010,2,13,1,325.00,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2030,NULL,648,40745,42010,2,96,2,363.64,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2031,NULL,648,40745,42010,2,67,2,76.36,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2032,NULL,648,40745,42010,2,13,1,440.00,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2033,NULL,649,40745,42010,2,96,2,363.64,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2034,NULL,649,40745,42010,2,67,2,76.36,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2035,NULL,649,40745,42010,2,13,1,440.00,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2036,NULL,650,40745,42010,2,96,2,628.10,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2037,NULL,650,40745,42010,2,67,2,131.90,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2038,NULL,650,40745,42010,2,13,1,760.00,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2039,NULL,651,40745,42010,2,96,2,826.45,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2040,NULL,651,40745,42010,2,67,2,173.55,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2041,NULL,651,40745,42010,2,13,1,1000.00,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2042,NULL,652,40745,42010,2,96,2,3099.17,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2043,NULL,652,40745,42010,2,67,2,650.83,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2044,NULL,652,40745,42010,2,13,1,3750.00,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2045,NULL,653,40745,42010,2,96,2,1553.72,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2046,NULL,653,40745,42010,2,67,2,326.28,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2047,NULL,653,40745,42010,2,13,1,1880.00,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2048,NULL,654,40745,42010,2,96,2,446.28,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2049,NULL,654,40745,42010,2,67,2,93.72,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2050,NULL,654,40745,42010,2,13,1,540.00,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2051,NULL,655,40745,42010,2,96,2,1480.17,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2052,NULL,655,40745,42010,2,67,2,310.83,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2053,NULL,655,40745,42010,2,13,1,1791.00,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2054,NULL,656,40745,42010,2,96,2,1338.84,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2055,NULL,656,40745,42010,2,67,2,281.16,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2056,NULL,656,40745,42010,2,13,1,1620.00,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2057,NULL,657,40745,42010,2,96,2,603.31,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2058,NULL,657,40745,42010,2,67,2,126.69,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2059,NULL,657,40745,42010,2,13,1,730.00,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2060,NULL,658,40745,42010,2,96,2,1652.89,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2061,NULL,658,40745,42010,2,67,2,347.11,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL);
INSERT INTO `balance_libro_details` VALUES (2062,NULL,658,40745,42010,2,13,1,2000.00,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2063,NULL,659,40745,42010,2,96,2,1322.31,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2064,NULL,659,40745,42010,2,67,2,277.69,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2065,NULL,659,40745,42010,2,13,1,1600.00,NULL,'2022-11-24 14:20:31','2022-11-24 14:20:31',NULL),(2066,NULL,660,40745,42010,2,96,2,264.46,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2067,NULL,660,40745,42010,2,67,2,55.54,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2068,NULL,660,40745,42010,2,13,1,320.00,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2069,NULL,661,40745,42010,2,96,2,1198.35,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2070,NULL,661,40745,42010,2,67,2,251.65,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2071,NULL,661,40745,42010,2,13,1,1450.00,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2072,NULL,662,40745,42010,2,96,2,628.10,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2073,NULL,662,40745,42010,2,67,2,131.90,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2074,NULL,662,40745,42010,2,13,1,760.00,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2075,NULL,663,40745,42010,2,96,2,1314.05,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2076,NULL,663,40745,42010,2,67,2,275.95,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2077,NULL,663,40745,42010,2,13,1,1590.00,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2078,NULL,664,40745,42010,2,96,2,1239.67,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2079,NULL,664,40745,42010,2,67,2,260.33,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2080,NULL,664,40745,42010,2,13,1,1500.00,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2081,NULL,665,40745,42010,2,96,2,929.75,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2082,NULL,665,40745,42010,2,67,2,195.25,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2083,NULL,665,40745,42010,2,13,1,1125.00,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2084,NULL,666,40745,42010,2,96,2,909.09,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2085,NULL,666,40745,42010,2,67,2,190.91,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2086,NULL,666,40745,42010,2,13,1,1100.00,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2087,NULL,667,40745,42010,2,96,2,826.45,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2088,NULL,667,40745,42010,2,67,2,173.55,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2089,NULL,667,40745,42010,2,13,1,1000.00,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2090,NULL,668,40745,42010,2,96,2,454.55,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2091,NULL,668,40745,42010,2,67,2,95.45,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2092,NULL,668,40745,42010,2,13,1,550.00,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2093,NULL,669,40745,42010,2,96,2,3099.17,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2094,NULL,669,40745,42010,2,67,2,650.83,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2095,NULL,669,40745,42010,2,13,1,3750.00,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2096,NULL,670,40745,42010,2,96,2,388.43,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2097,NULL,670,40745,42010,2,67,2,81.57,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2098,NULL,670,40745,42010,2,13,1,470.00,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2099,NULL,671,40745,42010,2,96,2,446.28,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2100,NULL,671,40745,42010,2,67,2,93.72,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2101,NULL,671,40745,42010,2,13,1,540.00,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2102,NULL,672,40745,42010,2,96,2,2004.13,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL);
INSERT INTO `balance_libro_details` VALUES (2103,NULL,672,40745,42010,2,67,2,420.87,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2104,NULL,672,40745,42010,2,13,1,2425.00,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2105,NULL,673,40745,42010,2,96,2,123.97,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2106,NULL,673,40745,42010,2,67,2,26.03,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2107,NULL,673,40745,42010,2,13,1,150.00,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2108,NULL,674,40745,42010,2,96,2,396.69,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2109,NULL,674,40745,42010,2,67,2,83.31,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2110,NULL,674,40745,42010,2,13,1,480.00,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2111,NULL,675,40745,42010,2,96,2,1074.38,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2112,NULL,675,40745,42010,2,67,2,225.62,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2113,NULL,675,40745,42010,2,13,1,1300.00,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2114,NULL,676,40745,42010,2,96,2,6446.28,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2115,NULL,676,40745,42010,2,67,2,1353.72,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2116,NULL,676,40745,42010,2,13,1,7800.00,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2117,NULL,677,40745,42010,2,96,2,247.93,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2118,NULL,677,40745,42010,2,67,2,52.07,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2119,NULL,677,40745,42010,2,13,1,300.00,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2120,NULL,678,40745,42010,2,96,2,644.63,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2121,NULL,678,40745,42010,2,67,2,135.37,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2122,NULL,678,40745,42010,2,13,1,780.00,NULL,'2022-11-24 14:20:32','2022-11-24 14:20:32',NULL),(2123,NULL,679,40745,42010,2,96,2,297.52,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2124,NULL,679,40745,42010,2,67,2,62.48,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2125,NULL,679,40745,42010,2,13,1,360.00,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2126,NULL,680,40745,42010,2,96,2,3165.29,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2127,NULL,680,40745,42010,2,67,2,664.71,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2128,NULL,680,40745,42010,2,13,1,3830.00,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2129,NULL,681,40745,42010,2,96,2,1351.24,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2130,NULL,681,40745,42010,2,67,2,283.76,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2131,NULL,681,40745,42010,2,13,1,1635.00,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2132,NULL,682,40745,42010,2,96,2,760.33,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2133,NULL,682,40745,42010,2,67,2,159.67,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2134,NULL,682,40745,42010,2,13,1,920.00,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2135,NULL,683,40745,42010,2,96,2,1264.46,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2136,NULL,683,40745,42010,2,67,2,265.54,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2137,NULL,683,40745,42010,2,13,1,1530.00,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2138,NULL,684,40745,42010,2,96,2,1516.53,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2139,NULL,684,40745,42010,2,67,2,318.47,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2140,NULL,684,40745,42010,2,13,1,1835.00,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2141,NULL,685,40745,42010,2,96,2,314.05,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2142,NULL,685,40745,42010,2,67,2,65.95,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2143,NULL,685,40745,42010,2,13,1,380.00,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL);
INSERT INTO `balance_libro_details` VALUES (2144,NULL,686,40745,42010,2,96,2,785.12,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2145,NULL,686,40745,42010,2,67,2,164.88,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2146,NULL,686,40745,42010,2,13,1,950.00,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2147,NULL,687,40745,42010,2,96,2,123.97,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2148,NULL,687,40745,42010,2,67,2,26.03,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2149,NULL,687,40745,42010,2,13,1,150.00,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2150,NULL,688,40745,42010,2,96,2,694.21,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2151,NULL,688,40745,42010,2,67,2,145.79,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2152,NULL,688,40745,42010,2,13,1,840.00,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2153,NULL,689,40745,42010,2,96,2,1351.24,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2154,NULL,689,40745,42010,2,67,2,283.76,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2155,NULL,689,40745,42010,2,13,1,1635.00,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2156,NULL,690,40745,42010,2,96,2,1446.28,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2157,NULL,690,40745,42010,2,67,2,303.72,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2158,NULL,690,40745,42010,2,13,1,1750.00,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2159,NULL,691,40745,42010,2,96,2,884.30,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2160,NULL,691,40745,42010,2,67,2,185.70,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2161,NULL,691,40745,42010,2,13,1,1070.00,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2162,NULL,692,40745,42010,2,96,2,247.93,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2163,NULL,692,40745,42010,2,67,2,52.07,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2164,NULL,692,40745,42010,2,13,1,300.00,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2165,NULL,693,40745,42010,2,96,2,760.33,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2166,NULL,693,40745,42010,2,67,2,159.67,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2167,NULL,693,40745,42010,2,13,1,920.00,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2168,NULL,694,40745,42010,2,96,2,99.17,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2169,NULL,694,40745,42010,2,67,2,20.83,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2170,NULL,694,40745,42010,2,13,1,120.00,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2171,NULL,695,40745,42010,2,96,2,347.11,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2172,NULL,695,40745,42010,2,67,2,72.89,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2173,NULL,695,40745,42010,2,13,1,420.00,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2174,NULL,696,40745,42010,2,96,2,322.31,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2175,NULL,696,40745,42010,2,67,2,67.69,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2176,NULL,696,40745,42010,2,13,1,390.00,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2177,NULL,697,40745,42010,2,96,2,1028.93,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2178,NULL,697,40745,42010,2,67,2,216.07,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2179,NULL,697,40745,42010,2,13,1,1245.00,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2180,NULL,698,40745,42010,2,96,2,355.37,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2181,NULL,698,40745,42010,2,67,2,74.63,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2182,NULL,698,40745,42010,2,13,1,430.00,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2183,NULL,699,40745,42010,2,96,2,471.07,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2184,NULL,699,40745,42010,2,67,2,98.93,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL);
INSERT INTO `balance_libro_details` VALUES (2185,NULL,699,40745,42010,2,13,1,570.00,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2186,NULL,700,40745,42010,2,96,2,1136.36,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2187,NULL,700,40745,42010,2,67,2,238.64,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2188,NULL,700,40745,42010,2,13,1,1375.00,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2189,NULL,701,40745,42010,2,96,2,2123.97,NULL,'2022-11-24 14:20:33','2022-11-24 14:20:33',NULL),(2190,NULL,701,40745,42010,2,67,2,446.03,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2191,NULL,701,40745,42010,2,13,1,2570.00,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2192,NULL,702,40745,42010,2,96,2,181.82,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2193,NULL,702,40745,42010,2,67,2,38.18,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2194,NULL,702,40745,42010,2,13,1,220.00,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2195,NULL,703,40745,42010,2,96,2,735.54,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2196,NULL,703,40745,42010,2,67,2,154.46,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2197,NULL,703,40745,42010,2,13,1,890.00,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2198,NULL,704,40745,42010,2,96,2,950.41,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2199,NULL,704,40745,42010,2,67,2,199.59,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2200,NULL,704,40745,42010,2,13,1,1150.00,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2201,NULL,705,40745,42010,2,96,2,541.32,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2202,NULL,705,40745,42010,2,67,2,113.68,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2203,NULL,705,40745,42010,2,13,1,655.00,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2204,NULL,706,40745,42010,2,96,2,264.46,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2205,NULL,706,40745,42010,2,67,2,55.54,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2206,NULL,706,40745,42010,2,13,1,320.00,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2207,NULL,707,40745,42010,2,96,2,1756.20,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2208,NULL,707,40745,42010,2,67,2,368.80,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2209,NULL,707,40745,42010,2,13,1,2125.00,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2210,NULL,708,40745,42010,2,96,2,975.21,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2211,NULL,708,40745,42010,2,67,2,204.79,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2212,NULL,708,40745,42010,2,13,1,1180.00,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2213,NULL,709,40745,42010,2,96,2,5049.59,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2214,NULL,709,40745,42010,2,67,2,1060.41,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2215,NULL,709,40745,42010,2,13,1,6110.00,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2216,NULL,710,40745,42010,2,96,2,438.02,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2217,NULL,710,40745,42010,2,67,2,91.98,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2218,NULL,710,40745,42010,2,13,1,530.00,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2219,NULL,711,40745,42010,2,96,2,264.46,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2220,NULL,711,40745,42010,2,67,2,55.54,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2221,NULL,711,40745,42010,2,13,1,320.00,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2222,NULL,712,40745,42010,2,96,2,247.93,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2223,NULL,712,40745,42010,2,67,2,52.07,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2224,NULL,712,40745,42010,2,13,1,300.00,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2225,NULL,713,40745,42010,2,96,2,661.16,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL);
INSERT INTO `balance_libro_details` VALUES (2226,NULL,713,40745,42010,2,67,2,138.84,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2227,NULL,713,40745,42010,2,13,1,800.00,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2228,NULL,714,40745,42010,2,96,2,409.09,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2229,NULL,714,40745,42010,2,67,2,85.91,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2230,NULL,714,40745,42010,2,13,1,495.00,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2231,NULL,715,40745,42010,2,96,2,1269.42,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2232,NULL,715,40745,42010,2,67,2,266.58,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2233,NULL,715,40745,42010,2,13,1,1536.00,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2234,NULL,716,40745,42010,2,96,2,640.50,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2235,NULL,716,40745,42010,2,67,2,134.50,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2236,NULL,716,40745,42010,2,13,1,775.00,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2237,NULL,717,40745,42010,2,96,2,99.17,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2238,NULL,717,40745,42010,2,67,2,20.83,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2239,NULL,717,40745,42010,2,13,1,120.00,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2240,NULL,718,40745,42010,2,96,2,756.20,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2241,NULL,718,40745,42010,2,67,2,158.80,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2242,NULL,718,40745,42010,2,13,1,915.00,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2243,NULL,719,40745,42010,2,96,2,190.08,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2244,NULL,719,40745,42010,2,67,2,39.92,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2245,NULL,719,40745,42010,2,13,1,230.00,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2246,NULL,720,40745,42010,2,96,2,958.68,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2247,NULL,720,40745,42010,2,67,2,201.32,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2248,NULL,720,40745,42010,2,13,1,1160.00,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2249,NULL,721,40745,42010,2,96,2,247.93,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2250,NULL,721,40745,42010,2,67,2,52.07,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2251,NULL,721,40745,42010,2,13,1,300.00,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2252,NULL,722,40745,42010,2,96,2,1301.65,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2253,NULL,722,40745,42010,2,67,2,273.35,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2254,NULL,722,40745,42010,2,13,1,1575.00,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2255,NULL,723,40745,42010,2,96,2,979.34,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2256,NULL,723,40745,42010,2,67,2,205.66,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2257,NULL,723,40745,42010,2,13,1,1185.00,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2258,NULL,724,40745,42010,2,96,2,512.40,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2259,NULL,724,40745,42010,2,67,2,107.60,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2260,NULL,724,40745,42010,2,13,1,620.00,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2261,NULL,725,40745,42010,2,96,2,851.24,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2262,NULL,725,40745,42010,2,67,2,178.76,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2263,NULL,725,40745,42010,2,13,1,1030.00,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2264,NULL,726,40745,42010,2,96,2,1078.51,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2265,NULL,726,40745,42010,2,67,2,226.49,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2266,NULL,726,40745,42010,2,13,1,1305.00,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL);
INSERT INTO `balance_libro_details` VALUES (2267,NULL,727,40745,42010,2,96,2,264.46,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2268,NULL,727,40745,42010,2,67,2,55.54,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2269,NULL,727,40745,42010,2,13,1,320.00,NULL,'2022-11-24 14:20:34','2022-11-24 14:20:34',NULL),(2270,NULL,728,40745,42010,2,96,2,2115.70,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2271,NULL,728,40745,42010,2,67,2,444.30,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2272,NULL,728,40745,42010,2,13,1,2560.00,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2273,NULL,729,40745,42010,2,96,2,2144.63,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2274,NULL,729,40745,42010,2,67,2,450.37,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2275,NULL,729,40745,42010,2,13,1,2595.00,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2276,NULL,730,40745,42010,2,96,2,512.40,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2277,NULL,730,40745,42010,2,67,2,107.60,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2278,NULL,730,40745,42010,2,13,1,620.00,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2279,NULL,731,40745,42010,2,96,2,826.45,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2280,NULL,731,40745,42010,2,67,2,173.55,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2281,NULL,731,40745,42010,2,13,1,1000.00,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2282,NULL,732,40745,42010,2,96,2,413.22,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2283,NULL,732,40745,42010,2,67,2,86.78,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2284,NULL,732,40745,42010,2,13,1,500.00,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2285,NULL,733,40745,42010,2,96,2,743.80,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2286,NULL,733,40745,42010,2,67,2,156.20,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2287,NULL,733,40745,42010,2,13,1,900.00,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2288,NULL,734,40745,42010,2,96,2,1685.95,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2289,NULL,734,40745,42010,2,67,2,354.05,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2290,NULL,734,40745,42010,2,13,1,2040.00,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2291,NULL,735,40745,42010,2,96,2,793.39,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2292,NULL,735,40745,42010,2,67,2,166.61,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2293,NULL,735,40745,42010,2,13,1,960.00,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2294,NULL,736,40745,42010,2,96,2,314.05,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2295,NULL,736,40745,42010,2,67,2,65.95,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2296,NULL,736,40745,42010,2,13,1,380.00,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2297,NULL,737,40745,42010,2,96,2,1983.47,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2298,NULL,737,40745,42010,2,67,2,416.53,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2299,NULL,737,40745,42010,2,13,1,2400.00,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2300,NULL,738,40745,42010,2,96,2,1330.58,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2301,NULL,738,40745,42010,2,67,2,279.42,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2302,NULL,738,40745,42010,2,13,1,1610.00,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2303,NULL,739,40745,42010,2,96,2,297.52,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2304,NULL,739,40745,42010,2,67,2,62.48,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2305,NULL,739,40745,42010,2,13,1,360.00,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2306,NULL,740,40745,42010,2,96,2,371.90,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2307,NULL,740,40745,42010,2,67,2,78.10,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL);
INSERT INTO `balance_libro_details` VALUES (2308,NULL,740,40745,42010,2,13,1,450.00,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2309,NULL,741,40745,42010,2,96,2,151.24,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2310,NULL,741,40745,42010,2,67,2,31.76,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2311,NULL,741,40745,42010,2,13,1,183.00,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2312,NULL,742,40745,42010,2,96,2,165.29,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2313,NULL,742,40745,42010,2,67,2,34.71,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2314,NULL,742,40745,42010,2,13,1,200.00,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2315,NULL,743,40745,42010,2,96,2,239.67,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2316,NULL,743,40745,42010,2,67,2,50.33,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2317,NULL,743,40745,42010,2,13,1,290.00,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2318,NULL,744,40745,42010,2,96,2,173.55,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2319,NULL,744,40745,42010,2,67,2,36.45,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2320,NULL,744,40745,42010,2,13,1,210.00,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2321,NULL,745,40745,42010,2,96,2,1206.61,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2322,NULL,745,40745,42010,2,67,2,253.39,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2323,NULL,745,40745,42010,2,13,1,1460.00,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2324,NULL,746,40745,42010,2,96,2,107.44,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2325,NULL,746,40745,42010,2,67,2,22.56,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2326,NULL,746,40745,42010,2,13,1,130.00,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2327,NULL,747,40745,42010,2,96,2,760.33,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2328,NULL,747,40745,42010,2,67,2,159.67,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2329,NULL,747,40745,42010,2,13,1,920.00,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2330,NULL,748,40745,42010,2,96,2,247.93,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2331,NULL,748,40745,42010,2,67,2,52.07,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2332,NULL,748,40745,42010,2,13,1,300.00,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2333,NULL,749,40745,42010,2,96,2,99.17,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2334,NULL,749,40745,42010,2,67,2,20.83,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2335,NULL,749,40745,42010,2,13,1,120.00,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2336,NULL,750,40745,42010,2,96,2,603.31,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2337,NULL,750,40745,42010,2,67,2,126.69,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2338,NULL,750,40745,42010,2,13,1,730.00,NULL,'2022-11-24 14:20:35','2022-11-24 14:20:35',NULL),(2339,NULL,751,40745,42010,2,96,2,2363.64,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2340,NULL,751,40745,42010,2,67,2,496.36,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2341,NULL,751,40745,42010,2,13,1,2860.00,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2342,NULL,752,40745,42010,2,96,2,380.17,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2343,NULL,752,40745,42010,2,67,2,79.83,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2344,NULL,752,40745,42010,2,13,1,460.00,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2345,NULL,753,40745,42010,2,96,2,809.92,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2346,NULL,753,40745,42010,2,67,2,170.08,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2347,NULL,753,40745,42010,2,13,1,980.00,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2348,NULL,754,40745,42010,2,96,2,1495.87,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL);
INSERT INTO `balance_libro_details` VALUES (2349,NULL,754,40745,42010,2,67,2,314.13,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2350,NULL,754,40745,42010,2,13,1,1810.00,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2351,NULL,755,40745,42010,2,96,2,82.64,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2352,NULL,755,40745,42010,2,67,2,17.36,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2353,NULL,755,40745,42010,2,13,1,100.00,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2354,NULL,756,40745,42010,2,96,2,1661.16,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2355,NULL,756,40745,42010,2,67,2,348.84,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2356,NULL,756,40745,42010,2,13,1,2010.00,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2357,NULL,757,40745,42010,2,96,2,413.22,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2358,NULL,757,40745,42010,2,67,2,86.78,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2359,NULL,757,40745,42010,2,13,1,500.00,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2360,NULL,758,40745,42010,2,96,2,528.93,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2361,NULL,758,40745,42010,2,67,2,111.07,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2362,NULL,758,40745,42010,2,13,1,640.00,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2363,NULL,759,40745,42010,2,96,2,239.67,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2364,NULL,759,40745,42010,2,67,2,50.33,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2365,NULL,759,40745,42010,2,13,1,290.00,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2366,NULL,760,40745,42010,2,96,2,479.34,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2367,NULL,760,40745,42010,2,67,2,100.66,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2368,NULL,760,40745,42010,2,13,1,580.00,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2369,NULL,761,40745,42010,2,96,2,165.29,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2370,NULL,761,40745,42010,2,67,2,34.71,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2371,NULL,761,40745,42010,2,13,1,200.00,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2372,NULL,762,40745,42010,2,96,2,446.28,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2373,NULL,762,40745,42010,2,67,2,93.72,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2374,NULL,762,40745,42010,2,13,1,540.00,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2375,NULL,763,40745,42010,2,96,2,351.24,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2376,NULL,763,40745,42010,2,67,2,73.76,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2377,NULL,763,40745,42010,2,13,1,425.00,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2378,NULL,764,40745,42010,2,96,2,247.93,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2379,NULL,764,40745,42010,2,67,2,52.07,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2380,NULL,764,40745,42010,2,13,1,300.00,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2381,NULL,765,40745,42010,2,96,2,504.13,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2382,NULL,765,40745,42010,2,67,2,105.87,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2383,NULL,765,40745,42010,2,13,1,610.00,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2384,NULL,766,40745,42010,2,96,2,834.71,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2385,NULL,766,40745,42010,2,67,2,175.29,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2386,NULL,766,40745,42010,2,13,1,1010.00,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2387,NULL,767,40745,42010,2,96,2,264.46,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2388,NULL,767,40745,42010,2,67,2,55.54,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2389,NULL,767,40745,42010,2,13,1,320.00,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL);
INSERT INTO `balance_libro_details` VALUES (2390,NULL,768,40745,42010,2,96,2,958.68,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2391,NULL,768,40745,42010,2,67,2,201.32,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2392,NULL,768,40745,42010,2,13,1,1160.00,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2393,NULL,769,40745,42010,2,96,2,413.22,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2394,NULL,769,40745,42010,2,67,2,86.78,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2395,NULL,769,40745,42010,2,13,1,500.00,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2396,NULL,770,40745,42010,2,96,2,99.17,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2397,NULL,770,40745,42010,2,67,2,20.83,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2398,NULL,770,40745,42010,2,13,1,120.00,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2399,NULL,771,40745,42010,2,96,2,214.88,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2400,NULL,771,40745,42010,2,67,2,45.12,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2401,NULL,771,40745,42010,2,13,1,260.00,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2402,NULL,772,40745,42010,2,96,2,272.73,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2403,NULL,772,40745,42010,2,67,2,57.27,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2404,NULL,772,40745,42010,2,13,1,330.00,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2405,NULL,773,40745,42010,2,96,2,322.31,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2406,NULL,773,40745,42010,2,67,2,67.69,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2407,NULL,773,40745,42010,2,13,1,390.00,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2408,NULL,774,40745,42010,2,96,2,330.58,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2409,NULL,774,40745,42010,2,67,2,69.42,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2410,NULL,774,40745,42010,2,13,1,400.00,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2411,NULL,775,40745,42010,2,96,2,545.45,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2412,NULL,775,40745,42010,2,67,2,114.55,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2413,NULL,775,40745,42010,2,13,1,660.00,NULL,'2022-11-24 14:20:36','2022-11-24 14:20:36',NULL),(2414,NULL,776,40745,42010,2,96,2,702.48,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2415,NULL,776,40745,42010,2,67,2,147.52,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2416,NULL,776,40745,42010,2,13,1,850.00,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2417,NULL,777,40745,42010,2,96,2,871.90,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2418,NULL,777,40745,42010,2,67,2,183.10,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2419,NULL,777,40745,42010,2,13,1,1055.00,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2420,NULL,778,40745,42010,2,96,2,223.14,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2421,NULL,778,40745,42010,2,67,2,46.86,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2422,NULL,778,40745,42010,2,13,1,270.00,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2423,NULL,779,40745,42010,2,96,2,3305.79,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2424,NULL,779,40745,42010,2,67,2,694.21,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2425,NULL,779,40745,42010,2,13,1,4000.00,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2426,NULL,780,40745,42010,2,96,2,603.31,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2427,NULL,780,40745,42010,2,67,2,126.69,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2428,NULL,780,40745,42010,2,13,1,730.00,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2429,NULL,781,40745,42010,2,96,2,421.49,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2430,NULL,781,40745,42010,2,67,2,88.51,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL);
INSERT INTO `balance_libro_details` VALUES (2431,NULL,781,40745,42010,2,13,1,510.00,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2432,NULL,782,40745,42010,2,96,2,1322.31,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2433,NULL,782,40745,42010,2,67,2,277.69,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2434,NULL,782,40745,42010,2,13,1,1600.00,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2435,NULL,783,40745,42010,2,96,2,1987.60,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2436,NULL,783,40745,42010,2,67,2,417.40,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2437,NULL,783,40745,42010,2,13,1,2405.00,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2438,NULL,784,40745,42010,2,96,2,1239.67,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2439,NULL,784,40745,42010,2,67,2,260.33,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2440,NULL,784,40745,42010,2,13,1,1500.00,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2441,NULL,785,40745,42010,2,96,2,619.83,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2442,NULL,785,40745,42010,2,67,2,130.17,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2443,NULL,785,40745,42010,2,13,1,750.00,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2444,NULL,786,40745,42010,2,96,2,661.16,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2445,NULL,786,40745,42010,2,67,2,138.84,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2446,NULL,786,40745,42010,2,13,1,800.00,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2447,NULL,787,40745,42010,2,96,2,2132.23,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2448,NULL,787,40745,42010,2,67,2,447.77,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2449,NULL,787,40745,42010,2,13,1,2580.00,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2450,NULL,788,40745,42010,2,96,2,611.57,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2451,NULL,788,40745,42010,2,67,2,128.43,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2452,NULL,788,40745,42010,2,13,1,740.00,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2453,NULL,789,40745,42010,2,96,2,1206.61,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2454,NULL,789,40745,42010,2,67,2,253.39,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2455,NULL,789,40745,42010,2,13,1,1460.00,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2456,NULL,790,40745,42010,2,96,2,413.22,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2457,NULL,790,40745,42010,2,67,2,86.78,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2458,NULL,790,40745,42010,2,13,1,500.00,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2459,NULL,791,40745,42010,2,96,2,2537.19,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2460,NULL,791,40745,42010,2,67,2,532.81,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2461,NULL,791,40745,42010,2,13,1,3070.00,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2462,NULL,792,40745,42010,2,96,2,586.78,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2463,NULL,792,40745,42010,2,67,2,123.22,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2464,NULL,792,40745,42010,2,13,1,710.00,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2465,NULL,793,40745,42010,2,96,2,714.88,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2466,NULL,793,40745,42010,2,67,2,150.12,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2467,NULL,793,40745,42010,2,13,1,865.00,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2468,NULL,794,40745,42010,2,96,2,1347.11,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2469,NULL,794,40745,42010,2,67,2,282.89,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2470,NULL,794,40745,42010,2,13,1,1630.00,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2471,NULL,795,40745,42010,2,96,2,578.51,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL);
INSERT INTO `balance_libro_details` VALUES (2472,NULL,795,40745,42010,2,67,2,121.49,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2473,NULL,795,40745,42010,2,13,1,700.00,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2474,NULL,796,40745,42010,2,96,2,1652.89,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2475,NULL,796,40745,42010,2,67,2,347.11,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2476,NULL,796,40745,42010,2,13,1,2000.00,NULL,'2022-11-24 14:20:37','2022-11-24 14:20:37',NULL),(2477,NULL,797,40745,42010,2,96,2,1925.62,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2478,NULL,797,40745,42010,2,67,2,404.38,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2479,NULL,797,40745,42010,2,13,1,2330.00,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2480,NULL,798,40745,42010,2,96,2,1574.38,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2481,NULL,798,40745,42010,2,67,2,330.62,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2482,NULL,798,40745,42010,2,13,1,1905.00,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2483,NULL,799,40745,42010,2,96,2,413.22,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2484,NULL,799,40745,42010,2,67,2,86.78,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2485,NULL,799,40745,42010,2,13,1,500.00,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2486,NULL,800,40745,42010,2,96,2,396.69,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2487,NULL,800,40745,42010,2,67,2,83.31,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2488,NULL,800,40745,42010,2,13,1,480.00,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2489,NULL,801,40745,42010,2,96,2,305.79,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2490,NULL,801,40745,42010,2,67,2,64.21,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2491,NULL,801,40745,42010,2,13,1,370.00,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2492,NULL,802,40745,42010,2,96,2,1033.06,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2493,NULL,802,40745,42010,2,67,2,216.94,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2494,NULL,802,40745,42010,2,13,1,1250.00,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2495,NULL,803,40745,42010,2,96,2,685.95,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2496,NULL,803,40745,42010,2,67,2,144.05,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2497,NULL,803,40745,42010,2,13,1,830.00,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2498,NULL,804,40745,42010,2,96,2,123.97,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2499,NULL,804,40745,42010,2,67,2,26.03,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2500,NULL,804,40745,42010,2,13,1,150.00,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2501,NULL,805,40745,42010,2,96,2,1136.36,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2502,NULL,805,40745,42010,2,67,2,238.64,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2503,NULL,805,40745,42010,2,13,1,1375.00,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2504,NULL,806,40745,42010,2,96,2,272.73,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2505,NULL,806,40745,42010,2,67,2,57.27,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2506,NULL,806,40745,42010,2,13,1,330.00,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2507,NULL,807,40745,42010,2,96,2,140.50,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2508,NULL,807,40745,42010,2,67,2,29.50,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2509,NULL,807,40745,42010,2,13,1,170.00,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2510,NULL,808,40745,42010,2,96,2,685.95,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2511,NULL,808,40745,42010,2,67,2,144.05,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2512,NULL,808,40745,42010,2,13,1,830.00,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL);
INSERT INTO `balance_libro_details` VALUES (2513,NULL,809,40745,42010,2,96,2,392.56,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2514,NULL,809,40745,42010,2,67,2,82.44,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2515,NULL,809,40745,42010,2,13,1,475.00,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2516,NULL,810,40745,42010,2,96,2,264.46,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2517,NULL,810,40745,42010,2,67,2,55.54,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2518,NULL,810,40745,42010,2,13,1,320.00,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2519,NULL,811,40745,42010,2,96,2,413.22,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2520,NULL,811,40745,42010,2,67,2,86.78,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2521,NULL,811,40745,42010,2,13,1,500.00,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2522,NULL,812,40745,42010,2,96,2,1243.80,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2523,NULL,812,40745,42010,2,67,2,261.20,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2524,NULL,812,40745,42010,2,13,1,1505.00,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2525,NULL,813,40745,42010,2,96,2,487.60,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2526,NULL,813,40745,42010,2,67,2,102.40,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2527,NULL,813,40745,42010,2,13,1,590.00,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2528,NULL,814,40745,42010,2,96,2,314.05,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2529,NULL,814,40745,42010,2,67,2,65.95,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2530,NULL,814,40745,42010,2,13,1,380.00,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2531,NULL,815,40745,42010,2,96,2,797.52,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2532,NULL,815,40745,42010,2,67,2,167.48,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2533,NULL,815,40745,42010,2,13,1,965.00,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2534,NULL,816,40745,42010,2,96,2,1381.82,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2535,NULL,816,40745,42010,2,67,2,290.18,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2536,NULL,816,40745,42010,2,13,1,1672.00,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2537,NULL,817,40745,42010,2,96,2,2856.20,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2538,NULL,817,40745,42010,2,67,2,599.80,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2539,NULL,817,40745,42010,2,13,1,3456.00,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2540,NULL,818,40745,42010,2,96,2,380.17,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2541,NULL,818,40745,42010,2,67,2,79.83,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2542,NULL,818,40745,42010,2,13,1,460.00,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2543,NULL,819,40745,42010,2,96,2,454.55,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2544,NULL,819,40745,42010,2,67,2,95.45,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2545,NULL,819,40745,42010,2,13,1,550.00,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2546,NULL,820,40745,42010,2,96,2,231.40,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2547,NULL,820,40745,42010,2,67,2,48.60,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2548,NULL,820,40745,42010,2,13,1,280.00,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2549,NULL,821,40745,42010,2,96,2,247.93,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2550,NULL,821,40745,42010,2,67,2,52.07,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2551,NULL,821,40745,42010,2,13,1,300.00,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2552,NULL,822,40745,42010,2,96,2,466.94,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2553,NULL,822,40745,42010,2,67,2,98.06,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL);
INSERT INTO `balance_libro_details` VALUES (2554,NULL,822,40745,42010,2,13,1,565.00,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2555,NULL,823,40745,42010,2,96,2,561.98,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2556,NULL,823,40745,42010,2,67,2,118.02,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2557,NULL,823,40745,42010,2,13,1,680.00,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2558,NULL,824,40745,42010,2,96,2,495.87,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2559,NULL,824,40745,42010,2,67,2,104.13,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2560,NULL,824,40745,42010,2,13,1,600.00,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2561,NULL,825,40745,42010,2,96,2,2764.46,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2562,NULL,825,40745,42010,2,67,2,580.54,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2563,NULL,825,40745,42010,2,13,1,3345.00,NULL,'2022-11-24 14:20:38','2022-11-24 14:20:38',NULL),(2564,NULL,826,40745,42010,2,96,2,115.70,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2565,NULL,826,40745,42010,2,67,2,24.30,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2566,NULL,826,40745,42010,2,13,1,140.00,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2567,NULL,827,40745,42010,2,96,2,537.19,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2568,NULL,827,40745,42010,2,67,2,112.81,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2569,NULL,827,40745,42010,2,13,1,650.00,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2570,NULL,828,40745,42010,2,96,2,603.31,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2571,NULL,828,40745,42010,2,67,2,126.69,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2572,NULL,828,40745,42010,2,13,1,730.00,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2573,NULL,829,40745,42010,2,96,2,859.50,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2574,NULL,829,40745,42010,2,67,2,180.50,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2575,NULL,829,40745,42010,2,13,1,1040.00,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2576,NULL,830,40745,42010,2,96,2,371.90,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2577,NULL,830,40745,42010,2,67,2,78.10,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2578,NULL,830,40745,42010,2,13,1,450.00,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2579,NULL,831,40745,42010,2,96,2,1442.15,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2580,NULL,831,40745,42010,2,67,2,302.85,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2581,NULL,831,40745,42010,2,13,1,1745.00,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2582,NULL,832,40745,42010,2,96,2,433.88,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2583,NULL,832,40745,42010,2,67,2,91.12,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2584,NULL,832,40745,42010,2,13,1,525.00,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2585,NULL,833,40745,42010,2,96,2,371.90,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2586,NULL,833,40745,42010,2,67,2,78.10,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2587,NULL,833,40745,42010,2,13,1,450.00,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2588,NULL,834,40745,42010,2,96,2,105.79,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2589,NULL,834,40745,42010,2,67,2,22.21,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2590,NULL,834,40745,42010,2,13,1,128.00,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2591,NULL,835,40745,42010,2,96,2,2256.20,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2592,NULL,835,40745,42010,2,67,2,473.80,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2593,NULL,835,40745,42010,2,13,1,2730.00,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2594,NULL,836,40745,42010,2,96,2,557.02,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL);
INSERT INTO `balance_libro_details` VALUES (2595,NULL,836,40745,42010,2,67,2,116.98,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2596,NULL,836,40745,42010,2,13,1,674.00,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2597,NULL,837,40745,42010,2,96,2,838.84,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2598,NULL,837,40745,42010,2,67,2,176.16,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2599,NULL,837,40745,42010,2,13,1,1015.00,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2600,NULL,838,40745,42010,2,96,2,973.55,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2601,NULL,838,40745,42010,2,67,2,204.45,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2602,NULL,838,40745,42010,2,13,1,1178.00,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2603,NULL,839,40745,42010,2,96,2,280.99,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2604,NULL,839,40745,42010,2,67,2,59.01,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2605,NULL,839,40745,42010,2,13,1,340.00,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2606,NULL,840,40745,42010,2,96,2,140.50,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2607,NULL,840,40745,42010,2,67,2,29.50,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2608,NULL,840,40745,42010,2,13,1,170.00,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2609,NULL,841,40745,42010,2,96,2,933.88,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2610,NULL,841,40745,42010,2,67,2,196.12,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2611,NULL,841,40745,42010,2,13,1,1130.00,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2612,NULL,842,40745,42010,2,96,2,1404.96,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2613,NULL,842,40745,42010,2,67,2,295.04,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2614,NULL,842,40745,42010,2,13,1,1700.00,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2615,NULL,843,40745,42010,2,96,2,82.64,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2616,NULL,843,40745,42010,2,67,2,17.36,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2617,NULL,843,40745,42010,2,13,1,100.00,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2618,NULL,844,40745,42010,2,96,2,685.95,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2619,NULL,844,40745,42010,2,67,2,144.05,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2620,NULL,844,40745,42010,2,13,1,830.00,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2621,NULL,845,40745,42010,2,96,2,1016.53,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2622,NULL,845,40745,42010,2,67,2,213.47,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2623,NULL,845,40745,42010,2,13,1,1230.00,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2624,NULL,846,40745,42010,2,96,2,942.15,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2625,NULL,846,40745,42010,2,67,2,197.85,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2626,NULL,846,40745,42010,2,13,1,1140.00,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2627,NULL,847,40745,42010,2,96,2,1115.70,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2628,NULL,847,40745,42010,2,67,2,234.30,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2629,NULL,847,40745,42010,2,13,1,1350.00,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2630,NULL,848,40745,42010,2,96,2,504.13,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2631,NULL,848,40745,42010,2,67,2,105.87,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2632,NULL,848,40745,42010,2,13,1,610.00,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2633,NULL,849,40745,42010,2,96,2,128.10,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2634,NULL,849,40745,42010,2,67,2,26.90,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2635,NULL,849,40745,42010,2,13,1,155.00,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL);
INSERT INTO `balance_libro_details` VALUES (2636,NULL,850,40745,42010,2,96,2,648.76,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2637,NULL,850,40745,42010,2,67,2,136.24,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2638,NULL,850,40745,42010,2,13,1,785.00,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2639,NULL,851,40745,42010,2,96,2,1669.42,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2640,NULL,851,40745,42010,2,67,2,350.58,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2641,NULL,851,40745,42010,2,13,1,2020.00,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2642,NULL,852,40745,42010,2,96,2,1061.98,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2643,NULL,852,40745,42010,2,67,2,223.02,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2644,NULL,852,40745,42010,2,13,1,1285.00,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2645,NULL,853,40745,42010,2,96,2,619.83,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2646,NULL,853,40745,42010,2,67,2,130.17,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2647,NULL,853,40745,42010,2,13,1,750.00,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2648,NULL,854,40745,42010,2,96,2,1632.23,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2649,NULL,854,40745,42010,2,67,2,342.77,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2650,NULL,854,40745,42010,2,13,1,1975.00,NULL,'2022-11-24 14:20:39','2022-11-24 14:20:39',NULL),(2651,NULL,855,40745,42010,2,96,2,1355.37,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2652,NULL,855,40745,42010,2,67,2,284.63,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2653,NULL,855,40745,42010,2,13,1,1640.00,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2654,NULL,856,40745,42010,2,96,2,6305.79,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2655,NULL,856,40745,42010,2,67,2,1324.21,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2656,NULL,856,40745,42010,2,13,1,7630.00,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2657,NULL,857,40745,42010,2,96,2,4743.80,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2658,NULL,857,40745,42010,2,67,2,996.20,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2659,NULL,857,40745,42010,2,13,1,5740.00,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2660,NULL,858,40745,42010,2,96,2,1553.72,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2661,NULL,858,40745,42010,2,67,2,326.28,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2662,NULL,858,40745,42010,2,13,1,1880.00,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2663,NULL,859,40745,42010,2,96,2,2177.69,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2664,NULL,859,40745,42010,2,67,2,457.31,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2665,NULL,859,40745,42010,2,13,1,2635.00,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2666,NULL,860,40745,42010,2,96,2,1545.45,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2667,NULL,860,40745,42010,2,67,2,324.55,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2668,NULL,860,40745,42010,2,13,1,1870.00,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2669,NULL,861,40745,42010,2,96,2,1070.25,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2670,NULL,861,40745,42010,2,67,2,224.75,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2671,NULL,861,40745,42010,2,13,1,1295.00,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2672,NULL,862,40745,42010,2,96,2,1491.74,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2673,NULL,862,40745,42010,2,67,2,313.26,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2674,NULL,862,40745,42010,2,13,1,1805.00,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2675,NULL,863,40745,42010,2,96,2,851.24,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2676,NULL,863,40745,42010,2,67,2,178.76,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL);
INSERT INTO `balance_libro_details` VALUES (2677,NULL,863,40745,42010,2,13,1,1030.00,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2678,NULL,864,40745,42010,2,96,2,1297.52,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2679,NULL,864,40745,42010,2,67,2,272.48,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2680,NULL,864,40745,42010,2,13,1,1570.00,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2681,NULL,865,40745,42010,2,96,2,1066.12,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2682,NULL,865,40745,42010,2,67,2,223.88,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2683,NULL,865,40745,42010,2,13,1,1290.00,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2684,NULL,866,40745,42010,2,96,2,1789.26,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2685,NULL,866,40745,42010,2,67,2,375.74,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2686,NULL,866,40745,42010,2,13,1,2165.00,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2687,NULL,867,40745,42010,2,96,2,132.23,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2688,NULL,867,40745,42010,2,67,2,27.77,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2689,NULL,867,40745,42010,2,13,1,160.00,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2690,NULL,868,40745,42010,2,96,2,1305.79,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2691,NULL,868,40745,42010,2,67,2,274.21,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2692,NULL,868,40745,42010,2,13,1,1580.00,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2693,NULL,869,40745,42010,2,96,2,1066.12,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2694,NULL,869,40745,42010,2,67,2,223.88,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2695,NULL,869,40745,42010,2,13,1,1290.00,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2696,NULL,870,40745,42010,2,96,2,991.74,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2697,NULL,870,40745,42010,2,67,2,208.26,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2698,NULL,870,40745,42010,2,13,1,1200.00,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2699,NULL,871,40745,42010,2,96,2,520.66,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2700,NULL,871,40745,42010,2,67,2,109.34,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2701,NULL,871,40745,42010,2,13,1,630.00,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2702,NULL,872,40745,42010,2,96,2,851.24,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2703,NULL,872,40745,42010,2,67,2,178.76,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2704,NULL,872,40745,42010,2,13,1,1030.00,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2705,NULL,873,40745,42010,2,96,2,214.88,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2706,NULL,873,40745,42010,2,67,2,45.12,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2707,NULL,873,40745,42010,2,13,1,260.00,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2708,NULL,874,40745,42010,2,96,2,710.74,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2709,NULL,874,40745,42010,2,67,2,149.26,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2710,NULL,874,40745,42010,2,13,1,860.00,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2711,NULL,875,40745,42010,2,96,2,595.04,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2712,NULL,875,40745,42010,2,67,2,124.96,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2713,NULL,875,40745,42010,2,13,1,720.00,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2714,NULL,876,40745,42010,2,96,2,1123.97,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2715,NULL,876,40745,42010,2,67,2,236.03,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2716,NULL,876,40745,42010,2,13,1,1360.00,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2717,NULL,877,40745,42010,2,96,2,1123.97,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL);
INSERT INTO `balance_libro_details` VALUES (2718,NULL,877,40745,42010,2,67,2,236.03,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2719,NULL,877,40745,42010,2,13,1,1360.00,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2720,NULL,878,40745,42010,2,96,2,789.71,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2721,NULL,878,40745,42010,2,67,2,165.84,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2722,NULL,878,40745,42010,2,13,1,955.55,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2723,NULL,879,40745,42010,2,96,2,123.97,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2724,NULL,879,40745,42010,2,67,2,26.03,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2725,NULL,879,40745,42010,2,13,1,150.00,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2726,NULL,880,40745,42010,2,96,2,520.66,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2727,NULL,880,40745,42010,2,67,2,109.34,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2728,NULL,880,40745,42010,2,13,1,630.00,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2729,NULL,881,40745,42010,2,96,2,694.21,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2730,NULL,881,40745,42010,2,67,2,145.79,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2731,NULL,881,40745,42010,2,13,1,840.00,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2732,NULL,882,40745,42010,2,96,2,1099.17,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2733,NULL,882,40745,42010,2,67,2,230.83,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2734,NULL,882,40745,42010,2,13,1,1330.00,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2735,NULL,883,40745,42010,2,96,2,442.15,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2736,NULL,883,40745,42010,2,67,2,92.85,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2737,NULL,883,40745,42010,2,13,1,535.00,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2738,NULL,884,40745,42010,2,96,2,735.54,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2739,NULL,884,40745,42010,2,67,2,154.46,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2740,NULL,884,40745,42010,2,13,1,890.00,NULL,'2022-11-24 14:20:40','2022-11-24 14:20:40',NULL),(2741,NULL,885,40745,42010,2,96,2,359.50,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2742,NULL,885,40745,42010,2,67,2,75.50,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2743,NULL,885,40745,42010,2,13,1,435.00,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2744,NULL,886,40745,42010,2,96,2,223.14,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2745,NULL,886,40745,42010,2,67,2,46.86,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2746,NULL,886,40745,42010,2,13,1,270.00,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2747,NULL,887,40745,42010,2,96,2,743.80,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2748,NULL,887,40745,42010,2,67,2,156.20,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2749,NULL,887,40745,42010,2,13,1,900.00,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2750,NULL,888,40745,42010,2,96,2,326.45,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2751,NULL,888,40745,42010,2,67,2,68.55,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2752,NULL,888,40745,42010,2,13,1,395.00,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2753,NULL,889,40745,42010,2,96,2,611.57,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2754,NULL,889,40745,42010,2,67,2,128.43,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2755,NULL,889,40745,42010,2,13,1,740.00,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2756,NULL,890,40745,42010,2,96,2,932.23,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2757,NULL,890,40745,42010,2,67,2,195.77,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2758,NULL,890,40745,42010,2,13,1,1128.00,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL);
INSERT INTO `balance_libro_details` VALUES (2759,NULL,891,40745,42010,2,96,2,1082.64,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2760,NULL,891,40745,42010,2,67,2,227.36,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2761,NULL,891,40745,42010,2,13,1,1310.00,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2762,NULL,892,40745,42010,2,96,2,2253.72,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2763,NULL,892,40745,42010,2,67,2,473.28,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2764,NULL,892,40745,42010,2,13,1,2727.00,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2765,NULL,893,40745,42010,2,96,2,1231.40,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2766,NULL,893,40745,42010,2,67,2,258.60,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2767,NULL,893,40745,42010,2,13,1,1490.00,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2768,NULL,894,40745,42010,2,96,2,330.58,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2769,NULL,894,40745,42010,2,67,2,69.42,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2770,NULL,894,40745,42010,2,13,1,400.00,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2771,NULL,895,40745,42010,2,96,2,545.45,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2772,NULL,895,40745,42010,2,67,2,114.55,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2773,NULL,895,40745,42010,2,13,1,660.00,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2774,NULL,896,40745,42010,2,96,2,264.46,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2775,NULL,896,40745,42010,2,67,2,55.54,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2776,NULL,896,40745,42010,2,13,1,320.00,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2777,NULL,897,40745,42010,2,96,2,264.46,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2778,NULL,897,40745,42010,2,67,2,55.54,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2779,NULL,897,40745,42010,2,13,1,320.00,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2780,NULL,898,40745,42010,2,96,2,851.24,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2781,NULL,898,40745,42010,2,67,2,178.76,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2782,NULL,898,40745,42010,2,13,1,1030.00,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2783,NULL,899,40745,42010,2,96,2,881.82,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2784,NULL,899,40745,42010,2,67,2,185.18,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2785,NULL,899,40745,42010,2,13,1,1067.00,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2786,NULL,900,40745,42010,2,96,2,330.58,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2787,NULL,900,40745,42010,2,67,2,69.42,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2788,NULL,900,40745,42010,2,13,1,400.00,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2789,NULL,901,40745,42010,2,96,2,371.90,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2790,NULL,901,40745,42010,2,67,2,78.10,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2791,NULL,901,40745,42010,2,13,1,450.00,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2792,NULL,902,40745,42010,2,96,2,3429.75,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2793,NULL,902,40745,42010,2,67,2,720.25,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2794,NULL,902,40745,42010,2,13,1,4150.00,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2795,NULL,903,40745,42010,2,96,2,137.19,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2796,NULL,903,40745,42010,2,67,2,28.81,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2797,NULL,903,40745,42010,2,13,1,166.00,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2798,NULL,904,40745,42010,2,96,2,1206.61,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2799,NULL,904,40745,42010,2,67,2,253.39,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL);
INSERT INTO `balance_libro_details` VALUES (2800,NULL,904,40745,42010,2,13,1,1460.00,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2801,NULL,905,40745,42010,2,96,2,247.93,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2802,NULL,905,40745,42010,2,67,2,52.07,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2803,NULL,905,40745,42010,2,13,1,300.00,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2804,NULL,906,40745,42010,2,96,2,727.27,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2805,NULL,906,40745,42010,2,67,2,152.73,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2806,NULL,906,40745,42010,2,13,1,880.00,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2807,NULL,907,40745,42010,2,96,2,1322.31,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2808,NULL,907,40745,42010,2,67,2,277.69,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2809,NULL,907,40745,42010,2,13,1,1600.00,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2810,NULL,908,40745,42010,2,96,2,388.43,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2811,NULL,908,40745,42010,2,67,2,81.57,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2812,NULL,908,40745,42010,2,13,1,470.00,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2813,NULL,909,40745,42010,2,96,2,1066.12,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2814,NULL,909,40745,42010,2,67,2,223.88,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2815,NULL,909,40745,42010,2,13,1,1290.00,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2816,NULL,910,40745,42010,2,96,2,826.45,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2817,NULL,910,40745,42010,2,67,2,173.55,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2818,NULL,910,40745,42010,2,13,1,1000.00,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2819,NULL,911,40745,42010,2,96,2,648.76,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2820,NULL,911,40745,42010,2,67,2,136.24,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2821,NULL,911,40745,42010,2,13,1,785.00,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2822,NULL,912,40745,42010,2,96,2,871.90,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2823,NULL,912,40745,42010,2,67,2,183.10,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2824,NULL,912,40745,42010,2,13,1,1055.00,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2825,NULL,913,40745,42010,2,96,2,115.70,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2826,NULL,913,40745,42010,2,67,2,24.30,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2827,NULL,913,40745,42010,2,13,1,140.00,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2828,NULL,914,40745,42010,2,96,2,297.52,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2829,NULL,914,40745,42010,2,67,2,62.48,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2830,NULL,914,40745,42010,2,13,1,360.00,NULL,'2022-11-24 14:20:41','2022-11-24 14:20:41',NULL),(2831,NULL,915,40745,42010,2,96,2,1727.27,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2832,NULL,915,40745,42010,2,67,2,362.73,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2833,NULL,915,40745,42010,2,13,1,2090.00,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2834,NULL,916,40745,42010,2,96,2,231.40,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2835,NULL,916,40745,42010,2,67,2,48.60,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2836,NULL,916,40745,42010,2,13,1,280.00,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2837,NULL,917,40745,42010,2,96,2,661.16,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2838,NULL,917,40745,42010,2,67,2,138.84,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2839,NULL,917,40745,42010,2,13,1,800.00,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2840,NULL,918,40745,42010,2,96,2,1198.35,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL);
INSERT INTO `balance_libro_details` VALUES (2841,NULL,918,40745,42010,2,67,2,251.65,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2842,NULL,918,40745,42010,2,13,1,1450.00,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2843,NULL,919,40745,42010,2,96,2,892.56,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2844,NULL,919,40745,42010,2,67,2,187.44,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2845,NULL,919,40745,42010,2,13,1,1080.00,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2846,NULL,920,40745,42010,2,96,2,247.93,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2847,NULL,920,40745,42010,2,67,2,52.07,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2848,NULL,920,40745,42010,2,13,1,300.00,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2849,NULL,921,40745,42010,2,96,2,338.84,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2850,NULL,921,40745,42010,2,67,2,71.16,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2851,NULL,921,40745,42010,2,13,1,410.00,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2852,NULL,922,40745,42010,2,96,2,2611.57,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2853,NULL,922,40745,42010,2,67,2,548.43,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2854,NULL,922,40745,42010,2,13,1,3160.00,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2855,NULL,923,40745,42010,2,96,2,5106.61,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2856,NULL,923,40745,42010,2,67,2,1072.39,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2857,NULL,923,40745,42010,2,13,1,6179.00,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2858,NULL,924,40745,42010,2,96,2,2231.40,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2859,NULL,924,40745,42010,2,67,2,468.60,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2860,NULL,924,40745,42010,2,13,1,2700.00,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2861,NULL,925,40745,42010,2,96,2,406.61,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2862,NULL,925,40745,42010,2,67,2,85.39,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2863,NULL,925,40745,42010,2,13,1,492.00,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2864,NULL,926,40745,42010,2,96,2,198.35,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2865,NULL,926,40745,42010,2,67,2,41.65,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2866,NULL,926,40745,42010,2,13,1,240.00,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2867,NULL,927,40745,42010,2,96,2,1520.66,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2868,NULL,927,40745,42010,2,67,2,319.34,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2869,NULL,927,40745,42010,2,13,1,1840.00,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2870,NULL,928,40745,42010,2,96,2,719.01,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2871,NULL,928,40745,42010,2,67,2,150.99,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2872,NULL,928,40745,42010,2,13,1,870.00,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2873,NULL,929,40745,42010,2,96,2,1033.06,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2874,NULL,929,40745,42010,2,67,2,216.94,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2875,NULL,929,40745,42010,2,13,1,1250.00,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2876,NULL,930,40745,42010,2,96,2,822.31,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2877,NULL,930,40745,42010,2,67,2,172.69,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2878,NULL,930,40745,42010,2,13,1,995.00,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2879,NULL,931,40745,42010,2,96,2,991.74,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2880,NULL,931,40745,42010,2,67,2,208.26,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2881,NULL,931,40745,42010,2,13,1,1200.00,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL);
INSERT INTO `balance_libro_details` VALUES (2882,NULL,932,40745,42010,2,96,2,520.66,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2883,NULL,932,40745,42010,2,67,2,109.34,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2884,NULL,932,40745,42010,2,13,1,630.00,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2885,NULL,933,40745,42010,2,96,2,223.14,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2886,NULL,933,40745,42010,2,67,2,46.86,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2887,NULL,933,40745,42010,2,13,1,270.00,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2888,NULL,934,40745,42010,2,96,2,82.64,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2889,NULL,934,40745,42010,2,67,2,17.36,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2890,NULL,934,40745,42010,2,13,1,100.00,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2891,NULL,935,40745,42010,2,96,2,1702.48,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2892,NULL,935,40745,42010,2,67,2,357.52,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2893,NULL,935,40745,42010,2,13,1,2060.00,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2894,NULL,936,40745,42010,2,96,2,446.28,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2895,NULL,936,40745,42010,2,67,2,93.72,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2896,NULL,936,40745,42010,2,13,1,540.00,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2897,NULL,937,40745,42010,2,96,2,636.36,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2898,NULL,937,40745,42010,2,67,2,133.64,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2899,NULL,937,40745,42010,2,13,1,770.00,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2900,NULL,938,40745,42010,2,96,2,929.75,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2901,NULL,938,40745,42010,2,67,2,195.25,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2902,NULL,938,40745,42010,2,13,1,1125.00,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2903,NULL,939,40745,42010,2,96,2,462.81,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2904,NULL,939,40745,42010,2,67,2,97.19,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2905,NULL,939,40745,42010,2,13,1,560.00,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2906,NULL,940,40745,42010,2,96,2,636.36,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2907,NULL,940,40745,42010,2,67,2,133.64,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2908,NULL,940,40745,42010,2,13,1,770.00,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2909,NULL,941,40745,42010,2,96,2,82.64,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2910,NULL,941,40745,42010,2,67,2,17.36,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2911,NULL,941,40745,42010,2,13,1,100.00,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2912,NULL,942,40745,42010,2,96,2,1380.17,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2913,NULL,942,40745,42010,2,67,2,289.83,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2914,NULL,942,40745,42010,2,13,1,1670.00,NULL,'2022-11-24 14:20:42','2022-11-24 14:20:42',NULL),(2915,NULL,943,40745,42010,2,96,2,677.69,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2916,NULL,943,40745,42010,2,67,2,142.31,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2917,NULL,943,40745,42010,2,13,1,820.00,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2918,NULL,944,40745,42010,2,96,2,1206.61,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2919,NULL,944,40745,42010,2,67,2,253.39,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2920,NULL,944,40745,42010,2,13,1,1460.00,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2921,NULL,945,40745,42010,2,96,2,677.69,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2922,NULL,945,40745,42010,2,67,2,142.31,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL);
INSERT INTO `balance_libro_details` VALUES (2923,NULL,945,40745,42010,2,13,1,820.00,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2924,NULL,946,40745,42010,2,96,2,834.71,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2925,NULL,946,40745,42010,2,67,2,175.29,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2926,NULL,946,40745,42010,2,13,1,1010.00,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2927,NULL,947,40745,42010,2,96,2,1322.31,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2928,NULL,947,40745,42010,2,67,2,277.69,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2929,NULL,947,40745,42010,2,13,1,1600.00,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2930,NULL,948,40745,42010,2,96,2,1206.61,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2931,NULL,948,40745,42010,2,67,2,253.39,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2932,NULL,948,40745,42010,2,13,1,1460.00,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2933,NULL,949,40745,42010,2,96,2,190.08,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2934,NULL,949,40745,42010,2,67,2,39.92,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2935,NULL,949,40745,42010,2,13,1,230.00,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2936,NULL,950,40745,42010,2,96,2,1272.73,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2937,NULL,950,40745,42010,2,67,2,267.27,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2938,NULL,950,40745,42010,2,13,1,1540.00,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2939,NULL,951,40745,42010,2,96,2,1008.26,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2940,NULL,951,40745,42010,2,67,2,211.74,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2941,NULL,951,40745,42010,2,13,1,1220.00,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2942,NULL,952,40745,42010,2,96,2,611.57,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2943,NULL,952,40745,42010,2,67,2,128.43,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2944,NULL,952,40745,42010,2,13,1,740.00,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2945,NULL,953,40745,42010,2,96,2,4334.71,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2946,NULL,953,40745,42010,2,67,2,910.29,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2947,NULL,953,40745,42010,2,13,1,5245.00,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2948,NULL,954,40745,42010,2,96,2,652.89,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2949,NULL,954,40745,42010,2,67,2,137.11,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2950,NULL,954,40745,42010,2,13,1,790.00,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2951,NULL,955,40745,42010,2,96,2,1958.68,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2952,NULL,955,40745,42010,2,67,2,411.32,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2953,NULL,955,40745,42010,2,13,1,2370.00,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2954,NULL,956,40745,42010,2,96,2,190.08,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2955,NULL,956,40745,42010,2,67,2,39.92,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2956,NULL,956,40745,42010,2,13,1,230.00,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2957,NULL,957,40745,42010,2,96,2,4958.68,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2958,NULL,957,40745,42010,2,67,2,1041.32,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2959,NULL,957,40745,42010,2,13,1,6000.00,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2960,NULL,958,40745,42010,2,96,2,10842.98,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2961,NULL,958,40745,42010,2,67,2,2277.02,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2962,NULL,958,40745,42010,2,13,1,13120.00,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2963,NULL,959,40745,42010,2,96,2,1404.96,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL);
INSERT INTO `balance_libro_details` VALUES (2964,NULL,959,40745,42010,2,67,2,295.04,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2965,NULL,959,40745,42010,2,13,1,1700.00,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2966,NULL,960,40745,42010,2,96,2,2669.42,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2967,NULL,960,40745,42010,2,67,2,560.58,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2968,NULL,960,40745,42010,2,13,1,3230.00,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2969,NULL,961,40745,42010,2,96,2,619.83,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2970,NULL,961,40745,42010,2,67,2,130.17,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2971,NULL,961,40745,42010,2,13,1,750.00,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2972,NULL,962,40745,42010,2,96,2,1574.38,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2973,NULL,962,40745,42010,2,67,2,330.62,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2974,NULL,962,40745,42010,2,13,1,1905.00,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2975,NULL,963,40745,42010,2,96,2,1512.40,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2976,NULL,963,40745,42010,2,67,2,317.60,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2977,NULL,963,40745,42010,2,13,1,1830.00,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2978,NULL,964,40745,42010,2,96,2,2074.38,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2979,NULL,964,40745,42010,2,67,2,435.62,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2980,NULL,964,40745,42010,2,13,1,2510.00,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2981,NULL,965,40745,42010,2,96,2,1471.07,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2982,NULL,965,40745,42010,2,67,2,308.93,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2983,NULL,965,40745,42010,2,13,1,1780.00,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2984,NULL,966,40745,42010,2,96,2,595.04,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2985,NULL,966,40745,42010,2,67,2,124.96,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2986,NULL,966,40745,42010,2,13,1,720.00,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2987,NULL,967,40745,42010,2,96,2,2975.21,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2988,NULL,967,40745,42010,2,67,2,624.79,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2989,NULL,967,40745,42010,2,13,1,3600.00,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2990,NULL,968,40745,42010,2,96,2,330.58,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2991,NULL,968,40745,42010,2,67,2,69.42,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2992,NULL,968,40745,42010,2,13,1,400.00,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2993,NULL,969,40745,42010,2,96,2,528.93,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2994,NULL,969,40745,42010,2,67,2,111.07,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2995,NULL,969,40745,42010,2,13,1,640.00,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2996,NULL,970,40745,42010,2,96,2,797.52,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2997,NULL,970,40745,42010,2,67,2,167.48,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2998,NULL,970,40745,42010,2,13,1,965.00,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(2999,NULL,971,40745,42010,2,96,2,371.90,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(3000,NULL,971,40745,42010,2,67,2,78.10,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(3001,NULL,971,40745,42010,2,13,1,450.00,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(3002,NULL,972,40745,42010,2,96,2,1438.02,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(3003,NULL,972,40745,42010,2,67,2,301.98,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL),(3004,NULL,972,40745,42010,2,13,1,1740.00,NULL,'2022-11-24 14:20:43','2022-11-24 14:20:43',NULL);
INSERT INTO `balance_libro_details` VALUES (3005,NULL,973,40745,42010,2,96,2,1198.35,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3006,NULL,973,40745,42010,2,67,2,251.65,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3007,NULL,973,40745,42010,2,13,1,1450.00,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3008,NULL,974,40745,42010,2,96,2,702.48,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3009,NULL,974,40745,42010,2,67,2,147.52,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3010,NULL,974,40745,42010,2,13,1,850.00,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3011,NULL,975,40745,42010,2,96,2,1818.18,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3012,NULL,975,40745,42010,2,67,2,381.82,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3013,NULL,975,40745,42010,2,13,1,2200.00,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3014,NULL,976,40745,42010,2,96,2,380.17,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3015,NULL,976,40745,42010,2,67,2,79.83,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3016,NULL,976,40745,42010,2,13,1,460.00,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3017,NULL,977,40745,42010,2,96,2,272.73,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3018,NULL,977,40745,42010,2,67,2,57.27,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3019,NULL,977,40745,42010,2,13,1,330.00,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3020,NULL,978,40745,42010,2,96,2,1082.64,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3021,NULL,978,40745,42010,2,67,2,227.36,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3022,NULL,978,40745,42010,2,13,1,1310.00,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3023,NULL,979,40745,42010,2,96,2,1537.19,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3024,NULL,979,40745,42010,2,67,2,322.81,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3025,NULL,979,40745,42010,2,13,1,1860.00,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3026,NULL,980,40745,42010,2,96,2,347.11,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3027,NULL,980,40745,42010,2,67,2,72.89,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3028,NULL,980,40745,42010,2,13,1,420.00,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3029,NULL,981,40745,42010,2,96,2,99.17,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3030,NULL,981,40745,42010,2,67,2,20.83,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3031,NULL,981,40745,42010,2,13,1,120.00,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3032,NULL,982,40745,42010,2,96,2,413.22,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3033,NULL,982,40745,42010,2,67,2,86.78,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3034,NULL,982,40745,42010,2,13,1,500.00,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3035,NULL,983,40745,42010,2,96,2,971.07,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3036,NULL,983,40745,42010,2,67,2,203.93,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3037,NULL,983,40745,42010,2,13,1,1175.00,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3038,NULL,984,40745,42010,2,96,2,789.26,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3039,NULL,984,40745,42010,2,67,2,165.74,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3040,NULL,984,40745,42010,2,13,1,955.00,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3041,NULL,985,40745,42010,2,96,2,570.25,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3042,NULL,985,40745,42010,2,67,2,119.75,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3043,NULL,985,40745,42010,2,13,1,690.00,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3044,NULL,986,40745,42010,2,96,2,297.52,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3045,NULL,986,40745,42010,2,67,2,62.48,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL);
INSERT INTO `balance_libro_details` VALUES (3046,NULL,986,40745,42010,2,13,1,360.00,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3047,NULL,987,40745,42010,2,96,2,4028.93,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3048,NULL,987,40745,42010,2,67,2,846.07,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3049,NULL,987,40745,42010,2,13,1,4875.00,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3050,NULL,988,40745,42010,2,96,2,371.90,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3051,NULL,988,40745,42010,2,67,2,78.10,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3052,NULL,988,40745,42010,2,13,1,450.00,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3053,NULL,989,40745,42010,2,96,2,2191.74,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3054,NULL,989,40745,42010,2,67,2,460.26,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3055,NULL,989,40745,42010,2,13,1,2652.00,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3056,NULL,990,40745,42010,2,96,2,595.04,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3057,NULL,990,40745,42010,2,67,2,124.96,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3058,NULL,990,40745,42010,2,13,1,720.00,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3059,NULL,991,40745,42010,2,96,2,471.07,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3060,NULL,991,40745,42010,2,67,2,98.93,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3061,NULL,991,40745,42010,2,13,1,570.00,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3062,NULL,992,40745,42010,2,96,2,5004.13,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3063,NULL,992,40745,42010,2,67,2,1050.87,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3064,NULL,992,40745,42010,2,13,1,6055.00,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3065,NULL,993,40745,42010,2,96,2,5123.97,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3066,NULL,993,40745,42010,2,67,2,1076.03,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3067,NULL,993,40745,42010,2,13,1,6200.00,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3068,NULL,994,40745,42010,2,96,2,727.27,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3069,NULL,994,40745,42010,2,67,2,152.73,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3070,NULL,994,40745,42010,2,13,1,880.00,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3071,NULL,995,40745,42010,2,96,2,826.45,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3072,NULL,995,40745,42010,2,67,2,173.55,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3073,NULL,995,40745,42010,2,13,1,1000.00,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3074,NULL,996,40745,42010,2,96,2,194.21,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3075,NULL,996,40745,42010,2,67,2,40.79,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3076,NULL,996,40745,42010,2,13,1,235.00,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3077,NULL,997,40745,42010,2,96,2,495.87,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3078,NULL,997,40745,42010,2,67,2,104.13,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3079,NULL,997,40745,42010,2,13,1,600.00,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3080,NULL,998,40745,42010,2,96,2,888.43,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3081,NULL,998,40745,42010,2,67,2,186.57,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3082,NULL,998,40745,42010,2,13,1,1075.00,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3083,NULL,999,40745,42010,2,96,2,1066.12,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3084,NULL,999,40745,42010,2,67,2,223.88,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3085,NULL,999,40745,42010,2,13,1,1290.00,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3086,NULL,1000,40745,42010,2,96,2,735.54,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL);
INSERT INTO `balance_libro_details` VALUES (3087,NULL,1000,40745,42010,2,67,2,154.46,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3088,NULL,1000,40745,42010,2,13,1,890.00,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3089,NULL,1001,40745,42010,2,96,2,338.84,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3090,NULL,1001,40745,42010,2,67,2,71.16,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3091,NULL,1001,40745,42010,2,13,1,410.00,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3092,NULL,1002,40745,42010,2,96,2,338.84,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3093,NULL,1002,40745,42010,2,67,2,71.16,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3094,NULL,1002,40745,42010,2,13,1,410.00,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3095,NULL,1003,40745,42010,2,96,2,520.66,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3096,NULL,1003,40745,42010,2,67,2,109.34,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3097,NULL,1003,40745,42010,2,13,1,630.00,NULL,'2022-11-24 14:20:44','2022-11-24 14:20:44',NULL),(3098,NULL,1004,40745,42010,2,96,2,2074.38,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3099,NULL,1004,40745,42010,2,67,2,435.62,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3100,NULL,1004,40745,42010,2,13,1,2510.00,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3101,NULL,1005,40745,42010,2,96,2,462.81,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3102,NULL,1005,40745,42010,2,67,2,97.19,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3103,NULL,1005,40745,42010,2,13,1,560.00,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3104,NULL,1006,40745,42010,2,96,2,966.94,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3105,NULL,1006,40745,42010,2,67,2,203.06,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3106,NULL,1006,40745,42010,2,13,1,1170.00,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3107,NULL,1007,40745,42010,2,96,2,760.33,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3108,NULL,1007,40745,42010,2,67,2,159.67,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3109,NULL,1007,40745,42010,2,13,1,920.00,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3110,NULL,1008,40745,42010,2,96,2,367.77,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3111,NULL,1008,40745,42010,2,67,2,77.23,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3112,NULL,1008,40745,42010,2,13,1,445.00,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3113,NULL,1009,40745,42010,2,96,2,2512.40,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3114,NULL,1009,40745,42010,2,67,2,527.60,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3115,NULL,1009,40745,42010,2,13,1,3040.00,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3116,NULL,1010,40745,42010,2,96,2,350.41,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3117,NULL,1010,40745,42010,2,67,2,73.59,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3118,NULL,1010,40745,42010,2,13,1,424.00,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3119,NULL,1011,40745,42010,2,96,2,413.22,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3120,NULL,1011,40745,42010,2,67,2,86.78,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3121,NULL,1011,40745,42010,2,13,1,500.00,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3122,NULL,1012,40745,42010,2,96,2,7396.69,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3123,NULL,1012,40745,42010,2,67,2,1553.31,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3124,NULL,1012,40745,42010,2,13,1,8950.00,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3125,NULL,1013,40745,42010,2,96,2,495.87,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3126,NULL,1013,40745,42010,2,67,2,104.13,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3127,NULL,1013,40745,42010,2,13,1,600.00,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL);
INSERT INTO `balance_libro_details` VALUES (3128,NULL,1014,40745,42010,2,96,2,723.97,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3129,NULL,1014,40745,42010,2,67,2,152.03,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3130,NULL,1014,40745,42010,2,13,1,876.00,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3131,NULL,1015,40745,42010,2,96,2,136.36,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3132,NULL,1015,40745,42010,2,67,2,28.64,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3133,NULL,1015,40745,42010,2,13,1,165.00,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3134,NULL,1016,40745,42010,2,96,2,512.40,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3135,NULL,1016,40745,42010,2,67,2,107.60,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3136,NULL,1016,40745,42010,2,13,1,620.00,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3137,NULL,1017,40745,42010,2,96,2,1528.93,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3138,NULL,1017,40745,42010,2,67,2,321.07,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3139,NULL,1017,40745,42010,2,13,1,1850.00,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3140,NULL,1018,40745,42010,2,96,2,1132.23,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3141,NULL,1018,40745,42010,2,67,2,237.77,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3142,NULL,1018,40745,42010,2,13,1,1370.00,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3143,NULL,1019,40745,42010,2,96,2,1115.70,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3144,NULL,1019,40745,42010,2,67,2,234.30,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3145,NULL,1019,40745,42010,2,13,1,1350.00,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3146,NULL,1020,40745,42010,2,96,2,428.93,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3147,NULL,1020,40745,42010,2,67,2,90.07,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3148,NULL,1020,40745,42010,2,13,1,519.00,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3149,NULL,1021,40745,42010,2,96,2,454.55,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3150,NULL,1021,40745,42010,2,67,2,95.45,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3151,NULL,1021,40745,42010,2,13,1,550.00,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3152,NULL,1022,40745,42010,2,96,2,495.87,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3153,NULL,1022,40745,42010,2,67,2,104.13,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3154,NULL,1022,40745,42010,2,13,1,600.00,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3155,NULL,1023,40745,42010,2,96,2,3442.15,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3156,NULL,1023,40745,42010,2,67,2,722.85,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3157,NULL,1023,40745,42010,2,13,1,4165.00,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3158,NULL,1024,40745,42010,2,96,2,743.80,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3159,NULL,1024,40745,42010,2,67,2,156.20,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3160,NULL,1024,40745,42010,2,13,1,900.00,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3161,NULL,1025,40745,42010,2,96,2,132.23,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3162,NULL,1025,40745,42010,2,67,2,27.77,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3163,NULL,1025,40745,42010,2,13,1,160.00,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3164,NULL,1026,40745,42010,2,96,2,82.64,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3165,NULL,1026,40745,42010,2,67,2,17.36,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3166,NULL,1026,40745,42010,2,13,1,100.00,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3167,NULL,1027,40745,42010,2,96,2,723.14,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3168,NULL,1027,40745,42010,2,67,2,151.86,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL);
INSERT INTO `balance_libro_details` VALUES (3169,NULL,1027,40745,42010,2,13,1,875.00,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3170,NULL,1028,40745,42010,2,96,2,1491.74,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3171,NULL,1028,40745,42010,2,67,2,313.26,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3172,NULL,1028,40745,42010,2,13,1,1805.00,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3173,NULL,1029,40745,42010,2,96,2,793.39,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3174,NULL,1029,40745,42010,2,67,2,166.61,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3175,NULL,1029,40745,42010,2,13,1,960.00,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3176,NULL,1030,40745,42010,2,96,2,231.40,NULL,'2022-11-24 14:20:45','2022-11-24 14:20:45',NULL),(3177,NULL,1030,40745,42010,2,67,2,48.60,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3178,NULL,1030,40745,42010,2,13,1,280.00,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3179,NULL,1031,40745,42010,2,96,2,1400.83,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3180,NULL,1031,40745,42010,2,67,2,294.17,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3181,NULL,1031,40745,42010,2,13,1,1695.00,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3182,NULL,1032,40745,42010,2,96,2,1049.59,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3183,NULL,1032,40745,42010,2,67,2,220.41,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3184,NULL,1032,40745,42010,2,13,1,1270.00,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3185,NULL,1033,40745,42010,2,96,2,206.61,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3186,NULL,1033,40745,42010,2,67,2,43.39,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3187,NULL,1033,40745,42010,2,13,1,250.00,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3188,NULL,1034,40745,42010,2,96,2,198.35,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3189,NULL,1034,40745,42010,2,67,2,41.65,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3190,NULL,1034,40745,42010,2,13,1,240.00,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3191,NULL,1035,40745,42010,2,96,2,1966.94,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3192,NULL,1035,40745,42010,2,67,2,413.06,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3193,NULL,1035,40745,42010,2,13,1,2380.00,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3194,NULL,1036,40745,42010,2,96,2,388.43,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3195,NULL,1036,40745,42010,2,67,2,81.57,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3196,NULL,1036,40745,42010,2,13,1,470.00,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3197,NULL,1037,40745,42010,2,96,2,297.52,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3198,NULL,1037,40745,42010,2,67,2,62.48,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3199,NULL,1037,40745,42010,2,13,1,360.00,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3200,NULL,1038,40745,42010,2,96,2,830.58,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3201,NULL,1038,40745,42010,2,67,2,174.42,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3202,NULL,1038,40745,42010,2,13,1,1005.00,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3203,NULL,1039,40745,42010,2,96,2,1057.85,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3204,NULL,1039,40745,42010,2,67,2,222.15,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3205,NULL,1039,40745,42010,2,13,1,1280.00,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3206,NULL,1040,40745,42010,2,96,2,694.21,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3207,NULL,1040,40745,42010,2,67,2,145.79,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3208,NULL,1040,40745,42010,2,13,1,840.00,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3209,NULL,1041,40745,42010,2,96,2,413.22,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL);
INSERT INTO `balance_libro_details` VALUES (3210,NULL,1041,40745,42010,2,67,2,86.78,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3211,NULL,1041,40745,42010,2,13,1,500.00,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3212,NULL,1042,40745,42010,2,96,2,1041.32,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3213,NULL,1042,40745,42010,2,67,2,218.68,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3214,NULL,1042,40745,42010,2,13,1,1260.00,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3215,NULL,1043,40745,42010,2,96,2,1123.97,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3216,NULL,1043,40745,42010,2,67,2,236.03,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3217,NULL,1043,40745,42010,2,13,1,1360.00,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3218,NULL,1044,40745,42010,2,96,2,173.55,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3219,NULL,1044,40745,42010,2,67,2,36.45,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3220,NULL,1044,40745,42010,2,13,1,210.00,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3221,NULL,1045,40745,42010,2,96,2,1429.75,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3222,NULL,1045,40745,42010,2,67,2,300.25,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3223,NULL,1045,40745,42010,2,13,1,1730.00,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3224,NULL,1046,40745,42010,2,96,2,289.26,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3225,NULL,1046,40745,42010,2,67,2,60.74,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3226,NULL,1046,40745,42010,2,13,1,350.00,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3227,NULL,1047,40745,42010,2,96,2,909.09,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3228,NULL,1047,40745,42010,2,67,2,190.91,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3229,NULL,1047,40745,42010,2,13,1,1100.00,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3230,NULL,1048,40745,42010,2,96,2,437.19,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3231,NULL,1048,40745,42010,2,67,2,91.81,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3232,NULL,1048,40745,42010,2,13,1,529.00,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3233,NULL,1049,40745,42010,2,96,2,165.29,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3234,NULL,1049,40745,42010,2,67,2,34.71,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3235,NULL,1049,40745,42010,2,13,1,200.00,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3236,7638,1050,40745,42010,3,217,1,29582.03,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3237,7638,1050,40745,42010,3,68,1,6212.23,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3238,7638,1050,40745,42010,3,217,1,2906.77,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3239,7638,1050,40745,42010,3,57,2,38701.03,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3240,NULL,1051,40745,42010,2,96,2,4247.93,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3241,NULL,1051,40745,42010,2,67,2,892.07,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3242,NULL,1051,40745,42010,2,13,1,5140.00,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3243,7638,1052,40745,42010,3,217,1,19592.06,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3244,7638,1052,40745,42010,3,68,1,4114.33,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3245,7638,1052,40745,42010,3,217,1,1621.90,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3246,7638,1052,40745,42010,3,57,2,25328.29,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3247,NULL,1053,40745,42010,2,96,2,379.34,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3248,NULL,1053,40745,42010,2,67,2,79.66,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3249,NULL,1053,40745,42010,2,13,1,459.00,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3250,7638,1054,40745,42010,3,217,1,136.71,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL);
INSERT INTO `balance_libro_details` VALUES (3251,7638,1054,40745,42010,3,68,1,28.71,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3252,7638,1054,40745,42010,3,57,2,165.42,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3253,NULL,1055,40745,42010,2,96,2,739.67,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3254,NULL,1055,40745,42010,2,67,2,155.33,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3255,NULL,1055,40745,42010,2,13,1,895.00,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3256,7638,1056,40745,42010,3,217,1,16848.99,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3257,7638,1056,40745,42010,3,68,1,3538.29,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3258,7638,1056,40745,42010,3,217,1,464.46,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3259,7638,1056,40745,42010,3,57,2,20851.74,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3260,NULL,1057,40745,42010,2,96,2,514.05,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3261,NULL,1057,40745,42010,2,67,2,107.95,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3262,NULL,1057,40745,42010,2,13,1,622.00,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3263,7638,1058,40745,42010,3,217,1,8660.00,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3264,7638,1058,40745,42010,3,68,1,1913.16,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3265,7638,1058,40745,42010,3,217,1,259.80,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3266,7638,1058,40745,42010,3,57,2,10832.96,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3267,NULL,1059,40745,42010,2,96,2,1709.92,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3268,NULL,1059,40745,42010,2,67,2,359.08,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3269,NULL,1059,40745,42010,2,13,1,2069.00,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3270,7638,1060,40745,42010,3,217,1,129383.97,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3271,7638,1060,40745,42010,3,68,1,27170.63,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3272,7638,1060,40745,42010,3,217,1,3881.53,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3273,7638,1060,40745,42010,3,57,2,160436.13,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3274,NULL,1061,40745,42010,2,96,2,1165.29,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3275,NULL,1061,40745,42010,2,67,2,244.71,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3276,NULL,1061,40745,42010,2,13,1,1410.00,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3277,7638,1062,40745,42010,3,217,1,41279.97,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3278,7638,1062,40745,42010,3,68,1,8668.79,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3279,7638,1062,40745,42010,3,217,1,3679.75,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3280,7638,1062,40745,42010,3,57,2,53628.51,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3281,NULL,1063,40745,42010,2,96,2,115.70,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3282,NULL,1063,40745,42010,2,67,2,24.30,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3283,NULL,1063,40745,42010,2,13,1,140.00,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3284,7638,1064,40745,42010,3,217,1,66550.41,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3285,7638,1064,40745,42010,3,68,1,13975.59,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3286,7638,1064,40745,42010,3,217,1,5571.68,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3287,7638,1064,40745,42010,3,57,2,86097.68,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3288,NULL,1065,40745,42010,2,96,2,652.89,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3289,NULL,1065,40745,42010,2,67,2,137.11,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3290,NULL,1065,40745,42010,2,13,1,790.00,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL);
INSERT INTO `balance_libro_details` VALUES (3291,7638,1066,40745,42010,3,217,1,26502.93,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3292,7638,1066,40745,42010,3,68,1,5565.62,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3293,7638,1066,40745,42010,3,57,2,32068.55,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3294,NULL,1067,40745,42010,2,96,2,528.93,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3295,NULL,1067,40745,42010,2,67,2,111.07,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3296,NULL,1067,40745,42010,2,13,1,640.00,NULL,'2022-11-24 14:20:46','2022-11-24 14:20:46',NULL),(3297,7638,1068,40745,42010,3,217,1,5692.43,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3298,7638,1068,40745,42010,3,68,1,1195.41,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3299,7638,1068,40745,42010,3,217,1,170.77,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3300,7638,1068,40745,42010,3,57,2,7058.61,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3301,NULL,1069,40745,42010,2,96,2,801.65,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3302,NULL,1069,40745,42010,2,67,2,168.35,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3303,NULL,1069,40745,42010,2,13,1,970.00,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3304,7638,1070,40745,42010,3,217,1,33526.96,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3305,7638,1070,40745,42010,3,68,1,7040.66,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3306,7638,1070,40745,42010,3,217,1,1005.81,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3307,7638,1070,40745,42010,3,57,2,41573.43,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3308,NULL,1071,40745,42010,2,96,2,438.02,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3309,NULL,1071,40745,42010,2,67,2,91.98,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3310,NULL,1071,40745,42010,2,13,1,530.00,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3311,7638,1072,40745,42010,3,217,2,1672.40,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3312,NULL,1073,40745,42010,2,96,2,1553.72,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3313,7638,1072,40745,42010,3,67,2,351.20,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3314,NULL,1073,40745,42010,2,67,2,326.28,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3315,7638,1072,40745,42010,3,217,2,50.18,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3316,NULL,1073,40745,42010,2,13,1,1880.00,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3317,7638,1072,40745,42010,3,57,1,2073.78,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3318,7638,1074,40745,42010,3,217,2,1084.70,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3319,NULL,1075,40745,42010,2,96,2,2446.28,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3320,NULL,1075,40745,42010,2,67,2,513.72,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3321,7638,1074,40745,42010,3,67,2,227.79,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3322,NULL,1075,40745,42010,2,13,1,2960.00,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3323,7638,1074,40745,42010,3,217,2,32.54,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3324,7638,1074,40745,42010,3,57,1,1345.03,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3325,7638,1076,40745,42010,3,217,1,503.06,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3326,NULL,1077,40745,42010,2,96,2,826.45,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3327,7638,1076,40745,42010,3,68,1,105.64,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3328,NULL,1077,40745,42010,2,67,2,173.55,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3329,7638,1076,40745,42010,3,57,2,608.70,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3330,NULL,1077,40745,42010,2,13,1,1000.00,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3331,NULL,1078,40745,42010,2,96,2,570.25,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL);
INSERT INTO `balance_libro_details` VALUES (3332,7638,1079,40745,42010,3,217,1,23412.13,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3333,NULL,1078,40745,42010,2,67,2,119.75,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3334,7638,1079,40745,42010,3,68,1,4916.55,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3335,NULL,1078,40745,42010,2,13,1,690.00,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3336,7638,1079,40745,42010,3,217,1,661.35,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3337,7638,1079,40745,42010,3,57,2,28990.03,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3338,NULL,1080,40745,42010,2,96,2,173.55,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3339,NULL,1080,40745,42010,2,67,2,36.45,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3340,NULL,1080,40745,42010,2,13,1,210.00,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3341,7638,1081,40745,42010,3,250,1,35000.00,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3342,7638,1081,40745,42010,3,57,2,35000.00,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3343,NULL,1082,40745,42010,2,96,2,495.87,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3344,NULL,1082,40745,42010,2,67,2,104.13,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3345,NULL,1082,40745,42010,2,13,1,600.00,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3346,7638,1083,40745,42010,3,217,1,8781.39,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3347,7638,1083,40745,42010,3,68,1,1844.09,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3348,7638,1083,40745,42010,3,217,1,601.46,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3349,7638,1083,40745,42010,3,57,2,11226.94,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3350,NULL,1084,40745,42010,2,96,2,2119.83,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3351,NULL,1084,40745,42010,2,67,2,445.17,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3352,NULL,1084,40745,42010,2,13,1,2565.00,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3353,7638,1085,40745,42010,3,217,1,12887.56,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3354,7638,1085,40745,42010,3,68,1,2706.39,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3355,7638,1085,40745,42010,3,217,1,1048.71,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3356,7638,1085,40745,42010,3,57,2,16642.66,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3357,NULL,1086,40745,42010,2,96,2,2479.34,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3358,NULL,1086,40745,42010,2,67,2,520.66,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3359,NULL,1086,40745,42010,2,13,1,3000.00,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3360,7638,1087,40745,42010,3,250,1,143640.00,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3361,7638,1087,40745,42010,3,57,2,143640.00,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3362,NULL,1088,40745,42010,2,96,2,2066.12,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3363,NULL,1088,40745,42010,2,67,2,433.88,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3364,NULL,1088,40745,42010,2,13,1,2500.00,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3365,7638,1089,40745,42010,3,217,1,10320.24,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3366,7638,1089,40745,42010,3,68,1,2167.25,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3367,7638,1089,40745,42010,3,57,2,12487.49,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3368,NULL,1090,40745,42010,2,96,2,495.87,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3369,NULL,1090,40745,42010,2,67,2,104.13,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3370,NULL,1090,40745,42010,2,13,1,600.00,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3371,7638,1091,40745,42010,3,217,1,26799.43,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL);
INSERT INTO `balance_libro_details` VALUES (3372,7638,1091,40745,42010,3,68,1,5627.88,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3373,7638,1091,40745,42010,3,217,1,762.97,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3374,7638,1091,40745,42010,3,57,2,33190.28,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3375,NULL,1092,40745,42010,2,96,2,946.28,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3376,NULL,1092,40745,42010,2,67,2,198.72,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3377,NULL,1092,40745,42010,2,13,1,1145.00,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3378,7638,1093,40745,42010,3,217,1,11709.84,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3379,7638,1093,40745,42010,3,68,1,2459.07,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3380,7638,1093,40745,42010,3,217,1,310.28,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3381,7638,1093,40745,42010,3,57,2,14479.19,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3382,NULL,1094,40745,42010,2,96,2,1628.10,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3383,NULL,1094,40745,42010,2,67,2,341.90,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3384,NULL,1094,40745,42010,2,13,1,1970.00,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3385,7638,1095,40745,42010,3,217,1,80645.69,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3386,7638,1095,40745,42010,3,68,1,16496.14,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3387,7638,1095,40745,42010,3,217,1,2356.60,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3388,7638,1095,40745,42010,3,57,2,99498.43,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3389,NULL,1096,40745,42010,2,96,2,537.19,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3390,NULL,1096,40745,42010,2,67,2,112.81,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3391,NULL,1096,40745,42010,2,13,1,650.00,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3392,7638,1097,40745,42010,3,217,1,12410.27,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3393,7638,1097,40745,42010,3,68,1,2606.16,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3394,7638,1097,40745,42010,3,217,1,587.85,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3395,7638,1097,40745,42010,3,57,2,15604.28,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3396,7638,1098,40745,42010,3,217,1,3150.43,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3397,7638,1098,40745,42010,3,68,1,661.59,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3398,7638,1098,40745,42010,3,217,1,477.31,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3399,7638,1098,40745,42010,3,57,2,4289.33,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3400,NULL,1099,40745,42010,2,96,2,355.37,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3401,NULL,1099,40745,42010,2,67,2,74.63,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3402,NULL,1099,40745,42010,2,13,1,430.00,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3403,7638,1100,40745,42010,3,217,1,2100.28,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3404,7638,1100,40745,42010,3,68,1,441.06,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3405,7638,1100,40745,42010,3,217,1,318.20,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3406,7638,1100,40745,42010,3,57,2,2859.54,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3407,NULL,1101,40745,42010,2,96,2,628.10,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3408,NULL,1101,40745,42010,2,67,2,131.90,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3409,NULL,1101,40745,42010,2,13,1,760.00,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3410,7638,1102,40745,42010,3,217,1,11078.64,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3411,7638,1102,40745,42010,3,68,1,2326.51,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL);
INSERT INTO `balance_libro_details` VALUES (3412,7638,1102,40745,42010,3,217,1,291.35,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3413,7638,1102,40745,42010,3,57,2,13696.50,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3414,NULL,1103,40745,42010,2,96,2,214.88,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3415,7638,1104,40745,42010,3,217,1,8791.51,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3416,NULL,1103,40745,42010,2,67,2,45.12,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3417,7638,1104,40745,42010,3,68,1,1846.22,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3418,NULL,1103,40745,42010,2,13,1,260.00,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3419,7638,1104,40745,42010,3,217,1,263.75,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3420,7638,1104,40745,42010,3,57,2,10901.48,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3421,NULL,1105,40745,42010,2,96,2,818.18,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3422,7638,1106,40745,42010,3,217,2,437.98,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3423,NULL,1105,40745,42010,2,67,2,171.82,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3424,7638,1106,40745,42010,3,67,2,91.98,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3425,NULL,1105,40745,42010,2,13,1,990.00,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3426,7638,1106,40745,42010,3,57,1,529.96,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3427,NULL,1107,40745,42010,2,96,2,154.55,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3428,NULL,1107,40745,42010,2,67,2,32.45,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3429,7638,1108,40745,42010,3,217,1,2382.50,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3430,NULL,1107,40745,42010,2,13,1,187.00,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3431,7638,1108,40745,42010,3,68,1,500.33,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3432,7638,1108,40745,42010,3,217,1,278.65,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3433,7638,1108,40745,42010,3,57,2,3161.48,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3434,NULL,1109,40745,42010,2,96,2,330.58,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3435,NULL,1109,40745,42010,2,67,2,69.42,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3436,NULL,1109,40745,42010,2,13,1,400.00,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3437,7638,1110,40745,42010,3,217,1,6867.91,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3438,7638,1110,40745,42010,3,68,1,1442.26,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3439,7638,1110,40745,42010,3,217,1,713.85,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3440,7638,1110,40745,42010,3,57,2,9024.02,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3441,NULL,1111,40745,42010,2,96,2,497.52,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3442,NULL,1111,40745,42010,2,67,2,104.48,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3443,NULL,1111,40745,42010,2,13,1,602.00,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3444,7638,1112,40745,42010,3,217,1,16366.20,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3445,7638,1112,40745,42010,3,68,1,3436.90,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3446,7638,1112,40745,42010,3,217,1,470.25,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3447,7638,1112,40745,42010,3,57,2,20273.35,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3448,NULL,1113,40745,42010,2,96,2,1319.01,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3449,NULL,1113,40745,42010,2,67,2,276.99,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3450,NULL,1113,40745,42010,2,13,1,1596.00,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3451,7638,1114,40745,42010,3,217,1,23014.04,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3452,7638,1114,40745,42010,3,68,1,4832.95,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL);
INSERT INTO `balance_libro_details` VALUES (3453,7638,1114,40745,42010,3,217,1,606.88,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3454,7638,1114,40745,42010,3,57,2,28453.87,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3455,NULL,1115,40745,42010,2,96,2,280.99,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3456,NULL,1115,40745,42010,2,67,2,59.01,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3457,NULL,1115,40745,42010,2,13,1,340.00,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3458,7638,1116,40745,42010,3,217,2,546.84,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3459,7638,1116,40745,42010,3,67,2,114.84,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3460,7638,1116,40745,42010,3,57,1,661.68,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3461,NULL,1117,40745,42010,2,96,2,826.45,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3462,NULL,1117,40745,42010,2,67,2,173.55,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3463,NULL,1117,40745,42010,2,13,1,1000.00,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3464,7638,1118,40745,42010,3,217,1,7427.05,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3465,7638,1118,40745,42010,3,68,1,1559.68,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3466,7638,1118,40745,42010,3,217,1,222.81,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3467,7638,1118,40745,42010,3,57,2,9209.54,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3468,NULL,1119,40745,42010,2,96,2,471.07,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3469,NULL,1119,40745,42010,2,67,2,98.93,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3470,NULL,1119,40745,42010,2,13,1,570.00,NULL,'2022-11-24 14:20:47','2022-11-24 14:20:47',NULL),(3471,7638,1120,40745,42010,3,217,1,10024.56,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3472,7638,1120,40745,42010,3,68,1,2105.16,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3473,7638,1120,40745,42010,3,217,1,465.03,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3474,7638,1120,40745,42010,3,57,2,12594.75,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3475,NULL,1121,40745,42010,2,96,2,867.77,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3476,NULL,1121,40745,42010,2,67,2,182.23,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3477,NULL,1121,40745,42010,2,13,1,1050.00,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3478,7638,1122,40745,42010,3,217,1,11727.77,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3479,7638,1122,40745,42010,3,68,1,2462.83,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3480,7638,1122,40745,42010,3,217,1,1256.24,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3481,7638,1122,40745,42010,3,57,2,15446.84,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3482,NULL,1123,40745,42010,2,96,2,719.01,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3483,NULL,1123,40745,42010,2,67,2,150.99,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3484,NULL,1123,40745,42010,2,13,1,870.00,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3485,7638,1124,40745,42010,3,217,1,15917.45,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3486,7638,1124,40745,42010,3,68,1,3342.66,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3487,7638,1124,40745,42010,3,217,1,407.80,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3488,7638,1124,40745,42010,3,57,2,19667.91,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3489,NULL,1125,40745,42010,2,96,2,830.58,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3490,NULL,1125,40745,42010,2,67,2,174.42,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3491,NULL,1125,40745,42010,2,13,1,1005.00,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3492,7638,1126,40745,42010,3,217,1,27718.50,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL);
INSERT INTO `balance_libro_details` VALUES (3493,7638,1126,40745,42010,3,68,1,5820.89,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3494,7638,1126,40745,42010,3,217,1,831.56,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3495,7638,1126,40745,42010,3,57,2,34370.95,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3496,7638,1127,40745,42010,3,217,1,17197.42,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3497,7638,1127,40745,42010,3,68,1,3611.46,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3498,7638,1127,40745,42010,3,57,2,20808.88,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3499,NULL,1128,40745,42010,2,96,2,82.64,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3500,NULL,1128,40745,42010,2,67,2,17.36,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3501,NULL,1128,40745,42010,2,13,1,100.00,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3502,7638,1129,40745,42010,3,217,1,18998.18,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3503,7638,1129,40745,42010,3,68,1,3989.62,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3504,7638,1129,40745,42010,3,57,2,22987.80,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3505,NULL,1130,40745,42010,2,96,2,694.21,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3506,NULL,1130,40745,42010,2,67,2,145.79,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3507,7638,1131,40745,42010,3,217,1,22552.24,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3508,7638,1131,40745,42010,3,68,1,4735.97,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3509,NULL,1130,40745,42010,2,13,1,840.00,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3510,7638,1131,40745,42010,3,57,2,27288.21,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3511,7638,1132,40745,42010,3,217,2,297.73,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3512,7638,1132,40745,42010,3,67,2,62.52,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3513,7638,1132,40745,42010,3,57,1,360.25,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3514,NULL,1133,40745,42010,2,96,2,983.47,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3515,NULL,1133,40745,42010,2,67,2,206.53,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3516,NULL,1133,40745,42010,2,13,1,1190.00,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3517,7638,1134,40745,42010,3,217,1,1841.70,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3518,7638,1134,40745,42010,3,68,1,386.76,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3519,7638,1134,40745,42010,3,57,2,2228.46,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3520,NULL,1135,40745,42010,2,96,2,347.11,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3521,NULL,1135,40745,42010,2,67,2,72.89,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3522,NULL,1135,40745,42010,2,13,1,420.00,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3523,7638,1136,40745,42010,3,217,1,10984.08,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3524,7638,1136,40745,42010,3,68,1,2306.66,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3525,7638,1136,40745,42010,3,57,2,13290.74,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3526,NULL,1137,40745,42010,2,96,2,421.49,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3527,NULL,1137,40745,42010,2,67,2,88.51,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3528,NULL,1137,40745,42010,2,13,1,510.00,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3529,7638,1138,40745,42010,3,217,1,262200.00,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3530,7638,1138,40745,42010,3,68,1,27531.00,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3531,7638,1138,40745,42010,3,57,2,289731.00,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3532,NULL,1139,40745,42010,2,96,2,479.34,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL);
INSERT INTO `balance_libro_details` VALUES (3533,NULL,1139,40745,42010,2,67,2,100.66,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3534,NULL,1139,40745,42010,2,13,1,580.00,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3535,7638,1140,40745,42010,3,217,1,491910.00,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3536,7638,1140,40745,42010,3,68,1,51650.55,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3537,7638,1140,40745,42010,3,57,2,543560.55,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3538,NULL,1141,40745,42010,2,96,2,615.70,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3539,NULL,1141,40745,42010,2,67,2,129.30,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3540,NULL,1141,40745,42010,2,13,1,745.00,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3541,7638,1142,40745,42010,3,217,1,603630.00,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3542,7638,1142,40745,42010,3,68,1,63381.15,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3543,7638,1142,40745,42010,3,57,2,667011.15,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3544,NULL,1143,40745,42010,2,96,2,595.04,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3545,NULL,1143,40745,42010,2,67,2,124.96,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3546,NULL,1143,40745,42010,2,13,1,720.00,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3547,NULL,1144,40745,42010,2,96,2,338.84,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3548,NULL,1144,40745,42010,2,67,2,71.16,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3549,NULL,1144,40745,42010,2,13,1,410.00,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3550,7638,1145,40745,42010,3,217,1,2785.88,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3551,7638,1145,40745,42010,3,68,1,585.03,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3552,7638,1145,40745,42010,3,217,1,187.17,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3553,7638,1145,40745,42010,3,57,2,3558.08,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3554,NULL,1146,40745,42010,2,96,2,958.68,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3555,NULL,1146,40745,42010,2,67,2,201.32,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3556,NULL,1146,40745,42010,2,13,1,1160.00,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3557,7638,1147,40745,42010,3,217,1,9539.47,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3558,7638,1147,40745,42010,3,68,1,2003.29,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3559,7638,1147,40745,42010,3,217,1,976.95,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3560,7638,1147,40745,42010,3,57,2,12519.71,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3561,NULL,1148,40745,42010,2,96,2,570.25,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3562,NULL,1148,40745,42010,2,67,2,119.75,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3563,NULL,1148,40745,42010,2,13,1,690.00,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3564,7638,1149,40745,42010,3,217,1,20837.96,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3565,7638,1149,40745,42010,3,68,1,4375.97,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3566,7638,1149,40745,42010,3,217,1,2811.96,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3567,7638,1149,40745,42010,3,57,2,28025.89,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3568,NULL,1150,40745,42010,2,96,2,314.05,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3569,NULL,1150,40745,42010,2,67,2,65.95,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3570,NULL,1150,40745,42010,2,13,1,380.00,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3571,NULL,1151,40745,42010,2,96,2,516.53,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3572,NULL,1151,40745,42010,2,67,2,108.47,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL);
INSERT INTO `balance_libro_details` VALUES (3573,7638,1152,40745,42010,3,217,1,3095.37,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3574,NULL,1151,40745,42010,2,13,1,625.00,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3575,7638,1152,40745,42010,3,68,1,650.03,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3576,7638,1152,40745,42010,3,57,2,3745.40,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3577,NULL,1153,40745,42010,2,96,2,520.66,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3578,NULL,1153,40745,42010,2,67,2,109.34,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3579,NULL,1153,40745,42010,2,13,1,630.00,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3580,7638,1154,40745,42010,3,217,1,6860.59,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3581,7638,1154,40745,42010,3,68,1,1440.72,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3582,7638,1154,40745,42010,3,217,1,205.82,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3583,7638,1154,40745,42010,3,57,2,8507.13,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3584,NULL,1155,40745,42010,2,96,2,247.93,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3585,NULL,1155,40745,42010,2,67,2,52.07,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3586,NULL,1155,40745,42010,2,13,1,300.00,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3587,7638,1156,40745,42010,3,217,1,6168.72,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3588,7638,1156,40745,42010,3,68,1,1295.43,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3589,7638,1156,40745,42010,3,217,1,185.06,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3590,7638,1156,40745,42010,3,57,2,7649.21,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3591,NULL,1157,40745,42010,2,96,2,400.83,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3592,NULL,1157,40745,42010,2,67,2,84.17,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3593,7638,1158,40745,42010,3,217,1,1213.50,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3594,NULL,1157,40745,42010,2,13,1,485.00,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3595,7638,1158,40745,42010,3,68,1,254.84,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3596,7638,1158,40745,42010,3,57,2,1468.34,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3597,7638,1159,40745,42010,3,217,1,5791.80,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3598,7638,1159,40745,42010,3,68,1,1216.28,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3599,7638,1159,40745,42010,3,217,1,418.17,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3600,7638,1159,40745,42010,3,57,2,7426.25,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3601,7638,1161,40745,42010,3,217,1,22888.00,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3602,NULL,1160,40745,42010,2,96,2,328.93,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3603,7638,1161,40745,42010,3,68,1,4806.48,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3604,7638,1161,40745,42010,3,57,2,27694.48,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3605,NULL,1160,40745,42010,2,67,2,69.07,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3606,NULL,1160,40745,42010,2,13,1,398.00,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3607,NULL,1162,40745,42010,2,96,2,1735.54,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3608,NULL,1162,40745,42010,2,67,2,364.46,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3609,NULL,1162,40745,42010,2,13,1,2100.00,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3610,NULL,1163,40745,42010,2,96,2,330.58,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3611,NULL,1163,40745,42010,2,67,2,69.42,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3612,NULL,1163,40745,42010,2,13,1,400.00,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3613,NULL,1164,40745,42010,2,96,2,429.75,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL);
INSERT INTO `balance_libro_details` VALUES (3614,NULL,1164,40745,42010,2,67,2,90.25,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3615,NULL,1164,40745,42010,2,13,1,520.00,NULL,'2022-11-24 14:20:48','2022-11-24 14:20:48',NULL),(3616,NULL,1165,40745,42010,2,96,2,322.31,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3617,NULL,1165,40745,42010,2,67,2,67.69,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3618,NULL,1165,40745,42010,2,13,1,390.00,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3619,NULL,1166,40745,42010,2,96,2,330.58,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3620,NULL,1166,40745,42010,2,67,2,69.42,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3621,NULL,1166,40745,42010,2,13,1,400.00,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3622,NULL,1167,40745,42010,2,96,2,330.58,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3623,NULL,1167,40745,42010,2,67,2,69.42,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3624,NULL,1167,40745,42010,2,13,1,400.00,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3625,NULL,1168,40745,42010,2,96,2,1016.53,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3626,NULL,1168,40745,42010,2,67,2,213.47,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3627,NULL,1168,40745,42010,2,13,1,1230.00,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3628,NULL,1169,40745,42010,2,96,2,520.66,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3629,NULL,1169,40745,42010,2,67,2,109.34,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3630,NULL,1169,40745,42010,2,13,1,630.00,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3631,NULL,1170,40745,42010,2,96,2,392.56,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3632,NULL,1170,40745,42010,2,67,2,82.44,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3633,NULL,1170,40745,42010,2,13,1,475.00,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3634,NULL,1171,40745,42010,2,96,2,537.19,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3635,NULL,1171,40745,42010,2,67,2,112.81,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3636,NULL,1171,40745,42010,2,13,1,650.00,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3637,NULL,1172,40745,42010,2,96,2,165.29,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3638,NULL,1172,40745,42010,2,67,2,34.71,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3639,NULL,1172,40745,42010,2,13,1,200.00,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3640,NULL,1173,40745,42010,2,96,2,289.26,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3641,NULL,1173,40745,42010,2,67,2,60.74,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3642,NULL,1173,40745,42010,2,13,1,350.00,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3643,NULL,1174,40745,42010,2,96,2,652.89,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3644,NULL,1174,40745,42010,2,67,2,137.11,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3645,NULL,1174,40745,42010,2,13,1,790.00,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3646,NULL,1175,40745,42010,2,96,2,483.47,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3647,NULL,1175,40745,42010,2,67,2,101.53,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3648,NULL,1175,40745,42010,2,13,1,585.00,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3649,NULL,1176,40745,42010,2,96,2,99.17,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3650,NULL,1176,40745,42010,2,67,2,20.83,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3651,NULL,1176,40745,42010,2,13,1,120.00,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3652,NULL,1177,40745,42010,2,96,2,1342.98,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3653,NULL,1177,40745,42010,2,67,2,282.02,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3654,NULL,1177,40745,42010,2,13,1,1625.00,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL);
INSERT INTO `balance_libro_details` VALUES (3655,NULL,1178,40745,42010,2,96,2,1867.77,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3656,NULL,1178,40745,42010,2,67,2,392.23,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3657,NULL,1178,40745,42010,2,13,1,2260.00,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3658,NULL,1179,40745,42010,2,96,2,413.22,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3659,NULL,1179,40745,42010,2,67,2,86.78,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3660,NULL,1179,40745,42010,2,13,1,500.00,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3661,NULL,1180,40745,42010,2,96,2,247.93,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3662,NULL,1180,40745,42010,2,67,2,52.07,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3663,NULL,1180,40745,42010,2,13,1,300.00,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3664,NULL,1181,40745,42010,2,96,2,479.34,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3665,NULL,1181,40745,42010,2,67,2,100.66,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3666,NULL,1181,40745,42010,2,13,1,580.00,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3667,NULL,1182,40745,42010,2,96,2,330.58,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3668,NULL,1182,40745,42010,2,67,2,69.42,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3669,NULL,1182,40745,42010,2,13,1,400.00,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3670,NULL,1183,40745,42010,2,96,2,305.79,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3671,NULL,1183,40745,42010,2,67,2,64.21,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3672,NULL,1183,40745,42010,2,13,1,370.00,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3673,NULL,1184,40745,42010,2,96,2,1214.88,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3674,NULL,1184,40745,42010,2,67,2,255.12,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3675,NULL,1184,40745,42010,2,13,1,1470.00,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3676,NULL,1185,40745,42010,2,96,2,256.20,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3677,NULL,1185,40745,42010,2,67,2,53.80,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3678,NULL,1185,40745,42010,2,13,1,310.00,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3679,NULL,1186,40745,42010,2,96,2,388.43,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3680,NULL,1186,40745,42010,2,67,2,81.57,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3681,NULL,1186,40745,42010,2,13,1,470.00,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3682,NULL,1187,40745,42010,2,96,2,826.45,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3683,NULL,1187,40745,42010,2,67,2,173.55,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3684,NULL,1187,40745,42010,2,13,1,1000.00,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3685,NULL,1188,40745,42010,2,96,2,1132.23,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3686,NULL,1188,40745,42010,2,67,2,237.77,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3687,NULL,1188,40745,42010,2,13,1,1370.00,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3688,NULL,1189,40745,42010,2,96,2,123.97,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3689,NULL,1189,40745,42010,2,67,2,26.03,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3690,NULL,1189,40745,42010,2,13,1,150.00,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3691,NULL,1190,40745,42010,2,96,2,570.25,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3692,NULL,1190,40745,42010,2,67,2,119.75,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3693,NULL,1190,40745,42010,2,13,1,690.00,NULL,'2022-11-24 14:20:49','2022-11-24 14:20:49',NULL),(3694,NULL,1191,40745,42010,2,96,2,214.88,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3695,NULL,1191,40745,42010,2,67,2,45.12,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL);
INSERT INTO `balance_libro_details` VALUES (3696,NULL,1191,40745,42010,2,13,1,260.00,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3697,NULL,1192,40745,42010,2,96,2,1082.64,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3698,NULL,1192,40745,42010,2,67,2,227.36,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3699,NULL,1192,40745,42010,2,13,1,1310.00,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3700,NULL,1193,40745,42010,2,96,2,1326.45,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3701,NULL,1193,40745,42010,2,67,2,278.55,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3702,NULL,1193,40745,42010,2,13,1,1605.00,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3703,NULL,1194,40745,42010,2,96,2,1239.67,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3704,NULL,1194,40745,42010,2,67,2,260.33,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3705,NULL,1194,40745,42010,2,13,1,1500.00,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3706,NULL,1195,40745,42010,2,96,2,826.45,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3707,NULL,1195,40745,42010,2,67,2,173.55,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3708,NULL,1195,40745,42010,2,13,1,1000.00,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3709,NULL,1196,40745,42010,2,96,2,2026.45,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3710,NULL,1196,40745,42010,2,67,2,425.55,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3711,NULL,1196,40745,42010,2,13,1,2452.00,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3712,NULL,1197,40745,42010,2,96,2,347.11,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3713,NULL,1197,40745,42010,2,67,2,72.89,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3714,NULL,1197,40745,42010,2,13,1,420.00,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3715,NULL,1198,40745,42010,2,96,2,1074.38,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3716,NULL,1198,40745,42010,2,67,2,225.62,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3717,NULL,1198,40745,42010,2,13,1,1300.00,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3718,NULL,1199,40745,42010,2,96,2,1293.39,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3719,NULL,1199,40745,42010,2,67,2,271.61,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3720,NULL,1199,40745,42010,2,13,1,1565.00,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3721,NULL,1200,40745,42010,2,96,2,1033.06,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3722,NULL,1200,40745,42010,2,67,2,216.94,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3723,NULL,1200,40745,42010,2,13,1,1250.00,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3724,NULL,1201,40745,42010,2,96,2,74.38,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3725,NULL,1201,40745,42010,2,67,2,15.62,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3726,NULL,1201,40745,42010,2,13,1,90.00,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3727,NULL,1202,40745,42010,2,96,2,243.80,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3728,NULL,1202,40745,42010,2,67,2,51.20,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3729,NULL,1202,40745,42010,2,13,1,295.00,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3730,NULL,1203,40745,42010,2,96,2,330.58,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3731,NULL,1203,40745,42010,2,67,2,69.42,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3732,NULL,1203,40745,42010,2,13,1,400.00,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3733,NULL,1204,40745,42010,2,96,2,1326.45,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3734,NULL,1204,40745,42010,2,67,2,278.55,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3735,NULL,1204,40745,42010,2,13,1,1605.00,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3736,NULL,1205,40745,42010,2,96,2,1099.17,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL);
INSERT INTO `balance_libro_details` VALUES (3737,NULL,1205,40745,42010,2,67,2,230.83,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3738,NULL,1205,40745,42010,2,13,1,1330.00,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3739,NULL,1206,40745,42010,2,96,2,504.13,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3740,NULL,1206,40745,42010,2,67,2,105.87,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3741,NULL,1206,40745,42010,2,13,1,610.00,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3742,NULL,1207,40745,42010,2,96,2,2380.17,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3743,NULL,1207,40745,42010,2,67,2,499.83,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3744,NULL,1207,40745,42010,2,13,1,2880.00,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3745,NULL,1208,40745,42010,2,96,2,466.94,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3746,NULL,1208,40745,42010,2,67,2,98.06,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3747,NULL,1208,40745,42010,2,13,1,565.00,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3748,NULL,1209,40745,42010,2,96,2,1619.83,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3749,NULL,1209,40745,42010,2,67,2,340.17,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3750,NULL,1209,40745,42010,2,13,1,1960.00,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3751,NULL,1210,40745,42010,2,96,2,1776.86,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3752,NULL,1210,40745,42010,2,67,2,373.14,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3753,NULL,1210,40745,42010,2,13,1,2150.00,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3754,NULL,1211,40745,42010,2,96,2,1322.31,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3755,NULL,1211,40745,42010,2,67,2,277.69,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3756,NULL,1211,40745,42010,2,13,1,1600.00,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3757,NULL,1212,40745,42010,2,96,2,1260.33,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3758,NULL,1212,40745,42010,2,67,2,264.67,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3759,NULL,1212,40745,42010,2,13,1,1525.00,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3760,NULL,1213,40745,42010,2,96,2,1285.12,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3761,NULL,1213,40745,42010,2,67,2,269.88,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3762,NULL,1213,40745,42010,2,13,1,1555.00,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3763,NULL,1214,40745,42010,2,96,2,272.73,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3764,NULL,1214,40745,42010,2,67,2,57.27,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3765,NULL,1214,40745,42010,2,13,1,330.00,NULL,'2022-11-24 14:20:50','2022-11-24 14:20:50',NULL),(3766,NULL,1215,40745,42010,2,96,2,1657.02,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3767,NULL,1215,40745,42010,2,67,2,347.98,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3768,NULL,1215,40745,42010,2,13,1,2005.00,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3769,NULL,1216,40745,42010,2,96,2,2285.12,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3770,NULL,1216,40745,42010,2,67,2,479.88,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3771,NULL,1216,40745,42010,2,13,1,2765.00,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3772,NULL,1217,40745,42010,2,96,2,958.68,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3773,NULL,1217,40745,42010,2,67,2,201.32,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3774,NULL,1217,40745,42010,2,13,1,1160.00,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3775,NULL,1218,40745,42010,2,96,2,2698.35,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3776,NULL,1218,40745,42010,2,67,2,566.65,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3777,NULL,1218,40745,42010,2,13,1,3265.00,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL);
INSERT INTO `balance_libro_details` VALUES (3778,NULL,1219,40745,42010,2,96,2,1504.13,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3779,NULL,1219,40745,42010,2,67,2,315.87,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3780,NULL,1219,40745,42010,2,13,1,1820.00,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3781,NULL,1220,40745,42010,2,96,2,413.22,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3782,NULL,1220,40745,42010,2,67,2,86.78,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3783,NULL,1220,40745,42010,2,13,1,500.00,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3784,NULL,1221,40745,42010,2,96,2,1367.77,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3785,NULL,1221,40745,42010,2,67,2,287.23,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3786,NULL,1221,40745,42010,2,13,1,1655.00,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3787,NULL,1222,40745,42010,2,96,2,595.04,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3788,NULL,1222,40745,42010,2,67,2,124.96,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3789,NULL,1222,40745,42010,2,13,1,720.00,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3790,NULL,1223,40745,42010,2,96,2,276.86,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3791,NULL,1223,40745,42010,2,67,2,58.14,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3792,NULL,1223,40745,42010,2,13,1,335.00,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3793,NULL,1224,40745,42010,2,96,2,619.83,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3794,NULL,1224,40745,42010,2,67,2,130.17,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3795,NULL,1224,40745,42010,2,13,1,750.00,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3796,NULL,1225,40745,42010,2,96,2,1289.26,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3797,NULL,1225,40745,42010,2,67,2,270.74,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3798,NULL,1225,40745,42010,2,13,1,1560.00,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3799,NULL,1226,40745,42010,2,96,2,1925.62,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3800,NULL,1226,40745,42010,2,67,2,404.38,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3801,NULL,1226,40745,42010,2,13,1,2330.00,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3802,NULL,1227,40745,42010,2,96,2,900.83,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3803,NULL,1227,40745,42010,2,67,2,189.17,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3804,NULL,1227,40745,42010,2,13,1,1090.00,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3805,NULL,1228,40745,42010,2,96,2,619.83,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3806,NULL,1228,40745,42010,2,67,2,130.17,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3807,NULL,1228,40745,42010,2,13,1,750.00,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3808,NULL,1229,40745,42010,2,96,2,1528.93,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3809,NULL,1229,40745,42010,2,67,2,321.07,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3810,NULL,1229,40745,42010,2,13,1,1850.00,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3811,NULL,1230,40745,42010,2,96,2,570.25,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3812,NULL,1230,40745,42010,2,67,2,119.75,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3813,NULL,1230,40745,42010,2,13,1,690.00,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3814,NULL,1231,40745,42010,2,96,2,5371.90,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3815,NULL,1231,40745,42010,2,67,2,1128.10,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3816,NULL,1231,40745,42010,2,13,1,6500.00,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3817,NULL,1232,40745,42010,2,96,2,371.90,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3818,NULL,1232,40745,42010,2,67,2,78.10,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL);
INSERT INTO `balance_libro_details` VALUES (3819,NULL,1232,40745,42010,2,13,1,450.00,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3820,NULL,1233,40745,42010,2,96,2,247.93,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3821,NULL,1233,40745,42010,2,67,2,52.07,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3822,NULL,1233,40745,42010,2,13,1,300.00,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3823,NULL,1234,40745,42010,2,96,2,351.24,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3824,NULL,1234,40745,42010,2,67,2,73.76,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3825,NULL,1234,40745,42010,2,13,1,425.00,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3826,NULL,1235,40745,42010,2,96,2,644.63,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3827,NULL,1235,40745,42010,2,67,2,135.37,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3828,NULL,1235,40745,42010,2,13,1,780.00,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3829,NULL,1236,40745,42010,2,96,2,363.64,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3830,NULL,1236,40745,42010,2,67,2,76.36,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3831,NULL,1236,40745,42010,2,13,1,440.00,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3832,NULL,1237,40745,42010,2,96,2,1491.74,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3833,NULL,1237,40745,42010,2,67,2,313.26,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3834,NULL,1237,40745,42010,2,13,1,1805.00,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3835,NULL,1238,40745,42010,2,96,2,206.61,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3836,NULL,1238,40745,42010,2,67,2,43.39,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3837,NULL,1238,40745,42010,2,13,1,250.00,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3838,NULL,1239,40745,42010,2,96,2,404.96,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3839,NULL,1239,40745,42010,2,67,2,85.04,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3840,NULL,1239,40745,42010,2,13,1,490.00,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3841,NULL,1240,40745,42010,2,96,2,165.29,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3842,NULL,1240,40745,42010,2,67,2,34.71,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3843,NULL,1240,40745,42010,2,13,1,200.00,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3844,NULL,1241,40745,42010,2,96,2,1504.13,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3845,NULL,1241,40745,42010,2,67,2,315.87,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3846,NULL,1241,40745,42010,2,13,1,1820.00,NULL,'2022-11-24 14:20:51','2022-11-24 14:20:51',NULL),(3847,NULL,1242,40745,42010,2,96,2,2276.86,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3848,NULL,1242,40745,42010,2,67,2,478.14,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3849,NULL,1242,40745,42010,2,13,1,2755.00,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3850,NULL,1243,40745,42010,2,96,2,1297.52,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3851,NULL,1243,40745,42010,2,67,2,272.48,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3852,NULL,1243,40745,42010,2,13,1,1570.00,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3853,NULL,1244,40745,42010,2,96,2,801.65,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3854,NULL,1244,40745,42010,2,67,2,168.35,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3855,NULL,1244,40745,42010,2,13,1,970.00,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3856,NULL,1245,40745,42010,2,96,2,504.13,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3857,NULL,1245,40745,42010,2,67,2,105.87,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3858,NULL,1245,40745,42010,2,13,1,610.00,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3859,NULL,1246,40745,42010,2,96,2,1520.66,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL);
INSERT INTO `balance_libro_details` VALUES (3860,NULL,1246,40745,42010,2,67,2,319.34,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3861,NULL,1246,40745,42010,2,13,1,1840.00,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3862,NULL,1247,40745,42010,2,96,2,842.98,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3863,NULL,1247,40745,42010,2,67,2,177.02,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3864,NULL,1247,40745,42010,2,13,1,1020.00,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3865,NULL,1248,40745,42010,2,96,2,165.29,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3866,NULL,1248,40745,42010,2,67,2,34.71,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3867,NULL,1248,40745,42010,2,13,1,200.00,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3868,NULL,1249,40745,42010,2,96,2,413.22,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3869,NULL,1249,40745,42010,2,67,2,86.78,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3870,NULL,1249,40745,42010,2,13,1,500.00,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3871,NULL,1250,40745,42010,2,96,2,2479.34,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3872,NULL,1250,40745,42010,2,67,2,520.66,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3873,NULL,1250,40745,42010,2,13,1,3000.00,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3874,NULL,1251,40745,42010,2,96,2,1909.09,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3875,NULL,1251,40745,42010,2,67,2,400.91,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3876,NULL,1251,40745,42010,2,13,1,2310.00,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3877,NULL,1252,40745,42010,2,96,2,867.77,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3878,NULL,1252,40745,42010,2,67,2,182.23,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3879,NULL,1252,40745,42010,2,13,1,1050.00,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3880,NULL,1253,40745,42010,2,96,2,545.45,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3881,NULL,1253,40745,42010,2,67,2,114.55,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3882,NULL,1253,40745,42010,2,13,1,660.00,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3883,NULL,1254,40745,42010,2,96,2,2479.34,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3884,NULL,1254,40745,42010,2,67,2,520.66,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3885,NULL,1254,40745,42010,2,13,1,3000.00,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3886,NULL,1255,40745,42010,2,96,2,330.58,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3887,NULL,1255,40745,42010,2,67,2,69.42,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3888,NULL,1255,40745,42010,2,13,1,400.00,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3889,NULL,1256,40745,42010,2,96,2,1462.81,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3890,NULL,1256,40745,42010,2,67,2,307.19,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3891,NULL,1256,40745,42010,2,13,1,1770.00,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3892,NULL,1257,40745,42010,2,96,2,380.17,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3893,NULL,1257,40745,42010,2,67,2,79.83,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3894,NULL,1257,40745,42010,2,13,1,460.00,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3895,NULL,1258,40745,42010,2,96,2,2136.36,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3896,NULL,1258,40745,42010,2,67,2,448.64,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3897,NULL,1258,40745,42010,2,13,1,2585.00,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3898,NULL,1259,40745,42010,2,96,2,950.41,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3899,NULL,1259,40745,42010,2,67,2,199.59,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3900,NULL,1259,40745,42010,2,13,1,1150.00,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL);
INSERT INTO `balance_libro_details` VALUES (3901,NULL,1260,40745,42010,2,96,2,471.07,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3902,NULL,1260,40745,42010,2,67,2,98.93,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3903,NULL,1260,40745,42010,2,13,1,570.00,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3904,NULL,1261,40745,42010,2,96,2,528.93,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3905,NULL,1261,40745,42010,2,67,2,111.07,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3906,NULL,1261,40745,42010,2,13,1,640.00,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3907,NULL,1262,40745,42010,2,96,2,925.62,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3908,NULL,1262,40745,42010,2,67,2,194.38,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3909,NULL,1262,40745,42010,2,13,1,1120.00,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3910,NULL,1263,40745,42010,2,96,2,826.45,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3911,NULL,1263,40745,42010,2,67,2,173.55,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3912,NULL,1263,40745,42010,2,13,1,1000.00,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3913,NULL,1264,40745,42010,2,96,2,595.04,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3914,NULL,1264,40745,42010,2,67,2,124.96,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3915,NULL,1264,40745,42010,2,13,1,720.00,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3916,NULL,1265,40745,42010,2,96,2,123.97,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3917,NULL,1265,40745,42010,2,67,2,26.03,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3918,NULL,1265,40745,42010,2,13,1,150.00,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3919,NULL,1266,40745,42010,2,96,2,2380.17,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3920,NULL,1266,40745,42010,2,67,2,499.83,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3921,NULL,1266,40745,42010,2,13,1,2880.00,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3922,NULL,1267,40745,42010,2,96,2,140.50,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3923,NULL,1267,40745,42010,2,67,2,29.50,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3924,NULL,1267,40745,42010,2,13,1,170.00,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3925,NULL,1268,40745,42010,2,96,2,1752.07,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3926,NULL,1268,40745,42010,2,67,2,367.93,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3927,NULL,1268,40745,42010,2,13,1,2120.00,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3928,NULL,1269,40745,42010,2,96,2,2136.36,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3929,NULL,1269,40745,42010,2,67,2,448.64,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3930,NULL,1269,40745,42010,2,13,1,2585.00,NULL,'2022-11-24 14:20:52','2022-11-24 14:20:52',NULL),(3931,NULL,1270,40745,42010,2,96,2,2479.34,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3932,NULL,1270,40745,42010,2,67,2,520.66,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3933,NULL,1270,40745,42010,2,13,1,3000.00,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3934,NULL,1271,40745,42010,2,96,2,1305.79,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3935,NULL,1271,40745,42010,2,67,2,274.21,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3936,NULL,1271,40745,42010,2,13,1,1580.00,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3937,NULL,1272,40745,42010,2,96,2,826.45,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3938,NULL,1272,40745,42010,2,67,2,173.55,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3939,NULL,1272,40745,42010,2,13,1,1000.00,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3940,NULL,1273,40745,42010,2,96,2,462.81,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3941,NULL,1273,40745,42010,2,67,2,97.19,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL);
INSERT INTO `balance_libro_details` VALUES (3942,NULL,1273,40745,42010,2,13,1,560.00,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3943,NULL,1274,40745,42010,2,96,2,429.75,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3944,NULL,1274,40745,42010,2,67,2,90.25,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3945,NULL,1274,40745,42010,2,13,1,520.00,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3946,NULL,1275,40745,42010,2,96,2,371.90,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3947,NULL,1275,40745,42010,2,67,2,78.10,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3948,NULL,1275,40745,42010,2,13,1,450.00,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3949,NULL,1276,40745,42010,2,96,2,561.98,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3950,NULL,1276,40745,42010,2,67,2,118.02,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3951,NULL,1276,40745,42010,2,13,1,680.00,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3952,NULL,1277,40745,42010,2,96,2,1553.72,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3953,NULL,1277,40745,42010,2,67,2,326.28,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3954,NULL,1277,40745,42010,2,13,1,1880.00,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3955,NULL,1278,40745,42010,2,96,2,578.51,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3956,NULL,1278,40745,42010,2,67,2,121.49,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3957,NULL,1278,40745,42010,2,13,1,700.00,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3958,NULL,1279,40745,42010,2,96,2,561.98,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3959,NULL,1279,40745,42010,2,67,2,118.02,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3960,NULL,1279,40745,42010,2,13,1,680.00,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3961,NULL,1280,40745,42010,2,96,2,148.76,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3962,NULL,1280,40745,42010,2,67,2,31.24,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3963,NULL,1280,40745,42010,2,13,1,180.00,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3964,NULL,1281,40745,42010,2,96,2,495.87,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3965,NULL,1281,40745,42010,2,67,2,104.13,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3966,NULL,1281,40745,42010,2,13,1,600.00,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3967,NULL,1282,40745,42010,2,96,2,148.76,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3968,NULL,1282,40745,42010,2,67,2,31.24,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3969,NULL,1282,40745,42010,2,13,1,180.00,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3970,NULL,1283,40745,42010,2,96,2,314.05,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3971,NULL,1283,40745,42010,2,67,2,65.95,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3972,NULL,1283,40745,42010,2,13,1,380.00,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3973,NULL,1284,40745,42010,2,96,2,826.45,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3974,NULL,1284,40745,42010,2,67,2,173.55,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3975,NULL,1284,40745,42010,2,13,1,1000.00,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3976,NULL,1285,40745,42010,2,96,2,495.87,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3977,NULL,1285,40745,42010,2,67,2,104.13,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3978,NULL,1285,40745,42010,2,13,1,600.00,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3979,NULL,1286,40745,42010,2,96,2,900.83,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3980,NULL,1286,40745,42010,2,67,2,189.17,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3981,NULL,1286,40745,42010,2,13,1,1090.00,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3982,NULL,1287,40745,42010,2,96,2,247.93,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL);
INSERT INTO `balance_libro_details` VALUES (3983,NULL,1287,40745,42010,2,67,2,52.07,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3984,NULL,1287,40745,42010,2,13,1,300.00,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3985,NULL,1288,40745,42010,2,96,2,247.93,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3986,NULL,1288,40745,42010,2,67,2,52.07,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3987,NULL,1288,40745,42010,2,13,1,300.00,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3988,NULL,1289,40745,42010,2,96,2,1685.95,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3989,NULL,1289,40745,42010,2,67,2,354.05,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3990,NULL,1289,40745,42010,2,13,1,2040.00,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3991,NULL,1290,40745,42010,2,96,2,396.69,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3992,NULL,1290,40745,42010,2,67,2,83.31,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3993,NULL,1290,40745,42010,2,13,1,480.00,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3994,NULL,1291,40745,42010,2,96,2,239.67,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3995,NULL,1291,40745,42010,2,67,2,50.33,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3996,NULL,1291,40745,42010,2,13,1,290.00,NULL,'2022-11-24 14:20:53','2022-11-24 14:20:53',NULL),(3997,NULL,1292,40745,42010,2,96,2,570.25,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(3998,NULL,1292,40745,42010,2,67,2,119.75,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(3999,NULL,1292,40745,42010,2,13,1,690.00,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4000,NULL,1293,40745,42010,2,96,2,1115.70,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4001,NULL,1293,40745,42010,2,67,2,234.30,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4002,NULL,1293,40745,42010,2,13,1,1350.00,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4003,NULL,1294,40745,42010,2,96,2,371.90,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4004,NULL,1294,40745,42010,2,67,2,78.10,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4005,NULL,1294,40745,42010,2,13,1,450.00,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4006,NULL,1295,40745,42010,2,96,2,396.69,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4007,NULL,1295,40745,42010,2,67,2,83.31,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4008,NULL,1295,40745,42010,2,13,1,480.00,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4009,NULL,1296,40745,42010,2,96,2,842.98,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4010,NULL,1296,40745,42010,2,67,2,177.02,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4011,NULL,1296,40745,42010,2,13,1,1020.00,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4012,NULL,1297,40745,42010,2,96,2,958.68,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4013,NULL,1297,40745,42010,2,67,2,201.32,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4014,NULL,1297,40745,42010,2,13,1,1160.00,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4015,NULL,1298,40745,42010,2,96,2,214.88,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4016,NULL,1298,40745,42010,2,67,2,45.12,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4017,NULL,1298,40745,42010,2,13,1,260.00,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4018,NULL,1299,40745,42010,2,96,2,768.60,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4019,NULL,1299,40745,42010,2,67,2,161.40,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4020,NULL,1299,40745,42010,2,13,1,930.00,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4021,NULL,1300,40745,42010,2,96,2,181.82,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4022,NULL,1300,40745,42010,2,67,2,38.18,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4023,NULL,1300,40745,42010,2,13,1,220.00,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL);
INSERT INTO `balance_libro_details` VALUES (4024,NULL,1301,40745,42010,2,96,2,1115.70,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4025,NULL,1301,40745,42010,2,67,2,234.30,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4026,NULL,1301,40745,42010,2,13,1,1350.00,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4027,NULL,1302,40745,42010,2,96,2,537.19,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4028,NULL,1302,40745,42010,2,67,2,112.81,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4029,NULL,1302,40745,42010,2,13,1,650.00,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4030,NULL,1303,40745,42010,2,96,2,570.25,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4031,NULL,1303,40745,42010,2,67,2,119.75,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4032,NULL,1303,40745,42010,2,13,1,690.00,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4033,NULL,1304,40745,42010,2,96,2,462.81,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4034,NULL,1304,40745,42010,2,67,2,97.19,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4035,NULL,1304,40745,42010,2,13,1,560.00,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4036,NULL,1305,40745,42010,2,96,2,876.03,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4037,NULL,1305,40745,42010,2,67,2,183.97,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4038,NULL,1305,40745,42010,2,13,1,1060.00,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4039,NULL,1306,40745,42010,2,96,2,512.40,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4040,NULL,1306,40745,42010,2,67,2,107.60,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4041,NULL,1306,40745,42010,2,13,1,620.00,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4042,NULL,1307,40745,42010,2,96,2,409.09,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4043,NULL,1307,40745,42010,2,67,2,85.91,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4044,NULL,1307,40745,42010,2,13,1,495.00,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4045,NULL,1308,40745,42010,2,96,2,2933.88,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4046,NULL,1308,40745,42010,2,67,2,616.12,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4047,NULL,1308,40745,42010,2,13,1,3550.00,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4048,NULL,1309,40745,42010,2,96,2,1128.10,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4049,NULL,1309,40745,42010,2,67,2,236.90,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4050,NULL,1309,40745,42010,2,13,1,1365.00,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4051,NULL,1310,40745,42010,2,96,2,330.58,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4052,NULL,1310,40745,42010,2,67,2,69.42,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4053,NULL,1310,40745,42010,2,13,1,400.00,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4054,NULL,1311,40745,42010,2,96,2,289.26,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4055,NULL,1311,40745,42010,2,67,2,60.74,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4056,NULL,1311,40745,42010,2,13,1,350.00,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4057,NULL,1312,40745,42010,2,96,2,330.58,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4058,NULL,1312,40745,42010,2,67,2,69.42,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4059,NULL,1312,40745,42010,2,13,1,400.00,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4060,NULL,1313,40745,42010,2,96,2,619.83,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4061,NULL,1313,40745,42010,2,67,2,130.17,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4062,NULL,1313,40745,42010,2,13,1,750.00,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4063,NULL,1314,40745,42010,2,96,2,1024.79,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4064,NULL,1314,40745,42010,2,67,2,215.21,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL);
INSERT INTO `balance_libro_details` VALUES (4065,NULL,1314,40745,42010,2,13,1,1240.00,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4066,NULL,1315,40745,42010,2,96,2,537.19,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4067,NULL,1315,40745,42010,2,67,2,112.81,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4068,NULL,1315,40745,42010,2,13,1,650.00,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4069,NULL,1316,40745,42010,2,96,2,826.45,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4070,NULL,1316,40745,42010,2,67,2,173.55,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4071,NULL,1316,40745,42010,2,13,1,1000.00,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4072,NULL,1317,40745,42010,2,96,2,1388.43,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4073,NULL,1317,40745,42010,2,67,2,291.57,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4074,NULL,1317,40745,42010,2,13,1,1680.00,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4075,NULL,1318,40745,42010,2,96,2,3305.79,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4076,NULL,1318,40745,42010,2,67,2,694.21,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4077,NULL,1318,40745,42010,2,13,1,4000.00,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4078,NULL,1319,40745,42010,2,96,2,280.99,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4079,NULL,1319,40745,42010,2,67,2,59.01,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4080,NULL,1319,40745,42010,2,13,1,340.00,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4081,NULL,1320,40745,42010,2,96,2,743.80,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4082,NULL,1320,40745,42010,2,67,2,156.20,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4083,NULL,1320,40745,42010,2,13,1,900.00,NULL,'2022-11-24 14:20:54','2022-11-24 14:20:54',NULL),(4084,NULL,1321,40745,42010,2,96,2,504.13,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4085,NULL,1321,40745,42010,2,67,2,105.87,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4086,NULL,1321,40745,42010,2,13,1,610.00,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4087,NULL,1322,40745,42010,2,96,2,582.64,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4088,NULL,1322,40745,42010,2,67,2,122.36,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4089,NULL,1322,40745,42010,2,13,1,705.00,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4090,NULL,1323,40745,42010,2,96,2,239.67,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4091,NULL,1323,40745,42010,2,67,2,50.33,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4092,NULL,1323,40745,42010,2,13,1,290.00,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4093,NULL,1324,40745,42010,2,96,2,842.98,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4094,NULL,1324,40745,42010,2,67,2,177.02,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4095,NULL,1324,40745,42010,2,13,1,1020.00,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4096,NULL,1325,40745,42010,2,96,2,396.69,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4097,NULL,1325,40745,42010,2,67,2,83.31,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4098,NULL,1325,40745,42010,2,13,1,480.00,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4099,NULL,1326,40745,42010,2,96,2,413.22,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4100,NULL,1326,40745,42010,2,67,2,86.78,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4101,NULL,1326,40745,42010,2,13,1,500.00,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4102,NULL,1327,40745,42010,2,96,2,541.32,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4103,NULL,1327,40745,42010,2,67,2,113.68,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4104,NULL,1327,40745,42010,2,13,1,655.00,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4105,NULL,1328,40745,42010,2,96,2,347.11,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL);
INSERT INTO `balance_libro_details` VALUES (4106,NULL,1328,40745,42010,2,67,2,72.89,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4107,NULL,1328,40745,42010,2,13,1,420.00,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4108,NULL,1329,40745,42010,2,96,2,380.17,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4109,NULL,1329,40745,42010,2,67,2,79.83,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4110,NULL,1329,40745,42010,2,13,1,460.00,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4111,NULL,1330,40745,42010,2,96,2,400.83,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4112,NULL,1330,40745,42010,2,67,2,84.17,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4113,NULL,1330,40745,42010,2,13,1,485.00,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4114,NULL,1331,40745,42010,2,96,2,1652.89,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4115,NULL,1331,40745,42010,2,67,2,347.11,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4116,NULL,1331,40745,42010,2,13,1,2000.00,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4117,NULL,1332,40745,42010,2,96,2,1128.10,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4118,NULL,1332,40745,42010,2,67,2,236.90,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4119,NULL,1332,40745,42010,2,13,1,1365.00,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4120,NULL,1333,40745,42010,2,96,2,1954.55,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4121,NULL,1333,40745,42010,2,67,2,410.45,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4122,NULL,1333,40745,42010,2,13,1,2365.00,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4123,NULL,1334,40745,42010,2,96,2,1479.34,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4124,NULL,1334,40745,42010,2,67,2,310.66,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4125,NULL,1334,40745,42010,2,13,1,1790.00,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4126,NULL,1335,40745,42010,2,96,2,966.94,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4127,NULL,1335,40745,42010,2,67,2,203.06,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4128,NULL,1335,40745,42010,2,13,1,1170.00,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4129,NULL,1336,40745,42010,2,96,2,3231.40,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4130,NULL,1336,40745,42010,2,67,2,678.60,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4131,NULL,1336,40745,42010,2,13,1,3910.00,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4132,NULL,1337,40745,42010,2,96,2,206.61,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4133,NULL,1337,40745,42010,2,67,2,43.39,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4134,NULL,1337,40745,42010,2,13,1,250.00,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4135,NULL,1338,40745,42010,2,96,2,785.12,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4136,NULL,1338,40745,42010,2,67,2,164.88,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4137,NULL,1338,40745,42010,2,13,1,950.00,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4138,NULL,1339,40745,42010,2,96,2,371.90,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4139,NULL,1339,40745,42010,2,67,2,78.10,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4140,NULL,1339,40745,42010,2,13,1,450.00,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4141,NULL,1340,40745,42010,2,96,2,1479.34,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4142,NULL,1340,40745,42010,2,67,2,310.66,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4143,NULL,1340,40745,42010,2,13,1,1790.00,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4144,NULL,1341,40745,42010,2,96,2,471.07,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4145,NULL,1341,40745,42010,2,67,2,98.93,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4146,NULL,1341,40745,42010,2,13,1,570.00,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL);
INSERT INTO `balance_libro_details` VALUES (4147,NULL,1342,40745,42010,2,96,2,148.76,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4148,NULL,1342,40745,42010,2,67,2,31.24,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4149,NULL,1342,40745,42010,2,13,1,180.00,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4150,NULL,1343,40745,42010,2,96,2,247.93,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4151,NULL,1343,40745,42010,2,67,2,52.07,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4152,NULL,1343,40745,42010,2,13,1,300.00,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4153,NULL,1344,40745,42010,2,96,2,1280.99,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4154,NULL,1344,40745,42010,2,67,2,269.01,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4155,NULL,1344,40745,42010,2,13,1,1550.00,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4156,NULL,1345,40745,42010,2,96,2,561.98,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4157,NULL,1345,40745,42010,2,67,2,118.02,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4158,NULL,1345,40745,42010,2,13,1,680.00,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4159,NULL,1346,40745,42010,2,96,2,578.51,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4160,NULL,1346,40745,42010,2,67,2,121.49,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4161,NULL,1346,40745,42010,2,13,1,700.00,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4162,NULL,1347,40745,42010,2,96,2,636.36,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4163,NULL,1347,40745,42010,2,67,2,133.64,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4164,NULL,1347,40745,42010,2,13,1,770.00,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4165,NULL,1348,40745,42010,2,96,2,338.84,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4166,NULL,1348,40745,42010,2,67,2,71.16,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4167,NULL,1348,40745,42010,2,13,1,410.00,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4168,NULL,1349,40745,42010,2,96,2,371.90,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4169,NULL,1349,40745,42010,2,67,2,78.10,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4170,NULL,1349,40745,42010,2,13,1,450.00,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4171,NULL,1350,40745,42010,2,96,2,528.93,NULL,'2022-11-24 14:20:55','2022-11-24 14:20:55',NULL),(4172,NULL,1350,40745,42010,2,67,2,111.07,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4173,NULL,1350,40745,42010,2,13,1,640.00,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4174,NULL,1351,40745,42010,2,96,2,826.45,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4175,NULL,1351,40745,42010,2,67,2,173.55,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4176,NULL,1351,40745,42010,2,13,1,1000.00,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4177,NULL,1352,40745,42010,2,96,2,247.93,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4178,NULL,1352,40745,42010,2,67,2,52.07,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4179,NULL,1352,40745,42010,2,13,1,300.00,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4180,NULL,1353,40745,42010,2,96,2,909.09,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4181,NULL,1353,40745,42010,2,67,2,190.91,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4182,NULL,1353,40745,42010,2,13,1,1100.00,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4183,NULL,1354,40745,42010,2,96,2,256.20,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4184,NULL,1354,40745,42010,2,67,2,53.80,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4185,NULL,1354,40745,42010,2,13,1,310.00,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4186,NULL,1355,40745,42010,2,96,2,355.37,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4187,NULL,1355,40745,42010,2,67,2,74.63,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL);
INSERT INTO `balance_libro_details` VALUES (4188,NULL,1355,40745,42010,2,13,1,430.00,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4189,NULL,1356,40745,42010,2,96,2,1685.95,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4190,NULL,1356,40745,42010,2,67,2,354.05,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4191,NULL,1356,40745,42010,2,13,1,2040.00,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4192,NULL,1357,40745,42010,2,96,2,735.54,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4193,NULL,1357,40745,42010,2,67,2,154.46,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4194,NULL,1357,40745,42010,2,13,1,890.00,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4195,NULL,1358,40745,42010,2,96,2,743.80,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4196,NULL,1358,40745,42010,2,67,2,156.20,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4197,NULL,1358,40745,42010,2,13,1,900.00,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4198,NULL,1359,40745,42010,2,96,2,264.46,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4199,NULL,1359,40745,42010,2,67,2,55.54,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4200,NULL,1359,40745,42010,2,13,1,320.00,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4201,NULL,1360,40745,42010,2,96,2,243.80,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4202,NULL,1360,40745,42010,2,67,2,51.20,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4203,NULL,1360,40745,42010,2,13,1,295.00,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4204,NULL,1361,40745,42010,2,96,2,528.93,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4205,NULL,1361,40745,42010,2,67,2,111.07,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4206,NULL,1361,40745,42010,2,13,1,640.00,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4207,NULL,1362,40745,42010,2,96,2,528.93,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4208,NULL,1362,40745,42010,2,67,2,111.07,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4209,NULL,1362,40745,42010,2,13,1,640.00,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4210,NULL,1363,40745,42010,2,96,2,826.45,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4211,NULL,1363,40745,42010,2,67,2,173.55,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4212,NULL,1363,40745,42010,2,13,1,1000.00,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4213,NULL,1364,40745,42010,2,96,2,958.68,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4214,NULL,1364,40745,42010,2,67,2,201.32,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4215,NULL,1364,40745,42010,2,13,1,1160.00,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4216,NULL,1365,40745,42010,2,96,2,1206.61,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4217,NULL,1365,40745,42010,2,67,2,253.39,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4218,NULL,1365,40745,42010,2,13,1,1460.00,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4219,NULL,1366,40745,42010,2,96,2,2446.28,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4220,NULL,1366,40745,42010,2,67,2,513.72,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4221,NULL,1366,40745,42010,2,13,1,2960.00,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4222,NULL,1367,40745,42010,2,96,2,82.64,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4223,NULL,1367,40745,42010,2,67,2,17.36,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4224,NULL,1367,40745,42010,2,13,1,100.00,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4225,NULL,1368,40745,42010,2,96,2,371.90,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4226,NULL,1368,40745,42010,2,67,2,78.10,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4227,NULL,1368,40745,42010,2,13,1,450.00,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4228,NULL,1369,40745,42010,2,96,2,223.14,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL);
INSERT INTO `balance_libro_details` VALUES (4229,NULL,1369,40745,42010,2,67,2,46.86,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4230,NULL,1369,40745,42010,2,13,1,270.00,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4231,NULL,1370,40745,42010,2,96,2,243.80,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4232,NULL,1370,40745,42010,2,67,2,51.20,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4233,NULL,1370,40745,42010,2,13,1,295.00,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4234,NULL,1371,40745,42010,2,96,2,272.73,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4235,NULL,1371,40745,42010,2,67,2,57.27,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4236,NULL,1371,40745,42010,2,13,1,330.00,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4237,NULL,1372,40745,42010,2,96,2,479.34,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4238,NULL,1372,40745,42010,2,67,2,100.66,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4239,NULL,1372,40745,42010,2,13,1,580.00,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4240,NULL,1373,40745,42010,2,96,2,330.58,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4241,NULL,1373,40745,42010,2,67,2,69.42,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4242,NULL,1373,40745,42010,2,13,1,400.00,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4243,NULL,1374,40745,42010,2,96,2,826.45,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4244,NULL,1374,40745,42010,2,67,2,173.55,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4245,NULL,1374,40745,42010,2,13,1,1000.00,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4246,NULL,1375,40745,42010,2,96,2,157.02,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4247,NULL,1375,40745,42010,2,67,2,32.98,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4248,NULL,1375,40745,42010,2,13,1,190.00,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4249,NULL,1376,40745,42010,2,96,2,1636.36,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4250,NULL,1376,40745,42010,2,67,2,343.64,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4251,NULL,1376,40745,42010,2,13,1,1980.00,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4252,NULL,1377,40745,42010,2,96,2,1842.98,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4253,NULL,1377,40745,42010,2,67,2,387.02,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4254,NULL,1377,40745,42010,2,13,1,2230.00,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4255,NULL,1378,40745,42010,2,96,2,810.74,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4256,NULL,1378,40745,42010,2,67,2,170.26,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4257,NULL,1378,40745,42010,2,13,1,981.00,NULL,'2022-11-24 14:20:56','2022-11-24 14:20:56',NULL),(4258,NULL,1379,40745,42010,2,96,2,925.62,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4259,NULL,1379,40745,42010,2,67,2,194.38,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4260,NULL,1379,40745,42010,2,13,1,1120.00,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4261,NULL,1380,40745,42010,2,96,2,826.45,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4262,NULL,1380,40745,42010,2,67,2,173.55,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4263,NULL,1380,40745,42010,2,13,1,1000.00,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4264,NULL,1381,40745,42010,2,96,2,173.55,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4265,NULL,1381,40745,42010,2,67,2,36.45,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4266,NULL,1381,40745,42010,2,13,1,210.00,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4267,NULL,1382,40745,42010,2,96,2,520.66,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4268,NULL,1382,40745,42010,2,67,2,109.34,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4269,NULL,1382,40745,42010,2,13,1,630.00,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL);
INSERT INTO `balance_libro_details` VALUES (4270,NULL,1383,40745,42010,2,96,2,438.02,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4271,NULL,1383,40745,42010,2,67,2,91.98,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4272,NULL,1383,40745,42010,2,13,1,530.00,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4273,NULL,1384,40745,42010,2,96,2,355.37,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4274,NULL,1384,40745,42010,2,67,2,74.63,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4275,NULL,1384,40745,42010,2,13,1,430.00,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4276,NULL,1385,40745,42010,2,96,2,82.64,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4277,NULL,1385,40745,42010,2,67,2,17.36,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4278,NULL,1385,40745,42010,2,13,1,100.00,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4279,NULL,1386,40745,42010,2,96,2,1107.44,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4280,NULL,1386,40745,42010,2,67,2,232.56,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4281,NULL,1386,40745,42010,2,13,1,1340.00,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4282,NULL,1387,40745,42010,2,96,2,917.36,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4283,NULL,1387,40745,42010,2,67,2,192.64,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4284,NULL,1387,40745,42010,2,13,1,1110.00,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4285,NULL,1388,40745,42010,2,96,2,752.07,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4286,NULL,1388,40745,42010,2,67,2,157.93,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4287,NULL,1388,40745,42010,2,13,1,910.00,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4288,NULL,1389,40745,42010,2,96,2,818.18,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4289,NULL,1389,40745,42010,2,67,2,171.82,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4290,NULL,1389,40745,42010,2,13,1,990.00,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4291,NULL,1390,40745,42010,2,96,2,677.69,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4292,NULL,1390,40745,42010,2,67,2,142.31,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4293,NULL,1390,40745,42010,2,13,1,820.00,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4294,NULL,1391,40745,42010,2,96,2,2198.35,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4295,NULL,1391,40745,42010,2,67,2,461.65,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4296,NULL,1391,40745,42010,2,13,1,2660.00,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4297,NULL,1392,40745,42010,2,96,2,396.69,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4298,NULL,1392,40745,42010,2,67,2,83.31,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4299,NULL,1392,40745,42010,2,13,1,480.00,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4300,NULL,1393,40745,42010,2,96,2,1132.23,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4301,NULL,1393,40745,42010,2,67,2,237.77,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4302,NULL,1393,40745,42010,2,13,1,1370.00,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4303,NULL,1394,40745,42010,2,96,2,2066.12,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4304,NULL,1394,40745,42010,2,67,2,433.88,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4305,NULL,1394,40745,42010,2,13,1,2500.00,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4306,NULL,1395,40745,42010,2,96,2,619.83,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4307,NULL,1395,40745,42010,2,67,2,130.17,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4308,NULL,1395,40745,42010,2,13,1,750.00,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4309,NULL,1396,40745,42010,2,96,2,900.83,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4310,NULL,1396,40745,42010,2,67,2,189.17,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL);
INSERT INTO `balance_libro_details` VALUES (4311,NULL,1396,40745,42010,2,13,1,1090.00,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4312,NULL,1397,40745,42010,2,96,2,1966.94,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4313,NULL,1397,40745,42010,2,67,2,413.06,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4314,NULL,1397,40745,42010,2,13,1,2380.00,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4315,NULL,1398,40745,42010,2,96,2,280.99,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4316,NULL,1398,40745,42010,2,67,2,59.01,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4317,NULL,1398,40745,42010,2,13,1,340.00,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4318,NULL,1399,40745,42010,2,96,2,876.03,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4319,NULL,1399,40745,42010,2,67,2,183.97,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4320,NULL,1399,40745,42010,2,13,1,1060.00,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4321,NULL,1400,40745,42010,2,96,2,483.47,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4322,NULL,1400,40745,42010,2,67,2,101.53,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4323,NULL,1400,40745,42010,2,13,1,585.00,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4324,NULL,1401,40745,42010,2,96,2,190.08,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4325,NULL,1401,40745,42010,2,67,2,39.92,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4326,NULL,1401,40745,42010,2,13,1,230.00,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4327,NULL,1402,40745,42010,2,96,2,719.01,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4328,NULL,1402,40745,42010,2,67,2,150.99,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4329,NULL,1402,40745,42010,2,13,1,870.00,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4330,NULL,1403,40745,42010,2,96,2,247.93,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4331,NULL,1403,40745,42010,2,67,2,52.07,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4332,NULL,1403,40745,42010,2,13,1,300.00,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4333,NULL,1404,40745,42010,2,96,2,669.42,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4334,NULL,1404,40745,42010,2,67,2,140.58,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4335,NULL,1404,40745,42010,2,13,1,810.00,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4336,NULL,1405,40745,42010,2,96,2,735.54,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4337,NULL,1405,40745,42010,2,67,2,154.46,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4338,NULL,1405,40745,42010,2,13,1,890.00,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4339,NULL,1406,40745,42010,2,96,2,518.18,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4340,NULL,1406,40745,42010,2,67,2,108.82,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4341,NULL,1406,40745,42010,2,13,1,627.00,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4342,NULL,1407,40745,42010,2,96,2,1537.19,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4343,NULL,1407,40745,42010,2,67,2,322.81,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4344,NULL,1407,40745,42010,2,13,1,1860.00,NULL,'2022-11-24 14:20:57','2022-11-24 14:20:57',NULL),(4345,NULL,1408,40745,42010,2,96,2,3276.86,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4346,NULL,1408,40745,42010,2,67,2,688.14,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4347,NULL,1408,40745,42010,2,13,1,3965.00,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4348,NULL,1409,40745,42010,2,96,2,677.69,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4349,NULL,1409,40745,42010,2,67,2,142.31,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4350,NULL,1409,40745,42010,2,13,1,820.00,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4351,NULL,1410,40745,42010,2,96,2,1636.36,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL);
INSERT INTO `balance_libro_details` VALUES (4352,NULL,1410,40745,42010,2,67,2,343.64,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4353,NULL,1410,40745,42010,2,13,1,1980.00,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4354,NULL,1411,40745,42010,2,96,2,2466.94,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4355,NULL,1411,40745,42010,2,67,2,518.06,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4356,NULL,1411,40745,42010,2,13,1,2985.00,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4357,NULL,1412,40745,42010,2,96,2,880.17,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4358,NULL,1412,40745,42010,2,67,2,184.83,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4359,NULL,1412,40745,42010,2,13,1,1065.00,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4360,NULL,1413,40745,42010,2,96,2,826.45,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4361,NULL,1413,40745,42010,2,67,2,173.55,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4362,NULL,1413,40745,42010,2,13,1,1000.00,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4363,NULL,1414,40745,42010,2,96,2,1128.10,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4364,NULL,1414,40745,42010,2,67,2,236.90,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4365,NULL,1414,40745,42010,2,13,1,1365.00,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4366,NULL,1415,40745,42010,2,96,2,219.01,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4367,NULL,1415,40745,42010,2,67,2,45.99,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4368,NULL,1415,40745,42010,2,13,1,265.00,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4369,NULL,1416,40745,42010,2,96,2,1219.01,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4370,NULL,1416,40745,42010,2,67,2,255.99,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4371,NULL,1416,40745,42010,2,13,1,1475.00,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4372,NULL,1417,40745,42010,2,96,2,512.40,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4373,NULL,1417,40745,42010,2,67,2,107.60,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4374,NULL,1417,40745,42010,2,13,1,620.00,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4375,NULL,1418,40745,42010,2,96,2,706.61,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4376,NULL,1418,40745,42010,2,67,2,148.39,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4377,NULL,1418,40745,42010,2,13,1,855.00,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4378,NULL,1419,40745,42010,2,96,2,247.93,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4379,NULL,1419,40745,42010,2,67,2,52.07,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4380,NULL,1419,40745,42010,2,13,1,300.00,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4381,NULL,1420,40745,42010,2,96,2,330.58,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4382,NULL,1420,40745,42010,2,67,2,69.42,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4383,NULL,1420,40745,42010,2,13,1,400.00,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4384,NULL,1421,40745,42010,2,96,2,652.89,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4385,NULL,1421,40745,42010,2,67,2,137.11,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4386,NULL,1421,40745,42010,2,13,1,790.00,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4387,NULL,1422,40745,42010,2,96,2,2975.21,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4388,NULL,1422,40745,42010,2,67,2,624.79,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4389,NULL,1422,40745,42010,2,13,1,3600.00,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4390,NULL,1423,40745,42010,2,96,2,859.50,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4391,NULL,1423,40745,42010,2,67,2,180.50,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4392,NULL,1423,40745,42010,2,13,1,1040.00,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL);
INSERT INTO `balance_libro_details` VALUES (4393,NULL,1424,40745,42010,2,96,2,264.46,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4394,NULL,1424,40745,42010,2,67,2,55.54,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4395,NULL,1424,40745,42010,2,13,1,320.00,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4396,NULL,1425,40745,42010,2,96,2,413.22,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4397,NULL,1425,40745,42010,2,67,2,86.78,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4398,NULL,1425,40745,42010,2,13,1,500.00,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4399,NULL,1426,40745,42010,2,96,2,595.04,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4400,NULL,1426,40745,42010,2,67,2,124.96,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4401,NULL,1426,40745,42010,2,13,1,720.00,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4402,NULL,1427,40745,42010,2,96,2,10.08,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4403,NULL,1427,40745,42010,2,67,2,2.12,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4404,NULL,1427,40745,42010,2,13,1,12.20,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4405,NULL,1428,40745,42010,2,96,2,789.26,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4406,NULL,1428,40745,42010,2,67,2,165.74,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4407,NULL,1428,40745,42010,2,13,1,955.00,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4408,NULL,1429,40745,42010,2,96,2,256.20,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4409,NULL,1429,40745,42010,2,67,2,53.80,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4410,NULL,1429,40745,42010,2,13,1,310.00,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4411,NULL,1430,40745,42010,2,96,2,661.16,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4412,NULL,1430,40745,42010,2,67,2,138.84,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4413,NULL,1430,40745,42010,2,13,1,800.00,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4414,NULL,1431,40745,42010,2,96,2,99.17,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4415,NULL,1431,40745,42010,2,67,2,20.83,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4416,NULL,1431,40745,42010,2,13,1,120.00,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4417,NULL,1432,40745,42010,2,96,2,82.64,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4418,NULL,1432,40745,42010,2,67,2,17.36,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4419,NULL,1432,40745,42010,2,13,1,100.00,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4420,NULL,1433,40745,42010,2,96,2,305.79,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4421,NULL,1433,40745,42010,2,67,2,64.21,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4422,NULL,1433,40745,42010,2,13,1,370.00,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4423,NULL,1434,40745,42010,2,96,2,665.29,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4424,NULL,1434,40745,42010,2,67,2,139.71,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4425,NULL,1434,40745,42010,2,13,1,805.00,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4426,NULL,1435,40745,42010,2,96,2,214.88,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4427,NULL,1435,40745,42010,2,67,2,45.12,NULL,'2022-11-24 14:20:58','2022-11-24 14:20:58',NULL),(4428,NULL,1435,40745,42010,2,13,1,260.00,NULL,'2