-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db27-30473521-5
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-09-15 14:37:12','Actividad Generica 1','000001',NULL),(2,NULL,'2022-09-15 14:37:12','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL),('2023-1','2023-01',2023,1,'2023-01-01','2023-01-31',1202.9790,NULL,NULL,NULL),('2023-2','2023-02',2023,2,'2023-02-01','2023-02-28',1282.7091,NULL,NULL,NULL),('2023-3','2023-03',2023,3,'2023-03-01','2023-03-31',1381.1601,NULL,NULL,NULL),('2023-4','2023-04',2023,4,'2023-04-01','2023-04-30',1497.2147,NULL,NULL,NULL),('2023-5','2023-05',2023,5,'2023-05-01','2023-05-31',1613.5895,NULL,NULL,NULL),('2023-6','2023-06',2023,6,'2023-06-01','2023-06-30',1709.6115,NULL,NULL,NULL),('2023-7','2023-07',2023,7,'2023-07-01','2023-07-31',1818.0838,NULL,NULL,NULL),('2023-8','2023-08',2023,8,'2023-08-01','2023-08-31',2044.2832,NULL,NULL,NULL),('2023-9','2023-09',2023,9,'2023-09-01','2023-09-30',2304.9242,NULL,NULL,NULL),('2023-10','2023-10',2023,10,'2023-10-01','2023-10-31',2496.2730,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_recibidas`
--

DROP TABLE IF EXISTS `api_recibidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_recibidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` json NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_recibidas_person_id_foreign` (`person_id`),
  CONSTRAINT `api_recibidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_recibidas`
--

LOCK TABLES `api_recibidas` WRITE;
/*!40000 ALTER TABLE `api_recibidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_recibidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
INSERT INTO `back_up_charlas_details` VALUES (1,'COORDINAMOS UNA REUNIÓN ´PARA EL DIA 15/10 HORARIO A CONFIRMAR- MOTIVO: CONSTITUCION SRL',40721,'2022-10-05'),(2,'COORDINAMOS UNA REUNIÓN ´PARA EL DIA 15/10 HORARIO A CONFIRMAR- MOTIVO: CONSTITUCION SRL',40721,'2022-10-05'),(3,'COORDINAMOS UNA REUNIÓN ´PARA EL DIA 15/10 HORARIO A CONFIRMAR- MOTIVO: CONSTITUCION SRL',40721,'2022-10-05'),(4,'COORDINAMOS UNA REUNIÓN ´PARA EL DIA 15/10 HORARIO A CONFIRMAR- MOTIVO: CONSTITUCION SRL',40721,'2023-01-24');
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
INSERT INTO `back_up_claves_details` VALUES (1,'afip','Royalexis2022',NULL,1,40720,'2022-09-17'),(2,'AFIP','Carlos2022',NULL,1,40721,'2022-10-05'),(3,'ARBA','Carlos2022','REG SIMPLIFICADO',3,40721,'2022-10-05'),(4,'AFIP','Carlos2022',NULL,1,40721,'2022-10-05'),(5,'ARBA','Carlos2022','REG SIMPLIFICADO',3,40721,'2022-10-05'),(6,'AFIP','Carlos2022',NULL,1,40721,'2022-10-05'),(7,'ARBA','Carlos2022','REG SIMPLIFICADO',3,40721,'2022-10-05'),(8,NULL,'231884',NULL,3,40745,'2022-11-08'),(9,NULL,'Mariani2022',NULL,1,40745,'2022-11-08'),(10,'MUNICIPALIDAD','Victoria2022','SEG E HIG',41,40745,'2022-11-08'),(11,'AFIP','Misteriosa09',NULL,1,40735,'2022-11-28'),(12,'ARBA','Misteriosa09',NULL,3,40735,'2022-11-28'),(13,'AFIP','Carlos2022',NULL,1,40721,'2023-01-24'),(14,'ARBA','Carlos2022','REG SIMPLIFICADO',3,40721,'2023-01-24'),(15,'afip','Royalexis2022',NULL,1,40720,'2023-03-28');
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'mayoristasixelaintima@gmail.com',NULL,'',1,40720,'2022-09-17'),(2,'alicia_acunia@yahoo.com.ar','11 3342-4733','',1,40745,'2022-11-08'),(3,'estudiocontablems02@gmail.com','1135605529',NULL,1,40719,'2022-11-10'),(4,'servicecas1973@hotmail.com','113274-8087','',1,40735,'2022-11-28'),(5,'mayoristasixelaintima@gmail.com',NULL,'',1,40720,'2023-03-28');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=688 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,7847,40721,4586,2,1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',80000.00,NULL,NULL,1,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(2,7847,40721,4586,2,2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',40000.00,NULL,NULL,1,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(3,7847,40721,4586,2,3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',80000.00,NULL,NULL,1,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(4,7847,40721,4586,2,4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',5000.00,NULL,NULL,1,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(5,7847,40721,4586,2,5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',76000.00,NULL,NULL,1,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(6,7847,40721,4586,2,6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',78900.00,NULL,NULL,1,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(7,7847,40721,4586,2,7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',100000.00,NULL,NULL,1,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(8,7847,40721,4586,2,8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',100000.00,NULL,NULL,1,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(9,7847,40721,4586,3,9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',2914.89,NULL,NULL,1,'2022-10-05 11:08:06','2022-10-05 11:08:06',NULL),(10,7847,40721,4586,3,10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',11165.00,NULL,NULL,1,'2022-10-05 11:08:06','2022-10-05 11:08:06',NULL),(11,7847,40721,4586,3,11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',718.62,NULL,NULL,1,'2022-10-05 11:08:06','2022-10-05 11:08:06',NULL),(12,7847,40721,4586,3,12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',49500.00,NULL,NULL,1,'2022-10-05 11:08:06','2022-10-05 11:08:06',NULL),(13,7847,40721,4585,2,13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',1275.92,NULL,NULL,1,'2022-10-05 11:44:50','2022-10-05 11:44:50',NULL),(14,7847,40721,4585,2,14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-13','2022-08-13',718.62,NULL,NULL,1,'2022-10-05 11:44:50','2022-10-05 11:44:50',NULL),(15,7847,40721,4585,2,15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',2254.00,NULL,NULL,1,'2022-10-05 11:44:50','2022-10-05 11:44:50',NULL),(16,7847,40721,4585,2,16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',80000.00,NULL,NULL,1,'2022-10-05 11:45:17','2022-10-05 11:45:17',NULL),(17,7847,40721,4585,2,17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',90000.00,NULL,NULL,1,'2022-10-05 11:45:17','2022-10-05 11:45:17',NULL),(18,7847,40721,4585,2,18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',60000.00,NULL,NULL,1,'2022-10-05 11:45:17','2022-10-05 11:45:17',NULL),(19,7847,40721,4585,2,19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',100000.00,NULL,NULL,1,'2022-10-05 11:45:17','2022-10-05 11:45:17',NULL),(20,7847,40721,4585,3,20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',1275.92,NULL,NULL,1,'2022-10-05 11:46:32','2022-10-05 11:46:32',NULL),(21,7847,40721,4585,3,21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-13','2022-08-13',718.62,NULL,NULL,1,'2022-10-05 11:46:32','2022-10-05 11:46:32',NULL),(22,7847,40721,4585,3,22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',2254.00,NULL,NULL,1,'2022-10-05 11:46:32','2022-10-05 11:46:32',NULL),(23,7847,40721,4585,2,23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',70000.00,NULL,NULL,1,'2022-10-05 11:49:00','2022-10-05 11:49:00',NULL),(24,7847,40736,6100,2,24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',15613.00,NULL,NULL,1,'2022-10-30 07:14:02','2022-11-23 12:22:26','2022-11-23 12:22:26'),(25,7847,40736,6100,2,25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',5600.00,NULL,NULL,1,'2022-10-30 07:14:02','2022-11-23 12:22:06','2022-11-23 12:22:06');
INSERT INTO `balance_libro` VALUES (26,7847,40736,6100,2,26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',3150.00,NULL,NULL,1,'2022-10-30 07:14:02','2022-11-23 12:22:23','2022-11-23 12:22:23'),(27,7847,40736,6100,2,27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',20081.00,NULL,NULL,1,'2022-10-30 07:14:02','2022-11-23 12:22:19','2022-11-23 12:22:19'),(28,7847,40736,6100,2,28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',3000.00,NULL,NULL,1,'2022-10-30 07:14:02','2022-11-23 12:22:14','2022-11-23 12:22:14'),(29,7847,40736,6100,2,29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',5700.00,NULL,NULL,1,'2022-10-30 07:14:02','2022-11-23 12:22:10','2022-11-23 12:22:10'),(30,7847,40736,6100,2,30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',4750.00,NULL,NULL,1,'2022-10-30 07:14:02','2022-11-23 12:22:30','2022-11-23 12:22:30'),(31,7847,40736,6100,2,31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',4000.00,NULL,NULL,1,'2022-10-30 07:14:02','2022-11-23 12:22:34','2022-11-23 12:22:34'),(32,7847,40736,6100,2,32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',7150.00,NULL,NULL,1,'2022-10-30 07:14:02','2022-11-23 12:22:38','2022-11-23 12:22:38'),(33,7847,40736,6100,2,33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',12011.00,NULL,NULL,1,'2022-10-30 07:14:02','2022-11-23 12:22:41','2022-11-23 12:22:41'),(34,7847,40736,6100,2,34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',2000.00,NULL,NULL,1,'2022-10-30 07:14:14','2022-11-23 12:22:47','2022-11-23 12:22:47'),(35,7847,40736,6100,2,35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',2600.00,NULL,NULL,1,'2022-10-30 07:14:14','2022-11-23 12:21:58','2022-11-23 12:21:58'),(36,7847,40736,6100,2,36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',6160.00,NULL,NULL,1,'2022-10-30 07:14:14','2022-11-23 12:21:55','2022-11-23 12:21:55'),(37,7847,40736,6100,2,37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',4670.00,NULL,NULL,1,'2022-10-30 07:14:14','2022-11-23 12:21:51','2022-11-23 12:21:51'),(38,7847,40736,6100,2,38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',2620.00,NULL,NULL,1,'2022-10-30 07:14:14','2022-11-23 12:21:47','2022-11-23 12:21:47'),(39,7847,40736,6100,2,39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',6080.00,NULL,NULL,1,'2022-10-30 07:14:14','2022-11-23 12:21:43','2022-11-23 12:21:43'),(40,7847,40736,6100,2,40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',3560.00,NULL,NULL,1,'2022-10-30 07:14:14','2022-11-23 12:21:36','2022-11-23 12:21:36'),(41,7847,40736,6100,2,41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',21000.00,NULL,NULL,1,'2022-10-30 07:14:14','2022-11-23 12:21:33','2022-11-23 12:21:33'),(42,7847,40736,6100,2,42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',4000.00,NULL,NULL,1,'2022-10-30 07:14:14','2022-11-23 12:21:29','2022-11-23 12:21:29'),(43,7847,40736,6100,2,43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',1790.00,NULL,NULL,1,'2022-10-30 07:14:14','2022-11-23 12:21:25','2022-11-23 12:21:25'),(44,7847,40736,6100,2,44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',4200.00,NULL,NULL,1,'2022-10-30 07:14:14','2022-11-23 12:21:21','2022-11-23 12:21:21'),(45,7847,40736,6100,2,45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',4241.00,NULL,NULL,1,'2022-10-30 07:14:14','2022-11-23 12:21:17','2022-11-23 12:21:17'),(46,7847,40736,6100,2,46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',4890.00,NULL,NULL,1,'2022-10-30 07:14:14','2022-11-23 12:21:13','2022-11-23 12:21:13'),(47,7847,40736,6100,2,47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',950.00,NULL,NULL,1,'2022-10-30 07:14:14','2022-11-23 12:21:09','2022-11-23 12:21:09'),(48,7847,40736,6100,2,48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',14310.00,NULL,NULL,1,'2022-10-30 07:14:14','2022-11-23 12:21:06','2022-11-23 12:21:06');
INSERT INTO `balance_libro` VALUES (49,7847,40736,6100,2,49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',900.00,NULL,NULL,1,'2022-10-30 07:14:14','2022-11-23 12:21:02','2022-11-23 12:21:02'),(50,7847,40736,6100,2,50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',3600.00,NULL,NULL,1,'2022-10-30 07:14:14','2022-11-23 12:20:58','2022-11-23 12:20:58'),(51,7847,40736,6100,2,51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',19010.00,NULL,NULL,1,'2022-10-30 07:14:14','2022-11-23 12:20:54','2022-11-23 12:20:54'),(52,7847,40736,6100,2,52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',20900.00,NULL,NULL,1,'2022-10-30 07:14:14','2022-11-23 12:20:49','2022-11-23 12:20:49'),(53,7847,40736,6100,2,53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',7000.00,NULL,NULL,1,'2022-10-30 07:14:14','2022-11-23 12:20:13','2022-11-23 12:20:13'),(54,7847,40736,6100,2,54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',11280.00,NULL,NULL,1,'2022-10-30 07:14:14','2022-11-23 12:19:53','2022-11-23 12:19:53'),(55,7847,40736,6100,2,55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',3750.00,NULL,NULL,1,'2022-10-30 07:14:14','2022-11-23 12:19:30','2022-11-23 12:19:30'),(56,7847,40736,6100,2,56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',8130.00,NULL,NULL,1,'2022-10-30 07:14:14','2022-11-23 12:19:48','2022-11-23 12:19:48'),(57,7847,40736,6100,2,57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',6365.00,NULL,NULL,1,'2022-10-30 07:14:14','2022-11-23 12:19:43','2022-11-23 12:19:43'),(58,7847,40721,3030,2,58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',70000.00,NULL,NULL,1,'2022-11-08 12:30:54','2022-11-08 12:30:54',NULL),(59,7847,40721,3030,2,59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',80000.00,NULL,NULL,1,'2022-11-08 12:30:54','2022-11-08 12:30:54',NULL),(60,7847,40721,3030,2,60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',85000.00,NULL,NULL,1,'2022-11-08 12:30:54','2022-11-08 12:30:54',NULL),(61,7847,40721,3030,3,61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1914.00,NULL,NULL,1,'2022-11-08 12:31:34','2022-11-08 12:31:34',NULL),(62,7847,40721,3030,3,62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',2401.34,NULL,NULL,1,'2022-11-08 12:31:34','2022-11-08 12:31:34',NULL),(63,7847,40721,3030,3,63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',718.62,NULL,NULL,1,'2022-11-08 12:31:34','2022-11-08 12:31:34',NULL),(64,7847,40721,3030,3,64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',2999.00,NULL,NULL,1,'2022-11-08 12:31:34','2022-11-08 12:31:34',NULL),(65,7847,40721,3030,3,65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',39999.00,NULL,NULL,1,'2022-11-08 12:31:34','2022-11-08 12:31:34',NULL),(66,7847,40721,3030,3,66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',43515.00,NULL,NULL,1,'2022-11-08 12:31:35','2022-11-08 12:31:35',NULL),(67,7847,40745,7820,2,67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',518.00,NULL,NULL,1,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(68,7847,40745,7820,2,68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',664.00,NULL,NULL,1,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(69,7847,40745,7820,2,69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',1390.00,NULL,NULL,1,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(70,7847,40745,7820,2,70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',710.00,NULL,NULL,1,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(71,7847,40745,7820,2,71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',580.00,NULL,NULL,1,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(72,7847,40745,7820,2,72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',745.00,NULL,NULL,1,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL);
INSERT INTO `balance_libro` VALUES (73,7847,40745,7820,2,73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',669.00,NULL,NULL,1,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(74,7847,40745,7820,2,74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',382.00,NULL,NULL,1,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(75,7847,40745,7820,2,75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',2796.00,NULL,NULL,1,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(76,7847,40745,7820,2,76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',1080.00,NULL,NULL,1,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(77,7847,40745,7820,2,77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',960.00,NULL,NULL,1,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(78,7847,40745,7820,2,78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',1510.00,NULL,NULL,1,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(79,7847,40745,7820,2,79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',406.00,NULL,NULL,1,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(80,7847,40745,7820,2,80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',820.00,NULL,NULL,1,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(81,7847,40745,7820,2,81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',700.00,NULL,NULL,1,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(82,7847,40745,7820,2,82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',990.00,NULL,NULL,1,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(83,7847,40745,7820,2,83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',860.00,NULL,NULL,1,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(84,7847,40745,7820,2,84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1400.00,NULL,NULL,1,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(85,7847,40745,7820,2,85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',580.00,NULL,NULL,1,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(86,7847,40745,7820,2,86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',3490.00,NULL,NULL,1,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(87,7847,40745,7820,2,87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',600.00,NULL,NULL,1,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(88,7847,40745,7820,2,88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',774.00,NULL,NULL,1,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(89,7847,40745,7820,2,89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',930.00,NULL,NULL,1,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(90,7847,40745,7820,2,90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',610.00,NULL,NULL,1,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(91,7847,40745,7820,2,91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1380.00,NULL,NULL,1,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(92,7847,40745,7820,2,92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',790.00,NULL,NULL,1,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(93,7847,40745,7820,2,93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1070.00,NULL,NULL,1,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(94,7847,40745,7820,2,94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',370.00,NULL,NULL,1,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(95,7847,40745,7820,2,95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',485.00,NULL,NULL,1,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(96,7847,40745,7820,2,96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',920.00,NULL,NULL,1,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(97,7847,40745,7820,2,97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',4100.00,NULL,NULL,1,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL);
INSERT INTO `balance_libro` VALUES (98,7847,40745,7820,2,98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',240.00,NULL,NULL,1,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(99,7847,40745,7820,2,99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',380.00,NULL,NULL,1,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(100,7847,40745,7820,2,100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1750.00,NULL,NULL,1,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(101,7847,40745,7820,2,101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',459.00,NULL,NULL,1,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(102,7847,40745,7820,2,102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',881.00,NULL,NULL,1,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(103,7847,40745,7820,2,103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',650.00,NULL,NULL,1,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(104,7847,40745,7820,2,104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',473.00,NULL,NULL,1,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(105,7847,40745,7820,2,105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1574.00,NULL,NULL,1,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(106,7847,40745,7820,2,106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',960.00,NULL,NULL,1,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(107,7847,40745,7820,2,107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',833.00,NULL,NULL,1,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(108,7847,40745,7820,2,108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',500.00,NULL,NULL,1,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(109,7847,40745,7820,2,109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',2820.00,NULL,NULL,1,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(110,7847,40745,7820,2,110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',650.00,NULL,NULL,1,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(111,7847,40745,7820,2,111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',378.00,NULL,NULL,1,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(112,7847,40745,7820,2,112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1420.00,NULL,NULL,1,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(113,7847,40745,7820,2,113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',950.00,NULL,NULL,1,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(114,7847,40745,7820,2,114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',866.00,NULL,NULL,1,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(115,7847,40745,7820,2,115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',990.00,NULL,NULL,1,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(116,7847,40745,7820,2,116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1300.00,NULL,NULL,1,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(117,7847,40745,7820,2,117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',960.00,NULL,NULL,1,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(118,7847,40745,7820,2,118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',710.00,NULL,NULL,1,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(119,7847,40745,7820,2,119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',3050.00,NULL,NULL,1,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(120,7847,40745,7820,2,120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',260.00,NULL,NULL,1,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(121,7847,40745,7820,2,121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',800.00,NULL,NULL,1,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(122,7847,40745,7820,2,122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',500.00,NULL,NULL,1,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL);
INSERT INTO `balance_libro` VALUES (123,7847,40745,7820,2,123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',710.00,NULL,NULL,1,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(124,7847,40745,7820,2,124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',980.00,NULL,NULL,1,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(125,7847,40745,7820,2,125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',650.00,NULL,NULL,1,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(126,7847,40745,7820,2,126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1100.00,NULL,NULL,1,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(127,7847,40745,7820,2,127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',3810.00,NULL,NULL,1,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(128,7847,40745,7820,2,128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',460.00,NULL,NULL,1,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(129,7847,40745,7820,2,129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',770.00,NULL,NULL,1,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(130,7847,40745,7820,2,130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',910.00,NULL,NULL,1,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(131,7847,40745,7820,2,131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',5580.00,NULL,NULL,1,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(132,7847,40745,7820,2,132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',440.00,NULL,NULL,1,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(133,7847,40745,7820,2,133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',800.00,NULL,NULL,1,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(134,7847,40745,7820,2,134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',960.00,NULL,NULL,1,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(135,7847,40745,7820,2,135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',1113.00,NULL,NULL,1,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(136,7847,40745,7820,2,136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',2700.00,NULL,NULL,1,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(137,7847,40745,7820,2,137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',500.00,NULL,NULL,1,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(138,7847,40745,7820,2,138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1540.00,NULL,NULL,1,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(139,7847,40745,7820,2,139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',893.00,NULL,NULL,1,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(140,7847,40745,7820,2,140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1910.00,NULL,NULL,1,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(141,7847,40745,7820,2,141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',3560.00,NULL,NULL,1,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(142,7847,40745,7820,2,142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',480.00,NULL,NULL,1,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(143,7847,40745,7820,2,143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',700.00,NULL,NULL,1,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(144,7847,40745,7820,2,144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1500.00,NULL,NULL,1,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(145,7847,40745,7820,2,145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',690.00,NULL,NULL,1,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(146,7847,40745,7820,2,146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1380.00,NULL,NULL,1,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(147,7847,40745,7820,2,147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',570.00,NULL,NULL,1,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL);
INSERT INTO `balance_libro` VALUES (148,7847,40745,7820,2,148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',835.00,NULL,NULL,1,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(149,7847,40745,7820,2,149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1900.00,NULL,NULL,1,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(150,7847,40745,7820,2,150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',2760.00,NULL,NULL,1,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(151,7847,40745,7820,2,151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1800.00,NULL,NULL,1,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(152,7847,40745,7820,2,152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1100.00,NULL,NULL,1,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(153,7847,40745,7820,2,153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1540.00,NULL,NULL,1,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(154,7847,40745,7820,2,154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',810.00,NULL,NULL,1,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(155,7847,40745,7820,2,155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1000.00,NULL,NULL,1,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(156,7847,40745,7820,2,156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',650.00,NULL,NULL,1,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(157,7847,40745,7820,2,157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1736.00,NULL,NULL,1,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(158,7847,40745,7820,2,158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',449.00,NULL,NULL,1,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(159,7847,40745,7820,2,159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1300.00,NULL,NULL,1,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(160,7847,40745,7820,2,160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',940.00,NULL,NULL,1,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(161,7847,40745,7820,2,161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',716.00,NULL,NULL,1,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(162,7847,40745,7820,2,162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',399.00,NULL,NULL,1,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(163,7847,40745,7820,2,163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',1500.00,NULL,NULL,1,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(164,7847,40745,7820,2,164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',700.00,NULL,NULL,1,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(165,7847,40745,7820,2,165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',882.00,NULL,NULL,1,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(166,7847,40745,7820,2,166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',1940.00,NULL,NULL,1,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(167,7847,40745,7820,2,167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',2050.00,NULL,NULL,1,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(168,7847,40745,7820,2,168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',1100.00,NULL,NULL,1,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(169,7847,40745,7820,2,169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',805.00,NULL,NULL,1,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(170,7847,40745,7820,2,170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',3450.00,NULL,NULL,1,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(171,7847,40745,7820,2,171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',1000.00,NULL,NULL,1,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(172,7847,40745,7820,2,172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',960.00,NULL,NULL,1,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL);
INSERT INTO `balance_libro` VALUES (173,7847,40745,7820,2,173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',520.00,NULL,NULL,1,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(174,7847,40745,7820,2,174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',1280.00,NULL,NULL,1,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(175,7847,40745,7820,2,175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',775.00,NULL,NULL,1,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(176,7847,40745,7820,2,176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',932.00,NULL,NULL,1,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(177,7847,40745,7820,2,177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',2100.00,NULL,NULL,1,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(178,7847,40745,7820,2,178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',500.00,NULL,NULL,1,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(179,7847,40745,7820,2,179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',970.00,NULL,NULL,1,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(180,7847,40745,7820,2,180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',600.00,NULL,NULL,1,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(181,7847,40745,7820,2,181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',2280.00,NULL,NULL,1,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(182,7847,40745,7820,2,182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1600.00,NULL,NULL,1,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(183,7847,40745,7820,2,183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1450.00,NULL,NULL,1,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(184,7847,40745,7820,2,184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',810.00,NULL,NULL,1,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(185,7847,40745,7820,2,185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',740.00,NULL,NULL,1,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(186,7847,40745,7820,2,186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',995.00,NULL,NULL,1,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(187,7847,40745,7820,2,187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',730.00,NULL,NULL,1,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(188,7847,40745,7820,2,188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',1800.00,NULL,NULL,1,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(189,7847,40745,7820,2,189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',4910.00,NULL,NULL,1,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(190,7847,40745,7820,2,190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',875.00,NULL,NULL,1,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(191,7847,40745,7820,2,191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',3000.00,NULL,NULL,1,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(192,7847,40745,7820,2,192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',450.00,NULL,NULL,1,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(193,7847,40745,7820,2,193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',910.00,NULL,NULL,1,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(194,7847,40745,7820,2,194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1700.00,NULL,NULL,1,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(195,7847,40745,7820,2,195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',620.00,NULL,NULL,1,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(196,7847,40745,7820,2,196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',370.00,NULL,NULL,1,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(197,7847,40745,7820,2,197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',900.00,NULL,NULL,1,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL);
INSERT INTO `balance_libro` VALUES (198,7847,40745,7820,2,198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',300.00,NULL,NULL,1,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(199,7847,40745,7820,2,199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1720.00,NULL,NULL,1,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(200,7847,40745,7820,2,200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',900.00,NULL,NULL,1,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(201,7847,40745,7820,2,201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2500.00,NULL,NULL,1,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(202,7847,40745,7820,2,202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1830.00,NULL,NULL,1,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(203,7847,40745,7820,2,203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1000.00,NULL,NULL,1,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(204,7847,40745,7820,2,204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',870.00,NULL,NULL,1,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(205,7847,40745,7820,2,205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1415.00,NULL,NULL,1,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(206,7847,40745,7820,2,206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',2890.00,NULL,NULL,1,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(207,7847,40745,7820,2,207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',8300.00,NULL,NULL,1,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(208,7847,40745,7820,2,208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',775.00,NULL,NULL,1,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(209,7847,40745,7820,2,209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1435.00,NULL,NULL,1,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(210,7847,40745,7820,2,210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',960.00,NULL,NULL,1,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(211,7847,40745,7820,2,211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',880.00,NULL,NULL,1,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(212,7847,40745,7820,2,212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',3460.00,NULL,NULL,1,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(213,7847,40745,7820,2,213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1800.00,NULL,NULL,1,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(214,7847,40745,7820,3,214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',5899.00,NULL,NULL,1,'2022-11-08 15:00:13','2022-11-08 15:00:13',NULL),(215,7847,40745,7820,3,215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',2482.00,NULL,NULL,1,'2022-11-08 15:00:13','2022-11-08 15:00:13',NULL),(216,7847,40745,7820,3,216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',19571.43,NULL,NULL,1,'2022-11-08 15:00:14','2022-11-08 15:00:14',NULL),(217,7847,40745,7820,3,217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',11635.24,NULL,NULL,1,'2022-11-08 15:00:14','2022-11-08 15:00:14',NULL),(218,7847,40745,7820,3,218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',45123.22,NULL,NULL,1,'2022-11-08 15:00:14','2022-11-08 15:00:14',NULL),(219,7847,40745,7820,3,219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',14903.34,NULL,NULL,1,'2022-11-08 15:00:14','2022-11-08 15:00:14',NULL),(220,7847,40745,7820,3,220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',26781.53,NULL,NULL,1,'2022-11-08 15:00:14','2022-11-08 15:00:14',NULL),(221,7847,40719,13,2,222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',24000.00,NULL,NULL,1,'2022-11-15 10:57:13','2022-11-15 10:57:13',NULL),(222,7847,40719,13,2,223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',12000.00,NULL,NULL,1,'2022-11-15 11:06:09','2022-11-15 11:06:09',NULL);
INSERT INTO `balance_libro` VALUES (223,7847,40751,35105,2,224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',4800.00,NULL,NULL,1,'2022-11-16 15:00:13','2022-11-16 15:00:13',NULL),(224,7847,40751,35105,2,225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',5600.00,NULL,NULL,1,'2022-11-16 15:00:13','2022-11-16 15:00:13',NULL),(225,7847,40751,35105,2,226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',5000.00,NULL,NULL,1,'2022-11-16 15:00:13','2022-11-16 15:00:13',NULL),(226,7847,40751,35105,2,227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',5500.00,NULL,NULL,1,'2022-11-16 15:00:13','2022-11-16 15:00:13',NULL),(227,7847,40751,35105,2,228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',5500.00,NULL,NULL,1,'2022-11-16 15:00:13','2022-11-16 15:00:13',NULL),(228,7847,40751,35105,2,229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',13000.00,NULL,NULL,1,'2022-11-16 15:00:13','2022-11-16 15:00:13',NULL),(229,7847,40751,35105,2,230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',6500.00,NULL,NULL,1,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(230,7847,40751,35105,2,231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',4000.00,NULL,NULL,1,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(231,7847,40751,35105,2,232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',6450.00,NULL,NULL,1,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(232,7847,40751,35105,2,233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',13000.00,NULL,NULL,1,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(233,7847,40751,35105,2,234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',2500.00,NULL,NULL,1,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(234,7847,40751,35105,2,235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',3080.00,NULL,NULL,1,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(235,7847,40751,35105,2,236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',13000.00,NULL,NULL,1,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(236,7847,40751,35105,2,237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',6800.00,NULL,NULL,1,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(237,7847,40751,35105,2,238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',13000.00,NULL,NULL,1,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(238,7847,40751,35105,2,239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',4500.00,NULL,NULL,1,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(239,7847,40751,35105,2,240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',7800.00,NULL,NULL,1,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(240,7847,40751,35105,2,241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',13000.00,NULL,NULL,1,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(241,7847,40751,35105,2,242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',11400.00,NULL,NULL,1,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(242,7847,40751,35105,2,243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',4180.00,NULL,NULL,1,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(243,7847,40751,35105,2,244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',4800.00,NULL,NULL,1,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(244,7847,40751,35105,3,245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1378.37,NULL,NULL,1,'2022-11-22 17:13:45','2022-11-22 17:13:45',NULL),(245,7847,40751,35105,3,246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',11500.00,NULL,NULL,1,'2022-11-22 17:13:45','2022-11-22 17:13:45',NULL),(246,7847,40751,35105,3,247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',8000.00,NULL,NULL,1,'2022-11-22 17:13:45','2022-11-22 17:13:45',NULL);
INSERT INTO `balance_libro` VALUES (247,7847,40736,6100,3,248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',288354.38,NULL,NULL,1,'2022-11-23 10:13:03','2022-11-23 10:13:03',NULL),(248,7847,40736,6100,3,249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',98375.35,NULL,NULL,1,'2022-11-23 10:13:03','2022-11-23 10:13:03',NULL),(249,7847,40736,6100,3,250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',7855.40,NULL,NULL,1,'2022-11-23 10:13:03','2022-11-23 10:13:03',NULL),(250,7847,40736,6100,3,251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',7234.23,NULL,NULL,1,'2022-11-23 10:13:03','2022-11-23 10:13:03',NULL),(251,7847,40736,6100,3,252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',18491.22,NULL,NULL,1,'2022-11-23 10:13:03','2022-11-23 10:13:03',NULL),(252,7847,40736,6100,3,253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',4400.00,NULL,NULL,1,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(253,7847,40736,6100,3,254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',735.00,NULL,NULL,1,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(254,7847,40736,6100,3,255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1102.50,NULL,NULL,1,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(255,7847,40736,6100,3,256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1459.50,NULL,NULL,1,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(256,7847,40736,6100,3,257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',106297.24,NULL,NULL,1,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(257,7847,40736,6100,3,258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',2200.00,NULL,NULL,1,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(258,7847,40736,6100,3,259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',2200.00,NULL,NULL,1,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(259,7847,40736,6100,3,260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',6000.00,NULL,NULL,1,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(260,7847,40736,6100,3,261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',71954.59,NULL,NULL,1,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(261,7847,40736,6100,3,262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',735.00,NULL,NULL,1,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(262,7847,40736,6100,3,263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',1155.01,NULL,NULL,1,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(263,7847,40736,6100,3,264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',1459.50,NULL,NULL,1,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(264,7847,40736,6100,3,265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',609.01,NULL,NULL,1,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(265,7847,40736,6100,3,266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',4500.00,NULL,NULL,1,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(266,7847,40736,6100,3,267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',28923.84,NULL,NULL,1,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(267,7847,40736,6100,3,268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',24494.03,NULL,NULL,1,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(268,7847,40736,6100,3,269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1155.01,NULL,NULL,1,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(269,7847,40736,6100,3,270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',91857.15,NULL,NULL,1,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(270,7847,40736,6100,3,271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',553037.76,NULL,NULL,1,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(271,7847,40736,6100,3,272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',3000.00,NULL,NULL,1,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL);
INSERT INTO `balance_libro` VALUES (272,7847,40736,6100,3,273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',91857.15,NULL,NULL,1,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(273,7847,40736,6100,3,274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',4500.00,NULL,NULL,1,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(274,7847,40736,6100,3,275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',71240.93,NULL,NULL,1,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(275,7847,40736,6100,3,276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',4500.00,NULL,NULL,1,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(276,7847,40736,6100,3,277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',4500.00,NULL,NULL,1,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(277,7847,40736,6100,3,278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',5000.00,NULL,NULL,1,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(278,7847,40736,6100,3,279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',5156.48,NULL,NULL,1,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(279,7847,40736,6100,3,280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',735.00,NULL,NULL,1,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(280,7847,40736,6100,3,281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',735.00,NULL,NULL,1,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(281,7847,40736,6100,3,282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',184841.27,NULL,NULL,1,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(282,7847,40736,6100,3,283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1459.50,NULL,NULL,1,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(283,7847,40736,6100,3,284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1102.50,NULL,NULL,1,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(284,7847,40736,6100,3,285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',4500.00,NULL,NULL,1,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(285,7847,40736,6100,3,286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',7500.00,NULL,NULL,1,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(286,7847,40736,6100,3,287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',6000.00,NULL,NULL,1,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(287,7847,40736,6100,3,288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',24000.00,NULL,NULL,1,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(288,7847,40736,6100,3,289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',6000.00,NULL,NULL,1,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(289,7847,40736,6100,3,290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',109752.80,NULL,NULL,1,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(290,7847,40736,6100,3,291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',106498.00,NULL,NULL,1,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(291,7847,40736,6100,3,292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',735.00,NULL,NULL,1,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(292,7847,40736,6100,3,293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',735.00,NULL,NULL,1,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(293,7847,40736,6100,3,294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',1155.01,NULL,NULL,1,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(294,7847,40736,6100,3,295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',47273.05,NULL,NULL,1,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(295,7847,40736,6100,3,296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',11023.59,NULL,NULL,1,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(296,7847,40736,6100,3,297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',6000.00,NULL,NULL,1,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL);
INSERT INTO `balance_libro` VALUES (297,7847,40736,6100,3,298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1459.50,NULL,NULL,1,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(298,7847,40736,6100,3,299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',17895.79,NULL,NULL,1,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(299,7847,40736,6100,3,300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',41200.00,NULL,NULL,1,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(300,7847,40736,6100,3,301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',202254.96,NULL,NULL,1,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(301,7847,40736,6100,3,302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',267631.68,NULL,NULL,1,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(302,7847,40736,6100,3,303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',41091.60,NULL,NULL,1,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(303,7847,40736,6100,3,304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',553037.76,NULL,NULL,1,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(304,7847,40736,6100,3,305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',0.00,NULL,NULL,1,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(305,7847,40736,6100,2,306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',5100.00,NULL,NULL,1,'2022-11-23 11:38:02','2022-11-23 12:19:39','2022-11-23 12:19:39'),(306,7847,40736,6100,2,307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',6110.00,NULL,NULL,1,'2022-11-23 11:38:02','2022-11-23 12:19:34','2022-11-23 12:19:34'),(307,7847,40736,6100,2,308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',6980.00,NULL,NULL,1,'2022-11-23 11:38:02','2022-11-23 12:19:19','2022-11-23 12:19:19'),(308,7847,40736,6100,2,309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',66550.00,NULL,NULL,1,'2022-11-23 11:38:02','2022-11-23 12:19:15','2022-11-23 12:19:15'),(309,7847,40736,6100,2,310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',2000.00,NULL,NULL,1,'2022-11-23 12:24:11','2022-11-23 12:24:11',NULL),(310,7847,40736,6100,2,311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',2600.00,NULL,NULL,1,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(311,7847,40736,6100,2,312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',6160.00,NULL,NULL,1,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(312,7847,40736,6100,2,313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',4670.00,NULL,NULL,1,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(313,7847,40736,6100,2,314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',2620.00,NULL,NULL,1,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(314,7847,40736,6100,2,315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',6080.00,NULL,NULL,1,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(315,7847,40736,6100,2,316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',3560.00,NULL,NULL,1,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(316,7847,40736,6100,2,317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',21000.00,NULL,NULL,1,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(317,7847,40736,6100,2,318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',4000.00,NULL,NULL,1,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(318,7847,40736,6100,2,319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',1790.00,NULL,NULL,1,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(319,7847,40736,6100,2,320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',4200.00,NULL,NULL,1,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(320,7847,40736,6100,2,321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',4241.00,NULL,NULL,1,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL);
INSERT INTO `balance_libro` VALUES (321,7847,40736,6100,2,322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',4890.00,NULL,NULL,1,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(322,7847,40736,6100,2,323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',950.00,NULL,NULL,1,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(323,7847,40736,6100,2,324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',14310.00,NULL,NULL,1,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(324,7847,40736,6100,2,325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',900.00,NULL,NULL,1,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(325,7847,40736,6100,2,326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',3600.00,NULL,NULL,1,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(326,7847,40736,6100,2,327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',19010.00,NULL,NULL,1,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(327,7847,40736,6100,2,328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',20900.00,NULL,NULL,1,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(328,7847,40736,6100,2,329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',7000.00,NULL,NULL,1,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(329,7847,40736,6100,2,330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',11280.00,NULL,NULL,1,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(330,7847,40736,6100,2,331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',3750.00,NULL,NULL,1,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(331,7847,40736,6100,2,332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',8130.00,NULL,NULL,1,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(332,7847,40736,6100,2,333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',6365.00,NULL,NULL,1,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(333,7847,40736,6100,2,334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',5100.00,NULL,NULL,1,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(334,7847,40736,6100,2,335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',6110.00,NULL,NULL,1,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(335,7847,40736,6100,2,336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',6980.00,NULL,NULL,1,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(336,7847,40736,6100,2,337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',66550.00,NULL,NULL,1,'2022-11-23 12:24:13','2022-11-23 12:24:13',NULL),(337,7847,40736,6100,2,338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',15613.00,NULL,NULL,1,'2022-11-23 12:24:27','2022-11-23 12:24:27',NULL),(338,7847,40736,6100,2,339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',5600.00,NULL,NULL,1,'2022-11-23 12:24:27','2022-11-23 12:24:27',NULL),(339,7847,40736,6100,2,340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',3150.00,NULL,NULL,1,'2022-11-23 12:24:27','2022-11-23 12:24:27',NULL),(340,7847,40736,6100,2,341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',20081.00,NULL,NULL,1,'2022-11-23 12:24:27','2022-11-23 12:24:27',NULL),(341,7847,40736,6100,2,342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',3000.00,NULL,NULL,1,'2022-11-23 12:24:27','2022-11-23 12:24:27',NULL),(342,7847,40736,6100,2,343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',5700.00,NULL,NULL,1,'2022-11-23 12:24:28','2022-11-23 12:24:28',NULL),(343,7847,40736,6100,2,344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',4750.00,NULL,NULL,1,'2022-11-23 12:24:28','2022-11-23 12:24:28',NULL),(344,7847,40736,6100,2,345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',4000.00,NULL,NULL,1,'2022-11-23 12:24:28','2022-11-23 12:24:28',NULL),(345,7847,40736,6100,2,346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',7150.00,NULL,NULL,1,'2022-11-23 12:24:28','2022-11-23 12:24:28',NULL);
INSERT INTO `balance_libro` VALUES (346,7847,40736,6100,2,347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',12011.00,NULL,NULL,1,'2022-11-23 12:24:28','2022-11-23 12:24:28',NULL),(347,7847,40787,51641,2,348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',100000.00,NULL,NULL,1,'2022-11-26 20:57:10','2022-11-26 20:57:10',NULL),(348,7847,40787,51641,2,349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',713900.00,NULL,NULL,1,'2022-11-26 20:57:10','2022-11-26 20:57:10',NULL),(349,7847,40787,51641,2,350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',58000.01,NULL,NULL,1,'2022-11-26 20:57:10','2022-11-26 20:57:10',NULL),(350,7847,40787,51641,2,351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',60000.00,NULL,NULL,1,'2022-11-26 20:57:10','2022-11-26 20:57:10',NULL),(351,7847,40787,51641,3,352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',150.00,NULL,NULL,1,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(352,7847,40787,51641,3,353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1117.77,NULL,NULL,1,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(353,7847,40787,51641,3,354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',5000.00,NULL,NULL,1,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(354,7847,40787,51641,3,355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',5019.99,NULL,NULL,1,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(355,7847,40787,51641,3,356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',166000.00,NULL,NULL,1,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(356,7847,40787,51641,3,357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',200000.00,NULL,NULL,1,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(357,7847,40787,51641,3,358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',234000.01,NULL,NULL,1,'2022-11-26 20:57:25','2022-11-26 20:59:50','2022-11-26 20:59:50'),(358,7847,40787,51641,3,358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',234000.00,NULL,NULL,1,'2022-11-26 20:59:50','2022-11-26 20:59:50',NULL),(359,7847,40787,51641,2,359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',150.00,NULL,NULL,1,'2022-11-27 06:44:34','2022-11-27 06:53:27','2022-11-27 06:53:27'),(360,7847,40787,51641,2,360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1117.77,NULL,NULL,1,'2022-11-27 06:44:34','2022-11-27 06:48:41','2022-11-27 06:48:41'),(361,7847,40787,51641,2,361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',5000.00,NULL,NULL,1,'2022-11-27 06:44:34','2022-11-27 06:48:19','2022-11-27 06:48:19'),(362,7847,40787,51641,2,362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',5019.99,NULL,NULL,1,'2022-11-27 06:44:34','2022-11-27 06:45:52','2022-11-27 06:45:52'),(363,7847,40787,51641,2,363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',166000.00,NULL,NULL,1,'2022-11-27 06:44:34','2022-11-27 06:53:33','2022-11-27 06:53:33'),(364,7847,40787,51641,2,364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',200000.00,NULL,NULL,1,'2022-11-27 06:44:34','2022-11-27 06:53:37','2022-11-27 06:53:37'),(365,7847,40787,51641,2,365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',234000.01,NULL,NULL,1,'2022-11-27 06:44:34','2022-11-27 06:53:46','2022-11-27 06:53:46'),(366,7847,40787,51641,2,362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',5020.05,NULL,NULL,1,'2022-11-27 06:45:52','2022-11-27 06:49:44','2022-11-27 06:49:44'),(367,7847,40787,51641,2,361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',5000.00,NULL,NULL,1,'2022-11-27 06:48:19','2022-11-27 06:53:07','2022-11-27 06:53:07'),(368,7847,40787,51641,2,360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1117.77,NULL,NULL,1,'2022-11-27 06:48:41','2022-11-27 06:48:41',NULL);
INSERT INTO `balance_libro` VALUES (369,7847,40787,51641,2,362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',5019.99,NULL,NULL,1,'2022-11-27 06:49:44','2022-11-27 06:53:42','2022-11-27 06:53:42'),(370,7847,40735,4597,2,366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',60000.00,NULL,NULL,1,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(371,7847,40735,4597,2,367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',45000.00,NULL,NULL,1,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(372,7847,40735,4597,2,368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',267748.80,NULL,NULL,1,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(373,7847,40735,4597,2,369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',35000.00,NULL,NULL,1,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(374,7847,40735,4597,2,370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',43500.00,NULL,NULL,1,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(375,7847,40735,4597,2,371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',184404.00,NULL,NULL,1,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(376,7847,40735,4597,2,372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',44000.00,NULL,NULL,1,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(377,7847,40735,4597,3,373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',1100.00,NULL,NULL,1,'2022-11-28 13:01:41','2022-11-28 13:01:41',NULL),(378,7847,40735,4597,3,374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',10000.00,NULL,NULL,1,'2022-11-28 13:01:41','2022-11-28 13:01:41',NULL),(379,7847,40735,4597,3,375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',12000.00,NULL,NULL,1,'2022-11-28 13:01:41','2022-11-28 13:01:41',NULL),(380,7847,40735,4597,3,376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',6000.00,NULL,NULL,1,'2022-11-28 13:01:41','2022-11-28 13:01:41',NULL),(381,7847,40735,4597,3,377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',66550.00,NULL,NULL,1,'2022-11-28 13:01:41','2022-11-28 13:01:41',NULL),(382,7847,40735,4597,3,378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',143990.00,NULL,NULL,1,'2022-11-28 13:01:41','2022-11-28 13:01:41',NULL),(383,7847,40735,4597,3,379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',10000.97,NULL,NULL,1,'2022-11-28 14:03:24','2022-11-28 14:03:24',NULL),(384,7847,40735,4597,3,380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',5000.01,NULL,NULL,1,'2022-11-28 14:05:35','2022-11-28 14:05:35',NULL),(387,7847,40720,1526,3,383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-13','2022-11-13',31624.11,NULL,NULL,1,'2022-12-23 11:12:30','2022-12-23 11:23:22','2022-12-23 11:23:22'),(388,7847,40720,1526,3,384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-20','2022-11-20',5450.48,NULL,NULL,1,'2022-12-23 11:12:30','2022-12-23 11:12:30',NULL),(389,7847,40720,1526,3,385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',500001.04,NULL,NULL,1,'2022-12-23 11:12:30','2022-12-23 11:12:30',NULL),(390,7847,40720,1526,3,386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',18000.00,NULL,NULL,1,'2022-12-23 11:12:30','2022-12-23 11:12:30',NULL),(392,7847,40720,1526,2,388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-13','2022-11-13',31624.11,NULL,NULL,1,'2022-12-23 11:17:07','2022-12-23 11:19:13','2022-12-23 11:19:13'),(393,7847,40720,1526,2,389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-20','2022-11-20',5450.48,NULL,NULL,1,'2022-12-23 11:17:07','2022-12-23 11:19:05','2022-12-23 11:19:05'),(394,7847,40720,1526,2,390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',500001.04,NULL,NULL,1,'2022-12-23 11:17:07','2022-12-23 11:19:00','2022-12-23 11:19:00'),(395,7847,40720,1526,2,391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',18000.00,NULL,NULL,1,'2022-12-23 11:17:07','2022-12-23 11:18:03','2022-12-23 11:18:03');
INSERT INTO `balance_libro` VALUES (396,7847,40720,1526,2,392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',46524.00,NULL,NULL,1,'2022-12-23 11:17:35','2022-12-23 11:36:00','2022-12-23 11:36:00'),(397,7847,40720,1526,2,393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',50028.00,NULL,NULL,1,'2022-12-23 11:17:35','2022-12-23 11:35:38','2022-12-23 11:35:38'),(398,7847,40720,1526,2,393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',50028.00,NULL,NULL,1,'2022-12-23 11:35:38','2022-12-23 11:35:38',NULL),(399,7847,40720,1526,2,392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',46524.00,NULL,NULL,1,'2022-12-23 11:36:00','2022-12-23 11:36:00',NULL),(400,7847,40720,1526,3,394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',12900.01,NULL,NULL,1,'2022-12-23 11:43:26','2022-12-23 11:43:26',NULL),(401,7847,40720,1525,3,395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',28319.75,NULL,NULL,1,'2022-12-23 11:58:32','2022-12-23 11:59:10','2022-12-23 11:59:10'),(402,7847,40720,1525,3,396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',5404.00,NULL,NULL,1,'2022-12-23 11:58:32','2022-12-23 11:58:32',NULL),(403,7847,40720,1525,3,397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',19000.00,NULL,NULL,1,'2022-12-23 11:58:32','2022-12-23 11:58:32',NULL),(404,7847,40720,1525,3,398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',8800.00,NULL,NULL,1,'2022-12-23 11:58:32','2022-12-23 12:04:49','2022-12-23 12:04:49'),(405,7847,40735,4600,2,399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',46800.00,NULL,NULL,1,'2023-02-21 23:43:30','2023-02-21 23:43:30',NULL),(406,7847,40735,4600,2,400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',48000.00,NULL,NULL,1,'2023-02-21 23:43:30','2023-02-21 23:43:30',NULL),(407,7847,40735,4600,2,401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',45500.00,NULL,NULL,1,'2023-02-21 23:43:30','2023-02-21 23:43:30',NULL),(408,7847,40735,4600,2,402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',133874.40,NULL,NULL,1,'2023-02-21 23:43:30','2023-02-21 23:43:30',NULL),(409,7847,40735,4600,2,403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',48300.00,NULL,NULL,1,'2023-02-21 23:43:30','2023-02-21 23:43:30',NULL),(410,7847,40735,4600,3,404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',231.00,NULL,NULL,1,'2023-02-21 23:43:39','2023-02-22 00:17:39','2023-02-22 00:17:39'),(411,7847,40735,4600,3,405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',1500.00,NULL,NULL,1,'2023-02-21 23:43:39','2023-02-22 00:19:22','2023-02-22 00:19:22'),(412,7847,40735,4600,3,406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',326.57,NULL,NULL,1,'2023-02-21 23:43:39','2023-02-22 00:18:32','2023-02-22 00:18:32'),(413,7847,40735,4600,3,407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',4000.01,NULL,NULL,1,'2023-02-21 23:43:39','2023-02-21 23:43:39',NULL),(414,7847,40735,4600,3,408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1172.00,NULL,NULL,1,'2023-02-21 23:43:39','2023-02-22 00:18:02','2023-02-22 00:18:02'),(415,7847,40735,4600,3,409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',9999.99,NULL,NULL,1,'2023-02-21 23:43:39','2023-02-21 23:43:39',NULL),(416,7847,40735,4600,3,410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',400001.80,NULL,NULL,1,'2023-02-21 23:43:39','2023-02-21 23:43:39',NULL),(417,7847,40735,4600,3,404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',231.00,NULL,NULL,1,'2023-02-22 00:17:39','2023-02-22 00:19:38','2023-02-22 00:19:38'),(418,7847,40735,4600,3,408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1172.00,NULL,NULL,1,'2023-02-22 00:18:02','2023-02-22 00:19:01','2023-02-22 00:19:01'),(419,7847,40735,4600,3,406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',326.58,NULL,NULL,1,'2023-02-22 00:18:32','2023-02-22 00:18:32',NULL);
INSERT INTO `balance_libro` VALUES (420,7847,40735,4600,3,408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1172.00,NULL,NULL,1,'2023-02-22 00:19:01','2023-02-22 00:19:01',NULL),(421,7847,40735,4600,3,405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',1500.00,NULL,NULL,1,'2023-02-22 00:19:22','2023-02-22 00:19:22',NULL),(422,7847,40735,4600,3,404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',231.00,NULL,NULL,1,'2023-02-22 00:19:38','2023-02-22 00:19:38',NULL),(423,7847,40720,1533,2,411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',54000.00,NULL,NULL,1,'2023-02-22 00:53:39','2023-02-22 00:53:39',NULL),(424,7847,40720,1533,2,412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',215000.00,NULL,NULL,1,'2023-02-22 00:53:39','2023-02-22 00:53:39',NULL),(425,7847,40720,1533,3,413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',3150.19,NULL,NULL,1,'2023-02-22 00:53:51','2023-02-22 00:53:51',NULL),(426,7847,40720,1533,3,414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',350316.00,NULL,NULL,1,'2023-02-22 00:53:51','2023-02-22 00:53:51',NULL),(427,7847,40720,1533,3,415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',19400.00,NULL,NULL,1,'2023-02-22 00:53:51','2023-02-22 00:53:51',NULL),(428,7847,40720,1533,3,416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',371300.60,NULL,NULL,1,'2023-02-22 00:53:51','2023-02-22 00:53:51',NULL),(429,7847,40720,1533,3,417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',100000.45,NULL,NULL,1,'2023-02-22 00:53:51','2023-02-22 00:53:51',NULL),(430,7847,40720,1533,3,418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',16352.61,NULL,NULL,1,'2023-02-22 00:53:51','2023-02-22 00:57:05','2023-02-22 00:57:05'),(431,7847,40720,1533,3,418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',16352.60,NULL,NULL,1,'2023-02-22 00:57:05','2023-02-22 00:57:05',NULL),(432,7847,40736,6104,2,419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',33002.75,NULL,NULL,1,'2023-02-22 13:21:17','2023-02-22 13:21:17',NULL),(433,7847,40736,6104,2,420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',17220.00,NULL,NULL,1,'2023-02-22 13:21:17','2023-02-22 13:21:17',NULL),(434,7847,40736,6104,2,421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',19480.00,NULL,NULL,1,'2023-02-22 13:21:17','2023-02-22 13:21:17',NULL),(435,7847,40736,6104,2,422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',19250.00,NULL,NULL,1,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(436,7847,40736,6104,2,423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',20580.00,NULL,NULL,1,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(437,7847,40736,6104,2,424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',17580.00,NULL,NULL,1,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(438,7847,40736,6104,2,425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',21000.00,NULL,NULL,1,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(439,7847,40736,6104,2,426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',19880.00,NULL,NULL,1,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(440,7847,40736,6104,2,427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',20700.00,NULL,NULL,1,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(441,7847,40736,6104,2,428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',21000.00,NULL,NULL,1,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(442,7847,40736,6104,2,429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',17430.00,NULL,NULL,1,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(443,7847,40736,6104,2,430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',20930.00,NULL,NULL,1,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL);
INSERT INTO `balance_libro` VALUES (444,7847,40736,6104,2,431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',19340.00,NULL,NULL,1,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(445,7847,40736,6104,2,432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',17770.00,NULL,NULL,1,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(446,7847,40736,6104,2,433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',20870.00,NULL,NULL,1,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(447,7847,40736,6104,2,434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',19130.00,NULL,NULL,1,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(448,7847,40736,6104,2,435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',18700.00,NULL,NULL,1,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(449,7847,40736,6104,2,436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',21200.00,NULL,NULL,1,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(450,7847,40736,6104,2,437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',17130.00,NULL,NULL,1,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(451,7847,40736,6104,2,438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',21250.00,NULL,NULL,1,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(452,7847,40736,6104,2,439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',20230.00,NULL,NULL,1,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(453,7847,40736,6104,2,440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',4760.00,NULL,NULL,1,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(454,7847,40736,6104,2,441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',20980.00,NULL,NULL,1,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(455,7847,40736,6104,2,442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',20395.00,NULL,NULL,1,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(456,7847,40736,6104,2,443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',8514.00,NULL,NULL,1,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(457,7847,40736,6104,2,444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',21640.00,NULL,NULL,1,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(458,7847,40736,6104,2,445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',16010.00,NULL,NULL,1,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(459,7847,40736,6104,2,446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',10470.00,NULL,NULL,1,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(460,7847,40736,6104,2,447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',18390.00,NULL,NULL,1,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(461,7847,40736,6104,2,448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',21560.00,NULL,NULL,1,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(462,7847,40736,6104,2,449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',14330.00,NULL,NULL,1,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(463,7847,40736,6104,2,450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',20980.00,NULL,NULL,1,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(464,7847,40736,6104,2,451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',17769.00,NULL,NULL,1,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(465,7847,40736,6104,2,452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',16150.00,NULL,NULL,1,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(466,7847,40736,6104,2,453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',21640.00,NULL,NULL,1,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(467,7847,40736,6104,2,454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',14970.00,NULL,NULL,1,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(468,7847,40736,6104,2,455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',11540.00,NULL,NULL,1,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL);
INSERT INTO `balance_libro` VALUES (469,7847,40736,6104,2,456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',20450.00,NULL,NULL,1,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(470,7847,40736,6104,2,457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',20680.00,NULL,NULL,1,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(471,7847,40736,6104,2,458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',23960.00,NULL,NULL,1,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(472,7847,40736,6104,2,459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',25000.00,NULL,NULL,1,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(473,7847,40736,6104,2,460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',19000.00,NULL,NULL,1,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(474,7847,40736,6104,2,461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',22589.00,NULL,NULL,1,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(475,7847,40736,6104,2,462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',23240.00,NULL,NULL,1,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(476,7847,40736,6104,2,463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',22180.00,NULL,NULL,1,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(477,7847,40736,6104,2,464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',20450.00,NULL,NULL,1,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(478,7847,40736,6104,2,465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',22310.00,NULL,NULL,1,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(479,7847,40736,6104,3,466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',10000.65,NULL,NULL,1,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(480,7847,40736,6104,3,467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-02-22 13:21:33','2023-02-24 10:48:26','2023-02-24 10:48:26'),(481,7847,40736,6104,3,468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1743.01,NULL,NULL,1,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(482,7847,40736,6104,3,469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',289844.27,NULL,NULL,1,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(483,7847,40736,6104,3,470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5600.00,NULL,NULL,1,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(484,7847,40736,6104,3,471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',625309.74,NULL,NULL,1,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(485,7847,40736,6104,3,472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',839.99,NULL,NULL,1,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(486,7847,40736,6104,3,473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',839.99,NULL,NULL,1,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(487,7847,40736,6104,3,474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1323.00,NULL,NULL,1,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(488,7847,40736,6104,3,475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1385.99,NULL,NULL,1,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(489,7847,40736,6104,3,476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',10330.78,NULL,NULL,1,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(490,7847,40736,6104,3,477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',49834.72,NULL,NULL,1,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(491,7847,40736,6104,3,478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',5600.00,NULL,NULL,1,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(492,7847,40736,6104,3,479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',10186.91,NULL,NULL,1,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(493,7847,40736,6104,3,480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',49834.72,NULL,NULL,1,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL);
INSERT INTO `balance_libro` VALUES (494,7847,40736,6104,3,481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',1743.01,NULL,NULL,1,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(495,7847,40736,6104,3,482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',1385.99,NULL,NULL,1,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(496,7847,40736,6104,3,483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',19914.45,NULL,NULL,1,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(497,7847,40736,6104,3,484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',839.99,NULL,NULL,1,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(498,7847,40736,6104,3,485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',839.99,NULL,NULL,1,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(499,7847,40736,6104,3,486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',312654.87,NULL,NULL,1,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(500,7847,40736,6104,3,487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',839.99,NULL,NULL,1,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(501,7847,40736,6104,3,488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1743.01,NULL,NULL,1,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(502,7847,40736,6104,3,489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1743.01,NULL,NULL,1,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(503,7847,40736,6104,3,490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',839.99,NULL,NULL,1,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(504,7847,40736,6104,3,491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',839.99,NULL,NULL,1,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(505,7847,40736,6104,3,492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',436566.91,NULL,NULL,1,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(506,7847,40736,6104,3,493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',43200.00,NULL,NULL,1,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(507,7847,40736,6104,3,494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1385.99,NULL,NULL,1,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(508,7847,40736,6104,3,495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1385.99,NULL,NULL,1,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(509,7847,40736,6104,3,496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1385.99,NULL,NULL,1,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(510,7847,40736,6104,3,497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',839.99,NULL,NULL,1,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(511,7847,40736,6104,3,498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1385.99,NULL,NULL,1,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(512,7847,40736,6104,3,499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1385.99,NULL,NULL,1,'2023-02-22 13:21:35','2023-02-22 13:21:35',NULL),(513,7847,40736,6104,3,500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',8400.00,NULL,NULL,1,'2023-02-22 13:21:35','2023-02-22 13:21:35',NULL),(514,7847,40736,6104,3,501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',49430.11,NULL,NULL,1,'2023-02-22 13:21:35','2023-02-22 13:21:35',NULL),(515,7847,40736,6104,3,502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',19600.79,NULL,NULL,1,'2023-02-22 13:21:35','2023-02-22 13:21:35',NULL),(516,7847,40736,6104,3,503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',650447.82,NULL,NULL,1,'2023-02-22 13:21:35','2023-02-22 13:46:29','2023-02-22 13:46:29'),(517,7847,40736,6104,3,504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',26065.06,NULL,NULL,1,'2023-02-22 13:21:35','2023-02-22 13:21:35',NULL),(518,7847,40736,6104,3,503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',650447.82,NULL,NULL,1,'2023-02-22 13:46:29','2023-02-22 13:46:29',NULL);
INSERT INTO `balance_libro` VALUES (519,7847,40736,6104,3,505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',9295.98,NULL,NULL,1,'2023-02-24 10:46:11','2023-02-24 10:47:11','2023-02-24 10:47:11'),(520,7847,40736,6104,3,506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',53794.38,NULL,NULL,1,'2023-02-24 10:46:12','2023-02-24 10:47:05','2023-02-24 10:47:05'),(521,7847,40736,6104,3,507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',48199.85,NULL,NULL,1,'2023-02-24 10:46:12','2023-02-24 10:46:57','2023-02-24 10:46:57'),(522,7847,40736,6104,3,508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',21608.48,NULL,NULL,1,'2023-02-24 10:46:12','2023-02-24 10:46:47','2023-02-24 10:46:47'),(523,7847,40736,6104,3,509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',5000.00,NULL,NULL,1,'2023-02-24 10:46:12','2023-02-24 10:46:39','2023-02-24 10:46:39'),(524,7847,40736,6102,2,510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',6510.00,NULL,NULL,1,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(525,7847,40736,6102,2,511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',6040.00,NULL,NULL,1,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(526,7847,40736,6102,2,512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',20000.00,NULL,NULL,1,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(527,7847,40736,6102,2,513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',16320.00,NULL,NULL,1,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(528,7847,40736,6102,2,514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',20000.00,NULL,NULL,1,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(529,7847,40736,6102,2,515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',15900.00,NULL,NULL,1,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(530,7847,40736,6102,2,516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',3350.00,NULL,NULL,1,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(531,7847,40736,6102,2,517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',2000.00,NULL,NULL,1,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(532,7847,40736,6102,2,518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',3500.00,NULL,NULL,1,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(533,7847,40736,6102,2,519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',18200.00,NULL,NULL,1,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(534,7847,40736,6102,2,520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',11110.00,NULL,NULL,1,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(535,7847,40736,6102,2,521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',21140.00,NULL,NULL,1,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(536,7847,40736,6102,2,522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',5600.00,NULL,NULL,1,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(537,7847,40736,6102,2,523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',17540.00,NULL,NULL,1,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(538,7847,40736,6102,2,524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',11890.00,NULL,NULL,1,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(539,7847,40736,6102,2,525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',15000.00,NULL,NULL,1,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(540,7847,40736,6102,2,526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',10350.00,NULL,NULL,1,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(541,7847,40736,6102,2,527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',10700.00,NULL,NULL,1,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(542,7847,40736,6102,2,528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',6730.00,NULL,NULL,1,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL);
INSERT INTO `balance_libro` VALUES (543,7847,40736,6102,2,529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',9600.00,NULL,NULL,1,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(544,7847,40736,6102,2,530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',11800.00,NULL,NULL,1,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(545,7847,40736,6102,2,531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',12150.00,NULL,NULL,1,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(546,7847,40736,6102,2,532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',16715.00,NULL,NULL,1,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(547,7847,40736,6102,2,533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',14692.00,NULL,NULL,1,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(548,7847,40736,6102,2,534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',20700.00,NULL,NULL,1,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(549,7847,40736,6102,2,535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',20370.00,NULL,NULL,1,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(550,7847,40736,6102,2,536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',9110.00,NULL,NULL,1,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(551,7847,40736,6102,2,537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',5480.00,NULL,NULL,1,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(552,7847,40736,6102,2,538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',5900.00,NULL,NULL,1,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(553,7847,40736,6102,2,539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',2010.00,NULL,NULL,1,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(554,7847,40736,6102,2,540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',19400.00,NULL,NULL,1,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(555,7847,40736,6102,2,541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',8990.00,NULL,NULL,1,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(556,7847,40736,6102,2,542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',21450.00,NULL,NULL,1,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(557,7847,40736,6102,2,543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',16680.00,NULL,NULL,1,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(558,7847,40736,6102,2,544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',11680.00,NULL,NULL,1,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(559,7847,40736,6102,2,545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',16880.00,NULL,NULL,1,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(560,7847,40736,6102,2,546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',19670.00,NULL,NULL,1,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(561,7847,40736,6102,2,547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',10000.00,NULL,NULL,1,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(562,7847,40736,6102,2,548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',18279.00,NULL,NULL,1,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(563,7847,40736,6102,2,549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',8300.00,NULL,NULL,1,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(564,7847,40736,6102,2,550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',12200.00,NULL,NULL,1,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(565,7847,40736,6102,2,551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',9600.00,NULL,NULL,1,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(566,7847,40736,6102,2,552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',6880.00,NULL,NULL,1,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(567,7847,40736,6102,2,553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',4800.00,NULL,NULL,1,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL);
INSERT INTO `balance_libro` VALUES (568,7847,40736,6102,2,554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',8600.00,NULL,NULL,1,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(569,7847,40736,6102,2,555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',4800.00,NULL,NULL,1,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(570,7847,40736,6102,2,556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',3500.00,NULL,NULL,1,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(571,7847,40736,6102,2,557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',5700.00,NULL,NULL,1,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(572,7847,40736,6102,2,558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',3900.00,NULL,NULL,1,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(573,7847,40736,6102,2,559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',4800.00,NULL,NULL,1,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(574,7847,40736,6102,2,560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',6500.00,NULL,NULL,1,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(575,7847,40736,6102,2,561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',5340.00,NULL,NULL,1,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(576,7847,40736,6102,2,562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',3500.00,NULL,NULL,1,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(577,7847,40736,6102,2,563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',10630.00,NULL,NULL,1,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(578,7847,40736,6102,2,564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',3500.00,NULL,NULL,1,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(579,7847,40736,6102,2,565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',7300.00,NULL,NULL,1,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(580,7847,40736,6102,2,566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',1000.00,NULL,NULL,1,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(581,7847,40736,6102,2,567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',5500.00,NULL,NULL,1,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(582,7847,40736,6102,2,568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',13500.00,NULL,NULL,1,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(583,7847,40736,6102,2,569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',6000.00,NULL,NULL,1,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(584,7847,40736,6102,2,570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',8500.00,NULL,NULL,1,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(585,7847,40736,6102,2,571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',2500.00,NULL,NULL,1,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(586,7847,40736,6102,2,572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',8400.00,NULL,NULL,1,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(587,7847,40736,6102,2,573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',18670.00,NULL,NULL,1,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(588,7847,40736,6102,2,574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',14500.00,NULL,NULL,1,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(589,7847,40736,6102,2,575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',9800.00,NULL,NULL,1,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(590,7847,40736,6102,2,576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',6630.00,NULL,NULL,1,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(591,7847,40736,6102,2,577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',14010.00,NULL,NULL,1,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(592,7847,40736,6102,2,578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',18430.00,NULL,NULL,1,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL);
INSERT INTO `balance_libro` VALUES (593,7847,40736,6102,2,579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',5360.00,NULL,NULL,1,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(594,7847,40736,6102,2,580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',20900.00,NULL,NULL,1,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(595,7847,40736,6102,2,581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',10900.00,NULL,NULL,1,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(596,7847,40736,6102,2,582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',21400.00,NULL,NULL,1,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(597,7847,40736,6102,2,583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',11880.00,NULL,NULL,1,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(598,7847,40736,6102,2,584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',2280.00,NULL,NULL,1,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(599,7847,40736,6102,2,585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',9970.00,NULL,NULL,1,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(600,7847,40736,6102,2,586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',19470.00,NULL,NULL,1,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(601,7847,40736,6102,2,587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',6810.00,NULL,NULL,1,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(602,7847,40736,6102,2,588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',13660.00,NULL,NULL,1,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(603,7847,40736,6102,2,589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',12690.00,NULL,NULL,1,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(604,7847,40736,6102,2,590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',6430.00,NULL,NULL,1,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(605,7847,40736,6102,2,591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',11850.00,NULL,NULL,1,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(606,7847,40736,6102,2,592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',7980.00,NULL,NULL,1,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(607,7847,40736,6102,2,593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',12450.00,NULL,NULL,1,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(608,7847,40736,6102,2,594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',36000.00,NULL,NULL,1,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(609,7847,40736,6102,2,595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',4560.00,NULL,NULL,1,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(610,7847,40736,6102,2,596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',13000.00,NULL,NULL,1,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(611,7847,40736,6102,2,597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',7800.00,NULL,NULL,1,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(612,7847,40736,6102,2,598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',6370.00,NULL,NULL,1,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(613,7847,40736,6102,3,599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',9295.98,NULL,NULL,1,'2023-02-24 11:52:47','2023-02-24 11:52:47',NULL),(614,7847,40736,6102,3,600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',78120.51,NULL,NULL,1,'2023-02-24 11:52:47','2023-02-24 11:52:47',NULL),(615,7847,40736,6102,3,601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',3900.00,NULL,NULL,1,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(616,7847,40736,6102,3,602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',4200.00,NULL,NULL,1,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(617,7847,40736,6102,3,603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',117656.00,NULL,NULL,1,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL);
INSERT INTO `balance_libro` VALUES (618,7847,40736,6102,3,604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',8493.64,NULL,NULL,1,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(619,7847,40736,6102,3,605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',8158.74,NULL,NULL,1,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(620,7847,40736,6102,3,606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',72057.53,NULL,NULL,1,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(621,7847,40736,6102,3,607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',122394.11,NULL,NULL,1,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(622,7847,40736,6102,3,608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',839.99,NULL,NULL,1,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(623,7847,40736,6102,3,609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',839.99,NULL,NULL,1,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(624,7847,40736,6102,3,610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1743.01,NULL,NULL,1,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(625,7847,40736,6102,3,611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',37315.53,NULL,NULL,1,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(626,7847,40736,6102,3,612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',587088.87,NULL,NULL,1,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(627,7847,40736,6102,3,613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',84120.07,NULL,NULL,1,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(628,7847,40736,6102,3,614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',4200.00,NULL,NULL,1,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(629,7847,40736,6102,3,615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',21045.75,NULL,NULL,1,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(630,7847,40736,6102,3,616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',37315.53,NULL,NULL,1,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(631,7847,40736,6102,3,617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',5000.00,NULL,NULL,1,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(632,7847,40736,6102,3,618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',4200.00,NULL,NULL,1,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(633,7847,40736,6102,3,619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',20381.77,NULL,NULL,1,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(634,7847,40736,6102,3,620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',94579.87,NULL,NULL,1,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(635,7847,40736,6102,3,621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',625309.74,NULL,NULL,1,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(636,7847,40736,6102,3,622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',34465.61,NULL,NULL,1,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(637,7847,40736,6102,3,623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',1323.00,NULL,NULL,1,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(638,7847,40736,6102,3,624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',693.00,NULL,NULL,1,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(639,7847,40736,6102,3,625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',1385.99,NULL,NULL,1,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(640,7847,40736,6102,3,626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',839.99,NULL,NULL,1,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(641,7847,40736,6102,3,627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',4200.00,NULL,NULL,1,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(642,7847,40736,6102,3,628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',322679.03,NULL,NULL,1,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL);
INSERT INTO `balance_libro` VALUES (643,7847,40736,6102,3,629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',4200.00,NULL,NULL,1,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(644,7847,40736,6102,3,630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',58906.44,NULL,NULL,1,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(645,7847,40736,6102,3,631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',37515.32,NULL,NULL,1,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(646,7847,40736,6102,3,632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',1743.01,NULL,NULL,1,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(647,7847,40736,6102,3,633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',1385.99,NULL,NULL,1,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(648,7847,40736,6102,3,634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',1385.99,NULL,NULL,1,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(649,7847,40736,6102,3,635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',1385.99,NULL,NULL,1,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(650,7847,40736,6102,3,636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',839.99,NULL,NULL,1,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(651,7847,40736,6102,3,637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',839.99,NULL,NULL,1,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(652,7847,40736,6102,3,638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',1323.00,NULL,NULL,1,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(653,7847,40736,6102,3,639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',1323.00,NULL,NULL,1,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(654,7847,40736,6102,3,640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',1385.99,NULL,NULL,1,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(655,7847,40736,6102,3,641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',37315.53,NULL,NULL,1,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(656,7847,40736,6102,3,642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',610480.26,NULL,NULL,1,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(657,7847,40736,6102,3,643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',48893.65,NULL,NULL,1,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(658,7847,40736,6102,3,644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',5600.00,NULL,NULL,1,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(659,7847,40736,6102,3,645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',315274.37,NULL,NULL,1,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(660,7847,40736,6102,3,646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',92549.17,NULL,NULL,1,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(661,7847,40736,6102,3,647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',1385.99,NULL,NULL,1,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(662,7847,40736,6102,3,648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',48893.65,NULL,NULL,1,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(663,7847,40736,6102,3,649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',37315.53,NULL,NULL,1,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(664,7847,40736,6102,3,650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',163086.11,NULL,NULL,1,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(665,7847,40736,6102,3,651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',36588.17,NULL,NULL,1,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(666,7847,40736,6102,3,652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',54734.94,NULL,NULL,1,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(667,7847,40736,6102,3,653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',24000.00,NULL,NULL,1,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL);
INSERT INTO `balance_libro` VALUES (668,7847,40736,6102,3,654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',839.99,NULL,NULL,1,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(669,7847,40736,6102,3,655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',839.99,NULL,NULL,1,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(670,7847,40736,6102,3,656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',1743.01,NULL,NULL,1,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(671,7847,40736,6102,3,657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',1385.99,NULL,NULL,1,'2023-02-24 11:52:53','2023-02-24 11:52:53',NULL),(672,7847,40736,6102,3,658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',1743.01,NULL,NULL,1,'2023-02-24 11:52:53','2023-02-24 11:52:53',NULL),(673,7847,40736,6102,3,659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',5600.00,NULL,NULL,1,'2023-02-24 11:52:53','2023-02-24 11:52:53',NULL),(674,7847,40736,6102,3,660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',610480.26,NULL,NULL,1,'2023-02-24 11:52:53','2023-02-24 11:52:53',NULL),(675,7847,40736,6102,3,661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',0.00,NULL,NULL,1,'2023-02-24 11:52:53','2023-02-24 11:52:53',NULL),(676,7847,40720,1534,2,662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',20800.00,NULL,NULL,1,'2023-03-28 10:43:34','2023-03-28 10:43:34',NULL),(677,7847,40720,1534,2,663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',29510.00,NULL,NULL,1,'2023-03-28 10:43:34','2023-03-28 10:43:34',NULL),(678,7847,40720,1534,3,664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',14900.50,NULL,NULL,1,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(679,7847,40720,1534,3,665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',27767.52,NULL,NULL,1,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(680,7847,40720,1534,3,666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',10903.17,NULL,NULL,1,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(681,7847,40720,1534,3,667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',19000.00,NULL,NULL,1,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(682,7847,40720,1534,3,668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',264500.07,NULL,NULL,1,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(683,7847,40720,1534,3,669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',400000.11,NULL,NULL,1,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(684,7847,40720,1534,3,670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',338999.00,NULL,NULL,1,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(685,7847,40720,1534,3,671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',200000.05,NULL,NULL,1,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(686,7847,40720,1534,3,672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',300007.40,NULL,NULL,1,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(687,7847,40720,1534,3,673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',300001.35,NULL,NULL,1,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL);
/*!40000 ALTER TABLE `balance_libro` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro_details`
--

DROP TABLE IF EXISTS `balance_libro_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `balance_libro_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_details_person_id_foreign` (`person_id`),
  KEY `balance_libro_details_period_id_foreign` (`period_id`),
  KEY `balance_libro_details_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_details_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_libro_details_saldo_id_foreign` (`saldo_id`),
  KEY `balance_libro_details_balance_libro_id_foreign` (`balance_libro_id`),
  CONSTRAINT `balance_libro_details_balance_libro_id_foreign` FOREIGN KEY (`balance_libro_id`) REFERENCES `balance_libro` (`id`) ON DELETE CASCADE,
  CONSTRAINT `balance_libro_details_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_details_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `balance_libro_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1918 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro_details`
--

LOCK TABLES `balance_libro_details` WRITE;
/*!40000 ALTER TABLE `balance_libro_details` DISABLE KEYS */;
INSERT INTO `balance_libro_details` VALUES (1,7847,1,40721,4586,2,218,2,80000.00,NULL,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(2,7847,1,40721,4586,2,13,1,80000.00,NULL,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(3,7847,2,40721,4586,2,218,2,40000.00,NULL,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(4,7847,2,40721,4586,2,13,1,40000.00,NULL,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(5,7847,3,40721,4586,2,218,2,80000.00,NULL,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(6,7847,3,40721,4586,2,13,1,80000.00,NULL,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(7,7847,4,40721,4586,2,218,2,5000.00,NULL,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(8,7847,4,40721,4586,2,13,1,5000.00,NULL,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(9,7847,5,40721,4586,2,218,2,76000.00,NULL,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(10,7847,5,40721,4586,2,13,1,76000.00,NULL,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(11,7847,6,40721,4586,2,218,2,78900.00,NULL,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(12,7847,6,40721,4586,2,13,1,78900.00,NULL,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(13,7847,7,40721,4586,2,218,2,100000.00,NULL,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(14,7847,7,40721,4586,2,13,1,100000.00,NULL,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(15,7847,8,40721,4586,2,218,2,100000.00,NULL,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(16,7847,8,40721,4586,2,13,1,100000.00,NULL,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(17,7847,9,40721,4586,3,217,1,2409.00,NULL,'2022-10-05 11:08:06','2022-10-05 11:08:06',NULL),(18,7847,9,40721,4586,3,68,1,505.89,NULL,'2022-10-05 11:08:06','2022-10-05 11:08:06',NULL),(19,7847,9,40721,4586,3,57,2,2914.89,NULL,'2022-10-05 11:08:06','2022-10-05 11:08:06',NULL),(20,7847,10,40721,4586,3,217,1,9227.27,NULL,'2022-10-05 11:08:06','2022-10-05 11:08:06',NULL),(21,7847,10,40721,4586,3,68,1,1937.73,NULL,'2022-10-05 11:08:06','2022-10-05 11:08:06',NULL),(22,7847,10,40721,4586,3,57,2,11165.00,NULL,'2022-10-05 11:08:06','2022-10-05 11:08:06',NULL),(23,7847,11,40721,4586,3,217,1,593.90,NULL,'2022-10-05 11:08:06','2022-10-05 11:08:06',NULL),(24,7847,11,40721,4586,3,68,1,124.72,NULL,'2022-10-05 11:08:06','2022-10-05 11:08:06',NULL),(25,7847,11,40721,4586,3,57,2,718.62,NULL,'2022-10-05 11:08:06','2022-10-05 11:08:06',NULL),(26,7847,12,40721,4586,3,250,1,49500.00,NULL,'2022-10-05 11:08:06','2022-10-05 11:08:06',NULL),(27,7847,12,40721,4586,3,57,2,49500.00,NULL,'2022-10-05 11:08:06','2022-10-05 11:08:06',NULL),(28,7847,13,40721,4585,2,96,2,1054.48,NULL,'2022-10-05 11:44:50','2022-10-05 11:44:50',NULL),(29,7847,13,40721,4585,2,67,2,221.44,NULL,'2022-10-05 11:44:50','2022-10-05 11:44:50',NULL),(30,7847,13,40721,4585,2,13,1,1275.92,NULL,'2022-10-05 11:44:50','2022-10-05 11:44:50',NULL),(31,7847,14,40721,4585,2,96,2,593.90,NULL,'2022-10-05 11:44:50','2022-10-05 11:44:50',NULL),(32,7847,14,40721,4585,2,67,2,124.72,NULL,'2022-10-05 11:44:50','2022-10-05 11:44:50',NULL),(33,7847,14,40721,4585,2,13,1,718.62,NULL,'2022-10-05 11:44:50','2022-10-05 11:44:50',NULL),(34,7847,15,40721,4585,2,96,2,1862.81,NULL,'2022-10-05 11:44:50','2022-10-05 11:44:50',NULL),(35,7847,15,40721,4585,2,67,2,391.19,NULL,'2022-10-05 11:44:50','2022-10-05 11:44:50',NULL),(36,7847,15,40721,4585,2,13,1,2254.00,NULL,'2022-10-05 11:44:50','2022-10-05 11:44:50',NULL),(37,7847,16,40721,4585,2,218,2,80000.00,NULL,'2022-10-05 11:45:17','2022-10-05 11:45:17',NULL),(38,7847,16,40721,4585,2,13,1,80000.00,NULL,'2022-10-05 11:45:17','2022-10-05 11:45:17',NULL),(39,7847,17,40721,4585,2,218,2,90000.00,NULL,'2022-10-05 11:45:17','2022-10-05 11:45:17',NULL),(40,7847,17,40721,4585,2,13,1,90000.00,NULL,'2022-10-05 11:45:17','2022-10-05 11:45:17',NULL),(41,7847,18,40721,4585,2,218,2,60000.00,NULL,'2022-10-05 11:45:17','2022-10-05 11:45:17',NULL),(42,7847,18,40721,4585,2,13,1,60000.00,NULL,'2022-10-05 11:45:17','2022-10-05 11:45:17',NULL);
INSERT INTO `balance_libro_details` VALUES (43,7847,19,40721,4585,2,218,2,100000.00,NULL,'2022-10-05 11:45:17','2022-10-05 11:45:17',NULL),(44,7847,19,40721,4585,2,13,1,100000.00,NULL,'2022-10-05 11:45:17','2022-10-05 11:45:17',NULL),(45,7847,20,40721,4585,3,217,1,1054.48,NULL,'2022-10-05 11:46:32','2022-10-05 11:46:32',NULL),(46,7847,20,40721,4585,3,68,1,221.44,NULL,'2022-10-05 11:46:32','2022-10-05 11:46:32',NULL),(47,7847,20,40721,4585,3,57,2,1275.92,NULL,'2022-10-05 11:46:32','2022-10-05 11:46:32',NULL),(48,7847,21,40721,4585,3,217,1,593.90,NULL,'2022-10-05 11:46:32','2022-10-05 11:46:32',NULL),(49,7847,21,40721,4585,3,68,1,124.72,NULL,'2022-10-05 11:46:32','2022-10-05 11:46:32',NULL),(50,7847,21,40721,4585,3,57,2,718.62,NULL,'2022-10-05 11:46:32','2022-10-05 11:46:32',NULL),(51,7847,22,40721,4585,3,217,1,1862.81,NULL,'2022-10-05 11:46:32','2022-10-05 11:46:32',NULL),(52,7847,22,40721,4585,3,68,1,391.19,NULL,'2022-10-05 11:46:32','2022-10-05 11:46:32',NULL),(53,7847,22,40721,4585,3,57,2,2254.00,NULL,'2022-10-05 11:46:32','2022-10-05 11:46:32',NULL),(54,7847,23,40721,4585,2,218,2,70000.00,NULL,'2022-10-05 11:49:00','2022-10-05 11:49:00',NULL),(55,7847,23,40721,4585,2,13,1,70000.00,NULL,'2022-10-05 11:49:00','2022-10-05 11:49:00',NULL),(56,7847,24,40736,6100,2,96,2,12903.31,NULL,'2022-10-30 07:14:02','2022-11-23 12:22:26','2022-11-23 12:22:26'),(57,7847,24,40736,6100,2,67,2,2709.69,NULL,'2022-10-30 07:14:02','2022-11-23 12:22:26','2022-11-23 12:22:26'),(58,7847,24,40736,6100,2,13,1,15613.00,NULL,'2022-10-30 07:14:02','2022-11-23 12:22:26','2022-11-23 12:22:26'),(59,7847,25,40736,6100,2,96,2,4628.10,NULL,'2022-10-30 07:14:02','2022-11-23 12:22:06','2022-11-23 12:22:06'),(60,7847,25,40736,6100,2,67,2,971.90,NULL,'2022-10-30 07:14:02','2022-11-23 12:22:06','2022-11-23 12:22:06'),(61,7847,25,40736,6100,2,13,1,5600.00,NULL,'2022-10-30 07:14:02','2022-11-23 12:22:06','2022-11-23 12:22:06'),(62,7847,26,40736,6100,2,96,2,2603.31,NULL,'2022-10-30 07:14:02','2022-11-23 12:22:23','2022-11-23 12:22:23'),(63,7847,26,40736,6100,2,67,2,546.69,NULL,'2022-10-30 07:14:02','2022-11-23 12:22:23','2022-11-23 12:22:23'),(64,7847,26,40736,6100,2,13,1,3150.00,NULL,'2022-10-30 07:14:02','2022-11-23 12:22:23','2022-11-23 12:22:23'),(65,7847,27,40736,6100,2,96,2,16595.87,NULL,'2022-10-30 07:14:02','2022-11-23 12:22:19','2022-11-23 12:22:19'),(66,7847,27,40736,6100,2,67,2,3485.13,NULL,'2022-10-30 07:14:02','2022-11-23 12:22:19','2022-11-23 12:22:19'),(67,7847,27,40736,6100,2,13,1,20081.00,NULL,'2022-10-30 07:14:02','2022-11-23 12:22:19','2022-11-23 12:22:19'),(68,7847,28,40736,6100,2,96,2,2479.34,NULL,'2022-10-30 07:14:02','2022-11-23 12:22:14','2022-11-23 12:22:14'),(69,7847,28,40736,6100,2,67,2,520.66,NULL,'2022-10-30 07:14:02','2022-11-23 12:22:14','2022-11-23 12:22:14'),(70,7847,28,40736,6100,2,13,1,3000.00,NULL,'2022-10-30 07:14:02','2022-11-23 12:22:14','2022-11-23 12:22:14'),(71,7847,29,40736,6100,2,96,2,4710.74,NULL,'2022-10-30 07:14:02','2022-11-23 12:22:10','2022-11-23 12:22:10'),(72,7847,29,40736,6100,2,67,2,989.26,NULL,'2022-10-30 07:14:02','2022-11-23 12:22:10','2022-11-23 12:22:10'),(73,7847,29,40736,6100,2,13,1,5700.00,NULL,'2022-10-30 07:14:02','2022-11-23 12:22:10','2022-11-23 12:22:10'),(74,7847,30,40736,6100,2,96,2,3925.62,NULL,'2022-10-30 07:14:02','2022-11-23 12:22:30','2022-11-23 12:22:30'),(75,7847,30,40736,6100,2,67,2,824.38,NULL,'2022-10-30 07:14:02','2022-11-23 12:22:30','2022-11-23 12:22:30'),(76,7847,30,40736,6100,2,13,1,4750.00,NULL,'2022-10-30 07:14:02','2022-11-23 12:22:30','2022-11-23 12:22:30'),(77,7847,31,40736,6100,2,96,2,3305.79,NULL,'2022-10-30 07:14:02','2022-11-23 12:22:34','2022-11-23 12:22:34'),(78,7847,31,40736,6100,2,67,2,694.21,NULL,'2022-10-30 07:14:02','2022-11-23 12:22:34','2022-11-23 12:22:34'),(79,7847,31,40736,6100,2,13,1,4000.00,NULL,'2022-10-30 07:14:02','2022-11-23 12:22:34','2022-11-23 12:22:34'),(80,7847,32,40736,6100,2,96,2,5909.09,NULL,'2022-10-30 07:14:02','2022-11-23 12:22:38','2022-11-23 12:22:38');
INSERT INTO `balance_libro_details` VALUES (81,7847,32,40736,6100,2,67,2,1240.91,NULL,'2022-10-30 07:14:02','2022-11-23 12:22:38','2022-11-23 12:22:38'),(82,7847,32,40736,6100,2,13,1,7150.00,NULL,'2022-10-30 07:14:02','2022-11-23 12:22:38','2022-11-23 12:22:38'),(83,7847,33,40736,6100,2,96,2,9926.45,NULL,'2022-10-30 07:14:02','2022-11-23 12:22:41','2022-11-23 12:22:41'),(84,7847,33,40736,6100,2,67,2,2084.55,NULL,'2022-10-30 07:14:02','2022-11-23 12:22:41','2022-11-23 12:22:41'),(85,7847,33,40736,6100,2,13,1,12011.00,NULL,'2022-10-30 07:14:02','2022-11-23 12:22:41','2022-11-23 12:22:41'),(86,7847,34,40736,6100,2,96,2,1652.89,NULL,'2022-10-30 07:14:14','2022-11-23 12:22:47','2022-11-23 12:22:47'),(87,7847,34,40736,6100,2,67,2,347.11,NULL,'2022-10-30 07:14:14','2022-11-23 12:22:47','2022-11-23 12:22:47'),(88,7847,34,40736,6100,2,13,1,2000.00,NULL,'2022-10-30 07:14:14','2022-11-23 12:22:47','2022-11-23 12:22:47'),(89,7847,35,40736,6100,2,96,2,2148.76,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:58','2022-11-23 12:21:58'),(90,7847,35,40736,6100,2,67,2,451.24,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:58','2022-11-23 12:21:58'),(91,7847,35,40736,6100,2,13,1,2600.00,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:58','2022-11-23 12:21:58'),(92,7847,36,40736,6100,2,96,2,5090.91,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:55','2022-11-23 12:21:55'),(93,7847,36,40736,6100,2,67,2,1069.09,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:55','2022-11-23 12:21:55'),(94,7847,36,40736,6100,2,13,1,6160.00,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:55','2022-11-23 12:21:55'),(95,7847,37,40736,6100,2,96,2,3859.50,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:51','2022-11-23 12:21:51'),(96,7847,37,40736,6100,2,67,2,810.50,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:51','2022-11-23 12:21:51'),(97,7847,37,40736,6100,2,13,1,4670.00,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:51','2022-11-23 12:21:51'),(98,7847,38,40736,6100,2,96,2,2165.29,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:47','2022-11-23 12:21:47'),(99,7847,38,40736,6100,2,67,2,454.71,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:47','2022-11-23 12:21:47'),(100,7847,38,40736,6100,2,13,1,2620.00,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:47','2022-11-23 12:21:47'),(101,7847,39,40736,6100,2,96,2,5024.79,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:43','2022-11-23 12:21:43'),(102,7847,39,40736,6100,2,67,2,1055.21,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:43','2022-11-23 12:21:43'),(103,7847,39,40736,6100,2,13,1,6080.00,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:43','2022-11-23 12:21:43'),(104,7847,40,40736,6100,2,96,2,2942.15,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:36','2022-11-23 12:21:36'),(105,7847,40,40736,6100,2,67,2,617.85,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:36','2022-11-23 12:21:36'),(106,7847,40,40736,6100,2,13,1,3560.00,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:36','2022-11-23 12:21:36'),(107,7847,41,40736,6100,2,96,2,17355.37,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:33','2022-11-23 12:21:33'),(108,7847,41,40736,6100,2,67,2,3644.63,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:33','2022-11-23 12:21:33'),(109,7847,41,40736,6100,2,13,1,21000.00,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:33','2022-11-23 12:21:33'),(110,7847,42,40736,6100,2,96,2,3305.79,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:29','2022-11-23 12:21:29'),(111,7847,42,40736,6100,2,67,2,694.21,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:29','2022-11-23 12:21:29'),(112,7847,42,40736,6100,2,13,1,4000.00,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:29','2022-11-23 12:21:29'),(113,7847,43,40736,6100,2,96,2,1479.34,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:25','2022-11-23 12:21:25'),(114,7847,43,40736,6100,2,67,2,310.66,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:25','2022-11-23 12:21:25'),(115,7847,43,40736,6100,2,13,1,1790.00,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:25','2022-11-23 12:21:25'),(116,7847,44,40736,6100,2,96,2,3471.07,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:21','2022-11-23 12:21:21');
INSERT INTO `balance_libro_details` VALUES (117,7847,44,40736,6100,2,67,2,728.93,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:21','2022-11-23 12:21:21'),(118,7847,44,40736,6100,2,13,1,4200.00,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:21','2022-11-23 12:21:21'),(119,7847,45,40736,6100,2,96,2,3504.96,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:17','2022-11-23 12:21:17'),(120,7847,45,40736,6100,2,67,2,736.04,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:17','2022-11-23 12:21:17'),(121,7847,45,40736,6100,2,13,1,4241.00,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:17','2022-11-23 12:21:17'),(122,7847,46,40736,6100,2,96,2,4041.32,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:13','2022-11-23 12:21:13'),(123,7847,46,40736,6100,2,67,2,848.68,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:13','2022-11-23 12:21:13'),(124,7847,46,40736,6100,2,13,1,4890.00,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:13','2022-11-23 12:21:13'),(125,7847,47,40736,6100,2,96,2,785.12,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:09','2022-11-23 12:21:09'),(126,7847,47,40736,6100,2,67,2,164.88,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:09','2022-11-23 12:21:09'),(127,7847,47,40736,6100,2,13,1,950.00,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:09','2022-11-23 12:21:09'),(128,7847,48,40736,6100,2,96,2,11826.45,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:06','2022-11-23 12:21:06'),(129,7847,48,40736,6100,2,67,2,2483.55,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:06','2022-11-23 12:21:06'),(130,7847,48,40736,6100,2,13,1,14310.00,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:06','2022-11-23 12:21:06'),(131,7847,49,40736,6100,2,96,2,743.80,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:02','2022-11-23 12:21:02'),(132,7847,49,40736,6100,2,67,2,156.20,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:02','2022-11-23 12:21:02'),(133,7847,49,40736,6100,2,13,1,900.00,NULL,'2022-10-30 07:14:14','2022-11-23 12:21:02','2022-11-23 12:21:02'),(134,7847,50,40736,6100,2,96,2,2975.21,NULL,'2022-10-30 07:14:14','2022-11-23 12:20:58','2022-11-23 12:20:58'),(135,7847,50,40736,6100,2,67,2,624.79,NULL,'2022-10-30 07:14:14','2022-11-23 12:20:58','2022-11-23 12:20:58'),(136,7847,50,40736,6100,2,13,1,3600.00,NULL,'2022-10-30 07:14:14','2022-11-23 12:20:58','2022-11-23 12:20:58'),(137,7847,51,40736,6100,2,96,2,15710.74,NULL,'2022-10-30 07:14:14','2022-11-23 12:20:54','2022-11-23 12:20:54'),(138,7847,51,40736,6100,2,67,2,3299.26,NULL,'2022-10-30 07:14:14','2022-11-23 12:20:54','2022-11-23 12:20:54'),(139,7847,51,40736,6100,2,13,1,19010.00,NULL,'2022-10-30 07:14:14','2022-11-23 12:20:54','2022-11-23 12:20:54'),(140,7847,52,40736,6100,2,96,2,17272.73,NULL,'2022-10-30 07:14:14','2022-11-23 12:20:49','2022-11-23 12:20:49'),(141,7847,52,40736,6100,2,67,2,3627.27,NULL,'2022-10-30 07:14:14','2022-11-23 12:20:49','2022-11-23 12:20:49'),(142,7847,52,40736,6100,2,13,1,20900.00,NULL,'2022-10-30 07:14:14','2022-11-23 12:20:49','2022-11-23 12:20:49'),(143,7847,53,40736,6100,2,96,2,5785.12,NULL,'2022-10-30 07:14:14','2022-11-23 12:20:13','2022-11-23 12:20:13'),(144,7847,53,40736,6100,2,67,2,1214.88,NULL,'2022-10-30 07:14:14','2022-11-23 12:20:13','2022-11-23 12:20:13'),(145,7847,53,40736,6100,2,13,1,7000.00,NULL,'2022-10-30 07:14:14','2022-11-23 12:20:13','2022-11-23 12:20:13'),(146,7847,54,40736,6100,2,96,2,9322.31,NULL,'2022-10-30 07:14:14','2022-11-23 12:19:53','2022-11-23 12:19:53'),(147,7847,54,40736,6100,2,67,2,1957.69,NULL,'2022-10-30 07:14:14','2022-11-23 12:19:53','2022-11-23 12:19:53'),(148,7847,54,40736,6100,2,13,1,11280.00,NULL,'2022-10-30 07:14:14','2022-11-23 12:19:53','2022-11-23 12:19:53'),(149,7847,55,40736,6100,2,96,2,3099.17,NULL,'2022-10-30 07:14:14','2022-11-23 12:19:30','2022-11-23 12:19:30'),(150,7847,55,40736,6100,2,67,2,650.83,NULL,'2022-10-30 07:14:14','2022-11-23 12:19:30','2022-11-23 12:19:30'),(151,7847,55,40736,6100,2,13,1,3750.00,NULL,'2022-10-30 07:14:14','2022-11-23 12:19:30','2022-11-23 12:19:30'),(152,7847,56,40736,6100,2,96,2,6719.01,NULL,'2022-10-30 07:14:14','2022-11-23 12:19:48','2022-11-23 12:19:48');
INSERT INTO `balance_libro_details` VALUES (153,7847,56,40736,6100,2,67,2,1410.99,NULL,'2022-10-30 07:14:14','2022-11-23 12:19:48','2022-11-23 12:19:48'),(154,7847,56,40736,6100,2,13,1,8130.00,NULL,'2022-10-30 07:14:14','2022-11-23 12:19:48','2022-11-23 12:19:48'),(155,7847,57,40736,6100,2,96,2,5260.33,NULL,'2022-10-30 07:14:14','2022-11-23 12:19:43','2022-11-23 12:19:43'),(156,7847,57,40736,6100,2,67,2,1104.67,NULL,'2022-10-30 07:14:14','2022-11-23 12:19:43','2022-11-23 12:19:43'),(157,7847,57,40736,6100,2,13,1,6365.00,NULL,'2022-10-30 07:14:14','2022-11-23 12:19:43','2022-11-23 12:19:43'),(158,7847,58,40721,3030,2,218,2,70000.00,NULL,'2022-11-08 12:30:54','2022-11-08 12:30:54',NULL),(159,7847,58,40721,3030,2,13,1,70000.00,NULL,'2022-11-08 12:30:54','2022-11-08 12:30:54',NULL),(160,7847,59,40721,3030,2,218,2,80000.00,NULL,'2022-11-08 12:30:54','2022-11-08 12:30:54',NULL),(161,7847,59,40721,3030,2,13,1,80000.00,NULL,'2022-11-08 12:30:54','2022-11-08 12:30:54',NULL),(162,7847,60,40721,3030,2,218,2,85000.00,NULL,'2022-11-08 12:30:54','2022-11-08 12:30:54',NULL),(163,7847,60,40721,3030,2,13,1,85000.00,NULL,'2022-11-08 12:30:54','2022-11-08 12:30:54',NULL),(164,7847,61,40721,3030,3,217,1,1581.82,NULL,'2022-11-08 12:31:34','2022-11-08 12:31:34',NULL),(165,7847,61,40721,3030,3,68,1,332.18,NULL,'2022-11-08 12:31:34','2022-11-08 12:31:34',NULL),(166,7847,61,40721,3030,3,57,2,1914.00,NULL,'2022-11-08 12:31:34','2022-11-08 12:31:34',NULL),(167,7847,62,40721,3030,3,217,1,1984.58,NULL,'2022-11-08 12:31:34','2022-11-08 12:31:34',NULL),(168,7847,62,40721,3030,3,68,1,416.76,NULL,'2022-11-08 12:31:34','2022-11-08 12:31:34',NULL),(169,7847,62,40721,3030,3,57,2,2401.34,NULL,'2022-11-08 12:31:34','2022-11-08 12:31:34',NULL),(170,7847,63,40721,3030,3,217,1,593.90,NULL,'2022-11-08 12:31:34','2022-11-08 12:31:34',NULL),(171,7847,63,40721,3030,3,68,1,124.72,NULL,'2022-11-08 12:31:34','2022-11-08 12:31:34',NULL),(172,7847,63,40721,3030,3,57,2,718.62,NULL,'2022-11-08 12:31:34','2022-11-08 12:31:34',NULL),(173,7847,64,40721,3030,3,217,1,2478.51,NULL,'2022-11-08 12:31:34','2022-11-08 12:31:34',NULL),(174,7847,64,40721,3030,3,68,1,520.49,NULL,'2022-11-08 12:31:34','2022-11-08 12:31:34',NULL),(175,7847,64,40721,3030,3,57,2,2999.00,NULL,'2022-11-08 12:31:34','2022-11-08 12:31:34',NULL),(176,7847,65,40721,3030,3,217,1,33057.02,NULL,'2022-11-08 12:31:34','2022-11-08 12:31:34',NULL),(177,7847,65,40721,3030,3,68,1,6941.98,NULL,'2022-11-08 12:31:34','2022-11-08 12:31:34',NULL),(178,7847,65,40721,3030,3,57,2,39999.00,NULL,'2022-11-08 12:31:34','2022-11-08 12:31:34',NULL),(179,7847,66,40721,3030,3,217,1,35962.81,NULL,'2022-11-08 12:31:35','2022-11-08 12:31:35',NULL),(180,7847,66,40721,3030,3,68,1,7552.19,NULL,'2022-11-08 12:31:35','2022-11-08 12:31:35',NULL),(181,7847,66,40721,3030,3,57,2,43515.00,NULL,'2022-11-08 12:31:35','2022-11-08 12:31:35',NULL),(182,7847,67,40745,7820,2,218,2,518.00,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(183,7847,67,40745,7820,2,13,1,518.00,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(184,7847,68,40745,7820,2,218,2,664.00,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(185,7847,68,40745,7820,2,13,1,664.00,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(186,7847,69,40745,7820,2,218,2,1390.00,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(187,7847,69,40745,7820,2,13,1,1390.00,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(188,7847,70,40745,7820,2,218,2,710.00,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(189,7847,70,40745,7820,2,13,1,710.00,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(190,7847,71,40745,7820,2,218,2,580.00,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(191,7847,71,40745,7820,2,13,1,580.00,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(192,7847,72,40745,7820,2,218,2,745.00,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(193,7847,72,40745,7820,2,13,1,745.00,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL);
INSERT INTO `balance_libro_details` VALUES (194,7847,73,40745,7820,2,218,2,669.00,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(195,7847,73,40745,7820,2,13,1,669.00,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(196,7847,74,40745,7820,2,218,2,382.00,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(197,7847,74,40745,7820,2,13,1,382.00,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(198,7847,75,40745,7820,2,218,2,2796.00,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(199,7847,75,40745,7820,2,13,1,2796.00,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(200,7847,76,40745,7820,2,218,2,1080.00,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(201,7847,76,40745,7820,2,13,1,1080.00,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(202,7847,77,40745,7820,2,218,2,960.00,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(203,7847,77,40745,7820,2,13,1,960.00,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(204,7847,78,40745,7820,2,218,2,1510.00,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(205,7847,78,40745,7820,2,13,1,1510.00,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(206,7847,79,40745,7820,2,218,2,406.00,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(207,7847,79,40745,7820,2,13,1,406.00,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(208,7847,80,40745,7820,2,218,2,820.00,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(209,7847,80,40745,7820,2,13,1,820.00,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(210,7847,81,40745,7820,2,218,2,700.00,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(211,7847,81,40745,7820,2,13,1,700.00,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(212,7847,82,40745,7820,2,218,2,990.00,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(213,7847,82,40745,7820,2,13,1,990.00,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(214,7847,83,40745,7820,2,218,2,860.00,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(215,7847,83,40745,7820,2,13,1,860.00,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(216,7847,84,40745,7820,2,218,2,1400.00,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(217,7847,84,40745,7820,2,13,1,1400.00,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(218,7847,85,40745,7820,2,218,2,580.00,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(219,7847,85,40745,7820,2,13,1,580.00,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(220,7847,86,40745,7820,2,218,2,3490.00,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(221,7847,86,40745,7820,2,13,1,3490.00,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(222,7847,87,40745,7820,2,218,2,600.00,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(223,7847,87,40745,7820,2,13,1,600.00,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(224,7847,88,40745,7820,2,218,2,774.00,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(225,7847,88,40745,7820,2,13,1,774.00,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(226,7847,89,40745,7820,2,218,2,930.00,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(227,7847,89,40745,7820,2,13,1,930.00,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(228,7847,90,40745,7820,2,218,2,610.00,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(229,7847,90,40745,7820,2,13,1,610.00,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(230,7847,91,40745,7820,2,218,2,1380.00,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(231,7847,91,40745,7820,2,13,1,1380.00,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(232,7847,92,40745,7820,2,218,2,790.00,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(233,7847,92,40745,7820,2,13,1,790.00,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(234,7847,93,40745,7820,2,218,2,1070.00,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(235,7847,93,40745,7820,2,13,1,1070.00,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL);
INSERT INTO `balance_libro_details` VALUES (236,7847,94,40745,7820,2,218,2,370.00,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(237,7847,94,40745,7820,2,13,1,370.00,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(238,7847,95,40745,7820,2,218,2,485.00,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(239,7847,95,40745,7820,2,13,1,485.00,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(240,7847,96,40745,7820,2,218,2,920.00,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(241,7847,96,40745,7820,2,13,1,920.00,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(242,7847,97,40745,7820,2,218,2,4100.00,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(243,7847,97,40745,7820,2,13,1,4100.00,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(244,7847,98,40745,7820,2,218,2,240.00,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(245,7847,98,40745,7820,2,13,1,240.00,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(246,7847,99,40745,7820,2,218,2,380.00,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(247,7847,99,40745,7820,2,13,1,380.00,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(248,7847,100,40745,7820,2,218,2,1750.00,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(249,7847,100,40745,7820,2,13,1,1750.00,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(250,7847,101,40745,7820,2,218,2,459.00,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(251,7847,101,40745,7820,2,13,1,459.00,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(252,7847,102,40745,7820,2,218,2,881.00,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(253,7847,102,40745,7820,2,13,1,881.00,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(254,7847,103,40745,7820,2,218,2,650.00,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(255,7847,103,40745,7820,2,13,1,650.00,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(256,7847,104,40745,7820,2,218,2,473.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(257,7847,104,40745,7820,2,13,1,473.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(258,7847,105,40745,7820,2,218,2,1574.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(259,7847,105,40745,7820,2,13,1,1574.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(260,7847,106,40745,7820,2,218,2,960.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(261,7847,106,40745,7820,2,13,1,960.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(262,7847,107,40745,7820,2,218,2,833.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(263,7847,107,40745,7820,2,13,1,833.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(264,7847,108,40745,7820,2,218,2,500.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(265,7847,108,40745,7820,2,13,1,500.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(266,7847,109,40745,7820,2,218,2,2820.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(267,7847,109,40745,7820,2,13,1,2820.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(268,7847,110,40745,7820,2,218,2,650.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(269,7847,110,40745,7820,2,13,1,650.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(270,7847,111,40745,7820,2,218,2,378.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(271,7847,111,40745,7820,2,13,1,378.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(272,7847,112,40745,7820,2,218,2,1420.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(273,7847,112,40745,7820,2,13,1,1420.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(274,7847,113,40745,7820,2,218,2,950.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(275,7847,113,40745,7820,2,13,1,950.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(276,7847,114,40745,7820,2,218,2,866.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(277,7847,114,40745,7820,2,13,1,866.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL);
INSERT INTO `balance_libro_details` VALUES (278,7847,115,40745,7820,2,218,2,990.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(279,7847,115,40745,7820,2,13,1,990.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(280,7847,116,40745,7820,2,218,2,1300.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(281,7847,116,40745,7820,2,13,1,1300.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(282,7847,117,40745,7820,2,218,2,960.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(283,7847,117,40745,7820,2,13,1,960.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(284,7847,118,40745,7820,2,218,2,710.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(285,7847,118,40745,7820,2,13,1,710.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(286,7847,119,40745,7820,2,218,2,3050.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(287,7847,119,40745,7820,2,13,1,3050.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(288,7847,120,40745,7820,2,218,2,260.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(289,7847,120,40745,7820,2,13,1,260.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(290,7847,121,40745,7820,2,218,2,800.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(291,7847,121,40745,7820,2,13,1,800.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(292,7847,122,40745,7820,2,218,2,500.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(293,7847,122,40745,7820,2,13,1,500.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(294,7847,123,40745,7820,2,218,2,710.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(295,7847,123,40745,7820,2,13,1,710.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(296,7847,124,40745,7820,2,218,2,980.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(297,7847,124,40745,7820,2,13,1,980.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(298,7847,125,40745,7820,2,218,2,650.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(299,7847,125,40745,7820,2,13,1,650.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(300,7847,126,40745,7820,2,218,2,1100.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(301,7847,126,40745,7820,2,13,1,1100.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(302,7847,127,40745,7820,2,218,2,3810.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(303,7847,127,40745,7820,2,13,1,3810.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(304,7847,128,40745,7820,2,218,2,460.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(305,7847,128,40745,7820,2,13,1,460.00,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(306,7847,129,40745,7820,2,218,2,770.00,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(307,7847,129,40745,7820,2,13,1,770.00,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(308,7847,130,40745,7820,2,218,2,910.00,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(309,7847,130,40745,7820,2,13,1,910.00,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(310,7847,131,40745,7820,2,218,2,5580.00,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(311,7847,131,40745,7820,2,13,1,5580.00,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(312,7847,132,40745,7820,2,218,2,440.00,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(313,7847,132,40745,7820,2,13,1,440.00,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(314,7847,133,40745,7820,2,218,2,800.00,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(315,7847,133,40745,7820,2,13,1,800.00,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(316,7847,134,40745,7820,2,218,2,960.00,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(317,7847,134,40745,7820,2,13,1,960.00,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(318,7847,135,40745,7820,2,218,2,1113.00,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(319,7847,135,40745,7820,2,13,1,1113.00,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL);
INSERT INTO `balance_libro_details` VALUES (320,7847,136,40745,7820,2,218,2,2700.00,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(321,7847,136,40745,7820,2,13,1,2700.00,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(322,7847,137,40745,7820,2,218,2,500.00,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(323,7847,137,40745,7820,2,13,1,500.00,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(324,7847,138,40745,7820,2,218,2,1540.00,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(325,7847,138,40745,7820,2,13,1,1540.00,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(326,7847,139,40745,7820,2,218,2,893.00,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(327,7847,139,40745,7820,2,13,1,893.00,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(328,7847,140,40745,7820,2,218,2,1910.00,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(329,7847,140,40745,7820,2,13,1,1910.00,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(330,7847,141,40745,7820,2,218,2,3560.00,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(331,7847,141,40745,7820,2,13,1,3560.00,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(332,7847,142,40745,7820,2,218,2,480.00,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(333,7847,142,40745,7820,2,13,1,480.00,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(334,7847,143,40745,7820,2,218,2,700.00,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(335,7847,143,40745,7820,2,13,1,700.00,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(336,7847,144,40745,7820,2,218,2,1500.00,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(337,7847,144,40745,7820,2,13,1,1500.00,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(338,7847,145,40745,7820,2,218,2,690.00,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(339,7847,145,40745,7820,2,13,1,690.00,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(340,7847,146,40745,7820,2,218,2,1380.00,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(341,7847,146,40745,7820,2,13,1,1380.00,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(342,7847,147,40745,7820,2,218,2,570.00,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(343,7847,147,40745,7820,2,13,1,570.00,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(344,7847,148,40745,7820,2,218,2,835.00,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(345,7847,148,40745,7820,2,13,1,835.00,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(346,7847,149,40745,7820,2,218,2,1900.00,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(347,7847,149,40745,7820,2,13,1,1900.00,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(348,7847,150,40745,7820,2,218,2,2760.00,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(349,7847,150,40745,7820,2,13,1,2760.00,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(350,7847,151,40745,7820,2,218,2,1800.00,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(351,7847,151,40745,7820,2,13,1,1800.00,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(352,7847,152,40745,7820,2,218,2,1100.00,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(353,7847,152,40745,7820,2,13,1,1100.00,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(354,7847,153,40745,7820,2,218,2,1540.00,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(355,7847,153,40745,7820,2,13,1,1540.00,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(356,7847,154,40745,7820,2,218,2,810.00,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(357,7847,154,40745,7820,2,13,1,810.00,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(358,7847,155,40745,7820,2,218,2,1000.00,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(359,7847,155,40745,7820,2,13,1,1000.00,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(360,7847,156,40745,7820,2,218,2,650.00,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(361,7847,156,40745,7820,2,13,1,650.00,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL);
INSERT INTO `balance_libro_details` VALUES (362,7847,157,40745,7820,2,218,2,1736.00,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(363,7847,157,40745,7820,2,13,1,1736.00,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(364,7847,158,40745,7820,2,218,2,449.00,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(365,7847,158,40745,7820,2,13,1,449.00,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(366,7847,159,40745,7820,2,218,2,1300.00,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(367,7847,159,40745,7820,2,13,1,1300.00,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(368,7847,160,40745,7820,2,218,2,940.00,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(369,7847,160,40745,7820,2,13,1,940.00,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(370,7847,161,40745,7820,2,218,2,716.00,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(371,7847,161,40745,7820,2,13,1,716.00,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(372,7847,162,40745,7820,2,218,2,399.00,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(373,7847,162,40745,7820,2,13,1,399.00,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(374,7847,163,40745,7820,2,218,2,1500.00,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(375,7847,163,40745,7820,2,13,1,1500.00,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(376,7847,164,40745,7820,2,218,2,700.00,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(377,7847,164,40745,7820,2,13,1,700.00,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(378,7847,165,40745,7820,2,218,2,882.00,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(379,7847,165,40745,7820,2,13,1,882.00,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(380,7847,166,40745,7820,2,218,2,1940.00,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(381,7847,166,40745,7820,2,13,1,1940.00,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(382,7847,167,40745,7820,2,218,2,2050.00,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(383,7847,167,40745,7820,2,13,1,2050.00,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(384,7847,168,40745,7820,2,218,2,1100.00,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(385,7847,168,40745,7820,2,13,1,1100.00,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(386,7847,169,40745,7820,2,218,2,805.00,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(387,7847,169,40745,7820,2,13,1,805.00,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(388,7847,170,40745,7820,2,218,2,3450.00,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(389,7847,170,40745,7820,2,13,1,3450.00,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(390,7847,171,40745,7820,2,218,2,1000.00,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(391,7847,171,40745,7820,2,13,1,1000.00,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(392,7847,172,40745,7820,2,218,2,960.00,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(393,7847,172,40745,7820,2,13,1,960.00,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(394,7847,173,40745,7820,2,218,2,520.00,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(395,7847,173,40745,7820,2,13,1,520.00,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(396,7847,174,40745,7820,2,218,2,1280.00,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(397,7847,174,40745,7820,2,13,1,1280.00,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(398,7847,175,40745,7820,2,218,2,775.00,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(399,7847,175,40745,7820,2,13,1,775.00,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(400,7847,176,40745,7820,2,218,2,932.00,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(401,7847,176,40745,7820,2,13,1,932.00,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(402,7847,177,40745,7820,2,218,2,2100.00,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(403,7847,177,40745,7820,2,13,1,2100.00,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL);
INSERT INTO `balance_libro_details` VALUES (404,7847,178,40745,7820,2,218,2,500.00,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(405,7847,178,40745,7820,2,13,1,500.00,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(406,7847,179,40745,7820,2,218,2,970.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(407,7847,179,40745,7820,2,13,1,970.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(408,7847,180,40745,7820,2,218,2,600.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(409,7847,180,40745,7820,2,13,1,600.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(410,7847,181,40745,7820,2,218,2,2280.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(411,7847,181,40745,7820,2,13,1,2280.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(412,7847,182,40745,7820,2,218,2,1600.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(413,7847,182,40745,7820,2,13,1,1600.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(414,7847,183,40745,7820,2,218,2,1450.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(415,7847,183,40745,7820,2,13,1,1450.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(416,7847,184,40745,7820,2,218,2,810.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(417,7847,184,40745,7820,2,13,1,810.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(418,7847,185,40745,7820,2,218,2,740.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(419,7847,185,40745,7820,2,13,1,740.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(420,7847,186,40745,7820,2,218,2,995.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(421,7847,186,40745,7820,2,13,1,995.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(422,7847,187,40745,7820,2,218,2,730.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(423,7847,187,40745,7820,2,13,1,730.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(424,7847,188,40745,7820,2,218,2,1800.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(425,7847,188,40745,7820,2,13,1,1800.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(426,7847,189,40745,7820,2,218,2,4910.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(427,7847,189,40745,7820,2,13,1,4910.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(428,7847,190,40745,7820,2,218,2,875.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(429,7847,190,40745,7820,2,13,1,875.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(430,7847,191,40745,7820,2,218,2,3000.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(431,7847,191,40745,7820,2,13,1,3000.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(432,7847,192,40745,7820,2,218,2,450.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(433,7847,192,40745,7820,2,13,1,450.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(434,7847,193,40745,7820,2,218,2,910.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(435,7847,193,40745,7820,2,13,1,910.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(436,7847,194,40745,7820,2,218,2,1700.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(437,7847,194,40745,7820,2,13,1,1700.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(438,7847,195,40745,7820,2,218,2,620.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(439,7847,195,40745,7820,2,13,1,620.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(440,7847,196,40745,7820,2,218,2,370.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(441,7847,196,40745,7820,2,13,1,370.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(442,7847,197,40745,7820,2,218,2,900.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(443,7847,197,40745,7820,2,13,1,900.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(444,7847,198,40745,7820,2,218,2,300.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(445,7847,198,40745,7820,2,13,1,300.00,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL);
INSERT INTO `balance_libro_details` VALUES (446,7847,199,40745,7820,2,218,2,1720.00,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(447,7847,199,40745,7820,2,13,1,1720.00,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(448,7847,200,40745,7820,2,218,2,900.00,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(449,7847,200,40745,7820,2,13,1,900.00,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(450,7847,201,40745,7820,2,218,2,2500.00,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(451,7847,201,40745,7820,2,13,1,2500.00,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(452,7847,202,40745,7820,2,218,2,1830.00,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(453,7847,202,40745,7820,2,13,1,1830.00,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(454,7847,203,40745,7820,2,218,2,1000.00,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(455,7847,203,40745,7820,2,13,1,1000.00,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(456,7847,204,40745,7820,2,218,2,870.00,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(457,7847,204,40745,7820,2,13,1,870.00,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(458,7847,205,40745,7820,2,218,2,1415.00,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(459,7847,205,40745,7820,2,13,1,1415.00,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(460,7847,206,40745,7820,2,218,2,2890.00,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(461,7847,206,40745,7820,2,13,1,2890.00,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(462,7847,207,40745,7820,2,218,2,8300.00,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(463,7847,207,40745,7820,2,13,1,8300.00,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(464,7847,208,40745,7820,2,218,2,775.00,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(465,7847,208,40745,7820,2,13,1,775.00,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(466,7847,209,40745,7820,2,218,2,1435.00,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(467,7847,209,40745,7820,2,13,1,1435.00,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(468,7847,210,40745,7820,2,218,2,960.00,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(469,7847,210,40745,7820,2,13,1,960.00,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(470,7847,211,40745,7820,2,218,2,880.00,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(471,7847,211,40745,7820,2,13,1,880.00,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(472,7847,212,40745,7820,2,218,2,3460.00,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(473,7847,212,40745,7820,2,13,1,3460.00,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(474,7847,213,40745,7820,2,218,2,1800.00,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(475,7847,213,40745,7820,2,13,1,1800.00,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(476,7847,214,40745,7820,3,217,1,5899.00,NULL,'2022-11-08 15:00:13','2022-11-08 15:00:13',NULL),(477,7847,214,40745,7820,3,57,2,5899.00,NULL,'2022-11-08 15:00:13','2022-11-08 15:00:13',NULL),(478,7847,215,40745,7820,3,217,1,2482.00,NULL,'2022-11-08 15:00:13','2022-11-08 15:00:13',NULL),(479,7847,215,40745,7820,3,57,2,2482.00,NULL,'2022-11-08 15:00:13','2022-11-08 15:00:13',NULL),(480,7847,216,40745,7820,3,217,1,16174.73,NULL,'2022-11-08 15:00:14','2022-11-08 15:00:14',NULL),(481,7847,216,40745,7820,3,68,1,3396.70,NULL,'2022-11-08 15:00:14','2022-11-08 15:00:14',NULL),(482,7847,216,40745,7820,3,57,2,19571.43,NULL,'2022-11-08 15:00:14','2022-11-08 15:00:14',NULL),(483,7847,217,40745,7820,3,217,1,9615.90,NULL,'2022-11-08 15:00:14','2022-11-08 15:00:14',NULL),(484,7847,217,40745,7820,3,68,1,2019.34,NULL,'2022-11-08 15:00:14','2022-11-08 15:00:14',NULL),(485,7847,217,40745,7820,3,57,2,11635.24,NULL,'2022-11-08 15:00:14','2022-11-08 15:00:14',NULL),(486,7847,218,40745,7820,3,217,1,37694.15,NULL,'2022-11-08 15:00:14','2022-11-08 15:00:14',NULL),(487,7847,218,40745,7820,3,68,1,7429.07,NULL,'2022-11-08 15:00:14','2022-11-08 15:00:14',NULL);
INSERT INTO `balance_libro_details` VALUES (488,7847,218,40745,7820,3,57,2,45123.22,NULL,'2022-11-08 15:00:14','2022-11-08 15:00:14',NULL),(489,7847,219,40745,7820,3,217,1,12316.81,NULL,'2022-11-08 15:00:14','2022-11-08 15:00:14',NULL),(490,7847,219,40745,7820,3,68,1,2586.53,NULL,'2022-11-08 15:00:14','2022-11-08 15:00:14',NULL),(491,7847,219,40745,7820,3,57,2,14903.34,NULL,'2022-11-08 15:00:14','2022-11-08 15:00:14',NULL),(492,7847,220,40745,7820,3,217,1,22133.50,NULL,'2022-11-08 15:00:14','2022-11-08 15:00:14',NULL),(493,7847,220,40745,7820,3,68,1,4648.03,NULL,'2022-11-08 15:00:14','2022-11-08 15:00:14',NULL),(494,7847,220,40745,7820,3,57,2,26781.53,NULL,'2022-11-08 15:00:14','2022-11-08 15:00:14',NULL),(495,7847,221,40719,13,2,218,2,24000.00,NULL,'2022-11-15 10:57:14','2022-11-15 10:57:14',NULL),(496,7847,221,40719,13,2,13,1,24000.00,NULL,'2022-11-15 10:57:14','2022-11-15 10:57:14',NULL),(497,7847,222,40719,13,2,218,2,12000.00,NULL,'2022-11-15 11:06:09','2022-11-15 11:06:09',NULL),(498,7847,222,40719,13,2,13,1,12000.00,NULL,'2022-11-15 11:06:09','2022-11-15 11:06:09',NULL),(499,7847,223,40751,35105,2,218,2,4800.00,NULL,'2022-11-16 15:00:13','2022-11-16 15:00:13',NULL),(500,7847,223,40751,35105,2,13,1,4800.00,NULL,'2022-11-16 15:00:13','2022-11-16 15:00:13',NULL),(501,7847,224,40751,35105,2,218,2,5600.00,NULL,'2022-11-16 15:00:13','2022-11-16 15:00:13',NULL),(502,7847,224,40751,35105,2,13,1,5600.00,NULL,'2022-11-16 15:00:13','2022-11-16 15:00:13',NULL),(503,7847,225,40751,35105,2,218,2,5000.00,NULL,'2022-11-16 15:00:13','2022-11-16 15:00:13',NULL),(504,7847,225,40751,35105,2,13,1,5000.00,NULL,'2022-11-16 15:00:13','2022-11-16 15:00:13',NULL),(505,7847,226,40751,35105,2,218,2,5500.00,NULL,'2022-11-16 15:00:13','2022-11-16 15:00:13',NULL),(506,7847,226,40751,35105,2,13,1,5500.00,NULL,'2022-11-16 15:00:13','2022-11-16 15:00:13',NULL),(507,7847,227,40751,35105,2,218,2,5500.00,NULL,'2022-11-16 15:00:13','2022-11-16 15:00:13',NULL),(508,7847,227,40751,35105,2,13,1,5500.00,NULL,'2022-11-16 15:00:13','2022-11-16 15:00:13',NULL),(509,7847,228,40751,35105,2,218,2,13000.00,NULL,'2022-11-16 15:00:13','2022-11-16 15:00:13',NULL),(510,7847,228,40751,35105,2,13,1,13000.00,NULL,'2022-11-16 15:00:13','2022-11-16 15:00:13',NULL),(511,7847,229,40751,35105,2,218,2,6500.00,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(512,7847,229,40751,35105,2,13,1,6500.00,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(513,7847,230,40751,35105,2,218,2,4000.00,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(514,7847,230,40751,35105,2,13,1,4000.00,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(515,7847,231,40751,35105,2,218,2,6450.00,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(516,7847,231,40751,35105,2,13,1,6450.00,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(517,7847,232,40751,35105,2,218,2,13000.00,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(518,7847,232,40751,35105,2,13,1,13000.00,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(519,7847,233,40751,35105,2,218,2,2500.00,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(520,7847,233,40751,35105,2,13,1,2500.00,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(521,7847,234,40751,35105,2,218,2,3080.00,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(522,7847,234,40751,35105,2,13,1,3080.00,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(523,7847,235,40751,35105,2,218,2,13000.00,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(524,7847,235,40751,35105,2,13,1,13000.00,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(525,7847,236,40751,35105,2,218,2,6800.00,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(526,7847,236,40751,35105,2,13,1,6800.00,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(527,7847,237,40751,35105,2,218,2,13000.00,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(528,7847,237,40751,35105,2,13,1,13000.00,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL);
INSERT INTO `balance_libro_details` VALUES (529,7847,238,40751,35105,2,218,2,4500.00,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(530,7847,238,40751,35105,2,13,1,4500.00,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(531,7847,239,40751,35105,2,218,2,7800.00,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(532,7847,239,40751,35105,2,13,1,7800.00,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(533,7847,240,40751,35105,2,218,2,13000.00,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(534,7847,240,40751,35105,2,13,1,13000.00,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(535,7847,241,40751,35105,2,218,2,11400.00,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(536,7847,241,40751,35105,2,13,1,11400.00,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(537,7847,242,40751,35105,2,218,2,4180.00,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(538,7847,242,40751,35105,2,13,1,4180.00,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(539,7847,243,40751,35105,2,218,2,4800.00,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(540,7847,243,40751,35105,2,13,1,4800.00,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(541,7847,244,40751,35105,3,217,1,1139.15,NULL,'2022-11-22 17:13:45','2022-11-22 17:13:45',NULL),(542,7847,244,40751,35105,3,68,1,239.22,NULL,'2022-11-22 17:13:45','2022-11-22 17:13:45',NULL),(543,7847,244,40751,35105,3,57,2,1378.37,NULL,'2022-11-22 17:13:45','2022-11-22 17:13:45',NULL),(544,7847,245,40751,35105,3,250,1,11500.00,NULL,'2022-11-22 17:13:45','2022-11-22 17:13:45',NULL),(545,7847,245,40751,35105,3,57,2,11500.00,NULL,'2022-11-22 17:13:45','2022-11-22 17:13:45',NULL),(546,7847,246,40751,35105,3,217,1,6611.57,NULL,'2022-11-22 17:13:45','2022-11-22 17:13:45',NULL),(547,7847,246,40751,35105,3,68,1,1388.43,NULL,'2022-11-22 17:13:45','2022-11-22 17:13:45',NULL),(548,7847,246,40751,35105,3,57,2,8000.00,NULL,'2022-11-22 17:13:45','2022-11-22 17:13:45',NULL),(549,7847,247,40736,6100,3,217,1,238309.41,NULL,'2022-11-23 10:13:03','2022-11-23 10:13:03',NULL),(550,7847,247,40736,6100,3,68,1,50044.97,NULL,'2022-11-23 10:13:03','2022-11-23 10:13:03',NULL),(551,7847,247,40736,6100,3,57,2,288354.38,NULL,'2022-11-23 10:13:03','2022-11-23 10:13:03',NULL),(552,7847,248,40736,6100,3,217,1,81301.94,NULL,'2022-11-23 10:13:03','2022-11-23 10:13:03',NULL),(553,7847,248,40736,6100,3,68,1,17073.41,NULL,'2022-11-23 10:13:03','2022-11-23 10:13:03',NULL),(554,7847,248,40736,6100,3,57,2,98375.35,NULL,'2022-11-23 10:13:03','2022-11-23 10:13:03',NULL),(555,7847,249,40736,6100,3,217,1,6335.00,NULL,'2022-11-23 10:13:03','2022-11-23 10:13:03',NULL),(556,7847,249,40736,6100,3,68,1,1330.35,NULL,'2022-11-23 10:13:03','2022-11-23 10:13:03',NULL),(557,7847,249,40736,6100,3,217,1,190.05,NULL,'2022-11-23 10:13:03','2022-11-23 10:13:03',NULL),(558,7847,249,40736,6100,3,57,2,7855.40,NULL,'2022-11-23 10:13:03','2022-11-23 10:13:03',NULL),(559,7847,250,40736,6100,3,217,1,5978.70,NULL,'2022-11-23 10:13:03','2022-11-23 10:13:03',NULL),(560,7847,250,40736,6100,3,68,1,1255.53,NULL,'2022-11-23 10:13:03','2022-11-23 10:13:03',NULL),(561,7847,250,40736,6100,3,57,2,7234.23,NULL,'2022-11-23 10:13:03','2022-11-23 10:13:03',NULL),(562,7847,251,40736,6100,3,217,1,15282.00,NULL,'2022-11-23 10:13:03','2022-11-23 10:13:03',NULL),(563,7847,251,40736,6100,3,68,1,3209.22,NULL,'2022-11-23 10:13:03','2022-11-23 10:13:03',NULL),(564,7847,251,40736,6100,3,57,2,18491.22,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(565,7847,252,40736,6100,3,217,1,3981.90,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(566,7847,252,40736,6100,3,68,1,418.10,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(567,7847,252,40736,6100,3,57,2,4400.00,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(568,7847,253,40736,6100,3,217,1,607.44,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(569,7847,253,40736,6100,3,68,1,127.56,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL);
INSERT INTO `balance_libro_details` VALUES (570,7847,253,40736,6100,3,57,2,735.00,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(571,7847,254,40736,6100,3,217,1,911.16,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(572,7847,254,40736,6100,3,68,1,191.34,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(573,7847,254,40736,6100,3,57,2,1102.50,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(574,7847,255,40736,6100,3,217,1,1206.20,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(575,7847,255,40736,6100,3,68,1,253.30,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(576,7847,255,40736,6100,3,57,2,1459.50,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(577,7847,256,40736,6100,3,217,1,87848.96,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(578,7847,256,40736,6100,3,68,1,18448.28,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(579,7847,256,40736,6100,3,57,2,106297.24,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(580,7847,257,40736,6100,3,217,1,1990.95,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(581,7847,257,40736,6100,3,68,1,209.05,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(582,7847,257,40736,6100,3,57,2,2200.00,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(583,7847,258,40736,6100,3,217,1,1990.95,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(584,7847,258,40736,6100,3,68,1,209.05,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(585,7847,258,40736,6100,3,57,2,2200.00,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(586,7847,259,40736,6100,3,217,1,5429.86,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(587,7847,259,40736,6100,3,68,1,570.14,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(588,7847,259,40736,6100,3,57,2,6000.00,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(589,7847,260,40736,6100,3,217,1,59466.60,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(590,7847,260,40736,6100,3,68,1,12487.99,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(591,7847,260,40736,6100,3,57,2,71954.59,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(592,7847,261,40736,6100,3,217,1,607.44,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(593,7847,261,40736,6100,3,68,1,127.56,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(594,7847,261,40736,6100,3,57,2,735.00,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(595,7847,262,40736,6100,3,217,1,954.55,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(596,7847,262,40736,6100,3,68,1,200.46,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(597,7847,262,40736,6100,3,57,2,1155.01,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(598,7847,263,40736,6100,3,217,1,1206.20,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(599,7847,263,40736,6100,3,68,1,253.30,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(600,7847,263,40736,6100,3,57,2,1459.50,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(601,7847,264,40736,6100,3,217,1,503.31,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(602,7847,264,40736,6100,3,68,1,105.70,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(603,7847,264,40736,6100,3,57,2,609.01,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(604,7847,265,40736,6100,3,217,1,4072.40,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(605,7847,265,40736,6100,3,68,1,427.60,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(606,7847,265,40736,6100,3,57,2,4500.00,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(607,7847,266,40736,6100,3,217,1,23904.00,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(608,7847,266,40736,6100,3,68,1,5019.84,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(609,7847,266,40736,6100,3,57,2,28923.84,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(610,7847,267,40736,6100,3,217,1,20243.00,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(611,7847,267,40736,6100,3,68,1,4251.03,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL);
INSERT INTO `balance_libro_details` VALUES (612,7847,267,40736,6100,3,57,2,24494.03,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(613,7847,268,40736,6100,3,217,1,954.55,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(614,7847,268,40736,6100,3,68,1,200.46,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(615,7847,268,40736,6100,3,57,2,1155.01,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(616,7847,269,40736,6100,3,217,1,75915.00,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(617,7847,269,40736,6100,3,68,1,15942.15,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(618,7847,269,40736,6100,3,57,2,91857.15,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(619,7847,270,40736,6100,3,217,1,457056.00,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(620,7847,270,40736,6100,3,68,1,95981.76,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(621,7847,270,40736,6100,3,57,2,553037.76,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(622,7847,271,40736,6100,3,217,1,2714.93,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(623,7847,271,40736,6100,3,68,1,285.07,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(624,7847,271,40736,6100,3,57,2,3000.00,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(625,7847,272,40736,6100,3,217,2,75915.00,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(626,7847,272,40736,6100,3,67,2,15942.15,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(627,7847,272,40736,6100,3,57,1,91857.15,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(628,7847,273,40736,6100,3,217,1,4072.40,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(629,7847,273,40736,6100,3,68,1,427.60,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(630,7847,273,40736,6100,3,57,2,4500.00,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(631,7847,274,40736,6100,3,217,1,58876.80,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(632,7847,274,40736,6100,3,68,1,12364.13,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(633,7847,274,40736,6100,3,57,2,71240.93,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(634,7847,275,40736,6100,3,217,1,4072.40,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(635,7847,275,40736,6100,3,68,1,427.60,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(636,7847,275,40736,6100,3,57,2,4500.00,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(637,7847,276,40736,6100,3,217,1,4072.40,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(638,7847,276,40736,6100,3,68,1,427.60,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(639,7847,276,40736,6100,3,57,2,4500.00,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(640,7847,277,40736,6100,3,217,1,4132.23,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(641,7847,277,40736,6100,3,68,1,867.77,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(642,7847,277,40736,6100,3,57,2,5000.00,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(643,7847,278,40736,6100,3,217,1,4261.56,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(644,7847,278,40736,6100,3,68,1,894.93,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(645,7847,278,40736,6100,3,217,1,-0.01,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(646,7847,278,40736,6100,3,57,2,5156.48,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(647,7847,279,40736,6100,3,217,1,607.44,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(648,7847,279,40736,6100,3,68,1,127.56,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(649,7847,279,40736,6100,3,57,2,735.00,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(650,7847,280,40736,6100,3,217,1,607.44,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(651,7847,280,40736,6100,3,68,1,127.56,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(652,7847,280,40736,6100,3,57,2,735.00,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(653,7847,281,40736,6100,3,217,1,152761.38,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL);
INSERT INTO `balance_libro_details` VALUES (654,7847,281,40736,6100,3,68,1,32079.89,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(655,7847,281,40736,6100,3,57,2,184841.27,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(656,7847,282,40736,6100,3,217,1,1206.20,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(657,7847,282,40736,6100,3,68,1,253.30,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(658,7847,282,40736,6100,3,57,2,1459.50,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(659,7847,283,40736,6100,3,217,1,911.16,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(660,7847,283,40736,6100,3,68,1,191.34,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(661,7847,283,40736,6100,3,57,2,1102.50,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(662,7847,284,40736,6100,3,217,1,4072.40,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(663,7847,284,40736,6100,3,68,1,427.60,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(664,7847,284,40736,6100,3,57,2,4500.00,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(665,7847,285,40736,6100,3,217,1,6787.33,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(666,7847,285,40736,6100,3,68,1,712.67,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(667,7847,285,40736,6100,3,57,2,7500.00,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(668,7847,286,40736,6100,3,217,1,5429.86,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(669,7847,286,40736,6100,3,68,1,570.14,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(670,7847,286,40736,6100,3,57,2,6000.00,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(671,7847,287,40736,6100,3,250,1,24000.00,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(672,7847,287,40736,6100,3,57,2,24000.00,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(673,7847,288,40736,6100,3,217,1,5429.86,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(674,7847,288,40736,6100,3,68,1,570.14,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(675,7847,288,40736,6100,3,57,2,6000.00,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(676,7847,289,40736,6100,3,217,1,90704.79,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(677,7847,289,40736,6100,3,68,1,19048.01,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(678,7847,289,40736,6100,3,57,2,109752.80,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(679,7847,290,40736,6100,3,217,1,88014.88,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(680,7847,290,40736,6100,3,68,1,18483.12,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(681,7847,290,40736,6100,3,57,2,106498.00,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(682,7847,291,40736,6100,3,217,1,607.44,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(683,7847,291,40736,6100,3,68,1,127.56,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(684,7847,291,40736,6100,3,57,2,735.00,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(685,7847,292,40736,6100,3,217,1,607.44,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(686,7847,292,40736,6100,3,68,1,127.56,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(687,7847,292,40736,6100,3,57,2,735.00,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(688,7847,293,40736,6100,3,217,1,954.55,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(689,7847,293,40736,6100,3,68,1,200.46,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(690,7847,293,40736,6100,3,57,2,1155.01,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(691,7847,294,40736,6100,3,217,1,42781.04,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(692,7847,294,40736,6100,3,68,1,4492.01,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(693,7847,294,40736,6100,3,57,2,47273.05,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(694,7847,295,40736,6100,3,217,1,8237.04,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(695,7847,295,40736,6100,3,68,1,1697.20,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL);
INSERT INTO `balance_libro_details` VALUES (696,7847,295,40736,6100,3,217,1,1089.35,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(697,7847,295,40736,6100,3,57,2,11023.59,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(698,7847,296,40736,6100,3,217,1,5429.86,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(699,7847,296,40736,6100,3,68,1,570.14,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(700,7847,296,40736,6100,3,57,2,6000.00,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(701,7847,297,40736,6100,3,217,1,1206.20,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(702,7847,297,40736,6100,3,68,1,253.30,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(703,7847,297,40736,6100,3,57,2,1459.50,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(704,7847,298,40736,6100,3,217,1,14789.91,NULL,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(705,7847,298,40736,6100,3,68,1,3105.88,NULL,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(706,7847,298,40736,6100,3,57,2,17895.79,NULL,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(707,7847,299,40736,6100,3,250,1,41200.00,NULL,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(708,7847,299,40736,6100,3,57,2,41200.00,NULL,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(709,7847,300,40736,6100,3,217,1,167152.86,NULL,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(710,7847,300,40736,6100,3,68,1,35102.10,NULL,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(711,7847,300,40736,6100,3,57,2,202254.96,NULL,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(712,7847,301,40736,6100,3,217,1,215832.00,NULL,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(713,7847,301,40736,6100,3,68,1,45324.72,NULL,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(714,7847,301,40736,6100,3,217,1,6474.96,NULL,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(715,7847,301,40736,6100,3,57,2,267631.68,NULL,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(716,7847,302,40736,6100,3,217,1,33960.00,NULL,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(717,7847,302,40736,6100,3,68,1,7131.60,NULL,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(718,7847,302,40736,6100,3,57,2,41091.60,NULL,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(719,7847,303,40736,6100,3,217,1,457056.00,NULL,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(720,7847,303,40736,6100,3,68,1,95981.76,NULL,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(721,7847,303,40736,6100,3,57,2,553037.76,NULL,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(722,7847,304,40736,6100,3,250,1,0.00,NULL,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(723,7847,304,40736,6100,3,57,2,0.00,NULL,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(724,7847,305,40736,6100,2,96,2,4214.88,NULL,'2022-11-23 11:38:02','2022-11-23 12:19:39','2022-11-23 12:19:39'),(725,7847,305,40736,6100,2,67,2,885.12,NULL,'2022-11-23 11:38:02','2022-11-23 12:19:39','2022-11-23 12:19:39'),(726,7847,305,40736,6100,2,13,1,5100.00,NULL,'2022-11-23 11:38:02','2022-11-23 12:19:39','2022-11-23 12:19:39'),(727,7847,306,40736,6100,2,96,2,5049.59,NULL,'2022-11-23 11:38:02','2022-11-23 12:19:34','2022-11-23 12:19:34'),(728,7847,306,40736,6100,2,67,2,1060.41,NULL,'2022-11-23 11:38:02','2022-11-23 12:19:34','2022-11-23 12:19:34'),(729,7847,306,40736,6100,2,13,1,6110.00,NULL,'2022-11-23 11:38:02','2022-11-23 12:19:34','2022-11-23 12:19:34'),(730,7847,307,40736,6100,2,96,2,5768.60,NULL,'2022-11-23 11:38:02','2022-11-23 12:19:19','2022-11-23 12:19:19'),(731,7847,307,40736,6100,2,67,2,1211.40,NULL,'2022-11-23 11:38:02','2022-11-23 12:19:19','2022-11-23 12:19:19'),(732,7847,307,40736,6100,2,13,1,6980.00,NULL,'2022-11-23 11:38:02','2022-11-23 12:19:19','2022-11-23 12:19:19'),(733,7847,308,40736,6100,2,96,2,55000.00,NULL,'2022-11-23 11:38:02','2022-11-23 12:19:15','2022-11-23 12:19:15'),(734,7847,308,40736,6100,2,67,2,11550.00,NULL,'2022-11-23 11:38:02','2022-11-23 12:19:15','2022-11-23 12:19:15');
INSERT INTO `balance_libro_details` VALUES (735,7847,308,40736,6100,2,13,1,66550.00,NULL,'2022-11-23 11:38:02','2022-11-23 12:19:15','2022-11-23 12:19:15'),(736,7847,309,40736,6100,2,96,2,1652.89,NULL,'2022-11-23 12:24:11','2022-11-23 12:24:11',NULL),(737,7847,309,40736,6100,2,67,2,347.11,NULL,'2022-11-23 12:24:11','2022-11-23 12:24:11',NULL),(738,7847,309,40736,6100,2,13,1,2000.00,NULL,'2022-11-23 12:24:11','2022-11-23 12:24:11',NULL),(739,7847,310,40736,6100,2,96,2,2148.76,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(740,7847,310,40736,6100,2,67,2,451.24,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(741,7847,310,40736,6100,2,13,1,2600.00,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(742,7847,311,40736,6100,2,96,2,5090.91,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(743,7847,311,40736,6100,2,67,2,1069.09,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(744,7847,311,40736,6100,2,13,1,6160.00,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(745,7847,312,40736,6100,2,96,2,3859.50,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(746,7847,312,40736,6100,2,67,2,810.50,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(747,7847,312,40736,6100,2,13,1,4670.00,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(748,7847,313,40736,6100,2,96,2,2165.29,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(749,7847,313,40736,6100,2,67,2,454.71,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(750,7847,313,40736,6100,2,13,1,2620.00,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(751,7847,314,40736,6100,2,96,2,5024.79,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(752,7847,314,40736,6100,2,67,2,1055.21,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(753,7847,314,40736,6100,2,13,1,6080.00,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(754,7847,315,40736,6100,2,96,2,2942.15,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(755,7847,315,40736,6100,2,67,2,617.85,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(756,7847,315,40736,6100,2,13,1,3560.00,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(757,7847,316,40736,6100,2,96,2,17355.37,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(758,7847,316,40736,6100,2,67,2,3644.63,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(759,7847,316,40736,6100,2,13,1,21000.00,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(760,7847,317,40736,6100,2,96,2,3305.79,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(761,7847,317,40736,6100,2,67,2,694.21,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(762,7847,317,40736,6100,2,13,1,4000.00,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(763,7847,318,40736,6100,2,96,2,1479.34,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(764,7847,318,40736,6100,2,67,2,310.66,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(765,7847,318,40736,6100,2,13,1,1790.00,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(766,7847,319,40736,6100,2,96,2,3471.07,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(767,7847,319,40736,6100,2,67,2,728.93,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(768,7847,319,40736,6100,2,13,1,4200.00,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(769,7847,320,40736,6100,2,96,2,3504.96,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(770,7847,320,40736,6100,2,67,2,736.04,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(771,7847,320,40736,6100,2,13,1,4241.00,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(772,7847,321,40736,6100,2,96,2,4041.32,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(773,7847,321,40736,6100,2,67,2,848.68,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(774,7847,321,40736,6100,2,13,1,4890.00,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(775,7847,322,40736,6100,2,96,2,785.12,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(776,7847,322,40736,6100,2,67,2,164.88,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL);
INSERT INTO `balance_libro_details` VALUES (777,7847,322,40736,6100,2,13,1,950.00,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(778,7847,323,40736,6100,2,96,2,11826.45,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(779,7847,323,40736,6100,2,67,2,2483.55,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(780,7847,323,40736,6100,2,13,1,14310.00,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(781,7847,324,40736,6100,2,96,2,743.80,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(782,7847,324,40736,6100,2,67,2,156.20,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(783,7847,324,40736,6100,2,13,1,900.00,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(784,7847,325,40736,6100,2,96,2,2975.21,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(785,7847,325,40736,6100,2,67,2,624.79,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(786,7847,325,40736,6100,2,13,1,3600.00,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(787,7847,326,40736,6100,2,96,2,15710.74,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(788,7847,326,40736,6100,2,67,2,3299.26,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(789,7847,326,40736,6100,2,13,1,19010.00,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(790,7847,327,40736,6100,2,96,2,17272.73,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(791,7847,327,40736,6100,2,67,2,3627.27,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(792,7847,327,40736,6100,2,13,1,20900.00,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(793,7847,328,40736,6100,2,96,2,5785.12,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(794,7847,328,40736,6100,2,67,2,1214.88,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(795,7847,328,40736,6100,2,13,1,7000.00,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(796,7847,329,40736,6100,2,96,2,9322.31,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(797,7847,329,40736,6100,2,67,2,1957.69,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(798,7847,329,40736,6100,2,13,1,11280.00,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(799,7847,330,40736,6100,2,96,2,3099.17,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(800,7847,330,40736,6100,2,67,2,650.83,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(801,7847,330,40736,6100,2,13,1,3750.00,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(802,7847,331,40736,6100,2,96,2,6719.01,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(803,7847,331,40736,6100,2,67,2,1410.99,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(804,7847,331,40736,6100,2,13,1,8130.00,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(805,7847,332,40736,6100,2,96,2,5260.33,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(806,7847,332,40736,6100,2,67,2,1104.67,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(807,7847,332,40736,6100,2,13,1,6365.00,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(808,7847,333,40736,6100,2,96,2,4214.88,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(809,7847,333,40736,6100,2,67,2,885.12,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(810,7847,333,40736,6100,2,13,1,5100.00,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(811,7847,334,40736,6100,2,96,2,5049.59,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(812,7847,334,40736,6100,2,67,2,1060.41,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(813,7847,334,40736,6100,2,13,1,6110.00,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(814,7847,335,40736,6100,2,96,2,5768.60,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(815,7847,335,40736,6100,2,67,2,1211.40,NULL,'2022-11-23 12:24:13','2022-11-23 12:24:13',NULL),(816,7847,335,40736,6100,2,13,1,6980.00,NULL,'2022-11-23 12:24:13','2022-11-23 12:24:13',NULL),(817,7847,336,40736,6100,2,96,2,55000.00,NULL,'2022-11-23 12:24:13','2022-11-23 12:24:13',NULL),(818,7847,336,40736,6100,2,67,2,11550.00,NULL,'2022-11-23 12:24:13','2022-11-23 12:24:13',NULL);
INSERT INTO `balance_libro_details` VALUES (819,7847,336,40736,6100,2,13,1,66550.00,NULL,'2022-11-23 12:24:13','2022-11-23 12:24:13',NULL),(820,7847,337,40736,6100,2,96,2,12903.31,NULL,'2022-11-23 12:24:27','2022-11-23 12:24:27',NULL),(821,7847,337,40736,6100,2,67,2,2709.69,NULL,'2022-11-23 12:24:27','2022-11-23 12:24:27',NULL),(822,7847,337,40736,6100,2,13,1,15613.00,NULL,'2022-11-23 12:24:27','2022-11-23 12:24:27',NULL),(823,7847,338,40736,6100,2,96,2,4628.10,NULL,'2022-11-23 12:24:27','2022-11-23 12:24:27',NULL),(824,7847,338,40736,6100,2,67,2,971.90,NULL,'2022-11-23 12:24:27','2022-11-23 12:24:27',NULL),(825,7847,338,40736,6100,2,13,1,5600.00,NULL,'2022-11-23 12:24:27','2022-11-23 12:24:27',NULL),(826,7847,339,40736,6100,2,96,2,2603.31,NULL,'2022-11-23 12:24:27','2022-11-23 12:24:27',NULL),(827,7847,339,40736,6100,2,67,2,546.69,NULL,'2022-11-23 12:24:27','2022-11-23 12:24:27',NULL),(828,7847,339,40736,6100,2,13,1,3150.00,NULL,'2022-11-23 12:24:27','2022-11-23 12:24:27',NULL),(829,7847,340,40736,6100,2,96,2,16595.87,NULL,'2022-11-23 12:24:27','2022-11-23 12:24:27',NULL),(830,7847,340,40736,6100,2,67,2,3485.13,NULL,'2022-11-23 12:24:27','2022-11-23 12:24:27',NULL),(831,7847,340,40736,6100,2,13,1,20081.00,NULL,'2022-11-23 12:24:27','2022-11-23 12:24:27',NULL),(832,7847,341,40736,6100,2,96,2,2479.34,NULL,'2022-11-23 12:24:27','2022-11-23 12:24:27',NULL),(833,7847,341,40736,6100,2,67,2,520.66,NULL,'2022-11-23 12:24:27','2022-11-23 12:24:27',NULL),(834,7847,341,40736,6100,2,13,1,3000.00,NULL,'2022-11-23 12:24:27','2022-11-23 12:24:27',NULL),(835,7847,342,40736,6100,2,96,2,4710.74,NULL,'2022-11-23 12:24:28','2022-11-23 12:24:28',NULL),(836,7847,342,40736,6100,2,67,2,989.26,NULL,'2022-11-23 12:24:28','2022-11-23 12:24:28',NULL),(837,7847,342,40736,6100,2,13,1,5700.00,NULL,'2022-11-23 12:24:28','2022-11-23 12:24:28',NULL),(838,7847,343,40736,6100,2,96,2,3925.62,NULL,'2022-11-23 12:24:28','2022-11-23 12:24:28',NULL),(839,7847,343,40736,6100,2,67,2,824.38,NULL,'2022-11-23 12:24:28','2022-11-23 12:24:28',NULL),(840,7847,343,40736,6100,2,13,1,4750.00,NULL,'2022-11-23 12:24:28','2022-11-23 12:24:28',NULL),(841,7847,344,40736,6100,2,96,2,3305.79,NULL,'2022-11-23 12:24:28','2022-11-23 12:24:28',NULL),(842,7847,344,40736,6100,2,67,2,694.21,NULL,'2022-11-23 12:24:28','2022-11-23 12:24:28',NULL),(843,7847,344,40736,6100,2,13,1,4000.00,NULL,'2022-11-23 12:24:28','2022-11-23 12:24:28',NULL),(844,7847,345,40736,6100,2,96,2,5909.09,NULL,'2022-11-23 12:24:28','2022-11-23 12:24:28',NULL),(845,7847,345,40736,6100,2,67,2,1240.91,NULL,'2022-11-23 12:24:28','2022-11-23 12:24:28',NULL),(846,7847,345,40736,6100,2,13,1,7150.00,NULL,'2022-11-23 12:24:28','2022-11-23 12:24:28',NULL),(847,7847,346,40736,6100,2,96,2,9926.45,NULL,'2022-11-23 12:24:28','2022-11-23 12:24:28',NULL),(848,7847,346,40736,6100,2,67,2,2084.55,NULL,'2022-11-23 12:24:28','2022-11-23 12:24:28',NULL),(849,7847,346,40736,6100,2,13,1,12011.00,NULL,'2022-11-23 12:24:28','2022-11-23 12:24:28',NULL),(850,7847,347,40787,51641,2,96,2,82644.63,NULL,'2022-11-26 20:57:10','2022-11-26 20:57:10',NULL),(851,7847,347,40787,51641,2,67,2,17355.37,NULL,'2022-11-26 20:57:10','2022-11-26 20:57:10',NULL),(852,7847,347,40787,51641,2,13,1,100000.00,NULL,'2022-11-26 20:57:10','2022-11-26 20:57:10',NULL),(853,7847,348,40787,51641,2,96,2,590000.00,NULL,'2022-11-26 20:57:10','2022-11-26 20:57:10',NULL),(854,7847,348,40787,51641,2,67,2,123900.00,NULL,'2022-11-26 20:57:10','2022-11-26 20:57:10',NULL),(855,7847,348,40787,51641,2,13,1,713900.00,NULL,'2022-11-26 20:57:10','2022-11-26 20:57:10',NULL),(856,7847,349,40787,51641,2,96,2,47933.89,NULL,'2022-11-26 20:57:10','2022-11-26 20:57:10',NULL),(857,7847,349,40787,51641,2,67,2,10066.12,NULL,'2022-11-26 20:57:10','2022-11-26 20:57:10',NULL),(858,7847,349,40787,51641,2,13,1,58000.01,NULL,'2022-11-26 20:57:10','2022-11-26 20:57:10',NULL),(859,7847,350,40787,51641,2,96,2,49586.78,NULL,'2022-11-26 20:57:10','2022-11-26 20:57:10',NULL);
INSERT INTO `balance_libro_details` VALUES (860,7847,350,40787,51641,2,67,2,10413.22,NULL,'2022-11-26 20:57:10','2022-11-26 20:57:10',NULL),(861,7847,350,40787,51641,2,13,1,60000.00,NULL,'2022-11-26 20:57:10','2022-11-26 20:57:10',NULL),(862,7847,351,40787,51641,3,217,1,123.97,NULL,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(863,7847,351,40787,51641,3,68,1,26.03,NULL,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(864,7847,351,40787,51641,3,57,2,150.00,NULL,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(865,7847,352,40787,51641,3,217,1,916.21,NULL,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(866,7847,352,40787,51641,3,68,1,192.40,NULL,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(867,7847,352,40787,51641,3,217,1,9.16,NULL,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(868,7847,352,40787,51641,3,57,2,1117.77,NULL,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(869,7847,353,40787,51641,3,217,1,3450.30,NULL,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(870,7847,353,40787,51641,3,68,1,724.56,NULL,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(871,7847,353,40787,51641,3,217,1,825.14,NULL,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(872,7847,353,40787,51641,3,57,2,5000.00,NULL,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(873,7847,354,40787,51641,3,217,1,3603.21,NULL,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(874,7847,354,40787,51641,3,68,1,756.67,NULL,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(875,7847,354,40787,51641,3,217,1,660.11,NULL,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(876,7847,354,40787,51641,3,57,2,5019.99,NULL,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(877,7847,355,40787,51641,3,217,1,137190.09,NULL,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(878,7847,355,40787,51641,3,68,1,28809.91,NULL,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(879,7847,355,40787,51641,3,57,2,166000.00,NULL,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(880,7847,356,40787,51641,3,217,1,165289.26,NULL,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(881,7847,356,40787,51641,3,68,1,34710.74,NULL,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(882,7847,356,40787,51641,3,57,2,200000.00,NULL,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(883,7847,357,40787,51641,3,217,1,193388.43,NULL,'2022-11-26 20:57:25','2022-11-26 20:59:50','2022-11-26 20:59:50'),(884,7847,357,40787,51641,3,68,1,40611.58,NULL,'2022-11-26 20:57:25','2022-11-26 20:59:50','2022-11-26 20:59:50'),(885,7847,357,40787,51641,3,57,2,234000.01,NULL,'2022-11-26 20:57:25','2022-11-26 20:59:50','2022-11-26 20:59:50'),(886,7847,358,40787,51641,3,217,1,193388.43,NULL,'2022-11-26 20:59:50','2022-11-26 20:59:50',NULL),(887,7847,358,40787,51641,3,68,1,40611.57,NULL,'2022-11-26 20:59:50','2022-11-26 20:59:50',NULL),(888,7847,358,40787,51641,3,57,2,234000.00,NULL,'2022-11-26 20:59:50','2022-11-26 20:59:50',NULL),(889,7847,359,40787,51641,2,96,2,123.97,NULL,'2022-11-27 06:44:34','2022-11-27 06:53:27','2022-11-27 06:53:27'),(890,7847,359,40787,51641,2,67,2,26.03,NULL,'2022-11-27 06:44:34','2022-11-27 06:53:27','2022-11-27 06:53:27'),(891,7847,359,40787,51641,2,13,1,150.00,NULL,'2022-11-27 06:44:34','2022-11-27 06:53:27','2022-11-27 06:53:27'),(892,7847,360,40787,51641,2,96,2,916.21,NULL,'2022-11-27 06:44:34','2022-11-27 06:48:41','2022-11-27 06:48:41'),(893,7847,360,40787,51641,2,67,2,192.40,NULL,'2022-11-27 06:44:34','2022-11-27 06:48:41','2022-11-27 06:48:41'),(894,7847,360,40787,51641,2,218,2,9.16,NULL,'2022-11-27 06:44:34','2022-11-27 06:48:41','2022-11-27 06:48:41'),(895,7847,360,40787,51641,2,13,1,1117.77,NULL,'2022-11-27 06:44:34','2022-11-27 06:48:41','2022-11-27 06:48:41'),(896,7847,361,40787,51641,2,96,2,3450.30,NULL,'2022-11-27 06:44:34','2022-11-27 06:48:19','2022-11-27 06:48:19'),(897,7847,361,40787,51641,2,67,2,724.56,NULL,'2022-11-27 06:44:34','2022-11-27 06:48:19','2022-11-27 06:48:19'),(898,7847,361,40787,51641,2,218,2,825.14,NULL,'2022-11-27 06:44:34','2022-11-27 06:48:19','2022-11-27 06:48:19');
INSERT INTO `balance_libro_details` VALUES (899,7847,361,40787,51641,2,13,1,5000.00,NULL,'2022-11-27 06:44:34','2022-11-27 06:48:19','2022-11-27 06:48:19'),(900,7847,362,40787,51641,2,96,2,3603.21,NULL,'2022-11-27 06:44:34','2022-11-27 06:45:52','2022-11-27 06:45:52'),(901,7847,362,40787,51641,2,67,2,756.67,NULL,'2022-11-27 06:44:34','2022-11-27 06:45:52','2022-11-27 06:45:52'),(902,7847,362,40787,51641,2,218,2,660.11,NULL,'2022-11-27 06:44:34','2022-11-27 06:45:52','2022-11-27 06:45:52'),(903,7847,362,40787,51641,2,13,1,5019.99,NULL,'2022-11-27 06:44:34','2022-11-27 06:45:52','2022-11-27 06:45:52'),(904,7847,363,40787,51641,2,96,2,137190.09,NULL,'2022-11-27 06:44:34','2022-11-27 06:53:33','2022-11-27 06:53:33'),(905,7847,363,40787,51641,2,67,2,28809.91,NULL,'2022-11-27 06:44:34','2022-11-27 06:53:33','2022-11-27 06:53:33'),(906,7847,363,40787,51641,2,13,1,166000.00,NULL,'2022-11-27 06:44:34','2022-11-27 06:53:33','2022-11-27 06:53:33'),(907,7847,364,40787,51641,2,96,2,165289.26,NULL,'2022-11-27 06:44:34','2022-11-27 06:53:37','2022-11-27 06:53:37'),(908,7847,364,40787,51641,2,67,2,34710.74,NULL,'2022-11-27 06:44:34','2022-11-27 06:53:37','2022-11-27 06:53:37'),(909,7847,364,40787,51641,2,13,1,200000.00,NULL,'2022-11-27 06:44:34','2022-11-27 06:53:37','2022-11-27 06:53:37'),(910,7847,365,40787,51641,2,96,2,193388.43,NULL,'2022-11-27 06:44:34','2022-11-27 06:53:46','2022-11-27 06:53:46'),(911,7847,365,40787,51641,2,67,2,40611.58,NULL,'2022-11-27 06:44:34','2022-11-27 06:53:46','2022-11-27 06:53:46'),(912,7847,365,40787,51641,2,13,1,234000.01,NULL,'2022-11-27 06:44:34','2022-11-27 06:53:46','2022-11-27 06:53:46'),(913,7847,366,40787,51641,2,96,2,3603.21,NULL,'2022-11-27 06:45:52','2022-11-27 06:49:44','2022-11-27 06:49:44'),(914,7847,366,40787,51641,2,67,2,756.67,NULL,'2022-11-27 06:45:52','2022-11-27 06:49:44','2022-11-27 06:49:44'),(915,7847,366,40787,51641,2,218,2,660.17,NULL,'2022-11-27 06:45:52','2022-11-27 06:49:44','2022-11-27 06:49:44'),(916,7847,366,40787,51641,2,13,1,5020.05,NULL,'2022-11-27 06:45:52','2022-11-27 06:49:44','2022-11-27 06:49:44'),(917,7847,367,40787,51641,2,96,2,3450.30,NULL,'2022-11-27 06:48:19','2022-11-27 06:53:07','2022-11-27 06:53:07'),(918,7847,367,40787,51641,2,67,2,724.56,NULL,'2022-11-27 06:48:20','2022-11-27 06:53:07','2022-11-27 06:53:07'),(919,7847,367,40787,51641,2,218,2,825.14,NULL,'2022-11-27 06:48:20','2022-11-27 06:53:07','2022-11-27 06:53:07'),(920,7847,367,40787,51641,2,13,1,5000.00,NULL,'2022-11-27 06:48:20','2022-11-27 06:53:07','2022-11-27 06:53:07'),(921,7847,368,40787,51641,2,96,2,916.21,NULL,'2022-11-27 06:48:41','2022-11-27 06:48:41',NULL),(922,7847,368,40787,51641,2,67,2,192.40,NULL,'2022-11-27 06:48:41','2022-11-27 06:48:41',NULL),(923,7847,368,40787,51641,2,218,2,9.16,NULL,'2022-11-27 06:48:41','2022-11-27 06:48:41',NULL),(924,7847,368,40787,51641,2,13,1,1117.77,NULL,'2022-11-27 06:48:41','2022-11-27 06:48:41',NULL),(925,7847,369,40787,51641,2,96,2,3603.21,NULL,'2022-11-27 06:49:44','2022-11-27 06:53:42','2022-11-27 06:53:42'),(926,7847,369,40787,51641,2,67,2,756.67,NULL,'2022-11-27 06:49:44','2022-11-27 06:53:42','2022-11-27 06:53:42'),(927,7847,369,40787,51641,2,218,2,660.11,NULL,'2022-11-27 06:49:44','2022-11-27 06:53:42','2022-11-27 06:53:42'),(928,7847,369,40787,51641,2,13,1,5019.99,NULL,'2022-11-27 06:49:44','2022-11-27 06:53:42','2022-11-27 06:53:42'),(929,7847,370,40735,4597,2,96,2,49586.78,NULL,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(930,7847,370,40735,4597,2,67,2,10413.22,NULL,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(931,7847,370,40735,4597,2,13,1,60000.00,NULL,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(932,7847,371,40735,4597,2,96,2,37190.08,NULL,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(933,7847,371,40735,4597,2,67,2,7809.92,NULL,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(934,7847,371,40735,4597,2,13,1,45000.00,NULL,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(935,7847,372,40735,4597,2,96,2,221280.00,NULL,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL);
INSERT INTO `balance_libro_details` VALUES (936,7847,372,40735,4597,2,67,2,46468.80,NULL,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(937,7847,372,40735,4597,2,13,1,267748.80,NULL,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(938,7847,373,40735,4597,2,96,2,28925.62,NULL,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(939,7847,373,40735,4597,2,67,2,6074.38,NULL,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(940,7847,373,40735,4597,2,13,1,35000.00,NULL,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(941,7847,374,40735,4597,2,96,2,35950.41,NULL,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(942,7847,374,40735,4597,2,67,2,7549.59,NULL,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(943,7847,374,40735,4597,2,13,1,43500.00,NULL,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(944,7847,375,40735,4597,2,96,2,152400.00,NULL,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(945,7847,375,40735,4597,2,67,2,32004.00,NULL,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(946,7847,375,40735,4597,2,13,1,184404.00,NULL,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(947,7847,376,40735,4597,2,96,2,36363.64,NULL,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(948,7847,376,40735,4597,2,67,2,7636.36,NULL,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(949,7847,376,40735,4597,2,13,1,44000.00,NULL,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(950,7847,377,40735,4597,3,217,1,909.09,NULL,'2022-11-28 13:01:41','2022-11-28 13:01:41',NULL),(951,7847,377,40735,4597,3,68,1,190.91,NULL,'2022-11-28 13:01:41','2022-11-28 13:01:41',NULL),(952,7847,377,40735,4597,3,57,2,1100.00,NULL,'2022-11-28 13:01:41','2022-11-28 13:01:41',NULL),(953,7847,378,40735,4597,3,217,1,7584.75,NULL,'2022-11-28 13:01:41','2022-11-28 13:01:41',NULL),(954,7847,378,40735,4597,3,68,1,1592.80,NULL,'2022-11-28 13:01:41','2022-11-28 13:01:41',NULL),(955,7847,378,40735,4597,3,217,1,822.45,NULL,'2022-11-28 13:01:41','2022-11-28 13:01:41',NULL),(956,7847,378,40735,4597,3,57,2,10000.00,NULL,'2022-11-28 13:01:41','2022-11-28 13:01:41',NULL),(957,7847,379,40735,4597,3,250,1,12000.00,NULL,'2022-11-28 13:01:41','2022-11-28 13:01:41',NULL),(958,7847,379,40735,4597,3,57,2,12000.00,NULL,'2022-11-28 13:01:41','2022-11-28 13:01:41',NULL),(959,7847,380,40735,4597,3,217,1,4564.12,NULL,'2022-11-28 13:01:41','2022-11-28 13:01:41',NULL),(960,7847,380,40735,4597,3,68,1,958.47,NULL,'2022-11-28 13:01:41','2022-11-28 13:01:41',NULL),(961,7847,380,40735,4597,3,217,1,477.41,NULL,'2022-11-28 13:01:41','2022-11-28 13:01:41',NULL),(962,7847,380,40735,4597,3,57,2,6000.00,NULL,'2022-11-28 13:01:41','2022-11-28 13:01:41',NULL),(963,7847,381,40735,4597,3,217,1,55000.00,NULL,'2022-11-28 13:01:41','2022-11-28 13:01:41',NULL),(964,7847,381,40735,4597,3,68,1,11550.00,NULL,'2022-11-28 13:01:41','2022-11-28 13:01:41',NULL),(965,7847,381,40735,4597,3,57,2,66550.00,NULL,'2022-11-28 13:01:41','2022-11-28 13:01:41',NULL),(966,7847,382,40735,4597,3,217,1,119000.00,NULL,'2022-11-28 13:01:41','2022-11-28 13:01:41',NULL),(967,7847,382,40735,4597,3,68,1,24990.00,NULL,'2022-11-28 13:01:41','2022-11-28 13:01:41',NULL),(968,7847,382,40735,4597,3,57,2,143990.00,NULL,'2022-11-28 13:01:41','2022-11-28 13:01:41',NULL),(969,7847,383,40735,4597,3,217,1,7751.32,NULL,'2022-11-28 14:03:24','2022-11-28 14:03:24',NULL),(970,7847,383,40735,4597,3,68,1,1627.78,NULL,'2022-11-28 14:03:24','2022-11-28 14:03:24',NULL),(971,7847,383,40735,4597,3,217,1,621.87,NULL,'2022-11-28 14:03:24','2022-11-28 14:03:24',NULL),(972,7847,383,40735,4597,3,57,2,10000.97,NULL,'2022-11-28 14:03:24','2022-11-28 14:03:24',NULL),(973,7847,384,40735,4597,3,217,1,3773.75,NULL,'2022-11-28 14:05:35','2022-11-28 14:05:35',NULL),(974,7847,384,40735,4597,3,68,1,792.49,NULL,'2022-11-28 14:05:35','2022-11-28 14:05:35',NULL),(975,7847,384,40735,4597,3,221,1,433.77,NULL,'2022-11-28 14:05:35','2022-11-28 14:05:35',NULL),(976,7847,384,40735,4597,3,57,2,5000.01,NULL,'2022-11-28 14:05:35','2022-11-28 14:05:35',NULL);
INSERT INTO `balance_libro_details` VALUES (983,7847,387,40720,1526,3,217,1,27040.44,NULL,'2022-12-23 11:12:30','2022-12-23 11:23:22','2022-12-23 11:23:22'),(984,7847,387,40720,1526,3,68,1,4583.67,NULL,'2022-12-23 11:12:30','2022-12-23 11:23:22','2022-12-23 11:23:22'),(985,7847,387,40720,1526,3,57,2,31624.11,NULL,'2022-12-23 11:12:30','2022-12-23 11:23:22','2022-12-23 11:23:22'),(986,7847,388,40720,1526,3,217,1,3824.47,NULL,'2022-12-23 11:12:30','2022-12-23 11:12:30',NULL),(987,7847,388,40720,1526,3,68,1,803.14,NULL,'2022-12-23 11:12:30','2022-12-23 11:12:30',NULL),(988,7847,388,40720,1526,3,217,1,822.87,NULL,'2022-12-23 11:12:30','2022-12-23 11:12:30',NULL),(989,7847,388,40720,1526,3,57,2,5450.48,NULL,'2022-12-23 11:12:30','2022-12-23 11:12:30',NULL),(990,7847,389,40720,1526,3,217,1,413224.00,NULL,'2022-12-23 11:12:30','2022-12-23 11:12:30',NULL),(991,7847,389,40720,1526,3,68,1,86777.04,NULL,'2022-12-23 11:12:30','2022-12-23 11:12:30',NULL),(992,7847,389,40720,1526,3,57,2,500001.04,NULL,'2022-12-23 11:12:30','2022-12-23 11:12:30',NULL),(993,7847,390,40720,1526,3,250,1,18000.00,NULL,'2022-12-23 11:12:30','2022-12-23 11:12:30',NULL),(994,7847,390,40720,1526,3,57,2,18000.00,NULL,'2022-12-23 11:12:30','2022-12-23 11:12:30',NULL),(998,7847,392,40720,1526,2,96,2,27040.44,NULL,'2022-12-23 11:17:07','2022-12-23 11:19:13','2022-12-23 11:19:13'),(999,7847,392,40720,1526,2,67,2,4583.67,NULL,'2022-12-23 11:17:07','2022-12-23 11:19:13','2022-12-23 11:19:13'),(1000,7847,392,40720,1526,2,13,1,31624.11,NULL,'2022-12-23 11:17:07','2022-12-23 11:19:13','2022-12-23 11:19:13'),(1001,7847,393,40720,1526,2,96,2,3824.47,NULL,'2022-12-23 11:17:07','2022-12-23 11:19:05','2022-12-23 11:19:05'),(1002,7847,393,40720,1526,2,67,2,803.14,NULL,'2022-12-23 11:17:07','2022-12-23 11:19:05','2022-12-23 11:19:05'),(1003,7847,393,40720,1526,2,218,2,822.87,NULL,'2022-12-23 11:17:07','2022-12-23 11:19:05','2022-12-23 11:19:05'),(1004,7847,393,40720,1526,2,13,1,5450.48,NULL,'2022-12-23 11:17:07','2022-12-23 11:19:05','2022-12-23 11:19:05'),(1005,7847,394,40720,1526,2,96,2,413224.00,NULL,'2022-12-23 11:17:07','2022-12-23 11:19:00','2022-12-23 11:19:00'),(1006,7847,394,40720,1526,2,67,2,86777.04,NULL,'2022-12-23 11:17:07','2022-12-23 11:19:00','2022-12-23 11:19:00'),(1007,7847,394,40720,1526,2,13,1,500001.04,NULL,'2022-12-23 11:17:07','2022-12-23 11:19:00','2022-12-23 11:19:00'),(1008,7847,395,40720,1526,2,218,2,18000.00,NULL,'2022-12-23 11:17:07','2022-12-23 11:18:03','2022-12-23 11:18:03'),(1009,7847,395,40720,1526,2,218,2,18000.00,NULL,'2022-12-23 11:17:07','2022-12-23 11:18:03','2022-12-23 11:18:03'),(1010,7847,395,40720,1526,2,13,1,18000.00,NULL,'2022-12-23 11:17:07','2022-12-23 11:18:03','2022-12-23 11:18:03'),(1011,7847,395,40720,1526,2,136,1,18000.00,NULL,'2022-12-23 11:17:07','2022-12-23 11:18:03','2022-12-23 11:18:03'),(1012,7847,396,40720,1526,2,96,2,38449.59,NULL,'2022-12-23 11:17:35','2022-12-23 11:36:00','2022-12-23 11:36:00'),(1013,7847,396,40720,1526,2,67,2,8074.41,NULL,'2022-12-23 11:17:35','2022-12-23 11:36:00','2022-12-23 11:36:00'),(1014,7847,396,40720,1526,2,13,1,46524.00,NULL,'2022-12-23 11:17:35','2022-12-23 11:36:00','2022-12-23 11:36:00'),(1015,7847,397,40720,1526,2,96,2,41345.45,NULL,'2022-12-23 11:17:35','2022-12-23 11:35:38','2022-12-23 11:35:38'),(1016,7847,397,40720,1526,2,67,2,8682.55,NULL,'2022-12-23 11:17:35','2022-12-23 11:35:38','2022-12-23 11:35:38'),(1017,7847,397,40720,1526,2,13,1,50028.00,NULL,'2022-12-23 11:17:35','2022-12-23 11:35:38','2022-12-23 11:35:38'),(1018,7847,398,40720,1526,2,96,2,41345.45,NULL,'2022-12-23 11:35:38','2022-12-23 11:35:38',NULL),(1019,7847,398,40720,1526,2,67,2,8682.54,NULL,'2022-12-23 11:35:38','2022-12-23 11:35:38',NULL),(1020,7847,398,40720,1526,2,218,2,0.01,NULL,'2022-12-23 11:35:38','2022-12-23 11:35:38',NULL),(1021,7847,398,40720,1526,2,13,1,50028.00,NULL,'2022-12-23 11:35:38','2022-12-23 11:35:38',NULL),(1022,7847,399,40720,1526,2,96,2,38449.59,NULL,'2022-12-23 11:36:00','2022-12-23 11:36:00',NULL);
INSERT INTO `balance_libro_details` VALUES (1023,7847,399,40720,1526,2,67,2,8074.41,NULL,'2022-12-23 11:36:00','2022-12-23 11:36:00',NULL),(1024,7847,399,40720,1526,2,13,1,46524.00,NULL,'2022-12-23 11:36:00','2022-12-23 11:36:00',NULL),(1025,7847,400,40720,1526,3,135,1,9868.24,NULL,'2022-12-23 11:43:26','2022-12-23 11:43:26',NULL),(1026,7847,400,40720,1526,3,68,1,2072.33,NULL,'2022-12-23 11:43:26','2022-12-23 11:43:26',NULL),(1027,7847,400,40720,1526,3,215,1,959.44,NULL,'2022-12-23 11:43:26','2022-12-23 11:43:26',NULL),(1028,7847,400,40720,1526,3,57,2,12900.01,NULL,'2022-12-23 11:43:26','2022-12-23 11:43:26',NULL),(1029,7847,401,40720,1525,3,217,1,24289.23,NULL,'2022-12-23 11:58:32','2022-12-23 11:59:10','2022-12-23 11:59:10'),(1030,7847,401,40720,1525,3,68,1,4030.52,NULL,'2022-12-23 11:58:32','2022-12-23 11:59:10','2022-12-23 11:59:10'),(1031,7847,401,40720,1525,3,57,2,28319.75,NULL,'2022-12-23 11:58:32','2022-12-23 11:59:10','2022-12-23 11:59:10'),(1032,7847,402,40720,1525,3,250,1,5404.00,NULL,'2022-12-23 11:58:32','2022-12-23 11:58:32',NULL),(1033,7847,402,40720,1525,3,57,2,5404.00,NULL,'2022-12-23 11:58:32','2022-12-23 11:58:32',NULL),(1034,7847,403,40720,1525,3,250,1,19000.00,NULL,'2022-12-23 11:58:32','2022-12-23 11:58:32',NULL),(1035,7847,403,40720,1525,3,57,2,19000.00,NULL,'2022-12-23 11:58:32','2022-12-23 11:58:32',NULL),(1036,7847,404,40720,1525,3,217,1,7272.73,NULL,'2022-12-23 11:58:32','2022-12-23 12:04:49','2022-12-23 12:04:49'),(1037,7847,404,40720,1525,3,68,1,1527.27,NULL,'2022-12-23 11:58:32','2022-12-23 12:04:49','2022-12-23 12:04:49'),(1038,7847,404,40720,1525,3,57,2,8800.00,NULL,'2022-12-23 11:58:32','2022-12-23 12:04:49','2022-12-23 12:04:49'),(1039,7847,405,40735,4600,2,96,2,38677.69,NULL,'2023-02-21 23:43:30','2023-02-21 23:43:30',NULL),(1040,7847,405,40735,4600,2,67,2,8122.31,NULL,'2023-02-21 23:43:30','2023-02-21 23:43:30',NULL),(1041,7847,405,40735,4600,2,13,1,46800.00,NULL,'2023-02-21 23:43:30','2023-02-21 23:43:30',NULL),(1042,7847,406,40735,4600,2,96,2,39669.42,NULL,'2023-02-21 23:43:30','2023-02-21 23:43:30',NULL),(1043,7847,406,40735,4600,2,67,2,8330.58,NULL,'2023-02-21 23:43:30','2023-02-21 23:43:30',NULL),(1044,7847,406,40735,4600,2,13,1,48000.00,NULL,'2023-02-21 23:43:30','2023-02-21 23:43:30',NULL),(1045,7847,407,40735,4600,2,96,2,37603.31,NULL,'2023-02-21 23:43:30','2023-02-21 23:43:30',NULL),(1046,7847,407,40735,4600,2,67,2,7896.69,NULL,'2023-02-21 23:43:30','2023-02-21 23:43:30',NULL),(1047,7847,407,40735,4600,2,13,1,45500.00,NULL,'2023-02-21 23:43:30','2023-02-21 23:43:30',NULL),(1048,7847,408,40735,4600,2,96,2,110640.00,NULL,'2023-02-21 23:43:30','2023-02-21 23:43:30',NULL),(1049,7847,408,40735,4600,2,67,2,23234.40,NULL,'2023-02-21 23:43:30','2023-02-21 23:43:30',NULL),(1050,7847,408,40735,4600,2,13,1,133874.40,NULL,'2023-02-21 23:43:30','2023-02-21 23:43:30',NULL),(1051,7847,409,40735,4600,2,96,2,39917.36,NULL,'2023-02-21 23:43:30','2023-02-21 23:43:30',NULL),(1052,7847,409,40735,4600,2,67,2,8382.64,NULL,'2023-02-21 23:43:30','2023-02-21 23:43:30',NULL),(1053,7847,409,40735,4600,2,13,1,48300.00,NULL,'2023-02-21 23:43:30','2023-02-21 23:43:30',NULL),(1054,7847,410,40735,4600,3,217,1,190.91,NULL,'2023-02-21 23:43:39','2023-02-22 00:17:39','2023-02-22 00:17:39'),(1055,7847,410,40735,4600,3,68,1,40.09,NULL,'2023-02-21 23:43:39','2023-02-22 00:17:39','2023-02-22 00:17:39'),(1056,7847,410,40735,4600,3,57,2,231.00,NULL,'2023-02-21 23:43:39','2023-02-22 00:17:39','2023-02-22 00:17:39'),(1057,7847,411,40735,4600,3,217,1,1239.67,NULL,'2023-02-21 23:43:39','2023-02-22 00:19:22','2023-02-22 00:19:22'),(1058,7847,411,40735,4600,3,68,1,260.33,NULL,'2023-02-21 23:43:39','2023-02-22 00:19:22','2023-02-22 00:19:22'),(1059,7847,411,40735,4600,3,57,2,1500.00,NULL,'2023-02-21 23:43:39','2023-02-22 00:19:22','2023-02-22 00:19:22'),(1060,7847,412,40735,4600,3,217,1,269.90,NULL,'2023-02-21 23:43:39','2023-02-22 00:18:32','2023-02-22 00:18:32'),(1061,7847,412,40735,4600,3,68,1,56.67,NULL,'2023-02-21 23:43:39','2023-02-22 00:18:32','2023-02-22 00:18:32');
INSERT INTO `balance_libro_details` VALUES (1062,7847,412,40735,4600,3,57,2,326.57,NULL,'2023-02-21 23:43:39','2023-02-22 00:18:32','2023-02-22 00:18:32'),(1063,7847,413,40735,4600,3,217,1,2851.69,NULL,'2023-02-21 23:43:39','2023-02-21 23:43:39',NULL),(1064,7847,413,40735,4600,3,68,1,598.85,NULL,'2023-02-21 23:43:39','2023-02-21 23:43:39',NULL),(1065,7847,413,40735,4600,3,217,1,549.47,NULL,'2023-02-21 23:43:39','2023-02-21 23:43:39',NULL),(1066,7847,413,40735,4600,3,57,2,4000.01,NULL,'2023-02-21 23:43:39','2023-02-21 23:43:39',NULL),(1067,7847,414,40735,4600,3,217,1,968.59,NULL,'2023-02-21 23:43:39','2023-02-22 00:18:02','2023-02-22 00:18:02'),(1068,7847,414,40735,4600,3,68,1,203.40,NULL,'2023-02-21 23:43:39','2023-02-22 00:18:02','2023-02-22 00:18:02'),(1069,7847,414,40735,4600,3,217,1,0.01,NULL,'2023-02-21 23:43:39','2023-02-22 00:18:02','2023-02-22 00:18:02'),(1070,7847,414,40735,4600,3,57,2,1172.00,NULL,'2023-02-21 23:43:39','2023-02-22 00:18:02','2023-02-22 00:18:02'),(1071,7847,415,40735,4600,3,217,1,7644.71,NULL,'2023-02-21 23:43:39','2023-02-21 23:43:39',NULL),(1072,7847,415,40735,4600,3,68,1,1605.39,NULL,'2023-02-21 23:43:39','2023-02-21 23:43:39',NULL),(1073,7847,415,40735,4600,3,217,1,749.89,NULL,'2023-02-21 23:43:39','2023-02-21 23:43:39',NULL),(1074,7847,415,40735,4600,3,57,2,9999.99,NULL,'2023-02-21 23:43:39','2023-02-21 23:43:39',NULL),(1075,7847,416,40735,4600,3,217,1,330580.00,NULL,'2023-02-21 23:43:39','2023-02-21 23:43:39',NULL),(1076,7847,416,40735,4600,3,68,1,69421.80,NULL,'2023-02-21 23:43:39','2023-02-21 23:43:39',NULL),(1077,7847,416,40735,4600,3,57,2,400001.80,NULL,'2023-02-21 23:43:39','2023-02-21 23:43:39',NULL),(1078,7847,417,40735,4600,3,217,1,190.91,NULL,'2023-02-22 00:17:39','2023-02-22 00:19:38','2023-02-22 00:19:38'),(1079,7847,417,40735,4600,3,68,1,40.09,NULL,'2023-02-22 00:17:39','2023-02-22 00:19:38','2023-02-22 00:19:38'),(1080,7847,417,40735,4600,3,57,2,231.00,NULL,'2023-02-22 00:17:39','2023-02-22 00:19:38','2023-02-22 00:19:38'),(1081,7847,418,40735,4600,3,217,1,968.59,NULL,'2023-02-22 00:18:02','2023-02-22 00:19:01','2023-02-22 00:19:01'),(1082,7847,418,40735,4600,3,68,1,203.40,NULL,'2023-02-22 00:18:02','2023-02-22 00:19:01','2023-02-22 00:19:01'),(1083,7847,418,40735,4600,3,217,1,0.01,NULL,'2023-02-22 00:18:02','2023-02-22 00:19:01','2023-02-22 00:19:01'),(1084,7847,418,40735,4600,3,57,2,1172.00,NULL,'2023-02-22 00:18:02','2023-02-22 00:19:01','2023-02-22 00:19:01'),(1085,7847,419,40735,4600,3,217,1,269.90,NULL,'2023-02-22 00:18:32','2023-02-22 00:18:32',NULL),(1086,7847,419,40735,4600,3,68,1,56.68,NULL,'2023-02-22 00:18:32','2023-02-22 00:18:32',NULL),(1087,7847,419,40735,4600,3,57,2,326.58,NULL,'2023-02-22 00:18:32','2023-02-22 00:18:32',NULL),(1088,7847,420,40735,4600,3,217,1,968.59,NULL,'2023-02-22 00:19:01','2023-02-22 00:19:01',NULL),(1089,7847,420,40735,4600,3,68,1,203.40,NULL,'2023-02-22 00:19:01','2023-02-22 00:19:01',NULL),(1090,7847,420,40735,4600,3,217,1,0.01,NULL,'2023-02-22 00:19:01','2023-02-22 00:19:01',NULL),(1091,7847,420,40735,4600,3,57,2,1172.00,NULL,'2023-02-22 00:19:01','2023-02-22 00:19:01',NULL),(1092,7847,421,40735,4600,3,217,1,1239.67,NULL,'2023-02-22 00:19:22','2023-02-22 00:19:22',NULL),(1093,7847,421,40735,4600,3,68,1,260.33,NULL,'2023-02-22 00:19:22','2023-02-22 00:19:22',NULL),(1094,7847,421,40735,4600,3,57,2,1500.00,NULL,'2023-02-22 00:19:22','2023-02-22 00:19:22',NULL),(1095,7847,422,40735,4600,3,217,1,190.91,NULL,'2023-02-22 00:19:38','2023-02-22 00:19:38',NULL),(1096,7847,422,40735,4600,3,68,1,40.09,NULL,'2023-02-22 00:19:38','2023-02-22 00:19:38',NULL),(1097,7847,422,40735,4600,3,57,2,231.00,NULL,'2023-02-22 00:19:38','2023-02-22 00:19:38',NULL),(1098,7847,423,40720,1533,2,96,2,44628.10,NULL,'2023-02-22 00:53:39','2023-02-22 00:53:39',NULL),(1099,7847,423,40720,1533,2,67,2,9371.90,NULL,'2023-02-22 00:53:39','2023-02-22 00:53:39',NULL),(1100,7847,423,40720,1533,2,13,1,54000.00,NULL,'2023-02-22 00:53:39','2023-02-22 00:53:39',NULL);
INSERT INTO `balance_libro_details` VALUES (1101,7847,424,40720,1533,2,96,2,177685.95,NULL,'2023-02-22 00:53:39','2023-02-22 00:53:39',NULL),(1102,7847,424,40720,1533,2,67,2,37314.05,NULL,'2023-02-22 00:53:39','2023-02-22 00:53:39',NULL),(1103,7847,424,40720,1533,2,13,1,215000.00,NULL,'2023-02-22 00:53:39','2023-02-22 00:53:39',NULL),(1104,7847,425,40720,1533,3,217,1,2603.46,NULL,'2023-02-22 00:53:51','2023-02-22 00:53:51',NULL),(1105,7847,425,40720,1533,3,68,1,546.73,NULL,'2023-02-22 00:53:51','2023-02-22 00:53:51',NULL),(1106,7847,425,40720,1533,3,57,2,3150.19,NULL,'2023-02-22 00:53:51','2023-02-22 00:53:51',NULL),(1107,7847,426,40720,1533,3,217,1,289517.36,NULL,'2023-02-22 00:53:51','2023-02-22 00:53:51',NULL),(1108,7847,426,40720,1533,3,68,1,60798.64,NULL,'2023-02-22 00:53:51','2023-02-22 00:53:51',NULL),(1109,7847,426,40720,1533,3,57,2,350316.00,NULL,'2023-02-22 00:53:51','2023-02-22 00:53:51',NULL),(1110,7847,427,40720,1533,3,217,1,16033.06,NULL,'2023-02-22 00:53:51','2023-02-22 00:53:51',NULL),(1111,7847,427,40720,1533,3,68,1,3366.94,NULL,'2023-02-22 00:53:51','2023-02-22 00:53:51',NULL),(1112,7847,427,40720,1533,3,57,2,19400.00,NULL,'2023-02-22 00:53:51','2023-02-22 00:53:51',NULL),(1113,7847,428,40720,1533,3,217,1,306860.00,NULL,'2023-02-22 00:53:51','2023-02-22 00:53:51',NULL),(1114,7847,428,40720,1533,3,68,1,64440.60,NULL,'2023-02-22 00:53:51','2023-02-22 00:53:51',NULL),(1115,7847,428,40720,1533,3,57,2,371300.60,NULL,'2023-02-22 00:53:51','2023-02-22 00:53:51',NULL),(1116,7847,429,40720,1533,3,217,1,82645.00,NULL,'2023-02-22 00:53:51','2023-02-22 00:53:51',NULL),(1117,7847,429,40720,1533,3,68,1,17355.45,NULL,'2023-02-22 00:53:51','2023-02-22 00:53:51',NULL),(1118,7847,429,40720,1533,3,57,2,100000.45,NULL,'2023-02-22 00:53:51','2023-02-22 00:53:51',NULL),(1119,7847,430,40720,1533,3,217,1,11561.64,NULL,'2023-02-22 00:53:51','2023-02-22 00:57:05','2023-02-22 00:57:05'),(1120,7847,430,40720,1533,3,68,1,2427.95,NULL,'2023-02-22 00:53:51','2023-02-22 00:57:05','2023-02-22 00:57:05'),(1121,7847,430,40720,1533,3,217,1,2363.02,NULL,'2023-02-22 00:53:51','2023-02-22 00:57:05','2023-02-22 00:57:05'),(1122,7847,430,40720,1533,3,57,2,16352.61,NULL,'2023-02-22 00:53:51','2023-02-22 00:57:05','2023-02-22 00:57:05'),(1123,7847,431,40720,1533,3,217,1,11561.64,NULL,'2023-02-22 00:57:05','2023-02-22 00:57:05',NULL),(1124,7847,431,40720,1533,3,68,1,2427.94,NULL,'2023-02-22 00:57:05','2023-02-22 00:57:05',NULL),(1125,7847,431,40720,1533,3,221,1,2363.02,NULL,'2023-02-22 00:57:05','2023-02-22 00:57:05',NULL),(1126,7847,431,40720,1533,3,57,2,16352.60,NULL,'2023-02-22 00:57:05','2023-02-22 00:57:05',NULL),(1127,7847,432,40736,6104,2,96,2,27275.00,NULL,'2023-02-22 13:21:17','2023-02-22 13:21:17',NULL),(1128,7847,432,40736,6104,2,67,2,5727.75,NULL,'2023-02-22 13:21:17','2023-02-22 13:21:17',NULL),(1129,7847,432,40736,6104,2,13,1,33002.75,NULL,'2023-02-22 13:21:17','2023-02-22 13:21:17',NULL),(1130,7847,433,40736,6104,2,96,2,14231.40,NULL,'2023-02-22 13:21:17','2023-02-22 13:21:17',NULL),(1131,7847,433,40736,6104,2,67,2,2988.60,NULL,'2023-02-22 13:21:17','2023-02-22 13:21:17',NULL),(1132,7847,433,40736,6104,2,13,1,17220.00,NULL,'2023-02-22 13:21:17','2023-02-22 13:21:17',NULL),(1133,7847,434,40736,6104,2,96,2,16099.17,NULL,'2023-02-22 13:21:17','2023-02-22 13:21:17',NULL),(1134,7847,434,40736,6104,2,67,2,3380.83,NULL,'2023-02-22 13:21:17','2023-02-22 13:21:17',NULL),(1135,7847,434,40736,6104,2,13,1,19480.00,NULL,'2023-02-22 13:21:17','2023-02-22 13:21:17',NULL),(1136,7847,435,40736,6104,2,96,2,15909.09,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1137,7847,435,40736,6104,2,67,2,3340.91,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1138,7847,435,40736,6104,2,13,1,19250.00,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1139,7847,436,40736,6104,2,96,2,17008.26,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1140,7847,436,40736,6104,2,67,2,3571.74,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL);
INSERT INTO `balance_libro_details` VALUES (1141,7847,436,40736,6104,2,13,1,20580.00,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1142,7847,437,40736,6104,2,96,2,14528.93,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1143,7847,437,40736,6104,2,67,2,3051.07,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1144,7847,437,40736,6104,2,13,1,17580.00,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1145,7847,438,40736,6104,2,96,2,17355.37,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1146,7847,438,40736,6104,2,67,2,3644.63,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1147,7847,438,40736,6104,2,13,1,21000.00,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1148,7847,439,40736,6104,2,96,2,16429.75,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1149,7847,439,40736,6104,2,67,2,3450.25,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1150,7847,439,40736,6104,2,13,1,19880.00,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1151,7847,440,40736,6104,2,96,2,17107.44,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1152,7847,440,40736,6104,2,67,2,3592.56,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1153,7847,440,40736,6104,2,13,1,20700.00,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1154,7847,441,40736,6104,2,96,2,17355.37,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1155,7847,441,40736,6104,2,67,2,3644.63,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1156,7847,441,40736,6104,2,13,1,21000.00,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1157,7847,442,40736,6104,2,96,2,14404.96,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1158,7847,442,40736,6104,2,67,2,3025.04,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1159,7847,442,40736,6104,2,13,1,17430.00,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1160,7847,443,40736,6104,2,96,2,17297.52,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1161,7847,443,40736,6104,2,67,2,3632.48,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1162,7847,443,40736,6104,2,13,1,20930.00,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1163,7847,444,40736,6104,2,96,2,15983.47,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1164,7847,444,40736,6104,2,67,2,3356.53,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1165,7847,444,40736,6104,2,13,1,19340.00,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1166,7847,445,40736,6104,2,96,2,14685.95,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1167,7847,445,40736,6104,2,67,2,3084.05,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1168,7847,445,40736,6104,2,13,1,17770.00,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1169,7847,446,40736,6104,2,96,2,17247.93,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1170,7847,446,40736,6104,2,67,2,3622.07,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1171,7847,446,40736,6104,2,13,1,20870.00,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1172,7847,447,40736,6104,2,96,2,15809.92,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1173,7847,447,40736,6104,2,67,2,3320.08,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1174,7847,447,40736,6104,2,13,1,19130.00,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1175,7847,448,40736,6104,2,96,2,15454.55,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1176,7847,448,40736,6104,2,67,2,3245.45,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1177,7847,448,40736,6104,2,13,1,18700.00,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1178,7847,449,40736,6104,2,96,2,17520.66,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1179,7847,449,40736,6104,2,67,2,3679.34,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1180,7847,449,40736,6104,2,13,1,21200.00,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1181,7847,450,40736,6104,2,96,2,14157.02,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL);
INSERT INTO `balance_libro_details` VALUES (1182,7847,450,40736,6104,2,67,2,2972.98,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1183,7847,450,40736,6104,2,13,1,17130.00,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1184,7847,451,40736,6104,2,96,2,17561.98,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1185,7847,451,40736,6104,2,67,2,3688.02,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1186,7847,451,40736,6104,2,13,1,21250.00,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1187,7847,452,40736,6104,2,96,2,16719.01,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1188,7847,452,40736,6104,2,67,2,3510.99,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1189,7847,452,40736,6104,2,13,1,20230.00,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1190,7847,453,40736,6104,2,96,2,3933.88,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1191,7847,453,40736,6104,2,67,2,826.12,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1192,7847,453,40736,6104,2,13,1,4760.00,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1193,7847,454,40736,6104,2,96,2,17338.84,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1194,7847,454,40736,6104,2,67,2,3641.16,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1195,7847,454,40736,6104,2,13,1,20980.00,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1196,7847,455,40736,6104,2,96,2,16855.37,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1197,7847,455,40736,6104,2,67,2,3539.63,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1198,7847,455,40736,6104,2,13,1,20395.00,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1199,7847,456,40736,6104,2,96,2,7036.36,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1200,7847,456,40736,6104,2,67,2,1477.64,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1201,7847,456,40736,6104,2,13,1,8514.00,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1202,7847,457,40736,6104,2,96,2,17884.30,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1203,7847,457,40736,6104,2,67,2,3755.70,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1204,7847,457,40736,6104,2,13,1,21640.00,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1205,7847,458,40736,6104,2,96,2,13231.40,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1206,7847,458,40736,6104,2,67,2,2778.60,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1207,7847,458,40736,6104,2,13,1,16010.00,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1208,7847,459,40736,6104,2,96,2,8652.89,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1209,7847,459,40736,6104,2,67,2,1817.11,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1210,7847,459,40736,6104,2,13,1,10470.00,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1211,7847,460,40736,6104,2,96,2,15198.35,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1212,7847,460,40736,6104,2,67,2,3191.65,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1213,7847,460,40736,6104,2,13,1,18390.00,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1214,7847,461,40736,6104,2,96,2,17818.18,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1215,7847,461,40736,6104,2,67,2,3741.82,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1216,7847,461,40736,6104,2,13,1,21560.00,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1217,7847,462,40736,6104,2,96,2,11842.98,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1218,7847,462,40736,6104,2,67,2,2487.02,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1219,7847,462,40736,6104,2,13,1,14330.00,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1220,7847,463,40736,6104,2,96,2,17338.84,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1221,7847,463,40736,6104,2,67,2,3641.16,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1222,7847,463,40736,6104,2,13,1,20980.00,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL);
INSERT INTO `balance_libro_details` VALUES (1223,7847,464,40736,6104,2,96,2,14685.12,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1224,7847,464,40736,6104,2,67,2,3083.88,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1225,7847,464,40736,6104,2,13,1,17769.00,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1226,7847,465,40736,6104,2,96,2,13347.11,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1227,7847,465,40736,6104,2,67,2,2802.89,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1228,7847,465,40736,6104,2,13,1,16150.00,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1229,7847,466,40736,6104,2,96,2,17884.30,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1230,7847,466,40736,6104,2,67,2,3755.70,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1231,7847,466,40736,6104,2,13,1,21640.00,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1232,7847,467,40736,6104,2,96,2,12371.90,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1233,7847,467,40736,6104,2,67,2,2598.10,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(1234,7847,467,40736,6104,2,13,1,14970.00,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(1235,7847,468,40736,6104,2,96,2,9537.19,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(1236,7847,468,40736,6104,2,67,2,2002.81,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(1237,7847,468,40736,6104,2,13,1,11540.00,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(1238,7847,469,40736,6104,2,96,2,16900.83,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(1239,7847,469,40736,6104,2,67,2,3549.17,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(1240,7847,469,40736,6104,2,13,1,20450.00,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(1241,7847,470,40736,6104,2,96,2,17090.91,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(1242,7847,470,40736,6104,2,67,2,3589.09,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(1243,7847,470,40736,6104,2,13,1,20680.00,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(1244,7847,471,40736,6104,2,96,2,19801.65,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(1245,7847,471,40736,6104,2,67,2,4158.35,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(1246,7847,471,40736,6104,2,13,1,23960.00,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(1247,7847,472,40736,6104,2,96,2,20661.16,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(1248,7847,472,40736,6104,2,67,2,4338.84,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(1249,7847,472,40736,6104,2,13,1,25000.00,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(1250,7847,473,40736,6104,2,96,2,15702.48,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(1251,7847,473,40736,6104,2,67,2,3297.52,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(1252,7847,473,40736,6104,2,13,1,19000.00,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(1253,7847,474,40736,6104,2,96,2,18668.60,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(1254,7847,474,40736,6104,2,67,2,3920.40,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(1255,7847,474,40736,6104,2,13,1,22589.00,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(1256,7847,475,40736,6104,2,96,2,19206.61,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(1257,7847,475,40736,6104,2,67,2,4033.39,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(1258,7847,475,40736,6104,2,13,1,23240.00,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(1259,7847,476,40736,6104,2,96,2,18330.58,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(1260,7847,476,40736,6104,2,67,2,3849.42,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(1261,7847,476,40736,6104,2,13,1,22180.00,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(1262,7847,477,40736,6104,2,96,2,16900.83,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(1263,7847,477,40736,6104,2,67,2,3549.17,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL);
INSERT INTO `balance_libro_details` VALUES (1264,7847,477,40736,6104,2,13,1,20450.00,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(1265,7847,478,40736,6104,2,96,2,18438.02,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(1266,7847,478,40736,6104,2,67,2,3871.98,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(1267,7847,478,40736,6104,2,13,1,22310.00,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(1268,7847,479,40736,6104,3,217,1,8265.00,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1269,7847,479,40736,6104,3,68,1,1735.65,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1270,7847,479,40736,6104,3,57,2,10000.65,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1271,7847,480,40736,6104,3,250,2,0.00,NULL,'2023-02-22 13:21:33','2023-02-24 10:48:26','2023-02-24 10:48:26'),(1272,7847,480,40736,6104,3,57,1,0.00,NULL,'2023-02-22 13:21:33','2023-02-24 10:48:26','2023-02-24 10:48:26'),(1273,7847,481,40736,6104,3,217,1,1440.50,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1274,7847,481,40736,6104,3,68,1,302.51,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1275,7847,481,40736,6104,3,57,2,1743.01,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1276,7847,482,40736,6104,3,217,1,239540.72,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1277,7847,482,40736,6104,3,68,1,50303.55,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1278,7847,482,40736,6104,3,57,2,289844.27,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1279,7847,483,40736,6104,3,217,1,5067.87,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1280,7847,483,40736,6104,3,68,1,532.13,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1281,7847,483,40736,6104,3,57,2,5600.00,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1282,7847,484,40736,6104,3,217,1,494316.00,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1283,7847,484,40736,6104,3,68,1,103806.36,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1284,7847,484,40736,6104,3,217,1,27187.38,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1285,7847,484,40736,6104,3,57,2,625309.74,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1286,7847,485,40736,6104,3,217,1,694.21,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1287,7847,485,40736,6104,3,68,1,145.78,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1288,7847,485,40736,6104,3,57,2,839.99,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1289,7847,486,40736,6104,3,217,1,694.21,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1290,7847,486,40736,6104,3,68,1,145.78,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1291,7847,486,40736,6104,3,57,2,839.99,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1292,7847,487,40736,6104,3,217,1,1093.39,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1293,7847,487,40736,6104,3,68,1,229.61,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1294,7847,487,40736,6104,3,57,2,1323.00,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1295,7847,488,40736,6104,3,217,1,1145.45,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1296,7847,488,40736,6104,3,68,1,240.54,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1297,7847,488,40736,6104,3,57,2,1385.99,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1298,7847,489,40736,6104,3,217,1,8537.83,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1299,7847,489,40736,6104,3,68,1,1792.94,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1300,7847,489,40736,6104,3,217,1,0.01,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1301,7847,489,40736,6104,3,57,2,10330.78,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1302,7847,490,40736,6104,3,217,1,40352.00,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1303,7847,490,40736,6104,3,68,1,8473.92,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1304,7847,490,40736,6104,3,217,1,1008.80,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL);
INSERT INTO `balance_libro_details` VALUES (1305,7847,490,40736,6104,3,57,2,49834.72,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1306,7847,491,40736,6104,3,217,1,5067.87,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1307,7847,491,40736,6104,3,68,1,532.13,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1308,7847,491,40736,6104,3,57,2,5600.00,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1309,7847,492,40736,6104,3,217,1,8052.89,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1310,7847,492,40736,6104,3,68,1,1691.11,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1311,7847,492,40736,6104,3,217,1,442.91,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1312,7847,492,40736,6104,3,57,2,10186.91,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1313,7847,493,40736,6104,3,217,2,40352.00,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1314,7847,493,40736,6104,3,67,2,8473.92,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1315,7847,493,40736,6104,3,217,2,1008.80,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1316,7847,493,40736,6104,3,57,1,49834.72,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1317,7847,494,40736,6104,3,217,1,1440.50,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1318,7847,494,40736,6104,3,68,1,302.51,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1319,7847,494,40736,6104,3,57,2,1743.01,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1320,7847,495,40736,6104,3,217,1,1145.45,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1321,7847,495,40736,6104,3,68,1,240.54,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(1322,7847,495,40736,6104,3,57,2,1385.99,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1323,7847,496,40736,6104,3,217,1,16458.23,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1324,7847,496,40736,6104,3,68,1,3456.23,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1325,7847,496,40736,6104,3,217,1,-0.01,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1326,7847,496,40736,6104,3,57,2,19914.45,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1327,7847,497,40736,6104,3,217,1,694.21,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1328,7847,497,40736,6104,3,68,1,145.78,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1329,7847,497,40736,6104,3,57,2,839.99,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1330,7847,498,40736,6104,3,217,1,694.21,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1331,7847,498,40736,6104,3,68,1,145.78,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1332,7847,498,40736,6104,3,57,2,839.99,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1333,7847,499,40736,6104,3,217,1,247158.00,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1334,7847,499,40736,6104,3,68,1,51903.18,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1335,7847,499,40736,6104,3,217,1,13593.69,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1336,7847,499,40736,6104,3,57,2,312654.87,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1337,7847,500,40736,6104,3,217,1,694.21,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1338,7847,500,40736,6104,3,68,1,145.78,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1339,7847,500,40736,6104,3,57,2,839.99,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1340,7847,501,40736,6104,3,217,1,1440.50,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1341,7847,501,40736,6104,3,68,1,302.51,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1342,7847,501,40736,6104,3,57,2,1743.01,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1343,7847,502,40736,6104,3,217,1,1440.50,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1344,7847,502,40736,6104,3,68,1,302.51,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1345,7847,502,40736,6104,3,57,2,1743.01,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL);
INSERT INTO `balance_libro_details` VALUES (1346,7847,503,40736,6104,3,217,1,694.21,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1347,7847,503,40736,6104,3,68,1,145.78,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1348,7847,503,40736,6104,3,57,2,839.99,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1349,7847,504,40736,6104,3,217,1,694.21,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1350,7847,504,40736,6104,3,68,1,145.78,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1351,7847,504,40736,6104,3,57,2,839.99,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1352,7847,505,40736,6104,3,217,1,360799.10,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1353,7847,505,40736,6104,3,68,1,75767.81,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1354,7847,505,40736,6104,3,57,2,436566.91,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1355,7847,506,40736,6104,3,217,1,35702.48,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1356,7847,506,40736,6104,3,68,1,7497.52,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1357,7847,506,40736,6104,3,57,2,43200.00,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1358,7847,507,40736,6104,3,217,1,1145.45,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1359,7847,507,40736,6104,3,68,1,240.54,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1360,7847,507,40736,6104,3,57,2,1385.99,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1361,7847,508,40736,6104,3,217,1,1145.45,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1362,7847,508,40736,6104,3,68,1,240.54,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1363,7847,508,40736,6104,3,57,2,1385.99,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1364,7847,509,40736,6104,3,217,1,1145.45,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1365,7847,509,40736,6104,3,68,1,240.54,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1366,7847,509,40736,6104,3,57,2,1385.99,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1367,7847,510,40736,6104,3,217,1,694.21,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1368,7847,510,40736,6104,3,68,1,145.78,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1369,7847,510,40736,6104,3,57,2,839.99,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1370,7847,511,40736,6104,3,217,1,1145.45,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1371,7847,511,40736,6104,3,68,1,240.54,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1372,7847,511,40736,6104,3,57,2,1385.99,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(1373,7847,512,40736,6104,3,217,1,1145.45,NULL,'2023-02-22 13:21:35','2023-02-22 13:21:35',NULL),(1374,7847,512,40736,6104,3,68,1,240.54,NULL,'2023-02-22 13:21:35','2023-02-22 13:21:35',NULL),(1375,7847,512,40736,6104,3,57,2,1385.99,NULL,'2023-02-22 13:21:35','2023-02-22 13:21:35',NULL),(1376,7847,513,40736,6104,3,217,1,7601.81,NULL,'2023-02-22 13:21:35','2023-02-22 13:21:35',NULL),(1377,7847,513,40736,6104,3,68,1,798.19,NULL,'2023-02-22 13:21:35','2023-02-22 13:21:35',NULL),(1378,7847,513,40736,6104,3,57,2,8400.00,NULL,'2023-02-22 13:21:35','2023-02-22 13:21:35',NULL),(1379,7847,514,40736,6104,3,217,1,40851.33,NULL,'2023-02-22 13:21:35','2023-02-22 13:21:35',NULL),(1380,7847,514,40736,6104,3,68,1,8578.78,NULL,'2023-02-22 13:21:35','2023-02-22 13:21:35',NULL),(1381,7847,514,40736,6104,3,57,2,49430.11,NULL,'2023-02-22 13:21:35','2023-02-22 13:21:35',NULL),(1382,7847,515,40736,6104,3,217,1,16199.00,NULL,'2023-02-22 13:21:35','2023-02-22 13:21:35',NULL),(1383,7847,515,40736,6104,3,68,1,3401.79,NULL,'2023-02-22 13:21:35','2023-02-22 13:21:35',NULL),(1384,7847,515,40736,6104,3,57,2,19600.79,NULL,'2023-02-22 13:21:35','2023-02-22 13:21:35',NULL),(1385,7847,516,40736,6104,3,217,1,514188.00,NULL,'2023-02-22 13:21:35','2023-02-22 13:46:29','2023-02-22 13:46:29'),(1386,7847,516,40736,6104,3,68,1,107979.48,NULL,'2023-02-22 13:21:35','2023-02-22 13:46:29','2023-02-22 13:46:29');
INSERT INTO `balance_libro_details` VALUES (1387,7847,516,40736,6104,3,217,1,28280.34,NULL,'2023-02-22 13:21:35','2023-02-22 13:46:29','2023-02-22 13:46:29'),(1388,7847,516,40736,6104,3,57,2,650447.82,NULL,'2023-02-22 13:21:35','2023-02-22 13:46:29','2023-02-22 13:46:29'),(1389,7847,517,40736,6104,3,217,1,21388.00,NULL,'2023-02-22 13:21:35','2023-02-22 13:21:35',NULL),(1390,7847,517,40736,6104,3,68,1,4142.36,NULL,'2023-02-22 13:21:35','2023-02-22 13:21:35',NULL),(1391,7847,517,40736,6104,3,217,1,534.70,NULL,'2023-02-22 13:21:35','2023-02-22 13:21:35',NULL),(1392,7847,517,40736,6104,3,57,2,26065.06,NULL,'2023-02-22 13:21:35','2023-02-22 13:21:35',NULL),(1393,7847,518,40736,6104,3,217,1,514188.00,NULL,'2023-02-22 13:46:29','2023-02-22 13:46:29',NULL),(1394,7847,518,40736,6104,3,68,1,107979.48,NULL,'2023-02-22 13:46:29','2023-02-22 13:46:29',NULL),(1395,7847,518,40736,6104,3,217,1,28280.34,NULL,'2023-02-22 13:46:29','2023-02-22 13:46:29',NULL),(1396,7847,518,40736,6104,3,57,2,650447.82,NULL,'2023-02-22 13:46:29','2023-02-22 13:46:29',NULL),(1397,7847,519,40736,6104,3,217,1,7682.63,NULL,'2023-02-24 10:46:11','2023-02-24 10:47:11','2023-02-24 10:47:11'),(1398,7847,519,40736,6104,3,68,1,1613.35,NULL,'2023-02-24 10:46:11','2023-02-24 10:47:11','2023-02-24 10:47:11'),(1399,7847,519,40736,6104,3,57,2,9295.98,NULL,'2023-02-24 10:46:11','2023-02-24 10:47:11','2023-02-24 10:47:11'),(1400,7847,520,40736,6104,3,217,1,48682.70,NULL,'2023-02-24 10:46:12','2023-02-24 10:47:05','2023-02-24 10:47:05'),(1401,7847,520,40736,6104,3,68,1,5111.68,NULL,'2023-02-24 10:46:12','2023-02-24 10:47:05','2023-02-24 10:47:05'),(1402,7847,520,40736,6104,3,57,2,53794.38,NULL,'2023-02-24 10:46:12','2023-02-24 10:47:05','2023-02-24 10:47:05'),(1403,7847,521,40736,6104,3,217,1,40329.38,NULL,'2023-02-24 10:46:12','2023-02-24 10:46:57','2023-02-24 10:46:57'),(1404,7847,521,40736,6104,3,68,1,7741.13,NULL,'2023-02-24 10:46:12','2023-02-24 10:46:57','2023-02-24 10:46:57'),(1405,7847,521,40736,6104,3,217,1,129.34,NULL,'2023-02-24 10:46:12','2023-02-24 10:46:57','2023-02-24 10:46:57'),(1406,7847,521,40736,6104,3,57,2,48199.85,NULL,'2023-02-24 10:46:12','2023-02-24 10:46:57','2023-02-24 10:46:57'),(1407,7847,522,40736,6104,3,217,1,17978.50,NULL,'2023-02-24 10:46:12','2023-02-24 10:46:47','2023-02-24 10:46:47'),(1408,7847,522,40736,6104,3,68,1,3629.98,NULL,'2023-02-24 10:46:12','2023-02-24 10:46:47','2023-02-24 10:46:47'),(1409,7847,522,40736,6104,3,57,2,21608.48,NULL,'2023-02-24 10:46:12','2023-02-24 10:46:47','2023-02-24 10:46:47'),(1410,7847,523,40736,6104,3,217,1,4132.23,NULL,'2023-02-24 10:46:12','2023-02-24 10:46:39','2023-02-24 10:46:39'),(1411,7847,523,40736,6104,3,68,1,867.77,NULL,'2023-02-24 10:46:12','2023-02-24 10:46:39','2023-02-24 10:46:39'),(1412,7847,523,40736,6104,3,57,2,5000.00,NULL,'2023-02-24 10:46:12','2023-02-24 10:46:39','2023-02-24 10:46:39'),(1413,7847,524,40736,6102,2,96,2,5380.17,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1414,7847,524,40736,6102,2,67,2,1129.83,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1415,7847,524,40736,6102,2,13,1,6510.00,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1416,7847,525,40736,6102,2,96,2,4991.74,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1417,7847,525,40736,6102,2,67,2,1048.26,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1418,7847,525,40736,6102,2,13,1,6040.00,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1419,7847,526,40736,6102,2,96,2,16528.93,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1420,7847,526,40736,6102,2,67,2,3471.07,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1421,7847,526,40736,6102,2,13,1,20000.00,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1422,7847,527,40736,6102,2,96,2,13487.60,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1423,7847,527,40736,6102,2,67,2,2832.40,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1424,7847,527,40736,6102,2,13,1,16320.00,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL);
INSERT INTO `balance_libro_details` VALUES (1425,7847,528,40736,6102,2,96,2,16528.93,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1426,7847,528,40736,6102,2,67,2,3471.07,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1427,7847,528,40736,6102,2,13,1,20000.00,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1428,7847,529,40736,6102,2,96,2,13140.50,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1429,7847,529,40736,6102,2,67,2,2759.50,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1430,7847,529,40736,6102,2,13,1,15900.00,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1431,7847,530,40736,6102,2,96,2,2768.60,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1432,7847,530,40736,6102,2,67,2,581.40,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1433,7847,530,40736,6102,2,13,1,3350.00,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1434,7847,531,40736,6102,2,96,2,1652.89,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1435,7847,531,40736,6102,2,67,2,347.11,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1436,7847,531,40736,6102,2,13,1,2000.00,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1437,7847,532,40736,6102,2,96,2,2892.56,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1438,7847,532,40736,6102,2,67,2,607.44,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1439,7847,532,40736,6102,2,13,1,3500.00,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1440,7847,533,40736,6102,2,96,2,15041.32,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1441,7847,533,40736,6102,2,67,2,3158.68,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1442,7847,533,40736,6102,2,13,1,18200.00,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1443,7847,534,40736,6102,2,96,2,9181.82,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1444,7847,534,40736,6102,2,67,2,1928.18,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1445,7847,534,40736,6102,2,13,1,11110.00,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1446,7847,535,40736,6102,2,96,2,17471.07,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1447,7847,535,40736,6102,2,67,2,3668.93,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1448,7847,535,40736,6102,2,13,1,21140.00,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1449,7847,536,40736,6102,2,96,2,4628.10,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1450,7847,536,40736,6102,2,67,2,971.90,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1451,7847,536,40736,6102,2,13,1,5600.00,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1452,7847,537,40736,6102,2,96,2,14495.87,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1453,7847,537,40736,6102,2,67,2,3044.13,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1454,7847,537,40736,6102,2,13,1,17540.00,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1455,7847,538,40736,6102,2,96,2,9826.45,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1456,7847,538,40736,6102,2,67,2,2063.55,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1457,7847,538,40736,6102,2,13,1,11890.00,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1458,7847,539,40736,6102,2,96,2,12396.69,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1459,7847,539,40736,6102,2,67,2,2603.31,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1460,7847,539,40736,6102,2,13,1,15000.00,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(1461,7847,540,40736,6102,2,96,2,8553.72,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1462,7847,540,40736,6102,2,67,2,1796.28,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1463,7847,540,40736,6102,2,13,1,10350.00,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1464,7847,541,40736,6102,2,96,2,8842.98,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1465,7847,541,40736,6102,2,67,2,1857.02,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL);
INSERT INTO `balance_libro_details` VALUES (1466,7847,541,40736,6102,2,13,1,10700.00,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1467,7847,542,40736,6102,2,96,2,5561.98,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1468,7847,542,40736,6102,2,67,2,1168.02,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1469,7847,542,40736,6102,2,13,1,6730.00,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1470,7847,543,40736,6102,2,96,2,7933.88,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1471,7847,543,40736,6102,2,67,2,1666.12,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1472,7847,543,40736,6102,2,13,1,9600.00,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1473,7847,544,40736,6102,2,96,2,9752.07,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1474,7847,544,40736,6102,2,67,2,2047.93,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1475,7847,544,40736,6102,2,13,1,11800.00,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1476,7847,545,40736,6102,2,96,2,10041.32,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1477,7847,545,40736,6102,2,67,2,2108.68,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1478,7847,545,40736,6102,2,13,1,12150.00,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1479,7847,546,40736,6102,2,96,2,13814.05,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1480,7847,546,40736,6102,2,67,2,2900.95,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1481,7847,546,40736,6102,2,13,1,16715.00,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1482,7847,547,40736,6102,2,96,2,12142.15,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1483,7847,547,40736,6102,2,67,2,2549.85,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1484,7847,547,40736,6102,2,13,1,14692.00,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1485,7847,548,40736,6102,2,96,2,17107.44,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1486,7847,548,40736,6102,2,67,2,3592.56,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1487,7847,548,40736,6102,2,13,1,20700.00,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1488,7847,549,40736,6102,2,96,2,16834.71,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1489,7847,549,40736,6102,2,67,2,3535.29,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1490,7847,549,40736,6102,2,13,1,20370.00,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1491,7847,550,40736,6102,2,96,2,7528.93,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1492,7847,550,40736,6102,2,67,2,1581.07,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1493,7847,550,40736,6102,2,13,1,9110.00,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1494,7847,551,40736,6102,2,96,2,4528.93,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1495,7847,551,40736,6102,2,67,2,951.07,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1496,7847,551,40736,6102,2,13,1,5480.00,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1497,7847,552,40736,6102,2,96,2,4876.03,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1498,7847,552,40736,6102,2,67,2,1023.97,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1499,7847,552,40736,6102,2,13,1,5900.00,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1500,7847,553,40736,6102,2,96,2,1661.16,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1501,7847,553,40736,6102,2,67,2,348.84,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1502,7847,553,40736,6102,2,13,1,2010.00,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1503,7847,554,40736,6102,2,96,2,16033.06,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1504,7847,554,40736,6102,2,67,2,3366.94,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1505,7847,554,40736,6102,2,13,1,19400.00,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1506,7847,555,40736,6102,2,96,2,7429.75,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL);
INSERT INTO `balance_libro_details` VALUES (1507,7847,555,40736,6102,2,67,2,1560.25,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1508,7847,555,40736,6102,2,13,1,8990.00,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1509,7847,556,40736,6102,2,96,2,17727.27,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1510,7847,556,40736,6102,2,67,2,3722.73,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1511,7847,556,40736,6102,2,13,1,21450.00,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1512,7847,557,40736,6102,2,96,2,13785.12,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1513,7847,557,40736,6102,2,67,2,2894.88,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1514,7847,557,40736,6102,2,13,1,16680.00,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1515,7847,558,40736,6102,2,96,2,9652.89,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1516,7847,558,40736,6102,2,67,2,2027.11,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1517,7847,558,40736,6102,2,13,1,11680.00,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1518,7847,559,40736,6102,2,96,2,13950.41,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1519,7847,559,40736,6102,2,67,2,2929.59,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1520,7847,559,40736,6102,2,13,1,16880.00,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1521,7847,560,40736,6102,2,96,2,16256.20,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1522,7847,560,40736,6102,2,67,2,3413.80,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1523,7847,560,40736,6102,2,13,1,19670.00,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(1524,7847,561,40736,6102,2,96,2,8264.46,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1525,7847,561,40736,6102,2,67,2,1735.54,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1526,7847,561,40736,6102,2,13,1,10000.00,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1527,7847,562,40736,6102,2,96,2,15106.61,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1528,7847,562,40736,6102,2,67,2,3172.39,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1529,7847,562,40736,6102,2,13,1,18279.00,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1530,7847,563,40736,6102,2,96,2,6859.50,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1531,7847,563,40736,6102,2,67,2,1440.50,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1532,7847,563,40736,6102,2,13,1,8300.00,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1533,7847,564,40736,6102,2,96,2,10082.64,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1534,7847,564,40736,6102,2,67,2,2117.36,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1535,7847,564,40736,6102,2,13,1,12200.00,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1536,7847,565,40736,6102,2,96,2,7933.88,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1537,7847,565,40736,6102,2,67,2,1666.12,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1538,7847,565,40736,6102,2,13,1,9600.00,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1539,7847,566,40736,6102,2,96,2,5685.95,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1540,7847,566,40736,6102,2,67,2,1194.05,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1541,7847,566,40736,6102,2,13,1,6880.00,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1542,7847,567,40736,6102,2,96,2,3966.94,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1543,7847,567,40736,6102,2,67,2,833.06,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1544,7847,567,40736,6102,2,13,1,4800.00,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1545,7847,568,40736,6102,2,96,2,7107.44,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1546,7847,568,40736,6102,2,67,2,1492.56,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1547,7847,568,40736,6102,2,13,1,8600.00,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL);
INSERT INTO `balance_libro_details` VALUES (1548,7847,569,40736,6102,2,96,2,3966.94,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1549,7847,569,40736,6102,2,67,2,833.06,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1550,7847,569,40736,6102,2,13,1,4800.00,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1551,7847,570,40736,6102,2,96,2,2892.56,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1552,7847,570,40736,6102,2,67,2,607.44,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1553,7847,570,40736,6102,2,13,1,3500.00,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1554,7847,571,40736,6102,2,96,2,4710.74,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1555,7847,571,40736,6102,2,67,2,989.26,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1556,7847,571,40736,6102,2,13,1,5700.00,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1557,7847,572,40736,6102,2,96,2,3223.14,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1558,7847,572,40736,6102,2,67,2,676.86,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1559,7847,572,40736,6102,2,13,1,3900.00,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1560,7847,573,40736,6102,2,96,2,3966.94,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1561,7847,573,40736,6102,2,67,2,833.06,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1562,7847,573,40736,6102,2,13,1,4800.00,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1563,7847,574,40736,6102,2,96,2,5371.90,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1564,7847,574,40736,6102,2,67,2,1128.10,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1565,7847,574,40736,6102,2,13,1,6500.00,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1566,7847,575,40736,6102,2,96,2,4413.22,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1567,7847,575,40736,6102,2,67,2,926.78,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1568,7847,575,40736,6102,2,13,1,5340.00,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1569,7847,576,40736,6102,2,96,2,2892.56,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1570,7847,576,40736,6102,2,67,2,607.44,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1571,7847,576,40736,6102,2,13,1,3500.00,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1572,7847,577,40736,6102,2,96,2,8785.12,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1573,7847,577,40736,6102,2,67,2,1844.88,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1574,7847,577,40736,6102,2,13,1,10630.00,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1575,7847,578,40736,6102,2,96,2,2892.56,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1576,7847,578,40736,6102,2,67,2,607.44,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1577,7847,578,40736,6102,2,13,1,3500.00,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1578,7847,579,40736,6102,2,96,2,6033.06,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1579,7847,579,40736,6102,2,67,2,1266.94,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1580,7847,579,40736,6102,2,13,1,7300.00,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1581,7847,580,40736,6102,2,96,2,826.45,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1582,7847,580,40736,6102,2,67,2,173.55,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1583,7847,580,40736,6102,2,13,1,1000.00,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(1584,7847,581,40736,6102,2,96,2,4545.45,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1585,7847,581,40736,6102,2,67,2,954.55,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1586,7847,581,40736,6102,2,13,1,5500.00,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1587,7847,582,40736,6102,2,96,2,11157.02,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1588,7847,582,40736,6102,2,67,2,2342.98,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL);
INSERT INTO `balance_libro_details` VALUES (1589,7847,582,40736,6102,2,13,1,13500.00,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1590,7847,583,40736,6102,2,96,2,4958.68,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1591,7847,583,40736,6102,2,67,2,1041.32,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1592,7847,583,40736,6102,2,13,1,6000.00,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1593,7847,584,40736,6102,2,96,2,7024.79,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1594,7847,584,40736,6102,2,67,2,1475.21,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1595,7847,584,40736,6102,2,13,1,8500.00,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1596,7847,585,40736,6102,2,96,2,2066.12,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1597,7847,585,40736,6102,2,67,2,433.88,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1598,7847,585,40736,6102,2,13,1,2500.00,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1599,7847,586,40736,6102,2,96,2,6942.15,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1600,7847,586,40736,6102,2,67,2,1457.85,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1601,7847,586,40736,6102,2,13,1,8400.00,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1602,7847,587,40736,6102,2,96,2,15429.75,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1603,7847,587,40736,6102,2,67,2,3240.25,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1604,7847,587,40736,6102,2,13,1,18670.00,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1605,7847,588,40736,6102,2,96,2,11983.47,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1606,7847,588,40736,6102,2,67,2,2516.53,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1607,7847,588,40736,6102,2,13,1,14500.00,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1608,7847,589,40736,6102,2,96,2,8099.17,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1609,7847,589,40736,6102,2,67,2,1700.83,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1610,7847,589,40736,6102,2,13,1,9800.00,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1611,7847,590,40736,6102,2,96,2,5479.34,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1612,7847,590,40736,6102,2,67,2,1150.66,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1613,7847,590,40736,6102,2,13,1,6630.00,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1614,7847,591,40736,6102,2,96,2,11578.51,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1615,7847,591,40736,6102,2,67,2,2431.49,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1616,7847,591,40736,6102,2,13,1,14010.00,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1617,7847,592,40736,6102,2,96,2,15231.40,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1618,7847,592,40736,6102,2,67,2,3198.60,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1619,7847,592,40736,6102,2,13,1,18430.00,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1620,7847,593,40736,6102,2,96,2,4429.75,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1621,7847,593,40736,6102,2,67,2,930.25,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1622,7847,593,40736,6102,2,13,1,5360.00,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1623,7847,594,40736,6102,2,96,2,17272.73,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1624,7847,594,40736,6102,2,67,2,3627.27,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1625,7847,594,40736,6102,2,13,1,20900.00,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1626,7847,595,40736,6102,2,96,2,9008.26,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1627,7847,595,40736,6102,2,67,2,1891.74,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1628,7847,595,40736,6102,2,13,1,10900.00,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1629,7847,596,40736,6102,2,96,2,17685.95,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL);
INSERT INTO `balance_libro_details` VALUES (1630,7847,596,40736,6102,2,67,2,3714.05,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1631,7847,596,40736,6102,2,13,1,21400.00,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1632,7847,597,40736,6102,2,96,2,9818.18,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1633,7847,597,40736,6102,2,67,2,2061.82,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1634,7847,597,40736,6102,2,13,1,11880.00,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1635,7847,598,40736,6102,2,96,2,1884.30,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1636,7847,598,40736,6102,2,67,2,395.70,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1637,7847,598,40736,6102,2,13,1,2280.00,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1638,7847,599,40736,6102,2,96,2,8239.67,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1639,7847,599,40736,6102,2,67,2,1730.33,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1640,7847,599,40736,6102,2,13,1,9970.00,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(1641,7847,600,40736,6102,2,96,2,16090.91,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(1642,7847,600,40736,6102,2,67,2,3379.09,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(1643,7847,600,40736,6102,2,13,1,19470.00,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(1644,7847,601,40736,6102,2,96,2,5628.10,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(1645,7847,601,40736,6102,2,67,2,1181.90,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(1646,7847,601,40736,6102,2,13,1,6810.00,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(1647,7847,602,40736,6102,2,96,2,11289.26,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(1648,7847,602,40736,6102,2,67,2,2370.74,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(1649,7847,602,40736,6102,2,13,1,13660.00,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(1650,7847,603,40736,6102,2,96,2,10487.60,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(1651,7847,603,40736,6102,2,67,2,2202.40,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(1652,7847,603,40736,6102,2,13,1,12690.00,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(1653,7847,604,40736,6102,2,96,2,5314.05,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(1654,7847,604,40736,6102,2,67,2,1115.95,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(1655,7847,604,40736,6102,2,13,1,6430.00,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(1656,7847,605,40736,6102,2,96,2,9793.39,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(1657,7847,605,40736,6102,2,67,2,2056.61,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(1658,7847,605,40736,6102,2,13,1,11850.00,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(1659,7847,606,40736,6102,2,96,2,6595.04,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(1660,7847,606,40736,6102,2,67,2,1384.96,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(1661,7847,606,40736,6102,2,13,1,7980.00,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(1662,7847,607,40736,6102,2,96,2,10289.26,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(1663,7847,607,40736,6102,2,67,2,2160.74,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(1664,7847,607,40736,6102,2,13,1,12450.00,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(1665,7847,608,40736,6102,2,96,2,29752.07,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(1666,7847,608,40736,6102,2,67,2,6247.93,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(1667,7847,608,40736,6102,2,13,1,36000.00,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(1668,7847,609,40736,6102,2,96,2,3768.60,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(1669,7847,609,40736,6102,2,67,2,791.40,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(1670,7847,609,40736,6102,2,13,1,4560.00,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL);
INSERT INTO `balance_libro_details` VALUES (1671,7847,610,40736,6102,2,96,2,10743.80,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(1672,7847,610,40736,6102,2,67,2,2256.20,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(1673,7847,610,40736,6102,2,13,1,13000.00,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(1674,7847,611,40736,6102,2,96,2,6446.28,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(1675,7847,611,40736,6102,2,67,2,1353.72,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(1676,7847,611,40736,6102,2,13,1,7800.00,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(1677,7847,612,40736,6102,2,96,2,5264.46,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(1678,7847,612,40736,6102,2,67,2,1105.54,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(1679,7847,612,40736,6102,2,13,1,6370.00,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(1680,7847,613,40736,6102,3,217,1,7682.63,NULL,'2023-02-24 11:52:47','2023-02-24 11:52:47',NULL),(1681,7847,613,40736,6102,3,68,1,1613.35,NULL,'2023-02-24 11:52:47','2023-02-24 11:52:47',NULL),(1682,7847,613,40736,6102,3,57,2,9295.98,NULL,'2023-02-24 11:52:47','2023-02-24 11:52:47',NULL),(1683,7847,614,40736,6102,3,217,1,64562.40,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(1684,7847,614,40736,6102,3,68,1,13558.11,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(1685,7847,614,40736,6102,3,57,2,78120.51,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(1686,7847,615,40736,6102,3,217,1,3529.41,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(1687,7847,615,40736,6102,3,68,1,370.59,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(1688,7847,615,40736,6102,3,57,2,3900.00,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(1689,7847,616,40736,6102,3,217,1,3800.90,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(1690,7847,616,40736,6102,3,68,1,399.10,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(1691,7847,616,40736,6102,3,57,2,4200.00,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(1692,7847,617,40736,6102,3,217,1,97236.40,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(1693,7847,617,40736,6102,3,68,1,20419.64,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(1694,7847,617,40736,6102,3,217,1,-0.04,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(1695,7847,617,40736,6102,3,57,2,117656.00,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(1696,7847,618,40736,6102,3,217,1,6714.34,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(1697,7847,618,40736,6102,3,68,1,1410.01,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(1698,7847,618,40736,6102,3,217,1,369.29,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(1699,7847,618,40736,6102,3,57,2,8493.64,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(1700,7847,619,40736,6102,3,217,1,6742.76,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(1701,7847,619,40736,6102,3,68,1,1415.98,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(1702,7847,619,40736,6102,3,57,2,8158.74,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(1703,7847,620,40736,6102,3,217,1,59551.68,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(1704,7847,620,40736,6102,3,68,1,12505.85,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(1705,7847,620,40736,6102,3,57,2,72057.53,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(1706,7847,621,40736,6102,3,217,1,101152.16,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(1707,7847,621,40736,6102,3,68,1,21241.95,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(1708,7847,621,40736,6102,3,57,2,122394.11,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(1709,7847,622,40736,6102,3,217,1,694.21,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(1710,7847,622,40736,6102,3,68,1,145.78,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(1711,7847,622,40736,6102,3,57,2,839.99,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL);
INSERT INTO `balance_libro_details` VALUES (1712,7847,623,40736,6102,3,217,1,694.21,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(1713,7847,623,40736,6102,3,68,1,145.78,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(1714,7847,623,40736,6102,3,57,2,839.99,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(1715,7847,624,40736,6102,3,217,1,1440.50,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(1716,7847,624,40736,6102,3,68,1,302.51,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(1717,7847,624,40736,6102,3,57,2,1743.01,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(1718,7847,625,40736,6102,3,217,1,30215.00,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(1719,7847,625,40736,6102,3,68,1,6345.15,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(1720,7847,625,40736,6102,3,217,1,755.38,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(1721,7847,625,40736,6102,3,57,2,37315.53,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(1722,7847,626,40736,6102,3,217,1,475375.60,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1723,7847,626,40736,6102,3,68,1,99828.88,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1724,7847,626,40736,6102,3,217,1,11884.39,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1725,7847,626,40736,6102,3,57,2,587088.87,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1726,7847,627,40736,6102,3,217,1,69520.72,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1727,7847,627,40736,6102,3,68,1,14599.35,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1728,7847,627,40736,6102,3,57,2,84120.07,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1729,7847,628,40736,6102,3,217,1,3800.90,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1730,7847,628,40736,6102,3,68,1,399.10,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1731,7847,628,40736,6102,3,57,2,4200.00,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1732,7847,629,40736,6102,3,217,1,17393.18,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1733,7847,629,40736,6102,3,68,1,3652.57,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1734,7847,629,40736,6102,3,57,2,21045.75,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1735,7847,630,40736,6102,3,217,2,30215.00,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1736,7847,630,40736,6102,3,67,2,6345.15,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1737,7847,630,40736,6102,3,217,2,755.38,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1738,7847,630,40736,6102,3,57,1,37315.53,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1739,7847,631,40736,6102,3,217,1,4132.23,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1740,7847,631,40736,6102,3,68,1,867.77,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1741,7847,631,40736,6102,3,57,2,5000.00,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1742,7847,632,40736,6102,3,217,1,3800.90,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1743,7847,632,40736,6102,3,68,1,399.10,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1744,7847,632,40736,6102,3,57,2,4200.00,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1745,7847,633,40736,6102,3,217,1,16844.44,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1746,7847,633,40736,6102,3,68,1,3537.33,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1747,7847,633,40736,6102,3,57,2,20381.77,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1748,7847,634,40736,6102,3,217,1,78165.18,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1749,7847,634,40736,6102,3,68,1,16414.69,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1750,7847,634,40736,6102,3,57,2,94579.87,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1751,7847,635,40736,6102,3,217,1,494316.00,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1752,7847,635,40736,6102,3,68,1,103806.36,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL);
INSERT INTO `balance_libro_details` VALUES (1753,7847,635,40736,6102,3,217,1,27187.38,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1754,7847,635,40736,6102,3,57,2,625309.74,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1755,7847,636,40736,6102,3,217,1,28483.97,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1756,7847,636,40736,6102,3,68,1,5981.63,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1757,7847,636,40736,6102,3,217,1,0.01,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1758,7847,636,40736,6102,3,57,2,34465.61,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1759,7847,637,40736,6102,3,217,1,1093.39,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1760,7847,637,40736,6102,3,68,1,229.61,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1761,7847,637,40736,6102,3,57,2,1323.00,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1762,7847,638,40736,6102,3,217,1,572.73,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1763,7847,638,40736,6102,3,68,1,120.27,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1764,7847,638,40736,6102,3,57,2,693.00,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1765,7847,639,40736,6102,3,217,1,1145.45,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1766,7847,639,40736,6102,3,68,1,240.54,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(1767,7847,639,40736,6102,3,57,2,1385.99,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(1768,7847,640,40736,6102,3,217,1,694.21,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(1769,7847,640,40736,6102,3,68,1,145.78,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(1770,7847,640,40736,6102,3,57,2,839.99,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(1771,7847,641,40736,6102,3,217,1,3800.90,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(1772,7847,641,40736,6102,3,68,1,399.10,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(1773,7847,641,40736,6102,3,57,2,4200.00,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(1774,7847,642,40736,6102,3,217,1,266676.88,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(1775,7847,642,40736,6102,3,68,1,56002.15,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(1776,7847,642,40736,6102,3,57,2,322679.03,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(1777,7847,643,40736,6102,3,217,1,3800.90,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(1778,7847,643,40736,6102,3,68,1,399.10,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(1779,7847,643,40736,6102,3,57,2,4200.00,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(1780,7847,644,40736,6102,3,217,1,50836.70,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(1781,7847,644,40736,6102,3,68,1,6798.82,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(1782,7847,644,40736,6102,3,217,1,1270.92,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(1783,7847,644,40736,6102,3,57,2,58906.44,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(1784,7847,645,40736,6102,3,217,1,31004.40,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(1785,7847,645,40736,6102,3,68,1,6510.92,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(1786,7847,645,40736,6102,3,57,2,37515.32,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(1787,7847,646,40736,6102,3,217,1,1440.50,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(1788,7847,646,40736,6102,3,68,1,302.51,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(1789,7847,646,40736,6102,3,57,2,1743.01,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(1790,7847,647,40736,6102,3,217,1,1145.45,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(1791,7847,647,40736,6102,3,68,1,240.54,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(1792,7847,647,40736,6102,3,57,2,1385.99,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(1793,7847,648,40736,6102,3,217,1,1145.45,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL);
INSERT INTO `balance_libro_details` VALUES (1794,7847,648,40736,6102,3,68,1,240.54,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(1795,7847,648,40736,6102,3,57,2,1385.99,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(1796,7847,649,40736,6102,3,217,1,1145.45,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(1797,7847,649,40736,6102,3,68,1,240.54,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(1798,7847,649,40736,6102,3,57,2,1385.99,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(1799,7847,650,40736,6102,3,217,1,694.21,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(1800,7847,650,40736,6102,3,68,1,145.78,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(1801,7847,650,40736,6102,3,57,2,839.99,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(1802,7847,651,40736,6102,3,217,1,694.21,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(1803,7847,651,40736,6102,3,68,1,145.78,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(1804,7847,651,40736,6102,3,57,2,839.99,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(1805,7847,652,40736,6102,3,217,1,1093.39,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(1806,7847,652,40736,6102,3,68,1,229.61,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(1807,7847,652,40736,6102,3,57,2,1323.00,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(1808,7847,653,40736,6102,3,217,1,1093.39,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(1809,7847,653,40736,6102,3,68,1,229.61,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(1810,7847,653,40736,6102,3,57,2,1323.00,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(1811,7847,654,40736,6102,3,217,1,1145.45,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(1812,7847,654,40736,6102,3,68,1,240.54,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(1813,7847,654,40736,6102,3,57,2,1385.99,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(1814,7847,655,40736,6102,3,217,1,30215.00,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(1815,7847,655,40736,6102,3,68,1,6345.15,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(1816,7847,655,40736,6102,3,217,1,755.38,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(1817,7847,655,40736,6102,3,57,2,37315.53,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(1818,7847,656,40736,6102,3,217,1,494316.00,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(1819,7847,656,40736,6102,3,68,1,103806.36,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(1820,7847,656,40736,6102,3,217,1,12357.90,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(1821,7847,656,40736,6102,3,57,2,610480.26,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(1822,7847,657,40736,6102,3,217,1,39590.00,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(1823,7847,657,40736,6102,3,68,1,8313.90,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(1824,7847,657,40736,6102,3,217,1,989.75,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(1825,7847,657,40736,6102,3,57,2,48893.65,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(1826,7847,658,40736,6102,3,217,1,5067.87,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(1827,7847,658,40736,6102,3,68,1,532.13,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(1828,7847,658,40736,6102,3,57,2,5600.00,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(1829,7847,659,40736,6102,3,217,1,260557.33,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(1830,7847,659,40736,6102,3,68,1,54717.04,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(1831,7847,659,40736,6102,3,57,2,315274.37,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(1832,7847,660,40736,6102,3,217,1,76486.92,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(1833,7847,660,40736,6102,3,68,1,16062.25,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(1834,7847,660,40736,6102,3,57,2,92549.17,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL);
INSERT INTO `balance_libro_details` VALUES (1835,7847,661,40736,6102,3,217,1,1145.45,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(1836,7847,661,40736,6102,3,68,1,240.54,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(1837,7847,661,40736,6102,3,57,2,1385.99,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(1838,7847,662,40736,6102,3,217,2,39590.00,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(1839,7847,662,40736,6102,3,67,2,8313.90,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(1840,7847,662,40736,6102,3,217,2,989.75,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(1841,7847,662,40736,6102,3,57,1,48893.65,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(1842,7847,663,40736,6102,3,217,2,30215.00,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(1843,7847,663,40736,6102,3,67,2,6345.15,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(1844,7847,663,40736,6102,3,217,2,755.38,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(1845,7847,663,40736,6102,3,57,1,37315.53,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(1846,7847,664,40736,6102,3,217,1,134781.91,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(1847,7847,664,40736,6102,3,68,1,28304.20,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(1848,7847,664,40736,6102,3,57,2,163086.11,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(1849,7847,665,40736,6102,3,217,1,30238.16,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(1850,7847,665,40736,6102,3,68,1,6350.01,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(1851,7847,665,40736,6102,3,57,2,36588.17,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(1852,7847,666,40736,6102,3,217,1,49533.89,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(1853,7847,666,40736,6102,3,68,1,5201.05,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(1854,7847,666,40736,6102,3,57,2,54734.94,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(1855,7847,667,40736,6102,3,250,1,24000.00,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(1856,7847,667,40736,6102,3,57,2,24000.00,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(1857,7847,668,40736,6102,3,217,1,694.21,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(1858,7847,668,40736,6102,3,68,1,145.78,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(1859,7847,668,40736,6102,3,57,2,839.99,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(1860,7847,669,40736,6102,3,217,1,694.21,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(1861,7847,669,40736,6102,3,68,1,145.78,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(1862,7847,669,40736,6102,3,57,2,839.99,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(1863,7847,670,40736,6102,3,217,1,1440.50,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(1864,7847,670,40736,6102,3,68,1,302.51,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(1865,7847,670,40736,6102,3,57,2,1743.01,NULL,'2023-02-24 11:52:53','2023-02-24 11:52:53',NULL),(1866,7847,671,40736,6102,3,217,1,1145.45,NULL,'2023-02-24 11:52:53','2023-02-24 11:52:53',NULL),(1867,7847,671,40736,6102,3,68,1,240.54,NULL,'2023-02-24 11:52:53','2023-02-24 11:52:53',NULL),(1868,7847,671,40736,6102,3,57,2,1385.99,NULL,'2023-02-24 11:52:53','2023-02-24 11:52:53',NULL),(1869,7847,672,40736,6102,3,217,1,1440.50,NULL,'2023-02-24 11:52:53','2023-02-24 11:52:53',NULL),(1870,7847,672,40736,6102,3,68,1,302.51,NULL,'2023-02-24 11:52:53','2023-02-24 11:52:53',NULL),(1871,7847,672,40736,6102,3,57,2,1743.01,NULL,'2023-02-24 11:52:53','2023-02-24 11:52:53',NULL),(1872,7847,673,40736,6102,3,217,1,5067.87,NULL,'2023-02-24 11:52:53','2023-02-24 11:52:53',NULL),(1873,7847,673,40736,6102,3,68,1,532.13,NULL,'2023-02-24 11:52:53','2023-02-24 11:52:53',NULL),(1874,7847,673,40736,6102,3,57,2,5600.00,NULL,'2023-02-24 11:52:53','2023-02-24 11:52:53',NULL),(1875,7847,674,40736,6102,3,217,1,494316.00,NULL,'2023-02-24 11:52:53','2023-02-24 11:52:53',NULL);
INSERT INTO `balance_libro_details` VALUES (1876,7847,674,40736,6102,3,68,1,103806.36,NULL,'2023-02-24 11:52:53','2023-02-24 11:52:53',NULL),(1877,7847,674,40736,6102,3,217,1,12357.90,NULL,'2023-02-24 11:52:53','2023-02-24 11:52:53',NULL),(1878,7847,674,40736,6102,3,57,2,610480.26,NULL,'2023-02-24 11:52:53','2023-02-24 11:52:53',NULL),(1879,7847,675,40736,6102,3,250,1,0.00,NULL,'2023-02-24 11:52:53','2023-02-24 11:52:53',NULL),(1880,7847,675,40736,6102,3,57,2,0.00,NULL,'2023-02-24 11:52:53','2023-02-24 11:52:53',NULL),(1881,7847,676,40720,1534,2,96,2,17190.08,NULL,'2023-03-28 10:43:34','2023-03-28 10:43:34',NULL),(1882,7847,676,40720,1534,2,67,2,3609.92,NULL,'2023-03-28 10:43:34','2023-03-28 10:43:34',NULL),(1883,7847,676,40720,1534,2,13,1,20800.00,NULL,'2023-03-28 10:43:34','2023-03-28 10:43:34',NULL),(1884,7847,677,40720,1534,2,96,2,24388.43,NULL,'2023-03-28 10:43:34','2023-03-28 10:43:34',NULL),(1885,7847,677,40720,1534,2,67,2,5121.57,NULL,'2023-03-28 10:43:34','2023-03-28 10:43:34',NULL),(1886,7847,677,40720,1534,2,13,1,29510.00,NULL,'2023-03-28 10:43:34','2023-03-28 10:43:34',NULL),(1887,7847,678,40720,1534,3,217,1,11542.12,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(1888,7847,678,40720,1534,3,68,1,2423.84,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(1889,7847,678,40720,1534,3,217,1,934.54,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(1890,7847,678,40720,1534,3,57,2,14900.50,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(1891,7847,679,40720,1534,3,217,1,22948.36,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(1892,7847,679,40720,1534,3,68,1,4819.16,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(1893,7847,679,40720,1534,3,57,2,27767.52,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(1894,7847,680,40720,1534,3,217,1,7816.95,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(1895,7847,680,40720,1534,3,68,1,1641.56,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(1896,7847,680,40720,1534,3,217,1,1444.66,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(1897,7847,680,40720,1534,3,57,2,10903.17,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(1898,7847,681,40720,1534,3,250,1,19000.00,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(1899,7847,681,40720,1534,3,57,2,19000.00,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(1900,7847,682,40720,1534,3,217,1,218595.10,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(1901,7847,682,40720,1534,3,68,1,45904.97,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(1902,7847,682,40720,1534,3,57,2,264500.07,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(1903,7847,683,40720,1534,3,217,1,330578.60,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(1904,7847,683,40720,1534,3,68,1,69421.51,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(1905,7847,683,40720,1534,3,57,2,400000.11,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(1906,7847,684,40720,1534,3,217,1,280164.46,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(1907,7847,684,40720,1534,3,68,1,58834.54,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(1908,7847,684,40720,1534,3,57,2,338999.00,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(1909,7847,685,40720,1534,3,217,1,165289.30,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(1910,7847,685,40720,1534,3,68,1,34710.75,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(1911,7847,685,40720,1534,3,57,2,200000.05,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(1912,7847,686,40720,1534,3,217,1,247940.00,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(1913,7847,686,40720,1534,3,68,1,52067.40,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(1914,7847,686,40720,1534,3,57,2,300007.40,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(1915,7847,687,40720,1534,3,217,1,247935.00,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(1916,7847,687,40720,1534,3,68,1,52066.35,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL);
INSERT INTO `balance_libro_details` VALUES (1917,7847,687,40720,1534,3,57,2,300001.35,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL);
/*!40000 ALTER TABLE `balance_libro_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs`
--

DROP TABLE IF EXISTS `blogs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fecha` date NOT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `blogs_categoria_sub_id` int(10) unsigned NOT NULL,
  `path` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `titulo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `contenido` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autor` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `publicar` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  KEY `blogs_blogs_categoria_sub_id_foreign` (`blogs_categoria_sub_id`),
  CONSTRAINT `blogs_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`),
  CONSTRAINT `blogs_blogs_categoria_sub_id_foreign` FOREIGN KEY (`blogs_categoria_sub_id`) REFERENCES `blogs_categorias_sub` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs`
--

LOCK TABLES `blogs` WRITE;
/*!40000 ALTER TABLE `blogs` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias`
--

DROP TABLE IF EXISTS `blogs_categorias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias`
--

LOCK TABLES `blogs_categorias` WRITE;
/*!40000 ALTER TABLE `blogs_categorias` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias_sub`
--

DROP TABLE IF EXISTS `blogs_categorias_sub`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias_sub` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_categorias_sub_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  CONSTRAINT `blogs_categorias_sub_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias_sub`
--

LOCK TABLES `blogs_categorias_sub` WRITE;
/*!40000 ALTER TABLE `blogs_categorias_sub` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias_sub` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_alicuotas`
--

DROP TABLE IF EXISTS `bs_per_alicuotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_alicuotas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `anio` int(10) unsigned NOT NULL,
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `desde` decimal(16,2) NOT NULL DEFAULT '0.00',
  `hasta` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `mas_porcentaje` decimal(16,4) NOT NULL DEFAULT '0.0000',
  `excedente` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_alicuotas`
--

LOCK TABLES `bs_per_alicuotas` WRITE;
/*!40000 ALTER TABLE `bs_per_alicuotas` DISABLE KEYS */;
INSERT INTO `bs_per_alicuotas` VALUES (1,2017,950000.00,0.00,999999999.99,0.00,0.0050,950000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,2018,1050000.00,0.00,999999999.99,0.00,0.0025,1050000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,2019,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2019-11-19 21:09:50','2022-09-15 14:37:11',NULL),(4,2019,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2019-11-19 21:09:50','2022-09-15 14:37:11',NULL),(5,2019,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2019-11-19 21:09:50','2022-09-15 14:37:11',NULL),(6,2019,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-09-15 14:37:11','2022-09-15 14:37:11',NULL),(7,2020,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2022-09-15 14:37:18','2022-09-15 14:37:18',NULL),(8,2020,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2022-09-15 14:37:18','2022-09-15 14:37:18',NULL),(9,2020,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2022-09-15 14:37:18','2022-09-15 14:37:18',NULL),(10,2020,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-09-15 14:37:18','2022-09-15 14:37:18',NULL),(11,2021,6000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2022-09-15 14:37:26','2022-09-15 14:37:26',NULL),(12,2021,6000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2022-09-15 14:37:26','2022-09-15 14:37:26',NULL),(13,2021,6000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2022-09-15 14:37:26','2022-09-15 14:37:26',NULL),(14,2021,6000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-09-15 14:37:26','2022-09-15 14:37:26',NULL),(15,2022,11282141.08,0.00,5641070.54,0.00,0.0050,0.00,'2023-05-30 15:04:41','2023-05-30 15:04:41',NULL),(16,2022,11282141.08,5641070.54,12222319.51,28205.35,0.0075,5641070.54,'2023-05-30 15:04:41','2023-05-30 15:04:41',NULL),(17,2022,11282141.08,12222319.51,33846423.25,77564.72,0.0100,12222319.51,'2023-05-30 15:04:41','2023-05-30 15:04:41',NULL),(18,2022,11282141.08,33846423.25,188035684.71,293802.76,0.0125,33846423.25,'2023-05-30 15:04:41','2023-05-30 15:04:41',NULL),(19,2022,11282141.08,188035684.71,564107054.14,2221171.53,0.0150,188035684.71,'2023-05-30 15:04:41','2023-05-30 15:04:41',NULL),(20,2022,11282141.08,564107054.14,999999999999.00,7682242.07,0.0175,564107054.14,'2023-05-30 15:04:41','2023-05-30 15:04:41',NULL);
/*!40000 ALTER TABLE `bs_per_alicuotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_ddjjs`
--

DROP TABLE IF EXISTS `bs_per_ddjjs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_ddjjs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `anio` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `total_bienes_gravados` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total_bienes_exentos` decimal(16,2) NOT NULL DEFAULT '0.00',
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `base_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto_determinado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_pagar` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_favor` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_per_ddjjs_person_id_foreign` (`person_id`),
  CONSTRAINT `bs_per_ddjjs_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_ddjjs`
--

LOCK TABLES `bs_per_ddjjs` WRITE;
/*!40000 ALTER TABLE `bs_per_ddjjs` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_per_ddjjs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_conceptos`
--

DROP TABLE IF EXISTS `bs_pers_conceptos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_conceptos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_conceptos`
--

LOCK TABLES `bs_pers_conceptos` WRITE;
/*!40000 ALTER TABLE `bs_pers_conceptos` DISABLE KEYS */;
INSERT INTO `bs_pers_conceptos` VALUES (1,'Inmuebles',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,'Derechos Reales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,'Naves y Aeronaves',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(4,'Automotores y otros rodados',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(5,'Dinero y depósitos en dinero',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(6,'Títulos, acciones, cuotas o participaciones sociales y otros títulos valores',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(7,'Patrimonio de empresas o explotaciones unipersonales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(8,'Créditos y debentures',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(9,'Derechos de propiedad científica, literaria o artística, marcas, patentes y sus licencias',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(10,'Otros Bienes (incluye semovientes, antigüedades, objetos de colección, objetos de arte, ...)',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(11,'Objetos Personales y del Hogar',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL);
/*!40000 ALTER TABLE `bs_pers_conceptos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_anticipos`
--

DROP TABLE IF EXISTS `bs_pers_detail_anticipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_anticipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ganan_concepto_anticipo_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_anticipos_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` (`ganan_concepto_anticipo_id`),
  CONSTRAINT `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` FOREIGN KEY (`ganan_concepto_anticipo_id`) REFERENCES `ganan_conceptos_anticipos` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_anticipos`
--

LOCK TABLES `bs_pers_detail_anticipos` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_bienes`
--

DROP TABLE IF EXISTS `bs_pers_detail_bienes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_bienes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `bs_pers_concepto_id` int(10) unsigned NOT NULL,
  `concepto` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe_gravado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `importe_exento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_bienes_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` (`bs_pers_concepto_id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` FOREIGN KEY (`bs_pers_concepto_id`) REFERENCES `bs_pers_conceptos` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_bienes`
--

LOCK TABLES `bs_pers_detail_bienes` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar`
--

DROP TABLE IF EXISTS `calendar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `ws_telefono_id` bigint(20) unsigned DEFAULT NULL,
  `title` longtext COLLATE utf8mb4_unicode_ci,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `descripcion_text` longtext COLLATE utf8mb4_unicode_ci,
  `url` text COLLATE utf8mb4_unicode_ci,
  `start` datetime DEFAULT NULL,
  `startEditable` tinyint(1) NOT NULL DEFAULT '1',
  `startStr` text COLLATE utf8mb4_unicode_ci,
  `end` datetime DEFAULT NULL,
  `endStr` text COLLATE utf8mb4_unicode_ci,
  `allDay` tinyint(1) NOT NULL DEFAULT '1',
  `allow` tinyint(1) DEFAULT NULL,
  `backgroundColor` text COLLATE utf8mb4_unicode_ci,
  `borderColor` text COLLATE utf8mb4_unicode_ci,
  `classNames` longtext COLLATE utf8mb4_unicode_ci,
  `constraint` text COLLATE utf8mb4_unicode_ci,
  `display` text COLLATE utf8mb4_unicode_ci,
  `durationEditable` tinyint(1) NOT NULL DEFAULT '1',
  `extendedProps` longtext COLLATE utf8mb4_unicode_ci,
  `groupId` text COLLATE utf8mb4_unicode_ci,
  `overlap` text COLLATE utf8mb4_unicode_ci,
  `source` longtext COLLATE utf8mb4_unicode_ci,
  `textColor` text COLLATE utf8mb4_unicode_ci,
  `is_impuesto_from_taxes` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_person_id_foreign` (`person_id`),
  KEY `calendar_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `calendar_ws_telefono_id_foreign` (`ws_telefono_id`),
  CONSTRAINT `calendar_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `calendar_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `calendar_ws_telefono_id_foreign` FOREIGN KEY (`ws_telefono_id`) REFERENCES `ws_telefonos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar`
--

LOCK TABLES `calendar` WRITE;
/*!40000 ALTER TABLE `calendar` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_emails_telefonos`
--

DROP TABLE IF EXISTS `calendar_emails_telefonos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_emails_telefonos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `calendar_id` bigint(20) unsigned NOT NULL,
  `email` text COLLATE utf8mb4_unicode_ci,
  `celular` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_emails_telefonos_calendar_id_foreign` (`calendar_id`),
  CONSTRAINT `calendar_emails_telefonos_calendar_id_foreign` FOREIGN KEY (`calendar_id`) REFERENCES `calendar` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_emails_telefonos`
--

LOCK TABLES `calendar_emails_telefonos` WRITE;
/*!40000 ALTER TABLE `calendar_emails_telefonos` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_emails_telefonos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_files`
--

DROP TABLE IF EXISTS `calendar_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `calendar_id` bigint(20) unsigned NOT NULL,
  `path` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `original_name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_files_calendar_id_foreign` (`calendar_id`),
  CONSTRAINT `calendar_files_calendar_id_foreign` FOREIGN KEY (`calendar_id`) REFERENCES `calendar` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_files`
--

LOCK TABLES `calendar_files` WRITE;
/*!40000 ALTER TABLE `calendar_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_niv_1`
--

DROP TABLE IF EXISTS `calendar_niv_1`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_niv_1` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `detalle` text COLLATE utf8mb4_unicode_ci,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_niv_1_person_id_foreign` (`person_id`),
  CONSTRAINT `calendar_niv_1_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_niv_1`
--

LOCK TABLES `calendar_niv_1` WRITE;
/*!40000 ALTER TABLE `calendar_niv_1` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_niv_1` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_niv_1_2`
--

DROP TABLE IF EXISTS `calendar_niv_1_2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_niv_1_2` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `calendar_niv_1_id` bigint(20) unsigned NOT NULL,
  `calendar_niv_2_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_niv_1_2_person_id_foreign` (`person_id`),
  KEY `calendar_niv_1_2_calendar_niv_1_id_foreign` (`calendar_niv_1_id`),
  KEY `calendar_niv_1_2_calendar_niv_2_id_foreign` (`calendar_niv_2_id`),
  CONSTRAINT `calendar_niv_1_2_calendar_niv_1_id_foreign` FOREIGN KEY (`calendar_niv_1_id`) REFERENCES `calendar_niv_1` (`id`),
  CONSTRAINT `calendar_niv_1_2_calendar_niv_2_id_foreign` FOREIGN KEY (`calendar_niv_2_id`) REFERENCES `calendar_niv_2` (`id`),
  CONSTRAINT `calendar_niv_1_2_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_niv_1_2`
--

LOCK TABLES `calendar_niv_1_2` WRITE;
/*!40000 ALTER TABLE `calendar_niv_1_2` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_niv_1_2` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_niv_2`
--

DROP TABLE IF EXISTS `calendar_niv_2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_niv_2` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `detalle` text COLLATE utf8mb4_unicode_ci,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_niv_2_person_id_foreign` (`person_id`),
  CONSTRAINT `calendar_niv_2_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_niv_2`
--

LOCK TABLES `calendar_niv_2` WRITE;
/*!40000 ALTER TABLE `calendar_niv_2` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_niv_2` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_notificaciones`
--

DROP TABLE IF EXISTS `calendar_notificaciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_notificaciones` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `calendar_id` bigint(20) unsigned NOT NULL,
  `start` datetime DEFAULT NULL,
  `tipo_de_notificacion_id` int(10) unsigned NOT NULL,
  `cantidad` int(10) unsigned NOT NULL,
  `unidad_de_tiempo_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_notificaciones_calendar_id_foreign` (`calendar_id`),
  CONSTRAINT `calendar_notificaciones_calendar_id_foreign` FOREIGN KEY (`calendar_id`) REFERENCES `calendar` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_notificaciones`
--

LOCK TABLES `calendar_notificaciones` WRITE;
/*!40000 ALTER TABLE `calendar_notificaciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_notificaciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_tur_dispo`
--

DROP TABLE IF EXISTS `calendar_tur_dispo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_tur_dispo` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `calendar_niv_1_id` bigint(20) unsigned NOT NULL,
  `calendar_niv_2_id` bigint(20) unsigned NOT NULL,
  `dia_hora` datetime(5) DEFAULT NULL,
  `duracion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '00:30',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_tur_dispo_person_id_foreign` (`person_id`),
  KEY `calendar_tur_dispo_calendar_niv_1_id_foreign` (`calendar_niv_1_id`),
  KEY `calendar_tur_dispo_calendar_niv_2_id_foreign` (`calendar_niv_2_id`),
  CONSTRAINT `calendar_tur_dispo_calendar_niv_1_id_foreign` FOREIGN KEY (`calendar_niv_1_id`) REFERENCES `calendar_niv_1` (`id`),
  CONSTRAINT `calendar_tur_dispo_calendar_niv_2_id_foreign` FOREIGN KEY (`calendar_niv_2_id`) REFERENCES `calendar_niv_2` (`id`),
  CONSTRAINT `calendar_tur_dispo_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_tur_dispo`
--

LOCK TABLES `calendar_tur_dispo` WRITE;
/*!40000 ALTER TABLE `calendar_tur_dispo` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_tur_dispo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_tur_dispo_datos`
--

DROP TABLE IF EXISTS `calendar_tur_dispo_datos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_tur_dispo_datos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `calendar_tur_dispo_id` bigint(20) unsigned NOT NULL,
  `email` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `nombre_ape` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `celular` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_tur_dispo_datos_person_id_foreign` (`person_id`),
  KEY `calendar_tur_dispo_datos_calendar_tur_dispo_id_foreign` (`calendar_tur_dispo_id`),
  CONSTRAINT `calendar_tur_dispo_datos_calendar_tur_dispo_id_foreign` FOREIGN KEY (`calendar_tur_dispo_id`) REFERENCES `calendar_tur_dispo` (`id`),
  CONSTRAINT `calendar_tur_dispo_datos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_tur_dispo_datos`
--

LOCK TABLES `calendar_tur_dispo_datos` WRITE;
/*!40000 ALTER TABLE `calendar_tur_dispo_datos` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_tur_dispo_datos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calle`
--

DROP TABLE IF EXISTS `calle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calle` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `localidad_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `desdealt` int(10) unsigned DEFAULT NULL,
  `hastaalt` int(10) unsigned DEFAULT NULL,
  `codpostal` int(10) unsigned DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calle_localidad_id_foreign` (`localidad_id`),
  CONSTRAINT `calle_localidad_id_foreign` FOREIGN KEY (`localidad_id`) REFERENCES `localidad` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calle`
--

LOCK TABLES `calle` WRITE;
/*!40000 ALTER TABLE `calle` DISABLE KEYS */;
INSERT INTO `calle` VALUES (1,NULL,1,'Ramon Falcon',6800,7500,1408,1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL);
/*!40000 ALTER TABLE `calle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_iibb`
--

DROP TABLE IF EXISTS `categorias_iibb`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_iibb` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `impuesto` decimal(16,2) DEFAULT NULL,
  `anual` decimal(16,2) DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_iibb`
--

LOCK TABLES `categorias_iibb` WRITE;
/*!40000 ALTER TABLE `categorias_iibb` DISABLE KEYS */;
INSERT INTO `categorias_iibb` VALUES (1,'A',1850.00,11100.00,370000.00,30,3300,NULL,'1',NULL,'2022-10-23 23:35:44',NULL),(2,'B',2750.00,16500.00,550000.00,45,5000,NULL,'1',NULL,'2022-10-23 23:35:44',NULL),(3,'C',3850.00,23100.00,770000.00,60,6700,NULL,'1',NULL,'2022-10-23 23:35:44',NULL),(4,'D',5300.00,31800.00,1060000.00,85,10000,NULL,'1',NULL,'2022-10-23 23:35:44',NULL),(5,'E',7000.00,42000.00,1400000.00,110,13000,NULL,'1',NULL,'2022-10-23 23:35:44',NULL),(6,'F',8750.00,52500.00,1750000.00,150,16500,NULL,'1',NULL,'2022-10-23 23:35:44',NULL),(7,'G',10500.00,63000.00,2100000.00,200,20000,NULL,'1',NULL,'2022-10-23 23:35:44',NULL),(8,'H',13000.00,78000.00,2600000.00,200,20000,NULL,'1',NULL,'2022-10-23 23:35:44',NULL);
/*!40000 ALTER TABLE `categorias_iibb` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_monotributo`
--

DROP TABLE IF EXISTS `categorias_monotributo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_monotributo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `facMensual` decimal(16,2) DEFAULT NULL,
  `actividad` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `empleados` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `alquileres` decimal(16,2) DEFAULT NULL,
  `impuesto_servicio` decimal(16,2) DEFAULT NULL,
  `impuesto_venta` decimal(16,2) DEFAULT NULL,
  `sipa` decimal(16,2) DEFAULT NULL,
  `obraSocial` decimal(16,2) DEFAULT NULL,
  `totalServicio` decimal(16,2) DEFAULT NULL,
  `totalVenta` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `desde` date DEFAULT NULL,
  `hasta` date DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_monotributo`
--

LOCK TABLES `categorias_monotributo` WRITE;
/*!40000 ALTER TABLE `categorias_monotributo` DISABLE KEYS */;
INSERT INTO `categorias_monotributo` VALUES (1,'A',2108288.01,175690.67,'No Excluida','0',30,3330,485448.92,1047.86,1047.86,4623.27,6457.26,12128.39,12128.39,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(2,'B',3133941.63,261161.80,'No Excluida','0',45,5000,485448.92,2018.89,2018.89,5085.60,6457.26,13561.75,13561.75,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(3,'C',4387518.23,365626.52,'No Excluida','0',60,6700,970897.79,3452.09,3190.00,5594.16,6457.26,15503.51,15241.42,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(4,'D',5449094.55,454091.21,'No Excluida','0',85,10000,970897.79,5671.23,5239.75,6153.58,7673.13,19497.94,19066.46,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(5,'E',6416528.72,534710.73,'No Excluida','0',110,13000,1209769.40,10787.67,8368.13,6768.94,9389.36,26945.97,24526.43,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(6,'F',8020660.90,668388.41,'No Excluida','0',150,16500,1213622.14,14840.88,10926.38,7445.83,10850.90,33137.61,29223.11,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(7,'G',9624793.05,802066.09,'No Excluida','0',200,20000,1456346.67,18878.58,13623.24,8190.41,11625.96,38694.95,33439.61,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(8,'H',11916410.45,993034.20,'No Excluida','0',200,20000,1941795.53,43150.91,33442.08,9009.45,13951.15,66111.51,56402.68,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(9,'I',13337213.22,1111434.44,'Venta de Bs Muebles','0',200,20000,1941795.53,NULL,53938.71,9910.39,17272.86,NULL,81121.96,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(10,'J',15285088.04,1273757.34,'Venta de Bs Muebles','0',200,20000,1941795.53,NULL,63385.73,10901.43,19332.31,NULL,93619.47,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(11,'K',16957968.71,1413164.06,'Venta de Bs Muebles','0',200,20000,1941795.53,NULL,72817.31,11991.57,22155.77,NULL,106964.65,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(12,'Monotributo Social',1414762.00,117896.00,'No Excluida','0',0,0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,NULL,'2018-01-01',NULL,'1','2020-02-27 02:46:40','2020-02-27 02:46:40',NULL),(13,'A Exento',1414762.00,117896.00,NULL,NULL,NULL,NULL,230178.48,0.00,0.00,2192.15,3061.75,5253.90,5253.90,'',NULL,NULL,'0',NULL,NULL,NULL),(14,'B Exento',2103025.00,175252.00,NULL,NULL,NULL,NULL,230178.48,0.00,0.00,2411.36,3061.75,5473.11,5473.11,'',NULL,NULL,'0',NULL,NULL,NULL);
/*!40000 ALTER TABLE `categorias_monotributo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `charlas_details`
--

DROP TABLE IF EXISTS `charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `charla` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `charlas_details`
--

LOCK TABLES `charlas_details` WRITE;
/*!40000 ALTER TABLE `charlas_details` DISABLE KEYS */;
INSERT INTO `charlas_details` VALUES (5,7847,'COORDINAMOS UNA REUNIÓN ´PARA EL DIA 15/10 HORARIO A CONFIRMAR- MOTIVO: CONSTITUCION SRL',40721,1,'2023-01-24 15:19:06','2023-01-24 15:19:06',NULL);
/*!40000 ALTER TABLE `charlas_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `CharlaDetail_BD` BEFORE DELETE ON `charlas_details` FOR EACH ROW insert into back_up_charlas_details (charla,person_id,modificado)
values(old.charla,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `chequeras_tipos`
--

DROP TABLE IF EXISTS `chequeras_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `chequeras_tipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chequeras_tipos`
--

LOCK TABLES `chequeras_tipos` WRITE;
/*!40000 ALTER TABLE `chequeras_tipos` DISABLE KEYS */;
INSERT INTO `chequeras_tipos` VALUES (1,NULL,'Fisica',1,NULL,NULL,NULL),(2,NULL,'Electronica',1,NULL,NULL,NULL),(3,NULL,'Transferencias',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `chequeras_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cheques_transfer_emitidas`
--

DROP TABLE IF EXISTS `cheques_transfer_emitidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cheques_transfer_emitidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_cliente_detail_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_detail_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_banco_cheq_id` int(10) unsigned NOT NULL,
  `fecha_emision` date NOT NULL,
  `fecha_cobro` date NOT NULL,
  `numero_cheque` int(11) NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cheques_transfer_emitidas_person_id_foreign` (`person_id`),
  KEY `cheques_transfer_emitidas_cta_cte_cliente_detail_id_foreign` (`cta_cte_cliente_detail_id`),
  KEY `cheques_transfer_emitidas_cta_cte_tesoreria_detail_id_foreign` (`cta_cte_tesoreria_detail_id`),
  KEY `cheques_transfer_emitidas_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cte_tes_ban_che_id_foreign` (`cta_cte_tesoreria_banco_cheq_id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_cliente_detail_id_foreign` FOREIGN KEY (`cta_cte_cliente_detail_id`) REFERENCES `cta_cte_cliente_details` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_tesoreria_detail_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_detail_id`) REFERENCES `cta_cte_tesoreria_detail` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cte_tes_ban_che_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_banco_cheq_id`) REFERENCES `cta_cte_tesoreria_banco_cheq` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cheques_transfer_emitidas`
--

LOCK TABLES `cheques_transfer_emitidas` WRITE;
/*!40000 ALTER TABLE `cheques_transfer_emitidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `cheques_transfer_emitidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claves`
--

DROP TABLE IF EXISTS `claves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves`
--

LOCK TABLES `claves` WRITE;
/*!40000 ALTER TABLE `claves` DISABLE KEYS */;
INSERT INTO `claves` VALUES (1,NULL,'Clave Fiscal',NULL,NULL,NULL),(2,NULL,'Clave Ciudad',NULL,NULL,NULL),(3,NULL,'Clave ARBA',NULL,NULL,NULL),(4,NULL,'Clave ANSES',NULL,NULL,NULL),(5,NULL,'Catedral',NULL,NULL,NULL),(6,NULL,'CEMIBA',NULL,NULL,NULL),(7,NULL,'COMPRA ARG',NULL,NULL,NULL),(8,NULL,'Consejo Ciencias Economicas',NULL,NULL,NULL),(9,NULL,'Correo',NULL,NULL,NULL),(10,NULL,'CUR',NULL,NULL,NULL),(11,NULL,'Firma Digital',NULL,NULL,NULL),(12,NULL,'Interbanking',NULL,NULL,NULL),(13,NULL,'Banco Citibank',NULL,NULL,NULL),(14,NULL,'Banco Ciudad',NULL,NULL,NULL),(15,NULL,'Banco Frances',NULL,NULL,NULL),(16,NULL,'Banco Galicia',NULL,NULL,NULL),(17,NULL,'Banco HSBC',NULL,NULL,NULL),(18,NULL,'Banco Itau',NULL,NULL,NULL),(19,NULL,'Banco Nacion',NULL,NULL,NULL),(20,NULL,'Banco Macro',NULL,NULL,NULL),(21,NULL,'Banco Patagonia',NULL,NULL,NULL),(22,NULL,'Banco Provincia',NULL,NULL,NULL),(23,NULL,'Banco Santander',NULL,NULL,NULL),(24,NULL,'Banco Supervielle',NULL,NULL,NULL),(25,NULL,'Seguridad e Higiene',NULL,NULL,NULL),(26,NULL,'Sindicato - ANSES',NULL,NULL,NULL),(27,NULL,'Sindicato - AOT',NULL,NULL,NULL),(28,NULL,'Sindicato - ATSA',NULL,NULL,NULL),(29,NULL,'Sindicato - Camioneros',NULL,NULL,NULL),(30,NULL,'Sindicato - Guinchero',NULL,NULL,NULL),(31,NULL,'Sindicato - IERIC',NULL,NULL,NULL),(32,NULL,'Sindicato - La Estrella',NULL,NULL,NULL),(33,NULL,'Sindicato - Nemesis',NULL,NULL,NULL),(34,NULL,'Sindicato - Pasta',NULL,NULL,NULL),(35,NULL,'Sindicato - SEC',NULL,NULL,NULL),(36,NULL,'Sindicato - SICOP',NULL,NULL,NULL),(37,NULL,'Sindicato - SOCAYA',NULL,NULL,NULL),(38,NULL,'Sindicato - UTHGRA',NULL,NULL,NULL),(39,NULL,'Sindicato - INACAP',NULL,NULL,NULL),(40,NULL,'Sindicato - Otro',NULL,NULL,NULL),(41,NULL,'Otra',NULL,NULL,NULL),(42,NULL,'Prisma - Firma Digital',NULL,NULL,NULL),(43,NULL,'Sindicato - FATSA',NULL,NULL,NULL),(44,7847,'Clave Municipal','2022-11-17 12:37:43','2022-11-17 12:37:43',NULL);
/*!40000 ALTER TABLE `claves` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claves_details`
--

DROP TABLE IF EXISTS `claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `claves_details_clave_id_foreign` (`clave_id`),
  KEY `claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_details`
--

LOCK TABLES `claves_details` WRITE;
/*!40000 ALTER TABLE `claves_details` DISABLE KEYS */;
INSERT INTO `claves_details` VALUES (13,7847,NULL,'Micaela2022',NULL,1,40736,1,'2022-10-30 07:06:46','2022-10-30 07:06:46',NULL),(14,7847,NULL,'Patricio2019',NULL,3,40736,1,'2022-10-30 07:06:46','2022-10-30 07:06:46',NULL),(18,7847,NULL,'231884',NULL,3,40745,1,'2022-11-08 15:02:48','2022-11-08 15:02:48',NULL),(19,7847,NULL,'Mariani2022',NULL,1,40745,1,'2022-11-08 15:02:48','2022-11-08 15:02:48',NULL),(20,7847,'MUNICIPALIDAD','Acuña2022','SEG E HIG',41,40745,1,'2022-11-08 15:02:48','2022-11-08 15:02:48',NULL),(21,7847,'AFIP','Misteriosa09',NULL,1,40735,1,'2022-11-28 13:34:35','2022-11-28 13:34:35',NULL),(22,7847,'ARBA','Misteriosa09',NULL,3,40735,1,'2022-11-28 13:34:35','2022-11-28 13:34:35',NULL),(23,7847,'AFIP','Carlos2022',NULL,1,40721,1,'2023-01-24 15:19:06','2023-01-24 15:19:06',NULL),(24,7847,'ARBA','Carlos2022','REG SIMPLIFICADO',3,40721,1,'2023-01-24 15:19:06','2023-01-24 15:19:06',NULL),(25,7847,'afip','Alexis2023',NULL,1,40720,1,'2023-03-28 11:09:24','2023-03-28 11:09:24',NULL);
/*!40000 ALTER TABLE `claves_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `ClavesDetail_BD` BEFORE DELETE ON `claves_details` FOR EACH ROW insert into back_up_claves_details (clave,valor,comentario,clave_id,person_id,modificado)
values(old.clave,old.valor,old.comentario,old.clave_id,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `claves_mails`
--

DROP TABLE IF EXISTS `claves_mails`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_mails` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_mails`
--

LOCK TABLES `claves_mails` WRITE;
/*!40000 ALTER TABLE `claves_mails` DISABLE KEYS */;
INSERT INTO `claves_mails` VALUES (1,'Listado de Claves',1,'Claves','claves_mails/claves_listado',NULL,NULL),(3,'Listado de Mails',2,'Mails','claves_mails/mails_listado',NULL,NULL),(5,'Listado de Charlas',3,'Charlas','claves_mails/charlas_listado',NULL,NULL);
/*!40000 ALTER TABLE `claves_mails` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cm_articulos_regimenes`
--

DROP TABLE IF EXISTS `cm_articulos_regimenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cm_articulos_regimenes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `codigo` int(11) DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cm_articulos_regimenes`
--

LOCK TABLES `cm_articulos_regimenes` WRITE;
/*!40000 ALTER TABLE `cm_articulos_regimenes` DISABLE KEYS */;
INSERT INTO `cm_articulos_regimenes` VALUES (1,NULL,'Articulo 2',2,1,'2022-09-15 14:37:19','2022-09-15 14:37:19',NULL),(2,NULL,'Articulo 6',6,0,'2022-09-15 14:37:19','2022-09-15 14:37:19',NULL),(3,NULL,'Articulo 7',7,0,'2022-09-15 14:37:19','2022-09-15 14:37:19',NULL),(4,NULL,'Articulo 8',8,0,'2022-09-15 14:37:19','2022-09-15 14:37:19',NULL),(5,NULL,'Articulo 9',9,0,'2022-09-15 14:37:19','2022-09-15 14:37:19',NULL),(6,NULL,'Articulo 10',10,0,'2022-09-15 14:37:19','2022-09-15 14:37:19',NULL),(7,NULL,'Articulo 11',11,0,'2022-09-15 14:37:19','2022-09-15 14:37:19',NULL),(8,NULL,'Articulo 12',12,0,'2022-09-15 14:37:19','2022-09-15 14:37:19',NULL),(9,NULL,'Articulo 13',13,0,'2022-09-15 14:37:19','2022-09-15 14:37:19',NULL),(10,NULL,'Articulo 14',14,1,'2022-09-15 14:37:19','2022-09-15 14:37:19',NULL);
/*!40000 ALTER TABLE `cm_articulos_regimenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores`
--

DROP TABLE IF EXISTS `cobradores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `telefono` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cobradores_person_id_foreign` (`person_id`),
  CONSTRAINT `cobradores_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores`
--

LOCK TABLES `cobradores` WRITE;
/*!40000 ALTER TABLE `cobradores` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores_datos`
--

DROP TABLE IF EXISTS `cobradores_datos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores_datos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cobrador_id` bigint(20) unsigned NOT NULL,
  `url_panel` longtext COLLATE utf8mb4_unicode_ci,
  `usuario` text COLLATE utf8mb4_unicode_ci,
  `clave` text COLLATE utf8mb4_unicode_ci,
  `numero_de_soporte` text COLLATE utf8mb4_unicode_ci,
  `inicial_create_user` text COLLATE utf8mb4_unicode_ci,
  `imp_min_p_retirar` int(11) DEFAULT NULL,
  `secret_recarga` text COLLATE utf8mb4_unicode_ci,
  `secret_on_off` text COLLATE utf8mb4_unicode_ci,
  `clave_new_user` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cobradores_datos_cobrador_id_foreign` (`cobrador_id`),
  CONSTRAINT `cobradores_datos_cobrador_id_foreign` FOREIGN KEY (`cobrador_id`) REFERENCES `cobradores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores_datos`
--

LOCK TABLES `cobradores_datos` WRITE;
/*!40000 ALTER TABLE `cobradores_datos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores_datos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores_metodos`
--

DROP TABLE IF EXISTS `cobradores_metodos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores_metodos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cobradores_metodos_descripcion_unique` (`descripcion`),
  KEY `cobradores_metodos_person_id_foreign` (`person_id`),
  CONSTRAINT `cobradores_metodos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores_metodos`
--

LOCK TABLES `cobradores_metodos` WRITE;
/*!40000 ALTER TABLE `cobradores_metodos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores_metodos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores_on_off`
--

DROP TABLE IF EXISTS `cobradores_on_off`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores_on_off` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cobrador_id` bigint(20) unsigned NOT NULL,
  `on_off` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cobradores_on_off_cobrador_id_foreign` (`cobrador_id`),
  CONSTRAINT `cobradores_on_off_cobrador_id_foreign` FOREIGN KEY (`cobrador_id`) REFERENCES `cobradores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores_on_off`
--

LOCK TABLES `cobradores_on_off` WRITE;
/*!40000 ALTER TABLE `cobradores_on_off` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores_on_off` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condicion_frente_al_iva`
--

DROP TABLE IF EXISTS `condicion_frente_al_iva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condicion_frente_al_iva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `codigo_afip` int(11) DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `show_comprobantes_a` tinyint(1) NOT NULL DEFAULT '0',
  `show_comprobantes_b` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condicion_frente_al_iva`
--

LOCK TABLES `condicion_frente_al_iva` WRITE;
/*!40000 ALTER TABLE `condicion_frente_al_iva` DISABLE KEYS */;
INSERT INTO `condicion_frente_al_iva` VALUES (1,NULL,1,'IVA Responsable Inscripto',1,0,1,NULL,NULL,NULL),(2,NULL,2,'IVA Responsable no Inscripto',0,0,1,NULL,NULL,NULL),(3,NULL,3,'IVA no Responsable',0,0,1,NULL,NULL,NULL),(4,NULL,4,'IVA Sujeto Exento',0,1,1,NULL,NULL,NULL),(5,NULL,5,'Consumidor Final',0,1,1,NULL,NULL,NULL),(6,NULL,6,'Responsable Monotributo',1,0,1,NULL,NULL,NULL),(7,NULL,7,'Sujeto no Categorizado',0,1,1,NULL,NULL,NULL),(8,NULL,8,'Proveedor del Exterior',0,1,1,NULL,NULL,NULL),(9,NULL,9,'Cliente del Exterior',0,1,1,NULL,NULL,NULL),(10,NULL,10,'IVA Liberado – Ley Nº 19.640',0,1,1,NULL,NULL,NULL),(11,NULL,11,'IVA Responsable Inscripto – Agente de Percepción',0,0,1,NULL,NULL,NULL),(12,NULL,12,'Pequeño Contribuyente Eventual',0,0,1,NULL,NULL,NULL),(13,NULL,13,'Monotributista Social',1,0,1,NULL,NULL,NULL),(14,NULL,14,'Pequeño Contribuyente Eventual Social',0,0,1,NULL,NULL,NULL),(15,NULL,NULL,'Monotributista Trabajador Independiente Promovido',1,0,1,NULL,NULL,NULL),(16,NULL,NULL,'IVA No Alcanzado',0,1,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `condicion_frente_al_iva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condiciones_venta`
--

DROP TABLE IF EXISTS `condiciones_venta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condiciones_venta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condiciones_venta`
--

LOCK TABLES `condiciones_venta` WRITE;
/*!40000 ALTER TABLE `condiciones_venta` DISABLE KEYS */;
INSERT INTO `condiciones_venta` VALUES (1,'Contado',NULL,NULL),(2,'Tarjeta de Debito',NULL,NULL),(3,'Tarjeta de Credito',NULL,NULL),(4,'Cuenta Corriente',NULL,NULL),(5,'Cheque',NULL,NULL),(6,'Ticket',NULL,NULL),(7,'Transferencia',NULL,NULL),(8,'Otra',NULL,NULL);
/*!40000 ALTER TABLE `condiciones_venta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consultas`
--

DROP TABLE IF EXISTS `consultas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consultas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consultas`
--

LOCK TABLES `consultas` WRITE;
/*!40000 ALTER TABLE `consultas` DISABLE KEYS */;
INSERT INTO `consultas` VALUES (1,NULL,'Estado Liquidaciones',1,NULL,NULL,NULL),(2,NULL,'Consumo',1,NULL,NULL,NULL),(3,NULL,'Resultado Liquidacion Hijas',1,'2023-03-12 23:43:57','2023-03-12 23:43:57',NULL);
/*!40000 ALTER TABLE `consultas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consultas_aux`
--

DROP TABLE IF EXISTS `consultas_aux`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consultas_aux` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `consulta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `estado` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `consultas_aux_consulta_id_foreign` (`consulta_id`),
  KEY `consultas_aux_person_id_foreign` (`person_id`),
  CONSTRAINT `consultas_aux_consulta_id_foreign` FOREIGN KEY (`consulta_id`) REFERENCES `consultas` (`id`),
  CONSTRAINT `consultas_aux_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consultas_aux`
--

LOCK TABLES `consultas_aux` WRITE;
/*!40000 ALTER TABLE `consultas_aux` DISABLE KEYS */;
INSERT INTO `consultas_aux` VALUES (1,NULL,1,NULL,'[{\"id\":40720,\"user_id\":7847,\"field_name1\":\"ALEXIS ROY ORTIZ\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"20-33421146-1\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2022-09-17T22:07:02.000000Z\",\"updated_at\":\"2022-09-17T22:07:02.000000Z\",\"activity_id\":null,\"address\":\"Flores Venancio Gral 3059, Capital Federal\",\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iva\":\"Pendiente\",\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":3,\"user_id\":7847,\"person_id\":40720,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2022-09-17T22:07:02.000000Z\",\"updated_at\":\"2022-09-17T22:54:58.000000Z\",\"active\":2,\"enviarMail\":0,\"honorario\":\"18000.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":2,\"obligation_sell\":1,\"obligation_buy\":1,\"obligation_iva\":1,\"obligation_electronic_receipt\":1,\"obligation_iibb\":4,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2022-03\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":2,\"person_id_administrador\":40720,\"person_id_titular\":40720,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2017-07-13T03:00:00.000000Z\",\"iibb\":\"20334211461\",\"fe_leyenda\":null,\"atencion_iva\":1,\"atencion_iva_comentario\":\"19 DE CADA MES\",\"atencion_iibb\":1,\"atencion_iibb_comentario\":\"15 DE CADA MES\",\"deleted_at\":null}],\"liquidador\":null,\"periods\":[{\"id\":1524,\"user_id\":null,\"code\":\"2022-09\",\"year\":2022,\"period_number\":9,\"date_from\":\"2022-09-01\",\"date_to\":\"2022-09-30\",\"created_at\":null,\"updated_at\":null,\"person_id\":40720,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40721,\"user_id\":7847,\"field_name1\":\"RIOS DE AGUA VIVA\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"20-33934148-7\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2022-10-05T13:02:02.000000Z\",\"updated_at\":\"2022-10-05T13:02:02.000000Z\",\"activity_id\":null,\"address\":\"Floresta 1209, Ezeiza C.P.: 1804 Buenos Aires\",\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":4,\"user_id\":7847,\"person_id\":40721,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2022-10-05T13:02:03.000000Z\",\"updated_at\":\"2022-10-05T13:44:26.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":1,\"obligation_sell\":1,\"obligation_buy\":1,\"obligation_iva\":0,\"obligation_electronic_receipt\":0,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2022-03\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":1,\"person_id_administrador\":40721,\"person_id_titular\":40721,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-03-02T03:00:00.000000Z\",\"iibb\":\"20339341487\",\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":null,\"periods\":[{\"id\":4586,\"user_id\":null,\"code\":\"2022-09\",\"year\":2022,\"period_number\":9,\"date_from\":\"2022-09-01\",\"date_to\":\"2022-09-30\",\"created_at\":null,\"updated_at\":null,\"person_id\":40721,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]}]',1,'2022-10-12 00:19:53','2022-10-12 00:19:54',NULL);
/*!40000 ALTER TABLE `consultas_aux` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_asientos`
--

DROP TABLE IF EXISTS `conta_asientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_asientos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `debe_cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `haber_cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `ctactecheque_id` int(10) unsigned DEFAULT NULL,
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `adjunto` text COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `radioChecked` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `CuentaTipo_id` int(10) unsigned DEFAULT NULL,
  `CentroCosto_id` int(10) unsigned DEFAULT NULL,
  `pagado` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_asientos_person_id_foreign` (`person_id`),
  KEY `conta_asientos_period_id_foreign` (`period_id`),
  KEY `conta_asientos_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `conta_asientos_cuentatipo_id_foreign` (`CuentaTipo_id`),
  KEY `conta_asientos_centrocosto_id_foreign` (`CentroCosto_id`),
  KEY `conta_asientos_ctactecheque_id_foreign` (`ctactecheque_id`),
  KEY `conta_asientos_haber_cta_cte_tesoreria_cuenta_id_foreign` (`haber_cta_cte_tesoreria_cuenta_id`),
  KEY `conta_asientos_debe_cta_cte_tesoreria_cuenta_id_foreign` (`debe_cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `conta_asientos_centrocosto_id_foreign` FOREIGN KEY (`CentroCosto_id`) REFERENCES `ctactegastos_centrocosto` (`id`),
  CONSTRAINT `conta_asientos_ctactecheque_id_foreign` FOREIGN KEY (`ctactecheque_id`) REFERENCES `ctacte_cheques` (`id`),
  CONSTRAINT `conta_asientos_cuentatipo_id_foreign` FOREIGN KEY (`CuentaTipo_id`) REFERENCES `ctactegastos_cuenta_tipo` (`idCuentaTipo`),
  CONSTRAINT `conta_asientos_debe_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`debe_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_haber_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`haber_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `conta_asientos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `conta_asientos_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_asientos`
--

LOCK TABLES `conta_asientos` WRITE;
/*!40000 ALTER TABLE `conta_asientos` DISABLE KEYS */;
INSERT INTO `conta_asientos` VALUES (1,7847,40720,NULL,2,NULL,NULL,NULL,NULL,'2022-09-17','2022-09-17',18000.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2022-09-17 19:52:22','2022-09-17 19:52:22',NULL);
/*!40000 ALTER TABLE `conta_asientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_asientos_details`
--

DROP TABLE IF EXISTS `conta_asientos_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_asientos_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_asientos_details_conta_asiento_id_foreign` (`conta_asiento_id`),
  KEY `conta_asientos_details_person_id_foreign` (`person_id`),
  KEY `conta_asientos_details_period_id_foreign` (`period_id`),
  KEY `conta_asientos_details_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `conta_asientos_details_saldo_id_foreign` (`saldo_id`),
  KEY `conta_asientos_details_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `conta_asientos_details_conta_asiento_id_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `conta_asientos_details_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `conta_asientos_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `conta_asientos_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `conta_asientos_details_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_asientos_details`
--

LOCK TABLES `conta_asientos_details` WRITE;
/*!40000 ALTER TABLE `conta_asientos_details` DISABLE KEYS */;
INSERT INTO `conta_asientos_details` VALUES (1,7847,1,40720,NULL,2,13,1,18000.00,'2022-09-17 19:52:22','2022-09-17 19:52:22',NULL),(2,7847,1,40720,NULL,2,480,2,18000.00,'2022-09-17 19:52:22','2022-09-17 19:52:22',NULL);
/*!40000 ALTER TABLE `conta_asientos_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_centro_costo_plan_cuenta`
--

DROP TABLE IF EXISTS `conta_centro_costo_plan_cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_centro_costo_plan_cuenta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_centro_costo_id` bigint(20) unsigned DEFAULT NULL,
  `conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_centro_costo_plan_cuenta_conta_centro_costo_id_foreign` (`conta_centro_costo_id`),
  KEY `conta_centro_costo_plan_cuenta_conta_plan_cuenta_id_foreign` (`conta_plan_cuenta_id`),
  CONSTRAINT `conta_centro_costo_plan_cuenta_conta_centro_costo_id_foreign` FOREIGN KEY (`conta_centro_costo_id`) REFERENCES `conta_centro_costos` (`id`),
  CONSTRAINT `conta_centro_costo_plan_cuenta_conta_plan_cuenta_id_foreign` FOREIGN KEY (`conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_centro_costo_plan_cuenta`
--

LOCK TABLES `conta_centro_costo_plan_cuenta` WRITE;
/*!40000 ALTER TABLE `conta_centro_costo_plan_cuenta` DISABLE KEYS */;
INSERT INTO `conta_centro_costo_plan_cuenta` VALUES (1,7847,1,425,NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_centro_costo_plan_cuenta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_centro_costos`
--

DROP TABLE IF EXISTS `conta_centro_costos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_centro_costos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_centro_costos_person_id_foreign` (`person_id`),
  CONSTRAINT `conta_centro_costos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_centro_costos`
--

LOCK TABLES `conta_centro_costos` WRITE;
/*!40000 ALTER TABLE `conta_centro_costos` DISABLE KEYS */;
INSERT INTO `conta_centro_costos` VALUES (1,7847,40745,'BANCO GALICIA',0,NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_centro_costos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_plan_cuenta`
--

DROP TABLE IF EXISTS `conta_plan_cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_plan_cuenta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `codigo` int(11) NOT NULL,
  `tipo_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `padre` int(11) NOT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rubro` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `no_editable` int(11) NOT NULL DEFAULT '1',
  `tes_cta_cte` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_origen` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_destino` tinyint(1) NOT NULL DEFAULT '0',
  `conta_asientos` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_plan_cuenta_tipo_cuenta_id_foreign` (`tipo_cuenta_id`),
  KEY `conta_plan_cuenta_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `conta_plan_cuenta_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `conta_plan_cuenta_tipo_cuenta_id_foreign` FOREIGN KEY (`tipo_cuenta_id`) REFERENCES `conta_tipo_cuentas` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1027 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_plan_cuenta`
--

LOCK TABLES `conta_plan_cuenta` WRITE;
/*!40000 ALTER TABLE `conta_plan_cuenta` DISABLE KEYS */;
INSERT INTO `conta_plan_cuenta` VALUES (1,NULL,1000000,1,1,0,'ACTIVO','Activo',NULL,1,1,0,0,0,0,NULL),(2,NULL,1100000,2,1,1000000,'ACTIVO CORRIENTE','Activo',NULL,1,1,0,0,0,0,NULL),(3,NULL,1110000,3,1,1100000,'CAJA Y BANCOS','Activo',NULL,1,1,0,0,0,0,NULL),(4,NULL,1110100,4,1,1110000,'CAJAS','Activo',NULL,1,1,0,0,0,0,NULL),(5,NULL,1110101,5,1,1110100,'Caja Oficina','Activo',NULL,0,1,0,0,0,0,NULL),(6,NULL,1110102,5,1,1110100,'Caja Casa','Activo',NULL,0,1,0,0,0,0,NULL),(7,NULL,1110103,5,1,1110100,'Caja Dolares Casa','Activo',NULL,0,1,0,0,0,0,NULL),(8,NULL,1110104,5,1,1110100,'Banco Santander 015-372795/5','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(9,NULL,1110200,4,1,1110000,'BANCOS','Activo',NULL,1,1,0,0,0,0,NULL),(10,NULL,1110201,5,1,1110200,'Banco Santander Rio Cta Corriente','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(11,NULL,1110202,5,1,1110200,'Banco Santander Rio Cta Corriente DOLARES','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(12,NULL,1130000,3,1,1100000,'CREDITOS POR VENTAS','Activo',NULL,1,1,0,0,0,0,NULL),(13,NULL,1130101,5,1,1130100,'Clientes - Deudores','Activo',NULL,1,2,0,0,0,1,NULL),(14,NULL,1130102,5,1,1130100,'Deudores por ventas comunes','Activo',NULL,1,1,0,0,0,1,NULL),(15,NULL,1130103,5,1,1130100,'Deudores por ventas morosos','Activo',NULL,1,1,0,0,0,1,NULL),(16,NULL,1130104,5,1,1130100,'Deudores en gestión judicial','Activo',NULL,1,1,0,0,0,1,NULL),(17,NULL,1130105,5,1,1130100,'Previsión deudores incobrables','Activo',NULL,1,1,0,0,0,1,NULL),(18,NULL,1140000,3,1,1100000,'OTROS CREDITOS','Activo',NULL,1,1,0,0,0,0,NULL),(19,NULL,1140100,4,1,1140000,'Retenciones Sufridas','Activo',NULL,1,1,0,0,0,0,NULL),(20,NULL,1140301,5,1,1140300,'Anticipos Impuesto a las Ganancias','Activo',NULL,1,2,0,0,1,1,NULL),(21,NULL,1140102,5,1,1140100,'Retenciones Ingr. Brutos','Activo',NULL,0,1,0,0,0,0,NULL),(22,NULL,1140329,5,1,1140300,'Anticipo Impto.Ganancia Mínima Presunta','Activo',NULL,1,1,0,0,0,1,NULL),(23,NULL,1140105,5,1,1140100,'Retenciones Impuesto a las Ganancias','Activo',NULL,1,2,1,0,0,1,NULL),(24,NULL,1140106,5,1,1140100,'Impuesto a las Ganancias (Saldo a favor)','Activo',NULL,1,1,0,0,0,1,NULL),(25,NULL,1140107,5,1,1140100,'Retenciones de IVA','Activo',NULL,1,2,1,0,0,1,NULL),(26,NULL,1140200,4,1,1140000,'CREDITOS DIVERSOS','Activo',NULL,1,1,0,0,0,0,NULL),(27,NULL,1140201,5,1,1140200,'Anticipos de proveedores','Activo',NULL,1,1,0,0,0,1,NULL),(28,NULL,1140205,5,1,1140200,'Depósito en garantía alquileres','Activo',NULL,1,1,0,0,0,1,NULL),(29,NULL,1140206,5,1,1140200,'Derechos adquiridos a devengar','Activo',NULL,1,1,0,0,0,1,NULL),(30,NULL,1140207,5,1,1140200,'Intereses a devengar','Activo',NULL,1,1,0,0,0,1,NULL),(31,NULL,1140208,5,1,1140200,'Cuentas a rendir - Directores','Activo',NULL,1,1,0,0,0,1,NULL),(32,NULL,1140210,5,1,1140200,'Alquileres no devengados','Activo',NULL,1,1,0,0,0,1,NULL),(33,NULL,1150000,3,1,1100000,'BIENES DE CAMBIO','Activo',NULL,1,1,0,0,0,0,NULL),(34,NULL,1150400,4,1,1150000,'MERCADERIA DE REVENTA','Activo',NULL,1,1,0,0,0,0,NULL),(35,NULL,1200000,2,1,1000000,'ACTIVO NO CORRIENTE','Activo',NULL,1,1,0,0,0,0,NULL),(36,NULL,1220000,3,1,1200000,'BIENES DE USO','Activo',NULL,1,1,0,0,0,0,NULL),(37,NULL,1220100,4,1,1220000,'EQUIPOS DE COMPUTACION','Activo',NULL,1,1,0,0,0,0,NULL),(38,NULL,1220101,5,1,1220100,'Equipos de computación valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(39,NULL,1220102,5,1,1220100,'Equipos de computación ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(40,NULL,1220108,5,1,1220100,'Amortización Acumulada Equipos de comput.','Activo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(41,NULL,1220200,4,1,1220000,'INSTALACIONES','Activo',NULL,1,1,0,0,0,0,NULL),(42,NULL,1220201,5,1,1220200,'Instalaciones valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(43,NULL,1220202,5,1,1220200,'Instalaciones ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(44,NULL,1220206,5,1,1220200,'Amortización Acumulada Instalaciones','Activo',NULL,1,1,0,0,0,1,NULL),(45,NULL,1220300,4,1,1220000,'MUEBLES Y UTILES','Activo',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (46,NULL,1220301,5,1,1220300,'Muebles y utiles valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(47,NULL,1220302,5,1,1220300,'Muebles y utiles ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(48,NULL,1220306,5,1,1220300,'Amortización Acumulada Muebles y Útiles','Activo',NULL,1,1,0,0,0,1,NULL),(49,NULL,1230000,3,1,1200000,'ACTIVOS INTANGIBLES','Activo',NULL,1,1,0,0,0,0,NULL),(50,NULL,1230101,5,1,1230100,'Gastos de organización valores historicos','Activo',NULL,1,1,0,0,0,1,NULL),(51,NULL,1230102,5,1,1230100,'Gastos de organización ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(52,NULL,1230103,5,1,1230100,'Amortización acumulada gs. de organización','Activo',NULL,1,1,0,0,0,1,NULL),(53,NULL,2000000,1,2,0,'PASIVO','Pasivo',NULL,1,1,0,0,0,0,NULL),(54,NULL,2100000,2,2,2000000,'PASIVO CORRIENTE','Pasivo',NULL,1,1,0,0,0,0,NULL),(55,NULL,2110000,3,2,2100000,'Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(56,NULL,2110100,4,2,2110000,'Comerciales','Pasivo',NULL,1,1,0,0,0,0,NULL),(57,NULL,2110101,5,2,2110100,'Proveedores en Cta. Cte. locales','Pasivo',NULL,1,2,0,0,0,1,NULL),(58,NULL,2110102,5,2,2110100,'Proveedores en cta. cte. exterior','Pasivo',NULL,1,1,0,0,0,1,NULL),(59,NULL,2110103,5,2,2110100,'Derechos de exhibición a devengar','Pasivo',NULL,1,1,0,0,0,1,NULL),(60,NULL,2110104,5,2,2110100,'Cheques emitidos ','Pasivo',NULL,1,2,1,1,1,1,NULL),(61,NULL,2110200,4,2,2110000,'REMUNERACIONES Y CARGAS SOCIALES','Pasivo',NULL,1,1,0,0,0,0,NULL),(62,NULL,2110201,5,2,2110200,'Sueldos y Jornales a pagar','Pasivo',NULL,1,2,0,0,1,1,NULL),(63,NULL,2110202,5,2,2110200,'Cargas sociales a pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(64,NULL,2110203,5,2,2110200,'Sindicatos a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(65,NULL,2110300,4,2,2110000,'CARGAS FISCALES','Pasivo',NULL,1,1,0,0,0,0,NULL),(67,NULL,2110301,5,2,2110300,'IVA Debito Fiscal','Pasivo',NULL,1,2,0,0,0,1,NULL),(68,NULL,1140222,5,1,1140200,'IVA Credito Fiscal','Activo',NULL,1,2,0,0,0,1,NULL),(69,NULL,2110303,5,2,2110300,'Impuestos Internos','Pasivo',NULL,1,1,0,0,0,1,NULL),(70,NULL,2110304,5,2,2110300,'Impuestos al Combustible','Pasivo',NULL,1,1,0,0,0,1,NULL),(71,NULL,2110601,5,2,2110600,'IVA Retenciones de terceros','Pasivo',NULL,1,1,0,0,0,1,NULL),(72,NULL,2110306,5,2,2110300,'IVA Percepciones realiz.por terceros','Pasivo',NULL,1,2,0,0,0,1,NULL),(73,NULL,2110307,5,2,2110300,'IVA Saldo a favor','Pasivo',NULL,1,1,0,0,0,1,NULL),(74,NULL,2110308,5,2,2110300,'IVA a pagar','Pasivo',NULL,1,2,0,0,0,1,NULL),(75,NULL,2110309,5,2,2110300,'Percepciones Ingresos Brutos','Pasivo',NULL,1,1,0,0,0,1,NULL),(76,NULL,2110310,5,2,2110300,'Otros Pagos AFIP','Pasivo',NULL,1,1,0,0,0,1,NULL),(78,NULL,2110350,5,2,2110300,'Impuesto a los Ingresos Brutos Pasivo','Pasivo',NULL,1,1,0,0,0,1,NULL),(79,NULL,2110313,5,2,2110300,'Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(80,NULL,2110314,5,2,2110300,'Impuesto a la Ganancia Mínima Presunta','Pasivo',NULL,1,1,0,0,0,1,NULL),(81,NULL,2110602,5,2,2110600,'AFIP - Retenciones Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(82,NULL,2110316,5,2,2110300,'AFIP - Plan de Facilidades Decreto 338/02','Pasivo',NULL,1,1,0,0,0,1,NULL),(83,NULL,2200000,2,2,2000000,'PASIVO NO CORRIENTE','Pasivo',NULL,1,1,0,0,0,0,NULL),(84,NULL,3000000,1,2,0,'PATRIMONIO NETO','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(85,NULL,3100000,2,2,3000000,'APORTE DE LOS PROPIETARIOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(86,NULL,3110100,4,2,3110000,'CAPITAL SOCIAL','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(87,NULL,3110101,5,2,3110100,'Acciones en circulación','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(88,NULL,3110102,5,2,3110100,'Ajuste del Capital','Patrimonio Neto',NULL,1,2,0,0,0,1,NULL),(89,NULL,3110103,5,2,3110100,'Aportes Irrevocables Futuras Suscripciones','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(90,NULL,3400000,2,2,3000000,'RESULTADOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(91,NULL,3410101,5,2,3410100,'Resultado del ejercicio','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (92,NULL,3410102,5,2,3410100,'Resultado ejercicios anteriores','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(93,NULL,3410103,5,2,3410100,'A.R.E.A.','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(94,NULL,4000000,1,2,0,'INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(95,NULL,4100000,2,2,4000000,'INGRESOS ORDINARIOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(96,NULL,4110101,5,2,4110100,'VENTAS','Result. Positivo',NULL,1,2,0,0,0,1,NULL),(97,NULL,4110102,5,2,4110100,'Honorarios','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(98,NULL,4110103,5,2,4110100,'Sueldo Vane','Result. Positivo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(99,NULL,4110104,5,2,4110100,'Descuentos obtenidos','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(100,NULL,4110105,5,2,4110100,'Reintegros por exportaciones','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(101,NULL,4120000,3,2,4100000,'OTROS INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(102,NULL,4120101,5,2,4120100,'Intereses Cobrados','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(103,NULL,4120102,5,2,4120100,'Diferencias de cambio','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(104,NULL,4120103,5,2,4120100,'Descuentos obtenidos','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(107,NULL,5000000,1,1,0,'GASTOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(108,NULL,5100000,2,1,5000000,'GASTOS ORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(109,NULL,5110100,4,1,5110000,'ASIENTO DE SUELDO','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(110,NULL,5110101,5,1,5110100,'Sueldos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(111,NULL,5110102,5,1,5110100,'Contribuciones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(112,NULL,5110103,5,1,5110100,'Sindicato','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(113,NULL,5120100,4,1,5120000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(114,NULL,5120101,5,1,5120100,'ACA','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(115,NULL,5120102,5,1,5120100,'Aereos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(116,NULL,5120103,5,1,5120100,'Alquiler','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(117,NULL,5120104,5,1,5120100,'AGUA AYSA','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(118,NULL,5120105,5,1,5120100,'TV Cablevision','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(119,NULL,5120106,5,1,5120100,'Caja Jubilacion Consejo','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(120,NULL,5120107,5,1,5120100,'Celulares','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(121,NULL,5120108,5,1,5120100,'Cheques','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(122,NULL,5120109,5,1,5120100,'Club la Nacion','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(123,NULL,5120110,5,1,5120100,'Comida','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(124,NULL,5120111,5,1,5120100,'Diario Clarin','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(125,NULL,5120112,5,1,5120100,'Digital Ocean','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(126,NULL,5120113,5,1,5120100,'Fletes y acarreos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(127,NULL,5120114,5,1,5120100,'Luz Edesur','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(128,NULL,5120115,5,1,5120100,'Movilidad y Viáticos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(129,NULL,5120116,5,1,5120100,'Mantenimiento','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(130,NULL,5120117,5,1,5120100,'IVA No Computable','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(131,NULL,5120118,5,1,5120100,'Entretenimiento','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(132,NULL,5120119,5,1,5120100,'Amortización Bienes de Uso','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(133,NULL,5120120,5,1,5120100,'Errepar','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(134,NULL,5120121,5,1,5120100,'Hosting Página Web To Webs','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(135,NULL,5120122,5,1,5120100,'Gastos varios','Result. Negativo',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (136,NULL,5120123,5,1,5120100,'Ajuste por redondeo','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(137,NULL,5120124,5,1,5120100,'Deudores Incobrables','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(138,NULL,5120125,5,1,5120100,'Faby Goncalves','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(139,NULL,5130100,4,1,5130000,'GASTOS FINANCIEROS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(140,NULL,5130101,5,1,5130100,'Intereses y Gastos bancarios','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(141,NULL,5130102,5,1,5130100,'Intereses Proveedores','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(142,NULL,5130103,5,1,5130100,'Damian Financiera','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(143,NULL,5130104,5,1,5130100,'Diferencias de cambio','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(144,NULL,5130105,5,1,5130100,'Diferencia de Cambio Bces. en M.Extranjera','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(145,NULL,5130106,5,1,5130100,'Diferencia tipo cambio Vendedor/Comprador','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(146,NULL,5130107,5,1,5130100,'Diferencia por conversion en Bce. en Mon. Extranj.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(147,NULL,5130108,5,1,5130100,'Diferencia de cambio CMV','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(148,NULL,5130109,5,1,5130100,'Diferencia de cambio PT','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(149,NULL,5130110,5,1,5130100,'Resultado por Exposición a la Inflación','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(150,NULL,5130111,5,1,5130100,'Diferencia de cambio PE','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(151,NULL,5130112,5,1,5130100,'Diferencia de cambio Ds.Vtas.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(152,NULL,5130113,5,1,5130100,'Diferencia de cambio ME','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(153,NULL,5130114,5,1,5130100,'Descuentos otorgados','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(154,NULL,5140100,4,1,5140000,'IMPUESTOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(155,NULL,5140101,5,1,5140100,'Impuesto a las Ganancias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(156,NULL,5140164,5,1,5140100,'Impuesto a los Ingresos Brutos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(157,NULL,5140102,5,1,5140100,'Impuesto al Debito y Credito Bancario','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(158,NULL,5200000,2,1,5000000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(159,NULL,5210101,5,1,5210100,'Pérdida por venta bienes de uso','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(160,NULL,5210102,5,1,5210100,'Inversiones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(161,NULL,5210103,5,1,5210100,'Amortizaciones extraordinarias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(162,NULL,1140103,5,1,1140100,'Retenciones SUSS','Activo',NULL,1,2,1,0,0,1,NULL),(163,NULL,1110122,5,1,1110100,'Banco Patagonia Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(164,NULL,1110106,5,1,1110100,'Banco HSBC','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(165,NULL,1110123,5,1,1110100,'Banco Ciudad Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(166,NULL,1110124,5,1,1110100,'Banco Nacion Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(167,NULL,1110109,5,1,1110100,'Banco Galicia Vane','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(168,NULL,1110110,5,1,1110100,'Banco Frances Vane','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(169,NULL,1110111,5,1,1110100,'Banco Patagonia In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(170,NULL,1110112,5,1,1110100,'Banco Ciudad In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(171,NULL,1110113,5,1,1110100,'Banco Provincia In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(172,NULL,1110114,5,1,1110100,'Banco Macro PedimeOnline','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(173,NULL,1110115,5,1,1110100,'Banco Patagonia Problema Resuelto','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22');
INSERT INTO `conta_plan_cuenta` VALUES (174,NULL,1110116,5,1,1110100,'Banco Patagonia Graciela','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(175,NULL,1110117,5,1,1110100,'Banco Patagonia Omar','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(176,NULL,1110118,5,1,1110100,'Cheques','Activo',NULL,1,2,1,1,1,0,NULL),(177,NULL,5120126,5,1,5120100,'Gisela Larzabal','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(178,NULL,5120127,5,1,5120100,'Google','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(179,NULL,5120128,5,1,5120100,'Seguro Moto','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(180,NULL,5120129,5,1,5120100,'Sueldo Agustina','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(181,NULL,5120130,5,1,5120100,'Sueldo Betty','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(182,NULL,5120131,5,1,5120100,'Sueldo Elizabet','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(183,NULL,5120132,5,1,5120100,'Sueldo Florencia','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(184,NULL,5120133,5,1,5120100,'Sueldo Graciela','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(185,NULL,5120134,5,1,5120100,'Sueldo Franco Sanchez','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(186,NULL,5120135,5,1,5120100,'Sueldo Santiago Sanchez','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(187,NULL,5120136,5,1,5120100,'Sueldo Jose Luis','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(188,NULL,5120137,5,1,5120100,'Publicidad','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(189,NULL,5120138,5,1,5120100,'Las Nieves','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(190,NULL,5120139,5,1,5120100,'Sueldo Lidia','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(191,NULL,5120140,5,1,5120100,'Cargas Sociales','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(192,NULL,5120141,5,1,5120100,'Honorarios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(193,NULL,5120142,5,1,5120100,'Telefono Fijo','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(194,NULL,5120143,5,1,5120100,'ONE DRIVE','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(195,NULL,5120144,5,1,5120100,'OSDE','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(196,NULL,5120145,5,1,5120100,'SAS Constitucion','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(197,NULL,5120146,5,1,5120100,'Seguro de Vida Zurich','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(198,NULL,5120147,5,1,5120100,'Seguros','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(199,NULL,5120148,5,1,5120100,'Internet','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(200,NULL,5120149,5,1,5120100,'Seguro de Retiro Zurich','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(201,NULL,5140165,5,1,5140100,'Monotributo','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(202,NULL,5140104,5,1,5140100,'IVA In Time SRL','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(203,NULL,5140105,5,1,5140100,'Autonomos','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(204,NULL,5140106,5,1,5140100,'Multas Impositivas','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(207,NULL,5120150,5,1,5120100,'Vanesa Gastos','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(208,NULL,5140166,5,1,5140100,'Impuesto a los Ingresos Brutos - BS AS','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(209,NULL,5140107,5,1,5140100,'SIRCREB','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(210,NULL,5140108,5,1,5140100,'Consejo Ciencias Economicas','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(211,NULL,5120152,5,1,5120100,'Albano Andres','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(212,NULL,5120153,5,1,5120100,'Tarjeta Visa','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(213,NULL,5120154,5,1,5120100,'Tarjeta American Express','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(214,NULL,5120155,5,1,5120100,'Tarjeta Mastercard','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(215,NULL,5120156,5,1,5120100,'Imp. Municipales','Result. Negativo',NULL,1,2,0,0,0,1,'2020-12-31 13:34:22');
INSERT INTO `conta_plan_cuenta` VALUES (216,NULL,5120157,5,1,5120100,'Perc/Ret. Imp. Ganancias','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(217,NULL,5120158,5,1,5120100,'Compras','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(218,NULL,4110106,5,2,4110100,'Ventas No Gravadas','Result. Positivo',NULL,1,2,0,0,0,1,NULL),(219,NULL,6110103,5,1,6110100,'Pagos AFIP','Movimiento',NULL,1,2,0,0,1,1,NULL),(220,NULL,5140167,5,1,5140100,'Perc IVA -RG3337','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(221,NULL,5140109,5,1,5140100,'Imps. Internos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(222,NULL,5140110,5,1,5140100,'Imp. Gasoil','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(223,NULL,5140111,5,1,5140100,'Imp. Hídricos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(224,NULL,5140112,5,1,5140100,'ITC','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(225,NULL,5140113,5,1,5140100,'Perc IIBB  Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(226,NULL,5140114,5,1,5140100,'Perc IIBB  Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(227,NULL,5140115,5,1,5140100,'Perc IIBB  Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(228,NULL,5140116,5,1,5140100,'Perc IIBB  Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(229,NULL,5140117,5,1,5140100,'Perc IIBB  Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(230,NULL,5140118,5,1,5140100,'Perc IIBB  Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(231,NULL,5140119,5,1,5140100,'Perc IIBB  Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(232,NULL,5140120,5,1,5140100,'Perc IIBB  Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(233,NULL,5140121,5,1,5140100,'Perc IIBB  Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(234,NULL,5140122,5,1,5140100,'Perc IIBB  Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(235,NULL,5140123,5,1,5140100,'Perc IIBB  La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(236,NULL,5140124,5,1,5140100,'Perc IIBB  La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(237,NULL,5140125,5,1,5140100,'Perc IIBB  Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(238,NULL,5140126,5,1,5140100,'Perc IIBB  Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(239,NULL,5140127,5,1,5140100,'Perc IIBB  Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(240,NULL,5140128,5,1,5140100,'Perc IIBB  Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(241,NULL,5140129,5,1,5140100,'Perc IIBB  Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(242,NULL,5140130,5,1,5140100,'Perc IIBB  Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(243,NULL,5140131,5,1,5140100,'Perc IIBB  San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(244,NULL,5140132,5,1,5140100,'Perc IIBB  San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(245,NULL,5140133,5,1,5140100,'Perc IIBB  Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(246,NULL,5140134,5,1,5140100,'Perc IIBB  Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(247,NULL,5140135,5,1,5140100,'Perc IIBB  Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(248,NULL,5140136,5,1,5140100,'Perc IIBB  Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(249,NULL,5140137,5,1,5140100,'Perc IIBB  Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(250,NULL,5140138,5,1,5140100,'Compras No Gravadas','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(251,NULL,1140108,5,1,1140100,'Retenciones de IIBB Buenos Aires','Activo',NULL,1,2,1,0,0,1,NULL),(252,NULL,1140109,5,1,1140100,'Retenciones de IIBB Capital Federal','Activo',NULL,1,2,1,0,0,1,NULL),(253,NULL,1140110,5,1,1140100,'Retenciones de IIBB Catamarca','Activo',NULL,1,2,1,0,0,1,NULL),(254,NULL,1140111,5,1,1140100,'Retenciones de IIBB Chaco','Activo',NULL,1,2,1,0,0,1,NULL),(255,NULL,1140112,5,1,1140100,'Retenciones de IIBB Chubut','Activo',NULL,1,2,1,0,0,1,NULL),(256,NULL,1140113,5,1,1140100,'Retenciones de IIBB Córdoba','Activo',NULL,1,2,1,0,0,1,NULL),(257,NULL,1140114,5,1,1140100,'Retenciones de IIBB Corrientes','Activo',NULL,1,2,1,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (258,NULL,1140115,5,1,1140100,'Retenciones de IIBB Entre Ríos','Activo',NULL,1,2,1,0,0,1,NULL),(259,NULL,1140116,5,1,1140100,'Retenciones de IIBB Formosa','Activo',NULL,1,2,1,0,0,1,NULL),(260,NULL,1140117,5,1,1140100,'Retenciones de IIBB Jujuy','Activo',NULL,1,2,1,0,0,1,NULL),(261,NULL,1140118,5,1,1140100,'Retenciones de IIBB La Pampa','Activo',NULL,1,2,1,0,0,1,NULL),(262,NULL,1140119,5,1,1140100,'Retenciones de IIBB La Rioja','Activo',NULL,1,2,1,0,0,1,NULL),(263,NULL,1140120,5,1,1140100,'Retenciones de IIBB Mendoza','Activo',NULL,1,2,1,0,0,1,NULL),(264,NULL,1140121,5,1,1140100,'Retenciones de IIBB Misiones','Activo',NULL,1,2,1,0,0,1,NULL),(265,NULL,1140122,5,1,1140100,'Retenciones de IIBB Neuquén','Activo',NULL,1,2,1,0,0,1,NULL),(266,NULL,1140123,5,1,1140100,'Retenciones de IIBB Pascua Lama','Activo',NULL,1,2,1,0,0,1,NULL),(267,NULL,1140124,5,1,1140100,'Retenciones de IIBB Río Negro','Activo',NULL,1,2,1,0,0,1,NULL),(268,NULL,1140125,5,1,1140100,'Retenciones de IIBB Salta','Activo',NULL,1,2,1,0,0,1,NULL),(269,NULL,1140126,5,1,1140100,'Retenciones de IIBB San Juan','Activo',NULL,1,2,1,0,0,1,NULL),(270,NULL,1140127,5,1,1140100,'Retenciones de IIBB San Luis','Activo',NULL,1,2,1,0,0,1,NULL),(271,NULL,1140128,5,1,1140100,'Retenciones de IIBB Santa Cruz','Activo',NULL,1,2,1,0,0,1,NULL),(272,NULL,1140129,5,1,1140100,'Retenciones de IIBB Santa Fe','Activo',NULL,1,2,1,0,0,1,NULL),(273,NULL,1140130,5,1,1140100,'Retenciones de IIBB Santiago del Estero','Activo',NULL,1,2,1,0,0,1,NULL),(274,NULL,1140131,5,1,1140100,'Retenciones de IIBB Tierra del Fuego','Activo',NULL,1,2,1,0,0,1,NULL),(275,NULL,1140132,5,1,1140100,'Retenciones de IIBB Tucuman','Activo',NULL,1,2,1,0,0,1,NULL),(276,NULL,5140168,5,1,5140100,'SIRCREB Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(277,NULL,5140139,5,1,5140100,'SIRCREB Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(278,NULL,5140140,5,1,5140100,'SIRCREB Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(279,NULL,5140141,5,1,5140100,'SIRCREB Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(280,NULL,5140142,5,1,5140100,'SIRCREB Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(281,NULL,5140143,5,1,5140100,'SIRCREB Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(282,NULL,5140144,5,1,5140100,'SIRCREB Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(283,NULL,5140145,5,1,5140100,'SIRCREB Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(284,NULL,5140146,5,1,5140100,'SIRCREB Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(285,NULL,5140147,5,1,5140100,'SIRCREB Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(286,NULL,5140148,5,1,5140100,'SIRCREB La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(287,NULL,5140149,5,1,5140100,'SIRCREB La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(288,NULL,5140150,5,1,5140100,'SIRCREB Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(289,NULL,5140151,5,1,5140100,'SIRCREB Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(290,NULL,5140152,5,1,5140100,'SIRCREB Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(291,NULL,5140153,5,1,5140100,'SIRCREB Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(292,NULL,5140154,5,1,5140100,'SIRCREB Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(293,NULL,5140155,5,1,5140100,'SIRCREB Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(294,NULL,5140156,5,1,5140100,'SIRCREB San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(295,NULL,5140157,5,1,5140100,'SIRCREB San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(296,NULL,5140158,5,1,5140100,'SIRCREB Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(297,NULL,5140159,5,1,5140100,'SIRCREB Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(298,NULL,5140160,5,1,5140100,'SIRCREB Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(299,NULL,5140161,5,1,5140100,'SIRCREB Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(300,NULL,5140162,5,1,5140100,'SIRCREB Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (301,NULL,1140326,5,1,1140300,'IIBB a Favor Buenos Aires','Activo',NULL,1,2,0,0,0,1,NULL),(302,NULL,1140302,5,1,1140300,'IIBB a Favor Capital Federal','Activo',NULL,1,2,0,0,0,1,NULL),(303,NULL,1140303,5,1,1140300,'IIBB a Favor Catamarca','Activo',NULL,1,2,0,0,0,1,NULL),(304,NULL,1140304,5,1,1140300,'IIBB a Favor Chaco','Activo',NULL,1,2,0,0,0,1,NULL),(305,NULL,1140305,5,1,1140300,'IIBB a Favor Chubut','Activo',NULL,1,2,0,0,0,1,NULL),(306,NULL,1140306,5,1,1140300,'IIBB a Favor Córdoba','Activo',NULL,1,2,0,0,0,1,NULL),(307,NULL,1140307,5,1,1140300,'IIBB a Favor Corrientes','Activo',NULL,1,2,0,0,0,1,NULL),(308,NULL,1140308,5,1,1140300,'IIBB a Favor Entre Ríos','Activo',NULL,1,2,0,0,0,1,NULL),(309,NULL,1140309,5,1,1140300,'IIBB a Favor Formosa','Activo',NULL,1,2,0,0,0,1,NULL),(310,NULL,1140310,5,1,1140300,'IIBB a Favor Jujuy','Activo',NULL,1,2,0,0,0,1,NULL),(311,NULL,1140311,5,1,1140300,'IIBB a Favor La Pampa','Activo',NULL,1,2,0,0,0,1,NULL),(312,NULL,1140312,5,1,1140300,'IIBB a Favor La Rioja','Activo',NULL,1,2,0,0,0,1,NULL),(313,NULL,1140313,5,1,1140300,'IIBB a Favor Mendoza','Activo',NULL,1,2,0,0,0,1,NULL),(314,NULL,1140314,5,1,1140300,'IIBB a Favor Misiones','Activo',NULL,1,2,0,0,0,1,NULL),(315,NULL,1140315,5,1,1140300,'IIBB a Favor Neuquén','Activo',NULL,1,2,0,0,0,1,NULL),(316,NULL,1140316,5,1,1140300,'IIBB a Favor Pascua Lama','Activo',NULL,1,2,0,0,0,1,NULL),(317,NULL,1140317,5,1,1140300,'IIBB a Favor Río Negro','Activo',NULL,1,2,0,0,0,1,NULL),(318,NULL,1140318,5,1,1140300,'IIBB a Favor Salta','Activo',NULL,1,2,0,0,0,1,NULL),(319,NULL,1140319,5,1,1140300,'IIBB a Favor San Juan','Activo',NULL,1,2,0,0,0,1,NULL),(320,NULL,1140320,5,1,1140300,'IIBB a Favor San Luis','Activo',NULL,1,2,0,0,0,1,NULL),(321,NULL,1140321,5,1,1140300,'IIBB a Favor Santa Cruz','Activo',NULL,1,2,0,0,0,1,NULL),(322,NULL,1140322,5,1,1140300,'IIBB a Favor Santa Fe','Activo',NULL,1,2,0,0,0,1,NULL),(323,NULL,1140323,5,1,1140300,'IIBB a Favor Santiago del Estero','Activo',NULL,1,2,0,0,0,1,NULL),(324,NULL,1140324,5,1,1140300,'IIBB a Favor Tierra del Fuego','Activo',NULL,1,2,0,0,0,1,NULL),(325,NULL,1140325,5,1,1140300,'IIBB a Favor Tucuman','Activo',NULL,1,2,0,0,0,1,NULL),(326,NULL,2110317,5,2,2110300,'IIBB a Pagar Buenos Aires','Pasivo',NULL,1,2,0,0,0,1,NULL),(327,NULL,2110318,5,2,2110300,'IIBB a Pagar Capital Federal','Pasivo',NULL,1,2,0,0,0,1,NULL),(328,NULL,2110319,5,2,2110300,'IIBB a Pagar Catamarca','Pasivo',NULL,1,2,0,0,0,1,NULL),(329,NULL,2110320,5,2,2110300,'IIBB a Pagar Chaco','Pasivo',NULL,1,2,0,0,0,1,NULL),(330,NULL,2110321,5,2,2110300,'IIBB a Pagar Chubut','Pasivo',NULL,1,2,0,0,0,1,NULL),(331,NULL,2110322,5,2,2110300,'IIBB a Pagar Córdoba','Pasivo',NULL,1,2,0,0,0,1,NULL),(332,NULL,2110323,5,2,2110300,'IIBB a Pagar Corrientes','Pasivo',NULL,1,2,0,0,0,1,NULL),(333,NULL,2110324,5,2,2110300,'IIBB a Pagar Entre Ríos','Pasivo',NULL,1,2,0,0,0,1,NULL),(334,NULL,2110325,5,2,2110300,'IIBB a Pagar Formosa','Pasivo',NULL,1,2,0,0,0,1,NULL),(335,NULL,2110326,5,2,2110300,'IIBB a Pagar Jujuy','Pasivo',NULL,1,2,0,0,0,1,NULL),(336,NULL,2110327,5,2,2110300,'IIBB a Pagar La Pampa','Pasivo',NULL,1,2,0,0,0,1,NULL),(337,NULL,2110328,5,2,2110300,'IIBB a Pagar La Rioja','Pasivo',NULL,1,2,0,0,0,1,NULL),(338,NULL,2110329,5,2,2110300,'IIBB a Pagar Mendoza','Pasivo',NULL,1,2,0,0,0,1,NULL),(339,NULL,2110330,5,2,2110300,'IIBB a Pagar Misiones','Pasivo',NULL,1,2,0,0,0,1,NULL),(340,NULL,2110331,5,2,2110300,'IIBB a Pagar Neuquén','Pasivo',NULL,1,2,0,0,0,1,NULL),(341,NULL,2110332,5,2,2110300,'IIBB a Pagar Pascua Lama','Pasivo',NULL,1,2,0,0,0,1,NULL),(342,NULL,2110333,5,2,2110300,'IIBB a Pagar Río Negro','Pasivo',NULL,1,2,0,0,0,1,NULL),(343,NULL,2110334,5,2,2110300,'IIBB a Pagar Salta','Pasivo',NULL,1,2,0,0,0,1,NULL),(344,NULL,2110335,5,2,2110300,'IIBB a Pagar San Juan','Pasivo',NULL,1,2,0,0,0,1,NULL),(345,NULL,2110336,5,2,2110300,'IIBB a Pagar San Luis','Pasivo',NULL,1,2,0,0,0,1,NULL),(346,NULL,2110337,5,2,2110300,'IIBB a Pagar Santa Cruz','Pasivo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (347,NULL,2110338,5,2,2110300,'IIBB a Pagar Santa Fe','Pasivo',NULL,1,2,0,0,0,1,NULL),(348,NULL,2110339,5,2,2110300,'IIBB a Pagar Santiago del Estero','Pasivo',NULL,1,2,0,0,0,1,NULL),(349,NULL,2110340,5,2,2110300,'IIBB a Pagar Tierra del Fuego','Pasivo',NULL,1,2,0,0,0,1,NULL),(350,NULL,2110341,5,2,2110300,'IIBB a Pagar Tucuman','Pasivo',NULL,1,2,0,0,0,1,NULL),(351,NULL,6110101,5,1,6110100,'BANCO SIRCREB','Movimiento',NULL,1,2,0,0,1,1,NULL),(352,NULL,6110102,5,1,6110100,'Compensacion','Movimiento',NULL,1,2,0,0,0,1,'2020-12-31 13:34:22'),(353,NULL,1140327,5,1,1140300,'IVA Saldo Tecnico','Activo',NULL,1,2,0,0,0,1,NULL),(354,NULL,1140328,5,1,1140300,'IVA Saldo Libre Disponibilidad','Activo',NULL,1,2,0,0,0,1,NULL),(355,NULL,6000000,1,1,0,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(356,NULL,6100000,2,1,6000000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(357,NULL,6110000,3,1,6100000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(358,NULL,4110000,3,2,4100000,'Ingresos Operativos','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(359,NULL,1110120,5,1,1110100,'Caja en Pesos','Activo',NULL,1,2,1,1,1,0,NULL),(360,NULL,1140211,5,1,1140200,'Retenciones Bancarias de Ganancias a Favor','Activo',NULL,1,2,0,0,1,1,NULL),(361,NULL,1220104,5,1,1220100,'Equipos de Computación','Activo',NULL,1,1,0,0,0,1,NULL),(362,NULL,1220105,5,1,1220100,'Computadoras','Activo',NULL,1,1,0,0,0,1,NULL),(363,NULL,1220304,5,1,1220300,'Muebles y Utiles','Activo',NULL,1,1,0,0,0,1,NULL),(364,NULL,2110105,5,2,2110100,'Anticipo de Clientes','Pasivo',NULL,1,2,0,0,1,1,NULL),(365,NULL,2110401,5,2,2110400,'Provision Honorarios','Pasivo',NULL,1,1,0,0,0,1,NULL),(366,NULL,2110106,5,2,2110100,'Cta. Cte Directores','Pasivo',NULL,1,1,0,0,0,1,NULL),(367,NULL,2110107,5,2,2110100,'Provisión Honorarios Directores','Pasivo',NULL,1,1,0,0,0,1,NULL),(368,NULL,2110110,5,2,2110100,'Cuenta Particular Socio 1','Pasivo',NULL,1,1,0,0,0,1,NULL),(369,NULL,3110104,5,2,3110100,'Capital','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(370,NULL,1120000,3,1,1100000,'INVERSIONES','Activo',NULL,1,1,0,0,0,0,NULL),(371,NULL,1160000,3,1,1100000,'OTROS ACTIVOS','Activo',NULL,1,1,0,0,0,0,NULL),(372,NULL,1160100,4,1,1160000,'OTROS','Activo',NULL,1,1,0,0,0,0,NULL),(373,NULL,2110400,4,2,2110000,'Provision de Honorarios','Pasivo',NULL,1,1,0,0,0,0,NULL),(374,NULL,3410100,4,1,3410000,'RESULTADOS ACUMULADOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(375,NULL,3420000,3,1,3400000,'GANACIAS RESERVADAS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(376,NULL,3420100,4,1,3420000,'Rerva Legal','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(377,NULL,1220400,4,1,1220000,'INMUEBLES','Activo',NULL,1,1,0,0,0,0,NULL),(378,NULL,1220500,4,1,1220000,'RODADOS','Activo',NULL,1,1,0,0,0,0,NULL),(379,NULL,1220600,4,1,1220000,'MAQUINARIAS','Activo',NULL,1,1,0,0,0,0,NULL),(380,NULL,1220204,5,1,1220200,'Instalaciones','Activo',NULL,1,1,0,0,0,1,NULL),(381,NULL,3420101,5,2,3420100,'Reserva Legal','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(382,NULL,3420102,5,2,3420100,'Reserva Legal','Patrimonio Neto',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(383,NULL,3410105,5,2,3410100,'Resultado no asignado','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(384,NULL,1110121,5,1,1110100,'Caja en Dolares','Activo',NULL,1,2,1,1,1,0,NULL),(385,NULL,1120100,4,1,1120000,'TEMPORARIAS','Activo',NULL,1,1,0,0,0,0,NULL),(386,NULL,1120101,5,1,1120100,'PLAZO FIJO','Activo',NULL,1,1,0,0,0,1,NULL),(387,NULL,1120200,4,1,1120000,'PERMANENTES','Activo',NULL,1,1,0,0,0,0,NULL),(388,NULL,1120201,5,1,1120200,'ACCIONES','Activo',NULL,1,1,0,0,0,1,NULL),(389,NULL,1220401,5,1,1220400,'Inmuebles','Activo',NULL,1,1,0,0,0,1,NULL),(390,NULL,1220501,5,1,1220500,'Vehiculos','Activo',NULL,1,1,0,0,0,1,NULL),(391,NULL,1220601,5,1,1220600,'Maquinarias','Activo',NULL,1,1,0,0,0,1,NULL),(392,NULL,1150401,5,1,1150400,'MERCADERIAS','Activo',NULL,1,1,0,0,0,1,NULL),(393,NULL,1160101,5,1,1160100,'OTROS','Activo',NULL,1,1,0,0,0,1,NULL),(394,NULL,1230100,4,1,1230000,'INTANGIBLES','Activo',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (395,NULL,2110119,5,2,2110100,'Cuenta Particular Socio 2','Pasivo',NULL,1,1,0,0,0,1,NULL),(396,NULL,5120160,5,1,5120100,'Comisiones Y gastos Bancarios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(397,NULL,4110100,4,2,4110000,'Ingresos Operativos','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(398,NULL,4120100,4,2,4120000,'OTROS INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(399,NULL,5110000,3,1,5100000,'GASTOS ORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(400,NULL,5120000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(401,NULL,5130000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(402,NULL,5140000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(403,NULL,5210000,3,1,5200000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(404,NULL,5210100,4,1,5210000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(405,NULL,6110100,4,1,6110000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(406,NULL,1130100,4,1,1130000,'Operaciones Ordinarias','Activo',NULL,1,1,0,0,0,0,NULL),(407,NULL,3110000,3,2,3100000,'CAPITAL SOCIAL','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(408,NULL,3410000,3,2,3400000,'RESULTADOS ANTERIORES','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(409,NULL,5110101,5,2,5110000,'IVA Crédito Fiscal No computable','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(410,NULL,1110203,5,1,1110200,'Banco ICBC Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(411,NULL,2110342,5,2,2110300,'Provisión Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(412,NULL,5120107,5,2,5120000,'Amortización Muebles y Útiles','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(413,NULL,5120102,5,2,5120000,'Amortización Equipos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(414,NULL,1220109,5,1,1220100,'Amortizacion Acumulada Equipos','Activo',NULL,1,1,0,0,0,1,NULL),(415,NULL,1220602,5,1,1220600,'Amortización Acumulada Maquinarias','Activo',NULL,1,1,0,0,0,1,NULL),(416,NULL,1160102,5,1,1160100,'Materias Primas','Activo',NULL,1,1,0,0,0,1,NULL),(417,NULL,1110204,5,1,1110200,'Banco Itaú Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(418,NULL,2110113,5,2,2110100,'Deudas Bancarias','Pasivo',NULL,1,2,0,1,1,1,NULL),(419,NULL,1220502,5,1,1220500,'Rodados','Activo',NULL,1,1,0,0,0,1,NULL),(420,NULL,1220503,5,1,1220500,'Amortización Acumulada Rodados','Activo',NULL,1,1,0,0,0,1,NULL),(421,NULL,5120105,5,2,5120000,'Amortización Rodados','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(422,NULL,5120109,5,2,5120000,'Amortización Maquinarias','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(423,NULL,1220504,5,1,1220500,'Accesorios','Activo',NULL,1,1,0,0,0,1,NULL),(424,NULL,1220505,5,1,1220500,'Amortización Acumulada Accesorios','Activo',NULL,1,1,0,0,0,1,NULL),(425,NULL,1110205,5,1,1110200,'Banco Galicia Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(426,NULL,3420101,5,2,3420000,'Reserva Facultativa','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(427,NULL,1140212,5,1,1140200,'Créditos por Impuestos Diferidos','Activo',NULL,1,1,0,0,0,1,NULL),(428,NULL,1160103,5,1,1160100,'Fondo de Comercio','Activo',NULL,1,1,0,0,0,1,NULL),(429,NULL,1160104,5,1,1160100,'Amortizacion Acumulada Fondo de Comercio','Activo',NULL,1,1,0,0,0,1,NULL),(430,NULL,1140213,5,1,1140200,'Intereses a devengar AGIP','Activo',NULL,1,1,0,0,0,1,NULL),(431,NULL,2110343,5,2,2110300,'PFP IIBB','Pasivo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(432,NULL,1140330,5,1,1140300,'Pago a Cuenta ITC','Activo',NULL,1,2,0,0,0,1,NULL),(433,NULL,2110114,5,2,2110100,'Préstamo','Pasivo',NULL,1,2,0,1,1,1,NULL),(434,NULL,1160106,5,1,1160100,'Productos','Activo',NULL,1,1,0,0,0,1,NULL),(435,NULL,2110345,5,2,2110300,'Intereses a devengar PFP','Pasivo',NULL,1,1,0,0,0,1,NULL),(436,NULL,1110206,5,1,1110200,'Banco Provincia Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(437,NULL,1140215,5,1,1140200,'Imp. Ley 25413 Cred 0.6%','Activo',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (438,NULL,2110402,5,2,2110400,'Honorarios Directorio a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(439,NULL,3110101,5,2,3110100,'Reserva para Futuras Inversiones','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(440,NULL,1130106,5,1,1130100,'TEAC - Trabajos Ejecutados a Certificar','Activo',NULL,1,1,0,0,0,1,NULL),(441,NULL,2110115,5,2,2110100,'Leasing','Pasivo',NULL,1,2,0,1,1,1,NULL),(442,NULL,1110207,5,1,1110200,'Banco Comafi Cta. Cte','Activo',NULL,1,2,1,1,1,0,NULL),(443,NULL,2110500,4,2,2110000,'Deudas Financieras','Pasivo',NULL,1,1,0,0,0,0,NULL),(444,NULL,2110501,5,2,2110500,'Banco Santander Rio Cta Cte','Pasivo',NULL,1,1,0,0,0,1,NULL),(446,NULL,2210000,3,2,2200000,'Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(447,NULL,2210100,4,2,2210000,'Otras Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(448,NULL,2210101,5,2,2210100,'Planes de Pagos AFIP','Pasivo',NULL,1,2,0,1,1,1,NULL),(449,NULL,2110502,5,2,2110500,'Leasing','Pasivo',NULL,1,1,0,0,0,1,NULL),(450,NULL,6110101,5,1,6110000,'Cheques Rechazados','Movimiento',NULL,1,2,0,0,1,1,NULL),(451,NULL,1110208,5,1,1110200,'Banco Patagonia Taxes Software','Activo',NULL,1,2,1,1,1,0,NULL),(452,NULL,1110209,5,1,1110200,'Banco Macro Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(453,NULL,1120202,5,1,1120200,'Inversión Central Caribe','Activo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(454,NULL,1120102,5,1,1120100,'Otras Inversiones','Activo',NULL,1,1,0,0,0,1,NULL),(455,NULL,1140216,5,1,1140200,'Otros Créditos','Activo',NULL,1,1,0,0,0,1,NULL),(456,NULL,2110403,5,2,2110400,'Provisión Honorarios Socio Gerente','Pasivo',NULL,1,1,0,0,0,1,NULL),(457,NULL,1110210,5,1,1110200,'Cheque Diferido Banco Santander Rio','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(458,NULL,1110211,5,1,1110200,'Cheque Diferido Banco Macro','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(459,NULL,2110204,5,2,2110200,'Moratoria SUSS a pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(460,NULL,2110344,5,2,2110300,'Impuestos Municipales a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(461,NULL,5110103,5,2,5110000,'Amortización Instalaciones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(462,NULL,5120110,5,2,5120000,'Amortización Equipos de comput.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(463,NULL,2110118,5,2,2110100,'Cuenta Particular Socio 3','Pasivo',NULL,1,1,0,0,0,1,NULL),(464,NULL,2110120,5,2,2110100,'Cuenta Particular Socio 4','Pasivo',NULL,1,1,0,0,0,1,NULL),(465,NULL,3110102,5,2,3110100,'Otras Reservas','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(466,NULL,1140331,5,1,1140300,'IGMP (Saldo a Favor)','Activo',NULL,1,1,0,0,0,1,NULL),(467,NULL,5110104,5,2,5110000,'Interés','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(468,NULL,1150402,5,1,1150400,'Productos en Proceso','Activo',NULL,1,1,0,0,0,1,NULL),(469,NULL,2110205,5,2,2110200,'Depósitos en Garantía Socio Gerente','Pasivo',NULL,1,1,0,0,0,1,NULL),(470,NULL,2110346,5,2,2110300,'Fondos Embargados','Pasivo',NULL,1,1,0,0,0,1,NULL),(471,NULL,2110347,5,2,2110300,'Cuota Solid.','Pasivo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(472,NULL,1140332,5,1,1140300,'Anticipo Honorarios Directores','Activo',NULL,1,1,0,0,0,1,NULL),(473,NULL,2110348,5,2,2110300,'SICORE a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(474,NULL,1110212,5,1,1110200,'Banco Credicoop Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(475,NULL,1110213,5,1,1110200,'Banco Superville Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(476,NULL,5110105,5,2,5110000,'RECPAM','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(477,NULL,1110125,5,1,1110100,'Caja Reales','Activo',NULL,1,2,1,1,1,0,NULL),(478,NULL,5140169,5,1,5140100,'CO2 - Imp. Al Carbono','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(479,NULL,1140300,4,1,1140000,'Anticipo de Impuestos','Activo',NULL,1,1,0,0,0,0,NULL),(480,NULL,2110600,4,2,2110000,'Retenciones Efectuadas','Pasivo',NULL,1,1,0,0,0,0,NULL),(481,NULL,4200000,2,2,4000000,'INGRESOS EXTRAORDINARIOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(1001,NULL,5140170,5,1,5140100,'SIRTAC Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (1002,NULL,5140171,5,1,5140100,'SIRTAC Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1003,NULL,5140172,5,1,5140100,'SIRTAC Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1004,NULL,5140173,5,1,5140100,'SIRTAC Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1005,NULL,5140174,5,1,5140100,'SIRTAC Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1006,NULL,5140175,5,1,5140100,'SIRTAC Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1007,NULL,5140176,5,1,5140100,'SIRTAC Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1008,NULL,5140177,5,1,5140100,'SIRTAC La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1009,NULL,5140178,5,1,5140100,'SIRTAC La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1010,NULL,5140179,5,1,5140100,'SIRTAC Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1011,NULL,5140180,5,1,5140100,'SIRTAC Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1012,NULL,5140181,5,1,5140100,'SIRTAC Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1013,NULL,5140182,5,1,5140100,'SIRTAC Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1014,NULL,5140183,5,1,5140100,'SIRTAC Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1015,NULL,5140184,5,1,5140100,'SIRTAC San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1016,NULL,5140185,5,1,5140100,'SIRTAC San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1017,NULL,5140186,5,1,5140100,'SIRTAC Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1018,NULL,5140187,5,1,5140100,'SIRTAC Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1019,NULL,5140188,5,1,5140100,'SIRTAC Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1020,NULL,5140189,5,1,5140100,'SIRTAC Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1021,NULL,5140190,5,1,5140100,'SIRTAC Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1022,NULL,5140191,5,1,5140100,'SIRTAC Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1023,NULL,5140192,5,1,5140100,'SIRTAC Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1024,NULL,5140193,5,1,5140100,'SIRTAC Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1025,NULL,5140194,5,1,5140100,'SIRTAC Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1026,NULL,6110104,5,1,6110100,'BANCO SIRTAC','Movimiento',NULL,1,2,0,0,1,1,NULL);
/*!40000 ALTER TABLE `conta_plan_cuenta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_asientos`
--

DROP TABLE IF EXISTS `conta_tipo_asientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_asientos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `orden` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_asientos`
--

LOCK TABLES `conta_tipo_asientos` WRITE;
/*!40000 ALTER TABLE `conta_tipo_asientos` DISABLE KEYS */;
INSERT INTO `conta_tipo_asientos` VALUES (1,'Sueldos',NULL,NULL,NULL,11),(2,'Ingresos',NULL,NULL,NULL,9),(3,'Egresos',NULL,NULL,NULL,10),(4,'Amortizaciones',NULL,NULL,NULL,4),(5,'Banco',NULL,NULL,NULL,15),(6,'Ganancias',NULL,NULL,NULL,12),(7,'Retenciones',NULL,NULL,NULL,13),(8,'SIRCREB',NULL,NULL,NULL,14),(9,'Compensaciones',NULL,NULL,NULL,16),(10,'Pagos AFIP',NULL,NULL,NULL,17),(11,'Ajustes',NULL,NULL,NULL,3),(12,'Saldos Iniciales',NULL,NULL,NULL,1),(13,'Cancelacion de Iniciales',NULL,NULL,NULL,2),(14,'Patrimonio Neto',NULL,NULL,NULL,8),(15,'Liquidaciones IVA',NULL,NULL,NULL,18),(16,'Liquidacion IIBB',NULL,NULL,NULL,19),(17,'Asientos de Cierre',NULL,NULL,NULL,5),(18,'Reclasificacion',NULL,NULL,NULL,6),(19,'Otros',NULL,NULL,NULL,7),(20,'Cobranzas','2019-10-02 03:20:37','2019-10-02 03:20:37',NULL,NULL),(21,'Pagos','2019-10-02 03:20:37','2019-10-02 03:20:37',NULL,NULL),(22,'Tesoreria','2019-10-19 02:10:24','2019-10-19 02:10:24',NULL,NULL),(23,'Ajuste por Inflacion','2020-03-01 06:39:20','2020-03-01 06:39:20',NULL,NULL),(24,'SIRTAC','2023-10-16 21:15:20','2023-10-16 21:15:20',NULL,20);
/*!40000 ALTER TABLE `conta_tipo_asientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_cuentas`
--

DROP TABLE IF EXISTS `conta_tipo_cuentas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_cuentas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo_cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_cuentas`
--

LOCK TABLES `conta_tipo_cuentas` WRITE;
/*!40000 ALTER TABLE `conta_tipo_cuentas` DISABLE KEYS */;
INSERT INTO `conta_tipo_cuentas` VALUES (1,'Rubro',NULL,NULL,NULL),(2,'SubRubro',NULL,NULL,NULL),(3,'Grupo',NULL,NULL,NULL),(4,'SubGrupo',NULL,NULL,NULL),(5,'Cuenta',NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_cuentas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_saldos`
--

DROP TABLE IF EXISTS `conta_tipo_saldos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_saldos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `saldo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_saldos`
--

LOCK TABLES `conta_tipo_saldos` WRITE;
/*!40000 ALTER TABLE `conta_tipo_saldos` DISABLE KEYS */;
INSERT INTO `conta_tipo_saldos` VALUES (1,'Deudor',NULL,NULL,NULL),(2,'Acreedor',NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_saldos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `control_cuits_afip`
--

DROP TABLE IF EXISTS `control_cuits_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `control_cuits_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `field_name1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuit` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `error` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `control_cuits_afip_person_id_foreign` (`person_id`),
  CONSTRAINT `control_cuits_afip_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `control_cuits_afip`
--

LOCK TABLES `control_cuits_afip` WRITE;
/*!40000 ALTER TABLE `control_cuits_afip` DISABLE KEYS */;
/*!40000 ALTER TABLE `control_cuits_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `control_general`
--

DROP TABLE IF EXISTS `control_general`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `control_general` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `control_general_description_unique` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `control_general`
--

LOCK TABLES `control_general` WRITE;
/*!40000 ALTER TABLE `control_general` DISABLE KEYS */;
INSERT INTO `control_general` VALUES (1,'Ingresos - Egresos - Resultado',1,'Proyeccion Ganancias','control_general/proyecGanancias',NULL,NULL),(2,'IVA',2,'IVA','control_general/iva',NULL,NULL),(3,'IIBB',3,'IIBB','control_general/iibb',NULL,NULL),(4,'Por Mes',4,'Vto. Impuestos','control_general/vto',NULL,NULL),(5,'Por Impuesto',4,'Vto. Impuestos','control_general/vtoPorImpuestos',NULL,NULL);
/*!40000 ALTER TABLE `control_general` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente`
--

DROP TABLE IF EXISTS `cta_cte_cliente`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `compensado` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(9,2) NOT NULL DEFAULT '1.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_cliente_person_id_foreign` (`person_id`),
  KEY `cta_cte_cliente_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `cta_cte_cliente_period_id_foreign` (`period_id`),
  KEY `cta_cte_cliente_saldo_id_foreign` (`saldo_id`),
  KEY `cta_cte_cliente_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `cta_cte_cliente_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_cliente_moneda_id_foreign` (`moneda_id`),
  CONSTRAINT `cta_cte_cliente_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_cliente_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `cta_cte_cliente_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_cliente_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `cta_cte_cliente_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=688 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente`
--

LOCK TABLES `cta_cte_cliente` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente` DISABLE KEYS */;
INSERT INTO `cta_cte_cliente` VALUES (1,7847,2,40721,40722,13,4586,1,0,'2022-09-19','2022-09-19',80000.00,1,1.00,'Factura C N°: 0001-00000016',NULL,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(2,7847,2,40721,40722,13,4586,1,0,'2022-09-19','2022-09-19',40000.00,1,1.00,'Factura C N°: 0001-00000017',NULL,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(3,7847,2,40721,40723,13,4586,1,0,'2022-09-19','2022-09-19',80000.00,1,1.00,'Factura C N°: 0001-00000018',NULL,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(4,7847,2,40721,40723,13,4586,1,0,'2022-09-22','2022-09-22',5000.00,1,1.00,'Factura C N°: 0001-00000019',NULL,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(5,7847,2,40721,40724,13,4586,1,0,'2022-09-22','2022-09-22',76000.00,1,1.00,'Factura C N°: 0001-00000020',NULL,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(6,7847,2,40721,40724,13,4586,1,0,'2022-09-23','2022-09-23',78900.00,1,1.00,'Factura C N°: 0001-00000021',NULL,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(7,7847,2,40721,40725,13,4586,1,0,'2022-09-26','2022-09-26',100000.00,1,1.00,'Factura C N°: 0001-00000022',NULL,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(8,7847,2,40721,40726,13,4586,1,0,'2022-09-30','2022-09-30',100000.00,1,1.00,'Factura C N°: 0001-00000023',NULL,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(9,7847,3,40721,40727,57,4586,2,0,'2022-09-05','2022-09-05',2914.89,1,1.00,'Factura A N°: 0020-01206587',NULL,'2022-10-05 11:08:06','2022-10-05 11:08:06',NULL),(10,7847,3,40721,40727,57,4586,2,0,'2022-09-05','2022-09-05',11165.00,1,1.00,'Factura A N°: 0022-00558050',NULL,'2022-10-05 11:08:06','2022-10-05 11:08:06',NULL),(11,7847,3,40721,40727,57,4586,2,0,'2022-09-07','2022-09-07',718.62,1,1.00,'Factura A N°: 0037-00986099',NULL,'2022-10-05 11:08:06','2022-10-05 11:08:06',NULL),(12,7847,3,40721,40728,57,4586,2,0,'2022-09-21','2022-09-21',49500.00,1,1.00,'Factura C N°: 0003-00000160',NULL,'2022-10-05 11:08:06','2022-10-05 11:08:06',NULL),(13,7847,2,40721,40727,13,4585,1,0,'2022-08-05','2022-08-05',1275.92,1,1.00,'Factura A N°: 0020-00985426',NULL,'2022-10-05 11:44:50','2022-10-05 11:44:50',NULL),(14,7847,2,40721,40727,13,4585,1,0,'2022-08-13','2022-08-13',718.62,1,1.00,'Factura A N°: 0037-00786917',NULL,'2022-10-05 11:44:50','2022-10-05 11:44:50',NULL),(15,7847,2,40721,40729,13,4585,1,0,'2022-08-30','2022-08-30',2254.00,1,1.00,'Factura B N°: 0005-00007078',NULL,'2022-10-05 11:44:50','2022-10-05 11:44:50',NULL),(16,7847,2,40721,40730,13,4585,1,0,'2022-08-01','2022-08-01',80000.00,1,1.00,'Factura C N°: 0001-00000012',NULL,'2022-10-05 11:45:17','2022-10-05 11:45:17',NULL),(17,7847,2,40721,40731,13,4585,1,0,'2022-08-04','2022-08-04',90000.00,1,1.00,'Factura C N°: 0001-00000013',NULL,'2022-10-05 11:45:17','2022-10-05 11:45:17',NULL),(18,7847,2,40721,40732,13,4585,1,0,'2022-08-08','2022-08-08',60000.00,1,1.00,'Factura C N°: 0001-00000014',NULL,'2022-10-05 11:45:17','2022-10-05 11:45:17',NULL),(19,7847,2,40721,40733,13,4585,1,0,'2022-08-29','2022-08-29',100000.00,1,1.00,'Factura C N°: 0001-00000015',NULL,'2022-10-05 11:45:17','2022-10-05 11:45:17',NULL),(20,7847,3,40721,40727,57,4585,2,0,'2022-08-05','2022-08-05',1275.92,1,1.00,'Factura A N°: 0020-00985426',NULL,'2022-10-05 11:46:32','2022-10-05 11:46:32',NULL),(21,7847,3,40721,40727,57,4585,2,0,'2022-08-13','2022-08-13',718.62,1,1.00,'Factura A N°: 0037-00786917',NULL,'2022-10-05 11:46:32','2022-10-05 11:46:32',NULL),(22,7847,3,40721,40729,57,4585,2,0,'2022-08-30','2022-08-30',2254.00,1,1.00,'Factura B N°: 0005-00007078',NULL,'2022-10-05 11:46:32','2022-10-05 11:46:32',NULL),(23,7847,2,40721,40734,13,4585,1,0,'2022-07-09','2022-07-09',70000.00,1,1.00,'Factura C N°: 0001-00000011',NULL,'2022-10-05 11:49:00','2022-10-05 11:49:00',NULL),(24,7847,2,40736,40740,13,6100,1,0,'2022-10-21','2022-10-21',15613.00,1,1.00,'Factura B N°: 0005-00000082',NULL,'2022-10-30 07:14:02','2022-11-23 12:22:26','2022-11-23 12:22:26');
INSERT INTO `cta_cte_cliente` VALUES (25,7847,2,40736,40740,13,6100,1,0,'2022-10-21','2022-10-21',5600.00,1,1.00,'Factura B N°: 0005-00000083',NULL,'2022-10-30 07:14:02','2022-11-23 12:22:06','2022-11-23 12:22:06'),(26,7847,2,40736,40740,13,6100,1,0,'2022-10-21','2022-10-21',3150.00,1,1.00,'Factura B N°: 0005-00000084',NULL,'2022-10-30 07:14:02','2022-11-23 12:22:23','2022-11-23 12:22:23'),(27,7847,2,40736,40740,13,6100,1,0,'2022-10-21','2022-10-21',20081.00,1,1.00,'Factura B N°: 0005-00000085',NULL,'2022-10-30 07:14:02','2022-11-23 12:22:19','2022-11-23 12:22:19'),(28,7847,2,40736,40740,13,6100,1,0,'2022-10-21','2022-10-21',3000.00,1,1.00,'Factura B N°: 0005-00000086',NULL,'2022-10-30 07:14:02','2022-11-23 12:22:14','2022-11-23 12:22:14'),(29,7847,2,40736,40740,13,6100,1,0,'2022-10-24','2022-10-24',5700.00,1,1.00,'Factura B N°: 0005-00000087',NULL,'2022-10-30 07:14:02','2022-11-23 12:22:10','2022-11-23 12:22:10'),(30,7847,2,40736,40740,13,6100,1,0,'2022-10-24','2022-10-24',4750.00,1,1.00,'Factura B N°: 0005-00000088',NULL,'2022-10-30 07:14:02','2022-11-23 12:22:30','2022-11-23 12:22:30'),(31,7847,2,40736,40740,13,6100,1,0,'2022-10-24','2022-10-24',4000.00,1,1.00,'Factura B N°: 0005-00000089',NULL,'2022-10-30 07:14:02','2022-11-23 12:22:34','2022-11-23 12:22:34'),(32,7847,2,40736,40740,13,6100,1,0,'2022-10-24','2022-10-24',7150.00,1,1.00,'Factura B N°: 0005-00000090',NULL,'2022-10-30 07:14:02','2022-11-23 12:22:38','2022-11-23 12:22:38'),(33,7847,2,40736,40740,13,6100,1,0,'2022-10-24','2022-10-24',12011.00,1,1.00,'Factura B N°: 0005-00000091',NULL,'2022-10-30 07:14:02','2022-11-23 12:22:41','2022-11-23 12:22:41'),(34,7847,2,40736,40740,13,6100,1,0,'2022-10-20','2022-10-20',2000.00,1,1.00,'Factura B N°: 0004-00000150',NULL,'2022-10-30 07:14:14','2022-11-23 12:22:47','2022-11-23 12:22:47'),(35,7847,2,40736,40740,13,6100,1,0,'2022-10-20','2022-10-20',2600.00,1,1.00,'Factura B N°: 0004-00000151',NULL,'2022-10-30 07:14:14','2022-11-23 12:21:58','2022-11-23 12:21:58'),(36,7847,2,40736,40740,13,6100,1,0,'2022-10-20','2022-10-20',6160.00,1,1.00,'Factura B N°: 0004-00000152',NULL,'2022-10-30 07:14:14','2022-11-23 12:21:55','2022-11-23 12:21:55'),(37,7847,2,40736,40740,13,6100,1,0,'2022-10-20','2022-10-20',4670.00,1,1.00,'Factura B N°: 0004-00000153',NULL,'2022-10-30 07:14:14','2022-11-23 12:21:51','2022-11-23 12:21:51'),(38,7847,2,40736,40740,13,6100,1,0,'2022-10-20','2022-10-20',2620.00,1,1.00,'Factura B N°: 0004-00000154',NULL,'2022-10-30 07:14:14','2022-11-23 12:21:47','2022-11-23 12:21:47'),(39,7847,2,40736,40740,13,6100,1,0,'2022-10-20','2022-10-20',6080.00,1,1.00,'Factura B N°: 0004-00000155',NULL,'2022-10-30 07:14:14','2022-11-23 12:21:43','2022-11-23 12:21:43'),(40,7847,2,40736,40740,13,6100,1,0,'2022-10-20','2022-10-20',3560.00,1,1.00,'Factura B N°: 0004-00000156',NULL,'2022-10-30 07:14:14','2022-11-23 12:21:36','2022-11-23 12:21:36'),(41,7847,2,40736,40740,13,6100,1,0,'2022-10-21','2022-10-21',21000.00,1,1.00,'Factura B N°: 0004-00000157',NULL,'2022-10-30 07:14:14','2022-11-23 12:21:33','2022-11-23 12:21:33'),(42,7847,2,40736,40740,13,6100,1,0,'2022-10-21','2022-10-21',4000.00,1,1.00,'Factura B N°: 0004-00000158',NULL,'2022-10-30 07:14:14','2022-11-23 12:21:29','2022-11-23 12:21:29'),(43,7847,2,40736,40740,13,6100,1,0,'2022-10-21','2022-10-21',1790.00,1,1.00,'Factura B N°: 0004-00000159',NULL,'2022-10-30 07:14:14','2022-11-23 12:21:25','2022-11-23 12:21:25'),(44,7847,2,40736,40740,13,6100,1,0,'2022-10-21','2022-10-21',4200.00,1,1.00,'Factura B N°: 0004-00000160',NULL,'2022-10-30 07:14:14','2022-11-23 12:21:21','2022-11-23 12:21:21'),(45,7847,2,40736,40740,13,6100,1,0,'2022-10-21','2022-10-21',4241.00,1,1.00,'Factura B N°: 0004-00000161',NULL,'2022-10-30 07:14:14','2022-11-23 12:21:17','2022-11-23 12:21:17'),(46,7847,2,40736,40740,13,6100,1,0,'2022-10-21','2022-10-21',4890.00,1,1.00,'Factura B N°: 0004-00000162',NULL,'2022-10-30 07:14:14','2022-11-23 12:21:13','2022-11-23 12:21:13');
INSERT INTO `cta_cte_cliente` VALUES (47,7847,2,40736,40740,13,6100,1,0,'2022-10-21','2022-10-21',950.00,1,1.00,'Factura B N°: 0004-00000163',NULL,'2022-10-30 07:14:14','2022-11-23 12:21:09','2022-11-23 12:21:09'),(48,7847,2,40736,40740,13,6100,1,0,'2022-10-23','2022-10-23',14310.00,1,1.00,'Factura B N°: 0004-00000164',NULL,'2022-10-30 07:14:14','2022-11-23 12:21:06','2022-11-23 12:21:06'),(49,7847,2,40736,40740,13,6100,1,0,'2022-10-23','2022-10-23',900.00,1,1.00,'Factura B N°: 0004-00000165',NULL,'2022-10-30 07:14:14','2022-11-23 12:21:02','2022-11-23 12:21:02'),(50,7847,2,40736,40740,13,6100,1,0,'2022-10-23','2022-10-23',3600.00,1,1.00,'Factura B N°: 0004-00000166',NULL,'2022-10-30 07:14:14','2022-11-23 12:20:58','2022-11-23 12:20:58'),(51,7847,2,40736,40740,13,6100,1,0,'2022-10-23','2022-10-23',19010.00,1,1.00,'Factura B N°: 0004-00000167',NULL,'2022-10-30 07:14:14','2022-11-23 12:20:54','2022-11-23 12:20:54'),(52,7847,2,40736,40740,13,6100,1,0,'2022-10-23','2022-10-23',20900.00,1,1.00,'Factura B N°: 0004-00000168',NULL,'2022-10-30 07:14:14','2022-11-23 12:20:49','2022-11-23 12:20:49'),(53,7847,2,40736,40740,13,6100,1,0,'2022-10-23','2022-10-23',7000.00,1,1.00,'Factura B N°: 0004-00000169',NULL,'2022-10-30 07:14:14','2022-11-23 12:20:13','2022-11-23 12:20:13'),(54,7847,2,40736,40740,13,6100,1,0,'2022-10-23','2022-10-23',11280.00,1,1.00,'Factura B N°: 0004-00000170',NULL,'2022-10-30 07:14:14','2022-11-23 12:19:53','2022-11-23 12:19:53'),(55,7847,2,40736,40740,13,6100,1,0,'2022-10-23','2022-10-23',3750.00,1,1.00,'Factura B N°: 0004-00000171',NULL,'2022-10-30 07:14:14','2022-11-23 12:19:30','2022-11-23 12:19:30'),(56,7847,2,40736,40740,13,6100,1,0,'2022-10-23','2022-10-23',8130.00,1,1.00,'Factura B N°: 0004-00000172',NULL,'2022-10-30 07:14:14','2022-11-23 12:19:48','2022-11-23 12:19:48'),(57,7847,2,40736,40740,13,6100,1,0,'2022-10-24','2022-10-24',6365.00,1,1.00,'Factura B N°: 0004-00000173',NULL,'2022-10-30 07:14:14','2022-11-23 12:19:43','2022-11-23 12:19:43'),(58,7847,2,40721,40726,13,3030,1,0,'2022-10-05','2022-10-05',70000.00,1,1.00,'Factura C N°: 0001-00000024',NULL,'2022-11-08 12:30:54','2022-11-08 12:30:54',NULL),(59,7847,2,40721,40741,13,3030,1,0,'2022-10-15','2022-10-15',80000.00,1,1.00,'Factura C N°: 0001-00000025',NULL,'2022-11-08 12:30:54','2022-11-08 12:30:54',NULL),(60,7847,2,40721,40742,13,3030,1,0,'2022-10-21','2022-10-21',85000.00,1,1.00,'Factura C N°: 0001-00000026',NULL,'2022-11-08 12:30:54','2022-11-08 12:30:54',NULL),(61,7847,3,40721,40727,57,3030,2,0,'2022-10-05','2022-10-05',1914.00,1,1.00,'Factura A N°: 0022-00643942',NULL,'2022-11-08 12:31:34','2022-11-08 12:31:34',NULL),(62,7847,3,40721,40727,57,3030,2,0,'2022-10-05','2022-10-05',2401.34,1,1.00,'Factura A N°: 0020-01486695',NULL,'2022-11-08 12:31:34','2022-11-08 12:31:34',NULL),(63,7847,3,40721,40727,57,3030,2,0,'2022-10-07','2022-10-07',718.62,1,1.00,'Factura A N°: 0037-01239756',NULL,'2022-11-08 12:31:34','2022-11-08 12:31:34',NULL),(64,7847,3,40721,40743,57,3030,2,0,'2022-10-08','2022-10-08',2999.00,1,1.00,'Factura B N°: 0117-00009001',NULL,'2022-11-08 12:31:34','2022-11-08 12:31:34',NULL),(65,7847,3,40721,40743,57,3030,2,0,'2022-10-08','2022-10-08',39999.00,1,1.00,'Factura B N°: 0117-00009000',NULL,'2022-11-08 12:31:34','2022-11-08 12:31:34',NULL),(66,7847,3,40721,40744,57,3030,2,0,'2022-10-14','2022-10-14',43515.00,1,1.00,'Factura B N°: 0099-00009965',NULL,'2022-11-08 12:31:35','2022-11-08 12:31:35',NULL),(67,7847,2,40745,40740,13,7820,1,0,'2022-10-01','2022-10-01',518.00,1,1.00,'Factura C N°: 0002-00005767',NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(68,7847,2,40745,40740,13,7820,1,0,'2022-10-01','2022-10-01',664.00,1,1.00,'Factura C N°: 0002-00005768',NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(69,7847,2,40745,40740,13,7820,1,0,'2022-10-01','2022-10-01',1390.00,1,1.00,'Factura C N°: 0002-00005769',NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL);
INSERT INTO `cta_cte_cliente` VALUES (70,7847,2,40745,40740,13,7820,1,0,'2022-10-01','2022-10-01',710.00,1,1.00,'Factura C N°: 0002-00005770',NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(71,7847,2,40745,40740,13,7820,1,0,'2022-10-01','2022-10-01',580.00,1,1.00,'Factura C N°: 0002-00005771',NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(72,7847,2,40745,40740,13,7820,1,0,'2022-10-03','2022-10-03',745.00,1,1.00,'Factura C N°: 0002-00005772',NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(73,7847,2,40745,40740,13,7820,1,0,'2022-10-03','2022-10-03',669.00,1,1.00,'Factura C N°: 0002-00005773',NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(74,7847,2,40745,40740,13,7820,1,0,'2022-10-03','2022-10-03',382.00,1,1.00,'Factura C N°: 0002-00005774',NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(75,7847,2,40745,40740,13,7820,1,0,'2022-10-03','2022-10-03',2796.00,1,1.00,'Factura C N°: 0002-00005775',NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(76,7847,2,40745,40740,13,7820,1,0,'2022-10-03','2022-10-03',1080.00,1,1.00,'Factura C N°: 0002-00005776',NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(77,7847,2,40745,40740,13,7820,1,0,'2022-10-03','2022-10-03',960.00,1,1.00,'Factura C N°: 0002-00005777',NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(78,7847,2,40745,40740,13,7820,1,0,'2022-10-03','2022-10-03',1510.00,1,1.00,'Factura C N°: 0002-00005778',NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(79,7847,2,40745,40740,13,7820,1,0,'2022-10-04','2022-10-04',406.00,1,1.00,'Factura C N°: 0002-00005779',NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(80,7847,2,40745,40740,13,7820,1,0,'2022-10-04','2022-10-04',820.00,1,1.00,'Factura C N°: 0002-00005780',NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(81,7847,2,40745,40740,13,7820,1,0,'2022-10-04','2022-10-04',700.00,1,1.00,'Factura C N°: 0002-00005781',NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(82,7847,2,40745,40740,13,7820,1,0,'2022-10-04','2022-10-04',990.00,1,1.00,'Factura C N°: 0002-00005782',NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(83,7847,2,40745,40740,13,7820,1,0,'2022-10-04','2022-10-04',860.00,1,1.00,'Factura C N°: 0002-00005783',NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(84,7847,2,40745,40740,13,7820,1,0,'2022-10-05','2022-10-05',1400.00,1,1.00,'Factura C N°: 0002-00005784',NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(85,7847,2,40745,40740,13,7820,1,0,'2022-10-05','2022-10-05',580.00,1,1.00,'Factura C N°: 0002-00005785',NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(86,7847,2,40745,40740,13,7820,1,0,'2022-10-05','2022-10-05',3490.00,1,1.00,'Factura C N°: 0002-00005786',NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(87,7847,2,40745,40740,13,7820,1,0,'2022-10-05','2022-10-05',600.00,1,1.00,'Factura C N°: 0002-00005787',NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(88,7847,2,40745,40740,13,7820,1,0,'2022-10-06','2022-10-06',774.00,1,1.00,'Factura C N°: 0002-00005788',NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(89,7847,2,40745,40740,13,7820,1,0,'2022-10-06','2022-10-06',930.00,1,1.00,'Factura C N°: 0002-00005789',NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(90,7847,2,40745,40740,13,7820,1,0,'2022-10-06','2022-10-06',610.00,1,1.00,'Factura C N°: 0002-00005790',NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(91,7847,2,40745,40740,13,7820,1,0,'2022-10-06','2022-10-06',1380.00,1,1.00,'Factura C N°: 0002-00005791',NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(92,7847,2,40745,40740,13,7820,1,0,'2022-10-06','2022-10-06',790.00,1,1.00,'Factura C N°: 0002-00005792',NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(93,7847,2,40745,40740,13,7820,1,0,'2022-10-06','2022-10-06',1070.00,1,1.00,'Factura C N°: 0002-00005793',NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL);
INSERT INTO `cta_cte_cliente` VALUES (94,7847,2,40745,40740,13,7820,1,0,'2022-10-07','2022-10-07',370.00,1,1.00,'Factura C N°: 0002-00005794',NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(95,7847,2,40745,40740,13,7820,1,0,'2022-10-07','2022-10-07',485.00,1,1.00,'Factura C N°: 0002-00005795',NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(96,7847,2,40745,40740,13,7820,1,0,'2022-10-07','2022-10-07',920.00,1,1.00,'Factura C N°: 0002-00005796',NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(97,7847,2,40745,40740,13,7820,1,0,'2022-10-07','2022-10-07',4100.00,1,1.00,'Factura C N°: 0002-00005797',NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(98,7847,2,40745,40740,13,7820,1,0,'2022-10-07','2022-10-07',240.00,1,1.00,'Factura C N°: 0002-00005798',NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(99,7847,2,40745,40740,13,7820,1,0,'2022-10-07','2022-10-07',380.00,1,1.00,'Factura C N°: 0002-00005799',NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(100,7847,2,40745,40740,13,7820,1,0,'2022-10-08','2022-10-08',1750.00,1,1.00,'Factura C N°: 0002-00005800',NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(101,7847,2,40745,40740,13,7820,1,0,'2022-10-08','2022-10-08',459.00,1,1.00,'Factura C N°: 0002-00005801',NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(102,7847,2,40745,40740,13,7820,1,0,'2022-10-08','2022-10-08',881.00,1,1.00,'Factura C N°: 0002-00005802',NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(103,7847,2,40745,40740,13,7820,1,0,'2022-10-08','2022-10-08',650.00,1,1.00,'Factura C N°: 0002-00005803',NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(104,7847,2,40745,40740,13,7820,1,0,'2022-10-08','2022-10-08',473.00,1,1.00,'Factura C N°: 0002-00005804',NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(105,7847,2,40745,40740,13,7820,1,0,'2022-10-08','2022-10-08',1574.00,1,1.00,'Factura C N°: 0002-00005805',NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(106,7847,2,40745,40740,13,7820,1,0,'2022-10-08','2022-10-08',960.00,1,1.00,'Factura C N°: 0002-00005806',NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(107,7847,2,40745,40740,13,7820,1,0,'2022-10-08','2022-10-08',833.00,1,1.00,'Factura C N°: 0002-00005807',NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(108,7847,2,40745,40740,13,7820,1,0,'2022-10-11','2022-10-11',500.00,1,1.00,'Factura C N°: 0002-00005808',NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(109,7847,2,40745,40740,13,7820,1,0,'2022-10-11','2022-10-11',2820.00,1,1.00,'Factura C N°: 0002-00005809',NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(110,7847,2,40745,40740,13,7820,1,0,'2022-10-11','2022-10-11',650.00,1,1.00,'Factura C N°: 0002-00005810',NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(111,7847,2,40745,40740,13,7820,1,0,'2022-10-11','2022-10-11',378.00,1,1.00,'Factura C N°: 0002-00005811',NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(112,7847,2,40745,40740,13,7820,1,0,'2022-10-11','2022-10-11',1420.00,1,1.00,'Factura C N°: 0002-00005812',NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(113,7847,2,40745,40740,13,7820,1,0,'2022-10-11','2022-10-11',950.00,1,1.00,'Factura C N°: 0002-00005813',NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(114,7847,2,40745,40740,13,7820,1,0,'2022-10-11','2022-10-11',866.00,1,1.00,'Factura C N°: 0002-00005814',NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(115,7847,2,40745,40740,13,7820,1,0,'2022-10-11','2022-10-11',990.00,1,1.00,'Factura C N°: 0002-00005815',NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(116,7847,2,40745,40740,13,7820,1,0,'2022-10-12','2022-10-12',1300.00,1,1.00,'Factura C N°: 0002-00005820',NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(117,7847,2,40745,40740,13,7820,1,0,'2022-10-12','2022-10-12',960.00,1,1.00,'Factura C N°: 0002-00005821',NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL);
INSERT INTO `cta_cte_cliente` VALUES (118,7847,2,40745,40740,13,7820,1,0,'2022-10-12','2022-10-12',710.00,1,1.00,'Factura C N°: 0002-00005816',NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(119,7847,2,40745,40740,13,7820,1,0,'2022-10-12','2022-10-12',3050.00,1,1.00,'Factura C N°: 0002-00005817',NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(120,7847,2,40745,40740,13,7820,1,0,'2022-10-12','2022-10-12',260.00,1,1.00,'Factura C N°: 0002-00005818',NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(121,7847,2,40745,40740,13,7820,1,0,'2022-10-12','2022-10-12',800.00,1,1.00,'Factura C N°: 0002-00005819',NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(122,7847,2,40745,40740,13,7820,1,0,'2022-10-14','2022-10-14',500.00,1,1.00,'Factura C N°: 0002-00005822',NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(123,7847,2,40745,40740,13,7820,1,0,'2022-10-14','2022-10-14',710.00,1,1.00,'Factura C N°: 0002-00005823',NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(124,7847,2,40745,40740,13,7820,1,0,'2022-10-14','2022-10-14',980.00,1,1.00,'Factura C N°: 0002-00005824',NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(125,7847,2,40745,40740,13,7820,1,0,'2022-10-14','2022-10-14',650.00,1,1.00,'Factura C N°: 0002-00005825',NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(126,7847,2,40745,40740,13,7820,1,0,'2022-10-14','2022-10-14',1100.00,1,1.00,'Factura C N°: 0002-00005826',NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(127,7847,2,40745,40740,13,7820,1,0,'2022-10-14','2022-10-14',3810.00,1,1.00,'Factura C N°: 0002-00005827',NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(128,7847,2,40745,40740,13,7820,1,0,'2022-10-14','2022-10-14',460.00,1,1.00,'Factura C N°: 0002-00005828',NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(129,7847,2,40745,40740,13,7820,1,0,'2022-10-14','2022-10-14',770.00,1,1.00,'Factura C N°: 0002-00005829',NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(130,7847,2,40745,40740,13,7820,1,0,'2022-10-14','2022-10-14',910.00,1,1.00,'Factura C N°: 0002-00005830',NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(131,7847,2,40745,40740,13,7820,1,0,'2022-10-14','2022-10-14',5580.00,1,1.00,'Factura C N°: 0002-00005831',NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(132,7847,2,40745,40740,13,7820,1,0,'2022-10-14','2022-10-14',440.00,1,1.00,'Factura C N°: 0002-00005832',NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(133,7847,2,40745,40740,13,7820,1,0,'2022-10-15','2022-10-15',800.00,1,1.00,'Factura C N°: 0002-00005833',NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(134,7847,2,40745,40740,13,7820,1,0,'2022-10-15','2022-10-15',960.00,1,1.00,'Factura C N°: 0002-00005834',NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(135,7847,2,40745,40740,13,7820,1,0,'2022-10-15','2022-10-15',1113.00,1,1.00,'Factura C N°: 0002-00005835',NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(136,7847,2,40745,40740,13,7820,1,0,'2022-10-15','2022-10-15',2700.00,1,1.00,'Factura C N°: 0002-00005836',NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(137,7847,2,40745,40740,13,7820,1,0,'2022-10-17','2022-10-17',500.00,1,1.00,'Factura C N°: 0002-00005837',NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(138,7847,2,40745,40740,13,7820,1,0,'2022-10-17','2022-10-17',1540.00,1,1.00,'Factura C N°: 0002-00005838',NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(139,7847,2,40745,40740,13,7820,1,0,'2022-10-17','2022-10-17',893.00,1,1.00,'Factura C N°: 0002-00005839',NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(140,7847,2,40745,40740,13,7820,1,0,'2022-10-17','2022-10-17',1910.00,1,1.00,'Factura C N°: 0002-00005840',NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(141,7847,2,40745,40740,13,7820,1,0,'2022-10-18','2022-10-18',3560.00,1,1.00,'Factura C N°: 0002-00005841',NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL);
INSERT INTO `cta_cte_cliente` VALUES (142,7847,2,40745,40740,13,7820,1,0,'2022-10-18','2022-10-18',480.00,1,1.00,'Factura C N°: 0002-00005842',NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(143,7847,2,40745,40740,13,7820,1,0,'2022-10-18','2022-10-18',700.00,1,1.00,'Factura C N°: 0002-00005843',NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(144,7847,2,40745,40740,13,7820,1,0,'2022-10-18','2022-10-18',1500.00,1,1.00,'Factura C N°: 0002-00005844',NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(145,7847,2,40745,40740,13,7820,1,0,'2022-10-18','2022-10-18',690.00,1,1.00,'Factura C N°: 0002-00005845',NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(146,7847,2,40745,40740,13,7820,1,0,'2022-10-18','2022-10-18',1380.00,1,1.00,'Factura C N°: 0002-00005846',NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(147,7847,2,40745,40740,13,7820,1,0,'2022-10-19','2022-10-19',570.00,1,1.00,'Factura C N°: 0002-00005847',NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(148,7847,2,40745,40740,13,7820,1,0,'2022-10-19','2022-10-19',835.00,1,1.00,'Factura C N°: 0002-00005848',NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(149,7847,2,40745,40740,13,7820,1,0,'2022-10-19','2022-10-19',1900.00,1,1.00,'Factura C N°: 0002-00005849',NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(150,7847,2,40745,40740,13,7820,1,0,'2022-10-19','2022-10-19',2760.00,1,1.00,'Factura C N°: 0002-00005850',NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(151,7847,2,40745,40740,13,7820,1,0,'2022-10-19','2022-10-19',1800.00,1,1.00,'Factura C N°: 0002-00005851',NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(152,7847,2,40745,40740,13,7820,1,0,'2022-10-19','2022-10-19',1100.00,1,1.00,'Factura C N°: 0002-00005852',NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(153,7847,2,40745,40740,13,7820,1,0,'2022-10-20','2022-10-20',1540.00,1,1.00,'Factura C N°: 0002-00005853',NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(154,7847,2,40745,40740,13,7820,1,0,'2022-10-20','2022-10-20',810.00,1,1.00,'Factura C N°: 0002-00005854',NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(155,7847,2,40745,40740,13,7820,1,0,'2022-10-20','2022-10-20',1000.00,1,1.00,'Factura C N°: 0002-00005855',NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(156,7847,2,40745,40740,13,7820,1,0,'2022-10-20','2022-10-20',650.00,1,1.00,'Factura C N°: 0002-00005856',NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(157,7847,2,40745,40740,13,7820,1,0,'2022-10-20','2022-10-20',1736.00,1,1.00,'Factura C N°: 0002-00005857',NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(158,7847,2,40745,40740,13,7820,1,0,'2022-10-20','2022-10-20',449.00,1,1.00,'Factura C N°: 0002-00005858',NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(159,7847,2,40745,40740,13,7820,1,0,'2022-10-20','2022-10-20',1300.00,1,1.00,'Factura C N°: 0002-00005859',NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(160,7847,2,40745,40740,13,7820,1,0,'2022-10-20','2022-10-20',940.00,1,1.00,'Factura C N°: 0002-00005860',NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(161,7847,2,40745,40740,13,7820,1,0,'2022-10-21','2022-10-21',716.00,1,1.00,'Factura C N°: 0002-00005861',NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(162,7847,2,40745,40740,13,7820,1,0,'2022-10-21','2022-10-21',399.00,1,1.00,'Factura C N°: 0002-00005862',NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(163,7847,2,40745,40740,13,7820,1,0,'2022-10-21','2022-10-21',1500.00,1,1.00,'Factura C N°: 0002-00005863',NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(164,7847,2,40745,40740,13,7820,1,0,'2022-10-21','2022-10-21',700.00,1,1.00,'Factura C N°: 0002-00005864',NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(165,7847,2,40745,40740,13,7820,1,0,'2022-10-21','2022-10-21',882.00,1,1.00,'Factura C N°: 0002-00005865',NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL);
INSERT INTO `cta_cte_cliente` VALUES (166,7847,2,40745,40740,13,7820,1,0,'2022-10-21','2022-10-21',1940.00,1,1.00,'Factura C N°: 0002-00005866',NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(167,7847,2,40745,40740,13,7820,1,0,'2022-10-21','2022-10-21',2050.00,1,1.00,'Factura C N°: 0002-00005867',NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(168,7847,2,40745,40740,13,7820,1,0,'2022-10-22','2022-10-22',1100.00,1,1.00,'Factura C N°: 0002-00005868',NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(169,7847,2,40745,40740,13,7820,1,0,'2022-10-22','2022-10-22',805.00,1,1.00,'Factura C N°: 0002-00005869',NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(170,7847,2,40745,40740,13,7820,1,0,'2022-10-22','2022-10-22',3450.00,1,1.00,'Factura C N°: 0002-00005870',NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(171,7847,2,40745,40740,13,7820,1,0,'2022-10-22','2022-10-22',1000.00,1,1.00,'Factura C N°: 0002-00005871',NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(172,7847,2,40745,40740,13,7820,1,0,'2022-10-22','2022-10-22',960.00,1,1.00,'Factura C N°: 0002-00005872',NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(173,7847,2,40745,40740,13,7820,1,0,'2022-10-22','2022-10-22',520.00,1,1.00,'Factura C N°: 0002-00005873',NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(174,7847,2,40745,40740,13,7820,1,0,'2022-10-24','2022-10-24',1280.00,1,1.00,'Factura C N°: 0002-00005874',NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(175,7847,2,40745,40740,13,7820,1,0,'2022-10-24','2022-10-24',775.00,1,1.00,'Factura C N°: 0002-00005875',NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(176,7847,2,40745,40740,13,7820,1,0,'2022-10-24','2022-10-24',932.00,1,1.00,'Factura C N°: 0002-00005876',NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(177,7847,2,40745,40740,13,7820,1,0,'2022-10-24','2022-10-24',2100.00,1,1.00,'Factura C N°: 0002-00005877',NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(178,7847,2,40745,40740,13,7820,1,0,'2022-10-24','2022-10-24',500.00,1,1.00,'Factura C N°: 0002-00005878',NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(179,7847,2,40745,40740,13,7820,1,0,'2022-10-25','2022-10-25',970.00,1,1.00,'Factura C N°: 0002-00005879',NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(180,7847,2,40745,40740,13,7820,1,0,'2022-10-25','2022-10-25',600.00,1,1.00,'Factura C N°: 0002-00005880',NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(181,7847,2,40745,40740,13,7820,1,0,'2022-10-25','2022-10-25',2280.00,1,1.00,'Factura C N°: 0002-00005881',NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(182,7847,2,40745,40740,13,7820,1,0,'2022-10-25','2022-10-25',1600.00,1,1.00,'Factura C N°: 0002-00005882',NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(183,7847,2,40745,40740,13,7820,1,0,'2022-10-25','2022-10-25',1450.00,1,1.00,'Factura C N°: 0002-00005883',NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(184,7847,2,40745,40740,13,7820,1,0,'2022-10-25','2022-10-25',810.00,1,1.00,'Factura C N°: 0002-00005884',NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(185,7847,2,40745,40740,13,7820,1,0,'2022-10-25','2022-10-25',740.00,1,1.00,'Factura C N°: 0002-00005885',NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(186,7847,2,40745,40740,13,7820,1,0,'2022-10-26','2022-10-26',995.00,1,1.00,'Factura C N°: 0002-00005886',NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(187,7847,2,40745,40740,13,7820,1,0,'2022-10-26','2022-10-26',730.00,1,1.00,'Factura C N°: 0002-00005887',NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(188,7847,2,40745,40740,13,7820,1,0,'2022-10-26','2022-10-26',1800.00,1,1.00,'Factura C N°: 0002-00005888',NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(189,7847,2,40745,40740,13,7820,1,0,'2022-10-26','2022-10-26',4910.00,1,1.00,'Factura C N°: 0002-00005889',NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL);
INSERT INTO `cta_cte_cliente` VALUES (190,7847,2,40745,40740,13,7820,1,0,'2022-10-27','2022-10-27',875.00,1,1.00,'Factura C N°: 0002-00005890',NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(191,7847,2,40745,40740,13,7820,1,0,'2022-10-27','2022-10-27',3000.00,1,1.00,'Factura C N°: 0002-00005891',NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(192,7847,2,40745,40740,13,7820,1,0,'2022-10-27','2022-10-27',450.00,1,1.00,'Factura C N°: 0002-00005892',NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(193,7847,2,40745,40740,13,7820,1,0,'2022-10-27','2022-10-27',910.00,1,1.00,'Factura C N°: 0002-00005893',NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(194,7847,2,40745,40740,13,7820,1,0,'2022-10-27','2022-10-27',1700.00,1,1.00,'Factura C N°: 0002-00005894',NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(195,7847,2,40745,40740,13,7820,1,0,'2022-10-27','2022-10-27',620.00,1,1.00,'Factura C N°: 0002-00005895',NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(196,7847,2,40745,40740,13,7820,1,0,'2022-10-27','2022-10-27',370.00,1,1.00,'Factura C N°: 0002-00005896',NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(197,7847,2,40745,40740,13,7820,1,0,'2022-10-28','2022-10-28',900.00,1,1.00,'Factura C N°: 0002-00005897',NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(198,7847,2,40745,40740,13,7820,1,0,'2022-10-28','2022-10-28',300.00,1,1.00,'Factura C N°: 0002-00005898',NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(199,7847,2,40745,40740,13,7820,1,0,'2022-10-28','2022-10-28',1720.00,1,1.00,'Factura C N°: 0002-00005899',NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(200,7847,2,40745,40740,13,7820,1,0,'2022-10-28','2022-10-28',900.00,1,1.00,'Factura C N°: 0002-00005900',NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(201,7847,2,40745,40740,13,7820,1,0,'2022-10-28','2022-10-28',2500.00,1,1.00,'Factura C N°: 0002-00005901',NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(202,7847,2,40745,40740,13,7820,1,0,'2022-10-28','2022-10-28',1830.00,1,1.00,'Factura C N°: 0002-00005902',NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(203,7847,2,40745,40740,13,7820,1,0,'2022-10-29','2022-10-29',1000.00,1,1.00,'Factura C N°: 0002-00005903',NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(204,7847,2,40745,40740,13,7820,1,0,'2022-10-29','2022-10-29',870.00,1,1.00,'Factura C N°: 0002-00005904',NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(205,7847,2,40745,40740,13,7820,1,0,'2022-10-29','2022-10-29',1415.00,1,1.00,'Factura C N°: 0002-00005905',NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(206,7847,2,40745,40740,13,7820,1,0,'2022-10-29','2022-10-29',2890.00,1,1.00,'Factura C N°: 0002-00005906',NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(207,7847,2,40745,40740,13,7820,1,0,'2022-10-29','2022-10-29',8300.00,1,1.00,'Factura C N°: 0002-00005907',NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(208,7847,2,40745,40740,13,7820,1,0,'2022-10-29','2022-10-29',775.00,1,1.00,'Factura C N°: 0002-00005908',NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(209,7847,2,40745,40740,13,7820,1,0,'2022-10-31','2022-10-31',1435.00,1,1.00,'Factura C N°: 0002-00005909',NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(210,7847,2,40745,40740,13,7820,1,0,'2022-10-31','2022-10-31',960.00,1,1.00,'Factura C N°: 0002-00005910',NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(211,7847,2,40745,40740,13,7820,1,0,'2022-10-31','2022-10-31',880.00,1,1.00,'Factura C N°: 0002-00005911',NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(212,7847,2,40745,40740,13,7820,1,0,'2022-10-31','2022-10-31',3460.00,1,1.00,'Factura C N°: 0002-00005912',NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(213,7847,2,40745,40740,13,7820,1,0,'2022-10-31','2022-10-31',1800.00,1,1.00,'Factura C N°: 0002-00005913',NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL);
INSERT INTO `cta_cte_cliente` VALUES (214,7847,3,40745,40746,57,7820,2,0,'2022-10-01','2022-10-01',5899.00,1,1.00,'Factura B N°: 0013-17562424',NULL,'2022-11-08 15:00:13','2022-11-08 15:00:13',NULL),(215,7847,3,40745,40746,57,7820,2,0,'2022-10-01','2022-10-01',2482.00,1,1.00,'Factura B N°: 0013-17619374',NULL,'2022-11-08 15:00:13','2022-11-08 15:00:13',NULL),(216,7847,3,40745,40747,57,7820,2,0,'2022-10-04','2022-10-04',19571.43,1,1.00,'Factura A N°: 0033-00007746',NULL,'2022-11-08 15:00:14','2022-11-08 15:00:14',NULL),(217,7847,3,40745,40748,57,7820,2,0,'2022-10-14','2022-10-14',11635.24,1,1.00,'Factura A N°: 0010-00010394',NULL,'2022-11-08 15:00:14','2022-11-08 15:00:14',NULL),(218,7847,3,40745,40749,57,7820,2,0,'2022-10-21','2022-10-21',45123.22,1,1.00,'Factura B N°: 2123-01076977',NULL,'2022-11-08 15:00:14','2022-11-08 15:00:14',NULL),(219,7847,3,40745,40747,57,7820,2,0,'2022-10-25','2022-10-25',14903.34,1,1.00,'Factura A N°: 0033-00008331',NULL,'2022-11-08 15:00:14','2022-11-08 15:00:14',NULL),(220,7847,3,40745,40750,57,7820,2,0,'2022-10-26','2022-10-26',26781.53,1,1.00,'Factura B N°: 0003-00198986',NULL,'2022-11-08 15:00:14','2022-11-08 15:00:14',NULL),(221,7847,2,40719,40736,13,13,1,0,'2022-11-15','2022-11-15',24000.00,1,1.00,'Factura C N°: 0003-00000001',NULL,'2022-11-15 10:57:14','2022-11-15 10:57:14',NULL),(222,7847,2,40719,40735,13,13,1,0,'2022-11-15','2022-11-15',12000.00,1,1.00,'Factura C N°: 0003-00000002',NULL,'2022-11-15 11:06:09','2022-11-15 11:06:09',NULL),(223,7847,2,40751,40753,13,35105,1,0,'2022-10-13','2022-10-13',4800.00,1,1.00,'Factura C N°: 0003-00000121',NULL,'2022-11-16 15:00:13','2022-11-16 15:00:13',NULL),(224,7847,2,40751,40740,13,35105,1,0,'2022-10-14','2022-10-14',5600.00,1,1.00,'Factura C N°: 0003-00000122',NULL,'2022-11-16 15:00:13','2022-11-16 15:00:13',NULL),(225,7847,2,40751,40740,13,35105,1,0,'2022-10-14','2022-10-14',5000.00,1,1.00,'Factura C N°: 0003-00000123',NULL,'2022-11-16 15:00:13','2022-11-16 15:00:13',NULL),(226,7847,2,40751,40740,13,35105,1,0,'2022-10-14','2022-10-14',5500.00,1,1.00,'Factura C N°: 0003-00000124',NULL,'2022-11-16 15:00:13','2022-11-16 15:00:13',NULL),(227,7847,2,40751,40740,13,35105,1,0,'2022-10-15','2022-10-15',5500.00,1,1.00,'Factura C N°: 0003-00000125',NULL,'2022-11-16 15:00:13','2022-11-16 15:00:13',NULL),(228,7847,2,40751,40740,13,35105,1,0,'2022-10-15','2022-10-15',13000.00,1,1.00,'Factura C N°: 0003-00000126',NULL,'2022-11-16 15:00:13','2022-11-16 15:00:13',NULL),(229,7847,2,40751,40740,13,35105,1,0,'2022-10-15','2022-10-15',6500.00,1,1.00,'Factura C N°: 0003-00000127',NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(230,7847,2,40751,40740,13,35105,1,0,'2022-10-17','2022-10-17',4000.00,1,1.00,'Factura C N°: 0003-00000128',NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(231,7847,2,40751,40740,13,35105,1,0,'2022-10-17','2022-10-17',6450.00,1,1.00,'Factura C N°: 0003-00000129',NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(232,7847,2,40751,40740,13,35105,1,0,'2022-10-17','2022-10-17',13000.00,1,1.00,'Factura C N°: 0003-00000130',NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(233,7847,2,40751,40740,13,35105,1,0,'2022-10-17','2022-10-17',2500.00,1,1.00,'Factura C N°: 0003-00000131',NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(234,7847,2,40751,40740,13,35105,1,0,'2022-10-18','2022-10-18',3080.00,1,1.00,'Factura C N°: 0003-00000132',NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(235,7847,2,40751,40740,13,35105,1,0,'2022-10-18','2022-10-18',13000.00,1,1.00,'Factura C N°: 0003-00000133',NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(236,7847,2,40751,40740,13,35105,1,0,'2022-10-18','2022-10-18',6800.00,1,1.00,'Factura C N°: 0003-00000134',NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(237,7847,2,40751,40740,13,35105,1,0,'2022-10-19','2022-10-19',13000.00,1,1.00,'Factura C N°: 0003-00000135',NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL);
INSERT INTO `cta_cte_cliente` VALUES (238,7847,2,40751,40740,13,35105,1,0,'2022-10-19','2022-10-19',4500.00,1,1.00,'Factura C N°: 0003-00000136',NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(239,7847,2,40751,40740,13,35105,1,0,'2022-10-19','2022-10-19',7800.00,1,1.00,'Factura C N°: 0003-00000137',NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(240,7847,2,40751,40740,13,35105,1,0,'2022-10-19','2022-10-19',13000.00,1,1.00,'Factura C N°: 0003-00000138',NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(241,7847,2,40751,40740,13,35105,1,0,'2022-10-19','2022-10-19',11400.00,1,1.00,'Factura C N°: 0003-00000139',NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(242,7847,2,40751,40740,13,35105,1,0,'2022-10-19','2022-10-19',4180.00,1,1.00,'Factura C N°: 0003-00000140',NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(243,7847,2,40751,40754,13,35105,1,0,'2022-10-20','2022-10-20',4800.00,1,1.00,'Factura C N°: 0003-00000141',NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(244,7847,3,40751,40727,57,35105,2,0,'2022-10-12','2022-10-12',1378.37,1,1.00,'Factura A N°: 0024-00679054',NULL,'2022-11-22 17:13:45','2022-11-22 17:13:45',NULL),(245,7847,3,40751,40759,57,35105,2,0,'2022-10-28','2022-10-28',11500.00,1,1.00,'Factura C N°: 0003-00000551',NULL,'2022-11-22 17:13:45','2022-11-22 17:13:45',NULL),(246,7847,3,40751,40760,57,35105,2,0,'2022-10-31','2022-10-31',8000.00,1,1.00,'Factura B N°: 0004-00025670',NULL,'2022-11-22 17:13:45','2022-11-22 17:13:45',NULL),(247,7847,3,40736,40761,57,6100,2,0,'2022-10-04','2022-10-04',288354.38,1,1.00,'Factura B N°: 0001-00001016',NULL,'2022-11-23 10:13:03','2022-11-23 10:13:03',NULL),(248,7847,3,40736,40762,57,6100,2,0,'2022-10-04','2022-10-04',98375.35,1,1.00,'Factura A N°: 0003-00000408',NULL,'2022-11-23 10:13:03','2022-11-23 10:13:03',NULL),(249,7847,3,40736,40763,57,6100,2,0,'2022-10-04','2022-10-04',7855.40,1,1.00,'Factura A N°: 0063-02115147',NULL,'2022-11-23 10:13:03','2022-11-23 10:13:03',NULL),(250,7847,3,40736,40764,57,6100,2,0,'2022-10-04','2022-10-04',7234.23,1,1.00,'Factura B N°: 0001-00234263',NULL,'2022-11-23 10:13:03','2022-11-23 10:13:03',NULL),(251,7847,3,40736,40765,57,6100,2,0,'2022-10-05','2022-10-05',18491.22,1,1.00,'Factura A N°: 0091-00058606',NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(252,7847,3,40736,40766,57,6100,2,0,'2022-10-05','2022-10-05',4400.00,1,1.00,'Factura A N°: 0001-00000029',NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(253,7847,3,40736,40767,57,6100,2,0,'2022-10-05','2022-10-05',735.00,1,1.00,'Factura A N°: 0004-00020112',NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(254,7847,3,40736,40767,57,6100,2,0,'2022-10-05','2022-10-05',1102.50,1,1.00,'Factura A N°: 0004-00020104',NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(255,7847,3,40736,40767,57,6100,2,0,'2022-10-06','2022-10-06',1459.50,1,1.00,'Factura A N°: 0004-00020132',NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(256,7847,3,40736,40762,57,6100,2,0,'2022-10-07','2022-10-07',106297.24,1,1.00,'Factura A N°: 0003-00000412',NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(257,7847,3,40736,40766,57,6100,2,0,'2022-10-08','2022-10-08',2200.00,1,1.00,'Factura A N°: 0001-00000030',NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(258,7847,3,40736,40766,57,6100,2,0,'2022-10-11','2022-10-11',2200.00,1,1.00,'Factura A N°: 0001-00000031',NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(259,7847,3,40736,40766,57,6100,2,0,'2022-10-12','2022-10-12',6000.00,1,1.00,'Factura A N°: 0001-00000032',NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(260,7847,3,40736,40768,57,6100,2,0,'2022-10-12','2022-10-12',71954.59,1,1.00,'Factura A N°: 0004-00032708',NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(261,7847,3,40736,40767,57,6100,2,0,'2022-10-13','2022-10-13',735.00,1,1.00,'Factura A N°: 0004-00020339',NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL);
INSERT INTO `cta_cte_cliente` VALUES (262,7847,3,40736,40767,57,6100,2,0,'2022-10-13','2022-10-13',1155.01,1,1.00,'Factura A N°: 0004-00020320',NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(263,7847,3,40736,40767,57,6100,2,0,'2022-10-13','2022-10-13',1459.50,1,1.00,'Factura A N°: 0004-00020323',NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(264,7847,3,40736,40767,57,6100,2,0,'2022-10-13','2022-10-13',609.01,1,1.00,'Factura A N°: 0004-00020324',NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(265,7847,3,40736,40766,57,6100,2,0,'2022-10-14','2022-10-14',4500.00,1,1.00,'Factura A N°: 0001-00000033',NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(266,7847,3,40736,40762,57,6100,2,0,'2022-10-14','2022-10-14',28923.84,1,1.00,'Factura A N°: 0003-00000421',NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(267,7847,3,40736,40769,57,6100,2,0,'2022-10-14','2022-10-14',24494.03,1,1.00,'Factura A N°: 0052-00023871',NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(268,7847,3,40736,40767,57,6100,2,0,'2022-10-14','2022-10-14',1155.01,1,1.00,'Factura A N°: 0004-00020430',NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(269,7847,3,40736,40765,57,6100,2,0,'2022-10-15','2022-10-15',91857.15,1,1.00,'Factura A N°: 0091-00059017',NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(270,7847,3,40736,40765,57,6100,2,0,'2022-10-15','2022-10-15',553037.76,1,1.00,'Factura A N°: 0091-00059016',NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(271,7847,3,40736,40766,57,6100,2,0,'2022-10-15','2022-10-15',3000.00,1,1.00,'Factura A N°: 0001-00000034',NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(272,7847,3,40736,40765,57,6100,1,0,'2022-10-17','2022-10-17',91857.15,1,1.00,'Nota de crédito A N°: 0091-00006888',NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(273,7847,3,40736,40766,57,6100,2,0,'2022-10-17','2022-10-17',4500.00,1,1.00,'Factura A N°: 0001-00000035',NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(274,7847,3,40736,40770,57,6100,2,0,'2022-10-18','2022-10-18',71240.93,1,1.00,'Factura A N°: 0002-00001151',NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(275,7847,3,40736,40766,57,6100,2,0,'2022-10-18','2022-10-18',4500.00,1,1.00,'Factura A N°: 0001-00000036',NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(276,7847,3,40736,40766,57,6100,2,0,'2022-10-19','2022-10-19',4500.00,1,1.00,'Factura A N°: 0001-00000038',NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(277,7847,3,40736,40771,57,6100,2,0,'2022-10-19','2022-10-19',5000.00,1,1.00,'Factura B N°: 0001-00000616',NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(278,7847,3,40736,40769,57,6100,2,0,'2022-10-19','2022-10-19',5156.48,1,1.00,'Factura A N°: 0052-00023894',NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(279,7847,3,40736,40767,57,6100,2,0,'2022-10-19','2022-10-19',735.00,1,1.00,'Factura A N°: 0004-00020548',NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(280,7847,3,40736,40767,57,6100,2,0,'2022-10-19','2022-10-19',735.00,1,1.00,'Factura A N°: 0004-00020554',NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(281,7847,3,40736,40761,57,6100,2,0,'2022-10-20','2022-10-20',184841.27,1,1.00,'Factura B N°: 0001-00001052',NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(282,7847,3,40736,40767,57,6100,2,0,'2022-10-20','2022-10-20',1459.50,1,1.00,'Factura A N°: 0004-00020585',NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(283,7847,3,40736,40767,57,6100,2,0,'2022-10-20','2022-10-20',1102.50,1,1.00,'Factura A N°: 0004-00020586',NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(284,7847,3,40736,40766,57,6100,2,0,'2022-10-21','2022-10-21',4500.00,1,1.00,'Factura A N°: 0001-00000039',NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(285,7847,3,40736,40766,57,6100,2,0,'2022-10-21','2022-10-21',7500.00,1,1.00,'Factura A N°: 0001-00000040',NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL);
INSERT INTO `cta_cte_cliente` VALUES (286,7847,3,40736,40766,57,6100,2,0,'2022-10-24','2022-10-24',6000.00,1,1.00,'Factura A N°: 0001-00000041',NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(287,7847,3,40736,40719,57,6100,2,0,'2022-10-25','2022-10-25',24000.00,1,1.00,'Factura C N°: 0002-00000039',NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(288,7847,3,40736,40766,57,6100,2,0,'2022-10-26','2022-10-26',6000.00,1,1.00,'Factura A N°: 0001-00000042',NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(289,7847,3,40736,40768,57,6100,2,0,'2022-10-26','2022-10-26',109752.80,1,1.00,'Factura A N°: 0004-00032968',NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(290,7847,3,40736,40772,57,6100,2,0,'2022-10-26','2022-10-26',106498.00,1,1.00,'Factura A N°: 0002-00004835',NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(291,7847,3,40736,40767,57,6100,2,0,'2022-10-26','2022-10-26',735.00,1,1.00,'Factura A N°: 0004-00020825',NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(292,7847,3,40736,40767,57,6100,2,0,'2022-10-26','2022-10-26',735.00,1,1.00,'Factura A N°: 0004-00020830',NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(293,7847,3,40736,40767,57,6100,2,0,'2022-10-26','2022-10-26',1155.01,1,1.00,'Factura A N°: 0004-00020833',NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(294,7847,3,40736,40773,57,6100,2,0,'2022-10-26','2022-10-26',47273.05,1,1.00,'Factura B N°: 0151-03225551',NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(295,7847,3,40736,40749,57,6100,2,0,'2022-10-27','2022-10-27',11023.59,1,1.00,'Factura B N°: 2131-04554960',NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(296,7847,3,40736,40766,57,6100,2,0,'2022-10-27','2022-10-27',6000.00,1,1.00,'Factura A N°: 0001-00000043',NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(297,7847,3,40736,40767,57,6100,2,0,'2022-10-27','2022-10-27',1459.50,1,1.00,'Factura A N°: 0004-00020854',NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(298,7847,3,40736,40769,57,6100,2,0,'2022-10-27','2022-10-27',17895.79,1,1.00,'Factura A N°: 0052-00023951',NULL,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(299,7847,3,40736,40774,57,6100,2,0,'2022-10-28','2022-10-28',41200.00,1,1.00,'Factura C N°: 0005-00000454',NULL,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(300,7847,3,40736,40762,57,6100,2,0,'2022-10-28','2022-10-28',202254.96,1,1.00,'Factura A N°: 0003-00000436',NULL,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(301,7847,3,40736,40775,57,6100,2,0,'2022-10-29','2022-10-29',267631.68,1,1.00,'Factura A N°: 0884-00060989',NULL,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(302,7847,3,40736,40765,57,6100,2,0,'2022-10-31','2022-10-31',41091.60,1,1.00,'Factura A N°: 0091-00059891',NULL,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(303,7847,3,40736,40765,57,6100,2,0,'2022-10-31','2022-10-31',553037.76,1,1.00,'Factura A N°: 0091-00059890',NULL,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(304,7847,3,40736,40776,57,6100,2,0,'2022-10-31','2022-10-31',0.00,1,1.00,'Factura B N°: 0006-09998102',NULL,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(305,7847,2,40736,40740,13,6100,1,0,'2022-10-25','2022-10-25',5100.00,1,1.00,'Factura B N°: 0004-00000174',NULL,'2022-11-23 11:38:02','2022-11-23 12:19:39','2022-11-23 12:19:39'),(306,7847,2,40736,40740,13,6100,1,0,'2022-10-25','2022-10-25',6110.00,1,1.00,'Factura B N°: 0004-00000175',NULL,'2022-11-23 11:38:02','2022-11-23 12:19:34','2022-11-23 12:19:34'),(307,7847,2,40736,40740,13,6100,1,0,'2022-10-25','2022-10-25',6980.00,1,1.00,'Factura B N°: 0004-00000176',NULL,'2022-11-23 11:38:02','2022-11-23 12:19:19','2022-11-23 12:19:19'),(308,7847,2,40736,40735,13,6100,1,0,'2022-10-31','2022-10-31',66550.00,1,1.00,'Factura A N°: 0004-00000001',NULL,'2022-11-23 11:38:02','2022-11-23 12:19:15','2022-11-23 12:19:15'),(309,7847,2,40736,40740,13,6100,1,0,'2022-10-20','2022-10-20',2000.00,1,1.00,'Factura B N°: 0004-00000150',NULL,'2022-11-23 12:24:11','2022-11-23 12:24:11',NULL);
INSERT INTO `cta_cte_cliente` VALUES (310,7847,2,40736,40740,13,6100,1,0,'2022-10-20','2022-10-20',2600.00,1,1.00,'Factura B N°: 0004-00000151',NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(311,7847,2,40736,40740,13,6100,1,0,'2022-10-20','2022-10-20',6160.00,1,1.00,'Factura B N°: 0004-00000152',NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(312,7847,2,40736,40740,13,6100,1,0,'2022-10-20','2022-10-20',4670.00,1,1.00,'Factura B N°: 0004-00000153',NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(313,7847,2,40736,40740,13,6100,1,0,'2022-10-20','2022-10-20',2620.00,1,1.00,'Factura B N°: 0004-00000154',NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(314,7847,2,40736,40740,13,6100,1,0,'2022-10-20','2022-10-20',6080.00,1,1.00,'Factura B N°: 0004-00000155',NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(315,7847,2,40736,40740,13,6100,1,0,'2022-10-20','2022-10-20',3560.00,1,1.00,'Factura B N°: 0004-00000156',NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(316,7847,2,40736,40740,13,6100,1,0,'2022-10-21','2022-10-21',21000.00,1,1.00,'Factura B N°: 0004-00000157',NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(317,7847,2,40736,40740,13,6100,1,0,'2022-10-21','2022-10-21',4000.00,1,1.00,'Factura B N°: 0004-00000158',NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(318,7847,2,40736,40740,13,6100,1,0,'2022-10-21','2022-10-21',1790.00,1,1.00,'Factura B N°: 0004-00000159',NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(319,7847,2,40736,40740,13,6100,1,0,'2022-10-21','2022-10-21',4200.00,1,1.00,'Factura B N°: 0004-00000160',NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(320,7847,2,40736,40740,13,6100,1,0,'2022-10-21','2022-10-21',4241.00,1,1.00,'Factura B N°: 0004-00000161',NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(321,7847,2,40736,40740,13,6100,1,0,'2022-10-21','2022-10-21',4890.00,1,1.00,'Factura B N°: 0004-00000162',NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(322,7847,2,40736,40740,13,6100,1,0,'2022-10-21','2022-10-21',950.00,1,1.00,'Factura B N°: 0004-00000163',NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(323,7847,2,40736,40740,13,6100,1,0,'2022-10-23','2022-10-23',14310.00,1,1.00,'Factura B N°: 0004-00000164',NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(324,7847,2,40736,40740,13,6100,1,0,'2022-10-23','2022-10-23',900.00,1,1.00,'Factura B N°: 0004-00000165',NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(325,7847,2,40736,40740,13,6100,1,0,'2022-10-23','2022-10-23',3600.00,1,1.00,'Factura B N°: 0004-00000166',NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(326,7847,2,40736,40740,13,6100,1,0,'2022-10-23','2022-10-23',19010.00,1,1.00,'Factura B N°: 0004-00000167',NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(327,7847,2,40736,40740,13,6100,1,0,'2022-10-23','2022-10-23',20900.00,1,1.00,'Factura B N°: 0004-00000168',NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(328,7847,2,40736,40740,13,6100,1,0,'2022-10-23','2022-10-23',7000.00,1,1.00,'Factura B N°: 0004-00000169',NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(329,7847,2,40736,40740,13,6100,1,0,'2022-10-23','2022-10-23',11280.00,1,1.00,'Factura B N°: 0004-00000170',NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(330,7847,2,40736,40740,13,6100,1,0,'2022-10-23','2022-10-23',3750.00,1,1.00,'Factura B N°: 0004-00000171',NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(331,7847,2,40736,40740,13,6100,1,0,'2022-10-23','2022-10-23',8130.00,1,1.00,'Factura B N°: 0004-00000172',NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(332,7847,2,40736,40740,13,6100,1,0,'2022-10-24','2022-10-24',6365.00,1,1.00,'Factura B N°: 0004-00000173',NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(333,7847,2,40736,40740,13,6100,1,0,'2022-10-25','2022-10-25',5100.00,1,1.00,'Factura B N°: 0004-00000174',NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL);
INSERT INTO `cta_cte_cliente` VALUES (334,7847,2,40736,40740,13,6100,1,0,'2022-10-25','2022-10-25',6110.00,1,1.00,'Factura B N°: 0004-00000175',NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(335,7847,2,40736,40740,13,6100,1,0,'2022-10-25','2022-10-25',6980.00,1,1.00,'Factura B N°: 0004-00000176',NULL,'2022-11-23 12:24:13','2022-11-23 12:24:13',NULL),(336,7847,2,40736,40735,13,6100,1,0,'2022-10-31','2022-10-31',66550.00,1,1.00,'Factura A N°: 0004-00000001',NULL,'2022-11-23 12:24:13','2022-11-23 12:24:13',NULL),(337,7847,2,40736,40740,13,6100,1,0,'2022-10-21','2022-10-21',15613.00,1,1.00,'Factura B N°: 0005-00000082',NULL,'2022-11-23 12:24:27','2022-11-23 12:24:27',NULL),(338,7847,2,40736,40740,13,6100,1,0,'2022-10-21','2022-10-21',5600.00,1,1.00,'Factura B N°: 0005-00000083',NULL,'2022-11-23 12:24:27','2022-11-23 12:24:27',NULL),(339,7847,2,40736,40740,13,6100,1,0,'2022-10-21','2022-10-21',3150.00,1,1.00,'Factura B N°: 0005-00000084',NULL,'2022-11-23 12:24:27','2022-11-23 12:24:27',NULL),(340,7847,2,40736,40740,13,6100,1,0,'2022-10-21','2022-10-21',20081.00,1,1.00,'Factura B N°: 0005-00000085',NULL,'2022-11-23 12:24:27','2022-11-23 12:24:27',NULL),(341,7847,2,40736,40740,13,6100,1,0,'2022-10-21','2022-10-21',3000.00,1,1.00,'Factura B N°: 0005-00000086',NULL,'2022-11-23 12:24:27','2022-11-23 12:24:27',NULL),(342,7847,2,40736,40740,13,6100,1,0,'2022-10-24','2022-10-24',5700.00,1,1.00,'Factura B N°: 0005-00000087',NULL,'2022-11-23 12:24:28','2022-11-23 12:24:28',NULL),(343,7847,2,40736,40740,13,6100,1,0,'2022-10-24','2022-10-24',4750.00,1,1.00,'Factura B N°: 0005-00000088',NULL,'2022-11-23 12:24:28','2022-11-23 12:24:28',NULL),(344,7847,2,40736,40740,13,6100,1,0,'2022-10-24','2022-10-24',4000.00,1,1.00,'Factura B N°: 0005-00000089',NULL,'2022-11-23 12:24:28','2022-11-23 12:24:28',NULL),(345,7847,2,40736,40740,13,6100,1,0,'2022-10-24','2022-10-24',7150.00,1,1.00,'Factura B N°: 0005-00000090',NULL,'2022-11-23 12:24:28','2022-11-23 12:24:28',NULL),(346,7847,2,40736,40740,13,6100,1,0,'2022-10-24','2022-10-24',12011.00,1,1.00,'Factura B N°: 0005-00000091',NULL,'2022-11-23 12:24:28','2022-11-23 12:24:28',NULL),(347,7847,2,40787,40788,13,51641,1,0,'2022-10-03','2022-10-03',100000.00,1,1.00,'Factura A N°: 0003-00000055',NULL,'2022-11-26 20:57:10','2022-11-26 20:57:10',NULL),(348,7847,2,40787,40789,13,51641,1,0,'2022-10-11','2022-10-11',713900.00,1,1.00,'Factura A N°: 0003-00000056',NULL,'2022-11-26 20:57:10','2022-11-26 20:57:10',NULL),(349,7847,2,40787,40790,13,51641,1,0,'2022-10-17','2022-10-17',58000.01,1,1.00,'Factura A N°: 0003-00000057',NULL,'2022-11-26 20:57:10','2022-11-26 20:57:10',NULL),(350,7847,2,40787,40791,13,51641,1,0,'2022-10-24','2022-10-24',60000.00,1,1.00,'Factura B N°: 0003-00000037',NULL,'2022-11-26 20:57:10','2022-11-26 20:57:10',NULL),(351,7847,3,40787,40727,57,51641,2,0,'2022-10-05','2022-10-05',150.00,1,1.00,'Factura A N°: 0022-00661112',NULL,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(352,7847,3,40787,40727,57,51641,2,0,'2022-10-05','2022-10-05',1117.77,1,1.00,'Factura A N°: 0020-01476797',NULL,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(353,7847,3,40787,40792,57,51641,2,0,'2022-10-13','2022-10-13',5000.00,1,1.00,'Factura A N°: 7942-00011782',NULL,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(354,7847,3,40787,40792,57,51641,2,0,'2022-10-15','2022-10-15',5019.99,1,1.00,'Factura A N°: 7944-00009490',NULL,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(355,7847,3,40787,40793,57,51641,2,0,'2022-10-24','2022-10-24',166000.00,1,1.00,'Factura A N°: 0001-00001616',NULL,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(356,7847,3,40787,40793,57,51641,2,0,'2022-10-24','2022-10-24',200000.00,1,1.00,'Factura A N°: 0001-00001614',NULL,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(357,7847,3,40787,40793,57,51641,2,0,'2022-10-24','2022-10-24',234000.01,1,1.00,'Factura A N°: 0001-00001627',NULL,'2022-11-26 20:57:25','2022-11-26 20:59:50','2022-11-26 20:59:50');
INSERT INTO `cta_cte_cliente` VALUES (358,7847,3,40787,40793,57,51641,2,0,'2022-10-24','2022-10-24',234000.00,1,1.00,'Factura A N°: 0001-00001627',NULL,'2022-11-26 20:59:50','2022-11-26 20:59:50',NULL),(359,7847,2,40787,40727,13,51641,1,0,'2022-10-05','2022-10-05',150.00,1,1.00,'Factura A N°: 0022-00661112',NULL,'2022-11-27 06:44:34','2022-11-27 06:53:27','2022-11-27 06:53:27'),(360,7847,2,40787,40727,13,51641,1,0,'2022-10-05','2022-10-05',1117.77,1,1.00,'Factura A N°: 0020-01476797',NULL,'2022-11-27 06:44:34','2022-11-27 06:48:41','2022-11-27 06:48:41'),(361,7847,2,40787,40792,13,51641,1,0,'2022-10-13','2022-10-13',5000.00,1,1.00,'Factura A N°: 7942-00011782',NULL,'2022-11-27 06:44:34','2022-11-27 06:48:20','2022-11-27 06:48:20'),(362,7847,2,40787,40792,13,51641,1,0,'2022-10-15','2022-10-15',5019.99,1,1.00,'Factura A N°: 7944-00009490',NULL,'2022-11-27 06:44:34','2022-11-27 06:45:52','2022-11-27 06:45:52'),(363,7847,2,40787,40793,13,51641,1,0,'2022-10-24','2022-10-24',166000.00,1,1.00,'Factura A N°: 0001-00001616',NULL,'2022-11-27 06:44:34','2022-11-27 06:53:33','2022-11-27 06:53:33'),(364,7847,2,40787,40793,13,51641,1,0,'2022-10-24','2022-10-24',200000.00,1,1.00,'Factura A N°: 0001-00001614',NULL,'2022-11-27 06:44:34','2022-11-27 06:53:37','2022-11-27 06:53:37'),(365,7847,2,40787,40793,13,51641,1,0,'2022-10-24','2022-10-24',234000.01,1,1.00,'Factura A N°: 0001-00001627',NULL,'2022-11-27 06:44:34','2022-11-27 06:53:46','2022-11-27 06:53:46'),(366,7847,2,40787,40792,13,51641,1,0,'2022-10-15','2022-10-15',5020.05,1,1.00,'Factura A N°: 7944-00009490',NULL,'2022-11-27 06:45:52','2022-11-27 06:49:44','2022-11-27 06:49:44'),(367,7847,2,40787,40792,13,51641,1,0,'2022-10-13','2022-10-13',5000.00,1,1.00,'Factura A N°: 7942-00011782',NULL,'2022-11-27 06:48:20','2022-11-27 06:53:07','2022-11-27 06:53:07'),(368,7847,2,40787,40727,13,51641,1,0,'2022-10-05','2022-10-05',1117.77,1,1.00,'Factura A N°: 0020-01476797',NULL,'2022-11-27 06:48:41','2022-11-27 06:48:41',NULL),(369,7847,2,40787,40792,13,51641,1,0,'2022-10-15','2022-10-15',5019.99,1,1.00,'Factura A N°: 7944-00009490',NULL,'2022-11-27 06:49:44','2022-11-27 06:53:42','2022-11-27 06:53:42'),(370,7847,2,40735,40794,13,4597,1,0,'2022-10-04','2022-10-04',60000.00,1,1.00,'Factura B N°: 0002-00000015',NULL,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(371,7847,2,40735,40794,13,4597,1,0,'2022-10-04','2022-10-04',45000.00,1,1.00,'Factura B N°: 0002-00000016',NULL,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(372,7847,2,40735,40795,13,4597,1,0,'2022-10-11','2022-10-11',267748.80,1,1.00,'Factura A N°: 0002-00000003',NULL,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(373,7847,2,40735,40794,13,4597,1,0,'2022-10-11','2022-10-11',35000.00,1,1.00,'Factura B N°: 0002-00000017',NULL,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(374,7847,2,40735,40794,13,4597,1,0,'2022-10-19','2022-10-19',43500.00,1,1.00,'Factura B N°: 0002-00000018',NULL,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(375,7847,2,40735,40795,13,4597,1,0,'2022-10-25','2022-10-25',184404.00,1,1.00,'Factura A N°: 0002-00000004',NULL,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(376,7847,2,40735,40794,13,4597,1,0,'2022-10-25','2022-10-25',44000.00,1,1.00,'Factura B N°: 0002-00000019',NULL,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(377,7847,3,40735,40796,57,4597,2,0,'2022-10-16','2022-10-16',1100.00,1,1.00,'Factura B N°: 0003-00677017',NULL,'2022-11-28 13:01:41','2022-11-28 13:01:41',NULL),(378,7847,3,40735,40792,57,4597,2,0,'2022-10-22','2022-10-22',10000.00,1,1.00,'Factura A N°: 6920-00017214',NULL,'2022-11-28 13:01:41','2022-11-28 13:01:41',NULL),(379,7847,3,40735,40719,57,4597,2,0,'2022-10-25','2022-10-25',12000.00,1,1.00,'Factura C N°: 0002-00000038',NULL,'2022-11-28 13:01:41','2022-11-28 13:01:41',NULL),(380,7847,3,40735,40792,57,4597,2,0,'2022-10-28','2022-10-28',6000.00,1,1.00,'Factura A N°: 7942-00012255',NULL,'2022-11-28 13:01:41','2022-11-28 13:01:41',NULL);
INSERT INTO `cta_cte_cliente` VALUES (381,7847,3,40735,40736,57,4597,2,0,'2022-10-31','2022-10-31',66550.00,1,1.00,'Factura A N°: 0004-00000001',NULL,'2022-11-28 13:01:41','2022-11-28 13:01:41',NULL),(382,7847,3,40735,40797,57,4597,2,0,'2022-10-31','2022-10-31',143990.00,1,1.00,'Factura A N°: 0001-00000071',NULL,'2022-11-28 13:01:41','2022-11-28 13:01:41',NULL),(383,7847,3,40735,40798,57,4597,2,0,'2022-10-06','2022-10-06',10000.97,1,1.00,'Tique Factura A N°: 0015-00026955',NULL,'2022-11-28 14:03:24','2022-11-28 14:03:24',NULL),(384,7847,3,40735,40799,57,4597,2,0,'2022-10-12','2022-10-12',5000.01,1,1.00,'Tique Factura A N°: 0014-00010992',NULL,'2022-11-28 14:05:35','2022-11-28 14:05:35',NULL),(387,7847,3,40720,40749,57,1526,2,0,'2022-11-13','2022-11-13',31624.11,1,1.00,'Factura B N°: 2219-04280483',NULL,'2022-12-23 11:12:30','2022-12-23 11:23:22','2022-12-23 11:23:22'),(388,7847,3,40720,40803,57,1526,2,0,'2022-11-20','2022-11-20',5450.48,1,1.00,'Factura A N°: 2026-00064720',NULL,'2022-12-23 11:12:30','2022-12-23 11:12:30',NULL),(389,7847,3,40720,40804,57,1526,2,0,'2022-11-29','2022-11-29',500001.04,1,1.00,'Factura A N°: 0001-00000001',NULL,'2022-12-23 11:12:30','2022-12-23 11:12:30',NULL),(390,7847,3,40720,40719,57,1526,2,0,'2022-11-30','2022-11-30',18000.00,1,1.00,'Factura C N°: 0002-00000046',NULL,'2022-12-23 11:12:30','2022-12-23 11:12:30',NULL),(392,7847,2,40720,40749,13,1526,1,0,'2022-11-13','2022-11-13',31624.11,1,1.00,'Factura B N°: 2219-04280483',NULL,'2022-12-23 11:17:07','2022-12-23 11:19:13','2022-12-23 11:19:13'),(393,7847,2,40720,40803,13,1526,1,0,'2022-11-20','2022-11-20',5450.48,1,1.00,'Factura A N°: 2026-00064720',NULL,'2022-12-23 11:17:07','2022-12-23 11:19:05','2022-12-23 11:19:05'),(394,7847,2,40720,40804,13,1526,1,0,'2022-11-29','2022-11-29',500001.04,1,1.00,'Factura A N°: 0001-00000001',NULL,'2022-12-23 11:17:07','2022-12-23 11:19:00','2022-12-23 11:19:00'),(395,7847,2,40720,40719,13,1526,1,0,'2022-11-30','2022-11-30',18000.00,1,1.00,'Factura C N°: 0002-00000046',NULL,'2022-12-23 11:17:07','2022-12-23 11:18:03','2022-12-23 11:18:03'),(396,7847,2,40720,40806,13,1526,1,0,'2022-11-28','2022-11-28',46524.00,1,1.00,'Factura B N°: 0005-00000002',NULL,'2022-12-23 11:17:35','2022-12-23 11:36:00','2022-12-23 11:36:00'),(397,7847,2,40720,40807,13,1526,1,0,'2022-11-28','2022-11-28',50028.00,1,1.00,'Factura B N°: 0005-00000003',NULL,'2022-12-23 11:17:35','2022-12-23 11:35:38','2022-12-23 11:35:38'),(398,7847,2,40720,40807,13,1526,1,0,'2022-11-28','2022-11-28',50028.00,1,1.00,'Factura B N°: 0005-00000003',NULL,'2022-12-23 11:35:38','2022-12-23 11:35:38',NULL),(399,7847,2,40720,40806,13,1526,1,0,'2022-11-28','2022-11-28',46524.00,1,1.00,'Factura B N°: 0005-00000002',NULL,'2022-12-23 11:36:00','2022-12-23 11:36:00',NULL),(400,7847,3,40720,40808,57,1526,2,0,'2022-11-23','2022-11-23',12900.01,1,1.00,'Tique Factura A N°: 0009-00002890',NULL,'2022-12-23 11:43:26','2022-12-23 11:43:26',NULL),(401,7847,3,40720,40749,57,1525,2,0,'2022-10-02','2022-10-02',28319.75,1,1.00,'Factura B N°: 2219-04149284',NULL,'2022-12-23 11:58:32','2022-12-23 11:59:10','2022-12-23 11:59:10'),(402,7847,3,40720,40809,57,1525,2,0,'2022-10-03','2022-10-03',5404.00,1,1.00,'Factura C N°: 0400-05624186',NULL,'2022-12-23 11:58:32','2022-12-23 11:58:32',NULL),(403,7847,3,40720,40719,57,1525,2,0,'2022-10-25','2022-10-25',19000.00,1,1.00,'Factura C N°: 0002-00000041',NULL,'2022-12-23 11:58:32','2022-12-23 11:58:32',NULL),(404,7847,3,40720,40810,57,1525,2,0,'2022-10-31','2022-10-31',8800.00,1,1.00,'Factura A N°: 0002-00001770',NULL,'2022-12-23 11:58:32','2022-12-23 12:04:49','2022-12-23 12:04:49'),(405,7847,2,40735,40794,13,4600,1,0,'2023-01-03','2023-01-03',46800.00,1,1.00,'Factura B N°: 0002-00000031',NULL,'2023-02-21 23:43:30','2023-02-21 23:43:30',NULL),(406,7847,2,40735,40794,13,4600,1,0,'2023-01-03','2023-01-03',48000.00,1,1.00,'Factura B N°: 0002-00000032',NULL,'2023-02-21 23:43:30','2023-02-21 23:43:30',NULL);
INSERT INTO `cta_cte_cliente` VALUES (407,7847,2,40735,40794,13,4600,1,0,'2023-01-24','2023-01-24',45500.00,1,1.00,'Factura B N°: 0002-00000033',NULL,'2023-02-21 23:43:30','2023-02-21 23:43:30',NULL),(408,7847,2,40735,40795,13,4600,1,0,'2023-01-31','2023-01-31',133874.40,1,1.00,'Factura A N°: 0002-00000013',NULL,'2023-02-21 23:43:30','2023-02-21 23:43:30',NULL),(409,7847,2,40735,40794,13,4600,1,0,'2023-01-31','2023-01-31',48300.00,1,1.00,'Factura B N°: 0002-00000034',NULL,'2023-02-21 23:43:30','2023-02-21 23:43:30',NULL),(410,7847,3,40735,40815,57,4600,2,0,'2023-01-03','2023-01-03',231.00,1,1.00,'Factura B N°: 0711-28952430',NULL,'2023-02-21 23:43:39','2023-02-22 00:17:39','2023-02-22 00:17:39'),(411,7847,3,40735,40796,57,4600,2,0,'2023-01-15','2023-01-15',1500.00,1,1.00,'Factura B N°: 0003-00992535',NULL,'2023-02-21 23:43:39','2023-02-22 00:19:22','2023-02-22 00:19:22'),(412,7847,3,40735,40815,57,4600,2,0,'2023-01-17','2023-01-17',326.57,1,1.00,'Factura B N°: 0711-29394204',NULL,'2023-02-21 23:43:39','2023-02-22 00:18:32','2023-02-22 00:18:32'),(413,7847,3,40735,40792,57,4600,2,0,'2023-01-19','2023-01-19',4000.01,1,1.00,'Factura A N°: 6944-00013815',NULL,'2023-02-21 23:43:39','2023-02-21 23:43:39',NULL),(414,7847,3,40735,40816,57,4600,2,0,'2023-01-20','2023-01-20',1172.00,1,1.00,'Factura B N°: 0113-12850545',NULL,'2023-02-21 23:43:39','2023-02-22 00:18:02','2023-02-22 00:18:02'),(415,7847,3,40735,40792,57,4600,2,0,'2023-01-24','2023-01-24',9999.99,1,1.00,'Factura A N°: 8104-00010378',NULL,'2023-02-21 23:43:39','2023-02-21 23:43:39',NULL),(416,7847,3,40735,40817,57,4600,2,0,'2023-01-25','2023-01-25',400001.80,1,1.00,'Factura A N°: 0001-00000157',NULL,'2023-02-21 23:43:39','2023-02-21 23:43:39',NULL),(417,7847,3,40735,40815,57,4600,2,0,'2023-01-03','2023-01-03',231.00,1,1.00,'Factura B N°: 0711-28952430',NULL,'2023-02-22 00:17:39','2023-02-22 00:19:38','2023-02-22 00:19:38'),(418,7847,3,40735,40816,57,4600,2,0,'2023-01-20','2023-01-20',1172.00,1,1.00,'Factura B N°: 0113-12850545',NULL,'2023-02-22 00:18:02','2023-02-22 00:19:01','2023-02-22 00:19:01'),(419,7847,3,40735,40815,57,4600,2,0,'2023-01-17','2023-01-17',326.58,1,1.00,'Factura B N°: 0711-29394204',NULL,'2023-02-22 00:18:32','2023-02-22 00:18:32',NULL),(420,7847,3,40735,40816,57,4600,2,0,'2023-01-20','2023-01-20',1172.00,1,1.00,'Factura B N°: 0113-12850545',NULL,'2023-02-22 00:19:01','2023-02-22 00:19:01',NULL),(421,7847,3,40735,40796,57,4600,2,0,'2023-01-15','2023-01-15',1500.00,1,1.00,'Factura B N°: 0003-00992535',NULL,'2023-02-22 00:19:22','2023-02-22 00:19:22',NULL),(422,7847,3,40735,40815,57,4600,2,0,'2023-01-03','2023-01-03',231.00,1,1.00,'Factura B N°: 0711-28952430',NULL,'2023-02-22 00:19:38','2023-02-22 00:19:38',NULL),(423,7847,2,40720,40806,13,1533,1,0,'2023-01-08','2023-01-08',54000.00,1,1.00,'Factura B N°: 0005-00000008',NULL,'2023-02-22 00:53:39','2023-02-22 00:53:39',NULL),(424,7847,2,40720,40818,13,1533,1,0,'2023-01-20','2023-01-20',215000.00,1,1.00,'Factura B N°: 0005-00000009',NULL,'2023-02-22 00:53:39','2023-02-22 00:53:39',NULL),(425,7847,3,40720,40819,57,1533,2,0,'2023-01-18','2023-01-18',3150.19,1,1.00,'Factura B N°: 0102-00009787',NULL,'2023-02-22 00:53:51','2023-02-22 00:53:51',NULL),(426,7847,3,40720,40820,57,1533,2,0,'2023-01-25','2023-01-25',350316.00,1,1.00,'Factura B N°: 0202-00007621',NULL,'2023-02-22 00:53:51','2023-02-22 00:53:51',NULL),(427,7847,3,40720,40810,57,1533,2,0,'2023-01-25','2023-01-25',19400.00,1,1.00,'Factura A N°: 0002-00002006',NULL,'2023-02-22 00:53:51','2023-02-22 00:53:51',NULL),(428,7847,3,40720,40804,57,1533,2,0,'2023-01-25','2023-01-25',371300.60,1,1.00,'Factura A N°: 0001-00000005',NULL,'2023-02-22 00:53:51','2023-02-22 00:53:51',NULL),(429,7847,3,40720,40804,57,1533,2,0,'2023-01-25','2023-01-25',100000.45,1,1.00,'Factura A N°: 0001-00000004',NULL,'2023-02-22 00:53:51','2023-02-22 00:53:51',NULL);
INSERT INTO `cta_cte_cliente` VALUES (430,7847,3,40720,40803,57,1533,2,0,'2023-01-31','2023-01-31',16352.61,1,1.00,'Factura A N°: 2026-00073704',NULL,'2023-02-22 00:53:51','2023-02-22 00:57:05','2023-02-22 00:57:05'),(431,7847,3,40720,40803,57,1533,2,0,'2023-01-31','2023-01-31',16352.60,1,1.00,'Factura A N°: 2026-00073704',NULL,'2023-02-22 00:57:05','2023-02-22 00:57:05',NULL),(432,7847,2,40736,40790,13,6104,1,0,'2023-01-11','2023-01-11',33002.75,1,1.00,'Factura A N°: 0004-00000003',NULL,'2023-02-22 13:21:17','2023-02-22 13:21:17',NULL),(433,7847,2,40736,40740,13,6104,1,0,'2023-01-11','2023-01-11',17220.00,1,1.00,'Factura B N°: 0004-00000284',NULL,'2023-02-22 13:21:17','2023-02-22 13:21:17',NULL),(434,7847,2,40736,40740,13,6104,1,0,'2023-01-11','2023-01-11',19480.00,1,1.00,'Factura B N°: 0004-00000285',NULL,'2023-02-22 13:21:17','2023-02-22 13:21:17',NULL),(435,7847,2,40736,40740,13,6104,1,0,'2023-01-11','2023-01-11',19250.00,1,1.00,'Factura B N°: 0004-00000286',NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(436,7847,2,40736,40740,13,6104,1,0,'2023-01-11','2023-01-11',20580.00,1,1.00,'Factura B N°: 0004-00000287',NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(437,7847,2,40736,40740,13,6104,1,0,'2023-01-11','2023-01-11',17580.00,1,1.00,'Factura B N°: 0004-00000288',NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(438,7847,2,40736,40740,13,6104,1,0,'2023-01-11','2023-01-11',21000.00,1,1.00,'Factura B N°: 0004-00000289',NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(439,7847,2,40736,40740,13,6104,1,0,'2023-01-11','2023-01-11',19880.00,1,1.00,'Factura B N°: 0004-00000290',NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(440,7847,2,40736,40740,13,6104,1,0,'2023-01-11','2023-01-11',20700.00,1,1.00,'Factura B N°: 0004-00000291',NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(441,7847,2,40736,40740,13,6104,1,0,'2023-01-11','2023-01-11',21000.00,1,1.00,'Factura B N°: 0004-00000292',NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(442,7847,2,40736,40740,13,6104,1,0,'2023-01-13','2023-01-13',17430.00,1,1.00,'Factura B N°: 0004-00000293',NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(443,7847,2,40736,40740,13,6104,1,0,'2023-01-13','2023-01-13',20930.00,1,1.00,'Factura B N°: 0004-00000294',NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(444,7847,2,40736,40740,13,6104,1,0,'2023-01-13','2023-01-13',19340.00,1,1.00,'Factura B N°: 0004-00000295',NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(445,7847,2,40736,40740,13,6104,1,0,'2023-01-13','2023-01-13',17770.00,1,1.00,'Factura B N°: 0004-00000296',NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(446,7847,2,40736,40740,13,6104,1,0,'2023-01-13','2023-01-13',20870.00,1,1.00,'Factura B N°: 0004-00000297',NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(447,7847,2,40736,40740,13,6104,1,0,'2023-01-13','2023-01-13',19130.00,1,1.00,'Factura B N°: 0004-00000298',NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(448,7847,2,40736,40740,13,6104,1,0,'2023-01-13','2023-01-13',18700.00,1,1.00,'Factura B N°: 0004-00000299',NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(449,7847,2,40736,40740,13,6104,1,0,'2023-01-13','2023-01-13',21200.00,1,1.00,'Factura B N°: 0004-00000300',NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(450,7847,2,40736,40740,13,6104,1,0,'2023-01-13','2023-01-13',17130.00,1,1.00,'Factura B N°: 0004-00000301',NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(451,7847,2,40736,40740,13,6104,1,0,'2023-01-13','2023-01-13',21250.00,1,1.00,'Factura B N°: 0004-00000302',NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(452,7847,2,40736,40740,13,6104,1,0,'2023-01-14','2023-01-14',20230.00,1,1.00,'Factura B N°: 0004-00000303',NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(453,7847,2,40736,40740,13,6104,1,0,'2023-01-14','2023-01-14',4760.00,1,1.00,'Factura B N°: 0004-00000304',NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL);
INSERT INTO `cta_cte_cliente` VALUES (454,7847,2,40736,40740,13,6104,1,0,'2023-01-14','2023-01-14',20980.00,1,1.00,'Factura B N°: 0004-00000305',NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(455,7847,2,40736,40740,13,6104,1,0,'2023-01-14','2023-01-14',20395.00,1,1.00,'Factura B N°: 0004-00000306',NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(456,7847,2,40736,40740,13,6104,1,0,'2023-01-14','2023-01-14',8514.00,1,1.00,'Factura B N°: 0004-00000307',NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(457,7847,2,40736,40740,13,6104,1,0,'2023-01-15','2023-01-15',21640.00,1,1.00,'Factura B N°: 0004-00000308',NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(458,7847,2,40736,40740,13,6104,1,0,'2023-01-15','2023-01-15',16010.00,1,1.00,'Factura B N°: 0004-00000309',NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(459,7847,2,40736,40740,13,6104,1,0,'2023-01-16','2023-01-16',10470.00,1,1.00,'Factura B N°: 0004-00000310',NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(460,7847,2,40736,40740,13,6104,1,0,'2023-01-28','2023-01-28',18390.00,1,1.00,'Factura B N°: 0004-00000311',NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(461,7847,2,40736,40740,13,6104,1,0,'2023-01-28','2023-01-28',21560.00,1,1.00,'Factura B N°: 0004-00000312',NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(462,7847,2,40736,40740,13,6104,1,0,'2023-01-28','2023-01-28',14330.00,1,1.00,'Factura B N°: 0004-00000313',NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(463,7847,2,40736,40740,13,6104,1,0,'2023-01-28','2023-01-28',20980.00,1,1.00,'Factura B N°: 0004-00000314',NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(464,7847,2,40736,40740,13,6104,1,0,'2023-01-28','2023-01-28',17769.00,1,1.00,'Factura B N°: 0004-00000315',NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(465,7847,2,40736,40740,13,6104,1,0,'2023-01-28','2023-01-28',16150.00,1,1.00,'Factura B N°: 0004-00000316',NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(466,7847,2,40736,40740,13,6104,1,0,'2023-01-28','2023-01-28',21640.00,1,1.00,'Factura B N°: 0004-00000317',NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(467,7847,2,40736,40740,13,6104,1,0,'2023-01-28','2023-01-28',14970.00,1,1.00,'Factura B N°: 0004-00000318',NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(468,7847,2,40736,40740,13,6104,1,0,'2023-01-28','2023-01-28',11540.00,1,1.00,'Factura B N°: 0004-00000319',NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(469,7847,2,40736,40740,13,6104,1,0,'2023-01-29','2023-01-29',20450.00,1,1.00,'Factura B N°: 0004-00000320',NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(470,7847,2,40736,40740,13,6104,1,0,'2023-01-29','2023-01-29',20680.00,1,1.00,'Factura B N°: 0004-00000321',NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(471,7847,2,40736,40740,13,6104,1,0,'2023-01-29','2023-01-29',23960.00,1,1.00,'Factura B N°: 0004-00000322',NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(472,7847,2,40736,40740,13,6104,1,0,'2023-01-29','2023-01-29',25000.00,1,1.00,'Factura B N°: 0004-00000323',NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(473,7847,2,40736,40740,13,6104,1,0,'2023-01-29','2023-01-29',19000.00,1,1.00,'Factura B N°: 0004-00000324',NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(474,7847,2,40736,40740,13,6104,1,0,'2023-01-30','2023-01-30',22589.00,1,1.00,'Factura B N°: 0004-00000325',NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(475,7847,2,40736,40740,13,6104,1,0,'2023-01-30','2023-01-30',23240.00,1,1.00,'Factura B N°: 0004-00000326',NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(476,7847,2,40736,40740,13,6104,1,0,'2023-01-30','2023-01-30',22180.00,1,1.00,'Factura B N°: 0004-00000327',NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(477,7847,2,40736,40740,13,6104,1,0,'2023-01-30','2023-01-30',20450.00,1,1.00,'Factura B N°: 0004-00000328',NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL);
INSERT INTO `cta_cte_cliente` VALUES (478,7847,2,40736,40740,13,6104,1,0,'2023-01-30','2023-01-30',22310.00,1,1.00,'Factura B N°: 0004-00000329',NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(479,7847,3,40736,40821,57,6104,2,0,'2023-01-03','2023-01-03',10000.65,1,1.00,'Factura A N°: 0002-00003986',NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(480,7847,3,40736,40740,57,6104,1,0,'1969-12-31','1969-12-31',0.00,1,1.00,'Recibo E N°: 0000-00000000',NULL,'2023-02-22 13:21:33','2023-02-24 10:48:26','2023-02-24 10:48:26'),(481,7847,3,40736,40767,57,6104,2,0,'2023-01-04','2023-01-04',1743.01,1,1.00,'Factura A N°: 0004-00023188',NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(482,7847,3,40736,40761,57,6104,2,0,'2023-01-05','2023-01-05',289844.27,1,1.00,'Factura A N°: 0001-00005073',NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(483,7847,3,40736,40766,57,6104,2,0,'2023-01-05','2023-01-05',5600.00,1,1.00,'Factura A N°: 0001-00000070',NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(484,7847,3,40736,40775,57,6104,2,0,'2023-01-05','2023-01-05',625309.74,1,1.00,'Factura A N°: 0884-00065772',NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(485,7847,3,40736,40767,57,6104,2,0,'2023-01-05','2023-01-05',839.99,1,1.00,'Factura A N°: 0004-00023204',NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(486,7847,3,40736,40767,57,6104,2,0,'2023-01-05','2023-01-05',839.99,1,1.00,'Factura A N°: 0004-00023205',NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(487,7847,3,40736,40767,57,6104,2,0,'2023-01-05','2023-01-05',1323.00,1,1.00,'Factura A N°: 0004-00023206',NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(488,7847,3,40736,40767,57,6104,2,0,'2023-01-05','2023-01-05',1385.99,1,1.00,'Factura A N°: 0004-00023208',NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(489,7847,3,40736,40769,57,6104,2,0,'2023-01-05','2023-01-05',10330.78,1,1.00,'Factura A N°: 0052-00024476',NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(490,7847,3,40736,40765,57,6104,2,0,'2023-01-06','2023-01-06',49834.72,1,1.00,'Factura A N°: 0091-00063468',NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(491,7847,3,40736,40766,57,6104,2,0,'2023-01-06','2023-01-06',5600.00,1,1.00,'Factura A N°: 0001-00000071',NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(492,7847,3,40736,40763,57,6104,2,0,'2023-01-06','2023-01-06',10186.91,1,1.00,'Factura A N°: 0063-02229678',NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(493,7847,3,40736,40765,57,6104,1,0,'2023-01-07','2023-01-07',49834.72,1,1.00,'Nota de crédito A N°: 0091-00007094',NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(494,7847,3,40736,40767,57,6104,2,0,'2023-01-11','2023-01-11',1743.01,1,1.00,'Factura A N°: 0004-00023370',NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(495,7847,3,40736,40767,57,6104,2,0,'2023-01-11','2023-01-11',1385.99,1,1.00,'Factura A N°: 0004-00023371',NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(496,7847,3,40736,40769,57,6104,2,0,'2023-01-11','2023-01-11',19914.45,1,1.00,'Factura A N°: 0052-00024528',NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(497,7847,3,40736,40767,57,6104,2,0,'2023-01-11','2023-01-11',839.99,1,1.00,'Factura A N°: 0004-00023362',NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(498,7847,3,40736,40767,57,6104,2,0,'2023-01-11','2023-01-11',839.99,1,1.00,'Factura A N°: 0004-00023369',NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(499,7847,3,40736,40775,57,6104,2,0,'2023-01-12','2023-01-12',312654.87,1,1.00,'Factura A N°: 0884-00066229',NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(500,7847,3,40736,40767,57,6104,2,0,'2023-01-12','2023-01-12',839.99,1,1.00,'Factura A N°: 0004-00023387',NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(501,7847,3,40736,40767,57,6104,2,0,'2023-01-12','2023-01-12',1743.01,1,1.00,'Factura A N°: 0004-00023388',NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL);
INSERT INTO `cta_cte_cliente` VALUES (502,7847,3,40736,40767,57,6104,2,0,'2023-01-12','2023-01-12',1743.01,1,1.00,'Factura A N°: 0004-00023389',NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(503,7847,3,40736,40767,57,6104,2,0,'2023-01-12','2023-01-12',839.99,1,1.00,'Factura A N°: 0004-00023392',NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(504,7847,3,40736,40767,57,6104,2,0,'2023-01-12','2023-01-12',839.99,1,1.00,'Factura A N°: 0004-00023393',NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(505,7847,3,40736,40761,57,6104,2,0,'2023-01-16','2023-01-16',436566.91,1,1.00,'Factura A N°: 0001-00005090',NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(506,7847,3,40736,40769,57,6104,2,0,'2023-01-16','2023-01-16',43200.00,1,1.00,'Factura A N°: 0052-00024544',NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(507,7847,3,40736,40767,57,6104,2,0,'2023-01-18','2023-01-18',1385.99,1,1.00,'Factura A N°: 0004-00023561',NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(508,7847,3,40736,40767,57,6104,2,0,'2023-01-18','2023-01-18',1385.99,1,1.00,'Factura A N°: 0004-00023565',NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(509,7847,3,40736,40767,57,6104,2,0,'2023-01-18','2023-01-18',1385.99,1,1.00,'Factura A N°: 0004-00023567',NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(510,7847,3,40736,40767,57,6104,2,0,'2023-01-18','2023-01-18',839.99,1,1.00,'Factura A N°: 0004-00023572',NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(511,7847,3,40736,40767,57,6104,2,0,'2023-01-18','2023-01-18',1385.99,1,1.00,'Factura A N°: 0004-00023573',NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(512,7847,3,40736,40767,57,6104,2,0,'2023-01-18','2023-01-18',1385.99,1,1.00,'Factura A N°: 0004-00023574',NULL,'2023-02-22 13:21:35','2023-02-22 13:21:35',NULL),(513,7847,3,40736,40766,57,6104,2,0,'2023-01-19','2023-01-19',8400.00,1,1.00,'Factura A N°: 0001-00000075',NULL,'2023-02-22 13:21:35','2023-02-22 13:21:35',NULL),(514,7847,3,40736,40822,57,6104,2,0,'2023-01-23','2023-01-23',49430.11,1,1.00,'Factura A N°: 0006-00019187',NULL,'2023-02-22 13:21:35','2023-02-22 13:21:35',NULL),(515,7847,3,40736,40823,57,6104,2,0,'2023-01-27','2023-01-27',19600.79,1,1.00,'Factura A N°: 0007-00004019',NULL,'2023-02-22 13:21:35','2023-02-22 13:21:35',NULL),(516,7847,3,40736,40775,57,6104,2,0,'2023-01-27','2023-01-27',650447.82,1,1.00,'Factura A N°: 0884-00067171',NULL,'2023-02-22 13:21:35','2023-02-22 13:46:29','2023-02-22 13:46:29'),(517,7847,3,40736,40824,57,6104,2,0,'2023-01-30','2023-01-30',26065.06,1,1.00,'Factura A N°: 0010-00603041',NULL,'2023-02-22 13:21:35','2023-02-22 13:21:35',NULL),(518,7847,3,40736,40775,57,6104,2,0,'2023-01-27','2023-01-27',650447.82,1,1.00,'Factura A N°: 0884-00067171',NULL,'2023-02-22 13:46:29','2023-02-22 13:46:29',NULL),(519,7847,3,40736,40764,57,6104,2,0,'2023-01-03','2023-01-03',9295.98,1,1.00,'Factura B N°: 0001-00319944',NULL,'2023-02-24 10:46:11','2023-02-24 10:47:11','2023-02-24 10:47:11'),(520,7847,3,40736,40773,57,6104,2,0,'2023-01-05','2023-01-05',53794.38,1,1.00,'Factura B N°: 0151-03334614',NULL,'2023-02-24 10:46:12','2023-02-24 10:47:05','2023-02-24 10:47:05'),(521,7847,3,40736,40825,57,6104,2,0,'2023-01-08','2023-01-08',48199.85,1,1.00,'Factura B N°: 12671-00122361',NULL,'2023-02-24 10:46:12','2023-02-24 10:46:57','2023-02-24 10:46:57'),(522,7847,3,40736,40749,57,6104,2,0,'2023-01-09','2023-01-09',21608.48,1,1.00,'Factura B N°: 2131-04855817',NULL,'2023-02-24 10:46:12','2023-02-24 10:46:47','2023-02-24 10:46:47'),(523,7847,3,40736,40771,57,6104,2,0,'2023-01-11','2023-01-11',5000.00,1,1.00,'Factura B N°: 0001-00000707',NULL,'2023-02-24 10:46:12','2023-02-24 10:46:39','2023-02-24 10:46:39'),(524,7847,2,40736,40740,13,6102,1,0,'2022-11-04','2022-11-04',6510.00,1,1.00,'Factura B N°: 0004-00000177',NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(525,7847,2,40736,40740,13,6102,1,0,'2022-11-04','2022-11-04',6040.00,1,1.00,'Factura B N°: 0004-00000178',NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL);
INSERT INTO `cta_cte_cliente` VALUES (526,7847,2,40736,40740,13,6102,1,0,'2022-11-04','2022-11-04',20000.00,1,1.00,'Factura B N°: 0004-00000179',NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(527,7847,2,40736,40740,13,6102,1,0,'2022-11-04','2022-11-04',16320.00,1,1.00,'Factura B N°: 0004-00000180',NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(528,7847,2,40736,40740,13,6102,1,0,'2022-11-04','2022-11-04',20000.00,1,1.00,'Factura B N°: 0004-00000181',NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(529,7847,2,40736,40740,13,6102,1,0,'2022-11-04','2022-11-04',15900.00,1,1.00,'Factura B N°: 0004-00000182',NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(530,7847,2,40736,40740,13,6102,1,0,'2022-11-04','2022-11-04',3350.00,1,1.00,'Factura B N°: 0004-00000183',NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(531,7847,2,40736,40740,13,6102,1,0,'2022-11-04','2022-11-04',2000.00,1,1.00,'Factura B N°: 0004-00000184',NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(532,7847,2,40736,40740,13,6102,1,0,'2022-11-04','2022-11-04',3500.00,1,1.00,'Factura B N°: 0004-00000185',NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(533,7847,2,40736,40740,13,6102,1,0,'2022-11-04','2022-11-04',18200.00,1,1.00,'Factura B N°: 0004-00000186',NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(534,7847,2,40736,40740,13,6102,1,0,'2022-11-04','2022-11-04',11110.00,1,1.00,'Factura B N°: 0004-00000187',NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(535,7847,2,40736,40740,13,6102,1,0,'2022-11-04','2022-11-04',21140.00,1,1.00,'Factura B N°: 0004-00000188',NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(536,7847,2,40736,40740,13,6102,1,0,'2022-11-04','2022-11-04',5600.00,1,1.00,'Factura B N°: 0004-00000189',NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(537,7847,2,40736,40740,13,6102,1,0,'2022-11-04','2022-11-04',17540.00,1,1.00,'Factura B N°: 0004-00000190',NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(538,7847,2,40736,40740,13,6102,1,0,'2022-11-04','2022-11-04',11890.00,1,1.00,'Factura B N°: 0004-00000191',NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(539,7847,2,40736,40740,13,6102,1,0,'2022-11-04','2022-11-04',15000.00,1,1.00,'Factura B N°: 0004-00000192',NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(540,7847,2,40736,40740,13,6102,1,0,'2022-11-04','2022-11-04',10350.00,1,1.00,'Factura B N°: 0005-00000092',NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(541,7847,2,40736,40740,13,6102,1,0,'2022-11-04','2022-11-04',10700.00,1,1.00,'Factura B N°: 0005-00000093',NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(542,7847,2,40736,40740,13,6102,1,0,'2022-11-04','2022-11-04',6730.00,1,1.00,'Factura B N°: 0005-00000094',NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(543,7847,2,40736,40740,13,6102,1,0,'2022-11-04','2022-11-04',9600.00,1,1.00,'Factura B N°: 0005-00000095',NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(544,7847,2,40736,40740,13,6102,1,0,'2022-11-04','2022-11-04',11800.00,1,1.00,'Factura B N°: 0005-00000096',NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(545,7847,2,40736,40740,13,6102,1,0,'2022-11-04','2022-11-04',12150.00,1,1.00,'Factura B N°: 0005-00000097',NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(546,7847,2,40736,40740,13,6102,1,0,'2022-11-04','2022-11-04',16715.00,1,1.00,'Factura B N°: 0005-00000098',NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(547,7847,2,40736,40740,13,6102,1,0,'2022-11-04','2022-11-04',14692.00,1,1.00,'Factura B N°: 0005-00000099',NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(548,7847,2,40736,40740,13,6102,1,0,'2022-11-05','2022-11-05',20700.00,1,1.00,'Factura B N°: 0004-00000193',NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(549,7847,2,40736,40740,13,6102,1,0,'2022-11-05','2022-11-05',20370.00,1,1.00,'Factura B N°: 0004-00000194',NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL);
INSERT INTO `cta_cte_cliente` VALUES (550,7847,2,40736,40740,13,6102,1,0,'2022-11-05','2022-11-05',9110.00,1,1.00,'Factura B N°: 0004-00000195',NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(551,7847,2,40736,40740,13,6102,1,0,'2022-11-05','2022-11-05',5480.00,1,1.00,'Factura B N°: 0004-00000196',NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(552,7847,2,40736,40740,13,6102,1,0,'2022-11-05','2022-11-05',5900.00,1,1.00,'Factura B N°: 0004-00000197',NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(553,7847,2,40736,40740,13,6102,1,0,'2022-11-05','2022-11-05',2010.00,1,1.00,'Factura B N°: 0004-00000198',NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(554,7847,2,40736,40740,13,6102,1,0,'2022-11-05','2022-11-05',19400.00,1,1.00,'Factura B N°: 0004-00000199',NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(555,7847,2,40736,40740,13,6102,1,0,'2022-11-05','2022-11-05',8990.00,1,1.00,'Factura B N°: 0004-00000200',NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(556,7847,2,40736,40740,13,6102,1,0,'2022-11-05','2022-11-05',21450.00,1,1.00,'Factura B N°: 0004-00000201',NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(557,7847,2,40736,40740,13,6102,1,0,'2022-11-05','2022-11-05',16680.00,1,1.00,'Factura B N°: 0004-00000202',NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(558,7847,2,40736,40740,13,6102,1,0,'2022-11-05','2022-11-05',11680.00,1,1.00,'Factura B N°: 0004-00000203',NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(559,7847,2,40736,40740,13,6102,1,0,'2022-11-05','2022-11-05',16880.00,1,1.00,'Factura B N°: 0004-00000204',NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(560,7847,2,40736,40740,13,6102,1,0,'2022-11-05','2022-11-05',19670.00,1,1.00,'Factura B N°: 0004-00000205',NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(561,7847,2,40736,40740,13,6102,1,0,'2022-11-05','2022-11-05',10000.00,1,1.00,'Factura B N°: 0004-00000206',NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(562,7847,2,40736,40740,13,6102,1,0,'2022-11-07','2022-11-07',18279.00,1,1.00,'Factura B N°: 0005-00000100',NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(563,7847,2,40736,40740,13,6102,1,0,'2022-11-12','2022-11-12',8300.00,1,1.00,'Factura B N°: 0004-00000207',NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(564,7847,2,40736,40740,13,6102,1,0,'2022-11-12','2022-11-12',12200.00,1,1.00,'Factura B N°: 0004-00000208',NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(565,7847,2,40736,40740,13,6102,1,0,'2022-11-12','2022-11-12',9600.00,1,1.00,'Factura B N°: 0004-00000209',NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(566,7847,2,40736,40740,13,6102,1,0,'2022-11-12','2022-11-12',6880.00,1,1.00,'Factura B N°: 0004-00000210',NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(567,7847,2,40736,40740,13,6102,1,0,'2022-11-12','2022-11-12',4800.00,1,1.00,'Factura B N°: 0004-00000211',NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(568,7847,2,40736,40740,13,6102,1,0,'2022-11-12','2022-11-12',8600.00,1,1.00,'Factura B N°: 0004-00000212',NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(569,7847,2,40736,40740,13,6102,1,0,'2022-11-12','2022-11-12',4800.00,1,1.00,'Factura B N°: 0004-00000213',NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(570,7847,2,40736,40740,13,6102,1,0,'2022-11-14','2022-11-14',3500.00,1,1.00,'Factura B N°: 0004-00000214',NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(571,7847,2,40736,40740,13,6102,1,0,'2022-11-14','2022-11-14',5700.00,1,1.00,'Factura B N°: 0004-00000215',NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(572,7847,2,40736,40740,13,6102,1,0,'2022-11-14','2022-11-14',3900.00,1,1.00,'Factura B N°: 0004-00000216',NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(573,7847,2,40736,40740,13,6102,1,0,'2022-11-14','2022-11-14',4800.00,1,1.00,'Factura B N°: 0004-00000217',NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL);
INSERT INTO `cta_cte_cliente` VALUES (574,7847,2,40736,40740,13,6102,1,0,'2022-11-14','2022-11-14',6500.00,1,1.00,'Factura B N°: 0004-00000218',NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(575,7847,2,40736,40740,13,6102,1,0,'2022-11-14','2022-11-14',5340.00,1,1.00,'Factura B N°: 0004-00000219',NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(576,7847,2,40736,40740,13,6102,1,0,'2022-11-14','2022-11-14',3500.00,1,1.00,'Factura B N°: 0004-00000220',NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(577,7847,2,40736,40740,13,6102,1,0,'2022-11-14','2022-11-14',10630.00,1,1.00,'Factura B N°: 0004-00000221',NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(578,7847,2,40736,40740,13,6102,1,0,'2022-11-14','2022-11-14',3500.00,1,1.00,'Factura B N°: 0004-00000222',NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(579,7847,2,40736,40740,13,6102,1,0,'2022-11-15','2022-11-15',7300.00,1,1.00,'Factura B N°: 0004-00000223',NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(580,7847,2,40736,40740,13,6102,1,0,'2022-11-15','2022-11-15',1000.00,1,1.00,'Factura B N°: 0004-00000224',NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(581,7847,2,40736,40740,13,6102,1,0,'2022-11-15','2022-11-15',5500.00,1,1.00,'Factura B N°: 0004-00000225',NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(582,7847,2,40736,40740,13,6102,1,0,'2022-11-16','2022-11-16',13500.00,1,1.00,'Factura B N°: 0004-00000226',NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(583,7847,2,40736,40740,13,6102,1,0,'2022-11-16','2022-11-16',6000.00,1,1.00,'Factura B N°: 0004-00000227',NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(584,7847,2,40736,40740,13,6102,1,0,'2022-11-16','2022-11-16',8500.00,1,1.00,'Factura B N°: 0004-00000228',NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(585,7847,2,40736,40740,13,6102,1,0,'2022-11-16','2022-11-16',2500.00,1,1.00,'Factura B N°: 0004-00000229',NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(586,7847,2,40736,40826,13,6102,1,0,'2022-11-16','2022-11-16',8400.00,1,1.00,'Factura B N°: 0004-00000230',NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(587,7847,2,40736,40740,13,6102,1,0,'2022-11-18','2022-11-18',18670.00,1,1.00,'Factura B N°: 0004-00000231',NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(588,7847,2,40736,40740,13,6102,1,0,'2022-11-18','2022-11-18',14500.00,1,1.00,'Factura B N°: 0004-00000232',NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(589,7847,2,40736,40740,13,6102,1,0,'2022-11-18','2022-11-18',9800.00,1,1.00,'Factura B N°: 0004-00000233',NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(590,7847,2,40736,40740,13,6102,1,0,'2022-11-18','2022-11-18',6630.00,1,1.00,'Factura B N°: 0004-00000234',NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(591,7847,2,40736,40740,13,6102,1,0,'2022-11-18','2022-11-18',14010.00,1,1.00,'Factura B N°: 0004-00000235',NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(592,7847,2,40736,40740,13,6102,1,0,'2022-11-18','2022-11-18',18430.00,1,1.00,'Factura B N°: 0004-00000236',NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(593,7847,2,40736,40740,13,6102,1,0,'2022-11-18','2022-11-18',5360.00,1,1.00,'Factura B N°: 0004-00000237',NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(594,7847,2,40736,40740,13,6102,1,0,'2022-11-19','2022-11-19',20900.00,1,1.00,'Factura B N°: 0004-00000238',NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(595,7847,2,40736,40740,13,6102,1,0,'2022-11-19','2022-11-19',10900.00,1,1.00,'Factura B N°: 0004-00000239',NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(596,7847,2,40736,40740,13,6102,1,0,'2022-11-19','2022-11-19',21400.00,1,1.00,'Factura B N°: 0004-00000240',NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(597,7847,2,40736,40740,13,6102,1,0,'2022-11-19','2022-11-19',11880.00,1,1.00,'Factura B N°: 0004-00000241',NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL);
INSERT INTO `cta_cte_cliente` VALUES (598,7847,2,40736,40740,13,6102,1,0,'2022-11-19','2022-11-19',2280.00,1,1.00,'Factura B N°: 0004-00000242',NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(599,7847,2,40736,40740,13,6102,1,0,'2022-11-19','2022-11-19',9970.00,1,1.00,'Factura B N°: 0004-00000243',NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(600,7847,2,40736,40740,13,6102,1,0,'2022-11-19','2022-11-19',19470.00,1,1.00,'Factura B N°: 0004-00000244',NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(601,7847,2,40736,40740,13,6102,1,0,'2022-11-19','2022-11-19',6810.00,1,1.00,'Factura B N°: 0004-00000245',NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(602,7847,2,40736,40740,13,6102,1,0,'2022-11-19','2022-11-19',13660.00,1,1.00,'Factura B N°: 0004-00000246',NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(603,7847,2,40736,40740,13,6102,1,0,'2022-11-19','2022-11-19',12690.00,1,1.00,'Factura B N°: 0004-00000247',NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(604,7847,2,40736,40740,13,6102,1,0,'2022-11-19','2022-11-19',6430.00,1,1.00,'Factura B N°: 0004-00000248',NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(605,7847,2,40736,40740,13,6102,1,0,'2022-11-19','2022-11-19',11850.00,1,1.00,'Factura B N°: 0004-00000249',NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(606,7847,2,40736,40740,13,6102,1,0,'2022-11-19','2022-11-19',7980.00,1,1.00,'Factura B N°: 0004-00000250',NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(607,7847,2,40736,40740,13,6102,1,0,'2022-11-19','2022-11-19',12450.00,1,1.00,'Factura B N°: 0004-00000251',NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(608,7847,2,40736,40790,13,6102,1,0,'2022-11-21','2022-11-21',36000.00,1,1.00,'Factura A N°: 0004-00000002',NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(609,7847,2,40736,40827,13,6102,1,0,'2022-11-25','2022-11-25',4560.00,1,1.00,'Factura B N°: 0004-00000252',NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(610,7847,2,40736,40740,13,6102,1,0,'2022-11-30','2022-11-30',13000.00,1,1.00,'Factura B N°: 0004-00000253',NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(611,7847,2,40736,40740,13,6102,1,0,'2022-11-30','2022-11-30',7800.00,1,1.00,'Factura B N°: 0005-00000101',NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(612,7847,2,40736,40740,13,6102,1,0,'2022-11-30','2022-11-30',6370.00,1,1.00,'Factura B N°: 0005-00000102',NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(613,7847,3,40736,40764,57,6102,2,0,'2022-12-01','2022-12-01',9295.98,1,1.00,'Factura B N°: 0001-00299859',NULL,'2023-02-24 11:52:47','2023-02-24 11:52:47',NULL),(614,7847,3,40736,40770,57,6102,2,0,'2022-12-02','2022-12-02',78120.51,1,1.00,'Factura A N°: 0002-00001211',NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(615,7847,3,40736,40766,57,6102,2,0,'2022-12-03','2022-12-03',3900.00,1,1.00,'Factura A N°: 0001-00000054',NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(616,7847,3,40736,40766,57,6102,2,0,'2022-12-05','2022-12-05',4200.00,1,1.00,'Factura A N°: 0001-00000055',NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(617,7847,3,40736,40768,57,6102,2,0,'2022-12-05','2022-12-05',117656.00,1,1.00,'Factura A N°: 0004-00033658',NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(618,7847,3,40736,40763,57,6102,2,0,'2022-12-05','2022-12-05',8493.64,1,1.00,'Factura A N°: 0063-02191475',NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(619,7847,3,40736,40769,57,6102,2,0,'2022-12-05','2022-12-05',8158.74,1,1.00,'Factura A N°: 0052-00024249',NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(620,7847,3,40736,40761,57,6102,2,0,'2022-12-06','2022-12-06',72057.53,1,1.00,'Factura A N°: 0001-00004986',NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(621,7847,3,40736,40761,57,6102,2,0,'2022-12-06','2022-12-06',122394.11,1,1.00,'Factura A N°: 0001-00004985',NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL);
INSERT INTO `cta_cte_cliente` VALUES (622,7847,3,40736,40767,57,6102,2,0,'2022-12-06','2022-12-06',839.99,1,1.00,'Factura A N°: 0004-00022284',NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(623,7847,3,40736,40767,57,6102,2,0,'2022-12-07','2022-12-07',839.99,1,1.00,'Factura A N°: 0004-00022319',NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(624,7847,3,40736,40767,57,6102,2,0,'2022-12-07','2022-12-07',1743.01,1,1.00,'Factura A N°: 0004-00022320',NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(625,7847,3,40736,40765,57,6102,2,0,'2022-12-10','2022-12-10',37315.53,1,1.00,'Factura A N°: 0091-00062231',NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(626,7847,3,40736,40765,57,6102,2,0,'2022-12-10','2022-12-10',587088.87,1,1.00,'Factura A N°: 0091-00062230',NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(627,7847,3,40736,40762,57,6102,2,0,'2022-12-10','2022-12-10',84120.07,1,1.00,'Factura A N°: 0003-00000496',NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(628,7847,3,40736,40766,57,6102,2,0,'2022-12-10','2022-12-10',4200.00,1,1.00,'Factura A N°: 0001-00000057',NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(629,7847,3,40736,40749,57,6102,2,0,'2022-12-11','2022-12-11',21045.75,1,1.00,'Factura B N°: 2131-04723201',NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(630,7847,3,40736,40765,57,6102,1,0,'2022-12-12','2022-12-12',37315.53,1,1.00,'Nota de crédito A N°: 0091-00007042',NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(631,7847,3,40736,40771,57,6102,2,0,'2022-12-12','2022-12-12',5000.00,1,1.00,'Factura B N°: 0001-00000675',NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(632,7847,3,40736,40766,57,6102,2,0,'2022-12-13','2022-12-13',4200.00,1,1.00,'Factura A N°: 0001-00000060',NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(633,7847,3,40736,40762,57,6102,2,0,'2022-12-13','2022-12-13',20381.77,1,1.00,'Factura A N°: 0003-00000499',NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(634,7847,3,40736,40762,57,6102,2,0,'2022-12-13','2022-12-13',94579.87,1,1.00,'Factura A N°: 0003-00000498',NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(635,7847,3,40736,40775,57,6102,2,0,'2022-12-13','2022-12-13',625309.74,1,1.00,'Factura A N°: 0884-00064107',NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(636,7847,3,40736,40769,57,6102,2,0,'2022-12-14','2022-12-14',34465.61,1,1.00,'Factura A N°: 0052-00024328',NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(637,7847,3,40736,40767,57,6102,2,0,'2022-12-14','2022-12-14',1323.00,1,1.00,'Factura A N°: 0004-00022553',NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(638,7847,3,40736,40767,57,6102,2,0,'2022-12-14','2022-12-14',693.00,1,1.00,'Factura A N°: 0004-00022567',NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(639,7847,3,40736,40767,57,6102,2,0,'2022-12-14','2022-12-14',1385.99,1,1.00,'Factura A N°: 0004-00022568',NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(640,7847,3,40736,40767,57,6102,2,0,'2022-12-14','2022-12-14',839.99,1,1.00,'Factura A N°: 0004-00022569',NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(641,7847,3,40736,40766,57,6102,2,0,'2022-12-15','2022-12-15',4200.00,1,1.00,'Factura A N°: 0001-00000062',NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(642,7847,3,40736,40761,57,6102,2,0,'2022-12-16','2022-12-16',322679.03,1,1.00,'Factura A N°: 0001-00005019',NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(643,7847,3,40736,40766,57,6102,2,0,'2022-12-16','2022-12-16',4200.00,1,1.00,'Factura A N°: 0001-00000063',NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(644,7847,3,40736,40824,57,6102,2,0,'2022-12-20','2022-12-20',58906.44,1,1.00,'Factura A N°: 0010-00596864',NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(645,7847,3,40736,40828,57,6102,2,0,'2022-12-20','2022-12-20',37515.32,1,1.00,'Factura A N°: 0007-00002403',NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL);
INSERT INTO `cta_cte_cliente` VALUES (646,7847,3,40736,40767,57,6102,2,0,'2022-12-21','2022-12-21',1743.01,1,1.00,'Factura A N°: 0004-00022797',NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(647,7847,3,40736,40767,57,6102,2,0,'2022-12-21','2022-12-21',1385.99,1,1.00,'Factura A N°: 0004-00022798',NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(648,7847,3,40736,40767,57,6102,2,0,'2022-12-21','2022-12-21',1385.99,1,1.00,'Factura A N°: 0004-00022799',NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(649,7847,3,40736,40767,57,6102,2,0,'2022-12-21','2022-12-21',1385.99,1,1.00,'Factura A N°: 0004-00022803',NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(650,7847,3,40736,40767,57,6102,2,0,'2022-12-21','2022-12-21',839.99,1,1.00,'Factura A N°: 0004-00022804',NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(651,7847,3,40736,40767,57,6102,2,0,'2022-12-21','2022-12-21',839.99,1,1.00,'Factura A N°: 0004-00022805',NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(652,7847,3,40736,40767,57,6102,2,0,'2022-12-21','2022-12-21',1323.00,1,1.00,'Factura A N°: 0004-00022807',NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(653,7847,3,40736,40767,57,6102,2,0,'2022-12-21','2022-12-21',1323.00,1,1.00,'Factura A N°: 0004-00022809',NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(654,7847,3,40736,40767,57,6102,2,0,'2022-12-21','2022-12-21',1385.99,1,1.00,'Factura A N°: 0004-00022810',NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(655,7847,3,40736,40765,57,6102,2,0,'2022-12-22','2022-12-22',37315.53,1,1.00,'Factura A N°: 0091-00062818',NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(656,7847,3,40736,40765,57,6102,2,0,'2022-12-22','2022-12-22',610480.26,1,1.00,'Factura A N°: 0091-00062814',NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(657,7847,3,40736,40765,57,6102,2,0,'2022-12-22','2022-12-22',48893.65,1,1.00,'Factura A N°: 0091-00062815',NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(658,7847,3,40736,40766,57,6102,2,0,'2022-12-22','2022-12-22',5600.00,1,1.00,'Factura A N°: 0001-00000066',NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(659,7847,3,40736,40761,57,6102,2,0,'2022-12-22','2022-12-22',315274.37,1,1.00,'Factura A N°: 0001-00005035',NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(660,7847,3,40736,40768,57,6102,2,0,'2022-12-22','2022-12-22',92549.17,1,1.00,'Factura A N°: 0004-00033970',NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(661,7847,3,40736,40767,57,6102,2,0,'2022-12-22','2022-12-22',1385.99,1,1.00,'Factura A N°: 0004-00022848',NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(662,7847,3,40736,40765,57,6102,1,0,'2022-12-23','2022-12-23',48893.65,1,1.00,'Nota de crédito A N°: 0091-00007062',NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(663,7847,3,40736,40765,57,6102,1,0,'2022-12-23','2022-12-23',37315.53,1,1.00,'Nota de crédito A N°: 0091-00007064',NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(664,7847,3,40736,40762,57,6102,2,0,'2022-12-23','2022-12-23',163086.11,1,1.00,'Factura A N°: 0003-00000513',NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(665,7847,3,40736,40769,57,6102,2,0,'2022-12-23','2022-12-23',36588.17,1,1.00,'Factura A N°: 0052-00024403',NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(666,7847,3,40736,40773,57,6102,2,0,'2022-12-27','2022-12-27',54734.94,1,1.00,'Factura B N°: 0151-03315771',NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(667,7847,3,40736,40719,57,6102,2,0,'2022-12-28','2022-12-28',24000.00,1,1.00,'Factura C N°: 0002-00000049',NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(668,7847,3,40736,40767,57,6102,2,0,'2022-12-28','2022-12-28',839.99,1,1.00,'Factura A N°: 0004-00023032',NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(669,7847,3,40736,40767,57,6102,2,0,'2022-12-29','2022-12-29',839.99,1,1.00,'Factura A N°: 0004-00023055',NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL);
INSERT INTO `cta_cte_cliente` VALUES (670,7847,3,40736,40767,57,6102,2,0,'2022-12-29','2022-12-29',1743.01,1,1.00,'Factura A N°: 0004-00023056',NULL,'2023-02-24 11:52:53','2023-02-24 11:52:53',NULL),(671,7847,3,40736,40767,57,6102,2,0,'2022-12-29','2022-12-29',1385.99,1,1.00,'Factura A N°: 0004-00023046',NULL,'2023-02-24 11:52:53','2023-02-24 11:52:53',NULL),(672,7847,3,40736,40767,57,6102,2,0,'2022-12-29','2022-12-29',1743.01,1,1.00,'Factura A N°: 0004-00023047',NULL,'2023-02-24 11:52:53','2023-02-24 11:52:53',NULL),(673,7847,3,40736,40766,57,6102,2,0,'2022-12-30','2022-12-30',5600.00,1,1.00,'Factura A N°: 0001-00000069',NULL,'2023-02-24 11:52:53','2023-02-24 11:52:53',NULL),(674,7847,3,40736,40765,57,6102,2,0,'2022-12-30','2022-12-30',610480.26,1,1.00,'Factura A N°: 0093-00007675',NULL,'2023-02-24 11:52:53','2023-02-24 11:52:53',NULL),(675,7847,3,40736,40776,57,6102,2,0,'2022-12-31','2022-12-31',0.00,1,1.00,'Factura B N°: 0006-10271226',NULL,'2023-02-24 11:52:53','2023-02-24 11:52:53',NULL),(676,7847,2,40720,40830,13,1534,1,0,'2023-02-28','2023-02-28',20800.00,1,1.00,'Factura B N°: 0005-00000010',NULL,'2023-03-28 10:43:34','2023-03-28 10:43:34',NULL),(677,7847,2,40720,40831,13,1534,1,0,'2023-02-28','2023-02-28',29510.00,1,1.00,'Factura B N°: 0005-00000011',NULL,'2023-03-28 10:43:34','2023-03-28 10:43:34',NULL),(678,7847,3,40720,40792,57,1534,2,0,'2023-02-05','2023-02-05',14900.50,1,1.00,'Factura A N°: 8010-00019006',NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(679,7847,3,40720,40749,57,1534,2,0,'2023-02-12','2023-02-12',27767.52,1,1.00,'Factura B N°: 2131-04995936',NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(680,7847,3,40720,40803,57,1534,2,0,'2023-02-18','2023-02-18',10903.17,1,1.00,'Factura A N°: 2023-00066354',NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(681,7847,3,40720,40719,57,1534,2,0,'2023-02-24','2023-02-24',19000.00,1,1.00,'Factura C N°: 0002-00000060',NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(682,7847,3,40720,40804,57,1534,2,0,'2023-02-24','2023-02-24',264500.07,1,1.00,'Factura A N°: 0001-00000007',NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(683,7847,3,40720,40804,57,1534,2,0,'2023-02-24','2023-02-24',400000.11,1,1.00,'Factura A N°: 0001-00000006',NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(684,7847,3,40720,40832,57,1534,2,0,'2023-02-26','2023-02-26',338999.00,1,1.00,'Factura B N°: 3564-00009721',NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(685,7847,3,40720,40804,57,1534,2,0,'2023-02-27','2023-02-27',200000.05,1,1.00,'Factura A N°: 0001-00000008',NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(686,7847,3,40720,40804,57,1534,2,0,'2023-02-27','2023-02-27',300007.40,1,1.00,'Factura A N°: 0001-00000009',NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(687,7847,3,40720,40804,57,1534,2,0,'2023-02-28','2023-02-28',300001.35,1,1.00,'Factura A N°: 0001-00000010',NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL);
/*!40000 ALTER TABLE `cta_cte_cliente` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente_details`
--

DROP TABLE IF EXISTS `cta_cte_cliente_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_cliente_details_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_cliente_details_person_id_foreign` (`person_id`),
  KEY `cta_cte_cliente_details_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `cta_cte_cliente_details_period_id_foreign` (`period_id`),
  KEY `cta_cte_cliente_details_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `cta_cte_cliente_details_saldo_id_foreign` (`saldo_id`),
  KEY `cta_cte_cliente_details_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `cta_cte_cliente_details_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `cta_cte_cliente_details_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_cliente_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_cliente_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_details_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `cta_cte_cliente_details_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente_details`
--

LOCK TABLES `cta_cte_cliente_details` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_cliente_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente_pivot_receipt`
--

DROP TABLE IF EXISTS `cta_cte_cliente_pivot_receipt`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente_pivot_receipt` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned NOT NULL,
  `receipt_id` int(11) DEFAULT NULL,
  `importe` decimal(16,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=688 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente_pivot_receipt`
--

LOCK TABLES `cta_cte_cliente_pivot_receipt` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente_pivot_receipt` DISABLE KEYS */;
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (1,7847,1,1,NULL,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(2,7847,2,2,NULL,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(3,7847,3,3,NULL,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(4,7847,4,4,NULL,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(5,7847,5,5,NULL,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(6,7847,6,6,NULL,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(7,7847,7,7,NULL,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(8,7847,8,8,NULL,'2022-10-05 10:14:29','2022-10-05 10:14:29',NULL),(9,7847,9,9,NULL,'2022-10-05 11:08:06','2022-10-05 11:08:06',NULL),(10,7847,10,10,NULL,'2022-10-05 11:08:06','2022-10-05 11:08:06',NULL),(11,7847,11,11,NULL,'2022-10-05 11:08:06','2022-10-05 11:08:06',NULL),(12,7847,12,12,NULL,'2022-10-05 11:08:06','2022-10-05 11:08:06',NULL),(13,7847,13,13,NULL,'2022-10-05 11:44:50','2022-10-05 11:44:50',NULL),(14,7847,14,14,NULL,'2022-10-05 11:44:50','2022-10-05 11:44:50',NULL),(15,7847,15,15,NULL,'2022-10-05 11:44:50','2022-10-05 11:44:50',NULL),(16,7847,16,16,NULL,'2022-10-05 11:45:17','2022-10-05 11:45:17',NULL),(17,7847,17,17,NULL,'2022-10-05 11:45:17','2022-10-05 11:45:17',NULL),(18,7847,18,18,NULL,'2022-10-05 11:45:17','2022-10-05 11:45:17',NULL),(19,7847,19,19,NULL,'2022-10-05 11:45:17','2022-10-05 11:45:17',NULL),(20,7847,20,20,NULL,'2022-10-05 11:46:32','2022-10-05 11:46:32',NULL),(21,7847,21,21,NULL,'2022-10-05 11:46:32','2022-10-05 11:46:32',NULL),(22,7847,22,22,NULL,'2022-10-05 11:46:32','2022-10-05 11:46:32',NULL),(23,7847,23,23,NULL,'2022-10-05 11:49:00','2022-10-05 11:49:00',NULL),(24,7847,24,24,NULL,'2022-10-30 07:14:02','2022-10-30 07:14:02',NULL),(25,7847,25,25,NULL,'2022-10-30 07:14:02','2022-10-30 07:14:02',NULL),(26,7847,26,26,NULL,'2022-10-30 07:14:02','2022-10-30 07:14:02',NULL),(27,7847,27,27,NULL,'2022-10-30 07:14:02','2022-10-30 07:14:02',NULL),(28,7847,28,28,NULL,'2022-10-30 07:14:02','2022-10-30 07:14:02',NULL),(29,7847,29,29,NULL,'2022-10-30 07:14:02','2022-10-30 07:14:02',NULL),(30,7847,30,30,NULL,'2022-10-30 07:14:02','2022-10-30 07:14:02',NULL),(31,7847,31,31,NULL,'2022-10-30 07:14:02','2022-10-30 07:14:02',NULL),(32,7847,32,32,NULL,'2022-10-30 07:14:02','2022-10-30 07:14:02',NULL),(33,7847,33,33,NULL,'2022-10-30 07:14:02','2022-10-30 07:14:02',NULL),(34,7847,34,34,NULL,'2022-10-30 07:14:14','2022-10-30 07:14:14',NULL),(35,7847,35,35,NULL,'2022-10-30 07:14:14','2022-10-30 07:14:14',NULL),(36,7847,36,36,NULL,'2022-10-30 07:14:14','2022-10-30 07:14:14',NULL),(37,7847,37,37,NULL,'2022-10-30 07:14:14','2022-10-30 07:14:14',NULL),(38,7847,38,38,NULL,'2022-10-30 07:14:14','2022-10-30 07:14:14',NULL),(39,7847,39,39,NULL,'2022-10-30 07:14:14','2022-10-30 07:14:14',NULL),(40,7847,40,40,NULL,'2022-10-30 07:14:14','2022-10-30 07:14:14',NULL),(41,7847,41,41,NULL,'2022-10-30 07:14:14','2022-10-30 07:14:14',NULL),(42,7847,42,42,NULL,'2022-10-30 07:14:14','2022-10-30 07:14:14',NULL),(43,7847,43,43,NULL,'2022-10-30 07:14:14','2022-10-30 07:14:14',NULL),(44,7847,44,44,NULL,'2022-10-30 07:14:14','2022-10-30 07:14:14',NULL),(45,7847,45,45,NULL,'2022-10-30 07:14:14','2022-10-30 07:14:14',NULL),(46,7847,46,46,NULL,'2022-10-30 07:14:14','2022-10-30 07:14:14',NULL),(47,7847,47,47,NULL,'2022-10-30 07:14:14','2022-10-30 07:14:14',NULL),(48,7847,48,48,NULL,'2022-10-30 07:14:14','2022-10-30 07:14:14',NULL),(49,7847,49,49,NULL,'2022-10-30 07:14:14','2022-10-30 07:14:14',NULL),(50,7847,50,50,NULL,'2022-10-30 07:14:14','2022-10-30 07:14:14',NULL),(51,7847,51,51,NULL,'2022-10-30 07:14:14','2022-10-30 07:14:14',NULL),(52,7847,52,52,NULL,'2022-10-30 07:14:14','2022-10-30 07:14:14',NULL),(53,7847,53,53,NULL,'2022-10-30 07:14:14','2022-10-30 07:14:14',NULL),(54,7847,54,54,NULL,'2022-10-30 07:14:14','2022-10-30 07:14:14',NULL),(55,7847,55,55,NULL,'2022-10-30 07:14:14','2022-10-30 07:14:14',NULL),(56,7847,56,56,NULL,'2022-10-30 07:14:14','2022-10-30 07:14:14',NULL),(57,7847,57,57,NULL,'2022-10-30 07:14:14','2022-10-30 07:14:14',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (58,7847,58,58,NULL,'2022-11-08 12:30:54','2022-11-08 12:30:54',NULL),(59,7847,59,59,NULL,'2022-11-08 12:30:54','2022-11-08 12:30:54',NULL),(60,7847,60,60,NULL,'2022-11-08 12:30:54','2022-11-08 12:30:54',NULL),(61,7847,61,61,NULL,'2022-11-08 12:31:34','2022-11-08 12:31:34',NULL),(62,7847,62,62,NULL,'2022-11-08 12:31:34','2022-11-08 12:31:34',NULL),(63,7847,63,63,NULL,'2022-11-08 12:31:34','2022-11-08 12:31:34',NULL),(64,7847,64,64,NULL,'2022-11-08 12:31:34','2022-11-08 12:31:34',NULL),(65,7847,65,65,NULL,'2022-11-08 12:31:34','2022-11-08 12:31:34',NULL),(66,7847,66,66,NULL,'2022-11-08 12:31:35','2022-11-08 12:31:35',NULL),(67,7847,67,67,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(68,7847,68,68,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(69,7847,69,69,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(70,7847,70,70,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(71,7847,71,71,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(72,7847,72,72,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(73,7847,73,73,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(74,7847,74,74,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(75,7847,75,75,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(76,7847,76,76,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(77,7847,77,77,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(78,7847,78,78,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(79,7847,79,79,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(80,7847,80,80,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(81,7847,81,81,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(82,7847,82,82,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(83,7847,83,83,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(84,7847,84,84,NULL,'2022-11-08 14:59:45','2022-11-08 14:59:45',NULL),(85,7847,85,85,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(86,7847,86,86,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(87,7847,87,87,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(88,7847,88,88,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(89,7847,89,89,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(90,7847,90,90,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(91,7847,91,91,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(92,7847,92,92,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(93,7847,93,93,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(94,7847,94,94,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(95,7847,95,95,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(96,7847,96,96,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(97,7847,97,97,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(98,7847,98,98,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(99,7847,99,99,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(100,7847,100,100,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(101,7847,101,101,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(102,7847,102,102,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(103,7847,103,103,NULL,'2022-11-08 14:59:46','2022-11-08 14:59:46',NULL),(104,7847,104,104,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(105,7847,105,105,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(106,7847,106,106,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(107,7847,107,107,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(108,7847,108,108,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(109,7847,109,109,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(110,7847,110,110,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(111,7847,111,111,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(112,7847,112,112,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(113,7847,113,113,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (114,7847,114,114,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(115,7847,115,115,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(116,7847,116,116,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(117,7847,117,117,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(118,7847,118,118,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(119,7847,119,119,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(120,7847,120,120,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(121,7847,121,121,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(122,7847,122,122,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(123,7847,123,123,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(124,7847,124,124,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(125,7847,125,125,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(126,7847,126,126,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(127,7847,127,127,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(128,7847,128,128,NULL,'2022-11-08 14:59:47','2022-11-08 14:59:47',NULL),(129,7847,129,129,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(130,7847,130,130,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(131,7847,131,131,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(132,7847,132,132,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(133,7847,133,133,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(134,7847,134,134,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(135,7847,135,135,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(136,7847,136,136,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(137,7847,137,137,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(138,7847,138,138,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(139,7847,139,139,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(140,7847,140,140,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(141,7847,141,141,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(142,7847,142,142,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(143,7847,143,143,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(144,7847,144,144,NULL,'2022-11-08 14:59:48','2022-11-08 14:59:48',NULL),(145,7847,145,145,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(146,7847,146,146,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(147,7847,147,147,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(148,7847,148,148,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(149,7847,149,149,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(150,7847,150,150,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(151,7847,151,151,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(152,7847,152,152,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(153,7847,153,153,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(154,7847,154,154,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(155,7847,155,155,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(156,7847,156,156,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(157,7847,157,157,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(158,7847,158,158,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(159,7847,159,159,NULL,'2022-11-08 14:59:49','2022-11-08 14:59:49',NULL),(160,7847,160,160,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(161,7847,161,161,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(162,7847,162,162,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(163,7847,163,163,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(164,7847,164,164,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(165,7847,165,165,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(166,7847,166,166,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(167,7847,167,167,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (168,7847,168,168,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(169,7847,169,169,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(170,7847,170,170,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(171,7847,171,171,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(172,7847,172,172,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(173,7847,173,173,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(174,7847,174,174,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(175,7847,175,175,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(176,7847,176,176,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(177,7847,177,177,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(178,7847,178,178,NULL,'2022-11-08 14:59:50','2022-11-08 14:59:50',NULL),(179,7847,179,179,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(180,7847,180,180,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(181,7847,181,181,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(182,7847,182,182,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(183,7847,183,183,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(184,7847,184,184,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(185,7847,185,185,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(186,7847,186,186,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(187,7847,187,187,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(188,7847,188,188,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(189,7847,189,189,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(190,7847,190,190,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(191,7847,191,191,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(192,7847,192,192,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(193,7847,193,193,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(194,7847,194,194,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(195,7847,195,195,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(196,7847,196,196,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(197,7847,197,197,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(198,7847,198,198,NULL,'2022-11-08 14:59:51','2022-11-08 14:59:51',NULL),(199,7847,199,199,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(200,7847,200,200,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(201,7847,201,201,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(202,7847,202,202,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(203,7847,203,203,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(204,7847,204,204,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(205,7847,205,205,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(206,7847,206,206,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(207,7847,207,207,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(208,7847,208,208,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(209,7847,209,209,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(210,7847,210,210,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(211,7847,211,211,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(212,7847,212,212,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(213,7847,213,213,NULL,'2022-11-08 14:59:52','2022-11-08 14:59:52',NULL),(214,7847,214,214,NULL,'2022-11-08 15:00:13','2022-11-08 15:00:13',NULL),(215,7847,215,215,NULL,'2022-11-08 15:00:14','2022-11-08 15:00:14',NULL),(216,7847,216,216,NULL,'2022-11-08 15:00:14','2022-11-08 15:00:14',NULL),(217,7847,217,217,NULL,'2022-11-08 15:00:14','2022-11-08 15:00:14',NULL),(218,7847,218,218,NULL,'2022-11-08 15:00:14','2022-11-08 15:00:14',NULL),(219,7847,219,219,NULL,'2022-11-08 15:00:14','2022-11-08 15:00:14',NULL),(220,7847,220,220,NULL,'2022-11-08 15:00:14','2022-11-08 15:00:14',NULL),(221,7847,221,222,NULL,'2022-11-15 10:57:14','2022-11-15 10:57:14',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (222,7847,222,223,NULL,'2022-11-15 11:06:09','2022-11-15 11:06:09',NULL),(223,7847,223,224,NULL,'2022-11-16 15:00:13','2022-11-16 15:00:13',NULL),(224,7847,224,225,NULL,'2022-11-16 15:00:13','2022-11-16 15:00:13',NULL),(225,7847,225,226,NULL,'2022-11-16 15:00:13','2022-11-16 15:00:13',NULL),(226,7847,226,227,NULL,'2022-11-16 15:00:13','2022-11-16 15:00:13',NULL),(227,7847,227,228,NULL,'2022-11-16 15:00:13','2022-11-16 15:00:13',NULL),(228,7847,228,229,NULL,'2022-11-16 15:00:13','2022-11-16 15:00:13',NULL),(229,7847,229,230,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(230,7847,230,231,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(231,7847,231,232,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(232,7847,232,233,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(233,7847,233,234,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(234,7847,234,235,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(235,7847,235,236,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(236,7847,236,237,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(237,7847,237,238,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(238,7847,238,239,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(239,7847,239,240,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(240,7847,240,241,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(241,7847,241,242,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(242,7847,242,243,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(243,7847,243,244,NULL,'2022-11-16 15:00:14','2022-11-16 15:00:14',NULL),(244,7847,244,245,NULL,'2022-11-22 17:13:45','2022-11-22 17:13:45',NULL),(245,7847,245,246,NULL,'2022-11-22 17:13:45','2022-11-22 17:13:45',NULL),(246,7847,246,247,NULL,'2022-11-22 17:13:45','2022-11-22 17:13:45',NULL),(247,7847,247,248,NULL,'2022-11-23 10:13:03','2022-11-23 10:13:03',NULL),(248,7847,248,249,NULL,'2022-11-23 10:13:03','2022-11-23 10:13:03',NULL),(249,7847,249,250,NULL,'2022-11-23 10:13:03','2022-11-23 10:13:03',NULL),(250,7847,250,251,NULL,'2022-11-23 10:13:03','2022-11-23 10:13:03',NULL),(251,7847,251,252,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(252,7847,252,253,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(253,7847,253,254,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(254,7847,254,255,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(255,7847,255,256,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(256,7847,256,257,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(257,7847,257,258,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(258,7847,258,259,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(259,7847,259,260,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(260,7847,260,261,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(261,7847,261,262,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(262,7847,262,263,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(263,7847,263,264,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(264,7847,264,265,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(265,7847,265,266,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(266,7847,266,267,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(267,7847,267,268,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(268,7847,268,269,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(269,7847,269,270,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(270,7847,270,271,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(271,7847,271,272,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(272,7847,272,273,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(273,7847,273,274,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(274,7847,274,275,NULL,'2022-11-23 10:13:04','2022-11-23 10:13:04',NULL),(275,7847,275,276,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (276,7847,276,277,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(277,7847,277,278,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(278,7847,278,279,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(279,7847,279,280,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(280,7847,280,281,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(281,7847,281,282,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(282,7847,282,283,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(283,7847,283,284,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(284,7847,284,285,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(285,7847,285,286,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(286,7847,286,287,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(287,7847,287,288,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(288,7847,288,289,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(289,7847,289,290,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(290,7847,290,291,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(291,7847,291,292,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(292,7847,292,293,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(293,7847,293,294,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(294,7847,294,295,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(295,7847,295,296,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(296,7847,296,297,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(297,7847,297,298,NULL,'2022-11-23 10:13:05','2022-11-23 10:13:05',NULL),(298,7847,298,299,NULL,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(299,7847,299,300,NULL,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(300,7847,300,301,NULL,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(301,7847,301,302,NULL,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(302,7847,302,303,NULL,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(303,7847,303,304,NULL,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(304,7847,304,305,NULL,'2022-11-23 10:13:06','2022-11-23 10:13:06',NULL),(305,7847,305,306,NULL,'2022-11-23 11:38:02','2022-11-23 11:38:02',NULL),(306,7847,306,307,NULL,'2022-11-23 11:38:02','2022-11-23 11:38:02',NULL),(307,7847,307,308,NULL,'2022-11-23 11:38:02','2022-11-23 11:38:02',NULL),(308,7847,308,309,NULL,'2022-11-23 11:38:02','2022-11-23 11:38:02',NULL),(309,7847,309,310,NULL,'2022-11-23 12:24:11','2022-11-23 12:24:11',NULL),(310,7847,310,311,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(311,7847,311,312,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(312,7847,312,313,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(313,7847,313,314,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(314,7847,314,315,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(315,7847,315,316,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(316,7847,316,317,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(317,7847,317,318,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(318,7847,318,319,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(319,7847,319,320,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(320,7847,320,321,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(321,7847,321,322,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(322,7847,322,323,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(323,7847,323,324,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(324,7847,324,325,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(325,7847,325,326,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(326,7847,326,327,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(327,7847,327,328,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(328,7847,328,329,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(329,7847,329,330,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (330,7847,330,331,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(331,7847,331,332,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(332,7847,332,333,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(333,7847,333,334,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(334,7847,334,335,NULL,'2022-11-23 12:24:12','2022-11-23 12:24:12',NULL),(335,7847,335,336,NULL,'2022-11-23 12:24:13','2022-11-23 12:24:13',NULL),(336,7847,336,337,NULL,'2022-11-23 12:24:13','2022-11-23 12:24:13',NULL),(337,7847,337,338,NULL,'2022-11-23 12:24:27','2022-11-23 12:24:27',NULL),(338,7847,338,339,NULL,'2022-11-23 12:24:27','2022-11-23 12:24:27',NULL),(339,7847,339,340,NULL,'2022-11-23 12:24:27','2022-11-23 12:24:27',NULL),(340,7847,340,341,NULL,'2022-11-23 12:24:27','2022-11-23 12:24:27',NULL),(341,7847,341,342,NULL,'2022-11-23 12:24:27','2022-11-23 12:24:27',NULL),(342,7847,342,343,NULL,'2022-11-23 12:24:28','2022-11-23 12:24:28',NULL),(343,7847,343,344,NULL,'2022-11-23 12:24:28','2022-11-23 12:24:28',NULL),(344,7847,344,345,NULL,'2022-11-23 12:24:28','2022-11-23 12:24:28',NULL),(345,7847,345,346,NULL,'2022-11-23 12:24:28','2022-11-23 12:24:28',NULL),(346,7847,346,347,NULL,'2022-11-23 12:24:28','2022-11-23 12:24:28',NULL),(347,7847,347,348,NULL,'2022-11-26 20:57:10','2022-11-26 20:57:10',NULL),(348,7847,348,349,NULL,'2022-11-26 20:57:10','2022-11-26 20:57:10',NULL),(349,7847,349,350,NULL,'2022-11-26 20:57:10','2022-11-26 20:57:10',NULL),(350,7847,350,351,NULL,'2022-11-26 20:57:10','2022-11-26 20:57:10',NULL),(351,7847,351,352,NULL,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(352,7847,352,353,NULL,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(353,7847,353,354,NULL,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(354,7847,354,355,NULL,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(355,7847,355,356,NULL,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(356,7847,356,357,NULL,'2022-11-26 20:57:25','2022-11-26 20:57:25',NULL),(357,7847,357,358,NULL,'2022-11-26 20:57:25','2022-11-26 20:59:50','2022-11-26 20:59:50'),(358,7847,358,358,NULL,'2022-11-26 20:59:50','2022-11-26 20:59:50',NULL),(359,7847,359,359,NULL,'2022-11-27 06:44:34','2022-11-27 06:44:34',NULL),(360,7847,360,360,NULL,'2022-11-27 06:44:34','2022-11-27 06:48:41','2022-11-27 06:48:41'),(361,7847,361,361,NULL,'2022-11-27 06:44:34','2022-11-27 06:48:20','2022-11-27 06:48:20'),(362,7847,362,362,NULL,'2022-11-27 06:44:34','2022-11-27 06:45:52','2022-11-27 06:45:52'),(363,7847,363,363,NULL,'2022-11-27 06:44:34','2022-11-27 06:44:34',NULL),(364,7847,364,364,NULL,'2022-11-27 06:44:34','2022-11-27 06:44:34',NULL),(365,7847,365,365,NULL,'2022-11-27 06:44:34','2022-11-27 06:44:34',NULL),(366,7847,366,362,NULL,'2022-11-27 06:45:52','2022-11-27 06:49:44','2022-11-27 06:49:44'),(367,7847,367,361,NULL,'2022-11-27 06:48:20','2022-11-27 06:48:20',NULL),(368,7847,368,360,NULL,'2022-11-27 06:48:41','2022-11-27 06:48:41',NULL),(369,7847,369,362,NULL,'2022-11-27 06:49:44','2022-11-27 06:49:44',NULL),(370,7847,370,366,NULL,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(371,7847,371,367,NULL,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(372,7847,372,368,NULL,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(373,7847,373,369,NULL,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(374,7847,374,370,NULL,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(375,7847,375,371,NULL,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(376,7847,376,372,NULL,'2022-11-28 13:01:27','2022-11-28 13:01:27',NULL),(377,7847,377,373,NULL,'2022-11-28 13:01:41','2022-11-28 13:01:41',NULL),(378,7847,378,374,NULL,'2022-11-28 13:01:41','2022-11-28 13:01:41',NULL),(379,7847,379,375,NULL,'2022-11-28 13:01:41','2022-11-28 13:01:41',NULL),(380,7847,380,376,NULL,'2022-11-28 13:01:41','2022-11-28 13:01:41',NULL),(381,7847,381,377,NULL,'2022-11-28 13:01:41','2022-11-28 13:01:41',NULL),(382,7847,382,378,NULL,'2022-11-28 13:01:41','2022-11-28 13:01:41',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (383,7847,383,379,NULL,'2022-11-28 14:03:24','2022-11-28 14:03:24',NULL),(384,7847,384,380,NULL,'2022-11-28 14:05:35','2022-11-28 14:05:35',NULL),(387,7847,387,383,NULL,'2022-12-23 11:12:30','2022-12-23 11:12:30',NULL),(388,7847,388,384,NULL,'2022-12-23 11:12:30','2022-12-23 11:12:30',NULL),(389,7847,389,385,NULL,'2022-12-23 11:12:30','2022-12-23 11:12:30',NULL),(390,7847,390,386,NULL,'2022-12-23 11:12:30','2022-12-23 11:12:30',NULL),(392,7847,392,388,NULL,'2022-12-23 11:17:07','2022-12-23 11:17:07',NULL),(393,7847,393,389,NULL,'2022-12-23 11:17:07','2022-12-23 11:17:07',NULL),(394,7847,394,390,NULL,'2022-12-23 11:17:07','2022-12-23 11:17:07',NULL),(395,7847,395,391,NULL,'2022-12-23 11:17:07','2022-12-23 11:17:07',NULL),(396,7847,396,392,NULL,'2022-12-23 11:17:35','2022-12-23 11:36:00','2022-12-23 11:36:00'),(397,7847,397,393,NULL,'2022-12-23 11:17:35','2022-12-23 11:35:38','2022-12-23 11:35:38'),(398,7847,398,393,NULL,'2022-12-23 11:35:38','2022-12-23 11:35:38',NULL),(399,7847,399,392,NULL,'2022-12-23 11:36:00','2022-12-23 11:36:00',NULL),(400,7847,400,394,NULL,'2022-12-23 11:43:26','2022-12-23 11:43:26',NULL),(401,7847,401,395,NULL,'2022-12-23 11:58:32','2022-12-23 11:58:32',NULL),(402,7847,402,396,NULL,'2022-12-23 11:58:32','2022-12-23 11:58:32',NULL),(403,7847,403,397,NULL,'2022-12-23 11:58:32','2022-12-23 11:58:32',NULL),(404,7847,404,398,NULL,'2022-12-23 11:58:32','2022-12-23 11:58:32',NULL),(405,7847,405,399,NULL,'2023-02-21 23:43:30','2023-02-21 23:43:30',NULL),(406,7847,406,400,NULL,'2023-02-21 23:43:30','2023-02-21 23:43:30',NULL),(407,7847,407,401,NULL,'2023-02-21 23:43:30','2023-02-21 23:43:30',NULL),(408,7847,408,402,NULL,'2023-02-21 23:43:30','2023-02-21 23:43:30',NULL),(409,7847,409,403,NULL,'2023-02-21 23:43:30','2023-02-21 23:43:30',NULL),(410,7847,410,404,NULL,'2023-02-21 23:43:39','2023-02-22 00:17:39','2023-02-22 00:17:39'),(411,7847,411,405,NULL,'2023-02-21 23:43:39','2023-02-22 00:19:22','2023-02-22 00:19:22'),(412,7847,412,406,NULL,'2023-02-21 23:43:39','2023-02-22 00:18:32','2023-02-22 00:18:32'),(413,7847,413,407,NULL,'2023-02-21 23:43:39','2023-02-21 23:43:39',NULL),(414,7847,414,408,NULL,'2023-02-21 23:43:39','2023-02-22 00:18:02','2023-02-22 00:18:02'),(415,7847,415,409,NULL,'2023-02-21 23:43:39','2023-02-21 23:43:39',NULL),(416,7847,416,410,NULL,'2023-02-21 23:43:39','2023-02-21 23:43:39',NULL),(417,7847,417,404,NULL,'2023-02-22 00:17:39','2023-02-22 00:19:38','2023-02-22 00:19:38'),(418,7847,418,408,NULL,'2023-02-22 00:18:02','2023-02-22 00:19:01','2023-02-22 00:19:01'),(419,7847,419,406,NULL,'2023-02-22 00:18:32','2023-02-22 00:18:32',NULL),(420,7847,420,408,NULL,'2023-02-22 00:19:01','2023-02-22 00:19:01',NULL),(421,7847,421,405,NULL,'2023-02-22 00:19:22','2023-02-22 00:19:22',NULL),(422,7847,422,404,NULL,'2023-02-22 00:19:38','2023-02-22 00:19:38',NULL),(423,7847,423,411,NULL,'2023-02-22 00:53:39','2023-02-22 00:53:39',NULL),(424,7847,424,412,NULL,'2023-02-22 00:53:39','2023-02-22 00:53:39',NULL),(425,7847,425,413,NULL,'2023-02-22 00:53:51','2023-02-22 00:53:51',NULL),(426,7847,426,414,NULL,'2023-02-22 00:53:51','2023-02-22 00:53:51',NULL),(427,7847,427,415,NULL,'2023-02-22 00:53:51','2023-02-22 00:53:51',NULL),(428,7847,428,416,NULL,'2023-02-22 00:53:51','2023-02-22 00:53:51',NULL),(429,7847,429,417,NULL,'2023-02-22 00:53:51','2023-02-22 00:53:51',NULL),(430,7847,430,418,NULL,'2023-02-22 00:53:51','2023-02-22 00:57:05','2023-02-22 00:57:05'),(431,7847,431,418,NULL,'2023-02-22 00:57:05','2023-02-22 00:57:05',NULL),(432,7847,432,419,NULL,'2023-02-22 13:21:17','2023-02-22 13:21:17',NULL),(433,7847,433,420,NULL,'2023-02-22 13:21:17','2023-02-22 13:21:17',NULL),(434,7847,434,421,NULL,'2023-02-22 13:21:17','2023-02-22 13:21:17',NULL),(435,7847,435,422,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(436,7847,436,423,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(437,7847,437,424,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (438,7847,438,425,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(439,7847,439,426,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(440,7847,440,427,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(441,7847,441,428,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(442,7847,442,429,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(443,7847,443,430,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(444,7847,444,431,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(445,7847,445,432,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(446,7847,446,433,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(447,7847,447,434,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(448,7847,448,435,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(449,7847,449,436,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(450,7847,450,437,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(451,7847,451,438,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(452,7847,452,439,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(453,7847,453,440,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(454,7847,454,441,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(455,7847,455,442,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(456,7847,456,443,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(457,7847,457,444,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(458,7847,458,445,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(459,7847,459,446,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(460,7847,460,447,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(461,7847,461,448,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(462,7847,462,449,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(463,7847,463,450,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(464,7847,464,451,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(465,7847,465,452,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(466,7847,466,453,NULL,'2023-02-22 13:21:18','2023-02-22 13:21:18',NULL),(467,7847,467,454,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(468,7847,468,455,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(469,7847,469,456,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(470,7847,470,457,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(471,7847,471,458,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(472,7847,472,459,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(473,7847,473,460,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(474,7847,474,461,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(475,7847,475,462,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(476,7847,476,463,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(477,7847,477,464,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(478,7847,478,465,NULL,'2023-02-22 13:21:19','2023-02-22 13:21:19',NULL),(479,7847,479,466,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(480,7847,480,467,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(481,7847,481,468,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(482,7847,482,469,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(483,7847,483,470,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(484,7847,484,471,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(485,7847,485,472,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(486,7847,486,473,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(487,7847,487,474,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(488,7847,488,475,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(489,7847,489,476,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(490,7847,490,477,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(491,7847,491,478,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (492,7847,492,479,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(493,7847,493,480,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(494,7847,494,481,NULL,'2023-02-22 13:21:33','2023-02-22 13:21:33',NULL),(495,7847,495,482,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(496,7847,496,483,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(497,7847,497,484,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(498,7847,498,485,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(499,7847,499,486,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(500,7847,500,487,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(501,7847,501,488,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(502,7847,502,489,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(503,7847,503,490,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(504,7847,504,491,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(505,7847,505,492,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(506,7847,506,493,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(507,7847,507,494,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(508,7847,508,495,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(509,7847,509,496,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(510,7847,510,497,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(511,7847,511,498,NULL,'2023-02-22 13:21:34','2023-02-22 13:21:34',NULL),(512,7847,512,499,NULL,'2023-02-22 13:21:35','2023-02-22 13:21:35',NULL),(513,7847,513,500,NULL,'2023-02-22 13:21:35','2023-02-22 13:21:35',NULL),(514,7847,514,501,NULL,'2023-02-22 13:21:35','2023-02-22 13:21:35',NULL),(515,7847,515,502,NULL,'2023-02-22 13:21:35','2023-02-22 13:21:35',NULL),(516,7847,516,503,NULL,'2023-02-22 13:21:35','2023-02-22 13:46:29','2023-02-22 13:46:29'),(517,7847,517,504,NULL,'2023-02-22 13:21:35','2023-02-22 13:21:35',NULL),(518,7847,518,503,NULL,'2023-02-22 13:46:29','2023-02-22 13:46:29',NULL),(519,7847,519,505,NULL,'2023-02-24 10:46:11','2023-02-24 10:46:11',NULL),(520,7847,520,506,NULL,'2023-02-24 10:46:12','2023-02-24 10:46:12',NULL),(521,7847,521,507,NULL,'2023-02-24 10:46:12','2023-02-24 10:46:12',NULL),(522,7847,522,508,NULL,'2023-02-24 10:46:12','2023-02-24 10:46:12',NULL),(523,7847,523,509,NULL,'2023-02-24 10:46:12','2023-02-24 10:46:12',NULL),(524,7847,524,510,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(525,7847,525,511,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(526,7847,526,512,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(527,7847,527,513,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(528,7847,528,514,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(529,7847,529,515,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(530,7847,530,516,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(531,7847,531,517,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(532,7847,532,518,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(533,7847,533,519,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(534,7847,534,520,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(535,7847,535,521,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(536,7847,536,522,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(537,7847,537,523,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(538,7847,538,524,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(539,7847,539,525,NULL,'2023-02-24 11:46:23','2023-02-24 11:46:23',NULL),(540,7847,540,526,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(541,7847,541,527,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(542,7847,542,528,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(543,7847,543,529,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(544,7847,544,530,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(545,7847,545,531,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (546,7847,546,532,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(547,7847,547,533,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(548,7847,548,534,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(549,7847,549,535,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(550,7847,550,536,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(551,7847,551,537,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(552,7847,552,538,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(553,7847,553,539,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(554,7847,554,540,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(555,7847,555,541,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(556,7847,556,542,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(557,7847,557,543,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(558,7847,558,544,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(559,7847,559,545,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(560,7847,560,546,NULL,'2023-02-24 11:46:24','2023-02-24 11:46:24',NULL),(561,7847,561,547,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(562,7847,562,548,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(563,7847,563,549,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(564,7847,564,550,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(565,7847,565,551,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(566,7847,566,552,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(567,7847,567,553,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(568,7847,568,554,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(569,7847,569,555,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(570,7847,570,556,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(571,7847,571,557,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(572,7847,572,558,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(573,7847,573,559,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(574,7847,574,560,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(575,7847,575,561,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(576,7847,576,562,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(577,7847,577,563,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(578,7847,578,564,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(579,7847,579,565,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(580,7847,580,566,NULL,'2023-02-24 11:46:25','2023-02-24 11:46:25',NULL),(581,7847,581,567,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(582,7847,582,568,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(583,7847,583,569,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(584,7847,584,570,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(585,7847,585,571,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(586,7847,586,572,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(587,7847,587,573,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(588,7847,588,574,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(589,7847,589,575,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(590,7847,590,576,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(591,7847,591,577,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(592,7847,592,578,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(593,7847,593,579,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(594,7847,594,580,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(595,7847,595,581,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(596,7847,596,582,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(597,7847,597,583,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(598,7847,598,584,NULL,'2023-02-24 11:46:26','2023-02-24 11:46:26',NULL),(599,7847,599,585,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (600,7847,600,586,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(601,7847,601,587,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(602,7847,602,588,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(603,7847,603,589,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(604,7847,604,590,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(605,7847,605,591,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(606,7847,606,592,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(607,7847,607,593,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(608,7847,608,594,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(609,7847,609,595,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(610,7847,610,596,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(611,7847,611,597,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(612,7847,612,598,NULL,'2023-02-24 11:46:27','2023-02-24 11:46:27',NULL),(613,7847,613,599,NULL,'2023-02-24 11:52:47','2023-02-24 11:52:47',NULL),(614,7847,614,600,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(615,7847,615,601,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(616,7847,616,602,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(617,7847,617,603,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(618,7847,618,604,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(619,7847,619,605,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(620,7847,620,606,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(621,7847,621,607,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(622,7847,622,608,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(623,7847,623,609,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(624,7847,624,610,NULL,'2023-02-24 11:52:48','2023-02-24 11:52:48',NULL),(625,7847,625,611,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(626,7847,626,612,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(627,7847,627,613,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(628,7847,628,614,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(629,7847,629,615,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(630,7847,630,616,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(631,7847,631,617,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(632,7847,632,618,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(633,7847,633,619,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(634,7847,634,620,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(635,7847,635,621,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(636,7847,636,622,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(637,7847,637,623,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(638,7847,638,624,NULL,'2023-02-24 11:52:49','2023-02-24 11:52:49',NULL),(639,7847,639,625,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(640,7847,640,626,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(641,7847,641,627,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(642,7847,642,628,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(643,7847,643,629,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(644,7847,644,630,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(645,7847,645,631,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(646,7847,646,632,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(647,7847,647,633,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(648,7847,648,634,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(649,7847,649,635,NULL,'2023-02-24 11:52:50','2023-02-24 11:52:50',NULL),(650,7847,650,636,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(651,7847,651,637,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(652,7847,652,638,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(653,7847,653,639,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (654,7847,654,640,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(655,7847,655,641,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(656,7847,656,642,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(657,7847,657,643,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(658,7847,658,644,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(659,7847,659,645,NULL,'2023-02-24 11:52:51','2023-02-24 11:52:51',NULL),(660,7847,660,646,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(661,7847,661,647,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(662,7847,662,648,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(663,7847,663,649,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(664,7847,664,650,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(665,7847,665,651,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(666,7847,666,652,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(667,7847,667,653,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(668,7847,668,654,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(669,7847,669,655,NULL,'2023-02-24 11:52:52','2023-02-24 11:52:52',NULL),(670,7847,670,656,NULL,'2023-02-24 11:52:53','2023-02-24 11:52:53',NULL),(671,7847,671,657,NULL,'2023-02-24 11:52:53','2023-02-24 11:52:53',NULL),(672,7847,672,658,NULL,'2023-02-24 11:52:53','2023-02-24 11:52:53',NULL),(673,7847,673,659,NULL,'2023-02-24 11:52:53','2023-02-24 11:52:53',NULL),(674,7847,674,660,NULL,'2023-02-24 11:52:53','2023-02-24 11:52:53',NULL),(675,7847,675,661,NULL,'2023-02-24 11:52:53','2023-02-24 11:52:53',NULL),(676,7847,676,662,NULL,'2023-03-28 10:43:34','2023-03-28 10:43:34',NULL),(677,7847,677,663,NULL,'2023-03-28 10:43:34','2023-03-28 10:43:34',NULL),(678,7847,678,664,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(679,7847,679,665,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(680,7847,680,666,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(681,7847,681,667,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(682,7847,682,668,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(683,7847,683,669,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(684,7847,684,670,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(685,7847,685,671,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(686,7847,686,672,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL),(687,7847,687,673,NULL,'2023-03-28 10:44:34','2023-03-28 10:44:34',NULL);
/*!40000 ALTER TABLE `cta_cte_cliente_pivot_receipt` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL,
  `fecha` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(9,2) NOT NULL DEFAULT '1.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `ticket_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_tesoreria_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_period_id_foreign` (`period_id`),
  KEY `cta_cte_tesoreria_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `cta_cte_tesoreria_moneda_id_foreign` (`moneda_id`),
  KEY `cta_cte_tesoreria_ticket_id_foreign` (`ticket_id`),
  CONSTRAINT `cta_cte_tesoreria_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `cta_cte_tesoreria_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_tesoreria_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_ticket_id_foreign` FOREIGN KEY (`ticket_id`) REFERENCES `tickets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria`
--

LOCK TABLES `cta_cte_tesoreria` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_banco_cheq`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_banco_cheq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_banco_cheq` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_banco_id` int(10) unsigned NOT NULL,
  `chequera_tipo_id` int(10) unsigned NOT NULL,
  `serie` text COLLATE utf8mb4_unicode_ci,
  `numero_cheque` int(11) DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_banco_cheq_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_banco_id_foreign` (`cta_cte_tesoreria_banco_id`),
  KEY `cta_cte_tesoreria_banco_cheq_chequera_tipo_id_foreign` (`chequera_tipo_id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_chequera_tipo_id_foreign` FOREIGN KEY (`chequera_tipo_id`) REFERENCES `chequeras_tipos` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_banco_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_banco_id`) REFERENCES `cta_cte_tesoreria_bancos` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_banco_cheq`
--

LOCK TABLES `cta_cte_tesoreria_banco_cheq` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_cheq` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_cheq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_banco_claves`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_banco_claves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_banco_claves` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_banco_id` int(10) unsigned NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_banco_claves_person_id_foreign` (`person_id`),
  KEY `ct_cuenta_id` (`cta_cte_tesoreria_cuenta_id`),
  KEY `ct_banco_id` (`cta_cte_tesoreria_banco_id`),
  CONSTRAINT `ct_banco_id` FOREIGN KEY (`cta_cte_tesoreria_banco_id`) REFERENCES `cta_cte_tesoreria_bancos` (`id`),
  CONSTRAINT `ct_cuenta_id` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_claves_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_banco_claves`
--

LOCK TABLES `cta_cte_tesoreria_banco_claves` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_claves` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_claves` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_bancos`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_bancos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_bancos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `ctacte_banco_id` int(10) unsigned NOT NULL,
  `persona_empresa` int(11) NOT NULL DEFAULT '1',
  `zone_id` int(10) unsigned NOT NULL,
  `cuenta_contable_id` int(10) unsigned NOT NULL,
  `cuenta_contable_id_diferido` int(10) unsigned DEFAULT NULL,
  `cuenta_contable_id_pend_acred` int(10) unsigned DEFAULT NULL,
  `numero_cuenta` text COLLATE utf8mb4_unicode_ci,
  `cbu` text COLLATE utf8mb4_unicode_ci,
  `alias` text COLLATE utf8mb4_unicode_ci,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_bancos_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_bancos_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_bancos_ctacte_banco_id_foreign` (`ctacte_banco_id`),
  KEY `cta_cte_tesoreria_bancos_zone_id_foreign` (`zone_id`),
  KEY `cta_cte_tesoreria_bancos_cuenta_contable_id_foreign` (`cuenta_contable_id`),
  KEY `cta_cte_tesoreria_bancos_cuenta_contable_id_diferido_foreign` (`cuenta_contable_id_diferido`),
  KEY `cta_cte_tesoreria_bancos_cuenta_contable_id_pend_acred_foreign` (`cuenta_contable_id_pend_acred`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_ctacte_banco_id_foreign` FOREIGN KEY (`ctacte_banco_id`) REFERENCES `ctacte_bancos` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cuenta_contable_id_diferido_foreign` FOREIGN KEY (`cuenta_contable_id_diferido`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cuenta_contable_id_foreign` FOREIGN KEY (`cuenta_contable_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cuenta_contable_id_pend_acred_foreign` FOREIGN KEY (`cuenta_contable_id_pend_acred`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_zone_id_foreign` FOREIGN KEY (`zone_id`) REFERENCES `zones` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_bancos`
--

LOCK TABLES `cta_cte_tesoreria_bancos` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_bancos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_bancos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_cuenta_tipos`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_cuenta_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_cuenta_tipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_cuenta_tipos`
--

LOCK TABLES `cta_cte_tesoreria_cuenta_tipos` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuenta_tipos` DISABLE KEYS */;
INSERT INTO `cta_cte_tesoreria_cuenta_tipos` VALUES (1,NULL,'CAJA',1,NULL,NULL,NULL),(2,NULL,'BANCOS',1,NULL,NULL,NULL),(3,NULL,'CHEQUES',1,NULL,NULL,NULL),(4,NULL,'RETENCIONES',1,NULL,NULL,NULL),(5,NULL,'PERCEPCIONES',1,NULL,NULL,NULL),(6,NULL,'RESULTADO NEGATIVO',1,NULL,NULL,NULL),(7,NULL,'RESULTADO POSITIVO',1,NULL,NULL,NULL),(8,NULL,'MOVIMIENTO',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuenta_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_cuentas`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_cuentas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_cuentas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_tipo_id` int(10) unsigned NOT NULL DEFAULT '8',
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cuit` text COLLATE utf8mb4_unicode_ci,
  `cheque3ros` tinyint(1) NOT NULL DEFAULT '0',
  `cheque_emitidos` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cta_cte` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_origen` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_destino` tinyint(1) NOT NULL DEFAULT '0',
  `conta_asientos` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_cuentas_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_cuentas_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `cta_tes_tipo_id_foreign` (`cta_cte_tesoreria_cuenta_tipo_id`),
  KEY `cta_cte_tesoreria_cuentas_moneda_id_foreign` (`moneda_id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_tes_tipo_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_tipo_id`) REFERENCES `cta_cte_tesoreria_cuenta_tipos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=757 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_cuentas`
--

LOCK TABLES `cta_cte_tesoreria_cuentas` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuentas` DISABLE KEYS */;
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (13,NULL,1,13,NULL,8,'Clientes - Deudores',NULL,0,0,0,0,0,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(20,NULL,1,20,NULL,8,'Anticipos Impuesto a las Ganancias',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(23,NULL,1,23,NULL,4,'Retenciones Impuesto a las Ganancias',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:11:42',NULL),(25,NULL,1,25,NULL,4,'Retenciones de IVA',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:11:42',NULL),(57,NULL,1,57,NULL,8,'Proveedores en Cta. Cte. locales',NULL,0,0,0,0,0,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(60,NULL,1,60,NULL,3,'Cheques emitidos ',NULL,0,1,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:11:42',NULL),(62,NULL,1,62,NULL,8,'Sueldos y Jornales a pagar',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(140,NULL,1,140,NULL,6,'Intereses y Gastos bancarios',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:11:42',NULL),(162,NULL,1,162,NULL,4,'Retenciones SUSS',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:11:42',NULL),(176,NULL,1,176,NULL,3,'Cheques en Cartera',NULL,1,0,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:11:42',NULL),(201,NULL,1,201,NULL,6,'Monotributo',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:11:42',NULL),(203,NULL,1,203,NULL,6,'Autonomos',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:11:42',NULL),(219,NULL,1,219,NULL,8,'Pagos AFIP',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(251,NULL,1,251,NULL,4,'Retenciones de IIBB Buenos Aires',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:11:42',NULL),(252,NULL,1,252,NULL,4,'Retenciones de IIBB Capital Federal',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:11:42',NULL),(253,NULL,1,253,NULL,4,'Retenciones de IIBB Catamarca',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:11:42',NULL),(254,NULL,1,254,NULL,4,'Retenciones de IIBB Chaco',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:11:42',NULL),(255,NULL,1,255,NULL,4,'Retenciones de IIBB Chubut',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:11:42',NULL),(256,NULL,1,256,NULL,4,'Retenciones de IIBB Córdoba',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:11:42',NULL),(257,NULL,1,257,NULL,4,'Retenciones de IIBB Corrientes',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:11:42',NULL),(258,NULL,1,258,NULL,4,'Retenciones de IIBB Entre Ríos',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:11:42',NULL),(259,NULL,1,259,NULL,4,'Retenciones de IIBB Formosa',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:11:42',NULL),(260,NULL,1,260,NULL,4,'Retenciones de IIBB Jujuy',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:11:42',NULL),(261,NULL,1,261,NULL,4,'Retenciones de IIBB La Pampa',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:11:42',NULL),(262,NULL,1,262,NULL,4,'Retenciones de IIBB La Rioja',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:11:42',NULL),(263,NULL,1,263,NULL,4,'Retenciones de IIBB Mendoza',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:11:42',NULL),(264,NULL,1,264,NULL,4,'Retenciones de IIBB Misiones',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:11:42',NULL),(265,NULL,1,265,NULL,4,'Retenciones de IIBB Neuquén',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:11:42',NULL),(266,NULL,1,266,NULL,4,'Retenciones de IIBB Pascua Lama',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:11:42',NULL),(267,NULL,1,267,NULL,4,'Retenciones de IIBB Río Negro',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:11:42',NULL),(268,NULL,1,268,NULL,4,'Retenciones de IIBB Salta',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:11:42',NULL),(269,NULL,1,269,NULL,4,'Retenciones de IIBB San Juan',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:11:42',NULL),(270,NULL,1,270,NULL,4,'Retenciones de IIBB San Luis',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:11:42',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (271,NULL,1,271,NULL,4,'Retenciones de IIBB Santa Cruz',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:11:42',NULL),(272,NULL,1,272,NULL,4,'Retenciones de IIBB Santa Fe',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:11:42',NULL),(273,NULL,1,273,NULL,4,'Retenciones de IIBB Santiago del Estero',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:11:42',NULL),(274,NULL,1,274,NULL,4,'Retenciones de IIBB Tierra del Fuego',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:11:42',NULL),(275,NULL,1,275,NULL,4,'Retenciones de IIBB Tucuman',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:11:42',NULL),(351,NULL,1,351,NULL,8,'BANCO SIRCREB',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(359,NULL,1,359,NULL,8,'Caja en Pesos',NULL,0,0,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-20 23:14:46','2023-03-20 23:14:46'),(360,NULL,1,360,NULL,8,'Retenciones Bancarias de Ganancias a Favor',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(364,NULL,1,364,NULL,8,'Anticipo de Clientes',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(384,NULL,1,384,NULL,8,'Caja en Dolares',NULL,0,0,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-20 23:14:46','2023-03-20 23:14:46'),(409,NULL,1,409,NULL,6,'IVA Crédito Fiscal No computable',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:11:42',NULL),(418,NULL,1,418,NULL,8,'Deudas Bancarias',NULL,0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(433,NULL,1,433,NULL,8,'Préstamo',NULL,0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(441,NULL,1,441,NULL,8,'Leasing',NULL,0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(448,NULL,1,448,NULL,8,'Planes de Pagos AFIP',NULL,0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(450,NULL,1,450,NULL,3,'Cheques Rechazados',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:11:42',NULL),(467,NULL,1,467,NULL,6,'Interés',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:11:42',NULL),(468,NULL,1,14,NULL,8,'Deudores por ventas comunes',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(469,NULL,1,15,NULL,8,'Deudores por ventas morosos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(470,NULL,1,16,NULL,8,'Deudores en gestión judicial',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(471,NULL,1,17,NULL,8,'Previsión deudores incobrables',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(472,NULL,1,22,NULL,8,'Anticipo Impto.Ganancia Mínima Presunta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(473,NULL,1,24,NULL,4,'Impuesto a las Ganancias (Saldo a favor)',NULL,0,0,0,0,0,1,0,'2020-02-06 17:23:07','2023-06-02 07:55:11',NULL),(474,NULL,1,27,NULL,8,'Anticipos de proveedores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(475,NULL,1,28,NULL,8,'Depósito en garantía alquileres',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(476,NULL,1,29,NULL,8,'Derechos adquiridos a devengar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(477,NULL,1,30,NULL,8,'Intereses a devengar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(478,NULL,1,31,NULL,8,'Cuentas a rendir - Directores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(479,NULL,1,32,NULL,8,'Alquileres no devengados',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(480,NULL,1,38,NULL,8,'Equipos de computación valores históricos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(481,NULL,1,39,NULL,8,'Equipos de computación ajuste',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(482,NULL,1,40,NULL,8,'Amortización Acumulada Equipos de comput.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (483,NULL,1,42,NULL,8,'Instalaciones valores históricos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(484,NULL,1,43,NULL,8,'Instalaciones ajuste',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(485,NULL,1,44,NULL,8,'Amortización Acumulada Instalaciones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(486,NULL,1,46,NULL,8,'Muebles y utiles valores históricos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(487,NULL,1,47,NULL,8,'Muebles y utiles ajuste',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(488,NULL,1,48,NULL,8,'Amortización Acumulada Muebles y Útiles',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(489,NULL,1,50,NULL,8,'Gastos de organización valores historicos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(490,NULL,1,51,NULL,8,'Gastos de organización ajuste',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(491,NULL,1,52,NULL,8,'Amortización acumulada gs. de organización',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(492,NULL,1,58,NULL,8,'Proveedores en cta. cte. exterior',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(493,NULL,1,59,NULL,8,'Derechos de exhibición a devengar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(494,NULL,1,63,NULL,8,'Cargas sociales a pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(495,NULL,1,64,NULL,8,'Sindicatos a Pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(496,NULL,1,67,NULL,8,'IVA Debito Fiscal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(497,NULL,1,68,NULL,8,'IVA Credito Fiscal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(498,NULL,1,69,NULL,8,'Impuestos Internos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(499,NULL,1,70,NULL,8,'Impuestos al Combustible',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(500,NULL,1,71,NULL,8,'IVA Retenciones de terceros',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(501,NULL,1,72,NULL,5,'IVA Percepciones realiz.por terceros',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(502,NULL,1,73,NULL,8,'IVA Saldo a favor',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(503,NULL,1,74,NULL,8,'IVA a pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(504,NULL,1,75,NULL,5,'Percepciones Ingresos Brutos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(505,NULL,1,76,NULL,8,'Otros Pagos AFIP',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(506,NULL,1,78,NULL,8,'Impuesto a los Ingresos Brutos Pasivo',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(507,NULL,1,79,NULL,8,'Impuesto a las Ganancias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(508,NULL,1,80,NULL,8,'Impuesto a la Ganancia Mínima Presunta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(509,NULL,1,81,NULL,8,'AFIP - Retenciones Impuesto a las Ganancias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(510,NULL,1,82,NULL,8,'AFIP - Plan de Facilidades Decreto 338/02',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(511,NULL,1,87,NULL,8,'Acciones en circulación',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(512,NULL,1,88,NULL,8,'Ajuste del Capital',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(513,NULL,1,89,NULL,8,'Aportes Irrevocables Futuras Suscripciones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(514,NULL,1,91,NULL,8,'Resultado del ejercicio',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (515,NULL,1,92,NULL,8,'Resultado ejercicios anteriores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(516,NULL,1,93,NULL,8,'A.R.E.A.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(517,NULL,1,96,NULL,7,'VENTAS',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(518,NULL,1,97,NULL,7,'Honorarios',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(519,NULL,1,99,NULL,7,'Descuentos obtenidos',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(520,NULL,1,100,NULL,7,'Reintegros por exportaciones',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(521,NULL,1,102,NULL,7,'Intereses Cobrados',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(522,NULL,1,103,NULL,7,'Diferencias de cambio',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(523,NULL,1,104,NULL,7,'Descuentos obtenidos',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(524,NULL,1,110,NULL,6,'Sueldos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(525,NULL,1,111,NULL,6,'Contribuciones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(526,NULL,1,112,NULL,6,'Sindicato',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(527,NULL,1,114,NULL,8,'ACA',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(528,NULL,1,115,NULL,6,'Aereos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(529,NULL,1,116,NULL,6,'Alquiler',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(530,NULL,1,117,NULL,8,'AGUA AYSA',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(531,NULL,1,118,NULL,8,'TV Cablevision',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(532,NULL,1,119,NULL,1,'Caja Jubilacion Consejo',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(533,NULL,1,120,NULL,6,'Celulares',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(534,NULL,1,121,NULL,3,'Cheques',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(535,NULL,1,123,NULL,8,'Comida',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(536,NULL,1,126,NULL,6,'Fletes y acarreos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(537,NULL,1,127,NULL,8,'Luz Edesur',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(538,NULL,1,128,NULL,6,'Movilidad y Viáticos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(539,NULL,1,129,NULL,8,'Mantenimiento',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(540,NULL,1,130,NULL,8,'IVA No Computable',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(541,NULL,1,131,NULL,8,'Entretenimiento',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(542,NULL,1,132,NULL,6,'Amortización Bienes de Uso',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(543,NULL,1,135,NULL,6,'Gastos varios',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(544,NULL,1,136,NULL,6,'Ajuste por redondeo',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(545,NULL,1,137,NULL,6,'Deudores Incobrables',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(546,NULL,1,141,NULL,6,'Intereses Proveedores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(547,NULL,1,143,NULL,6,'Diferencias de cambio',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(548,NULL,1,144,NULL,8,'Diferencia de Cambio Bces. en M.Extranjera',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(549,NULL,1,145,NULL,6,'Diferencia tipo cambio Vendedor/Comprador',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (550,NULL,1,146,NULL,8,'Diferencia por conversion en Bce. en Mon. Extranj.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(551,NULL,1,147,NULL,8,'Diferencia de cambio CMV',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(552,NULL,1,148,NULL,8,'Diferencia de cambio PT',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(553,NULL,1,149,NULL,8,'Resultado por Exposición a la Inflación',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(554,NULL,1,150,NULL,8,'Diferencia de cambio PE',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(555,NULL,1,151,NULL,8,'Diferencia de cambio Ds.Vtas.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(556,NULL,1,152,NULL,6,'Diferencia de cambio ME',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(557,NULL,1,153,NULL,6,'Descuentos otorgados',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(558,NULL,1,155,NULL,6,'Impuesto a las Ganancias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(559,NULL,1,156,NULL,6,'Impuesto a los Ingresos Brutos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(560,NULL,1,157,NULL,6,'Impuesto al Debito y Credito Bancario',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(561,NULL,1,159,NULL,6,'Pérdida por venta bienes de uso',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(562,NULL,1,160,NULL,6,'Inversiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(563,NULL,1,161,NULL,6,'Amortizaciones extraordinarias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(564,NULL,1,178,NULL,8,'Google',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(565,NULL,1,188,NULL,6,'Publicidad',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(566,NULL,1,191,NULL,6,'Cargas Sociales',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(567,NULL,1,192,NULL,6,'Honorarios',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(568,NULL,1,193,NULL,6,'Telefono Fijo',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(569,NULL,1,198,NULL,6,'Seguros',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(570,NULL,1,199,NULL,6,'Internet',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(571,NULL,1,204,NULL,6,'Multas Impositivas',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(572,NULL,1,208,NULL,6,'Impuesto a los Ingresos Brutos - BS AS',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(573,NULL,1,209,NULL,6,'SIRCREB',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(574,NULL,1,212,NULL,6,'Tarjeta Visa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(575,NULL,1,213,NULL,6,'Tarjeta American Express',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(576,NULL,1,214,NULL,6,'Tarjeta Mastercard',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(577,NULL,1,215,NULL,8,'Tarjeta Shopping',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(578,NULL,1,216,NULL,6,'Tarjeta Cencosud',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(579,NULL,1,217,NULL,6,'Compras',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(580,NULL,1,218,NULL,7,'Ventas No Gravadas',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(581,NULL,1,220,NULL,5,'Perc IVA -RG3337',NULL,0,0,0,0,0,1,0,'2020-02-06 17:23:07','2023-06-02 07:55:11',NULL),(582,NULL,1,221,NULL,6,'Imps. Internos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(583,NULL,1,222,NULL,6,'Imp. Gasoil',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (584,NULL,1,223,NULL,6,'Imp. Hídricos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(585,NULL,1,224,NULL,6,'ITC',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(586,NULL,1,225,NULL,5,'Perc IIBB  Buenos Aires',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(587,NULL,1,226,NULL,5,'Perc IIBB  Capital Federal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(588,NULL,1,227,NULL,5,'Perc IIBB  Catamarca',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(589,NULL,1,228,NULL,5,'Perc IIBB  Chaco',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(590,NULL,1,229,NULL,5,'Perc IIBB  Chubut',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(591,NULL,1,230,NULL,5,'Perc IIBB  Córdoba',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(592,NULL,1,231,NULL,5,'Perc IIBB  Corrientes',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(593,NULL,1,232,NULL,5,'Perc IIBB  Entre Ríos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(594,NULL,1,233,NULL,5,'Perc IIBB  Formosa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(595,NULL,1,234,NULL,5,'Perc IIBB  Jujuy',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(596,NULL,1,235,NULL,5,'Perc IIBB  La Pampa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(597,NULL,1,236,NULL,5,'Perc IIBB  La Rioja',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(598,NULL,1,237,NULL,5,'Perc IIBB  Mendoza',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(599,NULL,1,238,NULL,5,'Perc IIBB  Misiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(600,NULL,1,239,NULL,5,'Perc IIBB  Neuquén',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(601,NULL,1,240,NULL,5,'Perc IIBB  Pascua Lama',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(602,NULL,1,241,NULL,5,'Perc IIBB  Río Negro',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(603,NULL,1,242,NULL,5,'Perc IIBB  Salta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(604,NULL,1,243,NULL,5,'Perc IIBB  San Juan',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(605,NULL,1,244,NULL,5,'Perc IIBB  San Luis',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(606,NULL,1,245,NULL,5,'Perc IIBB  Santa Cruz',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(607,NULL,1,246,NULL,5,'Perc IIBB  Santa Fe',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(608,NULL,1,247,NULL,5,'Perc IIBB  Santiago del Estero',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(609,NULL,1,248,NULL,5,'Perc IIBB  Tierra del Fuego',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(610,NULL,1,249,NULL,5,'Perc IIBB  Tucuman',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:42',NULL),(611,NULL,1,250,NULL,6,'Compras No Gravadas',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL),(612,NULL,1,276,NULL,6,'SIRCREB Buenos Aires',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL),(613,NULL,1,277,NULL,6,'SIRCREB Capital Federal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL),(614,NULL,1,278,NULL,6,'SIRCREB Catamarca',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL),(615,NULL,1,279,NULL,6,'SIRCREB Chaco',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL),(616,NULL,1,280,NULL,6,'SIRCREB Chubut',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL),(617,NULL,1,281,NULL,6,'SIRCREB Córdoba',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL),(618,NULL,1,282,NULL,6,'SIRCREB Corrientes',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (619,NULL,1,283,NULL,6,'SIRCREB Entre Ríos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL),(620,NULL,1,284,NULL,6,'SIRCREB Formosa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL),(621,NULL,1,285,NULL,6,'SIRCREB Jujuy',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL),(622,NULL,1,286,NULL,6,'SIRCREB La Pampa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL),(623,NULL,1,287,NULL,6,'SIRCREB La Rioja',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL),(624,NULL,1,288,NULL,6,'SIRCREB Mendoza',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL),(625,NULL,1,289,NULL,6,'SIRCREB Misiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL),(626,NULL,1,290,NULL,6,'SIRCREB Neuquén',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL),(627,NULL,1,291,NULL,6,'SIRCREB Pascua Lama',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL),(628,NULL,1,292,NULL,6,'SIRCREB Río Negro',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL),(629,NULL,1,293,NULL,6,'SIRCREB Salta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL),(630,NULL,1,294,NULL,6,'SIRCREB San Juan',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL),(631,NULL,1,295,NULL,6,'SIRCREB San Luis',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL),(632,NULL,1,296,NULL,6,'SIRCREB Santa Cruz',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL),(633,NULL,1,297,NULL,6,'SIRCREB Santa Fe',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL),(634,NULL,1,298,NULL,6,'SIRCREB Santiago del Estero',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL),(635,NULL,1,299,NULL,6,'SIRCREB Tierra del Fuego',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL),(636,NULL,1,300,NULL,6,'SIRCREB Tucuman',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL),(637,NULL,1,301,NULL,8,'IIBB a Favor Buenos Aires',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL),(638,NULL,1,302,NULL,8,'IIBB a Favor Capital Federal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL),(639,NULL,1,303,NULL,8,'IIBB a Favor Catamarca',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL),(640,NULL,1,304,NULL,8,'IIBB a Favor Chaco',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL),(641,NULL,1,305,NULL,8,'IIBB a Favor Chubut',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL),(642,NULL,1,306,NULL,8,'IIBB a Favor Córdoba',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL),(643,NULL,1,307,NULL,8,'IIBB a Favor Corrientes',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL),(644,NULL,1,308,NULL,8,'IIBB a Favor Entre Ríos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL),(645,NULL,1,309,NULL,8,'IIBB a Favor Formosa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL),(646,NULL,1,310,NULL,8,'IIBB a Favor Jujuy',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL),(647,NULL,1,311,NULL,8,'IIBB a Favor La Pampa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL),(648,NULL,1,312,NULL,8,'IIBB a Favor La Rioja',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL),(649,NULL,1,313,NULL,8,'IIBB a Favor Mendoza',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:11:43',NULL),(650,NULL,1,314,NULL,8,'IIBB a Favor Misiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(651,NULL,1,315,NULL,8,'IIBB a Favor Neuquén',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(652,NULL,1,316,NULL,8,'IIBB a Favor Pascua Lama',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(653,NULL,1,317,NULL,8,'IIBB a Favor Río Negro',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (654,NULL,1,318,NULL,8,'IIBB a Favor Salta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(655,NULL,1,319,NULL,8,'IIBB a Favor San Juan',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(656,NULL,1,320,NULL,8,'IIBB a Favor San Luis',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(657,NULL,1,321,NULL,8,'IIBB a Favor Santa Cruz',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(658,NULL,1,322,NULL,8,'IIBB a Favor Santa Fe',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(659,NULL,1,323,NULL,8,'IIBB a Favor Santiago del Estero',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(660,NULL,1,324,NULL,8,'IIBB a Favor Tierra del Fuego',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(661,NULL,1,325,NULL,8,'IIBB a Favor Tucuman',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(662,NULL,1,326,NULL,8,'IIBB a Pagar Buenos Aires',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(663,NULL,1,327,NULL,8,'IIBB a Pagar Capital Federal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(664,NULL,1,328,NULL,8,'IIBB a Pagar Catamarca',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(665,NULL,1,329,NULL,8,'IIBB a Pagar Chaco',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(666,NULL,1,330,NULL,8,'IIBB a Pagar Chubut',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(667,NULL,1,331,NULL,8,'IIBB a Pagar Córdoba',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(668,NULL,1,332,NULL,8,'IIBB a Pagar Corrientes',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(669,NULL,1,333,NULL,8,'IIBB a Pagar Entre Ríos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(670,NULL,1,334,NULL,8,'IIBB a Pagar Formosa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(671,NULL,1,335,NULL,8,'IIBB a Pagar Jujuy',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(672,NULL,1,336,NULL,8,'IIBB a Pagar La Pampa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(673,NULL,1,337,NULL,8,'IIBB a Pagar La Rioja',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(674,NULL,1,338,NULL,8,'IIBB a Pagar Mendoza',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(675,NULL,1,339,NULL,8,'IIBB a Pagar Misiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(676,NULL,1,340,NULL,8,'IIBB a Pagar Neuquén',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(677,NULL,1,341,NULL,8,'IIBB a Pagar Pascua Lama',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(678,NULL,1,342,NULL,8,'IIBB a Pagar Río Negro',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(679,NULL,1,343,NULL,8,'IIBB a Pagar Salta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(680,NULL,1,344,NULL,8,'IIBB a Pagar San Juan',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(681,NULL,1,345,NULL,8,'IIBB a Pagar San Luis',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(682,NULL,1,346,NULL,8,'IIBB a Pagar Santa Cruz',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(683,NULL,1,347,NULL,8,'IIBB a Pagar Santa Fe',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(684,NULL,1,348,NULL,8,'IIBB a Pagar Santiago del Estero',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(685,NULL,1,349,NULL,8,'IIBB a Pagar Tierra del Fuego',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(686,NULL,1,350,NULL,8,'IIBB a Pagar Tucuman',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(687,NULL,1,352,NULL,8,'Compensacion',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (688,NULL,1,353,NULL,8,'IVA Saldo Tecnico',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(689,NULL,1,354,NULL,8,'IVA Saldo Libre Disponibilidad',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(690,NULL,1,361,NULL,8,'Equipos de Computación',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(691,NULL,1,362,NULL,8,'Computadoras',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(692,NULL,1,363,NULL,8,'Muebles y Utiles',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(693,NULL,1,365,NULL,8,'Provision Honorarios',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(694,NULL,1,366,NULL,8,'Cta. Cte Directores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(695,NULL,1,367,NULL,8,'Provisión Honorarios Directores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(696,NULL,1,368,NULL,8,'Cuenta Particular Socio 1',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(697,NULL,1,369,NULL,8,'Capital',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(698,NULL,1,380,NULL,8,'Instalaciones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(699,NULL,1,381,NULL,8,'Reserva Legal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(700,NULL,1,382,NULL,8,'Reserva Legal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(701,NULL,1,383,NULL,8,'Resultado no asignado',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(702,NULL,1,386,NULL,8,'PLAZO FIJO',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(703,NULL,1,388,NULL,8,'ACCIONES',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(704,NULL,1,389,NULL,8,'Inmuebles',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(705,NULL,1,390,NULL,8,'Vehiculos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(706,NULL,1,391,NULL,8,'Maquinarias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(707,NULL,1,392,NULL,8,'MERCADERIAS',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(708,NULL,1,393,NULL,8,'OTROS',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(709,NULL,1,395,NULL,8,'Cuenta Particular Socio 2',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(710,NULL,1,396,NULL,6,'Comisiones Y gastos Bancarios',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(711,NULL,1,411,NULL,8,'Provisión Impuesto a las Ganancias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(712,NULL,1,412,NULL,6,'Amortización Muebles y Útiles',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(713,NULL,1,413,NULL,6,'Amortización Equipos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(714,NULL,1,414,NULL,8,'Amortizacion Acumulada Equipos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(715,NULL,1,415,NULL,8,'Amortización Acumulada Maquinarias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(716,NULL,1,416,NULL,8,'Materias Primas',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(717,NULL,1,419,NULL,8,'Rodados',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(718,NULL,1,420,NULL,8,'Amortización Acumulada Rodados',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(719,NULL,1,421,NULL,8,'Amortización Rodados',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(720,NULL,1,422,NULL,8,'Amortización Maquinarias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(721,NULL,1,423,NULL,8,'Accesorios',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(722,NULL,1,424,NULL,8,'Amortización Acumulada Accesorios',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (723,NULL,1,426,NULL,8,'Reserva Facultativa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(724,NULL,1,427,NULL,8,'Créditos por Impuestos Diferidos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(725,NULL,1,428,NULL,8,'Fondo de Comercio',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(726,NULL,1,429,NULL,8,'Amortizacion Acumulada Fondo de Comercio',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(727,NULL,1,430,NULL,8,'Intereses a devengar AGIP',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(728,NULL,1,431,NULL,8,'PFP IIBB',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(729,NULL,1,434,NULL,8,'Productos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(730,NULL,1,435,NULL,8,'Intereses a devengar PFP',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(731,NULL,1,437,NULL,8,'Imp. Ley 25413 Cred 0.6%',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(732,NULL,1,438,NULL,8,'Honorarios Directorio a Pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(733,NULL,1,439,NULL,8,'Reserva para Futuras Inversiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(734,NULL,1,440,NULL,8,'TEAC - Trabajos Ejecutados a Certificar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(735,NULL,1,444,NULL,8,'Banco Santander Rio Cta Cte',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(736,NULL,1,449,NULL,8,'Leasing',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(737,NULL,1,453,NULL,8,'Inversión Central Caribe',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(738,NULL,1,454,NULL,8,'Otras Inversiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(739,NULL,1,455,NULL,8,'Otros Créditos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(740,NULL,1,456,NULL,8,'Provisión Honorarios Socio Gerente',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(741,NULL,1,459,NULL,8,'Moratoria SUSS a pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(742,NULL,1,460,NULL,8,'Impuestos Municipales a Pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(743,NULL,1,461,NULL,6,'Amortización Instalaciones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(744,NULL,1,462,NULL,8,'Amortización Equipos de comput.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(745,NULL,1,463,NULL,8,'Cuenta Particular Socio 3',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(746,NULL,1,464,NULL,8,'Cuenta Particular Socio 4',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(747,NULL,1,465,NULL,8,'Otras Reservas',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(748,NULL,1,466,NULL,8,'IGMP (Saldo a Favor)',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(749,NULL,1,468,NULL,8,'Productos en Proceso',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(750,NULL,1,469,NULL,8,'Depósitos en Garantía Socio Gerente',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(751,NULL,1,470,NULL,8,'Fondos Embargados',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(752,NULL,1,471,NULL,8,'Cuota Solid.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(753,NULL,1,472,NULL,8,'Anticipo Honorarios Directores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(754,NULL,1,473,NULL,8,'SICORE a Pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(755,NULL,1,476,NULL,6,'RECPAM',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL),(756,NULL,1,478,NULL,6,'CO2 - Imp. Al Carbono',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:11:43',NULL);
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuentas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_detail`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `is_conciliado` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_detail_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `cta_cte_tesoreria_detail_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_detail_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_detail_period_id_foreign` (`period_id`),
  KEY `cta_cte_tesoreria_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `cta_cte_tesoreria_detail_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_detail`
--

LOCK TABLES `cta_cte_tesoreria_detail` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctacte_bancos`
--

DROP TABLE IF EXISTS `ctacte_bancos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctacte_bancos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `codigoBCRA` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=80 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctacte_bancos`
--

LOCK TABLES `ctacte_bancos` WRITE;
/*!40000 ALTER TABLE `ctacte_bancos` DISABLE KEYS */;
INSERT INTO `ctacte_bancos` VALUES (1,NULL,'BANCO DE GALICIA Y BUENOS AIRES S.A.',7,NULL,NULL,NULL),(2,NULL,'BANCO DE LA NACION ARGENTINA',11,NULL,NULL,NULL),(3,NULL,'BANCO DE LA PROVINCIA DE BUENOS AIRES',14,NULL,NULL,NULL),(4,NULL,'INDUSTRIAL AND COMMERCIAL BANK OF CHINA',15,NULL,NULL,NULL),(5,NULL,'CITIBANK N.A.',16,NULL,NULL,NULL),(6,NULL,'BBVA BANCO FRANCES S.A.',17,NULL,NULL,NULL),(7,NULL,'THE BANK OF TOKYO-MITSUBISHI UFJ, LTD.',18,NULL,NULL,NULL),(8,NULL,'BANCO DE LA PROVINCIA DE CORDOBA S.A.',20,NULL,NULL,NULL),(9,NULL,'BANCO SUPERVIELLE S.A.',27,NULL,NULL,NULL),(10,NULL,'BANCO DE LA CIUDAD DE BUENOS AIRES',29,NULL,NULL,NULL),(11,NULL,'BANCO PATAGONIA S.A.',34,NULL,NULL,NULL),(12,NULL,'BANCO HIPOTECARIO S.A.',44,NULL,NULL,NULL),(13,NULL,'BANCO DE SAN JUAN S.A.',45,NULL,NULL,NULL),(14,NULL,'BANCO DEL TUCUMAN S.A.',60,NULL,NULL,NULL),(15,NULL,'BANCO MUNICIPAL DE ROSARIO',65,NULL,NULL,NULL),(16,NULL,'BANCO SANTANDER RIO S.A.',72,NULL,NULL,NULL),(17,NULL,'BANCO DEL CHUBUT S.A.',83,NULL,NULL,NULL),(18,NULL,'BANCO DE SANTA CRUZ S.A.',86,NULL,NULL,NULL),(19,NULL,'BANCO DE LA PAMPA SOCIEDAD DE ECONOMÍA M',93,NULL,NULL,NULL),(20,NULL,'BANCO DE CORRIENTES S.A.',94,NULL,NULL,NULL),(21,NULL,'BANCO PROVINCIA DEL NEUQUÉN SOCIEDAD ANÓ',97,NULL,NULL,NULL),(22,NULL,'BANCO INTERFINANZAS S.A.',147,NULL,NULL,NULL),(23,NULL,'HSBC BANK ARGENTINA S.A.',150,NULL,NULL,NULL),(24,NULL,'JPMORGAN CHASE BANK, NATIONAL ASSOCIATIO',165,NULL,NULL,NULL),(25,NULL,'BANCO CREDICOOP COOPERATIVO LIMITADO',191,NULL,NULL,NULL),(26,NULL,'BANCO DE VALORES S.A.',198,NULL,NULL,NULL),(27,NULL,'BANCO ROELA S.A.',247,NULL,NULL,NULL),(28,NULL,'BANCO MARIVA S.A.',254,NULL,NULL,NULL),(29,NULL,'BANCO ITAU ARGENTINA S.A.',259,NULL,NULL,NULL),(30,NULL,'BANK OF AMERICA, NATIONAL ASSOCIATION',262,NULL,NULL,NULL),(31,NULL,'BNP PARIBAS',266,NULL,NULL,NULL),(32,NULL,'BANCO PROVINCIA DE TIERRA DEL FUEGO',268,NULL,NULL,NULL),(33,NULL,'BANCO DE LA REPUBLICA ORIENTAL DEL URUGU',269,NULL,NULL,NULL),(34,NULL,'BANCO SAENZ S.A.',277,NULL,NULL,NULL),(35,NULL,'BANCO MERIDIAN S.A.',281,NULL,NULL,NULL),(36,NULL,'BANCO MACRO S.A.',285,NULL,NULL,NULL),(37,NULL,'BANCO COMAFI SOCIEDAD ANONIMA',299,NULL,NULL,NULL),(38,NULL,'BANCO DE INVERSION Y COMERCIO EXTERIOR S',300,NULL,NULL,NULL),(39,NULL,'BANCO PIANO S.A.',301,NULL,NULL,NULL),(40,NULL,'BANCO JULIO SOCIEDAD ANONIMA',305,NULL,NULL,NULL),(41,NULL,'BANCO RIOJA SOCIEDAD ANONIMA UNIPERSONAL',309,NULL,NULL,NULL),(42,NULL,'BANCO DEL SOL S.A.',310,NULL,NULL,NULL),(43,NULL,'NUEVO BANCO DEL CHACO S. A.',311,NULL,NULL,NULL),(44,NULL,'BANCO VOII S.A.',312,NULL,NULL,NULL),(45,NULL,'BANCO DE FORMOSA S.A.',315,NULL,NULL,NULL),(46,NULL,'BANCO CMF S.A.',319,NULL,NULL,NULL),(47,NULL,'BANCO DE SANTIAGO DEL ESTERO S.A.',321,NULL,NULL,NULL),(48,NULL,'BANCO INDUSTRIAL S.A.',322,NULL,NULL,NULL),(49,NULL,'NUEVO BANCO DE SANTA FE SOCIEDAD ANONIMA',330,NULL,NULL,NULL),(50,NULL,'BANCO CETELEM ARGENTINA S.A.',331,NULL,NULL,NULL),(51,NULL,'BANCO DE SERVICIOS FINANCIEROS S.A.',332,NULL,NULL,NULL),(52,NULL,'BANCO BRADESCO ARGENTINA S.A.U.',336,NULL,NULL,NULL),(53,NULL,'BANCO DE SERVICIOS Y TRANSACCIONES S.A.',338,NULL,NULL,NULL),(54,NULL,'RCI BANQUE S.A.',339,NULL,NULL,NULL),(55,NULL,'BACS BANCO DE CREDITO Y SECURITIZACION S',340,NULL,NULL,NULL),(56,NULL,'BANCO MASVENTAS S.A.',341,NULL,NULL,NULL),(57,NULL,'BANCO WANAP S.A.',384,NULL,NULL,NULL),(58,NULL,'NUEVO BANCO DE ENTRE RÍOS S.A.',386,NULL,NULL,NULL),(59,NULL,'BANCO COLUMBIA S.A.',389,NULL,NULL,NULL),(60,NULL,'BANCO BICA S.A.',426,NULL,NULL,NULL),(61,NULL,'BANCO COINAG S.A.',431,NULL,NULL,NULL),(62,NULL,'BANCO DE COMERCIO S.A.',432,NULL,NULL,NULL),(63,NULL,'FORD CREDIT COMPAÑIA FINANCIERA S.A.',44059,NULL,NULL,NULL),(64,NULL,'COMPAÑIA FINANCIERA ARGENTINA S.A.',44077,NULL,NULL,NULL),(65,NULL,'VOLKWAGEN FINANCIAL SERVICES CIA.FIN.S.A',44088,NULL,NULL,NULL),(66,NULL,'CORDIAL COMPAÑÍA FINANCIERA S.A.',44090,NULL,NULL,NULL),(67,NULL,'FCA COMPAÑIA FINANCIERA S.A.',44092,NULL,NULL,NULL);
INSERT INTO `ctacte_bancos` VALUES (68,NULL,'GPAT COMPAÑIA FINANCIERA S.A.',44093,NULL,NULL,NULL),(69,NULL,'MERCEDES-BENZ COMPAÑÍA FINANCIERA ARGENT',44094,NULL,NULL,NULL),(70,NULL,'ROMBO COMPAÑÍA FINANCIERA S.A.',44095,NULL,NULL,NULL),(71,NULL,'JOHN DEERE CREDIT COMPAÑÍA FINANCIERA S.',44096,NULL,NULL,NULL),(72,NULL,'PSA FINANCE ARGENTINA COMPAÑÍA FINANCIER',44098,NULL,NULL,NULL),(73,NULL,'TOYOTA COMPAÑÍA FINANCIERA DE ARGENTINA',44099,NULL,NULL,NULL),(74,NULL,'FINANDINO COMPAÑIA FINANCIERA S.A.',44100,NULL,NULL,NULL),(75,NULL,'MONTEMAR COMPAÑIA FINANCIERA S.A.',45056,NULL,NULL,NULL),(76,NULL,'MULTIFINANZAS COMPAÑIA FINANCIERA S.A.',45072,NULL,NULL,NULL),(77,NULL,'CAJA DE CREDITO \"CUENCA\" COOPERATIVA LIM',65203,NULL,NULL,NULL),(78,NULL,'MERCADO PAGO',NULL,NULL,NULL,NULL),(79,NULL,'UALA',NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctacte_bancos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctacte_bancos_datos`
--

DROP TABLE IF EXISTS `ctacte_bancos_datos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctacte_bancos_datos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cuenta_conta_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuit` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `titular` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `num_cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cbu` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alias` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ctacte_bancos_datos_cuenta_conta_id_foreign` (`cuenta_conta_id`),
  CONSTRAINT `ctacte_bancos_datos_cuenta_conta_id_foreign` FOREIGN KEY (`cuenta_conta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctacte_bancos_datos`
--

LOCK TABLES `ctacte_bancos_datos` WRITE;
/*!40000 ALTER TABLE `ctacte_bancos_datos` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctacte_bancos_datos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctacte_cheques`
--

DROP TABLE IF EXISTS `ctacte_cheques`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctacte_cheques` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `asiento_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuenta_conta_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id2` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id2` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) DEFAULT NULL,
  `cheque3ros` tinyint(1) NOT NULL DEFAULT '0',
  `cheque_emitidos` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `fecha_cobro` date DEFAULT NULL,
  `banco_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `cuit` text COLLATE utf8mb4_unicode_ci,
  `titular` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abierto_cruzado` int(11) NOT NULL DEFAULT '1',
  `is_no_a_la_orden` tinyint(1) NOT NULL DEFAULT '0',
  `numero` int(10) unsigned DEFAULT NULL,
  `foto` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ctacte_cheques_asiento_id_foreign` (`asiento_id`),
  KEY `ctacte_cheques_cuenta_conta_id_foreign` (`cuenta_conta_id`),
  KEY `ctacte_cheques_banco_id_foreign` (`banco_id`),
  KEY `ctacte_cheques_person_id_foreign` (`person_id`),
  KEY `ctacte_cheques_cta_cte_cliente_id2_foreign` (`cta_cte_cliente_id2`),
  KEY `ctacte_cheques_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_tesorer_id` (`cta_cte_tesoreria_id`),
  KEY `ctacte_cheques_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `ctacte_cheques_nf_cta_cte_id2_foreign` (`nf_cta_cte_id2`),
  KEY `ctacte_cheques_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `cta_cte_tesorer_id` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `ctacte_cheques_banco_id_foreign` FOREIGN KEY (`banco_id`) REFERENCES `ctacte_bancos` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_cliente_id2_foreign` FOREIGN KEY (`cta_cte_cliente_id2`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctacte_cheques_cuenta_conta_id_foreign` FOREIGN KEY (`cuenta_conta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `ctacte_cheques_nf_cta_cte_id2_foreign` FOREIGN KEY (`nf_cta_cte_id2`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `ctacte_cheques_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `ctacte_cheques_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctacte_cheques`
--

LOCK TABLES `ctacte_cheques` WRITE;
/*!40000 ALTER TABLE `ctacte_cheques` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctacte_cheques` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_centrocosto`
--

DROP TABLE IF EXISTS `ctactegastos_centrocosto`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_centrocosto` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_centrocosto`
--

LOCK TABLES `ctactegastos_centrocosto` WRITE;
/*!40000 ALTER TABLE `ctactegastos_centrocosto` DISABLE KEYS */;
INSERT INTO `ctactegastos_centrocosto` VALUES (1,NULL,'OFICINA',NULL,NULL,NULL),(2,NULL,'FIJO',NULL,NULL,NULL),(3,NULL,'VARIABLE',NULL,NULL,NULL),(4,NULL,'GISELA',NULL,NULL,NULL),(5,NULL,'LIA',NULL,NULL,NULL),(6,NULL,'PADRES',NULL,NULL,NULL),(7,NULL,'CASA',NULL,NULL,NULL),(8,NULL,'VANESA',NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctactegastos_centrocosto` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_cuenta_tipo`
--

DROP TABLE IF EXISTS `ctactegastos_cuenta_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_cuenta_tipo` (
  `idCuentaTipo` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `idTipo` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`idCuentaTipo`),
  KEY `ctactegastos_cuenta_tipo_idtipo_foreign` (`idTipo`),
  KEY `ctactegastos_cuenta_tipo_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `ctactegastos_cuenta_tipo_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctactegastos_cuenta_tipo_idtipo_foreign` FOREIGN KEY (`idTipo`) REFERENCES `ctactegastos_tiposdegastos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_cuenta_tipo`
--

LOCK TABLES `ctactegastos_cuenta_tipo` WRITE;
/*!40000 ALTER TABLE `ctactegastos_cuenta_tipo` DISABLE KEYS */;
INSERT INTO `ctactegastos_cuenta_tipo` VALUES (1,NULL,NULL,3,NULL,NULL,NULL),(2,NULL,NULL,6,NULL,NULL,NULL),(3,NULL,NULL,3,NULL,NULL,NULL),(4,NULL,NULL,4,NULL,NULL,NULL),(5,NULL,NULL,5,NULL,NULL,NULL),(6,NULL,NULL,3,NULL,NULL,NULL),(7,NULL,NULL,4,NULL,NULL,NULL),(8,NULL,NULL,3,NULL,NULL,NULL),(9,NULL,NULL,4,NULL,NULL,NULL),(10,NULL,NULL,7,NULL,NULL,NULL),(11,NULL,NULL,8,NULL,NULL,NULL),(12,NULL,NULL,3,NULL,NULL,NULL),(13,NULL,NULL,3,NULL,NULL,NULL),(14,NULL,NULL,4,NULL,NULL,NULL),(15,NULL,NULL,1,NULL,NULL,NULL),(16,NULL,NULL,2,NULL,NULL,NULL),(17,NULL,NULL,5,NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctactegastos_cuenta_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_mensuales`
--

DROP TABLE IF EXISTS `ctactegastos_mensuales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_mensuales` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `CuentaTipo_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL DEFAULT '13',
  `TipoDeGasto_id` int(10) unsigned NOT NULL,
  `CentroCosto_id` int(10) unsigned NOT NULL,
  `gasto_cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL DEFAULT '13',
  `monto` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ctactegastos_mensuales_cuentatipo_id_foreign` (`CuentaTipo_id`),
  KEY `ctactegastos_mensuales_tipodegasto_id_foreign` (`TipoDeGasto_id`),
  KEY `ctactegastos_mensuales_centrocosto_id_foreign` (`CentroCosto_id`),
  KEY `ctactegastos_mensuales_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `ctactegastos_mensuales_gasto_cta_cte_tesoreria_cuenta_id_foreign` (`gasto_cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `ctactegastos_mensuales_centrocosto_id_foreign` FOREIGN KEY (`CentroCosto_id`) REFERENCES `ctactegastos_centrocosto` (`id`),
  CONSTRAINT `ctactegastos_mensuales_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctactegastos_mensuales_cuentatipo_id_foreign` FOREIGN KEY (`CuentaTipo_id`) REFERENCES `ctactegastos_cuenta_tipo` (`idCuentaTipo`),
  CONSTRAINT `ctactegastos_mensuales_gasto_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`gasto_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctactegastos_mensuales_tipodegasto_id_foreign` FOREIGN KEY (`TipoDeGasto_id`) REFERENCES `ctactegastos_tiposdegastos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_mensuales`
--

LOCK TABLES `ctactegastos_mensuales` WRITE;
/*!40000 ALTER TABLE `ctactegastos_mensuales` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctactegastos_mensuales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_tiposdegastos`
--

DROP TABLE IF EXISTS `ctactegastos_tiposdegastos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_tiposdegastos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_tiposdegastos`
--

LOCK TABLES `ctactegastos_tiposdegastos` WRITE;
/*!40000 ALTER TABLE `ctactegastos_tiposdegastos` DISABLE KEYS */;
INSERT INTO `ctactegastos_tiposdegastos` VALUES (1,NULL,'Oficina',NULL,NULL,NULL),(2,NULL,'Personales',NULL,NULL,NULL),(3,NULL,'Tarjeta VISA',NULL,NULL,NULL),(4,NULL,'Tarjeta Mastercard',NULL,NULL,NULL),(5,NULL,'Debito Automatico',NULL,NULL,NULL),(6,NULL,'American Express',NULL,NULL,NULL),(7,NULL,'Tarjeta Shopping',NULL,NULL,NULL),(8,NULL,'Tarjeta Cencosud',NULL,NULL,NULL),(9,NULL,'Tarjeta Coto',NULL,NULL,NULL),(10,NULL,'Tarjeta Nativa',NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctactegastos_tiposdegastos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cursos`
--

DROP TABLE IF EXISTS `cursos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cursos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `fecha` date DEFAULT NULL,
  `hora` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `profesor` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cant_clases` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `duracion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `adjuntos` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `link_zoom` longtext COLLATE utf8mb4_unicode_ci,
  `cod_zoom` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contraseña_zoom` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `link_youtube` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `materiales` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cursos`
--

LOCK TABLES `cursos` WRITE;
/*!40000 ALTER TABLE `cursos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cursos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cursos_detail`
--

DROP TABLE IF EXISTS `cursos_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cursos_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `curso_id` int(10) unsigned NOT NULL,
  `field_name1` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `celular` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cursos_detail_curso_id_foreign` (`curso_id`),
  CONSTRAINT `cursos_detail_curso_id_foreign` FOREIGN KEY (`curso_id`) REFERENCES `cursos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cursos_detail`
--

LOCK TABLES `cursos_detail` WRITE;
/*!40000 ALTER TABLE `cursos_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `cursos_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `data_types`
--

DROP TABLE IF EXISTS `data_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `data_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `data_types_description_unique` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `data_types`
--

LOCK TABLES `data_types` WRITE;
/*!40000 ALTER TABLE `data_types` DISABLE KEYS */;
INSERT INTO `data_types` VALUES (1,'Comprobantes XLS',1,'Importación','XLS','data/imports/receipts/xls',NULL,NULL),(2,'CITI-Ventas',1,'Importación','TXT','data/imports/receipts/CitiVentas',NULL,NULL),(3,'CITI Compras',2,'Exportación','TXT','data/exports/receipts/citi',NULL,NULL),(4,'CITI Ventas',2,'Exportación','TXT','data/exports/receipts/CitiVentasExport',NULL,NULL),(5,'Convenio Multilateral',2,'Exportación','TXT','data/exports/receipts/convenio',NULL,NULL),(6,'Libro IVA Digital',2,'Exportación','TXT','data/exports/receipts/libro_iva_digital',NULL,'2019-11-20 21:43:44'),(7,'Mis Comprobantes',1,'Importacion','','data/imports/receipts/mis_comprobantes',NULL,NULL),(8,'Consulta AFIP',3,'AFIP','','data/afip/index','2019-12-06 14:49:55','2019-12-06 14:49:55');
/*!40000 ALTER TABLE `data_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_estados`
--

DROP TABLE IF EXISTS `dc_estados`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_estados` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_estados`
--

LOCK TABLES `dc_estados` WRITE;
/*!40000 ALTER TABLE `dc_estados` DISABLE KEYS */;
INSERT INTO `dc_estados` VALUES (1,NULL,'BORRADOR',1,NULL,'2023-08-06 23:58:57',NULL),(2,NULL,'TERMINADO',1,NULL,'2023-08-06 23:58:57',NULL),(3,NULL,'ELIMINADO',1,NULL,'2023-08-13 09:17:48',NULL),(4,NULL,'PAGADO',1,NULL,'2023-08-06 23:58:57','2023-08-06 23:58:57'),(5,NULL,'CONCILIADO',1,NULL,'2023-08-06 23:58:57','2023-08-06 23:58:57');
/*!40000 ALTER TABLE `dc_estados` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_firmas`
--

DROP TABLE IF EXISTS `dc_firmas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_firmas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `show_firmante_dc` tinyint(1) NOT NULL DEFAULT '0',
  `show_create_dc` tinyint(1) NOT NULL DEFAULT '0',
  `faltan_firmas` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_firmas`
--

LOCK TABLES `dc_firmas` WRITE;
/*!40000 ALTER TABLE `dc_firmas` DISABLE KEYS */;
INSERT INTO `dc_firmas` VALUES (1,NULL,'NO',1,1,0,1,NULL,'2023-08-06 23:58:57',NULL),(2,NULL,'RECHAZADO',1,1,0,1,NULL,'2023-08-06 23:58:57',NULL),(3,NULL,'ACEPTADO',1,0,0,1,NULL,'2023-08-06 23:58:57',NULL),(4,NULL,'FALTAN FIRMAS',0,0,1,1,'2023-08-06 23:58:57','2023-08-06 23:58:57',NULL),(5,NULL,'EMITIDO',1,0,0,1,'2023-10-12 08:07:26','2023-10-12 08:07:26',NULL);
/*!40000 ALTER TABLE `dc_firmas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_firmas_ordenes`
--

DROP TABLE IF EXISTS `dc_firmas_ordenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_firmas_ordenes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `user_id_que_firma` int(10) unsigned NOT NULL,
  `dc_firma_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_firmas_ordenes_person_id_foreign` (`person_id`),
  KEY `dc_firmas_ordenes_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_firmas_ordenes_dc_firma_id_foreign` (`dc_firma_id`),
  CONSTRAINT `dc_firmas_ordenes_dc_firma_id_foreign` FOREIGN KEY (`dc_firma_id`) REFERENCES `dc_firmas` (`id`),
  CONSTRAINT `dc_firmas_ordenes_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_firmas_ordenes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_firmas_ordenes`
--

LOCK TABLES `dc_firmas_ordenes` WRITE;
/*!40000 ALTER TABLE `dc_firmas_ordenes` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_firmas_ordenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_firmas_reglas`
--

DROP TABLE IF EXISTS `dc_firmas_reglas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_firmas_reglas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL,
  `grupos_users_ids` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_firmas_reglas_person_id_foreign` (`person_id`),
  KEY `dc_firmas_reglas_dc_orden_id_foreign` (`dc_orden_id`),
  CONSTRAINT `dc_firmas_reglas_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_firmas_reglas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_firmas_reglas`
--

LOCK TABLES `dc_firmas_reglas` WRITE;
/*!40000 ALTER TABLE `dc_firmas_reglas` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_firmas_reglas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_orden_de_pago`
--

DROP TABLE IF EXISTS `dc_orden_de_pago`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_orden_de_pago` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fecha` datetime NOT NULL DEFAULT '2023-09-28 16:31:13',
  `dc_orden_id` bigint(20) unsigned NOT NULL DEFAULT '10',
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `dc_estado_id` bigint(20) unsigned NOT NULL DEFAULT '1',
  `dc_firma_id` bigint(20) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_orden_de_pago_person_id_foreign` (`person_id`),
  KEY `dc_orden_de_pago_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `dc_orden_de_pago_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_orden_de_pago_dc_firma_id_foreign` (`dc_firma_id`),
  KEY `dc_orden_de_pago_dc_estado_id_foreign` (`dc_estado_id`),
  CONSTRAINT `dc_orden_de_pago_dc_estado_id_foreign` FOREIGN KEY (`dc_estado_id`) REFERENCES `dc_estados` (`id`),
  CONSTRAINT `dc_orden_de_pago_dc_firma_id_foreign` FOREIGN KEY (`dc_firma_id`) REFERENCES `dc_firmas` (`id`),
  CONSTRAINT `dc_orden_de_pago_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_orden_de_pago_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `dc_orden_de_pago_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_orden_de_pago`
--

LOCK TABLES `dc_orden_de_pago` WRITE;
/*!40000 ALTER TABLE `dc_orden_de_pago` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_orden_de_pago` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_orden_de_pago_receipts`
--

DROP TABLE IF EXISTS `dc_orden_de_pago_receipts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_orden_de_pago_receipts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_de_pago_id` bigint(20) unsigned NOT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `importe` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_orden_de_pago_receipts_dc_orden_de_pago_id_foreign` (`dc_orden_de_pago_id`),
  KEY `dc_orden_de_pago_receipts_receipt_id_foreign` (`receipt_id`),
  CONSTRAINT `dc_orden_de_pago_receipts_dc_orden_de_pago_id_foreign` FOREIGN KEY (`dc_orden_de_pago_id`) REFERENCES `dc_orden_de_pago` (`id`),
  CONSTRAINT `dc_orden_de_pago_receipts_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_orden_de_pago_receipts`
--

LOCK TABLES `dc_orden_de_pago_receipts` WRITE;
/*!40000 ALTER TABLE `dc_orden_de_pago_receipts` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_orden_de_pago_receipts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_orden_files`
--

DROP TABLE IF EXISTS `dc_orden_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_orden_files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `file` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `original_name` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_orden_files_dc_orden_id_foreign` (`dc_orden_id`),
  CONSTRAINT `dc_orden_files_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_orden_files`
--

LOCK TABLES `dc_orden_files` WRITE;
/*!40000 ALTER TABLE `dc_orden_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_orden_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes`
--

DROP TABLE IF EXISTS `dc_ordenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_tipo_id` bigint(20) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `titulo` text COLLATE utf8mb4_unicode_ci,
  `sucursal` int(11) NOT NULL DEFAULT '1',
  `numero` int(11) NOT NULL,
  `sector` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `solicitante` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `syj_empleado_id` int(10) unsigned DEFAULT NULL,
  `fecha` date NOT NULL,
  `fecha_entrega` date DEFAULT NULL,
  `fecha_asignacion` datetime DEFAULT NULL,
  `fecha_cumplido` datetime DEFAULT NULL,
  `condicion_venta_id` int(10) unsigned DEFAULT NULL,
  `is_pago_adelantado` tinyint(1) DEFAULT NULL,
  `forma_de_entrega_id` int(10) unsigned DEFAULT NULL,
  `plazo_de_pago_id` int(10) unsigned DEFAULT NULL,
  `cantidades` decimal(16,2) NOT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(16,2) NOT NULL DEFAULT '1.00',
  `neto` decimal(16,2) NOT NULL,
  `iva` decimal(16,2) NOT NULL,
  `total` decimal(16,2) NOT NULL,
  `facturada` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `dc_estado_id` bigint(20) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `conta_cc_id` bigint(20) unsigned DEFAULT NULL,
  `origendestinoable_type` text COLLATE utf8mb4_unicode_ci,
  `origendestinoable_id` int(10) unsigned DEFAULT NULL,
  `is_multiples_ot` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `dc_orden_origen_destino_id` bigint(20) unsigned DEFAULT NULL,
  `is_completado` tinyint(1) NOT NULL DEFAULT '0',
  `dc_firma_id` bigint(20) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_dc_orden_tipo_id_foreign` (`dc_orden_tipo_id`),
  KEY `dc_ordenes_person_id_foreign` (`person_id`),
  KEY `dc_ordenes_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `dc_ordenes_dc_estado_id_foreign` (`dc_estado_id`),
  KEY `dc_ordenes_conta_cc_id_foreign` (`conta_cc_id`),
  KEY `dc_ordenes_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  KEY `dc_ordenes_dc_orden_origen_destino_id_foreign` (`dc_orden_origen_destino_id`),
  KEY `dc_ordenes_moneda_id_foreign` (`moneda_id`),
  KEY `dc_ordenes_dc_firma_id_foreign` (`dc_firma_id`),
  KEY `dc_ordenes_syj_empleado_id_foreign` (`syj_empleado_id`),
  CONSTRAINT `dc_ordenes_conta_cc_id_foreign` FOREIGN KEY (`conta_cc_id`) REFERENCES `conta_centro_costos` (`id`),
  CONSTRAINT `dc_ordenes_dc_estado_id_foreign` FOREIGN KEY (`dc_estado_id`) REFERENCES `dc_estados` (`id`),
  CONSTRAINT `dc_ordenes_dc_firma_id_foreign` FOREIGN KEY (`dc_firma_id`) REFERENCES `dc_firmas` (`id`),
  CONSTRAINT `dc_ordenes_dc_orden_origen_destino_id_foreign` FOREIGN KEY (`dc_orden_origen_destino_id`) REFERENCES `dc_ordenes_origen_destino` (`id`),
  CONSTRAINT `dc_ordenes_dc_orden_tipo_id_foreign` FOREIGN KEY (`dc_orden_tipo_id`) REFERENCES `dc_ordenes_tipos` (`id`),
  CONSTRAINT `dc_ordenes_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `dc_ordenes_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `dc_ordenes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `dc_ordenes_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `dc_ordenes_syj_empleado_id_foreign` FOREIGN KEY (`syj_empleado_id`) REFERENCES `syj_empleados` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes`
--

LOCK TABLES `dc_ordenes` WRITE;
/*!40000 ALTER TABLE `dc_ordenes` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_compra_req`
--

DROP TABLE IF EXISTS `dc_ordenes_compra_req`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_compra_req` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_detail_id` bigint(20) unsigned NOT NULL,
  `dc_orden_req_id` bigint(20) unsigned NOT NULL,
  `dc_orden_req_detail_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_compra_req_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_compra_req_dc_orden_detail_id_foreign` (`dc_orden_detail_id`),
  KEY `dc_ordenes_compra_req_dc_orden_req_id_foreign` (`dc_orden_req_id`),
  KEY `dc_ordenes_compra_req_dc_orden_req_detail_id_foreign` (`dc_orden_req_detail_id`),
  CONSTRAINT `dc_ordenes_compra_req_dc_orden_detail_id_foreign` FOREIGN KEY (`dc_orden_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_compra_req_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_compra_req_dc_orden_req_detail_id_foreign` FOREIGN KEY (`dc_orden_req_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_compra_req_dc_orden_req_id_foreign` FOREIGN KEY (`dc_orden_req_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_compra_req`
--

LOCK TABLES `dc_ordenes_compra_req` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_compra_req` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_compra_req` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_details`
--

DROP TABLE IF EXISTS `dc_ordenes_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_origen_destino_id` bigint(20) unsigned DEFAULT NULL,
  `origendestinoable_id` int(10) unsigned DEFAULT NULL,
  `origendestinoable_type` text COLLATE utf8mb4_unicode_ci,
  `cantidades` decimal(16,2) NOT NULL,
  `inv_producto_id` bigint(20) unsigned DEFAULT NULL,
  `inv_producto_id_destino` bigint(20) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `neto` decimal(16,2) NOT NULL,
  `desc_porc` decimal(16,2) DEFAULT NULL,
  `descuento` decimal(16,2) DEFAULT NULL,
  `system_tax_id` int(10) unsigned NOT NULL,
  `iva` decimal(16,2) NOT NULL,
  `subtotal` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_details_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_details_inv_producto_id_foreign` (`inv_producto_id`),
  KEY `dc_ordenes_details_system_tax_id_foreign` (`system_tax_id`),
  KEY `dc_ordenes_details_inv_producto_id_destino_foreign` (`inv_producto_id_destino`),
  KEY `dc_ordenes_details_dc_orden_origen_destino_id_foreign` (`dc_orden_origen_destino_id`),
  CONSTRAINT `dc_ordenes_details_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_details_dc_orden_origen_destino_id_foreign` FOREIGN KEY (`dc_orden_origen_destino_id`) REFERENCES `dc_ordenes_origen_destino` (`id`),
  CONSTRAINT `dc_ordenes_details_inv_producto_id_destino_foreign` FOREIGN KEY (`inv_producto_id_destino`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `dc_ordenes_details_inv_producto_id_foreign` FOREIGN KEY (`inv_producto_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `dc_ordenes_details_system_tax_id_foreign` FOREIGN KEY (`system_tax_id`) REFERENCES `system_taxes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_details`
--

LOCK TABLES `dc_ordenes_details` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_facturada`
--

DROP TABLE IF EXISTS `dc_ordenes_facturada`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_facturada` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `dc_orden_id` bigint(20) unsigned DEFAULT NULL,
  `fact_elec_receipt_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_facturada_person_id_foreign` (`person_id`),
  KEY `dc_ordenes_facturada_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_facturada_fact_elec_receipt_id_foreign` (`fact_elec_receipt_id`),
  CONSTRAINT `dc_ordenes_facturada_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_facturada_fact_elec_receipt_id_foreign` FOREIGN KEY (`fact_elec_receipt_id`) REFERENCES `fact_elec_receipts` (`id`),
  CONSTRAINT `dc_ordenes_facturada_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_facturada`
--

LOCK TABLES `dc_ordenes_facturada` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_facturada` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_facturada` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_ingreso_compra`
--

DROP TABLE IF EXISTS `dc_ordenes_ingreso_compra`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_ingreso_compra` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_detail_id` bigint(20) unsigned NOT NULL,
  `dc_orden_compra_id` bigint(20) unsigned NOT NULL,
  `dc_orden_compra_detail_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_ingreso_compra_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_ingreso_compra_dc_orden_detail_id_foreign` (`dc_orden_detail_id`),
  KEY `dc_ordenes_ingreso_compra_dc_orden_compra_id_foreign` (`dc_orden_compra_id`),
  KEY `dc_ordenes_ingreso_compra_dc_orden_compra_detail_id_foreign` (`dc_orden_compra_detail_id`),
  CONSTRAINT `dc_ordenes_ingreso_compra_dc_orden_compra_detail_id_foreign` FOREIGN KEY (`dc_orden_compra_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_ingreso_compra_dc_orden_compra_id_foreign` FOREIGN KEY (`dc_orden_compra_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_ingreso_compra_dc_orden_detail_id_foreign` FOREIGN KEY (`dc_orden_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_ingreso_compra_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_ingreso_compra`
--

LOCK TABLES `dc_ordenes_ingreso_compra` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_ingreso_compra` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_ingreso_compra` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_origen_destino`
--

DROP TABLE IF EXISTS `dc_ordenes_origen_destino`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_origen_destino` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `modelo` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_deposito` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_origen_destino`
--

LOCK TABLES `dc_ordenes_origen_destino` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_origen_destino` DISABLE KEYS */;
INSERT INTO `dc_ordenes_origen_destino` VALUES (1,NULL,'Orden de Trabajo','App\\Models\\Inventario\\InvOrdenTrabajo',0,1,NULL,NULL,NULL),(2,NULL,'Centro de Costos','App\\Models\\Inventario\\InvOrdenTrabajoHorasTipo',0,1,NULL,'2023-09-12 22:20:13',NULL),(3,NULL,'Deposito','App\\Models\\Inventario\\InvDeposito',1,1,NULL,'2024-05-07 20:13:21',NULL),(4,NULL,'Empleado','App\\Models\\SyJEmpleado',0,0,NULL,'2023-07-03 22:09:49',NULL);
/*!40000 ALTER TABLE `dc_ordenes_origen_destino` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_revocadas`
--

DROP TABLE IF EXISTS `dc_ordenes_revocadas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_revocadas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `comentario` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_revocadas_dc_orden_id_foreign` (`dc_orden_id`),
  CONSTRAINT `dc_ordenes_revocadas_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_revocadas`
--

LOCK TABLES `dc_ordenes_revocadas` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_revocadas` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_revocadas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_servicio_compra`
--

DROP TABLE IF EXISTS `dc_ordenes_servicio_compra`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_servicio_compra` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_detail_id` bigint(20) unsigned NOT NULL,
  `dc_orden_compra_id` bigint(20) unsigned NOT NULL,
  `dc_orden_compra_detail_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_servicio_compra_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_servicio_compra_dc_orden_detail_id_foreign` (`dc_orden_detail_id`),
  KEY `dc_ordenes_servicio_compra_dc_orden_compra_id_foreign` (`dc_orden_compra_id`),
  KEY `dc_ordenes_servicio_compra_dc_orden_compra_detail_id_foreign` (`dc_orden_compra_detail_id`),
  CONSTRAINT `dc_ordenes_servicio_compra_dc_orden_compra_detail_id_foreign` FOREIGN KEY (`dc_orden_compra_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_servicio_compra_dc_orden_compra_id_foreign` FOREIGN KEY (`dc_orden_compra_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_servicio_compra_dc_orden_detail_id_foreign` FOREIGN KEY (`dc_orden_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_servicio_compra_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_servicio_compra`
--

LOCK TABLES `dc_ordenes_servicio_compra` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_servicio_compra` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_servicio_compra` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_tipos`
--

DROP TABLE IF EXISTS `dc_ordenes_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_tipos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `usabilidad` longtext COLLATE utf8mb4_unicode_ci,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_tipos`
--

LOCK TABLES `dc_ordenes_tipos` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_tipos` DISABLE KEYS */;
INSERT INTO `dc_ordenes_tipos` VALUES (1,NULL,'ORDEN DE COMPRAS',NULL,1,NULL,'2022-09-15 14:37:28',NULL),(2,NULL,'ORDEN DE VENTAS',NULL,1,NULL,'2022-09-15 14:37:28',NULL),(3,NULL,'PRESUPUESTO',NULL,1,NULL,NULL,NULL),(4,NULL,'REQUERIMIENTO',NULL,1,NULL,NULL,NULL),(5,NULL,'REMITO DE INGRESO',NULL,1,NULL,'2023-06-12 23:28:35',NULL),(6,NULL,'REMITO DE EGRESO',NULL,1,NULL,NULL,NULL),(7,NULL,'REMITO INTERNO',NULL,1,NULL,NULL,NULL),(8,NULL,'REMITO DE INGRESO','Es lo mismo que un remito de ingreso, \n        pero los productosa ingresar provienen de una Orden de Compra',1,NULL,NULL,NULL),(9,NULL,'REMITO DE SERVICIO','Es un remito de Ingreso de un servicio que se\n        asigna directo a una OT',1,NULL,NULL,NULL),(10,NULL,'ORDEN DE PAGO',NULL,1,'2023-09-28 16:31:13','2023-09-28 16:31:13',NULL),(11,NULL,'ANULACION REQUERIMIENTOS',NULL,1,'2024-04-02 23:11:05','2024-04-02 23:11:05',NULL),(12,NULL,'ANULACION COMPRAS PRODUCTOS',NULL,1,'2024-04-02 23:11:05','2024-04-02 23:11:05',NULL),(13,NULL,'ANULACION COMPRAS SERVICIOS',NULL,1,'2024-04-02 23:11:05','2024-04-02 23:11:05',NULL),(14,NULL,'REMITO DE GASTO',NULL,1,'2024-05-07 20:13:21','2024-05-07 20:13:21',NULL);
/*!40000 ALTER TABLE `dc_ordenes_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `deudas_impositivas`
--

DROP TABLE IF EXISTS `deudas_impositivas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `deudas_impositivas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `vto_impuesto_id` int(10) unsigned NOT NULL,
  `periodo_deuda` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `concepto` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `deudas_impositivas_vto_impuesto_id_foreign` (`vto_impuesto_id`),
  KEY `deudas_impositivas_person_id_foreign` (`person_id`),
  CONSTRAINT `deudas_impositivas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `deudas_impositivas_vto_impuesto_id_foreign` FOREIGN KEY (`vto_impuesto_id`) REFERENCES `vto_impuestos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `deudas_impositivas`
--

LOCK TABLES `deudas_impositivas` WRITE;
/*!40000 ALTER TABLE `deudas_impositivas` DISABLE KEYS */;
/*!40000 ALTER TABLE `deudas_impositivas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ejer_anteriores`
--

DROP TABLE IF EXISTS `ejer_anteriores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ejer_anteriores` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `anio` int(11) NOT NULL,
  `ventas` decimal(16,2) DEFAULT NULL,
  `compras` decimal(16,2) DEFAULT NULL,
  `sueldos` decimal(16,2) DEFAULT NULL,
  `impuesto` decimal(16,2) DEFAULT NULL,
  `apagar` decimal(16,2) DEFAULT NULL,
  `afavor` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ejer_anteriores_person_id_foreign` (`person_id`),
  CONSTRAINT `ejer_anteriores_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ejer_anteriores`
--

LOCK TABLES `ejer_anteriores` WRITE;
/*!40000 ALTER TABLE `ejer_anteriores` DISABLE KEYS */;
/*!40000 ALTER TABLE `ejer_anteriores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estado_civil`
--

DROP TABLE IF EXISTS `estado_civil`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estado_civil` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `estado_civil_descripcion_unique` (`descripcion`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estado_civil`
--

LOCK TABLES `estado_civil` WRITE;
/*!40000 ALTER TABLE `estado_civil` DISABLE KEYS */;
INSERT INTO `estado_civil` VALUES (1,NULL,'Separado Legal',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(2,NULL,'Separado de Hecho',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(3,NULL,'Divorciado',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(4,NULL,'Convivencia',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(5,NULL,'Soltero',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(6,NULL,'Casado',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(7,NULL,'Viudo',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL);
/*!40000 ALTER TABLE `estado_civil` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fa_masiva`
--

DROP TABLE IF EXISTS `fa_masiva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fa_masiva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `person_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fa_masiva`
--

LOCK TABLES `fa_masiva` WRITE;
/*!40000 ALTER TABLE `fa_masiva` DISABLE KEYS */;
/*!40000 ALTER TABLE `fa_masiva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fa_masiva_detalle`
--

DROP TABLE IF EXISTS `fa_masiva_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fa_masiva_detalle` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fa_masiva_id` int(11) NOT NULL,
  `cliente_id` int(11) NOT NULL,
  `tipo_comprobante_id` int(10) unsigned NOT NULL DEFAULT '1',
  `zone_id` int(10) unsigned NOT NULL DEFAULT '22',
  `activity_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cond_frente_iva_id` int(10) unsigned NOT NULL DEFAULT '1',
  `system_tax_id` int(10) unsigned NOT NULL DEFAULT '1',
  `concepto_id` int(10) unsigned NOT NULL DEFAULT '1',
  `taxable_iibb` int(10) unsigned NOT NULL DEFAULT '2',
  `renglon1` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe1` decimal(20,2) DEFAULT NULL,
  `renglon2` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe2` decimal(20,2) DEFAULT NULL,
  `renglon3` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe3` decimal(20,2) DEFAULT NULL,
  `punto_venta_id` int(11) DEFAULT NULL,
  `fecha_comprobante` date DEFAULT NULL,
  `fecha_facturado_desde` date DEFAULT NULL,
  `fecha_facturado_hasta` date DEFAULT NULL,
  `fecha_vencimiento_pago` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fa_masiva_detalle_concepto_id_foreign` (`concepto_id`),
  KEY `fa_masiva_detalle_system_tax_id_foreign` (`system_tax_id`),
  KEY `fa_masiva_detalle_cond_frente_iva_id_foreign` (`cond_frente_iva_id`),
  KEY `fa_masiva_detalle_zone_id_foreign` (`zone_id`),
  KEY `fa_masiva_detalle_tipo_comprobante_id_foreign` (`tipo_comprobante_id`),
  KEY `fa_masiva_detalle_activity_id_foreign` (`activity_id`),
  CONSTRAINT `fa_masiva_detalle_activity_id_foreign` FOREIGN KEY (`activity_id`) REFERENCES `activities` (`id`),
  CONSTRAINT `fa_masiva_detalle_concepto_id_foreign` FOREIGN KEY (`concepto_id`) REFERENCES `fact_elec_conceptos_afip` (`id`),
  CONSTRAINT `fa_masiva_detalle_cond_frente_iva_id_foreign` FOREIGN KEY (`cond_frente_iva_id`) REFERENCES `fac_elec_cond_frente_iva` (`id`),
  CONSTRAINT `fa_masiva_detalle_system_tax_id_foreign` FOREIGN KEY (`system_tax_id`) REFERENCES `system_taxes` (`id`),
  CONSTRAINT `fa_masiva_detalle_tipo_comprobante_id_foreign` FOREIGN KEY (`tipo_comprobante_id`) REFERENCES `receipt_types` (`id`),
  CONSTRAINT `fa_masiva_detalle_zone_id_foreign` FOREIGN KEY (`zone_id`) REFERENCES `zones` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fa_masiva_detalle`
--

LOCK TABLES `fa_masiva_detalle` WRITE;
/*!40000 ALTER TABLE `fa_masiva_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `fa_masiva_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fa_masiva_stock`
--

DROP TABLE IF EXISTS `fa_masiva_stock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fa_masiva_stock` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fa_masiva_stock_person_id_foreign` (`person_id`),
  KEY `fa_masiva_stock_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `fa_masiva_stock_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `fa_masiva_stock_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fa_masiva_stock`
--

LOCK TABLES `fa_masiva_stock` WRITE;
/*!40000 ALTER TABLE `fa_masiva_stock` DISABLE KEYS */;
/*!40000 ALTER TABLE `fa_masiva_stock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fac_elec_cond_frente_iva`
--

DROP TABLE IF EXISTS `fac_elec_cond_frente_iva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fac_elec_cond_frente_iva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `fac_elec_cond_frente_iva_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fac_elec_cond_frente_iva`
--

LOCK TABLES `fac_elec_cond_frente_iva` WRITE;
/*!40000 ALTER TABLE `fac_elec_cond_frente_iva` DISABLE KEYS */;
INSERT INTO `fac_elec_cond_frente_iva` VALUES (1,'IVA Responsable Inscripto','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(2,'IVA Sujeto Exento','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(3,'Consumidor Final','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(4,'Responsable Monotributo','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(5,'Proveedor del Exterior','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(6,'Cliente del Exterior','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(7,'IVA Liberado - Ley Nº 19.640','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(8,'IVA Responsable Inscripto - Agente de Percepción','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(9,'Monotributista Social','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(10,'IVA No Alcanzado','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL);
/*!40000 ALTER TABLE `fac_elec_cond_frente_iva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fac_elec_unidad_medidas`
--

DROP TABLE IF EXISTS `fac_elec_unidad_medidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fac_elec_unidad_medidas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `fac_elec_unidad_medidas_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fac_elec_unidad_medidas`
--

LOCK TABLES `fac_elec_unidad_medidas` WRITE;
/*!40000 ALTER TABLE `fac_elec_unidad_medidas` DISABLE KEYS */;
INSERT INTO `fac_elec_unidad_medidas` VALUES (1,'Grs','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(2,'Kg','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(3,'Mts','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(4,'Mts2','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(5,'Mts3','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(6,'Lts','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(7,'1000 Kwh','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(8,'Unidades','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(9,'Pares','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(10,'Doc','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(11,'Quilates','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(12,'Millares','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(13,'Milimetros','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(14,'Mm 3','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(15,'Km','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(16,'Hectolitros','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(17,'Cm','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(18,'Cm 3','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL);
/*!40000 ALTER TABLE `fac_elec_unidad_medidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_conceptos_afip`
--

DROP TABLE IF EXISTS `fact_elec_conceptos_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_conceptos_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `afip_comprobante_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_conceptos_afip`
--

LOCK TABLES `fact_elec_conceptos_afip` WRITE;
/*!40000 ALTER TABLE `fact_elec_conceptos_afip` DISABLE KEYS */;
INSERT INTO `fact_elec_conceptos_afip` VALUES (1,1,'Producto','2019-03-13 13:29:34','2019-03-13 13:29:34'),(2,2,'Servicios','2019-03-13 13:29:34','2019-03-13 13:29:34'),(3,3,'Productos y Servicios','2019-03-13 13:29:34','2019-03-13 13:29:34');
/*!40000 ALTER TABLE `fact_elec_conceptos_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_perc_ret`
--

DROP TABLE IF EXISTS `fact_elec_perc_ret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_perc_ret` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` int(10) unsigned NOT NULL,
  `other_tax_id` int(10) unsigned NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_perc_ret_other_tax_id_foreign` (`other_tax_id`),
  CONSTRAINT `fact_elec_perc_ret_other_tax_id_foreign` FOREIGN KEY (`other_tax_id`) REFERENCES `other_taxes` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_perc_ret`
--

LOCK TABLES `fact_elec_perc_ret` WRITE;
/*!40000 ALTER TABLE `fact_elec_perc_ret` DISABLE KEYS */;
INSERT INTO `fact_elec_perc_ret` VALUES (1,NULL,'Per./Ret de Imp. a las Ganancias',1,1032,1,NULL,NULL,NULL),(2,NULL,'Per./Ret de IVA',1,1000,1,NULL,NULL,NULL),(3,NULL,'Per./Ret de IIBB',2,1006,1,NULL,NULL,NULL),(4,NULL,'Impuestos Internos',4,1001,1,NULL,NULL,NULL),(5,NULL,'Impuestos Municipales',3,1031,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `fact_elec_perc_ret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_perc_ret_details`
--

DROP TABLE IF EXISTS `fact_elec_perc_ret_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_perc_ret_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fact_elec_perc_ret_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `fact_elec_receipt_id` int(10) unsigned NOT NULL,
  `detalle` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zone_id` int(10) unsigned DEFAULT NULL,
  `base_imponible` decimal(16,2) DEFAULT NULL,
  `alicuota` decimal(16,2) DEFAULT NULL,
  `importe` decimal(16,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_perc_ret_details_fact_elec_perc_ret_id_foreign` (`fact_elec_perc_ret_id`),
  KEY `fact_elec_perc_ret_details_person_id_foreign` (`person_id`),
  KEY `fact_elec_perc_ret_details_fact_elec_receipt_id_foreign` (`fact_elec_receipt_id`),
  KEY `fact_elec_perc_ret_details_zone_id_foreign` (`zone_id`),
  CONSTRAINT `fact_elec_perc_ret_details_fact_elec_perc_ret_id_foreign` FOREIGN KEY (`fact_elec_perc_ret_id`) REFERENCES `fact_elec_perc_ret` (`id`),
  CONSTRAINT `fact_elec_perc_ret_details_fact_elec_receipt_id_foreign` FOREIGN KEY (`fact_elec_receipt_id`) REFERENCES `fact_elec_receipts` (`id`),
  CONSTRAINT `fact_elec_perc_ret_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `fact_elec_perc_ret_details_zone_id_foreign` FOREIGN KEY (`zone_id`) REFERENCES `zones` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_perc_ret_details`
--

LOCK TABLES `fact_elec_perc_ret_details` WRITE;
/*!40000 ALTER TABLE `fact_elec_perc_ret_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `fact_elec_perc_ret_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_puntos_venta`
--

DROP TABLE IF EXISTS `fact_elec_puntos_venta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_puntos_venta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `direccion` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `codigo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '0000',
  `codigo_postal` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zone_id` int(11) DEFAULT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_puntos_venta_person_id_foreign` (`person_id`),
  CONSTRAINT `fact_elec_puntos_venta_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_puntos_venta`
--

LOCK TABLES `fact_elec_puntos_venta` WRITE;
/*!40000 ALTER TABLE `fact_elec_puntos_venta` DISABLE KEYS */;
INSERT INTO `fact_elec_puntos_venta` VALUES (1,7847,'RIO NIHUIL 1658','2022-11-10 12:23:16','2022-11-15 11:02:53',40719,'0003','1661',23,'img//27304735215/logo_punto_venta_0003.png',1,NULL);
/*!40000 ALTER TABLE `fact_elec_puntos_venta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_receipt_details`
--

DROP TABLE IF EXISTS `fact_elec_receipt_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_receipt_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fact_elec_receipt_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `cantidad` decimal(20,2) NOT NULL,
  `unidad_medida` text COLLATE utf8mb4_unicode_ci,
  `precio_unitario` decimal(20,2) NOT NULL,
  `neto_gravado` decimal(20,2) NOT NULL,
  `bonificacion_porcentaje` decimal(20,2) DEFAULT NULL,
  `bonificacion_monto` decimal(20,2) DEFAULT NULL,
  `bonificacion_subtotal` decimal(20,2) DEFAULT NULL,
  `system_tax_id` int(10) unsigned NOT NULL DEFAULT '1',
  `iva_monto` decimal(20,2) DEFAULT NULL,
  `iva_subtotal` decimal(20,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `codigo` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_receipt_details_fact_elec_receipt_id_foreign` (`fact_elec_receipt_id`),
  KEY `fact_elec_receipt_details_system_tax_id_foreign` (`system_tax_id`),
  CONSTRAINT `fact_elec_receipt_details_fact_elec_receipt_id_foreign` FOREIGN KEY (`fact_elec_receipt_id`) REFERENCES `fact_elec_receipts` (`id`),
  CONSTRAINT `fact_elec_receipt_details_system_tax_id_foreign` FOREIGN KEY (`system_tax_id`) REFERENCES `system_taxes` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_receipt_details`
--

LOCK TABLES `fact_elec_receipt_details` WRITE;
/*!40000 ALTER TABLE `fact_elec_receipt_details` DISABLE KEYS */;
INSERT INTO `fact_elec_receipt_details` VALUES (2,7847,2,'HONORARIOS CONTABLES Y SERVICIO DE FACTURACIÓN',1.00,'8',24000.00,24000.00,0.00,0.00,0.00,7,0.00,24000.00,'2022-11-15 10:57:12','2022-11-15 10:57:12','0001',NULL),(3,7847,3,'HONORARIOS',1.00,'8',12000.00,12000.00,0.00,0.00,0.00,7,0.00,12000.00,'2022-11-15 11:06:07','2022-11-15 11:06:07','0001',NULL);
/*!40000 ALTER TABLE `fact_elec_receipt_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_receipts`
--

DROP TABLE IF EXISTS `fact_elec_receipts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_receipts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `fecha_comprobante` date NOT NULL,
  `fecha_facturado_desde` date DEFAULT NULL,
  `fecha_facturado_hasta` date DEFAULT NULL,
  `fecha_vencimiento_pago` date DEFAULT NULL,
  `concepto_id` int(10) unsigned NOT NULL,
  `punto_venta_id` int(10) unsigned NOT NULL,
  `tipo_comprobante_id` int(10) unsigned NOT NULL,
  `condiciones_venta` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comprobante_asoc` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `cae` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cae_vencimiento` date DEFAULT NULL,
  `nro_comprobante_afip` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha_proceso_afip` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_receptor` int(10) unsigned NOT NULL,
  `condicion_venta_id` int(11) DEFAULT NULL,
  `cond_frente_iva_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cbu` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `opcion_transferencia` longtext COLLATE utf8mb4_unicode_ci,
  `referencia` text COLLATE utf8mb4_unicode_ci,
  `alias_cbu` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_otros_tributos` decimal(16,2) DEFAULT '0.00',
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(9,2) NOT NULL DEFAULT '1.00',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_receipts_user_id_foreign` (`user_id`),
  KEY `fact_elec_receipts_punto_venta_id_foreign` (`punto_venta_id`),
  KEY `fact_elec_receipts_tipo_comprobante_id_foreign` (`tipo_comprobante_id`),
  KEY `fact_elec_receipts_person_id_foreign` (`person_id`),
  KEY `fact_elec_receipts_person_id_receptor_foreign` (`person_id_receptor`),
  KEY `fact_elec_receipts_cond_frente_iva_id_foreign` (`cond_frente_iva_id`),
  KEY `fact_elec_receipts_moneda_id_foreign` (`moneda_id`),
  CONSTRAINT `fact_elec_receipts_cond_frente_iva_id_foreign` FOREIGN KEY (`cond_frente_iva_id`) REFERENCES `condicion_frente_al_iva` (`id`),
  CONSTRAINT `fact_elec_receipts_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `fact_elec_receipts_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `fact_elec_receipts_person_id_receptor_foreign` FOREIGN KEY (`person_id_receptor`) REFERENCES `persons` (`id`),
  CONSTRAINT `fact_elec_receipts_punto_venta_id_foreign` FOREIGN KEY (`punto_venta_id`) REFERENCES `fact_elec_puntos_venta` (`id`),
  CONSTRAINT `fact_elec_receipts_tipo_comprobante_id_foreign` FOREIGN KEY (`tipo_comprobante_id`) REFERENCES `receipt_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_receipts`
--

LOCK TABLES `fact_elec_receipts` WRITE;
/*!40000 ALTER TABLE `fact_elec_receipts` DISABLE KEYS */;
INSERT INTO `fact_elec_receipts` VALUES (1,7847,'2022-11-15','2022-11-01','2022-11-30','2022-11-10',2,1,7,'','{\"Tipo\":null,\"PtoVta\":null,\"Nro\":null,\"CbteFch\":\"11-15-2022\",\"anula_comp_rechazado\":\"N\"}','2022-11-15 10:56:49','2022-11-15 10:56:51',NULL,NULL,NULL,NULL,40719,40736,7,1,NULL,NULL,NULL,NULL,0.00,24000.00,1,1.00,'2022-11-15 10:56:51'),(2,7847,'2022-11-15','2022-11-01','2022-11-30','2022-11-15',2,1,7,'','{\"Tipo\":null,\"PtoVta\":null,\"Nro\":null,\"CbteFch\":\"11-15-2022\",\"anula_comp_rechazado\":\"N\"}','2022-11-15 10:57:12','2022-11-15 10:57:13','72465895878563','2022-11-25','1','2022-11-25',40719,40736,7,1,NULL,NULL,NULL,NULL,0.00,24000.00,1,1.00,NULL),(3,7847,'2022-11-15','2022-11-01','2022-11-30','2022-11-15',2,1,7,'','{\"Tipo\":null,\"PtoVta\":null,\"Nro\":null,\"CbteFch\":\"11-15-2022\",\"anula_comp_rechazado\":\"N\"}','2022-11-15 11:06:07','2022-11-15 11:06:09','72465897130613','2022-11-25','2','2022-11-25',40719,40735,7,1,NULL,NULL,NULL,NULL,0.00,12000.00,1,1.00,NULL);
/*!40000 ALTER TABLE `fact_elec_receipts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_tipos_docs_afip`
--

DROP TABLE IF EXISTS `fact_elec_tipos_docs_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_tipos_docs_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `afip_tipo_doc_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=100 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_tipos_docs_afip`
--

LOCK TABLES `fact_elec_tipos_docs_afip` WRITE;
/*!40000 ALTER TABLE `fact_elec_tipos_docs_afip` DISABLE KEYS */;
INSERT INTO `fact_elec_tipos_docs_afip` VALUES (1,1,'CI Buenos Aires','2019-03-13 13:29:34','2019-03-13 13:29:34'),(2,2,'CI Catamarca','2019-03-13 13:29:34','2019-03-13 13:29:34'),(3,3,'CI Córdoba','2019-03-13 13:29:34','2019-03-13 13:29:34'),(4,4,'CI Corrientes','2019-03-13 13:29:34','2019-03-13 13:29:34'),(5,5,'CI Entre Ríos','2019-03-13 13:29:34','2019-03-13 13:29:34'),(6,6,'CI Jujuy','2019-03-13 13:29:34','2019-03-13 13:29:34'),(7,7,'CI Mendoza','2019-03-13 13:29:34','2019-03-13 13:29:34'),(8,8,'CI La Rioja','2019-03-13 13:29:34','2019-03-13 13:29:34'),(9,9,'CI Salta','2019-03-13 13:29:34','2019-03-13 13:29:34'),(10,10,'CI San Juan','2019-03-13 13:29:34','2019-03-13 13:29:34'),(11,11,'CI San Luis','2019-03-13 13:29:34','2019-03-13 13:29:34'),(12,12,'CI Santa Fe','2019-03-13 13:29:34','2019-03-13 13:29:34'),(13,13,'CI Santiago del Estero','2019-03-13 13:29:34','2019-03-13 13:29:34'),(14,14,'CI Tucumán','2019-03-13 13:29:34','2019-03-13 13:29:34'),(16,16,'CI Chaco','2019-03-13 13:29:34','2019-03-13 13:29:34'),(17,17,'CI Chubut','2019-03-13 13:29:34','2019-03-13 13:29:34'),(18,18,'CI Formosa','2019-03-13 13:29:34','2019-03-13 13:29:34'),(19,19,'CI Misiones','2019-03-13 13:29:34','2019-03-13 13:29:34'),(20,20,'CI Neuquén','2019-03-13 13:29:34','2019-03-13 13:29:34'),(21,21,'CI La Pampa','2019-03-13 13:29:34','2019-03-13 13:29:34'),(22,22,'CI Río Negro','2019-03-13 13:29:34','2019-03-13 13:29:34'),(23,23,'CI Santa Cruz','2019-03-13 13:29:34','2019-03-13 13:29:34'),(24,24,'CI Tierra del Fuego','2019-03-13 13:29:34','2019-03-13 13:29:34'),(80,80,'CUIT','2019-03-13 13:29:34','2019-03-13 13:29:34'),(86,86,'CUIL','2019-03-13 13:29:34','2019-03-13 13:29:34'),(87,87,'CDI','2019-03-13 13:29:34','2019-03-13 13:29:34'),(89,89,'LE','2019-03-13 13:29:34','2019-03-13 13:29:34'),(90,90,'LC','2019-03-13 13:29:34','2019-03-13 13:29:34'),(91,91,'CI Extranjera','2019-03-13 13:29:34','2019-03-13 13:29:34'),(92,92,'en trámite','2019-03-13 13:29:34','2019-03-13 13:29:34'),(93,93,'Acta Nacimiento','2019-03-13 13:29:34','2019-03-13 13:29:34'),(94,94,'Pasaporte','2019-03-13 13:29:34','2019-03-13 13:29:34'),(95,95,'CI Bs. As. RNP','2019-03-13 13:29:34','2019-03-13 13:29:34'),(96,96,'DNI','2019-03-13 13:29:34','2019-03-13 13:29:34'),(97,0,'CI Policía Federal','2019-03-13 13:29:34','2019-03-13 13:29:34'),(99,99,'Doc. (Otro)','2019-03-13 13:29:34','2019-03-13 13:29:34');
/*!40000 ALTER TABLE `fact_elec_tipos_docs_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
INSERT INTO `failed_jobs` VALUES (1,NULL,'database','finance','{\"uuid\":\"aa424dee-6ae2-4493-93d8-a0245a1ebf9c\",\"displayName\":\"App\\\\Jobs\\\\QueueGenerica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"delay\":null,\"timeout\":null,\"timeoutAt\":null,\"data\":{\"commandName\":\"App\\\\Jobs\\\\QueueGenerica\",\"command\":\"O:22:\\\"App\\\\Jobs\\\\QueueGenerica\\\":9:{s:28:\\\"\\u0000App\\\\Jobs\\\\QueueGenerica\\u0000data\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":4:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:11:\\\"controlador\\\";s:55:\\\"\\\\App\\\\Http\\\\Controllers\\\\Data\\\\BOTMisComprobantesController\\\";s:6:\\\"metodo\\\";s:21:\\\"Execute_Bot_Descargar\\\";s:9:\\\"variables\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":11:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:4:\\\"user\\\";O:8:\\\"App\\\\User\\\":28:{s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:6:\\\"tusers\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:6:\\\"idUser\\\";s:11:\\\"\\u0000*\\u0000fillable\\\";a:12:{i:0;s:6:\\\"nombre\\\";i:1;s:9:\\\"loginUser\\\";i:2;s:9:\\\"emailUser\\\";i:3;s:5:\\\"clave\\\";i:4;s:9:\\\"claveUser\\\";i:5;s:10:\\\"statusUser\\\";i:6;s:12:\\\"user_type_id\\\";i:7;s:5:\\\"firma\\\";i:8;s:15:\\\"suscrip_plan_id\\\";i:9;s:7:\\\"importe\\\";i:10;s:6:\\\"avatar\\\";i:11;s:18:\\\"es_empresa_externa\\\";}s:9:\\\"\\u0000*\\u0000hidden\\\";a:4:{i:0;s:8:\\\"password\\\";i:1;s:14:\\\"remember_token\\\";i:2;s:9:\\\"claveUser\\\";i:3;s:5:\\\"clave\\\";}s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:17:{s:6:\\\"idUser\\\";i:7847;s:6:\\\"nombre\\\";s:29:\\\"Maldonado sosa Silvana lorena\\\";s:9:\\\"loginUser\\\";s:29:\\\"estudiocontablems02@gmail.com\\\";s:9:\\\"emailUser\\\";s:29:\\\"estudiocontablems02@gmail.com\\\";s:5:\\\"clave\\\";s:11:\\\"27304735215\\\";s:9:\\\"claveUser\\\";s:60:\\\"$2y$10$jlHW7mYVOb3xPFharvThwuzSfHHqCuvZ4Fk.A1JpIsAaeRvLVQAje\\\";s:5:\\\"firma\\\";N;s:6:\\\"avatar\\\";N;s:10:\\\"statusUser\\\";i:1;s:14:\\\"remember_token\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2022-09-15 14:36:58\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-09-15 14:36:58\\\";s:12:\\\"user_type_id\\\";i:1;s:18:\\\"es_empresa_externa\\\";i:0;s:15:\\\"suscrip_plan_id\\\";i:1;s:7:\\\"importe\\\";s:4:\\\"0.00\\\";s:6:\\\"person\\\";O:17:\\\"App\\\\Models\\\\Person\\\":27:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:7:\\\"persons\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:21:{s:2:\\\"id\\\";i:48170;s:7:\\\"user_id\\\";i:1;s:11:\\\"field_name1\\\";s:29:\\\"Maldonado sosa Silvana lorena\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-30473521-5\\\";s:21:\\\"cond_frente_al_iva_id\\\";N;s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:20:\\\"iva_creditos_tipo_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-01-09 14:51:02\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-01-09 14:51:02\\\";s:11:\\\"activity_id\\\";N;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";N;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:21:{s:2:\\\"id\\\";i:48170;s:7:\\\"user_id\\\";i:1;s:11:\\\"field_name1\\\";s:29:\\\"Maldonado sosa Silvana lorena\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-30473521-5\\\";s:21:\\\"cond_frente_al_iva_id\\\";N;s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:20:\\\"iva_creditos_tipo_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-01-09 14:51:02\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-01-09 14:51:02\\\";s:11:\\\"activity_id\\\";N;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";N;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}}s:11:\\\"\\u0000*\\u0000original\\\";a:16:{s:6:\\\"idUser\\\";i:7847;s:6:\\\"nombre\\\";s:29:\\\"Maldonado sosa Silvana lorena\\\";s:9:\\\"loginUser\\\";s:29:\\\"estudiocontablems02@gmail.com\\\";s:9:\\\"emailUser\\\";s:29:\\\"estudiocontablems02@gmail.com\\\";s:5:\\\"clave\\\";s:11:\\\"27304735215\\\";s:9:\\\"claveUser\\\";s:60:\\\"$2y$10$jlHW7mYVOb3xPFharvThwuzSfHHqCuvZ4Fk.A1JpIsAaeRvLVQAje\\\";s:5:\\\"firma\\\";N;s:6:\\\"avatar\\\";N;s:10:\\\"statusUser\\\";i:1;s:14:\\\"remember_token\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2022-09-15 14:36:58\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-09-15 14:36:58\\\";s:12:\\\"user_type_id\\\";i:1;s:18:\\\"es_empresa_externa\\\";i:0;s:15:\\\"suscrip_plan_id\\\";i:1;s:7:\\\"importe\\\";s:4:\\\"0.00\\\";}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:1:{i:0;s:1:\\\"*\\\";}s:20:\\\"\\u0000*\\u0000rememberTokenName\\\";s:14:\\\"remember_token\\\";}s:15:\\\"cuit_user_admin\\\";s:15:\\\"\'27-30473521-5\'\\\";s:23:\\\"cuit_administrador_afip\\\";s:11:\\\"20334211461\\\";s:12:\\\"clave_fiscal\\\";s:13:\\\"Royalexis2022\\\";s:12:\\\"cuit_empresa\\\";s:13:\\\"20-33421146-1\\\";s:5:\\\"sitio\\\";s:12:\\\"taxes.com.ar\\\";s:9:\\\"operacion\\\";s:8:\\\"Emitidos\\\";s:7:\\\"periodo\\\";s:10:\\\"Mes Pasado\\\";s:12:\\\"path_of_file\\\";O:21:\\\"App\\\\Models\\\\PathOfFile\\\":28:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:12:\\\"path_of_file\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:1;s:13:\\\"\\u0000*\\u0000attributes\\\";a:6:{s:7:\\\"user_id\\\";i:7847;s:20:\\\"path_of_file_name_id\\\";i:6;s:11:\\\"descripcion\\\";s:49:\\\"ALEXIS ROY ORTIZ Comprobantes Emitidos Mes Pasado\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-09-17 19:31:36\\\";s:10:\\\"created_at\\\";s:19:\\\"2022-09-17 19:31:36\\\";s:2:\\\"id\\\";i:1;}s:11:\\\"\\u0000*\\u0000original\\\";a:6:{s:7:\\\"user_id\\\";i:7847;s:20:\\\"path_of_file_name_id\\\";i:6;s:11:\\\"descripcion\\\";s:49:\\\"ALEXIS ROY ORTIZ Comprobantes Emitidos Mes Pasado\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-09-17 19:31:36\\\";s:10:\\\"created_at\\\";s:19:\\\"2022-09-17 19:31:36\\\";s:2:\\\"id\\\";i:1;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:1:{i:0;s:10:\\\"deleted_at\\\";}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}s:4:\\\"path\\\";s:14:\\\"27-30473521-5\\/\\\";}}s:3:\\\"job\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";s:7:\\\"finance\\\";s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:5:\\\"delay\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}','Symfony\\Component\\Process\\Exception\\ProcessTimedOutException: The process \"node /home/forge/taxes.com.ar/resources/js/puppeteer/ImportarMisComprobantes.js 20334211461 Royalexis2022 20-33421146-1 Emitidos \"Mes Pasado\" \'27-30473521-5\'\" exceeded the timeout of 60 seconds. in /home/forge/taxes.com.ar/vendor/symfony/process/Process.php:1213\nStack trace:\n#0 /home/forge/taxes.com.ar/vendor/symfony/process/Process.php(425): Symfony\\Component\\Process\\Process->checkTimeout()\n#1 /home/forge/taxes.com.ar/vendor/symfony/process/Process.php(249): Symfony\\Component\\Process\\Process->wait()\n#2 /home/forge/taxes.com.ar/app/Http/Controllers/Data/BOTMisComprobantesController.php(94): Symfony\\Component\\Process\\Process->run()\n#3 /home/forge/taxes.com.ar/app/Jobs/QueueGenerica.php(36): App\\Http\\Controllers\\Data\\BOTMisComprobantesController->Execute_Bot_Descargar(Object(Illuminate\\Support\\Collection))\n#4 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): App\\Jobs\\QueueGenerica->handle()\n#5 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#6 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#7 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#8 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#9 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Bus/Dispatcher.php(94): Illuminate\\Container\\Container->call(Array)\n#10 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(128): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#11 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(103): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#12 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Bus/Dispatcher.php(98): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#13 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(83): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(App\\Jobs\\QueueGenerica), false)\n#14 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(128): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#15 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(103): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#16 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(85): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#17 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(59): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(App\\Queue\\DatabaseJob), Object(App\\Jobs\\QueueGenerica))\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Jobs/Job.php(98): Illuminate\\Queue\\CallQueuedHandler->call(Object(App\\Queue\\DatabaseJob), Array)\n#19 /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php(26): Illuminate\\Queue\\Jobs\\Job->fire()\n#20 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(356): App\\Queue\\DatabaseJob->fire()\n#21 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(306): Illuminate\\Queue\\Worker->process(\'database\', Object(App\\Queue\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#22 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(265): Illuminate\\Queue\\Worker->runJob(Object(App\\Queue\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#23 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(112): Illuminate\\Queue\\Worker->runNextJob(\'database\', \'finance\', Object(Illuminate\\Queue\\WorkerOptions))\n#24 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(96): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'finance\')\n#25 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#26 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#27 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#28 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#29 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#30 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(134): Illuminate\\Container\\Container->call(Array)\n#31 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(256): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#32 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(121): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#33 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(971): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#34 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(290): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#35 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(166): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#36 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Application.php(93): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#37 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(129): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#38 /home/forge/taxes.com.ar/artisan(35): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#39 {main}','2022-09-17 19:32:37',NULL);
INSERT INTO `failed_jobs` VALUES (2,NULL,'database','finance','{\"uuid\":\"bb0fbace-0b20-491a-a2eb-d8986b3884fd\",\"displayName\":\"App\\\\Jobs\\\\QueueGenerica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"delay\":null,\"timeout\":null,\"timeoutAt\":null,\"data\":{\"commandName\":\"App\\\\Jobs\\\\QueueGenerica\",\"command\":\"O:22:\\\"App\\\\Jobs\\\\QueueGenerica\\\":9:{s:28:\\\"\\u0000App\\\\Jobs\\\\QueueGenerica\\u0000data\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":4:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:11:\\\"controlador\\\";s:55:\\\"\\\\App\\\\Http\\\\Controllers\\\\Data\\\\BOTMisComprobantesController\\\";s:6:\\\"metodo\\\";s:21:\\\"Execute_Bot_Descargar\\\";s:9:\\\"variables\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":11:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:4:\\\"user\\\";O:8:\\\"App\\\\User\\\":28:{s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:6:\\\"tusers\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:6:\\\"idUser\\\";s:11:\\\"\\u0000*\\u0000fillable\\\";a:12:{i:0;s:6:\\\"nombre\\\";i:1;s:9:\\\"loginUser\\\";i:2;s:9:\\\"emailUser\\\";i:3;s:5:\\\"clave\\\";i:4;s:9:\\\"claveUser\\\";i:5;s:10:\\\"statusUser\\\";i:6;s:12:\\\"user_type_id\\\";i:7;s:5:\\\"firma\\\";i:8;s:15:\\\"suscrip_plan_id\\\";i:9;s:7:\\\"importe\\\";i:10;s:6:\\\"avatar\\\";i:11;s:18:\\\"es_empresa_externa\\\";}s:9:\\\"\\u0000*\\u0000hidden\\\";a:4:{i:0;s:8:\\\"password\\\";i:1;s:14:\\\"remember_token\\\";i:2;s:9:\\\"claveUser\\\";i:3;s:5:\\\"clave\\\";}s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:17:{s:6:\\\"idUser\\\";i:7847;s:6:\\\"nombre\\\";s:29:\\\"Maldonado sosa Silvana lorena\\\";s:9:\\\"loginUser\\\";s:29:\\\"estudiocontablems02@gmail.com\\\";s:9:\\\"emailUser\\\";s:29:\\\"estudiocontablems02@gmail.com\\\";s:5:\\\"clave\\\";s:11:\\\"27304735215\\\";s:9:\\\"claveUser\\\";s:60:\\\"$2y$10$jlHW7mYVOb3xPFharvThwuzSfHHqCuvZ4Fk.A1JpIsAaeRvLVQAje\\\";s:5:\\\"firma\\\";N;s:6:\\\"avatar\\\";N;s:10:\\\"statusUser\\\";i:1;s:14:\\\"remember_token\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2022-09-15 14:36:58\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-09-15 14:36:58\\\";s:12:\\\"user_type_id\\\";i:1;s:18:\\\"es_empresa_externa\\\";i:0;s:15:\\\"suscrip_plan_id\\\";i:1;s:7:\\\"importe\\\";s:4:\\\"0.00\\\";s:6:\\\"person\\\";O:17:\\\"App\\\\Models\\\\Person\\\":27:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:7:\\\"persons\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:21:{s:2:\\\"id\\\";i:48170;s:7:\\\"user_id\\\";i:1;s:11:\\\"field_name1\\\";s:29:\\\"Maldonado sosa Silvana lorena\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-30473521-5\\\";s:21:\\\"cond_frente_al_iva_id\\\";N;s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:20:\\\"iva_creditos_tipo_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-01-09 14:51:02\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-01-09 14:51:02\\\";s:11:\\\"activity_id\\\";N;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";N;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:21:{s:2:\\\"id\\\";i:48170;s:7:\\\"user_id\\\";i:1;s:11:\\\"field_name1\\\";s:29:\\\"Maldonado sosa Silvana lorena\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-30473521-5\\\";s:21:\\\"cond_frente_al_iva_id\\\";N;s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:20:\\\"iva_creditos_tipo_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-01-09 14:51:02\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-01-09 14:51:02\\\";s:11:\\\"activity_id\\\";N;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";N;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}}s:11:\\\"\\u0000*\\u0000original\\\";a:16:{s:6:\\\"idUser\\\";i:7847;s:6:\\\"nombre\\\";s:29:\\\"Maldonado sosa Silvana lorena\\\";s:9:\\\"loginUser\\\";s:29:\\\"estudiocontablems02@gmail.com\\\";s:9:\\\"emailUser\\\";s:29:\\\"estudiocontablems02@gmail.com\\\";s:5:\\\"clave\\\";s:11:\\\"27304735215\\\";s:9:\\\"claveUser\\\";s:60:\\\"$2y$10$jlHW7mYVOb3xPFharvThwuzSfHHqCuvZ4Fk.A1JpIsAaeRvLVQAje\\\";s:5:\\\"firma\\\";N;s:6:\\\"avatar\\\";N;s:10:\\\"statusUser\\\";i:1;s:14:\\\"remember_token\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2022-09-15 14:36:58\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-09-15 14:36:58\\\";s:12:\\\"user_type_id\\\";i:1;s:18:\\\"es_empresa_externa\\\";i:0;s:15:\\\"suscrip_plan_id\\\";i:1;s:7:\\\"importe\\\";s:4:\\\"0.00\\\";}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:1:{i:0;s:1:\\\"*\\\";}s:20:\\\"\\u0000*\\u0000rememberTokenName\\\";s:14:\\\"remember_token\\\";}s:15:\\\"cuit_user_admin\\\";s:15:\\\"\'27-30473521-5\'\\\";s:23:\\\"cuit_administrador_afip\\\";s:11:\\\"20334211461\\\";s:12:\\\"clave_fiscal\\\";s:13:\\\"Royalexis2022\\\";s:12:\\\"cuit_empresa\\\";s:13:\\\"20-33421146-1\\\";s:5:\\\"sitio\\\";s:12:\\\"taxes.com.ar\\\";s:9:\\\"operacion\\\";s:8:\\\"Emitidos\\\";s:7:\\\"periodo\\\";s:10:\\\"Mes Pasado\\\";s:12:\\\"path_of_file\\\";O:21:\\\"App\\\\Models\\\\PathOfFile\\\":28:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:12:\\\"path_of_file\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:1;s:13:\\\"\\u0000*\\u0000attributes\\\";a:6:{s:7:\\\"user_id\\\";i:7847;s:20:\\\"path_of_file_name_id\\\";i:6;s:11:\\\"descripcion\\\";s:49:\\\"ALEXIS ROY ORTIZ Comprobantes Emitidos Mes Pasado\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-09-17 19:42:22\\\";s:10:\\\"created_at\\\";s:19:\\\"2022-09-17 19:42:22\\\";s:2:\\\"id\\\";i:2;}s:11:\\\"\\u0000*\\u0000original\\\";a:6:{s:7:\\\"user_id\\\";i:7847;s:20:\\\"path_of_file_name_id\\\";i:6;s:11:\\\"descripcion\\\";s:49:\\\"ALEXIS ROY ORTIZ Comprobantes Emitidos Mes Pasado\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-09-17 19:42:22\\\";s:10:\\\"created_at\\\";s:19:\\\"2022-09-17 19:42:22\\\";s:2:\\\"id\\\";i:2;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:1:{i:0;s:10:\\\"deleted_at\\\";}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}s:4:\\\"path\\\";s:14:\\\"27-30473521-5\\/\\\";}}s:3:\\\"job\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";s:7:\\\"finance\\\";s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:5:\\\"delay\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}','Symfony\\Component\\Process\\Exception\\ProcessTimedOutException: The process \"node /home/forge/taxes.com.ar/resources/js/puppeteer/ImportarMisComprobantes.js 20334211461 Royalexis2022 20-33421146-1 Emitidos \"Mes Pasado\" \'27-30473521-5\'\" exceeded the timeout of 60 seconds. in /home/forge/taxes.com.ar/vendor/symfony/process/Process.php:1213\nStack trace:\n#0 /home/forge/taxes.com.ar/vendor/symfony/process/Process.php(425): Symfony\\Component\\Process\\Process->checkTimeout()\n#1 /home/forge/taxes.com.ar/vendor/symfony/process/Process.php(249): Symfony\\Component\\Process\\Process->wait()\n#2 /home/forge/taxes.com.ar/app/Http/Controllers/Data/BOTMisComprobantesController.php(94): Symfony\\Component\\Process\\Process->run()\n#3 /home/forge/taxes.com.ar/app/Jobs/QueueGenerica.php(36): App\\Http\\Controllers\\Data\\BOTMisComprobantesController->Execute_Bot_Descargar(Object(Illuminate\\Support\\Collection))\n#4 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): App\\Jobs\\QueueGenerica->handle()\n#5 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#6 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#7 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#8 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#9 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Bus/Dispatcher.php(94): Illuminate\\Container\\Container->call(Array)\n#10 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(128): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#11 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(103): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#12 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Bus/Dispatcher.php(98): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#13 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(83): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(App\\Jobs\\QueueGenerica), false)\n#14 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(128): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#15 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(103): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#16 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(85): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#17 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(59): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(App\\Queue\\DatabaseJob), Object(App\\Jobs\\QueueGenerica))\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Jobs/Job.php(98): Illuminate\\Queue\\CallQueuedHandler->call(Object(App\\Queue\\DatabaseJob), Array)\n#19 /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php(26): Illuminate\\Queue\\Jobs\\Job->fire()\n#20 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(356): App\\Queue\\DatabaseJob->fire()\n#21 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(306): Illuminate\\Queue\\Worker->process(\'database\', Object(App\\Queue\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#22 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(265): Illuminate\\Queue\\Worker->runJob(Object(App\\Queue\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#23 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(112): Illuminate\\Queue\\Worker->runNextJob(\'database\', \'finance\', Object(Illuminate\\Queue\\WorkerOptions))\n#24 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(96): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'finance\')\n#25 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#26 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#27 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#28 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#29 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#30 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(134): Illuminate\\Container\\Container->call(Array)\n#31 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(256): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#32 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(121): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#33 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(971): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#34 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(290): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#35 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(166): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#36 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Application.php(93): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#37 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(129): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#38 /home/forge/taxes.com.ar/artisan(35): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#39 {main}','2022-09-17 19:43:22',NULL);
INSERT INTO `failed_jobs` VALUES (3,NULL,'database','finance','{\"uuid\":\"d13798f0-1a46-4b2e-b57a-fc12aace5c67\",\"displayName\":\"App\\\\Jobs\\\\QueueGenerica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"delay\":null,\"timeout\":null,\"timeoutAt\":null,\"data\":{\"commandName\":\"App\\\\Jobs\\\\QueueGenerica\",\"command\":\"O:22:\\\"App\\\\Jobs\\\\QueueGenerica\\\":9:{s:28:\\\"\\u0000App\\\\Jobs\\\\QueueGenerica\\u0000data\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":4:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:11:\\\"controlador\\\";s:55:\\\"\\\\App\\\\Http\\\\Controllers\\\\Data\\\\BOTMisComprobantesController\\\";s:6:\\\"metodo\\\";s:21:\\\"Execute_Bot_Descargar\\\";s:9:\\\"variables\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":11:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:4:\\\"user\\\";O:8:\\\"App\\\\User\\\":28:{s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:6:\\\"tusers\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:6:\\\"idUser\\\";s:11:\\\"\\u0000*\\u0000fillable\\\";a:12:{i:0;s:6:\\\"nombre\\\";i:1;s:9:\\\"loginUser\\\";i:2;s:9:\\\"emailUser\\\";i:3;s:5:\\\"clave\\\";i:4;s:9:\\\"claveUser\\\";i:5;s:10:\\\"statusUser\\\";i:6;s:12:\\\"user_type_id\\\";i:7;s:5:\\\"firma\\\";i:8;s:15:\\\"suscrip_plan_id\\\";i:9;s:7:\\\"importe\\\";i:10;s:6:\\\"avatar\\\";i:11;s:18:\\\"es_empresa_externa\\\";}s:9:\\\"\\u0000*\\u0000hidden\\\";a:4:{i:0;s:8:\\\"password\\\";i:1;s:14:\\\"remember_token\\\";i:2;s:9:\\\"claveUser\\\";i:3;s:5:\\\"clave\\\";}s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:17:{s:6:\\\"idUser\\\";i:7847;s:6:\\\"nombre\\\";s:29:\\\"Maldonado sosa Silvana lorena\\\";s:9:\\\"loginUser\\\";s:29:\\\"estudiocontablems02@gmail.com\\\";s:9:\\\"emailUser\\\";s:29:\\\"estudiocontablems02@gmail.com\\\";s:5:\\\"clave\\\";s:11:\\\"27304735215\\\";s:9:\\\"claveUser\\\";s:60:\\\"$2y$10$jlHW7mYVOb3xPFharvThwuzSfHHqCuvZ4Fk.A1JpIsAaeRvLVQAje\\\";s:5:\\\"firma\\\";N;s:6:\\\"avatar\\\";N;s:10:\\\"statusUser\\\";i:1;s:14:\\\"remember_token\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2022-09-15 14:36:58\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-09-15 14:36:58\\\";s:12:\\\"user_type_id\\\";i:1;s:18:\\\"es_empresa_externa\\\";i:0;s:15:\\\"suscrip_plan_id\\\";i:1;s:7:\\\"importe\\\";s:4:\\\"0.00\\\";s:6:\\\"person\\\";O:17:\\\"App\\\\Models\\\\Person\\\":27:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:7:\\\"persons\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:21:{s:2:\\\"id\\\";i:48170;s:7:\\\"user_id\\\";i:1;s:11:\\\"field_name1\\\";s:29:\\\"Maldonado sosa Silvana lorena\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-30473521-5\\\";s:21:\\\"cond_frente_al_iva_id\\\";N;s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:20:\\\"iva_creditos_tipo_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-01-09 14:51:02\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-01-09 14:51:02\\\";s:11:\\\"activity_id\\\";N;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";N;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:21:{s:2:\\\"id\\\";i:48170;s:7:\\\"user_id\\\";i:1;s:11:\\\"field_name1\\\";s:29:\\\"Maldonado sosa Silvana lorena\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-30473521-5\\\";s:21:\\\"cond_frente_al_iva_id\\\";N;s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:20:\\\"iva_creditos_tipo_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-01-09 14:51:02\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-01-09 14:51:02\\\";s:11:\\\"activity_id\\\";N;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";N;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}}s:11:\\\"\\u0000*\\u0000original\\\";a:16:{s:6:\\\"idUser\\\";i:7847;s:6:\\\"nombre\\\";s:29:\\\"Maldonado sosa Silvana lorena\\\";s:9:\\\"loginUser\\\";s:29:\\\"estudiocontablems02@gmail.com\\\";s:9:\\\"emailUser\\\";s:29:\\\"estudiocontablems02@gmail.com\\\";s:5:\\\"clave\\\";s:11:\\\"27304735215\\\";s:9:\\\"claveUser\\\";s:60:\\\"$2y$10$jlHW7mYVOb3xPFharvThwuzSfHHqCuvZ4Fk.A1JpIsAaeRvLVQAje\\\";s:5:\\\"firma\\\";N;s:6:\\\"avatar\\\";N;s:10:\\\"statusUser\\\";i:1;s:14:\\\"remember_token\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2022-09-15 14:36:58\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-09-15 14:36:58\\\";s:12:\\\"user_type_id\\\";i:1;s:18:\\\"es_empresa_externa\\\";i:0;s:15:\\\"suscrip_plan_id\\\";i:1;s:7:\\\"importe\\\";s:4:\\\"0.00\\\";}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:1:{i:0;s:1:\\\"*\\\";}s:20:\\\"\\u0000*\\u0000rememberTokenName\\\";s:14:\\\"remember_token\\\";}s:15:\\\"cuit_user_admin\\\";s:15:\\\"\'27-30473521-5\'\\\";s:23:\\\"cuit_administrador_afip\\\";s:11:\\\"20334211461\\\";s:12:\\\"clave_fiscal\\\";s:13:\\\"Royalexis2022\\\";s:12:\\\"cuit_empresa\\\";s:13:\\\"20-33421146-1\\\";s:5:\\\"sitio\\\";s:12:\\\"taxes.com.ar\\\";s:9:\\\"operacion\\\";s:8:\\\"Emitidos\\\";s:7:\\\"periodo\\\";s:10:\\\"Mes Pasado\\\";s:12:\\\"path_of_file\\\";O:21:\\\"App\\\\Models\\\\PathOfFile\\\":28:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:12:\\\"path_of_file\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:1;s:13:\\\"\\u0000*\\u0000attributes\\\";a:6:{s:7:\\\"user_id\\\";i:7847;s:20:\\\"path_of_file_name_id\\\";i:6;s:11:\\\"descripcion\\\";s:49:\\\"ALEXIS ROY ORTIZ Comprobantes Emitidos Mes Pasado\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-10-12 00:22:40\\\";s:10:\\\"created_at\\\";s:19:\\\"2022-10-12 00:22:40\\\";s:2:\\\"id\\\";i:4;}s:11:\\\"\\u0000*\\u0000original\\\";a:6:{s:7:\\\"user_id\\\";i:7847;s:20:\\\"path_of_file_name_id\\\";i:6;s:11:\\\"descripcion\\\";s:49:\\\"ALEXIS ROY ORTIZ Comprobantes Emitidos Mes Pasado\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-10-12 00:22:40\\\";s:10:\\\"created_at\\\";s:19:\\\"2022-10-12 00:22:40\\\";s:2:\\\"id\\\";i:4;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:1:{i:0;s:10:\\\"deleted_at\\\";}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}s:4:\\\"path\\\";s:14:\\\"27-30473521-5\\/\\\";}}s:3:\\\"job\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";s:7:\\\"finance\\\";s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:5:\\\"delay\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}','Symfony\\Component\\Process\\Exception\\ProcessTimedOutException: The process \"node /home/forge/taxes.com.ar/resources/js/puppeteer/ImportarMisComprobantes.js 20334211461 Royalexis2022 20-33421146-1 Emitidos \"Mes Pasado\" \'27-30473521-5\'\" exceeded the timeout of 60 seconds. in /home/forge/taxes.com.ar/vendor/symfony/process/Process.php:1213\nStack trace:\n#0 /home/forge/taxes.com.ar/vendor/symfony/process/Process.php(425): Symfony\\Component\\Process\\Process->checkTimeout()\n#1 /home/forge/taxes.com.ar/vendor/symfony/process/Process.php(249): Symfony\\Component\\Process\\Process->wait()\n#2 /home/forge/taxes.com.ar/app/Http/Controllers/Data/BOTMisComprobantesController.php(94): Symfony\\Component\\Process\\Process->run()\n#3 /home/forge/taxes.com.ar/app/Jobs/QueueGenerica.php(36): App\\Http\\Controllers\\Data\\BOTMisComprobantesController->Execute_Bot_Descargar(Object(Illuminate\\Support\\Collection))\n#4 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): App\\Jobs\\QueueGenerica->handle()\n#5 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#6 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#7 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#8 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#9 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Bus/Dispatcher.php(94): Illuminate\\Container\\Container->call(Array)\n#10 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(128): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#11 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(103): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#12 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Bus/Dispatcher.php(98): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#13 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(83): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(App\\Jobs\\QueueGenerica), false)\n#14 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(128): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#15 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(103): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#16 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(85): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#17 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(59): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(App\\Queue\\DatabaseJob), Object(App\\Jobs\\QueueGenerica))\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Jobs/Job.php(98): Illuminate\\Queue\\CallQueuedHandler->call(Object(App\\Queue\\DatabaseJob), Array)\n#19 /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php(26): Illuminate\\Queue\\Jobs\\Job->fire()\n#20 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(356): App\\Queue\\DatabaseJob->fire()\n#21 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(306): Illuminate\\Queue\\Worker->process(\'database\', Object(App\\Queue\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#22 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(265): Illuminate\\Queue\\Worker->runJob(Object(App\\Queue\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#23 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(112): Illuminate\\Queue\\Worker->runNextJob(\'database\', \'finance\', Object(Illuminate\\Queue\\WorkerOptions))\n#24 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(96): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'finance\')\n#25 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#26 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#27 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#28 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#29 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#30 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(134): Illuminate\\Container\\Container->call(Array)\n#31 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(256): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#32 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(121): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#33 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(971): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#34 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(290): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#35 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(166): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#36 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Application.php(93): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#37 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(129): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#38 /home/forge/taxes.com.ar/artisan(35): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#39 {main}','2022-10-12 00:23:41',NULL);
INSERT INTO `failed_jobs` VALUES (4,NULL,'database','finance','{\"uuid\":\"8f117556-11e3-49f5-8b1c-141c509a6cd3\",\"displayName\":\"App\\\\Jobs\\\\QueueGenerica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"delay\":null,\"timeout\":null,\"timeoutAt\":null,\"data\":{\"commandName\":\"App\\\\Jobs\\\\QueueGenerica\",\"command\":\"O:22:\\\"App\\\\Jobs\\\\QueueGenerica\\\":9:{s:28:\\\"\\u0000App\\\\Jobs\\\\QueueGenerica\\u0000data\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":4:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:11:\\\"controlador\\\";s:55:\\\"\\\\App\\\\Http\\\\Controllers\\\\Data\\\\BOTMisComprobantesController\\\";s:6:\\\"metodo\\\";s:21:\\\"Execute_Bot_Descargar\\\";s:9:\\\"variables\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":11:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:4:\\\"user\\\";O:8:\\\"App\\\\User\\\":28:{s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:6:\\\"tusers\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:6:\\\"idUser\\\";s:11:\\\"\\u0000*\\u0000fillable\\\";a:12:{i:0;s:6:\\\"nombre\\\";i:1;s:9:\\\"loginUser\\\";i:2;s:9:\\\"emailUser\\\";i:3;s:5:\\\"clave\\\";i:4;s:9:\\\"claveUser\\\";i:5;s:10:\\\"statusUser\\\";i:6;s:12:\\\"user_type_id\\\";i:7;s:5:\\\"firma\\\";i:8;s:15:\\\"suscrip_plan_id\\\";i:9;s:7:\\\"importe\\\";i:10;s:6:\\\"avatar\\\";i:11;s:18:\\\"es_empresa_externa\\\";}s:9:\\\"\\u0000*\\u0000hidden\\\";a:4:{i:0;s:8:\\\"password\\\";i:1;s:14:\\\"remember_token\\\";i:2;s:9:\\\"claveUser\\\";i:3;s:5:\\\"clave\\\";}s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:17:{s:6:\\\"idUser\\\";i:7847;s:6:\\\"nombre\\\";s:29:\\\"Maldonado sosa Silvana lorena\\\";s:9:\\\"loginUser\\\";s:29:\\\"estudiocontablems02@gmail.com\\\";s:9:\\\"emailUser\\\";s:29:\\\"estudiocontablems02@gmail.com\\\";s:5:\\\"clave\\\";s:11:\\\"27304735215\\\";s:9:\\\"claveUser\\\";s:60:\\\"$2y$10$jlHW7mYVOb3xPFharvThwuzSfHHqCuvZ4Fk.A1JpIsAaeRvLVQAje\\\";s:5:\\\"firma\\\";N;s:6:\\\"avatar\\\";N;s:10:\\\"statusUser\\\";i:1;s:14:\\\"remember_token\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2022-09-15 14:36:58\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-09-15 14:36:58\\\";s:12:\\\"user_type_id\\\";i:1;s:18:\\\"es_empresa_externa\\\";i:0;s:15:\\\"suscrip_plan_id\\\";i:1;s:7:\\\"importe\\\";s:4:\\\"0.00\\\";s:6:\\\"person\\\";O:17:\\\"App\\\\Models\\\\Person\\\":27:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:7:\\\"persons\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:21:{s:2:\\\"id\\\";i:48170;s:7:\\\"user_id\\\";i:1;s:11:\\\"field_name1\\\";s:29:\\\"Maldonado sosa Silvana lorena\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-30473521-5\\\";s:21:\\\"cond_frente_al_iva_id\\\";N;s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:20:\\\"iva_creditos_tipo_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-01-09 14:51:02\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-01-09 14:51:02\\\";s:11:\\\"activity_id\\\";N;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";N;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:21:{s:2:\\\"id\\\";i:48170;s:7:\\\"user_id\\\";i:1;s:11:\\\"field_name1\\\";s:29:\\\"Maldonado sosa Silvana lorena\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-30473521-5\\\";s:21:\\\"cond_frente_al_iva_id\\\";N;s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:20:\\\"iva_creditos_tipo_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-01-09 14:51:02\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-01-09 14:51:02\\\";s:11:\\\"activity_id\\\";N;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";N;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}}s:11:\\\"\\u0000*\\u0000original\\\";a:16:{s:6:\\\"idUser\\\";i:7847;s:6:\\\"nombre\\\";s:29:\\\"Maldonado sosa Silvana lorena\\\";s:9:\\\"loginUser\\\";s:29:\\\"estudiocontablems02@gmail.com\\\";s:9:\\\"emailUser\\\";s:29:\\\"estudiocontablems02@gmail.com\\\";s:5:\\\"clave\\\";s:11:\\\"27304735215\\\";s:9:\\\"claveUser\\\";s:60:\\\"$2y$10$jlHW7mYVOb3xPFharvThwuzSfHHqCuvZ4Fk.A1JpIsAaeRvLVQAje\\\";s:5:\\\"firma\\\";N;s:6:\\\"avatar\\\";N;s:10:\\\"statusUser\\\";i:1;s:14:\\\"remember_token\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2022-09-15 14:36:58\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-09-15 14:36:58\\\";s:12:\\\"user_type_id\\\";i:1;s:18:\\\"es_empresa_externa\\\";i:0;s:15:\\\"suscrip_plan_id\\\";i:1;s:7:\\\"importe\\\";s:4:\\\"0.00\\\";}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:1:{i:0;s:1:\\\"*\\\";}s:20:\\\"\\u0000*\\u0000rememberTokenName\\\";s:14:\\\"remember_token\\\";}s:15:\\\"cuit_user_admin\\\";s:15:\\\"\'27-30473521-5\'\\\";s:23:\\\"cuit_administrador_afip\\\";s:11:\\\"20334211461\\\";s:12:\\\"clave_fiscal\\\";s:13:\\\"Royalexis2022\\\";s:12:\\\"cuit_empresa\\\";s:13:\\\"20-33421146-1\\\";s:5:\\\"sitio\\\";s:12:\\\"taxes.com.ar\\\";s:9:\\\"operacion\\\";s:8:\\\"Emitidos\\\";s:7:\\\"periodo\\\";s:8:\\\"Este Mes\\\";s:12:\\\"path_of_file\\\";O:21:\\\"App\\\\Models\\\\PathOfFile\\\":28:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:12:\\\"path_of_file\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:1;s:13:\\\"\\u0000*\\u0000attributes\\\";a:6:{s:7:\\\"user_id\\\";i:7847;s:20:\\\"path_of_file_name_id\\\";i:6;s:11:\\\"descripcion\\\";s:47:\\\"ALEXIS ROY ORTIZ Comprobantes Emitidos Este Mes\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-10-12 00:23:25\\\";s:10:\\\"created_at\\\";s:19:\\\"2022-10-12 00:23:25\\\";s:2:\\\"id\\\";i:5;}s:11:\\\"\\u0000*\\u0000original\\\";a:6:{s:7:\\\"user_id\\\";i:7847;s:20:\\\"path_of_file_name_id\\\";i:6;s:11:\\\"descripcion\\\";s:47:\\\"ALEXIS ROY ORTIZ Comprobantes Emitidos Este Mes\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-10-12 00:23:25\\\";s:10:\\\"created_at\\\";s:19:\\\"2022-10-12 00:23:25\\\";s:2:\\\"id\\\";i:5;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:1:{i:0;s:10:\\\"deleted_at\\\";}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}s:4:\\\"path\\\";s:14:\\\"27-30473521-5\\/\\\";}}s:3:\\\"job\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";s:7:\\\"finance\\\";s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:5:\\\"delay\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}','Symfony\\Component\\Process\\Exception\\ProcessTimedOutException: The process \"node /home/forge/taxes.com.ar/resources/js/puppeteer/ImportarMisComprobantes.js 20334211461 Royalexis2022 20-33421146-1 Emitidos \"Este Mes\" \'27-30473521-5\'\" exceeded the timeout of 60 seconds. in /home/forge/taxes.com.ar/vendor/symfony/process/Process.php:1213\nStack trace:\n#0 /home/forge/taxes.com.ar/vendor/symfony/process/Process.php(425): Symfony\\Component\\Process\\Process->checkTimeout()\n#1 /home/forge/taxes.com.ar/vendor/symfony/process/Process.php(249): Symfony\\Component\\Process\\Process->wait()\n#2 /home/forge/taxes.com.ar/app/Http/Controllers/Data/BOTMisComprobantesController.php(94): Symfony\\Component\\Process\\Process->run()\n#3 /home/forge/taxes.com.ar/app/Jobs/QueueGenerica.php(36): App\\Http\\Controllers\\Data\\BOTMisComprobantesController->Execute_Bot_Descargar(Object(Illuminate\\Support\\Collection))\n#4 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): App\\Jobs\\QueueGenerica->handle()\n#5 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#6 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#7 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#8 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#9 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Bus/Dispatcher.php(94): Illuminate\\Container\\Container->call(Array)\n#10 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(128): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#11 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(103): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#12 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Bus/Dispatcher.php(98): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#13 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(83): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(App\\Jobs\\QueueGenerica), false)\n#14 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(128): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#15 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(103): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#16 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(85): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#17 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(59): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(App\\Queue\\DatabaseJob), Object(App\\Jobs\\QueueGenerica))\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Jobs/Job.php(98): Illuminate\\Queue\\CallQueuedHandler->call(Object(App\\Queue\\DatabaseJob), Array)\n#19 /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php(26): Illuminate\\Queue\\Jobs\\Job->fire()\n#20 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(356): App\\Queue\\DatabaseJob->fire()\n#21 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(306): Illuminate\\Queue\\Worker->process(\'database\', Object(App\\Queue\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#22 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(265): Illuminate\\Queue\\Worker->runJob(Object(App\\Queue\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#23 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(112): Illuminate\\Queue\\Worker->runNextJob(\'database\', \'finance\', Object(Illuminate\\Queue\\WorkerOptions))\n#24 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(96): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'finance\')\n#25 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#26 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#27 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#28 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#29 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#30 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(134): Illuminate\\Container\\Container->call(Array)\n#31 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(256): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#32 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(121): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#33 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(971): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#34 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(290): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#35 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(166): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#36 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Application.php(93): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#37 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(129): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#38 /home/forge/taxes.com.ar/artisan(35): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#39 {main}','2022-10-12 00:24:26',NULL);
INSERT INTO `failed_jobs` VALUES (5,NULL,'database','default','{\"uuid\":\"2b5e2273-265e-457e-a83e-6e6b9f98b333\",\"displayName\":\"App\\\\Mail\\\\AvisoDeVencimientos\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"delay\":null,\"timeout\":null,\"timeoutAt\":null,\"data\":{\"commandName\":\"Illuminate\\\\Mail\\\\SendQueuedMailable\",\"command\":\"O:34:\\\"Illuminate\\\\Mail\\\\SendQueuedMailable\\\":3:{s:8:\\\"mailable\\\";O:28:\\\"App\\\\Mail\\\\AvisoDeVencimientos\\\":29:{s:6:\\\"abuela\\\";O:45:\\\"Illuminate\\\\Contracts\\\\Database\\\\ModelIdentifier\\\":4:{s:5:\\\"class\\\";s:21:\\\"App\\\\Models\\\\Tdbabuelas\\\";s:2:\\\"id\\\";i:6787;s:9:\\\"relations\\\";a:2:{i:0;s:6:\\\"person\\\";i:1;s:4:\\\"user\\\";}s:10:\\\"connection\\\";s:9:\\\"seguridad\\\";}s:12:\\\"dataFiltrada\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":1:{s:8:\\\"\\u0000*\\u0000items\\\";a:1:{i:0;O:37:\\\"App\\\\Models\\\\Vto_Person_Impuesto_Creado\\\":27:{s:8:\\\"\\u0000*\\u0000table\\\";s:28:\\\"vto_person_impuestos_creados\\\";s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:8:{s:2:\\\"id\\\";i:40719;s:7:\\\"empresa\\\";s:29:\\\"Maldonado sosa Silvana lorena\\\";s:8:\\\"impuesto\\\";s:21:\\\"Honorarios Pendientes\\\";s:9:\\\"categoria\\\";N;s:8:\\\"anticipo\\\";s:20:\\\"Honorarios Atrasados\\\";s:11:\\\"vencimiento\\\";s:10:\\\"2022-10-01\\\";s:7:\\\"importe\\\";s:7:\\\"1000.00\\\";s:7:\\\"titular\\\";i:40719;}s:11:\\\"\\u0000*\\u0000original\\\";a:7:{s:2:\\\"id\\\";i:40719;s:7:\\\"empresa\\\";s:29:\\\"Maldonado sosa Silvana lorena\\\";s:8:\\\"impuesto\\\";s:21:\\\"Honorarios Pendientes\\\";s:9:\\\"categoria\\\";N;s:8:\\\"anticipo\\\";s:20:\\\"Honorarios Atrasados\\\";s:11:\\\"vencimiento\\\";s:10:\\\"2022-10-01\\\";s:7:\\\"importe\\\";s:7:\\\"1000.00\\\";}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}}}s:8:\\\"empresas\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":1:{s:8:\\\"\\u0000*\\u0000items\\\";a:1:{i:0;O:8:\\\"stdClass\\\":21:{s:2:\\\"id\\\";i:40719;s:7:\\\"user_id\\\";i:7847;s:11:\\\"field_name1\\\";s:29:\\\"Maldonado sosa Silvana lorena\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-30473521-5\\\";s:21:\\\"cond_frente_al_iva_id\\\";N;s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:20:\\\"iva_creditos_tipo_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-01-09 17:51:02\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-11-10 12:44:43\\\";s:11:\\\"activity_id\\\";N;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";i:1;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}}}s:6:\\\"origen\\\";s:4:\\\"mail\\\";s:6:\\\"locale\\\";N;s:4:\\\"from\\\";a:0:{}s:2:\\\"to\\\";a:1:{i:0;a:2:{s:4:\\\"name\\\";N;s:7:\\\"address\\\";s:29:\\\"estudiocontablems02@gmail.com\\\";}}s:2:\\\"cc\\\";a:0:{}s:3:\\\"bcc\\\";a:1:{i:0;a:2:{s:4:\\\"name\\\";N;s:7:\\\"address\\\";s:29:\\\"estudiocontablems02@gmail.com\\\";}}s:7:\\\"replyTo\\\";a:0:{}s:7:\\\"subject\\\";N;s:11:\\\"\\u0000*\\u0000markdown\\\";N;s:7:\\\"\\u0000*\\u0000html\\\";N;s:4:\\\"view\\\";N;s:8:\\\"textView\\\";N;s:8:\\\"viewData\\\";a:0:{}s:11:\\\"attachments\\\";a:0:{}s:14:\\\"rawAttachments\\\";a:0:{}s:15:\\\"diskAttachments\\\";a:0:{}s:9:\\\"callbacks\\\";a:0:{}s:5:\\\"theme\\\";N;s:6:\\\"mailer\\\";s:8:\\\"sendgrid\\\";s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:5:\\\"delay\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;}\"}}','GuzzleHttp\\Exception\\ClientException: Client error: `POST https://api.sendgrid.com/v3/mail/send` resulted in a `400 Bad Request` response:\n{\"errors\":[{\"message\":\"Each email address in the personalization block should be unique between to, cc, and bcc. We foun (truncated...)\n in /home/forge/taxes.com.ar/vendor/guzzlehttp/guzzle/src/Exception/RequestException.php:113\nStack trace:\n#0 /home/forge/taxes.com.ar/vendor/guzzlehttp/guzzle/src/Middleware.php(69): GuzzleHttp\\Exception\\RequestException::create(Object(GuzzleHttp\\Psr7\\Request), Object(GuzzleHttp\\Psr7\\Response), NULL, Array, NULL)\n#1 /home/forge/taxes.com.ar/vendor/guzzlehttp/promises/src/Promise.php(204): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Response))\n#2 /home/forge/taxes.com.ar/vendor/guzzlehttp/promises/src/Promise.php(153): GuzzleHttp\\Promise\\Promise::callHandler(1, Object(GuzzleHttp\\Psr7\\Response), NULL)\n#3 /home/forge/taxes.com.ar/vendor/guzzlehttp/promises/src/TaskQueue.php(48): GuzzleHttp\\Promise\\Promise::GuzzleHttp\\Promise\\{closure}()\n#4 /home/forge/taxes.com.ar/vendor/guzzlehttp/promises/src/Promise.php(248): GuzzleHttp\\Promise\\TaskQueue->run(true)\n#5 /home/forge/taxes.com.ar/vendor/guzzlehttp/promises/src/Promise.php(224): GuzzleHttp\\Promise\\Promise->invokeWaitFn()\n#6 /home/forge/taxes.com.ar/vendor/guzzlehttp/promises/src/Promise.php(269): GuzzleHttp\\Promise\\Promise->waitIfPending()\n#7 /home/forge/taxes.com.ar/vendor/guzzlehttp/promises/src/Promise.php(226): GuzzleHttp\\Promise\\Promise->invokeWaitList()\n#8 /home/forge/taxes.com.ar/vendor/guzzlehttp/promises/src/Promise.php(62): GuzzleHttp\\Promise\\Promise->waitIfPending()\n#9 /home/forge/taxes.com.ar/vendor/guzzlehttp/guzzle/src/Client.php(187): GuzzleHttp\\Promise\\Promise->wait()\n#10 /home/forge/taxes.com.ar/vendor/s-ichikawa/laravel-sendgrid-driver/src/Transport/SendgridTransport.php(304): GuzzleHttp\\Client->request(\'POST\', \'https://api.sen...\', Array)\n#11 /home/forge/taxes.com.ar/vendor/s-ichikawa/laravel-sendgrid-driver/src/Transport/SendgridTransport.php(77): Sichikawa\\LaravelSendgridDriver\\Transport\\SendgridTransport->post(Array)\n#12 /home/forge/taxes.com.ar/vendor/swiftmailer/swiftmailer/lib/classes/Swift/Mailer.php(71): Sichikawa\\LaravelSendgridDriver\\Transport\\SendgridTransport->send(Object(Swift_Message), Array)\n#13 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Mail/Mailer.php(521): Swift_Mailer->send(Object(Swift_Message), Array)\n#14 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Mail/Mailer.php(288): Illuminate\\Mail\\Mailer->sendSwiftMessage(Object(Swift_Message))\n#15 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Mail/Mailable.php(177): Illuminate\\Mail\\Mailer->send(\'administracion....\', Array, Object(Closure))\n#16 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Support/Traits/Localizable.php(19): Illuminate\\Mail\\Mailable->Illuminate\\Mail\\{closure}()\n#17 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Mail/Mailable.php(178): Illuminate\\Mail\\Mailable->withLocale(NULL, Object(Closure))\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Mail/SendQueuedMailable.php(52): Illuminate\\Mail\\Mailable->send(Object(Illuminate\\Mail\\MailManager))\n#19 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Mail\\SendQueuedMailable->handle(Object(Illuminate\\Mail\\MailManager))\n#20 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#21 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#22 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#23 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#24 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Bus/Dispatcher.php(94): Illuminate\\Container\\Container->call(Array)\n#25 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(128): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Mail\\SendQueuedMailable))\n#26 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(103): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Mail\\SendQueuedMailable))\n#27 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Bus/Dispatcher.php(98): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#28 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(83): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Mail\\SendQueuedMailable), false)\n#29 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(128): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Mail\\SendQueuedMailable))\n#30 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(103): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Mail\\SendQueuedMailable))\n#31 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(85): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#32 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(59): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(App\\Queue\\DatabaseJob), Object(Illuminate\\Mail\\SendQueuedMailable))\n#33 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Jobs/Job.php(98): Illuminate\\Queue\\CallQueuedHandler->call(Object(App\\Queue\\DatabaseJob), Array)\n#34 /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php(26): Illuminate\\Queue\\Jobs\\Job->fire()\n#35 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(356): App\\Queue\\DatabaseJob->fire()\n#36 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(306): Illuminate\\Queue\\Worker->process(\'database\', Object(App\\Queue\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(132): Illuminate\\Queue\\Worker->runJob(Object(App\\Queue\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(112): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(96): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(134): Illuminate\\Container\\Container->call(Array)\n#46 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(256): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#47 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(121): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#48 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(971): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#49 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(290): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#50 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(166): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#51 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Application.php(93): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#52 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(129): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#53 /home/forge/taxes.com.ar/artisan(35): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#54 {main}','2022-11-17 12:38:40',NULL);
INSERT INTO `failed_jobs` VALUES (6,NULL,'database','finance','{\"uuid\":\"4377dc33-5ace-426d-acac-aa727b9e67e7\",\"displayName\":\"App\\\\Jobs\\\\QueueGenerica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"delay\":null,\"timeout\":null,\"timeoutAt\":null,\"data\":{\"commandName\":\"App\\\\Jobs\\\\QueueGenerica\",\"command\":\"O:22:\\\"App\\\\Jobs\\\\QueueGenerica\\\":9:{s:28:\\\"\\u0000App\\\\Jobs\\\\QueueGenerica\\u0000data\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":5:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:11:\\\"controlador\\\";s:53:\\\"\\\\App\\\\Http\\\\Controllers\\\\Taxes\\\\BOTCopiarEnAfipController\\\";s:6:\\\"metodo\\\";s:26:\\\"Execute_Bot_Copiar_en_Afip\\\";s:12:\\\"metodo_error\\\";s:15:\\\"error_queue_bot\\\";s:9:\\\"variables\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":7:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:4:\\\"user\\\";O:8:\\\"App\\\\User\\\":28:{s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:6:\\\"tusers\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:6:\\\"idUser\\\";s:10:\\\"\\u0000*\\u0000appends\\\";a:1:{i:0;s:24:\\\"usuario_madre_habilitado\\\";}s:11:\\\"\\u0000*\\u0000fillable\\\";a:12:{i:0;s:6:\\\"nombre\\\";i:1;s:9:\\\"loginUser\\\";i:2;s:9:\\\"emailUser\\\";i:3;s:5:\\\"clave\\\";i:4;s:9:\\\"claveUser\\\";i:5;s:10:\\\"statusUser\\\";i:6;s:12:\\\"user_type_id\\\";i:7;s:5:\\\"firma\\\";i:8;s:15:\\\"suscrip_plan_id\\\";i:9;s:7:\\\"importe\\\";i:10;s:6:\\\"avatar\\\";i:11;s:18:\\\"es_empresa_externa\\\";}s:9:\\\"\\u0000*\\u0000hidden\\\";a:4:{i:0;s:8:\\\"password\\\";i:1;s:14:\\\"remember_token\\\";i:2;s:9:\\\"claveUser\\\";i:3;s:5:\\\"clave\\\";}s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:17:{s:6:\\\"idUser\\\";i:7847;s:6:\\\"nombre\\\";s:29:\\\"Maldonado sosa Silvana lorena\\\";s:9:\\\"loginUser\\\";s:29:\\\"estudiocontablems02@gmail.com\\\";s:9:\\\"emailUser\\\";s:29:\\\"estudiocontablems02@gmail.com\\\";s:5:\\\"clave\\\";s:11:\\\"27304735215\\\";s:9:\\\"claveUser\\\";s:60:\\\"$2y$10$jlHW7mYVOb3xPFharvThwuzSfHHqCuvZ4Fk.A1JpIsAaeRvLVQAje\\\";s:5:\\\"firma\\\";N;s:6:\\\"avatar\\\";N;s:10:\\\"statusUser\\\";i:1;s:14:\\\"remember_token\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2022-09-15 14:36:58\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-09-15 14:36:58\\\";s:12:\\\"user_type_id\\\";i:1;s:18:\\\"es_empresa_externa\\\";i:0;s:15:\\\"suscrip_plan_id\\\";i:1;s:7:\\\"importe\\\";s:4:\\\"0.00\\\";s:6:\\\"person\\\";O:17:\\\"App\\\\Models\\\\Person\\\":27:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:7:\\\"persons\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:21:{s:2:\\\"id\\\";i:48170;s:7:\\\"user_id\\\";i:1;s:11:\\\"field_name1\\\";s:29:\\\"Maldonado sosa Silvana lorena\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-30473521-5\\\";s:21:\\\"cond_frente_al_iva_id\\\";N;s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:20:\\\"iva_creditos_tipo_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-01-09 14:51:02\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-01-09 14:51:02\\\";s:11:\\\"activity_id\\\";N;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";N;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:21:{s:2:\\\"id\\\";i:48170;s:7:\\\"user_id\\\";i:1;s:11:\\\"field_name1\\\";s:29:\\\"Maldonado sosa Silvana lorena\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"27-30473521-5\\\";s:21:\\\"cond_frente_al_iva_id\\\";N;s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:20:\\\"iva_creditos_tipo_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-01-09 14:51:02\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-01-09 14:51:02\\\";s:11:\\\"activity_id\\\";N;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";N;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}}s:11:\\\"\\u0000*\\u0000original\\\";a:16:{s:6:\\\"idUser\\\";i:7847;s:6:\\\"nombre\\\";s:29:\\\"Maldonado sosa Silvana lorena\\\";s:9:\\\"loginUser\\\";s:29:\\\"estudiocontablems02@gmail.com\\\";s:9:\\\"emailUser\\\";s:29:\\\"estudiocontablems02@gmail.com\\\";s:5:\\\"clave\\\";s:11:\\\"27304735215\\\";s:9:\\\"claveUser\\\";s:60:\\\"$2y$10$jlHW7mYVOb3xPFharvThwuzSfHHqCuvZ4Fk.A1JpIsAaeRvLVQAje\\\";s:5:\\\"firma\\\";N;s:6:\\\"avatar\\\";N;s:10:\\\"statusUser\\\";i:1;s:14:\\\"remember_token\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2022-09-15 14:36:58\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-09-15 14:36:58\\\";s:12:\\\"user_type_id\\\";i:1;s:18:\\\"es_empresa_externa\\\";i:0;s:15:\\\"suscrip_plan_id\\\";i:1;s:7:\\\"importe\\\";s:4:\\\"0.00\\\";}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:1:{i:0;s:1:\\\"*\\\";}s:20:\\\"\\u0000*\\u0000rememberTokenName\\\";s:14:\\\"remember_token\\\";}s:23:\\\"cuit_administrador_afip\\\";s:11:\\\"27386665031\\\";s:12:\\\"clave_fiscal\\\";s:11:\\\"Micaela2022\\\";s:5:\\\"sitio\\\";s:12:\\\"taxes.com.ar\\\";s:6:\\\"settle\\\";O:28:\\\"App\\\\Models\\\\PeriodLiquidation\\\":28:{s:8:\\\"\\u0000*\\u0000table\\\";s:19:\\\"period_liquidations\\\";s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:9:\\\"\\u0000*\\u0000hidden\\\";a:2:{i:0;s:10:\\\"created_at\\\";i:1;s:10:\\\"updated_at\\\";}s:10:\\\"\\u0000*\\u0000appends\\\";a:1:{i:0;s:15:\\\"files_relations\\\";}s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:10:{s:2:\\\"id\\\";i:26;s:7:\\\"user_id\\\";i:7847;s:8:\\\"apply_to\\\";s:3:\\\"iva\\\";s:9:\\\"period_id\\\";i:6100;s:9:\\\"person_id\\\";i:40736;s:6:\\\"status\\\";i:1;s:11:\\\"auxiliar_id\\\";i:5756;s:10:\\\"created_at\\\";s:19:\\\"2022-11-23 10:26:24\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-11-23 11:08:36\\\";s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:10:{s:2:\\\"id\\\";i:26;s:7:\\\"user_id\\\";i:7847;s:8:\\\"apply_to\\\";s:3:\\\"iva\\\";s:9:\\\"period_id\\\";i:6100;s:9:\\\"person_id\\\";i:40736;s:6:\\\"status\\\";i:1;s:11:\\\"auxiliar_id\\\";i:5756;s:10:\\\"created_at\\\";s:19:\\\"2022-11-23 10:26:24\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-11-23 11:08:36\\\";s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:2:{s:11:\\\"auxiliar_id\\\";i:5756;s:10:\\\"updated_at\\\";s:19:\\\"2022-11-23 11:08:36\\\";}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:1:{i:0;s:10:\\\"deleted_at\\\";}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}s:8:\\\"auxiliar\\\";O:19:\\\"App\\\\Models\\\\Auxiliar\\\":27:{s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:8:\\\"auxiliar\\\";s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:1;s:13:\\\"\\u0000*\\u0000attributes\\\";a:5:{s:11:\\\"descripcion\\\";s:178801:\\\"{\\\"totales\\\":{\\\"period_liquidation_id\\\":26,\\\"period_id\\\":6100,\\\"person_id\\\":40736,\\\"total_debit\\\":58473.4,\\\"total_credit\\\":510771.04,\\\"credito_fiscal_comp\\\":\\\"0.00\\\",\\\"previous_technical\\\":\\\"0.00\\\",\\\"technical_balance\\\":\\\"452297.64\\\",\\\"previous_free_availability\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"compensation_amount\\\":\\\"0.00\\\",\\\"total_perceptions_retentions\\\":\\\"0.00\\\",\\\"free_availability_balance\\\":\\\"0.00\\\",\\\"pago_a_cuenta\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"452297.64\\\",\\\"total_free_availability\\\":\\\"0.00\\\",\\\"saldo_pago_a_cuenta\\\":\\\"0.00\\\",\\\"total_debito_mis_comp\\\":\\\"0.00\\\",\\\"total_credito_mis_comp\\\":\\\"0.00\\\",\\\"comentarios\\\":null},\\\"actividades\\\":[{\\\"id\\\":11,\\\"user_id\\\":7847,\\\"person_id\\\":40736,\\\"activity_id\\\":580,\\\"is_principal\\\":1,\\\"created_at\\\":\\\"2022-10-30T10:06:46.000000Z\\\",\\\"updated_at\\\":\\\"2022-10-30T10:06:46.000000Z\\\",\\\"deleted_at\\\":null,\\\"type\\\":1,\\\"actividad\\\":{\\\"id\\\":580,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Venta al por menor de productos alimenticios n.c.p., en comercios especializados\\\",\\\"codigo_afip\\\":\\\"472190\\\",\\\"codigo_cm\\\":null,\\\"total_iva\\\":30009.55,\\\"total_gravado\\\":142902.62}},{\\\"id\\\":12,\\\"user_id\\\":7847,\\\"person_id\\\":40736,\\\"activity_id\\\":611,\\\"is_principal\\\":0,\\\"created_at\\\":\\\"2022-10-30T10:06:46.000000Z\\\",\\\"updated_at\\\":\\\"2022-10-30T10:06:46.000000Z\\\",\\\"deleted_at\\\":null,\\\"type\\\":1,\\\"actividad\\\":{\\\"id\\\":611,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"name\\\":\\\"Venta al por menor de indumentaria para beb\\u00e9s y ni\\u00f1os\\\",\\\"codigo_afip\\\":\\\"477130\\\",\\\"codigo_cm\\\":null,\\\"total_iva\\\":28463.85,\\\"total_gravado\\\":135542.13}}],\\\"iva_creditos_tipos\\\":[{\\\"id\\\":1,\\\"user_id\\\":0,\\\"descripcion\\\":\\\"Compras de bienes (excepto bienes de uso)\\\",\\\"total\\\":510771.04,\\\"habilitado\\\":1,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"deleted_at\\\":null},{\\\"id\\\":2,\\\"user_id\\\":0,\\\"descripcion\\\":\\\"Locaciones\\\",\\\"total\\\":0,\\\"habilitado\\\":1,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"deleted_at\\\":null},{\\\"id\\\":3,\\\"user_id\\\":0,\\\"descripcion\\\":\\\"Prestaciones de servicios\\\",\\\"total\\\":0,\\\"habilitado\\\":1,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"deleted_at\\\":null},{\\\"id\\\":4,\\\"user_id\\\":0,\\\"descripcion\\\":\\\"Inversiones de Bienes de Uso\\\",\\\"total\\\":0,\\\"habilitado\\\":1,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"deleted_at\\\":null},{\\\"id\\\":5,\\\"user_id\\\":0,\\\"descripcion\\\":\\\"Compras de bienes usados a consumidores finales\\\",\\\"total\\\":0,\\\"habilitado\\\":1,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"deleted_at\\\":null},{\\\"id\\\":6,\\\"user_id\\\":0,\\\"descripcion\\\":\\\"Tur IVA\\\",\\\"total\\\":0,\\\"habilitado\\\":1,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"deleted_at\\\":null},{\\\"id\\\":7,\\\"user_id\\\":0,\\\"descripcion\\\":\\\"Contribuciones de la Seguridad Social\\\",\\\"total\\\":0,\\\"habilitado\\\":1,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"deleted_at\\\":null},{\\\"id\\\":8,\\\"user_id\\\":0,\\\"descripcion\\\":\\\"Contribuciones de la Seguridad Social - Art\\u00edculo 91 Ley 27.467\\\",\\\"total\\\":0,\\\"habilitado\\\":1,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"deleted_at\\\":null},{\\\"id\\\":9,\\\"user_id\\\":0,\\\"descripcion\\\":\\\"Otros Conceptos\\\",\\\"total\\\":0,\\\"habilitado\\\":1,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"deleted_at\\\":null},{\\\"id\\\":10,\\\"user_id\\\":0,\\\"descripcion\\\":\\\"Compras de Bienes en el Exterior\\\",\\\"total\\\":0,\\\"habilitado\\\":1,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"deleted_at\\\":null},{\\\"id\\\":11,\\\"user_id\\\":0,\\\"descripcion\\\":\\\"Compras de Servicios en el exterior - Impuesto ingresado a trav\\u00e9s de entidades Financieras\\\",\\\"total\\\":0,\\\"habilitado\\\":1,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"deleted_at\\\":null},{\\\"id\\\":12,\\\"user_id\\\":0,\\\"descripcion\\\":\\\"Compras de Servicios en el exterior - Impuesto ingresado por el responsable\\\",\\\"total\\\":0,\\\"habilitado\\\":1,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"deleted_at\\\":null},{\\\"id\\\":13,\\\"user_id\\\":0,\\\"descripcion\\\":\\\"Locaciones o prestaciones gravadas en el pa\\u00eds realizadas por sujetos del exterior - Impuesto ingresado a trav\\u00e9s de entidades Financieras\\\",\\\"total\\\":0,\\\"habilitado\\\":1,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"deleted_at\\\":null},{\\\"id\\\":14,\\\"user_id\\\":0,\\\"descripcion\\\":\\\"R\\u00e9gimen especial de compensaci\\u00f3n para la estabilizaci\\u00f3n de precios - Emergencia alimentaria - Ley 27.519\\\",\\\"total\\\":0,\\\"habilitado\\\":1,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"deleted_at\\\":null}],\\\"origenes_ventas\\\":{\\\"0\\\":{\\\"id\\\":1,\\\"type\\\":1,\\\"ordr\\\":1,\\\"total\\\":\\\"0.00\\\",\\\"descripcion\\\":\\\"Operaciones con Responsables Inscriptos\\\",\\\"habilitado\\\":1,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"deleted_at\\\":null},\\\"1\\\":{\\\"id\\\":2,\\\"type\\\":1,\\\"ordr\\\":2,\\\"total\\\":\\\"0.00\\\",\\\"descripcion\\\":\\\"Operaciones con Consumidores finales, Exentos y No alcanzados\\\",\\\"habilitado\\\":1,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"deleted_at\\\":null},\\\"2\\\":{\\\"id\\\":3,\\\"type\\\":1,\\\"ordr\\\":3,\\\"total\\\":\\\"0.00\\\",\\\"descripcion\\\":\\\"Operaciones no gravadas y exentas\\\",\\\"habilitado\\\":1,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"deleted_at\\\":null},\\\"3\\\":{\\\"id\\\":4,\\\"type\\\":1,\\\"ordr\\\":4,\\\"total\\\":\\\"0.00\\\",\\\"descripcion\\\":\\\"Credito fiscal a restituir\\\",\\\"habilitado\\\":1,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"deleted_at\\\":null},\\\"7\\\":{\\\"id\\\":8,\\\"type\\\":1,\\\"ordr\\\":8,\\\"total\\\":\\\"0.00\\\",\\\"descripcion\\\":\\\"Operaciones con Monotributistas - Regimen Simmplificado\\\",\\\"habilitado\\\":1,\\\"created_at\\\":\\\"2022-09-15T17:37:22.000000Z\\\",\\\"updated_at\\\":\\\"2022-09-15T17:37:22.000000Z\\\",\\\"deleted_at\\\":null}},\\\"origenes_compras\\\":{\\\"4\\\":{\\\"id\\\":5,\\\"type\\\":2,\\\"ordr\\\":5,\\\"total\\\":\\\"0.00\\\",\\\"descripcion\\\":\\\"Debito fiscal a restituir\\\",\\\"habilitado\\\":1,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"deleted_at\\\":null},\\\"5\\\":{\\\"id\\\":6,\\\"type\\\":2,\\\"ordr\\\":6,\\\"total\\\":\\\"0.00\\\",\\\"descripcion\\\":\\\"Total Credito Fiscal\\\",\\\"habilitado\\\":1,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"deleted_at\\\":null},\\\"6\\\":{\\\"id\\\":7,\\\"type\\\":2,\\\"ordr\\\":7,\\\"total\\\":\\\"0.00\\\",\\\"descripcion\\\":\\\"Total Operaciones que no Generan Credito Fiscal\\\",\\\"habilitado\\\":1,\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"deleted_at\\\":null}},\\\"settle\\\":{\\\"id\\\":26,\\\"user_id\\\":7847,\\\"apply_to\\\":\\\"iva\\\",\\\"period_id\\\":6100,\\\"person_id\\\":40736,\\\"status\\\":1,\\\"auxiliar_id\\\":null,\\\"deleted_at\\\":null,\\\"files_relations\\\":[],\\\"period\\\":{\\\"id\\\":6100,\\\"user_id\\\":null,\\\"code\\\":\\\"2022-10\\\",\\\"year\\\":2022,\\\"period_number\\\":10,\\\"date_from\\\":\\\"2022-10-01\\\",\\\"date_to\\\":\\\"2022-10-31\\\",\\\"created_at\\\":null,\\\"updated_at\\\":null,\\\"person_id\\\":40736,\\\"conta_status\\\":0,\\\"deleted_at\\\":null,\\\"syj_periods_status_id\\\":1,\\\"syj_sin_asiento\\\":0,\\\"syj_asiento_modificado\\\":0,\\\"syj_periods_status_emp_dom_id\\\":1},\\\"period_liquidation_i_v_a\\\":{\\\"id\\\":6,\\\"user_id\\\":7847,\\\"period_liquidation_id\\\":26,\\\"period_id\\\":6100,\\\"person_id\\\":40736,\\\"total_debit\\\":\\\"58473.40\\\",\\\"total_debito_mis_comp\\\":\\\"0.00\\\",\\\"total_credit\\\":\\\"510771.04\\\",\\\"credito_fiscal_comp\\\":\\\"0.00\\\",\\\"total_credito_mis_comp\\\":\\\"0.00\\\",\\\"previous_technical\\\":\\\"0.00\\\",\\\"technical_balance\\\":\\\"452297.64\\\",\\\"previous_free_availability\\\":\\\"0.00\\\",\\\"retention_amount\\\":\\\"0.00\\\",\\\"perception_amount\\\":\\\"0.00\\\",\\\"compensation_amount\\\":\\\"0.00\\\",\\\"total_perceptions_retentions\\\":\\\"0.00\\\",\\\"free_availability_balance\\\":\\\"0.00\\\",\\\"pago_a_cuenta\\\":\\\"0.00\\\",\\\"negative_amount\\\":\\\"0.00\\\",\\\"positive_amount\\\":\\\"452297.64\\\",\\\"total_free_availability\\\":\\\"0.00\\\",\\\"saldo_pago_a_cuenta\\\":\\\"0.00\\\",\\\"comentarios\\\":null,\\\"created_at\\\":\\\"2022-11-23T13:26:24.000000Z\\\",\\\"updated_at\\\":\\\"2022-11-23T14:03:42.000000Z\\\",\\\"deleted_at\\\":null}},\\\"details\\\":[{\\\"id\\\":1297,\\\"user_id\\\":7847,\\\"period_liquidation_id\\\":26,\\\"period_liquidation_iva_id\\\":6,\\\"period_id\\\":6100,\\\"person_id\\\":40736,\\\"activity_id\\\":611,\\\"iva_creditos_tipo_id\\\":1,\\\"type\\\":1,\\\"tax_id\\\":3,\\\"taxabled_amount\\\":\\\"0.00\\\",\\\"iva_amount\\\":\\\"0.00\\\",\\\"created_at\\\":\\\"2022-11-23T16:26:24.000000Z\\\",\\\"updated_at\\\":\\\"2022-11-23T16:26:24.000000Z\\\",\\\"ordr\\\":1,\\\"deleted_at\\\":null,\\\"base\\\":\\\"0.00\\\",\\\"system_taxes\\\":{\\\"id\\\":3,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2020-04-16T13:33:23.000000Z\\\",\\\"name\\\":\\\"gravado al 27%\\\",\\\"apply_to\\\":\\\"iva\\\",\\\"ammount_permited\\\":1,\\\"percent_iva\\\":\\\"27.00\\\",\\\"taxable_iibb\\\":1,\\\"taxable_iva\\\":1,\\\"code\\\":6,\\\"status\\\":1,\\\"afip_alicuota_id\\\":6,\\\"plan_cuenta_id\\\":96,\\\"code_citi_alic_iva\\\":6}},{\\\"id\\\":1298,\\\"user_id\\\":7847,\\\"period_liquidation_id\\\":26,\\\"period_liquidation_iva_id\\\":6,\\\"period_id\\\":6100,\\\"person_id\\\":40736,\\\"activity_id\\\":580,\\\"iva_creditos_tipo_id\\\":1,\\\"type\\\":1,\\\"tax_id\\\":3,\\\"taxabled_amount\\\":\\\"0.00\\\",\\\"iva_amount\\\":\\\"0.00\\\",\\\"created_at\\\":\\\"2022-11-23T16:26:24.000000Z\\\",\\\"updated_at\\\":\\\"2022-11-23T16:26:24.000000Z\\\",\\\"ordr\\\":1,\\\"deleted_at\\\":null,\\\"base\\\":\\\"0.00\\\",\\\"system_taxes\\\":{\\\"id\\\":3,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2020-04-16T13:33:23.000000Z\\\",\\\"name\\\":\\\"gravado al 27%\\\",\\\"apply_to\\\":\\\"iva\\\",\\\"ammount_permited\\\":1,\\\"percent_iva\\\":\\\"27.00\\\",\\\"taxable_iibb\\\":1,\\\"taxable_iva\\\":1,\\\"code\\\":6,\\\"status\\\":1,\\\"afip_alicuota_id\\\":6,\\\"plan_cuenta_id\\\":96,\\\"code_citi_alic_iva\\\":6}},{\\\"id\\\":1299,\\\"user_id\\\":7847,\\\"period_liquidation_id\\\":26,\\\"period_liquidation_iva_id\\\":6,\\\"period_id\\\":6100,\\\"person_id\\\":40736,\\\"activity_id\\\":580,\\\"iva_creditos_tipo_id\\\":1,\\\"type\\\":1,\\\"tax_id\\\":2,\\\"taxabled_amount\\\":\\\"0.00\\\",\\\"iva_amount\\\":\\\"0.00\\\",\\\"created_at\\\":\\\"2022-11-23T16:26:24.000000Z\\\",\\\"updated_at\\\":\\\"2022-11-23T16:26:24.000000Z\\\",\\\"ordr\\\":1,\\\"deleted_at\\\":null,\\\"base\\\":\\\"0.00\\\",\\\"system_taxes\\\":{\\\"id\\\":2,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2020-04-16T13:33:23.000000Z\\\",\\\"name\\\":\\\"gravado al 21%\\\",\\\"apply_to\\\":\\\"iva\\\",\\\"ammount_permited\\\":1,\\\"percent_iva\\\":\\\"21.00\\\",\\\"taxable_iibb\\\":1,\\\"taxable_iva\\\":1,\\\"code\\\":5,\\\"status\\\":1,\\\"afip_alicuota_id\\\":5,\\\"plan_cuenta_id\\\":96,\\\"code_citi_alic_iva\\\":5}},{\\\"id\\\":1300,\\\"user_id\\\":7847,\\\"period_liquidation_id\\\":26,\\\"period_liquidation_iva_id\\\":6,\\\"period_id\\\":6100,\\\"person_id\\\":40736,\\\"activity_id\\\":611,\\\"iva_creditos_tipo_id\\\":1,\\\"type\\\":1,\\\"tax_id\\\":2,\\\"taxabled_amount\\\":\\\"0.00\\\",\\\"iva_amount\\\":\\\"0.00\\\",\\\"created_at\\\":\\\"2022-11-23T16:26:24.000000Z\\\",\\\"updated_at\\\":\\\"2022-11-23T16:26:24.000000Z\\\",\\\"ordr\\\":1,\\\"deleted_at\\\":null,\\\"base\\\":\\\"0.00\\\",\\\"system_taxes\\\":{\\\"id\\\":2,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2020-04-16T13:33:23.000000Z\\\",\\\"name\\\":\\\"gravado al 21%\\\",\\\"apply_to\\\":\\\"iva\\\",\\\"ammount_permited\\\":1,\\\"percent_iva\\\":\\\"21.00\\\",\\\"taxable_iibb\\\":1,\\\"taxable_iva\\\":1,\\\"code\\\":5,\\\"status\\\":1,\\\"afip_alicuota_id\\\":5,\\\"plan_cuenta_id\\\":96,\\\"code_citi_alic_iva\\\":5}},{\\\"id\\\":1301,\\\"user_id\\\":7847,\\\"period_liquidation_id\\\":26,\\\"period_liquidation_iva_id\\\":6,\\\"period_id\\\":6100,\\\"person_id\\\":40736,\\\"activity_id\\\":580,\\\"iva_creditos_tipo_id\\\":1,\\\"type\\\":1,\\\"tax_id\\\":1,\\\"taxabled_amount\\\":\\\"0.00\\\",\\\"iva_amount\\\":\\\"0.00\\\",\\\"created_at\\\":\\\"2022-11-23T16:26:24.000000Z\\\",\\\"updated_at\\\":\\\"2022-11-23T16:26:24.000000Z\\\",\\\"ordr\\\":1,\\\"deleted_at\\\":null,\\\"base\\\":\\\"0.00\\\",\\\"system_taxes\\\":{\\\"id\\\":1,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2020-04-16T13:33:23.000000Z\\\",\\\"name\\\":\\\"gravado al 10,5%\\\",\\\"apply_to\\\":\\\"iva\\\",\\\"ammount_permited\\\":1,\\\"percent_iva\\\":\\\"10.50\\\",\\\"taxable_iibb\\\":1,\\\"taxable_iva\\\":1,\\\"code\\\":4,\\\"status\\\":1,\\\"afip_alicuota_id\\\":4,\\\"plan_cuenta_id\\\":96,\\\"code_citi_alic_iva\\\":4}},{\\\"id\\\":1302,\\\"user_id\\\":7847,\\\"period_liquidation_id\\\":26,\\\"period_liquidation_iva_id\\\":6,\\\"period_id\\\":6100,\\\"person_id\\\":40736,\\\"activity_id\\\":611,\\\"iva_creditos_tipo_id\\\":1,\\\"type\\\":1,\\\"tax_id\\\":1,\\\"taxabled_amount\\\":\\\"0.00\\\",\\\"iva_amount\\\":\\\"0.00\\\",\\\"created_at\\\":\\\"2022-11-23T16:26:24.000000Z\\\",\\\"updated_at\\\":\\\"2022-11-23T16:26:24.000000Z\\\",\\\"ordr\\\":1,\\\"deleted_at\\\":null,\\\"base\\\":\\\"0.00\\\",\\\"system_taxes\\\":{\\\"id\\\":1,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2020-04-16T13:33:23.000000Z\\\",\\\"name\\\":\\\"gravado al 10,5%\\\",\\\"apply_to\\\":\\\"iva\\\",\\\"ammount_permited\\\":1,\\\"percent_iva\\\":\\\"10.50\\\",\\\"taxable_iibb\\\":1,\\\"taxable_iva\\\":1,\\\"code\\\":4,\\\"status\\\":1,\\\"afip_alicuota_id\\\":4,\\\"plan_cuenta_id\\\":96,\\\"code_citi_alic_iva\\\":4}},{\\\"id\\\":1303,\\\"user_id\\\":7847,\\\"period_liquidation_id\\\":26,\\\"period_liquidation_iva_id\\\":6,\\\"period_id\\\":6100,\\\"person_id\\\":40736,\\\"activity_id\\\":580,\\\"iva_creditos_tipo_id\\\":1,\\\"type\\\":1,\\\"tax_id\\\":5,\\\"taxabled_amount\\\":\\\"0.00\\\",\\\"iva_amount\\\":\\\"0.00\\\",\\\"created_at\\\":\\\"2022-11-23T16:26:24.000000Z\\\",\\\"updated_at\\\":\\\"2022-11-23T16:26:24.000000Z\\\",\\\"ordr\\\":1,\\\"deleted_at\\\":null,\\\"base\\\":\\\"0.00\\\",\\\"system_taxes\\\":{\\\"id\\\":5,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2020-04-16T13:33:23.000000Z\\\",\\\"name\\\":\\\"gravado al 5%\\\",\\\"apply_to\\\":\\\"iva\\\",\\\"ammount_permited\\\":1,\\\"percent_iva\\\":\\\"5.00\\\",\\\"taxable_iibb\\\":1,\\\"taxable_iva\\\":1,\\\"code\\\":8,\\\"status\\\":1,\\\"afip_alicuota_id\\\":8,\\\"plan_cuenta_id\\\":96,\\\"code_citi_alic_iva\\\":8}},{\\\"id\\\":1304,\\\"user_id\\\":7847,\\\"period_liquidation_id\\\":26,\\\"period_liquidation_iva_id\\\":6,\\\"period_id\\\":6100,\\\"person_id\\\":40736,\\\"activity_id\\\":611,\\\"iva_creditos_tipo_id\\\":1,\\\"type\\\":1,\\\"tax_id\\\":5,\\\"taxabled_amount\\\":\\\"0.00\\\",\\\"iva_amount\\\":\\\"0.00\\\",\\\"created_at\\\":\\\"2022-11-23T16:26:24.000000Z\\\",\\\"updated_at\\\":\\\"2022-11-23T16:26:24.000000Z\\\",\\\"ordr\\\":1,\\\"deleted_at\\\":null,\\\"base\\\":\\\"0.00\\\",\\\"system_taxes\\\":{\\\"id\\\":5,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2020-04-16T13:33:23.000000Z\\\",\\\"name\\\":\\\"gravado al 5%\\\",\\\"apply_to\\\":\\\"iva\\\",\\\"ammount_permited\\\":1,\\\"percent_iva\\\":\\\"5.00\\\",\\\"taxable_iibb\\\":1,\\\"taxable_iva\\\":1,\\\"code\\\":8,\\\"status\\\":1,\\\"afip_alicuota_id\\\":8,\\\"plan_cuenta_id\\\":96,\\\"code_citi_alic_iva\\\":8}},{\\\"id\\\":1305,\\\"user_id\\\":7847,\\\"period_liquidation_id\\\":26,\\\"period_liquidation_iva_id\\\":6,\\\"period_id\\\":6100,\\\"person_id\\\":40736,\\\"activity_id\\\":611,\\\"iva_creditos_tipo_id\\\":1,\\\"type\\\":1,\\\"tax_id\\\":4,\\\"taxabled_amount\\\":\\\"0.00\\\",\\\"iva_amount\\\":\\\"0.00\\\",\\\"created_at\\\":\\\"2022-11-23T16:26:24.000000Z\\\",\\\"updated_at\\\":\\\"2022-11-23T16:26:24.000000Z\\\",\\\"ordr\\\":1,\\\"deleted_at\\\":null,\\\"base\\\":\\\"0.00\\\",\\\"system_taxes\\\":{\\\"id\\\":4,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2020-04-16T13:33:23.000000Z\\\",\\\"name\\\":\\\"gravado al 2,5%\\\",\\\"apply_to\\\":\\\"iva\\\",\\\"ammount_permited\\\":1,\\\"percent_iva\\\":\\\"2.50\\\",\\\"taxable_iibb\\\":1,\\\"taxable_iva\\\":1,\\\"code\\\":9,\\\"status\\\":1,\\\"afip_alicuota_id\\\":9,\\\"plan_cuenta_id\\\":96,\\\"code_citi_alic_iva\\\":9}},{\\\"id\\\":1306,\\\"user_id\\\":7847,\\\"period_liquidation_id\\\":26,\\\"period_liquidation_iva_id\\\":6,\\\"period_id\\\":6100,\\\"person_id\\\":40736,\\\"activity_id\\\":580,\\\"iva_creditos_tipo_id\\\":1,\\\"type\\\":1,\\\"tax_id\\\":4,\\\"taxabled_amount\\\":\\\"0.00\\\",\\\"iva_amount\\\":\\\"0.00\\\",\\\"created_at\\\":\\\"2022-11-23T16:26:24.000000Z\\\",\\\"updated_at\\\":\\\"2022-11-23T16:26:24.000000Z\\\",\\\"ordr\\\":1,\\\"deleted_at\\\":null,\\\"base\\\":\\\"0.00\\\",\\\"system_taxes\\\":{\\\"id\\\":4,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2020-04-16T13:33:23.000000Z\\\",\\\"name\\\":\\\"gravado al 2,5%\\\",\\\"apply_to\\\":\\\"iva\\\",\\\"ammount_permited\\\":1,\\\"percent_iva\\\":\\\"2.50\\\",\\\"taxable_iibb\\\":1,\\\"taxable_iva\\\":1,\\\"code\\\":9,\\\"status\\\":1,\\\"afip_alicuota_id\\\":9,\\\"plan_cuenta_id\\\":96,\\\"code_citi_alic_iva\\\":9}},{\\\"id\\\":1307,\\\"user_id\\\":7847,\\\"period_liquidation_id\\\":26,\\\"period_liquidation_iva_id\\\":6,\\\"period_id\\\":6100,\\\"person_id\\\":40736,\\\"activity_id\\\":611,\\\"iva_creditos_tipo_id\\\":1,\\\"type\\\":1,\\\"tax_id\\\":8,\\\"taxabled_amount\\\":\\\"0.00\\\",\\\"iva_amount\\\":\\\"0.00\\\",\\\"created_at\\\":\\\"2022-11-23T16:26:24.000000Z\\\",\\\"updated_at\\\":\\\"2022-11-23T16:26:24.000000Z\\\",\\\"ordr\\\":1,\\\"deleted_at\\\":null,\\\"base\\\":\\\"0.00\\\",\\\"system_taxes\\\":{\\\"id\\\":8,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2020-04-16T13:33:23.000000Z\\\",\\\"name\\\":\\\"Exento\\\",\\\"apply_to\\\":\\\"iva\\\",\\\"ammount_permited\\\":1,\\\"percent_iva\\\":\\\"0.00\\\",\\\"taxable_iibb\\\":1,\\\"taxable_iva\\\":1,\\\"code\\\":2,\\\"status\\\":1,\\\"afip_alicuota_id\\\":2,\\\"plan_cuenta_id\\\":218,\\\"code_citi_alic_iva\\\":3}},{\\\"id\\\":1308,\\\"user_id\\\":7847,\\\"period_liquidation_id\\\":26,\\\"period_liquidation_iva_id\\\":6,\\\"period_id\\\":6100,\\\"person_id\\\":40736,\\\"activity_id\\\":580,\\\"iva_creditos_tipo_id\\\":1,\\\"type\\\":1,\\\"tax_id\\\":8,\\\"taxabled_amount\\\":\\\"0.00\\\",\\\"iva_amount\\\":\\\"0.00\\\",\\\"created_at\\\":\\\"2022-11-23T16:26:24.000000Z\\\",\\\"updated_at\\\":\\\"2022-11-23T16:26:24.000000Z\\\",\\\"ordr\\\":1,\\\"deleted_at\\\":null,\\\"base\\\":\\\"0.00\\\",\\\"system_taxes\\\":{\\\"id\\\":8,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2020-04-16T13:33:23.000000Z\\\",\\\"name\\\":\\\"Exento\\\",\\\"apply_to\\\":\\\"iva\\\",\\\"ammount_permited\\\":1,\\\"percent_iva\\\":\\\"0.00\\\",\\\"taxable_iibb\\\":1,\\\"taxable_iva\\\":1,\\\"code\\\":2,\\\"status\\\":1,\\\"afip_alicuota_id\\\":2,\\\"plan_cuenta_id\\\":218,\\\"code_citi_alic_iva\\\":3}},{\\\"id\\\":1309,\\\"user_id\\\":7847,\\\"period_liquidation_id\\\":26,\\\"period_liquidation_iva_id\\\":6,\\\"period_id\\\":6100,\\\"person_id\\\":40736,\\\"activity_id\\\":611,\\\"iva_creditos_tipo_id\\\":1,\\\"type\\\":1,\\\"tax_id\\\":3,\\\"taxabled_amount\\\":\\\"0.00\\\",\\\"iva_amount\\\":\\\"0.00\\\",\\\"created_at\\\":\\\"2022-11-23T16:26:24.000000Z\\\",\\\"updated_at\\\":\\\"2022-11-23T16:26:24.000000Z\\\",\\\"ordr\\\":2,\\\"deleted_at\\\":null,\\\"base\\\":0,\\\"system_taxes\\\":{\\\"id\\\":3,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2020-04-16T13:33:23.000000Z\\\",\\\"name\\\":\\\"gravado al 27%\\\",\\\"apply_to\\\":\\\"iva\\\",\\\"ammount_permited\\\":1,\\\"percent_iva\\\":\\\"27.00\\\",\\\"taxable_iibb\\\":1,\\\"taxable_iva\\\":1,\\\"code\\\":6,\\\"status\\\":1,\\\"afip_alicuota_id\\\":6,\\\"plan_cuenta_id\\\":96,\\\"code_citi_alic_iva\\\":6}},{\\\"id\\\":1310,\\\"user_id\\\":7847,\\\"period_liquidation_id\\\":26,\\\"period_liquidation_iva_id\\\":6,\\\"period_id\\\":6100,\\\"person_id\\\":40736,\\\"activity_id\\\":580,\\\"iva_creditos_tipo_id\\\":1,\\\"type\\\":1,\\\"tax_id\\\":3,\\\"taxabled_amount\\\":\\\"0.00\\\",\\\"iva_amount\\\":\\\"0.00\\\",\\\"created_at\\\":\\\"2022-11-23T16:26:24.000000Z\\\",\\\"updated_at\\\":\\\"2022-11-23T16:26:24.000000Z\\\",\\\"ordr\\\":2,\\\"deleted_at\\\":null,\\\"base\\\":0,\\\"system_taxes\\\":{\\\"id\\\":3,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2020-04-16T13:33:23.000000Z\\\",\\\"name\\\":\\\"gravado al 27%\\\",\\\"apply_to\\\":\\\"iva\\\",\\\"ammount_permited\\\":1,\\\"percent_iva\\\":\\\"27.00\\\",\\\"taxable_iibb\\\":1,\\\"taxable_iva\\\":1,\\\"code\\\":6,\\\"status\\\":1,\\\"afip_alicuota_id\\\":6,\\\"plan_cuenta_id\\\":96,\\\"code_citi_alic_iva\\\":6}},{\\\"id\\\":1311,\\\"user_id\\\":7847,\\\"period_liquidation_id\\\":26,\\\"period_liquidation_iva_id\\\":6,\\\"period_id\\\":6100,\\\"person_id\\\":40736,\\\"activity_id\\\":611,\\\"iva_creditos_tipo_id\\\":1,\\\"type\\\":1,\\\"tax_id\\\":2,\\\"taxabled_amount\\\":\\\"135542.13\\\",\\\"iva_amount\\\":\\\"28463.85\\\",\\\"created_at\\\":\\\"2022-11-23T16:26:24.000000Z\\\",\\\"updated_at\\\":\\\"2022-11-23T16:26:24.000000Z\\\",\\\"ordr\\\":2,\\\"deleted_at\\\":null,\\\"base\\\":164005.98,\\\"system_taxes\\\":{\\\"id\\\":2,\\\"created_at\\\":null,\\\"updated_at\\\":\\\"2020-04-16T13:33:23.000000Z\\\",\\\"name\\\":\\\"gravado al 21%\\\",\\\"apply_to\\\":\\\"iva\\\",\\\"ammount_permited\\\":1,\\\"percent_iva\\\":\\\"21.00\\\",\\\"taxable_iibb\\\":1,\\\"taxable_iva\\\":1,\\\"code\\\":5,\\\"status\\\":1,\\\"afip_alicuota_id\\\":5,\\\"plan_cuenta_id\\\":96,\\\"code_citi_alic_iva\\\":5}},{\\\"id\\\":1312,\\\"user_id\\\":7847,\\\"period_liquidation_id\\\":26,\\\"period_liquidation_iva_id\\\":6,\\\"period_id\\\":6100,\\\"person_id\\\":40736,\\\"activity_id\\\":580,\\\"iva_creditos_tipo_id\\\":1,\\\"type\\\":1,\\\"tax_id\\\":2,\\\"taxabled_amount\\\":\\\"66987.62\\\",\\\"iva_amount\\\":\\\"14067.40\\\",\\\"created_at\\\":\\\"2022-11-23T16:26:24.000000Z\\\",\\\"updated_at\\\":\\\"2022-11-23T16:26:24.000