-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db27-30992480-6
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2021-02-22 16:19:55','Actividad Generica 1','000001',NULL),(2,NULL,'2021-02-22 16:19:55','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,'2021-08-19 23:41:11','2021-08-19 23:41:11',NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,'2021-08-19 20:42:22','2021-08-19 20:42:22',NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,'2021-08-19 20:42:43','2021-08-19 20:42:43',NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,'2021-08-19 20:43:12','2021-08-19 20:43:12',NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,'2021-08-19 20:43:43','2021-08-19 20:43:43',NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,'2021-08-19 20:43:51','2021-08-19 20:43:51',NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,'2021-08-19 20:44:04','2021-08-19 20:44:04',NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,'2021-08-19 20:44:35','2021-08-19 20:44:35',NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL),('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL),('2023-1','2023-01',2023,1,'2023-01-01','2023-01-31',1202.9790,NULL,NULL,NULL),('2023-2','2023-02',2023,2,'2023-02-01','2023-02-28',1282.7091,NULL,NULL,NULL),('2023-3','2023-03',2023,3,'2023-03-01','2023-03-31',1381.1601,NULL,NULL,NULL),('2023-4','2023-04',2023,4,'2023-04-01','2023-04-30',1497.2147,NULL,NULL,NULL),('2023-5','2023-05',2023,5,'2023-05-01','2023-05-31',1613.5895,NULL,NULL,NULL),('2023-6','2023-06',2023,6,'2023-06-01','2023-06-30',1709.6115,NULL,NULL,NULL),('2023-7','2023-07',2023,7,'2023-07-01','2023-07-31',1818.0838,NULL,NULL,NULL),('2023-8','2023-08',2023,8,'2023-08-01','2023-08-31',2044.2832,NULL,NULL,NULL),('2023-9','2023-09',2023,9,'2023-09-01','2023-09-30',2304.9242,NULL,NULL,NULL),('2023-10','2023-10',2023,10,'2023-10-01','2023-10-31',2496.2730,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_recibidas`
--

DROP TABLE IF EXISTS `api_recibidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_recibidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` json NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_recibidas_person_id_foreign` (`person_id`),
  CONSTRAINT `api_recibidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_recibidas`
--

LOCK TABLES `api_recibidas` WRITE;
/*!40000 ALTER TABLE `api_recibidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_recibidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'yanina_olmos@outlook.com','1134636954',NULL,1,40719,'2024-03-12'),(2,'yanina_olmos@outlook.com','1134636954','',1,40719,'2024-03-12'),(3,'yanina_olmos@outlook.com','1134636954','',1,40719,'2024-03-12'),(4,'yanina_olmos@outlook.com','1134636954','',1,40719,'2024-03-13');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `origin_id` bigint(20) unsigned DEFAULT NULL,
  `origin_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2132 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,2973,40720,1545,12,1,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',1577027.02,NULL,NULL,1,'2021-08-09 12:29:01','2021-08-09 12:31:19','2021-08-09 12:31:19'),(2,2973,40720,1545,19,2,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',1577027.02,NULL,NULL,1,'2021-08-09 12:31:29','2021-08-09 12:31:50','2021-08-09 12:31:50'),(3,2973,40720,1545,19,3,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-09','2021-08-09',1577027.02,NULL,NULL,1,'2021-08-09 12:31:50','2021-08-09 14:49:02','2021-08-09 14:49:02'),(34,2973,40720,1530,19,34,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',1577027.02,NULL,NULL,1,'2021-08-09 20:57:43','2021-08-24 17:39:11','2021-08-24 17:39:11'),(35,2973,40720,1530,19,35,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',137214.00,NULL,NULL,1,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(36,2973,40720,1530,19,36,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',137214.00,NULL,NULL,1,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(37,2973,40720,1530,19,37,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',1007772.79,NULL,NULL,1,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(38,2973,40720,1530,19,38,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',26620.00,NULL,NULL,1,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(39,2973,40720,1530,19,39,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',2680.69,NULL,NULL,1,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(40,2973,40720,1530,19,40,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',13500.00,NULL,NULL,1,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(41,2973,40720,1530,19,41,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',1984.50,NULL,NULL,1,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(42,2973,40720,1530,19,42,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',924.60,NULL,NULL,1,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(43,2973,40720,1530,19,43,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',3216.89,NULL,NULL,1,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(44,2973,40720,1530,19,44,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',29000.00,NULL,NULL,1,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(45,2973,40720,1530,19,45,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',29000.00,NULL,NULL,1,'2021-08-09 20:57:43','2021-08-09 20:57:44',NULL),(46,2973,40720,1530,19,46,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',10000.00,NULL,NULL,1,'2021-08-09 20:57:43','2021-08-09 20:57:44',NULL),(47,2973,40720,1530,19,47,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',224116.20,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(48,2973,40720,1530,19,48,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',34400.00,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(49,2973,40720,1530,19,49,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',3533.40,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(50,2973,40720,1530,19,50,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',49331.48,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL);
INSERT INTO `balance_libro` VALUES (51,2973,40720,1530,19,51,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',243650.00,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(52,2973,40720,1530,19,52,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',15246.00,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(53,2973,40720,1530,19,53,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',1840.88,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(54,2973,40720,1530,19,54,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',22689.45,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(55,2973,40720,1530,19,55,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',1085.52,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(56,2973,40720,1530,19,56,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',9680.00,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(57,2973,40720,1530,19,57,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',5031.18,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(58,2973,40720,1530,19,58,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',9680.00,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(59,2973,40720,1530,19,59,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',5031.18,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(60,2973,40720,1530,19,60,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',3587.27,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(61,2973,40720,1530,19,61,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',38888.61,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(62,2973,40720,1530,19,62,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',141449.80,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(63,2973,40720,1530,19,63,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',1348363.78,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-24 17:42:03','2021-08-24 17:42:03'),(64,2973,40720,1531,19,64,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',26620.00,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(65,2973,40720,1531,19,65,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',157643.64,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(66,2973,40720,1531,19,66,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',31500.00,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(67,2973,40720,1531,19,67,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',2017.12,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(68,2973,40720,1531,19,68,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',10708.50,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(69,2973,40720,1531,19,69,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',73000.00,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(70,2973,40720,1531,19,70,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',532085.40,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL);
INSERT INTO `balance_libro` VALUES (71,2973,40720,1531,19,71,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',430.00,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(72,2973,40720,1531,19,72,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',430.00,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(73,2973,40720,1531,19,73,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',2068.76,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(74,2973,40720,1531,19,74,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',4840.00,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(75,2973,40720,1531,19,75,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',87600.01,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(76,2973,40720,1531,19,76,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',20000.00,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(77,2973,40720,1531,19,77,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',59282.30,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(78,2973,40720,1531,19,78,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',385.08,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(79,2973,40720,1531,19,79,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',31580.37,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(80,2973,40720,1531,19,80,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',918.39,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(81,2973,40720,1531,19,81,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',137214.00,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(82,2973,40720,1531,19,82,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',3867.96,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(83,2973,40720,1531,19,83,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',10000.00,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(84,2973,40720,1531,19,84,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',68879.25,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(85,2973,40720,1531,19,85,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',970532.97,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(86,2973,40720,1531,19,86,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',175000.00,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-24 17:43:24','2021-08-24 17:43:24'),(87,2973,40720,1531,19,87,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',61710.00,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(88,2973,40720,1531,19,88,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',1482.00,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(89,2973,40720,1531,19,89,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',1993.13,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(90,2973,40720,1531,19,90,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',300.08,NULL,NULL,1,'2021-08-09 20:57:44','2021-08-09 20:57:45',NULL);
INSERT INTO `balance_libro` VALUES (91,2973,40720,1531,19,91,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',48929.64,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(92,2973,40720,1531,19,92,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',178407.46,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(93,2973,40720,1531,19,93,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',23814.00,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(94,2973,40720,1531,19,94,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',269.68,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(95,2973,40720,1531,19,95,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',1978558.52,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-24 17:44:50','2021-08-24 17:44:50'),(96,2973,40720,1532,19,96,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',540.00,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(97,2973,40720,1532,19,97,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',850.00,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(98,2973,40720,1532,19,98,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',50910.75,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(99,2973,40720,1532,19,99,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',69466.01,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(100,2973,40720,1532,19,100,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',26620.00,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(101,2973,40720,1532,19,101,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',34848.00,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(102,2973,40720,1532,19,102,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',205000.00,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(103,2973,40720,1532,19,103,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',868.78,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(104,2973,40720,1532,19,104,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',1138.50,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(105,2973,40720,1532,19,105,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',35.01,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(106,2973,40720,1532,19,106,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',6050.00,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(107,2973,40720,1532,19,107,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',53.00,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(108,2973,40720,1532,19,108,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',53.00,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(109,2973,40720,1532,19,109,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',10000.00,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(110,2973,40720,1532,19,110,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',60.00,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL);
INSERT INTO `balance_libro` VALUES (111,2973,40720,1532,19,111,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',34848.00,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(112,2973,40720,1532,19,112,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',131890.00,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(113,2973,40720,1532,19,113,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',162217.50,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(114,2973,40720,1532,19,114,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',3154.70,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(115,2973,40720,1532,19,115,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',47373.32,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(116,2973,40720,1532,19,116,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',28895.45,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(117,2973,40720,1532,19,117,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',43589.00,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(118,2973,40720,1532,19,118,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',94000.00,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(119,2973,40720,1532,19,119,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',3216.34,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(120,2973,40720,1532,19,120,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',256600.00,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(121,2973,40720,1532,19,121,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',1618.74,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(122,2973,40720,1532,19,122,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',53.00,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(123,2973,40720,1532,19,123,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',65.00,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(124,2973,40720,1532,19,124,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',100.00,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(125,2973,40720,1532,19,125,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',60.00,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(126,2973,40720,1532,19,126,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',60.00,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(127,2973,40720,1532,19,127,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',53.00,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(128,2973,40720,1532,19,128,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',65.00,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(129,2973,40720,1532,19,129,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',1340.64,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(130,2973,40720,1532,19,130,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',40.00,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL);
INSERT INTO `balance_libro` VALUES (131,2973,40720,1532,19,131,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',63844.58,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(132,2973,40720,1532,19,132,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',147685.46,NULL,NULL,1,'2021-08-09 20:57:45','2021-08-09 20:57:46',NULL),(133,2973,40720,1532,19,133,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',2375.79,NULL,NULL,1,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(134,2973,40720,1532,19,134,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',1486679.83,NULL,NULL,1,'2021-08-09 20:57:46','2021-08-24 17:47:04','2021-08-24 17:47:04'),(135,2973,40720,1533,19,135,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',26620.00,NULL,NULL,1,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(136,2973,40720,1533,19,136,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',1340.64,NULL,NULL,1,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(137,2973,40720,1533,19,137,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',3200.00,NULL,NULL,1,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(138,2973,40720,1533,19,138,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',3200.00,NULL,NULL,1,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(139,2973,40720,1533,19,139,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',56000.00,NULL,NULL,1,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(140,2973,40720,1533,19,140,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',44775.19,NULL,NULL,1,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(141,2973,40720,1533,19,141,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',9719.01,NULL,NULL,1,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(142,2973,40720,1533,19,142,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',10000.00,NULL,NULL,1,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(143,2973,40720,1533,19,143,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',660179.13,NULL,NULL,1,'2021-08-09 20:57:46','2021-08-24 17:48:22','2021-08-24 17:48:22'),(144,2973,40720,1534,19,144,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',26620.00,NULL,NULL,1,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(145,2973,40720,1534,19,145,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',1952.94,NULL,NULL,1,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(146,2973,40720,1534,19,146,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',820.00,NULL,NULL,1,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(147,2973,40720,1534,19,147,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',783.03,NULL,NULL,1,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(148,2973,40720,1534,19,148,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',479.51,NULL,NULL,1,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(149,2973,40720,1534,19,149,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',2685.53,NULL,NULL,1,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(150,2973,40720,1534,19,150,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',207960.00,NULL,NULL,1,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL);
INSERT INTO `balance_libro` VALUES (151,2973,40720,1534,19,151,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',10000.00,NULL,NULL,1,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(152,2973,40720,1534,19,152,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',155.48,NULL,NULL,1,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(153,2973,40720,1534,19,153,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',65.00,NULL,NULL,1,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(154,2973,40720,1534,19,154,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',53.00,NULL,NULL,1,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(155,2973,40720,1534,19,155,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',65.00,NULL,NULL,1,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(156,2973,40720,1534,19,156,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',53.00,NULL,NULL,1,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(157,2973,40720,1534,19,157,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',532.40,NULL,NULL,1,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(158,2973,40720,1534,19,158,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',60.00,NULL,NULL,1,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(159,2973,40720,1534,19,159,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',60.00,NULL,NULL,1,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(160,2973,40720,1534,19,160,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',53.00,NULL,NULL,1,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(161,2973,40720,1534,19,161,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',53.00,NULL,NULL,1,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(162,2973,40720,1534,19,162,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',260150.00,NULL,NULL,1,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(163,2973,40720,1534,19,163,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',850500.00,NULL,NULL,1,'2021-08-09 20:57:46','2021-08-24 17:49:23','2021-08-24 17:49:23'),(164,2973,40720,1534,19,164,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',53842.55,NULL,NULL,1,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(165,2973,40720,1534,19,165,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',81242.23,NULL,NULL,1,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(166,2973,40720,1534,19,166,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',11814.40,NULL,NULL,1,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(167,2973,40720,1534,19,167,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',1145559.46,NULL,NULL,1,'2021-08-09 20:57:46','2021-08-24 17:50:27','2021-08-24 17:50:27'),(168,2973,40720,1535,19,168,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',2920.00,NULL,NULL,1,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(169,2973,40720,1535,19,169,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',41780.68,NULL,NULL,1,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(170,2973,40720,1535,19,170,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',110000.00,NULL,NULL,1,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL);
INSERT INTO `balance_libro` VALUES (171,2973,40720,1535,19,171,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',100500.00,NULL,NULL,1,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(172,2973,40720,1535,19,172,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',26620.00,NULL,NULL,1,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(173,2973,40720,1535,19,173,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',112530.00,NULL,NULL,1,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(174,2973,40720,1535,19,174,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',60.00,NULL,NULL,1,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(175,2973,40720,1535,19,175,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',49.59,NULL,NULL,1,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(176,2973,40720,1535,19,176,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',53.00,NULL,NULL,1,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(177,2973,40720,1535,19,177,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',51546.00,NULL,NULL,1,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(178,2973,40720,1535,19,178,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',3112.42,NULL,NULL,1,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(179,2973,40720,1535,19,179,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',60.00,NULL,NULL,1,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(180,2973,40720,1535,19,180,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',60.00,NULL,NULL,1,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(181,2973,40720,1535,19,181,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',53.00,NULL,NULL,1,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(182,2973,40720,1535,19,182,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',53.00,NULL,NULL,1,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(183,2973,40720,1535,19,183,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',53.00,NULL,NULL,1,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(184,2973,40720,1535,19,184,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',53.00,NULL,NULL,1,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(185,2973,40720,1535,19,185,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',53.00,NULL,NULL,1,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(186,2973,40720,1535,19,186,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',53.00,NULL,NULL,1,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(187,2973,40720,1535,19,187,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',53.00,NULL,NULL,1,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(188,2973,40720,1535,19,188,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',53.00,NULL,NULL,1,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(189,2973,40720,1535,19,189,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',2947.48,NULL,NULL,1,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(190,2973,40720,1535,19,190,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',10000.00,NULL,NULL,1,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL);
INSERT INTO `balance_libro` VALUES (191,2973,40720,1535,19,191,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',340.96,NULL,NULL,1,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(192,2973,40720,1535,19,192,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',69938.00,NULL,NULL,1,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(193,2973,40720,1535,19,193,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',148290.34,NULL,NULL,1,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(194,2973,40720,1535,19,194,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',2136.98,NULL,NULL,1,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(195,2973,40720,1535,19,195,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',276333.75,NULL,NULL,1,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(196,2973,40720,1535,19,196,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',3640.02,NULL,NULL,1,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(197,2973,40720,1535,19,197,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',340.00,NULL,NULL,1,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(198,2973,40720,1535,19,198,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',2513.26,NULL,NULL,1,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(199,2973,40720,1535,19,199,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',5829.78,NULL,NULL,1,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(200,2973,40720,1535,19,200,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',45745.14,NULL,NULL,1,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(201,2973,40720,1535,19,201,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',125105.81,NULL,NULL,1,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(202,2973,40720,1535,19,202,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',3966.59,NULL,NULL,1,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(203,2973,40720,1535,19,203,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',1179064.36,NULL,NULL,1,'2021-08-09 20:57:47','2021-08-24 17:51:20','2021-08-24 17:51:20'),(204,2973,40720,1536,19,204,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',5808.00,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(205,2973,40720,1536,19,205,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',49218.41,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(206,2973,40720,1536,19,206,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',38482.17,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(207,2973,40720,1536,19,207,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',10000.00,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(208,2973,40720,1536,19,208,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',10000.00,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(209,2973,40720,1536,19,209,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',30613.00,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(210,2973,40720,1536,19,210,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',285.27,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL);
INSERT INTO `balance_libro` VALUES (211,2973,40720,1536,19,211,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',60.41,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(212,2973,40720,1536,19,212,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',3059.76,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(213,2973,40720,1536,19,213,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',315507.50,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(214,2973,40720,1536,19,214,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',1696.93,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(215,2973,40720,1536,19,215,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',8250.00,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(216,2973,40720,1536,19,216,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',25.39,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(217,2973,40720,1536,19,217,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',793.39,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(218,2973,40720,1536,19,218,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',3300.60,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(219,2973,40720,1536,19,219,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',4800.00,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(220,2973,40720,1536,19,220,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',2709.41,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(221,2973,40720,1536,19,221,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',2178.00,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(222,2973,40720,1536,19,222,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',2178.00,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(223,2973,40720,1536,19,223,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',30545.38,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(224,2973,40720,1536,19,224,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',70747.59,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(225,2973,40720,1536,19,225,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',62868.04,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(226,2973,40720,1536,19,226,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',2989.98,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(227,2973,40720,1536,19,227,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',910275.10,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-24 17:52:22','2021-08-24 17:52:22'),(228,2973,40720,1537,19,228,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',75655.25,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(229,2973,40720,1537,19,229,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',275.35,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(230,2973,40720,1537,19,230,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',311.99,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL);
INSERT INTO `balance_libro` VALUES (231,2973,40720,1537,19,231,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',3718.66,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(232,2973,40720,1537,19,232,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',30613.00,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(233,2973,40720,1537,19,233,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',4840.00,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(234,2973,40720,1537,19,234,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',6129.26,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(235,2973,40720,1537,19,235,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',2917.79,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(236,2973,40720,1537,19,236,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',1500.00,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(237,2973,40720,1537,19,237,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',26850.00,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(238,2973,40720,1537,19,238,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',2392.82,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(239,2973,40720,1537,19,239,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',1425.21,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(240,2973,40720,1537,19,240,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',1425.21,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(241,2973,40720,1537,19,241,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',431902.63,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(242,2973,40720,1537,19,242,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',10000.00,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(243,2973,40720,1537,19,243,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',6789.26,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(244,2973,40720,1537,19,244,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',681.82,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(245,2973,40720,1537,19,245,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',79.99,NULL,NULL,1,'2021-08-09 20:57:48','2021-08-09 20:57:49',NULL),(246,2973,40720,1537,19,246,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',80.01,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(247,2973,40720,1537,19,247,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',3282.12,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(248,2973,40720,1537,19,248,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',414485.50,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(249,2973,40720,1537,19,249,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',3163.95,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(250,2973,40720,1537,19,250,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',34696.75,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL);
INSERT INTO `balance_libro` VALUES (251,2973,40720,1537,19,251,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',79.99,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(252,2973,40720,1537,19,252,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',212.00,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(253,2973,40720,1537,19,253,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',80.01,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(254,2973,40720,1537,19,254,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',60.00,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(255,2973,40720,1537,19,255,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',187550.00,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(256,2973,40720,1537,19,256,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',159.00,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(257,2973,40720,1537,19,257,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',46965.52,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(258,2973,40720,1537,19,258,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',128867.04,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(259,2973,40720,1537,19,259,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',3144.30,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(260,2973,40720,1537,19,260,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',13563.99,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(261,2973,40720,1537,19,261,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',21592.26,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(262,2973,40720,1537,19,262,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',104.27,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(263,2973,40720,1537,19,263,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',1070361.34,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-24 17:53:19','2021-08-24 17:53:19'),(264,2973,40720,1538,19,264,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',2484.89,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(265,2973,40720,1538,19,265,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',320.63,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(266,2973,40720,1538,19,266,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',30613.00,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(267,2973,40720,1538,19,267,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',107938.05,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(268,2973,40720,1538,19,268,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1982.41,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(269,2973,40720,1538,19,269,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',4501.20,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(270,2973,40720,1538,19,270,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',15000.00,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL);
INSERT INTO `balance_libro` VALUES (271,2973,40720,1538,19,271,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',239000.00,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(272,2973,40720,1538,19,272,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',2200.02,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(273,2973,40720,1538,19,273,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',2670.84,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(274,2973,40720,1538,19,274,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',30599.01,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(275,2973,40720,1538,19,275,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',3260.43,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(276,2973,40720,1538,19,276,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',80.01,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(277,2973,40720,1538,19,277,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',80.01,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(278,2973,40720,1538,19,278,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',163440.00,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(279,2973,40720,1538,19,279,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',28726.10,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(280,2973,40720,1538,19,280,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1220.00,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(281,2973,40720,1538,19,281,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',743.50,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(282,2973,40720,1538,19,282,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1220.00,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(283,2973,40720,1538,19,283,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',620.60,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(284,2973,40720,1538,19,284,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1359.53,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(285,2973,40720,1538,19,285,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',231.74,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(286,2973,40720,1538,19,286,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',43287.75,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(287,2973,40720,1538,19,287,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',80.01,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(288,2973,40720,1538,19,288,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',80.01,NULL,NULL,1,'2021-08-09 20:57:49','2021-08-09 20:57:50',NULL),(289,2973,40720,1538,19,289,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',96195.00,NULL,NULL,1,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(290,2973,40720,1538,19,290,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',6368.84,NULL,NULL,1,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL);
INSERT INTO `balance_libro` VALUES (291,2973,40720,1538,19,291,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1331.00,NULL,NULL,1,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(292,2973,40720,1538,19,292,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',231.00,NULL,NULL,1,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(293,2973,40720,1538,19,293,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',268.05,NULL,NULL,1,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(294,2973,40720,1538,19,294,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',49388.13,NULL,NULL,1,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(295,2973,40720,1538,19,295,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',112785.76,NULL,NULL,1,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(296,2973,40720,1538,19,296,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',700.00,NULL,NULL,1,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(297,2973,40720,1538,19,297,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1300.00,NULL,NULL,1,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(298,2973,40720,1538,19,298,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',409.99,NULL,NULL,1,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(299,2973,40720,1538,19,299,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',457.03,NULL,NULL,1,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(300,2973,40720,1538,19,300,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',52511.49,NULL,NULL,1,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(301,2973,40720,1538,19,301,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1478534.38,NULL,NULL,1,'2021-08-09 20:57:50','2021-08-24 17:54:24','2021-08-24 17:54:24'),(302,2973,40720,1539,19,302,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',400.91,NULL,NULL,1,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(303,2973,40720,1539,19,303,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',1507.66,NULL,NULL,1,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(304,2973,40720,1539,19,304,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',1094.29,NULL,NULL,1,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(305,2973,40720,1539,19,305,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',10599.00,NULL,NULL,1,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(306,2973,40720,1539,19,306,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',10599.00,NULL,NULL,1,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(307,2973,40720,1539,19,307,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',30613.00,NULL,NULL,1,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(308,2973,40720,1539,19,308,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',1400.00,NULL,NULL,1,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(309,2973,40720,1539,19,309,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',69641.91,NULL,NULL,1,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(310,2973,40720,1539,19,310,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',15000.00,NULL,NULL,1,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL);
INSERT INTO `balance_libro` VALUES (311,2973,40720,1539,19,311,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',70808.22,NULL,NULL,1,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(312,2973,40720,1539,19,312,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',15000.00,NULL,NULL,1,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(313,2973,40720,1539,19,313,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',120000.00,NULL,NULL,1,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(314,2973,40720,1539,19,314,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',181260.38,NULL,NULL,1,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(315,2973,40720,1539,19,315,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',120000.00,NULL,NULL,1,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(316,2973,40720,1539,19,316,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',24805.00,NULL,NULL,1,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(317,2973,40720,1539,19,317,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',109000.00,NULL,NULL,1,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(318,2973,40720,1539,19,318,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',684.84,NULL,NULL,1,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(319,2973,40720,1539,19,319,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',3253.36,NULL,NULL,1,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(320,2973,40720,1539,19,320,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',319.68,NULL,NULL,1,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(321,2973,40720,1539,19,321,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',24805.00,NULL,NULL,1,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(322,2973,40720,1539,19,322,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',475492.89,NULL,NULL,1,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(323,2973,40720,1539,19,323,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',111376.51,NULL,NULL,1,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(324,2973,40720,1539,19,324,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',6568.49,NULL,NULL,1,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(325,2973,40720,1539,19,325,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',438.07,NULL,NULL,1,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(326,2973,40720,1539,19,326,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',99825.00,NULL,NULL,1,'2021-08-09 20:57:50','2021-08-09 20:57:51',NULL),(327,2973,40720,1539,19,327,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',1416.74,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(328,2973,40720,1539,19,328,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',1080.89,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(329,2973,40720,1539,19,329,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',174240.00,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(330,2973,40720,1539,19,330,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',3545.35,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL);
INSERT INTO `balance_libro` VALUES (331,2973,40720,1539,19,331,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',9900.00,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(332,2973,40720,1539,19,332,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',156.03,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(333,2973,40720,1539,19,333,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',34566.77,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(334,2973,40720,1539,19,334,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',92026.26,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(335,2973,40720,1539,19,335,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',206.00,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(336,2973,40720,1539,19,336,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',15958.79,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(337,2973,40720,1539,19,337,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',1073398.82,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-24 17:55:18','2021-08-24 17:55:18'),(338,2973,40720,1540,19,338,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',2813.80,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(339,2973,40720,1540,19,339,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',267.37,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(340,2973,40720,1540,19,340,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',30613.00,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(341,2973,40720,1540,19,341,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',600.00,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(342,2973,40720,1540,19,342,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',600.00,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(343,2973,40720,1540,19,343,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',3326.26,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(344,2973,40720,1540,19,344,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',500.01,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(345,2973,40720,1540,19,345,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',313371.26,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(346,2973,40720,1540,19,346,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',500.01,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(347,2973,40720,1540,19,347,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',1645.00,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(348,2973,40720,1540,19,348,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',2600.00,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(349,2973,40720,1540,19,349,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',15000.00,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(350,2973,40720,1540,19,350,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',15000.00,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL);
INSERT INTO `balance_libro` VALUES (351,2973,40720,1540,19,351,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',1645.00,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(352,2973,40720,1540,19,352,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',50700.00,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(353,2973,40720,1540,19,353,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',51273.75,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(354,2973,40720,1540,19,354,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',159200.00,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(355,2973,40720,1540,19,355,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',847.50,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(356,2973,40720,1540,19,356,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',3305.60,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(357,2973,40720,1540,19,357,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',3350.01,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(358,2973,40720,1540,19,358,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',1250.00,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(359,2973,40720,1540,19,359,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',167049.58,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(360,2973,40720,1540,19,360,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',3350.00,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(361,2973,40720,1540,19,361,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',1250.00,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(362,2973,40720,1540,19,362,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',2504.31,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(363,2973,40720,1540,19,363,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',1006.77,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(364,2973,40720,1540,19,364,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',66220.00,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(365,2973,40720,1540,19,365,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',1006.77,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(366,2973,40720,1540,19,366,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',2690.09,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(367,2973,40720,1540,19,367,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',7650.00,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(368,2973,40720,1540,19,368,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',2690.09,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(369,2973,40720,1540,19,369,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',7650.00,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(370,2973,40720,1540,19,370,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',216.46,NULL,NULL,1,'2021-08-09 20:57:51','2021-08-09 20:57:52',NULL);
INSERT INTO `balance_libro` VALUES (371,2973,40720,1540,19,371,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',33094.50,NULL,NULL,1,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(372,2973,40720,1540,19,372,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',151098.22,NULL,NULL,1,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(373,2973,40720,1540,19,373,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',17749.92,NULL,NULL,1,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(374,2973,40720,1540,19,374,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',62799.00,NULL,NULL,1,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(375,2973,40720,1540,19,375,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',1119211.72,NULL,NULL,1,'2021-08-09 20:57:52','2021-08-24 17:56:34','2021-08-24 17:56:34'),(376,2973,40720,1541,19,376,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',2749.36,NULL,NULL,1,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(377,2973,40720,1541,19,377,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',75255.63,NULL,NULL,1,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(378,2973,40720,1541,19,378,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',619.97,NULL,NULL,1,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(379,2973,40720,1541,19,379,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',1.90,NULL,NULL,1,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(380,2973,40720,1541,19,380,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',30613.00,NULL,NULL,1,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(381,2973,40720,1541,19,381,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',3568.92,NULL,NULL,1,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(382,2973,40720,1541,19,382,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',510.42,NULL,NULL,1,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(383,2973,40720,1541,19,383,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',467630.21,NULL,NULL,1,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(384,2973,40720,1541,19,384,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',62980.50,NULL,NULL,1,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(385,2973,40720,1541,19,385,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',78725.62,NULL,NULL,1,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(386,2973,40720,1541,19,386,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',2316.75,NULL,NULL,1,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(387,2973,40720,1541,19,387,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',4178.90,NULL,NULL,1,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(388,2973,40720,1541,19,388,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',1041.00,NULL,NULL,1,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(389,2973,40720,1541,19,389,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',187934.18,NULL,NULL,1,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(390,2973,40720,1541,19,390,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',3826.51,NULL,NULL,1,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL);
INSERT INTO `balance_libro` VALUES (391,2973,40720,1541,19,391,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',15000.00,NULL,NULL,1,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(392,2973,40720,1541,19,392,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',15000.00,NULL,NULL,1,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(393,2973,40720,1541,19,393,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',122120.02,NULL,NULL,1,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(394,2973,40720,1541,19,394,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',781.27,NULL,NULL,1,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(395,2973,40720,1541,19,395,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',904.96,NULL,NULL,1,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(396,2973,40720,1541,19,396,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',6212.70,NULL,NULL,1,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(397,2973,40720,1541,19,397,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',113.35,NULL,NULL,1,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(398,2973,40720,1541,19,398,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',177149.46,NULL,NULL,1,'2021-08-09 20:57:52','2021-08-28 12:31:26','2021-08-28 12:31:26'),(399,2973,40720,1541,19,399,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',31035.38,NULL,NULL,1,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(400,2973,40720,1541,19,400,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',138369.26,NULL,NULL,1,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(401,2973,40720,1541,19,401,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',350000.00,NULL,NULL,1,'2021-08-09 20:57:52','2021-08-28 14:00:48','2021-08-28 14:00:48'),(402,2973,40720,1541,19,402,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',637.72,NULL,NULL,1,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(403,2973,40720,1541,19,403,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',8527.69,NULL,NULL,1,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(404,2973,40720,1541,19,404,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',5691882.91,NULL,NULL,1,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(405,2973,40720,1541,19,405,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',2.08,NULL,NULL,1,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(406,2973,40720,1541,19,406,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',1909582.84,NULL,NULL,1,'2021-08-09 20:57:52','2021-08-24 17:57:25','2021-08-24 17:57:25'),(407,2973,40722,3057,2,1,'App\\Models\\Receipt',1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',597.03,NULL,NULL,1,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(408,2973,40722,3057,2,2,'App\\Models\\Receipt',2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',3824.71,NULL,NULL,1,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(409,2973,40722,3057,2,3,'App\\Models\\Receipt',3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',2369.71,NULL,NULL,1,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(410,2973,40722,3057,2,4,'App\\Models\\Receipt',4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',3893.58,NULL,NULL,1,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL);
INSERT INTO `balance_libro` VALUES (411,2973,40722,3057,2,5,'App\\Models\\Receipt',5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',3893.58,NULL,NULL,1,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(412,2973,40722,3057,2,6,'App\\Models\\Receipt',6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',8138.30,NULL,NULL,1,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(413,2973,40722,3057,2,7,'App\\Models\\Receipt',7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',3824.71,NULL,NULL,1,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(414,2973,40722,3057,2,8,'App\\Models\\Receipt',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',3024.00,NULL,NULL,1,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(415,2973,40722,3057,2,9,'App\\Models\\Receipt',9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',1310.00,NULL,NULL,1,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(416,2973,40722,3057,2,10,'App\\Models\\Receipt',10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',1116.47,NULL,NULL,1,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(417,2973,40722,3057,2,11,'App\\Models\\Receipt',11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',3855.47,NULL,NULL,1,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(418,2973,40722,3057,2,12,'App\\Models\\Receipt',12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',857.58,NULL,NULL,1,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(419,2973,40722,3057,2,13,'App\\Models\\Receipt',13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',2369.71,NULL,NULL,1,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(420,2973,40722,3057,2,14,'App\\Models\\Receipt',14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',4405.74,NULL,NULL,1,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(421,2973,40722,3057,2,15,'App\\Models\\Receipt',15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',7544.16,NULL,NULL,1,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(422,2973,40722,3057,2,16,'App\\Models\\Receipt',16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',2616.09,NULL,NULL,1,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(423,2973,40722,3057,2,17,'App\\Models\\Receipt',17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1113.20,NULL,NULL,1,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(424,2973,40722,3057,2,18,'App\\Models\\Receipt',18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',2668.47,NULL,NULL,1,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(425,2973,40722,3057,2,19,'App\\Models\\Receipt',19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',2062.22,NULL,NULL,1,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(426,2973,40722,3057,2,20,'App\\Models\\Receipt',20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',3618.46,NULL,NULL,1,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(427,2973,40722,3057,2,21,'App\\Models\\Receipt',21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',320.00,NULL,NULL,1,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(428,2973,40722,3057,2,22,'App\\Models\\Receipt',22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1666.46,NULL,NULL,1,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(429,2973,40722,3057,2,23,'App\\Models\\Receipt',23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',2324.12,NULL,NULL,1,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(430,2973,40722,3057,2,24,'App\\Models\\Receipt',24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',360.00,NULL,NULL,1,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(431,2973,40722,3057,2,25,'App\\Models\\Receipt',25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1232.15,NULL,NULL,1,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL);
INSERT INTO `balance_libro` VALUES (432,2973,40722,3057,2,26,'App\\Models\\Receipt',26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1069.73,NULL,NULL,1,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(433,2973,40722,3057,2,27,'App\\Models\\Receipt',27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',3826.65,NULL,NULL,1,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(434,2973,40722,3057,2,28,'App\\Models\\Receipt',28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',2913.97,NULL,NULL,1,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(435,2973,40722,3057,2,29,'App\\Models\\Receipt',29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1816.81,NULL,NULL,1,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(436,2973,40722,3057,2,30,'App\\Models\\Receipt',30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',2520.06,NULL,NULL,1,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(437,2973,40722,3057,2,31,'App\\Models\\Receipt',31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',235.00,NULL,NULL,1,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(438,2973,40722,3057,2,32,'App\\Models\\Receipt',32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',3136.01,NULL,NULL,1,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(439,2973,40722,3057,2,33,'App\\Models\\Receipt',33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',644.08,NULL,NULL,1,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(440,2973,40722,3057,2,34,'App\\Models\\Receipt',34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1035.95,NULL,NULL,1,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(441,2973,40722,3057,2,35,'App\\Models\\Receipt',35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1416.80,NULL,NULL,1,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(442,2973,40722,3057,2,36,'App\\Models\\Receipt',36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',3846.05,NULL,NULL,1,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(443,2973,40722,3057,2,37,'App\\Models\\Receipt',37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',579.88,NULL,NULL,1,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(444,2973,40722,3057,2,38,'App\\Models\\Receipt',38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',3886.79,NULL,NULL,1,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(445,2973,40722,3057,2,39,'App\\Models\\Receipt',39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',8138.30,NULL,NULL,1,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(446,2973,40722,3057,2,40,'App\\Models\\Receipt',40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',3330.00,NULL,NULL,1,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(447,2973,40722,3057,2,41,'App\\Models\\Receipt',41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1594.88,NULL,NULL,1,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(448,2973,40722,3057,2,42,'App\\Models\\Receipt',42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1422.15,NULL,NULL,1,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(449,2973,40722,3057,2,43,'App\\Models\\Receipt',43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1748.75,NULL,NULL,1,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(450,2973,40722,3057,2,44,'App\\Models\\Receipt',44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',3941.11,NULL,NULL,1,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(451,2973,40722,3057,2,45,'App\\Models\\Receipt',45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',770.00,NULL,NULL,1,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(452,2973,40722,3057,2,46,'App\\Models\\Receipt',46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',5188.53,NULL,NULL,1,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL);
INSERT INTO `balance_libro` VALUES (453,2973,40722,3057,2,47,'App\\Models\\Receipt',47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1077.80,NULL,NULL,1,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(454,2973,40722,3057,2,48,'App\\Models\\Receipt',48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',2642.28,NULL,NULL,1,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(455,2973,40722,3057,2,49,'App\\Models\\Receipt',49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',728.47,NULL,NULL,1,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(456,2973,40722,3057,2,50,'App\\Models\\Receipt',50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',728.47,NULL,NULL,1,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(457,2973,40722,3057,2,51,'App\\Models\\Receipt',51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1390.98,NULL,NULL,1,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(458,2973,40722,3057,2,52,'App\\Models\\Receipt',52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1757.00,NULL,NULL,1,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(459,2973,40722,3057,2,53,'App\\Models\\Receipt',53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',868.15,NULL,NULL,1,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(460,2973,40722,3057,2,54,'App\\Models\\Receipt',54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1986.56,NULL,NULL,1,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(461,2973,40722,3057,2,55,'App\\Models\\Receipt',55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1640.27,NULL,NULL,1,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(462,2973,40722,3057,2,56,'App\\Models\\Receipt',56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',2979.84,NULL,NULL,1,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(463,2973,40722,3057,2,57,'App\\Models\\Receipt',57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1526.86,NULL,NULL,1,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(464,2973,40722,3057,2,58,'App\\Models\\Receipt',58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',3983.66,NULL,NULL,1,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(465,2973,40722,3057,2,59,'App\\Models\\Receipt',59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',2232.94,NULL,NULL,1,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(466,2973,40722,3057,2,60,'App\\Models\\Receipt',60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',2326.06,NULL,NULL,1,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(467,2973,40722,3057,2,61,'App\\Models\\Receipt',61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1095.24,NULL,NULL,1,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(468,2973,40722,3057,2,62,'App\\Models\\Receipt',62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',2811.06,NULL,NULL,1,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(469,2973,40722,3057,2,63,'App\\Models\\Receipt',63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',3100.66,NULL,NULL,1,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(470,2973,40722,3057,2,64,'App\\Models\\Receipt',64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',4066.00,NULL,NULL,1,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(471,2973,40722,3057,2,65,'App\\Models\\Receipt',65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',8169.05,NULL,NULL,1,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(472,2973,40722,3057,2,66,'App\\Models\\Receipt',66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1136.84,NULL,NULL,1,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(473,2973,40722,3057,2,67,'App\\Models\\Receipt',67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',860.08,NULL,NULL,1,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL);
INSERT INTO `balance_libro` VALUES (474,2973,40722,3057,2,68,'App\\Models\\Receipt',68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1583.04,NULL,NULL,1,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(475,2973,40722,3057,2,69,'App\\Models\\Receipt',69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',2860.09,NULL,NULL,1,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(476,2973,40722,3057,2,70,'App\\Models\\Receipt',70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',445.00,NULL,NULL,1,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(477,2973,40722,3057,2,71,'App\\Models\\Receipt',71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',2377.00,NULL,NULL,1,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(478,2973,40722,3057,2,72,'App\\Models\\Receipt',72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1246.30,NULL,NULL,1,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(479,2973,40722,3057,2,73,'App\\Models\\Receipt',73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',5450.43,NULL,NULL,1,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(480,2973,40722,3057,2,74,'App\\Models\\Receipt',74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',815.10,NULL,NULL,1,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(481,2973,40722,3057,2,75,'App\\Models\\Receipt',75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',3919.70,NULL,NULL,1,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(482,2973,40722,3057,2,76,'App\\Models\\Receipt',76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',857.58,NULL,NULL,1,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(483,2973,40722,3057,2,77,'App\\Models\\Receipt',77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',770.00,NULL,NULL,1,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(484,2973,40722,3057,2,78,'App\\Models\\Receipt',78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',742.13,NULL,NULL,1,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(485,2973,40722,3057,2,79,'App\\Models\\Receipt',79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1060.35,NULL,NULL,1,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(486,2973,40722,3057,2,80,'App\\Models\\Receipt',80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',2556.12,NULL,NULL,1,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(487,2973,40722,3057,2,81,'App\\Models\\Receipt',81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',2448.28,NULL,NULL,1,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(488,2973,40722,3057,2,82,'App\\Models\\Receipt',82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1747.90,NULL,NULL,1,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(489,2973,40722,3057,2,83,'App\\Models\\Receipt',83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1330.45,NULL,NULL,1,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(490,2973,40722,3057,2,84,'App\\Models\\Receipt',84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1107.22,NULL,NULL,1,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(491,2973,40722,3057,2,85,'App\\Models\\Receipt',85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',2562.34,NULL,NULL,1,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(492,2973,40722,3057,2,86,'App\\Models\\Receipt',86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1088.12,NULL,NULL,1,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(493,2973,40722,3057,2,87,'App\\Models\\Receipt',87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',728.47,NULL,NULL,1,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(494,2973,40722,3057,2,88,'App\\Models\\Receipt',88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1665.66,NULL,NULL,1,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL);
INSERT INTO `balance_libro` VALUES (495,2973,40722,3057,2,89,'App\\Models\\Receipt',89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1416.80,NULL,NULL,1,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(496,2973,40722,3057,2,90,'App\\Models\\Receipt',90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',4285.00,NULL,NULL,1,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(497,2973,40722,3057,2,91,'App\\Models\\Receipt',91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',2881.95,NULL,NULL,1,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(498,2973,40722,3057,2,92,'App\\Models\\Receipt',92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',730.00,NULL,NULL,1,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(499,2973,40722,3057,2,93,'App\\Models\\Receipt',93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',2273.68,NULL,NULL,1,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(500,2973,40722,3057,2,94,'App\\Models\\Receipt',94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',4442.87,NULL,NULL,1,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(501,2973,40722,3057,2,95,'App\\Models\\Receipt',95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',2857.80,NULL,NULL,1,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(502,2973,40722,3057,2,96,'App\\Models\\Receipt',96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1259.94,NULL,NULL,1,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(503,2973,40722,3057,2,97,'App\\Models\\Receipt',97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',830.78,NULL,NULL,1,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(504,2973,40722,3057,2,98,'App\\Models\\Receipt',98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',15489.81,NULL,NULL,1,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(505,2973,40722,3057,2,99,'App\\Models\\Receipt',99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',2676.62,NULL,NULL,1,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(506,2973,40722,3057,2,100,'App\\Models\\Receipt',100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',2478.35,NULL,NULL,1,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(507,2973,40722,3057,2,101,'App\\Models\\Receipt',101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',403.70,NULL,NULL,1,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(508,2973,40722,3057,2,102,'App\\Models\\Receipt',102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',427.68,NULL,NULL,1,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(509,2973,40722,3057,2,103,'App\\Models\\Receipt',103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1040.27,NULL,NULL,1,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(510,2973,40722,3057,2,104,'App\\Models\\Receipt',104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',6864.00,NULL,NULL,1,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(511,2973,40722,3057,2,105,'App\\Models\\Receipt',105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1782.00,NULL,NULL,1,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(512,2973,40722,3057,2,106,'App\\Models\\Receipt',106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',2559.29,NULL,NULL,1,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(513,2973,40722,3057,2,107,'App\\Models\\Receipt',107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',3633.62,NULL,NULL,1,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(514,2973,40722,3057,2,108,'App\\Models\\Receipt',108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1047.60,NULL,NULL,1,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(515,2973,40722,3057,2,109,'App\\Models\\Receipt',109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',2676.62,NULL,NULL,1,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL);
INSERT INTO `balance_libro` VALUES (516,2973,40722,3057,2,110,'App\\Models\\Receipt',110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1506.45,NULL,NULL,1,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(517,2973,40722,3057,2,111,'App\\Models\\Receipt',111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1182.12,NULL,NULL,1,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(518,2973,40722,3057,2,112,'App\\Models\\Receipt',112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1364.79,NULL,NULL,1,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(519,2973,40722,3057,2,113,'App\\Models\\Receipt',113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',2206.25,NULL,NULL,1,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(520,2973,40722,3057,2,114,'App\\Models\\Receipt',114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',340.70,NULL,NULL,1,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(521,2973,40722,3057,2,115,'App\\Models\\Receipt',115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1060.35,NULL,NULL,1,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(522,2973,40722,3057,2,116,'App\\Models\\Receipt',116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1330.45,NULL,NULL,1,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(523,2973,40722,3057,2,117,'App\\Models\\Receipt',117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1465.64,NULL,NULL,1,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(524,2973,40722,3057,2,118,'App\\Models\\Receipt',118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',3690.50,NULL,NULL,1,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(525,2973,40722,3057,2,119,'App\\Models\\Receipt',119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1232.15,NULL,NULL,1,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(526,2973,40722,3057,2,120,'App\\Models\\Receipt',120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',2080.54,NULL,NULL,1,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(527,2973,40722,3057,2,121,'App\\Models\\Receipt',121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',2825.38,NULL,NULL,1,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(528,2973,40722,3057,2,122,'App\\Models\\Receipt',122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',996.60,NULL,NULL,1,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(529,2973,40722,3057,2,123,'App\\Models\\Receipt',123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1060.35,NULL,NULL,1,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(530,2973,40722,3057,2,124,'App\\Models\\Receipt',124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',692.00,NULL,NULL,1,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(531,2973,40722,3057,2,125,'App\\Models\\Receipt',125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',2289.22,NULL,NULL,1,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(532,2973,40722,3057,2,126,'App\\Models\\Receipt',126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',9248.21,NULL,NULL,1,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(533,2973,40722,3057,2,127,'App\\Models\\Receipt',127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',6864.00,NULL,NULL,1,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(534,2973,40722,3057,2,128,'App\\Models\\Receipt',128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',2788.33,NULL,NULL,1,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(535,2973,40722,3057,2,129,'App\\Models\\Receipt',129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',4051.00,NULL,NULL,1,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(536,2973,40722,3057,2,130,'App\\Models\\Receipt',130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',213.84,NULL,NULL,1,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL);
INSERT INTO `balance_libro` VALUES (537,2973,40722,3057,2,131,'App\\Models\\Receipt',131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1653.62,NULL,NULL,1,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(538,2973,40722,3057,2,132,'App\\Models\\Receipt',132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',2516.80,NULL,NULL,1,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(539,2973,40722,3057,2,133,'App\\Models\\Receipt',133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',379.50,NULL,NULL,1,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(540,2973,40722,3057,2,134,'App\\Models\\Receipt',134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1702.00,NULL,NULL,1,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(541,2973,40722,3057,2,135,'App\\Models\\Receipt',135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',2039.66,NULL,NULL,1,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(542,2973,40722,3057,2,136,'App\\Models\\Receipt',136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',5556.70,NULL,NULL,1,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(543,2973,40722,3057,2,137,'App\\Models\\Receipt',137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',979.00,NULL,NULL,1,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(544,2973,40722,3057,2,138,'App\\Models\\Receipt',138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1328.26,NULL,NULL,1,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(545,2973,40722,3057,2,139,'App\\Models\\Receipt',139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',2216.99,NULL,NULL,1,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(546,2973,40722,3057,2,140,'App\\Models\\Receipt',140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1060.35,NULL,NULL,1,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(547,2973,40722,3057,2,141,'App\\Models\\Receipt',141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1288.14,NULL,NULL,1,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(548,2973,40722,3057,2,142,'App\\Models\\Receipt',142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',857.58,NULL,NULL,1,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(549,2973,40722,3057,2,143,'App\\Models\\Receipt',143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1225.68,NULL,NULL,1,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(550,2973,40722,3057,2,144,'App\\Models\\Receipt',144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',8769.45,NULL,NULL,1,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(551,2973,40722,3057,2,145,'App\\Models\\Receipt',145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',4063.14,NULL,NULL,1,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(552,2973,40722,3057,2,146,'App\\Models\\Receipt',146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1717.47,NULL,NULL,1,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(553,2973,40722,3057,2,147,'App\\Models\\Receipt',147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',532.00,NULL,NULL,1,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(554,2973,40722,3057,2,148,'App\\Models\\Receipt',148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',532.00,NULL,NULL,1,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(555,2973,40722,3057,2,149,'App\\Models\\Receipt',149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',884.00,NULL,NULL,1,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(556,2973,40722,3057,2,150,'App\\Models\\Receipt',150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',852.00,NULL,NULL,1,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(557,2973,40722,3057,2,151,'App\\Models\\Receipt',151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',884.00,NULL,NULL,1,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL);
INSERT INTO `balance_libro` VALUES (558,2973,40722,3057,2,152,'App\\Models\\Receipt',152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',2847.00,NULL,NULL,1,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(559,2973,40722,3057,2,153,'App\\Models\\Receipt',153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',955.00,NULL,NULL,1,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(560,2973,40722,3057,2,154,'App\\Models\\Receipt',154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',2742.00,NULL,NULL,1,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(561,2973,40722,3057,2,155,'App\\Models\\Receipt',155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',3592.00,NULL,NULL,1,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(562,2973,40722,3057,2,156,'App\\Models\\Receipt',156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',1154.00,NULL,NULL,1,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(563,2973,40722,3057,2,157,'App\\Models\\Receipt',157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',4972.00,NULL,NULL,1,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(564,2973,40722,3057,2,158,'App\\Models\\Receipt',158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',1345.00,NULL,NULL,1,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(565,2973,40722,3057,2,159,'App\\Models\\Receipt',159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',532.00,NULL,NULL,1,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(566,2973,40722,3057,2,160,'App\\Models\\Receipt',160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',3412.00,NULL,NULL,1,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(567,2973,40722,3057,2,161,'App\\Models\\Receipt',161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',1308.00,NULL,NULL,1,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(568,2973,40722,3057,2,162,'App\\Models\\Receipt',162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',1078.00,NULL,NULL,1,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(569,2973,40722,3057,2,163,'App\\Models\\Receipt',163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',1659.00,NULL,NULL,1,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(570,2973,40722,3057,2,164,'App\\Models\\Receipt',164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',6555.00,NULL,NULL,1,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(571,2973,40722,3057,2,165,'App\\Models\\Receipt',165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',2708.00,NULL,NULL,1,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(572,2973,40722,3057,2,166,'App\\Models\\Receipt',166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',884.00,NULL,NULL,1,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(573,2973,40722,3057,2,167,'App\\Models\\Receipt',167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',2026.50,NULL,NULL,1,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(574,2973,40722,3057,2,168,'App\\Models\\Receipt',168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',891.00,NULL,NULL,1,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(575,2973,40722,3057,2,169,'App\\Models\\Receipt',169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',2260.50,NULL,NULL,1,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(576,2973,40722,3057,2,170,'App\\Models\\Receipt',170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',1342.00,NULL,NULL,1,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(577,2973,40722,3057,2,171,'App\\Models\\Receipt',171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',1596.00,NULL,NULL,1,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(578,2973,40722,3057,2,172,'App\\Models\\Receipt',172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',2942.00,NULL,NULL,1,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL);
INSERT INTO `balance_libro` VALUES (579,2973,40722,3057,2,173,'App\\Models\\Receipt',173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',1480.00,NULL,NULL,1,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(580,2973,40722,3057,2,174,'App\\Models\\Receipt',174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',3274.00,NULL,NULL,1,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(581,2973,40722,3057,2,175,'App\\Models\\Receipt',175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',1300.00,NULL,NULL,1,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(582,2973,40722,3057,2,176,'App\\Models\\Receipt',176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',2890.00,NULL,NULL,1,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(583,2973,40722,3057,2,177,'App\\Models\\Receipt',177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',2879.10,NULL,NULL,1,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(584,2973,40722,3057,2,178,'App\\Models\\Receipt',178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',9297.00,NULL,NULL,1,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(585,2973,40722,3057,2,179,'App\\Models\\Receipt',179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',4565.00,NULL,NULL,1,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(586,2973,40722,3057,2,180,'App\\Models\\Receipt',180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',4555.00,NULL,NULL,1,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(587,2973,40722,3057,2,181,'App\\Models\\Receipt',181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',1780.00,NULL,NULL,1,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(588,2973,40722,3057,2,182,'App\\Models\\Receipt',182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',491.00,NULL,NULL,1,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(589,2973,40722,3057,2,183,'App\\Models\\Receipt',183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',981.99,NULL,NULL,1,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(590,2973,40722,3057,2,184,'App\\Models\\Receipt',184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',3016.99,NULL,NULL,1,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(591,2973,40722,3057,2,185,'App\\Models\\Receipt',185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',5501.99,NULL,NULL,1,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(592,2973,40722,3057,2,186,'App\\Models\\Receipt',186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',2999.00,NULL,NULL,1,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(593,2973,40722,3057,2,187,'App\\Models\\Receipt',187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',2446.36,NULL,NULL,1,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(594,2973,40722,3057,2,188,'App\\Models\\Receipt',188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',3226.00,NULL,NULL,1,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(595,2973,40722,3057,2,189,'App\\Models\\Receipt',189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',12850.00,NULL,NULL,1,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(596,2973,40722,3057,2,190,'App\\Models\\Receipt',190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',948.15,NULL,NULL,1,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(597,2973,40722,3057,2,191,'App\\Models\\Receipt',191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',2800.00,NULL,NULL,1,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(598,2973,40722,3057,2,192,'App\\Models\\Receipt',192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',454.00,NULL,NULL,1,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(599,2973,40722,3057,2,193,'App\\Models\\Receipt',193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',1402.00,NULL,NULL,1,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL);
INSERT INTO `balance_libro` VALUES (600,2973,40722,3057,2,194,'App\\Models\\Receipt',194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',4109.00,NULL,NULL,1,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(601,2973,40722,3057,2,195,'App\\Models\\Receipt',195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',12850.00,NULL,NULL,1,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(602,2973,40722,3057,2,196,'App\\Models\\Receipt',196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',2879.10,NULL,NULL,1,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(603,2973,40722,3057,2,197,'App\\Models\\Receipt',197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',948.15,NULL,NULL,1,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(604,2973,40722,3057,2,198,'App\\Models\\Receipt',198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',442.00,NULL,NULL,1,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(605,2973,40722,3057,2,199,'App\\Models\\Receipt',199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',2170.00,NULL,NULL,1,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(606,2973,40722,3057,2,200,'App\\Models\\Receipt',200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',1724.00,NULL,NULL,1,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(607,2973,40722,3057,2,201,'App\\Models\\Receipt',201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',3450.00,NULL,NULL,1,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(608,2973,40722,3057,2,202,'App\\Models\\Receipt',202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',5134.00,NULL,NULL,1,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(609,2973,40722,3057,2,203,'App\\Models\\Receipt',203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',2847.00,NULL,NULL,1,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(610,2973,40722,3057,2,204,'App\\Models\\Receipt',204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',4630.00,NULL,NULL,1,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(611,2973,40722,3057,2,205,'App\\Models\\Receipt',205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',3982.00,NULL,NULL,1,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(612,2973,40722,3057,2,206,'App\\Models\\Receipt',206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',1206.00,NULL,NULL,1,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(613,2973,40722,3057,2,207,'App\\Models\\Receipt',207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',1401.99,NULL,NULL,1,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(614,2973,40722,3057,2,208,'App\\Models\\Receipt',208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',4996.00,NULL,NULL,1,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(615,2973,40722,3057,3,209,'App\\Models\\Receipt',209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',104.63,NULL,NULL,1,'2021-08-10 17:41:01','2021-08-10 17:41:01',NULL),(616,2973,40722,3057,3,210,'App\\Models\\Receipt',210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',45.05,NULL,NULL,1,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(617,2973,40722,3057,3,211,'App\\Models\\Receipt',211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',116.70,NULL,NULL,1,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(618,2973,40722,3057,3,212,'App\\Models\\Receipt',212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',4000.00,NULL,NULL,1,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(619,2973,40722,3057,3,213,'App\\Models\\Receipt',213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',7000.00,NULL,NULL,1,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(620,2973,40722,3057,3,214,'App\\Models\\Receipt',214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',33.00,NULL,NULL,1,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL);
INSERT INTO `balance_libro` VALUES (621,2973,40722,3057,3,215,'App\\Models\\Receipt',215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',974.66,NULL,NULL,1,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(622,2973,40722,3057,3,216,'App\\Models\\Receipt',216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',49.30,NULL,NULL,1,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(623,2973,40722,3057,3,217,'App\\Models\\Receipt',217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',401.07,NULL,NULL,1,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(624,2973,40722,3057,3,218,'App\\Models\\Receipt',218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',226.40,NULL,NULL,1,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(625,2973,40722,3057,3,219,'App\\Models\\Receipt',219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',542.00,NULL,NULL,1,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(626,2973,40722,3057,3,220,'App\\Models\\Receipt',220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',952.04,NULL,NULL,1,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(627,2973,40722,3057,3,221,'App\\Models\\Receipt',221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',118035.59,NULL,NULL,1,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(628,2973,40722,3057,3,222,'App\\Models\\Receipt',222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',110062.65,NULL,NULL,1,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(629,2973,40722,3057,3,223,'App\\Models\\Receipt',223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',412698.33,NULL,NULL,1,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(630,2973,40720,1541,23,630,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',1277259.76,'Ajuste por Inflacion Asiento Anual',NULL,1,'2021-08-20 06:48:09','2021-08-20 07:54:20','2021-08-20 07:54:20'),(631,2973,40720,1541,23,631,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',1277259.76,'Ajuste por Inflacion Asiento Anual',NULL,1,'2021-08-23 16:36:33','2021-08-23 16:36:35',NULL),(632,2973,40720,1541,17,632,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',7483823.46,'RESULTADO DEL EJERCICIO',NULL,1,'2021-08-24 16:37:58','2021-08-24 16:41:08','2021-08-24 16:41:08'),(633,2973,40720,1541,17,633,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',7483823.46,'RESULTADO DEL EJERCICIO',NULL,1,'2021-08-24 16:41:08','2021-08-28 12:36:49','2021-08-28 12:36:49'),(634,2973,40720,1530,19,634,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',1577027.02,NULL,NULL,1,'2021-08-24 17:39:11','2021-08-24 17:39:11',NULL),(635,2973,40720,1530,19,635,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',1348363.78,NULL,NULL,1,'2021-08-24 17:42:03','2021-08-24 17:42:03',NULL),(636,2973,40720,1531,19,636,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',175000.00,NULL,NULL,1,'2021-08-24 17:43:24','2021-08-24 17:43:24',NULL),(637,2973,40720,1531,19,637,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',1978558.52,NULL,NULL,1,'2021-08-24 17:44:50','2021-08-24 18:09:57','2021-08-24 18:09:57'),(638,2973,40720,1532,19,638,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',1486679.83,NULL,NULL,1,'2021-08-24 17:47:04','2021-08-24 17:47:04',NULL),(639,2973,40720,1533,19,639,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',660179.13,NULL,NULL,1,'2021-08-24 17:48:22','2021-08-24 17:48:22',NULL),(640,2973,40720,1534,19,640,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',850500.00,NULL,NULL,1,'2021-08-24 17:49:23','2021-08-24 17:49:23',NULL);
INSERT INTO `balance_libro` VALUES (641,2973,40720,1534,19,641,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',1145559.46,NULL,NULL,1,'2021-08-24 17:50:27','2021-08-24 17:50:27',NULL),(642,2973,40720,1535,19,642,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',1179064.36,NULL,NULL,1,'2021-08-24 17:51:20','2021-08-24 17:51:20',NULL),(643,2973,40720,1536,19,643,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',910275.10,NULL,NULL,1,'2021-08-24 17:52:22','2021-08-24 17:52:22',NULL),(644,2973,40720,1537,19,644,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',1070361.34,NULL,NULL,1,'2021-08-24 17:53:19','2021-08-24 17:53:19',NULL),(645,2973,40720,1538,19,645,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1478534.38,NULL,NULL,1,'2021-08-24 17:54:24','2021-08-24 17:54:24',NULL),(646,2973,40720,1539,19,646,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',1073398.82,NULL,NULL,1,'2021-08-24 17:55:18','2021-08-24 17:55:18',NULL),(647,2973,40720,1540,19,647,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',1119211.72,NULL,NULL,1,'2021-08-24 17:56:34','2021-08-24 17:56:34',NULL),(648,2973,40720,1541,19,648,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',1909582.84,NULL,NULL,1,'2021-08-24 17:57:25','2021-08-24 17:57:25',NULL),(649,2973,40720,1531,19,649,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',1978558.52,NULL,NULL,1,'2021-08-24 18:09:57','2021-08-24 18:20:48','2021-08-24 18:20:48'),(650,2973,40720,1531,19,650,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-28','2019-02-28',1978558.52,NULL,NULL,1,'2021-08-24 18:20:48','2021-08-24 18:23:27','2021-08-24 18:23:27'),(651,2973,40720,1531,19,651,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',1978558.52,NULL,NULL,1,'2021-08-24 18:23:27','2021-08-25 08:23:33','2021-08-25 08:23:33'),(652,2973,40720,1531,19,652,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-02-28','2020-02-28',1978558.52,NULL,NULL,1,'2021-08-25 08:23:33','2021-08-25 08:23:33',NULL),(653,2973,40720,1541,17,653,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',5516625.09,'CIERRE CUENTAS PATRIMONIALES',NULL,1,'2021-08-25 09:03:30','2021-08-28 12:36:36','2021-08-28 12:36:36'),(654,2973,40720,1541,19,654,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',800000.00,NULL,NULL,1,'2021-08-28 11:56:17','2021-08-28 11:56:17',NULL),(655,2973,40720,1541,19,655,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',232977.28,NULL,NULL,1,'2021-08-28 12:31:26','2021-08-28 12:45:04','2021-08-28 12:45:04'),(656,2973,40720,1541,19,656,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',232977.28,NULL,NULL,1,'2021-08-28 12:45:04','2021-08-28 12:45:04',NULL),(657,2973,40720,1541,19,657,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',1038857.27,NULL,NULL,1,'2021-08-28 14:00:48','2021-08-28 14:00:48',NULL),(658,2973,40722,3058,2,224,'App\\Models\\Receipt',224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',3990.00,NULL,NULL,1,'2021-09-09 14:39:50','2021-09-09 14:39:50',NULL),(659,2973,40722,3058,2,225,'App\\Models\\Receipt',225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',3990.00,NULL,NULL,1,'2021-09-09 14:39:50','2021-09-09 14:39:50',NULL),(660,2973,40722,3058,2,226,'App\\Models\\Receipt',226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',3273.99,NULL,NULL,1,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL);
INSERT INTO `balance_libro` VALUES (661,2973,40722,3058,2,227,'App\\Models\\Receipt',227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',8287.99,NULL,NULL,1,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(662,2973,40722,3058,2,228,'App\\Models\\Receipt',228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',2879.10,NULL,NULL,1,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(663,2973,40722,3058,2,229,'App\\Models\\Receipt',229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',174.00,NULL,NULL,1,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(664,2973,40722,3058,2,230,'App\\Models\\Receipt',230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',2366.00,NULL,NULL,1,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(665,2973,40722,3058,2,231,'App\\Models\\Receipt',231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',1888.00,NULL,NULL,1,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(666,2973,40722,3058,2,232,'App\\Models\\Receipt',232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',2068.00,NULL,NULL,1,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(667,2973,40722,3058,2,233,'App\\Models\\Receipt',233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',3997.00,NULL,NULL,1,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(668,2973,40722,3058,2,234,'App\\Models\\Receipt',234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',1626.00,NULL,NULL,1,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(669,2973,40722,3058,2,235,'App\\Models\\Receipt',235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',6481.00,NULL,NULL,1,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(670,2973,40722,3058,2,236,'App\\Models\\Receipt',236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',860.00,NULL,NULL,1,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(671,2973,40722,3058,2,237,'App\\Models\\Receipt',237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',1253.00,NULL,NULL,1,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(672,2973,40722,3058,2,238,'App\\Models\\Receipt',238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',2953.00,NULL,NULL,1,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(673,2973,40722,3058,2,239,'App\\Models\\Receipt',239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',2953.00,NULL,NULL,1,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(674,2973,40722,3058,2,240,'App\\Models\\Receipt',240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',1869.00,NULL,NULL,1,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(675,2973,40722,3058,2,241,'App\\Models\\Receipt',241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',165.00,NULL,NULL,1,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(676,2973,40722,3058,2,242,'App\\Models\\Receipt',242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',860.00,NULL,NULL,1,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(677,2973,40722,3058,2,243,'App\\Models\\Receipt',243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',4754.00,NULL,NULL,1,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(678,2973,40722,3058,2,244,'App\\Models\\Receipt',244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',2108.40,NULL,NULL,1,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(679,2973,40722,3058,2,245,'App\\Models\\Receipt',245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',1154.00,NULL,NULL,1,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(680,2973,40722,3058,2,246,'App\\Models\\Receipt',246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',2303.70,NULL,NULL,1,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(681,2973,40722,3058,2,247,'App\\Models\\Receipt',247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',1045.00,NULL,NULL,1,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL);
INSERT INTO `balance_libro` VALUES (682,2973,40722,3058,2,248,'App\\Models\\Receipt',248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',1871.00,NULL,NULL,1,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(683,2973,40722,3058,2,249,'App\\Models\\Receipt',249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',4841.00,NULL,NULL,1,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(684,2973,40722,3058,2,250,'App\\Models\\Receipt',250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',442.00,NULL,NULL,1,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(685,2973,40722,3058,2,251,'App\\Models\\Receipt',251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',2920.00,NULL,NULL,1,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(686,2973,40722,3058,2,252,'App\\Models\\Receipt',252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',1206.00,NULL,NULL,1,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(687,2973,40722,3058,2,253,'App\\Models\\Receipt',253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',2870.00,NULL,NULL,1,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(688,2973,40722,3058,2,254,'App\\Models\\Receipt',254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',1992.00,NULL,NULL,1,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(689,2973,40722,3058,2,255,'App\\Models\\Receipt',255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',1460.00,NULL,NULL,1,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(690,2973,40722,3058,2,256,'App\\Models\\Receipt',256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',1930.00,NULL,NULL,1,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(691,2973,40722,3058,2,257,'App\\Models\\Receipt',257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',4350.00,NULL,NULL,1,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(692,2973,40722,3058,2,258,'App\\Models\\Receipt',258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',1720.00,NULL,NULL,1,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(693,2973,40722,3058,2,259,'App\\Models\\Receipt',259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',2892.00,NULL,NULL,1,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(694,2973,40722,3058,2,260,'App\\Models\\Receipt',260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',1198.05,NULL,NULL,1,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(695,2973,40722,3058,2,261,'App\\Models\\Receipt',261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',128.00,NULL,NULL,1,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(696,2973,40722,3058,2,262,'App\\Models\\Receipt',262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',2986.00,NULL,NULL,1,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(697,2973,40722,3058,2,263,'App\\Models\\Receipt',263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',727.00,NULL,NULL,1,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(698,2973,40722,3058,2,264,'App\\Models\\Receipt',264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',2193.00,NULL,NULL,1,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(699,2973,40722,3058,2,265,'App\\Models\\Receipt',265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',1000.65,NULL,NULL,1,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(700,2973,40722,3058,2,266,'App\\Models\\Receipt',266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',1000.65,NULL,NULL,1,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(701,2973,40722,3058,2,267,'App\\Models\\Receipt',267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',5609.10,NULL,NULL,1,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(702,2973,40722,3058,2,268,'App\\Models\\Receipt',268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',3290.00,NULL,NULL,1,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL);
INSERT INTO `balance_libro` VALUES (703,2973,40722,3058,2,269,'App\\Models\\Receipt',269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',1645.00,NULL,NULL,1,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(704,2973,40722,3058,2,270,'App\\Models\\Receipt',270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',3368.00,NULL,NULL,1,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(705,2973,40722,3058,2,271,'App\\Models\\Receipt',271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',451.00,NULL,NULL,1,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(706,2973,40722,3058,2,272,'App\\Models\\Receipt',272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',2193.00,NULL,NULL,1,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(707,2973,40722,3058,2,273,'App\\Models\\Receipt',273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',2716.00,NULL,NULL,1,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(708,2973,40722,3058,2,274,'App\\Models\\Receipt',274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',1905.00,NULL,NULL,1,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(709,2973,40722,3058,2,275,'App\\Models\\Receipt',275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',491.00,NULL,NULL,1,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(710,2973,40722,3058,2,276,'App\\Models\\Receipt',276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',6290.00,NULL,NULL,1,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(711,2973,40722,3058,2,277,'App\\Models\\Receipt',277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',4841.00,NULL,NULL,1,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(712,2973,40722,3058,2,278,'App\\Models\\Receipt',278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',1795.05,NULL,NULL,1,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(713,2973,40722,3058,2,279,'App\\Models\\Receipt',279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',1439.55,NULL,NULL,1,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(714,2973,40722,3058,2,280,'App\\Models\\Receipt',280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',5419.00,NULL,NULL,1,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(715,2973,40722,3058,2,281,'App\\Models\\Receipt',281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',663.00,NULL,NULL,1,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(716,2973,40722,3058,2,282,'App\\Models\\Receipt',282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',4148.00,NULL,NULL,1,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(717,2973,40722,3058,2,283,'App\\Models\\Receipt',283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',2371.00,NULL,NULL,1,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(718,2973,40722,3058,2,284,'App\\Models\\Receipt',284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',2461.00,NULL,NULL,1,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(719,2973,40722,3058,2,285,'App\\Models\\Receipt',285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',2502.00,NULL,NULL,1,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(720,2973,40722,3058,2,286,'App\\Models\\Receipt',286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',2803.50,NULL,NULL,1,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(721,2973,40722,3058,2,287,'App\\Models\\Receipt',287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',1045.00,NULL,NULL,1,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(722,2973,40722,3058,2,288,'App\\Models\\Receipt',288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',815.00,NULL,NULL,1,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(723,2973,40722,3058,2,289,'App\\Models\\Receipt',289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',676.00,NULL,NULL,1,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL);
INSERT INTO `balance_libro` VALUES (724,2973,40722,3058,2,290,'App\\Models\\Receipt',290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',1451.00,NULL,NULL,1,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(725,2973,40722,3058,2,291,'App\\Models\\Receipt',291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',1998.00,NULL,NULL,1,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(726,2973,40722,3058,2,292,'App\\Models\\Receipt',292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',762.00,NULL,NULL,1,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(727,2973,40722,3058,2,293,'App\\Models\\Receipt',293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',3963.00,NULL,NULL,1,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(728,2973,40722,3058,2,294,'App\\Models\\Receipt',294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',5901.00,NULL,NULL,1,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(729,2973,40722,3058,2,295,'App\\Models\\Receipt',295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',3275.00,NULL,NULL,1,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(730,2973,40722,3058,2,296,'App\\Models\\Receipt',296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',5827.00,NULL,NULL,1,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(731,2973,40722,3058,2,297,'App\\Models\\Receipt',297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',930.30,NULL,NULL,1,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(732,2973,40722,3058,2,298,'App\\Models\\Receipt',298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',2142.00,NULL,NULL,1,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(733,2973,40722,3058,2,299,'App\\Models\\Receipt',299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',2146.00,NULL,NULL,1,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(734,2973,40722,3058,2,300,'App\\Models\\Receipt',300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',950.00,NULL,NULL,1,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(735,2973,40722,3058,2,301,'App\\Models\\Receipt',301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',5461.00,NULL,NULL,1,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(736,2973,40722,3058,2,302,'App\\Models\\Receipt',302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',7397.00,NULL,NULL,1,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(737,2973,40722,3058,2,303,'App\\Models\\Receipt',303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',2676.05,NULL,NULL,1,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(738,2973,40722,3058,2,304,'App\\Models\\Receipt',304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',5544.99,NULL,NULL,1,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(739,2973,40722,3058,2,305,'App\\Models\\Receipt',305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',4053.72,NULL,NULL,1,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(740,2973,40722,3058,2,306,'App\\Models\\Receipt',306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',793.00,NULL,NULL,1,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(741,2973,40722,3058,2,307,'App\\Models\\Receipt',307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',4490.00,NULL,NULL,1,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(742,2973,40722,3058,2,308,'App\\Models\\Receipt',308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',1262.00,NULL,NULL,1,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(743,2973,40722,3058,2,309,'App\\Models\\Receipt',309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',5840.00,NULL,NULL,1,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(744,2973,40722,3058,2,310,'App\\Models\\Receipt',310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',4520.00,NULL,NULL,1,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL);
INSERT INTO `balance_libro` VALUES (745,2973,40722,3058,2,311,'App\\Models\\Receipt',311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',1001.70,NULL,NULL,1,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(746,2973,40722,3058,2,312,'App\\Models\\Receipt',312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',884.00,NULL,NULL,1,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(747,2973,40722,3058,2,313,'App\\Models\\Receipt',313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',4109.00,NULL,NULL,1,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(748,2973,40722,3058,2,314,'App\\Models\\Receipt',314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',680.00,NULL,NULL,1,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(749,2973,40722,3058,2,315,'App\\Models\\Receipt',315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',2572.00,NULL,NULL,1,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(750,2973,40722,3058,2,316,'App\\Models\\Receipt',316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',1358.00,NULL,NULL,1,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(751,2973,40722,3058,2,317,'App\\Models\\Receipt',317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',1517.25,NULL,NULL,1,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(752,2973,40722,3058,2,318,'App\\Models\\Receipt',318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',1363.95,NULL,NULL,1,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(753,2973,40722,3058,2,319,'App\\Models\\Receipt',319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',1253.00,NULL,NULL,1,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(754,2973,40722,3058,2,320,'App\\Models\\Receipt',320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',1078.00,NULL,NULL,1,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(755,2973,40722,3058,2,321,'App\\Models\\Receipt',321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',4056.00,NULL,NULL,1,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(756,2973,40722,3058,2,322,'App\\Models\\Receipt',322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',2342.50,NULL,NULL,1,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(757,2973,40722,3058,2,323,'App\\Models\\Receipt',323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',7328.00,NULL,NULL,1,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(758,2973,40722,3058,2,324,'App\\Models\\Receipt',324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',989.00,NULL,NULL,1,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(759,2973,40722,3058,2,325,'App\\Models\\Receipt',325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',1366.00,NULL,NULL,1,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(760,2973,40722,3058,2,326,'App\\Models\\Receipt',326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',1193.00,NULL,NULL,1,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(761,2973,40722,3058,2,327,'App\\Models\\Receipt',327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',4056.00,NULL,NULL,1,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(762,2973,40722,3058,2,328,'App\\Models\\Receipt',328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',5827.00,NULL,NULL,1,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(763,2973,40722,3058,2,329,'App\\Models\\Receipt',329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',1345.00,NULL,NULL,1,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(764,2973,40722,3058,2,330,'App\\Models\\Receipt',330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',2072.30,NULL,NULL,1,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(765,2973,40722,3058,2,331,'App\\Models\\Receipt',331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',465.75,NULL,NULL,1,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL);
INSERT INTO `balance_libro` VALUES (766,2973,40722,3058,2,332,'App\\Models\\Receipt',332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',1045.00,NULL,NULL,1,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(767,2973,40722,3058,2,333,'App\\Models\\Receipt',333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',3395.95,NULL,NULL,1,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(768,2973,40722,3058,2,334,'App\\Models\\Receipt',334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',1045.00,NULL,NULL,1,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(769,2973,40722,3058,2,335,'App\\Models\\Receipt',335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',2146.00,NULL,NULL,1,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(770,2973,40722,3058,2,336,'App\\Models\\Receipt',336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',990.08,NULL,NULL,1,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(771,2973,40722,3058,2,337,'App\\Models\\Receipt',337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',760.00,NULL,NULL,1,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(772,2973,40722,3058,2,338,'App\\Models\\Receipt',338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',2179.25,NULL,NULL,1,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(773,2973,40722,3058,2,339,'App\\Models\\Receipt',339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',3426.20,NULL,NULL,1,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(774,2973,40722,3058,2,340,'App\\Models\\Receipt',340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',1324.00,NULL,NULL,1,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(775,2973,40722,3058,2,341,'App\\Models\\Receipt',341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',2490.00,NULL,NULL,1,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(776,2973,40722,3058,2,342,'App\\Models\\Receipt',342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',3782.10,NULL,NULL,1,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(777,2973,40722,3058,2,343,'App\\Models\\Receipt',343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',1915.20,NULL,NULL,1,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(778,2973,40722,3058,2,344,'App\\Models\\Receipt',344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',506.24,NULL,NULL,1,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(779,2973,40722,3058,2,345,'App\\Models\\Receipt',345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',4056.00,NULL,NULL,1,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(780,2973,40722,3058,2,346,'App\\Models\\Receipt',346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',1802.08,NULL,NULL,1,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(781,2973,40722,3058,2,347,'App\\Models\\Receipt',347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',3290.00,NULL,NULL,1,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(782,2973,40722,3058,2,348,'App\\Models\\Receipt',348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',10105.00,NULL,NULL,1,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(783,2973,40722,3058,2,349,'App\\Models\\Receipt',349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',505.12,NULL,NULL,1,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(784,2973,40722,3058,2,350,'App\\Models\\Receipt',350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',2357.50,NULL,NULL,1,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(785,2973,40722,3058,2,351,'App\\Models\\Receipt',351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',5501.99,NULL,NULL,1,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(786,2973,40722,3058,2,352,'App\\Models\\Receipt',352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',2676.05,NULL,NULL,1,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL);
INSERT INTO `balance_libro` VALUES (787,2973,40722,3058,2,353,'App\\Models\\Receipt',353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',5107.19,NULL,NULL,1,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(788,2973,40722,3058,2,354,'App\\Models\\Receipt',354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',993.00,NULL,NULL,1,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(789,2973,40722,3058,2,355,'App\\Models\\Receipt',355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',4555.00,NULL,NULL,1,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(790,2973,40722,3058,2,356,'App\\Models\\Receipt',356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',1324.00,NULL,NULL,1,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(791,2973,40722,3058,2,357,'App\\Models\\Receipt',357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',3584.16,NULL,NULL,1,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(792,2973,40722,3058,2,358,'App\\Models\\Receipt',358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',1517.25,NULL,NULL,1,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(793,2973,40722,3058,2,359,'App\\Models\\Receipt',359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',4274.00,NULL,NULL,1,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(794,2973,40722,3058,2,360,'App\\Models\\Receipt',360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',6684.10,NULL,NULL,1,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(795,2973,40722,3058,2,361,'App\\Models\\Receipt',361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',1629.60,NULL,NULL,1,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(796,2973,40722,3058,2,362,'App\\Models\\Receipt',362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',4272.50,NULL,NULL,1,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(797,2973,40722,3058,2,363,'App\\Models\\Receipt',363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',2320.00,NULL,NULL,1,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(798,2973,40722,3058,2,364,'App\\Models\\Receipt',364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',2494.80,NULL,NULL,1,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(799,2973,40722,3058,2,365,'App\\Models\\Receipt',365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',4972.00,NULL,NULL,1,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(800,2973,40722,3058,2,366,'App\\Models\\Receipt',366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',989.00,NULL,NULL,1,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(801,2973,40722,3058,2,367,'App\\Models\\Receipt',367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',2001.30,NULL,NULL,1,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(802,2973,40722,3058,2,368,'App\\Models\\Receipt',368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',9394.28,NULL,NULL,1,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(803,2973,40722,3058,2,369,'App\\Models\\Receipt',369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',1028.00,NULL,NULL,1,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(804,2973,40722,3058,2,370,'App\\Models\\Receipt',370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',1332.00,NULL,NULL,1,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(805,2973,40722,3058,2,371,'App\\Models\\Receipt',371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',1453.00,NULL,NULL,1,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(806,2973,40722,3058,2,372,'App\\Models\\Receipt',372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',862.40,NULL,NULL,1,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(807,2973,40722,3058,2,373,'App\\Models\\Receipt',373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',1390.35,NULL,NULL,1,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL);
INSERT INTO `balance_libro` VALUES (808,2973,40722,3058,2,374,'App\\Models\\Receipt',374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',950.00,NULL,NULL,1,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(809,2973,40722,3058,2,375,'App\\Models\\Receipt',375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',6209.00,NULL,NULL,1,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(810,2973,40722,3058,2,376,'App\\Models\\Receipt',376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',6441.80,NULL,NULL,1,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(811,2973,40722,3058,2,377,'App\\Models\\Receipt',377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',315.00,NULL,NULL,1,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(812,2973,40722,3058,2,378,'App\\Models\\Receipt',378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',2461.00,NULL,NULL,1,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(813,2973,40722,3058,2,379,'App\\Models\\Receipt',379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',3480.00,NULL,NULL,1,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(814,2973,40722,3058,2,380,'App\\Models\\Receipt',380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',3771.60,NULL,NULL,1,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(815,2973,40722,3058,2,381,'App\\Models\\Receipt',381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',989.00,NULL,NULL,1,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(816,2973,40722,3058,2,382,'App\\Models\\Receipt',382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',630.00,NULL,NULL,1,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(817,2973,40722,3058,2,383,'App\\Models\\Receipt',383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',1426.00,NULL,NULL,1,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(818,2973,40722,3058,2,384,'App\\Models\\Receipt',384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',2879.10,NULL,NULL,1,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(819,2973,40722,3058,2,385,'App\\Models\\Receipt',385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',853.30,NULL,NULL,1,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(820,2973,40722,3058,2,386,'App\\Models\\Receipt',386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',2341.40,NULL,NULL,1,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(821,2973,40722,3058,2,387,'App\\Models\\Receipt',387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',3290.00,NULL,NULL,1,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(822,2973,40722,3058,2,388,'App\\Models\\Receipt',388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',2919.70,NULL,NULL,1,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(823,2973,40722,3058,2,389,'App\\Models\\Receipt',389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',1115.00,NULL,NULL,1,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(824,2973,40722,3058,2,390,'App\\Models\\Receipt',390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',465.15,NULL,NULL,1,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(825,2973,40722,3058,2,391,'App\\Models\\Receipt',391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',1439.55,NULL,NULL,1,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(826,2973,40722,3058,2,392,'App\\Models\\Receipt',392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',1358.00,NULL,NULL,1,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(827,2973,40722,3058,2,393,'App\\Models\\Receipt',393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',2460.68,NULL,NULL,1,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(828,2973,40722,3058,2,394,'App\\Models\\Receipt',394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',1446.00,NULL,NULL,1,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL);
INSERT INTO `balance_libro` VALUES (829,2973,40722,3058,2,395,'App\\Models\\Receipt',395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',1000.65,NULL,NULL,1,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(830,2973,40722,3058,2,396,'App\\Models\\Receipt',396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',1539.00,NULL,NULL,1,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(831,2973,40722,3058,2,397,'App\\Models\\Receipt',397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',150.00,NULL,NULL,1,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(832,2973,40722,3058,2,398,'App\\Models\\Receipt',398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',3395.95,NULL,NULL,1,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(833,2973,40722,3058,2,399,'App\\Models\\Receipt',399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',1054.20,NULL,NULL,1,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(834,2973,40722,3058,2,400,'App\\Models\\Receipt',400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',875.84,NULL,NULL,1,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(835,2973,40722,3058,2,401,'App\\Models\\Receipt',401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',3792.70,NULL,NULL,1,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(836,2973,40722,3058,2,402,'App\\Models\\Receipt',402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',5376.00,NULL,NULL,1,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(837,2973,40722,3058,2,403,'App\\Models\\Receipt',403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',1954.00,NULL,NULL,1,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(838,2973,40722,3058,2,404,'App\\Models\\Receipt',404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',4489.38,NULL,NULL,1,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(839,2973,40722,3058,2,405,'App\\Models\\Receipt',405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',4114.70,NULL,NULL,1,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(840,2973,40722,3058,2,406,'App\\Models\\Receipt',406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',1420.00,NULL,NULL,1,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(841,2973,40722,3058,2,407,'App\\Models\\Receipt',407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',8530.00,NULL,NULL,1,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(842,2973,40722,3058,2,408,'App\\Models\\Receipt',408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',1446.00,NULL,NULL,1,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(843,2973,40722,3058,2,409,'App\\Models\\Receipt',409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',5728.15,NULL,NULL,1,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(844,2973,40722,3058,2,410,'App\\Models\\Receipt',410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',5315.00,NULL,NULL,1,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(845,2973,40722,3058,2,411,'App\\Models\\Receipt',411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',4060.46,NULL,NULL,1,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(846,2973,40722,3058,2,412,'App\\Models\\Receipt',412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',1635.84,NULL,NULL,1,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(847,2973,40722,3058,2,413,'App\\Models\\Receipt',413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',4891.00,NULL,NULL,1,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(848,2973,40722,3058,2,414,'App\\Models\\Receipt',414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',1324.00,NULL,NULL,1,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(849,2973,40722,3058,2,415,'App\\Models\\Receipt',415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',1206.00,NULL,NULL,1,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL);
INSERT INTO `balance_libro` VALUES (850,2973,40722,3058,2,416,'App\\Models\\Receipt',416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',2902.00,NULL,NULL,1,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(851,2973,40722,3058,2,417,'App\\Models\\Receipt',417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',16742.00,NULL,NULL,1,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(852,2973,40722,3058,2,418,'App\\Models\\Receipt',418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',530.88,NULL,NULL,1,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(853,2973,40722,3058,2,419,'App\\Models\\Receipt',419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',2600.00,NULL,NULL,1,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(854,2973,40722,3058,2,420,'App\\Models\\Receipt',420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',1184.00,NULL,NULL,1,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(855,2973,40722,3058,2,421,'App\\Models\\Receipt',421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',5609.10,NULL,NULL,1,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(856,2973,40722,3058,2,422,'App\\Models\\Receipt',422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',1324.80,NULL,NULL,1,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(857,2973,40722,3058,2,423,'App\\Models\\Receipt',423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',1402.00,NULL,NULL,1,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(858,2973,40722,3058,2,424,'App\\Models\\Receipt',424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',315.00,NULL,NULL,1,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(859,2973,40722,3058,2,425,'App\\Models\\Receipt',425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',647.00,NULL,NULL,1,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(860,2973,40722,3058,2,426,'App\\Models\\Receipt',426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',315.00,NULL,NULL,1,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(861,2973,40722,3058,2,427,'App\\Models\\Receipt',427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',2177.00,NULL,NULL,1,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(862,2973,40722,3058,2,428,'App\\Models\\Receipt',428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',9280.50,NULL,NULL,1,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(863,2973,40722,3058,2,429,'App\\Models\\Receipt',429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',5455.80,NULL,NULL,1,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(864,2973,40722,3058,2,430,'App\\Models\\Receipt',430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',2214.00,NULL,NULL,1,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(865,2973,40722,3058,2,431,'App\\Models\\Receipt',431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',400.00,NULL,NULL,1,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(866,2973,40722,3058,2,432,'App\\Models\\Receipt',432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',1841.70,NULL,NULL,1,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(867,2973,40722,3058,2,433,'App\\Models\\Receipt',433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',1746.00,NULL,NULL,1,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(868,2973,40722,3058,2,434,'App\\Models\\Receipt',434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',3233.00,NULL,NULL,1,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(869,2973,40722,3058,2,435,'App\\Models\\Receipt',435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',2895.90,NULL,NULL,1,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(870,2973,40722,3058,2,436,'App\\Models\\Receipt',436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',2193.00,NULL,NULL,1,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL);
INSERT INTO `balance_libro` VALUES (871,2973,40722,3058,2,437,'App\\Models\\Receipt',437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',10504.00,NULL,NULL,1,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(872,2973,40722,3058,2,438,'App\\Models\\Receipt',438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',2990.00,NULL,NULL,1,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(873,2973,40722,3058,2,439,'App\\Models\\Receipt',439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',3232.00,NULL,NULL,1,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(874,2973,40722,3058,2,440,'App\\Models\\Receipt',440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',3395.95,NULL,NULL,1,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(875,2973,40722,3058,2,441,'App\\Models\\Receipt',441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',3226.00,NULL,NULL,1,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(876,2973,40722,3058,2,442,'App\\Models\\Receipt',442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',1803.80,NULL,NULL,1,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(877,2973,40722,3058,2,443,'App\\Models\\Receipt',443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',1746.00,NULL,NULL,1,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(878,2973,40722,3058,2,444,'App\\Models\\Receipt',444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',3200.00,NULL,NULL,1,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(879,2973,40722,3058,2,445,'App\\Models\\Receipt',445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',4715.00,NULL,NULL,1,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(880,2973,40722,3058,2,446,'App\\Models\\Receipt',446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',2000.00,NULL,NULL,1,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(881,2973,40722,3058,2,447,'App\\Models\\Receipt',447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',6555.00,NULL,NULL,1,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(882,2973,40722,3058,2,448,'App\\Models\\Receipt',448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',495.04,NULL,NULL,1,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(883,2973,40722,3058,2,449,'App\\Models\\Receipt',449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',2562.00,NULL,NULL,1,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(884,2973,40722,3058,2,450,'App\\Models\\Receipt',450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',455.92,NULL,NULL,1,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(885,2973,40722,3058,2,451,'App\\Models\\Receipt',451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',2192.00,NULL,NULL,1,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(886,2973,40722,3058,2,452,'App\\Models\\Receipt',452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',2016.00,NULL,NULL,1,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(887,2973,40722,3058,2,453,'App\\Models\\Receipt',453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',7397.00,NULL,NULL,1,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(888,2973,40722,3058,2,454,'App\\Models\\Receipt',454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',571.00,NULL,NULL,1,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(889,2973,40722,3058,2,455,'App\\Models\\Receipt',455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',1457.55,NULL,NULL,1,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(890,2973,40722,3058,2,456,'App\\Models\\Receipt',456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',3506.00,NULL,NULL,1,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(891,2973,40722,3058,2,457,'App\\Models\\Receipt',457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',2926.00,NULL,NULL,1,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL);
INSERT INTO `balance_libro` VALUES (892,2973,40722,3058,2,458,'App\\Models\\Receipt',458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',1276.12,NULL,NULL,1,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(893,2973,40722,3058,2,459,'App\\Models\\Receipt',459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',1204.00,NULL,NULL,1,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(894,2973,40722,3058,2,460,'App\\Models\\Receipt',460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',2070.00,NULL,NULL,1,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(895,2973,40722,3058,2,461,'App\\Models\\Receipt',461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',4035.00,NULL,NULL,1,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(896,2973,40722,3058,2,462,'App\\Models\\Receipt',462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',9338.00,NULL,NULL,1,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(897,2973,40722,3058,2,463,'App\\Models\\Receipt',463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',2364.00,NULL,NULL,1,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(898,2973,40722,3058,2,464,'App\\Models\\Receipt',464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',3118.00,NULL,NULL,1,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(899,2973,40722,3058,2,465,'App\\Models\\Receipt',465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',4630.00,NULL,NULL,1,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(900,2973,40722,3058,2,466,'App\\Models\\Receipt',466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',4044.90,NULL,NULL,1,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(901,2973,40722,3058,2,467,'App\\Models\\Receipt',467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',1158.00,NULL,NULL,1,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(902,2973,40722,3058,2,468,'App\\Models\\Receipt',468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',1007.00,NULL,NULL,1,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(903,2973,40722,3058,2,469,'App\\Models\\Receipt',469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',4109.00,NULL,NULL,1,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(904,2973,40722,3058,2,470,'App\\Models\\Receipt',470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',2155.00,NULL,NULL,1,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(905,2973,40722,3058,2,471,'App\\Models\\Receipt',471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',3292.00,NULL,NULL,1,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(906,2973,40722,3058,2,472,'App\\Models\\Receipt',472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',1465.95,NULL,NULL,1,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(907,2973,40722,3058,2,473,'App\\Models\\Receipt',473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',593.00,NULL,NULL,1,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(908,2973,40722,3058,2,474,'App\\Models\\Receipt',474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',1199.25,NULL,NULL,1,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(909,2973,40722,3058,2,475,'App\\Models\\Receipt',475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',4350.00,NULL,NULL,1,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(910,2973,40722,3058,2,476,'App\\Models\\Receipt',476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',571.00,NULL,NULL,1,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(911,2973,40722,3058,2,477,'App\\Models\\Receipt',477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',2217.00,NULL,NULL,1,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(912,2973,40722,3058,2,478,'App\\Models\\Receipt',478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',1063.00,NULL,NULL,1,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL);
INSERT INTO `balance_libro` VALUES (913,2973,40722,3058,2,479,'App\\Models\\Receipt',479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',7328.00,NULL,NULL,1,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(914,2973,40722,3058,2,480,'App\\Models\\Receipt',480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',2783.75,NULL,NULL,1,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(915,2973,40722,3058,2,481,'App\\Models\\Receipt',481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',2088.00,NULL,NULL,1,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(916,2973,40722,3058,2,482,'App\\Models\\Receipt',482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',5155.00,NULL,NULL,1,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(917,2973,40722,3058,2,483,'App\\Models\\Receipt',483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',2433.00,NULL,NULL,1,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(918,2973,40722,3058,2,484,'App\\Models\\Receipt',484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',4543.00,NULL,NULL,1,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(919,2973,40722,3058,2,485,'App\\Models\\Receipt',485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',5645.10,NULL,NULL,1,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(920,2973,40722,3058,2,486,'App\\Models\\Receipt',486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',4105.00,NULL,NULL,1,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(921,2973,40722,3058,2,487,'App\\Models\\Receipt',487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',928.56,NULL,NULL,1,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(922,2973,40722,3058,2,488,'App\\Models\\Receipt',488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',574.74,NULL,NULL,1,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(923,2973,40722,3058,2,489,'App\\Models\\Receipt',489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',1351.00,NULL,NULL,1,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(924,2973,40722,3058,2,490,'App\\Models\\Receipt',490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',2037.70,NULL,NULL,1,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(925,2973,40722,3058,2,491,'App\\Models\\Receipt',491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',1330.88,NULL,NULL,1,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(926,2973,40722,3058,2,492,'App\\Models\\Receipt',492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',2700.56,NULL,NULL,1,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(927,2973,40722,3058,2,493,'App\\Models\\Receipt',493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',549.92,NULL,NULL,1,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(928,2973,40722,3058,2,494,'App\\Models\\Receipt',494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',4936.99,NULL,NULL,1,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(929,2973,40722,3058,2,495,'App\\Models\\Receipt',495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',2713.98,NULL,NULL,1,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(930,2973,40722,3058,2,496,'App\\Models\\Receipt',496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',4921.00,NULL,NULL,1,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(931,2973,40722,3058,2,497,'App\\Models\\Receipt',497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',2211.00,NULL,NULL,1,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(932,2973,40722,3058,2,498,'App\\Models\\Receipt',498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',2365.99,NULL,NULL,1,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(933,2973,40722,3058,2,499,'App\\Models\\Receipt',499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',2879.10,NULL,NULL,1,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL);
INSERT INTO `balance_libro` VALUES (934,2973,40722,3058,2,500,'App\\Models\\Receipt',500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',814.80,NULL,NULL,1,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(935,2973,40722,3058,2,501,'App\\Models\\Receipt',501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',4350.00,NULL,NULL,1,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(936,2973,40722,3058,2,502,'App\\Models\\Receipt',502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',3519.60,NULL,NULL,1,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(937,2973,40722,3058,2,503,'App\\Models\\Receipt',503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',2068.00,NULL,NULL,1,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(938,2973,40722,3058,2,504,'App\\Models\\Receipt',504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',869.40,NULL,NULL,1,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(939,2973,40722,3058,2,505,'App\\Models\\Receipt',505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',1277.00,NULL,NULL,1,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(940,2973,40722,3058,2,506,'App\\Models\\Receipt',506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',3351.75,NULL,NULL,1,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(941,2973,40722,3058,2,507,'App\\Models\\Receipt',507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',1056.00,NULL,NULL,1,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(942,2973,40722,3058,2,508,'App\\Models\\Receipt',508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',920.85,NULL,NULL,1,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(943,2973,40722,3058,2,509,'App\\Models\\Receipt',509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',1045.00,NULL,NULL,1,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(944,2973,40722,3058,2,510,'App\\Models\\Receipt',510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',814.80,NULL,NULL,1,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(945,2973,40722,3058,2,511,'App\\Models\\Receipt',511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',4350.00,NULL,NULL,1,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(946,2973,40722,3058,2,512,'App\\Models\\Receipt',512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',12850.00,NULL,NULL,1,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(947,2973,40722,3058,2,513,'App\\Models\\Receipt',513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',1515.00,NULL,NULL,1,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(948,2973,40722,3058,2,514,'App\\Models\\Receipt',514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',786.00,NULL,NULL,1,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(949,2973,40722,3058,2,515,'App\\Models\\Receipt',515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',1841.70,NULL,NULL,1,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(950,2973,40722,3058,2,516,'App\\Models\\Receipt',516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',1841.70,NULL,NULL,1,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(951,2973,40722,3058,2,517,'App\\Models\\Receipt',517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',3204.00,NULL,NULL,1,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(952,2973,40722,3058,2,518,'App\\Models\\Receipt',518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',3634.00,NULL,NULL,1,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(953,2973,40722,3058,2,519,'App\\Models\\Receipt',519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',2371.00,NULL,NULL,1,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(954,2973,40722,3058,2,520,'App\\Models\\Receipt',520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',1045.00,NULL,NULL,1,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL);
INSERT INTO `balance_libro` VALUES (955,2973,40722,3058,2,521,'App\\Models\\Receipt',521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',2804.55,NULL,NULL,1,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(956,2973,40722,3058,2,522,'App\\Models\\Receipt',522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',3106.95,NULL,NULL,1,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(957,2973,40722,3058,2,523,'App\\Models\\Receipt',523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',2415.00,NULL,NULL,1,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(958,2973,40722,3058,2,524,'App\\Models\\Receipt',524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',8407.00,NULL,NULL,1,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(959,2973,40722,3058,2,525,'App\\Models\\Receipt',525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',1046.00,NULL,NULL,1,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(960,2973,40722,3058,2,526,'App\\Models\\Receipt',526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',5155.00,NULL,NULL,1,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(961,2973,40722,3058,2,527,'App\\Models\\Receipt',527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',1342.00,NULL,NULL,1,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(962,2973,40722,3058,2,528,'App\\Models\\Receipt',528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',1166.00,NULL,NULL,1,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(963,2973,40722,3058,2,529,'App\\Models\\Receipt',529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',513.04,NULL,NULL,1,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(964,2973,40722,3058,2,530,'App\\Models\\Receipt',530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',1555.00,NULL,NULL,1,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(965,2973,40722,3058,2,531,'App\\Models\\Receipt',531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',2241.00,NULL,NULL,1,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(966,2973,40722,3058,2,532,'App\\Models\\Receipt',532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',3413.95,NULL,NULL,1,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(967,2973,40722,3058,2,533,'App\\Models\\Receipt',533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',3906.00,NULL,NULL,1,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(968,2973,40722,3058,2,534,'App\\Models\\Receipt',534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',1232.00,NULL,NULL,1,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(969,2973,40722,3058,2,535,'App\\Models\\Receipt',535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',1271.00,NULL,NULL,1,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(970,2973,40722,3058,2,536,'App\\Models\\Receipt',536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',2245.08,NULL,NULL,1,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(971,2973,40722,3058,2,537,'App\\Models\\Receipt',537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',1253.00,NULL,NULL,1,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(972,2973,40722,3058,2,538,'App\\Models\\Receipt',538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',4056.00,NULL,NULL,1,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(973,2973,40722,3058,2,539,'App\\Models\\Receipt',539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',1224.00,NULL,NULL,1,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(974,2973,40722,3058,2,540,'App\\Models\\Receipt',540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',6278.00,NULL,NULL,1,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(975,2973,40722,3058,2,541,'App\\Models\\Receipt',541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',982.12,NULL,NULL,1,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL);
INSERT INTO `balance_libro` VALUES (976,2973,40722,3058,2,542,'App\\Models\\Receipt',542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',2184.00,NULL,NULL,1,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(977,2973,40722,3058,2,543,'App\\Models\\Receipt',543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',1271.00,NULL,NULL,1,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(978,2973,40722,3058,2,544,'App\\Models\\Receipt',544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',793.12,NULL,NULL,1,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(979,2973,40722,3058,2,545,'App\\Models\\Receipt',545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',1100.00,NULL,NULL,1,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(980,2973,40722,3058,2,546,'App\\Models\\Receipt',546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',4572.00,NULL,NULL,1,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(981,2973,40722,3058,2,547,'App\\Models\\Receipt',547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',1471.00,NULL,NULL,1,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(982,2973,40722,3058,2,548,'App\\Models\\Receipt',548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',2321.70,NULL,NULL,1,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(983,2973,40722,3058,2,549,'App\\Models\\Receipt',549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',1101.30,NULL,NULL,1,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(984,2973,40722,3058,2,550,'App\\Models\\Receipt',550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',540.00,NULL,NULL,1,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(985,2973,40722,3058,2,551,'App\\Models\\Receipt',551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',1859.90,NULL,NULL,1,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(986,2973,40722,3058,2,552,'App\\Models\\Receipt',552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',1224.00,NULL,NULL,1,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(987,2973,40722,3058,2,553,'App\\Models\\Receipt',553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',3313.00,NULL,NULL,1,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(988,2973,40722,3058,2,554,'App\\Models\\Receipt',554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',672.00,NULL,NULL,1,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(989,2973,40722,3058,2,555,'App\\Models\\Receipt',555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',2582.00,NULL,NULL,1,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(990,2973,40722,3058,2,556,'App\\Models\\Receipt',556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',5736.00,NULL,NULL,1,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(991,2973,40722,3058,2,557,'App\\Models\\Receipt',557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',427.40,NULL,NULL,1,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(992,2973,40722,3058,2,558,'App\\Models\\Receipt',558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',1253.00,NULL,NULL,1,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(993,2973,40722,3058,2,559,'App\\Models\\Receipt',559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',1593.04,NULL,NULL,1,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(994,2973,40722,3058,2,560,'App\\Models\\Receipt',560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',513.04,NULL,NULL,1,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(995,2973,40722,3058,2,561,'App\\Models\\Receipt',561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',3902.40,NULL,NULL,1,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(996,2973,40722,3058,2,562,'App\\Models\\Receipt',562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',1766.00,NULL,NULL,1,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL);
INSERT INTO `balance_libro` VALUES (997,2973,40722,3058,2,563,'App\\Models\\Receipt',563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',593.00,NULL,NULL,1,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(998,2973,40722,3058,2,564,'App\\Models\\Receipt',564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',432.48,NULL,NULL,1,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(999,2973,40722,3058,2,565,'App\\Models\\Receipt',565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',9271.50,NULL,NULL,1,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(1000,2973,40722,3058,2,566,'App\\Models\\Receipt',566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',1857.11,NULL,NULL,1,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(1001,2973,40722,3058,2,567,'App\\Models\\Receipt',567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',10504.00,NULL,NULL,1,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(1002,2973,40722,3058,2,568,'App\\Models\\Receipt',568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',980.00,NULL,NULL,1,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(1003,2973,40722,3058,2,569,'App\\Models\\Receipt',569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',2207.20,NULL,NULL,1,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(1004,2973,40722,3058,2,570,'App\\Models\\Receipt',570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',1641.00,NULL,NULL,1,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(1005,2973,40722,3058,2,571,'App\\Models\\Receipt',571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',2671.20,NULL,NULL,1,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(1006,2973,40722,3058,2,572,'App\\Models\\Receipt',572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',1523.50,NULL,NULL,1,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(1007,2973,40722,3058,2,573,'App\\Models\\Receipt',573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',1007.00,NULL,NULL,1,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(1008,2973,40722,3058,2,574,'App\\Models\\Receipt',574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',2819.00,NULL,NULL,1,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(1009,2973,40722,3058,2,575,'App\\Models\\Receipt',575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',4981.00,NULL,NULL,1,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(1010,2973,40722,3058,2,576,'App\\Models\\Receipt',576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',2856.00,NULL,NULL,1,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(1011,2973,40722,3058,2,577,'App\\Models\\Receipt',577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',1693.55,NULL,NULL,1,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(1012,2973,40722,3058,2,578,'App\\Models\\Receipt',578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',2759.18,NULL,NULL,1,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(1013,2973,40722,3058,2,579,'App\\Models\\Receipt',579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',2104.00,NULL,NULL,1,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(1014,2973,40722,3058,2,580,'App\\Models\\Receipt',580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',1857.12,NULL,NULL,1,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(1015,2973,40722,3058,2,581,'App\\Models\\Receipt',581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',1103.60,NULL,NULL,1,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(1016,2973,40722,3058,2,582,'App\\Models\\Receipt',582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',4406.10,NULL,NULL,1,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(1017,2973,40722,3058,2,583,'App\\Models\\Receipt',583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',1836.00,NULL,NULL,1,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL);
INSERT INTO `balance_libro` VALUES (1018,2973,40722,3058,2,584,'App\\Models\\Receipt',584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',1104.00,NULL,NULL,1,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(1019,2973,40722,3058,2,585,'App\\Models\\Receipt',585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',4189.00,NULL,NULL,1,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(1020,2973,40722,3058,2,586,'App\\Models\\Receipt',586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',2389.00,NULL,NULL,1,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(1021,2973,40722,3058,2,587,'App\\Models\\Receipt',587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',4572.00,NULL,NULL,1,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(1022,2973,40722,3058,2,588,'App\\Models\\Receipt',588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',2916.00,NULL,NULL,1,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(1023,2973,40722,3058,2,589,'App\\Models\\Receipt',589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',2669.00,NULL,NULL,1,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(1024,2973,40722,3058,2,590,'App\\Models\\Receipt',590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',1263.00,NULL,NULL,1,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(1025,2973,40722,3058,2,591,'App\\Models\\Receipt',591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',4179.00,NULL,NULL,1,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(1026,2973,40722,3058,2,592,'App\\Models\\Receipt',592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',13930.20,NULL,NULL,1,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(1027,2973,40722,3058,2,593,'App\\Models\\Receipt',593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',4815.99,NULL,NULL,1,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(1028,2973,40722,3058,2,594,'App\\Models\\Receipt',594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',3449.92,NULL,NULL,1,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(1029,2973,40722,3058,2,595,'App\\Models\\Receipt',595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',2156.00,NULL,NULL,1,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(1030,2973,40722,3058,2,596,'App\\Models\\Receipt',596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',4181.30,NULL,NULL,1,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(1031,2973,40722,3058,2,597,'App\\Models\\Receipt',597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',7237.00,NULL,NULL,1,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(1032,2973,40722,3058,2,598,'App\\Models\\Receipt',598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',1353.24,NULL,NULL,1,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(1033,2973,40722,3058,2,599,'App\\Models\\Receipt',599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',7910.85,NULL,NULL,1,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(1034,2973,40722,3058,2,600,'App\\Models\\Receipt',600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',1665.60,NULL,NULL,1,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(1035,2973,40722,3058,2,601,'App\\Models\\Receipt',601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',5086.00,NULL,NULL,1,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(1036,2973,40722,3058,2,602,'App\\Models\\Receipt',602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',1650.00,NULL,NULL,1,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(1037,2973,40722,3058,2,603,'App\\Models\\Receipt',603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',1420.00,NULL,NULL,1,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(1038,2973,40722,3058,2,604,'App\\Models\\Receipt',604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',1382.24,NULL,NULL,1,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL);
INSERT INTO `balance_libro` VALUES (1039,2973,40722,3058,2,605,'App\\Models\\Receipt',605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',2184.00,NULL,NULL,1,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(1040,2973,40722,3058,2,606,'App\\Models\\Receipt',606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',13281.00,NULL,NULL,1,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(1041,2973,40722,3058,2,607,'App\\Models\\Receipt',607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',3071.25,NULL,NULL,1,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(1042,2973,40722,3058,2,608,'App\\Models\\Receipt',608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',2582.20,NULL,NULL,1,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(1043,2973,40722,3058,2,609,'App\\Models\\Receipt',609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',4380.48,NULL,NULL,1,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(1044,2973,40722,3058,2,610,'App\\Models\\Receipt',610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',1974.90,NULL,NULL,1,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(1045,2973,40722,3058,2,611,'App\\Models\\Receipt',611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',662.00,NULL,NULL,1,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(1046,2973,40722,3058,2,612,'App\\Models\\Receipt',612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',1762.78,NULL,NULL,1,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(1047,2973,40722,3058,2,613,'App\\Models\\Receipt',613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',1182.00,NULL,NULL,1,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(1048,2973,40722,3058,2,614,'App\\Models\\Receipt',614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',496.80,NULL,NULL,1,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(1049,2973,40722,3058,2,615,'App\\Models\\Receipt',615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',2036.00,NULL,NULL,1,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(1050,2973,40722,3058,2,616,'App\\Models\\Receipt',616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',2170.80,NULL,NULL,1,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(1051,2973,40722,3058,2,617,'App\\Models\\Receipt',617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',1135.84,NULL,NULL,1,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(1052,2973,40722,3058,2,618,'App\\Models\\Receipt',618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',2716.00,NULL,NULL,1,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(1053,2973,40722,3058,2,619,'App\\Models\\Receipt',619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',2915.10,NULL,NULL,1,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(1054,2973,40722,3058,2,620,'App\\Models\\Receipt',620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',4105.00,NULL,NULL,1,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(1055,2973,40722,3058,2,621,'App\\Models\\Receipt',621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',7990.00,NULL,NULL,1,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(1056,2973,40722,3058,2,622,'App\\Models\\Receipt',622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',938.85,NULL,NULL,1,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(1057,2973,40722,3058,2,623,'App\\Models\\Receipt',623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',2169.65,NULL,NULL,1,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(1058,2973,40722,3058,2,624,'App\\Models\\Receipt',624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',3710.00,NULL,NULL,1,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(1059,2973,40722,3058,2,625,'App\\Models\\Receipt',625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',2222.84,NULL,NULL,1,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL);
INSERT INTO `balance_libro` VALUES (1060,2973,40722,3058,2,626,'App\\Models\\Receipt',626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',3807.60,NULL,NULL,1,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(1061,2973,40722,3058,2,627,'App\\Models\\Receipt',627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',6007.60,NULL,NULL,1,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(1062,2973,40722,3058,2,628,'App\\Models\\Receipt',628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',1385.64,NULL,NULL,1,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(1063,2973,40722,3058,2,629,'App\\Models\\Receipt',629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',6926.00,NULL,NULL,1,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(1064,2973,40722,3058,2,630,'App\\Models\\Receipt',630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',1148.04,NULL,NULL,1,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(1065,2973,40722,3058,2,631,'App\\Models\\Receipt',631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',6243.08,NULL,NULL,1,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(1066,2973,40722,3058,2,632,'App\\Models\\Receipt',632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',1761.00,NULL,NULL,1,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(1067,2973,40722,3058,2,633,'App\\Models\\Receipt',633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',3997.00,NULL,NULL,1,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(1068,2973,40722,3058,2,634,'App\\Models\\Receipt',634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',1651.00,NULL,NULL,1,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(1069,2973,40722,3058,2,635,'App\\Models\\Receipt',635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',3313.00,NULL,NULL,1,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(1070,2973,40722,3058,2,636,'App\\Models\\Receipt',636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',1757.00,NULL,NULL,1,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(1071,2973,40722,3058,2,637,'App\\Models\\Receipt',637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',4813.00,NULL,NULL,1,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(1072,2973,40722,3058,2,638,'App\\Models\\Receipt',638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',2182.00,NULL,NULL,1,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(1073,2973,40722,3058,2,639,'App\\Models\\Receipt',639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',1145.00,NULL,NULL,1,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(1074,2973,40722,3058,2,640,'App\\Models\\Receipt',640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',5155.00,NULL,NULL,1,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(1075,2973,40722,3058,2,641,'App\\Models\\Receipt',641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',2546.64,NULL,NULL,1,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(1076,2973,40722,3058,2,642,'App\\Models\\Receipt',642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',340.64,NULL,NULL,1,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(1077,2973,40722,3058,2,643,'App\\Models\\Receipt',643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',4630.00,NULL,NULL,1,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(1078,2973,40722,3058,2,644,'App\\Models\\Receipt',644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',4907.00,NULL,NULL,1,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(1079,2973,40722,3058,2,645,'App\\Models\\Receipt',645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',1441.00,NULL,NULL,1,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(1080,2973,40722,3058,2,646,'App\\Models\\Receipt',646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',513.04,NULL,NULL,1,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL);
INSERT INTO `balance_libro` VALUES (1081,2973,40722,3058,2,647,'App\\Models\\Receipt',647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',4981.00,NULL,NULL,1,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(1082,2973,40722,3058,2,648,'App\\Models\\Receipt',648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',420.08,NULL,NULL,1,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(1083,2973,40722,3058,2,649,'App\\Models\\Receipt',649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',1552.00,NULL,NULL,1,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(1084,2973,40722,3058,2,650,'App\\Models\\Receipt',650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',1877.70,NULL,NULL,1,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(1085,2973,40722,3058,2,651,'App\\Models\\Receipt',651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',420.08,NULL,NULL,1,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(1086,2973,40722,3058,2,652,'App\\Models\\Receipt',652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',1007.00,NULL,NULL,1,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(1087,2973,40722,3058,2,653,'App\\Models\\Receipt',653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',432.48,NULL,NULL,1,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(1088,2973,40722,3058,2,654,'App\\Models\\Receipt',654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',4054.00,NULL,NULL,1,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(1089,2973,40722,3058,2,655,'App\\Models\\Receipt',655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',1072.20,NULL,NULL,1,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(1090,2973,40722,3058,2,656,'App\\Models\\Receipt',656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',1330.56,NULL,NULL,1,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(1091,2973,40722,3058,2,657,'App\\Models\\Receipt',657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',3834.42,NULL,NULL,1,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(1092,2973,40722,3058,2,658,'App\\Models\\Receipt',658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',7682.00,NULL,NULL,1,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(1093,2973,40722,3058,2,659,'App\\Models\\Receipt',659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',2013.00,NULL,NULL,1,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(1094,2973,40722,3058,2,660,'App\\Models\\Receipt',660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',2758.32,NULL,NULL,1,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(1095,2973,40722,3058,2,661,'App\\Models\\Receipt',661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',2514.60,NULL,NULL,1,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(1096,2973,40722,3058,2,662,'App\\Models\\Receipt',662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',4631.55,NULL,NULL,1,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(1097,2973,40722,3058,2,663,'App\\Models\\Receipt',663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',1018.65,NULL,NULL,1,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(1098,2973,40722,3058,2,664,'App\\Models\\Receipt',664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',5501.99,NULL,NULL,1,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(1099,2973,40722,3058,2,665,'App\\Models\\Receipt',665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',4213.99,NULL,NULL,1,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(1100,2973,40722,3058,2,666,'App\\Models\\Receipt',666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',2709.36,NULL,NULL,1,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(1101,2973,40722,3058,2,667,'App\\Models\\Receipt',667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',2407.26,NULL,NULL,1,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL);
INSERT INTO `balance_libro` VALUES (1102,2973,40722,3058,2,668,'App\\Models\\Receipt',668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',2960.00,NULL,NULL,1,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(1103,2973,40722,3058,2,669,'App\\Models\\Receipt',669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',186.99,NULL,NULL,1,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(1104,2973,40722,3058,2,670,'App\\Models\\Receipt',670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',11737.16,NULL,NULL,1,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(1105,2973,40722,3058,2,671,'App\\Models\\Receipt',671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',11737.16,NULL,NULL,1,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(1106,2973,40722,3058,2,672,'App\\Models\\Receipt',672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',162443.00,NULL,NULL,1,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(1107,2973,40722,3058,2,673,'App\\Models\\Receipt',673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',4179.00,NULL,NULL,1,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(1108,2973,40722,3058,2,674,'App\\Models\\Receipt',674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',2211.00,NULL,NULL,1,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(1109,2973,40722,3058,2,675,'App\\Models\\Receipt',675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',9841.99,NULL,NULL,1,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(1110,2973,40722,3058,3,676,'App\\Models\\Receipt',676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',1499.19,NULL,NULL,1,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(1111,2973,40722,3058,3,677,'App\\Models\\Receipt',677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',98.60,NULL,NULL,1,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(1112,2973,40722,3058,3,678,'App\\Models\\Receipt',678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-06','2021-08-06',121000.00,NULL,NULL,1,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(1113,2973,40722,3058,3,679,'App\\Models\\Receipt',679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',7000.00,NULL,NULL,1,'2021-09-09 14:51:59','2021-09-09 14:53:04','2021-09-09 14:53:04'),(1114,2973,40722,3058,3,680,'App\\Models\\Receipt',680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',891.59,NULL,NULL,1,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(1115,2973,40722,3058,3,681,'App\\Models\\Receipt',681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',39999.00,NULL,NULL,1,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(1116,2973,40722,3058,3,682,'App\\Models\\Receipt',682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',275.70,NULL,NULL,1,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(1117,2973,40722,3058,3,683,'App\\Models\\Receipt',683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',104.63,NULL,NULL,1,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(1118,2973,40722,3058,3,684,'App\\Models\\Receipt',684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',275.00,NULL,NULL,1,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(1119,2973,40722,3058,3,685,'App\\Models\\Receipt',685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-24','2021-08-24',70999.00,NULL,NULL,1,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(1120,2973,40722,3058,3,686,'App\\Models\\Receipt',686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',796.77,NULL,NULL,1,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(1121,2973,40722,3058,3,687,'App\\Models\\Receipt',687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',813.42,NULL,NULL,1,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19');
INSERT INTO `balance_libro` VALUES (1122,2973,40722,3058,3,688,'App\\Models\\Receipt',688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-29','2021-08-29',164234.53,NULL,NULL,1,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(1123,2973,40722,3058,3,689,'App\\Models\\Receipt',689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-29','2021-08-29',205593.81,NULL,NULL,1,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(1124,2973,40722,3058,3,690,'App\\Models\\Receipt',690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-29','2021-08-29',90.32,NULL,NULL,1,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(1125,2973,40722,3058,3,691,'App\\Models\\Receipt',691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-29','2021-08-29',329.15,NULL,NULL,1,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(1126,2973,40722,3058,3,692,'App\\Models\\Receipt',692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',3518.15,NULL,NULL,1,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(1127,2973,40722,3058,3,693,'App\\Models\\Receipt',693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',10000.00,NULL,NULL,1,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(1128,2973,40722,3058,3,694,'App\\Models\\Receipt',694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',553547.17,NULL,NULL,1,'2021-09-09 14:51:59','2021-09-09 14:53:44','2021-09-09 14:53:44'),(1129,2973,40722,3058,3,679,'App\\Models\\Receipt',679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',7000.00,NULL,NULL,1,'2021-09-09 14:53:04','2021-09-09 15:34:19','2021-09-09 15:34:19'),(1130,2973,40722,3058,3,694,'App\\Models\\Receipt',694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',553547.17,NULL,NULL,1,'2021-09-09 14:53:44','2021-09-09 15:34:19','2021-09-09 15:34:19'),(1131,2973,40722,3058,3,695,'App\\Models\\Receipt',695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',888.70,NULL,NULL,1,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(1132,2973,40722,3058,3,696,'App\\Models\\Receipt',696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',1499.19,NULL,NULL,1,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(1133,2973,40722,3058,3,697,'App\\Models\\Receipt',697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',98.60,NULL,NULL,1,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(1134,2973,40722,3058,3,698,'App\\Models\\Receipt',698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-06','2021-08-06',121000.00,NULL,NULL,1,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(1135,2973,40722,3058,3,699,'App\\Models\\Receipt',699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',7000.00,NULL,NULL,1,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(1136,2973,40722,3058,3,700,'App\\Models\\Receipt',700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-08','2021-08-08',3360.30,NULL,NULL,1,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(1137,2973,40722,3058,3,701,'App\\Models\\Receipt',701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',891.59,NULL,NULL,1,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(1138,2973,40722,3058,3,702,'App\\Models\\Receipt',702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',39999.00,NULL,NULL,1,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(1139,2973,40722,3058,3,703,'App\\Models\\Receipt',703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',740.10,NULL,NULL,1,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(1140,2973,40722,3058,3,704,'App\\Models\\Receipt',704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',275.70,NULL,NULL,1,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(1141,2973,40722,3058,3,705,'App\\Models\\Receipt',705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',104.63,NULL,NULL,1,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL);
INSERT INTO `balance_libro` VALUES (1142,2973,40722,3058,3,706,'App\\Models\\Receipt',706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',275.00,NULL,NULL,1,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(1143,2973,40722,3058,3,707,'App\\Models\\Receipt',707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',830.30,NULL,NULL,1,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(1144,2973,40722,3058,3,708,'App\\Models\\Receipt',708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',3960.30,NULL,NULL,1,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(1145,2973,40722,3058,3,709,'App\\Models\\Receipt',709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-24','2021-08-24',70999.00,NULL,NULL,1,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(1146,2973,40722,3058,3,710,'App\\Models\\Receipt',710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',796.77,NULL,NULL,1,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(1147,2973,40722,3058,3,711,'App\\Models\\Receipt',711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',1500.23,NULL,NULL,1,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(1148,2973,40722,3058,3,712,'App\\Models\\Receipt',712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',813.42,NULL,NULL,1,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(1149,2973,40722,3058,3,713,'App\\Models\\Receipt',713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-29','2021-08-29',164234.53,NULL,NULL,1,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(1150,2973,40722,3058,3,714,'App\\Models\\Receipt',714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-29','2021-08-29',205593.81,NULL,NULL,1,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(1151,2973,40722,3058,3,715,'App\\Models\\Receipt',715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-29','2021-08-29',90.32,NULL,NULL,1,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(1152,2973,40722,3058,3,716,'App\\Models\\Receipt',716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-29','2021-08-29',329.15,NULL,NULL,1,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(1153,2973,40722,3058,3,717,'App\\Models\\Receipt',717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',3518.15,NULL,NULL,1,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(1154,2973,40722,3058,3,718,'App\\Models\\Receipt',718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',10000.00,NULL,NULL,1,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(1155,2973,40722,3058,3,719,'App\\Models\\Receipt',719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',553547.17,NULL,NULL,1,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(1156,2973,40926,3765,2,720,'App\\Models\\Receipt',720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',7584.03,NULL,NULL,1,'2021-10-12 15:29:22','2021-10-12 15:29:22',NULL),(1157,2973,40926,3765,2,721,'App\\Models\\Receipt',721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',10519.66,NULL,NULL,1,'2021-10-12 15:29:22','2021-10-12 15:29:22',NULL),(1158,2973,40926,3765,2,722,'App\\Models\\Receipt',722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',35231.52,NULL,NULL,1,'2021-10-12 15:29:22','2021-10-12 15:29:22',NULL),(1159,2973,40926,3765,2,723,'App\\Models\\Receipt',723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-24','2021-09-24',11273.91,NULL,NULL,1,'2021-10-12 15:29:22','2021-10-12 15:29:22',NULL),(1160,2973,40926,3765,2,724,'App\\Models\\Receipt',724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-24','2021-09-24',9833.56,NULL,NULL,1,'2021-10-12 15:29:22','2021-10-12 15:29:22',NULL),(1161,2973,40926,3765,2,725,'App\\Models\\Receipt',725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',27839.16,NULL,NULL,1,'2021-10-12 15:29:22','2021-10-12 15:29:22',NULL),(1162,2973,40926,3765,2,726,'App\\Models\\Receipt',726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',26340.21,NULL,NULL,1,'2021-10-12 15:29:22','2021-10-12 15:29:22',NULL);
INSERT INTO `balance_libro` VALUES (1163,2973,40926,3765,2,727,'App\\Models\\Receipt',727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',707608.00,NULL,NULL,1,'2021-10-12 15:29:22','2021-10-12 15:29:22',NULL),(1164,2973,40926,3765,3,728,'App\\Models\\Receipt',728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',1800.00,NULL,NULL,1,'2021-10-12 16:30:55','2021-10-12 16:30:55',NULL),(1165,2973,40926,3765,3,729,'App\\Models\\Receipt',729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',54999.46,NULL,NULL,1,'2021-10-12 16:30:55','2021-10-12 16:30:55',NULL),(1166,2973,40926,3765,3,730,'App\\Models\\Receipt',730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',7000.00,NULL,NULL,1,'2021-10-12 16:30:55','2021-10-12 16:30:55',NULL),(1167,2973,40926,3765,3,731,'App\\Models\\Receipt',731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',10230.17,NULL,NULL,1,'2021-10-12 16:30:55','2021-10-12 16:30:55',NULL),(1168,2973,40926,3765,3,732,'App\\Models\\Receipt',732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',17070.86,NULL,NULL,1,'2021-10-12 16:30:55','2021-10-12 16:30:55',NULL),(1169,2973,40926,3765,3,733,'App\\Models\\Receipt',733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-24','2021-09-24',10318.89,NULL,NULL,1,'2021-10-12 16:30:55','2021-10-12 16:30:55',NULL),(1170,2973,40926,3765,3,734,'App\\Models\\Receipt',734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',142176.88,NULL,NULL,1,'2021-10-12 16:30:55','2021-10-12 16:30:55',NULL),(1171,2973,40926,3765,3,735,'App\\Models\\Receipt',735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',133968.63,NULL,NULL,1,'2021-10-12 16:30:55','2021-10-12 16:30:55',NULL),(1172,2973,40926,3765,3,736,'App\\Models\\Receipt',736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',22303.75,NULL,NULL,1,'2021-10-12 16:30:55','2021-10-12 16:30:55',NULL),(1173,2973,40720,1541,17,1173,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',7483823.46,'REFUNDICION DE CUENTAS',NULL,1,'2021-10-23 10:38:27','2021-10-23 10:38:27',NULL),(1174,2973,40720,1541,17,1174,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',5516625.09,'CIERRE CUENTAS PATRIMONIALES',NULL,1,'2021-10-23 10:55:09','2021-10-23 10:55:09',NULL),(1175,2973,40926,3772,2,737,'App\\Models\\Receipt',737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',10072.17,NULL,NULL,1,'2022-03-15 10:49:21','2022-03-15 10:49:21',NULL),(1176,2973,40926,3772,2,738,'App\\Models\\Receipt',738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',11441.60,NULL,NULL,1,'2022-03-15 10:49:21','2022-03-15 10:49:21',NULL),(1177,2973,40926,3772,2,739,'App\\Models\\Receipt',739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',327896.69,NULL,NULL,1,'2022-03-15 10:49:21','2022-03-15 10:49:21',NULL),(1178,2973,40926,3772,2,740,'App\\Models\\Receipt',740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',36300.00,NULL,NULL,1,'2022-03-15 10:49:21','2022-03-15 10:49:21',NULL),(1182,2973,40719,3,19,1182,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-01','2021-01-01',2749.36,NULL,NULL,1,'2022-06-20 12:50:41','2022-06-20 12:52:37','2022-06-20 12:52:37'),(1183,2973,40719,3,19,1183,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-01','2021-01-01',2749.36,NULL,NULL,1,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(1184,2973,40719,3,19,1184,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-01','2021-01-01',2424000.29,NULL,NULL,1,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(1185,2973,40719,3,19,1185,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-01','2021-01-01',5516625.09,NULL,NULL,1,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL);
INSERT INTO `balance_libro` VALUES (1186,2973,40719,3,19,1186,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-02','2021-01-02',6557.72,NULL,NULL,1,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(1187,2973,40719,3,19,1187,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-02','2021-01-02',800000.00,NULL,NULL,1,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(1188,2973,40719,3,19,1188,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',35204.95,NULL,NULL,1,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(1189,2973,40719,3,19,1189,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',45.05,NULL,NULL,1,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(1190,2973,40719,3,19,1190,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',987.17,NULL,NULL,1,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(1191,2973,40719,3,19,1191,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',179267.55,NULL,NULL,1,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(1192,2973,40719,3,19,1192,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',3929.58,NULL,NULL,1,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(1193,2973,40719,3,19,1193,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',51591.18,NULL,NULL,1,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(1194,2973,40719,3,19,1194,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',15000.00,NULL,NULL,1,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(1195,2973,40719,3,19,1195,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',350.42,NULL,NULL,1,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(1196,2973,40719,3,19,1196,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',86481.12,NULL,NULL,1,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(1197,2973,40719,3,19,1197,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',5445.00,NULL,NULL,1,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(1198,2973,40719,3,19,1198,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',793911.25,NULL,NULL,1,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(1199,2973,40719,3,19,1199,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',116100.00,NULL,NULL,1,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(1200,2973,40719,3,19,1200,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',3900.16,NULL,NULL,1,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(1201,2973,40719,3,19,1201,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-16','2021-01-16',4357.90,NULL,NULL,1,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(1202,2973,40719,3,19,1202,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-16','2021-01-16',4696.48,NULL,NULL,1,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(1203,2973,40719,3,19,1203,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',207.10,NULL,NULL,1,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(1204,2973,40719,3,19,1204,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',861.59,NULL,NULL,1,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(1205,2973,40719,3,19,1205,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',514.46,NULL,NULL,1,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL);
INSERT INTO `balance_libro` VALUES (1206,2973,40719,3,19,1206,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',12590.06,NULL,NULL,1,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(1207,2973,40719,3,19,1207,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',4069.69,NULL,NULL,1,'2022-06-20 12:52:46','2022-06-20 12:52:47',NULL),(1208,2973,40719,3,19,1208,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',3600.02,NULL,NULL,1,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(1209,2973,40719,3,19,1209,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',414600.00,NULL,NULL,1,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(1210,2973,40719,3,19,1210,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',12801.80,NULL,NULL,1,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(1211,2973,40719,3,19,1211,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',38.00,NULL,NULL,1,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(1212,2973,40719,3,19,1212,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',6150.43,NULL,NULL,1,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(1213,2973,40719,3,19,1213,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',69870.07,NULL,NULL,1,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(1214,2973,40719,3,19,1214,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',10632.42,NULL,NULL,1,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(1215,2973,40719,3,19,1215,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',307243.20,NULL,NULL,1,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(1216,2973,40719,3,19,1216,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',4112.36,NULL,NULL,1,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(1217,2973,40719,3,19,1217,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',311696.00,NULL,NULL,1,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(1218,2973,40719,3,19,1218,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',311696.00,NULL,NULL,1,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(1219,2973,40719,3,19,1219,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',307243.20,NULL,NULL,1,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(1220,2973,40719,3,19,1220,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',47091.92,NULL,NULL,1,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(1221,2973,40719,3,19,1221,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',23947.14,NULL,NULL,1,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(1222,2973,40719,3,19,1222,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',5152.00,NULL,NULL,1,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(1223,2973,40719,3,19,1223,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',316044.81,NULL,NULL,1,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(1224,2973,40719,3,19,1224,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',83697.58,NULL,NULL,1,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(1225,2973,40719,3,19,1225,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',47091.92,NULL,NULL,1,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL);
INSERT INTO `balance_libro` VALUES (1226,2973,40719,3,19,1226,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',2325858.11,NULL,NULL,1,'2022-06-20 12:52:47','2022-06-20 18:03:28','2022-06-20 18:03:28'),(1227,2973,40719,4,19,1227,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',280.88,NULL,NULL,1,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(1228,2973,40719,4,19,1228,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',35204.95,NULL,NULL,1,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(1229,2973,40719,4,19,1229,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',772282.50,NULL,NULL,1,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(1230,2973,40719,4,19,1230,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',1180.94,NULL,NULL,1,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(1231,2973,40719,4,19,1231,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',3513.51,NULL,NULL,1,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(1232,2973,40719,4,19,1232,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',93775.00,NULL,NULL,1,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(1233,2973,40719,4,19,1233,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',27000.00,NULL,NULL,1,'2022-06-20 12:52:47','2022-06-20 12:52:48',NULL),(1234,2973,40719,4,19,1234,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',15000.00,NULL,NULL,1,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(1235,2973,40719,4,19,1235,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',108802.10,NULL,NULL,1,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(1236,2973,40719,4,19,1236,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',388500.00,NULL,NULL,1,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(1237,2973,40719,4,19,1237,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',388500.00,NULL,NULL,1,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(1238,2973,40719,4,19,1238,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',788390.00,NULL,NULL,1,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(1239,2973,40719,4,19,1239,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',3961.77,NULL,NULL,1,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(1240,2973,40719,4,19,1240,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',1450.70,NULL,NULL,1,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(1241,2973,40719,4,19,1241,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',73931.00,NULL,NULL,1,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(1242,2973,40719,4,19,1242,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',1137.12,NULL,NULL,1,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(1243,2973,40719,4,19,1243,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',2789.99,NULL,NULL,1,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(1244,2973,40719,4,19,1244,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',484.21,NULL,NULL,1,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(1245,2973,40719,4,19,1245,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',15612.63,NULL,NULL,1,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL);
INSERT INTO `balance_libro` VALUES (1246,2973,40719,4,19,1246,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',510005.86,NULL,NULL,1,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(1247,2973,40719,4,19,1247,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',65176.65,NULL,NULL,1,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(1248,2973,40719,4,19,1248,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',22308.10,NULL,NULL,1,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(1249,2973,40719,4,19,1249,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',4518.11,NULL,NULL,1,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(1250,2973,40719,4,19,1250,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',84.87,NULL,NULL,1,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(1251,2973,40719,4,19,1251,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',72.80,NULL,NULL,1,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(1252,2973,40719,4,19,1252,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',298447.17,NULL,NULL,1,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(1253,2973,40719,4,19,1253,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',113085.41,NULL,NULL,1,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(1254,2973,40719,4,19,1254,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',80889.01,NULL,NULL,1,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(1255,2973,40719,4,19,1255,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',80889.01,NULL,NULL,1,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(1256,2973,40719,4,19,1256,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',4032561.86,NULL,NULL,1,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(1257,2973,40719,5,19,1257,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',60000.00,NULL,NULL,1,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(1258,2973,40719,5,19,1258,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',5200.00,NULL,NULL,1,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(1259,2973,40719,5,19,1259,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',289700.00,NULL,NULL,1,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(1260,2973,40719,5,19,1260,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',26526.81,NULL,NULL,1,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(1261,2973,40719,5,19,1261,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',620.20,NULL,NULL,1,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(1262,2973,40719,5,19,1262,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',419.99,NULL,NULL,1,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(1263,2973,40719,5,19,1263,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',35204.95,NULL,NULL,1,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(1264,2973,40719,5,19,1264,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',88330.00,NULL,NULL,1,'2022-06-20 12:52:48','2022-06-20 12:52:49',NULL),(1265,2973,40719,5,19,1265,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',2607.77,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL);
INSERT INTO `balance_libro` VALUES (1266,2973,40719,5,19,1266,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',12000.00,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(1267,2973,40719,5,19,1267,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',1048.52,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(1268,2973,40719,5,19,1268,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',54450.00,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(1269,2973,40719,5,19,1269,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',4350.41,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(1270,2973,40719,5,19,1270,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',106480.00,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(1271,2973,40719,5,19,1271,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',206.00,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(1272,2973,40719,5,19,1272,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',170.48,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(1273,2973,40719,5,19,1273,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',7200.00,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(1274,2973,40719,5,19,1274,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1500.00,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(1275,2973,40719,5,19,1275,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',3471.00,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(1276,2973,40719,5,19,1276,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',414750.01,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(1277,2973,40719,5,19,1277,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',231110.00,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(1278,2973,40719,5,19,1278,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',1040.00,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(1279,2973,40719,5,19,1279,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',15000.00,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(1280,2973,40719,5,19,1280,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',1820.00,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(1281,2973,40719,5,19,1281,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',315.87,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(1282,2973,40719,5,19,1282,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',5087.29,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(1283,2973,40719,5,19,1283,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',164540.00,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(1284,2973,40719,5,19,1284,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',3378.24,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(1285,2973,40719,5,19,1285,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',119420.43,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL);
INSERT INTO `balance_libro` VALUES (1286,2973,40719,5,19,1286,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',499.83,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(1287,2973,40719,5,19,1287,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',87800.00,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(1288,2973,40719,5,19,1288,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',86.75,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(1289,2973,40719,5,19,1289,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',32524.80,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(1290,2973,40719,5,19,1290,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',806.40,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(1291,2973,40719,5,19,1291,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',818.20,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(1292,2973,40719,5,19,1292,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',4600.70,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(1293,2973,40719,5,19,1293,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',1928.25,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(1294,2973,40719,5,19,1294,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',1024.66,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(1295,2973,40719,5,19,1295,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',36300.00,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(1296,2973,40719,5,19,1296,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',600.00,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(1297,2973,40719,5,19,1297,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',7746.42,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(1298,2973,40719,5,19,1298,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',260.00,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(1299,2973,40719,5,19,1299,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',21521.65,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(1300,2973,40719,5,19,1300,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',67397.00,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(1301,2973,40719,5,19,1301,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',416000.00,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(1302,2973,40719,5,19,1302,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',6083.88,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(1303,2973,40719,5,19,1303,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',65582.00,NULL,NULL,1,'2022-06-20 12:52:49','2022-06-20 12:52:50',NULL),(1304,2973,40719,5,19,1304,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',95590.00,NULL,NULL,1,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(1305,2973,40719,5,19,1305,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',302218.09,NULL,NULL,1,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL);
INSERT INTO `balance_libro` VALUES (1306,2973,40719,5,19,1306,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',99081.64,NULL,NULL,1,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(1307,2973,40719,5,19,1307,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',38279.95,NULL,NULL,1,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(1308,2973,40719,5,19,1308,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',38279.95,NULL,NULL,1,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(1309,2973,40719,5,19,1309,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',200622.33,NULL,NULL,1,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(1310,2973,40719,5,19,1310,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',3872391.52,NULL,NULL,1,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(1311,2973,40719,6,19,1311,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',4670.30,NULL,NULL,1,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(1312,2973,40719,6,19,1312,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',1583.05,NULL,NULL,1,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(1313,2973,40719,6,19,1313,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',2072.13,NULL,NULL,1,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(1314,2973,40719,6,19,1314,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',3243.25,NULL,NULL,1,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(1315,2973,40719,6,19,1315,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',35510.45,NULL,NULL,1,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(1316,2973,40719,6,19,1316,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',15000.00,NULL,NULL,1,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(1317,2973,40719,6,19,1317,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',69962.20,NULL,NULL,1,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(1318,2973,40719,6,19,1318,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',26620.00,NULL,NULL,1,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(1319,2973,40719,6,19,1319,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',35204.95,NULL,NULL,1,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(1320,2973,40719,6,19,1320,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',1522763.40,NULL,NULL,1,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(1321,2973,40719,6,19,1321,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',965888.01,NULL,NULL,1,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(1322,2973,40719,6,19,1322,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',2647.60,NULL,NULL,1,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(1323,2973,40719,6,19,1323,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',5256.19,NULL,NULL,1,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(1324,2973,40719,6,19,1324,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',6000.00,NULL,NULL,1,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(1325,2973,40719,6,19,1325,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',799.74,NULL,NULL,1,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL);
INSERT INTO `balance_libro` VALUES (1326,2973,40719,6,19,1326,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',1704.02,NULL,NULL,1,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(1327,2973,40719,6,19,1327,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',618189.00,NULL,NULL,1,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(1328,2973,40719,6,19,1328,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',39325.00,NULL,NULL,1,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(1329,2973,40719,6,19,1329,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',1625.00,NULL,NULL,1,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(1330,2973,40719,6,19,1330,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',77273.63,NULL,NULL,1,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(1331,2973,40719,6,19,1331,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',8349.00,NULL,NULL,1,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(1332,2973,40719,6,19,1332,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',470.00,NULL,NULL,1,'2022-06-20 12:52:50','2022-06-20 12:52:51',NULL),(1333,2973,40719,6,19,1333,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',531159.15,NULL,NULL,1,'2022-06-20 12:52:51','2022-06-20 12:52:51',NULL),(1334,2973,40719,6,19,1334,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',4899.86,NULL,NULL,1,'2022-06-20 12:52:51','2022-06-20 12:52:51',NULL),(1335,2973,40719,6,19,1335,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',41745.00,NULL,NULL,1,'2022-06-20 12:52:51','2022-06-20 12:52:51',NULL),(1336,2973,40719,6,19,1336,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',570035.91,NULL,NULL,1,'2022-06-20 12:52:51','2022-06-20 12:52:51',NULL),(1337,2973,40719,6,19,1337,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',204875.49,NULL,NULL,1,'2022-06-20 12:52:51','2022-06-20 12:52:51',NULL),(1338,2973,40719,6,19,1338,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',133788.11,NULL,NULL,1,'2022-06-20 12:52:51','2022-06-20 12:52:51',NULL),(1339,2973,40719,6,19,1339,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',133788.11,NULL,NULL,1,'2022-06-20 12:52:51','2022-06-20 12:52:51',NULL),(1340,2973,40719,6,19,1340,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',15000.00,NULL,NULL,1,'2022-06-20 12:52:51','2022-06-20 12:52:51',NULL),(1341,2973,40719,6,19,1341,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',6050237.71,NULL,NULL,1,'2022-06-20 12:52:51','2022-06-20 12:52:51',NULL),(1342,2973,40719,7,19,1342,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',3500.00,NULL,NULL,1,'2022-06-20 12:52:51','2022-06-20 12:52:51',NULL),(1343,2973,40719,7,19,1343,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',8938.88,NULL,NULL,1,'2022-06-20 12:52:51','2022-06-20 12:52:51',NULL),(1344,2973,40719,7,19,1344,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',65551.75,NULL,NULL,1,'2022-06-20 12:52:51','2022-06-20 12:52:51',NULL),(1345,2973,40719,7,19,1345,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',422700.00,NULL,NULL,1,'2022-06-20 12:52:51','2022-06-20 12:52:51',NULL);
INSERT INTO `balance_libro` VALUES (1346,2973,40719,7,19,1346,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',35204.95,NULL,NULL,1,'2022-06-20 12:52:51','2022-06-20 12:52:51',NULL),(1347,2973,40719,7,19,1347,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',8200.00,NULL,NULL,1,'2022-06-20 12:52:51','2022-06-20 12:52:51',NULL),(1348,2973,40719,7,19,1348,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',1524.49,NULL,NULL,1,'2022-06-20 12:52:51','2022-06-20 12:52:51',NULL),(1349,2973,40719,7,19,1349,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',7561.07,NULL,NULL,1,'2022-06-20 12:52:51','2022-06-20 12:52:51',NULL),(1350,2973,40719,7,19,1350,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',1260.00,NULL,NULL,1,'2022-06-20 12:52:51','2022-06-20 12:52:51',NULL),(1351,2973,40719,7,19,1351,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',25000.00,NULL,NULL,1,'2022-06-20 12:52:51','2022-06-20 12:52:51',NULL),(1352,2973,40719,7,19,1352,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',831.47,NULL,NULL,1,'2022-06-20 12:52:51','2022-06-20 12:52:51',NULL),(1353,2973,40719,7,19,1353,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',58200.00,NULL,NULL,1,'2022-06-20 12:52:51','2022-06-20 12:52:51',NULL),(1354,2973,40719,7,19,1354,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',462.35,NULL,NULL,1,'2022-06-20 12:52:51','2022-06-20 12:52:51',NULL),(1355,2973,40719,7,19,1355,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',253.12,NULL,NULL,1,'2022-06-20 12:52:51','2022-06-20 12:52:51',NULL),(1356,2973,40719,7,19,1356,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',14000.00,NULL,NULL,1,'2022-06-20 12:52:51','2022-06-20 12:52:51',NULL),(1357,2973,40719,7,19,1357,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',5733.81,NULL,NULL,1,'2022-06-20 12:52:51','2022-06-20 12:52:51',NULL),(1358,2973,40719,7,19,1358,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',16.96,NULL,NULL,1,'2022-06-20 12:52:51','2022-06-20 12:52:51',NULL),(1359,2973,40719,7,19,1359,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',409.70,NULL,NULL,1,'2022-06-20 12:52:51','2022-06-20 12:52:51',NULL),(1360,2973,40719,7,19,1360,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',107197.76,NULL,NULL,1,'2022-06-20 12:52:51','2022-06-20 12:52:51',NULL),(1361,2973,40719,7,19,1361,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',122395.13,NULL,NULL,1,'2022-06-20 12:52:51','2022-06-20 12:52:51',NULL),(1362,2973,40719,7,19,1362,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',2231200.01,NULL,NULL,1,'2022-06-20 12:52:51','2022-06-20 12:52:51',NULL),(1363,2973,40719,7,19,1363,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',159531.53,NULL,NULL,1,'2022-06-20 12:52:51','2022-06-20 12:52:51',NULL),(1364,2973,40719,7,19,1364,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',21701.81,NULL,NULL,1,'2022-06-20 12:52:51','2022-06-20 12:52:51',NULL),(1365,2973,40719,7,19,1365,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',71211.52,NULL,NULL,1,'2022-06-20 12:52:51','2022-06-20 12:52:51',NULL);
INSERT INTO `balance_libro` VALUES (1366,2973,40719,7,19,1366,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',8650.70,NULL,NULL,1,'2022-06-20 12:52:51','2022-06-20 12:52:52',NULL),(1367,2973,40719,7,19,1367,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',8650.70,NULL,NULL,1,'2022-06-20 12:52:52','2022-06-20 12:52:52',NULL),(1368,2973,40719,7,19,1368,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',29760.00,NULL,NULL,1,'2022-06-20 12:52:52','2022-06-20 12:52:52',NULL),(1369,2973,40719,7,19,1369,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',304.50,NULL,NULL,1,'2022-06-20 12:52:52','2022-06-20 12:52:52',NULL),(1370,2973,40719,7,19,1370,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',1785818.95,NULL,NULL,1,'2022-06-20 12:52:52','2022-06-20 12:52:52',NULL),(1371,2973,40719,8,19,1371,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',35204.95,NULL,NULL,1,'2022-06-20 12:52:52','2022-06-20 12:52:52',NULL),(1372,2973,40719,8,19,1372,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',132767.25,NULL,NULL,1,'2022-06-20 12:52:52','2022-06-20 12:52:52',NULL),(1373,2973,40719,8,19,1373,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',327.57,NULL,NULL,1,'2022-06-20 12:52:52','2022-06-20 12:52:52',NULL),(1374,2973,40719,8,19,1374,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',922.47,NULL,NULL,1,'2022-06-20 12:52:52','2022-06-20 12:52:52',NULL),(1375,2973,40719,8,19,1375,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',200000.00,NULL,NULL,1,'2022-06-20 12:52:52','2022-06-20 12:52:52',NULL),(1376,2973,40719,8,19,1376,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',790.00,NULL,NULL,1,'2022-06-20 12:52:52','2022-06-20 12:52:52',NULL),(1377,2973,40719,8,19,1377,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',200000.00,NULL,NULL,1,'2022-06-20 12:52:52','2022-06-20 12:52:52',NULL),(1378,2973,40719,8,19,1378,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',5636.14,NULL,NULL,1,'2022-06-20 12:52:52','2022-06-20 12:52:52',NULL),(1379,2973,40719,8,19,1379,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',69575.00,NULL,NULL,1,'2022-06-20 12:52:52','2022-06-20 12:52:52',NULL),(1380,2973,40719,8,19,1380,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',20000.00,NULL,NULL,1,'2022-06-20 12:52:52','2022-06-20 12:52:52',NULL),(1381,2973,40719,8,19,1381,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',1742.53,NULL,NULL,1,'2022-06-20 12:52:52','2022-06-20 12:52:52',NULL),(1382,2973,40719,8,19,1382,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-20','2021-06-20',687.27,NULL,NULL,1,'2022-06-20 12:52:52','2022-06-20 12:52:52',NULL),(1383,2973,40719,8,19,1383,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',81190.03,NULL,NULL,1,'2022-06-20 12:52:52','2022-06-20 12:52:52',NULL),(1384,2973,40719,8,19,1384,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',50820.00,NULL,NULL,1,'2022-06-20 12:52:52','2022-06-20 12:52:52',NULL),(1385,2973,40719,8,19,1385,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',5405.98,NULL,NULL,1,'2022-06-20 12:52:52','2022-06-20 12:52:52',NULL);
INSERT INTO `balance_libro` VALUES (1386,2973,40719,8,19,1386,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',358282.45,NULL,NULL,1,'2022-06-20 12:52:52','2022-06-20 12:52:52',NULL),(1387,2973,40719,8,19,1387,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',594650.00,NULL,NULL,1,'2022-06-20 12:52:52','2022-06-20 12:52:52',NULL),(1388,2973,40719,8,19,1388,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',69575.00,NULL,NULL,1,'2022-06-20 12:52:52','2022-06-20 12:52:52',NULL),(1389,2973,40719,8,19,1389,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',1690.00,NULL,NULL,1,'2022-06-20 12:52:52','2022-06-20 12:52:52',NULL),(1390,2973,40719,8,19,1390,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',17167.54,NULL,NULL,1,'2022-06-20 12:52:52','2022-06-20 12:52:52',NULL),(1391,2973,40719,8,19,1391,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',138320.97,NULL,NULL,1,'2022-06-20 12:52:52','2022-06-20 12:52:52',NULL),(1392,2973,40719,8,19,1392,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',139744.93,NULL,NULL,1,'2022-06-20 12:52:52','2022-06-20 12:52:52',NULL),(1393,2973,40719,8,19,1393,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',3010.00,NULL,NULL,1,'2022-06-20 12:52:52','2022-06-20 12:52:52',NULL),(1394,2973,40719,8,19,1394,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',31775.89,NULL,NULL,1,'2022-06-20 12:52:52','2022-06-20 12:52:53',NULL),(1395,2973,40719,8,19,1395,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',2110000.00,NULL,NULL,1,'2022-06-20 12:52:53','2022-06-20 12:52:53',NULL),(1396,2973,40719,8,19,1396,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',31775.89,NULL,NULL,1,'2022-06-20 12:52:53','2022-06-20 12:52:53',NULL),(1397,2973,40719,8,19,1397,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',28063.52,NULL,NULL,1,'2022-06-20 12:52:53','2022-06-20 12:52:53',NULL),(1398,2973,40719,8,19,1398,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',1814934.13,NULL,NULL,1,'2022-06-20 12:52:53','2022-06-20 12:52:53',NULL),(1399,2973,40719,9,19,1399,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',64610.97,NULL,NULL,1,'2022-06-20 12:52:53','2022-06-20 12:52:53',NULL),(1400,2973,40719,9,19,1400,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',1299.00,NULL,NULL,1,'2022-06-20 12:52:53','2022-06-20 12:52:53',NULL),(1401,2973,40719,9,19,1401,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',30689.98,NULL,NULL,1,'2022-06-20 12:52:53','2022-06-20 12:52:53',NULL),(1402,2973,40719,9,19,1402,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',40486.60,NULL,NULL,1,'2022-06-20 12:52:53','2022-06-20 12:52:53',NULL),(1403,2973,40719,9,19,1403,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',5317.11,NULL,NULL,1,'2022-06-20 12:52:53','2022-06-20 12:52:53',NULL),(1404,2973,40719,9,19,1404,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',2141.28,NULL,NULL,1,'2022-06-20 12:52:53','2022-06-20 12:52:53',NULL),(1405,2973,40719,9,19,1405,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1078.45,NULL,NULL,1,'2022-06-20 12:52:53','2022-06-20 12:52:53',NULL);
INSERT INTO `balance_libro` VALUES (1406,2973,40719,9,19,1406,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',20000.00,NULL,NULL,1,'2022-06-20 12:52:53','2022-06-20 12:52:53',NULL),(1407,2973,40719,9,19,1407,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',570817.50,NULL,NULL,1,'2022-06-20 12:52:53','2022-06-20 12:52:53',NULL),(1408,2973,40719,9,19,1408,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',658.45,NULL,NULL,1,'2022-06-20 12:52:53','2022-06-20 12:52:53',NULL),(1409,2973,40719,9,19,1409,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',269.86,NULL,NULL,1,'2022-06-20 12:52:53','2022-06-20 12:52:53',NULL),(1410,2973,40719,9,19,1410,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',1968.41,NULL,NULL,1,'2022-06-20 12:52:53','2022-06-20 12:52:53',NULL),(1411,2973,40719,9,19,1411,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',81030.31,NULL,NULL,1,'2022-06-20 12:52:53','2022-06-20 12:52:53',NULL),(1412,2973,40719,9,19,1412,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',721.64,NULL,NULL,1,'2022-06-20 12:52:53','2022-06-20 12:52:53',NULL),(1413,2973,40719,9,19,1413,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',239489.25,NULL,NULL,1,'2022-06-20 12:52:53','2022-06-20 12:52:53',NULL),(1414,2973,40719,9,19,1414,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',8552.85,NULL,NULL,1,'2022-06-20 12:52:53','2022-06-20 12:52:53',NULL),(1415,2973,40719,9,19,1415,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',1950.01,NULL,NULL,1,'2022-06-20 12:52:53','2022-06-20 12:52:53',NULL),(1416,2973,40719,9,19,1416,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',5629.27,NULL,NULL,1,'2022-06-20 12:52:53','2022-06-20 12:52:53',NULL),(1417,2973,40719,9,19,1417,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',20214.74,NULL,NULL,1,'2022-06-20 12:52:53','2022-06-20 12:52:53',NULL),(1418,2973,40719,9,19,1418,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',424400.00,NULL,NULL,1,'2022-06-20 12:52:53','2022-06-20 12:52:53',NULL),(1419,2973,40719,9,19,1419,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',424400.00,NULL,NULL,1,'2022-06-20 12:52:53','2022-06-20 12:52:53',NULL),(1420,2973,40719,9,19,1420,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',4235.00,NULL,NULL,1,'2022-06-20 12:52:53','2022-06-20 12:52:54',NULL),(1421,2973,40719,9,19,1421,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',888215.62,NULL,NULL,1,'2022-06-20 12:52:54','2022-06-20 12:52:54',NULL),(1422,2973,40719,9,19,1422,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',4010.18,NULL,NULL,1,'2022-06-20 12:52:54','2022-06-20 12:52:54',NULL),(1423,2973,40719,9,19,1423,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',86394.00,NULL,NULL,1,'2022-06-20 12:52:54','2022-06-20 12:52:54',NULL),(1424,2973,40719,9,19,1424,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',3570.00,NULL,NULL,1,'2022-06-20 12:52:54','2022-06-20 12:52:54',NULL),(1425,2973,40719,9,19,1425,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',320992.34,NULL,NULL,1,'2022-06-20 12:52:54','2022-06-20 12:52:54',NULL);
INSERT INTO `balance_libro` VALUES (1426,2973,40719,9,19,1426,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',266872.33,NULL,NULL,1,'2022-06-20 12:52:54','2022-06-20 12:52:54',NULL),(1427,2973,40719,9,19,1427,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',243.08,NULL,NULL,1,'2022-06-20 12:52:54','2022-06-20 12:52:54',NULL),(1428,2973,40719,9,19,1428,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',115741.85,NULL,NULL,1,'2022-06-20 12:52:54','2022-06-20 12:52:54',NULL),(1429,2973,40719,9,19,1429,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',115741.85,NULL,NULL,1,'2022-06-20 12:52:54','2022-06-20 12:52:54',NULL),(1430,2973,40719,9,19,1430,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',27484.01,NULL,NULL,1,'2022-06-20 12:52:54','2022-06-20 12:52:54',NULL),(1431,2973,40719,9,19,1431,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',426.30,NULL,NULL,1,'2022-06-20 12:52:54','2022-06-20 12:52:54',NULL),(1432,2973,40719,9,19,1432,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',3263231.81,NULL,NULL,1,'2022-06-20 12:52:54','2022-06-20 12:52:54',NULL),(1433,2973,40719,10,19,1433,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',4920.00,NULL,NULL,1,'2022-06-20 12:52:54','2022-06-20 12:52:54',NULL),(1434,2973,40719,10,19,1434,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',48599.35,NULL,NULL,1,'2022-06-20 12:52:54','2022-06-20 12:52:54',NULL),(1435,2973,40719,10,19,1435,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',1255.57,NULL,NULL,1,'2022-06-20 12:52:54','2022-06-20 12:52:54',NULL),(1436,2973,40719,10,19,1436,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',400.36,NULL,NULL,1,'2022-06-20 12:52:54','2022-06-20 12:52:54',NULL),(1437,2973,40719,10,19,1437,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',2042.81,NULL,NULL,1,'2022-06-20 12:52:54','2022-06-20 12:52:54',NULL),(1438,2973,40719,10,19,1438,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',3000.00,NULL,NULL,1,'2022-06-20 12:52:54','2022-06-20 12:52:54',NULL),(1439,2973,40719,10,19,1439,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-05','2021-08-05',6218.57,NULL,NULL,1,'2022-06-20 12:52:54','2022-06-20 12:52:54',NULL),(1440,2973,40719,10,19,1440,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-09','2021-08-09',3999.00,NULL,NULL,1,'2022-06-20 12:52:54','2022-06-20 12:52:54',NULL),(1441,2973,40719,10,19,1441,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-09','2021-08-09',9680.00,NULL,NULL,1,'2022-06-20 12:52:54','2022-06-20 12:52:54',NULL),(1442,2973,40719,10,19,1442,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',40486.60,NULL,NULL,1,'2022-06-20 12:52:54','2022-06-20 12:52:54',NULL),(1443,2973,40719,10,19,1443,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',5316.54,NULL,NULL,1,'2022-06-20 12:52:54','2022-06-20 12:52:54',NULL),(1444,2973,40719,10,19,1444,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',20000.00,NULL,NULL,1,'2022-06-20 12:52:54','2022-06-20 12:52:54',NULL),(1445,2973,40719,10,19,1445,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',272.00,NULL,NULL,1,'2022-06-20 12:52:54','2022-06-20 12:52:54',NULL);
INSERT INTO `balance_libro` VALUES (1446,2973,40719,10,19,1446,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',307.62,NULL,NULL,1,'2022-06-20 12:52:54','2022-06-20 12:52:54',NULL),(1447,2973,40719,10,19,1447,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',1129.99,NULL,NULL,1,'2022-06-20 12:52:54','2022-06-20 12:52:54',NULL),(1448,2973,40719,10,19,1448,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',493680.00,NULL,NULL,1,'2022-06-20 12:52:54','2022-06-20 12:52:54',NULL),(1449,2973,40719,10,19,1449,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',372934.10,NULL,NULL,1,'2022-06-20 12:52:54','2022-06-20 12:52:54',NULL),(1450,2973,40719,10,19,1450,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',1871.30,NULL,NULL,1,'2022-06-20 12:52:54','2022-06-20 12:52:55',NULL),(1451,2973,40719,10,19,1451,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',1006.96,NULL,NULL,1,'2022-06-20 12:52:55','2022-06-20 12:52:55',NULL),(1452,2973,40719,10,19,1452,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',177.00,NULL,NULL,1,'2022-06-20 12:52:55','2022-06-20 12:52:55',NULL),(1453,2973,40719,10,19,1453,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',113960.00,NULL,NULL,1,'2022-06-20 12:52:55','2022-06-20 12:52:55',NULL),(1454,2973,40719,10,19,1454,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',200000.00,NULL,NULL,1,'2022-06-20 12:52:55','2022-06-20 12:52:55',NULL),(1455,2973,40719,10,19,1455,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',200000.00,NULL,NULL,1,'2022-06-20 12:52:55','2022-06-20 12:52:55',NULL),(1456,2973,40719,10,19,1456,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',178753.30,NULL,NULL,1,'2022-06-20 12:52:55','2022-06-20 12:52:55',NULL),(1457,2973,40719,10,19,1457,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',1065491.94,NULL,NULL,1,'2022-06-20 12:52:55','2022-06-20 12:52:55',NULL),(1458,2973,40719,10,19,1458,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',178827.98,NULL,NULL,1,'2022-06-20 12:52:55','2022-06-20 12:52:55',NULL),(1459,2973,40719,10,19,1459,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',233200.53,NULL,NULL,1,'2022-06-20 12:52:55','2022-06-20 12:52:55',NULL),(1460,2973,40719,10,19,1460,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',840.22,NULL,NULL,1,'2022-06-20 12:52:55','2022-06-20 12:52:55',NULL),(1461,2973,40719,10,19,1461,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',508.20,NULL,NULL,1,'2022-06-20 12:52:55','2022-06-20 12:52:55',NULL),(1462,2973,40719,10,19,1462,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',234316.50,NULL,NULL,1,'2022-06-20 12:52:55','2022-06-20 12:52:55',NULL),(1463,2973,40719,10,19,1463,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',332.47,NULL,NULL,1,'2022-06-20 12:52:55','2022-06-20 12:52:55',NULL),(1464,2973,40719,10,19,1464,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',33301.56,NULL,NULL,1,'2022-06-20 12:52:55','2022-06-20 12:52:55',NULL),(1465,2973,40719,10,19,1465,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',33301.56,NULL,NULL,1,'2022-06-20 12:52:55','2022-06-20 12:52:55',NULL);
INSERT INTO `balance_libro` VALUES (1466,2973,40719,10,19,1466,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',77040.31,NULL,NULL,1,'2022-06-20 12:52:55','2022-06-20 12:52:55',NULL),(1467,2973,40719,10,19,1467,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',2116701.48,NULL,NULL,1,'2022-06-20 12:52:55','2022-06-20 12:52:55',NULL),(1468,2973,40719,11,19,1468,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',40486.60,NULL,NULL,1,'2022-06-20 12:52:55','2022-06-20 12:52:55',NULL),(1469,2973,40719,11,19,1469,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',1680.00,NULL,NULL,1,'2022-06-20 12:52:55','2022-06-20 12:52:55',NULL),(1470,2973,40719,11,19,1470,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',5527.19,NULL,NULL,1,'2022-06-20 12:52:55','2022-06-20 12:52:55',NULL),(1471,2973,40719,11,19,1471,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',85126.53,NULL,NULL,1,'2022-06-20 12:52:55','2022-06-20 12:52:55',NULL),(1472,2973,40719,11,19,1472,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',195000.00,NULL,NULL,1,'2022-06-20 12:52:55','2022-06-20 12:52:55',NULL),(1473,2973,40719,11,19,1473,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',193731.81,NULL,NULL,1,'2022-06-20 12:52:55','2022-06-20 12:52:55',NULL),(1474,2973,40719,11,19,1474,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',700.33,NULL,NULL,1,'2022-06-20 12:52:55','2022-06-20 12:52:55',NULL),(1475,2973,40719,11,19,1475,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',5480.60,NULL,NULL,1,'2022-06-20 12:52:55','2022-06-20 12:52:55',NULL),(1476,2973,40719,11,19,1476,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',9845.77,NULL,NULL,1,'2022-06-20 12:52:55','2022-06-20 12:52:55',NULL),(1477,2973,40719,11,19,1477,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',1000.00,NULL,NULL,1,'2022-06-20 12:52:55','2022-06-20 12:52:55',NULL),(1478,2973,40719,11,19,1478,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',5692.23,NULL,NULL,1,'2022-06-20 12:52:55','2022-06-20 12:52:56',NULL),(1479,2973,40719,11,19,1479,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',134616.01,NULL,NULL,1,'2022-06-20 12:52:56','2022-06-20 12:52:56',NULL),(1480,2973,40719,11,19,1480,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',134616.01,NULL,NULL,1,'2022-06-20 12:52:56','2022-06-20 12:52:56',NULL),(1481,2973,40719,11,19,1481,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',138690.20,NULL,NULL,1,'2022-06-20 12:52:56','2022-06-20 12:52:56',NULL),(1482,2973,40719,11,19,1482,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',103693.98,NULL,NULL,1,'2022-06-20 12:52:56','2022-06-20 12:52:56',NULL),(1483,2973,40719,11,19,1483,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',20000.00,NULL,NULL,1,'2022-06-20 12:52:56','2022-06-20 12:52:56',NULL),(1484,2973,40719,11,19,1484,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',499730.00,NULL,NULL,1,'2022-06-20 12:52:56','2022-06-20 12:52:56',NULL),(1485,2973,40719,11,19,1485,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',327200.00,NULL,NULL,1,'2022-06-20 12:52:56','2022-06-20 12:52:56',NULL);
INSERT INTO `balance_libro` VALUES (1486,2973,40719,11,19,1486,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',34485.00,NULL,NULL,1,'2022-06-20 12:52:56','2022-06-20 12:52:56',NULL),(1487,2973,40719,11,19,1487,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-18','2021-09-18',273.55,NULL,NULL,1,'2022-06-20 12:52:56','2022-06-20 12:52:56',NULL),(1488,2973,40719,11,19,1488,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-18','2021-09-18',1695.14,NULL,NULL,1,'2022-06-20 12:52:56','2022-06-20 12:52:56',NULL),(1489,2973,40719,11,19,1489,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',5120.43,NULL,NULL,1,'2022-06-20 12:52:56','2022-06-20 12:52:56',NULL),(1490,2973,40719,11,19,1490,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',986.13,NULL,NULL,1,'2022-06-20 12:52:56','2022-06-20 12:52:56',NULL),(1491,2973,40719,11,19,1491,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',177.00,NULL,NULL,1,'2022-06-20 12:52:56','2022-06-20 12:52:56',NULL),(1492,2973,40719,11,19,1492,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',29501.31,NULL,NULL,1,'2022-06-20 12:52:56','2022-06-20 12:52:56',NULL),(1493,2973,40719,11,19,1493,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',268.19,NULL,NULL,1,'2022-06-20 12:52:56','2022-06-20 12:52:56',NULL),(1494,2973,40719,11,19,1494,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',22235.59,NULL,NULL,1,'2022-06-20 12:52:56','2022-06-20 12:52:56',NULL),(1495,2973,40719,11,19,1495,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',514760.00,NULL,NULL,1,'2022-06-20 12:52:56','2022-06-20 12:52:56',NULL),(1496,2973,40719,11,19,1496,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',258600.00,NULL,NULL,1,'2022-06-20 12:52:56','2022-06-20 12:52:56',NULL),(1497,2973,40719,11,19,1497,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',40485.12,NULL,NULL,1,'2022-06-20 12:52:56','2022-06-20 12:52:56',NULL),(1498,2973,40719,11,19,1498,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',28052.64,NULL,NULL,1,'2022-06-20 12:52:56','2022-06-20 12:52:56',NULL),(1499,2973,40719,11,19,1499,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',4489.67,NULL,NULL,1,'2022-06-20 12:52:56','2022-06-20 12:52:56',NULL),(1500,2973,40719,11,19,1500,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',436929.49,NULL,NULL,1,'2022-06-20 12:52:56','2022-06-20 12:52:56',NULL),(1501,2973,40719,11,19,1501,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',1380.00,NULL,NULL,1,'2022-06-20 12:52:56','2022-06-20 12:52:56',NULL),(1502,2973,40719,11,19,1502,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',20207.00,NULL,NULL,1,'2022-06-20 12:52:56','2022-06-20 12:52:56',NULL),(1503,2973,40719,11,19,1503,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',368258.00,NULL,NULL,1,'2022-06-20 12:52:56','2022-06-20 12:52:56',NULL),(1504,2973,40719,11,19,1504,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',288474.22,NULL,NULL,1,'2022-06-20 12:52:56','2022-06-20 12:52:56',NULL),(1505,2973,40719,11,19,1505,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',3690.00,NULL,NULL,1,'2022-06-20 12:52:56','2022-06-20 12:52:56',NULL);
INSERT INTO `balance_libro` VALUES (1506,2973,40719,11,19,1506,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',5043.03,NULL,NULL,1,'2022-06-20 12:52:56','2022-06-20 12:52:56',NULL),(1507,2973,40719,11,19,1507,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',5199.00,NULL,NULL,1,'2022-06-20 12:52:56','2022-06-20 12:52:56',NULL),(1508,2973,40719,11,19,1508,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',5467.79,NULL,NULL,1,'2022-06-20 12:52:56','2022-06-20 12:52:56',NULL),(1509,2973,40719,11,19,1509,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',869.99,NULL,NULL,1,'2022-06-20 12:52:56','2022-06-20 12:52:56',NULL),(1510,2973,40719,11,19,1510,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',83161.54,NULL,NULL,1,'2022-06-20 12:52:56','2022-06-20 12:52:56',NULL),(1511,2973,40719,11,19,1511,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',83161.54,NULL,NULL,1,'2022-06-20 12:52:56','2022-06-20 12:52:56',NULL),(1512,2973,40719,11,19,1512,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',37182.02,NULL,NULL,1,'2022-06-20 12:52:56','2022-06-20 12:52:56',NULL),(1513,2973,40719,11,19,1513,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',60.90,NULL,NULL,1,'2022-06-20 12:52:56','2022-06-20 12:52:56',NULL),(1514,2973,40719,11,19,1514,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',3993494.48,NULL,NULL,1,'2022-06-20 12:52:56','2022-06-20 12:52:57',NULL),(1515,2973,40719,12,19,1515,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',253.12,NULL,NULL,1,'2022-06-20 12:52:57','2022-06-20 12:52:57',NULL),(1516,2973,40719,12,19,1516,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-02','2021-10-02',500000.00,NULL,NULL,1,'2022-06-20 12:52:57','2022-06-20 12:52:57',NULL),(1517,2973,40719,12,19,1517,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-02','2021-10-02',200000.00,NULL,NULL,1,'2022-06-20 12:52:57','2022-06-20 12:52:57',NULL),(1518,2973,40719,12,19,1518,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',40486.60,NULL,NULL,1,'2022-06-20 12:52:57','2022-06-20 12:52:57',NULL),(1519,2973,40719,12,19,1519,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',2156.96,NULL,NULL,1,'2022-06-20 12:52:57','2022-06-20 12:52:57',NULL),(1520,2973,40719,12,19,1520,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',40535.00,NULL,NULL,1,'2022-06-20 12:52:57','2022-06-20 12:52:57',NULL),(1521,2973,40719,12,19,1521,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',69212.00,NULL,NULL,1,'2022-06-20 12:52:57','2022-06-20 12:52:57',NULL),(1522,2973,40719,12,19,1522,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',9958.30,NULL,NULL,1,'2022-06-20 12:52:57','2022-06-20 12:52:57',NULL),(1523,2973,40719,12,19,1523,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',7200.01,NULL,NULL,1,'2022-06-20 12:52:57','2022-06-20 12:52:57',NULL),(1524,2973,40719,12,19,1524,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',326000.00,NULL,NULL,1,'2022-06-20 12:52:57','2022-06-20 12:52:57',NULL),(1525,2973,40719,12,19,1525,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',501.00,NULL,NULL,1,'2022-06-20 12:52:57','2022-06-20 12:52:57',NULL);
INSERT INTO `balance_libro` VALUES (1526,2973,40719,12,19,1526,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',20000.00,NULL,NULL,1,'2022-06-20 12:52:57','2022-06-20 12:52:57',NULL),(1527,2973,40719,12,19,1527,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',5600.00,NULL,NULL,1,'2022-06-20 12:52:57','2022-06-20 12:52:57',NULL),(1528,2973,40719,12,19,1528,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',879.98,NULL,NULL,1,'2022-06-20 12:52:57','2022-06-20 12:52:57',NULL),(1529,2973,40719,12,19,1529,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-17','2021-10-17',5882.19,NULL,NULL,1,'2022-06-20 12:52:57','2022-06-20 12:52:57',NULL),(1530,2973,40719,12,19,1530,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',26.50,NULL,NULL,1,'2022-06-20 12:52:57','2022-06-20 12:52:57',NULL),(1531,2973,40719,12,19,1531,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',115373.50,NULL,NULL,1,'2022-06-20 12:52:57','2022-06-20 12:52:57',NULL),(1532,2973,40719,12,19,1532,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',224000.00,NULL,NULL,1,'2022-06-20 12:52:57','2022-06-20 12:52:57',NULL),(1533,2973,40719,12,19,1533,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',211.80,NULL,NULL,1,'2022-06-20 12:52:57','2022-06-20 12:52:57',NULL),(1534,2973,40719,12,19,1534,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',1627.41,NULL,NULL,1,'2022-06-20 12:52:57','2022-06-20 12:52:57',NULL),(1535,2973,40719,12,19,1535,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',5056.23,NULL,NULL,1,'2022-06-20 12:52:57','2022-06-20 12:52:57',NULL),(1536,2973,40719,12,19,1536,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',9002.40,NULL,NULL,1,'2022-06-20 12:52:57','2022-06-20 12:52:57',NULL),(1537,2973,40719,12,19,1537,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',1069.44,NULL,NULL,1,'2022-06-20 12:52:57','2022-06-20 12:52:57',NULL),(1538,2973,40719,12,19,1538,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',2645.80,NULL,NULL,1,'2022-06-20 12:52:57','2022-06-20 12:52:57',NULL),(1539,2973,40719,12,19,1539,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',73205.00,NULL,NULL,1,'2022-06-20 12:52:57','2022-06-20 12:52:57',NULL),(1540,2973,40719,12,19,1540,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',172.50,NULL,NULL,1,'2022-06-20 12:52:57','2022-06-20 12:52:57',NULL),(1541,2973,40719,12,19,1541,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',1716.00,NULL,NULL,1,'2022-06-20 12:52:57','2022-06-20 12:52:57',NULL),(1542,2973,40719,12,19,1542,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',43929.05,NULL,NULL,1,'2022-06-20 12:52:57','2022-06-20 12:52:57',NULL),(1543,2973,40719,12,19,1543,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',85.00,NULL,NULL,1,'2022-06-20 12:52:57','2022-06-20 12:52:57',NULL),(1544,2973,40719,12,19,1544,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',85.00,NULL,NULL,1,'2022-06-20 12:52:57','2022-06-20 12:52:57',NULL),(1545,2973,40719,12,19,1545,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',261700.00,NULL,NULL,1,'2022-06-20 12:52:57','2022-06-20 12:52:57',NULL);
INSERT INTO `balance_libro` VALUES (1546,2973,40719,12,19,1546,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',192649.05,NULL,NULL,1,'2022-06-20 12:52:57','2022-06-20 12:52:57',NULL),(1547,2973,40719,12,19,1547,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',272805.45,NULL,NULL,1,'2022-06-20 12:52:57','2022-06-20 12:52:58',NULL),(1548,2973,40719,12,19,1548,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',40159.78,NULL,NULL,1,'2022-06-20 12:52:58','2022-06-20 12:52:58',NULL),(1549,2973,40719,12,19,1549,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',40159.78,NULL,NULL,1,'2022-06-20 12:52:58','2022-06-20 12:52:58',NULL),(1550,2973,40719,12,19,1550,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',35934.37,NULL,NULL,1,'2022-06-20 12:52:58','2022-06-20 12:52:58',NULL),(1551,2973,40719,12,19,1551,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',13248.32,NULL,NULL,1,'2022-06-20 12:52:58','2022-06-20 12:52:58',NULL),(1552,2973,40719,12,19,1552,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',2526305.26,NULL,NULL,1,'2022-06-20 12:52:58','2022-06-20 12:52:58',NULL),(1553,2973,40719,13,19,1553,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',40486.60,NULL,NULL,1,'2022-06-20 12:52:58','2022-06-20 12:52:58',NULL),(1554,2973,40719,13,19,1554,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',25235.17,NULL,NULL,1,'2022-06-20 12:52:58','2022-06-20 12:52:58',NULL),(1555,2973,40719,13,19,1555,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',421.06,NULL,NULL,1,'2022-06-20 12:52:58','2022-06-20 12:52:58',NULL),(1556,2973,40719,13,19,1556,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',35783.25,NULL,NULL,1,'2022-06-20 12:52:58','2022-06-20 12:52:58',NULL),(1557,2973,40719,13,19,1557,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',837.14,NULL,NULL,1,'2022-06-20 12:52:58','2022-06-20 12:52:58',NULL),(1558,2973,40719,13,19,1558,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',98.60,NULL,NULL,1,'2022-06-20 12:52:58','2022-06-20 12:52:58',NULL),(1559,2973,40719,13,19,1559,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',1406.28,NULL,NULL,1,'2022-06-20 12:52:58','2022-06-20 12:52:58',NULL),(1560,2973,40719,13,19,1560,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',248382.75,NULL,NULL,1,'2022-06-20 12:52:58','2022-06-20 12:52:58',NULL),(1561,2973,40719,13,19,1561,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',398475.00,NULL,NULL,1,'2022-06-20 12:52:58','2022-06-20 12:52:58',NULL),(1562,2973,40719,13,19,1562,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',2109.94,NULL,NULL,1,'2022-06-20 12:52:58','2022-06-20 12:52:58',NULL),(1563,2973,40719,13,19,1563,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',5525.32,NULL,NULL,1,'2022-06-20 12:52:58','2022-06-20 12:52:58',NULL),(1564,2973,40719,13,19,1564,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',93476.73,NULL,NULL,1,'2022-06-20 12:52:58','2022-06-20 12:52:58',NULL),(1565,2973,40719,13,19,1565,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',564740.86,NULL,NULL,1,'2022-06-20 12:52:58','2022-06-20 12:52:58',NULL);
INSERT INTO `balance_libro` VALUES (1566,2973,40719,13,19,1566,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',490050.00,NULL,NULL,1,'2022-06-20 12:52:58','2022-06-20 12:52:58',NULL),(1567,2973,40719,13,19,1567,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',30605.44,NULL,NULL,1,'2022-06-20 12:52:58','2022-06-20 12:52:58',NULL),(1568,2973,40719,13,19,1568,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',2519.27,NULL,NULL,1,'2022-06-20 12:52:58','2022-06-20 12:52:58',NULL),(1569,2973,40719,13,19,1569,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-16','2021-11-16',3544.66,NULL,NULL,1,'2022-06-20 12:52:58','2022-06-20 12:52:58',NULL),(1570,2973,40719,13,19,1570,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-16','2021-11-16',26000.00,NULL,NULL,1,'2022-06-20 12:52:58','2022-06-20 12:52:58',NULL),(1571,2973,40719,13,19,1571,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',7623.00,NULL,NULL,1,'2022-06-20 12:52:58','2022-06-20 12:52:58',NULL),(1572,2973,40719,13,19,1572,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',22748.00,NULL,NULL,1,'2022-06-20 12:52:58','2022-06-20 12:52:58',NULL),(1573,2973,40719,13,19,1573,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',175525.63,NULL,NULL,1,'2022-06-20 12:52:58','2022-06-20 12:52:59',NULL),(1574,2973,40719,13,19,1574,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',2174.73,NULL,NULL,1,'2022-06-20 12:52:59','2022-06-20 12:52:59',NULL),(1575,2973,40719,13,19,1575,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',7623.00,NULL,NULL,1,'2022-06-20 12:52:59','2022-06-20 12:52:59',NULL),(1576,2973,40719,13,19,1576,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-20','2021-11-20',1288.12,NULL,NULL,1,'2022-06-20 12:52:59','2022-06-20 12:52:59',NULL),(1577,2973,40719,13,19,1577,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-24','2021-11-24',209.25,NULL,NULL,1,'2022-06-20 12:52:59','2022-06-20 12:52:59',NULL),(1578,2973,40719,13,19,1578,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',5525.72,NULL,NULL,1,'2022-06-20 12:52:59','2022-06-20 12:52:59',NULL),(1579,2973,40719,13,19,1579,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',5299.00,NULL,NULL,1,'2022-06-20 12:52:59','2022-06-20 12:52:59',NULL),(1580,2973,40719,13,19,1580,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',345961.81,NULL,NULL,1,'2022-06-20 12:52:59','2022-06-20 12:52:59',NULL),(1581,2973,40719,13,19,1581,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',329419.35,NULL,NULL,1,'2022-06-20 12:52:59','2022-06-20 12:52:59',NULL),(1582,2973,40719,13,19,1582,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',253.12,NULL,NULL,1,'2022-06-20 12:52:59','2022-06-20 12:52:59',NULL),(1583,2973,40719,13,19,1583,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',89173.88,NULL,NULL,1,'2022-06-20 12:52:59','2022-06-20 12:52:59',NULL),(1584,2973,40719,13,19,1584,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',89173.88,NULL,NULL,1,'2022-06-20 12:52:59','2022-06-20 12:52:59',NULL),(1585,2973,40719,13,19,1585,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',41031.94,NULL,NULL,1,'2022-06-20 12:52:59','2022-06-20 12:52:59',NULL);
INSERT INTO `balance_libro` VALUES (1586,2973,40719,13,19,1586,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',60.90,NULL,NULL,1,'2022-06-20 12:52:59','2022-06-20 12:52:59',NULL),(1587,2973,40719,13,19,1587,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',3995261.11,NULL,NULL,1,'2022-06-20 12:52:59','2022-06-20 12:52:59',NULL),(1588,2973,40719,14,19,1588,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-02','2021-12-02',10928.72,NULL,NULL,1,'2022-06-20 12:52:59','2022-06-20 12:52:59',NULL),(1589,2973,40719,14,19,1589,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-02','2021-12-02',26000.00,NULL,NULL,1,'2022-06-20 12:52:59','2022-06-20 12:52:59',NULL),(1590,2973,40719,14,19,1590,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-03','2021-12-03',1374.68,NULL,NULL,1,'2022-06-20 12:52:59','2022-06-20 12:52:59',NULL),(1591,2973,40719,14,19,1591,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',40486.60,NULL,NULL,1,'2022-06-20 12:52:59','2022-06-20 12:52:59',NULL),(1592,2973,40719,14,19,1592,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',3355.99,NULL,NULL,1,'2022-06-20 12:52:59','2022-06-20 12:52:59',NULL),(1593,2973,40719,14,19,1593,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',280000.00,NULL,NULL,1,'2022-06-20 12:52:59','2022-06-20 12:52:59',NULL),(1594,2973,40719,14,19,1594,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',311.25,NULL,NULL,1,'2022-06-20 12:52:59','2022-06-20 12:52:59',NULL),(1595,2973,40719,14,19,1595,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-07','2021-12-07',77440.00,NULL,NULL,1,'2022-06-20 12:52:59','2022-06-20 12:52:59',NULL),(1596,2973,40719,14,19,1596,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-10','2021-12-10',396082.91,NULL,NULL,1,'2022-06-20 12:52:59','2022-06-20 12:52:59',NULL),(1597,2973,40719,14,19,1597,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-12','2021-12-12',5681.00,NULL,NULL,1,'2022-06-20 12:52:59','2022-06-20 12:52:59',NULL),(1598,2973,40719,14,19,1598,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-13','2021-12-13',5475.82,NULL,NULL,1,'2022-06-20 12:52:59','2022-06-20 12:52:59',NULL),(1599,2973,40719,14,19,1599,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-13','2021-12-13',296600.00,NULL,NULL,1,'2022-06-20 12:52:59','2022-06-20 12:52:59',NULL),(1600,2973,40719,14,19,1600,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',121000.00,NULL,NULL,1,'2022-06-20 12:52:59','2022-06-20 12:52:59',NULL),(1601,2973,40719,14,19,1601,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',3829.99,NULL,NULL,1,'2022-06-20 12:52:59','2022-06-20 12:52:59',NULL),(1602,2973,40719,14,19,1602,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',190500.00,NULL,NULL,1,'2022-06-20 12:52:59','2022-06-20 12:52:59',NULL),(1603,2973,40719,14,19,1603,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-15','2021-12-15',4900.00,NULL,NULL,1,'2022-06-20 12:52:59','2022-06-20 12:52:59',NULL),(1604,2973,40719,14,19,1604,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',5580.00,NULL,NULL,1,'2022-06-20 12:52:59','2022-06-20 12:52:59',NULL),(1605,2973,40719,14,19,1605,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',8100.00,NULL,NULL,1,'2022-06-20 12:52:59','2022-06-20 12:52:59',NULL);
INSERT INTO `balance_libro` VALUES (1606,2973,40719,14,19,1606,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',21568.91,NULL,NULL,1,'2022-06-20 12:52:59','2022-06-20 12:52:59',NULL),(1607,2973,40719,14,19,1607,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',1537.77,NULL,NULL,1,'2022-06-20 12:52:59','2022-06-20 12:52:59',NULL),(1608,2973,40719,14,19,1608,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',65945.00,NULL,NULL,1,'2022-06-20 12:52:59','2022-06-20 12:52:59',NULL),(1609,2973,40719,14,19,1609,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',182165.00,NULL,NULL,1,'2022-06-20 12:52:59','2022-06-20 12:53:00',NULL),(1610,2973,40719,14,19,1610,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',14520.00,NULL,NULL,1,'2022-06-20 12:53:00','2022-06-20 12:53:00',NULL),(1611,2973,40719,14,19,1611,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',151963.60,NULL,NULL,1,'2022-06-20 12:53:00','2022-06-20 12:53:00',NULL),(1612,2973,40719,14,19,1612,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',14520.00,NULL,NULL,1,'2022-06-20 12:53:00','2022-06-20 12:53:00',NULL),(1613,2973,40719,14,19,1613,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',1000.00,NULL,NULL,1,'2022-06-20 12:53:00','2022-06-20 12:53:00',NULL),(1614,2973,40719,14,19,1614,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',6305.74,NULL,NULL,1,'2022-06-20 12:53:00','2022-06-20 12:53:00',NULL),(1615,2973,40719,14,19,1615,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',1569.27,NULL,NULL,1,'2022-06-20 12:53:00','2022-06-20 12:53:00',NULL),(1616,2973,40719,14,19,1616,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',1042233.50,NULL,NULL,1,'2022-06-20 12:53:00','2022-06-20 12:53:00',NULL),(1617,2973,40719,14,19,1617,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-28','2021-12-28',9680.00,NULL,NULL,1,'2022-06-20 12:53:00','2022-06-20 12:53:00',NULL),(1618,2973,40719,14,19,1618,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',39.21,NULL,NULL,1,'2022-06-20 12:53:00','2022-06-20 12:53:00',NULL),(1619,2973,40719,14,19,1619,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',0.12,NULL,NULL,1,'2022-06-20 12:53:00','2022-06-20 12:53:00',NULL),(1620,2973,40719,14,19,1620,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',335445.62,NULL,NULL,1,'2022-06-20 12:53:00','2022-06-20 12:53:00',NULL),(1621,2973,40719,14,19,1621,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',370516.97,NULL,NULL,1,'2022-06-20 12:53:00','2022-06-20 12:53:00',NULL),(1622,2973,40719,14,19,1622,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',322580.14,NULL,NULL,1,'2022-06-20 12:53:00','2022-06-20 12:53:00',NULL),(1623,2973,40719,14,19,1623,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',48826.88,NULL,NULL,1,'2022-06-20 12:53:00','2022-06-20 12:53:00',NULL),(1624,2973,40719,14,19,1624,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',48826.88,NULL,NULL,1,'2022-06-20 12:53:00','2022-06-20 12:53:00',NULL),(1625,2973,40719,14,19,1625,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',68126.98,NULL,NULL,1,'2022-06-20 12:53:00','2022-06-20 12:53:00',NULL);
INSERT INTO `balance_libro` VALUES (1626,2973,40719,14,19,1626,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',2462942.84,NULL,NULL,1,'2022-06-20 12:53:00','2022-06-20 18:03:44','2022-06-20 18:03:44'),(1627,2973,40719,14,19,1627,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',2110000.00,NULL,NULL,1,'2022-06-20 12:53:00','2022-06-20 18:03:39','2022-06-20 18:03:39'),(1628,2973,40719,14,19,1628,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',20226.03,NULL,NULL,1,'2022-06-20 12:53:00','2022-06-20 12:53:00',NULL),(1629,2973,40719,14,19,1629,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',4893013.74,NULL,NULL,1,'2022-06-20 12:53:00','2022-06-20 18:03:36','2022-06-20 18:03:36'),(1630,2973,40719,3,19,1630,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-01','2021-01-01',2749.36,NULL,NULL,1,'2022-06-20 18:05:48','2022-06-20 18:05:48',NULL),(1631,2973,40720,1545,19,1631,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-01','2021-01-01',2749.36,NULL,NULL,1,'2022-06-20 18:07:31','2022-06-20 18:07:31',NULL),(1632,2973,40720,1545,19,1632,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-01','2021-01-01',2424000.29,NULL,NULL,1,'2022-06-20 18:07:31','2022-06-20 18:07:31',NULL),(1633,2973,40720,1545,19,1633,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-01','2021-01-01',5516625.09,NULL,NULL,1,'2022-06-20 18:07:31','2022-06-20 20:44:05','2022-06-20 20:44:05'),(1634,2973,40720,1545,19,1634,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-02','2021-01-02',6557.72,NULL,NULL,1,'2022-06-20 18:07:31','2022-06-20 18:07:31',NULL),(1635,2973,40720,1545,19,1635,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-02','2021-01-02',800000.00,NULL,NULL,1,'2022-06-20 18:07:31','2022-06-20 18:07:31',NULL),(1636,2973,40720,1545,19,1636,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',35204.95,NULL,NULL,1,'2022-06-20 18:07:31','2022-06-20 18:07:31',NULL),(1637,2973,40720,1545,19,1637,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',45.05,NULL,NULL,1,'2022-06-20 18:07:31','2022-06-20 18:07:31',NULL),(1638,2973,40720,1545,19,1638,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',987.17,NULL,NULL,1,'2022-06-20 18:07:31','2022-06-20 18:07:31',NULL),(1639,2973,40720,1545,19,1639,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',179267.55,NULL,NULL,1,'2022-06-20 18:07:31','2022-06-20 18:07:31',NULL),(1640,2973,40720,1545,19,1640,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',3929.58,NULL,NULL,1,'2022-06-20 18:07:31','2022-06-20 18:07:31',NULL),(1641,2973,40720,1545,19,1641,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',51591.18,NULL,NULL,1,'2022-06-20 18:07:31','2022-06-20 18:07:31',NULL),(1642,2973,40720,1545,19,1642,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',15000.00,NULL,NULL,1,'2022-06-20 18:07:31','2022-06-20 18:07:32',NULL),(1643,2973,40720,1545,19,1643,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',350.42,NULL,NULL,1,'2022-06-20 18:07:32','2022-06-20 18:07:32',NULL),(1644,2973,40720,1545,19,1644,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',86481.12,NULL,NULL,1,'2022-06-20 18:07:32','2022-06-20 18:07:32',NULL),(1645,2973,40720,1545,19,1645,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',5445.00,NULL,NULL,1,'2022-06-20 18:07:32','2022-06-20 18:07:32',NULL);
INSERT INTO `balance_libro` VALUES (1646,2973,40720,1545,19,1646,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',793911.25,NULL,NULL,1,'2022-06-20 18:07:32','2022-06-20 18:07:32',NULL),(1647,2973,40720,1545,19,1647,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',116100.00,NULL,NULL,1,'2022-06-20 18:07:32','2022-06-20 18:07:32',NULL),(1648,2973,40720,1545,19,1648,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',3900.16,NULL,NULL,1,'2022-06-20 18:07:32','2022-06-20 18:07:32',NULL),(1649,2973,40720,1545,19,1649,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-16','2021-01-16',4357.90,NULL,NULL,1,'2022-06-20 18:07:32','2022-06-20 18:07:32',NULL),(1650,2973,40720,1545,19,1650,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-16','2021-01-16',4696.48,NULL,NULL,1,'2022-06-20 18:07:32','2022-06-20 18:07:32',NULL),(1651,2973,40720,1545,19,1651,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',207.10,NULL,NULL,1,'2022-06-20 18:07:32','2022-06-20 18:07:32',NULL),(1652,2973,40720,1545,19,1652,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',861.59,NULL,NULL,1,'2022-06-20 18:07:32','2022-06-20 18:07:32',NULL),(1653,2973,40720,1545,19,1653,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',514.46,NULL,NULL,1,'2022-06-20 18:07:32','2022-06-20 18:07:32',NULL),(1654,2973,40720,1545,19,1654,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',12590.06,NULL,NULL,1,'2022-06-20 18:07:32','2022-06-20 18:07:32',NULL),(1655,2973,40720,1545,19,1655,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',4069.69,NULL,NULL,1,'2022-06-20 18:07:32','2022-06-20 18:07:32',NULL),(1656,2973,40720,1545,19,1656,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',3600.02,NULL,NULL,1,'2022-06-20 18:07:32','2022-06-20 18:07:32',NULL),(1657,2973,40720,1545,19,1657,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',414600.00,NULL,NULL,1,'2022-06-20 18:07:32','2022-06-20 18:07:32',NULL),(1658,2973,40720,1545,19,1658,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',12801.80,NULL,NULL,1,'2022-06-20 18:07:32','2022-06-20 18:07:32',NULL),(1659,2973,40720,1545,19,1659,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',38.00,NULL,NULL,1,'2022-06-20 18:07:32','2022-06-20 18:07:32',NULL),(1660,2973,40720,1545,19,1660,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',6150.43,NULL,NULL,1,'2022-06-20 18:07:32','2022-06-20 18:07:32',NULL),(1661,2973,40720,1545,19,1661,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',69870.07,NULL,NULL,1,'2022-06-20 18:07:32','2022-06-20 18:07:32',NULL),(1662,2973,40720,1545,19,1662,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',10632.42,NULL,NULL,1,'2022-06-20 18:07:32','2022-06-20 18:07:32',NULL),(1663,2973,40720,1545,19,1663,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',307243.20,NULL,NULL,1,'2022-06-20 18:07:32','2022-06-20 18:07:32',NULL),(1664,2973,40720,1545,19,1664,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',4112.36,NULL,NULL,1,'2022-06-20 18:07:32','2022-06-20 18:07:33',NULL),(1665,2973,40720,1545,19,1665,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',311696.00,NULL,NULL,1,'2022-06-20 18:07:33','2022-06-20 20:45:02','2022-06-20 20:45:02');
INSERT INTO `balance_libro` VALUES (1666,2973,40720,1545,19,1666,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',311696.00,NULL,NULL,1,'2022-06-20 18:07:33','2022-06-20 18:07:33',NULL),(1667,2973,40720,1545,19,1667,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',307243.20,NULL,NULL,1,'2022-06-20 18:07:33','2022-06-20 18:07:33',NULL),(1668,2973,40720,1545,19,1668,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',47091.92,NULL,NULL,1,'2022-06-20 18:07:33','2022-06-20 18:07:33',NULL),(1669,2973,40720,1545,19,1669,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',23947.14,NULL,NULL,1,'2022-06-20 18:07:33','2022-06-20 18:07:33',NULL),(1670,2973,40720,1545,19,1670,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',5152.00,NULL,NULL,1,'2022-06-20 18:07:33','2022-06-20 18:07:33',NULL),(1671,2973,40720,1545,19,1671,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',316044.81,NULL,NULL,1,'2022-06-20 18:07:33','2022-06-20 18:07:33',NULL),(1672,2973,40720,1545,19,1672,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',83697.58,NULL,NULL,1,'2022-06-20 18:07:33','2022-06-20 18:07:33',NULL),(1673,2973,40720,1545,19,1673,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',47091.92,NULL,NULL,1,'2022-06-20 18:07:33','2022-06-20 20:45:37','2022-06-20 20:45:37'),(1674,2973,40720,1545,19,1674,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',2325858.11,NULL,NULL,1,'2022-06-20 18:07:33','2022-06-20 20:46:50','2022-06-20 20:46:50'),(1675,2973,40720,1546,19,1675,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',280.88,NULL,NULL,1,'2022-06-20 18:07:33','2022-06-20 18:07:33',NULL),(1676,2973,40720,1546,19,1676,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',35204.95,NULL,NULL,1,'2022-06-20 18:07:33','2022-06-20 18:07:33',NULL),(1677,2973,40720,1546,19,1677,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',772282.50,NULL,NULL,1,'2022-06-20 18:07:33','2022-06-20 18:07:33',NULL),(1678,2973,40720,1546,19,1678,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',1180.94,NULL,NULL,1,'2022-06-20 18:07:33','2022-06-20 18:07:33',NULL),(1679,2973,40720,1546,19,1679,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',3513.51,NULL,NULL,1,'2022-06-20 18:07:33','2022-06-20 18:07:33',NULL),(1680,2973,40720,1546,19,1680,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',93775.00,NULL,NULL,1,'2022-06-20 18:07:33','2022-06-20 18:07:33',NULL),(1681,2973,40720,1546,19,1681,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',27000.00,NULL,NULL,1,'2022-06-20 18:07:33','2022-06-20 18:07:33',NULL),(1682,2973,40720,1546,19,1682,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',15000.00,NULL,NULL,1,'2022-06-20 18:07:33','2022-06-20 18:07:33',NULL),(1683,2973,40720,1546,19,1683,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',108802.10,NULL,NULL,1,'2022-06-20 18:07:33','2022-06-20 18:07:33',NULL),(1684,2973,40720,1546,19,1684,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',388500.00,NULL,NULL,1,'2022-06-20 18:07:33','2022-06-20 18:07:33',NULL),(1685,2973,40720,1546,19,1685,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',388500.00,NULL,NULL,1,'2022-06-20 18:07:33','2022-06-20 18:07:33',NULL);
INSERT INTO `balance_libro` VALUES (1686,2973,40720,1546,19,1686,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',788390.00,NULL,NULL,1,'2022-06-20 18:07:33','2022-06-20 18:07:33',NULL),(1687,2973,40720,1546,19,1687,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',3961.77,NULL,NULL,1,'2022-06-20 18:07:33','2022-06-20 18:07:33',NULL),(1688,2973,40720,1546,19,1688,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',1450.70,NULL,NULL,1,'2022-06-20 18:07:33','2022-06-20 18:07:34',NULL),(1689,2973,40720,1546,19,1689,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',73931.00,NULL,NULL,1,'2022-06-20 18:07:34','2022-06-20 18:07:34',NULL),(1690,2973,40720,1546,19,1690,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',1137.12,NULL,NULL,1,'2022-06-20 18:07:34','2022-06-20 18:07:34',NULL),(1691,2973,40720,1546,19,1691,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',2789.99,NULL,NULL,1,'2022-06-20 18:07:34','2022-06-20 18:07:34',NULL),(1692,2973,40720,1546,19,1692,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',484.21,NULL,NULL,1,'2022-06-20 18:07:34','2022-06-20 18:07:34',NULL),(1693,2973,40720,1546,19,1693,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',15612.63,NULL,NULL,1,'2022-06-20 18:07:34','2022-06-20 18:07:34',NULL),(1694,2973,40720,1546,19,1694,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',510005.86,NULL,NULL,1,'2022-06-20 18:07:34','2022-06-20 18:07:34',NULL),(1695,2973,40720,1546,19,1695,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',65176.65,NULL,NULL,1,'2022-06-20 18:07:34','2022-06-20 18:07:34',NULL),(1696,2973,40720,1546,19,1696,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',22308.10,NULL,NULL,1,'2022-06-20 18:07:34','2022-06-20 18:07:34',NULL),(1697,2973,40720,1546,19,1697,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',4518.11,NULL,NULL,1,'2022-06-20 18:07:34','2022-06-20 18:07:34',NULL),(1698,2973,40720,1546,19,1698,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',84.87,NULL,NULL,1,'2022-06-20 18:07:34','2022-06-20 18:07:34',NULL),(1699,2973,40720,1546,19,1699,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',72.80,NULL,NULL,1,'2022-06-20 18:07:34','2022-06-20 18:07:34',NULL),(1700,2973,40720,1546,19,1700,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',298447.17,NULL,NULL,1,'2022-06-20 18:07:34','2022-06-20 18:07:34',NULL),(1701,2973,40720,1546,19,1701,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',113085.41,NULL,NULL,1,'2022-06-20 18:07:34','2022-06-20 18:07:34',NULL),(1702,2973,40720,1546,19,1702,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',80889.01,NULL,NULL,1,'2022-06-20 18:07:34','2022-06-20 18:07:34',NULL),(1703,2973,40720,1546,19,1703,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',80889.01,NULL,NULL,1,'2022-06-20 18:07:34','2022-06-20 20:47:27','2022-06-20 20:47:27'),(1704,2973,40720,1546,19,1704,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',4032561.86,NULL,NULL,1,'2022-06-20 18:07:34','2022-06-20 20:48:36','2022-06-20 20:48:36'),(1705,2973,40720,1547,19,1705,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',60000.00,NULL,NULL,1,'2022-06-20 18:07:34','2022-06-20 18:07:35',NULL);
INSERT INTO `balance_libro` VALUES (1706,2973,40720,1547,19,1706,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',5200.00,NULL,NULL,1,'2022-06-20 18:07:35','2022-06-20 18:07:35',NULL),(1707,2973,40720,1547,19,1707,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',289700.00,NULL,NULL,1,'2022-06-20 18:07:35','2022-06-20 18:07:35',NULL),(1708,2973,40720,1547,19,1708,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',26526.81,NULL,NULL,1,'2022-06-20 18:07:35','2022-06-20 18:07:35',NULL),(1709,2973,40720,1547,19,1709,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',620.20,NULL,NULL,1,'2022-06-20 18:07:35','2022-06-20 18:07:35',NULL),(1710,2973,40720,1547,19,1710,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',419.99,NULL,NULL,1,'2022-06-20 18:07:35','2022-06-20 18:07:35',NULL),(1711,2973,40720,1547,19,1711,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',35204.95,NULL,NULL,1,'2022-06-20 18:07:35','2022-06-20 18:07:35',NULL),(1712,2973,40720,1547,19,1712,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',88330.00,NULL,NULL,1,'2022-06-20 18:07:35','2022-06-20 18:07:35',NULL),(1713,2973,40720,1547,19,1713,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',2607.77,NULL,NULL,1,'2022-06-20 18:07:35','2022-06-20 18:07:35',NULL),(1714,2973,40720,1547,19,1714,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',12000.00,NULL,NULL,1,'2022-06-20 18:07:35','2022-06-20 18:07:35',NULL),(1715,2973,40720,1547,19,1715,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',1048.52,NULL,NULL,1,'2022-06-20 18:07:35','2022-06-20 18:07:35',NULL),(1716,2973,40720,1547,19,1716,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',54450.00,NULL,NULL,1,'2022-06-20 18:07:35','2022-06-20 18:07:35',NULL),(1717,2973,40720,1547,19,1717,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',4350.41,NULL,NULL,1,'2022-06-20 18:07:35','2022-06-20 18:07:35',NULL),(1718,2973,40720,1547,19,1718,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',106480.00,NULL,NULL,1,'2022-06-20 18:07:35','2022-06-20 18:07:35',NULL),(1719,2973,40720,1547,19,1719,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',206.00,NULL,NULL,1,'2022-06-20 18:07:35','2022-06-20 18:07:35',NULL),(1720,2973,40720,1547,19,1720,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',170.48,NULL,NULL,1,'2022-06-20 18:07:35','2022-06-20 18:07:35',NULL),(1721,2973,40720,1547,19,1721,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',7200.00,NULL,NULL,1,'2022-06-20 18:07:35','2022-06-20 18:07:35',NULL),(1722,2973,40720,1547,19,1722,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1500.00,NULL,NULL,1,'2022-06-20 18:07:35','2022-06-20 18:07:35',NULL),(1723,2973,40720,1547,19,1723,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',3471.00,NULL,NULL,1,'2022-06-20 18:07:35','2022-06-20 18:07:36',NULL),(1724,2973,40720,1547,19,1724,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',414750.01,NULL,NULL,1,'2022-06-20 18:07:36','2022-06-20 18:07:36',NULL),(1725,2973,40720,1547,19,1725,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',231110.00,NULL,NULL,1,'2022-06-20 18:07:36','2022-06-20 18:07:36',NULL);
INSERT INTO `balance_libro` VALUES (1726,2973,40720,1547,19,1726,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',1040.00,NULL,NULL,1,'2022-06-20 18:07:36','2022-06-20 18:07:36',NULL),(1727,2973,40720,1547,19,1727,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',15000.00,NULL,NULL,1,'2022-06-20 18:07:36','2022-06-20 18:07:36',NULL),(1728,2973,40720,1547,19,1728,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',1820.00,NULL,NULL,1,'2022-06-20 18:07:36','2022-06-20 18:07:36',NULL),(1729,2973,40720,1547,19,1729,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',315.87,NULL,NULL,1,'2022-06-20 18:07:36','2022-06-20 18:07:36',NULL),(1730,2973,40720,1547,19,1730,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',5087.29,NULL,NULL,1,'2022-06-20 18:07:36','2022-06-20 18:07:36',NULL),(1731,2973,40720,1547,19,1731,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',164540.00,NULL,NULL,1,'2022-06-20 18:07:36','2022-06-20 18:07:36',NULL),(1732,2973,40720,1547,19,1732,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',3378.24,NULL,NULL,1,'2022-06-20 18:07:36','2022-06-20 18:07:36',NULL),(1733,2973,40720,1547,19,1733,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',119420.43,NULL,NULL,1,'2022-06-20 18:07:36','2022-06-20 18:07:36',NULL),(1734,2973,40720,1547,19,1734,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',499.83,NULL,NULL,1,'2022-06-20 18:07:36','2022-06-20 18:07:36',NULL),(1735,2973,40720,1547,19,1735,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',87800.00,NULL,NULL,1,'2022-06-20 18:07:36','2022-06-20 18:07:36',NULL),(1736,2973,40720,1547,19,1736,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',86.75,NULL,NULL,1,'2022-06-20 18:07:36','2022-06-20 18:07:36',NULL),(1737,2973,40720,1547,19,1737,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',32524.80,NULL,NULL,1,'2022-06-20 18:07:36','2022-06-20 18:07:36',NULL),(1738,2973,40720,1547,19,1738,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',806.40,NULL,NULL,1,'2022-06-20 18:07:36','2022-06-20 18:07:36',NULL),(1739,2973,40720,1547,19,1739,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',818.20,NULL,NULL,1,'2022-06-20 18:07:36','2022-06-20 18:07:36',NULL),(1740,2973,40720,1547,19,1740,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',4600.70,NULL,NULL,1,'2022-06-20 18:07:36','2022-06-20 18:07:36',NULL),(1741,2973,40720,1547,19,1741,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',1928.25,NULL,NULL,1,'2022-06-20 18:07:36','2022-06-20 18:07:36',NULL),(1742,2973,40720,1547,19,1742,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',1024.66,NULL,NULL,1,'2022-06-20 18:07:36','2022-06-20 18:07:36',NULL),(1743,2973,40720,1547,19,1743,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',36300.00,NULL,NULL,1,'2022-06-20 18:07:36','2022-06-20 18:07:36',NULL),(1744,2973,40720,1547,19,1744,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',600.00,NULL,NULL,1,'2022-06-20 18:07:36','2022-06-20 18:07:36',NULL),(1745,2973,40720,1547,19,1745,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',7746.42,NULL,NULL,1,'2022-06-20 18:07:36','2022-06-20 18:07:36',NULL);
INSERT INTO `balance_libro` VALUES (1746,2973,40720,1547,19,1746,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',260.00,NULL,NULL,1,'2022-06-20 18:07:36','2022-06-20 18:07:36',NULL),(1747,2973,40720,1547,19,1747,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',21521.65,NULL,NULL,1,'2022-06-20 18:07:36','2022-06-20 18:07:36',NULL),(1748,2973,40720,1547,19,1748,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',67397.00,NULL,NULL,1,'2022-06-20 18:07:36','2022-06-20 18:07:36',NULL),(1749,2973,40720,1547,19,1749,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',416000.00,NULL,NULL,1,'2022-06-20 18:07:36','2022-06-20 18:07:36',NULL),(1750,2973,40720,1547,19,1750,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',6083.88,NULL,NULL,1,'2022-06-20 18:07:36','2022-06-20 18:07:36',NULL),(1751,2973,40720,1547,19,1751,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',65582.00,NULL,NULL,1,'2022-06-20 18:07:36','2022-06-20 18:07:36',NULL),(1752,2973,40720,1547,19,1752,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',95590.00,NULL,NULL,1,'2022-06-20 18:07:36','2022-06-20 18:07:36',NULL),(1753,2973,40720,1547,19,1753,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',302218.09,NULL,NULL,1,'2022-06-20 18:07:36','2022-06-20 18:07:36',NULL),(1754,2973,40720,1547,19,1754,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',99081.64,NULL,NULL,1,'2022-06-20 18:07:36','2022-06-20 18:07:36',NULL),(1755,2973,40720,1547,19,1755,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',38279.95,NULL,NULL,1,'2022-06-20 18:07:36','2022-06-20 18:07:36',NULL),(1756,2973,40720,1547,19,1756,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',38279.95,NULL,NULL,1,'2022-06-20 18:07:36','2022-06-20 20:49:06','2022-06-20 20:49:06'),(1757,2973,40720,1547,19,1757,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',200622.33,NULL,NULL,1,'2022-06-20 18:07:36','2022-06-20 18:07:37',NULL),(1758,2973,40720,1547,19,1758,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',3872391.52,NULL,NULL,1,'2022-06-20 18:07:37','2022-06-20 20:50:20','2022-06-20 20:50:20'),(1759,2973,40720,1548,19,1759,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',4670.30,NULL,NULL,1,'2022-06-20 18:07:37','2022-06-20 18:07:37',NULL),(1760,2973,40720,1548,19,1760,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',1583.05,NULL,NULL,1,'2022-06-20 18:07:37','2022-06-20 18:07:37',NULL),(1761,2973,40720,1548,19,1761,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',2072.13,NULL,NULL,1,'2022-06-20 18:07:37','2022-06-20 18:07:37',NULL),(1762,2973,40720,1548,19,1762,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',3243.25,NULL,NULL,1,'2022-06-20 18:07:37','2022-06-20 18:07:37',NULL),(1763,2973,40720,1548,19,1763,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',35510.45,NULL,NULL,1,'2022-06-20 18:07:37','2022-06-20 18:07:37',NULL),(1764,2973,40720,1548,19,1764,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',15000.00,NULL,NULL,1,'2022-06-20 18:07:37','2022-06-20 18:07:37',NULL),(1765,2973,40720,1548,19,1765,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',69962.20,NULL,NULL,1,'2022-06-20 18:07:37','2022-06-20 18:07:37',NULL);
INSERT INTO `balance_libro` VALUES (1766,2973,40720,1548,19,1766,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',26620.00,NULL,NULL,1,'2022-06-20 18:07:37','2022-06-20 18:07:37',NULL),(1767,2973,40720,1548,19,1767,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',35204.95,NULL,NULL,1,'2022-06-20 18:07:37','2022-06-20 18:07:37',NULL),(1768,2973,40720,1548,19,1768,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',1522763.40,NULL,NULL,1,'2022-06-20 18:07:37','2022-06-20 18:07:37',NULL),(1769,2973,40720,1548,19,1769,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',965888.01,NULL,NULL,1,'2022-06-20 18:07:37','2022-06-20 18:07:37',NULL),(1770,2973,40720,1548,19,1770,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',2647.60,NULL,NULL,1,'2022-06-20 18:07:37','2022-06-20 18:07:37',NULL),(1771,2973,40720,1548,19,1771,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',5256.19,NULL,NULL,1,'2022-06-20 18:07:37','2022-06-20 18:07:37',NULL),(1772,2973,40720,1548,19,1772,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',6000.00,NULL,NULL,1,'2022-06-20 18:07:37','2022-06-20 18:07:37',NULL),(1773,2973,40720,1548,19,1773,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',799.74,NULL,NULL,1,'2022-06-20 18:07:37','2022-06-20 18:07:37',NULL),(1774,2973,40720,1548,19,1774,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',1704.02,NULL,NULL,1,'2022-06-20 18:07:37','2022-06-20 18:07:37',NULL),(1775,2973,40720,1548,19,1775,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',618189.00,NULL,NULL,1,'2022-06-20 18:07:37','2022-06-20 18:07:37',NULL),(1776,2973,40720,1548,19,1776,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',39325.00,NULL,NULL,1,'2022-06-20 18:07:37','2022-06-20 18:07:37',NULL),(1777,2973,40720,1548,19,1777,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',1625.00,NULL,NULL,1,'2022-06-20 18:07:37','2022-06-20 18:07:37',NULL),(1778,2973,40720,1548,19,1778,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',77273.63,NULL,NULL,1,'2022-06-20 18:07:37','2022-06-20 18:07:37',NULL),(1779,2973,40720,1548,19,1779,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',8349.00,NULL,NULL,1,'2022-06-20 18:07:37','2022-06-20 18:07:37',NULL),(1780,2973,40720,1548,19,1780,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',470.00,NULL,NULL,1,'2022-06-20 18:07:37','2022-06-20 18:07:37',NULL),(1781,2973,40720,1548,19,1781,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',531159.15,NULL,NULL,1,'2022-06-20 18:07:37','2022-06-20 18:07:37',NULL),(1782,2973,40720,1548,19,1782,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',4899.86,NULL,NULL,1,'2022-06-20 18:07:37','2022-06-20 18:07:37',NULL),(1783,2973,40720,1548,19,1783,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',41745.00,NULL,NULL,1,'2022-06-20 18:07:37','2022-06-20 18:07:37',NULL),(1784,2973,40720,1548,19,1784,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',570035.91,NULL,NULL,1,'2022-06-20 18:07:37','2022-06-20 18:07:37',NULL),(1785,2973,40720,1548,19,1785,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',204875.49,NULL,NULL,1,'2022-06-20 18:07:37','2022-06-20 18:07:37',NULL);
INSERT INTO `balance_libro` VALUES (1786,2973,40720,1548,19,1786,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',133788.11,NULL,NULL,1,'2022-06-20 18:07:37','2022-06-20 18:07:37',NULL),(1787,2973,40720,1548,19,1787,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',133788.11,NULL,NULL,1,'2022-06-20 18:07:37','2022-06-20 20:50:48','2022-06-20 20:50:48'),(1788,2973,40720,1548,19,1788,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',15000.00,NULL,NULL,1,'2022-06-20 18:07:37','2022-06-20 18:07:37',NULL),(1789,2973,40720,1548,19,1789,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',6050237.71,NULL,NULL,1,'2022-06-20 18:07:37','2022-06-20 20:51:58','2022-06-20 20:51:58'),(1790,2973,40720,1549,19,1790,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',3500.00,NULL,NULL,1,'2022-06-20 18:07:37','2022-06-20 18:07:37',NULL),(1791,2973,40720,1549,19,1791,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',8938.88,NULL,NULL,1,'2022-06-20 18:07:37','2022-06-20 18:07:37',NULL),(1792,2973,40720,1549,19,1792,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',65551.75,NULL,NULL,1,'2022-06-20 18:07:37','2022-06-20 18:07:38',NULL),(1793,2973,40720,1549,19,1793,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',422700.00,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 18:07:38',NULL),(1794,2973,40720,1549,19,1794,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',35204.95,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 18:07:38',NULL),(1795,2973,40720,1549,19,1795,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',8200.00,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 18:07:38',NULL),(1796,2973,40720,1549,19,1796,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',1524.49,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 18:07:38',NULL),(1797,2973,40720,1549,19,1797,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',7561.07,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 18:07:38',NULL),(1798,2973,40720,1549,19,1798,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',1260.00,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 18:07:38',NULL),(1799,2973,40720,1549,19,1799,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',25000.00,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 18:07:38',NULL),(1800,2973,40720,1549,19,1800,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',831.47,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 18:07:38',NULL),(1801,2973,40720,1549,19,1801,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',58200.00,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 18:07:38',NULL),(1802,2973,40720,1549,19,1802,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',462.35,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 18:07:38',NULL),(1803,2973,40720,1549,19,1803,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',253.12,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 18:07:38',NULL),(1804,2973,40720,1549,19,1804,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',14000.00,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 18:07:38',NULL),(1805,2973,40720,1549,19,1805,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',5733.81,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 18:07:38',NULL);
INSERT INTO `balance_libro` VALUES (1806,2973,40720,1549,19,1806,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',16.96,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 18:07:38',NULL),(1807,2973,40720,1549,19,1807,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',409.70,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 18:07:38',NULL),(1808,2973,40720,1549,19,1808,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',107197.76,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 18:07:38',NULL),(1809,2973,40720,1549,19,1809,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',122395.13,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 18:07:38',NULL),(1810,2973,40720,1549,19,1810,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',2231200.01,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 18:07:38',NULL),(1811,2973,40720,1549,19,1811,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',159531.53,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 18:07:38',NULL),(1812,2973,40720,1549,19,1812,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',21701.81,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 18:07:38',NULL),(1813,2973,40720,1549,19,1813,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',71211.52,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 18:07:38',NULL),(1814,2973,40720,1549,19,1814,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',8650.70,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 18:07:38',NULL),(1815,2973,40720,1549,19,1815,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',8650.70,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 20:52:36','2022-06-20 20:52:36'),(1816,2973,40720,1549,19,1816,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',29760.00,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 18:07:38',NULL),(1817,2973,40720,1549,19,1817,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',304.50,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 18:07:38',NULL),(1818,2973,40720,1549,19,1818,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',1785818.95,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 20:53:51','2022-06-20 20:53:51'),(1819,2973,40720,1550,19,1819,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',35204.95,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 18:07:38',NULL),(1820,2973,40720,1550,19,1820,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',132767.25,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 18:07:38',NULL),(1821,2973,40720,1550,19,1821,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',327.57,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 18:07:38',NULL),(1822,2973,40720,1550,19,1822,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',922.47,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 18:07:38',NULL),(1823,2973,40720,1550,19,1823,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',200000.00,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 18:07:38',NULL),(1824,2973,40720,1550,19,1824,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',790.00,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 18:07:38',NULL),(1825,2973,40720,1550,19,1825,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',200000.00,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 18:07:38',NULL);
INSERT INTO `balance_libro` VALUES (1826,2973,40720,1550,19,1826,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',5636.14,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 18:07:38',NULL),(1827,2973,40720,1550,19,1827,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',69575.00,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 18:07:38',NULL),(1828,2973,40720,1550,19,1828,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',20000.00,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 18:07:38',NULL),(1829,2973,40720,1550,19,1829,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',1742.53,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 18:07:38',NULL),(1830,2973,40720,1550,19,1830,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-20','2021-06-20',687.27,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 18:07:39',NULL),(1831,2973,40720,1550,19,1831,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',81190.03,NULL,NULL,1,'2022-06-20 18:07:38','2022-06-20 18:07:39',NULL),(1832,2973,40720,1550,19,1832,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',50820.00,NULL,NULL,1,'2022-06-20 18:07:39','2022-06-20 18:07:39',NULL),(1833,2973,40720,1550,19,1833,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',5405.98,NULL,NULL,1,'2022-06-20 18:07:39','2022-06-20 18:07:39',NULL),(1834,2973,40720,1550,19,1834,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',358282.45,NULL,NULL,1,'2022-06-20 18:07:39','2022-06-20 18:07:39',NULL),(1835,2973,40720,1550,19,1835,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',594650.00,NULL,NULL,1,'2022-06-20 18:07:39','2022-06-20 18:07:39',NULL),(1836,2973,40720,1550,19,1836,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',69575.00,NULL,NULL,1,'2022-06-20 18:07:39','2022-06-20 18:07:39',NULL),(1837,2973,40720,1550,19,1837,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',1690.00,NULL,NULL,1,'2022-06-20 18:07:39','2022-06-20 18:07:39',NULL),(1838,2973,40720,1550,19,1838,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',17167.54,NULL,NULL,1,'2022-06-20 18:07:39','2022-06-20 18:07:39',NULL),(1839,2973,40720,1550,19,1839,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',138320.97,NULL,NULL,1,'2022-06-20 18:07:39','2022-06-20 18:07:39',NULL),(1840,2973,40720,1550,19,1840,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',139744.93,NULL,NULL,1,'2022-06-20 18:07:39','2022-06-20 18:07:39',NULL),(1841,2973,40720,1550,19,1841,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',3010.00,NULL,NULL,1,'2022-06-20 18:07:39','2022-06-20 18:07:39',NULL),(1842,2973,40720,1550,19,1842,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',31775.89,NULL,NULL,1,'2022-06-20 18:07:39','2022-06-20 18:07:39',NULL),(1843,2973,40720,1550,19,1843,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',2110000.00,NULL,NULL,1,'2022-06-20 18:07:39','2022-06-20 18:07:39',NULL),(1844,2973,40720,1550,19,1844,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',31775.89,NULL,NULL,1,'2022-06-20 18:07:39','2022-06-20 20:54:35','2022-06-20 20:54:35'),(1845,2973,40720,1550,19,1845,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',28063.52,NULL,NULL,1,'2022-06-20 18:07:39','2022-06-20 18:07:39',NULL);
INSERT INTO `balance_libro` VALUES (1846,2973,40720,1550,19,1846,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',1814934.13,NULL,NULL,1,'2022-06-20 18:07:39','2022-06-20 20:55:25','2022-06-20 20:55:25'),(1847,2973,40720,1551,19,1847,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',64610.97,NULL,NULL,1,'2022-06-20 18:07:39','2022-06-20 18:07:39',NULL),(1848,2973,40720,1551,19,1848,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',1299.00,NULL,NULL,1,'2022-06-20 18:07:39','2022-06-20 18:07:39',NULL),(1849,2973,40720,1551,19,1849,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',30689.98,NULL,NULL,1,'2022-06-20 18:07:39','2022-06-20 18:07:39',NULL),(1850,2973,40720,1551,19,1850,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',40486.60,NULL,NULL,1,'2022-06-20 18:07:39','2022-06-20 18:07:39',NULL),(1851,2973,40720,1551,19,1851,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',5317.11,NULL,NULL,1,'2022-06-20 18:07:39','2022-06-20 18:07:39',NULL),(1852,2973,40720,1551,19,1852,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',2141.28,NULL,NULL,1,'2022-06-20 18:07:39','2022-06-20 18:07:39',NULL),(1853,2973,40720,1551,19,1853,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1078.45,NULL,NULL,1,'2022-06-20 18:07:39','2022-06-20 18:07:39',NULL),(1854,2973,40720,1551,19,1854,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',20000.00,NULL,NULL,1,'2022-06-20 18:07:39','2022-06-20 18:07:39',NULL),(1855,2973,40720,1551,19,1855,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',570817.50,NULL,NULL,1,'2022-06-20 18:07:39','2022-06-20 18:07:39',NULL),(1856,2973,40720,1551,19,1856,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',658.45,NULL,NULL,1,'2022-06-20 18:07:39','2022-06-20 18:07:39',NULL),(1857,2973,40720,1551,19,1857,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',269.86,NULL,NULL,1,'2022-06-20 18:07:39','2022-06-20 18:07:39',NULL),(1858,2973,40720,1551,19,1858,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',1968.41,NULL,NULL,1,'2022-06-20 18:07:39','2022-06-20 18:07:39',NULL),(1859,2973,40720,1551,19,1859,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',81030.31,NULL,NULL,1,'2022-06-20 18:07:39','2022-06-20 18:07:39',NULL),(1860,2973,40720,1551,19,1860,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',721.64,NULL,NULL,1,'2022-06-20 18:07:39','2022-06-20 18:07:39',NULL),(1861,2973,40720,1551,19,1861,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',239489.25,NULL,NULL,1,'2022-06-20 18:07:39','2022-06-20 18:07:40',NULL),(1862,2973,40720,1551,19,1862,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',8552.85,NULL,NULL,1,'2022-06-20 18:07:40','2022-06-20 18:07:40',NULL),(1863,2973,40720,1551,19,1863,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',1950.01,NULL,NULL,1,'2022-06-20 18:07:40','2022-06-20 18:07:40',NULL),(1864,2973,40720,1551,19,1864,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',5629.27,NULL,NULL,1,'2022-06-20 18:07:40','2022-06-20 18:07:40',NULL),(1865,2973,40720,1551,19,1865,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',20214.74,NULL,NULL,1,'2022-06-20 18:07:40','2022-06-20 18:07:40',NULL);
INSERT INTO `balance_libro` VALUES (1866,2973,40720,1551,19,1866,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',424400.00,NULL,NULL,1,'2022-06-20 18:07:40','2022-06-20 18:07:40',NULL),(1867,2973,40720,1551,19,1867,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',424400.00,NULL,NULL,1,'2022-06-20 18:07:40','2022-06-20 18:07:40',NULL),(1868,2973,40720,1551,19,1868,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',4235.00,NULL,NULL,1,'2022-06-20 18:07:40','2022-06-20 18:07:40',NULL),(1869,2973,40720,1551,19,1869,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',888215.62,NULL,NULL,1,'2022-06-20 18:07:40','2022-06-20 18:07:40',NULL),(1870,2973,40720,1551,19,1870,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',4010.18,NULL,NULL,1,'2022-06-20 18:07:40','2022-06-20 18:07:40',NULL),(1871,2973,40720,1551,19,1871,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',86394.00,NULL,NULL,1,'2022-06-20 18:07:40','2022-06-20 18:07:40',NULL),(1872,2973,40720,1551,19,1872,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',3570.00,NULL,NULL,1,'2022-06-20 18:07:40','2022-06-20 18:07:40',NULL),(1873,2973,40720,1551,19,1873,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',320992.34,NULL,NULL,1,'2022-06-20 18:07:40','2022-06-20 18:07:40',NULL),(1874,2973,40720,1551,19,1874,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',266872.33,NULL,NULL,1,'2022-06-20 18:07:40','2022-06-20 18:07:40',NULL),(1875,2973,40720,1551,19,1875,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',243.08,NULL,NULL,1,'2022-06-20 18:07:40','2022-06-20 18:07:40',NULL),(1876,2973,40720,1551,19,1876,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',115741.85,NULL,NULL,1,'2022-06-20 18:07:40','2022-06-20 18:07:40',NULL),(1877,2973,40720,1551,19,1877,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',115741.85,NULL,NULL,1,'2022-06-20 18:07:40','2022-06-20 20:56:11','2022-06-20 20:56:11'),(1878,2973,40720,1551,19,1878,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',27484.01,NULL,NULL,1,'2022-06-20 18:07:40','2022-06-20 18:07:40',NULL),(1879,2973,40720,1551,19,1879,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',426.30,NULL,NULL,1,'2022-06-20 18:07:40','2022-06-20 18:07:40',NULL),(1880,2973,40720,1551,19,1880,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',3263231.81,NULL,NULL,1,'2022-06-20 18:07:40','2022-06-20 20:57:19','2022-06-20 20:57:19'),(1881,2973,40720,1552,19,1881,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',4920.00,NULL,NULL,1,'2022-06-20 18:07:40','2022-06-20 18:07:40',NULL),(1882,2973,40720,1552,19,1882,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',48599.35,NULL,NULL,1,'2022-06-20 18:07:40','2022-06-20 18:07:40',NULL),(1883,2973,40720,1552,19,1883,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',1255.57,NULL,NULL,1,'2022-06-20 18:07:40','2022-06-20 18:07:40',NULL),(1884,2973,40720,1552,19,1884,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',400.36,NULL,NULL,1,'2022-06-20 18:07:40','2022-06-20 18:07:40',NULL),(1885,2973,40720,1552,19,1885,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',2042.81,NULL,NULL,1,'2022-06-20 18:07:40','2022-06-20 18:07:40',NULL);
INSERT INTO `balance_libro` VALUES (1886,2973,40720,1552,19,1886,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',3000.00,NULL,NULL,1,'2022-06-20 18:07:40','2022-06-20 18:07:40',NULL),(1887,2973,40720,1552,19,1887,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-05','2021-08-05',6218.57,NULL,NULL,1,'2022-06-20 18:07:40','2022-06-20 18:07:40',NULL),(1888,2973,40720,1552,19,1888,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-09','2021-08-09',3999.00,NULL,NULL,1,'2022-06-20 18:07:40','2022-06-20 18:07:40',NULL),(1889,2973,40720,1552,19,1889,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-09','2021-08-09',9680.00,NULL,NULL,1,'2022-06-20 18:07:40','2022-06-20 18:07:40',NULL),(1890,2973,40720,1552,19,1890,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',40486.60,NULL,NULL,1,'2022-06-20 18:07:40','2022-06-20 18:07:40',NULL),(1891,2973,40720,1552,19,1891,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',5316.54,NULL,NULL,1,'2022-06-20 18:07:40','2022-06-20 18:07:40',NULL),(1892,2973,40720,1552,19,1892,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',20000.00,NULL,NULL,1,'2022-06-20 18:07:40','2022-06-20 18:07:40',NULL),(1893,2973,40720,1552,19,1893,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',272.00,NULL,NULL,1,'2022-06-20 18:07:40','2022-06-20 18:07:41',NULL),(1894,2973,40720,1552,19,1894,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',307.62,NULL,NULL,1,'2022-06-20 18:07:41','2022-06-20 18:07:41',NULL),(1895,2973,40720,1552,19,1895,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',1129.99,NULL,NULL,1,'2022-06-20 18:07:41','2022-06-20 18:07:41',NULL),(1896,2973,40720,1552,19,1896,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',493680.00,NULL,NULL,1,'2022-06-20 18:07:41','2022-06-20 18:07:41',NULL),(1897,2973,40720,1552,19,1897,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',372934.10,NULL,NULL,1,'2022-06-20 18:07:41','2022-06-20 18:07:41',NULL),(1898,2973,40720,1552,19,1898,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',1871.30,NULL,NULL,1,'2022-06-20 18:07:41','2022-06-20 18:07:41',NULL),(1899,2973,40720,1552,19,1899,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',1006.96,NULL,NULL,1,'2022-06-20 18:07:41','2022-06-20 18:07:41',NULL),(1900,2973,40720,1552,19,1900,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',177.00,NULL,NULL,1,'2022-06-20 18:07:41','2022-06-20 18:07:41',NULL),(1901,2973,40720,1552,19,1901,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',113960.00,NULL,NULL,1,'2022-06-20 18:07:41','2022-06-20 18:07:41',NULL),(1902,2973,40720,1552,19,1902,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',200000.00,NULL,NULL,1,'2022-06-20 18:07:41','2022-06-20 18:07:41',NULL),(1903,2973,40720,1552,19,1903,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',200000.00,NULL,NULL,1,'2022-06-20 18:07:41','2022-06-20 18:07:41',NULL),(1904,2973,40720,1552,19,1904,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',178753.30,NULL,NULL,1,'2022-06-20 18:07:41','2022-06-20 18:07:41',NULL),(1905,2973,40720,1552,19,1905,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',1065491.94,NULL,NULL,1,'2022-06-20 18:07:41','2022-06-20 18:07:41',NULL);
INSERT INTO `balance_libro` VALUES (1906,2973,40720,1552,19,1906,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',178827.98,NULL,NULL,1,'2022-06-20 18:07:41','2022-06-20 18:07:41',NULL),(1907,2973,40720,1552,19,1907,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',233200.53,NULL,NULL,1,'2022-06-20 18:07:41','2022-06-20 18:07:41',NULL),(1908,2973,40720,1552,19,1908,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',840.22,NULL,NULL,1,'2022-06-20 18:07:41','2022-06-20 18:07:41',NULL),(1909,2973,40720,1552,19,1909,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',508.20,NULL,NULL,1,'2022-06-20 18:07:41','2022-06-20 18:07:41',NULL),(1910,2973,40720,1552,19,1910,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',234316.50,NULL,NULL,1,'2022-06-20 18:07:41','2022-06-20 18:07:41',NULL),(1911,2973,40720,1552,19,1911,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',332.47,NULL,NULL,1,'2022-06-20 18:07:41','2022-06-20 18:07:41',NULL),(1912,2973,40720,1552,19,1912,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',33301.56,NULL,NULL,1,'2022-06-20 18:07:41','2022-06-20 18:07:41',NULL),(1913,2973,40720,1552,19,1913,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',33301.56,NULL,NULL,1,'2022-06-20 18:07:41','2022-06-20 20:57:53','2022-06-20 20:57:53'),(1914,2973,40720,1552,19,1914,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',77040.31,NULL,NULL,1,'2022-06-20 18:07:41','2022-06-20 18:07:41',NULL),(1915,2973,40720,1552,19,1915,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',2116701.48,NULL,NULL,1,'2022-06-20 18:07:41','2022-06-20 20:58:42','2022-06-20 20:58:42'),(1916,2973,40720,1553,19,1916,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',40486.60,NULL,NULL,1,'2022-06-20 18:07:41','2022-06-20 18:07:41',NULL),(1917,2973,40720,1553,19,1917,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',1680.00,NULL,NULL,1,'2022-06-20 18:07:41','2022-06-20 18:07:41',NULL),(1918,2973,40720,1553,19,1918,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',5527.19,NULL,NULL,1,'2022-06-20 18:07:41','2022-06-20 18:07:42',NULL),(1919,2973,40720,1553,19,1919,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',85126.53,NULL,NULL,1,'2022-06-20 18:07:42','2022-06-20 18:07:42',NULL),(1920,2973,40720,1553,19,1920,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',195000.00,NULL,NULL,1,'2022-06-20 18:07:42','2022-06-20 18:07:42',NULL),(1921,2973,40720,1553,19,1921,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',193731.81,NULL,NULL,1,'2022-06-20 18:07:42','2022-06-20 18:07:42',NULL),(1922,2973,40720,1553,19,1922,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',700.33,NULL,NULL,1,'2022-06-20 18:07:42','2022-06-20 18:07:42',NULL),(1923,2973,40720,1553,19,1923,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',5480.60,NULL,NULL,1,'2022-06-20 18:07:42','2022-06-20 18:07:42',NULL),(1924,2973,40720,1553,19,1924,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',9845.77,NULL,NULL,1,'2022-06-20 18:07:42','2022-06-20 18:07:42',NULL),(1925,2973,40720,1553,19,1925,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',1000.00,NULL,NULL,1,'2022-06-20 18:07:42','2022-06-20 18:07:42',NULL);
INSERT INTO `balance_libro` VALUES (1926,2973,40720,1553,19,1926,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',5692.23,NULL,NULL,1,'2022-06-20 18:07:42','2022-06-20 18:07:42',NULL),(1927,2973,40720,1553,19,1927,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',134616.01,NULL,NULL,1,'2022-06-20 18:07:42','2022-06-20 18:07:42',NULL),(1928,2973,40720,1553,19,1928,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',134616.01,NULL,NULL,1,'2022-06-20 18:07:42','2022-06-20 18:07:42',NULL),(1929,2973,40720,1553,19,1929,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',138690.20,NULL,NULL,1,'2022-06-20 18:07:42','2022-06-20 18:07:42',NULL),(1930,2973,40720,1553,19,1930,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',103693.98,NULL,NULL,1,'2022-06-20 18:07:42','2022-06-20 18:07:42',NULL),(1931,2973,40720,1553,19,1931,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',20000.00,NULL,NULL,1,'2022-06-20 18:07:42','2022-06-20 18:07:42',NULL),(1932,2973,40720,1553,19,1932,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',499730.00,NULL,NULL,1,'2022-06-20 18:07:42','2022-06-20 18:07:42',NULL),(1933,2973,40720,1553,19,1933,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',327200.00,NULL,NULL,1,'2022-06-20 18:07:42','2022-06-20 18:07:42',NULL),(1934,2973,40720,1553,19,1934,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',34485.00,NULL,NULL,1,'2022-06-20 18:07:42','2022-06-20 18:07:42',NULL),(1935,2973,40720,1553,19,1935,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-18','2021-09-18',273.55,NULL,NULL,1,'2022-06-20 18:07:42','2022-06-20 18:07:42',NULL),(1936,2973,40720,1553,19,1936,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-18','2021-09-18',1695.14,NULL,NULL,1,'2022-06-20 18:07:42','2022-06-20 18:07:42',NULL),(1937,2973,40720,1553,19,1937,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',5120.43,NULL,NULL,1,'2022-06-20 18:07:42','2022-06-20 18:07:42',NULL),(1938,2973,40720,1553,19,1938,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',986.13,NULL,NULL,1,'2022-06-20 18:07:42','2022-06-20 18:07:42',NULL),(1939,2973,40720,1553,19,1939,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',177.00,NULL,NULL,1,'2022-06-20 18:07:42','2022-06-20 18:07:42',NULL),(1940,2973,40720,1553,19,1940,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',29501.31,NULL,NULL,1,'2022-06-20 18:07:42','2022-06-20 18:07:43',NULL),(1941,2973,40720,1553,19,1941,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',268.19,NULL,NULL,1,'2022-06-20 18:07:43','2022-06-20 18:07:43',NULL),(1942,2973,40720,1553,19,1942,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',22235.59,NULL,NULL,1,'2022-06-20 18:07:43','2022-06-20 18:07:43',NULL),(1943,2973,40720,1553,19,1943,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',514760.00,NULL,NULL,1,'2022-06-20 18:07:43','2022-06-20 18:07:43',NULL),(1944,2973,40720,1553,19,1944,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',258600.00,NULL,NULL,1,'2022-06-20 18:07:43','2022-06-20 18:07:43',NULL),(1945,2973,40720,1553,19,1945,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',40485.12,NULL,NULL,1,'2022-06-20 18:07:43','2022-06-20 18:07:43',NULL);
INSERT INTO `balance_libro` VALUES (1946,2973,40720,1553,19,1946,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',28052.64,NULL,NULL,1,'2022-06-20 18:07:43','2022-06-20 18:07:43',NULL),(1947,2973,40720,1553,19,1947,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',4489.67,NULL,NULL,1,'2022-06-20 18:07:43','2022-06-20 18:07:43',NULL),(1948,2973,40720,1553,19,1948,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',436929.49,NULL,NULL,1,'2022-06-20 18:07:43','2022-06-20 18:07:43',NULL),(1949,2973,40720,1553,19,1949,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',1380.00,NULL,NULL,1,'2022-06-20 18:07:43','2022-06-20 18:07:43',NULL),(1950,2973,40720,1553,19,1950,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',20207.00,NULL,NULL,1,'2022-06-20 18:07:43','2022-06-20 18:07:43',NULL),(1951,2973,40720,1553,19,1951,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',368258.00,NULL,NULL,1,'2022-06-20 18:07:43','2022-06-20 18:07:43',NULL),(1952,2973,40720,1553,19,1952,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',288474.22,NULL,NULL,1,'2022-06-20 18:07:43','2022-06-20 18:07:43',NULL),(1953,2973,40720,1553,19,1953,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',3690.00,NULL,NULL,1,'2022-06-20 18:07:43','2022-06-20 18:07:43',NULL),(1954,2973,40720,1553,19,1954,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',5043.03,NULL,NULL,1,'2022-06-20 18:07:43','2022-06-20 18:07:43',NULL),(1955,2973,40720,1553,19,1955,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',5199.00,NULL,NULL,1,'2022-06-20 18:07:43','2022-06-20 18:07:43',NULL),(1956,2973,40720,1553,19,1956,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',5467.79,NULL,NULL,1,'2022-06-20 18:07:43','2022-06-20 18:07:43',NULL),(1957,2973,40720,1553,19,1957,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',869.99,NULL,NULL,1,'2022-06-20 18:07:43','2022-06-20 18:07:43',NULL),(1958,2973,40720,1553,19,1958,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',83161.54,NULL,NULL,1,'2022-06-20 18:07:43','2022-06-20 18:07:43',NULL),(1959,2973,40720,1553,19,1959,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',83161.54,NULL,NULL,1,'2022-06-20 18:07:43','2022-06-20 20:59:12','2022-06-20 20:59:12'),(1960,2973,40720,1553,19,1960,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',37182.02,NULL,NULL,1,'2022-06-20 18:07:43','2022-06-20 18:07:43',NULL),(1961,2973,40720,1553,19,1961,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',60.90,NULL,NULL,1,'2022-06-20 18:07:43','2022-06-20 18:07:43',NULL),(1962,2973,40720,1553,19,1962,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',3993494.48,NULL,NULL,1,'2022-06-20 18:07:43','2022-06-20 21:00:08','2022-06-20 21:00:08'),(1963,2973,40720,1554,19,1963,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',253.12,NULL,NULL,1,'2022-06-20 18:07:43','2022-06-20 18:07:43',NULL),(1964,2973,40720,1554,19,1964,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-02','2021-10-02',500000.00,NULL,NULL,1,'2022-06-20 18:07:43','2022-06-20 18:07:43',NULL),(1965,2973,40720,1554,19,1965,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-02','2021-10-02',200000.00,NULL,NULL,1,'2022-06-20 18:07:43','2022-06-20 18:07:43',NULL);
INSERT INTO `balance_libro` VALUES (1966,2973,40720,1554,19,1966,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',40486.60,NULL,NULL,1,'2022-06-20 18:07:43','2022-06-20 18:07:43',NULL),(1967,2973,40720,1554,19,1967,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',2156.96,NULL,NULL,1,'2022-06-20 18:07:43','2022-06-20 18:07:43',NULL),(1968,2973,40720,1554,19,1968,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',40535.00,NULL,NULL,1,'2022-06-20 18:07:43','2022-06-20 18:07:43',NULL),(1969,2973,40720,1554,19,1969,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',69212.00,NULL,NULL,1,'2022-06-20 18:07:43','2022-06-20 18:07:43',NULL),(1970,2973,40720,1554,19,1970,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',9958.30,NULL,NULL,1,'2022-06-20 18:07:43','2022-06-20 18:07:43',NULL),(1971,2973,40720,1554,19,1971,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',7200.01,NULL,NULL,1,'2022-06-20 18:07:43','2022-06-20 18:07:43',NULL),(1972,2973,40720,1554,19,1972,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',326000.00,NULL,NULL,1,'2022-06-20 18:07:43','2022-06-20 18:07:43',NULL),(1973,2973,40720,1554,19,1973,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',501.00,NULL,NULL,1,'2022-06-20 18:07:43','2022-06-20 18:07:43',NULL),(1974,2973,40720,1554,19,1974,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',20000.00,NULL,NULL,1,'2022-06-20 18:07:43','2022-06-20 18:07:43',NULL),(1975,2973,40720,1554,19,1975,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',5600.00,NULL,NULL,1,'2022-06-20 18:07:43','2022-06-20 18:07:44',NULL),(1976,2973,40720,1554,19,1976,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',879.98,NULL,NULL,1,'2022-06-20 18:07:44','2022-06-20 18:07:44',NULL),(1977,2973,40720,1554,19,1977,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-17','2021-10-17',5882.19,NULL,NULL,1,'2022-06-20 18:07:44','2022-06-20 18:07:44',NULL),(1978,2973,40720,1554,19,1978,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',26.50,NULL,NULL,1,'2022-06-20 18:07:44','2022-06-20 18:07:44',NULL),(1979,2973,40720,1554,19,1979,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',115373.50,NULL,NULL,1,'2022-06-20 18:07:44','2022-06-20 18:07:44',NULL),(1980,2973,40720,1554,19,1980,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',224000.00,NULL,NULL,1,'2022-06-20 18:07:44','2022-06-20 18:07:44',NULL),(1981,2973,40720,1554,19,1981,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',211.80,NULL,NULL,1,'2022-06-20 18:07:44','2022-06-20 18:07:44',NULL),(1982,2973,40720,1554,19,1982,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',1627.41,NULL,NULL,1,'2022-06-20 18:07:44','2022-06-20 18:07:44',NULL),(1983,2973,40720,1554,19,1983,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',5056.23,NULL,NULL,1,'2022-06-20 18:07:44','2022-06-20 18:07:44',NULL),(1984,2973,40720,1554,19,1984,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',9002.40,NULL,NULL,1,'2022-06-20 18:07:44','2022-06-20 18:07:44',NULL),(1985,2973,40720,1554,19,1985,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',1069.44,NULL,NULL,1,'2022-06-20 18:07:44','2022-06-20 18:07:44',NULL);
INSERT INTO `balance_libro` VALUES (1986,2973,40720,1554,19,1986,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',2645.80,NULL,NULL,1,'2022-06-20 18:07:44','2022-06-20 18:07:44',NULL),(1987,2973,40720,1554,19,1987,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',73205.00,NULL,NULL,1,'2022-06-20 18:07:44','2022-06-20 18:07:44',NULL),(1988,2973,40720,1554,19,1988,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',172.50,NULL,NULL,1,'2022-06-20 18:07:44','2022-06-20 18:07:44',NULL),(1989,2973,40720,1554,19,1989,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',1716.00,NULL,NULL,1,'2022-06-20 18:07:44','2022-06-20 18:07:44',NULL),(1990,2973,40720,1554,19,1990,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',43929.05,NULL,NULL,1,'2022-06-20 18:07:44','2022-06-20 18:07:44',NULL),(1991,2973,40720,1554,19,1991,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',85.00,NULL,NULL,1,'2022-06-20 18:07:44','2022-06-20 18:07:44',NULL),(1992,2973,40720,1554,19,1992,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',85.00,NULL,NULL,1,'2022-06-20 18:07:44','2022-06-20 18:07:44',NULL),(1993,2973,40720,1554,19,1993,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',261700.00,NULL,NULL,1,'2022-06-20 18:07:44','2022-06-20 18:07:44',NULL),(1994,2973,40720,1554,19,1994,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',192649.05,NULL,NULL,1,'2022-06-20 18:07:44','2022-06-20 18:07:44',NULL),(1995,2973,40720,1554,19,1995,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',272805.45,NULL,NULL,1,'2022-06-20 18:07:44','2022-06-20 18:07:44',NULL),(1996,2973,40720,1554,19,1996,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',40159.78,NULL,NULL,1,'2022-06-20 18:07:44','2022-06-20 18:07:44',NULL),(1997,2973,40720,1554,19,1997,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',40159.78,NULL,NULL,1,'2022-06-20 18:07:44','2022-06-20 21:01:06','2022-06-20 21:01:06'),(1998,2973,40720,1554,19,1998,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',35934.37,NULL,NULL,1,'2022-06-20 18:07:44','2022-06-20 18:07:44',NULL),(1999,2973,40720,1554,19,1999,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',13248.32,NULL,NULL,1,'2022-06-20 18:07:44','2022-06-20 18:07:44',NULL),(2000,2973,40720,1554,19,2000,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',2526305.26,NULL,NULL,1,'2022-06-20 18:07:44','2022-06-20 21:02:35','2022-06-20 21:02:35'),(2001,2973,40720,1555,19,2001,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',40486.60,NULL,NULL,1,'2022-06-20 18:07:45','2022-06-20 18:07:45',NULL),(2002,2973,40720,1555,19,2002,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',25235.17,NULL,NULL,1,'2022-06-20 18:07:45','2022-06-20 18:07:45',NULL),(2003,2973,40720,1555,19,2003,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',421.06,NULL,NULL,1,'2022-06-20 18:07:45','2022-06-20 18:07:45',NULL),(2004,2973,40720,1555,19,2004,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',35783.25,NULL,NULL,1,'2022-06-20 18:07:45','2022-06-20 18:07:45',NULL),(2005,2973,40720,1555,19,2005,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',837.14,NULL,NULL,1,'2022-06-20 18:07:45','2022-06-20 18:07:45',NULL);
INSERT INTO `balance_libro` VALUES (2006,2973,40720,1555,19,2006,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',98.60,NULL,NULL,1,'2022-06-20 18:07:45','2022-06-20 18:07:45',NULL),(2007,2973,40720,1555,19,2007,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',1406.28,NULL,NULL,1,'2022-06-20 18:07:45','2022-06-20 18:07:45',NULL),(2008,2973,40720,1555,19,2008,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',248382.75,NULL,NULL,1,'2022-06-20 18:07:45','2022-06-20 18:07:45',NULL),(2009,2973,40720,1555,19,2009,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',398475.00,NULL,NULL,1,'2022-06-20 18:07:45','2022-06-20 18:07:45',NULL),(2010,2973,40720,1555,19,2010,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',2109.94,NULL,NULL,1,'2022-06-20 18:07:45','2022-06-20 18:07:45',NULL),(2011,2973,40720,1555,19,2011,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',5525.32,NULL,NULL,1,'2022-06-20 18:07:45','2022-06-20 18:07:45',NULL),(2012,2973,40720,1555,19,2012,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',93476.73,NULL,NULL,1,'2022-06-20 18:07:45','2022-06-20 18:07:45',NULL),(2013,2973,40720,1555,19,2013,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',564740.86,NULL,NULL,1,'2022-06-20 18:07:45','2022-06-20 18:07:45',NULL),(2014,2973,40720,1555,19,2014,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',490050.00,NULL,NULL,1,'2022-06-20 18:07:45','2022-06-20 18:07:45',NULL),(2015,2973,40720,1555,19,2015,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',30605.44,NULL,NULL,1,'2022-06-20 18:07:45','2022-06-20 18:07:45',NULL),(2016,2973,40720,1555,19,2016,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',2519.27,NULL,NULL,1,'2022-06-20 18:07:45','2022-06-20 18:07:45',NULL),(2017,2973,40720,1555,19,2017,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-16','2021-11-16',3544.66,NULL,NULL,1,'2022-06-20 18:07:45','2022-06-20 18:07:45',NULL),(2018,2973,40720,1555,19,2018,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-16','2021-11-16',26000.00,NULL,NULL,1,'2022-06-20 18:07:45','2022-06-20 18:07:45',NULL),(2019,2973,40720,1555,19,2019,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',7623.00,NULL,NULL,1,'2022-06-20 18:07:45','2022-06-20 18:07:45',NULL),(2020,2973,40720,1555,19,2020,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',22748.00,NULL,NULL,1,'2022-06-20 18:07:45','2022-06-20 18:07:46',NULL),(2021,2973,40720,1555,19,2021,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',175525.63,NULL,NULL,1,'2022-06-20 18:07:45','2022-06-20 18:07:46',NULL),(2022,2973,40720,1555,19,2022,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',2174.73,NULL,NULL,1,'2022-06-20 18:07:46','2022-06-20 18:07:46',NULL),(2023,2973,40720,1555,19,2023,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',7623.00,NULL,NULL,1,'2022-06-20 18:07:46','2022-06-20 18:07:46',NULL),(2024,2973,40720,1555,19,2024,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-20','2021-11-20',1288.12,NULL,NULL,1,'2022-06-20 18:07:46','2022-06-20 18:07:46',NULL),(2025,2973,40720,1555,19,2025,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-24','2021-11-24',209.25,NULL,NULL,1,'2022-06-20 18:07:46','2022-06-20 18:07:46',NULL);
INSERT INTO `balance_libro` VALUES (2026,2973,40720,1555,19,2026,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',5525.72,NULL,NULL,1,'2022-06-20 18:07:46','2022-06-20 18:07:46',NULL),(2027,2973,40720,1555,19,2027,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',5299.00,NULL,NULL,1,'2022-06-20 18:07:46','2022-06-20 18:07:46',NULL),(2028,2973,40720,1555,19,2028,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',345961.81,NULL,NULL,1,'2022-06-20 18:07:46','2022-06-20 18:07:46',NULL),(2029,2973,40720,1555,19,2029,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',329419.35,NULL,NULL,1,'2022-06-20 18:07:46','2022-06-20 18:07:46',NULL),(2030,2973,40720,1555,19,2030,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',253.12,NULL,NULL,1,'2022-06-20 18:07:46','2022-06-20 18:07:46',NULL),(2031,2973,40720,1555,19,2031,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',89173.88,NULL,NULL,1,'2022-06-20 18:07:46','2022-06-20 18:07:46',NULL),(2032,2973,40720,1555,19,2032,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',89173.88,NULL,NULL,1,'2022-06-20 18:07:46','2022-06-20 21:03:15','2022-06-20 21:03:15'),(2033,2973,40720,1555,19,2033,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',41031.94,NULL,NULL,1,'2022-06-20 18:07:46','2022-06-20 18:07:46',NULL),(2034,2973,40720,1555,19,2034,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',60.90,NULL,NULL,1,'2022-06-20 18:07:46','2022-06-20 18:07:46',NULL),(2035,2973,40720,1555,19,2035,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',3995261.11,NULL,NULL,1,'2022-06-20 18:07:46','2022-06-20 21:04:09','2022-06-20 21:04:09'),(2036,2973,40720,1556,19,2036,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-02','2021-12-02',10928.72,NULL,NULL,1,'2022-06-20 18:07:46','2022-06-20 18:07:46',NULL),(2037,2973,40720,1556,19,2037,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-02','2021-12-02',26000.00,NULL,NULL,1,'2022-06-20 18:07:46','2022-06-20 18:07:46',NULL),(2038,2973,40720,1556,19,2038,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-03','2021-12-03',1374.68,NULL,NULL,1,'2022-06-20 18:07:46','2022-06-20 18:07:46',NULL),(2039,2973,40720,1556,19,2039,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',40486.60,NULL,NULL,1,'2022-06-20 18:07:46','2022-06-20 18:07:46',NULL),(2040,2973,40720,1556,19,2040,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',3355.99,NULL,NULL,1,'2022-06-20 18:07:46','2022-06-20 18:07:46',NULL),(2041,2973,40720,1556,19,2041,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',280000.00,NULL,NULL,1,'2022-06-20 18:07:46','2022-06-20 18:07:46',NULL),(2042,2973,40720,1556,19,2042,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',311.25,NULL,NULL,1,'2022-06-20 18:07:46','2022-06-20 18:07:46',NULL),(2043,2973,40720,1556,19,2043,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-07','2021-12-07',77440.00,NULL,NULL,1,'2022-06-20 18:07:46','2022-06-20 18:07:46',NULL),(2044,2973,40720,1556,19,2044,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-10','2021-12-10',396082.91,NULL,NULL,1,'2022-06-20 18:07:46','2022-06-20 18:07:46',NULL),(2045,2973,40720,1556,19,2045,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-12','2021-12-12',5681.00,NULL,NULL,1,'2022-06-20 18:07:46','2022-06-20 18:07:46',NULL);
INSERT INTO `balance_libro` VALUES (2046,2973,40720,1556,19,2046,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-13','2021-12-13',5475.82,NULL,NULL,1,'2022-06-20 18:07:46','2022-06-20 18:07:46',NULL),(2047,2973,40720,1556,19,2047,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-13','2021-12-13',296600.00,NULL,NULL,1,'2022-06-20 18:07:46','2022-06-20 18:07:47',NULL),(2048,2973,40720,1556,19,2048,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',121000.00,NULL,NULL,1,'2022-06-20 18:07:47','2022-06-20 18:07:47',NULL),(2049,2973,40720,1556,19,2049,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',3829.99,NULL,NULL,1,'2022-06-20 18:07:47','2022-06-20 18:07:47',NULL),(2050,2973,40720,1556,19,2050,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',190500.00,NULL,NULL,1,'2022-06-20 18:07:47','2022-06-20 18:07:47',NULL),(2051,2973,40720,1556,19,2051,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-15','2021-12-15',4900.00,NULL,NULL,1,'2022-06-20 18:07:47','2022-06-20 18:07:47',NULL),(2052,2973,40720,1556,19,2052,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',5580.00,NULL,NULL,1,'2022-06-20 18:07:47','2022-06-20 18:07:47',NULL),(2053,2973,40720,1556,19,2053,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',8100.00,NULL,NULL,1,'2022-06-20 18:07:47','2022-06-20 18:07:47',NULL),(2054,2973,40720,1556,19,2054,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',21568.91,NULL,NULL,1,'2022-06-20 18:07:47','2022-06-20 18:07:47',NULL),(2055,2973,40720,1556,19,2055,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',1537.77,NULL,NULL,1,'2022-06-20 18:07:47','2022-06-20 18:07:47',NULL),(2056,2973,40720,1556,19,2056,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',65945.00,NULL,NULL,1,'2022-06-20 18:07:47','2022-06-20 18:07:47',NULL),(2057,2973,40720,1556,19,2057,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',182165.00,NULL,NULL,1,'2022-06-20 18:07:47','2022-06-20 18:07:47',NULL),(2058,2973,40720,1556,19,2058,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',14520.00,NULL,NULL,1,'2022-06-20 18:07:47','2022-06-20 18:07:47',NULL),(2059,2973,40720,1556,19,2059,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',151963.60,NULL,NULL,1,'2022-06-20 18:07:47','2022-06-20 18:07:47',NULL),(2060,2973,40720,1556,19,2060,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',14520.00,NULL,NULL,1,'2022-06-20 18:07:47','2022-06-20 18:07:47',NULL),(2061,2973,40720,1556,19,2061,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',1000.00,NULL,NULL,1,'2022-06-20 18:07:47','2022-06-20 18:07:47',NULL),(2062,2973,40720,1556,19,2062,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',6305.74,NULL,NULL,1,'2022-06-20 18:07:47','2022-06-20 18:07:47',NULL),(2063,2973,40720,1556,19,2063,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',1569.27,NULL,NULL,1,'2022-06-20 18:07:47','2022-06-20 18:07:47',NULL),(2064,2973,40720,1556,19,2064,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',1042233.50,NULL,NULL,1,'2022-06-20 18:07:47','2022-06-20 18:07:47',NULL),(2065,2973,40720,1556,19,2065,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-28','2021-12-28',9680.00,NULL,NULL,1,'2022-06-20 18:07:47','2022-06-20 18:07:47',NULL);
INSERT INTO `balance_libro` VALUES (2066,2973,40720,1556,19,2066,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',39.21,NULL,NULL,1,'2022-06-20 18:07:47','2022-06-20 18:07:47',NULL),(2067,2973,40720,1556,19,2067,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',0.12,NULL,NULL,1,'2022-06-20 18:07:47','2022-06-20 18:07:47',NULL),(2068,2973,40720,1556,19,2068,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',335445.62,NULL,NULL,1,'2022-06-20 18:07:47','2022-06-20 18:07:47',NULL),(2069,2973,40720,1556,19,2069,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',370516.97,NULL,NULL,1,'2022-06-20 18:07:47','2022-06-20 18:07:47',NULL),(2070,2973,40720,1556,19,2070,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',322580.14,NULL,NULL,1,'2022-06-20 18:07:47','2022-06-20 18:07:47',NULL),(2071,2973,40720,1556,19,2071,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',48826.88,NULL,NULL,1,'2022-06-20 18:07:47','2022-06-20 18:07:47',NULL),(2072,2973,40720,1556,19,2072,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',48826.88,NULL,NULL,1,'2022-06-20 18:07:47','2022-06-20 21:04:38','2022-06-20 21:04:38'),(2073,2973,40720,1556,19,2073,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',68126.98,NULL,NULL,1,'2022-06-20 18:07:47','2022-06-20 18:07:47',NULL),(2074,2973,40720,1556,19,2074,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',2462942.84,NULL,NULL,1,'2022-06-20 18:07:47','2022-06-20 18:07:47',NULL),(2075,2973,40720,1556,19,2075,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',2110000.00,NULL,NULL,1,'2022-06-20 18:07:47','2022-06-20 18:07:47',NULL),(2076,2973,40720,1556,19,2076,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',20226.03,NULL,NULL,1,'2022-06-20 18:07:47','2022-06-20 18:07:47',NULL),(2077,2973,40720,1556,19,2077,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',4893013.74,NULL,NULL,1,'2022-06-20 18:07:47','2022-06-20 21:05:47','2022-06-20 21:05:47'),(2078,2973,40720,1556,23,2078,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',4547462.50,'Ajuste por Inflacion Asiento Anual',NULL,1,'2022-06-20 20:03:58','2022-06-20 20:04:00',NULL),(2079,2973,40720,1545,19,2079,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-01','2021-01-01',5516625.09,NULL,NULL,1,'2022-06-20 20:44:05','2022-06-20 20:44:05',NULL),(2080,2973,40720,1545,19,2080,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',311696.00,NULL,NULL,1,'2022-06-20 20:45:02','2022-06-20 20:45:02',NULL),(2081,2973,40720,1545,19,2081,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',47091.92,NULL,NULL,1,'2022-06-20 20:45:37','2022-06-20 20:45:37',NULL),(2082,2973,40720,1545,19,2082,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',2325858.11,NULL,NULL,1,'2022-06-20 20:46:50','2022-06-20 20:46:50',NULL),(2083,2973,40720,1546,19,2083,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',80889.01,NULL,NULL,1,'2022-06-20 20:47:27','2022-06-20 20:47:27',NULL),(2084,2973,40720,1546,19,2084,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',4032561.86,NULL,NULL,1,'2022-06-20 20:48:36','2022-06-20 20:48:36',NULL),(2085,2973,40720,1547,19,2085,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',38279.95,NULL,NULL,1,'2022-06-20 20:49:06','2022-06-20 20:49:06',NULL);
INSERT INTO `balance_libro` VALUES (2086,2973,40720,1547,19,2086,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',3872391.52,NULL,NULL,1,'2022-06-20 20:50:20','2022-06-20 20:50:20',NULL),(2087,2973,40720,1548,19,2087,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',133788.11,NULL,NULL,1,'2022-06-20 20:50:48','2022-06-20 20:50:48',NULL),(2088,2973,40720,1548,19,2088,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',6050237.71,NULL,NULL,1,'2022-06-20 20:51:58','2022-06-20 20:51:58',NULL),(2089,2973,40720,1549,19,2089,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',8650.70,NULL,NULL,1,'2022-06-20 20:52:36','2022-06-20 20:52:36',NULL),(2090,2973,40720,1549,19,2090,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',1785818.95,NULL,NULL,1,'2022-06-20 20:53:51','2022-06-20 20:53:51',NULL),(2091,2973,40720,1550,19,2091,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',31775.89,NULL,NULL,1,'2022-06-20 20:54:35','2022-06-20 20:54:35',NULL),(2092,2973,40720,1550,19,2092,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',1814934.13,NULL,NULL,1,'2022-06-20 20:55:25','2022-06-20 20:55:25',NULL),(2093,2973,40720,1551,19,2093,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',115741.85,NULL,NULL,1,'2022-06-20 20:56:11','2022-06-20 20:56:11',NULL),(2094,2973,40720,1551,19,2094,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',3263231.81,NULL,NULL,1,'2022-06-20 20:57:19','2022-06-20 20:57:19',NULL),(2095,2973,40720,1552,19,2095,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',33301.56,NULL,NULL,1,'2022-06-20 20:57:53','2022-06-20 20:57:53',NULL),(2096,2973,40720,1552,19,2096,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',2116701.48,NULL,NULL,1,'2022-06-20 20:58:42','2022-06-20 20:58:42',NULL),(2097,2973,40720,1553,19,2097,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',83161.54,NULL,NULL,1,'2022-06-20 20:59:12','2022-06-20 20:59:12',NULL),(2098,2973,40720,1553,19,2098,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',3993494.48,NULL,NULL,1,'2022-06-20 21:00:08','2022-06-20 21:00:08',NULL),(2099,2973,40720,1554,19,2099,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',40159.78,NULL,NULL,1,'2022-06-20 21:01:06','2022-06-20 21:01:06',NULL),(2100,2973,40720,1554,19,2100,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',2526305.26,NULL,NULL,1,'2022-06-20 21:02:35','2022-06-20 21:02:35',NULL),(2101,2973,40720,1555,19,2101,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',89173.88,NULL,NULL,1,'2022-06-20 21:03:15','2022-06-20 21:03:15',NULL),(2102,2973,40720,1555,19,2102,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',3995261.11,NULL,NULL,1,'2022-06-20 21:04:09','2022-06-20 21:04:09',NULL),(2103,2973,40720,1556,19,2103,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',48826.88,NULL,NULL,1,'2022-06-20 21:04:38','2022-06-20 21:04:38',NULL),(2104,2973,40720,1556,19,2104,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',4893013.74,NULL,NULL,1,'2022-06-20 21:05:47','2022-06-20 21:22:38','2022-06-20 21:22:38'),(2105,2973,40720,1556,19,2105,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',4893013.74,NULL,NULL,1,'2022-06-20 21:22:38','2022-06-20 21:22:38',NULL);
INSERT INTO `balance_libro` VALUES (2106,2973,41363,4470,12,2106,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',50000.00,'Saldos Iniciales',NULL,1,'2022-09-08 11:05:18','2022-09-12 15:10:52','2022-09-12 15:10:52'),(2107,2973,41363,4470,19,2107,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',150000.00,'Integracion del Capital',NULL,1,'2022-09-08 11:07:46','2022-09-12 15:12:43','2022-09-12 15:12:43'),(2108,2973,41363,4470,12,2108,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',250000.00,'Saldos Iniciales',NULL,1,'2022-09-12 15:10:52','2022-09-29 15:58:59','2022-09-29 15:58:59'),(2109,2973,41363,4470,2,2109,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',50000.00,'Integracion del Capital',NULL,1,'2022-09-12 15:12:13','2022-09-29 15:59:43','2022-09-29 15:59:43'),(2110,2973,41363,4470,19,2110,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',150000.00,'Integracion del Capital',NULL,1,'2022-09-12 15:12:43','2022-09-12 15:13:53','2022-09-12 15:13:53'),(2111,2973,41363,4473,19,2111,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',150000.00,'Integracion del Capital',NULL,1,'2022-09-12 15:13:53','2022-09-21 16:09:59','2022-09-21 16:09:59'),(2112,2973,41363,4474,19,2112,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',60220.00,'Gastos de Organización',NULL,1,'2022-09-12 16:26:35','2022-10-11 11:31:21','2022-10-11 11:31:21'),(2113,2973,41363,4475,19,2113,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',20500.00,'Gastos de Organización',NULL,1,'2022-09-12 16:28:10','2022-09-12 16:28:10',NULL),(2114,2973,41363,6047,19,2114,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',16144.00,'Amortización Gastos de Org.',NULL,1,'2022-09-12 16:39:08','2022-09-29 17:09:10','2022-09-29 17:09:10'),(2115,2973,41363,4475,19,2115,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',150000.00,'Integracion del Capital',NULL,1,'2022-09-21 16:09:59','2022-09-21 16:19:32','2022-09-21 16:19:32'),(2116,2973,41363,4475,19,2116,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',200000.00,'Integracion del Capital',NULL,1,'2022-09-21 16:19:32','2022-09-29 15:59:21','2022-09-29 15:59:21'),(2117,2973,41363,4475,5,2117,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',780.00,'GASTOS BANCARIOS',NULL,1,'2022-09-23 15:52:00','2022-09-23 15:52:00',NULL),(2118,2973,41363,4470,12,2118,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',250000.00,'Saldos Iniciales',NULL,1,'2022-09-29 15:58:59','2022-10-11 10:40:19','2022-10-11 10:40:19'),(2119,2973,41363,4475,19,2119,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',200000.00,'Integracion del Capital',NULL,1,'2022-09-29 15:59:21','2022-10-11 10:44:14','2022-10-11 10:44:14'),(2120,2973,41363,4470,2,2120,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',50000.00,'Integracion del Capital',NULL,1,'2022-09-29 15:59:43','2022-09-29 15:59:43',NULL),(2121,2973,41363,6047,23,2121,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',110582.75,'Ajuste por Inflacion Asiento Anual',NULL,1,'2022-09-29 16:03:27','2022-10-11 10:41:52','2022-10-11 10:41:52'),(2122,2973,41363,6047,19,2122,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',20473.36,'Amortización Gastos de Org.',NULL,1,'2022-09-29 17:09:10','2022-10-11 11:42:02','2022-10-11 11:42:02');
INSERT INTO `balance_libro` VALUES (2123,2973,41363,4470,12,2123,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',200000.00,'Saldos Iniciales',NULL,1,'2022-10-11 10:40:19','2022-10-11 10:40:19',NULL),(2124,2973,41363,4475,19,2124,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',150000.00,'Integracion del Capital',NULL,1,'2022-10-11 10:44:14','2022-10-11 10:44:14',NULL),(2125,2973,41363,4474,19,2125,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',49500.00,'Gastos de Organización',NULL,1,'2022-10-11 11:31:21','2022-10-11 11:31:21',NULL),(2126,2973,41363,6047,19,2126,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',17730.74,'Amortización Gastos de Org.',NULL,1,'2022-10-11 11:42:02','2022-10-11 11:42:02',NULL),(2127,2973,41363,6047,23,2127,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',88466.20,'Ajuste por Inflacion Asiento Anual',NULL,1,'2022-10-11 11:43:14','2022-10-11 11:43:14',NULL),(2128,2973,40720,1556,17,2128,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',13386506.46,'CIERRE DE CUENTAS PATRIMONIALES',NULL,1,'2023-03-23 18:07:15','2023-06-02 15:16:31','2023-06-02 15:16:31'),(2129,2973,40720,1556,17,2129,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',21193760.04,'ASIENTO DE REFUNDICIÓN',NULL,1,'2023-03-25 09:56:29','2023-03-25 09:56:29',NULL),(2130,2973,40720,1556,19,2130,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',6234694.21,'RESULTADO NO ASIGNADO 2021',NULL,1,'2023-06-02 15:07:39','2023-06-02 15:07:39',NULL),(2131,2973,40720,1556,17,2131,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',13386506.46,'CIERRE DE CUENTAS PATRIMONIALES',NULL,1,'2023-06-02 15:16:31','2023-06-02 15:16:31',NULL);
/*!40000 ALTER TABLE `balance_libro` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro_details`
--

DROP TABLE IF EXISTS `balance_libro_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `balance_libro_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_details_person_id_foreign` (`person_id`),
  KEY `balance_libro_details_period_id_foreign` (`period_id`),
  KEY `balance_libro_details_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_details_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_libro_details_saldo_id_foreign` (`saldo_id`),
  KEY `balance_libro_details_balance_libro_id_foreign` (`balance_libro_id`),
  CONSTRAINT `balance_libro_details_balance_libro_id_foreign` FOREIGN KEY (`balance_libro_id`) REFERENCES `balance_libro` (`id`) ON DELETE CASCADE,
  CONSTRAINT `balance_libro_details_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_details_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `balance_libro_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7716 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro_details`
--

LOCK TABLES `balance_libro_details` WRITE;
/*!40000 ALTER TABLE `balance_libro_details` DISABLE KEYS */;
INSERT INTO `balance_libro_details` VALUES (1,2973,1,40720,1545,12,23,1,6086.98,NULL,'2021-08-09 12:29:01','2021-08-09 12:31:19','2021-08-09 12:31:19'),(2,2973,1,40720,1545,12,10,1,478863.03,NULL,'2021-08-09 12:29:01','2021-08-09 12:31:19','2021-08-09 12:31:19'),(3,2973,1,40720,1545,12,359,1,53811.45,NULL,'2021-08-09 12:29:01','2021-08-09 12:31:19','2021-08-09 12:31:19'),(4,2973,1,40720,1545,12,14,1,33807.40,NULL,'2021-08-09 12:29:01','2021-08-09 12:31:19','2021-08-09 12:31:19'),(5,2973,1,40720,1545,12,301,1,4819.18,NULL,'2021-08-09 12:29:01','2021-08-09 12:31:19','2021-08-09 12:31:19'),(6,2973,1,40720,1545,12,368,1,495000.00,NULL,'2021-08-09 12:29:01','2021-08-09 12:31:19','2021-08-09 12:31:19'),(7,2973,1,40720,1545,12,395,1,495000.00,NULL,'2021-08-09 12:29:01','2021-08-09 12:31:19','2021-08-09 12:31:19'),(8,2973,1,40720,1545,12,437,1,7193.66,NULL,'2021-08-09 12:29:01','2021-08-09 12:31:19','2021-08-09 12:31:19'),(9,2973,1,40720,1545,12,302,1,2445.32,NULL,'2021-08-09 12:29:01','2021-08-09 12:31:19','2021-08-09 12:31:19'),(10,2973,1,40720,1545,12,369,2,50000.00,NULL,'2021-08-09 12:29:01','2021-08-09 12:31:19','2021-08-09 12:31:19'),(11,2973,1,40720,1545,12,74,2,87351.60,NULL,'2021-08-09 12:29:01','2021-08-09 12:31:19','2021-08-09 12:31:19'),(12,2973,1,40720,1545,12,411,2,431902.63,NULL,'2021-08-09 12:29:01','2021-08-09 12:31:19','2021-08-09 12:31:19'),(13,2973,1,40720,1545,12,91,2,1007772.79,NULL,'2021-08-09 12:29:01','2021-08-09 12:31:19','2021-08-09 12:31:19'),(14,2973,2,40720,1545,19,23,1,6086.98,NULL,'2021-08-09 12:31:29','2021-08-09 12:31:50','2021-08-09 12:31:50'),(15,2973,2,40720,1545,19,10,1,478863.03,NULL,'2021-08-09 12:31:29','2021-08-09 12:31:50','2021-08-09 12:31:50'),(16,2973,2,40720,1545,19,359,1,53811.45,NULL,'2021-08-09 12:31:29','2021-08-09 12:31:50','2021-08-09 12:31:50'),(17,2973,2,40720,1545,19,14,1,33807.40,NULL,'2021-08-09 12:31:29','2021-08-09 12:31:50','2021-08-09 12:31:50'),(18,2973,2,40720,1545,19,301,1,4819.18,NULL,'2021-08-09 12:31:29','2021-08-09 12:31:50','2021-08-09 12:31:50'),(19,2973,2,40720,1545,19,368,1,495000.00,NULL,'2021-08-09 12:31:29','2021-08-09 12:31:50','2021-08-09 12:31:50'),(20,2973,2,40720,1545,19,395,1,495000.00,NULL,'2021-08-09 12:31:29','2021-08-09 12:31:50','2021-08-09 12:31:50'),(21,2973,2,40720,1545,19,437,1,7193.66,NULL,'2021-08-09 12:31:29','2021-08-09 12:31:50','2021-08-09 12:31:50'),(22,2973,2,40720,1545,19,302,1,2445.32,NULL,'2021-08-09 12:31:29','2021-08-09 12:31:50','2021-08-09 12:31:50'),(23,2973,2,40720,1545,19,369,2,50000.00,NULL,'2021-08-09 12:31:29','2021-08-09 12:31:50','2021-08-09 12:31:50'),(24,2973,2,40720,1545,19,74,2,87351.60,NULL,'2021-08-09 12:31:29','2021-08-09 12:31:50','2021-08-09 12:31:50'),(25,2973,2,40720,1545,19,411,2,431902.63,NULL,'2021-08-09 12:31:29','2021-08-09 12:31:50','2021-08-09 12:31:50'),(26,2973,2,40720,1545,19,91,2,1007772.79,NULL,'2021-08-09 12:31:29','2021-08-09 12:31:50','2021-08-09 12:31:50'),(27,2973,3,40720,1545,19,23,1,6086.98,NULL,'2021-08-09 12:31:50','2021-08-09 14:49:02','2021-08-09 14:49:02'),(28,2973,3,40720,1545,19,10,1,478863.03,NULL,'2021-08-09 12:31:50','2021-08-09 14:49:02','2021-08-09 14:49:02'),(29,2973,3,40720,1545,19,359,1,53811.45,NULL,'2021-08-09 12:31:50','2021-08-09 14:49:02','2021-08-09 14:49:02'),(30,2973,3,40720,1545,19,14,1,33807.40,NULL,'2021-08-09 12:31:50','2021-08-09 14:49:02','2021-08-09 14:49:02'),(31,2973,3,40720,1545,19,301,1,4819.18,NULL,'2021-08-09 12:31:50','2021-08-09 14:49:02','2021-08-09 14:49:02'),(32,2973,3,40720,1545,19,368,1,495000.00,NULL,'2021-08-09 12:31:50','2021-08-09 14:49:02','2021-08-09 14:49:02'),(33,2973,3,40720,1545,19,395,1,495000.00,NULL,'2021-08-09 12:31:50','2021-08-09 14:49:02','2021-08-09 14:49:02'),(34,2973,3,40720,1545,19,437,1,7193.66,NULL,'2021-08-09 12:31:50','2021-08-09 14:49:02','2021-08-09 14:49:02'),(35,2973,3,40720,1545,19,302,1,2445.32,NULL,'2021-08-09 12:31:50','2021-08-09 14:49:02','2021-08-09 14:49:02');
INSERT INTO `balance_libro_details` VALUES (36,2973,3,40720,1545,19,369,2,50000.00,NULL,'2021-08-09 12:31:50','2021-08-09 14:49:02','2021-08-09 14:49:02'),(37,2973,3,40720,1545,19,74,2,87351.60,NULL,'2021-08-09 12:31:50','2021-08-09 14:49:02','2021-08-09 14:49:02'),(38,2973,3,40720,1545,19,411,2,431902.63,NULL,'2021-08-09 12:31:50','2021-08-09 14:49:02','2021-08-09 14:49:02'),(39,2973,3,40720,1545,19,91,2,1007772.79,NULL,'2021-08-09 12:31:50','2021-08-09 14:49:02','2021-08-09 14:49:02'),(143,2973,34,40720,1530,19,23,1,6086.98,NULL,'2021-08-09 20:57:43','2021-08-24 17:39:11','2021-08-24 17:39:11'),(144,2973,34,40720,1530,19,10,1,478863.03,NULL,'2021-08-09 20:57:43','2021-08-24 17:39:11','2021-08-24 17:39:11'),(145,2973,34,40720,1530,19,359,1,53811.45,NULL,'2021-08-09 20:57:43','2021-08-24 17:39:11','2021-08-24 17:39:11'),(146,2973,34,40720,1530,19,13,1,33807.40,NULL,'2021-08-09 20:57:43','2021-08-24 17:39:11','2021-08-24 17:39:11'),(147,2973,34,40720,1530,19,301,1,4819.18,NULL,'2021-08-09 20:57:43','2021-08-24 17:39:11','2021-08-24 17:39:11'),(148,2973,34,40720,1530,19,368,1,495000.00,NULL,'2021-08-09 20:57:43','2021-08-24 17:39:11','2021-08-24 17:39:11'),(149,2973,34,40720,1530,19,395,1,495000.00,NULL,'2021-08-09 20:57:43','2021-08-24 17:39:11','2021-08-24 17:39:11'),(150,2973,34,40720,1530,19,487,1,7193.66,NULL,'2021-08-09 20:57:43','2021-08-24 17:39:11','2021-08-24 17:39:11'),(151,2973,34,40720,1530,19,302,1,2445.32,NULL,'2021-08-09 20:57:43','2021-08-24 17:39:11','2021-08-24 17:39:11'),(152,2973,34,40720,1530,19,369,2,50000.00,NULL,'2021-08-09 20:57:43','2021-08-24 17:39:11','2021-08-24 17:39:11'),(153,2973,34,40720,1530,19,74,2,87351.60,NULL,'2021-08-09 20:57:43','2021-08-24 17:39:11','2021-08-24 17:39:11'),(154,2973,34,40720,1530,19,411,2,431902.63,NULL,'2021-08-09 20:57:43','2021-08-24 17:39:11','2021-08-24 17:39:11'),(155,2973,34,40720,1530,19,91,2,1007772.79,NULL,'2021-08-09 20:57:43','2021-08-24 17:39:11','2021-08-24 17:39:11'),(156,2973,35,40720,1530,19,13,1,137214.00,NULL,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(157,2973,35,40720,1530,19,67,2,23814.00,NULL,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(158,2973,35,40720,1530,19,96,2,113400.00,NULL,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(159,2973,36,40720,1530,19,13,1,137214.00,NULL,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(160,2973,36,40720,1530,19,67,2,23814.00,NULL,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(161,2973,36,40720,1530,19,96,2,113400.00,NULL,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(162,2973,37,40720,1530,19,91,1,1007772.79,NULL,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(163,2973,37,40720,1530,19,383,2,1007772.79,NULL,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(164,2973,38,40720,1530,19,68,1,4620.00,NULL,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(165,2973,38,40720,1530,19,483,1,22000.00,NULL,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(166,2973,38,40720,1530,19,57,2,26620.00,NULL,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(167,2973,39,40720,1530,19,68,1,465.24,NULL,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(168,2973,39,40720,1530,19,484,1,2215.45,NULL,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(169,2973,39,40720,1530,19,57,2,2680.69,NULL,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(170,2973,40,40720,1530,19,13,1,13500.00,NULL,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(171,2973,40,40720,1530,19,67,2,2342.98,NULL,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(172,2973,40,40720,1530,19,96,2,11157.02,NULL,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(173,2973,41,40720,1530,19,251,1,1984.50,NULL,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(174,2973,41,40720,1530,19,13,2,1984.50,NULL,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(175,2973,42,40720,1530,19,23,1,924.60,NULL,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(176,2973,42,40720,1530,19,13,2,924.60,NULL,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL);
INSERT INTO `balance_libro_details` VALUES (177,2973,43,40720,1530,19,251,1,104.63,NULL,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(178,2973,43,40720,1530,19,25,1,62.05,NULL,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(179,2973,43,40720,1530,19,68,1,434.36,NULL,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(180,2973,43,40720,1530,19,128,1,2615.85,NULL,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(181,2973,43,40720,1530,19,57,2,3216.89,NULL,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(182,2973,44,40720,1530,19,68,1,2755.66,NULL,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(183,2973,44,40720,1530,19,391,1,26244.34,NULL,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(184,2973,44,40720,1530,19,57,2,29000.00,NULL,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(185,2973,45,40720,1530,19,57,1,29000.00,NULL,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(186,2973,45,40720,1530,19,359,2,29000.00,NULL,'2021-08-09 20:57:43','2021-08-09 20:57:43',NULL),(187,2973,46,40720,1530,19,192,1,10000.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(188,2973,46,40720,1530,19,57,2,10000.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(189,2973,47,40720,1530,19,13,1,224116.20,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(190,2973,47,40720,1530,19,67,2,38896.20,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(191,2973,47,40720,1530,19,96,2,185220.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(192,2973,48,40720,1530,19,13,1,34400.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(193,2973,48,40720,1530,19,67,2,5970.25,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(194,2973,48,40720,1530,19,96,2,28429.75,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(195,2973,49,40720,1530,19,251,1,114.93,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(196,2973,49,40720,1530,19,25,1,68.16,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(197,2973,49,40720,1530,19,68,1,477.09,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(198,2973,49,40720,1530,19,128,1,2873.22,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(199,2973,49,40720,1530,19,57,2,3533.40,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(200,2973,50,40720,1530,19,68,1,8561.66,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(201,2973,50,40720,1530,19,484,1,40769.82,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(202,2973,50,40720,1530,19,57,2,49331.48,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(203,2973,51,40720,1530,19,13,1,243650.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(204,2973,51,40720,1530,19,67,2,42286.36,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(205,2973,51,40720,1530,19,96,2,201363.64,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(206,2973,52,40720,1530,19,13,1,15246.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(207,2973,52,40720,1530,19,67,2,2646.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(208,2973,52,40720,1530,19,96,2,12600.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(209,2973,53,40720,1530,19,68,1,319.49,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(210,2973,53,40720,1530,19,484,1,1521.39,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(211,2973,53,40720,1530,19,57,2,1840.88,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(212,2973,54,40720,1530,19,251,1,3241.35,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(213,2973,54,40720,1530,19,25,1,19448.10,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(214,2973,54,40720,1530,19,13,2,22689.45,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(215,2973,55,40720,1530,19,68,1,188.40,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(216,2973,55,40720,1530,19,484,1,897.12,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(217,2973,55,40720,1530,19,57,2,1085.52,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL);
INSERT INTO `balance_libro_details` VALUES (218,2973,56,40720,1530,19,359,1,9680.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(219,2973,56,40720,1530,19,13,2,9680.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(220,2973,57,40720,1530,19,68,1,873.18,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(221,2973,57,40720,1530,19,484,1,4158.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(222,2973,57,40720,1530,19,57,2,5031.18,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(223,2973,58,40720,1530,19,13,1,9680.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(224,2973,58,40720,1530,19,67,2,1680.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(225,2973,58,40720,1530,19,96,2,8000.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(226,2973,59,40720,1530,19,57,1,5031.18,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(227,2973,59,40720,1530,19,359,2,5031.18,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(228,2973,60,40720,1530,19,251,1,116.68,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(229,2973,60,40720,1530,19,25,1,69.20,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(230,2973,60,40720,1530,19,68,1,484.37,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(231,2973,60,40720,1530,19,128,1,2917.02,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(232,2973,60,40720,1530,19,57,2,3587.27,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(233,2973,61,40720,1530,19,156,1,22881.86,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(234,2973,61,40720,1530,19,301,1,11230.62,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(235,2973,61,40720,1530,19,302,1,4776.13,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(236,2973,61,40720,1530,19,251,2,336.24,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(237,2973,61,40720,1530,19,302,2,2445.32,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(238,2973,61,40720,1530,19,301,2,4819.18,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(239,2973,61,40720,1530,19,251,2,31287.87,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(240,2973,62,40720,1530,19,67,1,141449.80,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(241,2973,62,40720,1530,19,25,2,199.41,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(242,2973,62,40720,1530,19,68,2,19179.50,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(243,2973,62,40720,1530,19,25,2,19448.10,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(244,2973,62,40720,1530,19,74,2,102622.79,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(245,2973,63,40720,1530,19,251,1,26062.02,NULL,'2021-08-09 20:57:44','2021-08-24 17:42:03','2021-08-24 17:42:03'),(246,2973,63,40720,1530,19,10,1,744629.05,NULL,'2021-08-09 20:57:44','2021-08-24 17:42:03','2021-08-24 17:42:03'),(247,2973,63,40720,1530,19,359,1,20000.00,NULL,'2021-08-09 20:57:44','2021-08-24 17:42:03','2021-08-24 17:42:03'),(248,2973,63,40720,1530,19,57,1,101896.79,NULL,'2021-08-09 20:57:44','2021-08-24 17:42:03','2021-08-24 17:42:03'),(249,2973,63,40720,1530,19,74,1,87351.60,NULL,'2021-08-09 20:57:44','2021-08-24 17:42:03','2021-08-24 17:42:03'),(250,2973,63,40720,1530,19,368,1,180000.00,NULL,'2021-08-09 20:57:44','2021-08-24 17:42:03','2021-08-24 17:42:03'),(251,2973,63,40720,1530,19,395,1,180000.00,NULL,'2021-08-09 20:57:44','2021-08-24 17:42:03','2021-08-24 17:42:03'),(252,2973,63,40720,1530,19,487,1,2691.03,NULL,'2021-08-09 20:57:44','2021-08-24 17:42:03','2021-08-24 17:42:03'),(253,2973,63,40720,1530,19,157,1,5463.60,NULL,'2021-08-09 20:57:44','2021-08-24 17:42:03','2021-08-24 17:42:03'),(254,2973,63,40720,1530,19,396,1,269.69,NULL,'2021-08-09 20:57:44','2021-08-24 17:42:03','2021-08-24 17:42:03'),(255,2973,63,40720,1530,19,10,2,603734.73,NULL,'2021-08-09 20:57:44','2021-08-24 17:42:03','2021-08-24 17:42:03'),(256,2973,63,40720,1530,19,13,2,744629.05,NULL,'2021-08-09 20:57:44','2021-08-24 17:42:03','2021-08-24 17:42:03');
INSERT INTO `balance_libro_details` VALUES (257,2973,64,40720,1531,19,68,1,4620.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(258,2973,64,40720,1531,19,483,1,22000.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(259,2973,64,40720,1531,19,57,2,26620.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(260,2973,65,40720,1531,19,13,1,157643.64,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(261,2973,65,40720,1531,19,67,2,27359.64,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(262,2973,65,40720,1531,19,96,2,130284.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(263,2973,66,40720,1531,19,13,1,31500.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(264,2973,66,40720,1531,19,67,2,5466.94,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(265,2973,66,40720,1531,19,96,2,26033.06,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(266,2973,67,40720,1531,19,251,1,66.90,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(267,2973,67,40720,1531,19,484,1,1672.50,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(268,2973,67,40720,1531,19,68,1,277.72,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(269,2973,67,40720,1531,19,57,2,2017.12,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(270,2973,68,40720,1531,19,13,1,10708.50,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(271,2973,68,40720,1531,19,67,2,1858.50,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(272,2973,68,40720,1531,19,96,2,8850.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(273,2973,69,40720,1531,19,13,1,73000.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(274,2973,69,40720,1531,19,67,2,12669.42,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(275,2973,69,40720,1531,19,96,2,60330.58,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(276,2973,70,40720,1531,19,13,1,532085.40,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(277,2973,70,40720,1531,19,67,2,92345.40,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(278,2973,70,40720,1531,19,96,2,439740.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(279,2973,71,40720,1531,19,217,1,430.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(280,2973,71,40720,1531,19,57,2,430.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(281,2973,72,40720,1531,19,57,1,430.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(282,2973,72,40720,1531,19,359,2,430.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(283,2973,73,40720,1531,19,251,1,68.61,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(284,2973,73,40720,1531,19,484,1,1715.32,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(285,2973,73,40720,1531,19,68,1,284.83,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(286,2973,73,40720,1531,19,57,2,2068.76,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(287,2973,74,40720,1531,19,13,1,4840.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(288,2973,74,40720,1531,19,67,2,840.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(289,2973,74,40720,1531,19,96,2,4000.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(290,2973,75,40720,1531,19,13,1,87600.01,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(291,2973,75,40720,1531,19,67,2,15203.31,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(292,2973,75,40720,1531,19,96,2,72396.70,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(293,2973,76,40720,1531,19,57,1,20000.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(294,2973,76,40720,1531,19,359,2,20000.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(295,2973,77,40720,1531,19,251,1,8794.80,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(296,2973,77,40720,1531,19,23,1,4314.80,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(297,2973,77,40720,1531,19,25,1,46172.70,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL);
INSERT INTO `balance_libro_details` VALUES (298,2973,77,40720,1531,19,13,2,59282.30,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(299,2973,78,40720,1531,19,484,1,385.08,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(300,2973,78,40720,1531,19,57,2,385.08,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(301,2973,79,40720,1531,19,484,1,26099.48,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(302,2973,79,40720,1531,19,68,1,5480.89,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(303,2973,79,40720,1531,19,57,2,31580.37,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(304,2973,80,40720,1531,19,484,1,759.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(305,2973,80,40720,1531,19,68,1,159.39,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(306,2973,80,40720,1531,19,57,2,918.39,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(307,2973,81,40720,1531,19,96,1,113400.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(308,2973,81,40720,1531,19,67,1,23814.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(309,2973,81,40720,1531,19,13,2,137214.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(310,2973,82,40720,1531,19,251,1,2605.68,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(311,2973,82,40720,1531,19,23,1,1262.28,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(312,2973,82,40720,1531,19,13,2,3867.96,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(313,2973,83,40720,1531,19,192,1,10000.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(314,2973,83,40720,1531,19,57,2,10000.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(315,2973,84,40720,1531,19,13,1,68879.25,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(316,2973,84,40720,1531,19,67,2,11954.25,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(317,2973,84,40720,1531,19,96,2,56925.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(318,2973,85,40720,1531,19,68,1,92222.59,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(319,2973,85,40720,1531,19,419,1,878310.38,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(320,2973,85,40720,1531,19,57,2,970532.97,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(321,2973,86,40720,1531,19,359,1,175000.00,NULL,'2021-08-09 20:57:44','2021-08-24 17:43:24','2021-08-24 17:43:24'),(322,2973,86,40720,1531,19,368,2,87500.00,NULL,'2021-08-09 20:57:44','2021-08-24 17:43:24','2021-08-24 17:43:24'),(323,2973,86,40720,1531,19,395,2,87500.00,NULL,'2021-08-09 20:57:44','2021-08-24 17:43:24','2021-08-24 17:43:24'),(324,2973,87,40720,1531,19,13,1,61710.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(325,2973,87,40720,1531,19,67,2,10710.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(326,2973,87,40720,1531,19,96,2,51000.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(327,2973,88,40720,1531,19,251,1,1482.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(328,2973,88,40720,1531,19,13,2,1482.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(329,2973,89,40720,1531,19,251,1,1993.13,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(330,2973,89,40720,1531,19,135,2,1993.13,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(331,2973,90,40720,1531,19,484,1,248.00,NULL,'2021-08-09 20:57:44','2021-08-09 20:57:44',NULL),(332,2973,90,40720,1531,19,68,1,52.08,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(333,2973,90,40720,1531,19,57,2,300.08,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(334,2973,91,40720,1531,19,156,1,23261.88,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(335,2973,91,40720,1531,19,301,1,22399.84,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(336,2973,91,40720,1531,19,302,1,3267.92,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(337,2973,91,40720,1531,19,251,2,135.51,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(338,2973,91,40720,1531,19,302,2,4776.13,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL);
INSERT INTO `balance_libro_details` VALUES (339,2973,91,40720,1531,19,301,2,11230.62,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(340,2973,91,40720,1531,19,486,2,15758.53,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(341,2973,91,40720,1531,19,251,2,17028.85,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(342,2973,92,40720,1531,19,67,1,178407.46,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(343,2973,92,40720,1531,19,74,2,5323.32,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(344,2973,92,40720,1531,19,25,2,46172.70,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(345,2973,92,40720,1531,19,68,2,126911.44,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(346,2973,93,40720,1531,19,68,1,23814.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(347,2973,93,40720,1531,19,67,2,23814.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(348,2973,94,40720,1531,19,13,1,269.68,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(349,2973,94,40720,1531,19,396,2,269.68,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(350,2973,95,40720,1531,19,251,1,2153.24,NULL,'2021-08-09 20:57:45','2021-08-24 17:44:50','2021-08-24 17:44:50'),(351,2973,95,40720,1531,19,10,1,717749.10,NULL,'2021-08-09 20:57:45','2021-08-24 17:44:50','2021-08-24 17:44:50'),(352,2973,95,40720,1531,19,57,1,1011538.92,NULL,'2021-08-09 20:57:45','2021-08-24 17:44:50','2021-08-24 17:44:50'),(353,2973,95,40720,1531,19,74,1,102622.79,NULL,'2021-08-09 20:57:45','2021-08-24 17:44:50','2021-08-24 17:44:50'),(354,2973,95,40720,1531,19,486,1,2566.33,NULL,'2021-08-09 20:57:45','2021-08-24 17:44:50','2021-08-24 17:44:50'),(355,2973,95,40720,1531,19,368,1,65000.00,NULL,'2021-08-09 20:57:45','2021-08-24 17:44:50','2021-08-24 17:44:50'),(356,2973,95,40720,1531,19,395,1,65000.00,NULL,'2021-08-09 20:57:45','2021-08-24 17:44:50','2021-08-24 17:44:50'),(357,2973,95,40720,1531,19,487,1,3896.36,NULL,'2021-08-09 20:57:45','2021-08-24 17:44:50','2021-08-24 17:44:50'),(358,2973,95,40720,1531,19,157,1,7910.78,NULL,'2021-08-09 20:57:45','2021-08-24 17:44:50','2021-08-24 17:44:50'),(359,2973,95,40720,1531,19,396,1,121.00,NULL,'2021-08-09 20:57:45','2021-08-24 17:44:50','2021-08-24 17:44:50'),(360,2973,95,40720,1531,19,359,2,175000.00,NULL,'2021-08-09 20:57:45','2021-08-24 17:44:50','2021-08-24 17:44:50'),(361,2973,95,40720,1531,19,13,2,542749.10,NULL,'2021-08-09 20:57:45','2021-08-24 17:44:50','2021-08-24 17:44:50'),(362,2973,95,40720,1531,19,10,2,1260809.42,NULL,'2021-08-09 20:57:45','2021-08-24 17:44:50','2021-08-24 17:44:50'),(363,2973,96,40720,1532,19,484,1,446.28,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(364,2973,96,40720,1532,19,68,1,93.72,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(365,2973,96,40720,1532,19,57,2,540.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(366,2973,97,40720,1532,19,484,1,850.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(367,2973,97,40720,1532,19,57,2,850.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(368,2973,98,40720,1532,19,13,1,50910.75,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(369,2973,98,40720,1532,19,67,2,8835.75,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(370,2973,98,40720,1532,19,96,2,42075.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(371,2973,99,40720,1532,19,68,1,4786.27,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(372,2973,99,40720,1532,19,483,1,64679.74,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(373,2973,99,40720,1532,19,57,2,69466.01,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(374,2973,100,40720,1532,19,68,1,4620.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(375,2973,100,40720,1532,19,483,1,22000.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(376,2973,100,40720,1532,19,57,2,26620.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(377,2973,101,40720,1532,19,13,1,34848.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL);
INSERT INTO `balance_libro_details` VALUES (378,2973,101,40720,1532,19,67,2,6048.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(379,2973,101,40720,1532,19,96,2,28800.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(380,2973,102,40720,1532,19,13,1,205000.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(381,2973,102,40720,1532,19,67,2,35578.51,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(382,2973,102,40720,1532,19,96,2,169421.49,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(383,2973,103,40720,1532,19,68,1,150.78,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(384,2973,103,40720,1532,19,485,1,718.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(385,2973,103,40720,1532,19,57,2,868.78,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(386,2973,104,40720,1532,19,251,1,1138.50,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(387,2973,104,40720,1532,19,13,2,1138.50,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(388,2973,105,40720,1532,19,68,1,6.08,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(389,2973,105,40720,1532,19,483,1,28.93,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(390,2973,105,40720,1532,19,57,2,35.01,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(391,2973,106,40720,1532,19,68,1,1050.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(392,2973,106,40720,1532,19,129,1,5000.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(393,2973,106,40720,1532,19,57,2,6050.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(394,2973,107,40720,1532,19,68,1,9.20,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(395,2973,107,40720,1532,19,483,1,43.80,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(396,2973,107,40720,1532,19,57,2,53.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(397,2973,108,40720,1532,19,68,1,9.20,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(398,2973,108,40720,1532,19,483,1,43.80,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(399,2973,108,40720,1532,19,57,2,53.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(400,2973,109,40720,1532,19,192,1,10000.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(401,2973,109,40720,1532,19,57,2,10000.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(402,2973,110,40720,1532,19,68,1,10.41,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(403,2973,110,40720,1532,19,483,1,49.59,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(404,2973,110,40720,1532,19,57,2,60.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(405,2973,111,40720,1532,19,251,1,576.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(406,2973,111,40720,1532,19,10,1,34272.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(407,2973,111,40720,1532,19,13,2,34848.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(408,2973,112,40720,1532,19,68,1,22890.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(409,2973,112,40720,1532,19,129,1,109000.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(410,2973,112,40720,1532,19,57,2,131890.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(411,2973,113,40720,1532,19,13,1,162217.50,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(412,2973,113,40720,1532,19,67,2,28153.45,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(413,2973,113,40720,1532,19,96,2,134064.05,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(414,2973,114,40720,1532,19,221,1,557.51,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(415,2973,114,40720,1532,19,251,1,104.70,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(416,2973,114,40720,1532,19,484,1,2059.91,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(417,2973,114,40720,1532,19,68,1,432.58,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(418,2973,114,40720,1532,19,57,2,3154.70,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL);
INSERT INTO `balance_libro_details` VALUES (419,2973,115,40720,1532,19,13,1,47373.32,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(420,2973,115,40720,1532,19,67,2,8221.82,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(421,2973,115,40720,1532,19,96,2,39151.50,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(422,2973,116,40720,1532,19,251,1,909.09,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(423,2973,116,40720,1532,19,25,1,657.40,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(424,2973,116,40720,1532,19,68,1,4601.78,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(425,2973,116,40720,1532,19,198,1,22727.18,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(426,2973,116,40720,1532,19,57,2,28895.45,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(427,2973,117,40720,1532,19,68,1,7565.03,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(428,2973,117,40720,1532,19,483,1,36023.97,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(429,2973,117,40720,1532,19,57,2,43589.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(430,2973,118,40720,1532,19,13,1,94000.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(431,2973,118,40720,1532,19,67,2,16314.05,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(432,2973,118,40720,1532,19,96,2,77685.95,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(433,2973,119,40720,1532,19,221,1,518.53,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(434,2973,119,40720,1532,19,251,1,86.33,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(435,2973,119,40720,1532,19,484,1,2158.25,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(436,2973,119,40720,1532,19,68,1,453.23,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(437,2973,119,40720,1532,19,57,2,3216.34,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(438,2973,120,40720,1532,19,13,1,256600.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(439,2973,120,40720,1532,19,67,2,44533.88,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(440,2973,120,40720,1532,19,96,2,212066.12,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(441,2973,121,40720,1532,19,57,1,1618.74,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(442,2973,121,40720,1532,19,198,2,1618.74,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(443,2973,122,40720,1532,19,68,1,9.20,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(444,2973,122,40720,1532,19,483,1,43.80,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(445,2973,122,40720,1532,19,57,2,53.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(446,2973,123,40720,1532,19,68,1,11.28,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(447,2973,123,40720,1532,19,483,1,53.72,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(448,2973,123,40720,1532,19,57,2,65.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(449,2973,124,40720,1532,19,483,1,100.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(450,2973,124,40720,1532,19,57,2,100.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(451,2973,125,40720,1532,19,68,1,10.41,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(452,2973,125,40720,1532,19,483,1,49.59,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(453,2973,125,40720,1532,19,57,2,60.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(454,2973,126,40720,1532,19,68,1,10.41,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(455,2973,126,40720,1532,19,483,1,49.59,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(456,2973,126,40720,1532,19,57,2,60.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(457,2973,127,40720,1532,19,68,1,9.20,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(458,2973,127,40720,1532,19,483,1,43.80,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(459,2973,127,40720,1532,19,57,2,53.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL);
INSERT INTO `balance_libro_details` VALUES (460,2973,128,40720,1532,19,68,1,11.28,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(461,2973,128,40720,1532,19,483,1,53.72,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(462,2973,128,40720,1532,19,57,2,65.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(463,2973,129,40720,1532,19,251,1,1340.64,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(464,2973,129,40720,1532,19,13,2,1340.64,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(465,2973,130,40720,1532,19,251,1,40.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(466,2973,130,40720,1532,19,135,2,40.00,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(467,2973,131,40720,1532,19,156,1,23890.58,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(468,2973,131,40720,1532,19,301,1,37704.40,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(469,2973,131,40720,1532,19,302,1,2249.60,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(470,2973,131,40720,1532,19,251,2,1100.12,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(471,2973,131,40720,1532,19,302,2,3267.92,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(472,2973,131,40720,1532,19,486,2,3323.63,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(473,2973,131,40720,1532,19,301,2,22399.84,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(474,2973,131,40720,1532,19,251,2,33753.07,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(475,2973,132,40720,1532,19,67,1,147685.46,NULL,'2021-08-09 20:57:45','2021-08-09 20:57:45',NULL),(476,2973,132,40720,1532,19,25,2,657.40,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(477,2973,132,40720,1532,19,68,2,46739.96,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(478,2973,132,40720,1532,19,74,2,100288.10,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(479,2973,133,40720,1532,19,57,1,2375.79,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(480,2973,133,40720,1532,19,359,2,2375.79,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(481,2973,134,40720,1532,19,251,1,30657.93,NULL,'2021-08-09 20:57:46','2021-08-24 17:47:04','2021-08-24 17:47:04'),(482,2973,134,40720,1532,19,10,1,730190.72,NULL,'2021-08-09 20:57:46','2021-08-24 17:47:04','2021-08-24 17:47:04'),(483,2973,134,40720,1532,19,359,1,35000.00,NULL,'2021-08-09 20:57:46','2021-08-24 17:47:04','2021-08-24 17:47:04'),(484,2973,134,40720,1532,19,57,1,334685.54,NULL,'2021-08-09 20:57:46','2021-08-24 17:47:04','2021-08-24 17:47:04'),(485,2973,134,40720,1532,19,74,1,5323.32,NULL,'2021-08-09 20:57:46','2021-08-24 17:47:04','2021-08-24 17:47:04'),(486,2973,134,40720,1532,19,486,1,13255.82,NULL,'2021-08-09 20:57:46','2021-08-24 17:47:04','2021-08-24 17:47:04'),(487,2973,134,40720,1532,19,368,1,185000.00,NULL,'2021-08-09 20:57:46','2021-08-24 17:47:04','2021-08-24 17:47:04'),(488,2973,134,40720,1532,19,395,1,130000.00,NULL,'2021-08-09 20:57:46','2021-08-24 17:47:04','2021-08-24 17:47:04'),(489,2973,134,40720,1532,19,487,1,3062.40,NULL,'2021-08-09 20:57:46','2021-08-24 17:47:04','2021-08-24 17:47:04'),(490,2973,134,40720,1532,19,157,1,6217.61,NULL,'2021-08-09 20:57:46','2021-08-24 17:47:04','2021-08-24 17:47:04'),(491,2973,134,40720,1532,19,419,1,875.80,NULL,'2021-08-09 20:57:46','2021-08-24 17:47:04','2021-08-24 17:47:04'),(492,2973,134,40720,1532,19,396,1,2402.79,NULL,'2021-08-09 20:57:46','2021-08-24 17:47:04','2021-08-24 17:47:04'),(493,2973,134,40720,1532,19,135,1,10007.90,NULL,'2021-08-09 20:57:46','2021-08-24 17:47:04','2021-08-24 17:47:04'),(494,2973,134,40720,1532,19,13,2,730190.72,NULL,'2021-08-09 20:57:46','2021-08-24 17:47:04','2021-08-24 17:47:04'),(495,2973,134,40720,1532,19,10,2,756489.11,NULL,'2021-08-09 20:57:46','2021-08-24 17:47:04','2021-08-24 17:47:04'),(496,2973,135,40720,1533,19,68,1,4620.00,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(497,2973,135,40720,1533,19,483,1,22000.00,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL);
INSERT INTO `balance_libro_details` VALUES (498,2973,135,40720,1533,19,57,2,26620.00,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(499,2973,136,40720,1533,19,251,1,1340.64,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(500,2973,136,40720,1533,19,13,2,1340.64,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(501,2973,137,40720,1533,19,68,1,555.37,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(502,2973,137,40720,1533,19,484,1,2644.63,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(503,2973,137,40720,1533,19,57,2,3200.00,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(504,2973,138,40720,1533,19,57,1,3200.00,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(505,2973,138,40720,1533,19,359,2,3200.00,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(506,2973,139,40720,1533,19,13,1,56000.00,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(507,2973,139,40720,1533,19,67,2,9719.01,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(508,2973,139,40720,1533,19,96,2,46280.99,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(509,2973,140,40720,1533,19,156,1,1572.21,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(510,2973,140,40720,1533,19,301,1,38232.98,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(511,2973,140,40720,1533,19,302,1,2341.59,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(512,2973,140,40720,1533,19,311,1,2628.41,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(513,2973,140,40720,1533,19,486,2,285.74,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(514,2973,140,40720,1533,19,302,2,2249.60,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(515,2973,140,40720,1533,19,251,2,4535.45,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(516,2973,140,40720,1533,19,301,2,37704.40,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(517,2973,141,40720,1533,19,67,1,9719.01,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(518,2973,141,40720,1533,19,74,2,4543.64,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(519,2973,141,40720,1533,19,68,2,5175.37,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(520,2973,142,40720,1533,19,192,1,10000.00,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(521,2973,142,40720,1533,19,57,2,10000.00,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(522,2973,143,40720,1533,19,251,1,3194.81,NULL,'2021-08-09 20:57:46','2021-08-24 17:48:22','2021-08-24 17:48:22'),(523,2973,143,40720,1533,19,10,1,354978.86,NULL,'2021-08-09 20:57:46','2021-08-24 17:48:22','2021-08-24 17:48:22'),(524,2973,143,40720,1533,19,57,1,36620.00,NULL,'2021-08-09 20:57:46','2021-08-24 17:48:22','2021-08-24 17:48:22'),(525,2973,143,40720,1533,19,74,1,25073.00,NULL,'2021-08-09 20:57:46','2021-08-24 17:48:22','2021-08-24 17:48:22'),(526,2973,143,40720,1533,19,368,1,90000.00,NULL,'2021-08-09 20:57:46','2021-08-24 17:48:22','2021-08-24 17:48:22'),(527,2973,143,40720,1533,19,395,1,145000.00,NULL,'2021-08-09 20:57:46','2021-08-24 17:48:22','2021-08-24 17:48:22'),(528,2973,143,40720,1533,19,487,1,1299.36,NULL,'2021-08-09 20:57:46','2021-08-24 17:48:22','2021-08-24 17:48:22'),(529,2973,143,40720,1533,19,157,1,2638.10,NULL,'2021-08-09 20:57:46','2021-08-24 17:48:22','2021-08-24 17:48:22'),(530,2973,143,40720,1533,19,396,1,1375.00,NULL,'2021-08-09 20:57:46','2021-08-24 17:48:22','2021-08-24 17:48:22'),(531,2973,143,40720,1533,19,10,2,305200.27,NULL,'2021-08-09 20:57:46','2021-08-24 17:48:22','2021-08-24 17:48:22'),(532,2973,143,40720,1533,19,13,2,354978.86,NULL,'2021-08-09 20:57:46','2021-08-24 17:48:22','2021-08-24 17:48:22'),(533,2973,144,40720,1534,19,484,1,22000.00,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(534,2973,144,40720,1534,19,68,1,4620.00,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(535,2973,144,40720,1534,19,57,2,26620.00,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(536,2973,145,40720,1534,19,68,1,338.94,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL);
INSERT INTO `balance_libro_details` VALUES (537,2973,145,40720,1534,19,485,1,1614.00,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(538,2973,145,40720,1534,19,57,2,1952.94,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(539,2973,146,40720,1534,19,68,1,142.31,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(540,2973,146,40720,1534,19,483,1,677.69,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(541,2973,146,40720,1534,19,57,2,820.00,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(542,2973,147,40720,1534,19,251,1,783.03,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(543,2973,147,40720,1534,19,13,2,783.03,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(544,2973,148,40720,1534,19,123,1,479.51,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(545,2973,148,40720,1534,19,57,2,479.51,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(546,2973,149,40720,1534,19,251,1,102.50,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(547,2973,149,40720,1534,19,25,1,62.49,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(548,2973,149,40720,1534,19,484,1,2083.09,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(549,2973,149,40720,1534,19,68,1,437.45,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(550,2973,149,40720,1534,19,57,2,2685.53,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(551,2973,150,40720,1534,19,13,1,207960.00,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(552,2973,150,40720,1534,19,67,2,36092.23,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(553,2973,150,40720,1534,19,96,2,171867.77,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(554,2973,151,40720,1534,19,192,1,10000.00,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(555,2973,151,40720,1534,19,57,2,10000.00,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(556,2973,152,40720,1534,19,484,1,155.48,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(557,2973,152,40720,1534,19,25,2,155.48,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(558,2973,153,40720,1534,19,68,1,11.28,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(559,2973,153,40720,1534,19,483,1,53.72,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(560,2973,153,40720,1534,19,57,2,65.00,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(561,2973,154,40720,1534,19,68,1,9.20,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(562,2973,154,40720,1534,19,483,1,43.80,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(563,2973,154,40720,1534,19,57,2,53.00,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(564,2973,155,40720,1534,19,68,1,11.28,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(565,2973,155,40720,1534,19,483,1,53.72,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(566,2973,155,40720,1534,19,57,2,65.00,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(567,2973,156,40720,1534,19,68,1,9.20,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(568,2973,156,40720,1534,19,483,1,43.80,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(569,2973,156,40720,1534,19,57,2,53.00,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(570,2973,157,40720,1534,19,484,1,440.00,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(571,2973,157,40720,1534,19,68,1,92.40,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(572,2973,157,40720,1534,19,57,2,532.40,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(573,2973,158,40720,1534,19,68,1,10.41,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(574,2973,158,40720,1534,19,483,1,49.59,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(575,2973,158,40720,1534,19,57,2,60.00,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(576,2973,159,40720,1534,19,68,1,10.41,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(577,2973,159,40720,1534,19,483,1,49.59,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(578,2973,159,40720,1534,19,57,2,60.00,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL);
INSERT INTO `balance_libro_details` VALUES (579,2973,160,40720,1534,19,68,1,9.20,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(580,2973,160,40720,1534,19,483,1,43.80,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(581,2973,160,40720,1534,19,57,2,53.00,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(582,2973,161,40720,1534,19,68,1,9.20,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(583,2973,161,40720,1534,19,483,1,43.80,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(584,2973,161,40720,1534,19,57,2,53.00,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(585,2973,162,40720,1534,19,13,1,260150.00,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(586,2973,162,40720,1534,19,67,2,45150.00,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(587,2973,162,40720,1534,19,96,2,215000.00,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(588,2973,163,40720,1534,19,383,1,850500.00,NULL,'2021-08-09 20:57:46','2021-08-24 17:49:23','2021-08-24 17:49:23'),(589,2973,163,40720,1534,19,381,2,50500.00,NULL,'2021-08-09 20:57:46','2021-08-24 17:49:23','2021-08-24 17:49:23'),(590,2973,163,40720,1534,19,368,2,400000.00,NULL,'2021-08-09 20:57:46','2021-08-24 17:49:23','2021-08-24 17:49:23'),(591,2973,163,40720,1534,19,395,2,400000.00,NULL,'2021-08-09 20:57:46','2021-08-24 17:49:23','2021-08-24 17:49:23'),(592,2973,164,40720,1534,19,156,1,13142.28,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(593,2973,164,40720,1534,19,301,1,29496.00,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(594,2973,164,40720,1534,19,302,1,2552.43,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(595,2973,164,40720,1534,19,311,1,8651.84,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(596,2973,164,40720,1534,19,136,2,0.02,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(597,2973,164,40720,1534,19,251,2,102.50,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(598,2973,164,40720,1534,19,302,2,2341.59,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(599,2973,164,40720,1534,19,486,2,2388.52,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(600,2973,164,40720,1534,19,311,2,2628.41,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(601,2973,164,40720,1534,19,251,2,8148.53,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(602,2973,164,40720,1534,19,301,2,38232.98,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(603,2973,165,40720,1534,19,67,1,81242.23,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(604,2973,165,40720,1534,19,25,2,62.49,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(605,2973,165,40720,1534,19,68,2,5712.50,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(606,2973,165,40720,1534,19,74,2,75467.24,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(607,2973,166,40720,1534,19,57,1,11814.40,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(608,2973,166,40720,1534,19,359,2,11814.40,NULL,'2021-08-09 20:57:46','2021-08-09 20:57:46',NULL),(609,2973,167,40720,1534,19,251,1,7365.50,NULL,'2021-08-09 20:57:46','2021-08-24 17:50:27','2021-08-24 17:50:27'),(610,2973,167,40720,1534,19,10,1,813500.29,NULL,'2021-08-09 20:57:46','2021-08-24 17:50:27','2021-08-24 17:50:27'),(611,2973,167,40720,1534,19,359,1,10000.00,NULL,'2021-08-09 20:57:46','2021-08-24 17:50:27','2021-08-24 17:50:27'),(612,2973,167,40720,1534,19,57,1,31737.98,NULL,'2021-08-09 20:57:46','2021-08-24 17:50:27','2021-08-24 17:50:27'),(613,2973,167,40720,1534,19,74,1,29615.64,NULL,'2021-08-09 20:57:46','2021-08-24 17:50:27','2021-08-24 17:50:27'),(614,2973,167,40720,1534,19,368,1,122000.00,NULL,'2021-08-09 20:57:46','2021-08-24 17:50:27','2021-08-24 17:50:27'),(615,2973,167,40720,1534,19,395,1,122000.00,NULL,'2021-08-09 20:57:46','2021-08-24 17:50:27','2021-08-24 17:50:27'),(616,2973,167,40720,1534,19,487,1,2269.76,NULL,'2021-08-09 20:57:46','2021-08-24 17:50:27','2021-08-24 17:50:27'),(617,2973,167,40720,1534,19,157,1,4608.29,NULL,'2021-08-09 20:57:46','2021-08-24 17:50:27','2021-08-24 17:50:27');
INSERT INTO `balance_libro_details` VALUES (618,2973,167,40720,1534,19,396,1,1331.00,NULL,'2021-08-09 20:57:46','2021-08-24 17:50:27','2021-08-24 17:50:27'),(619,2973,167,40720,1534,19,467,1,1131.00,NULL,'2021-08-09 20:57:46','2021-08-24 17:50:27','2021-08-24 17:50:27'),(620,2973,167,40720,1534,19,10,2,332059.17,NULL,'2021-08-09 20:57:46','2021-08-24 17:50:27','2021-08-24 17:50:27'),(621,2973,167,40720,1534,19,13,2,813500.29,NULL,'2021-08-09 20:57:47','2021-08-24 17:50:27','2021-08-24 17:50:27'),(622,2973,168,40720,1535,19,484,1,2413.22,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(623,2973,168,40720,1535,19,68,1,506.78,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(624,2973,168,40720,1535,19,57,2,2920.00,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(625,2973,169,40720,1535,19,68,1,7251.19,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(626,2973,169,40720,1535,19,484,1,34529.49,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(627,2973,169,40720,1535,19,57,2,41780.68,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(628,2973,170,40720,1535,19,13,1,110000.00,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(629,2973,170,40720,1535,19,67,2,19090.91,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(630,2973,170,40720,1535,19,96,2,90909.09,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(631,2973,171,40720,1535,19,13,1,100500.00,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(632,2973,171,40720,1535,19,67,2,17442.15,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(633,2973,171,40720,1535,19,96,2,83057.85,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(634,2973,172,40720,1535,19,68,1,4620.00,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(635,2973,172,40720,1535,19,483,1,22000.00,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(636,2973,172,40720,1535,19,57,2,26620.00,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(637,2973,173,40720,1535,19,13,1,112530.00,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(638,2973,173,40720,1535,19,67,2,19530.00,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(639,2973,173,40720,1535,19,96,2,93000.00,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(640,2973,174,40720,1535,19,68,1,10.41,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(641,2973,174,40720,1535,19,483,1,49.59,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(642,2973,174,40720,1535,19,57,2,60.00,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(643,2973,175,40720,1535,19,483,1,49.59,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(644,2973,175,40720,1535,19,57,2,49.59,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(645,2973,176,40720,1535,19,68,1,9.20,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(646,2973,176,40720,1535,19,483,1,43.80,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(647,2973,176,40720,1535,19,57,2,53.00,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(648,2973,177,40720,1535,19,13,1,51546.00,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(649,2973,177,40720,1535,19,67,2,8946.00,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(650,2973,177,40720,1535,19,96,2,42600.00,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(651,2973,178,40720,1535,19,221,1,493.92,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(652,2973,178,40720,1535,19,251,1,102.92,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(653,2973,178,40720,1535,19,484,1,2078.99,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(654,2973,178,40720,1535,19,68,1,436.59,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(655,2973,178,40720,1535,19,57,2,3112.42,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(656,2973,179,40720,1535,19,68,1,10.41,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(657,2973,179,40720,1535,19,483,1,49.59,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL);
INSERT INTO `balance_libro_details` VALUES (658,2973,179,40720,1535,19,57,2,60.00,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(659,2973,180,40720,1535,19,68,1,10.41,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(660,2973,180,40720,1535,19,483,1,49.59,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(661,2973,180,40720,1535,19,57,2,60.00,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(662,2973,181,40720,1535,19,68,1,9.20,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(663,2973,181,40720,1535,19,483,1,43.80,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(664,2973,181,40720,1535,19,57,2,53.00,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(665,2973,182,40720,1535,19,68,1,9.20,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(666,2973,182,40720,1535,19,483,1,43.80,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(667,2973,182,40720,1535,19,57,2,53.00,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(668,2973,183,40720,1535,19,68,1,9.20,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(669,2973,183,40720,1535,19,483,1,43.80,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(670,2973,183,40720,1535,19,57,2,53.00,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(671,2973,184,40720,1535,19,68,1,9.20,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(672,2973,184,40720,1535,19,483,1,43.80,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(673,2973,184,40720,1535,19,57,2,53.00,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(674,2973,185,40720,1535,19,68,1,9.20,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(675,2973,185,40720,1535,19,483,1,43.80,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(676,2973,185,40720,1535,19,57,2,53.00,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(677,2973,186,40720,1535,19,68,1,9.20,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(678,2973,186,40720,1535,19,483,1,43.80,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(679,2973,186,40720,1535,19,57,2,53.00,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(680,2973,187,40720,1535,19,68,1,9.20,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(681,2973,187,40720,1535,19,483,1,43.80,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(682,2973,187,40720,1535,19,57,2,53.00,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(683,2973,188,40720,1535,19,68,1,9.20,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(684,2973,188,40720,1535,19,483,1,43.80,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(685,2973,188,40720,1535,19,57,2,53.00,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(686,2973,189,40720,1535,19,251,1,94.32,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(687,2973,189,40720,1535,19,484,1,2357.98,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(688,2973,189,40720,1535,19,68,1,495.18,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(689,2973,189,40720,1535,19,57,2,2947.48,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(690,2973,190,40720,1535,19,192,1,10000.00,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(691,2973,190,40720,1535,19,57,2,10000.00,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(692,2973,191,40720,1535,19,251,1,10.91,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(693,2973,191,40720,1535,19,68,1,57.27,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(694,2973,191,40720,1535,19,483,1,272.78,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(695,2973,191,40720,1535,19,57,2,340.96,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(696,2973,192,40720,1535,19,13,1,69938.00,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(697,2973,192,40720,1535,19,67,2,12138.00,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(698,2973,192,40720,1535,19,96,2,57800.00,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(699,2973,193,40720,1535,19,68,1,25736.34,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL);
INSERT INTO `balance_libro_details` VALUES (700,2973,193,40720,1535,19,484,1,122554.00,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(701,2973,193,40720,1535,19,57,2,148290.34,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(702,2973,194,40720,1535,19,68,1,370.88,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(703,2973,194,40720,1535,19,484,1,1766.10,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(704,2973,194,40720,1535,19,57,2,2136.98,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(705,2973,195,40720,1535,19,13,1,276333.75,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(706,2973,195,40720,1535,19,67,2,47958.75,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(707,2973,195,40720,1535,19,96,2,228375.00,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(708,2973,196,40720,1535,19,68,1,631.74,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(709,2973,196,40720,1535,19,483,1,3008.28,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(710,2973,196,40720,1535,19,57,2,3640.02,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(711,2973,197,40720,1535,19,251,1,10.88,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(712,2973,197,40720,1535,19,217,1,272.00,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(713,2973,197,40720,1535,19,68,1,57.12,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(714,2973,197,40720,1535,19,57,2,340.00,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(715,2973,198,40720,1535,19,221,1,388.42,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(716,2973,198,40720,1535,19,251,1,83.03,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(717,2973,198,40720,1535,19,68,1,354.36,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(718,2973,198,40720,1535,19,128,1,1687.45,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(719,2973,198,40720,1535,19,57,2,2513.26,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(720,2973,199,40720,1535,19,484,1,4818.00,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(721,2973,199,40720,1535,19,68,1,1011.78,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(722,2973,199,40720,1535,19,57,2,5829.78,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(723,2973,200,40720,1535,19,156,1,20237.95,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(724,2973,200,40720,1535,19,301,1,14302.92,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(725,2973,200,40720,1535,19,302,1,2552.43,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(726,2973,200,40720,1535,19,311,1,8651.84,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(727,2973,200,40720,1535,19,251,2,302.06,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(728,2973,200,40720,1535,19,251,2,1064.70,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(729,2973,200,40720,1535,19,302,2,2552.43,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(730,2973,200,40720,1535,19,486,2,3678.11,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(731,2973,200,40720,1535,19,311,2,8651.84,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(732,2973,200,40720,1535,19,301,2,29496.00,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(733,2973,201,40720,1535,19,67,1,125105.81,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(734,2973,201,40720,1535,19,68,2,41643.26,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(735,2973,201,40720,1535,19,74,2,83462.55,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(736,2973,202,40720,1535,19,57,1,3966.59,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(737,2973,202,40720,1535,19,359,2,3966.59,NULL,'2021-08-09 20:57:47','2021-08-09 20:57:47',NULL),(738,2973,203,40720,1535,19,251,1,1064.70,NULL,'2021-08-09 20:57:47','2021-08-24 17:51:20','2021-08-24 17:51:20'),(739,2973,203,40720,1535,19,10,1,510347.75,NULL,'2021-08-09 20:57:47','2021-08-24 17:51:20','2021-08-24 17:51:20');
INSERT INTO `balance_libro_details` VALUES (740,2973,203,40720,1535,19,359,1,14000.00,NULL,'2021-08-09 20:57:47','2021-08-24 17:51:20','2021-08-24 17:51:20'),(741,2973,203,40720,1535,19,57,1,249034.56,NULL,'2021-08-09 20:57:47','2021-08-24 17:51:20','2021-08-24 17:51:20'),(742,2973,203,40720,1535,19,74,1,94276.30,NULL,'2021-08-09 20:57:47','2021-08-24 17:51:20','2021-08-24 17:51:20'),(743,2973,203,40720,1535,19,368,1,150000.00,NULL,'2021-08-09 20:57:47','2021-08-24 17:51:20','2021-08-24 17:51:20'),(744,2973,203,40720,1535,19,395,1,150000.00,NULL,'2021-08-09 20:57:47','2021-08-24 17:51:20','2021-08-24 17:51:20'),(745,2973,203,40720,1535,19,487,1,7046.16,NULL,'2021-08-09 20:57:47','2021-08-24 17:51:20','2021-08-24 17:51:20'),(746,2973,203,40720,1535,19,396,1,1331.00,NULL,'2021-08-09 20:57:47','2021-08-24 17:51:20','2021-08-24 17:51:20'),(747,2973,203,40720,1535,19,467,1,1963.89,NULL,'2021-08-09 20:57:47','2021-08-24 17:51:20','2021-08-24 17:51:20'),(748,2973,203,40720,1535,19,13,2,510347.75,NULL,'2021-08-09 20:57:47','2021-08-24 17:51:20','2021-08-24 17:51:20'),(749,2973,203,40720,1535,19,10,2,668716.61,NULL,'2021-08-09 20:57:48','2021-08-24 17:51:20','2021-08-24 17:51:20'),(750,2973,204,40720,1536,19,484,1,4800.00,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(751,2973,204,40720,1536,19,68,1,1008.00,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(752,2973,204,40720,1536,19,57,2,5808.00,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(753,2973,205,40720,1536,19,68,1,8542.04,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(754,2973,205,40720,1536,19,484,1,40676.37,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(755,2973,205,40720,1536,19,57,2,49218.41,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(756,2973,206,40720,1536,19,57,1,38482.17,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(757,2973,206,40720,1536,19,68,2,6678.72,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(758,2973,206,40720,1536,19,484,2,31803.45,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(759,2973,207,40720,1536,19,192,1,10000.00,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(760,2973,207,40720,1536,19,57,2,10000.00,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(761,2973,208,40720,1536,19,57,1,10000.00,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(762,2973,208,40720,1536,19,359,2,10000.00,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(763,2973,209,40720,1536,19,68,1,5313.00,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(764,2973,209,40720,1536,19,483,1,25300.00,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(765,2973,209,40720,1536,19,57,2,30613.00,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(766,2973,210,40720,1536,19,135,1,285.27,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(767,2973,210,40720,1536,19,57,2,285.27,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(768,2973,211,40720,1536,19,25,1,60.41,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(769,2973,211,40720,1536,19,128,2,60.41,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(770,2973,212,40720,1536,19,221,1,523.96,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(771,2973,212,40720,1536,19,251,1,99.09,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(772,2973,212,40720,1536,19,484,1,2013.81,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(773,2973,212,40720,1536,19,68,1,422.90,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(774,2973,212,40720,1536,19,57,2,3059.76,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(775,2973,213,40720,1536,19,13,1,315507.50,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(776,2973,213,40720,1536,19,67,2,54757.50,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(777,2973,213,40720,1536,19,96,2,260750.00,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(778,2973,214,40720,1536,19,251,1,92.80,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL);
INSERT INTO `balance_libro_details` VALUES (779,2973,214,40720,1536,19,68,1,278.40,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(780,2973,214,40720,1536,19,483,1,1325.73,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(781,2973,214,40720,1536,19,57,2,1696.93,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(782,2973,215,40720,1536,19,13,1,8250.00,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(783,2973,215,40720,1536,19,67,2,1431.82,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(784,2973,215,40720,1536,19,96,2,6818.18,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(785,2973,216,40720,1536,19,251,1,25.39,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(786,2973,216,40720,1536,19,135,2,25.39,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(787,2973,217,40720,1536,19,483,1,793.39,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(788,2973,217,40720,1536,19,57,2,793.39,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(789,2973,218,40720,1536,19,221,1,487.20,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(790,2973,218,40720,1536,19,484,1,2325.12,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(791,2973,218,40720,1536,19,68,1,488.28,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(792,2973,218,40720,1536,19,57,2,3300.60,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(793,2973,219,40720,1536,19,484,1,3966.94,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(794,2973,219,40720,1536,19,68,1,833.06,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(795,2973,219,40720,1536,19,57,2,4800.00,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(796,2973,220,40720,1536,19,484,1,2239.18,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(797,2973,220,40720,1536,19,68,1,470.23,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(798,2973,220,40720,1536,19,57,2,2709.41,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(799,2973,221,40720,1536,19,484,1,1800.00,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(800,2973,221,40720,1536,19,68,1,378.00,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(801,2973,221,40720,1536,19,57,2,2178.00,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(802,2973,222,40720,1536,19,57,1,2178.00,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(803,2973,222,40720,1536,19,359,2,2178.00,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(804,2973,223,40720,1536,19,156,1,9089.56,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(805,2973,223,40720,1536,19,301,1,10211.78,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(806,2973,223,40720,1536,19,302,1,2592.20,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(807,2973,223,40720,1536,19,311,1,8651.84,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(808,2973,223,40720,1536,19,251,2,41.89,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(809,2973,223,40720,1536,19,251,2,191.89,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(810,2973,223,40720,1536,19,302,2,2552.43,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(811,2973,223,40720,1536,19,486,2,4804.41,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(812,2973,223,40720,1536,19,311,2,8651.84,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(813,2973,223,40720,1536,19,301,2,14302.92,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(814,2973,224,40720,1536,19,68,1,12278.51,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(815,2973,224,40720,1536,19,484,1,58469.08,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(816,2973,224,40720,1536,19,57,2,70747.59,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(817,2973,225,40720,1536,19,67,1,56189.32,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(818,2973,225,40720,1536,19,68,1,6678.72,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(819,2973,225,40720,1536,19,25,2,60.41,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL);
INSERT INTO `balance_libro_details` VALUES (820,2973,225,40720,1536,19,68,2,30531.33,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(821,2973,225,40720,1536,19,74,2,32276.30,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(822,2973,226,40720,1536,19,68,1,518.92,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(823,2973,226,40720,1536,19,484,1,2471.06,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(824,2973,226,40720,1536,19,57,2,2989.98,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(825,2973,227,40720,1536,19,251,1,16.50,NULL,'2021-08-09 20:57:48','2021-08-24 17:52:22','2021-08-24 17:52:22'),(826,2973,227,40720,1536,19,10,1,323757.50,NULL,'2021-08-09 20:57:48','2021-08-24 17:52:22','2021-08-24 17:52:22'),(827,2973,227,40720,1536,19,359,1,20000.00,NULL,'2021-08-09 20:57:48','2021-08-24 17:52:22','2021-08-24 17:52:22'),(828,2973,227,40720,1536,19,57,1,121364.18,NULL,'2021-08-09 20:57:48','2021-08-24 17:52:22','2021-08-24 17:52:22'),(829,2973,227,40720,1536,19,74,1,108534.55,NULL,'2021-08-09 20:57:48','2021-08-24 17:52:22','2021-08-24 17:52:22'),(830,2973,227,40720,1536,19,368,1,165000.00,NULL,'2021-08-09 20:57:48','2021-08-24 17:52:22','2021-08-24 17:52:22'),(831,2973,227,40720,1536,19,395,1,165000.00,NULL,'2021-08-09 20:57:48','2021-08-24 17:52:22','2021-08-24 17:52:22'),(832,2973,227,40720,1536,19,487,1,3547.35,NULL,'2021-08-09 20:57:48','2021-08-24 17:52:22','2021-08-24 17:52:22'),(833,2973,227,40720,1536,19,396,1,1331.00,NULL,'2021-08-09 20:57:48','2021-08-24 17:52:22','2021-08-24 17:52:22'),(834,2973,227,40720,1536,19,467,1,1724.02,NULL,'2021-08-09 20:57:48','2021-08-24 17:52:22','2021-08-24 17:52:22'),(835,2973,227,40720,1536,19,13,2,323757.50,NULL,'2021-08-09 20:57:48','2021-08-24 17:52:22','2021-08-24 17:52:22'),(836,2973,227,40720,1536,19,10,2,586517.60,NULL,'2021-08-09 20:57:48','2021-08-24 17:52:22','2021-08-24 17:52:22'),(837,2973,228,40720,1537,19,13,1,75655.25,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(838,2973,228,40720,1537,19,67,2,13130.25,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(839,2973,228,40720,1537,19,96,2,62525.00,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(840,2973,229,40720,1537,19,135,1,275.35,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(841,2973,229,40720,1537,19,57,2,275.35,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(842,2973,230,40720,1537,19,484,1,257.84,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(843,2973,230,40720,1537,19,68,1,54.15,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(844,2973,230,40720,1537,19,57,2,311.99,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(845,2973,231,40720,1537,19,484,1,3073.27,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(846,2973,231,40720,1537,19,68,1,645.39,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(847,2973,231,40720,1537,19,57,2,3718.66,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(848,2973,232,40720,1537,19,68,1,5313.00,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(849,2973,232,40720,1537,19,483,1,25300.00,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(850,2973,232,40720,1537,19,57,2,30613.00,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(851,2973,233,40720,1537,19,68,1,840.00,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(852,2973,233,40720,1537,19,129,1,4000.00,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(853,2973,233,40720,1537,19,57,2,4840.00,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(854,2973,234,40720,1537,19,484,1,5065.50,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(855,2973,234,40720,1537,19,68,1,1063.76,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(856,2973,234,40720,1537,19,57,2,6129.26,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(857,2973,235,40720,1537,19,221,1,398.76,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(858,2973,235,40720,1537,19,251,1,96.48,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL);
INSERT INTO `balance_libro_details` VALUES (859,2973,235,40720,1537,19,484,1,2013.26,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(860,2973,235,40720,1537,19,68,1,409.29,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(861,2973,235,40720,1537,19,57,2,2917.79,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(862,2973,236,40720,1537,19,68,1,260.33,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(863,2973,236,40720,1537,19,129,1,1239.67,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(864,2973,236,40720,1537,19,57,2,1500.00,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(865,2973,237,40720,1537,19,13,1,26850.00,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(866,2973,237,40720,1537,19,67,2,4659.92,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(867,2973,237,40720,1537,19,96,2,22190.08,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(868,2973,238,40720,1537,19,251,1,76.57,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(869,2973,238,40720,1537,19,484,1,1914.26,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(870,2973,238,40720,1537,19,68,1,401.99,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(871,2973,238,40720,1537,19,57,2,2392.82,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(872,2973,239,40720,1537,19,68,1,247.35,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(873,2973,239,40720,1537,19,483,1,1177.86,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(874,2973,239,40720,1537,19,57,2,1425.21,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(875,2973,240,40720,1537,19,57,1,1425.21,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(876,2973,240,40720,1537,19,359,2,1425.21,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(877,2973,241,40720,1537,19,411,1,431902.63,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(878,2973,241,40720,1537,19,79,2,431902.63,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(879,2973,242,40720,1537,19,192,1,10000.00,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(880,2973,242,40720,1537,19,57,2,10000.00,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(881,2973,243,40720,1537,19,251,1,362.79,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(882,2973,243,40720,1537,19,25,1,155.48,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(883,2973,243,40720,1537,19,484,1,5182.64,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(884,2973,243,40720,1537,19,68,1,1088.35,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(885,2973,243,40720,1537,19,57,2,6789.26,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(886,2973,244,40720,1537,19,128,1,681.82,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(887,2973,244,40720,1537,19,57,2,681.82,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(888,2973,245,40720,1537,19,68,1,13.88,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(889,2973,245,40720,1537,19,483,1,66.11,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(890,2973,245,40720,1537,19,57,2,79.99,NULL,'2021-08-09 20:57:48','2021-08-09 20:57:48',NULL),(891,2973,246,40720,1537,19,68,1,13.89,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(892,2973,246,40720,1537,19,483,1,66.12,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(893,2973,246,40720,1537,19,57,2,80.01,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(894,2973,247,40720,1537,19,13,1,3282.12,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(895,2973,247,40720,1537,19,67,2,569.62,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(896,2973,247,40720,1537,19,96,2,2712.50,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(897,2973,248,40720,1537,19,13,1,414485.50,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(898,2973,248,40720,1537,19,67,2,71935.50,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(899,2973,248,40720,1537,19,96,2,342550.00,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL);
INSERT INTO `balance_libro_details` VALUES (900,2973,249,40720,1537,19,221,1,438.06,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(901,2973,249,40720,1537,19,251,1,104.66,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(902,2973,249,40720,1537,19,484,1,2178.30,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(903,2973,249,40720,1537,19,68,1,442.93,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(904,2973,249,40720,1537,19,57,2,3163.95,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(905,2973,250,40720,1537,19,13,1,34696.75,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(906,2973,250,40720,1537,19,67,2,6021.75,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(907,2973,250,40720,1537,19,96,2,28675.00,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(908,2973,251,40720,1537,19,68,1,13.88,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(909,2973,251,40720,1537,19,483,1,66.11,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(910,2973,251,40720,1537,19,57,2,79.99,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(911,2973,252,40720,1537,19,68,1,36.80,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(912,2973,252,40720,1537,19,483,1,175.20,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(913,2973,252,40720,1537,19,57,2,212.00,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(914,2973,253,40720,1537,19,68,1,13.89,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(915,2973,253,40720,1537,19,483,1,66.12,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(916,2973,253,40720,1537,19,57,2,80.01,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(917,2973,254,40720,1537,19,68,1,10.41,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(918,2973,254,40720,1537,19,483,1,49.59,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(919,2973,254,40720,1537,19,57,2,60.00,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(920,2973,255,40720,1537,19,13,1,187550.00,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(921,2973,255,40720,1537,19,67,2,32550.00,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(922,2973,255,40720,1537,19,96,2,155000.00,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(923,2973,256,40720,1537,19,68,1,27.60,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(924,2973,256,40720,1537,19,483,1,131.40,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(925,2973,256,40720,1537,19,57,2,159.00,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(926,2973,257,40720,1537,19,136,1,0.01,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(927,2973,257,40720,1537,19,156,1,20846.39,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(928,2973,257,40720,1537,19,301,1,14684.26,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(929,2973,257,40720,1537,19,302,1,2783.02,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(930,2973,257,40720,1537,19,311,1,8651.84,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(931,2973,257,40720,1537,19,251,2,744.50,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(932,2973,257,40720,1537,19,486,2,2385.34,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(933,2973,257,40720,1537,19,302,2,2592.20,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(934,2973,257,40720,1537,19,311,2,8651.84,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(935,2973,257,40720,1537,19,301,2,10211.78,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(936,2973,257,40720,1537,19,251,2,22379.86,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(937,2973,258,40720,1537,19,67,1,128867.04,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(938,2973,258,40720,1537,19,68,2,12625.94,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(939,2973,258,40720,1537,19,74,2,116241.10,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(940,2973,259,40720,1537,19,221,1,435.34,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL);
INSERT INTO `balance_libro_details` VALUES (941,2973,259,40720,1537,19,251,1,104.00,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(942,2973,259,40720,1537,19,484,1,2164.78,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(943,2973,259,40720,1537,19,68,1,440.18,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(944,2973,259,40720,1537,19,57,2,3144.30,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(945,2973,260,40720,1537,19,217,1,12275.10,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(946,2973,260,40720,1537,19,68,1,1288.89,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(947,2973,260,40720,1537,19,57,2,13563.99,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(948,2973,261,40720,1537,19,57,1,21592.26,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(949,2973,261,40720,1537,19,359,2,21592.26,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(950,2973,262,40720,1537,19,251,1,104.27,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(951,2973,262,40720,1537,19,135,2,104.27,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(952,2973,263,40720,1537,19,251,1,22275.59,NULL,'2021-08-09 20:57:49','2021-08-24 17:53:19','2021-08-24 17:53:19'),(953,2973,263,40720,1537,19,10,1,742519.62,NULL,'2021-08-09 20:57:49','2021-08-24 17:53:19','2021-08-24 17:53:19'),(954,2973,263,40720,1537,19,359,1,15000.00,NULL,'2021-08-09 20:57:49','2021-08-24 17:53:19','2021-08-24 17:53:19'),(955,2973,263,40720,1537,19,57,1,50574.95,NULL,'2021-08-09 20:57:49','2021-08-24 17:53:19','2021-08-24 17:53:19'),(956,2973,263,40720,1537,19,74,1,32276.30,NULL,'2021-08-09 20:57:49','2021-08-24 17:53:19','2021-08-24 17:53:19'),(957,2973,263,40720,1537,19,368,1,100000.00,NULL,'2021-08-09 20:57:49','2021-08-24 17:53:19','2021-08-24 17:53:19'),(958,2973,263,40720,1537,19,395,1,100000.00,NULL,'2021-08-09 20:57:49','2021-08-24 17:53:19','2021-08-24 17:53:19'),(959,2973,263,40720,1537,19,487,1,6383.88,NULL,'2021-08-09 20:57:49','2021-08-24 17:53:19','2021-08-24 17:53:19'),(960,2973,263,40720,1537,19,396,1,1331.00,NULL,'2021-08-09 20:57:49','2021-08-24 17:53:19','2021-08-24 17:53:19'),(961,2973,263,40720,1537,19,10,2,327841.72,NULL,'2021-08-09 20:57:49','2021-08-24 17:53:19','2021-08-24 17:53:19'),(962,2973,263,40720,1537,19,13,2,742519.62,NULL,'2021-08-09 20:57:49','2021-08-24 17:53:19','2021-08-24 17:53:19'),(963,2973,264,40720,1538,19,251,1,135.89,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(964,2973,264,40720,1538,19,68,1,407.68,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(965,2973,264,40720,1538,19,483,1,1941.32,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(966,2973,264,40720,1538,19,57,2,2484.89,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(967,2973,265,40720,1538,19,217,1,284.88,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(968,2973,265,40720,1538,19,68,1,35.75,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(969,2973,265,40720,1538,19,57,2,320.63,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(970,2973,266,40720,1538,19,68,1,5313.00,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(971,2973,266,40720,1538,19,483,1,25300.00,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(972,2973,266,40720,1538,19,57,2,30613.00,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(973,2973,267,40720,1538,19,13,1,107938.05,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(974,2973,267,40720,1538,19,67,2,18733.05,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(975,2973,267,40720,1538,19,96,2,89205.00,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(976,2973,268,40720,1538,19,221,1,409.96,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(977,2973,268,40720,1538,19,251,1,82.08,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(978,2973,268,40720,1538,19,68,1,258.66,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(979,2973,268,40720,1538,19,128,1,1231.71,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL);
INSERT INTO `balance_libro_details` VALUES (980,2973,268,40720,1538,19,57,2,1982.41,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(981,2973,269,40720,1538,19,68,1,781.20,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(982,2973,269,40720,1538,19,485,1,3720.00,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(983,2973,269,40720,1538,19,57,2,4501.20,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(984,2973,270,40720,1538,19,217,1,15000.00,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(985,2973,270,40720,1538,19,57,2,15000.00,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(986,2973,271,40720,1538,19,13,1,239000.00,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(987,2973,271,40720,1538,19,67,2,41479.34,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(988,2973,271,40720,1538,19,96,2,197520.66,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(989,2973,272,40720,1538,19,68,1,381.82,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(990,2973,272,40720,1538,19,484,1,1818.20,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(991,2973,272,40720,1538,19,57,2,2200.02,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(992,2973,273,40720,1538,19,251,1,2230.14,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(993,2973,273,40720,1538,19,23,1,440.70,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(994,2973,273,40720,1538,19,13,2,2670.84,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(995,2973,274,40720,1538,19,68,1,5310.57,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(996,2973,274,40720,1538,19,484,1,25288.44,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(997,2973,274,40720,1538,19,57,2,30599.01,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(998,2973,275,40720,1538,19,221,1,458.48,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(999,2973,275,40720,1538,19,484,1,2315.66,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(1000,2973,275,40720,1538,19,68,1,486.29,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(1001,2973,275,40720,1538,19,57,2,3260.43,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(1002,2973,276,40720,1538,19,68,1,13.89,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(1003,2973,276,40720,1538,19,483,1,66.12,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(1004,2973,276,40720,1538,19,57,2,80.01,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(1005,2973,277,40720,1538,19,68,1,13.89,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(1006,2973,277,40720,1538,19,483,1,66.12,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(1007,2973,277,40720,1538,19,57,2,80.01,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(1008,2973,278,40720,1538,19,13,1,163440.00,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(1009,2973,278,40720,1538,19,67,2,28365.62,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(1010,2973,278,40720,1538,19,96,2,135074.38,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(1011,2973,279,40720,1538,19,221,1,475.52,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(1012,2973,279,40720,1538,19,251,1,1120.88,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(1013,2973,279,40720,1538,19,25,1,648.44,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(1014,2973,279,40720,1538,19,68,1,4539.11,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(1015,2973,279,40720,1538,19,198,1,21942.15,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(1016,2973,279,40720,1538,19,57,2,28726.10,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(1017,2973,280,40720,1538,19,483,1,1220.00,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(1018,2973,280,40720,1538,19,57,2,1220.00,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(1019,2973,281,40720,1538,19,128,1,743.50,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(1020,2973,281,40720,1538,19,57,2,743.50,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL);
INSERT INTO `balance_libro_details` VALUES (1021,2973,282,40720,1538,19,57,1,1220.00,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(1022,2973,282,40720,1538,19,359,2,1220.00,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(1023,2973,283,40720,1538,19,198,1,620.60,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(1024,2973,283,40720,1538,19,57,2,620.60,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(1025,2973,284,40720,1538,19,57,1,1359.53,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(1026,2973,284,40720,1538,19,221,2,24.28,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(1027,2973,284,40720,1538,19,68,2,231.74,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(1028,2973,284,40720,1538,19,198,2,1103.51,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(1029,2973,285,40720,1538,19,68,1,231.74,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(1030,2973,285,40720,1538,19,198,2,231.74,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(1031,2973,286,40720,1538,19,13,1,43287.75,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(1032,2973,286,40720,1538,19,67,2,7512.75,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(1033,2973,286,40720,1538,19,96,2,35775.00,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(1034,2973,287,40720,1538,19,68,1,13.89,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(1035,2973,287,40720,1538,19,483,1,66.12,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(1036,2973,287,40720,1538,19,57,2,80.01,NULL,'2021-08-09 20:57:49','2021-08-09 20:57:49',NULL),(1037,2973,288,40720,1538,19,68,1,13.89,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1038,2973,288,40720,1538,19,483,1,66.12,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1039,2973,288,40720,1538,19,57,2,80.01,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1040,2973,289,40720,1538,19,13,1,96195.00,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1041,2973,289,40720,1538,19,67,2,16695.00,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1042,2973,289,40720,1538,19,96,2,79500.00,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1043,2973,290,40720,1538,19,484,1,5263.50,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1044,2973,290,40720,1538,19,68,1,1105.34,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1045,2973,290,40720,1538,19,57,2,6368.84,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1046,2973,291,40720,1538,19,217,1,1100.00,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1047,2973,291,40720,1538,19,68,1,231.00,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1048,2973,291,40720,1538,19,57,2,1331.00,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1049,2973,292,40720,1538,19,68,1,231.00,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1050,2973,292,40720,1538,19,396,2,231.00,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1051,2973,293,40720,1538,19,251,1,268.05,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1052,2973,293,40720,1538,19,135,2,268.05,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1053,2973,294,40720,1538,19,156,1,18244.98,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1054,2973,294,40720,1538,19,301,1,21742.77,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1055,2973,294,40720,1538,19,302,1,748.54,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1056,2973,294,40720,1538,19,311,1,8651.84,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1057,2973,294,40720,1538,19,302,2,2783.02,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1058,2973,294,40720,1538,19,311,2,8651.84,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1059,2973,294,40720,1538,19,301,2,14684.26,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1060,2973,294,40720,1538,19,251,2,23269.01,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1061,2973,295,40720,1538,19,67,1,112785.76,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL);
INSERT INTO `balance_libro_details` VALUES (1062,2973,295,40720,1538,19,25,2,648.44,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1063,2973,295,40720,1538,19,68,2,19498.17,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1064,2973,295,40720,1538,19,74,2,92639.15,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1065,2973,296,40720,1538,19,217,1,633.48,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1066,2973,296,40720,1538,19,68,1,66.52,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1067,2973,296,40720,1538,19,57,2,700.00,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1068,2973,297,40720,1538,19,68,1,225.62,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1069,2973,297,40720,1538,19,483,1,1074.38,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1070,2973,297,40720,1538,19,57,2,1300.00,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1071,2973,298,40720,1538,19,251,1,16.27,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1072,2973,298,40720,1538,19,217,1,325.39,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1073,2973,298,40720,1538,19,68,1,68.33,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1074,2973,298,40720,1538,19,57,2,409.99,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1075,2973,299,40720,1538,19,467,1,457.03,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1076,2973,299,40720,1538,19,486,2,457.03,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1077,2973,300,40720,1538,19,57,1,52511.49,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1078,2973,300,40720,1538,19,359,2,52511.49,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1079,2973,301,40720,1538,19,251,1,19415.70,NULL,'2021-08-09 20:57:50','2021-08-24 17:54:24','2021-08-24 17:54:24'),(1080,2973,301,40720,1538,19,10,1,647189.97,NULL,'2021-08-09 20:57:50','2021-08-24 17:54:24','2021-08-24 17:54:24'),(1081,2973,301,40720,1538,19,359,1,30000.00,NULL,'2021-08-09 20:57:50','2021-08-24 17:54:24','2021-08-24 17:54:24'),(1082,2973,301,40720,1538,19,57,1,80468.57,NULL,'2021-08-09 20:57:50','2021-08-24 17:54:24','2021-08-24 17:54:24'),(1083,2973,301,40720,1538,19,74,1,116241.10,NULL,'2021-08-09 20:57:50','2021-08-24 17:54:24','2021-08-24 17:54:24'),(1084,2973,301,40720,1538,19,486,1,17259.16,NULL,'2021-08-09 20:57:50','2021-08-24 17:54:24','2021-08-24 17:54:24'),(1085,2973,301,40720,1538,19,368,1,150000.00,NULL,'2021-08-09 20:57:50','2021-08-24 17:54:24','2021-08-24 17:54:24'),(1086,2973,301,40720,1538,19,395,1,150000.00,NULL,'2021-08-09 20:57:50','2021-08-24 17:54:24','2021-08-24 17:54:24'),(1087,2973,301,40720,1538,19,487,1,8818.30,NULL,'2021-08-09 20:57:50','2021-08-24 17:54:24','2021-08-24 17:54:24'),(1088,2973,301,40720,1538,19,20,1,259141.58,NULL,'2021-08-09 20:57:50','2021-08-24 17:54:24','2021-08-24 17:54:24'),(1089,2973,301,40720,1538,19,13,2,647189.97,NULL,'2021-08-09 20:57:50','2021-08-24 17:54:24','2021-08-24 17:54:24'),(1090,2973,301,40720,1538,19,10,2,831344.41,NULL,'2021-08-09 20:57:50','2021-08-24 17:54:24','2021-08-24 17:54:24'),(1091,2973,302,40720,1539,19,251,1,15.91,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1092,2973,302,40720,1539,19,484,1,318.18,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1093,2973,302,40720,1539,19,68,1,66.82,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1094,2973,302,40720,1539,19,57,2,400.91,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1095,2973,303,40720,1539,19,251,1,82.45,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1096,2973,303,40720,1539,19,68,1,247.35,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1097,2973,303,40720,1539,19,483,1,1177.86,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1098,2973,303,40720,1539,19,57,2,1507.66,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1099,2973,304,40720,1539,19,251,1,67.86,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1100,2973,304,40720,1539,19,68,1,178.14,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL);
INSERT INTO `balance_libro_details` VALUES (1101,2973,304,40720,1539,19,483,1,848.29,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1102,2973,304,40720,1539,19,57,2,1094.29,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1103,2973,305,40720,1539,19,217,1,8759.50,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1104,2973,305,40720,1539,19,68,1,1839.50,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1105,2973,305,40720,1539,19,57,2,10599.00,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1106,2973,306,40720,1539,19,57,1,10599.00,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1107,2973,306,40720,1539,19,359,2,10599.00,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1108,2973,307,40720,1539,19,68,1,5313.00,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1109,2973,307,40720,1539,19,483,1,25300.00,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1110,2973,307,40720,1539,19,57,2,30613.00,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1111,2973,308,40720,1539,19,217,1,1266.97,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1112,2973,308,40720,1539,19,68,1,133.03,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1113,2973,308,40720,1539,19,57,2,1400.00,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1114,2973,309,40720,1539,19,68,1,12086.61,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1115,2973,309,40720,1539,19,484,1,57555.30,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1116,2973,309,40720,1539,19,57,2,69641.91,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1117,2973,310,40720,1539,19,217,1,15000.00,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1118,2973,310,40720,1539,19,57,2,15000.00,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1119,2973,311,40720,1539,19,135,1,55353.53,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1120,2973,311,40720,1539,19,135,1,15454.69,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1121,2973,311,40720,1539,19,57,2,70808.22,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1122,2973,312,40720,1539,19,57,1,15000.00,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1123,2973,312,40720,1539,19,359,2,15000.00,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1124,2973,313,40720,1539,19,359,1,120000.00,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1125,2973,313,40720,1539,19,13,2,120000.00,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1126,2973,314,40720,1539,19,68,1,31458.41,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1127,2973,314,40720,1539,19,484,1,149801.97,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1128,2973,314,40720,1539,19,57,2,181260.38,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1129,2973,315,40720,1539,19,13,1,120000.00,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1130,2973,315,40720,1539,19,67,2,20826.45,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1131,2973,315,40720,1539,19,96,2,99173.55,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1132,2973,316,40720,1539,19,359,1,24805.00,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1133,2973,316,40720,1539,19,13,2,24805.00,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1134,2973,317,40720,1539,19,57,1,109000.00,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1135,2973,317,40720,1539,19,359,2,109000.00,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1136,2973,318,40720,1539,19,68,1,118.86,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1137,2973,318,40720,1539,19,483,1,565.98,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1138,2973,318,40720,1539,19,57,2,684.84,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1139,2973,319,40720,1539,19,221,1,67.69,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1140,2973,319,40720,1539,19,251,1,133.25,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL);
INSERT INTO `balance_libro_details` VALUES (1141,2973,319,40720,1539,19,484,1,2597.32,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1142,2973,319,40720,1539,19,68,1,455.10,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1143,2973,319,40720,1539,19,57,2,3253.36,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1144,2973,320,40720,1539,19,484,1,264.20,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1145,2973,320,40720,1539,19,68,1,55.48,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1146,2973,320,40720,1539,19,57,2,319.68,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1147,2973,321,40720,1539,19,13,1,24805.00,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1148,2973,321,40720,1539,19,67,2,4305.00,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1149,2973,321,40720,1539,19,96,2,20500.00,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1150,2973,322,40720,1539,19,135,1,400.00,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1151,2973,322,40720,1539,19,79,1,431902.63,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1152,2973,322,40720,1539,19,467,1,43190.26,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1153,2973,322,40720,1539,19,448,2,475492.89,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1154,2973,323,40720,1539,19,13,1,111376.51,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1155,2973,323,40720,1539,19,67,2,19329.81,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1156,2973,323,40720,1539,19,96,2,92046.70,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1157,2973,324,40720,1539,19,484,1,5428.50,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1158,2973,324,40720,1539,19,68,1,1139.99,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1159,2973,324,40720,1539,19,57,2,6568.49,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1160,2973,325,40720,1539,19,251,1,17.38,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1161,2973,325,40720,1539,19,68,1,73.01,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1162,2973,325,40720,1539,19,483,1,347.68,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1163,2973,325,40720,1539,19,57,2,438.07,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1164,2973,326,40720,1539,19,13,1,99825.00,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1165,2973,326,40720,1539,19,67,2,17325.00,NULL,'2021-08-09 20:57:50','2021-08-09 20:57:50',NULL),(1166,2973,326,40720,1539,19,96,2,82500.00,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1167,2973,327,40720,1539,19,128,1,1416.74,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1168,2973,327,40720,1539,19,57,2,1416.74,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1169,2973,328,40720,1539,19,128,1,1080.89,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1170,2973,328,40720,1539,19,57,2,1080.89,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1171,2973,329,40720,1539,19,13,1,174240.00,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1172,2973,329,40720,1539,19,67,2,30240.00,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1173,2973,329,40720,1539,19,96,2,144000.00,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1174,2973,330,40720,1539,19,221,1,74.97,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1175,2973,330,40720,1539,19,251,1,145.37,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1176,2973,330,40720,1539,19,484,1,2832.34,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1177,2973,330,40720,1539,19,68,1,492.67,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1178,2973,330,40720,1539,19,57,2,3545.35,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1179,2973,331,40720,1539,19,68,1,1718.18,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1180,2973,331,40720,1539,19,129,1,8181.82,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1181,2973,331,40720,1539,19,57,2,9900.00,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL);
INSERT INTO `balance_libro_details` VALUES (1182,2973,332,40720,1539,19,251,1,156.03,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1183,2973,332,40720,1539,19,135,2,156.03,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1184,2973,333,40720,1539,19,156,1,14886.78,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1185,2973,333,40720,1539,19,301,1,11028.15,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1186,2973,333,40720,1539,19,311,1,8651.84,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1187,2973,333,40720,1539,19,486,2,437.72,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1188,2973,333,40720,1539,19,302,2,748.54,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1189,2973,333,40720,1539,19,251,2,2985.90,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1190,2973,333,40720,1539,19,311,2,8651.84,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1191,2973,333,40720,1539,19,301,2,21742.77,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1192,2973,334,40720,1539,19,67,1,92026.26,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1193,2973,334,40720,1539,19,74,2,36614.36,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1194,2973,334,40720,1539,19,68,2,55411.90,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1195,2973,335,40720,1539,19,217,1,170.25,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1196,2973,335,40720,1539,19,68,1,35.75,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1197,2973,335,40720,1539,19,57,2,206.00,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1198,2973,336,40720,1539,19,57,1,15958.79,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1199,2973,336,40720,1539,19,359,2,15958.79,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1200,2973,337,40720,1539,19,251,1,2367.65,NULL,'2021-08-09 20:57:51','2021-08-24 17:55:18','2021-08-24 17:55:18'),(1201,2973,337,40720,1539,19,10,1,385441.50,NULL,'2021-08-09 20:57:51','2021-08-24 17:55:18','2021-08-24 17:55:18'),(1202,2973,337,40720,1539,19,57,1,278871.57,NULL,'2021-08-09 20:57:51','2021-08-24 17:55:18','2021-08-24 17:55:18'),(1203,2973,337,40720,1539,19,74,1,92639.15,NULL,'2021-08-09 20:57:51','2021-08-24 17:55:18','2021-08-24 17:55:18'),(1204,2973,337,40720,1539,19,368,1,110000.00,NULL,'2021-08-09 20:57:51','2021-08-24 17:55:18','2021-08-24 17:55:18'),(1205,2973,337,40720,1539,19,395,1,110000.00,NULL,'2021-08-09 20:57:51','2021-08-24 17:55:18','2021-08-24 17:55:18'),(1206,2973,337,40720,1539,19,487,1,6401.98,NULL,'2021-08-09 20:57:51','2021-08-24 17:55:18','2021-08-24 17:55:18'),(1207,2973,337,40720,1539,19,396,1,1331.00,NULL,'2021-08-09 20:57:51','2021-08-24 17:55:18','2021-08-24 17:55:18'),(1208,2973,337,40720,1539,19,20,1,86345.97,NULL,'2021-08-09 20:57:51','2021-08-24 17:55:18','2021-08-24 17:55:18'),(1209,2973,337,40720,1539,19,13,2,385441.50,NULL,'2021-08-09 20:57:51','2021-08-24 17:55:18','2021-08-24 17:55:18'),(1210,2973,337,40720,1539,19,10,2,687957.32,NULL,'2021-08-09 20:57:51','2021-08-24 17:55:18','2021-08-24 17:55:18'),(1211,2973,338,40720,1540,19,251,1,214.80,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1212,2973,338,40720,1540,19,68,1,451.07,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1213,2973,338,40720,1540,19,483,1,2147.93,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1214,2973,338,40720,1540,19,57,2,2813.80,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1215,2973,339,40720,1540,19,217,1,231.62,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1216,2973,339,40720,1540,19,68,1,35.75,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1217,2973,339,40720,1540,19,57,2,267.37,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1218,2973,340,40720,1540,19,68,1,5313.00,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1219,2973,340,40720,1540,19,483,1,25300.00,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1220,2973,340,40720,1540,19,57,2,30613.00,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL);
INSERT INTO `balance_libro_details` VALUES (1221,2973,341,40720,1540,19,68,1,104.13,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1222,2973,341,40720,1540,19,483,1,495.87,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1223,2973,341,40720,1540,19,57,2,600.00,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1224,2973,342,40720,1540,19,57,1,600.00,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1225,2973,342,40720,1540,19,359,2,600.00,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1226,2973,343,40720,1540,19,221,1,648.22,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1227,2973,343,40720,1540,19,251,1,106.27,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1228,2973,343,40720,1540,19,484,1,2125.43,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1229,2973,343,40720,1540,19,68,1,446.34,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1230,2973,343,40720,1540,19,57,2,3326.26,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1231,2973,344,40720,1540,19,251,1,16.00,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1232,2973,344,40720,1540,19,68,1,84.00,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1233,2973,344,40720,1540,19,483,1,400.01,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1234,2973,344,40720,1540,19,57,2,500.01,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1235,2973,345,40720,1540,19,13,1,313371.26,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1236,2973,345,40720,1540,19,67,2,54386.75,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1237,2973,345,40720,1540,19,96,2,258984.51,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1238,2973,346,40720,1540,19,57,1,500.01,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1239,2973,346,40720,1540,19,359,2,500.01,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1240,2973,347,40720,1540,19,68,1,285.50,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1241,2973,347,40720,1540,19,484,1,1359.50,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1242,2973,347,40720,1540,19,57,2,1645.00,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1243,2973,348,40720,1540,19,217,1,2352.94,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1244,2973,348,40720,1540,19,68,1,247.06,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1245,2973,348,40720,1540,19,57,2,2600.00,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1246,2973,349,40720,1540,19,192,1,15000.00,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1247,2973,349,40720,1540,19,57,2,15000.00,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1248,2973,350,40720,1540,19,57,1,15000.00,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1249,2973,350,40720,1540,19,359,2,15000.00,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1250,2973,351,40720,1540,19,57,1,1645.00,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1251,2973,351,40720,1540,19,359,2,1645.00,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1252,2973,352,40720,1540,19,13,1,50700.00,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1253,2973,352,40720,1540,19,67,2,8799.17,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1254,2973,352,40720,1540,19,96,2,41900.83,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1255,2973,353,40720,1540,19,13,1,51273.75,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1256,2973,353,40720,1540,19,67,2,8898.75,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1257,2973,353,40720,1540,19,96,2,42375.00,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1258,2973,354,40720,1540,19,13,1,159200.00,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1259,2973,354,40720,1540,19,67,2,27629.75,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1260,2973,354,40720,1540,19,96,2,131570.25,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1261,2973,355,40720,1540,19,251,1,847.50,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL);
INSERT INTO `balance_libro_details` VALUES (1262,2973,355,40720,1540,19,13,2,847.50,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1263,2973,356,40720,1540,19,221,1,644.19,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1264,2973,356,40720,1540,19,251,1,105.61,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1265,2973,356,40720,1540,19,484,1,2112.23,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1266,2973,356,40720,1540,19,68,1,443.57,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1267,2973,356,40720,1540,19,57,2,3305.60,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1268,2973,357,40720,1540,19,484,1,2768.60,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1269,2973,357,40720,1540,19,68,1,581.41,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1270,2973,357,40720,1540,19,57,2,3350.01,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1271,2973,358,40720,1540,19,484,1,1250.00,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1272,2973,358,40720,1540,19,57,2,1250.00,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1273,2973,359,40720,1540,19,13,1,167049.58,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1274,2973,359,40720,1540,19,67,2,28992.08,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1275,2973,359,40720,1540,19,96,2,138057.50,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1276,2973,360,40720,1540,19,57,1,3350.00,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1277,2973,360,40720,1540,19,359,2,3350.00,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1278,2973,361,40720,1540,19,57,1,1250.00,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1279,2973,361,40720,1540,19,359,2,1250.00,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1280,2973,362,40720,1540,19,483,1,2504.31,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1281,2973,362,40720,1540,19,57,2,2504.31,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1282,2973,363,40720,1540,19,251,1,35.17,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1283,2973,363,40720,1540,19,217,1,879.28,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1284,2973,363,40720,1540,19,68,1,92.32,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1285,2973,363,40720,1540,19,57,2,1006.77,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1286,2973,364,40720,1540,19,13,1,66220.00,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1287,2973,364,40720,1540,19,67,2,11492.73,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1288,2973,364,40720,1540,19,96,2,54727.27,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1289,2973,365,40720,1540,19,57,1,1006.77,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1290,2973,365,40720,1540,19,359,2,1006.77,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1291,2973,366,40720,1540,19,221,1,539.98,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1292,2973,366,40720,1540,19,251,1,89.71,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1293,2973,366,40720,1540,19,484,1,1702.81,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1294,2973,366,40720,1540,19,68,1,357.59,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1295,2973,366,40720,1540,19,57,2,2690.09,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1296,2973,367,40720,1540,19,483,1,7650.00,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1297,2973,367,40720,1540,19,57,2,7650.00,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1298,2973,368,40720,1540,19,57,1,2690.09,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1299,2973,368,40720,1540,19,359,2,2690.09,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1300,2973,369,40720,1540,19,57,1,7650.00,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1301,2973,369,40720,1540,19,359,2,7650.00,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL),(1302,2973,370,40720,1540,19,251,1,216.46,NULL,'2021-08-09 20:57:51','2021-08-09 20:57:51',NULL);
INSERT INTO `balance_libro_details` VALUES (1303,2973,370,40720,1540,19,135,2,216.46,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1304,2973,371,40720,1540,19,156,1,24442.66,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1305,2973,371,40720,1540,19,311,1,8651.84,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1306,2973,371,40720,1540,19,251,2,4579.59,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1307,2973,371,40720,1540,19,311,2,8651.84,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1308,2973,371,40720,1540,19,486,2,8834.92,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1309,2973,371,40720,1540,19,301,2,11028.15,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1310,2973,372,40720,1540,19,67,1,151098.22,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1311,2973,372,40720,1540,19,68,2,11423.72,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1312,2973,372,40720,1540,19,74,2,139674.50,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1313,2973,373,40720,1540,19,251,1,568.00,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1314,2973,373,40720,1540,19,217,1,14199.93,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1315,2973,373,40720,1540,19,68,1,2981.99,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1316,2973,373,40720,1540,19,57,2,17749.92,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1317,2973,374,40720,1540,19,13,1,62799.00,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1318,2973,374,40720,1540,19,67,2,10899.00,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1319,2973,374,40720,1540,19,96,2,51900.00,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1320,2973,375,40720,1540,19,251,1,2380.07,NULL,'2021-08-09 20:57:52','2021-08-24 17:56:34','2021-08-24 17:56:34'),(1321,2973,375,40720,1540,19,10,1,702716.50,NULL,'2021-08-09 20:57:52','2021-08-24 17:56:34','2021-08-24 17:56:34'),(1322,2973,375,40720,1540,19,57,1,45019.86,NULL,'2021-08-09 20:57:52','2021-08-24 17:56:34','2021-08-24 17:56:34'),(1323,2973,375,40720,1540,19,74,1,36614.36,NULL,'2021-08-09 20:57:52','2021-08-24 17:56:34','2021-08-24 17:56:34'),(1324,2973,375,40720,1540,19,368,1,120000.00,NULL,'2021-08-09 20:57:52','2021-08-24 17:56:34','2021-08-24 17:56:34'),(1325,2973,375,40720,1540,19,395,1,120000.00,NULL,'2021-08-09 20:57:52','2021-08-24 17:56:34','2021-08-24 17:56:34'),(1326,2973,375,40720,1540,19,487,1,4803.96,NULL,'2021-08-09 20:57:52','2021-08-24 17:56:34','2021-08-24 17:56:34'),(1327,2973,375,40720,1540,19,396,1,1331.00,NULL,'2021-08-09 20:57:52','2021-08-24 17:56:34','2021-08-24 17:56:34'),(1328,2973,375,40720,1540,19,20,1,86345.97,NULL,'2021-08-09 20:57:52','2021-08-24 17:56:34','2021-08-24 17:56:34'),(1329,2973,375,40720,1540,19,10,2,416495.22,NULL,'2021-08-09 20:57:52','2021-08-24 17:56:34','2021-08-24 17:56:34'),(1330,2973,375,40720,1540,19,13,2,702716.50,NULL,'2021-08-09 20:57:52','2021-08-24 17:56:34','2021-08-24 17:56:34'),(1331,2973,376,40720,1541,19,251,1,150.36,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1332,2973,376,40720,1541,19,68,1,451.07,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1333,2973,376,40720,1541,19,483,1,2147.93,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1334,2973,376,40720,1541,19,57,2,2749.36,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1335,2973,377,40720,1541,19,23,1,15064.19,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1336,2973,377,40720,1541,19,135,1,47279.28,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1337,2973,377,40720,1541,19,135,1,12912.16,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1338,2973,377,40720,1541,19,57,2,75255.63,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1339,2973,378,40720,1541,19,484,1,413.97,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1340,2973,378,40720,1541,19,217,1,170.25,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL);
INSERT INTO `balance_libro_details` VALUES (1341,2973,378,40720,1541,19,68,1,35.75,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1342,2973,378,40720,1541,19,57,2,619.97,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1343,2973,379,40720,1541,19,136,1,1.90,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1344,2973,379,40720,1541,19,74,2,1.90,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1345,2973,380,40720,1541,19,68,1,5313.00,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1346,2973,380,40720,1541,19,483,1,25300.00,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1347,2973,380,40720,1541,19,57,2,30613.00,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1348,2973,381,40720,1541,19,484,1,75.38,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1349,2973,381,40720,1541,19,221,1,491.34,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1350,2973,381,40720,1541,19,251,1,118.01,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1351,2973,381,40720,1541,19,68,1,500.56,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1352,2973,381,40720,1541,19,128,1,2383.63,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1353,2973,381,40720,1541,19,57,2,3568.92,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1354,2973,382,40720,1541,19,251,1,16.33,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1355,2973,382,40720,1541,19,68,1,85.75,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1356,2973,382,40720,1541,19,483,1,408.34,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1357,2973,382,40720,1541,19,57,2,510.42,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1358,2973,383,40720,1541,19,13,1,467630.21,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1359,2973,383,40720,1541,19,67,2,81158.96,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1360,2973,383,40720,1541,19,96,2,386471.25,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1361,2973,384,40720,1541,19,13,1,62980.50,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1362,2973,384,40720,1541,19,67,2,10930.50,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1363,2973,384,40720,1541,19,96,2,52050.00,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1364,2973,385,40720,1541,19,13,1,78725.62,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1365,2973,385,40720,1541,19,67,2,13663.12,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1366,2973,385,40720,1541,19,96,2,65062.50,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1367,2973,386,40720,1541,19,251,1,74.14,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1368,2973,386,40720,1541,19,484,1,1853.40,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1369,2973,386,40720,1541,19,68,1,389.21,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1370,2973,386,40720,1541,19,57,2,2316.75,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1371,2973,387,40720,1541,19,251,1,2761.15,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1372,2973,387,40720,1541,19,23,1,1417.75,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1373,2973,387,40720,1541,19,13,2,4178.90,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1374,2973,388,40720,1541,19,251,1,1041.00,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1375,2973,388,40720,1541,19,13,2,1041.00,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1376,2973,389,40720,1541,19,13,1,187934.18,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1377,2973,389,40720,1541,19,67,2,32616.68,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1378,2973,389,40720,1541,19,96,2,155317.50,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1379,2973,390,40720,1541,19,484,1,76.69,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1380,2973,390,40720,1541,19,221,1,499.92,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1381,2973,390,40720,1541,19,251,1,126.32,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL);
INSERT INTO `balance_libro_details` VALUES (1382,2973,390,40720,1541,19,68,1,542.11,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1383,2973,390,40720,1541,19,128,1,2581.47,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1384,2973,390,40720,1541,19,57,2,3826.51,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1385,2973,391,40720,1541,19,217,1,15000.00,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1386,2973,391,40720,1541,19,57,2,15000.00,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1387,2973,392,40720,1541,19,57,1,15000.00,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1388,2973,392,40720,1541,19,359,2,15000.00,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1389,2973,393,40720,1541,19,68,1,21194.38,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1390,2973,393,40720,1541,19,484,1,100925.64,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1391,2973,393,40720,1541,19,57,2,122120.02,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1392,2973,394,40720,1541,19,484,1,42.72,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1393,2973,394,40720,1541,19,68,1,128.19,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1394,2973,394,40720,1541,19,483,1,610.36,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1395,2973,394,40720,1541,19,57,2,781.27,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1396,2973,395,40720,1541,19,484,1,28.96,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1397,2973,395,40720,1541,19,68,1,152.03,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1398,2973,395,40720,1541,19,483,1,723.97,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1399,2973,395,40720,1541,19,57,2,904.96,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1400,2973,396,40720,1541,19,251,1,3106.35,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1401,2973,396,40720,1541,19,23,1,3106.35,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1402,2973,396,40720,1541,19,13,2,6212.70,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1403,2973,397,40720,1541,19,251,1,113.35,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1404,2973,397,40720,1541,19,135,2,113.35,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1405,2973,398,40720,1541,19,421,1,175837.24,NULL,'2021-08-09 20:57:52','2021-08-28 12:31:26','2021-08-28 12:31:26'),(1406,2973,398,40720,1541,19,422,1,1312.22,NULL,'2021-08-09 20:57:52','2021-08-28 12:31:26','2021-08-28 12:31:26'),(1407,2973,398,40720,1541,19,415,2,1312.22,NULL,'2021-08-09 20:57:52','2021-08-28 12:31:26','2021-08-28 12:31:26'),(1408,2973,398,40720,1541,19,420,2,175837.24,NULL,'2021-08-09 20:57:52','2021-08-28 12:31:26','2021-08-28 12:31:26'),(1409,2973,399,40720,1541,19,156,1,22383.54,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1410,2973,399,40720,1541,19,311,1,8651.84,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1411,2973,399,40720,1541,19,311,2,8651.84,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1412,2973,399,40720,1541,19,486,2,9101.21,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1413,2973,399,40720,1541,19,251,2,13282.33,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1414,2973,400,40720,1541,19,67,1,138369.26,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1415,2973,400,40720,1541,19,68,2,28792.05,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1416,2973,400,40720,1541,19,74,2,109577.21,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1417,2973,401,40720,1541,19,155,1,350000.00,NULL,'2021-08-09 20:57:52','2021-08-28 14:00:48','2021-08-28 14:00:48'),(1418,2973,401,40720,1541,19,411,2,350000.00,NULL,'2021-08-09 20:57:52','2021-08-28 14:00:48','2021-08-28 14:00:48'),(1419,2973,402,40720,1541,19,135,1,637.72,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1420,2973,402,40720,1541,19,484,2,637.72,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL);
INSERT INTO `balance_libro_details` VALUES (1421,2973,403,40720,1541,19,484,1,8527.69,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1422,2973,403,40720,1541,19,221,2,8527.69,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1423,2973,404,40720,1541,19,96,1,5691882.91,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1424,2973,404,40720,1541,19,96,2,5691882.91,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1425,2973,405,40720,1541,19,136,1,0.02,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1426,2973,405,40720,1541,19,57,1,0.27,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1427,2973,405,40720,1541,19,68,1,1.79,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1428,2973,405,40720,1541,19,13,2,0.02,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1429,2973,405,40720,1541,19,136,2,2.06,NULL,'2021-08-09 20:57:52','2021-08-09 20:57:52',NULL),(1430,2973,406,40720,1541,19,251,1,5775.32,NULL,'2021-08-09 20:57:52','2021-08-24 17:57:25','2021-08-24 17:57:25'),(1431,2973,406,40720,1541,19,10,1,954662.48,NULL,'2021-08-09 20:57:52','2021-08-24 17:57:25','2021-08-24 17:57:25'),(1432,2973,406,40720,1541,19,359,1,20000.00,NULL,'2021-08-09 20:57:52','2021-08-24 17:57:25','2021-08-24 17:57:25'),(1433,2973,406,40720,1541,19,57,1,262386.02,NULL,'2021-08-09 20:57:52','2021-08-24 17:57:25','2021-08-24 17:57:25'),(1434,2973,406,40720,1541,19,74,1,139674.50,NULL,'2021-08-09 20:57:53','2021-08-24 17:57:25','2021-08-24 17:57:25'),(1435,2973,406,40720,1541,19,368,1,200000.00,NULL,'2021-08-09 20:57:53','2021-08-24 17:57:25','2021-08-24 17:57:25'),(1436,2973,406,40720,1541,19,395,1,200000.00,NULL,'2021-08-09 20:57:53','2021-08-24 17:57:25','2021-08-24 17:57:25'),(1437,2973,406,40720,1541,19,487,1,11370.24,NULL,'2021-08-09 20:57:53','2021-08-24 17:57:25','2021-08-24 17:57:25'),(1438,2973,406,40720,1541,19,396,1,1754.50,NULL,'2021-08-09 20:57:53','2021-08-24 17:57:25','2021-08-24 17:57:25'),(1439,2973,406,40720,1541,19,20,1,86345.97,NULL,'2021-08-09 20:57:53','2021-08-24 17:57:25','2021-08-24 17:57:25'),(1440,2973,406,40720,1541,19,448,1,26416.27,NULL,'2021-08-09 20:57:53','2021-08-24 17:57:25','2021-08-24 17:57:25'),(1441,2973,406,40720,1541,19,467,1,1197.54,NULL,'2021-08-09 20:57:53','2021-08-24 17:57:25','2021-08-24 17:57:25'),(1442,2973,406,40720,1541,19,396,2,1774.99,NULL,'2021-08-09 20:57:53','2021-08-24 17:57:25','2021-08-24 17:57:25'),(1443,2973,406,40720,1541,19,13,2,952887.49,NULL,'2021-08-09 20:57:53','2021-08-24 17:57:25','2021-08-24 17:57:25'),(1444,2973,406,40720,1541,19,10,2,954920.36,NULL,'2021-08-09 20:57:53','2021-08-24 17:57:25','2021-08-24 17:57:25'),(1445,2973,407,40722,3057,2,96,2,493.41,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1446,2973,407,40722,3057,2,67,2,103.62,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1447,2973,407,40722,3057,2,13,1,597.03,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1448,2973,408,40722,3057,2,96,2,3160.92,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1449,2973,408,40722,3057,2,67,2,663.79,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1450,2973,408,40722,3057,2,13,1,3824.71,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1451,2973,409,40722,3057,2,96,2,1958.44,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1452,2973,409,40722,3057,2,67,2,411.27,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1453,2973,409,40722,3057,2,13,1,2369.71,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1454,2973,410,40722,3057,2,96,2,3217.83,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1455,2973,410,40722,3057,2,67,2,675.75,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1456,2973,410,40722,3057,2,13,1,3893.58,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1457,2973,411,40722,3057,2,96,2,3217.83,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1458,2973,411,40722,3057,2,67,2,675.75,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL);
INSERT INTO `balance_libro_details` VALUES (1459,2973,411,40722,3057,2,13,1,3893.58,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1460,2973,412,40722,3057,2,96,2,6725.87,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1461,2973,412,40722,3057,2,67,2,1412.43,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1462,2973,412,40722,3057,2,13,1,8138.30,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1463,2973,413,40722,3057,2,96,2,3160.92,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1464,2973,413,40722,3057,2,67,2,663.79,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1465,2973,413,40722,3057,2,13,1,3824.71,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1466,2973,414,40722,3057,2,96,2,2499.17,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1467,2973,414,40722,3057,2,67,2,524.83,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1468,2973,414,40722,3057,2,13,1,3024.00,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1469,2973,415,40722,3057,2,96,2,1082.64,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1470,2973,415,40722,3057,2,67,2,227.36,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1471,2973,415,40722,3057,2,13,1,1310.00,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1472,2973,416,40722,3057,2,96,2,922.70,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1473,2973,416,40722,3057,2,67,2,193.77,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1474,2973,416,40722,3057,2,13,1,1116.47,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1475,2973,417,40722,3057,2,96,2,3186.34,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1476,2973,417,40722,3057,2,67,2,669.13,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1477,2973,417,40722,3057,2,13,1,3855.47,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1478,2973,418,40722,3057,2,96,2,708.74,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1479,2973,418,40722,3057,2,67,2,148.84,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1480,2973,418,40722,3057,2,13,1,857.58,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1481,2973,419,40722,3057,2,96,2,1958.44,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1482,2973,419,40722,3057,2,67,2,411.27,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1483,2973,419,40722,3057,2,13,1,2369.71,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1484,2973,420,40722,3057,2,96,2,3641.11,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1485,2973,420,40722,3057,2,67,2,764.63,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1486,2973,420,40722,3057,2,13,1,4405.74,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1487,2973,421,40722,3057,2,96,2,6234.84,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1488,2973,421,40722,3057,2,67,2,1309.32,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1489,2973,421,40722,3057,2,13,1,7544.16,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1490,2973,422,40722,3057,2,96,2,2162.06,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1491,2973,422,40722,3057,2,67,2,454.03,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1492,2973,422,40722,3057,2,13,1,2616.09,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1493,2973,423,40722,3057,2,96,2,920.00,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1494,2973,423,40722,3057,2,67,2,193.20,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1495,2973,423,40722,3057,2,13,1,1113.20,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1496,2973,424,40722,3057,2,96,2,2205.35,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1497,2973,424,40722,3057,2,67,2,463.12,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1498,2973,424,40722,3057,2,13,1,2668.47,NULL,'2021-08-10 17:28:17','2021-08-10 17:28:17',NULL),(1499,2973,425,40722,3057,2,96,2,1704.31,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL);
INSERT INTO `balance_libro_details` VALUES (1500,2973,425,40722,3057,2,67,2,357.91,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1501,2973,425,40722,3057,2,13,1,2062.22,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1502,2973,426,40722,3057,2,96,2,2990.46,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1503,2973,426,40722,3057,2,67,2,628.00,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1504,2973,426,40722,3057,2,13,1,3618.46,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1505,2973,427,40722,3057,2,96,2,264.46,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1506,2973,427,40722,3057,2,67,2,55.54,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1507,2973,427,40722,3057,2,13,1,320.00,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1508,2973,428,40722,3057,2,96,2,1377.24,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1509,2973,428,40722,3057,2,67,2,289.22,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1510,2973,428,40722,3057,2,13,1,1666.46,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1511,2973,429,40722,3057,2,96,2,1920.76,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1512,2973,429,40722,3057,2,67,2,403.36,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1513,2973,429,40722,3057,2,13,1,2324.12,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1514,2973,430,40722,3057,2,96,2,297.52,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1515,2973,430,40722,3057,2,67,2,62.48,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1516,2973,430,40722,3057,2,13,1,360.00,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1517,2973,431,40722,3057,2,96,2,1018.31,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1518,2973,431,40722,3057,2,67,2,213.84,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1519,2973,431,40722,3057,2,13,1,1232.15,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1520,2973,432,40722,3057,2,96,2,884.07,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1521,2973,432,40722,3057,2,67,2,185.66,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1522,2973,432,40722,3057,2,13,1,1069.73,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1523,2973,433,40722,3057,2,96,2,3162.52,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1524,2973,433,40722,3057,2,67,2,664.13,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1525,2973,433,40722,3057,2,13,1,3826.65,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1526,2973,434,40722,3057,2,96,2,2408.24,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1527,2973,434,40722,3057,2,67,2,505.73,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1528,2973,434,40722,3057,2,13,1,2913.97,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1529,2973,435,40722,3057,2,96,2,1644.17,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1530,2973,435,40722,3057,2,67,2,172.64,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1531,2973,435,40722,3057,2,13,1,1816.81,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1532,2973,436,40722,3057,2,96,2,2082.69,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1533,2973,436,40722,3057,2,67,2,437.37,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1534,2973,436,40722,3057,2,13,1,2520.06,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1535,2973,437,40722,3057,2,96,2,194.21,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1536,2973,437,40722,3057,2,67,2,40.79,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1537,2973,437,40722,3057,2,13,1,235.00,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1538,2973,438,40722,3057,2,96,2,2591.74,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1539,2973,438,40722,3057,2,67,2,544.27,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1540,2973,438,40722,3057,2,13,1,3136.01,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL);
INSERT INTO `balance_libro_details` VALUES (1541,2973,439,40722,3057,2,96,2,532.30,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1542,2973,439,40722,3057,2,67,2,111.78,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1543,2973,439,40722,3057,2,13,1,644.08,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1544,2973,440,40722,3057,2,96,2,856.16,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1545,2973,440,40722,3057,2,67,2,179.79,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1546,2973,440,40722,3057,2,13,1,1035.95,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1547,2973,441,40722,3057,2,96,2,1170.91,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1548,2973,441,40722,3057,2,67,2,245.89,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1549,2973,441,40722,3057,2,13,1,1416.80,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1550,2973,442,40722,3057,2,96,2,3178.55,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1551,2973,442,40722,3057,2,67,2,667.50,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1552,2973,442,40722,3057,2,13,1,3846.05,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1553,2973,443,40722,3057,2,96,2,479.24,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1554,2973,443,40722,3057,2,67,2,100.64,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1555,2973,443,40722,3057,2,13,1,579.88,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1556,2973,444,40722,3057,2,96,2,3212.22,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1557,2973,444,40722,3057,2,67,2,674.57,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1558,2973,444,40722,3057,2,13,1,3886.79,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1559,2973,445,40722,3057,2,96,2,6725.87,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1560,2973,445,40722,3057,2,67,2,1412.43,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1561,2973,445,40722,3057,2,13,1,8138.30,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1562,2973,446,40722,3057,2,96,2,2752.07,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1563,2973,446,40722,3057,2,67,2,577.93,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1564,2973,446,40722,3057,2,13,1,3330.00,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1565,2973,447,40722,3057,2,96,2,1318.08,NULL,'2021-08-10 17:28:18','2021-08-10 17:28:18',NULL),(1566,2973,447,40722,3057,2,67,2,276.80,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1567,2973,447,40722,3057,2,13,1,1594.88,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1568,2973,448,40722,3057,2,96,2,1175.33,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1569,2973,448,40722,3057,2,67,2,246.82,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1570,2973,448,40722,3057,2,13,1,1422.15,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1571,2973,449,40722,3057,2,96,2,1445.25,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1572,2973,449,40722,3057,2,67,2,303.50,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1573,2973,449,40722,3057,2,13,1,1748.75,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1574,2973,450,40722,3057,2,96,2,3257.12,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1575,2973,450,40722,3057,2,67,2,683.99,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1576,2973,450,40722,3057,2,13,1,3941.11,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1577,2973,451,40722,3057,2,96,2,636.36,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1578,2973,451,40722,3057,2,67,2,133.64,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1579,2973,451,40722,3057,2,13,1,770.00,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1580,2973,452,40722,3057,2,96,2,4288.04,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1581,2973,452,40722,3057,2,67,2,900.49,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL);
INSERT INTO `balance_libro_details` VALUES (1582,2973,452,40722,3057,2,13,1,5188.53,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1583,2973,453,40722,3057,2,96,2,890.74,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1584,2973,453,40722,3057,2,67,2,187.06,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1585,2973,453,40722,3057,2,13,1,1077.80,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1586,2973,454,40722,3057,2,96,2,2183.70,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1587,2973,454,40722,3057,2,67,2,458.58,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1588,2973,454,40722,3057,2,13,1,2642.28,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1589,2973,455,40722,3057,2,96,2,602.04,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1590,2973,455,40722,3057,2,67,2,126.43,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1591,2973,455,40722,3057,2,13,1,728.47,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1592,2973,456,40722,3057,2,96,2,602.04,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1593,2973,456,40722,3057,2,67,2,126.43,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1594,2973,456,40722,3057,2,13,1,728.47,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1595,2973,457,40722,3057,2,96,2,1149.57,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1596,2973,457,40722,3057,2,67,2,241.41,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1597,2973,457,40722,3057,2,13,1,1390.98,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1598,2973,458,40722,3057,2,96,2,1452.07,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1599,2973,458,40722,3057,2,67,2,304.93,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1600,2973,458,40722,3057,2,13,1,1757.00,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1601,2973,459,40722,3057,2,96,2,717.48,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1602,2973,459,40722,3057,2,67,2,150.67,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1603,2973,459,40722,3057,2,13,1,868.15,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1604,2973,460,40722,3057,2,96,2,1641.79,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1605,2973,460,40722,3057,2,67,2,344.77,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1606,2973,460,40722,3057,2,13,1,1986.56,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1607,2973,461,40722,3057,2,96,2,1355.60,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1608,2973,461,40722,3057,2,67,2,284.67,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1609,2973,461,40722,3057,2,13,1,1640.27,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1610,2973,462,40722,3057,2,96,2,2462.68,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1611,2973,462,40722,3057,2,67,2,517.16,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1612,2973,462,40722,3057,2,13,1,2979.84,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1613,2973,463,40722,3057,2,96,2,1261.87,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1614,2973,463,40722,3057,2,67,2,264.99,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1615,2973,463,40722,3057,2,13,1,1526.86,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1616,2973,464,40722,3057,2,96,2,3292.28,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1617,2973,464,40722,3057,2,67,2,691.38,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1618,2973,464,40722,3057,2,13,1,3983.66,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1619,2973,465,40722,3057,2,96,2,1845.40,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1620,2973,465,40722,3057,2,67,2,387.54,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1621,2973,465,40722,3057,2,13,1,2232.94,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1622,2973,466,40722,3057,2,96,2,1922.36,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL);
INSERT INTO `balance_libro_details` VALUES (1623,2973,466,40722,3057,2,67,2,403.70,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1624,2973,466,40722,3057,2,13,1,2326.06,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1625,2973,467,40722,3057,2,96,2,905.16,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1626,2973,467,40722,3057,2,67,2,190.08,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1627,2973,467,40722,3057,2,13,1,1095.24,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1628,2973,468,40722,3057,2,96,2,2323.19,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1629,2973,468,40722,3057,2,67,2,487.87,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1630,2973,468,40722,3057,2,13,1,2811.06,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1631,2973,469,40722,3057,2,96,2,2562.53,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1632,2973,469,40722,3057,2,67,2,538.13,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1633,2973,469,40722,3057,2,13,1,3100.66,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1634,2973,470,40722,3057,2,96,2,3360.33,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1635,2973,470,40722,3057,2,67,2,705.67,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1636,2973,470,40722,3057,2,13,1,4066.00,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1637,2973,471,40722,3057,2,96,2,6751.28,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1638,2973,471,40722,3057,2,67,2,1417.77,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1639,2973,471,40722,3057,2,13,1,8169.05,NULL,'2021-08-10 17:28:19','2021-08-10 17:28:19',NULL),(1640,2973,472,40722,3057,2,96,2,939.54,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1641,2973,472,40722,3057,2,67,2,197.30,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1642,2973,472,40722,3057,2,13,1,1136.84,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1643,2973,473,40722,3057,2,96,2,710.81,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1644,2973,473,40722,3057,2,67,2,149.27,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1645,2973,473,40722,3057,2,13,1,860.08,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1646,2973,474,40722,3057,2,96,2,1308.30,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1647,2973,474,40722,3057,2,67,2,274.74,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1648,2973,474,40722,3057,2,13,1,1583.04,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1649,2973,475,40722,3057,2,96,2,2363.71,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1650,2973,475,40722,3057,2,67,2,496.38,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1651,2973,475,40722,3057,2,13,1,2860.09,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1652,2973,476,40722,3057,2,96,2,367.77,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1653,2973,476,40722,3057,2,67,2,77.23,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1654,2973,476,40722,3057,2,13,1,445.00,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1655,2973,477,40722,3057,2,96,2,1964.46,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1656,2973,477,40722,3057,2,67,2,412.54,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1657,2973,477,40722,3057,2,13,1,2377.00,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1658,2973,478,40722,3057,2,96,2,1030.00,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1659,2973,478,40722,3057,2,67,2,216.30,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1660,2973,478,40722,3057,2,13,1,1246.30,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1661,2973,479,40722,3057,2,96,2,4504.49,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1662,2973,479,40722,3057,2,67,2,945.94,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1663,2973,479,40722,3057,2,13,1,5450.43,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL);
INSERT INTO `balance_libro_details` VALUES (1664,2973,480,40722,3057,2,96,2,737.65,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1665,2973,480,40722,3057,2,67,2,77.45,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1666,2973,480,40722,3057,2,13,1,815.10,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1667,2973,481,40722,3057,2,96,2,3239.42,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1668,2973,481,40722,3057,2,67,2,680.28,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1669,2973,481,40722,3057,2,13,1,3919.70,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1670,2973,482,40722,3057,2,96,2,708.74,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1671,2973,482,40722,3057,2,67,2,148.84,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1672,2973,482,40722,3057,2,13,1,857.58,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1673,2973,483,40722,3057,2,96,2,636.36,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1674,2973,483,40722,3057,2,67,2,133.64,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1675,2973,483,40722,3057,2,13,1,770.00,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1676,2973,484,40722,3057,2,96,2,613.33,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1677,2973,484,40722,3057,2,67,2,128.80,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1678,2973,484,40722,3057,2,13,1,742.13,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1679,2973,485,40722,3057,2,96,2,876.32,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1680,2973,485,40722,3057,2,67,2,184.03,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1681,2973,485,40722,3057,2,13,1,1060.35,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1682,2973,486,40722,3057,2,96,2,2112.50,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1683,2973,486,40722,3057,2,67,2,443.62,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1684,2973,486,40722,3057,2,13,1,2556.12,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1685,2973,487,40722,3057,2,96,2,2023.37,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1686,2973,487,40722,3057,2,67,2,424.91,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1687,2973,487,40722,3057,2,13,1,2448.28,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1688,2973,488,40722,3057,2,96,2,1444.55,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1689,2973,488,40722,3057,2,67,2,303.35,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1690,2973,488,40722,3057,2,13,1,1747.90,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1691,2973,489,40722,3057,2,96,2,1099.55,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1692,2973,489,40722,3057,2,67,2,230.90,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1693,2973,489,40722,3057,2,13,1,1330.45,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1694,2973,490,40722,3057,2,96,2,915.06,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1695,2973,490,40722,3057,2,67,2,192.16,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1696,2973,490,40722,3057,2,13,1,1107.22,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1697,2973,491,40722,3057,2,96,2,2117.64,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1698,2973,491,40722,3057,2,67,2,444.70,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1699,2973,491,40722,3057,2,13,1,2562.34,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1700,2973,492,40722,3057,2,96,2,899.27,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1701,2973,492,40722,3057,2,67,2,188.85,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1702,2973,492,40722,3057,2,13,1,1088.12,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1703,2973,493,40722,3057,2,96,2,602.04,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1704,2973,493,40722,3057,2,67,2,126.43,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1705,2973,493,40722,3057,2,13,1,728.47,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL);
INSERT INTO `balance_libro_details` VALUES (1706,2973,494,40722,3057,2,96,2,1376.57,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1707,2973,494,40722,3057,2,67,2,289.09,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1708,2973,494,40722,3057,2,13,1,1665.66,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1709,2973,495,40722,3057,2,96,2,1170.91,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1710,2973,495,40722,3057,2,67,2,245.89,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1711,2973,495,40722,3057,2,13,1,1416.80,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1712,2973,496,40722,3057,2,96,2,3541.32,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1713,2973,496,40722,3057,2,67,2,743.68,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1714,2973,496,40722,3057,2,13,1,4285.00,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1715,2973,497,40722,3057,2,96,2,2381.78,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1716,2973,497,40722,3057,2,67,2,500.17,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1717,2973,497,40722,3057,2,13,1,2881.95,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1718,2973,498,40722,3057,2,96,2,603.31,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1719,2973,498,40722,3057,2,67,2,126.69,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1720,2973,498,40722,3057,2,13,1,730.00,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1721,2973,499,40722,3057,2,96,2,1879.07,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1722,2973,499,40722,3057,2,67,2,394.61,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1723,2973,499,40722,3057,2,13,1,2273.68,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1724,2973,500,40722,3057,2,96,2,3671.79,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1725,2973,500,40722,3057,2,67,2,771.08,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1726,2973,500,40722,3057,2,13,1,4442.87,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1727,2973,501,40722,3057,2,96,2,2361.82,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1728,2973,501,40722,3057,2,67,2,495.98,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1729,2973,501,40722,3057,2,13,1,2857.80,NULL,'2021-08-10 17:28:20','2021-08-10 17:28:20',NULL),(1730,2973,502,40722,3057,2,96,2,1041.27,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1731,2973,502,40722,3057,2,67,2,218.67,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1732,2973,502,40722,3057,2,13,1,1259.94,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1733,2973,503,40722,3057,2,96,2,686.60,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1734,2973,503,40722,3057,2,67,2,144.18,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1735,2973,503,40722,3057,2,13,1,830.78,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1736,2973,504,40722,3057,2,96,2,12801.50,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1737,2973,504,40722,3057,2,67,2,2688.31,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1738,2973,504,40722,3057,2,13,1,15489.81,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1739,2973,505,40722,3057,2,96,2,2212.08,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1740,2973,505,40722,3057,2,67,2,464.54,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1741,2973,505,40722,3057,2,13,1,2676.62,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1742,2973,506,40722,3057,2,96,2,2048.22,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1743,2973,506,40722,3057,2,67,2,430.13,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1744,2973,506,40722,3057,2,13,1,2478.35,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1745,2973,507,40722,3057,2,96,2,333.64,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1746,2973,507,40722,3057,2,67,2,70.06,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL);
INSERT INTO `balance_libro_details` VALUES (1747,2973,507,40722,3057,2,13,1,403.70,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1748,2973,508,40722,3057,2,96,2,353.45,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1749,2973,508,40722,3057,2,67,2,74.23,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1750,2973,508,40722,3057,2,13,1,427.68,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1751,2973,509,40722,3057,2,96,2,859.73,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1752,2973,509,40722,3057,2,67,2,180.54,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1753,2973,509,40722,3057,2,13,1,1040.27,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1754,2973,510,40722,3057,2,96,2,5672.73,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1755,2973,510,40722,3057,2,67,2,1191.27,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1756,2973,510,40722,3057,2,13,1,6864.00,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1757,2973,511,40722,3057,2,96,2,1472.73,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1758,2973,511,40722,3057,2,67,2,309.27,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1759,2973,511,40722,3057,2,13,1,1782.00,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1760,2973,512,40722,3057,2,96,2,2115.12,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1761,2973,512,40722,3057,2,67,2,444.17,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1762,2973,512,40722,3057,2,13,1,2559.29,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1763,2973,513,40722,3057,2,96,2,3002.99,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1764,2973,513,40722,3057,2,67,2,630.63,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1765,2973,513,40722,3057,2,13,1,3633.62,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1766,2973,514,40722,3057,2,96,2,865.79,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1767,2973,514,40722,3057,2,67,2,181.81,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1768,2973,514,40722,3057,2,13,1,1047.60,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1769,2973,515,40722,3057,2,96,2,2212.08,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1770,2973,515,40722,3057,2,67,2,464.54,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1771,2973,515,40722,3057,2,13,1,2676.62,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1772,2973,516,40722,3057,2,96,2,1245.00,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1773,2973,516,40722,3057,2,67,2,261.45,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1774,2973,516,40722,3057,2,13,1,1506.45,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1775,2973,517,40722,3057,2,96,2,976.96,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1776,2973,517,40722,3057,2,67,2,205.16,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1777,2973,517,40722,3057,2,13,1,1182.12,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1778,2973,518,40722,3057,2,96,2,1127.93,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1779,2973,518,40722,3057,2,67,2,236.86,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1780,2973,518,40722,3057,2,13,1,1364.79,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1781,2973,519,40722,3057,2,96,2,1823.35,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1782,2973,519,40722,3057,2,67,2,382.90,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1783,2973,519,40722,3057,2,13,1,2206.25,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1784,2973,520,40722,3057,2,96,2,281.57,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1785,2973,520,40722,3057,2,67,2,59.13,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1786,2973,520,40722,3057,2,13,1,340.70,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1787,2973,521,40722,3057,2,96,2,876.32,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL);
INSERT INTO `balance_libro_details` VALUES (1788,2973,521,40722,3057,2,67,2,184.03,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1789,2973,521,40722,3057,2,13,1,1060.35,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1790,2973,522,40722,3057,2,96,2,1099.55,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1791,2973,522,40722,3057,2,67,2,230.90,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1792,2973,522,40722,3057,2,13,1,1330.45,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1793,2973,523,40722,3057,2,96,2,1211.27,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1794,2973,523,40722,3057,2,67,2,254.37,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1795,2973,523,40722,3057,2,13,1,1465.64,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1796,2973,524,40722,3057,2,96,2,3050.00,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1797,2973,524,40722,3057,2,67,2,640.50,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1798,2973,524,40722,3057,2,13,1,3690.50,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1799,2973,525,40722,3057,2,96,2,1018.31,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1800,2973,525,40722,3057,2,67,2,213.84,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1801,2973,525,40722,3057,2,13,1,1232.15,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1802,2973,526,40722,3057,2,96,2,1719.45,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1803,2973,526,40722,3057,2,67,2,361.09,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1804,2973,526,40722,3057,2,13,1,2080.54,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1805,2973,527,40722,3057,2,96,2,2335.02,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1806,2973,527,40722,3057,2,67,2,490.36,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1807,2973,527,40722,3057,2,13,1,2825.38,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1808,2973,528,40722,3057,2,96,2,823.64,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1809,2973,528,40722,3057,2,67,2,172.96,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1810,2973,528,40722,3057,2,13,1,996.60,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1811,2973,529,40722,3057,2,96,2,876.32,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1812,2973,529,40722,3057,2,67,2,184.03,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1813,2973,529,40722,3057,2,13,1,1060.35,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1814,2973,530,40722,3057,2,96,2,571.90,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1815,2973,530,40722,3057,2,67,2,120.10,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1816,2973,530,40722,3057,2,13,1,692.00,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1817,2973,531,40722,3057,2,96,2,1891.92,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1818,2973,531,40722,3057,2,67,2,397.30,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1819,2973,531,40722,3057,2,13,1,2289.22,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1820,2973,532,40722,3057,2,96,2,7643.15,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1821,2973,532,40722,3057,2,67,2,1605.06,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1822,2973,532,40722,3057,2,13,1,9248.21,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1823,2973,533,40722,3057,2,96,2,5672.73,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1824,2973,533,40722,3057,2,67,2,1191.27,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1825,2973,533,40722,3057,2,13,1,6864.00,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1826,2973,534,40722,3057,2,96,2,2304.40,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1827,2973,534,40722,3057,2,67,2,483.93,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL),(1828,2973,534,40722,3057,2,13,1,2788.33,NULL,'2021-08-10 17:28:21','2021-08-10 17:28:21',NULL);
INSERT INTO `balance_libro_details` VALUES (1829,2973,535,40722,3057,2,96,2,3347.93,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1830,2973,535,40722,3057,2,67,2,703.07,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1831,2973,535,40722,3057,2,13,1,4051.00,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1832,2973,536,40722,3057,2,96,2,176.73,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1833,2973,536,40722,3057,2,67,2,37.11,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1834,2973,536,40722,3057,2,13,1,213.84,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1835,2973,537,40722,3057,2,96,2,1366.63,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1836,2973,537,40722,3057,2,67,2,286.99,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1837,2973,537,40722,3057,2,13,1,1653.62,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1838,2973,538,40722,3057,2,96,2,2080.00,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1839,2973,538,40722,3057,2,67,2,436.80,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1840,2973,538,40722,3057,2,13,1,2516.80,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1841,2973,539,40722,3057,2,96,2,313.64,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1842,2973,539,40722,3057,2,67,2,65.86,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1843,2973,539,40722,3057,2,13,1,379.50,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1844,2973,540,40722,3057,2,96,2,1406.61,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1845,2973,540,40722,3057,2,67,2,295.39,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1846,2973,540,40722,3057,2,13,1,1702.00,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1847,2973,541,40722,3057,2,96,2,1685.67,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1848,2973,541,40722,3057,2,67,2,353.99,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1849,2973,541,40722,3057,2,13,1,2039.66,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1850,2973,542,40722,3057,2,96,2,4592.31,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1851,2973,542,40722,3057,2,67,2,964.39,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1852,2973,542,40722,3057,2,13,1,5556.70,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1853,2973,543,40722,3057,2,96,2,809.09,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1854,2973,543,40722,3057,2,67,2,169.91,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1855,2973,543,40722,3057,2,13,1,979.00,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1856,2973,544,40722,3057,2,96,2,1097.74,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1857,2973,544,40722,3057,2,67,2,230.52,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1858,2973,544,40722,3057,2,13,1,1328.26,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1859,2973,545,40722,3057,2,96,2,1832.22,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1860,2973,545,40722,3057,2,67,2,384.77,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1861,2973,545,40722,3057,2,13,1,2216.99,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1862,2973,546,40722,3057,2,96,2,876.32,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1863,2973,546,40722,3057,2,67,2,184.03,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1864,2973,546,40722,3057,2,13,1,1060.35,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1865,2973,547,40722,3057,2,96,2,1064.58,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1866,2973,547,40722,3057,2,67,2,223.56,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1867,2973,547,40722,3057,2,13,1,1288.14,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1868,2973,548,40722,3057,2,96,2,708.74,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1869,2973,548,40722,3057,2,67,2,148.84,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL);
INSERT INTO `balance_libro_details` VALUES (1870,2973,548,40722,3057,2,13,1,857.58,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1871,2973,549,40722,3057,2,96,2,1012.96,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1872,2973,549,40722,3057,2,67,2,212.72,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1873,2973,549,40722,3057,2,13,1,1225.68,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1874,2973,550,40722,3057,2,96,2,7247.48,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1875,2973,550,40722,3057,2,67,2,1521.97,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1876,2973,550,40722,3057,2,13,1,8769.45,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1877,2973,551,40722,3057,2,96,2,3357.97,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1878,2973,551,40722,3057,2,67,2,705.17,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1879,2973,551,40722,3057,2,13,1,4063.14,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1880,2973,552,40722,3057,2,96,2,1419.40,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1881,2973,552,40722,3057,2,67,2,298.07,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1882,2973,552,40722,3057,2,13,1,1717.47,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1883,2973,553,40722,3057,2,96,2,439.67,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1884,2973,553,40722,3057,2,67,2,92.33,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1885,2973,553,40722,3057,2,13,1,532.00,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1886,2973,554,40722,3057,2,96,2,439.67,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1887,2973,554,40722,3057,2,67,2,92.33,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1888,2973,554,40722,3057,2,13,1,532.00,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1889,2973,555,40722,3057,2,96,2,730.58,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1890,2973,555,40722,3057,2,67,2,153.42,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1891,2973,555,40722,3057,2,13,1,884.00,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1892,2973,556,40722,3057,2,96,2,704.13,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1893,2973,556,40722,3057,2,67,2,147.87,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1894,2973,556,40722,3057,2,13,1,852.00,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1895,2973,557,40722,3057,2,96,2,730.58,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1896,2973,557,40722,3057,2,67,2,153.42,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1897,2973,557,40722,3057,2,13,1,884.00,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1898,2973,558,40722,3057,2,96,2,2352.89,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1899,2973,558,40722,3057,2,67,2,494.11,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1900,2973,558,40722,3057,2,13,1,2847.00,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1901,2973,559,40722,3057,2,96,2,789.26,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1902,2973,559,40722,3057,2,67,2,165.74,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1903,2973,559,40722,3057,2,13,1,955.00,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1904,2973,560,40722,3057,2,96,2,2266.12,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1905,2973,560,40722,3057,2,67,2,475.88,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1906,2973,560,40722,3057,2,13,1,2742.00,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1907,2973,561,40722,3057,2,96,2,2968.60,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1908,2973,561,40722,3057,2,67,2,623.40,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1909,2973,561,40722,3057,2,13,1,3592.00,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1910,2973,562,40722,3057,2,96,2,953.72,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1911,2973,562,40722,3057,2,67,2,200.28,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL);
INSERT INTO `balance_libro_details` VALUES (1912,2973,562,40722,3057,2,13,1,1154.00,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1913,2973,563,40722,3057,2,96,2,4109.09,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1914,2973,563,40722,3057,2,67,2,862.91,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1915,2973,563,40722,3057,2,13,1,4972.00,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1916,2973,564,40722,3057,2,96,2,1111.57,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1917,2973,564,40722,3057,2,67,2,233.43,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1918,2973,564,40722,3057,2,13,1,1345.00,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1919,2973,565,40722,3057,2,96,2,439.67,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1920,2973,565,40722,3057,2,67,2,92.33,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1921,2973,565,40722,3057,2,13,1,532.00,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1922,2973,566,40722,3057,2,96,2,2819.83,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1923,2973,566,40722,3057,2,67,2,592.17,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1924,2973,566,40722,3057,2,13,1,3412.00,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1925,2973,567,40722,3057,2,96,2,1080.99,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1926,2973,567,40722,3057,2,67,2,227.01,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1927,2973,567,40722,3057,2,13,1,1308.00,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1928,2973,568,40722,3057,2,96,2,890.91,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1929,2973,568,40722,3057,2,67,2,187.09,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1930,2973,568,40722,3057,2,13,1,1078.00,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1931,2973,569,40722,3057,2,96,2,1371.07,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1932,2973,569,40722,3057,2,67,2,287.93,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1933,2973,569,40722,3057,2,13,1,1659.00,NULL,'2021-08-10 17:28:22','2021-08-10 17:28:22',NULL),(1934,2973,570,40722,3057,2,96,2,5417.36,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1935,2973,570,40722,3057,2,67,2,1137.64,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1936,2973,570,40722,3057,2,13,1,6555.00,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1937,2973,571,40722,3057,2,96,2,2238.02,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1938,2973,571,40722,3057,2,67,2,469.98,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1939,2973,571,40722,3057,2,13,1,2708.00,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1940,2973,572,40722,3057,2,96,2,730.58,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1941,2973,572,40722,3057,2,67,2,153.42,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1942,2973,572,40722,3057,2,13,1,884.00,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1943,2973,573,40722,3057,2,96,2,1674.79,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1944,2973,573,40722,3057,2,67,2,351.71,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1945,2973,573,40722,3057,2,13,1,2026.50,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1946,2973,574,40722,3057,2,96,2,736.36,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1947,2973,574,40722,3057,2,67,2,154.64,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1948,2973,574,40722,3057,2,13,1,891.00,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1949,2973,575,40722,3057,2,96,2,1868.18,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1950,2973,575,40722,3057,2,67,2,392.32,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1951,2973,575,40722,3057,2,13,1,2260.50,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1952,2973,576,40722,3057,2,96,2,1109.09,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL);
INSERT INTO `balance_libro_details` VALUES (1953,2973,576,40722,3057,2,67,2,232.91,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1954,2973,576,40722,3057,2,13,1,1342.00,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1955,2973,577,40722,3057,2,96,2,1319.01,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1956,2973,577,40722,3057,2,67,2,276.99,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1957,2973,577,40722,3057,2,13,1,1596.00,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1958,2973,578,40722,3057,2,96,2,2431.40,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1959,2973,578,40722,3057,2,67,2,510.60,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1960,2973,578,40722,3057,2,13,1,2942.00,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1961,2973,579,40722,3057,2,96,2,1223.14,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1962,2973,579,40722,3057,2,67,2,256.86,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1963,2973,579,40722,3057,2,13,1,1480.00,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1964,2973,580,40722,3057,2,96,2,2705.79,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1965,2973,580,40722,3057,2,67,2,568.21,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1966,2973,580,40722,3057,2,13,1,3274.00,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1967,2973,581,40722,3057,2,96,2,1074.38,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1968,2973,581,40722,3057,2,67,2,225.62,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1969,2973,581,40722,3057,2,13,1,1300.00,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1970,2973,582,40722,3057,2,96,2,2388.43,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1971,2973,582,40722,3057,2,67,2,501.57,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1972,2973,582,40722,3057,2,13,1,2890.00,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1973,2973,583,40722,3057,2,96,2,2379.42,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1974,2973,583,40722,3057,2,67,2,499.68,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1975,2973,583,40722,3057,2,13,1,2879.10,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1976,2973,584,40722,3057,2,96,2,7683.47,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1977,2973,584,40722,3057,2,67,2,1613.53,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1978,2973,584,40722,3057,2,13,1,9297.00,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1979,2973,585,40722,3057,2,96,2,3772.73,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1980,2973,585,40722,3057,2,67,2,792.27,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1981,2973,585,40722,3057,2,13,1,4565.00,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1982,2973,586,40722,3057,2,96,2,3764.46,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1983,2973,586,40722,3057,2,67,2,790.54,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1984,2973,586,40722,3057,2,13,1,4555.00,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1985,2973,587,40722,3057,2,96,2,1471.07,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1986,2973,587,40722,3057,2,67,2,308.93,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1987,2973,587,40722,3057,2,13,1,1780.00,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1988,2973,588,40722,3057,2,96,2,405.79,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1989,2973,588,40722,3057,2,67,2,85.21,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1990,2973,588,40722,3057,2,13,1,491.00,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1991,2973,589,40722,3057,2,96,2,811.56,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1992,2973,589,40722,3057,2,67,2,170.43,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1993,2973,589,40722,3057,2,13,1,981.99,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL);
INSERT INTO `balance_libro_details` VALUES (1994,2973,590,40722,3057,2,96,2,2493.38,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1995,2973,590,40722,3057,2,67,2,523.61,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1996,2973,590,40722,3057,2,13,1,3016.99,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1997,2973,591,40722,3057,2,96,2,4547.10,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1998,2973,591,40722,3057,2,67,2,954.89,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(1999,2973,591,40722,3057,2,13,1,5501.99,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(2000,2973,592,40722,3057,2,96,2,2478.51,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(2001,2973,592,40722,3057,2,67,2,520.49,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(2002,2973,592,40722,3057,2,13,1,2999.00,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(2003,2973,593,40722,3057,2,96,2,2021.78,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(2004,2973,593,40722,3057,2,67,2,424.58,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(2005,2973,593,40722,3057,2,13,1,2446.36,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(2006,2973,594,40722,3057,2,96,2,2666.12,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(2007,2973,594,40722,3057,2,67,2,559.88,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(2008,2973,594,40722,3057,2,13,1,3226.00,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(2009,2973,595,40722,3057,2,96,2,10619.83,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(2010,2973,595,40722,3057,2,67,2,2230.17,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(2011,2973,595,40722,3057,2,13,1,12850.00,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(2012,2973,596,40722,3057,2,96,2,783.60,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(2013,2973,596,40722,3057,2,67,2,164.55,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(2014,2973,596,40722,3057,2,13,1,948.15,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(2015,2973,597,40722,3057,2,96,2,2314.05,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(2016,2973,597,40722,3057,2,67,2,485.95,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(2017,2973,597,40722,3057,2,13,1,2800.00,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(2018,2973,598,40722,3057,2,96,2,375.21,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(2019,2973,598,40722,3057,2,67,2,78.79,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(2020,2973,598,40722,3057,2,13,1,454.00,NULL,'2021-08-10 17:28:23','2021-08-10 17:28:23',NULL),(2021,2973,599,40722,3057,2,96,2,1158.68,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2022,2973,599,40722,3057,2,67,2,243.32,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2023,2973,599,40722,3057,2,13,1,1402.00,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2024,2973,600,40722,3057,2,96,2,3395.87,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2025,2973,600,40722,3057,2,67,2,713.13,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2026,2973,600,40722,3057,2,13,1,4109.00,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2027,2973,601,40722,3057,2,96,2,10619.83,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2028,2973,601,40722,3057,2,67,2,2230.17,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2029,2973,601,40722,3057,2,13,1,12850.00,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2030,2973,602,40722,3057,2,96,2,2379.42,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2031,2973,602,40722,3057,2,67,2,499.68,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2032,2973,602,40722,3057,2,13,1,2879.10,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2033,2973,603,40722,3057,2,96,2,783.60,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2034,2973,603,40722,3057,2,67,2,164.55,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL);
INSERT INTO `balance_libro_details` VALUES (2035,2973,603,40722,3057,2,13,1,948.15,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2036,2973,604,40722,3057,2,96,2,365.29,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2037,2973,604,40722,3057,2,67,2,76.71,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2038,2973,604,40722,3057,2,13,1,442.00,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2039,2973,605,40722,3057,2,96,2,1793.39,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2040,2973,605,40722,3057,2,67,2,376.61,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2041,2973,605,40722,3057,2,13,1,2170.00,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2042,2973,606,40722,3057,2,96,2,1424.79,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2043,2973,606,40722,3057,2,67,2,299.21,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2044,2973,606,40722,3057,2,13,1,1724.00,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2045,2973,607,40722,3057,2,96,2,2851.24,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2046,2973,607,40722,3057,2,67,2,598.76,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2047,2973,607,40722,3057,2,13,1,3450.00,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2048,2973,608,40722,3057,2,96,2,4242.98,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2049,2973,608,40722,3057,2,67,2,891.02,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2050,2973,608,40722,3057,2,13,1,5134.00,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2051,2973,609,40722,3057,2,96,2,2352.89,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2052,2973,609,40722,3057,2,67,2,494.11,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2053,2973,609,40722,3057,2,13,1,2847.00,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2054,2973,610,40722,3057,2,96,2,3826.45,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2055,2973,610,40722,3057,2,67,2,803.55,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2056,2973,610,40722,3057,2,13,1,4630.00,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2057,2973,611,40722,3057,2,96,2,3290.91,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2058,2973,611,40722,3057,2,67,2,691.09,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2059,2973,611,40722,3057,2,13,1,3982.00,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2060,2973,612,40722,3057,2,96,2,996.69,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2061,2973,612,40722,3057,2,67,2,209.31,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2062,2973,612,40722,3057,2,13,1,1206.00,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2063,2973,613,40722,3057,2,96,2,1158.67,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2064,2973,613,40722,3057,2,67,2,243.32,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2065,2973,613,40722,3057,2,13,1,1401.99,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2066,2973,614,40722,3057,2,96,2,4128.93,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2067,2973,614,40722,3057,2,67,2,867.07,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2068,2973,614,40722,3057,2,13,1,4996.00,NULL,'2021-08-10 17:28:24','2021-08-10 17:28:24',NULL),(2069,2973,615,40722,3057,3,217,1,79.88,NULL,'2021-08-10 17:41:01','2021-08-10 17:41:01',NULL),(2070,2973,615,40722,3057,3,68,1,16.77,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2071,2973,615,40722,3057,3,217,1,7.98,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2072,2973,615,40722,3057,3,57,2,104.63,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2073,2973,616,40722,3057,3,217,1,37.23,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2074,2973,616,40722,3057,3,68,1,7.82,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2075,2973,616,40722,3057,3,57,2,45.05,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2076,2973,617,40722,3057,3,217,1,96.44,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL);
INSERT INTO `balance_libro_details` VALUES (2077,2973,617,40722,3057,3,68,1,20.26,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2078,2973,617,40722,3057,3,57,2,116.70,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2079,2973,618,40722,3057,3,250,1,4000.00,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2080,2973,618,40722,3057,3,57,2,4000.00,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2081,2973,619,40722,3057,3,250,1,7000.00,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2082,2973,619,40722,3057,3,57,2,7000.00,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2083,2973,620,40722,3057,3,217,1,27.24,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2084,2973,620,40722,3057,3,68,1,5.72,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2085,2973,620,40722,3057,3,217,1,0.04,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2086,2973,620,40722,3057,3,57,2,33.00,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2087,2973,621,40722,3057,3,217,1,606.47,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2088,2973,621,40722,3057,3,68,1,127.36,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2089,2973,621,40722,3057,3,217,1,240.83,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2090,2973,621,40722,3057,3,57,2,974.66,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2091,2973,622,40722,3057,3,217,1,40.74,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2092,2973,622,40722,3057,3,68,1,8.56,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2093,2973,622,40722,3057,3,57,2,49.30,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2094,2973,623,40722,3057,3,217,1,306.18,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2095,2973,623,40722,3057,3,68,1,64.29,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2096,2973,623,40722,3057,3,217,1,30.60,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2097,2973,623,40722,3057,3,57,2,401.07,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2098,2973,624,40722,3057,3,217,1,187.10,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2099,2973,624,40722,3057,3,68,1,39.30,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2100,2973,624,40722,3057,3,57,2,226.40,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2101,2973,625,40722,3057,3,217,1,447.93,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2102,2973,625,40722,3057,3,68,1,94.07,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2103,2973,625,40722,3057,3,57,2,542.00,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2104,2973,626,40722,3057,3,217,1,592.39,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2105,2973,626,40722,3057,3,68,1,124.40,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2106,2973,626,40722,3057,3,217,1,235.25,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2107,2973,626,40722,3057,3,57,2,952.04,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2108,2973,627,40722,3057,3,217,1,83788.88,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2109,2973,627,40722,3057,3,68,1,17595.66,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2110,2973,627,40722,3057,3,217,1,16651.05,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2111,2973,627,40722,3057,3,57,2,118035.59,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2112,2973,628,40722,3057,3,217,1,87006.05,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2113,2973,628,40722,3057,3,68,1,18271.27,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2114,2973,628,40722,3057,3,217,1,4785.33,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2115,2973,628,40722,3057,3,57,2,110062.65,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2116,2973,629,40722,3057,3,217,1,341073.00,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2117,2973,629,40722,3057,3,68,1,71625.33,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL);
INSERT INTO `balance_libro_details` VALUES (2118,2973,629,40722,3057,3,57,2,412698.33,NULL,'2021-08-10 17:41:02','2021-08-10 17:41:02',NULL),(2119,2973,630,40720,1541,23,157,1,7542.20,NULL,'2021-08-20 06:48:10','2021-08-20 07:54:20','2021-08-20 07:54:20'),(2120,2973,630,40720,1541,23,192,1,19482.71,NULL,'2021-08-20 06:48:10','2021-08-20 07:54:20','2021-08-20 07:54:20'),(2121,2973,630,40720,1541,23,128,1,3614.79,NULL,'2021-08-20 06:48:10','2021-08-20 07:54:20','2021-08-20 07:54:20'),(2122,2973,630,40720,1541,23,483,1,72879.88,NULL,'2021-08-20 06:48:10','2021-08-20 07:54:20','2021-08-20 07:54:20'),(2123,2973,630,40720,1541,23,96,2,1107006.09,NULL,'2021-08-20 06:48:10','2021-08-20 07:54:20','2021-08-20 07:54:20'),(2124,2973,630,40720,1541,23,88,2,16570.53,NULL,'2021-08-20 06:48:10','2021-08-20 07:54:20','2021-08-20 07:54:20'),(2125,2973,630,40720,1541,23,396,1,2126.67,NULL,'2021-08-20 06:48:10','2021-08-20 07:54:20','2021-08-20 07:54:20'),(2126,2973,630,40720,1541,23,156,1,37073.29,NULL,'2021-08-20 06:48:10','2021-08-20 07:54:20','2021-08-20 07:54:20'),(2127,2973,630,40720,1541,23,391,1,8697.65,NULL,'2021-08-20 06:48:10','2021-08-20 07:54:20','2021-08-20 07:54:20'),(2128,2973,630,40720,1541,23,484,1,106135.73,NULL,'2021-08-20 06:48:10','2021-08-20 07:54:20','2021-08-20 07:54:20'),(2129,2973,630,40720,1541,23,383,2,142301.49,NULL,'2021-08-20 06:48:11','2021-08-20 07:54:20','2021-08-20 07:54:20'),(2130,2973,630,40720,1541,23,217,1,6472.47,NULL,'2021-08-20 06:48:11','2021-08-20 07:54:20','2021-08-20 07:54:20'),(2131,2973,630,40720,1541,23,419,1,268229.20,NULL,'2021-08-20 06:48:11','2021-08-20 07:54:20','2021-08-20 07:54:20'),(2132,2973,630,40720,1541,23,135,1,7224.88,NULL,'2021-08-20 06:48:11','2021-08-20 07:54:20','2021-08-20 07:54:20'),(2133,2973,630,40720,1541,23,221,1,1053.29,NULL,'2021-08-20 06:48:11','2021-08-20 07:54:20','2021-08-20 07:54:20'),(2134,2973,630,40720,1541,23,485,1,973.90,NULL,'2021-08-20 06:48:11','2021-08-20 07:54:20','2021-08-20 07:54:20'),(2135,2973,630,40720,1541,23,198,1,7953.97,NULL,'2021-08-20 06:48:11','2021-08-20 07:54:20','2021-08-20 07:54:20'),(2136,2973,630,40720,1541,23,129,1,31326.70,NULL,'2021-08-20 06:48:11','2021-08-20 07:54:20','2021-08-20 07:54:20'),(2137,2973,630,40720,1541,23,123,1,108.07,NULL,'2021-08-20 06:48:12','2021-08-20 07:54:20','2021-08-20 07:54:20'),(2138,2973,630,40720,1541,23,467,1,4148.84,NULL,'2021-08-20 06:48:12','2021-08-20 07:54:20','2021-08-20 07:54:20'),(2139,2973,630,40720,1541,23,381,2,11381.65,NULL,'2021-08-20 06:48:12','2021-08-20 07:54:20','2021-08-20 07:54:20'),(2140,2973,630,40720,1541,23,476,1,692215.52,NULL,'2021-08-20 06:48:12','2021-08-20 07:54:20','2021-08-20 07:54:20'),(2141,2973,631,40720,1541,23,157,1,7542.20,NULL,'2021-08-23 16:36:33','2021-08-23 16:36:33',NULL),(2142,2973,631,40720,1541,23,192,1,19482.71,NULL,'2021-08-23 16:36:33','2021-08-23 16:36:33',NULL),(2143,2973,631,40720,1541,23,128,1,3614.79,NULL,'2021-08-23 16:36:34','2021-08-23 16:36:34',NULL),(2144,2973,631,40720,1541,23,483,1,72879.88,NULL,'2021-08-23 16:36:34','2021-08-23 16:36:34',NULL),(2145,2973,631,40720,1541,23,96,2,1107006.09,NULL,'2021-08-23 16:36:34','2021-08-23 16:36:34',NULL),(2146,2973,631,40720,1541,23,88,2,16570.53,NULL,'2021-08-23 16:36:34','2021-08-23 16:36:34',NULL),(2147,2973,631,40720,1541,23,396,1,2126.67,NULL,'2021-08-23 16:36:34','2021-08-23 16:36:34',NULL),(2148,2973,631,40720,1541,23,156,1,37073.29,NULL,'2021-08-23 16:36:34','2021-08-23 16:36:34',NULL),(2149,2973,631,40720,1541,23,391,1,8697.65,NULL,'2021-08-23 16:36:34','2021-08-23 16:36:34',NULL),(2150,2973,631,40720,1541,23,484,1,106135.73,NULL,'2021-08-23 16:36:34','2021-08-23 16:36:34',NULL),(2151,2973,631,40720,1541,23,383,2,142301.49,NULL,'2021-08-23 16:36:34','2021-08-23 16:36:34',NULL),(2152,2973,631,40720,1541,23,135,1,7224.88,NULL,'2021-08-23 16:36:34','2021-08-23 16:36:34',NULL),(2153,2973,631,40720,1541,23,217,1,6472.47,NULL,'2021-08-23 16:36:34','2021-08-23 16:36:34',NULL);
INSERT INTO `balance_libro_details` VALUES (2154,2973,631,40720,1541,23,419,1,268229.20,NULL,'2021-08-23 16:36:34','2021-08-23 16:36:34',NULL),(2155,2973,631,40720,1541,23,221,1,1053.29,NULL,'2021-08-23 16:36:34','2021-08-23 16:36:34',NULL),(2156,2973,631,40720,1541,23,485,1,973.90,NULL,'2021-08-23 16:36:34','2021-08-23 16:36:34',NULL),(2157,2973,631,40720,1541,23,198,1,7953.97,NULL,'2021-08-23 16:36:34','2021-08-23 16:36:34',NULL),(2158,2973,631,40720,1541,23,129,1,31326.70,NULL,'2021-08-23 16:36:35','2021-08-23 16:36:35',NULL),(2159,2973,631,40720,1541,23,123,1,108.07,NULL,'2021-08-23 16:36:35','2021-08-23 16:36:35',NULL),(2160,2973,631,40720,1541,23,467,1,4148.84,NULL,'2021-08-23 16:36:35','2021-08-23 16:36:35',NULL),(2161,2973,631,40720,1541,23,381,2,11381.65,NULL,'2021-08-23 16:36:35','2021-08-23 16:36:35',NULL),(2162,2973,631,40720,1541,23,476,1,692215.52,NULL,'2021-08-23 16:36:35','2021-08-23 16:36:35',NULL),(2163,2973,632,40720,1541,17,96,1,7483823.31,NULL,'2021-08-24 16:37:58','2021-08-24 16:41:08','2021-08-24 16:41:08'),(2164,2973,632,40720,1541,17,140,2,53812.58,NULL,'2021-08-24 16:37:58','2021-08-24 16:41:08','2021-08-24 16:41:08'),(2165,2973,632,40720,1541,17,476,2,692215.52,NULL,'2021-08-24 16:37:58','2021-08-24 16:41:08','2021-08-24 16:41:08'),(2166,2973,632,40720,1541,17,421,2,175837.24,NULL,'2021-08-24 16:37:58','2021-08-24 16:41:08','2021-08-24 16:41:08'),(2167,2973,632,40720,1541,17,422,2,1312.22,NULL,'2021-08-24 16:37:58','2021-08-24 16:41:08','2021-08-24 16:41:08'),(2168,2973,632,40720,1541,17,123,2,587.58,NULL,'2021-08-24 16:37:58','2021-08-24 16:41:08','2021-08-24 16:41:08'),(2169,2973,632,40720,1541,17,484,2,874849.18,NULL,'2021-08-24 16:37:58','2021-08-24 16:41:08','2021-08-24 16:41:08'),(2170,2973,632,40720,1541,17,483,2,469323.40,NULL,'2021-08-24 16:37:58','2021-08-24 16:41:08','2021-08-24 16:41:08'),(2171,2973,632,40720,1541,17,485,2,7025.90,NULL,'2021-08-24 16:37:58','2021-08-24 16:41:08','2021-08-24 16:41:08'),(2172,2973,632,40720,1541,17,128,2,23767.68,NULL,'2021-08-24 16:37:58','2021-08-24 16:41:08','2021-08-24 16:41:08'),(2173,2973,632,40720,1541,17,129,2,158748.19,NULL,'2021-08-24 16:37:58','2021-08-24 16:41:08','2021-08-24 16:41:08'),(2174,2973,632,40720,1541,17,135,2,146914.10,NULL,'2021-08-24 16:37:58','2021-08-24 16:41:08','2021-08-24 16:41:08'),(2175,2973,632,40720,1541,17,136,1,0.15,NULL,'2021-08-24 16:37:58','2021-08-24 16:41:08','2021-08-24 16:41:08'),(2176,2973,632,40720,1541,17,192,2,114482.71,NULL,'2021-08-24 16:37:58','2021-08-24 16:41:08','2021-08-24 16:41:08'),(2177,2973,632,40720,1541,17,198,2,50289.91,NULL,'2021-08-24 16:37:58','2021-08-24 16:41:08','2021-08-24 16:41:08'),(2178,2973,632,40720,1541,17,217,2,94824.06,NULL,'2021-08-24 16:37:58','2021-08-24 16:41:08','2021-08-24 16:41:08'),(2179,2973,632,40720,1541,17,396,2,13759.98,NULL,'2021-08-24 16:37:58','2021-08-24 16:41:08','2021-08-24 16:41:08'),(2180,2973,632,40720,1541,17,157,2,34380.58,NULL,'2021-08-24 16:37:58','2021-08-24 16:41:08','2021-08-24 16:41:08'),(2181,2973,632,40720,1541,17,221,2,1053.29,NULL,'2021-08-24 16:37:58','2021-08-24 16:41:08','2021-08-24 16:41:08'),(2182,2973,632,40720,1541,17,156,2,251953.96,NULL,'2021-08-24 16:37:58','2021-08-24 16:41:08','2021-08-24 16:41:08'),(2183,2973,632,40720,1541,17,91,2,3968685.38,NULL,'2021-08-24 16:37:58','2021-08-24 16:41:08','2021-08-24 16:41:08'),(2184,2973,632,40720,1541,17,155,2,350000.00,NULL,'2021-08-24 16:37:58','2021-08-24 16:41:08','2021-08-24 16:41:08'),(2185,2973,633,40720,1541,17,96,1,7483823.31,NULL,'2021-08-24 16:41:08','2021-08-28 12:36:49','2021-08-28 12:36:49'),(2186,2973,633,40720,1541,17,476,2,692215.52,NULL,'2021-08-24 16:41:08','2021-08-28 12:36:49','2021-08-28 12:36:49'),(2187,2973,633,40720,1541,17,421,2,175837.24,NULL,'2021-08-24 16:41:08','2021-08-28 12:36:49','2021-08-28 12:36:49'),(2188,2973,633,40720,1541,17,422,2,1312.22,NULL,'2021-08-24 16:41:08','2021-08-28 12:36:49','2021-08-28 12:36:49');
INSERT INTO `balance_libro_details` VALUES (2189,2973,633,40720,1541,17,123,2,587.58,NULL,'2021-08-24 16:41:08','2021-08-28 12:36:49','2021-08-28 12:36:49'),(2190,2973,633,40720,1541,17,484,2,874849.18,NULL,'2021-08-24 16:41:08','2021-08-28 12:36:49','2021-08-28 12:36:49'),(2191,2973,633,40720,1541,17,483,2,469323.40,NULL,'2021-08-24 16:41:08','2021-08-28 12:36:49','2021-08-28 12:36:49'),(2192,2973,633,40720,1541,17,485,2,7025.90,NULL,'2021-08-24 16:41:08','2021-08-28 12:36:49','2021-08-28 12:36:49'),(2193,2973,633,40720,1541,17,128,2,23767.68,NULL,'2021-08-24 16:41:08','2021-08-28 12:36:49','2021-08-28 12:36:49'),(2194,2973,633,40720,1541,17,129,2,158748.19,NULL,'2021-08-24 16:41:08','2021-08-28 12:36:49','2021-08-28 12:36:49'),(2195,2973,633,40720,1541,17,135,2,146914.10,NULL,'2021-08-24 16:41:08','2021-08-28 12:36:49','2021-08-28 12:36:49'),(2196,2973,633,40720,1541,17,136,1,0.15,NULL,'2021-08-24 16:41:08','2021-08-28 12:36:49','2021-08-28 12:36:49'),(2197,2973,633,40720,1541,17,192,2,114482.71,NULL,'2021-08-24 16:41:08','2021-08-28 12:36:49','2021-08-28 12:36:49'),(2198,2973,633,40720,1541,17,198,2,50289.91,NULL,'2021-08-24 16:41:08','2021-08-28 12:36:49','2021-08-28 12:36:49'),(2199,2973,633,40720,1541,17,217,2,94824.06,NULL,'2021-08-24 16:41:08','2021-08-28 12:36:49','2021-08-28 12:36:49'),(2200,2973,633,40720,1541,17,396,2,13759.98,NULL,'2021-08-24 16:41:08','2021-08-28 12:36:49','2021-08-28 12:36:49'),(2201,2973,633,40720,1541,17,157,2,34380.58,NULL,'2021-08-24 16:41:08','2021-08-28 12:36:49','2021-08-28 12:36:49'),(2202,2973,633,40720,1541,17,221,2,1053.29,NULL,'2021-08-24 16:41:08','2021-08-28 12:36:49','2021-08-28 12:36:49'),(2203,2973,633,40720,1541,17,156,2,251953.96,NULL,'2021-08-24 16:41:08','2021-08-28 12:36:49','2021-08-28 12:36:49'),(2204,2973,633,40720,1541,17,91,2,3968685.38,NULL,'2021-08-24 16:41:08','2021-08-28 12:36:49','2021-08-28 12:36:49'),(2205,2973,633,40720,1541,17,155,2,350000.00,NULL,'2021-08-24 16:41:08','2021-08-28 12:36:49','2021-08-28 12:36:49'),(2206,2973,633,40720,1541,17,467,2,53812.58,NULL,'2021-08-24 16:41:08','2021-08-28 12:36:49','2021-08-28 12:36:49'),(2207,2973,634,40720,1530,19,23,1,6086.98,NULL,'2021-08-24 17:39:11','2021-08-24 17:39:11',NULL),(2208,2973,634,40720,1530,19,10,1,478863.03,NULL,'2021-08-24 17:39:11','2021-08-24 17:39:11',NULL),(2209,2973,634,40720,1530,19,359,1,53811.45,NULL,'2021-08-24 17:39:11','2021-08-24 17:39:11',NULL),(2210,2973,634,40720,1530,19,13,1,33807.40,NULL,'2021-08-24 17:39:11','2021-08-24 17:39:11',NULL),(2211,2973,634,40720,1530,19,301,1,4819.18,NULL,'2021-08-24 17:39:11','2021-08-24 17:39:11',NULL),(2212,2973,634,40720,1530,19,487,1,7193.66,NULL,'2021-08-24 17:39:11','2021-08-24 17:39:11',NULL),(2213,2973,634,40720,1530,19,302,1,2445.32,NULL,'2021-08-24 17:39:11','2021-08-24 17:39:11',NULL),(2214,2973,634,40720,1530,19,369,2,50000.00,NULL,'2021-08-24 17:39:11','2021-08-24 17:39:11',NULL),(2215,2973,634,40720,1530,19,74,2,87351.60,NULL,'2021-08-24 17:39:11','2021-08-24 17:39:11',NULL),(2216,2973,634,40720,1530,19,411,2,431902.63,NULL,'2021-08-24 17:39:11','2021-08-24 17:39:11',NULL),(2217,2973,634,40720,1530,19,91,2,1007772.79,NULL,'2021-08-24 17:39:11','2021-08-24 17:39:11',NULL),(2218,2973,634,40720,1530,19,488,1,495000.00,NULL,'2021-08-24 17:39:11','2021-08-24 17:39:11',NULL),(2219,2973,634,40720,1530,19,489,1,495000.00,NULL,'2021-08-24 17:39:11','2021-08-24 17:39:11',NULL),(2220,2973,635,40720,1530,19,251,1,26062.02,NULL,'2021-08-24 17:42:03','2021-08-24 17:42:03',NULL),(2221,2973,635,40720,1530,19,10,1,744629.05,NULL,'2021-08-24 17:42:03','2021-08-24 17:42:03',NULL),(2222,2973,635,40720,1530,19,359,1,20000.00,NULL,'2021-08-24 17:42:03','2021-08-24 17:42:03',NULL),(2223,2973,635,40720,1530,19,57,1,101896.79,NULL,'2021-08-24 17:42:03','2021-08-24 17:42:03',NULL),(2224,2973,635,40720,1530,19,74,1,87351.60,NULL,'2021-08-24 17:42:03','2021-08-24 17:42:03',NULL),(2225,2973,635,40720,1530,19,487,1,2691.03,NULL,'2021-08-24 17:42:03','2021-08-24 17:42:03',NULL);
INSERT INTO `balance_libro_details` VALUES (2226,2973,635,40720,1530,19,157,1,5463.60,NULL,'2021-08-24 17:42:03','2021-08-24 17:42:03',NULL),(2227,2973,635,40720,1530,19,396,1,269.69,NULL,'2021-08-24 17:42:03','2021-08-24 17:42:03',NULL),(2228,2973,635,40720,1530,19,10,2,603734.73,NULL,'2021-08-24 17:42:03','2021-08-24 17:42:03',NULL),(2229,2973,635,40720,1530,19,13,2,744629.05,NULL,'2021-08-24 17:42:03','2021-08-24 17:42:03',NULL),(2230,2973,635,40720,1530,19,488,1,180000.00,NULL,'2021-08-24 17:42:03','2021-08-24 17:42:03',NULL),(2231,2973,635,40720,1530,19,489,1,180000.00,NULL,'2021-08-24 17:42:03','2021-08-24 17:42:03',NULL),(2232,2973,636,40720,1531,19,359,1,175000.00,NULL,'2021-08-24 17:43:24','2021-08-24 17:43:24',NULL),(2233,2973,636,40720,1531,19,489,2,87500.00,NULL,'2021-08-24 17:43:24','2021-08-24 17:43:24',NULL),(2234,2973,636,40720,1531,19,488,2,87500.00,NULL,'2021-08-24 17:43:24','2021-08-24 17:43:24',NULL),(2235,2973,637,40720,1531,19,251,1,2153.24,NULL,'2021-08-24 17:44:50','2021-08-24 18:09:57','2021-08-24 18:09:57'),(2236,2973,637,40720,1531,19,10,1,717749.10,NULL,'2021-08-24 17:44:50','2021-08-24 18:09:57','2021-08-24 18:09:57'),(2237,2973,637,40720,1531,19,57,1,1011538.92,NULL,'2021-08-24 17:44:50','2021-08-24 18:09:57','2021-08-24 18:09:57'),(2238,2973,637,40720,1531,19,74,1,102622.79,NULL,'2021-08-24 17:44:50','2021-08-24 18:09:57','2021-08-24 18:09:57'),(2239,2973,637,40720,1531,19,486,1,2566.33,NULL,'2021-08-24 17:44:50','2021-08-24 18:09:57','2021-08-24 18:09:57'),(2240,2973,637,40720,1531,19,487,1,3896.36,NULL,'2021-08-24 17:44:50','2021-08-24 18:09:57','2021-08-24 18:09:57'),(2241,2973,637,40720,1531,19,157,1,7910.78,NULL,'2021-08-24 17:44:50','2021-08-24 18:09:57','2021-08-24 18:09:57'),(2242,2973,637,40720,1531,19,396,1,121.00,NULL,'2021-08-24 17:44:50','2021-08-24 18:09:57','2021-08-24 18:09:57'),(2243,2973,637,40720,1531,19,359,2,175000.00,NULL,'2021-08-24 17:44:50','2021-08-24 18:09:57','2021-08-24 18:09:57'),(2244,2973,637,40720,1531,19,13,2,542749.10,NULL,'2021-08-24 17:44:50','2021-08-24 18:09:57','2021-08-24 18:09:57'),(2245,2973,637,40720,1531,19,10,2,1260809.42,NULL,'2021-08-24 17:44:50','2021-08-24 18:09:57','2021-08-24 18:09:57'),(2246,2973,637,40720,1531,19,488,1,65000.00,NULL,'2021-08-24 17:44:50','2021-08-24 18:09:57','2021-08-24 18:09:57'),(2247,2973,637,40720,1531,19,488,1,65000.00,NULL,'2021-08-24 17:44:50','2021-08-24 18:09:57','2021-08-24 18:09:57'),(2248,2973,638,40720,1532,19,251,1,30657.93,NULL,'2021-08-24 17:47:04','2021-08-24 17:47:04',NULL),(2249,2973,638,40720,1532,19,10,1,730190.72,NULL,'2021-08-24 17:47:04','2021-08-24 17:47:04',NULL),(2250,2973,638,40720,1532,19,359,1,35000.00,NULL,'2021-08-24 17:47:04','2021-08-24 17:47:04',NULL),(2251,2973,638,40720,1532,19,57,1,334685.54,NULL,'2021-08-24 17:47:04','2021-08-24 17:47:04',NULL),(2252,2973,638,40720,1532,19,74,1,5323.32,NULL,'2021-08-24 17:47:04','2021-08-24 17:47:04',NULL),(2253,2973,638,40720,1532,19,486,1,13255.82,NULL,'2021-08-24 17:47:04','2021-08-24 17:47:04',NULL),(2254,2973,638,40720,1532,19,487,1,3062.40,NULL,'2021-08-24 17:47:04','2021-08-24 17:47:04',NULL),(2255,2973,638,40720,1532,19,157,1,6217.61,NULL,'2021-08-24 17:47:04','2021-08-24 17:47:04',NULL),(2256,2973,638,40720,1532,19,419,1,875.80,NULL,'2021-08-24 17:47:04','2021-08-24 17:47:04',NULL),(2257,2973,638,40720,1532,19,396,1,2402.79,NULL,'2021-08-24 17:47:04','2021-08-24 17:47:04',NULL),(2258,2973,638,40720,1532,19,135,1,10007.90,NULL,'2021-08-24 17:47:04','2021-08-24 17:47:04',NULL),(2259,2973,638,40720,1532,19,13,2,730190.72,NULL,'2021-08-24 17:47:04','2021-08-24 17:47:04',NULL),(2260,2973,638,40720,1532,19,10,2,756489.11,NULL,'2021-08-24 17:47:04','2021-08-24 17:47:04',NULL),(2261,2973,638,40720,1532,19,488,1,185000.00,NULL,'2021-08-24 17:47:04','2021-08-24 17:47:04',NULL),(2262,2973,638,40720,1532,19,489,1,130000.00,NULL,'2021-08-24 17:47:04','2021-08-24 17:47:04',NULL),(2263,2973,639,40720,1533,19,251,1,3194.81,NULL,'2021-08-24 17:48:22','2021-08-24 17:48:22',NULL);
INSERT INTO `balance_libro_details` VALUES (2264,2973,639,40720,1533,19,10,1,354978.86,NULL,'2021-08-24 17:48:22','2021-08-24 17:48:22',NULL),(2265,2973,639,40720,1533,19,57,1,36620.00,NULL,'2021-08-24 17:48:22','2021-08-24 17:48:22',NULL),(2266,2973,639,40720,1533,19,74,1,25073.00,NULL,'2021-08-24 17:48:22','2021-08-24 17:48:22',NULL),(2267,2973,639,40720,1533,19,487,1,1299.36,NULL,'2021-08-24 17:48:22','2021-08-24 17:48:22',NULL),(2268,2973,639,40720,1533,19,157,1,2638.10,NULL,'2021-08-24 17:48:22','2021-08-24 17:48:22',NULL),(2269,2973,639,40720,1533,19,396,1,1375.00,NULL,'2021-08-24 17:48:22','2021-08-24 17:48:22',NULL),(2270,2973,639,40720,1533,19,10,2,305200.27,NULL,'2021-08-24 17:48:22','2021-08-24 17:48:22',NULL),(2271,2973,639,40720,1533,19,13,2,354978.86,NULL,'2021-08-24 17:48:22','2021-08-24 17:48:22',NULL),(2272,2973,639,40720,1533,19,489,1,145000.00,NULL,'2021-08-24 17:48:22','2021-08-24 17:48:22',NULL),(2273,2973,639,40720,1533,19,488,1,90000.00,NULL,'2021-08-24 17:48:22','2021-08-24 17:48:22',NULL),(2274,2973,640,40720,1534,19,383,1,850500.00,NULL,'2021-08-24 17:49:23','2021-08-24 17:49:23',NULL),(2275,2973,640,40720,1534,19,381,2,50500.00,NULL,'2021-08-24 17:49:23','2021-08-24 17:49:23',NULL),(2276,2973,640,40720,1534,19,488,2,400000.00,NULL,'2021-08-24 17:49:23','2021-08-24 17:49:23',NULL),(2277,2973,640,40720,1534,19,489,2,400000.00,NULL,'2021-08-24 17:49:23','2021-08-24 17:49:23',NULL),(2278,2973,641,40720,1534,19,251,1,7365.50,NULL,'2021-08-24 17:50:27','2021-08-24 17:50:27',NULL),(2279,2973,641,40720,1534,19,10,1,813500.29,NULL,'2021-08-24 17:50:27','2021-08-24 17:50:27',NULL),(2280,2973,641,40720,1534,19,359,1,10000.00,NULL,'2021-08-24 17:50:27','2021-08-24 17:50:27',NULL),(2281,2973,641,40720,1534,19,57,1,31737.98,NULL,'2021-08-24 17:50:27','2021-08-24 17:50:27',NULL),(2282,2973,641,40720,1534,19,74,1,29615.64,NULL,'2021-08-24 17:50:27','2021-08-24 17:50:27',NULL),(2283,2973,641,40720,1534,19,487,1,2269.76,NULL,'2021-08-24 17:50:27','2021-08-24 17:50:27',NULL),(2284,2973,641,40720,1534,19,157,1,4608.29,NULL,'2021-08-24 17:50:27','2021-08-24 17:50:27',NULL),(2285,2973,641,40720,1534,19,396,1,1331.00,NULL,'2021-08-24 17:50:27','2021-08-24 17:50:27',NULL),(2286,2973,641,40720,1534,19,467,1,1131.00,NULL,'2021-08-24 17:50:27','2021-08-24 17:50:27',NULL),(2287,2973,641,40720,1534,19,10,2,332059.17,NULL,'2021-08-24 17:50:27','2021-08-24 17:50:27',NULL),(2288,2973,641,40720,1534,19,13,2,813500.29,NULL,'2021-08-24 17:50:27','2021-08-24 17:50:27',NULL),(2289,2973,641,40720,1534,19,488,1,122000.00,NULL,'2021-08-24 17:50:27','2021-08-24 17:50:27',NULL),(2290,2973,641,40720,1534,19,489,1,122000.00,NULL,'2021-08-24 17:50:27','2021-08-24 17:50:27',NULL),(2291,2973,642,40720,1535,19,251,1,1064.70,NULL,'2021-08-24 17:51:20','2021-08-24 17:51:20',NULL),(2292,2973,642,40720,1535,19,10,1,510347.75,NULL,'2021-08-24 17:51:20','2021-08-24 17:51:20',NULL),(2293,2973,642,40720,1535,19,359,1,14000.00,NULL,'2021-08-24 17:51:20','2021-08-24 17:51:20',NULL),(2294,2973,642,40720,1535,19,57,1,249034.56,NULL,'2021-08-24 17:51:20','2021-08-24 17:51:20',NULL),(2295,2973,642,40720,1535,19,74,1,94276.30,NULL,'2021-08-24 17:51:20','2021-08-24 17:51:20',NULL),(2296,2973,642,40720,1535,19,487,1,7046.16,NULL,'2021-08-24 17:51:20','2021-08-24 17:51:20',NULL),(2297,2973,642,40720,1535,19,396,1,1331.00,NULL,'2021-08-24 17:51:20','2021-08-24 17:51:20',NULL),(2298,2973,642,40720,1535,19,467,1,1963.89,NULL,'2021-08-24 17:51:20','2021-08-24 17:51:20',NULL),(2299,2973,642,40720,1535,19,13,2,510347.75,NULL,'2021-08-24 17:51:20','2021-08-24 17:51:20',NULL),(2300,2973,642,40720,1535,19,10,2,668716.61,NULL,'2021-08-24 17:51:20','2021-08-24 17:51:20',NULL),(2301,2973,642,40720,1535,19,488,1,150000.00,NULL,'2021-08-24 17:51:20','2021-08-24 17:51:20',NULL),(2302,2973,642,40720,1535,19,489,1,150000.00,NULL,'2021-08-24 17:51:20','2021-08-24 17:51:20',NULL),(2303,2973,643,40720,1536,19,251,1,16.50,NULL,'2021-08-24 17:52:22','2021-08-24 17:52:22',NULL);
INSERT INTO `balance_libro_details` VALUES (2304,2973,643,40720,1536,19,10,1,323757.50,NULL,'2021-08-24 17:52:22','2021-08-24 17:52:22',NULL),(2305,2973,643,40720,1536,19,359,1,20000.00,NULL,'2021-08-24 17:52:22','2021-08-24 17:52:22',NULL),(2306,2973,643,40720,1536,19,57,1,121364.18,NULL,'2021-08-24 17:52:22','2021-08-24 17:52:22',NULL),(2307,2973,643,40720,1536,19,74,1,108534.55,NULL,'2021-08-24 17:52:22','2021-08-24 17:52:22',NULL),(2308,2973,643,40720,1536,19,487,1,3547.35,NULL,'2021-08-24 17:52:22','2021-08-24 17:52:22',NULL),(2309,2973,643,40720,1536,19,396,1,1331.00,NULL,'2021-08-24 17:52:22','2021-08-24 17:52:22',NULL),(2310,2973,643,40720,1536,19,467,1,1724.02,NULL,'2021-08-24 17:52:22','2021-08-24 17:52:22',NULL),(2311,2973,643,40720,1536,19,13,2,323757.50,NULL,'2021-08-24 17:52:22','2021-08-24 17:52:22',NULL),(2312,2973,643,40720,1536,19,10,2,586517.60,NULL,'2021-08-24 17:52:22','2021-08-24 17:52:22',NULL),(2313,2973,643,40720,1536,19,488,1,165000.00,NULL,'2021-08-24 17:52:22','2021-08-24 17:52:22',NULL),(2314,2973,643,40720,1536,19,489,1,165000.00,NULL,'2021-08-24 17:52:22','2021-08-24 17:52:22',NULL),(2315,2973,644,40720,1537,19,251,1,22275.59,NULL,'2021-08-24 17:53:19','2021-08-24 17:53:19',NULL),(2316,2973,644,40720,1537,19,10,1,742519.62,NULL,'2021-08-24 17:53:19','2021-08-24 17:53:19',NULL),(2317,2973,644,40720,1537,19,359,1,15000.00,NULL,'2021-08-24 17:53:19','2021-08-24 17:53:19',NULL),(2318,2973,644,40720,1537,19,57,1,50574.95,NULL,'2021-08-24 17:53:19','2021-08-24 17:53:19',NULL),(2319,2973,644,40720,1537,19,74,1,32276.30,NULL,'2021-08-24 17:53:19','2021-08-24 17:53:19',NULL),(2320,2973,644,40720,1537,19,487,1,6383.88,NULL,'2021-08-24 17:53:19','2021-08-24 17:53:19',NULL),(2321,2973,644,40720,1537,19,396,1,1331.00,NULL,'2021-08-24 17:53:19','2021-08-24 17:53:19',NULL),(2322,2973,644,40720,1537,19,10,2,327841.72,NULL,'2021-08-24 17:53:19','2021-08-24 17:53:19',NULL),(2323,2973,644,40720,1537,19,13,2,742519.62,NULL,'2021-08-24 17:53:19','2021-08-24 17:53:19',NULL),(2324,2973,644,40720,1537,19,489,1,100000.00,NULL,'2021-08-24 17:53:19','2021-08-24 17:53:19',NULL),(2325,2973,644,40720,1537,19,488,1,100000.00,NULL,'2021-08-24 17:53:19','2021-08-24 17:53:19',NULL),(2326,2973,645,40720,1538,19,251,1,19415.70,NULL,'2021-08-24 17:54:24','2021-08-24 17:54:24',NULL),(2327,2973,645,40720,1538,19,10,1,647189.97,NULL,'2021-08-24 17:54:24','2021-08-24 17:54:24',NULL),(2328,2973,645,40720,1538,19,359,1,30000.00,NULL,'2021-08-24 17:54:24','2021-08-24 17:54:24',NULL),(2329,2973,645,40720,1538,19,57,1,80468.57,NULL,'2021-08-24 17:54:24','2021-08-24 17:54:24',NULL),(2330,2973,645,40720,1538,19,74,1,116241.10,NULL,'2021-08-24 17:54:24','2021-08-24 17:54:24',NULL),(2331,2973,645,40720,1538,19,486,1,17259.16,NULL,'2021-08-24 17:54:24','2021-08-24 17:54:24',NULL),(2332,2973,645,40720,1538,19,487,1,8818.30,NULL,'2021-08-24 17:54:24','2021-08-24 17:54:24',NULL),(2333,2973,645,40720,1538,19,20,1,259141.58,NULL,'2021-08-24 17:54:24','2021-08-24 17:54:24',NULL),(2334,2973,645,40720,1538,19,13,2,647189.97,NULL,'2021-08-24 17:54:24','2021-08-24 17:54:24',NULL),(2335,2973,645,40720,1538,19,10,2,831344.41,NULL,'2021-08-24 17:54:24','2021-08-24 17:54:24',NULL),(2336,2973,645,40720,1538,19,489,1,150000.00,NULL,'2021-08-24 17:54:24','2021-08-24 17:54:24',NULL),(2337,2973,645,40720,1538,19,488,1,150000.00,NULL,'2021-08-24 17:54:24','2021-08-24 17:54:24',NULL),(2338,2973,646,40720,1539,19,251,1,2367.65,NULL,'2021-08-24 17:55:18','2021-08-24 17:55:18',NULL),(2339,2973,646,40720,1539,19,10,1,385441.50,NULL,'2021-08-24 17:55:18','2021-08-24 17:55:18',NULL),(2340,2973,646,40720,1539,19,57,1,278871.57,NULL,'2021-08-24 17:55:18','2021-08-24 17:55:18',NULL),(2341,2973,646,40720,1539,19,74,1,92639.15,NULL,'2021-08-24 17:55:18','2021-08-24 17:55:18',NULL),(2342,2973,646,40720,1539,19,487,1,6401.98,NULL,'2021-08-24 17:55:18','2021-08-24 17:55:18',NULL),(2343,2973,646,40720,1539,19,396,1,1331.00,NULL,'2021-08-24 17:55:18','2021-08-24 17:55:18',NULL);
INSERT INTO `balance_libro_details` VALUES (2344,2973,646,40720,1539,19,20,1,86345.97,NULL,'2021-08-24 17:55:18','2021-08-24 17:55:18',NULL),(2345,2973,646,40720,1539,19,13,2,385441.50,NULL,'2021-08-24 17:55:18','2021-08-24 17:55:18',NULL),(2346,2973,646,40720,1539,19,10,2,687957.32,NULL,'2021-08-24 17:55:18','2021-08-24 17:55:18',NULL),(2347,2973,646,40720,1539,19,489,1,110000.00,NULL,'2021-08-24 17:55:18','2021-08-24 17:55:18',NULL),(2348,2973,646,40720,1539,19,488,1,110000.00,NULL,'2021-08-24 17:55:18','2021-08-24 17:55:18',NULL),(2349,2973,647,40720,1540,19,251,1,2380.07,NULL,'2021-08-24 17:56:34','2021-08-24 17:56:34',NULL),(2350,2973,647,40720,1540,19,10,1,702716.50,NULL,'2021-08-24 17:56:34','2021-08-24 17:56:34',NULL),(2351,2973,647,40720,1540,19,57,1,45019.86,NULL,'2021-08-24 17:56:34','2021-08-24 17:56:34',NULL),(2352,2973,647,40720,1540,19,74,1,36614.36,NULL,'2021-08-24 17:56:34','2021-08-24 17:56:34',NULL),(2353,2973,647,40720,1540,19,487,1,4803.96,NULL,'2021-08-24 17:56:34','2021-08-24 17:56:34',NULL),(2354,2973,647,40720,1540,19,396,1,1331.00,NULL,'2021-08-24 17:56:34','2021-08-24 17:56:34',NULL),(2355,2973,647,40720,1540,19,20,1,86345.97,NULL,'2021-08-24 17:56:34','2021-08-24 17:56:34',NULL),(2356,2973,647,40720,1540,19,10,2,416495.22,NULL,'2021-08-24 17:56:34','2021-08-24 17:56:34',NULL),(2357,2973,647,40720,1540,19,13,2,702716.50,NULL,'2021-08-24 17:56:34','2021-08-24 17:56:34',NULL),(2358,2973,647,40720,1540,19,489,1,120000.00,NULL,'2021-08-24 17:56:34','2021-08-24 17:56:34',NULL),(2359,2973,647,40720,1540,19,488,1,120000.00,NULL,'2021-08-24 17:56:34','2021-08-24 17:56:34',NULL),(2360,2973,648,40720,1541,19,251,1,5775.32,NULL,'2021-08-24 17:57:25','2021-08-24 17:57:25',NULL),(2361,2973,648,40720,1541,19,10,1,954662.48,NULL,'2021-08-24 17:57:25','2021-08-24 17:57:25',NULL),(2362,2973,648,40720,1541,19,359,1,20000.00,NULL,'2021-08-24 17:57:25','2021-08-24 17:57:25',NULL),(2363,2973,648,40720,1541,19,57,1,262386.02,NULL,'2021-08-24 17:57:25','2021-08-24 17:57:25',NULL),(2364,2973,648,40720,1541,19,74,1,139674.50,NULL,'2021-08-24 17:57:25','2021-08-24 17:57:25',NULL),(2365,2973,648,40720,1541,19,487,1,11370.24,NULL,'2021-08-24 17:57:25','2021-08-24 17:57:25',NULL),(2366,2973,648,40720,1541,19,396,1,1754.50,NULL,'2021-08-24 17:57:25','2021-08-24 17:57:25',NULL),(2367,2973,648,40720,1541,19,20,1,86345.97,NULL,'2021-08-24 17:57:25','2021-08-24 17:57:25',NULL),(2368,2973,648,40720,1541,19,448,1,26416.27,NULL,'2021-08-24 17:57:25','2021-08-24 17:57:25',NULL),(2369,2973,648,40720,1541,19,467,1,1197.54,NULL,'2021-08-24 17:57:25','2021-08-24 17:57:25',NULL),(2370,2973,648,40720,1541,19,396,2,1774.99,NULL,'2021-08-24 17:57:25','2021-08-24 17:57:25',NULL),(2371,2973,648,40720,1541,19,13,2,952887.49,NULL,'2021-08-24 17:57:25','2021-08-24 17:57:25',NULL),(2372,2973,648,40720,1541,19,10,2,954920.36,NULL,'2021-08-24 17:57:25','2021-08-24 17:57:25',NULL),(2373,2973,648,40720,1541,19,489,1,200000.00,NULL,'2021-08-24 17:57:25','2021-08-24 17:57:25',NULL),(2374,2973,648,40720,1541,19,488,1,200000.00,NULL,'2021-08-24 17:57:25','2021-08-24 17:57:25',NULL),(2375,2973,649,40720,1531,19,251,1,2153.24,NULL,'2021-08-24 18:09:57','2021-08-24 18:20:48','2021-08-24 18:20:48'),(2376,2973,649,40720,1531,19,10,1,717749.10,NULL,'2021-08-24 18:09:57','2021-08-24 18:20:48','2021-08-24 18:20:48'),(2377,2973,649,40720,1531,19,57,1,1011538.92,NULL,'2021-08-24 18:09:57','2021-08-24 18:20:48','2021-08-24 18:20:48'),(2378,2973,649,40720,1531,19,74,1,102622.79,NULL,'2021-08-24 18:09:57','2021-08-24 18:20:48','2021-08-24 18:20:48'),(2379,2973,649,40720,1531,19,486,1,2566.33,NULL,'2021-08-24 18:09:57','2021-08-24 18:20:48','2021-08-24 18:20:48'),(2380,2973,649,40720,1531,19,487,1,3896.36,NULL,'2021-08-24 18:09:57','2021-08-24 18:20:48','2021-08-24 18:20:48'),(2381,2973,649,40720,1531,19,157,1,7910.78,NULL,'2021-08-24 18:09:57','2021-08-24 18:20:48','2021-08-24 18:20:48'),(2382,2973,649,40720,1531,19,396,1,121.00,NULL,'2021-08-24 18:09:57','2021-08-24 18:20:48','2021-08-24 18:20:48');
INSERT INTO `balance_libro_details` VALUES (2383,2973,649,40720,1531,19,359,2,175000.00,NULL,'2021-08-24 18:09:57','2021-08-24 18:20:48','2021-08-24 18:20:48'),(2384,2973,649,40720,1531,19,13,2,542749.10,NULL,'2021-08-24 18:09:57','2021-08-24 18:20:48','2021-08-24 18:20:48'),(2385,2973,649,40720,1531,19,10,2,1260809.42,NULL,'2021-08-24 18:09:57','2021-08-24 18:20:48','2021-08-24 18:20:48'),(2386,2973,649,40720,1531,19,488,1,65000.00,NULL,'2021-08-24 18:09:57','2021-08-24 18:20:48','2021-08-24 18:20:48'),(2387,2973,649,40720,1531,19,488,1,65000.00,NULL,'2021-08-24 18:09:57','2021-08-24 18:20:48','2021-08-24 18:20:48'),(2388,2973,650,40720,1531,19,251,1,2153.24,NULL,'2021-08-24 18:20:48','2021-08-24 18:23:27','2021-08-24 18:23:27'),(2389,2973,650,40720,1531,19,10,1,717749.10,NULL,'2021-08-24 18:20:48','2021-08-24 18:23:27','2021-08-24 18:23:27'),(2390,2973,650,40720,1531,19,57,1,1011538.92,NULL,'2021-08-24 18:20:48','2021-08-24 18:23:27','2021-08-24 18:23:27'),(2391,2973,650,40720,1531,19,74,1,102622.79,NULL,'2021-08-24 18:20:48','2021-08-24 18:23:27','2021-08-24 18:23:27'),(2392,2973,650,40720,1531,19,486,1,2566.33,NULL,'2021-08-24 18:20:48','2021-08-24 18:23:27','2021-08-24 18:23:27'),(2393,2973,650,40720,1531,19,487,1,3896.36,NULL,'2021-08-24 18:20:48','2021-08-24 18:23:27','2021-08-24 18:23:27'),(2394,2973,650,40720,1531,19,157,1,7910.78,NULL,'2021-08-24 18:20:48','2021-08-24 18:23:27','2021-08-24 18:23:27'),(2395,2973,650,40720,1531,19,396,1,121.00,NULL,'2021-08-24 18:20:48','2021-08-24 18:23:27','2021-08-24 18:23:27'),(2396,2973,650,40720,1531,19,359,2,175000.00,NULL,'2021-08-24 18:20:48','2021-08-24 18:23:27','2021-08-24 18:23:27'),(2397,2973,650,40720,1531,19,13,2,542749.10,NULL,'2021-08-24 18:20:48','2021-08-24 18:23:27','2021-08-24 18:23:27'),(2398,2973,650,40720,1531,19,10,2,1260809.42,NULL,'2021-08-24 18:20:48','2021-08-24 18:23:27','2021-08-24 18:23:27'),(2399,2973,650,40720,1531,19,488,1,65000.00,NULL,'2021-08-24 18:20:48','2021-08-24 18:23:27','2021-08-24 18:23:27'),(2400,2973,650,40720,1531,19,488,1,65000.00,NULL,'2021-08-24 18:20:48','2021-08-24 18:23:27','2021-08-24 18:23:27'),(2401,2973,651,40720,1531,19,251,1,2153.24,NULL,'2021-08-24 18:23:27','2021-08-25 08:23:33','2021-08-25 08:23:33'),(2402,2973,651,40720,1531,19,10,1,717749.10,NULL,'2021-08-24 18:23:27','2021-08-25 08:23:33','2021-08-25 08:23:33'),(2403,2973,651,40720,1531,19,57,1,1011538.92,NULL,'2021-08-24 18:23:27','2021-08-25 08:23:33','2021-08-25 08:23:33'),(2404,2973,651,40720,1531,19,74,1,102622.79,NULL,'2021-08-24 18:23:27','2021-08-25 08:23:33','2021-08-25 08:23:33'),(2405,2973,651,40720,1531,19,486,1,2566.33,NULL,'2021-08-24 18:23:27','2021-08-25 08:23:33','2021-08-25 08:23:33'),(2406,2973,651,40720,1531,19,487,1,3896.36,NULL,'2021-08-24 18:23:27','2021-08-25 08:23:33','2021-08-25 08:23:33'),(2407,2973,651,40720,1531,19,157,1,7910.78,NULL,'2021-08-24 18:23:27','2021-08-25 08:23:33','2021-08-25 08:23:33'),(2408,2973,651,40720,1531,19,396,1,121.00,NULL,'2021-08-24 18:23:27','2021-08-25 08:23:33','2021-08-25 08:23:33'),(2409,2973,651,40720,1531,19,359,2,175000.00,NULL,'2021-08-24 18:23:27','2021-08-25 08:23:33','2021-08-25 08:23:33'),(2410,2973,651,40720,1531,19,13,2,542749.10,NULL,'2021-08-24 18:23:27','2021-08-25 08:23:33','2021-08-25 08:23:33'),(2411,2973,651,40720,1531,19,10,2,1260809.42,NULL,'2021-08-24 18:23:27','2021-08-25 08:23:33','2021-08-25 08:23:33'),(2412,2973,651,40720,1531,19,488,1,65000.00,NULL,'2021-08-24 18:23:27','2021-08-25 08:23:33','2021-08-25 08:23:33'),(2413,2973,651,40720,1531,19,488,1,65000.00,NULL,'2021-08-24 18:23:27','2021-08-25 08:23:33','2021-08-25 08:23:33'),(2414,2973,652,40720,1531,19,251,1,2153.24,NULL,'2021-08-25 08:23:33','2021-08-25 08:23:33',NULL),(2415,2973,652,40720,1531,19,10,1,717749.10,NULL,'2021-08-25 08:23:33','2021-08-25 08:23:33',NULL),(2416,2973,652,40720,1531,19,57,1,1011538.92,NULL,'2021-08-25 08:23:33','2021-08-25 08:23:33',NULL),(2417,2973,652,40720,1531,19,74,1,102622.79,NULL,'2021-08-25 08:23:33','2021-08-25 08:23:33',NULL);
INSERT INTO `balance_libro_details` VALUES (2418,2973,652,40720,1531,19,486,1,2566.33,NULL,'2021-08-25 08:23:33','2021-08-25 08:23:33',NULL),(2419,2973,652,40720,1531,19,487,1,3896.36,NULL,'2021-08-25 08:23:33','2021-08-25 08:23:33',NULL),(2420,2973,652,40720,1531,19,157,1,7910.78,NULL,'2021-08-25 08:23:33','2021-08-25 08:23:33',NULL),(2421,2973,652,40720,1531,19,396,1,121.00,NULL,'2021-08-25 08:23:33','2021-08-25 08:23:33',NULL),(2422,2973,652,40720,1531,19,359,2,175000.00,NULL,'2021-08-25 08:23:33','2021-08-25 08:23:33',NULL),(2423,2973,652,40720,1531,19,13,2,542749.10,NULL,'2021-08-25 08:23:33','2021-08-25 08:23:33',NULL),(2424,2973,652,40720,1531,19,10,2,1260809.42,NULL,'2021-08-25 08:23:33','2021-08-25 08:23:33',NULL),(2425,2973,652,40720,1531,19,488,1,65000.00,NULL,'2021-08-25 08:23:33','2021-08-25 08:23:33',NULL),(2426,2973,652,40720,1531,19,489,1,65000.00,NULL,'2021-08-25 08:23:33','2021-08-25 08:23:33',NULL),(2427,2973,653,40720,1541,17,359,2,8301.87,NULL,'2021-08-25 09:03:30','2021-08-28 12:36:36','2021-08-28 12:36:36'),(2428,2973,653,40720,1541,17,10,2,408732.43,NULL,'2021-08-25 09:03:30','2021-08-28 12:36:36','2021-08-28 12:36:36'),(2429,2973,653,40720,1541,17,23,2,32617.65,NULL,'2021-08-25 09:03:30','2021-08-28 12:36:36','2021-08-28 12:36:36'),(2430,2973,653,40720,1541,17,487,2,68784.44,NULL,'2021-08-25 09:03:30','2021-08-28 12:36:36','2021-08-28 12:36:36'),(2431,2973,653,40720,1541,17,488,2,1644500.00,NULL,'2021-08-25 09:03:30','2021-08-28 12:36:36','2021-08-28 12:36:36'),(2432,2973,653,40720,1541,17,489,2,1644500.00,NULL,'2021-08-25 09:03:30','2021-08-28 12:36:36','2021-08-28 12:36:36'),(2433,2973,653,40720,1541,17,20,2,518179.49,NULL,'2021-08-25 09:03:30','2021-08-28 12:36:36','2021-08-28 12:36:36'),(2434,2973,653,40720,1541,17,311,2,8651.84,NULL,'2021-08-25 09:03:30','2021-08-28 12:36:36','2021-08-28 12:36:36'),(2435,2973,653,40720,1541,17,419,2,1147415.38,NULL,'2021-08-25 09:03:30','2021-08-28 12:36:36','2021-08-28 12:36:36'),(2436,2973,653,40720,1541,17,391,2,34941.99,NULL,'2021-08-25 09:03:30','2021-08-28 12:36:36','2021-08-28 12:36:36'),(2437,2973,653,40720,1541,17,420,1,175837.24,NULL,'2021-08-25 09:03:30','2021-08-28 12:36:36','2021-08-28 12:36:36'),(2438,2973,653,40720,1541,17,415,1,1312.22,NULL,'2021-08-25 09:03:30','2021-08-28 12:36:36','2021-08-28 12:36:36'),(2439,2973,653,40720,1541,17,57,1,9472.17,NULL,'2021-08-25 09:03:30','2021-08-28 12:36:36','2021-08-28 12:36:36'),(2440,2973,653,40720,1541,17,74,1,115841.15,NULL,'2021-08-25 09:03:30','2021-08-28 12:36:36','2021-08-28 12:36:36'),(2441,2973,653,40720,1541,17,411,1,350000.00,NULL,'2021-08-25 09:03:30','2021-08-28 12:36:36','2021-08-28 12:36:36'),(2442,2973,653,40720,1541,17,486,1,18373.85,NULL,'2021-08-25 09:03:30','2021-08-28 12:36:36','2021-08-28 12:36:36'),(2443,2973,653,40720,1541,17,448,1,449076.62,NULL,'2021-08-25 09:03:30','2021-08-28 12:36:36','2021-08-28 12:36:36'),(2444,2973,653,40720,1541,17,88,1,16570.53,NULL,'2021-08-25 09:03:30','2021-08-28 12:36:36','2021-08-28 12:36:36'),(2445,2973,653,40720,1541,17,369,1,50000.00,NULL,'2021-08-25 09:03:30','2021-08-28 12:36:36','2021-08-28 12:36:36'),(2446,2973,653,40720,1541,17,91,1,3968685.38,NULL,'2021-08-25 09:03:30','2021-08-28 12:36:36','2021-08-28 12:36:36'),(2447,2973,653,40720,1541,17,383,1,299574.28,NULL,'2021-08-25 09:03:30','2021-08-28 12:36:36','2021-08-28 12:36:36'),(2448,2973,653,40720,1541,17,381,1,61881.65,NULL,'2021-08-25 09:03:30','2021-08-28 12:36:36','2021-08-28 12:36:36'),(2449,2973,654,40720,1541,19,367,2,800000.00,NULL,'2021-08-28 11:56:17','2021-08-28 11:56:17',NULL),(2450,2973,654,40720,1541,19,192,1,800000.00,NULL,'2021-08-28 11:56:17','2021-08-28 11:56:17',NULL),(2451,2973,655,40720,1541,19,421,1,229483.08,NULL,'2021-08-28 12:31:26','2021-08-28 12:45:04','2021-08-28 12:45:04'),(2452,2973,655,40720,1541,19,422,1,3494.20,NULL,'2021-08-28 12:31:26','2021-08-28 12:45:04','2021-08-28 12:45:04'),(2453,2973,655,40720,1541,19,415,2,229483.08,NULL,'2021-08-28 12:31:26','2021-08-28 12:45:04','2021-08-28 12:45:04');
INSERT INTO `balance_libro_details` VALUES (2454,2973,655,40720,1541,19,420,2,3494.20,NULL,'2021-08-28 12:31:26','2021-08-28 12:45:04','2021-08-28 12:45:04'),(2455,2973,656,40720,1541,19,421,1,229483.08,NULL,'2021-08-28 12:45:04','2021-08-28 12:45:04',NULL),(2456,2973,656,40720,1541,19,422,1,3494.20,NULL,'2021-08-28 12:45:04','2021-08-28 12:45:04',NULL),(2457,2973,656,40720,1541,19,415,2,3494.20,NULL,'2021-08-28 12:45:04','2021-08-28 12:45:04',NULL),(2458,2973,656,40720,1541,19,420,2,229483.08,NULL,'2021-08-28 12:45:04','2021-08-28 12:45:04',NULL),(2459,2973,657,40720,1541,19,155,1,1038857.27,NULL,'2021-08-28 14:00:48','2021-08-28 14:00:48',NULL),(2460,2973,657,40720,1541,19,411,2,1038857.27,NULL,'2021-08-28 14:00:48','2021-08-28 14:00:48',NULL),(2461,2973,658,40722,3058,2,96,2,3297.52,NULL,'2021-09-09 14:39:50','2021-09-09 14:39:50',NULL),(2462,2973,658,40722,3058,2,67,2,692.48,NULL,'2021-09-09 14:39:50','2021-09-09 14:39:50',NULL),(2463,2973,658,40722,3058,2,13,1,3990.00,NULL,'2021-09-09 14:39:50','2021-09-09 14:39:50',NULL),(2464,2973,659,40722,3058,2,96,2,3297.52,NULL,'2021-09-09 14:39:50','2021-09-09 14:39:50',NULL),(2465,2973,659,40722,3058,2,67,2,692.48,NULL,'2021-09-09 14:39:50','2021-09-09 14:39:50',NULL),(2466,2973,659,40722,3058,2,13,1,3990.00,NULL,'2021-09-09 14:39:50','2021-09-09 14:39:50',NULL),(2467,2973,660,40722,3058,2,96,2,2705.78,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2468,2973,660,40722,3058,2,67,2,568.21,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2469,2973,660,40722,3058,2,13,1,3273.99,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2470,2973,661,40722,3058,2,96,2,6849.58,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2471,2973,661,40722,3058,2,67,2,1438.41,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2472,2973,661,40722,3058,2,13,1,8287.99,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2473,2973,662,40722,3058,2,96,2,2379.42,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2474,2973,662,40722,3058,2,67,2,499.68,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2475,2973,662,40722,3058,2,13,1,2879.10,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2476,2973,663,40722,3058,2,96,2,143.80,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2477,2973,663,40722,3058,2,67,2,30.20,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2478,2973,663,40722,3058,2,13,1,174.00,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2479,2973,664,40722,3058,2,96,2,1955.37,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2480,2973,664,40722,3058,2,67,2,410.63,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2481,2973,664,40722,3058,2,13,1,2366.00,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2482,2973,665,40722,3058,2,96,2,1560.33,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2483,2973,665,40722,3058,2,67,2,327.67,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2484,2973,665,40722,3058,2,13,1,1888.00,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2485,2973,666,40722,3058,2,96,2,1709.09,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2486,2973,666,40722,3058,2,67,2,358.91,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2487,2973,666,40722,3058,2,13,1,2068.00,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2488,2973,667,40722,3058,2,96,2,3303.31,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2489,2973,667,40722,3058,2,67,2,693.69,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2490,2973,667,40722,3058,2,13,1,3997.00,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2491,2973,668,40722,3058,2,96,2,1343.80,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2492,2973,668,40722,3058,2,67,2,282.20,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2493,2973,668,40722,3058,2,13,1,1626.00,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2494,2973,669,40722,3058,2,96,2,5356.20,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL);
INSERT INTO `balance_libro_details` VALUES (2495,2973,669,40722,3058,2,67,2,1124.80,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2496,2973,669,40722,3058,2,13,1,6481.00,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2497,2973,670,40722,3058,2,96,2,710.74,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2498,2973,670,40722,3058,2,67,2,149.26,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2499,2973,670,40722,3058,2,13,1,860.00,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2500,2973,671,40722,3058,2,96,2,1035.54,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2501,2973,671,40722,3058,2,67,2,217.46,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2502,2973,671,40722,3058,2,13,1,1253.00,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2503,2973,672,40722,3058,2,96,2,2440.50,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2504,2973,672,40722,3058,2,67,2,512.50,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2505,2973,672,40722,3058,2,13,1,2953.00,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2506,2973,673,40722,3058,2,96,2,2440.50,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2507,2973,673,40722,3058,2,67,2,512.50,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2508,2973,673,40722,3058,2,13,1,2953.00,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2509,2973,674,40722,3058,2,96,2,1544.63,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2510,2973,674,40722,3058,2,67,2,324.37,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2511,2973,674,40722,3058,2,13,1,1869.00,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2512,2973,675,40722,3058,2,96,2,136.36,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2513,2973,675,40722,3058,2,67,2,28.64,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2514,2973,675,40722,3058,2,13,1,165.00,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2515,2973,676,40722,3058,2,96,2,710.74,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2516,2973,676,40722,3058,2,67,2,149.26,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2517,2973,676,40722,3058,2,13,1,860.00,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2518,2973,677,40722,3058,2,96,2,3928.93,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2519,2973,677,40722,3058,2,67,2,825.07,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2520,2973,677,40722,3058,2,13,1,4754.00,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2521,2973,678,40722,3058,2,96,2,1742.48,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2522,2973,678,40722,3058,2,67,2,365.92,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2523,2973,678,40722,3058,2,13,1,2108.40,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2524,2973,679,40722,3058,2,96,2,953.72,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2525,2973,679,40722,3058,2,67,2,200.28,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2526,2973,679,40722,3058,2,13,1,1154.00,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2527,2973,680,40722,3058,2,96,2,1903.88,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2528,2973,680,40722,3058,2,67,2,399.82,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2529,2973,680,40722,3058,2,13,1,2303.70,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2530,2973,681,40722,3058,2,96,2,863.64,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2531,2973,681,40722,3058,2,67,2,181.36,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2532,2973,681,40722,3058,2,13,1,1045.00,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2533,2973,682,40722,3058,2,96,2,1546.28,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2534,2973,682,40722,3058,2,67,2,324.72,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2535,2973,682,40722,3058,2,13,1,1871.00,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL);
INSERT INTO `balance_libro_details` VALUES (2536,2973,683,40722,3058,2,96,2,4000.83,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2537,2973,683,40722,3058,2,67,2,840.17,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2538,2973,683,40722,3058,2,13,1,4841.00,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2539,2973,684,40722,3058,2,96,2,365.29,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2540,2973,684,40722,3058,2,67,2,76.71,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2541,2973,684,40722,3058,2,13,1,442.00,NULL,'2021-09-09 14:39:51','2021-09-09 14:39:51',NULL),(2542,2973,685,40722,3058,2,96,2,2413.22,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2543,2973,685,40722,3058,2,67,2,506.78,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2544,2973,685,40722,3058,2,13,1,2920.00,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2545,2973,686,40722,3058,2,96,2,996.69,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2546,2973,686,40722,3058,2,67,2,209.31,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2547,2973,686,40722,3058,2,13,1,1206.00,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2548,2973,687,40722,3058,2,96,2,2371.90,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2549,2973,687,40722,3058,2,67,2,498.10,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2550,2973,687,40722,3058,2,13,1,2870.00,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2551,2973,688,40722,3058,2,96,2,1646.28,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2552,2973,688,40722,3058,2,67,2,345.72,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2553,2973,688,40722,3058,2,13,1,1992.00,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2554,2973,689,40722,3058,2,96,2,1206.61,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2555,2973,689,40722,3058,2,67,2,253.39,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2556,2973,689,40722,3058,2,13,1,1460.00,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2557,2973,690,40722,3058,2,96,2,1595.04,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2558,2973,690,40722,3058,2,67,2,334.96,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2559,2973,690,40722,3058,2,13,1,1930.00,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2560,2973,691,40722,3058,2,96,2,3595.04,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2561,2973,691,40722,3058,2,67,2,754.96,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2562,2973,691,40722,3058,2,13,1,4350.00,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2563,2973,692,40722,3058,2,96,2,1421.49,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2564,2973,692,40722,3058,2,67,2,298.51,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2565,2973,692,40722,3058,2,13,1,1720.00,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2566,2973,693,40722,3058,2,96,2,2390.08,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2567,2973,693,40722,3058,2,67,2,501.92,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2568,2973,693,40722,3058,2,13,1,2892.00,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2569,2973,694,40722,3058,2,96,2,990.12,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2570,2973,694,40722,3058,2,67,2,207.93,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2571,2973,694,40722,3058,2,13,1,1198.05,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2572,2973,695,40722,3058,2,96,2,105.79,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2573,2973,695,40722,3058,2,67,2,22.21,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2574,2973,695,40722,3058,2,13,1,128.00,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2575,2973,696,40722,3058,2,96,2,2467.77,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2576,2973,696,40722,3058,2,67,2,518.23,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL);
INSERT INTO `balance_libro_details` VALUES (2577,2973,696,40722,3058,2,13,1,2986.00,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2578,2973,697,40722,3058,2,96,2,600.83,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2579,2973,697,40722,3058,2,67,2,126.17,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2580,2973,697,40722,3058,2,13,1,727.00,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2581,2973,698,40722,3058,2,96,2,1812.40,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2582,2973,698,40722,3058,2,67,2,380.60,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2583,2973,698,40722,3058,2,13,1,2193.00,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2584,2973,699,40722,3058,2,96,2,826.98,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2585,2973,699,40722,3058,2,67,2,173.67,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2586,2973,699,40722,3058,2,13,1,1000.65,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2587,2973,700,40722,3058,2,96,2,826.98,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2588,2973,700,40722,3058,2,67,2,173.67,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2589,2973,700,40722,3058,2,13,1,1000.65,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2590,2973,701,40722,3058,2,96,2,4635.62,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2591,2973,701,40722,3058,2,67,2,973.48,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2592,2973,701,40722,3058,2,13,1,5609.10,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2593,2973,702,40722,3058,2,96,2,2719.01,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2594,2973,702,40722,3058,2,67,2,570.99,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2595,2973,702,40722,3058,2,13,1,3290.00,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2596,2973,703,40722,3058,2,96,2,1359.50,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2597,2973,703,40722,3058,2,67,2,285.50,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2598,2973,703,40722,3058,2,13,1,1645.00,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2599,2973,704,40722,3058,2,96,2,2783.47,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2600,2973,704,40722,3058,2,67,2,584.53,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2601,2973,704,40722,3058,2,13,1,3368.00,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2602,2973,705,40722,3058,2,96,2,429.52,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2603,2973,705,40722,3058,2,67,2,21.48,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2604,2973,705,40722,3058,2,13,1,451.00,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2605,2973,706,40722,3058,2,96,2,1812.40,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2606,2973,706,40722,3058,2,67,2,380.60,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2607,2973,706,40722,3058,2,13,1,2193.00,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2608,2973,707,40722,3058,2,96,2,2244.63,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2609,2973,707,40722,3058,2,67,2,471.37,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2610,2973,707,40722,3058,2,13,1,2716.00,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2611,2973,708,40722,3058,2,96,2,1574.38,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2612,2973,708,40722,3058,2,67,2,330.62,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2613,2973,708,40722,3058,2,13,1,1905.00,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2614,2973,709,40722,3058,2,96,2,405.79,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2615,2973,709,40722,3058,2,67,2,85.21,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2616,2973,709,40722,3058,2,13,1,491.00,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2617,2973,710,40722,3058,2,96,2,5198.35,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL);
INSERT INTO `balance_libro_details` VALUES (2618,2973,710,40722,3058,2,67,2,1091.65,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2619,2973,710,40722,3058,2,13,1,6290.00,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2620,2973,711,40722,3058,2,96,2,4000.83,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2621,2973,711,40722,3058,2,67,2,840.17,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2622,2973,711,40722,3058,2,13,1,4841.00,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2623,2973,712,40722,3058,2,96,2,1483.51,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2624,2973,712,40722,3058,2,67,2,311.54,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2625,2973,712,40722,3058,2,13,1,1795.05,NULL,'2021-09-09 14:39:52','2021-09-09 14:39:52',NULL),(2626,2973,713,40722,3058,2,96,2,1189.71,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2627,2973,713,40722,3058,2,67,2,249.84,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2628,2973,713,40722,3058,2,13,1,1439.55,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2629,2973,714,40722,3058,2,96,2,4478.51,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2630,2973,714,40722,3058,2,67,2,940.49,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2631,2973,714,40722,3058,2,13,1,5419.00,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2632,2973,715,40722,3058,2,96,2,547.93,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2633,2973,715,40722,3058,2,67,2,115.07,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2634,2973,715,40722,3058,2,13,1,663.00,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2635,2973,716,40722,3058,2,96,2,3428.10,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2636,2973,716,40722,3058,2,67,2,719.90,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2637,2973,716,40722,3058,2,13,1,4148.00,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2638,2973,717,40722,3058,2,96,2,1959.50,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2639,2973,717,40722,3058,2,67,2,411.50,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2640,2973,717,40722,3058,2,13,1,2371.00,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2641,2973,718,40722,3058,2,96,2,2033.88,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2642,2973,718,40722,3058,2,67,2,427.12,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2643,2973,718,40722,3058,2,13,1,2461.00,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2644,2973,719,40722,3058,2,96,2,2067.77,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2645,2973,719,40722,3058,2,67,2,434.23,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2646,2973,719,40722,3058,2,13,1,2502.00,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2647,2973,720,40722,3058,2,96,2,2316.94,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2648,2973,720,40722,3058,2,67,2,486.56,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2649,2973,720,40722,3058,2,13,1,2803.50,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2650,2973,721,40722,3058,2,96,2,863.64,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2651,2973,721,40722,3058,2,67,2,181.36,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2652,2973,721,40722,3058,2,13,1,1045.00,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2653,2973,722,40722,3058,2,96,2,673.55,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2654,2973,722,40722,3058,2,67,2,141.45,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2655,2973,722,40722,3058,2,13,1,815.00,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2656,2973,723,40722,3058,2,96,2,558.68,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2657,2973,723,40722,3058,2,67,2,117.32,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2658,2973,723,40722,3058,2,13,1,676.00,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL);
INSERT INTO `balance_libro_details` VALUES (2659,2973,724,40722,3058,2,96,2,1199.17,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2660,2973,724,40722,3058,2,67,2,251.83,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2661,2973,724,40722,3058,2,13,1,1451.00,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2662,2973,725,40722,3058,2,96,2,1651.24,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2663,2973,725,40722,3058,2,67,2,346.76,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2664,2973,725,40722,3058,2,13,1,1998.00,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2665,2973,726,40722,3058,2,96,2,629.75,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2666,2973,726,40722,3058,2,67,2,132.25,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2667,2973,726,40722,3058,2,13,1,762.00,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2668,2973,727,40722,3058,2,96,2,3275.20,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2669,2973,727,40722,3058,2,67,2,687.80,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2670,2973,727,40722,3058,2,13,1,3963.00,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2671,2973,728,40722,3058,2,96,2,4876.86,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2672,2973,728,40722,3058,2,67,2,1024.14,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2673,2973,728,40722,3058,2,13,1,5901.00,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2674,2973,729,40722,3058,2,96,2,2706.61,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2675,2973,729,40722,3058,2,67,2,568.39,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2676,2973,729,40722,3058,2,13,1,3275.00,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2677,2973,730,40722,3058,2,96,2,4815.70,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2678,2973,730,40722,3058,2,67,2,1011.30,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2679,2973,730,40722,3058,2,13,1,5827.00,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2680,2973,731,40722,3058,2,96,2,768.84,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2681,2973,731,40722,3058,2,67,2,161.46,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2682,2973,731,40722,3058,2,13,1,930.30,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2683,2973,732,40722,3058,2,96,2,1770.25,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2684,2973,732,40722,3058,2,67,2,371.75,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2685,2973,732,40722,3058,2,13,1,2142.00,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2686,2973,733,40722,3058,2,96,2,1773.55,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2687,2973,733,40722,3058,2,67,2,372.45,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2688,2973,733,40722,3058,2,13,1,2146.00,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2689,2973,734,40722,3058,2,96,2,785.12,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2690,2973,734,40722,3058,2,67,2,164.88,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2691,2973,734,40722,3058,2,13,1,950.00,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2692,2973,735,40722,3058,2,96,2,4513.22,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2693,2973,735,40722,3058,2,67,2,947.78,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2694,2973,735,40722,3058,2,13,1,5461.00,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2695,2973,736,40722,3058,2,96,2,6113.22,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2696,2973,736,40722,3058,2,67,2,1283.78,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2697,2973,736,40722,3058,2,13,1,7397.00,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2698,2973,737,40722,3058,2,96,2,2211.61,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2699,2973,737,40722,3058,2,67,2,464.44,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL);
INSERT INTO `balance_libro_details` VALUES (2700,2973,737,40722,3058,2,13,1,2676.05,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2701,2973,738,40722,3058,2,96,2,4582.64,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2702,2973,738,40722,3058,2,67,2,962.35,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2703,2973,738,40722,3058,2,13,1,5544.99,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2704,2973,739,40722,3058,2,96,2,3350.18,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2705,2973,739,40722,3058,2,67,2,703.54,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2706,2973,739,40722,3058,2,13,1,4053.72,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2707,2973,740,40722,3058,2,96,2,655.37,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2708,2973,740,40722,3058,2,67,2,137.63,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2709,2973,740,40722,3058,2,13,1,793.00,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2710,2973,741,40722,3058,2,96,2,3710.74,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2711,2973,741,40722,3058,2,67,2,779.26,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2712,2973,741,40722,3058,2,13,1,4490.00,NULL,'2021-09-09 14:39:53','2021-09-09 14:39:53',NULL),(2713,2973,742,40722,3058,2,96,2,1042.98,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2714,2973,742,40722,3058,2,67,2,219.02,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2715,2973,742,40722,3058,2,13,1,1262.00,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2716,2973,743,40722,3058,2,96,2,4826.45,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2717,2973,743,40722,3058,2,67,2,1013.55,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2718,2973,743,40722,3058,2,13,1,5840.00,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2719,2973,744,40722,3058,2,96,2,3735.54,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2720,2973,744,40722,3058,2,67,2,784.46,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2721,2973,744,40722,3058,2,13,1,4520.00,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2722,2973,745,40722,3058,2,96,2,827.85,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2723,2973,745,40722,3058,2,67,2,173.85,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2724,2973,745,40722,3058,2,13,1,1001.70,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2725,2973,746,40722,3058,2,96,2,730.58,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2726,2973,746,40722,3058,2,67,2,153.42,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2727,2973,746,40722,3058,2,13,1,884.00,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2728,2973,747,40722,3058,2,96,2,3395.87,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2729,2973,747,40722,3058,2,67,2,713.13,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2730,2973,747,40722,3058,2,13,1,4109.00,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2731,2973,748,40722,3058,2,96,2,561.98,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2732,2973,748,40722,3058,2,67,2,118.02,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2733,2973,748,40722,3058,2,13,1,680.00,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2734,2973,749,40722,3058,2,96,2,2125.62,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2735,2973,749,40722,3058,2,67,2,446.38,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2736,2973,749,40722,3058,2,13,1,2572.00,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2737,2973,750,40722,3058,2,96,2,1122.31,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2738,2973,750,40722,3058,2,67,2,235.69,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2739,2973,750,40722,3058,2,13,1,1358.00,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2740,2973,751,40722,3058,2,96,2,1253.93,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL);
INSERT INTO `balance_libro_details` VALUES (2741,2973,751,40722,3058,2,67,2,263.32,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2742,2973,751,40722,3058,2,13,1,1517.25,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2743,2973,752,40722,3058,2,96,2,1127.23,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2744,2973,752,40722,3058,2,67,2,236.72,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2745,2973,752,40722,3058,2,13,1,1363.95,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2746,2973,753,40722,3058,2,96,2,1035.54,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2747,2973,753,40722,3058,2,67,2,217.46,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2748,2973,753,40722,3058,2,13,1,1253.00,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2749,2973,754,40722,3058,2,96,2,890.91,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2750,2973,754,40722,3058,2,67,2,187.09,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2751,2973,754,40722,3058,2,13,1,1078.00,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2752,2973,755,40722,3058,2,96,2,3352.07,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2753,2973,755,40722,3058,2,67,2,703.93,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2754,2973,755,40722,3058,2,13,1,4056.00,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2755,2973,756,40722,3058,2,96,2,1935.95,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2756,2973,756,40722,3058,2,67,2,406.55,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2757,2973,756,40722,3058,2,13,1,2342.50,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2758,2973,757,40722,3058,2,96,2,6056.20,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2759,2973,757,40722,3058,2,67,2,1271.80,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2760,2973,757,40722,3058,2,13,1,7328.00,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2761,2973,758,40722,3058,2,96,2,817.36,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2762,2973,758,40722,3058,2,67,2,171.64,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2763,2973,758,40722,3058,2,13,1,989.00,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2764,2973,759,40722,3058,2,96,2,1128.93,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2765,2973,759,40722,3058,2,67,2,237.07,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2766,2973,759,40722,3058,2,13,1,1366.00,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2767,2973,760,40722,3058,2,96,2,985.95,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2768,2973,760,40722,3058,2,67,2,207.05,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2769,2973,760,40722,3058,2,13,1,1193.00,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2770,2973,761,40722,3058,2,96,2,3352.07,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2771,2973,761,40722,3058,2,67,2,703.93,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2772,2973,761,40722,3058,2,13,1,4056.00,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2773,2973,762,40722,3058,2,96,2,4815.70,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2774,2973,762,40722,3058,2,67,2,1011.30,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2775,2973,762,40722,3058,2,13,1,5827.00,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2776,2973,763,40722,3058,2,96,2,1111.57,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2777,2973,763,40722,3058,2,67,2,233.43,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2778,2973,763,40722,3058,2,13,1,1345.00,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2779,2973,764,40722,3058,2,96,2,1712.64,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2780,2973,764,40722,3058,2,67,2,359.66,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2781,2973,764,40722,3058,2,13,1,2072.30,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL);
INSERT INTO `balance_libro_details` VALUES (2782,2973,765,40722,3058,2,96,2,384.92,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2783,2973,765,40722,3058,2,67,2,80.83,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2784,2973,765,40722,3058,2,13,1,465.75,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2785,2973,766,40722,3058,2,96,2,863.64,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2786,2973,766,40722,3058,2,67,2,181.36,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2787,2973,766,40722,3058,2,13,1,1045.00,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2788,2973,767,40722,3058,2,96,2,2806.57,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2789,2973,767,40722,3058,2,67,2,589.38,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2790,2973,767,40722,3058,2,13,1,3395.95,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2791,2973,768,40722,3058,2,96,2,863.64,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2792,2973,768,40722,3058,2,67,2,181.36,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2793,2973,768,40722,3058,2,13,1,1045.00,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2794,2973,769,40722,3058,2,96,2,1773.55,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2795,2973,769,40722,3058,2,67,2,372.45,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2796,2973,769,40722,3058,2,13,1,2146.00,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2797,2973,770,40722,3058,2,96,2,818.25,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2798,2973,770,40722,3058,2,67,2,171.83,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2799,2973,770,40722,3058,2,13,1,990.08,NULL,'2021-09-09 14:39:54','2021-09-09 14:39:54',NULL),(2800,2973,771,40722,3058,2,96,2,628.10,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2801,2973,771,40722,3058,2,67,2,131.90,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2802,2973,771,40722,3058,2,13,1,760.00,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2803,2973,772,40722,3058,2,96,2,1801.03,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2804,2973,772,40722,3058,2,67,2,378.22,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2805,2973,772,40722,3058,2,13,1,2179.25,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2806,2973,773,40722,3058,2,96,2,2831.57,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2807,2973,773,40722,3058,2,67,2,594.63,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2808,2973,773,40722,3058,2,13,1,3426.20,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2809,2973,774,40722,3058,2,96,2,1094.21,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2810,2973,774,40722,3058,2,67,2,229.79,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2811,2973,774,40722,3058,2,13,1,1324.00,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2812,2973,775,40722,3058,2,96,2,2057.85,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2813,2973,775,40722,3058,2,67,2,432.15,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2814,2973,775,40722,3058,2,13,1,2490.00,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2815,2973,776,40722,3058,2,96,2,3125.70,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2816,2973,776,40722,3058,2,67,2,656.40,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2817,2973,776,40722,3058,2,13,1,3782.10,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2818,2973,777,40722,3058,2,96,2,1582.81,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2819,2973,777,40722,3058,2,67,2,332.39,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2820,2973,777,40722,3058,2,13,1,1915.20,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2821,2973,778,40722,3058,2,96,2,418.38,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2822,2973,778,40722,3058,2,67,2,87.86,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2823,2973,778,40722,3058,2,13,1,506.24,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL);
INSERT INTO `balance_libro_details` VALUES (2824,2973,779,40722,3058,2,96,2,3352.07,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2825,2973,779,40722,3058,2,67,2,703.93,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2826,2973,779,40722,3058,2,13,1,4056.00,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2827,2973,780,40722,3058,2,96,2,1489.32,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2828,2973,780,40722,3058,2,67,2,312.76,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2829,2973,780,40722,3058,2,13,1,1802.08,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2830,2973,781,40722,3058,2,96,2,2719.01,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2831,2973,781,40722,3058,2,67,2,570.99,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2832,2973,781,40722,3058,2,13,1,3290.00,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2833,2973,782,40722,3058,2,96,2,8351.24,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2834,2973,782,40722,3058,2,67,2,1753.76,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2835,2973,782,40722,3058,2,13,1,10105.00,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2836,2973,783,40722,3058,2,96,2,417.45,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2837,2973,783,40722,3058,2,67,2,87.67,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2838,2973,783,40722,3058,2,13,1,505.12,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2839,2973,784,40722,3058,2,96,2,1948.35,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2840,2973,784,40722,3058,2,67,2,409.15,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2841,2973,784,40722,3058,2,13,1,2357.50,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2842,2973,785,40722,3058,2,96,2,4547.10,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2843,2973,785,40722,3058,2,67,2,954.89,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2844,2973,785,40722,3058,2,13,1,5501.99,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2845,2973,786,40722,3058,2,96,2,2211.61,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2846,2973,786,40722,3058,2,67,2,464.44,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2847,2973,786,40722,3058,2,13,1,2676.05,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2848,2973,787,40722,3058,2,96,2,4220.82,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2849,2973,787,40722,3058,2,67,2,886.37,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2850,2973,787,40722,3058,2,13,1,5107.19,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2851,2973,788,40722,3058,2,96,2,820.66,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2852,2973,788,40722,3058,2,67,2,172.34,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2853,2973,788,40722,3058,2,13,1,993.00,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2854,2973,789,40722,3058,2,96,2,3764.46,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2855,2973,789,40722,3058,2,67,2,790.54,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2856,2973,789,40722,3058,2,13,1,4555.00,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2857,2973,790,40722,3058,2,96,2,1094.21,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2858,2973,790,40722,3058,2,67,2,229.79,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2859,2973,790,40722,3058,2,13,1,1324.00,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2860,2973,791,40722,3058,2,96,2,2962.12,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2861,2973,791,40722,3058,2,67,2,622.04,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2862,2973,791,40722,3058,2,13,1,3584.16,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2863,2973,792,40722,3058,2,96,2,1253.93,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2864,2973,792,40722,3058,2,67,2,263.32,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL);
INSERT INTO `balance_libro_details` VALUES (2865,2973,792,40722,3058,2,13,1,1517.25,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2866,2973,793,40722,3058,2,96,2,3532.23,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2867,2973,793,40722,3058,2,67,2,741.77,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2868,2973,793,40722,3058,2,13,1,4274.00,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2869,2973,794,40722,3058,2,96,2,5524.05,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2870,2973,794,40722,3058,2,67,2,1160.05,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2871,2973,794,40722,3058,2,13,1,6684.10,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2872,2973,795,40722,3058,2,96,2,1346.78,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2873,2973,795,40722,3058,2,67,2,282.82,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2874,2973,795,40722,3058,2,13,1,1629.60,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2875,2973,796,40722,3058,2,96,2,3530.99,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2876,2973,796,40722,3058,2,67,2,741.51,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2877,2973,796,40722,3058,2,13,1,4272.50,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2878,2973,797,40722,3058,2,96,2,1917.36,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2879,2973,797,40722,3058,2,67,2,402.64,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2880,2973,797,40722,3058,2,13,1,2320.00,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2881,2973,798,40722,3058,2,96,2,2061.82,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2882,2973,798,40722,3058,2,67,2,432.98,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2883,2973,798,40722,3058,2,13,1,2494.80,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2884,2973,799,40722,3058,2,96,2,4109.09,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2885,2973,799,40722,3058,2,67,2,862.91,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2886,2973,799,40722,3058,2,13,1,4972.00,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2887,2973,800,40722,3058,2,96,2,817.36,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2888,2973,800,40722,3058,2,67,2,171.64,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2889,2973,800,40722,3058,2,13,1,989.00,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2890,2973,801,40722,3058,2,96,2,1653.97,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2891,2973,801,40722,3058,2,67,2,347.33,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2892,2973,801,40722,3058,2,13,1,2001.30,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2893,2973,802,40722,3058,2,96,2,7763.87,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2894,2973,802,40722,3058,2,67,2,1630.41,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2895,2973,802,40722,3058,2,13,1,9394.28,NULL,'2021-09-09 14:39:55','2021-09-09 14:39:55',NULL),(2896,2973,803,40722,3058,2,96,2,849.59,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2897,2973,803,40722,3058,2,67,2,178.41,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2898,2973,803,40722,3058,2,13,1,1028.00,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2899,2973,804,40722,3058,2,96,2,1100.83,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2900,2973,804,40722,3058,2,67,2,231.17,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2901,2973,804,40722,3058,2,13,1,1332.00,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2902,2973,805,40722,3058,2,96,2,1200.83,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2903,2973,805,40722,3058,2,67,2,252.17,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2904,2973,805,40722,3058,2,13,1,1453.00,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2905,2973,806,40722,3058,2,96,2,712.73,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL);
INSERT INTO `balance_libro_details` VALUES (2906,2973,806,40722,3058,2,67,2,149.67,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2907,2973,806,40722,3058,2,13,1,862.40,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2908,2973,807,40722,3058,2,96,2,1149.05,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2909,2973,807,40722,3058,2,67,2,241.30,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2910,2973,807,40722,3058,2,13,1,1390.35,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2911,2973,808,40722,3058,2,96,2,785.12,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2912,2973,808,40722,3058,2,67,2,164.88,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2913,2973,808,40722,3058,2,13,1,950.00,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2914,2973,809,40722,3058,2,96,2,5131.41,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2915,2973,809,40722,3058,2,67,2,1077.59,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2916,2973,809,40722,3058,2,13,1,6209.00,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2917,2973,810,40722,3058,2,96,2,5323.80,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2918,2973,810,40722,3058,2,67,2,1118.00,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2919,2973,810,40722,3058,2,13,1,6441.80,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2920,2973,811,40722,3058,2,96,2,260.33,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2921,2973,811,40722,3058,2,67,2,54.67,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2922,2973,811,40722,3058,2,13,1,315.00,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2923,2973,812,40722,3058,2,96,2,2033.88,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2924,2973,812,40722,3058,2,67,2,427.12,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2925,2973,812,40722,3058,2,13,1,2461.00,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2926,2973,813,40722,3058,2,96,2,2876.03,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2927,2973,813,40722,3058,2,67,2,603.97,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2928,2973,813,40722,3058,2,13,1,3480.00,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2929,2973,814,40722,3058,2,96,2,3117.02,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2930,2973,814,40722,3058,2,67,2,654.58,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2931,2973,814,40722,3058,2,13,1,3771.60,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2932,2973,815,40722,3058,2,96,2,817.36,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2933,2973,815,40722,3058,2,67,2,171.64,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2934,2973,815,40722,3058,2,13,1,989.00,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2935,2973,816,40722,3058,2,96,2,520.66,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2936,2973,816,40722,3058,2,67,2,109.34,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2937,2973,816,40722,3058,2,13,1,630.00,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2938,2973,817,40722,3058,2,96,2,1178.51,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2939,2973,817,40722,3058,2,67,2,247.49,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2940,2973,817,40722,3058,2,13,1,1426.00,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2941,2973,818,40722,3058,2,96,2,2379.42,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2942,2973,818,40722,3058,2,67,2,499.68,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2943,2973,818,40722,3058,2,13,1,2879.10,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2944,2973,819,40722,3058,2,96,2,705.21,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2945,2973,819,40722,3058,2,67,2,148.09,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2946,2973,819,40722,3058,2,13,1,853.30,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL);
INSERT INTO `balance_libro_details` VALUES (2947,2973,820,40722,3058,2,96,2,1935.04,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2948,2973,820,40722,3058,2,67,2,406.36,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2949,2973,820,40722,3058,2,13,1,2341.40,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2950,2973,821,40722,3058,2,96,2,2719.01,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2951,2973,821,40722,3058,2,67,2,570.99,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2952,2973,821,40722,3058,2,13,1,3290.00,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2953,2973,822,40722,3058,2,96,2,2412.98,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2954,2973,822,40722,3058,2,67,2,506.72,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2955,2973,822,40722,3058,2,13,1,2919.70,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2956,2973,823,40722,3058,2,96,2,921.49,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2957,2973,823,40722,3058,2,67,2,193.51,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2958,2973,823,40722,3058,2,13,1,1115.00,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2959,2973,824,40722,3058,2,96,2,384.42,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2960,2973,824,40722,3058,2,67,2,80.73,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2961,2973,824,40722,3058,2,13,1,465.15,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2962,2973,825,40722,3058,2,96,2,1189.71,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2963,2973,825,40722,3058,2,67,2,249.84,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2964,2973,825,40722,3058,2,13,1,1439.55,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2965,2973,826,40722,3058,2,96,2,1122.31,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2966,2973,826,40722,3058,2,67,2,235.69,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2967,2973,826,40722,3058,2,13,1,1358.00,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2968,2973,827,40722,3058,2,96,2,2033.63,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2969,2973,827,40722,3058,2,67,2,427.05,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2970,2973,827,40722,3058,2,13,1,2460.68,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2971,2973,828,40722,3058,2,96,2,1195.04,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2972,2973,828,40722,3058,2,67,2,250.96,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2973,2973,828,40722,3058,2,13,1,1446.00,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2974,2973,829,40722,3058,2,96,2,826.98,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2975,2973,829,40722,3058,2,67,2,173.67,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2976,2973,829,40722,3058,2,13,1,1000.65,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2977,2973,830,40722,3058,2,96,2,1271.90,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2978,2973,830,40722,3058,2,67,2,267.10,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2979,2973,830,40722,3058,2,13,1,1539.00,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2980,2973,831,40722,3058,2,96,2,123.97,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2981,2973,831,40722,3058,2,67,2,26.03,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2982,2973,831,40722,3058,2,13,1,150.00,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2983,2973,832,40722,3058,2,96,2,2806.57,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2984,2973,832,40722,3058,2,67,2,589.38,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2985,2973,832,40722,3058,2,13,1,3395.95,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2986,2973,833,40722,3058,2,96,2,871.24,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2987,2973,833,40722,3058,2,67,2,182.96,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL);
INSERT INTO `balance_libro_details` VALUES (2988,2973,833,40722,3058,2,13,1,1054.20,NULL,'2021-09-09 14:39:56','2021-09-09 14:39:56',NULL),(2989,2973,834,40722,3058,2,96,2,723.83,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(2990,2973,834,40722,3058,2,67,2,152.01,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(2991,2973,834,40722,3058,2,13,1,875.84,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(2992,2973,835,40722,3058,2,96,2,3134.46,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(2993,2973,835,40722,3058,2,67,2,658.24,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(2994,2973,835,40722,3058,2,13,1,3792.70,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(2995,2973,836,40722,3058,2,96,2,4442.98,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(2996,2973,836,40722,3058,2,67,2,933.02,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(2997,2973,836,40722,3058,2,13,1,5376.00,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(2998,2973,837,40722,3058,2,96,2,1614.88,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(2999,2973,837,40722,3058,2,67,2,339.12,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3000,2973,837,40722,3058,2,13,1,1954.00,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3001,2973,838,40722,3058,2,96,2,3710.23,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3002,2973,838,40722,3058,2,67,2,779.15,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3003,2973,838,40722,3058,2,13,1,4489.38,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3004,2973,839,40722,3058,2,96,2,3400.58,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3005,2973,839,40722,3058,2,67,2,714.12,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3006,2973,839,40722,3058,2,13,1,4114.70,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3007,2973,840,40722,3058,2,96,2,1173.55,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3008,2973,840,40722,3058,2,67,2,246.45,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3009,2973,840,40722,3058,2,13,1,1420.00,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3010,2973,841,40722,3058,2,96,2,7049.59,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3011,2973,841,40722,3058,2,67,2,1480.41,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3012,2973,841,40722,3058,2,13,1,8530.00,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3013,2973,842,40722,3058,2,96,2,1195.04,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3014,2973,842,40722,3058,2,67,2,250.96,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3015,2973,842,40722,3058,2,13,1,1446.00,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3016,2973,843,40722,3058,2,96,2,4734.01,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3017,2973,843,40722,3058,2,67,2,994.14,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3018,2973,843,40722,3058,2,13,1,5728.15,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3019,2973,844,40722,3058,2,96,2,4392.56,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3020,2973,844,40722,3058,2,67,2,922.44,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3021,2973,844,40722,3058,2,13,1,5315.00,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3022,2973,845,40722,3058,2,96,2,3355.76,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3023,2973,845,40722,3058,2,67,2,704.70,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3024,2973,845,40722,3058,2,13,1,4060.46,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3025,2973,846,40722,3058,2,96,2,1351.93,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3026,2973,846,40722,3058,2,67,2,283.91,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3027,2973,846,40722,3058,2,13,1,1635.84,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3028,2973,847,40722,3058,2,96,2,4042.15,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL);
INSERT INTO `balance_libro_details` VALUES (3029,2973,847,40722,3058,2,67,2,848.85,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3030,2973,847,40722,3058,2,13,1,4891.00,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3031,2973,848,40722,3058,2,96,2,1094.21,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3032,2973,848,40722,3058,2,67,2,229.79,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3033,2973,848,40722,3058,2,13,1,1324.00,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3034,2973,849,40722,3058,2,96,2,996.69,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3035,2973,849,40722,3058,2,67,2,209.31,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3036,2973,849,40722,3058,2,13,1,1206.00,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3037,2973,850,40722,3058,2,96,2,2398.35,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3038,2973,850,40722,3058,2,67,2,503.65,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3039,2973,850,40722,3058,2,13,1,2902.00,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3040,2973,851,40722,3058,2,96,2,13836.36,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3041,2973,851,40722,3058,2,67,2,2905.64,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3042,2973,851,40722,3058,2,13,1,16742.00,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3043,2973,852,40722,3058,2,96,2,438.74,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3044,2973,852,40722,3058,2,67,2,92.14,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3045,2973,852,40722,3058,2,13,1,530.88,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3046,2973,853,40722,3058,2,96,2,2148.76,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3047,2973,853,40722,3058,2,67,2,451.24,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3048,2973,853,40722,3058,2,13,1,2600.00,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3049,2973,854,40722,3058,2,96,2,978.51,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3050,2973,854,40722,3058,2,67,2,205.49,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3051,2973,854,40722,3058,2,13,1,1184.00,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3052,2973,855,40722,3058,2,96,2,4635.62,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3053,2973,855,40722,3058,2,67,2,973.48,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3054,2973,855,40722,3058,2,13,1,5609.10,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3055,2973,856,40722,3058,2,96,2,1094.88,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3056,2973,856,40722,3058,2,67,2,229.92,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3057,2973,856,40722,3058,2,13,1,1324.80,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3058,2973,857,40722,3058,2,96,2,1158.68,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3059,2973,857,40722,3058,2,67,2,243.32,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3060,2973,857,40722,3058,2,13,1,1402.00,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3061,2973,858,40722,3058,2,96,2,260.33,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3062,2973,858,40722,3058,2,67,2,54.67,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3063,2973,858,40722,3058,2,13,1,315.00,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3064,2973,859,40722,3058,2,96,2,534.71,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3065,2973,859,40722,3058,2,67,2,112.29,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3066,2973,859,40722,3058,2,13,1,647.00,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3067,2973,860,40722,3058,2,96,2,260.33,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3068,2973,860,40722,3058,2,67,2,54.67,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3069,2973,860,40722,3058,2,13,1,315.00,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL);
INSERT INTO `balance_libro_details` VALUES (3070,2973,861,40722,3058,2,96,2,1799.17,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3071,2973,861,40722,3058,2,67,2,377.83,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3072,2973,861,40722,3058,2,13,1,2177.00,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3073,2973,862,40722,3058,2,96,2,7669.83,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3074,2973,862,40722,3058,2,67,2,1610.67,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3075,2973,862,40722,3058,2,13,1,9280.50,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3076,2973,863,40722,3058,2,96,2,4508.93,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3077,2973,863,40722,3058,2,67,2,946.87,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3078,2973,863,40722,3058,2,13,1,5455.80,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3079,2973,864,40722,3058,2,96,2,1829.75,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3080,2973,864,40722,3058,2,67,2,384.25,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3081,2973,864,40722,3058,2,13,1,2214.00,NULL,'2021-09-09 14:39:57','2021-09-09 14:39:57',NULL),(3082,2973,865,40722,3058,2,96,2,330.58,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3083,2973,865,40722,3058,2,67,2,69.42,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3084,2973,865,40722,3058,2,13,1,400.00,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3085,2973,866,40722,3058,2,96,2,1522.07,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3086,2973,866,40722,3058,2,67,2,319.63,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3087,2973,866,40722,3058,2,13,1,1841.70,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3088,2973,867,40722,3058,2,96,2,1442.98,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3089,2973,867,40722,3058,2,67,2,303.02,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3090,2973,867,40722,3058,2,13,1,1746.00,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3091,2973,868,40722,3058,2,96,2,2671.90,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3092,2973,868,40722,3058,2,67,2,561.10,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3093,2973,868,40722,3058,2,13,1,3233.00,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3094,2973,869,40722,3058,2,96,2,2393.31,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3095,2973,869,40722,3058,2,67,2,502.59,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3096,2973,869,40722,3058,2,13,1,2895.90,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3097,2973,870,40722,3058,2,96,2,1812.40,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3098,2973,870,40722,3058,2,67,2,380.60,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3099,2973,870,40722,3058,2,13,1,2193.00,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3100,2973,871,40722,3058,2,96,2,8680.99,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3101,2973,871,40722,3058,2,67,2,1823.01,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3102,2973,871,40722,3058,2,13,1,10504.00,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3103,2973,872,40722,3058,2,96,2,2471.07,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3104,2973,872,40722,3058,2,67,2,518.93,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3105,2973,872,40722,3058,2,13,1,2990.00,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3106,2973,873,40722,3058,2,96,2,2671.07,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3107,2973,873,40722,3058,2,67,2,560.93,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3108,2973,873,40722,3058,2,13,1,3232.00,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3109,2973,874,40722,3058,2,96,2,2806.57,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3110,2973,874,40722,3058,2,67,2,589.38,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL);
INSERT INTO `balance_libro_details` VALUES (3111,2973,874,40722,3058,2,13,1,3395.95,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3112,2973,875,40722,3058,2,96,2,2666.12,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3113,2973,875,40722,3058,2,67,2,559.88,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3114,2973,875,40722,3058,2,13,1,3226.00,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3115,2973,876,40722,3058,2,96,2,1490.75,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3116,2973,876,40722,3058,2,67,2,313.05,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3117,2973,876,40722,3058,2,13,1,1803.80,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3118,2973,877,40722,3058,2,96,2,1442.98,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3119,2973,877,40722,3058,2,67,2,303.02,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3120,2973,877,40722,3058,2,13,1,1746.00,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3121,2973,878,40722,3058,2,96,2,2644.63,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3122,2973,878,40722,3058,2,67,2,555.37,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3123,2973,878,40722,3058,2,13,1,3200.00,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3124,2973,879,40722,3058,2,96,2,3896.69,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3125,2973,879,40722,3058,2,67,2,818.31,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3126,2973,879,40722,3058,2,13,1,4715.00,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3127,2973,880,40722,3058,2,96,2,1652.89,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3128,2973,880,40722,3058,2,67,2,347.11,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3129,2973,880,40722,3058,2,13,1,2000.00,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3130,2973,881,40722,3058,2,96,2,5417.36,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3131,2973,881,40722,3058,2,67,2,1137.64,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3132,2973,881,40722,3058,2,13,1,6555.00,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3133,2973,882,40722,3058,2,96,2,409.12,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3134,2973,882,40722,3058,2,67,2,85.92,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3135,2973,882,40722,3058,2,13,1,495.04,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3136,2973,883,40722,3058,2,96,2,2117.36,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3137,2973,883,40722,3058,2,67,2,444.64,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3138,2973,883,40722,3058,2,13,1,2562.00,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3139,2973,884,40722,3058,2,96,2,376.79,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3140,2973,884,40722,3058,2,67,2,79.13,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3141,2973,884,40722,3058,2,13,1,455.92,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3142,2973,885,40722,3058,2,96,2,1811.57,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3143,2973,885,40722,3058,2,67,2,380.43,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3144,2973,885,40722,3058,2,13,1,2192.00,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3145,2973,886,40722,3058,2,96,2,1666.12,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3146,2973,886,40722,3058,2,67,2,349.88,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3147,2973,886,40722,3058,2,13,1,2016.00,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3148,2973,887,40722,3058,2,96,2,6113.22,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3149,2973,887,40722,3058,2,67,2,1283.78,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3150,2973,887,40722,3058,2,13,1,7397.00,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3151,2973,888,40722,3058,2,96,2,471.90,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL);
INSERT INTO `balance_libro_details` VALUES (3152,2973,888,40722,3058,2,67,2,99.10,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3153,2973,888,40722,3058,2,13,1,571.00,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3154,2973,889,40722,3058,2,96,2,1204.59,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3155,2973,889,40722,3058,2,67,2,252.96,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3156,2973,889,40722,3058,2,13,1,1457.55,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3157,2973,890,40722,3058,2,96,2,2897.52,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3158,2973,890,40722,3058,2,67,2,608.48,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3159,2973,890,40722,3058,2,13,1,3506.00,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3160,2973,891,40722,3058,2,96,2,2418.18,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3161,2973,891,40722,3058,2,67,2,507.82,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3162,2973,891,40722,3058,2,13,1,2926.00,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3163,2973,892,40722,3058,2,96,2,1054.65,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3164,2973,892,40722,3058,2,67,2,221.47,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3165,2973,892,40722,3058,2,13,1,1276.12,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3166,2973,893,40722,3058,2,96,2,995.04,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3167,2973,893,40722,3058,2,67,2,208.96,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3168,2973,893,40722,3058,2,13,1,1204.00,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3169,2973,894,40722,3058,2,96,2,1710.74,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3170,2973,894,40722,3058,2,67,2,359.26,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3171,2973,894,40722,3058,2,13,1,2070.00,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3172,2973,895,40722,3058,2,96,2,3334.71,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3173,2973,895,40722,3058,2,67,2,700.29,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3174,2973,895,40722,3058,2,13,1,4035.00,NULL,'2021-09-09 14:39:58','2021-09-09 14:39:58',NULL),(3175,2973,896,40722,3058,2,96,2,7717.36,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3176,2973,896,40722,3058,2,67,2,1620.64,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3177,2973,896,40722,3058,2,13,1,9338.00,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3178,2973,897,40722,3058,2,96,2,1953.72,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3179,2973,897,40722,3058,2,67,2,410.28,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3180,2973,897,40722,3058,2,13,1,2364.00,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3181,2973,898,40722,3058,2,96,2,2576.86,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3182,2973,898,40722,3058,2,67,2,541.14,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3183,2973,898,40722,3058,2,13,1,3118.00,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3184,2973,899,40722,3058,2,96,2,3826.45,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3185,2973,899,40722,3058,2,67,2,803.55,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3186,2973,899,40722,3058,2,13,1,4630.00,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3187,2973,900,40722,3058,2,96,2,3342.89,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3188,2973,900,40722,3058,2,67,2,702.01,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3189,2973,900,40722,3058,2,13,1,4044.90,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3190,2973,901,40722,3058,2,96,2,957.02,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3191,2973,901,40722,3058,2,67,2,200.98,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3192,2973,901,40722,3058,2,13,1,1158.00,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL);
INSERT INTO `balance_libro_details` VALUES (3193,2973,902,40722,3058,2,96,2,832.23,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3194,2973,902,40722,3058,2,67,2,174.77,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3195,2973,902,40722,3058,2,13,1,1007.00,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3196,2973,903,40722,3058,2,96,2,3395.87,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3197,2973,903,40722,3058,2,67,2,713.13,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3198,2973,903,40722,3058,2,13,1,4109.00,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3199,2973,904,40722,3058,2,96,2,1780.99,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3200,2973,904,40722,3058,2,67,2,374.01,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3201,2973,904,40722,3058,2,13,1,2155.00,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3202,2973,905,40722,3058,2,96,2,2720.66,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3203,2973,905,40722,3058,2,67,2,571.34,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3204,2973,905,40722,3058,2,13,1,3292.00,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3205,2973,906,40722,3058,2,96,2,1211.53,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3206,2973,906,40722,3058,2,67,2,254.42,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3207,2973,906,40722,3058,2,13,1,1465.95,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3208,2973,907,40722,3058,2,96,2,490.08,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3209,2973,907,40722,3058,2,67,2,102.92,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3210,2973,907,40722,3058,2,13,1,593.00,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3211,2973,908,40722,3058,2,96,2,991.12,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3212,2973,908,40722,3058,2,67,2,208.13,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3213,2973,908,40722,3058,2,13,1,1199.25,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3214,2973,909,40722,3058,2,96,2,3595.04,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3215,2973,909,40722,3058,2,67,2,754.96,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3216,2973,909,40722,3058,2,13,1,4350.00,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3217,2973,910,40722,3058,2,96,2,471.90,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3218,2973,910,40722,3058,2,67,2,99.10,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3219,2973,910,40722,3058,2,13,1,571.00,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3220,2973,911,40722,3058,2,96,2,1832.23,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3221,2973,911,40722,3058,2,67,2,384.77,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3222,2973,911,40722,3058,2,13,1,2217.00,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3223,2973,912,40722,3058,2,96,2,878.51,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3224,2973,912,40722,3058,2,67,2,184.49,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3225,2973,912,40722,3058,2,13,1,1063.00,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3226,2973,913,40722,3058,2,96,2,6056.20,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3227,2973,913,40722,3058,2,67,2,1271.80,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3228,2973,913,40722,3058,2,13,1,7328.00,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3229,2973,914,40722,3058,2,96,2,2300.62,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3230,2973,914,40722,3058,2,67,2,483.13,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3231,2973,914,40722,3058,2,13,1,2783.75,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3232,2973,915,40722,3058,2,96,2,1725.62,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3233,2973,915,40722,3058,2,67,2,362.38,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL);
INSERT INTO `balance_libro_details` VALUES (3234,2973,915,40722,3058,2,13,1,2088.00,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3235,2973,916,40722,3058,2,96,2,4260.33,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3236,2973,916,40722,3058,2,67,2,894.67,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3237,2973,916,40722,3058,2,13,1,5155.00,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3238,2973,917,40722,3058,2,96,2,2010.74,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3239,2973,917,40722,3058,2,67,2,422.26,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3240,2973,917,40722,3058,2,13,1,2433.00,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3241,2973,918,40722,3058,2,96,2,3754.55,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3242,2973,918,40722,3058,2,67,2,788.45,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3243,2973,918,40722,3058,2,13,1,4543.00,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3244,2973,919,40722,3058,2,96,2,4665.37,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3245,2973,919,40722,3058,2,67,2,979.73,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3246,2973,919,40722,3058,2,13,1,5645.10,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3247,2973,920,40722,3058,2,96,2,3392.56,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3248,2973,920,40722,3058,2,67,2,712.44,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3249,2973,920,40722,3058,2,13,1,4105.00,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3250,2973,921,40722,3058,2,96,2,767.40,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3251,2973,921,40722,3058,2,67,2,161.16,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3252,2973,921,40722,3058,2,13,1,928.56,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3253,2973,922,40722,3058,2,96,2,474.99,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3254,2973,922,40722,3058,2,67,2,99.75,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3255,2973,922,40722,3058,2,13,1,574.74,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3256,2973,923,40722,3058,2,96,2,1116.53,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3257,2973,923,40722,3058,2,67,2,234.47,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3258,2973,923,40722,3058,2,13,1,1351.00,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3259,2973,924,40722,3058,2,96,2,1684.05,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3260,2973,924,40722,3058,2,67,2,353.65,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3261,2973,924,40722,3058,2,13,1,2037.70,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3262,2973,925,40722,3058,2,96,2,1099.90,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3263,2973,925,40722,3058,2,67,2,230.98,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3264,2973,925,40722,3058,2,13,1,1330.88,NULL,'2021-09-09 14:39:59','2021-09-09 14:39:59',NULL),(3265,2973,926,40722,3058,2,96,2,2231.87,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3266,2973,926,40722,3058,2,67,2,468.69,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3267,2973,926,40722,3058,2,13,1,2700.56,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3268,2973,927,40722,3058,2,96,2,454.48,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3269,2973,927,40722,3058,2,67,2,95.44,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3270,2973,927,40722,3058,2,13,1,549.92,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3271,2973,928,40722,3058,2,96,2,4080.16,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3272,2973,928,40722,3058,2,67,2,856.83,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3273,2973,928,40722,3058,2,13,1,4936.99,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3274,2973,929,40722,3058,2,96,2,2242.96,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL);
INSERT INTO `balance_libro_details` VALUES (3275,2973,929,40722,3058,2,67,2,471.02,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3276,2973,929,40722,3058,2,13,1,2713.98,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3277,2973,930,40722,3058,2,96,2,4066.94,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3278,2973,930,40722,3058,2,67,2,854.06,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3279,2973,930,40722,3058,2,13,1,4921.00,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3280,2973,931,40722,3058,2,96,2,1827.27,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3281,2973,931,40722,3058,2,67,2,383.73,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3282,2973,931,40722,3058,2,13,1,2211.00,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3283,2973,932,40722,3058,2,96,2,1955.36,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3284,2973,932,40722,3058,2,67,2,410.63,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3285,2973,932,40722,3058,2,13,1,2365.99,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3286,2973,933,40722,3058,2,96,2,2379.42,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3287,2973,933,40722,3058,2,67,2,499.68,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3288,2973,933,40722,3058,2,13,1,2879.10,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3289,2973,934,40722,3058,2,96,2,673.39,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3290,2973,934,40722,3058,2,67,2,141.41,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3291,2973,934,40722,3058,2,13,1,814.80,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3292,2973,935,40722,3058,2,96,2,3595.04,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3293,2973,935,40722,3058,2,67,2,754.96,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3294,2973,935,40722,3058,2,13,1,4350.00,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3295,2973,936,40722,3058,2,96,2,2908.76,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3296,2973,936,40722,3058,2,67,2,610.84,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3297,2973,936,40722,3058,2,13,1,3519.60,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3298,2973,937,40722,3058,2,96,2,1709.09,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3299,2973,937,40722,3058,2,67,2,358.91,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3300,2973,937,40722,3058,2,13,1,2068.00,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3301,2973,938,40722,3058,2,96,2,718.51,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3302,2973,938,40722,3058,2,67,2,150.89,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3303,2973,938,40722,3058,2,13,1,869.40,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3304,2973,939,40722,3058,2,96,2,1055.37,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3305,2973,939,40722,3058,2,67,2,221.63,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3306,2973,939,40722,3058,2,13,1,1277.00,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3307,2973,940,40722,3058,2,96,2,2770.04,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3308,2973,940,40722,3058,2,67,2,581.71,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3309,2973,940,40722,3058,2,13,1,3351.75,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3310,2973,941,40722,3058,2,96,2,872.73,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3311,2973,941,40722,3058,2,67,2,183.27,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3312,2973,941,40722,3058,2,13,1,1056.00,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3313,2973,942,40722,3058,2,96,2,761.03,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3314,2973,942,40722,3058,2,67,2,159.82,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3315,2973,942,40722,3058,2,13,1,920.85,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL);
INSERT INTO `balance_libro_details` VALUES (3316,2973,943,40722,3058,2,96,2,863.64,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3317,2973,943,40722,3058,2,67,2,181.36,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3318,2973,943,40722,3058,2,13,1,1045.00,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3319,2973,944,40722,3058,2,96,2,673.39,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3320,2973,944,40722,3058,2,67,2,141.41,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3321,2973,944,40722,3058,2,13,1,814.80,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3322,2973,945,40722,3058,2,96,2,3595.04,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3323,2973,945,40722,3058,2,67,2,754.96,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3324,2973,945,40722,3058,2,13,1,4350.00,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3325,2973,946,40722,3058,2,96,2,10619.83,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3326,2973,946,40722,3058,2,67,2,2230.17,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3327,2973,946,40722,3058,2,13,1,12850.00,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3328,2973,947,40722,3058,2,96,2,1252.07,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3329,2973,947,40722,3058,2,67,2,262.93,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3330,2973,947,40722,3058,2,13,1,1515.00,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3331,2973,948,40722,3058,2,96,2,649.59,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3332,2973,948,40722,3058,2,67,2,136.41,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3333,2973,948,40722,3058,2,13,1,786.00,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3334,2973,949,40722,3058,2,96,2,1522.07,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3335,2973,949,40722,3058,2,67,2,319.63,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3336,2973,949,40722,3058,2,13,1,1841.70,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3337,2973,950,40722,3058,2,96,2,1522.07,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3338,2973,950,40722,3058,2,67,2,319.63,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3339,2973,950,40722,3058,2,13,1,1841.70,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3340,2973,951,40722,3058,2,96,2,2647.93,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3341,2973,951,40722,3058,2,67,2,556.07,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3342,2973,951,40722,3058,2,13,1,3204.00,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3343,2973,952,40722,3058,2,96,2,3003.31,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3344,2973,952,40722,3058,2,67,2,630.69,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3345,2973,952,40722,3058,2,13,1,3634.00,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3346,2973,953,40722,3058,2,96,2,1959.50,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3347,2973,953,40722,3058,2,67,2,411.50,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3348,2973,953,40722,3058,2,13,1,2371.00,NULL,'2021-09-09 14:40:00','2021-09-09 14:40:00',NULL),(3349,2973,954,40722,3058,2,96,2,863.64,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3350,2973,954,40722,3058,2,67,2,181.36,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3351,2973,954,40722,3058,2,13,1,1045.00,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3352,2973,955,40722,3058,2,96,2,2317.81,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3353,2973,955,40722,3058,2,67,2,486.74,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3354,2973,955,40722,3058,2,13,1,2804.55,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3355,2973,956,40722,3058,2,96,2,2567.73,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3356,2973,956,40722,3058,2,67,2,539.22,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL);
INSERT INTO `balance_libro_details` VALUES (3357,2973,956,40722,3058,2,13,1,3106.95,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3358,2973,957,40722,3058,2,96,2,1995.87,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3359,2973,957,40722,3058,2,67,2,419.13,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3360,2973,957,40722,3058,2,13,1,2415.00,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3361,2973,958,40722,3058,2,96,2,6947.93,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3362,2973,958,40722,3058,2,67,2,1459.07,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3363,2973,958,40722,3058,2,13,1,8407.00,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3364,2973,959,40722,3058,2,96,2,864.46,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3365,2973,959,40722,3058,2,67,2,181.54,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3366,2973,959,40722,3058,2,13,1,1046.00,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3367,2973,960,40722,3058,2,96,2,4260.33,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3368,2973,960,40722,3058,2,67,2,894.67,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3369,2973,960,40722,3058,2,13,1,5155.00,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3370,2973,961,40722,3058,2,96,2,1109.09,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3371,2973,961,40722,3058,2,67,2,232.91,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3372,2973,961,40722,3058,2,13,1,1342.00,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3373,2973,962,40722,3058,2,96,2,963.64,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3374,2973,962,40722,3058,2,67,2,202.36,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3375,2973,962,40722,3058,2,13,1,1166.00,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3376,2973,963,40722,3058,2,96,2,424.00,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3377,2973,963,40722,3058,2,67,2,89.04,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3378,2973,963,40722,3058,2,13,1,513.04,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3379,2973,964,40722,3058,2,96,2,1285.12,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3380,2973,964,40722,3058,2,67,2,269.88,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3381,2973,964,40722,3058,2,13,1,1555.00,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3382,2973,965,40722,3058,2,96,2,1852.07,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3383,2973,965,40722,3058,2,67,2,388.93,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3384,2973,965,40722,3058,2,13,1,2241.00,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3385,2973,966,40722,3058,2,96,2,2821.45,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3386,2973,966,40722,3058,2,67,2,592.50,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3387,2973,966,40722,3058,2,13,1,3413.95,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3388,2973,967,40722,3058,2,96,2,3228.10,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3389,2973,967,40722,3058,2,67,2,677.90,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3390,2973,967,40722,3058,2,13,1,3906.00,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3391,2973,968,40722,3058,2,96,2,1018.18,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3392,2973,968,40722,3058,2,67,2,213.82,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3393,2973,968,40722,3058,2,13,1,1232.00,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3394,2973,969,40722,3058,2,96,2,1050.41,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3395,2973,969,40722,3058,2,67,2,220.59,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3396,2973,969,40722,3058,2,13,1,1271.00,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3397,2973,970,40722,3058,2,96,2,1855.44,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL);
INSERT INTO `balance_libro_details` VALUES (3398,2973,970,40722,3058,2,67,2,389.64,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3399,2973,970,40722,3058,2,13,1,2245.08,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3400,2973,971,40722,3058,2,96,2,1035.54,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3401,2973,971,40722,3058,2,67,2,217.46,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3402,2973,971,40722,3058,2,13,1,1253.00,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3403,2973,972,40722,3058,2,96,2,3352.07,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3404,2973,972,40722,3058,2,67,2,703.93,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3405,2973,972,40722,3058,2,13,1,4056.00,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3406,2973,973,40722,3058,2,96,2,1011.57,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3407,2973,973,40722,3058,2,67,2,212.43,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3408,2973,973,40722,3058,2,13,1,1224.00,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3409,2973,974,40722,3058,2,96,2,5188.43,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3410,2973,974,40722,3058,2,67,2,1089.57,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3411,2973,974,40722,3058,2,13,1,6278.00,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3412,2973,975,40722,3058,2,96,2,811.67,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3413,2973,975,40722,3058,2,67,2,170.45,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3414,2973,975,40722,3058,2,13,1,982.12,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3415,2973,976,40722,3058,2,96,2,1804.96,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3416,2973,976,40722,3058,2,67,2,379.04,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3417,2973,976,40722,3058,2,13,1,2184.00,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3418,2973,977,40722,3058,2,96,2,1050.41,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3419,2973,977,40722,3058,2,67,2,220.59,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3420,2973,977,40722,3058,2,13,1,1271.00,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3421,2973,978,40722,3058,2,96,2,655.47,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3422,2973,978,40722,3058,2,67,2,137.65,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3423,2973,978,40722,3058,2,13,1,793.12,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3424,2973,979,40722,3058,2,96,2,909.09,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3425,2973,979,40722,3058,2,67,2,190.91,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3426,2973,979,40722,3058,2,13,1,1100.00,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3427,2973,980,40722,3058,2,96,2,3778.51,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3428,2973,980,40722,3058,2,67,2,793.49,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3429,2973,980,40722,3058,2,13,1,4572.00,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3430,2973,981,40722,3058,2,96,2,1215.70,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3431,2973,981,40722,3058,2,67,2,255.30,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3432,2973,981,40722,3058,2,13,1,1471.00,NULL,'2021-09-09 14:40:01','2021-09-09 14:40:01',NULL),(3433,2973,982,40722,3058,2,96,2,1918.76,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3434,2973,982,40722,3058,2,67,2,402.94,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3435,2973,982,40722,3058,2,13,1,2321.70,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3436,2973,983,40722,3058,2,96,2,910.17,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3437,2973,983,40722,3058,2,67,2,191.13,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3438,2973,983,40722,3058,2,13,1,1101.30,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL);
INSERT INTO `balance_libro_details` VALUES (3439,2973,984,40722,3058,2,96,2,446.28,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3440,2973,984,40722,3058,2,67,2,93.72,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3441,2973,984,40722,3058,2,13,1,540.00,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3442,2973,985,40722,3058,2,96,2,1537.11,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3443,2973,985,40722,3058,2,67,2,322.79,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3444,2973,985,40722,3058,2,13,1,1859.90,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3445,2973,986,40722,3058,2,96,2,1011.57,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3446,2973,986,40722,3058,2,67,2,212.43,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3447,2973,986,40722,3058,2,13,1,1224.00,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3448,2973,987,40722,3058,2,96,2,2738.02,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3449,2973,987,40722,3058,2,67,2,574.98,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3450,2973,987,40722,3058,2,13,1,3313.00,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3451,2973,988,40722,3058,2,96,2,555.37,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3452,2973,988,40722,3058,2,67,2,116.63,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3453,2973,988,40722,3058,2,13,1,672.00,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3454,2973,989,40722,3058,2,96,2,2133.88,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3455,2973,989,40722,3058,2,67,2,448.12,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3456,2973,989,40722,3058,2,13,1,2582.00,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3457,2973,990,40722,3058,2,96,2,4740.50,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3458,2973,990,40722,3058,2,67,2,995.50,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3459,2973,990,40722,3058,2,13,1,5736.00,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3460,2973,991,40722,3058,2,96,2,353.22,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3461,2973,991,40722,3058,2,67,2,74.18,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3462,2973,991,40722,3058,2,13,1,427.40,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3463,2973,992,40722,3058,2,96,2,1035.54,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3464,2973,992,40722,3058,2,67,2,217.46,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3465,2973,992,40722,3058,2,13,1,1253.00,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3466,2973,993,40722,3058,2,96,2,1316.56,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3467,2973,993,40722,3058,2,67,2,276.48,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3468,2973,993,40722,3058,2,13,1,1593.04,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3469,2973,994,40722,3058,2,96,2,424.00,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3470,2973,994,40722,3058,2,67,2,89.04,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3471,2973,994,40722,3058,2,13,1,513.04,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3472,2973,995,40722,3058,2,96,2,3225.12,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3473,2973,995,40722,3058,2,67,2,677.28,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3474,2973,995,40722,3058,2,13,1,3902.40,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3475,2973,996,40722,3058,2,96,2,1459.50,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3476,2973,996,40722,3058,2,67,2,306.50,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3477,2973,996,40722,3058,2,13,1,1766.00,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3478,2973,997,40722,3058,2,96,2,490.08,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3479,2973,997,40722,3058,2,67,2,102.92,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3480,2973,997,40722,3058,2,13,1,593.00,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL);
INSERT INTO `balance_libro_details` VALUES (3481,2973,998,40722,3058,2,96,2,357.42,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3482,2973,998,40722,3058,2,67,2,75.06,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3483,2973,998,40722,3058,2,13,1,432.48,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3484,2973,999,40722,3058,2,96,2,7662.40,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3485,2973,999,40722,3058,2,67,2,1609.10,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3486,2973,999,40722,3058,2,13,1,9271.50,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3487,2973,1000,40722,3058,2,96,2,1534.80,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3488,2973,1000,40722,3058,2,67,2,322.31,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3489,2973,1000,40722,3058,2,13,1,1857.11,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3490,2973,1001,40722,3058,2,96,2,8680.99,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3491,2973,1001,40722,3058,2,67,2,1823.01,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3492,2973,1001,40722,3058,2,13,1,10504.00,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3493,2973,1002,40722,3058,2,96,2,809.92,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3494,2973,1002,40722,3058,2,67,2,170.08,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3495,2973,1002,40722,3058,2,13,1,980.00,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3496,2973,1003,40722,3058,2,96,2,1824.13,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3497,2973,1003,40722,3058,2,67,2,383.07,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3498,2973,1003,40722,3058,2,13,1,2207.20,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3499,2973,1004,40722,3058,2,96,2,1356.20,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3500,2973,1004,40722,3058,2,67,2,284.80,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3501,2973,1004,40722,3058,2,13,1,1641.00,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3502,2973,1005,40722,3058,2,96,2,2207.60,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3503,2973,1005,40722,3058,2,67,2,463.60,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3504,2973,1005,40722,3058,2,13,1,2671.20,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3505,2973,1006,40722,3058,2,96,2,1259.09,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3506,2973,1006,40722,3058,2,67,2,264.41,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3507,2973,1006,40722,3058,2,13,1,1523.50,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3508,2973,1007,40722,3058,2,96,2,832.23,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3509,2973,1007,40722,3058,2,67,2,174.77,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3510,2973,1007,40722,3058,2,13,1,1007.00,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3511,2973,1008,40722,3058,2,96,2,2329.75,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3512,2973,1008,40722,3058,2,67,2,489.25,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3513,2973,1008,40722,3058,2,13,1,2819.00,NULL,'2021-09-09 14:40:02','2021-09-09 14:40:02',NULL),(3514,2973,1009,40722,3058,2,96,2,4116.53,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3515,2973,1009,40722,3058,2,67,2,864.47,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3516,2973,1009,40722,3058,2,13,1,4981.00,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3517,2973,1010,40722,3058,2,96,2,2360.33,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3518,2973,1010,40722,3058,2,67,2,495.67,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3519,2973,1010,40722,3058,2,13,1,2856.00,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3520,2973,1011,40722,3058,2,96,2,1399.63,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3521,2973,1011,40722,3058,2,67,2,293.92,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL);
INSERT INTO `balance_libro_details` VALUES (3522,2973,1011,40722,3058,2,13,1,1693.55,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3523,2973,1012,40722,3058,2,96,2,2280.31,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3524,2973,1012,40722,3058,2,67,2,478.87,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3525,2973,1012,40722,3058,2,13,1,2759.18,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3526,2973,1013,40722,3058,2,96,2,1738.84,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3527,2973,1013,40722,3058,2,67,2,365.16,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3528,2973,1013,40722,3058,2,13,1,2104.00,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3529,2973,1014,40722,3058,2,96,2,1534.81,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3530,2973,1014,40722,3058,2,67,2,322.31,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3531,2973,1014,40722,3058,2,13,1,1857.12,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3532,2973,1015,40722,3058,2,96,2,912.07,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3533,2973,1015,40722,3058,2,67,2,191.53,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3534,2973,1015,40722,3058,2,13,1,1103.60,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3535,2973,1016,40722,3058,2,96,2,3641.40,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3536,2973,1016,40722,3058,2,67,2,764.70,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3537,2973,1016,40722,3058,2,13,1,4406.10,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3538,2973,1017,40722,3058,2,96,2,1517.36,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3539,2973,1017,40722,3058,2,67,2,318.64,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3540,2973,1017,40722,3058,2,13,1,1836.00,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3541,2973,1018,40722,3058,2,96,2,912.40,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3542,2973,1018,40722,3058,2,67,2,191.60,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3543,2973,1018,40722,3058,2,13,1,1104.00,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3544,2973,1019,40722,3058,2,96,2,3461.98,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3545,2973,1019,40722,3058,2,67,2,727.02,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3546,2973,1019,40722,3058,2,13,1,4189.00,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3547,2973,1020,40722,3058,2,96,2,1974.38,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3548,2973,1020,40722,3058,2,67,2,414.62,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3549,2973,1020,40722,3058,2,13,1,2389.00,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3550,2973,1021,40722,3058,2,96,2,3778.51,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3551,2973,1021,40722,3058,2,67,2,793.49,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3552,2973,1021,40722,3058,2,13,1,4572.00,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3553,2973,1022,40722,3058,2,96,2,2409.92,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3554,2973,1022,40722,3058,2,67,2,506.08,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3555,2973,1022,40722,3058,2,13,1,2916.00,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3556,2973,1023,40722,3058,2,96,2,2205.78,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3557,2973,1023,40722,3058,2,67,2,463.22,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3558,2973,1023,40722,3058,2,13,1,2669.00,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3559,2973,1024,40722,3058,2,96,2,1043.80,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3560,2973,1024,40722,3058,2,67,2,219.20,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3561,2973,1024,40722,3058,2,13,1,1263.00,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3562,2973,1025,40722,3058,2,96,2,3453.72,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL);
INSERT INTO `balance_libro_details` VALUES (3563,2973,1025,40722,3058,2,67,2,725.28,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3564,2973,1025,40722,3058,2,13,1,4179.00,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3565,2973,1026,40722,3058,2,96,2,11512.56,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3566,2973,1026,40722,3058,2,67,2,2417.64,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3567,2973,1026,40722,3058,2,13,1,13930.20,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3568,2973,1027,40722,3058,2,96,2,3980.16,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3569,2973,1027,40722,3058,2,67,2,835.83,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3570,2973,1027,40722,3058,2,13,1,4815.99,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3571,2973,1028,40722,3058,2,96,2,2851.17,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3572,2973,1028,40722,3058,2,67,2,598.75,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3573,2973,1028,40722,3058,2,13,1,3449.92,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3574,2973,1029,40722,3058,2,96,2,1781.82,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3575,2973,1029,40722,3058,2,67,2,374.18,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3576,2973,1029,40722,3058,2,13,1,2156.00,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3577,2973,1030,40722,3058,2,96,2,3455.62,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3578,2973,1030,40722,3058,2,67,2,725.68,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3579,2973,1030,40722,3058,2,13,1,4181.30,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3580,2973,1031,40722,3058,2,96,2,5980.99,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3581,2973,1031,40722,3058,2,67,2,1256.01,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3582,2973,1031,40722,3058,2,13,1,7237.00,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3583,2973,1032,40722,3058,2,96,2,1118.38,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3584,2973,1032,40722,3058,2,67,2,234.86,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3585,2973,1032,40722,3058,2,13,1,1353.24,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3586,2973,1033,40722,3058,2,96,2,6537.90,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3587,2973,1033,40722,3058,2,67,2,1372.95,NULL,'2021-09-09 14:40:03','2021-09-09 14:40:03',NULL),(3588,2973,1033,40722,3058,2,13,1,7910.85,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3589,2973,1034,40722,3058,2,96,2,1376.53,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3590,2973,1034,40722,3058,2,67,2,289.07,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3591,2973,1034,40722,3058,2,13,1,1665.60,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3592,2973,1035,40722,3058,2,96,2,4203.31,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3593,2973,1035,40722,3058,2,67,2,882.69,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3594,2973,1035,40722,3058,2,13,1,5086.00,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3595,2973,1036,40722,3058,2,96,2,1363.64,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3596,2973,1036,40722,3058,2,67,2,286.36,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3597,2973,1036,40722,3058,2,13,1,1650.00,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3598,2973,1037,40722,3058,2,96,2,1173.55,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3599,2973,1037,40722,3058,2,67,2,246.45,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3600,2973,1037,40722,3058,2,13,1,1420.00,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3601,2973,1038,40722,3058,2,96,2,1142.35,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3602,2973,1038,40722,3058,2,67,2,239.89,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3603,2973,1038,40722,3058,2,13,1,1382.24,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL);
INSERT INTO `balance_libro_details` VALUES (3604,2973,1039,40722,3058,2,96,2,1804.96,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3605,2973,1039,40722,3058,2,67,2,379.04,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3606,2973,1039,40722,3058,2,13,1,2184.00,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3607,2973,1040,40722,3058,2,96,2,10976.03,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3608,2973,1040,40722,3058,2,67,2,2304.97,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3609,2973,1040,40722,3058,2,13,1,13281.00,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3610,2973,1041,40722,3058,2,96,2,2538.22,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3611,2973,1041,40722,3058,2,67,2,533.03,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3612,2973,1041,40722,3058,2,13,1,3071.25,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3613,2973,1042,40722,3058,2,96,2,2134.05,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3614,2973,1042,40722,3058,2,67,2,448.15,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3615,2973,1042,40722,3058,2,13,1,2582.20,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3616,2973,1043,40722,3058,2,96,2,3620.23,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3617,2973,1043,40722,3058,2,67,2,760.25,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3618,2973,1043,40722,3058,2,13,1,4380.48,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3619,2973,1044,40722,3058,2,96,2,1632.15,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3620,2973,1044,40722,3058,2,67,2,342.75,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3621,2973,1044,40722,3058,2,13,1,1974.90,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3622,2973,1045,40722,3058,2,96,2,547.11,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3623,2973,1045,40722,3058,2,67,2,114.89,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3624,2973,1045,40722,3058,2,13,1,662.00,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3625,2973,1046,40722,3058,2,96,2,1456.84,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3626,2973,1046,40722,3058,2,67,2,305.94,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3627,2973,1046,40722,3058,2,13,1,1762.78,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3628,2973,1047,40722,3058,2,96,2,976.86,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3629,2973,1047,40722,3058,2,67,2,205.14,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3630,2973,1047,40722,3058,2,13,1,1182.00,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3631,2973,1048,40722,3058,2,96,2,410.58,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3632,2973,1048,40722,3058,2,67,2,86.22,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3633,2973,1048,40722,3058,2,13,1,496.80,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3634,2973,1049,40722,3058,2,96,2,1682.64,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3635,2973,1049,40722,3058,2,67,2,353.36,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3636,2973,1049,40722,3058,2,13,1,2036.00,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3637,2973,1050,40722,3058,2,96,2,1794.05,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3638,2973,1050,40722,3058,2,67,2,376.75,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3639,2973,1050,40722,3058,2,13,1,2170.80,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3640,2973,1051,40722,3058,2,96,2,938.71,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3641,2973,1051,40722,3058,2,67,2,197.13,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3642,2973,1051,40722,3058,2,13,1,1135.84,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3643,2973,1052,40722,3058,2,96,2,2244.63,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3644,2973,1052,40722,3058,2,67,2,471.37,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL);
INSERT INTO `balance_libro_details` VALUES (3645,2973,1052,40722,3058,2,13,1,2716.00,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3646,2973,1053,40722,3058,2,96,2,2409.17,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3647,2973,1053,40722,3058,2,67,2,505.93,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3648,2973,1053,40722,3058,2,13,1,2915.10,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3649,2973,1054,40722,3058,2,96,2,3392.56,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3650,2973,1054,40722,3058,2,67,2,712.44,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3651,2973,1054,40722,3058,2,13,1,4105.00,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3652,2973,1055,40722,3058,2,96,2,6603.31,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3653,2973,1055,40722,3058,2,67,2,1386.69,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3654,2973,1055,40722,3058,2,13,1,7990.00,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3655,2973,1056,40722,3058,2,96,2,775.91,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3656,2973,1056,40722,3058,2,67,2,162.94,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3657,2973,1056,40722,3058,2,13,1,938.85,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3658,2973,1057,40722,3058,2,96,2,1793.10,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3659,2973,1057,40722,3058,2,67,2,376.55,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3660,2973,1057,40722,3058,2,13,1,2169.65,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3661,2973,1058,40722,3058,2,96,2,3066.12,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3662,2973,1058,40722,3058,2,67,2,643.88,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3663,2973,1058,40722,3058,2,13,1,3710.00,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3664,2973,1059,40722,3058,2,96,2,1837.06,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3665,2973,1059,40722,3058,2,67,2,385.78,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3666,2973,1059,40722,3058,2,13,1,2222.84,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3667,2973,1060,40722,3058,2,96,2,3146.78,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3668,2973,1060,40722,3058,2,67,2,660.82,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3669,2973,1060,40722,3058,2,13,1,3807.60,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3670,2973,1061,40722,3058,2,96,2,4964.96,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3671,2973,1061,40722,3058,2,67,2,1042.64,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3672,2973,1061,40722,3058,2,13,1,6007.60,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3673,2973,1062,40722,3058,2,96,2,1145.16,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3674,2973,1062,40722,3058,2,67,2,240.48,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3675,2973,1062,40722,3058,2,13,1,1385.64,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3676,2973,1063,40722,3058,2,96,2,5723.97,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3677,2973,1063,40722,3058,2,67,2,1202.03,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3678,2973,1063,40722,3058,2,13,1,6926.00,NULL,'2021-09-09 14:40:04','2021-09-09 14:40:04',NULL),(3679,2973,1064,40722,3058,2,96,2,948.79,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3680,2973,1064,40722,3058,2,67,2,199.25,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3681,2973,1064,40722,3058,2,13,1,1148.04,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3682,2973,1065,40722,3058,2,96,2,5159.57,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3683,2973,1065,40722,3058,2,67,2,1083.51,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3684,2973,1065,40722,3058,2,13,1,6243.08,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3685,2973,1066,40722,3058,2,96,2,1455.37,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL);
INSERT INTO `balance_libro_details` VALUES (3686,2973,1066,40722,3058,2,67,2,305.63,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3687,2973,1066,40722,3058,2,13,1,1761.00,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3688,2973,1067,40722,3058,2,96,2,3303.31,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3689,2973,1067,40722,3058,2,67,2,693.69,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3690,2973,1067,40722,3058,2,13,1,3997.00,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3691,2973,1068,40722,3058,2,96,2,1364.46,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3692,2973,1068,40722,3058,2,67,2,286.54,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3693,2973,1068,40722,3058,2,13,1,1651.00,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3694,2973,1069,40722,3058,2,96,2,2738.02,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3695,2973,1069,40722,3058,2,67,2,574.98,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3696,2973,1069,40722,3058,2,13,1,3313.00,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3697,2973,1070,40722,3058,2,96,2,1452.07,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3698,2973,1070,40722,3058,2,67,2,304.93,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3699,2973,1070,40722,3058,2,13,1,1757.00,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3700,2973,1071,40722,3058,2,96,2,3977.69,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3701,2973,1071,40722,3058,2,67,2,835.31,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3702,2973,1071,40722,3058,2,13,1,4813.00,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3703,2973,1072,40722,3058,2,96,2,1803.31,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3704,2973,1072,40722,3058,2,67,2,378.69,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3705,2973,1072,40722,3058,2,13,1,2182.00,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3706,2973,1073,40722,3058,2,96,2,946.28,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3707,2973,1073,40722,3058,2,67,2,198.72,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3708,2973,1073,40722,3058,2,13,1,1145.00,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3709,2973,1074,40722,3058,2,96,2,4260.33,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3710,2973,1074,40722,3058,2,67,2,894.67,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3711,2973,1074,40722,3058,2,13,1,5155.00,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3712,2973,1075,40722,3058,2,96,2,2104.66,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3713,2973,1075,40722,3058,2,67,2,441.98,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3714,2973,1075,40722,3058,2,13,1,2546.64,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3715,2973,1076,40722,3058,2,96,2,281.52,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3716,2973,1076,40722,3058,2,67,2,59.12,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3717,2973,1076,40722,3058,2,13,1,340.64,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3718,2973,1077,40722,3058,2,96,2,3826.45,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3719,2973,1077,40722,3058,2,67,2,803.55,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3720,2973,1077,40722,3058,2,13,1,4630.00,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3721,2973,1078,40722,3058,2,96,2,4055.37,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3722,2973,1078,40722,3058,2,67,2,851.63,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3723,2973,1078,40722,3058,2,13,1,4907.00,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3724,2973,1079,40722,3058,2,96,2,1190.91,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3725,2973,1079,40722,3058,2,67,2,250.09,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3726,2973,1079,40722,3058,2,13,1,1441.00,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL);
INSERT INTO `balance_libro_details` VALUES (3727,2973,1080,40722,3058,2,96,2,424.00,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3728,2973,1080,40722,3058,2,67,2,89.04,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3729,2973,1080,40722,3058,2,13,1,513.04,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3730,2973,1081,40722,3058,2,96,2,4116.53,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3731,2973,1081,40722,3058,2,67,2,864.47,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3732,2973,1081,40722,3058,2,13,1,4981.00,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3733,2973,1082,40722,3058,2,96,2,347.17,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3734,2973,1082,40722,3058,2,67,2,72.91,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3735,2973,1082,40722,3058,2,13,1,420.08,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3736,2973,1083,40722,3058,2,96,2,1282.64,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3737,2973,1083,40722,3058,2,67,2,269.36,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3738,2973,1083,40722,3058,2,13,1,1552.00,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3739,2973,1084,40722,3058,2,96,2,1551.82,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3740,2973,1084,40722,3058,2,67,2,325.88,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3741,2973,1084,40722,3058,2,13,1,1877.70,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3742,2973,1085,40722,3058,2,96,2,347.17,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3743,2973,1085,40722,3058,2,67,2,72.91,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3744,2973,1085,40722,3058,2,13,1,420.08,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3745,2973,1086,40722,3058,2,96,2,832.23,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3746,2973,1086,40722,3058,2,67,2,174.77,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3747,2973,1086,40722,3058,2,13,1,1007.00,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3748,2973,1087,40722,3058,2,96,2,357.42,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3749,2973,1087,40722,3058,2,67,2,75.06,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3750,2973,1087,40722,3058,2,13,1,432.48,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3751,2973,1088,40722,3058,2,96,2,3350.41,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3752,2973,1088,40722,3058,2,67,2,703.59,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3753,2973,1088,40722,3058,2,13,1,4054.00,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3754,2973,1089,40722,3058,2,96,2,886.12,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3755,2973,1089,40722,3058,2,67,2,186.08,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3756,2973,1089,40722,3058,2,13,1,1072.20,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3757,2973,1090,40722,3058,2,96,2,1099.64,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3758,2973,1090,40722,3058,2,67,2,230.92,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3759,2973,1090,40722,3058,2,13,1,1330.56,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3760,2973,1091,40722,3058,2,96,2,3168.95,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3761,2973,1091,40722,3058,2,67,2,665.47,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3762,2973,1091,40722,3058,2,13,1,3834.42,NULL,'2021-09-09 14:40:05','2021-09-09 14:40:05',NULL),(3763,2973,1092,40722,3058,2,96,2,6348.76,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3764,2973,1092,40722,3058,2,67,2,1333.24,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3765,2973,1092,40722,3058,2,13,1,7682.00,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3766,2973,1093,40722,3058,2,96,2,1663.64,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3767,2973,1093,40722,3058,2,67,2,349.36,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL);
INSERT INTO `balance_libro_details` VALUES (3768,2973,1093,40722,3058,2,13,1,2013.00,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3769,2973,1094,40722,3058,2,96,2,2279.60,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3770,2973,1094,40722,3058,2,67,2,478.72,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3771,2973,1094,40722,3058,2,13,1,2758.32,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3772,2973,1095,40722,3058,2,96,2,2078.18,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3773,2973,1095,40722,3058,2,67,2,436.42,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3774,2973,1095,40722,3058,2,13,1,2514.60,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3775,2973,1096,40722,3058,2,96,2,3827.73,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3776,2973,1096,40722,3058,2,67,2,803.82,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3777,2973,1096,40722,3058,2,13,1,4631.55,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3778,2973,1097,40722,3058,2,96,2,841.86,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3779,2973,1097,40722,3058,2,67,2,176.79,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3780,2973,1097,40722,3058,2,13,1,1018.65,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3781,2973,1098,40722,3058,2,96,2,4547.10,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3782,2973,1098,40722,3058,2,67,2,954.89,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3783,2973,1098,40722,3058,2,13,1,5501.99,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3784,2973,1099,40722,3058,2,96,2,3482.64,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3785,2973,1099,40722,3058,2,67,2,731.35,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3786,2973,1099,40722,3058,2,13,1,4213.99,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3787,2973,1100,40722,3058,2,96,2,2239.14,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3788,2973,1100,40722,3058,2,67,2,470.22,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3789,2973,1100,40722,3058,2,13,1,2709.36,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3790,2973,1101,40722,3058,2,96,2,1989.47,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3791,2973,1101,40722,3058,2,67,2,417.79,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3792,2973,1101,40722,3058,2,13,1,2407.26,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3793,2973,1102,40722,3058,2,96,2,2446.28,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3794,2973,1102,40722,3058,2,67,2,513.72,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3795,2973,1102,40722,3058,2,13,1,2960.00,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3796,2973,1103,40722,3058,2,96,2,154.54,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3797,2973,1103,40722,3058,2,67,2,32.45,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3798,2973,1103,40722,3058,2,13,1,186.99,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3799,2973,1104,40722,3058,2,96,1,9700.13,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3800,2973,1104,40722,3058,2,68,1,2037.03,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3801,2973,1104,40722,3058,2,13,2,11737.16,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3802,2973,1105,40722,3058,2,96,1,9700.13,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3803,2973,1105,40722,3058,2,68,1,2037.03,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3804,2973,1105,40722,3058,2,13,2,11737.16,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3805,2973,1106,40722,3058,2,96,2,134250.41,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3806,2973,1106,40722,3058,2,67,2,28192.59,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3807,2973,1106,40722,3058,2,13,1,162443.00,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3808,2973,1107,40722,3058,2,96,1,3453.72,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL);
INSERT INTO `balance_libro_details` VALUES (3809,2973,1107,40722,3058,2,68,1,725.28,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3810,2973,1107,40722,3058,2,13,2,4179.00,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3811,2973,1108,40722,3058,2,96,1,1827.27,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3812,2973,1108,40722,3058,2,68,1,383.73,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3813,2973,1108,40722,3058,2,13,2,2211.00,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3814,2973,1109,40722,3058,2,96,1,8133.88,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3815,2973,1109,40722,3058,2,68,1,1708.11,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3816,2973,1109,40722,3058,2,13,2,9841.99,NULL,'2021-09-09 14:40:06','2021-09-09 14:40:06',NULL),(3817,2973,1110,40722,3058,3,217,1,1239.00,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3818,2973,1110,40722,3058,3,68,1,260.19,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3819,2973,1110,40722,3058,3,57,2,1499.19,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3820,2973,1111,40722,3058,3,217,1,81.48,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3821,2973,1111,40722,3058,3,68,1,17.12,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3822,2973,1111,40722,3058,3,57,2,98.60,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3823,2973,1112,40722,3058,3,217,1,100000.00,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3824,2973,1112,40722,3058,3,68,1,21000.00,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3825,2973,1112,40722,3058,3,57,2,121000.00,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3826,2973,1113,40722,3058,3,250,1,7000.00,NULL,'2021-09-09 14:51:59','2021-09-09 14:53:04','2021-09-09 14:53:04'),(3827,2973,1113,40722,3058,3,57,2,7000.00,NULL,'2021-09-09 14:51:59','2021-09-09 14:53:04','2021-09-09 14:53:04'),(3828,2973,1114,40722,3058,3,217,1,554.78,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3829,2973,1114,40722,3058,3,68,1,116.50,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3830,2973,1114,40722,3058,3,217,1,220.31,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3831,2973,1114,40722,3058,3,57,2,891.59,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3832,2973,1115,40722,3058,3,217,1,33057.03,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3833,2973,1115,40722,3058,3,68,1,6941.97,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3834,2973,1115,40722,3058,3,57,2,39999.00,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3835,2973,1116,40722,3058,3,217,1,227.84,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3836,2973,1116,40722,3058,3,68,1,47.86,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3837,2973,1116,40722,3058,3,57,2,275.70,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3838,2973,1117,40722,3058,3,217,1,79.88,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3839,2973,1117,40722,3058,3,68,1,16.77,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3840,2973,1117,40722,3058,3,217,1,7.98,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3841,2973,1117,40722,3058,3,57,2,104.63,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3842,2973,1118,40722,3058,3,217,1,227.27,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3843,2973,1118,40722,3058,3,68,1,47.73,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3844,2973,1118,40722,3058,3,57,2,275.00,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19');
INSERT INTO `balance_libro_details` VALUES (3845,2973,1119,40722,3058,3,217,1,58676.86,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3846,2973,1119,40722,3058,3,68,1,12322.14,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3847,2973,1119,40722,3058,3,57,2,70999.00,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3848,2973,1120,40722,3058,3,217,1,495.78,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3849,2973,1120,40722,3058,3,68,1,104.11,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3850,2973,1120,40722,3058,3,217,1,196.88,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3851,2973,1120,40722,3058,3,57,2,796.77,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3852,2973,1121,40722,3058,3,217,1,506.14,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3853,2973,1121,40722,3058,3,68,1,106.29,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3854,2973,1121,40722,3058,3,217,1,200.99,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3855,2973,1121,40722,3058,3,57,2,813.42,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3856,2973,1122,40722,3058,3,217,1,128058.12,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3857,2973,1122,40722,3058,3,68,1,26892.20,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3858,2973,1122,40722,3058,3,217,1,9284.21,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3859,2973,1122,40722,3058,3,57,2,164234.53,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3860,2973,1123,40722,3058,3,217,1,125815.08,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3861,2973,1123,40722,3058,3,68,1,26421.17,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3862,2973,1123,40722,3058,3,217,1,53357.56,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3863,2973,1123,40722,3058,3,57,2,205593.81,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3864,2973,1124,40722,3058,3,217,1,69.75,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3865,2973,1124,40722,3058,3,68,1,14.65,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3866,2973,1124,40722,3058,3,217,1,5.92,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3867,2973,1124,40722,3058,3,57,2,90.32,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3868,2973,1125,40722,3058,3,217,2,266.52,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3869,2973,1125,40722,3058,3,67,2,55.97,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3870,2973,1125,40722,3058,3,217,2,6.66,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3871,2973,1125,40722,3058,3,57,1,329.15,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3872,2973,1126,40722,3058,3,217,2,2595.52,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3873,2973,1126,40722,3058,3,67,2,545.06,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3874,2973,1126,40722,3058,3,217,2,377.57,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3875,2973,1126,40722,3058,3,57,1,3518.15,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3876,2973,1127,40722,3058,3,250,1,10000.00,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3877,2973,1127,40722,3058,3,57,2,10000.00,NULL,'2021-09-09 14:51:59','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3878,2973,1128,40722,3058,3,217,1,457477.00,NULL,'2021-09-09 14:51:59','2021-09-09 14:53:44','2021-09-09 14:53:44'),(3879,2973,1128,40722,3058,3,68,1,96070.17,NULL,'2021-09-09 14:51:59','2021-09-09 14:53:44','2021-09-09 14:53:44');
INSERT INTO `balance_libro_details` VALUES (3880,2973,1128,40722,3058,3,57,2,553547.17,NULL,'2021-09-09 14:51:59','2021-09-09 14:53:44','2021-09-09 14:53:44'),(3881,2973,1129,40722,3058,3,250,1,7000.00,NULL,'2021-09-09 14:53:04','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3882,2973,1129,40722,3058,3,57,2,7000.00,NULL,'2021-09-09 14:53:04','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3883,2973,1130,40722,3058,3,217,1,457477.00,NULL,'2021-09-09 14:53:44','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3884,2973,1130,40722,3058,3,68,1,96070.17,NULL,'2021-09-09 14:53:44','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3885,2973,1130,40722,3058,3,57,2,553547.17,NULL,'2021-09-09 14:53:44','2021-09-09 15:34:19','2021-09-09 15:34:19'),(3886,2973,1131,40722,3058,3,217,1,587.80,NULL,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(3887,2973,1131,40722,3058,3,68,1,123.44,NULL,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(3888,2973,1131,40722,3058,3,217,1,177.46,NULL,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(3889,2973,1131,40722,3058,3,57,2,888.70,NULL,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(3890,2973,1132,40722,3058,3,217,1,1239.00,NULL,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(3891,2973,1132,40722,3058,3,68,1,260.19,NULL,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(3892,2973,1132,40722,3058,3,57,2,1499.19,NULL,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(3893,2973,1133,40722,3058,3,217,1,81.48,NULL,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(3894,2973,1133,40722,3058,3,68,1,17.12,NULL,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(3895,2973,1133,40722,3058,3,57,2,98.60,NULL,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(3896,2973,1134,40722,3058,3,217,1,100000.00,NULL,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(3897,2973,1134,40722,3058,3,68,1,21000.00,NULL,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(3898,2973,1134,40722,3058,3,57,2,121000.00,NULL,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(3899,2973,1135,40722,3058,3,250,1,7000.00,NULL,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(3900,2973,1135,40722,3058,3,57,2,7000.00,NULL,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(3901,2973,1136,40722,3058,3,217,1,2222.62,NULL,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(3902,2973,1136,40722,3058,3,68,1,466.75,NULL,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(3903,2973,1136,40722,3058,3,217,1,670.93,NULL,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(3904,2973,1136,40722,3058,3,57,2,3360.30,NULL,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(3905,2973,1137,40722,3058,3,217,1,554.78,NULL,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(3906,2973,1137,40722,3058,3,68,1,116.50,NULL,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(3907,2973,1137,40722,3058,3,217,1,220.31,NULL,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(3908,2973,1137,40722,3058,3,57,2,891.59,NULL,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(3909,2973,1138,40722,3058,3,217,1,33057.03,NULL,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(3910,2973,1138,40722,3058,3,68,1,6941.97,NULL,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(3911,2973,1138,40722,3058,3,57,2,39999.00,NULL,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(3912,2973,1139,40722,3058,3,217,1,489.53,NULL,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(3913,2973,1139,40722,3058,3,68,1,102.80,NULL,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(3914,2973,1139,40722,3058,3,217,1,147.77,NULL,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(3915,2973,1139,40722,3058,3,57,2,740.10,NULL,'2021-09-09 15:34:46','2021-09-09 15:34:46',NULL),(3916,2973,1140,40722,3058,3,217,1,227.84,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3917,2973,1140,40722,3058,3,68,1,47.86,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3918,2973,1140,40722,3058,3,57,2,275.70,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3919,2973,1141,40722,3058,3,217,1,79.88,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL);
INSERT INTO `balance_libro_details` VALUES (3920,2973,1141,40722,3058,3,68,1,16.77,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3921,2973,1141,40722,3058,3,217,1,7.98,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3922,2973,1141,40722,3058,3,57,2,104.63,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3923,2973,1142,40722,3058,3,217,1,227.27,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3924,2973,1142,40722,3058,3,68,1,47.73,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3925,2973,1142,40722,3058,3,57,2,275.00,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3926,2973,1143,40722,3058,3,217,1,549.19,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3927,2973,1143,40722,3058,3,68,1,115.33,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3928,2973,1143,40722,3058,3,217,1,165.78,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3929,2973,1143,40722,3058,3,57,2,830.30,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3930,2973,1144,40722,3058,3,217,1,2619.48,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3931,2973,1144,40722,3058,3,68,1,550.09,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3932,2973,1144,40722,3058,3,217,1,790.73,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3933,2973,1144,40722,3058,3,57,2,3960.30,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3934,2973,1145,40722,3058,3,217,1,58676.86,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3935,2973,1145,40722,3058,3,68,1,12322.14,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3936,2973,1145,40722,3058,3,57,2,70999.00,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3937,2973,1146,40722,3058,3,217,1,495.78,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3938,2973,1146,40722,3058,3,68,1,104.11,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3939,2973,1146,40722,3058,3,217,1,196.88,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3940,2973,1146,40722,3058,3,57,2,796.77,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3941,2973,1147,40722,3058,3,217,1,988.48,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3942,2973,1147,40722,3058,3,68,1,207.58,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3943,2973,1147,40722,3058,3,217,1,304.17,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3944,2973,1147,40722,3058,3,57,2,1500.23,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3945,2973,1148,40722,3058,3,217,1,506.14,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3946,2973,1148,40722,3058,3,68,1,106.29,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3947,2973,1148,40722,3058,3,217,1,200.99,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3948,2973,1148,40722,3058,3,57,2,813.42,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3949,2973,1149,40722,3058,3,217,1,128058.12,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3950,2973,1149,40722,3058,3,68,1,26892.20,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3951,2973,1149,40722,3058,3,217,1,9284.21,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3952,2973,1149,40722,3058,3,57,2,164234.53,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3953,2973,1150,40722,3058,3,217,1,125815.08,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3954,2973,1150,40722,3058,3,68,1,26421.17,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3955,2973,1150,40722,3058,3,217,1,53357.56,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3956,2973,1150,40722,3058,3,57,2,205593.81,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3957,2973,1151,40722,3058,3,217,1,69.75,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3958,2973,1151,40722,3058,3,68,1,14.65,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3959,2973,1151,40722,3058,3,217,1,5.92,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3960,2973,1151,40722,3058,3,57,2,90.32,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL);
INSERT INTO `balance_libro_details` VALUES (3961,2973,1152,40722,3058,3,217,2,266.52,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3962,2973,1152,40722,3058,3,67,2,55.97,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3963,2973,1152,40722,3058,3,217,2,6.66,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3964,2973,1152,40722,3058,3,57,1,329.15,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3965,2973,1153,40722,3058,3,217,2,2595.52,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3966,2973,1153,40722,3058,3,67,2,545.06,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3967,2973,1153,40722,3058,3,217,2,377.57,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3968,2973,1153,40722,3058,3,57,1,3518.15,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3969,2973,1154,40722,3058,3,250,1,10000.00,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3970,2973,1154,40722,3058,3,57,2,10000.00,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3971,2973,1155,40722,3058,3,217,1,457477.00,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3972,2973,1155,40722,3058,3,68,1,96070.17,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3973,2973,1155,40722,3058,3,57,2,553547.17,NULL,'2021-09-09 15:34:47','2021-09-09 15:34:47',NULL),(3974,2973,1156,40926,3765,2,96,2,6267.79,NULL,'2021-10-12 15:29:22','2021-10-12 15:29:22',NULL),(3975,2973,1156,40926,3765,2,67,2,1316.24,NULL,'2021-10-12 15:29:22','2021-10-12 15:29:22',NULL),(3976,2973,1156,40926,3765,2,13,1,7584.03,NULL,'2021-10-12 15:29:22','2021-10-12 15:29:22',NULL),(3977,2973,1157,40926,3765,2,96,2,8693.93,NULL,'2021-10-12 15:29:22','2021-10-12 15:29:22',NULL),(3978,2973,1157,40926,3765,2,67,2,1825.73,NULL,'2021-10-12 15:29:22','2021-10-12 15:29:22',NULL),(3979,2973,1157,40926,3765,2,13,1,10519.66,NULL,'2021-10-12 15:29:22','2021-10-12 15:29:22',NULL),(3980,2973,1158,40926,3765,2,96,2,29116.96,NULL,'2021-10-12 15:29:22','2021-10-12 15:29:22',NULL),(3981,2973,1158,40926,3765,2,67,2,6114.56,NULL,'2021-10-12 15:29:22','2021-10-12 15:29:22',NULL),(3982,2973,1158,40926,3765,2,13,1,35231.52,NULL,'2021-10-12 15:29:22','2021-10-12 15:29:22',NULL),(3983,2973,1159,40926,3765,2,96,2,9317.28,NULL,'2021-10-12 15:29:22','2021-10-12 15:29:22',NULL),(3984,2973,1159,40926,3765,2,67,2,1956.63,NULL,'2021-10-12 15:29:22','2021-10-12 15:29:22',NULL),(3985,2973,1159,40926,3765,2,13,1,11273.91,NULL,'2021-10-12 15:29:22','2021-10-12 15:29:22',NULL),(3986,2973,1160,40926,3765,2,96,2,8126.91,NULL,'2021-10-12 15:29:22','2021-10-12 15:29:22',NULL),(3987,2973,1160,40926,3765,2,67,2,1706.65,NULL,'2021-10-12 15:29:22','2021-10-12 15:29:22',NULL),(3988,2973,1160,40926,3765,2,13,1,9833.56,NULL,'2021-10-12 15:29:22','2021-10-12 15:29:22',NULL),(3989,2973,1161,40926,3765,2,96,2,23007.56,NULL,'2021-10-12 15:29:22','2021-10-12 15:29:22',NULL),(3990,2973,1161,40926,3765,2,67,2,4831.60,NULL,'2021-10-12 15:29:22','2021-10-12 15:29:22',NULL),(3991,2973,1161,40926,3765,2,13,1,27839.16,NULL,'2021-10-12 15:29:22','2021-10-12 15:29:22',NULL),(3992,2973,1162,40926,3765,2,96,2,21768.78,NULL,'2021-10-12 15:29:22','2021-10-12 15:29:22',NULL),(3993,2973,1162,40926,3765,2,67,2,4571.43,NULL,'2021-10-12 15:29:22','2021-10-12 15:29:22',NULL),(3994,2973,1162,40926,3765,2,13,1,26340.21,NULL,'2021-10-12 15:29:22','2021-10-12 15:29:22',NULL),(3995,2973,1163,40926,3765,2,96,2,584800.00,NULL,'2021-10-12 15:29:22','2021-10-12 15:29:22',NULL),(3996,2973,1163,40926,3765,2,67,2,122808.00,NULL,'2021-10-12 15:29:22','2021-10-12 15:29:22',NULL),(3997,2973,1163,40926,3765,2,13,1,707608.00,NULL,'2021-10-12 15:29:22','2021-10-12 15:29:22',NULL),(3998,2973,1164,40926,3765,3,250,1,1800.00,NULL,'2021-10-12 16:30:55','2021-10-12 16:30:55',NULL),(3999,2973,1164,40926,3765,3,57,2,1800.00,NULL,'2021-10-12 16:30:55','2021-10-12 16:30:55',NULL),(4000,2973,1165,40926,3765,3,217,1,45454.10,NULL,'2021-10-12 16:30:55','2021-10-12 16:30:55',NULL),(4001,2973,1165,40926,3765,3,68,1,9545.36,NULL,'2021-10-12 16:30:55','2021-10-12 16:30:55',NULL);
INSERT INTO `balance_libro_details` VALUES (4002,2973,1165,40926,3765,3,57,2,54999.46,NULL,'2021-10-12 16:30:55','2021-10-12 16:30:55',NULL),(4003,2973,1166,40926,3765,3,250,1,7000.00,NULL,'2021-10-12 16:30:55','2021-10-12 16:30:55',NULL),(4004,2973,1166,40926,3765,3,57,2,7000.00,NULL,'2021-10-12 16:30:55','2021-10-12 16:30:55',NULL),(4005,2973,1167,40926,3765,3,217,1,8454.69,NULL,'2021-10-12 16:30:55','2021-10-12 16:30:55',NULL),(4006,2973,1167,40926,3765,3,68,1,1775.48,NULL,'2021-10-12 16:30:55','2021-10-12 16:30:55',NULL),(4007,2973,1167,40926,3765,3,57,2,10230.17,NULL,'2021-10-12 16:30:55','2021-10-12 16:30:55',NULL),(4008,2973,1168,40926,3765,3,217,1,14108.15,NULL,'2021-10-12 16:30:55','2021-10-12 16:30:55',NULL),(4009,2973,1168,40926,3765,3,68,1,2962.71,NULL,'2021-10-12 16:30:55','2021-10-12 16:30:55',NULL),(4010,2973,1168,40926,3765,3,57,2,17070.86,NULL,'2021-10-12 16:30:55','2021-10-12 16:30:55',NULL),(4011,2973,1169,40926,3765,3,217,1,8528.01,NULL,'2021-10-12 16:30:55','2021-10-12 16:30:55',NULL),(4012,2973,1169,40926,3765,3,68,1,1790.88,NULL,'2021-10-12 16:30:55','2021-10-12 16:30:55',NULL),(4013,2973,1169,40926,3765,3,57,2,10318.89,NULL,'2021-10-12 16:30:55','2021-10-12 16:30:55',NULL),(4014,2973,1170,40926,3765,3,217,1,114658.78,NULL,'2021-10-12 16:30:55','2021-10-12 16:30:55',NULL),(4015,2973,1170,40926,3765,3,68,1,24078.34,NULL,'2021-10-12 16:30:55','2021-10-12 16:30:55',NULL),(4016,2973,1170,40926,3765,3,217,1,3439.76,NULL,'2021-10-12 16:30:55','2021-10-12 16:30:55',NULL),(4017,2973,1170,40926,3765,3,57,2,142176.88,NULL,'2021-10-12 16:30:55','2021-10-12 16:30:55',NULL),(4018,2973,1171,40926,3765,3,217,1,110717.88,NULL,'2021-10-12 16:30:55','2021-10-12 16:30:55',NULL),(4019,2973,1171,40926,3765,3,68,1,23250.75,NULL,'2021-10-12 16:30:55','2021-10-12 16:30:55',NULL),(4020,2973,1171,40926,3765,3,57,2,133968.63,NULL,'2021-10-12 16:30:55','2021-10-12 16:30:55',NULL),(4021,2973,1172,40926,3765,3,250,1,0.00,NULL,'2021-10-12 16:30:55','2021-10-12 16:30:55',NULL),(4022,2973,1172,40926,3765,3,250,1,22303.75,NULL,'2021-10-12 16:30:55','2021-10-12 16:30:55',NULL),(4023,2973,1172,40926,3765,3,57,2,22303.75,NULL,'2021-10-12 16:30:55','2021-10-12 16:30:55',NULL),(4024,2973,1173,40720,1541,17,96,1,7483823.31,NULL,'2021-10-23 10:38:27','2021-10-23 10:38:27',NULL),(4025,2973,1173,40720,1541,17,467,2,53812.58,NULL,'2021-10-23 10:38:27','2021-10-23 10:38:27',NULL),(4026,2973,1173,40720,1541,17,476,2,692215.52,NULL,'2021-10-23 10:38:27','2021-10-23 10:38:27',NULL),(4027,2973,1173,40720,1541,17,421,2,229483.08,NULL,'2021-10-23 10:38:27','2021-10-23 10:38:27',NULL),(4028,2973,1173,40720,1541,17,422,2,3494.20,NULL,'2021-10-23 10:38:27','2021-10-23 10:38:27',NULL),(4029,2973,1173,40720,1541,17,123,2,587.58,NULL,'2021-10-23 10:38:27','2021-10-23 10:38:27',NULL),(4030,2973,1173,40720,1541,17,484,2,874849.18,NULL,'2021-10-23 10:38:27','2021-10-23 10:38:27',NULL),(4031,2973,1173,40720,1541,17,483,2,469323.40,NULL,'2021-10-23 10:38:27','2021-10-23 10:38:27',NULL),(4032,2973,1173,40720,1541,17,485,2,7025.90,NULL,'2021-10-23 10:38:27','2021-10-23 10:38:27',NULL),(4033,2973,1173,40720,1541,17,128,2,23767.68,NULL,'2021-10-23 10:38:27','2021-10-23 10:38:27',NULL),(4034,2973,1173,40720,1541,17,129,2,158748.19,NULL,'2021-10-23 10:38:27','2021-10-23 10:38:27',NULL),(4035,2973,1173,40720,1541,17,135,2,146914.10,NULL,'2021-10-23 10:38:27','2021-10-23 10:38:27',NULL),(4036,2973,1173,40720,1541,17,192,2,914482.71,NULL,'2021-10-23 10:38:27','2021-10-23 10:38:27',NULL),(4037,2973,1173,40720,1541,17,136,1,0.15,NULL,'2021-10-23 10:38:27','2021-10-23 10:38:27',NULL),(4038,2973,1173,40720,1541,17,198,2,50289.91,NULL,'2021-10-23 10:38:27','2021-10-23 10:38:27',NULL),(4039,2973,1173,40720,1541,17,217,2,94824.06,NULL,'2021-10-23 10:38:27','2021-10-23 10:38:27',NULL),(4040,2973,1173,40720,1541,17,396,2,13759.98,NULL,'2021-10-23 10:38:27','2021-10-23 10:38:27',NULL),(4041,2973,1173,40720,1541,17,155,2,1038857.27,NULL,'2021-10-23 10:38:27','2021-10-23 10:38:27',NULL);
INSERT INTO `balance_libro_details` VALUES (4042,2973,1173,40720,1541,17,157,2,34380.58,NULL,'2021-10-23 10:38:27','2021-10-23 10:38:27',NULL),(4043,2973,1173,40720,1541,17,221,2,1053.29,NULL,'2021-10-23 10:38:27','2021-10-23 10:38:27',NULL),(4044,2973,1173,40720,1541,17,91,2,2424000.29,NULL,'2021-10-23 10:38:27','2021-10-23 10:38:27',NULL),(4045,2973,1173,40720,1541,17,156,2,251953.96,NULL,'2021-10-23 10:38:27','2021-10-23 10:38:27',NULL),(4046,2973,1174,40720,1541,17,420,1,229483.08,NULL,'2021-10-23 10:55:09','2021-10-23 10:55:09',NULL),(4047,2973,1174,40720,1541,17,415,1,3494.20,NULL,'2021-10-23 10:55:09','2021-10-23 10:55:09',NULL),(4048,2973,1174,40720,1541,17,57,1,9472.17,NULL,'2021-10-23 10:55:09','2021-10-23 10:55:09',NULL),(4049,2973,1174,40720,1541,17,367,1,800000.00,NULL,'2021-10-23 10:55:09','2021-10-23 10:55:09',NULL),(4050,2973,1174,40720,1541,17,74,1,115841.15,NULL,'2021-10-23 10:55:09','2021-10-23 10:55:09',NULL),(4051,2973,1174,40720,1541,17,411,1,1038857.27,NULL,'2021-10-23 10:55:09','2021-10-23 10:55:09',NULL),(4052,2973,1174,40720,1541,17,486,1,18373.85,NULL,'2021-10-23 10:55:09','2021-10-23 10:55:09',NULL),(4053,2973,1174,40720,1541,17,448,1,449076.62,NULL,'2021-10-23 10:55:09','2021-10-23 10:55:09',NULL),(4054,2973,1174,40720,1541,17,91,1,2424000.29,NULL,'2021-10-23 10:55:09','2021-10-23 10:55:09',NULL),(4055,2973,1174,40720,1541,17,88,1,16570.53,NULL,'2021-10-23 10:55:09','2021-10-23 10:55:09',NULL),(4056,2973,1174,40720,1541,17,369,1,50000.00,NULL,'2021-10-23 10:55:09','2021-10-23 10:55:09',NULL),(4057,2973,1174,40720,1541,17,381,1,61881.65,NULL,'2021-10-23 10:55:09','2021-10-23 10:55:09',NULL),(4058,2973,1174,40720,1541,17,383,1,299574.28,NULL,'2021-10-23 10:55:09','2021-10-23 10:55:09',NULL),(4059,2973,1174,40720,1541,17,359,2,8301.87,NULL,'2021-10-23 10:55:09','2021-10-23 10:55:09',NULL),(4060,2973,1174,40720,1541,17,10,2,408732.43,NULL,'2021-10-23 10:55:09','2021-10-23 10:55:09',NULL),(4061,2973,1174,40720,1541,17,23,2,32617.65,NULL,'2021-10-23 10:55:09','2021-10-23 10:55:09',NULL),(4062,2973,1174,40720,1541,17,487,2,68784.44,NULL,'2021-10-23 10:55:09','2021-10-23 10:55:09',NULL),(4063,2973,1174,40720,1541,17,488,2,1644500.00,NULL,'2021-10-23 10:55:09','2021-10-23 10:55:09',NULL),(4064,2973,1174,40720,1541,17,489,2,1644500.00,NULL,'2021-10-23 10:55:09','2021-10-23 10:55:09',NULL),(4065,2973,1174,40720,1541,17,20,2,518179.49,NULL,'2021-10-23 10:55:09','2021-10-23 10:55:09',NULL),(4066,2973,1174,40720,1541,17,311,2,8651.84,NULL,'2021-10-23 10:55:09','2021-10-23 10:55:09',NULL),(4067,2973,1174,40720,1541,17,419,2,1147415.38,NULL,'2021-10-23 10:55:09','2021-10-23 10:55:09',NULL),(4068,2973,1174,40720,1541,17,391,2,34941.99,NULL,'2021-10-23 10:55:09','2021-10-23 10:55:09',NULL),(4069,2973,1175,40926,3772,2,96,2,8324.10,NULL,'2022-03-15 10:49:21','2022-03-15 10:49:21',NULL),(4070,2973,1175,40926,3772,2,67,2,1748.07,NULL,'2022-03-15 10:49:21','2022-03-15 10:49:21',NULL),(4071,2973,1175,40926,3772,2,13,1,10072.17,NULL,'2022-03-15 10:49:21','2022-03-15 10:49:21',NULL),(4072,2973,1176,40926,3772,2,96,2,9455.86,NULL,'2022-03-15 10:49:21','2022-03-15 10:49:21',NULL),(4073,2973,1176,40926,3772,2,67,2,1985.74,NULL,'2022-03-15 10:49:21','2022-03-15 10:49:21',NULL),(4074,2973,1176,40926,3772,2,13,1,11441.60,NULL,'2022-03-15 10:49:21','2022-03-15 10:49:21',NULL),(4075,2973,1177,40926,3772,2,96,2,270989.00,NULL,'2022-03-15 10:49:21','2022-03-15 10:49:21',NULL),(4076,2973,1177,40926,3772,2,67,2,56907.69,NULL,'2022-03-15 10:49:21','2022-03-15 10:49:21',NULL),(4077,2973,1177,40926,3772,2,13,1,327896.69,NULL,'2022-03-15 10:49:21','2022-03-15 10:49:21',NULL),(4078,2973,1178,40926,3772,2,96,2,30000.00,NULL,'2022-03-15 10:49:21','2022-03-15 10:49:21',NULL),(4079,2973,1178,40926,3772,2,67,2,6300.00,NULL,'2022-03-15 10:49:21','2022-03-15 10:49:21',NULL),(4080,2973,1178,40926,3772,2,13,1,36300.00,NULL,'2022-03-15 10:49:21','2022-03-15 10:49:21',NULL),(4093,2973,1182,40719,3,19,251,1,150.36,NULL,'2022-06-20 12:50:41','2022-06-20 12:52:37','2022-06-20 12:52:37');
INSERT INTO `balance_libro_details` VALUES (4094,2973,1182,40719,3,19,68,1,451.07,NULL,'2022-06-20 12:50:41','2022-06-20 12:52:37','2022-06-20 12:52:37'),(4095,2973,1182,40719,3,19,483,1,2147.93,NULL,'2022-06-20 12:50:41','2022-06-20 12:52:37','2022-06-20 12:52:37'),(4096,2973,1182,40719,3,19,57,2,2749.36,NULL,'2022-06-20 12:50:41','2022-06-20 12:52:37','2022-06-20 12:52:37'),(4097,2973,1183,40719,3,19,251,1,150.36,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4098,2973,1183,40719,3,19,68,1,451.07,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4099,2973,1183,40719,3,19,483,1,2147.93,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4100,2973,1183,40719,3,19,57,2,2749.36,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4101,2973,1184,40719,3,19,91,1,2424000.29,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4102,2973,1184,40719,3,19,383,2,2424000.29,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4103,2973,1185,40719,3,19,23,1,32617.65,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4104,2973,1185,40719,3,19,444,1,408732.43,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4105,2973,1185,40719,3,19,359,1,8301.87,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4106,2973,1185,40719,3,19,488,1,1644500.00,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4107,2973,1185,40719,3,19,489,1,1644500.00,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4108,2973,1185,40719,3,19,487,1,68784.44,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4109,2973,1185,40719,3,19,391,1,34941.99,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4110,2973,1185,40719,3,19,419,1,1147415.38,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4111,2973,1185,40719,3,19,20,1,518179.49,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4112,2973,1185,40719,3,19,311,1,8651.84,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4113,2973,1185,40719,3,19,415,2,3494.20,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4114,2973,1185,40719,3,19,57,2,9472.17,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4115,2973,1185,40719,3,19,88,2,16570.53,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4116,2973,1185,40719,3,19,486,2,18373.85,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4117,2973,1185,40719,3,19,369,2,50000.00,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4118,2973,1185,40719,3,19,381,2,61881.65,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4119,2973,1185,40719,3,19,74,2,115841.15,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4120,2973,1185,40719,3,19,420,2,229483.08,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4121,2973,1185,40719,3,19,383,2,299574.28,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4122,2973,1185,40719,3,19,448,2,449076.62,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4123,2973,1185,40719,3,19,367,2,800000.00,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4124,2973,1185,40719,3,19,411,2,1038857.27,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4125,2973,1185,40719,3,19,91,2,2424000.29,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4126,2973,1186,40719,3,19,129,1,4044.07,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4127,2973,1186,40719,3,19,128,1,2513.65,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4128,2973,1186,40719,3,19,57,2,6557.72,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4129,2973,1187,40719,3,19,367,1,800000.00,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4130,2973,1187,40719,3,19,488,2,400000.00,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4131,2973,1187,40719,3,19,489,2,400000.00,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4132,2973,1188,40719,3,19,68,1,6109.95,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4133,2973,1188,40719,3,19,483,1,29095.00,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL);
INSERT INTO `balance_libro_details` VALUES (4134,2973,1188,40719,3,19,57,2,35204.95,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4135,2973,1189,40719,3,19,68,1,7.82,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4136,2973,1189,40719,3,19,483,1,37.23,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4137,2973,1189,40719,3,19,57,2,45.05,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4138,2973,1190,40719,3,19,251,1,53.99,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4139,2973,1190,40719,3,19,68,1,161.96,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4140,2973,1190,40719,3,19,483,1,771.22,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4141,2973,1190,40719,3,19,57,2,987.17,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4142,2973,1191,40719,3,19,13,1,179267.55,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4143,2973,1191,40719,3,19,67,2,31112.55,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4144,2973,1191,40719,3,19,96,2,148155.00,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4145,2973,1192,40719,3,19,484,1,78.93,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4146,2973,1192,40719,3,19,221,1,521.42,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4147,2973,1192,40719,3,19,251,1,129.78,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4148,2973,1192,40719,3,19,484,1,2644.17,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4149,2973,1192,40719,3,19,68,1,555.28,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4150,2973,1192,40719,3,19,57,2,3929.58,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4151,2973,1193,40719,3,19,68,1,8953.84,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4152,2973,1193,40719,3,19,484,1,42637.34,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4153,2973,1193,40719,3,19,57,2,51591.18,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4154,2973,1194,40719,3,19,217,1,15000.00,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4155,2973,1194,40719,3,19,57,2,15000.00,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4156,2973,1195,40719,3,19,484,1,289.60,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4157,2973,1195,40719,3,19,68,1,60.82,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4158,2973,1195,40719,3,19,57,2,350.42,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4159,2973,1196,40719,3,19,217,1,71472.00,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4160,2973,1196,40719,3,19,68,1,15009.12,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4161,2973,1196,40719,3,19,57,2,86481.12,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4162,2973,1197,40719,3,19,13,1,5445.00,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4163,2973,1197,40719,3,19,67,2,945.00,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4164,2973,1197,40719,3,19,96,2,4500.00,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4165,2973,1198,40719,3,19,13,1,793911.25,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4166,2973,1198,40719,3,19,67,2,137786.25,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4167,2973,1198,40719,3,19,96,2,656125.00,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4168,2973,1199,40719,3,19,13,1,116100.00,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4169,2973,1199,40719,3,19,67,2,20149.59,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4170,2973,1199,40719,3,19,96,2,95950.41,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4171,2973,1200,40719,3,19,221,1,792.02,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4172,2973,1200,40719,3,19,251,1,127.82,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4173,2973,1200,40719,3,19,25,1,72.10,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4174,2973,1200,40719,3,19,484,1,2403.49,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4175,2973,1200,40719,3,19,68,1,504.73,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL);
INSERT INTO `balance_libro_details` VALUES (4176,2973,1200,40719,3,19,57,2,3900.16,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4177,2973,1201,40719,3,19,484,1,85.79,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4178,2973,1201,40719,3,19,221,1,576.67,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4179,2973,1201,40719,3,19,251,1,143.90,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4180,2973,1201,40719,3,19,484,1,2935.16,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4181,2973,1201,40719,3,19,68,1,616.38,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4182,2973,1201,40719,3,19,57,2,4357.90,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4183,2973,1202,40719,3,19,484,1,72.60,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4184,2973,1202,40719,3,19,221,1,848.45,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4185,2973,1202,40719,3,19,251,1,156.48,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4186,2973,1202,40719,3,19,484,1,2990.87,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4187,2973,1202,40719,3,19,68,1,628.08,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4188,2973,1202,40719,3,19,57,2,4696.48,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4189,2973,1203,40719,3,19,68,1,35.94,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4190,2973,1203,40719,3,19,483,1,171.16,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4191,2973,1203,40719,3,19,57,2,207.10,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4192,2973,1204,40719,3,19,251,1,47.11,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4193,2973,1204,40719,3,19,68,1,141.36,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4194,2973,1204,40719,3,19,483,1,673.12,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4195,2973,1204,40719,3,19,57,2,861.59,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4196,2973,1205,40719,3,19,251,1,16.46,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4197,2973,1205,40719,3,19,68,1,86.43,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4198,2973,1205,40719,3,19,483,1,411.57,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4199,2973,1205,40719,3,19,57,2,514.46,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4200,2973,1206,40719,3,19,483,1,12590.06,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4201,2973,1206,40719,3,19,57,2,12590.06,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4202,2973,1207,40719,3,19,57,1,4069.69,NULL,'2022-06-20 12:52:46','2022-06-20 12:52:46',NULL),(4203,2973,1207,40719,3,19,484,2,222.56,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4204,2973,1207,40719,3,19,68,2,667.68,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4205,2973,1207,40719,3,19,483,2,3179.45,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4206,2973,1208,40719,3,19,57,1,3600.02,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4207,2973,1208,40719,3,19,484,2,196.88,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4208,2973,1208,40719,3,19,68,2,590.63,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4209,2973,1208,40719,3,19,483,2,2812.51,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4210,2973,1209,40719,3,19,13,1,414600.00,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4211,2973,1209,40719,3,19,67,2,71955.37,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4212,2973,1209,40719,3,19,96,2,342644.63,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4213,2973,1210,40719,3,19,484,1,10580.00,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4214,2973,1210,40719,3,19,68,1,2221.80,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4215,2973,1210,40719,3,19,57,2,12801.80,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4216,2973,1211,40719,3,19,129,1,38.00,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4217,2973,1211,40719,3,19,57,2,38.00,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL);
INSERT INTO `balance_libro_details` VALUES (4218,2973,1212,40719,3,19,484,1,5083.00,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4219,2973,1212,40719,3,19,68,1,1067.43,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4220,2973,1212,40719,3,19,57,2,6150.43,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4221,2973,1213,40719,3,19,68,1,12126.21,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4222,2973,1213,40719,3,19,484,1,57743.86,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4223,2973,1213,40719,3,19,57,2,69870.07,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4224,2973,1214,40719,3,19,251,1,633.42,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4225,2973,1214,40719,3,19,217,1,9048.87,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4226,2973,1214,40719,3,19,68,1,950.13,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4227,2973,1214,40719,3,19,57,2,10632.42,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4228,2973,1215,40719,3,19,13,1,307243.20,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4229,2973,1215,40719,3,19,67,2,53323.20,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4230,2973,1215,40719,3,19,96,2,253920.00,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4231,2973,1216,40719,3,19,221,1,777.91,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4232,2973,1216,40719,3,19,251,1,132.32,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4233,2973,1216,40719,3,19,484,1,2646.39,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4234,2973,1216,40719,3,19,68,1,555.74,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4235,2973,1216,40719,3,19,57,2,4112.36,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4236,2973,1217,40719,3,19,251,1,5152.00,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4237,2973,1217,40719,3,19,23,1,3808.60,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4238,2973,1217,40719,3,19,444,1,302735.40,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4239,2973,1217,40719,3,19,13,2,311696.00,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4240,2973,1218,40719,3,19,13,1,311696.00,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4241,2973,1218,40719,3,19,67,2,54096.00,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4242,2973,1218,40719,3,19,96,2,257600.00,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4243,2973,1219,40719,3,19,96,1,253920.00,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4244,2973,1219,40719,3,19,67,1,53323.20,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4245,2973,1219,40719,3,19,13,2,307243.20,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4246,2973,1220,40719,3,19,251,1,45337.42,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4247,2973,1220,40719,3,19,217,1,1450.00,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4248,2973,1220,40719,3,19,68,1,304.50,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4249,2973,1220,40719,3,19,57,2,47091.92,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4250,2973,1221,40719,3,19,57,1,23947.14,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4251,2973,1221,40719,3,19,359,2,23947.14,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4252,2973,1222,40719,3,19,251,1,5152.00,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4253,2973,1222,40719,3,19,251,2,5152.00,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4254,2973,1223,40719,3,19,136,1,0.05,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4255,2973,1223,40719,3,19,67,1,316044.76,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4256,2973,1223,40719,3,19,25,2,72.10,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4257,2973,1223,40719,3,19,68,2,49290.32,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4258,2973,1223,40719,3,19,74,2,266682.39,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL);
INSERT INTO `balance_libro_details` VALUES (4259,2973,1224,40719,3,19,156,1,51552.37,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4260,2973,1224,40719,3,19,301,1,23754.55,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4261,2973,1224,40719,3,19,302,1,645.39,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4262,2973,1224,40719,3,19,311,1,7745.27,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4263,2973,1224,40719,3,19,311,2,8651.84,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4264,2973,1224,40719,3,19,486,2,22964.38,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4265,2973,1224,40719,3,19,251,2,52081.36,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4266,2973,1225,40719,3,19,57,1,47091.92,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4267,2973,1225,40719,3,19,444,2,47091.92,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4268,2973,1226,40719,3,19,444,1,1509323.80,NULL,'2022-06-20 12:52:47','2022-06-20 18:03:28','2022-06-20 18:03:28'),(4269,2973,1226,40719,3,19,359,1,45000.00,NULL,'2022-06-20 12:52:47','2022-06-20 18:03:28','2022-06-20 18:03:28'),(4270,2973,1226,40719,3,19,57,1,218638.30,NULL,'2022-06-20 12:52:47','2022-06-20 18:03:28','2022-06-20 18:03:28'),(4271,2973,1226,40719,3,19,74,1,109577.21,NULL,'2022-06-20 12:52:47','2022-06-20 18:03:28','2022-06-20 18:03:28'),(4272,2973,1226,40719,3,19,488,1,150000.00,NULL,'2022-06-20 12:52:47','2022-06-20 18:03:28','2022-06-20 18:03:28'),(4273,2973,1226,40719,3,19,489,1,150000.00,NULL,'2022-06-20 12:52:47','2022-06-20 18:03:28','2022-06-20 18:03:28'),(4274,2973,1226,40719,3,19,487,1,14152.80,NULL,'2022-06-20 12:52:47','2022-06-20 18:03:28','2022-06-20 18:03:28'),(4275,2973,1226,40719,3,19,20,1,86345.97,NULL,'2022-06-20 12:52:47','2022-06-20 18:03:28','2022-06-20 18:03:28'),(4276,2973,1226,40719,3,19,448,1,26416.27,NULL,'2022-06-20 12:52:47','2022-06-20 18:03:28','2022-06-20 18:03:28'),(4277,2973,1226,40719,3,19,467,1,1725.86,NULL,'2022-06-20 12:52:47','2022-06-20 18:03:28','2022-06-20 18:03:28'),(4278,2973,1226,40719,3,19,135,1,14677.90,NULL,'2022-06-20 12:52:47','2022-06-20 18:03:28','2022-06-20 18:03:28'),(4279,2973,1226,40719,3,19,444,2,816534.31,NULL,'2022-06-20 12:52:47','2022-06-20 18:03:28','2022-06-20 18:03:28'),(4280,2973,1226,40719,3,19,13,2,1509323.80,NULL,'2022-06-20 12:52:47','2022-06-20 18:03:28','2022-06-20 18:03:28'),(4281,2973,1227,40719,4,19,217,1,245.13,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4282,2973,1227,40719,4,19,68,1,35.75,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4283,2973,1227,40719,4,19,57,2,280.88,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4284,2973,1228,40719,4,19,68,1,6109.95,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4285,2973,1228,40719,4,19,483,1,29095.00,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4286,2973,1228,40719,4,19,57,2,35204.95,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4287,2973,1229,40719,4,19,13,1,772282.50,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4288,2973,1229,40719,4,19,67,2,134032.50,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4289,2973,1229,40719,4,19,96,2,638250.00,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4290,2973,1230,40719,4,19,251,1,64.58,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4291,2973,1230,40719,4,19,68,1,193.75,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4292,2973,1230,40719,4,19,483,1,922.61,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4293,2973,1230,40719,4,19,57,2,1180.94,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4294,2973,1231,40719,4,19,221,1,654.08,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4295,2973,1231,40719,4,19,251,1,113.47,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4296,2973,1231,40719,4,19,484,1,2269.39,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4297,2973,1231,40719,4,19,68,1,476.57,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL);
INSERT INTO `balance_libro_details` VALUES (4298,2973,1231,40719,4,19,57,2,3513.51,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4299,2973,1232,40719,4,19,13,1,93775.00,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4300,2973,1232,40719,4,19,67,2,16275.00,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4301,2973,1232,40719,4,19,96,2,77500.00,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4302,2973,1233,40719,4,19,217,1,22314.05,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4303,2973,1233,40719,4,19,68,1,4685.95,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4304,2973,1233,40719,4,19,57,2,27000.00,NULL,'2022-06-20 12:52:47','2022-06-20 12:52:47',NULL),(4305,2973,1234,40719,4,19,217,1,15000.00,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4306,2973,1234,40719,4,19,57,2,15000.00,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4307,2973,1235,40719,4,19,68,1,18883.01,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4308,2973,1235,40719,4,19,484,1,89919.09,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4309,2973,1235,40719,4,19,57,2,108802.10,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4310,2973,1236,40719,4,19,13,1,388500.00,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4311,2973,1236,40719,4,19,96,2,388500.00,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4312,2973,1237,40719,4,19,96,1,388500.00,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4313,2973,1237,40719,4,19,96,2,388500.00,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4314,2973,1238,40719,4,19,13,1,788390.00,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4315,2973,1238,40719,4,19,67,2,136828.02,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4316,2973,1238,40719,4,19,96,2,651561.98,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4317,2973,1239,40719,4,19,221,1,535.00,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4318,2973,1239,40719,4,19,251,1,161.67,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4319,2973,1239,40719,4,19,484,1,2698.43,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4320,2973,1239,40719,4,19,68,1,566.67,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4321,2973,1239,40719,4,19,57,2,3961.77,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4322,2973,1240,40719,4,19,251,1,89.97,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4323,2973,1240,40719,4,19,68,1,236.16,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4324,2973,1240,40719,4,19,483,1,1124.57,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4325,2973,1240,40719,4,19,57,2,1450.70,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4326,2973,1241,40719,4,19,217,1,61100.00,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4327,2973,1241,40719,4,19,68,1,12831.00,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4328,2973,1241,40719,4,19,57,2,73931.00,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4329,2973,1242,40719,4,19,251,1,45.12,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4330,2973,1242,40719,4,19,68,1,189.52,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4331,2973,1242,40719,4,19,483,1,902.48,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4332,2973,1242,40719,4,19,57,2,1137.12,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4333,2973,1243,40719,4,19,217,1,2305.78,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4334,2973,1243,40719,4,19,68,1,484.21,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4335,2973,1243,40719,4,19,57,2,2789.99,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4336,2973,1244,40719,4,19,217,1,484.21,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4337,2973,1244,40719,4,19,68,2,484.21,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4338,2973,1245,40719,4,19,484,1,12903.00,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL);
INSERT INTO `balance_libro_details` VALUES (4339,2973,1245,40719,4,19,68,1,2709.63,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4340,2973,1245,40719,4,19,57,2,15612.63,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4341,2973,1246,40719,4,19,68,1,88513.41,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4342,2973,1246,40719,4,19,484,1,421492.45,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4343,2973,1246,40719,4,19,57,2,510005.86,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4344,2973,1247,40719,4,19,13,1,65176.65,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4345,2973,1247,40719,4,19,67,2,11311.65,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4346,2973,1247,40719,4,19,96,2,53865.00,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4347,2973,1248,40719,4,19,57,1,22308.10,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4348,2973,1248,40719,4,19,359,2,22308.10,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4349,2973,1249,40719,4,19,221,1,827.38,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4350,2973,1249,40719,4,19,251,1,182.82,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4351,2973,1249,40719,4,19,25,1,84.87,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4352,2973,1249,40719,4,19,484,1,2828.96,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4353,2973,1249,40719,4,19,68,1,594.08,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4354,2973,1249,40719,4,19,57,2,4518.11,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4355,2973,1250,40719,4,19,128,1,84.87,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4356,2973,1250,40719,4,19,25,2,84.87,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4357,2973,1251,40719,4,19,251,1,72.80,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4358,2973,1251,40719,4,19,135,2,72.80,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4359,2973,1252,40719,4,19,67,1,298447.17,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4360,2973,1252,40719,4,19,68,2,136329.96,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4361,2973,1252,40719,4,19,74,2,162117.21,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4362,2973,1253,40719,4,19,156,1,60947.21,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4363,2973,1253,40719,4,19,301,1,46325.67,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4364,2973,1253,40719,4,19,311,1,5812.53,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4365,2973,1253,40719,4,19,302,2,645.39,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4366,2973,1253,40719,4,19,486,2,1075.56,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4367,2973,1253,40719,4,19,311,2,7745.27,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4368,2973,1253,40719,4,19,301,2,23754.55,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4369,2973,1253,40719,4,19,251,2,79864.64,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4370,2973,1254,40719,4,19,251,1,79134.51,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4371,2973,1254,40719,4,19,217,1,1450.00,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4372,2973,1254,40719,4,19,68,1,304.50,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4373,2973,1254,40719,4,19,57,2,80889.01,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4374,2973,1255,40719,4,19,57,1,80889.01,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4375,2973,1255,40719,4,19,444,2,80889.01,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4376,2973,1256,40719,4,19,444,1,2332665.00,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4377,2973,1256,40719,4,19,359,1,40000.00,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4378,2973,1256,40719,4,19,57,1,344210.79,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4379,2973,1256,40719,4,19,74,1,272946.33,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL);
INSERT INTO `balance_libro_details` VALUES (4380,2973,1256,40719,4,19,488,1,450000.00,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4381,2973,1256,40719,4,19,489,1,450000.00,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4382,2973,1256,40719,4,19,487,1,26287.25,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4383,2973,1256,40719,4,19,20,1,86345.97,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4384,2973,1256,40719,4,19,448,1,26416.27,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4385,2973,1256,40719,4,19,467,1,3690.25,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4386,2973,1256,40719,4,19,444,2,1699896.86,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4387,2973,1256,40719,4,19,13,2,2332665.00,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4388,2973,1257,40719,5,19,359,1,60000.00,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4389,2973,1257,40719,5,19,488,2,30000.00,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4390,2973,1257,40719,5,19,489,2,30000.00,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4391,2973,1258,40719,5,19,217,1,4705.88,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4392,2973,1258,40719,5,19,68,1,494.12,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4393,2973,1258,40719,5,19,57,2,5200.00,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4394,2973,1259,40719,5,19,13,1,289700.00,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4395,2973,1259,40719,5,19,67,2,50278.51,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4396,2973,1259,40719,5,19,96,2,239421.49,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4397,2973,1260,40719,5,19,484,1,454.81,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4398,2973,1260,40719,5,19,251,1,1072.07,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4399,2973,1260,40719,5,19,25,1,620.20,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4400,2973,1260,40719,5,19,68,1,4176.86,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4401,2973,1260,40719,5,19,135,1,313.08,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4402,2973,1260,40719,5,19,198,1,19889.79,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4403,2973,1260,40719,5,19,484,2,17.24,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4404,2973,1260,40719,5,19,57,2,26509.57,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4405,2973,1261,40719,5,19,198,1,620.20,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4406,2973,1261,40719,5,19,25,2,620.20,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4407,2973,1262,40719,5,19,198,1,419.99,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4408,2973,1262,40719,5,19,57,2,419.99,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4409,2973,1263,40719,5,19,68,1,6109.95,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4410,2973,1263,40719,5,19,483,1,29095.00,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4411,2973,1263,40719,5,19,57,2,35204.95,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4412,2973,1264,40719,5,19,217,1,73000.00,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4413,2973,1264,40719,5,19,68,1,15330.00,NULL,'2022-06-20 12:52:48','2022-06-20 12:52:48',NULL),(4414,2973,1264,40719,5,19,57,2,88330.00,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4415,2973,1265,40719,5,19,68,1,452.59,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4416,2973,1265,40719,5,19,483,1,2155.18,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4417,2973,1265,40719,5,19,57,2,2607.77,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4418,2973,1266,40719,5,19,217,1,9917.36,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4419,2973,1266,40719,5,19,68,1,2082.64,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4420,2973,1266,40719,5,19,57,2,12000.00,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL);
INSERT INTO `balance_libro_details` VALUES (4421,2973,1267,40719,5,19,251,1,65.02,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4422,2973,1267,40719,5,19,68,1,170.69,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4423,2973,1267,40719,5,19,483,1,812.81,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4424,2973,1267,40719,5,19,57,2,1048.52,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4425,2973,1268,40719,5,19,217,1,45000.00,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4426,2973,1268,40719,5,19,68,1,9450.00,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4427,2973,1268,40719,5,19,57,2,54450.00,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4428,2973,1269,40719,5,19,221,1,522.31,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4429,2973,1269,40719,5,19,251,1,79.37,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4430,2973,1269,40719,5,19,484,1,3098.12,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4431,2973,1269,40719,5,19,68,1,650.61,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4432,2973,1269,40719,5,19,57,2,4350.41,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4433,2973,1270,40719,5,19,13,1,106480.00,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4434,2973,1270,40719,5,19,67,2,18480.00,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4435,2973,1270,40719,5,19,96,2,88000.00,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4436,2973,1271,40719,5,19,217,1,170.25,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4437,2973,1271,40719,5,19,68,1,35.75,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4438,2973,1271,40719,5,19,57,2,206.00,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4439,2973,1272,40719,5,19,396,1,170.48,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4440,2973,1272,40719,5,19,57,2,170.48,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4441,2973,1273,40719,5,19,217,1,6515.84,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4442,2973,1273,40719,5,19,68,1,684.16,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4443,2973,1273,40719,5,19,57,2,7200.00,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4444,2973,1274,40719,5,19,217,1,1500.00,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4445,2973,1274,40719,5,19,57,2,1500.00,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4446,2973,1275,40719,5,19,217,1,2868.60,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4447,2973,1275,40719,5,19,68,1,602.40,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4448,2973,1275,40719,5,19,57,2,3471.00,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4449,2973,1276,40719,5,19,13,1,414750.01,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4450,2973,1276,40719,5,19,67,2,71981.41,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4451,2973,1276,40719,5,19,96,2,342768.60,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4452,2973,1277,40719,5,19,13,1,231110.00,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4453,2973,1277,40719,5,19,67,2,40110.00,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4454,2973,1277,40719,5,19,96,2,191000.00,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4455,2973,1278,40719,5,19,251,1,41.27,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4456,2973,1278,40719,5,19,217,1,825.40,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4457,2973,1278,40719,5,19,68,1,173.33,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4458,2973,1278,40719,5,19,57,2,1040.00,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4459,2973,1279,40719,5,19,217,1,15000.00,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4460,2973,1279,40719,5,19,57,2,15000.00,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4461,2973,1280,40719,5,19,217,1,1504.13,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4462,2973,1280,40719,5,19,68,1,315.87,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL);
INSERT INTO `balance_libro_details` VALUES (4463,2973,1280,40719,5,19,57,2,1820.00,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4464,2973,1281,40719,5,19,217,1,315.87,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4465,2973,1281,40719,5,19,68,2,315.87,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4466,2973,1282,40719,5,19,221,1,994.01,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4467,2973,1282,40719,5,19,251,1,397.46,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4468,2973,1282,40719,5,19,25,1,89.41,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4469,2973,1282,40719,5,19,484,1,2980.50,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4470,2973,1282,40719,5,19,68,1,625.91,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4471,2973,1282,40719,5,19,57,2,5087.29,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4472,2973,1283,40719,5,19,217,1,148904.98,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4473,2973,1283,40719,5,19,68,1,15635.02,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4474,2973,1283,40719,5,19,57,2,164540.00,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4475,2973,1284,40719,5,19,217,1,2791.93,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4476,2973,1284,40719,5,19,68,1,586.31,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4477,2973,1284,40719,5,19,57,2,3378.24,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4478,2973,1285,40719,5,19,68,1,20725.86,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4479,2973,1285,40719,5,19,484,1,98694.57,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4480,2973,1285,40719,5,19,57,2,119420.43,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4481,2973,1286,40719,5,19,217,1,413.08,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4482,2973,1286,40719,5,19,68,1,86.75,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4483,2973,1286,40719,5,19,57,2,499.83,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4484,2973,1287,40719,5,19,13,1,87800.00,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4485,2973,1287,40719,5,19,67,2,15238.02,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4486,2973,1287,40719,5,19,96,2,72561.98,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4487,2973,1288,40719,5,19,217,1,86.75,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4488,2973,1288,40719,5,19,68,2,86.75,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4489,2973,1289,40719,5,19,13,1,32524.80,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4490,2973,1289,40719,5,19,67,2,5644.80,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4491,2973,1289,40719,5,19,96,2,26880.00,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4492,2973,1290,40719,5,19,251,1,806.40,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4493,2973,1290,40719,5,19,13,2,806.40,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4494,2973,1291,40719,5,19,251,1,32.47,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4495,2973,1291,40719,5,19,484,1,649.36,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4496,2973,1291,40719,5,19,68,1,136.37,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4497,2973,1291,40719,5,19,57,2,818.20,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4498,2973,1292,40719,5,19,221,1,508.93,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4499,2973,1292,40719,5,19,251,1,77.33,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4500,2973,1292,40719,5,19,484,1,3317.72,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4501,2973,1292,40719,5,19,68,1,696.72,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4502,2973,1292,40719,5,19,57,2,4600.70,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4503,2973,1293,40719,5,19,251,1,147.20,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4504,2973,1293,40719,5,19,68,1,309.11,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL);
INSERT INTO `balance_libro_details` VALUES (4505,2973,1293,40719,5,19,483,1,1471.94,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4506,2973,1293,40719,5,19,57,2,1928.25,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4507,2973,1294,40719,5,19,251,1,40.66,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4508,2973,1294,40719,5,19,68,1,170.78,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4509,2973,1294,40719,5,19,483,1,813.22,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4510,2973,1294,40719,5,19,57,2,1024.66,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4511,2973,1295,40719,5,19,217,1,30000.00,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4512,2973,1295,40719,5,19,68,1,6300.00,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4513,2973,1295,40719,5,19,57,2,36300.00,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4514,2973,1296,40719,5,19,217,1,600.00,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4515,2973,1296,40719,5,19,57,2,600.00,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4516,2973,1297,40719,5,19,484,1,6402.00,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4517,2973,1297,40719,5,19,68,1,1344.42,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4518,2973,1297,40719,5,19,57,2,7746.42,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4519,2973,1298,40719,5,19,217,1,214.88,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4520,2973,1298,40719,5,19,68,1,45.12,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4521,2973,1298,40719,5,19,57,2,260.00,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4522,2973,1299,40719,5,19,68,1,3735.16,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4523,2973,1299,40719,5,19,484,1,17786.49,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4524,2973,1299,40719,5,19,57,2,21521.65,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4525,2973,1300,40719,5,19,13,1,67397.00,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4526,2973,1300,40719,5,19,67,2,11697.00,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4527,2973,1300,40719,5,19,96,2,55700.00,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4528,2973,1301,40719,5,19,13,1,416000.00,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4529,2973,1301,40719,5,19,67,2,72198.35,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4530,2973,1301,40719,5,19,96,2,343801.65,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4531,2973,1302,40719,5,19,484,1,5028.00,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4532,2973,1302,40719,5,19,68,1,1055.88,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4533,2973,1302,40719,5,19,57,2,6083.88,NULL,'2022-06-20 12:52:49','2022-06-20 12:52:49',NULL),(4534,2973,1303,40719,5,19,217,1,54200.00,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4535,2973,1303,40719,5,19,68,1,11382.00,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4536,2973,1303,40719,5,19,57,2,65582.00,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4537,2973,1304,40719,5,19,13,1,95590.00,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4538,2973,1304,40719,5,19,67,2,16590.00,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4539,2973,1304,40719,5,19,96,2,79000.00,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4540,2973,1305,40719,5,19,67,1,302218.09,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4541,2973,1305,40719,5,19,25,2,89.41,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4542,2973,1305,40719,5,19,68,2,103466.26,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4543,2973,1305,40719,5,19,74,2,198662.42,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4544,2973,1306,40719,5,19,156,1,49470.78,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4545,2973,1306,40719,5,19,301,1,45257.83,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL);
INSERT INTO `balance_libro_details` VALUES (4546,2973,1306,40719,5,19,311,1,4353.03,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4547,2973,1306,40719,5,19,311,2,5812.53,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4548,2973,1306,40719,5,19,486,2,7613.37,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4549,2973,1306,40719,5,19,251,2,39330.07,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4550,2973,1306,40719,5,19,301,2,46325.67,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4551,2973,1307,40719,5,19,251,1,36525.45,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4552,2973,1307,40719,5,19,217,1,1450.00,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4553,2973,1307,40719,5,19,68,1,304.50,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4554,2973,1307,40719,5,19,57,2,38279.95,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4555,2973,1308,40719,5,19,57,1,38279.95,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4556,2973,1308,40719,5,19,444,2,38279.95,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4557,2973,1309,40719,5,19,57,1,200622.33,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4558,2973,1309,40719,5,19,359,2,200622.33,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4559,2973,1310,40719,5,19,444,1,1448625.05,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4560,2973,1310,40719,5,19,359,1,100000.00,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4561,2973,1310,40719,5,19,57,1,1019302.72,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4562,2973,1310,40719,5,19,74,1,162117.21,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4563,2973,1310,40719,5,19,488,1,500000.00,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4564,2973,1310,40719,5,19,489,1,500000.00,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4565,2973,1310,40719,5,19,487,1,22070.04,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4566,2973,1310,40719,5,19,135,1,4731.75,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4567,2973,1310,40719,5,19,20,1,86345.97,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4568,2973,1310,40719,5,19,448,1,26416.27,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4569,2973,1310,40719,5,19,467,1,2782.51,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4570,2973,1310,40719,5,19,13,2,1448625.05,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4571,2973,1310,40719,5,19,444,2,2423766.47,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4572,2973,1311,40719,6,19,484,1,84.02,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4573,2973,1311,40719,6,19,221,1,564.76,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4574,2973,1311,40719,6,19,484,1,3323.57,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4575,2973,1311,40719,6,19,68,1,697.95,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4576,2973,1311,40719,6,19,57,2,4670.30,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4577,2973,1312,40719,6,19,251,1,120.84,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4578,2973,1312,40719,6,19,68,1,253.77,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4579,2973,1312,40719,6,19,483,1,1208.44,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4580,2973,1312,40719,6,19,57,2,1583.05,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4581,2973,1313,40719,6,19,484,1,73.46,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4582,2973,1313,40719,6,19,251,1,79.31,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4583,2973,1313,40719,6,19,217,1,1586.25,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4584,2973,1313,40719,6,19,68,1,333.11,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4585,2973,1313,40719,6,19,57,2,2072.13,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4586,2973,1314,40719,6,19,68,1,562.88,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL);
INSERT INTO `balance_libro_details` VALUES (4587,2973,1314,40719,6,19,484,1,2680.37,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4588,2973,1314,40719,6,19,57,2,3243.25,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4589,2973,1315,40719,6,19,68,1,6162.97,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4590,2973,1315,40719,6,19,484,1,29347.48,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4591,2973,1315,40719,6,19,57,2,35510.45,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4592,2973,1316,40719,6,19,217,1,15000.00,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4593,2973,1316,40719,6,19,57,2,15000.00,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4594,2973,1317,40719,6,19,13,1,69962.20,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4595,2973,1317,40719,6,19,67,2,12142.20,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4596,2973,1317,40719,6,19,96,2,57820.00,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4597,2973,1318,40719,6,19,13,1,26620.00,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4598,2973,1318,40719,6,19,67,2,4620.00,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4599,2973,1318,40719,6,19,96,2,22000.00,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4600,2973,1319,40719,6,19,68,1,6109.95,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4601,2973,1319,40719,6,19,483,1,29095.00,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4602,2973,1319,40719,6,19,57,2,35204.95,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4603,2973,1320,40719,6,19,13,1,1522763.40,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4604,2973,1320,40719,6,19,67,2,264281.25,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4605,2973,1320,40719,6,19,96,2,1258482.15,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4606,2973,1321,40719,6,19,13,1,965888.01,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4607,2973,1321,40719,6,19,67,2,167633.46,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4608,2973,1321,40719,6,19,96,2,798254.55,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4609,2973,1322,40719,6,19,251,1,2394.60,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4610,2973,1322,40719,6,19,23,1,253.00,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4611,2973,1322,40719,6,19,13,2,2647.60,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4612,2973,1323,40719,6,19,221,1,653.58,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4613,2973,1323,40719,6,19,251,1,403.96,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4614,2973,1323,40719,6,19,25,1,101.58,NULL,'2022-06-20 12:52:50','2022-06-20 12:52:50',NULL),(4615,2973,1323,40719,6,19,484,1,3386.01,NULL,'2022-06-20 12:52:50','2022