-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db27-31020425-6
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2021-03-17 22:06:02','Actividad Generica 1','000001',NULL),(2,NULL,'2021-03-17 22:06:02','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
/*!40000 ALTER TABLE `balance_libro` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro_details`
--

DROP TABLE IF EXISTS `balance_libro_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `balance_libro_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_details_person_id_foreign` (`person_id`),
  KEY `balance_libro_details_period_id_foreign` (`period_id`),
  KEY `balance_libro_details_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_details_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_libro_details_saldo_id_foreign` (`saldo_id`),
  KEY `balance_libro_details_balance_libro_id_foreign` (`balance_libro_id`),
  CONSTRAINT `balance_libro_details_balance_libro_id_foreign` FOREIGN KEY (`balance_libro_id`) REFERENCES `balance_libro` (`id`) ON DELETE CASCADE,
  CONSTRAINT `balance_libro_details_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_details_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `balance_libro_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro_details`
--

LOCK TABLES `balance_libro_details` WRITE;
/*!40000 ALTER TABLE `balance_libro_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `balance_libro_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs`
--

DROP TABLE IF EXISTS `blogs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fecha` date NOT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `blogs_categoria_sub_id` int(10) unsigned NOT NULL,
  `path` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `titulo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `contenido` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autor` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `publicar` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  KEY `blogs_blogs_categoria_sub_id_foreign` (`blogs_categoria_sub_id`),
  CONSTRAINT `blogs_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`),
  CONSTRAINT `blogs_blogs_categoria_sub_id_foreign` FOREIGN KEY (`blogs_categoria_sub_id`) REFERENCES `blogs_categorias_sub` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs`
--

LOCK TABLES `blogs` WRITE;
/*!40000 ALTER TABLE `blogs` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias`
--

DROP TABLE IF EXISTS `blogs_categorias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias`
--

LOCK TABLES `blogs_categorias` WRITE;
/*!40000 ALTER TABLE `blogs_categorias` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias_sub`
--

DROP TABLE IF EXISTS `blogs_categorias_sub`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias_sub` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_categorias_sub_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  CONSTRAINT `blogs_categorias_sub_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias_sub`
--

LOCK TABLES `blogs_categorias_sub` WRITE;
/*!40000 ALTER TABLE `blogs_categorias_sub` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias_sub` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_alicuotas`
--

DROP TABLE IF EXISTS `bs_per_alicuotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_alicuotas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `anio` int(10) unsigned NOT NULL,
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `desde` decimal(16,2) NOT NULL DEFAULT '0.00',
  `hasta` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `mas_porcentaje` decimal(16,4) NOT NULL DEFAULT '0.0000',
  `excedente` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_alicuotas`
--

LOCK TABLES `bs_per_alicuotas` WRITE;
/*!40000 ALTER TABLE `bs_per_alicuotas` DISABLE KEYS */;
INSERT INTO `bs_per_alicuotas` VALUES (1,2017,950000.00,0.00,999999999.99,0.00,0.0050,950000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,2018,1050000.00,0.00,999999999.99,0.00,0.0025,1050000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,2019,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2019-11-19 21:09:50','2021-03-17 22:06:02',NULL),(4,2019,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2019-11-19 21:09:50','2021-03-17 22:06:02',NULL),(5,2019,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2019-11-19 21:09:50','2021-03-17 22:06:02',NULL),(6,2019,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2021-03-17 22:06:02','2021-03-17 22:06:02',NULL),(7,2020,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2021-06-15 20:41:13','2021-06-30 13:11:13',NULL),(8,2020,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2021-06-15 20:41:13','2021-06-30 13:11:13',NULL),(9,2020,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2021-06-15 20:41:13','2021-06-30 13:11:13',NULL),(10,2020,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2021-06-15 20:41:13','2021-06-30 13:11:13',NULL),(11,2021,6000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2022-05-17 16:44:35','2022-05-17 16:44:35',NULL),(12,2021,6000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2022-05-17 16:44:35','2022-05-17 16:44:35',NULL),(13,2021,6000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2022-05-17 16:44:35','2022-05-17 16:44:35',NULL),(14,2021,6000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-05-17 16:44:35','2022-05-17 16:44:35',NULL);
/*!40000 ALTER TABLE `bs_per_alicuotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_ddjjs`
--

DROP TABLE IF EXISTS `bs_per_ddjjs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_ddjjs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `anio` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `total_bienes_gravados` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total_bienes_exentos` decimal(16,2) NOT NULL DEFAULT '0.00',
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `base_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto_determinado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_pagar` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_favor` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_per_ddjjs_person_id_foreign` (`person_id`),
  CONSTRAINT `bs_per_ddjjs_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_ddjjs`
--

LOCK TABLES `bs_per_ddjjs` WRITE;
/*!40000 ALTER TABLE `bs_per_ddjjs` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_per_ddjjs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_conceptos`
--

DROP TABLE IF EXISTS `bs_pers_conceptos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_conceptos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_conceptos`
--

LOCK TABLES `bs_pers_conceptos` WRITE;
/*!40000 ALTER TABLE `bs_pers_conceptos` DISABLE KEYS */;
INSERT INTO `bs_pers_conceptos` VALUES (1,'Inmuebles',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,'Derechos Reales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,'Naves y Aeronaves',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(4,'Automotores y otros rodados',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(5,'Dinero y depósitos en dinero',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(6,'Títulos, acciones, cuotas o participaciones sociales y otros títulos valores',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(7,'Patrimonio de empresas o explotaciones unipersonales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(8,'Créditos y debentures',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(9,'Derechos de propiedad científica, literaria o artística, marcas, patentes y sus licencias',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(10,'Otros Bienes (incluye semovientes, antigüedades, objetos de colección, objetos de arte, ...)',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(11,'Objetos Personales y del Hogar',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL);
/*!40000 ALTER TABLE `bs_pers_conceptos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_anticipos`
--

DROP TABLE IF EXISTS `bs_pers_detail_anticipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_anticipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ganan_concepto_anticipo_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_anticipos_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` (`ganan_concepto_anticipo_id`),
  CONSTRAINT `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` FOREIGN KEY (`ganan_concepto_anticipo_id`) REFERENCES `ganan_conceptos_anticipos` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_anticipos`
--

LOCK TABLES `bs_pers_detail_anticipos` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_bienes`
--

DROP TABLE IF EXISTS `bs_pers_detail_bienes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_bienes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `bs_pers_concepto_id` int(10) unsigned NOT NULL,
  `concepto` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe_gravado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `importe_exento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_bienes_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` (`bs_pers_concepto_id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` FOREIGN KEY (`bs_pers_concepto_id`) REFERENCES `bs_pers_conceptos` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_bienes`
--

LOCK TABLES `bs_pers_detail_bienes` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calle`
--

DROP TABLE IF EXISTS `calle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calle` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `localidad_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `desdealt` int(10) unsigned DEFAULT NULL,
  `hastaalt` int(10) unsigned DEFAULT NULL,
  `codpostal` int(10) unsigned DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calle_localidad_id_foreign` (`localidad_id`),
  CONSTRAINT `calle_localidad_id_foreign` FOREIGN KEY (`localidad_id`) REFERENCES `localidad` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calle`
--

LOCK TABLES `calle` WRITE;
/*!40000 ALTER TABLE `calle` DISABLE KEYS */;
INSERT INTO `calle` VALUES (1,NULL,1,'Ramon Falcon',6800,7500,1408,1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL);
/*!40000 ALTER TABLE `calle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_iibb`
--

DROP TABLE IF EXISTS `categorias_iibb`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_iibb` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `impuesto` decimal(16,2) DEFAULT NULL,
  `anual` decimal(16,2) DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_iibb`
--

LOCK TABLES `categorias_iibb` WRITE;
/*!40000 ALTER TABLE `categorias_iibb` DISABLE KEYS */;
INSERT INTO `categorias_iibb` VALUES (1,'A',1045.00,6270.00,208739.25,30,3300,NULL,'1',NULL,NULL,NULL),(2,'B',1565.00,9390.00,313108.87,45,5000,NULL,'1',NULL,NULL,NULL),(3,'C',2090.00,12540.00,417478.51,60,6700,NULL,'1',NULL,NULL,NULL),(4,'D',3130.00,18780.00,626217.78,85,10000,NULL,'1',NULL,NULL,NULL),(5,'E',4175.00,25050.00,834957.00,110,13000,NULL,'1',NULL,NULL,NULL),(6,'F',5220.00,31320.00,1043696.27,150,16500,NULL,'1',NULL,NULL,NULL),(7,'G',6260.00,37560.00,1252435.53,200,20000,NULL,'1',NULL,NULL,NULL),(8,'H',8700.00,52200.00,1739493.79,200,20000,NULL,'1',NULL,NULL,NULL);
/*!40000 ALTER TABLE `categorias_iibb` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_monotributo`
--

DROP TABLE IF EXISTS `categorias_monotributo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_monotributo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `facMensual` decimal(16,2) DEFAULT NULL,
  `actividad` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `empleados` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `alquileres` decimal(16,2) DEFAULT NULL,
  `impuesto_servicio` decimal(16,2) DEFAULT NULL,
  `impuesto_venta` decimal(16,2) DEFAULT NULL,
  `sipa` decimal(16,2) DEFAULT NULL,
  `obraSocial` decimal(16,2) DEFAULT NULL,
  `totalServicio` decimal(16,2) DEFAULT NULL,
  `totalVenta` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `desde` date DEFAULT NULL,
  `hasta` date DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_monotributo`
--

LOCK TABLES `categorias_monotributo` WRITE;
/*!40000 ALTER TABLE `categorias_monotributo` DISABLE KEYS */;
INSERT INTO `categorias_monotributo` VALUES (1,'A',748382.07,62365.17,'No Excluida','0',30,3330,133455.58,288.07,288.07,1270.99,1775.18,3334.24,3334.24,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(2,'B',1112459.83,92704.99,'No Excluida','0',45,5000,133455.58,555.02,555.02,1398.09,1775.18,3728.29,3728.29,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(3,'C',1557443.75,129786.98,'No Excluida','0',60,6700,266911.14,949.02,876.97,1537.91,1775.18,4262.11,4190.06,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(4,'D',1934273.04,161189.42,'No Excluida','0',85,10000,266911.14,1559.09,1440.47,1691.69,1775.18,5025.96,4907.34,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(5,'E',2277684.56,189807.05,'No Excluida','0',110,13000,332579.74,2965.66,2300.50,1860.87,1775.18,6601.71,5936.55,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(6,'F',2847105.70,237258.81,'No Excluida','0',150,16500,333638.90,4079.93,3003.79,2046.95,1775.18,7902.06,6825.92,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(7,'G',3416526.83,284710.57,'No Excluida','0',200,20000,400366.71,5189.94,3745.19,2251.64,1775.18,9216.76,7772.01,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(8,'H',4229985.60,352498.80,'No Excluida','0',200,20000,533822.27,11862.69,9193.62,2476.80,1775.18,16114.68,13445.60,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(9,'I',4734330.03,394527.50,'Venta de Bs Muebles','0',200,20000,533822.27,NULL,14828.38,2724.49,1775.18,NULL,19328.05,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(10,'J',5425770.00,452147.50,'Venta de Bs Muebles','0',200,20000,533822.27,NULL,17425.48,2996.96,1775.18,NULL,22197.62,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(11,'K',6019594.89,501632.91,'Venta de Bs Muebles','0',200,20000,533822.27,NULL,20018.33,3296.62,1775.18,NULL,25090.13,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(12,'Monotributo Social',208739.25,17394.94,'No Excluida','0',0,0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,NULL,'2018-01-01',NULL,'1','2020-02-27 02:46:40','2020-02-27 02:46:40',NULL);
/*!40000 ALTER TABLE `categorias_monotributo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `charlas_details`
--

DROP TABLE IF EXISTS `charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `charla` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `charlas_details`
--

LOCK TABLES `charlas_details` WRITE;
/*!40000 ALTER TABLE `charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `charlas_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `CharlaDetail_BD` BEFORE DELETE ON `charlas_details` FOR EACH ROW insert into back_up_charlas_details (charla,person_id,modificado)
values(old.charla,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `claves`
--

DROP TABLE IF EXISTS `claves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves`
--

LOCK TABLES `claves` WRITE;
/*!40000 ALTER TABLE `claves` DISABLE KEYS */;
INSERT INTO `claves` VALUES (1,'Clave Fiscal',NULL,NULL),(2,'Clave Ciudad',NULL,NULL),(3,'Clave ARBA',NULL,NULL),(4,'Clave ANSES',NULL,NULL),(5,'Catedral',NULL,NULL),(6,'CEMIBA',NULL,NULL),(7,'COMPRA ARG',NULL,NULL),(8,'Consejo Ciencias Economicas',NULL,NULL),(9,'Correo',NULL,NULL),(10,'CUR',NULL,NULL),(11,'Firma Digital',NULL,NULL),(12,'Interbanking',NULL,NULL),(13,'Banco Citibank',NULL,NULL),(14,'Banco Ciudad',NULL,NULL),(15,'Banco Frances',NULL,NULL),(16,'Banco Galicia',NULL,NULL),(17,'Banco HSBC',NULL,NULL),(18,'Banco Itau',NULL,NULL),(19,'Banco Nacion',NULL,NULL),(20,'Banco Macro',NULL,NULL),(21,'Banco Patagonia',NULL,NULL),(22,'Banco Provincia',NULL,NULL),(23,'Banco Santander',NULL,NULL),(24,'Banco Supervielle',NULL,NULL),(25,'Seguridad e Higiene',NULL,NULL),(26,'Sindicato - ANSES',NULL,NULL),(27,'Sindicato - AOT',NULL,NULL),(28,'Sindicato - ATSA',NULL,NULL),(29,'Sindicato - Camioneros',NULL,NULL),(30,'Sindicato - Guinchero',NULL,NULL),(31,'Sindicato - IERIC',NULL,NULL),(32,'Sindicato - La Estrella',NULL,NULL),(33,'Sindicato - Nemesis',NULL,NULL),(34,'Sindicato - Pasta',NULL,NULL),(35,'Sindicato - SEC',NULL,NULL),(36,'Sindicato - SICOP',NULL,NULL),(37,'Sindicato - SOCAYA',NULL,NULL),(38,'Sindicato - UTHGRA',NULL,NULL),(39,'Sindicato - INACAP',NULL,NULL),(40,'Sindicato - Otro',NULL,NULL),(41,'Otra',NULL,NULL),(42,'Prisma - Firma Digital',NULL,NULL),(43,'Sindicato - FATSA',NULL,NULL);
/*!40000 ALTER TABLE `claves` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claves_details`
--

DROP TABLE IF EXISTS `claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `claves_details_clave_id_foreign` (`clave_id`),
  KEY `claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_details`
--

LOCK TABLES `claves_details` WRITE;
/*!40000 ALTER TABLE `claves_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `claves_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `ClavesDetail_BD` BEFORE DELETE ON `claves_details` FOR EACH ROW insert into back_up_claves_details (clave,valor,comentario,clave_id,person_id,modificado)
values(old.clave,old.valor,old.comentario,old.clave_id,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `claves_mails`
--

DROP TABLE IF EXISTS `claves_mails`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_mails` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_mails`
--

LOCK TABLES `claves_mails` WRITE;
/*!40000 ALTER TABLE `claves_mails` DISABLE KEYS */;
INSERT INTO `claves_mails` VALUES (1,'Listado de Claves',1,'Claves','claves_mails/claves_listado',NULL,NULL),(3,'Listado de Mails',2,'Mails','claves_mails/mails_listado',NULL,NULL),(5,'Listado de Charlas',3,'Charlas','claves_mails/charlas_listado',NULL,NULL);
/*!40000 ALTER TABLE `claves_mails` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cm_articulos_regimenes`
--

DROP TABLE IF EXISTS `cm_articulos_regimenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cm_articulos_regimenes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `codigo` int(11) DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cm_articulos_regimenes`
--

LOCK TABLES `cm_articulos_regimenes` WRITE;
/*!40000 ALTER TABLE `cm_articulos_regimenes` DISABLE KEYS */;
INSERT INTO `cm_articulos_regimenes` VALUES (1,NULL,'Articulo 2',2,1,'2021-07-26 03:45:19','2021-07-29 08:41:19',NULL),(2,NULL,'Articulo 6',6,0,'2021-07-26 03:45:19','2021-07-29 08:41:19',NULL),(3,NULL,'Articulo 7',7,0,'2021-07-26 03:45:19','2021-07-29 08:41:19',NULL),(4,NULL,'Articulo 8',8,0,'2021-07-26 03:45:19','2021-07-29 08:41:19',NULL),(5,NULL,'Articulo 9',9,0,'2021-07-26 03:45:19','2021-07-29 08:41:19',NULL),(6,NULL,'Articulo 10',10,0,'2021-07-26 03:45:19','2021-07-29 08:41:19',NULL),(7,NULL,'Articulo 11',11,0,'2021-07-26 03:45:19','2021-07-29 08:41:19',NULL),(8,NULL,'Articulo 12',12,0,'2021-07-26 03:45:19','2021-07-29 08:41:19',NULL),(9,NULL,'Articulo 13',13,0,'2021-07-26 03:45:19','2021-07-29 08:41:19',NULL),(10,NULL,'Articulo 14',14,1,'2021-07-26 03:45:19','2021-07-29 08:41:19',NULL);
/*!40000 ALTER TABLE `cm_articulos_regimenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condicion_frente_al_iva`
--

DROP TABLE IF EXISTS `condicion_frente_al_iva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condicion_frente_al_iva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `codigo_afip` int(11) DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `show_comprobantes_a` tinyint(1) NOT NULL DEFAULT '0',
  `show_comprobantes_b` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condicion_frente_al_iva`
--

LOCK TABLES `condicion_frente_al_iva` WRITE;
/*!40000 ALTER TABLE `condicion_frente_al_iva` DISABLE KEYS */;
INSERT INTO `condicion_frente_al_iva` VALUES (1,NULL,1,'IVA Responsable Inscripto',1,0,1,NULL,NULL,NULL),(2,NULL,2,'IVA Responsable no Inscripto',0,0,1,NULL,NULL,NULL),(3,NULL,3,'IVA no Responsable',0,0,1,NULL,NULL,NULL),(4,NULL,4,'IVA Sujeto Exento',0,1,1,NULL,NULL,NULL),(5,NULL,5,'Consumidor Final',0,1,1,NULL,NULL,NULL),(6,NULL,6,'Responsable Monotributo',1,0,1,NULL,NULL,NULL),(7,NULL,7,'Sujeto no Categorizado',0,1,1,NULL,NULL,NULL),(8,NULL,8,'Proveedor del Exterior',0,1,1,NULL,NULL,NULL),(9,NULL,9,'Cliente del Exterior',0,1,1,NULL,NULL,NULL),(10,NULL,10,'IVA Liberado – Ley Nº 19.640',0,1,1,NULL,NULL,NULL),(11,NULL,11,'IVA Responsable Inscripto – Agente de Percepción',0,0,1,NULL,NULL,NULL),(12,NULL,12,'Pequeño Contribuyente Eventual',0,0,1,NULL,NULL,NULL),(13,NULL,13,'Monotributista Social',1,0,1,NULL,NULL,NULL),(14,NULL,14,'Pequeño Contribuyente Eventual Social',0,0,1,NULL,NULL,NULL),(15,NULL,NULL,'Monotributista Trabajador Independiente Promovido',1,0,1,NULL,NULL,NULL),(16,NULL,NULL,'IVA No Alcanzado',0,1,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `condicion_frente_al_iva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condiciones_venta`
--

DROP TABLE IF EXISTS `condiciones_venta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condiciones_venta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condiciones_venta`
--

LOCK TABLES `condiciones_venta` WRITE;
/*!40000 ALTER TABLE `condiciones_venta` DISABLE KEYS */;
INSERT INTO `condiciones_venta` VALUES (1,'Contado',NULL,NULL),(2,'Tarjeta de Debito',NULL,NULL),(3,'Tarjeta de Credito',NULL,NULL),(4,'Cuenta Corriente',NULL,NULL),(5,'Cheque',NULL,NULL),(6,'Ticket',NULL,NULL),(7,'Transferencia',NULL,NULL),(8,'Otra',NULL,NULL);
/*!40000 ALTER TABLE `condiciones_venta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consultas`
--

DROP TABLE IF EXISTS `consultas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consultas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consultas`
--

LOCK TABLES `consultas` WRITE;
/*!40000 ALTER TABLE `consultas` DISABLE KEYS */;
INSERT INTO `consultas` VALUES (1,NULL,'Estado Liquidaciones',1,NULL,NULL,NULL),(2,NULL,'Consumo',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `consultas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consultas_aux`
--

DROP TABLE IF EXISTS `consultas_aux`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consultas_aux` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `consulta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `estado` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `consultas_aux_consulta_id_foreign` (`consulta_id`),
  KEY `consultas_aux_person_id_foreign` (`person_id`),
  CONSTRAINT `consultas_aux_consulta_id_foreign` FOREIGN KEY (`consulta_id`) REFERENCES `consultas` (`id`),
  CONSTRAINT `consultas_aux_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consultas_aux`
--

LOCK TABLES `consultas_aux` WRITE;
/*!40000 ALTER TABLE `consultas_aux` DISABLE KEYS */;
/*!40000 ALTER TABLE `consultas_aux` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_asientos`
--

DROP TABLE IF EXISTS `conta_asientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_asientos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `debe_cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `haber_cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `ctactecheque_id` int(10) unsigned DEFAULT NULL,
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `adjunto` text COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `radioChecked` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `CuentaTipo_id` int(10) unsigned DEFAULT NULL,
  `CentroCosto_id` int(10) unsigned DEFAULT NULL,
  `pagado` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_asientos_person_id_foreign` (`person_id`),
  KEY `conta_asientos_period_id_foreign` (`period_id`),
  KEY `conta_asientos_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `conta_asientos_cuentatipo_id_foreign` (`CuentaTipo_id`),
  KEY `conta_asientos_centrocosto_id_foreign` (`CentroCosto_id`),
  KEY `conta_asientos_ctactecheque_id_foreign` (`ctactecheque_id`),
  KEY `conta_asientos_haber_cta_cte_tesoreria_cuenta_id_foreign` (`haber_cta_cte_tesoreria_cuenta_id`),
  KEY `conta_asientos_debe_cta_cte_tesoreria_cuenta_id_foreign` (`debe_cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `conta_asientos_centrocosto_id_foreign` FOREIGN KEY (`CentroCosto_id`) REFERENCES `ctactegastos_centrocosto` (`id`),
  CONSTRAINT `conta_asientos_ctactecheque_id_foreign` FOREIGN KEY (`ctactecheque_id`) REFERENCES `ctacte_cheques` (`id`),
  CONSTRAINT `conta_asientos_cuentatipo_id_foreign` FOREIGN KEY (`CuentaTipo_id`) REFERENCES `ctactegastos_cuenta_tipo` (`idCuentaTipo`),
  CONSTRAINT `conta_asientos_debe_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`debe_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_haber_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`haber_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `conta_asientos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `conta_asientos_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_asientos`
--

LOCK TABLES `conta_asientos` WRITE;
/*!40000 ALTER TABLE `conta_asientos` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_asientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_asientos_details`
--

DROP TABLE IF EXISTS `conta_asientos_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_asientos_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_asientos_details_conta_asiento_id_foreign` (`conta_asiento_id`),
  KEY `conta_asientos_details_person_id_foreign` (`person_id`),
  KEY `conta_asientos_details_period_id_foreign` (`period_id`),
  KEY `conta_asientos_details_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `conta_asientos_details_saldo_id_foreign` (`saldo_id`),
  KEY `conta_asientos_details_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `conta_asientos_details_conta_asiento_id_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `conta_asientos_details_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `conta_asientos_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `conta_asientos_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `conta_asientos_details_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_asientos_details`
--

LOCK TABLES `conta_asientos_details` WRITE;
/*!40000 ALTER TABLE `conta_asientos_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_asientos_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_centro_costo_plan_cuenta`
--

DROP TABLE IF EXISTS `conta_centro_costo_plan_cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_centro_costo_plan_cuenta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_centro_costo_id` bigint(20) unsigned DEFAULT NULL,
  `conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_centro_costo_plan_cuenta_conta_centro_costo_id_foreign` (`conta_centro_costo_id`),
  KEY `conta_centro_costo_plan_cuenta_conta_plan_cuenta_id_foreign` (`conta_plan_cuenta_id`),
  CONSTRAINT `conta_centro_costo_plan_cuenta_conta_centro_costo_id_foreign` FOREIGN KEY (`conta_centro_costo_id`) REFERENCES `conta_centro_costos` (`id`),
  CONSTRAINT `conta_centro_costo_plan_cuenta_conta_plan_cuenta_id_foreign` FOREIGN KEY (`conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_centro_costo_plan_cuenta`
--

LOCK TABLES `conta_centro_costo_plan_cuenta` WRITE;
/*!40000 ALTER TABLE `conta_centro_costo_plan_cuenta` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_centro_costo_plan_cuenta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_centro_costos`
--

DROP TABLE IF EXISTS `conta_centro_costos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_centro_costos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_centro_costos_person_id_foreign` (`person_id`),
  CONSTRAINT `conta_centro_costos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_centro_costos`
--

LOCK TABLES `conta_centro_costos` WRITE;
/*!40000 ALTER TABLE `conta_centro_costos` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_centro_costos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_plan_cuenta`
--

DROP TABLE IF EXISTS `conta_plan_cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_plan_cuenta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `codigo` int(11) NOT NULL,
  `tipo_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `padre` int(11) NOT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rubro` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `no_editable` int(11) NOT NULL DEFAULT '1',
  `tes_cta_cte` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_origen` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_destino` tinyint(1) NOT NULL DEFAULT '0',
  `conta_asientos` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_plan_cuenta_tipo_cuenta_id_foreign` (`tipo_cuenta_id`),
  KEY `conta_plan_cuenta_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `conta_plan_cuenta_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `conta_plan_cuenta_tipo_cuenta_id_foreign` FOREIGN KEY (`tipo_cuenta_id`) REFERENCES `conta_tipo_cuentas` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=482 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_plan_cuenta`
--

LOCK TABLES `conta_plan_cuenta` WRITE;
/*!40000 ALTER TABLE `conta_plan_cuenta` DISABLE KEYS */;
INSERT INTO `conta_plan_cuenta` VALUES (1,NULL,1000000,1,1,0,'ACTIVO','Activo',NULL,1,1,0,0,0,0,NULL),(2,NULL,1100000,2,1,1000000,'ACTIVO CORRIENTE','Activo',NULL,1,1,0,0,0,0,NULL),(3,NULL,1110000,3,1,1100000,'CAJA Y BANCOS','Activo',NULL,1,1,0,0,0,0,NULL),(4,NULL,1110100,4,1,1110000,'CAJAS','Activo',NULL,1,1,0,0,0,0,NULL),(5,NULL,1110101,5,1,1110100,'Caja Oficina','Activo',NULL,0,1,0,0,0,0,NULL),(6,NULL,1110102,5,1,1110100,'Caja Casa','Activo',NULL,0,1,0,0,0,0,NULL),(7,NULL,1110103,5,1,1110100,'Caja Dolares Casa','Activo',NULL,0,1,0,0,0,0,NULL),(8,NULL,1110104,5,1,1110100,'Banco Santander 015-372795/5','Activo',NULL,0,1,0,0,0,0,NULL),(9,NULL,1110200,4,1,1110000,'BANCOS','Activo',NULL,1,1,0,0,0,0,NULL),(10,NULL,1110201,5,1,1110200,'Banco Santander Rio Cta Corriente','Activo',NULL,1,2,1,1,1,0,NULL),(11,NULL,1110202,5,1,1110200,'Banco Santander Rio Cta Corriente DOLARES','Activo',NULL,1,2,1,1,1,0,NULL),(12,NULL,1130000,3,1,1100000,'CREDITOS POR VENTAS','Activo',NULL,1,1,0,0,0,0,NULL),(13,NULL,1130101,5,1,1130100,'Clientes - Deudores','Activo',NULL,1,2,0,0,0,1,NULL),(14,NULL,1130102,5,1,1130100,'Deudores por ventas comunes','Activo',NULL,1,1,0,0,0,1,NULL),(15,NULL,1130103,5,1,1130100,'Deudores por ventas morosos','Activo',NULL,1,1,0,0,0,1,NULL),(16,NULL,1130104,5,1,1130100,'Deudores en gestión judicial','Activo',NULL,1,1,0,0,0,1,NULL),(17,NULL,1130105,5,1,1130100,'Previsión deudores incobrables','Activo',NULL,1,1,0,0,0,1,NULL),(18,NULL,1140000,3,1,1100000,'OTROS CREDITOS','Activo',NULL,1,1,0,0,0,0,NULL),(19,NULL,1140100,4,1,1140000,'Retenciones Sufridas','Activo',NULL,1,1,0,0,0,0,NULL),(20,NULL,1140301,5,1,1140300,'Anticipos Impuesto a las Ganancias','Activo',NULL,1,2,0,0,1,1,NULL),(21,NULL,1140102,5,1,1140100,'Retenciones Ingr. Brutos','Activo',NULL,0,1,0,0,0,0,NULL),(22,NULL,1140329,5,1,1140300,'Anticipo Impto.Ganancia Mínima Presunta','Activo',NULL,1,1,0,0,0,1,NULL),(23,NULL,1140105,5,1,1140100,'Retenciones Impuesto a las Ganancias','Activo',NULL,1,2,1,0,0,1,NULL),(24,NULL,1140106,5,1,1140100,'Impuesto a las Ganancias (Saldo a favor)','Activo',NULL,1,1,0,0,0,1,NULL),(25,NULL,1140107,5,1,1140100,'Retenciones de IVA','Activo',NULL,1,2,1,0,0,1,NULL),(26,NULL,1140200,4,1,1140000,'CREDITOS DIVERSOS','Activo',NULL,1,1,0,0,0,0,NULL),(27,NULL,1140201,5,1,1140200,'Anticipos de proveedores','Activo',NULL,1,1,0,0,0,1,NULL),(28,NULL,1140205,5,1,1140200,'Depósito en garantía alquileres','Activo',NULL,1,1,0,0,0,1,NULL),(29,NULL,1140206,5,1,1140200,'Derechos adquiridos a devengar','Activo',NULL,1,1,0,0,0,1,NULL),(30,NULL,1140207,5,1,1140200,'Intereses a devengar','Activo',NULL,1,1,0,0,0,1,NULL),(31,NULL,1140208,5,1,1140200,'Cuentas a rendir - Directores','Activo',NULL,1,1,0,0,0,1,NULL),(32,NULL,1140210,5,1,1140200,'Alquileres no devengados','Activo',NULL,1,1,0,0,0,1,NULL),(33,NULL,1150000,3,1,1100000,'BIENES DE CAMBIO','Activo',NULL,1,1,0,0,0,0,NULL),(34,NULL,1150400,4,1,1150000,'MERCADERIA DE REVENTA','Activo',NULL,1,1,0,0,0,0,NULL),(35,NULL,1200000,2,1,1000000,'ACTIVO NO CORRIENTE','Activo',NULL,1,1,0,0,0,0,NULL),(36,NULL,1220000,3,1,1200000,'BIENES DE USO','Activo',NULL,1,1,0,0,0,0,NULL),(37,NULL,1220100,4,1,1220000,'EQUIPOS DE COMPUTACION','Activo',NULL,1,1,0,0,0,0,NULL),(38,NULL,1220101,5,1,1220100,'Equipos de computación valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(39,NULL,1220102,5,1,1220100,'Equipos de computación ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(40,NULL,1220108,5,1,1220100,'Amortización Acumulada Equipos de comput.','Activo',NULL,1,1,0,0,0,1,NULL),(41,NULL,1220200,4,1,1220000,'INSTALACIONES','Activo',NULL,1,1,0,0,0,0,NULL),(42,NULL,1220201,5,1,1220200,'Instalaciones valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(43,NULL,1220202,5,1,1220200,'Instalaciones ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(44,NULL,1220206,5,1,1220200,'Amortización Acumulada Instalaciones','Activo',NULL,1,1,0,0,0,1,NULL),(45,NULL,1220300,4,1,1220000,'MUEBLES Y UTILES','Activo',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (46,NULL,1220301,5,1,1220300,'Muebles y utiles valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(47,NULL,1220302,5,1,1220300,'Muebles y utiles ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(48,NULL,1220306,5,1,1220300,'Amortización Acumulada Muebles y Útiles','Activo',NULL,1,1,0,0,0,1,NULL),(49,NULL,1230000,3,1,1200000,'ACTIVOS INTANGIBLES','Activo',NULL,1,1,0,0,0,0,NULL),(50,NULL,1230101,5,1,1230100,'Gastos de organización valores historicos','Activo',NULL,1,1,0,0,0,1,NULL),(51,NULL,1230102,5,1,1230100,'Gastos de organización ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(52,NULL,1230103,5,1,1230100,'Amortización acumulada gs. de organización','Activo',NULL,1,1,0,0,0,1,NULL),(53,NULL,2000000,1,2,0,'PASIVO','Pasivo',NULL,1,1,0,0,0,0,NULL),(54,NULL,2100000,2,2,2000000,'PASIVO CORRIENTE','Pasivo',NULL,1,1,0,0,0,0,NULL),(55,NULL,2110000,3,2,2100000,'Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(56,NULL,2110100,4,2,2110000,'Comerciales','Pasivo',NULL,1,1,0,0,0,0,NULL),(57,NULL,2110101,5,2,2110100,'Proveedores en Cta. Cte. locales','Pasivo',NULL,1,2,0,0,0,1,NULL),(58,NULL,2110102,5,2,2110100,'Proveedores en cta. cte. exterior','Pasivo',NULL,1,1,0,0,0,1,NULL),(59,NULL,2110103,5,2,2110100,'Derechos de exhibición a devengar','Pasivo',NULL,1,1,0,0,0,1,NULL),(60,NULL,2110104,5,2,2110100,'Cheques emitidos ','Pasivo',NULL,1,2,1,1,1,1,NULL),(61,NULL,2110200,4,2,2110000,'REMUNERACIONES Y CARGAS SOCIALES','Pasivo',NULL,1,1,0,0,0,0,NULL),(62,NULL,2110201,5,2,2110200,'Sueldos y Jornales a pagar','Pasivo',NULL,1,2,0,0,1,1,NULL),(63,NULL,2110202,5,2,2110200,'Cargas sociales a pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(64,NULL,2110203,5,2,2110200,'Sindicatos a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(65,NULL,2110300,4,2,2110000,'CARGAS FISCALES','Pasivo',NULL,1,1,0,0,0,0,NULL),(67,NULL,2110301,5,2,2110300,'IVA Debito Fiscal','Pasivo',NULL,1,2,0,0,0,1,NULL),(68,NULL,1140222,5,1,1140200,'IVA Credito Fiscal','Activo',NULL,1,2,0,0,0,1,NULL),(69,NULL,2110303,5,2,2110300,'Impuestos Internos','Pasivo',NULL,1,1,0,0,0,1,NULL),(70,NULL,2110304,5,2,2110300,'Impuestos al Combustible','Pasivo',NULL,1,1,0,0,0,1,NULL),(71,NULL,2110601,5,2,2110600,'IVA Retenciones de terceros','Pasivo',NULL,1,1,0,0,0,1,NULL),(72,NULL,2110306,5,2,2110300,'IVA Percepciones realiz.por terceros','Pasivo',NULL,1,2,0,0,0,1,NULL),(73,NULL,2110307,5,2,2110300,'IVA Saldo a favor','Pasivo',NULL,1,1,0,0,0,1,NULL),(74,NULL,2110308,5,2,2110300,'IVA a pagar','Pasivo',NULL,1,2,0,0,0,1,NULL),(75,NULL,2110309,5,2,2110300,'Percepciones Ingresos Brutos','Pasivo',NULL,1,1,0,0,0,1,NULL),(76,NULL,2110310,5,2,2110300,'Otros Pagos AFIP','Pasivo',NULL,1,1,0,0,0,1,NULL),(78,NULL,2110350,5,2,2110300,'Impuesto a los Ingresos Brutos Pasivo','Pasivo',NULL,1,1,0,0,0,1,NULL),(79,NULL,2110313,5,2,2110300,'Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(80,NULL,2110314,5,2,2110300,'Impuesto a la Ganancia Mínima Presunta','Pasivo',NULL,1,1,0,0,0,1,NULL),(81,NULL,2110602,5,2,2110600,'AFIP - Retenciones Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(82,NULL,2110316,5,2,2110300,'AFIP - Plan de Facilidades Decreto 338/02','Pasivo',NULL,1,1,0,0,0,1,NULL),(83,NULL,2200000,2,2,2000000,'PASIVO NO CORRIENTE','Pasivo',NULL,1,1,0,0,0,0,NULL),(84,NULL,3000000,1,2,0,'PATRIMONIO NETO','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(85,NULL,3100000,2,2,3000000,'APORTE DE LOS PROPIETARIOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(86,NULL,3110100,4,2,3110000,'CAPITAL SOCIAL','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(87,NULL,3110101,5,2,3110100,'Acciones en circulación','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(88,NULL,3110102,5,2,3110100,'Ajuste del Capital','Patrimonio Neto',NULL,1,2,0,0,0,1,NULL),(89,NULL,3110103,5,2,3110100,'Aportes Irrevocables Futuras Suscripciones','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(90,NULL,3400000,2,2,3000000,'RESULTADOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(91,NULL,3410101,5,2,3410100,'Resultado del ejercicio','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (92,NULL,3410102,5,2,3410100,'Resultado ejercicios anteriores','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(93,NULL,3410103,5,2,3410100,'A.R.E.A.','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(94,NULL,4000000,1,2,0,'INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(95,NULL,4100000,2,2,4000000,'INGRESOS ORDINARIOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(96,NULL,4110101,5,2,4110100,'VENTAS','Result. Positivo',NULL,1,2,0,0,0,1,NULL),(97,NULL,4110102,5,2,4110100,'Honorarios','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(98,NULL,4110103,5,2,4110100,'Sueldo Vane','Result. Positivo',NULL,0,1,0,0,0,0,NULL),(99,NULL,4110104,5,2,4110100,'Descuentos obtenidos','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(100,NULL,4110105,5,2,4110100,'Reintegros por exportaciones','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(101,NULL,4120000,3,2,4100000,'OTROS INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(102,NULL,4120101,5,2,4120100,'Intereses Cobrados','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(103,NULL,4120102,5,2,4120100,'Diferencias de cambio','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(104,NULL,4120103,5,2,4120100,'Descuentos obtenidos','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(107,NULL,5000000,1,1,0,'GASTOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(108,NULL,5100000,2,1,5000000,'GASTOS ORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(109,NULL,5110100,4,1,5110000,'ASIENTO DE SUELDO','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(110,NULL,5110101,5,1,5110100,'Sueldos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(111,NULL,5110102,5,1,5110100,'Contribuciones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(112,NULL,5110103,5,1,5110100,'Sindicato','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(113,NULL,5120100,4,1,5120000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(114,NULL,5120101,5,1,5120100,'ACA','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(115,NULL,5120102,5,1,5120100,'Aereos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(116,NULL,5120103,5,1,5120100,'Alquiler','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(117,NULL,5120104,5,1,5120100,'AGUA AYSA','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(118,NULL,5120105,5,1,5120100,'TV Cablevision','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(119,NULL,5120106,5,1,5120100,'Caja Jubilacion Consejo','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(120,NULL,5120107,5,1,5120100,'Celulares','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(121,NULL,5120108,5,1,5120100,'Cheques','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(122,NULL,5120109,5,1,5120100,'Club la Nacion','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(123,NULL,5120110,5,1,5120100,'Comida','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(124,NULL,5120111,5,1,5120100,'Diario Clarin','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(125,NULL,5120112,5,1,5120100,'Digital Ocean','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(126,NULL,5120113,5,1,5120100,'Fletes y acarreos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(127,NULL,5120114,5,1,5120100,'Luz Edesur','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(128,NULL,5120115,5,1,5120100,'Movilidad y Viáticos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(129,NULL,5120116,5,1,5120100,'Mantenimiento','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(130,NULL,5120117,5,1,5120100,'IVA No Computable','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(131,NULL,5120118,5,1,5120100,'Entretenimiento','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(132,NULL,5120119,5,1,5120100,'Amortización Bienes de Uso','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(133,NULL,5120120,5,1,5120100,'Errepar','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(134,NULL,5120121,5,1,5120100,'Hosting Página Web To Webs','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(135,NULL,5120122,5,1,5120100,'Gastos varios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(136,NULL,5120123,5,1,5120100,'Ajuste por redondeo','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(137,NULL,5120124,5,1,5120100,'Deudores Incobrables','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(138,NULL,5120125,5,1,5120100,'Faby Goncalves','Result. Negativo',NULL,0,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (139,NULL,5130100,4,1,5130000,'GASTOS FINANCIEROS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(140,NULL,5130101,5,1,5130100,'Intereses y Gastos bancarios','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(141,NULL,5130102,5,1,5130100,'Intereses Proveedores','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(142,NULL,5130103,5,1,5130100,'Damian Financiera','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(143,NULL,5130104,5,1,5130100,'Diferencias de cambio','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(144,NULL,5130105,5,1,5130100,'Diferencia de Cambio Bces. en M.Extranjera','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(145,NULL,5130106,5,1,5130100,'Diferencia tipo cambio Vendedor/Comprador','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(146,NULL,5130107,5,1,5130100,'Diferencia por conversion en Bce. en Mon. Extranj.','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(147,NULL,5130108,5,1,5130100,'Diferencia de cambio CMV','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(148,NULL,5130109,5,1,5130100,'Diferencia de cambio PT','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(149,NULL,5130110,5,1,5130100,'Resultado por Exposición a la Inflación','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(150,NULL,5130111,5,1,5130100,'Diferencia de cambio PE','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(151,NULL,5130112,5,1,5130100,'Diferencia de cambio Ds.Vtas.','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(152,NULL,5130113,5,1,5130100,'Diferencia de cambio ME','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(153,NULL,5130114,5,1,5130100,'Descuentos otorgados','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(154,NULL,5140100,4,1,5140000,'IMPUESTOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(155,NULL,5140101,5,1,5140100,'Impuesto a las Ganancias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(156,NULL,5140164,5,1,5140100,'Impuesto a los Ingresos Brutos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(157,NULL,5140102,5,1,5140100,'Impuesto al Debito y Credito Bancario','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(158,NULL,5200000,2,1,5000000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(159,NULL,5210101,5,1,5210100,'Pérdida por venta bienes de uso','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(160,NULL,5210102,5,1,5210100,'Inversiones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(161,NULL,5210103,5,1,5210100,'Amortizaciones extraordinarias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(162,NULL,1140103,5,1,1140100,'Retenciones SUSS','Activo',NULL,1,2,1,0,0,1,NULL),(163,NULL,1110122,5,1,1110100,'Banco Patagonia Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(164,NULL,1110106,5,1,1110100,'Banco HSBC','Activo',NULL,0,1,0,0,0,0,NULL),(165,NULL,1110123,5,1,1110100,'Banco Ciudad Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(166,NULL,1110124,5,1,1110100,'Banco Nacion Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(167,NULL,1110109,5,1,1110100,'Banco Galicia Vane','Activo',NULL,0,1,0,0,0,0,NULL),(168,NULL,1110110,5,1,1110100,'Banco Frances Vane','Activo',NULL,0,1,0,0,0,0,NULL),(169,NULL,1110111,5,1,1110100,'Banco Patagonia In Time SRL','Activo',NULL,0,1,0,0,0,0,NULL),(170,NULL,1110112,5,1,1110100,'Banco Ciudad In Time SRL','Activo',NULL,0,1,0,0,0,0,NULL),(171,NULL,1110113,5,1,1110100,'Banco Provincia In Time SRL','Activo',NULL,0,1,0,0,0,0,NULL),(172,NULL,1110114,5,1,1110100,'Banco Macro PedimeOnline','Activo',NULL,0,1,0,0,0,0,NULL),(173,NULL,1110115,5,1,1110100,'Banco Patagonia Problema Resuelto','Activo',NULL,0,1,0,0,0,0,NULL),(174,NULL,1110116,5,1,1110100,'Banco Patagonia Graciela','Activo',NULL,0,1,0,0,0,0,NULL),(175,NULL,1110117,5,1,1110100,'Banco Patagonia Omar','Activo',NULL,0,1,0,0,0,0,NULL),(176,NULL,1110118,5,1,1110100,'Cheques','Activo',NULL,1,2,1,1,1,0,NULL),(177,NULL,5120126,5,1,5120100,'Gisela Larzabal','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(178,NULL,5120127,5,1,5120100,'Google','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(179,NULL,5120128,5,1,5120100,'Seguro Moto','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(180,NULL,5120129,5,1,5120100,'Sueldo Agustina','Result. Negativo',NULL,0,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (181,NULL,5120130,5,1,5120100,'Sueldo Betty','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(182,NULL,5120131,5,1,5120100,'Sueldo Elizabet','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(183,NULL,5120132,5,1,5120100,'Sueldo Florencia','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(184,NULL,5120133,5,1,5120100,'Sueldo Graciela','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(185,NULL,5120134,5,1,5120100,'Sueldo Franco Sanchez','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(186,NULL,5120135,5,1,5120100,'Sueldo Santiago Sanchez','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(187,NULL,5120136,5,1,5120100,'Sueldo Jose Luis','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(188,NULL,5120137,5,1,5120100,'Publicidad','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(189,NULL,5120138,5,1,5120100,'Las Nieves','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(190,NULL,5120139,5,1,5120100,'Sueldo Lidia','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(191,NULL,5120140,5,1,5120100,'Cargas Sociales','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(192,NULL,5120141,5,1,5120100,'Honorarios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(193,NULL,5120142,5,1,5120100,'Telefono Fijo','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(194,NULL,5120143,5,1,5120100,'ONE DRIVE','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(195,NULL,5120144,5,1,5120100,'OSDE','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(196,NULL,5120145,5,1,5120100,'SAS Constitucion','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(197,NULL,5120146,5,1,5120100,'Seguro de Vida Zurich','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(198,NULL,5120147,5,1,5120100,'Seguros','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(199,NULL,5120148,5,1,5120100,'Internet','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(200,NULL,5120149,5,1,5120100,'Seguro de Retiro Zurich','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(201,NULL,5140165,5,1,5140100,'Monotributo','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(202,NULL,5140104,5,1,5140100,'IVA In Time SRL','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(203,NULL,5140105,5,1,5140100,'Autonomos','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(204,NULL,5140106,5,1,5140100,'Multas Impositivas','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(207,NULL,5120150,5,1,5120100,'Vanesa Gastos','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(208,NULL,5140166,5,1,5140100,'Impuesto a los Ingresos Brutos - BS AS','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(209,NULL,5140107,5,1,5140100,'SIRCREB','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(210,NULL,5140108,5,1,5140100,'Consejo Ciencias Economicas','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(211,NULL,5120152,5,1,5120100,'Albano Andres','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(212,NULL,5120153,5,1,5120100,'Tarjeta Visa','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(213,NULL,5120154,5,1,5120100,'Tarjeta American Express','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(214,NULL,5120155,5,1,5120100,'Tarjeta Mastercard','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(215,NULL,5120156,5,1,5120100,'Tarjeta Shopping','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(216,NULL,5120157,5,1,5120100,'Tarjeta Cencosud','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(217,NULL,5120158,5,1,5120100,'Compras','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(218,NULL,4110106,5,2,4110100,'Ventas No Gravadas','Result. Positivo',NULL,1,2,0,0,0,1,NULL),(219,NULL,6110103,5,1,6110100,'Pagos AFIP','Movimiento',NULL,1,2,0,0,1,1,NULL),(220,NULL,5140167,5,1,5140100,'Perc IVA -RG3337','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(221,NULL,5140109,5,1,5140100,'Imps. Internos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(222,NULL,5140110,5,1,5140100,'Imp. Gasoil','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(223,NULL,5140111,5,1,5140100,'Imp. Hídricos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(224,NULL,5140112,5,1,5140100,'ITC','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(225,NULL,5140113,5,1,5140100,'Perc IIBB  Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(226,NULL,5140114,5,1,5140100,'Perc IIBB  Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (227,NULL,5140115,5,1,5140100,'Perc IIBB  Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(228,NULL,5140116,5,1,5140100,'Perc IIBB  Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(229,NULL,5140117,5,1,5140100,'Perc IIBB  Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(230,NULL,5140118,5,1,5140100,'Perc IIBB  Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(231,NULL,5140119,5,1,5140100,'Perc IIBB  Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(232,NULL,5140120,5,1,5140100,'Perc IIBB  Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(233,NULL,5140121,5,1,5140100,'Perc IIBB  Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(234,NULL,5140122,5,1,5140100,'Perc IIBB  Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(235,NULL,5140123,5,1,5140100,'Perc IIBB  La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(236,NULL,5140124,5,1,5140100,'Perc IIBB  La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(237,NULL,5140125,5,1,5140100,'Perc IIBB  Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(238,NULL,5140126,5,1,5140100,'Perc IIBB  Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(239,NULL,5140127,5,1,5140100,'Perc IIBB  Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(240,NULL,5140128,5,1,5140100,'Perc IIBB  Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(241,NULL,5140129,5,1,5140100,'Perc IIBB  Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(242,NULL,5140130,5,1,5140100,'Perc IIBB  Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(243,NULL,5140131,5,1,5140100,'Perc IIBB  San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(244,NULL,5140132,5,1,5140100,'Perc IIBB  San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(245,NULL,5140133,5,1,5140100,'Perc IIBB  Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(246,NULL,5140134,5,1,5140100,'Perc IIBB  Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(247,NULL,5140135,5,1,5140100,'Perc IIBB  Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(248,NULL,5140136,5,1,5140100,'Perc IIBB  Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(249,NULL,5140137,5,1,5140100,'Perc IIBB  Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(250,NULL,5140138,5,1,5140100,'Compras No Gravadas','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(251,NULL,1140108,5,1,1140100,'Retenciones de IIBB Buenos Aires','Activo',NULL,1,2,1,0,0,1,NULL),(252,NULL,1140109,5,1,1140100,'Retenciones de IIBB Capital Federal','Activo',NULL,1,2,1,0,0,1,NULL),(253,NULL,1140110,5,1,1140100,'Retenciones de IIBB Catamarca','Activo',NULL,1,2,1,0,0,1,NULL),(254,NULL,1140111,5,1,1140100,'Retenciones de IIBB Chaco','Activo',NULL,1,2,1,0,0,1,NULL),(255,NULL,1140112,5,1,1140100,'Retenciones de IIBB Chubut','Activo',NULL,1,2,1,0,0,1,NULL),(256,NULL,1140113,5,1,1140100,'Retenciones de IIBB Córdoba','Activo',NULL,1,2,1,0,0,1,NULL),(257,NULL,1140114,5,1,1140100,'Retenciones de IIBB Corrientes','Activo',NULL,1,2,1,0,0,1,NULL),(258,NULL,1140115,5,1,1140100,'Retenciones de IIBB Entre Ríos','Activo',NULL,1,2,1,0,0,1,NULL),(259,NULL,1140116,5,1,1140100,'Retenciones de IIBB Formosa','Activo',NULL,1,2,1,0,0,1,NULL),(260,NULL,1140117,5,1,1140100,'Retenciones de IIBB Jujuy','Activo',NULL,1,2,1,0,0,1,NULL),(261,NULL,1140118,5,1,1140100,'Retenciones de IIBB La Pampa','Activo',NULL,1,2,1,0,0,1,NULL),(262,NULL,1140119,5,1,1140100,'Retenciones de IIBB La Rioja','Activo',NULL,1,2,1,0,0,1,NULL),(263,NULL,1140120,5,1,1140100,'Retenciones de IIBB Mendoza','Activo',NULL,1,2,1,0,0,1,NULL),(264,NULL,1140121,5,1,1140100,'Retenciones de IIBB Misiones','Activo',NULL,1,2,1,0,0,1,NULL),(265,NULL,1140122,5,1,1140100,'Retenciones de IIBB Neuquén','Activo',NULL,1,2,1,0,0,1,NULL),(266,NULL,1140123,5,1,1140100,'Retenciones de IIBB Pascua Lama','Activo',NULL,1,2,1,0,0,1,NULL),(267,NULL,1140124,5,1,1140100,'Retenciones de IIBB Río Negro','Activo',NULL,1,2,1,0,0,1,NULL),(268,NULL,1140125,5,1,1140100,'Retenciones de IIBB Salta','Activo',NULL,1,2,1,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (269,NULL,1140126,5,1,1140100,'Retenciones de IIBB San Juan','Activo',NULL,1,2,1,0,0,1,NULL),(270,NULL,1140127,5,1,1140100,'Retenciones de IIBB San Luis','Activo',NULL,1,2,1,0,0,1,NULL),(271,NULL,1140128,5,1,1140100,'Retenciones de IIBB Santa Cruz','Activo',NULL,1,2,1,0,0,1,NULL),(272,NULL,1140129,5,1,1140100,'Retenciones de IIBB Santa Fe','Activo',NULL,1,2,1,0,0,1,NULL),(273,NULL,1140130,5,1,1140100,'Retenciones de IIBB Santiago del Estero','Activo',NULL,1,2,1,0,0,1,NULL),(274,NULL,1140131,5,1,1140100,'Retenciones de IIBB Tierra del Fuego','Activo',NULL,1,2,1,0,0,1,NULL),(275,NULL,1140132,5,1,1140100,'Retenciones de IIBB Tucuman','Activo',NULL,1,2,1,0,0,1,NULL),(276,NULL,5140168,5,1,5140100,'SIRCREB Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(277,NULL,5140139,5,1,5140100,'SIRCREB Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(278,NULL,5140140,5,1,5140100,'SIRCREB Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(279,NULL,5140141,5,1,5140100,'SIRCREB Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(280,NULL,5140142,5,1,5140100,'SIRCREB Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(281,NULL,5140143,5,1,5140100,'SIRCREB Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(282,NULL,5140144,5,1,5140100,'SIRCREB Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(283,NULL,5140145,5,1,5140100,'SIRCREB Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(284,NULL,5140146,5,1,5140100,'SIRCREB Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(285,NULL,5140147,5,1,5140100,'SIRCREB Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(286,NULL,5140148,5,1,5140100,'SIRCREB La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(287,NULL,5140149,5,1,5140100,'SIRCREB La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(288,NULL,5140150,5,1,5140100,'SIRCREB Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(289,NULL,5140151,5,1,5140100,'SIRCREB Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(290,NULL,5140152,5,1,5140100,'SIRCREB Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(291,NULL,5140153,5,1,5140100,'SIRCREB Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(292,NULL,5140154,5,1,5140100,'SIRCREB Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(293,NULL,5140155,5,1,5140100,'SIRCREB Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(294,NULL,5140156,5,1,5140100,'SIRCREB San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(295,NULL,5140157,5,1,5140100,'SIRCREB San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(296,NULL,5140158,5,1,5140100,'SIRCREB Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(297,NULL,5140159,5,1,5140100,'SIRCREB Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(298,NULL,5140160,5,1,5140100,'SIRCREB Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(299,NULL,5140161,5,1,5140100,'SIRCREB Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(300,NULL,5140162,5,1,5140100,'SIRCREB Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(301,NULL,1140326,5,1,1140300,'IIBB a Favor Buenos Aires','Activo',NULL,1,2,0,0,0,1,NULL),(302,NULL,1140302,5,1,1140300,'IIBB a Favor Capital Federal','Activo',NULL,1,2,0,0,0,1,NULL),(303,NULL,1140303,5,1,1140300,'IIBB a Favor Catamarca','Activo',NULL,1,2,0,0,0,1,NULL),(304,NULL,1140304,5,1,1140300,'IIBB a Favor Chaco','Activo',NULL,1,2,0,0,0,1,NULL),(305,NULL,1140305,5,1,1140300,'IIBB a Favor Chubut','Activo',NULL,1,2,0,0,0,1,NULL),(306,NULL,1140306,5,1,1140300,'IIBB a Favor Córdoba','Activo',NULL,1,2,0,0,0,1,NULL),(307,NULL,1140307,5,1,1140300,'IIBB a Favor Corrientes','Activo',NULL,1,2,0,0,0,1,NULL),(308,NULL,1140308,5,1,1140300,'IIBB a Favor Entre Ríos','Activo',NULL,1,2,0,0,0,1,NULL),(309,NULL,1140309,5,1,1140300,'IIBB a Favor Formosa','Activo',NULL,1,2,0,0,0,1,NULL),(310,NULL,1140310,5,1,1140300,'IIBB a Favor Jujuy','Activo',NULL,1,2,0,0,0,1,NULL),(311,NULL,1140311,5,1,1140300,'IIBB a Favor La Pampa','Activo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (312,NULL,1140312,5,1,1140300,'IIBB a Favor La Rioja','Activo',NULL,1,2,0,0,0,1,NULL),(313,NULL,1140313,5,1,1140300,'IIBB a Favor Mendoza','Activo',NULL,1,2,0,0,0,1,NULL),(314,NULL,1140314,5,1,1140300,'IIBB a Favor Misiones','Activo',NULL,1,2,0,0,0,1,NULL),(315,NULL,1140315,5,1,1140300,'IIBB a Favor Neuquén','Activo',NULL,1,2,0,0,0,1,NULL),(316,NULL,1140316,5,1,1140300,'IIBB a Favor Pascua Lama','Activo',NULL,1,2,0,0,0,1,NULL),(317,NULL,1140317,5,1,1140300,'IIBB a Favor Río Negro','Activo',NULL,1,2,0,0,0,1,NULL),(318,NULL,1140318,5,1,1140300,'IIBB a Favor Salta','Activo',NULL,1,2,0,0,0,1,NULL),(319,NULL,1140319,5,1,1140300,'IIBB a Favor San Juan','Activo',NULL,1,2,0,0,0,1,NULL),(320,NULL,1140320,5,1,1140300,'IIBB a Favor San Luis','Activo',NULL,1,2,0,0,0,1,NULL),(321,NULL,1140321,5,1,1140300,'IIBB a Favor Santa Cruz','Activo',NULL,1,2,0,0,0,1,NULL),(322,NULL,1140322,5,1,1140300,'IIBB a Favor Santa Fe','Activo',NULL,1,2,0,0,0,1,NULL),(323,NULL,1140323,5,1,1140300,'IIBB a Favor Santiago del Estero','Activo',NULL,1,2,0,0,0,1,NULL),(324,NULL,1140324,5,1,1140300,'IIBB a Favor Tierra del Fuego','Activo',NULL,1,2,0,0,0,1,NULL),(325,NULL,1140325,5,1,1140300,'IIBB a Favor Tucuman','Activo',NULL,1,2,0,0,0,1,NULL),(326,NULL,2110317,5,2,2110300,'IIBB a Pagar Buenos Aires','Pasivo',NULL,1,2,0,0,0,1,NULL),(327,NULL,2110318,5,2,2110300,'IIBB a Pagar Capital Federal','Pasivo',NULL,1,2,0,0,0,1,NULL),(328,NULL,2110319,5,2,2110300,'IIBB a Pagar Catamarca','Pasivo',NULL,1,2,0,0,0,1,NULL),(329,NULL,2110320,5,2,2110300,'IIBB a Pagar Chaco','Pasivo',NULL,1,2,0,0,0,1,NULL),(330,NULL,2110321,5,2,2110300,'IIBB a Pagar Chubut','Pasivo',NULL,1,2,0,0,0,1,NULL),(331,NULL,2110322,5,2,2110300,'IIBB a Pagar Córdoba','Pasivo',NULL,1,2,0,0,0,1,NULL),(332,NULL,2110323,5,2,2110300,'IIBB a Pagar Corrientes','Pasivo',NULL,1,2,0,0,0,1,NULL),(333,NULL,2110324,5,2,2110300,'IIBB a Pagar Entre Ríos','Pasivo',NULL,1,2,0,0,0,1,NULL),(334,NULL,2110325,5,2,2110300,'IIBB a Pagar Formosa','Pasivo',NULL,1,2,0,0,0,1,NULL),(335,NULL,2110326,5,2,2110300,'IIBB a Pagar Jujuy','Pasivo',NULL,1,2,0,0,0,1,NULL),(336,NULL,2110327,5,2,2110300,'IIBB a Pagar La Pampa','Pasivo',NULL,1,2,0,0,0,1,NULL),(337,NULL,2110328,5,2,2110300,'IIBB a Pagar La Rioja','Pasivo',NULL,1,2,0,0,0,1,NULL),(338,NULL,2110329,5,2,2110300,'IIBB a Pagar Mendoza','Pasivo',NULL,1,2,0,0,0,1,NULL),(339,NULL,2110330,5,2,2110300,'IIBB a Pagar Misiones','Pasivo',NULL,1,2,0,0,0,1,NULL),(340,NULL,2110331,5,2,2110300,'IIBB a Pagar Neuquén','Pasivo',NULL,1,2,0,0,0,1,NULL),(341,NULL,2110332,5,2,2110300,'IIBB a Pagar Pascua Lama','Pasivo',NULL,1,2,0,0,0,1,NULL),(342,NULL,2110333,5,2,2110300,'IIBB a Pagar Río Negro','Pasivo',NULL,1,2,0,0,0,1,NULL),(343,NULL,2110334,5,2,2110300,'IIBB a Pagar Salta','Pasivo',NULL,1,2,0,0,0,1,NULL),(344,NULL,2110335,5,2,2110300,'IIBB a Pagar San Juan','Pasivo',NULL,1,2,0,0,0,1,NULL),(345,NULL,2110336,5,2,2110300,'IIBB a Pagar San Luis','Pasivo',NULL,1,2,0,0,0,1,NULL),(346,NULL,2110337,5,2,2110300,'IIBB a Pagar Santa Cruz','Pasivo',NULL,1,2,0,0,0,1,NULL),(347,NULL,2110338,5,2,2110300,'IIBB a Pagar Santa Fe','Pasivo',NULL,1,2,0,0,0,1,NULL),(348,NULL,2110339,5,2,2110300,'IIBB a Pagar Santiago del Estero','Pasivo',NULL,1,2,0,0,0,1,NULL),(349,NULL,2110340,5,2,2110300,'IIBB a Pagar Tierra del Fuego','Pasivo',NULL,1,2,0,0,0,1,NULL),(350,NULL,2110341,5,2,2110300,'IIBB a Pagar Tucuman','Pasivo',NULL,1,2,0,0,0,1,NULL),(351,NULL,6110101,5,1,6110100,'BANCO SIRCREB','Movimiento',NULL,1,2,0,0,1,1,NULL),(352,NULL,6110102,5,1,6110100,'Compensacion','Movimiento',NULL,1,2,0,0,0,1,NULL),(353,NULL,1140327,5,1,1140300,'IVA Saldo Tecnico','Activo',NULL,1,2,0,0,0,1,NULL),(354,NULL,1140328,5,1,1140300,'IVA Saldo Libre Disponibilidad','Activo',NULL,1,2,0,0,0,1,NULL),(355,NULL,6000000,1,1,0,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(356,NULL,6100000,2,1,6000000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(357,NULL,6110000,3,1,6100000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (358,NULL,4110000,3,2,4100000,'Ingresos Operativos','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(359,NULL,1110120,5,1,1110100,'Caja en Pesos','Activo',NULL,1,2,1,1,1,0,NULL),(360,NULL,1140211,5,1,1140200,'Retenciones Bancarias de Ganancias a Favor','Activo',NULL,1,2,0,0,1,1,NULL),(361,NULL,1220104,5,1,1220100,'Equipos de Computación','Activo',NULL,1,1,0,0,0,1,NULL),(362,NULL,1220105,5,1,1220100,'Computadoras','Activo',NULL,1,1,0,0,0,1,NULL),(363,NULL,1220304,5,1,1220300,'Muebles y Utiles','Activo',NULL,1,1,0,0,0,1,NULL),(364,NULL,2110105,5,2,2110100,'Anticipo de Clientes','Pasivo',NULL,1,2,0,0,1,1,NULL),(365,NULL,2110401,5,2,2110400,'Provision Honorarios','Pasivo',NULL,1,1,0,0,0,1,NULL),(366,NULL,2110106,5,2,2110100,'Cta. Cte Directores','Pasivo',NULL,1,1,0,0,0,1,NULL),(367,NULL,2110107,5,2,2110100,'Provisión Honorarios Directores','Pasivo',NULL,1,1,0,0,0,1,NULL),(368,NULL,2110110,5,2,2110100,'Cuenta Particular Socio 1','Pasivo',NULL,1,1,0,0,0,1,NULL),(369,NULL,3110104,5,2,3110100,'Capital','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(370,NULL,1120000,3,1,1100000,'INVERSIONES','Activo',NULL,1,1,0,0,0,0,NULL),(371,NULL,1160000,3,1,1100000,'OTROS ACTIVOS','Activo',NULL,1,1,0,0,0,0,NULL),(372,NULL,1160100,4,1,1160000,'OTROS','Activo',NULL,1,1,0,0,0,0,NULL),(373,NULL,2110400,4,2,2110000,'Provision de Honorarios','Pasivo',NULL,1,1,0,0,0,0,NULL),(374,NULL,3410100,4,1,3410000,'RESULTADOS ACUMULADOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(375,NULL,3420000,3,1,3400000,'GANACIAS RESERVADAS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(376,NULL,3420100,4,1,3420000,'Rerva Legal','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(377,NULL,1220400,4,1,1220000,'INMUEBLES','Activo',NULL,1,1,0,0,0,0,NULL),(378,NULL,1220500,4,1,1220000,'RODADOS','Activo',NULL,1,1,0,0,0,0,NULL),(379,NULL,1220600,4,1,1220000,'MAQUINARIAS','Activo',NULL,1,1,0,0,0,0,NULL),(380,NULL,1220204,5,1,1220200,'Instalaciones','Activo',NULL,1,1,0,0,0,1,NULL),(381,NULL,3420101,5,2,3420100,'Reserva Legal','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(382,NULL,3420102,5,2,3420100,'Reserva Legal','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(383,NULL,3410105,5,2,3410100,'Resultado no asignado','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(384,NULL,1110121,5,1,1110100,'Caja en Dolares','Activo',NULL,1,2,1,1,1,0,NULL),(385,NULL,1120100,4,1,1120000,'TEMPORARIAS','Activo',NULL,1,1,0,0,0,0,NULL),(386,NULL,1120101,5,1,1120100,'PLAZO FIJO','Activo',NULL,1,1,0,0,0,1,NULL),(387,NULL,1120200,4,1,1120000,'PERMANENTES','Activo',NULL,1,1,0,0,0,0,NULL),(388,NULL,1120201,5,1,1120200,'ACCIONES','Activo',NULL,1,1,0,0,0,1,NULL),(389,NULL,1220401,5,1,1220400,'Inmuebles','Activo',NULL,1,1,0,0,0,1,NULL),(390,NULL,1220501,5,1,1220500,'Vehiculos','Activo',NULL,1,1,0,0,0,1,NULL),(391,NULL,1220601,5,1,1220600,'Maquinarias','Activo',NULL,1,1,0,0,0,1,NULL),(392,NULL,1150401,5,1,1150400,'MERCADERIAS','Activo',NULL,1,1,0,0,0,1,NULL),(393,NULL,1160101,5,1,1160100,'OTROS','Activo',NULL,1,1,0,0,0,1,NULL),(394,NULL,1230100,4,1,1230000,'INTANGIBLES','Activo',NULL,1,1,0,0,0,0,NULL),(395,NULL,2110119,5,2,2110100,'Cuenta Particular Socio 2','Pasivo',NULL,1,1,0,0,0,1,NULL),(396,NULL,5120160,5,1,5120100,'Comisiones Y gastos Bancarios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(397,NULL,4110100,4,2,4110000,'Ingresos Operativos','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(398,NULL,4120100,4,2,4120000,'OTROS INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(399,NULL,5110000,3,1,5100000,'GASTOS ORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(400,NULL,5120000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(401,NULL,5130000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(402,NULL,5140000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(403,NULL,5210000,3,1,5200000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(404,NULL,5210100,4,1,5210000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (405,NULL,6110100,4,1,6110000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(406,NULL,1130100,4,1,1130000,'Operaciones Ordinarias','Activo',NULL,1,1,0,0,0,0,NULL),(407,NULL,3110000,3,2,3100000,'CAPITAL SOCIAL','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(408,NULL,3410000,3,2,3400000,'RESULTADOS ANTERIORES','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(409,NULL,5110101,5,2,5110000,'IVA Crédito Fiscal No computable','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(410,NULL,1110203,5,1,1110200,'Banco ICBC Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(411,NULL,2110342,5,2,2110300,'Provisión Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(412,NULL,5120107,5,2,5120000,'Amortización Muebles y Útiles','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(413,NULL,5120102,5,2,5120000,'Amortización Equipos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(414,NULL,1220109,5,1,1220100,'Amortizacion Acumulada Equipos','Activo',NULL,1,1,0,0,0,1,NULL),(415,NULL,1220602,5,1,1220600,'Amortización Acumulada Maquinarias','Activo',NULL,1,1,0,0,0,1,NULL),(416,NULL,1160102,5,1,1160100,'Materias Primas','Activo',NULL,1,1,0,0,0,1,NULL),(417,NULL,1110204,5,1,1110200,'Banco Itaú Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(418,NULL,2110113,5,2,2110100,'Deudas Bancarias','Pasivo',NULL,1,2,0,1,1,1,NULL),(419,NULL,1220502,5,1,1220500,'Rodados','Activo',NULL,1,1,0,0,0,1,NULL),(420,NULL,1220503,5,1,1220500,'Amortización Acumulada Rodados','Activo',NULL,1,1,0,0,0,1,NULL),(421,NULL,5120105,5,2,5120000,'Amortización Rodados','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(422,NULL,5120109,5,2,5120000,'Amortización Maquinarias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(423,NULL,1220504,5,1,1220500,'Accesorios','Activo',NULL,1,1,0,0,0,1,NULL),(424,NULL,1220505,5,1,1220500,'Amortización Acumulada Accesorios','Activo',NULL,1,1,0,0,0,1,NULL),(425,NULL,1110205,5,1,1110200,'Banco Galicia Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(426,NULL,3420101,5,2,3420000,'Reserva Facultativa','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(427,NULL,1140212,5,1,1140200,'Créditos por Impuestos Diferidos','Activo',NULL,1,1,0,0,0,1,NULL),(428,NULL,1160103,5,1,1160100,'Fondo de Comercio','Activo',NULL,1,1,0,0,0,1,NULL),(429,NULL,1160104,5,1,1160100,'Amortizacion Acumulada Fondo de Comercio','Activo',NULL,1,1,0,0,0,1,NULL),(430,NULL,1140213,5,1,1140200,'Intereses a devengar AGIP','Activo',NULL,1,1,0,0,0,1,NULL),(431,NULL,2110343,5,2,2110300,'PFP IIBB','Pasivo',NULL,1,1,0,0,0,1,NULL),(432,NULL,1140330,5,1,1140300,'Pago a Cuenta ITC','Activo',NULL,1,2,0,0,0,1,NULL),(433,NULL,2110114,5,2,2110100,'Préstamo','Pasivo',NULL,1,2,0,1,1,1,NULL),(434,NULL,1160106,5,1,1160100,'Productos','Activo',NULL,1,1,0,0,0,1,NULL),(435,NULL,2110345,5,2,2110300,'Intereses a devengar PFP','Pasivo',NULL,1,1,0,0,0,1,NULL),(436,NULL,1110206,5,1,1110200,'Banco Provincia Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(437,NULL,1140215,5,1,1140200,'Imp. Ley 25413 Cred 0.6%','Activo',NULL,1,1,0,0,0,1,NULL),(438,NULL,2110402,5,2,2110400,'Honorarios Directorio a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(439,NULL,3110101,5,2,3110100,'Reserva para Futuras Inversiones','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(440,NULL,1130106,5,1,1130100,'TEAC - Trabajos Ejecutados a Certificar','Activo',NULL,1,1,0,0,0,1,NULL),(441,NULL,2110115,5,2,2110100,'Leasing','Pasivo',NULL,1,2,0,1,1,1,NULL),(442,NULL,1110207,5,1,1110200,'Banco Comafi Cta. Cte','Activo',NULL,1,2,1,1,1,0,NULL),(443,NULL,2110500,4,2,2110000,'Deudas Financieras','Pasivo',NULL,1,1,0,0,0,0,NULL),(444,NULL,2110501,5,2,2110500,'Banco Santander Rio Cta Cte','Pasivo',NULL,1,1,0,0,0,1,NULL),(446,NULL,2210000,3,2,2200000,'Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(447,NULL,2210100,4,2,2210000,'Otras Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(448,NULL,2210101,5,2,2210100,'Planes de Pagos AFIP','Pasivo',NULL,1,2,0,1,1,1,NULL),(449,NULL,2110502,5,2,2110500,'Leasing','Pasivo',NULL,1,1,0,0,0,1,NULL),(450,NULL,6110101,5,1,6110000,'Cheques Rechazados','Movimiento',NULL,1,2,0,0,1,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (451,NULL,1110208,5,1,1110200,'Banco Patagonia Taxes Software','Activo',NULL,1,2,1,1,1,0,NULL),(452,NULL,1110209,5,1,1110200,'Banco Macro Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(453,NULL,1120202,5,1,1120200,'Inversión Central Caribe','Activo',NULL,1,1,0,0,0,1,NULL),(454,NULL,1120102,5,1,1120100,'Otras Inversiones','Activo',NULL,1,1,0,0,0,1,NULL),(455,NULL,1140216,5,1,1140200,'Otros Créditos','Activo',NULL,1,1,0,0,0,1,NULL),(456,NULL,2110403,5,2,2110400,'Provisión Honorarios Socio Gerente','Pasivo',NULL,1,1,0,0,0,1,NULL),(457,NULL,1110210,5,1,1110200,'Cheque Diferido Banco Santander Rio','Activo',NULL,1,2,1,1,1,0,NULL),(458,NULL,1110211,5,1,1110200,'Cheque Diferido Banco Macro','Activo',NULL,1,2,1,1,1,0,NULL),(459,NULL,2110204,5,2,2110200,'Moratoria SUSS a pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(460,NULL,2110344,5,2,2110300,'Impuestos Municipales a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(461,NULL,5110103,5,2,5110000,'Amortización Instalaciones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(462,NULL,5120110,5,2,5120000,'Amortización Equipos de comput.','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(463,NULL,2110118,5,2,2110100,'Cuenta Particular Socio 3','Pasivo',NULL,1,1,0,0,0,1,NULL),(464,NULL,2110120,5,2,2110100,'Cuenta Particular Socio 4','Pasivo',NULL,1,1,0,0,0,1,NULL),(465,NULL,3110102,5,2,3110100,'Otras Reservas','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(466,NULL,1140331,5,1,1140300,'IGMP (Saldo a Favor)','Activo',NULL,1,1,0,0,0,1,NULL),(467,NULL,5110104,5,2,5110000,'Interés','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(468,NULL,1150402,5,1,1150400,'Productos en Proceso','Activo',NULL,1,1,0,0,0,1,NULL),(469,NULL,2110205,5,2,2110200,'Depósitos en Garantía Socio Gerente','Pasivo',NULL,1,1,0,0,0,1,NULL),(470,NULL,2110346,5,2,2110300,'Fondos Embargados','Pasivo',NULL,1,1,0,0,0,1,NULL),(471,NULL,2110347,5,2,2110300,'Cuota Solid.','Pasivo',NULL,1,1,0,0,0,1,NULL),(472,NULL,1140332,5,1,1140300,'Anticipo Honorarios Directores','Activo',NULL,1,1,0,0,0,1,NULL),(473,NULL,2110348,5,2,2110300,'SICORE a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(474,NULL,1110212,5,1,1110200,'Banco Credicoop Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(475,NULL,1110213,5,1,1110200,'Banco Superville Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(476,NULL,5110105,5,2,5110000,'RECPAM','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(477,NULL,1110125,5,1,1110100,'Caja Reales','Activo',NULL,1,2,1,1,1,0,NULL),(478,NULL,5140169,5,1,5140100,'CO2 - Imp. Al Carbono','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(479,NULL,1140300,4,1,1140000,'Anticipo de Impuestos','Activo',NULL,1,1,0,0,0,0,NULL),(480,NULL,2110600,4,2,2110000,'Retenciones Efectuadas','Pasivo',NULL,1,1,0,0,0,0,NULL),(481,NULL,4200000,2,2,4000000,'INGRESOS EXTRAORDINARIOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL);
/*!40000 ALTER TABLE `conta_plan_cuenta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_asientos`
--

DROP TABLE IF EXISTS `conta_tipo_asientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_asientos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `orden` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_asientos`
--

LOCK TABLES `conta_tipo_asientos` WRITE;
/*!40000 ALTER TABLE `conta_tipo_asientos` DISABLE KEYS */;
INSERT INTO `conta_tipo_asientos` VALUES (1,'Sueldos',NULL,NULL,NULL,11),(2,'Ingresos',NULL,NULL,NULL,9),(3,'Egresos',NULL,NULL,NULL,10),(4,'Amortizaciones',NULL,NULL,NULL,4),(5,'Banco',NULL,NULL,NULL,15),(6,'Ganancias',NULL,NULL,NULL,12),(7,'Retenciones',NULL,NULL,NULL,13),(8,'SIRCREB',NULL,NULL,NULL,14),(9,'Compensaciones',NULL,NULL,NULL,16),(10,'Pagos AFIP',NULL,NULL,NULL,17),(11,'Ajustes',NULL,NULL,NULL,3),(12,'Saldos Iniciales',NULL,NULL,NULL,1),(13,'Cancelacion de Iniciales',NULL,NULL,NULL,2),(14,'Patrimonio Neto',NULL,NULL,NULL,8),(15,'Liquidaciones IVA',NULL,NULL,NULL,18),(16,'Liquidacion IIBB',NULL,NULL,NULL,19),(17,'Asientos de Cierre',NULL,NULL,NULL,5),(18,'Reclasificacion',NULL,NULL,NULL,6),(19,'Otros',NULL,NULL,NULL,7),(20,'Cobranzas','2019-10-02 03:20:37','2019-10-02 03:20:37',NULL,NULL),(21,'Pagos','2019-10-02 03:20:37','2019-10-02 03:20:37',NULL,NULL),(22,'Tesoreria','2019-10-19 02:10:24','2019-10-19 02:10:24',NULL,NULL),(23,'Ajuste por Inflacion','2020-03-01 06:39:20','2020-03-01 06:39:20',NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_asientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_cuentas`
--

DROP TABLE IF EXISTS `conta_tipo_cuentas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_cuentas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo_cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_cuentas`
--

LOCK TABLES `conta_tipo_cuentas` WRITE;
/*!40000 ALTER TABLE `conta_tipo_cuentas` DISABLE KEYS */;
INSERT INTO `conta_tipo_cuentas` VALUES (1,'Rubro',NULL,NULL,NULL),(2,'SubRubro',NULL,NULL,NULL),(3,'Grupo',NULL,NULL,NULL),(4,'SubGrupo',NULL,NULL,NULL),(5,'Cuenta',NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_cuentas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_saldos`
--

DROP TABLE IF EXISTS `conta_tipo_saldos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_saldos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `saldo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_saldos`
--

LOCK TABLES `conta_tipo_saldos` WRITE;
/*!40000 ALTER TABLE `conta_tipo_saldos` DISABLE KEYS */;
INSERT INTO `conta_tipo_saldos` VALUES (1,'Deudor',NULL,NULL,NULL),(2,'Acreedor',NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_saldos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `control_cuits_afip`
--

DROP TABLE IF EXISTS `control_cuits_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `control_cuits_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `field_name1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuit` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `error` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `control_cuits_afip_person_id_foreign` (`person_id`),
  CONSTRAINT `control_cuits_afip_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `control_cuits_afip`
--

LOCK TABLES `control_cuits_afip` WRITE;
/*!40000 ALTER TABLE `control_cuits_afip` DISABLE KEYS */;
/*!40000 ALTER TABLE `control_cuits_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `control_general`
--

DROP TABLE IF EXISTS `control_general`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `control_general` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `control_general_description_unique` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `control_general`
--

LOCK TABLES `control_general` WRITE;
/*!40000 ALTER TABLE `control_general` DISABLE KEYS */;
INSERT INTO `control_general` VALUES (1,'Ingresos - Egresos - Resultado',1,'Proyeccion Ganancias','control_general/proyecGanancias',NULL,NULL),(2,'IVA',2,'IVA','control_general/iva',NULL,NULL),(3,'IIBB',3,'IIBB','control_general/iibb',NULL,NULL),(4,'Por Mes',4,'Vto. Impuestos','control_general/vto',NULL,NULL),(5,'Por Impuesto',4,'Vto. Impuestos','control_general/vtoPorImpuestos',NULL,NULL);
/*!40000 ALTER TABLE `control_general` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente`
--

DROP TABLE IF EXISTS `cta_cte_cliente`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `compensado` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_cliente_person_id_foreign` (`person_id`),
  KEY `cta_cte_cliente_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `cta_cte_cliente_period_id_foreign` (`period_id`),
  KEY `cta_cte_cliente_saldo_id_foreign` (`saldo_id`),
  KEY `cta_cte_cliente_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `cta_cte_cliente_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `cta_cte_cliente_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_cliente_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_cliente_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `cta_cte_cliente_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente`
--

LOCK TABLES `cta_cte_cliente` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_cliente` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente_details`
--

DROP TABLE IF EXISTS `cta_cte_cliente_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_cliente_details_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_cliente_details_person_id_foreign` (`person_id`),
  KEY `cta_cte_cliente_details_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `cta_cte_cliente_details_period_id_foreign` (`period_id`),
  KEY `cta_cte_cliente_details_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `cta_cte_cliente_details_saldo_id_foreign` (`saldo_id`),
  KEY `cta_cte_cliente_details_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `cta_cte_cliente_details_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `cta_cte_cliente_details_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_cliente_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_cliente_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_details_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `cta_cte_cliente_details_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente_details`
--

LOCK TABLES `cta_cte_cliente_details` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_cliente_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente_pivot_receipt`
--

DROP TABLE IF EXISTS `cta_cte_cliente_pivot_receipt`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente_pivot_receipt` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned NOT NULL,
  `receipt_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente_pivot_receipt`
--

LOCK TABLES `cta_cte_cliente_pivot_receipt` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente_pivot_receipt` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_cliente_pivot_receipt` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL,
  `fecha` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_tesoreria_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_period_id_foreign` (`period_id`),
  KEY `cta_cte_tesoreria_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  CONSTRAINT `cta_cte_tesoreria_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `cta_cte_tesoreria_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_tesoreria_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria`
--

LOCK TABLES `cta_cte_tesoreria` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_cuentas`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_cuentas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_cuentas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cheque3ros` tinyint(1) NOT NULL DEFAULT '0',
  `cheque_emitidos` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cta_cte` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_origen` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_destino` tinyint(1) NOT NULL DEFAULT '0',
  `conta_asientos` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_cuentas_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_cuentas_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=757 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_cuentas`
--

LOCK TABLES `cta_cte_tesoreria_cuentas` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuentas` DISABLE KEYS */;
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (13,NULL,13,NULL,'Clientes - Deudores',0,0,0,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(20,NULL,20,NULL,'Anticipos Impuesto a las Ganancias',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(23,NULL,23,NULL,'Retenciones Impuesto a las Ganancias',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(25,NULL,25,NULL,'Retenciones de IVA',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(57,NULL,57,NULL,'Proveedores en Cta. Cte. locales',0,0,0,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(60,NULL,60,NULL,'Cheques emitidos ',0,1,1,1,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(62,NULL,62,NULL,'Sueldos y Jornales a pagar',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(140,NULL,140,NULL,'Intereses y Gastos bancarios',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(162,NULL,162,NULL,'Retenciones SUSS',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(176,NULL,176,NULL,'Cheques en Cartera',1,0,1,1,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(201,NULL,201,NULL,'Monotributo',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(203,NULL,203,NULL,'Autonomos',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(219,NULL,219,NULL,'Pagos AFIP',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(251,NULL,251,NULL,'Retenciones de IIBB Buenos Aires',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(252,NULL,252,NULL,'Retenciones de IIBB Capital Federal',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(253,NULL,253,NULL,'Retenciones de IIBB Catamarca',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(254,NULL,254,NULL,'Retenciones de IIBB Chaco',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(255,NULL,255,NULL,'Retenciones de IIBB Chubut',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(256,NULL,256,NULL,'Retenciones de IIBB Córdoba',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(257,NULL,257,NULL,'Retenciones de IIBB Corrientes',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(258,NULL,258,NULL,'Retenciones de IIBB Entre Ríos',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(259,NULL,259,NULL,'Retenciones de IIBB Formosa',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(260,NULL,260,NULL,'Retenciones de IIBB Jujuy',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(261,NULL,261,NULL,'Retenciones de IIBB La Pampa',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(262,NULL,262,NULL,'Retenciones de IIBB La Rioja',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(263,NULL,263,NULL,'Retenciones de IIBB Mendoza',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(264,NULL,264,NULL,'Retenciones de IIBB Misiones',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(265,NULL,265,NULL,'Retenciones de IIBB Neuquén',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(266,NULL,266,NULL,'Retenciones de IIBB Pascua Lama',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(267,NULL,267,NULL,'Retenciones de IIBB Río Negro',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(268,NULL,268,NULL,'Retenciones de IIBB Salta',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(269,NULL,269,NULL,'Retenciones de IIBB San Juan',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(270,NULL,270,NULL,'Retenciones de IIBB San Luis',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(271,NULL,271,NULL,'Retenciones de IIBB Santa Cruz',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(272,NULL,272,NULL,'Retenciones de IIBB Santa Fe',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(273,NULL,273,NULL,'Retenciones de IIBB Santiago del Estero',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (274,NULL,274,NULL,'Retenciones de IIBB Tierra del Fuego',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(275,NULL,275,NULL,'Retenciones de IIBB Tucuman',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(351,NULL,351,NULL,'BANCO SIRCREB',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(359,NULL,359,NULL,'Caja en Pesos',0,0,1,1,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(360,NULL,360,NULL,'Retenciones Bancarias de Ganancias a Favor',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(364,NULL,364,NULL,'Anticipo de Clientes',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(384,NULL,384,NULL,'Caja en Dolares',0,0,1,1,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(409,NULL,409,NULL,'IVA Crédito Fiscal No computable',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(418,NULL,418,NULL,'Deudas Bancarias',0,0,0,1,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(433,NULL,433,NULL,'Préstamo',0,0,0,1,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(441,NULL,441,NULL,'Leasing',0,0,0,1,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(448,NULL,448,NULL,'Planes de Pagos AFIP',0,0,0,1,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(450,NULL,450,NULL,'Cheques Rechazados',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(467,NULL,467,NULL,'Interés',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(468,0,14,NULL,'Deudores por ventas comunes',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(469,0,15,NULL,'Deudores por ventas morosos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(470,0,16,NULL,'Deudores en gestión judicial',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(471,0,17,NULL,'Previsión deudores incobrables',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(472,0,22,NULL,'Anticipo Impto.Ganancia Mínima Presunta',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(473,0,24,NULL,'Impuesto a las Ganancias (Saldo a favor)',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(474,0,27,NULL,'Anticipos de proveedores',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(475,0,28,NULL,'Depósito en garantía alquileres',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(476,0,29,NULL,'Derechos adquiridos a devengar',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(477,0,30,NULL,'Intereses a devengar',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(478,0,31,NULL,'Cuentas a rendir - Directores',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(479,0,32,NULL,'Alquileres no devengados',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(480,0,38,NULL,'Equipos de computación valores históricos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(481,0,39,NULL,'Equipos de computación ajuste',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(482,0,40,NULL,'Amortización Acumulada Equipos de comput.',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(483,0,42,NULL,'Instalaciones valores históricos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(484,0,43,NULL,'Instalaciones ajuste',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(485,0,44,NULL,'Amortización Acumulada Instalaciones',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(486,0,46,NULL,'Muebles y utiles valores históricos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(487,0,47,NULL,'Muebles y utiles ajuste',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(488,0,48,NULL,'Amortización Acumulada Muebles y Útiles',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(489,0,50,NULL,'Gastos de organización valores historicos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (490,0,51,NULL,'Gastos de organización ajuste',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(491,0,52,NULL,'Amortización acumulada gs. de organización',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(492,0,58,NULL,'Proveedores en cta. cte. exterior',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(493,0,59,NULL,'Derechos de exhibición a devengar',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(494,0,63,NULL,'Cargas sociales a pagar',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(495,0,64,NULL,'Sindicatos a Pagar',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(496,0,67,NULL,'IVA Debito Fiscal',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(497,0,68,NULL,'IVA Credito Fiscal',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(498,0,69,NULL,'Impuestos Internos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(499,0,70,NULL,'Impuestos al Combustible',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(500,0,71,NULL,'IVA Retenciones de terceros',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(501,0,72,NULL,'IVA Percepciones realiz.por terceros',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(502,0,73,NULL,'IVA Saldo a favor',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(503,0,74,NULL,'IVA a pagar',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(504,0,75,NULL,'Percepciones Ingresos Brutos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(505,0,76,NULL,'Otros Pagos AFIP',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(506,0,78,NULL,'Impuesto a los Ingresos Brutos Pasivo',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(507,0,79,NULL,'Impuesto a las Ganancias',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(508,0,80,NULL,'Impuesto a la Ganancia Mínima Presunta',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(509,0,81,NULL,'AFIP - Retenciones Impuesto a las Ganancias',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(510,0,82,NULL,'AFIP - Plan de Facilidades Decreto 338/02',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(511,0,87,NULL,'Acciones en circulación',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(512,0,88,NULL,'Ajuste del Capital',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(513,0,89,NULL,'Aportes Irrevocables Futuras Suscripciones',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(514,0,91,NULL,'Resultado del ejercicio',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(515,0,92,NULL,'Resultado ejercicios anteriores',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(516,0,93,NULL,'A.R.E.A.',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(517,0,96,NULL,'VENTAS',0,0,0,0,1,1,'2020-02-06 17:23:07','2021-03-17 22:06:02',NULL),(518,0,97,NULL,'Honorarios',0,0,0,0,1,1,'2020-02-06 17:23:07','2021-03-17 22:06:02',NULL),(519,0,99,NULL,'Descuentos obtenidos',0,0,0,0,1,1,'2020-02-06 17:23:07','2021-03-17 22:06:02',NULL),(520,0,100,NULL,'Reintegros por exportaciones',0,0,0,0,1,1,'2020-02-06 17:23:07','2021-03-17 22:06:02',NULL),(521,0,102,NULL,'Intereses Cobrados',0,0,0,0,1,1,'2020-02-06 17:23:07','2021-03-17 22:06:02',NULL),(522,0,103,NULL,'Diferencias de cambio',0,0,0,0,1,1,'2020-02-06 17:23:07','2021-03-17 22:06:02',NULL),(523,0,104,NULL,'Descuentos obtenidos',0,0,0,0,1,1,'2020-02-06 17:23:07','2021-03-17 22:06:02',NULL),(524,0,110,NULL,'Sueldos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(525,0,111,NULL,'Contribuciones',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(526,0,112,NULL,'Sindicato',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(527,0,114,NULL,'ACA',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (528,0,115,NULL,'Aereos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(529,0,116,NULL,'Alquiler',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(530,0,117,NULL,'AGUA AYSA',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(531,0,118,NULL,'TV Cablevision',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(532,0,119,NULL,'Caja Jubilacion Consejo',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(533,0,120,NULL,'Celulares',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(534,0,121,NULL,'Cheques',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(535,0,123,NULL,'Comida',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(536,0,126,NULL,'Fletes y acarreos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(537,0,127,NULL,'Luz Edesur',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(538,0,128,NULL,'Movilidad y Viáticos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(539,0,129,NULL,'Mantenimiento',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(540,0,130,NULL,'IVA No Computable',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(541,0,131,NULL,'Entretenimiento',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(542,0,132,NULL,'Amortización Bienes de Uso',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(543,0,135,NULL,'Gastos varios',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(544,0,136,NULL,'Ajuste por redondeo',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(545,0,137,NULL,'Deudores Incobrables',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(546,0,141,NULL,'Intereses Proveedores',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(547,0,143,NULL,'Diferencias de cambio',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(548,0,144,NULL,'Diferencia de Cambio Bces. en M.Extranjera',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(549,0,145,NULL,'Diferencia tipo cambio Vendedor/Comprador',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(550,0,146,NULL,'Diferencia por conversion en Bce. en Mon. Extranj.',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(551,0,147,NULL,'Diferencia de cambio CMV',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(552,0,148,NULL,'Diferencia de cambio PT',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(553,0,149,NULL,'Resultado por Exposición a la Inflación',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(554,0,150,NULL,'Diferencia de cambio PE',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(555,0,151,NULL,'Diferencia de cambio Ds.Vtas.',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(556,0,152,NULL,'Diferencia de cambio ME',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(557,0,153,NULL,'Descuentos otorgados',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(558,0,155,NULL,'Impuesto a las Ganancias',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(559,0,156,NULL,'Impuesto a los Ingresos Brutos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(560,0,157,NULL,'Impuesto al Debito y Credito Bancario',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(561,0,159,NULL,'Pérdida por venta bienes de uso',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(562,0,160,NULL,'Inversiones',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(563,0,161,NULL,'Amortizaciones extraordinarias',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(564,0,178,NULL,'Google',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(565,0,188,NULL,'Publicidad',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(566,0,191,NULL,'Cargas Sociales',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (567,0,192,NULL,'Honorarios',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(568,0,193,NULL,'Telefono Fijo',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(569,0,198,NULL,'Seguros',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(570,0,199,NULL,'Internet',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(571,0,204,NULL,'Multas Impositivas',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(572,0,208,NULL,'Impuesto a los Ingresos Brutos - BS AS',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(573,0,209,NULL,'SIRCREB',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(574,0,212,NULL,'Tarjeta Visa',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(575,0,213,NULL,'Tarjeta American Express',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(576,0,214,NULL,'Tarjeta Mastercard',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(577,0,215,NULL,'Tarjeta Shopping',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(578,0,216,NULL,'Tarjeta Cencosud',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(579,0,217,NULL,'Compras',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(580,0,218,NULL,'Ventas No Gravadas',0,0,0,0,1,1,'2020-02-06 17:23:07','2021-03-17 22:06:02',NULL),(581,0,220,NULL,'Perc IVA -RG3337',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(582,0,221,NULL,'Imps. Internos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(583,0,222,NULL,'Imp. Gasoil',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(584,0,223,NULL,'Imp. Hídricos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(585,0,224,NULL,'ITC',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(586,0,225,NULL,'Perc IIBB  Buenos Aires',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(587,0,226,NULL,'Perc IIBB  Capital Federal',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(588,0,227,NULL,'Perc IIBB  Catamarca',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(589,0,228,NULL,'Perc IIBB  Chaco',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(590,0,229,NULL,'Perc IIBB  Chubut',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(591,0,230,NULL,'Perc IIBB  Córdoba',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(592,0,231,NULL,'Perc IIBB  Corrientes',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(593,0,232,NULL,'Perc IIBB  Entre Ríos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(594,0,233,NULL,'Perc IIBB  Formosa',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(595,0,234,NULL,'Perc IIBB  Jujuy',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(596,0,235,NULL,'Perc IIBB  La Pampa',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(597,0,236,NULL,'Perc IIBB  La Rioja',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(598,0,237,NULL,'Perc IIBB  Mendoza',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(599,0,238,NULL,'Perc IIBB  Misiones',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(600,0,239,NULL,'Perc IIBB  Neuquén',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(601,0,240,NULL,'Perc IIBB  Pascua Lama',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(602,0,241,NULL,'Perc IIBB  Río Negro',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(603,0,242,NULL,'Perc IIBB  Salta',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(604,0,243,NULL,'Perc IIBB  San Juan',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(605,0,244,NULL,'Perc IIBB  San Luis',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(606,0,245,NULL,'Perc IIBB  Santa Cruz',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (607,0,246,NULL,'Perc IIBB  Santa Fe',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(608,0,247,NULL,'Perc IIBB  Santiago del Estero',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(609,0,248,NULL,'Perc IIBB  Tierra del Fuego',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(610,0,249,NULL,'Perc IIBB  Tucuman',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(611,0,250,NULL,'Compras No Gravadas',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(612,0,276,NULL,'SIRCREB Buenos Aires',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(613,0,277,NULL,'SIRCREB Capital Federal',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(614,0,278,NULL,'SIRCREB Catamarca',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(615,0,279,NULL,'SIRCREB Chaco',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(616,0,280,NULL,'SIRCREB Chubut',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(617,0,281,NULL,'SIRCREB Córdoba',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(618,0,282,NULL,'SIRCREB Corrientes',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(619,0,283,NULL,'SIRCREB Entre Ríos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(620,0,284,NULL,'SIRCREB Formosa',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(621,0,285,NULL,'SIRCREB Jujuy',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(622,0,286,NULL,'SIRCREB La Pampa',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(623,0,287,NULL,'SIRCREB La Rioja',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(624,0,288,NULL,'SIRCREB Mendoza',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(625,0,289,NULL,'SIRCREB Misiones',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(626,0,290,NULL,'SIRCREB Neuquén',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(627,0,291,NULL,'SIRCREB Pascua Lama',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(628,0,292,NULL,'SIRCREB Río Negro',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(629,0,293,NULL,'SIRCREB Salta',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(630,0,294,NULL,'SIRCREB San Juan',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(631,0,295,NULL,'SIRCREB San Luis',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(632,0,296,NULL,'SIRCREB Santa Cruz',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(633,0,297,NULL,'SIRCREB Santa Fe',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(634,0,298,NULL,'SIRCREB Santiago del Estero',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(635,0,299,NULL,'SIRCREB Tierra del Fuego',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(636,0,300,NULL,'SIRCREB Tucuman',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(637,0,301,NULL,'IIBB a Favor Buenos Aires',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(638,0,302,NULL,'IIBB a Favor Capital Federal',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(639,0,303,NULL,'IIBB a Favor Catamarca',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(640,0,304,NULL,'IIBB a Favor Chaco',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(641,0,305,NULL,'IIBB a Favor Chubut',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(642,0,306,NULL,'IIBB a Favor Córdoba',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(643,0,307,NULL,'IIBB a Favor Corrientes',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(644,0,308,NULL,'IIBB a Favor Entre Ríos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(645,0,309,NULL,'IIBB a Favor Formosa',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(646,0,310,NULL,'IIBB a Favor Jujuy',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (647,0,311,NULL,'IIBB a Favor La Pampa',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(648,0,312,NULL,'IIBB a Favor La Rioja',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(649,0,313,NULL,'IIBB a Favor Mendoza',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(650,0,314,NULL,'IIBB a Favor Misiones',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(651,0,315,NULL,'IIBB a Favor Neuquén',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(652,0,316,NULL,'IIBB a Favor Pascua Lama',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(653,0,317,NULL,'IIBB a Favor Río Negro',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(654,0,318,NULL,'IIBB a Favor Salta',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(655,0,319,NULL,'IIBB a Favor San Juan',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(656,0,320,NULL,'IIBB a Favor San Luis',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(657,0,321,NULL,'IIBB a Favor Santa Cruz',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(658,0,322,NULL,'IIBB a Favor Santa Fe',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(659,0,323,NULL,'IIBB a Favor Santiago del Estero',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(660,0,324,NULL,'IIBB a Favor Tierra del Fuego',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(661,0,325,NULL,'IIBB a Favor Tucuman',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(662,0,326,NULL,'IIBB a Pagar Buenos Aires',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(663,0,327,NULL,'IIBB a Pagar Capital Federal',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(664,0,328,NULL,'IIBB a Pagar Catamarca',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(665,0,329,NULL,'IIBB a Pagar Chaco',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(666,0,330,NULL,'IIBB a Pagar Chubut',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(667,0,331,NULL,'IIBB a Pagar Córdoba',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(668,0,332,NULL,'IIBB a Pagar Corrientes',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(669,0,333,NULL,'IIBB a Pagar Entre Ríos',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(670,0,334,NULL,'IIBB a Pagar Formosa',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(671,0,335,NULL,'IIBB a Pagar Jujuy',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(672,0,336,NULL,'IIBB a Pagar La Pampa',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(673,0,337,NULL,'IIBB a Pagar La Rioja',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(674,0,338,NULL,'IIBB a Pagar Mendoza',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(675,0,339,NULL,'IIBB a Pagar Misiones',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(676,0,340,NULL,'IIBB a Pagar Neuquén',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(677,0,341,NULL,'IIBB a Pagar Pascua Lama',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(678,0,342,NULL,'IIBB a Pagar Río Negro',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(679,0,343,NULL,'IIBB a Pagar Salta',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(680,0,344,NULL,'IIBB a Pagar San Juan',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(681,0,345,NULL,'IIBB a Pagar San Luis',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(682,0,346,NULL,'IIBB a Pagar Santa Cruz',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(683,0,347,NULL,'IIBB a Pagar Santa Fe',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(684,0,348,NULL,'IIBB a Pagar Santiago del Estero',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (685,0,349,NULL,'IIBB a Pagar Tierra del Fuego',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(686,0,350,NULL,'IIBB a Pagar Tucuman',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(687,0,352,NULL,'Compensacion',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(688,0,353,NULL,'IVA Saldo Tecnico',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(689,0,354,NULL,'IVA Saldo Libre Disponibilidad',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(690,0,361,NULL,'Equipos de Computación',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(691,0,362,NULL,'Computadoras',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(692,0,363,NULL,'Muebles y Utiles',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(693,0,365,NULL,'Provision Honorarios',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(694,0,366,NULL,'Cta. Cte Directores',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(695,0,367,NULL,'Provisión Honorarios Directores',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(696,0,368,NULL,'Cuenta Particular Socio 1',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(697,0,369,NULL,'Capital',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(698,0,380,NULL,'Instalaciones',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(699,0,381,NULL,'Reserva Legal',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(700,0,382,NULL,'Reserva Legal',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(701,0,383,NULL,'Resultado no asignado',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(702,0,386,NULL,'PLAZO FIJO',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(703,0,388,NULL,'ACCIONES',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(704,0,389,NULL,'Inmuebles',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(705,0,390,NULL,'Vehiculos',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(706,0,391,NULL,'Maquinarias',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(707,0,392,NULL,'MERCADERIAS',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(708,0,393,NULL,'OTROS',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(709,0,395,NULL,'Cuenta Particular Socio 2',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(710,0,396,NULL,'Comisiones Y gastos Bancarios',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(711,0,411,NULL,'Provisión Impuesto a las Ganancias',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(712,0,412,NULL,'Amortización Muebles y Útiles',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(713,0,413,NULL,'Amortización Equipos',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(714,0,414,NULL,'Amortizacion Acumulada Equipos',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(715,0,415,NULL,'Amortización Acumulada Maquinarias',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(716,0,416,NULL,'Materias Primas',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(717,0,419,NULL,'Rodados',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(718,0,420,NULL,'Amortización Acumulada Rodados',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(719,0,421,NULL,'Amortización Rodados',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(720,0,422,NULL,'Amortización Maquinarias',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(721,0,423,NULL,'Accesorios',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(722,0,424,NULL,'Amortización Acumulada Accesorios',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(723,0,426,NULL,'Reserva Facultativa',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (724,0,427,NULL,'Créditos por Impuestos Diferidos',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(725,0,428,NULL,'Fondo de Comercio',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(726,0,429,NULL,'Amortizacion Acumulada Fondo de Comercio',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(727,0,430,NULL,'Intereses a devengar AGIP',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(728,0,431,NULL,'PFP IIBB',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(729,0,434,NULL,'Productos',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(730,0,435,NULL,'Intereses a devengar PFP',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(731,0,437,NULL,'Imp. Ley 25413 Cred 0.6%',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(732,0,438,NULL,'Honorarios Directorio a Pagar',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(733,0,439,NULL,'Reserva para Futuras Inversiones',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(734,0,440,NULL,'TEAC - Trabajos Ejecutados a Certificar',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(735,0,444,NULL,'Banco Santander Rio Cta Cte',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(736,0,449,NULL,'Leasing',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(737,0,453,NULL,'Inversión Central Caribe',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(738,0,454,NULL,'Otras Inversiones',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(739,0,455,NULL,'Otros Créditos',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(740,0,456,NULL,'Provisión Honorarios Socio Gerente',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(741,0,459,NULL,'Moratoria SUSS a pagar',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(742,0,460,NULL,'Impuestos Municipales a Pagar',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(743,0,461,NULL,'Amortización Instalaciones',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(744,0,462,NULL,'Amortización Equipos de comput.',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(745,0,463,NULL,'Cuenta Particular Socio 3',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(746,0,464,NULL,'Cuenta Particular Socio 4',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(747,0,465,NULL,'Otras Reservas',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(748,0,466,NULL,'IGMP (Saldo a Favor)',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(749,0,468,NULL,'Productos en Proceso',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(750,0,469,NULL,'Depósitos en Garantía Socio Gerente',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(751,0,470,NULL,'Fondos Embargados',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(752,0,471,NULL,'Cuota Solid.',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(753,0,472,NULL,'Anticipo Honorarios Directores',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(754,0,473,NULL,'SICORE a Pagar',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(755,0,476,NULL,'RECPAM',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(756,0,478,NULL,'CO2 - Imp. Al Carbono',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL);
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuentas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_detail`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `fecha` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_detail_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `cta_cte_tesoreria_detail_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_detail_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_detail_period_id_foreign` (`period_id`),
  KEY `cta_cte_tesoreria_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `cta_cte_tesoreria_detail_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_detail`
--

LOCK TABLES `cta_cte_tesoreria_detail` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctacte_bancos`
--

DROP TABLE IF EXISTS `ctacte_bancos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctacte_bancos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `codigoBCRA` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctacte_bancos`
--

LOCK TABLES `ctacte_bancos` WRITE;
/*!40000 ALTER TABLE `ctacte_bancos` DISABLE KEYS */;
INSERT INTO `ctacte_bancos` VALUES (1,NULL,'BANCO DE GALICIA Y BUENOS AIRES S.A.',7,NULL,NULL,NULL),(2,NULL,'BANCO DE LA NACION ARGENTINA',11,NULL,NULL,NULL),(3,NULL,'BANCO DE LA PROVINCIA DE BUENOS AIRES',14,NULL,NULL,NULL),(4,NULL,'INDUSTRIAL AND COMMERCIAL BANK OF CHINA',15,NULL,NULL,NULL),(5,NULL,'CITIBANK N.A.',16,NULL,NULL,NULL),(6,NULL,'BBVA BANCO FRANCES S.A.',17,NULL,NULL,NULL),(7,NULL,'THE BANK OF TOKYO-MITSUBISHI UFJ, LTD.',18,NULL,NULL,NULL),(8,NULL,'BANCO DE LA PROVINCIA DE CORDOBA S.A.',20,NULL,NULL,NULL),(9,NULL,'BANCO SUPERVIELLE S.A.',27,NULL,NULL,NULL),(10,NULL,'BANCO DE LA CIUDAD DE BUENOS AIRES',29,NULL,NULL,NULL),(11,NULL,'BANCO PATAGONIA S.A.',34,NULL,NULL,NULL),(12,NULL,'BANCO HIPOTECARIO S.A.',44,NULL,NULL,NULL),(13,NULL,'BANCO DE SAN JUAN S.A.',45,NULL,NULL,NULL),(14,NULL,'BANCO DEL TUCUMAN S.A.',60,NULL,NULL,NULL),(15,NULL,'BANCO MUNICIPAL DE ROSARIO',65,NULL,NULL,NULL),(16,NULL,'BANCO SANTANDER RIO S.A.',72,NULL,NULL,NULL),(17,NULL,'BANCO DEL CHUBUT S.A.',83,NULL,NULL,NULL),(18,NULL,'BANCO DE SANTA CRUZ S.A.',86,NULL,NULL,NULL),(19,NULL,'BANCO DE LA PAMPA SOCIEDAD DE ECONOMÍA M',93,NULL,NULL,NULL),(20,NULL,'BANCO DE CORRIENTES S.A.',94,NULL,NULL,NULL),(21,NULL,'BANCO PROVINCIA DEL NEUQUÉN SOCIEDAD ANÓ',97,NULL,NULL,NULL),(22,NULL,'BANCO INTERFINANZAS S.A.',147,NULL,NULL,NULL),(23,NULL,'HSBC BANK ARGENTINA S.A.',150,NULL,NULL,NULL),(24,NULL,'JPMORGAN CHASE BANK, NATIONAL ASSOCIATIO',165,NULL,NULL,NULL),(25,NULL,'BANCO CREDICOOP COOPERATIVO LIMITADO',191,NULL,NULL,NULL),(26,NULL,'BANCO DE VALORES S.A.',198,NULL,NULL,NULL),(27,NULL,'BANCO ROELA S.A.',247,NULL,NULL,NULL),(28,NULL,'BANCO MARIVA S.A.',254,NULL,NULL,NULL),(29,NULL,'BANCO ITAU ARGENTINA S.A.',259,NULL,NULL,NULL),(30,NULL,'BANK OF AMERICA, NATIONAL ASSOCIATION',262,NULL,NULL,NULL),(31,NULL,'BNP PARIBAS',266,NULL,NULL,NULL),(32,NULL,'BANCO PROVINCIA DE TIERRA DEL FUEGO',268,NULL,NULL,NULL),(33,NULL,'BANCO DE LA REPUBLICA ORIENTAL DEL URUGU',269,NULL,NULL,NULL),(34,NULL,'BANCO SAENZ S.A.',277,NULL,NULL,NULL),(35,NULL,'BANCO MERIDIAN S.A.',281,NULL,NULL,NULL),(36,NULL,'BANCO MACRO S.A.',285,NULL,NULL,NULL),(37,NULL,'BANCO COMAFI SOCIEDAD ANONIMA',299,NULL,NULL,NULL),(38,NULL,'BANCO DE INVERSION Y COMERCIO EXTERIOR S',300,NULL,NULL,NULL),(39,NULL,'BANCO PIANO S.A.',301,NULL,NULL,NULL),(40,NULL,'BANCO JULIO SOCIEDAD ANONIMA',305,NULL,NULL,NULL),(41,NULL,'BANCO RIOJA SOCIEDAD ANONIMA UNIPERSONAL',309,NULL,NULL,NULL),(42,NULL,'BANCO DEL SOL S.A.',310,NULL,NULL,NULL),(43,NULL,'NUEVO BANCO DEL CHACO S. A.',311,NULL,NULL,NULL),(44,NULL,'BANCO VOII S.A.',312,NULL,NULL,NULL),(45,NULL,'BANCO DE FORMOSA S.A.',315,NULL,NULL,NULL),(46,NULL,'BANCO CMF S.A.',319,NULL,NULL,NULL),(47,NULL,'BANCO DE SANTIAGO DEL ESTERO S.A.',321,NULL,NULL,NULL),(48,NULL,'BANCO INDUSTRIAL S.A.',322,NULL,NULL,NULL),(49,NULL,'NUEVO BANCO DE SANTA FE SOCIEDAD ANONIMA',330,NULL,NULL,NULL),(50,NULL,'BANCO CETELEM ARGENTINA S.A.',331,NULL,NULL,NULL),(51,NULL,'BANCO DE SERVICIOS FINANCIEROS S.A.',332,NULL,NULL,NULL),(52,NULL,'BANCO BRADESCO ARGENTINA S.A.U.',336,NULL,NULL,NULL),(53,NULL,'BANCO DE SERVICIOS Y TRANSACCIONES S.A.',338,NULL,NULL,NULL),(54,NULL,'RCI BANQUE S.A.',339,NULL,NULL,NULL),(55,NULL,'BACS BANCO DE CREDITO Y SECURITIZACION S',340,NULL,NULL,NULL),(56,NULL,'BANCO MASVENTAS S.A.',341,NULL,NULL,NULL),(57,NULL,'BANCO WANAP S.A.',384,NULL,NULL,NULL),(58,NULL,'NUEVO BANCO DE ENTRE RÍOS S.A.',386,NULL,NULL,NULL),(59,NULL,'BANCO COLUMBIA S.A.',389,NULL,NULL,NULL),(60,NULL,'BANCO BICA S.A.',426,NULL,NULL,NULL),(61,NULL,'BANCO COINAG S.A.',431,NULL,NULL,NULL),(62,NULL,'BANCO DE COMERCIO S.A.',432,NULL,NULL,NULL),(63,NULL,'FORD CREDIT COMPAÑIA FINANCIERA S.A.',44059,NULL,NULL,NULL),(64,NULL,'COMPAÑIA FINANCIERA ARGENTINA S.A.',44077,NULL,NULL,NULL),(65,NULL,'VOLKWAGEN FINANCIAL SERVICES CIA.FIN.S.A',44088,NULL,NULL,NULL),(66,NULL,'CORDIAL COMPAÑÍA FINANCIERA S.A.',44090,NULL,NULL,NULL),(67,NULL,'FCA COMPAÑIA FINANCIERA S.A.',44092,NULL,NULL,NULL);
INSERT INTO `ctacte_bancos` VALUES (68,NULL,'GPAT COMPAÑIA FINANCIERA S.A.',44093,NULL,NULL,NULL),(69,NULL,'MERCEDES-BENZ COMPAÑÍA FINANCIERA ARGENT',44094,NULL,NULL,NULL),(70,NULL,'ROMBO COMPAÑÍA FINANCIERA S.A.',44095,NULL,NULL,NULL),(71,NULL,'JOHN DEERE CREDIT COMPAÑÍA FINANCIERA S.',44096,NULL,NULL,NULL),(72,NULL,'PSA FINANCE ARGENTINA COMPAÑÍA FINANCIER',44098,NULL,NULL,NULL),(73,NULL,'TOYOTA COMPAÑÍA FINANCIERA DE ARGENTINA',44099,NULL,NULL,NULL),(74,NULL,'FINANDINO COMPAÑIA FINANCIERA S.A.',44100,NULL,NULL,NULL),(75,NULL,'MONTEMAR COMPAÑIA FINANCIERA S.A.',45056,NULL,NULL,NULL),(76,NULL,'MULTIFINANZAS COMPAÑIA FINANCIERA S.A.',45072,NULL,NULL,NULL),(77,NULL,'CAJA DE CREDITO \"CUENCA\" COOPERATIVA LIM',65203,NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctacte_bancos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctacte_bancos_datos`
--

DROP TABLE IF EXISTS `ctacte_bancos_datos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctacte_bancos_datos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cuenta_conta_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuit` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `titular` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `num_cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cbu` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alias` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ctacte_bancos_datos_cuenta_conta_id_foreign` (`cuenta_conta_id`),
  CONSTRAINT `ctacte_bancos_datos_cuenta_conta_id_foreign` FOREIGN KEY (`cuenta_conta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctacte_bancos_datos`
--

LOCK TABLES `ctacte_bancos_datos` WRITE;
/*!40000 ALTER TABLE `ctacte_bancos_datos` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctacte_bancos_datos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctacte_cheques`
--

DROP TABLE IF EXISTS `ctacte_cheques`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctacte_cheques` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `asiento_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuenta_conta_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id2` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id2` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) DEFAULT NULL,
  `cheque3ros` tinyint(1) NOT NULL DEFAULT '0',
  `cheque_emitidos` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `fecha_cobro` date DEFAULT NULL,
  `banco_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `titular` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abierto_cruzado` int(11) NOT NULL DEFAULT '1',
  `numero` int(10) unsigned DEFAULT NULL,
  `foto` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ctacte_cheques_asiento_id_foreign` (`asiento_id`),
  KEY `ctacte_cheques_cuenta_conta_id_foreign` (`cuenta_conta_id`),
  KEY `ctacte_cheques_banco_id_foreign` (`banco_id`),
  KEY `ctacte_cheques_person_id_foreign` (`person_id`),
  KEY `ctacte_cheques_cta_cte_cliente_id2_foreign` (`cta_cte_cliente_id2`),
  KEY `ctacte_cheques_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_tesorer_id` (`cta_cte_tesoreria_id`),
  KEY `ctacte_cheques_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `ctacte_cheques_nf_cta_cte_id2_foreign` (`nf_cta_cte_id2`),
  KEY `ctacte_cheques_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `cta_cte_tesorer_id` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `ctacte_cheques_banco_id_foreign` FOREIGN KEY (`banco_id`) REFERENCES `ctacte_bancos` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_cliente_id2_foreign` FOREIGN KEY (`cta_cte_cliente_id2`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctacte_cheques_cuenta_conta_id_foreign` FOREIGN KEY (`cuenta_conta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `ctacte_cheques_nf_cta_cte_id2_foreign` FOREIGN KEY (`nf_cta_cte_id2`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `ctacte_cheques_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `ctacte_cheques_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctacte_cheques`
--

LOCK TABLES `ctacte_cheques` WRITE;
/*!40000 ALTER TABLE `ctacte_cheques` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctacte_cheques` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_centrocosto`
--

DROP TABLE IF EXISTS `ctactegastos_centrocosto`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_centrocosto` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_centrocosto`
--

LOCK TABLES `ctactegastos_centrocosto` WRITE;
/*!40000 ALTER TABLE `ctactegastos_centrocosto` DISABLE KEYS */;
INSERT INTO `ctactegastos_centrocosto` VALUES (1,NULL,'OFICINA',NULL,NULL,NULL),(2,NULL,'FIJO',NULL,NULL,NULL),(3,NULL,'VARIABLE',NULL,NULL,NULL),(4,NULL,'GISELA',NULL,NULL,NULL),(5,NULL,'LIA',NULL,NULL,NULL),(6,NULL,'PADRES',NULL,NULL,NULL),(7,NULL,'CASA',NULL,NULL,NULL),(8,NULL,'VANESA',NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctactegastos_centrocosto` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_cuenta_tipo`
--

DROP TABLE IF EXISTS `ctactegastos_cuenta_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_cuenta_tipo` (
  `idCuentaTipo` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `idTipo` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`idCuentaTipo`),
  KEY `ctactegastos_cuenta_tipo_idtipo_foreign` (`idTipo`),
  KEY `ctactegastos_cuenta_tipo_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `ctactegastos_cuenta_tipo_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctactegastos_cuenta_tipo_idtipo_foreign` FOREIGN KEY (`idTipo`) REFERENCES `ctactegastos_tiposdegastos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_cuenta_tipo`
--

LOCK TABLES `ctactegastos_cuenta_tipo` WRITE;
/*!40000 ALTER TABLE `ctactegastos_cuenta_tipo` DISABLE KEYS */;
INSERT INTO `ctactegastos_cuenta_tipo` VALUES (1,NULL,NULL,3,NULL,NULL,NULL),(2,NULL,NULL,6,NULL,NULL,NULL),(3,NULL,NULL,3,NULL,NULL,NULL),(4,NULL,NULL,4,NULL,NULL,NULL),(5,NULL,NULL,5,NULL,NULL,NULL),(6,NULL,NULL,3,NULL,NULL,NULL),(7,NULL,NULL,4,NULL,NULL,NULL),(8,NULL,NULL,3,NULL,NULL,NULL),(9,NULL,NULL,4,NULL,NULL,NULL),(10,NULL,NULL,7,NULL,NULL,NULL),(11,NULL,NULL,8,NULL,NULL,NULL),(12,NULL,NULL,3,NULL,NULL,NULL),(13,NULL,NULL,3,NULL,NULL,NULL),(14,NULL,NULL,4,NULL,NULL,NULL),(15,NULL,NULL,1,NULL,NULL,NULL),(16,NULL,NULL,2,NULL,NULL,NULL),(17,NULL,NULL,5,NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctactegastos_cuenta_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_mensuales`
--

DROP TABLE IF EXISTS `ctactegastos_mensuales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_mensuales` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `CuentaTipo_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL DEFAULT '13',
  `TipoDeGasto_id` int(10) unsigned NOT NULL,
  `CentroCosto_id` int(10) unsigned NOT NULL,
  `gasto_cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL DEFAULT '13',
  `monto` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ctactegastos_mensuales_cuentatipo_id_foreign` (`CuentaTipo_id`),
  KEY `ctactegastos_mensuales_tipodegasto_id_foreign` (`TipoDeGasto_id`),
  KEY `ctactegastos_mensuales_centrocosto_id_foreign` (`CentroCosto_id`),
  KEY `ctactegastos_mensuales_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `ctactegastos_mensuales_gasto_cta_cte_tesoreria_cuenta_id_foreign` (`gasto_cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `ctactegastos_mensuales_centrocosto_id_foreign` FOREIGN KEY (`CentroCosto_id`) REFERENCES `ctactegastos_centrocosto` (`id`),
  CONSTRAINT `ctactegastos_mensuales_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctactegastos_mensuales_cuentatipo_id_foreign` FOREIGN KEY (`CuentaTipo_id`) REFERENCES `ctactegastos_cuenta_tipo` (`idCuentaTipo`),
  CONSTRAINT `ctactegastos_mensuales_gasto_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`gasto_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctactegastos_mensuales_tipodegasto_id_foreign` FOREIGN KEY (`TipoDeGasto_id`) REFERENCES `ctactegastos_tiposdegastos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_mensuales`
--

LOCK TABLES `ctactegastos_mensuales` WRITE;
/*!40000 ALTER TABLE `ctactegastos_mensuales` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctactegastos_mensuales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_tiposdegastos`
--

DROP TABLE IF EXISTS `ctactegastos_tiposdegastos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_tiposdegastos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_tiposdegastos`
--

LOCK TABLES `ctactegastos_tiposdegastos` WRITE;
/*!40000 ALTER TABLE `ctactegastos_tiposdegastos` DISABLE KEYS */;
INSERT INTO `ctactegastos_tiposdegastos` VALUES (1,NULL,'Oficina',NULL,NULL,NULL),(2,NULL,'Personales',NULL,NULL,NULL),(3,NULL,'Tarjeta VISA',NULL,NULL,NULL),(4,NULL,'Tarjeta Mastercard',NULL,NULL,NULL),(5,NULL,'Debito Automatico',NULL,NULL,NULL),(6,NULL,'American Express',NULL,NULL,NULL),(7,NULL,'Tarjeta Shopping',NULL,NULL,NULL),(8,NULL,'Tarjeta Cencosud',NULL,NULL,NULL),(9,NULL,'Tarjeta Coto',NULL,NULL,NULL),(10,NULL,'Tarjeta Nativa',NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctactegastos_tiposdegastos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cursos`
--

DROP TABLE IF EXISTS `cursos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cursos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `fecha` date DEFAULT NULL,
  `hora` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `profesor` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cant_clases` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `duracion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `adjuntos` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `link_zoom` longtext COLLATE utf8mb4_unicode_ci,
  `cod_zoom` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contraseña_zoom` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `link_youtube` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `materiales` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cursos`
--

LOCK TABLES `cursos` WRITE;
/*!40000 ALTER TABLE `cursos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cursos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cursos_detail`
--

DROP TABLE IF EXISTS `cursos_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cursos_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `curso_id` int(10) unsigned NOT NULL,
  `field_name1` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `celular` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cursos_detail_curso_id_foreign` (`curso_id`),
  CONSTRAINT `cursos_detail_curso_id_foreign` FOREIGN KEY (`curso_id`) REFERENCES `cursos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cursos_detail`
--

LOCK TABLES `cursos_detail` WRITE;
/*!40000 ALTER TABLE `cursos_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `cursos_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `data_types`
--

DROP TABLE IF EXISTS `data_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `data_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `data_types_description_unique` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `data_types`
--

LOCK TABLES `data_types` WRITE;
/*!40000 ALTER TABLE `data_types` DISABLE KEYS */;
INSERT INTO `data_types` VALUES (1,'Comprobantes XLS',1,'Importación','XLS','data/imports/receipts/xls',NULL,NULL),(2,'CITI-Ventas',1,'Importación','TXT','data/imports/receipts/CitiVentas',NULL,NULL),(3,'CITI Compras',2,'Exportación','TXT','data/exports/receipts/citi',NULL,NULL),(4,'CITI Ventas',2,'Exportación','TXT','data/exports/receipts/CitiVentasExport',NULL,NULL),(5,'Convenio Multilateral',2,'Exportación','TXT','data/exports/receipts/convenio',NULL,NULL),(6,'Libro IVA Digital',2,'Exportación','TXT','data/exports/receipts/libro_iva_digital',NULL,'2019-11-20 21:43:44'),(7,'Mis Comprobantes',1,'Importacion','','data/imports/receipts/mis_comprobantes',NULL,NULL),(8,'Consulta AFIP',3,'AFIP','','data/afip/index','2019-12-06 14:49:55','2019-12-06 14:49:55');
/*!40000 ALTER TABLE `data_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_estados`
--

DROP TABLE IF EXISTS `dc_estados`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_estados` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_estados`
--

LOCK TABLES `dc_estados` WRITE;
/*!40000 ALTER TABLE `dc_estados` DISABLE KEYS */;
INSERT INTO `dc_estados` VALUES (1,NULL,'PEDIDO',1,NULL,NULL,NULL),(2,NULL,'ACEPTADO',1,NULL,NULL,NULL),(3,NULL,'RECHAZADO',1,NULL,NULL,NULL),(4,NULL,'PAGADO',1,NULL,NULL,NULL),(5,NULL,'CONCILIADO',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `dc_estados` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes`
--

DROP TABLE IF EXISTS `dc_ordenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_tipo_id` bigint(20) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `numero` int(11) NOT NULL,
  `sector` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `solicitante` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha` date NOT NULL,
  `fecha_entrega` date DEFAULT NULL,
  `cantidades` decimal(16,2) NOT NULL,
  `neto` decimal(16,2) NOT NULL,
  `iva` decimal(16,2) NOT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `dc_estado_id` bigint(20) unsigned NOT NULL,
  `conta_cc_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_dc_orden_tipo_id_foreign` (`dc_orden_tipo_id`),
  KEY `dc_ordenes_person_id_foreign` (`person_id`),
  KEY `dc_ordenes_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `dc_ordenes_dc_estado_id_foreign` (`dc_estado_id`),
  KEY `dc_ordenes_conta_cc_id_foreign` (`conta_cc_id`),
  CONSTRAINT `dc_ordenes_conta_cc_id_foreign` FOREIGN KEY (`conta_cc_id`) REFERENCES `conta_centro_costos` (`id`),
  CONSTRAINT `dc_ordenes_dc_estado_id_foreign` FOREIGN KEY (`dc_estado_id`) REFERENCES `dc_estados` (`id`),
  CONSTRAINT `dc_ordenes_dc_orden_tipo_id_foreign` FOREIGN KEY (`dc_orden_tipo_id`) REFERENCES `dc_ordenes_tipos` (`id`),
  CONSTRAINT `dc_ordenes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `dc_ordenes_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes`
--

LOCK TABLES `dc_ordenes` WRITE;
/*!40000 ALTER TABLE `dc_ordenes` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_details`
--

DROP TABLE IF EXISTS `dc_ordenes_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `cantidades` decimal(16,2) NOT NULL,
  `inv_producto_id` bigint(20) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `neto` decimal(16,2) NOT NULL,
  `desc_porc` decimal(16,2) DEFAULT NULL,
  `descuento` decimal(16,2) DEFAULT NULL,
  `system_tax_id` int(10) unsigned NOT NULL,
  `iva` decimal(16,2) NOT NULL,
  `subtotal` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_details_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_details_inv_producto_id_foreign` (`inv_producto_id`),
  KEY `dc_ordenes_details_system_tax_id_foreign` (`system_tax_id`),
  CONSTRAINT `dc_ordenes_details_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_details_inv_producto_id_foreign` FOREIGN KEY (`inv_producto_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `dc_ordenes_details_system_tax_id_foreign` FOREIGN KEY (`system_tax_id`) REFERENCES `system_taxes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_details`
--

LOCK TABLES `dc_ordenes_details` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_tipos`
--

DROP TABLE IF EXISTS `dc_ordenes_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_tipos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_tipos`
--

LOCK TABLES `dc_ordenes_tipos` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_tipos` DISABLE KEYS */;
INSERT INTO `dc_ordenes_tipos` VALUES (1,NULL,'COMPRAS',1,NULL,NULL,NULL),(2,NULL,'VENTAS',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `dc_ordenes_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `deudas_impositivas`
--

DROP TABLE IF EXISTS `deudas_impositivas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `deudas_impositivas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `vto_impuesto_id` int(10) unsigned NOT NULL,
  `periodo_deuda` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `concepto` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `deudas_impositivas_vto_impuesto_id_foreign` (`vto_impuesto_id`),
  KEY `deudas_impositivas_person_id_foreign` (`person_id`),
  CONSTRAINT `deudas_impositivas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `deudas_impositivas_vto_impuesto_id_foreign` FOREIGN KEY (`vto_impuesto_id`) REFERENCES `vto_impuestos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `deudas_impositivas`
--

LOCK TABLES `deudas_impositivas` WRITE;
/*!40000 ALTER TABLE `deudas_impositivas` DISABLE KEYS */;
/*!40000 ALTER TABLE `deudas_impositivas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ejer_anteriores`
--

DROP TABLE IF EXISTS `ejer_anteriores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ejer_anteriores` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `anio` int(11) NOT NULL,
  `ventas` decimal(16,2) DEFAULT NULL,
  `compras` decimal(16,2) DEFAULT NULL,
  `sueldos` decimal(16,2) DEFAULT NULL,
  `impuesto` decimal(16,2) DEFAULT NULL,
  `apagar` decimal(16,2) DEFAULT NULL,
  `afavor` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ejer_anteriores_person_id_foreign` (`person_id`),
  CONSTRAINT `ejer_anteriores_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ejer_anteriores`
--

LOCK TABLES `ejer_anteriores` WRITE;
/*!40000 ALTER TABLE `ejer_anteriores` DISABLE KEYS */;
/*!40000 ALTER TABLE `ejer_anteriores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estado_civil`
--

DROP TABLE IF EXISTS `estado_civil`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estado_civil` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `estado_civil_descripcion_unique` (`descripcion`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estado_civil`
--

LOCK TABLES `estado_civil` WRITE;
/*!40000 ALTER TABLE `estado_civil` DISABLE KEYS */;
INSERT INTO `estado_civil` VALUES (1,NULL,'Separado Legal',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(2,NULL,'Separado de Hecho',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(3,NULL,'Divorciado',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(4,NULL,'Convivencia',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(5,NULL,'Soltero',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(6,NULL,'Casado',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(7,NULL,'Viudo',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL);
/*!40000 ALTER TABLE `estado_civil` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fa_masiva`
--

DROP TABLE IF EXISTS `fa_masiva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fa_masiva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `person_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fa_masiva`
--

LOCK TABLES `fa_masiva` WRITE;
/*!40000 ALTER TABLE `fa_masiva` DISABLE KEYS */;
/*!40000 ALTER TABLE `fa_masiva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fa_masiva_detalle`
--

DROP TABLE IF EXISTS `fa_masiva_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fa_masiva_detalle` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fa_masiva_id` int(11) NOT NULL,
  `cliente_id` int(11) NOT NULL,
  `tipo_comprobante_id` int(10) unsigned NOT NULL DEFAULT '1',
  `zone_id` int(10) unsigned NOT NULL DEFAULT '22',
  `activity_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cond_frente_iva_id` int(10) unsigned NOT NULL DEFAULT '1',
  `system_tax_id` int(10) unsigned NOT NULL DEFAULT '1',
  `concepto_id` int(10) unsigned NOT NULL DEFAULT '1',
  `taxable_iibb` int(10) unsigned NOT NULL DEFAULT '2',
  `renglon1` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe1` decimal(20,2) DEFAULT NULL,
  `renglon2` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe2` decimal(20,2) DEFAULT NULL,
  `renglon3` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe3` decimal(20,2) DEFAULT NULL,
  `punto_venta_id` int(11) DEFAULT NULL,
  `fecha_comprobante` date DEFAULT NULL,
  `fecha_facturado_desde` date DEFAULT NULL,
  `fecha_facturado_hasta` date DEFAULT NULL,
  `fecha_vencimiento_pago` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fa_masiva_detalle_concepto_id_foreign` (`concepto_id`),
  KEY `fa_masiva_detalle_system_tax_id_foreign` (`system_tax_id`),
  KEY `fa_masiva_detalle_cond_frente_iva_id_foreign` (`cond_frente_iva_id`),
  KEY `fa_masiva_detalle_zone_id_foreign` (`zone_id`),
  KEY `fa_masiva_detalle_tipo_comprobante_id_foreign` (`tipo_comprobante_id`),
  KEY `fa_masiva_detalle_activity_id_foreign` (`activity_id`),
  CONSTRAINT `fa_masiva_detalle_activity_id_foreign` FOREIGN KEY (`activity_id`) REFERENCES `activities` (`id`),
  CONSTRAINT `fa_masiva_detalle_concepto_id_foreign` FOREIGN KEY (`concepto_id`) REFERENCES `fact_elec_conceptos_afip` (`id`),
  CONSTRAINT `fa_masiva_detalle_cond_frente_iva_id_foreign` FOREIGN KEY (`cond_frente_iva_id`) REFERENCES `fac_elec_cond_frente_iva` (`id`),
  CONSTRAINT `fa_masiva_detalle_system_tax_id_foreign` FOREIGN KEY (`system_tax_id`) REFERENCES `system_taxes` (`id`),
  CONSTRAINT `fa_masiva_detalle_tipo_comprobante_id_foreign` FOREIGN KEY (`tipo_comprobante_id`) REFERENCES `receipt_types` (`id`),
  CONSTRAINT `fa_masiva_detalle_zone_id_foreign` FOREIGN KEY (`zone_id`) REFERENCES `zones` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fa_masiva_detalle`
--

LOCK TABLES `fa_masiva_detalle` WRITE;
/*!40000 ALTER TABLE `fa_masiva_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `fa_masiva_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fa_masiva_stock`
--

DROP TABLE IF EXISTS `fa_masiva_stock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fa_masiva_stock` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fa_masiva_stock_person_id_foreign` (`person_id`),
  KEY `fa_masiva_stock_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `fa_masiva_stock_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `fa_masiva_stock_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fa_masiva_stock`
--

LOCK TABLES `fa_masiva_stock` WRITE;
/*!40000 ALTER TABLE `fa_masiva_stock` DISABLE KEYS */;
/*!40000 ALTER TABLE `fa_masiva_stock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fac_elec_cond_frente_iva`
--

DROP TABLE IF EXISTS `fac_elec_cond_frente_iva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fac_elec_cond_frente_iva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `fac_elec_cond_frente_iva_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fac_elec_cond_frente_iva`
--

LOCK TABLES `fac_elec_cond_frente_iva` WRITE;
/*!40000 ALTER TABLE `fac_elec_cond_frente_iva` DISABLE KEYS */;
INSERT INTO `fac_elec_cond_frente_iva` VALUES (1,'IVA Responsable Inscripto','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(2,'IVA Sujeto Exento','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(3,'Consumidor Final','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(4,'Responsable Monotributo','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(5,'Proveedor del Exterior','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(6,'Cliente del Exterior','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(7,'IVA Liberado - Ley Nº 19.640','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(8,'IVA Responsable Inscripto - Agente de Percepción','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(9,'Monotributista Social','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(10,'IVA No Alcanzado','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL);
/*!40000 ALTER TABLE `fac_elec_cond_frente_iva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fac_elec_unidad_medidas`
--

DROP TABLE IF EXISTS `fac_elec_unidad_medidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fac_elec_unidad_medidas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `fac_elec_unidad_medidas_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fac_elec_unidad_medidas`
--

LOCK TABLES `fac_elec_unidad_medidas` WRITE;
/*!40000 ALTER TABLE `fac_elec_unidad_medidas` DISABLE KEYS */;
INSERT INTO `fac_elec_unidad_medidas` VALUES (1,'Grs','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(2,'Kg','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(3,'Mts','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(4,'Mts2','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(5,'Mts3','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(6,'Lts','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(7,'1000 Kwh','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(8,'Unidades','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(9,'Pares','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(10,'Doc','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(11,'Quilates','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(12,'Millares','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(13,'Milimetros','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(14,'Mm 3','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(15,'Km','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(16,'Hectolitros','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(17,'Cm','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(18,'Cm 3','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL);
/*!40000 ALTER TABLE `fac_elec_unidad_medidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_conceptos_afip`
--

DROP TABLE IF EXISTS `fact_elec_conceptos_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_conceptos_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `afip_comprobante_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_conceptos_afip`
--

LOCK TABLES `fact_elec_conceptos_afip` WRITE;
/*!40000 ALTER TABLE `fact_elec_conceptos_afip` DISABLE KEYS */;
INSERT INTO `fact_elec_conceptos_afip` VALUES (1,1,'Producto','2019-03-13 13:29:34','2019-03-13 13:29:34'),(2,2,'Servicios','2019-03-13 13:29:34','2019-03-13 13:29:34'),(3,3,'Productos y Servicios','2019-03-13 13:29:34','2019-03-13 13:29:34');
/*!40000 ALTER TABLE `fact_elec_conceptos_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_puntos_venta`
--

DROP TABLE IF EXISTS `fact_elec_puntos_venta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_puntos_venta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `direccion` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `codigo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '0000',
  `codigo_postal` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zone_id` int(11) DEFAULT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_puntos_venta_person_id_foreign` (`person_id`),
  CONSTRAINT `fact_elec_puntos_venta_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_puntos_venta`
--

LOCK TABLES `fact_elec_puntos_venta` WRITE;
/*!40000 ALTER TABLE `fact_elec_puntos_venta` DISABLE KEYS */;
/*!40000 ALTER TABLE `fact_elec_puntos_venta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_receipt_details`
--

DROP TABLE IF EXISTS `fact_elec_receipt_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_receipt_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fact_elec_receipt_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `cantidad` decimal(20,2) NOT NULL,
  `unidad_medida` text COLLATE utf8mb4_unicode_ci,
  `precio_unitario` decimal(20,2) NOT NULL,
  `neto_gravado` decimal(20,2) NOT NULL,
  `bonificacion_porcentaje` decimal(20,2) DEFAULT NULL,
  `bonificacion_monto` decimal(20,2) DEFAULT NULL,
  `bonificacion_subtotal` decimal(20,2) DEFAULT NULL,
  `system_tax_id` int(10) unsigned NOT NULL DEFAULT '1',
  `iva_monto` decimal(20,2) DEFAULT NULL,
  `iva_subtotal` decimal(20,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `codigo` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_receipt_details_fact_elec_receipt_id_foreign` (`fact_elec_receipt_id`),
  KEY `fact_elec_receipt_details_system_tax_id_foreign` (`system_tax_id`),
  CONSTRAINT `fact_elec_receipt_details_fact_elec_receipt_id_foreign` FOREIGN KEY (`fact_elec_receipt_id`) REFERENCES `fact_elec_receipts` (`id`),
  CONSTRAINT `fact_elec_receipt_details_system_tax_id_foreign` FOREIGN KEY (`system_tax_id`) REFERENCES `system_taxes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_receipt_details`
--

LOCK TABLES `fact_elec_receipt_details` WRITE;
/*!40000 ALTER TABLE `fact_elec_receipt_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `fact_elec_receipt_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_receipts`
--

DROP TABLE IF EXISTS `fact_elec_receipts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_receipts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `fecha_comprobante` date NOT NULL,
  `fecha_facturado_desde` date DEFAULT NULL,
  `fecha_facturado_hasta` date DEFAULT NULL,
  `fecha_vencimiento_pago` date DEFAULT NULL,
  `concepto_id` int(10) unsigned NOT NULL,
  `punto_venta_id` int(10) unsigned NOT NULL,
  `tipo_comprobante_id` int(10) unsigned NOT NULL,
  `condiciones_venta` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comprobante_asoc` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `cae` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cae_vencimiento` date DEFAULT NULL,
  `nro_comprobante_afip` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha_proceso_afip` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_receptor` int(10) unsigned NOT NULL,
  `condicion_venta_id` int(11) DEFAULT NULL,
  `cond_frente_iva_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cbu` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `opcion_transferencia` longtext COLLATE utf8mb4_unicode_ci,
  `alias_cbu` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_receipts_user_id_foreign` (`user_id`),
  KEY `fact_elec_receipts_punto_venta_id_foreign` (`punto_venta_id`),
  KEY `fact_elec_receipts_tipo_comprobante_id_foreign` (`tipo_comprobante_id`),
  KEY `fact_elec_receipts_person_id_foreign` (`person_id`),
  KEY `fact_elec_receipts_person_id_receptor_foreign` (`person_id_receptor`),
  KEY `fact_elec_receipts_cond_frente_iva_id_foreign` (`cond_frente_iva_id`),
  CONSTRAINT `fact_elec_receipts_cond_frente_iva_id_foreign` FOREIGN KEY (`cond_frente_iva_id`) REFERENCES `condicion_frente_al_iva` (`id`),
  CONSTRAINT `fact_elec_receipts_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `fact_elec_receipts_person_id_receptor_foreign` FOREIGN KEY (`person_id_receptor`) REFERENCES `persons` (`id`),
  CONSTRAINT `fact_elec_receipts_punto_venta_id_foreign` FOREIGN KEY (`punto_venta_id`) REFERENCES `fact_elec_puntos_venta` (`id`),
  CONSTRAINT `fact_elec_receipts_tipo_comprobante_id_foreign` FOREIGN KEY (`tipo_comprobante_id`) REFERENCES `receipt_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_receipts`
--

LOCK TABLES `fact_elec_receipts` WRITE;
/*!40000 ALTER TABLE `fact_elec_receipts` DISABLE KEYS */;
/*!40000 ALTER TABLE `fact_elec_receipts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_tipos_docs_afip`
--

DROP TABLE IF EXISTS `fact_elec_tipos_docs_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_tipos_docs_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `afip_tipo_doc_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=100 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_tipos_docs_afip`
--

LOCK TABLES `fact_elec_tipos_docs_afip` WRITE;
/*!40000 ALTER TABLE `fact_elec_tipos_docs_afip` DISABLE KEYS */;
INSERT INTO `fact_elec_tipos_docs_afip` VALUES (1,1,'CI Buenos Aires','2019-03-13 13:29:34','2019-03-13 13:29:34'),(2,2,'CI Catamarca','2019-03-13 13:29:34','2019-03-13 13:29:34'),(3,3,'CI Córdoba','2019-03-13 13:29:34','2019-03-13 13:29:34'),(4,4,'CI Corrientes','2019-03-13 13:29:34','2019-03-13 13:29:34'),(5,5,'CI Entre Ríos','2019-03-13 13:29:34','2019-03-13 13:29:34'),(6,6,'CI Jujuy','2019-03-13 13:29:34','2019-03-13 13:29:34'),(7,7,'CI Mendoza','2019-03-13 13:29:34','2019-03-13 13:29:34'),(8,8,'CI La Rioja','2019-03-13 13:29:34','2019-03-13 13:29:34'),(9,9,'CI Salta','2019-03-13 13:29:34','2019-03-13 13:29:34'),(10,10,'CI San Juan','2019-03-13 13:29:34','2019-03-13 13:29:34'),(11,11,'CI San Luis','2019-03-13 13:29:34','2019-03-13 13:29:34'),(12,12,'CI Santa Fe','2019-03-13 13:29:34','2019-03-13 13:29:34'),(13,13,'CI Santiago del Estero','2019-03-13 13:29:34','2019-03-13 13:29:34'),(14,14,'CI Tucumán','2019-03-13 13:29:34','2019-03-13 13:29:34'),(16,16,'CI Chaco','2019-03-13 13:29:34','2019-03-13 13:29:34'),(17,17,'CI Chubut','2019-03-13 13:29:34','2019-03-13 13:29:34'),(18,18,'CI Formosa','2019-03-13 13:29:34','2019-03-13 13:29:34'),(19,19,'CI Misiones','2019-03-13 13:29:34','2019-03-13 13:29:34'),(20,20,'CI Neuquén','2019-03-13 13:29:34','2019-03-13 13:29:34'),(21,21,'CI La Pampa','2019-03-13 13:29:34','2019-03-13 13:29:34'),(22,22,'CI Río Negro','2019-03-13 13:29:34','2019-03-13 13:29:34'),(23,23,'CI Santa Cruz','2019-03-13 13:29:34','2019-03-13 13:29:34'),(24,24,'CI Tierra del Fuego','2019-03-13 13:29:34','2019-03-13 13:29:34'),(80,80,'CUIT','2019-03-13 13:29:34','2019-03-13 13:29:34'),(86,86,'CUIL','2019-03-13 13:29:34','2019-03-13 13:29:34'),(87,87,'CDI','2019-03-13 13:29:34','2019-03-13 13:29:34'),(89,89,'LE','2019-03-13 13:29:34','2019-03-13 13:29:34'),(90,90,'LC','2019-03-13 13:29:34','2019-03-13 13:29:34'),(91,91,'CI Extranjera','2019-03-13 13:29:34','2019-03-13 13:29:34'),(92,92,'en trámite','2019-03-13 13:29:34','2019-03-13 13:29:34'),(93,93,'Acta Nacimiento','2019-03-13 13:29:34','2019-03-13 13:29:34'),(94,94,'Pasaporte','2019-03-13 13:29:34','2019-03-13 13:29:34'),(95,95,'CI Bs. As. RNP','2019-03-13 13:29:34','2019-03-13 13:29:34'),(96,96,'DNI','2019-03-13 13:29:34','2019-03-13 13:29:34'),(97,0,'CI Policía Federal','2019-03-13 13:29:34','2019-03-13 13:29:34'),(99,99,'Doc. (Otro)','2019-03-13 13:29:34','2019-03-13 13:29:34');
/*!40000 ALTER TABLE `fact_elec_tipos_docs_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq`
--

DROP TABLE IF EXISTS `faq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `faq` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pregunta` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `respuesta` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq`
--

LOCK TABLES `faq` WRITE;
/*!40000 ALTER TABLE `faq` DISABLE KEYS */;
/*!40000 ALTER TABLE `faq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `file_upload_details`
--

DROP TABLE IF EXISTS `file_upload_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `file_upload_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `file_upload_id` int(10) unsigned NOT NULL,
  `detail` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `file_upload_details_file_upload_id_foreign` (`file_upload_id`),
  CONSTRAINT `file_upload_details_file_upload_id_foreign` FOREIGN KEY (`file_upload_id`) REFERENCES `file_uploads` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `file_upload_details`
--

LOCK TABLES `file_upload_details` WRITE;
/*!40000 ALTER TABLE `file_upload_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `file_upload_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `file_uploads`
--

DROP TABLE IF EXISTS `file_uploads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `file_uploads` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `data_type_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `file_uploads_data_type_id_foreign` (`data_type_id`),
  KEY `file_uploads_user_id_foreign` (`user_id`),
  KEY `file_uploads_person_id_foreign` (`person_id`),
  KEY `file_uploads_period_id_foreign` (`period_id`),
  CONSTRAINT `file_uploads_data_type_id_foreign` FOREIGN KEY (`data_type_id`) REFERENCES `data_types` (`id`),
  CONSTRAINT `file_uploads_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `file_uploads_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `file_uploads_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `tusers` (`idUser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `file_uploads`
--

LOCK TABLES `file_uploads` WRITE;
/*!40000 ALTER TABLE `file_uploads` DISABLE KEYS */;
/*!40000 ALTER TABLE `file_uploads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_art_90`
--

DROP TABLE IF EXISTS `ganan_art_90`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_art_90` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `anio` int(10) unsigned NOT NULL,
  `desde` decimal(16,2) NOT NULL DEFAULT '0.00',
  `hasta` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `mas_porcentaje` decimal(16,2) NOT NULL DEFAULT '0.00',
  `excedente` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_art_90`
--

LOCK TABLES `ganan_art_90` WRITE;
/*!40000 ALTER TABLE `ganan_art_90` DISABLE KEYS */;
INSERT INTO `ganan_art_90` VALUES (1,2017,0.00,20000.00,0.00,0.05,0.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(2,2017,20000.00,40000.00,1000.00,0.09,20000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(3,2017,40000.00,60000.00,2800.00,0.12,40000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(4,2017,60000.00,80000.00,5200.00,0.15,60000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(5,2017,80000.00,120000.00,8200.00,0.19,80000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(6,2017,120000.00,160000.00,15800.00,0.23,120000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(7,2017,160000.00,240000.00,25000.00,0.27,160000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(8,2017,240000.00,320000.00,46600.00,0.31,240000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(9,2017,320000.00,999999999.99,71400.00,0.35,320000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(10,2018,0.00,25754.00,0.00,0.05,0.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(11,2018,25754.00,51508.00,1287.70,0.09,25754.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(12,2018,51508.00,77262.00,3605.56,0.12,51508.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(13,2018,77262.00,103016.00,6696.04,0.15,77262.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(14,2018,103016.00,154524.00,10559.14,0.19,103016.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(15,2018,154524.00,206032.00,20345.66,0.23,154524.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(16,2018,206032.00,309048.00,32192.50,0.27,206032.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(17,2018,309048.00,412064.00,60006.82,0.31,309048.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(18,2018,412064.00,999999999.99,91941.78,0.35,412064.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(19,2019,0.00,33039.81,0.00,0.05,0.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(20,2019,33039.81,66079.61,1651.99,0.09,33039.81,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(21,2019,66079.61,99119.42,4625.57,0.12,66079.61,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(22,2019,99119.42,132159.23,8590.35,0.15,99119.42,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(23,2019,132159.23,198238.84,13546.32,0.19,132159.23,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(24,2019,198238.84,264318.45,26101.45,0.23,198238.84,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(25,2019,264318.45,396477.68,41299.76,0.27,264318.45,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(26,2019,396477.68,528636.91,76982.75,0.31,396477.68,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(27,2019,528636.91,999999999.99,117952.11,0.35,528636.91,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(28,2016,0.00,10000.00,0.00,0.09,0.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(29,2016,10000.00,20000.00,900.00,0.14,10000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(30,2016,20000.00,30000.00,2300.00,0.19,20000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(31,2016,30000.00,60000.00,4200.00,0.23,30000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(32,2016,60000.00,90000.00,11100.00,0.27,60000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(33,2016,90000.00,120000.00,19200.00,0.31,90000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(34,2016,120000.00,999999999.00,28500.00,0.35,120000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(37,2020,0.00,47669.16,0.00,0.05,0.00,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(38,2020,47669.16,95338.32,2383.46,0.09,47669.16,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(39,2020,95338.32,143007.48,6673.68,0.12,95338.32,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(40,2020,143007.48,190676.65,12393.98,0.15,143007.48,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(41,2020,190676.65,286014.96,19544.36,0.19,190676.65,'2020-01-28 14:17:39','2021-03-17 22:06:03',NULL),(42,2020,286014.96,381353.28,37658.64,0.23,286014.96,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL);
INSERT INTO `ganan_art_90` VALUES (43,2020,381353.28,572029.92,59586.45,0.27,381353.28,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(44,2020,572029.92,762706.57,111069.14,0.31,572029.92,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(45,2020,762706.57,999999999.99,170178.90,0.35,762706.57,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(46,2021,0.00,64532.64,0.00,0.05,0.00,'2021-03-17 22:06:03','2021-03-17 22:06:03',NULL),(47,2021,64532.64,129065.29,3226.63,0.09,64532.64,'2021-03-17 22:06:03','2021-03-17 22:06:03',NULL),(48,2021,129065.29,193597.93,9034.57,0.12,129065.29,'2021-03-17 22:06:03','2021-03-17 22:06:03',NULL),(49,2021,193597.93,258130.58,16778.49,0.15,193597.93,'2021-03-17 22:06:03','2021-03-17 22:06:03',NULL),(50,2021,258130.58,387195.86,26458.39,0.19,258130.58,'2021-03-17 22:06:03','2021-03-17 22:06:03',NULL),(51,2021,387195.86,516261.14,50980.79,0.23,387195.86,'2021-03-17 22:06:03','2022-06-07 11:08:19',NULL),(52,2021,516261.14,774391.71,80665.80,0.27,516261.14,'2021-03-17 22:06:03','2021-03-17 22:06:03',NULL),(53,2021,774391.71,1032522.30,150361.06,0.31,774391.71,'2021-03-17 22:06:03','2021-03-17 22:06:03',NULL),(54,2021,1032522.30,999999999.99,230381.54,0.35,1032522.30,'2021-03-17 22:06:03','2021-03-17 22:06:03',NULL),(55,2022,0.00,97201.99,0.00,0.05,0.00,'2022-01-11 14:02:38','2022-02-06 22:38:32',NULL),(56,2022,97201.99,194404.01,4860.10,0.09,97201.99,'2022-01-11 14:02:38','2022-01-11 14:02:38',NULL),(57,2022,194404.01,291606.01,13608.29,0.12,194404.01,'2022-01-11 14:02:38','2022-01-11 14:02:38',NULL),(58,2022,291606.01,388808.02,25272.52,0.15,291606.01,'2022-01-11 14:02:38','2022-01-11 14:02:38',NULL),(59,2022,388808.02,583212.02,39852.82,0.19,388808.02,'2022-01-11 14:02:38','2022-01-11 14:02:38',NULL),(60,2022,583212.02,777616.02,76789.59,0.23,583212.02,'2022-01-11 14:02:38','2022-01-11 14:02:38',NULL),(61,2022,777616.02,1166424.03,121502.49,0.27,777616.02,'2022-01-11 14:02:38','2022-01-11 14:02:38',NULL),(62,2022,1166424.03,1555232.07,226480.67,0.31,1166424.03,'2022-01-11 14:02:38','2022-01-11 14:02:38',NULL),(63,2022,1555232.07,9999999.00,347011.15,0.35,1555232.07,'2022-01-11 14:02:38','2022-01-11 14:02:38',NULL);
/*!40000 ALTER TABLE `ganan_art_90` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_categorias`
--

DROP TABLE IF EXISTS `ganan_categorias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_categorias` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_categorias`
--

LOCK TABLES `ganan_categorias` WRITE;
/*!40000 ALTER TABLE `ganan_categorias` DISABLE KEYS */;
INSERT INTO `ganan_categorias` VALUES (1,'Primera',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(2,'Segunda',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(3,'Tercera',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(4,'Cuarta',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL);
/*!40000 ALTER TABLE `ganan_categorias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_conceptos_anticipos`
--

DROP TABLE IF EXISTS `ganan_conceptos_anticipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_conceptos_anticipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ganan_conceptos_anticipos_nombre_unique` (`nombre`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_conceptos_anticipos`
--

LOCK TABLES `ganan_conceptos_anticipos` WRITE;
/*!40000 ALTER TABLE `ganan_conceptos_anticipos` DISABLE KEYS */;
INSERT INTO `ganan_conceptos_anticipos` VALUES (1,NULL,'Anticipos',1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(2,NULL,'Retenciones y Percepciones',1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(3,NULL,'Saldo a Favor Anterior',1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL);
/*!40000 ALTER TABLE `ganan_conceptos_anticipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_ddjj_detail_anticipos`
--

DROP TABLE IF EXISTS `ganan_ddjj_detail_anticipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_ddjj_detail_anticipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `ganan_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ganan_concepto_anticipo_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ganan_ddjj_detail_anticipos_ganan_ddjj_id_foreign` (`ganan_ddjj_id`),
  KEY `ganan_ddjj_detail_anticipos_person_id_foreign` (`person_id`),
  KEY `ganan_ddjj_detail_anticipos_ganan_concepto_anticipo_id_foreign` (`ganan_concepto_anticipo_id`),
  CONSTRAINT `ganan_ddjj_detail_anticipos_ganan_concepto_anticipo_id_foreign` FOREIGN KEY (`ganan_concepto_anticipo_id`) REFERENCES `ganan_conceptos_anticipos` (`id`),
  CONSTRAINT `ganan_ddjj_detail_anticipos_ganan_ddjj_id_foreign` FOREIGN KEY (`ganan_ddjj_id`) REFERENCES `ganan_ddjjs` (`id`),
  CONSTRAINT `ganan_ddjj_detail_anticipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_ddjj_detail_anticipos`
--

LOCK TABLES `ganan_ddjj_detail_anticipos` WRITE;
/*!40000 ALTER TABLE `ganan_ddjj_detail_anticipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `ganan_ddjj_detail_anticipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_ddjj_detail_deducciones`
--

DROP TABLE IF EXISTS `ganan_ddjj_detail_deducciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_ddjj_detail_deducciones` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `ganan_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ganan_deduccion_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ganan_ddjj_detail_deducciones_ganan_ddjj_id_foreign` (`ganan_ddjj_id`),
  KEY `ganan_ddjj_detail_deducciones_person_id_foreign` (`person_id`),
  KEY `ganan_ddjj_detail_deducciones_ganan_deduccion_id_foreign` (`ganan_deduccion_id`),
  CONSTRAINT `ganan_ddjj_detail_deducciones_ganan_ddjj_id_foreign` FOREIGN KEY (`ganan_ddjj_id`) REFERENCES `ganan_ddjjs` (`id`),
  CONSTRAINT `ganan_ddjj_detail_deducciones_ganan_deduccion_id_foreign` FOREIGN KEY (`ganan_deduccion_id`) REFERENCES `ganan_deducciones` (`id`),
  CONSTRAINT `ganan_ddjj_detail_deducciones_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_ddjj_detail_deducciones`
--

LOCK TABLES `ganan_ddjj_detail_deducciones` WRITE;
/*!40000 ALTER TABLE `ganan_ddjj_detail_deducciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `ganan_ddjj_detail_deducciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_ddjj_detail_ing_egr`
--

DROP TABLE IF EXISTS `ganan_ddjj_detail_ing_egr`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_ddjj_detail_ing_egr` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `ganan_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `ganan_categoria_id` int(10) unsigned NOT NULL,
  `ganan_tipo_op_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ganan_ddjj_detail_ing_egr_ganan_ddjj_id_foreign` (`ganan_ddjj_id`),
  KEY `ganan_ddjj_detail_ing_egr_person_id_foreign` (`person_id`),
  KEY `ganan_ddjj_detail_ing_egr_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `ganan_ddjj_detail_ing_egr_ganan_categoria_id_foreign` (`ganan_categoria_id`),
  KEY `ganan_ddjj_detail_ing_egr_ganan_tipo_op_id_foreign` (`ganan_tipo_op_id`),
  CONSTRAINT `ganan_ddjj_detail_ing_egr_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `ganan_ddjj_detail_ing_egr_ganan_categoria_id_foreign` FOREIGN KEY (`ganan_categoria_id`) REFERENCES `ganan_categorias` (`id`),
  CONSTRAINT `ganan_ddjj_detail_ing_egr_ganan_ddjj_id_foreign` FOREIGN KEY (`ganan_ddjj_id`) REFERENCES `ganan_ddjjs` (`id`),
  CONSTRAINT `ganan_ddjj_detail_ing_egr_ganan_tipo_op_id_foreign` FOREIGN KEY (`ganan_tipo_op_id`) REFERENCES `ganan_tipos_op` (`id`),
  CONSTRAINT `ganan_ddjj_detail_ing_egr_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_ddjj_detail_ing_egr`
--

LOCK TABLES `ganan_ddjj_detail_ing_egr` WRITE;
/*!40000 ALTER TABLE `ganan_ddjj_detail_ing_egr` DISABLE KEYS */;
/*!40000 ALTER TABLE `ganan_ddjj_detail_ing_egr` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_ddjjs`
--

DROP TABLE IF EXISTS `ganan_ddjjs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_ddjjs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `anio` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ingresos_gravados` decimal(16,2) NOT NULL DEFAULT '0.00',
  `ingresos_exentos` decimal(16,2) NOT NULL DEFAULT '0.00',
  `egresos_gravados` decimal(16,2) NOT NULL DEFAULT '0.00',
  `egresos_exentos` decimal(16,2) NOT NULL DEFAULT '0.00',
  `deducciones_total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `base_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto_determinado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_pagar` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_favor` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ganan_ddjjs_person_id_foreign` (`person_id`),
  CONSTRAINT `ganan_ddjjs_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_ddjjs`
--

LOCK TABLES `ganan_ddjjs` WRITE;
/*!40000 ALTER TABLE `ganan_ddjjs` DISABLE KEYS */;
/*!40000 ALTER TABLE `ganan_ddjjs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_deducciones`
--

DROP TABLE IF EXISTS `ganan_deducciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_deducciones` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `anio` int(10) unsigned NOT NULL,
  `generales` tinyint(1) NOT NULL DEFAULT '0',
  `particulares` tinyint(1) NOT NULL DEFAULT '0',
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=151 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_deducciones`
--

LOCK TABLES `ganan_deducciones` WRITE;
/*!40000 ALTER TABLE `ganan_deducciones` DISABLE KEYS */;
INSERT INTO `ganan_deducciones` VALUES (1,NULL,2017,1,0,'Primas de seguro para el caso de muerte',999.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(2,NULL,2017,1,0,'Gastos de Sepelio',999.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(3,NULL,2017,1,0,'Aportes a Obras Sociales',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(4,NULL,2017,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(5,NULL,2017,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(6,NULL,2017,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(7,NULL,2017,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(8,NULL,2017,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(9,NULL,2017,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(10,NULL,2017,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(11,NULL,2017,1,0,'Servicio Doméstico',51967.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(12,NULL,2017,1,0,'Donaciones',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(13,NULL,2017,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(14,NULL,2017,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(15,NULL,2017,0,1,'Conyuge',48447.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(16,NULL,2017,0,1,'Hijo Incapacitado',24432.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(17,NULL,2017,0,1,'Hijo Menor 18 años',24432.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(18,NULL,2017,0,1,'Hijastro Incapacitado',24432.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(19,NULL,2017,0,1,'Hijastro Menor 18 Años',24432.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(20,NULL,2017,0,1,'Ganancia No Imponible',51967.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(21,NULL,2017,0,1,'Deduccion Especial',51967.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(22,NULL,2018,1,0,'Primas de seguro para el caso de muerte',12000.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(23,NULL,2018,1,0,'Gastos de Sepelio',999.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(24,NULL,2018,1,0,'Aportes a Obras Sociales',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(25,NULL,2018,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(26,NULL,2018,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(27,NULL,2018,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(28,NULL,2018,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(29,NULL,2018,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(30,NULL,2018,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL);
INSERT INTO `ganan_deducciones` VALUES (31,NULL,2018,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(32,NULL,2018,1,0,'Servicio Doméstico',66917.91,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(33,NULL,2018,1,0,'Donaciones',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(34,NULL,2018,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(35,NULL,2018,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(36,NULL,2018,0,1,'Conyuge',66917.91,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(37,NULL,2018,0,1,'Hijo Incapacitado',31461.09,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(38,NULL,2018,0,1,'Hijo Menor 18 años',31461.09,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(39,NULL,2018,0,1,'Hijastro Incapacitado',31461.09,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(40,NULL,2018,0,1,'Hijastro Menor 18 Años',31461.09,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(41,NULL,2018,0,1,'Ganancia No Imponible',66917.91,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(42,NULL,2018,0,1,'Deduccion Especial',66917.91,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(43,NULL,2019,1,0,'Primas de seguro para el caso de muerte',18000.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(44,NULL,2019,1,0,'Gastos de Sepelio',999.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(45,NULL,2019,1,0,'Aportes a Obras Sociales',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(46,NULL,2019,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(47,NULL,2019,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(48,NULL,2019,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(49,NULL,2019,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(50,NULL,2019,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(51,NULL,2019,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(52,NULL,2019,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(53,NULL,2019,1,0,'Servicio Doméstico',103018.79,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(54,NULL,2019,1,0,'Donaciones',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(55,NULL,2019,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(56,NULL,2019,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(57,NULL,2019,0,1,'Conyuge',80033.97,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(58,NULL,2019,0,1,'Hijo Incapacitado',40361.43,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(59,NULL,2019,0,1,'Hijo Menor 18 años',206037.56,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(60,NULL,2019,0,1,'Hijastro Incapacitado',206037.56,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(61,NULL,2019,0,1,'Hijastro Menor 18 Años',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(62,NULL,2019,0,1,'Ganancia No Imponible',103018.79,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(63,NULL,2019,0,1,'Deduccion Especial',103018.79,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL);
INSERT INTO `ganan_deducciones` VALUES (64,NULL,2016,1,0,'Primas de seguro para el caso de muerte',999.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(65,NULL,2016,1,0,'Gastos de Sepelio',999.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(66,NULL,2016,1,0,'Aportes a Obras Sociales',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(67,NULL,2016,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(68,NULL,2016,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(69,NULL,2016,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(70,NULL,2016,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(71,NULL,2016,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(72,NULL,2016,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(73,NULL,2016,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(74,NULL,2016,1,0,'Servicio Doméstico',42318.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(75,NULL,2016,1,0,'Donaciones',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(76,NULL,2016,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(77,NULL,2016,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y \n            Paramédica',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(78,NULL,2016,0,1,'Conyuge',39778.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(79,NULL,2016,0,1,'Hijo Incapacitado',19889.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(80,NULL,2016,0,1,'Hijo Menor 18 años',19889.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(81,NULL,2016,0,1,'Hijastro Incapacitado',19889.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(82,NULL,2016,0,1,'Hijastro Menor 18 Años',19889.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(83,NULL,2016,0,1,'Ganancia No Imponible',42318.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(84,NULL,2016,0,1,'Deduccion Especial',42318.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(85,NULL,2019,1,0,'Alquileres',103018.97,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(86,NULL,2020,1,0,'Alquileres',123861.17,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(87,NULL,2020,1,0,'Primas de seguro para el caso de muerte',18000.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(88,NULL,2020,1,0,'Gastos de Sepelio',999.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(89,NULL,2020,1,0,'Aportes a Obras Sociales',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(90,NULL,2020,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(91,NULL,2020,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(92,NULL,2020,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(93,NULL,2020,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL);
INSERT INTO `ganan_deducciones` VALUES (94,NULL,2020,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(95,NULL,2020,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(96,NULL,2020,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(97,NULL,2020,1,0,'Servicio Doméstico',123861.17,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(98,NULL,2020,1,0,'Donaciones',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(99,NULL,2020,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(100,NULL,2020,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(101,NULL,2020,0,1,'Conyuge',115471.38,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(102,NULL,2020,0,1,'Hijo Incapacitado',58232.65,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(103,NULL,2020,0,1,'Hijo Menor 18 años',58232.65,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(104,NULL,2020,0,1,'Hijastro Incapacitado',58232.65,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(105,NULL,2020,0,1,'Hijastro Menor 18 Años',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(106,NULL,2020,0,1,'Ganancia No Imponible',123861.17,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(107,NULL,2020,0,1,'Deduccion Especial Art 30 Apartado 1',103018.79,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(108,NULL,2020,0,1,'Deduccion Especial Art 30 Apartado 1 \"Nuevos Profesionales / Emprendedores',309652.93,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(109,NULL,2020,0,1,'Deduccion Especial Art 30 Apartado 2',594533.62,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(110,NULL,2021,1,0,'Primas de seguro para el caso de muerte',24000.00,1,'2021-03-17 22:06:03','2021-03-17 22:06:03',NULL),(111,NULL,2021,1,0,'Gastos de Sepelio',996.23,1,'2021-03-17 22:06:03','2021-03-17 22:06:03',NULL),(112,NULL,2021,1,0,'Aportes a Obras Sociales',0.00,1,'2021-03-17 22:06:03','2021-03-17 22:06:03',NULL),(113,NULL,2021,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2021-03-17 22:06:03','2021-03-17 22:06:03',NULL),(114,NULL,2021,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2021-03-17 22:06:03','2021-03-17 22:06:03',NULL),(115,NULL,2021,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2021-03-17 22:06:03','2021-03-17 22:06:03',NULL),(116,NULL,2021,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2021-03-17 22:06:03','2021-03-17 22:06:03',NULL),(117,NULL,2021,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2021-03-17 22:06:03','2021-03-17 22:06:03',NULL),(118,NULL,2021,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2021-03-17 22:06:03','2021-03-17 22:06:03',NULL),(119,NULL,2021,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2021-03-17 22:06:03','2021-03-17 22:06:03',NULL),(120,NULL,2021,1,0,'Servicio Doméstico',167678.40,1,'2021-03-17 22:06:03','2021-03-17 22:06:03',NULL),(121,NULL,2021,1,0,'Donaciones',0.00,1,'2021-03-17 22:06:03','2021-03-17 22:06:03',NULL),(122,NULL,2021,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2021-03-17 22:06:03','2021-03-17 22:06:03',NULL),(123,NULL,2021,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2021-03-17 22:06:03','2021-03-17 22:06:03',NULL),(124,NULL,2021,0,1,'Conyuge',156320.63,1,'2021-03-17 22:06:03','2021-03-17 22:06:03',NULL),(125,NULL,2021,0,1,'Hijo Menor 18 años',78833.08,1,'2021-03-17 22:06:03','2021-03-17 22:06:03',NULL);
INSERT INTO `ganan_deducciones` VALUES (126,NULL,2021,0,1,'Ganancia No Imponible',167678.40,1,'2021-03-17 22:06:03','2021-03-17 22:06:03',NULL),(127,NULL,2021,0,1,'Deduccion Especial',804856.34,1,'2021-03-17 22:06:03','2021-03-17 22:06:03',NULL),(128,NULL,2022,1,0,'Primas de seguro para el caso de muerte',24000.00,1,'2022-01-11 14:02:38','2022-01-11 14:02:38',NULL),(129,NULL,2022,1,0,'Gastos de Sepelio',996.23,1,'2022-01-11 14:02:38','2022-01-11 14:02:38',NULL),(130,NULL,2022,1,0,'Aportes a Obras Sociales',0.00,1,'2022-01-11 14:02:38','2022-01-11 14:02:38',NULL),(131,NULL,2022,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2022-01-11 14:02:38','2022-01-11 14:02:38',NULL),(132,NULL,2022,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2022-01-11 14:02:38','2022-01-11 14:02:38',NULL),(133,NULL,2022,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2022-01-11 14:02:38','2022-01-11 14:02:38',NULL),(134,NULL,2022,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2022-01-11 14:02:38','2022-01-11 14:02:38',NULL),(135,NULL,2022,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2022-01-11 14:02:38','2022-01-11 14:02:38',NULL),(136,NULL,2022,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2022-01-11 14:02:38','2022-01-11 14:02:38',NULL),(137,NULL,2022,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2022-01-11 14:02:38','2022-01-11 14:02:38',NULL),(138,NULL,2022,1,0,'Servicio Doméstico',252564.84,1,'2022-01-11 14:02:38','2022-01-11 14:02:38',NULL),(139,NULL,2022,1,0,'Donaciones',0.00,1,'2022-01-11 14:02:38','2022-01-11 14:02:38',NULL),(140,NULL,2022,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2022-01-11 14:02:38','2022-01-11 14:02:38',NULL),(141,NULL,2022,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2022-01-11 14:02:38','2022-01-11 14:02:38',NULL),(142,NULL,2022,1,0,'Alquileres',252564.84,1,'2022-01-11 14:02:38','2022-01-11 14:02:38',NULL),(143,NULL,2022,0,1,'Conyuge',235457.25,1,'2022-01-11 14:02:38','2022-01-11 14:02:38',NULL),(144,NULL,2022,0,1,'Hijo Menor 18 años',118741.97,1,'2022-01-11 14:02:38','2022-01-11 14:02:38',NULL),(145,NULL,2022,0,1,'Ganancia No Imponible',252564.84,1,'2022-01-11 14:02:38','2022-01-11 14:02:38',NULL),(146,NULL,2022,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 2]',1212311.24,1,'2022-01-11 14:02:38','2022-01-11 14:02:38',NULL),(147,NULL,2022,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 1]',505129.68,1,'2022-01-11 14:02:38','2022-01-11 14:02:38',NULL),(148,NULL,2022,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 1 “nuevos profesionales/emprendedores”]',631412.10,1,'2022-01-11 14:02:38','2022-01-11 14:02:38',NULL),(149,NULL,2022,0,1,'Hijo Incapacitado',237483.94,1,'2022-01-11 14:02:38','2022-01-11 14:02:38',NULL),(150,NULL,2021,1,0,'Alquileres',167678.40,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `ganan_deducciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_tipos_op`
--

DROP TABLE IF EXISTS `ganan_tipos_op`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_tipos_op` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_tipos_op`
--

LOCK TABLES `ganan_tipos_op` WRITE;
/*!40000 ALTER TABLE `ganan_tipos_op` DISABLE KEYS */;
INSERT INTO `ganan_tipos_op` VALUES (1,NULL,'Gravado',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(2,NULL,'Exento',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL);
/*!40000 ALTER TABLE `ganan_tipos_op` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iibb_perceptions`
--

DROP TABLE IF EXISTS `iibb_perceptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `iibb_perceptions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iibb_perceptions`
--

LOCK TABLES `iibb_perceptions` WRITE;
/*!40000 ALTER TABLE `iibb_perceptions` DISABLE KEYS */;
INSERT INTO `iibb_perceptions` VALUES (1,NULL,NULL,NULL,'IIBB CABA','IIBBCABA'),(2,NULL,NULL,NULL,'IIBB Bs. As.','IIBBBSAS'),(3,NULL,NULL,NULL,'Percepcion IIBB Tucuman','IIBBTucuman'),(4,NULL,NULL,NULL,'Perc IIBB Misiones','IIBBMisiones'),(5,NULL,NULL,NULL,'Perc IIBB Cordoba','IIBBCba'),(6,NULL,NULL,NULL,'Pec IIBB La Pampa','IIBB La Pampa'),(7,NULL,NULL,NULL,'Perc IIBB Rio Negro','IIBB Rio Negro'),(8,NULL,NULL,NULL,'Perc IIBB Corrientes','IIIBB Corrientes'),(9,NULL,NULL,NULL,'Perc IIBB Santiago del Estero','IIBBSantiago');
/*!40000 ALTER TABLE `iibb_perceptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_combos`
--

DROP TABLE IF EXISTS `inv_combos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_combos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `inv_product_combo_id` bigint(20) unsigned NOT NULL,
  `inv_product_id` bigint(20) unsigned NOT NULL,
  `cantidades` int(11) NOT NULL,
  `codigo_interno` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_combos_inv_product_combo_id_foreign` (`inv_product_combo_id`),
  KEY `inv_combos_inv_product_id_foreign` (`inv_product_id`),
  CONSTRAINT `inv_combos_inv_product_combo_id_foreign` FOREIGN KEY (`inv_product_combo_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_combos_inv_product_id_foreign` FOREIGN KEY (`inv_product_id`) REFERENCES `inv_productos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_combos`
--

LOCK TABLES `inv_combos` WRITE;
/*!40000 ALTER TABLE `inv_combos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_combos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_control_stock`
--

DROP TABLE IF EXISTS `inv_control_stock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_control_stock` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_control_stock_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_control_stock_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_control_stock`
--

LOCK TABLES `inv_control_stock` WRITE;
/*!40000 ALTER TABLE `inv_control_stock` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_control_stock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_control_stock_detail`
--

DROP TABLE IF EXISTS `inv_control_stock_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_control_stock_detail` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_control_stock_id` bigint(20) unsigned NOT NULL,
  `inv_product_id` bigint(20) unsigned NOT NULL,
  `stock_actual` decimal(16,2) NOT NULL DEFAULT '0.00',
  `stock_real` decimal(16,2) NOT NULL DEFAULT '0.00',
  `stock_diferencia` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_costo` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_diferencia` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_control_stock_detail_person_id_foreign` (`person_id`),
  KEY `inv_control_stock_detail_inv_control_stock_id_foreign` (`inv_control_stock_id`),
  KEY `inv_control_stock_detail_inv_product_id_foreign` (`inv_product_id`),
  CONSTRAINT `inv_control_stock_detail_inv_control_stock_id_foreign` FOREIGN KEY (`inv_control_stock_id`) REFERENCES `inv_control_stock` (`id`),
  CONSTRAINT `inv_control_stock_detail_inv_product_id_foreign` FOREIGN KEY (`inv_product_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_control_stock_detail_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_control_stock_detail`
--

LOCK TABLES `inv_control_stock_detail` WRITE;
/*!40000 ALTER TABLE `inv_control_stock_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_control_stock_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_indicadores`
--

DROP TABLE IF EXISTS `inv_indicadores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_indicadores` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `metodo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `orden` int(10) unsigned NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_indicadores`
--

LOCK TABLES `inv_indicadores` WRITE;
/*!40000 ALTER TABLE `inv_indicadores` DISABLE KEYS */;
INSERT INTO `inv_indicadores` VALUES (1,NULL,'Datos Grales','datos_grales','card_info',5,1,NULL,'2022-05-19 22:13:01',NULL),(2,NULL,'Impuestos Asociados','impuestos_asociados','card_info',6,1,NULL,'2022-05-19 22:13:01',NULL),(3,NULL,'Informacion de Liquidacion','informacion_de_liquidacion','card_info',7,1,NULL,'2022-05-19 22:13:01',NULL),(4,NULL,'Cantidad Ventas del Mes','cantidad_ventas_del_mes','card',1,1,NULL,'2022-05-19 22:13:01',NULL),(5,NULL,'Total Facturado En El Mes','total_facturado_en_el_mes','card',2,1,NULL,'2022-05-19 22:13:01',NULL),(6,NULL,'Total Facturado En El Dia','total_facturado_en_el_dia','card',3,1,NULL,'2022-05-19 22:13:01',NULL),(7,NULL,'Total Facturado En El Año','total_facturado_en_el_anio','card',4,1,NULL,'2022-05-19 22:13:01',NULL),(8,NULL,'Facturacion Mensual','facturacion_mensual','grafico',8,1,NULL,'2022-05-19 22:13:01',NULL),(9,NULL,'Proyeccion de Ganancias','proyeccion_de_ganancias','tabla',9,1,NULL,'2022-05-19 22:13:01',NULL),(10,NULL,'Posicion IVA','posicion_de_iva','tabla',10,1,NULL,'2022-05-19 22:13:01',NULL);
/*!40000 ALTER TABLE `inv_indicadores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_indicadores_persons`
--

DROP TABLE IF EXISTS `inv_indicadores_persons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_indicadores_persons` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_indicador_id` bigint(20) unsigned NOT NULL,
  `objetivo` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_indicadores_persons_person_id_foreign` (`person_id`),
  KEY `inv_indicadores_persons_inv_indicador_id_foreign` (`inv_indicador_id`),
  CONSTRAINT `inv_indicadores_persons_inv_indicador_id_foreign` FOREIGN KEY (`inv_indicador_id`) REFERENCES `inv_indicadores` (`id`),
  CONSTRAINT `inv_indicadores_persons_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_indicadores_persons`
--

LOCK TABLES `inv_indicadores_persons` WRITE;
/*!40000 ALTER TABLE `inv_indicadores_persons` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_indicadores_persons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_ing_egr_stock`
--

DROP TABLE IF EXISTS `inv_ing_egr_stock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_ing_egr_stock` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_ing_egr_stock_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_ing_egr_stock_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_ing_egr_stock`
--

LOCK TABLES `inv_ing_egr_stock` WRITE;
/*!40000 ALTER TABLE `inv_ing_egr_stock` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_ing_egr_stock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_ing_egr_stock_detail`
--

DROP TABLE IF EXISTS `inv_ing_egr_stock_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_ing_egr_stock_detail` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_ing_egr_stock_id` bigint(20) unsigned NOT NULL,
  `inv_product_id` bigint(20) unsigned NOT NULL,
  `sumar1_restar0` tinyint(1) NOT NULL DEFAULT '1',
  `cantidades` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_ing_egr_stock_detail_person_id_foreign` (`person_id`),
  KEY `inv_ing_egr_stock_detail_inv_ing_egr_stock_id_foreign` (`inv_ing_egr_stock_id`),
  KEY `inv_ing_egr_stock_detail_inv_product_id_foreign` (`inv_product_id`),
  CONSTRAINT `inv_ing_egr_stock_detail_inv_ing_egr_stock_id_foreign` FOREIGN KEY (`inv_ing_egr_stock_id`) REFERENCES `inv_ing_egr_stock` (`id`),
  CONSTRAINT `inv_ing_egr_stock_detail_inv_product_id_foreign` FOREIGN KEY (`inv_product_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_ing_egr_stock_detail_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_ing_egr_stock_detail`
--

LOCK TABLES `inv_ing_egr_stock_detail` WRITE;
/*!40000 ALTER TABLE `inv_ing_egr_stock_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_ing_egr_stock_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_lista_de_precios`
--

DROP TABLE IF EXISTS `inv_lista_de_precios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_lista_de_precios` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `porcentaje_descuento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_lista_de_precios_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_lista_de_precios_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_lista_de_precios`
--

LOCK TABLES `inv_lista_de_precios` WRITE;
/*!40000 ALTER TABLE `inv_lista_de_precios` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_lista_de_precios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_config_cc`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_config_cc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_config_cc` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `horas_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `horas_contra_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `gastos_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `gastos_contra_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `productos_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `productos_contra_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `asiento_horas_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `asiento_contra_horas_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `asiento_gastos_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `asiento_contra_gastos_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `asiento_productos_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `asiento_contra_productos_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_config_cc_person_id_foreign` (`person_id`),
  KEY `hcc_id_foreign` (`horas_conta_plan_cuenta_id`),
  KEY `gcc_id_foreign` (`gastos_conta_plan_cuenta_id`),
  KEY `pcc_id_foreign` (`productos_conta_plan_cuenta_id`),
  KEY `h_contra_cc_id_foreign` (`horas_contra_conta_plan_cuenta_id`),
  KEY `g_contra_cc_id_foreign` (`gastos_contra_conta_plan_cuenta_id`),
  KEY `p_contra_cc_id_foreign` (`productos_contra_conta_plan_cuenta_id`),
  KEY `ahcc_id_foreign` (`asiento_horas_cpc_id`),
  KEY `agcc_id_foreign` (`asiento_gastos_cpc_id`),
  KEY `apcc_id_foreign` (`asiento_productos_cpc_id`),
  KEY `ah_contra_cc_id_foreign` (`asiento_contra_horas_cpc_id`),
  KEY `ag_contra_cc_id_foreign` (`asiento_contra_gastos_cpc_id`),
  KEY `ap_contra_cc_id_foreign` (`asiento_contra_productos_cpc_id`),
  CONSTRAINT `ag_contra_cc_id_foreign` FOREIGN KEY (`asiento_contra_gastos_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `agcc_id_foreign` FOREIGN KEY (`asiento_gastos_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `ah_contra_cc_id_foreign` FOREIGN KEY (`asiento_contra_horas_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `ahcc_id_foreign` FOREIGN KEY (`asiento_horas_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `ap_contra_cc_id_foreign` FOREIGN KEY (`asiento_contra_productos_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `apcc_id_foreign` FOREIGN KEY (`asiento_productos_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `g_contra_cc_id_foreign` FOREIGN KEY (`gastos_contra_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `gcc_id_foreign` FOREIGN KEY (`gastos_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `h_contra_cc_id_foreign` FOREIGN KEY (`horas_contra_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `hcc_id_foreign` FOREIGN KEY (`horas_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `inv_orden_trabajo_config_cc_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `p_contra_cc_id_foreign` FOREIGN KEY (`productos_contra_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `pcc_id_foreign` FOREIGN KEY (`productos_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_config_cc`
--

LOCK TABLES `inv_orden_trabajo_config_cc` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_config_cc` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_config_cc` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_facturada`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_facturada`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_facturada` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `fact_elec_receipt_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_facturada_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_facturada_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  KEY `inv_orden_trabajo_facturada_fact_elec_receipt_id_foreign` (`fact_elec_receipt_id`),
  CONSTRAINT `inv_orden_trabajo_facturada_fact_elec_receipt_id_foreign` FOREIGN KEY (`fact_elec_receipt_id`) REFERENCES `fact_elec_receipts` (`id`),
  CONSTRAINT `inv_orden_trabajo_facturada_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `inv_orden_trabajo_facturada_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_facturada`
--

LOCK TABLES `inv_orden_trabajo_facturada` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_facturada` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_facturada` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_gastos`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_gastos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_gastos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `inv_orden_trabajo_gastos_tipo_id` bigint(20) unsigned DEFAULT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `fecha` datetime NOT NULL DEFAULT '2022-04-28 01:06:28',
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_gastos_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_gastos_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `inv_orden_trabajo_gastos_receipt_id_foreign` (`receipt_id`),
  KEY `i_o_t_g_t_id_foreign` (`inv_orden_trabajo_gastos_tipo_id`),
  KEY `inv_orden_trabajo_gastos_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `i_o_t_g_t_id_foreign` FOREIGN KEY (`inv_orden_trabajo_gastos_tipo_id`) REFERENCES `inv_orden_trabajo_gastos_tipos` (`id`),
  CONSTRAINT `inv_orden_trabajo_gastos_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `inv_orden_trabajo_gastos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_orden_trabajo_gastos_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_orden_trabajo_gastos_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_gastos`
--

LOCK TABLES `inv_orden_trabajo_gastos` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_gastos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_gastos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_gastos_tipos`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_gastos_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_gastos_tipos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_gastos_tipos_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_orden_trabajo_gastos_tipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_gastos_tipos`
--

LOCK TABLES `inv_orden_trabajo_gastos_tipos` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_gastos_tipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_gastos_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_horas`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_horas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_horas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `inv_orden_trabajo_horas_tipo_id` bigint(20) unsigned DEFAULT NULL,
  `fecha` datetime NOT NULL DEFAULT '2022-04-28 01:06:28',
  `syj_empleado_id` int(10) unsigned DEFAULT NULL,
  `cantidad` decimal(16,2) NOT NULL DEFAULT '0.00',
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_horas_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_horas_inv_orden_trabajo_horas_tipo_id_foreign` (`inv_orden_trabajo_horas_tipo_id`),
  KEY `inv_orden_trabajo_horas_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  KEY `inv_orden_trabajo_horas_syj_empleado_id_foreign` (`syj_empleado_id`),
  CONSTRAINT `inv_orden_trabajo_horas_inv_orden_trabajo_horas_tipo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_horas_tipo_id`) REFERENCES `inv_orden_trabajo_horas_tipos` (`id`),
  CONSTRAINT `inv_orden_trabajo_horas_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `inv_orden_trabajo_horas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_orden_trabajo_horas_syj_empleado_id_foreign` FOREIGN KEY (`syj_empleado_id`) REFERENCES `syj_empleados` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_horas`
--

LOCK TABLES `inv_orden_trabajo_horas` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_horas_tipos`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_horas_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_horas_tipos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_horas_tipos_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_orden_trabajo_horas_tipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_horas_tipos`
--

LOCK TABLES `inv_orden_trabajo_horas_tipos` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas_tipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_productos`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_productos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_productos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `inv_producto_id` bigint(20) unsigned DEFAULT NULL,
  `fecha` datetime NOT NULL DEFAULT '2022-04-28 01:06:28',
  `cantidades` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_productos_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_productos_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  KEY `inv_orden_trabajo_productos_inv_producto_id_foreign` (`inv_producto_id`),
  CONSTRAINT `inv_orden_trabajo_productos_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `inv_orden_trabajo_productos_inv_producto_id_foreign` FOREIGN KEY (`inv_producto_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_orden_trabajo_productos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_productos`
--

LOCK TABLES `inv_orden_trabajo_productos` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_productos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_productos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajos`
--

DROP TABLE IF EXISTS `inv_orden_trabajos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `fecha` datetime NOT NULL DEFAULT '2022-04-28 01:06:28',
  `numero` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `titulo` text COLLATE utf8mb4_unicode_ci,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `cerrada` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajos_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajos_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `inv_orden_trabajos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_orden_trabajos_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajos`
--

LOCK TABLES `inv_orden_trabajos` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_product_receipt`
--

DROP TABLE IF EXISTS `inv_product_receipt`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_product_receipt` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `type_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_product_id` bigint(20) unsigned NOT NULL,
  `receiptable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `receiptable_id` int(10) unsigned NOT NULL,
  `cantidades` decimal(16,2) NOT NULL,
  `costo` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_sin_iva` decimal(16,2) NOT NULL DEFAULT '0.00',
  `descuento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `descuento_por1_imp0` tinyint(1) NOT NULL DEFAULT '1',
  `descuento_porcentaje` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_con_descuento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_final` decimal(16,2) NOT NULL DEFAULT '0.00',
  `iva` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_product_receipt_type_id_foreign` (`type_id`),
  KEY `inv_product_receipt_person_id_foreign` (`person_id`),
  KEY `inv_product_receipt_inv_product_id_foreign` (`inv_product_id`),
  CONSTRAINT `inv_product_receipt_inv_product_id_foreign` FOREIGN KEY (`inv_product_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_product_receipt_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_product_receipt_type_id_foreign` FOREIGN KEY (`type_id`) REFERENCES `types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_product_receipt`
--

LOCK TABLES `inv_product_receipt` WRITE;
/*!40000 ALTER TABLE `inv_product_receipt` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_product_receipt` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_productos`
--

DROP TABLE IF EXISTS `inv_productos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_productos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `inv_producto_tipo_id` bigint(20) unsigned NOT NULL DEFAULT '1',
  `person_id` int(10) unsigned NOT NULL,
  `person_prov_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `codigo_externo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `codigo_interno` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fac_ele_unidad_medida_id` int(10) unsigned NOT NULL DEFAULT '8',
  `inv_rubro_sub_id` bigint(20) unsigned NOT NULL,
  `inv_ubicacion_id` bigint(20) unsigned DEFAULT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `costo` decimal(16,2) NOT NULL DEFAULT '0.00',
  `margen` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_sin_iva` decimal(16,2) NOT NULL DEFAULT '0.00',
  `system_tax_id` int(10) unsigned DEFAULT NULL,
  `iva` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_final` decimal(16,2) NOT NULL DEFAULT '0.00',
  `inv_lista_de_precio_id` bigint(20) unsigned DEFAULT NULL,
  `foto` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `stock` decimal(16,2) NOT NULL DEFAULT '0.00',
  `stock_minimo` decimal(16,2) NOT NULL DEFAULT '0.00',
  `sku` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_productos_person_id_foreign` (`person_id`),
  KEY `inv_productos_person_prov_id_foreign` (`person_prov_id`),
  KEY `inv_productos_fac_ele_unidad_medida_id_foreign` (`fac_ele_unidad_medida_id`),
  KEY `inv_productos_inv_rubro_sub_id_foreign` (`inv_rubro_sub_id`),
  KEY `inv_productos_inv_ubicacion_id_foreign` (`inv_ubicacion_id`),
  KEY `inv_productos_system_tax_id_foreign` (`system_tax_id`),
  KEY `inv_productos_inv_lista_de_precio_id_foreign` (`inv_lista_de_precio_id`),
  KEY `inv_productos_inv_producto_tipo_id_foreign` (`inv_producto_tipo_id`),
  KEY `inv_productos_moneda_id_foreign` (`moneda_id`),
  CONSTRAINT `inv_productos_fac_ele_unidad_medida_id_foreign` FOREIGN KEY (`fac_ele_unidad_medida_id`) REFERENCES `fac_elec_unidad_medidas` (`id`),
  CONSTRAINT `inv_productos_inv_lista_de_precio_id_foreign` FOREIGN KEY (`inv_lista_de_precio_id`) REFERENCES `inv_lista_de_precios` (`id`),
  CONSTRAINT `inv_productos_inv_producto_tipo_id_foreign` FOREIGN KEY (`inv_producto_tipo_id`) REFERENCES `inv_productos_tipos` (`id`),
  CONSTRAINT `inv_productos_inv_rubro_sub_id_foreign` FOREIGN KEY (`inv_rubro_sub_id`) REFERENCES `inv_rubros_sub` (`id`),
  CONSTRAINT `inv_productos_inv_ubicacion_id_foreign` FOREIGN KEY (`inv_ubicacion_id`) REFERENCES `inv_ubicaciones` (`id`),
  CONSTRAINT `inv_productos_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `inv_productos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_productos_person_prov_id_foreign` FOREIGN KEY (`person_prov_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_productos_system_tax_id_foreign` FOREIGN KEY (`system_tax_id`) REFERENCES `system_taxes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_productos`
--

LOCK TABLES `inv_productos` WRITE;
/*!40000 ALTER TABLE `inv_productos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_productos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_productos_tipos`
--

DROP TABLE IF EXISTS `inv_productos_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_productos_tipos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_productos_tipos`
--

LOCK TABLES `inv_productos_tipos` WRITE;
/*!40000 ALTER TABLE `inv_productos_tipos` DISABLE KEYS */;
INSERT INTO `inv_productos_tipos` VALUES (1,NULL,'Unitario',1,NULL,NULL,NULL),(2,NULL,'Combo',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `inv_productos_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_rubros`
--

DROP TABLE IF EXISTS `inv_rubros`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_rubros` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_rubros_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_rubros_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_rubros`
--

LOCK TABLES `inv_rubros` WRITE;
/*!40000 ALTER TABLE `inv_rubros` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_rubros` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_rubros_sub`
--

DROP TABLE IF EXISTS `inv_rubros_sub`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_rubros_sub` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_rubro_id` bigint(20) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_rubros_sub_person_id_foreign` (`person_id`),
  KEY `inv_rubros_sub_inv_rubro_id_foreign` (`inv_rubro_id`),
  CONSTRAINT `inv_rubros_sub_inv_rubro_id_foreign` FOREIGN KEY (`inv_rubro_id`) REFERENCES `inv_rubros` (`id`),
  CONSTRAINT `inv_rubros_sub_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_rubros_sub`
--

LOCK TABLES `inv_rubros_sub` WRITE;
/*!40000 ALTER TABLE `inv_rubros_sub` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_rubros_sub` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_stock_movimientos`
--

DROP TABLE IF EXISTS `inv_stock_movimientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_stock_movimientos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_product_id` bigint(20) unsigned NOT NULL,
  `movimiento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `stock` decimal(16,2) NOT NULL DEFAULT '0.00',
  `costo` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_sin_iva` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_final` decimal(16,2) NOT NULL DEFAULT '0.00',
  `transactionable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `transactionable_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_transactions_morph` (`transactionable_type`,`transactionable_id`),
  KEY `inv_stock_movimientos_person_id_foreign` (`person_id`),
  KEY `inv_stock_movimientos_inv_product_id_foreign` (`inv_product_id`),
  CONSTRAINT `inv_stock_movimientos_inv_product_id_foreign` FOREIGN KEY (`inv_product_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_stock_movimientos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_stock_movimientos`
--

LOCK TABLES `inv_stock_movimientos` WRITE;
/*!40000 ALTER TABLE `inv_stock_movimientos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_stock_movimientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_ubicaciones`
--

DROP TABLE IF EXISTS `inv_ubicaciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_ubicaciones` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_ubicaciones_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_ubicaciones_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_ubicaciones`
--

LOCK TABLES `inv_ubicaciones` WRITE;
/*!40000 ALTER TABLE `inv_ubicaciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_ubicaciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iva_agrupacion`
--

DROP TABLE IF EXISTS `iva_agrupacion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `iva_agrupacion` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(11) NOT NULL,
  `ordr` int(11) NOT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iva_agrupacion`
--

LOCK TABLES `iva_agrupacion` WRITE;
/*!40000 ALTER TABLE `iva_agrupacion` DISABLE KEYS */;
INSERT INTO `iva_agrupacion` VALUES (1,1,1,0.00,'Operaciones con Responsables Inscriptos',1,NULL,NULL,NULL),(2,1,2,0.00,'Operaciones con Consumidores finales, Exentos y No alcanzados',1,NULL,NULL,NULL),(3,1,3,0.00,'Operaciones no gravadas y exentas',1,NULL,NULL,NULL),(4,1,4,0.00,'Credito fiscal a restituir',1,NULL,NULL,NULL),(5,2,5,0.00,'Debito fiscal a restituir',1,NULL,NULL,NULL),(6,2,6,0.00,'Total Credito Fiscal',1,NULL,NULL,NULL),(7,2,7,0.00,'Total Operaciones que no Generan Credito Fiscal',1,NULL,NULL,NULL),(8,1,8,0.00,'Operaciones con Monotributistas - Regimen Simmplificado',1,'2022-03-18 08:37:41','2022-03-18 08:37:41',NULL);
/*!40000 ALTER TABLE `iva_agrupacion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iva_conditions`
--

DROP TABLE IF EXISTS `iva_conditions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `iva_conditions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `iva_conditions_description_unique` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iva_conditions`
--

LOCK TABLES `iva_conditions` WRITE;
/*!40000 ALTER TABLE `iva_conditions` DISABLE KEYS */;
INSERT INTO `iva_conditions` VALUES (1,'Monotributo',NULL,NULL),(2,'Responsable Inscripto',NULL,NULL),(3,'Otro',NULL,NULL);
/*!40000 ALTER TABLE `iva_conditions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iva_creditos_tipos`
--

DROP TABLE IF EXISTS `iva_creditos_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `iva_creditos_tipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iva_creditos_tipos`
--

LOCK TABLES `iva_creditos_tipos` WRITE;
/*!40000 ALTER TABLE `iva_creditos_tipos` DISABLE KEYS */;
INSERT INTO `iva_creditos_tipos` VALUES (1,0,'Compras de bienes (excepto bienes de uso)',0.00,1,NULL,NULL,NULL),(2,0,'Locaciones',0.00,1,NULL,NULL,NULL),(3,0,'Prestaciones de servicios',0.00,1,NULL,NULL,NULL),(4,0,'Inversiones de Bienes de Uso',0.00,1,NULL,NULL,NULL),(5,0,'Compras de bienes usados a consumidores finales',0.00,1,NULL,NULL,NULL),(6,0,'Tur IVA',0.00,1,NULL,NULL,NULL),(7,0,'Contribuciones de la Seguridad Social',0.00,1,NULL,NULL,NULL),(8,0,'Contribuciones de la Seguridad Social - Artículo 91 Ley 27.467',0.00,1,NULL,NULL,NULL),(9,0,'Otros Conceptos',0.00,1,NULL,NULL,NULL),(10,0,'Compras de Bienes en el Exterior',0.00,1,NULL,NULL,NULL),(11,0,'Compras de Servicios en el exterior - Impuesto ingresado a través de entidades Financieras',0.00,1,NULL,NULL,NULL),(12,0,'Compras de Servicios en el exterior - Impuesto ingresado por el responsable',0.00,1,NULL,NULL,NULL),(13,0,'Locaciones o prestaciones gravadas en el país realizadas por sujetos del exterior - Impuesto ingresado a través de entidades Financieras',0.00,1,NULL,NULL,NULL),(14,0,'Régimen especial de compensación para la estabilización de precios - Emergencia alimentaria - Ley 27.519',0.00,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `iva_creditos_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `queue` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint(3) unsigned NOT NULL,
  `reserved_at` int(10) unsigned DEFAULT NULL,
  `available_at` int(10) unsigned NOT NULL,
  `created_at` int(10) unsigned NOT NULL,
  `base_de_dato` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `liquidators`
--

DROP TABLE IF EXISTS `liquidators`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `liquidators` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `liquidators_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `liquidators`
--

LOCK TABLES `liquidators` WRITE;
/*!40000 ALTER TABLE `liquidators` DISABLE KEYS */;
INSERT INTO `liquidators` VALUES (1,NULL,'Florencia',NULL,NULL,NULL),(2,NULL,'Jose Luis',NULL,NULL,NULL),(3,NULL,'Elizabet',NULL,NULL,NULL),(4,NULL,'Graciela',NULL,NULL,NULL),(5,NULL,'Agustina',NULL,NULL,NULL),(6,NULL,'Betty',NULL,NULL,NULL),(7,NULL,'Hernan',NULL,NULL,NULL);
/*!40000 ALTER TABLE `liquidators` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `localidad`
--

DROP TABLE IF EXISTS `localidad`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `localidad` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `zone_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `localidad_descripcion_unique` (`descripcion`),
  KEY `localidad_zone_id_foreign` (`zone_id`),
  CONSTRAINT `localidad_zone_id_foreign` FOREIGN KEY (`zone_id`) REFERENCES `zones` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `localidad`
--

LOCK TABLES `localidad` WRITE;
/*!40000 ALTER TABLE `localidad` DISABLE KEYS */;
INSERT INTO `localidad` VALUES (1,NULL,22,'Capital Federal',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(2,NULL,23,'Vicente Lopez',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(3,NULL,23,'San Isidro',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(4,NULL,23,'Lomas del Mirador',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(5,NULL,23,'Avellaneda',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(6,NULL,23,'Saenz Peña',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(7,NULL,23,'Caseros',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(8,NULL,23,'Moron',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL);
/*!40000 ALTER TABLE `localidad` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `log_debug`
--

DROP TABLE IF EXISTS `log_debug`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `log_debug` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `function_name` varchar(255) DEFAULT NULL,
  `message` varchar(255) DEFAULT NULL,
  `date` datetime DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15061 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `log_debug`
--

LOCK TABLES `log_debug` WRITE;
/*!40000 ALTER TABLE `log_debug` DISABLE KEYS */;
INSERT INTO `log_debug` VALUES (1,NULL,'assingMorePeriods','ejecutando funcion','2018-06-06 12:58:53',NULL),(2,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2, periodo->2018-5','2018-06-06 12:58:53',NULL),(3,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(4,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(5,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(6,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(7,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(8,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(9,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(10,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(11,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(12,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(13,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(14,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(15,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(16,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->3, periodo->2018-5','2018-06-06 12:58:53',NULL),(17,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(18,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(19,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(20,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(21,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(22,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(23,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(24,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(25,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(26,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(27,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(28,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(29,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(30,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->5, periodo->2018-5','2018-06-06 12:58:53',NULL),(31,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(32,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(33,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(34,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL);
INSERT INTO `log_debug` VALUES (35,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(36,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(37,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(38,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(39,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(40,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(41,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(42,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(43,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(44,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->96, periodo->2018-5','2018-06-06 12:58:53',NULL),(45,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(46,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(47,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(48,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(49,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(50,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(51,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(52,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(53,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(54,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(55,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(56,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(57,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(58,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->338, periodo->2018-5','2018-06-06 12:58:53',NULL),(59,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(60,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(61,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(62,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(63,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(64,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(65,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(66,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(67,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL);
INSERT INTO `log_debug` VALUES (68,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(69,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(70,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(71,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(72,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->435, periodo->2018-5','2018-06-06 12:58:53',NULL),(73,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(74,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(75,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(76,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(77,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(78,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(79,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(80,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(81,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(82,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(83,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(84,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(85,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(86,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->436, periodo->2018-5','2018-06-06 12:58:53',NULL),(87,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(88,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(89,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(90,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(91,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(92,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(93,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(94,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(95,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(96,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(97,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(98,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(99,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(100,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->448, periodo->2018-5','2018-06-06 12:58:53',NULL);
INSERT INTO `log_debug` VALUES (101,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(102,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(103,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(104,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(105,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(106,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(107,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(108,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(109,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(110,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(111,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(112,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(113,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(114,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->639, periodo->2018-5','2018-06-06 12:58:53',NULL),(115,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(116,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(117,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(118,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(119,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(120,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(121,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(122,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(123,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(124,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(125,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(126,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(127,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(128,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->640, periodo->2018-5','2018-06-06 12:58:53',NULL),(129,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(130,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(131,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(132,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(133,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL);
INSERT INTO `log_debug` VALUES (134,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(135,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(136,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(137,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(138,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(139,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(140,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(141,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(142,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->673, periodo->2018-5','2018-06-06 12:58:53',NULL),(143,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(144,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(145,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(146,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(147,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(148,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(149,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(150,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(151,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(152,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(153,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(154,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(155,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(156,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->784, periodo->2018-5','2018-06-06 12:58:53',NULL),(157,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(158,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(159,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(160,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(161,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(162,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(163,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(164,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(165,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(166,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL);
INSERT INTO `log_debug` VALUES (167,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(168,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(169,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(170,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1479, periodo->2018-5','2018-06-06 12:58:53',NULL),(171,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(172,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(173,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(174,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(175,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(176,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(177,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(178,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(179,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(180,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(181,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(182,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(183,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(184,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1634, periodo->2018-5','2018-06-06 12:58:54',NULL),(185,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(186,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(187,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(188,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(189,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(190,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(191,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(192,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(193,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(194,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(195,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(196,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(197,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(198,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1717, periodo->2018-5','2018-06-06 12:58:54',NULL),(199,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (200,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(201,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(202,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(203,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(204,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(205,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(206,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(207,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(208,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(209,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(210,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(211,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(212,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1729, periodo->2018-5','2018-06-06 12:58:54',NULL),(213,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(214,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(215,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(216,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(217,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(218,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(219,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(220,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(221,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(222,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(223,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(224,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(225,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(226,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1736, periodo->2018-5','2018-06-06 12:58:54',NULL),(227,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(228,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(229,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(230,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(231,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(232,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (233,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(234,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(235,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(236,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(237,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(238,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(239,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(240,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1845, periodo->2018-5','2018-06-06 12:58:54',NULL),(241,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(242,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(243,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(244,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(245,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(246,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(247,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(248,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(249,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(250,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(251,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(252,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(253,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(254,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1859, periodo->2018-5','2018-06-06 12:58:54',NULL),(255,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(256,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(257,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(258,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(259,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(260,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(261,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(262,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(263,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(264,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(265,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (266,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(267,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(268,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1865, periodo->2018-5','2018-06-06 12:58:54',NULL),(269,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(270,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(271,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(272,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(273,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(274,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(275,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(276,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(277,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(278,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(279,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(280,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(281,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(282,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1870, periodo->2018-5','2018-06-06 12:58:54',NULL),(283,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(284,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(285,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(286,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(287,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(288,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(289,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(290,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(291,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(292,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(293,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(294,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(295,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(296,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1979, periodo->2018-5','2018-06-06 12:58:54',NULL),(297,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(298,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (299,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(300,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(301,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(302,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(303,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(304,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(305,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(306,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(307,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(308,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(309,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(310,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1990, periodo->2018-5','2018-06-06 12:58:54',NULL),(311,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(312,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(313,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(314,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(315,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(316,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(317,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(318,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(319,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(320,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(321,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(322,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(323,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(324,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1991, periodo->2018-5','2018-06-06 12:58:54',NULL),(325,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(326,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(327,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(328,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(329,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(330,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(331,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (332,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(333,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(334,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(335,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(336,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(337,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(338,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1992, periodo->2018-5','2018-06-06 12:58:54',NULL),(339,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(340,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(341,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(342,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(343,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(344,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(345,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(346,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(347,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(348,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(349,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(350,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(351,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(352,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1993, periodo->2018-5','2018-06-06 12:58:54',NULL),(353,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(354,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(355,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(356,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(357,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(358,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(359,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(360,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(361,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(362,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(363,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(364,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (365,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(366,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1994, periodo->2018-5','2018-06-06 12:58:54',NULL),(367,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(368,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(369,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(370,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(371,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(372,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(373,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(374,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(375,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(376,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(377,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(378,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(379,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(380,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1995, periodo->2018-5','2018-06-06 12:58:54',NULL),(381,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(382,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(383,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(384,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(385,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(386,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(387,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(388,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(389,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(390,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(391,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(392,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(393,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(394,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1996, periodo->2018-6','2018-06-06 12:58:54',NULL),(395,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->7, contador->0','2018-06-06 12:58:54',NULL),(396,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->7, contador->1','2018-06-06 12:58:54',NULL),(397,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (398,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(399,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(400,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(401,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(402,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(403,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(404,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(405,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(406,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(407,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(408,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1997, periodo->2018-5','2018-06-06 12:58:54',NULL),(409,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(410,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(411,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(412,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(413,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(414,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(415,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(416,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(417,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(418,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(419,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(420,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(421,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(422,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1998, periodo->2018-5','2018-06-06 12:58:54',NULL),(423,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(424,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(425,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(426,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(427,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(428,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(429,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(430,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (431,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(432,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(433,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(434,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(435,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(436,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1999, periodo->2018-5','2018-06-06 12:58:54',NULL),(437,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(438,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(439,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(440,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(441,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(442,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(443,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(444,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(445,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(446,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(447,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(448,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(449,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(450,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2000, periodo->2018-5','2018-06-06 12:58:54',NULL),(451,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(452,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(453,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(454,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(455,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(456,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(457,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(458,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(459,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(460,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(461,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(462,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(463,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (464,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2001, periodo->2018-5','2018-06-06 12:58:54',NULL),(465,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(466,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(467,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(468,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(469,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(470,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(471,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(472,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(473,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(474,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(475,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(476,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(477,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(478,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2002, periodo->2018-5','2018-06-06 12:58:54',NULL),(479,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(480,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(481,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(482,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(483,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(484,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(485,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(486,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(487,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(488,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(489,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(490,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(491,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(492,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2003, periodo->2018-5','2018-06-06 12:58:54',NULL),(493,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(494,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(495,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(496,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (497,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(498,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(499,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(500,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(501,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(502,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(503,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(504,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(505,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(506,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2004, periodo->2018-5','2018-06-06 12:58:54',NULL),(507,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(508,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(509,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(510,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(511,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(512,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(513,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(514,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(515,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(516,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(517,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(518,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(519,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(520,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2005, periodo->2018-5','2018-06-06 12:58:54',NULL),(521,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(522,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(523,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(524,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(525,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(526,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(527,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(528,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(529,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (530,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(531,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(532,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(533,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(534,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2006, periodo->2018-5','2018-06-06 12:58:54',NULL),(535,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(536,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(537,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(538,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(539,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(540,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(541,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(542,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(543,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(544,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(545,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(546,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(547,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(548,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2007, periodo->2018-5','2018-06-06 12:58:54',NULL),(549,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(550,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(551,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(552,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(553,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(554,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(555,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(556,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(557,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(558,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(559,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(560,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(561,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(562,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2008, periodo->2018-5','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (563,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(564,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(565,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(566,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(567,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(568,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(569,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(570,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(571,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(572,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(573,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(574,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(575,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(576,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2009, periodo->2018-5','2018-06-06 12:58:54',NULL),(577,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(578,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(579,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(580,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(581,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(582,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(583,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(584,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(585,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(586,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(587,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(588,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(589,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(590,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2010, periodo->2018-5','2018-06-06 12:58:54',NULL),(591,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(592,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(593,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(594,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(595,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (596,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(597,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(598,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(599,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(600,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(601,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(602,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(603,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(604,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2011, periodo->2018-5','2018-06-06 12:58:54',NULL),(605,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(606,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(607,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(608,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(609,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(610,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(611,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(612,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(613,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(614,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(615,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(616,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(617,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(618,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2012, periodo->2018-5','2018-06-06 12:58:54',NULL),(619,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(620,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(621,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(622,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(623,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(624,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(625,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(626,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(627,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(628,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (629,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(630,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(631,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(632,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2013, periodo->2018-5','2018-06-06 12:58:54',NULL),(633,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(634,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(635,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(636,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(637,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(638,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(639,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(640,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(641,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(642,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(643,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(644,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(645,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(646,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2014, periodo->2018-5','2018-06-06 12:58:54',NULL),(647,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(648,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(649,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(650,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(651,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(652,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(653,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(654,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(655,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(656,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(657,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(658,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(659,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(660,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2015, periodo->2018-5','2018-06-06 12:58:54',NULL),(661,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (662,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(663,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(664,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(665,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(666,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(667,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(668,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(669,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(670,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(671,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(672,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(673,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(674,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2016, periodo->2018-5','2018-06-06 12:58:54',NULL),(675,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(676,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(677,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(678,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(679,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(680,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(681,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(682,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(683,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(684,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(685,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(686,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(687,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(688,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2017, periodo->2018-5','2018-06-06 12:58:54',NULL),(689,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(690,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(691,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(692,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(693,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(694,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (695,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(696,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(697,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(698,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(699,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(700,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(701,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(702,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2018, periodo->2018-5','2018-06-06 12:58:54',NULL),(703,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(704,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(705,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(706,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(707,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(708,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(709,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(710,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(711,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(712,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(713,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(714,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(715,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(716,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2019, periodo->2018-5','2018-06-06 12:58:54',NULL),(717,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(718,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(719,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(720,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(721,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(722,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(723,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(724,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(725,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(726,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(727,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (728,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(729,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(730,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2021, periodo->2018-5','2018-06-06 12:58:54',NULL),(731,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(732,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(733,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(734,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(735,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(736,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(737,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(738,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(739,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(740,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(741,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(742,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(743,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(744,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2022, periodo->2018-5','2018-06-06 12:58:54',NULL),(745,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(746,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(747,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(748,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(749,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(750,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(751,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(752,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(753,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(754,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(755,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(756,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(757,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(758,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2023, periodo->2018-5','2018-06-06 12:58:54',NULL),(759,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(760,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (761,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(762,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(763,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(764,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(765,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(766,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(767,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(768,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(769,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(770,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(771,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(772,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2024, periodo->2018-5','2018-06-06 12:58:54',NULL),(773,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(774,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(775,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(776,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(777,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(778,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(779,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(780,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(781,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(782,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(783,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(784,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(785,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(786,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2025, periodo->2018-5','2018-06-06 12:58:54',NULL),(787,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(788,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(789,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(790,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(791,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(792,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(793,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (794,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(795,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(796,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(797,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(798,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(799,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(800,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2026, periodo->2018-5','2018-06-06 12:58:54',NULL),(801,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(802,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(803,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(804,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(805,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(806,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(807,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(808,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(809,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(810,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(811,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(812,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(813,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(814,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2027, periodo->2018-5','2018-06-06 12:58:54',NULL),(815,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(816,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(817,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(818,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(819,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(820,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(821,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(822,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(823,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(824,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(825,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(826,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (827,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(828,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2028, periodo->2018-5','2018-06-06 12:58:54',NULL),(829,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(830,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(831,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(832,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(833,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(834,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(835,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(836,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(837,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(838,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(839,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(840,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(841,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(842,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2029, periodo->2018-5','2018-06-06 12:58:54',NULL),(843,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(844,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(845,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(846,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(847,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(848,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(849,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(850,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(851,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(852,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(853,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(854,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(855,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(856,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2030, periodo->2018-5','2018-06-06 12:58:54',NULL),(857,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(858,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(859,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (860,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(861,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(862,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(863,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(864,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(865,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(866,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(867,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(868,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(869,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(870,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2031, periodo->2018-5','2018-06-06 12:58:54',NULL),(871,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(872,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(873,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(874,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(875,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(876,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(877,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(878,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(879,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(880,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(881,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(882,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(883,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(884,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2032, periodo->2018-5','2018-06-06 12:58:54',NULL),(885,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(886,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(887,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(888,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(889,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(890,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(891,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(892,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (893,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(894,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(895,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(896,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(897,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(898,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2033, periodo->2018-5','2018-06-06 12:58:54',NULL),(899,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(900,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(901,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(902,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(903,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(904,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(905,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(906,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(907,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(908,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(909,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(910,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(911,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(912,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2034, periodo->2018-5','2018-06-06 12:58:54',NULL),(913,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(914,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(915,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(916,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(917,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(918,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(919,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(920,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(921,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(922,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(923,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(924,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(925,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (926,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2035, periodo->2018-5','2018-06-06 12:58:54',NULL),(927,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(928,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(929,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(930,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(931,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(932,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(933,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(934,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(935,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(936,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(937,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(938,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(939,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(940,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2036, periodo->2018-5','2018-06-06 12:58:54',NULL),(941,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(942,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(943,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(944,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(945,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(946,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(947,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(948,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(949,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(950,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(951,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(952,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(953,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(954,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2037, periodo->2018-5','2018-06-06 12:58:54',NULL),(955,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(956,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(957,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(958,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (959,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(960,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(961,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(962,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(963,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(964,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(965,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(966,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(967,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(968,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2038, periodo->2018-5','2018-06-06 12:58:54',NULL),(969,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(970,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(971,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(972,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(973,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(974,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(975,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(976,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(977,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(978,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(979,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(980,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(981,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(982,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2040, periodo->2018-5','2018-06-06 12:58:54',NULL),(983,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(984,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(985,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(986,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(987,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(988,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(989,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(990,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(991,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (992,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(993,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(994,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(995,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(996,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2041, periodo->2018-5','2018-06-06 12:58:54',NULL),(997,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(998,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(999,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(1000,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(1001,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(1002,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(1003,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(1004,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(1005,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(1006,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(1007,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(1008,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(1009,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(1010,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2042, periodo->2018-5','2018-06-06 12:58:54',NULL),(1011,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(1012,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(1013,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(1014,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(1015,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(1016,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(1017,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(1018,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(1019,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(1020,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(1021,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(1022,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(1023,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(1024,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2043, periodo->2018-5','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (1025,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(1026,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(1027,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(1028,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(1029,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(1030,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(1031,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(1032,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(1033,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(1034,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(1035,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(1036,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(1037,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(1038,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2044, periodo->2018-5','2018-06-06 12:58:54',NULL),(1039,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(1040,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(1041,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(1042,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(1043,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(1044,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(1045,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(1046,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(1047,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(1048,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(1049,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(1050,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(1051,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(1052,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2045, periodo->2018-5','2018-06-06 12:58:54',NULL),(1053,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(1054,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(1055,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(1056,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(1057,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (1058,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(1059,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(1060,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(1061,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(1062,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(1063,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(1064,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(1065,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(1066,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2046, periodo->2018-5','2018-06-06 12:58:54',NULL),(1067,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(1068,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(1069,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(1070,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(1071,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(1072,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(1073,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(1074,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(1075,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(1076,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(1077,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(1078,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(1079,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(1080,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2047, periodo->2018-5','2018-06-06 12:58:54',NULL),(1081,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(1082,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(1083,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(1084,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(1085,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(1086,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(1087,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(1088,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(1089,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(1090,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (1091,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(1092,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(1093,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(1094,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2048, periodo->2018-5','2018-06-06 12:58:54',NULL),(1095,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(1096,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(1097,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(1098,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(1099,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(1100,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(1101,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(1102,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(1103,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(1104,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(1105,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(1106,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(1107,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(1108,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2049, periodo->2018-5','2018-06-06 12:58:54',NULL),(1109,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(1110,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(1111,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(1112,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(1113,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(1114,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(1115,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(1116,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(1117,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(1118,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(1119,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(1120,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(1121,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(1122,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2050, periodo->2018-5','2018-06-06 12:58:54',NULL),(1123,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (1124,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(1125,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(1126,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(1127,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(1128,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(1129,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(1130,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(1131,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(1132,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(1133,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(1134,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(1135,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(1136,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2051, periodo->2018-5','2018-06-06 12:58:54',NULL),(1137,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(1138,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(1139,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(1140,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(1141,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(1142,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(1143,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(1144,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(1145,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(1146,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(1147,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(1148,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(1149,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(1150,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2052, periodo->2018-5','2018-06-06 12:58:54',NULL),(1151,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(1152,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(1153,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(1154,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(1155,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(1156,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (1157,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(1158,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(1159,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(1160,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(1161,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(1162,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(1163,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(1164,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2053, periodo->2018-5','2018-06-06 12:58:54',NULL),(1165,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(1166,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(1167,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(1168,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(1169,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(1170,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(1171,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(1172,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(1173,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(1174,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(1175,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(1176,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(1177,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(1178,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2054, periodo->2018-5','2018-06-06 12:58:54',NULL),(1179,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(1180,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(1181,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(1182,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(1183,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(1184,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(1185,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(1186,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(1187,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(1188,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(1189,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (1190,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(1191,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(1192,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2055, periodo->2018-5','2018-06-06 12:58:54',NULL),(1193,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(1194,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(1195,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(1196,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(1197,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(1198,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(1199,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(1200,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(1201,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(1202,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(1203,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(1204,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(1205,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(1206,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2056, periodo->2018-5','2018-06-06 12:58:54',NULL),(1207,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(1208,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(1209,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(1210,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(1211,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(1212,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(1213,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(1214,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(1215,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(1216,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(1217,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(1218,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(1219,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(1220,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2057, periodo->2018-5','2018-06-06 12:58:54',NULL),(1221,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(1222,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (1223,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(1224,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(1225,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(1226,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(1227,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(1228,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(1229,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(1230,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(1231,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(1232,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(1233,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(1234,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2058, periodo->2018-5','2018-06-06 12:58:54',NULL),(1235,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(1236,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(1237,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(1238,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(1239,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(1240,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(1241,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(1242,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(1243,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(1244,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(1245,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(1246,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(1247,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(1248,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2059, periodo->2018-5','2018-06-06 12:58:54',NULL),(1249,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(1250,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(1251,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(1252,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(1253,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(1254,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(1255,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (1256,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(1257,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(1258,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(1259,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(1260,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(1261,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(1262,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2060, periodo->2018-5','2018-06-06 12:58:54',NULL),(1263,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(1264,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(1265,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(1266,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(1267,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(1268,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(1269,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(1270,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(1271,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(1272,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(1273,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(1274,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(1275,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(1276,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2061, periodo->2018-5','2018-06-06 12:58:54',NULL),(1277,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(1278,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(1279,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(1280,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(1281,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(1282,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(1283,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(1284,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(1285,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(1286,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(1287,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(1288,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (1289,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(1290,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2062, periodo->2018-5','2018-06-06 12:58:54',NULL),(1291,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(1292,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(1293,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(1294,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(1295,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(1296,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(1297,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(1298,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(1299,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(1300,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(1301,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(1302,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(1303,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(1304,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2063, periodo->2018-5','2018-06-06 12:58:54',NULL),(1305,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(1306,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(1307,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(1308,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(1309,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(1310,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(1311,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(1312,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(1313,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(1314,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(1315,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(1316,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(1317,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(1318,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2064, periodo->2018-5','2018-06-06 12:58:54',NULL),(1319,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(1320,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(1321,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (1322,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(1323,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(1324,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(1325,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(1326,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(1327,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(1328,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(1329,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(1330,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(1331,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(1332,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2065, periodo->2018-5','2018-06-06 12:58:54',NULL),(1333,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(1334,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(1335,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(1336,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(1337,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1338,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1339,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1340,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1341,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1342,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1343,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1344,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1345,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1346,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2066, periodo->2018-6','2018-06-06 12:58:55',NULL),(1347,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->7, contador->0','2018-06-06 12:58:55',NULL),(1348,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->7, contador->1','2018-06-06 12:58:55',NULL),(1349,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1350,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1351,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1352,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1353,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1354,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL);
INSERT INTO `log_debug` VALUES (1355,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1356,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1357,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1358,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1359,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1360,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2067, periodo->2018-5','2018-06-06 12:58:55',NULL),(1361,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1362,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1363,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1364,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1365,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1366,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1367,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1368,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1369,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1370,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1371,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1372,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1373,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1374,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2068, periodo->2018-5','2018-06-06 12:58:55',NULL),(1375,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1376,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1377,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1378,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1379,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1380,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1381,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1382,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1383,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1384,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1385,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1386,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1387,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL);
INSERT INTO `log_debug` VALUES (1388,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2069, periodo->2018-5','2018-06-06 12:58:55',NULL),(1389,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1390,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1391,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1392,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1393,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1394,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1395,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1396,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1397,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1398,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1399,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1400,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1401,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1402,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2070, periodo->2018-5','2018-06-06 12:58:55',NULL),(1403,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1404,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1405,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1406,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1407,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1408,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1409,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1410,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1411,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1412,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1413,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1414,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1415,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1416,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2071, periodo->2018-5','2018-06-06 12:58:55',NULL),(1417,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1418,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1419,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1420,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL);
INSERT INTO `log_debug` VALUES (1421,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1422,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1423,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1424,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1425,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1426,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1427,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1428,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1429,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1430,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2072, periodo->2018-5','2018-06-06 12:58:55',NULL),(1431,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1432,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1433,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1434,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1435,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1436,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1437,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1438,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1439,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1440,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1441,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1442,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1443,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1444,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2073, periodo->2018-5','2018-06-06 12:58:55',NULL),(1445,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1446,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1447,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1448,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1449,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1450,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1451,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1452,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1453,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL);
INSERT INTO `log_debug` VALUES (1454,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1455,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1456,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1457,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1458,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2074, periodo->2018-5','2018-06-06 12:58:55',NULL),(1459,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1460,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1461,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1462,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1463,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1464,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1465,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1466,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1467,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1468,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1469,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1470,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1471,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1472,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2075, periodo->2018-5','2018-06-06 12:58:55',NULL),(1473,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1474,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1475,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1476,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1477,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1478,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1479,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1480,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1481,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1482,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1483,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1484,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1485,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1486,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2076, periodo->2018-5','2018-06-06 12:58:55',NULL);
INSERT INTO `log_debug` VALUES (1487,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1488,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1489,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1490,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1491,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1492,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1493,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1494,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1495,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1496,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1497,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1498,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1499,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1500,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2077, periodo->2018-5','2018-06-06 12:58:55',NULL),(1501,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1502,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1503,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1504,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1505,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1506,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1507,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1508,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1509,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1510,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1511,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1512,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1513,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1514,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2078, periodo->2018-5','2018-06-06 12:58:55',NULL),(1515,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1516,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1517,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1518,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1519,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL);
INSERT INTO `log_debug` VALUES (1520,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1521,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1522,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1523,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1524,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1525,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1526,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1527,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1528,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2079, periodo->2018-5','2018-06-06 12:58:55',NULL),(1529,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1530,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1531,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1532,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1533,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1534,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1535,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1536,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1537,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1538,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1539,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1540,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1541,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1542,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2080, periodo->2018-5','2018-06-06 12:58:55',NULL),(1543,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1544,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1545,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1546,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1547,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1548,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1549,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1550,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1551,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1552,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL);
INSERT INTO `log_debug` VALUES (1553,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1554,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1555,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1556,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2081, periodo->2018-5','2018-06-06 12:58:55',NULL),(1557,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1558,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1559,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1560,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1561,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1562,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1563,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1564,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1565,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1566,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1567,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1568,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1569,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1570,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2082, periodo->2018-5','2018-06-06 12:58:55',NULL),(1571,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1572,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1573,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1574,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1575,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1576,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1577,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1578,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1579,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1580,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1581,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1582,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1583,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1584,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2083, periodo->2018-5','2018-06-06 12:58:55',NULL),(1585,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL);
INSERT INTO `log_debug` VALUES (1586,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1587,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1588,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1589,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1590,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1591,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1592,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1593,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1594,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1595,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1596,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1597,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1598,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2084, periodo->2018-5','2018-06-06 12:58:55',NULL),(1599,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1600,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1601,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1602,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1603,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1604,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1605,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1606,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1607,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1608,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1609,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1610,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1611,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1612,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2085, periodo->2018-5','2018-06-06 12:58:55',NULL),(1613,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1614,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1615,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1616,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1617,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1618,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL);
INSERT INTO `log_debug` VALUES (1619,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1620,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1621,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1622,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1623,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1624,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1625,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1626,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2086, periodo->2018-5','2018-06-06 12:58:55',NULL),(1627,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1628,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1629,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1630,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1631,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1632,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1633,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1634,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1635,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1636,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1637,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1638,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1639,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1640,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2087, periodo->2018-5','2018-06-06 12:58:55',NULL),(1641,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1642,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1643,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1644,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1645,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1646,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1647,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1648,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1649,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1650,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1651,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL);
INSERT INTO `log_debug` VALUES (1652,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1653,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1654,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2088, periodo->2018-5','2018-06-06 12:58:55',NULL),(1655,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1656,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1657,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1658,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1659,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1660,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1661,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1662,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1663,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1664,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1665,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1666,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1667,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1668,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2089, periodo->2018-5','2018-06-06 12:58:55',NULL),(1669,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1670,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1671,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1672,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1673,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1674,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1675,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1676,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1677,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1678,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1679,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1680,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1681,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1682,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2090, periodo->2018-5','2018-06-06 12:58:55',NULL),(1683,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1684,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL);
INSERT INTO `log_debug` VALUES (1685,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1686,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1687,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1688,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1689,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1690,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1691,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1692,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1693,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1694,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1695,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1696,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2091, periodo->2018-5','2018-06-06 12:58:55',NULL),(1697,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1698,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1699,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1700,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1701,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1702,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1703,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1704,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1705,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1706,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1707,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1708,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1709,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1710,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2092, periodo->2018-5','2018-06-06 12:58:55',NULL),(1711,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1712,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1713,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1714,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1715,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1716,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1717,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL);
INSERT INTO `log_debug` VALUES (1718,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1719,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1720,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1721,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1722,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1723,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1724,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2093, periodo->2018-5','2018-06-06 12:58:55',NULL),(1725,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1726,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1727,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1728,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1729,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1730,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1731,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1732,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1733,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1734,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1735,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1736,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1737,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1738,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2094, periodo->2018-5','2018-06-06 12:58:55',NULL),(1739,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1740,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1741,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1742,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1743,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1744,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1745,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1746,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1747,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1748,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1749,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1750,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL);
INSERT INTO `log_debug` VALUES (1751,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1752,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2095, periodo->2018-5','2018-06-06 12:58:55',NULL),(1753,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1754,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1755,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1756,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1757,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1758,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1759,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1760,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1761,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1762,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1763,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1764,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1765,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1766,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2096, periodo->2018-5','2018-06-06 12:58:55',NULL),(1767,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1768,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1769,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1770,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1771,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1772,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1773,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1774,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1775,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1776,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1777,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1778,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1779,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1780,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2097, periodo->2018-5','2018-06-06 12:58:55',NULL),(1781,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1782,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1783,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL);
INSERT INTO `log_debug` VALUES (1784,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1785,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1786,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1787,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1788,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1789,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1790,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1791,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1792,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1793,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1794,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2098, periodo->2018-5','2018-06-06 12:58:55',NULL),(1795,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1796,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1797,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1798,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1799,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1800,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1801,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1802,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1803,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1804,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1805,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1806,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1807,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1808,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2099, periodo->2018-5','2018-06-06 12:58:55',NULL),(1809,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1810,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1811,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1812,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1813,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1814,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1815,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1816,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL);
INSERT INTO `log_debug` VALUES (1817,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1818,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1819,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1820,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1821,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1822,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2100, periodo->2018-5','2018-06-06 12:58:55',NULL),(1823,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1824,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1825,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1826,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1827,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1828,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1829,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1830,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1831,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1832,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1833,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1834,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1835,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1836,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2101, periodo->2018-5','2018-06-06 12:58:55',NULL),(1837,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1838,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1839,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1840,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1841,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1842,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1843,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1844,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1845,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1846,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1847,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1848,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1849,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL);
INSERT INTO `log_debug` VALUES (1850,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2102, periodo->2018-5','2018-06-06 12:58:55',NULL),(1851,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1852,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1853,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1854,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1855,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1856,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1857,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1858,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1859,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1860,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1861,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1862,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1863,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1864,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2104, periodo->2018-5','2018-06-06 12:58:55',NULL),(1865,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1866,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1867,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1868,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1869,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1870,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1871,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1872,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1873,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1874,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1875,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1876,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1877,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1878,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2105, periodo->2018-5','2018-06-06 12:58:55',NULL),(1879,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1880,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1881,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1882,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL);
INSERT INTO `log_debug` VALUES (1883,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1884,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1885,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1886,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1887,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1888,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1889,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1890,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1891,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1892,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2106, periodo->2018-5','2018-06-06 12:58:55',NULL),(1893,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1894,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1895,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1896,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1897,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1898,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1899,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1900,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1901,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1902,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1903,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1904,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1905,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1906,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2107, periodo->2018-5','2018-06-06 12:58:55',NULL),(1907,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1908,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1909,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1910,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1911,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1912,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1913,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1914,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1915,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL);
INSERT INTO `log_debug` VALUES (1916,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1917,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1918,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1919,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1920,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2108, periodo->2018-5','2018-06-06 12:58:55',NULL),(1921,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1922,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1923,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1924,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1925,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1926,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1927,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1928,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1929,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1930,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1931,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1932,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1933,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1934,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2109, periodo->2018-5','2018-06-06 12:58:55',NULL),(1935,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1936,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1937,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1938,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1939,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1940,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1941,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1942,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1943,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1944,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1945,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1946,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1947,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1948,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2110, periodo->2018-5','2018-06-06 12:58:55',NULL);
INSERT INTO `log_debug` VALUES (1949,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1950,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1951,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1952,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1953,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1954,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1955,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1956,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1957,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1958,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1959,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1960,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1961,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1962,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2111, periodo->2018-5','2018-06-06 12:58:55',NULL),(1963,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1964,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1965,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1966,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1967,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1968,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1969,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1970,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1971,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1972,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1973,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1974,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1975,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1976,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2112, periodo->2018-5','2018-06-06 12:58:55',NULL),(1977,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1978,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1979,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1980,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1981,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL);
INSERT INTO `log_debug` VALUES (1982,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1983,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1984,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1985,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(1986,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(1987,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(1988,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(1989,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(1990,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2113, periodo->2018-5','2018-06-06 12:58:55',NULL),(1991,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(1992,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(1993,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(1994,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(1995,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(1996,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(1997,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(1998,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(1999,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(2000,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(2001,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(2002,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(2003,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(2004,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2114, periodo->2018-5','2018-06-06 12:58:55',NULL),(2005,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(2006,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(2007,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(2008,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(2009,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(2010,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(2011,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(2012,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(2013,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(2014,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL);
INSERT INTO `log_debug` VALUES (2015,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(2016,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(2017,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(2018,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2115, periodo->2018-5','2018-06-06 12:58:55',NULL),(2019,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(2020,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(2021,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(2022,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(2023,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(2024,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(2025,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(2026,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(2027,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(2028,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(2029,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(2030,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(2031,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(2032,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2116, periodo->2018-5','2018-06-06 12:58:55',NULL),(2033,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(2034,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(2035,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(2036,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(2037,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(2038,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(2039,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(2040,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(2041,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(2042,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(2043,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(2044,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(2045,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(2046,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2117, periodo->2018-5','2018-06-06 12:58:55',NULL),(2047,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL);
INSERT INTO `log_debug` VALUES (2048,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(2049,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(2050,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(2051,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(2052,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(2053,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(2054,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(2055,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(2056,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(2057,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(2058,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(2059,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(2060,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2118, periodo->2018-5','2018-06-06 12:58:55',NULL),(2061,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(2062,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(2063,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(2064,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(2065,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(2066,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(2067,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(2068,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(2069,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(2070,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(2071,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(2072,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(2073,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(2074,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2119, periodo->2018-5','2018-06-06 12:58:55',NULL),(2075,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(2076,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(2077,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(2078,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(2079,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(2080,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL);
INSERT INTO `log_debug` VALUES (2081,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(2082,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(2083,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(2084,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(2085,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(2086,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(2087,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(2088,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2120, periodo->2018-5','2018-06-06 12:58:55',NULL),(2089,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(2090,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(2091,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(2092,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(2093,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(2094,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(2095,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(2096,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(2097,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(2098,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(2099,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(2100,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(2101,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(2102,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2121, periodo->2018-5','2018-06-06 12:58:55',NULL),(2103,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(2104,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(2105,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(2106,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(2107,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(2108,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(2109,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(2110,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(2111,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(2112,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(2113,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL);
INSERT INTO `log_debug` VALUES (2114,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(2115,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(2116,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2122, periodo->2018-5','2018-06-06 12:58:55',NULL),(2117,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(2118,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(2119,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(2120,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(2121,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(2122,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(2123,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(2124,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(2125,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(2126,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(2127,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(2128,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(2129,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(2130,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2123, periodo->2018-5','2018-06-06 12:58:55',NULL),(2131,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(2132,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(2133,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(2134,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(2135,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(2136,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(2137,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(2138,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(2139,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(2140,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(2141,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(2142,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(2143,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(2144,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2124, periodo->2018-5','2018-06-06 12:58:55',NULL),(2145,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(2146,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL);
INSERT INTO `log_debug` VALUES (2147,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(2148,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(2149,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(2150,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(2151,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(2152,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(2153,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(2154,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(2155,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(2156,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(2157,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(2158,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2125, periodo->2018-5','2018-06-06 12:58:55',NULL),(2159,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(2160,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(2161,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(2162,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(2163,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(2164,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(2165,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(2166,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(2167,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(2168,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(2169,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(2170,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(2171,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(2172,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2126, periodo->2018-5','2018-06-06 12:58:55',NULL),(2173,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(2174,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(2175,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(2176,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(2177,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(2178,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(2179,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL);
INSERT INTO `log_debug` VALUES (2180,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(2181,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(2182,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(2183,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(2184,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(2185,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(2186,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2127, periodo->2018-5','2018-06-06 12:58:55',NULL),(2187,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(2188,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(2189,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(2190,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(2191,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(2192,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(2193,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(2194,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(2195,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(2196,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(2197,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(2198,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(2199,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(2200,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2128, periodo->2018-5','2018-06-06 12:58:55',NULL),(2201,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(2202,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(2203,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(2204,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(2205,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(2206,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(2207,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(2208,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(2209,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(2210,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(2211,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(2212,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL);
INSERT INTO `log_debug` VALUES (2213,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(2214,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2129, periodo->2018-5','2018-06-06 12:58:55',NULL),(2215,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(2216,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(2217,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(2218,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(2219,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(2220,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(2221,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(2222,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(2223,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(2224,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(2225,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(2226,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(2227,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(2228,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2130, periodo->2018-5','2018-06-06 12:58:55',NULL),(2229,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(2230,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(2231,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(2232,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(2233,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(2234,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(2235,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(2236,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(2237,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(2238,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(2239,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(2240,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(2241,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(2242,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2131, periodo->2018-5','2018-06-06 12:58:55',NULL),(2243,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(2244,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(2245,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL);
INSERT INTO `log_debug` VALUES (2246,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(2247,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(2248,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(2249,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(2250,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(2251,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(2252,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(2253,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(2254,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(2255,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(2256,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2132, periodo->2018-5','2018-06-06 12:58:55',NULL),(2257,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(2258,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(2259,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(2260,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(2261,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(2262,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(2263,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(2264,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(2265,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(2266,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(2267,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(2268,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(2269,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(2270,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2133, periodo->2018-5','2018-06-06 12:58:55',NULL),(2271,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(2272,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(2273,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(2274,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(2275,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(2276,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(2277,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(2278,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL);
INSERT INTO `log_debug` VALUES (2279,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(2280,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(2281,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(2282,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(2283,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(2284,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2134, periodo->2018-5','2018-06-06 12:58:55',NULL),(2285,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(2286,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(2287,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(2288,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(2289,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(2290,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(2291,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(2292,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(2293,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(2294,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(2295,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(2296,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(2297,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(2298,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2135, periodo->2018-5','2018-06-06 12:58:55',NULL),(2299,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(2300,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(2301,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(2302,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(2303,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(2304,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(2305,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(2306,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(2307,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(2308,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(2309,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(2310,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(2311,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL);
INSERT INTO `log_debug` VALUES (2312,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2136, periodo->2018-5','2018-06-06 12:58:55',NULL),(2313,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(2314,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(2315,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(2316,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(2317,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(2318,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(2319,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(2320,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(2321,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(2322,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(2323,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(2324,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(2325,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(2326,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2137, periodo->2018-5','2018-06-06 12:58:55',NULL),(2327,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(2328,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(2329,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(2330,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(2331,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(2332,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(2333,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(2334,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(2335,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(2336,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(2337,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(2338,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(2339,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(2340,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2138, periodo->2018-5','2018-06-06 12:58:55',NULL),(2341,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(2342,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(2343,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(2344,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL);
INSERT INTO `log_debug` VALUES (2345,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(2346,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(2347,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(2348,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(2349,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(2350,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(2351,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(2352,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(2353,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(2354,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2139, periodo->2018-5','2018-06-06 12:58:55',NULL),(2355,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(2356,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(2357,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(2358,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(2359,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(2360,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(2361,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(2362,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(2363,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(2364,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(2365,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(2366,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(2367,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(2368,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2140, periodo->2018-5','2018-06-06 12:58:55',NULL),(2369,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(2370,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(2371,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(2372,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(2373,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(2374,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(2375,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(2376,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(2377,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL);
INSERT INTO `log_debug` VALUES (2378,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(2379,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(2380,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(2381,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(2382,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2141, periodo->2018-5','2018-06-06 12:58:55',NULL),(2383,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(2384,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(2385,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(2386,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(2387,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(2388,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(2389,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(2390,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(2391,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(2392,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(2393,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(2394,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(2395,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(2396,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2145, periodo->2018-5','2018-06-06 12:58:55',NULL),(2397,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:55',NULL),(2398,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:55',NULL),(2399,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(2400,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(2401,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(2402,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(2403,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(2404,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(2405,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(2406,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(2407,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(2408,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(2409,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(2410,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2400, periodo->2018-6','2018-06-06 12:58:55',NULL);
INSERT INTO `log_debug` VALUES (2411,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->7, contador->0','2018-06-06 12:58:55',NULL),(2412,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->7, contador->1','2018-06-06 12:58:55',NULL),(2413,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(2414,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(2415,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(2416,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(2417,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(2418,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(2419,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(2420,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(2421,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(2422,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(2423,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(2424,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2402, periodo->2018-6','2018-06-06 12:58:55',NULL),(2425,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->7, contador->0','2018-06-06 12:58:55',NULL),(2426,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->7, contador->1','2018-06-06 12:58:55',NULL),(2427,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:55',NULL),(2428,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:55',NULL),(2429,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:55',NULL),(2430,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:55',NULL),(2431,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:55',NULL),(2432,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:55',NULL),(2433,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:55',NULL),(2434,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:55',NULL),(2435,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:55',NULL),(2436,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:55',NULL),(2437,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:55',NULL),(2438,NULL,'assingMorePeriods','ejecutando funcion','2018-06-14 20:50:14',NULL),(2439,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2, periodo->2030-12','2018-06-14 20:50:14',NULL),(2440,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->13, contador->0','2018-06-14 20:50:14',NULL),(2441,NULL,'assingMorePeriods','While de empresa, year->2031, initial_month->13, contador->1','2018-06-14 20:50:14',NULL),(2442,NULL,'assingMorePeriods','While de empresa, year->2032, initial_month->1, contador->2','2018-06-14 20:50:14',NULL),(2443,NULL,'assingMorePeriods','While de empresa, year->2033, initial_month->1, contador->3','2018-06-14 20:50:14',NULL);
INSERT INTO `log_debug` VALUES (2444,NULL,'assingMorePeriods','While de empresa, year->2034, initial_month->1, contador->4','2018-06-14 20:50:14',NULL),(2445,NULL,'assingMorePeriods','While de empresa, year->2035, initial_month->1, contador->5','2018-06-14 20:50:14',NULL),(2446,NULL,'assingMorePeriods','While de empresa, year->2036, initial_month->1, contador->6','2018-06-14 20:50:14',NULL),(2447,NULL,'assingMorePeriods','While de empresa, year->2037, initial_month->1, contador->7','2018-06-14 20:50:14',NULL),(2448,NULL,'assingMorePeriods','While de empresa, year->2038, initial_month->1, contador->8','2018-06-14 20:50:14',NULL),(2449,NULL,'assingMorePeriods','While de empresa, year->2039, initial_month->1, contador->9','2018-06-14 20:50:14',NULL),(2450,NULL,'assingMorePeriods','While de empresa, year->2040, initial_month->1, contador->10','2018-06-14 20:50:14',NULL),(2451,NULL,'assingMorePeriods','While de empresa, year->2041, initial_month->1, contador->11','2018-06-14 20:50:14',NULL),(2452,NULL,'assingMorePeriods','While de empresa, year->2042, initial_month->1, contador->12','2018-06-14 20:50:14',NULL),(2453,NULL,'assingMorePeriods','While de empresa, year->2043, initial_month->1, contador->13','2018-06-14 20:50:14',NULL),(2454,NULL,'assingMorePeriods','While de empresa, year->2044, initial_month->1, contador->14','2018-06-14 20:50:14',NULL),(2455,NULL,'assingMorePeriods','While de empresa, year->2045, initial_month->1, contador->15','2018-06-14 20:50:14',NULL),(2456,NULL,'assingMorePeriods','While de empresa, year->2046, initial_month->1, contador->16','2018-06-14 20:50:14',NULL),(2457,NULL,'assingMorePeriods','While de empresa, year->2047, initial_month->1, contador->17','2018-06-14 20:50:14',NULL),(2458,NULL,'assingMorePeriods','While de empresa, year->2048, initial_month->1, contador->18','2018-06-14 20:50:14',NULL),(2459,NULL,'assingMorePeriods','While de empresa, year->2049, initial_month->1, contador->19','2018-06-14 20:50:14',NULL),(2460,NULL,'assingMorePeriods','While de empresa, year->2050, initial_month->1, contador->20','2018-06-14 20:50:14',NULL),(2461,NULL,'assingMorePeriods','While de empresa, year->2051, initial_month->1, contador->21','2018-06-14 20:50:14',NULL),(2462,NULL,'assingMorePeriods','While de empresa, year->2052, initial_month->1, contador->22','2018-06-14 20:50:14',NULL),(2463,NULL,'assingMorePeriods','While de empresa, year->2053, initial_month->1, contador->23','2018-06-14 20:50:14',NULL),(2464,NULL,'assingMorePeriods','While de empresa, year->2054, initial_month->1, contador->24','2018-06-14 20:50:14',NULL),(2465,NULL,'assingMorePeriods','While de empresa, year->2055, initial_month->1, contador->25','2018-06-14 20:50:14',NULL),(2466,NULL,'assingMorePeriods','While de empresa, year->2056, initial_month->1, contador->26','2018-06-14 20:50:14',NULL),(2467,NULL,'assingMorePeriods','While de empresa, year->2057, initial_month->1, contador->27','2018-06-14 20:50:14',NULL),(2468,NULL,'assingMorePeriods','While de empresa, year->2058, initial_month->1, contador->28','2018-06-14 20:50:14',NULL),(2469,NULL,'assingMorePeriods','While de empresa, year->2059, initial_month->1, contador->29','2018-06-14 20:50:14',NULL),(2470,NULL,'assingMorePeriods','While de empresa, year->2060, initial_month->1, contador->30','2018-06-14 20:50:14',NULL),(2471,NULL,'assingMorePeriods','While de empresa, year->2061, initial_month->1, contador->31','2018-06-14 20:50:14',NULL),(2472,NULL,'assingMorePeriods','While de empresa, year->2062, initial_month->1, contador->32','2018-06-14 20:50:14',NULL),(2473,NULL,'assingMorePeriods','While de empresa, year->2063, initial_month->1, contador->33','2018-06-14 20:50:14',NULL),(2474,NULL,'assingMorePeriods','While de empresa, year->2064, initial_month->1, contador->34','2018-06-14 20:50:14',NULL),(2475,NULL,'assingMorePeriods','While de empresa, year->2065, initial_month->1, contador->35','2018-06-14 20:50:14',NULL),(2476,NULL,'assingMorePeriods','While de empresa, year->2066, initial_month->1, contador->36','2018-06-14 20:50:14',NULL);
INSERT INTO `log_debug` VALUES (2477,NULL,'assingMorePeriods','While de empresa, year->2067, initial_month->1, contador->37','2018-06-14 20:50:14',NULL),(2478,NULL,'assingMorePeriods','While de empresa, year->2068, initial_month->1, contador->38','2018-06-14 20:50:14',NULL),(2479,NULL,'assingMorePeriods','While de empresa, year->2069, initial_month->1, contador->39','2018-06-14 20:50:14',NULL),(2480,NULL,'assingMorePeriods','While de empresa, year->2070, initial_month->1, contador->40','2018-06-14 20:50:14',NULL),(2481,NULL,'assingMorePeriods','While de empresa, year->2071, initial_month->1, contador->41','2018-06-14 20:50:14',NULL),(2482,NULL,'assingMorePeriods','While de empresa, year->2072, initial_month->1, contador->42','2018-06-14 20:50:14',NULL),(2483,NULL,'assingMorePeriods','While de empresa, year->2073, initial_month->1, contador->43','2018-06-14 20:50:14',NULL),(2484,NULL,'assingMorePeriods','While de empresa, year->2074, initial_month->1, contador->44','2018-06-14 20:50:14',NULL),(2485,NULL,'assingMorePeriods','While de empresa, year->2075, initial_month->1, contador->45','2018-06-14 20:50:14',NULL),(2486,NULL,'assingMorePeriods','While de empresa, year->2076, initial_month->1, contador->46','2018-06-14 20:50:14',NULL),(2487,NULL,'assingMorePeriods','While de empresa, year->2077, initial_month->1, contador->47','2018-06-14 20:50:14',NULL),(2488,NULL,'assingMorePeriods','While de empresa, year->2078, initial_month->1, contador->48','2018-06-14 20:50:14',NULL),(2489,NULL,'assingMorePeriods','While de empresa, year->2079, initial_month->1, contador->49','2018-06-14 20:50:14',NULL),(2490,NULL,'assingMorePeriods','While de empresa, year->2080, initial_month->1, contador->50','2018-06-14 20:50:14',NULL),(2491,NULL,'assingMorePeriods','While de empresa, year->2081, initial_month->1, contador->51','2018-06-14 20:50:14',NULL),(2492,NULL,'assingMorePeriods','While de empresa, year->2082, initial_month->1, contador->52','2018-06-14 20:50:14',NULL),(2493,NULL,'assingMorePeriods','While de empresa, year->2083, initial_month->1, contador->53','2018-06-14 20:50:14',NULL),(2494,NULL,'assingMorePeriods','While de empresa, year->2084, initial_month->1, contador->54','2018-06-14 20:50:14',NULL),(2495,NULL,'assingMorePeriods','While de empresa, year->2085, initial_month->1, contador->55','2018-06-14 20:50:14',NULL),(2496,NULL,'assingMorePeriods','While de empresa, year->2086, initial_month->1, contador->56','2018-06-14 20:50:14',NULL),(2497,NULL,'assingMorePeriods','While de empresa, year->2087, initial_month->1, contador->57','2018-06-14 20:50:14',NULL),(2498,NULL,'assingMorePeriods','While de empresa, year->2088, initial_month->1, contador->58','2018-06-14 20:50:14',NULL),(2499,NULL,'assingMorePeriods','While de empresa, year->2089, initial_month->1, contador->59','2018-06-14 20:50:14',NULL),(2500,NULL,'assingMorePeriods','While de empresa, year->2090, initial_month->1, contador->60','2018-06-14 20:50:14',NULL),(2501,NULL,'assingMorePeriods','While de empresa, year->2091, initial_month->1, contador->61','2018-06-14 20:50:14',NULL),(2502,NULL,'assingMorePeriods','While de empresa, year->2092, initial_month->1, contador->62','2018-06-14 20:50:14',NULL),(2503,NULL,'assingMorePeriods','While de empresa, year->2093, initial_month->1, contador->63','2018-06-14 20:50:14',NULL),(2504,NULL,'assingMorePeriods','While de empresa, year->2094, initial_month->1, contador->64','2018-06-14 20:50:14',NULL),(2505,NULL,'assingMorePeriods','While de empresa, year->2095, initial_month->1, contador->65','2018-06-14 20:50:14',NULL),(2506,NULL,'assingMorePeriods','While de empresa, year->2096, initial_month->1, contador->66','2018-06-14 20:50:14',NULL),(2507,NULL,'assingMorePeriods','While de empresa, year->2097, initial_month->1, contador->67','2018-06-14 20:50:14',NULL),(2508,NULL,'assingMorePeriods','While de empresa, year->2098, initial_month->1, contador->68','2018-06-14 20:50:14',NULL),(2509,NULL,'assingMorePeriods','While de empresa, year->2099, initial_month->1, contador->69','2018-06-14 20:50:14',NULL);
INSERT INTO `log_debug` VALUES (2510,NULL,'assingMorePeriods','While de empresa, year->2100, initial_month->1, contador->70','2018-06-14 20:50:14',NULL),(2511,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->3, periodo->2030-12','2018-06-14 20:50:14',NULL),(2512,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->13, contador->0','2018-06-14 20:50:14',NULL),(2513,NULL,'assingMorePeriods','While de empresa, year->2031, initial_month->13, contador->1','2018-06-14 20:50:14',NULL),(2514,NULL,'assingMorePeriods','While de empresa, year->2032, initial_month->1, contador->2','2018-06-14 20:50:14',NULL),(2515,NULL,'assingMorePeriods','While de empresa, year->2033, initial_month->1, contador->3','2018-06-14 20:50:14',NULL),(2516,NULL,'assingMorePeriods','While de empresa, year->2034, initial_month->1, contador->4','2018-06-14 20:50:14',NULL),(2517,NULL,'assingMorePeriods','While de empresa, year->2035, initial_month->1, contador->5','2018-06-14 20:50:14',NULL),(2518,NULL,'assingMorePeriods','While de empresa, year->2036, initial_month->1, contador->6','2018-06-14 20:50:14',NULL),(2519,NULL,'assingMorePeriods','While de empresa, year->2037, initial_month->1, contador->7','2018-06-14 20:50:14',NULL),(2520,NULL,'assingMorePeriods','While de empresa, year->2038, initial_month->1, contador->8','2018-06-14 20:50:14',NULL),(2521,NULL,'assingMorePeriods','While de empresa, year->2039, initial_month->1, contador->9','2018-06-14 20:50:14',NULL),(2522,NULL,'assingMorePeriods','While de empresa, year->2040, initial_month->1, contador->10','2018-06-14 20:50:14',NULL),(2523,NULL,'assingMorePeriods','While de empresa, year->2041, initial_month->1, contador->11','2018-06-14 20:50:14',NULL),(2524,NULL,'assingMorePeriods','While de empresa, year->2042, initial_month->1, contador->12','2018-06-14 20:50:14',NULL),(2525,NULL,'assingMorePeriods','While de empresa, year->2043, initial_month->1, contador->13','2018-06-14 20:50:14',NULL),(2526,NULL,'assingMorePeriods','While de empresa, year->2044, initial_month->1, contador->14','2018-06-14 20:50:14',NULL),(2527,NULL,'assingMorePeriods','While de empresa, year->2045, initial_month->1, contador->15','2018-06-14 20:50:14',NULL),(2528,NULL,'assingMorePeriods','While de empresa, year->2046, initial_month->1, contador->16','2018-06-14 20:50:14',NULL),(2529,NULL,'assingMorePeriods','While de empresa, year->2047, initial_month->1, contador->17','2018-06-14 20:50:14',NULL),(2530,NULL,'assingMorePeriods','While de empresa, year->2048, initial_month->1, contador->18','2018-06-14 20:50:14',NULL),(2531,NULL,'assingMorePeriods','While de empresa, year->2049, initial_month->1, contador->19','2018-06-14 20:50:14',NULL),(2532,NULL,'assingMorePeriods','While de empresa, year->2050, initial_month->1, contador->20','2018-06-14 20:50:14',NULL),(2533,NULL,'assingMorePeriods','While de empresa, year->2051, initial_month->1, contador->21','2018-06-14 20:50:14',NULL),(2534,NULL,'assingMorePeriods','While de empresa, year->2052, initial_month->1, contador->22','2018-06-14 20:50:14',NULL),(2535,NULL,'assingMorePeriods','While de empresa, year->2053, initial_month->1, contador->23','2018-06-14 20:50:14',NULL),(2536,NULL,'assingMorePeriods','While de empresa, year->2054, initial_month->1, contador->24','2018-06-14 20:50:14',NULL),(2537,NULL,'assingMorePeriods','While de empresa, year->2055, initial_month->1, contador->25','2018-06-14 20:50:14',NULL),(2538,NULL,'assingMorePeriods','While de empresa, year->2056, initial_month->1, contador->26','2018-06-14 20:50:14',NULL),(2539,NULL,'assingMorePeriods','While de empresa, year->2057, initial_month->1, contador->27','2018-06-14 20:50:14',NULL),(2540,NULL,'assingMorePeriods','While de empresa, year->2058, initial_month->1, contador->28','2018-06-14 20:50:14',NULL),(2541,NULL,'assingMorePeriods','While de empresa, year->2059, initial_month->1, contador->29','2018-06-14 20:50:14',NULL),(2542,NULL,'assingMorePeriods','While de empresa, year->2060, initial_month->1, contador->30','2018-06-14 20:50:14',NULL);
INSERT INTO `log_debug` VALUES (2543,NULL,'assingMorePeriods','While de empresa, year->2061, initial_month->1, contador->31','2018-06-14 20:50:14',NULL),(2544,NULL,'assingMorePeriods','While de empresa, year->2062, initial_month->1, contador->32','2018-06-14 20:50:14',NULL),(2545,NULL,'assingMorePeriods','While de empresa, year->2063, initial_month->1, contador->33','2018-06-14 20:50:14',NULL),(2546,NULL,'assingMorePeriods','While de empresa, year->2064, initial_month->1, contador->34','2018-06-14 20:50:14',NULL),(2547,NULL,'assingMorePeriods','While de empresa, year->2065, initial_month->1, contador->35','2018-06-14 20:50:14',NULL),(2548,NULL,'assingMorePeriods','While de empresa, year->2066, initial_month->1, contador->36','2018-06-14 20:50:14',NULL),(2549,NULL,'assingMorePeriods','While de empresa, year->2067, initial_month->1, contador->37','2018-06-14 20:50:14',NULL),(2550,NULL,'assingMorePeriods','While de empresa, year->2068, initial_month->1, contador->38','2018-06-14 20:50:14',NULL),(2551,NULL,'assingMorePeriods','While de empresa, year->2069, initial_month->1, contador->39','2018-06-14 20:50:14',NULL),(2552,NULL,'assingMorePeriods','While de empresa, year->2070, initial_month->1, contador->40','2018-06-14 20:50:14',NULL),(2553,NULL,'assingMorePeriods','While de empresa, year->2071, initial_month->1, contador->41','2018-06-14 20:50:14',NULL),(2554,NULL,'assingMorePeriods','While de empresa, year->2072, initial_month->1, contador->42','2018-06-14 20:50:14',NULL),(2555,NULL,'assingMorePeriods','While de empresa, year->2073, initial_month->1, contador->43','2018-06-14 20:50:14',NULL),(2556,NULL,'assingMorePeriods','While de empresa, year->2074, initial_month->1, contador->44','2018-06-14 20:50:14',NULL),(2557,NULL,'assingMorePeriods','While de empresa, year->2075, initial_month->1, contador->45','2018-06-14 20:50:14',NULL),(2558,NULL,'assingMorePeriods','While de empresa, year->2076, initial_month->1, contador->46','2018-06-14 20:50:14',NULL),(2559,NULL,'assingMorePeriods','While de empresa, year->2077, initial_month->1, contador->47','2018-06-14 20:50:14',NULL),(2560,NULL,'assingMorePeriods','While de empresa, year->2078, initial_month->1, contador->48','2018-06-14 20:50:14',NULL),(2561,NULL,'assingMorePeriods','While de empresa, year->2079, initial_month->1, contador->49','2018-06-14 20:50:14',NULL),(2562,NULL,'assingMorePeriods','While de empresa, year->2080, initial_month->1, contador->50','2018-06-14 20:50:14',NULL),(2563,NULL,'assingMorePeriods','While de empresa, year->2081, initial_month->1, contador->51','2018-06-14 20:50:14',NULL),(2564,NULL,'assingMorePeriods','While de empresa, year->2082, initial_month->1, contador->52','2018-06-14 20:50:14',NULL),(2565,NULL,'assingMorePeriods','While de empresa, year->2083, initial_month->1, contador->53','2018-06-14 20:50:14',NULL),(2566,NULL,'assingMorePeriods','While de empresa, year->2084, initial_month->1, contador->54','2018-06-14 20:50:14',NULL),(2567,NULL,'assingMorePeriods','While de empresa, year->2085, initial_month->1, contador->55','2018-06-14 20:50:14',NULL),(2568,NULL,'assingMorePeriods','While de empresa, year->2086, initial_month->1, contador->56','2018-06-14 20:50:14',NULL),(2569,NULL,'assingMorePeriods','While de empresa, year->2087, initial_month->1, contador->57','2018-06-14 20:50:14',NULL),(2570,NULL,'assingMorePeriods','While de empresa, year->2088, initial_month->1, contador->58','2018-06-14 20:50:14',NULL),(2571,NULL,'assingMorePeriods','While de empresa, year->2089, initial_month->1, contador->59','2018-06-14 20:50:14',NULL),(2572,NULL,'assingMorePeriods','While de empresa, year->2090, initial_month->1, contador->60','2018-06-14 20:50:14',NULL),(2573,NULL,'assingMorePeriods','While de empresa, year->2091, initial_month->1, contador->61','2018-06-14 20:50:14',NULL),(2574,NULL,'assingMorePeriods','While de empresa, year->2092, initial_month->1, contador->62','2018-06-14 20:50:14',NULL),(2575,NULL,'assingMorePeriods','While de empresa, year->2093, initial_month->1, contador->63','2018-06-14 20:50:14',NULL);
INSERT INTO `log_debug` VALUES (2576,NULL,'assingMorePeriods','While de empresa, year->2094, initial_month->1, contador->64','2018-06-14 20:50:14',NULL),(2577,NULL,'assingMorePeriods','While de empresa, year->2095, initial_month->1, contador->65','2018-06-14 20:50:14',NULL),(2578,NULL,'assingMorePeriods','While de empresa, year->2096, initial_month->1, contador->66','2018-06-14 20:50:14',NULL),(2579,NULL,'assingMorePeriods','While de empresa, year->2097, initial_month->1, contador->67','2018-06-14 20:50:14',NULL),(2580,NULL,'assingMorePeriods','While de empresa, year->2098, initial_month->1, contador->68','2018-06-14 20:50:14',NULL),(2581,NULL,'assingMorePeriods','While de empresa, year->2099, initial_month->1, contador->69','2018-06-14 20:50:14',NULL),(2582,NULL,'assingMorePeriods','While de empresa, year->2100, initial_month->1, contador->70','2018-06-14 20:50:14',NULL),(2583,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->5, periodo->2030-12','2018-06-14 20:50:14',NULL),(2584,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->13, contador->0','2018-06-14 20:50:14',NULL),(2585,NULL,'assingMorePeriods','While de empresa, year->2031, initial_month->13, contador->1','2018-06-14 20:50:14',NULL),(2586,NULL,'assingMorePeriods','While de empresa, year->2032, initial_month->1, contador->2','2018-06-14 20:50:14',NULL),(2587,NULL,'assingMorePeriods','While de empresa, year->2033, initial_month->1, contador->3','2018-06-14 20:50:14',NULL),(2588,NULL,'assingMorePeriods','While de empresa, year->2034, initial_month->1, contador->4','2018-06-14 20:50:14',NULL),(2589,NULL,'assingMorePeriods','While de empresa, year->2035, initial_month->1, contador->5','2018-06-14 20:50:14',NULL),(2590,NULL,'assingMorePeriods','While de empresa, year->2036, initial_month->1, contador->6','2018-06-14 20:50:14',NULL),(2591,NULL,'assingMorePeriods','While de empresa, year->2037, initial_month->1, contador->7','2018-06-14 20:50:14',NULL),(2592,NULL,'assingMorePeriods','While de empresa, year->2038, initial_month->1, contador->8','2018-06-14 20:50:14',NULL),(2593,NULL,'assingMorePeriods','While de empresa, year->2039, initial_month->1, contador->9','2018-06-14 20:50:14',NULL),(2594,NULL,'assingMorePeriods','While de empresa, year->2040, initial_month->1, contador->10','2018-06-14 20:50:14',NULL),(2595,NULL,'assingMorePeriods','While de empresa, year->2041, initial_month->1, contador->11','2018-06-14 20:50:14',NULL),(2596,NULL,'assingMorePeriods','While de empresa, year->2042, initial_month->1, contador->12','2018-06-14 20:50:14',NULL),(2597,NULL,'assingMorePeriods','While de empresa, year->2043, initial_month->1, contador->13','2018-06-14 20:50:14',NULL),(2598,NULL,'assingMorePeriods','While de empresa, year->2044, initial_month->1, contador->14','2018-06-14 20:50:14',NULL),(2599,NULL,'assingMorePeriods','While de empresa, year->2045, initial_month->1, contador->15','2018-06-14 20:50:14',NULL),(2600,NULL,'assingMorePeriods','While de empresa, year->2046, initial_month->1, contador->16','2018-06-14 20:50:14',NULL),(2601,NULL,'assingMorePeriods','While de empresa, year->2047, initial_month->1, contador->17','2018-06-14 20:50:14',NULL),(2602,NULL,'assingMorePeriods','While de empresa, year->2048, initial_month->1, contador->18','2018-06-14 20:50:14',NULL),(2603,NULL,'assingMorePeriods','While de empresa, year->2049, initial_month->1, contador->19','2018-06-14 20:50:14',NULL),(2604,NULL,'assingMorePeriods','While de empresa, year->2050, initial_month->1, contador->20','2018-06-14 20:50:14',NULL),(2605,NULL,'assingMorePeriods','While de empresa, year->2051, initial_month->1, contador->21','2018-06-14 20:50:14',NULL),(2606,NULL,'assingMorePeriods','While de empresa, year->2052, initial_month->1, contador->22','2018-06-14 20:50:14',NULL),(2607,NULL,'assingMorePeriods','While de empresa, year->2053, initial_month->1, contador->23','2018-06-14 20:50:14',NULL),(2608,NULL,'assingMorePeriods','While de empresa, year->2054, initial_month->1, contador->24','2018-06-14 20:50:14',NULL);
INSERT INTO `log_debug` VALUES (2609,NULL,'assingMorePeriods','While de empresa, year->2055, initial_month->1, contador->25','2018-06-14 20:50:14',NULL),(2610,NULL,'assingMorePeriods','While de empresa, year->2056, initial_month->1, contador->26','2018-06-14 20:50:14',NULL),(2611,NULL,'assingMorePeriods','While de empresa, year->2057, initial_month->1, contador->27','2018-06-14 20:50:14',NULL),(2612,NULL,'assingMorePeriods','While de empresa, year->2058, initial_month->1, contador->28','2018-06-14 20:50:14',NULL),(2613,NULL,'assingMorePeriods','While de empresa, year->2059, initial_month->1, contador->29','2018-06-14 20:50:14',NULL),(2614,NULL,'assingMorePeriods','While de empresa, year->2060, initial_month->1, contador->30','2018-06-14 20:50:14',NULL),(2615,NULL,'assingMorePeriods','While de empresa, year->2061, initial_month->1, contador->31','2018-06-14 20:50:14',NULL),(2616,NULL,'assingMorePeriods','While de empresa, year->2062, initial_month->1, contador->32','2018-06-14 20:50:14',NULL),(2617,NULL,'assingMorePeriods','While de empresa, year->2063, initial_month->1, contador->33','2018-06-14 20:50:14',NULL),(2618,NULL,'assingMorePeriods','While de empresa, year->2064, initial_month->1, contador->34','2018-06-14 20:50:14',NULL),(2619,NULL,'assingMorePeriods','While de empresa, year->2065, initial_month->1, contador->35','2018-06-14 20:50:14',NULL),(2620,NULL,'assingMorePeriods','While de empresa, year->2066, initial_month->1, contador->36','2018-06-14 20:50:14',NULL),(2621,NULL,'assingMorePeriods','While de empresa, year->2067, initial_month->1, contador->37','2018-06-14 20:50:14',NULL),(2622,NULL,'assingMorePeriods','While de empresa, year->2068, initial_month->1, contador->38','2018-06-14 20:50:14',NULL),(2623,NULL,'assingMorePeriods','While de empresa, year->2069, initial_month->1, contador->39','2018-06-14 20:50:14',NULL),(2624,NULL,'assingMorePeriods','While de empresa, year->2070, initial_month->1, contador->40','2018-06-14 20:50:14',NULL),(2625,NULL,'assingMorePeriods','While de empresa, year->2071, initial_month->1, contador->41','2018-06-14 20:50:14',NULL),(2626,NULL,'assingMorePeriods','While de empresa, year->2072, initial_month->1, contador->42','2018-06-14 20:50:14',NULL),(2627,NULL,'assingMorePeriods','While de empresa, year->2073, initial_month->1, contador->43','2018-06-14 20:50:14',NULL),(2628,NULL,'assingMorePeriods','While de empresa, year->2074, initial_month->1, contador->44','2018-06-14 20:50:14',NULL),(2629,NULL,'assingMorePeriods','While de empresa, year->2075, initial_month->1, contador->45','2018-06-14 20:50:14',NULL),(2630,NULL,'assingMorePeriods','While de empresa, year->2076, initial_month->1, contador->46','2018-06-14 20:50:14',NULL),(2631,NULL,'assingMorePeriods','While de empresa, year->2077, initial_month->1, contador->47','2018-06-14 20:50:14',NULL),(2632,NULL,'assingMorePeriods','While de empresa, year->2078, initial_month->1, contador->48','2018-06-14 20:50:14',NULL),(2633,NULL,'assingMorePeriods','While de empresa, year->2079, initial_month->1, contador->49','2018-06-14 20:50:14',NULL),(2634,NULL,'assingMorePeriods','While de empresa, year->2080, initial_month->1, contador->50','2018-06-14 20:50:14',NULL),(2635,NULL,'assingMorePeriods','While de empresa, year->2081, initial_month->1, contador->51','2018-06-14 20:50:14',NULL),(2636,NULL,'assingMorePeriods','While de empresa, year->2082, initial_month->1, contador->52','2018-06-14 20:50:14',NULL),(2637,NULL,'assingMorePeriods','While de empresa, year->2083, initial_month->1, contador->53','2018-06-14 20:50:14',NULL),(2638,NULL,'assingMorePeriods','While de empresa, year->2084, initial_month->1, contador->54','2018-06-14 20:50:14',NULL),(2639,NULL,'assingMorePeriods','While de empresa, year->2085, initial_month->1, contador->55','2018-06-14 20:50:14',NULL),(2640,NULL,'assingMorePeriods','While de empresa, year->2086, initial_month->1, contador->56','2018-06-14 20:50:14',NULL),(2641,NULL,'assingMorePeriods','While de empresa, year->2087, initial_month->1, contador->57','2018-06-14 20:50:14',NULL);
INSERT INTO `log_debug` VALUES (2642,NULL,'assingMorePeriods','While de empresa, year->2088, initial_month->1, contador->58','2018-06-14 20:50:14',NULL),(2643,NULL,'assingMorePeriods','While de empresa, year->2089, initial_month->1, contador->59','2018-06-14 20:50:14',NULL),(2644,NULL,'assingMorePeriods','While de empresa, year->2090, initial_month->1, contador->60','2018-06-14 20:50:14',NULL),(2645,NULL,'assingMorePeriods','While de empresa, year->2091, initial_month->1, contador->61','2018-06-14 20:50:14',NULL),(2646,NULL,'assingMorePeriods','While de empresa, year->2092, initial_month->1, contador->62','2018-06-14 20:50:14',NULL),(2647,NULL,'assingMorePeriods','While de empresa, year->2093, initial_month->1, contador->63','2018-06-14 20:50:14',NULL),(2648,NULL,'assingMorePeriods','While de empresa, year->2094, initial_month->1, contador->64','2018-06-14 20:50:14',NULL),(2649,NULL,'assingMorePeriods','While de empresa, year->2095, initial_month->1, contador->65','2018-06-14 20:50:14',NULL),(2650,NULL,'assingMorePeriods','While de empresa, year->2096, initial_month->1, contador->66','2018-06-14 20:50:14',NULL),(2651,NULL,'assingMorePeriods','While de empresa, year->2097, initial_month->1, contador->67','2018-06-14 20:50:14',NULL),(2652,NULL,'assingMorePeriods','While de empresa, year->2098, initial_month->1, contador->68','2018-06-14 20:50:14',NULL),(2653,NULL,'assingMorePeriods','While de empresa, year->2099, initial_month->1, contador->69','2018-06-14 20:50:14',NULL),(2654,NULL,'assingMorePeriods','While de empresa, year->2100, initial_month->1, contador->70','2018-06-14 20:50:14',NULL),(2655,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->96, periodo->2030-12','2018-06-14 20:50:14',NULL),(2656,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->13, contador->0','2018-06-14 20:50:14',NULL),(2657,NULL,'assingMorePeriods','While de empresa, year->2031, initial_month->13, contador->1','2018-06-14 20:50:14',NULL),(2658,NULL,'assingMorePeriods','While de empresa, year->2032, initial_month->1, contador->2','2018-06-14 20:50:14',NULL),(2659,NULL,'assingMorePeriods','While de empresa, year->2033, initial_month->1, contador->3','2018-06-14 20:50:14',NULL),(2660,NULL,'assingMorePeriods','While de empresa, year->2034, initial_month->1, contador->4','2018-06-14 20:50:14',NULL),(2661,NULL,'assingMorePeriods','While de empresa, year->2035, initial_month->1, contador->5','2018-06-14 20:50:14',NULL),(2662,NULL,'assingMorePeriods','While de empresa, year->2036, initial_month->1, contador->6','2018-06-14 20:50:14',NULL),(2663,NULL,'assingMorePeriods','While de empresa, year->2037, initial_month->1, contador->7','2018-06-14 20:50:14',NULL),(2664,NULL,'assingMorePeriods','While de empresa, year->2038, initial_month->1, contador->8','2018-06-14 20:50:14',NULL),(2665,NULL,'assingMorePeriods','While de empresa, year->2039, initial_month->1, contador->9','2018-06-14 20:50:14',NULL),(2666,NULL,'assingMorePeriods','While de empresa, year->2040, initial_month->1, contador->10','2018-06-14 20:50:14',NULL),(2667,NULL,'assingMorePeriods','While de empresa, year->2041, initial_month->1, contador->11','2018-06-14 20:50:14',NULL),(2668,NULL,'assingMorePeriods','While de empresa, year->2042, initial_month->1, contador->12','2018-06-14 20:50:14',NULL),(2669,NULL,'assingMorePeriods','While de empresa, year->2043, initial_month->1, contador->13','2018-06-14 20:50:14',NULL),(2670,NULL,'assingMorePeriods','While de empresa, year->2044, initial_month->1, contador->14','2018-06-14 20:50:14',NULL),(2671,NULL,'assingMorePeriods','While de empresa, year->2045, initial_month->1, contador->15','2018-06-14 20:50:14',NULL),(2672,NULL,'assingMorePeriods','While de empresa, year->2046, initial_month->1, contador->16','2018-06-14 20:50:14',NULL),(2673,NULL,'assingMorePeriods','While de empresa, year->2047, initial_month->1, contador->17','2018-06-14 20:50:14',NULL),(2674,NULL,'assingMorePeriods','While de empresa, year->2048, initial_month->1, contador->18','2018-06-14 20:50:14',NULL);
INSERT INTO `log_debug` VALUES (2675,NULL,'assingMorePeriods','While de empresa, year->2049, initial_month->1, contador->19','2018-06-14 20:50:14',NULL),(2676,NULL,'assingMorePeriods','While de empresa, year->2050, initial_month->1, contador->20','2018-06-14 20:50:14',NULL),(2677,NULL,'assingMorePeriods','While de empresa, year->2051, initial_month->1, contador->21','2018-06-14 20:50:14',NULL),(2678,NULL,'assingMorePeriods','While de empresa, year->2052, initial_month->1, contador->22','2018-06-14 20:50:14',NULL),(2679,NULL,'assingMorePeriods','While de empresa, year->2053, initial_month->1, contador->23','2018-06-14 20:50:14',NULL),(2680,NULL,'assingMorePeriods','While de empresa, year->2054, initial_month->1, contador->24','2018-06-14 20:50:14',NULL),(2681,NULL,'assingMorePeriods','While de empresa, year->2055, initial_month->1, contador->25','2018-06-14 20:50:14',NULL),(2682,NULL,'assingMorePeriods','While de empresa, year->2056, initial_month->1, contador->26','2018-06-14 20:50:14',NULL),(2683,NULL,'assingMorePeriods','While de empresa, year->2057, initial_month->1, contador->27','2018-06-14 20:50:14',NULL),(2684,NULL,'assingMorePeriods','While de empresa, year->2058, initial_month->1, contador->28','2018-06-14 20:50:14',NULL),(2685,NULL,'assingMorePeriods','While de empresa, year->2059, initial_month->1, contador->29','2018-06-14 20:50:14',NULL),(2686,NULL,'assingMorePeriods','While de empresa, year->2060, initial_month->1, contador->30','2018-06-14 20:50:14',NULL),(2687,NULL,'assingMorePeriods','While de empresa, year->2061, initial_month->1, contador->31','2018-06-14 20:50:14',NULL),(2688,NULL,'assingMorePeriods','While de empresa, year->2062, initial_month->1, contador->32','2018-06-14 20:50:14',NULL),(2689,NULL,'assingMorePeriods','While de empresa, year->2063, initial_month->1, contador->33','2018-06-14 20:50:14',NULL),(2690,NULL,'assingMorePeriods','While de empresa, year->2064, initial_month->1, contador->34','2018-06-14 20:50:14',NULL),(2691,NULL,'assingMorePeriods','While de empresa, year->2065, initial_month->1, contador->35','2018-06-14 20:50:14',NULL),(2692,NULL,'assingMorePeriods','While de empresa, year->2066, initial_month->1, contador->36','2018-06-14 20:50:14',NULL),(2693,NULL,'assingMorePeriods','While de empresa, year->2067, initial_month->1, contador->37','2018-06-14 20:50:14',NULL),(2694,NULL,'assingMorePeriods','While de empresa, year->2068, initial_month->1, contador->38','2018-06-14 20:50:14',NULL),(2695,NULL,'assingMorePeriods','While de empresa, year->2069, initial_month->1, contador->39','2018-06-14 20:50:14',NULL),(2696,NULL,'assingMorePeriods','While de empresa, year->2070, initial_month->1, contador->40','2018-06-14 20:50:14',NULL),(2697,NULL,'assingMorePeriods','While de empresa, year->2071, initial_month->1, contador->41','2018-06-14 20:50:14',NULL),(2698,NULL,'assingMorePeriods','While de empresa, year->2072, initial_month->1, contador->42','2018-06-14 20:50:14',NULL),(2699,NULL,'assingMorePeriods','While de empresa, year->2073, initial_month->1, contador->43','2018-06-14 20:50:14',NULL),(2700,NULL,'assingMorePeriods','While de empresa, year->2074, initial_month->1, contador->44','2018-06-14 20:50:14',NULL),(2701,NULL,'assingMorePeriods','While de empresa, year->2075, initial_month->1, contador->45','2018-06-14 20:50:14',NULL),(2702,NULL,'assingMorePeriods','While de empresa, year->2076, initial_month->1, contador->46','2018-06-14 20:50:14',NULL),(2703,NULL,'assingMorePeriods','While de empresa, year->2077, initial_month->1, contador->47','2018-06-14 20:50:14',NULL),(2704,NULL,'assingMorePeriods','While de empresa, year->2078, initial_month->1, contador->48','2018-06-14 20:50:14',NULL),(2705,NULL,'assingMorePeriods','While de empresa, year->2079, initial_month->1, contador->49','2018-06-14 20:50:14',NULL),(2706,NULL,'assingMorePeriods','While de empresa, year->2080, initial_month->1, contador->50','2018-06-14 20:50:14',NULL),(2707,NULL,'assingMorePeriods','While de empresa, year->2081, initial_month->1, contador->51','2018-06-14 20:50:14',NULL);
INSERT INTO `log_debug` VALUES (2708,NULL,'assingMorePeriods','While de empresa, year->2082, initial_month->1, contador->52','2018-06-14 20:50:14',NULL),(2709,NULL,'assingMorePeriods','While de empresa, year->2083, initial_month->1, contador->53','2018-06-14 20:50:14',NULL),(2710,NULL,'assingMorePeriods','While de empresa, year->2084, initial_month->1, contador->54','2018-06-14 20:50:14',NULL),(2711,NULL,'assingMorePeriods','While de empresa, year->2085, initial_month->1, contador->55','2018-06-14 20:50:14',NULL),(2712,NULL,'assingMorePeriods','While de empresa, year->2086, initial_month->1, contador->56','2018-06-14 20:50:14',NULL),(2713,NULL,'assingMorePeriods','While de empresa, year->2087, initial_month->1, contador->57','2018-06-14 20:50:14',NULL),(2714,NULL,'assingMorePeriods','While de empresa, year->2088, initial_month->1, contador->58','2018-06-14 20:50:14',NULL),(2715,NULL,'assingMorePeriods','While de empresa, year->2089, initial_month->1, contador->59','2018-06-14 20:50:14',NULL),(2716,NULL,'assingMorePeriods','While de empresa, year->2090, initial_month->1, contador->60','2018-06-14 20:50:14',NULL),(2717,NULL,'assingMorePeriods','While de empresa, year->2091, initial_month->1, contador->61','2018-06-14 20:50:14',NULL),(2718,NULL,'assingMorePeriods','While de empresa, year->2092, initial_month->1, contador->62','2018-06-14 20:50:14',NULL),(2719,NULL,'assingMorePeriods','While de empresa, year->2093, initial_month->1, contador->63','2018-06-14 20:50:14',NULL),(2720,NULL,'assingMorePeriods','While de empresa, year->2094, initial_month->1, contador->64','2018-06-14 20:50:14',NULL),(2721,NULL,'assingMorePeriods','While de empresa, year->2095, initial_month->1, contador->65','2018-06-14 20:50:14',NULL),(2722,NULL,'assingMorePeriods','While de empresa, year->2096, initial_month->1, contador->66','2018-06-14 20:50:14',NULL),(2723,NULL,'assingMorePeriods','While de empresa, year->2097, initial_month->1, contador->67','2018-06-14 20:50:14',NULL),(2724,NULL,'assingMorePeriods','While de empresa, year->2098, initial_month->1, contador->68','2018-06-14 20:50:14',NULL),(2725,NULL,'assingMorePeriods','While de empresa, year->2099, initial_month->1, contador->69','2018-06-14 20:50:14',NULL),(2726,NULL,'assingMorePeriods','While de empresa, year->2100, initial_month->1, contador->70','2018-06-14 20:50:14',NULL),(2727,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->338, periodo->2030-12','2018-06-14 20:50:14',NULL),(2728,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->13, contador->0','2018-06-14 20:50:14',NULL),(2729,NULL,'assingMorePeriods','While de empresa, year->2031, initial_month->13, contador->1','2018-06-14 20:50:14',NULL),(2730,NULL,'assingMorePeriods','While de empresa, year->2032, initial_month->1, contador->2','2018-06-14 20:50:14',NULL),(2731,NULL,'assingMorePeriods','While de empresa, year->2033, initial_month->1, contador->3','2018-06-14 20:50:14',NULL),(2732,NULL,'assingMorePeriods','While de empresa, year->2034, initial_month->1, contador->4','2018-06-14 20:50:14',NULL),(2733,NULL,'assingMorePeriods','While de empresa, year->2035, initial_month->1, contador->5','2018-06-14 20:50:14',NULL),(2734,NULL,'assingMorePeriods','While de empresa, year->2036, initial_month->1, contador->6','2018-06-14 20:50:14',NULL),(2735,NULL,'assingMorePeriods','While de empresa, year->2037, initial_month->1, contador->7','2018-06-14 20:50:14',NULL),(2736,NULL,'assingMorePeriods','While de empresa, year->2038, initial_month->1, contador->8','2018-06-14 20:50:14',NULL),(2737,NULL,'assingMorePeriods','While de empresa, year->2039, initial_month->1, contador->9','2018-06-14 20:50:14',NULL),(2738,NULL,'assingMorePeriods','While de empresa, year->2040, initial_month->1, contador->10','2018-06-14 20:50:14',NULL),(2739,NULL,'assingMorePeriods','While de empresa, year->2041, initial_month->1, contador->11','2018-06-14 20:50:14',NULL),(2740,NULL,'assingMorePeriods','While de empresa, year->2042, initial_month->1, contador->12','2018-06-14 20:50:14',NULL);
INSERT INTO `log_debug` VALUES (2741,NULL,'assingMorePeriods','While de empresa, year->2043, initial_month->1, contador->13','2018-06-14 20:50:14',NULL),(2742,NULL,'assingMorePeriods','While de empresa, year->2044, initial_month->1, contador->14','2018-06-14 20:50:14',NULL),(2743,NULL,'assingMorePeriods','While de empresa, year->2045, initial_month->1, contador->15','2018-06-14 20:50:14',NULL),(2744,NULL,'assingMorePeriods','While de empresa, year->2046, initial_month->1, contador->16','2018-06-14 20:50:14',NULL),(2745,NULL,'assingMorePeriods','While de empresa, year->2047, initial_month->1, contador->17','2018-06-14 20:50:14',NULL),(2746,NULL,'assingMorePeriods','While de empresa, year->2048, initial_month->1, contador->18','2018-06-14 20:50:14',NULL),(2747,NULL,'assingMorePeriods','While de empresa, year->2049, initial_month->1, contador->19','2018-06-14 20:50:14',NULL),(2748,NULL,'assingMorePeriods','While de empresa, year->2050, initial_month->1, contador->20','2018-06-14 20:50:14',NULL),(2749,NULL,'assingMorePeriods','While de empresa, year->2051, initial_month->1, contador->21','2018-06-14 20:50:14',NULL),(2750,NULL,'assingMorePeriods','While de empresa, year->2052, initial_month->1, contador->22','2018-06-14 20:50:14',NULL),(2751,NULL,'assingMorePeriods','While de empresa, year->2053, initial_month->1, contador->23','2018-06-14 20:50:14',NULL),(2752,NULL,'assingMorePeriods','While de empresa, year->2054, initial_month->1, contador->24','2018-06-14 20:50:14',NULL),(2753,NULL,'assingMorePeriods','While de empresa, year->2055, initial_month->1, contador->25','2018-06-14 20:50:14',NULL),(2754,NULL,'assingMorePeriods','While de empresa, year->2056, initial_month->1, contador->26','2018-06-14 20:50:14',NULL),(2755,NULL,'assingMorePeriods','While de empresa, year->2057, initial_month->1, contador->27','2018-06-14 20:50:14',NULL),(2756,NULL,'assingMorePeriods','While de empresa, year->2058, initial_month->1, contador->28','2018-06-14 20:50:14',NULL),(2757,NULL,'assingMorePeriods','While de empresa, year->2059, initial_month->1, contador->29','2018-06-14 20:50:14',NULL),(2758,NULL,'assingMorePeriods','While de empresa, year->2060, initial_month->1, contador->30','2018-06-14 20:50:14',NULL),(2759,NULL,'assingMorePeriods','While de empresa, year->2061, initial_month->1, contador->31','2018-06-14 20:50:14',NULL),(2760,NULL,'assingMorePeriods','While de empresa, year->2062, initial_month->1, contador->32','2018-06-14 20:50:14',NULL),(2761,NULL,'assingMorePeriods','While de empresa, year->2063, initial_month->1, contador->33','2018-06-14 20:50:14',NULL),(2762,NULL,'assingMorePeriods','While de empresa, year->2064, initial_month->1, contador->34','2018-06-14 20:50:14',NULL),(2763,NULL,'assingMorePeriods','While de empresa, year->2065, initial_month->1, contador->35','2018-06-14 20:50:14',NULL),(2764,NULL,'assingMorePeriods','While de empresa, year->2066, initial_month->1, contador->36','2018-06-14 20:50:14',NULL),(2765,NULL,'assingMorePeriods','While de empresa, year->2067, initial_month->1, contador->37','2018-06-14 20:50:14',NULL),(2766,NULL,'assingMorePeriods','While de empresa, year->2068, initial_month->1, contador->38','2018-06-14 20:50:14',NULL),(2767,NULL,'assingMorePeriods','While de empresa, year->2069, initial_month->1, contador->39','2018-06-14 20:50:14',NULL),(2768,NULL,'assingMorePeriods','While de empresa, year->2070, initial_month->1, contador->40','2018-06-14 20:50:14',NULL),(2769,NULL,'assingMorePeriods','While de empresa, year->2071, initial_month->1, contador->41','2018-06-14 20:50:14',NULL),(2770,NULL,'assingMorePeriods','While de empresa, year->2072, initial_month->1, contador->42','2018-06-14 20:50:14',NULL),(2771,NULL,'assingMorePeriods','While de empresa, year->2073, initial_month->1, contador->43','2018-06-14 20:50:14',NULL),(2772,NULL,'assingMorePeriods','While de empresa, year->2074, initial_month->1, contador->44','2018-06-14 20:50:14',NULL),(2773,NULL,'assingMorePeriods','While de empresa, year->2075, initial_month->1, contador->45','2018-06-14 20:50:14',NULL);
INSERT INTO `log_debug` VALUES (2774,NULL,'assingMorePeriods','While de empresa, year->2076, initial_month->1, contador->46','2018-06-14 20:50:14',NULL),(2775,NULL,'assingMorePeriods','While de empresa, year->2077, initial_month->1, contador->47','2018-06-14 20:50:14',NULL),(2776,NULL,'assingMorePeriods','While de empresa, year->2078, initial_month->1, contador->48','2018-06-14 20:50:14',NULL),(2777,NULL,'assingMorePeriods','While de empresa, year->2079, initial_month->1, contador->49','2018-06-14 20:50:14',NULL),(2778,NULL,'assingMorePeriods','While de empresa, year->2080, initial_month->1, contador->50','2018-06-14 20:50:14',NULL),(2779,NULL,'assingMorePeriods','While de empresa, year->2081, initial_month->1, contador->51','2018-06-14 20:50:14',NULL),(2780,NULL,'assingMorePeriods','While de empresa, year->2082, initial_month->1, contador->52','2018-06-14 20:50:14',NULL),(2781,NULL,'assingMorePeriods','While de empresa, year->2083, initial_month->1, contador->53','2018-06-14 20:50:14',NULL),(2782,NULL,'assingMorePeriods','While de empresa, year->2084, initial_month->1, contador->54','2018-06-14 20:50:14',NULL),(2783,NULL,'assingMorePeriods','While de empresa, year->2085, initial_month->1, contador->55','2018-06-14 20:50:14',NULL),(2784,NULL,'assingMorePeriods','While de empresa, year->2086, initial_month->1, contador->56','2018-06-14 20:50:14',NULL),(2785,NULL,'assingMorePeriods','While de empresa, year->2087, initial_month->1, contador->57','2018-06-14 20:50:14',NULL),(2786,NULL,'assingMorePeriods','While de empresa, year->2088, initial_month->1, contador->58','2018-06-14 20:50:14',NULL),(2787,NULL,'assingMorePeriods','While de empresa, year->2089, initial_month->1, contador->59','2018-06-14 20:50:14',NULL),(2788,NULL,'assingMorePeriods','While de empresa, year->2090, initial_month->1, contador->60','2018-06-14 20:50:14',NULL),(2789,NULL,'assingMorePeriods','While de empresa, year->2091, initial_month->1, contador->61','2018-06-14 20:50:14',NULL),(2790,NULL,'assingMorePeriods','While de empresa, year->2092, initial_month->1, contador->62','2018-06-14 20:50:14',NULL),(2791,NULL,'assingMorePeriods','While de empresa, year->2093, initial_month->1, contador->63','2018-06-14 20:50:14',NULL),(2792,NULL,'assingMorePeriods','While de empresa, year->2094, initial_month->1, contador->64','2018-06-14 20:50:14',NULL),(2793,NULL,'assingMorePeriods','While de empresa, year->2095, initial_month->1, contador->65','2018-06-14 20:50:14',NULL),(2794,NULL,'assingMorePeriods','While de empresa, year->2096, initial_month->1, contador->66','2018-06-14 20:50:14',NULL),(2795,NULL,'assingMorePeriods','While de empresa, year->2097, initial_month->1, contador->67','2018-06-14 20:50:14',NULL),(2796,NULL,'assingMorePeriods','While de empresa, year->2098, initial_month->1, contador->68','2018-06-14 20:50:14',NULL),(2797,NULL,'assingMorePeriods','While de empresa, year->2099, initial_month->1, contador->69','2018-06-14 20:50:14',NULL),(2798,NULL,'assingMorePeriods','While de empresa, year->2100, initial_month->1, contador->70','2018-06-14 20:50:14',NULL),(2799,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->435, periodo->2030-12','2018-06-14 20:50:14',NULL),(2800,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->13, contador->0','2018-06-14 20:50:14',NULL),(2801,NULL,'assingMorePeriods','While de empresa, year->2031, initial_month->13, contador->1','2018-06-14 20:50:14',NULL),(2802,NULL,'assingMorePeriods','While de empresa, year->2032, initial_month->1, contador->2','2018-06-14 20:50:14',NULL),(2803,NULL,'assingMorePeriods','While de empresa, year->2033, initial_month->1, contador->3','2018-06-14 20:50:14',NULL),(2804,NULL,'assingMorePeriods','While de empresa, year->2034, initial_month->1, contador->4','2018-06-14 20:50:14',NULL),(2805,NULL,'assingMorePeriods','While de empresa, year->2035, initial_month->1, contador->5','2018-06-14 20:50:14',NULL),(2806,NULL,'assingMorePeriods','While de empresa, year->2036, initial_month->1, contador->6','2018-06-14 20:50:14',NULL);
INSERT INTO `log_debug` VALUES (2807,NULL,'assingMorePeriods','While de empresa, year->2037, initial_month->1, contador->7','2018-06-14 20:50:14',NULL),(2808,NULL,'assingMorePeriods','While de empresa, year->2038, initial_month->1, contador->8','2018-06-14 20:50:14',NULL),(2809,NULL,'assingMorePeriods','While de empresa, year->2039, initial_month->1, contador->9','2018-06-14 20:50:14',NULL),(2810,NULL,'assingMorePeriods','While de empresa, year->2040, initial_month->1, contador->10','2018-06-14 20:50:14',NULL),(2811,NULL,'assingMorePeriods','While de empresa, year->2041, initial_month->1, contador->11','2018-06-14 20:50:14',NULL),(2812,NULL,'assingMorePeriods','While de empresa, year->2042, initial_month->1, contador->12','2018-06-14 20:50:14',NULL),(2813,NULL,'assingMorePeriods','While de empresa, year->2043, initial_month->1, contador->13','2018-06-14 20:50:14',NULL),(2814,NULL,'assingMorePeriods','While de empresa, year->2044, initial_month->1, contador->14','2018-06-14 20:50:14',NULL),(2815,NULL,'assingMorePeriods','While de empresa, year->2045, initial_month->1, contador->15','2018-06-14 20:50:14',NULL),(2816,NULL,'assingMorePeriods','While de empresa, year->2046, initial_month->1, contador->16','2018-06-14 20:50:14',NULL),(2817,NULL,'assingMorePeriods','While de empresa, year->2047, initial_month->1, contador->17','2018-06-14 20:50:14',NULL),(2818,NULL,'assingMorePeriods','While de empresa, year->2048, initial_month->1, contador->18','2018-06-14 20:50:14',NULL),(2819,NULL,'assingMorePeriods','While de empresa, year->2049, initial_month->1, contador->19','2018-06-14 20:50:14',NULL),(2820,NULL,'assingMorePeriods','While de empresa, year->2050, initial_month->1, contador->20','2018-06-14 20:50:14',NULL),(2821,NULL,'assingMorePeriods','While de empresa, year->2051, initial_month->1, contador->21','2018-06-14 20:50:14',NULL),(2822,NULL,'assingMorePeriods','While de empresa, year->2052, initial_month->1, contador->22','2018-06-14 20:50:14',NULL),(2823,NULL,'assingMorePeriods','While de empresa, year->2053, initial_month->1, contador->23','2018-06-14 20:50:14',NULL),(2824,NULL,'assingMorePeriods','While de empresa, year->2054, initial_month->1, contador->24','2018-06-14 20:50:14',NULL),(2825,NULL,'assingMorePeriods','While de empresa, year->2055, initial_month->1, contador->25','2018-06-14 20:50:14',NULL),(2826,NULL,'assingMorePeriods','While de empresa, year->2056, initial_month->1, contador->26','2018-06-14 20:50:14',NULL),(2827,NULL,'assingMorePeriods','While de empresa, year->2057, initial_month->1, contador->27','2018-06-14 20:50:14',NULL),(2828,NULL,'assingMorePeriods','While de empresa, year->2058, initial_month->1, contador->28','2018-06-14 20:50:14',NULL),(2829,NULL,'assingMorePeriods','While de empresa, year->2059, initial_month->1, contador->29','2018-06-14 20:50:14',NULL),(2830,NULL,'assingMorePeriods','While de empresa, year->2060, initial_month->1, contador->30','2018-06-14 20:50:14',NULL),(2831,NULL,'assingMorePeriods','While de empresa, year->2061, initial_month->1, contador->31','2018-06-14 20:50:14',NULL),(2832,NULL,'assingMorePeriods','While de empresa, year->2062, initial_month->1, contador->32','2018-06-14 20:50:14',NULL),(2833,NULL,'assingMorePeriods','While de empresa, year->2063, initial_month->1, contador->33','2018-06-14 20:50:14',NULL),(2834,NULL,'assingMorePeriods','While de empresa, year->2064, initial_month->1, contador->34','2018-06-14 20:50:14',NULL),(2835,NULL,'assingMorePeriods','While de empresa, year->2065, initial_month->1, contador->35','2018-06-14 20:50:14',NULL),(2836,NULL,'assingMorePeriods','While de empresa, year->2066, initial_month->1, contador->36','2018-06-14 20:50:14',NULL),(2837,NULL,'assingMorePeriods','While de empresa, year->2067, initial_month->1, contador->37','2018-06-14 20:50:14',NULL),(2838,NULL,'assingMorePeriods','While de empresa, year->2068, initial_month->1, contador->38','2018-06-14 20:50:14',NULL),(2839,NULL,'assingMorePeriods','While de empresa, year->2069, initial_month->1, contador->39','2018-06-14 20:50:14',NULL);
INSERT INTO `log_debug` VALUES (2840,NULL,'assingMorePeriods','While de empresa, year->2070, initial_month->1, contador->40','2018-06-14 20:50:14',NULL),(2841,NULL,'assingMorePeriods','While de empresa, year->2071, initial_month->1, contador->41','2018-06-14 20:50:14',NULL),(2842,NULL,'assingMorePeriods','While de empresa, year->2072, initial_month->1, contador->42','2018-06-14 20:50:14',NULL),(2843,NULL,'assingMorePeriods','While de empresa, year->2073, initial_month->1, contador->43','2018-06-14 20:50:14',NULL),(2844,NULL,'assingMorePeriods','While de empresa, year->2074, initial_month->1, contador->44','2018-06-14 20:50:14',NULL),(2845,NULL,'assingMorePeriods','While de empresa, year->2075, initial_month->1, contador->45','2018-06-14 20:50:14',NULL),(2846,NULL,'assingMorePeriods','While de empresa, year->2076, initial_month->1, contador->46','2018-06-14 20:50:14',NULL),(2847,NULL,'assingMorePeriods','While de empresa, year->2077, initial_month->1, contador->47','2018-06-14 20:50:14',NULL),(2848,NULL,'assingMorePeriods','While de empresa, year->2078, initial_month->1, contador->48','2018-06-14 20:50:14',NULL),(2849,NULL,'assingMorePeriods','While de empresa, year->2079, initial_month->1, contador->49','2018-06-14 20:50:14',NULL),(2850,NULL,'assingMorePeriods','While de empresa, year->2080, initial_month->1, contador->50','2018-06-14 20:50:14',NULL),(2851,NULL,'assingMorePeriods','While de empresa, year->2081, initial_month->1, contador->51','2018-06-14 20:50:14',NULL),(2852,NULL,'assingMorePeriods','While de empresa, year->2082, initial_month->1, contador->52','2018-06-14 20:50:14',NULL),(2853,NULL,'assingMorePeriods','While de empresa, year->2083, initial_month->1, contador->53','2018-06-14 20:50:14',NULL),(2854,NULL,'assingMorePeriods','While de empresa, year->2084, initial_month->1, contador->54','2018-06-14 20:50:14',NULL),(2855,NULL,'assingMorePeriods','While de empresa, year->2085, initial_month->1, contador->55','2018-06-14 20:50:14',NULL),(2856,NULL,'assingMorePeriods','While de empresa, year->2086, initial_month->1, contador->56','2018-06-14 20:50:14',NULL),(2857,NULL,'assingMorePeriods','While de empresa, year->2087, initial_month->1, contador->57','2018-06-14 20:50:14',NULL),(2858,NULL,'assingMorePeriods','While de empresa, year->2088, initial_month->1, contador->58','2018-06-14 20:50:14',NULL),(2859,NULL,'assingMorePeriods','While de empresa, year->2089, initial_month->1, contador->59','2018-06-14 20:50:14',NULL),(2860,NULL,'assingMorePeriods','While de empresa, year->2090, initial_month->1, contador->60','2018-06-14 20:50:14',NULL),(2861,NULL,'assingMorePeriods','While de empresa, year->2091, initial_month->1, contador->61','2018-06-14 20:50:14',NULL),(2862,NULL,'assingMorePeriods','While de empresa, year->2092, initial_month->1, contador->62','2018-06-14 20:50:14',NULL),(2863,NULL,'assingMorePeriods','While de empresa, year->2093, initial_month->1, contador->63','2018-06-14 20:50:14',NULL),(2864,NULL,'assingMorePeriods','While de empresa, year->2094, initial_month->1, contador->64','2018-06-14 20:50:14',NULL),(2865,NULL,'assingMorePeriods','While de empresa, year->2095, initial_month->1, contador->65','2018-06-14 20:50:14',NULL),(2866,NULL,'assingMorePeriods','While de empresa, year->2096, initial_month->1, contador->66','2018-06-14 20:50:14',NULL),(2867,NULL,'assingMorePeriods','While de empresa, year->2097, initial_month->1, contador->67','2018-06-14 20:50:14',NULL),(2868,NULL,'assingMorePeriods','While de empresa, year->2098, initial_month->1, contador->68','2018-06-14 20:50:14',NULL),(2869,NULL,'assingMorePeriods','While de empresa, year->2099, initial_month->1, contador->69','2018-06-14 20:50:14',NULL),(2870,NULL,'assingMorePeriods','While de empresa, year->2100, initial_month->1, contador->70','2018-06-14 20:50:14',NULL),(2871,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->436, periodo->2030-12','2018-06-14 20:50:14',NULL),(2872,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->13, contador->0','2018-06-14 20:50:14',NULL);
INSERT INTO `log_debug` VALUES (2873,NULL,'assingMorePeriods','While de empresa, year->2031, initial_month->13, contador->1','2018-06-14 20:50:14',NULL),(2874,NULL,'assingMorePeriods','While de empresa, year->2032, initial_month->1, contador->2','2018-06-14 20:50:14',NULL),(2875,NULL,'assingMorePeriods','While de empresa, year->2033, initial_month->1, contador->3','2018-06-14 20:50:14',NULL),(2876,NULL,'assingMorePeriods','While de empresa, year->2034, initial_month->1, contador->4','2018-06-14 20:50:14',NULL),(2877,NULL,'assingMorePeriods','While de empresa, year->2035, initial_month->1, contador->5','2018-06-14 20:50:14',NULL),(2878,NULL,'assingMorePeriods','While de empresa, year->2036, initial_month->1, contador->6','2018-06-14 20:50:14',NULL),(2879,NULL,'assingMorePeriods','While de empresa, year->2037, initial_month->1, contador->7','2018-06-14 20:50:14',NULL),(2880,NULL,'assingMorePeriods','While de empresa, year->2038, initial_month->1, contador->8','2018-06-14 20:50:14',NULL),(2881,NULL,'assingMorePeriods','While de empresa, year->2039, initial_month->1, contador->9','2018-06-14 20:50:14',NULL),(2882,NULL,'assingMorePeriods','While de empresa, year->2040, initial_month->1, contador->10','2018-06-14 20:50:14',NULL),(2883,NULL,'assingMorePeriods','While de empresa, year->2041, initial_month->1, contador->11','2018-06-14 20:50:14',NULL),(2884,NULL,'assingMorePeriods','While de empresa, year->2042, initial_month->1, contador->12','2018-06-14 20:50:14',NULL),(2885,NULL,'assingMorePeriods','While de empresa, year->2043, initial_month->1, contador->13','2018-06-14 20:50:14',NULL),(2886,NULL,'assingMorePeriods','While de empresa, year->2044, initial_month->1, contador->14','2018-06-14 20:50:14',NULL),(2887,NULL,'assingMorePeriods','While de empresa, year->2045, initial_month->1, contador->15','2018-06-14 20:50:14',NULL),(2888,NULL,'assingMorePeriods','While de empresa, year->2046, initial_month->1, contador->16','2018-06-14 20:50:14',NULL),(2889,NULL,'assingMorePeriods','While de empresa, year->2047, initial_month->1, contador->17','2018-06-14 20:50:14',NULL),(2890,NULL,'assingMorePeriods','While de empresa, year->2048, initial_month->1, contador->18','2018-06-14 20:50:14',NULL),(2891,NULL,'assingMorePeriods','While de empresa, year->2049, initial_month->1, contador->19','2018-06-14 20:50:14',NULL),(2892,NULL,'assingMorePeriods','While de empresa, year->2050, initial_month->1, contador->20','2018-06-14 20:50:14',NULL),(2893,NULL,'assingMorePeriods','While de empresa, year->2051, initial_month->1, contador->21','2018-06-14 20:50:14',NULL),(2894,NULL,'assingMorePeriods','While de empresa, year->2052, initial_month->1, contador->22','2018-06-14 20:50:14',NULL),(2895,NULL,'assingMorePeriods','While de empresa, year->2053, initial_month->1, contador->23','2018-06-14 20:50:14',NULL),(2896,NULL,'assingMorePeriods','While de empresa, year->2054, initial_month->1, contador->24','2018-06-14 20:50:14',NULL),(2897,NULL,'assingMorePeriods','While de empresa, year->2055, initial_month->1, contador->25','2018-06-14 20:50:14',NULL),(2898,NULL,'assingMorePeriods','While de empresa, year->2056, initial_month->1, contador->26','2018-06-14 20:50:14',NULL),(2899,NULL,'assingMorePeriods','While de empresa, year->2057, initial_month->1, contador->27','2018-06-14 20:50:14',NULL),(2900,NULL,'assingMorePeriods','While de empresa, year->2058, initial_month->1, contador->28','2018-06-14 20:50:14',NULL),(2901,NULL,'assingMorePeriods','While de empresa, year->2059, initial_month->1, contador->29','2018-06-14 20:50:14',NULL),(2902,NULL,'assingMorePeriods','While de empresa, year->2060, initial_month->1, contador->30','2018-06-14 20:50:14',NULL),(2903,NULL,'assingMorePeriods','While de empresa, year->2061, initial_month->1, contador->31','2018-06-14 20:50:14',NULL),(2904,NULL,'assingMorePeriods','While de empresa, year->2062, initial_month->1, contador->32','2018-06-14 20:50:14',NULL),(2905,NULL,'assingMorePeriods','While de empresa, year->2063, initial_month->1, contador->33','2018-06-14 20:50:14',NULL);
INSERT INTO `log_debug` VALUES (2906,NULL,'assingMorePeriods','While de empresa, year->2064, initial_month->1, contador->34','2018-06-14 20:50:14',NULL),(2907,NULL,'assingMorePeriods','While de empresa, year->2065, initial_month->1, contador->35','2018-06-14 20:50:14',NULL),(2908,NULL,'assingMorePeriods','While de empresa, year->2066, initial_month->1, contador->36','2018-06-14 20:50:14',NULL),(2909,NULL,'assingMorePeriods','While de empresa, year->2067, initial_month->1, contador->37','2018-06-14 20:50:14',NULL),(2910,NULL,'assingMorePeriods','While de empresa, year->2068, initial_month->1, contador->38','2018-06-14 20:50:14',NULL),(2911,NULL,'assingMorePeriods','While de empresa, year->2069, initial_month->1, contador->39','2018-06-14 20:50:14',NULL),(2912,NULL,'assingMorePeriods','While de empresa, year->2070, initial_month->1, contador->40','2018-06-14 20:50:14',NULL),(2913,NULL,'assingMorePeriods','While de empresa, year->2071, initial_month->1, contador->41','2018-06-14 20:50:14',NULL),(2914,NULL,'assingMorePeriods','While de empresa, year->2072, initial_month->1, contador->42','2018-06-14 20:50:14',NULL),(2915,NULL,'assingMorePeriods','While de empresa, year->2073, initial_month->1, contador->43','2018-06-14 20:50:14',NULL),(2916,NULL,'assingMorePeriods','While de empresa, year->2074, initial_month->1, contador->44','2018-06-14 20:50:14',NULL),(2917,NULL,'assingMorePeriods','While de empresa, year->2075, initial_month->1, contador->45','2018-06-14 20:50:14',NULL),(2918,NULL,'assingMorePeriods','While de empresa, year->2076, initial_month->1, contador->46','2018-06-14 20:50:14',NULL),(2919,NULL,'assingMorePeriods','While de empresa, year->2077, initial_month->1, contador->47','2018-06-14 20:50:14',NULL),(2920,NULL,'assingMorePeriods','While de empresa, year->2078, initial_month->1, contador->48','2018-06-14 20:50:14',NULL),(2921,NULL,'assingMorePeriods','While de empresa, year->2079, initial_month->1, contador->49','2018-06-14 20:50:14',NULL),(2922,NULL,'assingMorePeriods','While de empresa, year->2080, initial_month->1, contador->50','2018-06-14 20:50:14',NULL),(2923,NULL,'assingMorePeriods','While de empresa, year->2081, initial_month->1, contador->51','2018-06-14 20:50:14',NULL),(2924,NULL,'assingMorePeriods','While de empresa, year->2082, initial_month->1, contador->52','2018-06-14 20:50:14',NULL),(2925,NULL,'assingMorePeriods','While de empresa, year->2083, initial_month->1, contador->53','2018-06-14 20:50:14',NULL),(2926,NULL,'assingMorePeriods','While de empresa, year->2084, initial_month->1, contador->54','2018-06-14 20:50:14',NULL),(2927,NULL,'assingMorePeriods','While de empresa, year->2085, initial_month->1, contador->55','2018-06-14 20:50:14',NULL),(2928,NULL,'assingMorePeriods','While de empresa, year->2086, initial_month->1, contador->56','2018-06-14 20:50:14',NULL),(2929,NULL,'assingMorePeriods','While de empresa, year->2087, initial_month->1, contador->57','2018-06-14 20:50:14',NULL),(2930,NULL,'assingMorePeriods','While de empresa, year->2088, initial_month->1, contador->58','2018-06-14 20:50:14',NULL),(2931,NULL,'assingMorePeriods','While de empresa, year->2089, initial_month->1, contador->59','2018-06-14 20:50:14',NULL),(2932,NULL,'assingMorePeriods','While de empresa, year->2090, initial_month->1, contador->60','2018-06-14 20:50:14',NULL),(2933,NULL,'assingMorePeriods','While de empresa, year->2091, initial_month->1, contador->61','2018-06-14 20:50:14',NULL),(2934,NULL,'assingMorePeriods','While de empresa, year->2092, initial_month->1, contador->62','2018-06-14 20:50:14',NULL),(2935,NULL,'assingMorePeriods','While de empresa, year->2093, initial_month->1, contador->63','2018-06-14 20:50:14',NULL),(2936,NULL,'assingMorePeriods','While de empresa, year->2094, initial_month->1, contador->64','2018-06-14 20:50:14',NULL),(2937,NULL,'assingMorePeriods','While de empresa, year->2095, initial_month->1, contador->65','2018-06-14 20:50:14',NULL),(2938,NULL,'assingMorePeriods','While de empresa, year->2096, initial_month->1, contador->66','2018-06-14 20:50:14',NULL);
INSERT INTO `log_debug` VALUES (2939,NULL,'assingMorePeriods','While de empresa, year->2097, initial_month->1, contador->67','2018-06-14 20:50:14',NULL),(2940,NULL,'assingMorePeriods','While de empresa, year->2098, initial_month->1, contador->68','2018-06-14 20:50:14',NULL),(2941,NULL,'assingMorePeriods','While de empresa, year->2099, initial_month->1, contador->69','2018-06-14 20:50:14',NULL),(2942,NULL,'assingMorePeriods','While de empresa, year->2100, initial_month->1, contador->70','2018-06-14 20:50:14',NULL),(2943,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->448, periodo->2030-12','2018-06-14 20:50:14',NULL),(2944,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->13, contador->0','2018-06-14 20:50:14',NULL),(2945,NULL,'assingMorePeriods','While de empresa, year->2031, initial_month->13, contador->1','2018-06-14 20:50:14',NULL),(2946,NULL,'assingMorePeriods','While de empresa, year->2032, initial_month->1, contador->2','2018-06-14 20:50:14',NULL),(2947,NULL,'assingMorePeriods','While de empresa, year->2033, initial_month->1, contador->3','2018-06-14 20:50:14',NULL),(2948,NULL,'assingMorePeriods','While de empresa, year->2034, initial_month->1, contador->4','2018-06-14 20:50:14',NULL),(2949,NULL,'assingMorePeriods','While de empresa, year->2035, initial_month->1, contador->5','2018-06-14 20:50:14',NULL),(2950,NULL,'assingMorePeriods','While de empresa, year->2036, initial_month->1, contador->6','2018-06-14 20:50:14',NULL),(2951,NULL,'assingMorePeriods','While de empresa, year->2037, initial_month->1, contador->7','2018-06-14 20:50:14',NULL),(2952,NULL,'assingMorePeriods','While de empresa, year->2038, initial_month->1, contador->8','2018-06-14 20:50:14',NULL),(2953,NULL,'assingMorePeriods','While de empresa, year->2039, initial_month->1, contador->9','2018-06-14 20:50:14',NULL),(2954,NULL,'assingMorePeriods','While de empresa, year->2040, initial_month->1, contador->10','2018-06-14 20:50:14',NULL),(2955,NULL,'assingMorePeriods','While de empresa, year->2041, initial_month->1, contador->11','2018-06-14 20:50:14',NULL),(2956,NULL,'assingMorePeriods','While de empresa, year->2042, initial_month->1, contador->12','2018-06-14 20:50:14',NULL),(2957,NULL,'assingMorePeriods','While de empresa, year->2043, initial_month->1, contador->13','2018-06-14 20:50:14',NULL),(2958,NULL,'assingMorePeriods','While de empresa, year->2044, initial_month->1, contador->14','2018-06-14 20:50:14',NULL),(2959,NULL,'assingMorePeriods','While de empresa, year->2045, initial_month->1, contador->15','2018-06-14 20:50:14',NULL),(2960,NULL,'assingMorePeriods','While de empresa, year->2046, initial_month->1, contador->16','2018-06-14 20:50:14',NULL),(2961,NULL,'assingMorePeriods','While de empresa, year->2047, initial_month->1, contador->17','2018-06-14 20:50:14',NULL),(2962,NULL,'assingMorePeriods','While de empresa, year->2048, initial_month->1, contador->18','2018-06-14 20:50:14',NULL),(2963,NULL,'assingMorePeriods','While de empresa, year->2049, initial_month->1, contador->19','2018-06-14 20:50:14',NULL),(2964,NULL,'assingMorePeriods','While de empresa, year->2050, initial_month->1, contador->20','2018-06-14 20:50:14',NULL),(2965,NULL,'assingMorePeriods','While de empresa, year->2051, initial_month->1, contador->21','2018-06-14 20:50:14',NULL),(2966,NULL,'assingMorePeriods','While de empresa, year->2052, initial_month->1, contador->22','2018-06-14 20:50:14',NULL),(2967,NULL,'assingMorePeriods','While de empresa, year->2053, initial_month->1, contador->23','2018-06-14 20:50:14',NULL),(2968,NULL,'assingMorePeriods','While de empresa, year->2054, initial_month->1, contador->24','2018-06-14 20:50:14',NULL),(2969,NULL,'assingMorePeriods','While de empresa, year->2055, initial_month->1, contador->25','2018-06-14 20:50:14',NULL),(2970,NULL,'assingMorePeriods','While de empresa, year->2056, initial_month->1, contador->26','2018-06-14 20:50:14',NULL),(2971,NULL,'assingMorePeriods','While de empresa, year->2057, initial_month->1, contador->27','2018-06-14 20:50:14',NULL);
INSERT INTO `log_debug` VALUES (2972,NULL,'assingMorePeriods','While de empresa, year->2058, initial_month->1, contador->28','2018-06-14 20:50:14',NULL),(2973,NULL,'assingMorePeriods','While de empresa, year->2059, initial_month->1, contador->29','2018-06-14 20:50:14',NULL),(2974,NULL,'assingMorePeriods','While de empresa, year->2060, initial_month->1, contador->30','2018-06-14 20:50:14',NULL),(2975,NULL,'assingMorePeriods','While de empresa, year->2061, initial_month->1, contador->31','2018-06-14 20:50:14',NULL),(2976,NULL,'assingMorePeriods','While de empresa, year->2062, initial_month->1, contador->32','2018-06-14 20:50:14',NULL),(2977,NULL,'assingMorePeriods','While de empresa, year->2063, initial_month->1, contador->33','2018-06-14 20:50:14',NULL),(2978,NULL,'assingMorePeriods','While de empresa, year->2064, initial_month->1, contador->34','2018-06-14 20:50:14',NULL),(2979,NULL,'assingMorePeriods','While de empresa, year->2065, initial_month->1, contador->35','2018-06-14 20:50:14',NULL),(2980,NULL,'assingMorePeriods','While de empresa, year->2066, initial_month->1, contador->36','2018-06-14 20:50:14',NULL),(2981,NULL,'assingMorePeriods','While de empresa, year->2067, initial_month->1, contador->37','2018-06-14 20:50:14',NULL),(2982,NULL,'assingMorePeriods','While de empresa, year->2068, initial_month->1, contador->38','2018-06-14 20:50:14',NULL),(2983,NULL,'assingMorePeriods','While de empresa, year->2069, initial_month->1, contador->39','2018-06-14 20:50:14',NULL),(2984,NULL,'assingMorePeriods','While de empresa, year->2070, initial_month->1, contador->40','2018-06-14 20:50:14',NULL),(2985,NULL,'assingMorePeriods','While de empresa, year->2071, initial_month->1, contador->41','2018-06-14 20:50:14',NULL),(2986,NULL,'assingMorePeriods','While de empresa, year->2072, initial_month->1, contador->42','2018-06-14 20:50:14',NULL),(2987,NULL,'assingMorePeriods','While de empresa, year->2073, initial_month->1, contador->43','2018-06-14 20:50:14',NULL),(2988,NULL,'assingMorePeriods','While de empresa, year->2074, initial_month->1, contador->44','2018-06-14 20:50:14',NULL),(2989,NULL,'assingMorePeriods','While de empresa, year->2075, initial_month->1, contador->45','2018-06-14 20:50:14',NULL),(2990,NULL,'assingMorePeriods','While de empresa, year->2076, initial_month->1, contador->46','2018-06-14 20:50:14',NULL),(2991,NULL,'assingMorePeriods','While de empresa, year->2077, initial_month->1, contador->47','2018-06-14 20:50:14',NULL),(2992,NULL,'assingMorePeriods','While de empresa, year->2078, initial_month->1, contador->48','2018-06-14 20:50:14',NULL),(2993,NULL,'assingMorePeriods','While de empresa, year->2079, initial_month->1, contador->49','2018-06-14 20:50:14',NULL),(2994,NULL,'assingMorePeriods','While de empresa, year->2080, initial_month->1, contador->50','2018-06-14 20:50:14',NULL),(2995,NULL,'assingMorePeriods','While de empresa, year->2081, initial_month->1, contador->51','2018-06-14 20:50:14',NULL),(2996,NULL,'assingMorePeriods','While de empresa, year->2082, initial_month->1, contador->52','2018-06-14 20:50:14',NULL),(2997,NULL,'assingMorePeriods','While de empresa, year->2083, initial_month->1, contador->53','2018-06-14 20:50:14',NULL),(2998,NULL,'assingMorePeriods','While de empresa, year->2084, initial_month->1, contador->54','2018-06-14 20:50:14',NULL),(2999,NULL,'assingMorePeriods','While de empresa, year->2085, initial_month->1, contador->55','2018-06-14 20:50:14',NULL),(3000,NULL,'assingMorePeriods','While de empresa, year->2086, initial_month->1, contador->56','2018-06-14 20:50:14',NULL),(3001,NULL,'assingMorePeriods','While de empresa, year->2087, initial_month->1, contador->57','2018-06-14 20:50:14',NULL),(3002,NULL,'assingMorePeriods','While de empresa, year->2088, initial_month->1, contador->58','2018-06-14 20:50:14',NULL),(3003,NULL,'assingMorePeriods','While de empresa, year->2089, initial_month->1, contador->59','2018-06-14 20:50:14',NULL),(3004,NULL,'assingMorePeriods','While de empresa, year->2090, initial_month->1, contador->60','2018-06-14 20:50:14',NULL);
INSERT INTO `log_debug` VALUES (3005,NULL,'assingMorePeriods','While de empresa, year->2091, initial_month->1, contador->61','2018-06-14 20:50:14',NULL),(3006,NULL,'assingMorePeriods','While de empresa, year->2092, initial_month->1, contador->62','2018-06-14 20:50:14',NULL),(3007,NULL,'assingMorePeriods','While de empresa, year->2093, initial_month->1, contador->63','2018-06-14 20:50:14',NULL),(3008,NULL,'assingMorePeriods','While de empresa, year->2094, initial_month->1, contador->64','2018-06-14 20:50:14',NULL),(3009,NULL,'assingMorePeriods','While de empresa, year->2095, initial_month->1, contador->65','2018-06-14 20:50:14',NULL),(3010,NULL,'assingMorePeriods','While de empresa, year->2096, initial_month->1, contador->66','2018-06-14 20:50:14',NULL),(3011,NULL,'assingMorePeriods','While de empresa, year->2097, initial_month->1, contador->67','2018-06-14 20:50:14',NULL),(3012,NULL,'assingMorePeriods','While de empresa, year->2098, initial_month->1, contador->68','2018-06-14 20:50:14',NULL),(3013,NULL,'assingMorePeriods','While de empresa, year->2099, initial_month->1, contador->69','2018-06-14 20:50:14',NULL),(3014,NULL,'assingMorePeriods','While de empresa, year->2100, initial_month->1, contador->70','2018-06-14 20:50:14',NULL),(3015,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->639, periodo->2030-12','2018-06-14 20:50:14',NULL),(3016,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->13, contador->0','2018-06-14 20:50:14',NULL),(3017,NULL,'assingMorePeriods','While de empresa, year->2031, initial_month->13, contador->1','2018-06-14 20:50:14',NULL),(3018,NULL,'assingMorePeriods','While de empresa, year->2032, initial_month->1, contador->2','2018-06-14 20:50:14',NULL),(3019,NULL,'assingMorePeriods','While de empresa, year->2033, initial_month->1, contador->3','2018-06-14 20:50:14',NULL),(3020,NULL,'assingMorePeriods','While de empresa, year->2034, initial_month->1, contador->4','2018-06-14 20:50:14',NULL),(3021,NULL,'assingMorePeriods','While de empresa, year->2035, initial_month->1, contador->5','2018-06-14 20:50:14',NULL),(3022,NULL,'assingMorePeriods','While de empresa, year->2036, initial_month->1, contador->6','2018-06-14 20:50:14',NULL),(3023,NULL,'assingMorePeriods','While de empresa, year->2037, initial_month->1, contador->7','2018-06-14 20:50:14',NULL),(3024,NULL,'assingMorePeriods','While de empresa, year->2038, initial_month->1, contador->8','2018-06-14 20:50:14',NULL),(3025,NULL,'assingMorePeriods','While de empresa, year->2039, initial_month->1, contador->9','2018-06-14 20:50:14',NULL),(3026,NULL,'assingMorePeriods','While de empresa, year->2040, initial_month->1, contador->10','2018-06-14 20:50:14',NULL),(3027,NULL,'assingMorePeriods','While de empresa, year->2041, initial_month->1, contador->11','2018-06-14 20:50:14',NULL),(3028,NULL,'assingMorePeriods','While de empresa, year->2042, initial_month->1, contador->12','2018-06-14 20:50:14',NULL),(3029,NULL,'assingMorePeriods','While de empresa, year->2043, initial_month->1, contador->13','2018-06-14 20:50:14',NULL),(3030,NULL,'assingMorePeriods','While de empresa, year->2044, initial_month->1, contador->14','2018-06-14 20:50:14',NULL),(3031,NULL,'assingMorePeriods','While de empresa, year->2045, initial_month->1, contador->15','2018-06-14 20:50:14',NULL),(3032,NULL,'assingMorePeriods','While de empresa, year->2046, initial_month->1, contador->16','2018-06-14 20:50:14',NULL),(3033,NULL,'assingMorePeriods','While de empresa, year->2047, initial_month->1, contador->17','2018-06-14 20:50:14',NULL),(3034,NULL,'assingMorePeriods','While de empresa, year->2048, initial_month->1, contador->18','2018-06-14 20:50:14',NULL),(3035,NULL,'assingMorePeriods','While de empresa, year->2049, initial_month->1, contador->19','2018-06-14 20:50:14',NULL),(3036,NULL,'assingMorePeriods','While de empresa, year->2050, initial_month->1, contador->20','2018-06-14 20:50:14',NULL),(3037,NULL,'assingMorePeriods','While de empresa, year->2051, initial_month->1, contador->21','2018-06-14 20:50:14',NULL);
INSERT INTO `log_debug` VALUES (3038,NULL,'assingMorePeriods','While de empresa, year->2052, initial_month->1, contador->22','2018-06-14 20:50:14',NULL),(3039,NULL,'assingMorePeriods','While de empresa, year->2053, initial_month->1, contador->23','2018-06-14 20:50:14',NULL),(3040,NULL,'assingMorePeriods','While de empresa, year->2054, initial_month->1, contador->24','2018-06-14 20:50:14',NULL),(3041,NULL,'assingMorePeriods','While de empresa, year->2055, initial_month->1, contador->25','2018-06-14 20:50:14',NULL),(3042,NULL,'assingMorePeriods','While de empresa, year->2056, initial_month->1, contador->26','2018-06-14 20:50:14',NULL),(3043,NULL,'assingMorePeriods','While de empresa, year->2057, initial_month->1, contador->27','2018-06-14 20:50:14',NULL),(3044,NULL,'assingMorePeriods','While de empresa, year->2058, initial_month->1, contador->28','2018-06-14 20:50:14',NULL),(3045,NULL,'assingMorePeriods','While de empresa, year->2059, initial_month->1, contador->29','2018-06-14 20:50:14',NULL),(3046,NULL,'assingMorePeriods','While de empresa, year->2060, initial_month->1, contador->30','2018-06-14 20:50:14',NULL),(3047,NULL,'assingMorePeriods','While de empresa, year->2061, initial_month->1, contador->31','2018-06-14 20:50:14',NULL),(3048,NULL,'assingMorePeriods','While de empresa, year->2062, initial_month->1, contador->32','2018-06-14 20:50:14',NULL),(3049,NULL,'assingMorePeriods','While de empresa, year->2063, initial_month->1, contador->33','2018-06-14 20:50:14',NULL),(3050,NULL,'assingMorePeriods','While de empresa, year->2064, initial_month->1, contador->34','2018-06-14 20:50:14',NULL),(3051,NULL,'assingMorePeriods','While de empresa, year->2065, initial_month->1, contador->35','2018-06-14 20:50:14',NULL),(3052,NULL,'assingMorePeriods','While de empresa, year->2066, initial_month->1, contador->36','2018-06-14 20:50:14',NULL),(3053,NULL,'assingMorePeriods','While de empresa, year->2067, initial_month->1, contador->37','2018-06-14 20:50:14',NULL),(3054,NULL,'assingMorePeriods','While de empresa, year->2068, initial_month->1, contador->38','2018-06-14 20:50:14',NULL),(3055,NULL,'assingMorePeriods','While de empresa, year->2069, initial_month->1, contador->39','2018-06-14 20:50:14',NULL),(3056,NULL,'assingMorePeriods','While de empresa, year->2070, initial_month->1, contador->40','2018-06-14 20:50:14',NULL),(3057,NULL,'assingMorePeriods','While de empresa, year->2071, initial_month->1, contador->41','2018-06-14 20:50:14',NULL),(3058,NULL,'assingMorePeriods','While de empresa, year->2072, initial_month->1, contador->42','2018-06-14 20:50:14',NULL),(3059,NULL,'assingMorePeriods','While de empresa, year->2073, initial_month->1, contador->43','2018-06-14 20:50:14',NULL),(3060,NULL,'assingMorePeriods','While de empresa, year->2074, initial_month->1, contador->44','2018-06-14 20:50:14',NULL),(3061,NULL,'assingMorePeriods','While de empresa, year->2075, initial_month->1, contador->45','2018-06-14 20:50:14',NULL),(3062,NULL,'assingMorePeriods','While de empresa, year->2076, initial_month->1, contador->46','2018-06-14 20:50:14',NULL),(3063,NULL,'assingMorePeriods','While de empresa, year->2077, initial_month->1, contador->47','2018-06-14 20:50:14',NULL),(3064,NULL,'assingMorePeriods','While de empresa, year->2078, initial_month->1, contador->48','2018-06-14 20:50:14',NULL),(3065,NULL,'assingMorePeriods','While de empresa, year->2079, initial_month->1, contador->49','2018-06-14 20:50:14',NULL),(3066,NULL,'assingMorePeriods','While de empresa, year->2080, initial_month->1, contador->50','2018-06-14 20:50:14',NULL),(3067,NULL,'assingMorePeriods','While de empresa, year->2081, initial_month->1, contador->51','2018-06-14 20:50:14',NULL),(3068,NULL,'assingMorePeriods','While de empresa, year->2082, initial_month->1, contador->52','2018-06-14 20:50:14',NULL),(3069,NULL,'assingMorePeriods','While de empresa, year->2083, initial_month->1, contador->53','2018-06-14 20:50:14',NULL),(3070,NULL,'assingMorePeriods','While de empresa, year->2084, initial_month->1, contador->54','2018-06-14 20:50:14',NULL);
INSERT INTO `log_debug` VALUES (3071,NULL,'assingMorePeriods','While de empresa, year->2085, initial_month->1, contador->55','2018-06-14 20:50:14',NULL),(3072,NULL,'assingMorePeriods','While de empresa, year->2086, initial_month->1, contador->56','2018-06-14 20:50:14',NULL),(3073,NULL,'assingMorePeriods','While de empresa, year->2087, initial_month->1, contador->57','2018-06-14 20:50:14',NULL),(3074,NULL,'assingMorePeriods','While de empresa, year->2088, initial_month->1, contador->58','2018-06-14 20:50:14',NULL),(3075,NULL,'assingMorePeriods','While de empresa, year->2089, initial_month->1, contador->59','2018-06-14 20:50:14',NULL),(3076,NULL,'assingMorePeriods','While de empresa, year->2090, initial_month->1, contador->60','2018-06-14 20:50:14',NULL),(3077,NULL,'assingMorePeriods','While de empresa, year->2091, initial_month->1, contador->61','2018-06-14 20:50:14',NULL),(3078,NULL,'assingMorePeriods','While de empresa, year->2092, initial_month->1, contador->62','2018-06-14 20:50:14',NULL),(3079,NULL,'assingMorePeriods','While de empresa, year->2093, initial_month->1, contador->63','2018-06-14 20:50:14',NULL),(3080,NULL,'assingMorePeriods','While de empresa, year->2094, initial_month->1, contador->64','2018-06-14 20:50:14',NULL),(3081,NULL,'assingMorePeriods','While de empresa, year->2095, initial_month->1, contador->65','2018-06-14 20:50:14',NULL),(3082,NULL,'assingMorePeriods','While de empresa, year->2096, initial_month->1, contador->66','2018-06-14 20:50:14',NULL),(3083,NULL,'assingMorePeriods','While de empresa, year->2097, initial_month->1, contador->67','2018-06-14 20:50:14',NULL),(3084,NULL,'assingMorePeriods','While de empresa, year->2098, initial_month->1, contador->68','2018-06-14 20:50:14',NULL),(3085,NULL,'assingMorePeriods','While de empresa, year->2099, initial_month->1, contador->69','2018-06-14 20:50:14',NULL),(3086,NULL,'assingMorePeriods','While de empresa, year->2100, initial_month->1, contador->70','2018-06-14 20:50:14',NULL),(3087,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->640, periodo->2030-12','2018-06-14 20:50:14',NULL),(3088,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->13, contador->0','2018-06-14 20:50:14',NULL),(3089,NULL,'assingMorePeriods','While de empresa, year->2031, initial_month->13, contador->1','2018-06-14 20:50:14',NULL),(3090,NULL,'assingMorePeriods','While de empresa, year->2032, initial_month->1, contador->2','2018-06-14 20:50:14',NULL),(3091,NULL,'assingMorePeriods','While de empresa, year->2033, initial_month->1, contador->3','2018-06-14 20:50:14',NULL),(3092,NULL,'assingMorePeriods','While de empresa, year->2034, initial_month->1, contador->4','2018-06-14 20:50:14',NULL),(3093,NULL,'assingMorePeriods','While de empresa, year->2035, initial_month->1, contador->5','2018-06-14 20:50:14',NULL),(3094,NULL,'assingMorePeriods','While de empresa, year->2036, initial_month->1, contador->6','2018-06-14 20:50:14',NULL),(3095,NULL,'assingMorePeriods','While de empresa, year->2037, initial_month->1, contador->7','2018-06-14 20:50:14',NULL),(3096,NULL,'assingMorePeriods','While de empresa, year->2038, initial_month->1, contador->8','2018-06-14 20:50:14',NULL),(3097,NULL,'assingMorePeriods','While de empresa, year->2039, initial_month->1, contador->9','2018-06-14 20:50:14',NULL),(3098,NULL,'assingMorePeriods','While de empresa, year->2040, initial_month->1, contador->10','2018-06-14 20:50:14',NULL),(3099,NULL,'assingMorePeriods','While de empresa, year->2041, initial_month->1, contador->11','2018-06-14 20:50:14',NULL),(3100,NULL,'assingMorePeriods','While de empresa, year->2042, initial_month->1, contador->12','2018-06-14 20:50:14',NULL),(3101,NULL,'assingMorePeriods','While de empresa, year->2043, initial_month->1, contador->13','2018-06-14 20:50:14',NULL),(3102,NULL,'assingMorePeriods','While de empresa, year->2044, initial_month->1, contador->14','2018-06-14 20:50:14',NULL),(3103,NULL,'assingMorePeriods','While de empresa, year->2045, initial_month->1, contador->15','2018-06-14 20:50:14',NULL);
INSERT INTO `log_debug` VALUES (3104,NULL,'assingMorePeriods','While de empresa, year->2046, initial_month->1, contador->16','2018-06-14 20:50:14',NULL),(3105,NULL,'assingMorePeriods','While de empresa, year->2047, initial_month->1, contador->17','2018-06-14 20:50:14',NULL),(3106,NULL,'assingMorePeriods','While de empresa, year->2048, initial_month->1, contador->18','2018-06-14 20:50:14',NULL),(3107,NULL,'assingMorePeriods','While de empresa, year->2049, initial_month->1, contador->19','2018-06-14 20:50:14',NULL),(3108,NULL,'assingMorePeriods','While de empresa, year->2050, initial_month->1, contador->20','2018-06-14 20:50:14',NULL),(3109,NULL,'assingMorePeriods','While de empresa, year->2051, initial_month->1, contador->21','2018-06-14 20:50:14',NULL),(3110,NULL,'assingMorePeriods','While de empresa, year->2052, initial_month->1, contador->22','2018-06-14 20:50:14',NULL),(3111,NULL,'assingMorePeriods','While de empresa, year->2053, initial_month->1, contador->23','2018-06-14 20:50:14',NULL),(3112,NULL,'assingMorePeriods','While de empresa, year->2054, initial_month->1, contador->24','2018-06-14 20:50:14',NULL),(3113,NULL,'assingMorePeriods','While de empresa, year->2055, initial_month->1, contador->25','2018-06-14 20:50:14',NULL),(3114,NULL,'assingMorePeriods','While de empresa, year->2056, initial_month->1, contador->26','2018-06-14 20:50:14',NULL),(3115,NULL,'assingMorePeriods','While de empresa, year->2057, initial_month->1, contador->27','2018-06-14 20:50:14',NULL),(3116,NULL,'assingMorePeriods','While de empresa, year->2058, initial_month->1, contador->28','2018-06-14 20:50:14',NULL),(3117,NULL,'assingMorePeriods','While de empresa, year->2059, initial_month->1, contador->29','2018-06-14 20:50:14',NULL),(3118,NULL,'assingMorePeriods','While de empresa, year->2060, initial_month->1, contador->30','2018-06-14 20:50:14',NULL),(3119,NULL,'assingMorePeriods','While de empresa, year->2061, initial_month->1, contador->31','2018-06-14 20:50:14',NULL),(3120,NULL,'assingMorePeriods','While de empresa, year->2062, initial_month->1, contador->32','2018-06-14 20:50:14',NULL),(3121,NULL,'assingMorePeriods','While de empresa, year->2063, initial_month->1, contador->33','2018-06-14 20:50:14',NULL),(3122,NULL,'assingMorePeriods','While de empresa, year->2064, initial_month->1, contador->34','2018-06-14 20:50:14',NULL),(3123,NULL,'assingMorePeriods','While de empresa, year->2065, initial_month->1, contador->35','2018-06-14 20:50:14',NULL),(3124,NULL,'assingMorePeriods','While de empresa, year->2066, initial_month->1, contador->36','2018-06-14 20:50:14',NULL),(3125,NULL,'assingMorePeriods','While de empresa, year->2067, initial_month->1, contador->37','2018-06-14 20:50:14',NULL),(3126,NULL,'assingMorePeriods','While de empresa, year->2068, initial_month->1, contador->38','2018-06-14 20:50:14',NULL),(3127,NULL,'assingMorePeriods','While de empresa, year->2069, initial_month->1, contador->39','2018-06-14 20:50:14',NULL),(3128,NULL,'assingMorePeriods','While de empresa, year->2070, initial_month->1, contador->40','2018-06-14 20:50:14',NULL),(3129,NULL,'assingMorePeriods','While de empresa, year->2071, initial_month->1, contador->41','2018-06-14 20:50:14',NULL),(3130,NULL,'assingMorePeriods','While de empresa, year->2072, initial_month->1, contador->42','2018-06-14 20:50:14',NULL),(3131,NULL,'assingMorePeriods','While de empresa, year->2073, initial_month->1, contador->43','2018-06-14 20:50:14',NULL),(3132,NULL,'assingMorePeriods','While de empresa, year->2074, initial_month->1, contador->44','2018-06-14 20:50:14',NULL),(3133,NULL,'assingMorePeriods','While de empresa, year->2075, initial_month->1, contador->45','2018-06-14 20:50:14',NULL),(3134,NULL,'assingMorePeriods','While de empresa, year->2076, initial_month->1, contador->46','2018-06-14 20:50:14',NULL),(3135,NULL,'assingMorePeriods','While de empresa, year->2077, initial_month->1, contador->47','2018-06-14 20:50:14',NULL),(3136,NULL,'assingMorePeriods','While de empresa, year->2078, initial_month->1, contador->48','2018-06-14 20:50:14',NULL);
INSERT INTO `log_debug` VALUES (3137,NULL,'assingMorePeriods','While de empresa, year->2079, initial_month->1, contador->49','2018-06-14 20:50:14',NULL),(3138,NULL,'assingMorePeriods','While de empresa, year->2080, initial_month->1, contador->50','2018-06-14 20:50:14',NULL),(3139,NULL,'assingMorePeriods','While de empresa, year->2081, initial_month->1, contador->51','2018-06-14 20:50:14',NULL),(3140,NULL,'assingMorePeriods','While de empresa, year->2082, initial_month->1, contador->52','2018-06-14 20:50:14',NULL),(3141,NULL,'assingMorePeriods','While de empresa, year->2083, initial_month->1, contador->53','2018-06-14 20:50:14',NULL),(3142,NULL,'assingMorePeriods','While de empresa, year->2084, initial_month->1, contador->54','2018-06-14 20:50:14',NULL),(3143,NULL,'assingMorePeriods','While de empresa, year->2085, initial_month->1, contador->55','2018-06-14 20:50:14',NULL),(3144,NULL,'assingMorePeriods','While de empresa, year->2086, initial_month->1, contador->56','2018-06-14 20:50:14',NULL),(3145,NULL,'assingMorePeriods','While de empresa, year->2087, initial_month->1, contador->57','2018-06-14 20:50:14',NULL),(3146,NULL,'assingMorePeriods','While de empresa, year->2088, initial_month->1, contador->58','2018-06-14 20:50:14',NULL),(3147,NULL,'assingMorePeriods','While de empresa, year->2089, initial_month->1, contador->59','2018-06-14 20:50:14',NULL),(3148,NULL,'assingMorePeriods','While de empresa, year->2090, initial_month->1, contador->60','2018-06-14 20:50:14',NULL),(3149,NULL,'assingMorePeriods','While de empresa, year->2091, initial_month->1, contador->61','2018-06-14 20:50:14',NULL),(3150,NULL,'assingMorePeriods','While de empresa, year->2092, initial_month->1, contador->62','2018-06-14 20:50:14',NULL),(3151,NULL,'assingMorePeriods','While de empresa, year->2093, initial_month->1, contador->63','2018-06-14 20:50:14',NULL),(3152,NULL,'assingMorePeriods','While de empresa, year->2094, initial_month->1, contador->64','2018-06-14 20:50:14',NULL),(3153,NULL,'assingMorePeriods','While de empresa, year->2095, initial_month->1, contador->65','2018-06-14 20:50:14',NULL),(3154,NULL,'assingMorePeriods','While de empresa, year->2096, initial_month->1, contador->66','2018-06-14 20:50:14',NULL),(3155,NULL,'assingMorePeriods','While de empresa, year->2097, initial_month->1, contador->67','2018-06-14 20:50:14',NULL),(3156,NULL,'assingMorePeriods','While de empresa, year->2098, initial_month->1, contador->68','2018-06-14 20:50:14',NULL),(3157,NULL,'assingMorePeriods','While de empresa, year->2099, initial_month->1, contador->69','2018-06-14 20:50:14',NULL),(3158,NULL,'assingMorePeriods','While de empresa, year->2100, initial_month->1, contador->70','2018-06-14 20:50:14',NULL),(3159,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->673, periodo->2030-12','2018-06-14 20:50:14',NULL),(3160,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->13, contador->0','2018-06-14 20:50:14',NULL),(3161,NULL,'assingMorePeriods','While de empresa, year->2031, initial_month->13, contador->1','2018-06-14 20:50:14',NULL),(3162,NULL,'assingMorePeriods','While de empresa, year->2032, initial_month->1, contador->2','2018-06-14 20:50:14',NULL),(3163,NULL,'assingMorePeriods','While de empresa, year->2033, initial_month->1, contador->3','2018-06-14 20:50:14',NULL),(3164,NULL,'assingMorePeriods','While de empresa, year->2034, initial_month->1, contador->4','2018-06-14 20:50:14',NULL),(3165,NULL,'assingMorePeriods','While de empresa, year->2035, initial_month->1, contador->5','2018-06-14 20:50:14',NULL),(3166,NULL,'assingMorePeriods','While de empresa, year->2036, initial_month->1, contador->6','2018-06-14 20:50:14',NULL),(3167,NULL,'assingMorePeriods','While de empresa, year->2037, initial_month->1, contador->7','2018-06-14 20:50:14',NULL),(3168,NULL,'assingMorePeriods','While de empresa, year->2038, initial_month->1, contador->8','2018-06-14 20:50:14',NULL),(3169,NULL,'assingMorePeriods','While de empresa, year->2039, initial_month->1, contador->9','2018-06-14 20:50:14',NULL);
INSERT INTO `log_debug` VALUES (3170,NULL,'assingMorePeriods','While de empresa, year->2040, initial_month->1, contador->10','2018-06-14 20:50:14',NULL),(3171,NULL,'assingMorePeriods','While de empresa, year->2041, initial_month->1, contador->11','2018-06-14 20:50:14',NULL),(3172,NULL,'assingMorePeriods','While de empresa, year->2042, initial_month->1, contador->12','2018-06-14 20:50:14',NULL),(3173,NULL,'assingMorePeriods','While de empresa, year->2043, initial_month->1, contador->13','2018-06-14 20:50:14',NULL),(3174,NULL,'assingMorePeriods','While de empresa, year->2044, initial_month->1, contador->14','2018-06-14 20:50:14',NULL),(3175,NULL,'assingMorePeriods','While de empresa, year->2045, initial_month->1, contador->15','2018-06-14 20:50:14',NULL),(3176,NULL,'assingMorePeriods','While de empresa, year->2046, initial_month->1, contador->16','2018-06-14 20:50:14',NULL),(3177,NULL,'assingMorePeriods','While de empresa, year->2047, initial_month->1, contador->17','2018-06-14 20:50:14',NULL),(3178,NULL,'assingMorePeriods','While de empresa, year->2048, initial_month->1, contador->18','2018-06-14 20:50:14',NULL),(3179,NULL,'assingMorePeriods','While de empresa, year->2049, initial_month->1, contador->19','2018-06-14 20:50:14',NULL),(3180,NULL,'assingMorePeriods','While de empresa, year->2050, initial_month->1, contador->20','2018-06-14 20:50:14',NULL),(3181,NULL,'assingMorePeriods','While de empresa, year->2051, initial_month->1, contador->21','2018-06-14 20:50:14',NULL),(3182,NULL,'assingMorePeriods','While de empresa, year->2052, initial_month->1, contador->22','2018-06-14 20:50:14',NULL),(3183,NULL,'assingMorePeriods','While de empresa, year->2053, initial_month->1, contador->23','2018-06-14 20:50:14',NULL),(3184,NULL,'assingMorePeriods','While de empresa, year->2054, initial_month->1, contador->24','2018-06-14 20:50:14',NULL),(3185,NULL,'assingMorePeriods','While de empresa, year->2055, initial_month->1, contador->25','2018-06-14 20:50:14',NULL),(3186,NULL,'assingMorePeriods','While de empresa, year->2056, initial_month->1, contador->26','2018-06-14 20:50:14',NULL),(3187,NULL,'assingMorePeriods','While de empresa, year->2057, initial_month->1, contador->27','2018-06-14 20:50:14',NULL),(3188,NULL,'assingMorePeriods','While de empresa, year->2058, initial_month->1, contador->28','2018-06-14 20:50:14',NULL),(3189,NULL,'assingMorePeriods','While de empresa, year->2059, initial_month->1, contador->29','2018-06-14 20:50:14',NULL),(3190,NULL,'assingMorePeriods','While de empresa, year->2060, initial_month->1, contador->30','2018-06-14 20:50:14',NULL),(3191,NULL,'assingMorePeriods','While de empresa, year->2061, initial_month->1, contador->31','2018-06-14 20:50:14',NULL),(3192,NULL,'assingMorePeriods','While de empresa, year->2062, initial_month->1, contador->32','2018-06-14 20:50:14',NULL),(3193,NULL,'assingMorePeriods','While de empresa, year->2063, initial_month->1, contador->33','2018-06-14 20:50:14',NULL),(3194,NULL,'assingMorePeriods','While de empresa, year->2064, initial_month->1, contador->34','2018-06-14 20:50:14',NULL),(3195,NULL,'assingMorePeriods','While de empresa, year->2065, initial_month->1, contador->35','2018-06-14 20:50:14',NULL),(3196,NULL,'assingMorePeriods','While de empresa, year->2066, initial_month->1, contador->36','2018-06-14 20:50:14',NULL),(3197,NULL,'assingMorePeriods','While de empresa, year->2067, initial_month->1, contador->37','2018-06-14 20:50:14',NULL),(3198,NULL,'assingMorePeriods','While de empresa, year->2068, initial_month->1, contador->38','2018-06-14 20:50:14',NULL),(3199,NULL,'assingMorePeriods','While de empresa, year->2069, initial_month->1, contador->39','2018-06-14 20:50:14',NULL),(3200,NULL,'assingMorePeriods','While de empresa, year->2070, initial_month->1, contador->40','2018-06-14 20:50:14',NULL),(3201,NULL,'assingMorePeriods','While de empresa, year->2071, initial_month->1, contador->41','2018-06-14 20:50:14',NULL),(3202,NULL,'assingMorePeriods','While de empresa, year->2072, initial_month->1, contador->42','2018-06-14 20:50:14',NULL);
INSERT INTO `log_debug` VALUES (3203,NULL,'assingMorePeriods','While de empresa, year->2073, initial_month->1, contador->43','2018-06-14 20:50:14',NULL),(3204,NULL,'assingMorePeriods','While de empresa, year->2074, initial_month->1, contador->44','2018-06-14 20:50:14',NULL),(3205,NULL,'assingMorePeriods','While de empresa, year->2075, initial_month->1, contador->45','2018-06-14 20:50:14',NULL),(3206,NULL,'assingMorePeriods','While de empresa, year->2076, initial_month->1, contador->46','2018-06-14 20:50:14',NULL),(3207,NULL,'assingMorePeriods','While de empresa, year->2077, initial_month->1, contador->47','2018-06-14 20:50:14',NULL),(3208,NULL,'assingMorePeriods','While de empresa, year->2078, initial_month->1, contador->48','2018-06-14 20:50:14',NULL),(3209,NULL,'assingMorePeriods','While de empresa, year->2079, initial_month->1, contador->49','2018-06-14 20:50:14',NULL),(3210,NULL,'assingMorePeriods','While de empresa, year->2080, initial_month->1, contador->50','2018-06-14 20:50:14',NULL),(3211,NULL,'assingMorePeriods','While de empresa, year->2081, initial_month->1, contador->51','2018-06-14 20:50:14',NULL),(3212,NULL,'assingMorePeriods','While de empresa, year->2082, initial_month->1, contador->52','2018-06-14 20:50:14',NULL),(3213,NULL,'assingMorePeriods','While de empresa, year->2083, initial_month->1, contador->53','2018-06-14 20:50:14',NULL),(3214,NULL,'assingMorePeriods','While de empresa, year->2084, initial_month->1, contador->54','2018-06-14 20:50:14',NULL),(3215,NULL,'assingMorePeriods','While de empresa, year->2085, initial_month->1, contador->55','2018-06-14 20:50:14',NULL),(3216,NULL,'assingMorePeriods','While de empresa, year->2086, initial_month->1, contador->56','2018-06-14 20:50:14',NULL),(3217,NULL,'assingMorePeriods','While de empresa, year->2087, initial_month->1, contador->57','2018-06-14 20:50:14',NULL),(3218,NULL,'assingMorePeriods','While de empresa, year->2088, initial_month->1, contador->58','2018-06-14 20:50:14',NULL),(3219,NULL,'assingMorePeriods','While de empresa, year->2089, initial_month->1, contador->59','2018-06-14 20:50:14',NULL),(3220,NULL,'assingMorePeriods','While de empresa, year->2090, initial_month->1, contador->60','2018-06-14 20:50:14',NULL),(3221,NULL,'assingMorePeriods','While de empresa, year->2091, initial_month->1, contador->61','2018-06-14 20:50:14',NULL),(3222,NULL,'assingMorePeriods','While de empresa, year->2092, initial_month->1, contador->62','2018-06-14 20:50:14',NULL),(3223,NULL,'assingMorePeriods','While de empresa, year->2093, initial_month->1, contador->63','2018-06-14 20:50:14',NULL),(3224,NULL,'assingMorePeriods','While de empresa, year->2094, initial_month->1, contador->64','2018-06-14 20:50:14',NULL),(3225,NULL,'assingMorePeriods','While de empresa, year->2095, initial_month->1, contador->65','2018-06-14 20:50:14',NULL),(3226,NULL,'assingMorePeriods','While de empresa, year->2096, initial_month->1, contador->66','2018-06-14 20:50:14',NULL),(3227,NULL,'assingMorePeriods','While de empresa, year->2097, initial_month->1, contador->67','2018-06-14 20:50:14',NULL),(3228,NULL,'assingMorePeriods','While de empresa, year->2098, initial_month->1, contador->68','2018-06-14 20:50:14',NULL),(3229,NULL,'assingMorePeriods','While de empresa, year->2099, initial_month->1, contador->69','2018-06-14 20:50:14',NULL),(3230,NULL,'assingMorePeriods','While de empresa, year->2100, initial_month->1, contador->70','2018-06-14 20:50:14',NULL),(3231,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->784, periodo->2030-12','2018-06-14 20:50:14',NULL),(3232,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->13, contador->0','2018-06-14 20:50:14',NULL),(3233,NULL,'assingMorePeriods','While de empresa, year->2031, initial_month->13, contador->1','2018-06-14 20:50:14',NULL),(3234,NULL,'assingMorePeriods','While de empresa, year->2032, initial_month->1, contador->2','2018-06-14 20:50:14',NULL),(3235,NULL,'assingMorePeriods','While de empresa, year->2033, initial_month->1, contador->3','2018-06-14 20:50:14',NULL);
INSERT INTO `log_debug` VALUES (3236,NULL,'assingMorePeriods','While de empresa, year->2034, initial_month->1, contador->4','2018-06-14 20:50:14',NULL),(3237,NULL,'assingMorePeriods','While de empresa, year->2035, initial_month->1, contador->5','2018-06-14 20:50:14',NULL),(3238,NULL,'assingMorePeriods','While de empresa, year->2036, initial_month->1, contador->6','2018-06-14 20:50:14',NULL),(3239,NULL,'assingMorePeriods','While de empresa, year->2037, initial_month->1, contador->7','2018-06-14 20:50:14',NULL),(3240,NULL,'assingMorePeriods','While de empresa, year->2038, initial_month->1, contador->8','2018-06-14 20:50:14',NULL),(3241,NULL,'assingMorePeriods','While de empresa, year->2039, initial_month->1, contador->9','2018-06-14 20:50:14',NULL),(3242,NULL,'assingMorePeriods','While de empresa, year->2040, initial_month->1, contador->10','2018-06-14 20:50:14',NULL),(3243,NULL,'assingMorePeriods','While de empresa, year->2041, initial_month->1, contador->11','2018-06-14 20:50:14',NULL),(3244,NULL,'assingMorePeriods','While de empresa, year->2042, initial_month->1, contador->12','2018-06-14 20:50:14',NULL),(3245,NULL,'assingMorePeriods','While de empresa, year->2043, initial_month->1, contador->13','2018-06-14 20:50:14',NULL),(3246,NULL,'assingMorePeriods','While de empresa, year->2044, initial_month->1, contador->14','2018-06-14 20:50:14',NULL),(3247,NULL,'assingMorePeriods','While de empresa, year->2045, initial_month->1, contador->15','2018-06-14 20:50:14',NULL),(3248,NULL,'assingMorePeriods','While de empresa, year->2046, initial_month->1, contador->16','2018-06-14 20:50:14',NULL),(3249,NULL,'assingMorePeriods','While de empresa, year->2047, initial_month->1, contador->17','2018-06-14 20:50:14',NULL),(3250,NULL,'assingMorePeriods','While de empresa, year->2048, initial_month->1, contador->18','2018-06-14 20:50:14',NULL),(3251,NULL,'assingMorePeriods','While de empresa, year->2049, initial_month->1, contador->19','2018-06-14 20:50:14',NULL),(3252,NULL,'assingMorePeriods','While de empresa, year->2050, initial_month->1, contador->20','2018-06-14 20:50:14',NULL),(3253,NULL,'assingMorePeriods','While de empresa, year->2051, initial_month->1, contador->21','2018-06-14 20:50:14',NULL),(3254,NULL,'assingMorePeriods','While de empresa, year->2052, initial_month->1, contador->22','2018-06-14 20:50:14',NULL),(3255,NULL,'assingMorePeriods','While de empresa, year->2053, initial_month->1, contador->23','2018-06-14 20:50:14',NULL),(3256,NULL,'assingMorePeriods','While de empresa, year->2054, initial_month->1, contador->24','2018-06-14 20:50:14',NULL),(3257,NULL,'assingMorePeriods','While de empresa, year->2055, initial_month->1, contador->25','2018-06-14 20:50:14',NULL),(3258,NULL,'assingMorePeriods','While de empresa, year->2056, initial_month->1, contador->26','2018-06-14 20:50:14',NULL),(3259,NULL,'assingMorePeriods','While de empresa, year->2057, initial_month->1, contador->27','2018-06-14 20:50:14',NULL),(3260,NULL,'assingMorePeriods','While de empresa, year->2058, initial_month->1, contador->28','2018-06-14 20:50:14',NULL),(3261,NULL,'assingMorePeriods','While de empresa, year->2059, initial_month->1, contador->29','2018-06-14 20:50:14',NULL),(3262,NULL,'assingMorePeriods','While de empresa, year->2060, initial_month->1, contador->30','2018-06-14 20:50:14',NULL),(3263,NULL,'assingMorePeriods','While de empresa, year->2061, initial_month->1, contador->31','2018-06-14 20:50:14',NULL),(3264,NULL,'assingMorePeriods','While de empresa, year->2062, initial_month->1, contador->32','2018-06-14 20:50:14',NULL),(3265,NULL,'assingMorePeriods','While de empresa, year->2063, initial_month->1, contador->33','2018-06-14 20:50:14',NULL),(3266,NULL,'assingMorePeriods','While de empresa, year->2064, initial_month->1, contador->34','2018-06-14 20:50:14',NULL),(3267,NULL,'assingMorePeriods','While de empresa, year->2065, initial_month->1, contador->35','2018-06-14 20:50:14',NULL),(3268,NULL,'assingMorePeriods','While de empresa, year->2066, initial_month->1, contador->36','2018-06-14 20:50:14',NULL);
INSERT INTO `log_debug` VALUES (3269,NULL,'assingMorePeriods','While de empresa, year->2067, initial_month->1, contador->37','2018-06-14 20:50:14',NULL),(3270,NULL,'assingMorePeriods','While de empresa, year->2068, initial_month->1, contador->38','2018-06-14 20:50:14',NULL),(3271,NULL,'assingMorePeriods','While de empresa, year->2069, initial_month->1, contador->39','2018-06-14 20:50:14',NULL),(3272,NULL,'assingMorePeriods','While de empresa, year->2070, initial_month->1, contador->40','2018-06-14 20:50:14',NULL),(3273,NULL,'assingMorePeriods','While de empresa, year->2071, initial_month->1, contador->41','2018-06-14 20:50:14',NULL),(3274,NULL,'assingMorePeriods','While de empresa, year->2072, initial_month->1, contador->42','2018-06-14 20:50:14',NULL),(3275,NULL,'assingMorePeriods','While de empresa, year->2073, initial_month->1, contador->43','2018-06-14 20:50:14',NULL),(3276,NULL,'assingMorePeriods','While de empresa, year->2074, initial_month->1, contador->44','2018-06-14 20:50:14',NULL),(3277,NULL,'assingMorePeriods','While de empresa, year->2075, initial_month->1, contador->45','2018-06-14 20:50:14',NULL),(3278,NULL,'assingMorePeriods','While de empresa, year->2076, initial_month->1, contador->46','2018-06-14 20:50:14',NULL),(3279,NULL,'assingMorePeriods','While de empresa, year->2077, initial_month->1, contador->47','2018-06-14 20:50:14',NULL),(3280,NULL,'assingMorePeriods','While de empresa, year->2078, initial_month->1, contador->48','2018-06-14 20:50:14',NULL),(3281,NULL,'assingMorePeriods','While de empresa, year->2079, initial_month->1, contador->49','2018-06-14 20:50:14',NULL),(3282,NULL,'assingMorePeriods','While de empresa, year->2080, initial_month->1, contador->50','2018-06-14 20:50:14',NULL),(3283,NULL,'assingMorePeriods','While de empresa, year->2081, initial_month->1, contador->51','2018-06-14 20:50:14',NULL),(3284,NULL,'assingMorePeriods','While de empresa, year->2082, initial_month->1, contador->52','2018-06-14 20:50:14',NULL),(3285,NULL,'assingMorePeriods','While de empresa, year->2083, initial_month->1, contador->53','2018-06-14 20:50:14',NULL),(3286,NULL,'assingMorePeriods','While de empresa, year->2084, initial_month->1, contador->54','2018-06-14 20:50:14',NULL),(3287,NULL,'assingMorePeriods','While de empresa, year->2085, initial_month->1, contador->55','2018-06-14 20:50:14',NULL),(3288,NULL,'assingMorePeriods','While de empresa, year->2086, initial_month->1, contador->56','2018-06-14 20:50:14',NULL),(3289,NULL,'assingMorePeriods','While de empresa, year->2087, initial_month->1, contador->57','2018-06-14 20:50:14',NULL),(3290,NULL,'assingMorePeriods','While de empresa, year->2088, initial_month->1, contador->58','2018-06-14 20:50:14',NULL),(3291,NULL,'assingMorePeriods','While de empresa, year->2089, initial_month->1, contador->59','2018-06-14 20:50:14',NULL),(3292,NULL,'assingMorePeriods','While de empresa, year->2090, initial_month->1, contador->60','2018-06-14 20:50:14',NULL),(3293,NULL,'assingMorePeriods','While de empresa, year->2091, initial_month->1, contador->61','2018-06-14 20:50:14',NULL),(3294,NULL,'assingMorePeriods','While de empresa, year->2092, initial_month->1, contador->62','2018-06-14 20:50:14',NULL),(3295,NULL,'assingMorePeriods','While de empresa, year->2093, initial_month->1, contador->63','2018-06-14 20:50:14',NULL),(3296,NULL,'assingMorePeriods','While de empresa, year->2094, initial_month->1, contador->64','2018-06-14 20:50:14',NULL),(3297,NULL,'assingMorePeriods','While de empresa, year->2095, initial_month->1, contador->65','2018-06-14 20:50:14',NULL),(3298,NULL,'assingMorePeriods','While de empresa, year->2096, initial_month->1, contador->66','2018-06-14 20:50:14',NULL),(3299,NULL,'assingMorePeriods','While de empresa, year->2097, initial_month->1, contador->67','2018-06-14 20:50:14',NULL),(3300,NULL,'assingMorePeriods','While de empresa, year->2098, initial_month->1, contador->68','2018-06-14 20:50:14',NULL),(3301,NULL,'assingMorePeriods','While de empresa, year->2099, initial_month->1, contador->69','2018-06-14 20:50:14',NULL);
INSERT INTO `log_debug` VALUES (3302,NULL,'assingMorePeriods','While de empresa, year->2100, initial_month->1, contador->70','2018-06-14 20:50:14',NULL),(3303,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1479, periodo->2030-12','2018-06-14 20:50:14',NULL),(3304,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->13, contador->0','2018-06-14 20:50:14',NULL),(3305,NULL,'assingMorePeriods','While de empresa, year->2031, initial_month->13, contador->1','2018-06-14 20:50:14',NULL),(3306,NULL,'assingMorePeriods','While de empresa, year->2032, initial_month->1, contador->2','2018-06-14 20:50:14',NULL),(3307,NULL,'assingMorePeriods','While de empresa, year->2033, initial_month->1, contador->3','2018-06-14 20:50:14',NULL),(3308,NULL,'assingMorePeriods','While de empresa, year->2034, initial_month->1, contador->4','2018-06-14 20:50:14',NULL),(3309,NULL,'assingMorePeriods','While de empresa, year->2035, initial_month->1, contador->5','2018-06-14 20:50:14',NULL),(3310,NULL,'assingMorePeriods','While de empresa, year->2036, initial_month->1, contador->6','2018-06-14 20:50:14',NULL),(3311,NULL,'assingMorePeriods','While de empresa, year->2037, initial_month->1, contador->7','2018-06-14 20:50:14',NULL),(3312,NULL,'assingMorePeriods','While de empresa, year->2038, initial_month->1, contador->8','2018-06-14 20:50:14',NULL),(3313,NULL,'assingMorePeriods','While de empresa, year->2039, initial_month->1, contador->9','2018-06-14 20:50:14',NULL),(3314,NULL,'assingMorePeriods','While de empresa, year->2040, initial_month->1, contador->10','2018-06-14 20:50:14',NULL),(3315,NULL,'assingMorePeriods','While de empresa, year->2041, initial_month->1, contador->11','2018-06-14 20:50:14',NULL),(3316,NULL,'assingMorePeriods','While de empresa, year->2042, initial_month->1, contador->12','2018-06-14 20:50:14',NULL),(3317,NULL,'assingMorePeriods','While de empresa, year->2043, initial_month->1, contador->13','2018-06-14 20:50:14',NULL),(3318,NULL,'assingMorePeriods','While de empresa, year->2044, initial_month->1, contador->14','2018-06-14 20:50:14',NULL),(3319,NULL,'assingMorePeriods','While de empresa, year->2045, initial_month->1, contador->15','2018-06-14 20:50:14',NULL),(3320,NULL,'assingMorePeriods','While de empresa, year->2046, initial_month->1, contador->16','2018-06-14 20:50:14',NULL),(3321,NULL,'assingMorePeriods','While de empresa, year->2047, initial_month->1, contador->17','2018-06-14 20:50:14',NULL),(3322,NULL,'assingMorePeriods','While de empresa, year->2048, initial_month->1, contador->18','2018-06-14 20:50:14',NULL),(3323,NULL,'assingMorePeriods','While de empresa, year->2049, initial_month->1, contador->19','2018-06-14 20:50:14',NULL),(3324,NULL,'assingMorePeriods','While de empresa, year->2050, initial_month->1, contador->20','2018-06-14 20:50:14',NULL),(3325,NULL,'assingMorePeriods','While de empresa, year->2051, initial_month->1, contador->21','2018-06-14 20:50:14',NULL),(3326,NULL,'assingMorePeriods','While de empresa, year->2052, initial_month->1, contador->22','2018-06-14 20:50:14',NULL),(3327,NULL,'assingMorePeriods','While de empresa, year->2053, initial_month->1, contador->23','2018-06-14 20:50:14',NULL),(3328,NULL,'assingMorePeriods','While de empresa, year->2054, initial_month->1, contador->24','2018-06-14 20:50:14',NULL),(3329,NULL,'assingMorePeriods','While de empresa, year->2055, initial_month->1, contador->25','2018-06-14 20:50:14',NULL),(3330,NULL,'assingMorePeriods','While de empresa, year->2056, initial_month->1, contador->26','2018-06-14 20:50:14',NULL),(3331,NULL,'assingMorePeriods','While de empresa, year->2057, initial_month->1, contador->27','2018-06-14 20:50:14',NULL),(3332,NULL,'assingMorePeriods','While de empresa, year->2058, initial_month->1, contador->28','2018-06-14 20:50:14',NULL),(3333,NULL,'assingMorePeriods','While de empresa, year->2059, initial_month->1, contador->29','2018-06-14 20:50:14',NULL),(3334,NULL,'assingMorePeriods','While de empresa, year->2060, initial_month->1, contador->30','2018-06-14 20:50:14',NULL);
INSERT INTO `log_debug` VALUES (3335,NULL,'assingMorePeriods','While de empresa, year->2061, initial_month->1, contador->31','2018-06-14 20:50:14',NULL),(3336,NULL,'assingMorePeriods','While de empresa, year->2062, initial_month->1, contador->32','2018-06-14 20:50:14',NULL),(3337,NULL,'assingMorePeriods','While de empresa, year->2063, initial_month->1, contador->33','2018-06-14 20:50:14',NULL),(3338,NULL,'assingMorePeriods','While de empresa, year->2064, initial_month->1, contador->34','2018-06-14 20:50:14',NULL),(3339,NULL,'assingMorePeriods','While de empresa, year->2065, initial_month->1, contador->35','2018-06-14 20:50:14',NULL),(3340,NULL,'assingMorePeriods','While de empresa, year->2066, initial_month->1, contador->36','2018-06-14 20:50:14',NULL),(3341,NULL,'assingMorePeriods','While de empresa, year->2067, initial_month->1, contador->37','2018-06-14 20:50:14',NULL),(3342,NULL,'assingMorePeriods','While de empresa, year->2068, initial_month->1, contador->38','2018-06-14 20:50:14',NULL),(3343,NULL,'assingMorePeriods','While de empresa, year->2069, initial_month->1, contador->39','2018-06-14 20:50:14',NULL),(3344,NULL,'assingMorePeriods','While de empresa, year->2070, initial_month->1, contador->40','2018-06-14 20:50:14',NULL),(3345,NULL,'assingMorePeriods','While de empresa, year->2071, initial_month->1, contador->41','2018-06-14 20:50:15',NULL),(3346,NULL,'assingMorePeriods','While de empresa, year->2072, initial_month->1, contador->42','2018-06-14 20:50:15',NULL),(3347,NULL,'assingMorePeriods','While de empresa, year->2073, initial_month->1, contador->43','2018-06-14 20:50:15',NULL),(3348,NULL,'assingMorePeriods','While de empresa, year->2074, initial_month->1, contador->44','2018-06-14 20:50:15',NULL),(3349,NULL,'assingMorePeriods','While de empresa, year->2075, initial_month->1, contador->45','2018-06-14 20:50:15',NULL),(3350,NULL,'assingMorePeriods','While de empresa, year->2076, initial_month->1, contador->46','2018-06-14 20:50:15',NULL),(3351,NULL,'assingMorePeriods','While de empresa, year->2077, initial_month->1, contador->47','2018-06-14 20:50:15',NULL),(3352,NULL,'assingMorePeriods','While de empresa, year->2078, initial_month->1, contador->48','2018-06-14 20:50:15',NULL),(3353,NULL,'assingMorePeriods','While de empresa, year->2079, initial_month->1, contador->49','2018-06-14 20:50:15',NULL),(3354,NULL,'assingMorePeriods','While de empresa, year->2080, initial_month->1, contador->50','2018-06-14 20:50:15',NULL),(3355,NULL,'assingMorePeriods','While de empresa, year->2081, initial_month->1, contador->51','2018-06-14 20:50:15',NULL),(3356,NULL,'assingMorePeriods','While de empresa, year->2082, initial_month->1, contador->52','2018-06-14 20:50:15',NULL),(3357,NULL,'assingMorePeriods','While de empresa, year->2083, initial_month->1, contador->53','2018-06-14 20:50:15',NULL),(3358,NULL,'assingMorePeriods','While de empresa, year->2084, initial_month->1, contador->54','2018-06-14 20:50:15',NULL),(3359,NULL,'assingMorePeriods','While de empresa, year->2085, initial_month->1, contador->55','2018-06-14 20:50:15',NULL),(3360,NULL,'assingMorePeriods','While de empresa, year->2086, initial_month->1, contador->56','2018-06-14 20:50:15',NULL),(3361,NULL,'assingMorePeriods','While de empresa, year->2087, initial_month->1, contador->57','2018-06-14 20:50:15',NULL),(3362,NULL,'assingMorePeriods','While de empresa, year->2088, initial_month->1, contador->58','2018-06-14 20:50:15',NULL),(3363,NULL,'assingMorePeriods','While de empresa, year->2089, initial_month->1, contador->59','2018-06-14 20:50:15',NULL),(3364,NULL,'assingMorePeriods','While de empresa, year->2090, initial_month->1, contador->60','2018-06-14 20:50:15',NULL),(3365,NULL,'assingMorePeriods','While de empresa, year->2091, initial_month->1, contador->61','2018-06-14 20:50:15',NULL),(3366,NULL,'assingMorePeriods','While de empresa, year->2092, initial_month->1, contador->62','2018-06-14 20:50:15',NULL),(3367,NULL,'assingMorePeriods','While de empresa, year->2093, initial_month->1, contador->63','2018-06-14 20:50:15',NULL);
INSERT INTO `log_debug` VALUES (3368,NULL,'assingMorePeriods','While de empresa, year->2094, initial_month->1, contador->64','2018-06-14 20:50:15',NULL),(3369,NULL,'assingMorePeriods','While de empresa, year->2095, initial_month->1, contador->65','2018-06-14 20:50:15',NULL),(3370,NULL,'assingMorePeriods','While de empresa, year->2096, initial_month->1, contador->66','2018-06-14 20:50:15',NULL),(3371,NULL,'assingMorePeriods','While de empresa, year->2097, initial_month->1, contador->67','2018-06-14 20:50:15',NULL),(3372,NULL,'assingMorePeriods','While de empresa, year->2098, initial_month->1, contador->68','2018-06-14 20:50:15',NULL),(3373,NULL,'assingMorePeriods','While de empresa, year->2099, initial_month->1, contador->69','2018-06-14 20:50:15',NULL),(3374,NULL,'assingMorePeriods','While de empresa, year->2100, initial_month->1, contador->70','2018-06-14 20:50:15',NULL),(3375,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1634, periodo->2030-12','2018-06-14 20:50:15',NULL),(3376,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->13, contador->0','2018-06-14 20:50:15',NULL),(3377,NULL,'assingMorePeriods','While de empresa, year->2031, initial_month->13, contador->1','2018-06-14 20:50:15',NULL),(3378,NULL,'assingMorePeriods','While de empresa, year->2032, initial_month->1, contador->2','2018-06-14 20:50:15',NULL),(3379,NULL,'assingMorePeriods','While de empresa, year->2033, initial_month->1, contador->3','2018-06-14 20:50:15',NULL),(3380,NULL,'assingMorePeriods','While de empresa, year->2034, initial_month->1, contador->4','2018-06-14 20:50:15',NULL),(3381,NULL,'assingMorePeriods','While de empresa, year->2035, initial_month->1, contador->5','2018-06-14 20:50:15',NULL),(3382,NULL,'assingMorePeriods','While de empresa, year->2036, initial_month->1, contador->6','2018-06-14 20:50:15',NULL),(3383,NULL,'assingMorePeriods','While de empresa, year->2037, initial_month->1, contador->7','2018-06-14 20:50:15',NULL),(3384,NULL,'assingMorePeriods','While de empresa, year->2038, initial_month->1, contador->8','2018-06-14 20:50:15',NULL),(3385,NULL,'assingMorePeriods','While de empresa, year->2039, initial_month->1, contador->9','2018-06-14 20:50:15',NULL),(3386,NULL,'assingMorePeriods','While de empresa, year->2040, initial_month->1, contador->10','2018-06-14 20:50:15',NULL),(3387,NULL,'assingMorePeriods','While de empresa, year->2041, initial_month->1, contador->11','2018-06-14 20:50:15',NULL),(3388,NULL,'assingMorePeriods','While de empresa, year->2042, initial_month->1, contador->12','2018-06-14 20:50:15',NULL),(3389,NULL,'assingMorePeriods','While de empresa, year->2043, initial_month->1, contador->13','2018-06-14 20:50:15',NULL),(3390,NULL,'assingMorePeriods','While de empresa, year->2044, initial_month->1, contador->14','2018-06-14 20:50:15',NULL),(3391,NULL,'assingMorePeriods','While de empresa, year->2045, initial_month->1, contador->15','2018-06-14 20:50:15',NULL),(3392,NULL,'assingMorePeriods','While de empresa, year->2046, initial_month->1, contador->16','2018-06-14 20:50:15',NULL),(3393,NULL,'assingMorePeriods','While de empresa, year->2047, initial_month->1, contador->17','2018-06-14 20:50:15',NULL),(3394,NULL,'assingMorePeriods','While de empresa, year->2048, initial_month->1, contador->18','2018-06-14 20:50:15',NULL),(3395,NULL,'assingMorePeriods','While de empresa, year->2049, initial_month->1, contador->19','2018-06-14 20:50:15',NULL),(3396,NULL,'assingMorePeriods','While de empresa, year->2050, initial_month->1, contador->20','2018-06-14 20:50:15',NULL),(3397,NULL,'assingMorePeriods','While de empresa, year->2051, initial_month->1, contador->21','2018-06-14 20:50:15',NULL),(3398,NULL,'assingMorePeriods','While de empresa, year->2052, initial_month->1, contador->22','2018-06-14 20:50:15',NULL),(3399,NULL,'assingMorePeriods','While de empresa, year->2053, initial_month->1, contador->23','2018-06-14 20:50:15',NULL),(3400,NULL,'assingMorePeriods','While de empresa, year->2054, initial_month->1, contador->24','2018-06-14 20:50:15',NULL);
INSERT INTO `log_debug` VALUES (3401,NULL,'assingMorePeriods','While de empresa, year->2055, initial_month->1, contador->25','2018-06-14 20:50:15',NULL),(3402,NULL,'assingMorePeriods','While de empresa, year->2056, initial_month->1, contador->26','2018-06-14 20:50:15',NULL),(3403,NULL,'assingMorePeriods','While de empresa, year->2057, initial_month->1, contador->27','2018-06-14 20:50:15',NULL),(3404,NULL,'assingMorePeriods','While de empresa, year->2058, initial_month->1, contador->28','2018-06-14 20:50:15',NULL),(3405,NULL,'assingMorePeriods','While de empresa, year->2059, initial_month->1, contador->29','2018-06-14 20:50:15',NULL),(3406,NULL,'assingMorePeriods','While de empresa, year->2060, initial_month->1, contador->30','2018-06-14 20:50:15',NULL),(3407,NULL,'assingMorePeriods','While de empresa, year->2061, initial_month->1, contador->31','2018-06-14 20:50:15',NULL),(3408,NULL,'assingMorePeriods','While de empresa, year->2062, initial_month->1, contador->32','2018-06-14 20:50:15',NULL),(3409,NULL,'assingMorePeriods','While de empresa, year->2063, initial_month->1, contador->33','2018-06-14 20:50:15',NULL),(3410,NULL,'assingMorePeriods','While de empresa, year->2064, initial_month->1, contador->34','2018-06-14 20:50:15',NULL),(3411,NULL,'assingMorePeriods','While de empresa, year->2065, initial_month->1, contador->35','2018-06-14 20:50:15',NULL),(3412,NULL,'assingMorePeriods','While de empresa, year->2066, initial_month->1, contador->36','2018-06-14 20:50:15',NULL),(3413,NULL,'assingMorePeriods','While de empresa, year->2067, initial_month->1, contador->37','2018-06-14 20:50:15',NULL),(3414,NULL,'assingMorePeriods','While de empresa, year->2068, initial_month->1, contador->38','2018-06-14 20:50:15',NULL),(3415,NULL,'assingMorePeriods','While de empresa, year->2069, initial_month->1, contador->39','2018-06-14 20:50:15',NULL),(3416,NULL,'assingMorePeriods','While de empresa, year->2070, initial_month->1, contador->40','2018-06-14 20:50:15',NULL),(3417,NULL,'assingMorePeriods','While de empresa, year->2071, initial_month->1, contador->41','2018-06-14 20:50:15',NULL),(3418,NULL,'assingMorePeriods','While de empresa, year->2072, initial_month->1, contador->42','2018-06-14 20:50:15',NULL),(3419,NULL,'assingMorePeriods','While de empresa, year->2073, initial_month->1, contador->43','2018-06-14 20:50:15',NULL),(3420,NULL,'assingMorePeriods','While de empresa, year->2074, initial_month->1, contador->44','2018-06-14 20:50:15',NULL),(3421,NULL,'assingMorePeriods','While de empresa, year->2075, initial_month->1, contador->45','2018-06-14 20:50:15',NULL),(3422,NULL,'assingMorePeriods','While de empresa, year->2076, initial_month->1, contador->46','2018-06-14 20:50:15',NULL),(3423,NULL,'assingMorePeriods','While de empresa, year->2077, initial_month->1, contador->47','2018-06-14 20:50:15',NULL),(3424,NULL,'assingMorePeriods','While de empresa, year->2078, initial_month->1, contador->48','2018-06-14 20:50:15',NULL),(3425,NULL,'assingMorePeriods','While de empresa, year->2079, initial_month->1, contador->49','2018-06-14 20:50:15',NULL),(3426,NULL,'assingMorePeriods','While de empresa, year->2080, initial_month->1, contador->50','2018-06-14 20:50:15',NULL),(3427,NULL,'assingMorePeriods','While de empresa, year->2081, initial_month->1, contador->51','2018-06-14 20:50:15',NULL),(3428,NULL,'assingMorePeriods','While de empresa, year->2082, initial_month->1, contador->52','2018-06-14 20:50:15',NULL),(3429,NULL,'assingMorePeriods','While de empresa, year->2083, initial_month->1, contador->53','2018-06-14 20:50:15',NULL),(3430,NULL,'assingMorePeriods','While de empresa, year->2084, initial_month->1, contador->54','2018-06-14 20:50:15',NULL),(3431,NULL,'assingMorePeriods','While de empresa, year->2085, initial_month->1, contador->55','2018-06-14 20:50:15',NULL),(3432,NULL,'assingMorePeriods','While de empresa, year->2086, initial_month->1, contador->56','2018-06-14 20:50:15',NULL),(3433,NULL,'assingMorePeriods','While de empresa, year->2087, initial_month->1, contador->57','2018-06-14 20:50:15',NULL);
INSERT INTO `log_debug` VALUES (3434,NULL,'assingMorePeriods','While de empresa, year->2088, initial_month->1, contador->58','2018-06-14 20:50:15',NULL),(3435,NULL,'assingMorePeriods','While de empresa, year->2089, initial_month->1, contador->59','2018-06-14 20:50:15',NULL),(3436,NULL,'assingMorePeriods','While de empresa, year->2090, initial_month->1, contador->60','2018-06-14 20:50:15',NULL),(3437,NULL,'assingMorePeriods','While de empresa, year->2091, initial_month->1, contador->61','2018-06-14 20:50:15',NULL),(3438,NULL,'assingMorePeriods','While de empresa, year->2092, initial_month->1, contador->62','2018-06-14 20:50:15',NULL),(3439,NULL,'assingMorePeriods','While de empresa, year->2093, initial_month->1, contador->63','2018-06-14 20:50:15',NULL),(3440,NULL,'assingMorePeriods','While de empresa, year->2094, initial_month->1, contador->64','2018-06-14 20:50:15',NULL),(3441,NULL,'assingMorePeriods','While de empresa, year->2095, initial_month->1, contador->65','2018-06-14 20:50:15',NULL),(3442,NULL,'assingMorePeriods','While de empresa, year->2096, initial_month->1, contador->66','2018-06-14 20:50:15',NULL),(3443,NULL,'assingMorePeriods','While de empresa, year->2097, initial_month->1, contador->67','2018-06-14 20:50:15',NULL),(3444,NULL,'assingMorePeriods','While de empresa, year->2098, initial_month->1, contador->68','2018-06-14 20:50:15',NULL),(3445,NULL,'assingMorePeriods','While de empresa, year->2099, initial_month->1, contador->69','2018-06-14 20:50:15',NULL),(3446,NULL,'assingMorePeriods','While de empresa, year->2100, initial_month->1, contador->70','2018-06-14 20:50:15',NULL),(3447,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1717, periodo->2030-12','2018-06-14 20:50:15',NULL),(3448,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->13, contador->0','2018-06-14 20:50:15',NULL),(3449,NULL,'assingMorePeriods','While de empresa, year->2031, initial_month->13, contador->1','2018-06-14 20:50:15',NULL),(3450,NULL,'assingMorePeriods','While de empresa, year->2032, initial_month->1, contador->2','2018-06-14 20:50:15',NULL),(3451,NULL,'assingMorePeriods','While de empresa, year->2033, initial_month->1, contador->3','2018-06-14 20:50:15',NULL),(3452,NULL,'assingMorePeriods','While de empresa, year->2034, initial_month->1, contador->4','2018-06-14 20:50:15',NULL),(3453,NULL,'assingMorePeriods','While de empresa, year->2035, initial_month->1, contador->5','2018-06-14 20:50:15',NULL),(3454,NULL,'assingMorePeriods','While de empresa, year->2036, initial_month->1, contador->6','2018-06-14 20:50:15',NULL),(3455,NULL,'assingMorePeriods','While de empresa, year->2037, initial_month->1, contador->7','2018-06-14 20:50:15',NULL),(3456,NULL,'assingMorePeriods','While de empresa, year->2038, initial_month->1, contador->8','2018-06-14 20:50:15',NULL),(3457,NULL,'assingMorePeriods','While de empresa, year->2039, initial_month->1, contador->9','2018-06-14 20:50:15',NULL),(3458,NULL,'assingMorePeriods','While de empresa, year->2040, initial_month->1, contador->10','2018-06-14 20:50:15',NULL),(3459,NULL,'assingMorePeriods','While de empresa, year->2041, initial_month->1, contador->11','2018-06-14 20:50:15',NULL),(3460,NULL,'assingMorePeriods','While de empresa, year->2042, initial_month->1, contador->12','2018-06-14 20:50:15',NULL),(3461,NULL,'assingMorePeriods','While de empresa, year->2043, initial_month->1, contador->13','2018-06-14 20:50:15',NULL),(3462,NULL,'assingMorePeriods','While de empresa, year->2044, initial_month->1, contador->14','2018-06-14 20:50:15',NULL),(3463,NULL,'assingMorePeriods','While de empresa, year->2045, initial_month->1, contador->15','2018-06-14 20:50:15',NULL),(3464,NULL,'assingMorePeriods','While de empresa, year->2046, initial_month->1, contador->16','2018-06-14 20:50:15',NULL),(3465,NULL,'assingMorePeriods','While de empresa, year->2047, initial_month->1, contador->17','2018-06-14 20:50:15',NULL),(3466,NULL,'assingMorePeriods','While de empresa, year->2048, initial_month->1, contador->18','2018-06-14 20:50:15',NULL);
INSERT INTO `log_debug` VALUES (3467,NULL,'assingMorePeriods','While de empresa, year->2049, initial_month->1, contador->19','2018-06-14 20:50:15',NULL),(3468,NULL,'assingMorePeriods','While de empresa, year->2050, initial_month->1, contador->20','2018-06-14 20:50:15',NULL),(3469,NULL,'assingMorePeriods','While de empresa, year->2051, initial_month->1, contador->21','2018-06-14 20:50:15',NULL),(3470,NULL,'assingMorePeriods','While de empresa, year->2052, initial_month->1, contador->22','2018-06-14 20:50:15',NULL),(3471,NULL,'assingMorePeriods','While de empresa, year->2053, initial_month->1, contador->23','2018-06-14 20:50:15',NULL),(3472,NULL,'assingMorePeriods','While de empresa, year->2054, initial_month->1, contador->24','2018-06-14 20:50:15',NULL),(3473,NULL,'assingMorePeriods','While de empresa, year->2055, initial_month->1, contador->25','2018-06-14 20:50:15',NULL),(3474,NULL,'assingMorePeriods','While de empresa, year->2056, initial_month->1, contador->26','2018-06-14 20:50:15',NULL),(3475,NULL,'assingMorePeriods','While de empresa, year->2057, initial_month->1, contador->27','2018-06-14 20:50:15',NULL),(3476,NULL,'assingMorePeriods','While de empresa, year->2058, initial_month->1, contador->28','2018-06-14 20:50:15',NULL),(3477,NULL,'assingMorePeriods','While de empresa, year->2059, initial_month->1, contador->29','2018-06-14 20:50:15',NULL),(3478,NULL,'assingMorePeriods','While de empresa, year->2060, initial_month->1, contador->30','2018-06-14 20:50:15',NULL),(3479,NULL,'assingMorePeriods','While de empresa, year->2061, initial_month->1, contador->31','2018-06-14 20:50:15',NULL),(3480,NULL,'assingMorePeriods','While de empresa, year->2062, initial_month->1, contador->32','2018-06-14 20:50:15',NULL),(3481,NULL,'assingMorePeriods','While de empresa, year->2063, initial_month->1, contador->33','2018-06-14 20:50:15',NULL),(3482,NULL,'assingMorePeriods','While de empresa, year->2064, initial_month->1, contador->34','2018-06-14 20:50:15',NULL),(3483,NULL,'assingMorePeriods','While de empresa, year->2065, initial_month->1, contador->35','2018-06-14 20:50:15',NULL),(3484,NULL,'assingMorePeriods','While de empresa, year->2066, initial_month->1, contador->36','2018-06-14 20:50:15',NULL),(3485,NULL,'assingMorePeriods','While de empresa, year->2067, initial_month->1, contador->37','2018-06-14 20:50:15',NULL),(3486,NULL,'assingMorePeriods','While de empresa, year->2068, initial_month->1, contador->38','2018-06-14 20:50:15',NULL),(3487,NULL,'assingMorePeriods','While de empresa, year->2069, initial_month->1, contador->39','2018-06-14 20:50:15',NULL),(3488,NULL,'assingMorePeriods','While de empresa, year->2070, initial_month->1, contador->40','2018-06-14 20:50:15',NULL),(3489,NULL,'assingMorePeriods','While de empresa, year->2071, initial_month->1, contador->41','2018-06-14 20:50:15',NULL),(3490,NULL,'assingMorePeriods','While de empresa, year->2072, initial_month->1, contador->42','2018-06-14 20:50:15',NULL),(3491,NULL,'assingMorePeriods','While de empresa, year->2073, initial_month->1, contador->43','2018-06-14 20:50:15',NULL),(3492,NULL,'assingMorePeriods','While de empresa, year->2074, initial_month->1, contador->44','2018-06-14 20:50:15',NULL),(3493,NULL,'assingMorePeriods','While de empresa, year->2075, initial_month->1, contador->45','2018-06-14 20:50:15',NULL),(3494,NULL,'assingMorePeriods','While de empresa, year->2076, initial_month->1, contador->46','2018-06-14 20:50:15',NULL),(3495,NULL,'assingMorePeriods','While de empresa, year->2077, initial_month->1, contador->47','2018-06-14 20:50:15',NULL),(3496,NULL,'assingMorePeriods','While de empresa, year->2078, initial_month->1, contador->48','2018-06-14 20:50:15',NULL),(3497,NULL,'assingMorePeriods','While de empresa, year->2079, initial_month->1, contador->49','2018-06-14 20:50:15',NULL),(3498,NULL,'assingMorePeriods','While de empresa, year->2080, initial_month->1, contador->50','2018-06-14 20:50:15',NULL),(3499,NULL,'assingMorePeriods','While de empresa, year->2081, initial_month->1, contador->51','2018-06-14 20:50:15',NULL);
INSERT INTO `log_debug` VALUES (3500,NULL,'assingMorePeriods','While de empresa, year->2082, initial_month->1, contador->52','2018-06-14 20:50:15',NULL),(3501,NULL,'assingMorePeriods','While de empresa, year->2083, initial_month->1, contador->53','2018-06-14 20:50:15',NULL),(3502,NULL,'assingMorePeriods','While de empresa, year->2084, initial_month->1, contador->54','2018-06-14 20:50:15',NULL),(3503,NULL,'assingMorePeriods','While de empresa, year->2085, initial_month->1, contador->55','2018-06-14 20:50:15',NULL),(3504,NULL,'assingMorePeriods','While de empresa, year->2086, initial_month->1, contador->56','2018-06-14 20:50:15',NULL),(3505,NULL,'assingMorePeriods','While de empresa, year->2087, initial_month->1, contador->57','2018-06-14 20:50:15',NULL),(3506,NULL,'assingMorePeriods','While de empresa, year->2088, initial_month->1, contador->58','2018-06-14 20:50:15',NULL),(3507,NULL,'assingMorePeriods','While de empresa, year->2089, initial_month->1, contador->59','2018-06-14 20:50:15',NULL),(3508,NULL,'assingMorePeriods','While de empresa, year->2090, initial_month->1, contador->60','2018-06-14 20:50:15',NULL),(3509,NULL,'assingMorePeriods','While de empresa, year->2091, initial_month->1, contador->61','2018-06-14 20:50:15',NULL),(3510,NULL,'assingMorePeriods','While de empresa, year->2092, initial_month->1, contador->62','2018-06-14 20:50:15',NULL),(3511,NULL,'assingMorePeriods','While de empresa, year->2093, initial_month->1, contador->63','2018-06-14 20:50:15',NULL),(3512,NULL,'assingMorePeriods','While de empresa, year->2094, initial_month->1, contador->64','2018-06-14 20:50:15',NULL),(3513,NULL,'assingMorePeriods','While de empresa, year->2095, initial_month->1, contador->65','2018-06-14 20:50:15',NULL),(3514,NULL,'assingMorePeriods','While de empresa, year->2096, initial_month->1, contador->66','2018-06-14 20:50:15',NULL),(3515,NULL,'assingMorePeriods','While de empresa, year->2097, initial_month->1, contador->67','2018-06-14 20:50:15',NULL),(3516,NULL,'assingMorePeriods','While de empresa, year->2098, initial_month->1, contador->68','2018-06-14 20:50:15',NULL),(3517,NULL,'assingMorePeriods','While de empresa, year->2099, initial_month->1, contador->69','2018-06-14 20:50:15',NULL),(3518,NULL,'assingMorePeriods','While de empresa, year->2100, initial_month->1, contador->70','2018-06-14 20:50:15',NULL),(3519,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1729, periodo->2030-12','2018-06-14 20:50:15',NULL),(3520,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->13, contador->0','2018-06-14 20:50:15',NULL),(3521,NULL,'assingMorePeriods','While de empresa, year->2031, initial_month->13, contador->1','2018-06-14 20:50:15',NULL),(3522,NULL,'assingMorePeriods','While de empresa, year->2032, initial_month->1, contador->2','2018-06-14 20:50:15',NULL),(3523,NULL,'assingMorePeriods','While de empresa, year->2033, initial_month->1, contador->3','2018-06-14 20:50:15',NULL),(3524,NULL,'assingMorePeriods','While de empresa, year->2034, initial_month->1, contador->4','2018-06-14 20:50:15',NULL),(3525,NULL,'assingMorePeriods','While de empresa, year->2035, initial_month->1, contador->5','2018-06-14 20:50:15',NULL),(3526,NULL,'assingMorePeriods','While de empresa, year->2036, initial_month->1, contador->6','2018-06-14 20:50:15',NULL),(3527,NULL,'assingMorePeriods','While de empresa, year->2037, initial_month->1, contador->7','2018-06-14 20:50:15',NULL),(3528,NULL,'assingMorePeriods','While de empresa, year->2038, initial_month->1, contador->8','2018-06-14 20:50:15',NULL),(3529,NULL,'assingMorePeriods','While de empresa, year->2039, initial_month->1, contador->9','2018-06-14 20:50:15',NULL),(3530,NULL,'assingMorePeriods','While de empresa, year->2040, initial_month->1, contador->10','2018-06-14 20:50:15',NULL),(3531,NULL,'assingMorePeriods','While de empresa, year->2041, initial_month->1, contador->11','2018-06-14 20:50:15',NULL),(3532,NULL,'assingMorePeriods','While de empresa, year->2042, initial_month->1, contador->12','2018-06-14 20:50:15',NULL);
INSERT INTO `log_debug` VALUES (3533,NULL,'assingMorePeriods','While de empresa, year->2043, initial_month->1, contador->13','2018-06-14 20:50:15',NULL),(3534,NULL,'assingMorePeriods','While de empresa, year->2044, initial_month->1, contador->14','2018-06-14 20:50:15',NULL),(3535,NULL,'assingMorePeriods','While de empresa, year->2045, initial_month->1, contador->15','2018-06-14 20:50:15',NULL),(3536,NULL,'assingMorePeriods','While de empresa, year->2046, initial_month->1, contador->16','2018-06-14 20:50:15',NULL),(3537,NULL,'assingMorePeriods','While de empresa, year->2047, initial_month->1, contador->17','2018-06-14 20:50:15',NULL),(3538,NULL,'assingMorePeriods','While de empresa, year->2048, initial_month->1, contador->18','2018-06-14 20:50:15',NULL),(3539,NULL,'assingMorePeriods','While de empresa, year->2049, initial_month->1, contador->19','2018-06-14 20:50:15',NULL),(3540,NULL,'assingMorePeriods','While de empresa, year->2050, initial_month->1, contador->20','2018-06-14 20:50:15',NULL),(3541,NULL,'assingMorePeriods','While de empresa, year->2051, initial_month->1, contador->21','2018-06-14 20:50:15',NULL),(3542,NULL,'assingMorePeriods','While de empresa, year->2052, initial_month->1, contador->22','2018-06-14 20:50:15',NULL),(3543,NULL,'assingMorePeriods','While de empresa, year->2053, initial_month->1, contador->23','2018-06-14 20:50:15',NULL),(3544,NULL,'assingMorePeriods','While de empresa, year->2054, initial_month->1, contador->24','2018-06-14 20:50:15',NULL),(3545,NULL,'assingMorePeriods','While de empresa, year->2055, initial_month->1, contador->25','2018-06-14 20:50:15',NULL),(3546,NULL,'assingMorePeriods','While de empresa, year->2056, initial_month->1, contador->26','2018-06-14 20:50:15',NULL),(3547,NULL,'assingMorePeriods','While de empresa, year->2057, initial_month->1, contador->27','2018-06-14 20:50:15',NULL),(3548,NULL,'assingMorePeriods','While de empresa, year->2058, initial_month->1, contador->28','2018-06-14 20:50:15',NULL),(3549,NULL,'assingMorePeriods','While de empresa, year->2059, initial_month->1, contador->29','2018-06-14 20:50:15',NULL),(3550,NULL,'assingMorePeriods','While de empresa, year->2060, initial_month->1, contador->30','2018-06-14 20:50:15',NULL),(3551,NULL,'assingMorePeriods','While de empresa, year->2061, initial_month->1, contador->31','2018-06-14 20:50:15',NULL),(3552,NULL,'assingMorePeriods','While de empresa, year->2062, initial_month->1, contador->32','2018-06-14 20:50:15',NULL),(3553,NULL,'assingMorePeriods','While de empresa, year->2063, initial_month->1, contador->33','2018-06-14 20:50:15',NULL),(3554,NULL,'assingMorePeriods','While de empresa, year->2064, initial_month->1, contador->34','2018-06-14 20:50:15',NULL),(3555,NULL,'assingMorePeriods','While de empresa, year->2065, initial_month->1, contador->35','2018-06-14 20:50:15',NULL),(3556,NULL,'assingMorePeriods','While de empresa, year->2066, initial_month->1, contador->36','2018-06-14 20:50:15',NULL),(3557,NULL,'assingMorePeriods','While de empresa, year->2067, initial_month->1, contador->37','2018-06-14 20:50:15',NULL),(3558,NULL,'assingMorePeriods','While de empresa, year->2068, initial_month->1, contador->38','2018-06-14 20:50:15',NULL),(3559,NULL,'assingMorePeriods','While de empresa, year->2069, initial_month->1, contador->39','2018-06-14 20:50:15',NULL),(3560,NULL,'assingMorePeriods','While de empresa, year->2070, initial_month->1, contador->40','2018-06-14 20:50:15',NULL),(3561,NULL,'assingMorePeriods','While de empresa, year->2071, initial_month->1, contador->41','2018-06-14 20:50:15',NULL),(3562,NULL,'assingMorePeriods','While de empresa, year->2072, initial_month->1, contador->42','2018-06-14 20:50:15',NULL),(3563,NULL,'assingMorePeriods','While de empresa, year->2073, initial_month->1, contador->43','2018-06-14 20:50:15',NULL),(3564,NULL,'assingMorePeriods','While de empresa, year->2074, initial_month->1, contador->44','2018-06-14 20:50:15',NULL),(3565,NULL,'assingMorePeriods','While de empresa, year->2075, initial_month->1, contador->45','2018-06-14 20:50:15',NULL);
INSERT INTO `log_debug` VALUES (3566,NULL,'assingMorePeriods','While de empresa, year->2076, initial_month->1, contador->46','2018-06-14 20:50:15',NULL),(3567,NULL,'assingMorePeriods','While de empresa, year->2077, initial_month->1, contador->47','2018-06-14 20:50:15',NULL),(3568,NULL,'assingMorePeriods','While de empresa, year->2078, initial_month->1, contador->48','2018-06-14 20:50:15',NULL),(3569,NULL,'assingMorePeriods','While de empresa, year->2079, initial_month->1, contador->49','2018-06-14 20:50:15',NULL),(3570,NULL,'assingMorePeriods','While de empresa, year->2080, initial_month->1, contador->50','2018-06-14 20:50:15',NULL),(3571,NULL,'assingMorePeriods','While de empresa, year->2081, initial_month->1, contador->51','2018-06-14 20:50:15',NULL),(3572,NULL,'assingMorePeriods','While de empresa, year->2082, initial_month->1, contador->52','2018-06-14 20:50:15',NULL),(3573,NULL,'assingMorePeriods','While de empresa, year->2083, initial_month->1, contador->53','2018-06-14 20:50:15',NULL),(3574,NULL,'assingMorePeriods','While de empresa, year->2084, initial_month->1, contador->54','2018-06-14 20:50:15',NULL),(3575,NULL,'assingMorePeriods','While de empresa, year->2085, initial_month->1, contador->55','2018-06-14 20:50:15',NULL),(3576,NULL,'assingMorePeriods','While de empresa, year->2086, initial_month->1, contador->56','2018-06-14 20:50:15',NULL),(3577,NULL,'assingMorePeriods','While de empresa, year->2087, initial_month->1, contador->57','2018-06-14 20:50:15',NULL),(3578,NULL,'assingMorePeriods','While de empresa, year->2088, initial_month->1, contador->58','2018-06-14 20:50:15',NULL),(3579,NULL,'assingMorePeriods','While de empresa, year->2089, initial_month->1, contador->59','2018-06-14 20:50:15',NULL),(3580,NULL,'assingMorePeriods','While de empresa, year->2090, initial_month->1, contador->60','2018-06-14 20:50:15',NULL),(3581,NULL,'assingMorePeriods','While de empresa, year->2091, initial_month->1, contador->61','2018-06-14 20:50:15',NULL),(3582,NULL,'assingMorePeriods','While de empresa, year->2092, initial_month->1, contador->62','2018-06-14 20:50:15',NULL),(3583,NULL,'assingMorePeriods','While de empresa, year->2093, initial_month->1, contador->63','2018-06-14 20:50:15',NULL),(3584,NULL,'assingMorePeriods','While de empresa, year->2094, initial_month->1, contador->64','2018-06-14 20:50:15',NULL),(3585,NULL,'assingMorePeriods','While de empresa, year->2095, initial_month->1, contador->65','2018-06-14 20:50:15',NULL),(3586,NULL,'assingMorePeriods','While de empresa, year->2096, initial_month->1, contador->66','2018-06-14 20:50:15',NULL),(3587,NULL,'assingMorePeriods','While de empresa, year->2097, initial_month->1, contador->67','2018-06-14 20:50:15',NULL),(3588,NULL,'assingMorePeriods','While de empresa, year->2098, initial_month->1, contador->68','2018-06-14 20:50:15',NULL),(3589,NULL,'assingMorePeriods','While de empresa, year->2099, initial_month->1, contador->69','2018-06-14 20:50:15',NULL),(3590,NULL,'assingMorePeriods','While de empresa, year->2100, initial_month->1, contador->70','2018-06-14 20:50:15',NULL),(3591,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1736, periodo->2030-12','2018-06-14 20:50:15',NULL),(3592,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->13, contador->0','2018-06-14 20:50:15',NULL),(3593,NULL,'assingMorePeriods','While de empresa, year->2031, initial_month->13, contador->1','2018-06-14 20:50:15',NULL),(3594,NULL,'assingMorePeriods','While de empresa, year->2032, initial_month->1, contador->2','2018-06-14 20:50:15',NULL),(3595,NULL,'assingMorePeriods','While de empresa, year->2033, initial_month->1, contador->3','2018-06-14 20:50:15',NULL),(3596,NULL,'assingMorePeriods','While de empresa, year->2034, initial_month->1, contador->4','2018-06-14 20:50:15',NULL),(3597,NULL,'assingMorePeriods','While de empresa, year->2035, initial_month->1, contador->5','2018-06-14 20:50:15',NULL),(3598,NULL,'assingMorePeriods','While de empresa, year->2036, initial_month->1, contador->6','2018-06-14 20:50:15',NULL);
INSERT INTO `log_debug` VALUES (3599,NULL,'assingMorePeriods','While de empresa, year->2037, initial_month->1, contador->7','2018-06-14 20:50:15',NULL),(3600,NULL,'assingMorePeriods','While de empresa, year->2038, initial_month->1, contador->8','2018-06-14 20:50:15',NULL),(3601,NULL,'assingMorePeriods','While de empresa, year->2039, initial_month->1, contador->9','2018-06-14 20:50:15',NULL),(3602,NULL,'assingMorePeriods','While de empresa, year->2040, initial_month->1, contador->10','2018-06-14 20:50:15',NULL),(3603,NULL,'assingMorePeriods','While de empresa, year->2041, initial_month->1, contador->11','2018-06-14 20:50:15',NULL),(3604,NULL,'assingMorePeriods','While de empresa, year->2042, initial_month->1, contador->12','2018-06-14 20:50:15',NULL),(3605,NULL,'assingMorePeriods','While de empresa, year->2043, initial_month->1, contador->13','2018-06-14 20:50:15',NULL),(3606,NULL,'assingMorePeriods','While de empresa, year->2044, initial_month->1, contador->14','2018-06-14 20:50:15',NULL),(3607,NULL,'assingMorePeriods','While de empresa, year->2045, initial_month->1, contador->15','2018-06-14 20:50:15',NULL),(3608,NULL,'assingMorePeriods','While de empresa, year->2046, initial_month->1, contador->16','2018-06-14 20:50:15',NULL),(3609,NULL,'assingMorePeriods','While de empresa, year->2047, initial_month->1, contador->17','2018-06-14 20:50:15',NULL),(3610,NULL,'assingMorePeriods','While de empresa, year->2048, initial_month->1, contador->18','2018-06-14 20:50:15',NULL),(3611,NULL,'assingMorePeriods','While de empresa, year->2049, initial_month->1, contador->19','2018-06-14 20:50:15',NULL),(3612,NULL,'assingMorePeriods','While de empresa, year->2050, initial_month->1, contador->20','2018-06-14 20:50:15',NULL),(3613,NULL,'assingMorePeriods','While de empresa, year->2051, initial_month->1, contador->21','2018-06-14 20:50:15',NULL),(3614,NULL,'assingMorePeriods','While de empresa, year->2052, initial_month->1, contador->22','2018-06-14 20:50:15',NULL),(3615,NULL,'assingMorePeriods','While de empresa, year->2053, initial_month->1, contador->23','2018-06-14 20:50:15',NULL),(3616,NULL,'assingMorePeriods','While de empresa, year->2054, initial_month->1, contador->24','2018-06-14 20:50:15',NULL),(3617,NULL,'assingMorePeriods','While de empresa, year->2055, initial_month->1, contador->25','2018-06-14 20:50:15',NULL),(3618,NULL,'assingMorePeriods','While de empresa, year->2056, initial_month->1, contador->26','2018-06-14 20:50:15',NULL),(3619,NULL,'assingMorePeriods','While de empresa, year->2057, initial_month->1, contador->27','2018-06-14 20:50:15',NULL),(3620,NULL,'assingMorePeriods','While de empresa, year->2058, initial_month->1, contador->28','2018-06-14 20:50:15',NULL),(3621,NULL,'assingMorePeriods','While de empresa, year->2059, initial_month->1, contador->29','2018-06-14 20:50:15',NULL),(3622,NULL,'assingMorePeriods','While de empresa, year->2060, initial_month->1, contador->30','2018-06-14 20:50:15',NULL),(3623,NULL,'assingMorePeriods','While de empresa, year->2061, initial_month->1, contador->31','2018-06-14 20:50:15',NULL),(3624,NULL,'assingMorePeriods','While de empresa, year->2062, initial_month->1, contador->32','2018-06-14 20:50:15',NULL),(3625,NULL,'assingMorePeriods','While de empresa, year->2063, initial_month->1, contador->33','2018-06-14 20:50:15',NULL),(3626,NULL,'assingMorePeriods','While de empresa, year->2064, initial_month->1, contador->34','2018-06-14 20:50:15',NULL),(3627,NULL,'assingMorePeriods','While de empresa, year->2065, initial_month->1, contador->35','2018-06-14 20:50:15',NULL),(3628,NULL,'assingMorePeriods','While de empresa, year->2066, initial_month->1, contador->36','2018-06-14 20:50:15',NULL),(3629,NULL,'assingMorePeriods','While de empresa, year->2067, initial_month->1, contador->37','2018-06-14 20:50:15',NULL),(3630,NULL,'assingMorePeriods','While de empresa, year->2068, initial_month->1, contador->38','2018-06-14 20:50:15',NULL),(3631,NULL,'assingMorePeriods','While de empresa, year->2069, initial_month->1, contador->39','2018-06-14 20:50:15',NULL);
INSERT INTO `log_debug` VALUES (3632,NULL,'assingMorePeriods','While de empresa, year->2070, initial_month->1, contador->40','2018-06-14 20:50:15',NULL),(3633,NULL,'assingMorePeriods','While de empresa, year->2071, initial_month->1, contador->41','2018-06-14 20:50:15',NULL),(3634,NULL,'assingMorePeriods','While de empresa, year->2072, initial_month->1, contador->42','2018-06-14 20:50:15',NULL),(3635,NULL,'assingMorePeriods','While de empresa, year->2073, initial_month->1, contador->43','2018-06-14 20:50:15',NULL),(3636,NULL,'assingMorePeriods','While de empresa, year->2074, initial_month->1, contador->44','2018-06-14 20:50:15',NULL),(3637,NULL,'assingMorePeriods','While de empresa, year->2075, initial_month->1, contador->45','2018-06-14 20:50:15',NULL),(3638,NULL,'assingMorePeriods','While de empresa, year->2076, initial_month->1, contador->46','2018-06-14 20:50:15',NULL),(3639,NULL,'assingMorePeriods','While de empresa, year->2077, initial_month->1, contador->47','2018-06-14 20:50:15',NULL),(3640,NULL,'assingMorePeriods','While de empresa, year->2078, initial_month->1, contador->48','2018-06-14 20:50:15',NULL),(3641,NULL,'assingMorePeriods','While de empresa, year->2079, initial_month->1, contador->49','2018-06-14 20:50:15',NULL),(3642,NULL,'assingMorePeriods','While de empresa, year->2080, initial_month->1, contador->50','2018-06-14 20:50:15',NULL),(3643,NULL,'assingMorePeriods','While de empresa, year->2081, initial_month->1, contador->51','2018-06-14 20:50:15',NULL),(3644,NULL,'assingMorePeriods','While de empresa, year->2082, initial_month->1, contador->52','2018-06-14 20:50:15',NULL),(3645,NULL,'assingMorePeriods','While de empresa, year->2083, initial_month->1, contador->53','2018-06-14 20:50:15',NULL),(3646,NULL,'assingMorePeriods','While de empresa, year->2084, initial_month->1, contador->54','2018-06-14 20:50:15',NULL),(3647,NULL,'assingMorePeriods','While de empresa, year->2085, initial_month->1, contador->55','2018-06-14 20:50:15',NULL),(3648,NULL,'assingMorePeriods','While de empresa, year->2086, initial_month->1, contador->56','2018-06-14 20:50:15',NULL),(3649,NULL,'assingMorePeriods','While de empresa, year->2087, initial_month->1, contador->57','2018-06-14 20:50:15',NULL),(3650,NULL,'assingMorePeriods','While de empresa, year->2088, initial_month->1, contador->58','2018-06-14 20:50:15',NULL),(3651,NULL,'assingMorePeriods','While de empresa, year->2089, initial_month->1, contador->59','2018-06-14 20:50:15',NULL),(3652,NULL,'assingMorePeriods','While de empresa, year->2090, initial_month->1, contador->60','2018-06-14 20:50:15',NULL),(3653,NULL,'assingMorePeriods','While de empresa, year->2091, initial_month->1, contador->61','2018-06-14 20:50:15',NULL),(3654,NULL,'assingMorePeriods','While de empresa, year->2092, initial_month->1, contador->62','2018-06-14 20:50:15',NULL),(3655,NULL,'assingMorePeriods','While de empresa, year->2093, initial_month->1, contador->63','2018-06-14 20:50:15',NULL),(3656,NULL,'assingMorePeriods','While de empresa, year->2094, initial_month->1, contador->64','2018-06-14 20:50:15',NULL),(3657,NULL,'assingMorePeriods','While de empresa, year->2095, initial_month->1, contador->65','2018-06-14 20:50:15',NULL),(3658,NULL,'assingMorePeriods','While de empresa, year->2096, initial_month->1, contador->66','2018-06-14 20:50:15',NULL),(3659,NULL,'assingMorePeriods','While de empresa, year->2097, initial_month->1, contador->67','2018-06-14 20:50:15',NULL),(3660,NULL,'assingMorePeriods','While de empresa, year->2098, initial_month->1, contador->68','2018-06-14 20:50:15',NULL),(3661,NULL,'assingMorePeriods','While de empresa, year->2099, initial_month->1, contador->69','2018-06-14 20:50:15',NULL),(3662,NULL,'assingMorePeriods','While de empresa, year->2100, initial_month->1, contador->70','2018-06-14 20:50:15',NULL),(3663,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1845, periodo->2030-12','2018-06-14 20:50:15',NULL),(3664,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->13, contador->0','2018-06-14 20:50:15',NULL);
INSERT INTO `log_debug` VALUES (3665,NULL,'assingMorePeriods','While de empresa, year->2031, initial_month->13, contador->1','2018-06-14 20:50:15',NULL),(3666,NULL,'assingMorePeriods','While de empresa, year->2032, initial_month->1, contador->2','2018-06-14 20:50:15',NULL),(3667,NULL,'assingMorePeriods','While de empresa, year->2033, initial_month->1, contador->3','2018-06-14 20:50:15',NULL),(3668,NULL,'assingMorePeriods','While de empresa, year->2034, initial_month->1, contador->4','2018-06-14 20:50:15',NULL),(3669,NULL,'assingMorePeriods','While de empresa, year->2035, initial_month->1, contador->5','2018-06-14 20:50:15',NULL),(3670,NULL,'assingMorePeriods','While de empresa, year->2036, initial_month->1, contador->6','2018-06-14 20:50:15',NULL),(3671,NULL,'assingMorePeriods','While de empresa, year->2037, initial_month->1, contador->7','2018-06-14 20:50:15',NULL),(3672,NULL,'assingMorePeriods','While de empresa, year->2038, initial_month->1, contador->8','2018-06-14 20:50:15',NULL),(3673,NULL,'assingMorePeriods','While de empresa, year->2039, initial_month->1, contador->9','2018-06-14 20:50:15',NULL),(3674,NULL,'assingMorePeriods','While de empresa, year->2040, initial_month->1, contador->10','2018-06-14 20:50:15',NULL),(3675,NULL,'assingMorePeriods','While de empresa, year->2041, initial_month->1, contador->11','2018-06-14 20:50:15',NULL),(3676,NULL,'assingMorePeriods','While de empresa, year->2042, initial_month->1, contador->12','2018-06-14 20:50:15',NULL),(3677,NULL,'assingMorePeriods','While de empresa, year->2043, initial_month->1, contador->13','2018-06-14 20:50:15',NULL),(3678,NULL,'assingMorePeriods','While de empresa, year->2044, initial_month->1, contador->14','2018-06-14 20:50:15',NULL),(3679,NULL,'assingMorePeriods','While de empresa, year->2045, initial_month->1, contador->15','2018-06-14 20:50:15',NULL),(3680,NULL,'assingMorePeriods','While de empresa, year->2046, initial_month->1, contador->16','2018-06-14 20:50:15',NULL),(3681,NULL,'assingMorePeriods','While de empresa, year->2047, initial_month->1, contador->17','2018-06-14 20:50:15',NULL),(3682,NULL,'assingMorePeriods','While de empresa, year->2048, initial_month->1, contador->18','2018-06-14 20:50:15',NULL),(3683,NULL,'assingMorePeriods','While de empresa, year->2049, initial_month->1, contador->19','2018-06-14 20:50:15',NULL),(3684,NULL,'assingMorePeriods','While de empresa, year->2050, initial_month->1, contador->20','2018-06-14 20:50:15',NULL),(3685,NULL,'assingMorePeriods','While de empresa, year->2051, initial_month->1, contador->21','2018-06-14 20:50:15',NULL),(3686,NULL,'assingMorePeriods','While de empresa, year->2052, initial_month->1, contador->22','2018-06-14 20:50:15',NULL),(3687,NULL,'assingMorePeriods','While de empresa, year->2053, initial_month->1, contador->23','2018-06-14 20:50:15',NULL),(3688,NULL,'assingMorePeriods','While de empresa, year->2054, initial_month->1, contador->24','2018-06-14 20:50:15',NULL),(3689,NULL,'assingMorePeriods','While de empresa, year->2055, initial_month->1, contador->25','2018-06-14 20:50:15',NULL),(3690,NULL,'assingMorePeriods','While de empresa, year->2056, initial_month->1, contador->26','2018-06-14 20:50:15',NULL),(3691,NULL,'assingMorePeriods','While de empresa, year->2057, initial_month->1, contador->27','2018-06-14 20:50:15',NULL),(3692,NULL,'assingMorePeriods','While de empresa, year->2058, initial_month->1, contador->28','2018-06-14 20:50:15',NULL),(3693,NULL,'assingMorePeriods','While de empresa, year->2059, initial_month->1, contador->29','2018-06-14 20:50:15',NULL),(3694,NULL,'assingMorePeriods','While de empresa, year->2060, initial_month->1, contador->30','2018-06-14 20:50:15',NULL),(3695,NULL,'assingMorePeriods','While de empresa, year->2061, initial_month->1, contador->31','2018-06-14 20:50:15',NULL),(3696,NULL,'assingMorePeriods','While de empresa, year->2062, initial_month->1, contador->32','2018-06-14 20:50:15',NULL),(3697,NULL,'assingMorePeriods','While de empresa, year->2063, initial_month->1, contador->33','2018-06-14 20:50:15',NULL);
INSERT INTO `log_debug` VALUES (3698,NULL,'assingMorePeriods','While de empresa, year->2064, initial_month->1, contador->34','2018-06-14 20:50:15',NULL),(3699,NULL,'assingMorePeriods','While de empresa, year->2065, initial_month->1, contador->35','2018-06-14 20:50:15',NULL),(3700,NULL,'assingMorePeriods','While de empresa, year->2066, initial_month->1, contador->36','2018-06-14 20:50:15',NULL),(3701,NULL,'assingMorePeriods','While de empresa, year->2067, initial_month->1, contador->37','2018-06-14 20:50:15',NULL),(3702,NULL,'assingMorePeriods','While de empresa, year->2068, initial_month->1, contador->38','2018-06-14 20:50:15',NULL),(3703,NULL,'assingMorePeriods','While de empresa, year->2069, initial_month->1, contador->39','2018-06-14 20:50:15',NULL),(3704,NULL,'assingMorePeriods','While de empresa, year->2070, initial_month->1, contador->40','2018-06-14 20:50:15',NULL),(3705,NULL,'assingMorePeriods','While de empresa, year->2071, initial_month->1, contador->41','2018-06-14 20:50:15',NULL),(3706,NULL,'assingMorePeriods','While de empresa, year->2072, initial_month->1, contador->42','2018-06-14 20:50:15',NULL),(3707,NULL,'assingMorePeriods','While de empresa, year->2073, initial_month->1, contador->43','2018-06-14 20:50:15',NULL),(3708,NULL,'assingMorePeriods','While de empresa, year->2074, initial_month->1, contador->44','2018-06-14 20:50:15',NULL),(3709,NULL,'assingMorePeriods','While de empresa, year->2075, initial_month->1, contador->45','2018-06-14 20:50:15',NULL),(3710,NULL,'assingMorePeriods','While de empresa, year->2076, initial_month->1, contador->46','2018-06-14 20:50:15',NULL),(3711,NULL,'assingMorePeriods','While de empresa, year->2077, initial_month->1, contador->47','2018-06-14 20:50:15',NULL),(3712,NULL,'assingMorePeriods','While de empresa, year->2078, initial_month->1, contador->48','2018-06-14 20:50:15',NULL),(3713,NULL,'assingMorePeriods','While de empresa, year->2079, initial_month->1, contador->49','2018-06-14 20:50:15',NULL),(3714,NULL,'assingMorePeriods','While de empresa, year->2080, initial_month->1, contador->50','2018-06-14 20:50:15',NULL),(3715,NULL,'assingMorePeriods','While de empresa, year->2081, initial_month->1, contador->51','2018-06-14 20:50:15',NULL),(3716,NULL,'assingMorePeriods','While de empresa, year->2082, initial_month->1, contador->52','2018-06-14 20:50:15',NULL),(3717,NULL,'assingMorePeriods','While de empresa, year->2083, initial_month->1, contador->53','2018-06-14 20:50:15',NULL),(3718,NULL,'assingMorePeriods','While de empresa, year->2084, initial_month->1, contador->54','2018-06-14 20:50:15',NULL),(3719,NULL,'assingMorePeriods','While de empresa, year->2085, initial_month->1, contador->55','2018-06-14 20:50:15',NULL),(3720,NULL,'assingMorePeriods','While de empresa, year->2086, initial_month->1, contador->56','2018-06-14 20:50:15',NULL),(3721,NULL,'assingMorePeriods','While de empresa, year->2087, initial_month->1, contador->57','2018-06-14 20:50:15',NULL),(3722,NULL,'assingMorePeriods','While de empresa, year->2088, initial_month->1, contador->58','2018-06-14 20:50:15',NULL),(3723,NULL,'assingMorePeriods','While de empresa, year->2089, initial_month->1, contador->59','2018-06-14 20:50:15',NULL),(3724,NULL,'assingMorePeriods','While de empresa, year->2090, initial_month->1, contador->60','2018-06-14 20:50:15',NULL),(3725,NULL,'assingMorePeriods','While de empresa, year->2091, initial_month->1, contador->61','2018-06-14 20:50:15',NULL),(3726,NULL,'assingMorePeriods','While de empresa, year->2092, initial_month->1, contador->62','2018-06-14 20:50:15',NULL),(3727,NULL,'assingMorePeriods','While de empresa, year->2093, initial_month->1, contador->63','2018-06-14 20:50:15',NULL),(3728,NULL,'assingMorePeriods','While de empresa, year->2094, initial_month->1, contador->64','2018-06-14 20:50:15',NULL),(3729,NULL,'assingMorePeriods','While de empresa, year->2095, initial_month->1, contador->65','2018-06-14 20:50:15',NULL),(3730,NULL,'assingMorePeriods','While de empresa, year->2096, initial_month->1, contador->66','2018-06-14 20:50:15',NULL);
INSERT INTO `log_debug` VALUES (3731,NULL,'assingMorePeriods','While de empresa, year->2097, initial_month->1, contador->67','2018-06-14 20:50:15',NULL),(3732,NULL,'assingMorePeriods','While de empresa, year->2098, initial_month->1, contador->68','2018-06-14 20:50:15',NULL),(3733,NULL,'assingMorePeriods','While de empresa, year->2099, initial_month->1, contador->69','2018-06-14 20:50:15',NULL),(3734,NULL,'assingMorePeriods','While de empresa, year->2100, initial_month->1, contador->70','2018-06-14 20:50:15',NULL),(3735,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1859, periodo->2030-12','2018-06-14 20:50:15',NULL),(3736,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->13, contador->0','2018-06-14 20:50:15',NULL),(3737,NULL,'assingMorePeriods','While de empresa, year->2031, initial_month->13, contador->1','2018-06-14 20:50:15',NULL),(3738,NULL,'assingMorePeriods','While de empresa, year->2032, initial_month->1, contador->2','2018-06-14 20:50:15',NULL),(3739,NULL,'assingMorePeriods','While de empresa, year->2033, initial_month->1, contador->3','2018-06-14 20:50:15',NULL),(3740,NULL,'assingMorePeriods','While de empresa, year->2034, initial_month->1, contador->4','2018-06-14 20:50:15',NULL),(3741,NULL,'assingMorePeriods','While de empresa, year->2035, initial_month->1, contador->5','2018-06-14 20:50:15',NULL),(3742,NULL,'assingMorePeriods','While de empresa, year->2036, initial_month->1, contador->6','2018-06-14 20:50:15',NULL),(3743,NULL,'assingMorePeriods','While de empresa, year->2037, initial_month->1, contador->7','2018-06-14 20:50:15',NULL),(3744,NULL,'assingMorePeriods','While de empresa, year->2038, initial_month->1, contador->8','2018-06-14 20:50:15',NULL),(3745,NULL,'assingMorePeriods','While de empresa, year->2039, initial_month->1, contador->9','2018-06-14 20:50:15',NULL),(3746,NULL,'assingMorePeriods','While de empresa, year->2040, initial_month->1, contador->10','2018-06-14 20:50:15',NULL),(3747,NULL,'assingMorePeriods','While de empresa, year->2041, initial_month->1, contador->11','2018-06-14 20:50:15',NULL),(3748,NULL,'assingMorePeriods','While de empresa, year->2042, initial_month->1, contador->12','2018-06-14 20:50:15',NULL),(3749,NULL,'assingMorePeriods','While de empresa, year->2043, initial_month->1, contador->13','2018-06-14 20:50:15',NULL),(3750,NULL,'assingMorePeriods','While de empresa, year->2044, initial_month->1, contador->14','2018-06-14 20:50:15',NULL),(3751,NULL,'assingMorePeriods','While de empresa, year->2045, initial_month->1, contador->15','2018-06-14 20:50:15',NULL),(3752,NULL,'assingMorePeriods','While de empresa, year->2046, initial_month->1, contador->16','2018-06-14 20:50:15',NULL),(3753,NULL,'assingMorePeriods','While de empresa, year->2047, initial_month->1, contador->17','2018-06-14 20:50:15',NULL),(3754,NULL,'assingMorePeriods','While de empresa, year->2048, initial_month->1, contador->18','2018-06-14 20:50:15',NULL),(3755,NULL,'assingMorePeriods','While de empresa, year->2049, initial_month->1, contador->19','2018-06-14 20:50:15',NULL),(3756,NULL,'assingMorePeriods','While de empresa, year->2050, initial_month->1, contador->20','2018-06-14 20:50:15',NULL),(3757,NULL,'assingMorePeriods','While de empresa, year->2051, initial_month->1, contador->21','2018-06-14 20:50:15',NULL),(3758,NULL,'assingMorePeriods','While de empresa, year->2052, initial_month->1, contador->22','2018-06-14 20:50:15',NULL),(3759,NULL,'assingMorePeriods','While de empresa, year->2053, initial_month->1, contador->23','2018-06-14 20:50:15',NULL),(3760,NULL,'assingMorePeriods','While de empresa, year->2054, initial_month->1, contador->24','2018-06-14 20:50:15',NULL),(3761,NULL,'assingMorePeriods','While de empresa, year->2055, initial_month->1, contador->25','2018-06-14 20:50:15',NULL),(3762,NULL,'assingMorePeriods','While de empresa, year->2056, initial_month->1, contador->26','2018-06-14 20:50:15',NULL),(3763,NULL,'assingMorePeriods','While de empresa, year->2057, initial_month->1, contador->27','2018-06-14 20:50:15',NULL);
INSERT INTO `log_debug` VALUES (3764,NULL,'assingMorePeriods','While de empresa, year->2058, initial_month->1, contador->28','2018-06-14 20:50:15',NULL),(3765,NULL,'assingMorePeriods','While de empresa, year->2059, initial_month->1, contador->29','2018-06-14 20:50:15',NULL),(3766,NULL,'assingMorePeriods','While de empresa, year->2060, initial_month->1, contador->30','2018-06-14 20:50:15',NULL),(3767,NULL,'assingMorePeriods','While de empresa, year->2061, initial_month->1, contador->31','2018-06-14 20:50:15',NULL),(3768,NULL,'assingMorePeriods','While de empresa, year->2062, initial_month->1, contador->32','2018-06-14 20:50:15',NULL),(3769,NULL,'assingMorePeriods','While de empresa, year->2063, initial_month->1, contador->33','2018-06-14 20:50:15',NULL),(3770,NULL,'assingMorePeriods','While de empresa, year->2064, initial_month->1, contador->34','2018-06-14 20:50:15',NULL),(3771,NULL,'assingMorePeriods','While de empresa, year->2065, initial_month->1, contador->35','2018-06-14 20:50:15',NULL),(3772,NULL,'assingMorePeriods','While de empresa, year->2066, initial_month->1, contador->36','2018-06-14 20:50:15',NULL),(3773,NULL,'assingMorePeriods','While de empresa, year->2067, initial_month->1, contador->37','2018-06-14 20:50:15',NULL),(3774,NULL,'assingMorePeriods','While de empresa, year->2068, initial_month->1, contador->38','2018-06-14 20:50:15',NULL),(3775,NULL,'assingMorePeriods','While de empresa, year->2069, initial_month->1, contador->39','2018-06-14 20:50:15',NULL),(3776,NULL,'assingMorePeriods','While de empresa, year->2070, initial_month->1, contador->40','2018-06-14 20:50:15',NULL),(3777,NULL,'assingMorePeriods','While de empresa, year->2071, initial_month->1, contador->41','2018-06-14 20:50:15',NULL),(3778,NULL,'assingMorePeriods','While de empresa, year->2072, initial_month->1, contador->42','2018-06-14 20:50:15',NULL),(3779,NULL,'assingMorePeriods','While de empresa, year->2073, initial_month->1, contador->43','2018-06-14 20:50:15',NULL),(3780,NULL,'assingMorePeriods','While de empresa, year->2074, initial_month->1, contador->44','2018-06-14 20:50:15',NULL),(3781,NULL,'assingMorePeriods','While de empresa, year->2075, initial_month->1, contador->45','2018-06-14 20:50:15',NULL),(3782,NULL,'assingMorePeriods','While de empresa, year->2076, initial_month->1, contador->46','2018-06-14 20:50:15',NULL),(3783,NULL,'assingMorePeriods','While de empresa, year->2077, initial_month->1, contador->47','2018-06-14 20:50:15',NULL),(3784,NULL,'assingMorePeriods','While de empresa, year->2078, initial_month->1, contador->48','2018-06-14 20:50:15',NULL),(3785,NULL,'assingMorePeriods','While de empresa, year->2079, initial_month->1, contador->49','2018-06-14 20:50:15',NULL),(3786,NULL,'assingMorePeriods','While de empresa, year->2080, initial_month->1, contador->50','2018-06-14 20:50:15',NULL),(3787,NULL,'assingMorePeriods','While de empresa, year->2081, initial_month->1, contador->51','2018-06-14 20:50:15',NULL),(3788,NULL,'assingMorePeriods','While de empresa, year->2082, initial_month->1, contador->52','2018-06-14 20:50:15',NULL),(3789,NULL,'assingMorePeriods','While de empresa, year->2083, initial_month->1, contador->53','2018-06-14 20:50:15',NULL),(3790,NULL,'assingMorePeriods','While de empresa, year->2084, initial_month->1, contador->54','2018-06-14 20:50:15',NULL),(3791,NULL,'assingMorePeriods','While de empresa, year->2085, initial_month->1, contador->55','2018-06-14 20:50:15',NULL),(3792,NULL,'assingMorePeriods','While de empresa, year->2086, initial_month->1, contador->56','2018-06-14 20:50:15',NULL),(3793,NULL,'assingMorePeriods','While de empresa, year->2087, initial_month->1, contador->57','2018-06-14 20:50:15',NULL),(3794,NULL,'assingMorePeriods','While de empresa, year->2088, initial_month->1, contador->58','2018-06-14 20:50:15',NULL),(3795,NULL,'assingMorePeriods','While de empresa, year->2089, initial_month->1, contador->59','2018-06-14 20:50:15',NULL),(3796,NULL,'assingMorePeriods','While de empresa, year->2090, initial_month->1, contador->60','2018-06-14 20:50:15',NULL);
INSERT INTO `log_debug` VALUES (3797,NULL,'assingMorePeriods','While de empresa, year->2091, initial_month->1, contador->61','2018-06-14 20:50:15',NULL),(3798,NULL,'assingMorePeriods','While de empresa, year->2092, initial_month->1, contador->62','2018-06-14 20:50:15',NULL),(3799,NULL,'assingMorePeriods','While de empresa, year->2093, initial_month->1, contador->63','2018-06-14 20:50:15',NULL),(3800,NULL,'assingMorePeriods','While de empresa, year->2094, initial_month->1, contador->64','2018-06-14 20:50:15',NULL),(3801,NULL,'assingMorePeriods','While de empresa, year->2095, initial_month->1, contador->65','2018-06-14 20:50:15',NULL),(3802,NULL,'assingMorePeriods','While de empresa, year->2096, initial_month->1, contador->66','2018-06-14 20:50:15',NULL),(3803,NULL,'assingMorePeriods','While de empresa, year->2097, initial_month->1, contador->67','2018-06-14 20:50:15',NULL),(3804,NULL,'assingMorePeriods','While de empresa, year->2098, initial_month->1, contador->68','2018-06-14 20:50:15',NULL),(3805,NULL,'assingMorePeriods','While de empresa, year->2099, initial_month->1, contador->69','2018-06-14 20:50:15',NULL),(3806,NULL,'assingMorePeriods','While de empresa, year->2100, initial_month->1, contador->70','2018-06-14 20:50:15',NULL),(3807,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1865, periodo->2030-12','2018-06-14 20:50:15',NULL),(3808,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->13, contador->0','2018-06-14 20:50:15',NULL),(3809,NULL,'assingMorePeriods','While de empresa, year->2031, initial_month->13, contador->1','2018-06-14 20:50:15',NULL),(3810,NULL,'assingMorePeriods','While de empresa, year->2032, initial_month->1, contador->2','2018-06-14 20:50:15',NULL),(3811,NULL,'assingMorePeriods','While de empresa, year->2033, initial_month->1, contador->3','2018-06-14 20:50:15',NULL),(3812,NULL,'assingMorePeriods','While de empresa, year->2034, initial_month->1, contador->4','2018-06-14 20:50:15',NULL),(3813,NULL,'assingMorePeriods','While de empresa, year->2035, initial_month->1, contador->5','2018-06-14 20:50:15',NULL),(3814,NULL,'assingMorePeriods','While de empresa, year->2036, initial_month->1, contador->6','2018-06-14 20:50:15',NULL),(3815,NULL,'assingMorePeriods','While de empresa, year->2037, initial_month->1, contador->7','2018-06-14 20:50:15',NULL),(3816,NULL,'assingMorePeriods','While de empresa, year->2038, initial_month->1, contador->8','2018-06-14 20:50:15',NULL),(3817,NULL,'assingMorePeriods','While de empresa, year->2039, initial_month->1, contador->9','2018-06-14 20:50:15',NULL),(3818,NULL,'assingMorePeriods','While de empresa, year->2040, initial_month->1, contador->10','2018-06-14 20:50:15',NULL),(3819,NULL,'assingMorePeriods','While de empresa, year->2041, initial_month->1, contador->11','2018-06-14 20:50:15',NULL),(3820,NULL,'assingMorePeriods','While de empresa, year->2042, initial_month->1, contador->12','2018-06-14 20:50:15',NULL),(3821,NULL,'assingMorePeriods','While de empresa, year->2043, initial_month->1, contador->13','2018-06-14 20:50:15',NULL),(3822,NULL,'assingMorePeriods','While de empresa, year->2044, initial_month->1, contador->14','2018-06-14 20:50:15',NULL),(3823,NULL,'assingMorePeriods','While de empresa, year->2045, initial_month->1, contador->15','2018-06-14 20:50:15',NULL),(3824,NULL,'assingMorePeriods','While de empresa, year->2046, initial_month->1, contador->16','2018-06-14 20:50:15',NULL),(3825,NULL,'assingMorePeriods','While de empresa, year->2047, initial_month->1, contador->17','2018-06-14 20:50:15',NULL),(3826,NULL,'assingMorePeriods','While de empresa, year->2048, initial_month->1, contador->18','2018-06-14 20:50:15',NULL),(3827,NULL,'assingMorePeriods','While de empresa, year->2049, initial_month->1, contador->19','2018-06-14 20:50:15',NULL),(3828,NULL,'assingMorePeriods','While de empresa, year->2050, initial_month->1, contador->20','2018-06-14 20:50:15',NULL),(3829,NULL,'assingMorePeriods','While de empresa, year->2051, initial_month->1, contador->21','2018-06-14 20:50:15',NULL);
INSERT INTO `log_debug` VALUES (3830,NULL,'assingMorePeriods','While de empresa, year->2052, initial_month->1, contador->22','2018-06-14 20:50:15',NULL),(3831,NULL,'assingMorePeriods','While de empresa, year->2053, initial_month->1, contador->23','2018-06-14 20:50:15',NULL),(3832,NULL,'assingMorePeriods','While de empresa, year->2054, initial_month->1, contador->24','2018-06-14 20:50:15',NULL),(3833,NULL,'assingMorePeriods','While de empresa, year->2055, initial_month->1, contador->25','2018-06-14 20:50:15',NULL),(3834,NULL,'assingMorePeriods','While de empresa, year->2056, initial_month->1, contador->26','2018-06-14 20:50:15',NULL),(3835,NULL,'assingMorePeriods','While de empresa, year->2057, initial_month->1, contador->27','2018-06-14 20:50:15',NULL),(3836,NULL,'assingMorePeriods','While de empresa, year->2058, initial_month->1, contador->28','2018-06-14 20:50:15',NULL),(3837,NULL,'assingMorePeriods','While de empresa, year->2059, initial_month->1, contador->29','2018-06-14 20:50:15',NULL),(3838,NULL,'assingMorePeriods','While de empresa, year->2060, initial_month->1, contador->30','2018-06-14 20:50:15',NULL),(3839,NULL,'assingMorePeriods','While de empresa, year->2061, initial_month->1, contador->31','2018-06-14 20:50:15',NULL),(3840,NULL,'assingMorePeriods','While de empresa, year->2062, initial_month->1, contador->32','2018-06-14 20:50:15',NULL),(3841,NULL,'assingMorePeriods','While de empresa, year->2063, initial_month->1, contador->33','2018-06-14 20:50:15',NULL),(3842,NULL,'assingMorePeriods','While de empresa, year->2064, initial_month->1, contador->34','2018-06-14 20:50:15',NULL),(3843,NULL,'assingMorePeriods','While de empresa, year->2065, initial_month->1, contador->35','2018-06-14 20:50:15',NULL),(3844,NULL,'assingMorePeriods','While de empresa, year->2066, initial_month->1, contador->36','2018-06-14 20:50:15',NULL),(3845,NULL,'assingMorePeriods','While de empresa, year->2067, initial_month->1, contador->37','2018-06-14 20:50:15',NULL),(3846,NULL,'assingMorePeriods','While de empresa, year->2068, initial_month->1, contador->38','2018-06-14 20:50:15',NULL),(3847,NULL,'assingMorePeriods','While de empresa, year->2069, initial_month->1, contador->39','2018-06-14 20:50:15',NULL),(3848,NULL,'assingMorePeriods','While de empresa, year->2070, initial_month->1, contador->40','2018-06-14 20:50:15',NULL),(3849,NULL,'assingMorePeriods','While de empresa, year->2071, initial_month->1, contador->41','2018-06-14 20:50:15',NULL),(3850,NULL,'assingMorePeriods','While de empresa, year->2072, initial_month->1, contador->42','2018-06-14 20:50:15',NULL),(3851,NULL,'assingMorePeriods','While de empresa, year->2073, initial_month->1, contador->43','2018-06-14 20:50:15',NULL),(3852,NULL,'assingMorePeriods','While de empresa, year->2074, initial_month->1, contador->44','2018-06-14 20:50:15',NULL),(3853,NULL,'assingMorePeriods','While de empresa, year->2075, initial_month->1, contador->45','2018-06-14 20:50:15',NULL),(3854,NULL,'assingMorePeriods','While de empresa, year->2076, initial_month->1, contador->46','2018-06-14 20:50:15',NULL),(3855,NULL,'assingMorePeriods','While de empresa, year->2077, initial_month->1, contador->47','2018-06-14 20:50:15',NULL),(3856,NULL,'assingMorePeriods','While de empresa, year->2078, initial_month->1, contador->48','2018-06-14 20:50:15',NULL),(3857,NULL,'assingMorePeriods','While de empresa, year->2079, initial_month->1, contador->49','2018-06-14 20:50:15',NULL),(3858,NULL,'assingMorePeriods','While de empresa, year->2080, initial_month->1, contador->50','2018-06-14 20:50:15',NULL),(3859,NULL,'assingMorePeriods','While de empresa, year->2081, initial_month->1, contador->51','2018-06-14 20:50:15',NULL),(3860,NULL,'assingMorePeriods','While de empresa, year->2082, initial_month->1, contador->52','2018-06-14 20:50:15',NULL),(3861,NULL,'assingMorePeriods','While de empresa, year->2083, initial_month->1, contador->53','2018-06-14 20:50:15',NULL),(3862,NULL,'assingMorePeriods','While de empresa, year->2084, initial_month->1, contador->54','2018-06-14 20:50:15',NULL);
INSERT INTO `log_debug` VALUES (3863,NULL,'assingMorePeriods','While de empresa, year->2085, initial_month->1, contador->55','2018-06-14 20:50:15',NULL),(3864,NULL,'assingMorePeriods','While de empresa, year->2086, initial_month->1, contador->56','2018-06-14 20:50:15',NULL),(3865,NULL,'assingMorePeriods','While de empresa, year->2087, initial_month->1, contador->57','2018-06-14 20:50:15',NULL),(3866,NULL,'assingMorePeriods','While de empresa, year->2088, initial_month->1, contador->58','2018-06-14 20:50:15',NULL),(3867,NULL,'assingMorePeriods','While de empresa, year->2089, initial_month->1, contador->59','2018-06-14 20:50:15',NULL),(3868,NULL,'assingMorePeriods','While de empresa, year->2090, initial_month->1, contador->60','2018-06-14 20:50:15',NULL),(3869,NULL,'assingMorePeriods','While de empresa, year->2091, initial_month->1, contador->61','2018-06-14 20:50:15',NULL),(3870,NULL,'assingMorePeriods','While de empresa, year->2092, initial_month->1, contador->62','2018-06-14 20:50:15',NULL),(3871,NULL,'assingMorePeriods','While de empresa, year->2093, initial_month->1, contador->63','2018-06-14 20:50:15',NULL),(3872,NULL,'assingMorePeriods','While de empresa, year->2094, initial_month->1, contador->64','2018-06-14 20:50:15',NULL),(3873,NULL,'assingMorePeriods','While de empresa, year->2095, initial_month->1, contador->65','2018-06-14 20:50:15',NULL),(3874,NULL,'assingMorePeriods','While de empresa, year->2096, initial_month->1, contador->66','2018-06-14 20:50:15',NULL),(3875,NULL,'assingMorePeriods','While de empresa, year->2097, initial_month->1, contador->67','2018-06-14 20:50:15',NULL),(3876,NULL,'assingMorePeriods','While de empresa, year->2098, initial_month->1, contador->68','2018-06-14 20:50:15',NULL),(3877,NULL,'assingMorePeriods','While de empresa, year->2099, initial_month->1, contador->69','2018-06-14 20:50:15',NULL),(3878,NULL,'assingMorePeriods','While de empresa, year->2100, initial_month->1, contador->70','2018-06-14 20:50:15',NULL),(3879,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1870, periodo->2030-12','2018-06-14 20:50:15',NULL),(3880,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->13, contador->0','2018-06-14 20:50:15',NULL),(3881,NULL,'assingMorePeriods','While de empresa, year->2031, initial_month->13, contador->1','2018-06-14 20:50:15',NULL),(3882,NULL,'assingMorePeriods','While de empresa, year->2032, initial_month->1, contador->2','2018-06-14 20:50:15',NULL),(3883,NULL,'assingMorePeriods','While de empresa, year->2033, initial_month->1, contador->3','2018-06-14 20:50:15',NULL),(3884,NULL,'assingMorePeriods','While de empresa, year->2034, initial_month->1, contador->4','2018-06-14 20:50:15',NULL),(3885,NULL,'assingMorePeriods','While de empresa, year->2035, initial_month->1, contador->5','2018-06-14 20:50:15',NULL),(3886,NULL,'assingMorePeriods','While de empresa, year->2036, initial_month->1, contador->6','2018-06-14 20:50:15',NULL),(3887,NULL,'assingMorePeriods','While de empresa, year->2037, initial_month->1, contador->7','2018-06-14 20:50:15',NULL),(3888,NULL,'assingMorePeriods','While de empresa, year->2038, initial_month->1, contador->8','2018-06-14 20:50:15',NULL),(3889,NULL,'assingMorePeriods','While de empresa, year->2039, initial_month->1, contador->9','2018-06-14 20:50:15',NULL),(3890,NULL,'assingMorePeriods','While de empresa, year->2040, initial_month->1, contador->10','2018-06-14 20:50:15',NULL),(3891,NULL,'assingMorePeriods','While de empresa, year->2041, initial_month->1, contador->11','2018-06-14 20:50:15',NULL),(3892,NULL,'assingMorePeriods','While de empresa, year->2042, initial_month->1, contador->12','2018-06-14 20:50:15',NULL),(3893,NULL,'assingMorePeriods','While de empresa, year->2043, initial_month->1, contador->13','2018-06-14 20:50:15',NULL),(3894,NULL,'assingMorePeriods','While de empresa, year->2044, initial_month->1, contador->14','2018-06-14 20:50:15',NULL),(3895,NULL,'assingMorePeriods','While de empresa, year->2045, initial_month->1, contador->15','2018-06-14 20:50:15',NULL);
INSERT INTO `log_debug` VALUES (3896,NULL,'assingMorePeriods','While de empresa, year->2046, initial_month->1, contador->16','2018-06-14 20:50:15',NULL),(3897,NULL,'assingMorePeriods','While de empresa, year->2047, initial_month->1, contador->17','2018-06-14 20:50:15',NULL),(3898,NULL,'assingMorePeriods','While de empresa, year->2048, initial_month->1, contador->18','2018-06-14 20:50:15',NULL),(3899,NULL,'assingMorePeriods','While de empresa, year->2049, initial_month->1, contador->19','2018-06-14 20:50:15',NULL),(3900,NULL,'assingMorePeriods','While de empresa, year->2050, initial_month->1, contador->20','2018-06-14 20:50:15',NULL),(3901,NULL,'assingMorePeriods','While de empresa, year->2051, initial_month->1, contador->21','2018-06-14 20:50:15',NULL),(3902,NULL,'assingMorePeriods','While de empresa, year->2052, initial_month->1, contador->22','2018-06-14 20:50:15',NULL),(3903,NULL,'assingMorePeriods','While de empresa, year->2053, initial_month->1, contador->23','2018-06-14 20:50:15',NULL),(3904,NULL,'assingMorePeriods','While de empresa, year->2054, initial_month->1, contador->24','2018-06-14 20:50:15',NULL),(3905,NULL,'assingMorePeriods','While de empresa, year->2055, initial_month->1, contador->25','2018-06-14 20:50:15',NULL),(3906,NULL,'assingMorePeriods','While de empresa, year->2056, initial_month->1, contador->26','2018-06-14 20:50:15',NULL),(3907,NULL,'assingMorePeriods','While de empresa, year->2057, initial_month->1, contador->27','2018-06-14 20:50:15',NULL),(3908,NULL,'assingMorePeriods','While de empresa, year->2058, initial_month->1, contador->28','2018-06-14 20:50:15',NULL),(3909,NULL,'assingMorePeriods','While de empresa, year->2059, initial_month->1, contador->29','2018-06-14 20:50:15',NULL),(3910,NULL,'assingMorePeriods','While de empresa, year->2060, initial_month->1, contador->30','2018-06-14 20:50:15',NULL),(3911,NULL,'assingMorePeriods','While de empresa, year->2061, initial_month->1, contador->31','2018-06-14 20:50:15',NULL),(3912,NULL,'assingMorePeriods','While de empresa, year->2062, initial_month->1, contador->32','2018-06-14 20:50:15',NULL),(3913,NULL,'assingMorePeriods','While de empresa, year->2063, initial_month->1, contador->33','2018-06-14 20:50:15',NULL),(3914,NULL,'assingMorePeriods','While de empresa, year->2064, initial_month->1, contador->34','2018-06-14 20:50:15',NULL),(3915,NULL,'assingMorePeriods','While de empresa, year->2065, initial_month->1, contador->35','2018-06-14 20:50:15',NULL),(3916,NULL,'assingMorePeriods','While de empresa, year->2066, initial_month->1, contador->36','2018-06-14 20:50:15',NULL),(3917,NULL,'assingMorePeriods','While de empresa, year->2067, initial_month->1, contador->37','2018-06-14 20:50:15',NULL),(3918,NULL,'assingMorePeriods','While de empresa, year->2068, initial_month->1, contador->38','2018-06-14 20:50:15',NULL),(3919,NULL,'assingMorePeriods','While de empresa, year->2069, initial_month->1, contador->39','2018-06-14 20:50:15',NULL),(3920,NULL,'assingMorePeriods','While de empresa, year->2070, initial_month->1, contador->40','2018-06-14 20:50:15',NULL),(3921,NULL,'assingMorePeriods','While de empresa, year->2071, initial_month->1, contador->41','2018-06-14 20:50:15',NULL),(3922,NULL,'assingMorePeriods','While de empresa, year->2072, initial_month->1, contador->42','2018-06-14 20:50:15',NULL),(3923,NULL,'assingMorePeriods','While de empresa, year->2073, initial_month->1, contador->43','2018-06-14 20:50:15',NULL),(3924,NULL,'assingMorePeriods','While de empresa, year->2074, initial_month->1, contador->44','2018-06-14 20:50:15',NULL),(3925,NULL,'assingMorePeriods','While de empresa, year->2075, initial_month->1, contador->45','2018-06-14 20:50:15',NULL),(3926,NULL,'assingMorePeriods','While de empresa, year->2076, initial_month->1, contador->46','2018-06-14 20:50:15',NULL),(3927,NULL,'assingMorePeriods','While de empresa, year->2077, initial_month->1, contador->47','2018-06-14 20:50:15',NULL),(3928,NULL,'assingMorePeriods','While de empresa, year->2078, initial_month->1, contador->48','2018-06-14 20:50:15',NULL);
INSERT INTO `log_debug` VALUES (3929,NULL,'assingMorePeriods','While de empresa, year->2079, initial_month->1, contador->49','2018-06-14 20:50:15',NULL),(3930,NULL,'assingMorePeriods','While de empresa, year->2080, initial_month->1, contador->50','2018-06-14 20:50:15',NULL),(3931,NULL,'assingMorePeriods','While de empresa, year->2081, initial_month->1, contador->51','2018-06-14 20:50:15',NULL),(3932,NULL,'assingMorePeriods','While de empresa, year->2082, initial_month->1, contador->52','2018-06-14 20:50:15',NULL),(3933,NULL,'assingMorePeriods','While de empresa, year->2083, initial_month->1, contador->53','2018-06-14 20:50:15',NULL),(3934,NULL,'assingMorePeriods','While de empresa, year->2084, initial_month->1, contador->54','2018-06-14 20:50:15',NULL),(3935,NULL,'assingMorePeriods','While de empresa, year->2085, initial_month->1, contador->55','2018-06-14 20:50:15',NULL),(3936,NULL,'assingMorePeriods','While de empresa, year->2086, initial_month->1, contador->56','2018-06-14 20:50:15',NULL),(3937,NULL,'assingMorePeriods','While de empresa, year->2087, initial_month->1, contador->57','2018-06-14 20:50:15',NULL),(3938,NULL,'assingMorePeriods','While de empresa, year->2088, initial_month->1, contador->58','2018-06-14 20:50:15',NULL),(3939,NULL,'assingMorePeriods','While de empresa, year->2089, initial_month->1, contador->59','2018-06-14 20:50:15',NULL),(3940,NULL,'assingMorePeriods','While de empresa, year->2090, initial_month->1, contador->60','2018-06-14 20:50:15',NULL),(3941,NULL,'assingMorePeriods','While de empresa, year->2091, initial_month->1, contador->61','2018-06-14 20:50:15',NULL),(3942,NULL,'assingMorePeriods','While de empresa, year->2092, initial_month->1, contador->62','2018-06-14 20:50:15',NULL),(3943,NULL,'assingMorePeriods','While de empresa, year->2093, initial_month->1, contador->63','2018-06-14 20:50:15',NULL),(3944,NULL,'assingMorePeriods','While de empresa, year->2094, initial_month->1, contador->64','2018-06-14 20:50:15',NULL),(3945,NULL,'assingMorePeriods','While de empresa, year->2095, initial_month->1, contador->65','2018-06-14 20:50:15',NULL),(3946,NULL,'assingMorePeriods','While de empresa, year->2096, initial_month->1, contador->66','2018-06-14 20:50:15',NULL),(3947,NULL,'assingMorePeriods','While de empresa, year->2097, initial_month->1, contador->67','2018-06-14 20:50:15',NULL),(3948,NULL,'assingMorePeriods','While de empresa, year->2098, initial_month->1, contador->68','2018-06-14 20:50:15',NULL),(3949,NULL,'assingMorePeriods','While de empresa, year->2099, initial_month->1, contador->69','2018-06-14 20:50:15',NULL),(3950,NULL,'assingMorePeriods','While de empresa, year->2100, initial_month->1, contador->70','2018-06-14 20:50:15',NULL),(3951,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1979, periodo->2030-12','2018-06-14 20:50:15',NULL),(3952,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->13, contador->0','2018-06-14 20:50:15',NULL),(3953,NULL,'assingMorePeriods','While de empresa, year->2031, initial_month->13, contador->1','2018-06-14 20:50:15',NULL),(3954,NULL,'assingMorePeriods','While de empresa, year->2032, initial_month->1, contador->2','2018-06-14 20:50:15',NULL),(3955,NULL,'assingMorePeriods','While de empresa, year->2033, initial_month->1, contador->3','2018-06-14 20:50:15',NULL),(3956,NULL,'assingMorePeriods','While de empresa, year->2034, initial_month->1, contador->4','2018-06-14 20:50:15',NULL),(3957,NULL,'assingMorePeriods','While de empresa, year->2035, initial_month->1, contador->5','2018-06-14 20:50:15',NULL),(3958,NULL,'assingMorePeriods','While de empresa, year->2036, initial_month->1, contador->6','2018-06-14 20:50:15',NULL),(3959,NULL,'assingMorePeriods','While de empresa, year->2037, initial_month->1, contador->7','2018-06-14 20:50:15',NULL),(3960,NULL,'assingMorePeriods','While de empresa, year->2038, initial_month->1, contador->8','2018-06-14 20:50:15',NULL),(3961,NULL,'assingMorePeriods','While de empresa, year->2039, initial_month->1, contador->9','2018-06-14 20:50:15',NULL);
INSERT INTO `log_debug` VALUES (3962,NULL,'assingMorePeriods','While de empresa, year->2040, initial_month->1, contador->10','2018-06-14 20:50:15',NULL),(3963,NULL,'assingMorePeriods','While de empresa, year->2041, initial_month->1, contador->11','2018-06-14 20:50:15',NULL),(3964,NULL,'assingMorePeriods','While de empresa, year->2042, initial_month->1, contador->12','2018-06-14 20:50:15',NULL),(3965,NULL,'assingMorePeriods','While de empresa, year->2043, initial_month->1, contador->13','2018-06-14 20:50:15',NULL),(3966,NULL,'assingMorePeriods','While de empresa, year->2044, initial_month->1, contador->14','2018-06-14 20:50:15',NULL),(3967,NULL,'assingMorePeriods','While de empresa, year->2045, initial_month->1, contador->15','2018-06-14 20:50:15',NULL),(3968,NULL,'assingMorePeriods','While de empresa, year->2046, initial_month->1, contador->16','2018-06-14 20:50:15',NULL),(3969,NULL,'assingMorePeriods','While de empresa, year->2047, initial_month->1, contador->17','2018-06-14 20:50:15',NULL),(3970,NULL,'assingMorePeriods','While de empresa, year->2048, initial_month->1, contador->18','2018-06-14 20:50:15',NULL),(3971,NULL,'assingMorePeriods','While de empresa, year->2049, initial_month->1, contador->19','2018-06-14 20:50:15',NULL),(3972,NULL,'assingMorePeriods','While de empresa, year->2050, initial_month->1, contador->20','2018-06-14 20:50:15',NULL),(3973,NULL,'assingMorePeriods','While de empresa, year->2051, initial_month->1, contador->21','2018-06-14 20:50:15',NULL),(3974,NULL,'assingMorePeriods','While de empresa, year->2052, initial_month->1, contador->22','2018-06-14 20:50:15',NULL),(3975,NULL,'assingMorePeriods','While de empresa, year->2053, initial_month->1, contador->23','2018-06-14 20:50:15',NULL),(3976,NULL,'assingMorePeriods','While de empresa, year->2054, initial_month->1, contador->24','2018-06-14 20:50:15',NULL),(3977,NULL,'assingMorePeriods','While de empresa, year->2055, initial_month->1, contador->25','2018-06-14 20:50:15',NULL),(3978,NULL,'assingMorePeriods','While de empresa, year->2056, initial_month->1, contador->26','2018-06-14 20:50:15',NULL),(3979,NULL,'assingMorePeriods','While de empresa, year->2057, initial_month->1, contador->27','2018-06-14 20:50:15',NULL),(3980,NULL,'assingMorePeriods','While de empresa, year->2058, initial_month->1, contador->28','2018-06-14 20:50:15',NULL),(3981,NULL,'assingMorePeriods','While de empresa, year->2059, initial_month->1, contador->29','2018-06-14 20:50:15',NULL),(3982,NULL,'assingMorePeriods','While de empresa, year->2060, initial_month->1, contador->30','2018-06-14 20:50:15',NULL),(3983,NULL,'assingMorePeriods','While de empresa, year->2061, initial_month->1, contador->31','2018-06-14 20:50:15',NULL),(3984,NULL,'assingMorePeriods','While de empresa, year->2062, initial_month->1, contador->32','2018-06-14 20:50:15',NULL),(3985,NULL,'assingMorePeriods','While de empresa, year->2063, initial_month->1, contador->33','2018-06-14 20:50:15',NULL),(3986,NULL,'assingMorePeriods','While de empresa, year->2064, initial_month->1, contador->34','2018-06-14 20:50:15',NULL),(3987,NULL,'assingMorePeriods','While de empresa, year->2065, initial_month->1, contador->35','2018-06-14 20:50:15',NULL),(3988,NULL,'assingMorePeriods','While de empresa, year->2066, initial_month->1, contador->36','2018-06-14 20:50:15',NULL),(3989,NULL,'assingMorePeriods','While de empresa, year->2067, initial_month->1, contador->37','2018-06-14 20:50:15',NULL),(3990,NULL,'assingMorePeriods','While de empresa, year->2068, initial_month->1, contador->38','2018-06-14 20:50:15',NULL),(3991,NULL,'assingMorePeriods','While de empresa, year->2069, initial_month->1, contador->39','2018-06-14 20:50:15',NULL),(3992,NULL,'assingMorePeriods','While de empresa, year->2070, initial_month->1, contador->40','2018-06-14 20:50:15',NULL),(3993,NULL,'assingMorePeriods','While de empresa, year->2071, initial_month->1, contador->41','2018-06-14 20:50:15',NULL),(3994,NULL,'assingMorePeriods','While de empresa, year->2072, initial_month->1, contador->42','2018-06-14 20:50:15',NULL);
INSERT INTO `log_debug` VALUES (3995,NULL,'assingMorePeriods','While de empresa, year->2073, initial_month->1, contador->43','2018-06-14 20:50:15',NULL),(3996,NULL,'assingMorePeriods','While de empresa, year->2074, initial_month->1, contador->44','2018-06-14 20:50:15',NULL),(3997,NULL,'assingMorePeriods','While de empresa, year->2075, initial_month->1, contador->45','2018-06-14 20:50:15',NULL),(3998,NULL,'assingMorePeriods','While de empresa, year->2076, initial_month->1, contador->46','2018-06-14 20:50:15',NULL),(3999,NULL,'assingMorePeriods','While de empresa, year->2077, initial_month->1, contador->47','2018-06-14 20:50:15',NULL),(4000,NULL,'assingMorePeriods','While de empresa, year->2078, initial_month->1, contador->48','2018-06-14 20:50:15',NULL),(4001,NULL,'assingMorePeriods','While de empresa, year->2079, initial_month->1, contador->49','2018-06-14 20:50:15',NULL),(4002,NULL,'assingMorePeriods','While de empresa, year->2080, initial_month->1, contador->50','2018-06-14 20:50:15',NULL),(4003,NULL,'assingMorePeriods','While de empresa, year->2081, initial_month->1, contador->51','2018-06-14 20:50:15',NULL),(4004,NULL,'assingMorePeriods','While de empresa, year->2082, initial_month->1, contador->52','2018-06-14 20:50:15',NULL),(4005,NULL,'assingMorePeriods','While de empresa, year->2083, initial_month->1, contador->53','2018-06-14 20:50:15',NULL),(4006,NULL,'assingMorePeriods','While de empresa, year->2084, initial_month->1, contador->54','2018-06-14 20:50:15',NULL),(4007,NULL,'assingMorePeriods','While de empresa, year->2085, initial_month->1, contador->55','2018-06-14 20:50:15',NULL),(4008,NULL,'assingMorePeriods','While de empresa, year->2086, initial_month->1, contador->56','2018-06-14 20:50:15',NULL),(4009,NULL,'assingMorePeriods','While de empresa, year->2087, initial_month->1, contador->57','2018-06-14 20:50:15',NULL),(4010,NULL,'assingMorePeriods','While de empresa, year->2088, initial_month->1, contador->58','2018-06-14 20:50:15',NULL),(4011,NULL,'assingMorePeriods','While de empresa, year->2089, initial_month->1, contador->59','2018-06-14 20:50:15',NULL),(4012,NULL,'assingMorePeriods','While de empresa, year->2090, initial_month->1, contador->60','2018-06-14 20:50:15',NULL),(4013,NULL,'assingMorePeriods','While de empresa, year->2091, initial_month->1, contador->61','2018-06-14 20:50:15',NULL),(4014,NULL,'assingMorePeriods','While de empresa, year->2092, initial_month->1, contador->62','2018-06-14 20:50:15',NULL),(4015,NULL,'assingMorePeriods','While de empresa, year->2093, initial_month->1, contador->63','2018-06-14 20:50:15',NULL),(4016,NULL,'assingMorePeriods','While de empresa, year->2094, initial_month->1, contador->64','2018-06-14 20:50:15',NULL),(4017,NULL,'assingMorePeriods','While de empresa, year->2095, initial_month->1, contador->65','2018-06-14 20:50:15',NULL),(4018,NULL,'assingMorePeriods','While de empresa, year->2096, initial_month->1, contador->66','2018-06-14 20:50:15',NULL),(4019,NULL,'assingMorePeriods','While de empresa, year->2097, initial_month->1, contador->67','2018-06-14 20:50:15',NULL),(4020,NULL,'assingMorePeriods','While de empresa, year->2098, initial_month->1, contador->68','2018-06-14 20:50:15',NULL),(4021,NULL,'assingMorePeriods','While de empresa, year->2099, initial_month->1, contador->69','2018-06-14 20:50:15',NULL),(4022,NULL,'assingMorePeriods','While de empresa, year->2100, initial_month->1, contador->70','2018-06-14 20:50:15',NULL),(4023,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1990, periodo->2030-12','2018-06-14 20:50:15',NULL),(4024,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->13, contador->0','2018-06-14 20:50:15',NULL),(4025,NULL,'assingMorePeriods','While de empresa, year->2031, initial_month->13, contador->1','2018-06-14 20:50:15',NULL),(4026,NULL,'assingMorePeriods','While de empresa, year->2032, initial_month->1, contador->2','2018-06-14 20:50:15',NULL),(4027,NULL,'assingMorePeriods','While de empresa, year->2033, initial_month->1, contador->3','2018-06-14 20:50:15',NULL);
INSERT INTO `log_debug` VALUES (4028,NULL,'assingMorePeriods','While de empresa, year->2034, initial_month->1, contador->4','2018-06-14 20:50:15',NULL),(4029,NULL,'assingMorePeriods','While de empresa, year->2035, initial_month->1, contador->5','2018-06-14 20:50:15',NULL),(4030,NULL,'assingMorePeriods','While de empresa, year->2036, initial_month->1, contador->6','2018-06-14 20:50:15',NULL),(4031,NULL,'assingMorePeriods','While de empresa, year->2037, initial_month->1, contador->7','2018-06-14 20:50:15',NULL),(4032,NULL,'assingMorePeriods','While de empresa, year->2038, initial_month->1, contador->8','2018-06-14 20:50:15',NULL),(4033,NULL,'assingMorePeriods','While de empresa, year->2039, initial_month->1, contador->9','2018-06-14 20:50:15',NULL),(4034,NULL,'assingMorePeriods','While de empresa, year->2040, initial_month->1, contador->10','2018-06-14 20:50:15',NULL),(4035,NULL,'assingMorePeriods','While de empresa, year->2041, initial_month->1, contador->11','2018-06-14 20:50:15',NULL),(4036,NULL,'assingMorePeriods','While de empresa, year->2042, initial_month->1, contador->12','2018-06-14 20:50:15',NULL),(4037,NULL,'assingMorePeriods','While de empresa, year->2043, initial_month->1, contador->13','2018-06-14 20:50:15',NULL),(4038,NULL,'assingMorePeriods','While de empresa, year->2044, initial_month->1, contador->14','2018-06-14 20:50:15',NULL),(4039,NULL,'assingMorePeriods','While de empresa, year->2045, initial_month->1, contador->15','2018-06-14 20:50:15',NULL),(4040,NULL,'assingMorePeriods','While de empresa, year->2046, initial_month->1, contador->16','2018-06-14 20:50:15',NULL),(4041,NULL,'assingMorePeriods','While de empresa, year->2047, initial_month->1, contador->17','2018-06-14 20:50:15',NULL),(4042,NULL,'assingMorePeriods','While de empresa, year->2048, initial_month->1, contador->18','2018-06-14 20:50:15',NULL),(4043,NULL,'assingMorePeriods','While de empresa, year->2049, initial_month->1, contador->19','2018-06-14 20:50:15',NULL),(4044,NULL,'assingMorePeriods','While de empresa, year->2050, initial_month->1, contador->20','2018-06-14 20:50:15',NULL),(4045,NULL,'assingMorePeriods','While de empresa, year->2051, initial_month->1, contador->21','2018-06-14 20:50:15',NULL),(4046,NULL,'assingMorePeriods','While de empresa, year->2052, initial_month->1, contador->22','2018-06-14 20:50:15',NULL),(4047,NULL,'assingMorePeriods','While de empresa, year->2053, initial_month->1, contador->23','2018-06-14 20:50:15',NULL),(4048,NULL,'assingMorePeriods','While de empresa, year->2054, initial_month->1, contador->24','2018-06-14 20:50:15',NULL),(4049,NULL,'assingMorePeriods','While de empresa, year->2055, initial_month->1, contador->25','2018-06-14 20:50:15',NULL),(4050,NULL,'assingMorePeriods','While de empresa, year->2056, initial_month->1, contador->26','2018-06-14 20:50:15',NULL),(4051,NULL,'assingMorePeriods','While de empresa, year->2057, initial_month->1, contador->27','2018-06-14 20:50:15',NULL),(4052,NULL,'assingMorePeriods','While de empresa, year->2058, initial_month->1, contador->28','2018-06-14 20:50:15',NULL),(4053,NULL,'assingMorePeriods','While de empresa, year->2059, initial_month->1, contador->29','2018-06-14 20:50:15',NULL),(4054,NULL,'assingMorePeriods','While de empresa, year->2060, initial_month->1, contador->30','2018-06-14 20:50:15',NULL),(4055,NULL,'assingMorePeriods','While de empresa, year->2061, initial_month->1, contador->31','2018-06-14 20:50:15',NULL),(4056,NULL,'assingMorePeriods','While de empresa, year->2062, initial_month->1, contador->32','2018-06-14 20:50:15',NULL),(4057,NULL,'assingMorePeriods','While de empresa, year->2063, initial_month->1, contador->33','2018-06-14 20:50:15',NULL),(4058,NULL,'assingMorePeriods','While de empresa, year->2064, initial_month->1, contador->34','2018-06-14 20:50:15',NULL),(4059,NULL,'assingMorePeriods','While de empresa, year->2065, initial_month->1, contador->35','2018-06-14 20:50:15',NULL),(4060,NULL,'assingMorePeriods','While de empresa, year->2066, initial_month->1, contador->36','2018-06-14 20:50:15',NULL);
INSERT INTO `log_debug` VALUES (4061,NULL,'assingMorePeriods','While de empresa, year->2067, initial_month->1, contador->37','2018-06-14 20:50:15',NULL),(4062,NULL,'assingMorePeriods','While de empresa, year->2068, initial_month->1, contador->38','2018-06-14 20:50:15',NULL),(4063,NULL,'assingMorePeriods','While de empresa, year->2069, initial_month->1, contador->39','2018-06-14 20:50:15',NULL),(4064,NULL,'assingMorePeriods','While de empresa, year->2070, initial_month->1, contador->40','2018-06-14 20:50:15',NULL),(4065,NULL,'assingMorePeriods','While de empresa, year->2071, initial_month->1, contador->41','2018-06-14 20:50:15',NULL),(4066,NULL,'assingMorePeriods','While de empresa, year->2072, initial_month->1, contador->42','2018-06-14 20:50:15',NULL),(4067,NULL,'assingMorePeriods','While de empresa, year->2073, initial_month->1, contador->43','2018-06-14 20:50:15',NULL),(4068,NULL,'assingMorePeriods','While de empresa, year->2074, initial_month->1, contador->44','2018-06-14 20:50:15',NULL),(4069,NULL,'assingMorePeriods','While de empresa, year->2075, initial_month->1, contador->45','2018-06-14 20:50:15',NULL),(4070,NULL,'assingMorePeriods','While de empresa, year->2076, initial_month->1, contador->46','2018-06-14 20:50:15',NULL),(4071,NULL,'assingMorePeriods','While de empresa, year->2077, initial_month->1, contador->47','2018-06-14 20:50:15',NULL),(4072,NULL,'assingMorePeriods','While de empresa, year->2078, initial_month->1, contador->48','2018-06-14 20:50:15',NULL),(4073,NULL,'assingMorePeriods','While de empresa, year->2079, initial_month->1, contador->49','2018-06-14 20:50:15',NULL),(4074,NULL,'assingMorePeriods','While de empresa, year->2080, initial_month->1, contador->50','2018-06-14 20:50:15',NULL),(4075,NULL,'assingMorePeriods','While de empresa, year->2081, initial_month->1, contador->51','2018-06-14 20:50:15',NULL),(4076,NULL,'assingMorePeriods','While de empresa, year->2082, initial_month->1, contador->52','2018-06-14 20:50:15',NULL),(4077,NULL,'assingMorePeriods','While de empresa, year->2083, initial_month->1, contador->53','2018-06-14 20:50:15',NULL),(4078,NULL,'assingMorePeriods','While de empresa, year->2084, initial_month->1, contador->54','2018-06-14 20:50:15',NULL),(4079,NULL,'assingMorePeriods','While de empresa, year->2085, initial_month->1, contador->55','2018-06-14 20:50:15',NULL),(4080,NULL,'assingMorePeriods','While de empresa, year->2086, initial_month->1, contador->56','2018-06-14 20:50:15',NULL),(4081,NULL,'assingMorePeriods','While de empresa, year->2087, initial_month->1, contador->57','2018-06-14 20:50:15',NULL),(4082,NULL,'assingMorePeriods','While de empresa, year->2088, initial_month->1, contador->58','2018-06-14 20:50:15',NULL),(4083,NULL,'assingMorePeriods','While de empresa, year->2089, initial_month->1, contador->59','2018-06-14 20:50:15',NULL),(4084,NULL,'assingMorePeriods','While de empresa, year->2090, initial_month->1, contador->60','2018-06-14 20:50:15',NULL),(4085,NULL,'assingMorePeriods','While de empresa, year->2091, initial_month->1, contador->61','2018-06-14 20:50:15',NULL),(4086,NULL,'assingMorePeriods','While de empresa, year->2092, initial_month->1, contador->62','2018-06-14 20:50:15',NULL),(4087,NULL,'assingMorePeriods','While de empresa, year->2093, initial_month->1, contador->63','2018-06-14 20:50:15',NULL),(4088,NULL,'assingMorePeriods','While de empresa, year->2094, initial_month->1, contador->64','2018-06-14 20:50:15',NULL),(4089,NULL,'assingMorePeriods','While de empresa, year->2095, initial_month->1, contador->65','2018-06-14 20:50:15',NULL),(4090,NULL,'assingMorePeriods','While de empresa, year->2096, initial_month->1, contador->66','2018-06-14 20:50:15',NULL),(4091,NULL,'assingMorePeriods','While de empresa, year->2097, initial_month->1, contador->67','2018-06-14 20:50:15',NULL),(4092,NULL,'assingMorePeriods','While de empresa, year->2098, initial_month->1, contador->68','2018-06-14 20:50:15',NULL),(4093,NULL,'assingMorePeriods','While de empresa, year->2099, initial_month->1, contador->69','2018-06-14 20:50:15',NULL);
INSERT INTO `log_debug` VALUES (4094,NULL,'assingMorePeriods','While de empresa, year->2100, initial_month->1, contador->70','2018-06-14 20:50:15',NULL),(4095,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1991, periodo->2030-12','2018-06-14 20:50:15',NULL),(4096,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->13, contador->0','2018-06-14 20:50:15',NULL),(4097,NULL,'assingMorePeriods','While de empresa, year->2031, initial_month->13, contador->1','2018-06-14 20:50:15',NULL),(4098,NULL,'assingMorePeriods','While de empresa, year->2032, initial_month->1, contador->2','2018-06-14 20:50:15',NULL),(4099,NULL,'assingMorePeriods','While de empresa, year->2033, initial_month->1, contador->3','2018-06-14 20:50:15',NULL),(4100,NULL,'assingMorePeriods','While de empresa, year->2034, initial_month->1, contador->4','2018-06-14 20:50:15',NULL),(4101,NULL,'assingMorePeriods','While de empresa, year->2035, initial_month->1, contador->5','2018-06-14 20:50:15',NULL),(4102,NULL,'assingMorePeriods','While de empresa, year->2036, initial_month->1, contador->6','2018-06-14 20:50:15',NULL),(4103,NULL,'assingMorePeriods','While de empresa, year->2037, initial_month->1, contador->7','2018-06-14 20:50:15',NULL),(4104,NULL,'assingMorePeriods','While de empresa, year->2038, initial_month->1, contador->8','2018-06-14 20:50:15',NULL),(4105,NULL,'assingMorePeriods','While de empresa, year->2039, initial_month->1, contador->9','2018-06-14 20:50:15',NULL),(4106,NULL,'assingMorePeriods','While de empresa, year->2040, initial_month->1, contador->10','2018-06-14 20:50:15',NULL),(4107,NULL,'assingMorePeriods','While de empresa, year->2041, initial_month->1, contador->11','2018-06-14 20:50:15',NULL),(4108,NULL,'assingMorePeriods','While de empresa, year->2042, initial_month->1, contador->12','2018-06-14 20:50:15',NULL),(4109,NULL,'assingMorePeriods','While de empresa, year->2043, initial_month->1, contador->13','2018-06-14 20:50:15',NULL),(4110,NULL,'assingMorePeriods','While de empresa, year->2044, initial_month->1, contador->14','2018-06-14 20:50:15',NULL),(4111,NULL,'assingMorePeriods','While de empresa, year->2045, initial_month->1, contador->15','2018-06-14 20:50:15',NULL),(4112,NULL,'assingMorePeriods','While de empresa, year->2046, initial_month->1, contador->16','2018-06-14 20:50:15',NULL),(4113,NULL,'assingMorePeriods','While de empresa, year->2047, initial_month->1, contador->17','2018-06-14 20:50:15',NULL),(4114,NULL,'assingMorePeriods','While de empresa, year->2048, initial_month->1, contador->18','2018-06-14 20:50:15',NULL),(4115,NULL,'assingMorePeriods','While de empresa, year->2049, initial_month->1, contador->19','2018-06-14 20:50:15',NULL),(4116,NULL,'assingMorePeriods','While de empresa, year->2050, initial_month->1, contador->20','2018-06-14 20:50:15',NULL),(4117,NULL,'assingMorePeriods','While de empresa, year->2051, initial_month->1, contador->21','2018-06-14 20:50:15',NULL),(4118,NULL,'assingMorePeriods','While de empresa, year->2052, initial_month->1, contador->22','2018-06-14 20:50:15',NULL),(4119,NULL,'assingMorePeriods','While de empresa, year->2053, initial_month->1, contador->23','2018-06-14 20:50:15',NULL),(4120,NULL,'assingMorePeriods','While de empresa, year->2054, initial_month->1, contador->24','2018-06-14 20:50:15',NULL),(4121,NULL,'assingMorePeriods','While de empresa, year->2055, initial_month->1, contador->25','2018-06-14 20:50:15',NULL),(4122,NULL,'assingMorePeriods','While de empresa, year->2056, initial_month->1, contador->26','2018-06-14 20:50:15',NULL),(4123,NULL,'assingMorePeriods','While de empresa, year->2057, initial_month->1, contador->27','2018-06-14 20:50:15',NULL),(4124,NULL,'assingMorePeriods','While de empresa, year->2058, initial_month->1, contador->28','2018-06-14 20:50:15',NULL),(4125,NULL,'assingMorePeriods','While de empresa, year->2059, initial_month->1, contador->29','2018-06-14 20:50:15',NULL),(4126,NULL,'assingMorePeriods','While de empresa, year->2060, initial_month->1, contador->30','2018-06-14 20:50:15',NULL);
INSERT INTO `log_debug` VALUES (4127,NULL,'assingMorePeriods','While de empresa, year->2061, initial_month->1, contador->31','2018-06-14 20:50:15',NULL),(4128,NULL,'assingMorePeriods','While de empresa, year->2062, initial_month->1, contador->32','2018-06-14 20:50:15',NULL),(4129,NULL,'assingMorePeriods','While de empresa, year->2063, initial_month->1, contador->33','2018-06-14 20:50:15',NULL),(4130,NULL,'assingMorePeriods','While de empresa, year->2064, initial_month->1, contador->34','2018-06-14 20:50:15',NULL),(4131,NULL,'assingMorePeriods','While de empresa, year->2065, initial_month->1, contador->35','2018-06-14 20:50:15',NULL),(4132,NULL,'assingMorePeriods','While de empresa, year->2066, initial_month->1, contador->36','2018-06-14 20:50:15',NULL),(4133,NULL,'assingMorePeriods','While de empresa, year->2067, initial_month->1, contador->37','2018-06-14 20:50:15',NULL),(4134,NULL,'assingMorePeriods','While de empresa, year->2068, initial_month->1, contador->38','2018-06-14 20:50:15',NULL),(4135,NULL,'assingMorePeriods','While de empresa, year->2069, initial_month->1, contador->39','2018-06-14 20:50:15',NULL),(4136,NULL,'assingMorePeriods','While de empresa, year->2070, initial_month->1, contador->40','2018-06-14 20:50:15',NULL),(4137,NULL,'assingMorePeriods','While de empresa, year->2071, initial_month->1, contador->41','2018-06-14 20:50:15',NULL),(4138,NULL,'assingMorePeriods','While de empresa, year->2072, initial_month->1, contador->42','2018-06-14 20:50:15',NULL),(4139,NULL,'assingMorePeriods','While de empresa, year->2073, initial_month->1, contador->43','2018-06-14 20:50:15',NULL),(4140,NULL,'assingMorePeriods','While de empresa, year->2074, initial_month->1, contador->44','2018-06-14 20:50:15',NULL),(4141,NULL,'assingMorePeriods','While de empresa, year->2075, initial_month->1, contador->45','2018-06-14 20:50:15',NULL),(4142,NULL,'assingMorePeriods','While de empresa, year->2076, initial_month->1, contador->46','2018-06-14 20:50:15',NULL),(4143,NULL,'assingMorePeriods','While de empresa, year->2077, initial_month->1, contador->47','2018-06-14 20:50:15',NULL),(4144,NULL,'assingMorePeriods','While de empresa, year->2078, initial_month->1, contador->48','2018-06-14 20:50:15',NULL),(4145,NULL,'assingMorePeriods','While de empresa, year->2079, initial_month->1, contador->49','2018-06-14 20:50:15',NULL),(4146,NULL,'assingMorePeriods','While de empresa, year->2080, initial_month->1, contador->50','2018-06-14 20:50:15',NULL),(4147,NULL,'assingMorePeriods','While de empresa, year->2081, initial_month->1, contador->51','2018-06-14 20:50:15',NULL),(4148,NULL,'assingMorePeriods','While de empresa, year->2082, initial_month->1, contador->52','2018-06-14 20:50:15',NULL),(4149,NULL,'assingMorePeriods','While de empresa, year->2083, initial_month->1, contador->53','2018-06-14 20:50:15',NULL),(4150,NULL,'assingMorePeriods','While de empresa, year->2084, initial_month->1, contador->54','2018-06-14 20:50:15',NULL),(4151,NULL,'assingMorePeriods','While de empresa, year->2085, initial_month->1, contador->55','2018-06-14 20:50:15',NULL),(4152,NULL,'assingMorePeriods','While de empresa, year->2086, initial_month->1, contador->56','2018-06-14 20:50:15',NULL),(4153,NULL,'assingMorePeriods','While de empresa, year->2087, initial_month->1, contador->57','2018-06-14 20:50:15',NULL),(4154,NULL,'assingMorePeriods','While de empresa, year->2088, initial_month->1, contador->58','2018-06-14 20:50:15',NULL),(4155,NULL,'assingMorePeriods','While de empresa, year->2089, initial_month->1, contador->59','2018-06-14 20:50:15',NULL),(4156,NULL,'assingMorePeriods','While de empresa, year->2090, initial_month->1, contador->60','2018-06-14 20:50:15',NULL),(4157,NULL,'assingMorePeriods','While de empresa, year->2091, initial_month->1, contador->61','2018-06-14 20:50:15',NULL),(4158,NULL,'assingMorePeriods','While de empresa, year->2092, initial_month->1, contador->62','2018-06-14 20:50:15',NULL),(4159,NULL,'assingMorePeriods','While de empresa, year->2093, initial_month->1, contador->63','2018-06-14 20:50:15',NULL);
INSERT INTO `log_debug` VALUES (4160,NULL,'assingMorePeriods','While de empresa, year->2094, initial_month->1, contador->64','2018-06-14 20:50:15',NULL),(4161,NULL,'assingMorePeriods','While de empresa, year->2095, initial_month->1, contador->65','2018-06-14 20:50:15',NULL),(4162,NULL,'assingMorePeriods','While de empresa, year->2096, initial_month->1, contador->66','2018-06-14 20:50:15',NULL),(4163,NULL,'assingMorePeriods','While de empresa, year->2097, initial_month->1, contador->67','2018-06-14 20:50:15',NULL),(4164,NULL,'assingMorePeriods','While de empresa, year->2098, initial_month->1, contador->68','2018-06-14 20:50:15',NULL),(4165,NULL,'assingMorePeriods','While de empresa, year->2099, initial_month->1, contador->69','2018-06-14 20:50:15',NULL),(4166,NULL,'assingMorePeriods','While de empresa, year->2100, initial_month->1, contador->70','2018-06-14 20:50:15',NULL),(4167,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1992, periodo->2030-12','2018-06-14 20:50:15',NULL),(4168,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->13, contador->0','2018-06-14 20:50:15',NULL),(4169,NULL,'assingMorePeriods','While de empresa, year->2031, initial_month->13, contador->1','2018-06-14 20:50:15',NULL),(4170,NULL,'assingMorePeriods','While de empresa, year->2032, initial_month->1, contador->2','2018-06-14 20:50:15',NULL),(4171,NULL,'assingMorePeriods','While de empresa, year->2033, initial_month->1, contador->3','2018-06-14 20:50:15',NULL),(4172,NULL,'assingMorePeriods','While de empresa, year->2034, initial_month->1, contador->4','2018-06-14 20:50:15',NULL),(4173,NULL,'assingMorePeriods','While de empresa, year->2035, initial_month->1, contador->5','2018-06-14 20:50:15',NULL),(4174,NULL,'assingMorePeriods','While de empresa, year->2036, initial_month->1, contador->6','2018-06-14 20:50:15',NULL),(4175,NULL,'assingMorePeriods','While de empresa, year->2037, initial_month->1, contador->7','2018-06-14 20:50:15',NULL),(4176,NULL,'assingMorePeriods','While de empresa, year->2038, initial_month->1, contador->8','2018-06-14 20:50:15',NULL),(4177,NULL,'assingMorePeriods','While de empresa, year->2039, initial_month->1, contador->9','2018-06-14 20:50:15',NULL),(4178,NULL,'assingMorePeriods','While de empresa, year->2040, initial_month->1, contador->10','2018-06-14 20:50:15',NULL),(4179,NULL,'assingMorePeriods','While de empresa, year->2041, initial_month->1, contador->11','2018-06-14 20:50:15',NULL),(4180,NULL,'assingMorePeriods','While de empresa, year->2042, initial_month->1, contador->12','2018-06-14 20:50:15',NULL),(4181,NULL,'assingMorePeriods','While de empresa, year->2043, initial_month->1, contador->13','2018-06-14 20:50:15',NULL),(4182,NULL,'assingMorePeriods','While de empresa, year->2044, initial_month->1, contador->14','2018-06-14 20:50:15',NULL),(4183,NULL,'assingMorePeriods','While de empresa, year->2045, initial_month->1, contador->15','2018-06-14 20:50:15',NULL),(4184,NULL,'assingMorePeriods','While de empresa, year->2046, initial_month->1, contador->16','2018-06-14 20:50:15',NULL),(4185,NULL,'assingMorePeriods','While de empresa, year->2047, initial_month->1, contador->17','2018-06-14 20:50:15',NULL),(4186,NULL,'assingMorePeriods','While de empresa, year->2048, initial_month->1, contador->18','2018-06-14 20:50:15',NULL),(4187,NULL,'assingMorePeriods','While de empresa, year->2049, initial_month->1, contador->19','2018-06-14 20:50:15',NULL),(4188,NULL,'assingMorePeriods','While de empresa, year->2050, initial_month->1, contador->20','2018-06-14 20:50:15',NULL),(4189,NULL,'assingMorePeriods','While de empresa, year->2051, initial_month->1, contador->21','2018-06-14 20:50:15',NULL),(4190,NULL,'assingMorePeriods','While de empresa, year->2052, initial_month->1, contador->22','2018-06-14 20:50:15',NULL),(4191,NULL,'assingMorePeriods','While de empresa, year->2053, initial_month->1, contador->23','2018-06-14 20:50:15',NULL),(4192,NULL,'assingMorePeriods','While de empresa, year->2054, initial_month->1, contador->24','2018-06-14 20:50:15',NULL);
INSERT INTO `log_debug` VALUES (4193,NULL,'assingMorePeriods','While de empresa, year->2055, initial_month->1, contador->25','2018-06-14 20:50:15',NULL),(4194,NULL,'assingMorePeriods','While de empresa, year->2056, initial_month->1, contador->26','2018-06-14 20:50:15',NULL),(4195,NULL,'assingMorePeriods','While de empresa, year->2057, initial_month->1, contador->27','2018-06-14 20:50:15',NULL),(4196,NULL,'assingMorePeriods','While de empresa, year->2058, initial_month->1, contador->28','2018-06-14 20:50:15',NULL),(4197,NULL,'assingMorePeriods','While de empresa, year->2059, initial_month->1, contador->29','2018-06-14 20:50:15',NULL),(4198,NULL,'assingMorePeriods','While de empresa, year->2060, initial_month->1, contador->30','2018-06-14 20:50:15',NULL),(4199,NULL,'assingMorePeriods','While de empresa, year->2061, initial_month->1, contador->31','2018-06-14 20:50:15',NULL),(4200,NULL,'assingMorePeriods','While de empresa, year->2062, initial_month->1, contador->32','2018-06-14 20:50:15',NULL),(4201,NULL,'assingMorePeriods','While de empresa, year->2063, initial_month->1, contador->33','2018-06-14 20:50:15',NULL),(4202,NULL,'assingMorePeriods','While de empresa, year->2064, initial_month->1, contador->34','2018-06-14 20:50:15',NULL),(4203,NULL,'assingMorePeriods','While de empresa, year->2065, initial_month->1, contador->35','2018-06-14 20:50:15',NULL),(4204,NULL,'assingMorePeriods','While de empresa, year->2066, initial_month->1, contador->36','2018-06-14 20:50:15',NULL),(4205,NULL,'assingMorePeriods','While de empresa, year->2067, initial_month->1, contador->37','2018-06-14 20:50:15',NULL),(4206,NULL,'assingMorePeriods','While de empresa, year->2068, initial_month->1, contador->38','2018-06-14 20:50:15',NULL),(4207,NULL,'assingMorePeriods','While de empresa, year->2069, initial_month->1, contador->39','2018-06-14 20:50:15',NULL),(4208,NULL,'assingMorePeriods','While de empresa, year->2070, initial_month->1, contador->40','2018-06-14 20:50:15',NULL),(4209,NULL,'assingMorePeriods','While de empresa, year->2071, initial_month->1, contador->41','2018-06-14 20:50:15',NULL),(4210,NULL,'assingMorePeriods','While de empresa, year->2072, initial_month->1, contador->42','2018-06-14 20:50:15',NULL),(4211,NULL,'assingMorePeriods','While de empresa, year->2073, initial_month->1, contador->43','2018-06-14 20:50:15',NULL),(4212,NULL,'assingMorePeriods','While de empresa, year->2074, initial_month->1, contador->44','2018-06-14 20:50:15',NULL),(4213,NULL,'assingMorePeriods','While de empresa, year->2075, initial_month->1, contador->45','2018-06-14 20:50:15',NULL),(4214,NULL,'assingMorePeriods','While de empresa, year->2076, initial_month->1, contador->46','2018-06-14 20:50:15',NULL),(4215,NULL,'assingMorePeriods','While de empresa, year->2077, initial_month->1, contador->47','2018-06-14 20:50:15',NULL),(4216,NULL,'assingMorePeriods','While de empresa, year->2078, initial_month->1, contador->48','2018-06-14 20:50:15',NULL),(4217,NULL,'assingMorePeriods','While de empresa, year->2079, initial_month->1, contador->49','2018-06-14 20:50:15',NULL),(4218,NULL,'assingMorePeriods','While de empresa, year->2080, initial_month->1, contador->50','2018-06-14 20:50:15',NULL),(4219,NULL,'assingMorePeriods','While de empresa, year->2081, initial_month->1, contador->51','2018-06-14 20:50:15',NULL),(4220,NULL,'assingMorePeriods','While de empresa, year->2082, initial_month->1, contador->52','2018-06-14 20:50:15',NULL),(4221,NULL,'assingMorePeriods','While de empresa, year->2083, initial_month->1, contador->53','2018-06-14 20:50:15',NULL),(4222,NULL,'assingMorePeriods','While de empresa, year->2084, initial_month->1, contador->54','2018-06-14 20:50:15',NULL),(4223,NULL,'assingMorePeriods','While de empresa, year->2085, initial_month->1, contador->55','2018-06-14 20:50:15',NULL),(4224,NULL,'assingMorePeriods','While de empresa, year->2086, initial_month->1, contador->56','2018-06-14 20:50:15',NULL),(4225,NULL,'assingMorePeriods','While de empresa, year->2087, initial_month->1, contador->57','2018-06-14 20:50:15',NULL);
INSERT INTO `log_debug` VALUES (4226,NULL,'assingMorePeriods','While de empresa, year->2088, initial_month->1, contador->58','2018-06-14 20:50:15',NULL),(4227,NULL,'assingMorePeriods','While de empresa, year->2089, initial_month->1, contador->59','2018-06-14 20:50:15',NULL),(4228,NULL,'assingMorePeriods','While de empresa, year->2090, initial_month->1, contador->60','2018-06-14 20:50:15',NULL),(4229,NULL,'assingMorePeriods','While de empresa, year->2091, initial_month->1, contador->61','2018-06-14 20:50:15',NULL),(4230,NULL,'assingMorePeriods','While de empresa, year->2092, initial_month->1, contador->62','2018-06-14 20:50:15',NULL),(4231,NULL,'assingMorePeriods','While de empresa, year->2093, initial_month->1, contador->63','2018-06-14 20:50:15',NULL),(4232,NULL,'assingMorePeriods','While de empresa, year->2094, initial_month->1, contador->64','2018-06-14 20:50:15',NULL),(4233,NULL,'assingMorePeriods','While de empresa, year->2095, initial_month->1, contador->65','2018-06-14 20:50:15',NULL),(4234,NULL,'assingMorePeriods','While de empresa, year->2096, initial_month->1, contador->66','2018-06-14 20:50:15',NULL),(4235,NULL,'assingMorePeriods','While de empresa, year->2097, initial_month->1, contador->67','2018-06-14 20:50:15',NULL),(4236,NULL,'assingMorePeriods','While de empresa, year->2098, initial_month->1, contador->68','2018-06-14 20:50:15',NULL),(4237,NULL,'assingMorePeriods','While de empresa, year->2099, initial_month->1, contador->69','2018-06-14 20:50:15',NULL),(4238,NULL,'assingMorePeriods','While de empresa, year->2100, initial_month->1, contador->70','2018-06-14 20:50:15',NULL),(4239,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1993, periodo->2030-12','2018-06-14 20:50:15',NULL),(4240,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->13, contador->0','2018-06-14 20:50:15',NULL),(4241,NULL,'assingMorePeriods','While de empresa, year->2031, initial_month->13, contador->1','2018-06-14 20:50:15',NULL),(4242,NULL,'assingMorePeriods','While de empresa, year->2032, initial_month->1, contador->2','2018-06-14 20:50:15',NULL),(4243,NULL,'assingMorePeriods','While de empresa, year->2033, initial_month->1, contador->3','2018-06-14 20:50:15',NULL),(4244,NULL,'assingMorePeriods','While de empresa, year->2034, initial_month->1, contador->4','2018-06-14 20:50:15',NULL),(4245,NULL,'assingMorePeriods','While de empresa, year->2035, initial_month->1, contador->5','2018-06-14 20:50:15',NULL),(4246,NULL,'assingMorePeriods','While de empresa, year->2036, initial_month->1, contador->6','2018-06-14 20:50:15',NULL),(4247,NULL,'assingMorePeriods','While de empresa, year->2037, initial_month->1, contador->7','2018-06-14 20:50:15',NULL),(4248,NULL,'assingMorePeriods','While de empresa, year->2038, initial_month->1, contador->8','2018-06-14 20:50:15',NULL),(4249,NULL,'assingMorePeriods','While de empresa, year->2039, initial_month->1, contador->9','2018-06-14 20:50:15',NULL),(4250,NULL,'assingMorePeriods','While de empresa, year->2040, initial_month->1, contador->10','2018-06-14 20:50:15',NULL),(4251,NULL,'assingMorePeriods','While de empresa, year->2041, initial_month->1, contador->11','2018-06-14 20:50:15',NULL),(4252,NULL,'assingMorePeriods','While de empresa, year->2042, initial_month->1, contador->12','2018-06-14 20:50:15',NULL),(4253,NULL,'assingMorePeriods','While de empresa, year->2043, initial_month->1, contador->13','2018-06-14 20:50:15',NULL),(4254,NULL,'assingMorePeriods','While de empresa, year->2044, initial_month->1, contador->14','2018-06-14 20:50:15',NULL),(4255,NULL,'assingMorePeriods','While de empresa, year->2045, initial_month->1, contador->15','2018-06-14 20:50:15',NULL),(4256,NULL,'assingMorePeriods','While de empresa, year->2046, initial_month->1, contador->16','2018-06-14 20:50:15',NULL),(4257,NULL,'assingMorePeriods','While de empresa, year->2047, initial_month->1, contador->17','2018-06-14 20:50:15',NULL),(4258,NULL,'assingMorePeriods','While de empresa, year->2048, initial_month->1, contador->18','2018-06-14 20:50:15',NULL);
INSERT INTO `log_debug` VALUES (4259,NULL,'assingMorePeriods','While de empresa, year->2049, initial_month->1, contador->19','2018-06-14 20:50:15',NULL),(4260,NULL,'assingMorePeriods','While de empresa, year->2050, initial_month->1, contador->20','2018-06-14 20:50:15',NULL),(4261,NULL,'assingMorePeriods','While de empresa, year->2051, initial_month->1, contador->21','2018-06-14 20:50:15',NULL),(4262,NULL,'assingMorePeriods','While de empresa, year->2052, initial_month->1, contador->22','2018-06-14 20:50:15',NULL),(4263,NULL,'assingMorePeriods','While de empresa, year->2053, initial_month->1, contador->23','2018-06-14 20:50:15',NULL),(4264,NULL,'assingMorePeriods','While de empresa, year->2054, initial_month->1, contador->24','2018-06-14 20:50:15',NULL),(4265,NULL,'assingMorePeriods','While de empresa, year->2055, initial_month->1, contador->25','2018-06-14 20:50:15',NULL),(4266,NULL,'assingMorePeriods','While de empresa, year->2056, initial_month->1, contador->26','2018-06-14 20:50:15',NULL),(4267,NULL,'assingMorePeriods','While de empresa, year->2057, initial_month->1, contador->27','2018-06-14 20:50:15',NULL),(4268,NULL,'assingMorePeriods','While de empresa, year->2058, initial_month->1, contador->28','2018-06-14 20:50:15',NULL),(4269,NULL,'assingMorePeriods','While de empresa, year->2059, initial_month->1, contador->29','2018-06-14 20:50:15',NULL),(4270,NULL,'assingMorePeriods','While de empresa, year->2060, initial_month->1, contador->30','2018-06-14 20:50:15',NULL),(4271,NULL,'assingMorePeriods','While de empresa, year->2061, initial_month->1, contador->31','2018-06-14 20:50:15',NULL),(4272,NULL,'assingMorePeriods','While de empresa, year->2062, initial_month->1, contador->32','2018-06-14 20:50:15',NULL),(4273,NULL,'assingMorePeriods','While de empresa, year->2063, initial_month->1, contador->33','2018-06-14 20:50:15',NULL),(4274,NULL,'assingMorePeriods','While de empresa, year->2064, initial_month->1, contador->34','2018-06-14 20:50:15',NULL),(4275,NULL,'assingMorePeriods','While de empresa, year->2065, initial_month->1, contador->35','2018-06-14 20:50:15',NULL),(4276,NULL,'assingMorePeriods','While de empresa, year->2066, initial_month->1, contador->36','2018-06-14 20:50:15',NULL),(4277,NULL,'assingMorePeriods','While de empresa, year->2067, initial_month->1, contador->37','2018-06-14 20:50:15',NULL),(4278,NULL,'assingMorePeriods','While de empresa, year->2068, initial_month->1, contador->38','2018-06-14 20:50:15',NULL),(4279,NULL,'assingMorePeriods','While de empresa, year->2069, initial_month->1, contador->39','2018-06-14 20:50:15',NULL),(4280,NULL,'assingMorePeriods','While de empresa, year->2070, initial_month->1, contador->40','2018-06-14 20:50:15',NULL),(4281,NULL,'assingMorePeriods','While de empresa, year->2071, initial_month->1, contador->41','2018-06-14 20:50:15',NULL),(4282,NULL,'assingMorePeriods','While de empresa, year->2072, initial_month->1, contador->42','2018-06-14 20:50:15',NULL),(4283,NULL,'assingMorePeriods','While de empresa, year->2073, initial_month->1, contador->43','2018-06-14 20:50:15',NULL),(4284,NULL,'assingMorePeriods','While de empresa, year->2074, initial_month->1, contador->44','2018-06-14 20:50:15',NULL),(4285,NULL,'assingMorePeriods','While de empresa, year->2075, initial_month->1, contador->45','2018-06-14 20:50:15',NULL),(4286,NULL,'assingMorePeriods','While de empresa, year->2076, initial_month->1, contador->46','2018-06-14 20:50:15',NULL),(4287,NULL,'assingMorePeriods','While de empresa, year->2077, initial_month->1, contador->47','2018-06-14 20:50:15',NULL),(4288,NULL,'assingMorePeriods','While de empresa, year->2078, initial_month->1, contador->48','2018-06-14 20:50:15',NULL),(4289,NULL,'assingMorePeriods','While de empresa, year->2079, initial_month->1, contador->49','2018-06-14 20:50:15',NULL),(4290,NULL,'assingMorePeriods','While de empresa, year->2080, initial_month->1, contador->50','2018-06-14 20:50:15',NULL),(4291,NULL,'assingMorePeriods','While de empresa, year->2081, initial_month->1, contador->51','2018-06-14 20:50:15',NULL);
INSERT INTO `log_debug` VALUES (4292,NULL,'assingMorePeriods','While de empresa, year->2082, initial_month->1, contador->52','2018-06-14 20:50:15',NULL),(4293,NULL,'assingMorePeriods','While de empresa, year->2083, initial_month->1, contador->53','2018-06-14 20:50:15',NULL),(4294,NULL,'assingMorePeriods','While de empresa, year->2084, initial_month->1, contador->54','2018-06-14 20:50:15',NULL),(4295,NULL,'assingMorePeriods','While de empresa, year->2085, initial_month->1, contador->55','2018-06-14 20:50:15',NULL),(4296,NULL,'assingMorePeriods','While de empresa, year->2086, initial_month->1, contador->56','2018-06-14 20:50:15',NULL),(4297,NULL,'assingMorePeriods','While de empresa, year->2087, initial_month->1, contador->57','2018-06-14 20:50:15',NULL),(4298,NULL,'assingMorePeriods','While de empresa, year->2088, initial_month->1, contador->58','2018-06-14 20:50:15',NULL),(4299,NULL,'assingMorePeriods','While de empresa, year->2089, initial_month->1, contador->59','2018-06-14 20:50:15',NULL),(4300,NULL,'assingMorePeriods','While de empresa, year->2090, initial_month->1, contador->60','2018-06-14 20:50:15',NULL),(4301,NULL,'assingMorePeriods','While de empresa, year->2091, initial_month->1, contador->61','2018-06-14 20:50:15',NULL),(4302,NULL,'assingMorePeriods','While de empresa, year->2092, initial_month->1, contador->62','2018-06-14 20:50:15',NULL),(4303,NULL,'assingMorePeriods','While de empresa, year->2093, initial_month->1, contador->63','2018-06-14 20:50:15',NULL),(4304,NULL,'assingMorePeriods','While de empresa, year->2094, initial_month->1, contador->64','2018-06-14 20:50:15',NULL),(4305,NULL,'assingMorePeriods','While de empresa, year->2095, initial_month->1, contador->65','2018-06-14 20:50:15',NULL),(4306,NULL,'assingMorePeriods','While de empresa, year->2096, initial_month->1, contador->66','2018-06-14 20:50:15',NULL),(4307,NULL,'assingMorePeriods','While de empresa, year->2097, initial_month->1, contador->67','2018-06-14 20:50:15',NULL),(4308,NULL,'assingMorePeriods','While de empresa, year->2098, initial_month->1, contador->68','2018-06-14 20:50:15',NULL),(4309,NULL,'assingMorePeriods','While de empresa, year->2099, initial_month->1, contador->69','2018-06-14 20:50:15',NULL),(4310,NULL,'assingMorePeriods','While de empresa, year->2100, initial_month->1, contador->70','2018-06-14 20:50:15',NULL),(4311,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1994, periodo->2030-12','2018-06-14 20:50:15',NULL),(4312,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->13, contador->0','2018-06-14 20:50:15',NULL),(4313,NULL,'assingMorePeriods','While de empresa, year->2031, initial_month->13, contador->1','2018-06-14 20:50:15',NULL),(4314,NULL,'assingMorePeriods','While de empresa, year->2032, initial_month->1, contador->2','2018-06-14 20:50:15',NULL),(4315,NULL,'assingMorePeriods','While de empresa, year->2033, initial_month->1, contador->3','2018-06-14 20:50:15',NULL),(4316,NULL,'assingMorePeriods','While de empresa, year->2034, initial_month->1, contador->4','2018-06-14 20:50:15',NULL),(4317,NULL,'assingMorePeriods','While de empresa, year->2035, initial_month->1, contador->5','2018-06-14 20:50:15',NULL),(4318,NULL,'assingMorePeriods','While de empresa, year->2036, initial_month->1, contador->6','2018-06-14 20:50:15',NULL),(4319,NULL,'assingMorePeriods','While de empresa, year->2037, initial_month->1, contador->7','2018-06-14 20:50:15',NULL),(4320,NULL,'assingMorePeriods','While de empresa, year->2038, initial_month->1, contador->8','2018-06-14 20:50:15',NULL),(4321,NULL,'assingMorePeriods','While de empresa, year->2039, initial_month->1, contador->9','2018-06-14 20:50:15',NULL),(4322,NULL,'assingMorePeriods','While de empresa, year->2040, initial_month->1, contador->10','2018-06-14 20:50:15',NULL),(4323,NULL,'assingMorePeriods','While de empresa, year->2041, initial_month->1, contador->11','2018-06-14 20:50:15',NULL),(4324,NULL,'assingMorePeriods','While de empresa, year->2042, initial_month->1, contador->12','2018-06-14 20:50:15',NULL);
INSERT INTO `log_debug` VALUES (4325,NULL,'assingMorePeriods','While de empresa, year->2043, initial_month->1, contador->13','2018-06-14 20:50:15',NULL),(4326,NULL,'assingMorePeriods','While de empresa, year->2044, initial_month->1, contador->14','2018-06-14 20:50:15',NULL),(4327,NULL,'assingMorePeriods','While de empresa, year->2045, initial_month->1, contador->15','2018-06-14 20:50:15',NULL),(4328,NULL,'assingMorePeriods','While de empresa, year->2046, initial_month->1, contador->16','2018-06-14 20:50:15',NULL),(4329,NULL,'assingMorePeriods','While de empresa, year->2047, initial_month->1, contador->17','2018-06-14 20:50:15',NULL),(4330,NULL,'assingMorePeriods','While de empresa, year->2048, initial_month->1, contador->18','2018-06-14 20:50:15',NULL),(4331,NULL,'assingMorePeriods','While de empresa, year->2049, initial_month->1, contador->19','2018-06-14 20:50:15',NULL),(4332,NULL,'assingMorePeriods','While de empresa, year->2050, initial_month->1, contador->20','2018-06-14 20:50:15',NULL),(4333,NULL,'assingMorePeriods','While de empresa, year->2051, initial_month->1, contador->21','2018-06-14 20:50:15',NULL),(4334,NULL,'assingMorePeriods','While de empresa, year->2052, initial_month->1, contador->22','2018-06-14 20:50:15',NULL),(4335,NULL,'assingMorePeriods','While de empresa, year->2053, initial_month->1, contador->23','2018-06-14 20:50:15',NULL),(4336,NULL,'assingMorePeriods','While de empresa, year->2054, initial_month->1, contador->24','2018-06-14 20:50:15',NULL),(4337,NULL,'assingMorePeriods','While de empresa, year->2055, initial_month->1, contador->25','2018-06-14 20:50:15',NULL),(4338,NULL,'assingMorePeriods','While de empresa, year->2056, initial_month->1, contador->26','2018-06-14 20:50:15',NULL),(4339,NULL,'assingMorePeriods','While de empresa, year->2057, initial_month->1, contador->27','2018-06-14 20:50:15',NULL),(4340,NULL,'assingMorePeriods','While de empresa, year->2058, initial_month->1, contador->28','2018-06-14 20:50:15',NULL),(4341,NULL,'assingMorePeriods','While de empresa, year->2059, initial_month->1, contador->29','2018-06-14 20:50:15',NULL),(4342,NULL,'assingMorePeriods','While de empresa, year->2060, initial_month->1, contador->30','2018-06-14 20:50:15',NULL),(4343,NULL,'assingMorePeriods','While de empresa, year->2061, initial_month->1, contador->31','2018-06-14 20:50:15',NULL),(4344,NULL,'assingMorePeriods','While de empresa, year->2062, initial_month->1, contador->32','2018-06-14 20:50:15',NULL),(4345,NULL,'assingMorePeriods','While de empresa, year->2063, initial_month->1, contador->33','2018-06-14 20:50:15',NULL),(4346,NULL,'assingMorePeriods','While de empresa, year->2064, initial_month->1, contador->34','2018-06-14 20:50:15',NULL),(4347,NULL,'assingMorePeriods','While de empresa, year->2065, initial_month->1, contador->35','2018-06-14 20:50:15',NULL),(4348,NULL,'assingMorePeriods','While de empresa, year->2066, initial_month->1, contador->36','2018-06-14 20:50:15',NULL),(4349,NULL,'assingMorePeriods','While de empresa, year->2067, initial_month->1, contador->37','2018-06-14 20:50:15',NULL),(4350,NULL,'assingMorePeriods','While de empresa, year->2068, initial_month->1, contador->38','2018-06-14 20:50:15',NULL),(4351,NULL,'assingMorePeriods','While de empresa, year->2069, initial_month->1, contador->39','2018-06-14 20:50:15',NULL),(4352,NULL,'assingMorePeriods','While de empresa, year->2070, initial_month->1, contador->40','2018-06-14 20:50:15',NULL),(4353,NULL,'assingMorePeriods','While de empresa, year->2071, initial_month->1, contador->41','2018-06-14 20:50:15',NULL),(4354,NULL,'assingMorePeriods','While de empresa, year->2072, initial_month->1, contador->42','2018-06-14 20:50:15',NULL),(4355,NULL,'assingMorePeriods','While de empresa, year->2073, initial_month->1, contador->43','2018-06-14 20:50:15',NULL),(4356,NULL,'assingMorePeriods','While de empresa, year->2074, initial_month->1, contador->44','2018-06-14 20:50:15',NULL),(4357,NULL,'assingMorePeriods','While de empresa, year->2075, initial_month->1, contador->45','2018-06-14 20:50:15',NULL);
INSERT INTO `log_debug` VALUES (4358,NULL,'assingMorePeriods','While de empresa, year->2076, initial_month->1, contador->46','2018-06-14 20:50:15',NULL),(4359,NULL,'assingMorePeriods','While de empresa, year->2077, initial_month->1, contador->47','2018-06-14 20:50:15',NULL),(4360,NULL,'assingMorePeriods','While de empresa, year->2078, initial_month->1, contador->48','2018-06-14 20:50:15',NULL),(4361,NULL,'assingMorePeriods','While de empresa, year->2079, initial_month->1, contador->49','2018-06-14 20:50:15',NULL),(4362,NULL,'assingMorePeriods','While de empresa, year->2080, initial_month->1, contador->50','2018-06-14 20:50:15',NULL),(4363,NULL,'assingMorePeriods','While de empresa, year->2081, initial_month->1, contador->51','2018-06-14 20:50:15',NULL),(4364,NULL,'assingMorePeriods','While de empresa, year->2082, initial_month->1, contador->52','2018-06-14 20:50:15',NULL),(4365,NULL,'assingMorePeriods','While de empresa, year->2083, initial_month->1, contador->53','2018-06-14 20:50:15',NULL),(4366,NULL,'assingMorePeriods','While de empresa, year->2084, initial_month->1, contador->54','2018-06-14 20:50:15',NULL),(4367,NULL,'assingMorePeriods','While de empresa, year->2085, initial_month->1, contador->55','2018-06-14 20:50:15',NULL),(4368,NULL,'assingMorePeriods','While de empresa, year->2086, initial_month->1, contador->56','2018-06-14 20:50:15',NULL),(4369,NULL,'assingMorePeriods','While de empresa, year->2087, initial_month->1, contador->57','2018-06-14 20:50:15',NULL),(4370,NULL,'assingMorePeriods','While de empresa, year->2088, initial_month->1, contador->58','2018-06-14 20:50:15',NULL),(4371,NULL,'assingMorePeriods','While de empresa, year->2089, initial_month->1, contador->59','2018-06-14 20:50:15',NULL),(4372,NULL,'assingMorePeriods','While de empresa, year->2090, initial_month->1, contador->60','2018-06-14 20:50:15',NULL),(4373,NULL,'assingMorePeriods','While de empresa, year->2091, initial_month->1, contador->61','2018-06-14 20:50:15',NULL),(4374,NULL,'assingMorePeriods','While de empresa, year->2092, initial_month->1, contador->62','2018-06-14 20:50:15',NULL),(4375,NULL,'assingMorePeriods','While de empresa, year->2093, initial_month->1, contador->63','2018-06-14 20:50:15',NULL),(4376,NULL,'assingMorePeriods','While de empresa, year->2094, initial_month->1, contador->64','2018-06-14 20:50:15',NULL),(4377,NULL,'assingMorePeriods','While de empresa, year->2095, initial_month->1, contador->65','2018-06-14 20:50:15',NULL),(4378,NULL,'assingMorePeriods','While de empresa, year->2096, initial_month->1, contador->66','2018-06-14 20:50:15',NULL),(4379,NULL,'assingMorePeriods','While de empresa, year->2097, initial_month->1, contador->67','2018-06-14 20:50:15',NULL),(4380,NULL,'assingMorePeriods','While de empresa, year->2098, initial_month->1, contador->68','2018-06-14 20:50:15',NULL),(4381,NULL,'assingMorePeriods','While de empresa, year->2099, initial_month->1, contador->69','2018-06-14 20:50:15',NULL),(4382,NULL,'assingMorePeriods','While de empresa, year->2100, initial_month->1, contador->70','2018-06-14 20:50:15',NULL),(4383,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1995, periodo->2030-12','2018-06-14 20:50:15',NULL),(4384,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->13, contador->0','2018-06-14 20:50:15',NULL),(4385,NULL,'assingMorePeriods','While de empresa, year->2031, initial_month->13, contador->1','2018-06-14 20:50:15',NULL),(4386,NULL,'assingMorePeriods','While de empresa, year->2032, initial_month->1, contador->2','2018-06-14 20:50:15',NULL),(4387,NULL,'assingMorePeriods','While de empresa, year->2033, initial_month->1, contador->3','2018-06-14 20:50:15',NULL),(4388,NULL,'assingMorePeriods','While de empresa, year->2034, initial_month->1, contador->4','2018-06-14 20:50:15',NULL),(4389,NULL,'assingMorePeriods','While de empresa, year->2035, initial_month->1, contador->5','2018-06-14 20:50:15',NULL),(4390,NULL,'assingMorePeriods','While de empresa, year->2036, initial_month->1, contador->6','2018-06-14 20:50:15',NULL);
INSERT INTO `log_debug` VALUES (4391,NULL,'assingMorePeriods','While de empresa, year->2037, initial_month->1, contador->7','2018-06-14 20:50:15',NULL),(4392,NULL,'assingMorePeriods','While de empresa, year->2038, initial_month->1, contador->8','2018-06-14 20:50:15',NULL),(4393,NULL,'assingMorePeriods','While de empresa, year->2039, initial_month->1, contador->9','2018-06-14 20:50:15',NULL),(4394,NULL,'assingMorePeriods','While de empresa, year->2040, initial_month->1, contador->10','2018-06-14 20:50:15',NULL),(4395,NULL,'assingMorePeriods','While de empresa, year->2041, initial_month->1, contador->11','2018-06-14 20:50:15',NULL),(4396,NULL,'assingMorePeriods','While de empresa, year->2042, initial_month->1, contador->12','2018-06-14 20:50:15',NULL),(4397,NULL,'assingMorePeriods','While de empresa, year->2043, initial_month->1, contador->13','2018-06-14 20:50:15',NULL),(4398,NULL,'assingMorePeriods','While de empresa, year->2044, initial_month->1, contador->14','2018-06-14 20:50:15',NULL),(4399,NULL,'assingMorePeriods','While de empresa, year->2045, initial_month->1, contador->15','2018-06-14 20:50:15',NULL),(4400,NULL,'assingMorePeriods','While de empresa, year->2046, initial_month->1, contador->16','2018-06-14 20:50:15',NULL),(4401,NULL,'assingMorePeriods','While de empresa, year->2047, initial_month->1, contador->17','2018-06-14 20:50:15',NULL),(4402,NULL,'assingMorePeriods','While de empresa, year->2048, initial_month->1, contador->18','2018-06-14 20:50:15',NULL),(4403,NULL,'assingMorePeriods','While de empresa, year->2049, initial_month->1, contador->19','2018-06-14 20:50:15',NULL),(4404,NULL,'assingMorePeriods','While de empresa, year->2050, initial_month->1, contador->20','2018-06-14 20:50:15',NULL),(4405,NULL,'assingMorePeriods','While de empresa, year->2051, initial_month->1, contador->21','2018-06-14 20:50:15',NULL),(4406,NULL,'assingMorePeriods','While de empresa, year->2052, initial_month->1, contador->22','2018-06-14 20:50:15',NULL),(4407,NULL,'assingMorePeriods','While de empresa, year->2053, initial_month->1, contador->23','2018-06-14 20:50:15',NULL),(4408,NULL,'assingMorePeriods','While de empresa, year->2054, initial_month->1, contador->24','2018-06-14 20:50:15',NULL),(4409,NULL,'assingMorePeriods','While de empresa, year->2055, initial_month->1, contador->25','2018-06-14 20:50:15',NULL),(4410,NULL,'assingMorePeriods','While de empresa, year->2056, initial_month->1, contador->26','2018-06-14 20:50:15',NULL),(4411,NULL,'assingMorePeriods','While de empresa, year->2057, initial_month->1, contador->27','2018-06-14 20:50:15',NULL),(4412,NULL,'assingMorePeriods','While de empresa, year->2058, initial_month->1, contador->28','2018-06-14 20:50:15',NULL),(4413,NULL,'assingMorePeriods','While de empresa, year->2059, initial_month->1, contador->29','2018-06-14 20:50:15',NULL),(4414,NULL,'assingMorePeriods','While de empresa, year->2060, initial_month->1, contador->30','2018-06-14 20:50:15',NULL),(4415,NULL,'assingMorePeriods','While de empresa, year->2061, initial_month->1, contador->31','2018-06-14 20:50:15',NULL),(4416,NULL,'assingMorePeriods','While de empresa, year->2062, initial_month->1, contador->32','2018-06-14 20:50:15',NULL),(4417,NULL,'assingMorePeriods','While de empresa, year->2063, initial_month->1, contador->33','2018-06-14 20:50:15',NULL),(4418,NULL,'assingMorePeriods','While de empresa, year->2064, initial_month->1, contador->34','2018-06-14 20:50:15',NULL),(4419,NULL,'assingMorePeriods','While de empresa, year->2065, initial_month->1, contador->35','2018-06-14 20:50:15',NULL),(4420,NULL,'assingMorePeriods','While de empresa, year->2066, initial_month->1, contador->36','2018-06-14 20:50:15',NULL),(4421,NULL,'assingMorePeriods','While de empresa, year->2067, initial_month->1, contador->37','2018-06-14 20:50:15',NULL),(4422,NULL,'assingMorePeriods','While de empresa, year->2068, initial_month->1, contador->38','2018-06-14 20:50:15',NULL),(4423,NULL,'assingMorePeriods','While de empresa, year->2069, initial_month->1, contador->39','2018-06-14 20:50:15',NULL);
INSERT INTO `log_debug` VALUES (4424,NULL,'assingMorePeriods','While de empresa, year->2070, initial_month->1, contador->40','2018-06-14 20:50:15',NULL),(4425,NULL,'assingMorePeriods','While de empresa, year->2071, initial_month->1, contador->41','2018-06-14 20:50:15',NULL),(4426,NULL,'assingMorePeriods','While de empresa, year->2072, initial_month->1, contador->42','2018-06-14 20:50:15',NULL),(4427,NULL,'assingMorePeriods','While de empresa, year->2073, initial_month->1, contador->43','2018-06-14 20:50:15',NULL),(4428,NULL,'assingMorePeriods','While de empresa, year->2074, initial_month->1, contador->44','2018-06-14 20:50:15',NULL),(4429,NULL,'assingMorePeriods','While de empresa, year->2075, initial_month->1, contador->45','2018-06-14 20:50:15',NULL),(4430,NULL,'assingMorePeriods','While de empresa, year->2076, initial_month->1, contador->46','2018-06-14 20:50:15',NULL),(4431,NULL,'assingMorePeriods','While de empresa, year->2077, initial_month->1, contador->47','2018-06-14 20:50:15',NULL),(4432,NULL,'assingMorePeriods','While de empresa, year->2078, initial_month->1, contador->48','2018-06-14 20:50:15',NULL),(4433,NULL,'assingMorePeriods','While de empresa, year->2079, initial_month->1, contador->49','2018-06-14 20:50:15',NULL),(4434,NULL,'assingMorePeriods','While de empresa, year->2080, initial_month->1, contador->50','2018-06-14 20:50:15',NULL),(4435,NULL,'assingMorePeriods','While de empresa, year->2081, initial_month->1, contador->51','2018-06-14 20:50:15',NULL),(4436,NULL,'assingMorePeriods','While de empresa, year->2082, initial_month->1, contador->52','2018-06-14 20:50:15',NULL),(4437,NULL,'assingMorePeriods','While de empresa, year->2083, initial_month->1, contador->53','2018-06-14 20:50:15',NULL),(4438,NULL,'assingMorePeriods','While de empresa, year->2084, initial_month->1, contador->54','2018-06-14 20:50:15',NULL),(4439,NULL,'assingMorePeriods','While de empresa, year->2085, initial_month->1, contador->55','2018-06-14 20:50:15',NULL),(4440,NULL,'assingMorePeriods','While de empresa, year->2086, initial_month->1, contador->56','2018-06-14 20:50:15',NULL),(4441,NULL,'assingMorePeriods','While de empresa, year->2087, initial_month->1, contador->57','2018-06-14 20:50:15',NULL),(4442,NULL,'assingMorePeriods','While de empresa, year->2088, initial_month->1, contador->58','2018-06-14 20:50:15',NULL),(4443,NULL,'assingMorePeriods','While de empresa, year->2089, initial_month->1, contador->59','2018-06-14 20:50:15',NULL),(4444,NULL,'assingMorePeriods','While de empresa, year->2090, initial_month->1, contador->60','2018-06-14 20:50:15',NULL),(4445,NULL,'assingMorePeriods','While de empresa, year->2091, initial_month->1, contador->61','2018-06-14 20:50:15',NULL),(4446,NULL,'assingMorePeriods','While de empresa, year->2092, initial_month->1, contador->62','2018-06-14 20:50:15',NULL),(4447,NULL,'assingMorePeriods','While de empresa, year->2093, initial_month->1, contador->63','2018-06-14 20:50:15',NULL),(4448,NULL,'assingMorePeriods','While de empresa, year->2094, initial_month->1, contador->64','2018-06-14 20:50:15',NULL),(4449,NULL,'assingMorePeriods','While de empresa, year->2095, initial_month->1, contador->65','2018-06-14 20:50:15',NULL),(4450,NULL,'assingMorePeriods','While de empresa, year->2096, initial_month->1, contador->66','2018-06-14 20:50:15',NULL),(4451,NULL,'assingMorePeriods','While de empresa, year->2097, initial_month->1, contador->67','2018-06-14 20:50:15',NULL),(4452,NULL,'assingMorePeriods','While de empresa, year->2098, initial_month->1, contador->68','2018-06-14 20:50:15',NULL),(4453,NULL,'assingMorePeriods','While de empresa, year->2099, initial_month->1, contador->69','2018-06-14 20:50:15',NULL),(4454,NULL,'assingMorePeriods','While de empresa, year->2100, initial_month->1, contador->70','2018-06-14 20:50:15',NULL),(4455,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1996, periodo->2030-12','2018-06-14 20:50:15',NULL),(4456,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->13, contador->0','2018-06-14 20:50:15',NULL);
INSERT INTO `log_debug` VALUES (4457,NULL,'assingMorePeriods','While de empresa, year->2031, initial_month->13, contador->1','2018-06-14 20:50:15',NULL),(4458,NULL,'assingMorePeriods','While de empresa, year->2032, initial_month->1, contador->2','2018-06-14 20:50:15',NULL),(4459,NULL,'assingMorePeriods','While de empresa, year->2033, initial_month->1, contador->3','2018-06-14 20:50:15',NULL),(4460,NULL,'assingMorePeriods','While de empresa, year->2034, initial_month->1, contador->4','2018-06-14 20:50:15',NULL),(4461,NULL,'assingMorePeriods','While de empresa, year->2035, initial_month->1, contador->5','2018-06-14 20:50:15',NULL),(4462,NULL,'assingMorePeriods','While de empresa, year->2036, initial_month->1, contador->6','2018-06-14 20:50:15',NULL),(4463,NULL,'assingMorePeriods','While de empresa, year->2037, initial_month->1, contador->7','2018-06-14 20:50:15',NULL),(4464,NULL,'assingMorePeriods','While de empresa, year->2038, initial_month->1, contador->8','2018-06-14 20:50:15',NULL),(4465,NULL,'assingMorePeriods','While de empresa, year->2039, initial_month->1, contador->9','2018-06-14 20:50:15',NULL),(4466,NULL,'assingMorePeriods','While de empresa, year->2040, initial_month->1, contador->10','2018-06-14 20:50:15',NULL),(4467,NULL,'assingMorePeriods','While de empresa, year->2041, initial_month->1, contador->11','2018-06-14 20:50:15',NULL),(4468,NULL,'assingMorePeriods','While de empresa, year->2042, initial_month->1, contador->12','2018-06-14 20:50:15',NULL),(4469,NULL,'assingMorePeriods','While de empresa, year->2043, initial_month->1, contador->13','2018-06-14 20:50:15',NULL),(4470,NULL,'assingMorePeriods','While de empresa, year->2044, initial_month->1, contador->14','2018-06-14 20:50:15',NULL),(4471,NULL,'assingMorePeriods','While de empresa, year->2045, initial_month->1, contador->15','2018-06-14 20:50:15',NULL),(4472,NULL,'assingMorePeriods','While de empresa, year->2046, initial_month->1, contador->16','2018-06-14 20:50:15',NULL),(4473,NULL,'assingMorePeriods','While de empresa, year->2047, initial_month->1, contador->17','2018-06-14 20:50:15',NULL),(4474,NULL,'assingMorePeriods','While de empresa, year->2048, initial_month->1, contador->18','2018-06-14 20:50:15',NULL),(4475,NULL,'assingMorePeriods','While de empresa, year->2049, initial_month->1, contador->19','2018-06-14 20:50:15',NULL),(4476,NULL,'assingMorePeriods','While de empresa, year->2050, initial_month->1, contador->20','2018-06-14 20:50:15',NULL),(4477,NULL,'assingMorePeriods','While de empresa, year->2051, initial_month->1, contador->21','2018-06-14 20:50:15',NULL),(4478,NULL,'assingMorePeriods','While de empresa, year->2052, initial_month->1, contador->22','2018-06-14 20:50:15',NULL),(4479,NULL,'assingMorePeriods','While de empresa, year->2053, initial_month->1, contador->23','2018-06-14 20:50:15',NULL),(4480,NULL,'assingMorePeriods','While de empresa, year->2054, initial_month->1, contador->24','2018-06-14 20:50:15',NULL),(4481,NULL,'assingMorePeriods','While de empresa, year->2055, initial_month->1, contador->25','2018-06-14 20:50:15',NULL),(4482,NULL,'assingMorePeriods','While de empresa, year->2056, initial_month->1, contador->26','2018-06-14 20:50:15',NULL),(4483,NULL,'assingMorePeriods','While de empresa, year->2057, initial_month->1, contador->27','2018-06-14 20:50:15',NULL),(4484,NULL,'assingMorePeriods','While de empresa, year->2058, initial_month->1, contador->28','2018-06-14 20:50:15',NULL),(4485,NULL,'assingMorePeriods','While de empresa, year->2059, initial_month->1, contador->29','2018-06-14 20:50:15',NULL),(4486,NULL,'assingMorePeriods','While de empresa, year->2060, initial_month->1, contador->30','2018-06-14 20:50:15',NULL),(4487,NULL,'assingMorePeriods','While de empresa, year->2061, initial_month->1, contador->31','2018-06-14 20:50:15',NULL),(4488,NULL,'assingMorePeriods','While de empresa, year->2062, initial_month->1, contador->32','2018-06-14 20:50:15',NULL),(4489,NULL,'assingMorePeriods','While de empresa, year->2063, initial_month->1, contador->33','2018-06-14 20:50:15',NULL);
INSERT INTO `log_debug` VALUES (4490,NULL,'assingMorePeriods','While de empresa, year->2064, initial_month->1, contador->34','2018-06-14 20:50:15',NULL),(4491,NULL,'assingMorePeriods','While de empresa, year->2065, initial_month->1, contador->35','2018-06-14 20:50:15',NULL),(4492,NULL,'assingMorePeriods','While de empresa, year->2066, initial_month->1, contador->36','2018-06-14 20:50:15',NULL),(4493,NULL,'assingMorePeriods','While de empresa, year->2067, initial_month->1, contador->37','2018-06-14 20:50:15',NULL),(4494,NULL,'assingMorePeriods','While de empresa, year->2068, initial_month->1, contador->38','2018-06-14 20:50:15',NULL),(4495,NULL,'assingMorePeriods','While de empresa, year->2069, initial_month->1, contador->39','2018-06-14 20:50:15',NULL),(4496,NULL,'assingMorePeriods','While de empresa, year->2070, initial_month->1, contador->40','2018-06-14 20:50:15',NULL),(4497,NULL,'assingMorePeriods','While de empresa, year->2071, initial_month->1, contador->41','2018-06-14 20:50:15',NULL),(4498,NULL,'assingMorePeriods','While de empresa, year->2072, initial_month->1, contador->42','2018-06-14 20:50:15',NULL),(4499,NULL,'assingMorePeriods','While de empresa, year->2073, initial_month->1, contador->43','2018-06-14 20:50:15',NULL),(4500,NULL,'assingMorePeriods','While de empresa, year->2074, initial_month->1, contador->44','2018-06-14 20:50:15',NULL),(4501,NULL,'assingMorePeriods','While de empresa, year->2075, initial_month->1, contador->45','2018-06-14 20:50:15',NULL),(4502,NULL,'assingMorePeriods','While de empresa, year->2076, initial_month->1, contador->46','2018-06-14 20:50:15',NULL),(4503,NULL,'assingMorePeriods','While de empresa, year->2077, initial_month->1, contador->47','2018-06-14 20:50:15',NULL),(4504,NULL,'assingMorePeriods','While de empresa, year->2078, initial_month->1, contador->48','2018-06-14 20:50:15',NULL),(4505,NULL,'assingMorePeriods','While de empresa, year->2079, initial_month->1, contador->49','2018-06-14 20:50:15',NULL),(4506,NULL,'assingMorePeriods','While de empresa, year->2080, initial_month->1, contador->50','2018-06-14 20:50:15',NULL),(4507,NULL,'assingMorePeriods','While de empresa, year->2081, initial_month->1, contador->51','2018-06-14 20:50:15',NULL),(4508,NULL,'assingMorePeriods','While de empresa, year->2082, initial_month->1, contador->52','2018-06-14 20:50:15',NULL),(4509,NULL,'assingMorePeriods','While de empresa, year->2083, initial_month->1, contador->53','2018-06-14 20:50:15',NULL),(4510,NULL,'assingMorePeriods','While de empresa, year->2084, initial_month->1, contador->54','2018-06-14 20:50:15',NULL),(4511,NULL,'assingMorePeriods','While de empresa, year->2085, initial_month->1, contador->55','2018-06-14 20:50:15',NULL),(4512,NULL,'assingMorePeriods','While de empresa, year->2086, initial_month->1, contador->56','2018-06-14 20:50:15',NULL),(4513,NULL,'assingMorePeriods','While de empresa, year->2087, initial_month->1, contador->57','2018-06-14 20:50:15',NULL),(4514,NULL,'assingMorePeriods','While de empresa, year->2088, initial_month->1, contador->58','2018-06-14 20:50:15',NULL),(4515,NULL,'assingMorePeriods','While de empresa, year->2089, initial_month->1, contador->59','2018-06-14 20:50:15',NULL),(4516,NULL,'assingMorePeriods','While de empresa, year->2090, initial_month->1, contador->60','2018-06-14 20:50:15',NULL),(4517,NULL,'assingMorePeriods','While de empresa, year->2091, initial_month->1, contador->61','2018-06-14 20:50:15',NULL),(4518,NULL,'assingMorePeriods','While de empresa, year->2092, initial_month->1, contador->62','2018-06-14 20:50:15',NULL),(4519,NULL,'assingMorePeriods','While de empresa, year->2093, initial_month->1, contador->63','2018-06-14 20:50:15',NULL),(4520,NULL,'assingMorePeriods','While de empresa, year->2094, initial_month->1, contador->64','2018-06-14 20:50:15',NULL),(4521,NULL,'assingMorePeriods','While de empresa, year->2095, initial_month->1, contador->65','2018-06-14 20:50:15',NULL),(4522,NULL,'assingMorePeriods','While de empresa, year->2096, initial_month->1, contador->66','2018-06-14 20:50:15',NULL);
INSERT INTO `log_debug` VALUES (4523,NULL,'assingMorePeriods','While de empresa, year->2097, initial_month->1, contador->67','2018-06-14 20:50:15',NULL),(4524,NULL,'assingMorePeriods','While de empresa, year->2098, initial_month->1, contador->68','2018-06-14 20:50:15',NULL),(4525,NULL,'assingMorePeriods','While de empresa, year->2099, initial_month->1, contador->69','2018-06-14 20:50:15',NULL),(4526,NULL,'assingMorePeriods','While de empresa, year->2100, initial_month->1, contador->70','2018-06-14 20:50:15',NULL),(4527,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1997, periodo->2030-12','2018-06-14 20:50:15',NULL),(4528,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->13, contador->0','2018-06-14 20:50:15',NULL),(4529,NULL,'assingMorePeriods','While de empresa, year->2031, initial_month->13, contador->1','2018-06-14 20:50:15',NULL),(4530,NULL,'assingMorePeriods','While de empresa, year->2032, initial_month->1, contador->2','2018-06-14 20:50:15',NULL),(4531,NULL,'assingMorePeriods','While de empresa, year->2033, initial_month->1, contador->3','2018-06-14 20:50:15',NULL),(4532,NULL,'assingMorePeriods','While de empresa, year->2034, initial_month->1, contador->4','2018-06-14 20:50:15',NULL),(4533,NULL,'assingMorePeriods','While de empresa, year->2035, initial_month->1, contador->5','2018-06-14 20:50:15',NULL),(4534,NULL,'assingMorePeriods','While de empresa, year->2036, initial_month->1, contador->6','2018-06-14 20:50:15',NULL),(4535,NULL,'assingMorePeriods','While de empresa, year->2037, initial_month->1, contador->7','2018-06-14 20:50:15',NULL),(4536,NULL,'assingMorePeriods','While de empresa, year->2038, initial_month->1, contador->8','2018-06-14 20:50:15',NULL),(4537,NULL,'assingMorePeriods','While de empresa, year->2039, initial_month->1, contador->9','2018-06-14 20:50:15',NULL),(4538,NULL,'assingMorePeriods','While de empresa, year->2040, initial_month->1, contador->10','2018-06-14 20:50:15',NULL),(4539,NULL,'assingMorePeriods','While de empresa, year->2041, initial_month->1, contador->11','2018-06-14 20:50:15',NULL),(4540,NULL,'assingMorePeriods','While de empresa, year->2042, initial_month->1, contador->12','2018-06-14 20:50:15',NULL),(4541,NULL,'assingMorePeriods','While de empresa, year->2043, initial_month->1, contador->13','2018-06-14 20:50:15',NULL),(4542,NULL,'assingMorePeriods','While de empresa, year->2044, initial_month->1, contador->14','2018-06-14 20:50:15',NULL),(4543,NULL,'assingMorePeriods','While de empresa, year->2045, initial_month->1, contador->15','2018-06-14 20:50:15',NULL),(4544,NULL,'assingMorePeriods','While de empresa, year->2046, initial_month->1, contador->16','2018-06-14 20:50:15',NULL),(4545,NULL,'assingMorePeriods','While de empresa, year->2047, initial_month->1, contador->17','2018-06-14 20:50:15',NULL),(4546,NULL,'assingMorePeriods','While de empresa, year->2048, initial_month->1, contador->18','2018-06-14 20:50:15',NULL),(4547,NULL,'assingMorePeriods','While de empresa, year->2049, initial_month->1, contador->19','2018-06-14 20:50:15',NULL),(4548,NULL,'assingMorePeriods','While de empresa, year->2050, initial_month->1, contador->20','2018-06-14 20:50:15',NULL),(4549,NULL,'assingMorePeriods','While de empresa, year->2051, initial_month->1, contador->21','2018-06-14 20:50:15',NULL),(4550,NULL,'assingMorePeriods','While de empresa, year->2052, initial_month->1, contador->22','2018-06-14 20:50:15',NULL),(4551,NULL,'assingMorePeriods','While de empresa, year->2053, initial_month->1, contador->23','2018-06-14 20:50:15',NULL),(4552,NULL,'assingMorePeriods','While de empresa, year->2054, initial_month->1, contador->24','2018-06-14 20:50:15',NULL),(4553,NULL,'assingMorePeriods','While de empresa, year->2055, initial_month->1, contador->25','2018-06-14 20:50:15',NULL),(4554,NULL,'assingMorePeriods','While de empresa, year->2056, initial_month->1, contador->26','2018-06-14 20:50:15',NULL),(4555,NULL,'assingMorePeriods','While de empresa, year->2057, initial_month->1, contador->27','2018-06-14 20:50:15',NULL);
INSERT INTO `log_debug` VALUES (4556,NULL,'assingMorePeriods','While de empresa, year->2058, initial_month->1, contador->28','2018-06-14 20:50:15',NULL),(4557,NULL,'assingMorePeriods','While de empresa, year->2059, initial_month->1, contador->29','2018-06-14 20:50:15',NULL),(4558,NULL,'assingMorePeriods','While de empresa, year->2060, initial_month->1, contador->30','2018-06-14 20:50:15',NULL),(4559,NULL,'assingMorePeriods','While de empresa, year->2061, initial_month->1, contador->31','2018-06-14 20:50:15',NULL),(4560,NULL,'assingMorePeriods','While de empresa, year->2062, initial_month->1, contador->32','2018-06-14 20:50:15',NULL),(4561,NULL,'assingMorePeriods','While de empresa, year->2063, initial_month->1, contador->33','2018-06-14 20:50:15',NULL),(4562,NULL,'assingMorePeriods','While de empresa, year->2064, initial_month->1, contador->34','2018-06-14 20:50:15',NULL),(4563,NULL,'assingMorePeriods','While de empresa, year->2065, initial_month->1, contador->35','2018-06-14 20:50:15',NULL),(4564,NULL,'assingMorePeriods','While de empresa, year->2066, initial_month->1, contador->36','2018-06-14 20:50:15',NULL),(4565,NULL,'assingMorePeriods','While de empresa, year->2067, initial_month->1, contador->37','2018-06-14 20:50:15',NULL),(4566,NULL,'assingMorePeriods','While de empresa, year->2068, initial_month->1, contador->38','2018-06-14 20:50:15',NULL),(4567,NULL,'assingMorePeriods','While de empresa, year->2069, initial_month->1, contador->39','2018-06-14 20:50:15',NULL),(4568,NULL,'assingMorePeriods','While de empresa, year->2070, initial_month->1, contador->40','2018-06-14 20:50:15',NULL),(4569,NULL,'assingMorePeriods','While de empresa, year->2071, initial_month->1, contador->41','2018-06-14 20:50:15',NULL),(4570,NULL,'assingMorePeriods','While de empresa, year->2072, initial_month->1, contador->42','2018-06-14 20:50:15',NULL),(4571,NULL,'assingMorePeriods','While de empresa, year->2073, initial_month->1, contador->43','2018-06-14 20:50:15',NULL),(4572,NULL,'assingMorePeriods','While de empresa, year->2074, initial_month->1, contador->44','2018-06-14 20:50:15',NULL),(4573,NULL,'assingMorePeriods','While de empresa, year->2075, initial_month->1, contador->45','2018-06-14 20:50:15',NULL),(4574,NULL,'assingMorePeriods','While de empresa, year->2076, initial_month->1, contador->46','2018-06-14 20:50:15',NULL),(4575,NULL,'assingMorePeriods','While de empresa, year->2077, initial_month->1, contador->47','2018-06-14 20:50:15',NULL),(4576,NULL,'assingMorePeriods','While de empresa, year->2078, initial_month->1, contador->48','2018-06-14 20:50:15',NULL),(4577,NULL,'assingMorePeriods','While de empresa, year->2079, initial_month->1, contador->49','2018-06-14 20:50:15',NULL),(4578,NULL,'assingMorePeriods','While de empresa, year->2080, initial_month->1, contador->50','2018-06-14 20:50:15',NULL),(4579,NULL,'assingMorePeriods','While de empresa, year->2081, initial_month->1, contador->51','2018-06-14 20:50:15',NULL),(4580,NULL,'assingMorePeriods','While de empresa, year->2082, initial_month->1, contador->52','2018-06-14 20:50:15',NULL),(4581,NULL,'assingMorePeriods','While de empresa, year->2083, initial_month->1, contador->53','2018-06-14 20:50:15',NULL),(4582,NULL,'assingMorePeriods','While de empresa, year->2084, initial_month->1, contador->54','2018-06-14 20:50:15',NULL),(4583,NULL,'assingMorePeriods','While de empresa, year->2085, initial_month->1, contador->55','2018-06-14 20:50:15',NULL),(4584,NULL,'assingMorePeriods','While de empresa, year->2086, initial_month->1, contador->56','2018-06-14 20:50:15',NULL),(4585,NULL,'assingMorePeriods','While de empresa, year->2087, initial_month->1, contador->57','2018-06-14 20:50:15',NULL),(4586,NULL,'assingMorePeriods','While de empresa, year->2088, initial_month->1, contador->58','2018-06-14 20:50:15',NULL),(4587,NULL,'assingMorePeriods','While de empresa, year->2089, initial_month->1, contador->59','2018-06-14 20:50:15',NULL),(4588,NULL,'assingMorePeriods','While de empresa, year->2090, initial_month->1, contador->60','2018-06-14 20:50:15',NULL);
INSERT INTO `log_debug` VALUES (4589,NULL,'assingMorePeriods','While de empresa, year->2091, initial_month->1, contador->61','2018-06-14 20:50:15',NULL),(4590,NULL,'assingMorePeriods','While de empresa, year->2092, initial_month->1, contador->62','2018-06-14 20:50:15',NULL),(4591,NULL,'assingMorePeriods','While de empresa, year->2093, initial_month->1, contador->63','2018-06-14 20:50:15',NULL),(4592,NULL,'assingMorePeriods','While de empresa, year->2094, initial_month->1, contador->64','2018-06-14 20:50:15',NULL),(4593,NULL,'assingMorePeriods','While de empresa, year->2095, initial_month->1, contador->65','2018-06-14 20:50:15',NULL),(4594,NULL,'assingMorePeriods','While de empresa, year->2096, initial_month->1, contador->66','2018-06-14 20:50:15',NULL),(4595,NULL,'assingMorePeriods','While de empresa, year->2097, initial_month->1, contador->67','2018-06-14 20:50:15',NULL),(4596,NULL,'assingMorePeriods','While de empresa, year->2098, initial_month->1, contador->68','2018-06-14 20:50:15',NULL),(4597,NULL,'assingMorePeriods','While de empresa, year->2099, initial_month->1, contador->69','2018-06-14 20:50:15',NULL),(4598,NULL,'assingMorePeriods','While de empresa, year->2100, initial_month->1, contador->70','2018-06-14 20:50:15',NULL),(4599,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1998, periodo->2030-12','2018-06-14 20:50:15',NULL),(4600,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->13, contador->0','2018-06-14 20:50:15',NULL),(4601,NULL,'assingMorePeriods','While de empresa, year->2031, initial_month->13, contador->1','2018-06-14 20:50:15',NULL),(4602,NULL,'assingMorePeriods','While de empresa, year->2032, initial_month->1, contador->2','2018-06-14 20:50:15',NULL),(4603,NULL,'assingMorePeriods','While de empresa, year->2033, initial_month->1, contador->3','2018-06-14 20:50:15',NULL),(4604,NULL,'assingMorePeriods','While de empresa, year->2034, initial_month->1, contador->4','2018-06-14 20:50:15',NULL),(4605,NULL,'assingMorePeriods','While de empresa, year->2035, initial_month->1, contador->5','2018-06-14 20:50:15',NULL),(4606,NULL,'assingMorePeriods','While de empresa, year->2036, initial_month->1, contador->6','2018-06-14 20:50:15',NULL),(4607,NULL,'assingMorePeriods','While de empresa, year->2037, initial_month->1, contador->7','2018-06-14 20:50:15',NULL),(4608,NULL,'assingMorePeriods','While de empresa, year->2038, initial_month->1, contador->8','2018-06-14 20:50:15',NULL),(4609,NULL,'assingMorePeriods','While de empresa, year->2039, initial_month->1, contador->9','2018-06-14 20:50:15',NULL),(4610,NULL,'assingMorePeriods','While de empresa, year->2040, initial_month->1, contador->10','2018-06-14 20:50:15',NULL),(4611,NULL,'assingMorePeriods','While de empresa, year->2041, initial_month->1, contador->11','2018-06-14 20:50:15',NULL),(4612,NULL,'assingMorePeriods','While de empresa, year->2042, initial_month->1, contador->12','2018-06-14 20:50:15',NULL),(4613,NULL,'assingMorePeriods','While de empresa, year->2043, initial_month->1, contador->13','2018-06-14 20:50:15',NULL),(4614,NULL,'assingMorePeriods','While de empresa, year->2044, initial_month->1, contador->14','2018-06-14 20:50:15',NULL),(4615,NULL,'assingMorePeriods','While de empresa, year->2045, initial_month->1, contador->15','2018-06-14 20:50:15',NULL),(4616,NULL,'assingMorePeriods','While de empresa, year->2046, initial_month->1, contador->16','2018-06-14 20:50:15',NULL),(4617,NULL,'assingMorePeriods','While de empresa, year->2047, initial_month->1, contador->17','2018-06-14 20:50:15',NULL),(4618,NULL,'assingMorePeriods','While de empresa, year->2048, initial_month->1, contador->18','2018-06-14 20:50:16',NULL),(4619,NULL,'assingMorePeriods','While de empresa, year->2049, initial_month->1, contador->19','2018-06-14 20:50:16',NULL),(4620,NULL,'assingMorePeriods','While de empresa, year->2050, initial_month->1, contador->20','2018-06-14 20:50:16',NULL),(4621,NULL,'assingMorePeriods','While de empresa, year->2051, initial_month->1, contador->21','2018-06-14 20:50:16',NULL);
INSERT INTO `log_debug` VALUES (4622,NULL,'assingMorePeriods','While de empresa, year->2052, initial_month->1, contador->22','2018-06-14 20:50:16',NULL),(4623,NULL,'assingMorePeriods','While de empresa, year->2053, initial_month->1, contador->23','2018-06-14 20:50:16',NULL),(4624,NULL,'assingMorePeriods','While de empresa, year->2054, initial_month->1, contador->24','2018-06-14 20:50:16',NULL),(4625,NULL,'assingMorePeriods','While de empresa, year->2055, initial_month->1, contador->25','2018-06-14 20:50:16',NULL),(4626,NULL,'assingMorePeriods','While de empresa, year->2056, initial_month->1, contador->26','2018-06-14 20:50:16',NULL),(4627,NULL,'assingMorePeriods','While de empresa, year->2057, initial_month->1, contador->27','2018-06-14 20:50:16',NULL),(4628,NULL,'assingMorePeriods','While de empresa, year->2058, initial_month->1, contador->28','2018-06-14 20:50:16',NULL),(4629,NULL,'assingMorePeriods','While de empresa, year->2059, initial_month->1, contador->29','2018-06-14 20:50:16',NULL),(4630,NULL,'assingMorePeriods','While de empresa, year->2060, initial_month->1, contador->30','2018-06-14 20:50:16',NULL),(4631,NULL,'assingMorePeriods','While de empresa, year->2061, initial_month->1, contador->31','2018-06-14 20:50:16',NULL),(4632,NULL,'assingMorePeriods','While de empresa, year->2062, initial_month->1, contador->32','2018-06-14 20:50:16',NULL),(4633,NULL,'assingMorePeriods','While de empresa, year->2063, initial_month->1, contador->33','2018-06-14 20:50:16',NULL),(4634,NULL,'assingMorePeriods','While de empresa, year->2064, initial_month->1, contador->34','2018-06-14 20:50:16',NULL),(4635,NULL,'assingMorePeriods','While de empresa, year->2065, initial_month->1, contador->35','2018-06-14 20:50:16',NULL),(4636,NULL,'assingMorePeriods','While de empresa, year->2066, initial_month->1, contador->36','2018-06-14 20:50:16',NULL),(4637,NULL,'assingMorePeriods','While de empresa, year->2067, initial_month->1, contador->37','2018-06-14 20:50:16',NULL),(4638,NULL,'assingMorePeriods','While de empresa, year->2068, initial_month->1, contador->38','2018-06-14 20:50:16',NULL),(4639,NULL,'assingMorePeriods','While de empresa, year->2069, initial_month->1, contador->39','2018-06-14 20:50:16',NULL),(4640,NULL,'assingMorePeriods','While de empresa, year->2070, initial_month->1, contador->40','2018-06-14 20:50:16',NULL),(4641,NULL,'assingMorePeriods','While de empresa, year->2071, initial_month->1, contador->41','2018-06-14 20:50:16',NULL),(4642,NULL,'assingMorePeriods','While de empresa, year->2072, initial_month->1, contador->42','2018-06-14 20:50:16',NULL),(4643,NULL,'assingMorePeriods','While de empresa, year->2073, initial_month->1, contador->43','2018-06-14 20:50:16',NULL),(4644,NULL,'assingMorePeriods','While de empresa, year->2074, initial_month->1, contador->44','2018-06-14 20:50:16',NULL),(4645,NULL,'assingMorePeriods','While de 