-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db27-31043241-0
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2021-03-16 22:35:30','Actividad Generica 1','000001',NULL),(2,NULL,'2021-03-16 22:35:30','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL),('2023-1','2023-01',2023,1,'2023-01-01','2023-01-31',1202.9790,NULL,NULL,NULL),('2023-2','2023-02',2023,2,'2023-02-01','2023-02-28',1282.7091,NULL,NULL,NULL),('2023-3','2023-03',2023,3,'2023-03-01','2023-03-31',1381.1601,NULL,NULL,NULL),('2023-4','2023-04',2023,4,'2023-04-01','2023-04-30',1497.2147,NULL,NULL,NULL),('2023-5','2023-05',2023,5,'2023-05-01','2023-05-31',1613.5895,NULL,NULL,NULL),('2023-6','2023-06',2023,6,'2023-06-01','2023-06-30',1709.6115,NULL,NULL,NULL),('2023-7','2023-07',2023,7,'2023-07-01','2023-07-31',1818.0838,NULL,NULL,NULL),('2023-8','2023-08',2023,8,'2023-08-01','2023-08-31',2044.2832,NULL,NULL,NULL),('2023-9','2023-09',2023,9,'2023-09-01','2023-09-30',2304.9242,NULL,NULL,NULL),('2023-10','2023-10',2023,10,'2023-10-01','2023-10-31',2496.2730,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_recibidas`
--

DROP TABLE IF EXISTS `api_recibidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_recibidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` json NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_recibidas_person_id_foreign` (`person_id`),
  CONSTRAINT `api_recibidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_recibidas`
--

LOCK TABLES `api_recibidas` WRITE;
/*!40000 ALTER TABLE `api_recibidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_recibidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
INSERT INTO `back_up_claves_details` VALUES (1,NULL,'Aliciah2011',NULL,1,40719,'2022-01-19'),(2,NULL,'Carina2022',NULL,1,40922,'2022-01-20'),(3,NULL,'1648Carlos',NULL,1,40731,'2022-02-10'),(4,NULL,'Natalia2021',NULL,1,40845,'2022-03-17'),(5,NULL,'Natalia2021',NULL,1,40845,'2022-03-17'),(6,NULL,'Natalia2021',NULL,1,40845,'2022-03-28'),(7,NULL,'Natalia2021',NULL,1,40845,'2022-03-28'),(8,NULL,'Natalia2021',NULL,1,40845,'2022-03-28'),(9,NULL,'Natalia2021',NULL,1,40845,'2022-03-29');
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'aliciahr_09@hotmail.com','3402545845',NULL,1,40719,'2021-03-18'),(2,'aliciahr_09@hotmail.com','3402545845','',1,40719,'2021-03-26'),(3,'aliciahr_09@hotmail.com','3402545845','',1,40719,'2022-01-17'),(4,'aliciahr_09@hotmail.com','3402545845','',1,40719,'2022-01-19');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `origin_id` bigint(20) unsigned DEFAULT NULL,
  `origin_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=25169 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,3117,40719,4,2,1,'App\\Models\\Receipt',1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',16500.00,NULL,NULL,1,'2021-03-18 18:41:21','2021-03-18 18:41:21',NULL),(2,3117,40719,4,2,2,'App\\Models\\Receipt',2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',10000.00,NULL,NULL,1,'2021-03-18 18:41:21','2021-03-18 18:41:21',NULL),(3,3117,40719,4,2,3,'App\\Models\\Receipt',3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',10400.00,NULL,NULL,1,'2021-03-18 18:41:21','2021-03-18 18:41:21',NULL),(4,3117,40719,4,2,4,'App\\Models\\Receipt',4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',10250.00,NULL,NULL,1,'2021-03-18 18:41:21','2021-03-18 18:41:21',NULL),(5,3117,40719,4,2,5,'App\\Models\\Receipt',5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',10250.00,NULL,NULL,1,'2021-03-18 18:41:21','2021-03-18 18:41:21',NULL),(6,3117,40719,4,2,6,'App\\Models\\Receipt',6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',10290.00,NULL,NULL,1,'2021-03-18 18:41:21','2021-03-18 18:41:21',NULL),(7,3117,40719,4,2,7,'App\\Models\\Receipt',7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',10310.00,NULL,NULL,1,'2021-03-18 18:41:21','2021-03-18 18:41:21',NULL),(8,3117,40719,4,2,8,'App\\Models\\Receipt',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',10000.00,NULL,NULL,1,'2021-03-18 18:41:21','2021-03-18 18:41:21',NULL),(9,3117,40719,3,2,9,'App\\Models\\Receipt',9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',50000.00,NULL,NULL,1,'2021-03-18 18:45:29','2021-03-18 18:45:29',NULL),(10,3117,40719,3,2,10,'App\\Models\\Receipt',10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',50000.00,NULL,NULL,1,'2021-03-18 18:45:29','2021-03-18 18:45:29',NULL),(11,3117,40719,3,2,11,'App\\Models\\Receipt',11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',10000.00,NULL,NULL,1,'2021-03-18 18:45:29','2021-03-18 18:45:29',NULL),(12,3117,40719,3,2,12,'App\\Models\\Receipt',12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',7500.00,NULL,NULL,1,'2021-03-18 18:45:29','2021-03-18 18:45:29',NULL),(13,3117,40719,3,2,13,'App\\Models\\Receipt',13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',7500.00,NULL,NULL,1,'2021-03-18 18:45:30','2021-03-18 18:45:30',NULL),(14,3117,40719,3,3,14,'App\\Models\\Receipt',14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',2182.00,NULL,NULL,1,'2021-03-18 19:21:30','2021-03-18 19:21:30',NULL),(15,3117,40719,3,3,15,'App\\Models\\Receipt',15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',23299.01,NULL,NULL,1,'2021-03-18 19:21:30','2021-03-18 19:21:30',NULL),(16,3117,40719,3,3,16,'App\\Models\\Receipt',16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',23299.01,NULL,NULL,1,'2021-03-18 19:21:30','2021-03-18 19:21:30',NULL),(17,3117,40719,3,3,17,'App\\Models\\Receipt',17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',39998.99,NULL,NULL,1,'2021-03-18 19:21:30','2021-03-18 19:21:30',NULL),(18,3117,40719,4,3,18,'App\\Models\\Receipt',18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-07','2021-02-07',24499.00,NULL,NULL,1,'2021-03-18 19:26:56','2021-03-18 19:26:56',NULL),(19,3117,40719,4,3,19,'App\\Models\\Receipt',19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',24499.00,NULL,NULL,1,'2021-03-18 19:26:56','2021-03-18 19:26:56',NULL),(20,3117,40719,4,3,20,'App\\Models\\Receipt',20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',35998.99,NULL,NULL,1,'2021-03-18 19:26:56','2021-03-18 19:26:56',NULL),(21,3117,40719,4,3,21,'App\\Models\\Receipt',21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',33999.00,NULL,NULL,1,'2021-03-18 19:26:56','2021-03-18 19:26:56',NULL),(22,3117,40719,4,3,22,'App\\Models\\Receipt',22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',24499.00,NULL,NULL,1,'2021-03-18 19:26:56','2021-03-18 19:26:56',NULL);
INSERT INTO `balance_libro` VALUES (23,3117,40719,4,3,23,'App\\Models\\Receipt',23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',24499.00,NULL,NULL,1,'2021-03-18 19:26:56','2021-03-18 19:26:56',NULL),(24,3117,40719,4,3,24,'App\\Models\\Receipt',24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',429.25,NULL,NULL,1,'2021-03-18 19:26:56','2021-03-18 19:26:56',NULL),(25,3117,40719,3,2,25,'App\\Models\\Receipt',25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',1210.00,NULL,NULL,1,'2021-03-18 21:34:31','2021-03-18 21:35:37','2021-03-18 21:35:37'),(26,3117,40719,5,2,26,'App\\Models\\Receipt',26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',3500.00,NULL,NULL,1,'2021-03-26 22:54:28','2021-03-26 22:54:28',NULL),(27,3117,40719,5,2,27,'App\\Models\\Receipt',27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',3500.00,NULL,NULL,1,'2021-03-26 22:54:28','2021-03-26 22:54:28',NULL),(28,3117,40719,5,2,28,'App\\Models\\Receipt',28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',3500.00,NULL,NULL,1,'2021-03-26 22:54:28','2021-03-26 22:54:28',NULL),(29,3117,40719,5,2,29,'App\\Models\\Receipt',29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',50000.00,NULL,NULL,1,'2021-03-26 22:54:28','2021-03-26 22:54:28',NULL),(30,3117,40719,5,3,30,'App\\Models\\Receipt',30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',32399.10,NULL,NULL,1,'2021-03-26 22:55:42','2021-03-26 22:55:42',NULL),(31,3117,40719,5,3,31,'App\\Models\\Receipt',31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',27999.00,NULL,NULL,1,'2021-03-26 22:55:42','2021-03-26 22:55:42',NULL),(40,3117,40719,6,2,40,'App\\Models\\Receipt',40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',10150.00,NULL,NULL,1,'2021-04-28 21:52:14','2021-05-04 18:23:35','2021-05-04 18:23:35'),(41,3117,40719,6,2,41,'App\\Models\\Receipt',41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',10299.00,NULL,NULL,1,'2021-04-28 21:52:14','2021-05-04 18:23:40','2021-05-04 18:23:40'),(42,3117,40719,6,2,42,'App\\Models\\Receipt',42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',9700.00,NULL,NULL,1,'2021-04-28 21:52:14','2021-05-04 18:24:45','2021-05-04 18:24:45'),(43,3117,40719,6,2,43,'App\\Models\\Receipt',43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',10400.00,NULL,NULL,1,'2021-04-28 21:52:14','2021-05-04 18:24:37','2021-05-04 18:24:37'),(44,3117,40719,6,3,44,'App\\Models\\Receipt',44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',206991.72,NULL,NULL,1,'2021-04-28 21:53:26','2021-04-28 21:53:26',NULL),(45,3117,40719,6,3,45,'App\\Models\\Receipt',45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',19199.00,NULL,NULL,1,'2021-04-28 21:53:26','2021-04-28 21:53:26',NULL),(46,3117,40719,6,3,46,'App\\Models\\Receipt',46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',4120.00,NULL,NULL,1,'2021-04-28 21:53:26','2021-04-28 21:53:26',NULL),(47,3117,40736,1530,3,47,'App\\Models\\Receipt',47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-01','2020-07-01',375.10,NULL,NULL,1,'2021-04-28 22:14:03','2021-04-28 22:14:03',NULL),(48,3117,40736,1530,3,48,'App\\Models\\Receipt',48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-01','2020-07-01',14365.00,NULL,NULL,1,'2021-04-28 22:14:03','2021-04-28 22:14:03',NULL),(49,3117,40736,1530,3,49,'App\\Models\\Receipt',49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-03','2020-07-03',5267.00,NULL,NULL,1,'2021-04-28 22:14:03','2021-04-28 22:14:03',NULL),(50,3117,40736,1530,3,50,'App\\Models\\Receipt',50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-13','2020-07-13',375.10,NULL,NULL,1,'2021-04-28 22:14:03','2021-04-28 22:14:03',NULL),(51,3117,40736,1530,3,51,'App\\Models\\Receipt',51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-13','2020-07-13',20221.50,NULL,NULL,1,'2021-04-28 22:14:03','2021-04-28 22:14:03',NULL);
INSERT INTO `balance_libro` VALUES (52,3117,40736,1530,3,52,'App\\Models\\Receipt',52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-23','2020-07-23',20264.55,NULL,NULL,1,'2021-04-28 22:14:03','2021-04-28 22:14:03',NULL),(53,3117,40736,1530,2,53,'App\\Models\\Receipt',53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',7210.00,NULL,NULL,1,'2021-04-28 22:15:52','2021-04-28 22:15:52',NULL),(54,3117,40736,1530,2,54,'App\\Models\\Receipt',54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',7335.00,NULL,NULL,1,'2021-04-28 22:15:52','2021-04-28 22:15:52',NULL),(55,3117,40736,1530,2,55,'App\\Models\\Receipt',55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',7449.00,NULL,NULL,1,'2021-04-28 22:15:52','2021-04-28 22:15:52',NULL),(56,3117,40736,1531,2,56,'App\\Models\\Receipt',56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-27','2020-08-27',8105.00,NULL,NULL,1,'2021-04-28 22:17:31','2021-04-28 22:17:31',NULL),(57,3117,40736,1531,2,57,'App\\Models\\Receipt',57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-28','2020-08-28',8004.00,NULL,NULL,1,'2021-04-28 22:17:31','2021-04-28 22:17:31',NULL),(58,3117,40736,1531,2,58,'App\\Models\\Receipt',58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-29','2020-08-29',7999.00,NULL,NULL,1,'2021-04-28 22:17:31','2021-04-28 22:17:31',NULL),(59,3117,40736,1532,2,59,'App\\Models\\Receipt',59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-29','2020-09-29',8100.00,NULL,NULL,1,'2021-04-28 22:18:25','2021-04-28 22:18:25',NULL),(60,3117,40736,1532,2,60,'App\\Models\\Receipt',60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-29','2020-09-29',8400.00,NULL,NULL,1,'2021-04-28 22:18:25','2021-04-28 22:18:25',NULL),(61,3117,40736,1532,2,61,'App\\Models\\Receipt',61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',8430.00,NULL,NULL,1,'2021-04-28 22:18:25','2021-04-28 22:18:25',NULL),(62,3117,40736,1532,2,62,'App\\Models\\Receipt',62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',8180.00,NULL,NULL,1,'2021-04-28 22:18:25','2021-04-28 22:18:25',NULL),(63,3117,40736,1532,2,63,'App\\Models\\Receipt',63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',8009.00,NULL,NULL,1,'2021-04-28 22:18:25','2021-04-28 22:18:25',NULL),(64,3117,40736,1533,2,64,'App\\Models\\Receipt',64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-28','2020-10-28',8110.00,NULL,NULL,1,'2021-04-28 22:19:33','2021-04-28 22:19:33',NULL),(65,3117,40736,1533,2,65,'App\\Models\\Receipt',65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-28','2020-10-28',8225.00,NULL,NULL,1,'2021-04-28 22:19:33','2021-04-28 22:19:33',NULL),(66,3117,40736,1533,2,66,'App\\Models\\Receipt',66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-28','2020-10-28',8369.00,NULL,NULL,1,'2021-04-28 22:19:33','2021-04-28 22:19:33',NULL),(67,3117,40736,1533,2,67,'App\\Models\\Receipt',67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-29','2020-10-29',8540.00,NULL,NULL,1,'2021-04-28 22:19:33','2021-04-28 22:19:33',NULL),(68,3117,40736,1533,2,68,'App\\Models\\Receipt',68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-29','2020-10-29',8477.00,NULL,NULL,1,'2021-04-28 22:19:33','2021-04-28 22:19:33',NULL),(69,3117,40736,1533,2,69,'App\\Models\\Receipt',69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-30','2020-10-30',8420.00,NULL,NULL,1,'2021-04-28 22:19:33','2021-04-28 22:19:33',NULL),(70,3117,40736,1533,2,70,'App\\Models\\Receipt',70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-30','2020-10-30',8357.00,NULL,NULL,1,'2021-04-28 22:19:33','2021-04-28 22:19:33',NULL),(71,3117,40736,1533,2,71,'App\\Models\\Receipt',71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',8555.00,NULL,NULL,1,'2021-04-28 22:19:33','2021-04-28 22:19:33',NULL),(72,3117,40736,1534,2,72,'App\\Models\\Receipt',72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-28','2020-11-28',8433.00,NULL,NULL,1,'2021-04-28 22:20:32','2021-04-28 22:20:32',NULL);
INSERT INTO `balance_libro` VALUES (73,3117,40736,1534,2,73,'App\\Models\\Receipt',73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-28','2020-11-28',8334.00,NULL,NULL,1,'2021-04-28 22:20:32','2021-04-28 22:20:32',NULL),(74,3117,40736,1534,2,74,'App\\Models\\Receipt',74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-28','2020-11-28',8113.00,NULL,NULL,1,'2021-04-28 22:20:32','2021-04-28 22:20:32',NULL),(75,3117,40736,1534,2,75,'App\\Models\\Receipt',75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',8365.00,NULL,NULL,1,'2021-04-28 22:20:32','2021-04-28 22:20:32',NULL),(76,3117,40736,1534,2,76,'App\\Models\\Receipt',76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',8470.00,NULL,NULL,1,'2021-04-28 22:20:32','2021-04-28 22:20:32',NULL),(77,3117,40736,1534,2,77,'App\\Models\\Receipt',77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',8425.00,NULL,NULL,1,'2021-04-28 22:20:32','2021-04-28 22:20:32',NULL),(78,3117,40736,1535,2,78,'App\\Models\\Receipt',78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-26','2020-12-26',8550.00,NULL,NULL,1,'2021-04-28 22:21:22','2021-04-28 22:21:22',NULL),(79,3117,40736,1535,2,79,'App\\Models\\Receipt',79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-26','2020-12-26',8378.00,NULL,NULL,1,'2021-04-28 22:21:22','2021-04-28 22:21:22',NULL),(80,3117,40736,1535,2,80,'App\\Models\\Receipt',80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-28','2020-12-28',8499.00,NULL,NULL,1,'2021-04-28 22:21:22','2021-04-28 22:21:22',NULL),(81,3117,40736,1535,2,81,'App\\Models\\Receipt',81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-29','2020-12-29',8467.00,NULL,NULL,1,'2021-04-28 22:21:22','2021-04-28 22:21:22',NULL),(82,3117,40736,1535,2,82,'App\\Models\\Receipt',82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',8471.00,NULL,NULL,1,'2021-04-28 22:21:22','2021-04-28 22:21:22',NULL),(83,3117,40736,1535,2,83,'App\\Models\\Receipt',83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',8588.00,NULL,NULL,1,'2021-04-28 22:21:22','2021-04-28 22:21:22',NULL),(84,3117,40736,1537,2,84,'App\\Models\\Receipt',84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',8450.00,NULL,NULL,1,'2021-04-28 22:22:43','2021-04-28 22:22:43',NULL),(85,3117,40736,1537,2,85,'App\\Models\\Receipt',85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',7610.00,NULL,NULL,1,'2021-04-28 22:22:43','2021-04-28 22:22:43',NULL),(86,3117,40736,1537,2,86,'App\\Models\\Receipt',86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',8230.00,NULL,NULL,1,'2021-04-28 22:22:43','2021-04-28 22:22:43',NULL),(87,3117,40736,1537,2,87,'App\\Models\\Receipt',87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',3001.00,NULL,NULL,1,'2021-04-28 22:22:43','2021-04-28 22:22:43',NULL),(88,3117,40736,1539,2,88,'App\\Models\\Receipt',88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',10380.00,NULL,NULL,1,'2021-04-28 22:29:54','2021-04-28 22:29:54',NULL),(89,3117,40736,1539,2,89,'App\\Models\\Receipt',89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',10410.00,NULL,NULL,1,'2021-04-28 22:29:54','2021-04-28 22:29:54',NULL),(90,3117,40736,1539,2,90,'App\\Models\\Receipt',90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',10409.00,NULL,NULL,1,'2021-04-28 22:29:54','2021-04-28 22:29:54',NULL),(91,3117,40736,1539,2,91,'App\\Models\\Receipt',91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',10399.00,NULL,NULL,1,'2021-04-28 22:29:54','2021-04-28 22:29:54',NULL),(92,3117,40736,1539,2,92,'App\\Models\\Receipt',92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',10387.00,NULL,NULL,1,'2021-04-28 22:29:54','2021-04-28 22:29:54',NULL),(93,3117,40736,1539,2,93,'App\\Models\\Receipt',93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',10405.00,NULL,NULL,1,'2021-04-28 22:29:54','2021-04-28 22:29:54',NULL);
INSERT INTO `balance_libro` VALUES (94,3117,40736,1539,2,94,'App\\Models\\Receipt',94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',10110.00,NULL,NULL,1,'2021-04-28 22:29:54','2021-04-28 22:29:54',NULL),(95,3117,40736,1539,2,95,'App\\Models\\Receipt',95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',2500.00,NULL,NULL,1,'2021-04-28 22:30:09','2021-05-04 17:44:43','2021-05-04 17:44:43'),(96,3117,40736,1539,2,96,'App\\Models\\Receipt',96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',10100.00,NULL,NULL,1,'2021-04-28 22:30:09','2021-05-04 17:44:51','2021-05-04 17:44:51'),(97,3117,40736,1539,2,97,'App\\Models\\Receipt',97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',10210.00,NULL,NULL,1,'2021-04-28 22:30:09','2021-05-04 17:45:11','2021-05-04 17:45:11'),(98,3117,40736,1539,2,98,'App\\Models\\Receipt',98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',10250.00,NULL,NULL,1,'2021-04-28 22:30:09','2021-05-04 17:43:14','2021-05-04 17:43:14'),(99,3117,40736,1540,3,99,'App\\Models\\Receipt',99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',30719.00,NULL,NULL,1,'2021-05-04 17:36:30','2021-05-04 17:36:30',NULL),(100,3117,40736,1540,3,100,'App\\Models\\Receipt',100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',5244.00,NULL,NULL,1,'2021-05-04 17:36:30','2021-05-04 17:36:30',NULL),(101,3117,40736,1540,3,101,'App\\Models\\Receipt',101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',26133.25,NULL,NULL,1,'2021-05-04 17:36:30','2021-05-04 17:36:30',NULL),(102,3117,40736,1540,3,102,'App\\Models\\Receipt',102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',26243.75,NULL,NULL,1,'2021-05-04 17:36:30','2021-05-04 17:36:30',NULL),(103,3117,40736,1539,2,98,'App\\Models\\Receipt',98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',10250.00,NULL,NULL,1,'2021-05-04 17:43:14','2021-05-04 17:43:24','2021-05-04 17:43:24'),(104,3117,40736,1539,2,98,'App\\Models\\Receipt',98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',10250.00,NULL,NULL,1,'2021-05-04 17:43:24','2021-05-04 17:43:35','2021-05-04 17:43:35'),(105,3117,40736,1539,2,98,'App\\Models\\Receipt',98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',10250.00,NULL,NULL,1,'2021-05-04 17:43:35','2021-05-04 17:43:43','2021-05-04 17:43:43'),(106,3117,40736,1539,2,98,'App\\Models\\Receipt',98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',10250.00,NULL,NULL,1,'2021-05-04 17:43:43','2021-05-04 17:43:50','2021-05-04 17:43:50'),(107,3117,40736,1539,2,98,'App\\Models\\Receipt',98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',10250.00,NULL,NULL,1,'2021-05-04 17:43:50','2021-05-04 17:44:19','2021-05-04 17:44:19'),(108,3117,40736,1539,2,98,'App\\Models\\Receipt',98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',10250.00,NULL,NULL,1,'2021-05-04 17:44:19','2021-05-04 17:44:30','2021-05-04 17:44:30'),(109,3117,40736,1539,2,98,'App\\Models\\Receipt',98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',10250.00,NULL,NULL,1,'2021-05-04 17:44:30','2021-05-04 17:45:14','2021-05-04 17:45:14'),(110,3117,40736,1538,2,103,'App\\Models\\Receipt',103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',2500.00,NULL,NULL,1,'2021-05-04 17:55:43','2021-05-04 17:55:43',NULL),(111,3117,40736,1538,2,104,'App\\Models\\Receipt',104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',10100.00,NULL,NULL,1,'2021-05-04 17:55:43','2021-05-04 17:55:43',NULL),(112,3117,40736,1538,2,105,'App\\Models\\Receipt',105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',10210.00,NULL,NULL,1,'2021-05-04 17:55:43','2021-05-04 17:55:43',NULL),(113,3117,40736,1538,2,106,'App\\Models\\Receipt',106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',10250.00,NULL,NULL,1,'2021-05-04 17:55:43','2021-05-04 17:55:43',NULL);
INSERT INTO `balance_libro` VALUES (114,3117,40736,1531,3,107,'App\\Models\\Receipt',107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-04','2020-08-04',3524.00,NULL,NULL,1,'2021-05-04 17:57:29','2021-05-04 17:57:29',NULL),(115,3117,40736,1531,3,108,'App\\Models\\Receipt',108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-12','2020-08-12',33647.26,NULL,NULL,1,'2021-05-04 17:57:29','2021-05-04 17:57:29',NULL),(116,3117,40736,1531,3,109,'App\\Models\\Receipt',109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-26','2020-08-26',16326.38,NULL,NULL,1,'2021-05-04 17:57:29','2021-05-04 17:57:29',NULL),(117,3117,40736,1532,3,110,'App\\Models\\Receipt',110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-02','2020-09-02',376.31,NULL,NULL,1,'2021-05-04 17:58:28','2021-05-04 17:58:28',NULL),(118,3117,40736,1532,3,111,'App\\Models\\Receipt',111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-02','2020-09-02',16602.63,NULL,NULL,1,'2021-05-04 17:58:28','2021-05-04 17:58:28',NULL),(119,3117,40736,1532,3,112,'App\\Models\\Receipt',112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-03','2020-09-03',4396.00,NULL,NULL,1,'2021-05-04 17:58:28','2021-05-04 17:58:28',NULL),(120,3117,40736,1532,3,113,'App\\Models\\Receipt',113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-18','2020-09-18',19923.15,NULL,NULL,1,'2021-05-04 17:58:28','2021-05-04 17:58:28',NULL),(121,3117,40736,1532,3,114,'App\\Models\\Receipt',114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-28','2020-09-28',3984.63,NULL,NULL,1,'2021-05-04 17:58:28','2021-05-04 17:58:28',NULL),(122,3117,40736,1533,3,115,'App\\Models\\Receipt',115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-03','2020-10-03',17403.75,NULL,NULL,1,'2021-05-04 17:59:19','2021-05-04 17:59:19',NULL),(123,3117,40736,1533,3,116,'App\\Models\\Receipt',116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-05','2020-10-05',4396.00,NULL,NULL,1,'2021-05-04 17:59:19','2021-05-04 17:59:19',NULL),(124,3117,40736,1533,3,117,'App\\Models\\Receipt',117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-10','2020-10-10',23205.00,NULL,NULL,1,'2021-05-04 17:59:19','2021-05-04 17:59:19',NULL),(125,3117,40736,1533,3,118,'App\\Models\\Receipt',118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-23','2020-10-23',25470.25,NULL,NULL,1,'2021-05-04 17:59:19','2021-05-04 17:59:19',NULL),(126,3117,40736,1534,3,119,'App\\Models\\Receipt',119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-04','2020-11-04',24199.50,NULL,NULL,1,'2021-05-04 18:00:24','2021-05-04 18:00:24',NULL),(127,3117,40736,1534,3,120,'App\\Models\\Receipt',120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-04','2020-11-04',4396.00,NULL,NULL,1,'2021-05-04 18:00:24','2021-05-04 18:00:24',NULL),(128,3117,40736,1534,3,121,'App\\Models\\Receipt',121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-26','2020-11-26',15470.00,NULL,NULL,1,'2021-05-04 18:00:24','2021-05-04 18:00:24',NULL),(129,3117,40736,1535,3,122,'App\\Models\\Receipt',122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-03','2020-12-03',5009.00,NULL,NULL,1,'2021-05-04 18:01:13','2021-05-04 18:01:13',NULL),(130,3117,40736,1535,3,123,'App\\Models\\Receipt',123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-15','2020-12-15',23757.50,NULL,NULL,1,'2021-05-04 18:01:13','2021-05-04 18:01:13',NULL),(131,3117,40736,1535,3,124,'App\\Models\\Receipt',124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-22','2020-12-22',15470.00,NULL,NULL,1,'2021-05-04 18:01:13','2021-05-04 18:01:13',NULL),(132,3117,40736,1535,3,125,'App\\Models\\Receipt',125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-22','2020-12-22',871.20,NULL,NULL,1,'2021-05-04 18:01:13','2021-05-04 18:01:13',NULL),(133,3117,40736,1535,3,126,'App\\Models\\Receipt',126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-29','2020-12-29',15470.00,NULL,NULL,1,'2021-05-04 18:01:13','2021-05-04 18:01:13',NULL),(134,3117,40736,1537,3,127,'App\\Models\\Receipt',127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',5009.00,NULL,NULL,1,'2021-05-04 18:02:03','2021-05-04 18:02:03',NULL);
INSERT INTO `balance_libro` VALUES (135,3117,40736,1537,3,128,'App\\Models\\Receipt',128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',11602.50,NULL,NULL,1,'2021-05-04 18:02:03','2021-05-04 18:02:03',NULL),(136,3117,40736,1538,3,129,'App\\Models\\Receipt',129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',5009.00,NULL,NULL,1,'2021-05-04 18:03:04','2021-05-04 18:03:04',NULL),(137,3117,40736,1538,3,130,'App\\Models\\Receipt',130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',19500.00,NULL,NULL,1,'2021-05-04 18:03:04','2021-05-04 18:03:04',NULL),(138,3117,40736,1538,3,131,'App\\Models\\Receipt',131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',41500.00,NULL,NULL,1,'2021-05-04 18:03:04','2021-05-04 18:03:04',NULL),(139,3117,40736,1538,3,132,'App\\Models\\Receipt',132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',41500.00,NULL,NULL,1,'2021-05-04 18:03:04','2021-05-04 18:03:04',NULL),(140,3117,40736,1538,3,133,'App\\Models\\Receipt',133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',22100.00,NULL,NULL,1,'2021-05-04 18:03:04','2021-05-04 18:03:04',NULL),(141,3117,40736,1538,3,134,'App\\Models\\Receipt',134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',26520.00,NULL,NULL,1,'2021-05-04 18:03:04','2021-05-04 18:03:04',NULL),(142,3117,40736,1539,3,135,'App\\Models\\Receipt',135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',5244.00,NULL,NULL,1,'2021-05-04 18:04:49','2021-05-04 18:04:49',NULL),(143,3117,40736,1539,3,136,'App\\Models\\Receipt',136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',39614.25,NULL,NULL,1,'2021-05-04 18:04:49','2021-05-04 18:04:49',NULL),(144,3117,40736,1539,3,137,'App\\Models\\Receipt',137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',1089.00,NULL,NULL,1,'2021-05-04 18:04:49','2021-05-04 18:04:49',NULL),(145,3117,40736,1539,3,138,'App\\Models\\Receipt',138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',30746.63,NULL,NULL,1,'2021-05-04 18:04:49','2021-05-04 18:04:49',NULL),(146,3117,40736,1540,2,139,'App\\Models\\Receipt',139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',10358.00,NULL,NULL,1,'2021-05-04 18:09:23','2021-05-04 18:09:23',NULL),(147,3117,40736,1540,2,140,'App\\Models\\Receipt',140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',10338.00,NULL,NULL,1,'2021-05-04 18:09:23','2021-05-04 18:09:23',NULL),(148,3117,40736,1540,2,141,'App\\Models\\Receipt',141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',10390.00,NULL,NULL,1,'2021-05-04 18:09:23','2021-05-04 18:09:23',NULL),(149,3117,40736,1540,2,142,'App\\Models\\Receipt',142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',10399.00,NULL,NULL,1,'2021-05-04 18:09:23','2021-05-04 18:09:23',NULL),(150,3117,40736,1540,2,143,'App\\Models\\Receipt',143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',10259.00,NULL,NULL,1,'2021-05-04 18:09:23','2021-05-04 18:09:23',NULL),(151,3117,40736,1540,2,144,'App\\Models\\Receipt',144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',10400.00,NULL,NULL,1,'2021-05-04 18:09:23','2021-05-04 18:09:23',NULL),(152,3117,40736,1540,2,145,'App\\Models\\Receipt',145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',10389.00,NULL,NULL,1,'2021-05-04 18:09:23','2021-05-04 18:09:23',NULL),(153,3117,40736,1540,2,146,'App\\Models\\Receipt',146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',10377.00,NULL,NULL,1,'2021-05-04 18:09:23','2021-05-04 18:09:23',NULL),(154,3117,40736,1540,2,147,'App\\Models\\Receipt',147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',10355.00,NULL,NULL,1,'2021-05-04 18:09:23','2021-05-04 18:09:23',NULL),(155,3117,40719,6,2,148,'App\\Models\\Receipt',148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',10150.00,NULL,NULL,1,'2021-05-04 18:25:32','2021-05-04 18:25:32',NULL);
INSERT INTO `balance_libro` VALUES (156,3117,40719,6,2,149,'App\\Models\\Receipt',149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',10299.00,NULL,NULL,1,'2021-05-04 18:25:32','2021-05-04 18:25:32',NULL),(157,3117,40719,6,2,150,'App\\Models\\Receipt',150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',9700.00,NULL,NULL,1,'2021-05-04 18:25:32','2021-05-04 18:25:32',NULL),(158,3117,40719,6,2,151,'App\\Models\\Receipt',151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',10400.00,NULL,NULL,1,'2021-05-04 18:25:32','2021-05-04 18:25:32',NULL),(159,3117,40719,6,2,152,'App\\Models\\Receipt',152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',10150.00,NULL,NULL,1,'2021-05-04 18:25:32','2021-05-04 18:25:32',NULL),(160,3117,40719,6,2,153,'App\\Models\\Receipt',153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',10400.00,NULL,NULL,1,'2021-05-04 18:25:32','2021-05-04 18:25:32',NULL),(161,3117,40719,6,2,154,'App\\Models\\Receipt',154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',10250.00,NULL,NULL,1,'2021-05-04 18:25:32','2021-05-04 18:25:32',NULL),(162,3117,40719,6,2,155,'App\\Models\\Receipt',155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',26000.00,NULL,NULL,1,'2021-05-04 18:25:32','2021-05-04 18:25:32',NULL),(163,3117,40719,6,2,156,'App\\Models\\Receipt',156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',7850.00,NULL,NULL,1,'2021-05-04 18:25:32','2021-05-04 18:25:32',NULL),(164,3117,40731,3050,2,157,'App\\Models\\Receipt',157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',2103.00,NULL,NULL,1,'2021-05-05 18:20:02','2021-05-05 18:20:02',NULL),(165,3117,40731,3050,2,158,'App\\Models\\Receipt',158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',1985.00,NULL,NULL,1,'2021-05-05 18:20:02','2021-05-05 18:20:02',NULL),(166,3117,40731,3050,2,159,'App\\Models\\Receipt',159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',2090.00,NULL,NULL,1,'2021-05-05 18:20:02','2021-05-05 18:20:02',NULL),(167,3117,40731,3050,2,160,'App\\Models\\Receipt',160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',1879.00,NULL,NULL,1,'2021-05-05 18:20:02','2021-05-05 18:20:02',NULL),(168,3117,40731,3050,2,161,'App\\Models\\Receipt',161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',2099.00,NULL,NULL,1,'2021-05-05 18:20:02','2021-05-05 18:20:02',NULL),(169,3117,40731,3050,2,162,'App\\Models\\Receipt',162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',1566.00,NULL,NULL,1,'2021-05-05 18:20:02','2021-05-05 18:20:02',NULL),(170,3117,40731,3050,2,163,'App\\Models\\Receipt',163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',10308.00,NULL,NULL,1,'2021-05-05 18:20:02','2021-05-05 18:20:02',NULL),(171,3117,40731,3050,2,164,'App\\Models\\Receipt',164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',10100.00,NULL,NULL,1,'2021-05-05 18:20:02','2021-05-05 18:20:02',NULL),(172,3117,40731,3050,2,165,'App\\Models\\Receipt',165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',10199.00,NULL,NULL,1,'2021-05-05 18:20:02','2021-05-05 18:20:02',NULL),(173,3117,40731,3050,2,166,'App\\Models\\Receipt',166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',10289.00,NULL,NULL,1,'2021-05-05 18:20:02','2021-05-05 18:20:02',NULL),(174,3117,40731,3049,2,167,'App\\Models\\Receipt',167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',950.00,NULL,NULL,1,'2021-05-05 18:20:42','2021-05-05 18:20:42',NULL),(175,3117,40731,3049,2,168,'App\\Models\\Receipt',168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',1110.00,NULL,NULL,1,'2021-05-05 18:20:42','2021-05-05 18:20:42',NULL),(176,3117,40731,3049,2,169,'App\\Models\\Receipt',169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',1090.00,NULL,NULL,1,'2021-05-05 18:20:42','2021-05-05 18:20:42',NULL);
INSERT INTO `balance_libro` VALUES (177,3117,40731,3049,2,170,'App\\Models\\Receipt',170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-24','2021-03-24',1288.00,NULL,NULL,1,'2021-05-05 18:20:42','2021-05-05 18:20:42',NULL),(178,3117,40731,3049,2,171,'App\\Models\\Receipt',171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',1175.00,NULL,NULL,1,'2021-05-05 18:20:42','2021-05-05 18:20:42',NULL),(179,3117,40731,3050,3,172,'App\\Models\\Receipt',172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',9586.38,NULL,NULL,1,'2021-05-05 18:21:43','2021-05-05 18:21:43',NULL),(180,3117,40731,3050,3,173,'App\\Models\\Receipt',173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-04','2021-04-04',620.00,NULL,NULL,1,'2021-05-05 18:21:43','2021-05-05 18:21:43',NULL),(181,3117,40731,3050,3,174,'App\\Models\\Receipt',174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',8869.91,NULL,NULL,1,'2021-05-05 18:21:43','2021-05-05 18:21:43',NULL),(182,3117,40731,3050,3,175,'App\\Models\\Receipt',175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',1080.36,NULL,NULL,1,'2021-05-05 18:21:43','2021-05-05 18:21:43',NULL),(183,3117,40731,3050,3,176,'App\\Models\\Receipt',176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',2210.52,NULL,NULL,1,'2021-05-05 18:21:43','2021-05-05 18:21:43',NULL),(184,3117,40731,3050,3,177,'App\\Models\\Receipt',177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',8708.50,NULL,NULL,1,'2021-05-05 18:21:43','2021-05-05 18:21:43',NULL),(185,3117,40731,3050,3,178,'App\\Models\\Receipt',178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',365.00,NULL,NULL,1,'2021-05-05 18:21:43','2021-05-05 18:25:47','2021-05-05 18:25:47'),(186,3117,40731,3050,3,179,'App\\Models\\Receipt',179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',4059.53,NULL,NULL,1,'2021-05-05 18:21:43','2021-05-05 18:21:43',NULL),(187,3117,40731,3050,3,180,'App\\Models\\Receipt',180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',10227.95,NULL,NULL,1,'2021-05-05 18:21:43','2021-05-05 18:21:43',NULL),(188,3117,40731,3050,3,181,'App\\Models\\Receipt',181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',8198.48,NULL,NULL,1,'2021-05-05 18:21:43','2021-05-05 18:21:43',NULL),(189,3117,40731,3050,3,182,'App\\Models\\Receipt',182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',7421.91,NULL,NULL,1,'2021-05-05 18:21:43','2021-05-05 18:21:43',NULL),(190,3117,40731,3050,3,183,'App\\Models\\Receipt',183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',857.93,NULL,NULL,1,'2021-05-05 18:21:43','2021-05-05 18:21:43',NULL),(191,3117,40731,3050,3,184,'App\\Models\\Receipt',184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',5701.91,NULL,NULL,1,'2021-05-05 18:21:43','2021-05-05 18:21:43',NULL),(192,3117,40731,3050,3,185,'App\\Models\\Receipt',185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',169.00,NULL,NULL,1,'2021-05-05 18:21:43','2021-05-05 18:21:43',NULL),(193,3117,40731,3050,3,186,'App\\Models\\Receipt',186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',1050.09,NULL,NULL,1,'2021-05-05 18:21:43','2021-05-05 18:21:43',NULL),(194,3117,40731,3050,3,187,'App\\Models\\Receipt',187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',1849.79,NULL,NULL,1,'2021-05-05 18:21:43','2021-05-05 18:21:43',NULL),(195,3117,40731,3050,3,188,'App\\Models\\Receipt',188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',13164.64,NULL,NULL,1,'2021-05-05 18:21:43','2021-05-05 18:21:43',NULL),(196,3117,40731,3049,3,189,'App\\Models\\Receipt',189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',3500.00,NULL,NULL,1,'2021-05-05 18:22:52','2021-05-05 18:22:52',NULL),(197,3117,40731,3049,3,190,'App\\Models\\Receipt',190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',7857.51,NULL,NULL,1,'2021-05-05 18:22:52','2021-05-05 18:22:52',NULL);
INSERT INTO `balance_libro` VALUES (198,3117,40731,3049,3,191,'App\\Models\\Receipt',191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',4024.31,NULL,NULL,1,'2021-05-05 18:22:52','2021-05-05 18:22:52',NULL),(199,3117,40731,3049,3,192,'App\\Models\\Receipt',192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',4156.91,NULL,NULL,1,'2021-05-05 18:22:52','2021-05-05 18:22:52',NULL),(200,3117,40731,3049,3,193,'App\\Models\\Receipt',193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',14752.75,NULL,NULL,1,'2021-05-05 18:22:52','2021-05-05 18:22:52',NULL),(201,3117,40731,3049,3,194,'App\\Models\\Receipt',194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',1369.28,NULL,NULL,1,'2021-05-05 18:22:52','2021-05-05 18:22:52',NULL),(202,3117,40731,3049,3,195,'App\\Models\\Receipt',195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',15168.40,NULL,NULL,1,'2021-05-05 18:22:52','2021-05-05 18:22:52',NULL),(203,3117,40731,3049,3,196,'App\\Models\\Receipt',196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',11010.72,NULL,NULL,1,'2021-05-05 18:22:52','2021-05-05 18:22:52',NULL),(204,3117,40731,3049,3,197,'App\\Models\\Receipt',197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',11530.58,NULL,NULL,1,'2021-05-05 18:22:52','2021-05-05 18:22:52',NULL),(205,3117,40731,3050,3,178,'App\\Models\\Receipt',178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',365.00,NULL,NULL,1,'2021-05-05 18:25:47','2021-05-05 18:29:09','2021-05-05 18:29:09'),(206,3117,40736,1540,8,198,'App\\Models\\Receipt',198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',45.00,NULL,NULL,1,'2021-05-11 18:46:16','2021-05-11 18:46:16',NULL),(207,3117,40736,1540,8,199,'App\\Models\\Receipt',199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',0.00,NULL,NULL,1,'2021-05-11 18:46:20','2021-05-11 18:46:20',NULL),(208,3117,40736,1540,16,69,'App\\Models\\PeriodLiquidation',NULL,69,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',2331.63,NULL,NULL,1,'2021-05-11 18:46:44','2021-05-11 18:46:44',NULL),(209,3117,40719,1524,2,200,'App\\Models\\Receipt',200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-16','2020-07-16',2500.00,NULL,NULL,1,'2021-05-29 18:31:21','2021-05-29 18:31:21',NULL),(210,3117,40719,1524,2,201,'App\\Models\\Receipt',201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-16','2020-07-16',1500.00,NULL,NULL,1,'2021-05-29 18:31:21','2021-05-29 18:31:21',NULL),(211,3117,40719,1524,2,202,'App\\Models\\Receipt',202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-23','2020-07-23',15000.00,NULL,NULL,1,'2021-05-29 18:31:21','2021-05-29 18:31:21',NULL),(212,3117,40719,1524,2,203,'App\\Models\\Receipt',203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-30','2020-07-30',18000.00,NULL,NULL,1,'2021-05-29 18:31:21','2021-05-29 18:31:21',NULL),(213,3117,40719,1525,2,204,'App\\Models\\Receipt',204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-14','2020-08-14',15000.00,NULL,NULL,1,'2021-05-29 18:32:58','2021-05-29 18:32:58',NULL),(214,3117,40719,1525,2,205,'App\\Models\\Receipt',205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-21','2020-08-21',4104.00,NULL,NULL,1,'2021-05-29 18:32:58','2021-05-29 18:32:58',NULL),(215,3117,40719,1525,2,206,'App\\Models\\Receipt',206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-28','2020-08-28',19000.00,NULL,NULL,1,'2021-05-29 18:32:58','2021-05-29 18:32:58',NULL),(216,3117,40719,1525,2,207,'App\\Models\\Receipt',207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-29','2020-08-29',7800.00,NULL,NULL,1,'2021-05-29 18:32:58','2021-05-29 18:32:58',NULL),(217,3117,40719,1525,2,208,'App\\Models\\Receipt',208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',5900.00,NULL,NULL,1,'2021-05-29 18:32:58','2021-05-29 18:32:58',NULL),(218,3117,40719,1525,2,209,'App\\Models\\Receipt',209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',6000.00,NULL,NULL,1,'2021-05-29 18:32:58','2021-05-29 18:32:58',NULL);
INSERT INTO `balance_libro` VALUES (219,3117,40719,1526,2,210,'App\\Models\\Receipt',210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-25','2020-09-25',7700.00,NULL,NULL,1,'2021-05-29 18:34:22','2021-05-29 18:34:22',NULL),(220,3117,40719,1526,2,211,'App\\Models\\Receipt',211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-28','2020-09-28',22500.00,NULL,NULL,1,'2021-05-29 18:34:22','2021-05-29 18:34:22',NULL),(221,3117,40719,1526,2,212,'App\\Models\\Receipt',212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-29','2020-09-29',42500.00,NULL,NULL,1,'2021-05-29 18:34:22','2021-05-29 18:34:22',NULL),(222,3117,40719,1526,2,213,'App\\Models\\Receipt',213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',15000.00,NULL,NULL,1,'2021-05-29 18:34:22','2021-05-29 18:34:22',NULL),(223,3117,40719,1527,2,214,'App\\Models\\Receipt',214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-06','2020-10-06',16000.00,NULL,NULL,1,'2021-05-29 18:35:55','2021-05-29 18:35:55',NULL),(224,3117,40719,1527,2,215,'App\\Models\\Receipt',215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-14','2020-10-14',52500.00,NULL,NULL,1,'2021-05-29 18:35:55','2021-05-29 18:35:55',NULL),(225,3117,40719,1527,2,216,'App\\Models\\Receipt',216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-21','2020-10-21',5500.00,NULL,NULL,1,'2021-05-29 18:35:55','2021-05-29 18:35:55',NULL),(226,3117,40719,1527,2,217,'App\\Models\\Receipt',217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-23','2020-10-23',20000.00,NULL,NULL,1,'2021-05-29 18:35:55','2021-05-29 18:35:55',NULL),(227,3117,40719,1527,2,218,'App\\Models\\Receipt',218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-26','2020-10-26',35858.00,NULL,NULL,1,'2021-05-29 18:35:55','2021-05-29 18:35:55',NULL),(228,3117,40719,1529,2,219,'App\\Models\\Receipt',219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-11','2020-12-11',28737.43,NULL,NULL,1,'2021-05-29 18:40:32','2021-05-29 18:40:32',NULL),(229,3117,40719,1529,2,220,'App\\Models\\Receipt',220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-11','2020-12-11',6600.00,NULL,NULL,1,'2021-05-29 18:40:32','2021-05-29 18:40:32',NULL),(230,3117,40719,1529,2,221,'App\\Models\\Receipt',221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-15','2020-12-15',40500.00,NULL,NULL,1,'2021-05-29 18:40:32','2021-05-29 18:40:32',NULL),(231,3117,40719,1529,2,222,'App\\Models\\Receipt',222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-26','2020-12-26',45000.00,NULL,NULL,1,'2021-05-29 18:40:32','2021-05-29 18:40:32',NULL),(232,3117,40719,1529,2,223,'App\\Models\\Receipt',223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',50000.00,NULL,NULL,1,'2021-05-29 18:40:32','2021-05-29 18:40:32',NULL),(233,3117,40719,1529,2,224,'App\\Models\\Receipt',224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-02','2020-11-02',1500.00,NULL,NULL,1,'2021-05-29 18:40:50','2021-05-29 18:53:48','2021-05-29 18:53:48'),(234,3117,40719,1529,2,225,'App\\Models\\Receipt',225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-16','2020-11-16',30500.00,NULL,NULL,1,'2021-05-29 18:40:50','2021-05-29 18:53:58','2021-05-29 18:53:58'),(235,3117,40719,1529,2,226,'App\\Models\\Receipt',226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-18','2020-11-18',18000.00,NULL,NULL,1,'2021-05-29 18:40:50','2021-05-29 18:54:05','2021-05-29 18:54:05'),(236,3117,40719,1529,2,227,'App\\Models\\Receipt',227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',19000.00,NULL,NULL,1,'2021-05-29 18:40:50','2021-05-29 18:54:11','2021-05-29 18:54:11'),(237,3117,40719,1524,3,228,'App\\Models\\Receipt',228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-02','2020-07-02',3899.00,NULL,NULL,1,'2021-05-29 18:41:07','2021-05-29 18:41:07',NULL),(238,3117,40719,1524,3,229,'App\\Models\\Receipt',229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-08','2020-07-08',33998.00,NULL,NULL,1,'2021-05-29 18:41:07','2021-05-29 18:41:07',NULL),(239,3117,40719,1524,3,230,'App\\Models\\Receipt',230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-10','2020-07-10',28998.00,NULL,NULL,1,'2021-05-29 18:41:07','2021-05-29 18:41:07',NULL);
INSERT INTO `balance_libro` VALUES (240,3117,40719,1524,3,231,'App\\Models\\Receipt',231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-16','2020-07-16',14499.00,NULL,NULL,1,'2021-05-29 18:41:07','2021-05-29 18:41:07',NULL),(241,3117,40719,1524,3,232,'App\\Models\\Receipt',232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-21','2020-07-21',20999.01,NULL,NULL,1,'2021-05-29 18:41:07','2021-05-29 18:41:07',NULL),(242,3117,40719,1525,3,233,'App\\Models\\Receipt',233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-10','2020-08-10',103500.00,NULL,NULL,1,'2021-05-29 18:43:13','2021-05-29 18:43:13',NULL),(243,3117,40719,1525,3,234,'App\\Models\\Receipt',234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-11','2020-08-11',169.00,NULL,NULL,1,'2021-05-29 18:43:13','2021-05-29 18:43:13',NULL),(244,3117,40719,1525,3,235,'App\\Models\\Receipt',235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-13','2020-08-13',6022.00,NULL,NULL,1,'2021-05-29 18:43:13','2021-05-29 18:43:13',NULL),(245,3117,40719,1525,3,236,'App\\Models\\Receipt',236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-13','2020-08-13',7432.00,NULL,NULL,1,'2021-05-29 18:43:13','2021-05-29 18:43:13',NULL),(246,3117,40719,1525,3,237,'App\\Models\\Receipt',237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-14','2020-08-14',73100.00,NULL,NULL,1,'2021-05-29 18:43:13','2021-05-29 18:43:13',NULL),(247,3117,40719,1525,3,238,'App\\Models\\Receipt',238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-20','2020-08-20',14999.00,NULL,NULL,1,'2021-05-29 18:43:13','2021-05-29 18:43:13',NULL),(248,3117,40719,1525,3,239,'App\\Models\\Receipt',239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-21','2020-08-21',14999.00,NULL,NULL,1,'2021-05-29 18:43:13','2021-05-29 18:43:13',NULL),(249,3117,40719,1525,3,240,'App\\Models\\Receipt',240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-21','2020-08-21',14999.00,NULL,NULL,1,'2021-05-29 18:43:13','2021-05-29 18:43:13',NULL),(250,3117,40719,1525,3,241,'App\\Models\\Receipt',241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-21','2020-08-21',11999.00,NULL,NULL,1,'2021-05-29 18:43:13','2021-05-29 18:43:13',NULL),(251,3117,40719,1525,3,242,'App\\Models\\Receipt',242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-21','2020-08-21',11999.00,NULL,NULL,1,'2021-05-29 18:43:13','2021-05-29 18:43:13',NULL),(252,3117,40719,1525,3,243,'App\\Models\\Receipt',243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-27','2020-08-27',19999.00,NULL,NULL,1,'2021-05-29 18:43:13','2021-05-29 18:43:13',NULL),(253,3117,40719,1525,3,244,'App\\Models\\Receipt',244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',223.46,NULL,NULL,1,'2021-05-29 18:43:13','2021-05-29 18:43:13',NULL),(254,3117,40719,1526,3,245,'App\\Models\\Receipt',245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-01','2020-09-01',27999.00,NULL,NULL,1,'2021-05-29 18:44:54','2021-05-29 18:44:54',NULL),(255,3117,40719,1526,3,246,'App\\Models\\Receipt',246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-09','2020-09-09',12499.00,NULL,NULL,1,'2021-05-29 18:44:54','2021-05-29 18:44:54',NULL),(256,3117,40719,1526,3,247,'App\\Models\\Receipt',247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-09','2020-09-09',12499.00,NULL,NULL,1,'2021-05-29 18:44:54','2021-05-29 18:44:54',NULL),(257,3117,40719,1526,3,248,'App\\Models\\Receipt',248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-15','2020-09-15',19999.00,NULL,NULL,1,'2021-05-29 18:44:54','2021-05-29 18:44:54',NULL),(258,3117,40719,1526,3,249,'App\\Models\\Receipt',249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-17','2020-09-17',42400.00,NULL,NULL,1,'2021-05-29 18:44:54','2021-05-29 18:44:54',NULL),(259,3117,40719,1526,3,250,'App\\Models\\Receipt',250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-23','2020-09-23',47997.00,NULL,NULL,1,'2021-05-29 18:44:54','2021-05-29 18:44:54',NULL),(260,3117,40719,1526,3,251,'App\\Models\\Receipt',251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-25','2020-09-25',103993.00,NULL,NULL,1,'2021-05-29 18:44:54','2021-05-29 18:44:54',NULL);
INSERT INTO `balance_libro` VALUES (261,3117,40719,1526,3,252,'App\\Models\\Receipt',252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-29','2020-09-29',23999.01,NULL,NULL,1,'2021-05-29 18:44:54','2021-05-29 18:44:54',NULL),(262,3117,40719,1526,3,253,'App\\Models\\Receipt',253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',9.66,NULL,NULL,1,'2021-05-29 18:44:54','2021-05-29 18:44:54',NULL),(263,3117,40719,1526,3,254,'App\\Models\\Receipt',254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',13999.00,NULL,NULL,1,'2021-05-29 18:44:54','2021-05-29 18:44:54',NULL),(264,3117,40719,1526,3,255,'App\\Models\\Receipt',255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',31998.00,NULL,NULL,1,'2021-05-29 18:44:54','2021-05-29 18:44:54',NULL),(265,3117,40719,1527,3,256,'App\\Models\\Receipt',256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-01','2020-10-01',93545.00,NULL,NULL,1,'2021-05-29 18:46:09','2021-05-29 18:46:09',NULL),(266,3117,40719,1527,3,257,'App\\Models\\Receipt',257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-01','2020-10-01',70546.00,NULL,NULL,1,'2021-05-29 18:46:09','2021-05-29 18:46:09',NULL),(267,3117,40719,1527,3,258,'App\\Models\\Receipt',258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-02','2020-10-02',68546.00,NULL,NULL,1,'2021-05-29 18:46:09','2021-05-29 18:46:09',NULL),(268,3117,40719,1527,3,259,'App\\Models\\Receipt',259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-02','2020-10-02',23498.00,NULL,NULL,1,'2021-05-29 18:46:09','2021-05-29 18:46:09',NULL),(269,3117,40719,1527,3,260,'App\\Models\\Receipt',260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-06','2020-10-06',139993.00,NULL,NULL,1,'2021-05-29 18:46:09','2021-05-29 18:46:09',NULL),(270,3117,40719,1527,3,261,'App\\Models\\Receipt',261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-07','2020-10-07',88495.00,NULL,NULL,1,'2021-05-29 18:46:09','2021-05-29 18:46:09',NULL),(271,3117,40719,1527,3,262,'App\\Models\\Receipt',262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-15','2020-10-15',1760.00,NULL,NULL,1,'2021-05-29 18:46:09','2021-05-29 18:46:09',NULL),(272,3117,40719,1527,3,263,'App\\Models\\Receipt',263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-16','2020-10-16',19999.00,NULL,NULL,1,'2021-05-29 18:46:09','2021-05-29 18:46:09',NULL),(273,3117,40719,1527,3,264,'App\\Models\\Receipt',264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-17','2020-10-17',4050.00,NULL,NULL,1,'2021-05-29 18:46:09','2021-05-29 18:46:09',NULL),(274,3117,40719,1527,3,265,'App\\Models\\Receipt',265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-20','2020-10-20',33998.01,NULL,NULL,1,'2021-05-29 18:46:09','2021-05-29 18:46:09',NULL),(275,3117,40719,1527,3,266,'App\\Models\\Receipt',266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-20','2020-10-20',28999.01,NULL,NULL,1,'2021-05-29 18:46:09','2021-05-29 18:46:09',NULL),(276,3117,40719,1527,3,267,'App\\Models\\Receipt',267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-21','2020-10-21',59997.00,NULL,NULL,1,'2021-05-29 18:46:09','2021-05-29 18:46:09',NULL),(277,3117,40719,1527,3,268,'App\\Models\\Receipt',268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-24','2020-10-24',47998.00,NULL,NULL,1,'2021-05-29 18:46:09','2021-05-29 18:46:09',NULL),(278,3117,40719,1527,3,269,'App\\Models\\Receipt',269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-24','2020-10-24',47998.00,NULL,NULL,1,'2021-05-29 18:46:09','2021-05-29 18:46:09',NULL),(279,3117,40719,1527,3,270,'App\\Models\\Receipt',270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-25','2020-10-25',23999.00,NULL,NULL,1,'2021-05-29 18:46:09','2021-05-29 18:46:09',NULL),(280,3117,40719,1527,3,271,'App\\Models\\Receipt',271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-26','2020-10-26',39998.00,NULL,NULL,1,'2021-05-29 18:46:09','2021-05-29 18:46:09',NULL),(281,3117,40719,1527,3,272,'App\\Models\\Receipt',272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-26','2020-10-26',9599.00,NULL,NULL,1,'2021-05-29 18:46:09','2021-05-29 18:46:09',NULL);
INSERT INTO `balance_libro` VALUES (282,3117,40719,1527,3,273,'App\\Models\\Receipt',273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-27','2020-10-27',15999.00,NULL,NULL,1,'2021-05-29 18:46:09','2021-05-29 18:46:09',NULL),(283,3117,40719,1527,3,274,'App\\Models\\Receipt',274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-28','2020-10-28',31997.99,NULL,NULL,1,'2021-05-29 18:46:09','2021-05-29 18:46:09',NULL),(284,3117,40719,1527,3,275,'App\\Models\\Receipt',275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-28','2020-10-28',12499.01,NULL,NULL,1,'2021-05-29 18:46:09','2021-05-29 18:46:09',NULL),(285,3117,40719,1527,3,276,'App\\Models\\Receipt',276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-29','2020-10-29',79995.00,NULL,NULL,1,'2021-05-29 18:46:09','2021-05-29 18:46:09',NULL),(286,3117,40719,1527,3,277,'App\\Models\\Receipt',277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',3450.00,NULL,NULL,1,'2021-05-29 18:46:10','2021-05-29 18:46:10',NULL),(287,3117,40719,1527,3,278,'App\\Models\\Receipt',278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',435.60,NULL,NULL,1,'2021-05-29 18:46:10','2021-05-29 18:46:10',NULL),(288,3117,40719,1528,3,279,'App\\Models\\Receipt',279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-02','2020-11-02',19999.00,NULL,NULL,1,'2021-05-29 18:47:28','2021-05-29 18:47:28',NULL),(289,3117,40719,1528,3,280,'App\\Models\\Receipt',280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-04','2020-11-04',31997.99,NULL,NULL,1,'2021-05-29 18:47:28','2021-05-29 18:47:28',NULL),(290,3117,40719,1528,3,281,'App\\Models\\Receipt',281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-04','2020-11-04',12998.99,NULL,NULL,1,'2021-05-29 18:47:28','2021-05-29 18:47:28',NULL),(291,3117,40719,1528,3,282,'App\\Models\\Receipt',282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-04','2020-11-04',39998.00,NULL,NULL,1,'2021-05-29 18:47:28','2021-05-29 18:47:28',NULL),(292,3117,40719,1528,3,283,'App\\Models\\Receipt',283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-05','2020-11-05',23998.99,NULL,NULL,1,'2021-05-29 18:47:28','2021-05-29 18:47:28',NULL),(293,3117,40719,1528,3,284,'App\\Models\\Receipt',284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-05','2020-11-05',27998.00,NULL,NULL,1,'2021-05-29 18:47:28','2021-05-29 18:47:28',NULL),(294,3117,40719,1528,3,285,'App\\Models\\Receipt',285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-05','2020-11-05',19999.00,NULL,NULL,1,'2021-05-29 18:47:28','2021-05-29 18:47:28',NULL),(295,3117,40719,1528,3,286,'App\\Models\\Receipt',286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-12','2020-11-12',25998.01,NULL,NULL,1,'2021-05-29 18:47:28','2021-05-29 18:47:28',NULL),(296,3117,40719,1528,3,287,'App\\Models\\Receipt',287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-14','2020-11-14',36998.99,NULL,NULL,1,'2021-05-29 18:47:28','2021-05-29 18:47:28',NULL),(297,3117,40719,1528,3,288,'App\\Models\\Receipt',288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-16','2020-11-16',20907.00,NULL,NULL,1,'2021-05-29 18:47:28','2021-05-29 18:47:28',NULL),(298,3117,40719,1528,3,289,'App\\Models\\Receipt',289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-16','2020-11-16',14906.99,NULL,NULL,1,'2021-05-29 18:47:28','2021-05-29 18:47:28',NULL),(299,3117,40719,1528,3,290,'App\\Models\\Receipt',290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-16','2020-11-16',20907.00,NULL,NULL,1,'2021-05-29 18:47:28','2021-05-29 18:47:28',NULL),(300,3117,40719,1528,3,291,'App\\Models\\Receipt',291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-16','2020-11-16',19999.00,NULL,NULL,1,'2021-05-29 18:47:28','2021-05-29 18:47:28',NULL),(301,3117,40719,1528,3,292,'App\\Models\\Receipt',292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-16','2020-11-16',19999.00,NULL,NULL,1,'2021-05-29 18:47:28','2021-05-29 18:47:28',NULL),(302,3117,40719,1528,3,293,'App\\Models\\Receipt',293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-17','2020-11-17',19999.00,NULL,NULL,1,'2021-05-29 18:47:28','2021-05-29 18:47:28',NULL);
INSERT INTO `balance_libro` VALUES (303,3117,40719,1528,3,294,'App\\Models\\Receipt',294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-19','2020-11-19',29998.01,NULL,NULL,1,'2021-05-29 18:47:28','2021-05-29 18:47:28',NULL),(304,3117,40719,1528,3,295,'App\\Models\\Receipt',295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-24','2020-11-24',28999.00,NULL,NULL,1,'2021-05-29 18:47:28','2021-05-29 18:47:28',NULL),(305,3117,40719,1528,3,296,'App\\Models\\Receipt',296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-24','2020-11-24',40999.00,NULL,NULL,1,'2021-05-29 18:47:28','2021-05-29 18:47:28',NULL),(306,3117,40719,1528,3,297,'App\\Models\\Receipt',297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-25','2020-11-25',25998.01,NULL,NULL,1,'2021-05-29 18:47:29','2021-05-29 18:47:29',NULL),(307,3117,40719,1528,3,298,'App\\Models\\Receipt',298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-25','2020-11-25',25998.01,NULL,NULL,1,'2021-05-29 18:47:29','2021-05-29 18:47:29',NULL),(308,3117,40719,1528,3,299,'App\\Models\\Receipt',299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-25','2020-11-25',25998.01,NULL,NULL,1,'2021-05-29 18:47:29','2021-05-29 18:47:29',NULL),(309,3117,40719,1528,3,300,'App\\Models\\Receipt',300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-27','2020-11-27',31999.00,NULL,NULL,1,'2021-05-29 18:47:29','2021-05-29 18:47:29',NULL),(310,3117,40719,1529,3,301,'App\\Models\\Receipt',301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-04','2020-12-04',38998.99,NULL,NULL,1,'2021-05-29 18:49:22','2021-05-29 18:49:22',NULL),(311,3117,40719,1529,3,302,'App\\Models\\Receipt',302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-06','2020-12-06',39998.00,NULL,NULL,1,'2021-05-29 18:49:22','2021-05-29 18:49:22',NULL),(312,3117,40719,1529,3,303,'App\\Models\\Receipt',303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',6753.00,NULL,NULL,1,'2021-05-29 18:49:22','2021-05-29 18:49:22',NULL),(313,3117,40719,1529,3,304,'App\\Models\\Receipt',304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-21','2020-12-21',26999.00,NULL,NULL,1,'2021-05-29 18:49:22','2021-05-29 18:49:22',NULL),(314,3117,40719,1529,3,305,'App\\Models\\Receipt',305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-21','2020-12-21',16999.00,NULL,NULL,1,'2021-05-29 18:49:22','2021-05-29 18:49:22',NULL),(315,3117,40719,1529,3,306,'App\\Models\\Receipt',306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-21','2020-12-21',33998.00,NULL,NULL,1,'2021-05-29 18:49:22','2021-05-29 18:49:22',NULL),(316,3117,40719,1529,3,307,'App\\Models\\Receipt',307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-23','2020-12-23',26999.00,NULL,NULL,1,'2021-05-29 18:49:22','2021-05-29 18:49:22',NULL),(317,3117,40719,1529,3,308,'App\\Models\\Receipt',308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-24','2020-12-24',22699.00,NULL,NULL,1,'2021-05-29 18:49:22','2021-05-29 18:49:22',NULL),(318,3117,40719,1529,3,309,'App\\Models\\Receipt',309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',7661.55,NULL,NULL,1,'2021-05-29 18:49:22','2021-05-29 18:49:22',NULL),(319,3117,40719,1528,2,310,'App\\Models\\Receipt',310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-02','2020-11-02',1500.00,NULL,NULL,1,'2021-05-29 18:54:45','2021-05-29 18:54:45',NULL),(320,3117,40719,1528,2,311,'App\\Models\\Receipt',311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-16','2020-11-16',30500.00,NULL,NULL,1,'2021-05-29 18:54:45','2021-05-29 18:54:45',NULL),(321,3117,40719,1528,2,312,'App\\Models\\Receipt',312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-18','2020-11-18',18000.00,NULL,NULL,1,'2021-05-29 18:54:45','2021-05-29 18:54:45',NULL),(322,3117,40719,1528,2,313,'App\\Models\\Receipt',313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',19000.00,NULL,NULL,1,'2021-05-29 18:54:45','2021-05-29 18:54:45',NULL),(323,3117,40719,7,2,314,'App\\Models\\Receipt',314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',10636.00,NULL,NULL,1,'2021-06-01 18:13:18','2021-06-01 18:13:18',NULL);
INSERT INTO `balance_libro` VALUES (324,3117,40719,7,2,315,'App\\Models\\Receipt',315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',10000.00,NULL,NULL,1,'2021-06-01 18:13:18','2021-06-01 18:13:18',NULL),(325,3117,40719,7,2,316,'App\\Models\\Receipt',316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',9500.00,NULL,NULL,1,'2021-06-01 18:13:18','2021-06-01 18:13:18',NULL),(326,3117,40719,7,2,317,'App\\Models\\Receipt',317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',9000.00,NULL,NULL,1,'2021-06-01 18:13:18','2021-06-01 18:13:18',NULL),(327,3117,40719,7,2,318,'App\\Models\\Receipt',318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',9890.00,NULL,NULL,1,'2021-06-01 18:13:18','2021-06-01 18:13:18',NULL),(328,3117,40719,7,2,319,'App\\Models\\Receipt',319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',9963.00,NULL,NULL,1,'2021-06-01 18:13:18','2021-06-01 18:13:18',NULL),(329,3117,40719,7,2,320,'App\\Models\\Receipt',320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',30668.00,NULL,NULL,1,'2021-06-01 18:13:18','2021-06-01 18:13:18',NULL),(330,3117,40719,7,2,321,'App\\Models\\Receipt',321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',10100.00,NULL,NULL,1,'2021-06-01 18:13:18','2021-06-01 18:13:18',NULL),(331,3117,40719,7,2,322,'App\\Models\\Receipt',322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',9980.00,NULL,NULL,1,'2021-06-01 18:13:18','2021-06-01 18:13:18',NULL),(332,3117,40719,7,2,323,'App\\Models\\Receipt',323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',10255.00,NULL,NULL,1,'2021-06-01 18:13:19','2021-06-01 18:13:19',NULL),(333,3117,40719,7,2,324,'App\\Models\\Receipt',324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',10188.00,NULL,NULL,1,'2021-06-01 18:13:19','2021-06-01 18:13:19',NULL),(334,3117,40719,7,2,325,'App\\Models\\Receipt',325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',10335.00,NULL,NULL,1,'2021-06-01 18:13:19','2021-06-01 18:13:19',NULL),(335,3117,40719,7,2,326,'App\\Models\\Receipt',326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',10171.00,NULL,NULL,1,'2021-06-01 18:13:19','2021-06-01 18:13:19',NULL),(336,3117,40719,7,2,327,'App\\Models\\Receipt',327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',9876.00,NULL,NULL,1,'2021-06-01 18:13:19','2021-06-01 18:13:19',NULL),(337,3117,40719,7,2,328,'App\\Models\\Receipt',328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',9940.00,NULL,NULL,1,'2021-06-01 18:13:19','2021-06-01 18:13:19',NULL),(338,3117,40779,4570,2,329,'App\\Models\\Receipt',329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-01','2021-05-01',4810.00,NULL,NULL,1,'2021-06-10 19:36:51','2021-06-10 19:36:51',NULL),(339,3117,40779,4570,2,330,'App\\Models\\Receipt',330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-02','2021-05-02',4230.00,NULL,NULL,1,'2021-06-10 19:36:51','2021-06-10 19:36:51',NULL),(340,3117,40779,4570,2,331,'App\\Models\\Receipt',331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',4380.00,NULL,NULL,1,'2021-06-10 19:36:51','2021-06-10 19:36:51',NULL),(341,3117,40779,4570,2,332,'App\\Models\\Receipt',332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',4960.00,NULL,NULL,1,'2021-06-10 19:36:51','2021-06-10 19:36:51',NULL),(342,3117,40779,4570,2,333,'App\\Models\\Receipt',333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',4825.00,NULL,NULL,1,'2021-06-10 19:36:51','2021-06-10 19:36:51',NULL),(343,3117,40779,4570,2,334,'App\\Models\\Receipt',334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',4750.00,NULL,NULL,1,'2021-06-10 19:36:51','2021-06-10 19:36:51',NULL),(344,3117,40779,4570,2,335,'App\\Models\\Receipt',335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',4350.00,NULL,NULL,1,'2021-06-10 19:36:51','2021-06-10 19:36:51',NULL);
INSERT INTO `balance_libro` VALUES (345,3117,40779,4570,2,336,'App\\Models\\Receipt',336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',4380.00,NULL,NULL,1,'2021-06-10 19:36:51','2021-06-10 19:36:51',NULL),(346,3117,40779,4570,2,337,'App\\Models\\Receipt',337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-09','2021-05-09',4270.00,NULL,NULL,1,'2021-06-10 19:36:51','2021-06-10 19:36:51',NULL),(347,3117,40779,4570,2,338,'App\\Models\\Receipt',338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-09','2021-05-09',4110.00,NULL,NULL,1,'2021-06-10 19:36:51','2021-06-10 19:36:51',NULL),(348,3117,40779,4570,2,339,'App\\Models\\Receipt',339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-09','2021-05-09',4190.00,NULL,NULL,1,'2021-06-10 19:36:51','2021-06-10 19:36:51',NULL),(349,3117,40779,4570,2,340,'App\\Models\\Receipt',340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',1190.00,NULL,NULL,1,'2021-06-10 19:36:51','2021-06-10 19:36:51',NULL),(350,3117,40779,4570,2,341,'App\\Models\\Receipt',341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',4550.00,NULL,NULL,1,'2021-06-10 19:36:51','2021-06-10 19:36:51',NULL),(351,3117,40779,4570,2,342,'App\\Models\\Receipt',342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',2600.00,NULL,NULL,1,'2021-06-10 19:36:51','2021-06-10 19:36:51',NULL),(352,3117,40779,4570,2,343,'App\\Models\\Receipt',343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',4230.00,NULL,NULL,1,'2021-06-10 19:36:51','2021-06-10 19:36:51',NULL),(353,3117,40779,4570,2,344,'App\\Models\\Receipt',344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',4230.00,NULL,NULL,1,'2021-06-10 19:36:51','2021-06-10 19:36:51',NULL),(354,3117,40779,4570,2,345,'App\\Models\\Receipt',345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',4680.00,NULL,NULL,1,'2021-06-10 19:36:51','2021-06-10 19:36:51',NULL),(355,3117,40779,4570,2,346,'App\\Models\\Receipt',346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',4400.00,NULL,NULL,1,'2021-06-10 19:36:51','2021-06-10 19:36:51',NULL),(356,3117,40779,4570,2,347,'App\\Models\\Receipt',347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',4380.00,NULL,NULL,1,'2021-06-10 19:36:51','2021-06-10 19:36:51',NULL),(357,3117,40779,4570,2,348,'App\\Models\\Receipt',348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',1190.00,NULL,NULL,1,'2021-06-10 19:36:51','2021-06-10 19:36:51',NULL),(358,3117,40779,4570,2,349,'App\\Models\\Receipt',349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',4260.00,NULL,NULL,1,'2021-06-10 19:36:51','2021-06-10 19:36:51',NULL),(359,3117,40779,4570,2,350,'App\\Models\\Receipt',350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-16','2021-05-16',4120.00,NULL,NULL,1,'2021-06-10 19:36:51','2021-06-10 19:36:51',NULL),(360,3117,40779,4570,2,351,'App\\Models\\Receipt',351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-16','2021-05-16',4830.00,NULL,NULL,1,'2021-06-10 19:36:51','2021-06-10 19:36:51',NULL),(361,3117,40779,4570,2,352,'App\\Models\\Receipt',352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-16','2021-05-16',4930.00,NULL,NULL,1,'2021-06-10 19:36:51','2021-06-10 19:36:51',NULL),(362,3117,40779,4570,2,353,'App\\Models\\Receipt',353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-16','2021-05-16',3450.00,NULL,NULL,1,'2021-06-10 19:36:51','2021-06-10 19:36:51',NULL),(363,3117,40779,4570,2,354,'App\\Models\\Receipt',354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',1190.00,NULL,NULL,1,'2021-06-10 19:36:51','2021-06-10 19:36:51',NULL),(364,3117,40779,4570,2,355,'App\\Models\\Receipt',355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',4670.00,NULL,NULL,1,'2021-06-10 19:36:51','2021-06-10 19:36:51',NULL),(365,3117,40779,4570,2,356,'App\\Models\\Receipt',356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',4550.00,NULL,NULL,1,'2021-06-10 19:36:51','2021-06-10 19:36:51',NULL);
INSERT INTO `balance_libro` VALUES (366,3117,40779,4570,2,357,'App\\Models\\Receipt',357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',1190.00,NULL,NULL,1,'2021-06-10 19:36:51','2021-06-10 19:36:51',NULL),(367,3117,40779,4570,2,358,'App\\Models\\Receipt',358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',4350.00,NULL,NULL,1,'2021-06-10 19:36:51','2021-06-10 19:36:51',NULL),(368,3117,40779,4570,2,359,'App\\Models\\Receipt',359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',4830.00,NULL,NULL,1,'2021-06-10 19:36:51','2021-06-10 19:36:51',NULL),(369,3117,40779,4570,2,360,'App\\Models\\Receipt',360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',4520.00,NULL,NULL,1,'2021-06-10 19:36:51','2021-06-10 19:36:51',NULL),(370,3117,40779,4570,2,361,'App\\Models\\Receipt',361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',4630.00,NULL,NULL,1,'2021-06-10 19:36:51','2021-06-10 19:36:51',NULL),(371,3117,40779,4570,3,362,'App\\Models\\Receipt',362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',1690.00,NULL,NULL,1,'2021-06-10 19:37:09','2021-06-10 19:37:09',NULL),(372,3117,40779,4570,3,363,'App\\Models\\Receipt',363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',95137.13,NULL,NULL,1,'2021-06-10 19:37:09','2021-06-10 19:37:09',NULL),(373,3117,40779,4570,3,364,'App\\Models\\Receipt',364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',447.22,NULL,NULL,1,'2021-06-10 19:37:09','2021-06-10 19:37:09',NULL),(374,3117,40779,4570,3,365,'App\\Models\\Receipt',365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',8727.35,NULL,NULL,1,'2021-06-10 19:37:09','2021-06-10 19:37:09',NULL),(375,3117,40779,4570,3,366,'App\\Models\\Receipt',366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',54448.92,NULL,NULL,1,'2021-06-10 19:37:09','2021-06-10 19:37:09',NULL),(376,3117,40779,4570,3,367,'App\\Models\\Receipt',367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',4683.54,NULL,NULL,1,'2021-06-10 19:37:09','2021-06-10 19:37:09',NULL),(377,3117,40779,4570,3,368,'App\\Models\\Receipt',368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',18088.40,NULL,NULL,1,'2021-06-10 19:37:09','2021-06-10 19:37:09',NULL),(378,3117,40779,4570,3,369,'App\\Models\\Receipt',369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',3463.04,NULL,NULL,1,'2021-06-10 19:37:09','2021-06-10 19:37:09',NULL),(379,3117,40779,4570,3,370,'App\\Models\\Receipt',370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',6454.45,NULL,NULL,1,'2021-06-10 19:37:09','2021-06-10 19:37:09',NULL),(380,3117,40779,4570,3,371,'App\\Models\\Receipt',371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',4160.67,NULL,NULL,1,'2021-06-10 19:37:09','2021-06-10 19:37:09',NULL),(381,3117,40779,4570,3,372,'App\\Models\\Receipt',372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',22400.00,NULL,NULL,1,'2021-06-10 19:37:09','2021-06-10 19:37:09',NULL),(382,3117,40779,4570,3,373,'App\\Models\\Receipt',373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',22091.29,NULL,NULL,1,'2021-06-10 19:37:09','2021-06-10 19:37:09',NULL),(383,3117,40779,4571,3,374,'App\\Models\\Receipt',374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',9047.70,NULL,NULL,1,'2021-07-05 17:32:41','2021-07-05 17:32:41',NULL),(384,3117,40779,4571,3,375,'App\\Models\\Receipt',375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',175.24,NULL,NULL,1,'2021-07-05 17:32:41','2021-07-05 17:32:41',NULL),(385,3117,40779,4571,3,376,'App\\Models\\Receipt',376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',1690.00,NULL,NULL,1,'2021-07-05 17:32:41','2021-07-05 17:32:41',NULL),(386,3117,40779,4571,3,377,'App\\Models\\Receipt',377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',647.33,NULL,NULL,1,'2021-07-05 17:32:41','2021-07-05 17:32:41',NULL);
INSERT INTO `balance_libro` VALUES (387,3117,40779,4571,3,378,'App\\Models\\Receipt',378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',3508.60,NULL,NULL,1,'2021-07-05 17:32:41','2021-07-05 17:32:41',NULL),(388,3117,40779,4571,3,379,'App\\Models\\Receipt',379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',1160.54,NULL,NULL,1,'2021-07-05 17:32:41','2021-07-05 17:32:41',NULL),(389,3117,40779,4571,3,380,'App\\Models\\Receipt',380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',12892.48,NULL,NULL,1,'2021-07-05 17:32:41','2021-07-05 17:32:41',NULL),(390,3117,40779,4571,3,381,'App\\Models\\Receipt',381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',30600.10,NULL,NULL,1,'2021-07-05 17:32:41','2021-07-05 17:32:41',NULL),(391,3117,40779,4571,3,382,'App\\Models\\Receipt',382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',5720.86,NULL,NULL,1,'2021-07-05 17:32:41','2021-07-05 17:32:41',NULL),(392,3117,40779,4571,3,383,'App\\Models\\Receipt',383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',9448.75,NULL,NULL,1,'2021-07-05 17:32:41','2021-07-05 17:32:41',NULL),(393,3117,40779,4571,3,384,'App\\Models\\Receipt',384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',3508.60,NULL,NULL,1,'2021-07-05 17:32:41','2021-07-05 17:32:41',NULL),(394,3117,40779,4571,3,385,'App\\Models\\Receipt',385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',815.00,NULL,NULL,1,'2021-07-05 17:32:41','2021-07-05 17:32:41',NULL),(395,3117,40779,4571,3,386,'App\\Models\\Receipt',386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',8657.85,NULL,NULL,1,'2021-07-05 17:32:41','2021-07-05 17:32:41',NULL),(396,3117,40779,4571,3,387,'App\\Models\\Receipt',387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',2693.60,NULL,NULL,1,'2021-07-05 17:32:41','2021-07-05 17:32:41',NULL),(397,3117,40779,4571,3,388,'App\\Models\\Receipt',388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',9368.08,NULL,NULL,1,'2021-07-05 17:32:41','2021-07-05 17:32:41',NULL),(398,3117,40779,4571,3,389,'App\\Models\\Receipt',389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',62672.13,NULL,NULL,1,'2021-07-05 17:32:41','2021-07-05 17:32:41',NULL),(399,3117,40779,4571,3,390,'App\\Models\\Receipt',390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',11687.01,NULL,NULL,1,'2021-07-05 17:32:41','2021-07-05 17:32:41',NULL),(400,3117,40779,4571,3,391,'App\\Models\\Receipt',391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',16015.46,NULL,NULL,1,'2021-07-05 17:32:41','2021-07-05 17:32:41',NULL),(401,3117,40779,4571,3,392,'App\\Models\\Receipt',392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',75800.00,NULL,NULL,1,'2021-07-05 17:32:41','2021-07-05 17:32:41',NULL),(402,3117,40779,4571,3,393,'App\\Models\\Receipt',393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',5152.31,NULL,NULL,1,'2021-07-05 17:32:41','2021-07-05 17:32:41',NULL),(403,3117,40779,4571,3,394,'App\\Models\\Receipt',394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',21260.00,NULL,NULL,1,'2021-07-05 17:32:41','2021-07-05 17:32:41',NULL),(404,3117,40736,1542,2,395,'App\\Models\\Receipt',395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',10100.00,NULL,NULL,1,'2021-07-05 17:58:13','2021-07-05 17:58:13',NULL),(405,3117,40736,1542,2,396,'App\\Models\\Receipt',396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',10200.00,NULL,NULL,1,'2021-07-05 17:58:13','2021-07-05 17:58:13',NULL),(406,3117,40736,1542,2,397,'App\\Models\\Receipt',397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',10150.00,NULL,NULL,1,'2021-07-05 17:58:13','2021-07-05 17:58:13',NULL),(407,3117,40736,1542,2,398,'App\\Models\\Receipt',398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',10199.00,NULL,NULL,1,'2021-07-05 17:58:13','2021-07-05 17:58:13',NULL);
INSERT INTO `balance_libro` VALUES (408,3117,40736,1542,2,399,'App\\Models\\Receipt',399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',10189.00,NULL,NULL,1,'2021-07-05 17:58:13','2021-07-05 17:58:13',NULL),(409,3117,40736,1542,2,400,'App\\Models\\Receipt',400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',10250.00,NULL,NULL,1,'2021-07-05 17:58:13','2021-07-05 17:58:13',NULL),(410,3117,40736,1542,2,401,'App\\Models\\Receipt',401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',5396.00,NULL,NULL,1,'2021-07-05 17:58:28','2021-07-05 18:13:54','2021-07-05 18:13:54'),(411,3117,40736,1542,2,402,'App\\Models\\Receipt',402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',6223.00,NULL,NULL,1,'2021-07-05 17:58:28','2021-07-05 18:14:07','2021-07-05 18:14:07'),(412,3117,40736,1542,2,403,'App\\Models\\Receipt',403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',10250.00,NULL,NULL,1,'2021-07-05 17:58:28','2021-07-05 18:14:19','2021-07-05 18:14:19'),(413,3117,40736,1542,3,404,'App\\Models\\Receipt',404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',5961.00,NULL,NULL,1,'2021-07-05 18:12:43','2021-07-05 18:12:43',NULL),(414,3117,40736,1542,3,405,'App\\Models\\Receipt',405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',61769.50,NULL,NULL,1,'2021-07-05 18:12:43','2021-07-05 18:12:43',NULL),(415,3117,40736,1542,3,406,'App\\Models\\Receipt',406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',6265.00,NULL,NULL,1,'2021-07-05 18:12:56','2021-07-05 18:15:47','2021-07-05 18:15:47'),(416,3117,40736,1542,3,407,'App\\Models\\Receipt',407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',31580.00,NULL,NULL,1,'2021-07-05 18:12:56','2021-07-05 18:15:09','2021-07-05 18:15:09'),(417,3117,40736,1542,3,408,'App\\Models\\Receipt',408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',22100.00,NULL,NULL,1,'2021-07-05 18:12:56','2021-07-05 18:14:36','2021-07-05 18:14:36'),(418,3117,40736,1541,2,401,'App\\Models\\Receipt',401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',5396.00,NULL,NULL,1,'2021-07-05 18:13:54','2021-07-05 18:13:54',NULL),(419,3117,40736,1542,2,402,'App\\Models\\Receipt',402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',6223.00,NULL,NULL,1,'2021-07-05 18:14:07','2021-07-19 18:16:35','2021-07-19 18:16:35'),(420,3117,40736,1542,2,403,'App\\Models\\Receipt',403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',10250.00,NULL,NULL,1,'2021-07-05 18:14:19','2021-07-19 18:16:46','2021-07-19 18:16:46'),(421,3117,40736,1542,3,408,'App\\Models\\Receipt',408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',22100.00,NULL,NULL,1,'2021-07-05 18:14:36','2021-07-05 18:14:47','2021-07-05 18:14:47'),(422,3117,40736,1542,3,408,'App\\Models\\Receipt',408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',22100.00,NULL,NULL,1,'2021-07-05 18:14:47','2021-07-05 18:14:58','2021-07-05 18:14:58'),(423,3117,40736,1541,3,408,'App\\Models\\Receipt',408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',22100.00,NULL,NULL,1,'2021-07-05 18:14:58','2021-07-05 18:14:58',NULL),(424,3117,40736,1542,3,407,'App\\Models\\Receipt',407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',31580.00,NULL,NULL,1,'2021-07-05 18:15:09','2021-07-05 18:15:21','2021-07-05 18:15:21'),(425,3117,40736,1542,3,407,'App\\Models\\Receipt',407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',31580.00,NULL,NULL,1,'2021-07-05 18:15:21','2021-07-05 18:15:33','2021-07-05 18:15:33'),(426,3117,40736,1541,3,407,'App\\Models\\Receipt',407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',31580.00,NULL,NULL,1,'2021-07-05 18:15:33','2021-07-05 18:15:33',NULL),(427,3117,40736,1541,3,406,'App\\Models\\Receipt',406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',6265.00,NULL,NULL,1,'2021-07-05 18:15:47','2021-07-05 18:15:47',NULL);
INSERT INTO `balance_libro` VALUES (428,3117,40719,8,2,409,'App\\Models\\Receipt',409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',35998.00,NULL,NULL,1,'2021-07-05 18:18:21','2021-07-05 18:21:04','2021-07-05 18:21:04'),(429,3117,40719,8,2,410,'App\\Models\\Receipt',410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',24999.01,NULL,NULL,1,'2021-07-05 18:18:21','2021-07-05 18:20:58','2021-07-05 18:20:58'),(430,3117,40719,8,2,411,'App\\Models\\Receipt',411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',1900.00,NULL,NULL,1,'2021-07-05 18:18:21','2021-07-05 18:20:55','2021-07-05 18:20:55'),(431,3117,40719,8,2,412,'App\\Models\\Receipt',412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',179.68,NULL,NULL,1,'2021-07-05 18:18:21','2021-07-05 18:20:31','2021-07-05 18:20:31'),(432,3117,40719,8,2,413,'App\\Models\\Receipt',413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',9188.00,NULL,NULL,1,'2021-07-05 18:19:42','2021-07-05 18:19:42',NULL),(433,3117,40719,8,2,414,'App\\Models\\Receipt',414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',3300.00,NULL,NULL,1,'2021-07-05 18:19:42','2021-07-05 18:19:42',NULL),(434,3117,40719,8,2,415,'App\\Models\\Receipt',415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',10111.00,NULL,NULL,1,'2021-07-05 18:19:42','2021-07-05 18:19:42',NULL),(435,3117,40719,8,2,416,'App\\Models\\Receipt',416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',9500.00,NULL,NULL,1,'2021-07-05 18:19:42','2021-07-05 18:19:42',NULL),(436,3117,40719,8,2,417,'App\\Models\\Receipt',417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',9639.00,NULL,NULL,1,'2021-07-05 18:19:42','2021-07-05 18:19:42',NULL),(437,3117,40719,8,2,418,'App\\Models\\Receipt',418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',10200.00,NULL,NULL,1,'2021-07-05 18:19:42','2021-07-05 18:19:42',NULL),(438,3117,40719,8,2,419,'App\\Models\\Receipt',419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',9850.00,NULL,NULL,1,'2021-07-05 18:19:42','2021-07-05 18:19:42',NULL),(439,3117,40719,8,2,420,'App\\Models\\Receipt',420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',10100.00,NULL,NULL,1,'2021-07-05 18:19:42','2021-07-05 18:19:42',NULL),(440,3117,40719,8,2,421,'App\\Models\\Receipt',421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',10000.00,NULL,NULL,1,'2021-07-05 18:19:42','2021-07-05 18:19:42',NULL),(441,3117,40719,8,2,422,'App\\Models\\Receipt',422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',4850.00,NULL,NULL,1,'2021-07-05 18:19:42','2021-07-05 18:19:42',NULL),(442,3117,40719,8,2,423,'App\\Models\\Receipt',423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',9000.00,NULL,NULL,1,'2021-07-05 18:19:42','2021-07-05 18:19:42',NULL),(443,3117,40719,8,2,424,'App\\Models\\Receipt',424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',5800.00,NULL,NULL,1,'2021-07-05 18:19:42','2021-07-05 18:19:42',NULL),(444,3117,40719,8,2,425,'App\\Models\\Receipt',425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',9600.00,NULL,NULL,1,'2021-07-05 18:19:42','2021-07-05 18:19:42',NULL),(445,3117,40719,8,2,426,'App\\Models\\Receipt',426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',6000.00,NULL,NULL,1,'2021-07-05 18:19:42','2021-07-05 18:19:42',NULL),(446,3117,40719,8,2,427,'App\\Models\\Receipt',427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',10000.00,NULL,NULL,1,'2021-07-05 18:19:43','2021-07-05 18:19:43',NULL),(447,3117,40719,8,3,428,'App\\Models\\Receipt',428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',35998.00,NULL,NULL,1,'2021-07-05 18:26:25','2021-07-05 18:26:25',NULL),(448,3117,40719,8,3,429,'App\\Models\\Receipt',429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',24999.01,NULL,NULL,1,'2021-07-05 18:26:25','2021-07-05 18:26:25',NULL);
INSERT INTO `balance_libro` VALUES (449,3117,40719,8,3,430,'App\\Models\\Receipt',430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',1900.00,NULL,NULL,1,'2021-07-05 18:26:25','2021-07-05 18:26:25',NULL),(450,3117,40719,8,3,431,'App\\Models\\Receipt',431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',179.68,NULL,NULL,1,'2021-07-05 18:26:25','2021-07-05 18:26:25',NULL),(451,3117,40719,8,3,432,'App\\Models\\Receipt',432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',29999.00,NULL,NULL,1,'2021-07-05 18:27:27','2021-07-05 18:29:21','2021-07-05 18:29:21'),(452,3117,40719,8,3,433,'App\\Models\\Receipt',433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',19999.00,NULL,NULL,1,'2021-07-05 18:27:27','2021-07-05 18:29:09','2021-07-05 18:29:09'),(453,3117,40719,8,3,434,'App\\Models\\Receipt',434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',19999.00,NULL,NULL,1,'2021-07-05 18:27:27','2021-07-05 18:28:53','2021-07-05 18:28:53'),(454,3117,40719,8,3,435,'App\\Models\\Receipt',435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',19999.00,NULL,NULL,1,'2021-07-05 18:27:27','2021-07-05 18:28:38','2021-07-05 18:28:38'),(455,3117,40719,8,3,436,'App\\Models\\Receipt',436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',10000.00,NULL,NULL,1,'2021-07-05 18:27:27','2021-07-05 18:28:28','2021-07-05 18:28:28'),(456,3117,40719,8,3,437,'App\\Models\\Receipt',437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',1900.00,NULL,NULL,1,'2021-07-05 18:27:27','2021-07-05 18:28:16','2021-07-05 18:28:16'),(457,3117,40719,8,3,438,'App\\Models\\Receipt',438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',2628.19,NULL,NULL,1,'2021-07-05 18:27:27','2021-07-05 18:28:06','2021-07-05 18:28:06'),(458,3117,40719,7,3,438,'App\\Models\\Receipt',438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',2628.19,NULL,NULL,1,'2021-07-05 18:28:06','2021-07-05 18:28:06',NULL),(459,3117,40719,7,3,437,'App\\Models\\Receipt',437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',1900.00,NULL,NULL,1,'2021-07-05 18:28:16','2021-07-05 18:28:16',NULL),(460,3117,40719,7,3,436,'App\\Models\\Receipt',436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',10000.00,NULL,NULL,1,'2021-07-05 18:28:28','2021-07-05 18:28:28',NULL),(461,3117,40719,7,3,435,'App\\Models\\Receipt',435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',19999.00,NULL,NULL,1,'2021-07-05 18:28:38','2021-07-05 18:28:38',NULL),(462,3117,40719,7,3,434,'App\\Models\\Receipt',434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',19999.00,NULL,NULL,1,'2021-07-05 18:28:53','2021-07-05 18:28:53',NULL),(463,3117,40719,7,3,433,'App\\Models\\Receipt',433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',19999.00,NULL,NULL,1,'2021-07-05 18:29:09','2021-07-05 18:29:09',NULL),(464,3117,40719,7,3,432,'App\\Models\\Receipt',432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',29999.00,NULL,NULL,1,'2021-07-05 18:29:21','2021-07-05 18:29:21',NULL),(465,3117,40731,3052,2,439,'App\\Models\\Receipt',439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',5200.00,NULL,NULL,1,'2021-07-19 17:57:06','2021-07-19 17:57:06',NULL),(466,3117,40731,3052,2,440,'App\\Models\\Receipt',440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',1972.00,NULL,NULL,1,'2021-07-19 17:57:06','2021-07-19 17:57:06',NULL),(467,3117,40731,3052,2,441,'App\\Models\\Receipt',441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',3581.00,NULL,NULL,1,'2021-07-19 17:57:06','2021-07-19 17:57:06',NULL),(468,3117,40731,3052,2,442,'App\\Models\\Receipt',442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',1915.00,NULL,NULL,1,'2021-07-19 17:57:06','2021-07-19 17:57:06',NULL),(469,3117,40731,3052,2,443,'App\\Models\\Receipt',443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',2590.00,NULL,NULL,1,'2021-07-19 17:57:06','2021-07-19 17:57:06',NULL);
INSERT INTO `balance_libro` VALUES (470,3117,40731,3052,2,444,'App\\Models\\Receipt',444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',2147.00,NULL,NULL,1,'2021-07-19 17:57:06','2021-07-19 17:57:06',NULL),(471,3117,40731,3052,2,445,'App\\Models\\Receipt',445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',1666.00,NULL,NULL,1,'2021-07-19 17:57:06','2021-07-19 17:57:06',NULL),(472,3117,40731,3052,2,446,'App\\Models\\Receipt',446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',2400.00,NULL,NULL,1,'2021-07-19 17:57:06','2021-07-19 17:57:06',NULL),(473,3117,40731,3052,2,447,'App\\Models\\Receipt',447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',1703.00,NULL,NULL,1,'2021-07-19 17:57:06','2021-07-19 17:57:06',NULL),(474,3117,40731,3052,2,448,'App\\Models\\Receipt',448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',666.00,NULL,NULL,1,'2021-07-19 17:57:06','2021-07-19 17:57:06',NULL),(475,3117,40731,3052,2,449,'App\\Models\\Receipt',449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',2175.00,NULL,NULL,1,'2021-07-19 17:57:06','2021-07-19 17:57:06',NULL),(476,3117,40731,3052,2,450,'App\\Models\\Receipt',450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',2462.00,NULL,NULL,1,'2021-07-19 17:57:06','2021-07-19 17:57:06',NULL),(477,3117,40731,3052,2,451,'App\\Models\\Receipt',451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',2007.00,NULL,NULL,1,'2021-07-19 17:57:06','2021-07-19 17:57:06',NULL),(478,3117,40731,3052,2,452,'App\\Models\\Receipt',452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',3000.00,NULL,NULL,1,'2021-07-19 17:57:06','2021-07-19 17:57:06',NULL),(479,3117,40731,3052,2,453,'App\\Models\\Receipt',453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',4189.00,NULL,NULL,1,'2021-07-19 17:57:06','2021-07-19 17:57:06',NULL),(480,3117,40731,3052,2,454,'App\\Models\\Receipt',454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-06','2021-06-06',3151.00,NULL,NULL,1,'2021-07-19 17:57:06','2021-07-19 17:57:06',NULL),(481,3117,40731,3052,2,455,'App\\Models\\Receipt',455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-06','2021-06-06',1582.00,NULL,NULL,1,'2021-07-19 17:57:06','2021-07-19 17:57:06',NULL),(482,3117,40731,3052,2,456,'App\\Models\\Receipt',456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-06','2021-06-06',2156.00,NULL,NULL,1,'2021-07-19 17:57:06','2021-07-19 17:57:06',NULL),(483,3117,40731,3052,2,457,'App\\Models\\Receipt',457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-06','2021-06-06',3023.00,NULL,NULL,1,'2021-07-19 17:57:06','2021-07-19 17:57:06',NULL),(484,3117,40731,3052,2,458,'App\\Models\\Receipt',458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',1160.00,NULL,NULL,1,'2021-07-19 17:57:06','2021-07-19 17:57:06',NULL),(485,3117,40731,3052,2,459,'App\\Models\\Receipt',459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',1471.00,NULL,NULL,1,'2021-07-19 17:57:06','2021-07-19 17:57:06',NULL),(486,3117,40731,3052,2,460,'App\\Models\\Receipt',460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2235.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(487,3117,40731,3052,2,461,'App\\Models\\Receipt',461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2676.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(488,3117,40731,3052,2,462,'App\\Models\\Receipt',462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',6156.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(489,3117,40731,3052,2,463,'App\\Models\\Receipt',463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2224.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(490,3117,40731,3052,2,464,'App\\Models\\Receipt',464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',1407.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL);
INSERT INTO `balance_libro` VALUES (491,3117,40731,3052,2,465,'App\\Models\\Receipt',465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',4381.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(492,3117,40731,3052,2,466,'App\\Models\\Receipt',466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2002.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(493,3117,40731,3052,2,467,'App\\Models\\Receipt',467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-13','2021-06-13',2488.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(494,3117,40731,3052,2,468,'App\\Models\\Receipt',468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-13','2021-06-13',3203.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(495,3117,40731,3052,2,469,'App\\Models\\Receipt',469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-13','2021-06-13',1743.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(496,3117,40731,3052,2,470,'App\\Models\\Receipt',470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-13','2021-06-13',1966.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(497,3117,40731,3052,2,471,'App\\Models\\Receipt',471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',4103.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(498,3117,40731,3052,2,472,'App\\Models\\Receipt',472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',1761.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(499,3117,40731,3052,2,473,'App\\Models\\Receipt',473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',1183.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(500,3117,40731,3052,2,474,'App\\Models\\Receipt',474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',2439.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(501,3117,40731,3052,2,475,'App\\Models\\Receipt',475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',2084.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(502,3117,40731,3052,2,476,'App\\Models\\Receipt',476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',3568.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(503,3117,40731,3052,2,477,'App\\Models\\Receipt',477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',1222.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(504,3117,40731,3052,2,478,'App\\Models\\Receipt',478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',2508.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(505,3117,40731,3052,2,479,'App\\Models\\Receipt',479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',1698.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(506,3117,40731,3052,2,480,'App\\Models\\Receipt',480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',1981.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(507,3117,40731,3052,2,481,'App\\Models\\Receipt',481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',1492.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(508,3117,40731,3052,2,482,'App\\Models\\Receipt',482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',2986.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(509,3117,40731,3052,2,483,'App\\Models\\Receipt',483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',2220.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(510,3117,40731,3052,2,484,'App\\Models\\Receipt',484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',2446.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(511,3117,40731,3052,2,485,'App\\Models\\Receipt',485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',2489.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL);
INSERT INTO `balance_libro` VALUES (512,3117,40731,3052,2,486,'App\\Models\\Receipt',486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',3379.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(513,3117,40731,3052,2,487,'App\\Models\\Receipt',487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',3575.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(514,3117,40731,3052,2,488,'App\\Models\\Receipt',488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',2417.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(515,3117,40731,3052,2,489,'App\\Models\\Receipt',489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',3637.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(516,3117,40731,3052,2,490,'App\\Models\\Receipt',490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',3396.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(517,3117,40731,3052,2,491,'App\\Models\\Receipt',491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',2706.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(518,3117,40731,3052,2,492,'App\\Models\\Receipt',492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',2349.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(519,3117,40731,3052,2,493,'App\\Models\\Receipt',493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',2254.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(520,3117,40731,3052,2,494,'App\\Models\\Receipt',494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',887.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(521,3117,40731,3052,2,495,'App\\Models\\Receipt',495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',500.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(522,3117,40731,3052,2,496,'App\\Models\\Receipt',496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',5019.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(523,3117,40731,3052,2,497,'App\\Models\\Receipt',497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',3885.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(524,3117,40731,3052,2,498,'App\\Models\\Receipt',498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',3950.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(525,3117,40731,3052,2,499,'App\\Models\\Receipt',499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',6125.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(526,3117,40731,3052,2,500,'App\\Models\\Receipt',500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',5239.00,NULL,NULL,1,'2021-07-19 17:57:07','2021-07-19 17:57:07',NULL),(527,3117,40731,3052,3,501,'App\\Models\\Receipt',501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',7045.67,NULL,NULL,1,'2021-07-19 17:59:08','2021-07-19 17:59:08',NULL),(528,3117,40731,3052,3,502,'App\\Models\\Receipt',502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',2395.20,NULL,NULL,1,'2021-07-19 17:59:08','2021-07-19 17:59:08',NULL),(529,3117,40731,3052,3,503,'App\\Models\\Receipt',503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',1741.15,NULL,NULL,1,'2021-07-19 17:59:08','2021-07-19 17:59:08',NULL),(530,3117,40731,3052,3,504,'App\\Models\\Receipt',504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',6662.73,NULL,NULL,1,'2021-07-19 17:59:08','2021-07-19 17:59:08',NULL),(531,3117,40731,3052,3,505,'App\\Models\\Receipt',505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-06','2021-06-06',800.00,NULL,NULL,1,'2021-07-19 17:59:08','2021-07-19 17:59:08',NULL),(532,3117,40731,3052,3,506,'App\\Models\\Receipt',506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',640.00,NULL,NULL,1,'2021-07-19 17:59:08','2021-07-19 17:59:08',NULL);
INSERT INTO `balance_libro` VALUES (533,3117,40731,3052,3,507,'App\\Models\\Receipt',507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',13857.48,NULL,NULL,1,'2021-07-19 17:59:08','2021-07-19 17:59:08',NULL),(534,3117,40731,3052,3,508,'App\\Models\\Receipt',508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',28457.95,NULL,NULL,1,'2021-07-19 17:59:08','2021-07-19 17:59:08',NULL),(535,3117,40731,3052,3,509,'App\\Models\\Receipt',509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',7589.91,NULL,NULL,1,'2021-07-19 17:59:08','2021-07-19 17:59:08',NULL),(536,3117,40731,3052,3,510,'App\\Models\\Receipt',510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',7881.31,NULL,NULL,1,'2021-07-19 17:59:08','2021-07-19 17:59:08',NULL),(537,3117,40731,3052,3,511,'App\\Models\\Receipt',511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',6645.91,NULL,NULL,1,'2021-07-19 17:59:08','2021-07-19 17:59:08',NULL),(538,3117,40731,3052,3,512,'App\\Models\\Receipt',512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',15202.54,NULL,NULL,1,'2021-07-19 17:59:08','2021-07-19 17:59:08',NULL),(539,3117,40731,3052,3,513,'App\\Models\\Receipt',513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',5469.56,NULL,NULL,1,'2021-07-19 17:59:08','2021-07-19 17:59:08',NULL),(540,3117,40731,3052,3,514,'App\\Models\\Receipt',514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',2742.05,NULL,NULL,1,'2021-07-19 17:59:08','2021-07-19 17:59:08',NULL),(541,3117,40731,3052,3,515,'App\\Models\\Receipt',515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',460.48,NULL,NULL,1,'2021-07-19 17:59:08','2021-07-19 17:59:08',NULL),(542,3117,40731,3051,2,516,'App\\Models\\Receipt',516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-01','2021-05-01',3699.90,NULL,NULL,1,'2021-07-19 18:06:47','2021-07-19 18:06:47',NULL),(543,3117,40731,3051,2,517,'App\\Models\\Receipt',517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-02','2021-05-02',450.00,NULL,NULL,1,'2021-07-19 18:06:47','2021-07-19 18:06:47',NULL),(544,3117,40731,3051,2,518,'App\\Models\\Receipt',518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',1500.00,NULL,NULL,1,'2021-07-19 18:06:47','2021-07-19 18:06:47',NULL),(545,3117,40731,3051,2,519,'App\\Models\\Receipt',519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',2968.00,NULL,NULL,1,'2021-07-19 18:06:47','2021-07-19 18:06:47',NULL),(546,3117,40731,3051,2,520,'App\\Models\\Receipt',520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',3356.00,NULL,NULL,1,'2021-07-19 18:06:47','2021-07-19 18:06:47',NULL),(547,3117,40731,3051,2,521,'App\\Models\\Receipt',521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',3467.00,NULL,NULL,1,'2021-07-19 18:06:47','2021-07-19 18:06:47',NULL),(548,3117,40731,3051,2,522,'App\\Models\\Receipt',522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',4525.00,NULL,NULL,1,'2021-07-19 18:06:47','2021-07-19 18:06:47',NULL),(549,3117,40731,3051,2,523,'App\\Models\\Receipt',523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',6568.00,NULL,NULL,1,'2021-07-19 18:06:47','2021-07-19 18:06:47',NULL),(550,3117,40731,3051,2,524,'App\\Models\\Receipt',524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',1674.00,NULL,NULL,1,'2021-07-19 18:06:47','2021-07-19 18:06:47',NULL),(551,3117,40731,3051,2,525,'App\\Models\\Receipt',525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',1659.00,NULL,NULL,1,'2021-07-19 18:06:47','2021-07-19 18:06:47',NULL),(552,3117,40731,3051,2,526,'App\\Models\\Receipt',526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',1077.00,NULL,NULL,1,'2021-07-19 18:06:47','2021-07-19 18:06:47',NULL),(553,3117,40731,3051,2,527,'App\\Models\\Receipt',527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',1871.00,NULL,NULL,1,'2021-07-19 18:06:47','2021-07-19 18:06:47',NULL);
INSERT INTO `balance_libro` VALUES (554,3117,40731,3051,2,528,'App\\Models\\Receipt',528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',2892.00,NULL,NULL,1,'2021-07-19 18:06:47','2021-07-19 18:06:47',NULL),(555,3117,40731,3051,2,529,'App\\Models\\Receipt',529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',3086.00,NULL,NULL,1,'2021-07-19 18:06:47','2021-07-19 18:06:47',NULL),(556,3117,40731,3051,2,530,'App\\Models\\Receipt',530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',3172.00,NULL,NULL,1,'2021-07-19 18:06:47','2021-07-19 18:06:47',NULL),(557,3117,40731,3051,2,531,'App\\Models\\Receipt',531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',2050.00,NULL,NULL,1,'2021-07-19 18:06:47','2021-07-19 18:06:47',NULL),(558,3117,40731,3051,2,532,'App\\Models\\Receipt',532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',3689.00,NULL,NULL,1,'2021-07-19 18:06:47','2021-07-19 18:06:47',NULL),(559,3117,40731,3051,2,533,'App\\Models\\Receipt',533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-23','2021-05-23',9000.00,NULL,NULL,1,'2021-07-19 18:06:47','2021-07-19 18:06:47',NULL),(560,3117,40731,3051,2,534,'App\\Models\\Receipt',534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-23','2021-05-23',3704.00,NULL,NULL,1,'2021-07-19 18:06:47','2021-07-19 18:06:47',NULL),(561,3117,40731,3051,2,535,'App\\Models\\Receipt',535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',3792.00,NULL,NULL,1,'2021-07-19 18:06:47','2021-07-19 18:06:47',NULL),(562,3117,40731,3051,2,536,'App\\Models\\Receipt',536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',3250.00,NULL,NULL,1,'2021-07-19 18:06:47','2021-07-19 18:06:47',NULL),(563,3117,40731,3051,2,537,'App\\Models\\Receipt',537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',2884.00,NULL,NULL,1,'2021-07-19 18:06:47','2021-07-19 18:06:47',NULL),(564,3117,40731,3051,2,538,'App\\Models\\Receipt',538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',2471.00,NULL,NULL,1,'2021-07-19 18:06:47','2021-07-19 18:06:47',NULL),(565,3117,40731,3051,2,539,'App\\Models\\Receipt',539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',1702.00,NULL,NULL,1,'2021-07-19 18:06:47','2021-07-19 18:06:47',NULL),(566,3117,40731,3051,2,540,'App\\Models\\Receipt',540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',3040.00,NULL,NULL,1,'2021-07-19 18:06:47','2021-07-19 18:06:47',NULL),(567,3117,40731,3051,2,541,'App\\Models\\Receipt',541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',1130.00,NULL,NULL,1,'2021-07-19 18:06:47','2021-07-19 18:06:47',NULL),(568,3117,40731,3051,2,542,'App\\Models\\Receipt',542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',1270.00,NULL,NULL,1,'2021-07-19 18:06:47','2021-07-19 18:06:47',NULL),(569,3117,40731,3051,2,543,'App\\Models\\Receipt',543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',1300.00,NULL,NULL,1,'2021-07-19 18:06:47','2021-07-19 18:06:47',NULL),(570,3117,40731,3051,2,544,'App\\Models\\Receipt',544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',917.00,NULL,NULL,1,'2021-07-19 18:06:47','2021-07-19 18:06:47',NULL),(571,3117,40731,3051,2,545,'App\\Models\\Receipt',545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',2293.00,NULL,NULL,1,'2021-07-19 18:06:47','2021-07-19 18:06:47',NULL),(572,3117,40731,3051,3,546,'App\\Models\\Receipt',546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',620.00,NULL,NULL,1,'2021-07-19 18:07:09','2021-07-19 18:07:09',NULL),(573,3117,40731,3051,3,547,'App\\Models\\Receipt',547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',6127.25,NULL,NULL,1,'2021-07-19 18:07:09','2021-07-19 18:07:09',NULL),(574,3117,40731,3051,3,548,'App\\Models\\Receipt',548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',7366.12,NULL,NULL,1,'2021-07-19 18:07:09','2021-07-19 18:07:09',NULL);
INSERT INTO `balance_libro` VALUES (575,3117,40731,3051,3,549,'App\\Models\\Receipt',549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',4994.18,NULL,NULL,1,'2021-07-19 18:07:09','2021-07-19 18:07:09',NULL),(576,3117,40731,3051,3,550,'App\\Models\\Receipt',550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',7957.50,NULL,NULL,1,'2021-07-19 18:07:09','2021-07-19 18:07:09',NULL),(577,3117,40731,3051,3,551,'App\\Models\\Receipt',551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',7037.94,NULL,NULL,1,'2021-07-19 18:07:09','2021-07-19 18:07:09',NULL),(578,3117,40731,3051,3,552,'App\\Models\\Receipt',552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',24328.31,NULL,NULL,1,'2021-07-19 18:07:09','2021-07-19 18:07:09',NULL),(579,3117,40731,3051,3,553,'App\\Models\\Receipt',553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',6993.57,NULL,NULL,1,'2021-07-19 18:07:09','2021-07-19 18:07:09',NULL),(580,3117,40731,3051,3,554,'App\\Models\\Receipt',554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',716.84,NULL,NULL,1,'2021-07-19 18:07:09','2021-07-19 18:07:09',NULL),(581,3117,40736,1542,2,402,'App\\Models\\Receipt',402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',6223.00,NULL,NULL,1,'2021-07-19 18:16:35','2021-07-19 18:17:21','2021-07-19 18:17:21'),(582,3117,40736,1542,2,403,'App\\Models\\Receipt',403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',10250.00,NULL,NULL,1,'2021-07-19 18:16:46','2021-07-19 18:17:32','2021-07-19 18:17:32'),(583,3117,40736,1541,2,402,'App\\Models\\Receipt',402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',6223.00,NULL,NULL,1,'2021-07-19 18:17:21','2021-07-19 18:17:21',NULL),(584,3117,40736,1541,2,403,'App\\Models\\Receipt',403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',10250.00,NULL,NULL,1,'2021-07-19 18:17:32','2021-07-19 18:17:32',NULL),(585,3117,40779,4571,2,555,'App\\Models\\Receipt',555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',1190.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(586,3117,40779,4571,2,556,'App\\Models\\Receipt',556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',260.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(587,3117,40779,4571,2,557,'App\\Models\\Receipt',557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',4960.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(588,3117,40779,4571,2,558,'App\\Models\\Receipt',558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',4380.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(589,3117,40779,4571,2,559,'App\\Models\\Receipt',559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-06','2021-06-06',4750.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(590,3117,40779,4571,2,560,'App\\Models\\Receipt',560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',4860.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(591,3117,40779,4571,2,561,'App\\Models\\Receipt',561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',4280.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(592,3117,40779,4571,2,562,'App\\Models\\Receipt',562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',4105.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(593,3117,40779,4571,2,563,'App\\Models\\Receipt',563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',4590.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(594,3117,40779,4571,2,564,'App\\Models\\Receipt',564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',4650.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(595,3117,40779,4571,2,565,'App\\Models\\Receipt',565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-13','2021-06-13',4680.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL);
INSERT INTO `balance_libro` VALUES (596,3117,40779,4571,2,566,'App\\Models\\Receipt',566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-13','2021-06-13',1190.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(597,3117,40779,4571,2,567,'App\\Models\\Receipt',567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',4960.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(598,3117,40779,4571,2,568,'App\\Models\\Receipt',568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',4820.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(599,3117,40779,4571,2,569,'App\\Models\\Receipt',569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',4880.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(600,3117,40779,4571,2,570,'App\\Models\\Receipt',570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',4710.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(601,3117,40779,4571,2,571,'App\\Models\\Receipt',571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',1190.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(602,3117,40779,4571,2,572,'App\\Models\\Receipt',572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',4720.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(603,3117,40779,4571,2,573,'App\\Models\\Receipt',573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',4460.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(604,3117,40779,4571,2,574,'App\\Models\\Receipt',574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-20','2021-06-20',4550.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(605,3117,40779,4571,2,575,'App\\Models\\Receipt',575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-20','2021-06-20',4260.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(606,3117,40779,4571,2,576,'App\\Models\\Receipt',576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',4960.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(607,3117,40779,4571,2,577,'App\\Models\\Receipt',577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',4680.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(608,3117,40779,4571,2,578,'App\\Models\\Receipt',578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',4725.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(609,3117,40779,4571,2,579,'App\\Models\\Receipt',579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',4150.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(610,3117,40779,4571,2,580,'App\\Models\\Receipt',580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',4050.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(611,3117,40779,4571,2,581,'App\\Models\\Receipt',581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',4320.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(612,3117,40779,4571,2,582,'App\\Models\\Receipt',582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',4850.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(613,3117,40779,4571,2,583,'App\\Models\\Receipt',583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',4860.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(614,3117,40779,4571,2,584,'App\\Models\\Receipt',584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',4720.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(615,3117,40779,4571,2,585,'App\\Models\\Receipt',585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',4510.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(616,3117,40779,4571,2,586,'App\\Models\\Receipt',586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',4280.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL);
INSERT INTO `balance_libro` VALUES (617,3117,40779,4571,2,587,'App\\Models\\Receipt',587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',4780.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(618,3117,40779,4571,2,588,'App\\Models\\Receipt',588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',4230.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(619,3117,40779,4571,2,589,'App\\Models\\Receipt',589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',4680.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(620,3117,40779,4571,2,590,'App\\Models\\Receipt',590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',4570.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(621,3117,40779,4571,2,591,'App\\Models\\Receipt',591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',4790.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(622,3117,40779,4571,2,592,'App\\Models\\Receipt',592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',4950.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(623,3117,40779,4571,2,593,'App\\Models\\Receipt',593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',4260.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(624,3117,40779,4571,2,594,'App\\Models\\Receipt',594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',4680.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(625,3117,40779,4571,2,595,'App\\Models\\Receipt',595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',4720.00,NULL,NULL,1,'2021-07-20 16:29:41','2021-07-20 16:29:41',NULL),(626,3117,40779,4571,2,596,'App\\Models\\Receipt',596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',4860.00,NULL,NULL,1,'2021-07-20 16:29:42','2021-07-20 16:29:42',NULL),(627,3117,40779,4566,2,597,'App\\Models\\Receipt',597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-02','2021-01-02',4580.00,NULL,NULL,1,'2021-07-27 17:34:36','2021-07-27 17:34:36',NULL),(628,3117,40779,4566,2,598,'App\\Models\\Receipt',598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-02','2021-01-02',4960.00,NULL,NULL,1,'2021-07-27 17:34:36','2021-07-27 17:34:36',NULL),(629,3117,40779,4566,2,599,'App\\Models\\Receipt',599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-03','2021-01-03',4750.00,NULL,NULL,1,'2021-07-27 17:34:36','2021-07-27 17:34:36',NULL),(630,3117,40779,4566,2,600,'App\\Models\\Receipt',600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-03','2021-01-03',4820.00,NULL,NULL,1,'2021-07-27 17:34:36','2021-07-27 17:34:36',NULL),(631,3117,40779,4566,2,601,'App\\Models\\Receipt',601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-03','2021-01-03',4930.00,NULL,NULL,1,'2021-07-27 17:34:36','2021-07-27 17:34:36',NULL),(632,3117,40779,4566,2,602,'App\\Models\\Receipt',602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-09','2021-01-09',4930.00,NULL,NULL,1,'2021-07-27 17:34:36','2021-07-27 17:34:36',NULL),(633,3117,40779,4566,2,603,'App\\Models\\Receipt',603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-09','2021-01-09',4120.00,NULL,NULL,1,'2021-07-27 17:34:36','2021-07-27 17:34:36',NULL),(634,3117,40779,4566,2,604,'App\\Models\\Receipt',604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-10','2021-01-10',990.00,NULL,NULL,1,'2021-07-27 17:34:36','2021-07-27 17:34:36',NULL),(635,3117,40779,4566,2,605,'App\\Models\\Receipt',605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',4820.00,NULL,NULL,1,'2021-07-27 17:34:36','2021-07-27 17:34:36',NULL),(636,3117,40779,4566,2,606,'App\\Models\\Receipt',606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',4680.00,NULL,NULL,1,'2021-07-27 17:34:36','2021-07-27 17:34:36',NULL),(637,3117,40779,4566,2,607,'App\\Models\\Receipt',607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',4760.00,NULL,NULL,1,'2021-07-27 17:34:36','2021-07-27 17:34:36',NULL);
INSERT INTO `balance_libro` VALUES (638,3117,40779,4566,2,608,'App\\Models\\Receipt',608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',4580.00,NULL,NULL,1,'2021-07-27 17:34:36','2021-07-27 17:34:36',NULL),(639,3117,40779,4566,2,609,'App\\Models\\Receipt',609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',990.00,NULL,NULL,1,'2021-07-27 17:34:36','2021-07-27 17:34:36',NULL),(640,3117,40779,4566,2,610,'App\\Models\\Receipt',610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',4670.00,NULL,NULL,1,'2021-07-27 17:34:36','2021-07-27 17:34:36',NULL),(641,3117,40779,4566,2,611,'App\\Models\\Receipt',611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',4380.00,NULL,NULL,1,'2021-07-27 17:34:36','2021-07-27 17:34:36',NULL),(642,3117,40779,4566,2,612,'App\\Models\\Receipt',612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',4730.00,NULL,NULL,1,'2021-07-27 17:34:36','2021-07-27 17:34:36',NULL),(643,3117,40779,4566,2,613,'App\\Models\\Receipt',613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-16','2021-01-16',4209.00,NULL,NULL,1,'2021-07-27 17:34:36','2021-07-27 17:34:36',NULL),(644,3117,40779,4566,2,614,'App\\Models\\Receipt',614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-17','2021-01-17',4570.00,NULL,NULL,1,'2021-07-27 17:34:36','2021-07-27 17:34:36',NULL),(645,3117,40779,4566,2,615,'App\\Models\\Receipt',615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',4930.00,NULL,NULL,1,'2021-07-27 17:34:36','2021-07-27 17:34:36',NULL),(646,3117,40779,4566,2,616,'App\\Models\\Receipt',616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',990.00,NULL,NULL,1,'2021-07-27 17:34:36','2021-07-27 17:34:36',NULL),(647,3117,40779,4566,2,617,'App\\Models\\Receipt',617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',4760.00,NULL,NULL,1,'2021-07-27 17:34:36','2021-07-27 17:34:36',NULL),(648,3117,40779,4566,2,618,'App\\Models\\Receipt',618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',2980.00,NULL,NULL,1,'2021-07-27 17:34:36','2021-07-27 17:34:36',NULL),(649,3117,40779,4566,2,619,'App\\Models\\Receipt',619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',4520.00,NULL,NULL,1,'2021-07-27 17:34:36','2021-07-27 17:34:36',NULL),(650,3117,40779,4566,2,620,'App\\Models\\Receipt',620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',4130.00,NULL,NULL,1,'2021-07-27 17:34:36','2021-07-27 17:34:36',NULL),(651,3117,40779,4566,2,621,'App\\Models\\Receipt',621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',4690.00,NULL,NULL,1,'2021-07-27 17:34:36','2021-07-27 17:34:36',NULL),(652,3117,40779,4566,2,622,'App\\Models\\Receipt',622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-23','2021-01-23',3960.00,NULL,NULL,1,'2021-07-27 17:34:36','2021-07-27 17:34:36',NULL),(653,3117,40779,4566,2,623,'App\\Models\\Receipt',623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-23','2021-01-23',4160.00,NULL,NULL,1,'2021-07-27 17:34:36','2021-07-27 17:34:36',NULL),(654,3117,40779,4566,2,624,'App\\Models\\Receipt',624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-24','2021-01-24',4720.00,NULL,NULL,1,'2021-07-27 17:34:36','2021-07-27 17:34:36',NULL),(655,3117,40779,4566,2,625,'App\\Models\\Receipt',625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-24','2021-01-24',4690.00,NULL,NULL,1,'2021-07-27 17:34:36','2021-07-27 17:34:36',NULL),(656,3117,40779,4566,2,626,'App\\Models\\Receipt',626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',4440.00,NULL,NULL,1,'2021-07-27 17:34:36','2021-07-27 17:34:36',NULL),(657,3117,40779,4566,2,627,'App\\Models\\Receipt',627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',4380.00,NULL,NULL,1,'2021-07-27 17:34:36','2021-07-27 17:34:36',NULL),(658,3117,40779,4566,2,628,'App\\Models\\Receipt',628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',4760.00,NULL,NULL,1,'2021-07-27 17:34:36','2021-07-27 17:34:36',NULL);
INSERT INTO `balance_libro` VALUES (659,3117,40779,4566,2,629,'App\\Models\\Receipt',629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',4530.00,NULL,NULL,1,'2021-07-27 17:34:36','2021-07-27 17:34:36',NULL),(660,3117,40779,4566,2,630,'App\\Models\\Receipt',630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',4130.00,NULL,NULL,1,'2021-07-27 17:34:36','2021-07-27 17:34:36',NULL),(661,3117,40779,4566,2,631,'App\\Models\\Receipt',631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',4750.00,NULL,NULL,1,'2021-07-27 17:34:36','2021-07-27 17:34:36',NULL),(662,3117,40779,4566,2,632,'App\\Models\\Receipt',632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',4280.00,NULL,NULL,1,'2021-07-27 17:34:36','2021-07-27 17:34:36',NULL),(663,3117,40779,4566,3,633,'App\\Models\\Receipt',633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',11777.04,NULL,NULL,1,'2021-07-27 17:34:53','2021-07-27 17:34:53',NULL),(664,3117,40779,4566,3,634,'App\\Models\\Receipt',634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',45894.38,NULL,NULL,1,'2021-07-27 17:34:53','2021-07-27 17:34:53',NULL),(665,3117,40779,4566,3,635,'App\\Models\\Receipt',635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',24329.67,NULL,NULL,1,'2021-07-27 17:34:53','2021-07-27 17:34:53',NULL),(666,3117,40779,4566,3,636,'App\\Models\\Receipt',636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',48400.00,NULL,NULL,1,'2021-07-27 17:34:53','2021-07-27 17:34:53',NULL),(667,3117,40779,4566,3,637,'App\\Models\\Receipt',637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',33935.77,NULL,NULL,1,'2021-07-27 17:34:53','2021-07-27 17:34:53',NULL),(668,3117,40779,4566,3,638,'App\\Models\\Receipt',638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',2108.30,NULL,NULL,1,'2021-07-27 17:34:53','2021-07-27 17:34:53',NULL),(669,3117,40779,4566,3,639,'App\\Models\\Receipt',639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',1401.54,NULL,NULL,1,'2021-07-27 17:34:53','2021-07-27 17:34:53',NULL),(670,3117,40779,4566,3,640,'App\\Models\\Receipt',640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',1671.07,NULL,NULL,1,'2021-07-27 17:34:53','2021-07-27 17:34:53',NULL),(671,3117,40779,4566,3,641,'App\\Models\\Receipt',641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',16493.89,NULL,NULL,1,'2021-07-27 17:34:53','2021-07-27 17:34:53',NULL),(672,3117,40779,4566,3,642,'App\\Models\\Receipt',642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',2503.30,NULL,NULL,1,'2021-07-27 17:34:53','2021-07-27 17:34:53',NULL),(673,3117,40779,4566,3,643,'App\\Models\\Receipt',643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',2167.48,NULL,NULL,1,'2021-07-27 17:34:53','2021-07-27 17:34:53',NULL),(674,3117,40779,4566,3,644,'App\\Models\\Receipt',644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',200000.00,NULL,NULL,1,'2021-07-27 17:34:53','2021-07-27 17:34:53',NULL),(675,3117,40779,4566,3,645,'App\\Models\\Receipt',645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',2029.30,NULL,NULL,1,'2021-07-27 17:34:53','2021-07-27 17:34:53',NULL),(676,3117,40779,4566,3,646,'App\\Models\\Receipt',646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',1654.40,NULL,NULL,1,'2021-07-27 17:34:53','2021-07-27 17:34:53',NULL),(677,3117,40779,4566,3,647,'App\\Models\\Receipt',647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',2567.18,NULL,NULL,1,'2021-07-27 17:34:53','2021-07-27 17:34:53',NULL),(678,3117,40779,4567,2,648,'App\\Models\\Receipt',648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',1050.00,NULL,NULL,1,'2021-07-27 17:39:23','2021-07-27 17:39:23',NULL),(679,3117,40779,4567,2,649,'App\\Models\\Receipt',649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',760.00,NULL,NULL,1,'2021-07-27 17:39:23','2021-07-27 17:39:23',NULL);
INSERT INTO `balance_libro` VALUES (680,3117,40779,4567,2,650,'App\\Models\\Receipt',650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',4630.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL),(681,3117,40779,4567,2,651,'App\\Models\\Receipt',651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',4160.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL),(682,3117,40779,4567,2,652,'App\\Models\\Receipt',652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',4560.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL),(683,3117,40779,4567,2,653,'App\\Models\\Receipt',653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',4290.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL),(684,3117,40779,4567,2,654,'App\\Models\\Receipt',654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-06','2021-02-06',4400.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL),(685,3117,40779,4567,2,655,'App\\Models\\Receipt',655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-07','2021-02-07',4820.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL),(686,3117,40779,4567,2,656,'App\\Models\\Receipt',656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',4630.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL),(687,3117,40779,4567,2,657,'App\\Models\\Receipt',657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',1035.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL),(688,3117,40779,4567,2,658,'App\\Models\\Receipt',658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',4630.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL),(689,3117,40779,4567,2,659,'App\\Models\\Receipt',659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',4220.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL),(690,3117,40779,4567,2,660,'App\\Models\\Receipt',660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',4580.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL),(691,3117,40779,4567,2,661,'App\\Models\\Receipt',661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',1050.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL),(692,3117,40779,4567,2,662,'App\\Models\\Receipt',662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',4400.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL),(693,3117,40779,4567,2,663,'App\\Models\\Receipt',663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-13','2021-02-13',4820.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL),(694,3117,40779,4567,2,664,'App\\Models\\Receipt',664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-14','2021-02-14',4690.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL),(695,3117,40779,4567,2,665,'App\\Models\\Receipt',665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-15','2021-02-15',4890.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL),(696,3117,40779,4567,2,666,'App\\Models\\Receipt',666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-15','2021-02-15',4760.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL),(697,3117,40779,4567,2,667,'App\\Models\\Receipt',667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-15','2021-02-15',1035.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL),(698,3117,40779,4567,2,668,'App\\Models\\Receipt',668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-15','2021-02-15',1050.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL),(699,3117,40779,4567,2,669,'App\\Models\\Receipt',669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-15','2021-02-15',4900.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL),(700,3117,40779,4567,2,670,'App\\Models\\Receipt',670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-16','2021-02-16',1560.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL);
INSERT INTO `balance_libro` VALUES (701,3117,40779,4567,2,671,'App\\Models\\Receipt',671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-16','2021-02-16',4600.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL),(702,3117,40779,4567,2,672,'App\\Models\\Receipt',672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',4920.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL),(703,3117,40779,4567,2,673,'App\\Models\\Receipt',673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',4830.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL),(704,3117,40779,4567,2,674,'App\\Models\\Receipt',674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',4550.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL),(705,3117,40779,4567,2,675,'App\\Models\\Receipt',675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',4530.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL),(706,3117,40779,4567,2,676,'App\\Models\\Receipt',676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',4405.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL),(707,3117,40779,4567,2,677,'App\\Models\\Receipt',677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',4760.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL),(708,3117,40779,4567,2,678,'App\\Models\\Receipt',678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',4560.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL),(709,3117,40779,4567,2,679,'App\\Models\\Receipt',679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',4890.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL),(710,3117,40779,4567,2,680,'App\\Models\\Receipt',680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',4710.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL),(711,3117,40779,4567,2,681,'App\\Models\\Receipt',681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',4100.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL),(712,3117,40779,4567,2,682,'App\\Models\\Receipt',682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',4330.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL),(713,3117,40779,4567,2,683,'App\\Models\\Receipt',683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',4760.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL),(714,3117,40779,4567,2,684,'App\\Models\\Receipt',684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',4236.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL),(715,3117,40779,4567,2,685,'App\\Models\\Receipt',685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',1050.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL),(716,3117,40779,4567,2,686,'App\\Models\\Receipt',686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',4960.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL),(717,3117,40779,4567,2,687,'App\\Models\\Receipt',687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',4380.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL),(718,3117,40779,4567,2,688,'App\\Models\\Receipt',688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',4260.00,NULL,NULL,1,'2021-07-27 17:39:24','2021-07-27 17:39:24',NULL),(719,3117,40779,4567,2,689,'App\\Models\\Receipt',689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',4970.00,NULL,NULL,1,'2021-07-27 17:39:25','2021-07-27 17:39:25',NULL),(720,3117,40779,4567,2,690,'App\\Models\\Receipt',690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',4100.00,NULL,NULL,1,'2021-07-27 17:39:25','2021-07-27 17:39:25',NULL),(721,3117,40779,4567,2,691,'App\\Models\\Receipt',691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',4360.00,NULL,NULL,1,'2021-07-27 17:39:25','2021-07-27 17:39:25',NULL);
INSERT INTO `balance_libro` VALUES (722,3117,40779,4567,2,692,'App\\Models\\Receipt',692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',4250.00,NULL,NULL,1,'2021-07-27 17:39:25','2021-07-27 17:39:25',NULL),(723,3117,40779,4567,2,693,'App\\Models\\Receipt',693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',4370.00,NULL,NULL,1,'2021-07-27 17:39:25','2021-07-27 17:39:25',NULL),(724,3117,40779,4567,2,694,'App\\Models\\Receipt',694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',4680.00,NULL,NULL,1,'2021-07-27 17:39:25','2021-07-27 17:39:25',NULL),(725,3117,40779,4568,2,695,'App\\Models\\Receipt',695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',4280.00,NULL,NULL,1,'2021-07-27 17:40:32','2021-07-27 17:40:32',NULL),(726,3117,40779,4568,2,696,'App\\Models\\Receipt',696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',4440.00,NULL,NULL,1,'2021-07-27 17:40:32','2021-07-27 17:40:32',NULL),(727,3117,40779,4568,2,697,'App\\Models\\Receipt',697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',4760.00,NULL,NULL,1,'2021-07-27 17:40:32','2021-07-27 17:40:32',NULL),(728,3117,40779,4568,2,698,'App\\Models\\Receipt',698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',4330.00,NULL,NULL,1,'2021-07-27 17:40:32','2021-07-27 17:40:32',NULL),(729,3117,40779,4568,2,699,'App\\Models\\Receipt',699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',4820.00,NULL,NULL,1,'2021-07-27 17:40:32','2021-07-27 17:40:32',NULL),(730,3117,40779,4568,2,700,'App\\Models\\Receipt',700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',4290.00,NULL,NULL,1,'2021-07-27 17:40:32','2021-07-27 17:40:32',NULL),(731,3117,40779,4568,2,701,'App\\Models\\Receipt',701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',4190.00,NULL,NULL,1,'2021-07-27 17:40:32','2021-07-27 17:40:32',NULL),(732,3117,40779,4568,2,702,'App\\Models\\Receipt',702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',4830.00,NULL,NULL,1,'2021-07-27 17:40:32','2021-07-27 17:40:32',NULL),(733,3117,40779,4568,2,703,'App\\Models\\Receipt',703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',3960.00,NULL,NULL,1,'2021-07-27 17:40:32','2021-07-27 17:40:32',NULL),(734,3117,40779,4568,2,704,'App\\Models\\Receipt',704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-07','2021-03-07',3870.00,NULL,NULL,1,'2021-07-27 17:40:32','2021-07-27 17:40:32',NULL),(735,3117,40779,4568,2,705,'App\\Models\\Receipt',705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',4680.00,NULL,NULL,1,'2021-07-27 17:40:32','2021-07-27 17:40:32',NULL),(736,3117,40779,4568,2,706,'App\\Models\\Receipt',706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',4680.00,NULL,NULL,1,'2021-07-27 17:40:32','2021-07-27 17:40:32',NULL),(737,3117,40779,4568,2,707,'App\\Models\\Receipt',707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',4160.00,NULL,NULL,1,'2021-07-27 17:40:32','2021-07-27 17:40:32',NULL),(738,3117,40779,4568,2,708,'App\\Models\\Receipt',708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1050.00,NULL,NULL,1,'2021-07-27 17:40:32','2021-07-27 17:40:32',NULL),(739,3117,40779,4568,2,709,'App\\Models\\Receipt',709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1050.00,NULL,NULL,1,'2021-07-27 17:40:32','2021-07-27 17:40:32',NULL),(740,3117,40779,4568,2,710,'App\\Models\\Receipt',710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',4950.00,NULL,NULL,1,'2021-07-27 17:40:32','2021-07-27 17:40:32',NULL),(741,3117,40779,4568,2,711,'App\\Models\\Receipt',711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',4830.00,NULL,NULL,1,'2021-07-27 17:40:32','2021-07-27 17:40:32',NULL),(742,3117,40779,4568,2,712,'App\\Models\\Receipt',712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',4555.00,NULL,NULL,1,'2021-07-27 17:40:32','2021-07-27 17:40:32',NULL);
INSERT INTO `balance_libro` VALUES (743,3117,40779,4568,2,713,'App\\Models\\Receipt',713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',4850.00,NULL,NULL,1,'2021-07-27 17:40:32','2021-07-27 17:40:32',NULL),(744,3117,40779,4568,2,714,'App\\Models\\Receipt',714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',4760.00,NULL,NULL,1,'2021-07-27 17:40:32','2021-07-27 17:40:32',NULL),(745,3117,40779,4568,2,715,'App\\Models\\Receipt',715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',4200.00,NULL,NULL,1,'2021-07-27 17:40:32','2021-07-27 17:40:32',NULL),(746,3117,40779,4568,2,716,'App\\Models\\Receipt',716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',1050.00,NULL,NULL,1,'2021-07-27 17:40:32','2021-07-27 17:40:32',NULL),(747,3117,40779,4568,2,717,'App\\Models\\Receipt',717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',4440.00,NULL,NULL,1,'2021-07-27 17:40:32','2021-07-27 17:40:32',NULL),(748,3117,40779,4568,2,718,'App\\Models\\Receipt',718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-14','2021-03-14',4590.00,NULL,NULL,1,'2021-07-27 17:40:32','2021-07-27 17:40:32',NULL),(749,3117,40779,4568,2,719,'App\\Models\\Receipt',719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-14','2021-03-14',4832.00,NULL,NULL,1,'2021-07-27 17:40:32','2021-07-27 17:40:32',NULL),(750,3117,40779,4568,2,720,'App\\Models\\Receipt',720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',4350.00,NULL,NULL,1,'2021-07-27 17:40:32','2021-07-27 17:40:32',NULL),(751,3117,40779,4568,2,721,'App\\Models\\Receipt',721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',4980.00,NULL,NULL,1,'2021-07-27 17:40:32','2021-07-27 17:40:32',NULL),(752,3117,40779,4568,2,722,'App\\Models\\Receipt',722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',4280.00,NULL,NULL,1,'2021-07-27 17:40:32','2021-07-27 17:40:32',NULL),(753,3117,40779,4568,2,723,'App\\Models\\Receipt',723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',4160.00,NULL,NULL,1,'2021-07-27 17:40:32','2021-07-27 17:40:32',NULL),(754,3117,40779,4568,2,724,'App\\Models\\Receipt',724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',650.00,NULL,NULL,1,'2021-07-27 17:40:32','2021-07-27 17:40:32',NULL),(755,3117,40779,4568,2,725,'App\\Models\\Receipt',725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',1050.00,NULL,NULL,1,'2021-07-27 17:40:32','2021-07-27 17:40:32',NULL),(756,3117,40779,4568,2,726,'App\\Models\\Receipt',726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',4860.00,NULL,NULL,1,'2021-07-27 17:40:32','2021-07-27 17:40:32',NULL),(757,3117,40779,4568,2,727,'App\\Models\\Receipt',727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',4930.00,NULL,NULL,1,'2021-07-27 17:40:32','2021-07-27 17:40:32',NULL),(758,3117,40779,4568,2,728,'App\\Models\\Receipt',728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',4710.00,NULL,NULL,1,'2021-07-27 17:40:33','2021-07-27 17:40:33',NULL),(759,3117,40779,4568,2,729,'App\\Models\\Receipt',729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',4870.00,NULL,NULL,1,'2021-07-27 17:40:33','2021-07-27 17:40:33',NULL),(760,3117,40779,4568,2,730,'App\\Models\\Receipt',730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',4760.00,NULL,NULL,1,'2021-07-27 17:40:33','2021-07-27 17:40:33',NULL),(761,3117,40779,4568,2,731,'App\\Models\\Receipt',731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',4630.00,NULL,NULL,1,'2021-07-27 17:40:33','2021-07-27 17:40:33',NULL),(762,3117,40779,4568,2,732,'App\\Models\\Receipt',732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',4130.00,NULL,NULL,1,'2021-07-27 17:40:33','2021-07-27 17:40:33',NULL),(763,3117,40779,4568,2,733,'App\\Models\\Receipt',733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',4230.00,NULL,NULL,1,'2021-07-27 17:40:33','2021-07-27 17:40:33',NULL);
INSERT INTO `balance_libro` VALUES (764,3117,40779,4568,2,734,'App\\Models\\Receipt',734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-24','2021-03-24',4280.00,NULL,NULL,1,'2021-07-27 17:40:33','2021-07-27 17:40:33',NULL),(765,3117,40779,4568,2,735,'App\\Models\\Receipt',735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',4550.00,NULL,NULL,1,'2021-07-27 17:40:33','2021-07-27 17:40:33',NULL),(766,3117,40779,4568,2,736,'App\\Models\\Receipt',736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',4930.00,NULL,NULL,1,'2021-07-27 17:40:33','2021-07-27 17:40:33',NULL),(767,3117,40779,4568,2,737,'App\\Models\\Receipt',737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',4860.00,NULL,NULL,1,'2021-07-27 17:40:33','2021-07-27 17:40:33',NULL),(768,3117,40779,4568,2,738,'App\\Models\\Receipt',738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-28','2021-03-28',4820.00,NULL,NULL,1,'2021-07-27 17:40:33','2021-07-27 17:40:33',NULL),(769,3117,40779,4568,2,739,'App\\Models\\Receipt',739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-28','2021-03-28',4570.00,NULL,NULL,1,'2021-07-27 17:40:33','2021-07-27 17:40:33',NULL),(770,3117,40779,4569,2,740,'App\\Models\\Receipt',740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',4830.00,NULL,NULL,1,'2021-07-27 17:41:52','2021-07-27 17:41:52',NULL),(771,3117,40779,4569,2,741,'App\\Models\\Receipt',741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-04','2021-04-04',4280.00,NULL,NULL,1,'2021-07-27 17:41:52','2021-07-27 17:41:52',NULL),(772,3117,40779,4569,2,742,'App\\Models\\Receipt',742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',4280.00,NULL,NULL,1,'2021-07-27 17:41:52','2021-07-27 17:41:52',NULL),(773,3117,40779,4569,2,743,'App\\Models\\Receipt',743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',1650.00,NULL,NULL,1,'2021-07-27 17:41:52','2021-07-27 17:41:52',NULL),(774,3117,40779,4569,2,744,'App\\Models\\Receipt',744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',4380.00,NULL,NULL,1,'2021-07-27 17:41:52','2021-07-27 17:41:52',NULL),(775,3117,40779,4569,2,745,'App\\Models\\Receipt',745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',1650.00,NULL,NULL,1,'2021-07-27 17:41:52','2021-07-27 17:41:52',NULL),(776,3117,40779,4569,2,746,'App\\Models\\Receipt',746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',1100.00,NULL,NULL,1,'2021-07-27 17:41:52','2021-07-27 17:41:52',NULL),(777,3117,40779,4569,2,747,'App\\Models\\Receipt',747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',4390.00,NULL,NULL,1,'2021-07-27 17:41:52','2021-07-27 17:41:52',NULL),(778,3117,40779,4569,2,748,'App\\Models\\Receipt',748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',4630.00,NULL,NULL,1,'2021-07-27 17:41:52','2021-07-27 17:41:52',NULL),(779,3117,40779,4569,2,749,'App\\Models\\Receipt',749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',4720.00,NULL,NULL,1,'2021-07-27 17:41:52','2021-07-27 17:41:52',NULL),(780,3117,40779,4569,2,750,'App\\Models\\Receipt',750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',4390.00,NULL,NULL,1,'2021-07-27 17:41:52','2021-07-27 17:41:52',NULL),(781,3117,40779,4569,2,751,'App\\Models\\Receipt',751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',4580.00,NULL,NULL,1,'2021-07-27 17:41:52','2021-07-27 17:41:52',NULL),(782,3117,40779,4569,2,752,'App\\Models\\Receipt',752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',4280.00,NULL,NULL,1,'2021-07-27 17:41:52','2021-07-27 17:41:52',NULL),(783,3117,40779,4569,2,753,'App\\Models\\Receipt',753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-11','2021-04-11',4480.00,NULL,NULL,1,'2021-07-27 17:41:52','2021-07-27 17:41:52',NULL),(784,3117,40779,4569,2,754,'App\\Models\\Receipt',754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',4860.00,NULL,NULL,1,'2021-07-27 17:41:52','2021-07-27 17:41:52',NULL);
INSERT INTO `balance_libro` VALUES (785,3117,40779,4569,2,755,'App\\Models\\Receipt',755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',4690.00,NULL,NULL,1,'2021-07-27 17:41:52','2021-07-27 17:41:52',NULL),(786,3117,40779,4569,2,756,'App\\Models\\Receipt',756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',4850.00,NULL,NULL,1,'2021-07-27 17:41:52','2021-07-27 17:41:52',NULL),(787,3117,40779,4569,2,757,'App\\Models\\Receipt',757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',1100.00,NULL,NULL,1,'2021-07-27 17:41:52','2021-07-27 17:41:52',NULL),(788,3117,40779,4569,2,758,'App\\Models\\Receipt',758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',4360.00,NULL,NULL,1,'2021-07-27 17:41:52','2021-07-27 17:41:52',NULL),(789,3117,40779,4569,2,759,'App\\Models\\Receipt',759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',4250.00,NULL,NULL,1,'2021-07-27 17:41:53','2021-07-27 17:41:53',NULL),(790,3117,40779,4569,2,760,'App\\Models\\Receipt',760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',4580.00,NULL,NULL,1,'2021-07-27 17:41:53','2021-07-27 17:41:53',NULL),(791,3117,40779,4569,2,761,'App\\Models\\Receipt',761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-18','2021-04-18',4270.00,NULL,NULL,1,'2021-07-27 17:41:53','2021-07-27 17:41:53',NULL),(792,3117,40779,4569,2,762,'App\\Models\\Receipt',762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',4930.00,NULL,NULL,1,'2021-07-27 17:41:53','2021-07-27 17:41:53',NULL),(793,3117,40779,4569,2,763,'App\\Models\\Receipt',763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',4760.00,NULL,NULL,1,'2021-07-27 17:41:53','2021-07-27 17:41:53',NULL),(794,3117,40779,4569,2,764,'App\\Models\\Receipt',764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',4820.00,NULL,NULL,1,'2021-07-27 17:41:53','2021-07-27 17:41:53',NULL),(795,3117,40779,4569,2,765,'App\\Models\\Receipt',765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',4690.00,NULL,NULL,1,'2021-07-27 17:41:53','2021-07-27 17:41:53',NULL),(796,3117,40779,4569,2,766,'App\\Models\\Receipt',766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',4530.00,NULL,NULL,1,'2021-07-27 17:41:53','2021-07-27 17:41:53',NULL),(797,3117,40779,4569,2,767,'App\\Models\\Receipt',767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',4680.00,NULL,NULL,1,'2021-07-27 17:41:53','2021-07-27 17:41:53',NULL),(798,3117,40779,4569,2,768,'App\\Models\\Receipt',768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',1240.00,NULL,NULL,1,'2021-07-27 17:41:53','2021-07-27 17:41:53',NULL),(799,3117,40779,4569,2,769,'App\\Models\\Receipt',769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',4930.00,NULL,NULL,1,'2021-07-27 17:41:53','2021-07-27 17:41:53',NULL),(800,3117,40779,4569,2,770,'App\\Models\\Receipt',770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',4860.00,NULL,NULL,1,'2021-07-27 17:41:53','2021-07-27 17:41:53',NULL),(801,3117,40779,4569,2,771,'App\\Models\\Receipt',771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',4550.00,NULL,NULL,1,'2021-07-27 17:41:53','2021-07-27 17:41:53',NULL),(802,3117,40779,4569,2,772,'App\\Models\\Receipt',772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',4230.00,NULL,NULL,1,'2021-07-27 17:41:53','2021-07-27 17:41:53',NULL),(803,3117,40779,4569,2,773,'App\\Models\\Receipt',773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',4960.00,NULL,NULL,1,'2021-07-27 17:41:53','2021-07-27 17:41:53',NULL),(804,3117,40779,4569,2,774,'App\\Models\\Receipt',774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',4380.00,NULL,NULL,1,'2021-07-27 17:41:53','2021-07-27 17:41:53',NULL),(805,3117,40779,4569,2,775,'App\\Models\\Receipt',775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',4820.00,NULL,NULL,1,'2021-07-27 17:41:53','2021-07-27 17:41:53',NULL);
INSERT INTO `balance_libro` VALUES (806,3117,40779,4569,2,776,'App\\Models\\Receipt',776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',4680.00,NULL,NULL,1,'2021-07-27 17:41:53','2021-07-27 17:41:53',NULL),(807,3117,40779,4569,2,777,'App\\Models\\Receipt',777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',4160.00,NULL,NULL,1,'2021-07-27 17:41:53','2021-07-27 17:41:53',NULL),(808,3117,40779,4569,2,778,'App\\Models\\Receipt',778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',4630.00,NULL,NULL,1,'2021-07-27 17:41:53','2021-07-27 17:41:53',NULL),(809,3117,40779,4569,2,779,'App\\Models\\Receipt',779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',4690.00,NULL,NULL,1,'2021-07-27 17:41:53','2021-07-27 17:41:53',NULL),(810,3117,40779,4569,2,780,'App\\Models\\Receipt',780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',4860.00,NULL,NULL,1,'2021-07-27 17:41:53','2021-07-27 17:41:53',NULL),(811,3117,40779,4569,2,781,'App\\Models\\Receipt',781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',4850.00,NULL,NULL,1,'2021-07-27 17:41:53','2021-07-27 17:41:53',NULL),(812,3117,40779,4569,2,782,'App\\Models\\Receipt',782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',4160.00,NULL,NULL,1,'2021-07-27 17:41:53','2021-07-27 17:41:53',NULL),(813,3117,40779,4569,2,783,'App\\Models\\Receipt',783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',4670.00,NULL,NULL,1,'2021-07-27 17:41:53','2021-07-27 17:41:53',NULL),(814,3117,40779,4567,3,784,'App\\Models\\Receipt',784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',22385.00,NULL,NULL,1,'2021-07-27 17:46:26','2021-07-27 17:46:26',NULL),(815,3117,40779,4567,3,785,'App\\Models\\Receipt',785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',3275.32,NULL,NULL,1,'2021-07-27 17:46:26','2021-07-27 17:46:26',NULL),(816,3117,40779,4567,3,786,'App\\Models\\Receipt',786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',34935.83,NULL,NULL,1,'2021-07-27 17:46:26','2021-07-27 17:46:26',NULL),(817,3117,40779,4567,3,787,'App\\Models\\Receipt',787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',7196.64,NULL,NULL,1,'2021-07-27 17:46:26','2021-07-27 17:46:26',NULL),(818,3117,40779,4567,3,788,'App\\Models\\Receipt',788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-06','2021-02-06',21200.00,NULL,NULL,1,'2021-07-27 17:46:26','2021-07-27 17:46:26',NULL),(819,3117,40779,4567,3,789,'App\\Models\\Receipt',789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',7093.10,NULL,NULL,1,'2021-07-27 17:46:26','2021-07-27 17:46:26',NULL),(820,3117,40779,4567,3,790,'App\\Models\\Receipt',790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',22390.45,NULL,NULL,1,'2021-07-27 17:46:26','2021-07-27 17:46:26',NULL),(821,3117,40779,4567,3,791,'App\\Models\\Receipt',791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',19834.61,NULL,NULL,1,'2021-07-27 17:46:26','2021-07-27 17:46:26',NULL),(822,3117,40779,4567,3,792,'App\\Models\\Receipt',792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',15447.32,NULL,NULL,1,'2021-07-27 17:46:26','2021-07-27 17:46:26',NULL),(823,3117,40779,4567,3,793,'App\\Models\\Receipt',793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',14567.90,NULL,NULL,1,'2021-07-27 17:46:26','2021-07-27 17:46:26',NULL),(824,3117,40779,4567,3,794,'App\\Models\\Receipt',794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',15049.98,NULL,NULL,1,'2021-07-27 17:46:26','2021-07-27 17:46:26',NULL),(825,3117,40779,4567,3,795,'App\\Models\\Receipt',795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',15049.99,NULL,NULL,1,'2021-07-27 17:46:26','2021-07-27 17:46:26',NULL),(826,3117,40779,4567,3,796,'App\\Models\\Receipt',796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',14393.28,NULL,NULL,1,'2021-07-27 17:46:26','2021-07-27 17:46:26',NULL);
INSERT INTO `balance_libro` VALUES (827,3117,40779,4568,3,797,'App\\Models\\Receipt',797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',1390.00,NULL,NULL,1,'2021-07-27 17:47:25','2021-07-27 17:47:25',NULL),(828,3117,40779,4568,3,798,'App\\Models\\Receipt',798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',1396.64,NULL,NULL,1,'2021-07-27 17:47:25','2021-07-27 17:47:25',NULL),(829,3117,40779,4568,3,799,'App\\Models\\Receipt',799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',20000.00,NULL,NULL,1,'2021-07-27 17:47:25','2021-07-27 17:47:25',NULL),(830,3117,40779,4568,3,800,'App\\Models\\Receipt',800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',28830.57,NULL,NULL,1,'2021-07-27 17:47:25','2021-07-27 17:47:25',NULL),(831,3117,40779,4568,3,801,'App\\Models\\Receipt',801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',14356.17,NULL,NULL,1,'2021-07-27 17:47:26','2021-07-27 17:47:26',NULL),(832,3117,40779,4568,3,802,'App\\Models\\Receipt',802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',44000.00,NULL,NULL,1,'2021-07-27 17:47:26','2021-07-27 17:47:26',NULL),(833,3117,40779,4568,3,803,'App\\Models\\Receipt',803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',21425.54,NULL,NULL,1,'2021-07-27 17:47:26','2021-07-27 17:47:26',NULL),(834,3117,40779,4568,3,804,'App\\Models\\Receipt',804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',3990.05,NULL,NULL,1,'2021-07-27 17:47:26','2021-07-27 17:47:26',NULL),(835,3117,40779,4568,3,805,'App\\Models\\Receipt',805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',7775.54,NULL,NULL,1,'2021-07-27 17:47:26','2021-07-27 17:47:26',NULL),(836,3117,40779,4568,3,806,'App\\Models\\Receipt',806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',4472.16,NULL,NULL,1,'2021-07-27 17:47:26','2021-07-27 17:47:26',NULL),(837,3117,40779,4569,3,807,'App\\Models\\Receipt',807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',19884.02,NULL,NULL,1,'2021-07-27 17:49:59','2021-07-27 17:49:59',NULL),(838,3117,40779,4569,3,808,'App\\Models\\Receipt',808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',26250.00,NULL,NULL,1,'2021-07-27 17:49:59','2021-07-27 17:49:59',NULL),(839,3117,40779,4569,3,809,'App\\Models\\Receipt',809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',1690.00,NULL,NULL,1,'2021-07-27 17:49:59','2021-07-27 17:49:59',NULL),(840,3117,40779,4569,3,810,'App\\Models\\Receipt',810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',10932.24,NULL,NULL,1,'2021-07-27 17:49:59','2021-07-27 17:49:59',NULL),(841,3117,40779,4569,3,811,'App\\Models\\Receipt',811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',3700.00,NULL,NULL,1,'2021-07-27 17:49:59','2021-07-27 17:49:59',NULL),(842,3117,40779,4569,3,812,'App\\Models\\Receipt',812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',19834.61,NULL,NULL,1,'2021-07-27 17:49:59','2021-07-27 17:49:59',NULL),(843,3117,40779,4569,3,813,'App\\Models\\Receipt',813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',37107.45,NULL,NULL,1,'2021-07-27 17:49:59','2021-07-27 17:49:59',NULL),(844,3117,40779,4569,3,814,'App\\Models\\Receipt',814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',6559.35,NULL,NULL,1,'2021-07-27 17:49:59','2021-07-27 17:49:59',NULL),(845,3117,40779,4569,3,815,'App\\Models\\Receipt',815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',6559.35,NULL,NULL,1,'2021-07-27 17:50:00','2021-07-27 17:50:00',NULL),(846,3117,40779,4569,3,816,'App\\Models\\Receipt',816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',2342.56,NULL,NULL,1,'2021-07-27 17:50:00','2021-07-27 17:50:00',NULL),(847,3117,40779,4569,3,817,'App\\Models\\Receipt',817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',27400.00,NULL,NULL,1,'2021-07-27 17:50:00','2021-07-27 17:50:00',NULL);
INSERT INTO `balance_libro` VALUES (848,3117,40779,4569,3,818,'App\\Models\\Receipt',818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',20768.20,NULL,NULL,1,'2021-07-27 17:50:00','2021-07-27 17:50:00',NULL),(849,3117,40779,4569,3,819,'App\\Models\\Receipt',819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',5824.00,NULL,NULL,1,'2021-07-27 17:50:00','2021-07-27 17:50:00',NULL),(850,3117,40779,4569,3,820,'App\\Models\\Receipt',820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',3368.64,NULL,NULL,1,'2021-07-27 17:50:00','2021-07-27 17:50:00',NULL),(851,3117,40736,1543,2,821,'App\\Models\\Receipt',821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',12985.00,NULL,NULL,1,'2021-08-10 15:13:20','2021-08-10 15:13:20',NULL),(852,3117,40736,1543,2,822,'App\\Models\\Receipt',822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',13000.00,NULL,NULL,1,'2021-08-10 15:13:21','2021-08-10 15:13:21',NULL),(853,3117,40736,1543,2,823,'App\\Models\\Receipt',823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',10111.00,NULL,NULL,1,'2021-08-10 15:13:21','2021-08-10 15:13:21',NULL),(854,3117,40736,1543,3,824,'App\\Models\\Receipt',824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',5961.00,NULL,NULL,1,'2021-08-10 15:13:43','2021-08-10 15:13:43',NULL),(855,3117,40736,1543,3,825,'App\\Models\\Receipt',825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',29614.00,NULL,NULL,1,'2021-08-10 15:13:43','2021-08-10 15:13:43',NULL),(856,3117,40736,1543,8,826,'App\\Models\\Receipt',826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',30.00,NULL,NULL,1,'2021-08-10 16:04:57','2021-08-10 16:04:57',NULL),(857,3117,40736,1543,16,190,'App\\Models\\PeriodLiquidation',NULL,190,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',902.40,NULL,NULL,1,'2021-08-10 16:05:44','2021-08-10 16:05:44',NULL),(858,3117,40779,4572,2,827,'App\\Models\\Receipt',827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',4150.00,NULL,NULL,1,'2021-08-10 18:45:31','2021-08-10 18:45:31',NULL),(859,3117,40779,4572,2,828,'App\\Models\\Receipt',828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',330.00,NULL,NULL,1,'2021-08-10 18:45:31','2021-08-10 18:45:31',NULL),(860,3117,40779,4572,2,829,'App\\Models\\Receipt',829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',4360.00,NULL,NULL,1,'2021-08-10 18:45:31','2021-08-10 18:45:31',NULL),(861,3117,40779,4572,2,830,'App\\Models\\Receipt',830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',4380.00,NULL,NULL,1,'2021-08-10 18:45:31','2021-08-10 18:45:31',NULL),(862,3117,40779,4572,2,831,'App\\Models\\Receipt',831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',4710.00,NULL,NULL,1,'2021-08-10 18:45:31','2021-08-10 18:45:31',NULL),(863,3117,40779,4572,2,832,'App\\Models\\Receipt',832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',4850.00,NULL,NULL,1,'2021-08-10 18:45:31','2021-08-10 18:45:31',NULL),(864,3117,40779,4572,2,833,'App\\Models\\Receipt',833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',4160.00,NULL,NULL,1,'2021-08-10 18:45:31','2021-08-10 18:45:31',NULL),(865,3117,40779,4572,2,834,'App\\Models\\Receipt',834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',4990.00,NULL,NULL,1,'2021-08-10 18:45:31','2021-08-10 18:45:31',NULL),(866,3117,40779,4572,2,835,'App\\Models\\Receipt',835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',4630.00,NULL,NULL,1,'2021-08-10 18:45:31','2021-08-10 18:45:31',NULL),(867,3117,40779,4572,2,836,'App\\Models\\Receipt',836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',4880.00,NULL,NULL,1,'2021-08-10 18:45:31','2021-08-10 18:45:31',NULL),(868,3117,40779,4572,2,837,'App\\Models\\Receipt',837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',4370.00,NULL,NULL,1,'2021-08-10 18:45:31','2021-08-10 18:45:31',NULL);
INSERT INTO `balance_libro` VALUES (869,3117,40779,4572,2,838,'App\\Models\\Receipt',838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1300.00,NULL,NULL,1,'2021-08-10 18:45:31','2021-08-10 18:45:31',NULL),(870,3117,40779,4572,2,839,'App\\Models\\Receipt',839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1300.00,NULL,NULL,1,'2021-08-10 18:45:31','2021-08-10 18:45:31',NULL),(871,3117,40779,4572,2,840,'App\\Models\\Receipt',840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',4680.00,NULL,NULL,1,'2021-08-10 18:45:31','2021-08-10 18:45:31',NULL),(872,3117,40779,4572,2,841,'App\\Models\\Receipt',841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',4820.00,NULL,NULL,1,'2021-08-10 18:45:31','2021-08-10 18:45:31',NULL),(873,3117,40779,4572,2,842,'App\\Models\\Receipt',842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',4120.00,NULL,NULL,1,'2021-08-10 18:45:31','2021-08-10 18:45:31',NULL),(874,3117,40779,4572,2,843,'App\\Models\\Receipt',843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',4350.00,NULL,NULL,1,'2021-08-10 18:45:31','2021-08-10 18:45:31',NULL),(875,3117,40779,4572,2,844,'App\\Models\\Receipt',844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',4010.00,NULL,NULL,1,'2021-08-10 18:45:31','2021-08-10 18:45:31',NULL),(876,3117,40779,4572,2,845,'App\\Models\\Receipt',845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',4130.00,NULL,NULL,1,'2021-08-10 18:45:31','2021-08-10 18:45:31',NULL),(877,3117,40779,4572,2,846,'App\\Models\\Receipt',846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',4280.00,NULL,NULL,1,'2021-08-10 18:45:31','2021-08-10 18:45:31',NULL),(878,3117,40779,4572,2,847,'App\\Models\\Receipt',847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',1300.00,NULL,NULL,1,'2021-08-10 18:45:31','2021-08-10 18:45:31',NULL),(879,3117,40779,4572,2,848,'App\\Models\\Receipt',848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',4930.00,NULL,NULL,1,'2021-08-10 18:45:31','2021-08-10 18:45:31',NULL),(880,3117,40779,4572,2,849,'App\\Models\\Receipt',849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',4720.00,NULL,NULL,1,'2021-08-10 18:45:31','2021-08-10 18:45:31',NULL),(881,3117,40779,4572,2,850,'App\\Models\\Receipt',850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',4780.00,NULL,NULL,1,'2021-08-10 18:45:31','2021-08-10 18:45:31',NULL),(882,3117,40779,4572,2,851,'App\\Models\\Receipt',851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',4620.00,NULL,NULL,1,'2021-08-10 18:45:31','2021-08-10 18:45:31',NULL),(883,3117,40779,4572,2,852,'App\\Models\\Receipt',852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',650.00,NULL,NULL,1,'2021-08-10 18:45:32','2021-08-10 18:45:32',NULL),(884,3117,40779,4572,2,853,'App\\Models\\Receipt',853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',1300.00,NULL,NULL,1,'2021-08-10 18:45:32','2021-08-10 18:45:32',NULL),(885,3117,40779,4572,2,854,'App\\Models\\Receipt',854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',3910.00,NULL,NULL,1,'2021-08-10 18:45:32','2021-08-10 18:45:32',NULL),(886,3117,40779,4572,2,855,'App\\Models\\Receipt',855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',2970.00,NULL,NULL,1,'2021-08-10 18:45:32','2021-08-10 18:45:32',NULL),(887,3117,40779,4572,2,856,'App\\Models\\Receipt',856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',2970.00,NULL,NULL,1,'2021-08-10 18:45:32','2021-08-10 18:45:32',NULL),(888,3117,40779,4572,2,857,'App\\Models\\Receipt',857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',4650.00,NULL,NULL,1,'2021-08-10 18:45:32','2021-08-10 18:45:32',NULL),(889,3117,40779,4572,2,858,'App\\Models\\Receipt',858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',4845.00,NULL,NULL,1,'2021-08-10 18:45:32','2021-08-10 18:45:32',NULL);
INSERT INTO `balance_libro` VALUES (890,3117,40779,4572,2,859,'App\\Models\\Receipt',859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',4190.00,NULL,NULL,1,'2021-08-10 18:45:32','2021-08-10 18:45:32',NULL),(891,3117,40779,4572,2,860,'App\\Models\\Receipt',860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',1210.00,NULL,NULL,1,'2021-08-10 18:45:32','2021-08-10 18:45:32',NULL),(892,3117,40779,4572,2,861,'App\\Models\\Receipt',861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',3650.00,NULL,NULL,1,'2021-08-10 18:45:32','2021-08-10 18:45:32',NULL),(893,3117,40779,4572,2,862,'App\\Models\\Receipt',862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',3650.00,NULL,NULL,1,'2021-08-10 18:45:32','2021-08-10 18:45:32',NULL),(894,3117,40779,4572,2,863,'App\\Models\\Receipt',863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',4460.00,NULL,NULL,1,'2021-08-10 18:45:32','2021-08-10 18:45:32',NULL),(895,3117,40779,4572,2,864,'App\\Models\\Receipt',864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',4930.00,NULL,NULL,1,'2021-08-10 18:45:32','2021-08-10 18:45:32',NULL),(896,3117,40779,4572,2,865,'App\\Models\\Receipt',865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',4800.00,NULL,NULL,1,'2021-08-10 18:45:32','2021-08-10 18:45:32',NULL),(897,3117,40779,4572,2,866,'App\\Models\\Receipt',866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',4710.00,NULL,NULL,1,'2021-08-10 18:45:32','2021-08-10 18:45:32',NULL),(898,3117,40779,4572,2,867,'App\\Models\\Receipt',867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',4970.00,NULL,NULL,1,'2021-08-10 18:45:32','2021-08-10 18:45:32',NULL),(899,3117,40779,4572,2,868,'App\\Models\\Receipt',868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',4000.00,NULL,NULL,1,'2021-08-10 18:45:32','2021-08-10 18:45:32',NULL),(900,3117,40779,4572,2,869,'App\\Models\\Receipt',869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',4775.00,NULL,NULL,1,'2021-08-10 18:45:32','2021-08-10 18:45:32',NULL),(901,3117,40779,4572,2,870,'App\\Models\\Receipt',870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',4820.00,NULL,NULL,1,'2021-08-10 18:45:32','2021-08-10 18:45:32',NULL),(902,3117,40779,4572,2,871,'App\\Models\\Receipt',871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',4685.00,NULL,NULL,1,'2021-08-10 18:45:32','2021-08-10 18:45:32',NULL),(903,3117,40779,4572,2,872,'App\\Models\\Receipt',872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',3930.00,NULL,NULL,1,'2021-08-10 18:45:32','2021-08-10 18:45:32',NULL),(904,3117,40779,4572,2,873,'App\\Models\\Receipt',873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',3930.00,NULL,NULL,1,'2021-08-10 18:45:32','2021-08-10 18:45:32',NULL),(905,3117,40779,4572,2,874,'App\\Models\\Receipt',874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',3930.00,NULL,NULL,1,'2021-08-10 18:45:32','2021-08-10 18:45:32',NULL),(906,3117,40779,4572,2,875,'App\\Models\\Receipt',875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',4950.00,NULL,NULL,1,'2021-08-10 18:45:32','2021-08-10 18:45:32',NULL),(907,3117,40779,4572,2,876,'App\\Models\\Receipt',876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',4550.00,NULL,NULL,1,'2021-08-10 18:45:32','2021-08-10 18:45:32',NULL),(908,3117,40779,4572,2,877,'App\\Models\\Receipt',877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',4800.00,NULL,NULL,1,'2021-08-10 18:45:32','2021-08-10 18:45:32',NULL),(909,3117,40779,4572,2,878,'App\\Models\\Receipt',878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',4670.00,NULL,NULL,1,'2021-08-10 18:45:32','2021-08-10 18:45:32',NULL),(910,3117,40779,4572,2,879,'App\\Models\\Receipt',879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',4680.00,NULL,NULL,1,'2021-08-10 18:45:32','2021-08-10 18:45:32',NULL);
INSERT INTO `balance_libro` VALUES (911,3117,40779,4572,2,880,'App\\Models\\Receipt',880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',4600.00,NULL,NULL,1,'2021-08-10 18:45:32','2021-08-10 18:45:32',NULL),(912,3117,40779,4572,3,881,'App\\Models\\Receipt',881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',38304.93,NULL,NULL,1,'2021-08-10 18:45:51','2021-08-10 18:45:51',NULL),(913,3117,40779,4572,3,882,'App\\Models\\Receipt',882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',6476.25,NULL,NULL,1,'2021-08-10 18:45:51','2021-08-10 18:45:51',NULL),(914,3117,40779,4572,3,883,'App\\Models\\Receipt',883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',41566.49,NULL,NULL,1,'2021-08-10 18:45:51','2021-08-10 18:45:51',NULL),(915,3117,40779,4572,3,884,'App\\Models\\Receipt',884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',810.00,NULL,NULL,1,'2021-08-10 18:45:51','2021-08-10 18:45:51',NULL),(916,3117,40779,4572,3,885,'App\\Models\\Receipt',885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',90010.60,NULL,NULL,1,'2021-08-10 18:45:51','2021-08-10 18:45:51',NULL),(917,3117,40779,4572,3,886,'App\\Models\\Receipt',886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',56012.24,NULL,NULL,1,'2021-08-10 18:45:51','2021-08-10 18:45:51',NULL),(918,3117,40779,4572,3,887,'App\\Models\\Receipt',887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',40622.53,NULL,NULL,1,'2021-08-10 18:45:51','2021-08-10 18:45:51',NULL),(919,3117,40779,4572,3,888,'App\\Models\\Receipt',888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',8079.43,NULL,NULL,1,'2021-08-10 18:45:51','2021-08-10 18:45:51',NULL),(920,3117,40779,4572,3,889,'App\\Models\\Receipt',889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',36192.73,NULL,NULL,1,'2021-08-10 18:45:51','2021-08-10 18:45:51',NULL),(921,3117,40779,4572,3,890,'App\\Models\\Receipt',890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',807.95,NULL,NULL,1,'2021-08-10 18:45:51','2021-08-10 18:45:51',NULL),(922,3117,40779,4572,3,891,'App\\Models\\Receipt',891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',29455.85,NULL,NULL,1,'2021-08-10 18:45:51','2021-08-10 18:45:51',NULL),(923,3117,40779,4572,3,892,'App\\Models\\Receipt',892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',22321.11,NULL,NULL,1,'2021-08-10 18:45:51','2021-08-10 18:45:51',NULL),(924,3117,40779,4572,3,893,'App\\Models\\Receipt',893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',11000.00,NULL,NULL,1,'2021-08-10 18:45:51','2021-08-10 18:45:51',NULL),(925,3117,40779,4572,3,894,'App\\Models\\Receipt',894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',97217.62,NULL,NULL,1,'2021-08-10 18:45:51','2021-08-10 18:45:51',NULL),(926,3117,40779,4572,3,895,'App\\Models\\Receipt',895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1323.45,NULL,NULL,1,'2021-08-10 18:45:51','2021-08-10 18:45:51',NULL),(927,3117,40719,9,2,896,'App\\Models\\Receipt',896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',11304.00,NULL,NULL,1,'2021-08-13 14:47:39','2021-08-13 14:47:39',NULL),(928,3117,40719,9,2,897,'App\\Models\\Receipt',897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',4389.00,NULL,NULL,1,'2021-08-13 14:47:39','2021-08-13 14:47:39',NULL),(929,3117,40719,9,2,898,'App\\Models\\Receipt',898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',10150.00,NULL,NULL,1,'2021-08-13 14:47:39','2021-08-13 14:47:39',NULL),(930,3117,40719,9,2,899,'App\\Models\\Receipt',899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',10200.00,NULL,NULL,1,'2021-08-13 14:47:39','2021-08-13 14:47:39',NULL),(931,3117,40719,9,2,900,'App\\Models\\Receipt',900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',13000.00,NULL,NULL,1,'2021-08-13 14:47:39','2021-08-13 14:47:39',NULL);
INSERT INTO `balance_libro` VALUES (932,3117,40719,9,2,901,'App\\Models\\Receipt',901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',12999.00,NULL,NULL,1,'2021-08-13 14:47:39','2021-08-13 14:47:39',NULL),(933,3117,40719,9,2,902,'App\\Models\\Receipt',902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',10000.00,NULL,NULL,1,'2021-08-13 14:47:39','2021-08-13 14:47:39',NULL),(934,3117,40719,9,2,903,'App\\Models\\Receipt',903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',12699.00,NULL,NULL,1,'2021-08-13 14:47:39','2021-08-13 14:47:39',NULL),(935,3117,40719,9,2,904,'App\\Models\\Receipt',904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',13110.00,NULL,NULL,1,'2021-08-13 14:47:39','2021-08-13 14:47:39',NULL),(936,3117,40719,9,3,905,'App\\Models\\Receipt',905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',189.00,NULL,NULL,1,'2021-08-13 14:48:42','2021-08-13 14:48:42',NULL),(937,3117,40719,9,3,906,'App\\Models\\Receipt',906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',30999.00,NULL,NULL,1,'2021-08-13 14:48:42','2021-08-13 14:48:42',NULL),(938,3117,40719,9,3,907,'App\\Models\\Receipt',907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1900.00,NULL,NULL,1,'2021-08-13 14:48:42','2021-08-13 14:48:42',NULL),(939,3117,40731,3053,2,908,'App\\Models\\Receipt',908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',2992.00,NULL,NULL,1,'2021-08-19 14:24:10','2021-08-19 14:24:10',NULL),(940,3117,40731,3053,2,909,'App\\Models\\Receipt',909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',7945.00,NULL,NULL,1,'2021-08-19 14:24:10','2021-08-19 14:24:10',NULL),(941,3117,40731,3053,2,910,'App\\Models\\Receipt',910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',5506.00,NULL,NULL,1,'2021-08-19 14:24:10','2021-08-19 14:24:10',NULL),(942,3117,40731,3053,2,911,'App\\Models\\Receipt',911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',7292.00,NULL,NULL,1,'2021-08-19 14:24:10','2021-08-19 14:24:10',NULL),(943,3117,40731,3053,2,912,'App\\Models\\Receipt',912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',4657.00,NULL,NULL,1,'2021-08-19 14:24:10','2021-08-19 14:24:10',NULL),(944,3117,40731,3053,2,913,'App\\Models\\Receipt',913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',6481.00,NULL,NULL,1,'2021-08-19 14:24:10','2021-08-19 14:24:10',NULL),(945,3117,40731,3053,2,914,'App\\Models\\Receipt',914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',6737.00,NULL,NULL,1,'2021-08-19 14:24:10','2021-08-19 14:24:10',NULL),(946,3117,40731,3053,2,915,'App\\Models\\Receipt',915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',7213.00,NULL,NULL,1,'2021-08-19 14:24:10','2021-08-19 14:24:10',NULL),(947,3117,40731,3053,2,916,'App\\Models\\Receipt',916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',6251.00,NULL,NULL,1,'2021-08-19 14:24:10','2021-08-19 14:24:10',NULL),(948,3117,40731,3053,2,917,'App\\Models\\Receipt',917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',6235.00,NULL,NULL,1,'2021-08-19 14:24:10','2021-08-19 14:24:10',NULL),(949,3117,40731,3053,2,918,'App\\Models\\Receipt',918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',8723.00,NULL,NULL,1,'2021-08-19 14:24:10','2021-08-19 14:24:10',NULL),(950,3117,40731,3053,2,919,'App\\Models\\Receipt',919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',8483.00,NULL,NULL,1,'2021-08-19 14:24:10','2021-08-19 14:24:10',NULL),(951,3117,40731,3053,2,920,'App\\Models\\Receipt',920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',3681.00,NULL,NULL,1,'2021-08-19 14:24:10','2021-08-19 14:24:10',NULL),(952,3117,40731,3053,2,921,'App\\Models\\Receipt',921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',7642.00,NULL,NULL,1,'2021-08-19 14:24:10','2021-08-19 14:24:10',NULL);
INSERT INTO `balance_libro` VALUES (953,3117,40731,3053,2,922,'App\\Models\\Receipt',922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',8393.00,NULL,NULL,1,'2021-08-19 14:24:10','2021-08-19 14:24:10',NULL),(954,3117,40731,3053,2,923,'App\\Models\\Receipt',923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',6657.00,NULL,NULL,1,'2021-08-19 14:24:10','2021-08-19 14:24:10',NULL),(955,3117,40731,3053,2,924,'App\\Models\\Receipt',924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',8554.00,NULL,NULL,1,'2021-08-19 14:24:10','2021-08-19 14:24:10',NULL),(956,3117,40731,3053,2,925,'App\\Models\\Receipt',925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',5068.00,NULL,NULL,1,'2021-08-19 14:24:10','2021-08-19 14:24:10',NULL),(957,3117,40731,3053,2,926,'App\\Models\\Receipt',926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',8648.00,NULL,NULL,1,'2021-08-19 14:24:10','2021-08-19 14:24:10',NULL),(958,3117,40731,3053,2,927,'App\\Models\\Receipt',927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',7588.00,NULL,NULL,1,'2021-08-19 14:24:10','2021-08-19 14:24:10',NULL),(959,3117,40731,3053,2,928,'App\\Models\\Receipt',928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',7209.00,NULL,NULL,1,'2021-08-19 14:24:10','2021-08-19 14:24:10',NULL),(960,3117,40731,3053,2,929,'App\\Models\\Receipt',929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',4649.00,NULL,NULL,1,'2021-08-19 14:24:10','2021-08-19 14:24:10',NULL),(961,3117,40731,3053,2,930,'App\\Models\\Receipt',930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',7554.00,NULL,NULL,1,'2021-08-19 14:24:11','2021-08-19 14:24:11',NULL),(962,3117,40731,3053,2,931,'App\\Models\\Receipt',931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',5658.00,NULL,NULL,1,'2021-08-19 14:24:11','2021-08-19 14:24:11',NULL),(963,3117,40731,3053,2,932,'App\\Models\\Receipt',932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',2002.00,NULL,NULL,1,'2021-08-19 14:24:11','2021-08-19 14:24:11',NULL),(964,3117,40731,3053,2,933,'App\\Models\\Receipt',933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',4630.00,NULL,NULL,1,'2021-08-19 14:24:11','2021-08-19 14:24:11',NULL),(965,3117,40731,3053,2,934,'App\\Models\\Receipt',934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',8380.00,NULL,NULL,1,'2021-08-19 14:24:11','2021-08-19 14:24:11',NULL),(966,3117,40731,3053,2,935,'App\\Models\\Receipt',935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',7218.00,NULL,NULL,1,'2021-08-19 14:24:11','2021-08-19 14:24:11',NULL),(967,3117,40731,3053,2,936,'App\\Models\\Receipt',936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',3334.00,NULL,NULL,1,'2021-08-19 14:24:11','2021-08-19 14:24:11',NULL),(968,3117,40731,3053,2,937,'App\\Models\\Receipt',937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',8781.00,NULL,NULL,1,'2021-08-19 14:24:11','2021-08-19 14:24:11',NULL),(969,3117,40731,3053,2,938,'App\\Models\\Receipt',938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',8841.00,NULL,NULL,1,'2021-08-19 14:24:11','2021-08-19 14:24:11',NULL),(970,3117,40731,3053,2,939,'App\\Models\\Receipt',939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',6545.00,NULL,NULL,1,'2021-08-19 14:24:11','2021-08-19 14:24:11',NULL),(971,3117,40731,3053,2,940,'App\\Models\\Receipt',940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',4566.00,NULL,NULL,1,'2021-08-19 14:24:11','2021-08-19 14:24:11',NULL),(972,3117,40731,3053,2,941,'App\\Models\\Receipt',941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',7027.00,NULL,NULL,1,'2021-08-19 14:24:11','2021-08-19 14:24:11',NULL),(973,3117,40731,3053,2,942,'App\\Models\\Receipt',942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',4370.00,NULL,NULL,1,'2021-08-19 14:24:11','2021-08-19 14:24:11',NULL);
INSERT INTO `balance_libro` VALUES (974,3117,40731,3053,2,943,'App\\Models\\Receipt',943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',6963.00,NULL,NULL,1,'2021-08-19 14:24:11','2021-08-19 14:24:11',NULL),(975,3117,40731,3053,2,944,'App\\Models\\Receipt',944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',500.00,NULL,NULL,1,'2021-08-19 14:24:11','2021-08-19 14:24:11',NULL),(976,3117,40731,3053,2,945,'App\\Models\\Receipt',945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',650.00,NULL,NULL,1,'2021-08-19 14:24:11','2021-08-19 14:24:11',NULL),(977,3117,40731,3053,2,946,'App\\Models\\Receipt',946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',6770.00,NULL,NULL,1,'2021-08-19 14:24:11','2021-08-19 14:24:11',NULL),(978,3117,40731,3053,2,947,'App\\Models\\Receipt',947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',4340.00,NULL,NULL,1,'2021-08-19 14:24:11','2021-08-19 14:24:11',NULL),(979,3117,40731,3053,2,948,'App\\Models\\Receipt',948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',8709.00,NULL,NULL,1,'2021-08-19 14:24:11','2021-08-19 14:24:11',NULL),(980,3117,40731,3053,2,949,'App\\Models\\Receipt',949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',3597.00,NULL,NULL,1,'2021-08-19 14:24:11','2021-08-19 14:24:11',NULL),(981,3117,40731,3053,2,950,'App\\Models\\Receipt',950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',6759.00,NULL,NULL,1,'2021-08-19 14:24:11','2021-08-19 14:24:11',NULL),(982,3117,40731,3053,2,951,'App\\Models\\Receipt',951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',6153.00,NULL,NULL,1,'2021-08-19 14:24:11','2021-08-19 14:24:11',NULL),(983,3117,40731,3053,2,952,'App\\Models\\Receipt',952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',7119.00,NULL,NULL,1,'2021-08-19 14:24:11','2021-08-19 14:24:11',NULL),(984,3117,40731,3053,2,953,'App\\Models\\Receipt',953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',6877.00,NULL,NULL,1,'2021-08-19 14:24:11','2021-08-19 14:24:11',NULL),(985,3117,40731,3053,2,954,'App\\Models\\Receipt',954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',500.00,NULL,NULL,1,'2021-08-19 14:24:11','2021-08-19 14:24:11',NULL),(986,3117,40731,3053,2,955,'App\\Models\\Receipt',955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',7299.00,NULL,NULL,1,'2021-08-19 14:24:11','2021-08-19 14:24:11',NULL),(987,3117,40731,3053,2,956,'App\\Models\\Receipt',956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',7185.00,NULL,NULL,1,'2021-08-19 14:24:12','2021-08-19 14:24:12',NULL),(988,3117,40731,3053,2,957,'App\\Models\\Receipt',957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',7619.00,NULL,NULL,1,'2021-08-19 14:24:12','2021-08-19 14:24:12',NULL),(989,3117,40731,3053,2,958,'App\\Models\\Receipt',958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',6775.00,NULL,NULL,1,'2021-08-19 14:24:12','2021-08-19 14:24:12',NULL),(990,3117,40731,3053,2,959,'App\\Models\\Receipt',959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',9310.00,NULL,NULL,1,'2021-08-19 14:24:12','2021-08-19 14:24:12',NULL),(991,3117,40731,3053,2,960,'App\\Models\\Receipt',960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',6739.00,NULL,NULL,1,'2021-08-19 14:24:12','2021-08-19 14:24:12',NULL),(992,3117,40731,3053,2,961,'App\\Models\\Receipt',961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',2966.00,NULL,NULL,1,'2021-08-19 14:24:12','2021-08-19 14:24:12',NULL),(993,3117,40731,3053,2,962,'App\\Models\\Receipt',962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',4173.00,NULL,NULL,1,'2021-08-19 14:24:12','2021-08-19 14:24:12',NULL),(994,3117,40731,3053,2,963,'App\\Models\\Receipt',963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',6656.00,NULL,NULL,1,'2021-08-19 14:24:12','2021-08-19 14:24:12',NULL);
INSERT INTO `balance_libro` VALUES (995,3117,40731,3053,2,964,'App\\Models\\Receipt',964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',6294.00,NULL,NULL,1,'2021-08-19 14:24:12','2021-08-19 14:24:12',NULL),(996,3117,40731,3053,2,965,'App\\Models\\Receipt',965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',6474.00,NULL,NULL,1,'2021-08-19 14:24:12','2021-08-19 14:24:12',NULL),(997,3117,40731,3053,2,966,'App\\Models\\Receipt',966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',3714.00,NULL,NULL,1,'2021-08-19 14:24:12','2021-08-19 14:24:12',NULL),(998,3117,40731,3053,2,967,'App\\Models\\Receipt',967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',7323.00,NULL,NULL,1,'2021-08-19 14:24:12','2021-08-19 14:24:12',NULL),(999,3117,40731,3053,2,968,'App\\Models\\Receipt',968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',3880.00,NULL,NULL,1,'2021-08-19 14:24:12','2021-08-19 14:24:12',NULL),(1000,3117,40731,3053,2,969,'App\\Models\\Receipt',969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',10422.00,NULL,NULL,1,'2021-08-19 14:24:12','2021-08-19 14:24:12',NULL),(1001,3117,40731,3053,2,970,'App\\Models\\Receipt',970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',8551.00,NULL,NULL,1,'2021-08-19 14:24:12','2021-08-19 14:24:12',NULL),(1002,3117,40731,3053,2,971,'App\\Models\\Receipt',971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',11997.00,NULL,NULL,1,'2021-08-19 14:24:12','2021-08-19 14:24:12',NULL),(1003,3117,40731,3053,2,972,'App\\Models\\Receipt',972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',12793.00,NULL,NULL,1,'2021-08-19 14:24:12','2021-08-19 14:24:12',NULL),(1004,3117,40731,3053,2,973,'App\\Models\\Receipt',973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',12699.00,NULL,NULL,1,'2021-08-19 14:24:12','2021-08-19 14:24:12',NULL),(1005,3117,40731,3053,2,974,'App\\Models\\Receipt',974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',12741.00,NULL,NULL,1,'2021-08-19 14:24:12','2021-08-19 14:24:12',NULL),(1006,3117,40731,3053,2,975,'App\\Models\\Receipt',975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',7063.00,NULL,NULL,1,'2021-08-19 14:24:12','2021-08-19 14:24:12',NULL),(1007,3117,40731,3053,2,976,'App\\Models\\Receipt',976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',5389.00,NULL,NULL,1,'2021-08-19 14:24:12','2021-08-19 14:24:12',NULL),(1008,3117,40731,3053,2,977,'App\\Models\\Receipt',977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',522.00,NULL,NULL,1,'2021-08-19 14:24:12','2021-08-19 14:24:12',NULL),(1009,3117,40731,3053,2,978,'App\\Models\\Receipt',978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',10450.00,NULL,NULL,1,'2021-08-19 14:24:12','2021-08-19 14:24:12',NULL),(1010,3117,40731,3053,2,979,'App\\Models\\Receipt',979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',6344.00,NULL,NULL,1,'2021-08-19 14:24:12','2021-08-19 14:24:12',NULL),(1011,3117,40731,3053,2,980,'App\\Models\\Receipt',980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',11660.00,NULL,NULL,1,'2021-08-19 14:24:12','2021-08-19 14:24:12',NULL),(1012,3117,40731,3053,2,981,'App\\Models\\Receipt',981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',8013.00,NULL,NULL,1,'2021-08-19 14:24:13','2021-08-19 14:24:13',NULL),(1013,3117,40731,3053,2,982,'App\\Models\\Receipt',982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',5480.00,NULL,NULL,1,'2021-08-19 14:24:13','2021-08-19 14:24:13',NULL),(1014,3117,40731,3053,2,983,'App\\Models\\Receipt',983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',9135.00,NULL,NULL,1,'2021-08-19 14:24:13','2021-08-19 14:24:13',NULL),(1015,3117,40731,3053,2,984,'App\\Models\\Receipt',984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',12452.00,NULL,NULL,1,'2021-08-19 14:24:13','2021-08-19 14:24:13',NULL);
INSERT INTO `balance_libro` VALUES (1016,3117,40731,3053,2,985,'App\\Models\\Receipt',985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',588.00,NULL,NULL,1,'2021-08-19 14:24:13','2021-08-19 14:24:13',NULL),(1017,3117,40731,3053,3,986,'App\\Models\\Receipt',986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',7314.17,NULL,NULL,1,'2021-08-19 14:25:16','2021-08-19 14:25:16',NULL),(1018,3117,40731,3053,3,987,'App\\Models\\Receipt',987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',800.00,NULL,NULL,1,'2021-08-19 14:25:16','2021-08-19 14:25:16',NULL),(1019,3117,40731,3053,3,988,'App\\Models\\Receipt',988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',37392.15,NULL,NULL,1,'2021-08-19 14:25:16','2021-08-19 14:25:16',NULL),(1020,3117,40731,3053,3,989,'App\\Models\\Receipt',989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',12477.77,NULL,NULL,1,'2021-08-19 14:25:16','2021-08-19 14:25:16',NULL),(1021,3117,40731,3053,3,990,'App\\Models\\Receipt',990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',1138.65,NULL,NULL,1,'2021-08-19 14:25:16','2021-08-19 14:25:16',NULL),(1022,3117,40731,3053,3,991,'App\\Models\\Receipt',991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',2615.22,NULL,NULL,1,'2021-08-19 14:25:16','2021-08-19 14:25:16',NULL),(1023,3117,40731,3053,3,992,'App\\Models\\Receipt',992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',21605.66,NULL,NULL,1,'2021-08-19 14:25:16','2021-08-19 14:25:16',NULL),(1024,3117,40731,3053,3,993,'App\\Models\\Receipt',993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',6602.59,NULL,NULL,1,'2021-08-19 14:25:16','2021-08-19 14:25:16',NULL),(1025,3117,40731,3053,3,994,'App\\Models\\Receipt',994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',6538.25,NULL,NULL,1,'2021-08-19 14:25:16','2021-08-19 14:25:16',NULL),(1026,3117,40731,3053,3,995,'App\\Models\\Receipt',995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',2027.84,NULL,NULL,1,'2021-08-19 14:25:17','2021-08-19 14:25:17',NULL),(1027,3117,40731,3053,3,996,'App\\Models\\Receipt',996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',2476.10,NULL,NULL,1,'2021-08-19 14:25:17','2021-08-19 14:25:17',NULL),(1028,3117,40731,3053,3,997,'App\\Models\\Receipt',997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',8160.82,NULL,NULL,1,'2021-08-19 14:25:17','2021-08-19 14:25:17',NULL),(1029,3117,40731,3053,3,998,'App\\Models\\Receipt',998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',42391.57,NULL,NULL,1,'2021-08-19 14:25:17','2021-08-19 14:25:17',NULL),(1030,3117,40731,3053,3,999,'App\\Models\\Receipt',999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',784.37,NULL,NULL,1,'2021-08-19 14:25:17','2021-08-19 14:25:17',NULL),(1031,3117,40731,3053,3,1000,'App\\Models\\Receipt',1000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',490.60,NULL,NULL,1,'2021-08-19 14:25:17','2021-08-19 14:25:17',NULL),(1032,3117,40731,3053,3,1001,'App\\Models\\Receipt',1001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',4959.43,NULL,NULL,1,'2021-08-19 14:25:17','2021-08-19 14:25:17',NULL),(1033,3117,40731,3053,3,1002,'App\\Models\\Receipt',1002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',241.02,NULL,NULL,1,'2021-08-19 14:25:17','2021-08-19 14:25:17',NULL),(1072,3117,40728,6079,2,1041,'App\\Models\\Receipt',1041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',16800.00,NULL,NULL,1,'2021-09-13 14:54:01','2021-09-13 14:54:01',NULL),(1073,3117,40728,6079,2,1042,'App\\Models\\Receipt',1042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',16000.00,NULL,NULL,1,'2021-09-13 14:54:01','2021-09-13 14:54:01',NULL),(1074,3117,40728,6079,2,1043,'App\\Models\\Receipt',1043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-05','2021-08-05',29316.43,NULL,NULL,1,'2021-09-13 14:54:01','2021-09-13 14:54:01',NULL);
INSERT INTO `balance_libro` VALUES (1075,3117,40728,6079,2,1044,'App\\Models\\Receipt',1044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-05','2021-08-05',32800.00,NULL,NULL,1,'2021-09-13 14:54:01','2021-09-13 14:54:01',NULL),(1076,3117,40728,6079,2,1045,'App\\Models\\Receipt',1045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',13400.00,NULL,NULL,1,'2021-09-13 14:54:01','2021-09-13 14:54:01',NULL),(1077,3117,40728,6079,2,1046,'App\\Models\\Receipt',1046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',11600.00,NULL,NULL,1,'2021-09-13 14:54:01','2021-09-13 14:54:01',NULL),(1078,3117,40728,6079,2,1047,'App\\Models\\Receipt',1047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',13000.00,NULL,NULL,1,'2021-09-13 14:54:01','2021-09-13 14:54:01',NULL),(1079,3117,40728,6079,2,1048,'App\\Models\\Receipt',1048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',11000.00,NULL,NULL,1,'2021-09-13 14:54:01','2021-09-13 14:54:01',NULL),(1080,3117,40728,6079,2,1049,'App\\Models\\Receipt',1049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',27239.00,NULL,NULL,1,'2021-09-13 14:54:01','2021-09-13 14:54:01',NULL),(1081,3117,40728,6079,2,1050,'App\\Models\\Receipt',1050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',11000.00,NULL,NULL,1,'2021-09-13 14:54:02','2021-09-13 14:54:02',NULL),(1082,3117,40728,6079,2,1051,'App\\Models\\Receipt',1051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',28400.00,NULL,NULL,1,'2021-09-13 14:54:02','2021-09-13 14:54:02',NULL),(1083,3117,40728,6079,2,1052,'App\\Models\\Receipt',1052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',26000.00,NULL,NULL,1,'2021-09-13 14:54:02','2021-09-13 14:54:02',NULL),(1084,3117,40728,6079,2,1053,'App\\Models\\Receipt',1053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',5100.00,NULL,NULL,1,'2021-09-13 14:54:02','2021-09-13 14:54:02',NULL),(1085,3117,40728,6079,2,1054,'App\\Models\\Receipt',1054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-24','2021-08-24',1300.00,NULL,NULL,1,'2021-09-13 14:54:02','2021-09-13 14:54:02',NULL),(1086,3117,40728,6079,2,1055,'App\\Models\\Receipt',1055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',11500.00,NULL,NULL,1,'2021-09-13 14:54:02','2021-09-13 14:54:02',NULL),(1087,3117,40728,6079,2,1056,'App\\Models\\Receipt',1056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',12500.00,NULL,NULL,1,'2021-09-13 14:54:02','2021-09-13 14:54:02',NULL),(1088,3117,40728,6079,2,1057,'App\\Models\\Receipt',1057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-28','2021-08-28',40500.00,NULL,NULL,1,'2021-09-13 14:54:02','2021-09-13 14:54:02',NULL),(1089,3117,40728,6079,2,1058,'App\\Models\\Receipt',1058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',49500.00,NULL,NULL,1,'2021-09-13 14:54:02','2021-09-13 14:54:02',NULL),(1090,3117,40728,6079,2,1059,'App\\Models\\Receipt',1059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',33000.00,NULL,NULL,1,'2021-09-13 14:54:02','2021-09-13 14:54:02',NULL),(1091,3117,40728,6079,3,1060,'App\\Models\\Receipt',1060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',9999.00,NULL,NULL,1,'2021-09-13 14:55:48','2021-09-13 14:55:48',NULL),(1092,3117,40728,6079,3,1061,'App\\Models\\Receipt',1061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',9999.00,NULL,NULL,1,'2021-09-13 14:55:48','2021-09-13 14:55:48',NULL),(1093,3117,40728,6079,3,1062,'App\\Models\\Receipt',1062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',19999.00,NULL,NULL,1,'2021-09-13 14:55:48','2021-09-13 14:55:48',NULL),(1094,3117,40728,6079,3,1063,'App\\Models\\Receipt',1063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',19999.00,NULL,NULL,1,'2021-09-13 14:55:48','2021-09-13 14:55:48',NULL),(1095,3117,40728,6079,3,1064,'App\\Models\\Receipt',1064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',17999.00,NULL,NULL,1,'2021-09-13 14:55:48','2021-09-13 14:55:48',NULL);
INSERT INTO `balance_libro` VALUES (1096,3117,40728,6079,3,1065,'App\\Models\\Receipt',1065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',17999.00,NULL,NULL,1,'2021-09-13 14:55:48','2021-09-13 14:55:48',NULL),(1097,3117,40728,6079,3,1066,'App\\Models\\Receipt',1066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',19999.00,NULL,NULL,1,'2021-09-13 14:55:48','2021-09-13 14:55:48',NULL),(1098,3117,40728,6079,3,1067,'App\\Models\\Receipt',1067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',15499.00,NULL,NULL,1,'2021-09-13 14:55:48','2021-09-13 14:55:48',NULL),(1099,3117,40728,6079,3,1068,'App\\Models\\Receipt',1068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',15499.00,NULL,NULL,1,'2021-09-13 14:55:48','2021-09-13 14:55:48',NULL),(1100,3117,40728,6079,3,1069,'App\\Models\\Receipt',1069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',5999.00,NULL,NULL,1,'2021-09-13 14:55:48','2021-09-13 14:55:48',NULL),(1101,3117,40728,6079,3,1070,'App\\Models\\Receipt',1070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',19999.00,NULL,NULL,1,'2021-09-13 14:55:48','2021-09-13 14:55:48',NULL),(1102,3117,40728,6079,3,1071,'App\\Models\\Receipt',1071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',19999.00,NULL,NULL,1,'2021-09-13 14:55:48','2021-09-13 14:55:48',NULL),(1103,3117,40728,6079,3,1072,'App\\Models\\Receipt',1072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-09','2021-08-09',17994.00,NULL,NULL,1,'2021-09-13 14:55:48','2021-09-13 14:55:48',NULL),(1104,3117,40728,6079,3,1073,'App\\Models\\Receipt',1073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',15499.00,NULL,NULL,1,'2021-09-13 14:55:48','2021-09-13 14:55:48',NULL),(1105,3117,40728,6079,3,1074,'App\\Models\\Receipt',1074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',15499.00,NULL,NULL,1,'2021-09-13 14:55:48','2021-09-13 14:55:48',NULL),(1106,3117,40728,6079,3,1075,'App\\Models\\Receipt',1075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',15499.00,NULL,NULL,1,'2021-09-13 14:55:48','2021-09-13 14:55:48',NULL),(1107,3117,40728,6079,3,1076,'App\\Models\\Receipt',1076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',10499.00,NULL,NULL,1,'2021-09-13 14:55:48','2021-09-13 14:55:48',NULL),(1108,3117,40728,6079,3,1077,'App\\Models\\Receipt',1077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',9999.00,NULL,NULL,1,'2021-09-13 14:55:49','2021-09-13 14:55:49',NULL),(1109,3117,40728,6079,3,1078,'App\\Models\\Receipt',1078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',15499.00,NULL,NULL,1,'2021-09-13 14:55:49','2021-09-13 14:55:49',NULL),(1110,3117,40728,6079,3,1079,'App\\Models\\Receipt',1079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',15499.00,NULL,NULL,1,'2021-09-13 14:55:49','2021-09-13 14:55:49',NULL),(1111,3117,40728,6079,3,1080,'App\\Models\\Receipt',1080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-21','2021-08-21',37999.00,NULL,NULL,1,'2021-09-13 14:55:49','2021-09-13 14:55:49',NULL),(1112,3117,40728,6079,3,1081,'App\\Models\\Receipt',1081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',17999.00,NULL,NULL,1,'2021-09-13 14:55:49','2021-09-13 14:55:49',NULL),(1113,3117,40728,6079,3,1082,'App\\Models\\Receipt',1082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',29999.00,NULL,NULL,1,'2021-09-13 14:55:49','2021-09-13 14:55:49',NULL),(1114,3117,40728,6079,3,1083,'App\\Models\\Receipt',1083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',17999.00,NULL,NULL,1,'2021-09-13 14:55:49','2021-09-13 14:55:49',NULL),(1115,3117,40728,6079,3,1084,'App\\Models\\Receipt',1084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',29999.00,NULL,NULL,1,'2021-09-13 14:55:49','2021-09-13 14:55:49',NULL),(1116,3117,40728,6079,3,1085,'App\\Models\\Receipt',1085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',26999.00,NULL,NULL,1,'2021-09-13 14:55:49','2021-09-13 14:55:49',NULL);
INSERT INTO `balance_libro` VALUES (1117,3117,40728,6079,3,1086,'App\\Models\\Receipt',1086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',29999.00,NULL,NULL,1,'2021-09-13 14:55:49','2021-09-13 14:55:49',NULL),(1118,3117,40728,6079,3,1087,'App\\Models\\Receipt',1087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',10999.00,NULL,NULL,1,'2021-09-13 14:55:49','2021-09-13 14:55:49',NULL),(1119,3117,40728,6079,3,1088,'App\\Models\\Receipt',1088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',26999.00,NULL,NULL,1,'2021-09-13 14:55:49','2021-09-13 14:55:49',NULL),(1120,3117,40728,6079,3,1089,'App\\Models\\Receipt',1089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',29999.00,NULL,NULL,1,'2021-09-13 14:55:49','2021-09-13 14:55:49',NULL),(1121,3117,40728,6079,3,1090,'App\\Models\\Receipt',1090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',10999.00,NULL,NULL,1,'2021-09-13 14:55:49','2021-09-13 14:55:49',NULL),(1122,3117,40728,6079,3,1091,'App\\Models\\Receipt',1091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-24','2021-08-24',19999.00,NULL,NULL,1,'2021-09-13 14:55:49','2021-09-13 14:55:49',NULL),(1123,3117,40728,6079,3,1092,'App\\Models\\Receipt',1092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',19999.00,NULL,NULL,1,'2021-09-13 14:55:49','2021-09-13 14:55:49',NULL),(1124,3117,40728,6079,3,1093,'App\\Models\\Receipt',1093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',19999.00,NULL,NULL,1,'2021-09-13 14:55:49','2021-09-13 14:55:49',NULL),(1125,3117,40728,6079,3,1094,'App\\Models\\Receipt',1094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',19999.00,NULL,NULL,1,'2021-09-13 14:55:49','2021-09-13 14:55:49',NULL),(1126,3117,40728,6079,3,1095,'App\\Models\\Receipt',1095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',10999.00,NULL,NULL,1,'2021-09-13 14:55:49','2021-09-13 14:55:49',NULL),(1127,3117,40728,6079,3,1096,'App\\Models\\Receipt',1096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',19999.00,NULL,NULL,1,'2021-09-13 14:55:49','2021-09-13 14:55:49',NULL),(1128,3117,40728,6079,3,1097,'App\\Models\\Receipt',1097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',19999.00,NULL,NULL,1,'2021-09-13 14:55:49','2021-09-13 14:55:49',NULL),(1129,3117,40728,6079,3,1098,'App\\Models\\Receipt',1098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',6999.26,NULL,NULL,1,'2021-09-13 14:55:49','2021-09-13 15:02:09','2021-09-13 15:02:09'),(1130,3117,40728,6079,3,1099,'App\\Models\\Receipt',1099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',1799.50,NULL,NULL,1,'2021-09-13 14:55:49','2021-09-13 14:55:49',NULL),(1131,3117,40728,6079,3,1100,'App\\Models\\Receipt',1100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',300.00,NULL,NULL,1,'2021-09-13 14:55:49','2021-09-13 14:55:49',NULL),(1132,3117,40728,6079,3,1098,'App\\Models\\Receipt',1098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',6999.26,NULL,NULL,1,'2021-09-13 15:02:09','2021-09-13 15:02:09',NULL),(1133,3117,40719,10,2,1101,'App\\Models\\Receipt',1101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',9276.00,NULL,NULL,1,'2021-09-14 16:24:41','2021-09-14 16:24:41',NULL),(1134,3117,40719,10,2,1102,'App\\Models\\Receipt',1102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',40500.00,NULL,NULL,1,'2021-09-14 16:24:41','2021-09-14 16:24:41',NULL),(1135,3117,40719,10,2,1103,'App\\Models\\Receipt',1103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',34000.00,NULL,NULL,1,'2021-09-14 16:24:41','2021-09-14 16:24:41',NULL),(1136,3117,40719,10,2,1104,'App\\Models\\Receipt',1104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-14','2021-08-14',26500.00,NULL,NULL,1,'2021-09-14 16:24:41','2021-09-14 16:24:41',NULL),(1137,3117,40719,10,2,1105,'App\\Models\\Receipt',1105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-28','2021-08-28',48500.00,NULL,NULL,1,'2021-09-14 16:24:41','2021-09-14 16:24:41',NULL);
INSERT INTO `balance_libro` VALUES (1138,3117,40719,10,2,1106,'App\\Models\\Receipt',1106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',5094.00,NULL,NULL,1,'2021-09-14 16:24:41','2021-09-14 16:24:41',NULL),(1139,3117,40731,3054,2,1107,'App\\Models\\Receipt',1107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',5376.00,NULL,NULL,1,'2021-09-14 18:57:23','2021-09-14 18:57:23',NULL),(1140,3117,40731,3054,2,1108,'App\\Models\\Receipt',1108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',2464.00,NULL,NULL,1,'2021-09-14 18:57:23','2021-09-14 18:57:23',NULL),(1141,3117,40731,3054,2,1109,'App\\Models\\Receipt',1109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',12500.00,NULL,NULL,1,'2021-09-14 18:57:23','2021-09-14 18:57:23',NULL),(1142,3117,40731,3054,2,1110,'App\\Models\\Receipt',1110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',10501.00,NULL,NULL,1,'2021-09-14 18:57:23','2021-09-14 18:57:23',NULL),(1143,3117,40731,3054,2,1111,'App\\Models\\Receipt',1111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',9183.00,NULL,NULL,1,'2021-09-14 18:57:23','2021-09-14 18:57:23',NULL),(1144,3117,40731,3054,2,1112,'App\\Models\\Receipt',1112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',7840.00,NULL,NULL,1,'2021-09-14 18:57:23','2021-09-14 18:57:23',NULL),(1145,3117,40731,3054,2,1113,'App\\Models\\Receipt',1113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-05','2021-08-05',9323.00,NULL,NULL,1,'2021-09-14 18:57:23','2021-09-14 18:57:23',NULL),(1146,3117,40731,3054,2,1114,'App\\Models\\Receipt',1114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-05','2021-08-05',6009.00,NULL,NULL,1,'2021-09-14 18:57:23','2021-09-14 18:57:23',NULL),(1147,3117,40731,3054,2,1115,'App\\Models\\Receipt',1115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-06','2021-08-06',10555.00,NULL,NULL,1,'2021-09-14 18:57:23','2021-09-14 18:57:23',NULL),(1148,3117,40731,3054,2,1116,'App\\Models\\Receipt',1116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-06','2021-08-06',455.00,NULL,NULL,1,'2021-09-14 18:57:23','2021-09-14 18:57:23',NULL),(1149,3117,40731,3054,2,1117,'App\\Models\\Receipt',1117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',10204.00,NULL,NULL,1,'2021-09-14 18:57:23','2021-09-14 18:57:23',NULL),(1150,3117,40731,3054,2,1118,'App\\Models\\Receipt',1118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',9241.00,NULL,NULL,1,'2021-09-14 18:57:23','2021-09-14 18:57:23',NULL),(1151,3117,40731,3054,2,1119,'App\\Models\\Receipt',1119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-14','2021-08-14',7409.00,NULL,NULL,1,'2021-09-14 18:57:23','2021-09-14 18:57:23',NULL),(1152,3117,40731,3054,2,1120,'App\\Models\\Receipt',1120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-14','2021-08-14',12810.00,NULL,NULL,1,'2021-09-14 18:57:23','2021-09-14 18:57:23',NULL),(1153,3117,40731,3054,2,1121,'App\\Models\\Receipt',1121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',2141.00,NULL,NULL,1,'2021-09-14 18:57:23','2021-09-14 18:57:23',NULL),(1154,3117,40731,3054,2,1122,'App\\Models\\Receipt',1122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',1974.00,NULL,NULL,1,'2021-09-14 18:57:24','2021-09-14 18:57:24',NULL),(1155,3117,40731,3054,2,1123,'App\\Models\\Receipt',1123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-17','2021-08-17',3823.00,NULL,NULL,1,'2021-09-14 18:57:24','2021-09-14 18:57:24',NULL),(1156,3117,40731,3054,2,1124,'App\\Models\\Receipt',1124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-17','2021-08-17',388.00,NULL,NULL,1,'2021-09-14 18:57:24','2021-09-14 18:57:24',NULL),(1157,3117,40731,3054,2,1125,'App\\Models\\Receipt',1125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',7448.00,NULL,NULL,1,'2021-09-14 18:57:24','2021-09-14 18:57:24',NULL),(1158,3117,40731,3054,2,1126,'App\\Models\\Receipt',1126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',11024.00,NULL,NULL,1,'2021-09-14 18:57:24','2021-09-14 18:57:24',NULL);
INSERT INTO `balance_libro` VALUES (1159,3117,40731,3054,2,1127,'App\\Models\\Receipt',1127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',4505.00,NULL,NULL,1,'2021-09-14 18:57:24','2021-09-14 18:57:24',NULL),(1160,3117,40731,3054,2,1128,'App\\Models\\Receipt',1128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',8513.00,NULL,NULL,1,'2021-09-14 18:57:24','2021-09-14 18:57:24',NULL),(1161,3117,40731,3054,2,1129,'App\\Models\\Receipt',1129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',7304.00,NULL,NULL,1,'2021-09-14 18:57:24','2021-09-14 18:57:24',NULL),(1162,3117,40731,3054,2,1130,'App\\Models\\Receipt',1130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',12194.00,NULL,NULL,1,'2021-09-14 18:57:24','2021-09-14 18:57:24',NULL),(1163,3117,40731,3054,2,1131,'App\\Models\\Receipt',1131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',9859.00,NULL,NULL,1,'2021-09-14 18:57:24','2021-09-14 18:57:24',NULL),(1164,3117,40731,3054,2,1132,'App\\Models\\Receipt',1132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',7318.00,NULL,NULL,1,'2021-09-14 18:57:24','2021-09-14 18:57:24',NULL),(1165,3117,40731,3054,2,1133,'App\\Models\\Receipt',1133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',5568.00,NULL,NULL,1,'2021-09-14 18:57:24','2021-09-14 18:57:24',NULL),(1166,3117,40731,3054,2,1134,'App\\Models\\Receipt',1134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',11274.00,NULL,NULL,1,'2021-09-14 18:57:24','2021-09-14 18:57:24',NULL),(1167,3117,40731,3054,2,1135,'App\\Models\\Receipt',1135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',7798.00,NULL,NULL,1,'2021-09-14 18:57:24','2021-09-14 18:57:24',NULL),(1168,3117,40731,3054,2,1136,'App\\Models\\Receipt',1136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',9714.00,NULL,NULL,1,'2021-09-14 18:57:24','2021-09-14 18:57:24',NULL),(1169,3117,40731,3054,2,1137,'App\\Models\\Receipt',1137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',9336.00,NULL,NULL,1,'2021-09-14 18:57:24','2021-09-14 18:57:24',NULL),(1170,3117,40731,3054,2,1138,'App\\Models\\Receipt',1138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',6198.00,NULL,NULL,1,'2021-09-14 18:57:24','2021-09-14 18:57:24',NULL),(1171,3117,40731,3054,2,1139,'App\\Models\\Receipt',1139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',11048.00,NULL,NULL,1,'2021-09-14 18:57:24','2021-09-14 18:57:24',NULL),(1172,3117,40731,3054,2,1140,'App\\Models\\Receipt',1140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',12087.00,NULL,NULL,1,'2021-09-14 18:57:24','2021-09-14 18:57:24',NULL),(1173,3117,40731,3054,2,1141,'App\\Models\\Receipt',1141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',10301.00,NULL,NULL,1,'2021-09-14 18:57:24','2021-09-14 18:57:24',NULL),(1174,3117,40731,3054,2,1142,'App\\Models\\Receipt',1142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',12218.00,NULL,NULL,1,'2021-09-14 18:57:24','2021-09-14 18:57:24',NULL),(1175,3117,40731,3054,2,1143,'App\\Models\\Receipt',1143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',10076.00,NULL,NULL,1,'2021-09-14 18:57:24','2021-09-14 18:57:24',NULL),(1176,3117,40731,3054,2,1144,'App\\Models\\Receipt',1144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',7781.00,NULL,NULL,1,'2021-09-14 18:57:25','2021-09-14 18:57:25',NULL),(1177,3117,40731,3054,2,1145,'App\\Models\\Receipt',1145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',9799.00,NULL,NULL,1,'2021-09-14 18:57:25','2021-09-14 18:57:25',NULL),(1178,3117,40731,3054,2,1146,'App\\Models\\Receipt',1146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',10822.00,NULL,NULL,1,'2021-09-14 18:57:25','2021-09-14 18:57:25',NULL),(1179,3117,40731,3054,2,1147,'App\\Models\\Receipt',1147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',11701.00,NULL,NULL,1,'2021-09-14 18:57:25','2021-09-14 18:57:25',NULL);
INSERT INTO `balance_libro` VALUES (1180,3117,40731,3054,3,1148,'App\\Models\\Receipt',1148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-05','2021-08-05',800.00,NULL,NULL,1,'2021-09-14 18:57:52','2021-09-14 18:57:52',NULL),(1181,3117,40731,3054,3,1149,'App\\Models\\Receipt',1149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-05','2021-08-05',14419.30,NULL,NULL,1,'2021-09-14 18:57:52','2021-09-14 18:57:52',NULL),(1182,3117,40731,3054,3,1150,'App\\Models\\Receipt',1150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-06','2021-08-06',2058.56,NULL,NULL,1,'2021-09-14 18:57:52','2021-09-14 18:57:52',NULL),(1183,3117,40731,3054,3,1151,'App\\Models\\Receipt',1151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-06','2021-08-06',4655.62,NULL,NULL,1,'2021-09-14 18:57:52','2021-09-14 18:57:52',NULL),(1184,3117,40731,3054,3,1152,'App\\Models\\Receipt',1152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',2544.86,NULL,NULL,1,'2021-09-14 18:57:52','2021-09-14 18:57:52',NULL),(1185,3117,40731,3054,3,1153,'App\\Models\\Receipt',1153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',5533.34,NULL,NULL,1,'2021-09-14 18:57:53','2021-09-14 18:57:53',NULL),(1186,3117,40731,3054,3,1154,'App\\Models\\Receipt',1154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',7112.03,NULL,NULL,1,'2021-09-14 18:57:53','2021-09-14 18:57:53',NULL),(1187,3117,40731,3054,3,1155,'App\\Models\\Receipt',1155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',28533.19,NULL,NULL,1,'2021-09-14 18:57:53','2021-09-14 18:57:53',NULL),(1188,3117,40731,3054,3,1156,'App\\Models\\Receipt',1156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-21','2021-08-21',2470.19,NULL,NULL,1,'2021-09-14 18:57:53','2021-09-14 18:57:53',NULL),(1189,3117,40731,3054,3,1157,'App\\Models\\Receipt',1157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',14734.99,NULL,NULL,1,'2021-09-14 18:57:53','2021-09-14 18:57:53',NULL),(1190,3117,40731,3054,3,1158,'App\\Models\\Receipt',1158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',5181.00,NULL,NULL,1,'2021-09-14 18:57:53','2021-09-14 18:57:53',NULL),(1191,3117,40731,3054,3,1159,'App\\Models\\Receipt',1159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',1161.00,NULL,NULL,1,'2021-09-14 18:57:53','2021-09-14 18:57:53',NULL),(1192,3117,40731,3054,3,1160,'App\\Models\\Receipt',1160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',5633.37,NULL,NULL,1,'2021-09-14 18:57:53','2021-09-14 18:57:53',NULL),(1193,3117,40731,3054,3,1161,'App\\Models\\Receipt',1161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',344.92,NULL,NULL,1,'2021-09-14 18:57:53','2021-09-14 18:57:53',NULL),(1194,3117,40731,3054,3,1162,'App\\Models\\Receipt',1162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',365.50,NULL,NULL,1,'2021-09-14 18:57:53','2021-09-14 18:57:53',NULL),(1195,3117,40736,1544,2,1163,'App\\Models\\Receipt',1163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',12882.00,NULL,NULL,1,'2021-09-15 15:01:24','2021-09-15 15:01:24',NULL),(1196,3117,40736,1544,2,1164,'App\\Models\\Receipt',1164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-28','2021-08-28',13100.00,NULL,NULL,1,'2021-09-15 15:01:24','2021-09-15 15:01:24',NULL),(1197,3117,40736,1544,2,1165,'App\\Models\\Receipt',1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',12999.00,NULL,NULL,1,'2021-09-15 15:01:24','2021-09-15 15:01:24',NULL),(1198,3117,40736,1544,2,1166,'App\\Models\\Receipt',1166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',13099.00,NULL,NULL,1,'2021-09-15 15:01:24','2021-09-15 15:01:24',NULL),(1199,3117,40736,1544,2,1167,'App\\Models\\Receipt',1167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',12987.00,NULL,NULL,1,'2021-09-15 15:01:24','2021-09-15 15:01:24',NULL),(1200,3117,40736,1544,3,1168,'App\\Models\\Receipt',1168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',8399.00,NULL,NULL,1,'2021-09-15 15:01:39','2021-09-15 15:01:39',NULL);
INSERT INTO `balance_libro` VALUES (1201,3117,40736,1544,3,1169,'App\\Models\\Receipt',1169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',28951.00,NULL,NULL,1,'2021-09-15 15:01:39','2021-09-15 15:01:39',NULL),(1202,3117,40736,1544,3,1170,'App\\Models\\Receipt',1170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-09','2021-08-09',28177.50,NULL,NULL,1,'2021-09-15 15:01:39','2021-09-15 15:01:39',NULL),(1203,3117,40736,1544,3,1171,'App\\Models\\Receipt',1171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-14','2021-08-14',28177.50,NULL,NULL,1,'2021-09-15 15:01:39','2021-09-15 15:01:39',NULL),(1204,3117,40736,1544,3,1172,'App\\Models\\Receipt',1172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',40332.50,NULL,NULL,1,'2021-09-15 15:01:39','2021-09-15 15:01:39',NULL),(1205,3117,40736,1544,16,212,'App\\Models\\PeriodLiquidation',NULL,212,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',1626.68,NULL,NULL,1,'2021-09-15 15:04:40','2021-09-15 15:04:40',NULL),(1206,3117,40779,4573,2,1173,'App\\Models\\Receipt',1173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',2790.00,NULL,NULL,1,'2021-09-16 15:08:14','2021-09-16 15:08:14',NULL),(1207,3117,40779,4573,2,1174,'App\\Models\\Receipt',1174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',4720.00,NULL,NULL,1,'2021-09-16 15:08:15','2021-09-16 15:08:15',NULL),(1208,3117,40779,4573,2,1175,'App\\Models\\Receipt',1175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',4600.00,NULL,NULL,1,'2021-09-16 15:08:15','2021-09-16 15:08:15',NULL),(1209,3117,40779,4573,2,1176,'App\\Models\\Receipt',1176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',4730.00,NULL,NULL,1,'2021-09-16 15:08:15','2021-09-16 15:08:15',NULL),(1210,3117,40779,4573,2,1177,'App\\Models\\Receipt',1177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',2620.00,NULL,NULL,1,'2021-09-16 15:08:15','2021-09-16 15:08:15',NULL),(1211,3117,40779,4573,2,1178,'App\\Models\\Receipt',1178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-05','2021-08-05',4040.00,NULL,NULL,1,'2021-09-16 15:08:15','2021-09-16 15:08:15',NULL),(1212,3117,40779,4573,2,1179,'App\\Models\\Receipt',1179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-05','2021-08-05',4040.00,NULL,NULL,1,'2021-09-16 15:08:15','2021-09-16 15:08:15',NULL),(1213,3117,40779,4573,2,1180,'App\\Models\\Receipt',1180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-05','2021-08-05',4040.00,NULL,NULL,1,'2021-09-16 15:08:15','2021-09-16 15:08:15',NULL),(1214,3117,40779,4573,2,1181,'App\\Models\\Receipt',1181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-06','2021-08-06',3860.00,NULL,NULL,1,'2021-09-16 15:08:15','2021-09-16 15:08:15',NULL),(1215,3117,40779,4573,2,1182,'App\\Models\\Receipt',1182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-06','2021-08-06',4550.00,NULL,NULL,1,'2021-09-16 15:08:15','2021-09-16 15:08:15',NULL),(1216,3117,40779,4573,2,1183,'App\\Models\\Receipt',1183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-06','2021-08-06',4990.00,NULL,NULL,1,'2021-09-16 15:08:15','2021-09-16 15:08:15',NULL),(1217,3117,40779,4573,2,1184,'App\\Models\\Receipt',1184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',4520.00,NULL,NULL,1,'2021-09-16 15:08:15','2021-09-16 15:08:15',NULL),(1218,3117,40779,4573,2,1185,'App\\Models\\Receipt',1185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',4575.00,NULL,NULL,1,'2021-09-16 15:08:15','2021-09-16 15:08:15',NULL),(1219,3117,40779,4573,2,1186,'App\\Models\\Receipt',1186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',1690.00,NULL,NULL,1,'2021-09-16 15:08:15','2021-09-16 15:08:15',NULL),(1220,3117,40779,4573,2,1187,'App\\Models\\Receipt',1187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',4400.00,NULL,NULL,1,'2021-09-16 15:08:16','2021-09-16 15:08:16',NULL),(1221,3117,40779,4573,2,1188,'App\\Models\\Receipt',1188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',3750.00,NULL,NULL,1,'2021-09-16 15:08:16','2021-09-16 15:08:16',NULL);
INSERT INTO `balance_libro` VALUES (1222,3117,40779,4573,2,1189,'App\\Models\\Receipt',1189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',2310.00,NULL,NULL,1,'2021-09-16 15:08:16','2021-09-16 15:08:16',NULL),(1223,3117,40779,4573,2,1190,'App\\Models\\Receipt',1190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-08','2021-08-08',1000.00,NULL,NULL,1,'2021-09-16 15:08:16','2021-09-16 15:08:16',NULL),(1224,3117,40779,4573,2,1191,'App\\Models\\Receipt',1191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',1350.00,NULL,NULL,1,'2021-09-16 15:08:16','2021-09-16 15:08:16',NULL),(1225,3117,40779,4573,2,1192,'App\\Models\\Receipt',1192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',4950.00,NULL,NULL,1,'2021-09-16 15:08:16','2021-09-16 15:08:16',NULL),(1226,3117,40779,4573,2,1193,'App\\Models\\Receipt',1193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',4850.00,NULL,NULL,1,'2021-09-16 15:08:16','2021-09-16 15:08:16',NULL),(1227,3117,40779,4573,2,1194,'App\\Models\\Receipt',1194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',4460.00,NULL,NULL,1,'2021-09-16 15:08:16','2021-09-16 15:08:16',NULL),(1228,3117,40779,4573,2,1195,'App\\Models\\Receipt',1195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',4490.00,NULL,NULL,1,'2021-09-16 15:08:17','2021-09-16 15:08:17',NULL),(1229,3117,40779,4573,2,1196,'App\\Models\\Receipt',1196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',4280.00,NULL,NULL,1,'2021-09-16 15:08:17','2021-09-16 15:08:17',NULL),(1230,3117,40779,4573,2,1197,'App\\Models\\Receipt',1197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',4550.00,NULL,NULL,1,'2021-09-16 15:08:17','2021-09-16 15:08:17',NULL),(1231,3117,40779,4573,2,1198,'App\\Models\\Receipt',1198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',3915.00,NULL,NULL,1,'2021-09-16 15:08:17','2021-09-16 15:08:17',NULL),(1232,3117,40779,4573,2,1199,'App\\Models\\Receipt',1199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',3915.00,NULL,NULL,1,'2021-09-16 15:08:17','2021-09-16 15:08:17',NULL),(1233,3117,40779,4573,2,1200,'App\\Models\\Receipt',1200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',4950.00,NULL,NULL,1,'2021-09-16 15:08:17','2021-09-16 15:08:17',NULL),(1234,3117,40779,4573,2,1201,'App\\Models\\Receipt',1201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',4860.00,NULL,NULL,1,'2021-09-16 15:08:17','2021-09-16 15:08:17',NULL),(1235,3117,40779,4573,2,1202,'App\\Models\\Receipt',1202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',4130.00,NULL,NULL,1,'2021-09-16 15:08:17','2021-09-16 15:08:17',NULL),(1236,3117,40779,4573,2,1203,'App\\Models\\Receipt',1203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',3263.00,NULL,NULL,1,'2021-09-16 15:08:18','2021-09-16 15:08:18',NULL),(1237,3117,40779,4573,2,1204,'App\\Models\\Receipt',1204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',3262.00,NULL,NULL,1,'2021-09-16 15:08:18','2021-09-16 15:08:18',NULL),(1238,3117,40779,4573,2,1205,'App\\Models\\Receipt',1205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',4960.00,NULL,NULL,1,'2021-09-16 15:08:18','2021-09-16 15:08:18',NULL),(1239,3117,40779,4573,2,1206,'App\\Models\\Receipt',1206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',4200.00,NULL,NULL,1,'2021-09-16 15:08:18','2021-09-16 15:08:18',NULL),(1240,3117,40779,4573,2,1207,'App\\Models\\Receipt',1207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',4770.00,NULL,NULL,1,'2021-09-16 15:08:18','2021-09-16 15:08:18',NULL),(1241,3117,40779,4573,2,1208,'App\\Models\\Receipt',1208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-14','2021-08-14',1350.00,NULL,NULL,1,'2021-09-16 15:08:18','2021-09-16 15:08:18',NULL),(1242,3117,40779,4573,2,1209,'App\\Models\\Receipt',1209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16','2021-08-16',1350.00,NULL,NULL,1,'2021-09-16 15:08:18','2021-09-16 15:08:18',NULL);
INSERT INTO `balance_libro` VALUES (1243,3117,40779,4573,2,1210,'App\\Models\\Receipt',1210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',4890.00,NULL,NULL,1,'2021-09-16 15:08:18','2021-09-16 15:08:18',NULL),(1244,3117,40779,4573,2,1211,'App\\Models\\Receipt',1211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',4890.00,NULL,NULL,1,'2021-09-16 15:08:18','2021-09-16 15:08:18',NULL),(1245,3117,40779,4573,2,1212,'App\\Models\\Receipt',1212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',4890.00,NULL,NULL,1,'2021-09-16 15:08:19','2021-09-16 15:08:19',NULL),(1246,3117,40779,4573,2,1213,'App\\Models\\Receipt',1213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',4890.00,NULL,NULL,1,'2021-09-16 15:08:19','2021-09-16 15:08:19',NULL),(1247,3117,40779,4573,2,1214,'App\\Models\\Receipt',1214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',4890.00,NULL,NULL,1,'2021-09-16 15:08:19','2021-09-16 15:08:19',NULL),(1248,3117,40779,4573,2,1215,'App\\Models\\Receipt',1215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',1350.00,NULL,NULL,1,'2021-09-16 15:08:19','2021-09-16 15:08:19',NULL),(1249,3117,40779,4573,2,1216,'App\\Models\\Receipt',1216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',4890.00,NULL,NULL,1,'2021-09-16 15:08:19','2021-09-16 15:08:19',NULL),(1250,3117,40779,4573,2,1217,'App\\Models\\Receipt',1217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',4890.00,NULL,NULL,1,'2021-09-16 15:08:19','2021-09-16 15:08:19',NULL),(1251,3117,40779,4573,2,1218,'App\\Models\\Receipt',1218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',4272.00,NULL,NULL,1,'2021-09-16 15:08:19','2021-09-16 15:08:19',NULL),(1252,3117,40779,4573,2,1219,'App\\Models\\Receipt',1219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',4272.00,NULL,NULL,1,'2021-09-16 15:08:19','2021-09-16 15:08:19',NULL),(1253,3117,40779,4573,2,1220,'App\\Models\\Receipt',1220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',4272.00,NULL,NULL,1,'2021-09-16 15:08:20','2021-09-16 15:08:20',NULL),(1254,3117,40779,4573,2,1221,'App\\Models\\Receipt',1221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',4650.00,NULL,NULL,1,'2021-09-16 15:08:20','2021-09-16 15:08:20',NULL),(1255,3117,40779,4573,2,1222,'App\\Models\\Receipt',1222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',4920.00,NULL,NULL,1,'2021-09-16 15:08:20','2021-09-16 15:08:20',NULL),(1256,3117,40779,4573,2,1223,'App\\Models\\Receipt',1223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',4820.00,NULL,NULL,1,'2021-09-16 15:08:20','2021-09-16 15:08:20',NULL),(1257,3117,40779,4573,2,1224,'App\\Models\\Receipt',1224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',4760.00,NULL,NULL,1,'2021-09-16 15:08:20','2021-09-16 15:08:20',NULL),(1258,3117,40779,4573,2,1225,'App\\Models\\Receipt',1225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',4440.00,NULL,NULL,1,'2021-09-16 15:08:20','2021-09-16 15:08:20',NULL),(1259,3117,40779,4573,2,1226,'App\\Models\\Receipt',1226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',4710.00,NULL,NULL,1,'2021-09-16 15:08:20','2021-09-16 15:08:20',NULL),(1260,3117,40779,4573,2,1227,'App\\Models\\Receipt',1227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-28','2021-08-28',4930.00,NULL,NULL,1,'2021-09-16 15:08:20','2021-09-16 15:08:20',NULL),(1261,3117,40779,4573,2,1228,'App\\Models\\Receipt',1228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-28','2021-08-28',4820.00,NULL,NULL,1,'2021-09-16 15:08:20','2021-09-16 15:08:20',NULL),(1262,3117,40779,4573,2,1229,'App\\Models\\Receipt',1229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-28','2021-08-28',4710.00,NULL,NULL,1,'2021-09-16 15:08:21','2021-09-16 15:08:21',NULL),(1263,3117,40779,4573,2,1230,'App\\Models\\Receipt',1230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-28','2021-08-28',4990.00,NULL,NULL,1,'2021-09-16 15:08:21','2021-09-16 15:08:21',NULL);
INSERT INTO `balance_libro` VALUES (1264,3117,40779,4573,2,1231,'App\\Models\\Receipt',1231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-28','2021-08-28',4450.00,NULL,NULL,1,'2021-09-16 15:08:21','2021-09-16 15:08:21',NULL),(1265,3117,40779,4573,2,1232,'App\\Models\\Receipt',1232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-28','2021-08-28',4810.00,NULL,NULL,1,'2021-09-16 15:08:21','2021-09-16 15:08:21',NULL),(1266,3117,40779,4573,2,1233,'App\\Models\\Receipt',1233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-28','2021-08-28',4830.00,NULL,NULL,1,'2021-09-16 15:08:21','2021-09-16 15:08:21',NULL),(1267,3117,40779,4573,2,1234,'App\\Models\\Receipt',1234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-28','2021-08-28',4760.00,NULL,NULL,1,'2021-09-16 15:08:21','2021-09-16 15:08:21',NULL),(1268,3117,40779,4573,2,1235,'App\\Models\\Receipt',1235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-28','2021-08-28',4720.00,NULL,NULL,1,'2021-09-16 15:08:21','2021-09-16 15:08:21',NULL),(1269,3117,40779,4573,2,1236,'App\\Models\\Receipt',1236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-28','2021-08-28',4753.00,NULL,NULL,1,'2021-09-16 15:08:21','2021-09-16 15:08:21',NULL),(1270,3117,40779,4573,2,1237,'App\\Models\\Receipt',1237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-28','2021-08-28',4752.00,NULL,NULL,1,'2021-09-16 15:08:21','2021-09-16 15:08:21',NULL),(1271,3117,40779,4573,2,1238,'App\\Models\\Receipt',1238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-29','2021-08-29',4120.00,NULL,NULL,1,'2021-09-16 15:08:21','2021-09-16 15:08:21',NULL),(1272,3117,40779,4573,2,1239,'App\\Models\\Receipt',1239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-29','2021-08-29',4550.00,NULL,NULL,1,'2021-09-16 15:08:22','2021-09-16 15:08:22',NULL),(1273,3117,40779,4573,2,1240,'App\\Models\\Receipt',1240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-29','2021-08-29',4870.00,NULL,NULL,1,'2021-09-16 15:08:22','2021-09-16 15:08:22',NULL),(1274,3117,40779,4573,2,1241,'App\\Models\\Receipt',1241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-29','2021-08-29',2530.00,NULL,NULL,1,'2021-09-16 15:08:22','2021-09-16 15:08:22',NULL),(1275,3117,40779,4573,2,1242,'App\\Models\\Receipt',1242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',4970.00,NULL,NULL,1,'2021-09-16 15:08:22','2021-09-16 15:08:22',NULL),(1276,3117,40779,4573,2,1243,'App\\Models\\Receipt',1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',4540.00,NULL,NULL,1,'2021-09-16 15:08:22','2021-09-16 15:08:22',NULL),(1277,3117,40779,4573,2,1244,'App\\Models\\Receipt',1244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',4005.00,NULL,NULL,1,'2021-09-16 15:08:22','2021-09-16 15:08:22',NULL),(1278,3117,40779,4573,2,1245,'App\\Models\\Receipt',1245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',1709.00,NULL,NULL,1,'2021-09-16 15:08:22','2021-09-16 15:08:22',NULL),(1279,3117,40779,4573,3,1246,'App\\Models\\Receipt',1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-05','2021-08-05',1890.00,NULL,NULL,1,'2021-09-16 15:08:43','2021-09-16 15:08:43',NULL),(1280,3117,40779,4573,3,1247,'App\\Models\\Receipt',1247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-05','2021-08-05',1880.00,NULL,NULL,1,'2021-09-16 15:08:43','2021-09-16 15:08:43',NULL),(1281,3117,40779,4573,3,1248,'App\\Models\\Receipt',1248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-05','2021-08-05',15483.43,NULL,NULL,1,'2021-09-16 15:08:43','2021-09-16 15:08:43',NULL),(1282,3117,40779,4573,3,1249,'App\\Models\\Receipt',1249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-05','2021-08-05',22632.93,NULL,NULL,1,'2021-09-16 15:08:43','2021-09-16 15:08:43',NULL),(1283,3117,40779,4573,3,1250,'App\\Models\\Receipt',1250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-06','2021-08-06',59400.00,NULL,NULL,1,'2021-09-16 15:08:43','2021-09-16 15:08:43',NULL),(1284,3117,40779,4573,3,1251,'App\\Models\\Receipt',1251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-06','2021-08-06',1465.82,NULL,NULL,1,'2021-09-16 15:08:43','2021-09-16 15:08:43',NULL);
INSERT INTO `balance_libro` VALUES (1285,3117,40779,4573,3,1252,'App\\Models\\Receipt',1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',750.79,NULL,NULL,1,'2021-09-16 15:08:43','2021-09-16 15:08:43',NULL),(1286,3117,40779,4573,3,1253,'App\\Models\\Receipt',1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',3622.19,NULL,NULL,1,'2021-09-16 15:08:43','2021-09-16 15:08:43',NULL),(1287,3117,40779,4573,3,1254,'App\\Models\\Receipt',1254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-14','2021-08-14',6475.00,NULL,NULL,1,'2021-09-16 15:08:44','2021-09-16 15:08:44',NULL),(1288,3117,40779,4573,3,1255,'App\\Models\\Receipt',1255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-17','2021-08-17',10000.00,NULL,NULL,1,'2021-09-16 15:08:44','2021-09-16 15:08:44',NULL),(1289,3117,40779,4573,3,1256,'App\\Models\\Receipt',1256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',40915.88,NULL,NULL,1,'2021-09-16 15:08:44','2021-09-16 15:08:44',NULL),(1290,3117,40779,4573,3,1257,'App\\Models\\Receipt',1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',16824.63,NULL,NULL,1,'2021-09-16 15:08:44','2021-09-16 15:08:44',NULL),(1291,3117,40779,4573,3,1258,'App\\Models\\Receipt',1258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',16046.29,NULL,NULL,1,'2021-09-16 15:08:44','2021-09-16 15:08:44',NULL),(1292,3117,40779,4573,3,1259,'App\\Models\\Receipt',1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',50300.00,NULL,NULL,1,'2021-09-16 15:08:44','2021-09-16 15:08:44',NULL),(1293,3117,40779,4573,3,1260,'App\\Models\\Receipt',1260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',20519.23,NULL,NULL,1,'2021-09-16 15:08:44','2021-09-16 15:08:44',NULL),(1294,3117,40779,4573,3,1261,'App\\Models\\Receipt',1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-24','2021-08-24',5510.34,NULL,NULL,1,'2021-09-16 15:08:44','2021-09-16 15:08:44',NULL),(1295,3117,40779,4573,3,1262,'App\\Models\\Receipt',1262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',2233.50,NULL,NULL,1,'2021-09-16 15:08:45','2021-09-16 15:08:45',NULL),(1296,3117,40779,4573,3,1263,'App\\Models\\Receipt',1263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',14282.00,NULL,NULL,1,'2021-09-16 15:08:45','2021-09-16 15:08:45',NULL),(1297,3117,40779,4573,3,1264,'App\\Models\\Receipt',1264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',3989.07,NULL,NULL,1,'2021-09-16 15:08:45','2021-09-16 15:08:45',NULL),(1298,3117,40779,4573,3,1265,'App\\Models\\Receipt',1265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',29.14,NULL,NULL,1,'2021-09-16 15:08:45','2021-09-16 15:08:45',NULL),(1299,3117,40846,12446,2,1266,'App\\Models\\Receipt',1266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2075.00,NULL,NULL,1,'2021-09-24 14:58:58','2021-09-24 14:58:58',NULL),(1300,3117,40846,12446,2,1267,'App\\Models\\Receipt',1267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2043.00,NULL,NULL,1,'2021-09-24 14:58:58','2021-09-24 14:58:58',NULL),(1301,3117,40846,12446,2,1268,'App\\Models\\Receipt',1268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2805.00,NULL,NULL,1,'2021-09-24 14:58:58','2021-09-24 14:58:58',NULL),(1302,3117,40846,12446,2,1269,'App\\Models\\Receipt',1269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2100.00,NULL,NULL,1,'2021-09-24 14:58:59','2021-09-24 14:58:59',NULL),(1303,3117,40846,12446,2,1270,'App\\Models\\Receipt',1270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2605.00,NULL,NULL,1,'2021-09-24 14:58:59','2021-09-24 14:58:59',NULL),(1304,3117,40846,12446,2,1271,'App\\Models\\Receipt',1271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',3307.00,NULL,NULL,1,'2021-09-24 14:58:59','2021-09-24 14:58:59',NULL),(1305,3117,40846,12446,2,1272,'App\\Models\\Receipt',1272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',4075.00,NULL,NULL,1,'2021-09-24 14:58:59','2021-09-24 14:58:59',NULL);
INSERT INTO `balance_libro` VALUES (1306,3117,40846,12446,2,1273,'App\\Models\\Receipt',1273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2925.00,NULL,NULL,1,'2021-09-24 14:58:59','2021-09-24 14:58:59',NULL),(1307,3117,40846,12446,2,1274,'App\\Models\\Receipt',1274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2280.00,NULL,NULL,1,'2021-09-24 14:58:59','2021-09-24 14:58:59',NULL),(1308,3117,40846,12446,2,1275,'App\\Models\\Receipt',1275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',4510.00,NULL,NULL,1,'2021-09-24 14:58:59','2021-09-24 14:58:59',NULL),(1309,3117,40846,12446,2,1276,'App\\Models\\Receipt',1276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',4315.00,NULL,NULL,1,'2021-09-24 14:58:59','2021-09-24 14:58:59',NULL),(1310,3117,40846,12446,2,1277,'App\\Models\\Receipt',1277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',4190.00,NULL,NULL,1,'2021-09-24 14:58:59','2021-09-24 14:58:59',NULL),(1311,3117,40846,12446,2,1278,'App\\Models\\Receipt',1278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',3295.00,NULL,NULL,1,'2021-09-24 14:58:59','2021-09-24 14:58:59',NULL),(1312,3117,40846,12446,2,1279,'App\\Models\\Receipt',1279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',3280.00,NULL,NULL,1,'2021-09-24 14:58:59','2021-09-24 14:58:59',NULL),(1313,3117,40846,12446,2,1280,'App\\Models\\Receipt',1280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',3067.00,NULL,NULL,1,'2021-09-24 14:58:59','2021-09-24 14:58:59',NULL),(1314,3117,40846,12446,2,1281,'App\\Models\\Receipt',1281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1855.00,NULL,NULL,1,'2021-09-24 14:58:59','2021-09-24 14:58:59',NULL),(1315,3117,40846,12446,2,1282,'App\\Models\\Receipt',1282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',4000.00,NULL,NULL,1,'2021-09-24 14:58:59','2021-09-24 14:58:59',NULL),(1316,3117,40846,12446,2,1283,'App\\Models\\Receipt',1283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',4000.00,NULL,NULL,1,'2021-09-24 14:58:59','2021-09-24 14:58:59',NULL),(1317,3117,40846,12446,2,1284,'App\\Models\\Receipt',1284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',6000.00,NULL,NULL,1,'2021-09-24 14:58:59','2021-09-24 14:58:59',NULL),(1318,3117,40846,12446,2,1285,'App\\Models\\Receipt',1285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',6000.00,NULL,NULL,1,'2021-09-24 14:58:59','2021-09-24 14:58:59',NULL),(1319,3117,40846,12446,2,1286,'App\\Models\\Receipt',1286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',3955.00,NULL,NULL,1,'2021-09-24 14:58:59','2021-09-24 14:58:59',NULL),(1320,3117,40846,12446,2,1287,'App\\Models\\Receipt',1287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2450.00,NULL,NULL,1,'2021-09-24 14:58:59','2021-09-24 14:58:59',NULL),(1321,3117,40846,12446,2,1288,'App\\Models\\Receipt',1288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2990.00,NULL,NULL,1,'2021-09-24 14:58:59','2021-09-24 14:58:59',NULL),(1322,3117,40846,12446,2,1289,'App\\Models\\Receipt',1289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2549.00,NULL,NULL,1,'2021-09-24 14:58:59','2021-09-24 14:58:59',NULL),(1323,3117,40846,12446,2,1290,'App\\Models\\Receipt',1290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',3680.00,NULL,NULL,1,'2021-09-24 14:58:59','2021-09-24 14:58:59',NULL),(1324,3117,40846,12446,2,1291,'App\\Models\\Receipt',1291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2805.00,NULL,NULL,1,'2021-09-24 14:58:59','2021-09-24 14:58:59',NULL),(1325,3117,40846,12446,2,1292,'App\\Models\\Receipt',1292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',6797.00,NULL,NULL,1,'2021-09-24 14:58:59','2021-09-24 14:58:59',NULL),(1326,3117,40846,12446,2,1293,'App\\Models\\Receipt',1293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',3873.00,NULL,NULL,1,'2021-09-24 14:58:59','2021-09-24 14:58:59',NULL);
INSERT INTO `balance_libro` VALUES (1327,3117,40846,12446,2,1294,'App\\Models\\Receipt',1294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',3865.00,NULL,NULL,1,'2021-09-24 14:58:59','2021-09-24 14:58:59',NULL),(1328,3117,40846,12446,2,1295,'App\\Models\\Receipt',1295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',4173.00,NULL,NULL,1,'2021-09-24 14:58:59','2021-09-24 14:58:59',NULL),(1329,3117,40846,12446,2,1296,'App\\Models\\Receipt',1296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1580.00,NULL,NULL,1,'2021-09-24 14:58:59','2021-09-24 14:58:59',NULL),(1330,3117,40846,12446,2,1297,'App\\Models\\Receipt',1297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',4318.00,NULL,NULL,1,'2021-09-24 14:59:00','2021-09-24 14:59:00',NULL),(1331,3117,40846,12446,2,1298,'App\\Models\\Receipt',1298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',5145.00,NULL,NULL,1,'2021-09-24 14:59:00','2021-09-24 14:59:00',NULL),(1332,3117,40846,12446,2,1299,'App\\Models\\Receipt',1299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',2800.00,NULL,NULL,1,'2021-09-24 14:59:00','2021-09-24 14:59:00',NULL),(1333,3117,40846,12446,2,1300,'App\\Models\\Receipt',1300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',4600.00,NULL,NULL,1,'2021-09-24 14:59:00','2021-09-24 14:59:00',NULL),(1334,3117,40846,12446,2,1301,'App\\Models\\Receipt',1301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',3300.00,NULL,NULL,1,'2021-09-24 14:59:00','2021-09-24 14:59:00',NULL),(1335,3117,40846,12446,2,1302,'App\\Models\\Receipt',1302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',2905.00,NULL,NULL,1,'2021-09-24 14:59:00','2021-09-24 14:59:00',NULL),(1336,3117,40846,12446,2,1303,'App\\Models\\Receipt',1303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',4120.00,NULL,NULL,1,'2021-09-24 14:59:00','2021-09-24 14:59:00',NULL),(1337,3117,40846,12446,2,1304,'App\\Models\\Receipt',1304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',3315.00,NULL,NULL,1,'2021-09-24 14:59:00','2021-09-24 14:59:00',NULL),(1338,3117,40846,12446,2,1305,'App\\Models\\Receipt',1305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',4820.00,NULL,NULL,1,'2021-09-24 14:59:00','2021-09-24 14:59:00',NULL),(1339,3117,40846,12446,2,1306,'App\\Models\\Receipt',1306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',2705.00,NULL,NULL,1,'2021-09-24 14:59:00','2021-09-24 14:59:00',NULL),(1340,3117,40846,12446,2,1307,'App\\Models\\Receipt',1307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',4635.00,NULL,NULL,1,'2021-09-24 14:59:00','2021-09-24 14:59:00',NULL),(1341,3117,40846,12446,2,1308,'App\\Models\\Receipt',1308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',7155.00,NULL,NULL,1,'2021-09-24 14:59:00','2021-09-24 14:59:00',NULL),(1342,3117,40846,12446,2,1309,'App\\Models\\Receipt',1309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',5970.00,NULL,NULL,1,'2021-09-24 14:59:00','2021-09-24 14:59:00',NULL),(1343,3117,40846,12446,2,1310,'App\\Models\\Receipt',1310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',1915.00,NULL,NULL,1,'2021-09-24 14:59:00','2021-09-24 14:59:00',NULL),(1344,3117,40846,12446,2,1311,'App\\Models\\Receipt',1311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',3010.00,NULL,NULL,1,'2021-09-24 14:59:00','2021-09-24 14:59:00',NULL),(1345,3117,40846,12446,2,1312,'App\\Models\\Receipt',1312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',6000.00,NULL,NULL,1,'2021-09-24 14:59:00','2021-09-24 14:59:00',NULL),(1346,3117,40846,12446,2,1313,'App\\Models\\Receipt',1313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',6000.00,NULL,NULL,1,'2021-09-24 14:59:00','2021-09-24 14:59:00',NULL),(1347,3117,40846,12446,2,1314,'App\\Models\\Receipt',1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',2640.00,NULL,NULL,1,'2021-09-24 14:59:00','2021-09-24 14:59:00',NULL);
INSERT INTO `balance_libro` VALUES (1348,3117,40846,12446,2,1315,'App\\Models\\Receipt',1315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',3025.00,NULL,NULL,1,'2021-09-24 14:59:00','2021-09-24 14:59:00',NULL),(1349,3117,40846,12446,2,1316,'App\\Models\\Receipt',1316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',2526.00,NULL,NULL,1,'2021-09-24 14:59:00','2021-09-24 14:59:00',NULL),(1350,3117,40846,12446,2,1317,'App\\Models\\Receipt',1317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',1660.00,NULL,NULL,1,'2021-09-24 14:59:00','2021-09-24 14:59:00',NULL),(1351,3117,40846,12446,2,1318,'App\\Models\\Receipt',1318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',5845.00,NULL,NULL,1,'2021-09-24 14:59:00','2021-09-24 14:59:00',NULL),(1352,3117,40846,12446,2,1319,'App\\Models\\Receipt',1319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',2000.00,NULL,NULL,1,'2021-09-24 14:59:00','2021-09-24 14:59:00',NULL),(1353,3117,40846,12446,2,1320,'App\\Models\\Receipt',1320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',3510.00,NULL,NULL,1,'2021-09-24 14:59:00','2021-09-24 14:59:00',NULL),(1354,3117,40846,12446,2,1321,'App\\Models\\Receipt',1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',3320.00,NULL,NULL,1,'2021-09-24 14:59:00','2021-09-24 14:59:00',NULL),(1355,3117,40846,12446,2,1322,'App\\Models\\Receipt',1322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',2030.00,NULL,NULL,1,'2021-09-24 14:59:00','2021-09-24 14:59:00',NULL),(1356,3117,40846,12446,2,1323,'App\\Models\\Receipt',1323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1690.00,NULL,NULL,1,'2021-09-24 14:59:00','2021-09-24 14:59:00',NULL),(1357,3117,40846,12446,2,1324,'App\\Models\\Receipt',1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1360.00,NULL,NULL,1,'2021-09-24 14:59:00','2021-09-24 14:59:00',NULL),(1358,3117,40846,12446,2,1325,'App\\Models\\Receipt',1325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',4000.00,NULL,NULL,1,'2021-09-24 14:59:01','2021-09-24 14:59:01',NULL),(1359,3117,40846,12446,2,1326,'App\\Models\\Receipt',1326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1760.00,NULL,NULL,1,'2021-09-24 14:59:01','2021-09-24 14:59:01',NULL),(1360,3117,40846,12446,2,1327,'App\\Models\\Receipt',1327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',3960.00,NULL,NULL,1,'2021-09-24 14:59:01','2021-09-24 14:59:01',NULL),(1361,3117,40846,12446,2,1328,'App\\Models\\Receipt',1328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1410.00,NULL,NULL,1,'2021-09-24 14:59:01','2021-09-24 14:59:01',NULL),(1362,3117,40846,12446,2,1329,'App\\Models\\Receipt',1329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',2106.00,NULL,NULL,1,'2021-09-24 14:59:01','2021-09-24 14:59:01',NULL),(1363,3117,40846,12446,2,1330,'App\\Models\\Receipt',1330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1957.00,NULL,NULL,1,'2021-09-24 14:59:01','2021-09-24 14:59:01',NULL),(1364,3117,40846,12446,2,1331,'App\\Models\\Receipt',1331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1698.00,NULL,NULL,1,'2021-09-24 14:59:01','2021-09-24 14:59:01',NULL),(1365,3117,40846,12446,2,1332,'App\\Models\\Receipt',1332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',2430.00,NULL,NULL,1,'2021-09-24 14:59:01','2021-09-24 14:59:01',NULL),(1366,3117,40846,12446,2,1333,'App\\Models\\Receipt',1333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1363.00,NULL,NULL,1,'2021-09-24 14:59:01','2021-09-24 14:59:01',NULL),(1367,3117,40846,12446,2,1334,'App\\Models\\Receipt',1334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',2628.00,NULL,NULL,1,'2021-09-24 14:59:01','2021-09-24 14:59:01',NULL),(1368,3117,40846,12446,2,1335,'App\\Models\\Receipt',1335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',2770.00,NULL,NULL,1,'2021-09-24 14:59:01','2021-09-24 14:59:01',NULL);
INSERT INTO `balance_libro` VALUES (1369,3117,40846,12446,2,1336,'App\\Models\\Receipt',1336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1830.00,NULL,NULL,1,'2021-09-24 14:59:01','2021-09-24 14:59:01',NULL),(1370,3117,40846,12446,2,1337,'App\\Models\\Receipt',1337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1607.00,NULL,NULL,1,'2021-09-24 14:59:01','2021-09-24 14:59:01',NULL),(1371,3117,40846,12446,2,1338,'App\\Models\\Receipt',1338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2575.00,NULL,NULL,1,'2021-09-24 14:59:49','2021-09-28 17:44:32','2021-09-28 17:44:32'),(1372,3117,40846,12446,2,1339,'App\\Models\\Receipt',1339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',3007.00,NULL,NULL,1,'2021-09-24 14:59:49','2021-09-28 18:29:24','2021-09-28 18:29:24'),(1373,3117,40846,12446,2,1340,'App\\Models\\Receipt',1340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2345.00,NULL,NULL,1,'2021-09-24 14:59:49','2021-09-28 18:29:10','2021-09-28 18:29:10'),(1374,3117,40846,12446,2,1341,'App\\Models\\Receipt',1341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',1710.00,NULL,NULL,1,'2021-09-24 14:59:49','2021-09-28 18:28:57','2021-09-28 18:28:57'),(1375,3117,40846,12446,2,1342,'App\\Models\\Receipt',1342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',4500.00,NULL,NULL,1,'2021-09-24 14:59:49','2021-09-28 18:28:42','2021-09-28 18:28:42'),(1376,3117,40846,12446,2,1343,'App\\Models\\Receipt',1343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',4500.00,NULL,NULL,1,'2021-09-24 14:59:49','2021-09-28 18:28:29','2021-09-28 18:28:29'),(1377,3117,40846,12446,2,1344,'App\\Models\\Receipt',1344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2860.00,NULL,NULL,1,'2021-09-24 14:59:49','2021-09-28 18:28:14','2021-09-28 18:28:14'),(1378,3117,40846,12446,2,1345,'App\\Models\\Receipt',1345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',3975.00,NULL,NULL,1,'2021-09-24 14:59:49','2021-09-28 18:27:59','2021-09-28 18:27:59'),(1379,3117,40846,12446,2,1346,'App\\Models\\Receipt',1346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2955.00,NULL,NULL,1,'2021-09-24 14:59:49','2021-09-28 18:27:45','2021-09-28 18:27:45'),(1380,3117,40846,12446,2,1347,'App\\Models\\Receipt',1347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2415.00,NULL,NULL,1,'2021-09-24 14:59:49','2021-09-28 18:27:31','2021-09-28 18:27:31'),(1381,3117,40846,12446,2,1348,'App\\Models\\Receipt',1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2900.00,NULL,NULL,1,'2021-09-24 14:59:49','2021-09-28 18:27:17','2021-09-28 18:27:17'),(1382,3117,40846,12446,2,1349,'App\\Models\\Receipt',1349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2000.00,NULL,NULL,1,'2021-09-24 14:59:49','2021-09-28 18:27:04','2021-09-28 18:27:04'),(1383,3117,40846,12446,2,1350,'App\\Models\\Receipt',1350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',3120.00,NULL,NULL,1,'2021-09-24 14:59:50','2021-09-28 18:26:48','2021-09-28 18:26:48'),(1384,3117,40846,12446,2,1351,'App\\Models\\Receipt',1351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2370.00,NULL,NULL,1,'2021-09-24 14:59:50','2021-09-28 18:26:34','2021-09-28 18:26:34'),(1385,3117,40846,12446,2,1352,'App\\Models\\Receipt',1352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',5365.00,NULL,NULL,1,'2021-09-24 14:59:50','2021-09-28 18:26:20','2021-09-28 18:26:20'),(1386,3117,40846,12446,2,1353,'App\\Models\\Receipt',1353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2950.00,NULL,NULL,1,'2021-09-24 14:59:50','2021-09-28 18:26:05','2021-09-28 18:26:05'),(1387,3117,40846,12446,2,1354,'App\\Models\\Receipt',1354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',3223.00,NULL,NULL,1,'2021-09-24 14:59:50','2021-09-28 18:25:53','2021-09-28 18:25:53');
INSERT INTO `balance_libro` VALUES (1388,3117,40846,12446,2,1355,'App\\Models\\Receipt',1355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2470.00,NULL,NULL,1,'2021-09-24 14:59:50','2021-09-28 18:25:40','2021-09-28 18:25:40'),(1389,3117,40846,12446,2,1356,'App\\Models\\Receipt',1356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',1890.00,NULL,NULL,1,'2021-09-24 14:59:50','2021-09-28 18:25:25','2021-09-28 18:25:25'),(1390,3117,40846,12446,2,1357,'App\\Models\\Receipt',1357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2225.00,NULL,NULL,1,'2021-09-24 14:59:50','2021-09-28 18:25:12','2021-09-28 18:25:12'),(1391,3117,40846,12446,2,1358,'App\\Models\\Receipt',1358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2380.00,NULL,NULL,1,'2021-09-24 14:59:50','2021-09-28 18:24:59','2021-09-28 18:24:59'),(1392,3117,40846,12446,2,1359,'App\\Models\\Receipt',1359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2510.00,NULL,NULL,1,'2021-09-24 14:59:50','2021-09-28 18:24:45','2021-09-28 18:24:45'),(1393,3117,40846,12446,2,1360,'App\\Models\\Receipt',1360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2000.00,NULL,NULL,1,'2021-09-24 14:59:50','2021-09-28 18:24:31','2021-09-28 18:24:31'),(1394,3117,40846,12446,2,1361,'App\\Models\\Receipt',1361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2990.00,NULL,NULL,1,'2021-09-24 14:59:50','2021-09-28 18:24:18','2021-09-28 18:24:18'),(1395,3117,40846,12446,2,1362,'App\\Models\\Receipt',1362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',800.00,NULL,NULL,1,'2021-09-24 14:59:50','2021-09-28 18:24:03','2021-09-28 18:24:03'),(1396,3117,40846,12446,2,1363,'App\\Models\\Receipt',1363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',5000.00,NULL,NULL,1,'2021-09-24 14:59:50','2021-09-28 18:23:50','2021-09-28 18:23:50'),(1397,3117,40846,12446,2,1364,'App\\Models\\Receipt',1364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',1980.00,NULL,NULL,1,'2021-09-24 14:59:50','2021-09-28 18:23:37','2021-09-28 18:23:37'),(1398,3117,40846,12446,2,1365,'App\\Models\\Receipt',1365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',3525.00,NULL,NULL,1,'2021-09-24 14:59:50','2021-09-28 18:23:22','2021-09-28 18:23:22'),(1399,3117,40846,12446,2,1366,'App\\Models\\Receipt',1366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',1108.00,NULL,NULL,1,'2021-09-24 14:59:50','2021-09-28 18:23:09','2021-09-28 18:23:09'),(1400,3117,40846,12446,2,1367,'App\\Models\\Receipt',1367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',5000.00,NULL,NULL,1,'2021-09-24 14:59:50','2021-09-28 18:22:55','2021-09-28 18:22:55'),(1401,3117,40846,12446,2,1368,'App\\Models\\Receipt',1368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',5000.00,NULL,NULL,1,'2021-09-24 14:59:50','2021-09-28 18:22:43','2021-09-28 18:22:43'),(1402,3117,40846,12446,2,1369,'App\\Models\\Receipt',1369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',5000.00,NULL,NULL,1,'2021-09-24 14:59:50','2021-09-28 18:22:32','2021-09-28 18:22:32'),(1403,3117,40846,12446,2,1370,'App\\Models\\Receipt',1370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',5000.00,NULL,NULL,1,'2021-09-24 14:59:50','2021-09-28 18:22:18','2021-09-28 18:22:18'),(1404,3117,40846,12446,2,1371,'App\\Models\\Receipt',1371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3425.00,NULL,NULL,1,'2021-09-24 14:59:51','2021-09-28 18:22:03','2021-09-28 18:22:03'),(1405,3117,40846,12446,2,1372,'App\\Models\\Receipt',1372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',2300.00,NULL,NULL,1,'2021-09-24 14:59:51','2021-09-28 18:21:50','2021-09-28 18:21:50'),(1406,3117,40846,12446,2,1373,'App\\Models\\Receipt',1373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',2510.00,NULL,NULL,1,'2021-09-24 14:59:51','2021-09-28 18:21:36','2021-09-28 18:21:36');
INSERT INTO `balance_libro` VALUES (1407,3117,40846,12446,2,1374,'App\\Models\\Receipt',1374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',2250.00,NULL,NULL,1,'2021-09-24 14:59:51','2021-09-28 18:21:22','2021-09-28 18:21:22'),(1408,3117,40846,12446,2,1375,'App\\Models\\Receipt',1375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3130.00,NULL,NULL,1,'2021-09-24 14:59:51','2021-09-28 18:21:09','2021-09-28 18:21:09'),(1409,3117,40846,12446,2,1376,'App\\Models\\Receipt',1376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',1371.00,NULL,NULL,1,'2021-09-24 14:59:51','2021-09-28 18:20:55','2021-09-28 18:20:55'),(1410,3117,40846,12446,2,1377,'App\\Models\\Receipt',1377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',2200.00,NULL,NULL,1,'2021-09-24 14:59:51','2021-09-28 18:20:40','2021-09-28 18:20:40'),(1411,3117,40846,12446,2,1378,'App\\Models\\Receipt',1378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3025.00,NULL,NULL,1,'2021-09-24 14:59:51','2021-09-28 18:20:13','2021-09-28 18:20:13'),(1412,3117,40846,12446,2,1379,'App\\Models\\Receipt',1379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',2090.00,NULL,NULL,1,'2021-09-24 14:59:51','2021-09-28 18:19:55','2021-09-28 18:19:55'),(1413,3117,40846,12446,2,1380,'App\\Models\\Receipt',1380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3910.00,NULL,NULL,1,'2021-09-24 14:59:51','2021-09-28 18:13:29','2021-09-28 18:13:29'),(1414,3117,40846,12446,2,1381,'App\\Models\\Receipt',1381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3340.00,NULL,NULL,1,'2021-09-24 14:59:51','2021-09-28 18:13:14','2021-09-28 18:13:14'),(1415,3117,40846,12446,2,1382,'App\\Models\\Receipt',1382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',5450.00,NULL,NULL,1,'2021-09-24 14:59:51','2021-09-28 18:12:58','2021-09-28 18:12:58'),(1416,3117,40846,12446,2,1383,'App\\Models\\Receipt',1383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',4830.00,NULL,NULL,1,'2021-09-24 14:59:51','2021-09-28 18:12:40','2021-09-28 18:12:40'),(1417,3117,40846,12446,2,1384,'App\\Models\\Receipt',1384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',4840.00,NULL,NULL,1,'2021-09-24 14:59:51','2021-09-28 18:12:25','2021-09-28 18:12:25'),(1418,3117,40846,12446,2,1385,'App\\Models\\Receipt',1385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3127.00,NULL,NULL,1,'2021-09-24 14:59:51','2021-09-28 18:12:10','2021-09-28 18:12:10'),(1419,3117,40846,12446,2,1386,'App\\Models\\Receipt',1386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3882.00,NULL,NULL,1,'2021-09-24 14:59:51','2021-09-28 18:11:57','2021-09-28 18:11:57'),(1420,3117,40846,12446,2,1387,'App\\Models\\Receipt',1387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3295.00,NULL,NULL,1,'2021-09-24 14:59:51','2021-09-28 18:11:42','2021-09-28 18:11:42'),(1421,3117,40846,12446,2,1388,'App\\Models\\Receipt',1388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',4500.00,NULL,NULL,1,'2021-09-24 14:59:51','2021-09-28 18:11:31','2021-09-28 18:11:31'),(1422,3117,40846,12446,2,1389,'App\\Models\\Receipt',1389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',4500.00,NULL,NULL,1,'2021-09-24 14:59:51','2021-09-28 18:11:18','2021-09-28 18:11:18'),(1423,3117,40846,12446,2,1390,'App\\Models\\Receipt',1390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3650.00,NULL,NULL,1,'2021-09-24 14:59:51','2021-09-28 18:11:01','2021-09-28 18:11:01'),(1424,3117,40846,12446,2,1391,'App\\Models\\Receipt',1391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',1620.00,NULL,NULL,1,'2021-09-24 14:59:51','2021-09-28 18:10:49','2021-09-28 18:10:49'),(1425,3117,40846,12446,2,1392,'App\\Models\\Receipt',1392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',4050.00,NULL,NULL,1,'2021-09-24 14:59:51','2021-09-28 18:10:36','2021-09-28 18:10:36');
INSERT INTO `balance_libro` VALUES (1426,3117,40846,12446,2,1393,'App\\Models\\Receipt',1393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',4050.00,NULL,NULL,1,'2021-09-24 14:59:51','2021-09-28 18:10:24','2021-09-28 18:10:24'),(1427,3117,40846,12446,2,1394,'App\\Models\\Receipt',1394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',1670.00,NULL,NULL,1,'2021-09-24 14:59:52','2021-09-28 18:10:11','2021-09-28 18:10:11'),(1428,3117,40846,12446,2,1395,'App\\Models\\Receipt',1395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',5300.00,NULL,NULL,1,'2021-09-24 14:59:52','2021-09-28 18:09:58','2021-09-28 18:09:58'),(1429,3117,40846,12446,2,1396,'App\\Models\\Receipt',1396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3195.00,NULL,NULL,1,'2021-09-24 14:59:52','2021-09-28 18:09:44','2021-09-28 18:09:44'),(1430,3117,40846,12446,2,1397,'App\\Models\\Receipt',1397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',1630.00,NULL,NULL,1,'2021-09-24 14:59:52','2021-09-28 18:09:16','2021-09-28 18:09:16'),(1431,3117,40846,12446,2,1398,'App\\Models\\Receipt',1398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',2665.00,NULL,NULL,1,'2021-09-24 15:00:06','2021-09-28 18:08:50','2021-09-28 18:08:50'),(1432,3117,40846,12446,2,1399,'App\\Models\\Receipt',1399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',2115.00,NULL,NULL,1,'2021-09-24 15:00:06','2021-09-28 18:08:37','2021-09-28 18:08:37'),(1433,3117,40846,12446,2,1400,'App\\Models\\Receipt',1400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',6625.00,NULL,NULL,1,'2021-09-24 15:00:06','2021-09-28 18:08:23','2021-09-28 18:08:23'),(1434,3117,40846,12446,2,1401,'App\\Models\\Receipt',1401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',6625.00,NULL,NULL,1,'2021-09-24 15:00:06','2021-09-28 18:08:09','2021-09-28 18:08:09'),(1435,3117,40846,12446,2,1402,'App\\Models\\Receipt',1402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',6625.00,NULL,NULL,1,'2021-09-24 15:00:07','2021-09-28 18:07:56','2021-09-28 18:07:56'),(1436,3117,40846,12446,2,1403,'App\\Models\\Receipt',1403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',6625.00,NULL,NULL,1,'2021-09-24 15:00:07','2021-09-28 18:07:41','2021-09-28 18:07:41'),(1437,3117,40846,12446,2,1404,'App\\Models\\Receipt',1404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',5000.00,NULL,NULL,1,'2021-09-24 15:00:07','2021-09-28 18:07:27','2021-09-28 18:07:27'),(1438,3117,40846,12446,2,1405,'App\\Models\\Receipt',1405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',5000.00,NULL,NULL,1,'2021-09-24 15:00:07','2021-09-28 18:07:09','2021-09-28 18:07:09'),(1439,3117,40846,12446,2,1406,'App\\Models\\Receipt',1406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',180.00,NULL,NULL,1,'2021-09-24 15:00:07','2021-09-28 18:06:51','2021-09-28 18:06:51'),(1440,3117,40846,12446,2,1407,'App\\Models\\Receipt',1407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',8000.00,NULL,NULL,1,'2021-09-24 15:00:07','2021-09-28 18:06:37','2021-09-28 18:06:37'),(1441,3117,40846,12446,2,1408,'App\\Models\\Receipt',1408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',5000.00,NULL,NULL,1,'2021-09-24 15:00:07','2021-09-28 18:06:19','2021-09-28 18:06:19'),(1442,3117,40846,12446,2,1409,'App\\Models\\Receipt',1409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',2145.00,NULL,NULL,1,'2021-09-24 15:00:07','2021-09-28 18:06:02','2021-09-28 18:06:02'),(1443,3117,40846,12446,2,1410,'App\\Models\\Receipt',1410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',2060.00,NULL,NULL,1,'2021-09-24 15:00:07','2021-09-28 18:05:25','2021-09-28 18:05:25'),(1444,3117,40846,12446,2,1411,'App\\Models\\Receipt',1411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',4315.00,NULL,NULL,1,'2021-09-24 15:00:07','2021-09-28 18:04:41','2021-09-28 18:04:41');
INSERT INTO `balance_libro` VALUES (1445,3117,40846,12446,2,1412,'App\\Models\\Receipt',1412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',1000.00,NULL,NULL,1,'2021-09-24 15:00:07','2021-09-28 18:03:59','2021-09-28 18:03:59'),(1446,3117,40846,12446,2,1413,'App\\Models\\Receipt',1413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',4380.00,NULL,NULL,1,'2021-09-24 15:00:07','2021-09-28 18:03:47','2021-09-28 18:03:47'),(1447,3117,40846,12446,2,1414,'App\\Models\\Receipt',1414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',2700.00,NULL,NULL,1,'2021-09-24 15:00:07','2021-09-28 18:03:32','2021-09-28 18:03:32'),(1448,3117,40846,12446,2,1415,'App\\Models\\Receipt',1415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',1300.00,NULL,NULL,1,'2021-09-24 15:00:07','2021-09-28 18:03:18','2021-09-28 18:03:18'),(1449,3117,40846,12446,2,1416,'App\\Models\\Receipt',1416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',2665.00,NULL,NULL,1,'2021-09-24 15:00:07','2021-09-28 18:03:04','2021-09-28 18:03:04'),(1450,3117,40846,12446,2,1417,'App\\Models\\Receipt',1417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',2115.00,NULL,NULL,1,'2021-09-24 15:00:07','2021-09-28 18:02:50','2021-09-28 18:02:50'),(1451,3117,40846,12446,2,1418,'App\\Models\\Receipt',1418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',4280.00,NULL,NULL,1,'2021-09-24 15:00:07','2021-09-28 18:02:37','2021-09-28 18:02:37'),(1452,3117,40846,12446,2,1419,'App\\Models\\Receipt',1419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',2700.00,NULL,NULL,1,'2021-09-24 15:00:07','2021-09-28 18:02:22','2021-09-28 18:02:22'),(1453,3117,40846,12446,2,1420,'App\\Models\\Receipt',1420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1650.00,NULL,NULL,1,'2021-09-24 15:00:07','2021-09-28 18:02:08','2021-09-28 18:02:08'),(1454,3117,40846,12446,2,1421,'App\\Models\\Receipt',1421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1750.00,NULL,NULL,1,'2021-09-24 15:00:07','2021-09-28 18:01:52','2021-09-28 18:01:52'),(1455,3117,40846,12446,2,1422,'App\\Models\\Receipt',1422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',2543.00,NULL,NULL,1,'2021-09-24 15:00:07','2021-09-28 18:01:37','2021-09-28 18:01:37'),(1456,3117,40846,12446,2,1423,'App\\Models\\Receipt',1423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',8000.00,NULL,NULL,1,'2021-09-24 15:00:07','2021-09-28 18:01:20','2021-09-28 18:01:20'),(1457,3117,40846,12446,2,1424,'App\\Models\\Receipt',1424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',8000.00,NULL,NULL,1,'2021-09-24 15:00:07','2021-09-28 18:01:02','2021-09-28 18:01:02'),(1458,3117,40846,12446,2,1425,'App\\Models\\Receipt',1425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',8000.00,NULL,NULL,1,'2021-09-24 15:00:07','2021-09-28 17:57:22','2021-09-28 17:57:22'),(1459,3117,40846,12446,2,1426,'App\\Models\\Receipt',1426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',143.00,NULL,NULL,1,'2021-09-24 15:00:07','2021-09-28 17:57:09','2021-09-28 17:57:09'),(1460,3117,40846,12446,2,1427,'App\\Models\\Receipt',1427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',143.00,NULL,NULL,1,'2021-09-24 15:00:07','2021-09-28 17:56:55','2021-09-28 17:56:55'),(1461,3117,40846,12446,2,1428,'App\\Models\\Receipt',1428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',143.00,NULL,NULL,1,'2021-09-24 15:00:08','2021-09-28 17:56:35','2021-09-28 17:56:35'),(1462,3117,40846,12446,2,1429,'App\\Models\\Receipt',1429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',3500.00,NULL,NULL,1,'2021-09-24 15:00:08','2021-09-28 17:56:20','2021-09-28 17:56:20'),(1463,3117,40846,12446,2,1430,'App\\Models\\Receipt',1430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1395.00,NULL,NULL,1,'2021-09-24 15:00:08','2021-09-28 17:56:06','2021-09-28 17:56:06');
INSERT INTO `balance_libro` VALUES (1464,3117,40846,12446,2,1431,'App\\Models\\Receipt',1431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',3300.00,NULL,NULL,1,'2021-09-24 15:00:08','2021-09-28 17:55:48','2021-09-28 17:55:48'),(1465,3117,40846,12446,2,1432,'App\\Models\\Receipt',1432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1570.00,NULL,NULL,1,'2021-09-24 15:00:08','2021-09-28 17:55:34','2021-09-28 17:55:34'),(1466,3117,40846,12446,2,1433,'App\\Models\\Receipt',1433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1560.00,NULL,NULL,1,'2021-09-24 15:00:08','2021-09-28 17:55:22','2021-09-28 17:55:22'),(1467,3117,40846,12446,2,1434,'App\\Models\\Receipt',1434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1350.00,NULL,NULL,1,'2021-09-24 15:00:08','2021-09-28 17:55:10','2021-09-28 17:55:10'),(1468,3117,40846,12446,2,1435,'App\\Models\\Receipt',1435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1785.00,NULL,NULL,1,'2021-09-24 15:00:08','2021-09-28 17:54:57','2021-09-28 17:54:57'),(1469,3117,40846,12446,2,1436,'App\\Models\\Receipt',1436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',6620.00,NULL,NULL,1,'2021-09-24 15:00:08','2021-09-28 17:54:45','2021-09-28 17:54:45'),(1470,3117,40846,12446,2,1437,'App\\Models\\Receipt',1437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1785.00,NULL,NULL,1,'2021-09-24 15:00:08','2021-09-28 17:54:33','2021-09-28 17:54:33'),(1471,3117,40846,12446,2,1438,'App\\Models\\Receipt',1438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',4740.00,NULL,NULL,1,'2021-09-24 15:00:08','2021-09-28 17:54:19','2021-09-28 17:54:19'),(1472,3117,40846,12446,2,1439,'App\\Models\\Receipt',1439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',5410.00,NULL,NULL,1,'2021-09-24 15:00:08','2021-09-28 17:54:01','2021-09-28 17:54:01'),(1473,3117,40846,12446,2,1440,'App\\Models\\Receipt',1440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',3705.00,NULL,NULL,1,'2021-09-24 15:00:08','2021-09-28 17:53:44','2021-09-28 17:53:44'),(1474,3117,40846,12446,2,1441,'App\\Models\\Receipt',1441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',2337.00,NULL,NULL,1,'2021-09-24 15:00:08','2021-09-28 17:53:13','2021-09-28 17:53:13'),(1475,3117,40846,12446,2,1442,'App\\Models\\Receipt',1442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1475.00,NULL,NULL,1,'2021-09-24 15:00:08','2021-09-28 17:51:42','2021-09-28 17:51:42'),(1476,3117,40846,12446,2,1443,'App\\Models\\Receipt',1443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',2080.00,NULL,NULL,1,'2021-09-24 15:00:08','2021-09-28 17:51:31','2021-09-28 17:51:31'),(1477,3117,40846,12446,2,1444,'App\\Models\\Receipt',1444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',2915.00,NULL,NULL,1,'2021-09-24 15:00:08','2021-09-28 17:51:18','2021-09-28 17:51:18'),(1478,3117,40846,12446,2,1445,'App\\Models\\Receipt',1445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',2015.00,NULL,NULL,1,'2021-09-24 15:00:08','2021-09-28 17:51:05','2021-09-28 17:51:05'),(1479,3117,40846,12446,2,1446,'App\\Models\\Receipt',1446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',3171.00,NULL,NULL,1,'2021-09-24 15:00:08','2021-09-28 17:50:50','2021-09-28 17:50:50'),(1480,3117,40846,12446,2,1447,'App\\Models\\Receipt',1447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',3240.00,NULL,NULL,1,'2021-09-24 15:00:08','2021-09-28 17:50:15','2021-09-28 17:50:15'),(1481,3117,40846,12446,2,1448,'App\\Models\\Receipt',1448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',7400.00,NULL,NULL,1,'2021-09-24 15:00:09','2021-09-28 17:50:00','2021-09-28 17:50:00'),(1482,3117,40846,12446,2,1449,'App\\Models\\Receipt',1449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',2420.00,NULL,NULL,1,'2021-09-24 15:00:09','2021-09-28 17:48:27','2021-09-28 17:48:27');
INSERT INTO `balance_libro` VALUES (1483,3117,40846,12446,2,1450,'App\\Models\\Receipt',1450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',4650.00,NULL,NULL,1,'2021-09-24 15:00:09','2021-09-28 17:49:31','2021-09-28 17:49:31'),(1484,3117,40846,12446,2,1451,'App\\Models\\Receipt',1451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',2290.00,NULL,NULL,1,'2021-09-24 15:00:09','2021-09-28 17:49:20','2021-09-28 17:49:20'),(1485,3117,40846,12446,2,1452,'App\\Models\\Receipt',1452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',2855.00,NULL,NULL,1,'2021-09-24 15:00:09','2021-09-28 17:49:07','2021-09-28 17:49:07'),(1486,3117,40846,12446,2,1453,'App\\Models\\Receipt',1453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',4034.00,NULL,NULL,1,'2021-09-24 15:00:09','2021-09-28 17:48:10','2021-09-28 17:48:10'),(1487,3117,40846,12446,2,1454,'App\\Models\\Receipt',1454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',3210.00,NULL,NULL,1,'2021-09-24 15:00:09','2021-09-28 17:47:52','2021-09-28 17:47:52'),(1488,3117,40846,12446,2,1455,'App\\Models\\Receipt',1455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',2795.00,NULL,NULL,1,'2021-09-24 15:00:09','2021-09-28 17:47:36','2021-09-28 17:47:36'),(1489,3117,40846,12446,2,1456,'App\\Models\\Receipt',1456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',2180.00,NULL,NULL,1,'2021-09-24 15:00:09','2021-09-28 17:47:16','2021-09-28 17:47:16'),(1490,3117,40846,12446,2,1457,'App\\Models\\Receipt',1457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',4000.00,NULL,NULL,1,'2021-09-24 15:00:09','2021-09-28 17:46:57','2021-09-28 17:46:57'),(1491,3117,40846,12446,2,1458,'App\\Models\\Receipt',1458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',2383.00,NULL,NULL,1,'2021-09-24 15:00:09','2021-09-28 17:46:07','2021-09-28 17:46:07'),(1492,3117,40846,12446,2,1459,'App\\Models\\Receipt',1459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',3100.00,NULL,NULL,1,'2021-09-24 15:00:09','2021-09-28 17:45:48','2021-09-28 17:45:48'),(1493,3117,40846,12446,2,1460,'App\\Models\\Receipt',1460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',3826.00,NULL,NULL,1,'2021-09-24 15:00:09','2021-09-28 17:45:28','2021-09-28 17:45:28'),(1494,3117,40846,12446,2,1461,'App\\Models\\Receipt',1461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1590.00,NULL,NULL,1,'2021-09-24 15:00:09','2021-09-28 17:44:57','2021-09-28 17:44:57'),(1593,3117,40846,12447,3,1560,'App\\Models\\Receipt',1560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',6971.85,NULL,NULL,1,'2021-09-28 14:30:23','2021-09-28 14:30:23',NULL),(1594,3117,40846,12447,3,1561,'App\\Models\\Receipt',1561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',2080.35,NULL,NULL,1,'2021-09-28 14:30:23','2021-09-28 14:30:23',NULL),(1595,3117,40846,12447,3,1562,'App\\Models\\Receipt',1562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',0.00,NULL,NULL,1,'2021-09-28 14:30:24','2021-09-28 14:30:24',NULL),(1596,3117,40846,12447,3,1563,'App\\Models\\Receipt',1563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',294.45,NULL,NULL,1,'2021-09-28 14:30:24','2021-09-28 14:30:24',NULL),(1597,3117,40846,12447,3,1564,'App\\Models\\Receipt',1564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',5909.69,NULL,NULL,1,'2021-09-28 14:30:24','2021-09-28 14:30:24',NULL),(1598,3117,40846,12447,3,1565,'App\\Models\\Receipt',1565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',1467.09,NULL,NULL,1,'2021-09-28 14:30:24','2021-09-28 14:30:24',NULL),(1599,3117,40846,12447,3,1566,'App\\Models\\Receipt',1566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',1138.48,NULL,NULL,1,'2021-09-28 14:30:24','2021-09-28 14:30:24',NULL),(1600,3117,40846,12447,3,1567,'App\\Models\\Receipt',1567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-05','2021-08-05',1375.00,NULL,NULL,1,'2021-09-28 14:30:24','2021-09-28 14:30:24',NULL);
INSERT INTO `balance_libro` VALUES (1601,3117,40846,12447,3,1568,'App\\Models\\Receipt',1568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-05','2021-08-05',1692.00,NULL,NULL,1,'2021-09-28 14:30:24','2021-09-28 14:30:24',NULL),(1602,3117,40846,12447,3,1569,'App\\Models\\Receipt',1569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-06','2021-08-06',6115.26,NULL,NULL,1,'2021-09-28 14:30:24','2021-09-28 14:30:24',NULL),(1603,3117,40846,12447,3,1570,'App\\Models\\Receipt',1570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',11502.03,NULL,NULL,1,'2021-09-28 14:30:24','2021-09-28 14:30:24',NULL),(1604,3117,40846,12447,3,1571,'App\\Models\\Receipt',1571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',22316.26,NULL,NULL,1,'2021-09-28 14:30:24','2021-09-28 14:30:24',NULL),(1605,3117,40846,12447,3,1572,'App\\Models\\Receipt',1572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',6488.21,NULL,NULL,1,'2021-09-28 14:30:24','2021-09-28 14:30:24',NULL),(1606,3117,40846,12447,3,1573,'App\\Models\\Receipt',1573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',1198.05,NULL,NULL,1,'2021-09-28 14:30:24','2021-09-28 14:30:24',NULL),(1607,3117,40846,12447,3,1574,'App\\Models\\Receipt',1574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',25239.96,NULL,NULL,1,'2021-09-28 14:30:24','2021-09-28 14:30:24',NULL),(1608,3117,40846,12447,3,1575,'App\\Models\\Receipt',1575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',5361.62,NULL,NULL,1,'2021-09-28 14:30:24','2021-09-28 14:30:24',NULL),(1609,3117,40846,12447,3,1576,'App\\Models\\Receipt',1576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',3907.76,NULL,NULL,1,'2021-09-28 14:30:24','2021-09-28 14:30:24',NULL),(1610,3117,40846,12447,3,1577,'App\\Models\\Receipt',1577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',9782.01,NULL,NULL,1,'2021-09-28 14:30:24','2021-09-28 14:30:24',NULL),(1611,3117,40846,12447,3,1578,'App\\Models\\Receipt',1578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',7576.71,NULL,NULL,1,'2021-09-28 14:30:24','2021-09-28 14:30:24',NULL),(1612,3117,40846,12447,3,1579,'App\\Models\\Receipt',1579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',2921.61,NULL,NULL,1,'2021-09-28 14:30:24','2021-09-28 14:30:24',NULL),(1613,3117,40846,12447,3,1580,'App\\Models\\Receipt',1580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',5070.00,NULL,NULL,1,'2021-09-28 14:30:24','2021-09-28 14:30:24',NULL),(1614,3117,40846,12447,3,1581,'App\\Models\\Receipt',1581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',9297.60,NULL,NULL,1,'2021-09-28 14:30:24','2021-09-28 14:30:24',NULL),(1615,3117,40846,12447,3,1582,'App\\Models\\Receipt',1582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-17','2021-08-17',6455.46,NULL,NULL,1,'2021-09-28 14:30:24','2021-09-28 14:30:24',NULL),(1616,3117,40846,12447,3,1583,'App\\Models\\Receipt',1583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',2990.97,NULL,NULL,1,'2021-09-28 14:30:24','2021-09-28 14:30:24',NULL),(1617,3117,40846,12447,3,1584,'App\\Models\\Receipt',1584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',1830.74,NULL,NULL,1,'2021-09-28 14:30:24','2021-09-28 14:30:24',NULL),(1618,3117,40846,12447,3,1585,'App\\Models\\Receipt',1585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',6622.63,NULL,NULL,1,'2021-09-28 14:30:24','2021-09-28 14:30:24',NULL),(1619,3117,40846,12447,3,1586,'App\\Models\\Receipt',1586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',30213.73,NULL,NULL,1,'2021-09-28 14:30:24','2021-09-28 14:30:24',NULL),(1620,3117,40846,12447,3,1587,'App\\Models\\Receipt',1587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',7989.81,NULL,NULL,1,'2021-09-28 14:30:24','2021-09-28 14:30:24',NULL),(1621,3117,40846,12447,3,1588,'App\\Models\\Receipt',1588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',10509.85,NULL,NULL,1,'2021-09-28 14:30:24','2021-09-28 14:30:24',NULL);
INSERT INTO `balance_libro` VALUES (1622,3117,40846,12447,3,1589,'App\\Models\\Receipt',1589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-21','2021-08-21',9935.31,NULL,NULL,1,'2021-09-28 14:30:24','2021-09-28 14:30:24',NULL),(1623,3117,40846,12447,3,1590,'App\\Models\\Receipt',1590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-24','2021-08-24',13489.71,NULL,NULL,1,'2021-09-28 14:30:25','2021-09-28 14:30:25',NULL),(1624,3117,40846,12447,3,1591,'App\\Models\\Receipt',1591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-24','2021-08-24',20356.44,NULL,NULL,1,'2021-09-28 14:30:25','2021-09-28 14:30:25',NULL),(1625,3117,40846,12447,3,1592,'App\\Models\\Receipt',1592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',8317.60,NULL,NULL,1,'2021-09-28 14:30:25','2021-09-28 14:30:25',NULL),(1626,3117,40846,12447,3,1593,'App\\Models\\Receipt',1593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',2246.24,NULL,NULL,1,'2021-09-28 14:30:25','2021-09-28 14:30:25',NULL),(1627,3117,40846,12447,3,1594,'App\\Models\\Receipt',1594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',6316.01,NULL,NULL,1,'2021-09-28 14:30:25','2021-09-28 14:30:25',NULL),(1628,3117,40846,12447,3,1595,'App\\Models\\Receipt',1595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',6952.19,NULL,NULL,1,'2021-09-28 14:30:25','2021-09-28 14:30:25',NULL),(1629,3117,40846,12447,3,1596,'App\\Models\\Receipt',1596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',4049.99,NULL,NULL,1,'2021-09-28 14:30:25','2021-09-28 14:30:25',NULL),(1630,3117,40846,12447,3,1597,'App\\Models\\Receipt',1597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',6706.50,NULL,NULL,1,'2021-09-28 14:30:25','2021-09-28 14:30:25',NULL),(1631,3117,40846,12447,3,1598,'App\\Models\\Receipt',1598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',348.00,NULL,NULL,1,'2021-09-28 14:30:25','2021-09-28 14:30:25',NULL),(1632,3117,40846,12447,3,1599,'App\\Models\\Receipt',1599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',6187.82,NULL,NULL,1,'2021-09-28 14:30:25','2021-09-28 14:30:25',NULL),(1633,3117,40846,12447,3,1600,'App\\Models\\Receipt',1600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',167.62,NULL,NULL,1,'2021-09-28 14:30:25','2021-09-28 14:30:25',NULL),(1634,3117,40846,12447,3,1601,'App\\Models\\Receipt',1601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',6183.06,NULL,NULL,1,'2021-09-28 14:30:25','2021-09-28 14:30:25',NULL),(1635,3117,40846,12447,2,1602,'App\\Models\\Receipt',1602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',1219.00,NULL,NULL,1,'2021-09-28 14:30:52','2021-09-28 14:30:52',NULL),(1636,3117,40846,12447,2,1603,'App\\Models\\Receipt',1603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',2570.00,NULL,NULL,1,'2021-09-28 14:30:52','2021-09-28 14:30:52',NULL),(1637,3117,40846,12447,2,1604,'App\\Models\\Receipt',1604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',3490.00,NULL,NULL,1,'2021-09-28 14:30:52','2021-09-28 14:30:52',NULL),(1638,3117,40846,12447,2,1605,'App\\Models\\Receipt',1605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',2310.00,NULL,NULL,1,'2021-09-28 14:30:52','2021-09-28 14:30:52',NULL),(1639,3117,40846,12447,2,1606,'App\\Models\\Receipt',1606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',2520.00,NULL,NULL,1,'2021-09-28 14:30:52','2021-09-28 14:30:52',NULL),(1640,3117,40846,12447,2,1607,'App\\Models\\Receipt',1607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',1000.00,NULL,NULL,1,'2021-09-28 14:30:52','2021-09-28 14:30:52',NULL),(1641,3117,40846,12447,2,1608,'App\\Models\\Receipt',1608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',6000.00,NULL,NULL,1,'2021-09-28 14:30:52','2021-09-28 14:30:52',NULL),(1642,3117,40846,12447,2,1609,'App\\Models\\Receipt',1609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',1537.00,NULL,NULL,1,'2021-09-28 14:30:52','2021-09-28 14:30:52',NULL);
INSERT INTO `balance_libro` VALUES (1643,3117,40846,12447,2,1610,'App\\Models\\Receipt',1610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',2260.00,NULL,NULL,1,'2021-09-28 14:30:52','2021-09-28 14:30:52',NULL),(1644,3117,40846,12447,2,1611,'App\\Models\\Receipt',1611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',3460.00,NULL,NULL,1,'2021-09-28 14:30:52','2021-09-28 14:30:52',NULL),(1645,3117,40846,12447,2,1612,'App\\Models\\Receipt',1612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',1145.00,NULL,NULL,1,'2021-09-28 14:30:52','2021-09-28 14:30:52',NULL),(1646,3117,40846,12447,2,1613,'App\\Models\\Receipt',1613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',5000.00,NULL,NULL,1,'2021-09-28 14:30:52','2021-09-28 14:30:52',NULL),(1647,3117,40846,12447,2,1614,'App\\Models\\Receipt',1614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',5000.00,NULL,NULL,1,'2021-09-28 14:30:52','2021-09-28 14:30:52',NULL),(1648,3117,40846,12447,2,1615,'App\\Models\\Receipt',1615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',6000.00,NULL,NULL,1,'2021-09-28 14:30:52','2021-09-28 14:30:52',NULL),(1649,3117,40846,12447,2,1616,'App\\Models\\Receipt',1616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',6000.00,NULL,NULL,1,'2021-09-28 14:30:53','2021-09-28 14:30:53',NULL),(1650,3117,40846,12447,2,1617,'App\\Models\\Receipt',1617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',4500.00,NULL,NULL,1,'2021-09-28 14:30:53','2021-09-28 14:30:53',NULL),(1651,3117,40846,12447,2,1618,'App\\Models\\Receipt',1618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',4500.00,NULL,NULL,1,'2021-09-28 14:30:53','2021-09-28 14:30:53',NULL),(1652,3117,40846,12447,2,1619,'App\\Models\\Receipt',1619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',5000.00,NULL,NULL,1,'2021-09-28 14:30:53','2021-09-28 14:30:53',NULL),(1653,3117,40846,12447,2,1620,'App\\Models\\Receipt',1620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',4000.00,NULL,NULL,1,'2021-09-28 14:30:53','2021-09-28 14:30:53',NULL),(1654,3117,40846,12447,2,1621,'App\\Models\\Receipt',1621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',1070.00,NULL,NULL,1,'2021-09-28 14:30:53','2021-09-28 14:30:53',NULL),(1655,3117,40846,12447,2,1622,'App\\Models\\Receipt',1622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',5000.00,NULL,NULL,1,'2021-09-28 14:30:53','2021-09-28 14:30:53',NULL),(1656,3117,40846,12447,2,1623,'App\\Models\\Receipt',1623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',5000.00,NULL,NULL,1,'2021-09-28 14:30:53','2021-09-28 14:30:53',NULL),(1657,3117,40846,12447,2,1624,'App\\Models\\Receipt',1624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',5630.00,NULL,NULL,1,'2021-09-28 14:30:53','2021-09-28 14:30:53',NULL),(1658,3117,40846,12447,2,1625,'App\\Models\\Receipt',1625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',5000.00,NULL,NULL,1,'2021-09-28 14:30:53','2021-09-28 14:30:53',NULL),(1659,3117,40846,12447,2,1626,'App\\Models\\Receipt',1626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',1928.00,NULL,NULL,1,'2021-09-28 14:30:53','2021-09-28 14:30:53',NULL),(1660,3117,40846,12447,2,1627,'App\\Models\\Receipt',1627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',1736.00,NULL,NULL,1,'2021-09-28 14:30:53','2021-09-28 14:30:53',NULL),(1661,3117,40846,12447,2,1628,'App\\Models\\Receipt',1628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',2725.00,NULL,NULL,1,'2021-09-28 14:30:53','2021-09-28 14:30:53',NULL),(1662,3117,40846,12447,2,1629,'App\\Models\\Receipt',1629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',3370.00,NULL,NULL,1,'2021-09-28 14:30:53','2021-09-28 14:30:53',NULL),(1663,3117,40846,12447,2,1630,'App\\Models\\Receipt',1630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',1070.00,NULL,NULL,1,'2021-09-28 14:30:53','2021-09-28 14:30:53',NULL);
INSERT INTO `balance_libro` VALUES (1664,3117,40846,12447,2,1631,'App\\Models\\Receipt',1631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',2060.00,NULL,NULL,1,'2021-09-28 14:30:53','2021-09-28 14:30:53',NULL),(1665,3117,40846,12447,2,1632,'App\\Models\\Receipt',1632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',2715.00,NULL,NULL,1,'2021-09-28 14:30:53','2021-09-28 14:30:53',NULL),(1666,3117,40846,12447,2,1633,'App\\Models\\Receipt',1633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',2600.00,NULL,NULL,1,'2021-09-28 14:30:53','2021-09-28 14:30:53',NULL),(1667,3117,40846,12447,2,1634,'App\\Models\\Receipt',1634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',1645.00,NULL,NULL,1,'2021-09-28 14:30:53','2021-09-28 14:30:53',NULL),(1668,3117,40846,12447,2,1635,'App\\Models\\Receipt',1635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',2870.00,NULL,NULL,1,'2021-09-28 14:30:53','2021-09-28 14:30:53',NULL),(1669,3117,40846,12447,2,1636,'App\\Models\\Receipt',1636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',6000.00,NULL,NULL,1,'2021-09-28 14:30:53','2021-09-28 14:30:53',NULL),(1670,3117,40846,12447,2,1637,'App\\Models\\Receipt',1637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',1360.00,NULL,NULL,1,'2021-09-28 14:30:53','2021-09-28 14:30:53',NULL),(1671,3117,40846,12447,2,1638,'App\\Models\\Receipt',1638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',1700.00,NULL,NULL,1,'2021-09-28 14:30:53','2021-09-28 14:30:53',NULL),(1672,3117,40846,12447,2,1639,'App\\Models\\Receipt',1639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',1070.00,NULL,NULL,1,'2021-09-28 14:30:53','2021-09-28 14:30:53',NULL),(1673,3117,40846,12447,2,1640,'App\\Models\\Receipt',1640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',510.00,NULL,NULL,1,'2021-09-28 14:30:53','2021-09-28 14:30:53',NULL),(1674,3117,40846,12447,2,1641,'App\\Models\\Receipt',1641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',1440.00,NULL,NULL,1,'2021-09-28 14:30:53','2021-09-28 14:30:53',NULL),(1675,3117,40846,12447,2,1642,'App\\Models\\Receipt',1642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',590.00,NULL,NULL,1,'2021-09-28 14:30:53','2021-09-28 14:30:53',NULL),(1676,3117,40846,12447,2,1643,'App\\Models\\Receipt',1643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',1080.00,NULL,NULL,1,'2021-09-28 14:30:53','2021-09-28 14:30:53',NULL),(1677,3117,40846,12447,2,1644,'App\\Models\\Receipt',1644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',4800.00,NULL,NULL,1,'2021-09-28 14:30:53','2021-09-28 14:30:53',NULL),(1678,3117,40846,12447,2,1645,'App\\Models\\Receipt',1645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',1380.00,NULL,NULL,1,'2021-09-28 14:30:54','2021-09-28 14:30:54',NULL),(1679,3117,40846,12447,2,1646,'App\\Models\\Receipt',1646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',1680.00,NULL,NULL,1,'2021-09-28 14:30:54','2021-09-28 14:30:54',NULL),(1680,3117,40846,12447,2,1647,'App\\Models\\Receipt',1647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',1155.00,NULL,NULL,1,'2021-09-28 14:30:54','2021-09-28 14:30:54',NULL),(1681,3117,40846,12447,2,1648,'App\\Models\\Receipt',1648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',1040.00,NULL,NULL,1,'2021-09-28 14:30:54','2021-09-28 14:30:54',NULL),(1682,3117,40846,12447,2,1649,'App\\Models\\Receipt',1649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',1592.00,NULL,NULL,1,'2021-09-28 14:30:54','2021-09-28 14:30:54',NULL),(1683,3117,40846,12447,2,1650,'App\\Models\\Receipt',1650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',1165.00,NULL,NULL,1,'2021-09-28 14:30:54','2021-09-28 14:30:54',NULL),(1684,3117,40846,12447,2,1651,'App\\Models\\Receipt',1651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',2170.00,NULL,NULL,1,'2021-09-28 14:30:54','2021-09-28 14:30:54',NULL);
INSERT INTO `balance_libro` VALUES (1685,3117,40846,12447,2,1652,'App\\Models\\Receipt',1652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',1192.00,NULL,NULL,1,'2021-09-28 14:30:54','2021-09-28 14:30:54',NULL),(1686,3117,40846,12447,2,1653,'App\\Models\\Receipt',1653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',1670.00,NULL,NULL,1,'2021-09-28 14:30:54','2021-09-28 14:30:54',NULL),(1687,3117,40846,12447,2,1654,'App\\Models\\Receipt',1654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',1550.00,NULL,NULL,1,'2021-09-28 14:30:54','2021-09-28 14:30:54',NULL),(1688,3117,40846,12447,2,1655,'App\\Models\\Receipt',1655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',1970.00,NULL,NULL,1,'2021-09-28 14:30:54','2021-09-28 14:30:54',NULL),(1689,3117,40846,12447,2,1656,'App\\Models\\Receipt',1656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',960.00,NULL,NULL,1,'2021-09-28 14:30:54','2021-09-28 14:30:54',NULL),(1690,3117,40846,12447,2,1657,'App\\Models\\Receipt',1657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',1660.00,NULL,NULL,1,'2021-09-28 14:30:54','2021-09-28 14:30:54',NULL),(1691,3117,40846,12447,2,1658,'App\\Models\\Receipt',1658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',1385.00,NULL,NULL,1,'2021-09-28 14:30:54','2021-09-28 14:30:54',NULL),(1692,3117,40846,12447,2,1659,'App\\Models\\Receipt',1659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',960.00,NULL,NULL,1,'2021-09-28 14:30:54','2021-09-28 14:30:54',NULL),(1693,3117,40846,12447,2,1660,'App\\Models\\Receipt',1660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',1160.00,NULL,NULL,1,'2021-09-28 14:30:54','2021-09-28 14:30:54',NULL),(1694,3117,40846,12447,2,1661,'App\\Models\\Receipt',1661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',1375.00,NULL,NULL,1,'2021-09-28 14:30:54','2021-09-28 14:30:54',NULL),(1695,3117,40846,12447,2,1662,'App\\Models\\Receipt',1662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',2100.00,NULL,NULL,1,'2021-09-28 14:30:54','2021-09-28 14:30:54',NULL),(1696,3117,40846,12447,2,1663,'App\\Models\\Receipt',1663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',700.00,NULL,NULL,1,'2021-09-28 14:30:54','2021-09-28 14:30:54',NULL),(1697,3117,40846,12447,2,1664,'App\\Models\\Receipt',1664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',2500.00,NULL,NULL,1,'2021-09-28 14:30:54','2021-09-28 14:30:54',NULL),(1698,3117,40846,12447,2,1665,'App\\Models\\Receipt',1665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',1970.00,NULL,NULL,1,'2021-09-28 14:30:54','2021-09-28 14:30:54',NULL),(1699,3117,40846,12447,2,1666,'App\\Models\\Receipt',1666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',1285.00,NULL,NULL,1,'2021-09-28 14:30:54','2021-09-28 14:30:54',NULL),(1700,3117,40846,12447,2,1667,'App\\Models\\Receipt',1667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',1070.00,NULL,NULL,1,'2021-09-28 14:30:54','2021-09-28 14:30:54',NULL),(1701,3117,40846,12447,2,1668,'App\\Models\\Receipt',1668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',1730.00,NULL,NULL,1,'2021-09-28 14:30:54','2021-09-28 14:30:54',NULL),(1702,3117,40846,12447,2,1669,'App\\Models\\Receipt',1669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',3030.00,NULL,NULL,1,'2021-09-28 14:30:54','2021-09-28 14:30:54',NULL),(1703,3117,40846,12447,2,1670,'App\\Models\\Receipt',1670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',6000.00,NULL,NULL,1,'2021-09-28 14:30:54','2021-09-28 14:30:54',NULL),(1704,3117,40846,12447,2,1671,'App\\Models\\Receipt',1671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',6000.00,NULL,NULL,1,'2021-09-28 14:30:54','2021-09-28 14:30:54',NULL),(1705,3117,40846,12447,2,1672,'App\\Models\\Receipt',1672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',1825.00,NULL,NULL,1,'2021-09-28 14:30:55','2021-09-28 14:30:55',NULL);
INSERT INTO `balance_libro` VALUES (1706,3117,40846,12447,2,1673,'App\\Models\\Receipt',1673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',495.00,NULL,NULL,1,'2021-09-28 14:30:55','2021-09-28 14:30:55',NULL),(1707,3117,40846,12447,2,1674,'App\\Models\\Receipt',1674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',6900.00,NULL,NULL,1,'2021-09-28 14:30:55','2021-09-28 14:30:55',NULL),(1708,3117,40846,12447,2,1675,'App\\Models\\Receipt',1675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',1590.00,NULL,NULL,1,'2021-09-28 14:30:55','2021-09-28 14:30:55',NULL),(1709,3117,40846,12447,2,1676,'App\\Models\\Receipt',1676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',1225.00,NULL,NULL,1,'2021-09-28 14:30:55','2021-09-28 14:30:55',NULL),(1710,3117,40846,12447,2,1677,'App\\Models\\Receipt',1677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',1615.00,NULL,NULL,1,'2021-09-28 14:30:55','2021-09-28 14:30:55',NULL),(1711,3117,40846,12447,2,1678,'App\\Models\\Receipt',1678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',2030.00,NULL,NULL,1,'2021-09-28 14:30:55','2021-09-28 14:30:55',NULL),(1712,3117,40846,12447,2,1679,'App\\Models\\Receipt',1679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',1370.00,NULL,NULL,1,'2021-09-28 14:30:55','2021-09-28 14:30:55',NULL),(1713,3117,40846,12447,2,1680,'App\\Models\\Receipt',1680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',1300.00,NULL,NULL,1,'2021-09-28 14:30:55','2021-09-28 14:30:55',NULL),(1714,3117,40846,12447,2,1681,'App\\Models\\Receipt',1681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',1550.00,NULL,NULL,1,'2021-09-28 14:30:55','2021-09-28 14:30:55',NULL),(1715,3117,40846,12447,2,1682,'App\\Models\\Receipt',1682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',4500.00,NULL,NULL,1,'2021-09-28 14:30:55','2021-09-28 14:30:55',NULL),(1716,3117,40846,12447,2,1683,'App\\Models\\Receipt',1683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',1660.00,NULL,NULL,1,'2021-09-28 14:30:55','2021-09-28 14:30:55',NULL),(1717,3117,40846,12447,2,1684,'App\\Models\\Receipt',1684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',1300.00,NULL,NULL,1,'2021-09-28 14:30:55','2021-09-28 14:30:55',NULL),(1718,3117,40846,12447,2,1685,'App\\Models\\Receipt',1685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',1160.00,NULL,NULL,1,'2021-09-28 14:30:55','2021-09-28 14:30:55',NULL),(1719,3117,40846,12447,2,1686,'App\\Models\\Receipt',1686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',2400.00,NULL,NULL,1,'2021-09-28 14:30:55','2021-09-28 14:30:55',NULL),(1720,3117,40846,12447,2,1687,'App\\Models\\Receipt',1687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',1860.00,NULL,NULL,1,'2021-09-28 14:30:55','2021-09-28 14:30:55',NULL),(1721,3117,40846,12447,2,1688,'App\\Models\\Receipt',1688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',5405.00,NULL,NULL,1,'2021-09-28 14:30:55','2021-09-28 14:30:55',NULL),(1722,3117,40846,12447,2,1689,'App\\Models\\Receipt',1689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',2530.00,NULL,NULL,1,'2021-09-28 14:30:55','2021-09-28 14:30:55',NULL),(1723,3117,40846,12447,2,1690,'App\\Models\\Receipt',1690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',2330.00,NULL,NULL,1,'2021-09-28 14:30:55','2021-09-28 14:30:55',NULL),(1724,3117,40846,12447,2,1691,'App\\Models\\Receipt',1691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',3380.00,NULL,NULL,1,'2021-09-28 14:30:55','2021-09-28 14:30:55',NULL),(1725,3117,40846,12447,2,1692,'App\\Models\\Receipt',1692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',4740.00,NULL,NULL,1,'2021-09-28 14:30:55','2021-09-28 14:30:55',NULL),(1726,3117,40846,12447,2,1693,'App\\Models\\Receipt',1693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',1200.00,NULL,NULL,1,'2021-09-28 14:30:55','2021-09-28 14:30:55',NULL);
INSERT INTO `balance_libro` VALUES (1727,3117,40846,12447,2,1694,'App\\Models\\Receipt',1694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',1180.00,NULL,NULL,1,'2021-09-28 14:30:55','2021-09-28 14:30:55',NULL),(1728,3117,40846,12447,2,1695,'App\\Models\\Receipt',1695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',1070.00,NULL,NULL,1,'2021-09-28 14:30:55','2021-09-28 14:30:55',NULL),(1729,3117,40846,12447,2,1696,'App\\Models\\Receipt',1696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',1410.00,NULL,NULL,1,'2021-09-28 14:30:55','2021-09-28 14:30:55',NULL),(1730,3117,40846,12447,2,1697,'App\\Models\\Receipt',1697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',3788.00,NULL,NULL,1,'2021-09-28 14:30:55','2021-09-28 14:30:55',NULL),(1731,3117,40846,12447,2,1698,'App\\Models\\Receipt',1698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',2370.00,NULL,NULL,1,'2021-09-28 14:30:55','2021-09-28 14:30:55',NULL),(1732,3117,40846,12447,2,1699,'App\\Models\\Receipt',1699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',1215.00,NULL,NULL,1,'2021-09-28 14:30:55','2021-09-28 14:30:55',NULL),(1733,3117,40846,12447,2,1700,'App\\Models\\Receipt',1700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2021-09-28 14:30:55','2021-09-28 17:46:34','2021-09-28 17:46:34'),(1734,3117,40846,12446,3,1701,'App\\Models\\Receipt',1701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',2707.67,NULL,NULL,1,'2021-09-28 17:36:06','2021-09-28 17:36:06',NULL),(1735,3117,40846,12446,3,1702,'App\\Models\\Receipt',1702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',17579.15,NULL,NULL,1,'2021-09-28 17:36:06','2021-09-28 17:36:06',NULL),(1736,3117,40846,12446,3,1703,'App\\Models\\Receipt',1703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',12450.53,NULL,NULL,1,'2021-09-28 17:36:06','2021-09-28 17:36:06',NULL),(1737,3117,40846,12446,3,1704,'App\\Models\\Receipt',1704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',4056.00,NULL,NULL,1,'2021-09-28 17:36:06','2021-09-28 17:36:06',NULL),(1738,3117,40846,12446,3,1705,'App\\Models\\Receipt',1705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',1375.00,NULL,NULL,1,'2021-09-28 17:36:06','2021-09-28 17:36:06',NULL),(1739,3117,40846,12446,3,1706,'App\\Models\\Receipt',1706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',1422.89,NULL,NULL,1,'2021-09-28 17:36:06','2021-09-28 17:36:06',NULL),(1740,3117,40846,12446,3,1707,'App\\Models\\Receipt',1707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',9621.49,NULL,NULL,1,'2021-09-28 17:36:06','2021-09-28 17:36:06',NULL),(1741,3117,40846,12446,3,1708,'App\\Models\\Receipt',1708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',10033.35,NULL,NULL,1,'2021-09-28 17:36:06','2021-09-28 17:36:06',NULL),(1742,3117,40846,12446,3,1709,'App\\Models\\Receipt',1709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',5063.20,NULL,NULL,1,'2021-09-28 17:36:06','2021-09-28 17:36:06',NULL),(1743,3117,40846,12446,3,1710,'App\\Models\\Receipt',1710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',8163.87,NULL,NULL,1,'2021-09-28 17:36:06','2021-09-28 17:36:06',NULL),(1744,3117,40846,12446,3,1711,'App\\Models\\Receipt',1711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',7779.26,NULL,NULL,1,'2021-09-28 17:36:06','2021-09-28 17:36:06',NULL),(1745,3117,40846,12446,3,1712,'App\\Models\\Receipt',1712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',2002.20,NULL,NULL,1,'2021-09-28 17:36:06','2021-09-28 17:36:06',NULL),(1746,3117,40846,12446,3,1713,'App\\Models\\Receipt',1713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',2430.82,NULL,NULL,1,'2021-09-28 17:36:06','2021-09-28 17:36:06',NULL),(1747,3117,40846,12446,3,1714,'App\\Models\\Receipt',1714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',673.91,NULL,NULL,1,'2021-09-28 17:36:06','2021-09-28 17:36:06',NULL);
INSERT INTO `balance_libro` VALUES (1748,3117,40846,12446,3,1715,'App\\Models\\Receipt',1715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',1776.04,NULL,NULL,1,'2021-09-28 17:36:06','2021-09-28 17:36:06',NULL),(1749,3117,40846,12446,3,1716,'App\\Models\\Receipt',1716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',16531.92,NULL,NULL,1,'2021-09-28 17:36:06','2021-09-28 17:36:06',NULL),(1750,3117,40846,12446,3,1717,'App\\Models\\Receipt',1717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',7625.81,NULL,NULL,1,'2021-09-28 17:36:06','2021-09-28 17:36:06',NULL),(1751,3117,40846,12446,3,1718,'App\\Models\\Receipt',1718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',4046.70,NULL,NULL,1,'2021-09-28 17:36:06','2021-09-28 17:36:06',NULL),(1752,3117,40846,12446,3,1719,'App\\Models\\Receipt',1719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',4319.99,NULL,NULL,1,'2021-09-28 17:36:06','2021-09-28 17:36:06',NULL),(1753,3117,40846,12446,3,1720,'App\\Models\\Receipt',1720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',1497.10,NULL,NULL,1,'2021-09-28 17:36:06','2021-09-28 17:36:06',NULL),(1754,3117,40846,12446,3,1721,'App\\Models\\Receipt',1721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',14923.43,NULL,NULL,1,'2021-09-28 17:36:06','2021-09-28 17:36:06',NULL),(1755,3117,40846,12446,3,1722,'App\\Models\\Receipt',1722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',15001.36,NULL,NULL,1,'2021-09-28 17:36:06','2021-09-28 17:36:06',NULL),(1756,3117,40846,12446,3,1723,'App\\Models\\Receipt',1723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',11132.99,NULL,NULL,1,'2021-09-28 17:36:06','2021-09-28 17:36:06',NULL),(1757,3117,40846,12446,3,1724,'App\\Models\\Receipt',1724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',6507.67,NULL,NULL,1,'2021-09-28 17:36:06','2021-09-28 17:36:06',NULL),(1758,3117,40846,12446,3,1725,'App\\Models\\Receipt',1725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',5919.16,NULL,NULL,1,'2021-09-28 17:36:06','2021-09-28 17:36:06',NULL),(1759,3117,40846,12446,3,1726,'App\\Models\\Receipt',1726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',175.50,NULL,NULL,1,'2021-09-28 17:36:07','2021-09-28 17:36:07',NULL),(1760,3117,40846,12446,3,1727,'App\\Models\\Receipt',1727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',4807.72,NULL,NULL,1,'2021-09-28 17:36:07','2021-09-28 17:36:07',NULL),(1761,3117,40846,12446,3,1728,'App\\Models\\Receipt',1728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',821.11,NULL,NULL,1,'2021-09-28 17:36:07','2021-09-28 17:36:07',NULL),(1762,3117,40846,12446,3,1729,'App\\Models\\Receipt',1729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',12658.54,NULL,NULL,1,'2021-09-28 17:36:07','2021-09-28 17:36:07',NULL),(1763,3117,40846,12446,3,1730,'App\\Models\\Receipt',1730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',6688.92,NULL,NULL,1,'2021-09-28 17:36:07','2021-09-28 17:36:07',NULL),(1764,3117,40846,12446,3,1731,'App\\Models\\Receipt',1731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',1843.46,NULL,NULL,1,'2021-09-28 17:36:07','2021-09-28 17:36:07',NULL),(1765,3117,40846,12446,3,1732,'App\\Models\\Receipt',1732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',1118.91,NULL,NULL,1,'2021-09-28 17:36:07','2021-09-28 17:36:07',NULL),(1766,3117,40846,12446,3,1733,'App\\Models\\Receipt',1733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',3592.70,NULL,NULL,1,'2021-09-28 17:36:07','2021-09-28 17:36:07',NULL),(1767,3117,40846,12446,3,1734,'App\\Models\\Receipt',1734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',2296.05,NULL,NULL,1,'2021-09-28 17:36:07','2021-09-28 17:36:07',NULL),(1768,3117,40846,12446,3,1735,'App\\Models\\Receipt',1735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',23669.88,NULL,NULL,1,'2021-09-28 17:36:07','2021-09-28 17:36:07',NULL);
INSERT INTO `balance_libro` VALUES (1769,3117,40846,12446,3,1736,'App\\Models\\Receipt',1736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',5120.44,NULL,NULL,1,'2021-09-28 17:36:07','2021-09-28 17:36:07',NULL),(1770,3117,40846,12446,3,1737,'App\\Models\\Receipt',1737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',1377.34,NULL,NULL,1,'2021-09-28 17:36:07','2021-09-28 17:36:07',NULL),(1771,3117,40846,12446,3,1738,'App\\Models\\Receipt',1738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',1400.03,NULL,NULL,1,'2021-09-28 17:36:07','2021-09-28 17:36:07',NULL),(1772,3117,40846,12446,3,1739,'App\\Models\\Receipt',1739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',2268.52,NULL,NULL,1,'2021-09-28 17:36:07','2021-09-28 17:36:07',NULL),(1773,3117,40846,12446,3,1740,'App\\Models\\Receipt',1740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',11440.60,NULL,NULL,1,'2021-09-28 17:36:07','2021-09-28 17:36:07',NULL),(1774,3117,40846,12446,3,1741,'App\\Models\\Receipt',1741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',10694.52,NULL,NULL,1,'2021-09-28 17:36:07','2021-09-28 17:36:07',NULL),(1775,3117,40846,12446,3,1742,'App\\Models\\Receipt',1742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',12000.32,NULL,NULL,1,'2021-09-28 17:36:07','2021-09-28 17:36:07',NULL),(1776,3117,40846,12446,3,1743,'App\\Models\\Receipt',1743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',2470.00,NULL,NULL,1,'2021-09-28 17:36:07','2021-09-28 17:36:07',NULL),(1777,3117,40846,12446,3,1744,'App\\Models\\Receipt',1744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',13914.49,NULL,NULL,1,'2021-09-28 17:36:07','2021-09-28 17:36:07',NULL),(1778,3117,40846,12446,3,1745,'App\\Models\\Receipt',1745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',12945.09,NULL,NULL,1,'2021-09-28 17:36:07','2021-09-28 17:36:07',NULL),(1779,3117,40846,12446,3,1746,'App\\Models\\Receipt',1746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',9608.89,NULL,NULL,1,'2021-09-28 17:36:07','2021-09-28 17:36:07',NULL),(1780,3117,40846,12446,3,1747,'App\\Models\\Receipt',1747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',12226.80,NULL,NULL,1,'2021-09-28 17:36:07','2021-09-28 17:36:07',NULL),(1781,3117,40846,12446,3,1748,'App\\Models\\Receipt',1748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',5778.33,NULL,NULL,1,'2021-09-28 17:36:07','2021-09-28 17:36:07',NULL),(1782,3117,40846,12446,3,1749,'App\\Models\\Receipt',1749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',4582.63,NULL,NULL,1,'2021-09-28 17:36:07','2021-09-28 17:36:07',NULL),(1783,3117,40846,12446,3,1750,'App\\Models\\Receipt',1750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',2584.61,NULL,NULL,1,'2021-09-28 17:36:07','2021-09-28 17:36:07',NULL),(1784,3117,40846,12446,3,1751,'App\\Models\\Receipt',1751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',11701.92,NULL,NULL,1,'2021-09-28 17:36:08','2021-09-28 17:36:08',NULL),(1785,3117,40846,12446,3,1752,'App\\Models\\Receipt',1752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1118.91,NULL,NULL,1,'2021-09-28 17:36:08','2021-09-28 17:36:08',NULL),(1786,3117,40846,12446,3,1753,'App\\Models\\Receipt',1753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',85.00,NULL,NULL,1,'2021-09-28 17:36:08','2021-09-28 17:36:08',NULL),(1787,3117,40846,12446,3,1754,'App\\Models\\Receipt',1754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',336.00,NULL,NULL,1,'2021-09-28 17:36:08','2021-09-28 17:36:08',NULL),(1788,3117,40846,12445,2,1338,'App\\Models\\Receipt',1338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2575.00,NULL,NULL,1,'2021-09-28 17:44:32','2021-09-28 17:44:32',NULL),(1789,3117,40846,12444,2,1461,'App\\Models\\Receipt',1461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1590.00,NULL,NULL,1,'2021-09-28 17:44:57','2021-09-28 17:44:57',NULL);
INSERT INTO `balance_libro` VALUES (1790,3117,40846,12444,2,1460,'App\\Models\\Receipt',1460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',3826.00,NULL,NULL,1,'2021-09-28 17:45:28','2021-09-28 17:45:28',NULL),(1791,3117,40846,12444,2,1459,'App\\Models\\Receipt',1459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',3100.00,NULL,NULL,1,'2021-09-28 17:45:48','2021-09-28 17:45:48',NULL),(1792,3117,40846,12444,2,1458,'App\\Models\\Receipt',1458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',2383.00,NULL,NULL,1,'2021-09-28 17:46:07','2021-09-28 17:46:07',NULL),(1793,3117,40846,12444,2,1457,'App\\Models\\Receipt',1457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',4000.00,NULL,NULL,1,'2021-09-28 17:46:57','2021-09-28 17:46:57',NULL),(1794,3117,40846,12444,2,1456,'App\\Models\\Receipt',1456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',2180.00,NULL,NULL,1,'2021-09-28 17:47:16','2021-09-28 17:47:16',NULL),(1795,3117,40846,12444,2,1455,'App\\Models\\Receipt',1455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',2795.00,NULL,NULL,1,'2021-09-28 17:47:36','2021-09-28 17:47:36',NULL),(1796,3117,40846,12444,2,1454,'App\\Models\\Receipt',1454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',3210.00,NULL,NULL,1,'2021-09-28 17:47:52','2021-09-28 17:47:52',NULL),(1797,3117,40846,12444,2,1453,'App\\Models\\Receipt',1453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',4034.00,NULL,NULL,1,'2021-09-28 17:48:10','2021-09-28 17:48:10',NULL),(1798,3117,40846,12444,2,1449,'App\\Models\\Receipt',1449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',2420.00,NULL,NULL,1,'2021-09-28 17:48:27','2021-09-28 17:48:27',NULL),(1799,3117,40846,12444,2,1452,'App\\Models\\Receipt',1452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',2855.00,NULL,NULL,1,'2021-09-28 17:49:07','2021-09-28 17:49:07',NULL),(1800,3117,40846,12444,2,1451,'App\\Models\\Receipt',1451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',2290.00,NULL,NULL,1,'2021-09-28 17:49:20','2021-09-28 17:49:20',NULL),(1801,3117,40846,12446,2,1450,'App\\Models\\Receipt',1450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',4650.00,NULL,NULL,1,'2021-09-28 17:49:31','2021-09-28 17:49:45','2021-09-28 17:49:45'),(1802,3117,40846,12444,2,1450,'App\\Models\\Receipt',1450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',4650.00,NULL,NULL,1,'2021-09-28 17:49:45','2021-09-28 17:49:45',NULL),(1803,3117,40846,12444,2,1448,'App\\Models\\Receipt',1448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',7400.00,NULL,NULL,1,'2021-09-28 17:50:00','2021-09-28 17:50:00',NULL),(1804,3117,40846,12446,2,1447,'App\\Models\\Receipt',1447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',3240.00,NULL,NULL,1,'2021-09-28 17:50:15','2021-09-28 17:50:37','2021-09-28 17:50:37'),(1805,3117,40846,12444,2,1447,'App\\Models\\Receipt',1447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',3240.00,NULL,NULL,1,'2021-09-28 17:50:37','2021-09-28 17:50:37',NULL),(1806,3117,40846,12444,2,1446,'App\\Models\\Receipt',1446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',3171.00,NULL,NULL,1,'2021-09-28 17:50:50','2021-09-28 17:50:50',NULL),(1807,3117,40846,12444,2,1445,'App\\Models\\Receipt',1445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',2015.00,NULL,NULL,1,'2021-09-28 17:51:05','2021-09-28 17:51:05',NULL),(1808,3117,40846,12444,2,1444,'App\\Models\\Receipt',1444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',2915.00,NULL,NULL,1,'2021-09-28 17:51:18','2021-09-28 17:51:18',NULL),(1809,3117,40846,12444,2,1443,'App\\Models\\Receipt',1443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',2080.00,NULL,NULL,1,'2021-09-28 17:51:31','2021-09-28 17:51:31',NULL);
INSERT INTO `balance_libro` VALUES (1810,3117,40846,12444,2,1442,'App\\Models\\Receipt',1442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1475.00,NULL,NULL,1,'2021-09-28 17:51:42','2021-09-28 17:51:42',NULL),(1811,3117,40846,12446,2,1441,'App\\Models\\Receipt',1441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',2337.00,NULL,NULL,1,'2021-09-28 17:53:13','2021-09-28 17:53:29','2021-09-28 17:53:29'),(1812,3117,40846,12444,2,1441,'App\\Models\\Receipt',1441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',2337.00,NULL,NULL,1,'2021-09-28 17:53:29','2021-09-28 17:53:29',NULL),(1813,3117,40846,12444,2,1440,'App\\Models\\Receipt',1440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',3705.00,NULL,NULL,1,'2021-09-28 17:53:44','2021-09-28 17:53:44',NULL),(1814,3117,40846,12444,2,1439,'App\\Models\\Receipt',1439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',5410.00,NULL,NULL,1,'2021-09-28 17:54:01','2021-09-28 17:54:01',NULL),(1815,3117,40846,12444,2,1438,'App\\Models\\Receipt',1438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',4740.00,NULL,NULL,1,'2021-09-28 17:54:19','2021-09-28 17:54:19',NULL),(1816,3117,40846,12444,2,1437,'App\\Models\\Receipt',1437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1785.00,NULL,NULL,1,'2021-09-28 17:54:33','2021-09-28 17:54:33',NULL),(1817,3117,40846,12444,2,1436,'App\\Models\\Receipt',1436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',6620.00,NULL,NULL,1,'2021-09-28 17:54:45','2021-09-28 17:54:45',NULL),(1818,3117,40846,12444,2,1435,'App\\Models\\Receipt',1435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1785.00,NULL,NULL,1,'2021-09-28 17:54:57','2021-09-28 17:54:57',NULL),(1819,3117,40846,12444,2,1434,'App\\Models\\Receipt',1434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1350.00,NULL,NULL,1,'2021-09-28 17:55:10','2021-09-28 17:55:10',NULL),(1820,3117,40846,12444,2,1433,'App\\Models\\Receipt',1433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1560.00,NULL,NULL,1,'2021-09-28 17:55:22','2021-09-28 17:55:22',NULL),(1821,3117,40846,12444,2,1432,'App\\Models\\Receipt',1432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1570.00,NULL,NULL,1,'2021-09-28 17:55:34','2021-09-28 17:55:34',NULL),(1822,3117,40846,12444,2,1431,'App\\Models\\Receipt',1431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',3300.00,NULL,NULL,1,'2021-09-28 17:55:48','2021-09-28 17:55:48',NULL),(1823,3117,40846,12444,2,1430,'App\\Models\\Receipt',1430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1395.00,NULL,NULL,1,'2021-09-28 17:56:06','2021-09-28 17:56:06',NULL),(1824,3117,40846,12444,2,1429,'App\\Models\\Receipt',1429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',3500.00,NULL,NULL,1,'2021-09-28 17:56:20','2021-09-28 17:56:20',NULL),(1825,3117,40846,12444,2,1428,'App\\Models\\Receipt',1428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',143.00,NULL,NULL,1,'2021-09-28 17:56:35','2021-09-28 17:56:35',NULL),(1826,3117,40846,12444,2,1427,'App\\Models\\Receipt',1427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',143.00,NULL,NULL,1,'2021-09-28 17:56:55','2021-09-28 17:56:55',NULL),(1827,3117,40846,12444,2,1426,'App\\Models\\Receipt',1426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',143.00,NULL,NULL,1,'2021-09-28 17:57:09','2021-09-28 17:57:09',NULL),(1828,3117,40846,12446,2,1425,'App\\Models\\Receipt',1425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',8000.00,NULL,NULL,1,'2021-09-28 17:57:22','2021-09-28 17:57:50','2021-09-28 17:57:50'),(1829,3117,40846,12446,2,1425,'App\\Models\\Receipt',1425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',8000.00,NULL,NULL,1,'2021-09-28 17:57:50','2021-09-28 17:58:35','2021-09-28 17:58:35');
INSERT INTO `balance_libro` VALUES (1830,3117,40846,12444,2,1425,'App\\Models\\Receipt',1425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',8000.00,NULL,NULL,1,'2021-09-28 17:58:35','2021-09-28 17:58:35',NULL),(1831,3117,40846,12444,2,1424,'App\\Models\\Receipt',1424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',8000.00,NULL,NULL,1,'2021-09-28 18:01:02','2021-09-28 18:01:02',NULL),(1832,3117,40846,12444,2,1423,'App\\Models\\Receipt',1423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',8000.00,NULL,NULL,1,'2021-09-28 18:01:20','2021-09-28 18:01:20',NULL),(1833,3117,40846,12444,2,1422,'App\\Models\\Receipt',1422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',2543.00,NULL,NULL,1,'2021-09-28 18:01:37','2021-09-28 18:01:37',NULL),(1834,3117,40846,12444,2,1421,'App\\Models\\Receipt',1421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1750.00,NULL,NULL,1,'2021-09-28 18:01:52','2021-09-28 18:01:52',NULL),(1835,3117,40846,12444,2,1420,'App\\Models\\Receipt',1420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1650.00,NULL,NULL,1,'2021-09-28 18:02:08','2021-09-28 18:02:08',NULL),(1836,3117,40846,12444,2,1419,'App\\Models\\Receipt',1419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',2700.00,NULL,NULL,1,'2021-09-28 18:02:22','2021-09-28 18:02:22',NULL),(1837,3117,40846,12444,2,1418,'App\\Models\\Receipt',1418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',4280.00,NULL,NULL,1,'2021-09-28 18:02:37','2021-09-28 18:02:37',NULL),(1838,3117,40846,12444,2,1417,'App\\Models\\Receipt',1417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',2115.00,NULL,NULL,1,'2021-09-28 18:02:50','2021-09-28 18:02:50',NULL),(1839,3117,40846,12444,2,1416,'App\\Models\\Receipt',1416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',2665.00,NULL,NULL,1,'2021-09-28 18:03:04','2021-09-28 18:03:04',NULL),(1840,3117,40846,12444,2,1415,'App\\Models\\Receipt',1415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',1300.00,NULL,NULL,1,'2021-09-28 18:03:18','2021-09-28 18:03:18',NULL),(1841,3117,40846,12444,2,1414,'App\\Models\\Receipt',1414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',2700.00,NULL,NULL,1,'2021-09-28 18:03:32','2021-09-28 18:03:32',NULL),(1842,3117,40846,12444,2,1413,'App\\Models\\Receipt',1413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',4380.00,NULL,NULL,1,'2021-09-28 18:03:47','2021-09-28 18:03:47',NULL),(1843,3117,40846,12444,2,1412,'App\\Models\\Receipt',1412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',1000.00,NULL,NULL,1,'2021-09-28 18:03:59','2021-09-28 18:03:59',NULL),(1844,3117,40846,12444,2,1411,'App\\Models\\Receipt',1411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',4315.00,NULL,NULL,1,'2021-09-28 18:04:41','2021-09-28 18:04:41',NULL),(1845,3117,40846,12446,2,1410,'App\\Models\\Receipt',1410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',2060.00,NULL,NULL,1,'2021-09-28 18:05:25','2021-09-28 18:05:45','2021-09-28 18:05:45'),(1846,3117,40846,12444,2,1410,'App\\Models\\Receipt',1410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',2060.00,NULL,NULL,1,'2021-09-28 18:05:45','2021-09-28 18:05:45',NULL),(1847,3117,40846,12444,2,1409,'App\\Models\\Receipt',1409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',2145.00,NULL,NULL,1,'2021-09-28 18:06:02','2021-09-28 18:06:02',NULL),(1848,3117,40846,12444,2,1408,'App\\Models\\Receipt',1408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',5000.00,NULL,NULL,1,'2021-09-28 18:06:19','2021-09-28 18:06:19',NULL),(1849,3117,40846,12444,2,1407,'App\\Models\\Receipt',1407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',8000.00,NULL,NULL,1,'2021-09-28 18:06:37','2021-09-28 18:06:37',NULL),(1850,3117,40846,12444,2,1406,'App\\Models\\Receipt',1406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',180.00,NULL,NULL,1,'2021-09-28 18:06:51','2021-09-28 18:06:51',NULL);
INSERT INTO `balance_libro` VALUES (1851,3117,40846,12444,2,1405,'App\\Models\\Receipt',1405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',5000.00,NULL,NULL,1,'2021-09-28 18:07:09','2021-09-28 18:07:09',NULL),(1852,3117,40846,12444,2,1404,'App\\Models\\Receipt',1404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',5000.00,NULL,NULL,1,'2021-09-28 18:07:27','2021-09-28 18:07:27',NULL),(1853,3117,40846,12444,2,1403,'App\\Models\\Receipt',1403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',6625.00,NULL,NULL,1,'2021-09-28 18:07:41','2021-09-28 18:07:41',NULL),(1854,3117,40846,12444,2,1402,'App\\Models\\Receipt',1402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',6625.00,NULL,NULL,1,'2021-09-28 18:07:56','2021-09-28 18:07:56',NULL),(1855,3117,40846,12444,2,1401,'App\\Models\\Receipt',1401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',6625.00,NULL,NULL,1,'2021-09-28 18:08:09','2021-09-28 18:08:09',NULL),(1856,3117,40846,12444,2,1400,'App\\Models\\Receipt',1400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',6625.00,NULL,NULL,1,'2021-09-28 18:08:23','2021-09-28 18:08:23',NULL),(1857,3117,40846,12444,2,1399,'App\\Models\\Receipt',1399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',2115.00,NULL,NULL,1,'2021-09-28 18:08:37','2021-09-28 18:08:37',NULL),(1858,3117,40846,12444,2,1398,'App\\Models\\Receipt',1398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',2665.00,NULL,NULL,1,'2021-09-28 18:08:50','2021-09-28 18:08:50',NULL),(1859,3117,40846,12446,2,1397,'App\\Models\\Receipt',1397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',1630.00,NULL,NULL,1,'2021-09-28 18:09:16','2021-09-28 18:09:31','2021-09-28 18:09:31'),(1860,3117,40846,12445,2,1397,'App\\Models\\Receipt',1397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',1630.00,NULL,NULL,1,'2021-09-28 18:09:31','2021-09-28 18:09:31',NULL),(1861,3117,40846,12445,2,1396,'App\\Models\\Receipt',1396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3195.00,NULL,NULL,1,'2021-09-28 18:09:44','2021-09-28 18:09:44',NULL),(1862,3117,40846,12445,2,1395,'App\\Models\\Receipt',1395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',5300.00,NULL,NULL,1,'2021-09-28 18:09:58','2021-09-28 18:09:58',NULL),(1863,3117,40846,12445,2,1394,'App\\Models\\Receipt',1394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',1670.00,NULL,NULL,1,'2021-09-28 18:10:11','2021-09-28 18:10:11',NULL),(1864,3117,40846,12445,2,1393,'App\\Models\\Receipt',1393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',4050.00,NULL,NULL,1,'2021-09-28 18:10:24','2021-09-28 18:10:24',NULL),(1865,3117,40846,12445,2,1392,'App\\Models\\Receipt',1392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',4050.00,NULL,NULL,1,'2021-09-28 18:10:36','2021-09-28 18:10:36',NULL),(1866,3117,40846,12445,2,1391,'App\\Models\\Receipt',1391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',1620.00,NULL,NULL,1,'2021-09-28 18:10:49','2021-09-28 18:10:49',NULL),(1867,3117,40846,12445,2,1390,'App\\Models\\Receipt',1390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3650.00,NULL,NULL,1,'2021-09-28 18:11:01','2021-09-28 18:11:01',NULL),(1868,3117,40846,12445,2,1389,'App\\Models\\Receipt',1389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',4500.00,NULL,NULL,1,'2021-09-28 18:11:18','2021-09-28 18:11:18',NULL),(1869,3117,40846,12445,2,1388,'App\\Models\\Receipt',1388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',4500.00,NULL,NULL,1,'2021-09-28 18:11:31','2021-09-28 18:11:31',NULL),(1870,3117,40846,12445,2,1387,'App\\Models\\Receipt',1387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3295.00,NULL,NULL,1,'2021-09-28 18:11:42','2021-09-28 18:11:42',NULL),(1871,3117,40846,12445,2,1386,'App\\Models\\Receipt',1386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3882.00,NULL,NULL,1,'2021-09-28 18:11:57','2021-09-28 18:11:57',NULL);
INSERT INTO `balance_libro` VALUES (1872,3117,40846,12445,2,1385,'App\\Models\\Receipt',1385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3127.00,NULL,NULL,1,'2021-09-28 18:12:10','2021-09-28 18:12:10',NULL),(1873,3117,40846,12445,2,1384,'App\\Models\\Receipt',1384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',4840.00,NULL,NULL,1,'2021-09-28 18:12:25','2021-09-28 18:12:25',NULL),(1874,3117,40846,12445,2,1383,'App\\Models\\Receipt',1383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',4830.00,NULL,NULL,1,'2021-09-28 18:12:40','2021-09-28 18:12:40',NULL),(1875,3117,40846,12445,2,1382,'App\\Models\\Receipt',1382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',5450.00,NULL,NULL,1,'2021-09-28 18:12:58','2021-09-28 18:12:58',NULL),(1876,3117,40846,12445,2,1381,'App\\Models\\Receipt',1381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3340.00,NULL,NULL,1,'2021-09-28 18:13:14','2021-09-28 18:13:14',NULL),(1877,3117,40846,12445,2,1380,'App\\Models\\Receipt',1380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3910.00,NULL,NULL,1,'2021-09-28 18:13:29','2021-09-28 18:13:29',NULL),(1878,3117,40846,12443,3,1755,'App\\Models\\Receipt',1755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',1180.00,NULL,NULL,1,'2021-09-28 18:17:18','2021-09-28 18:17:18',NULL),(1879,3117,40846,12443,3,1756,'App\\Models\\Receipt',1756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',7431.24,NULL,NULL,1,'2021-09-28 18:17:18','2021-09-28 18:17:18',NULL),(1880,3117,40846,12443,3,1757,'App\\Models\\Receipt',1757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',3846.77,NULL,NULL,1,'2021-09-28 18:17:18','2021-09-28 18:17:18',NULL),(1881,3117,40846,12443,3,1758,'App\\Models\\Receipt',1758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',4653.83,NULL,NULL,1,'2021-09-28 18:17:18','2021-09-28 18:17:18',NULL),(1882,3117,40846,12443,3,1759,'App\\Models\\Receipt',1759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',1271.13,NULL,NULL,1,'2021-09-28 18:17:18','2021-09-28 18:17:18',NULL),(1883,3117,40846,12443,3,1760,'App\\Models\\Receipt',1760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',8193.00,NULL,NULL,1,'2021-09-28 18:17:18','2021-09-28 18:17:18',NULL),(1884,3117,40846,12443,3,1761,'App\\Models\\Receipt',1761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',3571.05,NULL,NULL,1,'2021-09-28 18:17:18','2021-09-28 18:17:18',NULL),(1885,3117,40846,12443,3,1762,'App\\Models\\Receipt',1762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',2114.57,NULL,NULL,1,'2021-09-28 18:17:18','2021-09-28 18:17:18',NULL),(1886,3117,40846,12443,3,1763,'App\\Models\\Receipt',1763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',7301.32,NULL,NULL,1,'2021-09-28 18:17:19','2021-09-28 18:17:19',NULL),(1887,3117,40846,12443,3,1764,'App\\Models\\Receipt',1764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',8588.11,NULL,NULL,1,'2021-09-28 18:17:19','2021-09-28 18:17:19',NULL),(1888,3117,40846,12443,3,1765,'App\\Models\\Receipt',1765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',4808.02,NULL,NULL,1,'2021-09-28 18:17:19','2021-09-28 18:17:19',NULL),(1889,3117,40846,12443,3,1766,'App\\Models\\Receipt',1766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',4033.11,NULL,NULL,1,'2021-09-28 18:17:19','2021-09-28 18:17:19',NULL),(1890,3117,40846,12443,3,1767,'App\\Models\\Receipt',1767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',2748.95,NULL,NULL,1,'2021-09-28 18:17:19','2021-09-28 18:17:19',NULL),(1891,3117,40846,12443,3,1768,'App\\Models\\Receipt',1768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',2020.10,NULL,NULL,1,'2021-09-28 18:17:19','2021-09-28 18:17:19',NULL),(1892,3117,40846,12443,3,1769,'App\\Models\\Receipt',1769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',7754.56,NULL,NULL,1,'2021-09-28 18:17:19','2021-09-28 18:17:19',NULL);
INSERT INTO `balance_libro` VALUES (1893,3117,40846,12443,3,1770,'App\\Models\\Receipt',1770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',7375.14,NULL,NULL,1,'2021-09-28 18:17:19','2021-09-28 18:17:19',NULL),(1894,3117,40846,12443,3,1771,'App\\Models\\Receipt',1771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',3124.78,NULL,NULL,1,'2021-09-28 18:17:19','2021-09-28 18:17:19',NULL),(1895,3117,40846,12443,3,1772,'App\\Models\\Receipt',1772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',8861.91,NULL,NULL,1,'2021-09-28 18:17:19','2021-09-28 18:17:19',NULL),(1896,3117,40846,12443,3,1773,'App\\Models\\Receipt',1773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',11010.42,NULL,NULL,1,'2021-09-28 18:17:19','2021-09-28 18:17:19',NULL),(1897,3117,40846,12443,3,1774,'App\\Models\\Receipt',1774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',4914.60,NULL,NULL,1,'2021-09-28 18:17:19','2021-09-28 18:17:19',NULL),(1898,3117,40846,12443,3,1775,'App\\Models\\Receipt',1775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',9761.58,NULL,NULL,1,'2021-09-28 18:17:19','2021-09-28 18:17:19',NULL),(1899,3117,40846,12443,3,1776,'App\\Models\\Receipt',1776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',4270.83,NULL,NULL,1,'2021-09-28 18:17:19','2021-09-28 18:17:19',NULL),(1900,3117,40846,12443,3,1777,'App\\Models\\Receipt',1777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',4256.83,NULL,NULL,1,'2021-09-28 18:17:19','2021-09-28 18:17:19',NULL),(1901,3117,40846,12443,3,1778,'App\\Models\\Receipt',1778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',515.22,NULL,NULL,1,'2021-09-28 18:17:19','2021-09-28 18:17:19',NULL),(1902,3117,40846,12443,3,1779,'App\\Models\\Receipt',1779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',4443.59,NULL,NULL,1,'2021-09-28 18:17:19','2021-09-28 18:17:19',NULL),(1903,3117,40846,12443,3,1780,'App\\Models\\Receipt',1780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',100.37,NULL,NULL,1,'2021-09-28 18:17:19','2021-09-28 18:17:19',NULL),(1904,3117,40846,12443,3,1781,'App\\Models\\Receipt',1781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',5184.43,NULL,NULL,1,'2021-09-28 18:17:19','2021-09-28 18:17:19',NULL),(1905,3117,40846,12443,3,1782,'App\\Models\\Receipt',1782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',24630.33,NULL,NULL,1,'2021-09-28 18:17:19','2021-09-28 18:17:19',NULL),(1906,3117,40846,12443,3,1783,'App\\Models\\Receipt',1783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',11174.40,NULL,NULL,1,'2021-09-28 18:17:19','2021-09-28 18:17:19',NULL),(1907,3117,40846,12443,3,1784,'App\\Models\\Receipt',1784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',1259.21,NULL,NULL,1,'2021-09-28 18:17:19','2021-09-28 18:17:19',NULL),(1908,3117,40846,12443,3,1785,'App\\Models\\Receipt',1785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',4852.97,NULL,NULL,1,'2021-09-28 18:17:20','2021-09-28 18:17:20',NULL),(1909,3117,40846,12443,3,1786,'App\\Models\\Receipt',1786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',3651.55,NULL,NULL,1,'2021-09-28 18:17:20','2021-09-28 18:17:20',NULL),(1910,3117,40846,12443,3,1787,'App\\Models\\Receipt',1787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',3291.54,NULL,NULL,1,'2021-09-28 18:17:20','2021-09-28 18:17:20',NULL),(1911,3117,40846,12443,3,1788,'App\\Models\\Receipt',1788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',1449.70,NULL,NULL,1,'2021-09-28 18:17:20','2021-09-28 18:17:20',NULL),(1912,3117,40846,12443,3,1789,'App\\Models\\Receipt',1789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',9679.47,NULL,NULL,1,'2021-09-28 18:17:20','2021-09-28 18:17:20',NULL),(1913,3117,40846,12443,3,1790,'App\\Models\\Receipt',1790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',1116.21,NULL,NULL,1,'2021-09-28 18:17:20','2021-09-28 18:17:20',NULL);
INSERT INTO `balance_libro` VALUES (1914,3117,40846,12443,3,1791,'App\\Models\\Receipt',1791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',1403.84,NULL,NULL,1,'2021-09-28 18:17:20','2021-09-28 18:17:20',NULL),(1915,3117,40846,12443,3,1792,'App\\Models\\Receipt',1792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',6267.46,NULL,NULL,1,'2021-09-28 18:17:20','2021-09-28 18:17:20',NULL),(1916,3117,40846,12443,3,1793,'App\\Models\\Receipt',1793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',105.00,NULL,NULL,1,'2021-09-28 18:17:20','2021-09-28 18:17:20',NULL),(1917,3117,40846,12443,3,1794,'App\\Models\\Receipt',1794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',1551.10,NULL,NULL,1,'2021-09-28 18:17:20','2021-09-28 18:17:20',NULL),(1918,3117,40846,12443,3,1795,'App\\Models\\Receipt',1795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',699.96,NULL,NULL,1,'2021-09-28 18:17:20','2021-09-28 18:17:20',NULL),(1919,3117,40846,12443,3,1796,'App\\Models\\Receipt',1796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2021-09-28 18:17:20','2021-09-28 18:17:20',NULL),(1962,3117,40846,12445,3,1839,'App\\Models\\Receipt',1839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2575.00,NULL,NULL,1,'2021-09-28 18:19:04','2021-12-27 11:37:09','2021-12-27 11:37:09'),(1963,3117,40846,12445,3,1840,'App\\Models\\Receipt',1840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',3007.00,NULL,NULL,1,'2021-09-28 18:19:04','2021-12-27 11:37:09','2021-12-27 11:37:09'),(1964,3117,40846,12445,3,1841,'App\\Models\\Receipt',1841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2345.00,NULL,NULL,1,'2021-09-28 18:19:05','2021-12-27 11:37:09','2021-12-27 11:37:09'),(1965,3117,40846,12445,3,1842,'App\\Models\\Receipt',1842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',1710.00,NULL,NULL,1,'2021-09-28 18:19:05','2021-12-27 11:37:09','2021-12-27 11:37:09'),(1966,3117,40846,12445,3,1843,'App\\Models\\Receipt',1843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',4500.00,NULL,NULL,1,'2021-09-28 18:19:05','2021-12-27 11:37:10','2021-12-27 11:37:10'),(1967,3117,40846,12445,3,1844,'App\\Models\\Receipt',1844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',4500.00,NULL,NULL,1,'2021-09-28 18:19:05','2021-12-27 11:37:10','2021-12-27 11:37:10'),(1968,3117,40846,12445,3,1845,'App\\Models\\Receipt',1845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2860.00,NULL,NULL,1,'2021-09-28 18:19:05','2021-12-27 11:37:10','2021-12-27 11:37:10'),(1969,3117,40846,12445,3,1846,'App\\Models\\Receipt',1846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',3975.00,NULL,NULL,1,'2021-09-28 18:19:05','2021-12-27 11:37:10','2021-12-27 11:37:10'),(1970,3117,40846,12445,3,1847,'App\\Models\\Receipt',1847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2955.00,NULL,NULL,1,'2021-09-28 18:19:05','2021-12-27 11:37:10','2021-12-27 11:37:10'),(1971,3117,40846,12445,3,1848,'App\\Models\\Receipt',1848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2415.00,NULL,NULL,1,'2021-09-28 18:19:05','2021-12-27 11:37:10','2021-12-27 11:37:10'),(1972,3117,40846,12445,3,1849,'App\\Models\\Receipt',1849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2900.00,NULL,NULL,1,'2021-09-28 18:19:05','2021-12-27 11:37:10','2021-12-27 11:37:10'),(1973,3117,40846,12445,3,1850,'App\\Models\\Receipt',1850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2000.00,NULL,NULL,1,'2021-09-28 18:19:05','2021-12-27 11:37:10','2021-12-27 11:37:10'),(1974,3117,40846,12445,3,1851,'App\\Models\\Receipt',1851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',3120.00,NULL,NULL,1,'2021-09-28 18:19:05','2021-12-27 11:37:10','2021-12-27 11:37:10');
INSERT INTO `balance_libro` VALUES (1975,3117,40846,12445,3,1852,'App\\Models\\Receipt',1852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2370.00,NULL,NULL,1,'2021-09-28 18:19:05','2021-12-27 11:37:10','2021-12-27 11:37:10'),(1976,3117,40846,12445,3,1853,'App\\Models\\Receipt',1853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',5365.00,NULL,NULL,1,'2021-09-28 18:19:05','2021-12-27 11:37:10','2021-12-27 11:37:10'),(1977,3117,40846,12445,3,1854,'App\\Models\\Receipt',1854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2950.00,NULL,NULL,1,'2021-09-28 18:19:05','2021-12-27 11:37:10','2021-12-27 11:37:10'),(1978,3117,40846,12445,3,1855,'App\\Models\\Receipt',1855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',3223.00,NULL,NULL,1,'2021-09-28 18:19:05','2021-12-27 11:37:10','2021-12-27 11:37:10'),(1979,3117,40846,12445,3,1856,'App\\Models\\Receipt',1856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2470.00,NULL,NULL,1,'2021-09-28 18:19:05','2021-12-27 11:37:10','2021-12-27 11:37:10'),(1980,3117,40846,12445,3,1857,'App\\Models\\Receipt',1857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',1890.00,NULL,NULL,1,'2021-09-28 18:19:05','2021-12-27 11:37:10','2021-12-27 11:37:10'),(1981,3117,40846,12445,3,1858,'App\\Models\\Receipt',1858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2225.00,NULL,NULL,1,'2021-09-28 18:19:05','2021-12-27 11:37:10','2021-12-27 11:37:10'),(1982,3117,40846,12445,3,1859,'App\\Models\\Receipt',1859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2380.00,NULL,NULL,1,'2021-09-28 18:19:05','2021-12-27 11:37:10','2021-12-27 11:37:10'),(1983,3117,40846,12445,3,1860,'App\\Models\\Receipt',1860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2510.00,NULL,NULL,1,'2021-09-28 18:19:05','2021-12-27 11:37:10','2021-12-27 11:37:10'),(1984,3117,40846,12445,3,1861,'App\\Models\\Receipt',1861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2000.00,NULL,NULL,1,'2021-09-28 18:19:05','2021-12-27 11:37:10','2021-12-27 11:37:10'),(1985,3117,40846,12445,3,1862,'App\\Models\\Receipt',1862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2990.00,NULL,NULL,1,'2021-09-28 18:19:05','2021-12-27 11:37:10','2021-12-27 11:37:10'),(1986,3117,40846,12445,3,1863,'App\\Models\\Receipt',1863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',800.00,NULL,NULL,1,'2021-09-28 18:19:05','2021-12-27 11:37:10','2021-12-27 11:37:10'),(1987,3117,40846,12445,3,1864,'App\\Models\\Receipt',1864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',5000.00,NULL,NULL,1,'2021-09-28 18:19:05','2021-12-27 11:37:10','2021-12-27 11:37:10'),(1988,3117,40846,12445,3,1865,'App\\Models\\Receipt',1865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',1980.00,NULL,NULL,1,'2021-09-28 18:19:05','2021-12-27 11:37:10','2021-12-27 11:37:10'),(1989,3117,40846,12445,3,1866,'App\\Models\\Receipt',1866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',3525.00,NULL,NULL,1,'2021-09-28 18:19:05','2021-12-27 11:37:10','2021-12-27 11:37:10'),(1990,3117,40846,12445,3,1867,'App\\Models\\Receipt',1867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',1108.00,NULL,NULL,1,'2021-09-28 18:19:05','2021-12-27 11:37:10','2021-12-27 11:37:10'),(1991,3117,40846,12445,3,1868,'App\\Models\\Receipt',1868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',5000.00,NULL,NULL,1,'2021-09-28 18:19:05','2021-12-27 11:37:10','2021-12-27 11:37:10'),(1992,3117,40846,12445,3,1869,'App\\Models\\Receipt',1869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',5000.00,NULL,NULL,1,'2021-09-28 18:19:05','2021-12-27 11:37:10','2021-12-27 11:37:10'),(1993,3117,40846,12445,3,1870,'App\\Models\\Receipt',1870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',5000.00,NULL,NULL,1,'2021-09-28 18:19:06','2021-12-27 11:37:10','2021-12-27 11:37:10');
INSERT INTO `balance_libro` VALUES (1994,3117,40846,12445,3,1871,'App\\Models\\Receipt',1871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',5000.00,NULL,NULL,1,'2021-09-28 18:19:06','2021-12-27 11:37:10','2021-12-27 11:37:10'),(1995,3117,40846,12445,3,1872,'App\\Models\\Receipt',1872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3425.00,NULL,NULL,1,'2021-09-28 18:19:06','2021-12-27 11:37:10','2021-12-27 11:37:10'),(1996,3117,40846,12445,3,1873,'App\\Models\\Receipt',1873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',2300.00,NULL,NULL,1,'2021-09-28 18:19:06','2021-12-27 11:37:10','2021-12-27 11:37:10'),(1997,3117,40846,12445,3,1874,'App\\Models\\Receipt',1874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',2510.00,NULL,NULL,1,'2021-09-28 18:19:06','2021-12-27 11:37:10','2021-12-27 11:37:10'),(1998,3117,40846,12445,3,1875,'App\\Models\\Receipt',1875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',2250.00,NULL,NULL,1,'2021-09-28 18:19:06','2021-12-27 11:37:10','2021-12-27 11:37:10'),(1999,3117,40846,12445,3,1876,'App\\Models\\Receipt',1876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3130.00,NULL,NULL,1,'2021-09-28 18:19:06','2021-12-27 11:37:10','2021-12-27 11:37:10'),(2000,3117,40846,12445,3,1877,'App\\Models\\Receipt',1877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',1371.00,NULL,NULL,1,'2021-09-28 18:19:06','2021-12-27 11:37:10','2021-12-27 11:37:10'),(2001,3117,40846,12445,3,1878,'App\\Models\\Receipt',1878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',2200.00,NULL,NULL,1,'2021-09-28 18:19:06','2021-12-27 11:37:10','2021-12-27 11:37:10'),(2002,3117,40846,12445,3,1879,'App\\Models\\Receipt',1879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3025.00,NULL,NULL,1,'2021-09-28 18:19:06','2021-12-27 11:37:10','2021-12-27 11:37:10'),(2003,3117,40846,12445,3,1880,'App\\Models\\Receipt',1880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',2090.00,NULL,NULL,1,'2021-09-28 18:19:06','2021-12-27 11:37:10','2021-12-27 11:37:10'),(2004,3117,40846,12445,3,1881,'App\\Models\\Receipt',1881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3910.00,NULL,NULL,1,'2021-09-28 18:19:06','2021-12-27 11:37:10','2021-12-27 11:37:10'),(2005,3117,40846,12445,3,1882,'App\\Models\\Receipt',1882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3340.00,NULL,NULL,1,'2021-09-28 18:19:06','2021-12-27 11:37:10','2021-12-27 11:37:10'),(2006,3117,40846,12445,3,1883,'App\\Models\\Receipt',1883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',5450.00,NULL,NULL,1,'2021-09-28 18:19:06','2021-12-27 11:37:10','2021-12-27 11:37:10'),(2007,3117,40846,12445,3,1884,'App\\Models\\Receipt',1884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',4830.00,NULL,NULL,1,'2021-09-28 18:19:06','2021-12-27 11:37:10','2021-12-27 11:37:10'),(2008,3117,40846,12445,3,1885,'App\\Models\\Receipt',1885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',4840.00,NULL,NULL,1,'2021-09-28 18:19:06','2021-12-27 11:37:10','2021-12-27 11:37:10'),(2009,3117,40846,12445,3,1886,'App\\Models\\Receipt',1886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3127.00,NULL,NULL,1,'2021-09-28 18:19:06','2021-12-27 11:37:10','2021-12-27 11:37:10'),(2010,3117,40846,12445,3,1887,'App\\Models\\Receipt',1887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3882.00,NULL,NULL,1,'2021-09-28 18:19:06','2021-12-27 11:37:10','2021-12-27 11:37:10'),(2011,3117,40846,12445,3,1888,'App\\Models\\Receipt',1888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3295.00,NULL,NULL,1,'2021-09-28 18:19:06','2021-12-27 11:36:52','2021-12-27 11:36:52'),(2012,3117,40846,12445,3,1889,'App\\Models\\Receipt',1889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',4500.00,NULL,NULL,1,'2021-09-28 18:19:06','2021-12-27 11:36:43','2021-12-27 11:36:43');
INSERT INTO `balance_libro` VALUES (2013,3117,40846,12445,3,1890,'App\\Models\\Receipt',1890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',4500.00,NULL,NULL,1,'2021-09-28 18:19:06','2021-12-27 11:36:34','2021-12-27 11:36:34'),(2014,3117,40846,12445,3,1891,'App\\Models\\Receipt',1891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3650.00,NULL,NULL,1,'2021-09-28 18:19:06','2021-12-27 11:36:24','2021-12-27 11:36:24'),(2015,3117,40846,12445,3,1892,'App\\Models\\Receipt',1892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',1620.00,NULL,NULL,1,'2021-09-28 18:19:06','2021-12-27 11:36:15','2021-12-27 11:36:15'),(2016,3117,40846,12445,3,1893,'App\\Models\\Receipt',1893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',4050.00,NULL,NULL,1,'2021-09-28 18:19:06','2021-12-27 11:36:03','2021-12-27 11:36:03'),(2017,3117,40846,12445,3,1894,'App\\Models\\Receipt',1894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',4050.00,NULL,NULL,1,'2021-09-28 18:19:06','2021-12-27 11:35:55','2021-12-27 11:35:55'),(2018,3117,40846,12445,3,1895,'App\\Models\\Receipt',1895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',1670.00,NULL,NULL,1,'2021-09-28 18:19:06','2021-12-27 11:35:44','2021-12-27 11:35:44'),(2019,3117,40846,12445,3,1896,'App\\Models\\Receipt',1896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',5300.00,NULL,NULL,1,'2021-09-28 18:19:06','2021-12-27 11:35:34','2021-12-27 11:35:34'),(2020,3117,40846,12445,3,1897,'App\\Models\\Receipt',1897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3195.00,NULL,NULL,1,'2021-09-28 18:19:06','2021-12-27 11:35:22','2021-12-27 11:35:22'),(2021,3117,40846,12445,3,1898,'App\\Models\\Receipt',1898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',1630.00,NULL,NULL,1,'2021-09-28 18:19:06','2021-12-27 11:35:00','2021-12-27 11:35:00'),(2022,3117,40846,12445,2,1379,'App\\Models\\Receipt',1379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',2090.00,NULL,NULL,1,'2021-09-28 18:19:55','2021-09-28 18:19:55',NULL),(2023,3117,40846,12446,2,1378,'App\\Models\\Receipt',1378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3025.00,NULL,NULL,1,'2021-09-28 18:20:13','2021-09-28 18:20:28','2021-09-28 18:20:28'),(2024,3117,40846,12445,2,1378,'App\\Models\\Receipt',1378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3025.00,NULL,NULL,1,'2021-09-28 18:20:28','2021-09-28 18:20:28',NULL),(2025,3117,40846,12445,2,1377,'App\\Models\\Receipt',1377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',2200.00,NULL,NULL,1,'2021-09-28 18:20:40','2021-09-28 18:20:40',NULL),(2026,3117,40846,12445,2,1376,'App\\Models\\Receipt',1376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',1371.00,NULL,NULL,1,'2021-09-28 18:20:55','2021-09-28 18:20:55',NULL),(2027,3117,40846,12445,2,1375,'App\\Models\\Receipt',1375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3130.00,NULL,NULL,1,'2021-09-28 18:21:09','2021-09-28 18:21:09',NULL),(2028,3117,40846,12445,2,1374,'App\\Models\\Receipt',1374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',2250.00,NULL,NULL,1,'2021-09-28 18:21:22','2021-09-28 18:21:22',NULL),(2029,3117,40846,12445,2,1373,'App\\Models\\Receipt',1373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',2510.00,NULL,NULL,1,'2021-09-28 18:21:36','2021-09-28 18:21:36',NULL),(2030,3117,40846,12445,2,1372,'App\\Models\\Receipt',1372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',2300.00,NULL,NULL,1,'2021-09-28 18:21:50','2021-09-28 18:21:50',NULL),(2031,3117,40846,12445,2,1371,'App\\Models\\Receipt',1371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3425.00,NULL,NULL,1,'2021-09-28 18:22:03','2021-09-28 18:22:03',NULL),(2032,3117,40846,12445,2,1370,'App\\Models\\Receipt',1370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',5000.00,NULL,NULL,1,'2021-09-28 18:22:18','2021-09-28 18:22:18',NULL);
INSERT INTO `balance_libro` VALUES (2033,3117,40846,12445,2,1369,'App\\Models\\Receipt',1369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',5000.00,NULL,NULL,1,'2021-09-28 18:22:32','2021-09-28 18:22:32',NULL),(2034,3117,40846,12445,2,1368,'App\\Models\\Receipt',1368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',5000.00,NULL,NULL,1,'2021-09-28 18:22:43','2021-09-28 18:22:43',NULL),(2035,3117,40846,12445,2,1367,'App\\Models\\Receipt',1367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',5000.00,NULL,NULL,1,'2021-09-28 18:22:55','2021-09-28 18:22:55',NULL),(2036,3117,40846,12445,2,1366,'App\\Models\\Receipt',1366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',1108.00,NULL,NULL,1,'2021-09-28 18:23:09','2021-09-28 18:23:09',NULL),(2037,3117,40846,12445,2,1365,'App\\Models\\Receipt',1365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',3525.00,NULL,NULL,1,'2021-09-28 18:23:22','2021-09-28 18:23:22',NULL),(2038,3117,40846,12445,2,1364,'App\\Models\\Receipt',1364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',1980.00,NULL,NULL,1,'2021-09-28 18:23:37','2021-09-28 18:23:37',NULL),(2039,3117,40846,12445,2,1363,'App\\Models\\Receipt',1363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',5000.00,NULL,NULL,1,'2021-09-28 18:23:50','2021-09-28 18:23:50',NULL),(2040,3117,40846,12445,2,1362,'App\\Models\\Receipt',1362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',800.00,NULL,NULL,1,'2021-09-28 18:24:03','2021-09-28 18:24:03',NULL),(2041,3117,40846,12445,2,1361,'App\\Models\\Receipt',1361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2990.00,NULL,NULL,1,'2021-09-28 18:24:18','2021-09-28 18:24:18',NULL),(2042,3117,40846,12445,2,1360,'App\\Models\\Receipt',1360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2000.00,NULL,NULL,1,'2021-09-28 18:24:31','2021-09-28 18:24:31',NULL),(2043,3117,40846,12445,2,1359,'App\\Models\\Receipt',1359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2510.00,NULL,NULL,1,'2021-09-28 18:24:45','2021-09-28 18:24:45',NULL),(2044,3117,40846,12445,2,1358,'App\\Models\\Receipt',1358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2380.00,NULL,NULL,1,'2021-09-28 18:24:59','2021-09-28 18:24:59',NULL),(2045,3117,40846,12445,2,1357,'App\\Models\\Receipt',1357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2225.00,NULL,NULL,1,'2021-09-28 18:25:12','2021-09-28 18:25:12',NULL),(2046,3117,40846,12445,2,1356,'App\\Models\\Receipt',1356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',1890.00,NULL,NULL,1,'2021-09-28 18:25:25','2021-09-28 18:25:25',NULL),(2047,3117,40846,12445,2,1355,'App\\Models\\Receipt',1355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2470.00,NULL,NULL,1,'2021-09-28 18:25:40','2021-09-28 18:25:40',NULL),(2048,3117,40846,12445,2,1354,'App\\Models\\Receipt',1354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',3223.00,NULL,NULL,1,'2021-09-28 18:25:53','2021-09-28 18:25:53',NULL),(2049,3117,40846,12445,2,1353,'App\\Models\\Receipt',1353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2950.00,NULL,NULL,1,'2021-09-28 18:26:05','2021-09-28 18:26:05',NULL),(2050,3117,40846,12445,2,1352,'App\\Models\\Receipt',1352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',5365.00,NULL,NULL,1,'2021-09-28 18:26:20','2021-09-28 18:26:20',NULL),(2051,3117,40846,12445,2,1351,'App\\Models\\Receipt',1351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2370.00,NULL,NULL,1,'2021-09-28 18:26:34','2021-09-28 18:26:34',NULL),(2052,3117,40846,12445,2,1350,'App\\Models\\Receipt',1350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',3120.00,NULL,NULL,1,'2021-09-28 18:26:48','2021-09-28 18:26:48',NULL),(2053,3117,40846,12445,2,1349,'App\\Models\\Receipt',1349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2000.00,NULL,NULL,1,'2021-09-28 18:27:04','2021-09-28 18:27:04',NULL);
INSERT INTO `balance_libro` VALUES (2054,3117,40846,12445,2,1348,'App\\Models\\Receipt',1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2900.00,NULL,NULL,1,'2021-09-28 18:27:17','2021-09-28 18:27:17',NULL),(2055,3117,40846,12445,2,1347,'App\\Models\\Receipt',1347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2415.00,NULL,NULL,1,'2021-09-28 18:27:31','2021-09-28 18:27:31',NULL),(2056,3117,40846,12445,2,1346,'App\\Models\\Receipt',1346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2955.00,NULL,NULL,1,'2021-09-28 18:27:45','2021-09-28 18:27:45',NULL),(2057,3117,40846,12445,2,1345,'App\\Models\\Receipt',1345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',3975.00,NULL,NULL,1,'2021-09-28 18:27:59','2021-09-28 18:27:59',NULL),(2058,3117,40846,12445,2,1344,'App\\Models\\Receipt',1344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2860.00,NULL,NULL,1,'2021-09-28 18:28:14','2021-09-28 18:28:14',NULL),(2059,3117,40846,12445,2,1343,'App\\Models\\Receipt',1343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',4500.00,NULL,NULL,1,'2021-09-28 18:28:29','2021-09-28 18:28:29',NULL),(2060,3117,40846,12445,2,1342,'App\\Models\\Receipt',1342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',4500.00,NULL,NULL,1,'2021-09-28 18:28:42','2021-09-28 18:28:42',NULL),(2061,3117,40846,12445,2,1341,'App\\Models\\Receipt',1341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',1710.00,NULL,NULL,1,'2021-09-28 18:28:57','2021-09-28 18:28:57',NULL),(2062,3117,40846,12445,2,1340,'App\\Models\\Receipt',1340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2345.00,NULL,NULL,1,'2021-09-28 18:29:10','2021-09-28 18:29:10',NULL),(2063,3117,40846,12445,2,1339,'App\\Models\\Receipt',1339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',3007.00,NULL,NULL,1,'2021-09-28 18:29:24','2021-09-28 18:29:24',NULL),(2064,3117,40779,4574,3,1899,'App\\Models\\Receipt',1899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',1890.00,NULL,NULL,1,'2021-10-05 14:36:57','2021-10-05 14:36:57',NULL),(2065,3117,40779,4574,3,1900,'App\\Models\\Receipt',1900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',19550.00,NULL,NULL,1,'2021-10-05 14:36:57','2021-10-05 14:36:57',NULL),(2066,3117,40779,4574,3,1901,'App\\Models\\Receipt',1901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',55757.45,NULL,NULL,1,'2021-10-05 14:36:57','2021-10-05 14:36:57',NULL),(2067,3117,40779,4574,3,1902,'App\\Models\\Receipt',1902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',10857.49,NULL,NULL,1,'2021-10-05 14:36:57','2021-10-05 14:36:57',NULL),(2068,3117,40779,4574,3,1903,'App\\Models\\Receipt',1903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',299.43,NULL,NULL,1,'2021-10-05 14:36:57','2021-10-05 14:36:57',NULL),(2069,3117,40779,4574,3,1904,'App\\Models\\Receipt',1904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',10857.49,NULL,NULL,1,'2021-10-05 14:36:57','2021-10-05 14:36:57',NULL),(2070,3117,40779,4574,3,1905,'App\\Models\\Receipt',1905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',10857.49,NULL,NULL,1,'2021-10-05 14:36:57','2021-10-05 14:36:57',NULL),(2071,3117,40779,4574,3,1906,'App\\Models\\Receipt',1906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',2859.84,NULL,NULL,1,'2021-10-05 14:36:57','2021-10-05 14:36:57',NULL),(2072,3117,40779,4574,3,1907,'App\\Models\\Receipt',1907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',9999.43,NULL,NULL,1,'2021-10-05 14:36:57','2021-10-05 14:36:57',NULL),(2073,3117,40779,4574,3,1908,'App\\Models\\Receipt',1908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',74283.26,NULL,NULL,1,'2021-10-05 14:36:57','2021-10-05 14:36:57',NULL),(2074,3117,40779,4574,3,1909,'App\\Models\\Receipt',1909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',2859.84,NULL,NULL,1,'2021-10-05 14:36:57','2021-10-05 14:36:57',NULL);
INSERT INTO `balance_libro` VALUES (2075,3117,40779,4574,3,1910,'App\\Models\\Receipt',1910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',29024.29,NULL,NULL,1,'2021-10-05 14:36:57','2021-10-05 14:36:57',NULL),(2076,3117,40779,4574,3,1911,'App\\Models\\Receipt',1911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-18','2021-09-18',34200.00,NULL,NULL,1,'2021-10-05 14:36:57','2021-10-05 14:36:57',NULL),(2077,3117,40779,4574,3,1912,'App\\Models\\Receipt',1912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',2912.00,NULL,NULL,1,'2021-10-05 14:36:57','2021-10-05 14:36:57',NULL),(2078,3117,40779,4574,3,1913,'App\\Models\\Receipt',1913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',8339.09,NULL,NULL,1,'2021-10-05 14:36:57','2021-10-05 14:36:57',NULL),(2079,3117,40779,4574,3,1914,'App\\Models\\Receipt',1914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-24','2021-09-24',12675.84,NULL,NULL,1,'2021-10-05 14:36:57','2021-10-05 14:36:57',NULL),(2080,3117,40779,4574,3,1915,'App\\Models\\Receipt',1915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-24','2021-09-24',54627.21,NULL,NULL,1,'2021-10-05 14:36:57','2021-10-05 14:36:57',NULL),(2081,3117,40779,4574,3,1916,'App\\Models\\Receipt',1916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',3047.66,NULL,NULL,1,'2021-10-05 14:36:57','2021-10-05 14:36:57',NULL),(2082,3117,40779,4574,3,1917,'App\\Models\\Receipt',1917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',3666.60,NULL,NULL,1,'2021-10-05 14:36:57','2021-10-05 14:36:57',NULL),(2083,3117,40779,4574,3,1918,'App\\Models\\Receipt',1918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',14134.16,NULL,NULL,1,'2021-10-05 14:36:57','2021-10-05 14:36:57',NULL),(2084,3117,40779,4574,3,1919,'App\\Models\\Receipt',1919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',2151.00,NULL,NULL,1,'2021-10-05 14:36:57','2021-10-05 14:36:57',NULL),(2085,3117,40779,4574,3,1920,'App\\Models\\Receipt',1920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',19173.65,NULL,NULL,1,'2021-10-05 14:36:57','2021-10-05 14:36:57',NULL),(2086,3117,40779,4574,2,1921,'App\\Models\\Receipt',1921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11','2021-09-11',1450.00,NULL,NULL,1,'2021-10-05 14:38:35','2021-10-05 14:38:35',NULL),(2087,3117,40779,4574,2,1922,'App\\Models\\Receipt',1922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11','2021-09-11',4600.00,NULL,NULL,1,'2021-10-05 14:38:36','2021-10-05 14:38:36',NULL),(2088,3117,40779,4574,2,1923,'App\\Models\\Receipt',1923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11','2021-09-11',4950.00,NULL,NULL,1,'2021-10-05 14:38:36','2021-10-05 14:38:36',NULL),(2089,3117,40779,4574,2,1924,'App\\Models\\Receipt',1924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11','2021-09-11',4820.00,NULL,NULL,1,'2021-10-05 14:38:36','2021-10-05 14:38:36',NULL),(2090,3117,40779,4574,2,1925,'App\\Models\\Receipt',1925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11','2021-09-11',4720.00,NULL,NULL,1,'2021-10-05 14:38:36','2021-10-05 14:38:36',NULL),(2091,3117,40779,4574,2,1926,'App\\Models\\Receipt',1926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11','2021-09-11',4010.00,NULL,NULL,1,'2021-10-05 14:38:36','2021-10-05 14:38:36',NULL),(2092,3117,40779,4574,2,1927,'App\\Models\\Receipt',1927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-12','2021-09-12',4820.00,NULL,NULL,1,'2021-10-05 14:38:36','2021-10-05 14:38:36',NULL),(2093,3117,40779,4574,2,1928,'App\\Models\\Receipt',1928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-12','2021-09-12',4550.00,NULL,NULL,1,'2021-10-05 14:38:36','2021-10-05 14:38:36',NULL),(2094,3117,40779,4574,2,1929,'App\\Models\\Receipt',1929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-12','2021-09-12',1450.00,NULL,NULL,1,'2021-10-05 14:38:36','2021-10-05 14:38:36',NULL),(2095,3117,40779,4574,2,1930,'App\\Models\\Receipt',1930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',4280.00,NULL,NULL,1,'2021-10-05 14:38:36','2021-10-05 14:38:36',NULL);
INSERT INTO `balance_libro` VALUES (2096,3117,40779,4574,2,1931,'App\\Models\\Receipt',1931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',4710.00,NULL,NULL,1,'2021-10-05 14:38:36','2021-10-05 14:38:36',NULL),(2097,3117,40779,4574,2,1932,'App\\Models\\Receipt',1932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',4880.00,NULL,NULL,1,'2021-10-05 14:38:36','2021-10-05 14:38:36',NULL),(2098,3117,40779,4574,2,1933,'App\\Models\\Receipt',1933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',4180.00,NULL,NULL,1,'2021-10-05 14:38:36','2021-10-05 14:38:36',NULL),(2099,3117,40779,4574,2,1934,'App\\Models\\Receipt',1934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',4720.00,NULL,NULL,1,'2021-10-05 14:38:36','2021-10-05 14:38:36',NULL),(2100,3117,40779,4574,2,1935,'App\\Models\\Receipt',1935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',4670.00,NULL,NULL,1,'2021-10-05 14:38:36','2021-10-05 14:38:36',NULL),(2101,3117,40779,4574,2,1936,'App\\Models\\Receipt',1936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',4390.00,NULL,NULL,1,'2021-10-05 14:38:36','2021-10-05 14:38:36',NULL),(2102,3117,40779,4574,2,1937,'App\\Models\\Receipt',1937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',4440.00,NULL,NULL,1,'2021-10-05 14:38:36','2021-10-05 14:38:36',NULL),(2103,3117,40779,4574,2,1938,'App\\Models\\Receipt',1938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',2935.00,NULL,NULL,1,'2021-10-05 14:38:36','2021-10-05 14:38:36',NULL),(2104,3117,40779,4574,2,1939,'App\\Models\\Receipt',1939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',2935.00,NULL,NULL,1,'2021-10-05 14:38:36','2021-10-05 14:38:36',NULL),(2105,3117,40779,4574,2,1940,'App\\Models\\Receipt',1940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',1450.00,NULL,NULL,1,'2021-10-05 14:38:36','2021-10-05 14:38:36',NULL),(2106,3117,40779,4574,2,1941,'App\\Models\\Receipt',1941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-18','2021-09-18',4250.00,NULL,NULL,1,'2021-10-05 14:38:36','2021-10-05 14:38:36',NULL),(2107,3117,40779,4574,2,1942,'App\\Models\\Receipt',1942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-18','2021-09-18',4830.00,NULL,NULL,1,'2021-10-05 14:38:36','2021-10-05 14:38:36',NULL),(2108,3117,40779,4574,2,1943,'App\\Models\\Receipt',1943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-18','2021-09-18',4170.00,NULL,NULL,1,'2021-10-05 14:38:36','2021-10-05 14:38:36',NULL),(2109,3117,40779,4574,2,1944,'App\\Models\\Receipt',1944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',4760.00,NULL,NULL,1,'2021-10-05 14:38:36','2021-10-05 14:38:36',NULL),(2110,3117,40779,4574,2,1945,'App\\Models\\Receipt',1945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',4760.00,NULL,NULL,1,'2021-10-05 14:38:36','2021-10-05 14:38:36',NULL),(2111,3117,40779,4574,2,1946,'App\\Models\\Receipt',1946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',4810.00,NULL,NULL,1,'2021-10-05 14:38:36','2021-10-05 14:38:36',NULL),(2112,3117,40779,4574,2,1947,'App\\Models\\Receipt',1947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',4550.00,NULL,NULL,1,'2021-10-05 14:38:36','2021-10-05 14:38:36',NULL),(2113,3117,40779,4574,2,1948,'App\\Models\\Receipt',1948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',4620.00,NULL,NULL,1,'2021-10-05 14:38:36','2021-10-05 14:38:36',NULL),(2114,3117,40779,4574,2,1949,'App\\Models\\Receipt',1949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',4190.00,NULL,NULL,1,'2021-10-05 14:38:36','2021-10-05 14:38:36',NULL),(2115,3117,40779,4574,2,1950,'App\\Models\\Receipt',1950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',4930.00,NULL,NULL,1,'2021-10-05 14:38:36','2021-10-05 14:38:36',NULL),(2116,3117,40779,4574,2,1951,'App\\Models\\Receipt',1951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',4820.00,NULL,NULL,1,'2021-10-05 14:38:36','2021-10-05 14:38:36',NULL);
INSERT INTO `balance_libro` VALUES (2117,3117,40779,4574,2,1952,'App\\Models\\Receipt',1952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',4860.00,NULL,NULL,1,'2021-10-05 14:38:36','2021-10-05 14:38:36',NULL),(2118,3117,40779,4574,2,1953,'App\\Models\\Receipt',1953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',4620.00,NULL,NULL,1,'2021-10-05 14:38:36','2021-10-05 14:38:36',NULL),(2119,3117,40779,4574,2,1954,'App\\Models\\Receipt',1954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',4310.00,NULL,NULL,1,'2021-10-05 14:38:37','2021-10-05 14:38:37',NULL),(2120,3117,40779,4574,2,1955,'App\\Models\\Receipt',1955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',4130.00,NULL,NULL,1,'2021-10-05 14:38:37','2021-10-05 14:38:37',NULL),(2121,3117,40779,4574,2,1956,'App\\Models\\Receipt',1956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',4130.00,NULL,NULL,1,'2021-10-05 14:38:37','2021-10-05 14:38:37',NULL),(2122,3117,40779,4574,2,1957,'App\\Models\\Receipt',1957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',4131.00,NULL,NULL,1,'2021-10-05 14:38:37','2021-10-05 14:38:37',NULL),(2123,3117,40779,4574,2,1958,'App\\Models\\Receipt',1958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',520.00,NULL,NULL,1,'2021-10-05 14:38:37','2021-10-05 14:38:37',NULL),(2124,3117,40779,4574,2,1959,'App\\Models\\Receipt',1959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',520.00,NULL,NULL,1,'2021-10-05 14:38:37','2021-10-05 14:38:37',NULL),(2125,3117,40779,4574,2,1960,'App\\Models\\Receipt',1960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',4230.00,NULL,NULL,1,'2021-10-05 14:38:37','2021-10-05 14:38:37',NULL),(2126,3117,40779,4574,2,1961,'App\\Models\\Receipt',1961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',4630.00,NULL,NULL,1,'2021-10-05 14:38:37','2021-10-05 14:38:37',NULL),(2127,3117,40779,4574,2,1962,'App\\Models\\Receipt',1962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',4080.00,NULL,NULL,1,'2021-10-05 14:38:37','2021-10-05 14:38:37',NULL),(2128,3117,40779,4574,2,1963,'App\\Models\\Receipt',1963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',4820.00,NULL,NULL,1,'2021-10-05 14:38:37','2021-10-05 14:38:37',NULL),(2129,3117,40779,4574,2,1964,'App\\Models\\Receipt',1964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',4550.00,NULL,NULL,1,'2021-10-05 14:38:37','2021-10-05 14:38:37',NULL),(2130,3117,40779,4574,2,1965,'App\\Models\\Receipt',1965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',4620.00,NULL,NULL,1,'2021-10-05 14:38:37','2021-10-05 14:38:37',NULL),(2131,3117,40779,4574,2,1966,'App\\Models\\Receipt',1966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',4400.00,NULL,NULL,1,'2021-10-05 14:38:37','2021-10-05 14:38:37',NULL),(2132,3117,40779,4574,2,1967,'App\\Models\\Receipt',1967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',4190.00,NULL,NULL,1,'2021-10-05 14:38:37','2021-10-05 14:38:37',NULL),(2133,3117,40779,4574,2,1968,'App\\Models\\Receipt',1968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-26','2021-09-26',4590.00,NULL,NULL,1,'2021-10-05 14:38:37','2021-10-05 14:38:37',NULL),(2134,3117,40779,4574,2,1969,'App\\Models\\Receipt',1969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-26','2021-09-26',4820.00,NULL,NULL,1,'2021-10-05 14:38:37','2021-10-05 14:38:37',NULL),(2135,3117,40779,4574,2,1970,'App\\Models\\Receipt',1970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-26','2021-09-26',4360.00,NULL,NULL,1,'2021-10-05 14:38:37','2021-10-05 14:38:37',NULL),(2136,3117,40779,4574,2,1971,'App\\Models\\Receipt',1971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-26','2021-09-26',4700.00,NULL,NULL,1,'2021-10-05 14:38:37','2021-10-05 14:38:37',NULL),(2137,3117,40779,4574,2,1972,'App\\Models\\Receipt',1972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-26','2021-09-26',4460.00,NULL,NULL,1,'2021-10-05 14:38:37','2021-10-05 14:38:37',NULL);
INSERT INTO `balance_libro` VALUES (2138,3117,40779,4574,2,1973,'App\\Models\\Receipt',1973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-26','2021-09-26',4930.00,NULL,NULL,1,'2021-10-05 14:38:37','2021-10-05 14:38:37',NULL),(2139,3117,40779,4574,2,1974,'App\\Models\\Receipt',1974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-26','2021-09-26',4210.00,NULL,NULL,1,'2021-10-05 14:38:37','2021-10-05 14:38:37',NULL),(2140,3117,40779,4574,2,1975,'App\\Models\\Receipt',1975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-26','2021-09-26',4100.00,NULL,NULL,1,'2021-10-05 14:38:37','2021-10-05 14:38:37',NULL),(2141,3117,40779,4574,2,1976,'App\\Models\\Receipt',1976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-26','2021-09-26',4570.00,NULL,NULL,1,'2021-10-05 14:38:37','2021-10-05 14:38:37',NULL),(2142,3117,40779,4574,2,1977,'App\\Models\\Receipt',1977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-26','2021-09-26',2960.00,NULL,NULL,1,'2021-10-05 14:38:37','2021-10-05 14:38:37',NULL),(2143,3117,40779,4574,2,1978,'App\\Models\\Receipt',1978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',4950.00,NULL,NULL,1,'2021-10-05 14:38:37','2021-10-05 14:38:37',NULL),(2144,3117,40779,4574,2,1979,'App\\Models\\Receipt',1979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',4480.00,NULL,NULL,1,'2021-10-05 14:38:37','2021-10-05 14:38:37',NULL),(2145,3117,40779,4574,2,1980,'App\\Models\\Receipt',1980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',4670.00,NULL,NULL,1,'2021-10-05 14:38:37','2021-10-05 14:38:37',NULL),(2146,3117,40779,4574,2,1981,'App\\Models\\Receipt',1981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',4390.00,NULL,NULL,1,'2021-10-05 14:38:37','2021-10-05 14:38:37',NULL),(2147,3117,40779,4574,2,1982,'App\\Models\\Receipt',1982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',4250.00,NULL,NULL,1,'2021-10-05 14:38:37','2021-10-05 14:38:37',NULL),(2148,3117,40779,4574,2,1983,'App\\Models\\Receipt',1983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',4280.00,NULL,NULL,1,'2021-10-05 14:38:38','2021-10-05 14:38:38',NULL),(2149,3117,40779,4574,2,1984,'App\\Models\\Receipt',1984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',4990.00,NULL,NULL,1,'2021-10-05 14:38:38','2021-10-05 14:38:38',NULL),(2150,3117,40779,4574,2,1985,'App\\Models\\Receipt',1985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',4940.00,NULL,NULL,1,'2021-10-05 14:38:38','2021-10-05 14:38:38',NULL),(2151,3117,40779,4574,2,1986,'App\\Models\\Receipt',1986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',4880.00,NULL,NULL,1,'2021-10-05 14:38:38','2021-10-05 14:38:38',NULL),(2152,3117,40779,4574,2,1987,'App\\Models\\Receipt',1987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',4780.00,NULL,NULL,1,'2021-10-05 14:38:38','2021-10-05 14:38:38',NULL),(2153,3117,40779,4574,2,1988,'App\\Models\\Receipt',1988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',4280.00,NULL,NULL,1,'2021-10-05 14:38:38','2021-10-05 14:38:38',NULL),(2154,3117,40779,4574,2,1989,'App\\Models\\Receipt',1989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',930.00,NULL,NULL,1,'2021-10-05 14:38:38','2021-10-05 14:38:38',NULL),(2155,3117,40728,6080,2,1990,'App\\Models\\Receipt',1990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',45500.00,NULL,NULL,1,'2021-10-05 15:09:26','2021-10-05 15:09:26',NULL),(2156,3117,40728,6080,2,1991,'App\\Models\\Receipt',1991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',4000.00,NULL,NULL,1,'2021-10-05 15:09:26','2021-10-05 15:09:26',NULL),(2157,3117,40728,6080,2,1992,'App\\Models\\Receipt',1992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',5000.00,NULL,NULL,1,'2021-10-05 15:09:26','2021-10-05 15:09:26',NULL),(2158,3117,40728,6080,2,1993,'App\\Models\\Receipt',1993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',10000.00,NULL,NULL,1,'2021-10-05 15:09:26','2021-10-05 15:09:26',NULL);
INSERT INTO `balance_libro` VALUES (2159,3117,40728,6080,2,1994,'App\\Models\\Receipt',1994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',42685.28,NULL,NULL,1,'2021-10-05 15:09:26','2021-10-05 15:09:26',NULL),(2160,3117,40728,6080,2,1995,'App\\Models\\Receipt',1995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11','2021-09-11',5000.00,NULL,NULL,1,'2021-10-05 15:09:26','2021-10-05 15:09:26',NULL),(2161,3117,40728,6080,2,1996,'App\\Models\\Receipt',1996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',100000.00,NULL,NULL,1,'2021-10-05 15:09:26','2021-10-05 15:09:26',NULL),(2162,3117,40728,6080,2,1997,'App\\Models\\Receipt',1997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',30000.00,NULL,NULL,1,'2021-10-05 15:09:26','2021-10-05 15:09:26',NULL),(2163,3117,40728,6080,2,1998,'App\\Models\\Receipt',1998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-18','2021-09-18',35000.00,NULL,NULL,1,'2021-10-05 15:09:26','2021-10-05 15:09:26',NULL),(2164,3117,40728,6080,2,1999,'App\\Models\\Receipt',1999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-24','2021-09-24',37600.00,NULL,NULL,1,'2021-10-05 15:09:26','2021-10-05 15:09:26',NULL),(2165,3117,40728,6080,3,2000,'App\\Models\\Receipt',2000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',3623.26,NULL,NULL,1,'2021-10-05 15:09:40','2021-10-05 15:09:40',NULL),(2166,3117,40728,6080,3,2001,'App\\Models\\Receipt',2001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-04','2021-09-04',3999.00,NULL,NULL,1,'2021-10-05 15:09:40','2021-10-05 15:09:40',NULL),(2167,3117,40728,6080,3,2002,'App\\Models\\Receipt',2002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-04','2021-09-04',3999.00,NULL,NULL,1,'2021-10-05 15:09:40','2021-10-05 15:09:40',NULL),(2168,3117,40728,6080,3,2003,'App\\Models\\Receipt',2003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',19999.00,NULL,NULL,1,'2021-10-05 15:09:40','2021-10-05 15:09:40',NULL),(2169,3117,40728,6080,3,2004,'App\\Models\\Receipt',2004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',19999.00,NULL,NULL,1,'2021-10-05 15:09:40','2021-10-05 15:09:40',NULL),(2170,3117,40728,6080,3,2005,'App\\Models\\Receipt',2005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',19999.00,NULL,NULL,1,'2021-10-05 15:09:40','2021-10-05 15:09:40',NULL),(2171,3117,40728,6080,3,2006,'App\\Models\\Receipt',2006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',4496.76,NULL,NULL,1,'2021-10-05 15:09:40','2021-10-05 15:09:40',NULL),(2172,3117,40728,6080,3,2007,'App\\Models\\Receipt',2007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',19999.00,NULL,NULL,1,'2021-10-05 15:09:40','2021-10-05 15:09:40',NULL),(2173,3117,40728,6080,3,2008,'App\\Models\\Receipt',2008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',15499.00,NULL,NULL,1,'2021-10-05 15:09:40','2021-10-05 15:09:40',NULL),(2174,3117,40728,6080,3,2009,'App\\Models\\Receipt',2009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',9999.00,NULL,NULL,1,'2021-10-05 15:09:40','2021-10-05 15:09:40',NULL),(2175,3117,40728,6080,3,2010,'App\\Models\\Receipt',2010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',15499.00,NULL,NULL,1,'2021-10-05 15:09:40','2021-10-05 15:09:40',NULL),(2176,3117,40728,6080,3,2011,'App\\Models\\Receipt',2011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',15499.00,NULL,NULL,1,'2021-10-05 15:09:41','2021-10-05 15:09:41',NULL),(2177,3117,40728,6080,3,2012,'App\\Models\\Receipt',2012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',15499.00,NULL,NULL,1,'2021-10-05 15:09:41','2021-10-05 15:09:41',NULL),(2178,3117,40728,6080,3,2013,'App\\Models\\Receipt',2013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',3999.00,NULL,NULL,1,'2021-10-05 15:09:41','2021-10-05 15:09:41',NULL),(2179,3117,40728,6080,3,2014,'App\\Models\\Receipt',2014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',15499.00,NULL,NULL,1,'2021-10-05 15:09:41','2021-10-05 15:09:41',NULL);
INSERT INTO `balance_libro` VALUES (2180,3117,40728,6080,3,2015,'App\\Models\\Receipt',2015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',3627.34,NULL,NULL,1,'2021-10-05 15:09:41','2021-10-05 15:09:41',NULL),(2181,3117,40728,6080,3,2016,'App\\Models\\Receipt',2016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',7313.84,NULL,NULL,1,'2021-10-05 15:09:41','2021-10-05 15:09:41',NULL),(2182,3117,40719,11,2,2017,'App\\Models\\Receipt',2017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',27000.00,NULL,NULL,1,'2021-10-06 15:07:13','2021-10-06 15:07:13',NULL),(2183,3117,40719,11,2,2018,'App\\Models\\Receipt',2018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',3017.50,NULL,NULL,1,'2021-10-06 15:07:13','2021-10-06 15:07:13',NULL),(2184,3117,40719,11,2,2019,'App\\Models\\Receipt',2019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',11660.00,NULL,NULL,1,'2021-10-06 15:07:13','2021-10-06 15:07:13',NULL),(2185,3117,40719,11,2,2020,'App\\Models\\Receipt',2020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11','2021-09-11',17600.00,NULL,NULL,1,'2021-10-06 15:07:13','2021-10-06 15:07:13',NULL),(2186,3117,40719,11,2,2021,'App\\Models\\Receipt',2021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',13800.00,NULL,NULL,1,'2021-10-06 15:07:13','2021-10-06 15:07:13',NULL),(2187,3117,40719,11,2,2022,'App\\Models\\Receipt',2022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',28000.00,NULL,NULL,1,'2021-10-06 15:07:13','2021-10-06 15:07:13',NULL),(2188,3117,40719,11,2,2023,'App\\Models\\Receipt',2023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-24','2021-09-24',13000.00,NULL,NULL,1,'2021-10-06 15:07:13','2021-10-06 15:07:13',NULL),(2189,3117,40719,11,2,2024,'App\\Models\\Receipt',2024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-24','2021-09-24',30000.00,NULL,NULL,1,'2021-10-06 15:07:13','2021-10-06 15:07:13',NULL),(2190,3117,40719,11,2,2025,'App\\Models\\Receipt',2025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-24','2021-09-24',12000.00,NULL,NULL,1,'2021-10-06 15:07:13','2021-10-06 15:07:13',NULL),(2191,3117,40719,11,2,2026,'App\\Models\\Receipt',2026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',2500.00,NULL,NULL,1,'2021-10-06 15:07:13','2021-10-06 15:07:13',NULL),(2192,3117,40719,11,3,2027,'App\\Models\\Receipt',2027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',3653.60,NULL,NULL,1,'2021-10-06 15:07:29','2021-10-06 15:07:29',NULL),(2193,3117,40719,11,3,2028,'App\\Models\\Receipt',2028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',2500.01,NULL,NULL,1,'2021-10-06 15:07:29','2021-10-06 15:07:29',NULL),(2194,3117,40719,11,3,2029,'App\\Models\\Receipt',2029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',3833.28,NULL,NULL,1,'2021-10-06 15:07:29','2021-10-06 15:07:29',NULL),(2195,3117,40731,3055,2,2030,'App\\Models\\Receipt',2030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',10336.00,NULL,NULL,1,'2021-10-12 14:58:21','2021-10-12 14:58:21',NULL),(2196,3117,40731,3055,2,2031,'App\\Models\\Receipt',2031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',10336.00,NULL,NULL,1,'2021-10-12 14:58:21','2021-10-12 14:58:21',NULL),(2197,3117,40731,3055,2,2032,'App\\Models\\Receipt',2032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11','2021-09-11',5361.00,NULL,NULL,1,'2021-10-12 14:58:21','2021-10-12 14:58:21',NULL),(2198,3117,40731,3055,2,2033,'App\\Models\\Receipt',2033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11','2021-09-11',9886.00,NULL,NULL,1,'2021-10-12 14:58:21','2021-10-12 14:58:21',NULL),(2199,3117,40731,3055,2,2034,'App\\Models\\Receipt',2034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11','2021-09-11',10036.00,NULL,NULL,1,'2021-10-12 14:58:21','2021-10-12 14:58:21',NULL),(2200,3117,40731,3055,2,2035,'App\\Models\\Receipt',2035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11','2021-09-11',8547.00,NULL,NULL,1,'2021-10-12 14:58:21','2021-10-12 14:58:21',NULL);
INSERT INTO `balance_libro` VALUES (2201,3117,40731,3055,2,2036,'App\\Models\\Receipt',2036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11','2021-09-11',6914.00,NULL,NULL,1,'2021-10-12 14:58:21','2021-10-12 14:58:21',NULL),(2202,3117,40731,3055,2,2037,'App\\Models\\Receipt',2037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11','2021-09-11',13022.00,NULL,NULL,1,'2021-10-12 14:58:21','2021-10-12 14:58:21',NULL),(2203,3117,40731,3055,2,2038,'App\\Models\\Receipt',2038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',12794.00,NULL,NULL,1,'2021-10-12 14:58:22','2021-10-12 14:58:22',NULL),(2204,3117,40731,3055,2,2039,'App\\Models\\Receipt',2039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',11428.00,NULL,NULL,1,'2021-10-12 14:58:22','2021-10-12 14:58:22',NULL),(2205,3117,40731,3055,2,2040,'App\\Models\\Receipt',2040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',6303.00,NULL,NULL,1,'2021-10-12 14:58:22','2021-10-12 14:58:22',NULL),(2206,3117,40731,3055,2,2041,'App\\Models\\Receipt',2041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',11906.00,NULL,NULL,1,'2021-10-12 14:58:22','2021-10-12 14:58:22',NULL),(2207,3117,40731,3055,2,2042,'App\\Models\\Receipt',2042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',7528.00,NULL,NULL,1,'2021-10-12 14:58:22','2021-10-12 14:58:22',NULL),(2208,3117,40731,3055,2,2043,'App\\Models\\Receipt',2043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',11359.00,NULL,NULL,1,'2021-10-12 14:58:22','2021-10-12 14:58:22',NULL),(2209,3117,40731,3055,2,2044,'App\\Models\\Receipt',2044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',11595.00,NULL,NULL,1,'2021-10-12 14:58:22','2021-10-12 14:58:22',NULL),(2210,3117,40731,3055,2,2045,'App\\Models\\Receipt',2045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',9505.00,NULL,NULL,1,'2021-10-12 14:58:22','2021-10-12 14:58:22',NULL),(2211,3117,40731,3055,2,2046,'App\\Models\\Receipt',2046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',8255.00,NULL,NULL,1,'2021-10-12 14:58:22','2021-10-12 14:58:22',NULL),(2212,3117,40731,3055,2,2047,'App\\Models\\Receipt',2047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',11722.00,NULL,NULL,1,'2021-10-12 14:58:22','2021-10-12 14:58:22',NULL),(2213,3117,40731,3055,2,2048,'App\\Models\\Receipt',2048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',11205.00,NULL,NULL,1,'2021-10-12 14:58:22','2021-10-12 14:58:22',NULL),(2214,3117,40731,3055,2,2049,'App\\Models\\Receipt',2049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',8707.00,NULL,NULL,1,'2021-10-12 14:58:22','2021-10-12 14:58:22',NULL),(2215,3117,40731,3055,2,2050,'App\\Models\\Receipt',2050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',11285.00,NULL,NULL,1,'2021-10-12 14:58:22','2021-10-12 14:58:22',NULL),(2216,3117,40731,3055,2,2051,'App\\Models\\Receipt',2051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',11269.00,NULL,NULL,1,'2021-10-12 14:58:22','2021-10-12 14:58:22',NULL),(2217,3117,40731,3055,2,2052,'App\\Models\\Receipt',2052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',5783.00,NULL,NULL,1,'2021-10-12 14:58:22','2021-10-12 14:58:22',NULL),(2218,3117,40731,3055,2,2053,'App\\Models\\Receipt',2053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',5140.00,NULL,NULL,1,'2021-10-12 14:58:22','2021-10-12 14:58:22',NULL),(2219,3117,40731,3055,2,2054,'App\\Models\\Receipt',2054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',11783.00,NULL,NULL,1,'2021-10-12 14:58:22','2021-10-12 14:58:22',NULL),(2220,3117,40731,3055,2,2055,'App\\Models\\Receipt',2055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',12490.00,NULL,NULL,1,'2021-10-12 14:58:22','2021-10-12 14:58:22',NULL),(2221,3117,40731,3055,2,2056,'App\\Models\\Receipt',2056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',5821.00,NULL,NULL,1,'2021-10-12 14:58:22','2021-10-12 14:58:22',NULL);
INSERT INTO `balance_libro` VALUES (2222,3117,40731,3055,2,2057,'App\\Models\\Receipt',2057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',12296.00,NULL,NULL,1,'2021-10-12 14:58:22','2021-10-12 14:58:22',NULL),(2223,3117,40731,3055,2,2058,'App\\Models\\Receipt',2058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',10042.00,NULL,NULL,1,'2021-10-12 14:58:22','2021-10-12 14:58:22',NULL),(2224,3117,40731,3055,2,2059,'App\\Models\\Receipt',2059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',6335.00,NULL,NULL,1,'2021-10-12 14:58:22','2021-10-12 14:58:22',NULL),(2225,3117,40731,3055,2,2060,'App\\Models\\Receipt',2060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-24','2021-09-24',10260.00,NULL,NULL,1,'2021-10-12 14:58:22','2021-10-12 14:58:22',NULL),(2226,3117,40731,3055,2,2061,'App\\Models\\Receipt',2061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-24','2021-09-24',13064.00,NULL,NULL,1,'2021-10-12 14:58:22','2021-10-12 14:58:22',NULL),(2227,3117,40731,3055,2,2062,'App\\Models\\Receipt',2062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-24','2021-09-24',10285.00,NULL,NULL,1,'2021-10-12 14:58:22','2021-10-12 14:58:22',NULL),(2228,3117,40731,3055,2,2063,'App\\Models\\Receipt',2063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-24','2021-09-24',5762.00,NULL,NULL,1,'2021-10-12 14:58:22','2021-10-12 14:58:22',NULL),(2229,3117,40731,3055,2,2064,'App\\Models\\Receipt',2064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',11560.00,NULL,NULL,1,'2021-10-12 14:58:22','2021-10-12 14:58:22',NULL),(2230,3117,40731,3055,2,2065,'App\\Models\\Receipt',2065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',11384.00,NULL,NULL,1,'2021-10-12 14:58:22','2021-10-12 14:58:22',NULL),(2231,3117,40731,3055,2,2066,'App\\Models\\Receipt',2066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',9406.00,NULL,NULL,1,'2021-10-12 14:58:23','2021-10-12 14:58:23',NULL),(2232,3117,40731,3055,2,2067,'App\\Models\\Receipt',2067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',12000.00,NULL,NULL,1,'2021-10-12 14:58:23','2021-10-12 14:58:23',NULL),(2233,3117,40731,3055,2,2068,'App\\Models\\Receipt',2068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',11329.00,NULL,NULL,1,'2021-10-12 14:58:23','2021-10-12 14:58:23',NULL),(2234,3117,40731,3055,2,2069,'App\\Models\\Receipt',2069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',10689.00,NULL,NULL,1,'2021-10-12 14:58:23','2021-10-12 14:58:23',NULL),(2235,3117,40731,3055,2,2070,'App\\Models\\Receipt',2070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',11479.00,NULL,NULL,1,'2021-10-12 14:58:23','2021-10-12 14:58:23',NULL),(2236,3117,40731,3055,2,2071,'App\\Models\\Receipt',2071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',10977.00,NULL,NULL,1,'2021-10-12 14:58:23','2021-10-12 14:58:23',NULL),(2237,3117,40731,3055,2,2072,'App\\Models\\Receipt',2072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',11080.00,NULL,NULL,1,'2021-10-12 14:58:23','2021-10-12 14:58:23',NULL),(2238,3117,40731,3055,2,2073,'App\\Models\\Receipt',2073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',11137.00,NULL,NULL,1,'2021-10-12 14:58:23','2021-10-12 14:58:23',NULL),(2239,3117,40731,3055,2,2074,'App\\Models\\Receipt',2074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',12702.00,NULL,NULL,1,'2021-10-12 14:58:23','2021-10-12 14:58:23',NULL),(2240,3117,40731,3055,2,2075,'App\\Models\\Receipt',2075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',11777.00,NULL,NULL,1,'2021-10-12 14:58:23','2021-10-12 14:58:23',NULL),(2241,3117,40731,3055,2,2076,'App\\Models\\Receipt',2076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',13016.00,NULL,NULL,1,'2021-10-12 14:58:23','2021-10-12 14:58:23',NULL),(2242,3117,40731,3055,2,2077,'App\\Models\\Receipt',2077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',13008.00,NULL,NULL,1,'2021-10-12 14:58:23','2021-10-12 14:58:23',NULL);
INSERT INTO `balance_libro` VALUES (2243,3117,40731,3055,2,2078,'App\\Models\\Receipt',2078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',10216.50,NULL,NULL,1,'2021-10-12 14:58:23','2021-10-12 14:58:23',NULL),(2244,3117,40731,3055,2,2079,'App\\Models\\Receipt',2079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',11610.00,NULL,NULL,1,'2021-10-12 14:58:23','2021-10-12 14:58:23',NULL),(2245,3117,40731,3055,2,2080,'App\\Models\\Receipt',2080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',9249.00,NULL,NULL,1,'2021-10-12 14:58:23','2021-10-12 14:58:23',NULL),(2246,3117,40731,3055,2,2081,'App\\Models\\Receipt',2081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',1500.00,NULL,NULL,1,'2021-10-12 14:58:23','2021-10-12 14:58:23',NULL),(2247,3117,40731,3055,3,2082,'App\\Models\\Receipt',2082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',11849.58,NULL,NULL,1,'2021-10-12 14:58:47','2021-10-12 14:58:47',NULL),(2248,3117,40731,3055,3,2083,'App\\Models\\Receipt',2083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',2440.45,NULL,NULL,1,'2021-10-12 14:58:47','2021-10-12 14:58:47',NULL),(2249,3117,40731,3055,3,2084,'App\\Models\\Receipt',2084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',6462.34,NULL,NULL,1,'2021-10-12 14:58:47','2021-10-12 14:58:47',NULL),(2250,3117,40731,3055,3,2085,'App\\Models\\Receipt',2085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-04','2021-09-04',15203.20,NULL,NULL,1,'2021-10-12 14:58:47','2021-10-12 14:58:47',NULL),(2251,3117,40731,3055,3,2086,'App\\Models\\Receipt',2086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-05','2021-09-05',800.00,NULL,NULL,1,'2021-10-12 14:58:47','2021-10-12 14:58:47',NULL),(2252,3117,40731,3055,3,2087,'App\\Models\\Receipt',2087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',5735.27,NULL,NULL,1,'2021-10-12 14:58:47','2021-10-12 14:58:47',NULL),(2253,3117,40731,3055,3,2088,'App\\Models\\Receipt',2088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',5808.65,NULL,NULL,1,'2021-10-12 14:58:47','2021-10-12 14:58:47',NULL),(2254,3117,40731,3055,3,2089,'App\\Models\\Receipt',2089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',4569.29,NULL,NULL,1,'2021-10-12 14:58:47','2021-10-12 14:58:47',NULL),(2255,3117,40731,3055,3,2090,'App\\Models\\Receipt',2090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',9749.04,NULL,NULL,1,'2021-10-12 14:58:47','2021-10-12 14:58:47',NULL),(2256,3117,40731,3055,3,2091,'App\\Models\\Receipt',2091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',2654.07,NULL,NULL,1,'2021-10-12 14:58:47','2021-10-12 14:58:47',NULL),(2257,3117,40731,3055,3,2092,'App\\Models\\Receipt',2092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',8250.70,NULL,NULL,1,'2021-10-12 14:58:47','2021-10-12 14:58:47',NULL),(2258,3117,40731,3055,3,2093,'App\\Models\\Receipt',2093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',2016.02,NULL,NULL,1,'2021-10-12 14:58:47','2021-10-12 14:58:47',NULL),(2259,3117,40731,3055,3,2094,'App\\Models\\Receipt',2094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',2016.02,NULL,NULL,1,'2021-10-12 14:58:47','2021-10-12 14:58:47',NULL),(2260,3117,40731,3055,3,2095,'App\\Models\\Receipt',2095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-18','2021-09-18',13351.80,NULL,NULL,1,'2021-10-12 14:58:47','2021-10-12 14:58:47',NULL),(2261,3117,40731,3055,3,2096,'App\\Models\\Receipt',2096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',8250.70,NULL,NULL,1,'2021-10-12 14:58:47','2021-10-12 14:58:47',NULL),(2262,3117,40731,3055,3,2097,'App\\Models\\Receipt',2097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',7659.50,NULL,NULL,1,'2021-10-12 14:58:47','2021-10-12 14:58:47',NULL),(2263,3117,40731,3055,3,2098,'App\\Models\\Receipt',2098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',14715.78,NULL,NULL,1,'2021-10-12 14:58:47','2021-10-12 14:58:47',NULL);
INSERT INTO `balance_libro` VALUES (2264,3117,40731,3055,3,2099,'App\\Models\\Receipt',2099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',753.18,NULL,NULL,1,'2021-10-12 14:58:47','2021-10-12 14:58:47',NULL),(2265,3117,40731,3055,3,2100,'App\\Models\\Receipt',2100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-24','2021-09-24',7673.52,NULL,NULL,1,'2021-10-12 14:58:48','2021-10-12 14:58:48',NULL),(2266,3117,40731,3055,3,2101,'App\\Models\\Receipt',2101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-24','2021-09-24',4377.53,NULL,NULL,1,'2021-10-12 14:58:48','2021-10-12 14:58:48',NULL),(2267,3117,40731,3055,3,2102,'App\\Models\\Receipt',2102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',6339.67,NULL,NULL,1,'2021-10-12 14:58:48','2021-10-12 14:58:48',NULL),(2268,3117,40731,3055,3,2103,'App\\Models\\Receipt',2103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-26','2021-09-26',11020.00,NULL,NULL,1,'2021-10-12 14:58:48','2021-10-12 14:58:48',NULL),(2269,3117,40731,3055,3,2104,'App\\Models\\Receipt',2104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',3024.23,NULL,NULL,1,'2021-10-12 14:58:48','2021-10-12 14:58:48',NULL),(2270,3117,40731,3055,3,2105,'App\\Models\\Receipt',2105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',18624.19,NULL,NULL,1,'2021-10-12 14:58:48','2021-10-12 14:58:48',NULL),(2271,3117,40731,3055,3,2106,'App\\Models\\Receipt',2106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',8117.77,NULL,NULL,1,'2021-10-12 14:58:48','2021-10-12 14:58:48',NULL),(2272,3117,40731,3055,3,2107,'App\\Models\\Receipt',2107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',413.64,NULL,NULL,1,'2021-10-12 14:58:48','2021-10-12 14:58:48',NULL),(2273,3117,40731,3055,3,2108,'App\\Models\\Receipt',2108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',5947.96,NULL,NULL,1,'2021-10-12 14:58:48','2021-10-12 14:58:48',NULL),(2274,3117,40731,3055,3,2109,'App\\Models\\Receipt',2109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',1647.17,NULL,NULL,1,'2021-10-12 14:58:48','2021-10-12 14:58:48',NULL),(2275,3117,40736,1545,2,2110,'App\\Models\\Receipt',2110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',35017.00,NULL,NULL,1,'2021-10-12 15:18:59','2021-10-12 15:18:59',NULL),(2276,3117,40736,1545,3,2111,'App\\Models\\Receipt',2111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',6795.00,NULL,NULL,1,'2021-10-12 15:19:24','2021-10-12 15:19:24',NULL),(2277,3117,40736,1545,3,2112,'App\\Models\\Receipt',2112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',40608.75,NULL,NULL,1,'2021-10-12 15:19:24','2021-10-12 15:19:24',NULL),(2278,3117,40845,11735,2,2113,'App\\Models\\Receipt',2113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',1580.00,NULL,NULL,1,'2021-10-14 15:38:53','2021-10-14 15:38:53',NULL),(2279,3117,40845,11735,2,2114,'App\\Models\\Receipt',2114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',760.00,NULL,NULL,1,'2021-10-14 15:38:53','2021-10-14 15:38:53',NULL),(2280,3117,40845,11735,2,2115,'App\\Models\\Receipt',2115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',1830.00,NULL,NULL,1,'2021-10-14 15:38:53','2021-10-14 15:38:53',NULL),(2281,3117,40845,11735,2,2116,'App\\Models\\Receipt',2116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',2130.00,NULL,NULL,1,'2021-10-14 15:38:53','2021-10-14 15:38:53',NULL),(2282,3117,40845,11735,2,2117,'App\\Models\\Receipt',2117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',1240.00,NULL,NULL,1,'2021-10-14 15:38:53','2021-10-14 15:38:53',NULL),(2283,3117,40845,11735,2,2118,'App\\Models\\Receipt',2118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',650.00,NULL,NULL,1,'2021-10-14 15:38:53','2021-10-14 15:38:53',NULL),(2284,3117,40845,11735,2,2119,'App\\Models\\Receipt',2119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',1800.00,NULL,NULL,1,'2021-10-14 15:38:53','2021-10-14 15:38:53',NULL);
INSERT INTO `balance_libro` VALUES (2285,3117,40845,11735,2,2120,'App\\Models\\Receipt',2120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',1520.00,NULL,NULL,1,'2021-10-14 15:38:53','2021-10-14 15:38:53',NULL),(2286,3117,40845,11735,2,2121,'App\\Models\\Receipt',2121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',1750.00,NULL,NULL,1,'2021-10-14 15:38:53','2021-10-14 15:38:53',NULL),(2287,3117,40845,11735,2,2122,'App\\Models\\Receipt',2122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',1340.00,NULL,NULL,1,'2021-10-14 15:38:53','2021-10-14 15:38:53',NULL),(2288,3117,40845,11735,2,2123,'App\\Models\\Receipt',2123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',1125.00,NULL,NULL,1,'2021-10-14 15:38:53','2021-10-14 15:38:53',NULL),(2289,3117,40845,11735,2,2124,'App\\Models\\Receipt',2124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',1900.00,NULL,NULL,1,'2021-10-14 15:38:53','2021-10-14 15:38:53',NULL),(2290,3117,40845,11735,2,2125,'App\\Models\\Receipt',2125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',2680.00,NULL,NULL,1,'2021-10-14 15:38:53','2021-10-14 15:38:53',NULL),(2291,3117,40845,11735,2,2126,'App\\Models\\Receipt',2126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',1250.00,NULL,NULL,1,'2021-10-14 15:38:53','2021-10-14 15:38:53',NULL),(2292,3117,40845,11735,2,2127,'App\\Models\\Receipt',2127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',850.00,NULL,NULL,1,'2021-10-14 15:38:53','2021-10-14 15:38:53',NULL),(2293,3117,40845,11735,2,2128,'App\\Models\\Receipt',2128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',1000.00,NULL,NULL,1,'2021-10-14 15:38:53','2021-10-14 15:38:53',NULL),(2294,3117,40845,11735,2,2129,'App\\Models\\Receipt',2129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',3200.00,NULL,NULL,1,'2021-10-14 15:38:53','2021-10-14 15:38:53',NULL),(2295,3117,40845,11735,2,2130,'App\\Models\\Receipt',2130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-04','2021-09-04',1500.00,NULL,NULL,1,'2021-10-14 15:38:53','2021-10-14 15:38:53',NULL),(2296,3117,40845,11735,2,2131,'App\\Models\\Receipt',2131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-04','2021-09-04',1680.00,NULL,NULL,1,'2021-10-14 15:38:53','2021-10-14 15:38:53',NULL),(2297,3117,40845,11735,2,2132,'App\\Models\\Receipt',2132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-04','2021-09-04',860.00,NULL,NULL,1,'2021-10-14 15:38:53','2021-10-14 15:38:53',NULL),(2298,3117,40845,11735,2,2133,'App\\Models\\Receipt',2133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-04','2021-09-04',1200.00,NULL,NULL,1,'2021-10-14 15:38:53','2021-10-14 15:38:53',NULL),(2299,3117,40845,11735,2,2134,'App\\Models\\Receipt',2134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-04','2021-09-04',1870.00,NULL,NULL,1,'2021-10-14 15:38:54','2021-10-14 15:38:54',NULL),(2300,3117,40845,11735,2,2135,'App\\Models\\Receipt',2135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-04','2021-09-04',910.00,NULL,NULL,1,'2021-10-14 15:38:54','2021-10-14 15:38:54',NULL),(2301,3117,40845,11735,2,2136,'App\\Models\\Receipt',2136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-04','2021-09-04',1530.00,NULL,NULL,1,'2021-10-14 15:38:54','2021-10-14 15:38:54',NULL),(2302,3117,40845,11735,2,2137,'App\\Models\\Receipt',2137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-05','2021-09-05',1300.00,NULL,NULL,1,'2021-10-14 15:38:54','2021-10-14 15:38:54',NULL),(2303,3117,40845,11735,2,2138,'App\\Models\\Receipt',2138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-05','2021-09-05',1880.00,NULL,NULL,1,'2021-10-14 15:38:54','2021-10-14 15:38:54',NULL),(2304,3117,40845,11735,2,2139,'App\\Models\\Receipt',2139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-05','2021-09-05',1260.00,NULL,NULL,1,'2021-10-14 15:38:54','2021-10-14 15:38:54',NULL),(2305,3117,40845,11735,2,2140,'App\\Models\\Receipt',2140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-05','2021-09-05',500.00,NULL,NULL,1,'2021-10-14 15:38:54','2021-10-14 15:38:54',NULL);
INSERT INTO `balance_libro` VALUES (2306,3117,40845,11735,2,2141,'App\\Models\\Receipt',2141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-05','2021-09-05',1385.00,NULL,NULL,1,'2021-10-14 15:38:54','2021-10-14 15:38:54',NULL),(2307,3117,40845,11735,2,2142,'App\\Models\\Receipt',2142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-05','2021-09-05',1120.00,NULL,NULL,1,'2021-10-14 15:38:54','2021-10-14 15:38:54',NULL),(2308,3117,40845,11735,2,2143,'App\\Models\\Receipt',2143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-05','2021-09-05',1200.00,NULL,NULL,1,'2021-10-14 15:38:54','2021-10-14 15:38:54',NULL),(2309,3117,40845,11735,2,2144,'App\\Models\\Receipt',2144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',1320.00,NULL,NULL,1,'2021-10-14 15:38:54','2021-10-14 15:38:54',NULL),(2310,3117,40845,11735,2,2145,'App\\Models\\Receipt',2145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',970.00,NULL,NULL,1,'2021-10-14 15:38:54','2021-10-14 15:38:54',NULL),(2311,3117,40845,11735,2,2146,'App\\Models\\Receipt',2146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',1890.00,NULL,NULL,1,'2021-10-14 15:38:54','2021-10-14 15:38:54',NULL),(2312,3117,40845,11735,2,2147,'App\\Models\\Receipt',2147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',1500.00,NULL,NULL,1,'2021-10-14 15:38:54','2021-10-14 15:38:54',NULL),(2313,3117,40845,11735,2,2148,'App\\Models\\Receipt',2148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',1270.00,NULL,NULL,1,'2021-10-14 15:38:54','2021-10-14 15:38:54',NULL),(2314,3117,40845,11735,2,2149,'App\\Models\\Receipt',2149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',1400.00,NULL,NULL,1,'2021-10-14 15:38:54','2021-10-14 15:38:54',NULL),(2315,3117,40845,11735,2,2150,'App\\Models\\Receipt',2150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',2600.00,NULL,NULL,1,'2021-10-14 15:38:54','2021-10-14 15:38:54',NULL),(2316,3117,40845,11735,2,2151,'App\\Models\\Receipt',2151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',1725.00,NULL,NULL,1,'2021-10-14 15:38:54','2021-10-14 15:38:54',NULL),(2317,3117,40845,11735,2,2152,'App\\Models\\Receipt',2152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',1050.00,NULL,NULL,1,'2021-10-14 15:38:54','2021-10-14 15:38:54',NULL),(2318,3117,40845,11735,2,2153,'App\\Models\\Receipt',2153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',640.00,NULL,NULL,1,'2021-10-14 15:38:54','2021-10-14 15:38:54',NULL),(2319,3117,40845,11735,2,2154,'App\\Models\\Receipt',2154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',1250.00,NULL,NULL,1,'2021-10-14 15:38:54','2021-10-14 15:38:54',NULL),(2320,3117,40845,11735,2,2155,'App\\Models\\Receipt',2155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',2160.00,NULL,NULL,1,'2021-10-14 15:38:54','2021-10-14 15:38:54',NULL),(2321,3117,40845,11735,2,2156,'App\\Models\\Receipt',2156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',1530.00,NULL,NULL,1,'2021-10-14 15:38:54','2021-10-14 15:38:54',NULL),(2322,3117,40845,11735,2,2157,'App\\Models\\Receipt',2157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',980.00,NULL,NULL,1,'2021-10-14 15:38:54','2021-10-14 15:38:54',NULL),(2323,3117,40845,11735,2,2158,'App\\Models\\Receipt',2158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',1120.00,NULL,NULL,1,'2021-10-14 15:38:54','2021-10-14 15:38:54',NULL),(2324,3117,40845,11735,2,2159,'App\\Models\\Receipt',2159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',1570.00,NULL,NULL,1,'2021-10-14 15:38:54','2021-10-14 15:38:54',NULL),(2325,3117,40845,11735,2,2160,'App\\Models\\Receipt',2160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',890.00,NULL,NULL,1,'2021-10-14 15:38:55','2021-10-14 15:38:55',NULL),(2326,3117,40845,11735,2,2161,'App\\Models\\Receipt',2161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',1600.00,NULL,NULL,1,'2021-10-14 15:38:55','2021-10-14 15:38:55',NULL);
INSERT INTO `balance_libro` VALUES (2327,3117,40845,11735,2,2162,'App\\Models\\Receipt',2162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',1350.00,NULL,NULL,1,'2021-10-14 15:38:55','2021-10-14 15:38:55',NULL),(2328,3117,40845,11735,2,2163,'App\\Models\\Receipt',2163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',1930.00,NULL,NULL,1,'2021-10-14 15:38:55','2021-10-14 15:38:55',NULL),(2329,3117,40845,11735,2,2164,'App\\Models\\Receipt',2164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',1060.00,NULL,NULL,1,'2021-10-14 15:38:55','2021-10-14 15:38:55',NULL),(2330,3117,40845,11735,2,2165,'App\\Models\\Receipt',2165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',1725.00,NULL,NULL,1,'2021-10-14 15:38:55','2021-10-14 15:38:55',NULL),(2331,3117,40845,11735,2,2166,'App\\Models\\Receipt',2166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',1300.00,NULL,NULL,1,'2021-10-14 15:38:55','2021-10-14 15:38:55',NULL),(2332,3117,40845,11735,2,2167,'App\\Models\\Receipt',2167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',720.00,NULL,NULL,1,'2021-10-14 15:38:55','2021-10-14 15:38:55',NULL),(2333,3117,40845,11735,2,2168,'App\\Models\\Receipt',2168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',1290.00,NULL,NULL,1,'2021-10-14 15:38:55','2021-10-14 15:38:55',NULL),(2334,3117,40845,11735,2,2169,'App\\Models\\Receipt',2169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11','2021-09-11',3700.00,NULL,NULL,1,'2021-10-14 15:38:55','2021-10-14 15:38:55',NULL),(2335,3117,40845,11735,2,2170,'App\\Models\\Receipt',2170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11','2021-09-11',2130.00,NULL,NULL,1,'2021-10-14 15:38:55','2021-10-14 15:38:55',NULL),(2336,3117,40845,11735,2,2171,'App\\Models\\Receipt',2171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11','2021-09-11',1500.00,NULL,NULL,1,'2021-10-14 15:38:55','2021-10-14 15:38:55',NULL),(2337,3117,40845,11735,2,2172,'App\\Models\\Receipt',2172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-12','2021-09-12',1670.00,NULL,NULL,1,'2021-10-14 15:38:55','2021-10-14 15:38:55',NULL),(2338,3117,40845,11735,2,2173,'App\\Models\\Receipt',2173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-12','2021-09-12',1260.00,NULL,NULL,1,'2021-10-14 15:38:55','2021-10-14 15:38:55',NULL),(2339,3117,40845,11735,2,2174,'App\\Models\\Receipt',2174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-12','2021-09-12',680.00,NULL,NULL,1,'2021-10-14 15:38:55','2021-10-14 15:38:55',NULL),(2340,3117,40845,11735,2,2175,'App\\Models\\Receipt',2175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-12','2021-09-12',1490.00,NULL,NULL,1,'2021-10-14 15:38:55','2021-10-14 15:38:55',NULL),(2341,3117,40845,11735,2,2176,'App\\Models\\Receipt',2176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-12','2021-09-12',900.00,NULL,NULL,1,'2021-10-14 15:38:55','2021-10-14 15:38:55',NULL),(2342,3117,40845,11735,2,2177,'App\\Models\\Receipt',2177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-12','2021-09-12',1230.00,NULL,NULL,1,'2021-10-14 15:38:55','2021-10-14 15:38:55',NULL),(2343,3117,40845,11735,2,2178,'App\\Models\\Receipt',2178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',1460.00,NULL,NULL,1,'2021-10-14 15:38:55','2021-10-14 15:38:55',NULL),(2344,3117,40845,11735,2,2179,'App\\Models\\Receipt',2179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',1690.00,NULL,NULL,1,'2021-10-14 15:38:55','2021-10-14 15:38:55',NULL),(2345,3117,40845,11735,2,2180,'App\\Models\\Receipt',2180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',2250.00,NULL,NULL,1,'2021-10-14 15:38:55','2021-10-14 15:38:55',NULL),(2346,3117,40845,11735,2,2181,'App\\Models\\Receipt',2181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',1970.00,NULL,NULL,1,'2021-10-14 15:38:55','2021-10-14 15:38:55',NULL),(2347,3117,40845,11735,2,2182,'App\\Models\\Receipt',2182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',950.00,NULL,NULL,1,'2021-10-14 15:38:55','2021-10-14 15:38:55',NULL);
INSERT INTO `balance_libro` VALUES (2348,3117,40845,11735,2,2183,'App\\Models\\Receipt',2183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',1360.00,NULL,NULL,1,'2021-10-14 15:38:55','2021-10-14 15:38:55',NULL),(2349,3117,40845,11735,2,2184,'App\\Models\\Receipt',2184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',2340.00,NULL,NULL,1,'2021-10-14 15:38:55','2021-10-14 15:38:55',NULL),(2350,3117,40845,11735,2,2185,'App\\Models\\Receipt',2185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',1930.00,NULL,NULL,1,'2021-10-14 15:38:55','2021-10-14 15:38:55',NULL),(2351,3117,40845,11735,2,2186,'App\\Models\\Receipt',2186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',1365.00,NULL,NULL,1,'2021-10-14 15:38:55','2021-10-14 15:38:55',NULL),(2352,3117,40845,11735,2,2187,'App\\Models\\Receipt',2187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',3250.00,NULL,NULL,1,'2021-10-14 15:38:55','2021-10-14 15:38:55',NULL),(2353,3117,40845,11735,2,2188,'App\\Models\\Receipt',2188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',1860.00,NULL,NULL,1,'2021-10-14 15:38:56','2021-10-14 15:38:56',NULL),(2354,3117,40845,11735,2,2189,'App\\Models\\Receipt',2189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',1500.00,NULL,NULL,1,'2021-10-14 15:38:56','2021-10-14 15:38:56',NULL),(2355,3117,40845,11735,2,2190,'App\\Models\\Receipt',2190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',2100.00,NULL,NULL,1,'2021-10-14 15:38:56','2021-10-14 15:38:56',NULL),(2356,3117,40845,11735,2,2191,'App\\Models\\Receipt',2191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',1210.00,NULL,NULL,1,'2021-10-14 15:38:56','2021-10-14 15:38:56',NULL),(2357,3117,40845,11735,2,2192,'App\\Models\\Receipt',2192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',1250.00,NULL,NULL,1,'2021-10-14 15:38:56','2021-10-14 15:38:56',NULL),(2358,3117,40845,11735,2,2193,'App\\Models\\Receipt',2193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',1700.00,NULL,NULL,1,'2021-10-14 15:38:56','2021-10-14 15:38:56',NULL),(2359,3117,40845,11735,2,2194,'App\\Models\\Receipt',2194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',1380.00,NULL,NULL,1,'2021-10-14 15:38:56','2021-10-14 15:38:56',NULL),(2360,3117,40845,11735,2,2195,'App\\Models\\Receipt',2195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',500.00,NULL,NULL,1,'2021-10-14 15:38:56','2021-10-14 15:38:56',NULL),(2361,3117,40845,11735,2,2196,'App\\Models\\Receipt',2196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',1980.00,NULL,NULL,1,'2021-10-14 15:38:56','2021-10-14 15:38:56',NULL),(2362,3117,40845,11735,2,2197,'App\\Models\\Receipt',2197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-18','2021-09-18',1260.00,NULL,NULL,1,'2021-10-14 15:38:56','2021-10-14 15:38:56',NULL),(2363,3117,40845,11735,2,2198,'App\\Models\\Receipt',2198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-18','2021-09-18',1850.00,NULL,NULL,1,'2021-10-14 15:38:56','2021-10-14 15:38:56',NULL),(2364,3117,40845,11735,2,2199,'App\\Models\\Receipt',2199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-18','2021-09-18',1520.00,NULL,NULL,1,'2021-10-14 15:38:56','2021-10-14 15:38:56',NULL),(2365,3117,40845,11735,2,2200,'App\\Models\\Receipt',2200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-18','2021-09-18',930.00,NULL,NULL,1,'2021-10-14 15:38:56','2021-10-14 15:38:56',NULL),(2366,3117,40845,11735,2,2201,'App\\Models\\Receipt',2201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-18','2021-09-18',1120.00,NULL,NULL,1,'2021-10-14 15:38:56','2021-10-14 15:38:56',NULL),(2367,3117,40845,11735,2,2202,'App\\Models\\Receipt',2202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-18','2021-09-18',780.00,NULL,NULL,1,'2021-10-14 15:38:56','2021-10-14 15:38:56',NULL),(2368,3117,40845,11735,2,2203,'App\\Models\\Receipt',2203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',1530.00,NULL,NULL,1,'2021-10-14 15:38:56','2021-10-14 15:38:56',NULL);
INSERT INTO `balance_libro` VALUES (2369,3117,40845,11735,2,2204,'App\\Models\\Receipt',2204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',1290.00,NULL,NULL,1,'2021-10-14 15:38:56','2021-10-14 15:38:56',NULL),(2370,3117,40845,11735,2,2205,'App\\Models\\Receipt',2205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',760.00,NULL,NULL,1,'2021-10-14 15:38:56','2021-10-14 15:38:56',NULL),(2371,3117,40845,11735,2,2206,'App\\Models\\Receipt',2206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',1160.00,NULL,NULL,1,'2021-10-14 15:38:56','2021-10-14 15:38:56',NULL),(2372,3117,40845,11735,2,2207,'App\\Models\\Receipt',2207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',2460.00,NULL,NULL,1,'2021-10-14 15:38:56','2021-10-14 15:38:56',NULL),(2373,3117,40845,11735,2,2208,'App\\Models\\Receipt',2208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',870.00,NULL,NULL,1,'2021-10-14 15:38:56','2021-10-14 15:38:56',NULL),(2374,3117,40845,11735,2,2209,'App\\Models\\Receipt',2209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',1130.00,NULL,NULL,1,'2021-10-14 15:38:56','2021-10-14 15:38:56',NULL),(2375,3117,40845,11735,2,2210,'App\\Models\\Receipt',2210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',430.00,NULL,NULL,1,'2021-10-14 15:38:56','2021-10-14 15:38:56',NULL),(2376,3117,40845,11735,2,2211,'App\\Models\\Receipt',2211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',1270.00,NULL,NULL,1,'2021-10-14 15:38:56','2021-10-14 15:38:56',NULL),(2377,3117,40845,11735,2,2212,'App\\Models\\Receipt',2212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',1800.00,NULL,NULL,1,'2021-10-14 15:38:56','2021-10-14 15:38:56',NULL),(2378,3117,40845,11735,2,2213,'App\\Models\\Receipt',2213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',1570.00,NULL,NULL,1,'2021-10-14 15:38:56','2021-10-14 15:38:56',NULL),(2379,3117,40845,11735,2,2214,'App\\Models\\Receipt',2214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',1850.00,NULL,NULL,1,'2021-10-14 15:38:56','2021-10-14 15:38:56',NULL),(2380,3117,40845,11735,2,2215,'App\\Models\\Receipt',2215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',1245.00,NULL,NULL,1,'2021-10-14 15:38:57','2021-10-14 15:38:57',NULL),(2381,3117,40845,11735,2,2216,'App\\Models\\Receipt',2216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',770.00,NULL,NULL,1,'2021-10-14 15:38:57','2021-10-14 15:38:57',NULL),(2382,3117,40845,11735,2,2217,'App\\Models\\Receipt',2217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',1500.00,NULL,NULL,1,'2021-10-14 15:38:57','2021-10-14 15:38:57',NULL),(2383,3117,40845,11735,2,2218,'App\\Models\\Receipt',2218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',1180.00,NULL,NULL,1,'2021-10-14 15:38:57','2021-10-14 15:38:57',NULL),(2384,3117,40845,11735,2,2219,'App\\Models\\Receipt',2219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',1900.00,NULL,NULL,1,'2021-10-14 15:38:57','2021-10-14 15:38:57',NULL),(2385,3117,40845,11735,2,2220,'App\\Models\\Receipt',2220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',2870.00,NULL,NULL,1,'2021-10-14 15:38:57','2021-10-14 15:38:57',NULL),(2386,3117,40845,11735,2,2221,'App\\Models\\Receipt',2221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',2700.00,NULL,NULL,1,'2021-10-14 15:38:57','2021-10-14 15:38:57',NULL),(2387,3117,40845,11735,2,2222,'App\\Models\\Receipt',2222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',3100.00,NULL,NULL,1,'2021-10-14 15:38:57','2021-10-14 15:38:57',NULL),(2388,3117,40845,11735,2,2223,'App\\Models\\Receipt',2223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-24','2021-09-24',1490.00,NULL,NULL,1,'2021-10-14 15:38:57','2021-10-14 15:38:57',NULL),(2389,3117,40845,11735,2,2224,'App\\Models\\Receipt',2224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-24','2021-09-24',2650.00,NULL,NULL,1,'2021-10-14 15:38:57','2021-10-14 15:38:57',NULL);
INSERT INTO `balance_libro` VALUES (2390,3117,40845,11735,2,2225,'App\\Models\\Receipt',2225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-24','2021-09-24',1840.00,NULL,NULL,1,'2021-10-14 15:38:57','2021-10-14 15:38:57',NULL),(2391,3117,40845,11735,2,2226,'App\\Models\\Receipt',2226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-24','2021-09-24',1320.00,NULL,NULL,1,'2021-10-14 15:38:57','2021-10-14 15:38:57',NULL),(2392,3117,40845,11735,2,2227,'App\\Models\\Receipt',2227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',1800.00,NULL,NULL,1,'2021-10-14 15:38:57','2021-10-14 15:38:57',NULL),(2393,3117,40845,11735,2,2228,'App\\Models\\Receipt',2228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',1375.00,NULL,NULL,1,'2021-10-14 15:38:57','2021-10-14 15:38:57',NULL),(2394,3117,40845,11735,2,2229,'App\\Models\\Receipt',2229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',1630.00,NULL,NULL,1,'2021-10-14 15:38:57','2021-10-14 15:38:57',NULL),(2395,3117,40845,11735,2,2230,'App\\Models\\Receipt',2230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',980.00,NULL,NULL,1,'2021-10-14 15:38:57','2021-10-14 15:38:57',NULL),(2396,3117,40845,11735,2,2231,'App\\Models\\Receipt',2231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',1120.00,NULL,NULL,1,'2021-10-14 15:38:57','2021-10-14 15:38:57',NULL),(2397,3117,40845,11735,2,2232,'App\\Models\\Receipt',2232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-26','2021-09-26',1580.00,NULL,NULL,1,'2021-10-14 15:38:57','2021-10-14 15:38:57',NULL),(2398,3117,40845,11735,2,2233,'App\\Models\\Receipt',2233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-26','2021-09-26',1230.00,NULL,NULL,1,'2021-10-14 15:38:57','2021-10-14 15:38:57',NULL),(2399,3117,40845,11735,2,2234,'App\\Models\\Receipt',2234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-26','2021-09-26',1900.00,NULL,NULL,1,'2021-10-14 15:38:57','2021-10-14 15:38:57',NULL),(2400,3117,40845,11735,2,2235,'App\\Models\\Receipt',2235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-26','2021-09-26',960.00,NULL,NULL,1,'2021-10-14 15:38:57','2021-10-14 15:38:57',NULL),(2401,3117,40845,11735,2,2236,'App\\Models\\Receipt',2236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-26','2021-09-26',1990.00,NULL,NULL,1,'2021-10-14 15:38:57','2021-10-14 15:38:57',NULL),(2402,3117,40845,11735,2,2237,'App\\Models\\Receipt',2237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',1770.00,NULL,NULL,1,'2021-10-14 15:38:57','2021-10-14 15:38:57',NULL),(2403,3117,40845,11735,2,2238,'App\\Models\\Receipt',2238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',2050.00,NULL,NULL,1,'2021-10-14 15:38:57','2021-10-14 15:38:57',NULL),(2404,3117,40845,11735,2,2239,'App\\Models\\Receipt',2239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',1320.00,NULL,NULL,1,'2021-10-14 15:38:57','2021-10-14 15:38:57',NULL),(2405,3117,40845,11735,2,2240,'App\\Models\\Receipt',2240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',1200.00,NULL,NULL,1,'2021-10-14 15:38:57','2021-10-14 15:38:57',NULL),(2406,3117,40845,11735,2,2241,'App\\Models\\Receipt',2241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',1580.00,NULL,NULL,1,'2021-10-14 15:38:58','2021-10-14 15:38:58',NULL),(2407,3117,40845,11735,2,2242,'App\\Models\\Receipt',2242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',970.00,NULL,NULL,1,'2021-10-14 15:38:58','2021-10-14 15:38:58',NULL),(2408,3117,40845,11735,2,2243,'App\\Models\\Receipt',2243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',1690.00,NULL,NULL,1,'2021-10-14 15:38:58','2021-10-14 15:38:58',NULL),(2409,3117,40845,11735,2,2244,'App\\Models\\Receipt',2244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',1500.00,NULL,NULL,1,'2021-10-14 15:38:58','2021-10-14 15:38:58',NULL),(2410,3117,40845,11735,2,2245,'App\\Models\\Receipt',2245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',1310.00,NULL,NULL,1,'2021-10-14 15:38:58','2021-10-14 15:38:58',NULL);
INSERT INTO `balance_libro` VALUES (2411,3117,40845,11735,2,2246,'App\\Models\\Receipt',2246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',1450.00,NULL,NULL,1,'2021-10-14 15:38:58','2021-10-14 15:38:58',NULL),(2412,3117,40845,11735,2,2247,'App\\Models\\Receipt',2247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',1100.00,NULL,NULL,1,'2021-10-14 15:38:58','2021-10-14 15:38:58',NULL),(2413,3117,40845,11735,2,2248,'App\\Models\\Receipt',2248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',1360.00,NULL,NULL,1,'2021-10-14 15:38:58','2021-10-14 15:38:58',NULL),(2414,3117,40845,11735,2,2249,'App\\Models\\Receipt',2249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',3100.00,NULL,NULL,1,'2021-10-14 15:38:58','2021-10-14 15:38:58',NULL),(2415,3117,40845,11735,2,2250,'App\\Models\\Receipt',2250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',1970.00,NULL,NULL,1,'2021-10-14 15:38:58','2021-10-14 15:38:58',NULL),(2416,3117,40845,11735,2,2251,'App\\Models\\Receipt',2251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',1400.00,NULL,NULL,1,'2021-10-14 15:38:58','2021-10-14 15:38:58',NULL),(2417,3117,40845,11735,2,2252,'App\\Models\\Receipt',2252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',1280.00,NULL,NULL,1,'2021-10-14 15:38:58','2021-10-14 15:38:58',NULL),(2418,3117,40845,11735,2,2253,'App\\Models\\Receipt',2253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',1500.00,NULL,NULL,1,'2021-10-14 15:38:58','2021-10-14 15:38:58',NULL),(2419,3117,40845,11735,2,2254,'App\\Models\\Receipt',2254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',1860.00,NULL,NULL,1,'2021-10-14 15:38:58','2021-10-14 15:38:58',NULL),(2420,3117,40845,11735,2,2255,'App\\Models\\Receipt',2255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',2200.00,NULL,NULL,1,'2021-10-14 15:38:58','2021-10-14 15:38:58',NULL),(2421,3117,40845,11735,2,2256,'App\\Models\\Receipt',2256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',1670.00,NULL,NULL,1,'2021-10-14 15:38:58','2021-10-14 15:38:58',NULL),(2422,3117,40845,11735,2,2257,'App\\Models\\Receipt',2257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',1700.00,NULL,NULL,1,'2021-10-14 15:38:58','2021-10-14 15:38:58',NULL),(2423,3117,40845,11735,2,2258,'App\\Models\\Receipt',2258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',1900.00,NULL,NULL,1,'2021-10-14 15:38:58','2021-10-14 15:38:58',NULL),(2424,3117,40845,11735,3,2259,'App\\Models\\Receipt',2259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',24994.76,NULL,NULL,1,'2021-10-14 15:39:16','2021-10-14 15:39:16',NULL),(2425,3117,40845,11735,3,2260,'App\\Models\\Receipt',2260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',13704.03,NULL,NULL,1,'2021-10-14 15:39:16','2021-10-14 15:39:16',NULL),(2426,3117,40845,11735,3,2261,'App\\Models\\Receipt',2261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',15441.65,NULL,NULL,1,'2021-10-14 15:39:16','2021-10-14 15:39:16',NULL),(2427,3117,40845,11735,3,2262,'App\\Models\\Receipt',2262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',6079.89,NULL,NULL,1,'2021-10-14 15:39:16','2021-10-14 15:39:16',NULL),(2428,3117,40845,11735,3,2263,'App\\Models\\Receipt',2263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',10544.46,NULL,NULL,1,'2021-10-14 15:39:16','2021-10-14 15:39:16',NULL),(2429,3117,40845,11735,3,2264,'App\\Models\\Receipt',2264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',2927.75,NULL,NULL,1,'2021-10-14 15:39:16','2021-10-14 15:39:16',NULL),(2430,3117,40845,11735,3,2265,'App\\Models\\Receipt',2265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',18741.99,NULL,NULL,1,'2021-10-14 15:39:16','2021-10-14 15:39:16',NULL),(2431,3117,40845,11735,3,2266,'App\\Models\\Receipt',2266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',0.00,NULL,NULL,1,'2021-10-14 15:39:16','2021-10-14 15:39:16',NULL);
INSERT INTO `balance_libro` VALUES (2432,3117,40845,11735,3,2267,'App\\Models\\Receipt',2267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',1229.48,NULL,NULL,1,'2021-10-14 15:39:16','2021-10-14 15:39:16',NULL),(2433,3117,40845,11735,3,2268,'App\\Models\\Receipt',2268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',44379.85,NULL,NULL,1,'2021-10-14 15:39:16','2021-10-14 15:39:16',NULL),(2434,3117,40845,11735,3,2269,'App\\Models\\Receipt',2269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',9644.95,NULL,NULL,1,'2021-10-14 15:39:16','2021-10-14 15:39:16',NULL),(2435,3117,40845,11735,3,2270,'App\\Models\\Receipt',2270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-04','2021-09-04',4072.69,NULL,NULL,1,'2021-10-14 15:39:16','2021-10-14 15:39:16',NULL),(2436,3117,40845,11735,3,2271,'App\\Models\\Receipt',2271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-04','2021-09-04',6551.47,NULL,NULL,1,'2021-10-14 15:39:16','2021-10-14 15:39:16',NULL),(2437,3117,40845,11735,3,2272,'App\\Models\\Receipt',2272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',10427.99,NULL,NULL,1,'2021-10-14 15:39:16','2021-10-14 15:39:16',NULL),(2438,3117,40845,11735,3,2273,'App\\Models\\Receipt',2273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',48264.13,NULL,NULL,1,'2021-10-14 15:39:16','2021-10-14 15:39:16',NULL),(2439,3117,40845,11735,3,2274,'App\\Models\\Receipt',2274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',3540.65,NULL,NULL,1,'2021-10-14 15:39:16','2021-10-14 15:39:16',NULL),(2440,3117,40845,11735,3,2275,'App\\Models\\Receipt',2275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',34243.96,NULL,NULL,1,'2021-10-14 15:39:16','2021-10-14 15:39:16',NULL),(2441,3117,40845,11735,3,2276,'App\\Models\\Receipt',2276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',983.67,NULL,NULL,1,'2021-10-14 15:39:16','2021-10-14 15:39:16',NULL),(2442,3117,40845,11735,3,2277,'App\\Models\\Receipt',2277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',37154.87,NULL,NULL,1,'2021-10-14 15:39:16','2021-10-14 15:39:16',NULL),(2443,3117,40845,11735,3,2278,'App\\Models\\Receipt',2278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',20077.26,NULL,NULL,1,'2021-10-14 15:39:16','2021-10-14 15:39:16',NULL),(2444,3117,40845,11735,3,2279,'App\\Models\\Receipt',2279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',5999.71,NULL,NULL,1,'2021-10-14 15:39:17','2021-10-14 15:39:17',NULL),(2445,3117,40845,11735,3,2280,'App\\Models\\Receipt',2280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',1819.57,NULL,NULL,1,'2021-10-14 15:39:17','2021-10-14 15:39:17',NULL),(2446,3117,40845,11735,3,2281,'App\\Models\\Receipt',2281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',20955.93,NULL,NULL,1,'2021-10-14 15:39:17','2021-10-14 15:39:17',NULL),(2447,3117,40845,11735,3,2282,'App\\Models\\Receipt',2282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',5981.24,NULL,NULL,1,'2021-10-14 15:39:17','2021-10-14 15:39:17',NULL),(2448,3117,40845,11735,3,2283,'App\\Models\\Receipt',2283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',1511.56,NULL,NULL,1,'2021-10-14 15:39:17','2021-10-14 15:39:17',NULL),(2449,3117,40845,11735,3,2284,'App\\Models\\Receipt',2284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',7582.68,NULL,NULL,1,'2021-10-14 15:39:17','2021-10-14 15:39:17',NULL),(2450,3117,40845,11735,3,2285,'App\\Models\\Receipt',2285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',1185.07,NULL,NULL,1,'2021-10-14 15:39:17','2021-10-14 15:39:17',NULL),(2451,3117,40845,11735,3,2286,'App\\Models\\Receipt',2286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',8843.91,NULL,NULL,1,'2021-10-14 15:39:17','2021-10-14 15:39:17',NULL),(2452,3117,40845,11735,3,2287,'App\\Models\\Receipt',2287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',507.18,NULL,NULL,1,'2021-10-14 15:39:17','2021-10-14 15:39:17',NULL);
INSERT INTO `balance_libro` VALUES (2453,3117,40845,11735,3,2288,'App\\Models\\Receipt',2288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',53819.88,NULL,NULL,1,'2021-10-14 15:39:17','2021-10-14 15:39:17',NULL),(2454,3117,40845,11735,3,2289,'App\\Models\\Receipt',2289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11','2021-09-11',14060.41,NULL,NULL,1,'2021-10-14 15:39:17','2021-10-14 15:39:17',NULL),(2455,3117,40845,11735,3,2290,'App\\Models\\Receipt',2290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',4453.86,NULL,NULL,1,'2021-10-14 15:39:17','2021-10-14 15:39:17',NULL),(2456,3117,40845,11735,3,2291,'App\\Models\\Receipt',2291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',12179.83,NULL,NULL,1,'2021-10-14 15:39:17','2021-10-14 15:39:17',NULL),(2457,3117,40845,11735,3,2292,'App\\Models\\Receipt',2292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',43189.18,NULL,NULL,1,'2021-10-14 15:39:17','2021-10-14 15:39:17',NULL),(2458,3117,40845,11735,3,2293,'App\\Models\\Receipt',2293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',21707.09,NULL,NULL,1,'2021-10-14 15:39:17','2021-10-14 15:39:17',NULL),(2459,3117,40845,11735,3,2294,'App\\Models\\Receipt',2294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',22003.34,NULL,NULL,1,'2021-10-14 15:39:17','2021-10-14 15:39:17',NULL),(2460,3117,40845,11735,3,2295,'App\\Models\\Receipt',2295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',623.05,NULL,NULL,1,'2021-10-14 15:39:17','2021-10-14 15:39:17',NULL),(2461,3117,40845,11735,3,2296,'App\\Models\\Receipt',2296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',3126.54,NULL,NULL,1,'2021-10-14 15:39:17','2021-10-14 15:39:17',NULL),(2462,3117,40845,11735,3,2297,'App\\Models\\Receipt',2297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',12586.58,NULL,NULL,1,'2021-10-14 15:39:17','2021-10-14 15:39:17',NULL),(2463,3117,40845,11735,3,2298,'App\\Models\\Receipt',2298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',12261.60,NULL,NULL,1,'2021-10-14 15:39:17','2021-10-14 15:39:17',NULL),(2464,3117,40845,11735,3,2299,'App\\Models\\Receipt',2299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',1788.43,NULL,NULL,1,'2021-10-14 15:39:18','2021-10-14 15:39:18',NULL),(2465,3117,40845,11735,3,2300,'App\\Models\\Receipt',2300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',11212.56,NULL,NULL,1,'2021-10-14 15:39:18','2021-10-14 15:39:18',NULL),(2466,3117,40845,11735,3,2301,'App\\Models\\Receipt',2301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',56633.21,NULL,NULL,1,'2021-10-14 15:39:18','2021-10-14 15:39:18',NULL),(2467,3117,40845,11735,3,2302,'App\\Models\\Receipt',2302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',4079.42,NULL,NULL,1,'2021-10-14 15:39:18','2021-10-14 15:39:18',NULL),(2468,3117,40845,11735,3,2303,'App\\Models\\Receipt',2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',1143.68,NULL,NULL,1,'2021-10-14 15:39:18','2021-10-14 15:39:18',NULL),(2469,3117,40845,11735,3,2304,'App\\Models\\Receipt',2304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',21567.26,NULL,NULL,1,'2021-10-14 15:39:18','2021-10-14 15:39:18',NULL),(2470,3117,40845,11735,3,2305,'App\\Models\\Receipt',2305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',6687.28,NULL,NULL,1,'2021-10-14 15:39:18','2021-10-14 15:39:18',NULL),(2471,3117,40845,11735,3,2306,'App\\Models\\Receipt',2306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',52139.95,NULL,NULL,1,'2021-10-14 15:39:18','2021-10-14 15:39:18',NULL),(2472,3117,40845,11735,3,2307,'App\\Models\\Receipt',2307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',22879.54,NULL,NULL,1,'2021-10-14 15:39:18','2021-10-14 15:39:18',NULL),(2473,3117,40845,11735,3,2308,'App\\Models\\Receipt',2308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',32845.14,NULL,NULL,1,'2021-10-14 15:39:18','2021-10-14 15:39:18',NULL);
INSERT INTO `balance_libro` VALUES (2474,3117,40845,11735,3,2309,'App\\Models\\Receipt',2309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',9195.30,NULL,NULL,1,'2021-10-14 15:39:18','2021-10-14 15:39:18',NULL),(2475,3117,40845,11735,3,2310,'App\\Models\\Receipt',2310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',10932.94,NULL,NULL,1,'2021-10-14 15:39:18','2021-10-14 15:39:18',NULL),(2476,3117,40845,11735,3,2311,'App\\Models\\Receipt',2311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',967.40,NULL,NULL,1,'2021-10-14 15:39:18','2021-10-14 15:39:18',NULL),(2477,3117,40845,11735,3,2312,'App\\Models\\Receipt',2312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',0.00,NULL,NULL,1,'2021-10-14 15:39:18','2021-10-14 15:39:18',NULL),(2478,3117,40845,11735,3,2313,'App\\Models\\Receipt',2313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',16838.31,NULL,NULL,1,'2021-10-14 15:39:18','2021-10-14 15:39:18',NULL),(2479,3117,40845,11735,3,2314,'App\\Models\\Receipt',2314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',3404.14,NULL,NULL,1,'2021-10-14 15:39:18','2021-10-14 15:39:18',NULL),(2480,3117,40845,11735,3,2315,'App\\Models\\Receipt',2315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',16304.56,NULL,NULL,1,'2021-10-14 15:39:18','2021-10-14 15:39:18',NULL),(2481,3117,40845,11735,3,2316,'App\\Models\\Receipt',2316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',58281.84,NULL,NULL,1,'2021-10-14 15:39:18','2021-10-14 15:39:18',NULL),(2482,3117,40845,11735,3,2317,'App\\Models\\Receipt',2317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-24','2021-09-24',14939.28,NULL,NULL,1,'2021-10-14 15:39:18','2021-10-14 15:39:18',NULL),(2483,3117,40845,11735,3,2318,'App\\Models\\Receipt',2318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',6713.40,NULL,NULL,1,'2021-10-14 15:39:18','2021-10-14 15:39:18',NULL),(2484,3117,40845,11735,3,2319,'App\\Models\\Receipt',2319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',1917.90,NULL,NULL,1,'2021-10-14 15:39:19','2021-10-14 15:39:19',NULL),(2485,3117,40845,11735,3,2320,'App\\Models\\Receipt',2320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',9082.69,NULL,NULL,1,'2021-10-14 15:39:19','2021-10-14 15:39:19',NULL),(2486,3117,40845,11735,3,2321,'App\\Models\\Receipt',2321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',16054.72,NULL,NULL,1,'2021-10-14 15:39:19','2021-10-14 15:39:19',NULL),(2487,3117,40845,11735,3,2322,'App\\Models\\Receipt',2322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',5533.85,NULL,NULL,1,'2021-10-14 15:39:19','2021-10-14 15:39:19',NULL),(2488,3117,40845,11735,3,2323,'App\\Models\\Receipt',2323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',56279.75,NULL,NULL,1,'2021-10-14 15:39:19','2021-10-14 15:39:19',NULL),(2489,3117,40845,11735,3,2324,'App\\Models\\Receipt',2324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',2163.00,NULL,NULL,1,'2021-10-14 15:39:19','2021-10-14 15:39:19',NULL),(2490,3117,40845,11735,3,2325,'App\\Models\\Receipt',2325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',19870.86,NULL,NULL,1,'2021-10-14 15:39:19','2021-10-14 15:39:19',NULL),(2491,3117,40845,11735,3,2326,'App\\Models\\Receipt',2326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',1194.48,NULL,NULL,1,'2021-10-14 15:39:19','2021-10-14 15:39:19',NULL),(2492,3117,40845,11735,3,2327,'App\\Models\\Receipt',2327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',2402.93,NULL,NULL,1,'2021-10-14 15:39:19','2021-10-14 15:39:19',NULL),(2493,3117,40845,11735,3,2328,'App\\Models\\Receipt',2328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',13451.50,NULL,NULL,1,'2021-10-14 15:39:19','2021-10-14 15:39:19',NULL),(2494,3117,40845,11735,3,2329,'App\\Models\\Receipt',2329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',5288.34,NULL,NULL,1,'2021-10-14 15:39:19','2021-10-14 15:39:19',NULL);
INSERT INTO `balance_libro` VALUES (2495,3117,40845,11735,3,2330,'App\\Models\\Receipt',2330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',892.07,NULL,NULL,1,'2021-10-14 15:39:19','2021-10-14 15:39:19',NULL),(2496,3117,40845,11735,3,2331,'App\\Models\\Receipt',2331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',9032.81,NULL,NULL,1,'2021-10-14 15:39:19','2021-10-14 15:39:19',NULL),(2497,3117,40845,11735,3,2332,'App\\Models\\Receipt',2332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',9623.29,NULL,NULL,1,'2021-10-14 15:39:19','2021-10-14 15:39:19',NULL),(2498,3117,40845,11735,3,2333,'App\\Models\\Receipt',2333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',2176.31,NULL,NULL,1,'2021-10-14 15:39:19','2021-10-14 15:39:19',NULL),(2499,3117,40845,11735,3,2334,'App\\Models\\Receipt',2334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',348.00,NULL,NULL,1,'2021-10-14 15:39:19','2021-10-14 15:39:19',NULL),(2500,3117,40845,11735,3,2335,'App\\Models\\Receipt',2335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',52230.63,NULL,NULL,1,'2021-10-14 15:39:19','2021-10-14 15:39:19',NULL),(2501,3117,40736,1546,2,2336,'App\\Models\\Receipt',2336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',54967.00,NULL,NULL,1,'2021-11-02 15:07:23','2021-11-02 15:07:23',NULL),(2502,3117,40719,12,2,2337,'App\\Models\\Receipt',2337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',3947.00,NULL,NULL,1,'2021-11-03 15:21:15','2021-11-03 15:21:15',NULL),(2503,3117,40719,12,2,2338,'App\\Models\\Receipt',2338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',9696.00,NULL,NULL,1,'2021-11-03 15:21:15','2021-11-03 15:21:15',NULL),(2504,3117,40719,12,2,2339,'App\\Models\\Receipt',2339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',2000.00,NULL,NULL,1,'2021-11-03 15:21:15','2021-11-03 15:21:15',NULL),(2505,3117,40719,12,2,2340,'App\\Models\\Receipt',2340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',29000.00,NULL,NULL,1,'2021-11-03 15:21:15','2021-11-03 15:21:15',NULL),(2506,3117,40719,12,2,2341,'App\\Models\\Receipt',2341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',20000.00,NULL,NULL,1,'2021-11-03 15:21:15','2021-11-03 15:21:15',NULL),(2507,3117,40719,12,2,2342,'App\\Models\\Receipt',2342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',13000.00,NULL,NULL,1,'2021-11-03 15:21:15','2021-11-03 15:21:15',NULL),(2508,3117,40719,12,2,2343,'App\\Models\\Receipt',2343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',12000.00,NULL,NULL,1,'2021-11-03 15:21:15','2021-11-03 15:21:15',NULL),(2509,3117,40719,12,2,2344,'App\\Models\\Receipt',2344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',12500.00,NULL,NULL,1,'2021-11-03 15:21:15','2021-11-03 15:21:15',NULL),(2510,3117,40719,12,2,2345,'App\\Models\\Receipt',2345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',11500.00,NULL,NULL,1,'2021-11-03 15:21:15','2021-11-03 15:21:15',NULL),(2511,3117,40719,12,2,2346,'App\\Models\\Receipt',2346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',8000.00,NULL,NULL,1,'2021-11-03 15:21:15','2021-11-03 15:21:15',NULL),(2512,3117,40719,12,2,2347,'App\\Models\\Receipt',2347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',13000.00,NULL,NULL,1,'2021-11-03 15:21:15','2021-11-03 15:21:15',NULL),(2513,3117,40719,12,3,2348,'App\\Models\\Receipt',2348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',4650.03,NULL,NULL,1,'2021-11-03 15:21:39','2021-11-03 15:21:39',NULL),(2514,3117,40719,12,3,2349,'App\\Models\\Receipt',2349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',2500.01,NULL,NULL,1,'2021-11-03 15:21:39','2021-11-03 15:21:39',NULL),(2515,3117,40719,12,3,2350,'App\\Models\\Receipt',2350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',4029.30,NULL,NULL,1,'2021-11-03 15:21:39','2021-11-03 15:21:39',NULL);
INSERT INTO `balance_libro` VALUES (2516,3117,40728,6081,2,2351,'App\\Models\\Receipt',2351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',43561.01,NULL,NULL,1,'2021-11-03 15:35:50','2021-11-03 15:35:50',NULL),(2517,3117,40728,6081,2,2352,'App\\Models\\Receipt',2352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',27000.00,NULL,NULL,1,'2021-11-03 15:35:50','2021-11-03 15:35:50',NULL),(2518,3117,40728,6081,2,2353,'App\\Models\\Receipt',2353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',7800.00,NULL,NULL,1,'2021-11-03 15:35:50','2021-11-03 15:35:50',NULL),(2519,3117,40728,6081,2,2354,'App\\Models\\Receipt',2354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',12000.00,NULL,NULL,1,'2021-11-03 15:35:50','2021-11-03 15:35:50',NULL),(2520,3117,40728,6081,2,2355,'App\\Models\\Receipt',2355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',10500.00,NULL,NULL,1,'2021-11-03 15:35:50','2021-11-03 15:35:50',NULL),(2521,3117,40728,6081,2,2356,'App\\Models\\Receipt',2356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',8000.00,NULL,NULL,1,'2021-11-03 15:35:50','2021-11-03 15:35:50',NULL),(2522,3117,40728,6081,2,2357,'App\\Models\\Receipt',2357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',5000.00,NULL,NULL,1,'2021-11-03 15:35:50','2021-11-03 15:35:50',NULL),(2523,3117,40728,6081,2,2358,'App\\Models\\Receipt',2358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',13000.00,NULL,NULL,1,'2021-11-03 15:35:50','2021-11-03 15:35:50',NULL),(2524,3117,40728,6081,2,2359,'App\\Models\\Receipt',2359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',9000.00,NULL,NULL,1,'2021-11-03 15:35:50','2021-11-03 15:35:50',NULL),(2525,3117,40728,6081,2,2360,'App\\Models\\Receipt',2360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',5000.00,NULL,NULL,1,'2021-11-03 15:35:50','2021-11-03 15:35:50',NULL),(2526,3117,40728,6081,2,2361,'App\\Models\\Receipt',2361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',25000.00,NULL,NULL,1,'2021-11-03 15:35:50','2021-11-03 15:35:50',NULL),(2527,3117,40728,6081,2,2362,'App\\Models\\Receipt',2362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',10450.00,NULL,NULL,1,'2021-11-03 15:35:51','2021-11-03 15:35:51',NULL),(2528,3117,40728,6081,2,2363,'App\\Models\\Receipt',2363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',10700.00,NULL,NULL,1,'2021-11-03 15:35:51','2021-11-03 15:35:51',NULL),(2529,3117,40728,6081,2,2364,'App\\Models\\Receipt',2364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',11000.00,NULL,NULL,1,'2021-11-03 15:35:51','2021-11-03 15:35:51',NULL),(2530,3117,40728,6081,2,2365,'App\\Models\\Receipt',2365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',9600.00,NULL,NULL,1,'2021-11-03 15:35:51','2021-11-03 15:35:51',NULL),(2531,3117,40728,6081,2,2366,'App\\Models\\Receipt',2366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',13000.00,NULL,NULL,1,'2021-11-03 15:35:51','2021-11-03 15:35:51',NULL),(2532,3117,40728,6081,2,2367,'App\\Models\\Receipt',2367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',3500.00,NULL,NULL,1,'2021-11-03 15:35:51','2021-11-03 15:35:51',NULL),(2533,3117,40728,6081,2,2368,'App\\Models\\Receipt',2368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',4000.00,NULL,NULL,1,'2021-11-03 15:35:51','2021-11-03 15:35:51',NULL),(2534,3117,40728,6081,2,2369,'App\\Models\\Receipt',2369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',1200.00,NULL,NULL,1,'2021-11-03 15:35:51','2021-11-03 15:35:51',NULL),(2535,3117,40728,6081,2,2370,'App\\Models\\Receipt',2370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',26000.00,NULL,NULL,1,'2021-11-03 15:35:51','2021-11-03 15:35:51',NULL),(2536,3117,40728,6081,3,2371,'App\\Models\\Receipt',2371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',15499.00,NULL,NULL,1,'2021-11-03 15:36:11','2021-11-03 15:36:11',NULL);
INSERT INTO `balance_libro` VALUES (2537,3117,40728,6081,3,2372,'App\\Models\\Receipt',2372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',22079.09,NULL,NULL,1,'2021-11-03 15:36:11','2021-11-03 15:36:11',NULL),(2538,3117,40728,6081,3,2373,'App\\Models\\Receipt',2373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',22079.09,NULL,NULL,1,'2021-11-03 15:36:11','2021-11-03 15:36:11',NULL),(2539,3117,40728,6081,3,2374,'App\\Models\\Receipt',2374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',22079.09,NULL,NULL,1,'2021-11-03 15:36:11','2021-11-03 15:36:11',NULL),(2540,3117,40728,6081,3,2375,'App\\Models\\Receipt',2375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',17999.00,NULL,NULL,1,'2021-11-03 15:36:11','2021-11-03 15:36:11',NULL),(2541,3117,40728,6081,3,2376,'App\\Models\\Receipt',2376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',17999.00,NULL,NULL,1,'2021-11-03 15:36:11','2021-11-03 15:36:11',NULL),(2542,3117,40728,6081,3,2377,'App\\Models\\Receipt',2377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',17999.00,NULL,NULL,1,'2021-11-03 15:36:11','2021-11-03 15:36:11',NULL),(2543,3117,40728,6081,3,2378,'App\\Models\\Receipt',2378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',23999.00,NULL,NULL,1,'2021-11-03 15:36:11','2021-11-03 15:36:11',NULL),(2544,3117,40728,6081,3,2379,'App\\Models\\Receipt',2379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',15999.00,NULL,NULL,1,'2021-11-03 15:36:11','2021-11-03 15:36:11',NULL),(2545,3117,40728,6081,3,2380,'App\\Models\\Receipt',2380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',15999.00,NULL,NULL,1,'2021-11-03 15:36:12','2021-11-03 15:36:12',NULL),(2546,3117,40728,6081,3,2381,'App\\Models\\Receipt',2381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',15999.00,NULL,NULL,1,'2021-11-03 15:36:12','2021-11-03 15:36:12',NULL),(2547,3117,40728,6081,3,2382,'App\\Models\\Receipt',2382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',299.00,NULL,NULL,1,'2021-11-03 15:36:12','2021-11-03 15:36:12',NULL),(2548,3117,40728,6081,3,2383,'App\\Models\\Receipt',2383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',20488.00,NULL,NULL,1,'2021-11-03 15:36:12','2021-11-03 15:36:12',NULL),(2549,3117,40728,6081,3,2384,'App\\Models\\Receipt',2384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',20599.00,NULL,NULL,1,'2021-11-03 15:36:12','2021-11-03 15:36:12',NULL),(2550,3117,40728,6081,3,2385,'App\\Models\\Receipt',2385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',20599.00,NULL,NULL,1,'2021-11-03 15:36:12','2021-11-03 15:36:12',NULL),(2551,3117,40728,6081,3,2386,'App\\Models\\Receipt',2386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',9899.00,NULL,NULL,1,'2021-11-03 15:36:12','2021-11-03 15:36:12',NULL),(2552,3117,40728,6081,3,2387,'App\\Models\\Receipt',2387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',9899.00,NULL,NULL,1,'2021-11-03 15:36:12','2021-11-03 15:36:12',NULL),(2553,3117,40728,6081,3,2388,'App\\Models\\Receipt',2388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',18000.00,NULL,NULL,1,'2021-11-03 15:36:12','2021-11-03 15:36:12',NULL),(2554,3117,40728,6081,3,2389,'App\\Models\\Receipt',2389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',20599.00,NULL,NULL,1,'2021-11-03 15:36:12','2021-11-03 15:36:12',NULL),(2555,3117,40728,6081,3,2390,'App\\Models\\Receipt',2390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',20599.00,NULL,NULL,1,'2021-11-03 15:36:12','2021-11-03 15:36:12',NULL),(2556,3117,40728,6081,3,2391,'App\\Models\\Receipt',2391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',15999.00,NULL,NULL,1,'2021-11-03 15:36:12','2021-11-03 15:36:12',NULL),(2557,3117,40728,6081,3,2392,'App\\Models\\Receipt',2392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',15999.00,NULL,NULL,1,'2021-11-03 15:36:12','2021-11-03 15:36:12',NULL);
INSERT INTO `balance_libro` VALUES (2558,3117,40728,6081,3,2393,'App\\Models\\Receipt',2393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',9899.00,NULL,NULL,1,'2021-11-03 15:36:12','2021-11-03 15:36:12',NULL),(2559,3117,40728,6081,3,2394,'App\\Models\\Receipt',2394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',15999.00,NULL,NULL,1,'2021-11-03 15:36:12','2021-11-03 15:36:12',NULL),(2560,3117,40728,6081,3,2395,'App\\Models\\Receipt',2395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',2110.14,NULL,NULL,1,'2021-11-03 15:36:12','2021-11-03 15:36:12',NULL),(2561,3117,40728,6081,3,2396,'App\\Models\\Receipt',2396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-16','2021-10-16',15999.00,NULL,NULL,1,'2021-11-03 15:36:12','2021-11-03 15:36:12',NULL),(2562,3117,40728,6081,3,2397,'App\\Models\\Receipt',2397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-16','2021-10-16',15999.00,NULL,NULL,1,'2021-11-03 15:36:12','2021-11-03 15:36:12',NULL),(2563,3117,40728,6081,3,2398,'App\\Models\\Receipt',2398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-16','2021-10-16',9899.00,NULL,NULL,1,'2021-11-03 15:36:12','2021-11-03 15:36:12',NULL),(2564,3117,40728,6081,3,2399,'App\\Models\\Receipt',2399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-17','2021-10-17',35999.00,NULL,NULL,1,'2021-11-03 15:36:12','2021-11-03 15:36:12',NULL),(2565,3117,40728,6081,3,2400,'App\\Models\\Receipt',2400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',20690.01,NULL,NULL,1,'2021-11-03 15:36:12','2021-11-03 15:36:12',NULL),(2566,3117,40728,6081,3,2401,'App\\Models\\Receipt',2401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',20999.00,NULL,NULL,1,'2021-11-03 15:36:12','2021-11-03 15:36:12',NULL),(2567,3117,40728,6081,3,2402,'App\\Models\\Receipt',2402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',19689.00,NULL,NULL,1,'2021-11-03 15:36:12','2021-11-03 15:36:12',NULL),(2568,3117,40728,6081,3,2403,'App\\Models\\Receipt',2403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',20689.00,NULL,NULL,1,'2021-11-03 15:36:12','2021-11-03 15:36:12',NULL),(2569,3117,40728,6081,3,2404,'App\\Models\\Receipt',2404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',20689.00,NULL,NULL,1,'2021-11-03 15:36:12','2021-11-03 15:36:12',NULL),(2570,3117,40728,6081,3,2405,'App\\Models\\Receipt',2405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',20689.00,NULL,NULL,1,'2021-11-03 15:36:12','2021-11-03 15:36:12',NULL),(2571,3117,40728,6081,3,2406,'App\\Models\\Receipt',2406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',16771.99,NULL,NULL,1,'2021-11-03 15:36:12','2021-11-03 15:36:12',NULL),(2572,3117,40728,6081,3,2407,'App\\Models\\Receipt',2407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',16771.99,NULL,NULL,1,'2021-11-03 15:36:13','2021-11-03 15:36:13',NULL),(2573,3117,40728,6081,3,2408,'App\\Models\\Receipt',2408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',16771.99,NULL,NULL,1,'2021-11-03 15:36:13','2021-11-03 15:36:13',NULL),(2574,3117,40728,6081,3,2409,'App\\Models\\Receipt',2409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',16771.99,NULL,NULL,1,'2021-11-03 15:36:13','2021-11-03 15:36:13',NULL),(2575,3117,40728,6081,3,2410,'App\\Models\\Receipt',2410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',20488.00,NULL,NULL,1,'2021-11-03 15:36:13','2021-11-03 15:36:13',NULL),(2576,3117,40728,6081,3,2411,'App\\Models\\Receipt',2411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',20488.00,NULL,NULL,1,'2021-11-03 15:36:13','2021-11-03 15:36:13',NULL),(2577,3117,40728,6081,3,2412,'App\\Models\\Receipt',2412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',20488.00,NULL,NULL,1,'2021-11-03 15:36:13','2021-11-03 15:36:13',NULL),(2578,3117,40728,6081,3,2413,'App\\Models\\Receipt',2413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',17999.00,NULL,NULL,1,'2021-11-03 15:36:13','2021-11-03 15:36:13',NULL);
INSERT INTO `balance_libro` VALUES (2579,3117,40728,6081,3,2414,'App\\Models\\Receipt',2414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',3999.00,NULL,NULL,1,'2021-11-03 15:36:13','2021-11-03 15:36:13',NULL),(2580,3117,40728,6081,3,2415,'App\\Models\\Receipt',2415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',3999.00,NULL,NULL,1,'2021-11-03 15:36:13','2021-11-03 15:36:13',NULL),(2581,3117,40728,6081,3,2416,'App\\Models\\Receipt',2416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',71398.30,NULL,NULL,1,'2021-11-03 15:36:13','2021-11-03 15:36:13',NULL),(2582,3117,40728,6081,3,2417,'App\\Models\\Receipt',2417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',20488.00,NULL,NULL,1,'2021-11-03 15:36:13','2021-11-03 15:36:13',NULL),(2583,3117,40728,6081,3,2418,'App\\Models\\Receipt',2418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',34199.10,NULL,NULL,1,'2021-11-03 15:36:13','2021-11-03 15:36:13',NULL),(2584,3117,40728,6081,3,2419,'App\\Models\\Receipt',2419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',10198.16,NULL,NULL,1,'2021-11-03 15:36:13','2021-11-03 15:36:13',NULL),(2585,3117,40885,13961,2,2420,'App\\Models\\Receipt',2420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',290.00,NULL,NULL,1,'2021-11-08 14:59:41','2021-11-08 14:59:41',NULL),(2586,3117,40885,13961,2,2421,'App\\Models\\Receipt',2421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',1000.00,NULL,NULL,1,'2021-11-08 14:59:41','2021-11-08 14:59:41',NULL),(2587,3117,40885,13961,2,2422,'App\\Models\\Receipt',2422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',838.00,NULL,NULL,1,'2021-11-08 14:59:41','2021-11-08 14:59:41',NULL),(2588,3117,40885,13961,2,2423,'App\\Models\\Receipt',2423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',1690.00,NULL,NULL,1,'2021-11-08 14:59:41','2021-11-08 14:59:41',NULL),(2589,3117,40885,13961,2,2424,'App\\Models\\Receipt',2424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',118.00,NULL,NULL,1,'2021-11-08 14:59:41','2021-11-08 14:59:41',NULL),(2590,3117,40885,13961,2,2425,'App\\Models\\Receipt',2425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',640.00,NULL,NULL,1,'2021-11-08 14:59:41','2021-11-08 14:59:41',NULL),(2591,3117,40885,13961,2,2426,'App\\Models\\Receipt',2426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',341.00,NULL,NULL,1,'2021-11-08 14:59:41','2021-11-08 14:59:41',NULL),(2592,3117,40885,13961,2,2427,'App\\Models\\Receipt',2427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',670.00,NULL,NULL,1,'2021-11-08 14:59:41','2021-11-08 14:59:41',NULL),(2593,3117,40885,13961,2,2428,'App\\Models\\Receipt',2428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',416.00,NULL,NULL,1,'2021-11-08 14:59:41','2021-11-08 14:59:41',NULL),(2594,3117,40885,13961,2,2429,'App\\Models\\Receipt',2429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',583.00,NULL,NULL,1,'2021-11-08 14:59:41','2021-11-08 14:59:41',NULL),(2595,3117,40885,13961,2,2430,'App\\Models\\Receipt',2430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',252.00,NULL,NULL,1,'2021-11-08 14:59:41','2021-11-08 14:59:41',NULL),(2596,3117,40885,13961,2,2431,'App\\Models\\Receipt',2431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',1220.00,NULL,NULL,1,'2021-11-08 14:59:41','2021-11-08 14:59:41',NULL),(2597,3117,40885,13961,2,2432,'App\\Models\\Receipt',2432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',736.00,NULL,NULL,1,'2021-11-08 14:59:41','2021-11-08 14:59:41',NULL),(2598,3117,40885,13961,2,2433,'App\\Models\\Receipt',2433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',2791.00,NULL,NULL,1,'2021-11-08 14:59:41','2021-11-08 14:59:41',NULL),(2599,3117,40885,13961,2,2434,'App\\Models\\Receipt',2434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',500.00,NULL,NULL,1,'2021-11-08 14:59:41','2021-11-08 14:59:41',NULL);
INSERT INTO `balance_libro` VALUES (2600,3117,40885,13961,2,2435,'App\\Models\\Receipt',2435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',2000.00,NULL,NULL,1,'2021-11-08 14:59:41','2021-11-08 14:59:41',NULL),(2601,3117,40885,13961,2,2436,'App\\Models\\Receipt',2436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',1262.00,NULL,NULL,1,'2021-11-08 14:59:42','2021-11-08 14:59:42',NULL),(2602,3117,40885,13961,2,2437,'App\\Models\\Receipt',2437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',220.00,NULL,NULL,1,'2021-11-08 14:59:42','2021-11-08 14:59:42',NULL),(2603,3117,40885,13961,2,2438,'App\\Models\\Receipt',2438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',942.00,NULL,NULL,1,'2021-11-08 14:59:42','2021-11-08 14:59:42',NULL),(2604,3117,40885,13961,2,2439,'App\\Models\\Receipt',2439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',698.00,NULL,NULL,1,'2021-11-08 14:59:42','2021-11-08 14:59:42',NULL),(2605,3117,40885,13961,2,2440,'App\\Models\\Receipt',2440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',2700.00,NULL,NULL,1,'2021-11-08 14:59:42','2021-11-08 14:59:42',NULL),(2606,3117,40885,13961,2,2441,'App\\Models\\Receipt',2441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',564.00,NULL,NULL,1,'2021-11-08 14:59:42','2021-11-08 14:59:42',NULL),(2607,3117,40885,13961,2,2442,'App\\Models\\Receipt',2442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',16212.00,NULL,NULL,1,'2021-11-08 14:59:42','2021-11-08 14:59:42',NULL),(2608,3117,40885,13961,2,2443,'App\\Models\\Receipt',2443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',380.00,NULL,NULL,1,'2021-11-08 14:59:42','2021-11-08 14:59:42',NULL),(2609,3117,40885,13961,2,2444,'App\\Models\\Receipt',2444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',3145.00,NULL,NULL,1,'2021-11-08 14:59:42','2021-11-08 14:59:42',NULL),(2610,3117,40885,13961,2,2445,'App\\Models\\Receipt',2445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',1284.00,NULL,NULL,1,'2021-11-08 14:59:42','2021-11-08 14:59:42',NULL),(2611,3117,40885,13961,2,2446,'App\\Models\\Receipt',2446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',494.00,NULL,NULL,1,'2021-11-08 14:59:42','2021-11-08 14:59:42',NULL),(2612,3117,40885,13961,2,2447,'App\\Models\\Receipt',2447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',2801.79,NULL,NULL,1,'2021-11-08 14:59:42','2021-11-08 14:59:42',NULL),(2613,3117,40885,13961,2,2448,'App\\Models\\Receipt',2448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',378.00,NULL,NULL,1,'2021-11-08 14:59:42','2021-11-08 14:59:42',NULL),(2614,3117,40885,13961,2,2449,'App\\Models\\Receipt',2449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',2000.00,NULL,NULL,1,'2021-11-08 14:59:42','2021-11-08 14:59:42',NULL),(2615,3117,40885,13961,2,2450,'App\\Models\\Receipt',2450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',1400.00,NULL,NULL,1,'2021-11-08 14:59:42','2021-11-08 14:59:42',NULL),(2616,3117,40885,13961,2,2451,'App\\Models\\Receipt',2451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',210.00,NULL,NULL,1,'2021-11-08 14:59:42','2021-11-08 14:59:42',NULL),(2617,3117,40885,13961,2,2452,'App\\Models\\Receipt',2452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',900.00,NULL,NULL,1,'2021-11-08 14:59:42','2021-11-08 14:59:42',NULL),(2618,3117,40885,13961,2,2453,'App\\Models\\Receipt',2453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-10','2021-10-10',1120.00,NULL,NULL,1,'2021-11-08 14:59:42','2021-11-08 14:59:42',NULL),(2619,3117,40885,13961,2,2454,'App\\Models\\Receipt',2454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-10','2021-10-10',2000.00,NULL,NULL,1,'2021-11-08 14:59:42','2021-11-08 14:59:42',NULL),(2620,3117,40885,13961,2,2455,'App\\Models\\Receipt',2455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-10','2021-10-10',645.00,NULL,NULL,1,'2021-11-08 14:59:42','2021-11-08 14:59:42',NULL);
INSERT INTO `balance_libro` VALUES (2621,3117,40885,13961,2,2456,'App\\Models\\Receipt',2456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',1302.00,NULL,NULL,1,'2021-11-08 14:59:42','2021-11-08 14:59:42',NULL),(2622,3117,40885,13961,2,2457,'App\\Models\\Receipt',2457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',505.00,NULL,NULL,1,'2021-11-08 14:59:42','2021-11-08 14:59:42',NULL),(2623,3117,40885,13961,2,2458,'App\\Models\\Receipt',2458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',735.00,NULL,NULL,1,'2021-11-08 14:59:42','2021-11-08 14:59:42',NULL),(2624,3117,40885,13961,2,2459,'App\\Models\\Receipt',2459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',1010.00,NULL,NULL,1,'2021-11-08 14:59:42','2021-11-08 14:59:42',NULL),(2625,3117,40885,13961,2,2460,'App\\Models\\Receipt',2460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',524.00,NULL,NULL,1,'2021-11-08 14:59:42','2021-11-08 14:59:42',NULL),(2626,3117,40885,13961,2,2461,'App\\Models\\Receipt',2461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',329.00,NULL,NULL,1,'2021-11-08 14:59:42','2021-11-08 14:59:42',NULL),(2627,3117,40885,13961,2,2462,'App\\Models\\Receipt',2462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',180.00,NULL,NULL,1,'2021-11-08 14:59:42','2021-11-08 14:59:42',NULL),(2628,3117,40885,13961,2,2463,'App\\Models\\Receipt',2463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',2540.00,NULL,NULL,1,'2021-11-08 14:59:42','2021-11-08 14:59:42',NULL),(2629,3117,40885,13961,2,2464,'App\\Models\\Receipt',2464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',1000.00,NULL,NULL,1,'2021-11-08 14:59:42','2021-11-08 14:59:42',NULL),(2630,3117,40885,13961,2,2465,'App\\Models\\Receipt',2465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',914.00,NULL,NULL,1,'2021-11-08 14:59:42','2021-11-08 14:59:42',NULL),(2631,3117,40885,13961,2,2466,'App\\Models\\Receipt',2466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',926.00,NULL,NULL,1,'2021-11-08 14:59:43','2021-11-08 14:59:43',NULL),(2632,3117,40885,13961,2,2467,'App\\Models\\Receipt',2467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',960.00,NULL,NULL,1,'2021-11-08 14:59:43','2021-11-08 14:59:43',NULL),(2633,3117,40885,13961,2,2468,'App\\Models\\Receipt',2468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',983.00,NULL,NULL,1,'2021-11-08 14:59:43','2021-11-08 14:59:43',NULL),(2634,3117,40885,13961,2,2469,'App\\Models\\Receipt',2469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',139.00,NULL,NULL,1,'2021-11-08 14:59:43','2021-11-08 14:59:43',NULL),(2635,3117,40885,13961,2,2470,'App\\Models\\Receipt',2470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',2000.00,NULL,NULL,1,'2021-11-08 14:59:43','2021-11-08 14:59:43',NULL),(2636,3117,40885,13961,2,2471,'App\\Models\\Receipt',2471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',260.00,NULL,NULL,1,'2021-11-08 14:59:43','2021-11-08 14:59:43',NULL),(2637,3117,40885,13961,2,2472,'App\\Models\\Receipt',2472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',1140.84,NULL,NULL,1,'2021-11-08 14:59:43','2021-11-08 14:59:43',NULL),(2638,3117,40885,13961,2,2473,'App\\Models\\Receipt',2473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',440.00,NULL,NULL,1,'2021-11-08 14:59:43','2021-11-08 14:59:43',NULL),(2639,3117,40885,13961,2,2474,'App\\Models\\Receipt',2474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',280.00,NULL,NULL,1,'2021-11-08 14:59:43','2021-11-08 14:59:43',NULL),(2640,3117,40885,13961,2,2475,'App\\Models\\Receipt',2475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',3491.94,NULL,NULL,1,'2021-11-08 14:59:43','2021-11-08 14:59:43',NULL),(2641,3117,40885,13961,2,2476,'App\\Models\\Receipt',2476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',660.00,NULL,NULL,1,'2021-11-08 14:59:43','2021-11-08 14:59:43',NULL);
INSERT INTO `balance_libro` VALUES (2642,3117,40885,13961,2,2477,'App\\Models\\Receipt',2477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',330.00,NULL,NULL,1,'2021-11-08 14:59:43','2021-11-08 14:59:43',NULL),(2643,3117,40885,13961,2,2478,'App\\Models\\Receipt',2478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',340.00,NULL,NULL,1,'2021-11-08 14:59:43','2021-11-08 14:59:43',NULL),(2644,3117,40885,13961,2,2479,'App\\Models\\Receipt',2479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',1025.00,NULL,NULL,1,'2021-11-08 14:59:43','2021-11-08 14:59:43',NULL),(2645,3117,40885,13961,2,2480,'App\\Models\\Receipt',2480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',510.00,NULL,NULL,1,'2021-11-08 14:59:43','2021-11-08 14:59:43',NULL),(2646,3117,40885,13961,2,2481,'App\\Models\\Receipt',2481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',155.00,NULL,NULL,1,'2021-11-08 14:59:43','2021-11-08 14:59:43',NULL),(2647,3117,40885,13961,2,2482,'App\\Models\\Receipt',2482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',483.00,NULL,NULL,1,'2021-11-08 14:59:43','2021-11-08 14:59:43',NULL),(2648,3117,40885,13961,2,2483,'App\\Models\\Receipt',2483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',1128.00,NULL,NULL,1,'2021-11-08 14:59:43','2021-11-08 14:59:43',NULL),(2649,3117,40885,13961,2,2484,'App\\Models\\Receipt',2484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23','2021-10-23',3216.00,NULL,NULL,1,'2021-11-08 14:59:43','2021-11-08 14:59:43',NULL),(2650,3117,40885,13961,2,2485,'App\\Models\\Receipt',2485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23','2021-10-23',215.00,NULL,NULL,1,'2021-11-08 14:59:43','2021-11-08 14:59:43',NULL),(2651,3117,40885,13961,2,2486,'App\\Models\\Receipt',2486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23','2021-10-23',677.00,NULL,NULL,1,'2021-11-08 14:59:43','2021-11-08 14:59:43',NULL),(2652,3117,40885,13961,2,2487,'App\\Models\\Receipt',2487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23','2021-10-23',1294.00,NULL,NULL,1,'2021-11-08 14:59:43','2021-11-08 14:59:43',NULL),(2653,3117,40885,13961,2,2488,'App\\Models\\Receipt',2488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23','2021-10-23',460.00,NULL,NULL,1,'2021-11-08 14:59:43','2021-11-08 14:59:43',NULL),(2654,3117,40885,13961,2,2489,'App\\Models\\Receipt',2489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23','2021-10-23',273.00,NULL,NULL,1,'2021-11-08 14:59:43','2021-11-08 14:59:43',NULL),(2655,3117,40885,13961,2,2490,'App\\Models\\Receipt',2490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23','2021-10-23',317.00,NULL,NULL,1,'2021-11-08 14:59:43','2021-11-08 14:59:43',NULL),(2656,3117,40885,13961,2,2491,'App\\Models\\Receipt',2491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23','2021-10-23',4649.75,NULL,NULL,1,'2021-11-08 14:59:43','2021-11-08 14:59:43',NULL),(2657,3117,40885,13961,2,2492,'App\\Models\\Receipt',2492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23','2021-10-23',1256.95,NULL,NULL,1,'2021-11-08 14:59:43','2021-11-08 14:59:43',NULL),(2658,3117,40885,13961,2,2493,'App\\Models\\Receipt',2493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23','2021-10-23',1140.00,NULL,NULL,1,'2021-11-08 14:59:43','2021-11-08 14:59:43',NULL),(2659,3117,40885,13961,2,2494,'App\\Models\\Receipt',2494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',564.00,NULL,NULL,1,'2021-11-08 14:59:43','2021-11-08 14:59:43',NULL),(2660,3117,40885,13961,2,2495,'App\\Models\\Receipt',2495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',500.00,NULL,NULL,1,'2021-11-08 14:59:43','2021-11-08 14:59:43',NULL),(2661,3117,40885,13961,2,2496,'App\\Models\\Receipt',2496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',310.00,NULL,NULL,1,'2021-11-08 14:59:44','2021-11-08 14:59:44',NULL),(2662,3117,40885,13961,2,2497,'App\\Models\\Receipt',2497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',545.00,NULL,NULL,1,'2021-11-08 14:59:44','2021-11-08 14:59:44',NULL);
INSERT INTO `balance_libro` VALUES (2663,3117,40885,13961,3,2498,'App\\Models\\Receipt',2498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',11934.69,NULL,NULL,1,'2021-11-08 14:59:58','2021-11-08 14:59:58',NULL),(2664,3117,40885,13961,3,2499,'App\\Models\\Receipt',2499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',3626.75,NULL,NULL,1,'2021-11-08 14:59:58','2021-11-08 14:59:58',NULL),(2665,3117,40885,13961,3,2500,'App\\Models\\Receipt',2500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',8072.09,NULL,NULL,1,'2021-11-08 14:59:58','2021-11-08 14:59:58',NULL),(2666,3117,40885,13961,3,2501,'App\\Models\\Receipt',2501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',5361.82,NULL,NULL,1,'2021-11-08 14:59:58','2021-11-08 14:59:58',NULL),(2667,3117,40885,13961,3,2502,'App\\Models\\Receipt',2502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',2491.12,NULL,NULL,1,'2021-11-08 14:59:58','2021-11-08 14:59:58',NULL),(2668,3117,40885,13961,3,2503,'App\\Models\\Receipt',2503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',13994.07,NULL,NULL,1,'2021-11-08 14:59:59','2021-11-08 14:59:59',NULL),(2669,3117,40885,13961,3,2504,'App\\Models\\Receipt',2504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',4569.83,NULL,NULL,1,'2021-11-08 14:59:59','2021-11-08 14:59:59',NULL),(2670,3117,40885,13961,3,2505,'App\\Models\\Receipt',2505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',22681.92,NULL,NULL,1,'2021-11-08 14:59:59','2021-11-08 14:59:59',NULL),(2671,3117,40885,13961,3,2506,'App\\Models\\Receipt',2506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',6752.25,NULL,NULL,1,'2021-11-08 14:59:59','2021-11-08 14:59:59',NULL),(2672,3117,40885,13961,3,2507,'App\\Models\\Receipt',2507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',13288.80,NULL,NULL,1,'2021-11-08 14:59:59','2021-11-08 14:59:59',NULL),(2673,3117,40885,13961,3,2508,'App\\Models\\Receipt',2508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',1035.01,NULL,NULL,1,'2021-11-08 14:59:59','2021-11-08 14:59:59',NULL),(2674,3117,40885,13961,3,2509,'App\\Models\\Receipt',2509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',12314.23,NULL,NULL,1,'2021-11-08 14:59:59','2021-11-08 14:59:59',NULL),(2675,3117,40885,13961,3,2510,'App\\Models\\Receipt',2510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',4376.64,NULL,NULL,1,'2021-11-08 14:59:59','2021-11-08 14:59:59',NULL),(2676,3117,40885,13961,3,2511,'App\\Models\\Receipt',2511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',4608.56,NULL,NULL,1,'2021-11-08 14:59:59','2021-11-08 14:59:59',NULL),(2677,3117,40885,13961,3,2512,'App\\Models\\Receipt',2512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',5483.68,NULL,NULL,1,'2021-11-08 14:59:59','2021-11-08 14:59:59',NULL),(2678,3117,40885,13961,3,2513,'App\\Models\\Receipt',2513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',5697.36,NULL,NULL,1,'2021-11-08 14:59:59','2021-11-08 14:59:59',NULL),(2679,3117,40885,13961,3,2514,'App\\Models\\Receipt',2514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23','2021-10-23',13871.93,NULL,NULL,1,'2021-11-08 14:59:59','2021-11-08 14:59:59',NULL),(2680,3117,40885,13961,3,2515,'App\\Models\\Receipt',2515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23','2021-10-23',884.00,NULL,NULL,1,'2021-11-08 14:59:59','2021-11-08 14:59:59',NULL),(2681,3117,40885,13961,3,2516,'App\\Models\\Receipt',2516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',11337.84,NULL,NULL,1,'2021-11-08 14:59:59','2021-11-08 14:59:59',NULL),(2682,3117,40885,13961,3,2517,'App\\Models\\Receipt',2517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',8790.50,NULL,NULL,1,'2021-11-08 14:59:59','2021-11-08 14:59:59',NULL),(2683,3117,40885,13961,3,2518,'App\\Models\\Receipt',2518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',9613.44,NULL,NULL,1,'2021-11-08 14:59:59','2021-11-08 14:59:59',NULL);
INSERT INTO `balance_libro` VALUES (2684,3117,40885,13961,3,2519,'App\\Models\\Receipt',2519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',6130.26,NULL,NULL,1,'2021-11-08 14:59:59','2021-11-08 14:59:59',NULL),(2685,3117,40885,13961,3,2520,'App\\Models\\Receipt',2520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',5419.63,NULL,NULL,1,'2021-11-08 14:59:59','2021-11-08 14:59:59',NULL),(2686,3117,40885,13961,3,2521,'App\\Models\\Receipt',2521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',763.27,NULL,NULL,1,'2021-11-08 14:59:59','2021-11-08 14:59:59',NULL),(2687,3117,40885,13961,3,2522,'App\\Models\\Receipt',2522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-30','2021-10-30',15512.65,NULL,NULL,1,'2021-11-08 14:59:59','2021-11-08 14:59:59',NULL),(2688,3117,40885,13960,2,2523,'App\\Models\\Receipt',2523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',137.00,NULL,NULL,1,'2021-11-08 15:09:13','2021-11-08 15:09:13',NULL),(2689,3117,40885,13960,2,2524,'App\\Models\\Receipt',2524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',270.00,NULL,NULL,1,'2021-11-08 15:09:13','2021-11-08 15:09:13',NULL),(2690,3117,40885,13960,2,2525,'App\\Models\\Receipt',2525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',340.00,NULL,NULL,1,'2021-11-08 15:09:13','2021-11-08 15:09:13',NULL),(2691,3117,40885,13960,2,2526,'App\\Models\\Receipt',2526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',1015.00,NULL,NULL,1,'2021-11-08 15:09:13','2021-11-08 15:09:13',NULL),(2692,3117,40885,13960,2,2527,'App\\Models\\Receipt',2527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',626.00,NULL,NULL,1,'2021-11-08 15:09:13','2021-11-08 15:09:13',NULL),(2693,3117,40885,13960,2,2528,'App\\Models\\Receipt',2528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',220.00,NULL,NULL,1,'2021-11-08 15:09:13','2021-11-08 15:09:13',NULL),(2694,3117,40885,13960,2,2529,'App\\Models\\Receipt',2529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',8000.00,NULL,NULL,1,'2021-11-08 15:09:13','2021-11-08 15:09:13',NULL),(2695,3117,40885,13960,2,2530,'App\\Models\\Receipt',2530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',195.00,NULL,NULL,1,'2021-11-08 15:09:13','2021-11-08 15:09:13',NULL),(2696,3117,40885,13960,2,2531,'App\\Models\\Receipt',2531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',503.00,NULL,NULL,1,'2021-11-08 15:09:13','2021-11-08 15:09:13',NULL),(2697,3117,40885,13960,2,2532,'App\\Models\\Receipt',2532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',1136.00,NULL,NULL,1,'2021-11-08 15:09:13','2021-11-08 15:09:13',NULL),(2698,3117,40885,13960,2,2533,'App\\Models\\Receipt',2533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',615.00,NULL,NULL,1,'2021-11-08 15:09:13','2021-11-08 15:09:13',NULL),(2699,3117,40885,13960,2,2534,'App\\Models\\Receipt',2534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',554.00,NULL,NULL,1,'2021-11-08 15:09:13','2021-11-08 15:09:13',NULL),(2700,3117,40885,13960,2,2535,'App\\Models\\Receipt',2535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',260.00,NULL,NULL,1,'2021-11-08 15:09:13','2021-11-08 15:09:13',NULL),(2701,3117,40885,13960,2,2536,'App\\Models\\Receipt',2536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',973.00,NULL,NULL,1,'2021-11-08 15:09:13','2021-11-08 15:09:13',NULL),(2702,3117,40885,13960,2,2537,'App\\Models\\Receipt',2537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',755.00,NULL,NULL,1,'2021-11-08 15:09:13','2021-11-08 15:09:13',NULL),(2703,3117,40885,13960,2,2538,'App\\Models\\Receipt',2538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',935.00,NULL,NULL,1,'2021-11-08 15:09:13','2021-11-08 15:09:13',NULL),(2704,3117,40885,13960,2,2539,'App\\Models\\Receipt',2539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',730.00,NULL,NULL,1,'2021-11-08 15:09:13','2021-11-08 15:09:13',NULL);
INSERT INTO `balance_libro` VALUES (2705,3117,40885,13960,2,2540,'App\\Models\\Receipt',2540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',682.00,NULL,NULL,1,'2021-11-08 15:09:14','2021-11-08 15:09:14',NULL),(2706,3117,40885,13960,2,2541,'App\\Models\\Receipt',2541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',330.00,NULL,NULL,1,'2021-11-08 15:09:14','2021-11-08 15:09:14',NULL),(2707,3117,40885,13960,2,2542,'App\\Models\\Receipt',2542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',350.00,NULL,NULL,1,'2021-11-08 15:09:14','2021-11-08 15:09:14',NULL),(2708,3117,40885,13960,2,2543,'App\\Models\\Receipt',2543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',650.00,NULL,NULL,1,'2021-11-08 15:09:14','2021-11-08 15:09:14',NULL),(2709,3117,40885,13960,2,2544,'App\\Models\\Receipt',2544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',451.00,NULL,NULL,1,'2021-11-08 15:09:14','2021-11-08 15:09:14',NULL),(2710,3117,40885,13960,2,2545,'App\\Models\\Receipt',2545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',772.35,NULL,NULL,1,'2021-11-08 15:09:14','2021-11-08 15:09:14',NULL),(2711,3117,40885,13960,2,2546,'App\\Models\\Receipt',2546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',772.35,NULL,NULL,1,'2021-11-08 15:09:14','2021-11-08 15:09:14',NULL),(2712,3117,40885,13960,2,2547,'App\\Models\\Receipt',2547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',772.35,NULL,NULL,1,'2021-11-08 15:09:14','2021-11-08 15:09:14',NULL),(2713,3117,40885,13960,2,2548,'App\\Models\\Receipt',2548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',520.00,NULL,NULL,1,'2021-11-08 15:09:14','2021-11-08 15:09:14',NULL),(2714,3117,40885,13960,2,2549,'App\\Models\\Receipt',2549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',265.00,NULL,NULL,1,'2021-11-08 15:09:14','2021-11-08 15:09:14',NULL),(2715,3117,40885,13960,2,2550,'App\\Models\\Receipt',2550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',265.00,NULL,NULL,1,'2021-11-08 15:09:14','2021-11-08 15:09:14',NULL),(2716,3117,40885,13960,2,2551,'App\\Models\\Receipt',2551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',230.00,NULL,NULL,1,'2021-11-08 15:09:14','2021-11-08 15:09:14',NULL),(2717,3117,40885,13960,2,2552,'App\\Models\\Receipt',2552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',1000.00,NULL,NULL,1,'2021-11-08 15:09:14','2021-11-08 15:09:14',NULL),(2718,3117,40885,13960,2,2553,'App\\Models\\Receipt',2553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',217.00,NULL,NULL,1,'2021-11-08 15:09:14','2021-11-08 15:09:14',NULL),(2719,3117,40885,13960,2,2554,'App\\Models\\Receipt',2554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',322.00,NULL,NULL,1,'2021-11-08 15:09:14','2021-11-08 15:09:14',NULL),(2720,3117,40885,13960,2,2555,'App\\Models\\Receipt',2555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',205.00,NULL,NULL,1,'2021-11-08 15:09:14','2021-11-08 15:09:14',NULL),(2721,3117,40885,13960,2,2556,'App\\Models\\Receipt',2556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',310.00,NULL,NULL,1,'2021-11-08 15:09:14','2021-11-08 15:09:14',NULL),(2722,3117,40885,13960,2,2557,'App\\Models\\Receipt',2557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',1107.00,NULL,NULL,1,'2021-11-08 15:09:14','2021-11-08 15:09:14',NULL),(2723,3117,40885,13960,2,2558,'App\\Models\\Receipt',2558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',450.00,NULL,NULL,1,'2021-11-08 15:09:14','2021-11-08 15:09:14',NULL),(2724,3117,40885,13960,2,2559,'App\\Models\\Receipt',2559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',1198.00,NULL,NULL,1,'2021-11-08 15:09:14','2021-11-08 15:09:14',NULL),(2725,3117,40885,13960,2,2560,'App\\Models\\Receipt',2560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',347.00,NULL,NULL,1,'2021-11-08 15:09:14','2021-11-08 15:09:14',NULL);
INSERT INTO `balance_libro` VALUES (2726,3117,40885,13960,2,2561,'App\\Models\\Receipt',2561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',940.00,NULL,NULL,1,'2021-11-08 15:09:14','2021-11-08 15:09:14',NULL),(2727,3117,40885,13960,2,2562,'App\\Models\\Receipt',2562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',1667.00,NULL,NULL,1,'2021-11-08 15:09:14','2021-11-08 15:09:14',NULL),(2728,3117,40885,13960,2,2563,'App\\Models\\Receipt',2563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',1620.00,NULL,NULL,1,'2021-11-08 15:09:14','2021-11-08 15:09:14',NULL),(2729,3117,40885,13960,2,2564,'App\\Models\\Receipt',2564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',500.00,NULL,NULL,1,'2021-11-08 15:09:14','2021-11-08 15:09:14',NULL),(2730,3117,40885,13960,2,2565,'App\\Models\\Receipt',2565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',1000.00,NULL,NULL,1,'2021-11-08 15:09:14','2021-11-08 15:09:14',NULL),(2731,3117,40885,13960,2,2566,'App\\Models\\Receipt',2566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',225.00,NULL,NULL,1,'2021-11-08 15:09:14','2021-11-08 15:09:14',NULL),(2732,3117,40885,13960,2,2567,'App\\Models\\Receipt',2567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',662.00,NULL,NULL,1,'2021-11-08 15:09:14','2021-11-08 15:09:14',NULL),(2733,3117,40885,13960,2,2568,'App\\Models\\Receipt',2568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',558.00,NULL,NULL,1,'2021-11-08 15:09:14','2021-11-08 15:09:14',NULL),(2734,3117,40885,13960,2,2569,'App\\Models\\Receipt',2569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',820.00,NULL,NULL,1,'2021-11-08 15:09:14','2021-11-08 15:09:14',NULL),(2735,3117,40885,13960,2,2570,'App\\Models\\Receipt',2570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',226.00,NULL,NULL,1,'2021-11-08 15:09:14','2021-11-08 15:09:14',NULL),(2736,3117,40885,13960,2,2571,'App\\Models\\Receipt',2571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',452.00,NULL,NULL,1,'2021-11-08 15:09:15','2021-11-08 15:09:15',NULL),(2737,3117,40885,13960,2,2572,'App\\Models\\Receipt',2572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',1055.00,NULL,NULL,1,'2021-11-08 15:09:15','2021-11-08 15:09:15',NULL),(2738,3117,40885,13960,2,2573,'App\\Models\\Receipt',2573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',120.00,NULL,NULL,1,'2021-11-08 15:09:15','2021-11-08 15:09:15',NULL),(2739,3117,40885,13960,2,2574,'App\\Models\\Receipt',2574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',603.00,NULL,NULL,1,'2021-11-08 15:09:15','2021-11-08 15:09:15',NULL),(2740,3117,40885,13960,2,2575,'App\\Models\\Receipt',2575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',812.00,NULL,NULL,1,'2021-11-08 15:09:15','2021-11-08 15:09:15',NULL),(2741,3117,40885,13960,2,2576,'App\\Models\\Receipt',2576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',510.00,NULL,NULL,1,'2021-11-08 15:09:15','2021-11-08 15:09:15',NULL),(2742,3117,40885,13960,2,2577,'App\\Models\\Receipt',2577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',10000.00,NULL,NULL,1,'2021-11-08 15:09:15','2021-11-08 15:09:15',NULL),(2743,3117,40885,13960,2,2578,'App\\Models\\Receipt',2578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',35900.00,NULL,NULL,1,'2021-11-08 15:09:15','2021-11-08 15:09:15',NULL),(2744,3117,40885,13960,2,2579,'App\\Models\\Receipt',2579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',587.00,NULL,NULL,1,'2021-11-08 15:09:15','2021-11-08 15:09:15',NULL),(2745,3117,40885,13960,2,2580,'App\\Models\\Receipt',2580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',2692.00,NULL,NULL,1,'2021-11-08 15:09:15','2021-11-08 15:09:15',NULL),(2746,3117,40885,13960,2,2581,'App\\Models\\Receipt',2581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',2105.00,NULL,NULL,1,'2021-11-08 15:09:15','2021-11-08 15:09:15',NULL);
INSERT INTO `balance_libro` VALUES (2747,3117,40885,13960,2,2582,'App\\Models\\Receipt',2582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',871.00,NULL,NULL,1,'2021-11-08 15:09:15','2021-11-08 15:09:15',NULL),(2748,3117,40885,13960,2,2583,'App\\Models\\Receipt',2583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',1000.00,NULL,NULL,1,'2021-11-08 15:09:15','2021-11-08 15:09:15',NULL),(2749,3117,40885,13960,2,2584,'App\\Models\\Receipt',2584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',1200.00,NULL,NULL,1,'2021-11-08 15:09:15','2021-11-08 15:09:15',NULL),(2750,3117,40885,13960,2,2585,'App\\Models\\Receipt',2585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',547.00,NULL,NULL,1,'2021-11-08 15:09:15','2021-11-08 15:09:15',NULL),(2751,3117,40885,13960,2,2586,'App\\Models\\Receipt',2586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',1216.00,NULL,NULL,1,'2021-11-08 15:09:15','2021-11-08 15:09:15',NULL),(2752,3117,40885,13960,2,2587,'App\\Models\\Receipt',2587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',200.00,NULL,NULL,1,'2021-11-08 15:09:15','2021-11-08 15:09:15',NULL),(2753,3117,40885,13960,2,2588,'App\\Models\\Receipt',2588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',1668.00,NULL,NULL,1,'2021-11-08 15:09:15','2021-11-08 15:09:15',NULL),(2754,3117,40885,13960,2,2589,'App\\Models\\Receipt',2589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-05','2021-09-05',902.27,NULL,NULL,1,'2021-11-08 15:09:15','2021-11-08 15:09:15',NULL),(2755,3117,40885,13960,2,2590,'App\\Models\\Receipt',2590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-05','2021-09-05',120.00,NULL,NULL,1,'2021-11-08 15:09:15','2021-11-08 15:09:15',NULL),(2756,3117,40885,13960,2,2591,'App\\Models\\Receipt',2591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-05','2021-09-05',661.00,NULL,NULL,1,'2021-11-08 15:09:15','2021-11-08 15:09:15',NULL),(2757,3117,40885,13960,2,2592,'App\\Models\\Receipt',2592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-05','2021-09-05',1326.00,NULL,NULL,1,'2021-11-08 15:09:15','2021-11-08 15:09:15',NULL),(2758,3117,40885,13960,2,2593,'App\\Models\\Receipt',2593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-05','2021-09-05',480.00,NULL,NULL,1,'2021-11-08 15:09:15','2021-11-08 15:09:15',NULL),(2759,3117,40885,13960,2,2594,'App\\Models\\Receipt',2594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-05','2021-09-05',800.00,NULL,NULL,1,'2021-11-08 15:09:15','2021-11-08 15:09:15',NULL),(2760,3117,40885,13960,2,2595,'App\\Models\\Receipt',2595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',736.00,NULL,NULL,1,'2021-11-08 15:09:15','2021-11-08 15:09:15',NULL),(2761,3117,40885,13960,2,2596,'App\\Models\\Receipt',2596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',3826.00,NULL,NULL,1,'2021-11-08 15:09:15','2021-11-08 15:09:15',NULL),(2762,3117,40885,13960,2,2597,'App\\Models\\Receipt',2597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',340.00,NULL,NULL,1,'2021-11-08 15:09:15','2021-11-08 15:09:15',NULL),(2763,3117,40885,13960,2,2598,'App\\Models\\Receipt',2598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',700.00,NULL,NULL,1,'2021-11-08 15:09:15','2021-11-08 15:09:15',NULL),(2764,3117,40885,13960,2,2599,'App\\Models\\Receipt',2599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',1209.00,NULL,NULL,1,'2021-11-08 15:09:16','2021-11-08 15:09:16',NULL),(2765,3117,40885,13960,2,2600,'App\\Models\\Receipt',2600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',197.00,NULL,NULL,1,'2021-11-08 15:09:16','2021-11-08 15:09:16',NULL),(2766,3117,40885,13960,2,2601,'App\\Models\\Receipt',2601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',826.00,NULL,NULL,1,'2021-11-08 15:09:16','2021-11-08 15:09:16',NULL),(2767,3117,40885,13960,2,2602,'App\\Models\\Receipt',2602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',78.00,NULL,NULL,1,'2021-11-08 15:09:16','2021-11-08 15:09:16',NULL);
INSERT INTO `balance_libro` VALUES (2768,3117,40885,13960,2,2603,'App\\Models\\Receipt',2603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',675.00,NULL,NULL,1,'2021-11-08 15:09:16','2021-11-08 15:09:16',NULL),(2769,3117,40885,13960,2,2604,'App\\Models\\Receipt',2604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',1047.00,NULL,NULL,1,'2021-11-08 15:09:16','2021-11-08 15:09:16',NULL),(2770,3117,40885,13960,2,2605,'App\\Models\\Receipt',2605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',14620.00,NULL,NULL,1,'2021-11-08 15:09:16','2021-11-08 15:09:16',NULL),(2771,3117,40885,13960,2,2606,'App\\Models\\Receipt',2606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',400.00,NULL,NULL,1,'2021-11-08 15:09:16','2021-11-08 15:09:16',NULL),(2772,3117,40885,13960,2,2607,'App\\Models\\Receipt',2607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',410.00,NULL,NULL,1,'2021-11-08 15:09:16','2021-11-08 15:09:16',NULL),(2773,3117,40885,13960,2,2608,'App\\Models\\Receipt',2608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',2500.00,NULL,NULL,1,'2021-11-08 15:09:16','2021-11-08 15:09:16',NULL),(2774,3117,40885,13960,2,2609,'App\\Models\\Receipt',2609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',584.00,NULL,NULL,1,'2021-11-08 15:09:16','2021-11-08 15:09:16',NULL),(2775,3117,40885,13960,2,2610,'App\\Models\\Receipt',2610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',773.00,NULL,NULL,1,'2021-11-08 15:09:16','2021-11-08 15:09:16',NULL),(2776,3117,40885,13960,2,2611,'App\\Models\\Receipt',2611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',4663.00,NULL,NULL,1,'2021-11-08 15:09:16','2021-11-08 15:09:16',NULL),(2777,3117,40885,13960,2,2612,'App\\Models\\Receipt',2612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',294.00,NULL,NULL,1,'2021-11-08 15:09:16','2021-11-08 15:09:16',NULL),(2778,3117,40885,13960,2,2613,'App\\Models\\Receipt',2613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',871.00,NULL,NULL,1,'2021-11-08 15:09:16','2021-11-08 15:09:16',NULL),(2779,3117,40885,13960,2,2614,'App\\Models\\Receipt',2614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',647.00,NULL,NULL,1,'2021-11-08 15:09:16','2021-11-08 15:09:16',NULL),(2780,3117,40885,13960,2,2615,'App\\Models\\Receipt',2615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',812.00,NULL,NULL,1,'2021-11-08 15:09:16','2021-11-08 15:09:16',NULL),(2781,3117,40885,13960,2,2616,'App\\Models\\Receipt',2616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',460.00,NULL,NULL,1,'2021-11-08 15:09:16','2021-11-08 15:09:16',NULL),(2782,3117,40885,13960,2,2617,'App\\Models\\Receipt',2617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',735.00,NULL,NULL,1,'2021-11-08 15:09:16','2021-11-08 15:09:16',NULL),(2783,3117,40885,13960,2,2618,'App\\Models\\Receipt',2618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',257.00,NULL,NULL,1,'2021-11-08 15:09:16','2021-11-08 15:09:16',NULL),(2784,3117,40885,13960,2,2619,'App\\Models\\Receipt',2619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',365.00,NULL,NULL,1,'2021-11-08 15:09:16','2021-11-08 15:09:16',NULL),(2785,3117,40885,13960,2,2620,'App\\Models\\Receipt',2620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',914.00,NULL,NULL,1,'2021-11-08 15:09:16','2021-11-08 15:09:16',NULL),(2786,3117,40885,13960,2,2621,'App\\Models\\Receipt',2621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',795.00,NULL,NULL,1,'2021-11-08 15:09:16','2021-11-08 15:09:16',NULL),(2787,3117,40885,13960,2,2622,'App\\Models\\Receipt',2622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',360.00,NULL,NULL,1,'2021-11-08 15:09:16','2021-11-08 15:09:16',NULL),(2788,3117,40885,13960,2,2623,'App\\Models\\Receipt',2623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',676.00,NULL,NULL,1,'2021-11-08 15:09:16','2021-11-08 15:09:16',NULL);
INSERT INTO `balance_libro` VALUES (2789,3117,40885,13960,2,2624,'App\\Models\\Receipt',2624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',360.00,NULL,NULL,1,'2021-11-08 15:09:16','2021-11-08 15:09:16',NULL),(2790,3117,40885,13960,2,2625,'App\\Models\\Receipt',2625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',420.00,NULL,NULL,1,'2021-11-08 15:09:16','2021-11-08 15:09:16',NULL),(2791,3117,40885,13960,2,2626,'App\\Models\\Receipt',2626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',296.00,NULL,NULL,1,'2021-11-08 15:09:17','2021-11-08 15:09:17',NULL),(2792,3117,40885,13960,2,2627,'App\\Models\\Receipt',2627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',2292.00,NULL,NULL,1,'2021-11-08 15:09:17','2021-11-08 15:09:17',NULL),(2793,3117,40885,13960,2,2628,'App\\Models\\Receipt',2628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',917.00,NULL,NULL,1,'2021-11-08 15:09:17','2021-11-08 15:09:17',NULL),(2794,3117,40885,13960,2,2629,'App\\Models\\Receipt',2629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',785.00,NULL,NULL,1,'2021-11-08 15:09:17','2021-11-08 15:09:17',NULL),(2795,3117,40885,13960,2,2630,'App\\Models\\Receipt',2630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',600.00,NULL,NULL,1,'2021-11-08 15:09:17','2021-11-08 15:09:17',NULL),(2796,3117,40885,13960,2,2631,'App\\Models\\Receipt',2631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',495.00,NULL,NULL,1,'2021-11-08 15:09:17','2021-11-08 15:09:17',NULL),(2797,3117,40885,13960,2,2632,'App\\Models\\Receipt',2632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',1240.00,NULL,NULL,1,'2021-11-08 15:09:17','2021-11-08 15:09:17',NULL),(2798,3117,40885,13960,2,2633,'App\\Models\\Receipt',2633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',227.00,NULL,NULL,1,'2021-11-08 15:09:17','2021-11-08 15:09:17',NULL),(2799,3117,40885,13960,2,2634,'App\\Models\\Receipt',2634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',3120.00,NULL,NULL,1,'2021-11-08 15:09:17','2021-11-08 15:09:17',NULL),(2800,3117,40885,13960,2,2635,'App\\Models\\Receipt',2635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',1049.00,NULL,NULL,1,'2021-11-08 15:09:17','2021-11-08 15:09:17',NULL),(2801,3117,40885,13960,2,2636,'App\\Models\\Receipt',2636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',1021.00,NULL,NULL,1,'2021-11-08 15:09:17','2021-11-08 15:09:17',NULL),(2802,3117,40885,13960,2,2637,'App\\Models\\Receipt',2637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11','2021-09-11',219.00,NULL,NULL,1,'2021-11-08 15:09:17','2021-11-08 15:09:17',NULL),(2803,3117,40885,13960,2,2638,'App\\Models\\Receipt',2638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11','2021-09-11',370.00,NULL,NULL,1,'2021-11-08 15:09:17','2021-11-08 15:09:17',NULL),(2804,3117,40885,13960,2,2639,'App\\Models\\Receipt',2639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11','2021-09-11',246.00,NULL,NULL,1,'2021-11-08 15:09:17','2021-11-08 15:09:17',NULL),(2805,3117,40885,13960,2,2640,'App\\Models\\Receipt',2640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11','2021-09-11',600.00,NULL,NULL,1,'2021-11-08 15:09:17','2021-11-08 15:09:17',NULL),(2806,3117,40885,13960,2,2641,'App\\Models\\Receipt',2641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11','2021-09-11',362.00,NULL,NULL,1,'2021-11-08 15:09:17','2021-11-08 15:09:17',NULL),(2807,3117,40885,13960,2,2642,'App\\Models\\Receipt',2642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-12','2021-09-12',1332.00,NULL,NULL,1,'2021-11-08 15:09:17','2021-11-08 15:09:17',NULL),(2808,3117,40885,13960,2,2643,'App\\Models\\Receipt',2643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-12','2021-09-12',512.00,NULL,NULL,1,'2021-11-08 15:09:17','2021-11-08 15:09:17',NULL),(2809,3117,40885,13960,2,2644,'App\\Models\\Receipt',2644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-12','2021-09-12',953.00,NULL,NULL,1,'2021-11-08 15:09:17','2021-11-08 15:09:17',NULL);
INSERT INTO `balance_libro` VALUES (2810,3117,40885,13960,2,2645,'App\\Models\\Receipt',2645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-12','2021-09-12',400.00,NULL,NULL,1,'2021-11-08 15:09:17','2021-11-08 15:09:17',NULL),(2811,3117,40885,13960,2,2646,'App\\Models\\Receipt',2646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-12','2021-09-12',1310.00,NULL,NULL,1,'2021-11-08 15:09:17','2021-11-08 15:09:17',NULL),(2812,3117,40885,13960,2,2647,'App\\Models\\Receipt',2647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-12','2021-09-12',420.00,NULL,NULL,1,'2021-11-08 15:09:17','2021-11-08 15:09:17',NULL),(2813,3117,40885,13960,2,2648,'App\\Models\\Receipt',2648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-12','2021-09-12',701.00,NULL,NULL,1,'2021-11-08 15:09:17','2021-11-08 15:09:17',NULL),(2814,3117,40885,13960,2,2649,'App\\Models\\Receipt',2649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-12','2021-09-12',470.00,NULL,NULL,1,'2021-11-08 15:09:17','2021-11-08 15:09:17',NULL),(2815,3117,40885,13960,2,2650,'App\\Models\\Receipt',2650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-12','2021-09-12',363.00,NULL,NULL,1,'2021-11-08 15:09:17','2021-11-08 15:09:17',NULL),(2816,3117,40885,13960,2,2651,'App\\Models\\Receipt',2651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-12','2021-09-12',375.00,NULL,NULL,1,'2021-11-08 15:09:17','2021-11-08 15:09:17',NULL),(2817,3117,40885,13960,2,2652,'App\\Models\\Receipt',2652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',785.00,NULL,NULL,1,'2021-11-08 15:09:17','2021-11-08 15:09:17',NULL),(2818,3117,40885,13960,2,2653,'App\\Models\\Receipt',2653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',50.00,NULL,NULL,1,'2021-11-08 15:09:17','2021-11-08 15:09:17',NULL),(2819,3117,40885,13960,2,2654,'App\\Models\\Receipt',2654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',776.00,NULL,NULL,1,'2021-11-08 15:09:17','2021-11-08 15:09:17',NULL),(2820,3117,40885,13960,2,2655,'App\\Models\\Receipt',2655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',615.00,NULL,NULL,1,'2021-11-08 15:09:18','2021-11-08 15:09:18',NULL),(2821,3117,40885,13960,2,2656,'App\\Models\\Receipt',2656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',920.00,NULL,NULL,1,'2021-11-08 15:09:18','2021-11-08 15:09:18',NULL),(2822,3117,40885,13960,2,2657,'App\\Models\\Receipt',2657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',992.00,NULL,NULL,1,'2021-11-08 15:09:18','2021-11-08 15:09:18',NULL),(2823,3117,40885,13960,2,2658,'App\\Models\\Receipt',2658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',660.00,NULL,NULL,1,'2021-11-08 15:09:18','2021-11-08 15:09:18',NULL),(2824,3117,40885,13960,2,2659,'App\\Models\\Receipt',2659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',430.00,NULL,NULL,1,'2021-11-08 15:09:18','2021-11-08 15:09:18',NULL),(2825,3117,40885,13960,2,2660,'App\\Models\\Receipt',2660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',1275.00,NULL,NULL,1,'2021-11-08 15:09:18','2021-11-08 15:09:18',NULL),(2826,3117,40885,13960,2,2661,'App\\Models\\Receipt',2661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',466.75,NULL,NULL,1,'2021-11-08 15:09:18','2021-11-08 15:09:18',NULL),(2827,3117,40885,13960,2,2662,'App\\Models\\Receipt',2662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',1820.00,NULL,NULL,1,'2021-11-08 15:09:18','2021-11-08 15:09:18',NULL),(2828,3117,40885,13960,2,2663,'App\\Models\\Receipt',2663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',324.00,NULL,NULL,1,'2021-11-08 15:09:18','2021-11-08 15:09:18',NULL),(2829,3117,40885,13960,2,2664,'App\\Models\\Receipt',2664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',1273.00,NULL,NULL,1,'2021-11-08 15:09:18','2021-11-08 15:09:18',NULL),(2830,3117,40885,13960,2,2665,'App\\Models\\Receipt',2665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',937.00,NULL,NULL,1,'2021-11-08 15:09:18','2021-11-08 15:09:18',NULL);
INSERT INTO `balance_libro` VALUES (2831,3117,40885,13960,2,2666,'App\\Models\\Receipt',2666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',1215.00,NULL,NULL,1,'2021-11-08 15:09:18','2021-11-08 15:09:18',NULL),(2832,3117,40885,13960,2,2667,'App\\Models\\Receipt',2667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',339.00,NULL,NULL,1,'2021-11-08 15:09:18','2021-11-08 15:09:18',NULL),(2833,3117,40885,13960,2,2668,'App\\Models\\Receipt',2668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',277.00,NULL,NULL,1,'2021-11-08 15:09:18','2021-11-08 15:09:18',NULL),(2834,3117,40885,13960,2,2669,'App\\Models\\Receipt',2669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',412.00,NULL,NULL,1,'2021-11-08 15:09:18','2021-11-08 15:09:18',NULL),(2835,3117,40885,13960,2,2670,'App\\Models\\Receipt',2670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',258.00,NULL,NULL,1,'2021-11-08 15:09:18','2021-11-08 15:09:18',NULL),(2836,3117,40885,13960,2,2671,'App\\Models\\Receipt',2671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',615.00,NULL,NULL,1,'2021-11-08 15:09:18','2021-11-08 15:09:18',NULL),(2837,3117,40885,13960,2,2672,'App\\Models\\Receipt',2672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',253.00,NULL,NULL,1,'2021-11-08 15:09:18','2021-11-08 15:09:18',NULL),(2838,3117,40885,13960,2,2673,'App\\Models\\Receipt',2673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',370.00,NULL,NULL,1,'2021-11-08 15:09:18','2021-11-08 15:09:18',NULL),(2839,3117,40885,13960,2,2674,'App\\Models\\Receipt',2674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',500.00,NULL,NULL,1,'2021-11-08 15:09:18','2021-11-08 15:09:18',NULL),(2840,3117,40885,13960,2,2675,'App\\Models\\Receipt',2675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',942.00,NULL,NULL,1,'2021-11-08 15:09:18','2021-11-08 15:09:18',NULL),(2841,3117,40885,13960,2,2676,'App\\Models\\Receipt',2676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',403.00,NULL,NULL,1,'2021-11-08 15:09:18','2021-11-08 15:09:18',NULL),(2842,3117,40885,13960,2,2677,'App\\Models\\Receipt',2677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',719.00,NULL,NULL,1,'2021-11-08 15:09:18','2021-11-08 15:09:18',NULL),(2843,3117,40885,13960,2,2678,'App\\Models\\Receipt',2678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',250.00,NULL,NULL,1,'2021-11-08 15:09:18','2021-11-08 15:09:18',NULL),(2844,3117,40885,13960,2,2679,'App\\Models\\Receipt',2679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',760.00,NULL,NULL,1,'2021-11-08 15:09:18','2021-11-08 15:09:18',NULL),(2845,3117,40885,13960,2,2680,'App\\Models\\Receipt',2680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',470.00,NULL,NULL,1,'2021-11-08 15:09:18','2021-11-08 15:09:18',NULL),(2846,3117,40885,13960,2,2681,'App\\Models\\Receipt',2681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',704.00,NULL,NULL,1,'2021-11-08 15:09:18','2021-11-08 15:09:18',NULL),(2847,3117,40885,13960,2,2682,'App\\Models\\Receipt',2682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',519.00,NULL,NULL,1,'2021-11-08 15:09:18','2021-11-08 15:09:18',NULL),(2848,3117,40885,13960,2,2683,'App\\Models\\Receipt',2683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',250.00,NULL,NULL,1,'2021-11-08 15:09:18','2021-11-08 15:09:18',NULL),(2849,3117,40885,13960,2,2684,'App\\Models\\Receipt',2684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',220.00,NULL,NULL,1,'2021-11-08 15:09:19','2021-11-08 15:09:19',NULL),(2850,3117,40885,13960,2,2685,'App\\Models\\Receipt',2685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',423.00,NULL,NULL,1,'2021-11-08 15:09:19','2021-11-08 15:09:19',NULL),(2851,3117,40885,13960,2,2686,'App\\Models\\Receipt',2686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',1122.00,NULL,NULL,1,'2021-11-08 15:09:19','2021-11-08 15:09:19',NULL);
INSERT INTO `balance_libro` VALUES (2852,3117,40885,13960,2,2687,'App\\Models\\Receipt',2687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',265.00,NULL,NULL,1,'2021-11-08 15:09:19','2021-11-08 15:09:19',NULL),(2853,3117,40885,13960,2,2688,'App\\Models\\Receipt',2688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',5592.73,NULL,NULL,1,'2021-11-08 15:09:19','2021-11-08 15:09:19',NULL),(2854,3117,40885,13960,2,2689,'App\\Models\\Receipt',2689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',1451.00,NULL,NULL,1,'2021-11-08 15:09:19','2021-11-08 15:09:19',NULL),(2855,3117,40885,13960,2,2690,'App\\Models\\Receipt',2690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',511.00,NULL,NULL,1,'2021-11-08 15:09:19','2021-11-08 15:09:19',NULL),(2856,3117,40885,13960,2,2691,'App\\Models\\Receipt',2691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',10.00,NULL,NULL,1,'2021-11-08 15:09:19','2021-11-08 15:09:19',NULL),(2857,3117,40885,13960,2,2692,'App\\Models\\Receipt',2692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',821.00,NULL,NULL,1,'2021-11-08 15:09:19','2021-11-08 15:09:19',NULL),(2858,3117,40885,13960,2,2693,'App\\Models\\Receipt',2693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',1541.50,NULL,NULL,1,'2021-11-08 15:09:19','2021-11-08 15:09:19',NULL),(2859,3117,40885,13960,2,2694,'App\\Models\\Receipt',2694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',984.00,NULL,NULL,1,'2021-11-08 15:09:19','2021-11-08 15:09:19',NULL),(2860,3117,40885,13960,2,2695,'App\\Models\\Receipt',2695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',1872.00,NULL,NULL,1,'2021-11-08 15:09:19','2021-11-08 15:09:19',NULL),(2861,3117,40885,13960,2,2696,'App\\Models\\Receipt',2696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',450.00,NULL,NULL,1,'2021-11-08 15:09:19','2021-11-08 15:09:19',NULL),(2862,3117,40885,13960,2,2697,'App\\Models\\Receipt',2697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',1397.00,NULL,NULL,1,'2021-11-08 15:09:19','2021-11-08 15:09:19',NULL),(2863,3117,40885,13960,2,2698,'App\\Models\\Receipt',2698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',10400.00,NULL,NULL,1,'2021-11-08 15:09:19','2021-11-08 15:09:19',NULL),(2864,3117,40885,13960,2,2699,'App\\Models\\Receipt',2699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',537.00,NULL,NULL,1,'2021-11-08 15:09:19','2021-11-08 15:09:19',NULL),(2865,3117,40885,13960,2,2700,'App\\Models\\Receipt',2700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',1400.00,NULL,NULL,1,'2021-11-08 15:09:19','2021-11-08 15:09:19',NULL),(2866,3117,40885,13960,2,2701,'App\\Models\\Receipt',2701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',680.00,NULL,NULL,1,'2021-11-08 15:09:19','2021-11-08 15:09:19',NULL),(2867,3117,40885,13960,2,2702,'App\\Models\\Receipt',2702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',765.00,NULL,NULL,1,'2021-11-08 15:09:19','2021-11-08 15:09:19',NULL),(2868,3117,40885,13960,2,2703,'App\\Models\\Receipt',2703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-18','2021-09-18',618.00,NULL,NULL,1,'2021-11-08 15:09:19','2021-11-08 15:09:19',NULL),(2869,3117,40885,13960,2,2704,'App\\Models\\Receipt',2704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',560.00,NULL,NULL,1,'2021-11-08 15:09:19','2021-11-08 15:09:19',NULL),(2870,3117,40885,13960,2,2705,'App\\Models\\Receipt',2705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',840.00,NULL,NULL,1,'2021-11-08 15:09:19','2021-11-08 15:09:19',NULL),(2871,3117,40885,13960,2,2706,'App\\Models\\Receipt',2706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',951.69,NULL,NULL,1,'2021-11-08 15:09:19','2021-11-08 15:09:19',NULL),(2872,3117,40885,13960,2,2707,'App\\Models\\Receipt',2707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',264.00,NULL,NULL,1,'2021-11-08 15:09:19','2021-11-08 15:09:19',NULL);
INSERT INTO `balance_libro` VALUES (2873,3117,40885,13960,2,2708,'App\\Models\\Receipt',2708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',3863.00,NULL,NULL,1,'2021-11-08 15:09:19','2021-11-08 15:09:19',NULL),(2874,3117,40885,13960,2,2709,'App\\Models\\Receipt',2709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',390.00,NULL,NULL,1,'2021-11-08 15:09:19','2021-11-08 15:09:19',NULL),(2875,3117,40885,13960,2,2710,'App\\Models\\Receipt',2710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',440.00,NULL,NULL,1,'2021-11-08 15:09:19','2021-11-08 15:09:19',NULL),(2876,3117,40885,13960,2,2711,'App\\Models\\Receipt',2711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',120.00,NULL,NULL,1,'2021-11-08 15:09:20','2021-11-08 15:09:20',NULL),(2877,3117,40885,13960,2,2712,'App\\Models\\Receipt',2712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',1341.00,NULL,NULL,1,'2021-11-08 15:09:20','2021-11-08 15:09:20',NULL),(2878,3117,40885,13960,2,2713,'App\\Models\\Receipt',2713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',1001.00,NULL,NULL,1,'2021-11-08 15:09:20','2021-11-08 15:09:20',NULL),(2879,3117,40885,13960,2,2714,'App\\Models\\Receipt',2714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',713.00,NULL,NULL,1,'2021-11-08 15:09:20','2021-11-08 15:09:20',NULL),(2880,3117,40885,13960,2,2715,'App\\Models\\Receipt',2715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',850.00,NULL,NULL,1,'2021-11-08 15:09:20','2021-11-08 15:09:20',NULL),(2881,3117,40885,13960,2,2716,'App\\Models\\Receipt',2716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',390.00,NULL,NULL,1,'2021-11-08 15:09:20','2021-11-08 15:09:20',NULL),(2882,3117,40885,13960,2,2717,'App\\Models\\Receipt',2717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',340.00,NULL,NULL,1,'2021-11-08 15:09:20','2021-11-08 15:09:20',NULL),(2883,3117,40885,13960,2,2718,'App\\Models\\Receipt',2718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',210.00,NULL,NULL,1,'2021-11-08 15:09:20','2021-11-08 15:09:20',NULL),(2884,3117,40885,13960,2,2719,'App\\Models\\Receipt',2719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',913.00,NULL,NULL,1,'2021-11-08 15:09:20','2021-11-08 15:09:20',NULL),(2885,3117,40885,13960,2,2720,'App\\Models\\Receipt',2720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',960.00,NULL,NULL,1,'2021-11-08 15:09:20','2021-11-08 15:09:20',NULL),(2886,3117,40885,13960,2,2721,'App\\Models\\Receipt',2721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',572.00,NULL,NULL,1,'2021-11-08 15:09:20','2021-11-08 15:09:20',NULL),(2887,3117,40885,13960,2,2722,'App\\Models\\Receipt',2722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',480.00,NULL,NULL,1,'2021-11-08 15:09:20','2021-11-08 15:09:20',NULL),(2888,3117,40885,13960,2,2723,'App\\Models\\Receipt',2723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',1655.00,NULL,NULL,1,'2021-11-08 15:09:20','2021-11-08 15:09:20',NULL),(2889,3117,40885,13960,2,2724,'App\\Models\\Receipt',2724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',487.00,NULL,NULL,1,'2021-11-08 15:09:20','2021-11-08 15:09:20',NULL),(2890,3117,40885,13960,2,2725,'App\\Models\\Receipt',2725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',678.00,NULL,NULL,1,'2021-11-08 15:09:20','2021-11-08 15:09:20',NULL),(2891,3117,40885,13960,2,2726,'App\\Models\\Receipt',2726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',855.00,NULL,NULL,1,'2021-11-08 15:09:20','2021-11-08 15:09:20',NULL),(2892,3117,40885,13960,2,2727,'App\\Models\\Receipt',2727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',2080.00,NULL,NULL,1,'2021-11-08 15:09:20','2021-11-08 15:09:20',NULL),(2893,3117,40885,13960,2,2728,'App\\Models\\Receipt',2728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',236.00,NULL,NULL,1,'2021-11-08 15:09:20','2021-11-08 15:09:20',NULL);
INSERT INTO `balance_libro` VALUES (2894,3117,40885,13960,2,2729,'App\\Models\\Receipt',2729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',177.50,NULL,NULL,1,'2021-11-08 15:09:20','2021-11-08 15:09:20',NULL),(2895,3117,40885,13960,2,2730,'App\\Models\\Receipt',2730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',450.00,NULL,NULL,1,'2021-11-08 15:09:20','2021-11-08 15:09:20',NULL),(2896,3117,40885,13960,2,2731,'App\\Models\\Receipt',2731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',737.00,NULL,NULL,1,'2021-11-08 15:09:20','2021-11-08 15:09:20',NULL),(2897,3117,40885,13960,2,2732,'App\\Models\\Receipt',2732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',560.00,NULL,NULL,1,'2021-11-08 15:09:20','2021-11-08 15:09:20',NULL),(2898,3117,40885,13960,2,2733,'App\\Models\\Receipt',2733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',930.00,NULL,NULL,1,'2021-11-08 15:09:20','2021-11-08 15:09:20',NULL),(2899,3117,40885,13960,2,2734,'App\\Models\\Receipt',2734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',690.00,NULL,NULL,1,'2021-11-08 15:09:20','2021-11-08 15:09:20',NULL),(2900,3117,40885,13960,2,2735,'App\\Models\\Receipt',2735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',807.00,NULL,NULL,1,'2021-11-08 15:09:20','2021-11-08 15:09:20',NULL),(2901,3117,40885,13960,2,2736,'App\\Models\\Receipt',2736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',500.00,NULL,NULL,1,'2021-11-08 15:09:20','2021-11-08 15:09:20',NULL),(2902,3117,40885,13960,2,2737,'App\\Models\\Receipt',2737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',335.00,NULL,NULL,1,'2021-11-08 15:09:20','2021-11-08 15:09:20',NULL),(2903,3117,40885,13960,2,2738,'App\\Models\\Receipt',2738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',318.00,NULL,NULL,1,'2021-11-08 15:09:20','2021-11-08 15:09:20',NULL),(2904,3117,40885,13960,2,2739,'App\\Models\\Receipt',2739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',810.00,NULL,NULL,1,'2021-11-08 15:09:21','2021-11-08 15:09:21',NULL),(2905,3117,40885,13960,2,2740,'App\\Models\\Receipt',2740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',629.00,NULL,NULL,1,'2021-11-08 15:09:21','2021-11-08 15:09:21',NULL),(2906,3117,40885,13960,2,2741,'App\\Models\\Receipt',2741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',500.00,NULL,NULL,1,'2021-11-08 15:09:21','2021-11-08 15:09:21',NULL),(2907,3117,40885,13960,2,2742,'App\\Models\\Receipt',2742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',600.00,NULL,NULL,1,'2021-11-08 15:09:21','2021-11-08 15:09:21',NULL),(2908,3117,40885,13960,2,2743,'App\\Models\\Receipt',2743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',204.00,NULL,NULL,1,'2021-11-08 15:09:21','2021-11-08 15:09:21',NULL),(2909,3117,40885,13960,2,2744,'App\\Models\\Receipt',2744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',180.00,NULL,NULL,1,'2021-11-08 15:09:21','2021-11-08 15:09:21',NULL),(2910,3117,40885,13960,2,2745,'App\\Models\\Receipt',2745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',276.00,NULL,NULL,1,'2021-11-08 15:09:21','2021-11-08 15:09:21',NULL),(2911,3117,40885,13960,2,2746,'App\\Models\\Receipt',2746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',1514.00,NULL,NULL,1,'2021-11-08 15:09:21','2021-11-08 15:09:21',NULL),(2912,3117,40885,13960,2,2747,'App\\Models\\Receipt',2747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',515.00,NULL,NULL,1,'2021-11-08 15:09:21','2021-11-08 15:09:21',NULL),(2913,3117,40885,13960,2,2748,'App\\Models\\Receipt',2748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',700.00,NULL,NULL,1,'2021-11-08 15:09:21','2021-11-08 15:09:21',NULL),(2914,3117,40885,13960,2,2749,'App\\Models\\Receipt',2749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',518.00,NULL,NULL,1,'2021-11-08 15:09:21','2021-11-08 15:09:21',NULL);
INSERT INTO `balance_libro` VALUES (2915,3117,40885,13960,2,2750,'App\\Models\\Receipt',2750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-26','2021-09-26',5474.69,NULL,NULL,1,'2021-11-08 15:09:21','2021-11-08 15:09:21',NULL),(2916,3117,40885,13960,2,2751,'App\\Models\\Receipt',2751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-26','2021-09-26',1450.00,NULL,NULL,1,'2021-11-08 15:09:21','2021-11-08 15:09:21',NULL),(2917,3117,40885,13960,2,2752,'App\\Models\\Receipt',2752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-26','2021-09-26',1000.00,NULL,NULL,1,'2021-11-08 15:09:21','2021-11-08 15:09:21',NULL),(2918,3117,40885,13960,2,2753,'App\\Models\\Receipt',2753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',1333.00,NULL,NULL,1,'2021-11-08 15:09:21','2021-11-08 15:09:21',NULL),(2919,3117,40885,13960,2,2754,'App\\Models\\Receipt',2754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',6000.00,NULL,NULL,1,'2021-11-08 15:09:21','2021-11-08 15:09:21',NULL),(2920,3117,40885,13960,2,2755,'App\\Models\\Receipt',2755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',148.00,NULL,NULL,1,'2021-11-08 15:09:21','2021-11-08 15:09:21',NULL),(2921,3117,40885,13960,2,2756,'App\\Models\\Receipt',2756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',656.50,NULL,NULL,1,'2021-11-08 15:09:21','2021-11-08 15:09:21',NULL),(2922,3117,40885,13960,2,2757,'App\\Models\\Receipt',2757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',606.00,NULL,NULL,1,'2021-11-08 15:09:21','2021-11-08 15:09:21',NULL),(2923,3117,40885,13960,2,2758,'App\\Models\\Receipt',2758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',180.00,NULL,NULL,1,'2021-11-08 15:09:21','2021-11-08 15:09:21',NULL),(2924,3117,40885,13960,2,2759,'App\\Models\\Receipt',2759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',717.00,NULL,NULL,1,'2021-11-08 15:09:21','2021-11-08 15:09:21',NULL),(2925,3117,40885,13960,2,2760,'App\\Models\\Receipt',2760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',190.00,NULL,NULL,1,'2021-11-08 15:09:21','2021-11-08 15:09:21',NULL),(2926,3117,40885,13960,2,2761,'App\\Models\\Receipt',2761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',177.00,NULL,NULL,1,'2021-11-08 15:09:21','2021-11-08 15:09:21',NULL),(2927,3117,40885,13960,2,2762,'App\\Models\\Receipt',2762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',125.00,NULL,NULL,1,'2021-11-08 15:09:21','2021-11-08 15:09:21',NULL),(2928,3117,40885,13960,2,2763,'App\\Models\\Receipt',2763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',752.00,NULL,NULL,1,'2021-11-08 15:09:21','2021-11-08 15:09:21',NULL),(2929,3117,40885,13960,2,2764,'App\\Models\\Receipt',2764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',8210.00,NULL,NULL,1,'2021-11-08 15:09:21','2021-11-08 15:09:21',NULL),(2930,3117,40885,13960,2,2765,'App\\Models\\Receipt',2765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',1900.00,NULL,NULL,1,'2021-11-08 15:09:22','2021-11-08 15:09:22',NULL),(2931,3117,40885,13960,2,2766,'App\\Models\\Receipt',2766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',3933.36,NULL,NULL,1,'2021-11-08 15:09:22','2021-11-08 15:09:22',NULL),(2932,3117,40885,13960,2,2767,'App\\Models\\Receipt',2767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',328.00,NULL,NULL,1,'2021-11-08 15:09:22','2021-11-08 15:09:22',NULL),(2933,3117,40885,13960,2,2768,'App\\Models\\Receipt',2768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',995.00,NULL,NULL,1,'2021-11-08 15:09:22','2021-11-08 15:09:22',NULL),(2934,3117,40885,13960,2,2769,'App\\Models\\Receipt',2769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',442.00,NULL,NULL,1,'2021-11-08 15:09:22','2021-11-08 15:09:22',NULL),(2935,3117,40885,13960,2,2770,'App\\Models\\Receipt',2770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',445.00,NULL,NULL,1,'2021-11-08 15:09:22','2021-11-08 15:09:22',NULL);
INSERT INTO `balance_libro` VALUES (2936,3117,40885,13960,2,2771,'App\\Models\\Receipt',2771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',1282.00,NULL,NULL,1,'2021-11-08 15:09:22','2021-11-08 15:09:22',NULL),(2937,3117,40885,13960,2,2772,'App\\Models\\Receipt',2772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',180.00,NULL,NULL,1,'2021-11-08 15:09:22','2021-11-08 15:09:22',NULL),(2938,3117,40885,13960,2,2773,'App\\Models\\Receipt',2773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',346.00,NULL,NULL,1,'2021-11-08 15:09:22','2021-11-08 15:09:22',NULL),(2939,3117,40885,13960,2,2774,'App\\Models\\Receipt',2774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',112.00,NULL,NULL,1,'2021-11-08 15:09:22','2021-11-08 15:09:22',NULL),(2940,3117,40885,13960,3,2775,'App\\Models\\Receipt',2775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',3071.38,NULL,NULL,1,'2021-11-08 15:09:40','2021-11-08 15:09:40',NULL),(2941,3117,40885,13960,3,2776,'App\\Models\\Receipt',2776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',4620.61,NULL,NULL,1,'2021-11-08 15:09:40','2021-11-08 15:09:40',NULL),(2942,3117,40885,13960,3,2777,'App\\Models\\Receipt',2777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-04','2021-09-04',2703.03,NULL,NULL,1,'2021-11-08 15:09:40','2021-11-08 15:09:40',NULL),(2943,3117,40885,13960,3,2778,'App\\Models\\Receipt',2778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',1035.01,NULL,NULL,1,'2021-11-08 15:09:40','2021-11-08 15:09:40',NULL),(2944,3117,40885,13960,3,2779,'App\\Models\\Receipt',2779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',13237.83,NULL,NULL,1,'2021-11-08 15:09:40','2021-11-08 15:09:40',NULL),(2945,3117,40885,13960,3,2780,'App\\Models\\Receipt',2780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',410.00,NULL,NULL,1,'2021-11-08 15:09:40','2021-11-08 15:09:40',NULL),(2946,3117,40885,13960,3,2781,'App\\Models\\Receipt',2781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',3463.75,NULL,NULL,1,'2021-11-08 15:09:41','2021-11-08 15:09:41',NULL),(2947,3117,40885,13960,3,2782,'App\\Models\\Receipt',2782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',3046.43,NULL,NULL,1,'2021-11-08 15:09:41','2021-11-08 15:09:41',NULL),(2948,3117,40885,13960,3,2783,'App\\Models\\Receipt',2783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',8216.30,NULL,NULL,1,'2021-11-08 15:09:41','2021-11-08 15:09:41',NULL),(2949,3117,40885,13960,3,2784,'App\\Models\\Receipt',2784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',3290.18,NULL,NULL,1,'2021-11-08 15:09:41','2021-11-08 15:09:41',NULL),(2950,3117,40885,13960,3,2785,'App\\Models\\Receipt',2785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11','2021-09-11',6760.71,NULL,NULL,1,'2021-11-08 15:09:41','2021-11-08 15:09:41',NULL),(2951,3117,40885,13960,3,2786,'App\\Models\\Receipt',2786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',15712.47,NULL,NULL,1,'2021-11-08 15:09:41','2021-11-08 15:09:41',NULL),(2952,3117,40885,13960,3,2787,'App\\Models\\Receipt',2787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',6776.74,NULL,NULL,1,'2021-11-08 15:09:41','2021-11-08 15:09:41',NULL),(2953,3117,40885,13960,3,2788,'App\\Models\\Receipt',2788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',5323.98,NULL,NULL,1,'2021-11-08 15:09:41','2021-11-08 15:09:41',NULL),(2954,3117,40885,13960,3,2789,'App\\Models\\Receipt',2789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',4914.19,NULL,NULL,1,'2021-11-08 15:09:41','2021-11-08 15:09:41',NULL),(2955,3117,40885,13960,3,2790,'App\\Models\\Receipt',2790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-18','2021-09-18',2856.02,NULL,NULL,1,'2021-11-08 15:09:41','2021-11-08 15:09:41',NULL),(2956,3117,40885,13960,3,2791,'App\\Models\\Receipt',2791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',1035.01,NULL,NULL,1,'2021-11-08 15:09:41','2021-11-08 15:09:41',NULL);
INSERT INTO `balance_libro` VALUES (2957,3117,40885,13960,3,2792,'App\\Models\\Receipt',2792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',12787.03,NULL,NULL,1,'2021-11-08 15:09:41','2021-11-08 15:09:41',NULL),(2958,3117,40885,13960,3,2793,'App\\Models\\Receipt',2793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',13118.52,NULL,NULL,1,'2021-11-08 15:09:41','2021-11-08 15:09:41',NULL),(2959,3117,40885,13960,3,2794,'App\\Models\\Receipt',2794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',3219.25,NULL,NULL,1,'2021-11-08 15:09:41','2021-11-08 15:09:41',NULL),(2960,3117,40885,13960,3,2795,'App\\Models\\Receipt',2795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',3547.28,NULL,NULL,1,'2021-11-08 15:09:41','2021-11-08 15:09:41',NULL),(2961,3117,40885,13960,3,2796,'App\\Models\\Receipt',2796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',1500.00,NULL,NULL,1,'2021-11-08 15:09:41','2021-11-08 15:09:41',NULL),(2962,3117,40885,13960,3,2797,'App\\Models\\Receipt',2797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',5308.19,NULL,NULL,1,'2021-11-08 15:09:41','2021-11-08 15:09:41',NULL),(2963,3117,40885,13960,3,2798,'App\\Models\\Receipt',2798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',7526.58,NULL,NULL,1,'2021-11-08 15:09:41','2021-11-08 15:09:41',NULL),(2964,3117,40885,13960,3,2799,'App\\Models\\Receipt',2799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',4165.00,NULL,NULL,1,'2021-11-08 15:09:41','2021-11-08 15:09:41',NULL),(2965,3117,40885,13960,3,2800,'App\\Models\\Receipt',2800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',1035.01,NULL,NULL,1,'2021-11-08 15:09:41','2021-11-08 15:09:41',NULL),(2966,3117,40885,13960,3,2801,'App\\Models\\Receipt',2801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',691.64,NULL,NULL,1,'2021-11-08 15:09:41','2021-11-08 15:09:41',NULL),(2967,3117,40885,13960,3,2802,'App\\Models\\Receipt',2802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',13999.84,NULL,NULL,1,'2021-11-08 15:09:41','2021-11-08 15:09:41',NULL),(2968,3117,40885,13960,3,2803,'App\\Models\\Receipt',2803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',4564.87,NULL,NULL,1,'2021-11-08 15:09:41','2021-11-08 15:09:41',NULL),(2969,3117,40885,13960,3,2804,'App\\Models\\Receipt',2804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',6040.96,NULL,NULL,1,'2021-11-08 15:09:41','2021-11-08 15:09:41',NULL),(2970,3117,40885,13960,3,2805,'App\\Models\\Receipt',2805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',2822.81,NULL,NULL,1,'2021-11-08 15:09:41','2021-11-08 15:09:41',NULL),(2971,3117,40885,13960,3,2806,'App\\Models\\Receipt',2806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',2026.58,NULL,NULL,1,'2021-11-08 15:09:41','2021-11-08 15:09:41',NULL),(3610,3117,40885,13960,3,3445,'App\\Models\\Receipt',3445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',18324.53,NULL,NULL,1,'2021-11-08 15:13:01','2021-11-08 15:13:01',NULL),(3611,3117,40885,13960,3,3446,'App\\Models\\Receipt',3446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',5519.49,NULL,NULL,1,'2021-11-08 15:13:01','2021-11-08 15:13:01',NULL),(3612,3117,40885,13960,3,3447,'App\\Models\\Receipt',3447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-05','2021-08-05',3992.99,NULL,NULL,1,'2021-11-08 15:13:01','2021-11-08 15:23:21','2021-11-08 15:23:21'),(3613,3117,40885,13960,3,3448,'App\\Models\\Receipt',3448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-05','2021-08-05',6907.41,NULL,NULL,1,'2021-11-08 15:13:01','2021-11-08 15:23:09','2021-11-08 15:23:09'),(3614,3117,40885,13960,3,3449,'App\\Models\\Receipt',3449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',4487.96,NULL,NULL,1,'2021-11-08 15:13:01','2021-11-08 15:22:57','2021-11-08 15:22:57');
INSERT INTO `balance_libro` VALUES (3615,3117,40885,13960,3,3450,'App\\Models\\Receipt',3450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-09','2021-08-09',10998.24,NULL,NULL,1,'2021-11-08 15:13:01','2021-11-08 15:22:41','2021-11-08 15:22:41'),(3616,3117,40885,13960,3,3451,'App\\Models\\Receipt',3451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',13400.00,NULL,NULL,1,'2021-11-08 15:13:01','2021-11-08 15:23:55','2021-11-08 15:23:55'),(3617,3117,40885,13960,3,3452,'App\\Models\\Receipt',3452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',1805.56,NULL,NULL,1,'2021-11-08 15:13:01','2021-11-08 15:20:08','2021-11-08 15:20:08'),(3618,3117,40885,13960,3,3453,'App\\Models\\Receipt',3453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',1990.01,NULL,NULL,1,'2021-11-08 15:13:01','2021-11-08 15:13:01',NULL),(3619,3117,40885,13960,3,3454,'App\\Models\\Receipt',3454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',8783.10,NULL,NULL,1,'2021-11-08 15:13:01','2021-11-08 15:13:01',NULL),(3620,3117,40885,13960,3,3455,'App\\Models\\Receipt',3455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',5627.42,NULL,NULL,1,'2021-11-08 15:13:01','2021-11-08 15:13:01',NULL),(3621,3117,40885,13960,3,3456,'App\\Models\\Receipt',3456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',1281.60,NULL,NULL,1,'2021-11-08 15:13:01','2021-11-08 15:13:01',NULL),(3622,3117,40885,13960,3,3457,'App\\Models\\Receipt',3457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-14','2021-08-14',5315.77,NULL,NULL,1,'2021-11-08 15:13:01','2021-11-08 15:19:37','2021-11-08 15:19:37'),(3623,3117,40885,13960,3,3458,'App\\Models\\Receipt',3458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',3355.48,NULL,NULL,1,'2021-11-08 15:13:01','2021-11-08 15:19:23','2021-11-08 15:19:23'),(3624,3117,40885,13960,3,3459,'App\\Models\\Receipt',3459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',995.01,NULL,NULL,1,'2021-11-08 15:13:01','2021-11-08 15:19:10','2021-11-08 15:19:10'),(3625,3117,40885,13960,3,3460,'App\\Models\\Receipt',3460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',9639.27,NULL,NULL,1,'2021-11-08 15:13:01','2021-11-08 15:16:03','2021-11-08 15:16:03'),(3626,3117,40885,13960,3,3461,'App\\Models\\Receipt',3461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',5144.05,NULL,NULL,1,'2021-11-08 15:13:01','2021-11-08 15:15:46','2021-11-08 15:15:46'),(3627,3117,40885,13960,3,3462,'App\\Models\\Receipt',3462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',6624.31,NULL,NULL,1,'2021-11-08 15:13:01','2021-11-08 15:15:26','2021-11-08 15:15:26'),(3628,3117,40885,13960,3,3463,'App\\Models\\Receipt',3463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',3781.98,NULL,NULL,1,'2021-11-08 15:13:01','2021-11-08 15:13:01',NULL),(3629,3117,40885,13960,3,3464,'App\\Models\\Receipt',3464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',3992.99,NULL,NULL,1,'2021-11-08 15:13:01','2021-11-08 15:13:01',NULL),(3630,3117,40885,13960,3,3465,'App\\Models\\Receipt',3465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',6106.12,NULL,NULL,1,'2021-11-08 15:13:01','2021-11-08 15:13:01',NULL),(3631,3117,40885,13960,3,3466,'App\\Models\\Receipt',3466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-26','2021-08-26',2661.99,NULL,NULL,1,'2021-11-08 15:13:01','2021-11-08 15:13:01',NULL),(3632,3117,40885,13960,3,3467,'App\\Models\\Receipt',3467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-28','2021-08-28',10229.63,NULL,NULL,1,'2021-11-08 15:13:01','2021-11-08 15:15:13','2021-11-08 15:15:13'),(3633,3117,40885,13960,3,3468,'App\\Models\\Receipt',3468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',10537.03,NULL,NULL,1,'2021-11-08 15:13:01','2021-11-08 15:15:03','2021-11-08 15:15:03'),(3634,3117,40885,13960,3,3469,'App\\Models\\Receipt',3469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',10956.16,NULL,NULL,1,'2021-11-08 15:13:01','2021-11-08 15:14:52','2021-11-08 15:14:52');
INSERT INTO `balance_libro` VALUES (3635,3117,40885,13960,3,3470,'App\\Models\\Receipt',3470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',4886.57,NULL,NULL,1,'2021-11-08 15:13:02','2021-11-08 15:14:42','2021-11-08 15:14:42'),(3636,3117,40885,13960,3,3471,'App\\Models\\Receipt',3471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',18.04,NULL,NULL,1,'2021-11-08 15:13:02','2021-11-08 15:14:31','2021-11-08 15:14:31'),(3637,3117,40885,13960,3,3472,'App\\Models\\Receipt',3472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',1830.40,NULL,NULL,1,'2021-11-08 15:13:02','2021-11-08 15:14:17','2021-11-08 15:14:17'),(3638,3117,40885,13959,3,3472,'App\\Models\\Receipt',3472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',1830.40,NULL,NULL,1,'2021-11-08 15:14:17','2021-11-08 15:14:17',NULL),(3639,3117,40885,13959,3,3471,'App\\Models\\Receipt',3471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',18.04,NULL,NULL,1,'2021-11-08 15:14:31','2021-11-08 15:15:33','2021-11-08 15:15:33'),(3640,3117,40885,13959,3,3470,'App\\Models\\Receipt',3470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',4886.56,NULL,NULL,1,'2021-11-08 15:14:42','2021-11-08 15:15:52','2021-11-08 15:15:52'),(3641,3117,40885,13959,3,3469,'App\\Models\\Receipt',3469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',10956.16,NULL,NULL,1,'2021-11-08 15:14:52','2021-11-08 15:14:52',NULL),(3642,3117,40885,13959,3,3468,'App\\Models\\Receipt',3468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',10537.00,NULL,NULL,1,'2021-11-08 15:15:03','2021-11-08 15:15:03',NULL),(3643,3117,40885,13959,3,3467,'App\\Models\\Receipt',3467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-28','2021-08-28',10229.63,NULL,NULL,1,'2021-11-08 15:15:13','2021-11-08 15:15:13',NULL),(3644,3117,40885,13959,3,3462,'App\\Models\\Receipt',3462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',6624.31,NULL,NULL,1,'2021-11-08 15:15:26','2021-11-08 15:15:26',NULL),(3645,3117,40885,13959,3,3471,'App\\Models\\Receipt',3471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',18.04,NULL,NULL,1,'2021-11-08 15:15:33','2021-11-08 15:15:33',NULL),(3646,3117,40885,13959,3,3461,'App\\Models\\Receipt',3461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',5144.05,NULL,NULL,1,'2021-11-08 15:15:46','2021-11-08 15:15:46',NULL),(3647,3117,40885,13959,3,3470,'App\\Models\\Receipt',3470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',4886.56,NULL,NULL,1,'2021-11-08 15:15:52','2021-11-08 15:15:52',NULL),(3648,3117,40885,13959,3,3460,'App\\Models\\Receipt',3460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',9639.27,NULL,NULL,1,'2021-11-08 15:16:03','2021-11-08 15:16:03',NULL),(3649,3117,40885,13959,3,3459,'App\\Models\\Receipt',3459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',995.01,NULL,NULL,1,'2021-11-08 15:19:10','2021-11-08 15:19:10',NULL),(3650,3117,40885,13959,3,3458,'App\\Models\\Receipt',3458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',3355.48,NULL,NULL,1,'2021-11-08 15:19:23','2021-11-08 15:19:23',NULL),(3651,3117,40885,13960,3,3457,'App\\Models\\Receipt',3457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-14','2021-08-14',5315.77,NULL,NULL,1,'2021-11-08 15:19:37','2021-11-08 15:19:54','2021-11-08 15:19:54'),(3652,3117,40885,13959,3,3457,'App\\Models\\Receipt',3457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-14','2021-08-14',5315.77,NULL,NULL,1,'2021-11-08 15:19:54','2021-11-08 15:19:54',NULL),(3653,3117,40885,13959,3,3452,'App\\Models\\Receipt',3452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',1805.56,NULL,NULL,1,'2021-11-08 15:20:08','2021-11-08 15:20:08',NULL),(3654,3117,40885,13959,3,3450,'App\\Models\\Receipt',3450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-09','2021-08-09',10998.24,NULL,NULL,1,'2021-11-08 15:22:41','2021-11-08 15:22:41',NULL);
INSERT INTO `balance_libro` VALUES (3655,3117,40885,13959,3,3449,'App\\Models\\Receipt',3449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',4487.96,NULL,NULL,1,'2021-11-08 15:22:57','2021-11-08 15:22:57',NULL),(3656,3117,40885,13959,3,3448,'App\\Models\\Receipt',3448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-05','2021-08-05',6907.41,NULL,NULL,1,'2021-11-08 15:23:09','2021-11-08 15:23:09',NULL),(3657,3117,40885,13959,3,3447,'App\\Models\\Receipt',3447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-05','2021-08-05',3992.99,NULL,NULL,1,'2021-11-08 15:23:21','2021-11-08 15:23:21',NULL),(3658,3117,40736,1546,3,3473,'App\\Models\\Receipt',3473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-02','2021-10-02',338.00,NULL,NULL,1,'2021-11-09 14:25:44','2021-11-09 14:25:44',NULL),(3659,3117,40736,1546,3,3474,'App\\Models\\Receipt',3474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',8235.00,NULL,NULL,1,'2021-11-09 14:25:44','2021-11-09 14:25:44',NULL),(3660,3117,40736,1546,3,3475,'App\\Models\\Receipt',3475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',60996.00,NULL,NULL,1,'2021-11-09 14:25:44','2021-11-09 14:25:44',NULL),(3661,3117,40736,1546,3,3476,'App\\Models\\Receipt',3476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',37901.50,NULL,NULL,1,'2021-11-09 14:25:44','2021-11-09 14:25:44',NULL),(3662,3117,40736,1546,3,3477,'App\\Models\\Receipt',3477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',2600.00,NULL,NULL,1,'2021-11-09 14:25:44','2021-11-09 14:25:44',NULL),(3663,3117,40736,1546,3,3478,'App\\Models\\Receipt',3478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',445.95,NULL,NULL,1,'2021-11-09 14:25:44','2021-11-09 14:25:44',NULL),(3664,3117,40731,3056,2,3479,'App\\Models\\Receipt',3479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',9397.00,NULL,NULL,1,'2021-11-09 15:10:20','2021-11-09 15:10:20',NULL),(3665,3117,40731,3056,2,3480,'App\\Models\\Receipt',3480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',9513.00,NULL,NULL,1,'2021-11-09 15:10:20','2021-11-09 15:10:20',NULL),(3666,3117,40731,3056,2,3481,'App\\Models\\Receipt',3481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',7454.00,NULL,NULL,1,'2021-11-09 15:10:20','2021-11-09 15:10:20',NULL),(3667,3117,40731,3056,2,3482,'App\\Models\\Receipt',3482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',8662.00,NULL,NULL,1,'2021-11-09 15:10:20','2021-11-09 15:10:20',NULL),(3668,3117,40731,3056,2,3483,'App\\Models\\Receipt',3483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',6021.00,NULL,NULL,1,'2021-11-09 15:10:20','2021-11-09 15:10:20',NULL),(3669,3117,40731,3056,2,3484,'App\\Models\\Receipt',3484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',12063.00,NULL,NULL,1,'2021-11-09 15:10:20','2021-11-09 15:10:20',NULL),(3670,3117,40731,3056,2,3485,'App\\Models\\Receipt',3485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',12958.00,NULL,NULL,1,'2021-11-09 15:10:20','2021-11-09 15:10:20',NULL),(3671,3117,40731,3056,2,3486,'App\\Models\\Receipt',3486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',7063.00,NULL,NULL,1,'2021-11-09 15:10:21','2021-11-09 15:10:21',NULL),(3672,3117,40731,3056,2,3487,'App\\Models\\Receipt',3487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',10929.00,NULL,NULL,1,'2021-11-09 15:10:21','2021-11-09 15:10:21',NULL),(3673,3117,40731,3056,2,3488,'App\\Models\\Receipt',3488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',3187.00,NULL,NULL,1,'2021-11-09 15:10:21','2021-11-09 15:10:21',NULL),(3674,3117,40731,3056,2,3489,'App\\Models\\Receipt',3489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',10448.00,NULL,NULL,1,'2021-11-09 15:10:21','2021-11-09 15:10:21',NULL),(3675,3117,40731,3056,2,3490,'App\\Models\\Receipt',3490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',3662.00,NULL,NULL,1,'2021-11-09 15:10:21','2021-11-09 15:10:21',NULL);
INSERT INTO `balance_libro` VALUES (3676,3117,40731,3056,2,3491,'App\\Models\\Receipt',3491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',12022.00,NULL,NULL,1,'2021-11-09 15:10:21','2021-11-09 15:10:21',NULL),(3677,3117,40731,3056,2,3492,'App\\Models\\Receipt',3492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',13100.00,NULL,NULL,1,'2021-11-09 15:10:21','2021-11-09 15:10:21',NULL),(3678,3117,40731,3056,2,3493,'App\\Models\\Receipt',3493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',12854.00,NULL,NULL,1,'2021-11-09 15:10:21','2021-11-09 15:10:21',NULL),(3679,3117,40731,3056,2,3494,'App\\Models\\Receipt',3494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',11120.00,NULL,NULL,1,'2021-11-09 15:10:21','2021-11-09 15:10:21',NULL),(3680,3117,40731,3056,2,3495,'App\\Models\\Receipt',3495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',9612.00,NULL,NULL,1,'2021-11-09 15:10:21','2021-11-09 15:10:21',NULL),(3681,3117,40731,3056,2,3496,'App\\Models\\Receipt',3496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',11013.00,NULL,NULL,1,'2021-11-09 15:10:21','2021-11-09 15:10:21',NULL),(3682,3117,40731,3056,2,3497,'App\\Models\\Receipt',3497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',10002.00,NULL,NULL,1,'2021-11-09 15:10:21','2021-11-09 15:10:21',NULL),(3683,3117,40731,3056,2,3498,'App\\Models\\Receipt',3498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',12933.00,NULL,NULL,1,'2021-11-09 15:10:21','2021-11-09 15:10:21',NULL),(3684,3117,40731,3056,2,3499,'App\\Models\\Receipt',3499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',8348.00,NULL,NULL,1,'2021-11-09 15:10:21','2021-11-09 15:10:21',NULL),(3685,3117,40731,3056,2,3500,'App\\Models\\Receipt',3500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',8216.00,NULL,NULL,1,'2021-11-09 15:10:21','2021-11-09 15:10:21',NULL),(3686,3117,40731,3056,2,3501,'App\\Models\\Receipt',3501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',8216.00,NULL,NULL,1,'2021-11-09 15:10:21','2021-11-09 15:10:21',NULL),(3687,3117,40731,3056,2,3502,'App\\Models\\Receipt',3502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',8257.00,NULL,NULL,1,'2021-11-09 15:10:21','2021-11-09 15:10:21',NULL),(3688,3117,40731,3056,2,3503,'App\\Models\\Receipt',3503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-30','2021-10-30',5669.00,NULL,NULL,1,'2021-11-09 15:10:21','2021-11-09 15:10:21',NULL),(3689,3117,40731,3056,3,3504,'App\\Models\\Receipt',3504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',5865.09,NULL,NULL,1,'2021-11-09 15:10:38','2021-11-09 15:10:38',NULL),(3690,3117,40731,3056,3,3505,'App\\Models\\Receipt',3505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',16000.00,NULL,NULL,1,'2021-11-09 15:10:38','2021-11-09 15:10:38',NULL),(3691,3117,40731,3056,3,3506,'App\\Models\\Receipt',3506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',800.00,NULL,NULL,1,'2021-11-09 15:10:38','2021-11-09 15:10:38',NULL),(3692,3117,40731,3056,3,3507,'App\\Models\\Receipt',3507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',7806.44,NULL,NULL,1,'2021-11-09 15:10:38','2021-11-09 15:10:38',NULL),(3693,3117,40731,3056,3,3508,'App\\Models\\Receipt',3508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',2518.84,NULL,NULL,1,'2021-11-09 15:10:38','2021-11-09 15:10:38',NULL),(3694,3117,40731,3056,3,3509,'App\\Models\\Receipt',3509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',9615.35,NULL,NULL,1,'2021-11-09 15:10:38','2021-11-09 15:10:38',NULL),(3695,3117,40731,3056,3,3510,'App\\Models\\Receipt',3510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',0.01,NULL,NULL,1,'2021-11-09 15:10:38','2021-11-09 15:10:38',NULL),(3696,3117,40731,3056,3,3511,'App\\Models\\Receipt',3511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',12021.21,NULL,NULL,1,'2021-11-09 15:10:38','2021-11-09 15:10:38',NULL);
INSERT INTO `balance_libro` VALUES (3697,3117,40731,3056,3,3512,'App\\Models\\Receipt',3512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',6499.85,NULL,NULL,1,'2021-11-09 15:10:38','2021-11-09 15:10:38',NULL),(3698,3117,40731,3056,3,3513,'App\\Models\\Receipt',3513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',5152.52,NULL,NULL,1,'2021-11-09 15:10:38','2021-11-09 15:10:38',NULL),(3699,3117,40731,3056,3,3514,'App\\Models\\Receipt',3514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',6325.09,NULL,NULL,1,'2021-11-09 15:10:38','2021-11-09 15:10:38',NULL),(3700,3117,40731,3056,3,3515,'App\\Models\\Receipt',3515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',12907.76,NULL,NULL,1,'2021-11-09 15:10:38','2021-11-09 15:10:38',NULL),(3701,3117,40731,3056,3,3516,'App\\Models\\Receipt',3516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',300.90,NULL,NULL,1,'2021-11-09 15:10:38','2021-11-09 15:10:38',NULL),(3702,3117,40731,3056,3,3517,'App\\Models\\Receipt',3517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-16','2021-10-16',5942.79,NULL,NULL,1,'2021-11-09 15:10:38','2021-11-09 15:10:38',NULL),(3703,3117,40731,3056,3,3518,'App\\Models\\Receipt',3518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-17','2021-10-17',5428.82,NULL,NULL,1,'2021-11-09 15:10:38','2021-11-09 15:10:38',NULL),(3704,3117,40731,3056,3,3519,'App\\Models\\Receipt',3519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',50.15,NULL,NULL,1,'2021-11-09 15:10:38','2021-11-09 15:10:38',NULL),(3705,3117,40731,3056,3,3520,'App\\Models\\Receipt',3520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',11330.77,NULL,NULL,1,'2021-11-09 15:10:39','2021-11-09 15:10:39',NULL),(3706,3117,40731,3056,3,3521,'App\\Models\\Receipt',3521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',300.90,NULL,NULL,1,'2021-11-09 15:10:39','2021-11-09 15:10:39',NULL),(3707,3117,40731,3056,3,3522,'App\\Models\\Receipt',3522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',70.57,NULL,NULL,1,'2021-11-09 15:10:39','2021-11-09 15:10:39',NULL),(3708,3117,40731,3056,3,3523,'App\\Models\\Receipt',3523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',8904.17,NULL,NULL,1,'2021-11-09 15:10:39','2021-11-09 15:10:39',NULL),(3709,3117,40731,3056,3,3524,'App\\Models\\Receipt',3524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23','2021-10-23',5292.25,NULL,NULL,1,'2021-11-09 15:10:39','2021-11-09 15:10:39',NULL),(3710,3117,40731,3056,3,3525,'App\\Models\\Receipt',3525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23','2021-10-23',10602.92,NULL,NULL,1,'2021-11-09 15:10:39','2021-11-09 15:10:39',NULL),(3711,3117,40731,3056,3,3526,'App\\Models\\Receipt',3526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',2326.09,NULL,NULL,1,'2021-11-09 15:10:39','2021-11-09 15:10:39',NULL),(3712,3117,40731,3056,3,3527,'App\\Models\\Receipt',3527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',1934.91,NULL,NULL,1,'2021-11-09 15:10:39','2021-11-09 15:10:39',NULL),(3713,3117,40731,3056,3,3528,'App\\Models\\Receipt',3528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',11017.43,NULL,NULL,1,'2021-11-09 15:10:39','2021-11-09 15:10:39',NULL),(3714,3117,40731,3056,3,3529,'App\\Models\\Receipt',3529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-30','2021-10-30',3077.65,NULL,NULL,1,'2021-11-09 15:10:39','2021-11-09 15:10:39',NULL),(3715,3117,40731,3056,3,3530,'App\\Models\\Receipt',3530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',5862.73,NULL,NULL,1,'2021-11-09 15:10:39','2021-11-09 15:10:39',NULL),(3716,3117,40731,3056,3,3531,'App\\Models\\Receipt',3531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',1619.56,NULL,NULL,1,'2021-11-09 15:10:39','2021-11-09 15:10:39',NULL),(3717,3117,40779,4575,2,3532,'App\\Models\\Receipt',3532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',6150.00,NULL,NULL,1,'2021-11-10 15:00:57','2021-11-10 15:00:57',NULL);
INSERT INTO `balance_libro` VALUES (3718,3117,40779,4575,2,3533,'App\\Models\\Receipt',3533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',4930.00,NULL,NULL,1,'2021-11-10 15:00:57','2021-11-10 15:00:57',NULL),(3719,3117,40779,4575,2,3534,'App\\Models\\Receipt',3534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',4820.00,NULL,NULL,1,'2021-11-10 15:00:57','2021-11-10 15:00:57',NULL),(3720,3117,40779,4575,2,3535,'App\\Models\\Receipt',3535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',4550.00,NULL,NULL,1,'2021-11-10 15:00:57','2021-11-10 15:00:57',NULL),(3721,3117,40779,4575,2,3536,'App\\Models\\Receipt',3536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',4680.00,NULL,NULL,1,'2021-11-10 15:00:57','2021-11-10 15:00:57',NULL),(3722,3117,40779,4575,2,3537,'App\\Models\\Receipt',3537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',4410.00,NULL,NULL,1,'2021-11-10 15:00:57','2021-11-10 15:00:57',NULL),(3723,3117,40779,4575,2,3538,'App\\Models\\Receipt',3538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',4710.00,NULL,NULL,1,'2021-11-10 15:00:57','2021-11-10 15:00:57',NULL),(3724,3117,40779,4575,2,3539,'App\\Models\\Receipt',3539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',4790.00,NULL,NULL,1,'2021-11-10 15:00:57','2021-11-10 15:00:57',NULL),(3725,3117,40779,4575,2,3540,'App\\Models\\Receipt',3540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',4680.00,NULL,NULL,1,'2021-11-10 15:00:57','2021-11-10 15:00:57',NULL),(3726,3117,40779,4575,2,3541,'App\\Models\\Receipt',3541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',4710.00,NULL,NULL,1,'2021-11-10 15:00:58','2021-11-10 15:00:58',NULL),(3727,3117,40779,4575,2,3542,'App\\Models\\Receipt',3542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-10','2021-10-10',4830.00,NULL,NULL,1,'2021-11-10 15:00:58','2021-11-10 15:00:58',NULL),(3728,3117,40779,4575,2,3543,'App\\Models\\Receipt',3543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-10','2021-10-10',4800.00,NULL,NULL,1,'2021-11-10 15:00:58','2021-11-10 15:00:58',NULL),(3729,3117,40779,4575,2,3544,'App\\Models\\Receipt',3544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-10','2021-10-10',4005.00,NULL,NULL,1,'2021-11-10 15:00:58','2021-11-10 15:00:58',NULL),(3730,3117,40779,4575,2,3545,'App\\Models\\Receipt',3545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-10','2021-10-10',4220.00,NULL,NULL,1,'2021-11-10 15:00:58','2021-11-10 15:00:58',NULL),(3731,3117,40779,4575,2,3546,'App\\Models\\Receipt',3546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-10','2021-10-10',4170.00,NULL,NULL,1,'2021-11-10 15:00:58','2021-11-10 15:00:58',NULL),(3732,3117,40779,4575,2,3547,'App\\Models\\Receipt',3547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-10','2021-10-10',4760.00,NULL,NULL,1,'2021-11-10 15:00:58','2021-11-10 15:00:58',NULL),(3733,3117,40779,4575,2,3548,'App\\Models\\Receipt',3548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',4100.00,NULL,NULL,1,'2021-11-10 15:00:58','2021-11-10 15:00:58',NULL),(3734,3117,40779,4575,2,3549,'App\\Models\\Receipt',3549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',4370.00,NULL,NULL,1,'2021-11-10 15:00:58','2021-11-10 15:00:58',NULL),(3735,3117,40779,4575,2,3550,'App\\Models\\Receipt',3550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',4550.00,NULL,NULL,1,'2021-11-10 15:00:58','2021-11-10 15:00:58',NULL),(3736,3117,40779,4575,2,3551,'App\\Models\\Receipt',3551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',4050.00,NULL,NULL,1,'2021-11-10 15:00:58','2021-11-10 15:00:58',NULL),(3737,3117,40779,4575,2,3552,'App\\Models\\Receipt',3552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',4390.00,NULL,NULL,1,'2021-11-10 15:00:58','2021-11-10 15:00:58',NULL),(3738,3117,40779,4575,2,3553,'App\\Models\\Receipt',3553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',4650.00,NULL,NULL,1,'2021-11-10 15:00:58','2021-11-10 15:00:58',NULL);
INSERT INTO `balance_libro` VALUES (3739,3117,40779,4575,2,3554,'App\\Models\\Receipt',3554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',4400.00,NULL,NULL,1,'2021-11-10 15:00:58','2021-11-10 15:00:58',NULL),(3740,3117,40779,4575,2,3555,'App\\Models\\Receipt',3555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',4300.00,NULL,NULL,1,'2021-11-10 15:00:58','2021-11-10 15:00:58',NULL),(3741,3117,40779,4575,2,3556,'App\\Models\\Receipt',3556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',4560.00,NULL,NULL,1,'2021-11-10 15:00:58','2021-11-10 15:00:58',NULL),(3742,3117,40779,4575,2,3557,'App\\Models\\Receipt',3557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',2580.00,NULL,NULL,1,'2021-11-10 15:00:58','2021-11-10 15:00:58',NULL),(3743,3117,40779,4575,2,3558,'App\\Models\\Receipt',3558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',1490.00,NULL,NULL,1,'2021-11-10 15:00:58','2021-11-10 15:00:58',NULL),(3744,3117,40779,4575,2,3559,'App\\Models\\Receipt',3559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',1490.00,NULL,NULL,1,'2021-11-10 15:00:58','2021-11-10 15:00:58',NULL),(3745,3117,40779,4575,2,3560,'App\\Models\\Receipt',3560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',4550.00,NULL,NULL,1,'2021-11-10 15:00:58','2021-11-10 15:00:58',NULL),(3746,3117,40779,4575,2,3561,'App\\Models\\Receipt',3561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',4990.00,NULL,NULL,1,'2021-11-10 15:00:58','2021-11-10 15:00:58',NULL),(3747,3117,40779,4575,2,3562,'App\\Models\\Receipt',3562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',4870.00,NULL,NULL,1,'2021-11-10 15:00:58','2021-11-10 15:00:58',NULL),(3748,3117,40779,4575,2,3563,'App\\Models\\Receipt',3563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',4710.00,NULL,NULL,1,'2021-11-10 15:00:58','2021-11-10 15:00:58',NULL),(3749,3117,40779,4575,2,3564,'App\\Models\\Receipt',3564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',4730.00,NULL,NULL,1,'2021-11-10 15:00:58','2021-11-10 15:00:58',NULL),(3750,3117,40779,4575,2,3565,'App\\Models\\Receipt',3565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',4120.00,NULL,NULL,1,'2021-11-10 15:00:58','2021-11-10 15:00:58',NULL),(3751,3117,40779,4575,2,3566,'App\\Models\\Receipt',3566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-16','2021-10-16',4220.00,NULL,NULL,1,'2021-11-10 15:00:58','2021-11-10 15:00:58',NULL),(3752,3117,40779,4575,2,3567,'App\\Models\\Receipt',3567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-16','2021-10-16',4440.00,NULL,NULL,1,'2021-11-10 15:00:58','2021-11-10 15:00:58',NULL),(3753,3117,40779,4575,2,3568,'App\\Models\\Receipt',3568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-16','2021-10-16',4830.00,NULL,NULL,1,'2021-11-10 15:00:58','2021-11-10 15:00:58',NULL),(3754,3117,40779,4575,2,3569,'App\\Models\\Receipt',3569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-17','2021-10-17',1490.00,NULL,NULL,1,'2021-11-10 15:00:58','2021-11-10 15:00:58',NULL),(3755,3117,40779,4575,2,3570,'App\\Models\\Receipt',3570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-17','2021-10-17',1490.00,NULL,NULL,1,'2021-11-10 15:00:59','2021-11-10 15:00:59',NULL),(3756,3117,40779,4575,2,3571,'App\\Models\\Receipt',3571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-17','2021-10-17',4220.00,NULL,NULL,1,'2021-11-10 15:00:59','2021-11-10 15:00:59',NULL),(3757,3117,40779,4575,2,3572,'App\\Models\\Receipt',3572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-17','2021-10-17',4690.00,NULL,NULL,1,'2021-11-10 15:00:59','2021-11-10 15:00:59',NULL),(3758,3117,40779,4575,2,3573,'App\\Models\\Receipt',3573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-17','2021-10-17',4720.00,NULL,NULL,1,'2021-11-10 15:00:59','2021-11-10 15:00:59',NULL),(3759,3117,40779,4575,2,3574,'App\\Models\\Receipt',3574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-17','2021-10-17',3270.00,NULL,NULL,1,'2021-11-10 15:00:59','2021-11-10 15:00:59',NULL);
INSERT INTO `balance_libro` VALUES (3760,3117,40779,4575,2,3575,'App\\Models\\Receipt',3575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',1490.00,NULL,NULL,1,'2021-11-10 15:00:59','2021-11-10 15:00:59',NULL),(3761,3117,40779,4575,2,3576,'App\\Models\\Receipt',3576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',1490.00,NULL,NULL,1,'2021-11-10 15:00:59','2021-11-10 15:00:59',NULL),(3762,3117,40779,4575,2,3577,'App\\Models\\Receipt',3577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',4930.00,NULL,NULL,1,'2021-11-10 15:00:59','2021-11-10 15:00:59',NULL),(3763,3117,40779,4575,2,3578,'App\\Models\\Receipt',3578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',4870.00,NULL,NULL,1,'2021-11-10 15:00:59','2021-11-10 15:00:59',NULL),(3764,3117,40779,4575,2,3579,'App\\Models\\Receipt',3579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',4550.00,NULL,NULL,1,'2021-11-10 15:00:59','2021-11-10 15:00:59',NULL),(3765,3117,40779,4575,2,3580,'App\\Models\\Receipt',3580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',4440.00,NULL,NULL,1,'2021-11-10 15:00:59','2021-11-10 15:00:59',NULL),(3766,3117,40779,4575,2,3581,'App\\Models\\Receipt',3581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',4750.00,NULL,NULL,1,'2021-11-10 15:00:59','2021-11-10 15:00:59',NULL),(3767,3117,40779,4575,2,3582,'App\\Models\\Receipt',3582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',4200.00,NULL,NULL,1,'2021-11-10 15:00:59','2021-11-10 15:00:59',NULL),(3768,3117,40779,4575,2,3583,'App\\Models\\Receipt',3583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',4320.00,NULL,NULL,1,'2021-11-10 15:00:59','2021-11-10 15:00:59',NULL),(3769,3117,40779,4575,2,3584,'App\\Models\\Receipt',3584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',4550.00,NULL,NULL,1,'2021-11-10 15:00:59','2021-11-10 15:00:59',NULL),(3770,3117,40779,4575,2,3585,'App\\Models\\Receipt',3585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',4680.00,NULL,NULL,1,'2021-11-10 15:00:59','2021-11-10 15:00:59',NULL),(3771,3117,40779,4575,2,3586,'App\\Models\\Receipt',3586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',4470.00,NULL,NULL,1,'2021-11-10 15:00:59','2021-11-10 15:00:59',NULL),(3772,3117,40779,4575,2,3587,'App\\Models\\Receipt',3587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23','2021-10-23',4960.00,NULL,NULL,1,'2021-11-10 15:00:59','2021-11-10 15:00:59',NULL),(3773,3117,40779,4575,2,3588,'App\\Models\\Receipt',3588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23','2021-10-23',4780.00,NULL,NULL,1,'2021-11-10 15:00:59','2021-11-10 15:00:59',NULL),(3774,3117,40779,4575,2,3589,'App\\Models\\Receipt',3589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23','2021-10-23',4995.00,NULL,NULL,1,'2021-11-10 15:00:59','2021-11-10 15:00:59',NULL),(3775,3117,40779,4575,2,3590,'App\\Models\\Receipt',3590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23','2021-10-23',4670.00,NULL,NULL,1,'2021-11-10 15:00:59','2021-11-10 15:00:59',NULL),(3776,3117,40779,4575,2,3591,'App\\Models\\Receipt',3591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23','2021-10-23',4560.00,NULL,NULL,1,'2021-11-10 15:00:59','2021-11-10 15:00:59',NULL),(3777,3117,40779,4575,2,3592,'App\\Models\\Receipt',3592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23','2021-10-23',4120.00,NULL,NULL,1,'2021-11-10 15:00:59','2021-11-10 15:00:59',NULL),(3778,3117,40779,4575,2,3593,'App\\Models\\Receipt',3593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23','2021-10-23',4610.00,NULL,NULL,1,'2021-11-10 15:00:59','2021-11-10 15:00:59',NULL),(3779,3117,40779,4575,2,3594,'App\\Models\\Receipt',3594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23','2021-10-23',4180.00,NULL,NULL,1,'2021-11-10 15:00:59','2021-11-10 15:00:59',NULL),(3780,3117,40779,4575,2,3595,'App\\Models\\Receipt',3595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23','2021-10-23',4680.00,NULL,NULL,1,'2021-11-10 15:00:59','2021-11-10 15:00:59',NULL);
INSERT INTO `balance_libro` VALUES (3781,3117,40779,4575,2,3596,'App\\Models\\Receipt',3596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',4470.00,NULL,NULL,1,'2021-11-10 15:00:59','2021-11-10 15:00:59',NULL),(3782,3117,40779,4575,2,3597,'App\\Models\\Receipt',3597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',2690.00,NULL,NULL,1,'2021-11-10 15:00:59','2021-11-10 15:00:59',NULL),(3783,3117,40779,4575,2,3598,'App\\Models\\Receipt',3598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',2690.00,NULL,NULL,1,'2021-11-10 15:00:59','2021-11-10 15:00:59',NULL),(3784,3117,40779,4575,2,3599,'App\\Models\\Receipt',3599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',4990.00,NULL,NULL,1,'2021-11-10 15:00:59','2021-11-10 15:00:59',NULL),(3785,3117,40779,4575,2,3600,'App\\Models\\Receipt',3600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',4820.00,NULL,NULL,1,'2021-11-10 15:00:59','2021-11-10 15:00:59',NULL),(3786,3117,40779,4575,2,3601,'App\\Models\\Receipt',3601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',4710.00,NULL,NULL,1,'2021-11-10 15:01:00','2021-11-10 15:01:00',NULL),(3787,3117,40779,4575,2,3602,'App\\Models\\Receipt',3602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',4510.00,NULL,NULL,1,'2021-11-10 15:01:00','2021-11-10 15:01:00',NULL),(3788,3117,40779,4575,2,3603,'App\\Models\\Receipt',3603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',4380.00,NULL,NULL,1,'2021-11-10 15:01:00','2021-11-10 15:01:00',NULL),(3789,3117,40779,4575,2,3604,'App\\Models\\Receipt',3604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',4930.00,NULL,NULL,1,'2021-11-10 15:01:00','2021-11-10 15:01:00',NULL),(3790,3117,40779,4575,2,3605,'App\\Models\\Receipt',3605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',4270.00,NULL,NULL,1,'2021-11-10 15:01:00','2021-11-10 15:01:00',NULL),(3791,3117,40779,4575,2,3606,'App\\Models\\Receipt',3606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',4100.00,NULL,NULL,1,'2021-11-10 15:01:00','2021-11-10 15:01:00',NULL),(3792,3117,40779,4575,2,3607,'App\\Models\\Receipt',3607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',4370.00,NULL,NULL,1,'2021-11-10 15:01:00','2021-11-10 15:01:00',NULL),(3793,3117,40779,4575,2,3608,'App\\Models\\Receipt',3608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',4200.00,NULL,NULL,1,'2021-11-10 15:01:00','2021-11-10 15:01:00',NULL),(3794,3117,40779,4575,2,3609,'App\\Models\\Receipt',3609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',4786.00,NULL,NULL,1,'2021-11-10 15:01:00','2021-11-10 15:01:00',NULL),(3795,3117,40779,4575,2,3610,'App\\Models\\Receipt',3610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',4787.00,NULL,NULL,1,'2021-11-10 15:01:00','2021-11-10 15:01:00',NULL),(3796,3117,40779,4575,3,3611,'App\\Models\\Receipt',3611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',17525.53,NULL,NULL,1,'2021-11-10 15:01:19','2021-11-10 15:01:19',NULL),(3797,3117,40779,4575,3,3612,'App\\Models\\Receipt',3612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',2534.63,NULL,NULL,1,'2021-11-10 15:01:19','2021-11-10 15:01:19',NULL),(3798,3117,40779,4575,3,3613,'App\\Models\\Receipt',3613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',9454.89,NULL,NULL,1,'2021-11-10 15:01:19','2021-11-10 15:01:19',NULL),(3799,3117,40779,4575,3,3614,'App\\Models\\Receipt',3614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-02','2021-10-02',37600.00,NULL,NULL,1,'2021-11-10 15:01:19','2021-11-10 15:01:19',NULL),(3800,3117,40779,4575,3,3615,'App\\Models\\Receipt',3615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',6362.29,NULL,NULL,1,'2021-11-10 15:01:19','2021-11-10 15:01:19',NULL),(3801,3117,40779,4575,3,3616,'App\\Models\\Receipt',3616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',48930.10,NULL,NULL,1,'2021-11-10 15:01:19','2021-11-10 15:01:19',NULL);
INSERT INTO `balance_libro` VALUES (3802,3117,40779,4575,3,3617,'App\\Models\\Receipt',3617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',6599.36,NULL,NULL,1,'2021-11-10 15:01:19','2021-11-10 15:01:19',NULL),(3803,3117,40779,4575,3,3618,'App\\Models\\Receipt',3618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',61324.25,NULL,NULL,1,'2021-11-10 15:01:19','2021-11-10 15:01:19',NULL),(3804,3117,40779,4575,3,3619,'App\\Models\\Receipt',3619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',2507.60,NULL,NULL,1,'2021-11-10 15:01:19','2021-11-10 15:01:19',NULL),(3805,3117,40779,4575,3,3620,'App\\Models\\Receipt',3620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',2835.58,NULL,NULL,1,'2021-11-10 15:01:19','2021-11-10 15:01:19',NULL),(3806,3117,40779,4575,3,3621,'App\\Models\\Receipt',3621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',26166.36,NULL,NULL,1,'2021-11-10 15:01:19','2021-11-10 15:01:19',NULL),(3807,3117,40779,4575,3,3622,'App\\Models\\Receipt',3622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',61719.29,NULL,NULL,1,'2021-11-10 15:01:19','2021-11-10 15:01:19',NULL),(3808,3117,40779,4575,3,3623,'App\\Models\\Receipt',3623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',5173.65,NULL,NULL,1,'2021-11-10 15:01:19','2021-11-10 15:01:19',NULL),(3809,3117,40779,4575,3,3624,'App\\Models\\Receipt',3624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',15000.00,NULL,NULL,1,'2021-11-10 15:01:19','2021-11-10 15:01:19',NULL),(3810,3117,40846,12449,2,3625,'App\\Models\\Receipt',3625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-03','2021-10-03',220.00,NULL,NULL,1,'2021-11-16 17:00:58','2021-11-16 17:00:58',NULL),(3811,3117,40846,12449,2,3626,'App\\Models\\Receipt',3626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-03','2021-10-03',685.00,NULL,NULL,1,'2021-11-16 17:00:58','2021-11-16 17:00:58',NULL),(3812,3117,40846,12449,2,3627,'App\\Models\\Receipt',3627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-03','2021-10-03',635.00,NULL,NULL,1,'2021-11-16 17:00:58','2021-11-16 17:00:58',NULL),(3813,3117,40846,12449,2,3628,'App\\Models\\Receipt',3628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-03','2021-10-03',215.00,NULL,NULL,1,'2021-11-16 17:00:58','2021-11-16 17:00:58',NULL),(3814,3117,40846,12449,2,3629,'App\\Models\\Receipt',3629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-03','2021-10-03',1012.00,NULL,NULL,1,'2021-11-16 17:00:58','2021-11-16 17:00:58',NULL),(3815,3117,40846,12449,2,3630,'App\\Models\\Receipt',3630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-03','2021-10-03',3760.00,NULL,NULL,1,'2021-11-16 17:00:58','2021-11-16 17:00:58',NULL),(3816,3117,40846,12449,2,3631,'App\\Models\\Receipt',3631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-03','2021-10-03',905.00,NULL,NULL,1,'2021-11-16 17:00:58','2021-11-16 17:00:58',NULL),(3817,3117,40846,12449,2,3632,'App\\Models\\Receipt',3632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-03','2021-10-03',190.00,NULL,NULL,1,'2021-11-16 17:00:58','2021-11-16 17:00:58',NULL),(3818,3117,40846,12449,2,3633,'App\\Models\\Receipt',3633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',920.00,NULL,NULL,1,'2021-11-16 17:00:58','2021-11-16 17:00:58',NULL),(3819,3117,40846,12449,2,3634,'App\\Models\\Receipt',3634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',858.00,NULL,NULL,1,'2021-11-16 17:00:58','2021-11-16 17:00:58',NULL),(3820,3117,40846,12449,2,3635,'App\\Models\\Receipt',3635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',760.00,NULL,NULL,1,'2021-11-16 17:00:58','2021-11-16 17:00:58',NULL),(3821,3117,40846,12449,2,3636,'App\\Models\\Receipt',3636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',500.00,NULL,NULL,1,'2021-11-16 17:00:58','2021-11-16 17:00:58',NULL),(3822,3117,40846,12449,2,3637,'App\\Models\\Receipt',3637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',405.00,NULL,NULL,1,'2021-11-16 17:00:58','2021-11-16 17:00:58',NULL);
INSERT INTO `balance_libro` VALUES (3823,3117,40846,12449,2,3638,'App\\Models\\Receipt',3638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',100.00,NULL,NULL,1,'2021-11-16 17:00:58','2021-11-16 17:00:58',NULL),(3824,3117,40846,12449,2,3639,'App\\Models\\Receipt',3639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',1085.00,NULL,NULL,1,'2021-11-16 17:00:58','2021-11-16 17:00:58',NULL),(3825,3117,40846,12449,2,3640,'App\\Models\\Receipt',3640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',220.00,NULL,NULL,1,'2021-11-16 17:00:58','2021-11-16 17:00:58',NULL),(3826,3117,40846,12449,2,3641,'App\\Models\\Receipt',3641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',3500.00,NULL,NULL,1,'2021-11-16 17:00:58','2021-11-16 17:00:58',NULL),(3827,3117,40846,12449,2,3642,'App\\Models\\Receipt',3642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',649.00,NULL,NULL,1,'2021-11-16 17:00:58','2021-11-16 17:00:58',NULL),(3828,3117,40846,12449,2,3643,'App\\Models\\Receipt',3643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',960.00,NULL,NULL,1,'2021-11-16 17:00:58','2021-11-16 17:00:58',NULL),(3829,3117,40846,12449,2,3644,'App\\Models\\Receipt',3644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',1270.00,NULL,NULL,1,'2021-11-16 17:00:58','2021-11-16 17:00:58',NULL),(3830,3117,40846,12449,2,3645,'App\\Models\\Receipt',3645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',1246.00,NULL,NULL,1,'2021-11-16 17:00:58','2021-11-16 17:00:58',NULL),(3831,3117,40846,12449,2,3646,'App\\Models\\Receipt',3646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',1235.00,NULL,NULL,1,'2021-11-16 17:00:58','2021-11-16 17:00:58',NULL),(3832,3117,40846,12449,2,3647,'App\\Models\\Receipt',3647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',475.00,NULL,NULL,1,'2021-11-16 17:00:58','2021-11-16 17:00:58',NULL),(3833,3117,40846,12449,2,3648,'App\\Models\\Receipt',3648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',1820.00,NULL,NULL,1,'2021-11-16 17:00:58','2021-11-16 17:00:58',NULL),(3834,3117,40846,12449,2,3649,'App\\Models\\Receipt',3649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',800.00,NULL,NULL,1,'2021-11-16 17:00:58','2021-11-16 17:00:58',NULL),(3835,3117,40846,12449,2,3650,'App\\Models\\Receipt',3650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',280.00,NULL,NULL,1,'2021-11-16 17:00:58','2021-11-16 17:00:58',NULL),(3836,3117,40846,12449,2,3651,'App\\Models\\Receipt',3651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',1473.00,NULL,NULL,1,'2021-11-16 17:00:58','2021-11-16 17:00:58',NULL),(3837,3117,40846,12449,2,3652,'App\\Models\\Receipt',3652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',255.00,NULL,NULL,1,'2021-11-16 17:00:59','2021-11-16 17:00:59',NULL),(3838,3117,40846,12449,2,3653,'App\\Models\\Receipt',3653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',460.00,NULL,NULL,1,'2021-11-16 17:00:59','2021-11-16 17:00:59',NULL),(3839,3117,40846,12449,2,3654,'App\\Models\\Receipt',3654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',1160.00,NULL,NULL,1,'2021-11-16 17:00:59','2021-11-16 17:00:59',NULL),(3840,3117,40846,12449,2,3655,'App\\Models\\Receipt',3655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',635.00,NULL,NULL,1,'2021-11-16 17:00:59','2021-11-16 17:00:59',NULL),(3841,3117,40846,12449,2,3656,'App\\Models\\Receipt',3656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',345.00,NULL,NULL,1,'2021-11-16 17:00:59','2021-11-16 17:00:59',NULL),(3842,3117,40846,12449,2,3657,'App\\Models\\Receipt',3657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',955.00,NULL,NULL,1,'2021-11-16 17:00:59','2021-11-16 17:00:59',NULL),(3843,3117,40846,12449,2,3658,'App\\Models\\Receipt',3658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',540.00,NULL,NULL,1,'2021-11-16 17:00:59','2021-11-16 17:00:59',NULL);
INSERT INTO `balance_libro` VALUES (3844,3117,40846,12449,2,3659,'App\\Models\\Receipt',3659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',475.00,NULL,NULL,1,'2021-11-16 17:00:59','2021-11-16 17:00:59',NULL),(3845,3117,40846,12449,2,3660,'App\\Models\\Receipt',3660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',451.00,NULL,NULL,1,'2021-11-16 17:00:59','2021-11-16 17:00:59',NULL),(3846,3117,40846,12449,2,3661,'App\\Models\\Receipt',3661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',1319.00,NULL,NULL,1,'2021-11-16 17:00:59','2021-11-16 17:00:59',NULL),(3847,3117,40846,12449,2,3662,'App\\Models\\Receipt',3662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',1395.00,NULL,NULL,1,'2021-11-16 17:00:59','2021-11-16 17:00:59',NULL),(3848,3117,40846,12449,2,3663,'App\\Models\\Receipt',3663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',298.25,NULL,NULL,1,'2021-11-16 17:00:59','2021-11-16 17:00:59',NULL),(3849,3117,40846,12449,2,3664,'App\\Models\\Receipt',3664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',1954.75,NULL,NULL,1,'2021-11-16 17:00:59','2021-11-16 17:00:59',NULL),(3850,3117,40846,12449,2,3665,'App\\Models\\Receipt',3665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',4517.00,NULL,NULL,1,'2021-11-16 17:00:59','2021-11-16 17:00:59',NULL),(3851,3117,40846,12449,2,3666,'App\\Models\\Receipt',3666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',315.00,NULL,NULL,1,'2021-11-16 17:00:59','2021-11-16 17:00:59',NULL),(3852,3117,40846,12449,2,3667,'App\\Models\\Receipt',3667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',640.00,NULL,NULL,1,'2021-11-16 17:00:59','2021-11-16 17:00:59',NULL),(3853,3117,40846,12449,2,3668,'App\\Models\\Receipt',3668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',241.00,NULL,NULL,1,'2021-11-16 17:00:59','2021-11-16 17:00:59',NULL),(3854,3117,40846,12449,2,3669,'App\\Models\\Receipt',3669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',3690.00,NULL,NULL,1,'2021-11-16 17:00:59','2021-11-16 17:00:59',NULL),(3855,3117,40846,12449,2,3670,'App\\Models\\Receipt',3670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',756.25,NULL,NULL,1,'2021-11-16 17:00:59','2021-11-16 17:00:59',NULL),(3856,3117,40846,12449,2,3671,'App\\Models\\Receipt',3671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',260.00,NULL,NULL,1,'2021-11-16 17:00:59','2021-11-16 17:00:59',NULL),(3857,3117,40846,12449,2,3672,'App\\Models\\Receipt',3672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',2331.00,NULL,NULL,1,'2021-11-16 17:00:59','2021-11-16 17:00:59',NULL),(3858,3117,40846,12449,2,3673,'App\\Models\\Receipt',3673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',805.00,NULL,NULL,1,'2021-11-16 17:00:59','2021-11-16 17:00:59',NULL),(3859,3117,40846,12449,2,3674,'App\\Models\\Receipt',3674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',570.00,NULL,NULL,1,'2021-11-16 17:00:59','2021-11-16 17:00:59',NULL),(3860,3117,40846,12449,2,3675,'App\\Models\\Receipt',3675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',660.00,NULL,NULL,1,'2021-11-16 17:00:59','2021-11-16 17:00:59',NULL),(3861,3117,40846,12449,2,3676,'App\\Models\\Receipt',3676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',890.00,NULL,NULL,1,'2021-11-16 17:00:59','2021-11-16 17:00:59',NULL),(3862,3117,40846,12449,2,3677,'App\\Models\\Receipt',3677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',300.00,NULL,NULL,1,'2021-11-16 17:01:00','2021-11-16 17:01:00',NULL),(3863,3117,40846,12449,2,3678,'App\\Models\\Receipt',3678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',1338.25,NULL,NULL,1,'2021-11-16 17:01:00','2021-11-16 17:01:00',NULL),(3864,3117,40846,12449,2,3679,'App\\Models\\Receipt',3679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',1600.00,NULL,NULL,1,'2021-11-16 17:01:00','2021-11-16 17:01:00',NULL);
INSERT INTO `balance_libro` VALUES (3865,3117,40846,12449,2,3680,'App\\Models\\Receipt',3680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',616.00,NULL,NULL,1,'2021-11-16 17:01:00','2021-11-16 17:01:00',NULL),(3866,3117,40846,12449,2,3681,'App\\Models\\Receipt',3681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',964.00,NULL,NULL,1,'2021-11-16 17:01:00','2021-11-16 17:01:00',NULL),(3867,3117,40846,12449,2,3682,'App\\Models\\Receipt',3682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',2770.00,NULL,NULL,1,'2021-11-16 17:01:00','2021-11-16 17:01:00',NULL),(3868,3117,40846,12449,2,3683,'App\\Models\\Receipt',3683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',800.00,NULL,NULL,1,'2021-11-16 17:01:00','2021-11-16 17:01:00',NULL),(3869,3117,40846,12449,2,3684,'App\\Models\\Receipt',3684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',1400.00,NULL,NULL,1,'2021-11-16 17:01:00','2021-11-16 17:01:00',NULL),(3870,3117,40846,12449,2,3685,'App\\Models\\Receipt',3685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',270.00,NULL,NULL,1,'2021-11-16 17:01:00','2021-11-16 17:01:00',NULL),(3871,3117,40846,12449,2,3686,'App\\Models\\Receipt',3686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',3530.00,NULL,NULL,1,'2021-11-16 17:01:00','2021-11-16 17:01:00',NULL),(3872,3117,40846,12449,2,3687,'App\\Models\\Receipt',3687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',920.00,NULL,NULL,1,'2021-11-16 17:01:00','2021-11-16 17:01:00',NULL),(3873,3117,40846,12449,2,3688,'App\\Models\\Receipt',3688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',400.00,NULL,NULL,1,'2021-11-16 17:01:00','2021-11-16 17:01:00',NULL),(3874,3117,40846,12449,2,3689,'App\\Models\\Receipt',3689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',976.00,NULL,NULL,1,'2021-11-16 17:01:00','2021-11-16 17:01:00',NULL),(3875,3117,40846,12449,2,3690,'App\\Models\\Receipt',3690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',7370.00,NULL,NULL,1,'2021-11-16 17:01:00','2021-11-16 17:01:00',NULL),(3876,3117,40846,12449,2,3691,'App\\Models\\Receipt',3691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',360.00,NULL,NULL,1,'2021-11-16 17:01:00','2021-11-16 17:01:00',NULL),(3877,3117,40846,12449,2,3692,'App\\Models\\Receipt',3692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',2170.00,NULL,NULL,1,'2021-11-16 17:01:00','2021-11-16 17:01:00',NULL),(3878,3117,40846,12449,2,3693,'App\\Models\\Receipt',3693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',1175.00,NULL,NULL,1,'2021-11-16 17:01:00','2021-11-16 17:01:00',NULL),(3879,3117,40846,12449,2,3694,'App\\Models\\Receipt',3694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-10','2021-10-10',1810.00,NULL,NULL,1,'2021-11-16 17:01:00','2021-11-16 17:01:00',NULL),(3880,3117,40846,12449,2,3695,'App\\Models\\Receipt',3695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-10','2021-10-10',4625.00,NULL,NULL,1,'2021-11-16 17:01:00','2021-11-16 17:01:00',NULL),(3881,3117,40846,12449,2,3696,'App\\Models\\Receipt',3696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-10','2021-10-10',2224.00,NULL,NULL,1,'2021-11-16 17:01:00','2021-11-16 17:01:00',NULL),(3882,3117,40846,12449,2,3697,'App\\Models\\Receipt',3697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-10','2021-10-10',615.00,NULL,NULL,1,'2021-11-16 17:01:00','2021-11-16 17:01:00',NULL),(3883,3117,40846,12449,2,3698,'App\\Models\\Receipt',3698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-10','2021-10-10',1890.00,NULL,NULL,1,'2021-11-16 17:01:00','2021-11-16 17:01:00',NULL),(3884,3117,40846,12449,2,3699,'App\\Models\\Receipt',3699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-10','2021-10-10',980.00,NULL,NULL,1,'2021-11-16 17:01:00','2021-11-16 17:01:00',NULL),(3885,3117,40846,12449,2,3700,'App\\Models\\Receipt',3700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-10','2021-10-10',1145.00,NULL,NULL,1,'2021-11-16 17:01:01','2021-11-16 17:01:01',NULL);
INSERT INTO `balance_libro` VALUES (3886,3117,40846,12449,2,3701,'App\\Models\\Receipt',3701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-10','2021-10-10',1237.00,NULL,NULL,1,'2021-11-16 17:01:01','2021-11-16 17:01:01',NULL),(3887,3117,40846,12449,2,3702,'App\\Models\\Receipt',3702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',1450.00,NULL,NULL,1,'2021-11-16 17:01:01','2021-11-16 17:01:01',NULL),(3888,3117,40846,12449,2,3703,'App\\Models\\Receipt',3703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',1755.00,NULL,NULL,1,'2021-11-16 17:01:01','2021-11-16 17:01:01',NULL),(3889,3117,40846,12449,2,3704,'App\\Models\\Receipt',3704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',1030.00,NULL,NULL,1,'2021-11-16 17:01:01','2021-11-16 17:01:01',NULL),(3890,3117,40846,12449,2,3705,'App\\Models\\Receipt',3705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',332.00,NULL,NULL,1,'2021-11-16 17:01:01','2021-11-16 17:01:01',NULL),(3891,3117,40846,12449,2,3706,'App\\Models\\Receipt',3706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',384.00,NULL,NULL,1,'2021-11-16 17:01:01','2021-11-16 17:01:01',NULL),(3892,3117,40846,12449,2,3707,'App\\Models\\Receipt',3707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',910.00,NULL,NULL,1,'2021-11-16 17:01:01','2021-11-16 17:01:01',NULL),(3893,3117,40846,12449,2,3708,'App\\Models\\Receipt',3708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',1087.00,NULL,NULL,1,'2021-11-16 17:01:01','2021-11-16 17:01:01',NULL),(3894,3117,40846,12449,2,3709,'App\\Models\\Receipt',3709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',870.00,NULL,NULL,1,'2021-11-16 17:01:01','2021-11-16 17:01:01',NULL),(3895,3117,40846,12449,2,3710,'App\\Models\\Receipt',3710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',445.00,NULL,NULL,1,'2021-11-16 17:01:01','2021-11-16 17:01:01',NULL),(3896,3117,40846,12449,2,3711,'App\\Models\\Receipt',3711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',750.00,NULL,NULL,1,'2021-11-16 17:01:01','2021-11-16 17:01:01',NULL),(3897,3117,40846,12449,2,3712,'App\\Models\\Receipt',3712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',1040.00,NULL,NULL,1,'2021-11-16 17:01:01','2021-11-16 17:01:01',NULL),(3898,3117,40846,12449,2,3713,'App\\Models\\Receipt',3713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',1965.00,NULL,NULL,1,'2021-11-16 17:01:01','2021-11-16 17:01:01',NULL),(3899,3117,40846,12449,2,3714,'App\\Models\\Receipt',3714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',270.00,NULL,NULL,1,'2021-11-16 17:01:01','2021-11-16 17:01:01',NULL),(3900,3117,40846,12449,2,3715,'App\\Models\\Receipt',3715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',704.00,NULL,NULL,1,'2021-11-16 17:01:01','2021-11-16 17:01:01',NULL),(3901,3117,40846,12449,2,3716,'App\\Models\\Receipt',3716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',1190.00,NULL,NULL,1,'2021-11-16 17:01:01','2021-11-16 17:01:01',NULL),(3902,3117,40846,12449,2,3717,'App\\Models\\Receipt',3717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',840.00,NULL,NULL,1,'2021-11-16 17:01:01','2021-11-16 17:01:01',NULL),(3903,3117,40846,12449,2,3718,'App\\Models\\Receipt',3718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',1200.00,NULL,NULL,1,'2021-11-16 17:01:01','2021-11-16 17:01:01',NULL),(3904,3117,40846,12449,2,3719,'App\\Models\\Receipt',3719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',380.00,NULL,NULL,1,'2021-11-16 17:01:01','2021-11-16 17:01:01',NULL),(3905,3117,40846,12449,2,3720,'App\\Models\\Receipt',3720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',690.00,NULL,NULL,1,'2021-11-16 17:01:01','2021-11-16 17:01:01',NULL),(3906,3117,40846,12449,2,3721,'App\\Models\\Receipt',3721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',560.00,NULL,NULL,1,'2021-11-16 17:01:01','2021-11-16 17:01:01',NULL);
INSERT INTO `balance_libro` VALUES (3907,3117,40846,12449,2,3722,'App\\Models\\Receipt',3722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',1550.00,NULL,NULL,1,'2021-11-16 17:01:01','2021-11-16 17:01:01',NULL),(3908,3117,40846,12449,2,3723,'App\\Models\\Receipt',3723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',1510.00,NULL,NULL,1,'2021-11-16 17:01:01','2021-11-16 17:01:01',NULL),(3909,3117,40846,12449,2,3724,'App\\Models\\Receipt',3724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',190.00,NULL,NULL,1,'2021-11-16 17:01:01','2021-11-16 17:01:01',NULL),(3910,3117,40846,12449,2,3725,'App\\Models\\Receipt',3725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',720.00,NULL,NULL,1,'2021-11-16 17:01:01','2021-11-16 17:01:01',NULL),(3911,3117,40846,12449,2,3726,'App\\Models\\Receipt',3726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',1308.00,NULL,NULL,1,'2021-11-16 17:01:01','2021-11-16 17:01:01',NULL),(3912,3117,40846,12449,2,3727,'App\\Models\\Receipt',3727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',995.00,NULL,NULL,1,'2021-11-16 17:01:01','2021-11-16 17:01:01',NULL),(3913,3117,40846,12449,2,3728,'App\\Models\\Receipt',3728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',939.00,NULL,NULL,1,'2021-11-16 17:01:01','2021-11-16 17:01:01',NULL),(3914,3117,40846,12449,2,3729,'App\\Models\\Receipt',3729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',1080.00,NULL,NULL,1,'2021-11-16 17:01:02','2021-11-16 17:01:02',NULL),(3915,3117,40846,12449,2,3730,'App\\Models\\Receipt',3730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',4250.00,NULL,NULL,1,'2021-11-16 17:01:02','2021-11-16 17:01:02',NULL),(3916,3117,40846,12449,2,3731,'App\\Models\\Receipt',3731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',963.00,NULL,NULL,1,'2021-11-16 17:01:02','2021-11-16 17:01:02',NULL),(3917,3117,40846,12449,2,3732,'App\\Models\\Receipt',3732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',1040.00,NULL,NULL,1,'2021-11-16 17:01:02','2021-11-16 17:01:02',NULL),(3918,3117,40846,12449,2,3733,'App\\Models\\Receipt',3733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',2890.00,NULL,NULL,1,'2021-11-16 17:01:02','2021-11-16 17:01:02',NULL),(3919,3117,40846,12449,2,3734,'App\\Models\\Receipt',3734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',930.00,NULL,NULL,1,'2021-11-16 17:01:02','2021-11-16 17:01:02',NULL),(3920,3117,40846,12449,2,3735,'App\\Models\\Receipt',3735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',1660.00,NULL,NULL,1,'2021-11-16 17:01:02','2021-11-16 17:01:02',NULL),(3921,3117,40846,12449,2,3736,'App\\Models\\Receipt',3736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',840.00,NULL,NULL,1,'2021-11-16 17:01:02','2021-11-16 17:01:02',NULL),(3922,3117,40846,12449,2,3737,'App\\Models\\Receipt',3737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',1350.00,NULL,NULL,1,'2021-11-16 17:01:02','2021-11-16 17:01:02',NULL),(3923,3117,40846,12449,2,3738,'App\\Models\\Receipt',3738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',1910.00,NULL,NULL,1,'2021-11-16 17:01:02','2021-11-16 17:01:02',NULL),(3924,3117,40846,12449,2,3739,'App\\Models\\Receipt',3739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',1750.00,NULL,NULL,1,'2021-11-16 17:01:02','2021-11-16 17:01:02',NULL),(3925,3117,40846,12449,2,3740,'App\\Models\\Receipt',3740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',1331.00,NULL,NULL,1,'2021-11-16 17:01:02','2021-11-16 17:01:02',NULL),(3926,3117,40846,12449,2,3741,'App\\Models\\Receipt',3741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',1365.00,NULL,NULL,1,'2021-11-16 17:01:02','2021-11-16 17:01:02',NULL),(3927,3117,40846,12449,2,3742,'App\\Models\\Receipt',3742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',1340.00,NULL,NULL,1,'2021-11-16 17:01:02','2021-11-16 17:01:02',NULL);
INSERT INTO `balance_libro` VALUES (3928,3117,40846,12449,2,3743,'App\\Models\\Receipt',3743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',1280.00,NULL,NULL,1,'2021-11-16 17:01:02','2021-11-16 17:01:02',NULL),(3929,3117,40846,12449,2,3744,'App\\Models\\Receipt',3744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',3845.00,NULL,NULL,1,'2021-11-16 17:01:02','2021-11-16 17:01:02',NULL),(3930,3117,40846,12449,2,3745,'App\\Models\\Receipt',3745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',1466.00,NULL,NULL,1,'2021-11-16 17:01:02','2021-11-16 17:01:02',NULL),(3931,3117,40846,12449,2,3746,'App\\Models\\Receipt',3746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',1990.00,NULL,NULL,1,'2021-11-16 17:01:02','2021-11-16 17:01:02',NULL),(3932,3117,40846,12449,2,3747,'App\\Models\\Receipt',3747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',1625.00,NULL,NULL,1,'2021-11-16 17:01:02','2021-11-16 17:01:02',NULL),(3933,3117,40846,12449,2,3748,'App\\Models\\Receipt',3748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',1350.00,NULL,NULL,1,'2021-11-16 17:01:02','2021-11-16 17:01:02',NULL),(3934,3117,40846,12449,2,3749,'App\\Models\\Receipt',3749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',1130.00,NULL,NULL,1,'2021-11-16 17:01:02','2021-11-16 17:01:02',NULL),(3935,3117,40846,12449,2,3750,'App\\Models\\Receipt',3750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',4970.00,NULL,NULL,1,'2021-11-16 17:01:02','2021-11-16 17:01:02',NULL),(3936,3117,40846,12449,2,3751,'App\\Models\\Receipt',3751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',2815.00,NULL,NULL,1,'2021-11-16 17:01:02','2021-11-16 17:01:02',NULL),(3937,3117,40846,12449,2,3752,'App\\Models\\Receipt',3752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',2578.00,NULL,NULL,1,'2021-11-16 17:01:02','2021-11-16 17:01:02',NULL),(3938,3117,40846,12449,2,3753,'App\\Models\\Receipt',3753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',1720.00,NULL,NULL,1,'2021-11-16 17:01:02','2021-11-16 17:01:02',NULL),(3939,3117,40846,12449,2,3754,'App\\Models\\Receipt',3754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',1290.00,NULL,NULL,1,'2021-11-16 17:01:02','2021-11-16 17:01:02',NULL),(3940,3117,40846,12449,2,3755,'App\\Models\\Receipt',3755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',200.00,NULL,NULL,1,'2021-11-16 17:01:02','2021-11-16 17:01:02',NULL),(3941,3117,40846,12449,2,3756,'App\\Models\\Receipt',3756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',640.00,NULL,NULL,1,'2021-11-16 17:01:02','2021-11-16 17:01:02',NULL),(3942,3117,40846,12449,2,3757,'App\\Models\\Receipt',3757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',1240.00,NULL,NULL,1,'2021-11-16 17:01:02','2021-11-16 17:01:02',NULL),(3943,3117,40846,12449,2,3758,'App\\Models\\Receipt',3758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',410.00,NULL,NULL,1,'2021-11-16 17:01:03','2021-11-16 17:01:03',NULL),(3944,3117,40846,12449,2,3759,'App\\Models\\Receipt',3759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',370.00,NULL,NULL,1,'2021-11-16 17:01:03','2021-11-16 17:01:03',NULL),(3945,3117,40846,12449,2,3760,'App\\Models\\Receipt',3760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',210.00,NULL,NULL,1,'2021-11-16 17:01:03','2021-11-16 17:01:03',NULL),(3946,3117,40846,12449,2,3761,'App\\Models\\Receipt',3761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',915.00,NULL,NULL,1,'2021-11-16 17:01:03','2021-11-16 17:01:03',NULL),(3947,3117,40846,12449,2,3762,'App\\Models\\Receipt',3762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',540.00,NULL,NULL,1,'2021-11-16 17:01:03','2021-11-16 17:01:03',NULL),(3948,3117,40846,12449,2,3763,'App\\Models\\Receipt',3763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',550.00,NULL,NULL,1,'2021-11-16 17:01:03','2021-11-16 17:01:03',NULL);
INSERT INTO `balance_libro` VALUES (3949,3117,40846,12449,2,3764,'App\\Models\\Receipt',3764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',640.00,NULL,NULL,1,'2021-11-16 17:01:03','2021-11-16 17:01:03',NULL),(3950,3117,40846,12449,2,3765,'App\\Models\\Receipt',3765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',380.00,NULL,NULL,1,'2021-11-16 17:01:03','2021-11-16 17:01:03',NULL),(3951,3117,40846,12449,2,3766,'App\\Models\\Receipt',3766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',295.00,NULL,NULL,1,'2021-11-16 17:01:03','2021-11-16 17:01:03',NULL),(3952,3117,40846,12449,2,3767,'App\\Models\\Receipt',3767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',1660.00,NULL,NULL,1,'2021-11-16 17:01:03','2021-11-16 17:01:03',NULL),(3953,3117,40846,12449,2,3768,'App\\Models\\Receipt',3768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',510.00,NULL,NULL,1,'2021-11-16 17:01:03','2021-11-16 17:01:03',NULL),(3954,3117,40846,12449,2,3769,'App\\Models\\Receipt',3769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',1035.00,NULL,NULL,1,'2021-11-16 17:01:03','2021-11-16 17:01:03',NULL),(3955,3117,40846,12449,2,3770,'App\\Models\\Receipt',3770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',550.00,NULL,NULL,1,'2021-11-16 17:01:03','2021-11-16 17:01:03',NULL),(3956,3117,40846,12449,2,3771,'App\\Models\\Receipt',3771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',480.00,NULL,NULL,1,'2021-11-16 17:01:03','2021-11-16 17:01:03',NULL),(3957,3117,40846,12449,2,3772,'App\\Models\\Receipt',3772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',620.00,NULL,NULL,1,'2021-11-16 17:01:03','2021-11-16 17:01:03',NULL),(3958,3117,40846,12449,2,3773,'App\\Models\\Receipt',3773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',935.00,NULL,NULL,1,'2021-11-16 17:01:03','2021-11-16 17:01:03',NULL),(3959,3117,40846,12449,2,3774,'App\\Models\\Receipt',3774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',710.00,NULL,NULL,1,'2021-11-16 17:01:03','2021-11-16 17:01:03',NULL),(3960,3117,40846,12449,2,3775,'App\\Models\\Receipt',3775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',300.00,NULL,NULL,1,'2021-11-16 17:01:03','2021-11-16 17:01:03',NULL),(3961,3117,40846,12449,2,3776,'App\\Models\\Receipt',3776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',490.00,NULL,NULL,1,'2021-11-16 17:01:03','2021-11-16 17:01:03',NULL),(3962,3117,40846,12449,2,3777,'App\\Models\\Receipt',3777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',730.00,NULL,NULL,1,'2021-11-16 17:01:03','2021-11-16 17:01:03',NULL),(3963,3117,40846,12449,2,3778,'App\\Models\\Receipt',3778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',190.00,NULL,NULL,1,'2021-11-16 17:01:03','2021-11-16 17:01:03',NULL),(3964,3117,40846,12449,2,3779,'App\\Models\\Receipt',3779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',1770.00,NULL,NULL,1,'2021-11-16 17:01:03','2021-11-16 17:01:03',NULL),(3965,3117,40846,12449,2,3780,'App\\Models\\Receipt',3780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',2930.00,NULL,NULL,1,'2021-11-16 17:01:03','2021-11-16 17:01:03',NULL),(3966,3117,40846,12449,2,3781,'App\\Models\\Receipt',3781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',1313.00,NULL,NULL,1,'2021-11-16 17:01:03','2021-11-16 17:01:03',NULL),(3967,3117,40846,12449,2,3782,'App\\Models\\Receipt',3782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',330.00,NULL,NULL,1,'2021-11-16 17:01:03','2021-11-16 17:01:03',NULL),(3968,3117,40846,12449,2,3783,'App\\Models\\Receipt',3783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',500.00,NULL,NULL,1,'2021-11-16 17:01:03','2021-11-16 17:01:03',NULL),(3969,3117,40846,12449,2,3784,'App\\Models\\Receipt',3784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',920.25,NULL,NULL,1,'2021-11-16 17:01:03','2021-11-16 17:01:03',NULL);
INSERT INTO `balance_libro` VALUES (3970,3117,40846,12449,2,3785,'App\\Models\\Receipt',3785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',650.00,NULL,NULL,1,'2021-11-16 17:01:04','2021-11-16 17:01:04',NULL),(3971,3117,40846,12449,2,3786,'App\\Models\\Receipt',3786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',1512.00,NULL,NULL,1,'2021-11-16 17:01:04','2021-11-16 17:01:04',NULL),(3972,3117,40846,12449,2,3787,'App\\Models\\Receipt',3787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',375.00,NULL,NULL,1,'2021-11-16 17:01:04','2021-11-16 17:01:04',NULL),(3973,3117,40846,12449,2,3788,'App\\Models\\Receipt',3788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',340.00,NULL,NULL,1,'2021-11-16 17:01:04','2021-11-16 17:01:04',NULL),(3974,3117,40846,12449,2,3789,'App\\Models\\Receipt',3789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',1550.00,NULL,NULL,1,'2021-11-16 17:01:04','2021-11-16 17:01:04',NULL),(3975,3117,40846,12449,2,3790,'App\\Models\\Receipt',3790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',770.00,NULL,NULL,1,'2021-11-16 17:01:04','2021-11-16 17:01:04',NULL),(3976,3117,40846,12449,2,3791,'App\\Models\\Receipt',3791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',2115.00,NULL,NULL,1,'2021-11-16 17:01:04','2021-11-16 17:01:04',NULL),(3977,3117,40846,12449,2,3792,'App\\Models\\Receipt',3792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',687.00,NULL,NULL,1,'2021-11-16 17:01:04','2021-11-16 17:01:04',NULL),(3978,3117,40846,12449,2,3793,'App\\Models\\Receipt',3793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',585.00,NULL,NULL,1,'2021-11-16 17:01:04','2021-11-16 17:01:04',NULL),(3979,3117,40846,12449,2,3794,'App\\Models\\Receipt',3794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',1650.00,NULL,NULL,1,'2021-11-16 17:01:04','2021-11-16 17:01:04',NULL),(3980,3117,40846,12449,2,3795,'App\\Models\\Receipt',3795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',650.00,NULL,NULL,1,'2021-11-16 17:01:04','2021-11-16 17:01:04',NULL),(3981,3117,40846,12449,2,3796,'App\\Models\\Receipt',3796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',100.00,NULL,NULL,1,'2021-11-16 17:01:04','2021-11-16 17:01:04',NULL),(3982,3117,40846,12449,2,3797,'App\\Models\\Receipt',3797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',1000.00,NULL,NULL,1,'2021-11-16 17:01:04','2021-11-16 17:01:04',NULL),(3983,3117,40846,12449,2,3798,'App\\Models\\Receipt',3798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',700.00,NULL,NULL,1,'2021-11-16 17:01:04','2021-11-16 17:01:04',NULL),(3984,3117,40846,12449,2,3799,'App\\Models\\Receipt',3799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',1235.00,NULL,NULL,1,'2021-11-16 17:01:04','2021-11-16 17:01:04',NULL),(3985,3117,40846,12449,2,3800,'App\\Models\\Receipt',3800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',965.00,NULL,NULL,1,'2021-11-16 17:01:04','2021-11-16 17:01:04',NULL),(3986,3117,40846,12449,2,3801,'App\\Models\\Receipt',3801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',5180.00,NULL,NULL,1,'2021-11-16 17:01:04','2021-11-16 17:01:04',NULL),(3987,3117,40846,12449,2,3802,'App\\Models\\Receipt',3802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',500.00,NULL,NULL,1,'2021-11-16 17:01:04','2021-11-16 17:01:04',NULL),(3988,3117,40846,12449,2,3803,'App\\Models\\Receipt',3803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',770.00,NULL,NULL,1,'2021-11-16 17:01:04','2021-11-16 17:01:04',NULL),(3989,3117,40846,12449,2,3804,'App\\Models\\Receipt',3804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',400.00,NULL,NULL,1,'2021-11-16 17:01:04','2021-11-16 17:01:04',NULL),(3990,3117,40846,12449,2,3805,'App\\Models\\Receipt',3805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',2557.00,NULL,NULL,1,'2021-11-16 17:01:04','2021-11-16 17:01:04',NULL);
INSERT INTO `balance_libro` VALUES (3991,3117,40846,12449,2,3806,'App\\Models\\Receipt',3806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',280.00,NULL,NULL,1,'2021-11-16 17:01:04','2021-11-16 17:01:04',NULL),(3992,3117,40846,12449,2,3807,'App\\Models\\Receipt',3807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',1040.00,NULL,NULL,1,'2021-11-16 17:01:04','2021-11-16 17:01:04',NULL),(3993,3117,40846,12449,2,3808,'App\\Models\\Receipt',3808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',340.00,NULL,NULL,1,'2021-11-16 17:01:04','2021-11-16 17:01:04',NULL),(3994,3117,40846,12449,2,3809,'App\\Models\\Receipt',3809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',1390.00,NULL,NULL,1,'2021-11-16 17:01:04','2021-11-16 17:01:04',NULL),(3995,3117,40846,12449,2,3810,'App\\Models\\Receipt',3810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',685.00,NULL,NULL,1,'2021-11-16 17:01:04','2021-11-16 17:01:04',NULL),(3996,3117,40846,12449,2,3811,'App\\Models\\Receipt',3811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',1250.00,NULL,NULL,1,'2021-11-16 17:01:04','2021-11-16 17:01:04',NULL),(3997,3117,40846,12449,2,3812,'App\\Models\\Receipt',3812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',1200.00,NULL,NULL,1,'2021-11-16 17:01:05','2021-11-16 17:01:05',NULL),(3998,3117,40846,12449,2,3813,'App\\Models\\Receipt',3813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',1050.00,NULL,NULL,1,'2021-11-16 17:01:05','2021-11-16 17:01:05',NULL),(3999,3117,40846,12449,3,3814,'App\\Models\\Receipt',3814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',5342.30,NULL,NULL,1,'2021-11-16 17:01:25','2021-11-16 17:01:25',NULL),(4000,3117,40846,12449,3,3815,'App\\Models\\Receipt',3815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',7233.86,NULL,NULL,1,'2021-11-16 17:01:25','2021-11-16 17:01:25',NULL),(4001,3117,40846,12449,3,3816,'App\\Models\\Receipt',3816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',7525.94,NULL,NULL,1,'2021-11-16 17:01:25','2021-11-16 17:01:25',NULL),(4002,3117,40846,12449,3,3817,'App\\Models\\Receipt',3817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',0.00,NULL,NULL,1,'2021-11-16 17:01:25','2021-11-16 17:01:25',NULL),(4003,3117,40846,12449,3,3818,'App\\Models\\Receipt',3818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',4958.68,NULL,NULL,1,'2021-11-16 17:01:25','2021-11-16 17:01:25',NULL),(4004,3117,40846,12449,3,3819,'App\\Models\\Receipt',3819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',5147.98,NULL,NULL,1,'2021-11-16 17:01:25','2021-11-16 17:01:25',NULL),(4005,3117,40846,12449,3,3820,'App\\Models\\Receipt',3820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',1002.99,NULL,NULL,1,'2021-11-16 17:01:25','2021-11-16 17:01:25',NULL),(4006,3117,40846,12449,3,3821,'App\\Models\\Receipt',3821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',2088.34,NULL,NULL,1,'2021-11-16 17:01:25','2021-11-16 17:01:25',NULL),(4007,3117,40846,12449,3,3822,'App\\Models\\Receipt',3822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',4192.26,NULL,NULL,1,'2021-11-16 17:01:25','2021-11-16 17:01:25',NULL),(4008,3117,40846,12449,3,3823,'App\\Models\\Receipt',3823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',10786.56,NULL,NULL,1,'2021-11-16 17:01:25','2021-11-16 17:01:25',NULL),(4009,3117,40846,12449,3,3824,'App\\Models\\Receipt',3824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',609.61,NULL,NULL,1,'2021-11-16 17:01:25','2021-11-16 17:01:25',NULL),(4010,3117,40846,12449,3,3825,'App\\Models\\Receipt',3825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',1384.72,NULL,NULL,1,'2021-11-16 17:01:25','2021-11-16 17:01:25',NULL),(4011,3117,40846,12449,3,3826,'App\\Models\\Receipt',3826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',1375.00,NULL,NULL,1,'2021-11-16 17:01:25','2021-11-16 17:01:25',NULL);
INSERT INTO `balance_libro` VALUES (4012,3117,40846,12449,3,3827,'App\\Models\\Receipt',3827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',18555.37,NULL,NULL,1,'2021-11-16 17:01:25','2021-11-16 17:01:25',NULL),(4013,3117,40846,12449,3,3828,'App\\Models\\Receipt',3828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',13064.69,NULL,NULL,1,'2021-11-16 17:01:26','2021-11-16 17:01:26',NULL),(4014,3117,40846,12449,3,3829,'App\\Models\\Receipt',3829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',6793.17,NULL,NULL,1,'2021-11-16 17:01:26','2021-11-16 17:01:26',NULL),(4015,3117,40846,12449,3,3830,'App\\Models\\Receipt',3830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',5248.59,NULL,NULL,1,'2021-11-16 17:01:26','2021-11-16 17:01:26',NULL),(4016,3117,40846,12449,3,3831,'App\\Models\\Receipt',3831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',6083.82,NULL,NULL,1,'2021-11-16 17:01:26','2021-11-16 17:01:26',NULL),(4017,3117,40846,12449,3,3832,'App\\Models\\Receipt',3832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',1897.16,NULL,NULL,1,'2021-11-16 17:01:26','2021-11-16 17:01:26',NULL),(4018,3117,40846,12449,3,3833,'App\\Models\\Receipt',3833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',7804.57,NULL,NULL,1,'2021-11-16 17:01:26','2021-11-16 17:01:26',NULL),(4019,3117,40846,12449,3,3834,'App\\Models\\Receipt',3834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-16','2021-10-16',2181.47,NULL,NULL,1,'2021-11-16 17:01:26','2021-11-16 17:01:26',NULL),(4020,3117,40846,12449,3,3835,'App\\Models\\Receipt',3835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-16','2021-10-16',1800.12,NULL,NULL,1,'2021-11-16 17:01:26','2021-11-16 17:01:26',NULL),(4021,3117,40846,12449,3,3836,'App\\Models\\Receipt',3836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',4414.70,NULL,NULL,1,'2021-11-16 17:01:26','2021-11-16 17:01:26',NULL),(4022,3117,40846,12449,3,3837,'App\\Models\\Receipt',3837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',8431.23,NULL,NULL,1,'2021-11-16 17:01:26','2021-11-16 17:01:26',NULL),(4023,3117,40846,12449,3,3838,'App\\Models\\Receipt',3838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',13492.81,NULL,NULL,1,'2021-11-16 17:01:26','2021-11-16 17:01:26',NULL),(4024,3117,40846,12449,3,3839,'App\\Models\\Receipt',3839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',5495.64,NULL,NULL,1,'2021-11-16 17:01:26','2021-11-16 17:01:26',NULL),(4025,3117,40846,12449,3,3840,'App\\Models\\Receipt',3840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',4496.28,NULL,NULL,1,'2021-11-16 17:01:26','2021-11-16 17:01:26',NULL),(4026,3117,40846,12449,3,3841,'App\\Models\\Receipt',3841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',3823.06,NULL,NULL,1,'2021-11-16 17:01:26','2021-11-16 17:01:26',NULL),(4027,3117,40846,12449,3,3842,'App\\Models\\Receipt',3842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',30612.08,NULL,NULL,1,'2021-11-16 17:01:26','2021-11-16 17:01:26',NULL),(4028,3117,40846,12449,3,3843,'App\\Models\\Receipt',3843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',6707.12,NULL,NULL,1,'2021-11-16 17:01:26','2021-11-16 17:01:26',NULL),(4029,3117,40846,12449,3,3844,'App\\Models\\Receipt',3844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',4601.07,NULL,NULL,1,'2021-11-16 17:01:26','2021-11-16 17:01:26',NULL),(4030,3117,40846,12449,3,3845,'App\\Models\\Receipt',3845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',11329.27,NULL,NULL,1,'2021-11-16 17:01:26','2021-11-16 17:01:26',NULL),(4031,3117,40846,12449,3,3846,'App\\Models\\Receipt',3846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',2215.11,NULL,NULL,1,'2021-11-16 17:01:26','2021-11-16 17:01:26',NULL),(4032,3117,40846,12449,3,3847,'App\\Models\\Receipt',3847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',10022.85,NULL,NULL,1,'2021-11-16 17:01:26','2021-11-16 17:01:26',NULL);
INSERT INTO `balance_libro` VALUES (4033,3117,40846,12449,3,3848,'App\\Models\\Receipt',3848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',5740.20,NULL,NULL,1,'2021-11-16 17:01:26','2021-11-16 17:01:26',NULL),(4034,3117,40846,12449,3,3849,'App\\Models\\Receipt',3849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',9907.95,NULL,NULL,1,'2021-11-16 17:01:26','2021-11-16 17:01:26',NULL),(4035,3117,40846,12449,3,3850,'App\\Models\\Receipt',3850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',8210.66,NULL,NULL,1,'2021-11-16 17:01:26','2021-11-16 17:01:26',NULL),(4036,3117,40846,12449,3,3851,'App\\Models\\Receipt',3851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',1686.82,NULL,NULL,1,'2021-11-16 17:01:26','2021-11-16 17:01:26',NULL),(4037,3117,40846,12449,3,3852,'App\\Models\\Receipt',3852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',4584.54,NULL,NULL,1,'2021-11-16 17:01:26','2021-11-16 17:01:26',NULL),(4038,3117,40846,12449,3,3853,'App\\Models\\Receipt',3853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',10045.90,NULL,NULL,1,'2021-11-16 17:01:26','2021-11-16 17:01:26',NULL),(4039,3117,40846,12449,3,3854,'App\\Models\\Receipt',3854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-30','2021-10-30',125.00,NULL,NULL,1,'2021-11-16 17:01:26','2021-11-16 17:01:26',NULL),(4040,3117,40846,12449,3,3855,'App\\Models\\Receipt',3855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',336.00,NULL,NULL,1,'2021-11-16 17:01:26','2021-11-16 17:01:26',NULL),(4041,3117,40846,12449,3,3856,'App\\Models\\Receipt',3856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',1392.73,NULL,NULL,1,'2021-11-16 17:01:27','2021-11-16 17:01:27',NULL),(4042,3117,40846,12448,2,3857,'App\\Models\\Receipt',3857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',1620.00,NULL,NULL,1,'2021-11-16 17:08:23','2021-11-16 17:08:23',NULL),(4043,3117,40846,12448,2,3858,'App\\Models\\Receipt',3858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',1228.00,NULL,NULL,1,'2021-11-16 17:08:23','2021-11-16 17:08:23',NULL),(4044,3117,40846,12448,2,3859,'App\\Models\\Receipt',3859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',3630.00,NULL,NULL,1,'2021-11-16 17:08:24','2021-11-16 17:08:24',NULL),(4045,3117,40846,12448,2,3860,'App\\Models\\Receipt',3860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',1460.00,NULL,NULL,1,'2021-11-16 17:08:24','2021-11-16 17:08:24',NULL),(4046,3117,40846,12448,2,3861,'App\\Models\\Receipt',3861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',5000.00,NULL,NULL,1,'2021-11-16 17:08:24','2021-11-16 17:08:24',NULL),(4047,3117,40846,12448,2,3862,'App\\Models\\Receipt',3862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',5000.00,NULL,NULL,1,'2021-11-16 17:08:24','2021-11-16 17:08:24',NULL),(4048,3117,40846,12448,2,3863,'App\\Models\\Receipt',3863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',5000.00,NULL,NULL,1,'2021-11-16 17:08:24','2021-11-16 17:08:24',NULL),(4049,3117,40846,12448,2,3864,'App\\Models\\Receipt',3864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',5000.00,NULL,NULL,1,'2021-11-16 17:08:24','2021-11-16 17:08:24',NULL),(4050,3117,40846,12448,2,3865,'App\\Models\\Receipt',3865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',260.00,NULL,NULL,1,'2021-11-16 17:08:24','2021-11-16 17:08:24',NULL),(4051,3117,40846,12448,2,3866,'App\\Models\\Receipt',3866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',2420.00,NULL,NULL,1,'2021-11-16 17:08:24','2021-11-16 17:08:24',NULL),(4052,3117,40846,12448,2,3867,'App\\Models\\Receipt',3867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',1466.00,NULL,NULL,1,'2021-11-16 17:08:24','2021-11-16 17:08:24',NULL),(4053,3117,40846,12448,2,3868,'App\\Models\\Receipt',3868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',1610.00,NULL,NULL,1,'2021-11-16 17:08:24','2021-11-16 17:08:24',NULL);
INSERT INTO `balance_libro` VALUES (4054,3117,40846,12448,2,3869,'App\\Models\\Receipt',3869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',840.00,NULL,NULL,1,'2021-11-16 17:08:24','2021-11-16 17:08:24',NULL),(4055,3117,40846,12448,2,3870,'App\\Models\\Receipt',3870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',5000.00,NULL,NULL,1,'2021-11-16 17:08:24','2021-11-16 17:08:24',NULL),(4056,3117,40846,12448,2,3871,'App\\Models\\Receipt',3871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',5000.00,NULL,NULL,1,'2021-11-16 17:08:24','2021-11-16 17:08:24',NULL),(4057,3117,40846,12448,2,3872,'App\\Models\\Receipt',3872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',5000.00,NULL,NULL,1,'2021-11-16 17:08:24','2021-11-16 17:08:24',NULL),(4058,3117,40846,12448,2,3873,'App\\Models\\Receipt',3873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',5000.00,NULL,NULL,1,'2021-11-16 17:08:24','2021-11-16 17:08:24',NULL),(4059,3117,40846,12448,2,3874,'App\\Models\\Receipt',3874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',1005.00,NULL,NULL,1,'2021-11-16 17:08:24','2021-11-16 17:08:24',NULL),(4060,3117,40846,12448,2,3875,'App\\Models\\Receipt',3875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',1395.00,NULL,NULL,1,'2021-11-16 17:08:24','2021-11-16 17:08:24',NULL),(4061,3117,40846,12448,2,3876,'App\\Models\\Receipt',3876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',652.00,NULL,NULL,1,'2021-11-16 17:08:24','2021-11-16 17:08:24',NULL),(4062,3117,40846,12448,2,3877,'App\\Models\\Receipt',3877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',2880.00,NULL,NULL,1,'2021-11-16 17:08:24','2021-11-16 17:08:24',NULL),(4063,3117,40846,12448,2,3878,'App\\Models\\Receipt',3878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',1640.00,NULL,NULL,1,'2021-11-16 17:08:24','2021-11-16 17:08:24',NULL),(4064,3117,40846,12448,2,3879,'App\\Models\\Receipt',3879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',1030.00,NULL,NULL,1,'2021-11-16 17:08:25','2021-11-16 17:08:25',NULL),(4065,3117,40846,12448,2,3880,'App\\Models\\Receipt',3880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',6000.00,NULL,NULL,1,'2021-11-16 17:08:25','2021-11-16 17:08:25',NULL),(4066,3117,40846,12448,2,3881,'App\\Models\\Receipt',3881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',2170.00,NULL,NULL,1,'2021-11-16 17:08:25','2021-11-16 17:08:25',NULL),(4067,3117,40846,12448,2,3882,'App\\Models\\Receipt',3882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',250.00,NULL,NULL,1,'2021-11-16 17:08:25','2021-11-16 17:08:25',NULL),(4068,3117,40846,12448,2,3883,'App\\Models\\Receipt',3883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',1140.00,NULL,NULL,1,'2021-11-16 17:08:25','2021-11-16 17:08:25',NULL),(4069,3117,40846,12448,2,3884,'App\\Models\\Receipt',3884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',455.00,NULL,NULL,1,'2021-11-16 17:08:25','2021-11-16 17:08:25',NULL),(4070,3117,40846,12448,2,3885,'App\\Models\\Receipt',3885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',1580.00,NULL,NULL,1,'2021-11-16 17:08:25','2021-11-16 17:08:25',NULL),(4071,3117,40846,12448,2,3886,'App\\Models\\Receipt',3886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',500.00,NULL,NULL,1,'2021-11-16 17:08:25','2021-11-16 17:08:25',NULL),(4072,3117,40846,12448,2,3887,'App\\Models\\Receipt',3887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',1430.00,NULL,NULL,1,'2021-11-16 17:08:25','2021-11-16 17:08:25',NULL),(4073,3117,40846,12448,2,3888,'App\\Models\\Receipt',3888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',450.00,NULL,NULL,1,'2021-11-16 17:08:25','2021-11-16 17:08:25',NULL),(4074,3117,40846,12448,2,3889,'App\\Models\\Receipt',3889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',940.00,NULL,NULL,1,'2021-11-16 17:08:25','2021-11-16 17:08:25',NULL);
INSERT INTO `balance_libro` VALUES (4075,3117,40846,12448,2,3890,'App\\Models\\Receipt',3890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',2235.00,NULL,NULL,1,'2021-11-16 17:08:25','2021-11-16 17:08:25',NULL),(4076,3117,40846,12448,2,3891,'App\\Models\\Receipt',3891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',1700.00,NULL,NULL,1,'2021-11-16 17:08:25','2021-11-16 17:08:25',NULL),(4077,3117,40846,12448,2,3892,'App\\Models\\Receipt',3892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',1640.00,NULL,NULL,1,'2021-11-16 17:08:25','2021-11-16 17:08:25',NULL),(4078,3117,40846,12448,2,3893,'App\\Models\\Receipt',3893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',1020.00,NULL,NULL,1,'2021-11-16 17:08:25','2021-11-16 17:08:25',NULL),(4079,3117,40846,12448,2,3894,'App\\Models\\Receipt',3894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',4705.00,NULL,NULL,1,'2021-11-16 17:08:25','2021-11-16 17:08:25',NULL),(4080,3117,40846,12448,2,3895,'App\\Models\\Receipt',3895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',390.00,NULL,NULL,1,'2021-11-16 17:08:25','2021-11-16 17:08:25',NULL),(4081,3117,40846,12448,2,3896,'App\\Models\\Receipt',3896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',1620.00,NULL,NULL,1,'2021-11-16 17:08:25','2021-11-16 17:08:25',NULL),(4082,3117,40846,12448,2,3897,'App\\Models\\Receipt',3897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',1380.00,NULL,NULL,1,'2021-11-16 17:08:25','2021-11-16 17:08:25',NULL),(4083,3117,40846,12448,2,3898,'App\\Models\\Receipt',3898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',1700.00,NULL,NULL,1,'2021-11-16 17:08:25','2021-11-16 17:08:25',NULL),(4084,3117,40846,12448,2,3899,'App\\Models\\Receipt',3899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',1550.00,NULL,NULL,1,'2021-11-16 17:08:25','2021-11-16 17:08:25',NULL),(4085,3117,40846,12448,2,3900,'App\\Models\\Receipt',3900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',2580.00,NULL,NULL,1,'2021-11-16 17:08:25','2021-11-16 17:08:25',NULL),(4086,3117,40846,12448,2,3901,'App\\Models\\Receipt',3901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',1968.00,NULL,NULL,1,'2021-11-16 17:08:25','2021-11-16 17:08:25',NULL),(4087,3117,40846,12448,2,3902,'App\\Models\\Receipt',3902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',1180.00,NULL,NULL,1,'2021-11-16 17:08:26','2021-11-16 17:08:26',NULL),(4088,3117,40846,12448,2,3903,'App\\Models\\Receipt',3903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',1900.00,NULL,NULL,1,'2021-11-16 17:08:26','2021-11-16 17:08:26',NULL),(4089,3117,40846,12448,2,3904,'App\\Models\\Receipt',3904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',2352.00,NULL,NULL,1,'2021-11-16 17:08:26','2021-11-16 17:08:26',NULL),(4090,3117,40846,12448,2,3905,'App\\Models\\Receipt',3905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',4610.00,NULL,NULL,1,'2021-11-16 17:08:26','2021-11-16 17:08:26',NULL),(4091,3117,40846,12448,2,3906,'App\\Models\\Receipt',3906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',4490.00,NULL,NULL,1,'2021-11-16 17:08:26','2021-11-16 17:08:26',NULL),(4092,3117,40846,12448,2,3907,'App\\Models\\Receipt',3907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',1700.00,NULL,NULL,1,'2021-11-16 17:08:26','2021-11-16 17:08:26',NULL),(4093,3117,40846,12448,2,3908,'App\\Models\\Receipt',3908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',4000.00,NULL,NULL,1,'2021-11-16 17:08:26','2021-11-16 17:08:26',NULL),(4094,3117,40846,12448,2,3909,'App\\Models\\Receipt',3909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',1665.00,NULL,NULL,1,'2021-11-16 17:08:26','2021-11-16 17:08:26',NULL),(4095,3117,40846,12448,2,3910,'App\\Models\\Receipt',3910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',1300.00,NULL,NULL,1,'2021-11-16 17:08:26','2021-11-16 17:08:26',NULL);
INSERT INTO `balance_libro` VALUES (4096,3117,40846,12448,2,3911,'App\\Models\\Receipt',3911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',2270.00,NULL,NULL,1,'2021-11-16 17:08:26','2021-11-16 17:08:26',NULL),(4097,3117,40846,12448,2,3912,'App\\Models\\Receipt',3912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',2360.00,NULL,NULL,1,'2021-11-16 17:08:26','2021-11-16 17:08:26',NULL),(4098,3117,40846,12448,2,3913,'App\\Models\\Receipt',3913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',1200.00,NULL,NULL,1,'2021-11-16 17:08:26','2021-11-16 17:08:26',NULL),(4099,3117,40846,12448,2,3914,'App\\Models\\Receipt',3914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',1295.00,NULL,NULL,1,'2021-11-16 17:08:26','2021-11-16 17:08:26',NULL),(4100,3117,40846,12448,2,3915,'App\\Models\\Receipt',3915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',950.00,NULL,NULL,1,'2021-11-16 17:08:26','2021-11-16 17:08:26',NULL),(4101,3117,40846,12448,2,3916,'App\\Models\\Receipt',3916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',1265.00,NULL,NULL,1,'2021-11-16 17:08:26','2021-11-16 17:08:26',NULL),(4102,3117,40846,12448,2,3917,'App\\Models\\Receipt',3917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',2445.00,NULL,NULL,1,'2021-11-16 17:08:26','2021-11-16 17:08:26',NULL),(4103,3117,40846,12448,2,3918,'App\\Models\\Receipt',3918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',630.00,NULL,NULL,1,'2021-11-16 17:08:26','2021-11-16 17:08:26',NULL),(4104,3117,40846,12448,2,3919,'App\\Models\\Receipt',3919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',2900.00,NULL,NULL,1,'2021-11-16 17:08:26','2021-11-16 17:08:26',NULL),(4105,3117,40846,12448,2,3920,'App\\Models\\Receipt',3920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',2900.00,NULL,NULL,1,'2021-11-16 17:08:26','2021-11-16 17:08:26',NULL),(4106,3117,40846,12448,2,3921,'App\\Models\\Receipt',3921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',2090.00,NULL,NULL,1,'2021-11-16 17:08:26','2021-11-16 17:08:26',NULL),(4107,3117,40846,12448,2,3922,'App\\Models\\Receipt',3922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',810.00,NULL,NULL,1,'2021-11-16 17:08:26','2021-11-16 17:08:26',NULL),(4108,3117,40846,12448,2,3923,'App\\Models\\Receipt',3923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',965.00,NULL,NULL,1,'2021-11-16 17:08:26','2021-11-16 17:08:26',NULL),(4109,3117,40846,12448,2,3924,'App\\Models\\Receipt',3924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',580.00,NULL,NULL,1,'2021-11-16 17:08:26','2021-11-16 17:08:26',NULL),(4110,3117,40846,12448,2,3925,'App\\Models\\Receipt',3925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',858.00,NULL,NULL,1,'2021-11-16 17:08:26','2021-11-16 17:08:26',NULL),(4111,3117,40846,12448,2,3926,'App\\Models\\Receipt',3926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',641.00,NULL,NULL,1,'2021-11-16 17:08:26','2021-11-16 17:08:26',NULL),(4112,3117,40846,12448,2,3927,'App\\Models\\Receipt',3927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',565.00,NULL,NULL,1,'2021-11-16 17:08:26','2021-11-16 17:08:26',NULL),(4113,3117,40846,12448,2,3928,'App\\Models\\Receipt',3928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',630.00,NULL,NULL,1,'2021-11-16 17:08:26','2021-11-16 17:08:26',NULL),(4114,3117,40846,12448,2,3929,'App\\Models\\Receipt',3929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',1110.00,NULL,NULL,1,'2021-11-16 17:08:27','2021-11-16 17:08:27',NULL),(4115,3117,40846,12448,2,3930,'App\\Models\\Receipt',3930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',360.00,NULL,NULL,1,'2021-11-16 17:08:27','2021-11-16 17:08:27',NULL),(4116,3117,40846,12448,2,3931,'App\\Models\\Receipt',3931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',1520.00,NULL,NULL,1,'2021-11-16 17:08:27','2021-11-16 17:08:27',NULL);
INSERT INTO `balance_libro` VALUES (4117,3117,40846,12448,2,3932,'App\\Models\\Receipt',3932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',420.00,NULL,NULL,1,'2021-11-16 17:08:27','2021-11-16 17:08:27',NULL),(4118,3117,40846,12448,2,3933,'App\\Models\\Receipt',3933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',7050.00,NULL,NULL,1,'2021-11-16 17:08:27','2021-11-16 17:08:27',NULL),(4119,3117,40846,12448,2,3934,'App\\Models\\Receipt',3934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',480.00,NULL,NULL,1,'2021-11-16 17:08:27','2021-11-16 17:08:27',NULL),(4120,3117,40846,12448,2,3935,'App\\Models\\Receipt',3935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',425.00,NULL,NULL,1,'2021-11-16 17:08:27','2021-11-16 17:08:27',NULL),(4121,3117,40846,12448,2,3936,'App\\Models\\Receipt',3936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',460.00,NULL,NULL,1,'2021-11-16 17:08:27','2021-11-16 17:08:27',NULL),(4122,3117,40846,12448,2,3937,'App\\Models\\Receipt',3937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',1945.00,NULL,NULL,1,'2021-11-16 17:08:27','2021-11-16 17:08:27',NULL),(4123,3117,40846,12448,2,3938,'App\\Models\\Receipt',3938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',310.00,NULL,NULL,1,'2021-11-16 17:08:27','2021-11-16 17:08:27',NULL),(4124,3117,40846,12448,2,3939,'App\\Models\\Receipt',3939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',1270.00,NULL,NULL,1,'2021-11-16 17:08:27','2021-11-16 17:08:27',NULL),(4125,3117,40846,12448,2,3940,'App\\Models\\Receipt',3940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',860.00,NULL,NULL,1,'2021-11-16 17:08:27','2021-11-16 17:08:27',NULL),(4126,3117,40846,12448,2,3941,'App\\Models\\Receipt',3941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',570.00,NULL,NULL,1,'2021-11-16 17:08:27','2021-11-16 17:08:27',NULL),(4127,3117,40846,12448,2,3942,'App\\Models\\Receipt',3942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',2530.00,NULL,NULL,1,'2021-11-16 17:08:27','2021-11-16 17:08:27',NULL),(4128,3117,40846,12448,2,3943,'App\\Models\\Receipt',3943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',790.00,NULL,NULL,1,'2021-11-16 17:08:27','2021-11-16 17:08:27',NULL),(4129,3117,40846,12448,2,3944,'App\\Models\\Receipt',3944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',420.00,NULL,NULL,1,'2021-11-16 17:08:27','2021-11-16 17:08:27',NULL),(4130,3117,40846,12448,2,3945,'App\\Models\\Receipt',3945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',860.00,NULL,NULL,1,'2021-11-16 17:08:27','2021-11-16 17:08:27',NULL),(4131,3117,40846,12448,2,3946,'App\\Models\\Receipt',3946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',875.00,NULL,NULL,1,'2021-11-16 17:08:27','2021-11-16 17:08:27',NULL),(4132,3117,40846,12448,2,3947,'App\\Models\\Receipt',3947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',8000.00,NULL,NULL,1,'2021-11-16 17:08:27','2021-11-16 17:08:27',NULL),(4133,3117,40846,12448,2,3948,'App\\Models\\Receipt',3948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',10000.00,NULL,NULL,1,'2021-11-16 17:08:27','2021-11-16 17:08:27',NULL),(4134,3117,40846,12448,2,3949,'App\\Models\\Receipt',3949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',1081.00,NULL,NULL,1,'2021-11-16 17:08:27','2021-11-16 17:08:27',NULL),(4135,3117,40846,12448,2,3950,'App\\Models\\Receipt',3950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',1570.00,NULL,NULL,1,'2021-11-16 17:08:27','2021-11-16 17:08:27',NULL),(4136,3117,40846,12448,2,3951,'App\\Models\\Receipt',3951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',550.00,NULL,NULL,1,'2021-11-16 17:08:27','2021-11-16 17:08:27',NULL),(4137,3117,40846,12448,2,3952,'App\\Models\\Receipt',3952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',755.00,NULL,NULL,1,'2021-11-16 17:08:27','2021-11-16 17:08:27',NULL);
INSERT INTO `balance_libro` VALUES (4138,3117,40846,12448,2,3953,'App\\Models\\Receipt',3953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',480.00,NULL,NULL,1,'2021-11-16 17:08:27','2021-11-16 17:08:27',NULL),(4139,3117,40846,12448,2,3954,'App\\Models\\Receipt',3954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',2560.00,NULL,NULL,1,'2021-11-16 17:08:27','2021-11-16 17:08:27',NULL),(4140,3117,40846,12448,2,3955,'App\\Models\\Receipt',3955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',2499.50,NULL,NULL,1,'2021-11-16 17:08:27','2021-11-16 17:08:27',NULL),(4141,3117,40846,12448,2,3956,'App\\Models\\Receipt',3956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',1340.00,NULL,NULL,1,'2021-11-16 17:08:28','2021-11-16 17:08:28',NULL),(4142,3117,40846,12448,2,3957,'App\\Models\\Receipt',3957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',924.00,NULL,NULL,1,'2021-11-16 17:08:28','2021-11-16 17:08:28',NULL),(4143,3117,40846,12448,2,3958,'App\\Models\\Receipt',3958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',955.00,NULL,NULL,1,'2021-11-16 17:08:28','2021-11-16 17:08:28',NULL),(4144,3117,40846,12448,2,3959,'App\\Models\\Receipt',3959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',820.00,NULL,NULL,1,'2021-11-16 17:08:28','2021-11-16 17:08:28',NULL),(4145,3117,40846,12448,2,3960,'App\\Models\\Receipt',3960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',1487.00,NULL,NULL,1,'2021-11-16 17:08:28','2021-11-16 17:08:28',NULL),(4146,3117,40846,12448,2,3961,'App\\Models\\Receipt',3961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',362.00,NULL,NULL,1,'2021-11-16 17:08:28','2021-11-16 17:08:28',NULL),(4147,3117,40846,12448,2,3962,'App\\Models\\Receipt',3962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',595.00,NULL,NULL,1,'2021-11-16 17:08:28','2021-11-16 17:08:28',NULL),(4148,3117,40846,12448,2,3963,'App\\Models\\Receipt',3963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',350.00,NULL,NULL,1,'2021-11-16 17:08:28','2021-11-16 17:08:28',NULL),(4149,3117,40846,12448,2,3964,'App\\Models\\Receipt',3964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',1333.00,NULL,NULL,1,'2021-11-16 17:08:28','2021-11-16 17:08:28',NULL),(4150,3117,40846,12448,2,3965,'App\\Models\\Receipt',3965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',310.00,NULL,NULL,1,'2021-11-16 17:08:28','2021-11-16 17:08:28',NULL),(4151,3117,40846,12448,2,3966,'App\\Models\\Receipt',3966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',902.00,NULL,NULL,1,'2021-11-16 17:08:28','2021-11-16 17:08:28',NULL),(4152,3117,40846,12448,2,3967,'App\\Models\\Receipt',3967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',990.00,NULL,NULL,1,'2021-11-16 17:08:28','2021-11-16 17:08:28',NULL),(4153,3117,40846,12448,2,3968,'App\\Models\\Receipt',3968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',715.00,NULL,NULL,1,'2021-11-16 17:08:28','2021-11-16 17:08:28',NULL),(4154,3117,40846,12448,2,3969,'App\\Models\\Receipt',3969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',390.00,NULL,NULL,1,'2021-11-16 17:08:28','2021-11-16 17:08:28',NULL),(4155,3117,40846,12448,2,3970,'App\\Models\\Receipt',3970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',640.00,NULL,NULL,1,'2021-11-16 17:08:28','2021-11-16 17:08:28',NULL),(4156,3117,40846,12448,2,3971,'App\\Models\\Receipt',3971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',695.00,NULL,NULL,1,'2021-11-16 17:08:28','2021-11-16 17:08:28',NULL),(4157,3117,40846,12448,2,3972,'App\\Models\\Receipt',3972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',1175.00,NULL,NULL,1,'2021-11-16 17:08:28','2021-11-16 17:08:28',NULL),(4158,3117,40846,12448,2,3973,'App\\Models\\Receipt',3973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',905.00,NULL,NULL,1,'2021-11-16 17:08:28','2021-11-16 17:08:28',NULL);
INSERT INTO `balance_libro` VALUES (4159,3117,40846,12448,2,3974,'App\\Models\\Receipt',3974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',477.79,NULL,NULL,1,'2021-11-16 17:08:28','2021-11-16 17:08:28',NULL),(4160,3117,40846,12448,2,3975,'App\\Models\\Receipt',3975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',690.00,NULL,NULL,1,'2021-11-16 17:08:28','2021-11-16 17:08:28',NULL),(4161,3117,40846,12448,2,3976,'App\\Models\\Receipt',3976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',1025.00,NULL,NULL,1,'2021-11-16 17:08:28','2021-11-16 17:08:28',NULL),(4162,3117,40846,12448,2,3977,'App\\Models\\Receipt',3977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',1410.00,NULL,NULL,1,'2021-11-16 17:08:28','2021-11-16 17:08:28',NULL),(4163,3117,40846,12448,2,3978,'App\\Models\\Receipt',3978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',1300.00,NULL,NULL,1,'2021-11-16 17:08:28','2021-11-16 17:08:28',NULL),(4164,3117,40846,12448,2,3979,'App\\Models\\Receipt',3979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',270.00,NULL,NULL,1,'2021-11-16 17:08:28','2021-11-16 17:08:28',NULL),(4165,3117,40846,12448,2,3980,'App\\Models\\Receipt',3980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',1840.00,NULL,NULL,1,'2021-11-16 17:08:28','2021-11-16 17:08:28',NULL),(4166,3117,40846,12448,2,3981,'App\\Models\\Receipt',3981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',1090.00,NULL,NULL,1,'2021-11-16 17:08:29','2021-11-16 17:08:29',NULL),(4167,3117,40846,12448,2,3982,'App\\Models\\Receipt',3982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',970.00,NULL,NULL,1,'2021-11-16 17:08:29','2021-11-16 17:08:29',NULL),(4168,3117,40846,12448,2,3983,'App\\Models\\Receipt',3983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',960.00,NULL,NULL,1,'2021-11-16 17:08:29','2021-11-16 17:08:29',NULL),(4169,3117,40846,12448,2,3984,'App\\Models\\Receipt',3984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',520.00,NULL,NULL,1,'2021-11-16 17:08:29','2021-11-16 17:08:29',NULL),(4170,3117,40846,12448,2,3985,'App\\Models\\Receipt',3985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',700.00,NULL,NULL,1,'2021-11-16 17:08:29','2021-11-16 17:08:29',NULL),(4171,3117,40846,12448,2,3986,'App\\Models\\Receipt',3986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',1430.00,NULL,NULL,1,'2021-11-16 17:08:29','2021-11-16 17:08:29',NULL),(4172,3117,40846,12448,2,3987,'App\\Models\\Receipt',3987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',1038.00,NULL,NULL,1,'2021-11-16 17:08:29','2021-11-16 17:08:29',NULL),(4173,3117,40846,12448,2,3988,'App\\Models\\Receipt',3988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',1646.00,NULL,NULL,1,'2021-11-16 17:08:29','2021-11-16 17:08:29',NULL),(4174,3117,40846,12448,2,3989,'App\\Models\\Receipt',3989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',550.00,NULL,NULL,1,'2021-11-16 17:08:29','2021-11-16 17:08:29',NULL),(4175,3117,40846,12448,2,3990,'App\\Models\\Receipt',3990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',410.00,NULL,NULL,1,'2021-11-16 17:08:29','2021-11-16 17:08:29',NULL),(4176,3117,40846,12448,2,3991,'App\\Models\\Receipt',3991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',830.00,NULL,NULL,1,'2021-11-16 17:08:29','2021-11-16 17:08:29',NULL),(4177,3117,40846,12448,2,3992,'App\\Models\\Receipt',3992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',135.00,NULL,NULL,1,'2021-11-16 17:08:29','2021-11-16 17:08:29',NULL),(4178,3117,40846,12448,2,3993,'App\\Models\\Receipt',3993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',1460.00,NULL,NULL,1,'2021-11-16 17:08:29','2021-11-16 17:08:29',NULL),(4179,3117,40846,12448,2,3994,'App\\Models\\Receipt',3994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',1045.00,NULL,NULL,1,'2021-11-16 17:08:29','2021-11-16 17:08:29',NULL);
INSERT INTO `balance_libro` VALUES (4180,3117,40846,12448,2,3995,'App\\Models\\Receipt',3995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',140.00,NULL,NULL,1,'2021-11-16 17:08:29','2021-11-16 17:08:29',NULL),(4181,3117,40846,12448,2,3996,'App\\Models\\Receipt',3996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',436.00,NULL,NULL,1,'2021-11-16 17:08:29','2021-11-16 17:08:29',NULL),(4182,3117,40846,12448,2,3997,'App\\Models\\Receipt',3997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',840.00,NULL,NULL,1,'2021-11-16 17:08:29','2021-11-16 17:08:29',NULL),(4183,3117,40846,12448,2,3998,'App\\Models\\Receipt',3998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',187.00,NULL,NULL,1,'2021-11-16 17:08:29','2021-11-16 17:08:29',NULL),(4184,3117,40846,12448,2,3999,'App\\Models\\Receipt',3999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',800.00,NULL,NULL,1,'2021-11-16 17:08:29','2021-11-16 17:08:29',NULL),(4185,3117,40846,12448,2,4000,'App\\Models\\Receipt',4000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',1745.00,NULL,NULL,1,'2021-11-16 17:08:29','2021-11-16 17:08:29',NULL),(4186,3117,40846,12448,2,4001,'App\\Models\\Receipt',4001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',1413.00,NULL,NULL,1,'2021-11-16 17:08:29','2021-11-16 17:08:29',NULL),(4187,3117,40846,12448,2,4002,'App\\Models\\Receipt',4002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',535.00,NULL,NULL,1,'2021-11-16 17:08:29','2021-11-16 17:08:29',NULL),(4188,3117,40846,12448,2,4003,'App\\Models\\Receipt',4003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',635.00,NULL,NULL,1,'2021-11-16 17:08:29','2021-11-16 17:08:29',NULL),(4189,3117,40846,12448,2,4004,'App\\Models\\Receipt',4004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',300.00,NULL,NULL,1,'2021-11-16 17:08:29','2021-11-16 17:08:29',NULL),(4190,3117,40846,12448,2,4005,'App\\Models\\Receipt',4005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',905.00,NULL,NULL,1,'2021-11-16 17:08:29','2021-11-16 17:08:29',NULL),(4191,3117,40846,12448,2,4006,'App\\Models\\Receipt',4006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',730.00,NULL,NULL,1,'2021-11-16 17:08:29','2021-11-16 17:08:29',NULL),(4192,3117,40846,12448,2,4007,'App\\Models\\Receipt',4007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',670.00,NULL,NULL,1,'2021-11-16 17:08:30','2021-11-16 17:08:30',NULL),(4193,3117,40846,12448,2,4008,'App\\Models\\Receipt',4008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',490.00,NULL,NULL,1,'2021-11-16 17:08:30','2021-11-16 17:08:30',NULL),(4194,3117,40846,12448,2,4009,'App\\Models\\Receipt',4009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',2335.00,NULL,NULL,1,'2021-11-16 17:08:30','2021-11-16 17:08:30',NULL),(4195,3117,40846,12448,2,4010,'App\\Models\\Receipt',4010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',640.00,NULL,NULL,1,'2021-11-16 17:08:30','2021-11-16 17:08:30',NULL),(4196,3117,40846,12448,2,4011,'App\\Models\\Receipt',4011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',945.00,NULL,NULL,1,'2021-11-16 17:08:30','2021-11-16 17:08:30',NULL),(4197,3117,40846,12448,2,4012,'App\\Models\\Receipt',4012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',980.00,NULL,NULL,1,'2021-11-16 17:08:30','2021-11-16 17:08:30',NULL),(4198,3117,40846,12448,2,4013,'App\\Models\\Receipt',4013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',1120.00,NULL,NULL,1,'2021-11-16 17:08:30','2021-11-16 17:08:30',NULL),(4199,3117,40846,12448,2,4014,'App\\Models\\Receipt',4014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',1020.00,NULL,NULL,1,'2021-11-16 17:08:30','2021-11-16 17:08:30',NULL),(4200,3117,40846,12448,2,4015,'App\\Models\\Receipt',4015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',1300.00,NULL,NULL,1,'2021-11-16 17:08:30','2021-11-16 17:08:30',NULL);
INSERT INTO `balance_libro` VALUES (4201,3117,40846,12448,2,4016,'App\\Models\\Receipt',4016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',2005.00,NULL,NULL,1,'2021-11-16 17:08:30','2021-11-16 17:08:30',NULL),(4202,3117,40846,12448,2,4017,'App\\Models\\Receipt',4017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',1040.00,NULL,NULL,1,'2021-11-16 17:08:30','2021-11-16 17:08:30',NULL),(4203,3117,40846,12448,2,4018,'App\\Models\\Receipt',4018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',1485.00,NULL,NULL,1,'2021-11-16 17:08:30','2021-11-16 17:08:30',NULL),(4204,3117,40846,12448,2,4019,'App\\Models\\Receipt',4019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',1010.00,NULL,NULL,1,'2021-11-16 17:08:30','2021-11-16 17:08:30',NULL),(4205,3117,40846,12448,2,4020,'App\\Models\\Receipt',4020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',750.00,NULL,NULL,1,'2021-11-16 17:08:30','2021-11-16 17:08:30',NULL),(4206,3117,40846,12448,2,4021,'App\\Models\\Receipt',4021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',873.00,NULL,NULL,1,'2021-11-16 17:08:30','2021-11-16 17:08:30',NULL),(4207,3117,40846,12448,2,4022,'App\\Models\\Receipt',4022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',1520.00,NULL,NULL,1,'2021-11-16 17:08:30','2021-11-16 17:08:30',NULL),(4208,3117,40846,12448,3,4023,'App\\Models\\Receipt',4023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',6820.01,NULL,NULL,1,'2021-11-16 17:08:54','2021-11-16 17:08:54',NULL),(4209,3117,40846,12448,3,4024,'App\\Models\\Receipt',4024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',2985.20,NULL,NULL,1,'2021-11-16 17:08:54','2021-11-16 17:08:54',NULL),(4210,3117,40846,12448,3,4025,'App\\Models\\Receipt',4025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',4054.01,NULL,NULL,1,'2021-11-16 17:08:54','2021-11-16 17:08:54',NULL),(4211,3117,40846,12448,3,4026,'App\\Models\\Receipt',4026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',6158.74,NULL,NULL,1,'2021-11-16 17:08:54','2021-11-16 17:08:54',NULL),(4212,3117,40846,12448,3,4027,'App\\Models\\Receipt',4027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',10832.07,NULL,NULL,1,'2021-11-16 17:08:54','2021-11-16 17:08:54',NULL),(4213,3117,40846,12448,3,4028,'App\\Models\\Receipt',4028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',3100.58,NULL,NULL,1,'2021-11-16 17:08:54','2021-11-16 17:08:54',NULL),(4214,3117,40846,12448,3,4029,'App\\Models\\Receipt',4029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',8327.31,NULL,NULL,1,'2021-11-16 17:08:54','2021-11-16 17:08:54',NULL),(4215,3117,40846,12448,3,4030,'App\\Models\\Receipt',4030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',8152.54,NULL,NULL,1,'2021-11-16 17:08:54','2021-11-16 17:08:54',NULL),(4216,3117,40846,12448,3,4031,'App\\Models\\Receipt',4031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',14798.15,NULL,NULL,1,'2021-11-16 17:08:54','2021-11-16 17:08:54',NULL),(4217,3117,40846,12448,3,4032,'App\\Models\\Receipt',4032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',1375.00,NULL,NULL,1,'2021-11-16 17:08:54','2021-11-16 17:08:54',NULL),(4218,3117,40846,12448,3,4033,'App\\Models\\Receipt',4033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',6590.18,NULL,NULL,1,'2021-11-16 17:08:54','2021-11-16 17:08:54',NULL),(4219,3117,40846,12448,3,4034,'App\\Models\\Receipt',4034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',1545.96,NULL,NULL,1,'2021-11-16 17:08:55','2021-11-16 17:08:55',NULL),(4220,3117,40846,12448,3,4035,'App\\Models\\Receipt',4035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',3764.31,NULL,NULL,1,'2021-11-16 17:08:55','2021-11-16 17:08:55',NULL),(4221,3117,40846,12448,3,4036,'App\\Models\\Receipt',4036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',2715.41,NULL,NULL,1,'2021-11-16 17:08:55','2021-11-16 17:08:55',NULL);
INSERT INTO `balance_libro` VALUES (4222,3117,40846,12448,3,4037,'App\\Models\\Receipt',4037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',9247.51,NULL,NULL,1,'2021-11-16 17:08:55','2021-11-16 17:08:55',NULL),(4223,3117,40846,12448,3,4038,'App\\Models\\Receipt',4038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',9618.99,NULL,NULL,1,'2021-11-16 17:08:55','2021-11-16 17:08:55',NULL),(4224,3117,40846,12448,3,4039,'App\\Models\\Receipt',4039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',8567.13,NULL,NULL,1,'2021-11-16 17:08:55','2021-11-16 17:08:55',NULL),(4225,3117,40846,12448,3,4040,'App\\Models\\Receipt',4040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',3319.59,NULL,NULL,1,'2021-11-16 17:08:55','2021-11-16 17:08:55',NULL),(4226,3117,40846,12448,3,4041,'App\\Models\\Receipt',4041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',5499.44,NULL,NULL,1,'2021-11-16 17:08:55','2021-11-16 17:08:55',NULL),(4227,3117,40846,12448,3,4042,'App\\Models\\Receipt',4042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',7289.77,NULL,NULL,1,'2021-11-16 17:08:55','2021-11-16 17:08:55',NULL),(4228,3117,40846,12448,3,4043,'App\\Models\\Receipt',4043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',2484.65,NULL,NULL,1,'2021-11-16 17:08:55','2021-11-16 17:08:55',NULL),(4229,3117,40846,12448,3,4044,'App\\Models\\Receipt',4044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',12111.10,NULL,NULL,1,'2021-11-16 17:08:55','2021-11-16 17:08:55',NULL),(4230,3117,40846,12448,3,4045,'App\\Models\\Receipt',4045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',6707.12,NULL,NULL,1,'2021-11-16 17:08:55','2021-11-16 17:08:55',NULL),(4231,3117,40846,12448,3,4046,'App\\Models\\Receipt',4046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19','2021-09-19',30612.08,NULL,NULL,1,'2021-11-16 17:08:55','2021-11-16 17:08:55',NULL),(4232,3117,40846,12448,3,4047,'App\\Models\\Receipt',4047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',5503.41,NULL,NULL,1,'2021-11-16 17:08:55','2021-11-16 17:08:55',NULL),(4233,3117,40846,12448,3,4048,'App\\Models\\Receipt',4048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',9314.09,NULL,NULL,1,'2021-11-16 17:08:55','2021-11-16 17:08:55',NULL),(4234,3117,40846,12448,3,4049,'App\\Models\\Receipt',4049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',4594.88,NULL,NULL,1,'2021-11-16 17:08:55','2021-11-16 17:08:55',NULL),(4235,3117,40846,12448,3,4050,'App\\Models\\Receipt',4050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',4385.78,NULL,NULL,1,'2021-11-16 17:08:55','2021-11-16 17:08:55',NULL),(4236,3117,40846,12448,3,4051,'App\\Models\\Receipt',4051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',4901.96,NULL,NULL,1,'2021-11-16 17:08:55','2021-11-16 17:08:55',NULL),(4237,3117,40846,12448,3,4052,'App\\Models\\Receipt',4052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',20309.62,NULL,NULL,1,'2021-11-16 17:08:55','2021-11-16 17:08:55',NULL),(4238,3117,40846,12448,3,4053,'App\\Models\\Receipt',4053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',2237.01,NULL,NULL,1,'2021-11-16 17:08:55','2021-11-16 17:08:55',NULL),(4239,3117,40846,12448,3,4054,'App\\Models\\Receipt',4054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',9799.78,NULL,NULL,1,'2021-11-16 17:08:55','2021-11-16 17:08:55',NULL),(4240,3117,40846,12448,3,4055,'App\\Models\\Receipt',4055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-24','2021-09-24',14101.93,NULL,NULL,1,'2021-11-16 17:08:55','2021-11-16 17:08:55',NULL),(4241,3117,40846,12448,3,4056,'App\\Models\\Receipt',4056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-24','2021-09-24',7601.41,NULL,NULL,1,'2021-11-16 17:08:55','2021-11-16 17:08:55',NULL),(4242,3117,40846,12448,3,4057,'App\\Models\\Receipt',4057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',7692.11,NULL,NULL,1,'2021-11-16 17:08:55','2021-11-16 17:08:55',NULL);
INSERT INTO `balance_libro` VALUES (4243,3117,40846,12448,3,4058,'App\\Models\\Receipt',4058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',10332.97,NULL,NULL,1,'2021-11-16 17:08:55','2021-11-16 17:08:55',NULL),(4244,3117,40846,12448,3,4059,'App\\Models\\Receipt',4059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',4795.71,NULL,NULL,1,'2021-11-16 17:08:55','2021-11-16 17:08:55',NULL),(4245,3117,40846,12448,3,4060,'App\\Models\\Receipt',4060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',4507.75,NULL,NULL,1,'2021-11-16 17:08:56','2021-11-16 17:08:56',NULL),(4246,3117,40846,12448,3,4061,'App\\Models\\Receipt',4061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',360.00,NULL,NULL,1,'2021-11-16 17:08:56','2021-11-16 17:08:56',NULL),(4247,3117,40846,12448,3,4062,'App\\Models\\Receipt',4062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',3849.98,NULL,NULL,1,'2021-11-16 17:08:56','2021-11-16 17:08:56',NULL),(4248,3117,40846,12448,3,4063,'App\\Models\\Receipt',4063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',1260.32,NULL,NULL,1,'2021-11-16 17:08:56','2021-11-16 17:08:56',NULL),(4249,3117,40846,12448,3,4064,'App\\Models\\Receipt',4064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',228.02,NULL,NULL,1,'2021-11-16 17:08:56','2021-11-16 17:08:56',NULL),(4250,3117,40846,12448,3,4065,'App\\Models\\Receipt',4065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',718.57,NULL,NULL,1,'2021-11-16 17:08:56','2021-11-16 17:08:56',NULL),(4251,3117,40846,12448,3,4066,'App\\Models\\Receipt',4066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',9337.58,NULL,NULL,1,'2021-11-16 17:08:56','2021-11-16 17:08:56',NULL),(4252,3117,40846,12448,3,4067,'App\\Models\\Receipt',4067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',228.02,NULL,NULL,1,'2021-11-16 17:08:56','2021-11-16 17:08:56',NULL),(4253,3117,40846,12448,3,4068,'App\\Models\\Receipt',4068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',1829.45,NULL,NULL,1,'2021-11-16 17:08:56','2021-11-16 17:08:56',NULL),(4254,3117,40779,4576,2,4069,'App\\Models\\Receipt',4069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',1490.00,NULL,NULL,1,'2021-12-03 15:33:04','2021-12-03 15:33:04',NULL),(4255,3117,40779,4576,2,4070,'App\\Models\\Receipt',4070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',4950.00,NULL,NULL,1,'2021-12-03 15:33:05','2021-12-03 15:33:05',NULL),(4256,3117,40779,4576,2,4071,'App\\Models\\Receipt',4071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',4890.00,NULL,NULL,1,'2021-12-03 15:33:05','2021-12-03 15:33:05',NULL),(4257,3117,40779,4576,2,4072,'App\\Models\\Receipt',4072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',4760.00,NULL,NULL,1,'2021-12-03 15:33:05','2021-12-03 15:33:05',NULL),(4258,3117,40779,4576,2,4073,'App\\Models\\Receipt',4073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',4550.00,NULL,NULL,1,'2021-12-03 15:33:05','2021-12-03 15:33:05',NULL),(4259,3117,40779,4576,2,4074,'App\\Models\\Receipt',4074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',4280.00,NULL,NULL,1,'2021-12-03 15:33:05','2021-12-03 15:33:05',NULL),(4260,3117,40779,4576,2,4075,'App\\Models\\Receipt',4075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',4100.00,NULL,NULL,1,'2021-12-03 15:33:05','2021-12-03 15:33:05',NULL),(4261,3117,40779,4576,2,4076,'App\\Models\\Receipt',4076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',4100.00,NULL,NULL,1,'2021-12-03 15:33:05','2021-12-03 15:33:05',NULL),(4262,3117,40779,4576,2,4077,'App\\Models\\Receipt',4077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',4570.00,NULL,NULL,1,'2021-12-03 15:33:05','2021-12-03 15:33:05',NULL),(4263,3117,40779,4576,2,4078,'App\\Models\\Receipt',4078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',4920.00,NULL,NULL,1,'2021-12-03 15:33:05','2021-12-03 15:33:05',NULL);
INSERT INTO `balance_libro` VALUES (4264,3117,40779,4576,2,4079,'App\\Models\\Receipt',4079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',4130.00,NULL,NULL,1,'2021-12-03 15:33:05','2021-12-03 15:33:05',NULL),(4265,3117,40779,4576,2,4080,'App\\Models\\Receipt',4080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',4950.00,NULL,NULL,1,'2021-12-03 15:33:05','2021-12-03 15:33:05',NULL),(4266,3117,40779,4576,2,4081,'App\\Models\\Receipt',4081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',1490.00,NULL,NULL,1,'2021-12-03 15:33:05','2021-12-03 15:33:05',NULL),(4267,3117,40779,4576,2,4082,'App\\Models\\Receipt',4082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',4820.00,NULL,NULL,1,'2021-12-03 15:33:05','2021-12-03 15:33:05',NULL),(4268,3117,40779,4576,2,4083,'App\\Models\\Receipt',4083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',4660.00,NULL,NULL,1,'2021-12-03 15:33:05','2021-12-03 15:33:05',NULL),(4269,3117,40779,4576,2,4084,'App\\Models\\Receipt',4084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',4720.00,NULL,NULL,1,'2021-12-03 15:33:05','2021-12-03 15:33:05',NULL),(4270,3117,40779,4576,2,4085,'App\\Models\\Receipt',4085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',4440.00,NULL,NULL,1,'2021-12-03 15:33:05','2021-12-03 15:33:05',NULL),(4271,3117,40779,4576,2,4086,'App\\Models\\Receipt',4086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',4270.00,NULL,NULL,1,'2021-12-03 15:33:05','2021-12-03 15:33:05',NULL),(4272,3117,40779,4576,2,4087,'App\\Models\\Receipt',4087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-07','2021-11-07',4510.00,NULL,NULL,1,'2021-12-03 15:33:05','2021-12-03 15:33:05',NULL),(4273,3117,40779,4576,2,4088,'App\\Models\\Receipt',4088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-07','2021-11-07',4720.00,NULL,NULL,1,'2021-12-03 15:33:05','2021-12-03 15:33:05',NULL),(4274,3117,40779,4576,2,4089,'App\\Models\\Receipt',4089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-07','2021-11-07',4680.00,NULL,NULL,1,'2021-12-03 15:33:05','2021-12-03 15:33:05',NULL),(4275,3117,40779,4576,2,4090,'App\\Models\\Receipt',4090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-07','2021-11-07',4330.00,NULL,NULL,1,'2021-12-03 15:33:05','2021-12-03 15:33:05',NULL),(4276,3117,40779,4576,2,4091,'App\\Models\\Receipt',4091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',1490.00,NULL,NULL,1,'2021-12-03 15:33:06','2021-12-03 15:33:06',NULL),(4277,3117,40779,4576,2,4092,'App\\Models\\Receipt',4092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',1490.00,NULL,NULL,1,'2021-12-03 15:33:06','2021-12-03 15:33:06',NULL),(4278,3117,40779,4576,2,4093,'App\\Models\\Receipt',4093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',4990.00,NULL,NULL,1,'2021-12-03 15:33:06','2021-12-03 15:33:06',NULL),(4279,3117,40779,4576,2,4094,'App\\Models\\Receipt',4094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',4870.00,NULL,NULL,1,'2021-12-03 15:33:06','2021-12-03 15:33:06',NULL),(4280,3117,40779,4576,2,4095,'App\\Models\\Receipt',4095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',4210.00,NULL,NULL,1,'2021-12-03 15:33:06','2021-12-03 15:33:06',NULL),(4281,3117,40779,4576,2,4096,'App\\Models\\Receipt',4096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',4570.00,NULL,NULL,1,'2021-12-03 15:33:06','2021-12-03 15:33:06',NULL),(4282,3117,40779,4576,2,4097,'App\\Models\\Receipt',4097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',4694.00,NULL,NULL,1,'2021-12-03 15:33:06','2021-12-03 15:33:06',NULL),(4283,3117,40779,4576,2,4098,'App\\Models\\Receipt',4098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-09','2021-11-09',1490.00,NULL,NULL,1,'2021-12-03 15:33:06','2021-12-03 15:33:06',NULL),(4284,3117,40779,4576,2,4099,'App\\Models\\Receipt',4099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-09','2021-11-09',3840.00,NULL,NULL,1,'2021-12-03 15:33:06','2021-12-03 15:33:06',NULL);
INSERT INTO `balance_libro` VALUES (4285,3117,40779,4576,2,4100,'App\\Models\\Receipt',4100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',210.00,NULL,NULL,1,'2021-12-03 15:33:06','2021-12-03 15:33:06',NULL),(4286,3117,40779,4576,2,4101,'App\\Models\\Receipt',4101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',4950.00,NULL,NULL,1,'2021-12-03 15:33:06','2021-12-03 15:33:06',NULL),(4287,3117,40779,4576,2,4102,'App\\Models\\Receipt',4102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',4820.00,NULL,NULL,1,'2021-12-03 15:33:06','2021-12-03 15:33:06',NULL),(4288,3117,40779,4576,2,4103,'App\\Models\\Receipt',4103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',4280.00,NULL,NULL,1,'2021-12-03 15:33:06','2021-12-03 15:33:06',NULL),(4289,3117,40779,4576,2,4104,'App\\Models\\Receipt',4104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',4550.00,NULL,NULL,1,'2021-12-03 15:33:06','2021-12-03 15:33:06',NULL),(4290,3117,40779,4576,2,4105,'App\\Models\\Receipt',4105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',4440.00,NULL,NULL,1,'2021-12-03 15:33:06','2021-12-03 15:33:06',NULL),(4291,3117,40779,4576,2,4106,'App\\Models\\Receipt',4106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',4370.00,NULL,NULL,1,'2021-12-03 15:33:06','2021-12-03 15:33:06',NULL),(4292,3117,40779,4576,2,4107,'App\\Models\\Receipt',4107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',4050.00,NULL,NULL,1,'2021-12-03 15:33:06','2021-12-03 15:33:06',NULL),(4293,3117,40779,4576,2,4108,'App\\Models\\Receipt',4108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',4100.00,NULL,NULL,1,'2021-12-03 15:33:06','2021-12-03 15:33:06',NULL),(4294,3117,40779,4576,2,4109,'App\\Models\\Receipt',4109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',4210.00,NULL,NULL,1,'2021-12-03 15:33:06','2021-12-03 15:33:06',NULL),(4295,3117,40779,4576,2,4110,'App\\Models\\Receipt',4110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',4610.00,NULL,NULL,1,'2021-12-03 15:33:06','2021-12-03 15:33:06',NULL),(4296,3117,40779,4576,2,4111,'App\\Models\\Receipt',4111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-13','2021-11-13',4710.00,NULL,NULL,1,'2021-12-03 15:33:06','2021-12-03 15:33:06',NULL),(4297,3117,40779,4576,2,4112,'App\\Models\\Receipt',4112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-13','2021-11-13',4200.00,NULL,NULL,1,'2021-12-03 15:33:06','2021-12-03 15:33:06',NULL),(4298,3117,40779,4576,2,4113,'App\\Models\\Receipt',4113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-13','2021-11-13',4390.00,NULL,NULL,1,'2021-12-03 15:33:06','2021-12-03 15:33:06',NULL),(4299,3117,40779,4576,2,4114,'App\\Models\\Receipt',4114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-13','2021-11-13',4825.00,NULL,NULL,1,'2021-12-03 15:33:06','2021-12-03 15:33:06',NULL),(4300,3117,40779,4576,2,4115,'App\\Models\\Receipt',4115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-13','2021-11-13',4150.00,NULL,NULL,1,'2021-12-03 15:33:06','2021-12-03 15:33:06',NULL),(4301,3117,40779,4576,2,4116,'App\\Models\\Receipt',4116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-13','2021-11-13',4710.00,NULL,NULL,1,'2021-12-03 15:33:07','2021-12-03 15:33:07',NULL),(4302,3117,40779,4576,2,4117,'App\\Models\\Receipt',4117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-14','2021-11-14',4295.00,NULL,NULL,1,'2021-12-03 15:33:07','2021-12-03 15:33:07',NULL),(4303,3117,40779,4576,2,4118,'App\\Models\\Receipt',4118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-14','2021-11-14',4050.00,NULL,NULL,1,'2021-12-03 15:33:07','2021-12-03 15:33:07',NULL),(4304,3117,40779,4576,2,4119,'App\\Models\\Receipt',4119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-14','2021-11-14',4280.00,NULL,NULL,1,'2021-12-03 15:33:07','2021-12-03 15:33:07',NULL),(4305,3117,40779,4576,2,4120,'App\\Models\\Receipt',4120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-14','2021-11-14',4960.00,NULL,NULL,1,'2021-12-03 15:33:07','2021-12-03 15:33:07',NULL);
INSERT INTO `balance_libro` VALUES (4306,3117,40779,4576,2,4121,'App\\Models\\Receipt',4121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',4880.00,NULL,NULL,1,'2021-12-03 15:33:07','2021-12-03 15:33:07',NULL),(4307,3117,40779,4576,2,4122,'App\\Models\\Receipt',4122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',4710.00,NULL,NULL,1,'2021-12-03 15:33:07','2021-12-03 15:33:07',NULL),(4308,3117,40779,4576,2,4123,'App\\Models\\Receipt',4123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',4210.00,NULL,NULL,1,'2021-12-03 15:33:07','2021-12-03 15:33:07',NULL),(4309,3117,40779,4576,2,4124,'App\\Models\\Receipt',4124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',3998.00,NULL,NULL,1,'2021-12-03 15:33:07','2021-12-03 15:33:07',NULL),(4310,3117,40779,4576,2,4125,'App\\Models\\Receipt',4125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',3997.00,NULL,NULL,1,'2021-12-03 15:33:07','2021-12-03 15:33:07',NULL),(4311,3117,40779,4576,2,4126,'App\\Models\\Receipt',4126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',4950.00,NULL,NULL,1,'2021-12-03 15:33:07','2021-12-03 15:33:07',NULL),(4312,3117,40779,4576,2,4127,'App\\Models\\Receipt',4127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',4820.00,NULL,NULL,1,'2021-12-03 15:33:07','2021-12-03 15:33:07',NULL),(4313,3117,40779,4576,2,4128,'App\\Models\\Receipt',4128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',4400.00,NULL,NULL,1,'2021-12-03 15:33:07','2021-12-03 15:33:07',NULL),(4314,3117,40779,4576,2,4129,'App\\Models\\Receipt',4129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',4710.00,NULL,NULL,1,'2021-12-03 15:33:07','2021-12-03 15:33:07',NULL),(4315,3117,40779,4576,2,4130,'App\\Models\\Receipt',4130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',4310.00,NULL,NULL,1,'2021-12-03 15:33:07','2021-12-03 15:33:07',NULL),(4316,3117,40779,4576,2,4131,'App\\Models\\Receipt',4131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',4270.00,NULL,NULL,1,'2021-12-03 15:33:07','2021-12-03 15:33:07',NULL),(4317,3117,40779,4576,2,4132,'App\\Models\\Receipt',4132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',4100.00,NULL,NULL,1,'2021-12-03 15:33:07','2021-12-03 15:33:07',NULL),(4318,3117,40779,4576,2,4133,'App\\Models\\Receipt',4133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',4210.00,NULL,NULL,1,'2021-12-03 15:33:07','2021-12-03 15:33:07',NULL),(4319,3117,40779,4576,2,4134,'App\\Models\\Receipt',4134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',4330.00,NULL,NULL,1,'2021-12-03 15:33:07','2021-12-03 15:33:07',NULL),(4320,3117,40779,4576,2,4135,'App\\Models\\Receipt',4135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-20','2021-11-20',4100.00,NULL,NULL,1,'2021-12-03 15:33:07','2021-12-03 15:33:07',NULL),(4321,3117,40779,4576,2,4136,'App\\Models\\Receipt',4136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-20','2021-11-20',4710.00,NULL,NULL,1,'2021-12-03 15:33:07','2021-12-03 15:33:07',NULL),(4322,3117,40779,4576,2,4137,'App\\Models\\Receipt',4137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-20','2021-11-20',4050.00,NULL,NULL,1,'2021-12-03 15:33:07','2021-12-03 15:33:07',NULL),(4323,3117,40779,4576,2,4138,'App\\Models\\Receipt',4138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-20','2021-11-20',4200.00,NULL,NULL,1,'2021-12-03 15:33:07','2021-12-03 15:33:07',NULL),(4324,3117,40779,4576,2,4139,'App\\Models\\Receipt',4139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-20','2021-11-20',4720.00,NULL,NULL,1,'2021-12-03 15:33:07','2021-12-03 15:33:07',NULL),(4325,3117,40779,4576,2,4140,'App\\Models\\Receipt',4140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-21','2021-11-21',4090.00,NULL,NULL,1,'2021-12-03 15:33:07','2021-12-03 15:33:07',NULL),(4326,3117,40779,4576,2,4141,'App\\Models\\Receipt',4141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-21','2021-11-21',4380.00,NULL,NULL,1,'2021-12-03 15:33:07','2021-12-03 15:33:07',NULL);
INSERT INTO `balance_libro` VALUES (4327,3117,40779,4576,2,4142,'App\\Models\\Receipt',4142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-21','2021-11-21',3105.00,NULL,NULL,1,'2021-12-03 15:33:07','2021-12-03 15:33:07',NULL),(4328,3117,40779,4576,2,4143,'App\\Models\\Receipt',4143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',4950.00,NULL,NULL,1,'2021-12-03 15:33:07','2021-12-03 15:33:07',NULL),(4329,3117,40779,4576,2,4144,'App\\Models\\Receipt',4144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',4880.00,NULL,NULL,1,'2021-12-03 15:33:07','2021-12-03 15:33:07',NULL),(4330,3117,40779,4576,2,4145,'App\\Models\\Receipt',4145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',4720.00,NULL,NULL,1,'2021-12-03 15:33:08','2021-12-03 15:33:08',NULL),(4331,3117,40779,4576,2,4146,'App\\Models\\Receipt',4146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',4690.00,NULL,NULL,1,'2021-12-03 15:33:08','2021-12-03 15:33:08',NULL),(4332,3117,40779,4576,2,4147,'App\\Models\\Receipt',4147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',4920.00,NULL,NULL,1,'2021-12-03 15:33:08','2021-12-03 15:33:08',NULL),(4333,3117,40779,4576,2,4148,'App\\Models\\Receipt',4148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',4440.00,NULL,NULL,1,'2021-12-03 15:33:08','2021-12-03 15:33:08',NULL),(4334,3117,40779,4576,2,4149,'App\\Models\\Receipt',4149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',4180.00,NULL,NULL,1,'2021-12-03 15:33:08','2021-12-03 15:33:08',NULL),(4335,3117,40779,4576,2,4150,'App\\Models\\Receipt',4150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',4810.00,NULL,NULL,1,'2021-12-03 15:33:08','2021-12-03 15:33:08',NULL),(4336,3117,40779,4576,2,4151,'App\\Models\\Receipt',4151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',4690.00,NULL,NULL,1,'2021-12-03 15:33:08','2021-12-03 15:33:08',NULL),(4337,3117,40779,4576,2,4152,'App\\Models\\Receipt',4152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',4100.00,NULL,NULL,1,'2021-12-03 15:33:08','2021-12-03 15:33:08',NULL),(4338,3117,40779,4576,2,4153,'App\\Models\\Receipt',4153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',4320.00,NULL,NULL,1,'2021-12-03 15:33:08','2021-12-03 15:33:08',NULL),(4339,3117,40779,4576,2,4154,'App\\Models\\Receipt',4154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',4670.00,NULL,NULL,1,'2021-12-03 15:33:08','2021-12-03 15:33:08',NULL),(4340,3117,40779,4576,2,4155,'App\\Models\\Receipt',4155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',4640.00,NULL,NULL,1,'2021-12-03 15:33:08','2021-12-03 15:33:08',NULL),(4341,3117,40779,4576,2,4156,'App\\Models\\Receipt',4156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',4710.00,NULL,NULL,1,'2021-12-03 15:33:08','2021-12-03 15:33:08',NULL),(4342,3117,40779,4576,2,4157,'App\\Models\\Receipt',4157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',4280.00,NULL,NULL,1,'2021-12-03 15:33:08','2021-12-03 15:33:08',NULL),(4343,3117,40779,4576,2,4158,'App\\Models\\Receipt',4158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-28','2021-11-28',4440.00,NULL,NULL,1,'2021-12-03 15:33:08','2021-12-03 15:33:08',NULL),(4344,3117,40779,4576,2,4159,'App\\Models\\Receipt',4159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-28','2021-11-28',4500.00,NULL,NULL,1,'2021-12-03 15:33:08','2021-12-03 15:33:08',NULL),(4345,3117,40779,4576,2,4160,'App\\Models\\Receipt',4160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-28','2021-11-28',4680.00,NULL,NULL,1,'2021-12-03 15:33:08','2021-12-03 15:33:08',NULL),(4346,3117,40779,4576,2,4161,'App\\Models\\Receipt',4161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-28','2021-11-28',4320.00,NULL,NULL,1,'2021-12-03 15:33:08','2021-12-03 15:33:08',NULL),(4347,3117,40779,4576,2,4162,'App\\Models\\Receipt',4162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-28','2021-11-28',4448.00,NULL,NULL,1,'2021-12-03 15:33:08','2021-12-03 15:33:08',NULL);
INSERT INTO `balance_libro` VALUES (4348,3117,40731,3057,2,4163,'App\\Models\\Receipt',4163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',13099.00,NULL,NULL,1,'2021-12-06 15:02:02','2021-12-06 15:02:02',NULL),(4349,3117,40731,3057,2,4164,'App\\Models\\Receipt',4164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',12998.00,NULL,NULL,1,'2021-12-06 15:02:02','2021-12-06 15:02:02',NULL),(4350,3117,40731,3057,2,4165,'App\\Models\\Receipt',4165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-20','2021-11-20',12440.00,NULL,NULL,1,'2021-12-06 15:02:02','2021-12-06 15:02:02',NULL),(4351,3117,40731,3057,2,4166,'App\\Models\\Receipt',4166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-20','2021-11-20',8767.00,NULL,NULL,1,'2021-12-06 15:02:02','2021-12-06 15:02:02',NULL),(4352,3117,40731,3057,2,4167,'App\\Models\\Receipt',4167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-20','2021-11-20',7720.00,NULL,NULL,1,'2021-12-06 15:02:02','2021-12-06 15:02:02',NULL),(4353,3117,40731,3057,2,4168,'App\\Models\\Receipt',4168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-20','2021-11-20',8766.00,NULL,NULL,1,'2021-12-06 15:02:02','2021-12-06 15:02:02',NULL),(4354,3117,40731,3057,2,4169,'App\\Models\\Receipt',4169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-20','2021-11-20',10075.00,NULL,NULL,1,'2021-12-06 15:02:02','2021-12-06 15:02:02',NULL),(4355,3117,40731,3057,2,4170,'App\\Models\\Receipt',4170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-20','2021-11-20',11526.00,NULL,NULL,1,'2021-12-06 15:02:02','2021-12-06 15:02:02',NULL),(4356,3117,40731,3057,2,4171,'App\\Models\\Receipt',4171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-22','2021-11-22',7572.00,NULL,NULL,1,'2021-12-06 15:02:02','2021-12-06 15:02:02',NULL),(4357,3117,40731,3057,2,4172,'App\\Models\\Receipt',4172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-22','2021-11-22',11391.00,NULL,NULL,1,'2021-12-06 15:02:02','2021-12-06 15:02:02',NULL),(4358,3117,40731,3057,2,4173,'App\\Models\\Receipt',4173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-22','2021-11-22',11000.00,NULL,NULL,1,'2021-12-06 15:02:02','2021-12-06 15:02:02',NULL),(4359,3117,40731,3057,2,4174,'App\\Models\\Receipt',4174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-22','2021-11-22',8840.00,NULL,NULL,1,'2021-12-06 15:02:02','2021-12-06 15:02:02',NULL),(4360,3117,40731,3057,2,4175,'App\\Models\\Receipt',4175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-22','2021-11-22',12554.00,NULL,NULL,1,'2021-12-06 15:02:02','2021-12-06 15:02:02',NULL),(4361,3117,40731,3057,2,4176,'App\\Models\\Receipt',4176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-22','2021-11-22',3287.00,NULL,NULL,1,'2021-12-06 15:02:02','2021-12-06 15:02:02',NULL),(4362,3117,40731,3057,2,4177,'App\\Models\\Receipt',4177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',11479.00,NULL,NULL,1,'2021-12-06 15:02:03','2021-12-06 15:02:03',NULL),(4363,3117,40731,3057,2,4178,'App\\Models\\Receipt',4178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',12856.00,NULL,NULL,1,'2021-12-06 15:02:03','2021-12-06 15:02:03',NULL),(4364,3117,40731,3057,2,4179,'App\\Models\\Receipt',4179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',8321.00,NULL,NULL,1,'2021-12-06 15:02:03','2021-12-06 15:02:03',NULL),(4365,3117,40731,3057,2,4180,'App\\Models\\Receipt',4180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',13037.00,NULL,NULL,1,'2021-12-06 15:02:03','2021-12-06 15:02:03',NULL),(4366,3117,40731,3057,2,4181,'App\\Models\\Receipt',4181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',11825.00,NULL,NULL,1,'2021-12-06 15:02:03','2021-12-06 15:02:03',NULL),(4367,3117,40731,3057,2,4182,'App\\Models\\Receipt',4182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',12700.00,NULL,NULL,1,'2021-12-06 15:02:03','2021-12-06 15:02:03',NULL),(4368,3117,40731,3057,2,4183,'App\\Models\\Receipt',4183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',12699.00,NULL,NULL,1,'2021-12-06 15:02:03','2021-12-06 15:02:03',NULL);
INSERT INTO `balance_libro` VALUES (4369,3117,40731,3057,2,4184,'App\\Models\\Receipt',4184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',12888.00,NULL,NULL,1,'2021-12-06 15:02:03','2021-12-06 15:02:03',NULL),(4370,3117,40731,3057,2,4185,'App\\Models\\Receipt',4185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',13080.00,NULL,NULL,1,'2021-12-06 15:02:03','2021-12-06 15:02:03',NULL),(4371,3117,40731,3057,2,4186,'App\\Models\\Receipt',4186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',12693.00,NULL,NULL,1,'2021-12-06 15:02:03','2021-12-06 15:02:03',NULL),(4372,3117,40731,3057,2,4187,'App\\Models\\Receipt',4187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',12987.00,NULL,NULL,1,'2021-12-06 15:02:03','2021-12-06 15:02:03',NULL),(4373,3117,40731,3057,2,4188,'App\\Models\\Receipt',4188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',13066.00,NULL,NULL,1,'2021-12-06 15:02:03','2021-12-06 15:02:03',NULL),(4374,3117,40731,3057,2,4189,'App\\Models\\Receipt',4189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',13099.00,NULL,NULL,1,'2021-12-06 15:02:03','2021-12-06 15:02:03',NULL),(4375,3117,40731,3057,2,4190,'App\\Models\\Receipt',4190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',13000.00,NULL,NULL,1,'2021-12-06 15:02:04','2021-12-06 15:02:04',NULL),(4376,3117,40731,3057,2,4191,'App\\Models\\Receipt',4191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',9768.00,NULL,NULL,1,'2021-12-06 15:02:04','2021-12-06 15:02:04',NULL),(4377,3117,40731,3057,2,4192,'App\\Models\\Receipt',4192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',12300.00,NULL,NULL,1,'2021-12-06 15:02:04','2021-12-06 15:02:04',NULL),(4378,3117,40731,3057,2,4193,'App\\Models\\Receipt',4193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',12333.00,NULL,NULL,1,'2021-12-06 15:02:04','2021-12-06 15:02:04',NULL),(4379,3117,40731,3057,3,4194,'App\\Models\\Receipt',4194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',120798.00,NULL,NULL,1,'2021-12-06 15:02:43','2021-12-06 15:02:43',NULL),(4380,3117,40731,3057,3,4195,'App\\Models\\Receipt',4195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',1480.79,NULL,NULL,1,'2021-12-06 15:02:43','2021-12-06 15:02:43',NULL),(4381,3117,40731,3057,3,4196,'App\\Models\\Receipt',4196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',60.00,NULL,NULL,1,'2021-12-06 15:02:43','2021-12-06 15:02:43',NULL),(4382,3117,40731,3057,3,4197,'App\\Models\\Receipt',4197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',59000.00,NULL,NULL,1,'2021-12-06 15:02:43','2021-12-06 15:02:43',NULL),(4383,3117,40731,3057,3,4198,'App\\Models\\Receipt',4198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',9358.72,NULL,NULL,1,'2021-12-06 15:02:43','2021-12-06 15:02:43',NULL),(4384,3117,40731,3057,3,4199,'App\\Models\\Receipt',4199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',3562.97,NULL,NULL,1,'2021-12-06 15:02:43','2021-12-06 15:02:43',NULL),(4385,3117,40731,3057,3,4200,'App\\Models\\Receipt',4200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',1446.14,NULL,NULL,1,'2021-12-06 15:02:43','2021-12-06 15:02:43',NULL),(4386,3117,40731,3057,3,4201,'App\\Models\\Receipt',4201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',9523.24,NULL,NULL,1,'2021-12-06 15:02:43','2021-12-06 15:02:43',NULL),(4387,3117,40731,3057,3,4202,'App\\Models\\Receipt',4202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',644.00,NULL,NULL,1,'2021-12-06 15:02:43','2021-12-06 15:02:43',NULL),(4388,3117,40731,3057,3,4203,'App\\Models\\Receipt',4203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',6587.71,NULL,NULL,1,'2021-12-06 15:02:43','2021-12-06 15:02:43',NULL),(4389,3117,40731,3057,3,4204,'App\\Models\\Receipt',4204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',2289.01,NULL,NULL,1,'2021-12-06 15:02:44','2021-12-06 15:02:44',NULL);
INSERT INTO `balance_libro` VALUES (4390,3117,40731,3057,3,4205,'App\\Models\\Receipt',4205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-13','2021-11-13',60.00,NULL,NULL,1,'2021-12-06 15:02:44','2021-12-06 15:02:44',NULL),(4391,3117,40731,3057,3,4206,'App\\Models\\Receipt',4206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-13','2021-11-13',2313.88,NULL,NULL,1,'2021-12-06 15:02:44','2021-12-06 15:02:44',NULL),(4392,3117,40731,3057,3,4207,'App\\Models\\Receipt',4207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-13','2021-11-13',7952.40,NULL,NULL,1,'2021-12-06 15:02:44','2021-12-06 15:02:44',NULL),(4393,3117,40731,3057,3,4208,'App\\Models\\Receipt',4208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-13','2021-11-13',16028.15,NULL,NULL,1,'2021-12-06 15:02:44','2021-12-06 15:02:44',NULL),(4394,3117,40731,3057,3,4209,'App\\Models\\Receipt',4209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',1814.66,NULL,NULL,1,'2021-12-06 15:02:44','2021-12-06 15:02:44',NULL),(4395,3117,40731,3057,3,4210,'App\\Models\\Receipt',4210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-16','2021-11-16',60.00,NULL,NULL,1,'2021-12-06 15:02:44','2021-12-06 15:02:44',NULL),(4396,3117,40731,3057,3,4211,'App\\Models\\Receipt',4211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-16','2021-11-16',561.08,NULL,NULL,1,'2021-12-06 15:02:44','2021-12-06 15:02:44',NULL),(4397,3117,40731,3057,3,4212,'App\\Models\\Receipt',4212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-16','2021-11-16',533.97,NULL,NULL,1,'2021-12-06 15:02:44','2021-12-06 15:02:44',NULL),(4398,3117,40731,3057,3,4213,'App\\Models\\Receipt',4213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',14555.19,NULL,NULL,1,'2021-12-06 15:02:44','2021-12-06 15:02:44',NULL),(4399,3117,40731,3057,3,4214,'App\\Models\\Receipt',4214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',580.72,NULL,NULL,1,'2021-12-06 15:02:44','2021-12-06 15:02:44',NULL),(4400,3117,40731,3057,3,4215,'App\\Models\\Receipt',4215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',4552.01,NULL,NULL,1,'2021-12-06 15:02:44','2021-12-06 15:02:44',NULL),(4401,3117,40731,3057,3,4216,'App\\Models\\Receipt',4216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',3744.32,NULL,NULL,1,'2021-12-06 15:02:44','2021-12-06 15:02:44',NULL),(4402,3117,40731,3057,3,4217,'App\\Models\\Receipt',4217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',994.26,NULL,NULL,1,'2021-12-06 15:02:44','2021-12-06 15:02:44',NULL),(4403,3117,40731,3057,3,4218,'App\\Models\\Receipt',4218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-24','2021-11-24',6901.55,NULL,NULL,1,'2021-12-06 15:02:44','2021-12-06 15:02:44',NULL),(4404,3117,40731,3057,3,4219,'App\\Models\\Receipt',4219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-24','2021-11-24',3541.86,NULL,NULL,1,'2021-12-06 15:02:44','2021-12-06 15:02:44',NULL),(4405,3117,40731,3057,3,4220,'App\\Models\\Receipt',4220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',321.94,NULL,NULL,1,'2021-12-06 15:02:44','2021-12-06 15:02:44',NULL),(4406,3117,40731,3057,3,4221,'App\\Models\\Receipt',4221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',7530.29,NULL,NULL,1,'2021-12-06 15:02:44','2021-12-06 15:02:44',NULL),(4407,3117,40731,3057,3,4222,'App\\Models\\Receipt',4222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',60.00,NULL,NULL,1,'2021-12-06 15:02:45','2021-12-06 15:02:45',NULL),(4408,3117,40731,3057,3,4223,'App\\Models\\Receipt',4223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',60.00,NULL,NULL,1,'2021-12-06 15:02:45','2021-12-06 15:02:45',NULL),(4409,3117,40731,3057,3,4224,'App\\Models\\Receipt',4224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',7386.29,NULL,NULL,1,'2021-12-06 15:02:45','2021-12-06 15:02:45',NULL),(4410,3117,40731,3057,3,4225,'App\\Models\\Receipt',4225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',4900.66,NULL,NULL,1,'2021-12-06 15:02:45','2021-12-06 15:02:45',NULL);
INSERT INTO `balance_libro` VALUES (4411,3117,40731,3057,3,4226,'App\\Models\\Receipt',4226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',5334.60,NULL,NULL,1,'2021-12-06 15:02:45','2021-12-06 15:02:45',NULL),(4412,3117,40731,3057,3,4227,'App\\Models\\Receipt',4227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',1420.76,NULL,NULL,1,'2021-12-06 15:02:45','2021-12-06 15:02:45',NULL),(4413,3117,40736,1547,2,4228,'App\\Models\\Receipt',4228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',21120.00,NULL,NULL,1,'2021-12-10 14:54:41','2021-12-10 14:54:41',NULL),(4414,3117,40736,1547,2,4229,'App\\Models\\Receipt',4229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',60952.00,NULL,NULL,1,'2021-12-10 14:54:41','2021-12-10 14:54:41',NULL),(4415,3117,40736,1547,3,4230,'App\\Models\\Receipt',4230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',87958.00,NULL,NULL,1,'2021-12-10 14:54:56','2021-12-10 14:54:56',NULL),(4416,3117,40736,1547,3,4231,'App\\Models\\Receipt',4231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',5261.00,NULL,NULL,1,'2021-12-10 14:54:56','2021-12-10 14:54:56',NULL),(4417,3117,40736,1547,3,4232,'App\\Models\\Receipt',4232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',21658.00,NULL,NULL,1,'2021-12-10 14:54:56','2021-12-10 14:54:56',NULL),(4418,3117,40719,13,2,4233,'App\\Models\\Receipt',4233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',10572.00,NULL,NULL,1,'2021-12-13 07:55:12','2021-12-13 07:55:12',NULL),(4419,3117,40719,13,2,4234,'App\\Models\\Receipt',4234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',4347.00,NULL,NULL,1,'2021-12-13 07:55:12','2021-12-13 07:55:12',NULL),(4420,3117,40719,13,2,4235,'App\\Models\\Receipt',4235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',25600.00,NULL,NULL,1,'2021-12-13 07:55:12','2021-12-13 07:55:12',NULL),(4421,3117,40719,13,2,4236,'App\\Models\\Receipt',4236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',15000.00,NULL,NULL,1,'2021-12-13 07:55:12','2021-12-13 07:55:12',NULL),(4422,3117,40719,13,2,4237,'App\\Models\\Receipt',4237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',12000.00,NULL,NULL,1,'2021-12-13 07:55:12','2021-12-13 07:55:12',NULL),(4423,3117,40719,13,2,4238,'App\\Models\\Receipt',4238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',13000.00,NULL,NULL,1,'2021-12-13 07:55:12','2021-12-13 07:55:12',NULL),(4424,3117,40719,13,2,4239,'App\\Models\\Receipt',4239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',10000.00,NULL,NULL,1,'2021-12-13 07:55:12','2021-12-13 07:55:12',NULL),(4425,3117,40719,13,2,4240,'App\\Models\\Receipt',4240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',11000.00,NULL,NULL,1,'2021-12-13 07:55:12','2021-12-13 07:55:12',NULL),(4426,3117,40719,13,2,4241,'App\\Models\\Receipt',4241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',12000.00,NULL,NULL,1,'2021-12-13 07:55:12','2021-12-13 07:55:12',NULL),(4427,3117,40719,13,2,4242,'App\\Models\\Receipt',4242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',13000.00,NULL,NULL,1,'2021-12-13 07:55:12','2021-12-13 07:55:12',NULL),(4428,3117,40719,13,2,4243,'App\\Models\\Receipt',4243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',32000.00,NULL,NULL,1,'2021-12-13 07:55:12','2021-12-13 07:55:12',NULL),(4429,3117,40719,13,2,4244,'App\\Models\\Receipt',4244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',26500.00,NULL,NULL,1,'2021-12-13 07:55:12','2021-12-13 07:55:12',NULL),(4430,3117,40719,13,2,4245,'App\\Models\\Receipt',4245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',21500.00,NULL,NULL,1,'2021-12-13 07:55:12','2021-12-13 07:55:12',NULL),(4431,3117,40719,13,3,4246,'App\\Models\\Receipt',4246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',7300.00,NULL,NULL,1,'2021-12-13 07:55:31','2021-12-13 07:55:31',NULL);
INSERT INTO `balance_libro` VALUES (4432,3117,40719,13,3,4247,'App\\Models\\Receipt',4247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',10650.00,NULL,NULL,1,'2021-12-13 07:55:31','2021-12-13 07:55:31',NULL),(4433,3117,40719,13,3,4248,'App\\Models\\Receipt',4248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',18999.00,NULL,NULL,1,'2021-12-13 07:55:32','2021-12-13 07:55:32',NULL),(4434,3117,40719,13,3,4249,'App\\Models\\Receipt',4249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',18999.00,NULL,NULL,1,'2021-12-13 07:55:32','2021-12-13 07:55:32',NULL),(4435,3117,40719,13,3,4250,'App\\Models\\Receipt',4250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',3919.31,NULL,NULL,1,'2021-12-13 07:55:32','2021-12-13 07:55:32',NULL),(4436,3117,40719,13,3,4251,'App\\Models\\Receipt',4251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',2500.01,NULL,NULL,1,'2021-12-13 07:55:32','2021-12-13 07:55:32',NULL),(4437,3117,40719,13,3,4252,'App\\Models\\Receipt',4252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',7220.07,NULL,NULL,1,'2021-12-13 07:55:32','2021-12-13 07:55:32',NULL),(4438,3117,40728,6082,2,4253,'App\\Models\\Receipt',4253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',4400.00,NULL,NULL,1,'2021-12-13 14:43:46','2021-12-13 14:43:46',NULL),(4439,3117,40728,6082,2,4254,'App\\Models\\Receipt',4254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',24000.00,NULL,NULL,1,'2021-12-13 14:43:46','2021-12-13 14:43:46',NULL),(4440,3117,40728,6082,2,4255,'App\\Models\\Receipt',4255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',10200.00,NULL,NULL,1,'2021-12-13 14:43:47','2021-12-13 14:43:47',NULL),(4441,3117,40728,6082,2,4256,'App\\Models\\Receipt',4256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',50625.00,NULL,NULL,1,'2021-12-13 14:43:47','2021-12-13 14:43:47',NULL),(4442,3117,40728,6082,2,4257,'App\\Models\\Receipt',4257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',5613.00,NULL,NULL,1,'2021-12-13 14:43:47','2021-12-13 14:43:47',NULL),(4443,3117,40728,6082,2,4258,'App\\Models\\Receipt',4258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',10000.00,NULL,NULL,1,'2021-12-13 14:43:47','2021-12-13 14:43:47',NULL),(4444,3117,40728,6082,2,4259,'App\\Models\\Receipt',4259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',10000.00,NULL,NULL,1,'2021-12-13 14:43:47','2021-12-13 14:43:47',NULL),(4445,3117,40728,6082,2,4260,'App\\Models\\Receipt',4260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',10000.00,NULL,NULL,1,'2021-12-13 14:43:47','2021-12-13 14:43:47',NULL),(4446,3117,40728,6082,2,4261,'App\\Models\\Receipt',4261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',9000.00,NULL,NULL,1,'2021-12-13 14:43:47','2021-12-13 14:43:47',NULL),(4447,3117,40728,6082,2,4262,'App\\Models\\Receipt',4262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',11000.00,NULL,NULL,1,'2021-12-13 14:43:47','2021-12-13 14:43:47',NULL),(4448,3117,40728,6082,2,4263,'App\\Models\\Receipt',4263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',23500.00,NULL,NULL,1,'2021-12-13 14:43:47','2021-12-13 14:43:47',NULL),(4449,3117,40728,6082,2,4264,'App\\Models\\Receipt',4264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',23100.00,NULL,NULL,1,'2021-12-13 14:43:47','2021-12-13 14:43:47',NULL),(4450,3117,40728,6082,2,4265,'App\\Models\\Receipt',4265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',42909.66,NULL,NULL,1,'2021-12-13 14:43:47','2021-12-13 14:45:45','2021-12-13 14:45:45'),(4451,3117,40728,6082,2,4266,'App\\Models\\Receipt',4266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',25250.00,NULL,NULL,1,'2021-12-13 14:43:47','2021-12-13 14:43:47',NULL),(4452,3117,40728,6082,2,4267,'App\\Models\\Receipt',4267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',1500.00,NULL,NULL,1,'2021-12-13 14:43:47','2021-12-13 14:43:47',NULL);
INSERT INTO `balance_libro` VALUES (4453,3117,40728,6082,2,4268,'App\\Models\\Receipt',4268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',3500.00,NULL,NULL,1,'2021-12-13 14:43:47','2021-12-13 14:43:47',NULL),(4454,3117,40728,6082,2,4269,'App\\Models\\Receipt',4269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-20','2021-11-20',9000.00,NULL,NULL,1,'2021-12-13 14:43:47','2021-12-13 14:43:47',NULL),(4455,3117,40728,6082,2,4270,'App\\Models\\Receipt',4270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',12000.00,NULL,NULL,1,'2021-12-13 14:43:47','2021-12-13 14:43:47',NULL),(4456,3117,40728,6082,2,4271,'App\\Models\\Receipt',4271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',7000.00,NULL,NULL,1,'2021-12-13 14:43:47','2021-12-13 14:43:47',NULL),(4457,3117,40728,6082,2,4272,'App\\Models\\Receipt',4272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',10000.00,NULL,NULL,1,'2021-12-13 14:43:47','2021-12-13 14:43:47',NULL),(4458,3117,40728,6082,2,4273,'App\\Models\\Receipt',4273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',6500.00,NULL,NULL,1,'2021-12-13 14:43:47','2021-12-13 14:43:47',NULL),(4459,3117,40728,6082,2,4274,'App\\Models\\Receipt',4274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',41250.00,NULL,NULL,1,'2021-12-13 14:43:47','2021-12-13 14:43:47',NULL),(4460,3117,40728,6082,2,4275,'App\\Models\\Receipt',4275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',12000.00,NULL,NULL,1,'2021-12-13 14:43:47','2021-12-13 14:43:47',NULL),(4461,3117,40728,6082,2,4276,'App\\Models\\Receipt',4276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',11000.00,NULL,NULL,1,'2021-12-13 14:43:47','2021-12-13 14:43:47',NULL),(4462,3117,40728,6082,2,4277,'App\\Models\\Receipt',4277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',12000.00,NULL,NULL,1,'2021-12-13 14:43:47','2021-12-13 14:43:47',NULL),(4463,3117,40728,6082,2,4278,'App\\Models\\Receipt',4278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',10000.00,NULL,NULL,1,'2021-12-13 14:43:47','2021-12-13 14:43:47',NULL),(4464,3117,40728,6082,2,4279,'App\\Models\\Receipt',4279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',36.00,NULL,NULL,1,'2021-12-13 14:43:47','2021-12-13 14:45:27','2021-12-13 14:45:27'),(4465,3117,40728,6082,3,4280,'App\\Models\\Receipt',4280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',20999.02,NULL,NULL,1,'2021-12-13 14:44:06','2021-12-13 14:44:06',NULL),(4466,3117,40728,6082,3,4281,'App\\Models\\Receipt',4281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',15999.00,NULL,NULL,1,'2021-12-13 14:44:06','2021-12-13 14:44:06',NULL),(4467,3117,40728,6082,3,4282,'App\\Models\\Receipt',4282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',21499.00,NULL,NULL,1,'2021-12-13 14:44:06','2021-12-13 14:44:06',NULL),(4468,3117,40728,6082,3,4283,'App\\Models\\Receipt',4283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',20999.01,NULL,NULL,1,'2021-12-13 14:44:06','2021-12-13 14:44:06',NULL),(4469,3117,40728,6082,3,4284,'App\\Models\\Receipt',4284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',21499.00,NULL,NULL,1,'2021-12-13 14:44:06','2021-12-13 14:44:06',NULL),(4470,3117,40728,6082,3,4285,'App\\Models\\Receipt',4285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',15999.00,NULL,NULL,1,'2021-12-13 14:44:06','2021-12-13 14:44:06',NULL),(4471,3117,40728,6082,3,4286,'App\\Models\\Receipt',4286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',15999.00,NULL,NULL,1,'2021-12-13 14:44:06','2021-12-13 14:44:06',NULL),(4472,3117,40728,6082,3,4287,'App\\Models\\Receipt',4287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',20999.01,NULL,NULL,1,'2021-12-13 14:44:06','2021-12-13 14:44:06',NULL),(4473,3117,40728,6082,3,4288,'App\\Models\\Receipt',4288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',15999.00,NULL,NULL,1,'2021-12-13 14:44:06','2021-12-13 14:44:06',NULL);
INSERT INTO `balance_libro` VALUES (4474,3117,40728,6082,3,4289,'App\\Models\\Receipt',4289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',15999.00,NULL,NULL,1,'2021-12-13 14:44:06','2021-12-13 14:44:06',NULL),(4475,3117,40728,6082,3,4290,'App\\Models\\Receipt',4290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',15999.00,NULL,NULL,1,'2021-12-13 14:44:06','2021-12-13 14:44:06',NULL),(4476,3117,40728,6082,3,4291,'App\\Models\\Receipt',4291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',15999.00,NULL,NULL,1,'2021-12-13 14:44:07','2021-12-13 14:44:07',NULL),(4477,3117,40728,6082,3,4292,'App\\Models\\Receipt',4292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',15999.00,NULL,NULL,1,'2021-12-13 14:44:07','2021-12-13 14:44:07',NULL),(4478,3117,40728,6082,3,4293,'App\\Models\\Receipt',4293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',15999.00,NULL,NULL,1,'2021-12-13 14:44:07','2021-12-13 14:44:07',NULL),(4479,3117,40728,6082,3,4294,'App\\Models\\Receipt',4294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',15999.00,NULL,NULL,1,'2021-12-13 14:44:07','2021-12-13 14:44:07',NULL),(4480,3117,40728,6082,3,4295,'App\\Models\\Receipt',4295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',15999.00,NULL,NULL,1,'2021-12-13 14:44:07','2021-12-13 14:44:07',NULL),(4481,3117,40728,6082,3,4296,'App\\Models\\Receipt',4296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',15999.00,NULL,NULL,1,'2021-12-13 14:44:07','2021-12-13 14:44:07',NULL),(4482,3117,40728,6082,3,4297,'App\\Models\\Receipt',4297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',15999.00,NULL,NULL,1,'2021-12-13 14:44:07','2021-12-13 14:44:07',NULL),(4483,3117,40728,6082,3,4298,'App\\Models\\Receipt',4298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',14399.11,NULL,NULL,1,'2021-12-13 14:44:07','2021-12-13 14:44:07',NULL),(4484,3117,40728,6082,3,4299,'App\\Models\\Receipt',4299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',14399.11,NULL,NULL,1,'2021-12-13 14:44:07','2021-12-13 14:44:07',NULL),(4485,3117,40728,6082,3,4300,'App\\Models\\Receipt',4300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',27999.01,NULL,NULL,1,'2021-12-13 14:44:07','2021-12-13 14:44:07',NULL),(4486,3117,40728,6082,3,4301,'App\\Models\\Receipt',4301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',19999.00,NULL,NULL,1,'2021-12-13 14:44:07','2021-12-13 14:44:07',NULL),(4487,3117,40728,6082,3,4302,'App\\Models\\Receipt',4302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',39599.10,NULL,NULL,1,'2021-12-13 14:44:07','2021-12-13 14:44:07',NULL),(4488,3117,40728,6082,3,4303,'App\\Models\\Receipt',4303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',15999.00,NULL,NULL,1,'2021-12-13 14:44:07','2021-12-13 14:44:07',NULL),(4489,3117,40728,6082,3,4304,'App\\Models\\Receipt',4304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',15999.00,NULL,NULL,1,'2021-12-13 14:44:07','2021-12-13 14:44:07',NULL),(4490,3117,40728,6082,3,4305,'App\\Models\\Receipt',4305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',15999.00,NULL,NULL,1,'2021-12-13 14:44:07','2021-12-13 14:44:07',NULL),(4491,3117,40728,6082,3,4306,'App\\Models\\Receipt',4306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',15999.00,NULL,NULL,1,'2021-12-13 14:44:07','2021-12-13 14:44:07',NULL),(4492,3117,40728,6082,3,4307,'App\\Models\\Receipt',4307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',3999.00,NULL,NULL,1,'2021-12-13 14:44:07','2021-12-13 14:44:07',NULL),(4493,3117,40728,6082,3,4308,'App\\Models\\Receipt',4308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',20999.02,NULL,NULL,1,'2021-12-13 14:44:07','2021-12-13 14:44:07',NULL),(4494,3117,40728,6082,3,4309,'App\\Models\\Receipt',4309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',15999.00,NULL,NULL,1,'2021-12-13 14:44:07','2021-12-13 14:44:07',NULL);
INSERT INTO `balance_libro` VALUES (4495,3117,40728,6082,3,4310,'App\\Models\\Receipt',4310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',15999.00,NULL,NULL,1,'2021-12-13 14:44:07','2021-12-13 14:44:07',NULL),(4496,3117,40728,6082,3,4311,'App\\Models\\Receipt',4311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',15999.00,NULL,NULL,1,'2021-12-13 14:44:07','2021-12-13 14:44:07',NULL),(4497,3117,40728,6082,3,4312,'App\\Models\\Receipt',4312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',15999.00,NULL,NULL,1,'2021-12-13 14:44:07','2021-12-13 14:44:07',NULL),(4498,3117,40728,6082,3,4313,'App\\Models\\Receipt',4313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',15999.00,NULL,NULL,1,'2021-12-13 14:44:07','2021-12-13 14:44:07',NULL),(4499,3117,40728,6082,3,4314,'App\\Models\\Receipt',4314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',15999.00,NULL,NULL,1,'2021-12-13 14:44:07','2021-12-13 14:44:07',NULL),(4500,3117,40728,6082,3,4315,'App\\Models\\Receipt',4315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',15999.00,NULL,NULL,1,'2021-12-13 14:44:07','2021-12-13 14:44:07',NULL),(4501,3117,40728,6082,3,4316,'App\\Models\\Receipt',4316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',15999.00,NULL,NULL,1,'2021-12-13 14:44:07','2021-12-13 14:44:07',NULL),(4502,3117,40728,6082,3,4317,'App\\Models\\Receipt',4317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',15999.00,NULL,NULL,1,'2021-12-13 14:44:07','2021-12-13 14:44:07',NULL),(4503,3117,40728,6082,3,4318,'App\\Models\\Receipt',4318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',5430.00,NULL,NULL,1,'2021-12-13 14:44:07','2021-12-13 14:44:07',NULL),(4504,3117,40728,6082,3,4319,'App\\Models\\Receipt',4319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',35999.00,NULL,NULL,1,'2021-12-13 14:44:07','2021-12-13 14:44:07',NULL),(4505,3117,40728,6082,3,4320,'App\\Models\\Receipt',4320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',3999.00,NULL,NULL,1,'2021-12-13 14:44:08','2021-12-13 14:44:08',NULL),(4506,3117,40728,6082,3,4321,'App\\Models\\Receipt',4321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',35999.00,NULL,NULL,1,'2021-12-13 14:44:08','2021-12-13 14:44:08',NULL),(4507,3117,40728,6082,3,4322,'App\\Models\\Receipt',4322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',3999.00,NULL,NULL,1,'2021-12-13 14:44:08','2021-12-13 14:44:08',NULL),(4508,3117,40728,6082,3,4323,'App\\Models\\Receipt',4323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',39599.10,NULL,NULL,1,'2021-12-13 14:44:08','2021-12-13 14:44:08',NULL),(4509,3117,40728,6082,3,4324,'App\\Models\\Receipt',4324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-13','2021-11-13',10999.00,NULL,NULL,1,'2021-12-13 14:44:08','2021-12-13 14:44:08',NULL),(4510,3117,40728,6082,3,4325,'App\\Models\\Receipt',4325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',3999.00,NULL,NULL,1,'2021-12-13 14:44:08','2021-12-13 14:44:08',NULL),(4511,3117,40728,6082,3,4326,'App\\Models\\Receipt',4326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',3999.00,NULL,NULL,1,'2021-12-13 14:44:08','2021-12-13 14:44:08',NULL),(4512,3117,40728,6082,3,4327,'App\\Models\\Receipt',4327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-20','2021-11-20',21499.00,NULL,NULL,1,'2021-12-13 14:44:08','2021-12-13 14:44:08',NULL),(4513,3117,40728,6082,3,4328,'App\\Models\\Receipt',4328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-20','2021-11-20',21499.00,NULL,NULL,1,'2021-12-13 14:44:08','2021-12-13 14:44:08',NULL),(4514,3117,40728,6082,3,4329,'App\\Models\\Receipt',4329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-20','2021-11-20',17999.00,NULL,NULL,1,'2021-12-13 14:44:08','2021-12-13 14:44:08',NULL),(4515,3117,40728,6082,3,4330,'App\\Models\\Receipt',4330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-20','2021-11-20',21499.00,NULL,NULL,1,'2021-12-13 14:44:08','2021-12-13 14:44:08',NULL);
INSERT INTO `balance_libro` VALUES (4516,3117,40728,6082,3,4331,'App\\Models\\Receipt',4331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-20','2021-11-20',17999.00,NULL,NULL,1,'2021-12-13 14:44:08','2021-12-13 14:44:08',NULL),(4517,3117,40728,6082,3,4332,'App\\Models\\Receipt',4332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-21','2021-11-21',17999.00,NULL,NULL,1,'2021-12-13 14:44:08','2021-12-13 14:44:08',NULL),(4518,3117,40728,6082,3,4333,'App\\Models\\Receipt',4333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-21','2021-11-21',17999.00,NULL,NULL,1,'2021-12-13 14:44:08','2021-12-13 14:44:08',NULL),(4519,3117,40728,6082,3,4334,'App\\Models\\Receipt',4334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',15999.01,NULL,NULL,1,'2021-12-13 14:44:08','2021-12-13 14:44:08',NULL),(4520,3117,40728,6082,3,4335,'App\\Models\\Receipt',4335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',23999.00,NULL,NULL,1,'2021-12-13 14:44:08','2021-12-13 14:44:08',NULL),(4521,3117,40728,6082,3,4336,'App\\Models\\Receipt',4336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',32399.11,NULL,NULL,1,'2021-12-13 14:44:08','2021-12-13 14:44:08',NULL),(4522,3117,40728,6082,3,4337,'App\\Models\\Receipt',4337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',20999.02,NULL,NULL,1,'2021-12-13 14:44:08','2021-12-13 14:44:08',NULL),(4523,3117,40728,6082,3,4338,'App\\Models\\Receipt',4338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',21499.00,NULL,NULL,1,'2021-12-13 14:44:08','2021-12-13 14:44:08',NULL),(4524,3117,40728,6082,3,4339,'App\\Models\\Receipt',4339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',17999.00,NULL,NULL,1,'2021-12-13 14:44:08','2021-12-13 14:44:08',NULL),(4525,3117,40728,6082,3,4340,'App\\Models\\Receipt',4340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',10999.00,NULL,NULL,1,'2021-12-13 14:44:08','2021-12-13 14:44:08',NULL),(4526,3117,40728,6082,3,4341,'App\\Models\\Receipt',4341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',27589.12,NULL,NULL,1,'2021-12-13 14:44:08','2021-12-13 14:44:08',NULL),(4527,3117,40728,6082,3,4342,'App\\Models\\Receipt',4342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',27589.12,NULL,NULL,1,'2021-12-13 14:44:08','2021-12-13 14:44:08',NULL),(4528,3117,40728,6082,3,4343,'App\\Models\\Receipt',4343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',27589.12,NULL,NULL,1,'2021-12-13 14:44:08','2021-12-13 14:44:08',NULL),(4529,3117,40728,6082,3,4344,'App\\Models\\Receipt',4344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',27589.12,NULL,NULL,1,'2021-12-13 14:44:08','2021-12-13 14:44:08',NULL),(4530,3117,40728,6082,3,4345,'App\\Models\\Receipt',4345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',19999.00,NULL,NULL,1,'2021-12-13 14:44:08','2021-12-13 14:44:08',NULL),(4531,3117,40728,6082,3,4346,'App\\Models\\Receipt',4346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',19999.00,NULL,NULL,1,'2021-12-13 14:44:08','2021-12-13 14:44:08',NULL),(4532,3117,40728,6082,3,4347,'App\\Models\\Receipt',4347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',26733.00,NULL,NULL,1,'2021-12-13 14:44:08','2021-12-13 14:44:08',NULL),(4533,3117,40728,6082,3,4348,'App\\Models\\Receipt',4348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',26733.00,NULL,NULL,1,'2021-12-13 14:44:08','2021-12-13 14:44:08',NULL),(4534,3117,40728,6082,3,4349,'App\\Models\\Receipt',4349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',26733.00,NULL,NULL,1,'2021-12-13 14:44:08','2021-12-13 14:44:08',NULL),(4535,3117,40728,6082,3,4350,'App\\Models\\Receipt',4350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',19999.00,NULL,NULL,1,'2021-12-13 14:44:08','2021-12-13 14:44:08',NULL),(4536,3117,40728,6082,3,4351,'App\\Models\\Receipt',4351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',19999.00,NULL,NULL,1,'2021-12-13 14:44:09','2021-12-13 14:44:09',NULL);
INSERT INTO `balance_libro` VALUES (4537,3117,40728,6082,3,4352,'App\\Models\\Receipt',4352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',26733.00,NULL,NULL,1,'2021-12-13 14:44:09','2021-12-13 14:44:09',NULL),(4538,3117,40728,6082,3,4353,'App\\Models\\Receipt',4353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',26733.00,NULL,NULL,1,'2021-12-13 14:44:09','2021-12-13 14:44:09',NULL),(4539,3117,40728,6082,3,4354,'App\\Models\\Receipt',4354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',19999.00,NULL,NULL,1,'2021-12-13 14:44:09','2021-12-13 14:44:09',NULL),(4540,3117,40728,6082,3,4355,'App\\Models\\Receipt',4355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',14999.00,NULL,NULL,1,'2021-12-13 14:44:09','2021-12-13 14:44:09',NULL),(4541,3117,40728,6082,3,4356,'App\\Models\\Receipt',4356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',15999.01,NULL,NULL,1,'2021-12-13 14:44:09','2021-12-13 14:44:09',NULL),(4542,3117,40728,6082,3,4357,'App\\Models\\Receipt',4357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',15999.01,NULL,NULL,1,'2021-12-13 14:44:09','2021-12-13 14:44:09',NULL),(4543,3117,40728,6082,3,4358,'App\\Models\\Receipt',4358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',336.00,NULL,NULL,1,'2021-12-13 14:44:09','2021-12-13 14:44:09',NULL),(4544,3117,40728,6082,3,4359,'App\\Models\\Receipt',4359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',18268.16,NULL,NULL,1,'2021-12-13 14:44:09','2021-12-13 14:44:09',NULL),(4545,3117,40728,6082,2,4279,'App\\Models\\Receipt',4279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',36.00,NULL,NULL,1,'2021-12-13 14:45:27','2021-12-13 14:45:27',NULL),(4546,3117,40728,6082,2,4265,'App\\Models\\Receipt',4265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',42909.66,NULL,NULL,1,'2021-12-13 14:45:45','2021-12-13 14:45:45',NULL),(4547,3117,40885,13962,2,4360,'App\\Models\\Receipt',4360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',1575.00,NULL,NULL,1,'2021-12-15 13:51:49','2021-12-15 13:51:49',NULL),(4548,3117,40885,13962,2,4361,'App\\Models\\Receipt',4361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',625.00,NULL,NULL,1,'2021-12-15 13:51:49','2021-12-15 13:51:49',NULL),(4549,3117,40885,13962,2,4362,'App\\Models\\Receipt',4362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',600.00,NULL,NULL,1,'2021-12-15 13:51:49','2021-12-15 13:51:49',NULL),(4550,3117,40885,13962,2,4363,'App\\Models\\Receipt',4363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',892.00,NULL,NULL,1,'2021-12-15 13:51:49','2021-12-15 13:51:49',NULL),(4551,3117,40885,13962,2,4364,'App\\Models\\Receipt',4364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-09','2021-11-09',500.00,NULL,NULL,1,'2021-12-15 13:51:49','2021-12-15 13:51:49',NULL),(4552,3117,40885,13962,2,4365,'App\\Models\\Receipt',4365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-09','2021-11-09',145.00,NULL,NULL,1,'2021-12-15 13:51:49','2021-12-15 13:51:49',NULL),(4553,3117,40885,13962,3,4366,'App\\Models\\Receipt',4366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',21450.06,NULL,NULL,1,'2021-12-15 13:52:00','2021-12-15 13:52:00',NULL),(4554,3117,40885,13962,3,4367,'App\\Models\\Receipt',4367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',10000.00,NULL,NULL,1,'2021-12-15 13:52:00','2021-12-15 13:52:00',NULL),(4555,3117,40885,13962,3,4368,'App\\Models\\Receipt',4368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',6353.90,NULL,NULL,1,'2021-12-15 13:52:00','2021-12-15 13:52:00',NULL),(4556,3117,40885,13962,3,4369,'App\\Models\\Receipt',4369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',7171.50,NULL,NULL,1,'2021-12-15 13:52:00','2021-12-15 13:52:00',NULL),(4557,3117,40885,13962,3,4370,'App\\Models\\Receipt',4370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',5483.68,NULL,NULL,1,'2021-12-15 13:52:01','2021-12-15 13:52:01',NULL);
INSERT INTO `balance_libro` VALUES (4558,3117,40885,13962,3,4371,'App\\Models\\Receipt',4371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',6787.41,NULL,NULL,1,'2021-12-15 13:52:01','2021-12-15 13:52:01',NULL),(4559,3117,40885,13962,3,4372,'App\\Models\\Receipt',4372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',2702.98,NULL,NULL,1,'2021-12-15 13:52:01','2021-12-15 13:52:01',NULL),(4560,3117,40885,13962,3,4373,'App\\Models\\Receipt',4373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',19293.34,NULL,NULL,1,'2021-12-15 13:52:01','2021-12-15 13:52:01',NULL),(4561,3117,40885,13962,3,4374,'App\\Models\\Receipt',4374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-09','2021-11-09',3474.90,NULL,NULL,1,'2021-12-15 13:52:01','2021-12-15 13:52:01',NULL),(4562,3117,40885,13962,3,4375,'App\\Models\\Receipt',4375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',3117.63,NULL,NULL,1,'2021-12-15 13:52:01','2021-12-15 13:52:01',NULL),(4563,3117,40885,13962,3,4376,'App\\Models\\Receipt',4376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',12498.36,NULL,NULL,1,'2021-12-15 13:52:01','2021-12-15 13:52:01',NULL),(4564,3117,40885,13962,3,4377,'App\\Models\\Receipt',4377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',10924.41,NULL,NULL,1,'2021-12-15 13:52:01','2021-12-15 13:52:01',NULL),(4565,3117,40885,13962,3,4378,'App\\Models\\Receipt',4378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',7869.73,NULL,NULL,1,'2021-12-15 13:52:01','2021-12-15 13:52:01',NULL),(4566,3117,40885,13962,3,4379,'App\\Models\\Receipt',4379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-13','2021-11-13',2498.98,NULL,NULL,1,'2021-12-15 13:52:01','2021-12-15 13:52:01',NULL),(4567,3117,40885,13962,3,4380,'App\\Models\\Receipt',4380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',1099.01,NULL,NULL,1,'2021-12-15 13:52:01','2021-12-15 13:52:01',NULL),(4568,3117,40885,13962,3,4381,'App\\Models\\Receipt',4381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',18960.15,NULL,NULL,1,'2021-12-15 13:52:01','2021-12-15 13:52:01',NULL),(4569,3117,40885,13962,3,4382,'App\\Models\\Receipt',4382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-16','2021-11-16',6511.25,NULL,NULL,1,'2021-12-15 13:52:01','2021-12-15 13:52:01',NULL),(4570,3117,40885,13962,3,4383,'App\\Models\\Receipt',4383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',13137.20,NULL,NULL,1,'2021-12-15 13:52:01','2021-12-15 13:52:01',NULL),(4571,3117,40885,13962,3,4384,'App\\Models\\Receipt',4384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',6786.65,NULL,NULL,1,'2021-12-15 13:52:01','2021-12-15 13:52:01',NULL),(4572,3117,40885,13962,3,4385,'App\\Models\\Receipt',4385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',11896.67,NULL,NULL,1,'2021-12-15 13:52:01','2021-12-15 13:52:01',NULL),(4573,3117,40885,13962,3,4386,'App\\Models\\Receipt',4386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',18669.90,NULL,NULL,1,'2021-12-15 13:52:01','2021-12-15 13:52:01',NULL),(4574,3117,40885,13962,3,4387,'App\\Models\\Receipt',4387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-21','2021-11-21',2279.99,NULL,NULL,1,'2021-12-15 13:52:01','2021-12-15 13:52:01',NULL),(4575,3117,40885,13962,3,4388,'App\\Models\\Receipt',4388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-22','2021-11-22',8468.34,NULL,NULL,1,'2021-12-15 13:52:01','2021-12-15 13:52:01',NULL),(4576,3117,40885,13962,3,4389,'App\\Models\\Receipt',4389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-24','2021-11-24',6848.12,NULL,NULL,1,'2021-12-15 13:52:01','2021-12-15 13:52:01',NULL),(4577,3117,40885,13962,3,4390,'App\\Models\\Receipt',4390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',10343.32,NULL,NULL,1,'2021-12-15 13:52:01','2021-12-15 13:52:01',NULL),(4578,3117,40885,13962,3,4391,'App\\Models\\Receipt',4391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',28191.50,NULL,NULL,1,'2021-12-15 13:52:01','2021-12-15 13:52:01',NULL);
INSERT INTO `balance_libro` VALUES (4579,3117,40885,13962,3,4392,'App\\Models\\Receipt',4392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',1996.90,NULL,NULL,1,'2021-12-15 13:52:01','2021-12-15 13:52:01',NULL),(4580,3117,40885,13962,3,4393,'App\\Models\\Receipt',4393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',4298.32,NULL,NULL,1,'2021-12-15 13:52:02','2021-12-15 13:52:02',NULL),(4581,3117,40885,13962,3,4394,'App\\Models\\Receipt',4394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',16529.51,NULL,NULL,1,'2021-12-15 13:52:02','2021-12-15 13:52:02',NULL),(4582,3117,40885,13962,3,4395,'App\\Models\\Receipt',4395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',6084.68,NULL,NULL,1,'2021-12-15 13:52:02','2021-12-15 13:52:02',NULL),(4583,3117,40885,13962,3,4396,'App\\Models\\Receipt',4396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',1500.00,NULL,NULL,1,'2021-12-15 13:52:02','2021-12-15 13:52:02',NULL),(4584,3117,40885,13962,3,4397,'App\\Models\\Receipt',4397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',1116.01,NULL,NULL,1,'2021-12-15 13:52:02','2021-12-15 13:52:02',NULL),(4585,3117,40885,13962,3,4398,'App\\Models\\Receipt',4398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',21486.97,NULL,NULL,1,'2021-12-15 13:52:02','2021-12-15 13:52:02',NULL),(4586,3117,40885,13962,3,4399,'App\\Models\\Receipt',4399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',3294.43,NULL,NULL,1,'2021-12-15 13:52:02','2021-12-15 13:52:02',NULL),(4587,3117,40885,13962,3,4400,'App\\Models\\Receipt',4400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',2202.51,NULL,NULL,1,'2021-12-15 13:52:02','2021-12-15 13:52:02',NULL),(4588,3117,40845,11737,2,4401,'App\\Models\\Receipt',4401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',10220.00,NULL,NULL,1,'2021-12-17 14:43:53','2021-12-17 14:43:53',NULL),(4589,3117,40845,11737,2,4402,'App\\Models\\Receipt',4402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',11667.00,NULL,NULL,1,'2021-12-17 14:43:53','2021-12-17 14:43:53',NULL),(4590,3117,40845,11737,2,4403,'App\\Models\\Receipt',4403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',10999.00,NULL,NULL,1,'2021-12-17 14:43:53','2021-12-17 14:43:53',NULL),(4591,3117,40845,11737,2,4404,'App\\Models\\Receipt',4404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',8996.00,NULL,NULL,1,'2021-12-17 14:43:53','2021-12-17 14:43:53',NULL),(4592,3117,40845,11737,2,4405,'App\\Models\\Receipt',4405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',6332.00,NULL,NULL,1,'2021-12-17 14:43:53','2021-12-17 14:43:53',NULL),(4593,3117,40845,11737,2,4406,'App\\Models\\Receipt',4406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',7399.00,NULL,NULL,1,'2021-12-17 14:43:53','2021-12-17 14:43:53',NULL),(4594,3117,40845,11737,2,4407,'App\\Models\\Receipt',4407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',12330.00,NULL,NULL,1,'2021-12-17 14:43:53','2021-12-17 14:43:53',NULL),(4595,3117,40845,11737,2,4408,'App\\Models\\Receipt',4408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-20','2021-11-20',13100.00,NULL,NULL,1,'2021-12-17 14:43:53','2021-12-17 14:43:53',NULL),(4596,3117,40845,11737,2,4409,'App\\Models\\Receipt',4409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',12999.00,NULL,NULL,1,'2021-12-17 14:43:53','2021-12-17 14:43:53',NULL),(4597,3117,40845,11737,2,4410,'App\\Models\\Receipt',4410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',12890.00,NULL,NULL,1,'2021-12-17 14:43:53','2021-12-17 14:43:53',NULL),(4598,3117,40845,11737,3,4411,'App\\Models\\Receipt',4411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',5910.96,NULL,NULL,1,'2021-12-17 14:44:10','2021-12-17 14:44:10',NULL),(4599,3117,40845,11737,3,4412,'App\\Models\\Receipt',4412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',8544.27,NULL,NULL,1,'2021-12-17 14:44:10','2021-12-17 14:44:10',NULL);
INSERT INTO `balance_libro` VALUES (4600,3117,40845,11737,3,4413,'App\\Models\\Receipt',4413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',1526.45,NULL,NULL,1,'2021-12-17 14:44:10','2021-12-17 14:44:10',NULL),(4601,3117,40845,11737,3,4414,'App\\Models\\Receipt',4414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',64099.82,NULL,NULL,1,'2021-12-17 14:44:10','2021-12-17 14:44:10',NULL),(4602,3117,40845,11737,3,4415,'App\\Models\\Receipt',4415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',1771.50,NULL,NULL,1,'2021-12-17 14:44:10','2021-12-17 14:44:10',NULL),(4603,3117,40845,11737,3,4416,'App\\Models\\Receipt',4416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',19596.78,NULL,NULL,1,'2021-12-17 14:44:10','2021-12-17 14:44:10',NULL),(4604,3117,40845,11737,3,4417,'App\\Models\\Receipt',4417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',40976.47,NULL,NULL,1,'2021-12-17 14:44:10','2021-12-17 14:44:10',NULL),(4605,3117,40845,11737,3,4418,'App\\Models\\Receipt',4418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',8256.80,NULL,NULL,1,'2021-12-17 14:44:10','2021-12-17 14:44:10',NULL),(4606,3117,40845,11737,3,4419,'App\\Models\\Receipt',4419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',400.00,NULL,NULL,1,'2021-12-17 14:44:10','2021-12-17 14:44:10',NULL),(4607,3117,40845,11737,3,4420,'App\\Models\\Receipt',4420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',1595.97,NULL,NULL,1,'2021-12-17 14:44:10','2021-12-17 14:44:10',NULL),(4608,3117,40845,11737,3,4421,'App\\Models\\Receipt',4421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',9911.53,NULL,NULL,1,'2021-12-17 14:44:11','2021-12-17 14:44:11',NULL),(4609,3117,40845,11737,3,4422,'App\\Models\\Receipt',4422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',21804.17,NULL,NULL,1,'2021-12-17 14:44:11','2021-12-17 14:44:11',NULL),(4610,3117,40845,11737,3,4423,'App\\Models\\Receipt',4423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',7107.62,NULL,NULL,1,'2021-12-17 14:44:11','2021-12-17 14:44:11',NULL),(4611,3117,40845,11737,3,4424,'App\\Models\\Receipt',4424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',55424.20,NULL,NULL,1,'2021-12-17 14:44:11','2021-12-17 14:44:11',NULL),(4612,3117,40845,11737,3,4425,'App\\Models\\Receipt',4425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',1207.98,NULL,NULL,1,'2021-12-17 14:44:11','2021-12-17 14:44:11',NULL),(4613,3117,40845,11737,3,4426,'App\\Models\\Receipt',4426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',15240.04,NULL,NULL,1,'2021-12-17 14:44:11','2021-12-17 14:44:11',NULL),(4614,3117,40845,11737,3,4427,'App\\Models\\Receipt',4427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',23675.19,NULL,NULL,1,'2021-12-17 14:44:11','2021-12-17 14:44:11',NULL),(4615,3117,40845,11737,3,4428,'App\\Models\\Receipt',4428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',5324.27,NULL,NULL,1,'2021-12-17 14:44:11','2021-12-17 14:44:11',NULL),(4616,3117,40845,11737,3,4429,'App\\Models\\Receipt',4429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',2078.94,NULL,NULL,1,'2021-12-17 14:44:11','2021-12-17 14:44:11',NULL),(4617,3117,40845,11737,3,4430,'App\\Models\\Receipt',4430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',79884.53,NULL,NULL,1,'2021-12-17 14:44:11','2021-12-17 14:44:11',NULL),(4618,3117,40845,11737,3,4431,'App\\Models\\Receipt',4431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-09','2021-11-09',22864.39,NULL,NULL,1,'2021-12-17 14:44:11','2021-12-17 14:44:11',NULL),(4619,3117,40845,11737,3,4432,'App\\Models\\Receipt',4432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',30013.69,NULL,NULL,1,'2021-12-17 14:44:11','2021-12-17 14:44:11',NULL),(4620,3117,40845,11737,3,4433,'App\\Models\\Receipt',4433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',26741.66,NULL,NULL,1,'2021-12-17 14:44:11','2021-12-17 14:44:11',NULL);
INSERT INTO `balance_libro` VALUES (4621,3117,40845,11737,3,4434,'App\\Models\\Receipt',4434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',6685.13,NULL,NULL,1,'2021-12-17 14:44:11','2021-12-17 14:44:11',NULL),(4622,3117,40845,11737,3,4435,'App\\Models\\Receipt',4435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',3737.67,NULL,NULL,1,'2021-12-17 14:44:11','2021-12-17 14:44:11',NULL),(4623,3117,40845,11737,3,4436,'App\\Models\\Receipt',4436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',892.30,NULL,NULL,1,'2021-12-17 14:44:11','2021-12-17 14:44:11',NULL),(4624,3117,40845,11737,3,4437,'App\\Models\\Receipt',4437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',11291.47,NULL,NULL,1,'2021-12-17 14:44:11','2021-12-17 14:44:11',NULL),(4625,3117,40845,11737,3,4438,'App\\Models\\Receipt',4438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',40860.53,NULL,NULL,1,'2021-12-17 14:44:11','2021-12-17 14:44:11',NULL),(4626,3117,40845,11737,3,4439,'App\\Models\\Receipt',4439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',0.00,NULL,NULL,1,'2021-12-17 14:44:11','2021-12-17 14:44:11',NULL),(4627,3117,40845,11737,3,4440,'App\\Models\\Receipt',4440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',53612.70,NULL,NULL,1,'2021-12-17 14:44:11','2021-12-17 14:44:11',NULL),(4628,3117,40845,11737,3,4441,'App\\Models\\Receipt',4441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',1596.00,NULL,NULL,1,'2021-12-17 14:44:11','2021-12-17 14:44:11',NULL),(4629,3117,40845,11737,3,4442,'App\\Models\\Receipt',4442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',2.03,NULL,NULL,1,'2021-12-17 14:44:11','2021-12-17 14:44:11',NULL),(4630,3117,40845,11737,3,4443,'App\\Models\\Receipt',4443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',15606.30,NULL,NULL,1,'2021-12-17 14:44:11','2021-12-17 14:44:11',NULL),(4631,3117,40845,11737,3,4444,'App\\Models\\Receipt',4444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-13','2021-11-13',12939.67,NULL,NULL,1,'2021-12-17 14:44:11','2021-12-17 14:44:11',NULL),(4632,3117,40845,11737,3,4445,'App\\Models\\Receipt',4445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-13','2021-11-13',8469.27,NULL,NULL,1,'2021-12-17 14:44:11','2021-12-17 14:44:11',NULL),(4633,3117,40845,11737,3,4446,'App\\Models\\Receipt',4446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',19929.68,NULL,NULL,1,'2021-12-17 14:44:11','2021-12-17 14:44:11',NULL),(4634,3117,40845,11737,3,4447,'App\\Models\\Receipt',4447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',2043.67,NULL,NULL,1,'2021-12-17 14:44:11','2021-12-17 14:44:11',NULL),(4635,3117,40845,11737,3,4448,'App\\Models\\Receipt',4448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',14320.02,NULL,NULL,1,'2021-12-17 14:44:11','2021-12-17 14:44:11',NULL),(4636,3117,40845,11737,3,4449,'App\\Models\\Receipt',4449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',13379.65,NULL,NULL,1,'2021-12-17 14:44:11','2021-12-17 14:44:11',NULL),(4637,3117,40845,11737,3,4450,'App\\Models\\Receipt',4450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',54399.76,NULL,NULL,1,'2021-12-17 14:44:11','2021-12-17 14:44:11',NULL),(4638,3117,40845,11737,3,4451,'App\\Models\\Receipt',4451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-16','2021-11-16',2168.50,NULL,NULL,1,'2021-12-17 14:44:11','2021-12-17 14:44:11',NULL),(4639,3117,40845,11737,3,4452,'App\\Models\\Receipt',4452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-16','2021-11-16',23543.67,NULL,NULL,1,'2021-12-17 14:44:11','2021-12-17 14:44:11',NULL),(4640,3117,40845,11737,3,4453,'App\\Models\\Receipt',4453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-16','2021-11-16',33394.33,NULL,NULL,1,'2021-12-17 14:44:12','2021-12-17 14:44:12',NULL),(4641,3117,40845,11737,3,4454,'App\\Models\\Receipt',4454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',4256.07,NULL,NULL,1,'2021-12-17 14:44:12','2021-12-17 14:44:12',NULL);
INSERT INTO `balance_libro` VALUES (4642,3117,40845,11737,3,4455,'App\\Models\\Receipt',4455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',830.76,NULL,NULL,1,'2021-12-17 14:44:12','2021-12-17 14:44:12',NULL),(4643,3117,40845,11737,3,4456,'App\\Models\\Receipt',4456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',19092.01,NULL,NULL,1,'2021-12-17 14:44:12','2021-12-17 14:44:12',NULL),(4644,3117,40845,11737,3,4457,'App\\Models\\Receipt',4457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',22710.47,NULL,NULL,1,'2021-12-17 14:44:12','2021-12-17 14:44:12',NULL),(4645,3117,40845,11737,3,4458,'App\\Models\\Receipt',4458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',8011.44,NULL,NULL,1,'2021-12-17 14:44:12','2021-12-17 14:44:12',NULL),(4646,3117,40845,11737,3,4459,'App\\Models\\Receipt',4459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',2900.08,NULL,NULL,1,'2021-12-17 14:44:12','2021-12-17 14:44:12',NULL),(4647,3117,40845,11737,3,4460,'App\\Models\\Receipt',4460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',51955.59,NULL,NULL,1,'2021-12-17 14:44:12','2021-12-17 14:44:12',NULL),(4648,3117,40845,11737,3,4461,'App\\Models\\Receipt',4461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',59658.76,NULL,NULL,1,'2021-12-17 14:44:12','2021-12-17 14:44:12',NULL),(4649,3117,40845,11737,3,4462,'App\\Models\\Receipt',4462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',28839.24,NULL,NULL,1,'2021-12-17 14:44:12','2021-12-17 14:44:12',NULL),(4650,3117,40845,11737,3,4463,'App\\Models\\Receipt',4463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',12302.31,NULL,NULL,1,'2021-12-17 14:44:12','2021-12-17 14:44:12',NULL),(4651,3117,40845,11737,3,4464,'App\\Models\\Receipt',4464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',12085.45,NULL,NULL,1,'2021-12-17 14:44:12','2021-12-17 14:44:12',NULL),(4652,3117,40845,11737,3,4465,'App\\Models\\Receipt',4465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',13820.06,NULL,NULL,1,'2021-12-17 14:44:12','2021-12-17 14:44:12',NULL),(4653,3117,40845,11737,3,4466,'App\\Models\\Receipt',4466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-24','2021-11-24',40158.56,NULL,NULL,1,'2021-12-17 14:44:12','2021-12-17 14:44:12',NULL),(4654,3117,40845,11737,3,4467,'App\\Models\\Receipt',4467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-24','2021-11-24',20791.87,NULL,NULL,1,'2021-12-17 14:44:12','2021-12-17 14:44:12',NULL),(4655,3117,40845,11737,3,4468,'App\\Models\\Receipt',4468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',16253.28,NULL,NULL,1,'2021-12-17 14:44:12','2021-12-17 14:44:12',NULL),(4656,3117,40845,11737,3,4469,'App\\Models\\Receipt',4469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',3064.22,NULL,NULL,1,'2021-12-17 14:44:12','2021-12-17 14:44:12',NULL),(4657,3117,40845,11737,3,4470,'App\\Models\\Receipt',4470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',8663.73,NULL,NULL,1,'2021-12-17 14:44:12','2021-12-17 14:44:12',NULL),(4658,3117,40845,11737,3,4471,'App\\Models\\Receipt',4471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',78373.75,NULL,NULL,1,'2021-12-17 14:44:12','2021-12-17 14:44:12',NULL),(4659,3117,40845,11737,3,4472,'App\\Models\\Receipt',4472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',15576.71,NULL,NULL,1,'2021-12-17 14:44:12','2021-12-17 14:44:12',NULL),(4660,3117,40845,11737,3,4473,'App\\Models\\Receipt',4473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',29202.18,NULL,NULL,1,'2021-12-17 14:44:12','2021-12-17 14:44:12',NULL),(4661,3117,40845,11737,3,4474,'App\\Models\\Receipt',4474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',1416.00,NULL,NULL,1,'2021-12-17 14:44:12','2021-12-17 14:44:12',NULL),(4662,3117,40845,11737,3,4475,'App\\Models\\Receipt',4475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',19270.91,NULL,NULL,1,'2021-12-17 14:44:12','2021-12-17 14:44:12',NULL);
INSERT INTO `balance_libro` VALUES (4663,3117,40845,11737,3,4476,'App\\Models\\Receipt',4476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',22114.85,NULL,NULL,1,'2021-12-17 14:44:12','2021-12-17 14:44:12',NULL),(4664,3117,40845,11737,3,4477,'App\\Models\\Receipt',4477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',2306.70,NULL,NULL,1,'2021-12-17 14:44:12','2021-12-17 14:44:12',NULL),(4665,3117,40845,11737,3,4478,'App\\Models\\Receipt',4478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',17800.10,NULL,NULL,1,'2021-12-17 14:44:12','2021-12-17 14:44:12',NULL),(4666,3117,40845,11737,3,4479,'App\\Models\\Receipt',4479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',1022.05,NULL,NULL,1,'2021-12-17 14:44:12','2021-12-17 14:44:12',NULL),(4667,3117,40845,11737,3,4480,'App\\Models\\Receipt',4480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',65740.00,NULL,NULL,1,'2021-12-17 14:44:12','2021-12-17 14:44:12',NULL),(4668,3117,40845,11737,3,4481,'App\\Models\\Receipt',4481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',360.00,NULL,NULL,1,'2021-12-17 14:44:12','2021-12-17 14:44:12',NULL),(4669,3117,40845,11737,3,4482,'App\\Models\\Receipt',4482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',9995.59,NULL,NULL,1,'2021-12-17 14:44:12','2021-12-17 14:44:12',NULL),(4670,3117,40845,11737,3,4483,'App\\Models\\Receipt',4483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',2452.04,NULL,NULL,1,'2021-12-17 14:44:12','2021-12-17 14:44:12',NULL),(4671,3117,40845,11737,3,4484,'App\\Models\\Receipt',4484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',5607.35,NULL,NULL,1,'2021-12-17 14:44:39','2021-12-17 14:44:39',NULL),(4672,3117,40845,11737,3,4485,'App\\Models\\Receipt',4485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-02','2021-10-02',1748.00,NULL,NULL,1,'2021-12-17 14:44:39','2021-12-17 14:44:39',NULL),(4673,3117,40845,11737,3,4486,'App\\Models\\Receipt',4486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-02','2021-10-02',21768.96,NULL,NULL,1,'2021-12-17 14:44:39','2021-12-17 14:44:39',NULL),(4674,3117,40845,11737,3,4487,'App\\Models\\Receipt',4487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',13551.85,NULL,NULL,1,'2021-12-17 14:44:39','2021-12-17 14:44:39',NULL),(4675,3117,40845,11737,3,4488,'App\\Models\\Receipt',4488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',304.59,NULL,NULL,1,'2021-12-17 14:44:39','2021-12-17 14:44:39',NULL),(4676,3117,40845,11737,3,4489,'App\\Models\\Receipt',4489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',17388.60,NULL,NULL,1,'2021-12-17 14:44:39','2021-12-17 14:44:39',NULL),(4677,3117,40845,11737,3,4490,'App\\Models\\Receipt',4490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',2676.23,NULL,NULL,1,'2021-12-17 14:44:39','2021-12-17 14:44:39',NULL),(4678,3117,40845,11737,3,4491,'App\\Models\\Receipt',4491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',62590.34,NULL,NULL,1,'2021-12-17 14:44:39','2021-12-17 14:44:39',NULL),(4679,3117,40845,11737,3,4492,'App\\Models\\Receipt',4492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',1695.82,NULL,NULL,1,'2021-12-17 14:44:39','2021-12-17 14:44:39',NULL),(4680,3117,40845,11737,3,4493,'App\\Models\\Receipt',4493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',33396.15,NULL,NULL,1,'2021-12-17 14:44:39','2021-12-17 14:44:39',NULL),(4681,3117,40845,11737,3,4494,'App\\Models\\Receipt',4494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',20402.05,NULL,NULL,1,'2021-12-17 14:44:39','2021-12-17 14:44:39',NULL),(4682,3117,40845,11737,3,4495,'App\\Models\\Receipt',4495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',3647.25,NULL,NULL,1,'2021-12-17 14:44:39','2021-12-17 14:44:39',NULL),(4683,3117,40845,11737,3,4496,'App\\Models\\Receipt',4496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',22363.21,NULL,NULL,1,'2021-12-17 14:44:39','2021-12-17 14:44:39',NULL);
INSERT INTO `balance_libro` VALUES (4684,3117,40845,11737,3,4497,'App\\Models\\Receipt',4497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',1331.08,NULL,NULL,1,'2021-12-17 14:44:39','2021-12-17 14:44:39',NULL),(4685,3117,40845,11737,3,4498,'App\\Models\\Receipt',4498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',8884.99,NULL,NULL,1,'2021-12-17 14:44:39','2021-12-17 14:44:39',NULL),(4686,3117,40845,11737,3,4499,'App\\Models\\Receipt',4499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',0.00,NULL,NULL,1,'2021-12-17 14:44:39','2021-12-17 14:44:39',NULL),(4687,3117,40845,11737,3,4500,'App\\Models\\Receipt',4500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',20503.54,NULL,NULL,1,'2021-12-17 14:44:39','2021-12-17 14:44:39',NULL),(4688,3117,40845,11737,3,4501,'App\\Models\\Receipt',4501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',13359.65,NULL,NULL,1,'2021-12-17 14:44:39','2021-12-17 14:44:39',NULL),(4689,3117,40845,11737,3,4502,'App\\Models\\Receipt',4502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',58859.85,NULL,NULL,1,'2021-12-17 14:44:39','2021-12-17 14:44:39',NULL),(4690,3117,40845,11737,3,4503,'App\\Models\\Receipt',4503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',5975.81,NULL,NULL,1,'2021-12-17 14:44:39','2021-12-17 14:44:39',NULL),(4691,3117,40845,11737,3,4504,'App\\Models\\Receipt',4504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',3555.17,NULL,NULL,1,'2021-12-17 14:44:39','2021-12-17 14:44:39',NULL),(4692,3117,40845,11737,3,4505,'App\\Models\\Receipt',4505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',40888.90,NULL,NULL,1,'2021-12-17 14:44:39','2021-12-17 14:44:39',NULL),(4693,3117,40845,11737,3,4506,'App\\Models\\Receipt',4506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',1510.50,NULL,NULL,1,'2021-12-17 14:44:39','2021-12-17 14:44:39',NULL),(4694,3117,40845,11737,3,4507,'App\\Models\\Receipt',4507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',25961.90,NULL,NULL,1,'2021-12-17 14:44:39','2021-12-17 14:44:39',NULL),(4695,3117,40845,11737,3,4508,'App\\Models\\Receipt',4508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',25635.49,NULL,NULL,1,'2021-12-17 14:44:40','2021-12-17 14:44:40',NULL),(4696,3117,40845,11737,3,4509,'App\\Models\\Receipt',4509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',18693.66,NULL,NULL,1,'2021-12-17 14:44:40','2021-12-17 14:44:40',NULL),(4697,3117,40845,11737,3,4510,'App\\Models\\Receipt',4510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',639.10,NULL,NULL,1,'2021-12-17 14:44:40','2021-12-17 14:44:40',NULL),(4698,3117,40845,11737,3,4511,'App\\Models\\Receipt',4511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',14458.77,NULL,NULL,1,'2021-12-17 14:44:40','2021-12-17 14:44:40',NULL),(4699,3117,40845,11737,3,4512,'App\\Models\\Receipt',4512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',40999.96,NULL,NULL,1,'2021-12-17 14:44:40','2021-12-17 14:44:40',NULL),(4700,3117,40845,11737,3,4513,'App\\Models\\Receipt',4513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',0.00,NULL,NULL,1,'2021-12-17 14:44:40','2021-12-17 14:44:40',NULL),(4701,3117,40845,11737,3,4514,'App\\Models\\Receipt',4514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13','2021-10-13',6625.35,NULL,NULL,1,'2021-12-17 14:44:40','2021-12-17 14:44:40',NULL),(4702,3117,40845,11737,3,4515,'App\\Models\\Receipt',4515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',8433.42,NULL,NULL,1,'2021-12-17 14:44:40','2021-12-17 14:44:40',NULL),(4703,3117,40845,11737,3,4516,'App\\Models\\Receipt',4516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',996.07,NULL,NULL,1,'2021-12-17 14:44:40','2021-12-17 14:44:40',NULL),(4704,3117,40845,11737,3,4517,'App\\Models\\Receipt',4517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',9842.25,NULL,NULL,1,'2021-12-17 14:44:40','2021-12-17 14:44:40',NULL);
INSERT INTO `balance_libro` VALUES (4705,3117,40845,11737,3,4518,'App\\Models\\Receipt',4518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',6625.35,NULL,NULL,1,'2021-12-17 14:44:40','2021-12-17 14:44:40',NULL),(4706,3117,40845,11737,3,4519,'App\\Models\\Receipt',4519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',1671.40,NULL,NULL,1,'2021-12-17 14:44:40','2021-12-17 14:44:40',NULL),(4707,3117,40845,11737,3,4520,'App\\Models\\Receipt',4520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',0.00,NULL,NULL,1,'2021-12-17 14:44:40','2021-12-17 14:44:40',NULL),(4708,3117,40845,11737,3,4521,'App\\Models\\Receipt',4521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',12999.00,NULL,NULL,1,'2021-12-17 14:44:40','2021-12-17 14:44:40',NULL),(4709,3117,40845,11737,3,4522,'App\\Models\\Receipt',4522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',40999.00,NULL,NULL,1,'2021-12-17 14:44:40','2021-12-17 14:44:40',NULL),(4710,3117,40845,11737,3,4523,'App\\Models\\Receipt',4523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',12999.00,NULL,NULL,1,'2021-12-17 14:44:40','2021-12-17 14:44:40',NULL),(4711,3117,40845,11737,3,4524,'App\\Models\\Receipt',4524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',5062.61,NULL,NULL,1,'2021-12-17 14:44:40','2021-12-17 14:44:40',NULL),(4712,3117,40845,11737,3,4525,'App\\Models\\Receipt',4525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',0.00,NULL,NULL,1,'2021-12-17 14:44:40','2021-12-17 14:44:40',NULL),(4713,3117,40845,11737,3,4526,'App\\Models\\Receipt',4526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',6625.35,NULL,NULL,1,'2021-12-17 14:44:40','2021-12-17 14:44:40',NULL),(4714,3117,40845,11737,3,4527,'App\\Models\\Receipt',4527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',0.00,NULL,NULL,1,'2021-12-17 14:44:40','2021-12-17 14:44:40',NULL),(4715,3117,40845,11737,3,4528,'App\\Models\\Receipt',4528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',6625.35,NULL,NULL,1,'2021-12-17 14:44:40','2021-12-17 14:44:40',NULL),(4716,3117,40845,11737,3,4529,'App\\Models\\Receipt',4529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',66802.43,NULL,NULL,1,'2021-12-17 14:44:40','2021-12-17 14:44:40',NULL),(4717,3117,40845,11737,3,4530,'App\\Models\\Receipt',4530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-16','2021-10-16',722.92,NULL,NULL,1,'2021-12-17 14:44:41','2021-12-17 14:44:41',NULL),(4718,3117,40845,11737,3,4531,'App\\Models\\Receipt',4531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-16','2021-10-16',14110.42,NULL,NULL,1,'2021-12-17 14:44:41','2021-12-17 14:44:41',NULL),(4719,3117,40845,11737,3,4532,'App\\Models\\Receipt',4532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',17985.06,NULL,NULL,1,'2021-12-17 14:44:41','2021-12-17 14:44:41',NULL),(4720,3117,40845,11737,3,4533,'App\\Models\\Receipt',4533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',4692.27,NULL,NULL,1,'2021-12-17 14:44:41','2021-12-17 14:44:41',NULL),(4721,3117,40845,11737,3,4534,'App\\Models\\Receipt',4534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',1982.50,NULL,NULL,1,'2021-12-17 14:44:41','2021-12-17 14:44:41',NULL),(4722,3117,40845,11737,3,4535,'App\\Models\\Receipt',4535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',54102.56,NULL,NULL,1,'2021-12-17 14:44:41','2021-12-17 14:44:41',NULL),(4723,3117,40845,11737,3,4536,'App\\Models\\Receipt',4536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',40999.00,NULL,NULL,1,'2021-12-17 14:44:41','2021-12-17 14:44:41',NULL),(4724,3117,40845,11737,3,4537,'App\\Models\\Receipt',4537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',48898.00,NULL,NULL,1,'2021-12-17 14:44:41','2021-12-17 14:44:41',NULL),(4725,3117,40845,11737,3,4538,'App\\Models\\Receipt',4538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',20947.42,NULL,NULL,1,'2021-12-17 14:44:41','2021-12-17 14:44:41',NULL);
INSERT INTO `balance_libro` VALUES (4726,3117,40845,11737,3,4539,'App\\Models\\Receipt',4539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',14634.73,NULL,NULL,1,'2021-12-17 14:44:41','2021-12-17 14:44:41',NULL),(4727,3117,40845,11737,3,4540,'App\\Models\\Receipt',4540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',8233.62,NULL,NULL,1,'2021-12-17 14:44:41','2021-12-17 14:44:41',NULL),(4728,3117,40845,11737,3,4541,'App\\Models\\Receipt',4541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',200.00,NULL,NULL,1,'2021-12-17 14:44:41','2021-12-17 14:44:41',NULL),(4729,3117,40845,11737,3,4542,'App\\Models\\Receipt',4542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',23565.53,NULL,NULL,1,'2021-12-17 14:44:41','2021-12-17 14:44:41',NULL),(4730,3117,40845,11737,3,4543,'App\\Models\\Receipt',4543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',8466.62,NULL,NULL,1,'2021-12-17 14:44:41','2021-12-17 14:44:41',NULL),(4731,3117,40845,11737,3,4544,'App\\Models\\Receipt',4544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',4463.16,NULL,NULL,1,'2021-12-17 14:44:41','2021-12-17 14:44:41',NULL),(4732,3117,40845,11737,3,4545,'App\\Models\\Receipt',4545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',53908.73,NULL,NULL,1,'2021-12-17 14:44:41','2021-12-17 14:44:41',NULL),(4733,3117,40845,11737,3,4546,'App\\Models\\Receipt',4546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',29236.66,NULL,NULL,1,'2021-12-17 14:44:41','2021-12-17 14:44:41',NULL),(4734,3117,40845,11737,3,4547,'App\\Models\\Receipt',4547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',6374.68,NULL,NULL,1,'2021-12-17 14:44:41','2021-12-17 14:44:41',NULL),(4735,3117,40845,11737,3,4548,'App\\Models\\Receipt',4548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23','2021-10-23',12826.05,NULL,NULL,1,'2021-12-17 14:44:41','2021-12-17 14:44:41',NULL),(4736,3117,40845,11737,3,4549,'App\\Models\\Receipt',4549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23','2021-10-23',0.00,NULL,NULL,1,'2021-12-17 14:44:41','2021-12-17 14:44:41',NULL),(4737,3117,40845,11737,3,4550,'App\\Models\\Receipt',4550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',22565.62,NULL,NULL,1,'2021-12-17 14:44:41','2021-12-17 14:44:41',NULL),(4738,3117,40845,11737,3,4551,'App\\Models\\Receipt',4551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',15948.32,NULL,NULL,1,'2021-12-17 14:44:41','2021-12-17 14:44:41',NULL),(4739,3117,40845,11737,3,4552,'App\\Models\\Receipt',4552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',3578.44,NULL,NULL,1,'2021-12-17 14:44:41','2021-12-17 14:44:41',NULL),(4740,3117,40845,11737,3,4553,'App\\Models\\Receipt',4553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',51473.98,NULL,NULL,1,'2021-12-17 14:44:41','2021-12-17 14:44:41',NULL),(4741,3117,40845,11737,3,4554,'App\\Models\\Receipt',4554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',31349.55,NULL,NULL,1,'2021-12-17 14:44:41','2021-12-17 14:44:41',NULL),(4742,3117,40845,11737,3,4555,'App\\Models\\Receipt',4555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',45229.02,NULL,NULL,1,'2021-12-17 14:44:41','2021-12-17 14:44:41',NULL),(4743,3117,40845,11737,3,4556,'App\\Models\\Receipt',4556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',0.00,NULL,NULL,1,'2021-12-17 14:44:41','2021-12-17 14:44:41',NULL),(4744,3117,40845,11737,3,4557,'App\\Models\\Receipt',4557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',7883.46,NULL,NULL,1,'2021-12-17 14:44:41','2021-12-17 14:44:41',NULL),(4745,3117,40845,11737,3,4558,'App\\Models\\Receipt',4558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',3744.26,NULL,NULL,1,'2021-12-17 14:44:41','2021-12-17 14:44:41',NULL),(4746,3117,40845,11737,3,4559,'App\\Models\\Receipt',4559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',12464.54,NULL,NULL,1,'2021-12-17 14:44:42','2021-12-17 14:44:42',NULL);
INSERT INTO `balance_libro` VALUES (4747,3117,40845,11737,3,4560,'App\\Models\\Receipt',4560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',60072.31,NULL,NULL,1,'2021-12-17 14:44:42','2021-12-17 14:44:42',NULL),(4748,3117,40845,11737,3,4561,'App\\Models\\Receipt',4561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-30','2021-10-30',15064.75,NULL,NULL,1,'2021-12-17 14:44:42','2021-12-17 14:44:42',NULL),(4749,3117,40845,11737,3,4562,'App\\Models\\Receipt',4562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-30','2021-10-30',1084.37,NULL,NULL,1,'2021-12-17 14:44:42','2021-12-17 14:44:42',NULL),(4750,3117,40845,11737,3,4563,'App\\Models\\Receipt',4563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',372.00,NULL,NULL,1,'2021-12-17 14:44:42','2021-12-17 14:44:42',NULL),(4751,3117,40845,11737,3,4564,'App\\Models\\Receipt',4564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',1723.94,NULL,NULL,1,'2021-12-17 14:44:42','2021-12-17 14:44:42',NULL),(4752,3117,40845,11737,2,4565,'App\\Models\\Receipt',4565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',6852.00,NULL,NULL,1,'2021-12-17 14:44:59','2021-12-17 14:46:07','2021-12-17 14:46:07'),(4753,3117,40845,11737,2,4566,'App\\Models\\Receipt',4566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-02','2021-10-02',5996.00,NULL,NULL,1,'2021-12-17 14:44:59','2021-12-17 14:49:58','2021-12-17 14:49:58'),(4754,3117,40845,11737,2,4567,'App\\Models\\Receipt',4567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',6112.00,NULL,NULL,1,'2021-12-17 14:44:59','2021-12-17 14:49:46','2021-12-17 14:49:46'),(4755,3117,40845,11737,2,4568,'App\\Models\\Receipt',4568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',7115.00,NULL,NULL,1,'2021-12-17 14:44:59','2021-12-17 14:49:34','2021-12-17 14:49:34'),(4756,3117,40845,11737,2,4569,'App\\Models\\Receipt',4569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',20000.00,NULL,NULL,1,'2021-12-17 14:44:59','2021-12-17 14:49:22','2021-12-17 14:49:22'),(4757,3117,40845,11737,2,4570,'App\\Models\\Receipt',4570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',8993.00,NULL,NULL,1,'2021-12-17 14:44:59','2021-12-17 14:49:10','2021-12-17 14:49:10'),(4758,3117,40845,11737,2,4571,'App\\Models\\Receipt',4571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',6925.00,NULL,NULL,1,'2021-12-17 14:44:59','2021-12-17 14:48:58','2021-12-17 14:48:58'),(4759,3117,40845,11737,2,4572,'App\\Models\\Receipt',4572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',12963.00,NULL,NULL,1,'2021-12-17 14:44:59','2021-12-17 14:48:46','2021-12-17 14:48:46'),(4760,3117,40845,11737,2,4573,'App\\Models\\Receipt',4573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',13080.00,NULL,NULL,1,'2021-12-17 14:44:59','2021-12-17 14:48:28','2021-12-17 14:48:28'),(4761,3117,40845,11737,2,4574,'App\\Models\\Receipt',4574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',12999.00,NULL,NULL,1,'2021-12-17 14:44:59','2021-12-17 14:48:13','2021-12-17 14:48:13'),(4762,3117,40845,11737,2,4575,'App\\Models\\Receipt',4575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',11699.00,NULL,NULL,1,'2021-12-17 14:44:59','2021-12-17 14:48:01','2021-12-17 14:48:01'),(4763,3117,40845,11737,2,4576,'App\\Models\\Receipt',4576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',10595.00,NULL,NULL,1,'2021-12-17 14:44:59','2021-12-17 14:47:49','2021-12-17 14:47:49'),(4764,3117,40845,11737,2,4577,'App\\Models\\Receipt',4577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',11200.00,NULL,NULL,1,'2021-12-17 14:44:59','2021-12-17 14:47:37','2021-12-17 14:47:37'),(4765,3117,40845,11737,2,4578,'App\\Models\\Receipt',4578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',12050.00,NULL,NULL,1,'2021-12-17 14:44:59','2021-12-17 14:46:19','2021-12-17 14:46:19');
INSERT INTO `balance_libro` VALUES (4766,3117,40845,11737,2,4579,'App\\Models\\Receipt',4579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',11980.00,NULL,NULL,1,'2021-12-17 14:44:59','2021-12-17 14:47:26','2021-12-17 14:47:26'),(4767,3117,40845,11737,2,4580,'App\\Models\\Receipt',4580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',10963.00,NULL,NULL,1,'2021-12-17 14:44:59','2021-12-17 14:47:17','2021-12-17 14:47:17'),(4768,3117,40845,11737,2,4581,'App\\Models\\Receipt',4581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',10999.00,NULL,NULL,1,'2021-12-17 14:44:59','2021-12-17 14:47:06','2021-12-17 14:47:06'),(4769,3117,40845,11737,2,4582,'App\\Models\\Receipt',4582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',10119.00,NULL,NULL,1,'2021-12-17 14:44:59','2021-12-17 14:46:57','2021-12-17 14:46:57'),(4770,3117,40845,11737,2,4583,'App\\Models\\Receipt',4583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',11120.00,NULL,NULL,1,'2021-12-17 14:44:59','2021-12-17 14:46:36','2021-12-17 14:46:36'),(4771,3117,40845,11736,2,4565,'App\\Models\\Receipt',4565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',6852.00,NULL,NULL,1,'2021-12-17 14:46:07','2021-12-17 14:46:07',NULL),(4772,3117,40845,11736,2,4578,'App\\Models\\Receipt',4578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',12050.00,NULL,NULL,1,'2021-12-17 14:46:19','2021-12-17 14:46:19',NULL),(4773,3117,40845,11736,2,4583,'App\\Models\\Receipt',4583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',11120.00,NULL,NULL,1,'2021-12-17 14:46:36','2021-12-17 14:46:47','2021-12-17 14:46:47'),(4774,3117,40845,11736,2,4583,'App\\Models\\Receipt',4583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',11120.00,NULL,NULL,1,'2021-12-17 14:46:47','2021-12-17 14:46:47',NULL),(4775,3117,40845,11736,2,4582,'App\\Models\\Receipt',4582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',10119.00,NULL,NULL,1,'2021-12-17 14:46:57','2021-12-17 14:48:34','2021-12-17 14:48:34'),(4776,3117,40845,11736,2,4581,'App\\Models\\Receipt',4581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',10999.00,NULL,NULL,1,'2021-12-17 14:47:06','2021-12-17 14:47:06',NULL),(4777,3117,40845,11736,2,4580,'App\\Models\\Receipt',4580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',10963.00,NULL,NULL,1,'2021-12-17 14:47:17','2021-12-17 14:47:17',NULL),(4778,3117,40845,11736,2,4579,'App\\Models\\Receipt',4579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',11980.00,NULL,NULL,1,'2021-12-17 14:47:26','2021-12-17 14:47:26',NULL),(4779,3117,40845,11736,2,4577,'App\\Models\\Receipt',4577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',11200.00,NULL,NULL,1,'2021-12-17 14:47:37','2021-12-17 14:47:37',NULL),(4780,3117,40845,11736,2,4576,'App\\Models\\Receipt',4576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',10595.00,NULL,NULL,1,'2021-12-17 14:47:49','2021-12-17 14:47:49',NULL),(4781,3117,40845,11736,2,4575,'App\\Models\\Receipt',4575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',11699.00,NULL,NULL,1,'2021-12-17 14:48:01','2021-12-17 14:48:01',NULL),(4782,3117,40845,11736,2,4574,'App\\Models\\Receipt',4574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',12999.00,NULL,NULL,1,'2021-12-17 14:48:13','2021-12-17 14:48:13',NULL),(4783,3117,40845,11736,2,4573,'App\\Models\\Receipt',4573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',13080.00,NULL,NULL,1,'2021-12-17 14:48:28','2021-12-17 14:48:28',NULL),(4784,3117,40845,11736,2,4582,'App\\Models\\Receipt',4582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',10119.00,NULL,NULL,1,'2021-12-17 14:48:34','2021-12-17 14:48:34',NULL),(4785,3117,40845,11736,2,4572,'App\\Models\\Receipt',4572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',12963.00,NULL,NULL,1,'2021-12-17 14:48:46','2021-12-17 14:48:46',NULL);
INSERT INTO `balance_libro` VALUES (4786,3117,40845,11736,2,4571,'App\\Models\\Receipt',4571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09','2021-10-09',6925.00,NULL,NULL,1,'2021-12-17 14:48:58','2021-12-17 14:48:58',NULL),(4787,3117,40845,11736,2,4570,'App\\Models\\Receipt',4570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',8993.00,NULL,NULL,1,'2021-12-17 14:49:10','2021-12-17 14:49:10',NULL),(4788,3117,40845,11736,2,4569,'App\\Models\\Receipt',4569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',20000.00,NULL,NULL,1,'2021-12-17 14:49:22','2021-12-17 14:49:22',NULL),(4789,3117,40845,11736,2,4568,'App\\Models\\Receipt',4568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',7115.00,NULL,NULL,1,'2021-12-17 14:49:34','2021-12-17 14:49:34',NULL),(4790,3117,40845,11736,2,4567,'App\\Models\\Receipt',4567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',6112.00,NULL,NULL,1,'2021-12-17 14:49:46','2021-12-17 14:49:46',NULL),(4791,3117,40845,11736,2,4566,'App\\Models\\Receipt',4566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-02','2021-10-02',5996.00,NULL,NULL,1,'2021-12-17 14:49:58','2021-12-17 14:49:58',NULL),(4792,3117,40922,15474,2,4584,'App\\Models\\Receipt',4584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',8268.00,NULL,NULL,1,'2021-12-21 10:49:57','2021-12-21 10:49:57',NULL),(4793,3117,40922,15474,2,4585,'App\\Models\\Receipt',4585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',277.00,NULL,NULL,1,'2021-12-21 10:49:57','2021-12-21 10:49:57',NULL),(4794,3117,40922,15474,2,4586,'App\\Models\\Receipt',4586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',615.00,NULL,NULL,1,'2021-12-21 10:49:57','2021-12-21 10:49:57',NULL),(4795,3117,40922,15474,2,4587,'App\\Models\\Receipt',4587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',1532.00,NULL,NULL,1,'2021-12-21 10:49:57','2021-12-21 10:49:57',NULL),(4796,3117,40922,15474,2,4588,'App\\Models\\Receipt',4588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',13000.00,NULL,NULL,1,'2021-12-21 10:49:57','2021-12-21 10:49:57',NULL),(4797,3117,40922,15474,2,4589,'App\\Models\\Receipt',4589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',5000.00,NULL,NULL,1,'2021-12-21 10:49:57','2021-12-21 10:49:57',NULL),(4798,3117,40922,15474,2,4590,'App\\Models\\Receipt',4590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',938.00,NULL,NULL,1,'2021-12-21 10:49:57','2021-12-21 10:49:57',NULL),(4799,3117,40922,15474,2,4591,'App\\Models\\Receipt',4591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',548.00,NULL,NULL,1,'2021-12-21 10:49:57','2021-12-21 10:49:57',NULL),(4800,3117,40922,15474,2,4592,'App\\Models\\Receipt',4592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',12802.00,NULL,NULL,1,'2021-12-21 10:49:57','2021-12-21 10:49:57',NULL),(4801,3117,40922,15474,2,4593,'App\\Models\\Receipt',4593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',2267.00,NULL,NULL,1,'2021-12-21 10:49:57','2021-12-21 10:49:57',NULL),(4802,3117,40922,15474,2,4594,'App\\Models\\Receipt',4594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',1050.00,NULL,NULL,1,'2021-12-21 10:49:57','2021-12-21 10:49:57',NULL),(4803,3117,40922,15474,2,4595,'App\\Models\\Receipt',4595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',2293.00,NULL,NULL,1,'2021-12-21 10:49:57','2021-12-21 10:49:57',NULL),(4804,3117,40922,15474,2,4596,'App\\Models\\Receipt',4596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',699.00,NULL,NULL,1,'2021-12-21 10:49:58','2021-12-21 10:49:58',NULL),(4805,3117,40922,15474,2,4597,'App\\Models\\Receipt',4597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',4214.00,NULL,NULL,1,'2021-12-21 10:49:58','2021-12-21 10:49:58',NULL),(4806,3117,40922,15474,2,4598,'App\\Models\\Receipt',4598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',1076.00,NULL,NULL,1,'2021-12-21 10:49:58','2021-12-21 10:49:58',NULL);
INSERT INTO `balance_libro` VALUES (4807,3117,40922,15474,2,4599,'App\\Models\\Receipt',4599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',4000.00,NULL,NULL,1,'2021-12-21 10:49:58','2021-12-21 10:49:58',NULL),(4808,3117,40922,15474,2,4600,'App\\Models\\Receipt',4600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',2068.00,NULL,NULL,1,'2021-12-21 10:49:58','2021-12-21 10:49:58',NULL),(4809,3117,40922,15474,2,4601,'App\\Models\\Receipt',4601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',13110.00,NULL,NULL,1,'2021-12-21 10:49:58','2021-12-21 10:49:58',NULL),(4810,3117,40922,15474,2,4602,'App\\Models\\Receipt',4602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',591.00,NULL,NULL,1,'2021-12-21 10:49:58','2021-12-21 10:49:58',NULL),(4811,3117,40922,15474,2,4603,'App\\Models\\Receipt',4603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',13000.00,NULL,NULL,1,'2021-12-21 10:49:58','2021-12-21 10:49:58',NULL),(4812,3117,40922,15474,2,4604,'App\\Models\\Receipt',4604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',865.00,NULL,NULL,1,'2021-12-21 10:49:58','2021-12-21 10:49:58',NULL),(4813,3117,40922,15474,2,4605,'App\\Models\\Receipt',4605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',977.00,NULL,NULL,1,'2021-12-21 10:49:58','2021-12-21 10:49:58',NULL),(4814,3117,40922,15474,2,4606,'App\\Models\\Receipt',4606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',977.00,NULL,NULL,1,'2021-12-21 10:49:58','2021-12-21 10:49:58',NULL),(4815,3117,40922,15474,2,4607,'App\\Models\\Receipt',4607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',1475.00,NULL,NULL,1,'2021-12-21 10:49:58','2021-12-21 10:49:58',NULL),(4816,3117,40922,15474,2,4608,'App\\Models\\Receipt',4608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',2577.00,NULL,NULL,1,'2021-12-21 10:49:58','2021-12-21 10:49:58',NULL),(4817,3117,40922,15474,2,4609,'App\\Models\\Receipt',4609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',861.00,NULL,NULL,1,'2021-12-21 10:49:58','2021-12-21 10:49:58',NULL),(4818,3117,40922,15474,2,4610,'App\\Models\\Receipt',4610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',13000.00,NULL,NULL,1,'2021-12-21 10:49:58','2021-12-21 10:49:58',NULL),(4819,3117,40922,15474,2,4611,'App\\Models\\Receipt',4611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',827.00,NULL,NULL,1,'2021-12-21 10:49:58','2021-12-21 10:49:58',NULL),(4820,3117,40922,15474,2,4612,'App\\Models\\Receipt',4612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',1094.00,NULL,NULL,1,'2021-12-21 10:49:58','2021-12-21 10:49:58',NULL),(4821,3117,40922,15474,2,4613,'App\\Models\\Receipt',4613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',1711.00,NULL,NULL,1,'2021-12-21 10:49:58','2021-12-21 10:49:58',NULL),(4822,3117,40922,15474,2,4614,'App\\Models\\Receipt',4614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',1858.00,NULL,NULL,1,'2021-12-21 10:49:59','2021-12-21 10:49:59',NULL),(4823,3117,40922,15474,2,4615,'App\\Models\\Receipt',4615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',871.00,NULL,NULL,1,'2021-12-21 10:49:59','2021-12-21 10:49:59',NULL),(4824,3117,40922,15474,2,4616,'App\\Models\\Receipt',4616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',13000.00,NULL,NULL,1,'2021-12-21 10:49:59','2021-12-21 10:49:59',NULL),(4825,3117,40922,15474,2,4617,'App\\Models\\Receipt',4617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',1928.00,NULL,NULL,1,'2021-12-21 10:49:59','2021-12-21 10:49:59',NULL),(4826,3117,40922,15474,2,4618,'App\\Models\\Receipt',4618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',363.00,NULL,NULL,1,'2021-12-21 10:49:59','2021-12-21 10:49:59',NULL),(4827,3117,40922,15474,2,4619,'App\\Models\\Receipt',4619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',1051.00,NULL,NULL,1,'2021-12-21 10:49:59','2021-12-21 10:49:59',NULL);
INSERT INTO `balance_libro` VALUES (4828,3117,40922,15474,2,4620,'App\\Models\\Receipt',4620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',808.00,NULL,NULL,1,'2021-12-21 10:49:59','2021-12-21 10:49:59',NULL),(4829,3117,40922,15474,2,4621,'App\\Models\\Receipt',4621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',800.00,NULL,NULL,1,'2021-12-21 10:49:59','2021-12-21 10:49:59',NULL),(4830,3117,40922,15474,2,4622,'App\\Models\\Receipt',4622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',795.00,NULL,NULL,1,'2021-12-21 10:49:59','2021-12-21 10:49:59',NULL),(4831,3117,40922,15474,2,4623,'App\\Models\\Receipt',4623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',13000.00,NULL,NULL,1,'2021-12-21 10:49:59','2021-12-21 10:49:59',NULL),(4832,3117,40922,15474,2,4624,'App\\Models\\Receipt',4624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',1900.00,NULL,NULL,1,'2021-12-21 10:49:59','2021-12-21 10:49:59',NULL),(4833,3117,40922,15474,3,4625,'App\\Models\\Receipt',4625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',403.22,NULL,NULL,1,'2021-12-21 10:50:15','2021-12-21 10:50:15',NULL),(4834,3117,40922,15474,3,4626,'App\\Models\\Receipt',4626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',3800.54,NULL,NULL,1,'2021-12-21 10:50:15','2021-12-21 10:50:15',NULL),(4835,3117,40922,15474,3,4627,'App\\Models\\Receipt',4627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-03','2021-11-03',5283.21,NULL,NULL,1,'2021-12-21 10:50:15','2021-12-21 10:50:15',NULL),(4836,3117,40922,15474,3,4628,'App\\Models\\Receipt',4628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',2306.53,NULL,NULL,1,'2021-12-21 10:50:15','2021-12-21 10:50:15',NULL),(4837,3117,40922,15474,3,4629,'App\\Models\\Receipt',4629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',4765.22,NULL,NULL,1,'2021-12-21 10:50:15','2021-12-21 10:50:15',NULL),(4838,3117,40922,15474,3,4630,'App\\Models\\Receipt',4630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',9736.22,NULL,NULL,1,'2021-12-21 10:50:15','2021-12-21 10:55:30','2021-12-21 10:55:30'),(4839,3117,40922,15474,3,4631,'App\\Models\\Receipt',4631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',3532.69,NULL,NULL,1,'2021-12-21 10:50:15','2021-12-21 10:50:15',NULL),(4840,3117,40922,15474,3,4632,'App\\Models\\Receipt',4632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',2427.73,NULL,NULL,1,'2021-12-21 10:50:15','2021-12-21 10:50:15',NULL),(4841,3117,40922,15474,3,4633,'App\\Models\\Receipt',4633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',7810.20,NULL,NULL,1,'2021-12-21 10:50:15','2021-12-21 10:50:15',NULL),(4842,3117,40922,15474,3,4634,'App\\Models\\Receipt',4634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',0.00,NULL,NULL,1,'2021-12-21 10:50:15','2021-12-21 10:50:15',NULL),(4843,3117,40922,15474,3,4635,'App\\Models\\Receipt',4635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',388.58,NULL,NULL,1,'2021-12-21 10:50:15','2021-12-21 10:50:15',NULL),(4844,3117,40922,15474,3,4636,'App\\Models\\Receipt',4636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',3361.95,NULL,NULL,1,'2021-12-21 10:50:16','2021-12-21 10:50:16',NULL),(4845,3117,40922,15474,3,4637,'App\\Models\\Receipt',4637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',2676.92,NULL,NULL,1,'2021-12-21 10:50:16','2021-12-21 10:50:16',NULL),(4846,3117,40922,15474,3,4638,'App\\Models\\Receipt',4638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',533.97,NULL,NULL,1,'2021-12-21 10:50:16','2021-12-21 10:50:16',NULL),(4847,3117,40922,15474,3,4639,'App\\Models\\Receipt',4639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',3481.58,NULL,NULL,1,'2021-12-21 10:50:16','2021-12-21 10:50:16',NULL),(4848,3117,40922,15474,3,4640,'App\\Models\\Receipt',4640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',5172.82,NULL,NULL,1,'2021-12-21 10:50:16','2021-12-21 10:50:16',NULL);
INSERT INTO `balance_libro` VALUES (4849,3117,40922,15474,3,4641,'App\\Models\\Receipt',4641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',4878.74,NULL,NULL,1,'2021-12-21 10:50:16','2021-12-21 10:50:16',NULL),(4850,3117,40922,15474,3,4642,'App\\Models\\Receipt',4642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',2658.88,NULL,NULL,1,'2021-12-21 10:50:16','2021-12-21 10:50:16',NULL),(4851,3117,40922,15474,3,4643,'App\\Models\\Receipt',4643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',10874.47,NULL,NULL,1,'2021-12-21 10:50:16','2021-12-21 11:01:30','2021-12-21 11:01:30'),(4852,3117,40922,15474,3,4644,'App\\Models\\Receipt',4644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',8813.05,NULL,NULL,1,'2021-12-21 10:50:16','2021-12-21 11:00:45','2021-12-21 11:00:45'),(4853,3117,40922,15474,3,4645,'App\\Models\\Receipt',4645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',9413.44,NULL,NULL,1,'2021-12-21 10:50:16','2021-12-21 10:50:16',NULL),(4854,3117,40922,15474,3,4646,'App\\Models\\Receipt',4646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',4262.90,NULL,NULL,1,'2021-12-21 10:50:16','2021-12-21 10:50:16',NULL),(4855,3117,40922,15474,3,4647,'App\\Models\\Receipt',4647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-13','2021-11-13',0.00,NULL,NULL,1,'2021-12-21 10:50:16','2021-12-21 10:50:16',NULL),(4856,3117,40922,15474,3,4648,'App\\Models\\Receipt',4648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-13','2021-11-13',7100.20,NULL,NULL,1,'2021-12-21 10:50:16','2021-12-21 10:50:16',NULL),(4857,3117,40922,15474,3,4649,'App\\Models\\Receipt',4649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-13','2021-11-13',10868.34,NULL,NULL,1,'2021-12-21 10:50:16','2021-12-21 10:50:16',NULL),(4858,3117,40922,15474,3,4650,'App\\Models\\Receipt',4650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',3892.26,NULL,NULL,1,'2021-12-21 10:50:16','2021-12-21 10:50:16',NULL),(4859,3117,40922,15474,3,4651,'App\\Models\\Receipt',4651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',3522.35,NULL,NULL,1,'2021-12-21 10:50:16','2021-12-21 10:50:16',NULL),(4860,3117,40922,15474,3,4652,'App\\Models\\Receipt',4652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',1660.12,NULL,NULL,1,'2021-12-21 10:50:16','2021-12-21 10:50:16',NULL),(4861,3117,40922,15474,3,4653,'App\\Models\\Receipt',4653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',9530.75,NULL,NULL,1,'2021-12-21 10:50:16','2021-12-21 11:02:01','2021-12-21 11:02:01'),(4862,3117,40922,15474,3,4654,'App\\Models\\Receipt',4654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',1107.56,NULL,NULL,1,'2021-12-21 10:50:16','2021-12-21 10:50:16',NULL),(4863,3117,40922,15474,3,4655,'App\\Models\\Receipt',4655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',4058.40,NULL,NULL,1,'2021-12-21 10:50:16','2021-12-21 10:50:16',NULL),(4864,3117,40922,15474,3,4656,'App\\Models\\Receipt',4656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',7864.94,NULL,NULL,1,'2021-12-21 10:50:16','2021-12-21 10:57:44','2021-12-21 10:57:44'),(4865,3117,40922,15474,3,4657,'App\\Models\\Receipt',4657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',6855.51,NULL,NULL,1,'2021-12-21 10:50:16','2021-12-21 10:50:16',NULL),(4866,3117,40922,15474,3,4658,'App\\Models\\Receipt',4658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',4391.21,NULL,NULL,1,'2021-12-21 10:50:16','2021-12-21 10:50:16',NULL),(4867,3117,40922,15474,3,4659,'App\\Models\\Receipt',4659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-24','2021-11-24',10031.75,NULL,NULL,1,'2021-12-21 10:50:16','2021-12-21 10:50:16',NULL),(4868,3117,40922,15474,3,4660,'App\\Models\\Receipt',4660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',4979.28,NULL,NULL,1,'2021-12-21 10:50:17','2021-12-21 10:50:17',NULL);
INSERT INTO `balance_libro` VALUES (4869,3117,40922,15474,3,4661,'App\\Models\\Receipt',4661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',6059.28,NULL,NULL,1,'2021-12-21 10:50:17','2021-12-21 10:50:17',NULL),(4870,3117,40922,15474,3,4662,'App\\Models\\Receipt',4662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',9556.88,NULL,NULL,1,'2021-12-21 10:50:17','2021-12-21 10:50:17',NULL),(4871,3117,40922,15474,3,4663,'App\\Models\\Receipt',4663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',4605.74,NULL,NULL,1,'2021-12-21 10:50:17','2021-12-21 10:50:17',NULL),(4872,3117,40922,15474,3,4664,'App\\Models\\Receipt',4664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',3411.09,NULL,NULL,1,'2021-12-21 10:50:17','2021-12-21 10:50:17',NULL),(4873,3117,40922,15474,3,4665,'App\\Models\\Receipt',4665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',6845.74,NULL,NULL,1,'2021-12-21 10:50:17','2021-12-21 10:50:17',NULL),(4874,3117,40922,15474,3,4666,'App\\Models\\Receipt',4666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',391.33,NULL,NULL,1,'2021-12-21 10:50:17','2021-12-21 10:50:17',NULL),(4875,3117,40922,15474,3,4667,'App\\Models\\Receipt',4667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',15043.93,NULL,NULL,1,'2021-12-21 10:50:17','2021-12-21 10:50:17',NULL),(4876,3117,40922,15474,3,4668,'App\\Models\\Receipt',4668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',1132.22,NULL,NULL,1,'2021-12-21 10:50:17','2021-12-21 10:50:17',NULL),(4877,3117,40922,15474,3,4669,'App\\Models\\Receipt',4669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',3463.41,NULL,NULL,1,'2021-12-21 10:50:17','2021-12-21 10:50:17',NULL),(4878,3117,40922,15474,3,4670,'App\\Models\\Receipt',4670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',2385.22,NULL,NULL,1,'2021-12-21 10:50:17','2021-12-21 10:50:17',NULL),(4879,3117,40922,15474,3,4630,'App\\Models\\Receipt',4630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',9736.22,NULL,NULL,1,'2021-12-21 10:55:30','2021-12-21 10:55:30',NULL),(4880,3117,40922,15474,3,4656,'App\\Models\\Receipt',4656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',7864.94,NULL,NULL,1,'2021-12-21 10:57:44','2021-12-21 10:57:44',NULL),(4881,3117,40922,15474,3,4644,'App\\Models\\Receipt',4644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',8813.05,NULL,NULL,1,'2021-12-21 11:00:45','2021-12-21 11:00:45',NULL),(4882,3117,40922,15474,3,4643,'App\\Models\\Receipt',4643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',10874.47,NULL,NULL,1,'2021-12-21 11:01:30','2021-12-21 11:01:30',NULL),(4883,3117,40922,15474,3,4653,'App\\Models\\Receipt',4653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',9530.75,NULL,NULL,1,'2021-12-21 11:02:01','2021-12-21 11:02:01',NULL),(4884,3117,40922,15467,2,4671,'App\\Models\\Receipt',4671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',5000.00,NULL,NULL,1,'2021-12-23 10:17:44','2021-12-23 10:17:44',NULL),(4885,3117,40922,15467,2,4672,'App\\Models\\Receipt',4672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',1000.00,NULL,NULL,1,'2021-12-23 10:17:44','2021-12-23 10:17:44',NULL),(4886,3117,40922,15467,2,4673,'App\\Models\\Receipt',4673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',906.00,NULL,NULL,1,'2021-12-23 10:17:44','2021-12-23 10:17:44',NULL),(4887,3117,40922,15467,2,4674,'App\\Models\\Receipt',4674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',2336.00,NULL,NULL,1,'2021-12-23 10:17:44','2021-12-23 10:17:44',NULL),(4888,3117,40922,15467,2,4675,'App\\Models\\Receipt',4675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',6000.00,NULL,NULL,1,'2021-12-23 10:17:44','2021-12-23 10:17:44',NULL),(4889,3117,40922,15467,2,4676,'App\\Models\\Receipt',4676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',2994.00,NULL,NULL,1,'2021-12-23 10:17:44','2021-12-23 10:17:44',NULL);
INSERT INTO `balance_libro` VALUES (4890,3117,40922,15467,2,4677,'App\\Models\\Receipt',4677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',1900.00,NULL,NULL,1,'2021-12-23 10:17:44','2021-12-23 10:17:44',NULL),(4891,3117,40922,15467,2,4678,'App\\Models\\Receipt',4678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',6000.00,NULL,NULL,1,'2021-12-23 10:17:44','2021-12-23 10:17:44',NULL),(4892,3117,40922,15467,2,4679,'App\\Models\\Receipt',4679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',2000.00,NULL,NULL,1,'2021-12-23 10:17:44','2021-12-23 10:17:44',NULL),(4893,3117,40922,15467,2,4680,'App\\Models\\Receipt',4680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',6000.00,NULL,NULL,1,'2021-12-23 10:17:44','2021-12-23 10:17:44',NULL),(4894,3117,40922,15467,2,4681,'App\\Models\\Receipt',4681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',6000.00,NULL,NULL,1,'2021-12-23 10:17:44','2021-12-23 10:17:44',NULL),(4895,3117,40922,15467,2,4682,'App\\Models\\Receipt',4682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',6762.00,NULL,NULL,1,'2021-12-23 10:17:44','2021-12-23 10:17:44',NULL),(4896,3117,40922,15467,2,4683,'App\\Models\\Receipt',4683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-02','2021-04-02',1000.00,NULL,NULL,1,'2021-12-23 10:17:44','2021-12-23 10:17:44',NULL),(4897,3117,40922,15467,2,4684,'App\\Models\\Receipt',4684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',1000.00,NULL,NULL,1,'2021-12-23 10:17:44','2021-12-23 10:17:44',NULL),(4898,3117,40922,15467,2,4685,'App\\Models\\Receipt',4685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-04','2021-04-04',1815.00,NULL,NULL,1,'2021-12-23 10:17:45','2021-12-23 10:17:45',NULL),(4899,3117,40922,15467,2,4686,'App\\Models\\Receipt',4686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',6500.00,NULL,NULL,1,'2021-12-23 10:17:45','2021-12-23 10:17:45',NULL),(4900,3117,40922,15467,2,4687,'App\\Models\\Receipt',4687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',6500.00,NULL,NULL,1,'2021-12-23 10:17:45','2021-12-23 10:17:45',NULL),(4901,3117,40922,15467,2,4688,'App\\Models\\Receipt',4688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',6500.00,NULL,NULL,1,'2021-12-23 10:17:45','2021-12-23 10:17:45',NULL),(4902,3117,40922,15467,2,4689,'App\\Models\\Receipt',4689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',6500.00,NULL,NULL,1,'2021-12-23 10:17:45','2021-12-23 10:17:45',NULL),(4903,3117,40922,15467,2,4690,'App\\Models\\Receipt',4690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',1762.00,NULL,NULL,1,'2021-12-23 10:17:45','2021-12-23 10:17:45',NULL),(4904,3117,40922,15467,2,4691,'App\\Models\\Receipt',4691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2021-12-23 10:17:45','2021-12-23 10:17:45',NULL),(4905,3117,40922,15469,2,4692,'App\\Models\\Receipt',4692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',595.00,NULL,NULL,1,'2021-12-23 10:20:14','2021-12-23 10:20:14',NULL),(4906,3117,40922,15469,2,4693,'App\\Models\\Receipt',4693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',2323.00,NULL,NULL,1,'2021-12-23 10:20:14','2021-12-23 10:20:14',NULL),(4907,3117,40922,15469,2,4694,'App\\Models\\Receipt',4694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',10000.00,NULL,NULL,1,'2021-12-23 10:20:14','2021-12-23 10:20:14',NULL),(4908,3117,40922,15469,2,4695,'App\\Models\\Receipt',4695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',10000.00,NULL,NULL,1,'2021-12-23 10:20:14','2021-12-23 10:20:14',NULL),(4909,3117,40922,15469,2,4696,'App\\Models\\Receipt',4696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',10000.00,NULL,NULL,1,'2021-12-23 10:20:14','2021-12-23 10:20:14',NULL),(4910,3117,40922,15469,2,4697,'App\\Models\\Receipt',4697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',4500.00,NULL,NULL,1,'2021-12-23 10:20:14','2021-12-23 10:20:14',NULL);
INSERT INTO `balance_libro` VALUES (4911,3117,40922,15469,2,4698,'App\\Models\\Receipt',4698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',3523.00,NULL,NULL,1,'2021-12-23 10:20:14','2021-12-23 10:20:14',NULL),(4912,3117,40922,15469,2,4699,'App\\Models\\Receipt',4699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',900.00,NULL,NULL,1,'2021-12-23 10:20:14','2021-12-23 10:20:14',NULL),(4913,3117,40922,15469,2,4700,'App\\Models\\Receipt',4700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',1289.00,NULL,NULL,1,'2021-12-23 10:20:15','2021-12-23 10:20:15',NULL),(4914,3117,40922,15469,2,4701,'App\\Models\\Receipt',4701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',810.00,NULL,NULL,1,'2021-12-23 10:20:15','2021-12-23 10:20:15',NULL),(4915,3117,40922,15469,2,4702,'App\\Models\\Receipt',4702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',1244.00,NULL,NULL,1,'2021-12-23 10:20:15','2021-12-23 10:20:15',NULL),(4916,3117,40922,15469,2,4703,'App\\Models\\Receipt',4703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',2600.00,NULL,NULL,1,'2021-12-23 10:20:15','2021-12-23 10:20:15',NULL),(4917,3117,40922,15469,2,4704,'App\\Models\\Receipt',4704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',900.00,NULL,NULL,1,'2021-12-23 10:20:15','2021-12-23 10:20:15',NULL),(4918,3117,40922,15469,2,4705,'App\\Models\\Receipt',4705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',6500.00,NULL,NULL,1,'2021-12-23 10:20:15','2021-12-23 10:20:15',NULL),(4919,3117,40922,15469,2,4706,'App\\Models\\Receipt',4706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',6500.00,NULL,NULL,1,'2021-12-23 10:20:15','2021-12-23 10:20:15',NULL),(4920,3117,40922,15469,2,4707,'App\\Models\\Receipt',4707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',6500.00,NULL,NULL,1,'2021-12-23 10:20:15','2021-12-23 10:20:15',NULL),(4921,3117,40922,15469,2,4708,'App\\Models\\Receipt',4708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',6500.00,NULL,NULL,1,'2021-12-23 10:20:15','2021-12-23 10:20:15',NULL),(4922,3117,40922,15469,2,4709,'App\\Models\\Receipt',4709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',2900.00,NULL,NULL,1,'2021-12-23 10:20:15','2021-12-23 10:20:15',NULL),(4923,3117,40922,15469,2,4710,'App\\Models\\Receipt',4710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',6500.00,NULL,NULL,1,'2021-12-23 10:20:15','2021-12-23 10:20:15',NULL),(4924,3117,40922,15469,2,4711,'App\\Models\\Receipt',4711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',6500.00,NULL,NULL,1,'2021-12-23 10:20:15','2021-12-23 10:20:15',NULL),(4925,3117,40922,15469,2,4712,'App\\Models\\Receipt',4712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',6500.00,NULL,NULL,1,'2021-12-23 10:20:15','2021-12-23 10:20:15',NULL),(4926,3117,40922,15469,2,4713,'App\\Models\\Receipt',4713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',649.00,NULL,NULL,1,'2021-12-23 10:20:15','2021-12-23 10:20:15',NULL),(4927,3117,40922,15469,2,4714,'App\\Models\\Receipt',4714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',6500.00,NULL,NULL,1,'2021-12-23 10:20:15','2021-12-23 10:20:15',NULL),(4928,3117,40922,15469,2,4715,'App\\Models\\Receipt',4715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',5500.00,NULL,NULL,1,'2021-12-23 10:20:15','2021-12-23 10:20:15',NULL),(4929,3117,40922,15469,2,4716,'App\\Models\\Receipt',4716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',1129.00,NULL,NULL,1,'2021-12-23 10:20:15','2021-12-23 10:20:15',NULL),(4930,3117,40922,15469,2,4717,'App\\Models\\Receipt',4717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',1707.00,NULL,NULL,1,'2021-12-23 10:20:15','2021-12-23 10:20:15',NULL),(4931,3117,40922,15469,2,4718,'App\\Models\\Receipt',4718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',1289.00,NULL,NULL,1,'2021-12-23 10:20:15','2021-12-23 10:20:15',NULL);
INSERT INTO `balance_libro` VALUES (4932,3117,40922,15469,2,4719,'App\\Models\\Receipt',4719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',1474.00,NULL,NULL,1,'2021-12-23 10:20:15','2021-12-23 10:20:15',NULL),(4933,3117,40922,15469,2,4720,'App\\Models\\Receipt',4720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',1000.00,NULL,NULL,1,'2021-12-23 10:20:15','2021-12-23 10:20:15',NULL),(4934,3117,40922,15469,2,4721,'App\\Models\\Receipt',4721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',1974.00,NULL,NULL,1,'2021-12-23 10:20:15','2021-12-23 10:20:15',NULL),(4935,3117,40922,15469,2,4722,'App\\Models\\Receipt',4722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',1350.00,NULL,NULL,1,'2021-12-23 10:20:15','2021-12-23 10:20:15',NULL),(4936,3117,40922,15469,2,4723,'App\\Models\\Receipt',4723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',1806.00,NULL,NULL,1,'2021-12-23 10:20:15','2021-12-23 10:20:15',NULL),(4937,3117,40922,15469,2,4724,'App\\Models\\Receipt',4724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',1410.00,NULL,NULL,1,'2021-12-23 10:20:15','2021-12-23 10:20:15',NULL),(4938,3117,40922,15469,2,4725,'App\\Models\\Receipt',4725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',3755.00,NULL,NULL,1,'2021-12-23 10:20:15','2021-12-23 10:20:15',NULL),(4939,3117,40922,15469,2,4726,'App\\Models\\Receipt',4726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',980.00,NULL,NULL,1,'2021-12-23 10:20:15','2021-12-23 10:20:15',NULL),(4940,3117,40922,15469,2,4727,'App\\Models\\Receipt',4727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',987.00,NULL,NULL,1,'2021-12-23 10:20:15','2021-12-23 10:20:15',NULL),(4941,3117,40922,15469,2,4728,'App\\Models\\Receipt',4728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',595.00,NULL,NULL,1,'2021-12-23 10:20:15','2021-12-23 10:20:15',NULL),(4942,3117,40922,15469,2,4729,'App\\Models\\Receipt',4729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',1000.00,NULL,NULL,1,'2021-12-23 10:20:15','2021-12-23 10:20:15',NULL),(4943,3117,40922,15469,2,4730,'App\\Models\\Receipt',4730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',386.00,NULL,NULL,1,'2021-12-23 10:20:15','2021-12-23 10:20:15',NULL),(4944,3117,40922,15469,2,4731,'App\\Models\\Receipt',4731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',1954.00,NULL,NULL,1,'2021-12-23 10:20:15','2021-12-23 10:20:15',NULL),(4945,3117,40922,15469,2,4732,'App\\Models\\Receipt',4732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',1000.00,NULL,NULL,1,'2021-12-23 10:20:15','2021-12-23 10:20:15',NULL),(4946,3117,40922,15469,2,4733,'App\\Models\\Receipt',4733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',1747.00,NULL,NULL,1,'2021-12-23 10:20:15','2021-12-23 10:20:15',NULL),(4947,3117,40922,15469,2,4734,'App\\Models\\Receipt',4734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',500.00,NULL,NULL,1,'2021-12-23 10:20:15','2021-12-23 10:20:15',NULL),(4948,3117,40922,15469,2,4735,'App\\Models\\Receipt',4735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',4000.00,NULL,NULL,1,'2021-12-23 10:20:15','2021-12-23 10:20:15',NULL),(4949,3117,40922,15469,2,4736,'App\\Models\\Receipt',4736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',2602.00,NULL,NULL,1,'2021-12-23 10:20:16','2021-12-23 10:20:16',NULL),(4950,3117,40922,15469,2,4737,'App\\Models\\Receipt',4737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',552.00,NULL,NULL,1,'2021-12-23 10:20:16','2021-12-23 10:20:16',NULL),(4951,3117,40922,15469,2,4738,'App\\Models\\Receipt',4738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',968.00,NULL,NULL,1,'2021-12-23 10:20:16','2021-12-23 10:20:16',NULL),(4952,3117,40922,15469,2,4739,'App\\Models\\Receipt',4739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',350.00,NULL,NULL,1,'2021-12-23 10:20:16','2021-12-23 10:20:16',NULL);
INSERT INTO `balance_libro` VALUES (4953,3117,40922,15469,2,4740,'App\\Models\\Receipt',4740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',234.00,NULL,NULL,1,'2021-12-23 10:20:16','2021-12-23 10:20:16',NULL),(4954,3117,40922,15469,2,4741,'App\\Models\\Receipt',4741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',690.00,NULL,NULL,1,'2021-12-23 10:20:16','2021-12-23 10:20:16',NULL),(4955,3117,40922,15469,2,4742,'App\\Models\\Receipt',4742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',9000.00,NULL,NULL,1,'2021-12-23 10:20:16','2021-12-23 10:20:16',NULL),(4956,3117,40922,15469,2,4743,'App\\Models\\Receipt',4743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',772.00,NULL,NULL,1,'2021-12-23 10:20:16','2021-12-23 10:20:16',NULL),(4957,3117,40922,15469,2,4744,'App\\Models\\Receipt',4744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',9000.00,NULL,NULL,1,'2021-12-23 10:20:16','2021-12-23 10:20:16',NULL),(4958,3117,40922,15469,2,4745,'App\\Models\\Receipt',4745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',1091.00,NULL,NULL,1,'2021-12-23 10:20:16','2021-12-23 10:20:16',NULL),(4959,3117,40922,15469,2,4746,'App\\Models\\Receipt',4746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',873.00,NULL,NULL,1,'2021-12-23 10:20:16','2021-12-23 10:20:16',NULL),(4960,3117,40922,15469,2,4747,'App\\Models\\Receipt',4747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',805.00,NULL,NULL,1,'2021-12-23 10:20:16','2021-12-23 10:20:16',NULL),(4961,3117,40922,15469,2,4748,'App\\Models\\Receipt',4748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',202.00,NULL,NULL,1,'2021-12-23 10:20:16','2021-12-23 10:20:16',NULL),(4962,3117,40922,15469,2,4749,'App\\Models\\Receipt',4749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-20','2021-06-20',2509.00,NULL,NULL,1,'2021-12-23 10:20:16','2021-12-23 10:20:16',NULL),(4963,3117,40922,15469,2,4750,'App\\Models\\Receipt',4750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-20','2021-06-20',850.00,NULL,NULL,1,'2021-12-23 10:20:16','2021-12-23 10:20:16',NULL),(4964,3117,40922,15469,2,4751,'App\\Models\\Receipt',4751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',370.00,NULL,NULL,1,'2021-12-23 10:20:16','2021-12-23 10:20:16',NULL),(4965,3117,40922,15469,2,4752,'App\\Models\\Receipt',4752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',463.00,NULL,NULL,1,'2021-12-23 10:20:16','2021-12-23 10:20:16',NULL),(4966,3117,40922,15469,2,4753,'App\\Models\\Receipt',4753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',919.00,NULL,NULL,1,'2021-12-23 10:20:16','2021-12-23 10:20:16',NULL),(4967,3117,40922,15469,2,4754,'App\\Models\\Receipt',4754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',953.00,NULL,NULL,1,'2021-12-23 10:20:16','2021-12-23 10:20:16',NULL),(4968,3117,40922,15469,2,4755,'App\\Models\\Receipt',4755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',437.00,NULL,NULL,1,'2021-12-23 10:20:16','2021-12-23 10:20:16',NULL),(4969,3117,40922,15469,2,4756,'App\\Models\\Receipt',4756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',1260.00,NULL,NULL,1,'2021-12-23 10:20:16','2021-12-23 10:20:16',NULL),(4970,3117,40922,15469,2,4757,'App\\Models\\Receipt',4757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',3667.00,NULL,NULL,1,'2021-12-23 10:20:16','2021-12-23 10:20:16',NULL),(4971,3117,40922,15469,2,4758,'App\\Models\\Receipt',4758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',565.00,NULL,NULL,1,'2021-12-23 10:20:16','2021-12-23 10:20:16',NULL),(4972,3117,40922,15469,2,4759,'App\\Models\\Receipt',4759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',4941.00,NULL,NULL,1,'2021-12-23 10:20:16','2021-12-23 10:20:16',NULL),(4973,3117,40922,15469,2,4760,'App\\Models\\Receipt',4760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',530.00,NULL,NULL,1,'2021-12-23 10:20:16','2021-12-23 10:20:16',NULL);
INSERT INTO `balance_libro` VALUES (4974,3117,40922,15469,2,4761,'App\\Models\\Receipt',4761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',520.00,NULL,NULL,1,'2021-12-23 10:20:16','2021-12-23 10:20:16',NULL),(4975,3117,40922,15469,2,4762,'App\\Models\\Receipt',4762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',10000.00,NULL,NULL,1,'2021-12-23 10:20:16','2021-12-23 10:20:16',NULL),(4976,3117,40922,15469,2,4763,'App\\Models\\Receipt',4763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',1627.00,NULL,NULL,1,'2021-12-23 10:20:16','2021-12-23 10:20:16',NULL),(4977,3117,40922,15469,2,4764,'App\\Models\\Receipt',4764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',298.00,NULL,NULL,1,'2021-12-23 10:20:16','2021-12-23 10:20:16',NULL),(4978,3117,40922,15469,2,4765,'App\\Models\\Receipt',4765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',457.00,NULL,NULL,1,'2021-12-23 10:20:16','2021-12-23 10:20:16',NULL),(4979,3117,40922,15469,2,4766,'App\\Models\\Receipt',4766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',759.00,NULL,NULL,1,'2021-12-23 10:20:16','2021-12-23 10:20:16',NULL),(4980,3117,40922,15469,2,4767,'App\\Models\\Receipt',4767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',1000.00,NULL,NULL,1,'2021-12-23 10:20:17','2021-12-23 10:20:17',NULL),(4981,3117,40922,15469,2,4768,'App\\Models\\Receipt',4768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',5500.00,NULL,NULL,1,'2021-12-23 10:20:17','2021-12-23 10:20:17',NULL),(4982,3117,40922,15469,2,4769,'App\\Models\\Receipt',4769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',447.00,NULL,NULL,1,'2021-12-23 10:20:17','2021-12-23 10:20:17',NULL),(4983,3117,40922,15469,2,4770,'App\\Models\\Receipt',4770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',411.00,NULL,NULL,1,'2021-12-23 10:20:17','2021-12-23 10:20:17',NULL),(4984,3117,40922,15469,2,4771,'App\\Models\\Receipt',4771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',253.00,NULL,NULL,1,'2021-12-23 10:20:17','2021-12-23 10:20:17',NULL),(4985,3117,40922,15469,2,4772,'App\\Models\\Receipt',4772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',6500.00,NULL,NULL,1,'2021-12-23 10:20:17','2021-12-23 10:20:17',NULL),(4986,3117,40922,15469,2,4773,'App\\Models\\Receipt',4773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',1376.00,NULL,NULL,1,'2021-12-23 10:20:17','2021-12-23 10:20:17',NULL),(4987,3117,40922,15469,2,4774,'App\\Models\\Receipt',4774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',1366.00,NULL,NULL,1,'2021-12-23 10:20:17','2021-12-23 10:20:17',NULL),(4988,3117,40922,15469,2,4775,'App\\Models\\Receipt',4775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',1063.00,NULL,NULL,1,'2021-12-23 10:20:17','2021-12-23 10:20:17',NULL),(4989,3117,40922,15469,2,4776,'App\\Models\\Receipt',4776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',212.00,NULL,NULL,1,'2021-12-23 10:20:17','2021-12-23 10:20:17',NULL),(4990,3117,40922,15469,2,4777,'App\\Models\\Receipt',4777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',5000.00,NULL,NULL,1,'2021-12-23 10:20:17','2021-12-23 10:20:17',NULL),(4991,3117,40922,15469,2,4778,'App\\Models\\Receipt',4778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',2071.00,NULL,NULL,1,'2021-12-23 10:20:17','2021-12-23 10:20:17',NULL),(4992,3117,40922,15469,2,4779,'App\\Models\\Receipt',4779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',763.00,NULL,NULL,1,'2021-12-23 10:20:17','2021-12-23 10:20:17',NULL),(4993,3117,40922,15469,2,4780,'App\\Models\\Receipt',4780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',500.00,NULL,NULL,1,'2021-12-23 10:20:17','2021-12-23 10:20:17',NULL),(4994,3117,40922,15469,2,4781,'App\\Models\\Receipt',4781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',371.00,NULL,NULL,1,'2021-12-23 10:20:17','2021-12-23 10:20:17',NULL);
INSERT INTO `balance_libro` VALUES (4995,3117,40922,15469,2,4782,'App\\Models\\Receipt',4782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',902.00,NULL,NULL,1,'2021-12-23 10:20:17','2021-12-23 10:20:17',NULL),(4996,3117,40922,15469,2,4783,'App\\Models\\Receipt',4783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',10000.00,NULL,NULL,1,'2021-12-23 10:20:17','2021-12-23 10:20:17',NULL),(4997,3117,40922,15469,2,4784,'App\\Models\\Receipt',4784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',259.00,NULL,NULL,1,'2021-12-23 10:20:17','2021-12-23 10:20:17',NULL),(4998,3117,40922,15469,2,4785,'App\\Models\\Receipt',4785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',1096.00,NULL,NULL,1,'2021-12-23 10:20:18','2021-12-23 10:20:18',NULL),(4999,3117,40922,15469,2,4786,'App\\Models\\Receipt',4786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',620.00,NULL,NULL,1,'2021-12-23 10:20:18','2021-12-23 10:20:18',NULL),(5000,3117,40922,15469,2,4787,'App\\Models\\Receipt',4787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',10000.00,NULL,NULL,1,'2021-12-23 10:20:18','2021-12-23 10:20:18',NULL),(5001,3117,40922,15470,2,4788,'App\\Models\\Receipt',4788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',1000.00,NULL,NULL,1,'2021-12-23 10:22:34','2021-12-23 10:22:34',NULL),(5002,3117,40922,15470,2,4789,'App\\Models\\Receipt',4789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',404.00,NULL,NULL,1,'2021-12-23 10:22:34','2021-12-23 10:22:34',NULL),(5003,3117,40922,15470,2,4790,'App\\Models\\Receipt',4790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',2329.00,NULL,NULL,1,'2021-12-23 10:22:34','2021-12-23 10:22:34',NULL),(5004,3117,40922,15470,2,4791,'App\\Models\\Receipt',4791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',7000.00,NULL,NULL,1,'2021-12-23 10:22:34','2021-12-23 10:22:34',NULL),(5005,3117,40922,15470,2,4792,'App\\Models\\Receipt',4792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',6500.00,NULL,NULL,1,'2021-12-23 10:22:34','2021-12-23 10:22:34',NULL),(5006,3117,40922,15470,2,4793,'App\\Models\\Receipt',4793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',6500.00,NULL,NULL,1,'2021-12-23 10:22:34','2021-12-23 10:22:34',NULL),(5007,3117,40922,15470,2,4794,'App\\Models\\Receipt',4794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',311.00,NULL,NULL,1,'2021-12-23 10:22:34','2021-12-23 10:22:34',NULL),(5008,3117,40922,15470,2,4795,'App\\Models\\Receipt',4795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',570.00,NULL,NULL,1,'2021-12-23 10:22:34','2021-12-23 10:22:34',NULL),(5009,3117,40922,15470,2,4796,'App\\Models\\Receipt',4796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',1759.00,NULL,NULL,1,'2021-12-23 10:22:34','2021-12-23 10:22:34',NULL),(5010,3117,40922,15470,2,4797,'App\\Models\\Receipt',4797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',1486.00,NULL,NULL,1,'2021-12-23 10:22:34','2021-12-23 10:22:34',NULL),(5011,3117,40922,15470,2,4798,'App\\Models\\Receipt',4798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',500.00,NULL,NULL,1,'2021-12-23 10:22:34','2021-12-23 10:22:34',NULL),(5012,3117,40922,15470,2,4799,'App\\Models\\Receipt',4799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',282.00,NULL,NULL,1,'2021-12-23 10:22:34','2021-12-23 10:22:34',NULL),(5013,3117,40922,15470,2,4800,'App\\Models\\Receipt',4800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',689.00,NULL,NULL,1,'2021-12-23 10:22:34','2021-12-23 10:22:34',NULL),(5014,3117,40922,15470,2,4801,'App\\Models\\Receipt',4801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',2033.00,NULL,NULL,1,'2021-12-23 10:22:34','2021-12-23 10:22:34',NULL),(5015,3117,40922,15470,2,4802,'App\\Models\\Receipt',4802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',882.00,NULL,NULL,1,'2021-12-23 10:22:34','2021-12-23 10:22:34',NULL);
INSERT INTO `balance_libro` VALUES (5016,3117,40922,15470,2,4803,'App\\Models\\Receipt',4803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',10000.00,NULL,NULL,1,'2021-12-23 10:22:34','2021-12-23 10:22:34',NULL),(5017,3117,40922,15470,2,4804,'App\\Models\\Receipt',4804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',2427.00,NULL,NULL,1,'2021-12-23 10:22:34','2021-12-23 10:22:34',NULL),(5018,3117,40922,15470,2,4805,'App\\Models\\Receipt',4805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',9800.00,NULL,NULL,1,'2021-12-23 10:22:34','2021-12-23 10:22:34',NULL),(5019,3117,40922,15470,2,4806,'App\\Models\\Receipt',4806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',10000.00,NULL,NULL,1,'2021-12-23 10:22:34','2021-12-23 10:22:34',NULL),(5020,3117,40922,15470,2,4807,'App\\Models\\Receipt',4807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',5000.00,NULL,NULL,1,'2021-12-23 10:22:34','2021-12-23 10:22:34',NULL),(5021,3117,40922,15470,2,4808,'App\\Models\\Receipt',4808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',1814.00,NULL,NULL,1,'2021-12-23 10:22:34','2021-12-23 10:22:34',NULL),(5022,3117,40922,15470,2,4809,'App\\Models\\Receipt',4809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',705.00,NULL,NULL,1,'2021-12-23 10:22:34','2021-12-23 10:22:34',NULL),(5023,3117,40922,15470,2,4810,'App\\Models\\Receipt',4810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',1728.00,NULL,NULL,1,'2021-12-23 10:22:34','2021-12-23 10:22:34',NULL),(5024,3117,40922,15470,2,4811,'App\\Models\\Receipt',4811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',2000.00,NULL,NULL,1,'2021-12-23 10:22:34','2021-12-23 10:22:34',NULL),(5025,3117,40922,15470,2,4812,'App\\Models\\Receipt',4812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',1000.00,NULL,NULL,1,'2021-12-23 10:22:35','2021-12-23 10:22:35',NULL),(5026,3117,40922,15470,2,4813,'App\\Models\\Receipt',4813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',1131.00,NULL,NULL,1,'2021-12-23 10:22:35','2021-12-23 10:22:35',NULL),(5027,3117,40922,15470,2,4814,'App\\Models\\Receipt',4814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',8100.00,NULL,NULL,1,'2021-12-23 10:22:35','2021-12-23 10:22:35',NULL),(5028,3117,40922,15470,2,4815,'App\\Models\\Receipt',4815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',597.00,NULL,NULL,1,'2021-12-23 10:22:35','2021-12-23 10:22:35',NULL),(5029,3117,40922,15470,2,4816,'App\\Models\\Receipt',4816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1177.00,NULL,NULL,1,'2021-12-23 10:22:35','2021-12-23 10:22:35',NULL),(5030,3117,40922,15470,2,4817,'App\\Models\\Receipt',4817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',5176.00,NULL,NULL,1,'2021-12-23 10:22:35','2021-12-23 10:22:35',NULL),(5031,3117,40922,15470,2,4818,'App\\Models\\Receipt',4818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',959.00,NULL,NULL,1,'2021-12-23 10:22:35','2021-12-23 10:22:35',NULL),(5032,3117,40922,15470,2,4819,'App\\Models\\Receipt',4819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',1534.00,NULL,NULL,1,'2021-12-23 10:22:35','2021-12-23 10:22:35',NULL),(5033,3117,40922,15470,2,4820,'App\\Models\\Receipt',4820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',1114.00,NULL,NULL,1,'2021-12-23 10:22:35','2021-12-23 10:22:35',NULL),(5034,3117,40922,15470,2,4821,'App\\Models\\Receipt',4821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',9000.00,NULL,NULL,1,'2021-12-23 10:22:35','2021-12-23 10:22:35',NULL),(5035,3117,40922,15470,2,4822,'App\\Models\\Receipt',4822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',1838.00,NULL,NULL,1,'2021-12-23 10:22:35','2021-12-23 10:22:35',NULL),(5036,3117,40922,15470,2,4823,'App\\Models\\Receipt',4823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',2130.00,NULL,NULL,1,'2021-12-23 10:22:35','2021-12-23 10:22:35',NULL);
INSERT INTO `balance_libro` VALUES (5037,3117,40922,15470,2,4824,'App\\Models\\Receipt',4824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',915.00,NULL,NULL,1,'2021-12-23 10:22:35','2021-12-23 10:22:35',NULL),(5038,3117,40922,15470,2,4825,'App\\Models\\Receipt',4825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',678.00,NULL,NULL,1,'2021-12-23 10:22:35','2021-12-23 10:22:35',NULL),(5039,3117,40922,15470,2,4826,'App\\Models\\Receipt',4826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',1200.00,NULL,NULL,1,'2021-12-23 10:22:35','2021-12-23 10:22:35',NULL),(5040,3117,40922,15470,2,4827,'App\\Models\\Receipt',4827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',700.00,NULL,NULL,1,'2021-12-23 10:22:35','2021-12-23 10:22:35',NULL),(5041,3117,40922,15470,2,4828,'App\\Models\\Receipt',4828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',2000.00,NULL,NULL,1,'2021-12-23 10:22:35','2021-12-23 10:22:35',NULL),(5042,3117,40922,15470,2,4829,'App\\Models\\Receipt',4829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',1200.00,NULL,NULL,1,'2021-12-23 10:22:35','2021-12-23 10:22:35',NULL),(5043,3117,40922,15470,2,4830,'App\\Models\\Receipt',4830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',814.00,NULL,NULL,1,'2021-12-23 10:22:35','2021-12-23 10:22:35',NULL),(5044,3117,40922,15470,2,4831,'App\\Models\\Receipt',4831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',378.00,NULL,NULL,1,'2021-12-23 10:22:35','2021-12-23 10:22:35',NULL),(5045,3117,40922,15470,2,4832,'App\\Models\\Receipt',4832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',705.00,NULL,NULL,1,'2021-12-23 10:22:35','2021-12-23 10:22:35',NULL),(5046,3117,40922,15470,2,4833,'App\\Models\\Receipt',4833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',1200.00,NULL,NULL,1,'2021-12-23 10:22:35','2021-12-23 10:22:35',NULL),(5047,3117,40922,15470,2,4834,'App\\Models\\Receipt',4834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',386.00,NULL,NULL,1,'2021-12-23 10:22:35','2021-12-23 10:22:35',NULL),(5048,3117,40922,15470,2,4835,'App\\Models\\Receipt',4835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',9206.00,NULL,NULL,1,'2021-12-23 10:22:35','2021-12-23 10:22:35',NULL),(5049,3117,40922,15470,2,4836,'App\\Models\\Receipt',4836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',1956.00,NULL,NULL,1,'2021-12-23 10:22:36','2021-12-23 10:22:36',NULL),(5050,3117,40922,15470,2,4837,'App\\Models\\Receipt',4837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',3545.00,NULL,NULL,1,'2021-12-23 10:22:36','2021-12-23 10:22:36',NULL),(5051,3117,40922,15470,2,4838,'App\\Models\\Receipt',4838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',10000.00,NULL,NULL,1,'2021-12-23 10:22:36','2021-12-23 10:22:36',NULL),(5052,3117,40922,15470,2,4839,'App\\Models\\Receipt',4839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',512.00,NULL,NULL,1,'2021-12-23 10:22:36','2021-12-23 10:22:36',NULL),(5053,3117,40922,15470,2,4840,'App\\Models\\Receipt',4840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',5000.00,NULL,NULL,1,'2021-12-23 10:22:36','2021-12-23 10:22:36',NULL),(5054,3117,40922,15470,2,4841,'App\\Models\\Receipt',4841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',10000.00,NULL,NULL,1,'2021-12-23 10:22:36','2021-12-23 10:22:36',NULL),(5055,3117,40922,15470,2,4842,'App\\Models\\Receipt',4842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',10000.00,NULL,NULL,1,'2021-12-23 10:22:36','2021-12-23 10:22:36',NULL),(5056,3117,40922,15470,2,4843,'App\\Models\\Receipt',4843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',493.00,NULL,NULL,1,'2021-12-23 10:22:36','2021-12-23 10:22:36',NULL),(5057,3117,40922,15470,2,4844,'App\\Models\\Receipt',4844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',10000.00,NULL,NULL,1,'2021-12-23 10:22:36','2021-12-23 10:22:36',NULL);
INSERT INTO `balance_libro` VALUES (5058,3117,40922,15470,2,4845,'App\\Models\\Receipt',4845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',480.00,NULL,NULL,1,'2021-12-23 10:22:36','2021-12-23 10:22:36',NULL),(5059,3117,40922,15470,2,4846,'App\\Models\\Receipt',4846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',10000.00,NULL,NULL,1,'2021-12-23 10:22:36','2021-12-23 10:22:36',NULL),(5060,3117,40922,15470,2,4847,'App\\Models\\Receipt',4847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',10000.00,NULL,NULL,1,'2021-12-23 10:22:36','2021-12-23 10:22:36',NULL),(5061,3117,40922,15471,2,4848,'App\\Models\\Receipt',4848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',1000.00,NULL,NULL,1,'2021-12-23 10:23:10','2021-12-23 10:23:10',NULL),(5062,3117,40922,15471,2,4849,'App\\Models\\Receipt',4849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',2709.00,NULL,NULL,1,'2021-12-23 10:23:10','2021-12-23 10:23:10',NULL),(5063,3117,40922,15471,2,4850,'App\\Models\\Receipt',4850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',1059.00,NULL,NULL,1,'2021-12-23 10:23:10','2021-12-23 10:23:10',NULL),(5064,3117,40922,15471,2,4851,'App\\Models\\Receipt',4851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',205.00,NULL,NULL,1,'2021-12-23 10:23:10','2021-12-23 10:23:10',NULL),(5065,3117,40922,15471,2,4852,'App\\Models\\Receipt',4852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',300.00,NULL,NULL,1,'2021-12-23 10:23:10','2021-12-23 10:23:10',NULL),(5066,3117,40922,15471,2,4853,'App\\Models\\Receipt',4853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',1035.00,NULL,NULL,1,'2021-12-23 10:23:10','2021-12-23 10:23:10',NULL),(5067,3117,40922,15471,2,4854,'App\\Models\\Receipt',4854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',2080.00,NULL,NULL,1,'2021-12-23 10:23:10','2021-12-23 10:23:10',NULL),(5068,3117,40922,15471,2,4855,'App\\Models\\Receipt',4855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',10000.00,NULL,NULL,1,'2021-12-23 10:23:10','2021-12-23 10:23:10',NULL),(5069,3117,40922,15471,2,4856,'App\\Models\\Receipt',4856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',10000.00,NULL,NULL,1,'2021-12-23 10:23:10','2021-12-23 10:23:10',NULL),(5070,3117,40922,15471,2,4857,'App\\Models\\Receipt',4857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',700.00,NULL,NULL,1,'2021-12-23 10:23:10','2021-12-23 10:23:10',NULL),(5071,3117,40922,15471,2,4858,'App\\Models\\Receipt',4858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',1042.00,NULL,NULL,1,'2021-12-23 10:23:10','2021-12-23 10:23:10',NULL),(5072,3117,40922,15471,2,4859,'App\\Models\\Receipt',4859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',1500.00,NULL,NULL,1,'2021-12-23 10:23:10','2021-12-23 10:23:10',NULL),(5073,3117,40922,15471,2,4860,'App\\Models\\Receipt',4860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',10000.00,NULL,NULL,1,'2021-12-23 10:23:10','2021-12-23 10:23:10',NULL),(5074,3117,40922,15471,2,4861,'App\\Models\\Receipt',4861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',10000.00,NULL,NULL,1,'2021-12-23 10:23:11','2021-12-23 10:23:11',NULL),(5075,3117,40922,15471,2,4862,'App\\Models\\Receipt',4862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',10000.00,NULL,NULL,1,'2021-12-23 10:23:11','2021-12-23 10:23:11',NULL),(5076,3117,40922,15471,2,4863,'App\\Models\\Receipt',4863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',3873.00,NULL,NULL,1,'2021-12-23 10:23:11','2021-12-23 10:23:11',NULL),(5077,3117,40922,15471,2,4864,'App\\Models\\Receipt',4864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',670.00,NULL,NULL,1,'2021-12-23 10:23:11','2021-12-23 10:23:11',NULL),(5078,3117,40922,15471,2,4865,'App\\Models\\Receipt',4865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',745.00,NULL,NULL,1,'2021-12-23 10:23:11','2021-12-23 10:23:11',NULL);
INSERT INTO `balance_libro` VALUES (5079,3117,40922,15471,2,4866,'App\\Models\\Receipt',4866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',847.00,NULL,NULL,1,'2021-12-23 10:23:11','2021-12-23 10:23:11',NULL),(5080,3117,40922,15471,2,4867,'App\\Models\\Receipt',4867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',982.00,NULL,NULL,1,'2021-12-23 10:23:11','2021-12-23 10:23:11',NULL),(5081,3117,40922,15471,2,4868,'App\\Models\\Receipt',4868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',1869.00,NULL,NULL,1,'2021-12-23 10:23:11','2021-12-23 10:23:11',NULL),(5082,3117,40922,15471,2,4869,'App\\Models\\Receipt',4869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',1700.00,NULL,NULL,1,'2021-12-23 10:23:11','2021-12-23 10:23:11',NULL),(5083,3117,40922,15471,2,4870,'App\\Models\\Receipt',4870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',10000.00,NULL,NULL,1,'2021-12-23 10:23:11','2021-12-23 10:23:11',NULL),(5084,3117,40922,15471,2,4871,'App\\Models\\Receipt',4871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',5000.00,NULL,NULL,1,'2021-12-23 10:23:11','2021-12-23 10:23:11',NULL),(5085,3117,40922,15471,2,4872,'App\\Models\\Receipt',4872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',3047.00,NULL,NULL,1,'2021-12-23 10:23:11','2021-12-23 10:23:11',NULL),(5086,3117,40922,15471,2,4873,'App\\Models\\Receipt',4873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',5000.00,NULL,NULL,1,'2021-12-23 10:23:11','2021-12-23 10:23:11',NULL),(5087,3117,40922,15471,2,4874,'App\\Models\\Receipt',4874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',2000.00,NULL,NULL,1,'2021-12-23 10:23:11','2021-12-23 10:23:11',NULL),(5088,3117,40922,15471,2,4875,'App\\Models\\Receipt',4875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',1561.00,NULL,NULL,1,'2021-12-23 10:23:11','2021-12-23 10:23:11',NULL),(5089,3117,40922,15471,2,4876,'App\\Models\\Receipt',4876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',360.00,NULL,NULL,1,'2021-12-23 10:23:11','2021-12-23 10:23:11',NULL),(5090,3117,40922,15471,2,4877,'App\\Models\\Receipt',4877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',1048.00,NULL,NULL,1,'2021-12-23 10:23:11','2021-12-23 10:23:11',NULL),(5091,3117,40922,15471,2,4878,'App\\Models\\Receipt',4878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',725.00,NULL,NULL,1,'2021-12-23 10:23:11','2021-12-23 10:23:11',NULL),(5092,3117,40922,15471,2,4879,'App\\Models\\Receipt',4879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',1560.00,NULL,NULL,1,'2021-12-23 10:23:11','2021-12-23 10:23:11',NULL),(5093,3117,40922,15471,2,4880,'App\\Models\\Receipt',4880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',1000.00,NULL,NULL,1,'2021-12-23 10:23:11','2021-12-23 10:23:11',NULL),(5094,3117,40922,15471,2,4881,'App\\Models\\Receipt',4881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',1360.00,NULL,NULL,1,'2021-12-23 10:23:11','2021-12-23 10:23:11',NULL),(5095,3117,40922,15471,2,4882,'App\\Models\\Receipt',4882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',5958.00,NULL,NULL,1,'2021-12-23 10:23:11','2021-12-23 10:23:11',NULL),(5096,3117,40922,15471,2,4883,'App\\Models\\Receipt',4883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',440.00,NULL,NULL,1,'2021-12-23 10:23:11','2021-12-23 10:23:11',NULL),(5097,3117,40922,15471,2,4884,'App\\Models\\Receipt',4884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',700.00,NULL,NULL,1,'2021-12-23 10:23:11','2021-12-23 10:23:11',NULL),(5098,3117,40922,15471,2,4885,'App\\Models\\Receipt',4885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',230.00,NULL,NULL,1,'2021-12-23 10:23:11','2021-12-23 10:23:11',NULL),(5099,3117,40922,15471,2,4886,'App\\Models\\Receipt',4886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',8493.00,NULL,NULL,1,'2021-12-23 10:23:11','2021-12-23 10:23:11',NULL);
INSERT INTO `balance_libro` VALUES (5100,3117,40922,15471,2,4887,'App\\Models\\Receipt',4887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',1334.00,NULL,NULL,1,'2021-12-23 10:23:11','2021-12-23 10:23:11',NULL),(5101,3117,40922,15471,2,4888,'App\\Models\\Receipt',4888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',1000.00,NULL,NULL,1,'2021-12-23 10:23:11','2021-12-23 10:23:11',NULL),(5102,3117,40922,15471,2,4889,'App\\Models\\Receipt',4889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',9000.00,NULL,NULL,1,'2021-12-23 10:23:11','2021-12-23 10:23:11',NULL),(5103,3117,40922,15471,2,4890,'App\\Models\\Receipt',4890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',9000.00,NULL,NULL,1,'2021-12-23 10:23:12','2021-12-23 10:23:12',NULL),(5104,3117,40922,15471,2,4891,'App\\Models\\Receipt',4891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-21','2021-08-21',1024.00,NULL,NULL,1,'2021-12-23 10:23:12','2021-12-23 10:23:12',NULL),(5105,3117,40922,15471,2,4892,'App\\Models\\Receipt',4892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-21','2021-08-21',2564.00,NULL,NULL,1,'2021-12-23 10:23:12','2021-12-23 10:23:12',NULL),(5106,3117,40922,15471,2,4893,'App\\Models\\Receipt',4893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',1000.00,NULL,NULL,1,'2021-12-23 10:23:12','2021-12-23 10:23:12',NULL),(5107,3117,40922,15471,2,4894,'App\\Models\\Receipt',4894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',3206.00,NULL,NULL,1,'2021-12-23 10:23:12','2021-12-23 10:23:12',NULL),(5108,3117,40922,15471,2,4895,'App\\Models\\Receipt',4895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-22','2021-08-22',10000.00,NULL,NULL,1,'2021-12-23 10:23:12','2021-12-23 10:23:12',NULL),(5109,3117,40922,15471,2,4896,'App\\Models\\Receipt',4896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',959.00,NULL,NULL,1,'2021-12-23 10:23:12','2021-12-23 10:23:12',NULL),(5110,3117,40922,15471,2,4897,'App\\Models\\Receipt',4897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',636.00,NULL,NULL,1,'2021-12-23 10:23:12','2021-12-23 10:23:12',NULL),(5111,3117,40922,15471,2,4898,'App\\Models\\Receipt',4898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',1160.00,NULL,NULL,1,'2021-12-23 10:23:12','2021-12-23 10:23:12',NULL),(5112,3117,40922,15471,2,4899,'App\\Models\\Receipt',4899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',292.00,NULL,NULL,1,'2021-12-23 10:23:12','2021-12-23 10:23:12',NULL),(5113,3117,40922,15471,2,4900,'App\\Models\\Receipt',4900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',460.00,NULL,NULL,1,'2021-12-23 10:23:12','2021-12-23 10:23:12',NULL),(5114,3117,40922,15471,2,4901,'App\\Models\\Receipt',4901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',2405.00,NULL,NULL,1,'2021-12-23 10:23:12','2021-12-23 10:23:12',NULL),(5115,3117,40922,15471,2,4902,'App\\Models\\Receipt',4902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',10000.00,NULL,NULL,1,'2021-12-23 10:23:12','2021-12-23 10:23:12',NULL),(5116,3117,40922,15471,2,4903,'App\\Models\\Receipt',4903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-28','2021-08-28',4774.00,NULL,NULL,1,'2021-12-23 10:23:12','2021-12-23 10:23:12',NULL),(5117,3117,40922,15471,2,4904,'App\\Models\\Receipt',4904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-28','2021-08-28',10000.00,NULL,NULL,1,'2021-12-23 10:23:12','2021-12-23 10:23:12',NULL),(5118,3117,40922,15471,2,4905,'App\\Models\\Receipt',4905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-29','2021-08-29',10000.00,NULL,NULL,1,'2021-12-23 10:23:12','2021-12-23 10:23:12',NULL),(5119,3117,40922,15471,2,4906,'App\\Models\\Receipt',4906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-29','2021-08-29',10000.00,NULL,NULL,1,'2021-12-23 10:23:12','2021-12-23 10:23:12',NULL),(5120,3117,40922,15471,2,4907,'App\\Models\\Receipt',4907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',6338.00,NULL,NULL,1,'2021-12-23 10:23:12','2021-12-23 10:23:12',NULL);
INSERT INTO `balance_libro` VALUES (5121,3117,40922,15471,2,4908,'App\\Models\\Receipt',4908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',10600.00,NULL,NULL,1,'2021-12-23 10:23:12','2021-12-23 10:23:12',NULL),(5122,3117,40922,15471,2,4909,'App\\Models\\Receipt',4909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',13000.00,NULL,NULL,1,'2021-12-23 10:23:12','2021-12-23 10:23:12',NULL),(5123,3117,40922,15471,2,4910,'App\\Models\\Receipt',4910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',12500.00,NULL,NULL,1,'2021-12-23 10:23:12','2021-12-23 10:23:12',NULL),(5124,3117,40922,15471,2,4911,'App\\Models\\Receipt',4911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',1500.00,NULL,NULL,1,'2021-12-23 10:23:12','2021-12-23 10:23:12',NULL),(5125,3117,40922,15471,2,4912,'App\\Models\\Receipt',4912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',13000.00,NULL,NULL,1,'2021-12-23 10:23:12','2021-12-23 10:23:12',NULL),(5126,3117,40922,15471,2,4913,'App\\Models\\Receipt',4913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',12000.00,NULL,NULL,1,'2021-12-23 10:23:12','2021-12-23 10:23:12',NULL),(5127,3117,40922,15471,2,4914,'App\\Models\\Receipt',4914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',11000.00,NULL,NULL,1,'2021-12-23 10:23:12','2021-12-23 10:23:12',NULL),(5128,3117,40922,15471,2,4915,'App\\Models\\Receipt',4915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',10000.00,NULL,NULL,1,'2021-12-23 10:23:12','2021-12-23 10:23:12',NULL),(5129,3117,40922,15472,2,4916,'App\\Models\\Receipt',4916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',5531.00,NULL,NULL,1,'2021-12-23 10:23:58','2021-12-23 10:23:58',NULL),(5130,3117,40922,15472,2,4917,'App\\Models\\Receipt',4917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',748.00,NULL,NULL,1,'2021-12-23 10:23:58','2021-12-23 10:23:58',NULL),(5131,3117,40922,15472,2,4918,'App\\Models\\Receipt',4918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',1000.00,NULL,NULL,1,'2021-12-23 10:23:58','2021-12-23 10:23:58',NULL),(5132,3117,40922,15472,2,4919,'App\\Models\\Receipt',4919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',10000.00,NULL,NULL,1,'2021-12-23 10:23:58','2021-12-23 10:23:58',NULL),(5133,3117,40922,15472,2,4920,'App\\Models\\Receipt',4920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',10000.00,NULL,NULL,1,'2021-12-23 10:23:58','2021-12-23 10:23:58',NULL),(5134,3117,40922,15472,2,4921,'App\\Models\\Receipt',4921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',10000.00,NULL,NULL,1,'2021-12-23 10:23:59','2021-12-23 10:23:59',NULL),(5135,3117,40922,15472,2,4922,'App\\Models\\Receipt',4922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',10000.00,NULL,NULL,1,'2021-12-23 10:23:59','2021-12-23 10:23:59',NULL),(5136,3117,40922,15472,2,4923,'App\\Models\\Receipt',4923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',9000.00,NULL,NULL,1,'2021-12-23 10:23:59','2021-12-23 10:23:59',NULL),(5137,3117,40922,15472,2,4924,'App\\Models\\Receipt',4924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',2886.00,NULL,NULL,1,'2021-12-23 10:23:59','2021-12-23 10:23:59',NULL),(5138,3117,40922,15472,2,4925,'App\\Models\\Receipt',4925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',10000.00,NULL,NULL,1,'2021-12-23 10:23:59','2021-12-23 10:23:59',NULL),(5139,3117,40922,15472,2,4926,'App\\Models\\Receipt',4926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',2650.00,NULL,NULL,1,'2021-12-23 10:23:59','2021-12-23 10:23:59',NULL),(5140,3117,40922,15472,2,4927,'App\\Models\\Receipt',4927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',10000.00,NULL,NULL,1,'2021-12-23 10:23:59','2021-12-23 10:23:59',NULL),(5141,3117,40922,15472,2,4928,'App\\Models\\Receipt',4928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',2253.00,NULL,NULL,1,'2021-12-23 10:23:59','2021-12-23 10:23:59',NULL);
INSERT INTO `balance_libro` VALUES (5142,3117,40922,15472,2,4929,'App\\Models\\Receipt',4929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',1804.00,NULL,NULL,1,'2021-12-23 10:23:59','2021-12-23 10:23:59',NULL),(5143,3117,40922,15472,2,4930,'App\\Models\\Receipt',4930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',1233.00,NULL,NULL,1,'2021-12-23 10:23:59','2021-12-23 10:23:59',NULL),(5144,3117,40922,15472,2,4931,'App\\Models\\Receipt',4931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',2980.00,NULL,NULL,1,'2021-12-23 10:23:59','2021-12-23 10:23:59',NULL),(5145,3117,40922,15472,2,4932,'App\\Models\\Receipt',4932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',10000.00,NULL,NULL,1,'2021-12-23 10:23:59','2021-12-23 10:23:59',NULL),(5146,3117,40922,15472,2,4933,'App\\Models\\Receipt',4933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',10000.00,NULL,NULL,1,'2021-12-23 10:23:59','2021-12-23 10:23:59',NULL),(5147,3117,40922,15472,2,4934,'App\\Models\\Receipt',4934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-16','2021-09-16',10000.00,NULL,NULL,1,'2021-12-23 10:23:59','2021-12-23 10:23:59',NULL),(5148,3117,40922,15472,2,4935,'App\\Models\\Receipt',4935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',9000.00,NULL,NULL,1,'2021-12-23 10:23:59','2021-12-23 10:23:59',NULL),(5149,3117,40922,15472,2,4936,'App\\Models\\Receipt',4936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',9000.00,NULL,NULL,1,'2021-12-23 10:23:59','2021-12-23 10:23:59',NULL),(5150,3117,40922,15472,2,4937,'App\\Models\\Receipt',4937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',1672.00,NULL,NULL,1,'2021-12-23 10:23:59','2021-12-23 10:23:59',NULL),(5151,3117,40922,15472,2,4938,'App\\Models\\Receipt',4938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',10000.00,NULL,NULL,1,'2021-12-23 10:23:59','2021-12-23 10:23:59',NULL),(5152,3117,40922,15472,2,4939,'App\\Models\\Receipt',4939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-18','2021-09-18',4285.00,NULL,NULL,1,'2021-12-23 10:23:59','2021-12-23 10:23:59',NULL),(5153,3117,40922,15473,2,4940,'App\\Models\\Receipt',4940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',1491.00,NULL,NULL,1,'2021-12-23 10:27:27','2021-12-23 10:27:27',NULL),(5154,3117,40922,15473,2,4941,'App\\Models\\Receipt',4941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',10000.00,NULL,NULL,1,'2021-12-23 10:27:27','2021-12-23 10:27:27',NULL),(5155,3117,40922,15473,2,4942,'App\\Models\\Receipt',4942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',10000.00,NULL,NULL,1,'2021-12-23 10:27:27','2021-12-23 10:27:27',NULL),(5156,3117,40922,15473,2,4943,'App\\Models\\Receipt',4943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',10000.00,NULL,NULL,1,'2021-12-23 10:27:27','2021-12-23 10:27:27',NULL),(5157,3117,40922,15473,2,4944,'App\\Models\\Receipt',4944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',10000.00,NULL,NULL,1,'2021-12-23 10:27:27','2021-12-23 10:27:27',NULL),(5158,3117,40922,15473,2,4945,'App\\Models\\Receipt',4945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',10000.00,NULL,NULL,1,'2021-12-23 10:27:27','2021-12-23 10:27:27',NULL),(5159,3117,40922,15473,2,4946,'App\\Models\\Receipt',4946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',268.00,NULL,NULL,1,'2021-12-23 10:27:27','2021-12-23 10:27:27',NULL),(5160,3117,40922,15473,2,4947,'App\\Models\\Receipt',4947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',732.00,NULL,NULL,1,'2021-12-23 10:27:27','2021-12-23 10:27:27',NULL),(5161,3117,40922,15473,2,4948,'App\\Models\\Receipt',4948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',4204.00,NULL,NULL,1,'2021-12-23 10:27:27','2021-12-23 10:27:27',NULL),(5162,3117,40922,15473,2,4949,'App\\Models\\Receipt',4949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',5000.00,NULL,NULL,1,'2021-12-23 10:27:27','2021-12-23 10:27:27',NULL);
INSERT INTO `balance_libro` VALUES (5163,3117,40922,15473,2,4950,'App\\Models\\Receipt',4950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',991.00,NULL,NULL,1,'2021-12-23 10:27:27','2021-12-23 10:27:27',NULL),(5164,3117,40922,15473,2,4951,'App\\Models\\Receipt',4951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',500.00,NULL,NULL,1,'2021-12-23 10:27:27','2021-12-23 10:27:27',NULL),(5165,3117,40922,15473,2,4952,'App\\Models\\Receipt',4952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',11040.00,NULL,NULL,1,'2021-12-23 10:27:27','2021-12-23 10:27:27',NULL),(5166,3117,40922,15473,2,4953,'App\\Models\\Receipt',4953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',954.00,NULL,NULL,1,'2021-12-23 10:27:27','2021-12-23 10:27:27',NULL),(5167,3117,40922,15473,2,4954,'App\\Models\\Receipt',4954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',2597.00,NULL,NULL,1,'2021-12-23 10:27:27','2021-12-23 10:27:27',NULL),(5168,3117,40922,15473,2,4955,'App\\Models\\Receipt',4955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',897.00,NULL,NULL,1,'2021-12-23 10:27:27','2021-12-23 10:27:27',NULL),(5169,3117,40922,15473,2,4956,'App\\Models\\Receipt',4956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',1314.00,NULL,NULL,1,'2021-12-23 10:27:27','2021-12-23 10:27:27',NULL),(5170,3117,40922,15473,2,4957,'App\\Models\\Receipt',4957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',2310.00,NULL,NULL,1,'2021-12-23 10:27:27','2021-12-23 10:27:27',NULL),(5171,3117,40922,15473,2,4958,'App\\Models\\Receipt',4958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',9000.00,NULL,NULL,1,'2021-12-23 10:27:27','2021-12-23 10:27:27',NULL),(5172,3117,40922,15473,2,4959,'App\\Models\\Receipt',4959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',835.00,NULL,NULL,1,'2021-12-23 10:27:28','2021-12-23 10:27:28',NULL),(5173,3117,40922,15473,2,4960,'App\\Models\\Receipt',4960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',1305.00,NULL,NULL,1,'2021-12-23 10:27:28','2021-12-23 10:27:28',NULL),(5174,3117,40922,15473,2,4961,'App\\Models\\Receipt',4961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',9000.00,NULL,NULL,1,'2021-12-23 10:27:28','2021-12-23 10:27:28',NULL),(5175,3117,40922,15473,2,4962,'App\\Models\\Receipt',4962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',1037.00,NULL,NULL,1,'2021-12-23 10:27:28','2021-12-23 10:27:28',NULL),(5176,3117,40922,15473,2,4963,'App\\Models\\Receipt',4963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',758.00,NULL,NULL,1,'2021-12-23 10:27:28','2021-12-23 10:27:28',NULL),(5177,3117,40922,15473,2,4964,'App\\Models\\Receipt',4964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',2295.00,NULL,NULL,1,'2021-12-23 10:27:28','2021-12-23 10:27:28',NULL),(5178,3117,40922,15473,2,4965,'App\\Models\\Receipt',4965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',13000.00,NULL,NULL,1,'2021-12-23 10:27:28','2021-12-23 10:27:28',NULL),(5179,3117,40922,15473,2,4966,'App\\Models\\Receipt',4966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',13050.00,NULL,NULL,1,'2021-12-23 10:27:28','2021-12-23 10:27:28',NULL),(5180,3117,40922,15473,2,4967,'App\\Models\\Receipt',4967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',12500.00,NULL,NULL,1,'2021-12-23 10:27:28','2021-12-23 10:27:28',NULL),(5181,3117,40922,15473,2,4968,'App\\Models\\Receipt',4968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',13000.00,NULL,NULL,1,'2021-12-23 10:27:28','2021-12-23 10:27:28',NULL),(5182,3117,40922,15473,2,4969,'App\\Models\\Receipt',4969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',1078.00,NULL,NULL,1,'2021-12-23 10:27:28','2021-12-23 10:27:28',NULL),(5183,3117,40922,15473,2,4970,'App\\Models\\Receipt',4970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',13100.00,NULL,NULL,1,'2021-12-23 10:27:28','2021-12-23 10:27:28',NULL);
INSERT INTO `balance_libro` VALUES (5184,3117,40922,15473,2,4971,'App\\Models\\Receipt',4971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',13000.00,NULL,NULL,1,'2021-12-23 10:27:28','2021-12-23 10:27:28',NULL),(5185,3117,40922,15473,2,4972,'App\\Models\\Receipt',4972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',12500.00,NULL,NULL,1,'2021-12-23 10:27:28','2021-12-23 10:27:28',NULL),(5186,3117,40922,15473,2,4973,'App\\Models\\Receipt',4973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',13065.00,NULL,NULL,1,'2021-12-23 10:27:28','2021-12-23 10:27:28',NULL),(5187,3117,40922,15473,2,4974,'App\\Models\\Receipt',4974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',13029.00,NULL,NULL,1,'2021-12-23 10:27:28','2021-12-23 10:27:28',NULL),(5188,3117,40922,15473,2,4975,'App\\Models\\Receipt',4975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',800.00,NULL,NULL,1,'2021-12-23 10:27:28','2021-12-23 10:27:28',NULL),(5189,3117,40922,15473,2,4976,'App\\Models\\Receipt',4976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-30','2021-10-30',13000.00,NULL,NULL,1,'2021-12-23 10:27:28','2021-12-23 10:27:28',NULL),(5190,3117,40922,15473,2,4977,'App\\Models\\Receipt',4977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-30','2021-10-30',12998.00,NULL,NULL,1,'2021-12-23 10:27:28','2021-12-23 10:27:28',NULL),(5191,3117,40922,15473,2,4978,'App\\Models\\Receipt',4978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',962.00,NULL,NULL,1,'2021-12-23 10:27:28','2021-12-23 10:27:28',NULL),(5192,3117,40922,15473,2,4979,'App\\Models\\Receipt',4979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',500.00,NULL,NULL,1,'2021-12-23 10:27:28','2021-12-23 10:27:28',NULL),(5193,3117,40922,15473,2,4980,'App\\Models\\Receipt',4980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',13000.00,NULL,NULL,1,'2021-12-23 10:27:28','2021-12-23 10:27:28',NULL),(5194,3117,40922,15470,3,4981,'App\\Models\\Receipt',4981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',1057.51,NULL,NULL,1,'2021-12-23 10:34:31','2021-12-23 11:38:43','2021-12-23 11:38:43'),(5195,3117,40922,15470,3,4982,'App\\Models\\Receipt',4982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',5122.72,NULL,NULL,1,'2021-12-23 10:34:31','2021-12-23 11:38:23','2021-12-23 11:38:23'),(5196,3117,40922,15470,3,4983,'App\\Models\\Receipt',4983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',2079.11,NULL,NULL,1,'2021-12-23 10:34:31','2021-12-23 11:38:00','2021-12-23 11:38:00'),(5197,3117,40922,15470,3,4984,'App\\Models\\Receipt',4984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',6183.39,NULL,NULL,1,'2021-12-23 10:34:31','2021-12-23 11:37:15','2021-12-23 11:37:15'),(5198,3117,40922,15470,3,4985,'App\\Models\\Receipt',4985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',5126.03,NULL,NULL,1,'2021-12-23 10:34:31','2021-12-23 11:36:58','2021-12-23 11:36:58'),(5199,3117,40922,15470,3,4986,'App\\Models\\Receipt',4986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',2270.24,NULL,NULL,1,'2021-12-23 10:34:31','2021-12-23 11:36:20','2021-12-23 11:36:20'),(5200,3117,40922,15470,3,4987,'App\\Models\\Receipt',4987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',1624.44,NULL,NULL,1,'2021-12-23 10:34:31','2021-12-23 11:36:39','2021-12-23 11:36:39'),(5201,3117,40922,15470,3,4988,'App\\Models\\Receipt',4988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',2993.41,NULL,NULL,1,'2021-12-23 10:34:31','2021-12-23 11:35:41','2021-12-23 11:35:41'),(5202,3117,40922,15470,3,4989,'App\\Models\\Receipt',4989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',5453.26,NULL,NULL,1,'2021-12-23 10:34:31','2021-12-23 11:35:05','2021-12-23 11:35:05'),(5203,3117,40922,15470,3,4990,'App\\Models\\Receipt',4990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',3894.84,NULL,NULL,1,'2021-12-23 10:34:31','2021-12-23 11:34:47','2021-12-23 11:34:47');
INSERT INTO `balance_libro` VALUES (5204,3117,40922,15470,3,4991,'App\\Models\\Receipt',4991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',1649.33,NULL,NULL,1,'2021-12-23 10:34:31','2021-12-23 11:34:28','2021-12-23 11:34:28'),(5205,3117,40922,15470,3,4992,'App\\Models\\Receipt',4992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',2957.48,NULL,NULL,1,'2021-12-23 10:34:31','2021-12-23 11:34:11','2021-12-23 11:34:11'),(5206,3117,40922,15470,3,4993,'App\\Models\\Receipt',4993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',4618.03,NULL,NULL,1,'2021-12-23 10:34:31','2021-12-23 11:33:55','2021-12-23 11:33:55'),(5207,3117,40922,15470,3,4994,'App\\Models\\Receipt',4994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',7974.22,NULL,NULL,1,'2021-12-23 10:34:31','2021-12-23 11:33:37','2021-12-23 11:33:37'),(5208,3117,40922,15470,3,4995,'App\\Models\\Receipt',4995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',13157.50,NULL,NULL,1,'2021-12-23 10:34:31','2021-12-23 11:33:18','2021-12-23 11:33:18'),(5209,3117,40922,15470,3,4996,'App\\Models\\Receipt',4996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',2203.88,NULL,NULL,1,'2021-12-23 10:34:31','2021-12-23 11:32:43','2021-12-23 11:32:43'),(5210,3117,40922,15470,3,4997,'App\\Models\\Receipt',4997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',2748.42,NULL,NULL,1,'2021-12-23 10:34:31','2021-12-23 11:32:25','2021-12-23 11:32:25'),(5211,3117,40922,15470,3,4998,'App\\Models\\Receipt',4998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',2491.90,NULL,NULL,1,'2021-12-23 10:34:31','2021-12-23 11:32:07','2021-12-23 11:32:07'),(5212,3117,40922,15470,3,4999,'App\\Models\\Receipt',4999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',3124.78,NULL,NULL,1,'2021-12-23 10:34:31','2021-12-23 11:31:45','2021-12-23 11:31:45'),(5213,3117,40922,15470,3,5000,'App\\Models\\Receipt',5000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',695.69,NULL,NULL,1,'2021-12-23 10:34:31','2021-12-23 11:31:17','2021-12-23 11:31:17'),(5214,3117,40922,15470,3,5001,'App\\Models\\Receipt',5001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',470.99,NULL,NULL,1,'2021-12-23 10:34:31','2021-12-23 11:30:54','2021-12-23 11:30:54'),(5215,3117,40922,15470,3,5002,'App\\Models\\Receipt',5002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',4079.29,NULL,NULL,1,'2021-12-23 10:34:31','2021-12-23 11:30:35','2021-12-23 11:30:35'),(5216,3117,40922,15470,3,5003,'App\\Models\\Receipt',5003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',250.14,NULL,NULL,1,'2021-12-23 10:34:31','2021-12-23 11:30:16','2021-12-23 11:30:16'),(5217,3117,40922,15470,3,5004,'App\\Models\\Receipt',5004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',5612.15,NULL,NULL,1,'2021-12-23 10:34:31','2021-12-23 11:29:56','2021-12-23 11:29:56'),(5218,3117,40922,15470,3,5005,'App\\Models\\Receipt',5005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',7773.56,NULL,NULL,1,'2021-12-23 10:34:31','2021-12-23 11:29:35','2021-12-23 11:29:35'),(5219,3117,40922,15470,3,5006,'App\\Models\\Receipt',5006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',1037.64,NULL,NULL,1,'2021-12-23 10:34:32','2021-12-23 11:29:14','2021-12-23 11:29:14'),(5220,3117,40922,15470,3,5007,'App\\Models\\Receipt',5007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',2221.17,NULL,NULL,1,'2021-12-23 10:34:32','2021-12-23 11:28:54','2021-12-23 11:28:54'),(5221,3117,40922,15470,3,5008,'App\\Models\\Receipt',5008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',4647.94,NULL,NULL,1,'2021-12-23 10:34:32','2021-12-23 11:28:30','2021-12-23 11:28:30'),(5222,3117,40922,15470,3,5009,'App\\Models\\Receipt',5009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',2052.67,NULL,NULL,1,'2021-12-23 10:34:32','2021-12-23 11:28:08','2021-12-23 11:28:08');
INSERT INTO `balance_libro` VALUES (5223,3117,40922,15470,3,5010,'App\\Models\\Receipt',5010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',6061.71,NULL,NULL,1,'2021-12-23 10:34:32','2021-12-23 11:27:46','2021-12-23 11:27:46'),(5224,3117,40922,15470,3,5011,'App\\Models\\Receipt',5011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',1949.55,NULL,NULL,1,'2021-12-23 10:34:32','2021-12-23 11:27:26','2021-12-23 11:27:26'),(5225,3117,40922,15470,3,5012,'App\\Models\\Receipt',5012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',2389.23,NULL,NULL,1,'2021-12-23 10:34:32','2021-12-23 11:26:43','2021-12-23 11:26:43'),(5226,3117,40922,15470,3,5013,'App\\Models\\Receipt',5013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',4852.58,NULL,NULL,1,'2021-12-23 10:34:32','2021-12-23 11:26:07','2021-12-23 11:26:07'),(5227,3117,40922,15470,3,5014,'App\\Models\\Receipt',5014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',171.44,NULL,NULL,1,'2021-12-23 10:34:32','2021-12-23 11:25:06','2021-12-23 11:25:06'),(5228,3117,40922,15470,3,5015,'App\\Models\\Receipt',5015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',2757.36,NULL,NULL,1,'2021-12-23 10:34:32','2021-12-23 11:24:42','2021-12-23 11:24:42'),(5229,3117,40922,15470,3,5016,'App\\Models\\Receipt',5016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',5857.39,NULL,NULL,1,'2021-12-23 10:34:32','2021-12-23 11:24:01','2021-12-23 11:24:01'),(5230,3117,40922,15470,3,5017,'App\\Models\\Receipt',5017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',4883.39,NULL,NULL,1,'2021-12-23 10:34:32','2021-12-23 11:23:42','2021-12-23 11:23:42'),(5231,3117,40922,15470,3,5018,'App\\Models\\Receipt',5018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',3662.77,NULL,NULL,1,'2021-12-23 10:34:32','2021-12-23 11:23:08','2021-12-23 11:23:08'),(5232,3117,40922,15470,3,5019,'App\\Models\\Receipt',5019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',2565.08,NULL,NULL,1,'2021-12-23 10:34:32','2021-12-23 11:22:46','2021-12-23 11:22:46'),(5233,3117,40922,15470,3,5020,'App\\Models\\Receipt',5020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',795.61,NULL,NULL,1,'2021-12-23 10:34:32','2021-12-23 11:22:26','2021-12-23 11:22:26'),(5234,3117,40922,15470,3,5021,'App\\Models\\Receipt',5021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',2843.40,NULL,NULL,1,'2021-12-23 10:34:32','2021-12-23 11:22:00','2021-12-23 11:22:00'),(5235,3117,40922,15470,3,5022,'App\\Models\\Receipt',5022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',7300.20,NULL,NULL,1,'2021-12-23 10:34:32','2021-12-23 11:21:31','2021-12-23 11:21:31'),(5236,3117,40922,15470,3,5023,'App\\Models\\Receipt',5023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',2830.99,NULL,NULL,1,'2021-12-23 10:34:32','2021-12-23 11:19:06','2021-12-23 11:19:06'),(5237,3117,40922,15470,3,5024,'App\\Models\\Receipt',5024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',2548.80,NULL,NULL,1,'2021-12-23 10:34:32','2021-12-23 11:19:39','2021-12-23 11:19:39'),(5238,3117,40922,15470,3,5025,'App\\Models\\Receipt',5025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',2422.80,NULL,NULL,1,'2021-12-23 10:34:32','2021-12-23 11:20:53','2021-12-23 11:20:53'),(5239,3117,40922,15470,3,5026,'App\\Models\\Receipt',5026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',250.14,NULL,NULL,1,'2021-12-23 10:34:32','2021-12-23 11:20:32','2021-12-23 11:20:32'),(5240,3117,40922,15470,3,5027,'App\\Models\\Receipt',5027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',2587.43,NULL,NULL,1,'2021-12-23 10:34:32','2021-12-23 11:20:07','2021-12-23 11:20:07'),(5241,3117,40922,15470,3,5028,'App\\Models\\Receipt',5028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',4565.23,NULL,NULL,1,'2021-12-23 10:34:32','2021-12-23 11:18:16','2021-12-23 11:18:16');
INSERT INTO `balance_libro` VALUES (5242,3117,40922,15470,3,5029,'App\\Models\\Receipt',5029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2021-12-23 10:34:32','2021-12-23 10:34:32',NULL),(5243,3117,40922,15468,3,5030,'App\\Models\\Receipt',5030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',2633.35,NULL,NULL,1,'2021-12-23 10:35:32','2021-12-23 10:35:32',NULL),(5244,3117,40922,15468,3,5031,'App\\Models\\Receipt',5031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',2252.35,NULL,NULL,1,'2021-12-23 10:35:32','2021-12-23 10:35:32',NULL),(5245,3117,40922,15468,3,5032,'App\\Models\\Receipt',5032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',1049.46,NULL,NULL,1,'2021-12-23 10:35:32','2021-12-23 10:35:32',NULL),(5246,3117,40922,15468,3,5033,'App\\Models\\Receipt',5033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',2815.85,NULL,NULL,1,'2021-12-23 10:35:32','2021-12-23 10:35:32',NULL),(5247,3117,40922,15468,3,5034,'App\\Models\\Receipt',5034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',1350.95,NULL,NULL,1,'2021-12-23 10:35:32','2021-12-23 10:35:32',NULL),(5248,3117,40922,15468,3,5035,'App\\Models\\Receipt',5035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',2597.15,NULL,NULL,1,'2021-12-23 10:35:32','2021-12-23 10:35:32',NULL),(5249,3117,40922,15468,3,5036,'App\\Models\\Receipt',5036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',2454.19,NULL,NULL,1,'2021-12-23 10:35:32','2021-12-23 10:35:32',NULL),(5250,3117,40922,15468,3,5037,'App\\Models\\Receipt',5037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',2257.51,NULL,NULL,1,'2021-12-23 10:35:32','2021-12-23 10:35:32',NULL),(5251,3117,40922,15468,3,5038,'App\\Models\\Receipt',5038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',3742.65,NULL,NULL,1,'2021-12-23 10:35:32','2021-12-23 10:35:32',NULL),(5252,3117,40922,15468,3,5039,'App\\Models\\Receipt',5039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',1362.50,NULL,NULL,1,'2021-12-23 10:35:32','2021-12-23 10:35:32',NULL),(5253,3117,40922,15468,3,5040,'App\\Models\\Receipt',5040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',2989.44,NULL,NULL,1,'2021-12-23 10:35:32','2021-12-23 10:35:32',NULL),(5254,3117,40922,15468,3,5041,'App\\Models\\Receipt',5041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',2585.25,NULL,NULL,1,'2021-12-23 10:35:32','2021-12-23 10:35:32',NULL),(5255,3117,40922,15468,3,5042,'App\\Models\\Receipt',5042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',3803.51,NULL,NULL,1,'2021-12-23 10:35:32','2021-12-23 10:35:32',NULL),(5256,3117,40922,15468,3,5043,'App\\Models\\Receipt',5043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',6105.17,NULL,NULL,1,'2021-12-23 10:35:32','2021-12-23 10:35:32',NULL),(5257,3117,40922,15468,3,5044,'App\\Models\\Receipt',5044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',7329.43,NULL,NULL,1,'2021-12-23 10:35:32','2021-12-23 10:35:32',NULL),(5258,3117,40922,15468,3,5045,'App\\Models\\Receipt',5045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',479.14,NULL,NULL,1,'2021-12-23 10:35:32','2021-12-23 10:35:32',NULL),(5259,3117,40922,15468,3,5046,'App\\Models\\Receipt',5046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',4687.42,NULL,NULL,1,'2021-12-23 10:35:32','2021-12-23 10:35:32',NULL),(5260,3117,40922,15468,3,5047,'App\\Models\\Receipt',5047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',2053.78,NULL,NULL,1,'2021-12-23 10:35:32','2021-12-23 10:35:32',NULL),(5261,3117,40922,15468,3,5048,'App\\Models\\Receipt',5048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',3962.01,NULL,NULL,1,'2021-12-23 10:35:32','2021-12-23 10:35:32',NULL),(5262,3117,40922,15468,3,5049,'App\\Models\\Receipt',5049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',3391.99,NULL,NULL,1,'2021-12-23 10:35:32','2021-12-23 10:35:32',NULL);
INSERT INTO `balance_libro` VALUES (5263,3117,40922,15468,3,5050,'App\\Models\\Receipt',5050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',5107.30,NULL,NULL,1,'2021-12-23 10:35:32','2021-12-23 10:35:32',NULL),(5264,3117,40922,15468,3,5051,'App\\Models\\Receipt',5051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',4101.31,NULL,NULL,1,'2021-12-23 10:35:32','2021-12-23 10:35:32',NULL),(5265,3117,40922,15468,3,5052,'App\\Models\\Receipt',5052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',2157.31,NULL,NULL,1,'2021-12-23 10:35:32','2021-12-23 10:35:32',NULL),(5266,3117,40922,15468,3,5053,'App\\Models\\Receipt',5053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',2815.37,NULL,NULL,1,'2021-12-23 10:35:32','2021-12-23 10:35:32',NULL),(5267,3117,40922,15468,3,5054,'App\\Models\\Receipt',5054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',5380.43,NULL,NULL,1,'2021-12-23 10:35:32','2021-12-23 10:35:32',NULL),(5268,3117,40922,15468,3,5055,'App\\Models\\Receipt',5055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',10241.50,NULL,NULL,1,'2021-12-23 10:35:32','2021-12-23 10:35:32',NULL),(5269,3117,40922,15468,3,5056,'App\\Models\\Receipt',5056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',3159.44,NULL,NULL,1,'2021-12-23 10:35:32','2021-12-23 10:35:32',NULL),(5270,3117,40922,15468,3,5057,'App\\Models\\Receipt',5057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',3146.82,NULL,NULL,1,'2021-12-23 10:35:33','2021-12-23 10:35:33',NULL),(5271,3117,40922,15468,3,5058,'App\\Models\\Receipt',5058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',3735.02,NULL,NULL,1,'2021-12-23 10:35:33','2021-12-23 10:35:33',NULL),(5272,3117,40922,15468,3,5059,'App\\Models\\Receipt',5059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',3667.15,NULL,NULL,1,'2021-12-