-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db27-31477227-5
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-10-21 15:31:17','Actividad Generica 1','000001',NULL),(2,NULL,'2022-10-21 15:31:17','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
INSERT INTO `back_up_claves_details` VALUES (1,'Afip','Juan141184','20306533291',1,40720,'2022-10-22'),(2,'Afip','Juan141184','20306533291',1,40720,'2022-10-22'),(3,'Afip','Juan141184','20306533291',1,40720,'2022-10-22');
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'eacontadores@gmail.com','1557321836',NULL,1,40719,'2022-10-22'),(2,'eacontadores@gmail.com','1557321836','',1,40719,'2022-10-22'),(3,'eacontadores@gmail.com','1557321836','',1,40719,'2022-10-24'),(4,'eacontadores@gmail.com','1557321836',NULL,1,40719,'2022-10-24'),(5,'eacontadores@gmail.com','1557321836',NULL,1,40719,'2022-10-24'),(6,'eacontadores@gmail.com','1557321836',NULL,1,40719,'2022-10-25'),(7,'eacontadores@gmail.com','1557321836',NULL,1,40719,'2022-10-25');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1100 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,7968,40720,3134,3,1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',12751.37,NULL,NULL,1,'2022-10-22 15:54:00','2022-10-25 15:49:43','2022-10-25 15:49:43'),(2,7968,40720,3134,3,2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',13704.16,NULL,NULL,1,'2022-10-22 15:54:00','2022-10-25 15:49:43','2022-10-25 15:49:43'),(3,7968,40720,3134,3,3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',14362.65,NULL,NULL,1,'2022-10-22 15:54:00','2022-10-25 15:49:43','2022-10-25 15:49:43'),(4,7968,40720,3134,3,4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',1398.11,NULL,NULL,1,'2022-10-22 15:54:00','2022-10-25 15:49:43','2022-10-25 15:49:43'),(5,7968,40720,3134,3,5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',167.21,NULL,NULL,1,'2022-10-22 15:54:00','2022-10-25 15:49:43','2022-10-25 15:49:43'),(6,7968,40720,3134,3,6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',10019.54,NULL,NULL,1,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(7,7968,40720,3134,3,7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',980.16,NULL,NULL,1,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(8,7968,40720,3134,3,8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',10982.01,NULL,NULL,1,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(9,7968,40720,3134,3,9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',9899.99,NULL,NULL,1,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(10,7968,40720,3134,3,10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',116160.00,NULL,NULL,1,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(11,7968,40720,3134,3,11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',116160.00,NULL,NULL,1,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(12,7968,40720,3134,3,12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',116160.00,NULL,NULL,1,'2022-10-22 15:54:01','2022-10-25 15:46:59','2022-10-25 15:46:59'),(13,7968,40720,3134,3,13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',116160.00,NULL,NULL,1,'2022-10-22 15:54:01','2022-10-25 15:46:34','2022-10-25 15:46:34'),(14,7968,40720,3134,3,14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',4443.33,NULL,NULL,1,'2022-10-22 15:54:01','2022-10-25 15:43:23','2022-10-25 15:43:23'),(15,7968,40720,3134,3,15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',3439.21,NULL,NULL,1,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(16,7968,40720,3134,3,16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',1810.40,NULL,NULL,1,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(17,7968,40720,3134,3,17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',157.19,NULL,NULL,1,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(18,7968,40720,3134,3,18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',15244.03,NULL,NULL,1,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(19,7968,40720,3134,3,19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',8135.40,NULL,NULL,1,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(20,7968,40720,3134,3,20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',9737.93,NULL,NULL,1,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(21,7968,40720,3134,3,21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',1165.60,NULL,NULL,1,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(22,7968,40720,3134,3,22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',0.00,NULL,NULL,1,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(23,7968,40720,3134,3,23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',117.93,NULL,NULL,1,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43');
INSERT INTO `balance_libro` VALUES (24,7968,40720,3134,3,24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',7718.17,NULL,NULL,1,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(25,7968,40720,3134,3,25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',7902.01,NULL,NULL,1,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(26,7968,40720,3134,3,26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',14362.65,NULL,NULL,1,'2022-10-22 15:54:01','2022-10-25 15:44:09','2022-10-25 15:44:09'),(27,7968,40720,3134,3,27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',3850.20,NULL,NULL,1,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(28,7968,40720,3134,3,28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',416.72,NULL,NULL,1,'2022-10-22 15:54:01','2022-10-25 15:41:15','2022-10-25 15:41:15'),(29,7968,40720,3134,3,29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',7454.01,NULL,NULL,1,'2022-10-22 15:54:02','2022-10-24 17:07:57','2022-10-24 17:07:57'),(30,7968,40720,3134,3,30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',9300.56,NULL,NULL,1,'2022-10-22 15:54:02','2022-10-24 17:07:07','2022-10-24 17:07:07'),(31,7968,40720,3134,3,31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',11812.44,NULL,NULL,1,'2022-10-22 15:54:02','2022-10-24 17:06:48','2022-10-24 17:06:48'),(32,7968,40720,3134,3,32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',11998.99,NULL,NULL,1,'2022-10-22 15:54:02','2022-10-24 17:05:43','2022-10-24 17:05:43'),(33,7968,40720,3134,3,33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',7709.47,NULL,NULL,1,'2022-10-22 15:54:02','2022-10-24 17:04:30','2022-10-24 17:04:30'),(34,7968,40720,3134,3,34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',9004.90,NULL,NULL,1,'2022-10-22 15:54:02','2022-10-24 15:16:21','2022-10-24 15:16:21'),(35,7968,40720,3134,3,35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',0.00,NULL,NULL,1,'2022-10-22 15:54:02','2022-10-24 16:50:22','2022-10-24 16:50:22'),(36,7968,40720,3134,3,36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',13300.02,NULL,NULL,1,'2022-10-22 15:54:02','2022-10-24 15:15:51','2022-10-24 15:15:51'),(37,7968,40720,3134,3,37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',25900.00,NULL,NULL,1,'2022-10-22 15:54:02','2022-10-24 15:11:24','2022-10-24 15:11:24'),(38,7968,40720,3134,3,38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',500.00,NULL,NULL,1,'2022-10-22 15:54:02','2022-10-24 15:14:55','2022-10-24 15:14:55'),(39,7968,40720,3134,3,37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',25900.00,NULL,NULL,1,'2022-10-24 15:11:24','2022-10-24 16:45:15','2022-10-24 16:45:15'),(40,7968,40720,3134,3,38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',500.00,NULL,NULL,1,'2022-10-24 15:14:55','2022-10-24 16:37:31','2022-10-24 16:37:31'),(41,7968,40720,3134,3,36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',13300.02,NULL,NULL,1,'2022-10-24 15:15:51','2022-10-24 16:47:54','2022-10-24 16:47:54'),(42,7968,40720,3134,3,34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',9004.89,NULL,NULL,1,'2022-10-24 15:16:21','2022-10-24 17:03:26','2022-10-24 17:03:26'),(43,7968,40720,3134,3,38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',500.00,NULL,NULL,1,'2022-10-24 16:37:31','2022-10-24 16:44:21','2022-10-24 16:44:21'),(44,7968,40720,3134,3,38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',500.00,NULL,NULL,1,'2022-10-24 16:44:21','2022-10-24 16:44:29','2022-10-24 16:44:29'),(45,7968,40720,3134,3,38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',500.00,NULL,NULL,1,'2022-10-24 16:44:29','2022-10-25 15:49:43','2022-10-25 15:49:43'),(46,7968,40720,3134,3,37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',25900.00,NULL,NULL,1,'2022-10-24 16:45:15','2022-10-24 16:46:45','2022-10-24 16:46:45');
INSERT INTO `balance_libro` VALUES (47,7968,40720,3134,3,37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',25900.00,NULL,NULL,1,'2022-10-24 16:46:45','2022-10-25 15:49:43','2022-10-25 15:49:43'),(48,7968,40720,3134,3,36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',13300.02,NULL,NULL,1,'2022-10-24 16:47:54','2022-10-25 15:49:43','2022-10-25 15:49:43'),(49,7968,40720,3134,3,35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',0.01,NULL,NULL,1,'2022-10-24 16:50:22','2022-10-25 15:49:43','2022-10-25 15:49:43'),(50,7968,40720,3134,3,34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',9004.89,NULL,NULL,1,'2022-10-24 17:03:26','2022-10-25 15:49:43','2022-10-25 15:49:43'),(51,7968,40720,3134,3,33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',7709.47,NULL,NULL,1,'2022-10-24 17:04:30','2022-10-25 15:49:43','2022-10-25 15:49:43'),(52,7968,40720,3134,3,32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',11998.99,NULL,NULL,1,'2022-10-24 17:05:43','2022-10-25 15:49:43','2022-10-25 15:49:43'),(53,7968,40720,3134,3,31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',11812.44,NULL,NULL,1,'2022-10-24 17:06:48','2022-10-25 15:49:43','2022-10-25 15:49:43'),(54,7968,40720,3134,3,30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',9300.57,NULL,NULL,1,'2022-10-24 17:07:07','2022-10-25 15:49:43','2022-10-25 15:49:43'),(55,7968,40720,3134,3,29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',7454.01,NULL,NULL,1,'2022-10-24 17:07:57','2022-10-25 15:49:43','2022-10-25 15:49:43'),(56,7968,40720,3134,3,28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',416.72,NULL,NULL,1,'2022-10-25 15:41:15','2022-10-25 15:42:00','2022-10-25 15:42:00'),(57,7968,40720,3134,3,28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',416.72,NULL,NULL,1,'2022-10-25 15:42:00','2022-10-25 15:49:43','2022-10-25 15:49:43'),(58,7968,40720,3134,3,14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',4443.33,NULL,NULL,1,'2022-10-25 15:43:23','2022-10-25 15:44:39','2022-10-25 15:44:39'),(59,7968,40720,3134,3,26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',14362.65,NULL,NULL,1,'2022-10-25 15:44:09','2022-10-25 15:49:43','2022-10-25 15:49:43'),(60,7968,40720,3134,3,14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',4443.33,NULL,NULL,1,'2022-10-25 15:44:39','2022-10-25 15:49:43','2022-10-25 15:49:43'),(61,7968,40720,3134,3,13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',116160.00,NULL,NULL,1,'2022-10-25 15:46:34','2022-10-25 15:49:43','2022-10-25 15:49:43'),(62,7968,40720,3134,3,12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',116160.00,NULL,NULL,1,'2022-10-25 15:46:59','2022-10-25 15:49:43','2022-10-25 15:49:43'),(63,7968,40720,3134,3,39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',12751.37,NULL,NULL,1,'2022-10-25 15:53:23','2022-10-25 17:07:50','2022-10-25 17:07:50'),(64,7968,40720,3134,3,40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',13704.16,NULL,NULL,1,'2022-10-25 15:53:23','2022-10-25 17:07:50','2022-10-25 17:07:50'),(65,7968,40720,3134,3,41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',14362.65,NULL,NULL,1,'2022-10-25 15:53:23','2022-10-25 17:07:50','2022-10-25 17:07:50'),(66,7968,40720,3134,3,42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',1398.11,NULL,NULL,1,'2022-10-25 15:53:23','2022-10-25 17:07:50','2022-10-25 17:07:50'),(67,7968,40720,3134,3,43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',167.21,NULL,NULL,1,'2022-10-25 15:53:24','2022-10-25 17:07:50','2022-10-25 17:07:50'),(68,7968,40720,3134,3,44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',10019.54,NULL,NULL,1,'2022-10-25 15:53:24','2022-10-25 17:07:50','2022-10-25 17:07:50'),(69,7968,40720,3134,3,45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',980.16,NULL,NULL,1,'2022-10-25 15:53:24','2022-10-25 17:07:50','2022-10-25 17:07:50');
INSERT INTO `balance_libro` VALUES (70,7968,40720,3134,3,46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',10982.01,NULL,NULL,1,'2022-10-25 15:53:24','2022-10-25 17:07:50','2022-10-25 17:07:50'),(71,7968,40720,3134,3,47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',9899.99,NULL,NULL,1,'2022-10-25 15:53:24','2022-10-25 17:07:50','2022-10-25 17:07:50'),(72,7968,40720,3134,3,48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',116160.00,NULL,NULL,1,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(73,7968,40720,3134,3,49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',116160.00,NULL,NULL,1,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(74,7968,40720,3134,3,50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',116160.00,NULL,NULL,1,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(75,7968,40720,3134,3,51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',116160.00,NULL,NULL,1,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(76,7968,40720,3134,3,52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',4443.33,NULL,NULL,1,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(77,7968,40720,3134,3,53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',3439.21,NULL,NULL,1,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(78,7968,40720,3134,3,54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',1810.40,NULL,NULL,1,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(79,7968,40720,3134,3,55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',157.19,NULL,NULL,1,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(80,7968,40720,3134,3,56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',15244.03,NULL,NULL,1,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(81,7968,40720,3134,3,57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',8135.40,NULL,NULL,1,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(82,7968,40720,3134,3,58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',9737.93,NULL,NULL,1,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(83,7968,40720,3134,3,59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',1165.60,NULL,NULL,1,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(84,7968,40720,3134,3,60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',0.00,NULL,NULL,1,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(85,7968,40720,3134,3,61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',117.93,NULL,NULL,1,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(86,7968,40720,3134,3,62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',7718.17,NULL,NULL,1,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(87,7968,40720,3134,3,63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',7902.01,NULL,NULL,1,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(88,7968,40720,3134,3,64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',14362.65,NULL,NULL,1,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(89,7968,40720,3134,3,65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',3850.20,NULL,NULL,1,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(90,7968,40720,3134,3,66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',416.72,NULL,NULL,1,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(91,7968,40720,3134,3,67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',7454.01,NULL,NULL,1,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(92,7968,40720,3134,3,68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',9300.56,NULL,NULL,1,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51');
INSERT INTO `balance_libro` VALUES (93,7968,40720,3134,3,69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',11812.44,NULL,NULL,1,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(94,7968,40720,3134,3,70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',11998.99,NULL,NULL,1,'2022-10-25 15:53:25','2022-10-25 17:07:51','2022-10-25 17:07:51'),(95,7968,40720,3134,3,71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',7709.47,NULL,NULL,1,'2022-10-25 15:53:25','2022-10-25 17:07:51','2022-10-25 17:07:51'),(96,7968,40720,3134,3,72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',9004.90,NULL,NULL,1,'2022-10-25 15:53:25','2022-10-25 17:07:51','2022-10-25 17:07:51'),(97,7968,40720,3134,3,73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',0.00,NULL,NULL,1,'2022-10-25 15:53:25','2022-10-25 17:07:51','2022-10-25 17:07:51'),(98,7968,40720,3134,3,74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',13300.02,NULL,NULL,1,'2022-10-25 15:53:25','2022-10-25 15:56:03','2022-10-25 15:56:03'),(99,7968,40720,3134,3,75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',25900.00,NULL,NULL,1,'2022-10-25 15:53:25','2022-10-25 15:55:56','2022-10-25 15:55:56'),(100,7968,40720,3134,3,76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',500.00,NULL,NULL,1,'2022-10-25 15:53:25','2022-10-25 17:07:51','2022-10-25 17:07:51'),(101,7968,40720,3134,3,75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',25900.00,NULL,NULL,1,'2022-10-25 15:55:56','2022-10-25 17:07:51','2022-10-25 17:07:51'),(102,7968,40720,3134,3,74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',13300.02,NULL,NULL,1,'2022-10-25 15:56:03','2022-10-25 17:07:51','2022-10-25 17:07:51'),(103,7968,40720,3133,3,77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',4296.60,NULL,NULL,1,'2022-10-25 16:49:26','2022-10-25 16:49:26',NULL),(104,7968,40720,3133,3,78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',480.02,NULL,NULL,1,'2022-10-25 16:49:26','2022-10-25 16:49:26',NULL),(105,7968,40720,3133,3,79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',6351.35,NULL,NULL,1,'2022-10-25 16:49:26','2022-10-25 16:49:26',NULL),(106,7968,40720,3133,3,80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',12635.60,NULL,NULL,1,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(107,7968,40720,3133,3,81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',5497.32,NULL,NULL,1,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(108,7968,40720,3133,3,82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',9539.99,NULL,NULL,1,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(109,7968,40720,3133,3,83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',4221.40,NULL,NULL,1,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(110,7968,40720,3133,3,84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',12887.63,NULL,NULL,1,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(111,7968,40720,3133,3,85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-07','2022-08-07',9261.58,NULL,NULL,1,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(112,7968,40720,3133,3,86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',3555.71,NULL,NULL,1,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(113,7968,40720,3133,3,87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',364.08,NULL,NULL,1,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(114,7968,40720,3133,3,88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',8209.51,NULL,NULL,1,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(115,7968,40720,3133,3,89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',10661.81,NULL,NULL,1,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(116,7968,40720,3133,3,90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',11200.00,NULL,NULL,1,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL);
INSERT INTO `balance_libro` VALUES (117,7968,40720,3133,3,91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',13082.19,NULL,NULL,1,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(118,7968,40720,3133,3,92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',13554.30,NULL,NULL,1,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(119,7968,40720,3133,3,93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',7991.54,NULL,NULL,1,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(120,7968,40720,3133,3,94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',7435.80,NULL,NULL,1,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(121,7968,40720,3133,3,95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',4411.82,NULL,NULL,1,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(122,7968,40720,3133,3,96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',13298.75,NULL,NULL,1,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(123,7968,40720,3133,3,97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-15','2022-08-15',338.84,NULL,NULL,1,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(124,7968,40720,3133,3,98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-15','2022-08-15',2904.71,NULL,NULL,1,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(125,7968,40720,3133,3,99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',8891.00,NULL,NULL,1,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(126,7968,40720,3133,3,100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',15117.03,NULL,NULL,1,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(127,7968,40720,3133,3,101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',8276.16,NULL,NULL,1,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(128,7968,40720,3133,3,102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',16991.32,NULL,NULL,1,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(129,7968,40720,3133,3,103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',7080.05,NULL,NULL,1,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(130,7968,40720,3133,3,104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',433.19,NULL,NULL,1,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(131,7968,40720,3133,3,105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',4002.11,NULL,NULL,1,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(132,7968,40720,3133,3,106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',15021.00,NULL,NULL,1,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(133,7968,40720,3133,3,107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',0.00,NULL,NULL,1,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(134,7968,40720,3133,3,108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',3900.01,NULL,NULL,1,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(135,7968,40720,3133,3,109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',16387.23,NULL,NULL,1,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(136,7968,40720,3133,3,110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',95208.33,NULL,NULL,1,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(137,7968,40720,3133,3,111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',16387.23,NULL,NULL,1,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(138,7968,40720,3133,3,112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',16387.23,NULL,NULL,1,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(139,7968,40720,3133,3,113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',12704.20,NULL,NULL,1,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(140,7968,40720,3133,3,114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',3827.99,NULL,NULL,1,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(141,7968,40720,3133,3,115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',7433.94,NULL,NULL,1,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL);
INSERT INTO `balance_libro` VALUES (142,7968,40720,3133,3,116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',569.98,NULL,NULL,1,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(143,7968,40720,3133,3,117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',12199.99,NULL,NULL,1,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(144,7968,40720,3133,3,118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',6208.46,NULL,NULL,1,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(145,7968,40720,3133,3,119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',18726.36,NULL,NULL,1,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(146,7968,40720,3133,3,120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',15526.99,NULL,NULL,1,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(147,7968,40720,3133,3,121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',2845.99,NULL,NULL,1,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(148,7968,40720,3133,3,122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',561.00,NULL,NULL,1,'2022-10-25 16:49:28','2022-10-25 16:54:13','2022-10-25 16:54:13'),(149,7968,40720,3133,3,123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',25900.00,NULL,NULL,1,'2022-10-25 16:49:28','2022-10-25 16:54:05','2022-10-25 16:54:05'),(150,7968,40720,3133,3,123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',25900.00,NULL,NULL,1,'2022-10-25 16:54:05','2022-10-25 16:54:05',NULL),(151,7968,40720,3133,3,122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',561.00,NULL,NULL,1,'2022-10-25 16:54:13','2022-10-25 16:54:13',NULL),(152,7968,40720,3134,3,124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',12751.37,NULL,NULL,1,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(153,7968,40720,3134,3,125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',13704.16,NULL,NULL,1,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(154,7968,40720,3134,3,126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',14362.65,NULL,NULL,1,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(155,7968,40720,3134,3,127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',167.21,NULL,NULL,1,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(156,7968,40720,3134,3,128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',1398.11,NULL,NULL,1,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(157,7968,40720,3134,3,129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',10019.54,NULL,NULL,1,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(158,7968,40720,3134,3,130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',980.16,NULL,NULL,1,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(159,7968,40720,3134,3,131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',10982.01,NULL,NULL,1,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(160,7968,40720,3134,3,132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',116160.00,NULL,NULL,1,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(161,7968,40720,3134,3,133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',116160.00,NULL,NULL,1,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(162,7968,40720,3134,3,134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',9899.99,NULL,NULL,1,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(163,7968,40720,3134,3,135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',116160.00,NULL,NULL,1,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(164,7968,40720,3134,3,136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',116160.00,NULL,NULL,1,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(165,7968,40720,3134,3,137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',4443.33,NULL,NULL,1,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL);
INSERT INTO `balance_libro` VALUES (166,7968,40720,3134,3,138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',3439.21,NULL,NULL,1,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(167,7968,40720,3134,3,139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',157.19,NULL,NULL,1,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(168,7968,40720,3134,3,140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',1810.40,NULL,NULL,1,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(169,7968,40720,3134,3,141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',15244.03,NULL,NULL,1,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(170,7968,40720,3134,3,142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',8135.40,NULL,NULL,1,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(171,7968,40720,3134,3,143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',9737.93,NULL,NULL,1,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(172,7968,40720,3134,3,144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',117.93,NULL,NULL,1,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(173,7968,40720,3134,3,145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',1165.60,NULL,NULL,1,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(174,7968,40720,3134,3,146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',0.00,NULL,NULL,1,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(175,7968,40720,3134,3,147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',7718.17,NULL,NULL,1,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(176,7968,40720,3134,3,148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',7902.01,NULL,NULL,1,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(177,7968,40720,3134,3,149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',14362.65,NULL,NULL,1,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(178,7968,40720,3134,3,150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',3850.20,NULL,NULL,1,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(179,7968,40720,3134,3,151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',416.72,NULL,NULL,1,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(180,7968,40720,3134,3,152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',7454.01,NULL,NULL,1,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(181,7968,40720,3134,3,153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',9300.56,NULL,NULL,1,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(182,7968,40720,3134,3,154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',11812.44,NULL,NULL,1,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(183,7968,40720,3134,3,155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',13300.04,NULL,NULL,1,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(184,7968,40720,3134,3,156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',7709.47,NULL,NULL,1,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(185,7968,40720,3134,3,157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',11998.99,NULL,NULL,1,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(186,7968,40720,3134,3,158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',0.00,NULL,NULL,1,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(187,7968,40720,3134,3,159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',9004.90,NULL,NULL,1,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(188,7968,40720,3134,3,160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',500.00,NULL,NULL,1,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(189,7968,40720,3134,3,161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',25900.00,NULL,NULL,1,'2022-10-25 17:11:10','2022-10-25 17:11:39','2022-10-25 17:11:39'),(190,7968,40720,3134,3,161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',25900.00,NULL,NULL,1,'2022-10-25 17:11:39','2022-10-25 17:11:39',NULL);
INSERT INTO `balance_libro` VALUES (191,7968,40720,1518,3,162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',16918.51,NULL,NULL,1,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(192,7968,40720,1518,3,163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',2039.81,NULL,NULL,1,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(193,7968,40720,1518,3,164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',2176.20,NULL,NULL,1,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(194,7968,40720,1518,3,165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',227.77,NULL,NULL,1,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(195,7968,40720,1518,3,166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',12696.39,NULL,NULL,1,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(196,7968,40720,1518,3,167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',10871.19,NULL,NULL,1,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(197,7968,40720,1518,3,168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',7035.99,NULL,NULL,1,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(198,7968,40720,1518,3,169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',1602.71,NULL,NULL,1,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(199,7968,40720,1518,3,170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',167.21,NULL,NULL,1,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(200,7968,40720,1518,3,171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',940.92,NULL,NULL,1,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(201,7968,40720,1518,3,172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',13614.15,NULL,NULL,1,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(202,7968,40720,1518,3,173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',17215.16,NULL,NULL,1,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(203,7968,40720,1518,3,174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',17215.16,NULL,NULL,1,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(204,7968,40720,1518,3,175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',9246.15,NULL,NULL,1,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(205,7968,40720,1518,3,176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',7114.33,NULL,NULL,1,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(206,7968,40720,1518,3,177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',0.00,NULL,NULL,1,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(207,7968,40720,1518,3,178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',17204.45,NULL,NULL,1,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(208,7968,40720,1518,3,179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',13300.02,NULL,NULL,1,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(209,7968,40720,1518,3,180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',116160.00,NULL,NULL,1,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(210,7968,40720,1518,3,181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',4899.46,NULL,NULL,1,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(211,7968,40720,1518,3,182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',7222.64,NULL,NULL,1,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(212,7968,40720,1518,3,183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',20865.98,NULL,NULL,1,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48');
INSERT INTO `balance_libro` VALUES (213,7968,40720,1518,3,184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',973.40,NULL,NULL,1,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(214,7968,40720,1518,3,185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',126.54,NULL,NULL,1,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(215,7968,40720,1518,3,186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',4047.56,NULL,NULL,1,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(216,7968,40720,1518,3,187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',14362.65,NULL,NULL,1,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(217,7968,40720,1518,3,188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',32549.25,NULL,NULL,1,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(218,7968,40720,1518,3,189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',3162.00,NULL,NULL,1,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(219,7968,40720,1518,3,190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',404.13,NULL,NULL,1,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(220,7968,40720,1518,3,191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',13038.51,NULL,NULL,1,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(221,7968,40720,1518,3,192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',15715.38,NULL,NULL,1,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(222,7968,40720,1518,3,193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',8164.91,NULL,NULL,1,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(223,7968,40720,1518,3,194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',0.00,NULL,NULL,1,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(224,7968,40720,1518,3,195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',13300.02,NULL,NULL,1,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(225,7968,40720,1518,3,196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',25900.00,NULL,NULL,1,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(226,7968,40720,1518,3,197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',811.00,NULL,NULL,1,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(227,7968,40720,1518,3,198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1370.20,NULL,NULL,1,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(228,7968,40720,1518,3,199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',91.31,NULL,NULL,1,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(229,7968,40720,1518,3,200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',2039.81,NULL,NULL,1,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(230,7968,40720,1518,3,201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',2176.20,NULL,NULL,1,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(231,7968,40720,1518,3,202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',227.77,NULL,NULL,1,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(232,7968,40720,1518,3,203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',16918.51,NULL,NULL,1,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(233,7968,40720,1518,3,204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',12696.39,NULL,NULL,1,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(234,7968,40720,1518,3,205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',10871.19,NULL,NULL,1,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(235,7968,40720,1518,3,206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',7035.99,NULL,NULL,1,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL);
INSERT INTO `balance_libro` VALUES (236,7968,40720,1518,3,207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',1602.71,NULL,NULL,1,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(237,7968,40720,1518,3,208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',167.21,NULL,NULL,1,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(238,7968,40720,1518,3,209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',940.92,NULL,NULL,1,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(239,7968,40720,1518,3,210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',13614.15,NULL,NULL,1,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(240,7968,40720,1518,3,211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',17215.16,NULL,NULL,1,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(241,7968,40720,1518,3,212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',17215.16,NULL,NULL,1,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(242,7968,40720,1518,3,213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',9246.15,NULL,NULL,1,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(243,7968,40720,1518,3,214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',7114.33,NULL,NULL,1,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(244,7968,40720,1518,3,215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',116160.00,NULL,NULL,1,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(245,7968,40720,1518,3,216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',13300.04,NULL,NULL,1,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(246,7968,40720,1518,3,217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',0.00,NULL,NULL,1,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(247,7968,40720,1518,3,218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',17204.45,NULL,NULL,1,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(248,7968,40720,1518,3,219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',4899.46,NULL,NULL,1,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(249,7968,40720,1518,3,220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',126.54,NULL,NULL,1,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(250,7968,40720,1518,3,221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',973.40,NULL,NULL,1,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(251,7968,40720,1518,3,222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',7222.64,NULL,NULL,1,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(252,7968,40720,1518,3,223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',20865.98,NULL,NULL,1,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(253,7968,40720,1518,3,224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',4047.56,NULL,NULL,1,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(254,7968,40720,1518,3,225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',14362.65,NULL,NULL,1,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(255,7968,40720,1518,3,226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',404.13,NULL,NULL,1,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(256,7968,40720,1518,3,227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',3162.00,NULL,NULL,1,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(257,7968,40720,1518,3,228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',32549.25,NULL,NULL,1,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(258,7968,40720,1518,3,229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',13038.51,NULL,NULL,1,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(259,7968,40720,1518,3,230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',15715.38,NULL,NULL,1,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(260,7968,40720,1518,3,231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',0.00,NULL,NULL,1,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL);
INSERT INTO `balance_libro` VALUES (261,7968,40720,1518,3,232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',8164.91,NULL,NULL,1,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(262,7968,40720,1518,3,233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',13300.04,NULL,NULL,1,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(263,7968,40720,1518,3,234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',91.31,NULL,NULL,1,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(264,7968,40720,1518,3,235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1370.20,NULL,NULL,1,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(265,7968,40720,1518,3,236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',811.00,NULL,NULL,1,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(266,7968,40720,1518,3,237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',25900.00,NULL,NULL,1,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(267,7968,40720,1518,2,238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',2330.00,NULL,NULL,1,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(268,7968,40720,1518,2,239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',840.00,NULL,NULL,1,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(269,7968,40720,1518,2,240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',500.00,NULL,NULL,1,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(270,7968,40720,1518,2,241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',340.00,NULL,NULL,1,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(271,7968,40720,1518,2,242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',2300.00,NULL,NULL,1,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(272,7968,40720,1518,2,243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',1540.00,NULL,NULL,1,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(273,7968,40720,1518,2,244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',3460.00,NULL,NULL,1,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(274,7968,40720,1518,2,245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',1660.00,NULL,NULL,1,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(275,7968,40720,1518,2,246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',7860.00,NULL,NULL,1,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(276,7968,40720,1518,2,247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',1940.00,NULL,NULL,1,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(277,7968,40720,1518,2,248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',540.00,NULL,NULL,1,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(278,7968,40720,1518,2,249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',1110.00,NULL,NULL,1,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(279,7968,40720,1518,2,250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',2300.00,NULL,NULL,1,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(280,7968,40720,1518,2,251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',1270.00,NULL,NULL,1,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(281,7968,40720,1518,2,252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',2590.00,NULL,NULL,1,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(282,7968,40720,1518,2,253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',600.00,NULL,NULL,1,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(283,7968,40720,1518,2,254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',1860.00,NULL,NULL,1,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(284,7968,40720,1518,2,255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',2280.00,NULL,NULL,1,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(285,7968,40720,1518,2,256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',1290.00,NULL,NULL,1,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL);
INSERT INTO `balance_libro` VALUES (286,7968,40720,1518,2,257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',600.00,NULL,NULL,1,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(287,7968,40720,1518,2,258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',2900.00,NULL,NULL,1,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(288,7968,40720,1518,2,259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',1290.00,NULL,NULL,1,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(289,7968,40720,1518,2,260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',2260.00,NULL,NULL,1,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(290,7968,40720,1518,2,261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',720.00,NULL,NULL,1,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(291,7968,40720,1518,2,262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',1100.00,NULL,NULL,1,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(292,7968,40720,1518,2,263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',490.00,NULL,NULL,1,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(293,7968,40720,1518,2,264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',530.00,NULL,NULL,1,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(294,7968,40720,1518,2,265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',2640.00,NULL,NULL,1,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(295,7968,40720,1518,2,266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',1150.00,NULL,NULL,1,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(296,7968,40720,1518,2,267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',440.00,NULL,NULL,1,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(297,7968,40720,1518,2,268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',950.00,NULL,NULL,1,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(298,7968,40720,1518,2,269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',590.00,NULL,NULL,1,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(299,7968,40720,1518,2,270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',2400.00,NULL,NULL,1,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(300,7968,40720,1518,2,271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',1230.00,NULL,NULL,1,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(301,7968,40720,1518,2,272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',2470.00,NULL,NULL,1,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(302,7968,40720,1518,2,273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',1290.00,NULL,NULL,1,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(303,7968,40720,1518,2,274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',2300.00,NULL,NULL,1,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(304,7968,40720,1518,2,275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',930.00,NULL,NULL,1,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(305,7968,40720,1518,2,276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',3120.00,NULL,NULL,1,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(306,7968,40720,1518,2,277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',380.00,NULL,NULL,1,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(307,7968,40720,1518,2,278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',700.00,NULL,NULL,1,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(308,7968,40720,1518,2,279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',1210.00,NULL,NULL,1,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(309,7968,40720,1518,2,280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',2110.00,NULL,NULL,1,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(310,7968,40720,1518,2,281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',1110.00,NULL,NULL,1,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL);
INSERT INTO `balance_libro` VALUES (311,7968,40720,1518,2,282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',1800.00,NULL,NULL,1,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(312,7968,40720,1518,2,283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',820.00,NULL,NULL,1,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(313,7968,40720,1518,2,284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',3800.00,NULL,NULL,1,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(314,7968,40720,1518,2,285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',930.00,NULL,NULL,1,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(315,7968,40720,1518,2,286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',950.00,NULL,NULL,1,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(316,7968,40720,1518,2,287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',330.00,NULL,NULL,1,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(317,7968,40720,1518,2,288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1470.00,NULL,NULL,1,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(318,7968,40720,1518,2,289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',930.00,NULL,NULL,1,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(319,7968,40720,1518,2,290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',890.00,NULL,NULL,1,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(320,7968,40720,1518,2,291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1550.00,NULL,NULL,1,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(321,7968,40720,1518,2,292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1080.00,NULL,NULL,1,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(322,7968,40720,1518,2,293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1120.00,NULL,NULL,1,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(323,7968,40720,1518,2,294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',930.00,NULL,NULL,1,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(324,7968,40720,1518,2,295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',3300.00,NULL,NULL,1,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(325,7968,40720,1518,2,296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',3650.00,NULL,NULL,1,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(326,7968,40720,1518,2,297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1100.00,NULL,NULL,1,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(327,7968,40720,1518,2,298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',2580.00,NULL,NULL,1,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(328,7968,40720,1518,2,299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',2800.00,NULL,NULL,1,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(329,7968,40720,1518,2,300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',2010.00,NULL,NULL,1,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(330,7968,40720,1518,2,301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',3880.00,NULL,NULL,1,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(331,7968,40720,1518,2,302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',2800.00,NULL,NULL,1,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(332,7968,40720,1518,2,303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',600.00,NULL,NULL,1,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(333,7968,40720,1518,2,304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1270.00,NULL,NULL,1,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(334,7968,40720,1518,2,305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',880.00,NULL,NULL,1,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(335,7968,40720,1518,2,306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',830.00,NULL,NULL,1,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL);
INSERT INTO `balance_libro` VALUES (336,7968,40720,1518,2,307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',2010.00,NULL,NULL,1,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(337,7968,40720,1518,2,308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',1190.00,NULL,NULL,1,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(338,7968,40720,1518,2,309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',500.00,NULL,NULL,1,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(339,7968,40720,1518,2,310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',1690.00,NULL,NULL,1,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(340,7968,40720,1518,2,311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',1260.00,NULL,NULL,1,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(341,7968,40720,1518,2,312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',530.00,NULL,NULL,1,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(342,7968,40720,1518,2,313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',1940.00,NULL,NULL,1,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(343,7968,40720,1518,2,314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',550.00,NULL,NULL,1,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(344,7968,40720,1518,2,315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',1170.00,NULL,NULL,1,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(345,7968,40720,1518,2,316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',1720.00,NULL,NULL,1,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(346,7968,40720,1518,2,317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',2490.00,NULL,NULL,1,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(347,7968,40720,1518,2,318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',2340.00,NULL,NULL,1,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(348,7968,40720,1518,2,319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',2950.00,NULL,NULL,1,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(349,7968,40720,1518,2,320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',3450.00,NULL,NULL,1,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(350,7968,40720,1518,2,321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',3200.00,NULL,NULL,1,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(351,7968,40720,1518,2,322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1110.00,NULL,NULL,1,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(352,7968,40720,1518,2,323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',540.00,NULL,NULL,1,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(353,7968,40720,1518,2,324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1490.00,NULL,NULL,1,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(354,7968,40720,1518,2,325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',1800.00,NULL,NULL,1,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(355,7968,40720,1518,2,326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',950.00,NULL,NULL,1,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(356,7968,40720,1518,2,327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',2520.00,NULL,NULL,1,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(357,7968,40720,1518,2,328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1810.00,NULL,NULL,1,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(358,7968,40720,1518,2,329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',2600.00,NULL,NULL,1,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(359,7968,40720,1518,2,330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1500.00,NULL,NULL,1,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(360,7968,40720,1518,2,331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',1100.00,NULL,NULL,1,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL);
INSERT INTO `balance_libro` VALUES (361,7968,40720,1518,2,332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',2680.00,NULL,NULL,1,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(362,7968,40720,1518,2,333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',2260.00,NULL,NULL,1,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(363,7968,40720,1518,2,334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',530.00,NULL,NULL,1,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(364,7968,40720,1518,2,335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',2120.00,NULL,NULL,1,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(365,7968,40720,1518,2,336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',9820.00,NULL,NULL,1,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(366,7968,40720,1518,2,337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',7680.00,NULL,NULL,1,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(367,7968,40720,1518,2,338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1860.00,NULL,NULL,1,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(368,7968,40720,1518,2,339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1360.00,NULL,NULL,1,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(369,7968,40720,1518,2,340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1140.00,NULL,NULL,1,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(370,7968,40720,1518,2,341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1100.00,NULL,NULL,1,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(371,7968,40720,1518,2,342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',600.00,NULL,NULL,1,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(372,7968,40720,1518,2,343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',770.00,NULL,NULL,1,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(373,7968,40720,1518,2,344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',1470.00,NULL,NULL,1,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(374,7968,40720,1518,2,345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',440.00,NULL,NULL,1,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(375,7968,40720,1518,2,346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',1210.00,NULL,NULL,1,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(376,7968,40720,1518,2,347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',1860.00,NULL,NULL,1,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(377,7968,40720,1518,2,348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',500.00,NULL,NULL,1,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(378,7968,40720,1518,2,349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',1470.00,NULL,NULL,1,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(379,7968,40720,1518,2,350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',1540.00,NULL,NULL,1,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(380,7968,40720,1518,2,351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',660.00,NULL,NULL,1,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(381,7968,40720,1518,2,352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',600.00,NULL,NULL,1,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(382,7968,40720,1518,2,353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',1100.00,NULL,NULL,1,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(383,7968,40720,1518,2,354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',940.00,NULL,NULL,1,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(384,7968,40720,1518,2,355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',870.00,NULL,NULL,1,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(385,7968,40720,1518,2,356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',1280.00,NULL,NULL,1,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL);
INSERT INTO `balance_libro` VALUES (386,7968,40720,1518,2,357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',1960.00,NULL,NULL,1,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(387,7968,40720,1518,2,358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',2460.00,NULL,NULL,1,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(388,7968,40720,1518,2,359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',670.00,NULL,NULL,1,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(389,7968,40720,1518,2,360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',2280.00,NULL,NULL,1,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(390,7968,40720,1518,2,361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1920.00,NULL,NULL,1,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(391,7968,40720,1518,2,362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1290.00,NULL,NULL,1,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(392,7968,40720,1518,2,363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',630.00,NULL,NULL,1,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(393,7968,40720,1518,2,364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',520.00,NULL,NULL,1,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(394,7968,40720,1518,2,365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1100.00,NULL,NULL,1,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(395,7968,40720,1518,2,366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',2730.00,NULL,NULL,1,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(396,7968,40720,1518,2,367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1170.00,NULL,NULL,1,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(397,7968,40720,1518,2,368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1010.00,NULL,NULL,1,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(398,7968,40720,1518,2,369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',880.00,NULL,NULL,1,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(399,7968,40720,1518,2,370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',830.00,NULL,NULL,1,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(400,7968,40720,1518,2,371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',410.00,NULL,NULL,1,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(401,7968,40720,1518,2,372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',2690.00,NULL,NULL,1,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(402,7968,40720,1518,2,373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',2840.00,NULL,NULL,1,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(403,7968,40720,1518,2,374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',1690.00,NULL,NULL,1,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(404,7968,40720,1518,2,375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',1510.00,NULL,NULL,1,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(405,7968,40720,1518,2,376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',2440.00,NULL,NULL,1,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(406,7968,40720,1518,2,377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',420.00,NULL,NULL,1,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(407,7968,40720,1518,2,378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',580.00,NULL,NULL,1,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(408,7968,40720,1518,2,379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',1490.00,NULL,NULL,1,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(409,7968,40720,1518,2,380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',330.00,NULL,NULL,1,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(410,7968,40720,1518,2,381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1890.00,NULL,NULL,1,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL);
INSERT INTO `balance_libro` VALUES (411,7968,40720,1518,2,382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',2180.00,NULL,NULL,1,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(412,7968,40720,1518,2,383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1770.00,NULL,NULL,1,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(413,7968,40720,1518,2,384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',3400.00,NULL,NULL,1,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(414,7968,40720,1518,2,385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',630.00,NULL,NULL,1,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(415,7968,40720,1518,2,386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',1470.00,NULL,NULL,1,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(416,7968,40720,1518,2,387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',770.00,NULL,NULL,1,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(417,7968,40720,1518,2,388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',440.00,NULL,NULL,1,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(418,7968,40720,1518,2,389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',2300.00,NULL,NULL,1,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(419,7968,40720,1518,2,390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',3400.00,NULL,NULL,1,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(420,7968,40720,1518,2,391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',3250.00,NULL,NULL,1,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(421,7968,40720,1518,2,392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1580.00,NULL,NULL,1,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(422,7968,40720,1518,2,393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',2200.00,NULL,NULL,1,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(423,7968,40720,1518,2,394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1200.00,NULL,NULL,1,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(424,7968,40720,1518,2,395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',880.00,NULL,NULL,1,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(425,7968,40720,1518,2,396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',560.00,NULL,NULL,1,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(426,7968,40720,1518,2,397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1700.00,NULL,NULL,1,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(427,7968,40720,1518,2,398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1100.00,NULL,NULL,1,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(428,7968,40720,1518,2,399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1800.00,NULL,NULL,1,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(429,7968,40720,1518,2,400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',890.00,NULL,NULL,1,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(430,7968,40720,1518,2,401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1050.00,NULL,NULL,1,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(431,7968,40720,1518,2,402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',1670.00,NULL,NULL,1,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(432,7968,40720,1518,2,403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1300.00,NULL,NULL,1,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(433,7968,40720,1518,2,404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1590.00,NULL,NULL,1,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(434,7968,40720,1518,2,405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',2280.00,NULL,NULL,1,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(435,7968,40720,1518,2,406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',930.00,NULL,NULL,1,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL);
INSERT INTO `balance_libro` VALUES (436,7968,40720,1518,2,407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',2010.00,NULL,NULL,1,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(437,7968,40720,1518,2,408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',860.00,NULL,NULL,1,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(438,7968,40720,1518,2,409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',600.00,NULL,NULL,1,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(439,7968,40720,1518,2,410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',1430.00,NULL,NULL,1,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(440,7968,40720,1518,2,411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',930.00,NULL,NULL,1,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(441,7968,40720,1518,2,412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',3400.00,NULL,NULL,1,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(442,7968,40720,1518,2,413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',380.00,NULL,NULL,1,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(443,7968,40720,1518,2,414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',2460.00,NULL,NULL,1,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(444,7968,40720,1518,2,415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1730.00,NULL,NULL,1,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(445,7968,40720,1518,2,416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1340.00,NULL,NULL,1,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(446,7968,40720,1518,2,417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',2340.00,NULL,NULL,1,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(447,7968,40720,1518,2,418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1100.00,NULL,NULL,1,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(448,7968,40720,1518,2,419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',930.00,NULL,NULL,1,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(449,7968,40720,1518,2,420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',330.00,NULL,NULL,1,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(450,7968,40720,1518,2,421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1420.00,NULL,NULL,1,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(451,7968,40720,1518,2,422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1170.00,NULL,NULL,1,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(452,7968,40720,1518,2,423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1260.00,NULL,NULL,1,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(453,7968,40720,1518,2,424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',2310.00,NULL,NULL,1,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(454,7968,40720,1518,2,425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',930.00,NULL,NULL,1,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(455,7968,40720,1518,2,426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',2390.00,NULL,NULL,1,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(456,7968,40720,1518,2,427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',1500.00,NULL,NULL,1,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(457,7968,40720,1518,2,428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',2000.00,NULL,NULL,1,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(458,7968,40720,1518,2,429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',1510.00,NULL,NULL,1,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(459,7968,40720,1518,2,430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',820.00,NULL,NULL,1,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(460,7968,40720,1518,2,431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',1250.00,NULL,NULL,1,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL);
INSERT INTO `balance_libro` VALUES (461,7968,40720,1518,2,432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',410.00,NULL,NULL,1,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(462,7968,40720,1518,2,433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',1460.00,NULL,NULL,1,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(463,7968,40720,1518,2,434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',3290.00,NULL,NULL,1,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(464,7968,40720,1518,2,435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',1750.00,NULL,NULL,1,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(465,7968,40720,1518,2,436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',1670.00,NULL,NULL,1,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(466,7968,40720,1518,2,437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',3960.00,NULL,NULL,1,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(467,7968,40720,1518,2,438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',1630.00,NULL,NULL,1,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(468,7968,40720,1518,2,439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',4010.00,NULL,NULL,1,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(469,7968,40720,1518,2,440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',1010.00,NULL,NULL,1,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(470,7968,40720,1518,2,441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',1510.00,NULL,NULL,1,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(471,7968,40720,1518,2,442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',2180.00,NULL,NULL,1,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(472,7968,40720,1518,2,443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',1310.00,NULL,NULL,1,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(473,7968,40720,1518,2,444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',420.00,NULL,NULL,1,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(474,7968,40720,1518,2,445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',2510.00,NULL,NULL,1,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(475,7968,40720,1518,2,446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',3270.00,NULL,NULL,1,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(476,7968,40720,1518,2,447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',2860.00,NULL,NULL,1,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(477,7968,40720,1518,2,448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',3230.00,NULL,NULL,1,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(478,7968,40720,1518,2,449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',2390.00,NULL,NULL,1,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(479,7968,40720,1518,2,450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',1030.00,NULL,NULL,1,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(480,7968,40720,1518,2,451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',800.00,NULL,NULL,1,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(481,7968,40720,1518,2,452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',1100.00,NULL,NULL,1,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(482,7968,40720,1518,2,453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',860.00,NULL,NULL,1,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(483,7968,40720,1518,2,454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',2360.00,NULL,NULL,1,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(484,7968,40720,1518,2,455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',2250.00,NULL,NULL,1,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(485,7968,40720,1518,2,456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',930.00,NULL,NULL,1,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL);
INSERT INTO `balance_libro` VALUES (486,7968,40720,1518,2,457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',3400.00,NULL,NULL,1,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(487,7968,40720,1518,2,458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',2390.00,NULL,NULL,1,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(488,7968,40720,1518,2,459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1750.00,NULL,NULL,1,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(489,7968,40720,1518,2,460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1420.00,NULL,NULL,1,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(490,7968,40720,1518,2,461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1830.00,NULL,NULL,1,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(491,7968,40720,1518,2,462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1400.00,NULL,NULL,1,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(492,7968,40720,1518,2,463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',680.00,NULL,NULL,1,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(493,7968,40720,1518,2,464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',2760.00,NULL,NULL,1,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(494,7968,40720,1518,2,465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',1210.00,NULL,NULL,1,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(495,7968,40720,1518,2,466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',3210.00,NULL,NULL,1,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(496,7968,40720,1518,2,467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',2790.00,NULL,NULL,1,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(497,7968,40720,1518,2,468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',2790.00,NULL,NULL,1,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(498,7968,40720,1518,2,469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',1980.00,NULL,NULL,1,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(499,7968,40720,1518,2,470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',2380.00,NULL,NULL,1,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(500,7968,40720,1518,2,471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',1000.00,NULL,NULL,1,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(501,7968,40720,1518,2,472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',660.00,NULL,NULL,1,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(502,7968,40720,1518,2,473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',1550.00,NULL,NULL,1,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(503,7968,40720,1518,2,474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',1190.00,NULL,NULL,1,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(504,7968,40720,1518,2,475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',2790.00,NULL,NULL,1,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(505,7968,40720,1518,2,476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',790.00,NULL,NULL,1,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(506,7968,40720,1518,2,477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1300.00,NULL,NULL,1,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(507,7968,40720,1518,2,478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',2310.00,NULL,NULL,1,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(508,7968,40720,1518,2,479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',3240.00,NULL,NULL,1,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(509,7968,40720,1518,2,480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',930.00,NULL,NULL,1,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(510,7968,40720,1518,2,481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',2200.00,NULL,NULL,1,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL);
INSERT INTO `balance_libro` VALUES (511,7968,40720,1518,2,482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',6090.00,NULL,NULL,1,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(512,7968,40720,1518,2,483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1100.00,NULL,NULL,1,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(513,7968,40720,1518,2,484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',5070.00,NULL,NULL,1,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(514,7968,40720,1518,2,485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',680.00,NULL,NULL,1,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(515,7968,40720,1518,2,486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1850.00,NULL,NULL,1,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(516,7968,40720,1518,2,487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',1500.00,NULL,NULL,1,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(517,7968,40720,1518,2,488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2000.00,NULL,NULL,1,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(518,7968,40720,1518,2,489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1100.00,NULL,NULL,1,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(519,7968,40720,1518,2,490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2200.00,NULL,NULL,1,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(520,7968,40720,1518,2,491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2390.00,NULL,NULL,1,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(521,7968,40720,1518,2,492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',800.00,NULL,NULL,1,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(522,7968,40720,1518,2,493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1860.00,NULL,NULL,1,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(523,7968,40720,1518,2,494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2970.00,NULL,NULL,1,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(524,7968,40720,1518,2,495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',630.00,NULL,NULL,1,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(525,7968,40720,1518,2,496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2420.00,NULL,NULL,1,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(526,7968,40720,1518,2,497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',2410.00,NULL,NULL,1,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(527,7968,40720,1518,2,498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1490.00,NULL,NULL,1,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(528,7968,40720,1518,2,499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',740.00,NULL,NULL,1,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(529,7968,40720,1518,2,500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',950.00,NULL,NULL,1,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(530,7968,40720,1518,2,501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1150.00,NULL,NULL,1,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(531,7968,40720,1518,2,502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',500.00,NULL,NULL,1,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(532,7968,40720,1518,2,503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1460.00,NULL,NULL,1,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(533,7968,40720,1518,2,504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',4500.00,NULL,NULL,1,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(534,7968,40720,1518,2,505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',2930.00,NULL,NULL,1,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(535,7968,40720,1518,2,506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',3040.00,NULL,NULL,1,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL);
INSERT INTO `balance_libro` VALUES (536,7968,40720,1518,2,507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',1010.00,NULL,NULL,1,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(537,7968,40720,1518,2,508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',860.00,NULL,NULL,1,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(538,7968,40720,1518,2,509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',440.00,NULL,NULL,1,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(539,7968,40720,1518,2,510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',680.00,NULL,NULL,1,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(540,7968,40720,1518,2,511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',3870.00,NULL,NULL,1,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(541,7968,40720,1518,2,512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1190.00,NULL,NULL,1,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(542,7968,40720,1518,2,513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',330.00,NULL,NULL,1,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(543,7968,40720,1518,2,514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2390.00,NULL,NULL,1,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(544,7968,40720,1518,2,515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',940.00,NULL,NULL,1,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(545,7968,40720,1518,2,516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',840.00,NULL,NULL,1,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(546,7968,40720,1518,2,517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1040.00,NULL,NULL,1,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(547,7968,40720,1518,2,518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1670.00,NULL,NULL,1,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(548,7968,40720,1518,2,519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',600.00,NULL,NULL,1,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(549,7968,40720,1518,2,520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1570.00,NULL,NULL,1,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(550,7968,40720,1518,2,521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1100.00,NULL,NULL,1,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(551,7968,40720,1518,2,522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',930.00,NULL,NULL,1,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(552,7968,40720,3134,2,523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',960.00,NULL,NULL,1,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(553,7968,40720,3134,2,524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',1570.00,NULL,NULL,1,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(554,7968,40720,3134,2,525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',1800.00,NULL,NULL,1,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(555,7968,40720,3134,2,526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',1070.00,NULL,NULL,1,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(556,7968,40720,3134,2,527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',1230.00,NULL,NULL,1,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(557,7968,40720,3134,2,528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',1500.00,NULL,NULL,1,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(558,7968,40720,3134,2,529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',1080.00,NULL,NULL,1,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(559,7968,40720,3134,2,530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',490.00,NULL,NULL,1,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(560,7968,40720,3134,2,531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',1430.00,NULL,NULL,1,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL);
INSERT INTO `balance_libro` VALUES (561,7968,40720,3134,2,532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',980.00,NULL,NULL,1,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(562,7968,40720,3134,2,533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',1580.00,NULL,NULL,1,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(563,7968,40720,3134,2,534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',790.00,NULL,NULL,1,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(564,7968,40720,3134,2,535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',1400.00,NULL,NULL,1,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(565,7968,40720,3134,2,536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',910.00,NULL,NULL,1,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(566,7968,40720,3134,2,537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',3020.00,NULL,NULL,1,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(567,7968,40720,3134,2,538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',3370.00,NULL,NULL,1,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(568,7968,40720,3134,2,539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',2520.00,NULL,NULL,1,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(569,7968,40720,3134,2,540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-03','2022-09-03',1860.00,NULL,NULL,1,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(570,7968,40720,3134,2,541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-03','2022-09-03',1240.00,NULL,NULL,1,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(571,7968,40720,3134,2,542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-03','2022-09-03',1250.00,NULL,NULL,1,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(572,7968,40720,3134,2,543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-03','2022-09-03',2860.00,NULL,NULL,1,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(573,7968,40720,3134,2,544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-03','2022-09-03',3370.00,NULL,NULL,1,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(574,7968,40720,3134,2,545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-03','2022-09-03',3930.00,NULL,NULL,1,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(575,7968,40720,3134,2,546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-03','2022-09-03',2480.00,NULL,NULL,1,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(576,7968,40720,3134,2,547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-03','2022-09-03',960.00,NULL,NULL,1,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(577,7968,40720,3134,2,548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-03','2022-09-03',1380.00,NULL,NULL,1,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(578,7968,40720,3134,2,549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-03','2022-09-03',930.00,NULL,NULL,1,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(579,7968,40720,3134,2,550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',510.00,NULL,NULL,1,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(580,7968,40720,3134,2,551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',1440.00,NULL,NULL,1,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(581,7968,40720,3134,2,552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',1430.00,NULL,NULL,1,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(582,7968,40720,3134,2,553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',490.00,NULL,NULL,1,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(583,7968,40720,3134,2,554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',980.00,NULL,NULL,1,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(584,7968,40720,3134,2,555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',2030.00,NULL,NULL,1,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(585,7968,40720,3134,2,556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',750.00,NULL,NULL,1,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL);
INSERT INTO `balance_libro` VALUES (586,7968,40720,3134,2,557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',440.00,NULL,NULL,1,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(587,7968,40720,3134,2,558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',1340.00,NULL,NULL,1,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(588,7968,40720,3134,2,559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',740.00,NULL,NULL,1,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(589,7968,40720,3134,2,560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',1350.00,NULL,NULL,1,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(590,7968,40720,3134,2,561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',1380.00,NULL,NULL,1,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(591,7968,40720,3134,2,562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',1100.00,NULL,NULL,1,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(592,7968,40720,3134,2,563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',1600.00,NULL,NULL,1,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(593,7968,40720,3134,2,564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',1100.00,NULL,NULL,1,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(594,7968,40720,3134,2,565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',980.00,NULL,NULL,1,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(595,7968,40720,3134,2,566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',1280.00,NULL,NULL,1,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(596,7968,40720,3134,2,567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',1340.00,NULL,NULL,1,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(597,7968,40720,3134,2,568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',1490.00,NULL,NULL,1,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(598,7968,40720,3134,2,569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',920.00,NULL,NULL,1,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(599,7968,40720,3134,2,570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',2100.00,NULL,NULL,1,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(600,7968,40720,3134,2,571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',570.00,NULL,NULL,1,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(601,7968,40720,3134,2,572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',1970.00,NULL,NULL,1,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(602,7968,40720,3134,2,573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',680.00,NULL,NULL,1,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(603,7968,40720,3134,2,574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',1900.00,NULL,NULL,1,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(604,7968,40720,3134,2,575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',740.00,NULL,NULL,1,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(605,7968,40720,3134,2,576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',1690.00,NULL,NULL,1,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(606,7968,40720,3134,2,577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',970.00,NULL,NULL,1,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(607,7968,40720,3134,2,578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',2960.00,NULL,NULL,1,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(608,7968,40720,3134,2,579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',540.00,NULL,NULL,1,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(609,7968,40720,3134,2,580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',700.00,NULL,NULL,1,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(610,7968,40720,3134,2,581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',1190.00,NULL,NULL,1,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL);
INSERT INTO `balance_libro` VALUES (611,7968,40720,3134,2,582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',3050.00,NULL,NULL,1,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(612,7968,40720,3134,2,583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',2860.00,NULL,NULL,1,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(613,7968,40720,3134,2,584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',2500.00,NULL,NULL,1,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(614,7968,40720,3134,2,585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',980.00,NULL,NULL,1,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(615,7968,40720,3134,2,586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',1840.00,NULL,NULL,1,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(616,7968,40720,3134,2,587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',900.00,NULL,NULL,1,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(617,7968,40720,3134,2,588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',560.00,NULL,NULL,1,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(618,7968,40720,3134,2,589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',1300.00,NULL,NULL,1,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(619,7968,40720,3134,2,590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',650.00,NULL,NULL,1,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(620,7968,40720,3134,2,591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',1580.00,NULL,NULL,1,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(621,7968,40720,3134,2,592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',980.00,NULL,NULL,1,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(622,7968,40720,3134,2,593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',1170.00,NULL,NULL,1,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(623,7968,40720,3134,2,594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',790.00,NULL,NULL,1,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(624,7968,40720,3134,2,595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',1350.00,NULL,NULL,1,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(625,7968,40720,3134,2,596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',1100.00,NULL,NULL,1,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(626,7968,40720,3134,2,597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',2900.00,NULL,NULL,1,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(627,7968,40720,3134,2,598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',350.00,NULL,NULL,1,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(628,7968,40720,3134,2,599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',350.00,NULL,NULL,1,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(629,7968,40720,3134,2,600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',3330.00,NULL,NULL,1,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(630,7968,40720,3134,2,601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',1090.00,NULL,NULL,1,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(631,7968,40720,3134,2,602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',1960.00,NULL,NULL,1,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(632,7968,40720,3134,2,603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',1930.00,NULL,NULL,1,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(633,7968,40720,3134,2,604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',3250.00,NULL,NULL,1,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(634,7968,40720,3134,2,605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',1620.00,NULL,NULL,1,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(635,7968,40720,3134,2,606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',3510.00,NULL,NULL,1,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL);
INSERT INTO `balance_libro` VALUES (636,7968,40720,3134,2,607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',3530.00,NULL,NULL,1,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(637,7968,40720,3134,2,608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',3550.00,NULL,NULL,1,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(638,7968,40720,3134,2,609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',1870.00,NULL,NULL,1,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(639,7968,40720,3134,2,610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',460.00,NULL,NULL,1,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(640,7968,40720,3134,2,611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',790.00,NULL,NULL,1,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(641,7968,40720,3134,2,612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',360.00,NULL,NULL,1,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(642,7968,40720,3134,2,613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',310.00,NULL,NULL,1,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(643,7968,40720,3134,2,614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',1440.00,NULL,NULL,1,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(644,7968,40720,3134,2,615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',1940.00,NULL,NULL,1,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(645,7968,40720,3134,2,616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',1440.00,NULL,NULL,1,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(646,7968,40720,3134,2,617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',1430.00,NULL,NULL,1,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(647,7968,40720,3134,2,618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',1370.00,NULL,NULL,1,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(648,7968,40720,3134,2,619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',2870.00,NULL,NULL,1,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(649,7968,40720,3134,2,620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',2000.00,NULL,NULL,1,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(650,7968,40720,3134,2,621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',1080.00,NULL,NULL,1,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(651,7968,40720,3134,2,622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',940.00,NULL,NULL,1,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(652,7968,40720,3134,2,623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',620.00,NULL,NULL,1,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(653,7968,40720,3134,2,624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',1960.00,NULL,NULL,1,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(654,7968,40720,3134,2,625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',1100.00,NULL,NULL,1,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(655,7968,40720,3134,2,626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',2030.00,NULL,NULL,1,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(656,7968,40720,3134,2,627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',790.00,NULL,NULL,1,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(657,7968,40720,3134,2,628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',810.00,NULL,NULL,1,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(658,7968,40720,3134,2,629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',2570.00,NULL,NULL,1,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(659,7968,40720,3134,2,630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',420.00,NULL,NULL,1,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(660,7968,40720,3134,2,631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',1490.00,NULL,NULL,1,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL);
INSERT INTO `balance_libro` VALUES (661,7968,40720,3134,2,632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',980.00,NULL,NULL,1,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(662,7968,40720,3134,2,633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',3430.00,NULL,NULL,1,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(663,7968,40720,3134,2,634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',1580.00,NULL,NULL,1,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(664,7968,40720,3134,2,635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',1200.00,NULL,NULL,1,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(665,7968,40720,3134,2,636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',1050.00,NULL,NULL,1,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(666,7968,40720,3134,2,637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',2570.00,NULL,NULL,1,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(667,7968,40720,3134,2,638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',400.00,NULL,NULL,1,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(668,7968,40720,3134,2,639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',1280.00,NULL,NULL,1,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(669,7968,40720,3134,2,640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',820.00,NULL,NULL,1,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(670,7968,40720,3134,2,641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',2400.00,NULL,NULL,1,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(671,7968,40720,3134,2,642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',890.00,NULL,NULL,1,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(672,7968,40720,3134,2,643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',650.00,NULL,NULL,1,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(673,7968,40720,3134,2,644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',470.00,NULL,NULL,1,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(674,7968,40720,3134,2,645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',560.00,NULL,NULL,1,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(675,7968,40720,3134,2,646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',1220.00,NULL,NULL,1,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(676,7968,40720,3134,2,647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',980.00,NULL,NULL,1,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(677,7968,40720,3134,2,648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',980.00,NULL,NULL,1,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(678,7968,40720,3134,2,649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',1310.00,NULL,NULL,1,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(679,7968,40720,3134,2,650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',1940.00,NULL,NULL,1,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(680,7968,40720,3134,2,651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',1960.00,NULL,NULL,1,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(681,7968,40720,3134,2,652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',1430.00,NULL,NULL,1,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(682,7968,40720,3134,2,653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',1960.00,NULL,NULL,1,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(683,7968,40720,3134,2,654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',2940.00,NULL,NULL,1,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(684,7968,40720,3134,2,655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',1090.00,NULL,NULL,1,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(685,7968,40720,3134,2,656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',1440.00,NULL,NULL,1,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL);
INSERT INTO `balance_libro` VALUES (686,7968,40720,3134,2,657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',2110.00,NULL,NULL,1,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(687,7968,40720,3134,2,658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',1020.00,NULL,NULL,1,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(688,7968,40720,3134,2,659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',2550.00,NULL,NULL,1,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(689,7968,40720,3134,2,660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',2480.00,NULL,NULL,1,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(690,7968,40720,3134,2,661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',980.00,NULL,NULL,1,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(691,7968,40720,3134,2,662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',1250.00,NULL,NULL,1,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(692,7968,40720,3134,2,663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',3530.00,NULL,NULL,1,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(693,7968,40720,3134,2,664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',1250.00,NULL,NULL,1,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(694,7968,40720,3134,2,665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',1520.00,NULL,NULL,1,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(695,7968,40720,3134,2,666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',1720.00,NULL,NULL,1,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(696,7968,40720,3134,2,667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',9160.00,NULL,NULL,1,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(697,7968,40720,3134,2,668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',1250.00,NULL,NULL,1,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(698,7968,40720,3134,2,669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',1440.00,NULL,NULL,1,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(699,7968,40720,3134,2,670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',1350.00,NULL,NULL,1,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(700,7968,40720,3134,2,671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',610.00,NULL,NULL,1,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(701,7968,40720,3134,2,672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',1190.00,NULL,NULL,1,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(702,7968,40720,3134,2,673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',1100.00,NULL,NULL,1,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(703,7968,40720,3134,2,674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',2130.00,NULL,NULL,1,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(704,7968,40720,3134,2,675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',980.00,NULL,NULL,1,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(705,7968,40720,3134,2,676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',980.00,NULL,NULL,1,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(706,7968,40720,3134,2,677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',880.00,NULL,NULL,1,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(707,7968,40720,3134,2,678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',1060.00,NULL,NULL,1,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(708,7968,40720,3134,2,679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',820.00,NULL,NULL,1,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(709,7968,40720,3134,2,680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',1300.00,NULL,NULL,1,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(710,7968,40720,3134,2,681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',460.00,NULL,NULL,1,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL);
INSERT INTO `balance_libro` VALUES (711,7968,40720,3134,2,682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',800.00,NULL,NULL,1,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(712,7968,40720,3134,2,683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',2990.00,NULL,NULL,1,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(713,7968,40720,3134,2,684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',560.00,NULL,NULL,1,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(714,7968,40720,3134,2,685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',1580.00,NULL,NULL,1,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(715,7968,40720,3134,2,686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',980.00,NULL,NULL,1,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(716,7968,40720,3134,2,687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',1440.00,NULL,NULL,1,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(717,7968,40720,3134,2,688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',510.00,NULL,NULL,1,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(718,7968,40720,3134,2,689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',720.00,NULL,NULL,1,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(719,7968,40720,3134,2,690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',600.00,NULL,NULL,1,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(720,7968,40720,3134,2,691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',720.00,NULL,NULL,1,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(721,7968,40720,3134,2,692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',560.00,NULL,NULL,1,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(722,7968,40720,3134,2,693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',1340.00,NULL,NULL,1,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(723,7968,40720,3134,2,694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',980.00,NULL,NULL,1,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(724,7968,40720,3134,2,695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',2990.00,NULL,NULL,1,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(725,7968,40720,3134,2,696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',560.00,NULL,NULL,1,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(726,7968,40720,3134,2,697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',360.00,NULL,NULL,1,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(727,7968,40720,3134,2,698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',1000.00,NULL,NULL,1,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(728,7968,40720,3134,2,699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',1620.00,NULL,NULL,1,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(729,7968,40720,3134,2,700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',610.00,NULL,NULL,1,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(730,7968,40720,3134,2,701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',1990.00,NULL,NULL,1,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(731,7968,40720,3134,2,702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',1580.00,NULL,NULL,1,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(732,7968,40720,3134,2,703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',980.00,NULL,NULL,1,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(733,7968,40720,3134,2,704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',950.00,NULL,NULL,1,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(734,7968,40720,3134,2,705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',3200.00,NULL,NULL,1,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(735,7968,40720,3134,2,706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',1440.00,NULL,NULL,1,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL);
INSERT INTO `balance_libro` VALUES (736,7968,40720,3134,2,707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',720.00,NULL,NULL,1,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(737,7968,40720,3134,2,708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',280.00,NULL,NULL,1,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(738,7968,40720,3134,2,709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',560.00,NULL,NULL,1,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(739,7968,40720,3134,2,710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',1710.00,NULL,NULL,1,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(740,7968,40720,3134,2,711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',490.00,NULL,NULL,1,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(741,7968,40720,3134,2,712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',1960.00,NULL,NULL,1,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(742,7968,40720,3134,2,713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',1050.00,NULL,NULL,1,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(743,7968,40720,3134,2,714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',1200.00,NULL,NULL,1,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(744,7968,40720,3134,2,715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',980.00,NULL,NULL,1,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(745,7968,40720,3134,2,716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',1940.00,NULL,NULL,1,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(746,7968,40720,3134,2,717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',2080.00,NULL,NULL,1,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(747,7968,40720,3134,2,718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',980.00,NULL,NULL,1,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(748,7968,40720,3134,2,719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-24','2022-09-24',510.00,NULL,NULL,1,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(749,7968,40720,3134,2,720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-24','2022-09-24',1860.00,NULL,NULL,1,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(750,7968,40720,3134,2,721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-24','2022-09-24',1350.00,NULL,NULL,1,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(751,7968,40720,3134,2,722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-24','2022-09-24',3470.00,NULL,NULL,1,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(752,7968,40720,3134,2,723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-24','2022-09-24',5890.00,NULL,NULL,1,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(753,7968,40720,3134,2,724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-24','2022-09-24',2320.00,NULL,NULL,1,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(754,7968,40720,3134,2,725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-24','2022-09-24',2300.00,NULL,NULL,1,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(755,7968,40720,3134,2,726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-24','2022-09-24',2240.00,NULL,NULL,1,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(756,7968,40720,3134,2,727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-24','2022-09-24',1040.00,NULL,NULL,1,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(757,7968,40720,3134,2,728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-24','2022-09-24',1350.00,NULL,NULL,1,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(758,7968,40720,3134,2,729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',730.00,NULL,NULL,1,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(759,7968,40720,3134,2,730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',490.00,NULL,NULL,1,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(760,7968,40720,3134,2,731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',970.00,NULL,NULL,1,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL);
INSERT INTO `balance_libro` VALUES (761,7968,40720,3134,2,732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',2740.00,NULL,NULL,1,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(762,7968,40720,3134,2,733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',1460.00,NULL,NULL,1,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(763,7968,40720,3134,2,734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',980.00,NULL,NULL,1,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(764,7968,40720,3134,2,735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',1100.00,NULL,NULL,1,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(765,7968,40720,3134,2,736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',180.00,NULL,NULL,1,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(766,7968,40720,3134,2,737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',730.00,NULL,NULL,1,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(767,7968,40720,3134,2,738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',1650.00,NULL,NULL,1,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(768,7968,40720,3134,2,739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',1540.00,NULL,NULL,1,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(769,7968,40720,3134,2,740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',1860.00,NULL,NULL,1,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(770,7968,40720,3134,2,741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',1050.00,NULL,NULL,1,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(771,7968,40720,3134,2,742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',1580.00,NULL,NULL,1,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(772,7968,40720,3134,2,743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',750.00,NULL,NULL,1,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(773,7968,40720,3134,2,744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',1100.00,NULL,NULL,1,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(774,7968,40720,3134,2,745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',1020.00,NULL,NULL,1,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(775,7968,40720,3134,2,746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',310.00,NULL,NULL,1,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(776,7968,40720,3134,2,747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',280.00,NULL,NULL,1,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(777,7968,40720,3134,2,748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',440.00,NULL,NULL,1,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(778,7968,40720,3134,2,749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',1300.00,NULL,NULL,1,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(779,7968,40720,3134,2,750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',260.00,NULL,NULL,1,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(780,7968,40720,3134,2,751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',1310.00,NULL,NULL,1,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(781,7968,40720,3134,2,752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',1580.00,NULL,NULL,1,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(782,7968,40720,3134,2,753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',2670.00,NULL,NULL,1,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(783,7968,40720,3134,2,754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',2200.00,NULL,NULL,1,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(784,7968,40720,3134,2,755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',1100.00,NULL,NULL,1,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(785,7968,40720,3134,2,756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',1190.00,NULL,NULL,1,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL);
INSERT INTO `balance_libro` VALUES (786,7968,40720,3134,2,757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',1350.00,NULL,NULL,1,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(787,7968,40720,3134,2,758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',650.00,NULL,NULL,1,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(788,7968,40720,3134,2,759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',2910.00,NULL,NULL,1,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(789,7968,40720,3134,2,760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',1650.00,NULL,NULL,1,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(790,7968,40720,3134,2,761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',2280.00,NULL,NULL,1,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(791,7968,40720,3134,2,762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',2200.00,NULL,NULL,1,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(792,7968,40720,3134,2,763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',1230.00,NULL,NULL,1,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(793,7968,40720,3134,2,764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',1660.00,NULL,NULL,1,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(794,7968,40720,3134,2,765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',2200.00,NULL,NULL,1,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(795,7968,40720,3134,2,766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',930.00,NULL,NULL,1,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(796,7968,40720,3134,2,767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',1100.00,NULL,NULL,1,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(797,7968,40720,3134,2,768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',2570.00,NULL,NULL,1,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(798,7968,40720,3134,2,769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',1100.00,NULL,NULL,1,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(799,7968,40720,3134,2,770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',4740.00,NULL,NULL,1,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(800,7968,40720,3134,2,771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',1190.00,NULL,NULL,1,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(801,7968,40720,3134,2,772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',600.00,NULL,NULL,1,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(802,7968,40720,3134,2,773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',1650.00,NULL,NULL,1,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(803,7968,40720,3134,2,774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',2030.00,NULL,NULL,1,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(804,7968,40720,3134,2,775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',1950.00,NULL,NULL,1,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(805,7968,40720,3134,2,776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',2090.00,NULL,NULL,1,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(806,7968,40720,3134,2,777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',2200.00,NULL,NULL,1,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(807,7968,40720,3134,2,778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',3120.00,NULL,NULL,1,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(808,7968,40720,3134,2,779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',2790.00,NULL,NULL,1,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(809,7968,40720,3134,2,780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',2580.00,NULL,NULL,1,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(810,7968,40720,3134,2,781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',330.00,NULL,NULL,1,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL);
INSERT INTO `balance_libro` VALUES (811,7968,40720,3134,2,782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',1060.00,NULL,NULL,1,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(812,7968,40720,3134,2,783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',1520.00,NULL,NULL,1,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(813,7968,40720,3133,2,784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',1050.00,NULL,NULL,1,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(814,7968,40720,3133,2,785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',1580.00,NULL,NULL,1,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(815,7968,40720,3133,2,786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',1580.00,NULL,NULL,1,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(816,7968,40720,3133,2,787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',3210.00,NULL,NULL,1,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(817,7968,40720,3133,2,788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',1290.00,NULL,NULL,1,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(818,7968,40720,3133,2,789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',2350.00,NULL,NULL,1,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(819,7968,40720,3133,2,790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',940.00,NULL,NULL,1,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(820,7968,40720,3133,2,791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',2060.00,NULL,NULL,1,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(821,7968,40720,3133,2,792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',320.00,NULL,NULL,1,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(822,7968,40720,3133,2,793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',1080.00,NULL,NULL,1,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(823,7968,40720,3133,2,794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',1350.00,NULL,NULL,1,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(824,7968,40720,3133,2,795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',1990.00,NULL,NULL,1,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(825,7968,40720,3133,2,796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',1100.00,NULL,NULL,1,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(826,7968,40720,3133,2,797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',2670.00,NULL,NULL,1,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(827,7968,40720,3133,2,798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',3750.00,NULL,NULL,1,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(828,7968,40720,3133,2,799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',2510.00,NULL,NULL,1,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(829,7968,40720,3133,2,800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',1300.00,NULL,NULL,1,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(830,7968,40720,3133,2,801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',1840.00,NULL,NULL,1,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(831,7968,40720,3133,2,802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',1680.00,NULL,NULL,1,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(832,7968,40720,3133,2,803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',3530.00,NULL,NULL,1,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(833,7968,40720,3133,2,804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',1630.00,NULL,NULL,1,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(834,7968,40720,3133,2,805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',1050.00,NULL,NULL,1,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(835,7968,40720,3133,2,806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',570.00,NULL,NULL,1,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL);
INSERT INTO `balance_libro` VALUES (836,7968,40720,3133,2,807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',1580.00,NULL,NULL,1,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(837,7968,40720,3133,2,808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',790.00,NULL,NULL,1,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(838,7968,40720,3133,2,809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',1260.00,NULL,NULL,1,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(839,7968,40720,3133,2,810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',460.00,NULL,NULL,1,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(840,7968,40720,3133,2,811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',2200.00,NULL,NULL,1,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(841,7968,40720,3133,2,812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',720.00,NULL,NULL,1,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(842,7968,40720,3133,2,813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',780.00,NULL,NULL,1,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(843,7968,40720,3133,2,814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',940.00,NULL,NULL,1,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(844,7968,40720,3133,2,815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',1070.00,NULL,NULL,1,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(845,7968,40720,3133,2,816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',770.00,NULL,NULL,1,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(846,7968,40720,3133,2,817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',260.00,NULL,NULL,1,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(847,7968,40720,3133,2,818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',540.00,NULL,NULL,1,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(848,7968,40720,3133,2,819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',560.00,NULL,NULL,1,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(849,7968,40720,3133,2,820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',1580.00,NULL,NULL,1,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(850,7968,40720,3133,2,821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',1080.00,NULL,NULL,1,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(851,7968,40720,3133,2,822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',1310.00,NULL,NULL,1,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(852,7968,40720,3133,2,823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',4330.00,NULL,NULL,1,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(853,7968,40720,3133,2,824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',1300.00,NULL,NULL,1,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(854,7968,40720,3133,2,825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',1280.00,NULL,NULL,1,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(855,7968,40720,3133,2,826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',2080.00,NULL,NULL,1,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(856,7968,40720,3133,2,827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',1840.00,NULL,NULL,1,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(857,7968,40720,3133,2,828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',560.00,NULL,NULL,1,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(858,7968,40720,3133,2,829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',1060.00,NULL,NULL,1,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(859,7968,40720,3133,2,830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',510.00,NULL,NULL,1,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(860,7968,40720,3133,2,831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',2400.00,NULL,NULL,1,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL);
INSERT INTO `balance_libro` VALUES (861,7968,40720,3133,2,832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',1580.00,NULL,NULL,1,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(862,7968,40720,3133,2,833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',980.00,NULL,NULL,1,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(863,7968,40720,3133,2,834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',1580.00,NULL,NULL,1,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(864,7968,40720,3133,2,835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',3300.00,NULL,NULL,1,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(865,7968,40720,3133,2,836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',1960.00,NULL,NULL,1,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(866,7968,40720,3133,2,837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',1410.00,NULL,NULL,1,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(867,7968,40720,3133,2,838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',540.00,NULL,NULL,1,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(868,7968,40720,3133,2,839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',720.00,NULL,NULL,1,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(869,7968,40720,3133,2,840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',1490.00,NULL,NULL,1,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(870,7968,40720,3133,2,841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',2130.00,NULL,NULL,1,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(871,7968,40720,3133,2,842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',2130.00,NULL,NULL,1,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(872,7968,40720,3133,2,843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',530.00,NULL,NULL,1,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(873,7968,40720,3133,2,844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',1740.00,NULL,NULL,1,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(874,7968,40720,3133,2,845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',1350.00,NULL,NULL,1,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(875,7968,40720,3133,2,846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',1960.00,NULL,NULL,1,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(876,7968,40720,3133,2,847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',3380.00,NULL,NULL,1,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(877,7968,40720,3133,2,848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',510.00,NULL,NULL,1,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(878,7968,40720,3133,2,849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',1960.00,NULL,NULL,1,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(879,7968,40720,3133,2,850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',980.00,NULL,NULL,1,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(880,7968,40720,3133,2,851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',1960.00,NULL,NULL,1,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(881,7968,40720,3133,2,852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',3920.00,NULL,NULL,1,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(882,7968,40720,3133,2,853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',5200.00,NULL,NULL,1,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(883,7968,40720,3133,2,854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',3070.00,NULL,NULL,1,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(884,7968,40720,3133,2,855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',1380.00,NULL,NULL,1,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(885,7968,40720,3133,2,856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',1180.00,NULL,NULL,1,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL);
INSERT INTO `balance_libro` VALUES (886,7968,40720,3133,2,857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',980.00,NULL,NULL,1,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(887,7968,40720,3133,2,858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',360.00,NULL,NULL,1,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(888,7968,40720,3133,2,859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',1290.00,NULL,NULL,1,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(889,7968,40720,3133,2,860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',2300.00,NULL,NULL,1,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(890,7968,40720,3133,2,861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',1410.00,NULL,NULL,1,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(891,7968,40720,3133,2,862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',1890.00,NULL,NULL,1,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(892,7968,40720,3133,2,863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',1480.00,NULL,NULL,1,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(893,7968,40720,3133,2,864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',1550.00,NULL,NULL,1,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(894,7968,40720,3133,2,865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',1960.00,NULL,NULL,1,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(895,7968,40720,3133,2,866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',4830.00,NULL,NULL,1,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(896,7968,40720,3133,2,867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',1100.00,NULL,NULL,1,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(897,7968,40720,3133,2,868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',1580.00,NULL,NULL,1,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(898,7968,40720,3133,2,869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',3190.00,NULL,NULL,1,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(899,7968,40720,3133,2,870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',3440.00,NULL,NULL,1,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(900,7968,40720,3133,2,871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',1080.00,NULL,NULL,1,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(901,7968,40720,3133,2,872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',1260.00,NULL,NULL,1,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(902,7968,40720,3133,2,873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',420.00,NULL,NULL,1,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(903,7968,40720,3133,2,874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',1050.00,NULL,NULL,1,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(904,7968,40720,3133,2,875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',720.00,NULL,NULL,1,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(905,7968,40720,3133,2,876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',1580.00,NULL,NULL,1,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(906,7968,40720,3133,2,877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',790.00,NULL,NULL,1,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(907,7968,40720,3133,2,878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',980.00,NULL,NULL,1,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(908,7968,40720,3133,2,879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',980.00,NULL,NULL,1,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(909,7968,40720,3133,2,880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',1100.00,NULL,NULL,1,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(910,7968,40720,3133,2,881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',980.00,NULL,NULL,1,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL);
INSERT INTO `balance_libro` VALUES (911,7968,40720,3133,2,882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',1990.00,NULL,NULL,1,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(912,7968,40720,3133,2,883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',1840.00,NULL,NULL,1,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(913,7968,40720,3133,2,884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',890.00,NULL,NULL,1,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(914,7968,40720,3133,2,885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',1170.00,NULL,NULL,1,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(915,7968,40720,3133,2,886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',1080.00,NULL,NULL,1,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(916,7968,40720,3133,2,887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',560.00,NULL,NULL,1,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(917,7968,40720,3133,2,888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',1190.00,NULL,NULL,1,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(918,7968,40720,3133,2,889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',3570.00,NULL,NULL,1,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(919,7968,40720,3133,2,890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',1580.00,NULL,NULL,1,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(920,7968,40720,3133,2,891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',1400.00,NULL,NULL,1,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(921,7968,40720,3133,2,892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',2130.00,NULL,NULL,1,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(922,7968,40720,3133,2,893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',790.00,NULL,NULL,1,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(923,7968,40720,3133,2,894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',2330.00,NULL,NULL,1,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(924,7968,40720,3133,2,895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',790.00,NULL,NULL,1,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(925,7968,40720,3133,2,896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',2370.00,NULL,NULL,1,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(926,7968,40720,3133,2,897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',470.00,NULL,NULL,1,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(927,7968,40720,3133,2,898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',540.00,NULL,NULL,1,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(928,7968,40720,3133,2,899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',560.00,NULL,NULL,1,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(929,7968,40720,3133,2,900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',1880.00,NULL,NULL,1,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(930,7968,40720,3133,2,901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',2400.00,NULL,NULL,1,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(931,7968,40720,3133,2,902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',970.00,NULL,NULL,1,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(932,7968,40720,3133,2,903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',1580.00,NULL,NULL,1,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(933,7968,40720,3133,2,904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',2160.00,NULL,NULL,1,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(934,7968,40720,3133,2,905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',790.00,NULL,NULL,1,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(935,7968,40720,3133,2,906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',870.00,NULL,NULL,1,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL);
INSERT INTO `balance_libro` VALUES (936,7968,40720,3133,2,907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',3180.00,NULL,NULL,1,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(937,7968,40720,3133,2,908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',280.00,NULL,NULL,1,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(938,7968,40720,3133,2,909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',2010.00,NULL,NULL,1,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(939,7968,40720,3133,2,910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',1890.00,NULL,NULL,1,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(940,7968,40720,3133,2,911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',980.00,NULL,NULL,1,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(941,7968,40720,3133,2,912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',1060.00,NULL,NULL,1,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(942,7968,40720,3133,2,913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',1020.00,NULL,NULL,1,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(943,7968,40720,3133,2,914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',280.00,NULL,NULL,1,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(944,7968,40720,3133,2,915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-13','2022-08-13',890.00,NULL,NULL,1,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(945,7968,40720,3133,2,916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-13','2022-08-13',1820.00,NULL,NULL,1,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(946,7968,40720,3133,2,917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-13','2022-08-13',1840.00,NULL,NULL,1,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(947,7968,40720,3133,2,918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-13','2022-08-13',2500.00,NULL,NULL,1,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(948,7968,40720,3133,2,919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-13','2022-08-13',1240.00,NULL,NULL,1,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(949,7968,40720,3133,2,920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-13','2022-08-13',1300.00,NULL,NULL,1,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(950,7968,40720,3133,2,921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-13','2022-08-13',3750.00,NULL,NULL,1,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(951,7968,40720,3133,2,922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-13','2022-08-13',2810.00,NULL,NULL,1,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(952,7968,40720,3133,2,923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-13','2022-08-13',1040.00,NULL,NULL,1,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(953,7968,40720,3133,2,924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-13','2022-08-13',1350.00,NULL,NULL,1,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(954,7968,40720,3133,2,925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-13','2022-08-13',970.00,NULL,NULL,1,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(955,7968,40720,3133,2,926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-13','2022-08-13',990.00,NULL,NULL,1,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(956,7968,40720,3133,2,927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',510.00,NULL,NULL,1,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(957,7968,40720,3133,2,928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',510.00,NULL,NULL,1,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(958,7968,40720,3133,2,929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',490.00,NULL,NULL,1,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(959,7968,40720,3133,2,930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',570.00,NULL,NULL,1,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(960,7968,40720,3133,2,931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',2100.00,NULL,NULL,1,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL);
INSERT INTO `balance_libro` VALUES (961,7968,40720,3133,2,932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',2260.00,NULL,NULL,1,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(962,7968,40720,3133,2,933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',1770.00,NULL,NULL,1,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(963,7968,40720,3133,2,934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',1440.00,NULL,NULL,1,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(964,7968,40720,3133,2,935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',2980.00,NULL,NULL,1,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(965,7968,40720,3133,2,936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',1460.00,NULL,NULL,1,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(966,7968,40720,3133,2,937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',1390.00,NULL,NULL,1,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(967,7968,40720,3133,2,938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',360.00,NULL,NULL,1,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(968,7968,40720,3133,2,939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',790.00,NULL,NULL,1,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(969,7968,40720,3133,2,940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',1230.00,NULL,NULL,1,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(970,7968,40720,3133,2,941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',970.00,NULL,NULL,1,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(971,7968,40720,3133,2,942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',1580.00,NULL,NULL,1,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(972,7968,40720,3133,2,943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',640.00,NULL,NULL,1,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(973,7968,40720,3133,2,944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',790.00,NULL,NULL,1,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(974,7968,40720,3133,2,945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',490.00,NULL,NULL,1,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(975,7968,40720,3133,2,946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',360.00,NULL,NULL,1,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(976,7968,40720,3133,2,947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',1120.00,NULL,NULL,1,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(977,7968,40720,3133,2,948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',780.00,NULL,NULL,1,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(978,7968,40720,3133,2,949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',840.00,NULL,NULL,1,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(979,7968,40720,3133,2,950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',1060.00,NULL,NULL,1,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(980,7968,40720,3133,2,951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',560.00,NULL,NULL,1,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(981,7968,40720,3133,2,952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',460.00,NULL,NULL,1,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(982,7968,40720,3133,2,953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',1580.00,NULL,NULL,1,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(983,7968,40720,3133,2,954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',1160.00,NULL,NULL,1,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(984,7968,40720,3133,2,955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',850.00,NULL,NULL,1,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(985,7968,40720,3133,2,956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',720.00,NULL,NULL,1,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL);
INSERT INTO `balance_libro` VALUES (986,7968,40720,3133,2,957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',1500.00,NULL,NULL,1,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(987,7968,40720,3133,2,958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',1220.00,NULL,NULL,1,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(988,7968,40720,3133,2,959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',2990.00,NULL,NULL,1,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(989,7968,40720,3133,2,960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',1300.00,NULL,NULL,1,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(990,7968,40720,3133,2,961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',1940.00,NULL,NULL,1,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(991,7968,40720,3133,2,962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',980.00,NULL,NULL,1,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(992,7968,40720,3133,2,963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',3230.00,NULL,NULL,1,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(993,7968,40720,3133,2,964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',2380.00,NULL,NULL,1,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(994,7968,40720,3133,2,965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',2560.00,NULL,NULL,1,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(995,7968,40720,3133,2,966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',470.00,NULL,NULL,1,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(996,7968,40720,3133,2,967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',800.00,NULL,NULL,1,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(997,7968,40720,3133,2,968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',1840.00,NULL,NULL,1,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(998,7968,40720,3133,2,969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',2000.00,NULL,NULL,1,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(999,7968,40720,3133,2,970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',2340.00,NULL,NULL,1,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1000,7968,40720,3133,2,971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',1960.00,NULL,NULL,1,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1001,7968,40720,3133,2,972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',1300.00,NULL,NULL,1,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1002,7968,40720,3133,2,973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',3100.00,NULL,NULL,1,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1003,7968,40720,3133,2,974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',1890.00,NULL,NULL,1,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1004,7968,40720,3133,2,975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',2780.00,NULL,NULL,1,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1005,7968,40720,3133,2,976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',3930.00,NULL,NULL,1,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1006,7968,40720,3133,2,977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',1440.00,NULL,NULL,1,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1007,7968,40720,3133,2,978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',1710.00,NULL,NULL,1,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1008,7968,40720,3133,2,979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',960.00,NULL,NULL,1,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1009,7968,40720,3133,2,980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',2410.00,NULL,NULL,1,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1010,7968,40720,3133,2,981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',1500.00,NULL,NULL,1,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL);
INSERT INTO `balance_libro` VALUES (1011,7968,40720,3133,2,982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',1160.00,NULL,NULL,1,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1012,7968,40720,3133,2,983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',1130.00,NULL,NULL,1,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1013,7968,40720,3133,2,984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',1690.00,NULL,NULL,1,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1014,7968,40720,3133,2,985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',790.00,NULL,NULL,1,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1015,7968,40720,3133,2,986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',3160.00,NULL,NULL,1,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1016,7968,40720,3133,2,987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',1960.00,NULL,NULL,1,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1017,7968,40720,3133,2,988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',790.00,NULL,NULL,1,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1018,7968,40720,3133,2,989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',1800.00,NULL,NULL,1,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1019,7968,40720,3133,2,990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',1100.00,NULL,NULL,1,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1020,7968,40720,3133,2,991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',1100.00,NULL,NULL,1,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1021,7968,40720,3133,2,992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',1280.00,NULL,NULL,1,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1022,7968,40720,3133,2,993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',790.00,NULL,NULL,1,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1023,7968,40720,3133,2,994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',1520.00,NULL,NULL,1,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1024,7968,40720,3133,2,995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',1580.00,NULL,NULL,1,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1025,7968,40720,3133,2,996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',1100.00,NULL,NULL,1,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1026,7968,40720,3133,2,997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',1300.00,NULL,NULL,1,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1027,7968,40720,3133,2,998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',300.00,NULL,NULL,1,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1028,7968,40720,3133,2,999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',1010.00,NULL,NULL,1,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1029,7968,40720,3133,2,1000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',1000.00,NULL,NULL,1,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1030,7968,40720,3133,2,1001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',510.00,NULL,NULL,1,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1031,7968,40720,3133,2,1002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',260.00,NULL,NULL,1,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1032,7968,40720,3133,2,1003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',280.00,NULL,NULL,1,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1033,7968,40720,3133,2,1004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',2000.00,NULL,NULL,1,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1034,7968,40720,3133,2,1005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',950.00,NULL,NULL,1,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1035,7968,40720,3133,2,1006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',1840.00,NULL,NULL,1,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL);
INSERT INTO `balance_libro` VALUES (1036,7968,40720,3133,2,1007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',3040.00,NULL,NULL,1,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1037,7968,40720,3133,2,1008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',2330.00,NULL,NULL,1,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1038,7968,40720,3133,2,1009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',3430.00,NULL,NULL,1,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1039,7968,40720,3133,2,1010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',2450.00,NULL,NULL,1,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1040,7968,40720,3133,2,1011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',700.00,NULL,NULL,1,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1041,7968,40720,3133,2,1012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',570.00,NULL,NULL,1,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1042,7968,40720,3133,2,1013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',790.00,NULL,NULL,1,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1043,7968,40720,3133,2,1014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',620.00,NULL,NULL,1,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1044,7968,40720,3133,2,1015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',1460.00,NULL,NULL,1,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1045,7968,40720,3133,2,1016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',3890.00,NULL,NULL,1,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1046,7968,40720,3133,2,1017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',790.00,NULL,NULL,1,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1047,7968,40720,3133,2,1018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',980.00,NULL,NULL,1,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1048,7968,40720,3133,2,1019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',950.00,NULL,NULL,1,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1049,7968,40720,3133,2,1020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',810.00,NULL,NULL,1,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1050,7968,40720,3133,2,1021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',1720.00,NULL,NULL,1,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1051,7968,40720,3133,2,1022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',650.00,NULL,NULL,1,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1052,7968,40720,3133,2,1023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',560.00,NULL,NULL,1,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1053,7968,40720,3133,2,1024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',2400.00,NULL,NULL,1,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1054,7968,40720,3133,2,1025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',4250.00,NULL,NULL,1,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1055,7968,40720,3133,2,1026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',980.00,NULL,NULL,1,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1056,7968,40720,3133,2,1027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',490.00,NULL,NULL,1,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1057,7968,40720,3133,2,1028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',660.00,NULL,NULL,1,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1058,7968,40720,3133,2,1029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',790.00,NULL,NULL,1,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1059,7968,40720,3133,2,1030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',1940.00,NULL,NULL,1,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL);
INSERT INTO `balance_libro` VALUES (1060,7968,40720,3133,2,1031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',1100.00,NULL,NULL,1,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1061,7968,40720,3133,2,1032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',1960.00,NULL,NULL,1,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1062,7968,40720,3133,2,1033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',2900.00,NULL,NULL,1,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1063,7968,40720,3133,2,1034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',460.00,NULL,NULL,1,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1064,7968,40720,3133,2,1035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',980.00,NULL,NULL,1,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1065,7968,40720,3133,2,1036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',980.00,NULL,NULL,1,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1066,7968,40720,3133,2,1037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',3230.00,NULL,NULL,1,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1067,7968,40720,3133,2,1038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',1110.00,NULL,NULL,1,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1068,7968,40720,3133,2,1039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',1040.00,NULL,NULL,1,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1069,7968,40720,3133,2,1040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-27','2022-08-27',1550.00,NULL,NULL,1,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1070,7968,40720,3133,2,1041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',470.00,NULL,NULL,1,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1071,7968,40720,3133,2,1042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',1520.00,NULL,NULL,1,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(1072,7968,40720,3133,2,1043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',790.00,NULL,NULL,1,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(1073,7968,40720,3133,2,1044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',1230.00,NULL,NULL,1,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(1074,7968,40720,3133,2,1045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',1630.00,NULL,NULL,1,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(1075,7968,40720,3133,2,1046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',2720.00,NULL,NULL,1,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(1076,7968,40720,3133,2,1047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',3340.00,NULL,NULL,1,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(1077,7968,40720,3133,2,1048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',2990.00,NULL,NULL,1,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(1078,7968,40720,3133,2,1049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',1580.00,NULL,NULL,1,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(1079,7968,40720,3133,2,1050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',1490.00,NULL,NULL,1,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(1080,7968,40720,3133,2,1051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',1180.00,NULL,NULL,1,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(1081,7968,40720,3133,2,1052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',980.00,NULL,NULL,1,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(1082,7968,40720,3133,2,1053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',790.00,NULL,NULL,1,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(1083,7968,40720,3133,2,1054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',2200.00,NULL,NULL,1,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL);
INSERT INTO `balance_libro` VALUES (1084,7968,40720,3133,2,1055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',1990.00,NULL,NULL,1,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(1085,7968,40720,3133,2,1056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',1960.00,NULL,NULL,1,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(1086,7968,40720,3133,2,1057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',540.00,NULL,NULL,1,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(1087,7968,40720,3133,2,1058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',1490.00,NULL,NULL,1,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(1088,7968,40720,3133,2,1059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',1980.00,NULL,NULL,1,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(1089,7968,40720,3133,2,1060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',600.00,NULL,NULL,1,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(1090,7968,40720,3133,2,1061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',720.00,NULL,NULL,1,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(1091,7968,40720,3133,2,1062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',980.00,NULL,NULL,1,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(1092,7968,40720,3133,2,1063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1580.00,NULL,NULL,1,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(1093,7968,40720,3133,2,1064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',2080.00,NULL,NULL,1,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(1094,7968,40720,3133,2,1065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',940.00,NULL,NULL,1,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(1095,7968,40720,3133,2,1066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1280.00,NULL,NULL,1,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(1096,7968,40720,3133,2,1067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',510.00,NULL,NULL,1,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(1097,7968,40720,3133,2,1068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1350.00,NULL,NULL,1,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(1098,7968,40720,3133,2,1069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',750.00,NULL,NULL,1,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(1099,7968,40720,3133,2,1070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',830.00,NULL,NULL,1,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL);
/*!40000 ALTER TABLE `balance_libro` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro_details`
--

DROP TABLE IF EXISTS `balance_libro_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `balance_libro_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_details_person_id_foreign` (`person_id`),
  KEY `balance_libro_details_period_id_foreign` (`period_id`),
  KEY `balance_libro_details_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_details_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_libro_details_saldo_id_foreign` (`saldo_id`),
  KEY `balance_libro_details_balance_libro_id_foreign` (`balance_libro_id`),
  CONSTRAINT `balance_libro_details_balance_libro_id_foreign` FOREIGN KEY (`balance_libro_id`) REFERENCES `balance_libro` (`id`) ON DELETE CASCADE,
  CONSTRAINT `balance_libro_details_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_details_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `balance_libro_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3377 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro_details`
--

LOCK TABLES `balance_libro_details` WRITE;
/*!40000 ALTER TABLE `balance_libro_details` DISABLE KEYS */;
INSERT INTO `balance_libro_details` VALUES (1,7968,1,40720,3134,3,217,1,10538.32,NULL,'2022-10-22 15:54:00','2022-10-25 15:49:43','2022-10-25 15:49:43'),(2,7968,1,40720,3134,3,68,1,2213.05,NULL,'2022-10-22 15:54:00','2022-10-25 15:49:43','2022-10-25 15:49:43'),(3,7968,1,40720,3134,3,57,2,12751.37,NULL,'2022-10-22 15:54:00','2022-10-25 15:49:43','2022-10-25 15:49:43'),(4,7968,2,40720,3134,3,217,1,9634.07,NULL,'2022-10-22 15:54:00','2022-10-25 15:49:43','2022-10-25 15:49:43'),(5,7968,2,40720,3134,3,68,1,2023.16,NULL,'2022-10-22 15:54:00','2022-10-25 15:49:43','2022-10-25 15:49:43'),(6,7968,2,40720,3134,3,217,1,2046.93,NULL,'2022-10-22 15:54:00','2022-10-25 15:49:43','2022-10-25 15:49:43'),(7,7968,2,40720,3134,3,57,2,13704.16,NULL,'2022-10-22 15:54:00','2022-10-25 15:49:43','2022-10-25 15:49:43'),(8,7968,3,40720,3134,3,217,1,11869.96,NULL,'2022-10-22 15:54:00','2022-10-25 15:49:43','2022-10-25 15:49:43'),(9,7968,3,40720,3134,3,68,1,2492.69,NULL,'2022-10-22 15:54:00','2022-10-25 15:49:43','2022-10-25 15:49:43'),(10,7968,3,40720,3134,3,57,2,14362.65,NULL,'2022-10-22 15:54:00','2022-10-25 15:49:43','2022-10-25 15:49:43'),(11,7968,4,40720,3134,3,217,1,1127.50,NULL,'2022-10-22 15:54:00','2022-10-25 15:49:43','2022-10-25 15:49:43'),(12,7968,4,40720,3134,3,68,1,236.78,NULL,'2022-10-22 15:54:00','2022-10-25 15:49:43','2022-10-25 15:49:43'),(13,7968,4,40720,3134,3,217,1,33.83,NULL,'2022-10-22 15:54:00','2022-10-25 15:49:43','2022-10-25 15:49:43'),(14,7968,4,40720,3134,3,57,2,1398.11,NULL,'2022-10-22 15:54:00','2022-10-25 15:49:43','2022-10-25 15:49:43'),(15,7968,5,40720,3134,3,217,1,138.19,NULL,'2022-10-22 15:54:00','2022-10-25 15:49:43','2022-10-25 15:49:43'),(16,7968,5,40720,3134,3,68,1,29.02,NULL,'2022-10-22 15:54:00','2022-10-25 15:49:43','2022-10-25 15:49:43'),(17,7968,5,40720,3134,3,57,2,167.21,NULL,'2022-10-22 15:54:00','2022-10-25 15:49:43','2022-10-25 15:49:43'),(18,7968,6,40720,3134,3,217,1,8080.27,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(19,7968,6,40720,3134,3,68,1,1696.86,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(20,7968,6,40720,3134,3,217,1,242.41,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(21,7968,6,40720,3134,3,57,2,10019.54,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(22,7968,7,40720,3134,3,217,1,810.05,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(23,7968,7,40720,3134,3,68,1,170.11,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(24,7968,7,40720,3134,3,57,2,980.16,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(25,7968,8,40720,3134,3,217,1,9076.04,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(26,7968,8,40720,3134,3,68,1,1905.97,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(27,7968,8,40720,3134,3,57,2,10982.01,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(28,7968,9,40720,3134,3,217,1,8181.81,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(29,7968,9,40720,3134,3,68,1,1718.18,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(30,7968,9,40720,3134,3,57,2,9899.99,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(31,7968,10,40720,3134,3,217,1,96000.00,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(32,7968,10,40720,3134,3,68,1,20160.00,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(33,7968,10,40720,3134,3,57,2,116160.00,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(34,7968,11,40720,3134,3,57,1,-116160.00,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(35,7968,11,40720,3134,3,136,2,116160.00,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(36,7968,12,40720,3134,3,217,1,96000.00,NULL,'2022-10-22 15:54:01','2022-10-25 15:46:59','2022-10-25 15:46:59');
INSERT INTO `balance_libro_details` VALUES (37,7968,12,40720,3134,3,68,1,20160.00,NULL,'2022-10-22 15:54:01','2022-10-25 15:46:59','2022-10-25 15:46:59'),(38,7968,12,40720,3134,3,57,2,116160.00,NULL,'2022-10-22 15:54:01','2022-10-25 15:46:59','2022-10-25 15:46:59'),(39,7968,13,40720,3134,3,217,1,96000.00,NULL,'2022-10-22 15:54:01','2022-10-25 15:46:34','2022-10-25 15:46:34'),(40,7968,13,40720,3134,3,68,1,20160.00,NULL,'2022-10-22 15:54:01','2022-10-25 15:46:34','2022-10-25 15:46:34'),(41,7968,13,40720,3134,3,57,2,116160.00,NULL,'2022-10-22 15:54:01','2022-10-25 15:46:34','2022-10-25 15:46:34'),(42,7968,14,40720,3134,3,217,1,3498.69,NULL,'2022-10-22 15:54:01','2022-10-25 15:43:23','2022-10-25 15:43:23'),(43,7968,14,40720,3134,3,68,1,734.72,NULL,'2022-10-22 15:54:01','2022-10-25 15:43:23','2022-10-25 15:43:23'),(44,7968,14,40720,3134,3,217,1,209.92,NULL,'2022-10-22 15:54:01','2022-10-25 15:43:23','2022-10-25 15:43:23'),(45,7968,14,40720,3134,3,57,2,4443.33,NULL,'2022-10-22 15:54:01','2022-10-25 15:43:23','2022-10-25 15:43:23'),(46,7968,15,40720,3134,3,217,1,2842.32,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(47,7968,15,40720,3134,3,68,1,596.89,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(48,7968,15,40720,3134,3,57,2,3439.21,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(49,7968,16,40720,3134,3,217,1,1460.00,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(50,7968,16,40720,3134,3,68,1,306.60,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(51,7968,16,40720,3134,3,217,1,43.80,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(52,7968,16,40720,3134,3,57,2,1810.40,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(53,7968,17,40720,3134,3,217,1,129.91,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(54,7968,17,40720,3134,3,68,1,27.28,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(55,7968,17,40720,3134,3,57,2,157.19,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(56,7968,18,40720,3134,3,217,1,12726.36,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(57,7968,18,40720,3134,3,68,1,2517.67,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(58,7968,18,40720,3134,3,57,2,15244.03,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(59,7968,19,40720,3134,3,217,1,6723.47,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(60,7968,19,40720,3134,3,68,1,1411.93,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(61,7968,19,40720,3134,3,57,2,8135.40,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(62,7968,20,40720,3134,3,217,1,8047.88,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(63,7968,20,40720,3134,3,68,1,1690.05,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(64,7968,20,40720,3134,3,57,2,9737.93,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(65,7968,21,40720,3134,3,217,1,940.00,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(66,7968,21,40720,3134,3,68,1,197.40,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(67,7968,21,40720,3134,3,217,1,28.20,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(68,7968,21,40720,3134,3,57,2,1165.60,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(69,7968,22,40720,3134,3,250,1,0.00,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(70,7968,22,40720,3134,3,57,2,0.00,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(71,7968,23,40720,3134,3,217,1,97.46,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(72,7968,23,40720,3134,3,68,1,20.47,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43');
INSERT INTO `balance_libro_details` VALUES (73,7968,23,40720,3134,3,57,2,117.93,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(74,7968,24,40720,3134,3,217,1,5456.12,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(75,7968,24,40720,3134,3,68,1,1145.79,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(76,7968,24,40720,3134,3,217,1,1116.26,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(77,7968,24,40720,3134,3,57,2,7718.17,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(78,7968,25,40720,3134,3,217,1,6530.59,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(79,7968,25,40720,3134,3,68,1,1371.42,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(80,7968,25,40720,3134,3,57,2,7902.01,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(81,7968,26,40720,3134,3,217,1,11869.96,NULL,'2022-10-22 15:54:01','2022-10-25 15:44:09','2022-10-25 15:44:09'),(82,7968,26,40720,3134,3,68,1,2492.69,NULL,'2022-10-22 15:54:01','2022-10-25 15:44:09','2022-10-25 15:44:09'),(83,7968,26,40720,3134,3,57,2,14362.65,NULL,'2022-10-22 15:54:01','2022-10-25 15:44:09','2022-10-25 15:44:09'),(84,7968,27,40720,3134,3,217,1,3105.00,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(85,7968,27,40720,3134,3,68,1,652.05,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(86,7968,27,40720,3134,3,217,1,93.15,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(87,7968,27,40720,3134,3,57,2,3850.20,NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(88,7968,28,40720,3134,3,217,1,344.40,NULL,'2022-10-22 15:54:01','2022-10-25 15:41:15','2022-10-25 15:41:15'),(89,7968,28,40720,3134,3,68,1,72.32,NULL,'2022-10-22 15:54:01','2022-10-25 15:41:15','2022-10-25 15:41:15'),(90,7968,28,40720,3134,3,57,2,416.72,NULL,'2022-10-22 15:54:01','2022-10-25 15:41:15','2022-10-25 15:41:15'),(91,7968,29,40720,3134,3,217,1,6160.34,NULL,'2022-10-22 15:54:02','2022-10-24 17:07:57','2022-10-24 17:07:57'),(92,7968,29,40720,3134,3,68,1,1293.67,NULL,'2022-10-22 15:54:02','2022-10-24 17:07:57','2022-10-24 17:07:57'),(93,7968,29,40720,3134,3,57,2,7454.01,NULL,'2022-10-22 15:54:02','2022-10-24 17:07:57','2022-10-24 17:07:57'),(94,7968,30,40720,3134,3,217,1,6551.71,NULL,'2022-10-22 15:54:02','2022-10-24 17:07:07','2022-10-24 17:07:07'),(95,7968,30,40720,3134,3,68,1,1375.85,NULL,'2022-10-22 15:54:02','2022-10-24 17:07:07','2022-10-24 17:07:07'),(96,7968,30,40720,3134,3,217,1,1373.00,NULL,'2022-10-22 15:54:02','2022-10-24 17:07:07','2022-10-24 17:07:07'),(97,7968,30,40720,3134,3,57,2,9300.56,NULL,'2022-10-22 15:54:02','2022-10-24 17:07:07','2022-10-24 17:07:07'),(98,7968,31,40720,3134,3,217,1,9762.35,NULL,'2022-10-22 15:54:02','2022-10-24 17:06:48','2022-10-24 17:06:48'),(99,7968,31,40720,3134,3,68,1,2050.09,NULL,'2022-10-22 15:54:02','2022-10-24 17:06:48','2022-10-24 17:06:48'),(100,7968,31,40720,3134,3,57,2,11812.44,NULL,'2022-10-22 15:54:02','2022-10-24 17:06:48','2022-10-24 17:06:48'),(101,7968,32,40720,3134,3,217,1,9916.52,NULL,'2022-10-22 15:54:02','2022-10-24 17:05:43','2022-10-24 17:05:43'),(102,7968,32,40720,3134,3,68,1,2082.47,NULL,'2022-10-22 15:54:02','2022-10-24 17:05:43','2022-10-24 17:05:43'),(103,7968,32,40720,3134,3,57,2,11998.99,NULL,'2022-10-22 15:54:02','2022-10-24 17:05:43','2022-10-24 17:05:43'),(104,7968,33,40720,3134,3,217,1,6371.46,NULL,'2022-10-22 15:54:02','2022-10-24 17:04:30','2022-10-24 17:04:30'),(105,7968,33,40720,3134,3,68,1,1338.01,NULL,'2022-10-22 15:54:02','2022-10-24 17:04:30','2022-10-24 17:04:30'),(106,7968,33,40720,3134,3,57,2,7709.47,NULL,'2022-10-22 15:54:02','2022-10-24 17:04:30','2022-10-24 17:04:30'),(107,7968,34,40720,3134,3,217,1,6391.38,NULL,'2022-10-22 15:54:02','2022-10-24 15:16:21','2022-10-24 15:16:21'),(108,7968,34,40720,3134,3,68,1,1342.20,NULL,'2022-10-22 15:54:02','2022-10-24 15:16:21','2022-10-24 15:16:21');
INSERT INTO `balance_libro_details` VALUES (109,7968,34,40720,3134,3,217,1,1271.32,NULL,'2022-10-22 15:54:02','2022-10-24 15:16:21','2022-10-24 15:16:21'),(110,7968,34,40720,3134,3,57,2,9004.90,NULL,'2022-10-22 15:54:02','2022-10-24 15:16:21','2022-10-24 15:16:21'),(111,7968,35,40720,3134,3,250,1,0.00,NULL,'2022-10-22 15:54:02','2022-10-24 16:50:22','2022-10-24 16:50:22'),(112,7968,35,40720,3134,3,57,2,0.00,NULL,'2022-10-22 15:54:02','2022-10-24 16:50:22','2022-10-24 16:50:22'),(113,7968,36,40720,3134,3,217,1,10991.75,NULL,'2022-10-22 15:54:02','2022-10-24 15:15:51','2022-10-24 15:15:51'),(114,7968,36,40720,3134,3,68,1,2308.27,NULL,'2022-10-22 15:54:02','2022-10-24 15:15:51','2022-10-24 15:15:51'),(115,7968,36,40720,3134,3,57,2,13300.02,NULL,'2022-10-22 15:54:02','2022-10-24 15:15:51','2022-10-24 15:15:51'),(116,7968,37,40720,3134,3,250,1,25900.00,NULL,'2022-10-22 15:54:02','2022-10-24 15:11:24','2022-10-24 15:11:24'),(117,7968,37,40720,3134,3,57,2,25900.00,NULL,'2022-10-22 15:54:02','2022-10-24 15:11:24','2022-10-24 15:11:24'),(118,7968,38,40720,3134,3,57,1,-500.00,NULL,'2022-10-22 15:54:02','2022-10-24 15:14:55','2022-10-24 15:14:55'),(119,7968,38,40720,3134,3,136,2,500.00,NULL,'2022-10-22 15:54:02','2022-10-24 15:14:55','2022-10-24 15:14:55'),(120,7968,39,40720,3134,3,192,1,25900.00,NULL,'2022-10-24 15:11:24','2022-10-24 16:45:15','2022-10-24 16:45:15'),(121,7968,39,40720,3134,3,57,2,25900.00,NULL,'2022-10-24 15:11:24','2022-10-24 16:45:15','2022-10-24 16:45:15'),(122,7968,40,40720,3134,3,250,2,413.22,NULL,'2022-10-24 15:14:55','2022-10-24 16:37:31','2022-10-24 16:37:31'),(123,7968,40,40720,3134,3,67,2,86.78,NULL,'2022-10-24 15:14:55','2022-10-24 16:37:31','2022-10-24 16:37:31'),(124,7968,40,40720,3134,3,57,1,500.00,NULL,'2022-10-24 15:14:55','2022-10-24 16:37:31','2022-10-24 16:37:31'),(125,7968,41,40720,3134,3,392,1,10991.75,NULL,'2022-10-24 15:15:51','2022-10-24 16:47:54','2022-10-24 16:47:54'),(126,7968,41,40720,3134,3,68,1,2308.27,NULL,'2022-10-24 15:15:51','2022-10-24 16:47:54','2022-10-24 16:47:54'),(127,7968,41,40720,3134,3,57,2,13300.02,NULL,'2022-10-24 15:15:51','2022-10-24 16:47:54','2022-10-24 16:47:54'),(128,7968,42,40720,3134,3,392,1,6391.38,NULL,'2022-10-24 15:16:21','2022-10-24 17:03:26','2022-10-24 17:03:26'),(129,7968,42,40720,3134,3,68,1,1342.19,NULL,'2022-10-24 15:16:21','2022-10-24 17:03:26','2022-10-24 17:03:26'),(130,7968,42,40720,3134,3,392,1,1271.32,NULL,'2022-10-24 15:16:21','2022-10-24 17:03:26','2022-10-24 17:03:26'),(131,7968,42,40720,3134,3,57,2,9004.89,NULL,'2022-10-24 15:16:21','2022-10-24 17:03:26','2022-10-24 17:03:26'),(132,7968,43,40720,3134,3,250,2,413.22,NULL,'2022-10-24 16:37:31','2022-10-24 16:44:21','2022-10-24 16:44:21'),(133,7968,43,40720,3134,3,67,2,86.78,NULL,'2022-10-24 16:37:31','2022-10-24 16:44:21','2022-10-24 16:44:21'),(134,7968,43,40720,3134,3,57,1,500.00,NULL,'2022-10-24 16:37:31','2022-10-24 16:44:21','2022-10-24 16:44:21'),(135,7968,44,40720,3134,3,126,2,413.22,NULL,'2022-10-24 16:44:21','2022-10-24 16:44:29','2022-10-24 16:44:29'),(136,7968,44,40720,3134,3,67,2,86.78,NULL,'2022-10-24 16:44:21','2022-10-24 16:44:29','2022-10-24 16:44:29'),(137,7968,44,40720,3134,3,57,1,500.00,NULL,'2022-10-24 16:44:21','2022-10-24 16:44:29','2022-10-24 16:44:29'),(138,7968,45,40720,3134,3,126,2,413.22,NULL,'2022-10-24 16:44:29','2022-10-25 15:49:43','2022-10-25 15:49:43'),(139,7968,45,40720,3134,3,67,2,86.78,NULL,'2022-10-24 16:44:29','2022-10-25 15:49:43','2022-10-25 15:49:43'),(140,7968,45,40720,3134,3,57,1,500.00,NULL,'2022-10-24 16:44:29','2022-10-25 15:49:43','2022-10-25 15:49:43'),(141,7968,46,40720,3134,3,192,1,25900.00,NULL,'2022-10-24 16:45:15','2022-10-24 16:46:45','2022-10-24 16:46:45'),(142,7968,46,40720,3134,3,57,2,25900.00,NULL,'2022-10-24 16:45:15','2022-10-24 16:46:45','2022-10-24 16:46:45'),(143,7968,47,40720,3134,3,192,1,25900.00,NULL,'2022-10-24 16:46:45','2022-10-25 15:49:43','2022-10-25 15:49:43'),(144,7968,47,40720,3134,3,57,2,25900.00,NULL,'2022-10-24 16:46:45','2022-10-25 15:49:43','2022-10-25 15:49:43');
INSERT INTO `balance_libro_details` VALUES (145,7968,48,40720,3134,3,392,1,10991.75,NULL,'2022-10-24 16:47:54','2022-10-25 15:49:43','2022-10-25 15:49:43'),(146,7968,48,40720,3134,3,68,1,2308.27,NULL,'2022-10-24 16:47:54','2022-10-25 15:49:43','2022-10-25 15:49:43'),(147,7968,48,40720,3134,3,57,2,13300.02,NULL,'2022-10-24 16:47:54','2022-10-25 15:49:43','2022-10-25 15:49:43'),(148,7968,49,40720,3134,3,392,1,0.01,NULL,'2022-10-24 16:50:22','2022-10-25 15:49:43','2022-10-25 15:49:43'),(149,7968,49,40720,3134,3,57,2,0.01,NULL,'2022-10-24 16:50:22','2022-10-25 15:49:43','2022-10-25 15:49:43'),(150,7968,50,40720,3134,3,392,1,6391.38,NULL,'2022-10-24 17:03:26','2022-10-25 15:49:43','2022-10-25 15:49:43'),(151,7968,50,40720,3134,3,68,1,1342.19,NULL,'2022-10-24 17:03:26','2022-10-25 15:49:43','2022-10-25 15:49:43'),(152,7968,50,40720,3134,3,392,1,1271.32,NULL,'2022-10-24 17:03:26','2022-10-25 15:49:43','2022-10-25 15:49:43'),(153,7968,50,40720,3134,3,57,2,9004.89,NULL,'2022-10-24 17:03:26','2022-10-25 15:49:43','2022-10-25 15:49:43'),(154,7968,51,40720,3134,3,482,1,6371.46,NULL,'2022-10-24 17:04:30','2022-10-25 15:49:43','2022-10-25 15:49:43'),(155,7968,51,40720,3134,3,68,1,1338.01,NULL,'2022-10-24 17:04:30','2022-10-25 15:49:43','2022-10-25 15:49:43'),(156,7968,51,40720,3134,3,57,2,7709.47,NULL,'2022-10-24 17:04:30','2022-10-25 15:49:43','2022-10-25 15:49:43'),(157,7968,52,40720,3134,3,482,1,9916.52,NULL,'2022-10-24 17:05:43','2022-10-25 15:49:43','2022-10-25 15:49:43'),(158,7968,52,40720,3134,3,68,1,2082.47,NULL,'2022-10-24 17:05:43','2022-10-25 15:49:43','2022-10-25 15:49:43'),(159,7968,52,40720,3134,3,57,2,11998.99,NULL,'2022-10-24 17:05:43','2022-10-25 15:49:43','2022-10-25 15:49:43'),(160,7968,53,40720,3134,3,392,1,9762.35,NULL,'2022-10-24 17:06:48','2022-10-25 15:49:43','2022-10-25 15:49:43'),(161,7968,53,40720,3134,3,68,1,2050.09,NULL,'2022-10-24 17:06:48','2022-10-25 15:49:43','2022-10-25 15:49:43'),(162,7968,53,40720,3134,3,57,2,11812.44,NULL,'2022-10-24 17:06:48','2022-10-25 15:49:43','2022-10-25 15:49:43'),(163,7968,54,40720,3134,3,392,1,6551.71,NULL,'2022-10-24 17:07:07','2022-10-25 15:49:43','2022-10-25 15:49:43'),(164,7968,54,40720,3134,3,68,1,1375.86,NULL,'2022-10-24 17:07:08','2022-10-25 15:49:43','2022-10-25 15:49:43'),(165,7968,54,40720,3134,3,392,1,1373.00,NULL,'2022-10-24 17:07:08','2022-10-25 15:49:43','2022-10-25 15:49:43'),(166,7968,54,40720,3134,3,57,2,9300.57,NULL,'2022-10-24 17:07:08','2022-10-25 15:49:43','2022-10-25 15:49:43'),(167,7968,55,40720,3134,3,392,1,6160.34,NULL,'2022-10-24 17:07:57','2022-10-25 15:49:43','2022-10-25 15:49:43'),(168,7968,55,40720,3134,3,68,1,1293.67,NULL,'2022-10-24 17:07:57','2022-10-25 15:49:43','2022-10-25 15:49:43'),(169,7968,55,40720,3134,3,57,2,7454.01,NULL,'2022-10-24 17:07:57','2022-10-25 15:49:43','2022-10-25 15:49:43'),(170,7968,56,40720,3134,3,396,1,344.40,NULL,'2022-10-25 15:41:15','2022-10-25 15:42:00','2022-10-25 15:42:00'),(171,7968,56,40720,3134,3,68,1,72.32,NULL,'2022-10-25 15:41:15','2022-10-25 15:42:00','2022-10-25 15:42:00'),(172,7968,56,40720,3134,3,57,2,416.72,NULL,'2022-10-25 15:41:15','2022-10-25 15:42:00','2022-10-25 15:42:00'),(173,7968,57,40720,3134,3,396,1,344.40,NULL,'2022-10-25 15:42:00','2022-10-25 15:49:43','2022-10-25 15:49:43'),(174,7968,57,40720,3134,3,68,1,72.32,NULL,'2022-10-25 15:42:00','2022-10-25 15:49:43','2022-10-25 15:49:43'),(175,7968,57,40720,3134,3,57,2,416.72,NULL,'2022-10-25 15:42:00','2022-10-25 15:49:43','2022-10-25 15:49:43'),(176,7968,58,40720,3134,3,396,1,3498.69,NULL,'2022-10-25 15:43:23','2022-10-25 15:44:39','2022-10-25 15:44:39'),(177,7968,58,40720,3134,3,68,1,734.72,NULL,'2022-10-25 15:43:23','2022-10-25 15:44:39','2022-10-25 15:44:39'),(178,7968,58,40720,3134,3,396,1,209.92,NULL,'2022-10-25 15:43:23','2022-10-25 15:44:39','2022-10-25 15:44:39'),(179,7968,58,40720,3134,3,57,2,4443.33,NULL,'2022-10-25 15:43:23','2022-10-25 15:44:39','2022-10-25 15:44:39'),(180,7968,59,40720,3134,3,392,1,11869.96,NULL,'2022-10-25 15:44:09','2022-10-25 15:49:43','2022-10-25 15:49:43');
INSERT INTO `balance_libro_details` VALUES (181,7968,59,40720,3134,3,68,1,2492.69,NULL,'2022-10-25 15:44:09','2022-10-25 15:49:43','2022-10-25 15:49:43'),(182,7968,59,40720,3134,3,57,2,14362.65,NULL,'2022-10-25 15:44:09','2022-10-25 15:49:43','2022-10-25 15:49:43'),(183,7968,60,40720,3134,3,396,1,3498.69,NULL,'2022-10-25 15:44:39','2022-10-25 15:49:43','2022-10-25 15:49:43'),(184,7968,60,40720,3134,3,68,1,734.72,NULL,'2022-10-25 15:44:39','2022-10-25 15:49:43','2022-10-25 15:49:43'),(185,7968,60,40720,3134,3,396,1,209.92,NULL,'2022-10-25 15:44:39','2022-10-25 15:49:43','2022-10-25 15:49:43'),(186,7968,60,40720,3134,3,57,2,4443.33,NULL,'2022-10-25 15:44:39','2022-10-25 15:49:43','2022-10-25 15:49:43'),(187,7968,61,40720,3134,3,116,1,96000.00,NULL,'2022-10-25 15:46:34','2022-10-25 15:49:43','2022-10-25 15:49:43'),(188,7968,61,40720,3134,3,68,1,20160.00,NULL,'2022-10-25 15:46:34','2022-10-25 15:49:43','2022-10-25 15:49:43'),(189,7968,61,40720,3134,3,57,2,116160.00,NULL,'2022-10-25 15:46:34','2022-10-25 15:49:43','2022-10-25 15:49:43'),(190,7968,62,40720,3134,3,116,1,96000.00,NULL,'2022-10-25 15:46:59','2022-10-25 15:49:43','2022-10-25 15:49:43'),(191,7968,62,40720,3134,3,68,1,20160.00,NULL,'2022-10-25 15:46:59','2022-10-25 15:49:43','2022-10-25 15:49:43'),(192,7968,62,40720,3134,3,57,2,116160.00,NULL,'2022-10-25 15:46:59','2022-10-25 15:49:43','2022-10-25 15:49:43'),(193,7968,63,40720,3134,3,392,1,10538.32,NULL,'2022-10-25 15:53:23','2022-10-25 17:07:50','2022-10-25 17:07:50'),(194,7968,63,40720,3134,3,68,1,2213.05,NULL,'2022-10-25 15:53:23','2022-10-25 17:07:50','2022-10-25 17:07:50'),(195,7968,63,40720,3134,3,57,2,12751.37,NULL,'2022-10-25 15:53:23','2022-10-25 17:07:50','2022-10-25 17:07:50'),(196,7968,64,40720,3134,3,392,1,9634.07,NULL,'2022-10-25 15:53:23','2022-10-25 17:07:50','2022-10-25 17:07:50'),(197,7968,64,40720,3134,3,68,1,2023.16,NULL,'2022-10-25 15:53:23','2022-10-25 17:07:50','2022-10-25 17:07:50'),(198,7968,64,40720,3134,3,392,1,2046.93,NULL,'2022-10-25 15:53:23','2022-10-25 17:07:50','2022-10-25 17:07:50'),(199,7968,64,40720,3134,3,57,2,13704.16,NULL,'2022-10-25 15:53:23','2022-10-25 17:07:50','2022-10-25 17:07:50'),(200,7968,65,40720,3134,3,392,1,11869.96,NULL,'2022-10-25 15:53:23','2022-10-25 17:07:50','2022-10-25 17:07:50'),(201,7968,65,40720,3134,3,68,1,2492.69,NULL,'2022-10-25 15:53:23','2022-10-25 17:07:50','2022-10-25 17:07:50'),(202,7968,65,40720,3134,3,57,2,14362.65,NULL,'2022-10-25 15:53:23','2022-10-25 17:07:50','2022-10-25 17:07:50'),(203,7968,66,40720,3134,3,126,1,1127.50,NULL,'2022-10-25 15:53:23','2022-10-25 17:07:50','2022-10-25 17:07:50'),(204,7968,66,40720,3134,3,68,1,236.78,NULL,'2022-10-25 15:53:23','2022-10-25 17:07:50','2022-10-25 17:07:50'),(205,7968,66,40720,3134,3,126,1,33.83,NULL,'2022-10-25 15:53:23','2022-10-25 17:07:50','2022-10-25 17:07:50'),(206,7968,66,40720,3134,3,57,2,1398.11,NULL,'2022-10-25 15:53:23','2022-10-25 17:07:50','2022-10-25 17:07:50'),(207,7968,67,40720,3134,3,396,1,138.19,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:50','2022-10-25 17:07:50'),(208,7968,67,40720,3134,3,68,1,29.02,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:50','2022-10-25 17:07:50'),(209,7968,67,40720,3134,3,57,2,167.21,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:50','2022-10-25 17:07:50'),(210,7968,68,40720,3134,3,217,1,8080.27,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:50','2022-10-25 17:07:50'),(211,7968,68,40720,3134,3,68,1,1696.86,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:50','2022-10-25 17:07:50'),(212,7968,68,40720,3134,3,217,1,242.41,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:50','2022-10-25 17:07:50'),(213,7968,68,40720,3134,3,57,2,10019.54,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:50','2022-10-25 17:07:50'),(214,7968,69,40720,3134,3,482,1,810.05,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:50','2022-10-25 17:07:50'),(215,7968,69,40720,3134,3,68,1,170.11,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:50','2022-10-25 17:07:50'),(216,7968,69,40720,3134,3,57,2,980.16,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:50','2022-10-25 17:07:50');
INSERT INTO `balance_libro_details` VALUES (217,7968,70,40720,3134,3,392,1,9076.04,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:50','2022-10-25 17:07:50'),(218,7968,70,40720,3134,3,68,1,1905.97,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:50','2022-10-25 17:07:50'),(219,7968,70,40720,3134,3,57,2,10982.01,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:50','2022-10-25 17:07:50'),(220,7968,71,40720,3134,3,392,1,8181.81,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:50','2022-10-25 17:07:50'),(221,7968,71,40720,3134,3,68,1,1718.18,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:50','2022-10-25 17:07:50'),(222,7968,71,40720,3134,3,57,2,9899.99,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:50','2022-10-25 17:07:50'),(223,7968,72,40720,3134,3,116,1,96000.00,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(224,7968,72,40720,3134,3,68,1,20160.00,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(225,7968,72,40720,3134,3,57,2,116160.00,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(226,7968,73,40720,3134,3,57,1,-116160.00,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(227,7968,73,40720,3134,3,136,2,116160.00,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(228,7968,74,40720,3134,3,116,1,96000.00,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(229,7968,74,40720,3134,3,68,1,20160.00,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(230,7968,74,40720,3134,3,57,2,116160.00,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(231,7968,75,40720,3134,3,116,1,96000.00,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(232,7968,75,40720,3134,3,68,1,20160.00,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(233,7968,75,40720,3134,3,57,2,116160.00,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(234,7968,76,40720,3134,3,396,1,3498.69,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(235,7968,76,40720,3134,3,68,1,734.72,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(236,7968,76,40720,3134,3,396,1,209.92,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(237,7968,76,40720,3134,3,57,2,4443.33,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(238,7968,77,40720,3134,3,392,1,2842.32,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(239,7968,77,40720,3134,3,68,1,596.89,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(240,7968,77,40720,3134,3,57,2,3439.21,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(241,7968,78,40720,3134,3,126,1,1460.00,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(242,7968,78,40720,3134,3,68,1,306.60,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(243,7968,78,40720,3134,3,126,1,43.80,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(244,7968,78,40720,3134,3,57,2,1810.40,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(245,7968,79,40720,3134,3,396,1,129.91,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(246,7968,79,40720,3134,3,68,1,27.28,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(247,7968,79,40720,3134,3,57,2,157.19,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(248,7968,80,40720,3134,3,392,1,12726.36,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(249,7968,80,40720,3134,3,68,1,2517.67,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(250,7968,80,40720,3134,3,57,2,15244.03,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(251,7968,81,40720,3134,3,392,1,6723.47,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51');
INSERT INTO `balance_libro_details` VALUES (252,7968,81,40720,3134,3,68,1,1411.93,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(253,7968,81,40720,3134,3,57,2,8135.40,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(254,7968,82,40720,3134,3,392,1,8047.88,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(255,7968,82,40720,3134,3,68,1,1690.05,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(256,7968,82,40720,3134,3,57,2,9737.93,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(257,7968,83,40720,3134,3,126,1,940.00,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(258,7968,83,40720,3134,3,68,1,197.40,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(259,7968,83,40720,3134,3,126,1,28.20,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(260,7968,83,40720,3134,3,57,2,1165.60,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(261,7968,84,40720,3134,3,392,1,0.00,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(262,7968,84,40720,3134,3,57,2,0.00,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(263,7968,85,40720,3134,3,396,1,97.46,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(264,7968,85,40720,3134,3,68,1,20.47,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(265,7968,85,40720,3134,3,57,2,117.93,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(266,7968,86,40720,3134,3,392,1,5456.12,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(267,7968,86,40720,3134,3,68,1,1145.79,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(268,7968,86,40720,3134,3,392,1,1116.26,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(269,7968,86,40720,3134,3,57,2,7718.17,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(270,7968,87,40720,3134,3,392,1,6530.59,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(271,7968,87,40720,3134,3,68,1,1371.42,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(272,7968,87,40720,3134,3,57,2,7902.01,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(273,7968,88,40720,3134,3,392,1,11869.96,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(274,7968,88,40720,3134,3,68,1,2492.69,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(275,7968,88,40720,3134,3,57,2,14362.65,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(276,7968,89,40720,3134,3,126,1,3105.00,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(277,7968,89,40720,3134,3,68,1,652.05,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(278,7968,89,40720,3134,3,126,1,93.15,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(279,7968,89,40720,3134,3,57,2,3850.20,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(280,7968,90,40720,3134,3,396,1,344.40,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(281,7968,90,40720,3134,3,68,1,72.32,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(282,7968,90,40720,3134,3,57,2,416.72,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(283,7968,91,40720,3134,3,392,1,6160.34,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(284,7968,91,40720,3134,3,68,1,1293.67,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(285,7968,91,40720,3134,3,57,2,7454.01,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(286,7968,92,40720,3134,3,392,1,6551.71,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(287,7968,92,40720,3134,3,68,1,1375.85,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51');
INSERT INTO `balance_libro_details` VALUES (288,7968,92,40720,3134,3,392,1,1373.00,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(289,7968,92,40720,3134,3,57,2,9300.56,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(290,7968,93,40720,3134,3,392,1,9762.35,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(291,7968,93,40720,3134,3,68,1,2050.09,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(292,7968,93,40720,3134,3,57,2,11812.44,NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(293,7968,94,40720,3134,3,482,1,9916.52,NULL,'2022-10-25 15:53:25','2022-10-25 17:07:51','2022-10-25 17:07:51'),(294,7968,94,40720,3134,3,68,1,2082.47,NULL,'2022-10-25 15:53:25','2022-10-25 17:07:51','2022-10-25 17:07:51'),(295,7968,94,40720,3134,3,57,2,11998.99,NULL,'2022-10-25 15:53:25','2022-10-25 17:07:51','2022-10-25 17:07:51'),(296,7968,95,40720,3134,3,482,1,6371.46,NULL,'2022-10-25 15:53:25','2022-10-25 17:07:51','2022-10-25 17:07:51'),(297,7968,95,40720,3134,3,68,1,1338.01,NULL,'2022-10-25 15:53:25','2022-10-25 17:07:51','2022-10-25 17:07:51'),(298,7968,95,40720,3134,3,57,2,7709.47,NULL,'2022-10-25 15:53:25','2022-10-25 17:07:51','2022-10-25 17:07:51'),(299,7968,96,40720,3134,3,392,1,6391.38,NULL,'2022-10-25 15:53:25','2022-10-25 17:07:51','2022-10-25 17:07:51'),(300,7968,96,40720,3134,3,68,1,1342.20,NULL,'2022-10-25 15:53:25','2022-10-25 17:07:51','2022-10-25 17:07:51'),(301,7968,96,40720,3134,3,392,1,1271.32,NULL,'2022-10-25 15:53:25','2022-10-25 17:07:51','2022-10-25 17:07:51'),(302,7968,96,40720,3134,3,57,2,9004.90,NULL,'2022-10-25 15:53:25','2022-10-25 17:07:51','2022-10-25 17:07:51'),(303,7968,97,40720,3134,3,392,1,0.00,NULL,'2022-10-25 15:53:25','2022-10-25 17:07:51','2022-10-25 17:07:51'),(304,7968,97,40720,3134,3,57,2,0.00,NULL,'2022-10-25 15:53:25','2022-10-25 17:07:51','2022-10-25 17:07:51'),(305,7968,98,40720,3134,3,392,1,10991.75,NULL,'2022-10-25 15:53:25','2022-10-25 15:56:03','2022-10-25 15:56:03'),(306,7968,98,40720,3134,3,68,1,2308.27,NULL,'2022-10-25 15:53:25','2022-10-25 15:56:03','2022-10-25 15:56:03'),(307,7968,98,40720,3134,3,57,2,13300.02,NULL,'2022-10-25 15:53:25','2022-10-25 15:56:03','2022-10-25 15:56:03'),(308,7968,99,40720,3134,3,97,1,25900.00,NULL,'2022-10-25 15:53:25','2022-10-25 15:55:56','2022-10-25 15:55:56'),(309,7968,99,40720,3134,3,57,2,25900.00,NULL,'2022-10-25 15:53:25','2022-10-25 15:55:56','2022-10-25 15:55:56'),(310,7968,100,40720,3134,3,57,1,-500.00,NULL,'2022-10-25 15:53:25','2022-10-25 17:07:51','2022-10-25 17:07:51'),(311,7968,100,40720,3134,3,136,2,500.00,NULL,'2022-10-25 15:53:25','2022-10-25 17:07:51','2022-10-25 17:07:51'),(312,7968,101,40720,3134,3,192,1,25900.00,NULL,'2022-10-25 15:55:56','2022-10-25 17:07:51','2022-10-25 17:07:51'),(313,7968,101,40720,3134,3,57,2,25900.00,NULL,'2022-10-25 15:55:56','2022-10-25 17:07:51','2022-10-25 17:07:51'),(314,7968,102,40720,3134,3,392,1,10991.75,NULL,'2022-10-25 15:56:03','2022-10-25 17:07:51','2022-10-25 17:07:51'),(315,7968,102,40720,3134,3,68,1,2308.27,NULL,'2022-10-25 15:56:03','2022-10-25 17:07:51','2022-10-25 17:07:51'),(316,7968,102,40720,3134,3,57,2,13300.02,NULL,'2022-10-25 15:56:03','2022-10-25 17:07:51','2022-10-25 17:07:51'),(317,7968,103,40720,3133,3,226,1,103.95,NULL,'2022-10-25 16:49:26','2022-10-25 16:49:26',NULL),(318,7968,103,40720,3133,3,126,1,3465.00,NULL,'2022-10-25 16:49:26','2022-10-25 16:49:26',NULL),(319,7968,103,40720,3133,3,68,1,727.65,NULL,'2022-10-25 16:49:26','2022-10-25 16:49:26',NULL),(320,7968,103,40720,3133,3,57,2,4296.60,NULL,'2022-10-25 16:49:26','2022-10-25 16:49:26',NULL),(321,7968,104,40720,3133,3,396,1,396.71,NULL,'2022-10-25 16:49:26','2022-10-25 16:49:26',NULL),(322,7968,104,40720,3133,3,68,1,83.31,NULL,'2022-10-25 16:49:26','2022-10-25 16:49:26',NULL),(323,7968,104,40720,3133,3,57,2,480.02,NULL,'2022-10-25 16:49:26','2022-10-25 16:49:26',NULL),(324,7968,105,40720,3133,3,482,1,5249.05,NULL,'2022-10-25 16:49:26','2022-10-25 16:49:26',NULL);
INSERT INTO `balance_libro_details` VALUES (325,7968,105,40720,3133,3,68,1,1102.30,NULL,'2022-10-25 16:49:26','2022-10-25 16:49:26',NULL),(326,7968,105,40720,3133,3,57,2,6351.35,NULL,'2022-10-25 16:49:26','2022-10-25 16:49:26',NULL),(327,7968,106,40720,3133,3,392,1,10442.64,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(328,7968,106,40720,3133,3,68,1,2192.96,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(329,7968,106,40720,3133,3,57,2,12635.60,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(330,7968,107,40720,3133,3,482,1,4543.24,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(331,7968,107,40720,3133,3,68,1,954.08,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(332,7968,107,40720,3133,3,57,2,5497.32,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(333,7968,108,40720,3133,3,392,1,7884.29,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(334,7968,108,40720,3133,3,68,1,1655.70,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(335,7968,108,40720,3133,3,57,2,9539.99,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(336,7968,109,40720,3133,3,392,1,3488.76,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(337,7968,109,40720,3133,3,68,1,732.64,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(338,7968,109,40720,3133,3,57,2,4221.40,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(339,7968,110,40720,3133,3,392,1,2236.68,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(340,7968,110,40720,3133,3,68,1,234.85,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(341,7968,110,40720,3133,3,392,1,8608.35,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(342,7968,110,40720,3133,3,68,1,1807.75,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(343,7968,110,40720,3133,3,57,2,12887.63,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(344,7968,111,40720,3133,3,226,1,224.07,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(345,7968,111,40720,3133,3,250,1,7469.02,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(346,7968,111,40720,3133,3,68,1,1568.49,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(347,7968,111,40720,3133,3,57,2,9261.58,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(348,7968,112,40720,3133,3,226,1,86.03,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(349,7968,112,40720,3133,3,126,1,2867.50,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(350,7968,112,40720,3133,3,68,1,602.18,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(351,7968,112,40720,3133,3,57,2,3555.71,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(352,7968,113,40720,3133,3,396,1,300.89,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(353,7968,113,40720,3133,3,68,1,63.19,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(354,7968,113,40720,3133,3,57,2,364.08,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(355,7968,114,40720,3133,3,482,1,6784.71,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(356,7968,114,40720,3133,3,68,1,1424.79,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(357,7968,114,40720,3133,3,482,1,0.01,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(358,7968,114,40720,3133,3,57,2,8209.51,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(359,7968,115,40720,3133,3,392,1,8811.41,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(360,7968,115,40720,3133,3,68,1,1850.40,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(361,7968,115,40720,3133,3,57,2,10661.81,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(362,7968,116,40720,3133,3,392,1,9256.19,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(363,7968,116,40720,3133,3,68,1,1943.80,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(364,7968,116,40720,3133,3,392,1,0.01,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(365,7968,116,40720,3133,3,57,2,11200.00,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(366,7968,117,40720,3133,3,392,1,10811.73,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL);
INSERT INTO `balance_libro_details` VALUES (367,7968,117,40720,3133,3,68,1,2270.46,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(368,7968,117,40720,3133,3,57,2,13082.19,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(369,7968,118,40720,3133,3,392,1,11201.90,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(370,7968,118,40720,3133,3,68,1,2352.40,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(371,7968,118,40720,3133,3,57,2,13554.30,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(372,7968,119,40720,3133,3,392,1,6604.58,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(373,7968,119,40720,3133,3,68,1,1386.96,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(374,7968,119,40720,3133,3,57,2,7991.54,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(375,7968,120,40720,3133,3,221,1,697.92,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(376,7968,120,40720,3133,3,226,1,216.57,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(377,7968,120,40720,3133,3,392,1,6521.31,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(378,7968,120,40720,3133,3,57,2,7435.80,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(379,7968,121,40720,3133,3,221,1,208.44,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(380,7968,121,40720,3133,3,396,1,3473.87,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(381,7968,121,40720,3133,3,68,1,729.51,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(382,7968,121,40720,3133,3,57,2,4411.82,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(383,7968,122,40720,3133,3,392,1,10990.70,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(384,7968,122,40720,3133,3,68,1,2308.05,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(385,7968,122,40720,3133,3,57,2,13298.75,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(386,7968,123,40720,3133,3,396,1,280.03,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(387,7968,123,40720,3133,3,68,1,58.81,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(388,7968,123,40720,3133,3,57,2,338.84,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(389,7968,124,40720,3133,3,226,1,70.28,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(390,7968,124,40720,3133,3,126,1,2342.50,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(391,7968,124,40720,3133,3,68,1,491.93,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(392,7968,124,40720,3133,3,57,2,2904.71,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(393,7968,125,40720,3133,3,250,1,7347.93,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(394,7968,125,40720,3133,3,68,1,1543.07,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(395,7968,125,40720,3133,3,57,2,8891.00,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(396,7968,126,40720,3133,3,392,1,12493.41,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(397,7968,126,40720,3133,3,68,1,2623.62,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(398,7968,126,40720,3133,3,57,2,15117.03,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(399,7968,127,40720,3133,3,482,1,6839.80,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(400,7968,127,40720,3133,3,68,1,1436.36,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(401,7968,127,40720,3133,3,57,2,8276.16,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(402,7968,128,40720,3133,3,226,1,416.25,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(403,7968,128,40720,3133,3,220,1,337.51,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(404,7968,128,40720,3133,3,217,1,5248.80,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(405,7968,128,40720,3133,3,68,1,551.12,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(406,7968,128,40720,3133,3,217,1,8626.14,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(407,7968,128,40720,3133,3,68,1,1811.49,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(408,7968,128,40720,3133,3,217,1,0.01,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL);
INSERT INTO `balance_libro_details` VALUES (409,7968,128,40720,3133,3,57,2,16991.32,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(410,7968,129,40720,3133,3,392,1,5851.28,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(411,7968,129,40720,3133,3,68,1,1228.77,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(412,7968,129,40720,3133,3,57,2,7080.05,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(413,7968,130,40720,3133,3,396,1,358.01,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(414,7968,130,40720,3133,3,68,1,75.18,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(415,7968,130,40720,3133,3,57,2,433.19,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(416,7968,131,40720,3133,3,226,1,96.83,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(417,7968,131,40720,3133,3,126,1,3227.50,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(418,7968,131,40720,3133,3,68,1,677.78,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(419,7968,131,40720,3133,3,57,2,4002.11,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(420,7968,132,40720,3133,3,221,1,2011.01,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(421,7968,132,40720,3133,3,226,1,437.51,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(422,7968,132,40720,3133,3,392,1,12572.48,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(423,7968,132,40720,3133,3,57,2,15021.00,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(424,7968,133,40720,3133,3,57,2,0.00,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(425,7968,134,40720,3133,3,392,1,3223.15,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(426,7968,134,40720,3133,3,68,1,676.86,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(427,7968,134,40720,3133,3,57,2,3900.01,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(428,7968,135,40720,3133,3,392,2,2795.00,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(429,7968,135,40720,3133,3,67,2,293.48,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(430,7968,135,40720,3133,3,392,2,10990.70,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(431,7968,135,40720,3133,3,67,2,2308.05,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(432,7968,135,40720,3133,3,57,1,16387.23,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(433,7968,136,40720,3133,3,226,1,2303.43,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(434,7968,136,40720,3133,3,250,1,76780.91,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(435,7968,136,40720,3133,3,68,1,16123.99,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(436,7968,136,40720,3133,3,57,2,95208.33,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(437,7968,137,40720,3133,3,392,1,2795.00,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(438,7968,137,40720,3133,3,68,1,293.48,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(439,7968,137,40720,3133,3,392,1,10990.70,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(440,7968,137,40720,3133,3,68,1,2308.05,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(441,7968,137,40720,3133,3,57,2,16387.23,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(442,7968,138,40720,3133,3,392,1,2795.00,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(443,7968,138,40720,3133,3,68,1,293.48,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(444,7968,138,40720,3133,3,392,1,10990.70,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(445,7968,138,40720,3133,3,68,1,2308.05,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(446,7968,138,40720,3133,3,57,2,16387.23,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(447,7968,139,40720,3133,3,482,1,10499.33,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(448,7968,139,40720,3133,3,68,1,2204.86,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(449,7968,139,40720,3133,3,482,1,0.01,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(450,7968,139,40720,3133,3,57,2,12704.20,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL);
INSERT INTO `balance_libro_details` VALUES (451,7968,140,40720,3133,3,250,1,3163.63,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(452,7968,140,40720,3133,3,68,1,664.36,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(453,7968,140,40720,3133,3,57,2,3827.99,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(454,7968,141,40720,3133,3,392,1,6143.75,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(455,7968,141,40720,3133,3,68,1,1290.19,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(456,7968,141,40720,3133,3,57,2,7433.94,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(457,7968,142,40720,3133,3,482,1,471.06,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(458,7968,142,40720,3133,3,68,1,98.92,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(459,7968,142,40720,3133,3,57,2,569.98,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(460,7968,143,40720,3133,3,392,1,10082.62,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(461,7968,143,40720,3133,3,68,1,2117.35,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(462,7968,143,40720,3133,3,392,1,0.02,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(463,7968,143,40720,3133,3,57,2,12199.99,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(464,7968,144,40720,3133,3,482,1,5130.95,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(465,7968,144,40720,3133,3,68,1,1077.50,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(466,7968,144,40720,3133,3,482,1,0.01,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(467,7968,144,40720,3133,3,57,2,6208.46,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(468,7968,145,40720,3133,3,226,1,455.00,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(469,7968,145,40720,3133,3,220,1,388.08,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(470,7968,145,40720,3133,3,250,1,4461.48,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(471,7968,145,40720,3133,3,68,1,468.46,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(472,7968,145,40720,3133,3,250,1,10705.24,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(473,7968,145,40720,3133,3,68,1,2248.10,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(474,7968,145,40720,3133,3,57,2,18726.36,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(475,7968,146,40720,3133,3,392,1,12832.22,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(476,7968,146,40720,3133,3,68,1,2694.77,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(477,7968,146,40720,3133,3,57,2,15526.99,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(478,7968,147,40720,3133,3,250,1,1931.22,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(479,7968,147,40720,3133,3,68,1,202.78,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(480,7968,147,40720,3133,3,250,1,588.42,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(481,7968,147,40720,3133,3,68,1,123.57,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(482,7968,147,40720,3133,3,57,2,2845.99,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(483,7968,148,40720,3133,3,126,2,463.64,NULL,'2022-10-25 16:49:28','2022-10-25 16:54:13','2022-10-25 16:54:13'),(484,7968,148,40720,3133,3,67,2,97.36,NULL,'2022-10-25 16:49:28','2022-10-25 16:54:13','2022-10-25 16:54:13'),(485,7968,148,40720,3133,3,57,1,561.00,NULL,'2022-10-25 16:49:28','2022-10-25 16:54:13','2022-10-25 16:54:13'),(486,7968,149,40720,3133,3,97,1,25900.00,NULL,'2022-10-25 16:49:28','2022-10-25 16:54:05','2022-10-25 16:54:05'),(487,7968,149,40720,3133,3,97,1,25900.00,NULL,'2022-10-25 16:49:28','2022-10-25 16:54:05','2022-10-25 16:54:05'),(488,7968,149,40720,3133,3,57,2,25900.00,NULL,'2022-10-25 16:49:28','2022-10-25 16:54:05','2022-10-25 16:54:05'),(489,7968,149,40720,3133,3,136,2,25900.00,NULL,'2022-10-25 16:49:28','2022-10-25 16:54:05','2022-10-25 16:54:05'),(490,7968,150,40720,3133,3,192,1,25900.00,NULL,'2022-10-25 16:54:05','2022-10-25 16:54:05',NULL);
INSERT INTO `balance_libro_details` VALUES (491,7968,150,40720,3133,3,57,2,25900.00,NULL,'2022-10-25 16:54:05','2022-10-25 16:54:05',NULL),(492,7968,151,40720,3133,3,126,2,463.64,NULL,'2022-10-25 16:54:13','2022-10-25 16:54:13',NULL),(493,7968,151,40720,3133,3,67,2,97.36,NULL,'2022-10-25 16:54:13','2022-10-25 16:54:13',NULL),(494,7968,151,40720,3133,3,57,1,561.00,NULL,'2022-10-25 16:54:13','2022-10-25 16:54:13',NULL),(495,7968,152,40720,3134,3,392,1,10538.32,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(496,7968,152,40720,3134,3,68,1,2213.05,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(497,7968,152,40720,3134,3,57,2,12751.37,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(498,7968,153,40720,3134,3,221,1,1647.78,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(499,7968,153,40720,3134,3,226,1,399.15,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(500,7968,153,40720,3134,3,392,1,11657.23,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(501,7968,153,40720,3134,3,57,2,13704.16,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(502,7968,154,40720,3134,3,392,1,11869.96,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(503,7968,154,40720,3134,3,68,1,2492.69,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(504,7968,154,40720,3134,3,57,2,14362.65,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(505,7968,155,40720,3134,3,396,1,138.19,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(506,7968,155,40720,3134,3,68,1,29.02,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(507,7968,155,40720,3134,3,57,2,167.21,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(508,7968,156,40720,3134,3,226,1,33.83,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(509,7968,156,40720,3134,3,126,1,1127.50,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(510,7968,156,40720,3134,3,68,1,236.78,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(511,7968,156,40720,3134,3,57,2,1398.11,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(512,7968,157,40720,3134,3,226,1,242.41,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(513,7968,157,40720,3134,3,250,1,8080.27,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(514,7968,157,40720,3134,3,68,1,1696.86,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(515,7968,157,40720,3134,3,57,2,10019.54,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(516,7968,158,40720,3134,3,482,1,810.05,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(517,7968,158,40720,3134,3,68,1,170.11,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(518,7968,158,40720,3134,3,57,2,980.16,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(519,7968,159,40720,3134,3,392,1,9076.04,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(520,7968,159,40720,3134,3,68,1,1905.97,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(521,7968,159,40720,3134,3,57,2,10982.01,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(522,7968,160,40720,3134,3,116,1,96000.00,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(523,7968,160,40720,3134,3,68,1,20160.00,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(524,7968,160,40720,3134,3,57,2,116160.00,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(525,7968,161,40720,3134,3,116,1,96000.00,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(526,7968,161,40720,3134,3,68,1,20160.00,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(527,7968,161,40720,3134,3,57,2,116160.00,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(528,7968,162,40720,3134,3,392,1,8181.81,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(529,7968,162,40720,3134,3,68,1,1718.18,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(530,7968,162,40720,3134,3,57,2,9899.99,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(531,7968,163,40720,3134,3,116,1,96000.00,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL);
INSERT INTO `balance_libro_details` VALUES (532,7968,163,40720,3134,3,68,1,20160.00,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(533,7968,163,40720,3134,3,57,2,116160.00,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(534,7968,164,40720,3134,3,116,2,96000.00,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(535,7968,164,40720,3134,3,67,2,20160.00,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(536,7968,164,40720,3134,3,57,1,116160.00,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(537,7968,165,40720,3134,3,221,1,209.92,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(538,7968,165,40720,3134,3,396,1,3498.69,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(539,7968,165,40720,3134,3,68,1,734.72,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(540,7968,165,40720,3134,3,57,2,4443.33,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(541,7968,166,40720,3134,3,392,1,2842.32,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(542,7968,166,40720,3134,3,68,1,596.89,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(543,7968,166,40720,3134,3,57,2,3439.21,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(544,7968,167,40720,3134,3,396,1,129.91,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(545,7968,167,40720,3134,3,68,1,27.28,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(546,7968,167,40720,3134,3,57,2,157.19,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(547,7968,168,40720,3134,3,226,1,43.80,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(548,7968,168,40720,3134,3,126,1,1460.00,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(549,7968,168,40720,3134,3,68,1,306.60,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(550,7968,168,40720,3134,3,57,2,1810.40,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(551,7968,169,40720,3134,3,392,1,1475.00,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(552,7968,169,40720,3134,3,68,1,154.88,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(553,7968,169,40720,3134,3,392,1,11251.36,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(554,7968,169,40720,3134,3,68,1,2362.79,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(555,7968,169,40720,3134,3,57,2,15244.03,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(556,7968,170,40720,3134,3,392,1,6723.47,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(557,7968,170,40720,3134,3,68,1,1411.93,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(558,7968,170,40720,3134,3,57,2,8135.40,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(559,7968,171,40720,3134,3,392,1,8047.88,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(560,7968,171,40720,3134,3,68,1,1690.05,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(561,7968,171,40720,3134,3,57,2,9737.93,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(562,7968,172,40720,3134,3,396,1,97.46,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(563,7968,172,40720,3134,3,68,1,20.47,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(564,7968,172,40720,3134,3,57,2,117.93,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(565,7968,173,40720,3134,3,226,1,28.20,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(566,7968,173,40720,3134,3,126,1,940.00,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(567,7968,173,40720,3134,3,68,1,197.40,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(568,7968,173,40720,3134,3,57,2,1165.60,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(569,7968,174,40720,3134,3,57,2,0.00,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(570,7968,175,40720,3134,3,221,1,891.47,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(571,7968,175,40720,3134,3,226,1,224.79,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(572,7968,175,40720,3134,3,392,1,6601.91,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(573,7968,175,40720,3134,3,57,2,7718.17,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL);
INSERT INTO `balance_libro_details` VALUES (574,7968,176,40720,3134,3,392,1,6530.59,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(575,7968,176,40720,3134,3,68,1,1371.42,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(576,7968,176,40720,3134,3,57,2,7902.01,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(577,7968,177,40720,3134,3,392,1,11869.96,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(578,7968,177,40720,3134,3,68,1,2492.69,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(579,7968,177,40720,3134,3,57,2,14362.65,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(580,7968,178,40720,3134,3,226,1,93.15,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(581,7968,178,40720,3134,3,126,1,3105.00,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(582,7968,178,40720,3134,3,68,1,652.05,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(583,7968,178,40720,3134,3,57,2,3850.20,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(584,7968,179,40720,3134,3,396,1,344.40,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(585,7968,179,40720,3134,3,68,1,72.32,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(586,7968,179,40720,3134,3,57,2,416.72,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(587,7968,180,40720,3134,3,392,1,6160.34,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(588,7968,180,40720,3134,3,68,1,1293.67,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(589,7968,180,40720,3134,3,57,2,7454.01,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(590,7968,181,40720,3134,3,221,1,1102.11,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(591,7968,181,40720,3134,3,226,1,270.89,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(592,7968,181,40720,3134,3,392,1,7927.56,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(593,7968,181,40720,3134,3,57,2,9300.56,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(594,7968,182,40720,3134,3,392,1,9762.35,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(595,7968,182,40720,3134,3,68,1,2050.09,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(596,7968,182,40720,3134,3,57,2,11812.44,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(597,7968,183,40720,3134,3,392,1,10991.76,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(598,7968,183,40720,3134,3,68,1,2308.27,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(599,7968,183,40720,3134,3,392,1,0.01,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(600,7968,183,40720,3134,3,57,2,13300.04,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(601,7968,184,40720,3134,3,482,1,6371.46,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(602,7968,184,40720,3134,3,68,1,1338.01,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(603,7968,184,40720,3134,3,57,2,7709.47,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(604,7968,185,40720,3134,3,482,1,9916.52,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(605,7968,185,40720,3134,3,68,1,2082.47,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(606,7968,185,40720,3134,3,57,2,11998.99,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(607,7968,186,40720,3134,3,57,2,0.00,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(608,7968,187,40720,3134,3,221,1,1009.05,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(609,7968,187,40720,3134,3,226,1,262.27,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(610,7968,187,40720,3134,3,392,1,7733.58,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(611,7968,187,40720,3134,3,57,2,9004.90,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(612,7968,188,40720,3134,3,126,2,413.22,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(613,7968,188,40720,3134,3,67,2,86.78,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(614,7968,188,40720,3134,3,57,1,500.00,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL);
INSERT INTO `balance_libro_details` VALUES (615,7968,189,40720,3134,3,97,1,25900.00,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:39','2022-10-25 17:11:39'),(616,7968,189,40720,3134,3,97,1,25900.00,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:39','2022-10-25 17:11:39'),(617,7968,189,40720,3134,3,57,2,25900.00,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:39','2022-10-25 17:11:39'),(618,7968,189,40720,3134,3,136,2,25900.00,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:39','2022-10-25 17:11:39'),(619,7968,190,40720,3134,3,192,1,25900.00,NULL,'2022-10-25 17:11:39','2022-10-25 17:11:39',NULL),(620,7968,190,40720,3134,3,57,2,25900.00,NULL,'2022-10-25 17:11:39','2022-10-25 17:11:39',NULL),(621,7968,191,40720,1518,3,392,1,13982.24,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(622,7968,191,40720,1518,3,68,1,2936.27,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(623,7968,191,40720,1518,3,57,2,16918.51,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(624,7968,192,40720,1518,3,482,1,1685.79,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(625,7968,192,40720,1518,3,68,1,354.02,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(626,7968,192,40720,1518,3,57,2,2039.81,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(627,7968,193,40720,1518,3,126,1,1755.00,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(628,7968,193,40720,1518,3,68,1,368.55,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(629,7968,193,40720,1518,3,126,1,52.65,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(630,7968,193,40720,1518,3,57,2,2176.20,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(631,7968,194,40720,1518,3,396,1,188.24,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(632,7968,194,40720,1518,3,68,1,39.53,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(633,7968,194,40720,1518,3,57,2,227.77,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(634,7968,195,40720,1518,3,392,1,10925.98,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(635,7968,195,40720,1518,3,68,1,1770.41,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(636,7968,195,40720,1518,3,57,2,12696.39,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(637,7968,196,40720,1518,3,217,1,8767.09,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(638,7968,196,40720,1518,3,68,1,1841.09,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(639,7968,196,40720,1518,3,217,1,263.01,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(640,7968,196,40720,1518,3,57,2,10871.19,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(641,7968,197,40720,1518,3,392,1,5814.87,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(642,7968,197,40720,1518,3,68,1,1221.12,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(643,7968,197,40720,1518,3,57,2,7035.99,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(644,7968,198,40720,1518,3,126,1,1292.50,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(645,7968,198,40720,1518,3,68,1,271.43,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(646,7968,198,40720,1518,3,126,1,38.78,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(647,7968,198,40720,1518,3,57,2,1602.71,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(648,7968,199,40720,1518,3,396,1,138.19,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(649,7968,199,40720,1518,3,68,1,29.02,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(650,7968,199,40720,1518,3,57,2,167.21,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48');
INSERT INTO `balance_libro_details` VALUES (651,7968,200,40720,1518,3,482,1,777.62,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(652,7968,200,40720,1518,3,68,1,163.30,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(653,7968,200,40720,1518,3,57,2,940.92,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(654,7968,201,40720,1518,3,392,1,11251.36,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(655,7968,201,40720,1518,3,68,1,2362.79,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(656,7968,201,40720,1518,3,57,2,13614.15,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(657,7968,202,40720,1518,3,392,1,12109.79,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(658,7968,202,40720,1518,3,68,1,2543.08,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(659,7968,202,40720,1518,3,392,1,2562.29,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(660,7968,202,40720,1518,3,57,2,17215.16,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(661,7968,203,40720,1518,3,392,2,12109.79,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(662,7968,203,40720,1518,3,67,2,2543.08,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(663,7968,203,40720,1518,3,392,2,2562.29,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(664,7968,203,40720,1518,3,57,1,17215.16,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(665,7968,204,40720,1518,3,392,1,7641.45,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(666,7968,204,40720,1518,3,68,1,1604.70,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(667,7968,204,40720,1518,3,57,2,9246.15,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(668,7968,205,40720,1518,3,392,1,5879.61,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(669,7968,205,40720,1518,3,68,1,1234.72,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(670,7968,205,40720,1518,3,57,2,7114.33,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(671,7968,206,40720,1518,3,392,1,0.00,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(672,7968,206,40720,1518,3,57,2,0.00,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(673,7968,207,40720,1518,3,392,1,12125.92,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(674,7968,207,40720,1518,3,68,1,2546.47,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(675,7968,207,40720,1518,3,392,1,2532.06,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(676,7968,207,40720,1518,3,57,2,17204.45,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(677,7968,208,40720,1518,3,392,1,10991.75,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(678,7968,208,40720,1518,3,68,1,2308.27,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(679,7968,208,40720,1518,3,57,2,13300.02,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(680,7968,209,40720,1518,3,116,1,96000.00,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(681,7968,209,40720,1518,3,68,1,20160.00,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(682,7968,209,40720,1518,3,57,2,116160.00,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(683,7968,210,40720,1518,3,396,1,3857.84,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(684,7968,210,40720,1518,3,68,1,810.14,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(685,7968,210,40720,1518,3,396,1,231.48,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48');
INSERT INTO `balance_libro_details` VALUES (686,7968,210,40720,1518,3,57,2,4899.46,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(687,7968,211,40720,1518,3,392,1,5969.12,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(688,7968,211,40720,1518,3,68,1,1253.52,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(689,7968,211,40720,1518,3,57,2,7222.64,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(690,7968,212,40720,1518,3,482,1,17244.61,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(691,7968,212,40720,1518,3,68,1,3621.37,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(692,7968,212,40720,1518,3,57,2,20865.98,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(693,7968,213,40720,1518,3,126,1,785.00,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(694,7968,213,40720,1518,3,68,1,164.85,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(695,7968,213,40720,1518,3,126,1,23.55,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(696,7968,213,40720,1518,3,57,2,973.40,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(697,7968,214,40720,1518,3,396,1,104.58,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(698,7968,214,40720,1518,3,68,1,21.96,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(699,7968,214,40720,1518,3,57,2,126.54,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(700,7968,215,40720,1518,3,392,1,3345.09,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(701,7968,215,40720,1518,3,68,1,702.47,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(702,7968,215,40720,1518,3,57,2,4047.56,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(703,7968,216,40720,1518,3,392,1,11869.96,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(704,7968,216,40720,1518,3,68,1,2492.69,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(705,7968,216,40720,1518,3,57,2,14362.65,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(706,7968,217,40720,1518,3,217,1,25992.49,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(707,7968,217,40720,1518,3,68,1,4945.30,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(708,7968,217,40720,1518,3,217,1,1611.46,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(709,7968,217,40720,1518,3,57,2,32549.25,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(710,7968,218,40720,1518,3,126,1,2550.00,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(711,7968,218,40720,1518,3,68,1,535.50,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(712,7968,218,40720,1518,3,126,1,76.50,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(713,7968,218,40720,1518,3,57,2,3162.00,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(714,7968,219,40720,1518,3,396,1,333.99,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(715,7968,219,40720,1518,3,68,1,70.14,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(716,7968,219,40720,1518,3,57,2,404.13,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(717,7968,220,40720,1518,3,392,1,10775.63,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(718,7968,220,40720,1518,3,68,1,2262.88,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(719,7968,220,40720,1518,3,57,2,13038.51,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(720,7968,221,40720,1518,3,392,1,12987.92,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48');
INSERT INTO `balance_libro_details` VALUES (721,7968,221,40720,1518,3,68,1,2727.46,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(722,7968,221,40720,1518,3,57,2,15715.38,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(723,7968,222,40720,1518,3,392,1,5828.04,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(724,7968,222,40720,1518,3,68,1,1223.90,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(725,7968,222,40720,1518,3,392,1,1112.97,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(726,7968,222,40720,1518,3,57,2,8164.91,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(727,7968,223,40720,1518,3,392,1,0.00,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(728,7968,223,40720,1518,3,57,2,0.00,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(729,7968,224,40720,1518,3,392,1,10991.75,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(730,7968,224,40720,1518,3,68,1,2308.27,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(731,7968,224,40720,1518,3,57,2,13300.02,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(732,7968,225,40720,1518,3,97,1,25900.00,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(733,7968,225,40720,1518,3,57,2,25900.00,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(734,7968,226,40720,1518,3,126,2,670.25,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(735,7968,226,40720,1518,3,67,2,140.75,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(736,7968,226,40720,1518,3,57,1,811.00,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(737,7968,227,40720,1518,3,126,1,1105.00,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(738,7968,227,40720,1518,3,68,1,232.05,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(739,7968,227,40720,1518,3,126,1,33.15,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(740,7968,227,40720,1518,3,57,2,1370.20,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(741,7968,228,40720,1518,3,396,1,75.46,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(742,7968,228,40720,1518,3,68,1,15.85,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(743,7968,228,40720,1518,3,57,2,91.31,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(744,7968,229,40720,1518,3,482,1,1685.79,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(745,7968,229,40720,1518,3,68,1,354.02,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(746,7968,229,40720,1518,3,57,2,2039.81,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(747,7968,230,40720,1518,3,226,1,52.65,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(748,7968,230,40720,1518,3,126,1,1755.00,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(749,7968,230,40720,1518,3,68,1,368.55,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(750,7968,230,40720,1518,3,57,2,2176.20,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(751,7968,231,40720,1518,3,396,1,188.24,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(752,7968,231,40720,1518,3,68,1,39.53,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(753,7968,231,40720,1518,3,57,2,227.77,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(754,7968,232,40720,1518,3,392,1,13982.24,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(755,7968,232,40720,1518,3,68,1,2936.27,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(756,7968,232,40720,1518,3,57,2,16918.51,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(757,7968,233,40720,1518,3,392,1,4991.00,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(758,7968,233,40720,1518,3,68,1,524.06,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL);
INSERT INTO `balance_libro_details` VALUES (759,7968,233,40720,1518,3,392,1,5934.98,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(760,7968,233,40720,1518,3,68,1,1246.35,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(761,7968,233,40720,1518,3,57,2,12696.39,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(762,7968,234,40720,1518,3,226,1,263.01,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(763,7968,234,40720,1518,3,250,1,8767.09,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(764,7968,234,40720,1518,3,68,1,1841.09,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(765,7968,234,40720,1518,3,57,2,10871.19,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(766,7968,235,40720,1518,3,392,1,5814.87,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(767,7968,235,40720,1518,3,68,1,1221.12,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(768,7968,235,40720,1518,3,57,2,7035.99,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(769,7968,236,40720,1518,3,226,1,38.78,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(770,7968,236,40720,1518,3,126,1,1292.50,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(771,7968,236,40720,1518,3,68,1,271.43,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(772,7968,236,40720,1518,3,57,2,1602.71,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(773,7968,237,40720,1518,3,396,1,138.19,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(774,7968,237,40720,1518,3,68,1,29.02,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(775,7968,237,40720,1518,3,57,2,167.21,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(776,7968,238,40720,1518,3,482,1,777.62,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(777,7968,238,40720,1518,3,68,1,163.30,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(778,7968,238,40720,1518,3,57,2,940.92,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(779,7968,239,40720,1518,3,392,1,11251.36,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(780,7968,239,40720,1518,3,68,1,2362.79,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(781,7968,239,40720,1518,3,57,2,13614.15,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(782,7968,240,40720,1518,3,221,1,2060.87,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(783,7968,240,40720,1518,3,226,1,501.42,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(784,7968,240,40720,1518,3,392,1,14652.87,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(785,7968,240,40720,1518,3,57,2,17215.16,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(786,7968,241,40720,1518,3,221,2,2060.87,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(787,7968,241,40720,1518,3,226,2,501.42,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(788,7968,241,40720,1518,3,392,2,14652.87,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(789,7968,241,40720,1518,3,57,1,17215.16,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(790,7968,242,40720,1518,3,392,1,7641.45,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(791,7968,242,40720,1518,3,68,1,1604.70,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(792,7968,242,40720,1518,3,57,2,9246.15,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(793,7968,243,40720,1518,3,392,1,5879.61,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(794,7968,243,40720,1518,3,68,1,1234.72,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(795,7968,243,40720,1518,3,57,2,7114.33,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(796,7968,244,40720,1518,3,116,1,96000.00,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(797,7968,244,40720,1518,3,68,1,20160.00,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(798,7968,244,40720,1518,3,57,2,116160.00,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(799,7968,245,40720,1518,3,392,1,10991.76,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL);
INSERT INTO `balance_libro_details` VALUES (800,7968,245,40720,1518,3,68,1,2308.27,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(801,7968,245,40720,1518,3,392,1,0.01,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(802,7968,245,40720,1518,3,57,2,13300.04,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(803,7968,246,40720,1518,3,57,2,0.00,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(804,7968,247,40720,1518,3,221,1,2030.96,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(805,7968,247,40720,1518,3,226,1,501.10,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(806,7968,247,40720,1518,3,392,1,14672.39,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(807,7968,247,40720,1518,3,57,2,17204.45,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(808,7968,248,40720,1518,3,221,1,231.48,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(809,7968,248,40720,1518,3,396,1,3857.84,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(810,7968,248,40720,1518,3,68,1,810.14,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(811,7968,248,40720,1518,3,57,2,4899.46,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(812,7968,249,40720,1518,3,396,1,104.58,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(813,7968,249,40720,1518,3,68,1,21.96,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(814,7968,249,40720,1518,3,57,2,126.54,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(815,7968,250,40720,1518,3,226,1,23.55,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(816,7968,250,40720,1518,3,126,1,785.00,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(817,7968,250,40720,1518,3,68,1,164.85,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(818,7968,250,40720,1518,3,57,2,973.40,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(819,7968,251,40720,1518,3,392,1,5969.12,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(820,7968,251,40720,1518,3,68,1,1253.52,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(821,7968,251,40720,1518,3,57,2,7222.64,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(822,7968,252,40720,1518,3,482,1,17244.61,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(823,7968,252,40720,1518,3,68,1,3621.37,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(824,7968,252,40720,1518,3,57,2,20865.98,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(825,7968,253,40720,1518,3,392,1,3345.09,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(826,7968,253,40720,1518,3,68,1,702.47,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(827,7968,253,40720,1518,3,57,2,4047.56,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(828,7968,254,40720,1518,3,392,1,11869.96,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(829,7968,254,40720,1518,3,68,1,2492.69,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(830,7968,254,40720,1518,3,57,2,14362.65,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(831,7968,255,40720,1518,3,396,1,333.99,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(832,7968,255,40720,1518,3,68,1,70.14,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(833,7968,255,40720,1518,3,57,2,404.13,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(834,7968,256,40720,1518,3,226,1,76.50,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(835,7968,256,40720,1518,3,126,1,2550.00,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(836,7968,256,40720,1518,3,68,1,535.50,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(837,7968,256,40720,1518,3,57,2,3162.00,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(838,7968,257,40720,1518,3,221,1,121.56,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(839,7968,257,40720,1518,3,226,1,783.42,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(840,7968,257,40720,1518,3,220,1,706.47,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(841,7968,257,40720,1518,3,217,1,4886.80,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL);
INSERT INTO `balance_libro_details` VALUES (842,7968,257,40720,1518,3,68,1,513.11,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(843,7968,257,40720,1518,3,217,1,21105.69,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(844,7968,257,40720,1518,3,68,1,4432.19,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(845,7968,257,40720,1518,3,217,1,0.01,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(846,7968,257,40720,1518,3,57,2,32549.25,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(847,7968,258,40720,1518,3,392,1,10775.63,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(848,7968,258,40720,1518,3,68,1,2262.88,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(849,7968,258,40720,1518,3,57,2,13038.51,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(850,7968,259,40720,1518,3,392,1,12987.92,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(851,7968,259,40720,1518,3,68,1,2727.46,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(852,7968,259,40720,1518,3,57,2,15715.38,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(853,7968,260,40720,1518,3,57,2,0.00,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(854,7968,261,40720,1518,3,221,1,875.16,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(855,7968,261,40720,1518,3,226,1,237.81,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(856,7968,261,40720,1518,3,392,1,7051.94,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(857,7968,261,40720,1518,3,57,2,8164.91,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(858,7968,262,40720,1518,3,392,1,10991.76,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(859,7968,262,40720,1518,3,68,1,2308.27,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(860,7968,262,40720,1518,3,392,1,0.01,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(861,7968,262,40720,1518,3,57,2,13300.04,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(862,7968,263,40720,1518,3,396,1,75.46,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(863,7968,263,40720,1518,3,68,1,15.85,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(864,7968,263,40720,1518,3,57,2,91.31,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(865,7968,264,40720,1518,3,226,1,33.15,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(866,7968,264,40720,1518,3,126,1,1105.00,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(867,7968,264,40720,1518,3,68,1,232.05,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(868,7968,264,40720,1518,3,57,2,1370.20,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(869,7968,265,40720,1518,3,126,2,670.25,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(870,7968,265,40720,1518,3,67,2,140.75,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(871,7968,265,40720,1518,3,57,1,811.00,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(872,7968,266,40720,1518,3,97,1,25900.00,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(873,7968,266,40720,1518,3,97,1,25900.00,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(874,7968,266,40720,1518,3,57,2,25900.00,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(875,7968,266,40720,1518,3,136,2,25900.00,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(876,7968,267,40720,1518,2,96,2,1925.61,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(877,7968,267,40720,1518,2,67,2,404.39,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(878,7968,267,40720,1518,2,13,1,2330.00,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(879,7968,268,40720,1518,2,96,2,694.22,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(880,7968,268,40720,1518,2,67,2,145.78,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(881,7968,268,40720,1518,2,13,1,840.00,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(882,7968,269,40720,1518,2,96,2,413.22,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(883,7968,269,40720,1518,2,67,2,86.78,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL);
INSERT INTO `balance_libro_details` VALUES (884,7968,269,40720,1518,2,13,1,500.00,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(885,7968,270,40720,1518,2,96,2,280.99,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(886,7968,270,40720,1518,2,67,2,59.01,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(887,7968,270,40720,1518,2,13,1,340.00,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(888,7968,271,40720,1518,2,96,2,1900.83,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(889,7968,271,40720,1518,2,67,2,399.17,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(890,7968,271,40720,1518,2,13,1,2300.00,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(891,7968,272,40720,1518,2,96,2,1272.73,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(892,7968,272,40720,1518,2,67,2,267.27,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(893,7968,272,40720,1518,2,13,1,1540.00,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(894,7968,273,40720,1518,2,96,2,2859.51,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(895,7968,273,40720,1518,2,67,2,600.49,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(896,7968,273,40720,1518,2,13,1,3460.00,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(897,7968,274,40720,1518,2,96,2,1371.90,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(898,7968,274,40720,1518,2,67,2,288.10,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(899,7968,274,40720,1518,2,13,1,1660.00,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(900,7968,275,40720,1518,2,96,2,6495.86,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(901,7968,275,40720,1518,2,67,2,1364.14,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(902,7968,275,40720,1518,2,13,1,7860.00,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(903,7968,276,40720,1518,2,96,2,1603.31,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(904,7968,276,40720,1518,2,67,2,336.69,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(905,7968,276,40720,1518,2,13,1,1940.00,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(906,7968,277,40720,1518,2,96,2,446.28,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(907,7968,277,40720,1518,2,67,2,93.72,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(908,7968,277,40720,1518,2,13,1,540.00,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(909,7968,278,40720,1518,2,96,2,917.35,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(910,7968,278,40720,1518,2,67,2,192.65,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(911,7968,278,40720,1518,2,13,1,1110.00,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(912,7968,279,40720,1518,2,96,2,1900.82,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(913,7968,279,40720,1518,2,67,2,399.18,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(914,7968,279,40720,1518,2,13,1,2300.00,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(915,7968,280,40720,1518,2,96,2,1049.58,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(916,7968,280,40720,1518,2,67,2,220.42,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(917,7968,280,40720,1518,2,13,1,1270.00,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(918,7968,281,40720,1518,2,96,2,2140.49,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(919,7968,281,40720,1518,2,67,2,449.51,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(920,7968,281,40720,1518,2,13,1,2590.00,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(921,7968,282,40720,1518,2,96,2,495.86,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(922,7968,282,40720,1518,2,67,2,104.14,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(923,7968,282,40720,1518,2,13,1,600.00,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(924,7968,283,40720,1518,2,96,2,1537.19,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(925,7968,283,40720,1518,2,67,2,322.81,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL);
INSERT INTO `balance_libro_details` VALUES (926,7968,283,40720,1518,2,13,1,1860.00,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(927,7968,284,40720,1518,2,96,2,1884.30,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(928,7968,284,40720,1518,2,67,2,395.70,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(929,7968,284,40720,1518,2,13,1,2280.00,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(930,7968,285,40720,1518,2,96,2,1066.12,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(931,7968,285,40720,1518,2,67,2,223.88,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(932,7968,285,40720,1518,2,13,1,1290.00,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(933,7968,286,40720,1518,2,96,2,495.87,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(934,7968,286,40720,1518,2,67,2,104.13,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(935,7968,286,40720,1518,2,13,1,600.00,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(936,7968,287,40720,1518,2,96,2,2396.69,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(937,7968,287,40720,1518,2,67,2,503.31,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(938,7968,287,40720,1518,2,13,1,2900.00,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(939,7968,288,40720,1518,2,96,2,1066.12,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(940,7968,288,40720,1518,2,67,2,223.88,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(941,7968,288,40720,1518,2,13,1,1290.00,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(942,7968,289,40720,1518,2,96,2,1867.77,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(943,7968,289,40720,1518,2,67,2,392.23,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(944,7968,289,40720,1518,2,13,1,2260.00,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(945,7968,290,40720,1518,2,96,2,595.04,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(946,7968,290,40720,1518,2,67,2,124.96,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(947,7968,290,40720,1518,2,13,1,720.00,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(948,7968,291,40720,1518,2,96,2,909.09,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(949,7968,291,40720,1518,2,67,2,190.91,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(950,7968,291,40720,1518,2,13,1,1100.00,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(951,7968,292,40720,1518,2,96,2,404.96,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(952,7968,292,40720,1518,2,67,2,85.04,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(953,7968,292,40720,1518,2,13,1,490.00,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(954,7968,293,40720,1518,2,96,2,438.02,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(955,7968,293,40720,1518,2,67,2,91.98,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(956,7968,293,40720,1518,2,13,1,530.00,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(957,7968,294,40720,1518,2,96,2,2181.82,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(958,7968,294,40720,1518,2,67,2,458.18,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(959,7968,294,40720,1518,2,13,1,2640.00,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(960,7968,295,40720,1518,2,96,2,950.41,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(961,7968,295,40720,1518,2,67,2,199.59,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(962,7968,295,40720,1518,2,13,1,1150.00,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(963,7968,296,40720,1518,2,96,2,363.64,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(964,7968,296,40720,1518,2,67,2,76.36,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(965,7968,296,40720,1518,2,13,1,440.00,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(966,7968,297,40720,1518,2,96,2,785.13,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(967,7968,297,40720,1518,2,67,2,164.87,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL);
INSERT INTO `balance_libro_details` VALUES (968,7968,297,40720,1518,2,13,1,950.00,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(969,7968,298,40720,1518,2,96,2,487.60,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(970,7968,298,40720,1518,2,67,2,102.40,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(971,7968,298,40720,1518,2,13,1,590.00,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(972,7968,299,40720,1518,2,96,2,1983.48,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(973,7968,299,40720,1518,2,67,2,416.52,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(974,7968,299,40720,1518,2,13,1,2400.00,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(975,7968,300,40720,1518,2,96,2,1016.53,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(976,7968,300,40720,1518,2,67,2,213.47,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(977,7968,300,40720,1518,2,13,1,1230.00,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(978,7968,301,40720,1518,2,96,2,2041.33,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(979,7968,301,40720,1518,2,67,2,428.67,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(980,7968,301,40720,1518,2,13,1,2470.00,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(981,7968,302,40720,1518,2,96,2,1066.12,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(982,7968,302,40720,1518,2,67,2,223.88,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(983,7968,302,40720,1518,2,13,1,1290.00,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(984,7968,303,40720,1518,2,96,2,1900.83,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(985,7968,303,40720,1518,2,67,2,399.17,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(986,7968,303,40720,1518,2,13,1,2300.00,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(987,7968,304,40720,1518,2,96,2,768.60,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(988,7968,304,40720,1518,2,67,2,161.40,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(989,7968,304,40720,1518,2,13,1,930.00,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(990,7968,305,40720,1518,2,96,2,2578.51,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(991,7968,305,40720,1518,2,67,2,541.49,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(992,7968,305,40720,1518,2,13,1,3120.00,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(993,7968,306,40720,1518,2,96,2,314.05,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(994,7968,306,40720,1518,2,67,2,65.95,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(995,7968,306,40720,1518,2,13,1,380.00,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(996,7968,307,40720,1518,2,96,2,578.51,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(997,7968,307,40720,1518,2,67,2,121.49,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(998,7968,307,40720,1518,2,13,1,700.00,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(999,7968,308,40720,1518,2,96,2,1000.00,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1000,7968,308,40720,1518,2,67,2,210.00,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1001,7968,308,40720,1518,2,13,1,1210.00,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1002,7968,309,40720,1518,2,96,2,1743.80,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1003,7968,309,40720,1518,2,67,2,366.20,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1004,7968,309,40720,1518,2,13,1,2110.00,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1005,7968,310,40720,1518,2,96,2,917.36,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1006,7968,310,40720,1518,2,67,2,192.64,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1007,7968,310,40720,1518,2,13,1,1110.00,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1008,7968,311,40720,1518,2,96,2,1487.61,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1009,7968,311,40720,1518,2,67,2,312.39,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL);
INSERT INTO `balance_libro_details` VALUES (1010,7968,311,40720,1518,2,13,1,1800.00,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1011,7968,312,40720,1518,2,96,2,677.69,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1012,7968,312,40720,1518,2,67,2,142.31,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1013,7968,312,40720,1518,2,13,1,820.00,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1014,7968,313,40720,1518,2,96,2,3140.49,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1015,7968,313,40720,1518,2,67,2,659.51,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1016,7968,313,40720,1518,2,13,1,3800.00,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1017,7968,314,40720,1518,2,96,2,768.60,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1018,7968,314,40720,1518,2,67,2,161.40,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1019,7968,314,40720,1518,2,13,1,930.00,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1020,7968,315,40720,1518,2,96,2,785.12,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1021,7968,315,40720,1518,2,67,2,164.88,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1022,7968,315,40720,1518,2,13,1,950.00,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1023,7968,316,40720,1518,2,96,2,272.73,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1024,7968,316,40720,1518,2,67,2,57.27,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1025,7968,316,40720,1518,2,13,1,330.00,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1026,7968,317,40720,1518,2,96,2,1214.88,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1027,7968,317,40720,1518,2,67,2,255.12,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1028,7968,317,40720,1518,2,13,1,1470.00,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1029,7968,318,40720,1518,2,96,2,768.60,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1030,7968,318,40720,1518,2,67,2,161.40,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1031,7968,318,40720,1518,2,13,1,930.00,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1032,7968,319,40720,1518,2,96,2,735.54,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1033,7968,319,40720,1518,2,67,2,154.46,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1034,7968,319,40720,1518,2,13,1,890.00,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1035,7968,320,40720,1518,2,96,2,1280.99,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1036,7968,320,40720,1518,2,67,2,269.01,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1037,7968,320,40720,1518,2,13,1,1550.00,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1038,7968,321,40720,1518,2,96,2,892.56,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1039,7968,321,40720,1518,2,67,2,187.44,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1040,7968,321,40720,1518,2,13,1,1080.00,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(1041,7968,322,40720,1518,2,96,2,925.62,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1042,7968,322,40720,1518,2,67,2,194.38,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1043,7968,322,40720,1518,2,13,1,1120.00,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1044,7968,323,40720,1518,2,96,2,768.60,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1045,7968,323,40720,1518,2,67,2,161.40,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1046,7968,323,40720,1518,2,13,1,930.00,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1047,7968,324,40720,1518,2,96,2,2727.27,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1048,7968,324,40720,1518,2,67,2,572.73,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1049,7968,324,40720,1518,2,13,1,3300.00,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1050,7968,325,40720,1518,2,96,2,3016.52,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1051,7968,325,40720,1518,2,67,2,633.48,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL);
INSERT INTO `balance_libro_details` VALUES (1052,7968,325,40720,1518,2,13,1,3650.00,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1053,7968,326,40720,1518,2,96,2,909.09,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1054,7968,326,40720,1518,2,67,2,190.91,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1055,7968,326,40720,1518,2,13,1,1100.00,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1056,7968,327,40720,1518,2,96,2,2132.23,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1057,7968,327,40720,1518,2,67,2,447.77,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1058,7968,327,40720,1518,2,13,1,2580.00,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1059,7968,328,40720,1518,2,96,2,2314.06,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1060,7968,328,40720,1518,2,67,2,485.94,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1061,7968,328,40720,1518,2,13,1,2800.00,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1062,7968,329,40720,1518,2,96,2,1661.16,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1063,7968,329,40720,1518,2,67,2,348.84,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1064,7968,329,40720,1518,2,13,1,2010.00,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1065,7968,330,40720,1518,2,96,2,3206.61,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1066,7968,330,40720,1518,2,67,2,673.39,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1067,7968,330,40720,1518,2,13,1,3880.00,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1068,7968,331,40720,1518,2,96,2,2314.05,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1069,7968,331,40720,1518,2,67,2,485.95,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1070,7968,331,40720,1518,2,13,1,2800.00,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1071,7968,332,40720,1518,2,96,2,495.87,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1072,7968,332,40720,1518,2,67,2,104.13,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1073,7968,332,40720,1518,2,13,1,600.00,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1074,7968,333,40720,1518,2,96,2,1049.58,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1075,7968,333,40720,1518,2,67,2,220.42,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1076,7968,333,40720,1518,2,13,1,1270.00,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1077,7968,334,40720,1518,2,96,2,727.28,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1078,7968,334,40720,1518,2,67,2,152.72,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1079,7968,334,40720,1518,2,13,1,880.00,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1080,7968,335,40720,1518,2,96,2,685.95,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1081,7968,335,40720,1518,2,67,2,144.05,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1082,7968,335,40720,1518,2,13,1,830.00,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1083,7968,336,40720,1518,2,96,2,1661.16,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1084,7968,336,40720,1518,2,67,2,348.84,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1085,7968,336,40720,1518,2,13,1,2010.00,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1086,7968,337,40720,1518,2,96,2,983.47,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1087,7968,337,40720,1518,2,67,2,206.53,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1088,7968,337,40720,1518,2,13,1,1190.00,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1089,7968,338,40720,1518,2,96,2,413.22,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1090,7968,338,40720,1518,2,67,2,86.78,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1091,7968,338,40720,1518,2,13,1,500.00,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1092,7968,339,40720,1518,2,96,2,1396.69,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL);
INSERT INTO `balance_libro_details` VALUES (1093,7968,339,40720,1518,2,67,2,293.31,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1094,7968,339,40720,1518,2,13,1,1690.00,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1095,7968,340,40720,1518,2,96,2,1041.31,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1096,7968,340,40720,1518,2,67,2,218.69,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1097,7968,340,40720,1518,2,13,1,1260.00,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1098,7968,341,40720,1518,2,96,2,438.02,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1099,7968,341,40720,1518,2,67,2,91.98,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1100,7968,341,40720,1518,2,13,1,530.00,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1101,7968,342,40720,1518,2,96,2,1603.30,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1102,7968,342,40720,1518,2,67,2,336.70,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1103,7968,342,40720,1518,2,13,1,1940.00,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1104,7968,343,40720,1518,2,96,2,454.55,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1105,7968,343,40720,1518,2,67,2,95.45,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1106,7968,343,40720,1518,2,13,1,550.00,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1107,7968,344,40720,1518,2,96,2,966.94,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1108,7968,344,40720,1518,2,67,2,203.06,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1109,7968,344,40720,1518,2,13,1,1170.00,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1110,7968,345,40720,1518,2,96,2,1421.49,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1111,7968,345,40720,1518,2,67,2,298.51,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1112,7968,345,40720,1518,2,13,1,1720.00,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1113,7968,346,40720,1518,2,96,2,2057.85,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1114,7968,346,40720,1518,2,67,2,432.15,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1115,7968,346,40720,1518,2,13,1,2490.00,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1116,7968,347,40720,1518,2,96,2,1933.89,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1117,7968,347,40720,1518,2,67,2,406.11,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1118,7968,347,40720,1518,2,13,1,2340.00,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1119,7968,348,40720,1518,2,96,2,2438.03,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1120,7968,348,40720,1518,2,67,2,511.97,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1121,7968,348,40720,1518,2,13,1,2950.00,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1122,7968,349,40720,1518,2,96,2,2851.24,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1123,7968,349,40720,1518,2,67,2,598.76,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1124,7968,349,40720,1518,2,13,1,3450.00,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(1125,7968,350,40720,1518,2,96,2,2644.63,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1126,7968,350,40720,1518,2,67,2,555.37,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1127,7968,350,40720,1518,2,13,1,3200.00,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1128,7968,351,40720,1518,2,96,2,917.35,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1129,7968,351,40720,1518,2,67,2,192.65,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1130,7968,351,40720,1518,2,13,1,1110.00,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1131,7968,352,40720,1518,2,96,2,446.28,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1132,7968,352,40720,1518,2,67,2,93.72,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1133,7968,352,40720,1518,2,13,1,540.00,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL);
INSERT INTO `balance_libro_details` VALUES (1134,7968,353,40720,1518,2,96,2,1231.40,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1135,7968,353,40720,1518,2,67,2,258.60,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1136,7968,353,40720,1518,2,13,1,1490.00,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1137,7968,354,40720,1518,2,96,2,1487.61,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1138,7968,354,40720,1518,2,67,2,312.39,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1139,7968,354,40720,1518,2,13,1,1800.00,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1140,7968,355,40720,1518,2,96,2,785.13,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1141,7968,355,40720,1518,2,67,2,164.87,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1142,7968,355,40720,1518,2,13,1,950.00,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1143,7968,356,40720,1518,2,96,2,2082.64,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1144,7968,356,40720,1518,2,67,2,437.36,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1145,7968,356,40720,1518,2,13,1,2520.00,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1146,7968,357,40720,1518,2,96,2,1495.87,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1147,7968,357,40720,1518,2,67,2,314.13,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1148,7968,357,40720,1518,2,13,1,1810.00,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1149,7968,358,40720,1518,2,96,2,2148.76,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1150,7968,358,40720,1518,2,67,2,451.24,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1151,7968,358,40720,1518,2,13,1,2600.00,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1152,7968,359,40720,1518,2,96,2,1239.67,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1153,7968,359,40720,1518,2,67,2,260.33,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1154,7968,359,40720,1518,2,13,1,1500.00,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1155,7968,360,40720,1518,2,96,2,909.09,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1156,7968,360,40720,1518,2,67,2,190.91,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1157,7968,360,40720,1518,2,13,1,1100.00,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1158,7968,361,40720,1518,2,96,2,2214.88,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1159,7968,361,40720,1518,2,67,2,465.12,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1160,7968,361,40720,1518,2,13,1,2680.00,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1161,7968,362,40720,1518,2,96,2,1867.78,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1162,7968,362,40720,1518,2,67,2,392.22,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1163,7968,362,40720,1518,2,13,1,2260.00,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1164,7968,363,40720,1518,2,96,2,438.02,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1165,7968,363,40720,1518,2,67,2,91.98,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1166,7968,363,40720,1518,2,13,1,530.00,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1167,7968,364,40720,1518,2,96,2,1752.07,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1168,7968,364,40720,1518,2,67,2,367.93,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1169,7968,364,40720,1518,2,13,1,2120.00,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1170,7968,365,40720,1518,2,96,2,8115.70,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1171,7968,365,40720,1518,2,67,2,1704.30,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1172,7968,365,40720,1518,2,13,1,9820.00,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1173,7968,366,40720,1518,2,96,2,6347.10,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1174,7968,366,40720,1518,2,67,2,1332.90,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL);
INSERT INTO `balance_libro_details` VALUES (1175,7968,366,40720,1518,2,13,1,7680.00,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1176,7968,367,40720,1518,2,96,2,1537.19,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1177,7968,367,40720,1518,2,67,2,322.81,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1178,7968,367,40720,1518,2,13,1,1860.00,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1179,7968,368,40720,1518,2,96,2,1123.97,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1180,7968,368,40720,1518,2,67,2,236.03,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1181,7968,368,40720,1518,2,13,1,1360.00,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1182,7968,369,40720,1518,2,96,2,942.15,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1183,7968,369,40720,1518,2,67,2,197.85,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1184,7968,369,40720,1518,2,13,1,1140.00,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1185,7968,370,40720,1518,2,96,2,909.09,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1186,7968,370,40720,1518,2,67,2,190.91,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1187,7968,370,40720,1518,2,13,1,1100.00,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1188,7968,371,40720,1518,2,96,2,495.87,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1189,7968,371,40720,1518,2,67,2,104.13,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1190,7968,371,40720,1518,2,13,1,600.00,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1191,7968,372,40720,1518,2,96,2,636.36,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1192,7968,372,40720,1518,2,67,2,133.64,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1193,7968,372,40720,1518,2,13,1,770.00,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1194,7968,373,40720,1518,2,96,2,1214.88,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1195,7968,373,40720,1518,2,67,2,255.12,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1196,7968,373,40720,1518,2,13,1,1470.00,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1197,7968,374,40720,1518,2,96,2,363.64,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1198,7968,374,40720,1518,2,67,2,76.36,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1199,7968,374,40720,1518,2,13,1,440.00,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1200,7968,375,40720,1518,2,96,2,1000.00,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1201,7968,375,40720,1518,2,67,2,210.00,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1202,7968,375,40720,1518,2,13,1,1210.00,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1203,7968,376,40720,1518,2,96,2,1537.19,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1204,7968,376,40720,1518,2,67,2,322.81,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1205,7968,376,40720,1518,2,13,1,1860.00,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(1206,7968,377,40720,1518,2,96,2,413.22,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1207,7968,377,40720,1518,2,67,2,86.78,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1208,7968,377,40720,1518,2,13,1,500.00,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1209,7968,378,40720,1518,2,96,2,1214.88,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1210,7968,378,40720,1518,2,67,2,255.12,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1211,7968,378,40720,1518,2,13,1,1470.00,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1212,7968,379,40720,1518,2,96,2,1272.73,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1213,7968,379,40720,1518,2,67,2,267.27,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1214,7968,379,40720,1518,2,13,1,1540.00,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1215,7968,380,40720,1518,2,96,2,545.45,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1216,7968,380,40720,1518,2,67,2,114.55,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL);
INSERT INTO `balance_libro_details` VALUES (1217,7968,380,40720,1518,2,13,1,660.00,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1218,7968,381,40720,1518,2,96,2,495.87,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1219,7968,381,40720,1518,2,67,2,104.13,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1220,7968,381,40720,1518,2,13,1,600.00,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1221,7968,382,40720,1518,2,96,2,909.09,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1222,7968,382,40720,1518,2,67,2,190.91,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1223,7968,382,40720,1518,2,13,1,1100.00,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1224,7968,383,40720,1518,2,96,2,776.87,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1225,7968,383,40720,1518,2,67,2,163.13,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1226,7968,383,40720,1518,2,13,1,940.00,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1227,7968,384,40720,1518,2,96,2,719.01,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1228,7968,384,40720,1518,2,67,2,150.99,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1229,7968,384,40720,1518,2,13,1,870.00,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1230,7968,385,40720,1518,2,96,2,1057.86,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1231,7968,385,40720,1518,2,67,2,222.14,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1232,7968,385,40720,1518,2,13,1,1280.00,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1233,7968,386,40720,1518,2,96,2,1619.84,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1234,7968,386,40720,1518,2,67,2,340.16,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1235,7968,386,40720,1518,2,13,1,1960.00,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1236,7968,387,40720,1518,2,96,2,2033.06,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1237,7968,387,40720,1518,2,67,2,426.94,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1238,7968,387,40720,1518,2,13,1,2460.00,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1239,7968,388,40720,1518,2,96,2,553.72,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1240,7968,388,40720,1518,2,67,2,116.28,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1241,7968,388,40720,1518,2,13,1,670.00,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1242,7968,389,40720,1518,2,96,2,1884.30,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1243,7968,389,40720,1518,2,67,2,395.70,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1244,7968,389,40720,1518,2,13,1,2280.00,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1245,7968,390,40720,1518,2,96,2,1586.78,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1246,7968,390,40720,1518,2,67,2,333.22,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1247,7968,390,40720,1518,2,13,1,1920.00,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1248,7968,391,40720,1518,2,96,2,1066.12,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1249,7968,391,40720,1518,2,67,2,223.88,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1250,7968,391,40720,1518,2,13,1,1290.00,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1251,7968,392,40720,1518,2,96,2,520.66,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1252,7968,392,40720,1518,2,67,2,109.34,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1253,7968,392,40720,1518,2,13,1,630.00,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1254,7968,393,40720,1518,2,96,2,429.75,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1255,7968,393,40720,1518,2,67,2,90.25,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1256,7968,393,40720,1518,2,13,1,520.00,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1257,7968,394,40720,1518,2,96,2,909.09,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1258,7968,394,40720,1518,2,67,2,190.91,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL);
INSERT INTO `balance_libro_details` VALUES (1259,7968,394,40720,1518,2,13,1,1100.00,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1260,7968,395,40720,1518,2,96,2,2256.20,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1261,7968,395,40720,1518,2,67,2,473.80,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1262,7968,395,40720,1518,2,13,1,2730.00,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1263,7968,396,40720,1518,2,96,2,966.94,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1264,7968,396,40720,1518,2,67,2,203.06,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1265,7968,396,40720,1518,2,13,1,1170.00,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1266,7968,397,40720,1518,2,96,2,834.72,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1267,7968,397,40720,1518,2,67,2,175.28,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1268,7968,397,40720,1518,2,13,1,1010.00,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1269,7968,398,40720,1518,2,96,2,727.27,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1270,7968,398,40720,1518,2,67,2,152.73,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1271,7968,398,40720,1518,2,13,1,880.00,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1272,7968,399,40720,1518,2,96,2,685.95,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1273,7968,399,40720,1518,2,67,2,144.05,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1274,7968,399,40720,1518,2,13,1,830.00,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1275,7968,400,40720,1518,2,96,2,338.84,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1276,7968,400,40720,1518,2,67,2,71.16,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1277,7968,400,40720,1518,2,13,1,410.00,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1278,7968,401,40720,1518,2,96,2,2223.14,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1279,7968,401,40720,1518,2,67,2,466.86,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1280,7968,401,40720,1518,2,13,1,2690.00,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1281,7968,402,40720,1518,2,96,2,2347.11,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1282,7968,402,40720,1518,2,67,2,492.89,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1283,7968,402,40720,1518,2,13,1,2840.00,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1284,7968,403,40720,1518,2,96,2,1396.69,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1285,7968,403,40720,1518,2,67,2,293.31,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1286,7968,403,40720,1518,2,13,1,1690.00,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1287,7968,404,40720,1518,2,96,2,1247.94,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1288,7968,404,40720,1518,2,67,2,262.06,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1289,7968,404,40720,1518,2,13,1,1510.00,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1290,7968,405,40720,1518,2,96,2,2016.52,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1291,7968,405,40720,1518,2,67,2,423.48,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1292,7968,405,40720,1518,2,13,1,2440.00,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(1293,7968,406,40720,1518,2,96,2,347.11,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1294,7968,406,40720,1518,2,67,2,72.89,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1295,7968,406,40720,1518,2,13,1,420.00,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1296,7968,407,40720,1518,2,96,2,479.34,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1297,7968,407,40720,1518,2,67,2,100.66,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1298,7968,407,40720,1518,2,13,1,580.00,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1299,7968,408,40720,1518,2,96,2,1231.41,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1300,7968,408,40720,1518,2,67,2,258.59,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL);
INSERT INTO `balance_libro_details` VALUES (1301,7968,408,40720,1518,2,13,1,1490.00,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1302,7968,409,40720,1518,2,96,2,272.73,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1303,7968,409,40720,1518,2,67,2,57.27,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1304,7968,409,40720,1518,2,13,1,330.00,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1305,7968,410,40720,1518,2,96,2,1561.99,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1306,7968,410,40720,1518,2,67,2,328.01,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1307,7968,410,40720,1518,2,13,1,1890.00,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1308,7968,411,40720,1518,2,96,2,1801.66,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1309,7968,411,40720,1518,2,67,2,378.34,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1310,7968,411,40720,1518,2,13,1,2180.00,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1311,7968,412,40720,1518,2,96,2,1462.82,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1312,7968,412,40720,1518,2,67,2,307.18,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1313,7968,412,40720,1518,2,13,1,1770.00,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1314,7968,413,40720,1518,2,96,2,2809.92,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1315,7968,413,40720,1518,2,67,2,590.08,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1316,7968,413,40720,1518,2,13,1,3400.00,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1317,7968,414,40720,1518,2,96,2,520.66,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1318,7968,414,40720,1518,2,67,2,109.34,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1319,7968,414,40720,1518,2,13,1,630.00,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1320,7968,415,40720,1518,2,96,2,1214.88,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1321,7968,415,40720,1518,2,67,2,255.12,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1322,7968,415,40720,1518,2,13,1,1470.00,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1323,7968,416,40720,1518,2,96,2,636.36,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1324,7968,416,40720,1518,2,67,2,133.64,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1325,7968,416,40720,1518,2,13,1,770.00,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1326,7968,417,40720,1518,2,96,2,363.64,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1327,7968,417,40720,1518,2,67,2,76.36,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1328,7968,417,40720,1518,2,13,1,440.00,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1329,7968,418,40720,1518,2,96,2,1900.83,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1330,7968,418,40720,1518,2,67,2,399.17,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1331,7968,418,40720,1518,2,13,1,2300.00,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1332,7968,419,40720,1518,2,96,2,2809.92,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1333,7968,419,40720,1518,2,67,2,590.08,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1334,7968,419,40720,1518,2,13,1,3400.00,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1335,7968,420,40720,1518,2,96,2,2685.94,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1336,7968,420,40720,1518,2,67,2,564.06,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1337,7968,420,40720,1518,2,13,1,3250.00,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1338,7968,421,40720,1518,2,96,2,1305.79,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1339,7968,421,40720,1518,2,67,2,274.21,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1340,7968,421,40720,1518,2,13,1,1580.00,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1341,7968,422,40720,1518,2,96,2,1818.18,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL);
INSERT INTO `balance_libro_details` VALUES (1342,7968,422,40720,1518,2,67,2,381.82,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1343,7968,422,40720,1518,2,13,1,2200.00,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1344,7968,423,40720,1518,2,96,2,991.73,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1345,7968,423,40720,1518,2,67,2,208.27,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1346,7968,423,40720,1518,2,13,1,1200.00,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1347,7968,424,40720,1518,2,96,2,727.27,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1348,7968,424,40720,1518,2,67,2,152.73,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1349,7968,424,40720,1518,2,13,1,880.00,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1350,7968,425,40720,1518,2,96,2,462.81,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1351,7968,425,40720,1518,2,67,2,97.19,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1352,7968,425,40720,1518,2,13,1,560.00,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1353,7968,426,40720,1518,2,96,2,1404.97,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1354,7968,426,40720,1518,2,67,2,295.03,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1355,7968,426,40720,1518,2,13,1,1700.00,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1356,7968,427,40720,1518,2,96,2,909.09,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1357,7968,427,40720,1518,2,67,2,190.91,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1358,7968,427,40720,1518,2,13,1,1100.00,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1359,7968,428,40720,1518,2,96,2,1487.61,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1360,7968,428,40720,1518,2,67,2,312.39,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1361,7968,428,40720,1518,2,13,1,1800.00,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1362,7968,429,40720,1518,2,96,2,735.54,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1363,7968,429,40720,1518,2,67,2,154.46,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1364,7968,429,40720,1518,2,13,1,890.00,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1365,7968,430,40720,1518,2,96,2,867.77,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1366,7968,430,40720,1518,2,67,2,182.23,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1367,7968,430,40720,1518,2,13,1,1050.00,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1368,7968,431,40720,1518,2,96,2,1380.17,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1369,7968,431,40720,1518,2,67,2,289.83,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1370,7968,431,40720,1518,2,13,1,1670.00,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(1371,7968,432,40720,1518,2,96,2,1074.38,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1372,7968,432,40720,1518,2,67,2,225.62,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1373,7968,432,40720,1518,2,13,1,1300.00,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1374,7968,433,40720,1518,2,96,2,1314.06,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1375,7968,433,40720,1518,2,67,2,275.94,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1376,7968,433,40720,1518,2,13,1,1590.00,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1377,7968,434,40720,1518,2,96,2,1884.30,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1378,7968,434,40720,1518,2,67,2,395.70,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1379,7968,434,40720,1518,2,13,1,2280.00,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1380,7968,435,40720,1518,2,96,2,768.60,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1381,7968,435,40720,1518,2,67,2,161.40,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1382,7968,435,40720,1518,2,13,1,930.00,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1383,7968,436,40720,1518,2,96,2,1661.16,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL);
INSERT INTO `balance_libro_details` VALUES (1384,7968,436,40720,1518,2,67,2,348.84,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1385,7968,436,40720,1518,2,13,1,2010.00,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1386,7968,437,40720,1518,2,96,2,710.74,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1387,7968,437,40720,1518,2,67,2,149.26,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1388,7968,437,40720,1518,2,13,1,860.00,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1389,7968,438,40720,1518,2,96,2,495.87,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1390,7968,438,40720,1518,2,67,2,104.13,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1391,7968,438,40720,1518,2,13,1,600.00,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1392,7968,439,40720,1518,2,96,2,1181.82,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1393,7968,439,40720,1518,2,67,2,248.18,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1394,7968,439,40720,1518,2,13,1,1430.00,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1395,7968,440,40720,1518,2,96,2,768.60,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1396,7968,440,40720,1518,2,67,2,161.40,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1397,7968,440,40720,1518,2,13,1,930.00,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1398,7968,441,40720,1518,2,96,2,2809.92,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1399,7968,441,40720,1518,2,67,2,590.08,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1400,7968,441,40720,1518,2,13,1,3400.00,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1401,7968,442,40720,1518,2,96,2,314.05,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1402,7968,442,40720,1518,2,67,2,65.95,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1403,7968,442,40720,1518,2,13,1,380.00,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1404,7968,443,40720,1518,2,96,2,2033.06,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1405,7968,443,40720,1518,2,67,2,426.94,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1406,7968,443,40720,1518,2,13,1,2460.00,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1407,7968,444,40720,1518,2,96,2,1429.75,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1408,7968,444,40720,1518,2,67,2,300.25,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1409,7968,444,40720,1518,2,13,1,1730.00,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1410,7968,445,40720,1518,2,96,2,1107.44,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1411,7968,445,40720,1518,2,67,2,232.56,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1412,7968,445,40720,1518,2,13,1,1340.00,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1413,7968,446,40720,1518,2,96,2,1933.88,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1414,7968,446,40720,1518,2,67,2,406.12,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1415,7968,446,40720,1518,2,13,1,2340.00,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1416,7968,447,40720,1518,2,96,2,909.09,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1417,7968,447,40720,1518,2,67,2,190.91,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1418,7968,447,40720,1518,2,13,1,1100.00,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1419,7968,448,40720,1518,2,96,2,768.60,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1420,7968,448,40720,1518,2,67,2,161.40,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1421,7968,448,40720,1518,2,13,1,930.00,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1422,7968,449,40720,1518,2,96,2,272.73,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1423,7968,449,40720,1518,2,67,2,57.27,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1424,7968,449,40720,1518,2,13,1,330.00,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1425,7968,450,40720,1518,2,96,2,1173.55,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL);
INSERT INTO `balance_libro_details` VALUES (1426,7968,450,40720,1518,2,67,2,246.45,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1427,7968,450,40720,1518,2,13,1,1420.00,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1428,7968,451,40720,1518,2,96,2,966.94,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1429,7968,451,40720,1518,2,67,2,203.06,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1430,7968,451,40720,1518,2,13,1,1170.00,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1431,7968,452,40720,1518,2,96,2,1041.33,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1432,7968,452,40720,1518,2,67,2,218.67,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1433,7968,452,40720,1518,2,13,1,1260.00,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1434,7968,453,40720,1518,2,96,2,1909.10,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1435,7968,453,40720,1518,2,67,2,400.90,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1436,7968,453,40720,1518,2,13,1,2310.00,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1437,7968,454,40720,1518,2,96,2,768.60,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1438,7968,454,40720,1518,2,67,2,161.40,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1439,7968,454,40720,1518,2,13,1,930.00,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1440,7968,455,40720,1518,2,96,2,1975.21,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1441,7968,455,40720,1518,2,67,2,414.79,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1442,7968,455,40720,1518,2,13,1,2390.00,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1443,7968,456,40720,1518,2,96,2,1239.67,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1444,7968,456,40720,1518,2,67,2,260.33,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1445,7968,456,40720,1518,2,13,1,1500.00,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1446,7968,457,40720,1518,2,96,2,1652.90,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1447,7968,457,40720,1518,2,67,2,347.10,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1448,7968,457,40720,1518,2,13,1,2000.00,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1449,7968,458,40720,1518,2,96,2,1247.94,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1450,7968,458,40720,1518,2,67,2,262.06,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1451,7968,458,40720,1518,2,13,1,1510.00,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1452,7968,459,40720,1518,2,96,2,677.69,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1453,7968,459,40720,1518,2,67,2,142.31,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1454,7968,459,40720,1518,2,13,1,820.00,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1455,7968,460,40720,1518,2,96,2,1033.06,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1456,7968,460,40720,1518,2,67,2,216.94,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1457,7968,460,40720,1518,2,13,1,1250.00,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1458,7968,461,40720,1518,2,96,2,338.84,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1459,7968,461,40720,1518,2,67,2,71.16,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1460,7968,461,40720,1518,2,13,1,410.00,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1461,7968,462,40720,1518,2,96,2,1206.61,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1462,7968,462,40720,1518,2,67,2,253.39,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1463,7968,462,40720,1518,2,13,1,1460.00,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1464,7968,463,40720,1518,2,96,2,2719.01,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1465,7968,463,40720,1518,2,67,2,570.99,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1466,7968,463,40720,1518,2,13,1,3290.00,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL);
INSERT INTO `balance_libro_details` VALUES (1467,7968,464,40720,1518,2,96,2,1446.28,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1468,7968,464,40720,1518,2,67,2,303.72,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1469,7968,464,40720,1518,2,13,1,1750.00,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(1470,7968,465,40720,1518,2,96,2,1380.16,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1471,7968,465,40720,1518,2,67,2,289.84,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1472,7968,465,40720,1518,2,13,1,1670.00,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1473,7968,466,40720,1518,2,96,2,3272.73,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1474,7968,466,40720,1518,2,67,2,687.27,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1475,7968,466,40720,1518,2,13,1,3960.00,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1476,7968,467,40720,1518,2,96,2,1347.11,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1477,7968,467,40720,1518,2,67,2,282.89,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1478,7968,467,40720,1518,2,13,1,1630.00,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1479,7968,468,40720,1518,2,96,2,3314.04,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1480,7968,468,40720,1518,2,67,2,695.96,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1481,7968,468,40720,1518,2,13,1,4010.00,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1482,7968,469,40720,1518,2,96,2,834.71,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1483,7968,469,40720,1518,2,67,2,175.29,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1484,7968,469,40720,1518,2,13,1,1010.00,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1485,7968,470,40720,1518,2,96,2,1247.93,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1486,7968,470,40720,1518,2,67,2,262.07,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1487,7968,470,40720,1518,2,13,1,1510.00,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1488,7968,471,40720,1518,2,96,2,1801.66,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1489,7968,471,40720,1518,2,67,2,378.34,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1490,7968,471,40720,1518,2,13,1,2180.00,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1491,7968,472,40720,1518,2,96,2,1082.64,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1492,7968,472,40720,1518,2,67,2,227.36,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1493,7968,472,40720,1518,2,13,1,1310.00,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1494,7968,473,40720,1518,2,96,2,347.11,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1495,7968,473,40720,1518,2,67,2,72.89,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1496,7968,473,40720,1518,2,13,1,420.00,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1497,7968,474,40720,1518,2,96,2,2074.38,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1498,7968,474,40720,1518,2,67,2,435.62,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1499,7968,474,40720,1518,2,13,1,2510.00,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1500,7968,475,40720,1518,2,96,2,2702.48,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1501,7968,475,40720,1518,2,67,2,567.52,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1502,7968,475,40720,1518,2,13,1,3270.00,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1503,7968,476,40720,1518,2,96,2,2363.64,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1504,7968,476,40720,1518,2,67,2,496.36,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1505,7968,476,40720,1518,2,13,1,2860.00,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1506,7968,477,40720,1518,2,96,2,2669.42,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1507,7968,477,40720,1518,2,67,2,560.58,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL);
INSERT INTO `balance_libro_details` VALUES (1508,7968,477,40720,1518,2,13,1,3230.00,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1509,7968,478,40720,1518,2,96,2,1975.21,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1510,7968,478,40720,1518,2,67,2,414.79,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1511,7968,478,40720,1518,2,13,1,2390.00,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1512,7968,479,40720,1518,2,96,2,851.25,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1513,7968,479,40720,1518,2,67,2,178.75,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1514,7968,479,40720,1518,2,13,1,1030.00,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1515,7968,480,40720,1518,2,96,2,661.16,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1516,7968,480,40720,1518,2,67,2,138.84,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1517,7968,480,40720,1518,2,13,1,800.00,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1518,7968,481,40720,1518,2,96,2,909.09,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1519,7968,481,40720,1518,2,67,2,190.91,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1520,7968,481,40720,1518,2,13,1,1100.00,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1521,7968,482,40720,1518,2,96,2,710.74,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1522,7968,482,40720,1518,2,67,2,149.26,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1523,7968,482,40720,1518,2,13,1,860.00,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1524,7968,483,40720,1518,2,96,2,1950.42,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1525,7968,483,40720,1518,2,67,2,409.58,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1526,7968,483,40720,1518,2,13,1,2360.00,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1527,7968,484,40720,1518,2,96,2,1859.50,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1528,7968,484,40720,1518,2,67,2,390.50,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1529,7968,484,40720,1518,2,13,1,2250.00,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1530,7968,485,40720,1518,2,96,2,768.60,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1531,7968,485,40720,1518,2,67,2,161.40,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1532,7968,485,40720,1518,2,13,1,930.00,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1533,7968,486,40720,1518,2,96,2,2809.92,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1534,7968,486,40720,1518,2,67,2,590.08,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1535,7968,486,40720,1518,2,13,1,3400.00,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1536,7968,487,40720,1518,2,96,2,1975.21,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1537,7968,487,40720,1518,2,67,2,414.79,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1538,7968,487,40720,1518,2,13,1,2390.00,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1539,7968,488,40720,1518,2,96,2,1446.28,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1540,7968,488,40720,1518,2,67,2,303.72,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1541,7968,488,40720,1518,2,13,1,1750.00,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1542,7968,489,40720,1518,2,96,2,1173.55,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1543,7968,489,40720,1518,2,67,2,246.45,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1544,7968,489,40720,1518,2,13,1,1420.00,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1545,7968,490,40720,1518,2,96,2,1512.40,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1546,7968,490,40720,1518,2,67,2,317.60,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1547,7968,490,40720,1518,2,13,1,1830.00,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1548,7968,491,40720,1518,2,96,2,1157.02,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL);
INSERT INTO `balance_libro_details` VALUES (1549,7968,491,40720,1518,2,67,2,242.98,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1550,7968,491,40720,1518,2,13,1,1400.00,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1551,7968,492,40720,1518,2,96,2,561.98,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1552,7968,492,40720,1518,2,67,2,118.02,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1553,7968,492,40720,1518,2,13,1,680.00,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1554,7968,493,40720,1518,2,96,2,2280.99,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1555,7968,493,40720,1518,2,67,2,479.01,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1556,7968,493,40720,1518,2,13,1,2760.00,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1557,7968,494,40720,1518,2,96,2,1000.00,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1558,7968,494,40720,1518,2,67,2,210.00,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1559,7968,494,40720,1518,2,13,1,1210.00,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(1560,7968,495,40720,1518,2,96,2,2652.90,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1561,7968,495,40720,1518,2,67,2,557.10,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1562,7968,495,40720,1518,2,13,1,3210.00,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1563,7968,496,40720,1518,2,96,2,2305.79,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1564,7968,496,40720,1518,2,67,2,484.21,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1565,7968,496,40720,1518,2,13,1,2790.00,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1566,7968,497,40720,1518,2,96,2,2305.79,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1567,7968,497,40720,1518,2,67,2,484.21,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1568,7968,497,40720,1518,2,13,1,2790.00,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1569,7968,498,40720,1518,2,96,2,1636.37,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1570,7968,498,40720,1518,2,67,2,343.63,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1571,7968,498,40720,1518,2,13,1,1980.00,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1572,7968,499,40720,1518,2,96,2,1966.94,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1573,7968,499,40720,1518,2,67,2,413.06,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1574,7968,499,40720,1518,2,13,1,2380.00,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1575,7968,500,40720,1518,2,96,2,826.44,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1576,7968,500,40720,1518,2,67,2,173.56,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1577,7968,500,40720,1518,2,13,1,1000.00,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1578,7968,501,40720,1518,2,96,2,545.45,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1579,7968,501,40720,1518,2,67,2,114.55,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1580,7968,501,40720,1518,2,13,1,660.00,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1581,7968,502,40720,1518,2,96,2,1280.99,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1582,7968,502,40720,1518,2,67,2,269.01,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1583,7968,502,40720,1518,2,13,1,1550.00,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1584,7968,503,40720,1518,2,96,2,983.47,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1585,7968,503,40720,1518,2,67,2,206.53,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1586,7968,503,40720,1518,2,13,1,1190.00,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1587,7968,504,40720,1518,2,96,1,2305.79,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1588,7968,504,40720,1518,2,68,1,484.21,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1589,7968,504,40720,1518,2,13,2,2790.00,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL);
INSERT INTO `balance_libro_details` VALUES (1590,7968,505,40720,1518,2,96,2,652.90,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1591,7968,505,40720,1518,2,67,2,137.10,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1592,7968,505,40720,1518,2,13,1,790.00,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1593,7968,506,40720,1518,2,96,2,1074.38,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1594,7968,506,40720,1518,2,67,2,225.62,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1595,7968,506,40720,1518,2,13,1,1300.00,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1596,7968,507,40720,1518,2,96,2,1909.10,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1597,7968,507,40720,1518,2,67,2,400.90,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1598,7968,507,40720,1518,2,13,1,2310.00,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1599,7968,508,40720,1518,2,96,2,2677.69,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1600,7968,508,40720,1518,2,67,2,562.31,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1601,7968,508,40720,1518,2,13,1,3240.00,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1602,7968,509,40720,1518,2,96,2,768.60,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1603,7968,509,40720,1518,2,67,2,161.40,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1604,7968,509,40720,1518,2,13,1,930.00,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1605,7968,510,40720,1518,2,96,2,1818.18,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1606,7968,510,40720,1518,2,67,2,381.82,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1607,7968,510,40720,1518,2,13,1,2200.00,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1608,7968,511,40720,1518,2,96,2,5033.05,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1609,7968,511,40720,1518,2,67,2,1056.95,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1610,7968,511,40720,1518,2,13,1,6090.00,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1611,7968,512,40720,1518,2,96,2,909.09,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1612,7968,512,40720,1518,2,67,2,190.91,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1613,7968,512,40720,1518,2,13,1,1100.00,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1614,7968,513,40720,1518,2,96,2,4190.08,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1615,7968,513,40720,1518,2,67,2,879.92,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1616,7968,513,40720,1518,2,13,1,5070.00,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1617,7968,514,40720,1518,2,96,2,561.98,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1618,7968,514,40720,1518,2,67,2,118.02,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1619,7968,514,40720,1518,2,13,1,680.00,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1620,7968,515,40720,1518,2,96,2,1528.92,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1621,7968,515,40720,1518,2,67,2,321.08,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1622,7968,515,40720,1518,2,13,1,1850.00,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1623,7968,516,40720,1518,2,96,2,1239.67,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1624,7968,516,40720,1518,2,67,2,260.33,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1625,7968,516,40720,1518,2,13,1,1500.00,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1626,7968,517,40720,1518,2,96,2,1652.90,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1627,7968,517,40720,1518,2,67,2,347.10,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1628,7968,517,40720,1518,2,13,1,2000.00,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1629,7968,518,40720,1518,2,96,2,909.09,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1630,7968,518,40720,1518,2,67,2,190.91,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL);
INSERT INTO `balance_libro_details` VALUES (1631,7968,518,40720,1518,2,13,1,1100.00,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1632,7968,519,40720,1518,2,96,2,1818.18,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1633,7968,519,40720,1518,2,67,2,381.82,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1634,7968,519,40720,1518,2,13,1,2200.00,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1635,7968,520,40720,1518,2,96,2,1975.21,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1636,7968,520,40720,1518,2,67,2,414.79,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1637,7968,520,40720,1518,2,13,1,2390.00,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1638,7968,521,40720,1518,2,96,2,661.16,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1639,7968,521,40720,1518,2,67,2,138.84,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1640,7968,521,40720,1518,2,13,1,800.00,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1641,7968,522,40720,1518,2,96,2,1537.19,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1642,7968,522,40720,1518,2,67,2,322.81,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1643,7968,522,40720,1518,2,13,1,1860.00,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(1644,7968,523,40720,1518,2,96,2,2454.55,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1645,7968,523,40720,1518,2,67,2,515.45,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1646,7968,523,40720,1518,2,13,1,2970.00,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1647,7968,524,40720,1518,2,96,2,520.66,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1648,7968,524,40720,1518,2,67,2,109.34,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1649,7968,524,40720,1518,2,13,1,630.00,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1650,7968,525,40720,1518,2,96,2,2000.00,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1651,7968,525,40720,1518,2,67,2,420.00,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1652,7968,525,40720,1518,2,13,1,2420.00,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1653,7968,526,40720,1518,2,96,2,1991.74,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1654,7968,526,40720,1518,2,67,2,418.26,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1655,7968,526,40720,1518,2,13,1,2410.00,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1656,7968,527,40720,1518,2,96,2,1231.40,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1657,7968,527,40720,1518,2,67,2,258.60,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1658,7968,527,40720,1518,2,13,1,1490.00,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1659,7968,528,40720,1518,2,96,2,611.57,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1660,7968,528,40720,1518,2,67,2,128.43,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1661,7968,528,40720,1518,2,13,1,740.00,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1662,7968,529,40720,1518,2,96,2,785.13,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1663,7968,529,40720,1518,2,67,2,164.87,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1664,7968,529,40720,1518,2,13,1,950.00,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1665,7968,530,40720,1518,2,96,2,950.41,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1666,7968,530,40720,1518,2,67,2,199.59,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1667,7968,530,40720,1518,2,13,1,1150.00,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1668,7968,531,40720,1518,2,96,2,413.22,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1669,7968,531,40720,1518,2,67,2,86.78,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1670,7968,531,40720,1518,2,13,1,500.00,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1671,7968,532,40720,1518,2,96,2,1206.61,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1672,7968,532,40720,1518,2,67,2,253.39,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL);
INSERT INTO `balance_libro_details` VALUES (1673,7968,532,40720,1518,2,13,1,1460.00,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1674,7968,533,40720,1518,2,96,2,3719.01,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1675,7968,533,40720,1518,2,67,2,780.99,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1676,7968,533,40720,1518,2,13,1,4500.00,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1677,7968,534,40720,1518,2,96,2,2421.50,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1678,7968,534,40720,1518,2,67,2,508.50,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1679,7968,534,40720,1518,2,13,1,2930.00,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1680,7968,535,40720,1518,2,96,2,2512.40,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1681,7968,535,40720,1518,2,67,2,527.60,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1682,7968,535,40720,1518,2,13,1,3040.00,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1683,7968,536,40720,1518,2,96,2,834.71,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1684,7968,536,40720,1518,2,67,2,175.29,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1685,7968,536,40720,1518,2,13,1,1010.00,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1686,7968,537,40720,1518,2,96,2,710.74,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1687,7968,537,40720,1518,2,67,2,149.26,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1688,7968,537,40720,1518,2,13,1,860.00,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1689,7968,538,40720,1518,2,96,2,363.63,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1690,7968,538,40720,1518,2,67,2,76.37,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1691,7968,538,40720,1518,2,13,1,440.00,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1692,7968,539,40720,1518,2,96,2,561.98,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1693,7968,539,40720,1518,2,67,2,118.02,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1694,7968,539,40720,1518,2,13,1,680.00,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1695,7968,540,40720,1518,2,96,2,3198.35,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1696,7968,540,40720,1518,2,67,2,671.65,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1697,7968,540,40720,1518,2,13,1,3870.00,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1698,7968,541,40720,1518,2,96,2,983.47,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1699,7968,541,40720,1518,2,67,2,206.53,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1700,7968,541,40720,1518,2,13,1,1190.00,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1701,7968,542,40720,1518,2,96,2,272.73,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1702,7968,542,40720,1518,2,67,2,57.27,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1703,7968,542,40720,1518,2,13,1,330.00,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1704,7968,543,40720,1518,2,96,2,1975.21,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1705,7968,543,40720,1518,2,67,2,414.79,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1706,7968,543,40720,1518,2,13,1,2390.00,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1707,7968,544,40720,1518,2,96,2,776.86,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1708,7968,544,40720,1518,2,67,2,163.14,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1709,7968,544,40720,1518,2,13,1,940.00,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1710,7968,545,40720,1518,2,96,2,694.21,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1711,7968,545,40720,1518,2,67,2,145.79,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1712,7968,545,40720,1518,2,13,1,840.00,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1713,7968,546,40720,1518,2,96,2,859.51,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1714,7968,546,40720,1518,2,67,2,180.49,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL);
INSERT INTO `balance_libro_details` VALUES (1715,7968,546,40720,1518,2,13,1,1040.00,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1716,7968,547,40720,1518,2,96,2,1380.16,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1717,7968,547,40720,1518,2,67,2,289.84,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1718,7968,547,40720,1518,2,13,1,1670.00,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1719,7968,548,40720,1518,2,96,2,495.87,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1720,7968,548,40720,1518,2,67,2,104.13,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1721,7968,548,40720,1518,2,13,1,600.00,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1722,7968,549,40720,1518,2,96,2,1297.52,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1723,7968,549,40720,1518,2,67,2,272.48,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1724,7968,549,40720,1518,2,13,1,1570.00,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1725,7968,550,40720,1518,2,96,2,909.09,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1726,7968,550,40720,1518,2,67,2,190.91,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1727,7968,550,40720,1518,2,13,1,1100.00,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1728,7968,551,40720,1518,2,96,2,768.60,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1729,7968,551,40720,1518,2,67,2,161.40,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1730,7968,551,40720,1518,2,13,1,930.00,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(1731,7968,552,40720,3134,2,96,2,793.31,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1732,7968,552,40720,3134,2,67,2,166.60,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1733,7968,552,40720,3134,2,13,1,960.00,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1734,7968,552,40720,3134,2,136,2,0.09,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1735,7968,553,40720,3134,2,96,2,1297.52,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1736,7968,553,40720,3134,2,67,2,272.48,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1737,7968,553,40720,3134,2,13,1,1570.00,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1738,7968,554,40720,3134,2,96,2,1487.60,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1739,7968,554,40720,3134,2,67,2,312.40,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1740,7968,554,40720,3134,2,13,1,1800.00,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1741,7968,555,40720,3134,2,96,2,884.29,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1742,7968,555,40720,3134,2,67,2,185.71,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1743,7968,555,40720,3134,2,13,1,1070.00,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1744,7968,556,40720,3134,2,96,2,1016.53,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1745,7968,556,40720,3134,2,67,2,213.47,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1746,7968,556,40720,3134,2,13,1,1230.00,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1747,7968,557,40720,3134,2,96,2,1239.67,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1748,7968,557,40720,3134,2,67,2,260.33,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1749,7968,557,40720,3134,2,13,1,1500.00,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1750,7968,558,40720,3134,2,96,2,892.56,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1751,7968,558,40720,3134,2,67,2,187.44,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1752,7968,558,40720,3134,2,13,1,1080.00,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1753,7968,559,40720,3134,2,96,2,404.96,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1754,7968,559,40720,3134,2,67,2,85.04,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1755,7968,559,40720,3134,2,13,1,490.00,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1756,7968,560,40720,3134,2,96,2,1181.82,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL);
INSERT INTO `balance_libro_details` VALUES (1757,7968,560,40720,3134,2,67,2,248.18,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1758,7968,560,40720,3134,2,13,1,1430.00,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1759,7968,561,40720,3134,2,96,2,809.92,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1760,7968,561,40720,3134,2,67,2,170.08,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1761,7968,561,40720,3134,2,13,1,980.00,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1762,7968,562,40720,3134,2,96,2,1305.79,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1763,7968,562,40720,3134,2,67,2,274.21,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1764,7968,562,40720,3134,2,13,1,1580.00,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1765,7968,563,40720,3134,2,96,2,652.89,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1766,7968,563,40720,3134,2,67,2,137.11,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1767,7968,563,40720,3134,2,13,1,790.00,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1768,7968,564,40720,3134,2,96,2,1157.03,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1769,7968,564,40720,3134,2,67,2,242.97,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1770,7968,564,40720,3134,2,13,1,1400.00,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1771,7968,565,40720,3134,2,96,2,752.07,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1772,7968,565,40720,3134,2,67,2,157.93,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1773,7968,565,40720,3134,2,13,1,910.00,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1774,7968,566,40720,3134,2,96,2,2495.87,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1775,7968,566,40720,3134,2,67,2,524.13,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1776,7968,566,40720,3134,2,13,1,3020.00,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1777,7968,567,40720,3134,2,96,2,2785.12,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1778,7968,567,40720,3134,2,67,2,584.88,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1779,7968,567,40720,3134,2,13,1,3370.00,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1780,7968,568,40720,3134,2,96,2,2082.65,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1781,7968,568,40720,3134,2,67,2,437.35,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1782,7968,568,40720,3134,2,13,1,2520.00,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1783,7968,569,40720,3134,2,96,2,1537.19,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1784,7968,569,40720,3134,2,67,2,322.81,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1785,7968,569,40720,3134,2,13,1,1860.00,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1786,7968,570,40720,3134,2,96,2,1024.80,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1787,7968,570,40720,3134,2,67,2,215.20,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1788,7968,570,40720,3134,2,13,1,1240.00,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1789,7968,571,40720,3134,2,96,2,1033.06,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1790,7968,571,40720,3134,2,67,2,216.94,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1791,7968,571,40720,3134,2,13,1,1250.00,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1792,7968,572,40720,3134,2,96,2,2363.64,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1793,7968,572,40720,3134,2,67,2,496.36,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1794,7968,572,40720,3134,2,13,1,2860.00,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1795,7968,573,40720,3134,2,96,2,2785.13,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1796,7968,573,40720,3134,2,67,2,584.87,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1797,7968,573,40720,3134,2,13,1,3370.00,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL);
INSERT INTO `balance_libro_details` VALUES (1798,7968,574,40720,3134,2,96,2,3247.92,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1799,7968,574,40720,3134,2,67,2,682.08,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1800,7968,574,40720,3134,2,13,1,3930.00,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1801,7968,575,40720,3134,2,96,2,2049.59,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1802,7968,575,40720,3134,2,67,2,430.41,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1803,7968,575,40720,3134,2,13,1,2480.00,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1804,7968,576,40720,3134,2,96,2,793.39,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1805,7968,576,40720,3134,2,67,2,166.61,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1806,7968,576,40720,3134,2,13,1,960.00,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(1807,7968,577,40720,3134,2,96,2,1140.49,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1808,7968,577,40720,3134,2,67,2,239.51,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1809,7968,577,40720,3134,2,13,1,1380.00,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1810,7968,578,40720,3134,2,96,2,768.59,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1811,7968,578,40720,3134,2,67,2,161.41,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1812,7968,578,40720,3134,2,13,1,930.00,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1813,7968,579,40720,3134,2,96,2,421.49,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1814,7968,579,40720,3134,2,67,2,88.51,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1815,7968,579,40720,3134,2,13,1,510.00,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1816,7968,580,40720,3134,2,96,2,1190.09,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1817,7968,580,40720,3134,2,67,2,249.91,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1818,7968,580,40720,3134,2,13,1,1440.00,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1819,7968,581,40720,3134,2,96,2,1181.82,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1820,7968,581,40720,3134,2,67,2,248.18,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1821,7968,581,40720,3134,2,13,1,1430.00,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1822,7968,582,40720,3134,2,96,2,404.96,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1823,7968,582,40720,3134,2,67,2,85.04,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1824,7968,582,40720,3134,2,13,1,490.00,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1825,7968,583,40720,3134,2,96,2,809.92,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1826,7968,583,40720,3134,2,67,2,170.08,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1827,7968,583,40720,3134,2,13,1,980.00,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1828,7968,584,40720,3134,2,96,2,1677.69,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1829,7968,584,40720,3134,2,67,2,352.31,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1830,7968,584,40720,3134,2,13,1,2030.00,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1831,7968,585,40720,3134,2,96,2,619.83,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1832,7968,585,40720,3134,2,67,2,130.17,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1833,7968,585,40720,3134,2,13,1,750.00,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1834,7968,586,40720,3134,2,96,2,363.64,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1835,7968,586,40720,3134,2,67,2,76.36,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1836,7968,586,40720,3134,2,13,1,440.00,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1837,7968,587,40720,3134,2,96,2,1107.44,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1838,7968,587,40720,3134,2,67,2,232.56,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1839,7968,587,40720,3134,2,13,1,1340.00,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL);
INSERT INTO `balance_libro_details` VALUES (1840,7968,588,40720,3134,2,96,2,611.57,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1841,7968,588,40720,3134,2,67,2,128.43,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1842,7968,588,40720,3134,2,13,1,740.00,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1843,7968,589,40720,3134,2,96,2,1115.70,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1844,7968,589,40720,3134,2,67,2,234.30,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1845,7968,589,40720,3134,2,13,1,1350.00,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1846,7968,590,40720,3134,2,96,2,1140.49,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1847,7968,590,40720,3134,2,67,2,239.51,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1848,7968,590,40720,3134,2,13,1,1380.00,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1849,7968,591,40720,3134,2,96,2,909.09,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1850,7968,591,40720,3134,2,67,2,190.91,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1851,7968,591,40720,3134,2,13,1,1100.00,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1852,7968,592,40720,3134,2,96,2,1322.31,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1853,7968,592,40720,3134,2,67,2,277.69,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1854,7968,592,40720,3134,2,13,1,1600.00,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1855,7968,593,40720,3134,2,96,2,909.09,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1856,7968,593,40720,3134,2,67,2,190.91,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1857,7968,593,40720,3134,2,13,1,1100.00,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1858,7968,594,40720,3134,2,96,2,809.92,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1859,7968,594,40720,3134,2,67,2,170.08,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1860,7968,594,40720,3134,2,13,1,980.00,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1861,7968,595,40720,3134,2,96,2,1057.85,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1862,7968,595,40720,3134,2,67,2,222.15,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1863,7968,595,40720,3134,2,13,1,1280.00,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1864,7968,596,40720,3134,2,96,2,1107.44,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1865,7968,596,40720,3134,2,67,2,232.56,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1866,7968,596,40720,3134,2,13,1,1340.00,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1867,7968,597,40720,3134,2,96,2,1231.41,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1868,7968,597,40720,3134,2,67,2,258.59,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1869,7968,597,40720,3134,2,13,1,1490.00,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1870,7968,598,40720,3134,2,96,2,760.33,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1871,7968,598,40720,3134,2,67,2,159.67,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1872,7968,598,40720,3134,2,13,1,920.00,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1873,7968,599,40720,3134,2,96,2,1735.54,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1874,7968,599,40720,3134,2,67,2,364.46,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1875,7968,599,40720,3134,2,13,1,2100.00,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(1876,7968,600,40720,3134,2,96,2,471.08,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1877,7968,600,40720,3134,2,67,2,98.92,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1878,7968,600,40720,3134,2,13,1,570.00,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1879,7968,601,40720,3134,2,96,2,1628.10,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1880,7968,601,40720,3134,2,67,2,341.90,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL);
INSERT INTO `balance_libro_details` VALUES (1881,7968,601,40720,3134,2,13,1,1970.00,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1882,7968,602,40720,3134,2,96,2,561.98,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1883,7968,602,40720,3134,2,67,2,118.02,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1884,7968,602,40720,3134,2,13,1,680.00,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1885,7968,603,40720,3134,2,96,2,1570.25,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1886,7968,603,40720,3134,2,67,2,329.75,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1887,7968,603,40720,3134,2,13,1,1900.00,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1888,7968,604,40720,3134,2,96,2,611.57,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1889,7968,604,40720,3134,2,67,2,128.43,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1890,7968,604,40720,3134,2,13,1,740.00,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1891,7968,605,40720,3134,2,96,2,1396.70,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1892,7968,605,40720,3134,2,67,2,293.30,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1893,7968,605,40720,3134,2,13,1,1690.00,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1894,7968,606,40720,3134,2,96,2,801.65,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1895,7968,606,40720,3134,2,67,2,168.35,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1896,7968,606,40720,3134,2,13,1,970.00,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1897,7968,607,40720,3134,2,96,2,2446.28,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1898,7968,607,40720,3134,2,67,2,513.72,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1899,7968,607,40720,3134,2,13,1,2960.00,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1900,7968,608,40720,3134,2,96,2,446.28,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1901,7968,608,40720,3134,2,67,2,93.72,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1902,7968,608,40720,3134,2,13,1,540.00,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1903,7968,609,40720,3134,2,96,2,578.51,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1904,7968,609,40720,3134,2,67,2,121.49,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1905,7968,609,40720,3134,2,13,1,700.00,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1906,7968,610,40720,3134,2,96,2,983.47,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1907,7968,610,40720,3134,2,67,2,206.53,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1908,7968,610,40720,3134,2,13,1,1190.00,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1909,7968,611,40720,3134,2,96,2,2520.66,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1910,7968,611,40720,3134,2,67,2,529.34,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1911,7968,611,40720,3134,2,13,1,3050.00,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1912,7968,612,40720,3134,2,96,2,2363.64,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1913,7968,612,40720,3134,2,67,2,496.36,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1914,7968,612,40720,3134,2,13,1,2860.00,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1915,7968,613,40720,3134,2,96,2,2066.11,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1916,7968,613,40720,3134,2,67,2,433.89,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1917,7968,613,40720,3134,2,13,1,2500.00,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1918,7968,614,40720,3134,2,96,2,809.92,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1919,7968,614,40720,3134,2,67,2,170.08,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1920,7968,614,40720,3134,2,13,1,980.00,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1921,7968,615,40720,3134,2,96,2,1520.66,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1922,7968,615,40720,3134,2,67,2,319.34,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL);
INSERT INTO `balance_libro_details` VALUES (1923,7968,615,40720,3134,2,13,1,1840.00,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1924,7968,616,40720,3134,2,96,2,743.80,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1925,7968,616,40720,3134,2,67,2,156.20,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1926,7968,616,40720,3134,2,13,1,900.00,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1927,7968,617,40720,3134,2,96,2,462.81,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1928,7968,617,40720,3134,2,67,2,97.19,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1929,7968,617,40720,3134,2,13,1,560.00,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1930,7968,618,40720,3134,2,96,2,1074.38,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1931,7968,618,40720,3134,2,67,2,225.62,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1932,7968,618,40720,3134,2,13,1,1300.00,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(1933,7968,619,40720,3134,2,96,2,537.19,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1934,7968,619,40720,3134,2,67,2,112.81,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1935,7968,619,40720,3134,2,13,1,650.00,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1936,7968,620,40720,3134,2,96,2,1305.79,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1937,7968,620,40720,3134,2,67,2,274.21,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1938,7968,620,40720,3134,2,13,1,1580.00,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1939,7968,621,40720,3134,2,96,2,809.92,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1940,7968,621,40720,3134,2,67,2,170.08,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1941,7968,621,40720,3134,2,13,1,980.00,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1942,7968,622,40720,3134,2,96,2,966.95,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1943,7968,622,40720,3134,2,67,2,203.05,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1944,7968,622,40720,3134,2,13,1,1170.00,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1945,7968,623,40720,3134,2,96,2,652.89,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1946,7968,623,40720,3134,2,67,2,137.11,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1947,7968,623,40720,3134,2,13,1,790.00,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1948,7968,624,40720,3134,2,96,2,1115.70,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1949,7968,624,40720,3134,2,67,2,234.30,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1950,7968,624,40720,3134,2,13,1,1350.00,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1951,7968,625,40720,3134,2,96,2,909.09,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1952,7968,625,40720,3134,2,67,2,190.91,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1953,7968,625,40720,3134,2,13,1,1100.00,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1954,7968,626,40720,3134,2,96,2,2396.69,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1955,7968,626,40720,3134,2,67,2,503.31,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1956,7968,626,40720,3134,2,13,1,2900.00,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1957,7968,627,40720,3134,2,96,2,289.26,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1958,7968,627,40720,3134,2,67,2,60.74,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1959,7968,627,40720,3134,2,13,1,350.00,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1960,7968,628,40720,3134,2,96,2,289.26,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1961,7968,628,40720,3134,2,67,2,60.74,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1962,7968,628,40720,3134,2,13,1,350.00,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1963,7968,629,40720,3134,2,96,2,2752.06,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1964,7968,629,40720,3134,2,67,2,577.94,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL);
INSERT INTO `balance_libro_details` VALUES (1965,7968,629,40720,3134,2,13,1,3330.00,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1966,7968,630,40720,3134,2,96,2,900.82,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1967,7968,630,40720,3134,2,67,2,189.18,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1968,7968,630,40720,3134,2,13,1,1090.00,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1969,7968,631,40720,3134,2,96,2,1619.83,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1970,7968,631,40720,3134,2,67,2,340.17,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1971,7968,631,40720,3134,2,13,1,1960.00,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1972,7968,632,40720,3134,2,96,2,1595.04,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1973,7968,632,40720,3134,2,67,2,334.96,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1974,7968,632,40720,3134,2,13,1,1930.00,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1975,7968,633,40720,3134,2,96,2,2685.94,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1976,7968,633,40720,3134,2,67,2,564.06,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1977,7968,633,40720,3134,2,13,1,3250.00,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1978,7968,634,40720,3134,2,96,2,1338.84,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1979,7968,634,40720,3134,2,67,2,281.16,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1980,7968,634,40720,3134,2,13,1,1620.00,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1981,7968,635,40720,3134,2,96,2,2900.83,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1982,7968,635,40720,3134,2,67,2,609.17,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1983,7968,635,40720,3134,2,13,1,3510.00,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1984,7968,636,40720,3134,2,96,2,2917.35,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1985,7968,636,40720,3134,2,67,2,612.65,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1986,7968,636,40720,3134,2,13,1,3530.00,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1987,7968,637,40720,3134,2,96,2,2933.88,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1988,7968,637,40720,3134,2,67,2,616.12,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1989,7968,637,40720,3134,2,13,1,3550.00,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1990,7968,638,40720,3134,2,96,2,1545.45,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1991,7968,638,40720,3134,2,67,2,324.55,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1992,7968,638,40720,3134,2,13,1,1870.00,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1993,7968,639,40720,3134,2,96,2,380.16,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1994,7968,639,40720,3134,2,67,2,79.84,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1995,7968,639,40720,3134,2,13,1,460.00,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1996,7968,640,40720,3134,2,96,2,652.89,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1997,7968,640,40720,3134,2,67,2,137.11,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1998,7968,640,40720,3134,2,13,1,790.00,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(1999,7968,641,40720,3134,2,96,2,297.52,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(2000,7968,641,40720,3134,2,67,2,62.48,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(2001,7968,641,40720,3134,2,13,1,360.00,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(2002,7968,642,40720,3134,2,96,2,256.20,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(2003,7968,642,40720,3134,2,67,2,53.80,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(2004,7968,642,40720,3134,2,13,1,310.00,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(2005,7968,643,40720,3134,2,96,2,1190.08,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(2006,7968,643,40720,3134,2,67,2,249.92,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL);
INSERT INTO `balance_libro_details` VALUES (2007,7968,643,40720,3134,2,13,1,1440.00,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(2008,7968,644,40720,3134,2,96,2,1603.31,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(2009,7968,644,40720,3134,2,67,2,336.69,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(2010,7968,644,40720,3134,2,13,1,1940.00,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(2011,7968,645,40720,3134,2,96,2,1190.09,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(2012,7968,645,40720,3134,2,67,2,249.91,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(2013,7968,645,40720,3134,2,13,1,1440.00,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(2014,7968,646,40720,3134,2,96,2,1181.82,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(2015,7968,646,40720,3134,2,67,2,248.18,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(2016,7968,646,40720,3134,2,13,1,1430.00,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(2017,7968,647,40720,3134,2,96,2,1132.23,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(2018,7968,647,40720,3134,2,67,2,237.77,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(2019,7968,647,40720,3134,2,13,1,1370.00,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(2020,7968,648,40720,3134,2,96,2,2371.90,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(2021,7968,648,40720,3134,2,67,2,498.10,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2022,7968,648,40720,3134,2,13,1,2870.00,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2023,7968,649,40720,3134,2,96,2,1652.89,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2024,7968,649,40720,3134,2,67,2,347.11,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2025,7968,649,40720,3134,2,13,1,2000.00,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2026,7968,650,40720,3134,2,96,2,892.56,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2027,7968,650,40720,3134,2,67,2,187.44,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2028,7968,650,40720,3134,2,13,1,1080.00,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2029,7968,651,40720,3134,2,96,2,776.86,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2030,7968,651,40720,3134,2,67,2,163.14,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2031,7968,651,40720,3134,2,13,1,940.00,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2032,7968,652,40720,3134,2,96,2,512.39,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2033,7968,652,40720,3134,2,67,2,107.61,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2034,7968,652,40720,3134,2,13,1,620.00,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2035,7968,653,40720,3134,2,96,2,1619.84,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2036,7968,653,40720,3134,2,67,2,340.16,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2037,7968,653,40720,3134,2,13,1,1960.00,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2038,7968,654,40720,3134,2,96,2,909.09,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2039,7968,654,40720,3134,2,67,2,190.91,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2040,7968,654,40720,3134,2,13,1,1100.00,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2041,7968,655,40720,3134,2,96,2,1677.68,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2042,7968,655,40720,3134,2,67,2,352.32,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2043,7968,655,40720,3134,2,13,1,2030.00,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2044,7968,656,40720,3134,2,96,2,652.89,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2045,7968,656,40720,3134,2,67,2,137.11,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2046,7968,656,40720,3134,2,13,1,790.00,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2047,7968,657,40720,3134,2,96,2,669.42,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL);
INSERT INTO `balance_libro_details` VALUES (2048,7968,657,40720,3134,2,67,2,140.58,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2049,7968,657,40720,3134,2,13,1,810.00,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2050,7968,658,40720,3134,2,96,2,2123.97,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2051,7968,658,40720,3134,2,67,2,446.03,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2052,7968,658,40720,3134,2,13,1,2570.00,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2053,7968,659,40720,3134,2,96,2,347.11,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2054,7968,659,40720,3134,2,67,2,72.89,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2055,7968,659,40720,3134,2,13,1,420.00,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2056,7968,660,40720,3134,2,96,2,1231.40,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2057,7968,660,40720,3134,2,67,2,258.60,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2058,7968,660,40720,3134,2,13,1,1490.00,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2059,7968,661,40720,3134,2,96,2,809.92,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2060,7968,661,40720,3134,2,67,2,170.08,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2061,7968,661,40720,3134,2,13,1,980.00,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2062,7968,662,40720,3134,2,96,2,2834.72,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2063,7968,662,40720,3134,2,67,2,595.28,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2064,7968,662,40720,3134,2,13,1,3430.00,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2065,7968,663,40720,3134,2,96,2,1305.79,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2066,7968,663,40720,3134,2,67,2,274.21,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2067,7968,663,40720,3134,2,13,1,1580.00,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2068,7968,664,40720,3134,2,96,2,991.74,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2069,7968,664,40720,3134,2,67,2,208.26,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2070,7968,664,40720,3134,2,13,1,1200.00,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2071,7968,665,40720,3134,2,96,2,867.77,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2072,7968,665,40720,3134,2,67,2,182.23,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2073,7968,665,40720,3134,2,13,1,1050.00,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2074,7968,666,40720,3134,2,96,2,2123.97,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2075,7968,666,40720,3134,2,67,2,446.03,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2076,7968,666,40720,3134,2,13,1,2570.00,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2077,7968,667,40720,3134,2,96,2,330.58,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2078,7968,667,40720,3134,2,67,2,69.42,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2079,7968,667,40720,3134,2,13,1,400.00,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2080,7968,668,40720,3134,2,96,2,1057.85,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2081,7968,668,40720,3134,2,67,2,222.15,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2082,7968,668,40720,3134,2,13,1,1280.00,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2083,7968,669,40720,3134,2,96,2,677.68,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2084,7968,669,40720,3134,2,67,2,142.32,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2085,7968,669,40720,3134,2,13,1,820.00,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2086,7968,670,40720,3134,2,96,2,1983.47,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2087,7968,670,40720,3134,2,67,2,416.53,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2088,7968,670,40720,3134,2,13,1,2400.00,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2089,7968,671,40720,3134,2,96,2,735.54,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL);
INSERT INTO `balance_libro_details` VALUES (2090,7968,671,40720,3134,2,67,2,154.46,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2091,7968,671,40720,3134,2,13,1,890.00,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2092,7968,672,40720,3134,2,96,2,537.19,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2093,7968,672,40720,3134,2,67,2,112.81,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2094,7968,672,40720,3134,2,13,1,650.00,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2095,7968,673,40720,3134,2,96,2,388.43,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2096,7968,673,40720,3134,2,67,2,81.57,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2097,7968,673,40720,3134,2,13,1,470.00,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2098,7968,674,40720,3134,2,96,2,462.81,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2099,7968,674,40720,3134,2,67,2,97.19,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2100,7968,674,40720,3134,2,13,1,560.00,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2101,7968,675,40720,3134,2,96,2,1008.26,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2102,7968,675,40720,3134,2,67,2,211.74,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2103,7968,675,40720,3134,2,13,1,1220.00,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(2104,7968,676,40720,3134,2,96,2,809.92,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2105,7968,676,40720,3134,2,67,2,170.08,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2106,7968,676,40720,3134,2,13,1,980.00,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2107,7968,677,40720,3134,2,96,2,809.92,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2108,7968,677,40720,3134,2,67,2,170.08,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2109,7968,677,40720,3134,2,13,1,980.00,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2110,7968,678,40720,3134,2,96,2,1082.64,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2111,7968,678,40720,3134,2,67,2,227.36,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2112,7968,678,40720,3134,2,13,1,1310.00,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2113,7968,679,40720,3134,2,96,2,1603.31,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2114,7968,679,40720,3134,2,67,2,336.69,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2115,7968,679,40720,3134,2,13,1,1940.00,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2116,7968,680,40720,3134,2,96,2,1619.83,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2117,7968,680,40720,3134,2,67,2,340.17,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2118,7968,680,40720,3134,2,13,1,1960.00,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2119,7968,681,40720,3134,2,96,2,1181.82,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2120,7968,681,40720,3134,2,67,2,248.18,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2121,7968,681,40720,3134,2,13,1,1430.00,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2122,7968,682,40720,3134,2,96,2,1619.83,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2123,7968,682,40720,3134,2,67,2,340.17,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2124,7968,682,40720,3134,2,13,1,1960.00,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2125,7968,683,40720,3134,2,96,2,2429.75,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2126,7968,683,40720,3134,2,67,2,510.25,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2127,7968,683,40720,3134,2,13,1,2940.00,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2128,7968,684,40720,3134,2,96,2,900.82,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2129,7968,684,40720,3134,2,67,2,189.18,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2130,7968,684,40720,3134,2,13,1,1090.00,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2131,7968,685,40720,3134,2,96,2,1190.08,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL);
INSERT INTO `balance_libro_details` VALUES (2132,7968,685,40720,3134,2,67,2,249.92,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2133,7968,685,40720,3134,2,13,1,1440.00,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2134,7968,686,40720,3134,2,96,2,1743.80,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2135,7968,686,40720,3134,2,67,2,366.20,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2136,7968,686,40720,3134,2,13,1,2110.00,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2137,7968,687,40720,3134,2,96,2,842.98,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2138,7968,687,40720,3134,2,67,2,177.02,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2139,7968,687,40720,3134,2,13,1,1020.00,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2140,7968,688,40720,3134,2,96,2,2107.43,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2141,7968,688,40720,3134,2,67,2,442.57,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2142,7968,688,40720,3134,2,13,1,2550.00,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2143,7968,689,40720,3134,2,96,2,2049.58,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2144,7968,689,40720,3134,2,67,2,430.42,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2145,7968,689,40720,3134,2,13,1,2480.00,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2146,7968,690,40720,3134,2,96,2,809.92,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2147,7968,690,40720,3134,2,67,2,170.08,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2148,7968,690,40720,3134,2,13,1,980.00,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2149,7968,691,40720,3134,2,96,2,1033.06,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2150,7968,691,40720,3134,2,67,2,216.94,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2151,7968,691,40720,3134,2,13,1,1250.00,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2152,7968,692,40720,3134,2,96,2,2917.35,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2153,7968,692,40720,3134,2,67,2,612.65,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2154,7968,692,40720,3134,2,13,1,3530.00,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2155,7968,693,40720,3134,2,96,2,1033.06,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2156,7968,693,40720,3134,2,67,2,216.94,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2157,7968,693,40720,3134,2,13,1,1250.00,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2158,7968,694,40720,3134,2,96,2,1256.20,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2159,7968,694,40720,3134,2,67,2,263.80,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2160,7968,694,40720,3134,2,13,1,1520.00,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2161,7968,695,40720,3134,2,96,2,1421.49,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2162,7968,695,40720,3134,2,67,2,298.51,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2163,7968,695,40720,3134,2,13,1,1720.00,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2164,7968,696,40720,3134,2,96,2,7570.25,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2165,7968,696,40720,3134,2,67,2,1589.75,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2166,7968,696,40720,3134,2,13,1,9160.00,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2167,7968,697,40720,3134,2,96,2,1033.06,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2168,7968,697,40720,3134,2,67,2,216.94,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2169,7968,697,40720,3134,2,13,1,1250.00,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2170,7968,698,40720,3134,2,96,2,1190.08,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2171,7968,698,40720,3134,2,67,2,249.92,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2172,7968,698,40720,3134,2,13,1,1440.00,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL);
INSERT INTO `balance_libro_details` VALUES (2173,7968,699,40720,3134,2,96,2,1115.70,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2174,7968,699,40720,3134,2,67,2,234.30,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2175,7968,699,40720,3134,2,13,1,1350.00,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(2176,7968,700,40720,3134,2,96,2,504.13,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2177,7968,700,40720,3134,2,67,2,105.87,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2178,7968,700,40720,3134,2,13,1,610.00,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2179,7968,701,40720,3134,2,96,2,983.47,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2180,7968,701,40720,3134,2,67,2,206.53,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2181,7968,701,40720,3134,2,13,1,1190.00,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2182,7968,702,40720,3134,2,96,2,909.09,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2183,7968,702,40720,3134,2,67,2,190.91,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2184,7968,702,40720,3134,2,13,1,1100.00,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2185,7968,703,40720,3134,2,96,2,1760.33,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2186,7968,703,40720,3134,2,67,2,369.67,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2187,7968,703,40720,3134,2,13,1,2130.00,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2188,7968,704,40720,3134,2,96,2,809.92,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2189,7968,704,40720,3134,2,67,2,170.08,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2190,7968,704,40720,3134,2,13,1,980.00,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2191,7968,705,40720,3134,2,96,2,809.92,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2192,7968,705,40720,3134,2,67,2,170.08,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2193,7968,705,40720,3134,2,13,1,980.00,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2194,7968,706,40720,3134,2,96,2,727.27,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2195,7968,706,40720,3134,2,67,2,152.73,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2196,7968,706,40720,3134,2,13,1,880.00,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2197,7968,707,40720,3134,2,96,2,876.03,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2198,7968,707,40720,3134,2,67,2,183.97,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2199,7968,707,40720,3134,2,13,1,1060.00,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2200,7968,708,40720,3134,2,96,2,677.69,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2201,7968,708,40720,3134,2,67,2,142.31,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2202,7968,708,40720,3134,2,13,1,820.00,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2203,7968,709,40720,3134,2,96,2,1074.38,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2204,7968,709,40720,3134,2,67,2,225.62,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2205,7968,709,40720,3134,2,13,1,1300.00,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2206,7968,710,40720,3134,2,96,2,380.16,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2207,7968,710,40720,3134,2,67,2,79.84,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2208,7968,710,40720,3134,2,13,1,460.00,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2209,7968,711,40720,3134,2,96,2,661.16,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2210,7968,711,40720,3134,2,67,2,138.84,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2211,7968,711,40720,3134,2,13,1,800.00,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2212,7968,712,40720,3134,2,96,2,2471.07,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2213,7968,712,40720,3134,2,67,2,518.93,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2214,7968,712,40720,3134,2,13,1,2990.00,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL);
INSERT INTO `balance_libro_details` VALUES (2215,7968,713,40720,3134,2,96,2,462.81,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2216,7968,713,40720,3134,2,67,2,97.19,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2217,7968,713,40720,3134,2,13,1,560.00,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2218,7968,714,40720,3134,2,96,2,1305.79,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2219,7968,714,40720,3134,2,67,2,274.21,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2220,7968,714,40720,3134,2,13,1,1580.00,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2221,7968,715,40720,3134,2,96,2,809.92,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2222,7968,715,40720,3134,2,67,2,170.08,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2223,7968,715,40720,3134,2,13,1,980.00,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2224,7968,716,40720,3134,2,96,2,1190.09,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2225,7968,716,40720,3134,2,67,2,249.91,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2226,7968,716,40720,3134,2,13,1,1440.00,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2227,7968,717,40720,3134,2,96,2,421.49,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2228,7968,717,40720,3134,2,67,2,88.51,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2229,7968,717,40720,3134,2,13,1,510.00,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2230,7968,718,40720,3134,2,96,2,595.04,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2231,7968,718,40720,3134,2,67,2,124.96,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2232,7968,718,40720,3134,2,13,1,720.00,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2233,7968,719,40720,3134,2,96,2,495.86,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2234,7968,719,40720,3134,2,67,2,104.14,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2235,7968,719,40720,3134,2,13,1,600.00,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2236,7968,720,40720,3134,2,96,2,595.04,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2237,7968,720,40720,3134,2,67,2,124.96,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2238,7968,720,40720,3134,2,13,1,720.00,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(2239,7968,721,40720,3134,2,96,2,462.81,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2240,7968,721,40720,3134,2,67,2,97.19,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2241,7968,721,40720,3134,2,13,1,560.00,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2242,7968,722,40720,3134,2,96,2,1107.44,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2243,7968,722,40720,3134,2,67,2,232.56,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2244,7968,722,40720,3134,2,13,1,1340.00,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2245,7968,723,40720,3134,2,96,2,809.92,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2246,7968,723,40720,3134,2,67,2,170.08,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2247,7968,723,40720,3134,2,13,1,980.00,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2248,7968,724,40720,3134,2,96,2,2471.07,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2249,7968,724,40720,3134,2,67,2,518.93,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2250,7968,724,40720,3134,2,13,1,2990.00,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2251,7968,725,40720,3134,2,96,2,462.81,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2252,7968,725,40720,3134,2,67,2,97.19,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2253,7968,725,40720,3134,2,13,1,560.00,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2254,7968,726,40720,3134,2,96,2,297.52,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2255,7968,726,40720,3134,2,67,2,62.48,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2256,7968,726,40720,3134,2,13,1,360.00,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL);
INSERT INTO `balance_libro_details` VALUES (2257,7968,727,40720,3134,2,96,2,826.44,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2258,7968,727,40720,3134,2,67,2,173.56,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2259,7968,727,40720,3134,2,13,1,1000.00,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2260,7968,728,40720,3134,2,96,2,1338.84,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2261,7968,728,40720,3134,2,67,2,281.16,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2262,7968,728,40720,3134,2,13,1,1620.00,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2263,7968,729,40720,3134,2,96,2,504.14,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2264,7968,729,40720,3134,2,67,2,105.86,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2265,7968,729,40720,3134,2,13,1,610.00,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2266,7968,730,40720,3134,2,96,2,1644.63,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2267,7968,730,40720,3134,2,67,2,345.37,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2268,7968,730,40720,3134,2,13,1,1990.00,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2269,7968,731,40720,3134,2,96,2,1305.79,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2270,7968,731,40720,3134,2,67,2,274.21,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2271,7968,731,40720,3134,2,13,1,1580.00,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2272,7968,732,40720,3134,2,96,2,809.92,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2273,7968,732,40720,3134,2,67,2,170.08,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2274,7968,732,40720,3134,2,13,1,980.00,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2275,7968,733,40720,3134,2,96,2,785.12,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2276,7968,733,40720,3134,2,67,2,164.88,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2277,7968,733,40720,3134,2,13,1,950.00,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2278,7968,734,40720,3134,2,96,2,2644.62,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2279,7968,734,40720,3134,2,67,2,555.38,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2280,7968,734,40720,3134,2,13,1,3200.00,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2281,7968,735,40720,3134,2,96,2,1190.08,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2282,7968,735,40720,3134,2,67,2,249.92,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2283,7968,735,40720,3134,2,13,1,1440.00,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2284,7968,736,40720,3134,2,96,2,595.04,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2285,7968,736,40720,3134,2,67,2,124.96,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2286,7968,736,40720,3134,2,13,1,720.00,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2287,7968,737,40720,3134,2,96,2,231.40,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2288,7968,737,40720,3134,2,67,2,48.60,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2289,7968,737,40720,3134,2,13,1,280.00,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2290,7968,738,40720,3134,2,96,2,462.81,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2291,7968,738,40720,3134,2,67,2,97.19,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2292,7968,738,40720,3134,2,13,1,560.00,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2293,7968,739,40720,3134,2,96,2,1413.22,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2294,7968,739,40720,3134,2,67,2,296.78,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2295,7968,739,40720,3134,2,13,1,1710.00,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2296,7968,740,40720,3134,2,96,2,404.96,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2297,7968,740,40720,3134,2,67,2,85.04,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2298,7968,740,40720,3134,2,13,1,490.00,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL);
INSERT INTO `balance_libro_details` VALUES (2299,7968,741,40720,3134,2,96,2,1619.83,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2300,7968,741,40720,3134,2,67,2,340.17,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2301,7968,741,40720,3134,2,13,1,1960.00,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2302,7968,742,40720,3134,2,96,2,867.77,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2303,7968,742,40720,3134,2,67,2,182.23,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2304,7968,742,40720,3134,2,13,1,1050.00,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2305,7968,743,40720,3134,2,96,2,991.74,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2306,7968,743,40720,3134,2,67,2,208.26,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2307,7968,743,40720,3134,2,13,1,1200.00,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2308,7968,744,40720,3134,2,96,2,809.92,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2309,7968,744,40720,3134,2,67,2,170.08,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2310,7968,744,40720,3134,2,13,1,980.00,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2311,7968,745,40720,3134,2,96,2,1603.31,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2312,7968,745,40720,3134,2,67,2,336.69,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2313,7968,745,40720,3134,2,13,1,1940.00,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2314,7968,746,40720,3134,2,96,2,1719.01,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2315,7968,746,40720,3134,2,67,2,360.99,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2316,7968,746,40720,3134,2,13,1,2080.00,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2317,7968,747,40720,3134,2,96,2,809.92,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2318,7968,747,40720,3134,2,67,2,170.08,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2319,7968,747,40720,3134,2,13,1,980.00,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2320,7968,748,40720,3134,2,96,2,421.49,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2321,7968,748,40720,3134,2,67,2,88.51,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2322,7968,748,40720,3134,2,13,1,510.00,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(2323,7968,749,40720,3134,2,96,2,1537.19,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2324,7968,749,40720,3134,2,67,2,322.81,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2325,7968,749,40720,3134,2,13,1,1860.00,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2326,7968,750,40720,3134,2,96,2,1115.70,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2327,7968,750,40720,3134,2,67,2,234.30,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2328,7968,750,40720,3134,2,13,1,1350.00,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2329,7968,751,40720,3134,2,96,2,2867.77,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2330,7968,751,40720,3134,2,67,2,602.23,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2331,7968,751,40720,3134,2,13,1,3470.00,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2332,7968,752,40720,3134,2,96,2,4867.78,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2333,7968,752,40720,3134,2,67,2,1022.22,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2334,7968,752,40720,3134,2,13,1,5890.00,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2335,7968,753,40720,3134,2,96,2,1917.35,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2336,7968,753,40720,3134,2,67,2,402.65,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2337,7968,753,40720,3134,2,13,1,2320.00,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2338,7968,754,40720,3134,2,96,2,1900.83,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2339,7968,754,40720,3134,2,67,2,399.17,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL);
INSERT INTO `balance_libro_details` VALUES (2340,7968,754,40720,3134,2,13,1,2300.00,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2341,7968,755,40720,3134,2,96,2,1851.23,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2342,7968,755,40720,3134,2,67,2,388.77,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2343,7968,755,40720,3134,2,13,1,2240.00,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2344,7968,756,40720,3134,2,96,2,859.51,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2345,7968,756,40720,3134,2,67,2,180.49,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2346,7968,756,40720,3134,2,13,1,1040.00,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2347,7968,757,40720,3134,2,96,2,1115.70,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2348,7968,757,40720,3134,2,67,2,234.30,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2349,7968,757,40720,3134,2,13,1,1350.00,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2350,7968,758,40720,3134,2,96,2,603.30,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2351,7968,758,40720,3134,2,67,2,126.70,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2352,7968,758,40720,3134,2,13,1,730.00,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2353,7968,759,40720,3134,2,96,2,404.96,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2354,7968,759,40720,3134,2,67,2,85.04,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2355,7968,759,40720,3134,2,13,1,490.00,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2356,7968,760,40720,3134,2,96,2,801.65,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2357,7968,760,40720,3134,2,67,2,168.35,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2358,7968,760,40720,3134,2,13,1,970.00,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2359,7968,761,40720,3134,2,96,2,2264.46,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2360,7968,761,40720,3134,2,67,2,475.54,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2361,7968,761,40720,3134,2,13,1,2740.00,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2362,7968,762,40720,3134,2,96,2,1206.61,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2363,7968,762,40720,3134,2,67,2,253.39,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2364,7968,762,40720,3134,2,13,1,1460.00,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2365,7968,763,40720,3134,2,96,2,809.92,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2366,7968,763,40720,3134,2,67,2,170.08,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2367,7968,763,40720,3134,2,13,1,980.00,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2368,7968,764,40720,3134,2,96,2,909.09,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2369,7968,764,40720,3134,2,67,2,190.91,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2370,7968,764,40720,3134,2,13,1,1100.00,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2371,7968,765,40720,3134,2,96,2,148.76,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2372,7968,765,40720,3134,2,67,2,31.24,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2373,7968,765,40720,3134,2,13,1,180.00,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2374,7968,766,40720,3134,2,96,2,603.31,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2375,7968,766,40720,3134,2,67,2,126.69,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2376,7968,766,40720,3134,2,13,1,730.00,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2377,7968,767,40720,3134,2,96,2,1363.63,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2378,7968,767,40720,3134,2,67,2,286.37,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2379,7968,767,40720,3134,2,13,1,1650.00,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2380,7968,768,40720,3134,2,96,2,1272.73,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2381,7968,768,40720,3134,2,67,2,267.27,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL);
INSERT INTO `balance_libro_details` VALUES (2382,7968,768,40720,3134,2,13,1,1540.00,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2383,7968,769,40720,3134,2,96,2,1537.19,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2384,7968,769,40720,3134,2,67,2,322.81,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2385,7968,769,40720,3134,2,13,1,1860.00,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2386,7968,770,40720,3134,2,96,2,867.77,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2387,7968,770,40720,3134,2,67,2,182.23,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2388,7968,770,40720,3134,2,13,1,1050.00,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2389,7968,771,40720,3134,2,96,2,1305.79,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2390,7968,771,40720,3134,2,67,2,274.21,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2391,7968,771,40720,3134,2,13,1,1580.00,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2392,7968,772,40720,3134,2,96,2,619.83,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2393,7968,772,40720,3134,2,67,2,130.17,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2394,7968,772,40720,3134,2,13,1,750.00,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2395,7968,773,40720,3134,2,96,2,909.09,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2396,7968,773,40720,3134,2,67,2,190.91,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2397,7968,773,40720,3134,2,13,1,1100.00,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2398,7968,774,40720,3134,2,96,2,842.97,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2399,7968,774,40720,3134,2,67,2,177.03,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2400,7968,774,40720,3134,2,13,1,1020.00,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2401,7968,775,40720,3134,2,96,2,256.20,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2402,7968,775,40720,3134,2,67,2,53.80,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2403,7968,775,40720,3134,2,13,1,310.00,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2404,7968,776,40720,3134,2,96,2,231.40,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2405,7968,776,40720,3134,2,67,2,48.60,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2406,7968,776,40720,3134,2,13,1,280.00,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(2407,7968,777,40720,3134,2,96,2,363.64,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2408,7968,777,40720,3134,2,67,2,76.36,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2409,7968,777,40720,3134,2,13,1,440.00,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2410,7968,778,40720,3134,2,96,2,1074.38,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2411,7968,778,40720,3134,2,67,2,225.62,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2412,7968,778,40720,3134,2,13,1,1300.00,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2413,7968,779,40720,3134,2,96,2,214.88,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2414,7968,779,40720,3134,2,67,2,45.12,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2415,7968,779,40720,3134,2,13,1,260.00,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2416,7968,780,40720,3134,2,96,2,1082.64,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2417,7968,780,40720,3134,2,67,2,227.36,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2418,7968,780,40720,3134,2,13,1,1310.00,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2419,7968,781,40720,3134,2,96,2,1305.79,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2420,7968,781,40720,3134,2,67,2,274.21,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2421,7968,781,40720,3134,2,13,1,1580.00,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2422,7968,782,40720,3134,2,96,2,2206.61,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2423,7968,782,40720,3134,2,67,2,463.39,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL);
INSERT INTO `balance_libro_details` VALUES (2424,7968,782,40720,3134,2,13,1,2670.00,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2425,7968,783,40720,3134,2,96,2,1818.18,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2426,7968,783,40720,3134,2,67,2,381.82,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2427,7968,783,40720,3134,2,13,1,2200.00,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2428,7968,784,40720,3134,2,96,2,909.09,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2429,7968,784,40720,3134,2,67,2,190.91,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2430,7968,784,40720,3134,2,13,1,1100.00,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2431,7968,785,40720,3134,2,96,2,983.47,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2432,7968,785,40720,3134,2,67,2,206.53,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2433,7968,785,40720,3134,2,13,1,1190.00,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2434,7968,786,40720,3134,2,96,2,1115.70,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2435,7968,786,40720,3134,2,67,2,234.30,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2436,7968,786,40720,3134,2,13,1,1350.00,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2437,7968,787,40720,3134,2,96,2,537.19,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2438,7968,787,40720,3134,2,67,2,112.81,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2439,7968,787,40720,3134,2,13,1,650.00,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2440,7968,788,40720,3134,2,96,2,2404.96,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2441,7968,788,40720,3134,2,67,2,505.04,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2442,7968,788,40720,3134,2,13,1,2910.00,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2443,7968,789,40720,3134,2,96,2,1363.64,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2444,7968,789,40720,3134,2,67,2,286.36,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2445,7968,789,40720,3134,2,13,1,1650.00,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2446,7968,790,40720,3134,2,96,2,1884.30,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2447,7968,790,40720,3134,2,67,2,395.70,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2448,7968,790,40720,3134,2,13,1,2280.00,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2449,7968,791,40720,3134,2,96,2,1818.18,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2450,7968,791,40720,3134,2,67,2,381.82,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2451,7968,791,40720,3134,2,13,1,2200.00,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2452,7968,792,40720,3134,2,96,2,1016.53,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2453,7968,792,40720,3134,2,67,2,213.47,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2454,7968,792,40720,3134,2,13,1,1230.00,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2455,7968,793,40720,3134,2,96,2,1371.90,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2456,7968,793,40720,3134,2,67,2,288.10,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2457,7968,793,40720,3134,2,13,1,1660.00,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2458,7968,794,40720,3134,2,96,2,1818.18,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2459,7968,794,40720,3134,2,67,2,381.82,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2460,7968,794,40720,3134,2,13,1,2200.00,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2461,7968,795,40720,3134,2,96,2,768.60,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2462,7968,795,40720,3134,2,67,2,161.40,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2463,7968,795,40720,3134,2,13,1,930.00,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2464,7968,796,40720,3134,2,96,2,909.09,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL);
INSERT INTO `balance_libro_details` VALUES (2465,7968,796,40720,3134,2,67,2,190.91,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2466,7968,796,40720,3134,2,13,1,1100.00,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2467,7968,797,40720,3134,2,96,2,2123.97,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2468,7968,797,40720,3134,2,67,2,446.03,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2469,7968,797,40720,3134,2,13,1,2570.00,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2470,7968,798,40720,3134,2,96,2,909.09,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2471,7968,798,40720,3134,2,67,2,190.91,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2472,7968,798,40720,3134,2,13,1,1100.00,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(2473,7968,799,40720,3134,2,96,2,3917.36,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2474,7968,799,40720,3134,2,67,2,822.64,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2475,7968,799,40720,3134,2,13,1,4740.00,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2476,7968,800,40720,3134,2,96,2,983.47,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2477,7968,800,40720,3134,2,67,2,206.53,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2478,7968,800,40720,3134,2,13,1,1190.00,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2479,7968,801,40720,3134,2,96,2,495.87,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2480,7968,801,40720,3134,2,67,2,104.13,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2481,7968,801,40720,3134,2,13,1,600.00,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2482,7968,802,40720,3134,2,96,2,1363.63,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2483,7968,802,40720,3134,2,67,2,286.37,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2484,7968,802,40720,3134,2,13,1,1650.00,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2485,7968,803,40720,3134,2,96,2,1677.69,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2486,7968,803,40720,3134,2,67,2,352.31,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2487,7968,803,40720,3134,2,13,1,2030.00,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2488,7968,804,40720,3134,2,96,2,1611.57,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2489,7968,804,40720,3134,2,67,2,338.43,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2490,7968,804,40720,3134,2,13,1,1950.00,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2491,7968,805,40720,3134,2,96,2,1727.27,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2492,7968,805,40720,3134,2,67,2,362.73,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2493,7968,805,40720,3134,2,13,1,2090.00,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2494,7968,806,40720,3134,2,96,2,1818.18,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2495,7968,806,40720,3134,2,67,2,381.82,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2496,7968,806,40720,3134,2,13,1,2200.00,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2497,7968,807,40720,3134,2,96,2,2578.51,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2498,7968,807,40720,3134,2,67,2,541.49,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2499,7968,807,40720,3134,2,13,1,3120.00,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2500,7968,808,40720,3134,2,96,2,2305.78,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2501,7968,808,40720,3134,2,67,2,484.22,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2502,7968,808,40720,3134,2,13,1,2790.00,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2503,7968,809,40720,3134,2,96,2,2132.23,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2504,7968,809,40720,3134,2,67,2,447.77,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2505,7968,809,40720,3134,2,13,1,2580.00,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL);
INSERT INTO `balance_libro_details` VALUES (2506,7968,810,40720,3134,2,96,2,272.73,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2507,7968,810,40720,3134,2,67,2,57.27,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2508,7968,810,40720,3134,2,13,1,330.00,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2509,7968,811,40720,3134,2,96,2,876.04,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2510,7968,811,40720,3134,2,67,2,183.96,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2511,7968,811,40720,3134,2,13,1,1060.00,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2512,7968,812,40720,3134,2,96,2,1256.20,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2513,7968,812,40720,3134,2,67,2,263.80,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2514,7968,812,40720,3134,2,13,1,1520.00,NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(2515,7968,813,40720,3133,2,96,2,867.77,NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(2516,7968,813,40720,3133,2,67,2,182.23,NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(2517,7968,813,40720,3133,2,13,1,1050.00,NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(2518,7968,814,40720,3133,2,96,2,1305.79,NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(2519,7968,814,40720,3133,2,67,2,274.21,NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(2520,7968,814,40720,3133,2,13,1,1580.00,NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(2521,7968,815,40720,3133,2,96,2,1305.79,NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(2522,7968,815,40720,3133,2,67,2,274.21,NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(2523,7968,815,40720,3133,2,13,1,1580.00,NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(2524,7968,816,40720,3133,2,96,2,2652.89,NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(2525,7968,816,40720,3133,2,67,2,557.11,NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(2526,7968,816,40720,3133,2,13,1,3210.00,NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(2527,7968,817,40720,3133,2,96,2,1066.12,NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(2528,7968,817,40720,3133,2,67,2,223.88,NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(2529,7968,817,40720,3133,2,13,1,1290.00,NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(2530,7968,818,40720,3133,2,96,2,1942.15,NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(2531,7968,818,40720,3133,2,67,2,407.85,NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(2532,7968,818,40720,3133,2,13,1,2350.00,NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(2533,7968,819,40720,3133,2,96,2,776.86,NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(2534,7968,819,40720,3133,2,67,2,163.14,NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(2535,7968,819,40720,3133,2,13,1,940.00,NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(2536,7968,820,40720,3133,2,96,2,1702.48,NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(2537,7968,820,40720,3133,2,67,2,357.52,NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(2538,7968,820,40720,3133,2,13,1,2060.00,NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(2539,7968,821,40720,3133,2,96,2,264.47,NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(2540,7968,821,40720,3133,2,67,2,55.53,NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(2541,7968,821,40720,3133,2,13,1,320.00,NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(2542,7968,822,40720,3133,2,96,2,892.56,NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(2543,7968,822,40720,3133,2,67,2,187.44,NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(2544,7968,822,40720,3133,2,13,1,1080.00,NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(2545,7968,823,40720,3133,2,96,2,1115.70,NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(2546,7968,823,40720,3133,2,67,2,234.30,NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL);
INSERT INTO `balance_libro_details` VALUES (2547,7968,823,40720,3133,2,13,1,1350.00,NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(2548,7968,824,40720,3133,2,96,2,1644.63,NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(2549,7968,824,40720,3133,2,67,2,345.37,NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(2550,7968,824,40720,3133,2,13,1,1990.00,NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(2551,7968,825,40720,3133,2,96,2,909.09,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2552,7968,825,40720,3133,2,67,2,190.91,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2553,7968,825,40720,3133,2,13,1,1100.00,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2554,7968,826,40720,3133,2,96,2,2206.61,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2555,7968,826,40720,3133,2,67,2,463.39,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2556,7968,826,40720,3133,2,13,1,2670.00,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2557,7968,827,40720,3133,2,96,2,3099.17,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2558,7968,827,40720,3133,2,67,2,650.83,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2559,7968,827,40720,3133,2,13,1,3750.00,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2560,7968,828,40720,3133,2,96,2,2074.38,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2561,7968,828,40720,3133,2,67,2,435.62,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2562,7968,828,40720,3133,2,13,1,2510.00,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2563,7968,829,40720,3133,2,96,2,1074.38,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2564,7968,829,40720,3133,2,67,2,225.62,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2565,7968,829,40720,3133,2,13,1,1300.00,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2566,7968,830,40720,3133,2,96,2,1520.66,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2567,7968,830,40720,3133,2,67,2,319.34,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2568,7968,830,40720,3133,2,13,1,1840.00,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2569,7968,831,40720,3133,2,96,2,1388.43,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2570,7968,831,40720,3133,2,67,2,291.57,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2571,7968,831,40720,3133,2,13,1,1680.00,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2572,7968,832,40720,3133,2,96,2,2917.36,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2573,7968,832,40720,3133,2,67,2,612.64,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2574,7968,832,40720,3133,2,13,1,3530.00,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2575,7968,833,40720,3133,2,96,2,1347.10,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2576,7968,833,40720,3133,2,67,2,282.90,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2577,7968,833,40720,3133,2,13,1,1630.00,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2578,7968,834,40720,3133,2,96,2,867.77,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2579,7968,834,40720,3133,2,67,2,182.23,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2580,7968,834,40720,3133,2,13,1,1050.00,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2581,7968,835,40720,3133,2,96,2,471.08,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2582,7968,835,40720,3133,2,67,2,98.92,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2583,7968,835,40720,3133,2,13,1,570.00,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2584,7968,836,40720,3133,2,96,2,1305.79,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2585,7968,836,40720,3133,2,67,2,274.21,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2586,7968,836,40720,3133,2,13,1,1580.00,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2587,7968,837,40720,3133,2,96,2,652.89,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL);
INSERT INTO `balance_libro_details` VALUES (2588,7968,837,40720,3133,2,67,2,137.11,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2589,7968,837,40720,3133,2,13,1,790.00,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2590,7968,838,40720,3133,2,96,2,1041.32,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2591,7968,838,40720,3133,2,67,2,218.68,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2592,7968,838,40720,3133,2,13,1,1260.00,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2593,7968,839,40720,3133,2,96,2,380.16,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2594,7968,839,40720,3133,2,67,2,79.84,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2595,7968,839,40720,3133,2,13,1,460.00,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2596,7968,840,40720,3133,2,96,2,1818.18,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2597,7968,840,40720,3133,2,67,2,381.82,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2598,7968,840,40720,3133,2,13,1,2200.00,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2599,7968,841,40720,3133,2,96,2,595.04,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2600,7968,841,40720,3133,2,67,2,124.96,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2601,7968,841,40720,3133,2,13,1,720.00,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2602,7968,842,40720,3133,2,96,2,644.63,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2603,7968,842,40720,3133,2,67,2,135.37,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2604,7968,842,40720,3133,2,13,1,780.00,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2605,7968,843,40720,3133,2,96,2,776.86,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2606,7968,843,40720,3133,2,67,2,163.14,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2607,7968,843,40720,3133,2,13,1,940.00,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2608,7968,844,40720,3133,2,96,2,884.29,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2609,7968,844,40720,3133,2,67,2,185.71,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2610,7968,844,40720,3133,2,13,1,1070.00,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2611,7968,845,40720,3133,2,96,2,636.36,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2612,7968,845,40720,3133,2,67,2,133.64,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2613,7968,845,40720,3133,2,13,1,770.00,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2614,7968,846,40720,3133,2,96,2,214.88,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2615,7968,846,40720,3133,2,67,2,45.12,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2616,7968,846,40720,3133,2,13,1,260.00,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2617,7968,847,40720,3133,2,96,2,446.28,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2618,7968,847,40720,3133,2,67,2,93.72,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2619,7968,847,40720,3133,2,13,1,540.00,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2620,7968,848,40720,3133,2,96,2,462.81,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2621,7968,848,40720,3133,2,67,2,97.19,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2622,7968,848,40720,3133,2,13,1,560.00,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2623,7968,849,40720,3133,2,96,2,1305.79,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2624,7968,849,40720,3133,2,67,2,274.21,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2625,7968,849,40720,3133,2,13,1,1580.00,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2626,7968,850,40720,3133,2,96,2,892.56,NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(2627,7968,850,40720,3133,2,67,2,187.44,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2628,7968,850,40720,3133,2,13,1,1080.00,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2629,7968,851,40720,3133,2,96,2,1082.64,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL);
INSERT INTO `balance_libro_details` VALUES (2630,7968,851,40720,3133,2,67,2,227.36,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2631,7968,851,40720,3133,2,13,1,1310.00,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2632,7968,852,40720,3133,2,96,2,3578.51,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2633,7968,852,40720,3133,2,67,2,751.49,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2634,7968,852,40720,3133,2,13,1,4330.00,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2635,7968,853,40720,3133,2,96,2,1074.38,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2636,7968,853,40720,3133,2,67,2,225.62,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2637,7968,853,40720,3133,2,13,1,1300.00,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2638,7968,854,40720,3133,2,96,2,1057.85,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2639,7968,854,40720,3133,2,67,2,222.15,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2640,7968,854,40720,3133,2,13,1,1280.00,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2641,7968,855,40720,3133,2,96,2,1719.01,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2642,7968,855,40720,3133,2,67,2,360.99,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2643,7968,855,40720,3133,2,13,1,2080.00,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2644,7968,856,40720,3133,2,96,2,1520.66,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2645,7968,856,40720,3133,2,67,2,319.34,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2646,7968,856,40720,3133,2,13,1,1840.00,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2647,7968,857,40720,3133,2,96,2,462.81,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2648,7968,857,40720,3133,2,67,2,97.19,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2649,7968,857,40720,3133,2,13,1,560.00,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2650,7968,858,40720,3133,2,96,2,876.03,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2651,7968,858,40720,3133,2,67,2,183.97,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2652,7968,858,40720,3133,2,13,1,1060.00,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2653,7968,859,40720,3133,2,96,2,421.49,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2654,7968,859,40720,3133,2,67,2,88.51,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2655,7968,859,40720,3133,2,13,1,510.00,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2656,7968,860,40720,3133,2,96,2,1983.47,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2657,7968,860,40720,3133,2,67,2,416.53,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2658,7968,860,40720,3133,2,13,1,2400.00,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2659,7968,861,40720,3133,2,96,2,1305.79,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2660,7968,861,40720,3133,2,67,2,274.21,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2661,7968,861,40720,3133,2,13,1,1580.00,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2662,7968,862,40720,3133,2,96,2,809.92,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2663,7968,862,40720,3133,2,67,2,170.08,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2664,7968,862,40720,3133,2,13,1,980.00,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2665,7968,863,40720,3133,2,96,2,1305.79,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2666,7968,863,40720,3133,2,67,2,274.21,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2667,7968,863,40720,3133,2,13,1,1580.00,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2668,7968,864,40720,3133,2,96,2,2727.27,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2669,7968,864,40720,3133,2,67,2,572.73,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2670,7968,864,40720,3133,2,13,1,3300.00,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL);
INSERT INTO `balance_libro_details` VALUES (2671,7968,865,40720,3133,2,96,2,1619.84,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2672,7968,865,40720,3133,2,67,2,340.16,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2673,7968,865,40720,3133,2,13,1,1960.00,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2674,7968,866,40720,3133,2,96,2,1165.29,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2675,7968,866,40720,3133,2,67,2,244.71,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2676,7968,866,40720,3133,2,13,1,1410.00,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2677,7968,867,40720,3133,2,96,2,446.28,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2678,7968,867,40720,3133,2,67,2,93.72,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2679,7968,867,40720,3133,2,13,1,540.00,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2680,7968,868,40720,3133,2,96,2,595.04,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2681,7968,868,40720,3133,2,67,2,124.96,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2682,7968,868,40720,3133,2,13,1,720.00,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2683,7968,869,40720,3133,2,96,2,1231.40,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2684,7968,869,40720,3133,2,67,2,258.60,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2685,7968,869,40720,3133,2,13,1,1490.00,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2686,7968,870,40720,3133,2,96,2,1760.33,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2687,7968,870,40720,3133,2,67,2,369.67,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2688,7968,870,40720,3133,2,13,1,2130.00,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2689,7968,871,40720,3133,2,96,2,1760.34,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2690,7968,871,40720,3133,2,67,2,369.66,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2691,7968,871,40720,3133,2,13,1,2130.00,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2692,7968,872,40720,3133,2,96,2,438.02,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2693,7968,872,40720,3133,2,67,2,91.98,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2694,7968,872,40720,3133,2,13,1,530.00,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2695,7968,873,40720,3133,2,96,2,1438.01,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2696,7968,873,40720,3133,2,67,2,301.99,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2697,7968,873,40720,3133,2,13,1,1740.00,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2698,7968,874,40720,3133,2,96,2,1115.70,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2699,7968,874,40720,3133,2,67,2,234.29,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2700,7968,874,40720,3133,2,13,1,1350.00,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2701,7968,874,40720,3133,2,136,2,0.01,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2702,7968,875,40720,3133,2,96,2,1619.83,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2703,7968,875,40720,3133,2,67,2,340.17,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2704,7968,875,40720,3133,2,13,1,1960.00,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2705,7968,876,40720,3133,2,96,2,2793.38,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2706,7968,876,40720,3133,2,67,2,586.62,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2707,7968,876,40720,3133,2,13,1,3380.00,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2708,7968,877,40720,3133,2,96,2,421.49,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2709,7968,877,40720,3133,2,67,2,88.51,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2710,7968,877,40720,3133,2,13,1,510.00,NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(2711,7968,878,40720,3133,2,96,2,1619.83,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2712,7968,878,40720,3133,2,67,2,340.17,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL);
INSERT INTO `balance_libro_details` VALUES (2713,7968,878,40720,3133,2,13,1,1960.00,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2714,7968,879,40720,3133,2,96,2,809.92,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2715,7968,879,40720,3133,2,67,2,170.08,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2716,7968,879,40720,3133,2,13,1,980.00,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2717,7968,880,40720,3133,2,96,2,1619.83,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2718,7968,880,40720,3133,2,67,2,340.17,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2719,7968,880,40720,3133,2,13,1,1960.00,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2720,7968,881,40720,3133,2,96,2,3239.67,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2721,7968,881,40720,3133,2,67,2,680.33,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2722,7968,881,40720,3133,2,13,1,3920.00,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2723,7968,882,40720,3133,2,96,2,4297.51,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2724,7968,882,40720,3133,2,67,2,902.49,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2725,7968,882,40720,3133,2,13,1,5200.00,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2726,7968,883,40720,3133,2,96,2,2537.18,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2727,7968,883,40720,3133,2,67,2,532.82,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2728,7968,883,40720,3133,2,13,1,3070.00,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2729,7968,884,40720,3133,2,96,2,1140.50,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2730,7968,884,40720,3133,2,67,2,239.50,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2731,7968,884,40720,3133,2,13,1,1380.00,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2732,7968,885,40720,3133,2,96,2,975.21,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2733,7968,885,40720,3133,2,67,2,204.79,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2734,7968,885,40720,3133,2,13,1,1180.00,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2735,7968,886,40720,3133,2,96,2,809.92,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2736,7968,886,40720,3133,2,67,2,170.08,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2737,7968,886,40720,3133,2,13,1,980.00,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2738,7968,887,40720,3133,2,96,2,297.52,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2739,7968,887,40720,3133,2,67,2,62.48,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2740,7968,887,40720,3133,2,13,1,360.00,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2741,7968,888,40720,3133,2,96,2,1066.12,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2742,7968,888,40720,3133,2,67,2,223.88,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2743,7968,888,40720,3133,2,13,1,1290.00,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2744,7968,889,40720,3133,2,96,2,1900.83,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2745,7968,889,40720,3133,2,67,2,399.17,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2746,7968,889,40720,3133,2,13,1,2300.00,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2747,7968,890,40720,3133,2,96,2,1165.28,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2748,7968,890,40720,3133,2,67,2,244.72,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2749,7968,890,40720,3133,2,13,1,1410.00,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2750,7968,891,40720,3133,2,96,2,1561.98,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2751,7968,891,40720,3133,2,67,2,328.02,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2752,7968,891,40720,3133,2,13,1,1890.00,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2753,7968,892,40720,3133,2,96,2,1223.14,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL);
INSERT INTO `balance_libro_details` VALUES (2754,7968,892,40720,3133,2,67,2,256.86,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2755,7968,892,40720,3133,2,13,1,1480.00,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2756,7968,893,40720,3133,2,96,2,1280.99,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2757,7968,893,40720,3133,2,67,2,269.01,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2758,7968,893,40720,3133,2,13,1,1550.00,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2759,7968,894,40720,3133,2,96,2,1619.84,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2760,7968,894,40720,3133,2,67,2,340.16,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2761,7968,894,40720,3133,2,13,1,1960.00,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2762,7968,895,40720,3133,2,96,2,3991.73,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2763,7968,895,40720,3133,2,67,2,838.27,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2764,7968,895,40720,3133,2,13,1,4830.00,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2765,7968,896,40720,3133,2,96,2,909.09,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2766,7968,896,40720,3133,2,67,2,190.91,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2767,7968,896,40720,3133,2,13,1,1100.00,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2768,7968,897,40720,3133,2,96,2,1305.79,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2769,7968,897,40720,3133,2,67,2,274.21,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2770,7968,897,40720,3133,2,13,1,1580.00,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2771,7968,898,40720,3133,2,96,2,2636.37,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2772,7968,898,40720,3133,2,67,2,553.63,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2773,7968,898,40720,3133,2,13,1,3190.00,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2774,7968,899,40720,3133,2,96,2,2842.98,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2775,7968,899,40720,3133,2,67,2,597.02,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2776,7968,899,40720,3133,2,13,1,3440.00,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2777,7968,900,40720,3133,2,96,2,892.57,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2778,7968,900,40720,3133,2,67,2,187.43,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2779,7968,900,40720,3133,2,13,1,1080.00,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2780,7968,901,40720,3133,2,96,2,1041.32,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2781,7968,901,40720,3133,2,67,2,218.68,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2782,7968,901,40720,3133,2,13,1,1260.00,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2783,7968,902,40720,3133,2,96,2,347.11,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2784,7968,902,40720,3133,2,67,2,72.89,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2785,7968,902,40720,3133,2,13,1,420.00,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2786,7968,903,40720,3133,2,96,2,867.77,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2787,7968,903,40720,3133,2,67,2,182.23,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2788,7968,903,40720,3133,2,13,1,1050.00,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2789,7968,904,40720,3133,2,96,2,595.04,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2790,7968,904,40720,3133,2,67,2,124.96,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2791,7968,904,40720,3133,2,13,1,720.00,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2792,7968,905,40720,3133,2,96,2,1305.79,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2793,7968,905,40720,3133,2,67,2,274.21,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2794,7968,905,40720,3133,2,13,1,1580.00,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL);
INSERT INTO `balance_libro_details` VALUES (2795,7968,906,40720,3133,2,96,2,652.89,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2796,7968,906,40720,3133,2,67,2,137.11,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2797,7968,906,40720,3133,2,13,1,790.00,NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(2798,7968,907,40720,3133,2,96,2,809.92,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2799,7968,907,40720,3133,2,67,2,170.08,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2800,7968,907,40720,3133,2,13,1,980.00,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2801,7968,908,40720,3133,2,96,2,809.92,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2802,7968,908,40720,3133,2,67,2,170.08,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2803,7968,908,40720,3133,2,13,1,980.00,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2804,7968,909,40720,3133,2,96,2,909.09,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2805,7968,909,40720,3133,2,67,2,190.91,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2806,7968,909,40720,3133,2,13,1,1100.00,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2807,7968,910,40720,3133,2,96,2,809.92,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2808,7968,910,40720,3133,2,67,2,170.08,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2809,7968,910,40720,3133,2,13,1,980.00,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2810,7968,911,40720,3133,2,96,2,1644.63,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2811,7968,911,40720,3133,2,67,2,345.37,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2812,7968,911,40720,3133,2,13,1,1990.00,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2813,7968,912,40720,3133,2,96,2,1520.66,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2814,7968,912,40720,3133,2,67,2,319.34,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2815,7968,912,40720,3133,2,13,1,1840.00,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2816,7968,913,40720,3133,2,96,2,735.54,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2817,7968,913,40720,3133,2,67,2,154.46,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2818,7968,913,40720,3133,2,13,1,890.00,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2819,7968,914,40720,3133,2,96,2,966.95,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2820,7968,914,40720,3133,2,67,2,203.05,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2821,7968,914,40720,3133,2,13,1,1170.00,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2822,7968,915,40720,3133,2,96,2,892.56,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2823,7968,915,40720,3133,2,67,2,187.44,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2824,7968,915,40720,3133,2,13,1,1080.00,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2825,7968,916,40720,3133,2,96,2,462.81,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2826,7968,916,40720,3133,2,67,2,97.19,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2827,7968,916,40720,3133,2,13,1,560.00,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2828,7968,917,40720,3133,2,96,2,983.47,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2829,7968,917,40720,3133,2,67,2,206.53,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2830,7968,917,40720,3133,2,13,1,1190.00,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2831,7968,918,40720,3133,2,96,2,2950.41,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2832,7968,918,40720,3133,2,67,2,619.59,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2833,7968,918,40720,3133,2,13,1,3570.00,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2834,7968,919,40720,3133,2,96,2,1305.79,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2835,7968,919,40720,3133,2,67,2,274.21,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2836,7968,919,40720,3133,2,13,1,1580.00,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL);
INSERT INTO `balance_libro_details` VALUES (2837,7968,920,40720,3133,2,96,2,1157.03,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2838,7968,920,40720,3133,2,67,2,242.97,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2839,7968,920,40720,3133,2,13,1,1400.00,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2840,7968,921,40720,3133,2,96,2,1760.33,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2841,7968,921,40720,3133,2,67,2,369.67,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2842,7968,921,40720,3133,2,13,1,2130.00,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2843,7968,922,40720,3133,2,96,2,652.89,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2844,7968,922,40720,3133,2,67,2,137.11,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2845,7968,922,40720,3133,2,13,1,790.00,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2846,7968,923,40720,3133,2,96,2,1925.62,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2847,7968,923,40720,3133,2,67,2,404.38,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2848,7968,923,40720,3133,2,13,1,2330.00,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2849,7968,924,40720,3133,2,96,2,652.89,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2850,7968,924,40720,3133,2,67,2,137.11,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2851,7968,924,40720,3133,2,13,1,790.00,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2852,7968,925,40720,3133,2,96,2,1958.68,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2853,7968,925,40720,3133,2,67,2,411.32,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2854,7968,925,40720,3133,2,13,1,2370.00,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2855,7968,926,40720,3133,2,96,2,388.43,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2856,7968,926,40720,3133,2,67,2,81.57,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2857,7968,926,40720,3133,2,13,1,470.00,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2858,7968,927,40720,3133,2,96,2,446.28,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2859,7968,927,40720,3133,2,67,2,93.72,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2860,7968,927,40720,3133,2,13,1,540.00,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2861,7968,928,40720,3133,2,96,2,462.81,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2862,7968,928,40720,3133,2,67,2,97.19,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2863,7968,928,40720,3133,2,13,1,560.00,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2864,7968,929,40720,3133,2,96,2,1553.72,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2865,7968,929,40720,3133,2,67,2,326.28,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2866,7968,929,40720,3133,2,13,1,1880.00,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2867,7968,930,40720,3133,2,96,2,1983.47,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2868,7968,930,40720,3133,2,67,2,416.53,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2869,7968,930,40720,3133,2,13,1,2400.00,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2870,7968,931,40720,3133,2,96,2,801.65,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2871,7968,931,40720,3133,2,67,2,168.35,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2872,7968,931,40720,3133,2,13,1,970.00,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2873,7968,932,40720,3133,2,96,2,1305.79,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2874,7968,932,40720,3133,2,67,2,274.21,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2875,7968,932,40720,3133,2,13,1,1580.00,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2876,7968,933,40720,3133,2,96,2,1785.13,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2877,7968,933,40720,3133,2,67,2,374.87,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2878,7968,933,40720,3133,2,13,1,2160.00,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL);
INSERT INTO `balance_libro_details` VALUES (2879,7968,934,40720,3133,2,96,2,652.89,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2880,7968,934,40720,3133,2,67,2,137.11,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2881,7968,934,40720,3133,2,13,1,790.00,NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(2882,7968,935,40720,3133,2,96,2,719.01,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2883,7968,935,40720,3133,2,67,2,150.99,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2884,7968,935,40720,3133,2,13,1,870.00,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2885,7968,936,40720,3133,2,96,2,2628.10,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2886,7968,936,40720,3133,2,67,2,551.90,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2887,7968,936,40720,3133,2,13,1,3180.00,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2888,7968,937,40720,3133,2,96,2,231.40,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2889,7968,937,40720,3133,2,67,2,48.60,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2890,7968,937,40720,3133,2,13,1,280.00,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2891,7968,938,40720,3133,2,96,2,1661.15,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2892,7968,938,40720,3133,2,67,2,348.85,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2893,7968,938,40720,3133,2,13,1,2010.00,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2894,7968,939,40720,3133,2,96,2,1561.98,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2895,7968,939,40720,3133,2,67,2,328.02,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2896,7968,939,40720,3133,2,13,1,1890.00,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2897,7968,940,40720,3133,2,96,2,809.92,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2898,7968,940,40720,3133,2,67,2,170.08,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2899,7968,940,40720,3133,2,13,1,980.00,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2900,7968,941,40720,3133,2,96,2,876.03,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2901,7968,941,40720,3133,2,67,2,183.97,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2902,7968,941,40720,3133,2,13,1,1060.00,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2903,7968,942,40720,3133,2,96,2,842.97,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2904,7968,942,40720,3133,2,67,2,177.03,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2905,7968,942,40720,3133,2,13,1,1020.00,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2906,7968,943,40720,3133,2,96,2,231.40,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2907,7968,943,40720,3133,2,67,2,48.60,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2908,7968,943,40720,3133,2,13,1,280.00,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2909,7968,944,40720,3133,2,96,2,735.53,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2910,7968,944,40720,3133,2,67,2,154.47,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2911,7968,944,40720,3133,2,13,1,890.00,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2912,7968,945,40720,3133,2,96,2,1504.13,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2913,7968,945,40720,3133,2,67,2,315.87,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2914,7968,945,40720,3133,2,13,1,1820.00,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2915,7968,946,40720,3133,2,96,2,1520.66,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2916,7968,946,40720,3133,2,67,2,319.34,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2917,7968,946,40720,3133,2,13,1,1840.00,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2918,7968,947,40720,3133,2,96,2,2066.11,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2919,7968,947,40720,3133,2,67,2,433.89,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2920,7968,947,40720,3133,2,13,1,2500.00,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL);
INSERT INTO `balance_libro_details` VALUES (2921,7968,948,40720,3133,2,96,2,1024.80,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2922,7968,948,40720,3133,2,67,2,215.20,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2923,7968,948,40720,3133,2,13,1,1240.00,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2924,7968,949,40720,3133,2,96,2,1074.38,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2925,7968,949,40720,3133,2,67,2,225.62,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2926,7968,949,40720,3133,2,13,1,1300.00,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2927,7968,950,40720,3133,2,96,2,3099.17,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2928,7968,950,40720,3133,2,67,2,650.83,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2929,7968,950,40720,3133,2,13,1,3750.00,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2930,7968,951,40720,3133,2,96,2,2322.31,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2931,7968,951,40720,3133,2,67,2,487.69,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2932,7968,951,40720,3133,2,13,1,2810.00,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2933,7968,952,40720,3133,2,96,2,859.51,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2934,7968,952,40720,3133,2,67,2,180.49,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2935,7968,952,40720,3133,2,13,1,1040.00,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2936,7968,953,40720,3133,2,96,2,1115.70,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2937,7968,953,40720,3133,2,67,2,234.30,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2938,7968,953,40720,3133,2,13,1,1350.00,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2939,7968,954,40720,3133,2,96,2,801.65,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2940,7968,954,40720,3133,2,67,2,168.35,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2941,7968,954,40720,3133,2,13,1,970.00,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2942,7968,955,40720,3133,2,96,2,818.18,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2943,7968,955,40720,3133,2,67,2,171.82,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2944,7968,955,40720,3133,2,13,1,990.00,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2945,7968,956,40720,3133,2,96,2,421.49,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2946,7968,956,40720,3133,2,67,2,88.51,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2947,7968,956,40720,3133,2,13,1,510.00,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2948,7968,957,40720,3133,2,96,2,421.49,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2949,7968,957,40720,3133,2,67,2,88.51,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2950,7968,957,40720,3133,2,13,1,510.00,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2951,7968,958,40720,3133,2,96,2,404.96,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2952,7968,958,40720,3133,2,67,2,85.04,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2953,7968,958,40720,3133,2,13,1,490.00,NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(2954,7968,959,40720,3133,2,96,2,471.08,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2955,7968,959,40720,3133,2,67,2,98.92,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2956,7968,959,40720,3133,2,13,1,570.00,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2957,7968,960,40720,3133,2,96,2,1735.54,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2958,7968,960,40720,3133,2,67,2,364.46,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2959,7968,960,40720,3133,2,13,1,2100.00,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2960,7968,961,40720,3133,2,96,2,1867.77,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2961,7968,961,40720,3133,2,67,2,392.23,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2962,7968,961,40720,3133,2,13,1,2260.00,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL);
INSERT INTO `balance_libro_details` VALUES (2963,7968,962,40720,3133,2,96,2,1462.81,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2964,7968,962,40720,3133,2,67,2,307.19,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2965,7968,962,40720,3133,2,13,1,1770.00,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2966,7968,963,40720,3133,2,96,2,1190.09,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2967,7968,963,40720,3133,2,67,2,249.91,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2968,7968,963,40720,3133,2,13,1,1440.00,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2969,7968,964,40720,3133,2,96,2,2462.81,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2970,7968,964,40720,3133,2,67,2,517.19,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2971,7968,964,40720,3133,2,13,1,2980.00,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2972,7968,965,40720,3133,2,96,2,1206.61,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2973,7968,965,40720,3133,2,67,2,253.39,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2974,7968,965,40720,3133,2,13,1,1460.00,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2975,7968,966,40720,3133,2,96,2,1148.75,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2976,7968,966,40720,3133,2,67,2,241.25,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2977,7968,966,40720,3133,2,13,1,1390.00,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2978,7968,967,40720,3133,2,96,2,297.52,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2979,7968,967,40720,3133,2,67,2,62.48,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2980,7968,967,40720,3133,2,13,1,360.00,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2981,7968,968,40720,3133,2,96,2,652.89,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2982,7968,968,40720,3133,2,67,2,137.11,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2983,7968,968,40720,3133,2,13,1,790.00,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2984,7968,969,40720,3133,2,96,2,1016.53,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2985,7968,969,40720,3133,2,67,2,213.47,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2986,7968,969,40720,3133,2,13,1,1230.00,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2987,7968,970,40720,3133,2,96,2,801.65,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2988,7968,970,40720,3133,2,67,2,168.35,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2989,7968,970,40720,3133,2,13,1,970.00,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2990,7968,971,40720,3133,2,96,2,1305.79,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2991,7968,971,40720,3133,2,67,2,274.21,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2992,7968,971,40720,3133,2,13,1,1580.00,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2993,7968,972,40720,3133,2,96,2,528.92,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2994,7968,972,40720,3133,2,67,2,111.08,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2995,7968,972,40720,3133,2,13,1,640.00,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2996,7968,973,40720,3133,2,96,2,652.89,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2997,7968,973,40720,3133,2,67,2,137.11,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2998,7968,973,40720,3133,2,13,1,790.00,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(2999,7968,974,40720,3133,2,96,2,404.96,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(3000,7968,974,40720,3133,2,67,2,85.04,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(3001,7968,974,40720,3133,2,13,1,490.00,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(3002,7968,975,40720,3133,2,96,2,297.52,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(3003,7968,975,40720,3133,2,67,2,62.48,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(3004,7968,975,40720,3133,2,13,1,360.00,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL);
INSERT INTO `balance_libro_details` VALUES (3005,7968,976,40720,3133,2,96,2,925.62,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(3006,7968,976,40720,3133,2,67,2,194.38,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(3007,7968,976,40720,3133,2,13,1,1120.00,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(3008,7968,977,40720,3133,2,96,2,644.63,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(3009,7968,977,40720,3133,2,67,2,135.37,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(3010,7968,977,40720,3133,2,13,1,780.00,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(3011,7968,978,40720,3133,2,96,2,694.22,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(3012,7968,978,40720,3133,2,67,2,145.78,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(3013,7968,978,40720,3133,2,13,1,840.00,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(3014,7968,979,40720,3133,2,96,2,876.03,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(3015,7968,979,40720,3133,2,67,2,183.97,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(3016,7968,979,40720,3133,2,13,1,1060.00,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(3017,7968,980,40720,3133,2,96,2,462.81,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(3018,7968,980,40720,3133,2,67,2,97.19,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(3019,7968,980,40720,3133,2,13,1,560.00,NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(3020,7968,981,40720,3133,2,96,2,380.16,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3021,7968,981,40720,3133,2,67,2,79.84,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3022,7968,981,40720,3133,2,13,1,460.00,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3023,7968,982,40720,3133,2,96,2,1305.79,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3024,7968,982,40720,3133,2,67,2,274.21,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3025,7968,982,40720,3133,2,13,1,1580.00,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3026,7968,983,40720,3133,2,96,2,958.68,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3027,7968,983,40720,3133,2,67,2,201.32,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3028,7968,983,40720,3133,2,13,1,1160.00,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3029,7968,984,40720,3133,2,96,2,702.48,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3030,7968,984,40720,3133,2,67,2,147.52,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3031,7968,984,40720,3133,2,13,1,850.00,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3032,7968,985,40720,3133,2,96,2,595.04,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3033,7968,985,40720,3133,2,67,2,124.96,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3034,7968,985,40720,3133,2,13,1,720.00,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3035,7968,986,40720,3133,2,96,2,1239.67,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3036,7968,986,40720,3133,2,67,2,260.33,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3037,7968,986,40720,3133,2,13,1,1500.00,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3038,7968,987,40720,3133,2,96,2,1008.27,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3039,7968,987,40720,3133,2,67,2,211.73,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3040,7968,987,40720,3133,2,13,1,1220.00,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3041,7968,988,40720,3133,2,96,2,2471.07,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3042,7968,988,40720,3133,2,67,2,518.93,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3043,7968,988,40720,3133,2,13,1,2990.00,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3044,7968,989,40720,3133,2,96,2,1074.38,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3045,7968,989,40720,3133,2,67,2,225.62,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3046,7968,989,40720,3133,2,13,1,1300.00,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL);
INSERT INTO `balance_libro_details` VALUES (3047,7968,990,40720,3133,2,96,2,1603.31,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3048,7968,990,40720,3133,2,67,2,336.69,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3049,7968,990,40720,3133,2,13,1,1940.00,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3050,7968,991,40720,3133,2,96,2,809.92,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3051,7968,991,40720,3133,2,67,2,170.08,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3052,7968,991,40720,3133,2,13,1,980.00,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3053,7968,992,40720,3133,2,96,2,2669.42,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3054,7968,992,40720,3133,2,67,2,560.58,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3055,7968,992,40720,3133,2,13,1,3230.00,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3056,7968,993,40720,3133,2,96,2,1966.94,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3057,7968,993,40720,3133,2,67,2,413.06,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3058,7968,993,40720,3133,2,13,1,2380.00,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3059,7968,994,40720,3133,2,96,2,2115.70,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3060,7968,994,40720,3133,2,67,2,444.30,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3061,7968,994,40720,3133,2,13,1,2560.00,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3062,7968,995,40720,3133,2,96,2,388.43,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3063,7968,995,40720,3133,2,67,2,81.57,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3064,7968,995,40720,3133,2,13,1,470.00,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3065,7968,996,40720,3133,2,96,2,661.16,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3066,7968,996,40720,3133,2,67,2,138.84,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3067,7968,996,40720,3133,2,13,1,800.00,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3068,7968,997,40720,3133,2,96,2,1520.66,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3069,7968,997,40720,3133,2,67,2,319.34,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3070,7968,997,40720,3133,2,13,1,1840.00,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3071,7968,998,40720,3133,2,96,2,1652.89,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3072,7968,998,40720,3133,2,67,2,347.11,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3073,7968,998,40720,3133,2,13,1,2000.00,NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(3074,7968,999,40720,3133,2,96,2,1933.88,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3075,7968,999,40720,3133,2,67,2,406.12,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3076,7968,999,40720,3133,2,13,1,2340.00,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3077,7968,1000,40720,3133,2,96,2,1619.83,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3078,7968,1000,40720,3133,2,67,2,340.17,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3079,7968,1000,40720,3133,2,13,1,1960.00,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3080,7968,1001,40720,3133,2,96,2,1074.38,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3081,7968,1001,40720,3133,2,67,2,225.62,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3082,7968,1001,40720,3133,2,13,1,1300.00,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3083,7968,1002,40720,3133,2,96,2,2561.98,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3084,7968,1002,40720,3133,2,67,2,538.02,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3085,7968,1002,40720,3133,2,13,1,3100.00,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3086,7968,1003,40720,3133,2,96,2,1561.99,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3087,7968,1003,40720,3133,2,67,2,328.01,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL);
INSERT INTO `balance_libro_details` VALUES (3088,7968,1003,40720,3133,2,13,1,1890.00,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3089,7968,1004,40720,3133,2,96,2,2297.52,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3090,7968,1004,40720,3133,2,67,2,482.48,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3091,7968,1004,40720,3133,2,13,1,2780.00,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3092,7968,1005,40720,3133,2,96,2,3247.93,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3093,7968,1005,40720,3133,2,67,2,682.07,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3094,7968,1005,40720,3133,2,13,1,3930.00,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3095,7968,1006,40720,3133,2,96,2,1190.09,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3096,7968,1006,40720,3133,2,67,2,249.91,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3097,7968,1006,40720,3133,2,13,1,1440.00,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3098,7968,1007,40720,3133,2,96,2,1413.22,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3099,7968,1007,40720,3133,2,67,2,296.78,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3100,7968,1007,40720,3133,2,13,1,1710.00,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3101,7968,1008,40720,3133,2,96,2,793.39,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3102,7968,1008,40720,3133,2,67,2,166.61,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3103,7968,1008,40720,3133,2,13,1,960.00,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3104,7968,1009,40720,3133,2,96,2,1991.73,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3105,7968,1009,40720,3133,2,67,2,418.27,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3106,7968,1009,40720,3133,2,13,1,2410.00,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3107,7968,1010,40720,3133,2,96,2,1239.67,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3108,7968,1010,40720,3133,2,67,2,260.33,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3109,7968,1010,40720,3133,2,13,1,1500.00,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3110,7968,1011,40720,3133,2,96,2,958.68,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3111,7968,1011,40720,3133,2,67,2,201.32,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3112,7968,1011,40720,3133,2,13,1,1160.00,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3113,7968,1012,40720,3133,2,96,2,933.89,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3114,7968,1012,40720,3133,2,67,2,196.11,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3115,7968,1012,40720,3133,2,13,1,1130.00,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3116,7968,1013,40720,3133,2,96,2,1396.69,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3117,7968,1013,40720,3133,2,67,2,293.31,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3118,7968,1013,40720,3133,2,13,1,1690.00,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3119,7968,1014,40720,3133,2,96,2,652.89,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3120,7968,1014,40720,3133,2,67,2,137.11,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3121,7968,1014,40720,3133,2,13,1,790.00,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3122,7968,1015,40720,3133,2,96,2,2611.57,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3123,7968,1015,40720,3133,2,67,2,548.43,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3124,7968,1015,40720,3133,2,13,1,3160.00,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3125,7968,1016,40720,3133,2,96,2,1619.83,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3126,7968,1016,40720,3133,2,67,2,340.17,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3127,7968,1016,40720,3133,2,13,1,1960.00,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3128,7968,1017,40720,3133,2,96,2,652.89,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL);
INSERT INTO `balance_libro_details` VALUES (3129,7968,1017,40720,3133,2,67,2,137.11,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3130,7968,1017,40720,3133,2,13,1,790.00,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3131,7968,1018,40720,3133,2,96,2,1487.60,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3132,7968,1018,40720,3133,2,67,2,312.40,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3133,7968,1018,40720,3133,2,13,1,1800.00,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3134,7968,1019,40720,3133,2,96,2,909.09,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3135,7968,1019,40720,3133,2,67,2,190.91,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3136,7968,1019,40720,3133,2,13,1,1100.00,NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(3137,7968,1020,40720,3133,2,96,2,909.09,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3138,7968,1020,40720,3133,2,67,2,190.91,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3139,7968,1020,40720,3133,2,13,1,1100.00,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3140,7968,1021,40720,3133,2,96,2,1057.85,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3141,7968,1021,40720,3133,2,67,2,222.15,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3142,7968,1021,40720,3133,2,13,1,1280.00,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3143,7968,1022,40720,3133,2,96,2,652.89,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3144,7968,1022,40720,3133,2,67,2,137.11,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3145,7968,1022,40720,3133,2,13,1,790.00,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3146,7968,1023,40720,3133,2,96,2,1256.20,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3147,7968,1023,40720,3133,2,67,2,263.80,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3148,7968,1023,40720,3133,2,13,1,1520.00,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3149,7968,1024,40720,3133,2,96,2,1305.79,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3150,7968,1024,40720,3133,2,67,2,274.21,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3151,7968,1024,40720,3133,2,13,1,1580.00,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3152,7968,1025,40720,3133,2,96,2,909.09,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3153,7968,1025,40720,3133,2,67,2,190.91,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3154,7968,1025,40720,3133,2,13,1,1100.00,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3155,7968,1026,40720,3133,2,96,2,1074.38,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3156,7968,1026,40720,3133,2,67,2,225.62,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3157,7968,1026,40720,3133,2,13,1,1300.00,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3158,7968,1027,40720,3133,2,96,2,247.93,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3159,7968,1027,40720,3133,2,67,2,52.07,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3160,7968,1027,40720,3133,2,13,1,300.00,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3161,7968,1028,40720,3133,2,96,2,834.71,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3162,7968,1028,40720,3133,2,67,2,175.29,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3163,7968,1028,40720,3133,2,13,1,1010.00,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3164,7968,1029,40720,3133,2,96,2,826.44,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3165,7968,1029,40720,3133,2,67,2,173.56,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3166,7968,1029,40720,3133,2,13,1,1000.00,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3167,7968,1030,40720,3133,2,96,2,421.49,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3168,7968,1030,40720,3133,2,67,2,88.51,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3169,7968,1030,40720,3133,2,13,1,510.00,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL);
INSERT INTO `balance_libro_details` VALUES (3170,7968,1031,40720,3133,2,96,2,214.88,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3171,7968,1031,40720,3133,2,67,2,45.12,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3172,7968,1031,40720,3133,2,13,1,260.00,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3173,7968,1032,40720,3133,2,96,2,231.40,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3174,7968,1032,40720,3133,2,67,2,48.60,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3175,7968,1032,40720,3133,2,13,1,280.00,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3176,7968,1033,40720,3133,2,96,2,1652.89,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3177,7968,1033,40720,3133,2,67,2,347.11,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3178,7968,1033,40720,3133,2,13,1,2000.00,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3179,7968,1034,40720,3133,2,96,2,785.12,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3180,7968,1034,40720,3133,2,67,2,164.88,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3181,7968,1034,40720,3133,2,13,1,950.00,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3182,7968,1035,40720,3133,2,96,2,1520.67,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3183,7968,1035,40720,3133,2,67,2,319.33,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3184,7968,1035,40720,3133,2,13,1,1840.00,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3185,7968,1036,40720,3133,2,96,2,2512.40,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3186,7968,1036,40720,3133,2,67,2,527.60,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3187,7968,1036,40720,3133,2,13,1,3040.00,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3188,7968,1037,40720,3133,2,96,2,1925.62,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3189,7968,1037,40720,3133,2,67,2,404.38,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3190,7968,1037,40720,3133,2,13,1,2330.00,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3191,7968,1038,40720,3133,2,96,2,2834.71,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3192,7968,1038,40720,3133,2,67,2,595.29,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3193,7968,1038,40720,3133,2,13,1,3430.00,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3194,7968,1039,40720,3133,2,96,2,2024.79,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3195,7968,1039,40720,3133,2,67,2,425.21,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3196,7968,1039,40720,3133,2,13,1,2450.00,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3197,7968,1040,40720,3133,2,96,2,578.51,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3198,7968,1040,40720,3133,2,67,2,121.49,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3199,7968,1040,40720,3133,2,13,1,700.00,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3200,7968,1041,40720,3133,2,96,2,471.08,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3201,7968,1041,40720,3133,2,67,2,98.92,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3202,7968,1041,40720,3133,2,13,1,570.00,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3203,7968,1042,40720,3133,2,96,2,652.89,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3204,7968,1042,40720,3133,2,67,2,137.11,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3205,7968,1042,40720,3133,2,13,1,790.00,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3206,7968,1043,40720,3133,2,96,2,512.40,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3207,7968,1043,40720,3133,2,67,2,107.60,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3208,7968,1043,40720,3133,2,13,1,620.00,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3209,7968,1044,40720,3133,2,96,2,1206.61,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3210,7968,1044,40720,3133,2,67,2,253.39,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL);
INSERT INTO `balance_libro_details` VALUES (3211,7968,1044,40720,3133,2,13,1,1460.00,NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(3212,7968,1045,40720,3133,2,96,2,3214.88,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3213,7968,1045,40720,3133,2,67,2,675.12,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3214,7968,1045,40720,3133,2,13,1,3890.00,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3215,7968,1046,40720,3133,2,96,2,652.89,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3216,7968,1046,40720,3133,2,67,2,137.11,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3217,7968,1046,40720,3133,2,13,1,790.00,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3218,7968,1047,40720,3133,2,96,2,809.92,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3219,7968,1047,40720,3133,2,67,2,170.08,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3220,7968,1047,40720,3133,2,13,1,980.00,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3221,7968,1048,40720,3133,2,96,2,785.12,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3222,7968,1048,40720,3133,2,67,2,164.88,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3223,7968,1048,40720,3133,2,13,1,950.00,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3224,7968,1049,40720,3133,2,96,2,669.42,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3225,7968,1049,40720,3133,2,67,2,140.58,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3226,7968,1049,40720,3133,2,13,1,810.00,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3227,7968,1050,40720,3133,2,96,2,1421.48,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3228,7968,1050,40720,3133,2,67,2,298.52,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3229,7968,1050,40720,3133,2,13,1,1720.00,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3230,7968,1051,40720,3133,2,96,2,537.19,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3231,7968,1051,40720,3133,2,67,2,112.81,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3232,7968,1051,40720,3133,2,13,1,650.00,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3233,7968,1052,40720,3133,2,96,2,462.81,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3234,7968,1052,40720,3133,2,67,2,97.19,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3235,7968,1052,40720,3133,2,13,1,560.00,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3236,7968,1053,40720,3133,2,96,2,1983.47,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3237,7968,1053,40720,3133,2,67,2,416.53,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3238,7968,1053,40720,3133,2,13,1,2400.00,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3239,7968,1054,40720,3133,2,96,2,3512.39,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3240,7968,1054,40720,3133,2,67,2,737.61,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3241,7968,1054,40720,3133,2,13,1,4250.00,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3242,7968,1055,40720,3133,2,96,2,809.92,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3243,7968,1055,40720,3133,2,67,2,170.08,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3244,7968,1055,40720,3133,2,13,1,980.00,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3245,7968,1056,40720,3133,2,96,2,404.96,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3246,7968,1056,40720,3133,2,67,2,85.04,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3247,7968,1056,40720,3133,2,13,1,490.00,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3248,7968,1057,40720,3133,2,96,2,545.45,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3249,7968,1057,40720,3133,2,67,2,114.55,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3250,7968,1057,40720,3133,2,13,1,660.00,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3251,7968,1058,40720,3133,2,96,2,652.89,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL);
INSERT INTO `balance_libro_details` VALUES (3252,7968,1058,40720,3133,2,67,2,137.11,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3253,7968,1058,40720,3133,2,13,1,790.00,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3254,7968,1059,40720,3133,2,96,2,1603.31,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3255,7968,1059,40720,3133,2,67,2,336.69,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3256,7968,1059,40720,3133,2,13,1,1940.00,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3257,7968,1060,40720,3133,2,96,2,909.09,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3258,7968,1060,40720,3133,2,67,2,190.91,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3259,7968,1060,40720,3133,2,13,1,1100.00,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3260,7968,1061,40720,3133,2,96,2,1619.83,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3261,7968,1061,40720,3133,2,67,2,340.17,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3262,7968,1061,40720,3133,2,13,1,1960.00,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3263,7968,1062,40720,3133,2,96,2,2396.69,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3264,7968,1062,40720,3133,2,67,2,503.31,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3265,7968,1062,40720,3133,2,13,1,2900.00,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3266,7968,1063,40720,3133,2,96,2,380.16,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3267,7968,1063,40720,3133,2,67,2,79.84,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3268,7968,1063,40720,3133,2,13,1,460.00,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3269,7968,1064,40720,3133,2,96,2,809.91,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3270,7968,1064,40720,3133,2,67,2,170.09,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3271,7968,1064,40720,3133,2,13,1,980.00,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3272,7968,1065,40720,3133,2,96,2,809.92,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3273,7968,1065,40720,3133,2,67,2,170.08,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3274,7968,1065,40720,3133,2,13,1,980.00,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3275,7968,1066,40720,3133,2,96,2,2669.41,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3276,7968,1066,40720,3133,2,67,2,560.59,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3277,7968,1066,40720,3133,2,13,1,3230.00,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3278,7968,1067,40720,3133,2,96,2,917.35,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3279,7968,1067,40720,3133,2,67,2,192.65,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3280,7968,1067,40720,3133,2,13,1,1110.00,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3281,7968,1068,40720,3133,2,96,2,859.51,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3282,7968,1068,40720,3133,2,67,2,180.49,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3283,7968,1068,40720,3133,2,13,1,1040.00,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3284,7968,1069,40720,3133,2,96,2,1280.99,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3285,7968,1069,40720,3133,2,67,2,269.01,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3286,7968,1069,40720,3133,2,13,1,1550.00,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3287,7968,1070,40720,3133,2,96,2,388.43,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3288,7968,1070,40720,3133,2,67,2,81.57,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3289,7968,1070,40720,3133,2,13,1,470.00,NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(3290,7968,1071,40720,3133,2,96,2,1256.20,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3291,7968,1071,40720,3133,2,67,2,263.80,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3292,7968,1071,40720,3133,2,13,1,1520.00,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL);
INSERT INTO `balance_libro_details` VALUES (3293,7968,1072,40720,3133,2,96,2,652.89,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3294,7968,1072,40720,3133,2,67,2,137.11,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3295,7968,1072,40720,3133,2,13,1,790.00,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3296,7968,1073,40720,3133,2,96,2,1016.53,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3297,7968,1073,40720,3133,2,67,2,213.47,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3298,7968,1073,40720,3133,2,13,1,1230.00,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3299,7968,1074,40720,3133,2,96,2,1347.10,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3300,7968,1074,40720,3133,2,67,2,282.90,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3301,7968,1074,40720,3133,2,13,1,1630.00,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3302,7968,1075,40720,3133,2,96,2,2247.94,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3303,7968,1075,40720,3133,2,67,2,472.06,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3304,7968,1075,40720,3133,2,13,1,2720.00,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3305,7968,1076,40720,3133,2,96,2,2760.32,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3306,7968,1076,40720,3133,2,67,2,579.68,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3307,7968,1076,40720,3133,2,13,1,3340.00,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3308,7968,1077,40720,3133,2,96,2,2471.07,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3309,7968,1077,40720,3133,2,67,2,518.93,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3310,7968,1077,40720,3133,2,13,1,2990.00,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3311,7968,1078,40720,3133,2,96,2,1305.79,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3312,7968,1078,40720,3133,2,67,2,274.21,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3313,7968,1078,40720,3133,2,13,1,1580.00,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3314,7968,1079,40720,3133,2,96,2,1231.41,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3315,7968,1079,40720,3133,2,67,2,258.59,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3316,7968,1079,40720,3133,2,13,1,1490.00,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3317,7968,1080,40720,3133,2,96,2,975.21,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3318,7968,1080,40720,3133,2,67,2,204.79,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3319,7968,1080,40720,3133,2,13,1,1180.00,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3320,7968,1081,40720,3133,2,96,2,809.92,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3321,7968,1081,40720,3133,2,67,2,170.08,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3322,7968,1081,40720,3133,2,13,1,980.00,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3323,7968,1082,40720,3133,2,96,2,652.89,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3324,7968,1082,40720,3133,2,67,2,137.11,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3325,7968,1082,40720,3133,2,13,1,790.00,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3326,7968,1083,40720,3133,2,96,2,1818.18,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3327,7968,1083,40720,3133,2,67,2,381.82,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3328,7968,1083,40720,3133,2,13,1,2200.00,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3329,7968,1084,40720,3133,2,96,2,1644.63,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3330,7968,1084,40720,3133,2,67,2,345.37,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3331,7968,1084,40720,3133,2,13,1,1990.00,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3332,7968,1085,40720,3133,2,96,2,1619.83,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3333,7968,1085,40720,3133,2,67,2,340.17,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL);
INSERT INTO `balance_libro_details` VALUES (3334,7968,1085,40720,3133,2,13,1,1960.00,NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(3335,7968,1086,40720,3133,2,96,2,446.28,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3336,7968,1086,40720,3133,2,67,2,93.72,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3337,7968,1086,40720,3133,2,13,1,540.00,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3338,7968,1087,40720,3133,2,96,2,1231.40,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3339,7968,1087,40720,3133,2,67,2,258.60,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3340,7968,1087,40720,3133,2,13,1,1490.00,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3341,7968,1088,40720,3133,2,96,2,1636.37,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3342,7968,1088,40720,3133,2,67,2,343.63,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3343,7968,1088,40720,3133,2,13,1,1980.00,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3344,7968,1089,40720,3133,2,96,2,495.87,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3345,7968,1089,40720,3133,2,67,2,104.13,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3346,7968,1089,40720,3133,2,13,1,600.00,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3347,7968,1090,40720,3133,2,96,2,595.04,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3348,7968,1090,40720,3133,2,67,2,124.96,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3349,7968,1090,40720,3133,2,13,1,720.00,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3350,7968,1091,40720,3133,2,96,2,809.92,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3351,7968,1091,40720,3133,2,67,2,170.08,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3352,7968,1091,40720,3133,2,13,1,980.00,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3353,7968,1092,40720,3133,2,96,2,1305.79,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3354,7968,1092,40720,3133,2,67,2,274.21,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3355,7968,1092,40720,3133,2,13,1,1580.00,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3356,7968,1093,40720,3133,2,96,2,1719.01,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3357,7968,1093,40720,3133,2,67,2,360.99,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3358,7968,1093,40720,3133,2,13,1,2080.00,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3359,7968,1094,40720,3133,2,96,2,776.86,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3360,7968,1094,40720,3133,2,67,2,163.14,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3361,7968,1094,40720,3133,2,13,1,940.00,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3362,7968,1095,40720,3133,2,96,2,1057.85,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3363,7968,1095,40720,3133,2,67,2,222.15,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3364,7968,1095,40720,3133,2,13,1,1280.00,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3365,7968,1096,40720,3133,2,96,2,421.49,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3366,7968,1096,40720,3133,2,67,2,88.51,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3367,7968,1096,40720,3133,2,13,1,510.00,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3368,7968,1097,40720,3133,2,96,2,1115.70,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3369,7968,1097,40720,3133,2,67,2,234.30,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3370,7968,1097,40720,3133,2,13,1,1350.00,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3371,7968,1098,40720,3133,2,96,2,619.83,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3372,7968,1098,40720,3133,2,67,2,130.17,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3373,7968,1098,40720,3133,2,13,1,750.00,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3374,7968,1099,40720,3133,2,96,2,685.95,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL);
INSERT INTO `balance_libro_details` VALUES (3375,7968,1099,40720,3133,2,67,2,144.05,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(3376,7968,1099,40720,3133,2,13,1,830.00,NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL);
/*!40000 ALTER TABLE `balance_libro_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs`
--

DROP TABLE IF EXISTS `blogs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fecha` date NOT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `blogs_categoria_sub_id` int(10) unsigned NOT NULL,
  `path` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `titulo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `contenido` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autor` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `publicar` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  KEY `blogs_blogs_categoria_sub_id_foreign` (`blogs_categoria_sub_id`),
  CONSTRAINT `blogs_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`),
  CONSTRAINT `blogs_blogs_categoria_sub_id_foreign` FOREIGN KEY (`blogs_categoria_sub_id`) REFERENCES `blogs_categorias_sub` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs`
--

LOCK TABLES `blogs` WRITE;
/*!40000 ALTER TABLE `blogs` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias`
--

DROP TABLE IF EXISTS `blogs_categorias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias`
--

LOCK TABLES `blogs_categorias` WRITE;
/*!40000 ALTER TABLE `blogs_categorias` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias_sub`
--

DROP TABLE IF EXISTS `blogs_categorias_sub`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias_sub` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_categorias_sub_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  CONSTRAINT `blogs_categorias_sub_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias_sub`
--

LOCK TABLES `blogs_categorias_sub` WRITE;
/*!40000 ALTER TABLE `blogs_categorias_sub` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias_sub` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_alicuotas`
--

DROP TABLE IF EXISTS `bs_per_alicuotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_alicuotas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `anio` int(10) unsigned NOT NULL,
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `desde` decimal(16,2) NOT NULL DEFAULT '0.00',
  `hasta` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `mas_porcentaje` decimal(16,4) NOT NULL DEFAULT '0.0000',
  `excedente` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_alicuotas`
--

LOCK TABLES `bs_per_alicuotas` WRITE;
/*!40000 ALTER TABLE `bs_per_alicuotas` DISABLE KEYS */;
INSERT INTO `bs_per_alicuotas` VALUES (1,2017,950000.00,0.00,999999999.99,0.00,0.0050,950000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,2018,1050000.00,0.00,999999999.99,0.00,0.0025,1050000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,2019,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2019-11-19 21:09:50','2022-10-21 15:31:16',NULL),(4,2019,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2019-11-19 21:09:50','2022-10-21 15:31:16',NULL),(5,2019,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2019-11-19 21:09:50','2022-10-21 15:31:16',NULL),(6,2019,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-10-21 15:31:16','2022-10-21 15:31:16',NULL),(7,2020,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2022-10-21 15:31:22','2022-10-21 15:31:22',NULL),(8,2020,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2022-10-21 15:31:22','2022-10-21 15:31:22',NULL),(9,2020,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2022-10-21 15:31:22','2022-10-21 15:31:22',NULL),(10,2020,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-10-21 15:31:22','2022-10-21 15:31:22',NULL),(11,2021,6000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2022-10-21 15:31:29','2022-10-21 15:31:29',NULL),(12,2021,6000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2022-10-21 15:31:29','2022-10-21 15:31:29',NULL),(13,2021,6000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2022-10-21 15:31:29','2022-10-21 15:31:29',NULL),(14,2021,6000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-10-21 15:31:29','2022-10-21 15:31:29',NULL),(15,2022,11282141.08,0.00,5641070.54,0.00,0.0050,0.00,'2023-05-30 15:04:59','2023-05-30 15:04:59',NULL),(16,2022,11282141.08,5641070.54,12222319.51,28205.35,0.0075,5641070.54,'2023-05-30 15:04:59','2023-05-30 15:04:59',NULL),(17,2022,11282141.08,12222319.51,33846423.25,77564.72,0.0100,12222319.51,'2023-05-30 15:04:59','2023-05-30 15:04:59',NULL),(18,2022,11282141.08,33846423.25,188035684.71,293802.76,0.0125,33846423.25,'2023-05-30 15:04:59','2023-05-30 15:04:59',NULL),(19,2022,11282141.08,188035684.71,564107054.14,2221171.53,0.0150,188035684.71,'2023-05-30 15:04:59','2023-05-30 15:04:59',NULL),(20,2022,11282141.08,564107054.14,999999999999.00,7682242.07,0.0175,564107054.14,'2023-05-30 15:04:59','2023-05-30 15:04:59',NULL);
/*!40000 ALTER TABLE `bs_per_alicuotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_ddjjs`
--

DROP TABLE IF EXISTS `bs_per_ddjjs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_ddjjs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `anio` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `total_bienes_gravados` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total_bienes_exentos` decimal(16,2) NOT NULL DEFAULT '0.00',
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `base_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto_determinado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_pagar` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_favor` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_per_ddjjs_person_id_foreign` (`person_id`),
  CONSTRAINT `bs_per_ddjjs_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_ddjjs`
--

LOCK TABLES `bs_per_ddjjs` WRITE;
/*!40000 ALTER TABLE `bs_per_ddjjs` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_per_ddjjs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_conceptos`
--

DROP TABLE IF EXISTS `bs_pers_conceptos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_conceptos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_conceptos`
--

LOCK TABLES `bs_pers_conceptos` WRITE;
/*!40000 ALTER TABLE `bs_pers_conceptos` DISABLE KEYS */;
INSERT INTO `bs_pers_conceptos` VALUES (1,'Inmuebles',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,'Derechos Reales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,'Naves y Aeronaves',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(4,'Automotores y otros rodados',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(5,'Dinero y depósitos en dinero',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(6,'Títulos, acciones, cuotas o participaciones sociales y otros títulos valores',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(7,'Patrimonio de empresas o explotaciones unipersonales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(8,'Créditos y debentures',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(9,'Derechos de propiedad científica, literaria o artística, marcas, patentes y sus licencias',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(10,'Otros Bienes (incluye semovientes, antigüedades, objetos de colección, objetos de arte, ...)',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(11,'Objetos Personales y del Hogar',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL);
/*!40000 ALTER TABLE `bs_pers_conceptos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_anticipos`
--

DROP TABLE IF EXISTS `bs_pers_detail_anticipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_anticipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ganan_concepto_anticipo_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_anticipos_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` (`ganan_concepto_anticipo_id`),
  CONSTRAINT `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` FOREIGN KEY (`ganan_concepto_anticipo_id`) REFERENCES `ganan_conceptos_anticipos` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_anticipos`
--

LOCK TABLES `bs_pers_detail_anticipos` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_bienes`
--

DROP TABLE IF EXISTS `bs_pers_detail_bienes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_bienes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `bs_pers_concepto_id` int(10) unsigned NOT NULL,
  `concepto` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe_gravado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `importe_exento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_bienes_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` (`bs_pers_concepto_id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` FOREIGN KEY (`bs_pers_concepto_id`) REFERENCES `bs_pers_conceptos` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_bienes`
--

LOCK TABLES `bs_pers_detail_bienes` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calle`
--

DROP TABLE IF EXISTS `calle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calle` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `localidad_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `desdealt` int(10) unsigned DEFAULT NULL,
  `hastaalt` int(10) unsigned DEFAULT NULL,
  `codpostal` int(10) unsigned DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calle_localidad_id_foreign` (`localidad_id`),
  CONSTRAINT `calle_localidad_id_foreign` FOREIGN KEY (`localidad_id`) REFERENCES `localidad` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calle`
--

LOCK TABLES `calle` WRITE;
/*!40000 ALTER TABLE `calle` DISABLE KEYS */;
INSERT INTO `calle` VALUES (1,NULL,1,'Ramon Falcon',6800,7500,1408,1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL);
/*!40000 ALTER TABLE `calle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_iibb`
--

DROP TABLE IF EXISTS `categorias_iibb`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_iibb` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `impuesto` decimal(16,2) DEFAULT NULL,
  `anual` decimal(16,2) DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_iibb`
--

LOCK TABLES `categorias_iibb` WRITE;
/*!40000 ALTER TABLE `categorias_iibb` DISABLE KEYS */;
INSERT INTO `categorias_iibb` VALUES (1,'A',1850.00,11100.00,370000.00,30,3300,NULL,'1',NULL,'2022-10-21 15:31:31',NULL),(2,'B',2750.00,16500.00,550000.00,45,5000,NULL,'1',NULL,'2022-10-21 15:31:31',NULL),(3,'C',3850.00,23100.00,770000.00,60,6700,NULL,'1',NULL,'2022-10-21 15:31:31',NULL),(4,'D',5300.00,31800.00,1060000.00,85,10000,NULL,'1',NULL,'2022-10-21 15:31:31',NULL),(5,'E',7000.00,42000.00,1400000.00,110,13000,NULL,'1',NULL,'2022-10-21 15:31:31',NULL),(6,'F',8750.00,52500.00,1750000.00,150,16500,NULL,'1',NULL,'2022-10-21 15:31:31',NULL),(7,'G',10500.00,63000.00,2100000.00,200,20000,NULL,'1',NULL,'2022-10-21 15:31:31',NULL),(8,'H',13000.00,78000.00,2600000.00,200,20000,NULL,'1',NULL,'2022-10-21 15:31:31',NULL);
/*!40000 ALTER TABLE `categorias_iibb` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_monotributo`
--

DROP TABLE IF EXISTS `categorias_monotributo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_monotributo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `facMensual` decimal(16,2) DEFAULT NULL,
  `actividad` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `empleados` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `alquileres` decimal(16,2) DEFAULT NULL,
  `impuesto_servicio` decimal(16,2) DEFAULT NULL,
  `impuesto_venta` decimal(16,2) DEFAULT NULL,
  `sipa` decimal(16,2) DEFAULT NULL,
  `obraSocial` decimal(16,2) DEFAULT NULL,
  `totalServicio` decimal(16,2) DEFAULT NULL,
  `totalVenta` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `desde` date DEFAULT NULL,
  `hasta` date DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_monotributo`
--

LOCK TABLES `categorias_monotributo` WRITE;
/*!40000 ALTER TABLE `categorias_monotributo` DISABLE KEYS */;
INSERT INTO `categorias_monotributo` VALUES (1,'A',1414762.00,117896.00,'No Excluida','0',30,3330,230178.48,496.85,496.85,2192.15,3061.75,5750.75,5750.75,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(2,'B',2103025.00,175252.00,'No Excluida','0',45,5000,230178.48,957.27,957.27,2411.36,3061.75,6430.38,6430.38,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(3,'C',2944235.00,245352.00,'No Excluida','0',60,6700,460356.93,1636.83,1512.56,2652.52,3061.75,7351.10,7226.83,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(4,'D',3656604.00,304717.00,'No Excluida','0',85,10000,460356.93,2689.05,2484.46,2917.75,3638.26,9245.06,9040.47,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(5,'E',4305799.00,358816.00,'No Excluida','0',110,13000,573619.32,5115.04,3967.80,3209.55,4452.02,12776.61,11629.37,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(6,'F',5382248.00,448520.00,'No Excluida','0',150,16500,575446.12,7036.89,5180.81,3530.49,5145.02,15712.40,13856.32,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(7,'G',6458698.00,538224.00,'No Excluida','0',200,20000,690535.39,8951.39,6459.54,3883.53,5512.52,18347.44,15855.59,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(8,'H',7996484.00,666373.00,'No Excluida','0',200,20000,920713.84,20460.26,15856.76,4271.88,6615.02,31347.16,26743.66,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(9,'I',8949911.00,745825.00,'Venta de Bs Muebles','0',200,20000,920713.84,NULL,25575.36,4699.08,8190.03,NULL,38464.47,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(10,'J',10257028.00,854752.00,'Venta de Bs Muebles','0',200,20000,920713.84,NULL,30054.72,5169.03,9166.53,NULL,44390.28,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(11,'K',11379612.00,948301.00,'Venta de Bs Muebles','0',200,20000,920713.84,NULL,34526.76,5685.87,10505.29,NULL,50717.92,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(12,'Monotributo Social',1414762.00,117896.00,'No Excluida','0',0,0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,NULL,'2018-01-01',NULL,'1','2020-02-27 02:46:40','2020-02-27 02:46:40',NULL),(13,'A Exento',1414762.00,117896.00,NULL,NULL,NULL,NULL,230178.48,0.00,0.00,2192.15,3061.75,5253.90,5253.90,'',NULL,NULL,'0',NULL,NULL,NULL),(14,'B Exento',2103025.00,175252.00,NULL,NULL,NULL,NULL,230178.48,0.00,0.00,2411.36,3061.75,5473.11,5473.11,'',NULL,NULL,'0',NULL,NULL,NULL);
/*!40000 ALTER TABLE `categorias_monotributo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `charlas_details`
--

DROP TABLE IF EXISTS `charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `charla` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `charlas_details`
--

LOCK TABLES `charlas_details` WRITE;
/*!40000 ALTER TABLE `charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `charlas_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `CharlaDetail_BD` BEFORE DELETE ON `charlas_details` FOR EACH ROW insert into back_up_charlas_details (charla,person_id,modificado)
values(old.charla,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `chequeras_tipos`
--

DROP TABLE IF EXISTS `chequeras_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `chequeras_tipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chequeras_tipos`
--

LOCK TABLES `chequeras_tipos` WRITE;
/*!40000 ALTER TABLE `chequeras_tipos` DISABLE KEYS */;
INSERT INTO `chequeras_tipos` VALUES (1,NULL,'Fisica',1,NULL,NULL,NULL),(2,NULL,'Electronica',1,NULL,NULL,NULL),(3,NULL,'Transferencias',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `chequeras_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cheques_transfer_emitidas`
--

DROP TABLE IF EXISTS `cheques_transfer_emitidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cheques_transfer_emitidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_cliente_detail_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_detail_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_banco_cheq_id` int(10) unsigned NOT NULL,
  `fecha_emision` date NOT NULL,
  `fecha_cobro` date NOT NULL,
  `numero_cheque` int(11) NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cheques_transfer_emitidas_person_id_foreign` (`person_id`),
  KEY `cheques_transfer_emitidas_cta_cte_cliente_detail_id_foreign` (`cta_cte_cliente_detail_id`),
  KEY `cheques_transfer_emitidas_cta_cte_tesoreria_detail_id_foreign` (`cta_cte_tesoreria_detail_id`),
  KEY `cheques_transfer_emitidas_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cte_tes_ban_che_id_foreign` (`cta_cte_tesoreria_banco_cheq_id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_cliente_detail_id_foreign` FOREIGN KEY (`cta_cte_cliente_detail_id`) REFERENCES `cta_cte_cliente_details` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_tesoreria_detail_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_detail_id`) REFERENCES `cta_cte_tesoreria_detail` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cte_tes_ban_che_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_banco_cheq_id`) REFERENCES `cta_cte_tesoreria_banco_cheq` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cheques_transfer_emitidas`
--

LOCK TABLES `cheques_transfer_emitidas` WRITE;
/*!40000 ALTER TABLE `cheques_transfer_emitidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `cheques_transfer_emitidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claves`
--

DROP TABLE IF EXISTS `claves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves`
--

LOCK TABLES `claves` WRITE;
/*!40000 ALTER TABLE `claves` DISABLE KEYS */;
INSERT INTO `claves` VALUES (1,NULL,'Clave Fiscal',NULL,NULL,NULL),(2,NULL,'Clave Ciudad',NULL,NULL,NULL),(3,NULL,'Clave ARBA',NULL,NULL,NULL),(4,NULL,'Clave ANSES',NULL,NULL,NULL),(5,NULL,'Catedral',NULL,NULL,NULL),(6,NULL,'CEMIBA',NULL,NULL,NULL),(7,NULL,'COMPRA ARG',NULL,NULL,NULL),(8,NULL,'Consejo Ciencias Economicas',NULL,NULL,NULL),(9,NULL,'Correo',NULL,NULL,NULL),(10,NULL,'CUR',NULL,NULL,NULL),(11,NULL,'Firma Digital',NULL,NULL,NULL),(12,NULL,'Interbanking',NULL,NULL,NULL),(13,NULL,'Banco Citibank',NULL,NULL,NULL),(14,NULL,'Banco Ciudad',NULL,NULL,NULL),(15,NULL,'Banco Frances',NULL,NULL,NULL),(16,NULL,'Banco Galicia',NULL,NULL,NULL),(17,NULL,'Banco HSBC',NULL,NULL,NULL),(18,NULL,'Banco Itau',NULL,NULL,NULL),(19,NULL,'Banco Nacion',NULL,NULL,NULL),(20,NULL,'Banco Macro',NULL,NULL,NULL),(21,NULL,'Banco Patagonia',NULL,NULL,NULL),(22,NULL,'Banco Provincia',NULL,NULL,NULL),(23,NULL,'Banco Santander',NULL,NULL,NULL),(24,NULL,'Banco Supervielle',NULL,NULL,NULL),(25,NULL,'Seguridad e Higiene',NULL,NULL,NULL),(26,NULL,'Sindicato - ANSES',NULL,NULL,NULL),(27,NULL,'Sindicato - AOT',NULL,NULL,NULL),(28,NULL,'Sindicato - ATSA',NULL,NULL,NULL),(29,NULL,'Sindicato - Camioneros',NULL,NULL,NULL),(30,NULL,'Sindicato - Guinchero',NULL,NULL,NULL),(31,NULL,'Sindicato - IERIC',NULL,NULL,NULL),(32,NULL,'Sindicato - La Estrella',NULL,NULL,NULL),(33,NULL,'Sindicato - Nemesis',NULL,NULL,NULL),(34,NULL,'Sindicato - Pasta',NULL,NULL,NULL),(35,NULL,'Sindicato - SEC',NULL,NULL,NULL),(36,NULL,'Sindicato - SICOP',NULL,NULL,NULL),(37,NULL,'Sindicato - SOCAYA',NULL,NULL,NULL),(38,NULL,'Sindicato - UTHGRA',NULL,NULL,NULL),(39,NULL,'Sindicato - INACAP',NULL,NULL,NULL),(40,NULL,'Sindicato - Otro',NULL,NULL,NULL),(41,NULL,'Otra',NULL,NULL,NULL),(42,NULL,'Prisma - Firma Digital',NULL,NULL,NULL),(43,NULL,'Sindicato - FATSA',NULL,NULL,NULL);
/*!40000 ALTER TABLE `claves` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claves_details`
--

DROP TABLE IF EXISTS `claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `claves_details_clave_id_foreign` (`clave_id`),
  KEY `claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_details`
--

LOCK TABLES `claves_details` WRITE;
/*!40000 ALTER TABLE `claves_details` DISABLE KEYS */;
INSERT INTO `claves_details` VALUES (4,7968,'Afip','Juan141184',NULL,1,40720,1,'2022-10-22 12:49:22','2022-10-22 12:49:22',NULL),(5,7968,NULL,'1966Silvia',NULL,1,40732,1,'2022-10-24 16:29:31','2022-10-24 16:29:31',NULL);
/*!40000 ALTER TABLE `claves_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `ClavesDetail_BD` BEFORE DELETE ON `claves_details` FOR EACH ROW insert into back_up_claves_details (clave,valor,comentario,clave_id,person_id,modificado)
values(old.clave,old.valor,old.comentario,old.clave_id,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `claves_mails`
--

DROP TABLE IF EXISTS `claves_mails`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_mails` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_mails`
--

LOCK TABLES `claves_mails` WRITE;
/*!40000 ALTER TABLE `claves_mails` DISABLE KEYS */;
INSERT INTO `claves_mails` VALUES (1,'Listado de Claves',1,'Claves','claves_mails/claves_listado',NULL,NULL),(3,'Listado de Mails',2,'Mails','claves_mails/mails_listado',NULL,NULL),(5,'Listado de Charlas',3,'Charlas','claves_mails/charlas_listado',NULL,NULL);
/*!40000 ALTER TABLE `claves_mails` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cm_articulos_regimenes`
--

DROP TABLE IF EXISTS `cm_articulos_regimenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cm_articulos_regimenes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `codigo` int(11) DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cm_articulos_regimenes`
--

LOCK TABLES `cm_articulos_regimenes` WRITE;
/*!40000 ALTER TABLE `cm_articulos_regimenes` DISABLE KEYS */;
INSERT INTO `cm_articulos_regimenes` VALUES (1,NULL,'Articulo 2',2,1,'2022-10-21 15:31:22','2022-10-21 15:31:22',NULL),(2,NULL,'Articulo 6',6,0,'2022-10-21 15:31:22','2022-10-21 15:31:22',NULL),(3,NULL,'Articulo 7',7,0,'2022-10-21 15:31:22','2022-10-21 15:31:22',NULL),(4,NULL,'Articulo 8',8,0,'2022-10-21 15:31:22','2022-10-21 15:31:22',NULL),(5,NULL,'Articulo 9',9,0,'2022-10-21 15:31:22','2022-10-21 15:31:22',NULL),(6,NULL,'Articulo 10',10,0,'2022-10-21 15:31:22','2022-10-21 15:31:22',NULL),(7,NULL,'Articulo 11',11,0,'2022-10-21 15:31:22','2022-10-21 15:31:22',NULL),(8,NULL,'Articulo 12',12,0,'2022-10-21 15:31:22','2022-10-21 15:31:22',NULL),(9,NULL,'Articulo 13',13,0,'2022-10-21 15:31:22','2022-10-21 15:31:22',NULL),(10,NULL,'Articulo 14',14,1,'2022-10-21 15:31:22','2022-10-21 15:31:22',NULL);
/*!40000 ALTER TABLE `cm_articulos_regimenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores`
--

DROP TABLE IF EXISTS `cobradores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores`
--

LOCK TABLES `cobradores` WRITE;
/*!40000 ALTER TABLE `cobradores` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condicion_frente_al_iva`
--

DROP TABLE IF EXISTS `condicion_frente_al_iva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condicion_frente_al_iva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `codigo_afip` int(11) DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `show_comprobantes_a` tinyint(1) NOT NULL DEFAULT '0',
  `show_comprobantes_b` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condicion_frente_al_iva`
--

LOCK TABLES `condicion_frente_al_iva` WRITE;
/*!40000 ALTER TABLE `condicion_frente_al_iva` DISABLE KEYS */;
INSERT INTO `condicion_frente_al_iva` VALUES (1,NULL,1,'IVA Responsable Inscripto',1,0,1,NULL,NULL,NULL),(2,NULL,2,'IVA Responsable no Inscripto',0,0,1,NULL,NULL,NULL),(3,NULL,3,'IVA no Responsable',0,0,1,NULL,NULL,NULL),(4,NULL,4,'IVA Sujeto Exento',0,1,1,NULL,NULL,NULL),(5,NULL,5,'Consumidor Final',0,1,1,NULL,NULL,NULL),(6,NULL,6,'Responsable Monotributo',1,0,1,NULL,NULL,NULL),(7,NULL,7,'Sujeto no Categorizado',0,1,1,NULL,NULL,NULL),(8,NULL,8,'Proveedor del Exterior',0,1,1,NULL,NULL,NULL),(9,NULL,9,'Cliente del Exterior',0,1,1,NULL,NULL,NULL),(10,NULL,10,'IVA Liberado – Ley Nº 19.640',0,1,1,NULL,NULL,NULL),(11,NULL,11,'IVA Responsable Inscripto – Agente de Percepción',0,0,1,NULL,NULL,NULL),(12,NULL,12,'Pequeño Contribuyente Eventual',0,0,1,NULL,NULL,NULL),(13,NULL,13,'Monotributista Social',1,0,1,NULL,NULL,NULL),(14,NULL,14,'Pequeño Contribuyente Eventual Social',0,0,1,NULL,NULL,NULL),(15,NULL,NULL,'Monotributista Trabajador Independiente Promovido',1,0,1,NULL,NULL,NULL),(16,NULL,NULL,'IVA No Alcanzado',0,1,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `condicion_frente_al_iva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condiciones_venta`
--

DROP TABLE IF EXISTS `condiciones_venta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condiciones_venta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condiciones_venta`
--

LOCK TABLES `condiciones_venta` WRITE;
/*!40000 ALTER TABLE `condiciones_venta` DISABLE KEYS */;
INSERT INTO `condiciones_venta` VALUES (1,'Contado',NULL,NULL),(2,'Tarjeta de Debito',NULL,NULL),(3,'Tarjeta de Credito',NULL,NULL),(4,'Cuenta Corriente',NULL,NULL),(5,'Cheque',NULL,NULL),(6,'Ticket',NULL,NULL),(7,'Transferencia',NULL,NULL),(8,'Otra',NULL,NULL);
/*!40000 ALTER TABLE `condiciones_venta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consultas`
--

DROP TABLE IF EXISTS `consultas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consultas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consultas`
--

LOCK TABLES `consultas` WRITE;
/*!40000 ALTER TABLE `consultas` DISABLE KEYS */;
INSERT INTO `consultas` VALUES (1,NULL,'Estado Liquidaciones',1,NULL,NULL,NULL),(2,NULL,'Consumo',1,NULL,NULL,NULL),(3,NULL,'Resultado Liquidacion Hijas',1,'2023-03-12 23:44:28','2023-03-12 23:44:28',NULL);
/*!40000 ALTER TABLE `consultas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consultas_aux`
--

DROP TABLE IF EXISTS `consultas_aux`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consultas_aux` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `consulta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `estado` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `consultas_aux_consulta_id_foreign` (`consulta_id`),
  KEY `consultas_aux_person_id_foreign` (`person_id`),
  CONSTRAINT `consultas_aux_consulta_id_foreign` FOREIGN KEY (`consulta_id`) REFERENCES `consultas` (`id`),
  CONSTRAINT `consultas_aux_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consultas_aux`
--

LOCK TABLES `consultas_aux` WRITE;
/*!40000 ALTER TABLE `consultas_aux` DISABLE KEYS */;
INSERT INTO `consultas_aux` VALUES (1,NULL,1,NULL,'[{\"id\":40720,\"user_id\":7968,\"field_name1\":\"Olga\\u00b4s Deli SRL\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"30-71519542-5\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2022-10-22T14:58:47.000000Z\",\"updated_at\":\"2022-10-22T14:58:47.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":2,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iva\":\"Pendiente\",\"status_liq_iibb\":\"Pendiente\",\"status_liq_sueldos\":\"Sin Usar\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":3,\"user_id\":7968,\"person_id\":40720,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2022-10-22T14:58:48.000000Z\",\"updated_at\":\"2022-10-22T15:14:26.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"25900.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":2,\"obligation_sell\":1,\"obligation_buy\":1,\"obligation_iva\":1,\"obligation_electronic_receipt\":1,\"obligation_iibb\":2,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2016-01\",\"obligation_salaries\":1,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":1,\"person_id_administrador\":40720,\"person_id_titular\":40720,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2016-04-19T03:00:00.000000Z\",\"iibb\":\"30715195425\",\"fe_leyenda\":null,\"atencion_iva\":1,\"atencion_iva_comentario\":null,\"atencion_iibb\":1,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":null,\"periods\":[{\"id\":3134,\"user_id\":null,\"code\":\"2022-09\",\"year\":2022,\"period_number\":9,\"date_from\":\"2022-09-01\",\"date_to\":\"2022-09-30\",\"created_at\":null,\"updated_at\":null,\"person_id\":40720,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]}]',1,'2022-10-22 12:18:41','2022-10-22 12:18:41',NULL);
/*!40000 ALTER TABLE `consultas_aux` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_asientos`
--

DROP TABLE IF EXISTS `conta_asientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_asientos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `debe_cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `haber_cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `ctactecheque_id` int(10) unsigned DEFAULT NULL,
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `adjunto` text COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `radioChecked` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `CuentaTipo_id` int(10) unsigned DEFAULT NULL,
  `CentroCosto_id` int(10) unsigned DEFAULT NULL,
  `pagado` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_asientos_person_id_foreign` (`person_id`),
  KEY `conta_asientos_period_id_foreign` (`period_id`),
  KEY `conta_asientos_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `conta_asientos_cuentatipo_id_foreign` (`CuentaTipo_id`),
  KEY `conta_asientos_centrocosto_id_foreign` (`CentroCosto_id`),
  KEY `conta_asientos_ctactecheque_id_foreign` (`ctactecheque_id`),
  KEY `conta_asientos_haber_cta_cte_tesoreria_cuenta_id_foreign` (`haber_cta_cte_tesoreria_cuenta_id`),
  KEY `conta_asientos_debe_cta_cte_tesoreria_cuenta_id_foreign` (`debe_cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `conta_asientos_centrocosto_id_foreign` FOREIGN KEY (`CentroCosto_id`) REFERENCES `ctactegastos_centrocosto` (`id`),
  CONSTRAINT `conta_asientos_ctactecheque_id_foreign` FOREIGN KEY (`ctactecheque_id`) REFERENCES `ctacte_cheques` (`id`),
  CONSTRAINT `conta_asientos_cuentatipo_id_foreign` FOREIGN KEY (`CuentaTipo_id`) REFERENCES `ctactegastos_cuenta_tipo` (`idCuentaTipo`),
  CONSTRAINT `conta_asientos_debe_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`debe_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_haber_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`haber_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `conta_asientos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `conta_asientos_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_asientos`
--

LOCK TABLES `conta_asientos` WRITE;
/*!40000 ALTER TABLE `conta_asientos` DISABLE KEYS */;
INSERT INTO `conta_asientos` VALUES (1,7968,40720,NULL,2,NULL,NULL,NULL,NULL,'2022-10-22','2022-10-22',2590.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2022-10-22 12:13:05','2022-10-22 12:13:44','2022-10-22 12:13:44'),(2,7968,40720,NULL,2,13,480,NULL,NULL,'2022-09-30','2022-10-22',25900.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2022-10-22 12:13:44','2022-10-22 12:13:55','2022-10-22 12:13:55'),(3,7968,40720,NULL,2,13,480,NULL,NULL,'2022-09-30','2022-10-22',25900.00,NULL,'Honorario Mensual',1,1,NULL,NULL,NULL,'2022-10-22 12:13:55','2022-10-22 12:13:55',NULL);
/*!40000 ALTER TABLE `conta_asientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_asientos_details`
--

DROP TABLE IF EXISTS `conta_asientos_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_asientos_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_asientos_details_conta_asiento_id_foreign` (`conta_asiento_id`),
  KEY `conta_asientos_details_person_id_foreign` (`person_id`),
  KEY `conta_asientos_details_period_id_foreign` (`period_id`),
  KEY `conta_asientos_details_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `conta_asientos_details_saldo_id_foreign` (`saldo_id`),
  KEY `conta_asientos_details_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `conta_asientos_details_conta_asiento_id_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `conta_asientos_details_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `conta_asientos_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `conta_asientos_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `conta_asientos_details_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_asientos_details`
--

LOCK TABLES `conta_asientos_details` WRITE;
/*!40000 ALTER TABLE `conta_asientos_details` DISABLE KEYS */;
INSERT INTO `conta_asientos_details` VALUES (1,7968,1,40720,NULL,2,13,1,2590.00,'2022-10-22 12:13:05','2022-10-22 12:13:44','2022-10-22 12:13:44'),(2,7968,1,40720,NULL,2,480,2,2590.00,'2022-10-22 12:13:05','2022-10-22 12:13:44','2022-10-22 12:13:44'),(3,7968,2,40720,NULL,2,13,1,25900.00,'2022-10-22 12:13:44','2022-10-22 12:13:55','2022-10-22 12:13:55'),(4,7968,2,40720,NULL,2,480,2,25900.00,'2022-10-22 12:13:44','2022-10-22 12:13:55','2022-10-22 12:13:55'),(5,7968,3,40720,NULL,2,13,1,25900.00,'2022-10-22 12:13:55','2022-10-22 12:13:55',NULL),(6,7968,3,40720,NULL,2,480,2,25900.00,'2022-10-22 12:13:55','2022-10-22 12:13:55',NULL);
/*!40000 ALTER TABLE `conta_asientos_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_centro_costo_plan_cuenta`
--

DROP TABLE IF EXISTS `conta_centro_costo_plan_cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_centro_costo_plan_cuenta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_centro_costo_id` bigint(20) unsigned DEFAULT NULL,
  `conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_centro_costo_plan_cuenta_conta_centro_costo_id_foreign` (`conta_centro_costo_id`),
  KEY `conta_centro_costo_plan_cuenta_conta_plan_cuenta_id_foreign` (`conta_plan_cuenta_id`),
  CONSTRAINT `conta_centro_costo_plan_cuenta_conta_centro_costo_id_foreign` FOREIGN KEY (`conta_centro_costo_id`) REFERENCES `conta_centro_costos` (`id`),
  CONSTRAINT `conta_centro_costo_plan_cuenta_conta_plan_cuenta_id_foreign` FOREIGN KEY (`conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_centro_costo_plan_cuenta`
--

LOCK TABLES `conta_centro_costo_plan_cuenta` WRITE;
/*!40000 ALTER TABLE `conta_centro_costo_plan_cuenta` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_centro_costo_plan_cuenta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_centro_costos`
--

DROP TABLE IF EXISTS `conta_centro_costos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_centro_costos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_centro_costos_person_id_foreign` (`person_id`),
  CONSTRAINT `conta_centro_costos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_centro_costos`
--

LOCK TABLES `conta_centro_costos` WRITE;
/*!40000 ALTER TABLE `conta_centro_costos` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_centro_costos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_plan_cuenta`
--

DROP TABLE IF EXISTS `conta_plan_cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_plan_cuenta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `codigo` int(11) NOT NULL,
  `tipo_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `padre` int(11) NOT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rubro` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `no_editable` int(11) NOT NULL DEFAULT '1',
  `tes_cta_cte` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_origen` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_destino` tinyint(1) NOT NULL DEFAULT '0',
  `conta_asientos` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_plan_cuenta_tipo_cuenta_id_foreign` (`tipo_cuenta_id`),
  KEY `conta_plan_cuenta_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `conta_plan_cuenta_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `conta_plan_cuenta_tipo_cuenta_id_foreign` FOREIGN KEY (`tipo_cuenta_id`) REFERENCES `conta_tipo_cuentas` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=483 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_plan_cuenta`
--

LOCK TABLES `conta_plan_cuenta` WRITE;
/*!40000 ALTER TABLE `conta_plan_cuenta` DISABLE KEYS */;
INSERT INTO `conta_plan_cuenta` VALUES (1,NULL,1000000,1,1,0,'ACTIVO','Activo',NULL,1,1,0,0,0,0,NULL),(2,NULL,1100000,2,1,1000000,'ACTIVO CORRIENTE','Activo',NULL,1,1,0,0,0,0,NULL),(3,NULL,1110000,3,1,1100000,'CAJA Y BANCOS','Activo',NULL,1,1,0,0,0,0,NULL),(4,NULL,1110100,4,1,1110000,'CAJAS','Activo',NULL,1,1,0,0,0,0,NULL),(5,NULL,1110101,5,1,1110100,'Caja Oficina','Activo',NULL,0,1,0,0,0,0,NULL),(6,NULL,1110102,5,1,1110100,'Caja Casa','Activo',NULL,0,1,0,0,0,0,NULL),(7,NULL,1110103,5,1,1110100,'Caja Dolares Casa','Activo',NULL,0,1,0,0,0,0,NULL),(8,NULL,1110104,5,1,1110100,'Banco Santander 015-372795/5','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(9,NULL,1110200,4,1,1110000,'BANCOS','Activo',NULL,1,1,0,0,0,0,NULL),(10,NULL,1110201,5,1,1110200,'Banco Santander Rio Cta Corriente','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(11,NULL,1110202,5,1,1110200,'Banco Santander Rio Cta Corriente DOLARES','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(12,NULL,1130000,3,1,1100000,'CREDITOS POR VENTAS','Activo',NULL,1,1,0,0,0,0,NULL),(13,NULL,1130101,5,1,1130100,'Clientes - Deudores','Activo',NULL,1,2,0,0,0,1,NULL),(14,NULL,1130102,5,1,1130100,'Deudores por ventas comunes','Activo',NULL,1,1,0,0,0,1,NULL),(15,NULL,1130103,5,1,1130100,'Deudores por ventas morosos','Activo',NULL,1,1,0,0,0,1,NULL),(16,NULL,1130104,5,1,1130100,'Deudores en gestión judicial','Activo',NULL,1,1,0,0,0,1,NULL),(17,NULL,1130105,5,1,1130100,'Previsión deudores incobrables','Activo',NULL,1,1,0,0,0,1,NULL),(18,NULL,1140000,3,1,1100000,'OTROS CREDITOS','Activo',NULL,1,1,0,0,0,0,NULL),(19,NULL,1140100,4,1,1140000,'Retenciones Sufridas','Activo',NULL,1,1,0,0,0,0,NULL),(20,NULL,1140301,5,1,1140300,'Anticipos Impuesto a las Ganancias','Activo',NULL,1,2,0,0,1,1,NULL),(21,NULL,1140102,5,1,1140100,'Retenciones Ingr. Brutos','Activo',NULL,0,1,0,0,0,0,NULL),(22,NULL,1140329,5,1,1140300,'Anticipo Impto.Ganancia Mínima Presunta','Activo',NULL,1,1,0,0,0,1,NULL),(23,NULL,1140105,5,1,1140100,'Retenciones Impuesto a las Ganancias','Activo',NULL,1,2,1,0,0,1,NULL),(24,NULL,1140106,5,1,1140100,'Impuesto a las Ganancias (Saldo a favor)','Activo',NULL,1,1,0,0,0,1,NULL),(25,NULL,1140107,5,1,1140100,'Retenciones de IVA','Activo',NULL,1,2,1,0,0,1,NULL),(26,NULL,1140200,4,1,1140000,'CREDITOS DIVERSOS','Activo',NULL,1,1,0,0,0,0,NULL),(27,NULL,1140201,5,1,1140200,'Anticipos de proveedores','Activo',NULL,1,1,0,0,0,1,NULL),(28,NULL,1140205,5,1,1140200,'Depósito en garantía alquileres','Activo',NULL,1,1,0,0,0,1,NULL),(29,NULL,1140206,5,1,1140200,'Derechos adquiridos a devengar','Activo',NULL,1,1,0,0,0,1,NULL),(30,NULL,1140207,5,1,1140200,'Intereses a devengar','Activo',NULL,1,1,0,0,0,1,NULL),(31,NULL,1140208,5,1,1140200,'Cuentas a rendir - Directores','Activo',NULL,1,1,0,0,0,1,NULL),(32,NULL,1140210,5,1,1140200,'Alquileres no devengados','Activo',NULL,1,1,0,0,0,1,NULL),(33,NULL,1150000,3,1,1100000,'BIENES DE CAMBIO','Activo',NULL,1,1,0,0,0,0,NULL),(34,NULL,1150400,4,1,1150000,'MERCADERIA DE REVENTA','Activo',NULL,1,1,0,0,0,0,NULL),(35,NULL,1200000,2,1,1000000,'ACTIVO NO CORRIENTE','Activo',NULL,1,1,0,0,0,0,NULL),(36,NULL,1220000,3,1,1200000,'BIENES DE USO','Activo',NULL,1,1,0,0,0,0,NULL),(37,NULL,1220100,4,1,1220000,'EQUIPOS DE COMPUTACION','Activo',NULL,1,1,0,0,0,0,NULL),(38,NULL,1220101,5,1,1220100,'Equipos de computación valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(39,NULL,1220102,5,1,1220100,'Equipos de computación ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(40,NULL,1220108,5,1,1220100,'Amortización Acumulada Equipos de comput.','Activo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(41,NULL,1220200,4,1,1220000,'INSTALACIONES','Activo',NULL,1,1,0,0,0,0,NULL),(42,NULL,1220201,5,1,1220200,'Instalaciones valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(43,NULL,1220202,5,1,1220200,'Instalaciones ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(44,NULL,1220206,5,1,1220200,'Amortización Acumulada Instalaciones','Activo',NULL,1,1,0,0,0,1,NULL),(45,NULL,1220300,4,1,1220000,'MUEBLES Y UTILES','Activo',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (46,NULL,1220301,5,1,1220300,'Muebles y utiles valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(47,NULL,1220302,5,1,1220300,'Muebles y utiles ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(48,NULL,1220306,5,1,1220300,'Amortización Acumulada Muebles y Útiles','Activo',NULL,1,1,0,0,0,1,NULL),(49,NULL,1230000,3,1,1200000,'ACTIVOS INTANGIBLES','Activo',NULL,1,1,0,0,0,0,NULL),(50,NULL,1230101,5,1,1230100,'Gastos de organización valores historicos','Activo',NULL,1,1,0,0,0,1,NULL),(51,NULL,1230102,5,1,1230100,'Gastos de organización ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(52,NULL,1230103,5,1,1230100,'Amortización acumulada gs. de organización','Activo',NULL,1,1,0,0,0,1,NULL),(53,NULL,2000000,1,2,0,'PASIVO','Pasivo',NULL,1,1,0,0,0,0,NULL),(54,NULL,2100000,2,2,2000000,'PASIVO CORRIENTE','Pasivo',NULL,1,1,0,0,0,0,NULL),(55,NULL,2110000,3,2,2100000,'Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(56,NULL,2110100,4,2,2110000,'Comerciales','Pasivo',NULL,1,1,0,0,0,0,NULL),(57,NULL,2110101,5,2,2110100,'Proveedores en Cta. Cte. locales','Pasivo',NULL,1,2,0,0,0,1,NULL),(58,NULL,2110102,5,2,2110100,'Proveedores en cta. cte. exterior','Pasivo',NULL,1,1,0,0,0,1,NULL),(59,NULL,2110103,5,2,2110100,'Derechos de exhibición a devengar','Pasivo',NULL,1,1,0,0,0,1,NULL),(60,NULL,2110104,5,2,2110100,'Cheques emitidos ','Pasivo',NULL,1,2,1,1,1,1,NULL),(61,NULL,2110200,4,2,2110000,'REMUNERACIONES Y CARGAS SOCIALES','Pasivo',NULL,1,1,0,0,0,0,NULL),(62,NULL,2110201,5,2,2110200,'Sueldos y Jornales a pagar','Pasivo',NULL,1,2,0,0,1,1,NULL),(63,NULL,2110202,5,2,2110200,'Cargas sociales a pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(64,NULL,2110203,5,2,2110200,'Sindicatos a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(65,NULL,2110300,4,2,2110000,'CARGAS FISCALES','Pasivo',NULL,1,1,0,0,0,0,NULL),(67,NULL,2110301,5,2,2110300,'IVA Debito Fiscal','Pasivo',NULL,1,2,0,0,0,1,NULL),(68,NULL,1140222,5,1,1140200,'IVA Credito Fiscal','Activo',NULL,1,2,0,0,0,1,NULL),(69,NULL,2110303,5,2,2110300,'Impuestos Internos','Pasivo',NULL,1,1,0,0,0,1,NULL),(70,NULL,2110304,5,2,2110300,'Impuestos al Combustible','Pasivo',NULL,1,1,0,0,0,1,NULL),(71,NULL,2110601,5,2,2110600,'IVA Retenciones de terceros','Pasivo',NULL,1,1,0,0,0,1,NULL),(72,NULL,2110306,5,2,2110300,'IVA Percepciones realiz.por terceros','Pasivo',NULL,1,2,0,0,0,1,NULL),(73,NULL,2110307,5,2,2110300,'IVA Saldo a favor','Pasivo',NULL,1,1,0,0,0,1,NULL),(74,NULL,2110308,5,2,2110300,'IVA a pagar','Pasivo',NULL,1,2,0,0,0,1,NULL),(75,NULL,2110309,5,2,2110300,'Percepciones Ingresos Brutos','Pasivo',NULL,1,1,0,0,0,1,NULL),(76,NULL,2110310,5,2,2110300,'Otros Pagos AFIP','Pasivo',NULL,1,1,0,0,0,1,NULL),(78,NULL,2110350,5,2,2110300,'Impuesto a los Ingresos Brutos Pasivo','Pasivo',NULL,1,1,0,0,0,1,NULL),(79,NULL,2110313,5,2,2110300,'Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(80,NULL,2110314,5,2,2110300,'Impuesto a la Ganancia Mínima Presunta','Pasivo',NULL,1,1,0,0,0,1,NULL),(81,NULL,2110602,5,2,2110600,'AFIP - Retenciones Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(82,NULL,2110316,5,2,2110300,'AFIP - Plan de Facilidades Decreto 338/02','Pasivo',NULL,1,1,0,0,0,1,NULL),(83,NULL,2200000,2,2,2000000,'PASIVO NO CORRIENTE','Pasivo',NULL,1,1,0,0,0,0,NULL),(84,NULL,3000000,1,2,0,'PATRIMONIO NETO','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(85,NULL,3100000,2,2,3000000,'APORTE DE LOS PROPIETARIOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(86,NULL,3110100,4,2,3110000,'CAPITAL SOCIAL','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(87,NULL,3110101,5,2,3110100,'Acciones en circulación','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(88,NULL,3110102,5,2,3110100,'Ajuste del Capital','Patrimonio Neto',NULL,1,2,0,0,0,1,NULL),(89,NULL,3110103,5,2,3110100,'Aportes Irrevocables Futuras Suscripciones','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(90,NULL,3400000,2,2,3000000,'RESULTADOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(91,NULL,3410101,5,2,3410100,'Resultado del ejercicio','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (92,NULL,3410102,5,2,3410100,'Resultado ejercicios anteriores','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(93,NULL,3410103,5,2,3410100,'A.R.E.A.','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(94,NULL,4000000,1,2,0,'INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(95,NULL,4100000,2,2,4000000,'INGRESOS ORDINARIOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(96,NULL,4110101,5,2,4110100,'VENTAS','Result. Positivo',NULL,1,2,0,0,0,1,NULL),(97,NULL,4110102,5,2,4110100,'Honorarios','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(98,NULL,4110103,5,2,4110100,'Sueldo Vane','Result. Positivo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(99,NULL,4110104,5,2,4110100,'Descuentos obtenidos','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(100,NULL,4110105,5,2,4110100,'Reintegros por exportaciones','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(101,NULL,4120000,3,2,4100000,'OTROS INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(102,NULL,4120101,5,2,4120100,'Intereses Cobrados','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(103,NULL,4120102,5,2,4120100,'Diferencias de cambio','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(104,NULL,4120103,5,2,4120100,'Descuentos obtenidos','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(107,NULL,5000000,1,1,0,'GASTOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(108,NULL,5100000,2,1,5000000,'GASTOS ORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(109,NULL,5110100,4,1,5110000,'ASIENTO DE SUELDO','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(110,NULL,5110101,5,1,5110100,'Sueldos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(111,NULL,5110102,5,1,5110100,'Contribuciones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(112,NULL,5110103,5,1,5110100,'Sindicato','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(113,NULL,5120100,4,1,5120000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(114,NULL,5120101,5,1,5120100,'ACA','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(115,NULL,5120102,5,1,5120100,'Aereos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(116,NULL,5120103,5,1,5120100,'Alquiler','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(117,NULL,5120104,5,1,5120100,'AGUA AYSA','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(118,NULL,5120105,5,1,5120100,'TV Cablevision','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(119,NULL,5120106,5,1,5120100,'Caja Jubilacion Consejo','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(120,NULL,5120107,5,1,5120100,'Celulares','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(121,NULL,5120108,5,1,5120100,'Cheques','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(122,NULL,5120109,5,1,5120100,'Club la Nacion','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(123,NULL,5120110,5,1,5120100,'Comida','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(124,NULL,5120111,5,1,5120100,'Diario Clarin','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(125,NULL,5120112,5,1,5120100,'Digital Ocean','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(126,NULL,5120113,5,1,5120100,'Fletes y acarreos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(127,NULL,5120114,5,1,5120100,'Luz Edesur','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(128,NULL,5120115,5,1,5120100,'Movilidad y Viáticos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(129,NULL,5120116,5,1,5120100,'Mantenimiento','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(130,NULL,5120117,5,1,5120100,'IVA No Computable','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(131,NULL,5120118,5,1,5120100,'Entretenimiento','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(132,NULL,5120119,5,1,5120100,'Amortización Bienes de Uso','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(133,NULL,5120120,5,1,5120100,'Errepar','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(134,NULL,5120121,5,1,5120100,'Hosting Página Web To Webs','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(135,NULL,5120122,5,1,5120100,'Gastos varios','Result. Negativo',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (136,NULL,5120123,5,1,5120100,'Ajuste por redondeo','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(137,NULL,5120124,5,1,5120100,'Deudores Incobrables','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(138,NULL,5120125,5,1,5120100,'Faby Goncalves','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(139,NULL,5130100,4,1,5130000,'GASTOS FINANCIEROS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(140,NULL,5130101,5,1,5130100,'Intereses y Gastos bancarios','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(141,NULL,5130102,5,1,5130100,'Intereses Proveedores','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(142,NULL,5130103,5,1,5130100,'Damian Financiera','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(143,NULL,5130104,5,1,5130100,'Diferencias de cambio','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(144,NULL,5130105,5,1,5130100,'Diferencia de Cambio Bces. en M.Extranjera','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(145,NULL,5130106,5,1,5130100,'Diferencia tipo cambio Vendedor/Comprador','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(146,NULL,5130107,5,1,5130100,'Diferencia por conversion en Bce. en Mon. Extranj.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(147,NULL,5130108,5,1,5130100,'Diferencia de cambio CMV','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(148,NULL,5130109,5,1,5130100,'Diferencia de cambio PT','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(149,NULL,5130110,5,1,5130100,'Resultado por Exposición a la Inflación','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(150,NULL,5130111,5,1,5130100,'Diferencia de cambio PE','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(151,NULL,5130112,5,1,5130100,'Diferencia de cambio Ds.Vtas.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(152,NULL,5130113,5,1,5130100,'Diferencia de cambio ME','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(153,NULL,5130114,5,1,5130100,'Descuentos otorgados','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(154,NULL,5140100,4,1,5140000,'IMPUESTOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(155,NULL,5140101,5,1,5140100,'Impuesto a las Ganancias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(156,NULL,5140164,5,1,5140100,'Impuesto a los Ingresos Brutos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(157,NULL,5140102,5,1,5140100,'Impuesto al Debito y Credito Bancario','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(158,NULL,5200000,2,1,5000000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(159,NULL,5210101,5,1,5210100,'Pérdida por venta bienes de uso','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(160,NULL,5210102,5,1,5210100,'Inversiones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(161,NULL,5210103,5,1,5210100,'Amortizaciones extraordinarias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(162,NULL,1140103,5,1,1140100,'Retenciones SUSS','Activo',NULL,1,2,1,0,0,1,NULL),(163,NULL,1110122,5,1,1110100,'Banco Patagonia Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(164,NULL,1110106,5,1,1110100,'Banco HSBC','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(165,NULL,1110123,5,1,1110100,'Banco Ciudad Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(166,NULL,1110124,5,1,1110100,'Banco Nacion Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(167,NULL,1110109,5,1,1110100,'Banco Galicia Vane','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(168,NULL,1110110,5,1,1110100,'Banco Frances Vane','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(169,NULL,1110111,5,1,1110100,'Banco Patagonia In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(170,NULL,1110112,5,1,1110100,'Banco Ciudad In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(171,NULL,1110113,5,1,1110100,'Banco Provincia In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(172,NULL,1110114,5,1,1110100,'Banco Macro PedimeOnline','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(173,NULL,1110115,5,1,1110100,'Banco Patagonia Problema Resuelto','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22');
INSERT INTO `conta_plan_cuenta` VALUES (174,NULL,1110116,5,1,1110100,'Banco Patagonia Graciela','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(175,NULL,1110117,5,1,1110100,'Banco Patagonia Omar','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(176,NULL,1110118,5,1,1110100,'Cheques','Activo',NULL,1,2,1,1,1,0,NULL),(177,NULL,5120126,5,1,5120100,'Gisela Larzabal','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(178,NULL,5120127,5,1,5120100,'Google','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(179,NULL,5120128,5,1,5120100,'Seguro Moto','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(180,NULL,5120129,5,1,5120100,'Sueldo Agustina','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(181,NULL,5120130,5,1,5120100,'Sueldo Betty','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(182,NULL,5120131,5,1,5120100,'Sueldo Elizabet','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(183,NULL,5120132,5,1,5120100,'Sueldo Florencia','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(184,NULL,5120133,5,1,5120100,'Sueldo Graciela','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(185,NULL,5120134,5,1,5120100,'Sueldo Franco Sanchez','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(186,NULL,5120135,5,1,5120100,'Sueldo Santiago Sanchez','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(187,NULL,5120136,5,1,5120100,'Sueldo Jose Luis','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(188,NULL,5120137,5,1,5120100,'Publicidad','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(189,NULL,5120138,5,1,5120100,'Las Nieves','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(190,NULL,5120139,5,1,5120100,'Sueldo Lidia','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(191,NULL,5120140,5,1,5120100,'Cargas Sociales','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(192,NULL,5120141,5,1,5120100,'Honorarios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(193,NULL,5120142,5,1,5120100,'Telefono Fijo','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(194,NULL,5120143,5,1,5120100,'ONE DRIVE','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(195,NULL,5120144,5,1,5120100,'OSDE','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(196,NULL,5120145,5,1,5120100,'SAS Constitucion','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(197,NULL,5120146,5,1,5120100,'Seguro de Vida Zurich','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(198,NULL,5120147,5,1,5120100,'Seguros','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(199,NULL,5120148,5,1,5120100,'Internet','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(200,NULL,5120149,5,1,5120100,'Seguro de Retiro Zurich','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(201,NULL,5140165,5,1,5140100,'Monotributo','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(202,NULL,5140104,5,1,5140100,'IVA In Time SRL','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(203,NULL,5140105,5,1,5140100,'Autonomos','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(204,NULL,5140106,5,1,5140100,'Multas Impositivas','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(207,NULL,5120150,5,1,5120100,'Vanesa Gastos','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(208,NULL,5140166,5,1,5140100,'Impuesto a los Ingresos Brutos - BS AS','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(209,NULL,5140107,5,1,5140100,'SIRCREB','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(210,NULL,5140108,5,1,5140100,'Consejo Ciencias Economicas','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(211,NULL,5120152,5,1,5120100,'Albano Andres','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(212,NULL,5120153,5,1,5120100,'Tarjeta Visa','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(213,NULL,5120154,5,1,5120100,'Tarjeta American Express','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(214,NULL,5120155,5,1,5120100,'Tarjeta Mastercard','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(215,NULL,5120156,5,1,5120100,'Imp. Municipales','Result. Negativo',NULL,1,2,0,0,0,1,'2020-12-31 13:34:22');
INSERT INTO `conta_plan_cuenta` VALUES (216,NULL,5120157,5,1,5120100,'Perc/Ret. Imp. Ganancias','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(217,NULL,5120158,5,1,5120100,'Compras','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(218,NULL,4110106,5,2,4110100,'Ventas No Gravadas','Result. Positivo',NULL,1,2,0,0,0,1,NULL),(219,NULL,6110103,5,1,6110100,'Pagos AFIP','Movimiento',NULL,1,2,0,0,1,1,NULL),(220,NULL,5140167,5,1,5140100,'Perc IVA -RG3337','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(221,NULL,5140109,5,1,5140100,'Imps. Internos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(222,NULL,5140110,5,1,5140100,'Imp. Gasoil','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(223,NULL,5140111,5,1,5140100,'Imp. Hídricos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(224,NULL,5140112,5,1,5140100,'ITC','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(225,NULL,5140113,5,1,5140100,'Perc IIBB  Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(226,NULL,5140114,5,1,5140100,'Perc IIBB  Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(227,NULL,5140115,5,1,5140100,'Perc IIBB  Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(228,NULL,5140116,5,1,5140100,'Perc IIBB  Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(229,NULL,5140117,5,1,5140100,'Perc IIBB  Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(230,NULL,5140118,5,1,5140100,'Perc IIBB  Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(231,NULL,5140119,5,1,5140100,'Perc IIBB  Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(232,NULL,5140120,5,1,5140100,'Perc IIBB  Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(233,NULL,5140121,5,1,5140100,'Perc IIBB  Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(234,NULL,5140122,5,1,5140100,'Perc IIBB  Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(235,NULL,5140123,5,1,5140100,'Perc IIBB  La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(236,NULL,5140124,5,1,5140100,'Perc IIBB  La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(237,NULL,5140125,5,1,5140100,'Perc IIBB  Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(238,NULL,5140126,5,1,5140100,'Perc IIBB  Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(239,NULL,5140127,5,1,5140100,'Perc IIBB  Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(240,NULL,5140128,5,1,5140100,'Perc IIBB  Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(241,NULL,5140129,5,1,5140100,'Perc IIBB  Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(242,NULL,5140130,5,1,5140100,'Perc IIBB  Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(243,NULL,5140131,5,1,5140100,'Perc IIBB  San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(244,NULL,5140132,5,1,5140100,'Perc IIBB  San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(245,NULL,5140133,5,1,5140100,'Perc IIBB  Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(246,NULL,5140134,5,1,5140100,'Perc IIBB  Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(247,NULL,5140135,5,1,5140100,'Perc IIBB  Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(248,NULL,5140136,5,1,5140100,'Perc IIBB  Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(249,NULL,5140137,5,1,5140100,'Perc IIBB  Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(250,NULL,5140138,5,1,5140100,'Compras No Gravadas','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(251,NULL,1140108,5,1,1140100,'Retenciones de IIBB Buenos Aires','Activo',NULL,1,2,1,0,0,1,NULL),(252,NULL,1140109,5,1,1140100,'Retenciones de IIBB Capital Federal','Activo',NULL,1,2,1,0,0,1,NULL),(253,NULL,1140110,5,1,1140100,'Retenciones de IIBB Catamarca','Activo',NULL,1,2,1,0,0,1,NULL),(254,NULL,1140111,5,1,1140100,'Retenciones de IIBB Chaco','Activo',NULL,1,2,1,0,0,1,NULL),(255,NULL,1140112,5,1,1140100,'Retenciones de IIBB Chubut','Activo',NULL,1,2,1,0,0,1,NULL),(256,NULL,1140113,5,1,1140100,'Retenciones de IIBB Córdoba','Activo',NULL,1,2,1,0,0,1,NULL),(257,NULL,1140114,5,1,1140100,'Retenciones de IIBB Corrientes','Activo',NULL,1,2,1,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (258,NULL,1140115,5,1,1140100,'Retenciones de IIBB Entre Ríos','Activo',NULL,1,2,1,0,0,1,NULL),(259,NULL,1140116,5,1,1140100,'Retenciones de IIBB Formosa','Activo',NULL,1,2,1,0,0,1,NULL),(260,NULL,1140117,5,1,1140100,'Retenciones de IIBB Jujuy','Activo',NULL,1,2,1,0,0,1,NULL),(261,NULL,1140118,5,1,1140100,'Retenciones de IIBB La Pampa','Activo',NULL,1,2,1,0,0,1,NULL),(262,NULL,1140119,5,1,1140100,'Retenciones de IIBB La Rioja','Activo',NULL,1,2,1,0,0,1,NULL),(263,NULL,1140120,5,1,1140100,'Retenciones de IIBB Mendoza','Activo',NULL,1,2,1,0,0,1,NULL),(264,NULL,1140121,5,1,1140100,'Retenciones de IIBB Misiones','Activo',NULL,1,2,1,0,0,1,NULL),(265,NULL,1140122,5,1,1140100,'Retenciones de IIBB Neuquén','Activo',NULL,1,2,1,0,0,1,NULL),(266,NULL,1140123,5,1,1140100,'Retenciones de IIBB Pascua Lama','Activo',NULL,1,2,1,0,0,1,NULL),(267,NULL,1140124,5,1,1140100,'Retenciones de IIBB Río Negro','Activo',NULL,1,2,1,0,0,1,NULL),(268,NULL,1140125,5,1,1140100,'Retenciones de IIBB Salta','Activo',NULL,1,2,1,0,0,1,NULL),(269,NULL,1140126,5,1,1140100,'Retenciones de IIBB San Juan','Activo',NULL,1,2,1,0,0,1,NULL),(270,NULL,1140127,5,1,1140100,'Retenciones de IIBB San Luis','Activo',NULL,1,2,1,0,0,1,NULL),(271,NULL,1140128,5,1,1140100,'Retenciones de IIBB Santa Cruz','Activo',NULL,1,2,1,0,0,1,NULL),(272,NULL,1140129,5,1,1140100,'Retenciones de IIBB Santa Fe','Activo',NULL,1,2,1,0,0,1,NULL),(273,NULL,1140130,5,1,1140100,'Retenciones de IIBB Santiago del Estero','Activo',NULL,1,2,1,0,0,1,NULL),(274,NULL,1140131,5,1,1140100,'Retenciones de IIBB Tierra del Fuego','Activo',NULL,1,2,1,0,0,1,NULL),(275,NULL,1140132,5,1,1140100,'Retenciones de IIBB Tucuman','Activo',NULL,1,2,1,0,0,1,NULL),(276,NULL,5140168,5,1,5140100,'SIRCREB Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(277,NULL,5140139,5,1,5140100,'SIRCREB Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(278,NULL,5140140,5,1,5140100,'SIRCREB Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(279,NULL,5140141,5,1,5140100,'SIRCREB Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(280,NULL,5140142,5,1,5140100,'SIRCREB Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(281,NULL,5140143,5,1,5140100,'SIRCREB Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(282,NULL,5140144,5,1,5140100,'SIRCREB Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(283,NULL,5140145,5,1,5140100,'SIRCREB Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(284,NULL,5140146,5,1,5140100,'SIRCREB Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(285,NULL,5140147,5,1,5140100,'SIRCREB Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(286,NULL,5140148,5,1,5140100,'SIRCREB La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(287,NULL,5140149,5,1,5140100,'SIRCREB La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(288,NULL,5140150,5,1,5140100,'SIRCREB Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(289,NULL,5140151,5,1,5140100,'SIRCREB Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(290,NULL,5140152,5,1,5140100,'SIRCREB Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(291,NULL,5140153,5,1,5140100,'SIRCREB Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(292,NULL,5140154,5,1,5140100,'SIRCREB Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(293,NULL,5140155,5,1,5140100,'SIRCREB Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(294,NULL,5140156,5,1,5140100,'SIRCREB San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(295,NULL,5140157,5,1,5140100,'SIRCREB San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(296,NULL,5140158,5,1,5140100,'SIRCREB Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(297,NULL,5140159,5,1,5140100,'SIRCREB Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(298,NULL,5140160,5,1,5140100,'SIRCREB Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(299,NULL,5140161,5,1,5140100,'SIRCREB Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(300,NULL,5140162,5,1,5140100,'SIRCREB Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (301,NULL,1140326,5,1,1140300,'IIBB a Favor Buenos Aires','Activo',NULL,1,2,0,0,0,1,NULL),(302,NULL,1140302,5,1,1140300,'IIBB a Favor Capital Federal','Activo',NULL,1,2,0,0,0,1,NULL),(303,NULL,1140303,5,1,1140300,'IIBB a Favor Catamarca','Activo',NULL,1,2,0,0,0,1,NULL),(304,NULL,1140304,5,1,1140300,'IIBB a Favor Chaco','Activo',NULL,1,2,0,0,0,1,NULL),(305,NULL,1140305,5,1,1140300,'IIBB a Favor Chubut','Activo',NULL,1,2,0,0,0,1,NULL),(306,NULL,1140306,5,1,1140300,'IIBB a Favor Córdoba','Activo',NULL,1,2,0,0,0,1,NULL),(307,NULL,1140307,5,1,1140300,'IIBB a Favor Corrientes','Activo',NULL,1,2,0,0,0,1,NULL),(308,NULL,1140308,5,1,1140300,'IIBB a Favor Entre Ríos','Activo',NULL,1,2,0,0,0,1,NULL),(309,NULL,1140309,5,1,1140300,'IIBB a Favor Formosa','Activo',NULL,1,2,0,0,0,1,NULL),(310,NULL,1140310,5,1,1140300,'IIBB a Favor Jujuy','Activo',NULL,1,2,0,0,0,1,NULL),(311,NULL,1140311,5,1,1140300,'IIBB a Favor La Pampa','Activo',NULL,1,2,0,0,0,1,NULL),(312,NULL,1140312,5,1,1140300,'IIBB a Favor La Rioja','Activo',NULL,1,2,0,0,0,1,NULL),(313,NULL,1140313,5,1,1140300,'IIBB a Favor Mendoza','Activo',NULL,1,2,0,0,0,1,NULL),(314,NULL,1140314,5,1,1140300,'IIBB a Favor Misiones','Activo',NULL,1,2,0,0,0,1,NULL),(315,NULL,1140315,5,1,1140300,'IIBB a Favor Neuquén','Activo',NULL,1,2,0,0,0,1,NULL),(316,NULL,1140316,5,1,1140300,'IIBB a Favor Pascua Lama','Activo',NULL,1,2,0,0,0,1,NULL),(317,NULL,1140317,5,1,1140300,'IIBB a Favor Río Negro','Activo',NULL,1,2,0,0,0,1,NULL),(318,NULL,1140318,5,1,1140300,'IIBB a Favor Salta','Activo',NULL,1,2,0,0,0,1,NULL),(319,NULL,1140319,5,1,1140300,'IIBB a Favor San Juan','Activo',NULL,1,2,0,0,0,1,NULL),(320,NULL,1140320,5,1,1140300,'IIBB a Favor San Luis','Activo',NULL,1,2,0,0,0,1,NULL),(321,NULL,1140321,5,1,1140300,'IIBB a Favor Santa Cruz','Activo',NULL,1,2,0,0,0,1,NULL),(322,NULL,1140322,5,1,1140300,'IIBB a Favor Santa Fe','Activo',NULL,1,2,0,0,0,1,NULL),(323,NULL,1140323,5,1,1140300,'IIBB a Favor Santiago del Estero','Activo',NULL,1,2,0,0,0,1,NULL),(324,NULL,1140324,5,1,1140300,'IIBB a Favor Tierra del Fuego','Activo',NULL,1,2,0,0,0,1,NULL),(325,NULL,1140325,5,1,1140300,'IIBB a Favor Tucuman','Activo',NULL,1,2,0,0,0,1,NULL),(326,NULL,2110317,5,2,2110300,'IIBB a Pagar Buenos Aires','Pasivo',NULL,1,2,0,0,0,1,NULL),(327,NULL,2110318,5,2,2110300,'IIBB a Pagar Capital Federal','Pasivo',NULL,1,2,0,0,0,1,NULL),(328,NULL,2110319,5,2,2110300,'IIBB a Pagar Catamarca','Pasivo',NULL,1,2,0,0,0,1,NULL),(329,NULL,2110320,5,2,2110300,'IIBB a Pagar Chaco','Pasivo',NULL,1,2,0,0,0,1,NULL),(330,NULL,2110321,5,2,2110300,'IIBB a Pagar Chubut','Pasivo',NULL,1,2,0,0,0,1,NULL),(331,NULL,2110322,5,2,2110300,'IIBB a Pagar Córdoba','Pasivo',NULL,1,2,0,0,0,1,NULL),(332,NULL,2110323,5,2,2110300,'IIBB a Pagar Corrientes','Pasivo',NULL,1,2,0,0,0,1,NULL),(333,NULL,2110324,5,2,2110300,'IIBB a Pagar Entre Ríos','Pasivo',NULL,1,2,0,0,0,1,NULL),(334,NULL,2110325,5,2,2110300,'IIBB a Pagar Formosa','Pasivo',NULL,1,2,0,0,0,1,NULL),(335,NULL,2110326,5,2,2110300,'IIBB a Pagar Jujuy','Pasivo',NULL,1,2,0,0,0,1,NULL),(336,NULL,2110327,5,2,2110300,'IIBB a Pagar La Pampa','Pasivo',NULL,1,2,0,0,0,1,NULL),(337,NULL,2110328,5,2,2110300,'IIBB a Pagar La Rioja','Pasivo',NULL,1,2,0,0,0,1,NULL),(338,NULL,2110329,5,2,2110300,'IIBB a Pagar Mendoza','Pasivo',NULL,1,2,0,0,0,1,NULL),(339,NULL,2110330,5,2,2110300,'IIBB a Pagar Misiones','Pasivo',NULL,1,2,0,0,0,1,NULL),(340,NULL,2110331,5,2,2110300,'IIBB a Pagar Neuquén','Pasivo',NULL,1,2,0,0,0,1,NULL),(341,NULL,2110332,5,2,2110300,'IIBB a Pagar Pascua Lama','Pasivo',NULL,1,2,0,0,0,1,NULL),(342,NULL,2110333,5,2,2110300,'IIBB a Pagar Río Negro','Pasivo',NULL,1,2,0,0,0,1,NULL),(343,NULL,2110334,5,2,2110300,'IIBB a Pagar Salta','Pasivo',NULL,1,2,0,0,0,1,NULL),(344,NULL,2110335,5,2,2110300,'IIBB a Pagar San Juan','Pasivo',NULL,1,2,0,0,0,1,NULL),(345,NULL,2110336,5,2,2110300,'IIBB a Pagar San Luis','Pasivo',NULL,1,2,0,0,0,1,NULL),(346,NULL,2110337,5,2,2110300,'IIBB a Pagar Santa Cruz','Pasivo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (347,NULL,2110338,5,2,2110300,'IIBB a Pagar Santa Fe','Pasivo',NULL,1,2,0,0,0,1,NULL),(348,NULL,2110339,5,2,2110300,'IIBB a Pagar Santiago del Estero','Pasivo',NULL,1,2,0,0,0,1,NULL),(349,NULL,2110340,5,2,2110300,'IIBB a Pagar Tierra del Fuego','Pasivo',NULL,1,2,0,0,0,1,NULL),(350,NULL,2110341,5,2,2110300,'IIBB a Pagar Tucuman','Pasivo',NULL,1,2,0,0,0,1,NULL),(351,NULL,6110101,5,1,6110100,'BANCO SIRCREB','Movimiento',NULL,1,2,0,0,1,1,NULL),(352,NULL,6110102,5,1,6110100,'Compensacion','Movimiento',NULL,1,2,0,0,0,1,'2020-12-31 13:34:22'),(353,NULL,1140327,5,1,1140300,'IVA Saldo Tecnico','Activo',NULL,1,2,0,0,0,1,NULL),(354,NULL,1140328,5,1,1140300,'IVA Saldo Libre Disponibilidad','Activo',NULL,1,2,0,0,0,1,NULL),(355,NULL,6000000,1,1,0,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(356,NULL,6100000,2,1,6000000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(357,NULL,6110000,3,1,6100000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(358,NULL,4110000,3,2,4100000,'Ingresos Operativos','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(359,NULL,1110120,5,1,1110100,'Caja en Pesos','Activo',NULL,1,2,1,1,1,0,NULL),(360,NULL,1140211,5,1,1140200,'Retenciones Bancarias de Ganancias a Favor','Activo',NULL,1,2,0,0,1,1,NULL),(361,NULL,1220104,5,1,1220100,'Equipos de Computación','Activo',NULL,1,1,0,0,0,1,NULL),(362,NULL,1220105,5,1,1220100,'Computadoras','Activo',NULL,1,1,0,0,0,1,NULL),(363,NULL,1220304,5,1,1220300,'Muebles y Utiles','Activo',NULL,1,1,0,0,0,1,NULL),(364,NULL,2110105,5,2,2110100,'Anticipo de Clientes','Pasivo',NULL,1,2,0,0,1,1,NULL),(365,NULL,2110401,5,2,2110400,'Provision Honorarios','Pasivo',NULL,1,1,0,0,0,1,NULL),(366,NULL,2110106,5,2,2110100,'Cta. Cte Directores','Pasivo',NULL,1,1,0,0,0,1,NULL),(367,NULL,2110107,5,2,2110100,'Provisión Honorarios Directores','Pasivo',NULL,1,1,0,0,0,1,NULL),(368,NULL,2110110,5,2,2110100,'Cuenta Particular Socio 1','Pasivo',NULL,1,1,0,0,0,1,NULL),(369,NULL,3110104,5,2,3110100,'Capital','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(370,NULL,1120000,3,1,1100000,'INVERSIONES','Activo',NULL,1,1,0,0,0,0,NULL),(371,NULL,1160000,3,1,1100000,'OTROS ACTIVOS','Activo',NULL,1,1,0,0,0,0,NULL),(372,NULL,1160100,4,1,1160000,'OTROS','Activo',NULL,1,1,0,0,0,0,NULL),(373,NULL,2110400,4,2,2110000,'Provision de Honorarios','Pasivo',NULL,1,1,0,0,0,0,NULL),(374,NULL,3410100,4,1,3410000,'RESULTADOS ACUMULADOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(375,NULL,3420000,3,1,3400000,'GANACIAS RESERVADAS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(376,NULL,3420100,4,1,3420000,'Rerva Legal','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(377,NULL,1220400,4,1,1220000,'INMUEBLES','Activo',NULL,1,1,0,0,0,0,NULL),(378,NULL,1220500,4,1,1220000,'RODADOS','Activo',NULL,1,1,0,0,0,0,NULL),(379,NULL,1220600,4,1,1220000,'MAQUINARIAS','Activo',NULL,1,1,0,0,0,0,NULL),(380,NULL,1220204,5,1,1220200,'Instalaciones','Activo',NULL,1,1,0,0,0,1,NULL),(381,NULL,3420101,5,2,3420100,'Reserva Legal','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(382,NULL,3420102,5,2,3420100,'Reserva Legal','Patrimonio Neto',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(383,NULL,3410105,5,2,3410100,'Resultado no asignado','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(384,NULL,1110121,5,1,1110100,'Caja en Dolares','Activo',NULL,1,2,1,1,1,0,NULL),(385,NULL,1120100,4,1,1120000,'TEMPORARIAS','Activo',NULL,1,1,0,0,0,0,NULL),(386,NULL,1120101,5,1,1120100,'PLAZO FIJO','Activo',NULL,1,1,0,0,0,1,NULL),(387,NULL,1120200,4,1,1120000,'PERMANENTES','Activo',NULL,1,1,0,0,0,0,NULL),(388,NULL,1120201,5,1,1120200,'ACCIONES','Activo',NULL,1,1,0,0,0,1,NULL),(389,NULL,1220401,5,1,1220400,'Inmuebles','Activo',NULL,1,1,0,0,0,1,NULL),(390,NULL,1220501,5,1,1220500,'Vehiculos','Activo',NULL,1,1,0,0,0,1,NULL),(391,NULL,1220601,5,1,1220600,'Maquinarias','Activo',NULL,1,1,0,0,0,1,NULL),(392,NULL,1150401,5,1,1150400,'MERCADERIAS','Activo',NULL,1,1,0,0,0,1,NULL),(393,NULL,1160101,5,1,1160100,'OTROS','Activo',NULL,1,1,0,0,0,1,NULL),(394,NULL,1230100,4,1,1230000,'INTANGIBLES','Activo',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (395,NULL,2110119,5,2,2110100,'Cuenta Particular Socio 2','Pasivo',NULL,1,1,0,0,0,1,NULL),(396,NULL,5120160,5,1,5120100,'Comisiones Y gastos Bancarios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(397,NULL,4110100,4,2,4110000,'Ingresos Operativos','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(398,NULL,4120100,4,2,4120000,'OTROS INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(399,NULL,5110000,3,1,5100000,'GASTOS ORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(400,NULL,5120000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(401,NULL,5130000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(402,NULL,5140000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(403,NULL,5210000,3,1,5200000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(404,NULL,5210100,4,1,5210000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(405,NULL,6110100,4,1,6110000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(406,NULL,1130100,4,1,1130000,'Operaciones Ordinarias','Activo',NULL,1,1,0,0,0,0,NULL),(407,NULL,3110000,3,2,3100000,'CAPITAL SOCIAL','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(408,NULL,3410000,3,2,3400000,'RESULTADOS ANTERIORES','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(409,NULL,5110101,5,2,5110000,'IVA Crédito Fiscal No computable','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(410,NULL,1110203,5,1,1110200,'Banco ICBC Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(411,NULL,2110342,5,2,2110300,'Provisión Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(412,NULL,5120107,5,2,5120000,'Amortización Muebles y Útiles','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(413,NULL,5120102,5,2,5120000,'Amortización Equipos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(414,NULL,1220109,5,1,1220100,'Amortizacion Acumulada Equipos','Activo',NULL,1,1,0,0,0,1,NULL),(415,NULL,1220602,5,1,1220600,'Amortización Acumulada Maquinarias','Activo',NULL,1,1,0,0,0,1,NULL),(416,NULL,1160102,5,1,1160100,'Materias Primas','Activo',NULL,1,1,0,0,0,1,NULL),(417,NULL,1110204,5,1,1110200,'Banco Itaú Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(418,NULL,2110113,5,2,2110100,'Deudas Bancarias','Pasivo',NULL,1,2,0,1,1,1,NULL),(419,NULL,1220502,5,1,1220500,'Rodados','Activo',NULL,1,1,0,0,0,1,NULL),(420,NULL,1220503,5,1,1220500,'Amortización Acumulada Rodados','Activo',NULL,1,1,0,0,0,1,NULL),(421,NULL,5120105,5,2,5120000,'Amortización Rodados','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(422,NULL,5120109,5,2,5120000,'Amortización Maquinarias','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(423,NULL,1220504,5,1,1220500,'Accesorios','Activo',NULL,1,1,0,0,0,1,NULL),(424,NULL,1220505,5,1,1220500,'Amortización Acumulada Accesorios','Activo',NULL,1,1,0,0,0,1,NULL),(425,NULL,1110205,5,1,1110200,'Banco Galicia Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(426,NULL,3420101,5,2,3420000,'Reserva Facultativa','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(427,NULL,1140212,5,1,1140200,'Créditos por Impuestos Diferidos','Activo',NULL,1,1,0,0,0,1,NULL),(428,NULL,1160103,5,1,1160100,'Fondo de Comercio','Activo',NULL,1,1,0,0,0,1,NULL),(429,NULL,1160104,5,1,1160100,'Amortizacion Acumulada Fondo de Comercio','Activo',NULL,1,1,0,0,0,1,NULL),(430,NULL,1140213,5,1,1140200,'Intereses a devengar AGIP','Activo',NULL,1,1,0,0,0,1,NULL),(431,NULL,2110343,5,2,2110300,'PFP IIBB','Pasivo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(432,NULL,1140330,5,1,1140300,'Pago a Cuenta ITC','Activo',NULL,1,2,0,0,0,1,NULL),(433,NULL,2110114,5,2,2110100,'Préstamo','Pasivo',NULL,1,2,0,1,1,1,NULL),(434,NULL,1160106,5,1,1160100,'Productos','Activo',NULL,1,1,0,0,0,1,NULL),(435,NULL,2110345,5,2,2110300,'Intereses a devengar PFP','Pasivo',NULL,1,1,0,0,0,1,NULL),(436,NULL,1110206,5,1,1110200,'Banco Provincia Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(437,NULL,1140215,5,1,1140200,'Imp. Ley 25413 Cred 0.6%','Activo',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (438,NULL,2110402,5,2,2110400,'Honorarios Directorio a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(439,NULL,3110101,5,2,3110100,'Reserva para Futuras Inversiones','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(440,NULL,1130106,5,1,1130100,'TEAC - Trabajos Ejecutados a Certificar','Activo',NULL,1,1,0,0,0,1,NULL),(441,NULL,2110115,5,2,2110100,'Leasing','Pasivo',NULL,1,2,0,1,1,1,NULL),(442,NULL,1110207,5,1,1110200,'Banco Comafi Cta. Cte','Activo',NULL,1,2,1,1,1,0,NULL),(443,NULL,2110500,4,2,2110000,'Deudas Financieras','Pasivo',NULL,1,1,0,0,0,0,NULL),(444,NULL,2110501,5,2,2110500,'Banco Santander Rio Cta Cte','Pasivo',NULL,1,1,0,0,0,1,NULL),(446,NULL,2210000,3,2,2200000,'Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(447,NULL,2210100,4,2,2210000,'Otras Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(448,NULL,2210101,5,2,2210100,'Planes de Pagos AFIP','Pasivo',NULL,1,2,0,1,1,1,NULL),(449,NULL,2110502,5,2,2110500,'Leasing','Pasivo',NULL,1,1,0,0,0,1,NULL),(450,NULL,6110101,5,1,6110000,'Cheques Rechazados','Movimiento',NULL,1,2,0,0,1,1,NULL),(451,NULL,1110208,5,1,1110200,'Banco Patagonia Taxes Software','Activo',NULL,1,2,1,1,1,0,NULL),(452,NULL,1110209,5,1,1110200,'Banco Macro Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(453,NULL,1120202,5,1,1120200,'Inversión Central Caribe','Activo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(454,NULL,1120102,5,1,1120100,'Otras Inversiones','Activo',NULL,1,1,0,0,0,1,NULL),(455,NULL,1140216,5,1,1140200,'Otros Créditos','Activo',NULL,1,1,0,0,0,1,NULL),(456,NULL,2110403,5,2,2110400,'Provisión Honorarios Socio Gerente','Pasivo',NULL,1,1,0,0,0,1,NULL),(457,NULL,1110210,5,1,1110200,'Cheque Diferido Banco Santander Rio','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(458,NULL,1110211,5,1,1110200,'Cheque Diferido Banco Macro','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(459,NULL,2110204,5,2,2110200,'Moratoria SUSS a pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(460,NULL,2110344,5,2,2110300,'Impuestos Municipales a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(461,NULL,5110103,5,2,5110000,'Amortización Instalaciones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(462,NULL,5120110,5,2,5120000,'Amortización Equipos de comput.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(463,NULL,2110118,5,2,2110100,'Cuenta Particular Socio 3','Pasivo',NULL,1,1,0,0,0,1,NULL),(464,NULL,2110120,5,2,2110100,'Cuenta Particular Socio 4','Pasivo',NULL,1,1,0,0,0,1,NULL),(465,NULL,3110102,5,2,3110100,'Otras Reservas','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(466,NULL,1140331,5,1,1140300,'IGMP (Saldo a Favor)','Activo',NULL,1,1,0,0,0,1,NULL),(467,NULL,5110104,5,2,5110000,'Interés','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(468,NULL,1150402,5,1,1150400,'Productos en Proceso','Activo',NULL,1,1,0,0,0,1,NULL),(469,NULL,2110205,5,2,2110200,'Depósitos en Garantía Socio Gerente','Pasivo',NULL,1,1,0,0,0,1,NULL),(470,NULL,2110346,5,2,2110300,'Fondos Embargados','Pasivo',NULL,1,1,0,0,0,1,NULL),(471,NULL,2110347,5,2,2110300,'Cuota Solid.','Pasivo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(472,NULL,1140332,5,1,1140300,'Anticipo Honorarios Directores','Activo',NULL,1,1,0,0,0,1,NULL),(473,NULL,2110348,5,2,2110300,'SICORE a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(474,NULL,1110212,5,1,1110200,'Banco Credicoop Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(475,NULL,1110213,5,1,1110200,'Banco Superville Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(476,NULL,5110105,5,2,5110000,'RECPAM','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(477,NULL,1110125,5,1,1110100,'Caja Reales','Activo',NULL,1,2,1,1,1,0,NULL),(478,NULL,5140169,5,1,5140100,'CO2 - Imp. Al Carbono','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(479,NULL,1140300,4,1,1140000,'Anticipo de Impuestos','Activo',NULL,1,1,0,0,0,0,NULL),(480,NULL,2110600,4,2,2110000,'Retenciones Efectuadas','Pasivo',NULL,1,1,0,0,0,0,NULL),(481,NULL,4200000,2,2,4000000,'INGRESOS EXTRAORDINARIOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(482,7968,5120108,5,2,5120100,'Gastos de Papelera','Result. Negativo',NULL,1,1,1,0,0,1,NULL);
/*!40000 ALTER TABLE `conta_plan_cuenta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_asientos`
--

DROP TABLE IF EXISTS `conta_tipo_asientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_asientos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `orden` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_asientos`
--

LOCK TABLES `conta_tipo_asientos` WRITE;
/*!40000 ALTER TABLE `conta_tipo_asientos` DISABLE KEYS */;
INSERT INTO `conta_tipo_asientos` VALUES (1,'Sueldos',NULL,NULL,NULL,11),(2,'Ingresos',NULL,NULL,NULL,9),(3,'Egresos',NULL,NULL,NULL,10),(4,'Amortizaciones',NULL,NULL,NULL,4),(5,'Banco',NULL,NULL,NULL,15),(6,'Ganancias',NULL,NULL,NULL,12),(7,'Retenciones',NULL,NULL,NULL,13),(8,'SIRCREB',NULL,NULL,NULL,14),(9,'Compensaciones',NULL,NULL,NULL,16),(10,'Pagos AFIP',NULL,NULL,NULL,17),(11,'Ajustes',NULL,NULL,NULL,3),(12,'Saldos Iniciales',NULL,NULL,NULL,1),(13,'Cancelacion de Iniciales',NULL,NULL,NULL,2),(14,'Patrimonio Neto',NULL,NULL,NULL,8),(15,'Liquidaciones IVA',NULL,NULL,NULL,18),(16,'Liquidacion IIBB',NULL,NULL,NULL,19),(17,'Asientos de Cierre',NULL,NULL,NULL,5),(18,'Reclasificacion',NULL,NULL,NULL,6),(19,'Otros',NULL,NULL,NULL,7),(20,'Cobranzas','2019-10-02 03:20:37','2019-10-02 03:20:37',NULL,NULL),(21,'Pagos','2019-10-02 03:20:37','2019-10-02 03:20:37',NULL,NULL),(22,'Tesoreria','2019-10-19 02:10:24','2019-10-19 02:10:24',NULL,NULL),(23,'Ajuste por Inflacion','2020-03-01 06:39:20','2020-03-01 06:39:20',NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_asientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_cuentas`
--

DROP TABLE IF EXISTS `conta_tipo_cuentas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_cuentas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo_cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_cuentas`
--

LOCK TABLES `conta_tipo_cuentas` WRITE;
/*!40000 ALTER TABLE `conta_tipo_cuentas` DISABLE KEYS */;
INSERT INTO `conta_tipo_cuentas` VALUES (1,'Rubro',NULL,NULL,NULL),(2,'SubRubro',NULL,NULL,NULL),(3,'Grupo',NULL,NULL,NULL),(4,'SubGrupo',NULL,NULL,NULL),(5,'Cuenta',NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_cuentas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_saldos`
--

DROP TABLE IF EXISTS `conta_tipo_saldos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_saldos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `saldo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_saldos`
--

LOCK TABLES `conta_tipo_saldos` WRITE;
/*!40000 ALTER TABLE `conta_tipo_saldos` DISABLE KEYS */;
INSERT INTO `conta_tipo_saldos` VALUES (1,'Deudor',NULL,NULL,NULL),(2,'Acreedor',NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_saldos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `control_cuits_afip`
--

DROP TABLE IF EXISTS `control_cuits_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `control_cuits_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `field_name1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuit` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `error` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `control_cuits_afip_person_id_foreign` (`person_id`),
  CONSTRAINT `control_cuits_afip_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `control_cuits_afip`
--

LOCK TABLES `control_cuits_afip` WRITE;
/*!40000 ALTER TABLE `control_cuits_afip` DISABLE KEYS */;
/*!40000 ALTER TABLE `control_cuits_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `control_general`
--

DROP TABLE IF EXISTS `control_general`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `control_general` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `control_general_description_unique` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `control_general`
--

LOCK TABLES `control_general` WRITE;
/*!40000 ALTER TABLE `control_general` DISABLE KEYS */;
INSERT INTO `control_general` VALUES (1,'Ingresos - Egresos - Resultado',1,'Proyeccion Ganancias','control_general/proyecGanancias',NULL,NULL),(2,'IVA',2,'IVA','control_general/iva',NULL,NULL),(3,'IIBB',3,'IIBB','control_general/iibb',NULL,NULL),(4,'Por Mes',4,'Vto. Impuestos','control_general/vto',NULL,NULL),(5,'Por Impuesto',4,'Vto. Impuestos','control_general/vtoPorImpuestos',NULL,NULL);
/*!40000 ALTER TABLE `control_general` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente`
--

DROP TABLE IF EXISTS `cta_cte_cliente`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `compensado` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(9,2) NOT NULL DEFAULT '1.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_cliente_person_id_foreign` (`person_id`),
  KEY `cta_cte_cliente_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `cta_cte_cliente_period_id_foreign` (`period_id`),
  KEY `cta_cte_cliente_saldo_id_foreign` (`saldo_id`),
  KEY `cta_cte_cliente_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `cta_cte_cliente_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_cliente_moneda_id_foreign` (`moneda_id`),
  CONSTRAINT `cta_cte_cliente_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_cliente_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `cta_cte_cliente_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_cliente_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `cta_cte_cliente_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1100 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente`
--

LOCK TABLES `cta_cte_cliente` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente` DISABLE KEYS */;
INSERT INTO `cta_cte_cliente` VALUES (1,7968,3,40720,40721,57,3134,2,0,'2022-09-01',12751.37,1,1.00,'Factura A N°: 0003-00033686',NULL,'2022-10-22 15:54:00','2022-10-25 15:49:43','2022-10-25 15:49:43'),(2,7968,3,40720,40722,57,3134,2,0,'2022-09-01',13704.16,1,1.00,'Factura B N°: 9269-00452414',NULL,'2022-10-22 15:54:00','2022-10-25 15:49:43','2022-10-25 15:49:43'),(3,7968,3,40720,40723,57,3134,2,0,'2022-09-02',14362.65,1,1.00,'Factura A N°: 0004-00073417',NULL,'2022-10-22 15:54:00','2022-10-25 15:49:43','2022-10-25 15:49:43'),(4,7968,3,40720,40724,57,3134,2,0,'2022-09-05',1398.11,1,1.00,'Factura A N°: 0002-01808944',NULL,'2022-10-22 15:54:00','2022-10-25 15:49:43','2022-10-25 15:49:43'),(5,7968,3,40720,40725,57,3134,2,0,'2022-09-05',167.21,1,1.00,'Factura A N°: 0001-01493148',NULL,'2022-10-22 15:54:00','2022-10-25 15:49:43','2022-10-25 15:49:43'),(6,7968,3,40720,40726,57,3134,2,0,'2022-09-07',10019.54,1,1.00,'Factura A N°: 0010-01069559',NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(7,7968,3,40720,40727,57,3134,2,0,'2022-09-07',980.16,1,1.00,'Factura A N°: 0006-00002462',NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(8,7968,3,40720,40728,57,3134,2,0,'2022-09-07',10982.01,1,1.00,'Factura A N°: 0002-00053485',NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(9,7968,3,40720,40729,57,3134,2,0,'2022-09-09',9899.99,1,1.00,'Factura A N°: 0005-00004112',NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(10,7968,3,40720,40730,57,3134,2,0,'2022-09-09',116160.00,1,1.00,'Factura A N°: 0003-00000010',NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(11,7968,3,40720,40730,57,3134,1,0,'2022-09-09',-116160.00,1,1.00,'Nota de crédito A N°: 0003-00000001',NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(12,7968,3,40720,40730,57,3134,2,0,'2022-09-09',116160.00,1,1.00,'Factura A N°: 0003-00000008',NULL,'2022-10-22 15:54:01','2022-10-25 15:46:59','2022-10-25 15:46:59'),(13,7968,3,40720,40730,57,3134,2,0,'2022-09-09',116160.00,1,1.00,'Factura A N°: 0003-00000009',NULL,'2022-10-22 15:54:01','2022-10-25 15:46:34','2022-10-25 15:46:34'),(14,7968,3,40720,40731,57,3134,2,0,'2022-09-12',4443.33,1,1.00,'Factura A N°: 0026-00574088',NULL,'2022-10-22 15:54:01','2022-10-25 15:43:23','2022-10-25 15:43:23'),(15,7968,3,40720,40728,57,3134,2,0,'2022-09-12',3439.21,1,1.00,'Factura A N°: 0002-00053578',NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(16,7968,3,40720,40724,57,3134,2,0,'2022-09-12',1810.40,1,1.00,'Factura A N°: 0002-01832219',NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(17,7968,3,40720,40725,57,3134,2,0,'2022-09-12',157.19,1,1.00,'Factura A N°: 0001-01513356',NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(18,7968,3,40720,40723,57,3134,2,0,'2022-09-14',15244.03,1,1.00,'Factura A N°: 0004-00073634',NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(19,7968,3,40720,40728,57,3134,2,0,'2022-09-14',8135.40,1,1.00,'Factura A N°: 0002-00053655',NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(20,7968,3,40720,40721,57,3134,2,0,'2022-09-15',9737.93,1,1.00,'Factura A N°: 0003-00033961',NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(21,7968,3,40720,40724,57,3134,2,0,'2022-09-19',1165.60,1,1.00,'Factura A N°: 0002-01855417',NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(22,7968,3,40720,40722,57,3134,2,0,'2022-09-19',0.00,1,1.00,'Factura B N°: 9269-00453064',NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(23,7968,3,40720,40725,57,3134,2,0,'2022-09-19',117.93,1,1.00,'Factura A N°: 0001-01533635',NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(24,7968,3,40720,40722,57,3134,2,0,'2022-09-19',7718.17,1,1.00,'Factura B N°: 9269-00453065',NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43');
INSERT INTO `cta_cte_cliente` VALUES (25,7968,3,40720,40728,57,3134,2,0,'2022-09-21',7902.01,1,1.00,'Factura A N°: 0002-00053835',NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(26,7968,3,40720,40723,57,3134,2,0,'2022-09-23',14362.65,1,1.00,'Factura A N°: 0004-00073883',NULL,'2022-10-22 15:54:01','2022-10-25 15:44:09','2022-10-25 15:44:09'),(27,7968,3,40720,40724,57,3134,2,0,'2022-09-26',3850.20,1,1.00,'Factura A N°: 0002-01879215',NULL,'2022-10-22 15:54:01','2022-10-25 15:49:43','2022-10-25 15:49:43'),(28,7968,3,40720,40725,57,3134,2,0,'2022-09-26',416.72,1,1.00,'Factura A N°: 0001-01554222',NULL,'2022-10-22 15:54:01','2022-10-25 15:41:15','2022-10-25 15:41:15'),(29,7968,3,40720,40728,57,3134,2,0,'2022-09-27',7454.01,1,1.00,'Factura A N°: 0002-00053936',NULL,'2022-10-22 15:54:02','2022-10-24 17:07:57','2022-10-24 17:07:57'),(30,7968,3,40720,40722,57,3134,2,0,'2022-09-27',9300.56,1,1.00,'Factura B N°: 9269-00453375',NULL,'2022-10-22 15:54:02','2022-10-24 17:07:08','2022-10-24 17:07:08'),(31,7968,3,40720,40721,57,3134,2,0,'2022-09-29',11812.44,1,1.00,'Factura A N°: 0003-00034232',NULL,'2022-10-22 15:54:02','2022-10-24 17:06:48','2022-10-24 17:06:48'),(32,7968,3,40720,40727,57,3134,2,0,'2022-09-29',11998.99,1,1.00,'Factura A N°: 0006-00002927',NULL,'2022-10-22 15:54:02','2022-10-24 17:05:43','2022-10-24 17:05:43'),(33,7968,3,40720,40727,57,3134,2,0,'2022-09-29',7709.47,1,1.00,'Factura A N°: 0006-00002949',NULL,'2022-10-22 15:54:02','2022-10-24 17:04:30','2022-10-24 17:04:30'),(34,7968,3,40720,40722,57,3134,2,0,'2022-09-29',9004.90,1,1.00,'Factura B N°: 9269-00453463',NULL,'2022-10-22 15:54:02','2022-10-24 15:16:21','2022-10-24 15:16:21'),(35,7968,3,40720,40722,57,3134,2,0,'2022-09-29',0.00,1,1.00,'Factura B N°: 9269-00453462',NULL,'2022-10-22 15:54:02','2022-10-24 16:50:22','2022-10-24 16:50:22'),(36,7968,3,40720,40729,57,3134,2,0,'2022-09-29',13300.02,1,1.00,'Factura A N°: 0005-00004165',NULL,'2022-10-22 15:54:02','2022-10-24 15:15:51','2022-10-24 15:15:51'),(37,7968,3,40720,40719,57,3134,2,0,'2022-09-30',25900.00,1,1.00,'Factura C N°: 0002-00000846',NULL,'2022-10-22 15:54:02','2022-10-24 15:11:24','2022-10-24 15:11:24'),(38,7968,3,40720,40724,57,3134,1,0,'2022-09-30',-500.00,1,1.00,'Nota de crédito A N°: 0008-00427185',NULL,'2022-10-22 15:54:02','2022-10-24 15:14:55','2022-10-24 15:14:55'),(39,7968,3,40720,40719,57,3134,2,0,'2022-09-30',25900.00,1,1.00,'Factura C N°: 0002-00000846',NULL,'2022-10-24 15:11:24','2022-10-24 16:45:15','2022-10-24 16:45:15'),(40,7968,3,40720,40724,57,3134,1,0,'2022-09-30',500.00,1,1.00,'Nota de crédito A N°: 0008-00427185',NULL,'2022-10-24 15:14:55','2022-10-24 16:37:31','2022-10-24 16:37:31'),(41,7968,3,40720,40729,57,3134,2,0,'2022-09-29',13300.02,1,1.00,'Factura A N°: 0005-00004165',NULL,'2022-10-24 15:15:51','2022-10-24 16:47:54','2022-10-24 16:47:54'),(42,7968,3,40720,40722,57,3134,2,0,'2022-09-29',9004.89,1,1.00,'Factura B N°: 9269-00453463',NULL,'2022-10-24 15:16:21','2022-10-24 17:03:26','2022-10-24 17:03:26'),(43,7968,3,40720,40724,57,3134,1,0,'2022-09-30',500.00,1,1.00,'Nota de crédito A N°: 0008-00427185',NULL,'2022-10-24 16:37:31','2022-10-24 16:44:21','2022-10-24 16:44:21'),(44,7968,3,40720,40724,57,3134,1,0,'2022-09-30',500.00,1,1.00,'Nota de crédito A N°: 0008-00427185',NULL,'2022-10-24 16:44:21','2022-10-24 16:44:29','2022-10-24 16:44:29'),(45,7968,3,40720,40724,57,3134,1,0,'2022-09-30',500.00,1,1.00,'Nota de crédito A N°: 0008-00427185',NULL,'2022-10-24 16:44:29','2022-10-25 15:49:43','2022-10-25 15:49:43'),(46,7968,3,40720,40719,57,3134,2,0,'2022-09-30',25900.00,1,1.00,'Factura C N°: 0002-00000846',NULL,'2022-10-24 16:45:15','2022-10-24 16:46:45','2022-10-24 16:46:45'),(47,7968,3,40720,40719,57,3134,2,0,'2022-09-30',25900.00,1,1.00,'Factura C N°: 0002-00000846',NULL,'2022-10-24 16:46:45','2022-10-25 15:49:43','2022-10-25 15:49:43');
INSERT INTO `cta_cte_cliente` VALUES (48,7968,3,40720,40729,57,3134,2,0,'2022-09-29',13300.02,1,1.00,'Factura A N°: 0005-00004165',NULL,'2022-10-24 16:47:54','2022-10-25 15:49:43','2022-10-25 15:49:43'),(49,7968,3,40720,40722,57,3134,2,0,'2022-09-29',0.01,1,1.00,'Factura B N°: 9269-00453462',NULL,'2022-10-24 16:50:22','2022-10-25 15:49:43','2022-10-25 15:49:43'),(50,7968,3,40720,40722,57,3134,2,0,'2022-09-29',9004.89,1,1.00,'Factura B N°: 9269-00453463',NULL,'2022-10-24 17:03:26','2022-10-25 15:49:43','2022-10-25 15:49:43'),(51,7968,3,40720,40727,57,3134,2,0,'2022-09-29',7709.47,1,1.00,'Factura A N°: 0006-00002949',NULL,'2022-10-24 17:04:30','2022-10-25 15:49:43','2022-10-25 15:49:43'),(52,7968,3,40720,40727,57,3134,2,0,'2022-09-29',11998.99,1,1.00,'Factura A N°: 0006-00002927',NULL,'2022-10-24 17:05:43','2022-10-25 15:49:43','2022-10-25 15:49:43'),(53,7968,3,40720,40721,57,3134,2,0,'2022-09-29',11812.44,1,1.00,'Factura A N°: 0003-00034232',NULL,'2022-10-24 17:06:48','2022-10-25 15:49:43','2022-10-25 15:49:43'),(54,7968,3,40720,40722,57,3134,2,0,'2022-09-27',9300.57,1,1.00,'Factura B N°: 9269-00453375',NULL,'2022-10-24 17:07:08','2022-10-25 15:49:43','2022-10-25 15:49:43'),(55,7968,3,40720,40728,57,3134,2,0,'2022-09-27',7454.01,1,1.00,'Factura A N°: 0002-00053936',NULL,'2022-10-24 17:07:57','2022-10-25 15:49:43','2022-10-25 15:49:43'),(56,7968,3,40720,40725,57,3134,2,0,'2022-09-26',416.72,1,1.00,'Factura A N°: 0001-01554222',NULL,'2022-10-25 15:41:15','2022-10-25 15:42:00','2022-10-25 15:42:00'),(57,7968,3,40720,40725,57,3134,2,0,'2022-09-26',416.72,1,1.00,'Factura A N°: 0001-01554222',NULL,'2022-10-25 15:42:00','2022-10-25 15:49:43','2022-10-25 15:49:43'),(58,7968,3,40720,40731,57,3134,2,0,'2022-09-12',4443.33,1,1.00,'Factura A N°: 0026-00574088',NULL,'2022-10-25 15:43:23','2022-10-25 15:44:39','2022-10-25 15:44:39'),(59,7968,3,40720,40723,57,3134,2,0,'2022-09-23',14362.65,1,1.00,'Factura A N°: 0004-00073883',NULL,'2022-10-25 15:44:09','2022-10-25 15:49:43','2022-10-25 15:49:43'),(60,7968,3,40720,40731,57,3134,2,0,'2022-09-12',4443.33,1,1.00,'Factura A N°: 0026-00574088',NULL,'2022-10-25 15:44:39','2022-10-25 15:49:43','2022-10-25 15:49:43'),(61,7968,3,40720,40730,57,3134,2,0,'2022-09-09',116160.00,1,1.00,'Factura A N°: 0003-00000009',NULL,'2022-10-25 15:46:34','2022-10-25 15:49:43','2022-10-25 15:49:43'),(62,7968,3,40720,40730,57,3134,2,0,'2022-09-09',116160.00,1,1.00,'Factura A N°: 0003-00000008',NULL,'2022-10-25 15:46:59','2022-10-25 15:49:43','2022-10-25 15:49:43'),(63,7968,3,40720,40721,57,3134,2,0,'2022-09-01',12751.37,1,1.00,'Factura A N°: 0003-00033686',NULL,'2022-10-25 15:53:23','2022-10-25 17:07:50','2022-10-25 17:07:50'),(64,7968,3,40720,40722,57,3134,2,0,'2022-09-01',13704.16,1,1.00,'Factura B N°: 9269-00452414',NULL,'2022-10-25 15:53:23','2022-10-25 17:07:50','2022-10-25 17:07:50'),(65,7968,3,40720,40723,57,3134,2,0,'2022-09-02',14362.65,1,1.00,'Factura A N°: 0004-00073417',NULL,'2022-10-25 15:53:23','2022-10-25 17:07:50','2022-10-25 17:07:50'),(66,7968,3,40720,40724,57,3134,2,0,'2022-09-05',1398.11,1,1.00,'Factura A N°: 0002-01808944',NULL,'2022-10-25 15:53:23','2022-10-25 17:07:50','2022-10-25 17:07:50'),(67,7968,3,40720,40725,57,3134,2,0,'2022-09-05',167.21,1,1.00,'Factura A N°: 0001-01493148',NULL,'2022-10-25 15:53:24','2022-10-25 17:07:50','2022-10-25 17:07:50'),(68,7968,3,40720,40726,57,3134,2,0,'2022-09-07',10019.54,1,1.00,'Factura A N°: 0010-01069559',NULL,'2022-10-25 15:53:24','2022-10-25 17:07:50','2022-10-25 17:07:50'),(69,7968,3,40720,40727,57,3134,2,0,'2022-09-07',980.16,1,1.00,'Factura A N°: 0006-00002462',NULL,'2022-10-25 15:53:24','2022-10-25 17:07:50','2022-10-25 17:07:50'),(70,7968,3,40720,40728,57,3134,2,0,'2022-09-07',10982.01,1,1.00,'Factura A N°: 0002-00053485',NULL,'2022-10-25 15:53:24','2022-10-25 17:07:50','2022-10-25 17:07:50'),(71,7968,3,40720,40729,57,3134,2,0,'2022-09-09',9899.99,1,1.00,'Factura A N°: 0005-00004112',NULL,'2022-10-25 15:53:24','2022-10-25 17:07:50','2022-10-25 17:07:50');
INSERT INTO `cta_cte_cliente` VALUES (72,7968,3,40720,40730,57,3134,2,0,'2022-09-09',116160.00,1,1.00,'Factura A N°: 0003-00000010',NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(73,7968,3,40720,40730,57,3134,1,0,'2022-09-09',-116160.00,1,1.00,'Nota de crédito A N°: 0003-00000001',NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(74,7968,3,40720,40730,57,3134,2,0,'2022-09-09',116160.00,1,1.00,'Factura A N°: 0003-00000008',NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(75,7968,3,40720,40730,57,3134,2,0,'2022-09-09',116160.00,1,1.00,'Factura A N°: 0003-00000009',NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(76,7968,3,40720,40731,57,3134,2,0,'2022-09-12',4443.33,1,1.00,'Factura A N°: 0026-00574088',NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(77,7968,3,40720,40728,57,3134,2,0,'2022-09-12',3439.21,1,1.00,'Factura A N°: 0002-00053578',NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(78,7968,3,40720,40724,57,3134,2,0,'2022-09-12',1810.40,1,1.00,'Factura A N°: 0002-01832219',NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(79,7968,3,40720,40725,57,3134,2,0,'2022-09-12',157.19,1,1.00,'Factura A N°: 0001-01513356',NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(80,7968,3,40720,40723,57,3134,2,0,'2022-09-14',15244.03,1,1.00,'Factura A N°: 0004-00073634',NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(81,7968,3,40720,40728,57,3134,2,0,'2022-09-14',8135.40,1,1.00,'Factura A N°: 0002-00053655',NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(82,7968,3,40720,40721,57,3134,2,0,'2022-09-15',9737.93,1,1.00,'Factura A N°: 0003-00033961',NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(83,7968,3,40720,40724,57,3134,2,0,'2022-09-19',1165.60,1,1.00,'Factura A N°: 0002-01855417',NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(84,7968,3,40720,40722,57,3134,2,0,'2022-09-19',0.00,1,1.00,'Factura B N°: 9269-00453064',NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(85,7968,3,40720,40725,57,3134,2,0,'2022-09-19',117.93,1,1.00,'Factura A N°: 0001-01533635',NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(86,7968,3,40720,40722,57,3134,2,0,'2022-09-19',7718.17,1,1.00,'Factura B N°: 9269-00453065',NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(87,7968,3,40720,40728,57,3134,2,0,'2022-09-21',7902.01,1,1.00,'Factura A N°: 0002-00053835',NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(88,7968,3,40720,40723,57,3134,2,0,'2022-09-23',14362.65,1,1.00,'Factura A N°: 0004-00073883',NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(89,7968,3,40720,40724,57,3134,2,0,'2022-09-26',3850.20,1,1.00,'Factura A N°: 0002-01879215',NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(90,7968,3,40720,40725,57,3134,2,0,'2022-09-26',416.72,1,1.00,'Factura A N°: 0001-01554222',NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(91,7968,3,40720,40728,57,3134,2,0,'2022-09-27',7454.01,1,1.00,'Factura A N°: 0002-00053936',NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(92,7968,3,40720,40722,57,3134,2,0,'2022-09-27',9300.56,1,1.00,'Factura B N°: 9269-00453375',NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(93,7968,3,40720,40721,57,3134,2,0,'2022-09-29',11812.44,1,1.00,'Factura A N°: 0003-00034232',NULL,'2022-10-25 15:53:24','2022-10-25 17:07:51','2022-10-25 17:07:51'),(94,7968,3,40720,40727,57,3134,2,0,'2022-09-29',11998.99,1,1.00,'Factura A N°: 0006-00002927',NULL,'2022-10-25 15:53:25','2022-10-25 17:07:51','2022-10-25 17:07:51'),(95,7968,3,40720,40727,57,3134,2,0,'2022-09-29',7709.47,1,1.00,'Factura A N°: 0006-00002949',NULL,'2022-10-25 15:53:25','2022-10-25 17:07:51','2022-10-25 17:07:51');
INSERT INTO `cta_cte_cliente` VALUES (96,7968,3,40720,40722,57,3134,2,0,'2022-09-29',9004.90,1,1.00,'Factura B N°: 9269-00453463',NULL,'2022-10-25 15:53:25','2022-10-25 17:07:51','2022-10-25 17:07:51'),(97,7968,3,40720,40722,57,3134,2,0,'2022-09-29',0.00,1,1.00,'Factura B N°: 9269-00453462',NULL,'2022-10-25 15:53:25','2022-10-25 17:07:51','2022-10-25 17:07:51'),(98,7968,3,40720,40729,57,3134,2,0,'2022-09-29',13300.02,1,1.00,'Factura A N°: 0005-00004165',NULL,'2022-10-25 15:53:25','2022-10-25 15:56:03','2022-10-25 15:56:03'),(99,7968,3,40720,40719,57,3134,2,0,'2022-09-30',25900.00,1,1.00,'Factura C N°: 0002-00000846',NULL,'2022-10-25 15:53:25','2022-10-25 15:55:56','2022-10-25 15:55:56'),(100,7968,3,40720,40724,57,3134,1,0,'2022-09-30',-500.00,1,1.00,'Nota de crédito A N°: 0008-00427185',NULL,'2022-10-25 15:53:25','2022-10-25 17:07:51','2022-10-25 17:07:51'),(101,7968,3,40720,40719,57,3134,2,0,'2022-09-30',25900.00,1,1.00,'Factura C N°: 0002-00000846',NULL,'2022-10-25 15:55:56','2022-10-25 17:07:51','2022-10-25 17:07:51'),(102,7968,3,40720,40729,57,3134,2,0,'2022-09-29',13300.02,1,1.00,'Factura A N°: 0005-00004165',NULL,'2022-10-25 15:56:03','2022-10-25 17:07:51','2022-10-25 17:07:51'),(103,7968,3,40720,40724,57,3133,2,0,'2022-08-01',4296.60,1,1.00,'Factura A N°: 0002-01692905',NULL,'2022-10-25 16:49:26','2022-10-25 16:49:26',NULL),(104,7968,3,40720,40725,57,3133,2,0,'2022-08-01',480.02,1,1.00,'Factura A N°: 0001-01393695',NULL,'2022-10-25 16:49:26','2022-10-25 16:49:26',NULL),(105,7968,3,40720,40727,57,3133,2,0,'2022-08-01',6351.35,1,1.00,'Factura A N°: 0006-00001731',NULL,'2022-10-25 16:49:26','2022-10-25 16:49:26',NULL),(106,7968,3,40720,40728,57,3133,2,0,'2022-08-01',12635.60,1,1.00,'Factura A N°: 0002-00052642',NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(107,7968,3,40720,40727,57,3133,2,0,'2022-08-01',5497.32,1,1.00,'Factura A N°: 0006-00001730',NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(108,7968,3,40720,40728,57,3133,2,0,'2022-08-03',9539.99,1,1.00,'Factura A N°: 0002-00052710',NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(109,7968,3,40720,40721,57,3133,2,0,'2022-08-04',4221.40,1,1.00,'Factura A N°: 0003-00033135',NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(110,7968,3,40720,40723,57,3133,2,0,'2022-08-05',12887.63,1,1.00,'Factura A N°: 0004-00072837',NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(111,7968,3,40720,40726,57,3133,2,0,'2022-08-07',9261.58,1,1.00,'Factura A N°: 0009-01022968',NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(112,7968,3,40720,40724,57,3133,2,0,'2022-08-08',3555.71,1,1.00,'Factura A N°: 0002-01716362',NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(113,7968,3,40720,40725,57,3133,2,0,'2022-08-08',364.08,1,1.00,'Factura A N°: 0001-01413555',NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(114,7968,3,40720,40727,57,3133,2,0,'2022-08-09',8209.51,1,1.00,'Factura A N°: 0006-00001933',NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(115,7968,3,40720,40728,57,3133,2,0,'2022-08-09',10661.81,1,1.00,'Factura A N°: 0002-00052805',NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(116,7968,3,40720,40729,57,3133,2,0,'2022-08-09',11200.00,1,1.00,'Factura A N°: 0005-00004046',NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(117,7968,3,40720,40723,57,3133,2,0,'2022-08-10',13082.19,1,1.00,'Factura A N°: 0004-00072912',NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(118,7968,3,40720,40721,57,3133,2,0,'2022-08-11',13554.30,1,1.00,'Factura A N°: 0003-00033266',NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(119,7968,3,40720,40728,57,3133,2,0,'2022-08-11',7991.54,1,1.00,'Factura A N°: 0002-00052871',NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(120,7968,3,40720,40722,57,3133,2,0,'2022-08-11',7435.80,1,1.00,'Factura B N°: 9269-00451607',NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL);
INSERT INTO `cta_cte_cliente` VALUES (121,7968,3,40720,40731,57,3133,2,0,'2022-08-12',4411.82,1,1.00,'Factura A N°: 0026-00498853',NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(122,7968,3,40720,40723,57,3133,2,0,'2022-08-12',13298.75,1,1.00,'Factura A N°: 0004-00072987',NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(123,7968,3,40720,40725,57,3133,2,0,'2022-08-15',338.84,1,1.00,'Factura A N°: 0001-01433768',NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(124,7968,3,40720,40724,57,3133,2,0,'2022-08-15',2904.71,1,1.00,'Factura A N°: 0002-01738904',NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(125,7968,3,40720,40733,57,3133,2,0,'2022-08-18',8891.00,1,1.00,'Factura A N°: 0040-00005393',NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(126,7968,3,40720,40728,57,3133,2,0,'2022-08-18',15117.03,1,1.00,'Factura A N°: 0002-00053018',NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(127,7968,3,40720,40727,57,3133,2,0,'2022-08-18',8276.16,1,1.00,'Factura A N°: 0006-00002106',NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(128,7968,3,40720,40734,57,3133,2,0,'2022-08-19',16991.32,1,1.00,'Factura A N°: 1428-00017092',NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(129,7968,3,40720,40728,57,3133,2,0,'2022-08-22',7080.05,1,1.00,'Factura A N°: 0002-00053095',NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(130,7968,3,40720,40725,57,3133,2,0,'2022-08-22',433.19,1,1.00,'Factura A N°: 0001-01453316',NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(131,7968,3,40720,40724,57,3133,2,0,'2022-08-22',4002.11,1,1.00,'Factura A N°: 0002-01762453',NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(132,7968,3,40720,40722,57,3133,2,0,'2022-08-22',15021.00,1,1.00,'Factura B N°: 9269-00451977',NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(133,7968,3,40720,40722,57,3133,2,0,'2022-08-22',0.00,1,1.00,'Factura B N°: 9269-00451976',NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(134,7968,3,40720,40728,57,3133,2,0,'2022-08-23',3900.01,1,1.00,'Factura A N°: 0002-00053115',NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(135,7968,3,40720,40723,57,3133,1,0,'2022-08-23',16387.23,1,1.00,'Nota de crédito A N°: 0004-00004313',NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(136,7968,3,40720,40735,57,3133,2,0,'2022-08-24',95208.33,1,1.00,'Factura A N°: 0018-00027104',NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(137,7968,3,40720,40723,57,3133,2,0,'2022-08-24',16387.23,1,1.00,'Factura A N°: 0004-00073178',NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(138,7968,3,40720,40723,57,3133,2,0,'2022-08-24',16387.23,1,1.00,'Factura A N°: 0004-00073202',NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(139,7968,3,40720,40727,57,3133,2,0,'2022-08-25',12704.20,1,1.00,'Factura A N°: 0006-00002219',NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(140,7968,3,40720,40736,57,3133,2,0,'2022-08-25',3827.99,1,1.00,'Factura A N°: 0004-00004177',NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(141,7968,3,40720,40721,57,3133,2,0,'2022-08-25',7433.94,1,1.00,'Factura A N°: 0003-00033547',NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(142,7968,3,40720,40727,57,3133,2,0,'2022-08-26',569.98,1,1.00,'Factura A N°: 0006-00002255',NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(143,7968,3,40720,40729,57,3133,2,0,'2022-08-26',12199.99,1,1.00,'Factura A N°: 0005-00004081',NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(144,7968,3,40720,40727,57,3133,2,0,'2022-08-29',6208.46,1,1.00,'Factura A N°: 0006-00002295',NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(145,7968,3,40720,40734,57,3133,2,0,'2022-08-30',18726.36,1,1.00,'Factura A N°: 1426-00009329',NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(146,7968,3,40720,40728,57,3133,2,0,'2022-08-31',15526.99,1,1.00,'Factura A N°: 0002-00053332',NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL);
INSERT INTO `cta_cte_cliente` VALUES (147,7968,3,40720,40737,57,3133,2,0,'2022-08-31',2845.99,1,1.00,'Factura A N°: 0010-00031006',NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(148,7968,3,40720,40724,57,3133,1,0,'2022-08-31',561.00,1,1.00,'Nota de crédito A N°: 0008-00405609',NULL,'2022-10-25 16:49:28','2022-10-25 16:54:13','2022-10-25 16:54:13'),(149,7968,3,40720,40719,57,3133,2,0,'2022-08-31',25900.00,1,1.00,'Factura C N°: 0002-00000828',NULL,'2022-10-25 16:49:28','2022-10-25 16:54:05','2022-10-25 16:54:05'),(150,7968,3,40720,40719,57,3133,2,0,'2022-08-31',25900.00,1,1.00,'Factura C N°: 0002-00000828',NULL,'2022-10-25 16:54:05','2022-10-25 16:54:05',NULL),(151,7968,3,40720,40724,57,3133,1,0,'2022-08-31',561.00,1,1.00,'Nota de crédito A N°: 0008-00405609',NULL,'2022-10-25 16:54:13','2022-10-25 16:54:13',NULL),(152,7968,3,40720,40721,57,3134,2,0,'2022-09-01',12751.37,1,1.00,'Factura A N°: 0003-00033686',NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(153,7968,3,40720,40722,57,3134,2,0,'2022-09-01',13704.16,1,1.00,'Factura B N°: 9269-00452414',NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(154,7968,3,40720,40723,57,3134,2,0,'2022-09-02',14362.65,1,1.00,'Factura A N°: 0004-00073417',NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(155,7968,3,40720,40725,57,3134,2,0,'2022-09-05',167.21,1,1.00,'Factura A N°: 0001-01493148',NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(156,7968,3,40720,40724,57,3134,2,0,'2022-09-05',1398.11,1,1.00,'Factura A N°: 0002-01808944',NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(157,7968,3,40720,40726,57,3134,2,0,'2022-09-07',10019.54,1,1.00,'Factura A N°: 0010-01069559',NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(158,7968,3,40720,40727,57,3134,2,0,'2022-09-07',980.16,1,1.00,'Factura A N°: 0006-00002462',NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(159,7968,3,40720,40728,57,3134,2,0,'2022-09-07',10982.01,1,1.00,'Factura A N°: 0002-00053485',NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(160,7968,3,40720,40730,57,3134,2,0,'2022-09-09',116160.00,1,1.00,'Factura A N°: 0003-00000009',NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(161,7968,3,40720,40730,57,3134,2,0,'2022-09-09',116160.00,1,1.00,'Factura A N°: 0003-00000008',NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(162,7968,3,40720,40729,57,3134,2,0,'2022-09-09',9899.99,1,1.00,'Factura A N°: 0005-00004112',NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(163,7968,3,40720,40730,57,3134,2,0,'2022-09-09',116160.00,1,1.00,'Factura A N°: 0003-00000010',NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(164,7968,3,40720,40730,57,3134,1,0,'2022-09-09',116160.00,1,1.00,'Nota de crédito A N°: 0003-00000001',NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(165,7968,3,40720,40731,57,3134,2,0,'2022-09-12',4443.33,1,1.00,'Factura A N°: 0026-00574088',NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(166,7968,3,40720,40728,57,3134,2,0,'2022-09-12',3439.21,1,1.00,'Factura A N°: 0002-00053578',NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(167,7968,3,40720,40725,57,3134,2,0,'2022-09-12',157.19,1,1.00,'Factura A N°: 0001-01513356',NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(168,7968,3,40720,40724,57,3134,2,0,'2022-09-12',1810.40,1,1.00,'Factura A N°: 0002-01832219',NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(169,7968,3,40720,40723,57,3134,2,0,'2022-09-14',15244.03,1,1.00,'Factura A N°: 0004-00073634',NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(170,7968,3,40720,40728,57,3134,2,0,'2022-09-14',8135.40,1,1.00,'Factura A N°: 0002-00053655',NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(171,7968,3,40720,40721,57,3134,2,0,'2022-09-15',9737.93,1,1.00,'Factura A N°: 0003-00033961',NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(172,7968,3,40720,40725,57,3134,2,0,'2022-09-19',117.93,1,1.00,'Factura A N°: 0001-01533635',NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL);
INSERT INTO `cta_cte_cliente` VALUES (173,7968,3,40720,40724,57,3134,2,0,'2022-09-19',1165.60,1,1.00,'Factura A N°: 0002-01855417',NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(174,7968,3,40720,40722,57,3134,2,0,'2022-09-19',0.00,1,1.00,'Factura B N°: 9269-00453064',NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(175,7968,3,40720,40722,57,3134,2,0,'2022-09-19',7718.17,1,1.00,'Factura B N°: 9269-00453065',NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(176,7968,3,40720,40728,57,3134,2,0,'2022-09-21',7902.01,1,1.00,'Factura A N°: 0002-00053835',NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(177,7968,3,40720,40723,57,3134,2,0,'2022-09-23',14362.65,1,1.00,'Factura A N°: 0004-00073883',NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(178,7968,3,40720,40724,57,3134,2,0,'2022-09-26',3850.20,1,1.00,'Factura A N°: 0002-01879215',NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(179,7968,3,40720,40725,57,3134,2,0,'2022-09-26',416.72,1,1.00,'Factura A N°: 0001-01554222',NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(180,7968,3,40720,40728,57,3134,2,0,'2022-09-27',7454.01,1,1.00,'Factura A N°: 0002-00053936',NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(181,7968,3,40720,40722,57,3134,2,0,'2022-09-27',9300.56,1,1.00,'Factura B N°: 9269-00453375',NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(182,7968,3,40720,40721,57,3134,2,0,'2022-09-29',11812.44,1,1.00,'Factura A N°: 0003-00034232',NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(183,7968,3,40720,40729,57,3134,2,0,'2022-09-29',13300.04,1,1.00,'Factura A N°: 0005-00004165',NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(184,7968,3,40720,40727,57,3134,2,0,'2022-09-29',7709.47,1,1.00,'Factura A N°: 0006-00002949',NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(185,7968,3,40720,40727,57,3134,2,0,'2022-09-29',11998.99,1,1.00,'Factura A N°: 0006-00002927',NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(186,7968,3,40720,40722,57,3134,2,0,'2022-09-29',0.00,1,1.00,'Factura B N°: 9269-00453462',NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(187,7968,3,40720,40722,57,3134,2,0,'2022-09-29',9004.90,1,1.00,'Factura B N°: 9269-00453463',NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(188,7968,3,40720,40724,57,3134,1,0,'2022-09-30',500.00,1,1.00,'Nota de crédito A N°: 0008-00427185',NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(189,7968,3,40720,40719,57,3134,2,0,'2022-09-30',25900.00,1,1.00,'Factura C N°: 0002-00000846',NULL,'2022-10-25 17:11:10','2022-10-25 17:11:39','2022-10-25 17:11:39'),(190,7968,3,40720,40719,57,3134,2,0,'2022-09-30',25900.00,1,1.00,'Factura C N°: 0002-00000846',NULL,'2022-10-25 17:11:39','2022-10-25 17:11:39',NULL),(191,7968,3,40720,40728,57,1518,2,0,'2022-10-03',16918.51,1,1.00,'Factura A N°: 0002-00054131',NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(192,7968,3,40720,40727,57,1518,2,0,'2022-10-03',2039.81,1,1.00,'Factura A N°: 0006-00003008',NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(193,7968,3,40720,40724,57,1518,2,0,'2022-10-03',2176.20,1,1.00,'Factura A N°: 0002-01902709',NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(194,7968,3,40720,40725,57,1518,2,0,'2022-10-03',227.77,1,1.00,'Factura A N°: 0001-01574237',NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(195,7968,3,40720,40723,57,1518,2,0,'2022-10-05',12696.39,1,1.00,'Factura A N°: 0004-00074140',NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(196,7968,3,40720,40726,57,1518,2,0,'2022-10-05',10871.19,1,1.00,'Factura A N°: 0009-01037574',NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(197,7968,3,40720,40721,57,1518,2,0,'2022-10-06',7035.99,1,1.00,'Factura A N°: 0003-00034373',NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48');
INSERT INTO `cta_cte_cliente` VALUES (198,7968,3,40720,40724,57,1518,2,0,'2022-10-10',1602.71,1,1.00,'Factura A N°: 0002-01926237',NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(199,7968,3,40720,40725,57,1518,2,0,'2022-10-10',167.21,1,1.00,'Factura A N°: 0001-01594379',NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(200,7968,3,40720,40727,57,1518,2,0,'2022-10-11',940.92,1,1.00,'Factura A N°: 0006-00003134',NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(201,7968,3,40720,40723,57,1518,2,0,'2022-10-12',13614.15,1,1.00,'Factura A N°: 0004-00074250',NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(202,7968,3,40720,40722,57,1518,2,0,'2022-10-12',17215.16,1,1.00,'Factura B N°: 9269-00453796',NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(203,7968,3,40720,40722,57,1518,1,0,'2022-10-12',17215.16,1,1.00,'Nota de crédito B N°: 9270-00109200',NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(204,7968,3,40720,40728,57,1518,2,0,'2022-10-13',9246.15,1,1.00,'Factura A N°: 0002-00054345',NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(205,7968,3,40720,40721,57,1518,2,0,'2022-10-13',7114.33,1,1.00,'Factura A N°: 0003-00034501',NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(206,7968,3,40720,40722,57,1518,2,0,'2022-10-13',0.00,1,1.00,'Factura B N°: 9269-00453832',NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(207,7968,3,40720,40722,57,1518,2,0,'2022-10-13',17204.45,1,1.00,'Factura B N°: 9269-00453833',NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(208,7968,3,40720,40729,57,1518,2,0,'2022-10-13',13300.02,1,1.00,'Factura A N°: 0005-00004196',NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(209,7968,3,40720,40730,57,1518,2,0,'2022-10-13',116160.00,1,1.00,'Factura A N°: 0003-00000011',NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(210,7968,3,40720,40731,57,1518,2,0,'2022-10-16',4899.46,1,1.00,'Factura A N°: 0026-00690890',NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(211,7968,3,40720,40728,57,1518,2,0,'2022-10-17',7222.64,1,1.00,'Factura A N°: 0002-00054426',NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(212,7968,3,40720,40727,57,1518,2,0,'2022-10-17',20865.98,1,1.00,'Factura A N°: 0006-00003282',NULL,'2022-11-21 20:45:08','2022-11-21 20:45:48','2022-11-21 20:45:48'),(213,7968,3,40720,40724,57,1518,2,0,'2022-10-17',973.40,1,1.00,'Factura A N°: 0002-01949930',NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(214,7968,3,40720,40725,57,1518,2,0,'2022-10-17',126.54,1,1.00,'Factura A N°: 0001-01614474',NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(215,7968,3,40720,40721,57,1518,2,0,'2022-10-20',4047.56,1,1.00,'Factura A N°: 0003-00034635',NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(216,7968,3,40720,40723,57,1518,2,0,'2022-10-21',14362.65,1,1.00,'Factura A N°: 0004-00074487',NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(217,7968,3,40720,40734,57,1518,2,0,'2022-10-24',32549.25,1,1.00,'Factura A N°: 1428-00018715',NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(218,7968,3,40720,40724,57,1518,2,0,'2022-10-24',3162.00,1,1.00,'Factura A N°: 0002-01973406',NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(219,7968,3,40720,40725,57,1518,2,0,'2022-10-24',404.13,1,1.00,'Factura A N°: 0001-01635018',NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(220,7968,3,40720,40728,57,1518,2,0,'2022-10-27',13038.51,1,1.00,'Factura A N°: 0002-00054700',NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(221,7968,3,40720,40721,57,1518,2,0,'2022-10-27',15715.38,1,1.00,'Factura A N°: 0003-00034781',NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48');
INSERT INTO `cta_cte_cliente` VALUES (222,7968,3,40720,40722,57,1518,2,0,'2022-10-27',8164.91,1,1.00,'Factura B N°: 9269-00454477',NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(223,7968,3,40720,40722,57,1518,2,0,'2022-10-27',0.00,1,1.00,'Factura B N°: 9269-00454476',NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(224,7968,3,40720,40729,57,1518,2,0,'2022-10-28',13300.02,1,1.00,'Factura A N°: 0005-00004234',NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(225,7968,3,40720,40719,57,1518,2,0,'2022-10-31',25900.00,1,1.00,'Factura C N°: 0002-00000866',NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(226,7968,3,40720,40724,57,1518,1,0,'2022-10-31',811.00,1,1.00,'Nota de crédito A N°: 0008-00448531',NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(227,7968,3,40720,40724,57,1518,2,0,'2022-10-31',1370.20,1,1.00,'Factura A N°: 0002-01996759',NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(228,7968,3,40720,40725,57,1518,2,0,'2022-10-31',91.31,1,1.00,'Factura A N°: 0001-01655010',NULL,'2022-11-21 20:45:09','2022-11-21 20:45:48','2022-11-21 20:45:48'),(229,7968,3,40720,40727,57,1518,2,0,'2022-10-03',2039.81,1,1.00,'Factura A N°: 0006-00003008',NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(230,7968,3,40720,40724,57,1518,2,0,'2022-10-03',2176.20,1,1.00,'Factura A N°: 0002-01902709',NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(231,7968,3,40720,40725,57,1518,2,0,'2022-10-03',227.77,1,1.00,'Factura A N°: 0001-01574237',NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(232,7968,3,40720,40728,57,1518,2,0,'2022-10-03',16918.51,1,1.00,'Factura A N°: 0002-00054131',NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(233,7968,3,40720,40723,57,1518,2,0,'2022-10-05',12696.39,1,1.00,'Factura A N°: 0004-00074140',NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(234,7968,3,40720,40726,57,1518,2,0,'2022-10-05',10871.19,1,1.00,'Factura A N°: 0009-01037574',NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(235,7968,3,40720,40721,57,1518,2,0,'2022-10-06',7035.99,1,1.00,'Factura A N°: 0003-00034373',NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(236,7968,3,40720,40724,57,1518,2,0,'2022-10-10',1602.71,1,1.00,'Factura A N°: 0002-01926237',NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(237,7968,3,40720,40725,57,1518,2,0,'2022-10-10',167.21,1,1.00,'Factura A N°: 0001-01594379',NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(238,7968,3,40720,40727,57,1518,2,0,'2022-10-11',940.92,1,1.00,'Factura A N°: 0006-00003134',NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(239,7968,3,40720,40723,57,1518,2,0,'2022-10-12',13614.15,1,1.00,'Factura A N°: 0004-00074250',NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(240,7968,3,40720,40722,57,1518,2,0,'2022-10-12',17215.16,1,1.00,'Factura B N°: 9269-00453796',NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(241,7968,3,40720,40722,57,1518,1,0,'2022-10-12',17215.16,1,1.00,'Nota de crédito B N°: 9270-00109200',NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(242,7968,3,40720,40728,57,1518,2,0,'2022-10-13',9246.15,1,1.00,'Factura A N°: 0002-00054345',NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(243,7968,3,40720,40721,57,1518,2,0,'2022-10-13',7114.33,1,1.00,'Factura A N°: 0003-00034501',NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(244,7968,3,40720,40730,57,1518,2,0,'2022-10-13',116160.00,1,1.00,'Factura A N°: 0003-00000011',NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(245,7968,3,40720,40729,57,1518,2,0,'2022-10-13',13300.04,1,1.00,'Factura A N°: 0005-00004196',NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(246,7968,3,40720,40722,57,1518,2,0,'2022-10-13',0.00,1,1.00,'Factura B N°: 9269-00453832',NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL);
INSERT INTO `cta_cte_cliente` VALUES (247,7968,3,40720,40722,57,1518,2,0,'2022-10-13',17204.45,1,1.00,'Factura B N°: 9269-00453833',NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(248,7968,3,40720,40731,57,1518,2,0,'2022-10-16',4899.46,1,1.00,'Factura A N°: 0026-00690890',NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(249,7968,3,40720,40725,57,1518,2,0,'2022-10-17',126.54,1,1.00,'Factura A N°: 0001-01614474',NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(250,7968,3,40720,40724,57,1518,2,0,'2022-10-17',973.40,1,1.00,'Factura A N°: 0002-01949930',NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(251,7968,3,40720,40728,57,1518,2,0,'2022-10-17',7222.64,1,1.00,'Factura A N°: 0002-00054426',NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(252,7968,3,40720,40727,57,1518,2,0,'2022-10-17',20865.98,1,1.00,'Factura A N°: 0006-00003282',NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(253,7968,3,40720,40721,57,1518,2,0,'2022-10-20',4047.56,1,1.00,'Factura A N°: 0003-00034635',NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(254,7968,3,40720,40723,57,1518,2,0,'2022-10-21',14362.65,1,1.00,'Factura A N°: 0004-00074487',NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(255,7968,3,40720,40725,57,1518,2,0,'2022-10-24',404.13,1,1.00,'Factura A N°: 0001-01635018',NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(256,7968,3,40720,40724,57,1518,2,0,'2022-10-24',3162.00,1,1.00,'Factura A N°: 0002-01973406',NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(257,7968,3,40720,40734,57,1518,2,0,'2022-10-24',32549.25,1,1.00,'Factura A N°: 1428-00018715',NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(258,7968,3,40720,40728,57,1518,2,0,'2022-10-27',13038.51,1,1.00,'Factura A N°: 0002-00054700',NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(259,7968,3,40720,40721,57,1518,2,0,'2022-10-27',15715.38,1,1.00,'Factura A N°: 0003-00034781',NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(260,7968,3,40720,40722,57,1518,2,0,'2022-10-27',0.00,1,1.00,'Factura B N°: 9269-00454476',NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(261,7968,3,40720,40722,57,1518,2,0,'2022-10-27',8164.91,1,1.00,'Factura B N°: 9269-00454477',NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(262,7968,3,40720,40729,57,1518,2,0,'2022-10-28',13300.04,1,1.00,'Factura A N°: 0005-00004234',NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(263,7968,3,40720,40725,57,1518,2,0,'2022-10-31',91.31,1,1.00,'Factura A N°: 0001-01655010',NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(264,7968,3,40720,40724,57,1518,2,0,'2022-10-31',1370.20,1,1.00,'Factura A N°: 0002-01996759',NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(265,7968,3,40720,40724,57,1518,1,0,'2022-10-31',811.00,1,1.00,'Nota de crédito A N°: 0008-00448531',NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(266,7968,3,40720,40719,57,1518,2,0,'2022-10-31',25900.00,1,1.00,'Factura C N°: 0002-00000866',NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(267,7968,2,40720,40738,13,1518,1,0,'2022-10-01',2330.00,1,1.00,'Tique Factura B N°: 0013-00021172',NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(268,7968,2,40720,40738,13,1518,1,0,'2022-10-01',840.00,1,1.00,'Tique Factura B N°: 0013-00021173',NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(269,7968,2,40720,40738,13,1518,1,0,'2022-10-01',500.00,1,1.00,'Tique Factura B N°: 0013-00021174',NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(270,7968,2,40720,40738,13,1518,1,0,'2022-10-01',340.00,1,1.00,'Tique Factura B N°: 0013-00021175',NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(271,7968,2,40720,40738,13,1518,1,0,'2022-10-01',2300.00,1,1.00,'Tique Factura B N°: 0013-00021176',NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(272,7968,2,40720,40738,13,1518,1,0,'2022-10-01',1540.00,1,1.00,'Tique Factura B N°: 0013-00021177',NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL);
INSERT INTO `cta_cte_cliente` VALUES (273,7968,2,40720,40738,13,1518,1,0,'2022-10-01',3460.00,1,1.00,'Tique Factura B N°: 0013-00021178',NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(274,7968,2,40720,40738,13,1518,1,0,'2022-10-01',1660.00,1,1.00,'Tique Factura B N°: 0013-00021179',NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(275,7968,2,40720,40738,13,1518,1,0,'2022-10-01',7860.00,1,1.00,'Tique Factura B N°: 0013-00021180',NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(276,7968,2,40720,40738,13,1518,1,0,'2022-10-01',1940.00,1,1.00,'Tique Factura B N°: 0013-00021181',NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(277,7968,2,40720,40738,13,1518,1,0,'2022-10-01',540.00,1,1.00,'Tique Factura B N°: 0013-00021182',NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(278,7968,2,40720,40738,13,1518,1,0,'2022-10-01',1110.00,1,1.00,'Tique Factura B N°: 0013-00021183',NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(279,7968,2,40720,40738,13,1518,1,0,'2022-10-01',2300.00,1,1.00,'Tique Factura B N°: 0013-00021184',NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(280,7968,2,40720,40738,13,1518,1,0,'2022-10-01',1270.00,1,1.00,'Tique Factura B N°: 0013-00021186',NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(281,7968,2,40720,40738,13,1518,1,0,'2022-10-01',2590.00,1,1.00,'Tique Factura B N°: 0013-00021188',NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(282,7968,2,40720,40738,13,1518,1,0,'2022-10-03',600.00,1,1.00,'Tique Factura B N°: 0013-00021189',NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(283,7968,2,40720,40738,13,1518,1,0,'2022-10-03',1860.00,1,1.00,'Tique Factura B N°: 0013-00021192',NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(284,7968,2,40720,40738,13,1518,1,0,'2022-10-03',2280.00,1,1.00,'Tique Factura B N°: 0013-00021194',NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(285,7968,2,40720,40738,13,1518,1,0,'2022-10-03',1290.00,1,1.00,'Tique Factura B N°: 0013-00021195',NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(286,7968,2,40720,40738,13,1518,1,0,'2022-10-03',600.00,1,1.00,'Tique Factura B N°: 0013-00021196',NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(287,7968,2,40720,40738,13,1518,1,0,'2022-10-03',2900.00,1,1.00,'Tique Factura B N°: 0013-00021197',NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(288,7968,2,40720,40738,13,1518,1,0,'2022-10-03',1290.00,1,1.00,'Tique Factura B N°: 0013-00021198',NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(289,7968,2,40720,40738,13,1518,1,0,'2022-10-03',2260.00,1,1.00,'Tique Factura B N°: 0013-00021199',NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(290,7968,2,40720,40738,13,1518,1,0,'2022-10-03',720.00,1,1.00,'Tique Factura B N°: 0013-00021200',NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(291,7968,2,40720,40738,13,1518,1,0,'2022-10-03',1100.00,1,1.00,'Tique Factura B N°: 0013-00021202',NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(292,7968,2,40720,40738,13,1518,1,0,'2022-10-03',490.00,1,1.00,'Tique Factura B N°: 0013-00021203',NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(293,7968,2,40720,40738,13,1518,1,0,'2022-10-03',530.00,1,1.00,'Tique Factura B N°: 0013-00021204',NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(294,7968,2,40720,40738,13,1518,1,0,'2022-10-03',2640.00,1,1.00,'Tique Factura B N°: 0013-00021206',NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(295,7968,2,40720,40738,13,1518,1,0,'2022-10-03',1150.00,1,1.00,'Tique Factura B N°: 0013-00021207',NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(296,7968,2,40720,40738,13,1518,1,0,'2022-10-03',440.00,1,1.00,'Tique Factura B N°: 0013-00021208',NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(297,7968,2,40720,40738,13,1518,1,0,'2022-10-03',950.00,1,1.00,'Tique Factura B N°: 0013-00021209',NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL);
INSERT INTO `cta_cte_cliente` VALUES (298,7968,2,40720,40738,13,1518,1,0,'2022-10-03',590.00,1,1.00,'Tique Factura B N°: 0013-00021212',NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(299,7968,2,40720,40738,13,1518,1,0,'2022-10-03',2400.00,1,1.00,'Tique Factura B N°: 0013-00021215',NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(300,7968,2,40720,40738,13,1518,1,0,'2022-10-04',1230.00,1,1.00,'Tique Factura B N°: 0013-00021216',NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(301,7968,2,40720,40738,13,1518,1,0,'2022-10-04',2470.00,1,1.00,'Tique Factura B N°: 0013-00021217',NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(302,7968,2,40720,40738,13,1518,1,0,'2022-10-04',1290.00,1,1.00,'Tique Factura B N°: 0013-00021220',NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(303,7968,2,40720,40738,13,1518,1,0,'2022-10-04',2300.00,1,1.00,'Tique Factura B N°: 0013-00021221',NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(304,7968,2,40720,40738,13,1518,1,0,'2022-10-04',930.00,1,1.00,'Tique Factura B N°: 0013-00021222',NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(305,7968,2,40720,40738,13,1518,1,0,'2022-10-04',3120.00,1,1.00,'Tique Factura B N°: 0013-00021223',NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(306,7968,2,40720,40738,13,1518,1,0,'2022-10-04',380.00,1,1.00,'Tique Factura B N°: 0013-00021224',NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(307,7968,2,40720,40738,13,1518,1,0,'2022-10-04',700.00,1,1.00,'Tique Factura B N°: 0013-00021227',NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(308,7968,2,40720,40738,13,1518,1,0,'2022-10-04',1210.00,1,1.00,'Tique Factura B N°: 0013-00021229',NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(309,7968,2,40720,40738,13,1518,1,0,'2022-10-04',2110.00,1,1.00,'Tique Factura B N°: 0013-00021230',NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(310,7968,2,40720,40738,13,1518,1,0,'2022-10-04',1110.00,1,1.00,'Tique Factura B N°: 0013-00021231',NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(311,7968,2,40720,40738,13,1518,1,0,'2022-10-04',1800.00,1,1.00,'Tique Factura B N°: 0013-00021233',NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(312,7968,2,40720,40738,13,1518,1,0,'2022-10-04',820.00,1,1.00,'Tique Factura B N°: 0013-00021234',NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(313,7968,2,40720,40738,13,1518,1,0,'2022-10-04',3800.00,1,1.00,'Tique Factura B N°: 0013-00021235',NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(314,7968,2,40720,40738,13,1518,1,0,'2022-10-05',930.00,1,1.00,'Tique Factura B N°: 0013-00021236',NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(315,7968,2,40720,40738,13,1518,1,0,'2022-10-05',950.00,1,1.00,'Tique Factura B N°: 0013-00021238',NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(316,7968,2,40720,40738,13,1518,1,0,'2022-10-05',330.00,1,1.00,'Tique Factura B N°: 0013-00021239',NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(317,7968,2,40720,40738,13,1518,1,0,'2022-10-05',1470.00,1,1.00,'Tique Factura B N°: 0013-00021240',NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(318,7968,2,40720,40738,13,1518,1,0,'2022-10-05',930.00,1,1.00,'Tique Factura B N°: 0013-00021241',NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(319,7968,2,40720,40738,13,1518,1,0,'2022-10-05',890.00,1,1.00,'Tique Factura B N°: 0013-00021242',NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(320,7968,2,40720,40738,13,1518,1,0,'2022-10-05',1550.00,1,1.00,'Tique Factura B N°: 0013-00021243',NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(321,7968,2,40720,40738,13,1518,1,0,'2022-10-05',1080.00,1,1.00,'Tique Factura B N°: 0013-00021244',NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(322,7968,2,40720,40738,13,1518,1,0,'2022-10-06',1120.00,1,1.00,'Tique Factura B N°: 0013-00021245',NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL);
INSERT INTO `cta_cte_cliente` VALUES (323,7968,2,40720,40738,13,1518,1,0,'2022-10-06',930.00,1,1.00,'Tique Factura B N°: 0013-00021246',NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(324,7968,2,40720,40738,13,1518,1,0,'2022-10-06',3300.00,1,1.00,'Tique Factura B N°: 0013-00021247',NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(325,7968,2,40720,40738,13,1518,1,0,'2022-10-06',3650.00,1,1.00,'Tique Factura B N°: 0013-00021248',NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(326,7968,2,40720,40738,13,1518,1,0,'2022-10-06',1100.00,1,1.00,'Tique Factura B N°: 0013-00021249',NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(327,7968,2,40720,40738,13,1518,1,0,'2022-10-06',2580.00,1,1.00,'Tique Factura B N°: 0013-00021250',NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(328,7968,2,40720,40738,13,1518,1,0,'2022-10-06',2800.00,1,1.00,'Tique Factura B N°: 0013-00021251',NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(329,7968,2,40720,40738,13,1518,1,0,'2022-10-06',2010.00,1,1.00,'Tique Factura B N°: 0013-00021252',NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(330,7968,2,40720,40738,13,1518,1,0,'2022-10-06',3880.00,1,1.00,'Tique Factura B N°: 0013-00021253',NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(331,7968,2,40720,40738,13,1518,1,0,'2022-10-06',2800.00,1,1.00,'Tique Factura B N°: 0013-00021254',NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(332,7968,2,40720,40738,13,1518,1,0,'2022-10-06',600.00,1,1.00,'Tique Factura B N°: 0013-00021256',NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(333,7968,2,40720,40738,13,1518,1,0,'2022-10-06',1270.00,1,1.00,'Tique Factura B N°: 0013-00021257',NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(334,7968,2,40720,40738,13,1518,1,0,'2022-10-06',880.00,1,1.00,'Tique Factura B N°: 0013-00021259',NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(335,7968,2,40720,40738,13,1518,1,0,'2022-10-06',830.00,1,1.00,'Tique Factura B N°: 0013-00021260',NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(336,7968,2,40720,40738,13,1518,1,0,'2022-10-06',2010.00,1,1.00,'Tique Factura B N°: 0013-00021262',NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(337,7968,2,40720,40738,13,1518,1,0,'2022-10-07',1190.00,1,1.00,'Tique Factura B N°: 0013-00021263',NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(338,7968,2,40720,40738,13,1518,1,0,'2022-10-07',500.00,1,1.00,'Tique Factura B N°: 0013-00021266',NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(339,7968,2,40720,40738,13,1518,1,0,'2022-10-07',1690.00,1,1.00,'Tique Factura B N°: 0013-00021268',NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(340,7968,2,40720,40738,13,1518,1,0,'2022-10-07',1260.00,1,1.00,'Tique Factura B N°: 0013-00021274',NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(341,7968,2,40720,40738,13,1518,1,0,'2022-10-07',530.00,1,1.00,'Tique Factura B N°: 0013-00021275',NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(342,7968,2,40720,40738,13,1518,1,0,'2022-10-07',1940.00,1,1.00,'Tique Factura B N°: 0013-00021276',NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(343,7968,2,40720,40738,13,1518,1,0,'2022-10-07',550.00,1,1.00,'Tique Factura B N°: 0013-00021277',NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(344,7968,2,40720,40738,13,1518,1,0,'2022-10-07',1170.00,1,1.00,'Tique Factura B N°: 0013-00021279',NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(345,7968,2,40720,40738,13,1518,1,0,'2022-10-07',1720.00,1,1.00,'Tique Factura B N°: 0013-00021280',NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(346,7968,2,40720,40738,13,1518,1,0,'2022-10-07',2490.00,1,1.00,'Tique Factura B N°: 0013-00021282',NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(347,7968,2,40720,40738,13,1518,1,0,'2022-10-07',2340.00,1,1.00,'Tique Factura B N°: 0013-00021283',NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL);
INSERT INTO `cta_cte_cliente` VALUES (348,7968,2,40720,40738,13,1518,1,0,'2022-10-08',2950.00,1,1.00,'Tique Factura B N°: 0013-00021284',NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(349,7968,2,40720,40738,13,1518,1,0,'2022-10-08',3450.00,1,1.00,'Tique Factura B N°: 0013-00021285',NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(350,7968,2,40720,40738,13,1518,1,0,'2022-10-08',3200.00,1,1.00,'Tique Factura B N°: 0013-00021287',NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(351,7968,2,40720,40738,13,1518,1,0,'2022-10-08',1110.00,1,1.00,'Tique Factura B N°: 0013-00021288',NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(352,7968,2,40720,40738,13,1518,1,0,'2022-10-08',540.00,1,1.00,'Tique Factura B N°: 0013-00021289',NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(353,7968,2,40720,40738,13,1518,1,0,'2022-10-08',1490.00,1,1.00,'Tique Factura B N°: 0013-00021290',NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(354,7968,2,40720,40738,13,1518,1,0,'2022-10-08',1800.00,1,1.00,'Tique Factura B N°: 0013-00021291',NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(355,7968,2,40720,40738,13,1518,1,0,'2022-10-08',950.00,1,1.00,'Tique Factura B N°: 0013-00021292',NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(356,7968,2,40720,40738,13,1518,1,0,'2022-10-11',2520.00,1,1.00,'Tique Factura B N°: 0013-00021293',NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(357,7968,2,40720,40738,13,1518,1,0,'2022-10-11',1810.00,1,1.00,'Tique Factura B N°: 0013-00021294',NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(358,7968,2,40720,40738,13,1518,1,0,'2022-10-11',2600.00,1,1.00,'Tique Factura B N°: 0013-00021296',NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(359,7968,2,40720,40738,13,1518,1,0,'2022-10-11',1500.00,1,1.00,'Tique Factura B N°: 0013-00021297',NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(360,7968,2,40720,40738,13,1518,1,0,'2022-10-11',1100.00,1,1.00,'Tique Factura B N°: 0013-00021298',NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(361,7968,2,40720,40738,13,1518,1,0,'2022-10-11',2680.00,1,1.00,'Tique Factura B N°: 0013-00021299',NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(362,7968,2,40720,40738,13,1518,1,0,'2022-10-11',2260.00,1,1.00,'Tique Factura B N°: 0013-00021300',NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(363,7968,2,40720,40738,13,1518,1,0,'2022-10-12',530.00,1,1.00,'Tique Factura B N°: 0013-00021301',NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(364,7968,2,40720,40738,13,1518,1,0,'2022-10-12',2120.00,1,1.00,'Tique Factura B N°: 0013-00021302',NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(365,7968,2,40720,40738,13,1518,1,0,'2022-10-12',9820.00,1,1.00,'Tique Factura B N°: 0013-00021303',NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(366,7968,2,40720,40738,13,1518,1,0,'2022-10-12',7680.00,1,1.00,'Tique Factura B N°: 0013-00021304',NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(367,7968,2,40720,40738,13,1518,1,0,'2022-10-12',1860.00,1,1.00,'Tique Factura B N°: 0013-00021305',NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(368,7968,2,40720,40738,13,1518,1,0,'2022-10-12',1360.00,1,1.00,'Tique Factura B N°: 0013-00021306',NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(369,7968,2,40720,40738,13,1518,1,0,'2022-10-12',1140.00,1,1.00,'Tique Factura B N°: 0013-00021307',NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(370,7968,2,40720,40738,13,1518,1,0,'2022-10-12',1100.00,1,1.00,'Tique Factura B N°: 0013-00021308',NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(371,7968,2,40720,40738,13,1518,1,0,'2022-10-12',600.00,1,1.00,'Tique Factura B N°: 0013-00021309',NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(372,7968,2,40720,40738,13,1518,1,0,'2022-10-12',770.00,1,1.00,'Tique Factura B N°: 0013-00021310',NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL);
INSERT INTO `cta_cte_cliente` VALUES (373,7968,2,40720,40738,13,1518,1,0,'2022-10-12',1470.00,1,1.00,'Tique Factura B N°: 0013-00021311',NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(374,7968,2,40720,40738,13,1518,1,0,'2022-10-13',440.00,1,1.00,'Tique Factura B N°: 0013-00021312',NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(375,7968,2,40720,40738,13,1518,1,0,'2022-10-13',1210.00,1,1.00,'Tique Factura B N°: 0013-00021313',NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(376,7968,2,40720,40738,13,1518,1,0,'2022-10-13',1860.00,1,1.00,'Tique Factura B N°: 0013-00021314',NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(377,7968,2,40720,40738,13,1518,1,0,'2022-10-13',500.00,1,1.00,'Tique Factura B N°: 0013-00021315',NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(378,7968,2,40720,40738,13,1518,1,0,'2022-10-13',1470.00,1,1.00,'Tique Factura B N°: 0013-00021316',NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(379,7968,2,40720,40738,13,1518,1,0,'2022-10-13',1540.00,1,1.00,'Tique Factura B N°: 0013-00021317',NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(380,7968,2,40720,40738,13,1518,1,0,'2022-10-13',660.00,1,1.00,'Tique Factura B N°: 0013-00021318',NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(381,7968,2,40720,40738,13,1518,1,0,'2022-10-13',600.00,1,1.00,'Tique Factura B N°: 0013-00021319',NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(382,7968,2,40720,40738,13,1518,1,0,'2022-10-13',1100.00,1,1.00,'Tique Factura B N°: 0013-00021320',NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(383,7968,2,40720,40738,13,1518,1,0,'2022-10-13',940.00,1,1.00,'Tique Factura B N°: 0013-00021321',NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(384,7968,2,40720,40738,13,1518,1,0,'2022-10-13',870.00,1,1.00,'Tique Factura B N°: 0013-00021322',NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(385,7968,2,40720,40738,13,1518,1,0,'2022-10-13',1280.00,1,1.00,'Tique Factura B N°: 0013-00021324',NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(386,7968,2,40720,40738,13,1518,1,0,'2022-10-13',1960.00,1,1.00,'Tique Factura B N°: 0013-00021325',NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(387,7968,2,40720,40738,13,1518,1,0,'2022-10-13',2460.00,1,1.00,'Tique Factura B N°: 0013-00021326',NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(388,7968,2,40720,40738,13,1518,1,0,'2022-10-14',670.00,1,1.00,'Tique Factura B N°: 0013-00021328',NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(389,7968,2,40720,40738,13,1518,1,0,'2022-10-14',2280.00,1,1.00,'Tique Factura B N°: 0013-00021329',NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(390,7968,2,40720,40738,13,1518,1,0,'2022-10-14',1920.00,1,1.00,'Tique Factura B N°: 0013-00021330',NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(391,7968,2,40720,40738,13,1518,1,0,'2022-10-14',1290.00,1,1.00,'Tique Factura B N°: 0013-00021331',NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(392,7968,2,40720,40738,13,1518,1,0,'2022-10-14',630.00,1,1.00,'Tique Factura B N°: 0013-00021332',NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(393,7968,2,40720,40738,13,1518,1,0,'2022-10-14',520.00,1,1.00,'Tique Factura B N°: 0013-00021333',NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(394,7968,2,40720,40738,13,1518,1,0,'2022-10-14',1100.00,1,1.00,'Tique Factura B N°: 0013-00021334',NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(395,7968,2,40720,40738,13,1518,1,0,'2022-10-14',2730.00,1,1.00,'Tique Factura B N°: 0013-00021335',NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(396,7968,2,40720,40738,13,1518,1,0,'2022-10-14',1170.00,1,1.00,'Tique Factura B N°: 0013-00021336',NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(397,7968,2,40720,40738,13,1518,1,0,'2022-10-14',1010.00,1,1.00,'Tique Factura B N°: 0013-00021337',NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL);
INSERT INTO `cta_cte_cliente` VALUES (398,7968,2,40720,40738,13,1518,1,0,'2022-10-14',880.00,1,1.00,'Tique Factura B N°: 0013-00021338',NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(399,7968,2,40720,40738,13,1518,1,0,'2022-10-15',830.00,1,1.00,'Tique Factura B N°: 0013-00021339',NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(400,7968,2,40720,40738,13,1518,1,0,'2022-10-15',410.00,1,1.00,'Tique Factura B N°: 0013-00021341',NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(401,7968,2,40720,40738,13,1518,1,0,'2022-10-15',2690.00,1,1.00,'Tique Factura B N°: 0013-00021343',NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(402,7968,2,40720,40738,13,1518,1,0,'2022-10-15',2840.00,1,1.00,'Tique Factura B N°: 0013-00021344',NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(403,7968,2,40720,40738,13,1518,1,0,'2022-10-15',1690.00,1,1.00,'Tique Factura B N°: 0013-00021345',NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(404,7968,2,40720,40738,13,1518,1,0,'2022-10-15',1510.00,1,1.00,'Tique Factura B N°: 0013-00021346',NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(405,7968,2,40720,40738,13,1518,1,0,'2022-10-15',2440.00,1,1.00,'Tique Factura B N°: 0013-00021347',NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(406,7968,2,40720,40738,13,1518,1,0,'2022-10-15',420.00,1,1.00,'Tique Factura B N°: 0013-00021348',NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(407,7968,2,40720,40738,13,1518,1,0,'2022-10-15',580.00,1,1.00,'Tique Factura B N°: 0013-00021349',NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(408,7968,2,40720,40738,13,1518,1,0,'2022-10-15',1490.00,1,1.00,'Tique Factura B N°: 0013-00021350',NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(409,7968,2,40720,40738,13,1518,1,0,'2022-10-17',330.00,1,1.00,'Tique Factura B N°: 0013-00021351',NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(410,7968,2,40720,40738,13,1518,1,0,'2022-10-17',1890.00,1,1.00,'Tique Factura B N°: 0013-00021352',NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(411,7968,2,40720,40738,13,1518,1,0,'2022-10-17',2180.00,1,1.00,'Tique Factura B N°: 0013-00021353',NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(412,7968,2,40720,40738,13,1518,1,0,'2022-10-17',1770.00,1,1.00,'Tique Factura B N°: 0013-00021354',NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(413,7968,2,40720,40738,13,1518,1,0,'2022-10-17',3400.00,1,1.00,'Tique Factura B N°: 0013-00021356',NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(414,7968,2,40720,40738,13,1518,1,0,'2022-10-17',630.00,1,1.00,'Tique Factura B N°: 0013-00021357',NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(415,7968,2,40720,40738,13,1518,1,0,'2022-10-17',1470.00,1,1.00,'Tique Factura B N°: 0013-00021358',NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(416,7968,2,40720,40738,13,1518,1,0,'2022-10-17',770.00,1,1.00,'Tique Factura B N°: 0013-00021359',NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(417,7968,2,40720,40738,13,1518,1,0,'2022-10-18',440.00,1,1.00,'Tique Factura B N°: 0013-00021360',NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(418,7968,2,40720,40738,13,1518,1,0,'2022-10-18',2300.00,1,1.00,'Tique Factura B N°: 0013-00021361',NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(419,7968,2,40720,40738,13,1518,1,0,'2022-10-18',3400.00,1,1.00,'Tique Factura B N°: 0013-00021363',NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(420,7968,2,40720,40738,13,1518,1,0,'2022-10-18',3250.00,1,1.00,'Tique Factura B N°: 0013-00021364',NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(421,7968,2,40720,40738,13,1518,1,0,'2022-10-18',1580.00,1,1.00,'Tique Factura B N°: 0013-00021365',NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(422,7968,2,40720,40738,13,1518,1,0,'2022-10-18',2200.00,1,1.00,'Tique Factura B N°: 0013-00021366',NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL);
INSERT INTO `cta_cte_cliente` VALUES (423,7968,2,40720,40738,13,1518,1,0,'2022-10-18',1200.00,1,1.00,'Tique Factura B N°: 0013-00021367',NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(424,7968,2,40720,40738,13,1518,1,0,'2022-10-18',880.00,1,1.00,'Tique Factura B N°: 0013-00021368',NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(425,7968,2,40720,40738,13,1518,1,0,'2022-10-18',560.00,1,1.00,'Tique Factura B N°: 0013-00021369',NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(426,7968,2,40720,40738,13,1518,1,0,'2022-10-18',1700.00,1,1.00,'Tique Factura B N°: 0013-00021370',NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(427,7968,2,40720,40738,13,1518,1,0,'2022-10-18',1100.00,1,1.00,'Tique Factura B N°: 0013-00021371',NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(428,7968,2,40720,40738,13,1518,1,0,'2022-10-18',1800.00,1,1.00,'Tique Factura B N°: 0013-00021373',NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(429,7968,2,40720,40738,13,1518,1,0,'2022-10-18',890.00,1,1.00,'Tique Factura B N°: 0013-00021374',NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(430,7968,2,40720,40738,13,1518,1,0,'2022-10-18',1050.00,1,1.00,'Tique Factura B N°: 0013-00021376',NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(431,7968,2,40720,40738,13,1518,1,0,'2022-10-18',1670.00,1,1.00,'Tique Factura B N°: 0013-00021378',NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(432,7968,2,40720,40738,13,1518,1,0,'2022-10-19',1300.00,1,1.00,'Tique Factura B N°: 0013-00021379',NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(433,7968,2,40720,40738,13,1518,1,0,'2022-10-19',1590.00,1,1.00,'Tique Factura B N°: 0013-00021380',NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(434,7968,2,40720,40738,13,1518,1,0,'2022-10-19',2280.00,1,1.00,'Tique Factura B N°: 0013-00021381',NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(435,7968,2,40720,40738,13,1518,1,0,'2022-10-19',930.00,1,1.00,'Tique Factura B N°: 0013-00021382',NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(436,7968,2,40720,40738,13,1518,1,0,'2022-10-19',2010.00,1,1.00,'Tique Factura B N°: 0013-00021383',NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(437,7968,2,40720,40738,13,1518,1,0,'2022-10-19',860.00,1,1.00,'Tique Factura B N°: 0013-00021384',NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(438,7968,2,40720,40738,13,1518,1,0,'2022-10-19',600.00,1,1.00,'Tique Factura B N°: 0013-00021385',NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(439,7968,2,40720,40738,13,1518,1,0,'2022-10-19',1430.00,1,1.00,'Tique Factura B N°: 0013-00021386',NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(440,7968,2,40720,40738,13,1518,1,0,'2022-10-19',930.00,1,1.00,'Tique Factura B N°: 0013-00021387',NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(441,7968,2,40720,40738,13,1518,1,0,'2022-10-20',3400.00,1,1.00,'Tique Factura B N°: 0013-00021389',NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(442,7968,2,40720,40738,13,1518,1,0,'2022-10-20',380.00,1,1.00,'Tique Factura B N°: 0013-00021390',NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(443,7968,2,40720,40738,13,1518,1,0,'2022-10-20',2460.00,1,1.00,'Tique Factura B N°: 0013-00021392',NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(444,7968,2,40720,40738,13,1518,1,0,'2022-10-20',1730.00,1,1.00,'Tique Factura B N°: 0013-00021393',NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(445,7968,2,40720,40738,13,1518,1,0,'2022-10-20',1340.00,1,1.00,'Tique Factura B N°: 0013-00021394',NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(446,7968,2,40720,40738,13,1518,1,0,'2022-10-20',2340.00,1,1.00,'Tique Factura B N°: 0013-00021395',NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(447,7968,2,40720,40738,13,1518,1,0,'2022-10-20',1100.00,1,1.00,'Tique Factura B N°: 0013-00021396',NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL);
INSERT INTO `cta_cte_cliente` VALUES (448,7968,2,40720,40738,13,1518,1,0,'2022-10-20',930.00,1,1.00,'Tique Factura B N°: 0013-00021397',NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(449,7968,2,40720,40738,13,1518,1,0,'2022-10-20',330.00,1,1.00,'Tique Factura B N°: 0013-00021398',NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(450,7968,2,40720,40738,13,1518,1,0,'2022-10-20',1420.00,1,1.00,'Tique Factura B N°: 0013-00021399',NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(451,7968,2,40720,40738,13,1518,1,0,'2022-10-20',1170.00,1,1.00,'Tique Factura B N°: 0013-00021400',NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(452,7968,2,40720,40738,13,1518,1,0,'2022-10-20',1260.00,1,1.00,'Tique Factura B N°: 0013-00021401',NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(453,7968,2,40720,40738,13,1518,1,0,'2022-10-21',2310.00,1,1.00,'Tique Factura B N°: 0013-00021402',NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(454,7968,2,40720,40738,13,1518,1,0,'2022-10-21',930.00,1,1.00,'Tique Factura B N°: 0013-00021403',NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(455,7968,2,40720,40738,13,1518,1,0,'2022-10-21',2390.00,1,1.00,'Tique Factura B N°: 0013-00021404',NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(456,7968,2,40720,40738,13,1518,1,0,'2022-10-21',1500.00,1,1.00,'Tique Factura B N°: 0013-00021405',NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(457,7968,2,40720,40738,13,1518,1,0,'2022-10-21',2000.00,1,1.00,'Tique Factura B N°: 0013-00021406',NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(458,7968,2,40720,40738,13,1518,1,0,'2022-10-21',1510.00,1,1.00,'Tique Factura B N°: 0013-00021407',NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(459,7968,2,40720,40738,13,1518,1,0,'2022-10-21',820.00,1,1.00,'Tique Factura B N°: 0013-00021408',NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(460,7968,2,40720,40738,13,1518,1,0,'2022-10-21',1250.00,1,1.00,'Tique Factura B N°: 0013-00021409',NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(461,7968,2,40720,40738,13,1518,1,0,'2022-10-22',410.00,1,1.00,'Tique Factura B N°: 0013-00021411',NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(462,7968,2,40720,40738,13,1518,1,0,'2022-10-22',1460.00,1,1.00,'Tique Factura B N°: 0013-00021412',NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(463,7968,2,40720,40738,13,1518,1,0,'2022-10-22',3290.00,1,1.00,'Tique Factura B N°: 0013-00021413',NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(464,7968,2,40720,40738,13,1518,1,0,'2022-10-22',1750.00,1,1.00,'Tique Factura B N°: 0013-00021414',NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(465,7968,2,40720,40738,13,1518,1,0,'2022-10-22',1670.00,1,1.00,'Tique Factura B N°: 0013-00021415',NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(466,7968,2,40720,40738,13,1518,1,0,'2022-10-22',3960.00,1,1.00,'Tique Factura B N°: 0013-00021416',NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(467,7968,2,40720,40738,13,1518,1,0,'2022-10-22',1630.00,1,1.00,'Tique Factura B N°: 0013-00021417',NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(468,7968,2,40720,40738,13,1518,1,0,'2022-10-22',4010.00,1,1.00,'Tique Factura B N°: 0013-00021418',NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(469,7968,2,40720,40738,13,1518,1,0,'2022-10-22',1010.00,1,1.00,'Tique Factura B N°: 0013-00021419',NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(470,7968,2,40720,40738,13,1518,1,0,'2022-10-22',1510.00,1,1.00,'Tique Factura B N°: 0013-00021420',NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(471,7968,2,40720,40738,13,1518,1,0,'2022-10-22',2180.00,1,1.00,'Tique Factura B N°: 0013-00021421',NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(472,7968,2,40720,40738,13,1518,1,0,'2022-10-22',1310.00,1,1.00,'Tique Factura B N°: 0013-00021422',NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL);
INSERT INTO `cta_cte_cliente` VALUES (473,7968,2,40720,40738,13,1518,1,0,'2022-10-24',420.00,1,1.00,'Tique Factura B N°: 0013-00021423',NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(474,7968,2,40720,40738,13,1518,1,0,'2022-10-24',2510.00,1,1.00,'Tique Factura B N°: 0013-00021424',NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(475,7968,2,40720,40738,13,1518,1,0,'2022-10-24',3270.00,1,1.00,'Tique Factura B N°: 0013-00021425',NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(476,7968,2,40720,40738,13,1518,1,0,'2022-10-24',2860.00,1,1.00,'Tique Factura B N°: 0013-00021429',NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(477,7968,2,40720,40738,13,1518,1,0,'2022-10-24',3230.00,1,1.00,'Tique Factura B N°: 0013-00021430',NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(478,7968,2,40720,40738,13,1518,1,0,'2022-10-24',2390.00,1,1.00,'Tique Factura B N°: 0013-00021431',NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(479,7968,2,40720,40738,13,1518,1,0,'2022-10-24',1030.00,1,1.00,'Tique Factura B N°: 0013-00021432',NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(480,7968,2,40720,40738,13,1518,1,0,'2022-10-24',800.00,1,1.00,'Tique Factura B N°: 0013-00021433',NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(481,7968,2,40720,40738,13,1518,1,0,'2022-10-24',1100.00,1,1.00,'Tique Factura B N°: 0013-00021435',NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(482,7968,2,40720,40738,13,1518,1,0,'2022-10-24',860.00,1,1.00,'Tique Factura B N°: 0013-00021436',NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(483,7968,2,40720,40738,13,1518,1,0,'2022-10-24',2360.00,1,1.00,'Tique Factura B N°: 0013-00021437',NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(484,7968,2,40720,40738,13,1518,1,0,'2022-10-24',2250.00,1,1.00,'Tique Factura B N°: 0013-00021438',NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(485,7968,2,40720,40738,13,1518,1,0,'2022-10-25',930.00,1,1.00,'Tique Factura B N°: 0013-00021439',NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(486,7968,2,40720,40738,13,1518,1,0,'2022-10-25',3400.00,1,1.00,'Tique Factura B N°: 0013-00021440',NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(487,7968,2,40720,40738,13,1518,1,0,'2022-10-25',2390.00,1,1.00,'Tique Factura B N°: 0013-00021443',NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(488,7968,2,40720,40738,13,1518,1,0,'2022-10-25',1750.00,1,1.00,'Tique Factura B N°: 0013-00021445',NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(489,7968,2,40720,40738,13,1518,1,0,'2022-10-25',1420.00,1,1.00,'Tique Factura B N°: 0013-00021446',NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(490,7968,2,40720,40738,13,1518,1,0,'2022-10-25',1830.00,1,1.00,'Tique Factura B N°: 0013-00021447',NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(491,7968,2,40720,40738,13,1518,1,0,'2022-10-25',1400.00,1,1.00,'Tique Factura B N°: 0013-00021448',NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(492,7968,2,40720,40738,13,1518,1,0,'2022-10-25',680.00,1,1.00,'Tique Factura B N°: 0013-00021449',NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(493,7968,2,40720,40738,13,1518,1,0,'2022-10-25',2760.00,1,1.00,'Tique Factura B N°: 0013-00021450',NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(494,7968,2,40720,40738,13,1518,1,0,'2022-10-25',1210.00,1,1.00,'Tique Factura B N°: 0013-00021451',NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(495,7968,2,40720,40738,13,1518,1,0,'2022-10-26',3210.00,1,1.00,'Tique Factura B N°: 0013-00021452',NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(496,7968,2,40720,40738,13,1518,1,0,'2022-10-26',2790.00,1,1.00,'Tique Factura B N°: 0013-00021453',NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(497,7968,2,40720,40738,13,1518,1,0,'2022-10-26',2790.00,1,1.00,'Tique Factura B N°: 0013-00021454',NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL);
INSERT INTO `cta_cte_cliente` VALUES (498,7968,2,40720,40738,13,1518,1,0,'2022-10-26',1980.00,1,1.00,'Tique Factura B N°: 0013-00021455',NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(499,7968,2,40720,40738,13,1518,1,0,'2022-10-26',2380.00,1,1.00,'Tique Factura B N°: 0013-00021456',NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(500,7968,2,40720,40738,13,1518,1,0,'2022-10-26',1000.00,1,1.00,'Tique Factura B N°: 0013-00021457',NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(501,7968,2,40720,40738,13,1518,1,0,'2022-10-26',660.00,1,1.00,'Tique Factura B N°: 0013-00021458',NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(502,7968,2,40720,40738,13,1518,1,0,'2022-10-26',1550.00,1,1.00,'Tique Factura B N°: 0013-00021459',NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(503,7968,2,40720,40738,13,1518,1,0,'2022-10-26',1190.00,1,1.00,'Tique Factura B N°: 0013-00021460',NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(504,7968,2,40720,40738,13,1518,2,0,'2022-10-26',2790.00,1,1.00,'Nota de crédito B N°: 0001-00001000',NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(505,7968,2,40720,40738,13,1518,1,0,'2022-10-27',790.00,1,1.00,'Tique Factura B N°: 0013-00021461',NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(506,7968,2,40720,40738,13,1518,1,0,'2022-10-27',1300.00,1,1.00,'Tique Factura B N°: 0013-00021462',NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(507,7968,2,40720,40738,13,1518,1,0,'2022-10-27',2310.00,1,1.00,'Tique Factura B N°: 0013-00021463',NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(508,7968,2,40720,40738,13,1518,1,0,'2022-10-27',3240.00,1,1.00,'Tique Factura B N°: 0013-00021464',NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(509,7968,2,40720,40738,13,1518,1,0,'2022-10-27',930.00,1,1.00,'Tique Factura B N°: 0013-00021465',NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(510,7968,2,40720,40738,13,1518,1,0,'2022-10-27',2200.00,1,1.00,'Tique Factura B N°: 0013-00021466',NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(511,7968,2,40720,40738,13,1518,1,0,'2022-10-27',6090.00,1,1.00,'Tique Factura B N°: 0013-00021467',NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(512,7968,2,40720,40738,13,1518,1,0,'2022-10-27',1100.00,1,1.00,'Tique Factura B N°: 0013-00021468',NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(513,7968,2,40720,40738,13,1518,1,0,'2022-10-27',5070.00,1,1.00,'Tique Factura B N°: 0013-00021469',NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(514,7968,2,40720,40738,13,1518,1,0,'2022-10-27',680.00,1,1.00,'Tique Factura B N°: 0013-00021470',NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(515,7968,2,40720,40738,13,1518,1,0,'2022-10-27',1850.00,1,1.00,'Tique Factura B N°: 0013-00021471',NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(516,7968,2,40720,40738,13,1518,1,0,'2022-10-27',1500.00,1,1.00,'Tique Factura B N°: 0013-00021472',NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(517,7968,2,40720,40738,13,1518,1,0,'2022-10-28',2000.00,1,1.00,'Tique Factura B N°: 0013-00021473',NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(518,7968,2,40720,40738,13,1518,1,0,'2022-10-28',1100.00,1,1.00,'Tique Factura B N°: 0013-00021474',NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(519,7968,2,40720,40738,13,1518,1,0,'2022-10-28',2200.00,1,1.00,'Tique Factura B N°: 0013-00021475',NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(520,7968,2,40720,40738,13,1518,1,0,'2022-10-28',2390.00,1,1.00,'Tique Factura B N°: 0013-00021476',NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(521,7968,2,40720,40738,13,1518,1,0,'2022-10-28',800.00,1,1.00,'Tique Factura B N°: 0013-00021477',NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(522,7968,2,40720,40738,13,1518,1,0,'2022-10-28',1860.00,1,1.00,'Tique Factura B N°: 0013-00021478',NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL);
INSERT INTO `cta_cte_cliente` VALUES (523,7968,2,40720,40738,13,1518,1,0,'2022-10-28',2970.00,1,1.00,'Tique Factura B N°: 0013-00021479',NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(524,7968,2,40720,40738,13,1518,1,0,'2022-10-28',630.00,1,1.00,'Tique Factura B N°: 0013-00021480',NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(525,7968,2,40720,40738,13,1518,1,0,'2022-10-28',2420.00,1,1.00,'Tique Factura B N°: 0013-00021481',NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(526,7968,2,40720,40738,13,1518,1,0,'2022-10-28',2410.00,1,1.00,'Tique Factura B N°: 0013-00021482',NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(527,7968,2,40720,40738,13,1518,1,0,'2022-10-29',1490.00,1,1.00,'Tique Factura B N°: 0013-00021483',NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(528,7968,2,40720,40738,13,1518,1,0,'2022-10-29',740.00,1,1.00,'Tique Factura B N°: 0013-00021484',NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(529,7968,2,40720,40738,13,1518,1,0,'2022-10-29',950.00,1,1.00,'Tique Factura B N°: 0013-00021485',NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(530,7968,2,40720,40738,13,1518,1,0,'2022-10-29',1150.00,1,1.00,'Tique Factura B N°: 0013-00021486',NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(531,7968,2,40720,40738,13,1518,1,0,'2022-10-29',500.00,1,1.00,'Tique Factura B N°: 0013-00021487',NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(532,7968,2,40720,40738,13,1518,1,0,'2022-10-29',1460.00,1,1.00,'Tique Factura B N°: 0013-00021488',NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(533,7968,2,40720,40738,13,1518,1,0,'2022-10-29',4500.00,1,1.00,'Tique Factura B N°: 0013-00021489',NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(534,7968,2,40720,40738,13,1518,1,0,'2022-10-29',2930.00,1,1.00,'Tique Factura B N°: 0013-00021490',NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(535,7968,2,40720,40738,13,1518,1,0,'2022-10-29',3040.00,1,1.00,'Tique Factura B N°: 0013-00021491',NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(536,7968,2,40720,40738,13,1518,1,0,'2022-10-29',1010.00,1,1.00,'Tique Factura B N°: 0013-00021492',NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(537,7968,2,40720,40738,13,1518,1,0,'2022-10-29',860.00,1,1.00,'Tique Factura B N°: 0013-00021493',NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(538,7968,2,40720,40738,13,1518,1,0,'2022-10-29',440.00,1,1.00,'Tique Factura B N°: 0013-00021494',NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(539,7968,2,40720,40738,13,1518,1,0,'2022-10-29',680.00,1,1.00,'Tique Factura B N°: 0013-00021495',NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(540,7968,2,40720,40738,13,1518,1,0,'2022-10-29',3870.00,1,1.00,'Tique Factura B N°: 0013-00021496',NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(541,7968,2,40720,40738,13,1518,1,0,'2022-10-31',1190.00,1,1.00,'Tique Factura B N°: 0013-00021497',NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(542,7968,2,40720,40738,13,1518,1,0,'2022-10-31',330.00,1,1.00,'Tique Factura B N°: 0013-00021498',NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(543,7968,2,40720,40738,13,1518,1,0,'2022-10-31',2390.00,1,1.00,'Tique Factura B N°: 0013-00021499',NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(544,7968,2,40720,40738,13,1518,1,0,'2022-10-31',940.00,1,1.00,'Tique Factura B N°: 0013-00021500',NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(545,7968,2,40720,40738,13,1518,1,0,'2022-10-31',840.00,1,1.00,'Tique Factura B N°: 0013-00021501',NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(546,7968,2,40720,40738,13,1518,1,0,'2022-10-31',1040.00,1,1.00,'Tique Factura B N°: 0013-00021502',NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(547,7968,2,40720,40738,13,1518,1,0,'2022-10-31',1670.00,1,1.00,'Tique Factura B N°: 0013-00021503',NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL);
INSERT INTO `cta_cte_cliente` VALUES (548,7968,2,40720,40738,13,1518,1,0,'2022-10-31',600.00,1,1.00,'Tique Factura B N°: 0013-00021504',NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(549,7968,2,40720,40738,13,1518,1,0,'2022-10-31',1570.00,1,1.00,'Tique Factura B N°: 0013-00021505',NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(550,7968,2,40720,40738,13,1518,1,0,'2022-10-31',1100.00,1,1.00,'Tique Factura B N°: 0013-00021506',NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(551,7968,2,40720,40738,13,1518,1,0,'2022-10-31',930.00,1,1.00,'Tique Factura B N°: 0013-00021507',NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(552,7968,2,40720,40738,13,3134,1,0,'2022-09-01',960.00,1,1.00,'Tique Factura B N°: 0013-00020807',NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(553,7968,2,40720,40738,13,3134,1,0,'2022-09-01',1570.00,1,1.00,'Tique Factura B N°: 0013-00020809',NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(554,7968,2,40720,40738,13,3134,1,0,'2022-09-01',1800.00,1,1.00,'Tique Factura B N°: 0013-00020810',NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(555,7968,2,40720,40738,13,3134,1,0,'2022-09-01',1070.00,1,1.00,'Tique Factura B N°: 0013-00020811',NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(556,7968,2,40720,40738,13,3134,1,0,'2022-09-01',1230.00,1,1.00,'Tique Factura B N°: 0013-00020812',NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(557,7968,2,40720,40738,13,3134,1,0,'2022-09-01',1500.00,1,1.00,'Tique Factura B N°: 0013-00020813',NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(558,7968,2,40720,40738,13,3134,1,0,'2022-09-01',1080.00,1,1.00,'Tique Factura B N°: 0013-00020814',NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(559,7968,2,40720,40738,13,3134,1,0,'2022-09-02',490.00,1,1.00,'Tique Factura B N°: 0013-00020815',NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(560,7968,2,40720,40738,13,3134,1,0,'2022-09-02',1430.00,1,1.00,'Tique Factura B N°: 0013-00020816',NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(561,7968,2,40720,40738,13,3134,1,0,'2022-09-02',980.00,1,1.00,'Tique Factura B N°: 0013-00020817',NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(562,7968,2,40720,40738,13,3134,1,0,'2022-09-02',1580.00,1,1.00,'Tique Factura B N°: 0013-00020819',NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(563,7968,2,40720,40738,13,3134,1,0,'2022-09-02',790.00,1,1.00,'Tique Factura B N°: 0013-00020820',NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(564,7968,2,40720,40738,13,3134,1,0,'2022-09-02',1400.00,1,1.00,'Tique Factura B N°: 0013-00020821',NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(565,7968,2,40720,40738,13,3134,1,0,'2022-09-02',910.00,1,1.00,'Tique Factura B N°: 0013-00020822',NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(566,7968,2,40720,40738,13,3134,1,0,'2022-09-02',3020.00,1,1.00,'Tique Factura B N°: 0013-00020823',NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(567,7968,2,40720,40738,13,3134,1,0,'2022-09-02',3370.00,1,1.00,'Tique Factura B N°: 0013-00020824',NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(568,7968,2,40720,40738,13,3134,1,0,'2022-09-02',2520.00,1,1.00,'Tique Factura B N°: 0013-00020825',NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(569,7968,2,40720,40738,13,3134,1,0,'2022-09-03',1860.00,1,1.00,'Tique Factura B N°: 0013-00020827',NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(570,7968,2,40720,40738,13,3134,1,0,'2022-09-03',1240.00,1,1.00,'Tique Factura B N°: 0013-00020828',NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(571,7968,2,40720,40738,13,3134,1,0,'2022-09-03',1250.00,1,1.00,'Tique Factura B N°: 0013-00020830',NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(572,7968,2,40720,40738,13,3134,1,0,'2022-09-03',2860.00,1,1.00,'Tique Factura B N°: 0013-00020833',NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL);
INSERT INTO `cta_cte_cliente` VALUES (573,7968,2,40720,40738,13,3134,1,0,'2022-09-03',3370.00,1,1.00,'Tique Factura B N°: 0013-00020835',NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(574,7968,2,40720,40738,13,3134,1,0,'2022-09-03',3930.00,1,1.00,'Tique Factura B N°: 0013-00020836',NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(575,7968,2,40720,40738,13,3134,1,0,'2022-09-03',2480.00,1,1.00,'Tique Factura B N°: 0013-00020838',NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(576,7968,2,40720,40738,13,3134,1,0,'2022-09-03',960.00,1,1.00,'Tique Factura B N°: 0013-00020839',NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(577,7968,2,40720,40738,13,3134,1,0,'2022-09-03',1380.00,1,1.00,'Tique Factura B N°: 0013-00020840',NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(578,7968,2,40720,40738,13,3134,1,0,'2022-09-03',930.00,1,1.00,'Tique Factura B N°: 0013-00020842',NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(579,7968,2,40720,40738,13,3134,1,0,'2022-09-05',510.00,1,1.00,'Tique Factura B N°: 0013-00020843',NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(580,7968,2,40720,40738,13,3134,1,0,'2022-09-05',1440.00,1,1.00,'Tique Factura B N°: 0013-00020844',NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(581,7968,2,40720,40738,13,3134,1,0,'2022-09-05',1430.00,1,1.00,'Tique Factura B N°: 0013-00020845',NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(582,7968,2,40720,40738,13,3134,1,0,'2022-09-05',490.00,1,1.00,'Tique Factura B N°: 0013-00020846',NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(583,7968,2,40720,40738,13,3134,1,0,'2022-09-05',980.00,1,1.00,'Tique Factura B N°: 0013-00020848',NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(584,7968,2,40720,40738,13,3134,1,0,'2022-09-05',2030.00,1,1.00,'Tique Factura B N°: 0013-00020850',NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(585,7968,2,40720,40738,13,3134,1,0,'2022-09-05',750.00,1,1.00,'Tique Factura B N°: 0013-00020851',NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(586,7968,2,40720,40738,13,3134,1,0,'2022-09-05',440.00,1,1.00,'Tique Factura B N°: 0013-00020852',NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(587,7968,2,40720,40738,13,3134,1,0,'2022-09-05',1340.00,1,1.00,'Tique Factura B N°: 0013-00020853',NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(588,7968,2,40720,40738,13,3134,1,0,'2022-09-05',740.00,1,1.00,'Tique Factura B N°: 0013-00020854',NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(589,7968,2,40720,40738,13,3134,1,0,'2022-09-06',1350.00,1,1.00,'Tique Factura B N°: 0013-00020855',NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(590,7968,2,40720,40738,13,3134,1,0,'2022-09-06',1380.00,1,1.00,'Tique Factura B N°: 0013-00020857',NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(591,7968,2,40720,40738,13,3134,1,0,'2022-09-06',1100.00,1,1.00,'Tique Factura B N°: 0013-00020859',NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(592,7968,2,40720,40738,13,3134,1,0,'2022-09-06',1600.00,1,1.00,'Tique Factura B N°: 0013-00020860',NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(593,7968,2,40720,40738,13,3134,1,0,'2022-09-06',1100.00,1,1.00,'Tique Factura B N°: 0013-00020861',NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(594,7968,2,40720,40738,13,3134,1,0,'2022-09-06',980.00,1,1.00,'Tique Factura B N°: 0013-00020863',NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(595,7968,2,40720,40738,13,3134,1,0,'2022-09-06',1280.00,1,1.00,'Tique Factura B N°: 0013-00020864',NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(596,7968,2,40720,40738,13,3134,1,0,'2022-09-06',1340.00,1,1.00,'Tique Factura B N°: 0013-00020865',NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(597,7968,2,40720,40738,13,3134,1,0,'2022-09-06',1490.00,1,1.00,'Tique Factura B N°: 0013-00020866',NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL);
INSERT INTO `cta_cte_cliente` VALUES (598,7968,2,40720,40738,13,3134,1,0,'2022-09-06',920.00,1,1.00,'Tique Factura B N°: 0013-00020867',NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(599,7968,2,40720,40738,13,3134,1,0,'2022-09-06',2100.00,1,1.00,'Tique Factura B N°: 0013-00020868',NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(600,7968,2,40720,40738,13,3134,1,0,'2022-09-07',570.00,1,1.00,'Tique Factura B N°: 0013-00020870',NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(601,7968,2,40720,40738,13,3134,1,0,'2022-09-07',1970.00,1,1.00,'Tique Factura B N°: 0013-00020871',NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(602,7968,2,40720,40738,13,3134,1,0,'2022-09-07',680.00,1,1.00,'Tique Factura B N°: 0013-00020872',NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(603,7968,2,40720,40738,13,3134,1,0,'2022-09-07',1900.00,1,1.00,'Tique Factura B N°: 0013-00020873',NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(604,7968,2,40720,40738,13,3134,1,0,'2022-09-07',740.00,1,1.00,'Tique Factura B N°: 0013-00020874',NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(605,7968,2,40720,40738,13,3134,1,0,'2022-09-07',1690.00,1,1.00,'Tique Factura B N°: 0013-00020875',NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(606,7968,2,40720,40738,13,3134,1,0,'2022-09-07',970.00,1,1.00,'Tique Factura B N°: 0013-00020876',NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(607,7968,2,40720,40738,13,3134,1,0,'2022-09-07',2960.00,1,1.00,'Tique Factura B N°: 0013-00020877',NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(608,7968,2,40720,40738,13,3134,1,0,'2022-09-07',540.00,1,1.00,'Tique Factura B N°: 0013-00020878',NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(609,7968,2,40720,40738,13,3134,1,0,'2022-09-07',700.00,1,1.00,'Tique Factura B N°: 0013-00020879',NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(610,7968,2,40720,40738,13,3134,1,0,'2022-09-08',1190.00,1,1.00,'Tique Factura B N°: 0013-00020880',NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(611,7968,2,40720,40738,13,3134,1,0,'2022-09-08',3050.00,1,1.00,'Tique Factura B N°: 0013-00020881',NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(612,7968,2,40720,40738,13,3134,1,0,'2022-09-08',2860.00,1,1.00,'Tique Factura B N°: 0013-00020882',NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(613,7968,2,40720,40738,13,3134,1,0,'2022-09-08',2500.00,1,1.00,'Tique Factura B N°: 0013-00020884',NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(614,7968,2,40720,40738,13,3134,1,0,'2022-09-08',980.00,1,1.00,'Tique Factura B N°: 0013-00020886',NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(615,7968,2,40720,40738,13,3134,1,0,'2022-09-08',1840.00,1,1.00,'Tique Factura B N°: 0013-00020888',NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(616,7968,2,40720,40738,13,3134,1,0,'2022-09-08',900.00,1,1.00,'Tique Factura B N°: 0013-00020890',NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(617,7968,2,40720,40738,13,3134,1,0,'2022-09-08',560.00,1,1.00,'Tique Factura B N°: 0013-00020891',NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(618,7968,2,40720,40738,13,3134,1,0,'2022-09-08',1300.00,1,1.00,'Tique Factura B N°: 0013-00020892',NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(619,7968,2,40720,40738,13,3134,1,0,'2022-09-09',650.00,1,1.00,'Tique Factura B N°: 0013-00020893',NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(620,7968,2,40720,40738,13,3134,1,0,'2022-09-09',1580.00,1,1.00,'Tique Factura B N°: 0013-00020894',NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(621,7968,2,40720,40738,13,3134,1,0,'2022-09-09',980.00,1,1.00,'Tique Factura B N°: 0013-00020895',NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(622,7968,2,40720,40738,13,3134,1,0,'2022-09-09',1170.00,1,1.00,'Tique Factura B N°: 0013-00020896',NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL);
INSERT INTO `cta_cte_cliente` VALUES (623,7968,2,40720,40738,13,3134,1,0,'2022-09-09',790.00,1,1.00,'Tique Factura B N°: 0013-00020897',NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(624,7968,2,40720,40738,13,3134,1,0,'2022-09-09',1350.00,1,1.00,'Tique Factura B N°: 0013-00020900',NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(625,7968,2,40720,40738,13,3134,1,0,'2022-09-09',1100.00,1,1.00,'Tique Factura B N°: 0013-00020902',NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(626,7968,2,40720,40738,13,3134,1,0,'2022-09-09',2900.00,1,1.00,'Tique Factura B N°: 0013-00020904',NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(627,7968,2,40720,40738,13,3134,1,0,'2022-09-09',350.00,1,1.00,'Tique Factura B N°: 0013-00020906',NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(628,7968,2,40720,40738,13,3134,1,0,'2022-09-09',350.00,1,1.00,'Tique Factura B N°: 0013-00020907',NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(629,7968,2,40720,40738,13,3134,1,0,'2022-09-09',3330.00,1,1.00,'Tique Factura B N°: 0013-00020908',NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(630,7968,2,40720,40738,13,3134,1,0,'2022-09-09',1090.00,1,1.00,'Tique Factura B N°: 0013-00020909',NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(631,7968,2,40720,40738,13,3134,1,0,'2022-09-10',1960.00,1,1.00,'Tique Factura B N°: 0013-00020912',NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(632,7968,2,40720,40738,13,3134,1,0,'2022-09-10',1930.00,1,1.00,'Tique Factura B N°: 0013-00020913',NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(633,7968,2,40720,40738,13,3134,1,0,'2022-09-10',3250.00,1,1.00,'Tique Factura B N°: 0013-00020914',NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(634,7968,2,40720,40738,13,3134,1,0,'2022-09-10',1620.00,1,1.00,'Tique Factura B N°: 0013-00020915',NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(635,7968,2,40720,40738,13,3134,1,0,'2022-09-10',3510.00,1,1.00,'Tique Factura B N°: 0013-00020916',NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(636,7968,2,40720,40738,13,3134,1,0,'2022-09-10',3530.00,1,1.00,'Tique Factura B N°: 0013-00020917',NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(637,7968,2,40720,40738,13,3134,1,0,'2022-09-10',3550.00,1,1.00,'Tique Factura B N°: 0013-00020919',NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(638,7968,2,40720,40738,13,3134,1,0,'2022-09-10',1870.00,1,1.00,'Tique Factura B N°: 0013-00020920',NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(639,7968,2,40720,40738,13,3134,1,0,'2022-09-10',460.00,1,1.00,'Tique Factura B N°: 0013-00020921',NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(640,7968,2,40720,40738,13,3134,1,0,'2022-09-10',790.00,1,1.00,'Tique Factura B N°: 0013-00020922',NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(641,7968,2,40720,40738,13,3134,1,0,'2022-09-12',360.00,1,1.00,'Tique Factura B N°: 0013-00020923',NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(642,7968,2,40720,40738,13,3134,1,0,'2022-09-12',310.00,1,1.00,'Tique Factura B N°: 0013-00020925',NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(643,7968,2,40720,40738,13,3134,1,0,'2022-09-12',1440.00,1,1.00,'Tique Factura B N°: 0013-00020926',NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(644,7968,2,40720,40738,13,3134,1,0,'2022-09-12',1940.00,1,1.00,'Tique Factura B N°: 0013-00020927',NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(645,7968,2,40720,40738,13,3134,1,0,'2022-09-12',1440.00,1,1.00,'Tique Factura B N°: 0013-00020928',NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(646,7968,2,40720,40738,13,3134,1,0,'2022-09-12',1430.00,1,1.00,'Tique Factura B N°: 0013-00020929',NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(647,7968,2,40720,40738,13,3134,1,0,'2022-09-12',1370.00,1,1.00,'Tique Factura B N°: 0013-00020931',NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL);
INSERT INTO `cta_cte_cliente` VALUES (648,7968,2,40720,40738,13,3134,1,0,'2022-09-12',2870.00,1,1.00,'Tique Factura B N°: 0013-00020933',NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(649,7968,2,40720,40738,13,3134,1,0,'2022-09-12',2000.00,1,1.00,'Tique Factura B N°: 0013-00020934',NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(650,7968,2,40720,40738,13,3134,1,0,'2022-09-12',1080.00,1,1.00,'Tique Factura B N°: 0013-00020936',NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(651,7968,2,40720,40738,13,3134,1,0,'2022-09-13',940.00,1,1.00,'Tique Factura B N°: 0013-00020938',NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(652,7968,2,40720,40738,13,3134,1,0,'2022-09-13',620.00,1,1.00,'Tique Factura B N°: 0013-00020940',NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(653,7968,2,40720,40738,13,3134,1,0,'2022-09-13',1960.00,1,1.00,'Tique Factura B N°: 0013-00020941',NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(654,7968,2,40720,40738,13,3134,1,0,'2022-09-13',1100.00,1,1.00,'Tique Factura B N°: 0013-00020942',NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(655,7968,2,40720,40738,13,3134,1,0,'2022-09-13',2030.00,1,1.00,'Tique Factura B N°: 0013-00020943',NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(656,7968,2,40720,40738,13,3134,1,0,'2022-09-13',790.00,1,1.00,'Tique Factura B N°: 0013-00020944',NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(657,7968,2,40720,40738,13,3134,1,0,'2022-09-13',810.00,1,1.00,'Tique Factura B N°: 0013-00020946',NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(658,7968,2,40720,40738,13,3134,1,0,'2022-09-13',2570.00,1,1.00,'Tique Factura B N°: 0013-00020947',NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(659,7968,2,40720,40738,13,3134,1,0,'2022-09-14',420.00,1,1.00,'Tique Factura B N°: 0013-00020949',NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(660,7968,2,40720,40738,13,3134,1,0,'2022-09-14',1490.00,1,1.00,'Tique Factura B N°: 0013-00020951',NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(661,7968,2,40720,40738,13,3134,1,0,'2022-09-14',980.00,1,1.00,'Tique Factura B N°: 0013-00020952',NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(662,7968,2,40720,40738,13,3134,1,0,'2022-09-14',3430.00,1,1.00,'Tique Factura B N°: 0013-00020953',NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(663,7968,2,40720,40738,13,3134,1,0,'2022-09-14',1580.00,1,1.00,'Tique Factura B N°: 0013-00020954',NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(664,7968,2,40720,40738,13,3134,1,0,'2022-09-14',1200.00,1,1.00,'Tique Factura B N°: 0013-00020955',NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(665,7968,2,40720,40738,13,3134,1,0,'2022-09-14',1050.00,1,1.00,'Tique Factura B N°: 0013-00020957',NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(666,7968,2,40720,40738,13,3134,1,0,'2022-09-14',2570.00,1,1.00,'Tique Factura B N°: 0013-00020959',NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(667,7968,2,40720,40738,13,3134,1,0,'2022-09-14',400.00,1,1.00,'Tique Factura B N°: 0013-00020961',NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(668,7968,2,40720,40738,13,3134,1,0,'2022-09-14',1280.00,1,1.00,'Tique Factura B N°: 0013-00020964',NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(669,7968,2,40720,40738,13,3134,1,0,'2022-09-14',820.00,1,1.00,'Tique Factura B N°: 0013-00020965',NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(670,7968,2,40720,40738,13,3134,1,0,'2022-09-14',2400.00,1,1.00,'Tique Factura B N°: 0013-00020966',NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(671,7968,2,40720,40738,13,3134,1,0,'2022-09-14',890.00,1,1.00,'Tique Factura B N°: 0013-00020969',NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(672,7968,2,40720,40738,13,3134,1,0,'2022-09-14',650.00,1,1.00,'Tique Factura B N°: 0013-00020970',NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL);
INSERT INTO `cta_cte_cliente` VALUES (673,7968,2,40720,40738,13,3134,1,0,'2022-09-14',470.00,1,1.00,'Tique Factura B N°: 0013-00020971',NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(674,7968,2,40720,40738,13,3134,1,0,'2022-09-14',560.00,1,1.00,'Tique Factura B N°: 0013-00020972',NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(675,7968,2,40720,40738,13,3134,1,0,'2022-09-16',1220.00,1,1.00,'Tique Factura B N°: 0013-00020973',NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(676,7968,2,40720,40738,13,3134,1,0,'2022-09-16',980.00,1,1.00,'Tique Factura B N°: 0013-00020974',NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(677,7968,2,40720,40738,13,3134,1,0,'2022-09-16',980.00,1,1.00,'Tique Factura B N°: 0013-00020975',NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(678,7968,2,40720,40738,13,3134,1,0,'2022-09-16',1310.00,1,1.00,'Tique Factura B N°: 0013-00020976',NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(679,7968,2,40720,40738,13,3134,1,0,'2022-09-16',1940.00,1,1.00,'Tique Factura B N°: 0013-00020977',NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(680,7968,2,40720,40738,13,3134,1,0,'2022-09-16',1960.00,1,1.00,'Tique Factura B N°: 0013-00020978',NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(681,7968,2,40720,40738,13,3134,1,0,'2022-09-16',1430.00,1,1.00,'Tique Factura B N°: 0013-00020979',NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(682,7968,2,40720,40738,13,3134,1,0,'2022-09-16',1960.00,1,1.00,'Tique Factura B N°: 0013-00020980',NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(683,7968,2,40720,40738,13,3134,1,0,'2022-09-16',2940.00,1,1.00,'Tique Factura B N°: 0013-00020981',NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(684,7968,2,40720,40738,13,3134,1,0,'2022-09-16',1090.00,1,1.00,'Tique Factura B N°: 0013-00020982',NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(685,7968,2,40720,40738,13,3134,1,0,'2022-09-16',1440.00,1,1.00,'Tique Factura B N°: 0013-00020983',NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(686,7968,2,40720,40738,13,3134,1,0,'2022-09-16',2110.00,1,1.00,'Tique Factura B N°: 0013-00020984',NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(687,7968,2,40720,40738,13,3134,1,0,'2022-09-17',1020.00,1,1.00,'Tique Factura B N°: 0013-00020985',NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(688,7968,2,40720,40738,13,3134,1,0,'2022-09-17',2550.00,1,1.00,'Tique Factura B N°: 0013-00020986',NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(689,7968,2,40720,40738,13,3134,1,0,'2022-09-17',2480.00,1,1.00,'Tique Factura B N°: 0013-00020987',NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(690,7968,2,40720,40738,13,3134,1,0,'2022-09-17',980.00,1,1.00,'Tique Factura B N°: 0013-00020988',NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(691,7968,2,40720,40738,13,3134,1,0,'2022-09-17',1250.00,1,1.00,'Tique Factura B N°: 0013-00020989',NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(692,7968,2,40720,40738,13,3134,1,0,'2022-09-17',3530.00,1,1.00,'Tique Factura B N°: 0013-00020991',NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(693,7968,2,40720,40738,13,3134,1,0,'2022-09-17',1250.00,1,1.00,'Tique Factura B N°: 0013-00020994',NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(694,7968,2,40720,40738,13,3134,1,0,'2022-09-17',1520.00,1,1.00,'Tique Factura B N°: 0013-00020997',NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(695,7968,2,40720,40738,13,3134,1,0,'2022-09-17',1720.00,1,1.00,'Tique Factura B N°: 0013-00020998',NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(696,7968,2,40720,40738,13,3134,1,0,'2022-09-17',9160.00,1,1.00,'Tique Factura B N°: 0013-00021001',NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(697,7968,2,40720,40738,13,3134,1,0,'2022-09-17',1250.00,1,1.00,'Tique Factura B N°: 0013-00021002',NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL);
INSERT INTO `cta_cte_cliente` VALUES (698,7968,2,40720,40738,13,3134,1,0,'2022-09-17',1440.00,1,1.00,'Tique Factura B N°: 0013-00021005',NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(699,7968,2,40720,40738,13,3134,1,0,'2022-09-17',1350.00,1,1.00,'Tique Factura B N°: 0013-00021006',NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(700,7968,2,40720,40738,13,3134,1,0,'2022-09-17',610.00,1,1.00,'Tique Factura B N°: 0013-00021008',NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(701,7968,2,40720,40738,13,3134,1,0,'2022-09-19',1190.00,1,1.00,'Tique Factura B N°: 0013-00021010',NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(702,7968,2,40720,40738,13,3134,1,0,'2022-09-19',1100.00,1,1.00,'Tique Factura B N°: 0013-00021012',NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(703,7968,2,40720,40738,13,3134,1,0,'2022-09-19',2130.00,1,1.00,'Tique Factura B N°: 0013-00021013',NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(704,7968,2,40720,40738,13,3134,1,0,'2022-09-19',980.00,1,1.00,'Tique Factura B N°: 0013-00021014',NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(705,7968,2,40720,40738,13,3134,1,0,'2022-09-19',980.00,1,1.00,'Tique Factura B N°: 0013-00021016',NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(706,7968,2,40720,40738,13,3134,1,0,'2022-09-19',880.00,1,1.00,'Tique Factura B N°: 0013-00021018',NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(707,7968,2,40720,40738,13,3134,1,0,'2022-09-19',1060.00,1,1.00,'Tique Factura B N°: 0013-00021021',NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(708,7968,2,40720,40738,13,3134,1,0,'2022-09-19',820.00,1,1.00,'Tique Factura B N°: 0013-00021024',NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(709,7968,2,40720,40738,13,3134,1,0,'2022-09-19',1300.00,1,1.00,'Tique Factura B N°: 0013-00021025',NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(710,7968,2,40720,40738,13,3134,1,0,'2022-09-19',460.00,1,1.00,'Tique Factura B N°: 0013-00021026',NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(711,7968,2,40720,40738,13,3134,1,0,'2022-09-19',800.00,1,1.00,'Tique Factura B N°: 0013-00021027',NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(712,7968,2,40720,40738,13,3134,1,0,'2022-09-20',2990.00,1,1.00,'Tique Factura B N°: 0013-00021028',NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(713,7968,2,40720,40738,13,3134,1,0,'2022-09-20',560.00,1,1.00,'Tique Factura B N°: 0013-00021029',NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(714,7968,2,40720,40738,13,3134,1,0,'2022-09-20',1580.00,1,1.00,'Tique Factura B N°: 0013-00021031',NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(715,7968,2,40720,40738,13,3134,1,0,'2022-09-20',980.00,1,1.00,'Tique Factura B N°: 0013-00021032',NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(716,7968,2,40720,40738,13,3134,1,0,'2022-09-20',1440.00,1,1.00,'Tique Factura B N°: 0013-00021033',NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(717,7968,2,40720,40738,13,3134,1,0,'2022-09-20',510.00,1,1.00,'Tique Factura B N°: 0013-00021035',NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(718,7968,2,40720,40738,13,3134,1,0,'2022-09-20',720.00,1,1.00,'Tique Factura B N°: 0013-00021036',NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(719,7968,2,40720,40738,13,3134,1,0,'2022-09-20',600.00,1,1.00,'Tique Factura B N°: 0013-00021037',NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(720,7968,2,40720,40738,13,3134,1,0,'2022-09-20',720.00,1,1.00,'Tique Factura B N°: 0013-00021039',NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(721,7968,2,40720,40738,13,3134,1,0,'2022-09-20',560.00,1,1.00,'Tique Factura B N°: 0013-00021041',NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(722,7968,2,40720,40738,13,3134,1,0,'2022-09-21',1340.00,1,1.00,'Tique Factura B N°: 0013-00021045',NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL);
INSERT INTO `cta_cte_cliente` VALUES (723,7968,2,40720,40738,13,3134,1,0,'2022-09-21',980.00,1,1.00,'Tique Factura B N°: 0013-00021047',NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(724,7968,2,40720,40738,13,3134,1,0,'2022-09-21',2990.00,1,1.00,'Tique Factura B N°: 0013-00021049',NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(725,7968,2,40720,40738,13,3134,1,0,'2022-09-21',560.00,1,1.00,'Tique Factura B N°: 0013-00021052',NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(726,7968,2,40720,40738,13,3134,1,0,'2022-09-21',360.00,1,1.00,'Tique Factura B N°: 0013-00021054',NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(727,7968,2,40720,40738,13,3134,1,0,'2022-09-21',1000.00,1,1.00,'Tique Factura B N°: 0013-00021055',NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(728,7968,2,40720,40738,13,3134,1,0,'2022-09-21',1620.00,1,1.00,'Tique Factura B N°: 0013-00021064',NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(729,7968,2,40720,40738,13,3134,1,0,'2022-09-22',610.00,1,1.00,'Tique Factura B N°: 0013-00021066',NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(730,7968,2,40720,40738,13,3134,1,0,'2022-09-22',1990.00,1,1.00,'Tique Factura B N°: 0013-00021068',NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(731,7968,2,40720,40738,13,3134,1,0,'2022-09-22',1580.00,1,1.00,'Tique Factura B N°: 0013-00021069',NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(732,7968,2,40720,40738,13,3134,1,0,'2022-09-22',980.00,1,1.00,'Tique Factura B N°: 0013-00021070',NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(733,7968,2,40720,40738,13,3134,1,0,'2022-09-22',950.00,1,1.00,'Tique Factura B N°: 0013-00021071',NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(734,7968,2,40720,40738,13,3134,1,0,'2022-09-22',3200.00,1,1.00,'Tique Factura B N°: 0013-00021073',NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(735,7968,2,40720,40738,13,3134,1,0,'2022-09-22',1440.00,1,1.00,'Tique Factura B N°: 0013-00021074',NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(736,7968,2,40720,40738,13,3134,1,0,'2022-09-22',720.00,1,1.00,'Tique Factura B N°: 0013-00021075',NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(737,7968,2,40720,40738,13,3134,1,0,'2022-09-22',280.00,1,1.00,'Tique Factura B N°: 0013-00021077',NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(738,7968,2,40720,40738,13,3134,1,0,'2022-09-22',560.00,1,1.00,'Tique Factura B N°: 0013-00021078',NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(739,7968,2,40720,40738,13,3134,1,0,'2022-09-22',1710.00,1,1.00,'Tique Factura B N°: 0013-00021079',NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(740,7968,2,40720,40738,13,3134,1,0,'2022-09-23',490.00,1,1.00,'Tique Factura B N°: 0013-00021081',NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(741,7968,2,40720,40738,13,3134,1,0,'2022-09-23',1960.00,1,1.00,'Tique Factura B N°: 0013-00021082',NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(742,7968,2,40720,40738,13,3134,1,0,'2022-09-23',1050.00,1,1.00,'Tique Factura B N°: 0013-00021083',NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(743,7968,2,40720,40738,13,3134,1,0,'2022-09-23',1200.00,1,1.00,'Tique Factura B N°: 0013-00021084',NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(744,7968,2,40720,40738,13,3134,1,0,'2022-09-23',980.00,1,1.00,'Tique Factura B N°: 0013-00021086',NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(745,7968,2,40720,40738,13,3134,1,0,'2022-09-23',1940.00,1,1.00,'Tique Factura B N°: 0013-00021087',NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(746,7968,2,40720,40738,13,3134,1,0,'2022-09-23',2080.00,1,1.00,'Tique Factura B N°: 0013-00021089',NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(747,7968,2,40720,40738,13,3134,1,0,'2022-09-23',980.00,1,1.00,'Tique Factura B N°: 0013-00021090',NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL);
INSERT INTO `cta_cte_cliente` VALUES (748,7968,2,40720,40738,13,3134,1,0,'2022-09-24',510.00,1,1.00,'Tique Factura B N°: 0013-00021093',NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(749,7968,2,40720,40738,13,3134,1,0,'2022-09-24',1860.00,1,1.00,'Tique Factura B N°: 0013-00021094',NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(750,7968,2,40720,40738,13,3134,1,0,'2022-09-24',1350.00,1,1.00,'Tique Factura B N°: 0013-00021095',NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(751,7968,2,40720,40738,13,3134,1,0,'2022-09-24',3470.00,1,1.00,'Tique Factura B N°: 0013-00021096',NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(752,7968,2,40720,40738,13,3134,1,0,'2022-09-24',5890.00,1,1.00,'Tique Factura B N°: 0013-00021098',NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(753,7968,2,40720,40738,13,3134,1,0,'2022-09-24',2320.00,1,1.00,'Tique Factura B N°: 0013-00021099',NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(754,7968,2,40720,40738,13,3134,1,0,'2022-09-24',2300.00,1,1.00,'Tique Factura B N°: 0013-00021100',NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(755,7968,2,40720,40738,13,3134,1,0,'2022-09-24',2240.00,1,1.00,'Tique Factura B N°: 0013-00021101',NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(756,7968,2,40720,40738,13,3134,1,0,'2022-09-24',1040.00,1,1.00,'Tique Factura B N°: 0013-00021102',NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(757,7968,2,40720,40738,13,3134,1,0,'2022-09-24',1350.00,1,1.00,'Tique Factura B N°: 0013-00021103',NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(758,7968,2,40720,40738,13,3134,1,0,'2022-09-26',730.00,1,1.00,'Tique Factura B N°: 0013-00021104',NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(759,7968,2,40720,40738,13,3134,1,0,'2022-09-26',490.00,1,1.00,'Tique Factura B N°: 0013-00021105',NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(760,7968,2,40720,40738,13,3134,1,0,'2022-09-26',970.00,1,1.00,'Tique Factura B N°: 0013-00021106',NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(761,7968,2,40720,40738,13,3134,1,0,'2022-09-26',2740.00,1,1.00,'Tique Factura B N°: 0013-00021108',NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(762,7968,2,40720,40738,13,3134,1,0,'2022-09-26',1460.00,1,1.00,'Tique Factura B N°: 0013-00021109',NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(763,7968,2,40720,40738,13,3134,1,0,'2022-09-26',980.00,1,1.00,'Tique Factura B N°: 0013-00021110',NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(764,7968,2,40720,40738,13,3134,1,0,'2022-09-26',1100.00,1,1.00,'Tique Factura B N°: 0013-00021111',NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(765,7968,2,40720,40738,13,3134,1,0,'2022-09-26',180.00,1,1.00,'Tique Factura B N°: 0013-00021112',NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(766,7968,2,40720,40738,13,3134,1,0,'2022-09-26',730.00,1,1.00,'Tique Factura B N°: 0013-00021113',NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(767,7968,2,40720,40738,13,3134,1,0,'2022-09-26',1650.00,1,1.00,'Tique Factura B N°: 0013-00021114',NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(768,7968,2,40720,40738,13,3134,1,0,'2022-09-26',1540.00,1,1.00,'Tique Factura B N°: 0013-00021115',NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(769,7968,2,40720,40738,13,3134,1,0,'2022-09-27',1860.00,1,1.00,'Tique Factura B N°: 0013-00021116',NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(770,7968,2,40720,40738,13,3134,1,0,'2022-09-27',1050.00,1,1.00,'Tique Factura B N°: 0013-00021117',NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(771,7968,2,40720,40738,13,3134,1,0,'2022-09-27',1580.00,1,1.00,'Tique Factura B N°: 0013-00021118',NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(772,7968,2,40720,40738,13,3134,1,0,'2022-09-27',750.00,1,1.00,'Tique Factura B N°: 0013-00021119',NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL);
INSERT INTO `cta_cte_cliente` VALUES (773,7968,2,40720,40738,13,3134,1,0,'2022-09-27',1100.00,1,1.00,'Tique Factura B N°: 0013-00021120',NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(774,7968,2,40720,40738,13,3134,1,0,'2022-09-27',1020.00,1,1.00,'Tique Factura B N°: 0013-00021121',NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(775,7968,2,40720,40738,13,3134,1,0,'2022-09-27',310.00,1,1.00,'Tique Factura B N°: 0013-00021122',NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(776,7968,2,40720,40738,13,3134,1,0,'2022-09-27',280.00,1,1.00,'Tique Factura B N°: 0013-00021123',NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(777,7968,2,40720,40738,13,3134,1,0,'2022-09-27',440.00,1,1.00,'Tique Factura B N°: 0013-00021124',NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(778,7968,2,40720,40738,13,3134,1,0,'2022-09-27',1300.00,1,1.00,'Tique Factura B N°: 0013-00021125',NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(779,7968,2,40720,40738,13,3134,1,0,'2022-09-28',260.00,1,1.00,'Tique Factura B N°: 0013-00021126',NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(780,7968,2,40720,40738,13,3134,1,0,'2022-09-28',1310.00,1,1.00,'Tique Factura B N°: 0013-00021127',NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(781,7968,2,40720,40738,13,3134,1,0,'2022-09-28',1580.00,1,1.00,'Tique Factura B N°: 0013-00021128',NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(782,7968,2,40720,40738,13,3134,1,0,'2022-09-28',2670.00,1,1.00,'Tique Factura B N°: 0013-00021129',NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(783,7968,2,40720,40738,13,3134,1,0,'2022-09-28',2200.00,1,1.00,'Tique Factura B N°: 0013-00021130',NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(784,7968,2,40720,40738,13,3134,1,0,'2022-09-28',1100.00,1,1.00,'Tique Factura B N°: 0013-00021131',NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(785,7968,2,40720,40738,13,3134,1,0,'2022-09-28',1190.00,1,1.00,'Tique Factura B N°: 0013-00021134',NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(786,7968,2,40720,40738,13,3134,1,0,'2022-09-28',1350.00,1,1.00,'Tique Factura B N°: 0013-00021135',NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(787,7968,2,40720,40738,13,3134,1,0,'2022-09-28',650.00,1,1.00,'Tique Factura B N°: 0013-00021136',NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(788,7968,2,40720,40738,13,3134,1,0,'2022-09-28',2910.00,1,1.00,'Tique Factura B N°: 0013-00021137',NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(789,7968,2,40720,40738,13,3134,1,0,'2022-09-29',1650.00,1,1.00,'Tique Factura B N°: 0013-00021138',NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(790,7968,2,40720,40738,13,3134,1,0,'2022-09-29',2280.00,1,1.00,'Tique Factura B N°: 0013-00021139',NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(791,7968,2,40720,40738,13,3134,1,0,'2022-09-29',2200.00,1,1.00,'Tique Factura B N°: 0013-00021140',NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(792,7968,2,40720,40738,13,3134,1,0,'2022-09-29',1230.00,1,1.00,'Tique Factura B N°: 0013-00021144',NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(793,7968,2,40720,40738,13,3134,1,0,'2022-09-29',1660.00,1,1.00,'Tique Factura B N°: 0013-00021145',NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(794,7968,2,40720,40738,13,3134,1,0,'2022-09-29',2200.00,1,1.00,'Tique Factura B N°: 0013-00021146',NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(795,7968,2,40720,40738,13,3134,1,0,'2022-09-29',930.00,1,1.00,'Tique Factura B N°: 0013-00021147',NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(796,7968,2,40720,40738,13,3134,1,0,'2022-09-29',1100.00,1,1.00,'Tique Factura B N°: 0013-00021148',NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(797,7968,2,40720,40738,13,3134,1,0,'2022-09-29',2570.00,1,1.00,'Tique Factura B N°: 0013-00021149',NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL);
INSERT INTO `cta_cte_cliente` VALUES (798,7968,2,40720,40738,13,3134,1,0,'2022-09-29',1100.00,1,1.00,'Tique Factura B N°: 0013-00021151',NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(799,7968,2,40720,40738,13,3134,1,0,'2022-09-29',4740.00,1,1.00,'Tique Factura B N°: 0013-00021153',NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(800,7968,2,40720,40738,13,3134,1,0,'2022-09-29',1190.00,1,1.00,'Tique Factura B N°: 0013-00021154',NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(801,7968,2,40720,40738,13,3134,1,0,'2022-09-29',600.00,1,1.00,'Tique Factura B N°: 0013-00021156',NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(802,7968,2,40720,40738,13,3134,1,0,'2022-09-29',1650.00,1,1.00,'Tique Factura B N°: 0013-00021157',NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(803,7968,2,40720,40738,13,3134,1,0,'2022-09-29',2030.00,1,1.00,'Tique Factura B N°: 0013-00021158',NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(804,7968,2,40720,40738,13,3134,1,0,'2022-09-30',1950.00,1,1.00,'Tique Factura B N°: 0013-00021159',NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(805,7968,2,40720,40738,13,3134,1,0,'2022-09-30',2090.00,1,1.00,'Tique Factura B N°: 0013-00021161',NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(806,7968,2,40720,40738,13,3134,1,0,'2022-09-30',2200.00,1,1.00,'Tique Factura B N°: 0013-00021162',NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(807,7968,2,40720,40738,13,3134,1,0,'2022-09-30',3120.00,1,1.00,'Tique Factura B N°: 0013-00021163',NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(808,7968,2,40720,40738,13,3134,1,0,'2022-09-30',2790.00,1,1.00,'Tique Factura B N°: 0013-00021164',NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(809,7968,2,40720,40738,13,3134,1,0,'2022-09-30',2580.00,1,1.00,'Tique Factura B N°: 0013-00021165',NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(810,7968,2,40720,40738,13,3134,1,0,'2022-09-30',330.00,1,1.00,'Tique Factura B N°: 0013-00021166',NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(811,7968,2,40720,40738,13,3134,1,0,'2022-09-30',1060.00,1,1.00,'Tique Factura B N°: 0013-00021167',NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(812,7968,2,40720,40738,13,3134,1,0,'2022-09-30',1520.00,1,1.00,'Tique Factura B N°: 0013-00021170',NULL,'2022-11-23 11:33:46','2022-11-23 11:33:46',NULL),(813,7968,2,40720,40738,13,3133,1,0,'2022-08-01',1050.00,1,1.00,'Tique Factura B N°: 0013-00020465',NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(814,7968,2,40720,40738,13,3133,1,0,'2022-08-01',1580.00,1,1.00,'Tique Factura B N°: 0013-00020466',NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(815,7968,2,40720,40738,13,3133,1,0,'2022-08-01',1580.00,1,1.00,'Tique Factura B N°: 0013-00020467',NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(816,7968,2,40720,40738,13,3133,1,0,'2022-08-01',3210.00,1,1.00,'Tique Factura B N°: 0013-00020468',NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(817,7968,2,40720,40738,13,3133,1,0,'2022-08-01',1290.00,1,1.00,'Tique Factura B N°: 0013-00020469',NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(818,7968,2,40720,40738,13,3133,1,0,'2022-08-01',2350.00,1,1.00,'Tique Factura B N°: 0013-00020470',NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(819,7968,2,40720,40738,13,3133,1,0,'2022-08-01',940.00,1,1.00,'Tique Factura B N°: 0013-00020471',NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(820,7968,2,40720,40738,13,3133,1,0,'2022-08-01',2060.00,1,1.00,'Tique Factura B N°: 0013-00020472',NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(821,7968,2,40720,40738,13,3133,1,0,'2022-08-01',320.00,1,1.00,'Tique Factura B N°: 0013-00020473',NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(822,7968,2,40720,40738,13,3133,1,0,'2022-08-01',1080.00,1,1.00,'Tique Factura B N°: 0013-00020474',NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL);
INSERT INTO `cta_cte_cliente` VALUES (823,7968,2,40720,40738,13,3133,1,0,'2022-08-01',1350.00,1,1.00,'Tique Factura B N°: 0013-00020475',NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(824,7968,2,40720,40738,13,3133,1,0,'2022-08-02',1990.00,1,1.00,'Tique Factura B N°: 0013-00020476',NULL,'2022-11-23 11:35:40','2022-11-23 11:35:40',NULL),(825,7968,2,40720,40738,13,3133,1,0,'2022-08-02',1100.00,1,1.00,'Tique Factura B N°: 0013-00020477',NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(826,7968,2,40720,40738,13,3133,1,0,'2022-08-02',2670.00,1,1.00,'Tique Factura B N°: 0013-00020478',NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(827,7968,2,40720,40738,13,3133,1,0,'2022-08-02',3750.00,1,1.00,'Tique Factura B N°: 0013-00020479',NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(828,7968,2,40720,40738,13,3133,1,0,'2022-08-02',2510.00,1,1.00,'Tique Factura B N°: 0013-00020480',NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(829,7968,2,40720,40738,13,3133,1,0,'2022-08-02',1300.00,1,1.00,'Tique Factura B N°: 0013-00020482',NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(830,7968,2,40720,40738,13,3133,1,0,'2022-08-02',1840.00,1,1.00,'Tique Factura B N°: 0013-00020483',NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(831,7968,2,40720,40738,13,3133,1,0,'2022-08-02',1680.00,1,1.00,'Tique Factura B N°: 0013-00020484',NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(832,7968,2,40720,40738,13,3133,1,0,'2022-08-02',3530.00,1,1.00,'Tique Factura B N°: 0013-00020485',NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(833,7968,2,40720,40738,13,3133,1,0,'2022-08-02',1630.00,1,1.00,'Tique Factura B N°: 0013-00020487',NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(834,7968,2,40720,40738,13,3133,1,0,'2022-08-03',1050.00,1,1.00,'Tique Factura B N°: 0013-00020488',NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(835,7968,2,40720,40738,13,3133,1,0,'2022-08-03',570.00,1,1.00,'Tique Factura B N°: 0013-00020489',NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(836,7968,2,40720,40738,13,3133,1,0,'2022-08-03',1580.00,1,1.00,'Tique Factura B N°: 0013-00020490',NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(837,7968,2,40720,40738,13,3133,1,0,'2022-08-03',790.00,1,1.00,'Tique Factura B N°: 0013-00020491',NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(838,7968,2,40720,40738,13,3133,1,0,'2022-08-03',1260.00,1,1.00,'Tique Factura B N°: 0013-00020493',NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(839,7968,2,40720,40738,13,3133,1,0,'2022-08-03',460.00,1,1.00,'Tique Factura B N°: 0013-00020494',NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(840,7968,2,40720,40738,13,3133,1,0,'2022-08-03',2200.00,1,1.00,'Tique Factura B N°: 0013-00020495',NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(841,7968,2,40720,40738,13,3133,1,0,'2022-08-03',720.00,1,1.00,'Tique Factura B N°: 0013-00020496',NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(842,7968,2,40720,40738,13,3133,1,0,'2022-08-03',780.00,1,1.00,'Tique Factura B N°: 0013-00020497',NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(843,7968,2,40720,40738,13,3133,1,0,'2022-08-03',940.00,1,1.00,'Tique Factura B N°: 0013-00020498',NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(844,7968,2,40720,40738,13,3133,1,0,'2022-08-03',1070.00,1,1.00,'Tique Factura B N°: 0013-00020499',NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(845,7968,2,40720,40738,13,3133,1,0,'2022-08-03',770.00,1,1.00,'Tique Factura B N°: 0013-00020500',NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(846,7968,2,40720,40738,13,3133,1,0,'2022-08-03',260.00,1,1.00,'Tique Factura B N°: 0013-00020501',NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(847,7968,2,40720,40738,13,3133,1,0,'2022-08-04',540.00,1,1.00,'Tique Factura B N°: 0013-00020502',NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL);
INSERT INTO `cta_cte_cliente` VALUES (848,7968,2,40720,40738,13,3133,1,0,'2022-08-04',560.00,1,1.00,'Tique Factura B N°: 0013-00020503',NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(849,7968,2,40720,40738,13,3133,1,0,'2022-08-04',1580.00,1,1.00,'Tique Factura B N°: 0013-00020504',NULL,'2022-11-23 11:35:41','2022-11-23 11:35:41',NULL),(850,7968,2,40720,40738,13,3133,1,0,'2022-08-04',1080.00,1,1.00,'Tique Factura B N°: 0013-00020505',NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(851,7968,2,40720,40738,13,3133,1,0,'2022-08-04',1310.00,1,1.00,'Tique Factura B N°: 0013-00020506',NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(852,7968,2,40720,40738,13,3133,1,0,'2022-08-04',4330.00,1,1.00,'Tique Factura B N°: 0013-00020507',NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(853,7968,2,40720,40738,13,3133,1,0,'2022-08-04',1300.00,1,1.00,'Tique Factura B N°: 0013-00020508',NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(854,7968,2,40720,40738,13,3133,1,0,'2022-08-04',1280.00,1,1.00,'Tique Factura B N°: 0013-00020509',NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(855,7968,2,40720,40738,13,3133,1,0,'2022-08-04',2080.00,1,1.00,'Tique Factura B N°: 0013-00020510',NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(856,7968,2,40720,40738,13,3133,1,0,'2022-08-04',1840.00,1,1.00,'Tique Factura B N°: 0013-00020511',NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(857,7968,2,40720,40738,13,3133,1,0,'2022-08-04',560.00,1,1.00,'Tique Factura B N°: 0013-00020512',NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(858,7968,2,40720,40738,13,3133,1,0,'2022-08-04',1060.00,1,1.00,'Tique Factura B N°: 0013-00020513',NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(859,7968,2,40720,40738,13,3133,1,0,'2022-08-05',510.00,1,1.00,'Tique Factura B N°: 0013-00020514',NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(860,7968,2,40720,40738,13,3133,1,0,'2022-08-05',2400.00,1,1.00,'Tique Factura B N°: 0013-00020515',NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(861,7968,2,40720,40738,13,3133,1,0,'2022-08-05',1580.00,1,1.00,'Tique Factura B N°: 0013-00020516',NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(862,7968,2,40720,40738,13,3133,1,0,'2022-08-05',980.00,1,1.00,'Tique Factura B N°: 0013-00020517',NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(863,7968,2,40720,40738,13,3133,1,0,'2022-08-05',1580.00,1,1.00,'Tique Factura B N°: 0013-00020518',NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(864,7968,2,40720,40738,13,3133,1,0,'2022-08-05',3300.00,1,1.00,'Tique Factura B N°: 0013-00020519',NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(865,7968,2,40720,40738,13,3133,1,0,'2022-08-05',1960.00,1,1.00,'Tique Factura B N°: 0013-00020520',NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(866,7968,2,40720,40738,13,3133,1,0,'2022-08-05',1410.00,1,1.00,'Tique Factura B N°: 0013-00020521',NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(867,7968,2,40720,40738,13,3133,1,0,'2022-08-05',540.00,1,1.00,'Tique Factura B N°: 0013-00020522',NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(868,7968,2,40720,40738,13,3133,1,0,'2022-08-05',720.00,1,1.00,'Tique Factura B N°: 0013-00020523',NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(869,7968,2,40720,40738,13,3133,1,0,'2022-08-05',1490.00,1,1.00,'Tique Factura B N°: 0013-00020524',NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(870,7968,2,40720,40738,13,3133,1,0,'2022-08-05',2130.00,1,1.00,'Tique Factura B N°: 0013-00020525',NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(871,7968,2,40720,40738,13,3133,1,0,'2022-08-05',2130.00,1,1.00,'Tique Factura B N°: 0013-00020526',NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(872,7968,2,40720,40738,13,3133,1,0,'2022-08-06',530.00,1,1.00,'Tique Factura B N°: 0013-00020528',NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL);
INSERT INTO `cta_cte_cliente` VALUES (873,7968,2,40720,40738,13,3133,1,0,'2022-08-06',1740.00,1,1.00,'Tique Factura B N°: 0013-00020530',NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(874,7968,2,40720,40738,13,3133,1,0,'2022-08-06',1350.00,1,1.00,'Tique Factura B N°: 0013-00020531',NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(875,7968,2,40720,40738,13,3133,1,0,'2022-08-06',1960.00,1,1.00,'Tique Factura B N°: 0013-00020532',NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(876,7968,2,40720,40738,13,3133,1,0,'2022-08-06',3380.00,1,1.00,'Tique Factura B N°: 0013-00020533',NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(877,7968,2,40720,40738,13,3133,1,0,'2022-08-06',510.00,1,1.00,'Tique Factura B N°: 0013-00020535',NULL,'2022-11-23 11:35:42','2022-11-23 11:35:42',NULL),(878,7968,2,40720,40738,13,3133,1,0,'2022-08-06',1960.00,1,1.00,'Tique Factura B N°: 0013-00020536',NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(879,7968,2,40720,40738,13,3133,1,0,'2022-08-06',980.00,1,1.00,'Tique Factura B N°: 0013-00020537',NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(880,7968,2,40720,40738,13,3133,1,0,'2022-08-06',1960.00,1,1.00,'Tique Factura B N°: 0013-00020538',NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(881,7968,2,40720,40738,13,3133,1,0,'2022-08-06',3920.00,1,1.00,'Tique Factura B N°: 0013-00020539',NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(882,7968,2,40720,40738,13,3133,1,0,'2022-08-06',5200.00,1,1.00,'Tique Factura B N°: 0013-00020541',NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(883,7968,2,40720,40738,13,3133,1,0,'2022-08-06',3070.00,1,1.00,'Tique Factura B N°: 0013-00020542',NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(884,7968,2,40720,40738,13,3133,1,0,'2022-08-06',1380.00,1,1.00,'Tique Factura B N°: 0013-00020543',NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(885,7968,2,40720,40738,13,3133,1,0,'2022-08-06',1180.00,1,1.00,'Tique Factura B N°: 0013-00020545',NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(886,7968,2,40720,40738,13,3133,1,0,'2022-08-06',980.00,1,1.00,'Tique Factura B N°: 0013-00020546',NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(887,7968,2,40720,40738,13,3133,1,0,'2022-08-06',360.00,1,1.00,'Tique Factura B N°: 0013-00020547',NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(888,7968,2,40720,40738,13,3133,1,0,'2022-08-06',1290.00,1,1.00,'Tique Factura B N°: 0013-00020548',NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(889,7968,2,40720,40738,13,3133,1,0,'2022-08-06',2300.00,1,1.00,'Tique Factura B N°: 0013-00020549',NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(890,7968,2,40720,40738,13,3133,1,0,'2022-08-06',1410.00,1,1.00,'Tique Factura B N°: 0013-00020550',NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(891,7968,2,40720,40738,13,3133,1,0,'2022-08-06',1890.00,1,1.00,'Tique Factura B N°: 0013-00020551',NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(892,7968,2,40720,40738,13,3133,1,0,'2022-08-06',1480.00,1,1.00,'Tique Factura B N°: 0013-00020553',NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(893,7968,2,40720,40738,13,3133,1,0,'2022-08-06',1550.00,1,1.00,'Tique Factura B N°: 0013-00020554',NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(894,7968,2,40720,40738,13,3133,1,0,'2022-08-06',1960.00,1,1.00,'Tique Factura B N°: 0013-00020555',NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(895,7968,2,40720,40738,13,3133,1,0,'2022-08-08',4830.00,1,1.00,'Tique Factura B N°: 0013-00020557',NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(896,7968,2,40720,40738,13,3133,1,0,'2022-08-08',1100.00,1,1.00,'Tique Factura B N°: 0013-00020558',NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(897,7968,2,40720,40738,13,3133,1,0,'2022-08-08',1580.00,1,1.00,'Tique Factura B N°: 0013-00020561',NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL);
INSERT INTO `cta_cte_cliente` VALUES (898,7968,2,40720,40738,13,3133,1,0,'2022-08-08',3190.00,1,1.00,'Tique Factura B N°: 0013-00020562',NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(899,7968,2,40720,40738,13,3133,1,0,'2022-08-08',3440.00,1,1.00,'Tique Factura B N°: 0013-00020564',NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(900,7968,2,40720,40738,13,3133,1,0,'2022-08-08',1080.00,1,1.00,'Tique Factura B N°: 0013-00020565',NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(901,7968,2,40720,40738,13,3133,1,0,'2022-08-08',1260.00,1,1.00,'Tique Factura B N°: 0013-00020566',NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(902,7968,2,40720,40738,13,3133,1,0,'2022-08-09',420.00,1,1.00,'Tique Factura B N°: 0013-00020568',NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(903,7968,2,40720,40738,13,3133,1,0,'2022-08-09',1050.00,1,1.00,'Tique Factura B N°: 0013-00020569',NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(904,7968,2,40720,40738,13,3133,1,0,'2022-08-09',720.00,1,1.00,'Tique Factura B N°: 0013-00020570',NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(905,7968,2,40720,40738,13,3133,1,0,'2022-08-09',1580.00,1,1.00,'Tique Factura B N°: 0013-00020571',NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(906,7968,2,40720,40738,13,3133,1,0,'2022-08-09',790.00,1,1.00,'Tique Factura B N°: 0013-00020572',NULL,'2022-11-23 11:35:43','2022-11-23 11:35:43',NULL),(907,7968,2,40720,40738,13,3133,1,0,'2022-08-09',980.00,1,1.00,'Tique Factura B N°: 0013-00020574',NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(908,7968,2,40720,40738,13,3133,1,0,'2022-08-09',980.00,1,1.00,'Tique Factura B N°: 0013-00020575',NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(909,7968,2,40720,40738,13,3133,1,0,'2022-08-09',1100.00,1,1.00,'Tique Factura B N°: 0013-00020576',NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(910,7968,2,40720,40738,13,3133,1,0,'2022-08-09',980.00,1,1.00,'Tique Factura B N°: 0013-00020577',NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(911,7968,2,40720,40738,13,3133,1,0,'2022-08-09',1990.00,1,1.00,'Tique Factura B N°: 0013-00020578',NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(912,7968,2,40720,40738,13,3133,1,0,'2022-08-09',1840.00,1,1.00,'Tique Factura B N°: 0013-00020579',NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(913,7968,2,40720,40738,13,3133,1,0,'2022-08-09',890.00,1,1.00,'Tique Factura B N°: 0013-00020580',NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(914,7968,2,40720,40738,13,3133,1,0,'2022-08-09',1170.00,1,1.00,'Tique Factura B N°: 0013-00020581',NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(915,7968,2,40720,40738,13,3133,1,0,'2022-08-09',1080.00,1,1.00,'Tique Factura B N°: 0013-00020582',NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(916,7968,2,40720,40738,13,3133,1,0,'2022-08-09',560.00,1,1.00,'Tique Factura B N°: 0013-00020583',NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(917,7968,2,40720,40738,13,3133,1,0,'2022-08-09',1190.00,1,1.00,'Tique Factura B N°: 0013-00020584',NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(918,7968,2,40720,40738,13,3133,1,0,'2022-08-10',3570.00,1,1.00,'Tique Factura B N°: 0013-00020585',NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(919,7968,2,40720,40738,13,3133,1,0,'2022-08-10',1580.00,1,1.00,'Tique Factura B N°: 0013-00020586',NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(920,7968,2,40720,40738,13,3133,1,0,'2022-08-10',1400.00,1,1.00,'Tique Factura B N°: 0013-00020587',NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(921,7968,2,40720,40738,13,3133,1,0,'2022-08-11',2130.00,1,1.00,'Tique Factura B N°: 0013-00020588',NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(922,7968,2,40720,40738,13,3133,1,0,'2022-08-11',790.00,1,1.00,'Tique Factura B N°: 0013-00020589',NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL);
INSERT INTO `cta_cte_cliente` VALUES (923,7968,2,40720,40738,13,3133,1,0,'2022-08-11',2330.00,1,1.00,'Tique Factura B N°: 0013-00020590',NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(924,7968,2,40720,40738,13,3133,1,0,'2022-08-11',790.00,1,1.00,'Tique Factura B N°: 0013-00020591',NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(925,7968,2,40720,40738,13,3133,1,0,'2022-08-11',2370.00,1,1.00,'Tique Factura B N°: 0013-00020592',NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(926,7968,2,40720,40738,13,3133,1,0,'2022-08-11',470.00,1,1.00,'Tique Factura B N°: 0013-00020593',NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(927,7968,2,40720,40738,13,3133,1,0,'2022-08-11',540.00,1,1.00,'Tique Factura B N°: 0013-00020594',NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(928,7968,2,40720,40738,13,3133,1,0,'2022-08-11',560.00,1,1.00,'Tique Factura B N°: 0013-00020595',NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(929,7968,2,40720,40738,13,3133,1,0,'2022-08-11',1880.00,1,1.00,'Tique Factura B N°: 0013-00020596',NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(930,7968,2,40720,40738,13,3133,1,0,'2022-08-11',2400.00,1,1.00,'Tique Factura B N°: 0013-00020597',NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(931,7968,2,40720,40738,13,3133,1,0,'2022-08-11',970.00,1,1.00,'Tique Factura B N°: 0013-00020598',NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(932,7968,2,40720,40738,13,3133,1,0,'2022-08-12',1580.00,1,1.00,'Tique Factura B N°: 0013-00020599',NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(933,7968,2,40720,40738,13,3133,1,0,'2022-08-12',2160.00,1,1.00,'Tique Factura B N°: 0013-00020600',NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(934,7968,2,40720,40738,13,3133,1,0,'2022-08-12',790.00,1,1.00,'Tique Factura B N°: 0013-00020601',NULL,'2022-11-23 11:35:44','2022-11-23 11:35:44',NULL),(935,7968,2,40720,40738,13,3133,1,0,'2022-08-12',870.00,1,1.00,'Tique Factura B N°: 0013-00020602',NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(936,7968,2,40720,40738,13,3133,1,0,'2022-08-12',3180.00,1,1.00,'Tique Factura B N°: 0013-00020603',NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(937,7968,2,40720,40738,13,3133,1,0,'2022-08-12',280.00,1,1.00,'Tique Factura B N°: 0013-00020604',NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(938,7968,2,40720,40738,13,3133,1,0,'2022-08-12',2010.00,1,1.00,'Tique Factura B N°: 0013-00020605',NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(939,7968,2,40720,40738,13,3133,1,0,'2022-08-12',1890.00,1,1.00,'Tique Factura B N°: 0013-00020606',NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(940,7968,2,40720,40738,13,3133,1,0,'2022-08-12',980.00,1,1.00,'Tique Factura B N°: 0013-00020607',NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(941,7968,2,40720,40738,13,3133,1,0,'2022-08-12',1060.00,1,1.00,'Tique Factura B N°: 0013-00020608',NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(942,7968,2,40720,40738,13,3133,1,0,'2022-08-12',1020.00,1,1.00,'Tique Factura B N°: 0013-00020609',NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(943,7968,2,40720,40738,13,3133,1,0,'2022-08-12',280.00,1,1.00,'Tique Factura B N°: 0013-00020610',NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(944,7968,2,40720,40738,13,3133,1,0,'2022-08-13',890.00,1,1.00,'Tique Factura B N°: 0013-00020612',NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(945,7968,2,40720,40738,13,3133,1,0,'2022-08-13',1820.00,1,1.00,'Tique Factura B N°: 0013-00020613',NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(946,7968,2,40720,40738,13,3133,1,0,'2022-08-13',1840.00,1,1.00,'Tique Factura B N°: 0013-00020614',NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(947,7968,2,40720,40738,13,3133,1,0,'2022-08-13',2500.00,1,1.00,'Tique Factura B N°: 0013-00020615',NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL);
INSERT INTO `cta_cte_cliente` VALUES (948,7968,2,40720,40738,13,3133,1,0,'2022-08-13',1240.00,1,1.00,'Tique Factura B N°: 0013-00020616',NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(949,7968,2,40720,40738,13,3133,1,0,'2022-08-13',1300.00,1,1.00,'Tique Factura B N°: 0013-00020617',NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(950,7968,2,40720,40738,13,3133,1,0,'2022-08-13',3750.00,1,1.00,'Tique Factura B N°: 0013-00020618',NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(951,7968,2,40720,40738,13,3133,1,0,'2022-08-13',2810.00,1,1.00,'Tique Factura B N°: 0013-00020619',NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(952,7968,2,40720,40738,13,3133,1,0,'2022-08-13',1040.00,1,1.00,'Tique Factura B N°: 0013-00020621',NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(953,7968,2,40720,40738,13,3133,1,0,'2022-08-13',1350.00,1,1.00,'Tique Factura B N°: 0013-00020623',NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(954,7968,2,40720,40738,13,3133,1,0,'2022-08-13',970.00,1,1.00,'Tique Factura B N°: 0013-00020625',NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(955,7968,2,40720,40738,13,3133,1,0,'2022-08-13',990.00,1,1.00,'Tique Factura B N°: 0013-00020627',NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(956,7968,2,40720,40738,13,3133,1,0,'2022-08-16',510.00,1,1.00,'Tique Factura B N°: 0013-00020629',NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(957,7968,2,40720,40738,13,3133,1,0,'2022-08-16',510.00,1,1.00,'Tique Factura B N°: 0013-00020630',NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(958,7968,2,40720,40738,13,3133,1,0,'2022-08-16',490.00,1,1.00,'Tique Factura B N°: 0013-00020632',NULL,'2022-11-23 11:35:45','2022-11-23 11:35:45',NULL),(959,7968,2,40720,40738,13,3133,1,0,'2022-08-16',570.00,1,1.00,'Tique Factura B N°: 0013-00020633',NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(960,7968,2,40720,40738,13,3133,1,0,'2022-08-16',2100.00,1,1.00,'Tique Factura B N°: 0013-00020634',NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(961,7968,2,40720,40738,13,3133,1,0,'2022-08-16',2260.00,1,1.00,'Tique Factura B N°: 0013-00020635',NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(962,7968,2,40720,40738,13,3133,1,0,'2022-08-16',1770.00,1,1.00,'Tique Factura B N°: 0013-00020638',NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(963,7968,2,40720,40738,13,3133,1,0,'2022-08-16',1440.00,1,1.00,'Tique Factura B N°: 0013-00020639',NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(964,7968,2,40720,40738,13,3133,1,0,'2022-08-16',2980.00,1,1.00,'Tique Factura B N°: 0013-00020640',NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(965,7968,2,40720,40738,13,3133,1,0,'2022-08-16',1460.00,1,1.00,'Tique Factura B N°: 0013-00020641',NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(966,7968,2,40720,40738,13,3133,1,0,'2022-08-16',1390.00,1,1.00,'Tique Factura B N°: 0013-00020642',NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(967,7968,2,40720,40738,13,3133,1,0,'2022-08-16',360.00,1,1.00,'Tique Factura B N°: 0013-00020643',NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(968,7968,2,40720,40738,13,3133,1,0,'2022-08-16',790.00,1,1.00,'Tique Factura B N°: 0013-00020644',NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(969,7968,2,40720,40738,13,3133,1,0,'2022-08-17',1230.00,1,1.00,'Tique Factura B N°: 0013-00020645',NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(970,7968,2,40720,40738,13,3133,1,0,'2022-08-17',970.00,1,1.00,'Tique Factura B N°: 0013-00020646',NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(971,7968,2,40720,40738,13,3133,1,0,'2022-08-17',1580.00,1,1.00,'Tique Factura B N°: 0013-00020647',NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(972,7968,2,40720,40738,13,3133,1,0,'2022-08-17',640.00,1,1.00,'Tique Factura B N°: 0013-00020648',NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL);
INSERT INTO `cta_cte_cliente` VALUES (973,7968,2,40720,40738,13,3133,1,0,'2022-08-17',790.00,1,1.00,'Tique Factura B N°: 0013-00020649',NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(974,7968,2,40720,40738,13,3133,1,0,'2022-08-17',490.00,1,1.00,'Tique Factura B N°: 0013-00020650',NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(975,7968,2,40720,40738,13,3133,1,0,'2022-08-17',360.00,1,1.00,'Tique Factura B N°: 0013-00020651',NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(976,7968,2,40720,40738,13,3133,1,0,'2022-08-17',1120.00,1,1.00,'Tique Factura B N°: 0013-00020652',NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(977,7968,2,40720,40738,13,3133,1,0,'2022-08-17',780.00,1,1.00,'Tique Factura B N°: 0013-00020653',NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(978,7968,2,40720,40738,13,3133,1,0,'2022-08-17',840.00,1,1.00,'Tique Factura B N°: 0013-00020654',NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(979,7968,2,40720,40738,13,3133,1,0,'2022-08-17',1060.00,1,1.00,'Tique Factura B N°: 0013-00020655',NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(980,7968,2,40720,40738,13,3133,1,0,'2022-08-17',560.00,1,1.00,'Tique Factura B N°: 0013-00020656',NULL,'2022-11-23 11:35:46','2022-11-23 11:35:46',NULL),(981,7968,2,40720,40738,13,3133,1,0,'2022-08-17',460.00,1,1.00,'Tique Factura B N°: 0013-00020657',NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(982,7968,2,40720,40738,13,3133,1,0,'2022-08-18',1580.00,1,1.00,'Tique Factura B N°: 0013-00020658',NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(983,7968,2,40720,40738,13,3133,1,0,'2022-08-18',1160.00,1,1.00,'Tique Factura B N°: 0013-00020660',NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(984,7968,2,40720,40738,13,3133,1,0,'2022-08-18',850.00,1,1.00,'Tique Factura B N°: 0013-00020661',NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(985,7968,2,40720,40738,13,3133,1,0,'2022-08-18',720.00,1,1.00,'Tique Factura B N°: 0013-00020662',NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(986,7968,2,40720,40738,13,3133,1,0,'2022-08-18',1500.00,1,1.00,'Tique Factura B N°: 0013-00020663',NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(987,7968,2,40720,40738,13,3133,1,0,'2022-08-18',1220.00,1,1.00,'Tique Factura B N°: 0013-00020664',NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(988,7968,2,40720,40738,13,3133,1,0,'2022-08-18',2990.00,1,1.00,'Tique Factura B N°: 0013-00020665',NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(989,7968,2,40720,40738,13,3133,1,0,'2022-08-18',1300.00,1,1.00,'Tique Factura B N°: 0013-00020666',NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(990,7968,2,40720,40738,13,3133,1,0,'2022-08-19',1940.00,1,1.00,'Tique Factura B N°: 0013-00020668',NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(991,7968,2,40720,40738,13,3133,1,0,'2022-08-19',980.00,1,1.00,'Tique Factura B N°: 0013-00020669',NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(992,7968,2,40720,40738,13,3133,1,0,'2022-08-19',3230.00,1,1.00,'Tique Factura B N°: 0013-00020671',NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(993,7968,2,40720,40738,13,3133,1,0,'2022-08-19',2380.00,1,1.00,'Tique Factura B N°: 0013-00020672',NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(994,7968,2,40720,40738,13,3133,1,0,'2022-08-19',2560.00,1,1.00,'Tique Factura B N°: 0013-00020673',NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(995,7968,2,40720,40738,13,3133,1,0,'2022-08-19',470.00,1,1.00,'Tique Factura B N°: 0013-00020674',NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(996,7968,2,40720,40738,13,3133,1,0,'2022-08-19',800.00,1,1.00,'Tique Factura B N°: 0013-00020676',NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(997,7968,2,40720,40738,13,3133,1,0,'2022-08-19',1840.00,1,1.00,'Tique Factura B N°: 0013-00020677',NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL);
INSERT INTO `cta_cte_cliente` VALUES (998,7968,2,40720,40738,13,3133,1,0,'2022-08-19',2000.00,1,1.00,'Tique Factura B N°: 0013-00020678',NULL,'2022-11-23 11:35:47','2022-11-23 11:35:47',NULL),(999,7968,2,40720,40738,13,3133,1,0,'2022-08-20',2340.00,1,1.00,'Tique Factura B N°: 0013-00020679',NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1000,7968,2,40720,40738,13,3133,1,0,'2022-08-20',1960.00,1,1.00,'Tique Factura B N°: 0013-00020680',NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1001,7968,2,40720,40738,13,3133,1,0,'2022-08-20',1300.00,1,1.00,'Tique Factura B N°: 0013-00020682',NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1002,7968,2,40720,40738,13,3133,1,0,'2022-08-20',3100.00,1,1.00,'Tique Factura B N°: 0013-00020683',NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1003,7968,2,40720,40738,13,3133,1,0,'2022-08-20',1890.00,1,1.00,'Tique Factura B N°: 0013-00020684',NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1004,7968,2,40720,40738,13,3133,1,0,'2022-08-20',2780.00,1,1.00,'Tique Factura B N°: 0013-00020685',NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1005,7968,2,40720,40738,13,3133,1,0,'2022-08-20',3930.00,1,1.00,'Tique Factura B N°: 0013-00020686',NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1006,7968,2,40720,40738,13,3133,1,0,'2022-08-20',1440.00,1,1.00,'Tique Factura B N°: 0013-00020687',NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1007,7968,2,40720,40738,13,3133,1,0,'2022-08-20',1710.00,1,1.00,'Tique Factura B N°: 0013-00020688',NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1008,7968,2,40720,40738,13,3133,1,0,'2022-08-20',960.00,1,1.00,'Tique Factura B N°: 0013-00020689',NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1009,7968,2,40720,40738,13,3133,1,0,'2022-08-20',2410.00,1,1.00,'Tique Factura B N°: 0013-00020690',NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1010,7968,2,40720,40738,13,3133,1,0,'2022-08-20',1500.00,1,1.00,'Tique Factura B N°: 0013-00020691',NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1011,7968,2,40720,40738,13,3133,1,0,'2022-08-20',1160.00,1,1.00,'Tique Factura B N°: 0013-00020692',NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1012,7968,2,40720,40738,13,3133,1,0,'2022-08-20',1130.00,1,1.00,'Tique Factura B N°: 0013-00020693',NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1013,7968,2,40720,40738,13,3133,1,0,'2022-08-20',1690.00,1,1.00,'Tique Factura B N°: 0013-00020694',NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1014,7968,2,40720,40738,13,3133,1,0,'2022-08-22',790.00,1,1.00,'Tique Factura B N°: 0013-00020695',NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1015,7968,2,40720,40738,13,3133,1,0,'2022-08-22',3160.00,1,1.00,'Tique Factura B N°: 0013-00020696',NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1016,7968,2,40720,40738,13,3133,1,0,'2022-08-22',1960.00,1,1.00,'Tique Factura B N°: 0013-00020697',NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1017,7968,2,40720,40738,13,3133,1,0,'2022-08-22',790.00,1,1.00,'Tique Factura B N°: 0013-00020698',NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1018,7968,2,40720,40738,13,3133,1,0,'2022-08-22',1800.00,1,1.00,'Tique Factura B N°: 0013-00020699',NULL,'2022-11-23 11:35:48','2022-11-23 11:35:48',NULL),(1019,7968,2,40720,40738,13,3133,1,0,'2022-08-22',1100.00,1,1.00,'Tique Factura B N°: 0013-00020701',NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1020,7968,2,40720,40738,13,3133,1,0,'2022-08-22',1100.00,1,1.00,'Tique Factura B N°: 0013-00020702',NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1021,7968,2,40720,40738,13,3133,1,0,'2022-08-22',1280.00,1,1.00,'Tique Factura B N°: 0013-00020703',NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1022,7968,2,40720,40738,13,3133,1,0,'2022-08-22',790.00,1,1.00,'Tique Factura B N°: 0013-00020706',NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL);
INSERT INTO `cta_cte_cliente` VALUES (1023,7968,2,40720,40738,13,3133,1,0,'2022-08-22',1520.00,1,1.00,'Tique Factura B N°: 0013-00020709',NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1024,7968,2,40720,40738,13,3133,1,0,'2022-08-23',1580.00,1,1.00,'Tique Factura B N°: 0013-00020710',NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1025,7968,2,40720,40738,13,3133,1,0,'2022-08-23',1100.00,1,1.00,'Tique Factura B N°: 0013-00020711',NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1026,7968,2,40720,40738,13,3133,1,0,'2022-08-23',1300.00,1,1.00,'Tique Factura B N°: 0013-00020712',NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1027,7968,2,40720,40738,13,3133,1,0,'2022-08-23',300.00,1,1.00,'Tique Factura B N°: 0013-00020713',NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1028,7968,2,40720,40738,13,3133,1,0,'2022-08-23',1010.00,1,1.00,'Tique Factura B N°: 0013-00020714',NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1029,7968,2,40720,40738,13,3133,1,0,'2022-08-23',1000.00,1,1.00,'Tique Factura B N°: 0013-00020715',NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1030,7968,2,40720,40738,13,3133,1,0,'2022-08-24',510.00,1,1.00,'Tique Factura B N°: 0013-00020716',NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1031,7968,2,40720,40738,13,3133,1,0,'2022-08-24',260.00,1,1.00,'Tique Factura B N°: 0013-00020718',NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1032,7968,2,40720,40738,13,3133,1,0,'2022-08-24',280.00,1,1.00,'Tique Factura B N°: 0013-00020719',NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1033,7968,2,40720,40738,13,3133,1,0,'2022-08-24',2000.00,1,1.00,'Tique Factura B N°: 0013-00020720',NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1034,7968,2,40720,40738,13,3133,1,0,'2022-08-24',950.00,1,1.00,'Tique Factura B N°: 0013-00020721',NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1035,7968,2,40720,40738,13,3133,1,0,'2022-08-24',1840.00,1,1.00,'Tique Factura B N°: 0013-00020724',NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1036,7968,2,40720,40738,13,3133,1,0,'2022-08-24',3040.00,1,1.00,'Tique Factura B N°: 0013-00020725',NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1037,7968,2,40720,40738,13,3133,1,0,'2022-08-24',2330.00,1,1.00,'Tique Factura B N°: 0013-00020726',NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1038,7968,2,40720,40738,13,3133,1,0,'2022-08-24',3430.00,1,1.00,'Tique Factura B N°: 0013-00020727',NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1039,7968,2,40720,40738,13,3133,1,0,'2022-08-24',2450.00,1,1.00,'Tique Factura B N°: 0013-00020728',NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1040,7968,2,40720,40738,13,3133,1,0,'2022-08-24',700.00,1,1.00,'Tique Factura B N°: 0013-00020729',NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1041,7968,2,40720,40738,13,3133,1,0,'2022-08-24',570.00,1,1.00,'Tique Factura B N°: 0013-00020730',NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1042,7968,2,40720,40738,13,3133,1,0,'2022-08-25',790.00,1,1.00,'Tique Factura B N°: 0013-00020731',NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1043,7968,2,40720,40738,13,3133,1,0,'2022-08-25',620.00,1,1.00,'Tique Factura B N°: 0013-00020732',NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1044,7968,2,40720,40738,13,3133,1,0,'2022-08-25',1460.00,1,1.00,'Tique Factura B N°: 0013-00020733',NULL,'2022-11-23 11:35:49','2022-11-23 11:35:49',NULL),(1045,7968,2,40720,40738,13,3133,1,0,'2022-08-25',3890.00,1,1.00,'Tique Factura B N°: 0013-00020734',NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1046,7968,2,40720,40738,13,3133,1,0,'2022-08-25',790.00,1,1.00,'Tique Factura B N°: 0013-00020735',NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1047,7968,2,40720,40738,13,3133,1,0,'2022-08-25',980.00,1,1.00,'Tique Factura B N°: 0013-00020737',NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL);
INSERT INTO `cta_cte_cliente` VALUES (1048,7968,2,40720,40738,13,3133,1,0,'2022-08-25',950.00,1,1.00,'Tique Factura B N°: 0013-00020738',NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1049,7968,2,40720,40738,13,3133,1,0,'2022-08-25',810.00,1,1.00,'Tique Factura B N°: 0013-00020739',NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1050,7968,2,40720,40738,13,3133,1,0,'2022-08-25',1720.00,1,1.00,'Tique Factura B N°: 0013-00020740',NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1051,7968,2,40720,40738,13,3133,1,0,'2022-08-25',650.00,1,1.00,'Tique Factura B N°: 0013-00020741',NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1052,7968,2,40720,40738,13,3133,1,0,'2022-08-25',560.00,1,1.00,'Tique Factura B N°: 0013-00020742',NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1053,7968,2,40720,40738,13,3133,1,0,'2022-08-25',2400.00,1,1.00,'Tique Factura B N°: 0013-00020744',NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1054,7968,2,40720,40738,13,3133,1,0,'2022-08-25',4250.00,1,1.00,'Tique Factura B N°: 0013-00020745',NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1055,7968,2,40720,40738,13,3133,1,0,'2022-08-25',980.00,1,1.00,'Tique Factura B N°: 0013-00020746',NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1056,7968,2,40720,40738,13,3133,1,0,'2022-08-26',490.00,1,1.00,'Tique Factura B N°: 0013-00020748',NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1057,7968,2,40720,40738,13,3133,1,0,'2022-08-26',660.00,1,1.00,'Tique Factura B N°: 0013-00020749',NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1058,7968,2,40720,40738,13,3133,1,0,'2022-08-26',790.00,1,1.00,'Tique Factura B N°: 0013-00020750',NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1059,7968,2,40720,40738,13,3133,1,0,'2022-08-26',1940.00,1,1.00,'Tique Factura B N°: 0013-00020752',NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1060,7968,2,40720,40738,13,3133,1,0,'2022-08-26',1100.00,1,1.00,'Tique Factura B N°: 0013-00020754',NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1061,7968,2,40720,40738,13,3133,1,0,'2022-08-26',1960.00,1,1.00,'Tique Factura B N°: 0013-00020755',NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1062,7968,2,40720,40738,13,3133,1,0,'2022-08-26',2900.00,1,1.00,'Tique Factura B N°: 0013-00020756',NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1063,7968,2,40720,40738,13,3133,1,0,'2022-08-27',460.00,1,1.00,'Tique Factura B N°: 0013-00020760',NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1064,7968,2,40720,40738,13,3133,1,0,'2022-08-27',980.00,1,1.00,'Tique Factura B N°: 0013-00020761',NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1065,7968,2,40720,40738,13,3133,1,0,'2022-08-27',980.00,1,1.00,'Tique Factura B N°: 0013-00020762',NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1066,7968,2,40720,40738,13,3133,1,0,'2022-08-27',3230.00,1,1.00,'Tique Factura B N°: 0013-00020763',NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1067,7968,2,40720,40738,13,3133,1,0,'2022-08-27',1110.00,1,1.00,'Tique Factura B N°: 0013-00020764',NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1068,7968,2,40720,40738,13,3133,1,0,'2022-08-27',1040.00,1,1.00,'Tique Factura B N°: 0013-00020765',NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1069,7968,2,40720,40738,13,3133,1,0,'2022-08-27',1550.00,1,1.00,'Tique Factura B N°: 0013-00020766',NULL,'2022-11-23 11:35:50','2022-11-23 11:35:50',NULL),(1070,7968,2,40720,40738,13,3133,1,0,'2022-08-29',470.00,1,1.00,'Tique Factura B N°: 0013-00020768',NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(1071,7968,2,40720,40738,13,3133,1,0,'2022-08-29',1520.00,1,1.00,'Tique Factura B N°: 0013-00020769',NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(1072,7968,2,40720,40738,13,3133,1,0,'2022-08-29',790.00,1,1.00,'Tique Factura B N°: 0013-00020771',NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL);
INSERT INTO `cta_cte_cliente` VALUES (1073,7968,2,40720,40738,13,3133,1,0,'2022-08-29',1230.00,1,1.00,'Tique Factura B N°: 0013-00020772',NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(1074,7968,2,40720,40738,13,3133,1,0,'2022-08-29',1630.00,1,1.00,'Tique Factura B N°: 0013-00020774',NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(1075,7968,2,40720,40738,13,3133,1,0,'2022-08-29',2720.00,1,1.00,'Tique Factura B N°: 0013-00020775',NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(1076,7968,2,40720,40738,13,3133,1,0,'2022-08-29',3340.00,1,1.00,'Tique Factura B N°: 0013-00020776',NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(1077,7968,2,40720,40738,13,3133,1,0,'2022-08-29',2990.00,1,1.00,'Tique Factura B N°: 0013-00020778',NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(1078,7968,2,40720,40738,13,3133,1,0,'2022-08-29',1580.00,1,1.00,'Tique Factura B N°: 0013-00020779',NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(1079,7968,2,40720,40738,13,3133,1,0,'2022-08-29',1490.00,1,1.00,'Tique Factura B N°: 0013-00020780',NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(1080,7968,2,40720,40738,13,3133,1,0,'2022-08-29',1180.00,1,1.00,'Tique Factura B N°: 0013-00020781',NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(1081,7968,2,40720,40738,13,3133,1,0,'2022-08-30',980.00,1,1.00,'Tique Factura B N°: 0013-00020782',NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(1082,7968,2,40720,40738,13,3133,1,0,'2022-08-30',790.00,1,1.00,'Tique Factura B N°: 0013-00020783',NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(1083,7968,2,40720,40738,13,3133,1,0,'2022-08-30',2200.00,1,1.00,'Tique Factura B N°: 0013-00020784',NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(1084,7968,2,40720,40738,13,3133,1,0,'2022-08-30',1990.00,1,1.00,'Tique Factura B N°: 0013-00020785',NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(1085,7968,2,40720,40738,13,3133,1,0,'2022-08-30',1960.00,1,1.00,'Tique Factura B N°: 0013-00020786',NULL,'2022-11-23 11:35:51','2022-11-23 11:35:51',NULL),(1086,7968,2,40720,40738,13,3133,1,0,'2022-08-30',540.00,1,1.00,'Tique Factura B N°: 0013-00020787',NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(1087,7968,2,40720,40738,13,3133,1,0,'2022-08-30',1490.00,1,1.00,'Tique Factura B N°: 0013-00020789',NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(1088,7968,2,40720,40738,13,3133,1,0,'2022-08-30',1980.00,1,1.00,'Tique Factura B N°: 0013-00020790',NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(1089,7968,2,40720,40738,13,3133,1,0,'2022-08-30',600.00,1,1.00,'Tique Factura B N°: 0013-00020791',NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(1090,7968,2,40720,40738,13,3133,1,0,'2022-08-31',720.00,1,1.00,'Tique Factura B N°: 0013-00020792',NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(1091,7968,2,40720,40738,13,3133,1,0,'2022-08-31',980.00,1,1.00,'Tique Factura B N°: 0013-00020793',NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(1092,7968,2,40720,40738,13,3133,1,0,'2022-08-31',1580.00,1,1.00,'Tique Factura B N°: 0013-00020795',NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(1093,7968,2,40720,40738,13,3133,1,0,'2022-08-31',2080.00,1,1.00,'Tique Factura B N°: 0013-00020796',NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(1094,7968,2,40720,40738,13,3133,1,0,'2022-08-31',940.00,1,1.00,'Tique Factura B N°: 0013-00020797',NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(1095,7968,2,40720,40738,13,3133,1,0,'2022-08-31',1280.00,1,1.00,'Tique Factura B N°: 0013-00020798',NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(1096,7968,2,40720,40738,13,3133,1,0,'2022-08-31',510.00,1,1.00,'Tique Factura B N°: 0013-00020799',NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(1097,7968,2,40720,40738,13,3133,1,0,'2022-08-31',1350.00,1,1.00,'Tique Factura B N°: 0013-00020800',NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL);
INSERT INTO `cta_cte_cliente` VALUES (1098,7968,2,40720,40738,13,3133,1,0,'2022-08-31',750.00,1,1.00,'Tique Factura B N°: 0013-00020801',NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL),(1099,7968,2,40720,40738,13,3133,1,0,'2022-08-31',830.00,1,1.00,'Tique Factura B N°: 0013-00020802',NULL,'2022-11-23 11:35:52','2022-11-23 11:35:52',NULL);
/*!40000 ALTER TABLE `cta_cte_cliente` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente_details`
--

DROP TABLE IF EXISTS `cta_cte_cliente_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_cliente_details_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_cliente_details_person_id_foreign` (`person_id`),
  KEY `cta_cte_cliente_details_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `cta_cte_cliente_details_period_id_foreign` (`period_id`),
  KEY `cta_cte_cliente_details_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `cta_cte_cliente_details_saldo_id_foreign` (`saldo_id`),
  KEY `cta_cte_cliente_details_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `cta_cte_cliente_details_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `cta_cte_cliente_details_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_cliente_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_cliente_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_details_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `cta_cte_cliente_details_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente_details`
--

LOCK TABLES `cta_cte_cliente_details` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_cliente_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente_pivot_receipt`
--

DROP TABLE IF EXISTS `cta_cte_cliente_pivot_receipt`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente_pivot_receipt` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned NOT NULL,
  `receipt_id` int(11) DEFAULT NULL,
  `importe` decimal(16,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1100 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente_pivot_receipt`
--

LOCK TABLES `cta_cte_cliente_pivot_receipt` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente_pivot_receipt` DISABLE KEYS */;
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (1,7968,1,1,NULL,'2022-10-22 15:54:00','2022-10-22 15:54:00',NULL),(2,7968,2,2,NULL,'2022-10-22 15:54:00','2022-10-22 15:54:00',NULL),(3,7968,3,3,NULL,'2022-10-22 15:54:00','2022-10-22 15:54:00',NULL),(4,7968,4,4,NULL,'2022-10-22 15:54:00','2022-10-22 15:54:00',NULL),(5,7968,5,5,NULL,'2022-10-22 15:54:01','2022-10-22 15:54:01',NULL),(6,7968,6,6,NULL,'2022-10-22 15:54:01','2022-10-22 15:54:01',NULL),(7,7968,7,7,NULL,'2022-10-22 15:54:01','2022-10-22 15:54:01',NULL),(8,7968,8,8,NULL,'2022-10-22 15:54:01','2022-10-22 15:54:01',NULL),(9,7968,9,9,NULL,'2022-10-22 15:54:01','2022-10-22 15:54:01',NULL),(10,7968,10,10,NULL,'2022-10-22 15:54:01','2022-10-22 15:54:01',NULL),(11,7968,11,11,NULL,'2022-10-22 15:54:01','2022-10-22 15:54:01',NULL),(12,7968,12,12,NULL,'2022-10-22 15:54:01','2022-10-25 15:46:59','2022-10-25 15:46:59'),(13,7968,13,13,NULL,'2022-10-22 15:54:01','2022-10-25 15:46:34','2022-10-25 15:46:34'),(14,7968,14,14,NULL,'2022-10-22 15:54:01','2022-10-25 15:43:23','2022-10-25 15:43:23'),(15,7968,15,15,NULL,'2022-10-22 15:54:01','2022-10-22 15:54:01',NULL),(16,7968,16,16,NULL,'2022-10-22 15:54:01','2022-10-22 15:54:01',NULL),(17,7968,17,17,NULL,'2022-10-22 15:54:01','2022-10-22 15:54:01',NULL),(18,7968,18,18,NULL,'2022-10-22 15:54:01','2022-10-22 15:54:01',NULL),(19,7968,19,19,NULL,'2022-10-22 15:54:01','2022-10-22 15:54:01',NULL),(20,7968,20,20,NULL,'2022-10-22 15:54:01','2022-10-22 15:54:01',NULL),(21,7968,21,21,NULL,'2022-10-22 15:54:01','2022-10-22 15:54:01',NULL),(22,7968,22,22,NULL,'2022-10-22 15:54:01','2022-10-22 15:54:01',NULL),(23,7968,23,23,NULL,'2022-10-22 15:54:01','2022-10-22 15:54:01',NULL),(24,7968,24,24,NULL,'2022-10-22 15:54:01','2022-10-22 15:54:01',NULL),(25,7968,25,25,NULL,'2022-10-22 15:54:01','2022-10-22 15:54:01',NULL),(26,7968,26,26,NULL,'2022-10-22 15:54:01','2022-10-25 15:44:09','2022-10-25 15:44:09'),(27,7968,27,27,NULL,'2022-10-22 15:54:01','2022-10-22 15:54:01',NULL),(28,7968,28,28,NULL,'2022-10-22 15:54:01','2022-10-25 15:41:15','2022-10-25 15:41:15'),(29,7968,29,29,NULL,'2022-10-22 15:54:02','2022-10-24 17:07:57','2022-10-24 17:07:57'),(30,7968,30,30,NULL,'2022-10-22 15:54:02','2022-10-24 17:07:08','2022-10-24 17:07:08'),(31,7968,31,31,NULL,'2022-10-22 15:54:02','2022-10-24 17:06:48','2022-10-24 17:06:48'),(32,7968,32,32,NULL,'2022-10-22 15:54:02','2022-10-24 17:05:43','2022-10-24 17:05:43'),(33,7968,33,33,NULL,'2022-10-22 15:54:02','2022-10-24 17:04:30','2022-10-24 17:04:30'),(34,7968,34,34,NULL,'2022-10-22 15:54:02','2022-10-24 15:16:21','2022-10-24 15:16:21'),(35,7968,35,35,NULL,'2022-10-22 15:54:02','2022-10-24 16:50:22','2022-10-24 16:50:22'),(36,7968,36,36,NULL,'2022-10-22 15:54:02','2022-10-24 15:15:51','2022-10-24 15:15:51'),(37,7968,37,37,NULL,'2022-10-22 15:54:02','2022-10-24 15:11:24','2022-10-24 15:11:24'),(38,7968,38,38,NULL,'2022-10-22 15:54:02','2022-10-24 15:14:55','2022-10-24 15:14:55'),(39,7968,39,37,NULL,'2022-10-24 15:11:24','2022-10-24 16:45:15','2022-10-24 16:45:15'),(40,7968,40,38,NULL,'2022-10-24 15:14:55','2022-10-24 16:37:31','2022-10-24 16:37:31'),(41,7968,41,36,NULL,'2022-10-24 15:15:51','2022-10-24 16:47:54','2022-10-24 16:47:54'),(42,7968,42,34,NULL,'2022-10-24 15:16:21','2022-10-24 17:03:26','2022-10-24 17:03:26'),(43,7968,43,38,NULL,'2022-10-24 16:37:31','2022-10-24 16:44:21','2022-10-24 16:44:21'),(44,7968,44,38,NULL,'2022-10-24 16:44:21','2022-10-24 16:44:29','2022-10-24 16:44:29'),(45,7968,45,38,NULL,'2022-10-24 16:44:29','2022-10-24 16:44:29',NULL),(46,7968,46,37,NULL,'2022-10-24 16:45:15','2022-10-24 16:46:45','2022-10-24 16:46:45'),(47,7968,47,37,NULL,'2022-10-24 16:46:45','2022-10-24 16:46:45',NULL),(48,7968,48,36,NULL,'2022-10-24 16:47:54','2022-10-24 16:47:54',NULL),(49,7968,49,35,NULL,'2022-10-24 16:50:22','2022-10-24 16:50:22',NULL),(50,7968,50,34,NULL,'2022-10-24 17:03:26','2022-10-24 17:03:26',NULL),(51,7968,51,33,NULL,'2022-10-24 17:04:30','2022-10-24 17:04:30',NULL),(52,7968,52,32,NULL,'2022-10-24 17:05:43','2022-10-24 17:05:43',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (53,7968,53,31,NULL,'2022-10-24 17:06:48','2022-10-24 17:06:48',NULL),(54,7968,54,30,NULL,'2022-10-24 17:07:08','2022-10-24 17:07:08',NULL),(55,7968,55,29,NULL,'2022-10-24 17:07:57','2022-10-24 17:07:57',NULL),(56,7968,56,28,NULL,'2022-10-25 15:41:15','2022-10-25 15:42:00','2022-10-25 15:42:00'),(57,7968,57,28,NULL,'2022-10-25 15:42:00','2022-10-25 15:42:00',NULL),(58,7968,58,14,NULL,'2022-10-25 15:43:23','2022-10-25 15:44:39','2022-10-25 15:44:39'),(59,7968,59,26,NULL,'2022-10-25 15:44:09','2022-10-25 15:44:09',NULL),(60,7968,60,14,NULL,'2022-10-25 15:44:39','2022-10-25 15:44:39',NULL),(61,7968,61,13,NULL,'2022-10-25 15:46:34','2022-10-25 15:46:34',NULL),(62,7968,62,12,NULL,'2022-10-25 15:46:59','2022-10-25 15:46:59',NULL),(63,7968,63,39,NULL,'2022-10-25 15:53:23','2022-10-25 15:53:23',NULL),(64,7968,64,40,NULL,'2022-10-25 15:53:23','2022-10-25 15:53:23',NULL),(65,7968,65,41,NULL,'2022-10-25 15:53:23','2022-10-25 15:53:23',NULL),(66,7968,66,42,NULL,'2022-10-25 15:53:23','2022-10-25 15:53:23',NULL),(67,7968,67,43,NULL,'2022-10-25 15:53:24','2022-10-25 15:53:24',NULL),(68,7968,68,44,NULL,'2022-10-25 15:53:24','2022-10-25 15:53:24',NULL),(69,7968,69,45,NULL,'2022-10-25 15:53:24','2022-10-25 15:53:24',NULL),(70,7968,70,46,NULL,'2022-10-25 15:53:24','2022-10-25 15:53:24',NULL),(71,7968,71,47,NULL,'2022-10-25 15:53:24','2022-10-25 15:53:24',NULL),(72,7968,72,48,NULL,'2022-10-25 15:53:24','2022-10-25 15:53:24',NULL),(73,7968,73,49,NULL,'2022-10-25 15:53:24','2022-10-25 15:53:24',NULL),(74,7968,74,50,NULL,'2022-10-25 15:53:24','2022-10-25 15:53:24',NULL),(75,7968,75,51,NULL,'2022-10-25 15:53:24','2022-10-25 15:53:24',NULL),(76,7968,76,52,NULL,'2022-10-25 15:53:24','2022-10-25 15:53:24',NULL),(77,7968,77,53,NULL,'2022-10-25 15:53:24','2022-10-25 15:53:24',NULL),(78,7968,78,54,NULL,'2022-10-25 15:53:24','2022-10-25 15:53:24',NULL),(79,7968,79,55,NULL,'2022-10-25 15:53:24','2022-10-25 15:53:24',NULL),(80,7968,80,56,NULL,'2022-10-25 15:53:24','2022-10-25 15:53:24',NULL),(81,7968,81,57,NULL,'2022-10-25 15:53:24','2022-10-25 15:53:24',NULL),(82,7968,82,58,NULL,'2022-10-25 15:53:24','2022-10-25 15:53:24',NULL),(83,7968,83,59,NULL,'2022-10-25 15:53:24','2022-10-25 15:53:24',NULL),(84,7968,84,60,NULL,'2022-10-25 15:53:24','2022-10-25 15:53:24',NULL),(85,7968,85,61,NULL,'2022-10-25 15:53:24','2022-10-25 15:53:24',NULL),(86,7968,86,62,NULL,'2022-10-25 15:53:24','2022-10-25 15:53:24',NULL),(87,7968,87,63,NULL,'2022-10-25 15:53:24','2022-10-25 15:53:24',NULL),(88,7968,88,64,NULL,'2022-10-25 15:53:24','2022-10-25 15:53:24',NULL),(89,7968,89,65,NULL,'2022-10-25 15:53:24','2022-10-25 15:53:24',NULL),(90,7968,90,66,NULL,'2022-10-25 15:53:24','2022-10-25 15:53:24',NULL),(91,7968,91,67,NULL,'2022-10-25 15:53:24','2022-10-25 15:53:24',NULL),(92,7968,92,68,NULL,'2022-10-25 15:53:24','2022-10-25 15:53:24',NULL),(93,7968,93,69,NULL,'2022-10-25 15:53:24','2022-10-25 15:53:24',NULL),(94,7968,94,70,NULL,'2022-10-25 15:53:25','2022-10-25 15:53:25',NULL),(95,7968,95,71,NULL,'2022-10-25 15:53:25','2022-10-25 15:53:25',NULL),(96,7968,96,72,NULL,'2022-10-25 15:53:25','2022-10-25 15:53:25',NULL),(97,7968,97,73,NULL,'2022-10-25 15:53:25','2022-10-25 15:53:25',NULL),(98,7968,98,74,NULL,'2022-10-25 15:53:25','2022-10-25 15:56:03','2022-10-25 15:56:03'),(99,7968,99,75,NULL,'2022-10-25 15:53:25','2022-10-25 15:55:56','2022-10-25 15:55:56'),(100,7968,100,76,NULL,'2022-10-25 15:53:25','2022-10-25 15:53:25',NULL),(101,7968,101,75,NULL,'2022-10-25 15:55:56','2022-10-25 15:55:56',NULL),(102,7968,102,74,NULL,'2022-10-25 15:56:03','2022-10-25 15:56:03',NULL),(103,7968,103,77,NULL,'2022-10-25 16:49:26','2022-10-25 16:49:26',NULL),(104,7968,104,78,NULL,'2022-10-25 16:49:26','2022-10-25 16:49:26',NULL),(105,7968,105,79,NULL,'2022-10-25 16:49:26','2022-10-25 16:49:26',NULL),(106,7968,106,80,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(107,7968,107,81,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (108,7968,108,82,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(109,7968,109,83,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(110,7968,110,84,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(111,7968,111,85,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(112,7968,112,86,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(113,7968,113,87,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(114,7968,114,88,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(115,7968,115,89,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(116,7968,116,90,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(117,7968,117,91,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(118,7968,118,92,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(119,7968,119,93,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(120,7968,120,94,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(121,7968,121,95,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(122,7968,122,96,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(123,7968,123,97,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(124,7968,124,98,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(125,7968,125,99,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(126,7968,126,100,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(127,7968,127,101,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(128,7968,128,102,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(129,7968,129,103,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(130,7968,130,104,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(131,7968,131,105,NULL,'2022-10-25 16:49:27','2022-10-25 16:49:27',NULL),(132,7968,132,106,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(133,7968,133,107,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(134,7968,134,108,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(135,7968,135,109,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(136,7968,136,110,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(137,7968,137,111,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(138,7968,138,112,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(139,7968,139,113,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(140,7968,140,114,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(141,7968,141,115,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(142,7968,142,116,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(143,7968,143,117,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(144,7968,144,118,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(145,7968,145,119,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(146,7968,146,120,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(147,7968,147,121,NULL,'2022-10-25 16:49:28','2022-10-25 16:49:28',NULL),(148,7968,148,122,NULL,'2022-10-25 16:49:28','2022-10-25 16:54:13','2022-10-25 16:54:13'),(149,7968,149,123,NULL,'2022-10-25 16:49:28','2022-10-25 16:54:05','2022-10-25 16:54:05'),(150,7968,150,123,NULL,'2022-10-25 16:54:05','2022-10-25 16:54:05',NULL),(151,7968,151,122,NULL,'2022-10-25 16:54:13','2022-10-25 16:54:13',NULL),(152,7968,152,124,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(153,7968,153,125,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(154,7968,154,126,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(155,7968,155,127,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(156,7968,156,128,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(157,7968,157,129,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(158,7968,158,130,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(159,7968,159,131,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(160,7968,160,132,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(161,7968,161,133,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (162,7968,162,134,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(163,7968,163,135,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(164,7968,164,136,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(165,7968,165,137,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(166,7968,166,138,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(167,7968,167,139,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(168,7968,168,140,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(169,7968,169,141,NULL,'2022-10-25 17:11:09','2022-10-25 17:11:09',NULL),(170,7968,170,142,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(171,7968,171,143,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(172,7968,172,144,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(173,7968,173,145,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(174,7968,174,146,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(175,7968,175,147,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(176,7968,176,148,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(177,7968,177,149,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(178,7968,178,150,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(179,7968,179,151,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(180,7968,180,152,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(181,7968,181,153,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(182,7968,182,154,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(183,7968,183,155,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(184,7968,184,156,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(185,7968,185,157,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(186,7968,186,158,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(187,7968,187,159,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(188,7968,188,160,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:10',NULL),(189,7968,189,161,NULL,'2022-10-25 17:11:10','2022-10-25 17:11:39','2022-10-25 17:11:39'),(190,7968,190,161,NULL,'2022-10-25 17:11:39','2022-10-25 17:11:39',NULL),(191,7968,191,162,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:08',NULL),(192,7968,192,163,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:08',NULL),(193,7968,193,164,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:08',NULL),(194,7968,194,165,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:08',NULL),(195,7968,195,166,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:08',NULL),(196,7968,196,167,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:08',NULL),(197,7968,197,168,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:08',NULL),(198,7968,198,169,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:08',NULL),(199,7968,199,170,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:08',NULL),(200,7968,200,171,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:08',NULL),(201,7968,201,172,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:08',NULL),(202,7968,202,173,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:08',NULL),(203,7968,203,174,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:08',NULL),(204,7968,204,175,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:08',NULL),(205,7968,205,176,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:08',NULL),(206,7968,206,177,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:08',NULL),(207,7968,207,178,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:08',NULL),(208,7968,208,179,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:08',NULL),(209,7968,209,180,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:08',NULL),(210,7968,210,181,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:08',NULL),(211,7968,211,182,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:08',NULL),(212,7968,212,183,NULL,'2022-11-21 20:45:08','2022-11-21 20:45:08',NULL),(213,7968,213,184,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:09',NULL),(214,7968,214,185,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:09',NULL),(215,7968,215,186,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:09',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (216,7968,216,187,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:09',NULL),(217,7968,217,188,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:09',NULL),(218,7968,218,189,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:09',NULL),(219,7968,219,190,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:09',NULL),(220,7968,220,191,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:09',NULL),(221,7968,221,192,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:09',NULL),(222,7968,222,193,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:09',NULL),(223,7968,223,194,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:09',NULL),(224,7968,224,195,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:09',NULL),(225,7968,225,196,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:09',NULL),(226,7968,226,197,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:09',NULL),(227,7968,227,198,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:09',NULL),(228,7968,228,199,NULL,'2022-11-21 20:45:09','2022-11-21 20:45:09',NULL),(229,7968,229,200,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(230,7968,230,201,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(231,7968,231,202,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(232,7968,232,203,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(233,7968,233,204,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(234,7968,234,205,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(235,7968,235,206,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(236,7968,236,207,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(237,7968,237,208,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(238,7968,238,209,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(239,7968,239,210,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(240,7968,240,211,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(241,7968,241,212,NULL,'2022-11-21 20:46:54','2022-11-21 20:46:54',NULL),(242,7968,242,213,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(243,7968,243,214,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(244,7968,244,215,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(245,7968,245,216,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(246,7968,246,217,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(247,7968,247,218,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(248,7968,248,219,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(249,7968,249,220,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(250,7968,250,221,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(251,7968,251,222,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(252,7968,252,223,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(253,7968,253,224,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(254,7968,254,225,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(255,7968,255,226,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(256,7968,256,227,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(257,7968,257,228,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(258,7968,258,229,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(259,7968,259,230,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(260,7968,260,231,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(261,7968,261,232,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(262,7968,262,233,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(263,7968,263,234,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(264,7968,264,235,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(265,7968,265,236,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(266,7968,266,237,NULL,'2022-11-21 20:46:55','2022-11-21 20:46:55',NULL),(267,7968,267,238,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(268,7968,268,239,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(269,7968,269,240,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (270,7968,270,241,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(271,7968,271,242,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(272,7968,272,243,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(273,7968,273,244,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(274,7968,274,245,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(275,7968,275,246,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(276,7968,276,247,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(277,7968,277,248,NULL,'2022-11-23 11:32:43','2022-11-23 11:32:43',NULL),(278,7968,278,249,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(279,7968,279,250,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(280,7968,280,251,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(281,7968,281,252,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(282,7968,282,253,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(283,7968,283,254,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(284,7968,284,255,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(285,7968,285,256,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(286,7968,286,257,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(287,7968,287,258,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(288,7968,288,259,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(289,7968,289,260,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(290,7968,290,261,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(291,7968,291,262,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(292,7968,292,263,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(293,7968,293,264,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(294,7968,294,265,NULL,'2022-11-23 11:32:44','2022-11-23 11:32:44',NULL),(295,7968,295,266,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(296,7968,296,267,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(297,7968,297,268,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(298,7968,298,269,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(299,7968,299,270,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(300,7968,300,271,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(301,7968,301,272,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(302,7968,302,273,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(303,7968,303,274,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(304,7968,304,275,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(305,7968,305,276,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(306,7968,306,277,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(307,7968,307,278,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(308,7968,308,279,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(309,7968,309,280,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(310,7968,310,281,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(311,7968,311,282,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(312,7968,312,283,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(313,7968,313,284,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(314,7968,314,285,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(315,7968,315,286,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(316,7968,316,287,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(317,7968,317,288,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(318,7968,318,289,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(319,7968,319,290,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(320,7968,320,291,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(321,7968,321,292,NULL,'2022-11-23 11:32:45','2022-11-23 11:32:45',NULL),(322,7968,322,293,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(323,7968,323,294,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (324,7968,324,295,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(325,7968,325,296,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(326,7968,326,297,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(327,7968,327,298,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(328,7968,328,299,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(329,7968,329,300,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(330,7968,330,301,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(331,7968,331,302,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(332,7968,332,303,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(333,7968,333,304,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(334,7968,334,305,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(335,7968,335,306,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(336,7968,336,307,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(337,7968,337,308,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(338,7968,338,309,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(339,7968,339,310,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(340,7968,340,311,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(341,7968,341,312,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(342,7968,342,313,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(343,7968,343,314,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(344,7968,344,315,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(345,7968,345,316,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(346,7968,346,317,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(347,7968,347,318,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(348,7968,348,319,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(349,7968,349,320,NULL,'2022-11-23 11:32:46','2022-11-23 11:32:46',NULL),(350,7968,350,321,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(351,7968,351,322,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(352,7968,352,323,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(353,7968,353,324,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(354,7968,354,325,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(355,7968,355,326,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(356,7968,356,327,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(357,7968,357,328,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(358,7968,358,329,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(359,7968,359,330,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(360,7968,360,331,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(361,7968,361,332,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(362,7968,362,333,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(363,7968,363,334,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(364,7968,364,335,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(365,7968,365,336,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(366,7968,366,337,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(367,7968,367,338,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(368,7968,368,339,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(369,7968,369,340,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(370,7968,370,341,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(371,7968,371,342,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(372,7968,372,343,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(373,7968,373,344,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(374,7968,374,345,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(375,7968,375,346,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(376,7968,376,347,NULL,'2022-11-23 11:32:47','2022-11-23 11:32:47',NULL),(377,7968,377,348,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (378,7968,378,349,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(379,7968,379,350,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(380,7968,380,351,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(381,7968,381,352,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(382,7968,382,353,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(383,7968,383,354,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(384,7968,384,355,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(385,7968,385,356,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(386,7968,386,357,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(387,7968,387,358,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(388,7968,388,359,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(389,7968,389,360,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(390,7968,390,361,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(391,7968,391,362,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(392,7968,392,363,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(393,7968,393,364,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(394,7968,394,365,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(395,7968,395,366,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(396,7968,396,367,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(397,7968,397,368,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(398,7968,398,369,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(399,7968,399,370,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(400,7968,400,371,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(401,7968,401,372,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(402,7968,402,373,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(403,7968,403,374,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(404,7968,404,375,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(405,7968,405,376,NULL,'2022-11-23 11:32:48','2022-11-23 11:32:48',NULL),(406,7968,406,377,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(407,7968,407,378,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(408,7968,408,379,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(409,7968,409,380,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(410,7968,410,381,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(411,7968,411,382,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(412,7968,412,383,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(413,7968,413,384,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(414,7968,414,385,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(415,7968,415,386,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(416,7968,416,387,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(417,7968,417,388,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(418,7968,418,389,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(419,7968,419,390,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(420,7968,420,391,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(421,7968,421,392,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(422,7968,422,393,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(423,7968,423,394,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(424,7968,424,395,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(425,7968,425,396,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(426,7968,426,397,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(427,7968,427,398,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(428,7968,428,399,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(429,7968,429,400,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(430,7968,430,401,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL),(431,7968,431,402,NULL,'2022-11-23 11:32:49','2022-11-23 11:32:49',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (432,7968,432,403,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(433,7968,433,404,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(434,7968,434,405,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(435,7968,435,406,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(436,7968,436,407,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(437,7968,437,408,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(438,7968,438,409,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(439,7968,439,410,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(440,7968,440,411,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(441,7968,441,412,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(442,7968,442,413,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(443,7968,443,414,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(444,7968,444,415,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(445,7968,445,416,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(446,7968,446,417,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(447,7968,447,418,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(448,7968,448,419,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(449,7968,449,420,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(450,7968,450,421,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(451,7968,451,422,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(452,7968,452,423,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(453,7968,453,424,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(454,7968,454,425,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(455,7968,455,426,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(456,7968,456,427,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(457,7968,457,428,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(458,7968,458,429,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(459,7968,459,430,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(460,7968,460,431,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(461,7968,461,432,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(462,7968,462,433,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(463,7968,463,434,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(464,7968,464,435,NULL,'2022-11-23 11:32:50','2022-11-23 11:32:50',NULL),(465,7968,465,436,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(466,7968,466,437,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(467,7968,467,438,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(468,7968,468,439,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(469,7968,469,440,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(470,7968,470,441,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(471,7968,471,442,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(472,7968,472,443,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(473,7968,473,444,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(474,7968,474,445,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(475,7968,475,446,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(476,7968,476,447,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(477,7968,477,448,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(478,7968,478,449,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(479,7968,479,450,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(480,7968,480,451,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(481,7968,481,452,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(482,7968,482,453,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(483,7968,483,454,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(484,7968,484,455,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(485,7968,485,456,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (486,7968,486,457,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(487,7968,487,458,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(488,7968,488,459,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(489,7968,489,460,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(490,7968,490,461,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(491,7968,491,462,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(492,7968,492,463,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(493,7968,493,464,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(494,7968,494,465,NULL,'2022-11-23 11:32:51','2022-11-23 11:32:51',NULL),(495,7968,495,466,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(496,7968,496,467,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(497,7968,497,468,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(498,7968,498,469,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(499,7968,499,470,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(500,7968,500,471,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(501,7968,501,472,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(502,7968,502,473,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(503,7968,503,474,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(504,7968,504,475,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(505,7968,505,476,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(506,7968,506,477,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(507,7968,507,478,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(508,7968,508,479,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(509,7968,509,480,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(510,7968,510,481,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(511,7968,511,482,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(512,7968,512,483,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(513,7968,513,484,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(514,7968,514,485,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(515,7968,515,486,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(516,7968,516,487,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(517,7968,517,488,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(518,7968,518,489,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(519,7968,519,490,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(520,7968,520,491,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(521,7968,521,492,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(522,7968,522,493,NULL,'2022-11-23 11:32:52','2022-11-23 11:32:52',NULL),(523,7968,523,494,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(524,7968,524,495,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(525,7968,525,496,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(526,7968,526,497,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(527,7968,527,498,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(528,7968,528,499,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(529,7968,529,500,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(530,7968,530,501,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(531,7968,531,502,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(532,7968,532,503,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(533,7968,533,504,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(534,7968,534,505,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(535,7968,535,506,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(536,7968,536,507,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(537,7968,537,508,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(538,7968,538,509,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(539,7968,539,510,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (540,7968,540,511,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(541,7968,541,512,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(542,7968,542,513,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(543,7968,543,514,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(544,7968,544,515,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(545,7968,545,516,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(546,7968,546,517,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(547,7968,547,518,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(548,7968,548,519,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(549,7968,549,520,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(550,7968,550,521,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(551,7968,551,522,NULL,'2022-11-23 11:32:53','2022-11-23 11:32:53',NULL),(552,7968,552,523,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(553,7968,553,524,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(554,7968,554,525,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(555,7968,555,526,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(556,7968,556,527,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(557,7968,557,528,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(558,7968,558,529,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(559,7968,559,530,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(560,7968,560,531,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(561,7968,561,532,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(562,7968,562,533,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(563,7968,563,534,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(564,7968,564,535,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(565,7968,565,536,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(566,7968,566,537,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(567,7968,567,538,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(568,7968,568,539,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(569,7968,569,540,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(570,7968,570,541,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(571,7968,571,542,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(572,7968,572,543,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(573,7968,573,544,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(574,7968,574,545,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(575,7968,575,546,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(576,7968,576,547,NULL,'2022-11-23 11:33:36','2022-11-23 11:33:36',NULL),(577,7968,577,548,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(578,7968,578,549,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(579,7968,579,550,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(580,7968,580,551,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(581,7968,581,552,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(582,7968,582,553,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(583,7968,583,554,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(584,7968,584,555,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(585,7968,585,556,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(586,7968,586,557,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(587,7968,587,558,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(588,7968,588,559,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(589,7968,589,560,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(590,7968,590,561,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(591,7968,591,562,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(592,7968,592,563,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(593,7968,593,564,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (594,7968,594,565,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(595,7968,595,566,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(596,7968,596,567,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(597,7968,597,568,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(598,7968,598,569,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(599,7968,599,570,NULL,'2022-11-23 11:33:37','2022-11-23 11:33:37',NULL),(600,7968,600,571,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(601,7968,601,572,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(602,7968,602,573,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(603,7968,603,574,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(604,7968,604,575,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(605,7968,605,576,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(606,7968,606,577,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(607,7968,607,578,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(608,7968,608,579,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(609,7968,609,580,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(610,7968,610,581,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(611,7968,611,582,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(612,7968,612,583,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(613,7968,613,584,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(614,7968,614,585,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(615,7968,615,586,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(616,7968,616,587,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(617,7968,617,588,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(618,7968,618,589,NULL,'2022-11-23 11:33:38','2022-11-23 11:33:38',NULL),(619,7968,619,590,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(620,7968,620,591,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(621,7968,621,592,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(622,7968,622,593,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(623,7968,623,594,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(624,7968,624,595,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(625,7968,625,596,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(626,7968,626,597,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(627,7968,627,598,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(628,7968,628,599,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(629,7968,629,600,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(630,7968,630,601,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(631,7968,631,602,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(632,7968,632,603,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(633,7968,633,604,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(634,7968,634,605,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(635,7968,635,606,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(636,7968,636,607,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(637,7968,637,608,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(638,7968,638,609,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(639,7968,639,610,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(640,7968,640,611,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(641,7968,641,612,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(642,7968,642,613,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(643,7968,643,614,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(644,7968,644,615,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(645,7968,645,616,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(646,7968,646,617,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL),(647,7968,647,618,NULL,'2022-11-23 11:33:39','2022-11-23 11:33:39',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (648,7968,648,619,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(649,7968,649,620,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(650,7968,650,621,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(651,7968,651,622,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(652,7968,652,623,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(653,7968,653,624,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(654,7968,654,625,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(655,7968,655,626,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(656,7968,656,627,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(657,7968,657,628,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(658,7968,658,629,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(659,7968,659,630,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(660,7968,660,631,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(661,7968,661,632,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(662,7968,662,633,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(663,7968,663,634,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(664,7968,664,635,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(665,7968,665,636,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(666,7968,666,637,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(667,7968,667,638,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(668,7968,668,639,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(669,7968,669,640,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(670,7968,670,641,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(671,7968,671,642,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(672,7968,672,643,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(673,7968,673,644,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(674,7968,674,645,NULL,'2022-11-23 11:33:40','2022-11-23 11:33:40',NULL),(675,7968,675,646,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(676,7968,676,647,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(677,7968,677,648,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(678,7968,678,649,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(679,7968,679,650,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(680,7968,680,651,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(681,7968,681,652,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(682,7968,682,653,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(683,7968,683,654,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(684,7968,684,655,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(685,7968,685,656,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(686,7968,686,657,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(687,7968,687,658,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(688,7968,688,659,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(689,7968,689,660,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(690,7968,690,661,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(691,7968,691,662,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(692,7968,692,663,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(693,7968,693,664,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(694,7968,694,665,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(695,7968,695,666,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(696,7968,696,667,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(697,7968,697,668,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(698,7968,698,669,NULL,'2022-11-23 11:33:41','2022-11-23 11:33:41',NULL),(699,7968,699,670,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(700,7968,700,671,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(701,7968,701,672,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (702,7968,702,673,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(703,7968,703,674,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(704,7968,704,675,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(705,7968,705,676,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(706,7968,706,677,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(707,7968,707,678,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(708,7968,708,679,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(709,7968,709,680,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(710,7968,710,681,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(711,7968,711,682,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(712,7968,712,683,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(713,7968,713,684,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(714,7968,714,685,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(715,7968,715,686,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(716,7968,716,687,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(717,7968,717,688,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(718,7968,718,689,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(719,7968,719,690,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(720,7968,720,691,NULL,'2022-11-23 11:33:42','2022-11-23 11:33:42',NULL),(721,7968,721,692,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(722,7968,722,693,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(723,7968,723,694,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(724,7968,724,695,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(725,7968,725,696,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(726,7968,726,697,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(727,7968,727,698,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(728,7968,728,699,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(729,7968,729,700,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(730,7968,730,701,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(731,7968,731,702,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(732,7968,732,703,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(733,7968,733,704,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(734,7968,734,705,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(735,7968,735,706,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(736,7968,736,707,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(737,7968,737,708,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(738,7968,738,709,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(739,7968,739,710,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(740,7968,740,711,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(741,7968,741,712,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(742,7968,742,713,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(743,7968,743,714,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(744,7968,744,715,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(745,7968,745,716,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(746,7968,746,717,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(747,7968,747,718,NULL,'2022-11-23 11:33:43','2022-11-23 11:33:43',NULL),(748,7968,748,719,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(749,7968,749,720,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(750,7968,750,721,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(751,7968,751,722,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(752,7968,752,723,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(753,7968,753,724,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(754,7968,754,725,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(755,7968,755,726,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (756,7968,756,727,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(757,7968,757,728,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(758,7968,758,729,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(759,7968,759,730,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(760,7968,760,731,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(761,7968,761,732,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(762,7968,762,733,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(763,7968,763,734,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(764,7968,764,735,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(765,7968,765,736,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(766,7968,766,737,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(767,7968,767,738,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(768,7968,768,739,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(769,7968,769,740,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(770,7968,770,741,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(771,7968,771,742,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(772,7968,772,743,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(773,7968,773,744,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(774,7968,774,745,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(775,7968,775,746,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(776,7968,776,747,NULL,'2022-11-23 11:33:44','2022-11-23 11:33:44',NULL),(777,7968,777,748,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(778,7968,778,749,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(779,7968,779,750,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(780,7968,780,751,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(781,7968,781,752,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(782,7968,782,753,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(783,7968,783,754,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(784,7968,784,755,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(785,7968,785,756,NULL,'2022-11-23 11:33:45','2022-11-23 11:33:45',NULL),(786,7968,786,757,NULL,'