-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db27-32956506-3
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-09-02 07:49:05','Actividad Generica 1','000001',NULL),(2,NULL,'2022-09-02 07:49:05','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL),('2023-1','2023-01',2023,1,'2023-01-01','2023-01-31',1202.9790,NULL,NULL,NULL),('2023-2','2023-02',2023,2,'2023-02-01','2023-02-28',1282.7091,NULL,NULL,NULL),('2023-3','2023-03',2023,3,'2023-03-01','2023-03-31',1381.1601,NULL,NULL,NULL),('2023-4','2023-04',2023,4,'2023-04-01','2023-04-30',1497.2147,NULL,NULL,NULL),('2023-5','2023-05',2023,5,'2023-05-01','2023-05-31',1613.5895,NULL,NULL,NULL),('2023-6','2023-06',2023,6,'2023-06-01','2023-06-30',1709.6115,NULL,NULL,NULL),('2023-7','2023-07',2023,7,'2023-07-01','2023-07-31',1818.0838,NULL,NULL,NULL),('2023-8','2023-08',2023,8,'2023-08-01','2023-08-31',2044.2832,NULL,NULL,NULL),('2023-9','2023-09',2023,9,'2023-09-01','2023-09-30',2304.9242,NULL,NULL,NULL),('2023-10','2023-10',2023,10,'2023-10-01','2023-10-31',2496.2730,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_recibidas`
--

DROP TABLE IF EXISTS `api_recibidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_recibidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` json NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_recibidas_person_id_foreign` (`person_id`),
  CONSTRAINT `api_recibidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_recibidas`
--

LOCK TABLES `api_recibidas` WRITE;
/*!40000 ALTER TABLE `api_recibidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_recibidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
INSERT INTO `back_up_claves_details` VALUES (1,NULL,'SOsa656539','Fernando D. Sosa',1,40728,'2022-09-07'),(2,NULL,'SOsa656539','Fernando D. Sosa',1,40728,'2022-09-09'),(3,NULL,'SOsa656539','Fernando D. Sosa',1,40728,'2022-09-09'),(4,NULL,'SOsa656539','Fernando D. Sosa',1,40728,'2022-09-09'),(5,'CLAVE AFIP','22Pablo898','Agustina',1,41245,'2022-09-09'),(6,'CLAVE AFIP','22Pablo898','Agustina',1,41245,'2022-09-09'),(7,'CLAVE AFIP','22Pablo898','Agustina',1,41245,'2022-09-14'),(8,NULL,'Branca2022',NULL,1,41298,'2022-09-15'),(9,NULL,'Branca2022',NULL,1,41298,'2022-09-15'),(10,NULL,'Branca2022',NULL,1,41298,'2022-10-14'),(11,NULL,'Felipe2022',NULL,1,41323,'2022-10-14'),(12,NULL,'Branca2022',NULL,1,41298,'2022-10-16'),(13,NULL,'Branca2022',NULL,1,41298,'2022-10-16'),(14,NULL,'Feli311287',NULL,1,41322,'2022-10-18'),(15,NULL,'SOsa656539','Fernando D. Sosa',1,40728,'2022-10-29'),(16,NULL,'SOsa656539','Fernando D. Sosa',1,40728,'2022-10-29'),(17,NULL,'SOsa656539','Fernando D. Sosa',1,40728,'2022-10-29'),(18,NULL,'SOsa656539','Fernando D. Sosa',1,40728,'2022-10-29'),(19,NULL,'SOsa656539','Fernando D. Sosa',1,40728,'2022-11-15'),(20,NULL,'SOsa656539','Fernando D. Sosa',1,40728,'2022-11-15'),(21,NULL,'SOsa656539','Fernando D. Sosa',1,40728,'2022-11-18'),(22,NULL,'SOsa656539','Fernando D. Sosa',1,40728,'2022-11-18'),(23,NULL,'SOsa656539','Fernando D. Sosa',1,40728,'2022-11-18'),(24,'CLAVE AFIP','22Pablo898','Agustina',1,41245,'2023-03-30');
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'fsosa@basyd.com.ar','2325651110','Fernando D. Sosa',1,40728,'2022-09-07'),(2,'fsosa@basyd.com.ar','2325651110','Fernando D. Sosa',1,40728,'2022-09-09'),(3,'fsosa@basyd.com.ar','2325651110','Fernando D. Sosa',1,40728,'2022-09-09'),(4,'fsosa@basyd.com.ar','2325651110','Fernando D. Sosa',1,40728,'2022-09-09'),(5,'aguscllc@gmail.com','1137554013','Agustina',1,41245,'2022-09-09'),(6,'aguscllc@gmail.com','1137554013','Agustina',1,41245,'2022-09-09'),(7,'aguscllc@gmail.com','1137554013','Agustina',1,41245,'2022-09-14'),(8,'natalia-pz@hotmail.com',NULL,'',1,41322,'2022-10-18'),(9,'fsosa@basyd.com.ar','2325651110','Fernando D. Sosa',1,40728,'2022-10-29'),(10,'fsosa@basyd.com.ar','2325651110','Fernando D. Sosa',1,40728,'2022-10-29'),(11,'fsosa@basyd.com.ar','2325651110','Fernando D. Sosa',1,40728,'2022-10-29'),(12,'fsosa@basyd.com.ar','2325651110','Fernando D. Sosa',1,40728,'2022-10-29'),(13,'fsosa@basyd.com.ar','2325651110','Fernando D. Sosa',1,40728,'2022-11-15'),(14,'fsosa@basyd.com.ar','2325651110','Fernando D. Sosa',1,40728,'2022-11-15'),(15,'fsosa@basyd.com.ar','2325651110','Fernando D. Sosa',1,40728,'2022-11-18'),(16,'fsosa@basyd.com.ar','2325651110','Fernando D. Sosa',1,40728,'2022-11-18'),(17,'fsosa@basyd.com.ar','2325651110','Fernando D. Sosa',1,40728,'2022-11-18'),(18,'aguscllc@gmail.com','1137554013','Agustina',1,41245,'2023-03-30');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(7,4,5,410,NULL,0.00,'2022-10-27 01:23:15','2022-10-27 01:23:15',NULL),(8,4,5,57,NULL,0.00,'2022-10-27 01:23:15','2022-10-27 01:23:15',NULL),(9,5,10,326,NULL,0.00,'2022-10-28 11:54:18','2022-10-28 11:54:18',NULL),(10,5,10,410,NULL,0.00,'2022-10-28 11:54:18','2022-10-28 11:54:18',NULL),(16,8,10,74,NULL,0.00,'2022-10-28 12:09:06','2022-10-28 12:09:06',NULL),(17,8,10,467,NULL,0.00,'2022-10-28 12:09:06','2022-10-28 12:09:06',NULL),(18,8,10,410,NULL,0.00,'2022-10-28 12:09:06','2022-10-28 12:09:06',NULL),(19,9,21,484,NULL,0.00,'2022-10-31 18:44:01','2022-10-31 18:44:01',NULL),(20,9,21,410,NULL,0.00,'2022-10-31 18:44:01','2022-10-31 18:44:01',NULL),(21,10,21,484,NULL,0.00,'2022-10-31 18:44:28','2022-10-31 18:44:28',NULL),(22,10,21,410,NULL,0.00,'2022-10-31 18:44:28','2022-10-31 18:44:28',NULL),(25,12,2,410,NULL,0.00,'2022-11-06 20:03:05','2022-11-06 20:03:05',NULL),(26,12,2,454,NULL,0.00,'2022-11-06 20:03:05','2022-11-06 20:03:05',NULL),(27,12,2,102,NULL,0.00,'2022-11-06 20:03:05','2022-11-06 20:03:05',NULL),(28,13,2,410,NULL,0.00,'2022-11-06 20:04:33','2022-11-06 20:04:33',NULL),(29,13,2,454,NULL,0.00,'2022-11-06 20:04:33','2022-11-06 20:04:33',NULL),(30,14,18,437,NULL,0.00,'2022-11-06 22:18:30','2022-11-06 22:18:30',NULL),(31,14,18,217,NULL,0.00,'2022-11-06 22:18:30','2022-11-06 22:18:30',NULL),(32,15,4,132,NULL,0.00,'2022-11-16 12:09:56','2022-11-16 12:09:56',NULL),(33,15,4,363,NULL,0.00,'2022-11-16 12:09:56','2022-11-16 12:09:56',NULL),(34,15,4,391,NULL,0.00,'2022-11-16 12:09:56','2022-11-16 12:09:56',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,7768,5,2,'Banco ICBC',0.00,'2022-10-27 01:22:00','2022-10-27 01:22:37','2022-10-27 01:22:37'),(4,7768,5,2,'Banco ICBC',0.00,'2022-10-27 01:23:15','2022-10-27 01:23:15',NULL),(5,7768,10,2,'PAGO IIBB CM',0.00,'2022-10-28 11:54:18','2022-10-28 11:54:18',NULL),(6,7768,10,2,'PAGO IIBB CM',0.00,'2022-10-28 11:54:44','2022-10-28 11:54:49','2022-10-28 11:54:49'),(7,7768,10,2,'PAGO IVA',0.00,'2022-10-28 12:07:18','2022-10-28 12:08:33','2022-10-28 12:08:33'),(8,7768,10,2,'PAGO DDJJ IVA - INTERESES',0.00,'2022-10-28 12:09:06','2022-10-28 12:09:06',NULL),(9,7768,21,2,'Cta Particular del Socio',0.00,'2022-10-31 18:44:01','2022-10-31 18:44:01',NULL),(10,7768,21,2,'Cta Particular del Socio',0.00,'2022-10-31 18:44:28','2022-10-31 18:44:28',NULL),(11,7768,2,2,'INVERSIONES',0.00,'2022-11-06 20:01:34','2022-11-06 20:03:43','2022-11-06 20:03:43'),(12,7768,2,2,'INVERSIONES',0.00,'2022-11-06 20:03:05','2022-11-06 20:03:05',NULL),(13,7768,2,2,'INVERSIONES FCI',0.00,'2022-11-06 20:04:33','2022-11-06 20:04:33',NULL),(14,7768,18,2,'RECLA IMP LEY 25413',0.00,'2022-11-06 22:18:30','2022-11-06 22:18:30',NULL),(15,7768,4,2,'AMORTIZACIONES',0.00,'2022-11-16 12:09:56','2022-11-16 12:09:56',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `origin_id` bigint(20) unsigned DEFAULT NULL,
  `origin_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7194 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (32,7768,40728,13779,2,32,'App\\Models\\Receipt',32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',85716.63,NULL,NULL,1,'2022-09-06 00:04:26','2022-09-06 00:04:26',NULL),(33,7768,40728,13779,2,33,'App\\Models\\Receipt',33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',417347.98,NULL,NULL,1,'2022-09-06 00:04:26','2022-09-06 00:04:26',NULL),(34,7768,40728,13779,2,34,'App\\Models\\Receipt',34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',13310.00,NULL,NULL,1,'2022-09-06 00:04:26','2022-09-06 00:04:26',NULL),(35,7768,40728,13779,2,35,'App\\Models\\Receipt',35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',428376.23,NULL,NULL,1,'2022-09-06 00:04:26','2022-09-06 00:04:26',NULL),(36,7768,40728,13779,2,36,'App\\Models\\Receipt',36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',166378.61,NULL,NULL,1,'2022-09-06 00:04:26','2022-09-06 00:04:26',NULL),(37,7768,40728,13779,2,37,'App\\Models\\Receipt',37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',19590.15,NULL,NULL,1,'2022-09-06 00:04:27','2022-09-06 00:04:27',NULL),(38,7768,40728,13780,2,38,'App\\Models\\Receipt',38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',126270.48,NULL,NULL,1,'2022-09-06 11:55:17','2022-09-06 11:55:17',NULL),(39,7768,40728,13780,2,39,'App\\Models\\Receipt',39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',330054.77,NULL,NULL,1,'2022-09-06 11:55:17','2022-09-06 11:55:17',NULL),(40,7768,40728,13780,2,40,'App\\Models\\Receipt',40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',65100.78,NULL,NULL,1,'2022-09-06 11:55:17','2022-09-06 11:55:17',NULL),(41,7768,40728,13780,2,41,'App\\Models\\Receipt',41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',93945.85,NULL,NULL,1,'2022-09-06 11:55:17','2022-09-06 11:55:17',NULL),(42,7768,40728,13780,2,42,'App\\Models\\Receipt',42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',476537.81,NULL,NULL,1,'2022-09-06 11:55:17','2022-09-06 11:55:17',NULL),(43,7768,40728,13780,2,43,'App\\Models\\Receipt',43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',297892.32,NULL,NULL,1,'2022-09-06 11:55:17','2022-09-06 11:55:17',NULL),(44,7768,40728,13780,3,44,'App\\Models\\Receipt',44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',4249.46,NULL,NULL,1,'2022-09-06 11:55:33','2022-09-06 12:04:28','2022-09-06 12:04:28'),(45,7768,40728,13780,3,45,'App\\Models\\Receipt',45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',5687.00,NULL,NULL,1,'2022-09-06 11:55:33','2022-09-06 12:04:28','2022-09-06 12:04:28'),(46,7768,40728,13780,3,46,'App\\Models\\Receipt',46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',1200.01,NULL,NULL,1,'2022-09-06 11:55:33','2022-09-06 12:04:28','2022-09-06 12:04:28'),(47,7768,40728,13780,3,47,'App\\Models\\Receipt',47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',4428.21,NULL,NULL,1,'2022-09-06 11:55:33','2022-09-06 12:04:28','2022-09-06 12:04:28'),(48,7768,40728,13780,3,48,'App\\Models\\Receipt',48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',15000.00,NULL,NULL,1,'2022-09-06 11:55:33','2022-09-06 12:04:28','2022-09-06 12:04:28'),(49,7768,40728,13780,3,49,'App\\Models\\Receipt',49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',817.69,NULL,NULL,1,'2022-09-06 11:55:33','2022-09-06 12:04:28','2022-09-06 12:04:28'),(50,7768,40728,13780,3,50,'App\\Models\\Receipt',50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',5525.02,NULL,NULL,1,'2022-09-06 11:55:33','2022-09-06 12:04:28','2022-09-06 12:04:28'),(51,7768,40728,13780,3,51,'App\\Models\\Receipt',51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',807.03,NULL,NULL,1,'2022-09-06 11:55:33','2022-09-06 12:04:28','2022-09-06 12:04:28');
INSERT INTO `balance_libro` VALUES (52,7768,40728,13780,3,52,'App\\Models\\Receipt',52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',36300.00,NULL,NULL,1,'2022-09-06 11:55:33','2022-09-06 12:04:28','2022-09-06 12:04:28'),(53,7768,40728,13780,3,53,'App\\Models\\Receipt',53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',475.00,NULL,NULL,1,'2022-09-06 11:55:33','2022-09-06 12:04:28','2022-09-06 12:04:28'),(54,7768,40728,13780,3,54,'App\\Models\\Receipt',54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',31627.89,NULL,NULL,1,'2022-09-06 11:55:34','2022-09-06 12:04:28','2022-09-06 12:04:28'),(55,7768,40728,13780,3,55,'App\\Models\\Receipt',55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-13','2022-08-13',4500.00,NULL,NULL,1,'2022-09-06 11:55:34','2022-09-06 12:04:28','2022-09-06 12:04:28'),(56,7768,40728,13780,3,56,'App\\Models\\Receipt',56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',1200.00,NULL,NULL,1,'2022-09-06 11:55:34','2022-09-06 12:04:28','2022-09-06 12:04:28'),(57,7768,40728,13780,3,57,'App\\Models\\Receipt',57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',592.04,NULL,NULL,1,'2022-09-06 11:55:34','2022-09-06 12:04:28','2022-09-06 12:04:28'),(58,7768,40728,13780,3,58,'App\\Models\\Receipt',58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',12308.34,NULL,NULL,1,'2022-09-06 11:55:34','2022-09-06 12:04:28','2022-09-06 12:04:28'),(59,7768,40728,13780,3,59,'App\\Models\\Receipt',59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',6010.00,NULL,NULL,1,'2022-09-06 11:55:35','2022-09-06 12:04:28','2022-09-06 12:04:28'),(60,7768,40728,13780,3,60,'App\\Models\\Receipt',60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',1830.00,NULL,NULL,1,'2022-09-06 11:55:35','2022-09-06 12:04:28','2022-09-06 12:04:28'),(61,7768,40728,13780,3,61,'App\\Models\\Receipt',61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',1802.22,NULL,NULL,1,'2022-09-06 11:55:35','2022-09-06 12:04:28','2022-09-06 12:04:28'),(62,7768,40728,13780,3,62,'App\\Models\\Receipt',62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',9500.00,NULL,NULL,1,'2022-09-06 11:55:35','2022-09-06 12:04:28','2022-09-06 12:04:28'),(63,7768,40728,13780,3,63,'App\\Models\\Receipt',63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',17000.00,NULL,NULL,1,'2022-09-06 11:55:35','2022-09-06 12:04:28','2022-09-06 12:04:28'),(64,7768,40728,13780,3,64,'App\\Models\\Receipt',64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',17617.73,NULL,NULL,1,'2022-09-06 11:55:35','2022-09-06 12:04:28','2022-09-06 12:04:28'),(65,7768,40728,13780,3,65,'App\\Models\\Receipt',65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',565.00,NULL,NULL,1,'2022-09-06 11:55:35','2022-09-06 12:04:28','2022-09-06 12:04:28'),(66,7768,40728,13780,3,66,'App\\Models\\Receipt',66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',1352417.21,NULL,NULL,1,'2022-09-06 11:55:36','2022-09-06 12:04:28','2022-09-06 12:04:28'),(67,7768,40728,13780,3,67,'App\\Models\\Receipt',67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',1468.24,NULL,NULL,1,'2022-09-06 11:55:36','2022-09-06 12:04:28','2022-09-06 12:04:28'),(68,7768,40728,13780,3,68,'App\\Models\\Receipt',68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',3893.08,NULL,NULL,1,'2022-09-06 11:55:36','2022-09-06 12:04:28','2022-09-06 12:04:28'),(69,7768,40728,13780,3,69,'App\\Models\\Receipt',69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',42111.91,NULL,NULL,1,'2022-09-06 11:55:36','2022-09-06 12:04:28','2022-09-06 12:04:28'),(70,7768,40728,13780,3,70,'App\\Models\\Receipt',70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',3305.79,NULL,NULL,1,'2022-09-06 11:55:36','2022-09-06 12:04:28','2022-09-06 12:04:28');
INSERT INTO `balance_libro` VALUES (71,7768,40728,13780,3,71,'App\\Models\\Receipt',71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',3134.07,NULL,NULL,1,'2022-09-06 11:55:36','2022-09-06 12:04:28','2022-09-06 12:04:28'),(72,7768,40728,13780,3,72,'App\\Models\\Receipt',72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',39924.34,NULL,NULL,1,'2022-09-06 11:55:36','2022-09-06 12:04:28','2022-09-06 12:04:28'),(73,7768,40728,13780,3,73,'App\\Models\\Receipt',73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',2322.49,NULL,NULL,1,'2022-09-06 11:55:36','2022-09-06 12:04:28','2022-09-06 12:04:28'),(74,7768,40728,13780,3,74,'App\\Models\\Receipt',74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',5687.00,NULL,NULL,1,'2022-09-06 12:05:10','2022-09-06 12:05:10',NULL),(75,7768,40728,13780,3,75,'App\\Models\\Receipt',75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',4249.46,NULL,NULL,1,'2022-09-06 12:05:10','2022-09-06 12:05:10',NULL),(76,7768,40728,13780,3,76,'App\\Models\\Receipt',76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',1200.05,NULL,NULL,1,'2022-09-06 12:05:10','2022-09-06 12:05:10',NULL),(77,7768,40728,13780,3,77,'App\\Models\\Receipt',77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',4428.21,NULL,NULL,1,'2022-09-06 12:05:10','2022-09-06 12:05:10',NULL),(78,7768,40728,13780,3,78,'App\\Models\\Receipt',78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',15000.00,NULL,NULL,1,'2022-09-06 12:05:10','2022-11-08 15:32:45','2022-11-08 15:32:45'),(79,7768,40728,13780,3,79,'App\\Models\\Receipt',79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',5525.02,NULL,NULL,1,'2022-09-06 12:05:10','2022-10-31 18:08:05','2022-10-31 18:08:05'),(80,7768,40728,13780,3,80,'App\\Models\\Receipt',80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',817.69,NULL,NULL,1,'2022-09-06 12:05:10','2022-09-06 12:05:10',NULL),(81,7768,40728,13780,3,81,'App\\Models\\Receipt',81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',36300.00,NULL,NULL,1,'2022-09-06 12:05:10','2022-09-06 12:05:10',NULL),(82,7768,40728,13780,3,82,'App\\Models\\Receipt',82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',807.03,NULL,NULL,1,'2022-09-06 12:05:10','2022-09-06 12:05:10',NULL),(83,7768,40728,13780,3,83,'App\\Models\\Receipt',83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',475.00,NULL,NULL,1,'2022-09-06 12:05:10','2022-09-06 12:05:10',NULL),(84,7768,40728,13780,3,84,'App\\Models\\Receipt',84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',31627.89,NULL,NULL,1,'2022-09-06 12:05:10','2022-10-31 18:05:33','2022-10-31 18:05:33'),(85,7768,40728,13780,3,85,'App\\Models\\Receipt',85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',4957.38,NULL,NULL,1,'2022-09-06 12:05:11','2022-10-31 18:08:33','2022-10-31 18:08:33'),(86,7768,40728,13780,3,86,'App\\Models\\Receipt',86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-13','2022-08-13',4500.00,NULL,NULL,1,'2022-09-06 12:05:11','2022-09-06 12:05:11',NULL),(87,7768,40728,13780,3,87,'App\\Models\\Receipt',87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',1200.02,NULL,NULL,1,'2022-09-06 12:05:11','2022-09-06 12:05:11',NULL),(88,7768,40728,13780,3,88,'App\\Models\\Receipt',88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',592.04,NULL,NULL,1,'2022-09-06 12:05:11','2022-09-06 12:05:11',NULL),(89,7768,40728,13780,3,89,'App\\Models\\Receipt',89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',12308.34,NULL,NULL,1,'2022-09-06 12:05:11','2022-09-06 12:05:11',NULL),(90,7768,40728,13780,3,90,'App\\Models\\Receipt',90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',6010.00,NULL,NULL,1,'2022-09-06 12:05:11','2022-09-06 12:05:11',NULL),(91,7768,40728,13780,3,91,'App\\Models\\Receipt',91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',1830.00,NULL,NULL,1,'2022-09-06 12:05:11','2022-09-06 12:05:11',NULL);
INSERT INTO `balance_libro` VALUES (92,7768,40728,13780,3,92,'App\\Models\\Receipt',92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',1802.22,NULL,NULL,1,'2022-09-06 12:05:11','2022-09-06 12:05:11',NULL),(93,7768,40728,13780,3,93,'App\\Models\\Receipt',93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',9500.00,NULL,NULL,1,'2022-09-06 12:05:11','2022-09-06 12:05:11',NULL),(94,7768,40728,13780,3,94,'App\\Models\\Receipt',94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',17000.00,NULL,NULL,1,'2022-09-06 12:05:11','2022-09-06 12:05:11',NULL),(95,7768,40728,13780,3,95,'App\\Models\\Receipt',95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',17617.73,NULL,NULL,1,'2022-09-06 12:05:11','2022-09-06 12:05:11',NULL),(96,7768,40728,13780,3,96,'App\\Models\\Receipt',96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',565.02,NULL,NULL,1,'2022-09-06 12:05:11','2022-09-06 12:05:11',NULL),(97,7768,40728,13780,3,97,'App\\Models\\Receipt',97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',1352417.21,NULL,NULL,1,'2022-09-06 12:05:11','2022-09-06 12:05:11',NULL),(98,7768,40728,13780,3,98,'App\\Models\\Receipt',98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',3893.08,NULL,NULL,1,'2022-09-06 12:05:11','2022-09-06 12:05:11',NULL),(99,7768,40728,13780,3,99,'App\\Models\\Receipt',99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',1468.24,NULL,NULL,1,'2022-09-06 12:05:11','2022-09-06 12:05:11',NULL),(100,7768,40728,13780,3,100,'App\\Models\\Receipt',100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',42111.91,NULL,NULL,1,'2022-09-06 12:05:11','2022-09-06 12:05:11',NULL),(101,7768,40728,13780,3,101,'App\\Models\\Receipt',101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',3305.79,NULL,NULL,1,'2022-09-06 12:05:12','2022-09-06 12:05:12',NULL),(102,7768,40728,13780,3,102,'App\\Models\\Receipt',102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',39924.34,NULL,NULL,1,'2022-09-06 12:05:12','2022-09-06 12:05:12',NULL),(103,7768,40728,13780,3,103,'App\\Models\\Receipt',103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',2322.49,NULL,NULL,1,'2022-09-06 12:05:12','2022-09-06 12:05:12',NULL),(104,7768,40728,13780,3,104,'App\\Models\\Receipt',104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',3134.07,NULL,NULL,1,'2022-09-06 12:05:12','2022-09-06 12:05:12',NULL),(105,7768,40728,13759,3,105,'App\\Models\\Receipt',105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',301264.73,NULL,NULL,1,'2022-09-06 12:31:52','2022-09-08 23:11:54','2022-09-08 23:11:54'),(106,7768,40728,13759,3,106,'App\\Models\\Receipt',106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',0.00,NULL,NULL,1,'2022-09-06 12:31:52','2022-09-06 12:31:52',NULL),(107,7768,40728,13759,3,107,'App\\Models\\Receipt',107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',64575.00,NULL,NULL,1,'2022-09-06 12:31:52','2022-09-06 12:31:52',NULL),(108,7768,40728,13759,3,108,'App\\Models\\Receipt',108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',50250.03,NULL,NULL,1,'2022-09-06 12:31:52','2022-09-06 12:31:52',NULL),(109,7768,40728,13759,3,109,'App\\Models\\Receipt',109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',27499.00,NULL,NULL,1,'2022-09-06 12:31:53','2022-09-06 12:31:53',NULL),(110,7768,40728,13759,3,110,'App\\Models\\Receipt',110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',11240.90,NULL,NULL,1,'2022-09-06 12:31:53','2022-09-06 12:31:53',NULL),(111,7768,40728,13759,3,111,'App\\Models\\Receipt',111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',23068.01,NULL,NULL,1,'2022-09-06 12:31:53','2022-09-06 12:31:53',NULL),(112,7768,40728,13759,3,112,'App\\Models\\Receipt',112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',2384.90,NULL,NULL,1,'2022-09-06 12:31:53','2022-09-06 12:31:53',NULL);
INSERT INTO `balance_libro` VALUES (113,7768,40728,13759,3,113,'App\\Models\\Receipt',113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',8381.00,NULL,NULL,1,'2022-09-06 12:31:53','2022-09-06 12:31:53',NULL),(114,7768,40728,13759,3,114,'App\\Models\\Receipt',114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',24310.00,NULL,NULL,1,'2022-09-06 12:31:53','2022-09-06 12:31:53',NULL),(115,7768,40728,13759,3,115,'App\\Models\\Receipt',115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',4100.11,NULL,NULL,1,'2022-09-06 12:31:53','2022-11-15 12:25:50','2022-11-15 12:25:50'),(116,7768,40728,13759,3,116,'App\\Models\\Receipt',116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',5677.40,NULL,NULL,1,'2022-09-06 12:31:53','2022-09-06 12:31:53',NULL),(117,7768,40728,13759,2,117,'App\\Models\\Receipt',117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',525261.00,NULL,NULL,1,'2022-09-06 12:32:17','2022-09-06 12:32:17',NULL),(118,7768,40728,13759,2,118,'App\\Models\\Receipt',118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',379788.75,NULL,NULL,1,'2022-09-06 12:32:17','2022-09-06 12:32:17',NULL),(119,7768,40728,13760,2,119,'App\\Models\\Receipt',119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',114950.00,NULL,NULL,1,'2022-09-06 12:39:15','2022-09-06 12:39:15',NULL),(120,7768,40728,13760,2,120,'App\\Models\\Receipt',120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',886173.75,NULL,NULL,1,'2022-09-06 12:39:15','2022-09-06 12:39:15',NULL),(138,7768,40728,13761,2,138,'App\\Models\\Receipt',138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',655578.00,NULL,NULL,1,'2022-09-06 12:43:03','2022-09-06 12:43:03',NULL),(139,7768,40728,13761,2,139,'App\\Models\\Receipt',139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',96094.22,NULL,NULL,1,'2022-09-06 12:43:03','2022-09-06 12:43:03',NULL),(198,7768,40728,13762,2,198,'App\\Models\\Receipt',198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',655578.00,NULL,NULL,1,'2022-09-06 12:54:26','2022-09-06 12:54:26',NULL),(199,7768,40728,13762,2,199,'App\\Models\\Receipt',199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',132923.34,NULL,NULL,1,'2022-09-06 12:54:26','2022-09-06 12:54:26',NULL),(208,7768,40728,13778,3,208,'App\\Models\\Receipt',208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',5687.00,NULL,NULL,1,'2022-09-06 20:18:01','2022-09-06 20:58:31','2022-09-06 20:58:31'),(209,7768,40728,13778,3,209,'App\\Models\\Receipt',209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',3329.18,NULL,NULL,1,'2022-09-06 20:18:01','2022-09-06 20:58:31','2022-09-06 20:58:31'),(210,7768,40728,13778,3,210,'App\\Models\\Receipt',210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',31361.28,NULL,NULL,1,'2022-09-06 20:18:01','2022-09-06 20:58:31','2022-09-06 20:58:31'),(211,7768,40728,13778,3,211,'App\\Models\\Receipt',211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',4879.30,NULL,NULL,1,'2022-09-06 20:18:01','2022-09-06 20:58:31','2022-09-06 20:58:31'),(212,7768,40728,13778,3,212,'App\\Models\\Receipt',212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',5113.41,NULL,NULL,1,'2022-09-06 20:18:01','2022-09-06 20:58:31','2022-09-06 20:58:31'),(213,7768,40728,13778,3,213,'App\\Models\\Receipt',213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',11495.00,NULL,NULL,1,'2022-09-06 20:18:02','2022-09-06 20:58:31','2022-09-06 20:58:31'),(214,7768,40728,13778,3,214,'App\\Models\\Receipt',214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',37932.21,NULL,NULL,1,'2022-09-06 20:18:02','2022-09-06 20:58:31','2022-09-06 20:58:31'),(215,7768,40728,13778,3,215,'App\\Models\\Receipt',215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',7345.81,NULL,NULL,1,'2022-09-06 20:18:02','2022-09-06 20:58:31','2022-09-06 20:58:31');
INSERT INTO `balance_libro` VALUES (216,7768,40728,13778,3,216,'App\\Models\\Receipt',216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',3000.02,NULL,NULL,1,'2022-09-06 20:18:02','2022-09-06 20:58:31','2022-09-06 20:58:31'),(217,7768,40728,13778,3,217,'App\\Models\\Receipt',217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',7500.00,NULL,NULL,1,'2022-09-06 20:18:02','2022-09-06 20:58:31','2022-09-06 20:58:31'),(218,7768,40728,13778,3,218,'App\\Models\\Receipt',218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',4959.91,NULL,NULL,1,'2022-09-06 20:18:02','2022-09-06 20:58:31','2022-09-06 20:58:31'),(219,7768,40728,13778,3,219,'App\\Models\\Receipt',219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',6524.69,NULL,NULL,1,'2022-09-06 20:18:02','2022-09-06 20:58:31','2022-09-06 20:58:31'),(220,7768,40728,13778,3,220,'App\\Models\\Receipt',220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',4888.42,NULL,NULL,1,'2022-09-06 20:18:02','2022-09-06 20:58:31','2022-09-06 20:58:31'),(221,7768,40728,13778,3,221,'App\\Models\\Receipt',221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',3851.54,NULL,NULL,1,'2022-09-06 20:18:02','2022-09-06 20:58:31','2022-09-06 20:58:31'),(222,7768,40728,13778,3,222,'App\\Models\\Receipt',222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',5056.23,NULL,NULL,1,'2022-09-06 20:18:03','2022-09-06 20:58:31','2022-09-06 20:58:31'),(223,7768,40728,13778,3,223,'App\\Models\\Receipt',223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',5258.94,NULL,NULL,1,'2022-09-06 20:18:03','2022-09-06 20:58:31','2022-09-06 20:58:31'),(224,7768,40728,13778,3,224,'App\\Models\\Receipt',224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',11362.45,NULL,NULL,1,'2022-09-06 20:18:03','2022-09-06 20:58:31','2022-09-06 20:58:31'),(256,7768,40728,13779,2,256,'App\\Models\\Receipt',256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',87914.50,NULL,NULL,1,'2022-09-06 20:20:27','2022-09-06 20:43:40','2022-09-06 20:43:40'),(257,7768,40728,13777,3,257,'App\\Models\\Receipt',257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',890.00,NULL,NULL,1,'2022-09-06 20:22:03','2022-09-06 20:22:03',NULL),(258,7768,40728,13777,3,258,'App\\Models\\Receipt',258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',5687.00,NULL,NULL,1,'2022-09-06 20:22:03','2022-09-06 20:22:03',NULL),(259,7768,40728,13777,3,259,'App\\Models\\Receipt',259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',10648.00,NULL,NULL,1,'2022-09-06 20:22:03','2022-09-06 20:22:03',NULL),(260,7768,40728,13777,3,260,'App\\Models\\Receipt',260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',4069.99,NULL,NULL,1,'2022-09-06 20:22:03','2022-09-06 20:22:03',NULL),(261,7768,40728,13777,3,261,'App\\Models\\Receipt',261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',3780.00,NULL,NULL,1,'2022-09-06 20:22:03','2022-09-06 20:22:03',NULL),(262,7768,40728,13777,3,262,'App\\Models\\Receipt',262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',11049.55,NULL,NULL,1,'2022-09-06 20:22:03','2022-10-29 10:18:02','2022-10-29 10:18:02'),(263,7768,40728,13777,3,263,'App\\Models\\Receipt',263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',26654.79,NULL,NULL,1,'2022-09-06 20:22:04','2022-09-06 20:22:04',NULL),(264,7768,40728,13777,3,264,'App\\Models\\Receipt',264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-15','2022-05-15',3203.67,NULL,NULL,1,'2022-09-06 20:22:04','2022-10-29 10:19:17','2022-10-29 10:19:17'),(265,7768,40728,13777,3,265,'App\\Models\\Receipt',265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',719.49,NULL,NULL,1,'2022-09-06 20:22:04','2022-09-06 20:22:04',NULL),(266,7768,40728,13777,3,266,'App\\Models\\Receipt',266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',12172.13,NULL,NULL,1,'2022-09-06 20:22:04','2022-10-29 10:23:44','2022-10-29 10:23:44');
INSERT INTO `balance_libro` VALUES (267,7768,40728,13777,3,267,'App\\Models\\Receipt',267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',4680.88,NULL,NULL,1,'2022-09-06 20:22:04','2022-10-29 11:04:11','2022-10-29 11:04:11'),(268,7768,40728,13777,3,268,'App\\Models\\Receipt',268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',4831.75,NULL,NULL,1,'2022-09-06 20:22:04','2022-09-06 20:22:04',NULL),(269,7768,40728,13777,3,269,'App\\Models\\Receipt',269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-21','2022-05-21',5678.72,NULL,NULL,1,'2022-09-06 20:22:04','2022-09-06 20:22:04',NULL),(270,7768,40728,13777,3,270,'App\\Models\\Receipt',270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',3227.13,NULL,NULL,1,'2022-09-06 20:22:04','2022-10-29 11:14:01','2022-10-29 11:14:01'),(271,7768,40728,13777,2,271,'App\\Models\\Receipt',271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',75384.75,NULL,NULL,1,'2022-09-06 20:22:28','2022-09-06 20:22:28',NULL),(272,7768,40728,13777,2,272,'App\\Models\\Receipt',272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',93188.39,NULL,NULL,1,'2022-09-06 20:22:28','2022-09-06 20:22:28',NULL),(273,7768,40728,13777,2,273,'App\\Models\\Receipt',273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',93188.39,NULL,NULL,1,'2022-09-06 20:22:28','2022-09-06 20:22:28',NULL),(274,7768,40728,13777,2,274,'App\\Models\\Receipt',274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',93188.39,NULL,NULL,1,'2022-09-06 20:22:29','2022-09-06 20:22:29',NULL),(275,7768,40728,13777,2,275,'App\\Models\\Receipt',275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',222764.05,NULL,NULL,1,'2022-09-06 20:22:29','2022-09-06 20:22:29',NULL),(307,7768,40728,13779,3,307,'App\\Models\\Receipt',307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',5687.00,NULL,NULL,1,'2022-09-06 20:27:41','2022-09-06 20:27:41',NULL),(308,7768,40728,13779,3,308,'App\\Models\\Receipt',308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2000.00,NULL,NULL,1,'2022-09-06 20:27:41','2022-09-06 20:27:41',NULL),(309,7768,40728,13779,3,309,'App\\Models\\Receipt',309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',10690.01,NULL,NULL,1,'2022-09-06 20:27:41','2022-09-06 20:27:41',NULL),(310,7768,40728,13779,3,310,'App\\Models\\Receipt',310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',1216.28,NULL,NULL,1,'2022-09-06 20:27:41','2022-09-06 20:27:41',NULL),(311,7768,40728,13779,3,311,'App\\Models\\Receipt',311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',15000.00,NULL,NULL,1,'2022-09-06 20:27:41','2022-11-08 15:32:34','2022-11-08 15:32:34'),(312,7768,40728,13779,3,312,'App\\Models\\Receipt',312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',37391.33,NULL,NULL,1,'2022-09-06 20:27:41','2022-10-31 14:42:43','2022-10-31 14:42:43'),(313,7768,40728,13779,3,313,'App\\Models\\Receipt',313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',84645.88,NULL,NULL,1,'2022-09-06 20:27:42','2022-09-06 20:27:42',NULL),(314,7768,40728,13779,3,314,'App\\Models\\Receipt',314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',1249.99,NULL,NULL,1,'2022-09-06 20:27:42','2022-10-31 16:16:26','2022-10-31 16:16:26'),(315,7768,40728,13779,3,315,'App\\Models\\Receipt',315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5791.23,NULL,NULL,1,'2022-09-06 20:27:42','2022-10-31 16:15:05','2022-10-31 16:15:05'),(316,7768,40728,13779,3,316,'App\\Models\\Receipt',316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',3133.24,NULL,NULL,1,'2022-09-06 20:27:42','2022-10-31 16:15:53','2022-10-31 16:15:53'),(317,7768,40728,13779,3,317,'App\\Models\\Receipt',317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',7545.96,NULL,NULL,1,'2022-09-06 20:27:42','2022-09-06 20:27:42',NULL);
INSERT INTO `balance_libro` VALUES (318,7768,40728,13779,3,318,'App\\Models\\Receipt',318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',25807.98,NULL,NULL,1,'2022-09-06 20:27:42','2022-10-31 16:03:45','2022-10-31 16:03:45'),(319,7768,40728,13779,3,319,'App\\Models\\Receipt',319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',9500.00,NULL,NULL,1,'2022-09-06 20:27:42','2022-09-06 20:27:42',NULL),(320,7768,40728,13779,3,320,'App\\Models\\Receipt',320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',450.00,NULL,NULL,1,'2022-09-06 20:27:42','2022-09-06 20:27:42',NULL),(321,7768,40728,13779,3,321,'App\\Models\\Receipt',321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',3531.14,NULL,NULL,1,'2022-09-06 20:27:42','2022-09-06 20:27:42',NULL),(322,7768,40728,13779,3,322,'App\\Models\\Receipt',322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',5550.05,NULL,NULL,1,'2022-09-06 20:27:42','2022-09-06 20:27:42',NULL),(323,7768,40728,13779,3,323,'App\\Models\\Receipt',323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',1740.07,NULL,NULL,1,'2022-09-06 20:27:42','2022-09-06 20:27:42',NULL),(324,7768,40728,13779,3,324,'App\\Models\\Receipt',324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',48000.02,NULL,NULL,1,'2022-09-06 20:27:42','2022-09-06 20:27:42',NULL),(325,7768,40728,13779,3,325,'App\\Models\\Receipt',325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',63731.58,NULL,NULL,1,'2022-09-06 20:27:42','2022-10-31 16:06:15','2022-10-31 16:06:15'),(326,7768,40728,13779,3,326,'App\\Models\\Receipt',326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',7280.00,NULL,NULL,1,'2022-09-06 20:27:42','2022-09-06 20:27:42',NULL),(327,7768,40728,13779,3,327,'App\\Models\\Receipt',327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5002.93,NULL,NULL,1,'2022-09-06 20:27:42','2022-10-31 16:06:37','2022-10-31 16:06:37'),(328,7768,40728,13779,3,328,'App\\Models\\Receipt',328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',284737.20,NULL,NULL,1,'2022-09-06 20:27:42','2022-09-06 20:27:42',NULL),(329,7768,40728,13779,3,329,'App\\Models\\Receipt',329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',123231.24,NULL,NULL,1,'2022-09-06 20:27:42','2022-09-06 20:27:42',NULL),(330,7768,40728,13779,3,330,'App\\Models\\Receipt',330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',7265.64,NULL,NULL,1,'2022-09-06 20:27:42','2022-10-31 16:02:43','2022-10-31 16:02:43'),(331,7768,40728,13779,3,331,'App\\Models\\Receipt',331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',3136.89,NULL,NULL,1,'2022-09-06 20:27:42','2022-09-06 20:27:42',NULL),(332,7768,40728,13779,3,332,'App\\Models\\Receipt',332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',1010.00,NULL,NULL,1,'2022-09-06 20:27:42','2022-09-06 20:27:42',NULL),(333,7768,40728,13779,3,333,'App\\Models\\Receipt',333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',865.05,NULL,NULL,1,'2022-09-06 20:27:42','2022-09-06 20:27:42',NULL),(334,7768,40728,13779,3,334,'App\\Models\\Receipt',334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',2000.01,NULL,NULL,1,'2022-09-06 20:27:43','2022-09-06 20:27:43',NULL),(335,7768,40728,13779,3,335,'App\\Models\\Receipt',335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',2000.00,NULL,NULL,1,'2022-09-06 20:27:43','2022-09-06 20:27:43',NULL),(336,7768,40728,13779,3,336,'App\\Models\\Receipt',336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',800.00,NULL,NULL,1,'2022-09-06 20:27:43','2022-09-06 20:27:43',NULL),(337,7768,40728,13779,3,337,'App\\Models\\Receipt',337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',4719.07,NULL,NULL,1,'2022-09-06 20:27:43','2022-09-06 20:27:43',NULL),(338,7768,40728,13779,3,338,'App\\Models\\Receipt',338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',6005.53,NULL,NULL,1,'2022-09-06 20:27:43','2022-09-06 20:27:43',NULL);
INSERT INTO `balance_libro` VALUES (339,7768,40728,13779,3,339,'App\\Models\\Receipt',339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',7180.96,NULL,NULL,1,'2022-09-06 20:27:43','2022-09-06 20:27:43',NULL),(340,7768,40728,13779,3,340,'App\\Models\\Receipt',340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5561.25,NULL,NULL,1,'2022-09-06 20:27:43','2022-09-06 20:27:43',NULL),(341,7768,40728,13779,3,341,'App\\Models\\Receipt',341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',5642.69,NULL,NULL,1,'2022-09-06 20:27:43','2022-09-06 20:27:43',NULL),(342,7768,40728,13779,3,342,'App\\Models\\Receipt',342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-17','2022-07-17',6969.81,NULL,NULL,1,'2022-09-06 20:27:43','2023-04-25 19:47:40','2023-04-25 19:47:40'),(343,7768,40728,13779,3,343,'App\\Models\\Receipt',343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',4866.41,NULL,NULL,1,'2022-09-06 20:27:43','2022-09-06 20:27:43',NULL),(344,7768,40728,13779,3,344,'App\\Models\\Receipt',344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',3683.03,NULL,NULL,1,'2022-09-06 20:27:43','2022-09-06 20:27:43',NULL),(345,7768,40728,13779,3,345,'App\\Models\\Receipt',345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',2400.00,NULL,NULL,1,'2022-09-06 20:27:43','2022-09-06 20:27:43',NULL),(346,7768,40728,13779,3,346,'App\\Models\\Receipt',346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',4200.00,NULL,NULL,1,'2022-09-06 20:27:43','2022-09-06 20:27:43',NULL),(347,7768,40728,13779,3,347,'App\\Models\\Receipt',347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',15141.27,NULL,NULL,1,'2022-09-06 20:27:43','2022-09-07 19:51:16','2022-09-07 19:51:16'),(348,7768,40728,13778,2,348,'App\\Models\\Receipt',348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',87914.50,NULL,NULL,1,'2022-09-06 20:44:15','2022-09-06 20:44:15',NULL),(349,7768,40728,13776,2,349,'App\\Models\\Receipt',349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',98363.68,NULL,NULL,1,'2022-09-06 20:46:12','2022-09-06 20:46:12',NULL),(350,7768,40728,13776,2,350,'App\\Models\\Receipt',350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',54106.38,NULL,NULL,1,'2022-09-06 20:46:12','2022-09-06 20:46:12',NULL),(351,7768,40728,13776,2,351,'App\\Models\\Receipt',351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',62266.60,NULL,NULL,1,'2022-09-06 20:46:12','2022-09-06 20:46:12',NULL),(352,7768,40728,13776,2,352,'App\\Models\\Receipt',352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',8813.62,NULL,NULL,1,'2022-09-06 20:46:12','2022-09-06 20:46:12',NULL),(353,7768,40728,13776,2,353,'App\\Models\\Receipt',353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',54106.38,NULL,NULL,1,'2022-09-06 20:46:12','2022-09-06 20:46:12',NULL),(354,7768,40728,13776,3,354,'App\\Models\\Receipt',354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',4650.42,NULL,NULL,1,'2022-09-06 20:46:24','2022-11-07 08:56:58','2022-11-07 08:56:58'),(355,7768,40728,13776,3,355,'App\\Models\\Receipt',355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',5687.00,NULL,NULL,1,'2022-09-06 20:46:24','2022-09-06 20:46:24',NULL),(356,7768,40728,13776,3,356,'App\\Models\\Receipt',356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',30000.00,NULL,NULL,1,'2022-09-06 20:46:24','2022-09-06 20:46:24',NULL),(357,7768,40728,13776,3,357,'App\\Models\\Receipt',357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',92288.54,NULL,NULL,1,'2022-09-06 20:46:24','2022-10-29 09:48:35','2022-10-29 09:48:35'),(358,7768,40728,13776,3,358,'App\\Models\\Receipt',358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',1900.00,NULL,NULL,1,'2022-09-06 20:46:24','2022-09-06 20:46:24',NULL);
INSERT INTO `balance_libro` VALUES (359,7768,40728,13776,3,359,'App\\Models\\Receipt',359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',2534.33,NULL,NULL,1,'2022-09-06 20:46:24','2022-11-07 08:56:35','2022-11-07 08:56:35'),(360,7768,40728,13776,3,360,'App\\Models\\Receipt',360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',2450.04,NULL,NULL,1,'2022-09-06 20:46:24','2022-09-06 20:46:24',NULL),(361,7768,40728,13776,3,361,'App\\Models\\Receipt',361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',2885.00,NULL,NULL,1,'2022-09-06 20:46:24','2022-09-06 20:46:24',NULL),(362,7768,40728,13776,3,362,'App\\Models\\Receipt',362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',9250.00,NULL,NULL,1,'2022-09-06 20:46:24','2022-09-06 20:46:24',NULL),(363,7768,40728,13776,3,363,'App\\Models\\Receipt',363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',14300.00,NULL,NULL,1,'2022-09-06 20:46:24','2022-09-06 20:46:24',NULL),(364,7768,40728,13776,3,364,'App\\Models\\Receipt',364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',7477.94,NULL,NULL,1,'2022-09-06 20:46:24','2022-10-29 09:47:44','2022-10-29 09:47:44'),(365,7768,40728,13776,3,365,'App\\Models\\Receipt',365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',2557.18,NULL,NULL,1,'2022-09-06 20:46:24','2022-09-06 20:46:24',NULL),(366,7768,40728,13776,3,366,'App\\Models\\Receipt',366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',403.78,NULL,NULL,1,'2022-09-06 20:46:24','2022-09-06 20:46:24',NULL),(367,7768,40728,13776,3,367,'App\\Models\\Receipt',367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',4883.00,NULL,NULL,1,'2022-09-06 20:46:24','2022-11-07 08:56:07','2022-11-07 08:56:07'),(368,7768,40728,13776,3,368,'App\\Models\\Receipt',368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',2774.81,NULL,NULL,1,'2022-09-06 20:46:25','2022-09-06 20:46:25',NULL),(369,7768,40728,13776,3,369,'App\\Models\\Receipt',369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',14157.00,NULL,NULL,1,'2022-09-06 20:46:25','2022-09-06 20:46:25',NULL),(370,7768,40728,13776,3,370,'App\\Models\\Receipt',370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',14157.00,NULL,NULL,1,'2022-09-06 20:46:25','2022-09-06 20:46:25',NULL),(371,7768,40728,13776,3,371,'App\\Models\\Receipt',371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',7500.00,NULL,NULL,1,'2022-09-06 20:46:25','2022-11-08 15:31:14','2022-11-08 15:31:14'),(372,7768,40728,13776,3,372,'App\\Models\\Receipt',372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',15000.00,NULL,NULL,1,'2022-09-06 20:46:25','2022-11-08 15:31:03','2022-11-08 15:31:03'),(373,7768,40728,13776,3,373,'App\\Models\\Receipt',373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',3993.38,NULL,NULL,1,'2022-09-06 20:46:25','2022-11-15 12:23:05','2022-11-15 12:23:05'),(374,7768,40728,13776,3,374,'App\\Models\\Receipt',374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',4837.08,NULL,NULL,1,'2022-09-06 20:46:25','2022-11-15 12:21:50','2022-11-15 12:21:50'),(375,7768,40728,13776,3,375,'App\\Models\\Receipt',375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-03','2022-04-03',5101.51,NULL,NULL,1,'2022-09-06 20:46:25','2022-09-06 20:46:25',NULL),(376,7768,40728,13776,3,376,'App\\Models\\Receipt',376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-03','2022-04-03',3750.71,NULL,NULL,1,'2022-09-06 20:46:25','2022-09-06 20:46:25',NULL),(377,7768,40728,13776,3,377,'App\\Models\\Receipt',377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-03','2022-04-03',4461.37,NULL,NULL,1,'2022-09-06 20:46:25','2022-09-06 20:46:25',NULL),(378,7768,40728,13776,3,378,'App\\Models\\Receipt',378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',3967.64,NULL,NULL,1,'2022-09-06 20:46:25','2022-11-08 15:43:39','2022-11-08 15:43:39');
INSERT INTO `balance_libro` VALUES (391,7768,40728,13778,3,391,'App\\Models\\Receipt',391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',4719.00,NULL,NULL,1,'2022-09-06 20:57:21','2022-09-06 20:58:31','2022-09-06 20:58:31'),(392,7768,40728,13778,3,392,'App\\Models\\Receipt',392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',810.00,NULL,NULL,1,'2022-09-06 20:57:21','2022-09-06 20:58:31','2022-09-06 20:58:31'),(393,7768,40728,13778,3,393,'App\\Models\\Receipt',393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',4356.00,NULL,NULL,1,'2022-09-06 20:57:21','2022-09-06 20:58:31','2022-09-06 20:58:31'),(394,7768,40728,13778,3,394,'App\\Models\\Receipt',394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',4872.24,NULL,NULL,1,'2022-09-06 20:57:21','2022-09-06 20:58:31','2022-09-06 20:58:31'),(395,7768,40728,13778,3,395,'App\\Models\\Receipt',395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',500.00,NULL,NULL,1,'2022-09-06 20:57:21','2022-09-06 20:58:31','2022-09-06 20:58:31'),(396,7768,40728,13778,3,396,'App\\Models\\Receipt',396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',4679.62,NULL,NULL,1,'2022-09-06 20:57:21','2022-09-06 20:58:31','2022-09-06 20:58:31'),(397,7768,40728,13778,3,397,'App\\Models\\Receipt',397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',13975.00,NULL,NULL,1,'2022-09-06 20:57:21','2022-09-06 20:58:31','2022-09-06 20:58:31'),(398,7768,40728,13778,3,398,'App\\Models\\Receipt',398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',5350.70,NULL,NULL,1,'2022-09-06 20:57:21','2022-09-06 20:58:31','2022-09-06 20:58:31'),(399,7768,40728,13778,3,399,'App\\Models\\Receipt',399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',13600.00,NULL,NULL,1,'2022-09-06 20:57:21','2022-09-06 20:58:31','2022-09-06 20:58:31'),(400,7768,40728,13778,3,400,'App\\Models\\Receipt',400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',3400.90,NULL,NULL,1,'2022-09-06 20:57:21','2022-09-06 20:58:31','2022-09-06 20:58:31'),(401,7768,40728,13778,3,401,'App\\Models\\Receipt',401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',10000.00,NULL,NULL,1,'2022-09-06 20:57:22','2022-09-06 20:58:31','2022-09-06 20:58:31'),(402,7768,40728,13778,3,402,'App\\Models\\Receipt',402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1159.00,NULL,NULL,1,'2022-09-06 20:57:22','2022-09-06 20:58:31','2022-09-06 20:58:31'),(403,7768,40728,13778,3,403,'App\\Models\\Receipt',403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',3849.43,NULL,NULL,1,'2022-09-06 20:57:22','2022-09-06 20:58:31','2022-09-06 20:58:31'),(404,7768,40728,13778,3,404,'App\\Models\\Receipt',404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',350.57,NULL,NULL,1,'2022-09-06 20:57:22','2022-09-06 20:58:31','2022-09-06 20:58:31'),(405,7768,40728,13778,3,405,'App\\Models\\Receipt',405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-27','2022-03-27',3300.11,NULL,NULL,1,'2022-09-06 20:57:22','2022-09-06 20:58:31','2022-09-06 20:58:31'),(406,7768,40728,13778,3,406,'App\\Models\\Receipt',406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-27','2022-03-27',5200.20,NULL,NULL,1,'2022-09-06 20:57:22','2022-09-06 20:58:31','2022-09-06 20:58:31'),(407,7768,40728,13778,3,407,'App\\Models\\Receipt',407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-01','2022-03-01',5658.49,NULL,NULL,1,'2022-09-06 20:57:22','2022-09-06 20:58:32','2022-09-06 20:58:32'),(408,7768,40728,13778,3,408,'App\\Models\\Receipt',408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',4550.40,NULL,NULL,1,'2022-09-06 20:57:22','2022-09-06 20:58:32','2022-09-06 20:58:32'),(409,7768,40728,13778,3,409,'App\\Models\\Receipt',409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',22187.50,NULL,NULL,1,'2022-09-06 20:57:22','2022-09-06 20:58:32','2022-09-06 20:58:32');
INSERT INTO `balance_libro` VALUES (410,7768,40728,13778,3,410,'App\\Models\\Receipt',410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',2500.01,NULL,NULL,1,'2022-09-06 20:57:22','2022-09-06 20:58:32','2022-09-06 20:58:32'),(411,7768,40728,13778,3,411,'App\\Models\\Receipt',411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',5183.21,NULL,NULL,1,'2022-09-06 20:57:22','2022-09-06 20:58:32','2022-09-06 20:58:32'),(412,7768,40728,13778,3,412,'App\\Models\\Receipt',412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',4800.59,NULL,NULL,1,'2022-09-06 20:57:22','2022-09-06 20:58:32','2022-09-06 20:58:32'),(413,7768,40728,13778,3,413,'App\\Models\\Receipt',413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',7691.23,NULL,NULL,1,'2022-09-06 20:57:22','2022-09-06 20:57:55','2022-09-06 20:57:55'),(414,7768,40728,13778,3,414,'App\\Models\\Receipt',414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',3501.00,NULL,NULL,1,'2022-09-06 20:57:22','2022-09-06 20:57:51','2022-09-06 20:57:51'),(415,7768,40728,13775,3,415,'App\\Models\\Receipt',415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',4719.00,NULL,NULL,1,'2022-09-06 20:59:53','2022-09-06 20:59:53',NULL),(416,7768,40728,13775,3,416,'App\\Models\\Receipt',416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',810.00,NULL,NULL,1,'2022-09-06 20:59:53','2022-09-06 20:59:53',NULL),(417,7768,40728,13775,3,417,'App\\Models\\Receipt',417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',4356.00,NULL,NULL,1,'2022-09-06 20:59:53','2022-09-06 20:59:53',NULL),(418,7768,40728,13775,3,418,'App\\Models\\Receipt',418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',4872.24,NULL,NULL,1,'2022-09-06 20:59:53','2022-10-23 11:01:22','2022-10-23 11:01:22'),(419,7768,40728,13775,3,419,'App\\Models\\Receipt',419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',500.00,NULL,NULL,1,'2022-09-06 20:59:53','2022-09-06 20:59:53',NULL),(420,7768,40728,13775,3,420,'App\\Models\\Receipt',420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',4679.62,NULL,NULL,1,'2022-09-06 20:59:53','2022-10-23 11:23:10','2022-10-23 11:23:10'),(421,7768,40728,13775,3,421,'App\\Models\\Receipt',421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',13975.00,NULL,NULL,1,'2022-09-06 20:59:53','2022-09-06 20:59:53',NULL),(422,7768,40728,13775,3,422,'App\\Models\\Receipt',422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',5350.70,NULL,NULL,1,'2022-09-06 20:59:53','2022-11-07 08:55:35','2022-11-07 08:55:35'),(423,7768,40728,13775,3,423,'App\\Models\\Receipt',423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',13600.00,NULL,NULL,1,'2022-09-06 20:59:53','2022-09-06 20:59:53',NULL),(424,7768,40728,13775,3,424,'App\\Models\\Receipt',424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',3400.90,NULL,NULL,1,'2022-09-06 20:59:53','2022-11-07 08:55:15','2022-11-07 08:55:15'),(425,7768,40728,13775,3,425,'App\\Models\\Receipt',425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',10000.00,NULL,NULL,1,'2022-09-06 20:59:53','2022-09-06 20:59:53',NULL),(426,7768,40728,13775,3,426,'App\\Models\\Receipt',426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1159.00,NULL,NULL,1,'2022-09-06 20:59:53','2022-11-07 08:54:58','2022-11-07 08:54:58'),(427,7768,40728,13775,3,427,'App\\Models\\Receipt',427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',3849.43,NULL,NULL,1,'2022-09-06 20:59:53','2022-11-08 15:43:25','2022-11-08 15:43:25'),(428,7768,40728,13775,3,428,'App\\Models\\Receipt',428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',350.57,NULL,NULL,1,'2022-09-06 20:59:53','2022-09-06 20:59:53',NULL),(429,7768,40728,13775,3,429,'App\\Models\\Receipt',429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-27','2022-03-27',3300.11,NULL,NULL,1,'2022-09-06 20:59:53','2022-11-15 15:06:58','2022-11-15 15:06:58');
INSERT INTO `balance_libro` VALUES (430,7768,40728,13775,3,430,'App\\Models\\Receipt',430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-27','2022-03-27',5200.20,NULL,NULL,1,'2022-09-06 20:59:53','2022-09-06 20:59:53',NULL),(431,7768,40728,13775,3,431,'App\\Models\\Receipt',431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-01','2022-03-01',5658.49,NULL,NULL,1,'2022-09-06 20:59:53','2022-09-06 20:59:53',NULL),(432,7768,40728,13775,3,432,'App\\Models\\Receipt',432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',4550.40,NULL,NULL,1,'2022-09-06 20:59:53','2022-09-06 20:59:53',NULL),(433,7768,40728,13775,3,433,'App\\Models\\Receipt',433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',22187.50,NULL,NULL,1,'2022-09-06 20:59:53','2022-09-06 20:59:53',NULL),(434,7768,40728,13775,3,434,'App\\Models\\Receipt',434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',2500.01,NULL,NULL,1,'2022-09-06 20:59:53','2022-09-06 20:59:53',NULL),(435,7768,40728,13775,3,435,'App\\Models\\Receipt',435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',5183.21,NULL,NULL,1,'2022-09-06 20:59:53','2022-09-06 20:59:53',NULL),(436,7768,40728,13775,3,436,'App\\Models\\Receipt',436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',4800.59,NULL,NULL,1,'2022-09-06 20:59:54','2022-09-06 20:59:54',NULL),(437,7768,40728,13775,3,437,'App\\Models\\Receipt',437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',7691.23,NULL,NULL,1,'2022-09-06 20:59:54','2022-09-06 20:59:54',NULL),(438,7768,40728,13775,3,438,'App\\Models\\Receipt',438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',3501.00,NULL,NULL,1,'2022-09-06 20:59:54','2022-09-06 20:59:54',NULL),(450,7768,40728,13774,3,450,'App\\Models\\Receipt',450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',4719.00,NULL,NULL,1,'2022-09-06 22:58:27','2022-09-06 22:58:27',NULL),(451,7768,40728,13774,3,451,'App\\Models\\Receipt',451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',8430.15,NULL,NULL,1,'2022-09-06 22:58:27','2022-11-15 12:40:15','2022-11-15 12:40:15'),(452,7768,40728,13774,3,452,'App\\Models\\Receipt',452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',10723.59,NULL,NULL,1,'2022-09-06 22:58:27','2022-09-06 22:58:27',NULL),(453,7768,40728,13774,3,453,'App\\Models\\Receipt',453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',3955.24,NULL,NULL,1,'2022-09-06 22:58:27','2022-10-23 11:00:49','2022-10-23 11:00:49'),(454,7768,40728,13774,3,454,'App\\Models\\Receipt',454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-13','2022-02-13',5592.00,NULL,NULL,1,'2022-09-06 22:58:27','2022-09-06 22:58:27',NULL),(455,7768,40728,13774,3,455,'App\\Models\\Receipt',455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',65520.59,NULL,NULL,1,'2022-09-06 22:58:27','2022-09-06 22:58:27',NULL),(456,7768,40728,13774,3,456,'App\\Models\\Receipt',456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',5202.88,NULL,NULL,1,'2022-09-06 22:58:27','2022-11-07 08:54:38','2022-11-07 08:54:38'),(457,7768,40728,13774,3,457,'App\\Models\\Receipt',457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',11342.00,NULL,NULL,1,'2022-09-06 22:58:27','2022-09-06 22:58:27',NULL),(458,7768,40728,13774,3,458,'App\\Models\\Receipt',458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-19','2022-02-19',900.00,NULL,NULL,1,'2022-09-06 22:58:27','2022-09-06 22:58:27',NULL),(459,7768,40728,13774,3,459,'App\\Models\\Receipt',459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',29947.72,NULL,NULL,1,'2022-09-06 22:58:27','2022-09-06 22:58:27',NULL),(460,7768,40728,13774,3,460,'App\\Models\\Receipt',460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',3784.39,NULL,NULL,1,'2022-09-06 22:58:27','2022-11-07 08:54:10','2022-11-07 08:54:10');
INSERT INTO `balance_libro` VALUES (461,7768,40728,13774,3,461,'App\\Models\\Receipt',461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',6506.95,NULL,NULL,1,'2022-09-06 22:58:27','2022-10-23 11:09:33','2022-10-23 11:09:33'),(462,7768,40728,13774,3,462,'App\\Models\\Receipt',462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',2500.09,NULL,NULL,1,'2022-09-06 22:58:28','2022-09-06 22:58:28',NULL),(463,7768,40728,13774,3,463,'App\\Models\\Receipt',463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-26','2022-02-26',4691.79,NULL,NULL,1,'2022-09-06 22:58:28','2022-09-06 22:58:28',NULL),(464,7768,40728,13774,3,464,'App\\Models\\Receipt',464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',4054.78,NULL,NULL,1,'2022-09-06 22:58:28','2022-09-06 22:58:28',NULL),(465,7768,40728,13774,3,465,'App\\Models\\Receipt',465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',30596.99,NULL,NULL,1,'2022-09-06 22:58:28','2022-11-08 15:42:46','2022-11-08 15:42:46'),(466,7768,40728,13774,2,466,'App\\Models\\Receipt',466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',183920.00,NULL,NULL,1,'2022-09-06 22:59:25','2022-09-06 23:03:26','2022-09-06 23:03:26'),(467,7768,40728,13774,2,467,'App\\Models\\Receipt',467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',183920.00,NULL,NULL,1,'2022-09-06 22:59:25','2022-09-06 23:03:22','2022-09-06 23:03:22'),(468,7768,40728,13774,2,468,'App\\Models\\Receipt',468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',183920.00,NULL,NULL,1,'2022-09-06 22:59:25','2022-09-06 23:03:18','2022-09-06 23:03:18'),(469,7768,40728,13774,2,469,'App\\Models\\Receipt',469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',1272678.00,NULL,NULL,1,'2022-09-06 22:59:25','2022-09-06 23:03:13','2022-09-06 23:03:13'),(494,7768,40728,13773,3,494,'App\\Models\\Receipt',494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-02','2022-01-02',4256.00,NULL,NULL,1,'2022-09-06 23:02:06','2022-09-06 23:02:06',NULL),(495,7768,40728,13773,3,495,'App\\Models\\Receipt',495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',4719.00,NULL,NULL,1,'2022-09-06 23:02:06','2022-09-06 23:02:06',NULL),(496,7768,40728,13773,3,496,'App\\Models\\Receipt',496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',6121.39,NULL,NULL,1,'2022-09-06 23:02:06','2022-09-06 23:02:06',NULL),(497,7768,40728,13773,3,497,'App\\Models\\Receipt',497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',4101.49,NULL,NULL,1,'2022-09-06 23:02:07','2022-09-06 23:02:07',NULL),(498,7768,40728,13773,3,498,'App\\Models\\Receipt',498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',820.38,NULL,NULL,1,'2022-09-06 23:02:07','2022-09-06 23:02:07',NULL),(499,7768,40728,13773,3,499,'App\\Models\\Receipt',499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',1199.99,NULL,NULL,1,'2022-09-06 23:02:07','2022-09-06 23:02:07',NULL),(500,7768,40728,13773,3,500,'App\\Models\\Receipt',500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',4904.04,NULL,NULL,1,'2022-09-06 23:02:07','2022-10-23 11:03:39','2022-10-23 11:03:39'),(501,7768,40728,13773,3,501,'App\\Models\\Receipt',501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',3630.00,NULL,NULL,1,'2022-09-06 23:02:07','2022-09-06 23:02:07',NULL),(502,7768,40728,13773,3,502,'App\\Models\\Receipt',502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',45406.93,NULL,NULL,1,'2022-09-06 23:02:07','2022-11-15 12:52:38','2022-11-15 12:52:38'),(503,7768,40728,13773,3,503,'App\\Models\\Receipt',503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',18803.40,NULL,NULL,1,'2022-09-06 23:02:07','2022-09-06 23:02:07',NULL),(504,7768,40728,13773,3,504,'App\\Models\\Receipt',504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',2322.69,NULL,NULL,1,'2022-09-06 23:02:07','2022-09-06 23:02:07',NULL);
INSERT INTO `balance_libro` VALUES (505,7768,40728,13773,3,505,'App\\Models\\Receipt',505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',14976.79,NULL,NULL,1,'2022-09-06 23:02:07','2022-09-06 23:02:07',NULL),(506,7768,40728,13773,3,506,'App\\Models\\Receipt',506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',1013.79,NULL,NULL,1,'2022-09-06 23:02:07','2022-09-06 23:02:07',NULL),(507,7768,40728,13773,3,507,'App\\Models\\Receipt',507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',3954.87,NULL,NULL,1,'2022-09-06 23:02:07','2022-11-07 08:53:48','2022-11-07 08:53:48'),(508,7768,40728,13773,3,508,'App\\Models\\Receipt',508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',11495.00,NULL,NULL,1,'2022-09-06 23:02:07','2022-09-06 23:02:07',NULL),(509,7768,40728,13773,3,509,'App\\Models\\Receipt',509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',3783.75,NULL,NULL,1,'2022-09-06 23:02:07','2022-10-23 11:00:27','2022-10-23 11:00:27'),(510,7768,40728,13773,3,510,'App\\Models\\Receipt',510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',101001.68,NULL,NULL,1,'2022-09-06 23:02:07','2022-09-06 23:02:07',NULL),(511,7768,40728,13773,3,511,'App\\Models\\Receipt',511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',847.00,NULL,NULL,1,'2022-09-06 23:02:07','2022-09-06 23:02:07',NULL),(512,7768,40728,13773,3,512,'App\\Models\\Receipt',512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',3751.00,NULL,NULL,1,'2022-09-06 23:02:07','2022-09-06 23:02:07',NULL),(513,7768,40728,13773,3,513,'App\\Models\\Receipt',513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',3751.00,NULL,NULL,1,'2022-09-06 23:02:07','2022-09-06 23:02:07',NULL),(514,7768,40728,13773,3,514,'App\\Models\\Receipt',514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-22','2022-01-22',6361.74,NULL,NULL,1,'2022-09-06 23:02:07','2022-09-06 23:02:07',NULL),(515,7768,40728,13773,3,515,'App\\Models\\Receipt',515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',488598.00,NULL,NULL,1,'2022-09-06 23:02:07','2022-09-06 23:02:07',NULL),(516,7768,40728,13773,3,516,'App\\Models\\Receipt',516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',364210.00,NULL,NULL,1,'2022-09-06 23:02:07','2022-09-06 23:02:07',NULL),(517,7768,40728,13773,3,517,'App\\Models\\Receipt',517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',7500.00,NULL,NULL,1,'2022-09-06 23:02:07','2022-11-08 15:30:50','2022-11-08 15:30:50'),(518,7768,40728,13773,3,518,'App\\Models\\Receipt',518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',2614.99,NULL,NULL,1,'2022-09-06 23:02:07','2022-09-06 23:02:07',NULL),(519,7768,40728,13773,3,519,'App\\Models\\Receipt',519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',4275.49,NULL,NULL,1,'2022-09-06 23:02:07','2022-09-06 23:02:07',NULL),(520,7768,40728,13773,3,520,'App\\Models\\Receipt',520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',8223.66,NULL,NULL,1,'2022-09-06 23:02:08','2022-09-06 23:02:08',NULL),(521,7768,40728,13773,3,521,'App\\Models\\Receipt',521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-02','2022-01-02',4180.99,NULL,NULL,1,'2022-09-06 23:02:08','2022-11-15 12:22:06','2022-11-15 12:22:06'),(522,7768,40728,13773,3,522,'App\\Models\\Receipt',522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',4119.38,NULL,NULL,1,'2022-09-06 23:02:08','2022-11-15 12:22:19','2022-11-15 12:22:19'),(523,7768,40728,13773,3,523,'App\\Models\\Receipt',523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',3954.87,NULL,NULL,1,'2022-09-06 23:02:08','2022-11-07 08:53:19','2022-11-07 08:53:19'),(524,7768,40728,13773,3,524,'App\\Models\\Receipt',524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',6493.32,NULL,NULL,1,'2022-09-06 23:02:08','2022-09-06 23:02:08',NULL);
INSERT INTO `balance_libro` VALUES (525,7768,40728,13773,3,525,'App\\Models\\Receipt',525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',10655.18,NULL,NULL,1,'2022-09-06 23:02:08','2022-09-06 23:02:08',NULL),(526,7768,40728,13773,3,526,'App\\Models\\Receipt',526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',3901.00,NULL,NULL,1,'2022-09-06 23:02:08','2022-09-06 23:02:08',NULL),(527,7768,40728,13773,3,527,'App\\Models\\Receipt',527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',3997.86,NULL,NULL,1,'2022-09-06 23:02:08','2022-09-06 23:02:08',NULL),(528,7768,40728,13773,3,528,'App\\Models\\Receipt',528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',3896.00,NULL,NULL,1,'2022-09-06 23:02:08','2022-09-06 23:02:08',NULL),(529,7768,40728,13773,2,529,'App\\Models\\Receipt',529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',183920.00,NULL,NULL,1,'2022-09-06 23:05:04','2022-09-06 23:05:04',NULL),(530,7768,40728,13773,2,530,'App\\Models\\Receipt',530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',183920.00,NULL,NULL,1,'2022-09-06 23:05:04','2022-09-06 23:05:04',NULL),(531,7768,40728,13773,2,531,'App\\Models\\Receipt',531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',183920.00,NULL,NULL,1,'2022-09-06 23:05:04','2022-09-06 23:05:04',NULL),(532,7768,40728,13773,2,532,'App\\Models\\Receipt',532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',1272678.00,NULL,NULL,1,'2022-09-06 23:05:04','2022-09-06 23:05:04',NULL),(533,7768,40728,13778,3,533,'App\\Models\\Receipt',533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',5687.00,NULL,NULL,1,'2022-09-06 23:13:36','2022-09-06 23:13:36',NULL),(534,7768,40728,13778,3,534,'App\\Models\\Receipt',534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',3329.18,NULL,NULL,1,'2022-09-06 23:13:36','2022-10-31 12:05:52','2022-10-31 12:05:52'),(535,7768,40728,13778,3,535,'App\\Models\\Receipt',535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',31361.28,NULL,NULL,1,'2022-09-06 23:13:36','2022-10-31 11:58:45','2022-10-31 11:58:45'),(536,7768,40728,13778,3,536,'App\\Models\\Receipt',536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',4879.30,NULL,NULL,1,'2022-09-06 23:13:36','2022-09-06 23:13:36',NULL),(537,7768,40728,13778,3,537,'App\\Models\\Receipt',537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',5113.41,NULL,NULL,1,'2022-09-06 23:13:36','2022-10-31 12:11:46','2022-10-31 12:11:46'),(538,7768,40728,13778,3,538,'App\\Models\\Receipt',538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',11495.00,NULL,NULL,1,'2022-09-06 23:13:36','2022-09-06 23:13:36',NULL),(539,7768,40728,13778,3,539,'App\\Models\\Receipt',539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',37932.21,NULL,NULL,1,'2022-09-06 23:13:36','2022-09-06 23:13:36',NULL),(540,7768,40728,13778,3,540,'App\\Models\\Receipt',540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',7345.81,NULL,NULL,1,'2022-09-06 23:13:36','2022-10-31 12:14:24','2022-10-31 12:14:24'),(541,7768,40728,13778,3,541,'App\\Models\\Receipt',541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',3000.02,NULL,NULL,1,'2022-09-06 23:13:36','2022-09-06 23:13:36',NULL),(542,7768,40728,13778,3,542,'App\\Models\\Receipt',542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',7500.00,NULL,NULL,1,'2022-09-06 23:13:36','2022-11-08 15:30:39','2022-11-08 15:30:39'),(543,7768,40728,13778,3,543,'App\\Models\\Receipt',543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',4959.91,NULL,NULL,1,'2022-09-06 23:13:36','2022-09-06 23:13:36',NULL),(544,7768,40728,13778,3,544,'App\\Models\\Receipt',544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',6524.69,NULL,NULL,1,'2022-09-06 23:13:36','2022-09-08 22:39:03','2022-09-08 22:39:03');
INSERT INTO `balance_libro` VALUES (545,7768,40728,13778,3,545,'App\\Models\\Receipt',545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',4888.42,NULL,NULL,1,'2022-09-06 23:13:36','2022-09-06 23:13:36',NULL),(546,7768,40728,13778,3,546,'App\\Models\\Receipt',546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',3851.54,NULL,NULL,1,'2022-09-06 23:13:36','2022-09-06 23:13:36',NULL),(547,7768,40728,13778,3,547,'App\\Models\\Receipt',547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',5056.23,NULL,NULL,1,'2022-09-06 23:13:36','2022-09-06 23:13:36',NULL),(548,7768,40728,13778,3,548,'App\\Models\\Receipt',548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',5258.94,NULL,NULL,1,'2022-09-06 23:13:36','2022-09-06 23:13:36',NULL),(549,7768,40728,13778,3,549,'App\\Models\\Receipt',549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',11362.45,NULL,NULL,1,'2022-09-06 23:13:36','2022-09-06 23:13:36',NULL),(567,7768,40728,13760,3,567,'App\\Models\\Receipt',567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',825.00,NULL,NULL,1,'2022-09-06 23:15:59','2022-09-06 23:15:59',NULL),(568,7768,40728,13760,3,568,'App\\Models\\Receipt',568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',24310.00,NULL,NULL,1,'2022-09-06 23:15:59','2022-09-06 23:15:59',NULL),(569,7768,40728,13760,3,569,'App\\Models\\Receipt',569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',2805.00,NULL,NULL,1,'2022-09-06 23:15:59','2022-09-06 23:15:59',NULL),(570,7768,40728,13760,3,570,'App\\Models\\Receipt',570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',7850.00,NULL,NULL,1,'2022-09-06 23:15:59','2022-09-06 23:15:59',NULL),(571,7768,40728,13760,3,571,'App\\Models\\Receipt',571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',9137.66,NULL,NULL,1,'2022-09-06 23:15:59','2022-11-15 12:28:32','2022-11-15 12:28:32'),(572,7768,40728,13760,3,572,'App\\Models\\Receipt',572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',28999.00,NULL,NULL,1,'2022-09-06 23:15:59','2022-09-06 23:15:59',NULL),(573,7768,40728,13760,3,573,'App\\Models\\Receipt',573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',24310.00,NULL,NULL,1,'2022-09-06 23:15:59','2022-09-06 23:15:59',NULL),(574,7768,40728,13760,3,574,'App\\Models\\Receipt',574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',1015.94,NULL,NULL,1,'2022-09-06 23:15:59','2022-09-06 23:15:59',NULL),(575,7768,40728,13760,3,575,'App\\Models\\Receipt',575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',4498.09,NULL,NULL,1,'2022-09-06 23:15:59','2022-09-06 23:15:59',NULL),(576,7768,40728,13760,3,576,'App\\Models\\Receipt',576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',2805.00,NULL,NULL,1,'2022-09-06 23:15:59','2022-09-06 23:15:59',NULL),(577,7768,40728,13760,3,577,'App\\Models\\Receipt',577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',267.00,NULL,NULL,1,'2022-09-06 23:15:59','2022-09-06 23:15:59',NULL),(578,7768,40728,13760,3,578,'App\\Models\\Receipt',578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',705.67,NULL,NULL,1,'2022-09-06 23:15:59','2022-09-06 23:15:59',NULL),(579,7768,40728,13760,3,579,'App\\Models\\Receipt',579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',950.00,NULL,NULL,1,'2022-09-06 23:15:59','2022-09-06 23:15:59',NULL),(580,7768,40728,13760,3,580,'App\\Models\\Receipt',580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',3635.14,NULL,NULL,1,'2022-09-06 23:16:00','2022-09-06 23:16:00',NULL),(581,7768,40728,13760,3,581,'App\\Models\\Receipt',581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',1370.09,NULL,NULL,1,'2022-09-06 23:16:00','2022-10-01 09:20:15','2022-10-01 09:20:15'),(582,7768,40728,13760,3,582,'App\\Models\\Receipt',582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',21599.00,NULL,NULL,1,'2022-09-06 23:16:00','2022-09-06 23:16:00',NULL);
INSERT INTO `balance_libro` VALUES (583,7768,40728,13760,3,583,'App\\Models\\Receipt',583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',4641.00,NULL,NULL,1,'2022-09-06 23:16:00','2022-09-06 23:16:00',NULL),(584,7768,40728,13760,3,584,'App\\Models\\Receipt',584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',3501.10,NULL,NULL,1,'2022-09-06 23:16:00','2022-11-07 08:52:41','2022-11-07 08:52:41'),(585,7768,40728,13760,3,585,'App\\Models\\Receipt',585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',2310.00,NULL,NULL,1,'2022-09-06 23:16:00','2022-09-06 23:16:00',NULL),(586,7768,40728,13760,3,586,'App\\Models\\Receipt',586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',1059.70,NULL,NULL,1,'2022-09-06 23:16:00','2022-09-06 23:16:00',NULL),(587,7768,40728,13760,3,587,'App\\Models\\Receipt',587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',3982.00,NULL,NULL,1,'2022-09-06 23:16:00','2022-11-07 08:52:24','2022-11-07 08:52:24'),(588,7768,40728,13760,3,588,'App\\Models\\Receipt',588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',3480.80,NULL,NULL,1,'2022-09-06 23:16:00','2022-09-06 23:16:00',NULL),(589,7768,40728,13760,3,589,'App\\Models\\Receipt',589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',2900.00,NULL,NULL,1,'2022-09-06 23:16:00','2022-11-07 08:52:04','2022-11-07 08:52:04'),(590,7768,40728,13760,3,590,'App\\Models\\Receipt',590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',3400.67,NULL,NULL,1,'2022-09-06 23:16:00','2022-09-06 23:16:00',NULL),(591,7768,40728,13760,3,591,'App\\Models\\Receipt',591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',3900.00,NULL,NULL,1,'2022-09-06 23:16:00','2022-11-07 08:51:46','2022-11-07 08:51:46'),(592,7768,40728,13760,3,592,'App\\Models\\Receipt',592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',4147.19,NULL,NULL,1,'2022-09-06 23:16:00','2022-11-15 12:25:06','2022-11-15 12:25:06'),(593,7768,40728,13760,3,593,'App\\Models\\Receipt',593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',2000.57,NULL,NULL,1,'2022-09-06 23:16:00','2022-11-07 08:13:57','2022-11-07 08:13:57'),(594,7768,40728,13760,3,594,'App\\Models\\Receipt',594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',3003.26,NULL,NULL,1,'2022-09-06 23:16:00','2022-11-07 08:37:10','2022-11-07 08:37:10'),(595,7768,40728,13760,3,595,'App\\Models\\Receipt',595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',3000.34,NULL,NULL,1,'2022-09-06 23:16:00','2022-11-07 08:36:47','2022-11-07 08:36:47'),(596,7768,40728,13760,3,596,'App\\Models\\Receipt',596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',6401.32,NULL,NULL,1,'2022-09-06 23:16:00','2022-11-07 08:36:17','2022-11-07 08:36:17'),(597,7768,40728,13760,3,597,'App\\Models\\Receipt',597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',3000.42,NULL,NULL,1,'2022-09-06 23:16:00','2022-11-07 08:35:49','2022-11-07 08:35:49'),(598,7768,40728,13760,3,598,'App\\Models\\Receipt',598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-13','2021-06-13',3700.36,NULL,NULL,1,'2022-09-06 23:16:00','2022-11-07 08:35:33','2022-11-07 08:35:33'),(599,7768,40728,13760,3,599,'App\\Models\\Receipt',599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-13','2021-06-13',6834.15,NULL,NULL,1,'2022-09-06 23:16:00','2022-11-07 08:35:10','2022-11-07 08:35:10'),(600,7768,40728,13760,3,600,'App\\Models\\Receipt',600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-13','2021-06-13',5232.33,NULL,NULL,1,'2022-09-06 23:16:00','2022-11-07 08:34:55','2022-11-07 08:34:55'),(601,7768,40728,13760,3,601,'App\\Models\\Receipt',601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2001.46,NULL,NULL,1,'2022-09-06 23:16:00','2022-11-07 08:34:38','2022-11-07 08:34:38'),(602,7768,40728,13760,3,602,'App\\Models\\Receipt',602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2600.43,NULL,NULL,1,'2022-09-06 23:16:01','2022-11-07 08:33:55','2022-11-07 08:33:55');
INSERT INTO `balance_libro` VALUES (603,7768,40728,13760,3,603,'App\\Models\\Receipt',603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',4502.91,NULL,NULL,1,'2022-09-06 23:16:01','2022-11-07 08:33:35','2022-11-07 08:33:35'),(604,7768,40728,13760,3,604,'App\\Models\\Receipt',604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',3517.79,NULL,NULL,1,'2022-09-06 23:16:01','2022-11-07 08:33:16','2022-11-07 08:33:16'),(605,7768,40728,13760,3,605,'App\\Models\\Receipt',605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',5000.17,NULL,NULL,1,'2022-09-06 23:16:01','2022-11-07 08:32:58','2022-11-07 08:32:58'),(606,7768,40728,13760,3,606,'App\\Models\\Receipt',606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',3000.34,NULL,NULL,1,'2022-09-06 23:16:01','2022-11-07 08:32:38','2022-11-07 08:32:38'),(607,7768,40728,13760,3,607,'App\\Models\\Receipt',607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',2000.84,NULL,NULL,1,'2022-09-06 23:16:01','2022-11-07 08:32:22','2022-11-07 08:32:22'),(608,7768,40728,13760,3,608,'App\\Models\\Receipt',608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',4860.00,NULL,NULL,1,'2022-09-06 23:16:01','2022-11-07 08:32:04','2022-11-07 08:32:04'),(609,7768,40728,13760,3,609,'App\\Models\\Receipt',609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',4001.86,NULL,NULL,1,'2022-09-06 23:16:01','2022-11-07 08:31:46','2022-11-07 08:31:46'),(610,7768,40728,13760,3,610,'App\\Models\\Receipt',610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',2501.47,NULL,NULL,1,'2022-09-06 23:16:01','2022-11-07 08:31:29','2022-11-07 08:31:29'),(611,7768,40728,13760,3,611,'App\\Models\\Receipt',611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',5079.06,NULL,NULL,1,'2022-09-06 23:16:01','2022-11-07 08:31:04','2022-11-07 08:31:04'),(612,7768,40728,13760,3,612,'App\\Models\\Receipt',612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',1501.63,NULL,NULL,1,'2022-09-06 23:16:01','2022-11-07 08:30:30','2022-11-07 08:30:30'),(613,7768,40728,13760,3,613,'App\\Models\\Receipt',613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',3003.39,NULL,NULL,1,'2022-09-06 23:16:01','2022-11-07 08:30:14','2022-11-07 08:30:14'),(614,7768,40728,13760,3,614,'App\\Models\\Receipt',614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',4000.12,NULL,NULL,1,'2022-09-06 23:16:01','2022-11-07 08:29:57','2022-11-07 08:29:57'),(615,7768,40728,13760,3,615,'App\\Models\\Receipt',615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',5000.91,NULL,NULL,1,'2022-09-06 23:16:01','2022-11-07 08:29:36','2022-11-07 08:29:36'),(616,7768,40728,13760,3,616,'App\\Models\\Receipt',616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',2500.96,NULL,NULL,1,'2022-09-06 23:16:01','2022-11-07 08:29:08','2022-11-07 08:29:08'),(617,7768,40728,13760,3,617,'App\\Models\\Receipt',617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',3001.36,NULL,NULL,1,'2022-09-06 23:16:01','2022-11-07 08:28:47','2022-11-07 08:28:47'),(618,7768,40728,13760,3,618,'App\\Models\\Receipt',618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',3001.36,NULL,NULL,1,'2022-09-06 23:16:01','2022-11-07 08:28:26','2022-11-07 08:28:26'),(619,7768,40728,13760,3,619,'App\\Models\\Receipt',619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',4101.62,NULL,NULL,1,'2022-09-06 23:16:01','2022-11-07 08:27:54','2022-11-07 08:27:54'),(620,7768,40728,13760,3,620,'App\\Models\\Receipt',620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',2500.96,NULL,NULL,1,'2022-09-06 23:16:02','2022-11-07 08:27:29','2022-11-07 08:27:29'),(621,7768,40728,13760,3,621,'App\\Models\\Receipt',621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',2001.24,NULL,NULL,1,'2022-09-06 23:16:02','2022-11-07 08:24:45','2022-11-07 08:24:45');
INSERT INTO `balance_libro` VALUES (622,7768,40728,13760,3,622,'App\\Models\\Receipt',622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2000.28,NULL,NULL,1,'2022-09-06 23:16:02','2022-11-07 08:22:57','2022-11-07 08:22:57'),(623,7768,40728,13760,3,623,'App\\Models\\Receipt',623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',3801.18,NULL,NULL,1,'2022-09-06 23:16:02','2022-11-07 08:22:34','2022-11-07 08:22:34'),(624,7768,40728,13760,3,624,'App\\Models\\Receipt',624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',1501.19,NULL,NULL,1,'2022-09-06 23:16:02','2022-11-07 08:21:58','2022-11-07 08:21:58'),(625,7768,40728,13760,3,625,'App\\Models\\Receipt',625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',4181.01,NULL,NULL,1,'2022-09-06 23:16:02','2022-11-07 08:21:40','2022-11-07 08:21:40'),(626,7768,40728,13760,3,626,'App\\Models\\Receipt',626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',1001.09,NULL,NULL,1,'2022-09-06 23:16:02','2022-11-07 08:21:19','2022-11-07 08:21:19'),(627,7768,40728,13760,3,627,'App\\Models\\Receipt',627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',1483.39,NULL,NULL,1,'2022-09-06 23:16:02','2022-11-07 08:21:03','2022-11-07 08:21:03'),(628,7768,40728,13760,3,628,'App\\Models\\Receipt',628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',1474.80,NULL,NULL,1,'2022-09-06 23:16:02','2022-11-07 08:20:41','2022-11-07 08:20:41'),(629,7768,40728,13760,3,629,'App\\Models\\Receipt',629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',1000.03,NULL,NULL,1,'2022-09-06 23:16:02','2022-11-07 08:20:19','2022-11-07 08:20:19'),(630,7768,40728,13760,3,630,'App\\Models\\Receipt',630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',3001.36,NULL,NULL,1,'2022-09-06 23:16:02','2022-11-07 08:19:36','2022-11-07 08:19:36'),(631,7768,40728,13760,3,631,'App\\Models\\Receipt',631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',1137.78,NULL,NULL,1,'2022-09-06 23:16:02','2022-11-07 08:19:23','2022-11-07 08:19:23'),(632,7768,40728,13760,3,632,'App\\Models\\Receipt',632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',3000.34,NULL,NULL,1,'2022-09-06 23:16:02','2022-11-07 08:14:41','2022-11-07 08:14:41'),(633,7768,40728,13760,3,633,'App\\Models\\Receipt',633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',1740.00,NULL,NULL,1,'2022-09-06 23:16:02','2022-11-07 08:18:19','2022-11-07 08:18:19'),(634,7768,40728,13760,3,634,'App\\Models\\Receipt',634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',1501.63,NULL,NULL,1,'2022-09-06 23:16:02','2022-11-07 08:17:56','2022-11-07 08:17:56'),(635,7768,40728,13760,3,635,'App\\Models\\Receipt',635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',3150.00,NULL,NULL,1,'2022-09-06 23:16:02','2022-11-07 08:17:24','2022-11-07 08:17:24'),(636,7768,40728,13760,3,636,'App\\Models\\Receipt',636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',2159.16,NULL,NULL,1,'2022-09-06 23:16:02','2022-11-07 08:16:56','2022-11-07 08:16:56'),(637,7768,40728,13760,3,637,'App\\Models\\Receipt',637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',500.00,NULL,NULL,1,'2022-09-06 23:16:02','2022-11-07 08:16:38','2022-11-07 08:16:38'),(638,7768,40728,13760,3,638,'App\\Models\\Receipt',638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',1894.63,NULL,NULL,1,'2022-09-06 23:16:02','2022-11-07 08:16:08','2022-11-07 08:16:08'),(653,7768,40728,13779,3,653,'App\\Models\\Receipt',653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',1585.82,NULL,NULL,1,'2022-09-06 23:17:39','2022-09-07 19:55:57','2022-09-07 19:55:57'),(654,7768,40728,13779,3,654,'App\\Models\\Receipt',654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',578.26,NULL,NULL,1,'2022-09-06 23:17:39','2022-09-07 19:55:49','2022-09-07 19:55:49');
INSERT INTO `balance_libro` VALUES (655,7768,40728,13779,3,655,'App\\Models\\Receipt',655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',19300.04,NULL,NULL,1,'2022-09-06 23:17:39','2022-09-07 19:52:07','2022-09-07 19:52:07'),(656,7768,40728,13779,3,656,'App\\Models\\Receipt',656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',29149.78,NULL,NULL,1,'2022-09-06 23:17:40','2022-09-07 19:55:41','2022-09-07 19:55:41'),(657,7768,40728,13779,3,657,'App\\Models\\Receipt',657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',6386.38,NULL,NULL,1,'2022-09-06 23:17:40','2022-09-07 19:55:34','2022-09-07 19:55:34'),(658,7768,40728,13779,3,658,'App\\Models\\Receipt',658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',17600.00,NULL,NULL,1,'2022-09-06 23:17:40','2022-09-07 19:50:08','2022-09-07 19:50:08'),(659,7768,40728,13779,3,659,'App\\Models\\Receipt',659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',3960.06,NULL,NULL,1,'2022-09-06 23:17:40','2022-09-07 19:55:27','2022-09-07 19:55:27'),(660,7768,40728,13779,3,660,'App\\Models\\Receipt',660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',10023.82,NULL,NULL,1,'2022-09-06 23:17:40','2022-09-07 19:55:19','2022-09-07 19:55:19'),(661,7768,40728,13779,3,661,'App\\Models\\Receipt',661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',19935.00,NULL,NULL,1,'2022-09-06 23:17:40','2022-09-07 19:55:11','2022-09-07 19:55:11'),(662,7768,40728,13779,3,662,'App\\Models\\Receipt',662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',331500.00,NULL,NULL,1,'2022-09-06 23:17:40','2022-09-07 19:55:03','2022-09-07 19:55:03'),(663,7768,40728,13779,3,663,'App\\Models\\Receipt',663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',900.00,NULL,NULL,1,'2022-09-06 23:17:40','2022-09-07 19:54:56','2022-09-07 19:54:56'),(664,7768,40728,13779,3,664,'App\\Models\\Receipt',664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',2489.97,NULL,NULL,1,'2022-09-06 23:17:40','2022-09-07 19:54:49','2022-09-07 19:54:49'),(665,7768,40728,13779,3,665,'App\\Models\\Receipt',665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',866.08,NULL,NULL,1,'2022-09-06 23:17:40','2022-09-07 19:54:42','2022-09-07 19:54:42'),(666,7768,40728,13779,3,666,'App\\Models\\Receipt',666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',188247.59,NULL,NULL,1,'2022-09-06 23:17:40','2022-09-07 19:54:34','2022-09-07 19:54:34'),(667,7768,40728,13779,3,667,'App\\Models\\Receipt',667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',3200.01,NULL,NULL,1,'2022-09-06 23:17:40','2022-09-07 19:54:25','2022-09-07 19:54:25'),(668,7768,40728,13779,3,668,'App\\Models\\Receipt',668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',4100.59,NULL,NULL,1,'2022-09-06 23:17:40','2022-09-07 19:54:16','2022-09-07 19:54:16'),(669,7768,40728,13779,3,669,'App\\Models\\Receipt',669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',4100.00,NULL,NULL,1,'2022-09-06 23:17:40','2022-09-07 19:54:08','2022-09-07 19:54:08'),(670,7768,40728,13779,3,670,'App\\Models\\Receipt',670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',3900.09,NULL,NULL,1,'2022-09-06 23:17:40','2022-09-07 19:53:59','2022-09-07 19:53:59'),(671,7768,40728,13779,3,671,'App\\Models\\Receipt',671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',2235.15,NULL,NULL,1,'2022-09-06 23:17:40','2022-09-07 19:53:49','2022-09-07 19:53:49'),(672,7768,40728,13779,3,672,'App\\Models\\Receipt',672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',4313.95,NULL,NULL,1,'2022-09-06 23:17:40','2022-09-07 19:53:42','2022-09-07 19:53:42'),(673,7768,40728,13779,3,673,'App\\Models\\Receipt',673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',4122.71,NULL,NULL,1,'2022-09-06 23:17:40','2022-09-07 19:53:32','2022-09-07 19:53:32');
INSERT INTO `balance_libro` VALUES (674,7768,40728,13779,3,674,'App\\Models\\Receipt',674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',3000.11,NULL,NULL,1,'2022-09-06 23:17:40','2022-09-07 19:53:23','2022-09-07 19:53:23'),(675,7768,40728,13779,3,675,'App\\Models\\Receipt',675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',3904.50,NULL,NULL,1,'2022-09-06 23:17:41','2022-09-07 19:53:15','2022-09-07 19:53:15'),(676,7768,40728,13779,3,676,'App\\Models\\Receipt',676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',392.97,NULL,NULL,1,'2022-09-06 23:17:41','2022-09-07 19:53:07','2022-09-07 19:53:07'),(677,7768,40728,13779,3,677,'App\\Models\\Receipt',677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',2539.94,NULL,NULL,1,'2022-09-06 23:17:41','2022-09-07 19:52:56','2022-09-07 19:52:56'),(678,7768,40728,13779,3,678,'App\\Models\\Receipt',678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',0.03,NULL,NULL,1,'2022-09-06 23:17:41','2022-09-07 19:52:46','2022-09-07 19:52:46'),(679,7768,40728,13779,3,679,'App\\Models\\Receipt',679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',14253.76,NULL,NULL,1,'2022-09-06 23:17:41','2022-09-07 19:52:19','2022-09-07 19:52:19'),(692,7768,40728,13763,2,692,'App\\Models\\Receipt',692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',228659.50,NULL,NULL,1,'2022-09-06 23:25:37','2022-09-06 23:25:37',NULL),(693,7768,40728,13763,2,693,'App\\Models\\Receipt',693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',313195.18,NULL,NULL,1,'2022-09-06 23:25:37','2022-09-06 23:25:37',NULL),(694,7768,40728,13763,2,694,'App\\Models\\Receipt',694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',707245.00,NULL,NULL,1,'2022-09-06 23:25:37','2022-09-06 23:25:37',NULL),(755,7768,40728,13764,3,755,'App\\Models\\Receipt',755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',21964.80,NULL,NULL,1,'2022-09-06 23:28:13','2022-09-06 23:28:13',NULL),(756,7768,40728,13764,3,756,'App\\Models\\Receipt',756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',20534.88,NULL,NULL,1,'2022-09-06 23:28:13','2022-09-06 23:28:13',NULL),(757,7768,40728,13764,3,757,'App\\Models\\Receipt',757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',4719.00,NULL,NULL,1,'2022-09-06 23:28:13','2022-09-06 23:28:13',NULL),(758,7768,40728,13764,3,758,'App\\Models\\Receipt',758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-02','2021-10-02',4234.76,NULL,NULL,1,'2022-09-06 23:28:13','2022-09-06 23:28:13',NULL),(759,7768,40728,13764,3,759,'App\\Models\\Receipt',759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-02','2021-10-02',2026.45,NULL,NULL,1,'2022-09-06 23:28:13','2022-09-06 23:28:13',NULL),(760,7768,40728,13764,3,760,'App\\Models\\Receipt',760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',99.99,NULL,NULL,1,'2022-09-06 23:28:13','2022-09-06 23:28:13',NULL),(761,7768,40728,13764,3,761,'App\\Models\\Receipt',761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',81909.99,NULL,NULL,1,'2022-09-06 23:28:13','2022-09-06 23:28:13',NULL),(762,7768,40728,13764,3,762,'App\\Models\\Receipt',762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',4706.00,NULL,NULL,1,'2022-09-06 23:28:13','2022-09-06 23:28:13',NULL),(763,7768,40728,13764,3,763,'App\\Models\\Receipt',763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',77814.49,NULL,NULL,1,'2022-09-06 23:28:13','2022-09-06 23:28:13',NULL),(764,7768,40728,13764,3,764,'App\\Models\\Receipt',764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',3332.93,NULL,NULL,1,'2022-09-06 23:28:13','2022-10-01 10:00:03','2022-10-01 10:00:03'),(765,7768,40728,13764,3,765,'App\\Models\\Receipt',765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',7300.00,NULL,NULL,1,'2022-09-06 23:28:13','2022-09-06 23:28:13',NULL);
INSERT INTO `balance_libro` VALUES (766,7768,40728,13764,3,766,'App\\Models\\Receipt',766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',81909.99,NULL,NULL,1,'2022-09-06 23:28:13','2022-09-06 23:28:13',NULL),(767,7768,40728,13764,3,767,'App\\Models\\Receipt',767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',17800.00,NULL,NULL,1,'2022-09-06 23:28:13','2022-09-06 23:28:13',NULL),(768,7768,40728,13764,3,768,'App\\Models\\Receipt',768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',6878.23,NULL,NULL,1,'2022-09-06 23:28:13','2022-09-06 23:28:13',NULL),(769,7768,40728,13764,3,769,'App\\Models\\Receipt',769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',35733.05,NULL,NULL,1,'2022-09-06 23:28:14','2022-09-06 23:28:14',NULL),(770,7768,40728,13764,3,770,'App\\Models\\Receipt',770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',35733.05,NULL,NULL,1,'2022-09-06 23:28:14','2022-09-06 23:28:14',NULL),(771,7768,40728,13764,3,771,'App\\Models\\Receipt',771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',6878.23,NULL,NULL,1,'2022-09-06 23:28:14','2022-09-06 23:28:14',NULL),(772,7768,40728,13764,3,772,'App\\Models\\Receipt',772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',22589.90,NULL,NULL,1,'2022-09-06 23:28:14','2022-09-06 23:28:14',NULL),(773,7768,40728,13764,3,773,'App\\Models\\Receipt',773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',35733.05,NULL,NULL,1,'2022-09-06 23:28:14','2022-09-06 23:28:14',NULL),(774,7768,40728,13764,3,774,'App\\Models\\Receipt',774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',6878.23,NULL,NULL,1,'2022-09-06 23:28:14','2022-09-06 23:28:14',NULL),(775,7768,40728,13764,3,775,'App\\Models\\Receipt',775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',4685.80,NULL,NULL,1,'2022-09-06 23:28:14','2022-09-06 23:28:14',NULL),(776,7768,40728,13764,3,776,'App\\Models\\Receipt',776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',1450.00,NULL,NULL,1,'2022-09-06 23:28:14','2022-09-06 23:28:14',NULL),(777,7768,40728,13764,3,777,'App\\Models\\Receipt',777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',3580.30,NULL,NULL,1,'2022-09-06 23:28:14','2022-11-15 12:24:06','2022-11-15 12:24:06'),(778,7768,40728,13764,3,778,'App\\Models\\Receipt',778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-10','2021-10-10',5802.95,NULL,NULL,1,'2022-09-06 23:28:14','2022-09-06 23:28:14',NULL),(779,7768,40728,13764,3,779,'App\\Models\\Receipt',779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-10','2021-10-10',4056.58,NULL,NULL,1,'2022-09-06 23:28:14','2022-11-07 08:51:28','2022-11-07 08:51:28'),(780,7768,40728,13764,3,780,'App\\Models\\Receipt',780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',4952.45,NULL,NULL,1,'2022-09-06 23:28:14','2022-11-07 08:51:09','2022-11-07 08:51:09'),(781,7768,40728,13764,3,781,'App\\Models\\Receipt',781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',3231.28,NULL,NULL,1,'2022-09-06 23:28:14','2022-09-06 23:28:14',NULL),(782,7768,40728,13764,3,782,'App\\Models\\Receipt',782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',5000.31,NULL,NULL,1,'2022-09-06 23:28:14','2022-09-06 23:28:14',NULL),(783,7768,40728,13764,3,783,'App\\Models\\Receipt',783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',4359.56,NULL,NULL,1,'2022-09-06 23:28:14','2022-11-07 08:37:59','2022-11-07 08:37:59'),(784,7768,40728,13764,3,784,'App\\Models\\Receipt',784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-17','2021-10-17',3880.01,NULL,NULL,1,'2022-09-06 23:28:14','2022-11-15 12:23:50','2022-11-15 12:23:50'),(785,7768,40728,13764,3,785,'App\\Models\\Receipt',785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',3349.90,NULL,NULL,1,'2022-09-06 23:28:14','2022-11-07 08:50:57','2022-11-07 08:50:57');
INSERT INTO `balance_libro` VALUES (786,7768,40728,13764,3,786,'App\\Models\\Receipt',786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-24','2021-10-24',3777.11,NULL,NULL,1,'2022-09-06 23:28:14','2022-11-15 12:50:16','2022-11-15 12:50:16'),(787,7768,40728,13764,3,787,'App\\Models\\Receipt',787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',2800.00,NULL,NULL,1,'2022-09-06 23:28:14','2022-11-08 15:33:49','2022-11-08 15:33:49'),(788,7768,40728,13764,3,788,'App\\Models\\Receipt',788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',4300.17,NULL,NULL,1,'2022-09-06 23:28:14','2022-09-06 23:28:14',NULL),(789,7768,40728,13764,3,789,'App\\Models\\Receipt',789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',7955.80,NULL,NULL,1,'2022-09-06 23:28:14','2022-11-08 15:42:36','2022-11-08 15:42:36'),(790,7768,40728,13764,3,790,'App\\Models\\Receipt',790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',1645.16,NULL,NULL,1,'2022-09-06 23:28:14','2022-09-06 23:28:14',NULL),(791,7768,40728,13764,2,791,'App\\Models\\Receipt',791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',707245.00,NULL,NULL,1,'2022-09-06 23:28:47','2022-09-06 23:28:47',NULL),(792,7768,40728,13765,2,792,'App\\Models\\Receipt',792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',954508.50,NULL,NULL,1,'2022-09-06 23:29:18','2022-09-06 23:29:18',NULL),(825,7768,40728,13765,3,825,'App\\Models\\Receipt',825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',4719.00,NULL,NULL,1,'2022-09-06 23:31:20','2022-09-06 23:31:20',NULL),(826,7768,40728,13765,3,826,'App\\Models\\Receipt',826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',67199.00,NULL,NULL,1,'2022-09-06 23:31:20','2022-11-15 15:04:49','2022-11-15 15:04:49'),(827,7768,40728,13765,3,827,'App\\Models\\Receipt',827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',6746.17,NULL,NULL,1,'2022-09-06 23:31:20','2022-09-06 23:31:20',NULL),(828,7768,40728,13765,3,828,'App\\Models\\Receipt',828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',15013.86,NULL,NULL,1,'2022-09-06 23:31:20','2022-09-06 23:31:20',NULL),(829,7768,40728,13765,3,829,'App\\Models\\Receipt',829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',4049.97,NULL,NULL,1,'2022-09-06 23:31:20','2022-09-06 23:31:20',NULL),(830,7768,40728,13765,3,830,'App\\Models\\Receipt',830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',1121.00,NULL,NULL,1,'2022-09-06 23:31:20','2022-09-06 23:31:20',NULL),(831,7768,40728,13765,3,831,'App\\Models\\Receipt',831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',9740.06,NULL,NULL,1,'2022-09-06 23:31:20','2022-09-06 23:31:20',NULL),(832,7768,40728,13765,3,832,'App\\Models\\Receipt',832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',5200.00,NULL,NULL,1,'2022-09-06 23:31:20','2022-09-06 23:31:20',NULL),(833,7768,40728,13765,3,833,'App\\Models\\Receipt',833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',44704.03,NULL,NULL,1,'2022-09-06 23:31:20','2022-09-06 23:31:20',NULL),(834,7768,40728,13765,3,834,'App\\Models\\Receipt',834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',6860.02,NULL,NULL,1,'2022-09-06 23:31:20','2022-09-06 23:31:20',NULL),(835,7768,40728,13765,3,835,'App\\Models\\Receipt',835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',16242.00,NULL,NULL,1,'2022-09-06 23:31:20','2022-09-06 23:31:20',NULL),(836,7768,40728,13765,3,836,'App\\Models\\Receipt',836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',7500.00,NULL,NULL,1,'2022-09-06 23:31:21','2022-11-08 15:30:29','2022-11-08 15:30:29'),(837,7768,40728,13765,3,837,'App\\Models\\Receipt',837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',7500.00,NULL,NULL,1,'2022-09-06 23:31:21','2022-11-08 15:30:19','2022-11-08 15:30:19');
INSERT INTO `balance_libro` VALUES (838,7768,40728,13765,3,838,'App\\Models\\Receipt',838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',3431.04,NULL,NULL,1,'2022-09-06 23:31:21','2022-10-01 10:02:45','2022-10-01 10:02:45'),(839,7768,40728,13765,3,839,'App\\Models\\Receipt',839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',170.17,NULL,NULL,1,'2022-09-06 23:31:21','2022-09-06 23:31:21',NULL),(840,7768,40728,13765,3,840,'App\\Models\\Receipt',840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-13','2021-11-13',1015.92,NULL,NULL,1,'2022-09-06 23:31:21','2022-09-06 23:31:21',NULL),(841,7768,40728,13765,3,841,'App\\Models\\Receipt',841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-13','2021-11-13',1490.95,NULL,NULL,1,'2022-09-06 23:31:21','2022-09-06 23:31:21',NULL),(842,7768,40728,13765,3,842,'App\\Models\\Receipt',842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-13','2021-11-13',913.30,NULL,NULL,1,'2022-09-06 23:31:21','2022-09-06 23:31:21',NULL),(843,7768,40728,13765,3,843,'App\\Models\\Receipt',843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-13','2021-11-13',9000.00,NULL,NULL,1,'2022-09-06 23:31:21','2022-09-06 23:31:21',NULL),(844,7768,40728,13765,3,844,'App\\Models\\Receipt',844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-14','2021-11-14',3564.60,NULL,NULL,1,'2022-09-06 23:31:21','2022-11-07 08:48:39','2022-11-07 08:48:39'),(845,7768,40728,13765,3,845,'App\\Models\\Receipt',845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',190150.42,NULL,NULL,1,'2022-09-06 23:31:21','2022-11-16 12:46:25','2022-11-16 12:46:25'),(846,7768,40728,13765,3,846,'App\\Models\\Receipt',846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-17','2021-11-17',7400.02,NULL,NULL,1,'2022-09-06 23:31:21','2022-09-06 23:31:21',NULL),(847,7768,40728,13765,3,847,'App\\Models\\Receipt',847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',14911.49,NULL,NULL,1,'2022-09-06 23:31:21','2022-09-06 23:31:21',NULL),(848,7768,40728,13765,3,848,'App\\Models\\Receipt',848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',28560.00,NULL,NULL,1,'2022-09-06 23:31:21','2022-09-06 23:31:21',NULL),(849,7768,40728,13765,3,849,'App\\Models\\Receipt',849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',2000.00,NULL,NULL,1,'2022-09-06 23:31:21','2022-09-06 23:31:21',NULL),(850,7768,40728,13765,3,850,'App\\Models\\Receipt',850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-20','2021-11-20',29390.90,NULL,NULL,1,'2022-09-06 23:31:21','2022-09-06 23:31:21',NULL),(851,7768,40728,13765,3,851,'App\\Models\\Receipt',851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-20','2021-11-20',2698.30,NULL,NULL,1,'2022-09-06 23:31:21','2022-09-06 23:31:21',NULL),(852,7768,40728,13765,3,852,'App\\Models\\Receipt',852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',2600.00,NULL,NULL,1,'2022-09-06 23:31:21','2022-09-06 23:31:21',NULL),(853,7768,40728,13765,3,853,'App\\Models\\Receipt',853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',1070.00,NULL,NULL,1,'2022-09-06 23:31:21','2022-09-06 23:31:21',NULL),(854,7768,40728,13765,3,854,'App\\Models\\Receipt',854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',81750.14,NULL,NULL,1,'2022-09-06 23:31:21','2022-09-06 23:31:21',NULL),(855,7768,40728,13765,3,855,'App\\Models\\Receipt',855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',18994.00,NULL,NULL,1,'2022-09-06 23:31:21','2022-11-15 15:05:16','2022-11-15 15:05:16'),(856,7768,40728,13765,3,856,'App\\Models\\Receipt',856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',300564.00,NULL,NULL,1,'2022-09-06 23:31:21','2022-09-06 23:31:21',NULL),(857,7768,40728,13765,3,857,'App\\Models\\Receipt',857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',4173.32,NULL,NULL,1,'2022-09-06 23:31:22','2022-11-15 12:22:31','2022-11-15 12:22:31');
INSERT INTO `balance_libro` VALUES (858,7768,40728,13765,3,858,'App\\Models\\Receipt',858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-06','2021-11-06',8168.81,NULL,NULL,1,'2022-09-06 23:31:22','2022-09-06 23:31:22',NULL),(859,7768,40728,13765,3,859,'App\\Models\\Receipt',859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',3900.59,NULL,NULL,1,'2022-09-06 23:31:22','2022-11-07 08:48:16','2022-11-07 08:48:16'),(860,7768,40728,13765,3,860,'App\\Models\\Receipt',860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',4000.90,NULL,NULL,1,'2022-09-06 23:31:22','2022-09-06 23:31:22',NULL),(861,7768,40728,13765,3,861,'App\\Models\\Receipt',861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-14','2021-11-14',3564.60,NULL,NULL,1,'2022-09-06 23:31:22','2022-11-07 08:47:55','2022-11-07 08:47:55'),(862,7768,40728,13765,3,862,'App\\Models\\Receipt',862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',4268.66,NULL,NULL,1,'2022-09-06 23:31:22','2022-11-15 12:21:33','2022-11-15 12:21:33'),(863,7768,40728,13765,3,863,'App\\Models\\Receipt',863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',4284.46,NULL,NULL,1,'2022-09-06 23:31:22','2022-11-15 12:21:21','2022-11-15 12:21:21'),(864,7768,40728,13765,3,864,'App\\Models\\Receipt',864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',16132.10,NULL,NULL,1,'2022-09-06 23:31:22','2022-11-08 15:42:27','2022-11-08 15:42:27'),(913,7768,40728,13782,3,913,'App\\Models\\Receipt',913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',4719.00,NULL,NULL,1,'2022-09-07 19:09:37','2022-09-07 19:32:11','2022-09-07 19:32:11'),(914,7768,40728,13782,3,914,'App\\Models\\Receipt',914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-04','2021-12-04',7500.00,NULL,NULL,1,'2022-09-07 19:09:37','2022-09-07 19:32:11','2022-09-07 19:32:11'),(915,7768,40728,13782,3,915,'App\\Models\\Receipt',915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-05','2021-12-05',4382.75,NULL,NULL,1,'2022-09-07 19:09:38','2022-09-07 19:32:11','2022-09-07 19:32:11'),(916,7768,40728,13782,3,916,'App\\Models\\Receipt',916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',1277.00,NULL,NULL,1,'2022-09-07 19:09:38','2022-09-07 19:32:11','2022-09-07 19:32:11'),(917,7768,40728,13782,3,917,'App\\Models\\Receipt',917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',2534.45,NULL,NULL,1,'2022-09-07 19:09:38','2022-09-07 19:32:11','2022-09-07 19:32:11'),(918,7768,40728,13782,3,918,'App\\Models\\Receipt',918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-10','2021-12-10',384017.70,NULL,NULL,1,'2022-09-07 19:09:38','2022-09-07 19:32:11','2022-09-07 19:32:11'),(919,7768,40728,13782,3,919,'App\\Models\\Receipt',919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-10','2021-12-10',77678.37,NULL,NULL,1,'2022-09-07 19:09:38','2022-09-07 19:32:11','2022-09-07 19:32:11'),(920,7768,40728,13782,3,920,'App\\Models\\Receipt',920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-13','2021-12-13',4274.20,NULL,NULL,1,'2022-09-07 19:09:38','2022-09-07 19:32:11','2022-09-07 19:32:11'),(921,7768,40728,13782,3,921,'App\\Models\\Receipt',921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',39930.00,NULL,NULL,1,'2022-09-07 19:09:38','2022-09-07 19:32:11','2022-09-07 19:32:11'),(922,7768,40728,13782,3,922,'App\\Models\\Receipt',922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',24321.00,NULL,NULL,1,'2022-09-07 19:09:38','2022-09-07 19:32:11','2022-09-07 19:32:11'),(923,7768,40728,13782,3,923,'App\\Models\\Receipt',923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-15','2021-12-15',7328.07,NULL,NULL,1,'2022-09-07 19:09:38','2022-09-07 19:32:11','2022-09-07 19:32:11'),(924,7768,40728,13782,3,924,'App\\Models\\Receipt',924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',22084.92,NULL,NULL,1,'2022-09-07 19:09:38','2022-09-07 19:32:11','2022-09-07 19:32:11');
INSERT INTO `balance_libro` VALUES (925,7768,40728,13782,3,925,'App\\Models\\Receipt',925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',9146.58,NULL,NULL,1,'2022-09-07 19:09:38','2022-09-07 19:32:11','2022-09-07 19:32:11'),(926,7768,40728,13782,3,926,'App\\Models\\Receipt',926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',45406.93,NULL,NULL,1,'2022-09-07 19:09:38','2022-09-07 19:32:11','2022-09-07 19:32:11'),(927,7768,40728,13782,3,927,'App\\Models\\Receipt',927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',360580.00,NULL,NULL,1,'2022-09-07 19:09:38','2022-09-07 19:32:11','2022-09-07 19:32:11'),(928,7768,40728,13782,3,928,'App\\Models\\Receipt',928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',4156.90,NULL,NULL,1,'2022-09-07 19:09:39','2022-09-07 19:32:11','2022-09-07 19:32:11'),(929,7768,40728,13782,3,929,'App\\Models\\Receipt',929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',823.01,NULL,NULL,1,'2022-09-07 19:09:39','2022-09-07 19:32:11','2022-09-07 19:32:11'),(930,7768,40728,13782,3,930,'App\\Models\\Receipt',930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-21','2021-12-21',4165.01,NULL,NULL,1,'2022-09-07 19:09:39','2022-09-07 19:32:11','2022-09-07 19:32:11'),(931,7768,40728,13782,3,931,'App\\Models\\Receipt',931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-21','2021-12-21',6582.00,NULL,NULL,1,'2022-09-07 19:09:39','2022-09-07 19:32:11','2022-09-07 19:32:11'),(932,7768,40728,13782,3,932,'App\\Models\\Receipt',932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',28381.25,NULL,NULL,1,'2022-09-07 19:09:39','2022-09-07 19:32:11','2022-09-07 19:32:11'),(933,7768,40728,13782,3,933,'App\\Models\\Receipt',933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',480.04,NULL,NULL,1,'2022-09-07 19:09:39','2022-09-07 19:32:11','2022-09-07 19:32:11'),(934,7768,40728,13782,3,934,'App\\Models\\Receipt',934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',22991.21,NULL,NULL,1,'2022-09-07 19:09:39','2022-09-07 19:32:11','2022-09-07 19:32:11'),(935,7768,40728,13782,3,935,'App\\Models\\Receipt',935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',54451.28,NULL,NULL,1,'2022-09-07 19:09:39','2022-09-07 19:32:11','2022-09-07 19:32:11'),(936,7768,40728,13782,3,936,'App\\Models\\Receipt',936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-24','2021-12-24',4055.12,NULL,NULL,1,'2022-09-07 19:09:39','2022-09-07 19:32:11','2022-09-07 19:32:11'),(937,7768,40728,13782,3,937,'App\\Models\\Receipt',937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',22160.00,NULL,NULL,1,'2022-09-07 19:09:39','2022-09-07 19:32:11','2022-09-07 19:32:11'),(938,7768,40728,13782,3,938,'App\\Models\\Receipt',938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-29','2021-12-29',22506.00,NULL,NULL,1,'2022-09-07 19:09:39','2022-09-07 19:32:11','2022-09-07 19:32:11'),(939,7768,40728,13782,3,939,'App\\Models\\Receipt',939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',34185.38,NULL,NULL,1,'2022-09-07 19:09:39','2022-09-07 19:32:11','2022-09-07 19:32:11'),(940,7768,40728,13782,3,940,'App\\Models\\Receipt',940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',7500.00,NULL,NULL,1,'2022-09-07 19:09:39','2022-09-07 19:32:11','2022-09-07 19:32:11'),(941,7768,40728,13782,3,941,'App\\Models\\Receipt',941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',4219.36,NULL,NULL,1,'2022-09-07 19:09:39','2022-09-07 19:32:11','2022-09-07 19:32:11'),(942,7768,40728,13782,3,942,'App\\Models\\Receipt',942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-22','2021-11-22',3800.50,NULL,NULL,1,'2022-09-07 19:09:39','2022-09-07 19:32:11','2022-09-07 19:32:11'),(943,7768,40728,13782,3,943,'App\\Models\\Receipt',943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',2702.30,NULL,NULL,1,'2022-09-07 19:09:39','2022-09-07 19:32:11','2022-09-07 19:32:11');
INSERT INTO `balance_libro` VALUES (944,7768,40728,13782,3,944,'App\\Models\\Receipt',944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-21','2021-12-21',4165.01,NULL,NULL,1,'2022-09-07 19:09:40','2022-09-07 19:32:11','2022-09-07 19:32:11'),(945,7768,40728,13782,3,945,'App\\Models\\Receipt',945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-24','2021-12-24',4055.12,NULL,NULL,1,'2022-09-07 19:09:40','2022-09-07 19:32:11','2022-09-07 19:32:11'),(946,7768,40728,13782,3,946,'App\\Models\\Receipt',946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',4156.90,NULL,NULL,1,'2022-09-07 19:09:40','2022-09-07 19:32:11','2022-09-07 19:32:11'),(947,7768,40728,13782,3,947,'App\\Models\\Receipt',947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',4002.65,NULL,NULL,1,'2022-09-07 19:09:40','2022-09-07 19:32:11','2022-09-07 19:32:11'),(948,7768,40728,13782,3,948,'App\\Models\\Receipt',948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-05','2021-12-05',4382.75,NULL,NULL,1,'2022-09-07 19:09:40','2022-09-07 19:32:11','2022-09-07 19:32:11'),(949,7768,40728,13782,3,949,'App\\Models\\Receipt',949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',2534.45,NULL,NULL,1,'2022-09-07 19:09:40','2022-09-07 19:32:11','2022-09-07 19:32:11'),(950,7768,40728,13782,3,950,'App\\Models\\Receipt',950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-11','2021-12-11',4283.71,NULL,NULL,1,'2022-09-07 19:09:40','2022-09-07 19:32:11','2022-09-07 19:32:11'),(951,7768,40728,13782,3,951,'App\\Models\\Receipt',951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',5749.17,NULL,NULL,1,'2022-09-07 19:09:40','2022-09-07 19:32:11','2022-09-07 19:32:11'),(952,7768,40728,13782,3,952,'App\\Models\\Receipt',952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',19926.15,NULL,NULL,1,'2022-09-07 19:09:40','2022-09-07 19:32:11','2022-09-07 19:32:11'),(953,7768,40728,13782,3,953,'App\\Models\\Receipt',953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-12','2021-12-12',2027.51,NULL,NULL,1,'2022-09-07 19:09:40','2022-09-07 19:32:11','2022-09-07 19:32:11'),(954,7768,40728,13782,3,954,'App\\Models\\Receipt',954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',9380.00,NULL,NULL,1,'2022-09-07 19:09:40','2022-09-07 19:32:11','2022-09-07 19:32:11'),(955,7768,40728,13782,3,955,'App\\Models\\Receipt',955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',15813.29,NULL,NULL,1,'2022-09-07 19:09:40','2022-09-07 19:32:11','2022-09-07 19:32:11'),(956,7768,40728,13784,2,956,'App\\Models\\Receipt',956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-07','2021-12-07',363000.00,NULL,NULL,1,'2022-09-07 19:35:16','2022-09-07 19:59:24','2022-09-07 19:59:24'),(957,7768,40728,13784,2,957,'App\\Models\\Receipt',957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-28','2021-12-28',30125.37,NULL,NULL,1,'2022-09-07 19:35:16','2022-09-07 19:59:24','2022-09-07 19:59:24'),(958,7768,40728,13784,3,958,'App\\Models\\Receipt',958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',4719.00,NULL,NULL,1,'2022-09-07 19:35:27','2022-09-07 19:59:27','2022-09-07 19:59:27'),(959,7768,40728,13784,3,959,'App\\Models\\Receipt',959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-04','2021-12-04',7500.00,NULL,NULL,1,'2022-09-07 19:35:27','2022-09-07 19:59:27','2022-09-07 19:59:27'),(960,7768,40728,13784,3,960,'App\\Models\\Receipt',960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-05','2021-12-05',4382.75,NULL,NULL,1,'2022-09-07 19:35:27','2022-09-07 19:59:27','2022-09-07 19:59:27'),(961,7768,40728,13784,3,961,'App\\Models\\Receipt',961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',1277.00,NULL,NULL,1,'2022-09-07 19:35:27','2022-09-07 19:59:27','2022-09-07 19:59:27'),(962,7768,40728,13784,3,962,'App\\Models\\Receipt',962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',2534.45,NULL,NULL,1,'2022-09-07 19:35:27','2022-09-07 19:59:27','2022-09-07 19:59:27');
INSERT INTO `balance_libro` VALUES (963,7768,40728,13784,3,963,'App\\Models\\Receipt',963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-10','2021-12-10',384017.70,NULL,NULL,1,'2022-09-07 19:35:27','2022-09-07 19:59:27','2022-09-07 19:59:27'),(964,7768,40728,13784,3,964,'App\\Models\\Receipt',964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-10','2021-12-10',77678.37,NULL,NULL,1,'2022-09-07 19:35:27','2022-09-07 19:59:27','2022-09-07 19:59:27'),(965,7768,40728,13784,3,965,'App\\Models\\Receipt',965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-13','2021-12-13',4274.20,NULL,NULL,1,'2022-09-07 19:35:27','2022-09-07 19:59:27','2022-09-07 19:59:27'),(966,7768,40728,13784,3,966,'App\\Models\\Receipt',966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',39930.00,NULL,NULL,1,'2022-09-07 19:35:27','2022-09-07 19:59:27','2022-09-07 19:59:27'),(967,7768,40728,13784,3,967,'App\\Models\\Receipt',967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',24321.00,NULL,NULL,1,'2022-09-07 19:35:27','2022-09-07 19:59:27','2022-09-07 19:59:27'),(968,7768,40728,13784,3,968,'App\\Models\\Receipt',968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-15','2021-12-15',7328.07,NULL,NULL,1,'2022-09-07 19:35:27','2022-09-07 19:59:27','2022-09-07 19:59:27'),(969,7768,40728,13784,3,969,'App\\Models\\Receipt',969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',22084.92,NULL,NULL,1,'2022-09-07 19:35:27','2022-09-07 19:59:27','2022-09-07 19:59:27'),(970,7768,40728,13784,3,970,'App\\Models\\Receipt',970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',9146.58,NULL,NULL,1,'2022-09-07 19:35:27','2022-09-07 19:59:27','2022-09-07 19:59:27'),(971,7768,40728,13784,3,971,'App\\Models\\Receipt',971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',45406.93,NULL,NULL,1,'2022-09-07 19:35:27','2022-09-07 19:59:27','2022-09-07 19:59:27'),(972,7768,40728,13784,3,972,'App\\Models\\Receipt',972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',360580.00,NULL,NULL,1,'2022-09-07 19:35:27','2022-09-07 19:59:27','2022-09-07 19:59:27'),(973,7768,40728,13784,3,973,'App\\Models\\Receipt',973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',4156.90,NULL,NULL,1,'2022-09-07 19:35:27','2022-09-07 19:59:27','2022-09-07 19:59:27'),(974,7768,40728,13784,3,974,'App\\Models\\Receipt',974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',823.01,NULL,NULL,1,'2022-09-07 19:35:27','2022-09-07 19:59:27','2022-09-07 19:59:27'),(975,7768,40728,13784,3,975,'App\\Models\\Receipt',975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-21','2021-12-21',4165.01,NULL,NULL,1,'2022-09-07 19:35:27','2022-09-07 19:59:27','2022-09-07 19:59:27'),(976,7768,40728,13784,3,976,'App\\Models\\Receipt',976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-21','2021-12-21',6582.00,NULL,NULL,1,'2022-09-07 19:35:27','2022-09-07 19:59:27','2022-09-07 19:59:27'),(977,7768,40728,13784,3,977,'App\\Models\\Receipt',977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',28381.25,NULL,NULL,1,'2022-09-07 19:35:27','2022-09-07 19:59:27','2022-09-07 19:59:27'),(978,7768,40728,13784,3,978,'App\\Models\\Receipt',978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',480.04,NULL,NULL,1,'2022-09-07 19:35:27','2022-09-07 19:59:27','2022-09-07 19:59:27'),(979,7768,40728,13784,3,979,'App\\Models\\Receipt',979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',22991.21,NULL,NULL,1,'2022-09-07 19:35:27','2022-09-07 19:59:27','2022-09-07 19:59:27'),(980,7768,40728,13784,3,980,'App\\Models\\Receipt',980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',54451.28,NULL,NULL,1,'2022-09-07 19:35:28','2022-09-07 19:59:27','2022-09-07 19:59:27'),(981,7768,40728,13784,3,981,'App\\Models\\Receipt',981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-24','2021-12-24',4055.12,NULL,NULL,1,'2022-09-07 19:35:28','2022-09-07 19:59:27','2022-09-07 19:59:27');
INSERT INTO `balance_libro` VALUES (982,7768,40728,13784,3,982,'App\\Models\\Receipt',982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',22160.00,NULL,NULL,1,'2022-09-07 19:35:28','2022-09-07 19:59:27','2022-09-07 19:59:27'),(983,7768,40728,13784,3,983,'App\\Models\\Receipt',983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-29','2021-12-29',22506.00,NULL,NULL,1,'2022-09-07 19:35:28','2022-09-07 19:59:27','2022-09-07 19:59:27'),(984,7768,40728,13784,3,984,'App\\Models\\Receipt',984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',34185.38,NULL,NULL,1,'2022-09-07 19:35:28','2022-09-07 19:59:27','2022-09-07 19:59:27'),(985,7768,40728,13784,3,985,'App\\Models\\Receipt',985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',7500.00,NULL,NULL,1,'2022-09-07 19:35:28','2022-09-07 19:59:27','2022-09-07 19:59:27'),(986,7768,40728,13784,3,986,'App\\Models\\Receipt',986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',4219.36,NULL,NULL,1,'2022-09-07 19:35:28','2022-09-07 19:59:27','2022-09-07 19:59:27'),(987,7768,40728,13784,3,987,'App\\Models\\Receipt',987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-22','2021-11-22',3800.50,NULL,NULL,1,'2022-09-07 19:35:28','2022-09-07 19:59:27','2022-09-07 19:59:27'),(988,7768,40728,13784,3,988,'App\\Models\\Receipt',988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',2702.30,NULL,NULL,1,'2022-09-07 19:35:28','2022-09-07 19:59:27','2022-09-07 19:59:27'),(989,7768,40728,13784,3,989,'App\\Models\\Receipt',989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-21','2021-12-21',4165.01,NULL,NULL,1,'2022-09-07 19:35:28','2022-09-07 19:59:27','2022-09-07 19:59:27'),(990,7768,40728,13784,3,990,'App\\Models\\Receipt',990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-24','2021-12-24',4055.12,NULL,NULL,1,'2022-09-07 19:35:28','2022-09-07 19:59:27','2022-09-07 19:59:27'),(991,7768,40728,13784,3,991,'App\\Models\\Receipt',991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',4156.90,NULL,NULL,1,'2022-09-07 19:35:28','2022-09-07 19:59:27','2022-09-07 19:59:27'),(992,7768,40728,13784,3,992,'App\\Models\\Receipt',992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',4002.65,NULL,NULL,1,'2022-09-07 19:35:28','2022-09-07 19:59:28','2022-09-07 19:59:28'),(993,7768,40728,13784,3,993,'App\\Models\\Receipt',993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-05','2021-12-05',4382.75,NULL,NULL,1,'2022-09-07 19:35:28','2022-09-07 19:59:28','2022-09-07 19:59:28'),(994,7768,40728,13784,3,994,'App\\Models\\Receipt',994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',2534.45,NULL,NULL,1,'2022-09-07 19:35:28','2022-09-07 19:59:28','2022-09-07 19:59:28'),(995,7768,40728,13784,3,995,'App\\Models\\Receipt',995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-11','2021-12-11',4283.71,NULL,NULL,1,'2022-09-07 19:35:28','2022-09-07 19:59:28','2022-09-07 19:59:28'),(996,7768,40728,13784,3,996,'App\\Models\\Receipt',996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',5749.17,NULL,NULL,1,'2022-09-07 19:35:28','2022-09-07 19:59:28','2022-09-07 19:59:28'),(997,7768,40728,13784,3,997,'App\\Models\\Receipt',997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',19926.15,NULL,NULL,1,'2022-09-07 19:35:28','2022-09-07 19:59:28','2022-09-07 19:59:28'),(998,7768,40728,13784,3,998,'App\\Models\\Receipt',998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-12','2021-12-12',2027.51,NULL,NULL,1,'2022-09-07 19:35:28','2022-09-07 19:59:28','2022-09-07 19:59:28'),(999,7768,40728,13784,3,999,'App\\Models\\Receipt',999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',9380.00,NULL,NULL,1,'2022-09-07 19:35:28','2022-09-07 19:59:28','2022-09-07 19:59:28'),(1000,7768,40728,13784,3,1000,'App\\Models\\Receipt',1000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',15813.29,NULL,NULL,1,'2022-09-07 19:35:28','2022-09-07 19:59:28','2022-09-07 19:59:28');
INSERT INTO `balance_libro` VALUES (1075,7768,40728,13761,3,1075,'App\\Models\\Receipt',1075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',1585.82,NULL,NULL,1,'2022-09-07 19:57:40','2022-10-01 09:32:33','2022-10-01 09:32:33'),(1076,7768,40728,13761,3,1076,'App\\Models\\Receipt',1076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',578.26,NULL,NULL,1,'2022-09-07 19:57:40','2022-09-07 19:57:40',NULL),(1077,7768,40728,13761,3,1077,'App\\Models\\Receipt',1077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',19300.04,NULL,NULL,1,'2022-09-07 19:57:40','2022-09-07 19:57:40',NULL),(1078,7768,40728,13761,3,1078,'App\\Models\\Receipt',1078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',29149.78,NULL,NULL,1,'2022-09-07 19:57:40','2022-10-01 09:31:18','2022-10-01 09:31:18'),(1079,7768,40728,13761,3,1079,'App\\Models\\Receipt',1079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',6386.38,NULL,NULL,1,'2022-09-07 19:57:40','2022-09-07 19:57:40',NULL),(1080,7768,40728,13761,3,1080,'App\\Models\\Receipt',1080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',17600.00,NULL,NULL,1,'2022-09-07 19:57:40','2022-09-07 19:57:40',NULL),(1081,7768,40728,13761,3,1081,'App\\Models\\Receipt',1081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',3960.06,NULL,NULL,1,'2022-09-07 19:57:40','2022-09-07 19:57:40',NULL),(1082,7768,40728,13761,3,1082,'App\\Models\\Receipt',1082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',10023.82,NULL,NULL,1,'2022-09-07 19:57:40','2022-10-01 09:30:47','2022-10-01 09:30:47'),(1083,7768,40728,13761,3,1083,'App\\Models\\Receipt',1083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',19935.00,NULL,NULL,1,'2022-09-07 19:57:40','2022-09-07 19:57:40',NULL),(1084,7768,40728,13761,3,1084,'App\\Models\\Receipt',1084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',331500.00,NULL,NULL,1,'2022-09-07 19:57:40','2022-11-06 23:50:06','2022-11-06 23:50:06'),(1085,7768,40728,13761,3,1085,'App\\Models\\Receipt',1085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',900.00,NULL,NULL,1,'2022-09-07 19:57:41','2022-09-07 19:57:41',NULL),(1086,7768,40728,13761,3,1086,'App\\Models\\Receipt',1086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',2489.97,NULL,NULL,1,'2022-09-07 19:57:41','2022-09-07 19:57:41',NULL),(1087,7768,40728,13761,3,1087,'App\\Models\\Receipt',1087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',866.08,NULL,NULL,1,'2022-09-07 19:57:41','2022-09-07 19:57:41',NULL),(1088,7768,40728,13761,3,1088,'App\\Models\\Receipt',1088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',188247.59,NULL,NULL,1,'2022-09-07 19:57:41','2022-09-07 19:57:41',NULL),(1089,7768,40728,13761,3,1089,'App\\Models\\Receipt',1089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',3200.01,NULL,NULL,1,'2022-09-07 19:57:41','2022-11-15 15:07:48','2022-11-15 15:07:48'),(1090,7768,40728,13761,3,1090,'App\\Models\\Receipt',1090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',4100.59,NULL,NULL,1,'2022-09-07 19:57:41','2022-11-15 12:24:56','2022-11-15 12:24:56'),(1091,7768,40728,13761,3,1091,'App\\Models\\Receipt',1091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',4100.00,NULL,NULL,1,'2022-09-07 19:57:41','2022-09-07 19:57:41',NULL),(1092,7768,40728,13761,3,1092,'App\\Models\\Receipt',1092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',3900.09,NULL,NULL,1,'2022-09-07 19:57:41','2022-09-07 19:57:41',NULL),(1093,7768,40728,13761,3,1093,'App\\Models\\Receipt',1093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',2235.15,NULL,NULL,1,'2022-09-07 19:57:41','2022-09-07 19:57:41',NULL),(1094,7768,40728,13761,3,1094,'App\\Models\\Receipt',1094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',4313.95,NULL,NULL,1,'2022-09-07 19:57:41','2022-11-07 08:15:44','2022-11-07 08:15:44');
INSERT INTO `balance_libro` VALUES (1095,7768,40728,13761,3,1095,'App\\Models\\Receipt',1095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',4122.71,NULL,NULL,1,'2022-09-07 19:57:41','2022-09-07 19:57:41',NULL),(1096,7768,40728,13761,3,1096,'App\\Models\\Receipt',1096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',3000.11,NULL,NULL,1,'2022-09-07 19:57:41','2022-09-07 19:57:41',NULL),(1097,7768,40728,13761,3,1097,'App\\Models\\Receipt',1097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',3904.50,NULL,NULL,1,'2022-09-07 19:57:41','2022-11-07 08:47:39','2022-11-07 08:47:39'),(1098,7768,40728,13761,3,1098,'App\\Models\\Receipt',1098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',392.97,NULL,NULL,1,'2022-09-07 19:57:41','2022-11-08 15:42:16','2022-11-08 15:42:16'),(1099,7768,40728,13761,3,1099,'App\\Models\\Receipt',1099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',2539.94,NULL,NULL,1,'2022-09-07 19:57:41','2022-10-01 09:10:10','2022-10-01 09:10:10'),(1100,7768,40728,13761,3,1100,'App\\Models\\Receipt',1100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',0.03,NULL,NULL,1,'2022-09-07 19:57:41','2022-10-01 09:29:23','2022-10-01 09:29:23'),(1101,7768,40728,13761,3,1101,'App\\Models\\Receipt',1101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',14253.76,NULL,NULL,1,'2022-09-07 19:57:41','2022-09-07 19:57:41',NULL),(1130,7768,40728,13766,3,1130,'App\\Models\\Receipt',1130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',4719.00,NULL,NULL,1,'2022-09-07 20:01:35','2022-09-07 20:01:35',NULL),(1131,7768,40728,13766,3,1131,'App\\Models\\Receipt',1131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-04','2021-12-04',7500.00,NULL,NULL,1,'2022-09-07 20:01:35','2022-11-08 15:30:08','2022-11-08 15:30:08'),(1132,7768,40728,13766,3,1132,'App\\Models\\Receipt',1132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-05','2021-12-05',4382.75,NULL,NULL,1,'2022-09-07 20:01:36','2022-11-07 08:47:18','2022-11-07 08:47:18'),(1133,7768,40728,13766,3,1133,'App\\Models\\Receipt',1133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',1277.00,NULL,NULL,1,'2022-09-07 20:01:36','2022-09-07 20:01:36',NULL),(1134,7768,40728,13766,3,1134,'App\\Models\\Receipt',1134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',2534.45,NULL,NULL,1,'2022-09-07 20:01:36','2022-11-07 08:46:56','2022-11-07 08:46:56'),(1135,7768,40728,13766,3,1135,'App\\Models\\Receipt',1135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-10','2021-12-10',384017.70,NULL,NULL,1,'2022-09-07 20:01:36','2022-11-16 12:47:28','2022-11-16 12:47:28'),(1136,7768,40728,13766,3,1136,'App\\Models\\Receipt',1136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-10','2021-12-10',77678.37,NULL,NULL,1,'2022-09-07 20:01:36','2022-11-15 12:40:03','2022-11-15 12:40:03'),(1137,7768,40728,13766,3,1137,'App\\Models\\Receipt',1137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-13','2021-12-13',4274.20,NULL,NULL,1,'2022-09-07 20:01:36','2022-10-23 10:39:27','2022-10-23 10:39:27'),(1138,7768,40728,13766,3,1138,'App\\Models\\Receipt',1138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',39930.00,NULL,NULL,1,'2022-09-07 20:01:36','2022-09-07 20:01:36',NULL),(1139,7768,40728,13766,3,1139,'App\\Models\\Receipt',1139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',24321.00,NULL,NULL,1,'2022-09-07 20:01:36','2022-09-07 20:01:36',NULL),(1140,7768,40728,13766,3,1140,'App\\Models\\Receipt',1140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-15','2021-12-15',7328.07,NULL,NULL,1,'2022-09-07 20:01:36','2022-09-07 20:01:36',NULL),(1141,7768,40728,13766,3,1141,'App\\Models\\Receipt',1141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',22084.92,NULL,NULL,1,'2022-09-07 20:01:36','2022-10-23 10:56:17','2022-10-23 10:56:17'),(1142,7768,40728,13766,3,1142,'App\\Models\\Receipt',1142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',9146.58,NULL,NULL,1,'2022-09-07 20:01:36','2022-10-23 10:49:24','2022-10-23 10:49:24');
INSERT INTO `balance_libro` VALUES (1143,7768,40728,13766,3,1143,'App\\Models\\Receipt',1143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',45406.93,NULL,NULL,1,'2022-09-07 20:01:36','2022-11-15 12:52:27','2022-11-15 12:52:27'),(1144,7768,40728,13766,3,1144,'App\\Models\\Receipt',1144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',360580.00,NULL,NULL,1,'2022-09-07 20:01:36','2022-09-07 20:01:36',NULL),(1145,7768,40728,13766,3,1145,'App\\Models\\Receipt',1145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',4156.90,NULL,NULL,1,'2022-09-07 20:01:36','2022-11-07 08:46:40','2022-11-07 08:46:40'),(1146,7768,40728,13766,3,1146,'App\\Models\\Receipt',1146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',823.01,NULL,NULL,1,'2022-09-07 20:01:36','2022-09-07 20:01:36',NULL),(1147,7768,40728,13766,3,1147,'App\\Models\\Receipt',1147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-21','2021-12-21',4165.01,NULL,NULL,1,'2022-09-07 20:01:36','2022-11-07 08:46:21','2022-11-07 08:46:21'),(1148,7768,40728,13766,3,1148,'App\\Models\\Receipt',1148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-21','2021-12-21',6582.00,NULL,NULL,1,'2022-09-07 20:01:36','2022-09-07 20:01:36',NULL),(1149,7768,40728,13766,3,1149,'App\\Models\\Receipt',1149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',28381.25,NULL,NULL,1,'2022-09-07 20:01:36','2022-11-15 12:52:11','2022-11-15 12:52:11'),(1150,7768,40728,13766,3,1150,'App\\Models\\Receipt',1150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',480.04,NULL,NULL,1,'2022-09-07 20:01:36','2022-09-07 20:01:36',NULL),(1151,7768,40728,13766,3,1151,'App\\Models\\Receipt',1151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',22991.21,NULL,NULL,1,'2022-09-07 20:01:36','2022-11-15 12:39:47','2022-11-15 12:39:47'),(1152,7768,40728,13766,3,1152,'App\\Models\\Receipt',1152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',54451.28,NULL,NULL,1,'2022-09-07 20:01:36','2022-10-23 10:52:35','2022-10-23 10:52:35'),(1153,7768,40728,13766,3,1153,'App\\Models\\Receipt',1153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-24','2021-12-24',4055.12,NULL,NULL,1,'2022-09-07 20:01:36','2022-11-07 08:46:02','2022-11-07 08:46:02'),(1154,7768,40728,13766,3,1154,'App\\Models\\Receipt',1154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',22160.00,NULL,NULL,1,'2022-09-07 20:01:36','2022-09-07 20:01:36',NULL),(1155,7768,40728,13766,3,1155,'App\\Models\\Receipt',1155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-29','2021-12-29',22506.00,NULL,NULL,1,'2022-09-07 20:01:36','2022-09-07 20:01:36',NULL),(1156,7768,40728,13766,3,1156,'App\\Models\\Receipt',1156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',34185.38,NULL,NULL,1,'2022-09-07 20:01:36','2022-10-23 10:54:15','2022-10-23 10:54:15'),(1157,7768,40728,13766,3,1157,'App\\Models\\Receipt',1157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',7500.00,NULL,NULL,1,'2022-09-07 20:01:36','2022-11-08 15:29:58','2022-11-08 15:29:58'),(1158,7768,40728,13766,3,1158,'App\\Models\\Receipt',1158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',4219.36,NULL,NULL,1,'2022-09-07 20:01:37','2022-11-07 08:15:25','2022-11-07 08:15:25'),(1159,7768,40728,13766,3,1159,'App\\Models\\Receipt',1159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-22','2021-11-22',3800.50,NULL,NULL,1,'2022-09-07 20:01:37','2022-11-07 08:45:41','2022-11-07 08:45:41'),(1160,7768,40728,13766,3,1160,'App\\Models\\Receipt',1160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',2702.30,NULL,NULL,1,'2022-09-07 20:01:37','2022-11-15 12:21:12','2022-11-15 12:21:12'),(1161,7768,40728,13766,3,1161,'App\\Models\\Receipt',1161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-21','2021-12-21',4165.01,NULL,NULL,1,'2022-09-07 20:01:37','2022-11-07 08:42:23','2022-11-07 08:42:23');
INSERT INTO `balance_libro` VALUES (1162,7768,40728,13766,3,1162,'App\\Models\\Receipt',1162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-24','2021-12-24',4055.12,NULL,NULL,1,'2022-09-07 20:01:37','2022-11-07 08:42:10','2022-11-07 08:42:10'),(1163,7768,40728,13766,3,1163,'App\\Models\\Receipt',1163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',4156.90,NULL,NULL,1,'2022-09-07 20:01:37','2022-11-07 08:41:44','2022-11-07 08:41:44'),(1164,7768,40728,13766,3,1164,'App\\Models\\Receipt',1164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',4002.65,NULL,NULL,1,'2022-09-07 20:01:37','2022-11-15 12:29:13','2022-11-15 12:29:13'),(1165,7768,40728,13766,3,1165,'App\\Models\\Receipt',1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-05','2021-12-05',4382.75,NULL,NULL,1,'2022-09-07 20:01:37','2022-11-07 08:41:25','2022-11-07 08:41:25'),(1166,7768,40728,13766,3,1166,'App\\Models\\Receipt',1166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',2534.45,NULL,NULL,1,'2022-09-07 20:01:37','2022-10-23 10:54:45','2022-10-23 10:54:45'),(1167,7768,40728,13766,3,1167,'App\\Models\\Receipt',1167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-11','2021-12-11',4283.71,NULL,NULL,1,'2022-09-07 20:01:37','2022-11-15 12:21:00','2022-11-15 12:21:00'),(1168,7768,40728,13766,3,1168,'App\\Models\\Receipt',1168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',5749.17,NULL,NULL,1,'2022-09-07 20:01:37','2022-09-07 20:01:37',NULL),(1169,7768,40728,13766,3,1169,'App\\Models\\Receipt',1169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',19926.15,NULL,NULL,1,'2022-09-07 20:01:37','2022-09-07 20:01:37',NULL),(1170,7768,40728,13766,3,1170,'App\\Models\\Receipt',1170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-12','2021-12-12',2027.51,NULL,NULL,1,'2022-09-07 20:01:37','2022-09-07 20:01:37',NULL),(1171,7768,40728,13766,3,1171,'App\\Models\\Receipt',1171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',9380.00,NULL,NULL,1,'2022-09-07 20:01:37','2022-11-15 12:29:02','2022-11-15 12:29:02'),(1172,7768,40728,13766,3,1172,'App\\Models\\Receipt',1172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',15813.29,NULL,NULL,1,'2022-09-07 20:01:37','2022-11-08 15:41:23','2022-11-08 15:41:23'),(1173,7768,40728,13766,2,1173,'App\\Models\\Receipt',1173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-07','2021-12-07',363000.00,NULL,NULL,1,'2022-09-07 20:01:50','2022-09-07 20:01:50',NULL),(1174,7768,40728,13766,2,1174,'App\\Models\\Receipt',1174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-28','2021-12-28',30125.37,NULL,NULL,1,'2022-09-07 20:01:50','2022-09-07 20:01:50',NULL),(1205,7768,40728,13763,3,1205,'App\\Models\\Receipt',1205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',9420.18,NULL,NULL,1,'2022-09-07 23:18:28','2022-09-07 23:20:21','2022-09-07 23:20:21'),(1206,7768,40728,13763,3,1206,'App\\Models\\Receipt',1206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-03','2021-09-03',12500.00,NULL,NULL,1,'2022-09-07 23:18:28','2022-09-07 23:18:28',NULL),(1207,7768,40728,13763,3,1207,'App\\Models\\Receipt',1207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',12500.00,NULL,NULL,1,'2022-09-07 23:18:28','2022-09-07 23:21:26','2022-09-07 23:21:26'),(1208,7768,40728,13763,3,1208,'App\\Models\\Receipt',1208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',1232.82,NULL,NULL,1,'2022-09-07 23:18:28','2022-09-07 23:23:23','2022-09-07 23:23:23'),(1209,7768,40728,13763,3,1209,'App\\Models\\Receipt',1209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-20','2021-09-20',242000.00,NULL,NULL,1,'2022-09-07 23:18:28','2022-09-07 23:18:28',NULL),(1210,7768,40728,13763,3,1210,'App\\Models\\Receipt',1210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',326700.00,NULL,NULL,1,'2022-09-07 23:18:28','2022-09-07 23:27:14','2022-09-07 23:27:14');
INSERT INTO `balance_libro` VALUES (1211,7768,40728,13763,3,1211,'App\\Models\\Receipt',1211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-24','2021-09-24',96800.00,NULL,NULL,1,'2022-09-07 23:18:28','2022-09-07 23:27:08','2022-09-07 23:27:08'),(1212,7768,40728,13763,3,1212,'App\\Models\\Receipt',1212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-24','2021-09-24',24132.00,NULL,NULL,1,'2022-09-07 23:18:28','2022-09-07 23:18:28',NULL),(1213,7768,40728,13763,3,1213,'App\\Models\\Receipt',1213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-24','2021-09-24',24132.00,NULL,NULL,1,'2022-09-07 23:18:28','2022-09-07 23:18:28',NULL),(1214,7768,40728,13763,3,1214,'App\\Models\\Receipt',1214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-24','2021-09-24',24132.00,NULL,NULL,1,'2022-09-07 23:18:28','2022-09-07 23:18:28',NULL),(1215,7768,40728,13763,3,1215,'App\\Models\\Receipt',1215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',230.00,NULL,NULL,1,'2022-09-07 23:18:28','2022-09-07 23:18:28',NULL),(1216,7768,40728,13763,3,1216,'App\\Models\\Receipt',1216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',950.00,NULL,NULL,1,'2022-09-07 23:18:28','2022-09-07 23:18:28',NULL),(1217,7768,40728,13763,3,1217,'App\\Models\\Receipt',1217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',2200.00,NULL,NULL,1,'2022-09-07 23:18:28','2022-09-07 23:18:28',NULL),(1218,7768,40728,13763,3,1218,'App\\Models\\Receipt',1218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',44855.01,NULL,NULL,1,'2022-09-07 23:18:28','2022-09-08 21:53:02','2022-09-08 21:53:02'),(1219,7768,40728,13763,3,1219,'App\\Models\\Receipt',1219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',585650.00,NULL,NULL,1,'2022-09-07 23:18:28','2022-11-06 23:49:20','2022-11-06 23:49:20'),(1220,7768,40728,13763,3,1207,'App\\Models\\Receipt',1207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',12500.00,NULL,NULL,1,'2022-09-07 23:21:26','2022-09-07 23:21:26',NULL),(1221,7768,40728,13763,3,1208,'App\\Models\\Receipt',1208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',1232.82,NULL,NULL,1,'2022-09-07 23:23:23','2022-10-01 09:55:23','2022-10-01 09:55:23'),(1222,7768,40728,13763,3,1220,'App\\Models\\Receipt',1220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',34953.86,NULL,NULL,1,'2022-09-07 23:28:20','2022-09-07 23:28:20',NULL),(1223,7768,40728,13763,3,1221,'App\\Models\\Receipt',1221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',4256.00,NULL,NULL,1,'2022-09-07 23:28:20','2022-11-15 12:24:42','2022-11-15 12:24:42'),(1224,7768,40728,13763,3,1222,'App\\Models\\Receipt',1222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',2027.42,NULL,NULL,1,'2022-09-07 23:28:20','2022-11-07 08:38:12','2022-11-07 08:38:12'),(1225,7768,40728,13763,3,1223,'App\\Models\\Receipt',1223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',3751.81,NULL,NULL,1,'2022-09-07 23:28:20','2022-09-08 21:38:28','2022-09-08 21:38:28'),(1226,7768,40728,13763,3,1224,'App\\Models\\Receipt',1224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11','2021-09-11',3265.98,NULL,NULL,1,'2022-09-07 23:28:20','2022-11-15 12:20:39','2022-11-15 12:20:39'),(1227,7768,40728,13763,3,1225,'App\\Models\\Receipt',1225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-12','2021-09-12',2000.00,NULL,NULL,1,'2022-09-07 23:28:20','2022-11-07 08:40:35','2022-11-07 08:40:35'),(1228,7768,40728,13763,3,1226,'App\\Models\\Receipt',1226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',4156.82,NULL,NULL,1,'2022-09-07 23:28:20','2022-11-15 12:24:22','2022-11-15 12:24:22'),(1229,7768,40728,13763,3,1227,'App\\Models\\Receipt',1227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-25','2021-09-25',810.00,NULL,NULL,1,'2022-09-07 23:28:20','2022-09-07 23:28:20',NULL),(1230,7768,40728,13763,3,1228,'App\\Models\\Receipt',1228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',2027.56,NULL,NULL,1,'2022-09-07 23:28:20','2022-11-07 08:40:18','2022-11-07 08:40:18');
INSERT INTO `balance_libro` VALUES (1231,7768,40728,13763,3,1229,'App\\Models\\Receipt',1229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',3569.30,NULL,NULL,1,'2022-09-07 23:28:20','2022-11-15 12:20:29','2022-11-15 12:20:29'),(1232,7768,40728,13763,3,1230,'App\\Models\\Receipt',1230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',12475.85,NULL,NULL,1,'2022-09-07 23:28:20','2022-10-01 09:37:34','2022-10-01 09:37:34'),(1233,7768,40728,13763,3,1231,'App\\Models\\Receipt',1231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',15800.13,NULL,NULL,1,'2022-09-07 23:28:20','2022-11-08 15:41:02','2022-11-08 15:41:02'),(1234,7768,40728,13762,3,1232,'App\\Models\\Receipt',1232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',29200.00,NULL,NULL,1,'2022-09-07 23:33:22','2022-09-07 23:33:22',NULL),(1235,7768,40728,13762,3,1233,'App\\Models\\Receipt',1233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',1864.09,NULL,NULL,1,'2022-09-07 23:33:22','2022-09-08 00:34:41','2022-09-08 00:34:41'),(1236,7768,40728,13762,3,1234,'App\\Models\\Receipt',1234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',1817.82,NULL,NULL,1,'2022-09-07 23:33:22','2022-09-08 00:35:13','2022-09-08 00:35:13'),(1237,7768,40728,13762,3,1235,'App\\Models\\Receipt',1235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-06','2021-08-06',10830.00,NULL,NULL,1,'2022-09-07 23:33:22','2022-09-07 23:33:22',NULL),(1238,7768,40728,13762,3,1236,'App\\Models\\Receipt',1236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',10500.00,NULL,NULL,1,'2022-09-07 23:33:23','2022-09-07 23:33:23',NULL),(1239,7768,40728,13762,3,1237,'App\\Models\\Receipt',1237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',11500.00,NULL,NULL,1,'2022-09-07 23:33:23','2022-09-07 23:33:23',NULL),(1240,7768,40728,13762,3,1238,'App\\Models\\Receipt',1238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',5300.00,NULL,NULL,1,'2022-09-07 23:33:23','2022-09-07 23:33:23',NULL),(1241,7768,40728,13762,3,1239,'App\\Models\\Receipt',1239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',4303.22,NULL,NULL,1,'2022-09-07 23:33:23','2022-09-07 23:33:23',NULL),(1242,7768,40728,13762,3,1240,'App\\Models\\Receipt',1240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',1432.00,NULL,NULL,1,'2022-09-07 23:33:23','2022-09-07 23:33:23',NULL),(1243,7768,40728,13762,3,1241,'App\\Models\\Receipt',1241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',1009.41,NULL,NULL,1,'2022-09-07 23:33:23','2022-09-07 23:33:23',NULL),(1244,7768,40728,13762,3,1242,'App\\Models\\Receipt',1242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-17','2021-08-17',5490.01,NULL,NULL,1,'2022-09-07 23:33:23','2022-09-07 23:33:23',NULL),(1245,7768,40728,13762,3,1243,'App\\Models\\Receipt',1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-17','2021-08-17',718250.00,NULL,NULL,1,'2022-09-07 23:33:23','2022-09-08 00:33:18','2022-09-08 00:33:18'),(1246,7768,40728,13762,3,1244,'App\\Models\\Receipt',1244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',718250.00,NULL,NULL,1,'2022-09-07 23:33:23','2022-09-08 00:32:51','2022-09-08 00:32:51'),(1247,7768,40728,13762,3,1245,'App\\Models\\Receipt',1245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',90.06,NULL,NULL,1,'2022-09-07 23:33:23','2022-09-07 23:33:23',NULL),(1248,7768,40728,13762,3,1246,'App\\Models\\Receipt',1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',739250.01,NULL,NULL,1,'2022-09-07 23:33:23','2022-09-08 00:32:06','2022-09-08 00:32:06'),(1249,7768,40728,13762,3,1247,'App\\Models\\Receipt',1247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-21','2021-08-21',181500.00,NULL,NULL,1,'2022-09-07 23:33:23','2022-09-07 23:33:23',NULL),(1250,7768,40728,13762,3,1248,'App\\Models\\Receipt',1248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23','2021-08-23',168.50,NULL,NULL,1,'2022-09-07 23:33:23','2022-09-07 23:33:23',NULL);
INSERT INTO `balance_libro` VALUES (1251,7768,40728,13762,3,1249,'App\\Models\\Receipt',1249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-24','2021-08-24',25020.00,NULL,NULL,1,'2022-09-07 23:33:23','2022-09-07 23:33:23',NULL),(1252,7768,40728,13762,3,1250,'App\\Models\\Receipt',1250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',51025.70,NULL,NULL,1,'2022-09-07 23:33:23','2022-09-07 23:33:23',NULL),(1253,7768,40728,13762,3,1251,'App\\Models\\Receipt',1251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',29657.10,NULL,NULL,1,'2022-09-07 23:33:23','2022-09-07 23:33:23',NULL),(1254,7768,40728,13762,3,1252,'App\\Models\\Receipt',1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',4201.36,NULL,NULL,1,'2022-09-07 23:39:49','2022-09-08 00:36:12','2022-09-08 00:36:12'),(1255,7768,40728,13762,3,1253,'App\\Models\\Receipt',1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',1999.99,NULL,NULL,1,'2022-09-07 23:39:49','2022-09-07 23:39:49',NULL),(1256,7768,40728,13762,3,1254,'App\\Models\\Receipt',1254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',2040.00,NULL,NULL,1,'2022-09-07 23:39:49','2022-09-07 23:39:49',NULL),(1257,7768,40728,13762,3,1255,'App\\Models\\Receipt',1255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',2523.54,NULL,NULL,1,'2022-09-07 23:39:49','2022-09-07 23:39:49',NULL),(1258,7768,40728,13762,3,1256,'App\\Models\\Receipt',1256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',4072.69,NULL,NULL,1,'2022-09-07 23:39:49','2022-09-07 23:39:49',NULL),(1259,7768,40728,13762,3,1257,'App\\Models\\Receipt',1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',4398.82,NULL,NULL,1,'2022-09-07 23:39:49','2022-10-01 09:39:56','2022-10-01 09:39:56'),(1260,7768,40728,13762,3,1258,'App\\Models\\Receipt',1258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',3991.30,NULL,NULL,1,'2022-09-07 23:39:49','2022-09-07 23:39:49',NULL),(1261,7768,40728,13762,3,1259,'App\\Models\\Receipt',1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-29','2021-08-29',6081.19,NULL,NULL,1,'2022-09-07 23:39:49','2022-09-08 00:28:59','2022-09-08 00:28:59'),(1262,7768,40728,13762,3,1260,'App\\Models\\Receipt',1260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',3600.00,NULL,NULL,1,'2022-09-07 23:39:49','2022-09-07 23:39:49',NULL),(1263,7768,40728,13762,3,1261,'App\\Models\\Receipt',1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',3410.61,NULL,NULL,1,'2022-09-07 23:39:49','2022-09-07 23:39:49',NULL),(1264,7768,40728,13758,15,177,'App\\Models\\PeriodLiquidation',NULL,177,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',243886.63,NULL,NULL,1,'2022-09-07 23:51:30','2022-09-08 22:58:34','2022-09-08 22:58:34'),(1265,7768,40728,13759,15,179,'App\\Models\\PeriodLiquidation',NULL,179,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',333212.30,NULL,NULL,1,'2022-09-07 23:53:54','2022-09-08 23:11:05','2022-09-08 23:11:05'),(1266,7768,40728,13760,15,180,'App\\Models\\PeriodLiquidation',NULL,180,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',215452.76,NULL,NULL,1,'2022-09-07 23:55:13','2022-10-01 09:08:37','2022-10-01 09:08:37'),(1267,7768,40728,13761,15,181,'App\\Models\\PeriodLiquidation',NULL,181,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',130455.50,NULL,NULL,1,'2022-09-07 23:56:18','2022-10-01 09:09:50','2022-10-01 09:09:50'),(1268,7768,40728,13762,3,1262,'App\\Models\\Receipt',1262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-06','2021-08-06',99900.00,NULL,NULL,1,'2022-09-08 00:21:54','2022-11-15 12:13:47','2022-11-15 12:13:47'),(1269,7768,40728,13762,3,1259,'App\\Models\\Receipt',1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-29','2021-08-29',6031.19,NULL,NULL,1,'2022-09-08 00:28:59','2022-10-01 09:39:36','2022-10-01 09:39:36'),(1270,7768,40728,13762,3,1246,'App\\Models\\Receipt',1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',739250.01,NULL,NULL,1,'2022-09-08 00:32:06','2022-09-08 00:32:06',NULL);
INSERT INTO `balance_libro` VALUES (1271,7768,40728,13762,3,1244,'App\\Models\\Receipt',1244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',718250.00,NULL,NULL,1,'2022-09-08 00:32:51','2022-09-08 00:32:51',NULL),(1272,7768,40728,13762,3,1243,'App\\Models\\Receipt',1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-17','2021-08-17',718250.00,NULL,NULL,1,'2022-09-08 00:33:18','2022-09-08 00:33:18',NULL),(1273,7768,40728,13762,3,1233,'App\\Models\\Receipt',1233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',1861.77,NULL,NULL,1,'2022-09-08 00:34:41','2022-09-08 00:34:41',NULL),(1274,7768,40728,13762,3,1234,'App\\Models\\Receipt',1234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03','2021-08-03',1817.82,NULL,NULL,1,'2022-09-08 00:35:13','2022-09-08 00:35:13',NULL),(1275,7768,40728,13762,3,1252,'App\\Models\\Receipt',1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',4201.36,NULL,NULL,1,'2022-09-08 00:36:12','2022-11-15 12:19:57','2022-11-15 12:19:57'),(1276,7768,40728,13762,15,196,'App\\Models\\PeriodLiquidation',NULL,196,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',216438.32,NULL,NULL,1,'2022-09-08 00:42:05','2022-10-01 09:36:54','2022-10-01 09:36:54'),(1277,7768,40728,13764,9,1277,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',327.24,'COMPENSACIONES',NULL,1,'2022-09-08 18:44:35','2022-09-08 18:47:53','2022-09-08 18:47:53'),(1278,7768,40728,13764,9,1278,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-19','2021-10-19',327.24,'COMPENSACIONES',NULL,1,'2022-09-08 18:47:53','2022-09-08 18:47:53',NULL),(1279,7768,40728,13763,3,1263,'App\\Models\\Receipt',1263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',55900.00,NULL,NULL,1,'2022-09-08 21:28:24','2022-09-08 21:28:24',NULL),(1280,7768,40728,13763,3,1223,'App\\Models\\Receipt',1223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',3751.81,NULL,NULL,1,'2022-09-08 21:38:28','2022-09-08 21:38:47','2022-09-08 21:38:47'),(1281,7768,40728,13763,3,1223,'App\\Models\\Receipt',1223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',3751.81,NULL,NULL,1,'2022-09-08 21:38:47','2022-09-08 21:38:47',NULL),(1282,7768,40728,13763,3,1218,'App\\Models\\Receipt',1218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',43991.63,NULL,NULL,1,'2022-09-08 21:53:02','2022-09-08 21:59:19','2022-09-08 21:59:19'),(1283,7768,40728,13763,3,1218,'App\\Models\\Receipt',1218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',48966.63,NULL,NULL,1,'2022-09-08 21:59:19','2022-09-08 21:59:19',NULL),(1284,7768,40728,13763,15,211,'App\\Models\\PeriodLiquidation',NULL,211,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',220974.08,NULL,NULL,1,'2022-09-08 22:01:43','2022-10-01 09:37:02','2022-10-01 09:37:02'),(1285,7768,40728,13764,15,77,'App\\Models\\PeriodLiquidation',NULL,77,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',144356.13,NULL,NULL,1,'2022-09-08 22:02:54','2022-10-01 09:59:10','2022-10-01 09:59:10'),(1286,7768,40728,13765,15,81,'App\\Models\\PeriodLiquidation',NULL,81,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',168264.21,NULL,NULL,1,'2022-09-08 22:03:47','2022-10-01 09:59:17','2022-10-01 09:59:17'),(1287,7768,40728,13766,15,155,'App\\Models\\PeriodLiquidation',NULL,155,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',216120.50,NULL,NULL,1,'2022-09-08 22:04:39','2022-10-01 10:16:30','2022-10-01 10:16:30'),(1288,7768,40728,13773,15,213,'App\\Models\\PeriodLiquidation',NULL,213,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',370884.07,NULL,NULL,1,'2022-09-08 22:18:31','2022-10-01 10:16:38','2022-10-01 10:16:38'),(1289,7768,40728,13774,15,214,'App\\Models\\PeriodLiquidation',NULL,214,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',100712.77,NULL,NULL,1,'2022-09-08 22:19:33','2022-10-23 10:38:32','2022-10-23 10:38:32');
INSERT INTO `balance_libro` VALUES (1290,7768,40728,13775,15,215,'App\\Models\\PeriodLiquidation',NULL,215,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',119459.88,NULL,NULL,1,'2022-09-08 22:20:42','2022-10-23 10:38:38','2022-10-23 10:38:38'),(1291,7768,40728,13776,15,218,'App\\Models\\PeriodLiquidation',NULL,218,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',161174.47,NULL,NULL,1,'2022-09-08 22:22:17','2022-10-23 11:05:42','2022-10-23 11:05:42'),(1292,7768,40728,13777,15,217,'App\\Models\\PeriodLiquidation',NULL,217,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',150238.68,NULL,NULL,1,'2022-09-08 22:23:51','2022-09-08 23:14:21','2022-09-08 23:14:21'),(1293,7768,40728,13778,15,219,'App\\Models\\PeriodLiquidation',NULL,219,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',82736.49,NULL,NULL,1,'2022-09-08 22:25:18','2022-10-23 11:13:52','2022-10-23 11:13:52'),(1294,7768,40728,13779,3,544,'App\\Models\\Receipt',544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',6524.69,NULL,NULL,1,'2022-09-08 22:39:03','2022-09-08 22:44:17','2022-09-08 22:44:17'),(1295,7768,40728,13779,3,544,'App\\Models\\Receipt',544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',6524.69,NULL,NULL,1,'2022-09-08 22:44:17','2022-09-08 22:55:46','2022-09-08 22:55:46'),(1296,7768,40728,13779,3,1264,'App\\Models\\Receipt',1264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',15141.24,NULL,NULL,1,'2022-09-08 22:51:59','2022-11-08 15:40:28','2022-11-08 15:40:28'),(1297,7768,40728,13779,15,230,'App\\Models\\PeriodLiquidation',NULL,230,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',197114.00,NULL,NULL,1,'2022-09-08 22:56:24','2022-10-31 14:42:02','2022-10-31 14:42:02'),(1298,7768,40728,13758,16,178,'App\\Models\\PeriodLiquidation',NULL,178,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',0.00,NULL,NULL,1,'2022-09-08 22:58:34','2022-10-01 09:58:35','2022-10-01 09:58:35'),(1299,7768,40728,13759,3,105,'App\\Models\\Receipt',105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',301264.73,NULL,NULL,1,'2022-09-08 23:11:54','2022-09-08 23:11:54',NULL),(1300,7768,40728,13759,15,234,'App\\Models\\PeriodLiquidation',NULL,234,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',333212.30,NULL,NULL,1,'2022-09-08 23:12:27','2022-11-07 08:11:09','2022-11-07 08:11:09'),(1301,7768,40728,13759,16,235,'App\\Models\\PeriodLiquidation',NULL,235,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',11219.64,NULL,NULL,1,'2022-09-08 23:14:21','2022-11-07 08:11:14','2022-11-07 08:11:14'),(1302,7768,41245,15288,2,1265,'App\\Models\\Receipt',1265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',50380.00,NULL,NULL,1,'2022-09-09 14:25:37','2022-09-09 14:25:37',NULL),(1303,7768,41245,15288,2,1266,'App\\Models\\Receipt',1266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',30000.00,NULL,NULL,1,'2022-09-09 14:25:37','2022-09-09 14:25:37',NULL),(1304,7768,41245,15288,2,1267,'App\\Models\\Receipt',1267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',46000.00,NULL,NULL,1,'2022-09-09 14:25:37','2022-09-09 14:25:37',NULL),(1305,7768,41245,15289,2,1268,'App\\Models\\Receipt',1268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',28990.00,NULL,NULL,1,'2022-09-09 14:28:12','2022-09-09 14:28:12',NULL),(1306,7768,41245,15289,2,1269,'App\\Models\\Receipt',1269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',40000.00,NULL,NULL,1,'2022-09-09 14:28:13','2022-09-09 14:28:13',NULL),(1307,7768,41245,15289,2,1270,'App\\Models\\Receipt',1270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',55200.00,NULL,NULL,1,'2022-09-09 14:28:13','2022-09-09 14:28:13',NULL),(1308,7768,41245,15290,2,1271,'App\\Models\\Receipt',1271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',33150.00,NULL,NULL,1,'2022-09-09 14:28:38','2022-09-09 14:28:38',NULL);
INSERT INTO `balance_libro` VALUES (1309,7768,41245,15290,2,1272,'App\\Models\\Receipt',1272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',40000.00,NULL,NULL,1,'2022-09-09 14:28:38','2022-09-09 14:28:38',NULL),(1310,7768,41245,15290,2,1273,'App\\Models\\Receipt',1273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',68200.00,NULL,NULL,1,'2022-09-09 14:28:38','2022-09-09 14:28:38',NULL),(1311,7768,41245,15291,2,1274,'App\\Models\\Receipt',1274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',50000.00,NULL,NULL,1,'2022-09-09 14:29:56','2022-09-09 14:29:56',NULL),(1312,7768,41245,15291,2,1275,'App\\Models\\Receipt',1275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',89294.00,NULL,NULL,1,'2022-09-09 14:29:56','2022-09-09 14:29:56',NULL),(1313,7768,41245,15291,2,1276,'App\\Models\\Receipt',1276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',25000.00,NULL,NULL,1,'2022-09-09 14:29:56','2022-09-09 14:29:56',NULL),(1314,7768,41245,15292,2,1277,'App\\Models\\Receipt',1277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',50000.00,NULL,NULL,1,'2022-09-09 14:30:27','2022-09-09 14:30:27',NULL),(1315,7768,41245,15292,2,1278,'App\\Models\\Receipt',1278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',83217.50,NULL,NULL,1,'2022-09-09 14:30:27','2022-09-09 14:30:27',NULL),(1316,7768,41245,15292,2,1279,'App\\Models\\Receipt',1279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',83217.50,NULL,NULL,1,'2022-09-09 14:30:27','2022-09-09 14:30:27',NULL),(1317,7768,41245,15293,2,1280,'App\\Models\\Receipt',1280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',86441.82,NULL,NULL,1,'2022-09-09 14:30:58','2022-09-09 14:30:58',NULL),(1318,7768,41245,15293,2,1281,'App\\Models\\Receipt',1281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',107835.00,NULL,NULL,1,'2022-09-09 14:30:58','2022-09-09 14:30:58',NULL),(1319,7768,41245,15293,2,1282,'App\\Models\\Receipt',1282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',50000.00,NULL,NULL,1,'2022-09-09 14:30:58','2022-09-09 14:30:58',NULL),(1320,7768,41245,15294,2,1283,'App\\Models\\Receipt',1283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',124175.00,NULL,NULL,1,'2022-09-09 14:31:25','2022-09-09 14:31:25',NULL),(1321,7768,41245,15294,2,1284,'App\\Models\\Receipt',1284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',83325.00,NULL,NULL,1,'2022-09-09 14:31:25','2022-09-09 14:31:25',NULL),(1322,7768,41245,15295,2,1285,'App\\Models\\Receipt',1285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-07','2022-08-07',119294.50,NULL,NULL,1,'2022-09-09 14:31:52','2022-09-09 14:41:51','2022-09-09 14:41:51'),(1323,7768,41245,15295,2,1286,'App\\Models\\Receipt',1286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-07','2022-08-07',119294.50,NULL,NULL,1,'2022-09-09 14:31:52','2022-09-09 14:41:51','2022-09-09 14:41:51'),(1324,7768,41245,15295,2,1287,'App\\Models\\Receipt',1287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-02','2021-12-02',40000.00,NULL,NULL,1,'2022-09-09 14:32:27','2022-09-09 14:41:51','2022-09-09 14:41:51'),(1325,7768,41245,15295,2,1288,'App\\Models\\Receipt',1288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-02','2021-12-02',34240.00,NULL,NULL,1,'2022-09-09 14:32:27','2022-09-09 14:41:51','2022-09-09 14:41:51'),(1326,7768,41245,15295,2,1289,'App\\Models\\Receipt',1289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-03','2021-12-03',25000.00,NULL,NULL,1,'2022-09-09 14:32:27','2022-09-09 14:41:51','2022-09-09 14:41:51'),(1327,7768,41245,15295,2,1290,'App\\Models\\Receipt',1290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',23660.00,NULL,NULL,1,'2022-09-09 14:32:55','2022-09-09 14:41:51','2022-09-09 14:41:51'),(1328,7768,41245,15295,2,1291,'App\\Models\\Receipt',1291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',36400.00,NULL,NULL,1,'2022-09-09 14:32:55','2022-09-09 14:41:51','2022-09-09 14:41:51');
INSERT INTO `balance_libro` VALUES (1329,7768,41245,15295,2,1292,'App\\Models\\Receipt',1292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',20000.00,NULL,NULL,1,'2022-09-09 14:32:55','2022-09-09 14:41:51','2022-09-09 14:41:51'),(1330,7768,41245,15295,2,1293,'App\\Models\\Receipt',1293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-09','2021-11-09',30000.00,NULL,NULL,1,'2022-09-09 14:32:55','2022-09-09 14:41:51','2022-09-09 14:41:51'),(1331,7768,41245,15295,2,1294,'App\\Models\\Receipt',1294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',36400.00,NULL,NULL,1,'2022-09-09 14:33:26','2022-09-09 14:41:51','2022-09-09 14:41:51'),(1332,7768,41245,15295,2,1295,'App\\Models\\Receipt',1295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',33801.00,NULL,NULL,1,'2022-09-09 14:33:26','2022-09-09 14:41:51','2022-09-09 14:41:51'),(1333,7768,41245,15295,2,1296,'App\\Models\\Receipt',1296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',11000.00,NULL,NULL,1,'2022-09-09 14:33:26','2022-09-09 14:41:51','2022-09-09 14:41:51'),(1334,7768,41245,15295,2,1297,'App\\Models\\Receipt',1297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',22230.00,NULL,NULL,1,'2022-09-09 14:34:15','2022-09-09 14:38:37','2022-09-09 14:38:37'),(1335,7768,41245,16916,2,1297,'App\\Models\\Receipt',1297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',22230.00,NULL,NULL,1,'2022-09-09 14:38:37','2022-09-09 14:38:37',NULL),(1336,7768,41245,15295,2,1298,'App\\Models\\Receipt',1298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-07','2022-08-07',119294.50,NULL,NULL,1,'2022-09-09 14:42:46','2022-09-09 14:42:46',NULL),(1337,7768,41245,15295,2,1299,'App\\Models\\Receipt',1299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-07','2022-08-07',119294.50,NULL,NULL,1,'2022-09-09 14:42:46','2022-09-09 14:42:46',NULL),(1338,7768,41245,16917,2,1300,'App\\Models\\Receipt',1300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',36400.00,NULL,NULL,1,'2022-09-09 14:43:25','2022-09-09 14:43:25',NULL),(1339,7768,41245,16917,2,1301,'App\\Models\\Receipt',1301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11','2021-10-11',33801.00,NULL,NULL,1,'2022-09-09 14:43:25','2022-09-09 14:43:25',NULL),(1340,7768,41245,16917,2,1302,'App\\Models\\Receipt',1302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',11000.00,NULL,NULL,1,'2022-09-09 14:43:25','2022-09-09 14:43:25',NULL),(1341,7768,41245,16918,2,1303,'App\\Models\\Receipt',1303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',23660.00,NULL,NULL,1,'2022-09-09 14:43:51','2022-09-09 14:43:51',NULL),(1342,7768,41245,16918,2,1304,'App\\Models\\Receipt',1304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',36400.00,NULL,NULL,1,'2022-09-09 14:43:51','2022-09-09 14:43:51',NULL),(1343,7768,41245,16918,2,1305,'App\\Models\\Receipt',1305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',20000.00,NULL,NULL,1,'2022-09-09 14:43:52','2022-09-09 14:43:52',NULL),(1344,7768,41245,16918,2,1306,'App\\Models\\Receipt',1306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-09','2021-11-09',30000.00,NULL,NULL,1,'2022-09-09 14:43:52','2022-09-09 14:43:52',NULL),(1345,7768,41245,16919,2,1307,'App\\Models\\Receipt',1307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-02','2021-12-02',40000.00,NULL,NULL,1,'2022-09-09 14:45:49','2022-09-09 14:45:49',NULL),(1346,7768,41245,16919,2,1308,'App\\Models\\Receipt',1308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-02','2021-12-02',34240.00,NULL,NULL,1,'2022-09-09 14:45:49','2022-09-09 14:45:49',NULL),(1347,7768,41245,16919,2,1309,'App\\Models\\Receipt',1309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-03','2021-12-03',25000.00,NULL,NULL,1,'2022-09-09 14:45:49','2022-09-09 14:45:49',NULL),(1348,7768,41298,88852,3,1310,'App\\Models\\Receipt',1310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',43092.00,NULL,NULL,1,'2022-09-14 13:40:07','2022-09-14 16:33:56','2022-09-14 16:33:56');
INSERT INTO `balance_libro` VALUES (1349,7768,41298,88852,3,1311,'App\\Models\\Receipt',1311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',475.00,NULL,NULL,1,'2022-09-14 13:40:07','2022-09-14 16:33:46','2022-09-14 16:33:46'),(1350,7768,41298,88852,3,1312,'App\\Models\\Receipt',1312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-29','2022-05-29',10241.26,NULL,NULL,1,'2022-09-14 13:40:07','2022-09-14 16:33:32','2022-09-14 16:33:32'),(1351,7768,41298,88853,3,1313,'App\\Models\\Receipt',1313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',43092.00,NULL,NULL,1,'2022-09-14 16:19:36','2022-09-14 16:46:18','2022-09-14 16:46:18'),(1352,7768,41298,88853,3,1314,'App\\Models\\Receipt',1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-04','2022-06-04',2735.00,NULL,NULL,1,'2022-09-14 16:19:36','2022-09-14 16:46:07','2022-09-14 16:46:07'),(1353,7768,41298,88853,3,1315,'App\\Models\\Receipt',1315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',4650.00,NULL,NULL,1,'2022-09-14 16:19:36','2022-09-14 16:46:00','2022-09-14 16:46:00'),(1354,7768,41298,88854,3,1316,'App\\Models\\Receipt',1316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',52250.00,NULL,NULL,1,'2022-09-14 16:20:14','2022-09-14 17:00:29','2022-09-14 17:00:29'),(1355,7768,41298,88854,3,1317,'App\\Models\\Receipt',1317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',28800.00,NULL,NULL,1,'2022-09-14 16:20:14','2022-09-14 17:00:25','2022-09-14 17:00:25'),(1356,7768,41298,88854,3,1318,'App\\Models\\Receipt',1318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1233.52,NULL,NULL,1,'2022-09-14 16:20:14','2022-09-14 17:00:21','2022-09-14 17:00:21'),(1357,7768,41298,88855,3,1319,'App\\Models\\Receipt',1319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',9148.57,NULL,NULL,1,'2022-09-14 16:20:48','2022-09-14 17:01:25','2022-09-14 17:01:25'),(1358,7768,41298,88855,3,1320,'App\\Models\\Receipt',1320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',84499.00,NULL,NULL,1,'2022-09-14 16:20:48','2022-09-14 17:01:21','2022-09-14 17:01:21'),(1359,7768,41298,88855,3,1321,'App\\Models\\Receipt',1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',52250.00,NULL,NULL,1,'2022-09-14 16:20:48','2022-09-14 17:06:42','2022-09-14 17:06:42'),(1360,7768,41298,88855,3,1322,'App\\Models\\Receipt',1322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',1350.00,NULL,NULL,1,'2022-09-14 16:20:48','2022-09-14 17:01:16','2022-09-14 17:01:16'),(1361,7768,41298,88855,3,1323,'App\\Models\\Receipt',1323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',9990.00,NULL,NULL,1,'2022-09-14 16:20:48','2022-09-14 17:01:12','2022-09-14 17:01:12'),(1362,7768,41298,88855,3,1324,'App\\Models\\Receipt',1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',4320.65,NULL,NULL,1,'2022-09-14 16:20:48','2022-09-14 17:01:08','2022-09-14 17:01:08'),(1363,7768,41298,88852,3,1312,'App\\Models\\Receipt',1312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-29','2022-05-29',10241.26,NULL,NULL,1,'2022-09-14 16:33:32','2022-09-14 16:33:32',NULL),(1364,7768,41298,88852,3,1311,'App\\Models\\Receipt',1311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',475.00,NULL,NULL,1,'2022-09-14 16:33:46','2022-09-14 16:33:46',NULL),(1365,7768,41298,88852,3,1310,'App\\Models\\Receipt',1310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',43092.00,NULL,NULL,1,'2022-09-14 16:33:56','2022-09-14 16:33:56',NULL),(1366,7768,41298,88853,3,1315,'App\\Models\\Receipt',1315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',4650.00,NULL,NULL,1,'2022-09-14 16:46:00','2022-09-14 16:46:00',NULL),(1367,7768,41298,88853,3,1314,'App\\Models\\Receipt',1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-04','2022-06-04',2735.00,NULL,NULL,1,'2022-09-14 16:46:07','2022-09-14 16:46:07',NULL);
INSERT INTO `balance_libro` VALUES (1368,7768,41298,88853,3,1313,'App\\Models\\Receipt',1313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',43092.00,NULL,NULL,1,'2022-09-14 16:46:18','2022-09-14 16:46:18',NULL),(1369,7768,41298,88852,15,277,'App\\Models\\PeriodLiquidation',NULL,277,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',0.00,NULL,NULL,1,'2022-09-14 16:46:44','2022-09-14 16:46:44',NULL),(1370,7768,41298,88853,15,285,'App\\Models\\PeriodLiquidation',NULL,285,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',0.00,NULL,NULL,1,'2022-09-14 16:58:51','2022-09-14 16:58:51',NULL),(1371,7768,41298,88854,3,1318,'App\\Models\\Receipt',1318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',1233.52,NULL,NULL,1,'2022-09-14 17:00:21','2022-09-14 17:00:21',NULL),(1372,7768,41298,88854,3,1317,'App\\Models\\Receipt',1317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-09','2022-07-09',28800.00,NULL,NULL,1,'2022-09-14 17:00:25','2022-09-14 17:00:25',NULL),(1373,7768,41298,88854,3,1316,'App\\Models\\Receipt',1316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',52250.00,NULL,NULL,1,'2022-09-14 17:00:29','2022-09-14 17:00:29',NULL),(1374,7768,41298,88855,3,1324,'App\\Models\\Receipt',1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',4320.65,NULL,NULL,1,'2022-09-14 17:01:08','2022-09-14 17:06:19','2022-09-14 17:06:19'),(1375,7768,41298,88855,3,1323,'App\\Models\\Receipt',1323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',9990.00,NULL,NULL,1,'2022-09-14 17:01:12','2022-09-14 17:06:23','2022-09-14 17:06:23'),(1376,7768,41298,88855,3,1322,'App\\Models\\Receipt',1322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',1350.00,NULL,NULL,1,'2022-09-14 17:01:16','2022-09-14 17:06:27','2022-09-14 17:06:27'),(1377,7768,41298,88855,3,1320,'App\\Models\\Receipt',1320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',84499.00,NULL,NULL,1,'2022-09-14 17:01:21','2022-09-14 17:06:49','2022-09-14 17:06:49'),(1378,7768,41298,88855,3,1319,'App\\Models\\Receipt',1319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',9148.57,NULL,NULL,1,'2022-09-14 17:01:25','2022-09-14 17:06:53','2022-09-14 17:06:53'),(1379,7768,41298,88854,15,293,'App\\Models\\PeriodLiquidation',NULL,293,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',214.08,NULL,NULL,1,'2022-09-14 17:05:27','2022-09-14 17:05:27',NULL),(1380,7768,41298,88855,3,1324,'App\\Models\\Receipt',1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',4320.65,NULL,NULL,1,'2022-09-14 17:06:19','2022-09-14 17:07:17','2022-09-14 17:07:17'),(1381,7768,41298,88855,3,1323,'App\\Models\\Receipt',1323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',9990.00,NULL,NULL,1,'2022-09-14 17:06:23','2022-09-14 17:06:23',NULL),(1382,7768,41298,88855,3,1322,'App\\Models\\Receipt',1322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',1350.00,NULL,NULL,1,'2022-09-14 17:06:27','2022-09-14 17:06:27',NULL),(1383,7768,41298,88855,3,1321,'App\\Models\\Receipt',1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',52250.00,NULL,NULL,1,'2022-09-14 17:06:42','2022-09-14 17:06:42',NULL),(1384,7768,41298,88855,3,1320,'App\\Models\\Receipt',1320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',84499.00,NULL,NULL,1,'2022-09-14 17:06:49','2022-09-14 17:06:49',NULL),(1385,7768,41298,88855,3,1319,'App\\Models\\Receipt',1319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',9148.57,NULL,NULL,1,'2022-09-14 17:06:53','2022-09-14 17:06:53',NULL),(1386,7768,41298,88855,3,1324,'App\\Models\\Receipt',1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',4320.65,NULL,NULL,1,'2022-09-14 17:07:17','2022-09-14 17:07:17',NULL),(1387,7768,41298,88855,15,317,'App\\Models\\PeriodLiquidation',NULL,317,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',214.08,NULL,NULL,1,'2022-09-15 09:28:16','2022-10-13 22:36:38','2022-10-13 22:36:38');
INSERT INTO `balance_libro` VALUES (1388,7768,40728,13780,3,1325,'App\\Models\\Receipt',1325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',6015.00,NULL,NULL,1,'2022-09-16 01:21:58','2022-09-16 01:21:58',NULL),(1389,7768,40728,13780,3,1326,'App\\Models\\Receipt',1326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',6010.70,NULL,NULL,1,'2022-09-16 01:21:58','2022-09-16 01:21:58',NULL),(1390,7768,40728,13780,3,1327,'App\\Models\\Receipt',1327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',2513.96,NULL,NULL,1,'2022-09-16 01:21:58','2022-09-16 01:21:58',NULL),(1391,7768,40728,13780,3,1328,'App\\Models\\Receipt',1328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',3745.36,NULL,NULL,1,'2022-09-16 01:21:59','2022-09-16 01:21:59',NULL),(1392,7768,40728,13780,3,1329,'App\\Models\\Receipt',1329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',1534.11,NULL,NULL,1,'2022-09-16 01:21:59','2022-09-16 01:21:59',NULL),(1393,7768,40728,13780,3,1330,'App\\Models\\Receipt',1330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',18980.49,NULL,NULL,1,'2022-09-16 01:21:59','2022-11-08 15:40:19','2022-11-08 15:40:19'),(1394,7768,40728,13780,15,328,'App\\Models\\PeriodLiquidation',NULL,328,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',275896.88,NULL,NULL,1,'2022-09-19 12:22:40','2022-10-31 18:04:49','2022-10-31 18:04:49'),(1395,7768,40728,13761,3,1099,'App\\Models\\Receipt',1099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',700.74,NULL,NULL,1,'2022-10-01 09:10:10','2022-11-08 15:42:05','2022-11-08 15:42:05'),(1396,7768,40728,13760,3,1331,'App\\Models\\Receipt',1331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',1839.21,NULL,NULL,1,'2022-10-01 09:13:35','2022-11-08 15:40:06','2022-11-08 15:40:06'),(1397,7768,40728,13760,3,581,'App\\Models\\Receipt',581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',1370.09,NULL,NULL,1,'2022-10-01 09:20:15','2022-10-01 09:20:15',NULL),(1398,7768,40728,13760,15,334,'App\\Models\\PeriodLiquidation',NULL,334,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',215452.76,NULL,NULL,1,'2022-10-01 09:23:40','2022-10-26 23:48:34','2022-10-26 23:48:34'),(1399,7768,40728,13760,16,335,'App\\Models\\PeriodLiquidation',NULL,335,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',13597.29,NULL,NULL,1,'2022-10-01 09:24:16','2022-11-07 00:06:01','2022-11-07 00:06:01'),(1400,7768,40728,13761,3,1100,'App\\Models\\Receipt',1100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',0.05,NULL,NULL,1,'2022-10-01 09:29:23','2022-10-01 09:30:06','2022-10-01 09:30:06'),(1401,7768,40728,13761,3,1100,'App\\Models\\Receipt',1100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',0.03,NULL,NULL,1,'2022-10-01 09:30:06','2022-11-08 15:41:49','2022-11-08 15:41:49'),(1402,7768,40728,13761,3,1082,'App\\Models\\Receipt',1082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',10023.82,NULL,NULL,1,'2022-10-01 09:30:47','2022-10-01 09:30:47',NULL),(1403,7768,40728,13761,3,1078,'App\\Models\\Receipt',1078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',29149.78,NULL,NULL,1,'2022-10-01 09:31:18','2022-10-01 09:31:18',NULL),(1404,7768,40728,13761,3,1075,'App\\Models\\Receipt',1075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',1585.82,NULL,NULL,1,'2022-10-01 09:32:33','2022-10-01 09:32:33',NULL),(1405,7768,40728,13761,15,345,'App\\Models\\PeriodLiquidation',NULL,345,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',130455.50,NULL,NULL,1,'2022-10-01 09:34:36','2022-11-06 20:27:07','2022-11-06 20:27:07'),(1406,7768,40728,13761,16,347,'App\\Models\\PeriodLiquidation',NULL,347,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',10504.91,NULL,NULL,1,'2022-10-01 09:34:41','2022-11-06 23:49:39','2022-11-06 23:49:39');
INSERT INTO `balance_libro` VALUES (1407,7768,40728,13763,3,1230,'App\\Models\\Receipt',1230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',4692.25,NULL,NULL,1,'2022-10-01 09:37:34','2022-11-08 15:41:12','2022-11-08 15:41:12'),(1408,7768,40728,13762,3,1332,'App\\Models\\Receipt',1332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',7783.61,NULL,NULL,1,'2022-10-01 09:38:51','2022-10-01 09:49:49','2022-10-01 09:49:49'),(1409,7768,40728,13762,3,1259,'App\\Models\\Receipt',1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-29','2021-08-29',6031.19,NULL,NULL,1,'2022-10-01 09:39:36','2022-10-01 09:39:36',NULL),(1410,7768,40728,13762,3,1257,'App\\Models\\Receipt',1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',4398.82,NULL,NULL,1,'2022-10-01 09:39:56','2022-10-01 09:39:56',NULL),(1411,7768,40728,13762,3,1332,'App\\Models\\Receipt',1332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',7783.61,NULL,NULL,1,'2022-10-01 09:49:49','2022-11-08 15:39:53','2022-11-08 15:39:53'),(1412,7768,40728,13762,15,356,'App\\Models\\PeriodLiquidation',NULL,356,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',216438.33,NULL,NULL,1,'2022-10-01 09:52:35','2022-10-01 09:56:50','2022-10-01 09:56:50'),(1413,7768,40728,13762,16,357,'App\\Models\\PeriodLiquidation',NULL,357,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',18745.07,NULL,NULL,1,'2022-10-01 09:52:41','2022-11-07 08:11:37','2022-11-07 08:11:37'),(1414,7768,40728,13763,3,1208,'App\\Models\\Receipt',1208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',1232.82,NULL,NULL,1,'2022-10-01 09:55:23','2022-10-01 09:55:23',NULL),(1415,7768,40728,13763,16,359,'App\\Models\\PeriodLiquidation',NULL,359,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',24454.97,NULL,NULL,1,'2022-10-01 09:56:50','2022-11-06 23:49:03','2022-11-06 23:49:03'),(1416,7768,40728,13763,15,358,'App\\Models\\PeriodLiquidation',NULL,358,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',220974.08,NULL,NULL,1,'2022-10-01 09:58:35','2022-10-01 10:01:06','2022-10-01 10:01:06'),(1417,7768,40728,13764,3,764,'App\\Models\\Receipt',764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',3332.93,NULL,NULL,1,'2022-10-01 10:00:03','2022-10-01 10:00:03',NULL),(1418,7768,40728,13764,16,361,'App\\Models\\PeriodLiquidation',NULL,361,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',17737.76,NULL,NULL,1,'2022-10-01 10:01:06','2022-11-07 08:11:55','2022-11-07 08:11:55'),(1419,7768,40728,13764,15,360,'App\\Models\\PeriodLiquidation',NULL,360,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',144356.13,NULL,NULL,1,'2022-10-01 10:01:45','2022-10-01 10:05:01','2022-10-01 10:05:01'),(1420,7768,40728,13765,3,838,'App\\Models\\Receipt',838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',3431.04,NULL,NULL,1,'2022-10-01 10:02:45','2022-10-01 10:02:45',NULL),(1421,7768,40728,13765,16,363,'App\\Models\\PeriodLiquidation',NULL,363,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',20803.01,NULL,NULL,1,'2022-10-01 10:05:01','2022-11-07 08:12:38','2022-11-07 08:12:38'),(1422,7768,40728,13765,15,364,'App\\Models\\PeriodLiquidation',NULL,364,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',168264.21,NULL,NULL,1,'2022-10-01 10:07:40','2022-11-06 20:32:15','2022-11-06 20:32:15'),(1423,7768,40728,13781,3,1333,'App\\Models\\Receipt',1333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',14000.00,NULL,NULL,1,'2022-10-12 19:08:06','2022-10-12 19:08:06',NULL),(1424,7768,40728,13781,3,1334,'App\\Models\\Receipt',1334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',28000.00,NULL,NULL,1,'2022-10-12 19:08:06','2022-10-12 19:08:06',NULL),(1425,7768,40728,13781,3,1335,'App\\Models\\Receipt',1335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',7502.00,NULL,NULL,1,'2022-10-12 19:08:06','2022-10-12 19:08:06',NULL);
INSERT INTO `balance_libro` VALUES (1426,7768,40728,13781,3,1336,'App\\Models\\Receipt',1336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-01','2022-09-01',28000.00,NULL,NULL,1,'2022-10-12 19:08:06','2022-10-12 19:08:06',NULL),(1427,7768,40728,13781,3,1337,'App\\Models\\Receipt',1337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',26000.00,NULL,NULL,1,'2022-10-12 19:08:06','2022-11-08 15:32:20','2022-11-08 15:32:20'),(1428,7768,40728,13781,3,1338,'App\\Models\\Receipt',1338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',1918.59,NULL,NULL,1,'2022-10-12 19:08:06','2022-10-12 19:08:06',NULL),(1429,7768,40728,13781,3,1339,'App\\Models\\Receipt',1339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',2600.00,NULL,NULL,1,'2022-10-12 19:08:06','2022-10-12 19:08:06',NULL),(1430,7768,40728,13781,3,1340,'App\\Models\\Receipt',1340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',5400.01,NULL,NULL,1,'2022-10-12 19:08:06','2022-10-12 19:08:06',NULL),(1431,7768,40728,13781,3,1341,'App\\Models\\Receipt',1341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',1334.92,NULL,NULL,1,'2022-10-12 19:08:07','2022-10-12 19:08:07',NULL),(1432,7768,40728,13781,3,1342,'App\\Models\\Receipt',1342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',13570.00,NULL,NULL,1,'2022-10-12 19:08:07','2022-10-12 19:08:07',NULL),(1433,7768,40728,13781,3,1343,'App\\Models\\Receipt',1343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',1083.00,NULL,NULL,1,'2022-10-12 19:08:07','2022-10-12 19:08:07',NULL),(1434,7768,40728,13781,3,1344,'App\\Models\\Receipt',1344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',1700.00,NULL,NULL,1,'2022-10-12 19:08:07','2022-10-12 19:08:07',NULL),(1435,7768,40728,13781,3,1345,'App\\Models\\Receipt',1345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',1160.56,NULL,NULL,1,'2022-10-12 19:08:07','2022-10-12 19:08:07',NULL),(1436,7768,40728,13781,3,1346,'App\\Models\\Receipt',1346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',3310.00,NULL,NULL,1,'2022-10-12 19:08:07','2022-10-12 19:08:07',NULL),(1437,7768,40728,13781,3,1347,'App\\Models\\Receipt',1347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',70873.94,NULL,NULL,1,'2022-10-12 19:08:07','2022-10-12 19:08:07',NULL),(1438,7768,40728,13781,3,1348,'App\\Models\\Receipt',1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',33607.35,NULL,NULL,1,'2022-10-12 19:08:07','2022-10-17 10:38:52','2022-10-17 10:38:52'),(1439,7768,40728,13781,3,1349,'App\\Models\\Receipt',1349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',25000.00,NULL,NULL,1,'2022-10-12 19:08:07','2022-11-08 15:26:56','2022-11-08 15:26:56'),(1440,7768,40728,13781,3,1350,'App\\Models\\Receipt',1350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-14','2022-09-14',2125.58,NULL,NULL,1,'2022-10-12 19:08:07','2022-10-12 19:08:07',NULL),(1441,7768,40728,13781,3,1351,'App\\Models\\Receipt',1351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',28729.22,NULL,NULL,1,'2022-10-12 19:08:07','2022-10-12 19:08:07',NULL),(1442,7768,40728,13781,3,1352,'App\\Models\\Receipt',1352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',66307.58,NULL,NULL,1,'2022-10-12 19:08:07','2022-10-12 19:08:07',NULL),(1443,7768,40728,13781,3,1353,'App\\Models\\Receipt',1353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',80344.00,NULL,NULL,1,'2022-10-12 19:08:07','2022-10-12 19:08:07',NULL),(1444,7768,40728,13781,3,1354,'App\\Models\\Receipt',1354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',164560.00,NULL,NULL,1,'2022-10-12 19:08:07','2022-10-12 19:08:07',NULL),(1445,7768,40728,13781,3,1355,'App\\Models\\Receipt',1355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',200.01,NULL,NULL,1,'2022-10-12 19:08:07','2022-10-12 19:08:07',NULL);
INSERT INTO `balance_libro` VALUES (1446,7768,40728,13781,3,1356,'App\\Models\\Receipt',1356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',28729.22,NULL,NULL,1,'2022-10-12 19:08:07','2022-10-12 19:08:07',NULL),(1447,7768,40728,13781,3,1357,'App\\Models\\Receipt',1357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',8733.78,NULL,NULL,1,'2022-10-12 19:08:07','2022-10-12 19:08:07',NULL),(1448,7768,40728,13781,3,1358,'App\\Models\\Receipt',1358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',23900.00,NULL,NULL,1,'2022-10-12 19:08:07','2022-10-12 19:08:07',NULL),(1449,7768,40728,13781,3,1359,'App\\Models\\Receipt',1359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',1427991.74,NULL,NULL,1,'2022-10-12 19:08:07','2022-10-12 19:08:07',NULL),(1450,7768,40728,13781,3,1360,'App\\Models\\Receipt',1360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',1068.36,NULL,NULL,1,'2022-10-12 19:08:07','2022-10-12 19:08:07',NULL),(1451,7768,40728,13781,3,1361,'App\\Models\\Receipt',1361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',18500.00,NULL,NULL,1,'2022-10-12 19:08:08','2022-10-12 19:08:08',NULL),(1452,7768,40728,13781,3,1362,'App\\Models\\Receipt',1362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',11306.74,NULL,NULL,1,'2022-10-12 19:08:08','2022-10-12 19:08:08',NULL),(1453,7768,40728,13781,3,1363,'App\\Models\\Receipt',1363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',3499.63,NULL,NULL,1,'2022-10-12 19:08:08','2022-10-12 19:08:08',NULL),(1454,7768,40728,13781,3,1364,'App\\Models\\Receipt',1364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',3363.71,NULL,NULL,1,'2022-10-12 19:08:08','2022-10-12 19:08:08',NULL),(1455,7768,40728,13781,3,1365,'App\\Models\\Receipt',1365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',261709.61,NULL,NULL,1,'2022-10-12 19:08:08','2022-10-12 19:08:08',NULL),(1456,7768,40728,13781,2,1366,'App\\Models\\Receipt',1366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',581720.48,NULL,NULL,1,'2022-10-12 19:08:22','2022-10-12 19:08:22',NULL),(1457,7768,40728,13781,2,1367,'App\\Models\\Receipt',1367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',366041.13,NULL,NULL,1,'2022-10-12 19:08:22','2022-10-12 19:08:22',NULL),(1458,7768,40728,13781,2,1368,'App\\Models\\Receipt',1368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',476537.81,NULL,NULL,1,'2022-10-12 19:08:22','2022-10-12 19:08:22',NULL),(1459,7768,40728,13781,2,1369,'App\\Models\\Receipt',1369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',26762.97,NULL,NULL,1,'2022-10-12 19:08:22','2022-10-12 19:08:22',NULL),(1460,7768,40728,13781,2,1370,'App\\Models\\Receipt',1370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',73112.14,NULL,NULL,1,'2022-10-12 19:08:22','2022-10-12 19:08:22',NULL),(1461,7768,41298,88856,3,1371,'App\\Models\\Receipt',1371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',15000.00,NULL,NULL,1,'2022-10-13 22:29:51','2022-10-13 22:29:51',NULL),(1462,7768,41298,88856,3,1372,'App\\Models\\Receipt',1372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',52250.00,NULL,NULL,1,'2022-10-13 22:29:51','2022-10-16 18:50:30','2022-10-16 18:50:30'),(1463,7768,41298,88856,3,1373,'App\\Models\\Receipt',1373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-10','2022-09-10',1079.33,NULL,NULL,1,'2022-10-13 22:29:51','2022-10-13 22:29:51',NULL),(1464,7768,41298,88856,3,1374,'App\\Models\\Receipt',1374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-11','2022-09-11',4000.01,NULL,NULL,1,'2022-10-13 22:29:51','2022-10-13 22:29:51',NULL),(1465,7768,41298,88856,3,1375,'App\\Models\\Receipt',1375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',33895.68,NULL,NULL,1,'2022-10-13 22:29:51','2022-10-13 22:29:51',NULL);
INSERT INTO `balance_libro` VALUES (1466,7768,41298,88856,3,1376,'App\\Models\\Receipt',1376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',33895.68,NULL,NULL,1,'2022-10-13 22:29:51','2022-10-13 22:29:51',NULL),(1467,7768,41298,88856,3,1377,'App\\Models\\Receipt',1377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',33895.68,NULL,NULL,1,'2022-10-13 22:29:51','2022-10-13 22:29:51',NULL),(1468,7768,41298,88852,16,321,'App\\Models\\PeriodLiquidation',NULL,321,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',0.00,NULL,NULL,1,'2022-10-13 22:36:33','2022-10-13 22:36:33',NULL),(1469,7768,41298,88853,16,319,'App\\Models\\PeriodLiquidation',NULL,319,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',0.00,NULL,NULL,1,'2022-10-13 22:36:38','2022-10-13 22:36:38',NULL),(1470,7768,41298,88854,16,292,'App\\Models\\PeriodLiquidation',NULL,292,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',0.00,NULL,NULL,1,'2022-10-13 22:36:44','2022-10-13 22:36:44',NULL),(1471,7768,41298,88855,16,318,'App\\Models\\PeriodLiquidation',NULL,318,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',0.00,NULL,NULL,1,'2022-10-13 22:36:49','2022-10-13 22:36:49',NULL),(1472,7768,41323,91875,2,1378,'App\\Models\\Receipt',1378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',200000.00,NULL,NULL,1,'2022-10-13 23:59:26','2022-10-13 23:59:26',NULL),(1473,7768,41323,91875,2,1379,'App\\Models\\Receipt',1379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',200000.00,NULL,NULL,1,'2022-10-13 23:59:26','2022-10-13 23:59:26',NULL),(1474,7768,41323,91875,2,1380,'App\\Models\\Receipt',1380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',200000.00,NULL,NULL,1,'2022-10-13 23:59:26','2022-10-13 23:59:26',NULL),(1475,7768,40728,13758,12,1475,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',3591404.49,'ASIENTO DE APERTURA',NULL,1,'2022-10-15 11:04:53','2022-10-15 11:04:53',NULL),(1476,7768,41298,88856,3,1381,'App\\Models\\Receipt',1381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',30000.00,NULL,NULL,1,'2022-10-16 18:59:59','2022-10-16 18:59:59',NULL),(1477,7768,41298,88856,3,1382,'App\\Models\\Receipt',1382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',1779.04,NULL,NULL,1,'2022-10-16 19:01:25','2022-10-16 19:02:53','2022-10-16 19:02:53'),(1478,7768,41298,88856,3,1382,'App\\Models\\Receipt',1382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',2000.01,NULL,NULL,1,'2022-10-16 19:02:53','2022-10-16 19:03:36','2022-10-16 19:03:36'),(1479,7768,41298,88856,3,1382,'App\\Models\\Receipt',1382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-17','2022-09-17',2000.01,NULL,NULL,1,'2022-10-16 19:03:36','2022-10-16 19:03:36',NULL),(1480,7768,41298,88856,3,1383,'App\\Models\\Receipt',1383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-18','2022-09-18',3909.60,NULL,NULL,1,'2022-10-16 19:05:05','2022-10-16 19:05:05',NULL),(1481,7768,41298,88856,3,1384,'App\\Models\\Receipt',1384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-18','2022-09-18',6051.20,NULL,NULL,1,'2022-10-16 19:12:30','2022-10-16 19:12:30',NULL),(1482,7768,41298,88856,16,389,'App\\Models\\PeriodLiquidation',NULL,389,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',0.00,NULL,NULL,1,'2022-10-16 19:31:12','2022-10-18 16:49:02','2022-10-18 16:49:02'),(1483,7768,41298,88856,15,387,'App\\Models\\PeriodLiquidation',NULL,387,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',8603.88,NULL,NULL,1,'2022-10-16 19:32:05','2022-10-16 19:32:05',NULL),(1484,7768,41322,90360,3,1385,'App\\Models\\Receipt',1385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',189000.00,NULL,NULL,1,'2022-10-16 20:04:39','2022-10-16 20:04:39',NULL),(1485,7768,41322,90360,15,392,'App\\Models\\PeriodLiquidation',NULL,392,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',0.00,NULL,NULL,1,'2022-10-16 20:16:59','2022-10-16 20:16:59',NULL);
INSERT INTO `balance_libro` VALUES (1486,7768,41322,90360,16,391,'App\\Models\\PeriodLiquidation',NULL,391,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',0.00,NULL,NULL,1,'2022-10-16 20:17:11','2022-10-18 16:52:13','2022-10-18 16:52:13'),(1487,7768,41322,90361,15,393,'App\\Models\\PeriodLiquidation',NULL,393,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',0.00,NULL,NULL,1,'2022-10-16 20:58:28','2022-10-16 20:58:28',NULL),(1488,7768,41322,90361,16,394,'App\\Models\\PeriodLiquidation',NULL,394,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',0.00,NULL,NULL,1,'2022-10-16 20:58:32','2022-10-16 20:58:32',NULL),(1489,7768,40728,13781,3,1386,'App\\Models\\Receipt',1386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',3724.38,NULL,NULL,1,'2022-10-17 10:24:54','2022-10-17 10:24:54',NULL),(1490,7768,40728,13781,3,1387,'App\\Models\\Receipt',1387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',21000.03,NULL,NULL,1,'2022-10-17 10:24:54','2022-10-17 10:24:54',NULL),(1491,7768,40728,13781,3,1388,'App\\Models\\Receipt',1388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-21','2022-09-21',757.15,NULL,NULL,1,'2022-10-17 10:24:54','2022-10-17 10:24:54',NULL),(1492,7768,40728,13781,3,1389,'App\\Models\\Receipt',1389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-16','2022-09-16',1675.97,NULL,NULL,1,'2022-10-17 10:24:54','2022-10-17 10:24:54',NULL),(1493,7768,40728,13781,3,1390,'App\\Models\\Receipt',1390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',3000.21,NULL,NULL,1,'2022-10-17 10:24:54','2022-11-07 08:09:17','2022-11-07 08:09:17'),(1494,7768,40728,13781,3,1391,'App\\Models\\Receipt',1391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-03','2022-09-03',13396.82,NULL,NULL,1,'2022-10-17 10:24:54','2022-10-17 10:36:05','2022-10-17 10:36:05'),(1495,7768,40728,13781,3,1392,'App\\Models\\Receipt',1392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',3420.00,NULL,NULL,1,'2022-10-17 10:24:54','2022-10-17 10:24:54',NULL),(1496,7768,40728,13781,3,1393,'App\\Models\\Receipt',1393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',3000.00,NULL,NULL,1,'2022-10-17 10:24:54','2022-10-17 10:24:54',NULL),(1497,7768,40728,13781,3,1394,'App\\Models\\Receipt',1394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',6850.30,NULL,NULL,1,'2022-10-17 10:24:54','2022-10-17 10:24:54',NULL),(1498,7768,40728,13781,3,1395,'App\\Models\\Receipt',1395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',37045.94,NULL,NULL,1,'2022-10-17 10:24:54','2022-10-17 10:24:54',NULL),(1499,7768,40728,13781,3,1396,'App\\Models\\Receipt',1396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',2360.78,NULL,NULL,1,'2022-10-17 10:24:54','2022-10-17 10:24:54',NULL),(1500,7768,40728,13781,3,1397,'App\\Models\\Receipt',1397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',16887.70,NULL,NULL,1,'2022-10-17 10:24:55','2022-11-08 15:39:41','2022-11-08 15:39:41'),(1501,7768,40728,13781,3,1348,'App\\Models\\Receipt',1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',33607.35,NULL,NULL,1,'2022-10-17 10:38:52','2022-11-17 19:07:31','2022-11-17 19:07:31'),(1502,7768,41322,90362,16,395,'App\\Models\\PeriodLiquidation',NULL,395,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',0.00,NULL,NULL,1,'2022-10-18 16:47:58','2022-10-18 16:47:58',NULL),(1503,7768,41322,90362,15,396,'App\\Models\\PeriodLiquidation',NULL,396,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',0.00,NULL,NULL,1,'2022-10-18 16:48:14','2022-10-18 16:48:14',NULL),(1504,7768,41322,90363,15,408,'App\\Models\\PeriodLiquidation',NULL,408,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',0.00,NULL,NULL,1,'2022-10-18 16:48:58','2022-10-18 16:48:58',NULL),(1505,7768,41322,90363,16,409,'App\\Models\\PeriodLiquidation',NULL,409,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',0.00,NULL,NULL,1,'2022-10-18 16:49:03','2022-10-18 16:49:03',NULL);
INSERT INTO `balance_libro` VALUES (1506,7768,41322,90364,16,411,'App\\Models\\PeriodLiquidation',NULL,411,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',0.00,NULL,NULL,1,'2022-10-18 16:49:29','2022-10-18 16:49:29',NULL),(1507,7768,41322,90364,15,410,'App\\Models\\PeriodLiquidation',NULL,410,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',0.00,NULL,NULL,1,'2022-10-18 16:49:36','2022-10-23 11:05:31','2022-10-23 11:05:31'),(1508,7768,41322,90365,3,1398,'App\\Models\\Receipt',1398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-12','2022-08-12',103.87,NULL,NULL,1,'2022-10-18 16:50:42','2022-10-18 16:50:42',NULL),(1509,7768,41322,90365,15,412,'App\\Models\\PeriodLiquidation',NULL,412,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',18.03,NULL,NULL,1,'2022-10-18 16:52:04','2022-10-23 11:13:44','2022-10-23 11:13:44'),(1510,7768,41322,90365,16,413,'App\\Models\\PeriodLiquidation',NULL,413,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',0.00,NULL,NULL,1,'2022-10-18 16:52:13','2022-10-18 16:52:13',NULL),(1511,7768,41322,90366,15,414,'App\\Models\\PeriodLiquidation',NULL,414,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',18.03,NULL,NULL,1,'2022-10-18 17:02:13','2022-10-18 17:02:13',NULL),(1512,7768,40728,13766,3,1137,'App\\Models\\Receipt',1137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-13','2021-12-13',4274.20,NULL,NULL,1,'2022-10-23 10:39:27','2022-10-23 10:39:27',NULL),(1513,7768,40728,13766,3,1142,'App\\Models\\Receipt',1142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',9146.58,NULL,NULL,1,'2022-10-23 10:49:24','2022-10-23 10:49:24',NULL),(1514,7768,40728,13766,3,1152,'App\\Models\\Receipt',1152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',54451.27,NULL,NULL,1,'2022-10-23 10:52:35','2022-10-23 10:52:35',NULL),(1515,7768,40728,13766,3,1156,'App\\Models\\Receipt',1156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',34185.38,NULL,NULL,1,'2022-10-23 10:54:15','2022-10-23 10:54:15',NULL),(1516,7768,40728,13766,3,1166,'App\\Models\\Receipt',1166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',2534.45,NULL,NULL,1,'2022-10-23 10:54:45','2022-11-07 08:41:09','2022-11-07 08:41:09'),(1517,7768,40728,13766,3,1141,'App\\Models\\Receipt',1141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',22084.92,NULL,NULL,1,'2022-10-23 10:56:17','2022-10-23 10:56:17',NULL),(1518,7768,40728,13766,16,426,'App\\Models\\PeriodLiquidation',NULL,426,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',14269.25,NULL,NULL,1,'2022-10-23 10:57:36','2022-10-29 09:29:28','2022-10-29 09:29:28'),(1519,7768,40728,13766,15,425,'App\\Models\\PeriodLiquidation',NULL,425,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',216120.50,NULL,NULL,1,'2022-10-23 10:58:01','2022-11-06 20:33:31','2022-11-06 20:33:31'),(1520,7768,40728,13773,3,509,'App\\Models\\Receipt',509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',3783.75,NULL,NULL,1,'2022-10-23 11:00:27','2022-10-23 11:00:27',NULL),(1521,7768,40728,13774,3,453,'App\\Models\\Receipt',453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',3955.24,NULL,NULL,1,'2022-10-23 11:00:49','2022-10-23 11:00:49',NULL),(1522,7768,40728,13775,3,418,'App\\Models\\Receipt',418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',4872.24,NULL,NULL,1,'2022-10-23 11:01:22','2022-10-23 11:01:22',NULL),(1523,7768,40728,13773,3,500,'App\\Models\\Receipt',500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',4904.04,NULL,NULL,1,'2022-10-23 11:03:39','2022-10-23 11:03:39',NULL),(1524,7768,40728,13773,16,434,'App\\Models\\PeriodLiquidation',NULL,434,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',27452.79,NULL,NULL,1,'2022-10-23 11:05:31','2022-11-07 08:12:54','2022-11-07 08:12:54'),(1525,7768,40728,13773,15,433,'App\\Models\\PeriodLiquidation',NULL,433,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',370884.07,NULL,NULL,1,'2022-10-23 11:05:42','2022-11-07 08:13:00','2022-11-07 08:13:00');
INSERT INTO `balance_libro` VALUES (1526,7768,40728,13774,3,461,'App\\Models\\Receipt',461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',6536.15,NULL,NULL,1,'2022-10-23 11:09:33','2022-11-08 15:43:09','2022-11-08 15:43:09'),(1527,7768,40728,13774,16,436,'App\\Models\\PeriodLiquidation',NULL,436,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',23139.36,NULL,NULL,1,'2022-10-23 11:13:44','2022-11-07 08:13:05','2022-11-07 08:13:05'),(1528,7768,40728,13774,15,435,'App\\Models\\PeriodLiquidation',NULL,435,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',100712.78,NULL,NULL,1,'2022-10-23 11:13:52','2022-11-06 20:34:29','2022-11-06 20:34:29'),(1529,7768,40728,13775,3,420,'App\\Models\\Receipt',420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',4679.62,NULL,NULL,1,'2022-10-23 11:23:10','2022-11-07 08:39:22','2022-11-07 08:39:22'),(1530,7768,40728,13775,16,439,'App\\Models\\PeriodLiquidation',NULL,439,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',23478.31,NULL,NULL,1,'2022-10-23 11:23:33','2022-11-07 08:13:11','2022-11-07 08:13:11'),(1531,7768,40728,13775,15,438,'App\\Models\\PeriodLiquidation',NULL,438,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',119459.90,NULL,NULL,1,'2022-10-23 11:23:39','2022-11-07 08:13:18','2022-11-07 08:13:18'),(1532,7768,41298,88857,3,1399,'App\\Models\\Receipt',1399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',6501.20,NULL,NULL,1,'2022-10-24 20:42:10','2022-10-24 20:42:10',NULL),(1533,7768,41298,88857,3,1400,'App\\Models\\Receipt',1400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',8000.00,NULL,NULL,1,'2022-10-24 20:42:10','2022-10-24 20:42:10',NULL),(1534,7768,41298,88857,3,1401,'App\\Models\\Receipt',1401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',106900.00,NULL,NULL,1,'2022-10-24 20:42:10','2022-11-15 21:18:13','2022-11-15 21:18:13'),(1535,7768,41298,88857,3,1402,'App\\Models\\Receipt',1402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',13500.00,NULL,NULL,1,'2022-10-24 20:42:10','2022-10-24 20:42:10',NULL),(1536,7768,41298,88857,3,1403,'App\\Models\\Receipt',1403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',4500.00,NULL,NULL,1,'2022-10-24 20:42:10','2022-11-14 19:04:46','2022-11-14 19:04:46'),(1537,7768,41298,88857,3,1404,'App\\Models\\Receipt',1404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-09','2022-10-09',3000.00,NULL,NULL,1,'2022-10-24 20:42:10','2022-10-24 20:42:10',NULL),(1538,7768,41298,88857,3,1405,'App\\Models\\Receipt',1405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',15000.00,NULL,NULL,1,'2022-10-24 20:42:10','2022-10-24 20:42:10',NULL),(1539,7768,41298,88857,3,1406,'App\\Models\\Receipt',1406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',19999.99,NULL,NULL,1,'2022-10-24 20:42:10','2022-10-24 20:42:10',NULL),(1540,7768,41298,88857,3,1407,'App\\Models\\Receipt',1407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',1098.36,NULL,NULL,1,'2022-10-24 20:42:10','2022-10-24 20:42:10',NULL),(1541,7768,41298,88857,3,1408,'App\\Models\\Receipt',1408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-16','2022-10-16',6601.39,NULL,NULL,1,'2022-10-24 20:42:10','2022-10-24 20:42:10',NULL),(1542,7768,41298,88857,3,1409,'App\\Models\\Receipt',1409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',4819.60,NULL,NULL,1,'2022-10-24 20:42:10','2022-11-15 21:03:30','2022-11-15 21:03:30'),(1543,7768,41298,88857,3,1410,'App\\Models\\Receipt',1410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',5291.41,NULL,NULL,1,'2022-10-24 20:42:10','2022-10-24 20:42:10',NULL),(1544,7768,41298,88857,2,1411,'App\\Models\\Receipt',1411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',125235.00,NULL,NULL,1,'2022-10-24 20:42:48','2022-10-24 20:42:48',NULL),(1545,7768,40728,13782,3,1412,'App\\Models\\Receipt',1412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',4700.00,NULL,NULL,1,'2022-10-26 23:06:51','2022-10-26 23:06:51',NULL);
INSERT INTO `balance_libro` VALUES (1546,7768,40728,13782,3,1413,'App\\Models\\Receipt',1413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',1600.04,NULL,NULL,1,'2022-10-26 23:06:51','2022-10-26 23:06:51',NULL),(1547,7768,40728,13782,3,1414,'App\\Models\\Receipt',1414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',79363.66,NULL,NULL,1,'2022-10-26 23:06:51','2022-10-26 23:06:51',NULL),(1548,7768,40728,13782,3,1415,'App\\Models\\Receipt',1415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',4550.00,NULL,NULL,1,'2022-10-26 23:06:51','2022-10-26 23:06:51',NULL),(1549,7768,40728,13782,3,1416,'App\\Models\\Receipt',1416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',7502.00,NULL,NULL,1,'2022-10-26 23:06:51','2022-10-26 23:06:51',NULL),(1550,7768,40728,13782,3,1417,'App\\Models\\Receipt',1417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',15000.00,NULL,NULL,1,'2022-10-26 23:06:51','2022-11-08 15:32:09','2022-11-08 15:32:09'),(1551,7768,40728,13782,3,1418,'App\\Models\\Receipt',1418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1800.00,NULL,NULL,1,'2022-10-26 23:06:51','2022-10-26 23:06:51',NULL),(1552,7768,40728,13782,3,1419,'App\\Models\\Receipt',1419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',1069.64,NULL,NULL,1,'2022-10-26 23:06:51','2022-10-26 23:06:51',NULL),(1553,7768,40728,13782,3,1420,'App\\Models\\Receipt',1420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',3200.00,NULL,NULL,1,'2022-10-26 23:06:52','2022-10-26 23:06:52',NULL),(1554,7768,40728,13782,3,1421,'App\\Models\\Receipt',1421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',35363.79,NULL,NULL,1,'2022-10-26 23:06:52','2022-11-17 19:05:56','2022-11-17 19:05:56'),(1555,7768,40728,13782,3,1422,'App\\Models\\Receipt',1422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',3757.44,NULL,NULL,1,'2022-10-26 23:06:52','2022-10-26 23:06:52',NULL),(1556,7768,40728,13782,3,1423,'App\\Models\\Receipt',1423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',16187.42,NULL,NULL,1,'2022-10-26 23:06:52','2022-10-26 23:06:52',NULL),(1557,7768,40728,13782,3,1424,'App\\Models\\Receipt',1424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',2200.02,NULL,NULL,1,'2022-10-26 23:06:52','2022-10-26 23:06:52',NULL),(1558,7768,40728,13782,3,1425,'App\\Models\\Receipt',1425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',2273.90,NULL,NULL,1,'2022-10-26 23:06:52','2022-10-26 23:06:52',NULL),(1559,7768,40728,13782,3,1426,'App\\Models\\Receipt',1426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',3932.40,NULL,NULL,1,'2022-10-26 23:06:52','2022-10-26 23:06:52',NULL),(1560,7768,40728,13782,3,1427,'App\\Models\\Receipt',1427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',4766.90,NULL,NULL,1,'2022-10-26 23:06:52','2022-11-07 08:40:00','2022-11-07 08:40:00'),(1561,7768,40728,13782,3,1428,'App\\Models\\Receipt',1428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',11250.01,NULL,NULL,1,'2022-10-26 23:06:52','2022-10-26 23:06:52',NULL),(1562,7768,40728,13782,3,1429,'App\\Models\\Receipt',1429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',12000.01,NULL,NULL,1,'2022-10-26 23:06:52','2022-10-26 23:06:52',NULL),(1563,7768,40728,13782,3,1430,'App\\Models\\Receipt',1430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',47708.82,NULL,NULL,1,'2022-10-26 23:06:52','2022-10-26 23:06:52',NULL),(1564,7768,40728,13782,3,1431,'App\\Models\\Receipt',1431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',4200.05,NULL,NULL,1,'2022-10-26 23:06:52','2022-10-26 23:06:52',NULL),(1565,7768,40728,13782,3,1432,'App\\Models\\Receipt',1432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',3852.47,NULL,NULL,1,'2022-10-26 23:06:52','2022-11-07 08:39:47','2022-11-07 08:39:47');
INSERT INTO `balance_libro` VALUES (1566,7768,40728,13782,3,1433,'App\\Models\\Receipt',1433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',53595.90,NULL,NULL,1,'2022-10-26 23:06:52','2022-11-17 23:28:53','2022-11-17 23:28:53'),(1567,7768,40728,13782,3,1434,'App\\Models\\Receipt',1434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',4850.17,NULL,NULL,1,'2022-10-26 23:06:52','2022-10-26 23:06:52',NULL),(1568,7768,40728,13782,3,1435,'App\\Models\\Receipt',1435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',2918.92,NULL,NULL,1,'2022-10-26 23:06:52','2022-10-26 23:06:52',NULL),(1569,7768,40728,13782,2,1436,'App\\Models\\Receipt',1436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',1177271.63,NULL,NULL,1,'2022-10-26 23:08:52','2022-10-26 23:08:52',NULL),(1570,7768,40728,13782,2,1437,'App\\Models\\Receipt',1437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',125997.98,NULL,NULL,1,'2022-10-26 23:08:53','2022-10-26 23:08:53',NULL),(1571,7768,40728,13782,2,1438,'App\\Models\\Receipt',1438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',110947.32,NULL,NULL,1,'2022-10-26 23:08:53','2022-10-26 23:08:53',NULL),(1572,7768,40728,13782,2,1439,'App\\Models\\Receipt',1439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',93001.07,NULL,NULL,1,'2022-10-26 23:10:41','2022-10-26 23:10:41',NULL),(1573,7768,40728,13782,2,1440,'App\\Models\\Receipt',1440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',110947.32,NULL,NULL,1,'2022-10-26 23:10:41','2022-10-26 23:10:41',NULL),(1574,7768,40728,13782,2,1441,'App\\Models\\Receipt',1441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',387200.00,NULL,NULL,1,'2022-10-26 23:10:41','2022-10-26 23:10:41',NULL),(1575,7768,40728,13760,7,1442,'App\\Models\\Receipt',1442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',0.00,NULL,NULL,1,'2022-10-26 23:48:34','2022-11-06 20:26:13','2022-11-06 20:26:13'),(1576,7768,40728,13761,5,1576,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',0.03,'Banco ICBC 05-2021',NULL,1,'2022-10-27 01:24:02','2022-11-06 16:16:35','2022-11-06 16:16:35'),(1577,7768,40728,13761,5,1577,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',2539.94,'Banco ICBC 06-2021',NULL,1,'2022-10-27 01:24:33','2022-11-06 16:14:42','2022-11-06 16:14:42'),(1578,7768,40728,13761,5,1578,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',392.97,'Banco ICBC 07-2021',NULL,1,'2022-10-27 01:25:41','2022-11-06 16:15:15','2022-11-06 16:15:15'),(1579,7768,40728,13762,5,1579,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',12475.85,'Banco ICBC 08-2021',NULL,1,'2022-10-27 01:26:12','2022-11-06 16:12:46','2022-11-06 16:12:46'),(1580,7768,40728,13763,5,1580,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',15800.13,'Banco ICBC 09-2021',NULL,1,'2022-10-27 01:26:43','2022-11-06 16:17:00','2022-11-06 16:17:00'),(1581,7768,40728,13764,5,1581,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',7955.80,'Banco ICBC 10-2021',NULL,1,'2022-10-27 01:27:57','2022-11-06 16:15:43','2022-11-06 16:15:43'),(1582,7768,40728,13765,5,1582,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',16132.10,'Banco ICBC',NULL,1,'2022-10-27 01:28:24','2022-11-06 16:17:24','2022-11-06 16:17:24'),(1583,7768,40728,13766,5,1583,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',15813.29,'Banco ICBC 12-2021',NULL,1,'2022-10-27 01:28:58','2022-11-06 16:17:49','2022-11-06 16:17:49'),(1584,7768,40728,13773,5,1584,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',6536.15,'Banco ICBC 01-2022',NULL,1,'2022-10-27 01:29:21','2022-11-06 16:18:14','2022-11-06 16:18:14');
INSERT INTO `balance_libro` VALUES (1585,7768,40728,13774,5,1585,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',30596.93,'Banco ICBC 02-2022',NULL,1,'2022-10-27 01:29:58','2022-11-06 18:44:41','2022-11-06 18:44:41'),(1586,7768,40728,13775,5,1586,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',3849.43,'Banco ICBC',NULL,1,'2022-10-27 01:30:25','2022-11-06 16:16:10','2022-11-06 16:16:10'),(1587,7768,40728,13763,10,1587,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',11758.08,'PAGO IIBB CM',NULL,1,'2022-10-28 11:58:07','2022-10-28 11:58:07',NULL),(1588,7768,40728,13763,10,1588,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-06','2021-09-06',11219.62,'PAGO IIBB CM',NULL,1,'2022-10-28 11:59:19','2022-10-28 11:59:19',NULL),(1589,7768,40728,13763,10,1589,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',9318.25,'PAGO IIBB CM',NULL,1,'2022-10-28 12:00:00','2022-10-28 12:00:00',NULL),(1590,7768,40728,13765,10,1590,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',8346.85,'PAGO IIBB CM',NULL,1,'2022-10-28 12:00:57','2022-10-28 12:00:57',NULL),(1591,7768,40728,13765,10,1591,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-09','2021-11-09',9774.81,'PAGO IIBB CM',NULL,1,'2022-10-28 12:01:32','2022-10-28 12:01:32',NULL),(1592,7768,40728,13765,10,1592,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-09','2021-11-09',15214.73,'PAGO IIBB CM',NULL,1,'2022-10-28 12:02:31','2022-10-28 12:02:31',NULL),(1593,7768,40728,13766,10,1593,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',4141.63,'PAGO IIBB CM',NULL,1,'2022-10-28 12:03:09','2022-10-28 12:03:09',NULL),(1594,7768,40728,13773,10,1594,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',3786.19,'PAGO IIBB CM',NULL,1,'2022-10-28 12:03:48','2022-10-28 12:03:48',NULL),(1595,7768,40728,13774,10,1595,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',17727.26,'PAGO IIBB CM',NULL,1,'2022-10-28 12:04:30','2022-10-28 12:04:30',NULL),(1596,7768,40728,13775,10,1596,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',1665.56,'PAGO IIBB CM',NULL,1,'2022-10-28 12:05:02','2022-11-24 10:44:07','2022-11-24 10:44:07'),(1597,7768,40728,13775,10,1597,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',2500.00,'PAGO IIBB CM',NULL,1,'2022-10-28 12:05:32','2022-11-24 10:49:33','2022-11-24 10:49:33'),(1598,7768,40728,13765,10,1598,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-09','2021-11-09',5790.54,'PAGO DDJJ IVA - INTERESES 07-2022',NULL,1,'2022-10-28 12:09:53','2022-10-28 12:09:53',NULL),(1599,7768,40728,13773,10,1599,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',3983.78,'PAGO DDJJ IVA - INTERESES',NULL,1,'2022-10-28 12:10:35','2022-10-28 12:10:35',NULL),(1600,7768,41352,93399,2,1443,'App\\Models\\Receipt',1443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',183615.48,NULL,NULL,1,'2022-10-28 15:59:23','2022-10-28 15:59:23',NULL),(1601,7768,41352,93399,2,1444,'App\\Models\\Receipt',1444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',68210.00,NULL,NULL,1,'2022-10-28 15:59:23','2022-10-28 15:59:23',NULL),(1602,7768,41352,93399,2,1445,'App\\Models\\Receipt',1445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',90349.89,NULL,NULL,1,'2022-10-28 15:59:23','2022-10-28 15:59:23',NULL),(1603,7768,41352,93399,2,1446,'App\\Models\\Receipt',1446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',55924.89,NULL,NULL,1,'2022-10-28 15:59:23','2022-10-28 15:59:23',NULL);
INSERT INTO `balance_libro` VALUES (1604,7768,41352,93399,2,1447,'App\\Models\\Receipt',1447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',2500.00,NULL,NULL,1,'2022-10-28 15:59:23','2022-10-28 15:59:23',NULL),(1605,7768,41352,93398,2,1448,'App\\Models\\Receipt',1448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-04','2022-09-04',130769.10,NULL,NULL,1,'2022-10-28 16:01:45','2022-10-28 16:01:45',NULL),(1606,7768,41352,93398,2,1449,'App\\Models\\Receipt',1449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',117935.61,NULL,NULL,1,'2022-10-28 16:01:45','2022-10-28 16:01:45',NULL),(1607,7768,41352,93398,2,1450,'App\\Models\\Receipt',1450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',87402.00,NULL,NULL,1,'2022-10-28 16:01:45','2022-10-28 16:01:45',NULL),(1608,7768,41352,93398,2,1451,'App\\Models\\Receipt',1451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',60326.78,NULL,NULL,1,'2022-10-28 16:01:45','2022-10-28 16:01:45',NULL),(1609,7768,41352,93398,2,1452,'App\\Models\\Receipt',1452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',14989.63,NULL,NULL,1,'2022-10-28 16:01:45','2022-10-28 16:01:45',NULL),(1610,7768,41352,93398,2,1453,'App\\Models\\Receipt',1453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',9000.00,NULL,NULL,1,'2022-10-28 16:01:45','2022-10-28 16:01:45',NULL),(1611,7768,41352,93398,2,1454,'App\\Models\\Receipt',1454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-18','2022-09-18',4371.47,NULL,NULL,1,'2022-10-28 16:01:45','2022-10-28 16:01:45',NULL),(1612,7768,41352,93397,2,1455,'App\\Models\\Receipt',1455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',88772.52,NULL,NULL,1,'2022-10-28 16:03:57','2022-10-28 16:03:57',NULL),(1613,7768,41352,93397,2,1456,'App\\Models\\Receipt',1456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',127510.00,NULL,NULL,1,'2022-10-28 16:03:57','2022-10-28 16:03:57',NULL),(1614,7768,41352,93397,2,1457,'App\\Models\\Receipt',1457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',93725.07,NULL,NULL,1,'2022-10-28 16:03:57','2022-10-28 16:03:57',NULL),(1615,7768,41352,93397,2,1458,'App\\Models\\Receipt',1458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-04','2022-08-04',9465.28,NULL,NULL,1,'2022-10-28 16:03:57','2022-10-28 16:03:57',NULL),(1616,7768,41352,93396,2,1459,'App\\Models\\Receipt',1459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',78472.00,NULL,NULL,1,'2022-10-28 16:04:48','2022-10-28 16:04:48',NULL),(1617,7768,41352,93396,2,1460,'App\\Models\\Receipt',1460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',75895.22,NULL,NULL,1,'2022-10-28 16:04:48','2022-10-28 16:04:48',NULL),(1618,7768,41352,93396,2,1461,'App\\Models\\Receipt',1461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',16469.64,NULL,NULL,1,'2022-10-28 16:04:48','2022-10-28 16:04:48',NULL),(1619,7768,41352,93396,2,1462,'App\\Models\\Receipt',1462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',23283.52,NULL,NULL,1,'2022-10-28 16:04:48','2022-10-28 16:04:48',NULL),(1620,7768,41352,93396,2,1463,'App\\Models\\Receipt',1463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',56187.09,NULL,NULL,1,'2022-10-28 16:04:48','2022-10-28 16:04:48',NULL),(1621,7768,41352,93395,2,1464,'App\\Models\\Receipt',1464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',11000.00,NULL,NULL,1,'2022-10-28 16:05:47','2022-10-28 16:05:47',NULL),(1622,7768,41352,93395,2,1465,'App\\Models\\Receipt',1465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',94491.95,NULL,NULL,1,'2022-10-28 16:05:47','2022-10-28 16:05:47',NULL),(1623,7768,41352,93395,2,1466,'App\\Models\\Receipt',1466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-05','2022-06-05',84474.23,NULL,NULL,1,'2022-10-28 16:05:48','2022-10-28 16:05:48',NULL),(1624,7768,41352,93395,2,1467,'App\\Models\\Receipt',1467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-05','2022-06-05',97634.50,NULL,NULL,1,'2022-10-28 16:05:48','2022-10-28 16:05:48',NULL);
INSERT INTO `balance_libro` VALUES (1625,7768,41352,93395,2,1468,'App\\Models\\Receipt',1468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-08','2022-06-08',15786.86,NULL,NULL,1,'2022-10-28 16:05:48','2022-10-28 16:05:48',NULL),(1626,7768,41352,93395,2,1469,'App\\Models\\Receipt',1469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',7716.34,NULL,NULL,1,'2022-10-28 16:05:48','2022-10-28 16:05:48',NULL),(1627,7768,41352,93395,2,1470,'App\\Models\\Receipt',1470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',2500.00,NULL,NULL,1,'2022-10-28 16:05:48','2022-10-28 16:05:48',NULL),(1628,7768,41352,93394,2,1471,'App\\Models\\Receipt',1471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-08','2022-05-08',71170.00,NULL,NULL,1,'2022-10-28 16:07:43','2022-10-28 16:07:43',NULL),(1629,7768,41352,93394,2,1472,'App\\Models\\Receipt',1472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-08','2022-05-08',11463.78,NULL,NULL,1,'2022-10-28 16:07:43','2022-10-28 16:07:43',NULL),(1630,7768,41352,93394,2,1473,'App\\Models\\Receipt',1473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-08','2022-05-08',77437.22,NULL,NULL,1,'2022-10-28 16:07:43','2022-10-28 16:07:43',NULL),(1631,7768,41352,93393,2,1474,'App\\Models\\Receipt',1474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',87596.00,NULL,NULL,1,'2022-10-28 16:09:03','2022-10-28 16:09:03',NULL),(1632,7768,41352,93393,2,1475,'App\\Models\\Receipt',1475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',7134.78,NULL,NULL,1,'2022-10-28 16:09:03','2022-10-28 16:09:03',NULL),(1633,7768,41352,93393,2,1476,'App\\Models\\Receipt',1476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',10016.26,NULL,NULL,1,'2022-10-28 16:09:03','2022-10-28 16:09:03',NULL),(1634,7768,41352,93393,2,1477,'App\\Models\\Receipt',1477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',71430.67,NULL,NULL,1,'2022-10-28 16:09:04','2022-10-28 16:09:04',NULL),(1635,7768,41352,93392,2,1478,'App\\Models\\Receipt',1478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',30856.29,NULL,NULL,1,'2022-10-28 16:09:51','2022-10-28 16:09:51',NULL),(1636,7768,41352,93392,2,1479,'App\\Models\\Receipt',1479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-06','2022-03-06',56336.00,NULL,NULL,1,'2022-10-28 16:09:51','2022-10-28 16:09:51',NULL),(1637,7768,41352,93392,2,1480,'App\\Models\\Receipt',1480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-06','2022-03-06',40464.16,NULL,NULL,1,'2022-10-28 16:09:51','2022-10-28 16:09:51',NULL),(1638,7768,41352,93392,2,1481,'App\\Models\\Receipt',1481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-06','2022-03-06',6353.75,NULL,NULL,1,'2022-10-28 16:09:51','2022-10-28 16:09:51',NULL),(1639,7768,41352,93392,2,1482,'App\\Models\\Receipt',1482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-06','2022-03-06',20930.20,NULL,NULL,1,'2022-10-28 16:09:51','2022-10-28 16:09:51',NULL),(1640,7768,41352,93392,2,1483,'App\\Models\\Receipt',1483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',70070.75,NULL,NULL,1,'2022-10-28 16:09:52','2022-10-28 16:09:52',NULL),(1641,7768,41352,93392,2,1484,'App\\Models\\Receipt',1484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',28176.52,NULL,NULL,1,'2022-10-28 16:09:52','2022-10-28 16:09:52',NULL),(1642,7768,41352,93392,2,1485,'App\\Models\\Receipt',1485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',1931.61,NULL,NULL,1,'2022-10-28 16:09:52','2022-10-28 16:09:52',NULL),(1643,7768,41352,93391,2,1486,'App\\Models\\Receipt',1486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',63084.00,NULL,NULL,1,'2022-10-28 16:10:35','2022-10-28 16:10:35',NULL),(1644,7768,41352,93391,2,1487,'App\\Models\\Receipt',1487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',17907.86,NULL,NULL,1,'2022-10-28 16:10:35','2022-10-28 16:10:35',NULL),(1645,7768,41352,93391,2,1488,'App\\Models\\Receipt',1488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',8548.71,NULL,NULL,1,'2022-10-28 16:10:35','2022-10-28 16:10:35',NULL);
INSERT INTO `balance_libro` VALUES (1646,7768,41352,93390,2,1489,'App\\Models\\Receipt',1489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',56336.00,NULL,NULL,1,'2022-10-28 16:12:05','2022-10-28 16:12:05',NULL),(1647,7768,41352,93390,2,1490,'App\\Models\\Receipt',1490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-09','2022-01-09',14214.15,NULL,NULL,1,'2022-10-28 16:12:05','2022-10-28 16:12:05',NULL),(1648,7768,41352,93390,2,1491,'App\\Models\\Receipt',1491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',85729.65,NULL,NULL,1,'2022-10-28 16:12:05','2022-10-28 16:12:05',NULL),(1649,7768,41352,93390,2,1492,'App\\Models\\Receipt',1492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',77030.42,NULL,NULL,1,'2022-10-28 16:12:05','2022-10-28 16:12:05',NULL),(1650,7768,41352,93386,2,1493,'App\\Models\\Receipt',1493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',34120.00,NULL,NULL,1,'2022-10-28 16:12:41','2022-10-28 16:12:41',NULL),(1651,7768,41352,93386,2,1494,'App\\Models\\Receipt',1494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',1119.78,NULL,NULL,1,'2022-10-28 16:12:41','2022-10-28 16:12:41',NULL),(1652,7768,41352,93386,2,1495,'App\\Models\\Receipt',1495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',1901.07,NULL,NULL,1,'2022-10-28 16:12:41','2022-10-28 16:12:41',NULL),(1653,7768,41352,93386,2,1496,'App\\Models\\Receipt',1496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',1200.00,NULL,NULL,1,'2022-10-28 16:12:42','2022-10-28 16:12:42',NULL),(1654,7768,41352,93386,2,1497,'App\\Models\\Receipt',1497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-07','2021-12-07',8874.02,NULL,NULL,1,'2022-10-28 16:12:42','2022-10-28 16:12:42',NULL),(1655,7768,41352,93386,2,1498,'App\\Models\\Receipt',1498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-07','2021-12-07',17919.03,NULL,NULL,1,'2022-10-28 16:12:42','2022-10-28 16:12:42',NULL),(1656,7768,41352,93386,2,1499,'App\\Models\\Receipt',1499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',62557.62,NULL,NULL,1,'2022-10-28 16:12:42','2022-10-28 16:12:42',NULL),(1657,7768,41352,93386,2,1500,'App\\Models\\Receipt',1500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',107007.01,NULL,NULL,1,'2022-10-28 16:12:42','2022-10-28 16:12:42',NULL),(1658,7768,41352,93385,2,1501,'App\\Models\\Receipt',1501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',1200.00,NULL,NULL,1,'2022-10-28 16:13:34','2022-10-28 16:13:34',NULL),(1659,7768,41352,93385,2,1502,'App\\Models\\Receipt',1502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',22369.38,NULL,NULL,1,'2022-10-28 16:13:34','2022-10-28 16:13:34',NULL),(1660,7768,41352,93385,2,1503,'App\\Models\\Receipt',1503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',12223.04,NULL,NULL,1,'2022-10-28 16:13:34','2022-10-28 16:13:34',NULL),(1661,7768,41352,93385,2,1504,'App\\Models\\Receipt',1504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',5690.03,NULL,NULL,1,'2022-10-28 16:13:34','2022-10-28 16:13:34',NULL),(1662,7768,41352,93385,2,1505,'App\\Models\\Receipt',1505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',8800.00,NULL,NULL,1,'2022-10-28 16:13:34','2022-10-28 16:13:34',NULL),(1663,7768,41352,93385,2,1506,'App\\Models\\Receipt',1506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-28','2021-11-28',78253.70,NULL,NULL,1,'2022-10-28 16:13:34','2022-10-28 16:13:34',NULL),(1664,7768,41352,93385,2,1507,'App\\Models\\Receipt',1507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-28','2021-11-28',80144.00,NULL,NULL,1,'2022-10-28 16:13:34','2022-10-28 16:13:34',NULL),(1665,7768,41352,93385,2,1508,'App\\Models\\Receipt',1508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-28','2021-11-28',46469.56,NULL,NULL,1,'2022-10-28 16:13:34','2022-10-28 16:13:34',NULL),(1666,7768,41352,93384,2,1509,'App\\Models\\Receipt',1509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',45536.00,NULL,NULL,1,'2022-10-28 16:14:06','2022-10-28 16:14:06',NULL);
INSERT INTO `balance_libro` VALUES (1667,7768,41352,93384,2,1510,'App\\Models\\Receipt',1510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',37260.98,NULL,NULL,1,'2022-10-28 16:14:06','2022-10-28 16:14:06',NULL),(1668,7768,41352,93384,2,1511,'App\\Models\\Receipt',1511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',8800.00,NULL,NULL,1,'2022-10-28 16:14:06','2022-10-28 16:14:06',NULL),(1669,7768,41352,93384,2,1512,'App\\Models\\Receipt',1512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06','2021-10-06',18316.06,NULL,NULL,1,'2022-10-28 16:14:06','2022-10-28 16:14:06',NULL),(1670,7768,41352,93384,2,1513,'App\\Models\\Receipt',1513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-24','2021-10-24',79142.25,NULL,NULL,1,'2022-10-28 16:14:07','2022-10-28 16:14:07',NULL),(1671,7768,41352,93384,2,1514,'App\\Models\\Receipt',1514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-24','2021-10-24',48986.00,NULL,NULL,1,'2022-10-28 16:14:07','2022-10-28 16:14:07',NULL),(1672,7768,41352,93384,2,1515,'App\\Models\\Receipt',1515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-24','2021-10-24',69218.81,NULL,NULL,1,'2022-10-28 16:14:07','2022-10-28 16:14:07',NULL),(1673,7768,40728,13782,2,1516,'App\\Models\\Receipt',1516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',113183.40,NULL,NULL,1,'2022-10-29 09:13:38','2022-10-31 12:47:37','2022-10-31 12:47:37'),(1674,7768,40728,13760,16,451,'App\\Models\\PeriodLiquidation',NULL,451,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',13597.29,NULL,NULL,1,'2022-10-29 09:29:28','2022-11-07 08:11:28','2022-11-07 08:11:28'),(1675,7768,40728,13760,15,450,'App\\Models\\PeriodLiquidation',NULL,450,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',215452.76,NULL,NULL,1,'2022-10-29 09:30:53','2022-11-06 20:26:12','2022-11-06 20:26:12'),(1676,7768,40728,13776,3,364,'App\\Models\\Receipt',364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',7477.94,NULL,NULL,1,'2022-10-29 09:47:44','2022-10-29 09:47:44',NULL),(1677,7768,40728,13776,3,357,'App\\Models\\Receipt',357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',92288.03,NULL,NULL,1,'2022-10-29 09:48:35','2022-10-29 09:48:35',NULL),(1678,7768,40728,13776,16,468,'App\\Models\\PeriodLiquidation',NULL,468,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',27249.07,NULL,NULL,1,'2022-10-29 10:13:09','2022-11-07 08:50:16','2022-11-07 08:50:16'),(1679,7768,40728,13776,15,467,'App\\Models\\PeriodLiquidation',NULL,467,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',161174.49,NULL,NULL,1,'2022-10-29 10:16:30','2022-11-07 08:50:34','2022-11-07 08:50:34'),(1680,7768,40728,13777,3,262,'App\\Models\\Receipt',262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-10','2022-05-10',11049.55,NULL,NULL,1,'2022-10-29 10:18:03','2022-10-29 10:18:03',NULL),(1681,7768,40728,13777,3,264,'App\\Models\\Receipt',264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-15','2022-05-15',3203.67,NULL,NULL,1,'2022-10-29 10:19:17','2022-10-29 10:19:17',NULL),(1682,7768,40728,13777,3,266,'App\\Models\\Receipt',266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',12172.13,NULL,NULL,1,'2022-10-29 10:23:44','2022-10-29 10:23:44',NULL),(1683,7768,40728,13777,3,267,'App\\Models\\Receipt',267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',4680.88,NULL,NULL,1,'2022-10-29 11:04:11','2022-11-07 08:57:28','2022-11-07 08:57:28'),(1684,7768,40728,13777,3,270,'App\\Models\\Receipt',270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',3227.13,NULL,NULL,1,'2022-10-29 11:14:01','2022-11-08 15:43:49','2022-11-08 15:43:49'),(1685,7768,40728,13777,16,480,'App\\Models\\PeriodLiquidation',NULL,480,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',26026.32,NULL,NULL,1,'2022-10-29 11:15:21','2022-11-07 08:50:26','2022-11-07 08:50:26'),(1686,7768,40728,13777,15,479,'App\\Models\\PeriodLiquidation',NULL,479,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',150238.68,NULL,NULL,1,'2022-10-29 11:26:57','2022-11-07 08:50:30','2022-11-07 08:50:30');
INSERT INTO `balance_libro` VALUES (1687,7768,40728,13778,3,535,'App\\Models\\Receipt',535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',31361.28,NULL,NULL,1,'2022-10-31 11:58:45','2022-10-31 11:58:45',NULL),(1688,7768,40728,13778,3,534,'App\\Models\\Receipt',534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',3329.18,NULL,NULL,1,'2022-10-31 12:05:52','2022-10-31 12:06:34','2022-10-31 12:06:34'),(1689,7768,40728,13778,3,534,'App\\Models\\Receipt',534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',3329.18,NULL,NULL,1,'2022-10-31 12:06:34','2022-10-31 12:06:34',NULL),(1690,7768,40728,13778,3,537,'App\\Models\\Receipt',537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',5113.41,NULL,NULL,1,'2022-10-31 12:11:46','2022-11-07 08:53:04','2022-11-07 08:53:04'),(1691,7768,40728,13778,3,540,'App\\Models\\Receipt',540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',6449.94,NULL,NULL,1,'2022-10-31 12:14:24','2022-10-31 12:14:59','2022-10-31 12:14:59'),(1692,7768,40728,13778,3,540,'App\\Models\\Receipt',540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',7345.81,NULL,NULL,1,'2022-10-31 12:14:59','2022-10-31 12:17:54','2022-10-31 12:17:54'),(1693,7768,40728,13778,3,540,'App\\Models\\Receipt',540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',7345.81,NULL,NULL,1,'2022-10-31 12:17:54','2022-11-15 12:25:24','2022-11-15 12:25:24'),(1694,7768,40728,13778,3,1517,'App\\Models\\Receipt',1517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',48.90,NULL,NULL,1,'2022-10-31 12:25:10','2022-10-31 16:29:03','2022-10-31 16:29:03'),(1695,7768,40728,13778,16,497,'App\\Models\\PeriodLiquidation',NULL,497,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',23091.78,NULL,NULL,1,'2022-10-31 12:35:26','2022-10-31 16:27:24','2022-10-31 16:27:24'),(1696,7768,40728,13778,15,496,'App\\Models\\PeriodLiquidation',NULL,496,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',82023.57,NULL,NULL,1,'2022-10-31 12:35:40','2022-10-31 16:26:47','2022-10-31 16:26:47'),(1697,7768,40728,13782,2,1516,'App\\Models\\Receipt',1516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',112667.94,NULL,NULL,1,'2022-10-31 12:47:37','2022-10-31 12:47:37',NULL),(1698,7768,40728,13782,3,1518,'App\\Models\\Receipt',1518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',3993.00,NULL,NULL,1,'2022-10-31 12:56:08','2022-10-31 12:56:08',NULL),(1699,7768,40728,13782,3,1519,'App\\Models\\Receipt',1519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',21066.10,NULL,NULL,1,'2022-10-31 12:57:48','2022-10-31 12:57:48',NULL),(1700,7768,40728,13779,3,312,'App\\Models\\Receipt',312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',37391.33,NULL,NULL,1,'2022-10-31 14:42:43','2022-10-31 14:42:43',NULL),(1701,7768,40728,13779,3,330,'App\\Models\\Receipt',330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',5474.60,NULL,NULL,1,'2022-10-31 16:02:43','2022-11-15 12:25:40','2022-11-15 12:25:40'),(1702,7768,40728,13779,3,318,'App\\Models\\Receipt',318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',25807.98,NULL,NULL,1,'2022-10-31 16:03:45','2022-10-31 16:03:45',NULL),(1703,7768,40728,13779,3,325,'App\\Models\\Receipt',325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',63731.58,NULL,NULL,1,'2022-10-31 16:06:15','2022-10-31 16:06:15',NULL),(1704,7768,40728,13779,3,327,'App\\Models\\Receipt',327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',5002.92,NULL,NULL,1,'2022-10-31 16:06:37','2022-10-31 16:06:37',NULL),(1705,7768,40728,13779,3,315,'App\\Models\\Receipt',315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',5791.23,NULL,NULL,1,'2022-10-31 16:15:05','2022-10-31 16:15:05',NULL),(1706,7768,40728,13779,3,316,'App\\Models\\Receipt',316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',3133.24,NULL,NULL,1,'2022-10-31 16:15:53','2022-10-31 16:15:53',NULL);
INSERT INTO `balance_libro` VALUES (1707,7768,40728,13779,3,314,'App\\Models\\Receipt',314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',1249.99,NULL,NULL,1,'2022-10-31 16:16:26','2022-10-31 16:16:26',NULL),(1708,7768,40728,13779,16,525,'App\\Models\\PeriodLiquidation',NULL,525,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',25079.57,NULL,NULL,1,'2022-10-31 16:17:18','2022-11-07 08:09:29','2022-11-07 08:09:29'),(1709,7768,40728,13778,3,1517,'App\\Models\\Receipt',1517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',6524.70,NULL,NULL,1,'2022-10-31 16:29:03','2022-11-08 15:39:23','2022-11-08 15:39:23'),(1710,7768,40728,13778,15,529,'App\\Models\\PeriodLiquidation',NULL,529,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',82736.49,NULL,NULL,1,'2022-10-31 16:30:30','2022-11-07 08:50:20','2022-11-07 08:50:20'),(1711,7768,40728,13778,16,528,'App\\Models\\PeriodLiquidation',NULL,528,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',23091.78,NULL,NULL,1,'2022-10-31 16:31:40','2022-11-07 08:50:23','2022-11-07 08:50:23'),(1712,7768,40728,13779,15,530,'App\\Models\\PeriodLiquidation',NULL,530,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',197114.00,NULL,NULL,1,'2022-10-31 16:34:24','2022-11-07 08:11:03','2022-11-07 08:11:03'),(1713,7768,40728,13780,3,84,'App\\Models\\Receipt',84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',31627.89,NULL,NULL,1,'2022-10-31 18:05:33','2022-11-16 20:51:18','2022-11-16 20:51:18'),(1714,7768,40728,13780,3,79,'App\\Models\\Receipt',79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-06','2022-08-06',5525.02,NULL,NULL,1,'2022-10-31 18:08:05','2022-10-31 18:08:05',NULL),(1715,7768,40728,13780,3,85,'App\\Models\\Receipt',85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',4957.38,NULL,NULL,1,'2022-10-31 18:08:33','2022-11-15 12:26:04','2022-11-15 12:26:04'),(1716,7768,40728,13765,21,1716,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',40000.00,'Cta Particular del Socio',NULL,1,'2022-10-31 18:46:57','2022-10-31 18:46:57',NULL),(1717,7768,40728,13765,21,1717,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',40000.00,'Cta Particular del Socio',NULL,1,'2022-10-31 18:47:37','2022-10-31 18:47:37',NULL),(1718,7768,40728,13765,21,1718,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-16','2021-11-16',40000.00,'Cta Particular del Socio',NULL,1,'2022-10-31 18:48:26','2022-10-31 18:48:26',NULL),(1719,7768,40728,13765,21,1719,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',40000.00,'Cta Particular del Socio',NULL,1,'2022-10-31 18:49:07','2022-10-31 18:49:07',NULL),(1720,7768,40728,13765,21,1720,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',40000.00,'Cta Particular del Socio',NULL,1,'2022-10-31 18:49:48','2022-10-31 18:49:48',NULL),(1721,7768,40728,13765,21,1721,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',40000.00,'Cta Particular del Socio',NULL,1,'2022-10-31 18:50:19','2022-10-31 18:50:19',NULL),(1722,7768,40728,13766,21,1722,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',40000.00,'Cta Particular del Socio',NULL,1,'2022-10-31 18:50:50','2022-10-31 18:50:50',NULL),(1723,7768,40728,13774,21,1723,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',25000.00,'Cta Particular del Socio',NULL,1,'2022-10-31 18:51:32','2022-10-31 18:51:32',NULL),(1724,7768,40728,13760,20,1614,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1614,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',114950.00,NULL,NULL,1,'2022-11-01 12:15:21','2022-11-01 12:15:21',NULL);
INSERT INTO `balance_libro` VALUES (1725,7768,40728,13761,20,1615,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1615,NULL,NULL,NULL,0,NULL,'2021-12-07','2021-12-07',363000.00,NULL,NULL,1,'2022-11-01 12:18:17','2022-11-06 16:04:26','2022-11-06 16:04:26'),(1726,7768,40728,13774,20,1616,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1616,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',183920.00,NULL,NULL,1,'2022-11-01 12:20:35','2022-11-01 12:20:35',NULL),(1727,7768,40728,13782,3,1520,'App\\Models\\Receipt',1520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',199650.00,NULL,NULL,1,'2022-11-04 10:25:32','2022-11-04 10:25:32',NULL),(1728,7768,40728,13782,3,1521,'App\\Models\\Receipt',1521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',199650.00,NULL,NULL,1,'2022-11-04 10:25:32','2022-11-04 10:25:32',NULL),(1729,7768,40728,13782,3,1522,'App\\Models\\Receipt',1522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',61998.00,NULL,NULL,1,'2022-11-04 10:25:33','2022-11-04 10:25:33',NULL),(1730,7768,40728,13782,3,1523,'App\\Models\\Receipt',1523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1450.00,NULL,NULL,1,'2022-11-04 10:25:33','2022-11-04 10:25:33',NULL),(1731,7768,40728,13782,3,1524,'App\\Models\\Receipt',1524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',206910.00,NULL,NULL,1,'2022-11-04 10:25:33','2022-11-04 10:25:33',NULL),(1732,7768,40728,13782,3,1525,'App\\Models\\Receipt',1525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2095.85,NULL,NULL,1,'2022-11-04 10:25:33','2022-11-04 10:25:33',NULL),(1733,7768,40728,13782,3,1526,'App\\Models\\Receipt',1526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',96800.00,NULL,NULL,1,'2022-11-04 10:25:33','2022-11-04 10:25:33',NULL),(1734,7768,40728,13782,3,1527,'App\\Models\\Receipt',1527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',100023.44,NULL,NULL,1,'2022-11-04 10:25:33','2022-11-04 10:25:33',NULL),(1735,7768,40728,13782,3,1528,'App\\Models\\Receipt',1528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',32399.00,NULL,NULL,1,'2022-11-04 10:25:33','2022-11-07 08:44:59','2022-11-07 08:44:59'),(1736,7768,40728,13782,3,1529,'App\\Models\\Receipt',1529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',206910.00,NULL,NULL,1,'2022-11-04 10:25:33','2022-11-04 10:25:33',NULL),(1737,7768,40728,13761,21,1627,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1627,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',29149.78,NULL,NULL,1,'2022-11-04 14:53:02','2022-11-04 14:53:02',NULL),(1738,7768,40728,13761,21,1628,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1628,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',19935.00,NULL,NULL,1,'2022-11-04 14:54:23','2022-11-04 14:54:23',NULL),(1739,7768,40728,13761,21,1629,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1629,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',6386.38,NULL,NULL,1,'2022-11-04 14:55:18','2022-11-04 14:55:18',NULL),(1740,7768,40728,13761,21,1630,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1630,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',10023.82,NULL,NULL,1,'2022-11-04 14:56:18','2022-11-04 14:56:18',NULL),(1741,7768,40728,13762,21,1631,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1631,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',1864.09,NULL,NULL,1,'2022-11-04 14:57:40','2022-11-04 14:57:40',NULL),(1742,7768,40728,13762,20,1632,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1632,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',1817.82,NULL,NULL,1,'2022-11-04 14:58:36','2022-11-04 14:59:18','2022-11-04 14:59:18'),(1743,7768,40728,13762,21,1633,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1633,NULL,NULL,NULL,0,NULL,'2021-08-04','2021-08-04',1817.82,NULL,NULL,1,'2022-11-04 14:59:58','2022-11-04 14:59:58',NULL),(1744,7768,40728,13763,21,1634,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1634,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',48966.63,NULL,NULL,1,'2022-11-04 15:10:07','2022-11-04 15:10:07',NULL);
INSERT INTO `balance_libro` VALUES (1745,7768,40728,13763,21,1635,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1635,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',739250.01,NULL,NULL,1,'2022-11-04 15:17:22','2022-11-06 19:00:57','2022-11-06 19:00:57'),(1746,7768,40728,13763,21,1636,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1636,NULL,NULL,NULL,0,NULL,'2021-09-24','2021-09-24',24132.00,NULL,NULL,1,'2022-11-04 15:24:58','2022-11-04 15:24:58',NULL),(1747,7768,40728,13763,21,1637,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1637,NULL,NULL,NULL,0,NULL,'2021-09-17','2021-09-17',5147.10,NULL,NULL,1,'2022-11-04 15:26:43','2022-11-04 15:26:43',NULL),(1748,7768,40728,13763,21,1638,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1638,NULL,NULL,NULL,0,NULL,'2021-09-02','2021-09-02',2900.00,NULL,NULL,1,'2022-11-04 15:28:46','2022-11-04 15:28:46',NULL),(1749,7768,40728,13765,21,1639,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1639,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',2000.00,NULL,NULL,1,'2022-11-04 15:29:53','2022-11-04 15:29:53',NULL),(1750,7768,40728,13773,21,1640,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1640,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',1600.00,NULL,NULL,1,'2022-11-04 15:30:35','2022-11-04 15:30:35',NULL),(1751,7768,40728,13764,21,1641,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1641,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',22589.90,NULL,NULL,1,'2022-11-04 15:44:02','2022-11-04 15:44:02',NULL),(1752,7768,40728,13764,21,1642,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1642,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',17800.00,NULL,NULL,1,'2022-11-04 15:44:51','2022-11-04 15:44:51',NULL),(1753,7768,40728,13764,21,1643,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1643,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',585650.00,NULL,NULL,1,'2022-11-04 15:50:09','2022-11-06 23:43:50','2022-11-06 23:43:50'),(1754,7768,40728,13764,21,1644,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1644,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',4719.00,NULL,NULL,1,'2022-11-04 15:52:08','2022-11-04 15:52:08',NULL),(1755,7768,40728,13765,21,1645,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1645,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',4719.00,NULL,NULL,1,'2022-11-04 15:54:25','2022-11-04 15:54:25',NULL),(1756,7768,40728,13764,21,1646,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1646,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',78814.49,NULL,NULL,1,'2022-11-04 15:55:42','2022-11-04 15:55:42',NULL),(1757,7768,40728,13764,21,1647,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1647,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',20534.88,NULL,NULL,1,'2022-11-04 16:01:19','2022-11-04 16:01:19',NULL),(1758,7768,40728,13765,21,1648,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1648,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',9000.00,NULL,NULL,1,'2022-11-04 16:02:16','2022-11-04 16:02:16',NULL),(1759,7768,40728,13765,21,1649,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1649,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',32089.20,NULL,NULL,1,'2022-11-04 16:03:27','2022-11-04 16:03:27',NULL),(1760,7768,40728,13765,21,1650,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1650,NULL,NULL,NULL,0,NULL,'2021-11-23','2021-11-23',28560.00,NULL,NULL,1,'2022-11-04 16:04:21','2022-11-04 16:04:21',NULL),(1761,7768,40728,13765,21,1651,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1651,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',7400.02,NULL,NULL,1,'2022-11-04 16:06:03','2022-11-04 16:06:03',NULL),(1762,7768,40728,13765,21,1652,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1652,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',190150.42,NULL,NULL,1,'2022-11-04 16:07:13','2022-11-04 16:07:13',NULL),(1763,7768,40728,13765,21,1653,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1653,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',53323.42,NULL,NULL,1,'2022-11-04 16:11:29','2022-11-04 16:11:29',NULL),(1764,7768,40728,13765,21,1654,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1654,NULL,NULL,NULL,0,NULL,'2021-11-12','2021-11-12',6680.02,NULL,NULL,1,'2022-11-04 16:12:40','2022-11-04 16:12:40',NULL);
INSERT INTO `balance_libro` VALUES (1765,7768,40728,13765,21,1655,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1655,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',240.02,NULL,NULL,1,'2022-11-04 16:14:14','2022-11-04 16:14:14',NULL),(1766,7768,40728,13766,21,1656,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1656,NULL,NULL,NULL,0,NULL,'2021-12-29','2021-12-29',22506.00,NULL,NULL,1,'2022-11-04 16:15:12','2022-11-04 16:15:12',NULL),(1767,7768,40728,13766,21,1657,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1657,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',22160.00,NULL,NULL,1,'2022-11-04 16:15:58','2022-11-04 16:15:58',NULL),(1768,7768,40728,13766,21,1658,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1658,NULL,NULL,NULL,0,NULL,'2021-12-27','2021-12-27',54451.28,NULL,NULL,1,'2022-11-04 16:17:57','2022-11-04 16:17:57',NULL),(1769,7768,40728,13766,21,1659,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1659,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',360580.00,NULL,NULL,1,'2022-11-04 16:18:47','2022-11-04 16:18:47',NULL),(1770,7768,40728,13766,21,1660,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1660,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',823.01,NULL,NULL,1,'2022-11-04 16:19:57','2022-11-04 16:19:57',NULL),(1771,7768,40728,13766,21,1661,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1661,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',19926.15,NULL,NULL,1,'2022-11-04 16:22:02','2022-11-04 16:22:02',NULL),(1772,7768,40728,13766,21,1662,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1662,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',13298.57,NULL,NULL,1,'2022-11-04 16:22:43','2022-11-04 16:22:43',NULL),(1773,7768,40728,13766,21,1663,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1663,NULL,NULL,NULL,0,NULL,'2021-12-16','2021-12-16',7328.07,NULL,NULL,1,'2022-11-04 16:23:39','2022-11-04 16:23:39',NULL),(1774,7768,40728,13766,21,1664,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1664,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',39930.00,NULL,NULL,1,'2022-11-04 16:24:40','2022-11-04 16:24:40',NULL),(1775,7768,40728,13766,21,1665,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1665,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',24321.00,NULL,NULL,1,'2022-11-04 16:25:23','2022-11-04 16:25:23',NULL),(1776,7768,40728,13766,21,1666,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1666,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',300564.00,NULL,NULL,1,'2022-11-04 16:25:58','2022-11-04 16:25:58',NULL),(1777,7768,40728,13766,21,1667,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1667,NULL,NULL,NULL,0,NULL,'2021-12-10','2021-12-10',4719.00,NULL,NULL,1,'2022-11-04 16:27:30','2022-11-04 16:27:30',NULL),(1778,7768,40728,13766,21,1668,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1668,NULL,NULL,NULL,0,NULL,'2021-12-12','2021-12-12',77678.37,NULL,NULL,1,'2022-11-04 16:28:24','2022-11-15 12:39:25','2022-11-15 12:39:25'),(1779,7768,40728,13766,21,1669,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1669,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',384017.70,NULL,NULL,1,'2022-11-04 16:29:42','2022-11-16 12:47:08','2022-11-16 12:47:08'),(1780,7768,40728,13773,21,1670,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1670,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',3997.86,NULL,NULL,1,'2022-11-04 16:30:39','2022-11-04 16:30:39',NULL),(1781,7768,40728,13773,21,1671,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1671,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',6361.74,NULL,NULL,1,'2022-11-06 14:59:25','2022-11-06 14:59:25',NULL),(1782,7768,40728,13773,21,1672,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1672,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',8223.66,NULL,NULL,1,'2022-11-06 15:02:06','2022-11-06 15:02:06',NULL),(1783,7768,40728,13773,21,1673,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1673,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',10655.18,NULL,NULL,1,'2022-11-06 15:03:41','2022-11-06 15:03:41',NULL),(1784,7768,40728,13773,21,1674,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1674,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',3751.00,NULL,NULL,1,'2022-11-06 15:05:29','2022-11-06 15:05:29',NULL);
INSERT INTO `balance_libro` VALUES (1785,7768,40728,13773,21,1675,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1675,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',22991.21,NULL,NULL,1,'2022-11-06 15:06:49','2022-11-15 12:39:20','2022-11-15 12:39:20'),(1786,7768,40728,13773,21,1676,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1676,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',4719.00,NULL,NULL,1,'2022-11-06 15:13:37','2022-11-06 15:13:37',NULL),(1787,7768,40728,13773,21,1677,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1677,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',2322.69,NULL,NULL,1,'2022-11-06 15:23:58','2022-11-06 15:23:58',NULL),(1788,7768,40728,13773,21,1678,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1678,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',18803.40,NULL,NULL,1,'2022-11-06 15:25:15','2022-11-06 15:25:15',NULL),(1789,7768,40728,13773,21,1679,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1679,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',28381.25,NULL,NULL,1,'2022-11-06 15:26:32','2022-11-15 12:51:55','2022-11-15 12:51:55'),(1790,7768,40728,13773,21,1680,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1680,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',14976.79,NULL,NULL,1,'2022-11-06 15:27:39','2022-11-06 15:27:39',NULL),(1791,7768,40728,13773,21,1681,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1681,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',3630.00,NULL,NULL,1,'2022-11-06 15:28:28','2022-11-06 15:28:28',NULL),(1792,7768,40728,13773,21,1682,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1682,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',820.38,NULL,NULL,1,'2022-11-06 15:29:24','2022-11-06 15:29:24',NULL),(1793,7768,40728,13773,21,1683,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1683,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',6493.32,NULL,NULL,1,'2022-11-06 15:30:12','2022-11-06 15:30:12',NULL),(1794,7768,40728,13773,20,1684,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1684,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',29947.52,NULL,NULL,1,'2022-11-06 15:32:17','2022-11-06 15:32:31','2022-11-06 15:32:31'),(1795,7768,40728,13774,21,1685,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1685,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',29947.52,NULL,NULL,1,'2022-11-06 15:33:38','2022-11-06 15:33:38',NULL),(1796,7768,40728,13774,21,1686,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1686,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',12107.00,NULL,NULL,1,'2022-11-06 15:34:57','2022-11-06 15:34:57',NULL),(1797,7768,40728,13774,21,1687,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1687,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',4719.00,NULL,NULL,1,'2022-11-06 15:35:54','2022-11-06 15:35:54',NULL),(1798,7768,40728,13774,21,1688,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1688,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',8430.15,NULL,NULL,1,'2022-11-06 15:36:43','2022-11-15 12:39:14','2022-11-15 12:39:14'),(1799,7768,40728,13774,21,1689,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1689,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',8364.16,NULL,NULL,1,'2022-11-06 15:38:36','2022-11-06 15:38:36',NULL),(1800,7768,40728,13774,21,1690,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1690,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',852808.00,NULL,NULL,1,'2022-11-06 15:40:48','2022-11-06 15:40:48',NULL),(1801,7768,40728,13774,21,1691,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1691,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',4719.00,NULL,NULL,1,'2022-11-06 15:42:17','2022-11-06 15:42:17',NULL),(1802,7768,40728,13775,21,1692,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1692,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',4356.00,NULL,NULL,1,'2022-11-06 15:46:51','2022-11-06 15:46:51',NULL),(1803,7768,40728,13775,21,1693,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1693,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',500.00,NULL,NULL,1,'2022-11-06 15:48:08','2022-11-06 15:48:08',NULL);
INSERT INTO `balance_libro` VALUES (1804,7768,40728,13775,20,1694,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1694,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',810.00,NULL,NULL,1,'2022-11-06 15:48:56','2022-11-06 15:49:30','2022-11-06 15:49:30'),(1805,7768,40728,13775,21,1695,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1695,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',810.00,NULL,NULL,1,'2022-11-06 15:49:59','2022-11-06 15:49:59',NULL),(1806,7768,40728,13766,20,1696,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1696,NULL,NULL,NULL,0,NULL,'2021-12-07','2021-12-07',363000.00,NULL,NULL,1,'2022-11-06 16:05:17','2022-11-06 16:05:17',NULL),(1807,7768,40728,13762,5,1807,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',12475.85,'Banco ICBC 08-2021',NULL,1,'2022-11-06 16:12:46','2022-11-06 16:12:46',NULL),(1808,7768,40728,13761,5,1808,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',2539.94,'Banco ICBC 06-2021',NULL,1,'2022-11-06 16:14:42','2022-11-06 16:14:42',NULL),(1809,7768,40728,13761,5,1809,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',392.97,'Banco ICBC 07-2021',NULL,1,'2022-11-06 16:15:15','2022-11-06 16:15:15',NULL),(1810,7768,40728,13764,5,1810,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',7955.80,'Banco ICBC 10-2021',NULL,1,'2022-11-06 16:15:43','2022-11-06 16:15:43',NULL),(1811,7768,40728,13775,5,1811,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',3849.43,'Banco ICBC',NULL,1,'2022-11-06 16:16:10','2022-11-06 16:16:10',NULL),(1812,7768,40728,13761,5,1812,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',0.03,'Banco ICBC 05-2021',NULL,1,'2022-11-06 16:16:35','2022-11-06 16:16:35',NULL),(1813,7768,40728,13763,5,1813,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',15800.13,'Banco ICBC 09-2021',NULL,1,'2022-11-06 16:17:00','2022-11-06 16:17:00',NULL),(1814,7768,40728,13765,5,1814,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',16132.10,'Banco ICBC',NULL,1,'2022-11-06 16:17:24','2022-11-06 16:17:24',NULL),(1815,7768,40728,13766,5,1815,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',15813.29,'Banco ICBC 12-2021',NULL,1,'2022-11-06 16:17:49','2022-11-06 16:17:49',NULL),(1816,7768,40728,13773,5,1816,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',6536.15,'Banco ICBC 01-2022',NULL,1,'2022-11-06 16:18:14','2022-11-06 16:18:14',NULL),(1817,7768,40728,13774,5,1817,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',30596.93,'Banco ICBC 02-2022',NULL,1,'2022-11-06 18:44:41','2022-11-06 18:44:41',NULL),(1818,7768,40728,13777,5,1818,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',1.10,'Banco ICBC 05-2021',NULL,1,'2022-11-06 18:50:50','2022-11-06 18:51:04','2022-11-06 18:51:04'),(1819,7768,40728,13759,5,1819,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',1.10,'Banco ICBC 05-2021',NULL,1,'2022-11-06 18:51:04','2022-11-06 18:51:04',NULL),(1820,7768,40728,13773,19,1820,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',4122.30,'CTA PARTCULAR DEL SOCIO',NULL,1,'2022-11-06 18:53:27','2022-11-06 18:53:27',NULL),(1821,7768,40728,13773,21,1821,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',7000.38,'Cta Particular del Socio',NULL,1,'2022-11-06 18:55:01','2022-11-06 18:55:01',NULL),(1822,7768,40728,13775,21,1822,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',2232.21,'Cta Particular del Socio',NULL,1,'2022-11-06 18:56:46','2022-11-06 18:56:46',NULL);
INSERT INTO `balance_libro` VALUES (1823,7768,40728,13763,21,1697,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1697,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',369625.00,NULL,NULL,1,'2022-11-06 19:03:25','2022-11-06 19:03:25',NULL),(1824,7768,40728,13763,19,1824,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',310000.00,'REPOSICION CAJA',NULL,1,'2022-11-06 19:06:44','2022-11-06 19:06:44',NULL),(1825,7768,40728,13764,19,1825,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',100000.00,'REPOSICION CAJA',NULL,1,'2022-11-06 19:07:37','2022-11-06 19:07:37',NULL),(1826,7768,40728,13764,19,1826,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',100000.00,'REPOSICION CAJA',NULL,1,'2022-11-06 19:08:32','2022-11-06 19:08:32',NULL),(1827,7768,40728,13764,19,1827,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',200000.00,'REPOSICION CAJA',NULL,1,'2022-11-06 19:09:20','2022-11-06 19:09:20',NULL),(1828,7768,40728,13764,21,1698,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1698,NULL,NULL,NULL,0,NULL,'2021-10-07','2021-10-07',75535.70,NULL,NULL,1,'2022-11-06 19:15:18','2022-11-06 19:15:18',NULL),(1829,7768,40728,13775,21,1699,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1699,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',38122.09,NULL,NULL,1,'2022-11-06 19:58:23','2022-11-06 19:58:23',NULL),(1830,7768,40728,13774,2,1830,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',50000.00,'INVERSIONES FCI',NULL,1,'2022-11-06 20:05:15','2022-11-06 20:09:17','2022-11-06 20:09:17'),(1831,7768,40728,13774,2,1831,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',50000.00,'INVERSIONES FCI',NULL,1,'2022-11-06 20:06:36','2022-11-06 20:09:30','2022-11-06 20:09:30'),(1832,7768,40728,13775,2,1832,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',51490.74,'INVERSIONES',NULL,1,'2022-11-06 20:07:25','2022-11-06 20:07:25',NULL),(1833,7768,40728,13775,2,1833,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',50932.39,'INVERSIONES',NULL,1,'2022-11-06 20:08:01','2022-11-06 20:08:01',NULL),(1834,7768,40728,13774,2,1834,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',50000.00,'INVERSIONES FCI',NULL,1,'2022-11-06 20:09:17','2022-11-06 20:09:17',NULL),(1835,7768,40728,13774,2,1835,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',50000.00,'INVERSIONES FCI',NULL,1,'2022-11-06 20:09:30','2022-11-06 20:09:30',NULL),(1836,7768,40728,13760,7,1442,'App\\Models\\Receipt',1442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',10479.50,NULL,NULL,1,'2022-11-06 20:26:13','2022-11-06 20:27:08','2022-11-06 20:27:08'),(1837,7768,40728,13761,7,1442,'App\\Models\\Receipt',1442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',21003.50,NULL,NULL,1,'2022-11-06 20:27:08','2022-11-06 20:27:18','2022-11-06 20:27:18'),(1838,7768,40728,13761,7,1442,'App\\Models\\Receipt',1442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',21003.50,NULL,NULL,1,'2022-11-06 20:27:18','2022-11-06 20:27:18',NULL),(1839,7768,40728,13760,7,1530,'App\\Models\\Receipt',1530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',10479.50,NULL,NULL,1,'2022-11-06 20:28:28','2022-11-06 20:28:28',NULL),(1840,7768,40728,13762,7,1531,'App\\Models\\Receipt',1531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',10141.41,NULL,NULL,1,'2022-11-06 20:29:41','2022-11-06 20:29:41',NULL),(1841,7768,40728,13763,7,1532,'App\\Models\\Receipt',1532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',16166.28,NULL,NULL,1,'2022-11-06 20:31:18','2022-11-06 20:31:18',NULL);
INSERT INTO `balance_libro` VALUES (1842,7768,40728,13765,7,1533,'App\\Models\\Receipt',1533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',7210.00,NULL,NULL,1,'2022-11-06 20:32:16','2022-11-06 20:32:16',NULL),(1843,7768,40728,13766,7,1534,'App\\Models\\Receipt',1534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-13','2021-12-13',11297.00,NULL,NULL,1,'2022-11-06 20:33:32','2022-11-06 20:33:32',NULL),(1844,7768,40728,13774,7,1535,'App\\Models\\Receipt',1535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',16556.00,NULL,NULL,1,'2022-11-06 20:34:30','2022-11-06 20:34:30',NULL),(1845,7768,40728,13780,20,1700,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1700,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',778359.93,NULL,NULL,1,'2022-11-06 20:38:54','2022-11-06 20:48:42','2022-11-06 20:48:42'),(1846,7768,40728,13763,20,1701,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1701,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',1223642.60,NULL,NULL,1,'2022-11-06 20:40:11','2022-11-06 20:40:11',NULL),(1847,7768,40728,13765,20,1702,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1702,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',694774.50,NULL,NULL,1,'2022-11-06 20:40:45','2022-11-06 20:40:45',NULL),(1848,7768,40728,13766,20,1703,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1703,NULL,NULL,NULL,0,NULL,'2021-12-13','2021-12-13',936111.85,NULL,NULL,1,'2022-11-06 20:41:24','2022-11-06 20:41:24',NULL),(1849,7768,40728,13773,20,1704,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1704,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',29901.30,NULL,NULL,1,'2022-11-06 20:42:49','2022-11-06 20:42:49',NULL),(1850,7768,40728,13774,20,1705,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1705,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',1242448.60,NULL,NULL,1,'2022-11-06 20:43:34','2022-11-06 20:43:34',NULL),(1851,7768,40728,13762,20,1706,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1706,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',778359.93,NULL,NULL,1,'2022-11-06 20:48:30','2022-11-06 20:48:30',NULL),(1852,7768,40728,13765,21,1707,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1707,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',188247.59,NULL,NULL,1,'2022-11-06 21:03:12','2022-11-06 21:03:12',NULL),(1853,7768,40728,13761,18,1853,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',0.01,'RECLA IMP LEY 25413',NULL,1,'2022-11-06 22:19:03','2022-11-06 22:19:03',NULL),(1854,7768,40728,13761,18,1854,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',700.74,'RECLA IMP LEY 25413',NULL,1,'2022-11-06 22:19:27','2022-11-06 22:19:27',NULL),(1855,7768,40728,13761,18,1855,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',392.97,'RECLA IMP LEY 25413',NULL,1,'2022-11-06 22:19:56','2022-11-06 22:19:56',NULL),(1856,7768,40728,13762,18,1856,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',4692.25,'RECLA IMP LEY 25413',NULL,1,'2022-11-06 22:20:16','2022-11-06 22:20:16',NULL),(1857,7768,40728,13763,18,1857,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',11906.53,'RECLA IMP LEY 25413',NULL,1,'2022-11-06 22:20:42','2022-11-06 22:20:42',NULL),(1858,7768,40728,13764,18,1858,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',5503.80,'RECLA IMP LEY 25413',NULL,1,'2022-11-06 22:21:06','2022-11-06 22:21:06',NULL),(1859,7768,40728,13765,18,1859,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',8447.23,'RECLA IMP LEY 25413',NULL,1,'2022-11-06 22:21:27','2022-11-06 22:21:27',NULL),(1860,7768,40728,13766,18,1860,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',15813.29,'RECLA IMP LEY 25413',NULL,1,'2022-11-06 22:21:45','2022-11-06 22:21:45',NULL);
INSERT INTO `balance_libro` VALUES (1861,7768,40728,13773,18,1861,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',4298.70,'RECLA IMP LEY 25413',NULL,1,'2022-11-06 22:23:02','2022-11-06 22:23:02',NULL),(1862,7768,40728,13774,18,1862,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',13937.26,'RECLA IMP LEY 25413',NULL,1,'2022-11-06 22:23:17','2022-11-06 22:23:17',NULL),(1863,7768,40728,13775,18,1863,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',860.71,'RECLA IMP LEY 25413',NULL,1,'2022-11-06 22:23:32','2022-11-06 22:23:32',NULL),(1864,7768,40728,13763,3,1219,'App\\Models\\Receipt',1219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',585650.00,NULL,NULL,1,'2022-11-06 23:49:20','2022-11-06 23:49:20',NULL),(1865,7768,40728,13761,3,1084,'App\\Models\\Receipt',1084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',331500.00,NULL,NULL,1,'2022-11-06 23:50:06','2022-11-06 23:50:06',NULL),(1866,7768,40728,13764,21,1710,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1710,NULL,NULL,NULL,0,NULL,'2021-10-16','2021-10-16',250000.00,NULL,NULL,1,'2022-11-06 23:54:34','2022-11-06 23:54:34',NULL),(1867,7768,40728,13766,21,1711,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1711,NULL,NULL,NULL,0,NULL,'2021-12-24','2021-12-24',150000.00,NULL,NULL,1,'2022-11-06 23:55:09','2022-11-06 23:55:09',NULL),(1868,7768,40728,13774,21,1712,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1712,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',100000.00,NULL,NULL,1,'2022-11-06 23:55:50','2022-11-06 23:57:14','2022-11-06 23:57:14'),(1869,7768,40728,13775,20,1713,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1713,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',85560.00,NULL,NULL,1,'2022-11-06 23:56:25','2022-11-06 23:57:21','2022-11-06 23:57:21'),(1870,7768,40728,13774,21,1714,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1714,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',100000.00,NULL,NULL,1,'2022-11-06 23:57:52','2022-11-06 23:57:52',NULL),(1871,7768,40728,13775,21,1715,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1715,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',85560.00,NULL,NULL,1,'2022-11-06 23:58:25','2022-11-06 23:58:25',NULL),(1872,7768,40728,13766,21,1716,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1716,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',30000.00,NULL,NULL,1,'2022-11-07 00:01:04','2022-11-08 15:29:31','2022-11-08 15:29:31'),(1873,7768,40728,13774,21,1717,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1717,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',7500.00,NULL,NULL,1,'2022-11-07 00:02:52','2022-11-08 15:29:26','2022-11-08 15:29:26'),(1874,7768,40728,13760,16,550,'App\\Models\\PeriodLiquidation',NULL,550,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',13483.11,NULL,NULL,1,'2022-11-07 00:08:59','2022-11-07 08:11:24','2022-11-07 08:11:24'),(1875,7768,40728,13761,16,564,'App\\Models\\PeriodLiquidation',NULL,564,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',10419.18,NULL,NULL,1,'2022-11-07 00:09:04','2022-11-07 08:11:34','2022-11-07 08:11:34'),(1876,7768,40728,13762,16,552,'App\\Models\\PeriodLiquidation',NULL,552,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',18655.14,NULL,NULL,1,'2022-11-07 00:09:19','2022-11-07 08:11:43','2022-11-07 08:11:43'),(1877,7768,40728,13763,16,562,'App\\Models\\PeriodLiquidation',NULL,562,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',24312.51,NULL,NULL,1,'2022-11-07 00:09:25','2022-11-07 08:11:49','2022-11-07 08:11:49'),(1878,7768,40728,13765,16,556,'App\\Models\\PeriodLiquidation',NULL,556,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',20694.15,NULL,NULL,1,'2022-11-07 00:09:31','2022-11-07 08:12:30','2022-11-07 08:12:30'),(1879,7768,40728,13766,16,558,'App\\Models\\PeriodLiquidation',NULL,558,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',14224.41,NULL,NULL,1,'2022-11-07 00:09:38','2022-11-07 08:12:44','2022-11-07 08:12:44');
INSERT INTO `balance_libro` VALUES (1880,7768,40728,13781,3,1390,'App\\Models\\Receipt',1390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',3000.21,NULL,NULL,1,'2022-11-07 08:09:17','2022-11-07 08:09:17',NULL),(1881,7768,40728,13760,3,593,'App\\Models\\Receipt',593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',2000.57,NULL,NULL,1,'2022-11-07 08:13:57','2022-11-07 08:13:57',NULL),(1882,7768,40728,13760,3,632,'App\\Models\\Receipt',632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',3000.34,NULL,NULL,1,'2022-11-07 08:14:41','2022-11-07 08:14:41',NULL),(1883,7768,40728,13766,3,1158,'App\\Models\\Receipt',1158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',4219.36,NULL,NULL,1,'2022-11-07 08:15:25','2022-11-07 08:15:25',NULL),(1884,7768,40728,13761,3,1094,'App\\Models\\Receipt',1094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',4313.95,NULL,NULL,1,'2022-11-07 08:15:44','2022-11-07 08:15:44',NULL),(1885,7768,40728,13760,3,638,'App\\Models\\Receipt',638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',1894.63,NULL,NULL,1,'2022-11-07 08:16:08','2022-11-07 08:16:08',NULL),(1886,7768,40728,13760,3,637,'App\\Models\\Receipt',637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',500.00,NULL,NULL,1,'2022-11-07 08:16:38','2022-11-07 08:16:38',NULL),(1887,7768,40728,13760,3,636,'App\\Models\\Receipt',636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',2159.16,NULL,NULL,1,'2022-11-07 08:16:56','2022-11-07 08:16:56',NULL),(1888,7768,40728,13760,3,635,'App\\Models\\Receipt',635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',3150.01,NULL,NULL,1,'2022-11-07 08:17:24','2022-11-07 08:17:24',NULL),(1889,7768,40728,13760,3,634,'App\\Models\\Receipt',634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',1501.63,NULL,NULL,1,'2022-11-07 08:17:56','2022-11-07 08:17:56',NULL),(1890,7768,40728,13760,3,633,'App\\Models\\Receipt',633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',1740.00,NULL,NULL,1,'2022-11-07 08:18:19','2022-11-07 08:18:19',NULL),(1891,7768,40728,13760,3,631,'App\\Models\\Receipt',631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',1137.78,NULL,NULL,1,'2022-11-07 08:19:23','2022-11-07 08:19:23',NULL),(1892,7768,40728,13760,3,630,'App\\Models\\Receipt',630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',3001.36,NULL,NULL,1,'2022-11-07 08:19:36','2022-11-07 08:19:36',NULL),(1893,7768,40728,13760,3,629,'App\\Models\\Receipt',629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',1000.03,NULL,NULL,1,'2022-11-07 08:20:19','2022-11-07 08:20:19',NULL),(1894,7768,40728,13760,3,628,'App\\Models\\Receipt',628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',1474.80,NULL,NULL,1,'2022-11-07 08:20:41','2022-11-07 08:20:41',NULL),(1895,7768,40728,13760,3,627,'App\\Models\\Receipt',627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',1483.39,NULL,NULL,1,'2022-11-07 08:21:03','2022-11-07 08:21:03',NULL),(1896,7768,40728,13760,3,626,'App\\Models\\Receipt',626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',1001.09,NULL,NULL,1,'2022-11-07 08:21:19','2022-11-07 08:21:19',NULL),(1897,7768,40728,13760,3,625,'App\\Models\\Receipt',625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',4181.01,NULL,NULL,1,'2022-11-07 08:21:40','2022-11-07 08:21:40',NULL),(1898,7768,40728,13760,3,624,'App\\Models\\Receipt',624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',1501.19,NULL,NULL,1,'2022-11-07 08:21:58','2022-11-07 08:21:58',NULL),(1899,7768,40728,13760,3,623,'App\\Models\\Receipt',623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',3801.18,NULL,NULL,1,'2022-11-07 08:22:34','2022-11-07 08:22:34',NULL),(1900,7768,40728,13760,3,622,'App\\Models\\Receipt',622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2000.28,NULL,NULL,1,'2022-11-07 08:22:57','2022-11-07 08:22:57',NULL);
INSERT INTO `balance_libro` VALUES (1901,7768,40728,13760,3,621,'App\\Models\\Receipt',621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',2001.24,NULL,NULL,1,'2022-11-07 08:24:45','2022-11-07 08:24:45',NULL),(1902,7768,40728,13760,3,620,'App\\Models\\Receipt',620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',2500.96,NULL,NULL,1,'2022-11-07 08:27:29','2022-11-07 08:27:29',NULL),(1903,7768,40728,13760,3,619,'App\\Models\\Receipt',619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',4101.62,NULL,NULL,1,'2022-11-07 08:27:54','2022-11-07 08:27:54',NULL),(1904,7768,40728,13760,3,618,'App\\Models\\Receipt',618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',3001.36,NULL,NULL,1,'2022-11-07 08:28:26','2022-11-07 08:28:26',NULL),(1905,7768,40728,13760,3,617,'App\\Models\\Receipt',617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',3001.36,NULL,NULL,1,'2022-11-07 08:28:47','2022-11-07 08:28:47',NULL),(1906,7768,40728,13760,3,616,'App\\Models\\Receipt',616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',2500.96,NULL,NULL,1,'2022-11-07 08:29:08','2022-11-07 08:29:08',NULL),(1907,7768,40728,13760,3,615,'App\\Models\\Receipt',615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',5000.91,NULL,NULL,1,'2022-11-07 08:29:36','2022-11-07 08:29:36',NULL),(1908,7768,40728,13760,3,614,'App\\Models\\Receipt',614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',4000.12,NULL,NULL,1,'2022-11-07 08:29:57','2022-11-07 08:29:57',NULL),(1909,7768,40728,13760,3,613,'App\\Models\\Receipt',613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',3003.39,NULL,NULL,1,'2022-11-07 08:30:14','2022-11-07 08:30:14',NULL),(1910,7768,40728,13760,3,612,'App\\Models\\Receipt',612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',1501.63,NULL,NULL,1,'2022-11-07 08:30:30','2022-11-07 08:30:30',NULL),(1911,7768,40728,13760,3,611,'App\\Models\\Receipt',611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',5079.06,NULL,NULL,1,'2022-11-07 08:31:04','2022-11-07 08:31:04',NULL),(1912,7768,40728,13760,3,610,'App\\Models\\Receipt',610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',2501.47,NULL,NULL,1,'2022-11-07 08:31:29','2022-11-07 08:31:29',NULL),(1913,7768,40728,13760,3,609,'App\\Models\\Receipt',609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',4001.86,NULL,NULL,1,'2022-11-07 08:31:46','2022-11-07 08:31:46',NULL),(1914,7768,40728,13760,3,608,'App\\Models\\Receipt',608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',4860.00,NULL,NULL,1,'2022-11-07 08:32:04','2022-11-07 08:32:04',NULL),(1915,7768,40728,13760,3,607,'App\\Models\\Receipt',607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',2000.84,NULL,NULL,1,'2022-11-07 08:32:22','2022-11-07 08:32:22',NULL),(1916,7768,40728,13760,3,606,'App\\Models\\Receipt',606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',3000.34,NULL,NULL,1,'2022-11-07 08:32:38','2022-11-07 08:32:38',NULL),(1917,7768,40728,13760,3,605,'App\\Models\\Receipt',605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',5000.17,NULL,NULL,1,'2022-11-07 08:32:58','2022-11-07 08:32:58',NULL),(1918,7768,40728,13760,3,604,'App\\Models\\Receipt',604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',3517.79,NULL,NULL,1,'2022-11-07 08:33:16','2022-11-07 08:33:16',NULL),(1919,7768,40728,13760,3,603,'App\\Models\\Receipt',603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',4502.91,NULL,NULL,1,'2022-11-07 08:33:35','2022-11-07 08:33:35',NULL),(1920,7768,40728,13760,3,602,'App\\Models\\Receipt',602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2600.43,NULL,NULL,1,'2022-11-07 08:33:55','2022-11-07 08:33:55',NULL),(1921,7768,40728,13760,3,601,'App\\Models\\Receipt',601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2001.46,NULL,NULL,1,'2022-11-07 08:34:38','2022-11-07 08:34:38',NULL);
INSERT INTO `balance_libro` VALUES (1922,7768,40728,13760,3,600,'App\\Models\\Receipt',600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-13','2021-06-13',5232.33,NULL,NULL,1,'2022-11-07 08:34:55','2022-11-07 08:34:55',NULL),(1923,7768,40728,13760,3,599,'App\\Models\\Receipt',599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-13','2021-06-13',6834.15,NULL,NULL,1,'2022-11-07 08:35:10','2022-11-07 08:35:10',NULL),(1924,7768,40728,13760,3,598,'App\\Models\\Receipt',598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-13','2021-06-13',3700.36,NULL,NULL,1,'2022-11-07 08:35:33','2022-11-07 08:35:33',NULL),(1925,7768,40728,13760,3,597,'App\\Models\\Receipt',597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',3000.42,NULL,NULL,1,'2022-11-07 08:35:49','2022-11-07 08:35:49',NULL),(1926,7768,40728,13760,3,596,'App\\Models\\Receipt',596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',6401.32,NULL,NULL,1,'2022-11-07 08:36:17','2022-11-07 08:36:17',NULL),(1927,7768,40728,13760,3,595,'App\\Models\\Receipt',595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',3000.34,NULL,NULL,1,'2022-11-07 08:36:47','2022-11-07 08:36:47',NULL),(1928,7768,40728,13760,3,594,'App\\Models\\Receipt',594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',3003.26,NULL,NULL,1,'2022-11-07 08:37:10','2022-11-07 08:37:10',NULL),(1929,7768,40728,13764,3,783,'App\\Models\\Receipt',783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-15','2021-10-15',4359.56,NULL,NULL,1,'2022-11-07 08:37:59','2022-11-07 08:37:59',NULL),(1930,7768,40728,13763,3,1222,'App\\Models\\Receipt',1222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',2027.42,NULL,NULL,1,'2022-11-07 08:38:12','2022-11-07 08:38:12',NULL),(1931,7768,40728,13775,3,420,'App\\Models\\Receipt',420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',4679.62,NULL,NULL,1,'2022-11-07 08:39:22','2022-11-07 08:39:22',NULL),(1932,7768,40728,13782,3,1432,'App\\Models\\Receipt',1432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',3852.47,NULL,NULL,1,'2022-11-07 08:39:47','2022-11-17 22:21:32','2022-11-17 22:21:32'),(1933,7768,40728,13782,3,1427,'App\\Models\\Receipt',1427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',4766.90,NULL,NULL,1,'2022-11-07 08:40:00','2022-11-17 22:21:03','2022-11-17 22:21:03'),(1934,7768,40728,13763,3,1228,'App\\Models\\Receipt',1228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',2027.56,NULL,NULL,1,'2022-11-07 08:40:18','2022-11-07 08:40:18',NULL),(1935,7768,40728,13763,3,1225,'App\\Models\\Receipt',1225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-12','2021-09-12',2000.00,NULL,NULL,1,'2022-11-07 08:40:35','2022-11-07 08:40:35',NULL),(1936,7768,40728,13766,3,1166,'App\\Models\\Receipt',1166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',2534.45,NULL,NULL,1,'2022-11-07 08:41:09','2022-11-07 08:41:09',NULL),(1937,7768,40728,13766,3,1165,'App\\Models\\Receipt',1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-05','2021-12-05',4382.75,NULL,NULL,1,'2022-11-07 08:41:25','2022-11-07 08:41:25',NULL),(1938,7768,40728,13766,3,1163,'App\\Models\\Receipt',1163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',4156.90,NULL,NULL,1,'2022-11-07 08:41:44','2022-11-07 08:41:44',NULL),(1939,7768,40728,13766,3,1162,'App\\Models\\Receipt',1162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-24','2021-12-24',4055.13,NULL,NULL,1,'2022-11-07 08:42:10','2022-11-07 08:42:10',NULL),(1940,7768,40728,13766,3,1161,'App\\Models\\Receipt',1161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-21','2021-12-21',4165.01,NULL,NULL,1,'2022-11-07 08:42:23','2022-11-07 08:42:23',NULL),(1941,7768,40728,13782,3,1528,'App\\Models\\Receipt',1528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',32399.00,NULL,NULL,1,'2022-11-07 08:44:59','2022-11-07 08:45:08','2022-11-07 08:45:08');
INSERT INTO `balance_libro` VALUES (1942,7768,40728,13782,3,1528,'App\\Models\\Receipt',1528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',32399.00,NULL,NULL,1,'2022-11-07 08:45:08','2022-11-07 08:45:08',NULL),(1943,7768,40728,13766,3,1159,'App\\Models\\Receipt',1159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-22','2021-11-22',3800.50,NULL,NULL,1,'2022-11-07 08:45:41','2022-11-07 08:45:41',NULL),(1944,7768,40728,13766,3,1153,'App\\Models\\Receipt',1153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-24','2021-12-24',4055.13,NULL,NULL,1,'2022-11-07 08:46:02','2022-11-07 08:46:02',NULL),(1945,7768,40728,13766,3,1147,'App\\Models\\Receipt',1147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-21','2021-12-21',4165.01,NULL,NULL,1,'2022-11-07 08:46:21','2022-11-07 08:46:21',NULL),(1946,7768,40728,13766,3,1145,'App\\Models\\Receipt',1145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',4156.90,NULL,NULL,1,'2022-11-07 08:46:40','2022-11-07 08:46:40',NULL),(1947,7768,40728,13766,3,1134,'App\\Models\\Receipt',1134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',2534.45,NULL,NULL,1,'2022-11-07 08:46:56','2022-11-07 08:46:56',NULL),(1948,7768,40728,13766,3,1132,'App\\Models\\Receipt',1132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-05','2021-12-05',4382.75,NULL,NULL,1,'2022-11-07 08:47:18','2022-11-07 08:47:18',NULL),(1949,7768,40728,13761,3,1097,'App\\Models\\Receipt',1097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',3904.50,NULL,NULL,1,'2022-11-07 08:47:39','2022-11-07 08:47:39',NULL),(1950,7768,40728,13765,3,861,'App\\Models\\Receipt',861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-14','2021-11-14',3564.59,NULL,NULL,1,'2022-11-07 08:47:55','2022-11-07 08:47:55',NULL),(1951,7768,40728,13765,3,859,'App\\Models\\Receipt',859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',3900.59,NULL,NULL,1,'2022-11-07 08:48:16','2022-11-07 08:48:16',NULL),(1952,7768,40728,13765,3,844,'App\\Models\\Receipt',844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-14','2021-11-14',3564.59,NULL,NULL,1,'2022-11-07 08:48:39','2022-11-07 08:48:39',NULL),(1953,7768,40728,13764,3,785,'App\\Models\\Receipt',785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',3349.90,NULL,NULL,1,'2022-11-07 08:50:57','2022-11-07 08:50:57',NULL),(1954,7768,40728,13764,3,780,'App\\Models\\Receipt',780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',4952.45,NULL,NULL,1,'2022-11-07 08:51:09','2022-11-07 08:51:09',NULL),(1955,7768,40728,13764,3,779,'App\\Models\\Receipt',779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-10','2021-10-10',4056.58,NULL,NULL,1,'2022-11-07 08:51:28','2022-11-07 08:51:28',NULL),(1956,7768,40728,13760,3,591,'App\\Models\\Receipt',591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',3900.00,NULL,NULL,1,'2022-11-07 08:51:46','2022-11-07 08:51:46',NULL),(1957,7768,40728,13760,3,589,'App\\Models\\Receipt',589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',2900.00,NULL,NULL,1,'2022-11-07 08:52:04','2022-11-07 08:52:04',NULL),(1958,7768,40728,13760,3,587,'App\\Models\\Receipt',587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',3982.00,NULL,NULL,1,'2022-11-07 08:52:24','2022-11-07 08:52:24',NULL),(1959,7768,40728,13760,3,584,'App\\Models\\Receipt',584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',3501.10,NULL,NULL,1,'2022-11-07 08:52:41','2022-11-07 08:52:41',NULL),(1960,7768,40728,13778,3,537,'App\\Models\\Receipt',537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',5113.41,NULL,NULL,1,'2022-11-07 08:53:04','2022-11-07 08:53:04',NULL),(1961,7768,40728,13773,3,523,'App\\Models\\Receipt',523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',3954.87,NULL,NULL,1,'2022-11-07 08:53:19','2022-11-07 08:53:19',NULL),(1962,7768,40728,13773,3,507,'App\\Models\\Receipt',507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',3954.87,NULL,NULL,1,'2022-11-07 08:53:48','2022-11-07 08:53:48',NULL);
INSERT INTO `balance_libro` VALUES (1963,7768,40728,13774,3,460,'App\\Models\\Receipt',460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',3784.39,NULL,NULL,1,'2022-11-07 08:54:10','2022-11-07 08:54:10',NULL),(1964,7768,40728,13774,3,456,'App\\Models\\Receipt',456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',5202.88,NULL,NULL,1,'2022-11-07 08:54:38','2022-11-07 08:54:38',NULL),(1965,7768,40728,13775,3,426,'App\\Models\\Receipt',426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1159.00,NULL,NULL,1,'2022-11-07 08:54:58','2022-11-07 08:54:58',NULL),(1966,7768,40728,13775,3,424,'App\\Models\\Receipt',424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',3400.90,NULL,NULL,1,'2022-11-07 08:55:15','2022-11-07 08:55:15',NULL),(1967,7768,40728,13775,3,422,'App\\Models\\Receipt',422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',5350.70,NULL,NULL,1,'2022-11-07 08:55:35','2022-11-07 08:55:35',NULL),(1968,7768,40728,13776,3,367,'App\\Models\\Receipt',367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',4883.00,NULL,NULL,1,'2022-11-07 08:56:07','2022-11-07 08:56:07',NULL),(1969,7768,40728,13776,3,359,'App\\Models\\Receipt',359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',2534.33,NULL,NULL,1,'2022-11-07 08:56:35','2022-11-07 08:56:35',NULL),(1970,7768,40728,13776,3,354,'App\\Models\\Receipt',354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',4650.42,NULL,NULL,1,'2022-11-07 08:56:58','2022-11-07 08:57:10','2022-11-07 08:57:10'),(1971,7768,40728,13776,3,354,'App\\Models\\Receipt',354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',4650.42,NULL,NULL,1,'2022-11-07 08:57:10','2022-11-07 08:57:10',NULL),(1972,7768,40728,13777,3,267,'App\\Models\\Receipt',267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',4680.88,NULL,NULL,1,'2022-11-07 08:57:28','2022-11-07 08:57:28',NULL),(1973,7768,40728,13781,3,1349,'App\\Models\\Receipt',1349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',25000.00,NULL,NULL,1,'2022-11-08 15:26:56','2022-11-08 15:26:56',NULL),(1974,7768,40728,13766,3,1157,'App\\Models\\Receipt',1157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',7500.00,NULL,NULL,1,'2022-11-08 15:29:58','2022-11-08 15:29:58',NULL),(1975,7768,40728,13766,3,1131,'App\\Models\\Receipt',1131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-04','2021-12-04',7500.00,NULL,NULL,1,'2022-11-08 15:30:08','2022-11-08 15:30:08',NULL),(1976,7768,40728,13765,3,837,'App\\Models\\Receipt',837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',7500.00,NULL,NULL,1,'2022-11-08 15:30:19','2022-11-08 15:30:19',NULL),(1977,7768,40728,13765,3,836,'App\\Models\\Receipt',836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-11','2021-11-11',7500.00,NULL,NULL,1,'2022-11-08 15:30:29','2022-11-08 15:30:29',NULL),(1978,7768,40728,13778,3,542,'App\\Models\\Receipt',542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',7500.00,NULL,NULL,1,'2022-11-08 15:30:39','2022-11-08 15:30:39',NULL),(1979,7768,40728,13773,3,517,'App\\Models\\Receipt',517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',7500.00,NULL,NULL,1,'2022-11-08 15:30:50','2022-11-08 15:30:50',NULL),(1980,7768,40728,13776,3,372,'App\\Models\\Receipt',372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',15000.00,NULL,NULL,1,'2022-11-08 15:31:03','2022-11-08 15:31:03',NULL),(1981,7768,40728,13776,3,371,'App\\Models\\Receipt',371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',7500.00,NULL,NULL,1,'2022-11-08 15:31:14','2022-11-08 15:31:14',NULL),(1982,7768,40728,13782,3,1417,'App\\Models\\Receipt',1417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',15000.00,NULL,NULL,1,'2022-11-08 15:32:09','2022-11-08 15:32:09',NULL),(1983,7768,40728,13781,3,1337,'App\\Models\\Receipt',1337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',26000.00,NULL,NULL,1,'2022-11-08 15:32:20','2022-11-08 15:32:20',NULL);
INSERT INTO `balance_libro` VALUES (1984,7768,40728,13779,3,311,'App\\Models\\Receipt',311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',15000.00,NULL,NULL,1,'2022-11-08 15:32:34','2022-11-08 15:32:34',NULL),(1985,7768,40728,13780,3,78,'App\\Models\\Receipt',78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',15000.00,NULL,NULL,1,'2022-11-08 15:32:45','2022-11-08 15:32:45',NULL),(1986,7768,40728,13764,3,787,'App\\Models\\Receipt',787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',2800.00,NULL,NULL,1,'2022-11-08 15:33:49','2022-11-08 15:33:49',NULL),(1987,7768,40728,13766,21,1825,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1825,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',30000.00,NULL,NULL,1,'2022-11-08 15:35:30','2022-11-15 12:42:24','2022-11-15 12:42:24'),(1988,7768,40728,13774,21,1826,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1826,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',7500.00,NULL,NULL,1,'2022-11-08 15:36:24','2022-11-08 15:36:24',NULL),(1989,7768,40728,13778,3,1517,'App\\Models\\Receipt',1517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',6524.70,NULL,NULL,1,'2022-11-08 15:39:23','2022-11-08 15:39:23',NULL),(1990,7768,40728,13781,3,1397,'App\\Models\\Receipt',1397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',16887.64,NULL,NULL,1,'2022-11-08 15:39:41','2022-11-08 15:39:41',NULL),(1991,7768,40728,13762,3,1332,'App\\Models\\Receipt',1332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',7783.61,NULL,NULL,1,'2022-11-08 15:39:53','2022-11-08 15:39:53',NULL),(1992,7768,40728,13760,3,1331,'App\\Models\\Receipt',1331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',1839.21,NULL,NULL,1,'2022-11-08 15:40:06','2022-11-08 15:40:06',NULL),(1993,7768,40728,13780,3,1330,'App\\Models\\Receipt',1330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',18980.49,NULL,NULL,1,'2022-11-08 15:40:19','2022-11-08 15:40:19',NULL),(1994,7768,40728,13779,3,1264,'App\\Models\\Receipt',1264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',15141.24,NULL,NULL,1,'2022-11-08 15:40:28','2022-11-08 15:40:28',NULL),(1995,7768,40728,13763,3,1231,'App\\Models\\Receipt',1231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',15800.13,NULL,NULL,1,'2022-11-08 15:41:02','2022-11-08 15:41:02',NULL),(1996,7768,40728,13763,3,1230,'App\\Models\\Receipt',1230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',4692.25,NULL,NULL,1,'2022-11-08 15:41:12','2022-11-08 15:41:12',NULL),(1997,7768,40728,13766,3,1172,'App\\Models\\Receipt',1172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',15813.29,NULL,NULL,1,'2022-11-08 15:41:23','2022-11-08 15:41:23',NULL),(1998,7768,40728,13761,3,1100,'App\\Models\\Receipt',1100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',0.03,NULL,NULL,1,'2022-11-08 15:41:49','2022-11-08 15:41:49',NULL),(1999,7768,40728,13761,3,1099,'App\\Models\\Receipt',1099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',700.74,NULL,NULL,1,'2022-11-08 15:42:05','2022-11-08 15:42:05',NULL),(2000,7768,40728,13761,3,1098,'App\\Models\\Receipt',1098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',392.97,NULL,NULL,1,'2022-11-08 15:42:16','2022-11-08 15:42:16',NULL),(2001,7768,40728,13765,3,864,'App\\Models\\Receipt',864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',16132.10,NULL,NULL,1,'2022-11-08 15:42:27','2022-11-08 15:42:27',NULL),(2002,7768,40728,13764,3,789,'App\\Models\\Receipt',789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',7955.80,NULL,NULL,1,'2022-11-08 15:42:36','2022-11-08 15:42:36',NULL),(2003,7768,40728,13774,3,465,'App\\Models\\Receipt',465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',30596.93,NULL,NULL,1,'2022-11-08 15:42:46','2022-11-08 15:42:46',NULL),(2004,7768,40728,13774,3,461,'App\\Models\\Receipt',461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',6536.15,NULL,NULL,1,'2022-11-08 15:43:09','2022-11-08 15:43:09',NULL);
INSERT INTO `balance_libro` VALUES (2005,7768,40728,13775,3,427,'App\\Models\\Receipt',427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',3849.43,NULL,NULL,1,'2022-11-08 15:43:25','2022-11-08 15:43:25',NULL),(2006,7768,40728,13776,3,378,'App\\Models\\Receipt',378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',3967.64,NULL,NULL,1,'2022-11-08 15:43:39','2022-11-08 15:43:39',NULL),(2007,7768,40728,13777,3,270,'App\\Models\\Receipt',270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',3227.13,NULL,NULL,1,'2022-11-08 15:43:49','2022-11-08 15:43:49',NULL),(2008,7768,41298,88857,3,1536,'App\\Models\\Receipt',1536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',6156.36,NULL,NULL,1,'2022-11-14 19:12:14','2022-11-14 19:12:14',NULL),(2009,7768,40728,13763,3,2009,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',5000.00,'GASTOS VARIOS',NULL,1,'2022-11-15 11:50:53','2022-11-15 11:50:53',NULL),(2010,7768,40728,13766,3,2010,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',760.00,'GASTOS VARIOS',NULL,1,'2022-11-15 11:51:39','2022-11-15 11:51:39',NULL),(2011,7768,40728,13773,3,2011,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',670.00,'GASTOS VARIOS',NULL,1,'2022-11-15 11:52:24','2022-11-15 11:52:24',NULL),(2012,7768,40728,13773,2,2012,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',20000.00,'APORTE DE LOS SOCIOS',NULL,1,'2022-11-15 11:55:47','2022-11-15 11:55:47',NULL),(2013,7768,40728,13773,5,2013,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',25000.00,'CAJA',NULL,1,'2022-11-15 11:59:06','2022-11-15 11:59:06',NULL),(2014,7768,40728,13773,5,2014,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',60000.00,'CAJA',NULL,1,'2022-11-15 11:59:36','2022-11-15 11:59:36',NULL),(2015,7768,40728,13773,5,2015,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',50000.00,'CAJA',NULL,1,'2022-11-15 12:00:05','2022-11-15 12:00:05',NULL),(2016,7768,40728,13762,3,1262,'App\\Models\\Receipt',1262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-05','2021-08-05',99900.00,NULL,NULL,1,'2022-11-15 12:13:47','2022-11-15 12:13:47',NULL),(2017,7768,40728,13762,3,1252,'App\\Models\\Receipt',1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',4201.36,NULL,NULL,1,'2022-11-15 12:19:57','2022-11-15 12:19:57',NULL),(2018,7768,40728,13763,3,1229,'App\\Models\\Receipt',1229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',3569.30,NULL,NULL,1,'2022-11-15 12:20:29','2022-11-15 12:20:29',NULL),(2019,7768,40728,13763,3,1224,'App\\Models\\Receipt',1224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11','2021-09-11',3265.98,NULL,NULL,1,'2022-11-15 12:20:39','2022-11-15 12:20:39',NULL),(2020,7768,40728,13766,3,1167,'App\\Models\\Receipt',1167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-11','2021-12-11',4283.71,NULL,NULL,1,'2022-11-15 12:21:00','2022-11-15 12:21:00',NULL),(2021,7768,40728,13766,3,1160,'App\\Models\\Receipt',1160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',2702.30,NULL,NULL,1,'2022-11-15 12:21:12','2022-11-15 12:21:12',NULL),(2022,7768,40728,13765,3,863,'App\\Models\\Receipt',863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',4284.46,NULL,NULL,1,'2022-11-15 12:21:21','2022-11-15 12:21:21',NULL),(2023,7768,40728,13765,3,862,'App\\Models\\Receipt',862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',4268.66,NULL,NULL,1,'2022-11-15 12:21:33','2022-11-15 12:21:33',NULL),(2024,7768,40728,13776,3,374,'App\\Models\\Receipt',374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',4837.08,NULL,NULL,1,'2022-11-15 12:21:50','2022-11-15 12:21:50',NULL);
INSERT INTO `balance_libro` VALUES (2025,7768,40728,13773,3,521,'App\\Models\\Receipt',521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-02','2022-01-02',4180.97,NULL,NULL,1,'2022-11-15 12:22:06','2022-11-15 12:22:06',NULL),(2026,7768,40728,13773,3,522,'App\\Models\\Receipt',522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',4119.38,NULL,NULL,1,'2022-11-15 12:22:19','2022-11-15 12:22:19',NULL),(2027,7768,40728,13765,3,857,'App\\Models\\Receipt',857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',4173.32,NULL,NULL,1,'2022-11-15 12:22:31','2022-11-15 12:22:31',NULL),(2028,7768,40728,13776,3,373,'App\\Models\\Receipt',373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',3993.36,NULL,NULL,1,'2022-11-15 12:23:05','2022-11-15 12:23:05',NULL),(2029,7768,40728,13764,3,784,'App\\Models\\Receipt',784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-17','2021-10-17',3880.01,NULL,NULL,1,'2022-11-15 12:23:50','2022-11-15 12:23:50',NULL),(2030,7768,40728,13764,3,777,'App\\Models\\Receipt',777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',3580.30,NULL,NULL,1,'2022-11-15 12:24:06','2022-11-15 12:24:06',NULL),(2031,7768,40728,13763,3,1226,'App\\Models\\Receipt',1226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-23','2021-09-23',4156.82,NULL,NULL,1,'2022-11-15 12:24:22','2022-11-15 12:24:22',NULL),(2032,7768,40728,13763,3,1221,'App\\Models\\Receipt',1221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',4256.00,NULL,NULL,1,'2022-11-15 12:24:42','2022-11-15 12:24:42',NULL),(2033,7768,40728,13761,3,1090,'App\\Models\\Receipt',1090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',4100.59,NULL,NULL,1,'2022-11-15 12:24:56','2022-11-15 12:24:56',NULL),(2034,7768,40728,13760,3,592,'App\\Models\\Receipt',592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',4147.19,NULL,NULL,1,'2022-11-15 12:25:06','2022-11-15 12:25:06',NULL),(2035,7768,40728,13778,3,540,'App\\Models\\Receipt',540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-26','2022-06-26',7345.81,NULL,NULL,1,'2022-11-15 12:25:24','2023-04-25 19:23:06','2023-04-25 19:23:06'),(2036,7768,40728,13779,3,330,'App\\Models\\Receipt',330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-24','2022-07-24',5474.60,NULL,NULL,1,'2022-11-15 12:25:40','2022-11-15 12:25:40',NULL),(2037,7768,40728,13759,3,115,'App\\Models\\Receipt',115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',4100.11,NULL,NULL,1,'2022-11-15 12:25:50','2022-11-15 12:25:50',NULL),(2038,7768,40728,13780,3,85,'App\\Models\\Receipt',85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',4957.38,NULL,NULL,1,'2022-11-15 12:26:04','2022-11-17 19:13:03','2022-11-17 19:13:03'),(2039,7768,40728,13760,3,571,'App\\Models\\Receipt',571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',9129.86,NULL,NULL,1,'2022-11-15 12:28:32','2022-11-15 12:28:32',NULL),(2040,7768,40728,13766,3,1171,'App\\Models\\Receipt',1171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14','2021-12-14',9380.00,NULL,NULL,1,'2022-11-15 12:29:02','2022-11-15 12:29:02',NULL),(2041,7768,40728,13766,3,1164,'App\\Models\\Receipt',1164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',4002.65,NULL,NULL,1,'2022-11-15 12:29:13','2022-11-15 12:29:13',NULL),(2042,7768,40728,13766,3,1151,'App\\Models\\Receipt',1151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',22991.21,NULL,NULL,1,'2022-11-15 12:39:47','2022-11-15 12:41:19','2022-11-15 12:41:19'),(2043,7768,40728,13766,3,1136,'App\\Models\\Receipt',1136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-10','2021-12-10',77678.37,NULL,NULL,1,'2022-11-15 12:40:03','2022-11-15 12:41:35','2022-11-15 12:41:35'),(2044,7768,40728,13774,3,451,'App\\Models\\Receipt',451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',8430.15,NULL,NULL,1,'2022-11-15 12:40:15','2022-11-15 12:41:48','2022-11-15 12:41:48');
INSERT INTO `balance_libro` VALUES (2045,7768,40728,13766,3,1151,'App\\Models\\Receipt',1151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',22991.21,NULL,NULL,1,'2022-11-15 12:41:19','2022-11-15 12:41:19',NULL),(2046,7768,40728,13766,3,1136,'App\\Models\\Receipt',1136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-10','2021-12-10',77678.37,NULL,NULL,1,'2022-11-15 12:41:35','2022-11-15 12:41:35',NULL),(2047,7768,40728,13774,3,451,'App\\Models\\Receipt',451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',8430.15,NULL,NULL,1,'2022-11-15 12:41:48','2022-11-15 12:41:48',NULL),(2048,7768,40728,13764,21,1879,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1879,NULL,NULL,NULL,0,NULL,'2021-12-10','2021-12-10',77678.37,NULL,NULL,1,'2022-11-15 12:43:29','2022-11-15 12:43:29',NULL),(2049,7768,40728,13773,21,1880,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1880,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',22991.21,NULL,NULL,1,'2022-11-15 12:44:16','2022-11-15 12:44:16',NULL),(2050,7768,40728,13774,21,1881,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1881,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',8430.15,NULL,NULL,1,'2022-11-15 12:44:52','2022-11-15 12:44:52',NULL),(2051,7768,40728,13766,21,1882,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1882,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',30000.00,NULL,NULL,1,'2022-11-15 12:48:20','2022-11-15 12:48:20',NULL),(2052,7768,40728,13764,3,786,'App\\Models\\Receipt',786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-24','2021-10-24',3777.11,NULL,NULL,1,'2022-11-15 12:50:16','2022-11-15 12:50:16',NULL),(2053,7768,40728,13766,3,1149,'App\\Models\\Receipt',1149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',28381.25,NULL,NULL,1,'2022-11-15 12:52:11','2022-11-15 12:52:11',NULL),(2054,7768,40728,13766,3,1143,'App\\Models\\Receipt',1143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-17','2021-12-17',45406.93,NULL,NULL,1,'2022-11-15 12:52:27','2022-11-15 12:52:27',NULL),(2055,7768,40728,13773,3,502,'App\\Models\\Receipt',502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',45406.93,NULL,NULL,1,'2022-11-15 12:52:38','2022-11-15 12:52:38',NULL),(2056,7768,40728,13773,21,1887,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1887,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',28381.25,NULL,NULL,1,'2022-11-15 12:55:26','2022-11-15 12:55:26',NULL),(2057,7768,40728,13765,3,826,'App\\Models\\Receipt',826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-02','2021-11-02',67199.00,NULL,NULL,1,'2022-11-15 15:04:49','2022-11-15 15:04:49',NULL),(2058,7768,40728,13765,3,855,'App\\Models\\Receipt',855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',18994.00,NULL,NULL,1,'2022-11-15 15:05:16','2022-11-15 15:05:16',NULL),(2059,7768,40728,13775,3,429,'App\\Models\\Receipt',429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-27','2022-03-27',3300.11,NULL,NULL,1,'2022-11-15 15:06:58','2022-11-15 15:06:58',NULL),(2060,7768,40728,13761,3,1089,'App\\Models\\Receipt',1089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',3200.01,NULL,NULL,1,'2022-11-15 15:07:48','2022-11-15 15:07:48',NULL),(2061,7768,41322,90367,3,1537,'App\\Models\\Receipt',1537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',33000.00,NULL,NULL,1,'2022-11-15 16:16:20','2022-11-16 19:52:56','2022-11-16 19:52:56'),(2062,7768,41322,90367,3,1538,'App\\Models\\Receipt',1538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',4712.29,NULL,NULL,1,'2022-11-15 16:16:20','2022-11-15 16:28:17','2022-11-15 16:28:17'),(2063,7768,41322,90367,3,1539,'App\\Models\\Receipt',1539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',2104.41,NULL,NULL,1,'2022-11-15 16:16:20','2022-11-15 16:16:20',NULL),(2064,7768,41322,90367,3,1538,'App\\Models\\Receipt',1538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',4712.29,NULL,NULL,1,'2022-11-15 16:28:17','2022-11-16 19:53:16','2022-11-16 19:53:16');
INSERT INTO `balance_libro` VALUES (2065,7768,41298,88857,3,1409,'App\\Models\\Receipt',1409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',4819.60,NULL,NULL,1,'2022-11-15 21:03:30','2022-11-15 21:03:30',NULL),(2066,7768,40728,13761,4,2066,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',3333.33,'AMORTIZACIONES',NULL,1,'2022-11-16 12:38:57','2022-11-16 12:38:57',NULL),(2067,7768,40728,13762,4,2067,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',13956.07,'AMORTIZACIONES',NULL,1,'2022-11-16 12:40:24','2022-11-16 12:40:24',NULL),(2068,7768,40728,13763,4,2068,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',22847.45,'AMORTIZACIONES',NULL,1,'2022-11-16 12:41:26','2022-11-16 12:41:26',NULL),(2069,7768,40728,13764,4,2069,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',22847.45,'AMORTIZACIONES',NULL,1,'2022-11-16 12:42:10','2022-11-16 12:42:10',NULL),(2070,7768,40728,13765,4,2070,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',28871.92,'AMORTIZACIONES',NULL,1,'2022-11-16 12:42:44','2022-11-16 12:42:44',NULL),(2071,7768,40728,13766,4,2071,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',36806.17,'AMORTIZACIONES',NULL,1,'2022-11-16 12:43:22','2022-11-16 12:43:22',NULL),(2072,7768,40728,13773,4,2072,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',36806.17,'AMORTIZACIONES',NULL,1,'2022-11-16 12:44:18','2022-11-16 12:44:18',NULL),(2073,7768,40728,13774,4,2073,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',36806.17,'AMORTIZACIONES',NULL,1,'2022-11-16 12:45:00','2022-11-16 12:45:00',NULL),(2074,7768,40728,13775,4,2074,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',36806.17,'AMORTIZACIONES',NULL,1,'2022-11-16 12:45:55','2022-11-16 12:45:55',NULL),(2075,7768,40728,13765,3,845,'App\\Models\\Receipt',845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',190150.42,NULL,NULL,1,'2022-11-16 12:46:25','2022-11-16 12:46:25',NULL),(2076,7768,40728,13766,3,1135,'App\\Models\\Receipt',1135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-10','2021-12-10',384017.70,NULL,NULL,1,'2022-11-16 12:47:28','2022-11-16 12:47:28',NULL),(2077,7768,40728,13773,21,1899,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,1899,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',384017.70,NULL,NULL,1,'2022-11-16 12:49:58','2022-11-16 12:49:58',NULL),(2078,7768,40728,13758,16,178,'App\\Models\\PeriodLiquidation',NULL,178,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',0.00,NULL,NULL,1,'2022-11-16 13:28:19','2022-11-17 22:47:53','2022-11-17 22:47:53'),(2079,7768,40728,13758,15,177,'App\\Models\\PeriodLiquidation',NULL,177,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',243886.63,NULL,NULL,1,'2022-11-16 13:28:26','2022-11-17 22:49:30','2022-11-17 22:49:30'),(2080,7768,40728,13759,16,864,'App\\Models\\PeriodLiquidation',NULL,864,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',11322.84,NULL,NULL,1,'2022-11-16 13:28:31','2022-11-17 22:47:44','2022-11-17 22:47:44'),(2081,7768,40728,13759,15,863,'App\\Models\\PeriodLiquidation',NULL,863,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',333212.30,NULL,NULL,1,'2022-11-16 13:28:40','2022-11-16 13:28:40',NULL),(2082,7768,40728,13760,16,868,'App\\Models\\PeriodLiquidation',NULL,868,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',13483.10,NULL,NULL,1,'2022-11-16 13:28:46','2022-11-16 14:14:25','2022-11-16 14:14:25'),(2083,7768,40728,13760,15,867,'App\\Models\\PeriodLiquidation',NULL,867,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',215452.76,NULL,NULL,1,'2022-11-16 13:29:44','2022-11-16 13:32:08','2022-11-16 13:32:08');
INSERT INTO `balance_libro` VALUES (2084,7768,40728,13761,16,900,'App\\Models\\PeriodLiquidation',NULL,900,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',10190.82,NULL,NULL,1,'2022-11-16 13:29:49','2022-11-17 22:48:04','2022-11-17 22:48:04'),(2085,7768,40728,13761,15,899,'App\\Models\\PeriodLiquidation',NULL,899,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',130455.50,NULL,NULL,1,'2022-11-16 13:29:59','2022-11-16 20:00:24','2022-11-16 20:00:24'),(2086,7768,40728,13762,16,824,'App\\Models\\PeriodLiquidation',NULL,824,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',18255.32,NULL,NULL,1,'2022-11-16 13:30:04','2022-11-17 22:48:09','2022-11-17 22:48:09'),(2087,7768,40728,13762,15,823,'App\\Models\\PeriodLiquidation',NULL,823,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',216438.33,NULL,NULL,1,'2022-11-16 13:30:25','2022-11-16 13:30:25',NULL),(2088,7768,40728,13763,16,854,'App\\Models\\PeriodLiquidation',NULL,854,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',23732.83,NULL,NULL,1,'2022-11-16 13:30:34','2022-11-17 22:48:14','2022-11-17 22:48:14'),(2089,7768,40728,13763,15,853,'App\\Models\\PeriodLiquidation',NULL,853,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',220974.08,NULL,NULL,1,'2022-11-16 13:30:44','2022-11-16 13:30:44',NULL),(2090,7768,40728,13764,16,886,'App\\Models\\PeriodLiquidation',NULL,886,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',16792.50,NULL,NULL,1,'2022-11-16 13:30:49','2022-11-17 22:48:18','2022-11-17 22:48:18'),(2091,7768,40728,13764,15,885,'App\\Models\\PeriodLiquidation',NULL,885,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',144356.13,NULL,NULL,1,'2022-11-16 13:30:57','2022-11-16 13:30:57',NULL),(2092,7768,40728,13765,16,911,'App\\Models\\PeriodLiquidation',NULL,911,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',19668.23,NULL,NULL,1,'2022-11-16 13:31:02','2022-11-17 22:48:22','2022-11-17 22:48:22'),(2093,7768,40728,13765,15,910,'App\\Models\\PeriodLiquidation',NULL,910,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',168264.21,NULL,NULL,1,'2022-11-16 13:31:22','2022-11-24 09:42:16','2022-11-24 09:42:16'),(2094,7768,40728,13766,16,913,'App\\Models\\PeriodLiquidation',NULL,913,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',12980.77,NULL,NULL,1,'2022-11-16 13:31:33','2022-11-17 22:48:27','2022-11-17 22:48:27'),(2095,7768,40728,13766,15,912,'App\\Models\\PeriodLiquidation',NULL,912,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',216120.50,NULL,NULL,1,'2022-11-16 13:31:43','2022-11-16 13:31:43',NULL),(2096,7768,40728,13773,16,892,'App\\Models\\PeriodLiquidation',NULL,892,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',26353.18,NULL,NULL,1,'2022-11-16 13:31:48','2022-11-17 22:48:32','2022-11-17 22:48:32'),(2097,7768,40728,13773,15,891,'App\\Models\\PeriodLiquidation',NULL,891,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',370884.07,NULL,NULL,1,'2022-11-16 13:31:56','2022-11-16 13:31:56',NULL),(2098,7768,40728,13774,16,884,'App\\Models\\PeriodLiquidation',NULL,884,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',22053.48,NULL,NULL,1,'2022-11-16 13:32:08','2022-11-17 22:48:37','2022-11-17 22:48:37'),(2099,7768,40728,13775,15,897,'App\\Models\\PeriodLiquidation',NULL,897,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',119459.90,NULL,NULL,1,'2022-11-16 13:32:19','2022-11-16 13:32:19',NULL),(2100,7768,40728,13774,15,883,'App\\Models\\PeriodLiquidation',NULL,883,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',100712.78,NULL,NULL,1,'2022-11-16 13:32:51','2022-11-16 13:32:51',NULL),(2101,7768,40728,13775,16,898,'App\\Models\\PeriodLiquidation',NULL,898,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',22392.43,NULL,NULL,1,'2022-11-16 13:32:57','2022-11-17 22:48:42','2022-11-17 22:48:42');
INSERT INTO `balance_libro` VALUES (2102,7768,40728,13776,11,2102,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',243886.63,'RECLA SALDOS',NULL,1,'2022-11-16 13:45:06','2022-11-16 13:47:39','2022-11-16 13:47:39'),(2103,7768,40728,13758,11,2103,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',243886.63,'RECLA SALDOS',NULL,1,'2022-11-16 13:47:39','2022-11-24 09:54:09','2022-11-24 09:54:09'),(2104,7768,40728,13778,16,914,'App\\Models\\PeriodLiquidation',NULL,914,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',22172.03,NULL,NULL,1,'2022-11-16 14:14:39','2022-11-17 22:48:47','2022-11-17 22:48:47'),(2105,7768,40728,13760,15,917,'App\\Models\\PeriodLiquidation',NULL,917,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',215452.76,NULL,NULL,1,'2022-11-16 14:15:25','2022-11-16 14:15:25',NULL),(2106,7768,40728,13760,16,916,'App\\Models\\PeriodLiquidation',NULL,916,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',13483.10,NULL,NULL,1,'2022-11-16 14:15:30','2022-11-17 22:47:58','2022-11-17 22:47:58'),(2107,7768,41298,88857,15,908,'App\\Models\\PeriodLiquidation',NULL,908,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',21735.00,NULL,NULL,1,'2022-11-16 19:33:18','2022-11-16 19:33:18',NULL),(2108,7768,41322,90367,3,1537,'App\\Models\\Receipt',1537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',33000.00,NULL,NULL,1,'2022-11-16 19:52:56','2022-11-16 19:52:56',NULL),(2109,7768,41322,90367,3,1538,'App\\Models\\Receipt',1538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',4712.29,NULL,NULL,1,'2022-11-16 19:53:16','2022-11-16 19:53:16',NULL),(2110,7768,41322,90367,15,921,'App\\Models\\PeriodLiquidation',NULL,921,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1053.21,NULL,NULL,1,'2022-11-16 19:59:44','2022-11-16 19:59:44',NULL),(2111,7768,41322,90367,16,922,'App\\Models\\PeriodLiquidation',NULL,922,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',0.00,NULL,NULL,1,'2022-11-16 20:00:24','2022-11-16 20:00:24',NULL),(2112,7768,40728,13780,3,84,'App\\Models\\Receipt',84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',31627.89,NULL,NULL,1,'2022-11-16 20:51:18','2022-11-17 23:04:56','2022-11-17 23:04:56'),(2113,7768,40728,13782,3,1421,'App\\Models\\Receipt',1421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',35363.79,NULL,NULL,1,'2022-11-17 19:05:56','2022-11-17 22:12:43','2022-11-17 22:12:43'),(2114,7768,40728,13781,3,1348,'App\\Models\\Receipt',1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',34890.27,NULL,NULL,1,'2022-11-17 19:07:31','2022-11-17 19:07:43','2022-11-17 19:07:43'),(2115,7768,40728,13781,3,1348,'App\\Models\\Receipt',1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',33607.35,NULL,NULL,1,'2022-11-17 19:07:43','2022-11-17 23:06:39','2022-11-17 23:06:39'),(2116,7768,40728,13780,3,85,'App\\Models\\Receipt',85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',4957.38,NULL,NULL,1,'2022-11-17 19:13:03','2022-11-17 21:04:44','2022-11-17 21:04:44'),(2117,7768,40728,13780,3,85,'App\\Models\\Receipt',85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',4957.38,NULL,NULL,1,'2022-11-17 21:04:44','2022-11-17 23:05:14','2022-11-17 23:05:14'),(2118,7768,40728,13782,3,1540,'App\\Models\\Receipt',1540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',3286.20,NULL,NULL,1,'2022-11-17 21:33:02','2022-11-17 21:33:02',NULL),(2119,7768,40728,13782,3,1541,'App\\Models\\Receipt',1541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',4932.59,NULL,NULL,1,'2022-11-17 21:33:02','2022-11-17 21:33:02',NULL),(2120,7768,40728,13782,3,1542,'App\\Models\\Receipt',1542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',3455.87,NULL,NULL,1,'2022-11-17 21:33:02','2022-11-17 23:23:09','2022-11-17 23:23:09');
INSERT INTO `balance_libro` VALUES (2121,7768,40728,13782,3,1543,'App\\Models\\Receipt',1543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',3564.50,NULL,NULL,1,'2022-11-17 21:33:02','2022-11-17 21:33:02',NULL),(2122,7768,40728,13782,3,1544,'App\\Models\\Receipt',1544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',7499.95,NULL,NULL,1,'2022-11-17 21:33:02','2022-11-17 21:33:02',NULL),(2123,7768,40728,13782,3,1545,'App\\Models\\Receipt',1545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',8000.01,NULL,NULL,1,'2022-11-17 21:33:02','2022-11-17 21:33:02',NULL),(2124,7768,40728,13782,3,1546,'App\\Models\\Receipt',1546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',1603.61,NULL,NULL,1,'2022-11-17 21:33:02','2022-11-17 21:33:02',NULL),(2125,7768,40728,13782,3,1547,'App\\Models\\Receipt',1547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',2924.22,NULL,NULL,1,'2022-11-17 21:33:02','2022-11-17 21:33:02',NULL),(2126,7768,40728,13782,3,1548,'App\\Models\\Receipt',1548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',3777.26,NULL,NULL,1,'2022-11-17 21:33:03','2022-11-17 21:33:03',NULL),(2127,7768,40728,13782,3,1549,'App\\Models\\Receipt',1549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',6727.87,NULL,NULL,1,'2022-11-17 21:33:03','2022-11-17 21:33:03',NULL),(2128,7768,40728,13782,3,1550,'App\\Models\\Receipt',1550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',4044.47,NULL,NULL,1,'2022-11-17 21:33:03','2022-11-17 21:33:03',NULL),(2129,7768,40728,13782,3,1551,'App\\Models\\Receipt',1551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',6049.95,NULL,NULL,1,'2022-11-17 21:33:03','2022-11-17 21:33:03',NULL),(2130,7768,40728,13782,3,1552,'App\\Models\\Receipt',1552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',10324.59,NULL,NULL,1,'2022-11-17 21:33:03','2022-11-17 21:33:03',NULL),(2131,7768,40728,13782,3,1553,'App\\Models\\Receipt',1553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',22640.06,NULL,NULL,1,'2022-11-17 21:33:03','2022-11-17 22:16:29','2022-11-17 22:16:29'),(2132,7768,40728,13782,3,1554,'App\\Models\\Receipt',1554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',2000.00,NULL,NULL,1,'2022-11-17 21:33:03','2022-11-17 21:33:03',NULL),(2133,7768,40728,13782,3,1555,'App\\Models\\Receipt',1555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',59579.31,NULL,NULL,1,'2022-11-17 21:33:03','2022-11-17 22:16:02','2022-11-17 22:16:02'),(2134,7768,40728,13782,3,1421,'App\\Models\\Receipt',1421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',35363.79,NULL,NULL,1,'2022-11-17 22:12:43','2022-11-17 23:08:19','2022-11-17 23:08:19'),(2135,7768,40728,13782,3,1556,'App\\Models\\Receipt',1556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',2866.54,NULL,NULL,1,'2022-11-17 22:14:19','2022-11-17 22:14:19',NULL),(2136,7768,40728,13782,3,1555,'App\\Models\\Receipt',1555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',59579.31,NULL,NULL,1,'2022-11-17 22:16:02','2022-11-17 22:16:02',NULL),(2137,7768,40728,13782,3,1553,'App\\Models\\Receipt',1553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',22640.06,NULL,NULL,1,'2022-11-17 22:16:29','2022-11-17 22:16:29',NULL),(2138,7768,40728,13782,3,1427,'App\\Models\\Receipt',1427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',4766.90,NULL,NULL,1,'2022-11-17 22:21:03','2022-11-17 22:21:03',NULL),(2139,7768,40728,13782,3,1432,'App\\Models\\Receipt',1432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',3852.47,NULL,NULL,1,'2022-11-17 22:21:32','2022-11-17 22:21:32',NULL),(2140,7768,40728,13758,16,178,'App\\Models\\PeriodLiquidation',NULL,178,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',0.00,NULL,NULL,1,'2022-11-17 22:49:30','2022-11-17 22:49:30',NULL);
INSERT INTO `balance_libro` VALUES (2141,7768,40728,13759,16,951,'App\\Models\\PeriodLiquidation',NULL,951,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',11219.64,NULL,NULL,1,'2022-11-17 22:50:45','2022-11-17 22:50:45',NULL),(2142,7768,40728,13760,16,952,'App\\Models\\PeriodLiquidation',NULL,952,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',13597.29,NULL,NULL,1,'2022-11-17 22:51:19','2022-11-17 22:51:19',NULL),(2143,7768,40728,13761,16,953,'App\\Models\\PeriodLiquidation',NULL,953,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',10504.91,NULL,NULL,1,'2022-11-17 22:51:43','2022-11-17 22:51:43',NULL),(2144,7768,40728,13762,16,954,'App\\Models\\PeriodLiquidation',NULL,954,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',18745.07,NULL,NULL,1,'2022-11-17 22:52:04','2022-11-17 23:01:52','2022-11-17 23:01:52'),(2145,7768,40728,13763,16,955,'App\\Models\\PeriodLiquidation',NULL,955,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',24454.97,NULL,NULL,1,'2022-11-17 22:52:32','2022-11-17 22:52:32',NULL),(2146,7768,40728,13764,16,956,'App\\Models\\PeriodLiquidation',NULL,956,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',17737.76,NULL,NULL,1,'2022-11-17 22:53:21','2022-11-17 23:02:08','2022-11-17 23:02:08'),(2147,7768,40728,13765,16,957,'App\\Models\\PeriodLiquidation',NULL,957,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',20803.01,NULL,NULL,1,'2022-11-17 22:53:44','2022-11-17 22:53:44',NULL),(2148,7768,40728,13766,16,958,'App\\Models\\PeriodLiquidation',NULL,958,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',14269.25,NULL,NULL,1,'2022-11-17 22:54:14','2022-11-17 23:02:29','2022-11-17 23:02:29'),(2149,7768,40728,13773,16,959,'App\\Models\\PeriodLiquidation',NULL,959,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',27452.79,NULL,NULL,1,'2022-11-17 22:54:49','2022-11-17 22:54:49',NULL),(2150,7768,40728,13774,16,960,'App\\Models\\PeriodLiquidation',NULL,960,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',23139.36,NULL,NULL,1,'2022-11-17 22:55:14','2022-11-17 23:02:46','2022-11-17 23:02:46'),(2151,7768,40728,13775,16,961,'App\\Models\\PeriodLiquidation',NULL,961,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',23478.31,NULL,NULL,1,'2022-11-17 22:55:31','2022-11-17 22:55:31',NULL),(2152,7768,40728,13776,16,964,'App\\Models\\PeriodLiquidation',NULL,964,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',27249.07,NULL,NULL,1,'2022-11-17 23:01:52','2022-11-17 23:01:52',NULL),(2153,7768,40728,13777,16,965,'App\\Models\\PeriodLiquidation',NULL,965,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',26026.32,NULL,NULL,1,'2022-11-17 23:02:08','2022-11-17 23:02:08',NULL),(2154,7768,40728,13778,16,966,'App\\Models\\PeriodLiquidation',NULL,966,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',23091.78,NULL,NULL,1,'2022-11-17 23:02:29','2023-04-25 19:22:25','2023-04-25 19:22:25'),(2155,7768,40728,13779,16,967,'App\\Models\\PeriodLiquidation',NULL,967,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',25079.57,NULL,NULL,1,'2022-11-17 23:02:46','2023-04-25 19:46:52','2023-04-25 19:46:52'),(2156,7768,40728,13780,3,84,'App\\Models\\Receipt',84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',31627.89,NULL,NULL,1,'2022-11-17 23:04:56','2022-11-17 23:04:56',NULL),(2157,7768,40728,13780,3,85,'App\\Models\\Receipt',85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',4957.38,NULL,NULL,1,'2022-11-17 23:05:14','2022-11-17 23:05:14',NULL),(2158,7768,40728,13780,16,974,'App\\Models\\PeriodLiquidation',NULL,974,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',29318.05,NULL,NULL,1,'2022-11-17 23:05:33','2022-11-17 23:07:03','2022-11-17 23:07:03'),(2159,7768,40728,13781,3,1348,'App\\Models\\Receipt',1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',33607.35,NULL,NULL,1,'2022-11-17 23:06:39','2022-11-17 23:06:39',NULL);
INSERT INTO `balance_libro` VALUES (2160,7768,40728,13781,16,977,'App\\Models\\PeriodLiquidation',NULL,977,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',30651.49,NULL,NULL,1,'2022-11-17 23:07:03','2022-11-17 23:07:03',NULL),(2161,7768,40728,13782,3,1421,'App\\Models\\Receipt',1421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',35363.79,NULL,NULL,1,'2022-11-17 23:08:19','2022-11-17 23:08:19',NULL),(2162,7768,40728,13782,3,1542,'App\\Models\\Receipt',1542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',3328.45,NULL,NULL,1,'2022-11-17 23:23:09','2022-11-17 23:23:09',NULL),(2163,7768,40728,13782,3,1433,'App\\Models\\Receipt',1433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',53595.90,NULL,NULL,1,'2022-11-17 23:28:53','2022-11-17 23:28:53',NULL),(2164,7768,40728,13782,16,988,'App\\Models\\PeriodLiquidation',NULL,988,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',33060.28,NULL,NULL,1,'2022-11-17 23:56:20','2022-11-17 23:56:20',NULL),(2165,7768,40728,13761,15,899,'App\\Models\\PeriodLiquidation',NULL,899,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',130455.50,NULL,NULL,1,'2022-11-24 09:39:44','2022-11-24 09:39:44',NULL),(2166,7768,40728,13765,15,910,'App\\Models\\PeriodLiquidation',NULL,910,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',168264.21,NULL,NULL,1,'2022-11-24 09:42:26','2022-11-24 09:42:26',NULL),(2167,7768,40728,13762,16,954,'App\\Models\\PeriodLiquidation',NULL,954,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',18745.07,NULL,NULL,1,'2022-11-24 10:05:45','2022-11-24 10:05:45',NULL),(2168,7768,40728,13764,16,956,'App\\Models\\PeriodLiquidation',NULL,956,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',17737.76,NULL,NULL,1,'2022-11-24 10:06:09','2022-11-24 10:06:09',NULL),(2169,7768,40728,13766,16,958,'App\\Models\\PeriodLiquidation',NULL,958,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',14269.25,NULL,NULL,1,'2022-11-24 10:06:30','2022-11-24 10:06:30',NULL),(2170,7768,40728,13774,16,960,'App\\Models\\PeriodLiquidation',NULL,960,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',23139.36,NULL,NULL,1,'2022-11-24 10:10:53','2022-11-24 10:10:53',NULL),(2171,7768,40728,13775,10,2171,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',1665.56,'PAGO INTERESES BP-ACCIONES O PARTICIPACIONES',NULL,1,'2022-11-24 10:44:07','2022-11-24 10:44:21','2022-11-24 10:44:21'),(2172,7768,40728,13775,10,2172,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',1665.56,'PAGO INTERESES BP-ACCIONES O PARTICIPACIONES',NULL,1,'2022-11-24 10:44:21','2022-11-24 10:44:21',NULL),(2173,7768,40728,13775,10,2173,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',2500.00,'PAGO IIBB CM',NULL,1,'2022-11-24 10:49:33','2022-11-24 10:49:33',NULL),(2174,7768,40728,13783,2,1557,'App\\Models\\Receipt',1557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',144036.60,NULL,NULL,1,'2022-11-25 10:21:03','2022-11-25 10:21:03',NULL),(2175,7768,40728,13783,2,1558,'App\\Models\\Receipt',1558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',954068.83,NULL,NULL,1,'2022-11-25 10:21:04','2022-11-25 10:21:04',NULL),(2176,7768,40728,13783,2,1559,'App\\Models\\Receipt',1559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',144364.23,NULL,NULL,1,'2022-11-25 10:21:04','2022-11-25 10:21:04',NULL),(2177,7768,40728,13783,2,1560,'App\\Models\\Receipt',1560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',144036.60,NULL,NULL,1,'2022-11-25 10:21:04','2022-11-25 10:21:04',NULL),(2178,7768,40728,13783,2,1561,'App\\Models\\Receipt',1561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',168833.14,NULL,NULL,1,'2022-11-25 10:21:04','2022-11-25 10:21:04',NULL);
INSERT INTO `balance_libro` VALUES (2179,7768,40728,13783,2,1562,'App\\Models\\Receipt',1562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',828377.48,NULL,NULL,1,'2022-11-25 10:21:04','2022-11-25 10:21:04',NULL),(2180,7768,40728,13783,2,1563,'App\\Models\\Receipt',1563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',101674.53,NULL,NULL,1,'2022-11-25 10:21:04','2022-11-25 10:21:04',NULL),(2181,7768,40728,13783,3,1564,'App\\Models\\Receipt',1564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',11495.00,NULL,NULL,1,'2022-11-25 10:21:16','2022-11-25 10:21:16',NULL),(2182,7768,40728,13783,3,1565,'App\\Models\\Receipt',1565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',25373.35,NULL,NULL,1,'2022-11-25 10:21:16','2022-11-25 10:21:16',NULL),(2183,7768,40728,13783,3,1566,'App\\Models\\Receipt',1566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',274193.24,NULL,NULL,1,'2022-11-25 10:21:16','2022-12-19 22:31:35','2022-12-19 22:31:35'),(2184,7768,40728,13783,3,1567,'App\\Models\\Receipt',1567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',21500.00,NULL,NULL,1,'2022-11-25 10:21:16','2022-11-25 10:21:16',NULL),(2185,7768,40728,13783,3,1568,'App\\Models\\Receipt',1568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',9500.00,NULL,NULL,1,'2022-11-25 10:21:16','2022-11-25 10:21:16',NULL),(2186,7768,40728,13783,3,1569,'App\\Models\\Receipt',1569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',720.19,NULL,NULL,1,'2022-11-25 10:21:16','2022-11-25 10:21:16',NULL),(2187,7768,40728,13783,3,1570,'App\\Models\\Receipt',1570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',7265.08,NULL,NULL,1,'2022-11-25 10:21:16','2022-12-19 22:31:58','2022-12-19 22:31:58'),(2188,7768,40728,13783,3,1571,'App\\Models\\Receipt',1571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',74531.99,NULL,NULL,1,'2022-11-25 10:21:16','2022-11-25 10:21:16',NULL),(2189,7768,40728,13783,3,1572,'App\\Models\\Receipt',1572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',1452.00,NULL,NULL,1,'2022-11-25 10:21:16','2022-11-25 10:21:16',NULL),(2190,7768,40728,13783,3,1573,'App\\Models\\Receipt',1573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',800.00,NULL,NULL,1,'2022-11-25 10:21:16','2022-11-25 10:21:16',NULL),(2191,7768,40728,13783,3,1574,'App\\Models\\Receipt',1574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',35813.89,NULL,NULL,1,'2022-11-25 10:21:16','2022-11-25 10:21:16',NULL),(2192,7768,40728,13783,3,1575,'App\\Models\\Receipt',1575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',5088.96,NULL,NULL,1,'2022-11-25 10:21:16','2022-12-19 22:32:39','2022-12-19 22:32:39'),(2193,7768,40728,13783,3,1576,'App\\Models\\Receipt',1576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',41232.29,NULL,NULL,1,'2022-11-25 10:21:16','2022-12-19 22:33:12','2022-12-19 22:33:12'),(2194,7768,40728,13783,3,1577,'App\\Models\\Receipt',1577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',360.14,NULL,NULL,1,'2022-11-25 10:21:16','2022-11-25 10:21:16',NULL),(2195,7768,40728,13783,3,1578,'App\\Models\\Receipt',1578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',606816.33,NULL,NULL,1,'2022-11-25 10:21:16','2022-12-19 22:34:30','2022-12-19 22:34:30'),(2196,7768,40728,13783,3,1579,'App\\Models\\Receipt',1579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',668.60,NULL,NULL,1,'2022-11-25 10:21:17','2022-11-25 10:21:17',NULL),(2197,7768,40728,13783,3,1580,'App\\Models\\Receipt',1580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',22680.01,NULL,NULL,1,'2022-11-25 10:21:17','2022-11-25 10:21:17',NULL),(2198,7768,40728,13783,3,1581,'App\\Models\\Receipt',1581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',68281.53,NULL,NULL,1,'2022-11-25 10:21:17','2022-11-25 10:21:17',NULL);
INSERT INTO `balance_libro` VALUES (2199,7768,40728,13783,3,1582,'App\\Models\\Receipt',1582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',784.74,NULL,NULL,1,'2022-11-25 10:21:17','2022-12-19 22:35:46','2022-12-19 22:35:46'),(2200,7768,40728,13783,3,1583,'App\\Models\\Receipt',1583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',17138.42,NULL,NULL,1,'2022-11-25 10:21:17','2022-12-19 22:35:09','2022-12-19 22:35:09'),(2201,7768,40728,13783,3,1584,'App\\Models\\Receipt',1584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',2435.49,NULL,NULL,1,'2022-11-25 10:21:17','2022-11-25 10:21:17',NULL),(2202,7768,40728,13783,3,1585,'App\\Models\\Receipt',1585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',3735.44,NULL,NULL,1,'2022-11-25 10:21:17','2022-11-25 10:21:17',NULL),(2203,7768,40728,13783,3,1586,'App\\Models\\Receipt',1586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',47674.00,NULL,NULL,1,'2022-11-25 10:21:17','2022-11-25 10:21:17',NULL),(2204,7768,40728,13783,3,1587,'App\\Models\\Receipt',1587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',119673.09,NULL,NULL,1,'2022-11-25 10:21:17','2022-11-25 10:21:17',NULL),(2205,7768,40728,13783,3,1588,'App\\Models\\Receipt',1588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',3660.59,NULL,NULL,1,'2022-11-25 10:21:17','2022-11-25 10:21:17',NULL),(2206,7768,40728,13783,3,1589,'App\\Models\\Receipt',1589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',1006.72,NULL,NULL,1,'2022-11-25 10:21:17','2022-11-25 10:21:17',NULL),(2207,7768,40728,13783,3,1590,'App\\Models\\Receipt',1590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',4679.97,NULL,NULL,1,'2022-11-25 10:21:17','2022-11-25 10:21:17',NULL),(2208,7768,40728,13783,3,1591,'App\\Models\\Receipt',1591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',4600.00,NULL,NULL,1,'2022-11-25 10:21:17','2022-11-25 10:21:17',NULL),(2209,7768,40728,13783,3,1592,'App\\Models\\Receipt',1592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',4680.00,NULL,NULL,1,'2022-11-25 10:21:17','2022-11-25 10:21:17',NULL),(2210,7768,41298,88858,2,1593,'App\\Models\\Receipt',1593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',39325.00,NULL,NULL,1,'2022-11-25 10:27:01','2022-11-25 10:27:01',NULL),(2211,7768,41298,88858,2,1594,'App\\Models\\Receipt',1594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',125235.00,NULL,NULL,1,'2022-11-25 10:27:01','2022-11-25 10:27:01',NULL),(2212,7768,41298,88858,3,1595,'App\\Models\\Receipt',1595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',106900.00,NULL,NULL,1,'2022-11-25 10:27:13','2022-12-15 10:47:56','2022-12-15 10:47:56'),(2213,7768,41298,88858,3,1596,'App\\Models\\Receipt',1596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',11348.00,NULL,NULL,1,'2022-11-25 10:27:13','2022-11-25 10:27:13',NULL),(2214,7768,41298,88858,3,1597,'App\\Models\\Receipt',1597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-13','2022-11-13',6451.40,NULL,NULL,1,'2022-11-25 10:27:13','2022-11-25 10:27:13',NULL),(2215,7768,41298,88858,3,1598,'App\\Models\\Receipt',1598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',2967.50,NULL,NULL,1,'2022-11-25 10:27:13','2022-11-25 10:27:13',NULL),(2216,7768,41298,88858,3,1599,'App\\Models\\Receipt',1599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',11599.00,NULL,NULL,1,'2022-11-25 10:27:13','2022-12-15 10:48:43','2022-12-15 10:48:43'),(2217,7768,41298,88858,3,1600,'App\\Models\\Receipt',1600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',48000.00,NULL,NULL,1,'2022-11-25 10:27:13','2022-11-25 10:27:13',NULL),(2218,7768,41298,88858,3,1601,'App\\Models\\Receipt',1601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',69333.22,NULL,NULL,1,'2022-11-25 10:27:13','2022-11-25 10:27:13',NULL);
INSERT INTO `balance_libro` VALUES (2219,7768,41298,88858,3,1602,'App\\Models\\Receipt',1602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',69333.22,NULL,NULL,1,'2022-11-25 10:27:13','2022-12-15 10:47:42','2022-12-15 10:47:42'),(2220,7768,41298,88858,3,1603,'App\\Models\\Receipt',1603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',69333.22,NULL,NULL,1,'2022-11-25 10:27:13','2022-12-15 10:47:36','2022-12-15 10:47:36'),(2221,7768,41298,88858,3,1604,'App\\Models\\Receipt',1604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',4819.60,NULL,NULL,1,'2022-11-25 10:27:13','2022-12-19 15:11:04','2022-12-19 15:11:04'),(2222,7768,41322,90368,2,1605,'App\\Models\\Receipt',1605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',205700.00,NULL,NULL,1,'2022-11-25 10:37:59','2022-11-25 10:37:59',NULL),(2223,7768,41322,90368,3,1606,'App\\Models\\Receipt',1606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',12500.00,NULL,NULL,1,'2022-11-25 10:38:07','2022-11-25 10:38:07',NULL),(2224,7768,41322,90368,3,1607,'App\\Models\\Receipt',1607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',4540.49,NULL,NULL,1,'2022-11-25 10:38:07','2022-12-19 12:07:14','2022-12-19 12:07:14'),(2225,7768,41322,90368,3,1608,'App\\Models\\Receipt',1608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',2004.99,NULL,NULL,1,'2022-11-25 10:38:07','2022-11-25 10:38:07',NULL),(2226,7768,41322,90368,3,1609,'App\\Models\\Receipt',1609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',4366.91,NULL,NULL,1,'2022-11-25 10:38:07','2022-12-19 12:08:26','2022-12-19 12:08:26'),(2227,7768,40728,13783,7,1610,'App\\Models\\Receipt',1610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',1920.00,NULL,NULL,1,'2022-11-28 12:37:03','2022-11-28 12:37:03',NULL),(2228,7768,40728,13783,7,1611,'App\\Models\\Receipt',1611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',2880.00,NULL,NULL,1,'2022-11-28 12:38:14','2022-11-28 12:38:14',NULL),(2229,7768,40728,13783,7,1612,'App\\Models\\Receipt',1612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',53760.00,NULL,NULL,1,'2022-11-28 12:38:44','2022-11-28 12:38:44',NULL),(2230,7768,40728,13783,7,1613,'App\\Models\\Receipt',1613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',3200.00,NULL,NULL,1,'2022-11-28 12:39:17','2022-11-28 12:39:17',NULL),(2231,7768,40728,13783,3,1614,'App\\Models\\Receipt',1614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',48552.00,NULL,NULL,1,'2022-11-28 12:44:01','2022-11-28 12:44:01',NULL),(2232,7768,40728,13783,3,1615,'App\\Models\\Receipt',1615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',29400.00,NULL,NULL,1,'2022-11-28 12:44:01','2022-11-28 12:44:01',NULL),(2233,7768,41298,88858,2,1616,'App\\Models\\Receipt',1616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',96800.00,NULL,NULL,1,'2022-12-15 11:03:59','2022-12-15 11:03:59',NULL),(2234,7768,40728,13783,2,1617,'App\\Models\\Receipt',1617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',20413.62,NULL,NULL,1,'2022-12-16 00:22:08','2022-12-16 00:22:08',NULL),(2235,7768,40728,13783,2,1618,'App\\Models\\Receipt',1618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',560036.40,NULL,NULL,1,'2022-12-16 00:22:08','2022-12-16 00:22:08',NULL),(2236,7768,40728,13783,2,1619,'App\\Models\\Receipt',1619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',560036.40,NULL,NULL,1,'2022-12-16 00:22:08','2022-12-16 00:22:08',NULL),(2237,7768,40728,13783,3,1620,'App\\Models\\Receipt',1620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',8219.54,NULL,NULL,1,'2022-12-16 00:22:17','2022-12-19 20:34:32','2022-12-19 20:34:32'),(2238,7768,40728,13783,3,1621,'App\\Models\\Receipt',1621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',11300.46,NULL,NULL,1,'2022-12-16 00:22:17','2022-12-19 20:34:07','2022-12-19 20:34:07');
INSERT INTO `balance_libro` VALUES (2239,7768,40728,13783,3,1622,'App\\Models\\Receipt',1622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',63748.65,NULL,NULL,1,'2022-12-16 00:22:17','2022-12-19 22:34:03','2022-12-19 22:34:03'),(2240,7768,40728,13783,3,1623,'App\\Models\\Receipt',1623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',11377.15,NULL,NULL,1,'2022-12-16 00:22:17','2022-12-16 00:22:17',NULL),(2241,7768,40728,13783,3,1624,'App\\Models\\Receipt',1624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',4365.09,NULL,NULL,1,'2022-12-16 00:22:18','2022-12-19 22:36:22','2022-12-19 22:36:22'),(2242,7768,41322,90368,2,1625,'App\\Models\\Receipt',1625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',261360.00,NULL,NULL,1,'2022-12-17 16:24:08','2022-12-17 16:36:01','2022-12-17 16:36:01'),(2243,7768,41322,90368,3,1626,'App\\Models\\Receipt',1626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',6745.00,NULL,NULL,1,'2022-12-17 16:25:49','2022-12-17 16:25:49',NULL),(2244,7768,41322,90368,2,1625,'App\\Models\\Receipt',1625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',216000.00,NULL,NULL,1,'2022-12-17 16:36:01','2022-12-17 16:37:27','2022-12-17 16:37:27'),(2245,7768,41322,90368,2,1625,'App\\Models\\Receipt',1625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',261360.00,NULL,NULL,1,'2022-12-17 16:37:27','2022-12-17 16:37:27',NULL),(2246,7768,41322,90368,3,1627,'App\\Models\\Receipt',1627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',11691.58,NULL,NULL,1,'2022-12-19 11:27:11','2022-12-19 11:27:11',NULL),(2247,7768,41322,90368,3,1607,'App\\Models\\Receipt',1607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',4540.49,NULL,NULL,1,'2022-12-19 12:07:14','2022-12-19 12:07:14',NULL),(2248,7768,41322,90368,3,1609,'App\\Models\\Receipt',1609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',4366.91,NULL,NULL,1,'2022-12-19 12:08:26','2022-12-19 12:08:26',NULL),(2249,7768,41322,90368,15,1037,'App\\Models\\PeriodLiquidation',NULL,1037,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',82009.28,NULL,NULL,1,'2022-12-19 13:14:39','2022-12-19 13:14:39',NULL),(2250,7768,41322,90368,16,1038,'App\\Models\\PeriodLiquidation',NULL,1038,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',753.53,NULL,NULL,1,'2022-12-19 13:14:41','2022-12-19 13:14:41',NULL),(2251,7768,41298,88858,3,1628,'App\\Models\\Receipt',1628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-06','2022-11-06',6452.72,NULL,NULL,1,'2022-12-19 13:20:11','2022-12-19 13:20:11',NULL),(2252,7768,41298,88858,3,1629,'App\\Models\\Receipt',1629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-20','2022-11-20',6175.27,NULL,NULL,1,'2022-12-19 13:20:11','2022-12-19 13:20:11',NULL),(2253,7768,41298,88858,3,1630,'App\\Models\\Receipt',1630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',2100.00,NULL,NULL,1,'2022-12-19 13:20:11','2022-12-19 13:20:11',NULL),(2254,7768,41298,88858,3,1631,'App\\Models\\Receipt',1631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',7030.57,NULL,NULL,1,'2022-12-19 13:20:11','2022-12-19 13:20:11',NULL),(2255,7768,41298,88858,3,1604,'App\\Models\\Receipt',1604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',4819.00,NULL,NULL,1,'2022-12-19 15:11:04','2022-12-19 15:14:44','2022-12-19 15:14:44'),(2256,7768,41298,88858,3,1604,'App\\Models\\Receipt',1604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',4819.60,NULL,NULL,1,'2022-12-19 15:14:44','2022-12-19 15:14:44',NULL),(2257,7768,41298,88858,15,1043,'App\\Models\\PeriodLiquidation',NULL,1043,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',45360.00,NULL,NULL,1,'2022-12-19 15:16:46','2022-12-19 15:16:46',NULL),(2258,7768,40728,13783,3,1632,'App\\Models\\Receipt',1632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',5200.49,NULL,NULL,1,'2022-12-19 20:10:20','2022-12-19 20:10:20',NULL);
INSERT INTO `balance_libro` VALUES (2259,7768,40728,13783,3,1633,'App\\Models\\Receipt',1633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',106708.63,NULL,NULL,1,'2022-12-19 20:10:20','2022-12-19 20:10:20',NULL),(2260,7768,40728,13783,7,1634,'App\\Models\\Receipt',1634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',12912.54,NULL,NULL,1,'2022-12-19 20:19:52','2022-12-19 20:19:52',NULL),(2261,7768,40728,13783,3,1635,'App\\Models\\Receipt',1635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',75638.11,NULL,NULL,1,'2022-12-19 20:32:03','2022-12-19 20:37:19','2022-12-19 20:37:19'),(2262,7768,40728,13783,3,1621,'App\\Models\\Receipt',1621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',11300.46,NULL,NULL,1,'2022-12-19 20:34:07','2022-12-19 20:34:07',NULL),(2263,7768,40728,13783,3,1620,'App\\Models\\Receipt',1620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',8219.52,NULL,NULL,1,'2022-12-19 20:34:32','2022-12-19 20:34:32',NULL),(2264,7768,40728,13783,3,1635,'App\\Models\\Receipt',1635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',75638.11,NULL,NULL,1,'2022-12-19 20:37:19','2022-12-19 20:38:23','2022-12-19 20:38:23'),(2265,7768,40728,13783,3,1635,'App\\Models\\Receipt',1635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',75638.11,NULL,NULL,1,'2022-12-19 20:38:23','2022-12-19 20:39:12','2022-12-19 20:39:12'),(2266,7768,40728,13783,3,1635,'App\\Models\\Receipt',1635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',75638.11,NULL,NULL,1,'2022-12-19 20:39:12','2022-12-19 20:41:50','2022-12-19 20:41:50'),(2267,7768,40728,13783,3,1636,'App\\Models\\Receipt',1636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',75638.11,NULL,NULL,1,'2022-12-19 20:42:53','2022-12-19 20:45:01','2022-12-19 20:45:01'),(2268,7768,40728,13783,3,1636,'App\\Models\\Receipt',1636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',75638.11,NULL,NULL,1,'2022-12-19 20:45:01','2022-12-19 20:46:36','2022-12-19 20:46:36'),(2269,7768,40728,13783,3,1636,'App\\Models\\Receipt',1636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',75638.11,NULL,NULL,1,'2022-12-19 20:46:36','2022-12-19 20:47:10','2022-12-19 20:47:10'),(2270,7768,40728,13784,3,1636,'App\\Models\\Receipt',1636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',75638.11,NULL,NULL,1,'2022-12-19 20:47:10','2022-12-19 20:53:34','2022-12-19 20:53:34'),(2271,7768,40728,13783,3,1636,'App\\Models\\Receipt',1636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',75638.11,NULL,NULL,1,'2022-12-19 20:53:34','2022-12-19 20:53:34',NULL),(2272,7768,40728,13783,3,1566,'App\\Models\\Receipt',1566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',274193.14,NULL,NULL,1,'2022-12-19 22:31:35','2022-12-19 22:31:35',NULL),(2273,7768,40728,13783,3,1570,'App\\Models\\Receipt',1570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',7265.08,NULL,NULL,1,'2022-12-19 22:31:58','2022-12-19 22:31:58',NULL),(2274,7768,40728,13783,3,1575,'App\\Models\\Receipt',1575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',5088.96,NULL,NULL,1,'2022-12-19 22:32:39','2022-12-19 22:32:39',NULL),(2275,7768,40728,13783,3,1576,'App\\Models\\Receipt',1576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',41232.29,NULL,NULL,1,'2022-12-19 22:33:12','2022-12-19 22:33:12',NULL),(2276,7768,40728,13783,3,1622,'App\\Models\\Receipt',1622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',63748.65,NULL,NULL,1,'2022-12-19 22:34:03','2022-12-19 22:34:03',NULL),(2277,7768,40728,13783,3,1578,'App\\Models\\Receipt',1578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',606816.34,NULL,NULL,1,'2022-12-19 22:34:30','2022-12-19 22:34:30',NULL),(2278,7768,40728,13783,3,1583,'App\\Models\\Receipt',1583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',17138.42,NULL,NULL,1,'2022-12-19 22:35:09','2022-12-19 22:35:09',NULL);
INSERT INTO `balance_libro` VALUES (2279,7768,40728,13783,3,1582,'App\\Models\\Receipt',1582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',784.74,NULL,NULL,1,'2022-12-19 22:35:46','2022-12-19 22:35:46',NULL),(2280,7768,40728,13783,3,1624,'App\\Models\\Receipt',1624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',4365.08,NULL,NULL,1,'2022-12-19 22:36:22','2022-12-19 22:36:22',NULL),(2281,7768,40728,13783,7,1637,'App\\Models\\Receipt',1637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',691.74,NULL,NULL,1,'2022-12-19 22:40:47','2022-12-19 22:40:47',NULL),(2282,7768,40728,13783,16,1100,'App\\Models\\PeriodLiquidation',NULL,1100,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',86086.79,NULL,NULL,1,'2022-12-19 22:42:32','2022-12-19 22:42:32',NULL),(2283,7768,40728,13784,2,1638,'App\\Models\\Receipt',1638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',560036.40,NULL,NULL,1,'2022-12-29 08:41:25','2022-12-29 08:41:25',NULL),(2284,7768,40728,13784,2,1639,'App\\Models\\Receipt',1639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',398373.85,NULL,NULL,1,'2022-12-29 08:41:26','2022-12-29 08:41:26',NULL),(2285,7768,40728,13784,2,1640,'App\\Models\\Receipt',1640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',255416.48,NULL,NULL,1,'2022-12-29 08:41:26','2022-12-29 08:41:26',NULL),(2286,7768,40728,13784,2,1641,'App\\Models\\Receipt',1641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',11424.13,NULL,NULL,1,'2022-12-29 08:41:26','2022-12-29 08:41:26',NULL),(2287,7768,40728,13784,2,1642,'App\\Models\\Receipt',1642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',6346.11,NULL,NULL,1,'2022-12-29 08:41:26','2022-12-29 08:41:26',NULL),(2288,7768,40728,13784,2,1643,'App\\Models\\Receipt',1643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',106744.24,NULL,NULL,1,'2022-12-29 08:41:26','2022-12-29 08:41:26',NULL),(2289,7768,40728,13784,3,1644,'App\\Models\\Receipt',1644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',55437.36,NULL,NULL,1,'2022-12-29 08:41:57','2022-12-29 08:41:57',NULL),(2290,7768,40728,13784,3,1645,'App\\Models\\Receipt',1645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',11495.00,NULL,NULL,1,'2022-12-29 08:41:57','2022-12-29 08:41:57',NULL),(2291,7768,40728,13784,3,1646,'App\\Models\\Receipt',1646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',3531.47,NULL,NULL,1,'2022-12-29 08:41:57','2022-12-29 08:41:57',NULL),(2292,7768,40728,13784,3,1647,'App\\Models\\Receipt',1647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',54208.00,NULL,NULL,1,'2022-12-29 08:41:57','2022-12-29 08:41:57',NULL),(2293,7768,40728,13784,3,1648,'App\\Models\\Receipt',1648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',3630.00,NULL,NULL,1,'2022-12-29 08:41:57','2022-12-29 08:41:57',NULL),(2294,7768,40728,13784,3,1649,'App\\Models\\Receipt',1649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',1774.92,NULL,NULL,1,'2022-12-29 08:41:57','2022-12-29 08:41:57',NULL),(2295,7768,40728,13784,3,1650,'App\\Models\\Receipt',1650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',1006.72,NULL,NULL,1,'2022-12-29 08:41:57','2022-12-29 08:41:57',NULL),(2296,7768,40728,13784,3,1651,'App\\Models\\Receipt',1651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',6795.12,NULL,NULL,1,'2022-12-29 08:41:57','2023-01-16 20:13:37','2023-01-16 20:13:37'),(2297,7768,40728,13784,3,1652,'App\\Models\\Receipt',1652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',13396.82,NULL,NULL,1,'2022-12-29 08:41:57','2023-01-16 20:13:32','2023-01-16 20:13:32'),(2298,7768,40728,13784,3,1653,'App\\Models\\Receipt',1653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',9156.10,NULL,NULL,1,'2022-12-29 08:41:57','2023-01-16 20:13:26','2023-01-16 20:13:26');
INSERT INTO `balance_libro` VALUES (2299,7768,40728,13784,3,1654,'App\\Models\\Receipt',1654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',5805.60,NULL,NULL,1,'2022-12-29 08:41:57','2023-01-16 20:13:19','2023-01-16 20:13:19'),(2300,7768,40728,13784,3,1655,'App\\Models\\Receipt',1655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',9445.24,NULL,NULL,1,'2022-12-29 08:41:57','2023-01-16 20:13:13','2023-01-16 20:13:13'),(2301,7768,40728,13784,3,1656,'App\\Models\\Receipt',1656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',6105.76,NULL,NULL,1,'2022-12-29 08:41:57','2023-01-16 20:13:06','2023-01-16 20:13:06'),(2302,7768,40728,13784,3,1657,'App\\Models\\Receipt',1657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',9734.38,NULL,NULL,1,'2022-12-29 08:41:57','2023-01-16 20:12:56','2023-01-16 20:12:56'),(2303,7768,40728,13784,3,1658,'App\\Models\\Receipt',1658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',7287.52,NULL,NULL,1,'2022-12-29 08:41:57','2023-01-16 20:12:47','2023-01-16 20:12:47'),(2304,7768,40728,13784,3,1659,'App\\Models\\Receipt',1659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',10312.66,NULL,NULL,1,'2022-12-29 08:41:57','2023-01-16 20:12:38','2023-01-16 20:12:38'),(2305,7768,40728,13784,3,1660,'App\\Models\\Receipt',1660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',8368.53,NULL,NULL,1,'2022-12-29 08:41:57','2023-01-16 20:12:31','2023-01-16 20:12:31'),(2306,7768,40728,13784,3,1661,'App\\Models\\Receipt',1661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',11565.60,NULL,NULL,1,'2022-12-29 08:41:57','2023-01-16 20:12:25','2023-01-16 20:12:25'),(2307,7768,40728,13784,3,1662,'App\\Models\\Receipt',1662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',9156.10,NULL,NULL,1,'2022-12-29 08:41:58','2023-01-16 20:12:15','2023-01-16 20:12:15'),(2308,7768,40728,13784,3,1663,'App\\Models\\Receipt',1663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',15000.00,NULL,NULL,1,'2022-12-29 08:41:58','2022-12-29 08:41:58',NULL),(2309,7768,40728,13784,3,1664,'App\\Models\\Receipt',1664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',7426.21,NULL,NULL,1,'2022-12-29 08:41:58','2023-01-16 20:38:59','2023-01-16 20:38:59'),(2310,7768,40728,13784,3,1665,'App\\Models\\Receipt',1665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',1277.13,NULL,NULL,1,'2022-12-29 08:41:58','2022-12-29 08:41:58',NULL),(2311,7768,40728,13784,3,1666,'App\\Models\\Receipt',1666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',179295.15,NULL,NULL,1,'2022-12-29 08:41:58','2022-12-29 08:41:58',NULL),(2312,7768,40728,13784,3,1667,'App\\Models\\Receipt',1667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',16601.20,NULL,NULL,1,'2022-12-29 08:41:58','2022-12-29 08:41:58',NULL),(2313,7768,40728,13784,3,1668,'App\\Models\\Receipt',1668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',88572.00,NULL,NULL,1,'2022-12-29 08:41:58','2022-12-29 08:41:58',NULL),(2314,7768,40728,13784,3,1669,'App\\Models\\Receipt',1669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',349065.33,NULL,NULL,1,'2022-12-29 08:41:58','2022-12-29 08:41:58',NULL),(2315,7768,40728,13784,3,1670,'App\\Models\\Receipt',1670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',4500.00,NULL,NULL,1,'2022-12-29 08:41:58','2022-12-29 08:41:58',NULL),(2316,7768,40728,13784,3,1671,'App\\Models\\Receipt',1671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',2400.00,NULL,NULL,1,'2022-12-29 08:41:58','2022-12-29 08:41:58',NULL),(2317,7768,40728,13784,3,1672,'App\\Models\\Receipt',1672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',6476.71,NULL,NULL,1,'2022-12-29 08:41:58','2023-01-16 20:40:13','2023-01-16 20:40:13'),(2318,7768,40728,13784,3,1673,'App\\Models\\Receipt',1673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',16284.62,NULL,NULL,1,'2022-12-29 08:41:58','2022-12-29 08:41:58',NULL);
INSERT INTO `balance_libro` VALUES (2319,7768,40728,13784,3,1674,'App\\Models\\Receipt',1674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',37978.07,NULL,NULL,1,'2022-12-29 08:41:58','2023-01-16 20:40:45','2023-01-16 20:40:45'),(2320,7768,40728,13784,3,1675,'App\\Models\\Receipt',1675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',1530962.61,NULL,NULL,1,'2022-12-29 08:41:58','2023-01-16 21:18:06','2023-01-16 21:18:06'),(2321,7768,40728,13784,3,1676,'App\\Models\\Receipt',1676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',121000.00,NULL,NULL,1,'2022-12-29 08:41:58','2022-12-29 08:41:58',NULL),(2322,7768,40728,13784,3,1677,'App\\Models\\Receipt',1677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',72600.00,NULL,NULL,1,'2022-12-29 08:41:58','2022-12-29 08:41:58',NULL),(2323,7768,40728,13784,3,1678,'App\\Models\\Receipt',1678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',732100.27,NULL,NULL,1,'2022-12-29 08:41:58','2023-01-16 20:41:43','2023-01-16 20:41:43'),(2324,7768,40728,13784,3,1679,'App\\Models\\Receipt',1679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',836106.23,NULL,NULL,1,'2022-12-29 08:41:58','2022-12-29 08:41:58',NULL),(2325,7768,40728,13784,3,1680,'App\\Models\\Receipt',1680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',1530962.61,NULL,NULL,1,'2022-12-29 08:41:58','2023-01-16 21:14:31','2023-01-16 21:14:31'),(2326,7768,40728,13784,3,1681,'App\\Models\\Receipt',1681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',18403.61,NULL,NULL,1,'2022-12-29 08:41:58','2022-12-29 08:41:58',NULL),(2327,7768,40728,13784,3,1682,'App\\Models\\Receipt',1682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',2249.74,NULL,NULL,1,'2022-12-29 08:41:58','2022-12-29 08:41:58',NULL),(2328,7768,40728,13784,3,1683,'App\\Models\\Receipt',1683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',414.99,NULL,NULL,1,'2022-12-29 08:41:58','2022-12-29 08:41:58',NULL),(2329,7768,40728,13784,3,1684,'App\\Models\\Receipt',1684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',5680.10,NULL,NULL,1,'2022-12-29 08:41:58','2022-12-29 08:41:58',NULL),(2330,7768,40728,13784,3,1685,'App\\Models\\Receipt',1685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',67957.74,NULL,NULL,1,'2022-12-29 08:41:59','2022-12-29 08:41:59',NULL),(2331,7768,40728,13784,3,1686,'App\\Models\\Receipt',1686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',2408.38,NULL,NULL,1,'2022-12-29 08:41:59','2022-12-29 08:41:59',NULL),(2332,7768,40728,13784,3,1687,'App\\Models\\Receipt',1687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',3216.18,NULL,NULL,1,'2022-12-29 08:41:59','2022-12-29 08:41:59',NULL),(2333,7768,40728,13784,3,1688,'App\\Models\\Receipt',1688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',4532.88,NULL,NULL,1,'2022-12-29 08:41:59','2023-01-16 20:42:10','2023-01-16 20:42:10'),(2334,7768,40728,13784,3,1689,'App\\Models\\Receipt',1689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',31038.26,NULL,NULL,1,'2022-12-29 08:41:59','2022-12-29 08:41:59',NULL),(2335,7768,40728,13784,3,1690,'App\\Models\\Receipt',1690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',16360.00,NULL,NULL,1,'2022-12-29 08:41:59','2022-12-29 08:41:59',NULL),(2336,7768,40728,13784,3,1691,'App\\Models\\Receipt',1691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',5068.19,NULL,NULL,1,'2022-12-29 08:41:59','2023-01-16 20:42:36','2023-01-16 20:42:36'),(2337,7768,40728,13784,3,1692,'App\\Models\\Receipt',1692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',107370.64,NULL,NULL,1,'2022-12-29 08:41:59','2022-12-29 08:41:59',NULL),(2338,7768,40728,13784,3,1693,'App\\Models\\Receipt',1693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',7860.00,NULL,NULL,1,'2022-12-29 08:41:59','2022-12-29 08:41:59',NULL);
INSERT INTO `balance_libro` VALUES (2339,7768,40728,13784,3,1694,'App\\Models\\Receipt',1694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',709.48,NULL,NULL,1,'2022-12-29 08:41:59','2022-12-29 08:41:59',NULL),(2340,7768,40728,13784,3,1695,'App\\Models\\Receipt',1695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',147117.48,NULL,NULL,1,'2022-12-29 08:41:59','2022-12-29 08:41:59',NULL),(2341,7768,40728,13784,3,1696,'App\\Models\\Receipt',1696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',3609.10,NULL,NULL,1,'2022-12-29 08:41:59','2022-12-29 08:41:59',NULL),(2342,7768,40728,13784,3,1697,'App\\Models\\Receipt',1697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',240.00,NULL,NULL,1,'2022-12-29 08:41:59','2022-12-29 08:41:59',NULL),(2343,7768,40728,13784,3,1698,'App\\Models\\Receipt',1698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',484.00,NULL,NULL,1,'2022-12-29 08:41:59','2022-12-29 08:41:59',NULL),(2344,7768,40728,13784,3,1699,'App\\Models\\Receipt',1699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',15100.10,NULL,NULL,1,'2022-12-29 08:41:59','2022-12-29 08:41:59',NULL),(2345,7768,40728,13784,3,1700,'App\\Models\\Receipt',1700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',25805.36,NULL,NULL,1,'2022-12-29 08:41:59','2022-12-29 08:41:59',NULL),(2346,7768,40728,13784,3,1701,'App\\Models\\Receipt',1701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',6400.09,NULL,NULL,1,'2022-12-29 08:41:59','2022-12-29 08:41:59',NULL),(2347,7768,40728,13784,3,1702,'App\\Models\\Receipt',1702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',1833.44,NULL,NULL,1,'2022-12-29 08:41:59','2022-12-29 08:41:59',NULL),(2348,7768,40728,13784,3,1703,'App\\Models\\Receipt',1703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',15000.00,NULL,NULL,1,'2022-12-29 08:41:59','2022-12-29 08:41:59',NULL),(2349,7768,40728,13784,3,1704,'App\\Models\\Receipt',1704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',1990.00,NULL,NULL,1,'2022-12-29 08:41:59','2022-12-29 08:41:59',NULL),(2350,7768,40728,13784,3,1705,'App\\Models\\Receipt',1705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',6270.00,NULL,NULL,1,'2022-12-29 08:41:59','2022-12-29 08:41:59',NULL),(2351,7768,40728,13784,3,1706,'App\\Models\\Receipt',1706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',8808.80,NULL,NULL,1,'2022-12-29 08:42:00','2022-12-29 08:42:00',NULL),(2352,7768,40728,13784,3,1707,'App\\Models\\Receipt',1707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',39260.54,NULL,NULL,1,'2022-12-29 08:42:00','2022-12-29 08:42:00',NULL),(2353,7768,40728,13784,3,1708,'App\\Models\\Receipt',1708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',293.50,NULL,NULL,1,'2022-12-29 08:42:00','2022-12-29 08:42:00',NULL),(2354,7768,40728,13784,3,1709,'App\\Models\\Receipt',1709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',36179.00,NULL,NULL,1,'2022-12-29 08:42:00','2022-12-29 08:42:00',NULL),(2355,7768,40728,13784,3,1710,'App\\Models\\Receipt',1710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',1779.16,NULL,NULL,1,'2022-12-29 08:42:00','2022-12-29 08:42:00',NULL),(2356,7768,40728,13784,3,1711,'App\\Models\\Receipt',1711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',27810.74,NULL,NULL,1,'2022-12-29 08:42:00','2022-12-29 08:42:00',NULL),(2357,7768,40728,13784,3,1712,'App\\Models\\Receipt',1712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',21850.00,NULL,NULL,1,'2022-12-29 08:42:00','2022-12-29 08:42:00',NULL),(2358,7768,40728,13784,3,1713,'App\\Models\\Receipt',1713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',5100.00,NULL,NULL,1,'2022-12-29 08:42:00','2022-12-29 08:42:00',NULL),(2359,7768,41322,90369,2,1714,'App\\Models\\Receipt',1714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',583976.25,NULL,NULL,1,'2022-12-29 18:32:00','2022-12-29 18:32:00',NULL);
INSERT INTO `balance_libro` VALUES (2360,7768,41322,90369,3,1715,'App\\Models\\Receipt',1715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',135598.00,NULL,NULL,1,'2022-12-29 18:32:09','2022-12-29 18:32:09',NULL),(2361,7768,41322,90369,3,1716,'App\\Models\\Receipt',1716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',12500.00,NULL,NULL,1,'2022-12-29 18:32:09','2022-12-29 18:32:09',NULL),(2362,7768,41322,90369,3,1717,'App\\Models\\Receipt',1717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',15877.89,NULL,NULL,1,'2022-12-29 18:32:09','2022-12-29 18:32:09',NULL),(2363,7768,41322,90369,3,1718,'App\\Models\\Receipt',1718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',11201.20,NULL,NULL,1,'2022-12-29 18:32:09','2022-12-29 18:32:09',NULL),(2364,7768,41322,90369,3,1719,'App\\Models\\Receipt',1719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',18400.09,NULL,NULL,1,'2022-12-29 18:32:09','2022-12-29 18:32:09',NULL),(2365,7768,41322,90369,3,1720,'App\\Models\\Receipt',1720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',16034.01,NULL,NULL,1,'2022-12-29 18:32:09','2022-12-29 18:32:09',NULL),(2366,7768,41322,90369,3,1721,'App\\Models\\Receipt',1721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',6572.73,NULL,NULL,1,'2022-12-29 18:32:09','2023-01-16 09:40:51','2023-01-16 09:40:51'),(2367,7768,41298,88859,2,1722,'App\\Models\\Receipt',1722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',90750.00,NULL,NULL,1,'2022-12-29 18:56:00','2022-12-29 18:56:00',NULL),(2368,7768,41298,88859,2,1723,'App\\Models\\Receipt',1723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',63525.00,NULL,NULL,1,'2022-12-29 18:56:00','2022-12-29 18:56:00',NULL),(2369,7768,41298,88859,2,1724,'App\\Models\\Receipt',1724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',125235.00,NULL,NULL,1,'2022-12-29 18:56:00','2022-12-29 18:56:00',NULL),(2370,7768,41298,88859,3,1725,'App\\Models\\Receipt',1725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',8353.24,NULL,NULL,1,'2022-12-29 18:56:12','2022-12-29 18:56:12',NULL),(2371,7768,41298,88859,3,1726,'App\\Models\\Receipt',1726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',1700.00,NULL,NULL,1,'2022-12-29 18:56:12','2022-12-29 18:56:12',NULL),(2372,7768,41298,88859,3,1727,'App\\Models\\Receipt',1727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',15000.00,NULL,NULL,1,'2022-12-29 18:56:12','2022-12-29 18:56:12',NULL),(2373,7768,41298,88859,3,1728,'App\\Models\\Receipt',1728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',2989.99,NULL,NULL,1,'2022-12-29 18:56:13','2022-12-29 18:56:13',NULL),(2374,7768,41298,88859,3,1729,'App\\Models\\Receipt',1729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',2020.00,NULL,NULL,1,'2022-12-29 18:56:13','2022-12-29 18:56:13',NULL),(2375,7768,41298,88859,3,1730,'App\\Models\\Receipt',1730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',115735.00,NULL,NULL,1,'2022-12-29 18:56:13','2022-12-29 18:56:13',NULL),(2376,7768,41298,88859,3,1731,'App\\Models\\Receipt',1731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',7005.31,NULL,NULL,1,'2022-12-29 18:56:13','2022-12-29 18:56:13',NULL),(2377,7768,41298,88859,3,1732,'App\\Models\\Receipt',1732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',5719.20,NULL,NULL,1,'2022-12-29 18:56:13','2022-12-29 18:56:13',NULL),(2378,7768,41298,88859,3,1733,'App\\Models\\Receipt',1733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',15093.02,NULL,NULL,1,'2022-12-29 18:56:13','2023-01-19 17:08:50','2023-01-19 17:08:50'),(2379,7768,41298,88859,3,1734,'App\\Models\\Receipt',1734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',6964.49,NULL,NULL,1,'2022-12-29 18:56:13','2023-01-19 17:12:05','2023-01-19 17:12:05');
INSERT INTO `balance_libro` VALUES (2380,7768,41298,88859,3,1735,'App\\Models\\Receipt',1735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',11067.50,NULL,NULL,1,'2022-12-29 18:56:13','2022-12-29 18:56:13',NULL),(2381,7768,41298,88859,3,1736,'App\\Models\\Receipt',1736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',74366.00,NULL,NULL,1,'2022-12-29 18:56:13','2023-01-18 23:41:11','2023-01-18 23:41:11'),(2382,7768,41322,90369,3,1737,'App\\Models\\Receipt',1737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',8496.22,NULL,NULL,1,'2023-01-12 20:17:34','2023-01-12 20:17:34',NULL),(2383,7768,41322,90369,3,1738,'App\\Models\\Receipt',1738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',34749.93,NULL,NULL,1,'2023-01-12 20:17:34','2023-01-12 20:17:34',NULL),(2384,7768,41322,90369,3,1739,'App\\Models\\Receipt',1739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',10600.00,NULL,NULL,1,'2023-01-12 20:17:34','2023-01-12 20:17:34',NULL),(2385,7768,41322,90369,3,1740,'App\\Models\\Receipt',1740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',99970.02,NULL,NULL,1,'2023-01-12 20:17:34','2023-01-12 20:17:34',NULL),(2386,7768,41322,90369,3,1741,'App\\Models\\Receipt',1741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',20594.30,NULL,NULL,1,'2023-01-16 08:08:29','2023-01-16 08:08:29',NULL),(2387,7768,41322,90369,3,1721,'App\\Models\\Receipt',1721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',6572.73,NULL,NULL,1,'2023-01-16 09:40:51','2023-01-16 09:40:51',NULL),(2388,7768,40728,13784,3,1742,'App\\Models\\Receipt',1742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',5872.90,NULL,NULL,1,'2023-01-16 20:09:46','2023-01-16 20:09:46',NULL),(2389,7768,40728,13784,3,1743,'App\\Models\\Receipt',1743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',2999.99,NULL,NULL,1,'2023-01-16 20:09:46','2023-01-16 20:09:46',NULL),(2390,7768,40728,13784,3,1744,'App\\Models\\Receipt',1744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',3063.78,NULL,NULL,1,'2023-01-16 20:09:46','2023-01-16 20:09:46',NULL),(2391,7768,40728,13784,3,1745,'App\\Models\\Receipt',1745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',53002.57,NULL,NULL,1,'2023-01-16 20:09:46','2023-01-16 20:09:46',NULL),(2392,7768,40728,13784,3,1746,'App\\Models\\Receipt',1746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',98282.63,NULL,NULL,1,'2023-01-16 20:09:46','2023-01-16 20:09:46',NULL),(2393,7768,40728,13784,3,1747,'App\\Models\\Receipt',1747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',12703.12,NULL,NULL,1,'2023-01-16 20:09:46','2023-01-16 20:09:46',NULL),(2394,7768,40728,13784,3,1748,'App\\Models\\Receipt',1748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-06','2022-11-06',7100.41,NULL,NULL,1,'2023-01-16 20:09:46','2023-01-16 20:09:46',NULL),(2395,7768,40728,13784,3,1749,'App\\Models\\Receipt',1749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',6470.74,NULL,NULL,1,'2023-01-16 20:09:46','2023-01-16 20:09:46',NULL),(2396,7768,40728,13784,3,1750,'App\\Models\\Receipt',1750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',49930.55,NULL,NULL,1,'2023-01-16 20:09:47','2023-01-16 20:09:47',NULL),(2397,7768,40728,13784,3,1751,'App\\Models\\Receipt',1751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',7457.00,NULL,NULL,1,'2023-01-16 20:09:47','2023-01-16 20:09:47',NULL),(2398,7768,40728,13784,3,1752,'App\\Models\\Receipt',1752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',24895.55,NULL,NULL,1,'2023-01-16 20:09:47','2023-01-16 20:56:44','2023-01-16 20:56:44'),(2399,7768,40728,13784,3,1753,'App\\Models\\Receipt',1753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',3316.61,NULL,NULL,1,'2023-01-16 20:09:47','2023-01-16 20:56:04','2023-01-16 20:56:04');
INSERT INTO `balance_libro` VALUES (2400,7768,40728,13784,3,1754,'App\\Models\\Receipt',1754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2268.52,NULL,NULL,1,'2023-01-16 20:09:47','2023-01-16 20:09:47',NULL),(2401,7768,40728,13784,3,1755,'App\\Models\\Receipt',1755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',11371.69,NULL,NULL,1,'2023-01-16 20:09:47','2023-01-16 20:09:47',NULL),(2402,7768,40728,13784,3,1756,'App\\Models\\Receipt',1756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',3000.30,NULL,NULL,1,'2023-01-16 20:09:47','2023-01-16 20:09:47',NULL),(2403,7768,40728,13784,3,1757,'App\\Models\\Receipt',1757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',2999.98,NULL,NULL,1,'2023-01-16 20:09:47','2023-01-16 20:09:47',NULL),(2404,7768,40728,13784,3,1758,'App\\Models\\Receipt',1758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',2999.98,NULL,NULL,1,'2023-01-16 20:09:47','2023-01-16 20:09:47',NULL),(2405,7768,40728,13784,3,1759,'App\\Models\\Receipt',1759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',3000.30,NULL,NULL,1,'2023-01-16 20:09:47','2023-01-16 21:25:11','2023-01-16 21:25:11'),(2406,7768,40728,13784,3,1760,'App\\Models\\Receipt',1760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',2999.99,NULL,NULL,1,'2023-01-16 20:09:47','2023-01-16 20:09:47',NULL),(2407,7768,40728,13784,3,1761,'App\\Models\\Receipt',1761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',3206.78,NULL,NULL,1,'2023-01-16 20:09:48','2023-01-16 20:57:30','2023-01-16 20:57:30'),(2408,7768,40728,13784,3,1762,'App\\Models\\Receipt',1762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',68061.42,NULL,NULL,1,'2023-01-16 20:09:48','2023-01-16 20:09:48',NULL),(2409,7768,40728,13784,3,1763,'App\\Models\\Receipt',1763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',1999.95,NULL,NULL,1,'2023-01-16 20:09:48','2023-01-16 20:09:48',NULL),(2410,7768,40728,13784,3,1764,'App\\Models\\Receipt',1764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',5000.08,NULL,NULL,1,'2023-01-16 20:09:48','2023-01-16 20:09:48',NULL),(2411,7768,40728,13784,2,1765,'App\\Models\\Receipt',1765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',650652.32,NULL,NULL,1,'2023-01-16 20:14:39','2023-01-16 20:14:39',NULL),(2412,7768,40728,13784,2,1766,'App\\Models\\Receipt',1766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',153298.89,NULL,NULL,1,'2023-01-16 20:14:39','2023-01-16 20:14:39',NULL),(2413,7768,40728,13784,3,1767,'App\\Models\\Receipt',1767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',35574.00,NULL,NULL,1,'2023-01-16 20:37:39','2023-01-16 20:37:39',NULL),(2414,7768,40728,13784,3,1768,'App\\Models\\Receipt',1768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',326700.00,NULL,NULL,1,'2023-01-16 20:37:39','2023-01-16 20:37:39',NULL),(2415,7768,40728,13784,3,1769,'App\\Models\\Receipt',1769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',4489.37,NULL,NULL,1,'2023-01-16 20:37:39','2023-01-16 20:37:39',NULL),(2416,7768,40728,13784,3,1770,'App\\Models\\Receipt',1770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',15159.84,NULL,NULL,1,'2023-01-16 20:37:39','2023-01-16 20:37:39',NULL),(2417,7768,40728,13784,3,1664,'App\\Models\\Receipt',1664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',7426.22,NULL,NULL,1,'2023-01-16 20:38:59','2023-01-16 20:38:59',NULL),(2418,7768,40728,13784,3,1672,'App\\Models\\Receipt',1672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',6476.71,NULL,NULL,1,'2023-01-16 20:40:13','2023-01-16 21:20:27','2023-01-16 21:20:27'),(2419,7768,40728,13784,3,1674,'App\\Models\\Receipt',1674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',37978.07,NULL,NULL,1,'2023-01-16 20:40:45','2023-01-16 20:40:45',NULL);
INSERT INTO `balance_libro` VALUES (2420,7768,40728,13784,3,1678,'App\\Models\\Receipt',1678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',732100.27,NULL,NULL,1,'2023-01-16 20:41:43','2023-01-16 20:41:43',NULL),(2421,7768,40728,13784,3,1688,'App\\Models\\Receipt',1688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',4532.88,NULL,NULL,1,'2023-01-16 20:42:10','2023-01-16 20:42:10',NULL),(2422,7768,40728,13784,3,1691,'App\\Models\\Receipt',1691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',5068.19,NULL,NULL,1,'2023-01-16 20:42:36','2023-01-16 20:42:36',NULL),(2423,7768,40728,13784,3,1753,'App\\Models\\Receipt',1753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',3361.16,NULL,NULL,1,'2023-01-16 20:56:04','2023-01-16 20:56:25','2023-01-16 20:56:25'),(2424,7768,40728,13784,3,1753,'App\\Models\\Receipt',1753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',3316.61,NULL,NULL,1,'2023-01-16 20:56:25','2023-01-16 20:56:25',NULL),(2425,7768,40728,13784,3,1752,'App\\Models\\Receipt',1752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',24895.55,NULL,NULL,1,'2023-01-16 20:56:44','2023-01-16 20:56:44',NULL),(2426,7768,40728,13784,3,1761,'App\\Models\\Receipt',1761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',3206.78,NULL,NULL,1,'2023-01-16 20:57:30','2023-01-16 20:57:30',NULL),(2427,7768,40728,13784,7,1771,'App\\Models\\Receipt',1771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',77757.12,NULL,NULL,1,'2023-01-16 21:00:32','2023-01-16 21:00:32',NULL),(2428,7768,40728,13784,3,1680,'App\\Models\\Receipt',1680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',1530962.61,NULL,NULL,1,'2023-01-16 21:14:31','2023-01-16 21:16:19','2023-01-16 21:16:19'),(2429,7768,40728,13784,3,1675,'App\\Models\\Receipt',1675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',1530962.61,NULL,NULL,1,'2023-01-16 21:18:06','2023-01-16 21:18:06',NULL),(2430,7768,40728,13784,3,1672,'App\\Models\\Receipt',1672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',6476.71,NULL,NULL,1,'2023-01-16 21:20:27','2023-01-16 21:21:37','2023-01-16 21:21:37'),(2431,7768,40728,13784,3,1672,'App\\Models\\Receipt',1672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',6476.71,NULL,NULL,1,'2023-01-16 21:21:37','2023-01-16 21:26:53','2023-01-16 21:26:53'),(2432,7768,40728,13784,3,1759,'App\\Models\\Receipt',1759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',3041.24,NULL,NULL,1,'2023-01-16 21:25:11','2023-01-16 21:25:11',NULL),(2433,7768,40728,13784,3,1672,'App\\Models\\Receipt',1672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',6476.71,NULL,NULL,1,'2023-01-16 21:26:53','2023-01-16 21:38:04','2023-01-16 21:38:04'),(2434,7768,40728,13784,3,1772,'App\\Models\\Receipt',1772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',1530962.61,NULL,NULL,1,'2023-01-16 21:35:21','2023-01-16 21:35:21',NULL),(2435,7768,40728,13784,3,1672,'App\\Models\\Receipt',1672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',6476.71,NULL,NULL,1,'2023-01-16 21:38:04','2023-01-16 21:38:04',NULL),(2436,7768,40728,13784,7,1773,'App\\Models\\Receipt',1773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',4165.56,NULL,NULL,1,'2023-01-16 22:05:27','2023-01-16 22:05:27',NULL),(2437,7768,40728,13784,7,1774,'App\\Models\\Receipt',1774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',4776.80,NULL,NULL,1,'2023-01-16 22:06:33','2023-01-16 22:06:33',NULL),(2438,7768,40728,13784,7,1775,'App\\Models\\Receipt',1775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',4628.40,NULL,NULL,1,'2023-01-16 22:07:15','2023-01-16 22:07:15',NULL),(2439,7768,40728,13784,15,1204,'App\\Models\\PeriodLiquidation',NULL,1204,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1023252.87,NULL,NULL,1,'2023-01-16 22:35:28','2023-02-15 17:52:09','2023-02-15 17:52:09');
INSERT INTO `balance_libro` VALUES (2440,7768,41298,88859,3,1776,'App\\Models\\Receipt',1776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',3748.26,NULL,NULL,1,'2023-01-18 23:42:02','2023-01-18 23:42:02',NULL),(2441,7768,41298,88859,3,1733,'App\\Models\\Receipt',1733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',15093.02,NULL,NULL,1,'2023-01-19 17:08:50','2023-01-19 17:08:50',NULL),(2442,7768,41298,88859,3,1734,'App\\Models\\Receipt',1734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',6964.49,NULL,NULL,1,'2023-01-19 17:12:05','2023-01-19 17:12:05',NULL),(2443,7768,40728,13788,3,1777,'App\\Models\\Receipt',1777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',186675.20,NULL,NULL,1,'2023-01-20 12:26:02','2023-02-21 22:34:07','2023-02-21 22:34:07'),(2444,7768,40728,13788,3,1778,'App\\Models\\Receipt',1778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',14641.00,NULL,NULL,1,'2023-01-20 12:26:02','2023-01-20 12:26:02',NULL),(2445,7768,40728,13788,3,1779,'App\\Models\\Receipt',1779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2008.60,NULL,NULL,1,'2023-01-20 12:26:02','2023-01-20 12:26:02',NULL),(2446,7768,40728,13788,3,1780,'App\\Models\\Receipt',1780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',18150.00,NULL,NULL,1,'2023-01-20 12:26:02','2023-01-20 12:26:02',NULL),(2447,7768,40728,13788,3,1781,'App\\Models\\Receipt',1781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',820.00,NULL,NULL,1,'2023-01-20 12:26:02','2023-01-20 12:26:02',NULL),(2448,7768,40728,13788,3,1782,'App\\Models\\Receipt',1782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',8500.04,NULL,NULL,1,'2023-01-20 12:26:02','2023-01-20 12:26:02',NULL),(2449,7768,40728,13788,3,1783,'App\\Models\\Receipt',1783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',9300.00,NULL,NULL,1,'2023-01-20 12:26:02','2023-01-20 12:26:02',NULL),(2450,7768,40728,13788,3,1784,'App\\Models\\Receipt',1784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',9300.00,NULL,NULL,1,'2023-01-20 12:26:02','2023-01-20 12:26:02',NULL),(2451,7768,40728,13788,3,1785,'App\\Models\\Receipt',1785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',81949.46,NULL,NULL,1,'2023-01-20 12:26:02','2023-01-20 12:26:02',NULL),(2452,7768,40728,13788,3,1786,'App\\Models\\Receipt',1786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',120243.69,NULL,NULL,1,'2023-01-20 12:26:02','2023-01-20 12:26:02',NULL),(2453,7768,40728,13788,3,1787,'App\\Models\\Receipt',1787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3932.50,NULL,NULL,1,'2023-01-20 12:26:02','2023-01-20 12:26:02',NULL),(2454,7768,40728,13788,3,1788,'App\\Models\\Receipt',1788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',41215.04,NULL,NULL,1,'2023-01-20 12:26:02','2023-02-21 22:34:41','2023-02-21 22:34:41'),(2455,7768,40728,13788,3,1789,'App\\Models\\Receipt',1789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1120.00,NULL,NULL,1,'2023-01-20 12:26:02','2023-01-20 12:26:02',NULL),(2456,7768,40728,13788,3,1790,'App\\Models\\Receipt',1790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',31992.40,NULL,NULL,1,'2023-01-20 12:26:02','2023-01-20 12:26:02',NULL),(2457,7768,40728,13788,3,1791,'App\\Models\\Receipt',1791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',6234.26,NULL,NULL,1,'2023-01-20 12:26:03','2023-01-20 12:26:03',NULL),(2458,7768,40728,13788,3,1792,'App\\Models\\Receipt',1792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3148.36,NULL,NULL,1,'2023-01-20 12:26:03','2023-01-20 12:26:03',NULL),(2459,7768,40728,13788,3,1793,'App\\Models\\Receipt',1793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',22000.00,NULL,NULL,1,'2023-01-20 12:26:03','2023-01-20 12:26:03',NULL);
INSERT INTO `balance_libro` VALUES (2460,7768,40728,13788,3,1794,'App\\Models\\Receipt',1794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',14801.38,NULL,NULL,1,'2023-01-20 12:26:03','2023-01-20 12:26:03',NULL),(2461,7768,40728,13788,3,1795,'App\\Models\\Receipt',1795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',2000.02,NULL,NULL,1,'2023-01-20 12:26:03','2023-01-20 12:26:03',NULL),(2462,7768,40728,13788,3,1796,'App\\Models\\Receipt',1796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',46828.96,NULL,NULL,1,'2023-01-20 12:26:03','2023-02-21 22:35:30','2023-02-21 22:35:30'),(2463,7768,40728,13788,3,1797,'App\\Models\\Receipt',1797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',3639.37,NULL,NULL,1,'2023-01-20 12:26:03','2023-01-20 12:26:03',NULL),(2464,7768,40728,13788,3,1798,'App\\Models\\Receipt',1798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',3205.68,NULL,NULL,1,'2023-01-20 12:26:03','2023-01-20 12:26:03',NULL),(2465,7768,40728,13788,3,1799,'App\\Models\\Receipt',1799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',1342.48,NULL,NULL,1,'2023-01-20 12:26:03','2023-01-20 12:26:03',NULL),(2466,7768,40728,13788,3,1800,'App\\Models\\Receipt',1800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',1404867.22,NULL,NULL,1,'2023-01-20 12:26:03','2023-01-20 12:26:03',NULL),(2467,7768,40728,13788,3,1801,'App\\Models\\Receipt',1801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',3050.02,NULL,NULL,1,'2023-01-20 12:26:03','2023-01-20 12:26:03',NULL),(2468,7768,40728,13788,3,1802,'App\\Models\\Receipt',1802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',363000.00,NULL,NULL,1,'2023-01-20 12:26:03','2023-01-20 12:26:03',NULL),(2469,7768,40728,13788,3,1803,'App\\Models\\Receipt',1803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',1080.60,NULL,NULL,1,'2023-01-20 12:26:03','2023-01-20 12:26:03',NULL),(2470,7768,40728,13788,3,1804,'App\\Models\\Receipt',1804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',4775.16,NULL,NULL,1,'2023-01-20 12:26:03','2023-01-20 12:26:03',NULL),(2471,7768,40728,13788,3,1805,'App\\Models\\Receipt',1805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',6783.32,NULL,NULL,1,'2023-01-20 12:26:03','2023-01-20 12:26:03',NULL),(2472,7768,40728,13788,3,1806,'App\\Models\\Receipt',1806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',18750.04,NULL,NULL,1,'2023-01-20 12:26:03','2023-01-20 12:26:03',NULL),(2473,7768,40728,13788,3,1807,'App\\Models\\Receipt',1807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',78254.70,NULL,NULL,1,'2023-01-20 12:26:03','2023-02-21 22:36:17','2023-02-21 22:36:17'),(2474,7768,40728,13788,3,1808,'App\\Models\\Receipt',1808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',999.94,NULL,NULL,1,'2023-01-20 12:26:04','2023-01-20 12:26:04',NULL),(2475,7768,40728,13788,3,1809,'App\\Models\\Receipt',1809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',65506.52,NULL,NULL,1,'2023-01-20 12:26:04','2023-01-20 12:26:04',NULL),(2476,7768,40728,13788,3,1810,'App\\Models\\Receipt',1810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',13844.04,NULL,NULL,1,'2023-01-20 12:26:04','2023-01-20 12:26:04',NULL),(2477,7768,40728,13788,3,1811,'App\\Models\\Receipt',1811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',1142.11,NULL,NULL,1,'2023-01-20 12:26:04','2023-01-20 12:26:04',NULL),(2478,7768,40728,13788,3,1812,'App\\Models\\Receipt',1812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',10527.00,NULL,NULL,1,'2023-01-20 12:26:04','2023-01-20 12:26:04',NULL),(2479,7768,40728,13788,3,1813,'App\\Models\\Receipt',1813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',60225.50,NULL,NULL,1,'2023-01-20 12:26:04','2023-01-20 12:26:04',NULL);
INSERT INTO `balance_libro` VALUES (2480,7768,40728,13788,3,1814,'App\\Models\\Receipt',1814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',1359.99,NULL,NULL,1,'2023-01-20 12:26:04','2023-01-20 12:26:04',NULL),(2481,7768,40728,13788,3,1815,'App\\Models\\Receipt',1815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2572.92,NULL,NULL,1,'2023-01-20 12:26:04','2023-01-20 12:26:04',NULL),(2482,7768,40728,13788,3,1816,'App\\Models\\Receipt',1816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',6174.15,NULL,NULL,1,'2023-01-20 12:26:04','2023-01-20 12:26:04',NULL),(2483,7768,40728,13788,3,1817,'App\\Models\\Receipt',1817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',6638.98,NULL,NULL,1,'2023-01-20 12:26:04','2023-01-20 12:26:04',NULL),(2484,7768,40728,13788,3,1818,'App\\Models\\Receipt',1818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',7695.99,NULL,NULL,1,'2023-01-20 12:26:04','2023-01-20 12:26:04',NULL),(2485,7768,40728,13788,2,1819,'App\\Models\\Receipt',1819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',40313.99,NULL,NULL,1,'2023-01-20 12:26:37','2023-01-20 12:26:37',NULL),(2486,7768,40728,13788,2,1820,'App\\Models\\Receipt',1820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',23238.05,NULL,NULL,1,'2023-01-20 12:26:37','2023-01-20 12:26:37',NULL),(2487,7768,40728,13788,2,1821,'App\\Models\\Receipt',1821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',268937.26,NULL,NULL,1,'2023-01-20 12:26:38','2023-01-20 12:26:38',NULL),(2488,7768,40728,13788,2,1822,'App\\Models\\Receipt',1822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',42863.48,NULL,NULL,1,'2023-01-20 12:26:38','2023-01-20 12:26:38',NULL),(2489,7768,40728,13788,2,1823,'App\\Models\\Receipt',1823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',23050.50,NULL,NULL,1,'2023-01-20 12:26:38','2023-01-20 12:26:38',NULL),(2490,7768,40728,13788,2,1824,'App\\Models\\Receipt',1824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',167395.07,NULL,NULL,1,'2023-01-20 12:26:38','2023-01-20 12:26:38',NULL),(2491,7768,40728,13788,2,1825,'App\\Models\\Receipt',1825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',21899.06,NULL,NULL,1,'2023-01-20 12:26:38','2023-01-20 12:26:38',NULL),(2492,7768,40728,13788,2,1826,'App\\Models\\Receipt',1826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',754799.35,NULL,NULL,1,'2023-01-20 12:26:38','2023-01-20 12:26:38',NULL),(2493,7768,40728,13788,2,1827,'App\\Models\\Receipt',1827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',61327.64,NULL,NULL,1,'2023-01-20 12:26:38','2023-01-20 12:26:38',NULL),(2494,7768,40728,13788,2,1828,'App\\Models\\Receipt',1828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',58806.00,NULL,NULL,1,'2023-01-20 12:26:38','2023-01-20 12:26:38',NULL),(2495,7768,40728,13788,2,1829,'App\\Models\\Receipt',1829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',1748991.31,NULL,NULL,1,'2023-01-20 12:26:38','2023-01-20 12:26:38',NULL),(2496,7768,40728,13788,2,1830,'App\\Models\\Receipt',1830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',1380731.91,NULL,NULL,1,'2023-01-20 12:26:38','2023-01-20 12:26:38',NULL),(2497,7768,40728,13788,3,1831,'App\\Models\\Receipt',1831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',163350.00,NULL,NULL,1,'2023-01-24 10:00:09','2023-01-24 10:00:09',NULL),(2498,7768,40728,13788,3,1832,'App\\Models\\Receipt',1832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',80331.44,NULL,NULL,1,'2023-01-24 10:00:09','2023-01-24 10:00:09',NULL),(2499,7768,40728,13788,3,1833,'App\\Models\\Receipt',1833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',5777.67,NULL,NULL,1,'2023-01-24 10:00:09','2023-02-21 22:37:27','2023-02-21 22:37:27');
INSERT INTO `balance_libro` VALUES (2500,7768,40728,13788,3,1834,'App\\Models\\Receipt',1834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',6014.65,NULL,NULL,1,'2023-01-24 10:00:09','2023-01-24 10:00:09',NULL),(2501,7768,40728,13788,3,1835,'App\\Models\\Receipt',1835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',3898.26,NULL,NULL,1,'2023-01-24 10:00:09','2023-01-24 10:00:09',NULL),(2502,7768,40728,13788,3,1836,'App\\Models\\Receipt',1836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',61889.12,NULL,NULL,1,'2023-01-24 10:00:09','2023-01-24 10:00:09',NULL),(2503,7768,40728,13788,3,1837,'App\\Models\\Receipt',1837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',1469.39,NULL,NULL,1,'2023-01-24 10:00:09','2023-01-24 10:00:09',NULL),(2504,7768,40728,13788,2,1838,'App\\Models\\Receipt',1838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',669215.91,NULL,NULL,1,'2023-01-24 10:00:25','2023-01-24 10:00:25',NULL),(2505,7768,40728,13788,2,1839,'App\\Models\\Receipt',1839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',656478.24,NULL,NULL,1,'2023-01-24 10:00:25','2023-01-24 10:00:25',NULL),(2506,7768,40728,13788,2,1840,'App\\Models\\Receipt',1840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',656478.24,NULL,NULL,1,'2023-01-24 10:00:25','2023-01-24 10:00:25',NULL),(2507,7768,41298,88863,3,1841,'App\\Models\\Receipt',1841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',18900.00,NULL,NULL,1,'2023-02-15 08:17:40','2023-02-18 10:29:35','2023-02-18 10:29:35'),(2508,7768,41298,88863,3,1842,'App\\Models\\Receipt',1842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',9000.00,NULL,NULL,1,'2023-02-15 08:17:40','2023-02-18 10:29:27','2023-02-18 10:29:27'),(2509,7768,41298,88863,3,1843,'App\\Models\\Receipt',1843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',7401.70,NULL,NULL,1,'2023-02-15 08:17:40','2023-02-18 10:29:19','2023-02-18 10:29:19'),(2510,7768,41298,88863,3,1844,'App\\Models\\Receipt',1844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',7202.92,NULL,NULL,1,'2023-02-15 08:17:40','2023-02-18 10:29:12','2023-02-18 10:29:12'),(2511,7768,41298,88863,3,1845,'App\\Models\\Receipt',1845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',3000.01,NULL,NULL,1,'2023-02-15 08:17:40','2023-02-18 10:28:59','2023-02-18 10:28:59'),(2512,7768,41298,88863,2,1846,'App\\Models\\Receipt',1846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',191119.00,NULL,NULL,1,'2023-02-15 08:17:50','2023-02-15 08:37:24','2023-02-15 08:37:24'),(2513,7768,41298,88863,2,1846,'App\\Models\\Receipt',1846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',191119.00,NULL,NULL,1,'2023-02-15 08:37:24','2023-02-15 08:37:24',NULL),(2514,7768,41322,90375,3,1847,'App\\Models\\Receipt',1847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',12601.78,NULL,NULL,1,'2023-02-15 17:48:04','2023-02-15 17:48:57','2023-02-15 17:48:57'),(2515,7768,41322,90375,3,1848,'App\\Models\\Receipt',1848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',14101.25,NULL,NULL,1,'2023-02-15 17:48:04','2023-02-15 17:48:51','2023-02-15 17:48:51'),(2516,7768,41322,90375,3,1849,'App\\Models\\Receipt',1849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',11084.81,NULL,NULL,1,'2023-02-15 17:50:20','2023-02-15 17:50:20',NULL),(2517,7768,41322,90375,3,1850,'App\\Models\\Receipt',1850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',16270.00,NULL,NULL,1,'2023-02-15 17:50:20','2023-02-15 17:50:20',NULL),(2518,7768,41322,90375,3,1851,'App\\Models\\Receipt',1851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',15750.00,NULL,NULL,1,'2023-02-15 17:50:20','2023-02-15 17:50:20',NULL),(2519,7768,41322,90375,3,1852,'App\\Models\\Receipt',1852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',8558.20,NULL,NULL,1,'2023-02-15 17:50:20','2023-02-15 17:50:20',NULL);
INSERT INTO `balance_libro` VALUES (2520,7768,41322,90375,3,1853,'App\\Models\\Receipt',1853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',19876.00,NULL,NULL,1,'2023-02-15 17:50:20','2023-02-15 17:50:20',NULL),(2521,7768,41322,90375,3,1854,'App\\Models\\Receipt',1854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',12601.78,NULL,NULL,1,'2023-02-15 17:50:20','2023-02-15 17:50:20',NULL),(2522,7768,41322,90375,3,1855,'App\\Models\\Receipt',1855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',14101.25,NULL,NULL,1,'2023-02-15 17:50:20','2023-02-15 17:50:20',NULL),(2523,7768,41322,90369,15,1117,'App\\Models\\PeriodLiquidation',NULL,1117,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',101351.25,NULL,NULL,1,'2023-02-15 17:52:05','2023-02-15 17:52:05',NULL),(2524,7768,41322,90375,16,1236,'App\\Models\\PeriodLiquidation',NULL,1236,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',7201.56,NULL,NULL,1,'2023-02-15 17:52:09','2023-02-15 18:06:59','2023-02-15 18:06:59'),(2525,7768,41322,90369,16,1118,'App\\Models\\PeriodLiquidation',NULL,1118,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',4674.49,NULL,NULL,1,'2023-02-15 18:07:08','2023-02-15 18:07:08',NULL),(2526,7768,41322,90375,15,1235,'App\\Models\\PeriodLiquidation',NULL,1235,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',9893.25,NULL,NULL,1,'2023-02-15 18:28:14','2023-02-15 18:28:14',NULL),(2527,7768,41322,90375,16,1236,'App\\Models\\PeriodLiquidation',NULL,1236,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',7201.56,NULL,NULL,1,'2023-02-15 18:28:19','2023-02-15 18:28:19',NULL),(2528,7768,41298,88863,3,1856,'App\\Models\\Receipt',1856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',18900.00,NULL,NULL,1,'2023-02-18 10:30:34','2023-02-18 10:30:34',NULL),(2529,7768,41298,88863,3,1857,'App\\Models\\Receipt',1857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',9000.00,NULL,NULL,1,'2023-02-18 10:30:34','2023-02-18 10:30:34',NULL),(2530,7768,41298,88863,3,1858,'App\\Models\\Receipt',1858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',7401.70,NULL,NULL,1,'2023-02-18 10:30:34','2023-02-18 10:30:34',NULL),(2531,7768,41298,88863,3,1859,'App\\Models\\Receipt',1859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',7202.92,NULL,NULL,1,'2023-02-18 10:30:34','2023-02-18 10:30:34',NULL),(2532,7768,41298,88863,3,1860,'App\\Models\\Receipt',1860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',3000.01,NULL,NULL,1,'2023-02-18 10:30:34','2023-02-18 10:30:34',NULL),(2533,7768,41298,88863,3,1861,'App\\Models\\Receipt',1861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',16882.50,NULL,NULL,1,'2023-02-18 10:30:34','2023-02-18 10:30:34',NULL),(2534,7768,41298,88859,15,1213,'App\\Models\\PeriodLiquidation',NULL,1213,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',48510.00,NULL,NULL,1,'2023-02-18 11:11:47','2023-02-18 11:11:47',NULL),(2535,7768,40728,13788,2,1862,'App\\Models\\Receipt',1862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',124020.16,NULL,NULL,1,'2023-02-21 22:31:14','2023-02-21 22:31:14',NULL),(2536,7768,40728,13788,3,1863,'App\\Models\\Receipt',1863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',880.03,NULL,NULL,1,'2023-02-21 22:33:05','2023-02-21 22:33:05',NULL),(2537,7768,40728,13788,3,1864,'App\\Models\\Receipt',1864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',1008.56,NULL,NULL,1,'2023-02-21 22:33:05','2023-02-21 22:33:05',NULL),(2538,7768,40728,13788,3,1865,'App\\Models\\Receipt',1865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',3136.26,NULL,NULL,1,'2023-02-21 22:33:05','2023-02-21 22:33:05',NULL),(2539,7768,40728,13788,3,1866,'App\\Models\\Receipt',1866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',96316.79,NULL,NULL,1,'2023-02-21 22:33:05','2023-02-21 22:33:05',NULL);
INSERT INTO `balance_libro` VALUES (2540,7768,40728,13788,3,1867,'App\\Models\\Receipt',1867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',5400.44,NULL,NULL,1,'2023-02-21 22:33:05','2023-02-21 22:33:05',NULL),(2541,7768,40728,13788,3,1868,'App\\Models\\Receipt',1868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',880.03,NULL,NULL,1,'2023-02-21 22:33:05','2023-02-21 22:33:05',NULL),(2542,7768,40728,13788,3,1869,'App\\Models\\Receipt',1869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',3598.07,NULL,NULL,1,'2023-02-21 22:33:05','2023-02-21 22:33:05',NULL),(2543,7768,40728,13788,3,1870,'App\\Models\\Receipt',1870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',1007.56,NULL,NULL,1,'2023-02-21 22:33:05','2023-02-21 22:33:05',NULL),(2544,7768,40728,13788,3,1871,'App\\Models\\Receipt',1871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',508200.00,NULL,NULL,1,'2023-02-21 22:33:05','2023-02-21 22:33:05',NULL),(2545,7768,40728,13788,3,1872,'App\\Models\\Receipt',1872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',695.00,NULL,NULL,1,'2023-02-21 22:33:05','2023-02-21 22:33:05',NULL),(2546,7768,40728,13788,3,1873,'App\\Models\\Receipt',1873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',1746.59,NULL,NULL,1,'2023-02-21 22:33:05','2023-02-21 22:33:05',NULL),(2547,7768,40728,13788,3,1874,'App\\Models\\Receipt',1874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',695.00,NULL,NULL,1,'2023-02-21 22:33:05','2023-02-21 22:33:05',NULL),(2548,7768,40728,13788,3,1875,'App\\Models\\Receipt',1875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',7400.00,NULL,NULL,1,'2023-02-21 22:33:05','2023-02-21 22:33:05',NULL),(2549,7768,40728,13788,3,1876,'App\\Models\\Receipt',1876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',8057.92,NULL,NULL,1,'2023-02-21 22:33:05','2023-02-21 22:57:53','2023-02-21 22:57:53'),(2550,7768,40728,13788,3,1877,'App\\Models\\Receipt',1877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',1200.00,NULL,NULL,1,'2023-02-21 22:33:05','2023-02-21 22:33:05',NULL),(2551,7768,40728,13788,3,1878,'App\\Models\\Receipt',1878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',7751.82,NULL,NULL,1,'2023-02-21 22:33:05','2023-02-21 22:33:05',NULL),(2552,7768,40728,13788,3,1879,'App\\Models\\Receipt',1879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',3063.78,NULL,NULL,1,'2023-02-21 22:33:05','2023-02-21 22:33:05',NULL),(2553,7768,40728,13788,3,1880,'App\\Models\\Receipt',1880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',801.30,NULL,NULL,1,'2023-02-21 22:33:05','2023-02-21 22:33:05',NULL),(2554,7768,40728,13788,3,1881,'App\\Models\\Receipt',1881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',20012.57,NULL,NULL,1,'2023-02-21 22:33:05','2023-02-21 22:33:05',NULL),(2555,7768,40728,13788,3,1882,'App\\Models\\Receipt',1882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',23801.27,NULL,NULL,1,'2023-02-21 22:33:05','2023-02-21 22:33:05',NULL),(2556,7768,40728,13788,3,1883,'App\\Models\\Receipt',1883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',188350.26,NULL,NULL,1,'2023-02-21 22:33:05','2023-02-21 22:33:05',NULL),(2557,7768,40728,13788,3,1884,'App\\Models\\Receipt',1884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',10657.44,NULL,NULL,1,'2023-02-21 22:33:05','2023-02-21 22:33:05',NULL),(2558,7768,40728,13788,3,1885,'App\\Models\\Receipt',1885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',65607.04,NULL,NULL,1,'2023-02-21 22:33:06','2023-02-21 22:33:06',NULL),(2559,7768,40728,13788,3,1777,'App\\Models\\Receipt',1777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',186675.20,NULL,NULL,1,'2023-02-21 22:34:07','2023-02-21 22:34:07',NULL),(2560,7768,40728,13788,3,1788,'App\\Models\\Receipt',1788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',41215.04,NULL,NULL,1,'2023-02-21 22:34:41','2023-02-21 22:34:41',NULL);
INSERT INTO `balance_libro` VALUES (2561,7768,40728,13788,3,1796,'App\\Models\\Receipt',1796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',46828.96,NULL,NULL,1,'2023-02-21 22:35:30','2023-02-21 22:35:30',NULL),(2562,7768,40728,13788,3,1807,'App\\Models\\Receipt',1807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',78254.70,NULL,NULL,1,'2023-02-21 22:36:17','2023-02-21 22:36:17',NULL),(2563,7768,40728,13788,3,1833,'App\\Models\\Receipt',1833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',5777.67,NULL,NULL,1,'2023-02-21 22:37:27','2023-02-21 22:37:27',NULL),(2564,7768,40728,13784,16,1205,'App\\Models\\PeriodLiquidation',NULL,1205,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',134945.61,NULL,NULL,1,'2023-02-21 22:42:10','2023-02-21 22:42:10',NULL),(2565,7768,40728,13788,3,1876,'App\\Models\\Receipt',1876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',8057.93,NULL,NULL,1,'2023-02-21 22:57:53','2023-02-21 22:57:53',NULL),(2566,7768,40728,13788,16,1266,'App\\Models\\PeriodLiquidation',NULL,1266,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',130703.95,NULL,NULL,1,'2023-02-21 23:20:11','2023-02-21 23:41:06','2023-02-21 23:41:06'),(2567,7768,40728,13788,7,1886,'App\\Models\\Receipt',1886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',34569.27,NULL,NULL,1,'2023-02-21 23:41:56','2023-02-21 23:41:56',NULL),(2568,7768,40728,13788,7,1887,'App\\Models\\Receipt',1887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3292.31,NULL,NULL,1,'2023-02-21 23:43:20','2023-02-21 23:43:20',NULL),(2569,7768,40728,13788,7,1888,'App\\Models\\Receipt',1888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2104.62,NULL,NULL,1,'2023-02-21 23:44:26','2023-02-21 23:44:26',NULL),(2570,7768,40728,13788,7,1889,'App\\Models\\Receipt',1889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',6274.58,NULL,NULL,1,'2023-02-21 23:46:41','2023-02-21 23:46:41',NULL),(2571,7768,40728,13788,7,1890,'App\\Models\\Receipt',1890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',6274.58,NULL,NULL,1,'2023-02-21 23:46:41','2023-02-21 23:46:53','2023-02-21 23:46:53'),(2572,7768,40728,13789,2,1891,'App\\Models\\Receipt',1891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',172576.25,NULL,NULL,1,'2023-03-06 09:27:56','2023-03-06 09:27:56',NULL),(2573,7768,40728,13789,2,1892,'App\\Models\\Receipt',1892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',3119574.21,NULL,NULL,1,'2023-03-06 09:27:56','2023-03-06 09:27:56',NULL),(2574,7768,40728,13789,2,1893,'App\\Models\\Receipt',1893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',2682255.09,NULL,NULL,1,'2023-03-06 09:27:56','2023-03-06 09:27:56',NULL),(2575,7768,40728,13789,2,1894,'App\\Models\\Receipt',1894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',1643247.09,NULL,NULL,1,'2023-03-06 09:27:56','2023-03-06 09:27:56',NULL),(2576,7768,40728,13789,2,1895,'App\\Models\\Receipt',1895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',236384.44,NULL,NULL,1,'2023-03-06 09:27:56','2023-03-06 09:27:56',NULL),(2577,7768,40728,13789,2,1896,'App\\Models\\Receipt',1896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',30732.31,NULL,NULL,1,'2023-03-06 09:27:57','2023-03-06 09:27:57',NULL),(2578,7768,40728,13789,2,1897,'App\\Models\\Receipt',1897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',55980.07,NULL,NULL,1,'2023-03-06 09:27:57','2023-03-06 09:27:57',NULL),(2579,7768,40728,13789,2,1898,'App\\Models\\Receipt',1898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',85344.69,NULL,NULL,1,'2023-03-06 09:27:57','2023-03-06 09:27:57',NULL),(2580,7768,40728,13789,2,1899,'App\\Models\\Receipt',1899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',2232489.93,NULL,NULL,1,'2023-03-06 09:27:57','2023-03-06 09:27:57',NULL);
INSERT INTO `balance_libro` VALUES (2581,7768,40728,13789,2,1900,'App\\Models\\Receipt',1900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',2232489.93,NULL,NULL,1,'2023-03-06 09:27:57','2023-03-06 09:27:57',NULL),(2582,7768,40728,13789,2,1901,'App\\Models\\Receipt',1901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',1899902.80,NULL,NULL,1,'2023-03-06 09:27:57','2023-03-06 09:27:57',NULL),(2583,7768,40728,13789,2,1902,'App\\Models\\Receipt',1902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',136236.32,NULL,NULL,1,'2023-03-06 09:27:57','2023-03-06 09:27:57',NULL),(2584,7768,40728,13789,3,1903,'App\\Models\\Receipt',1903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',48400.00,NULL,NULL,1,'2023-03-15 17:28:16','2023-03-15 17:28:16',NULL),(2585,7768,40728,13789,3,1904,'App\\Models\\Receipt',1904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',14641.00,NULL,NULL,1,'2023-03-15 17:28:17','2023-03-15 17:28:17',NULL),(2586,7768,40728,13789,3,1905,'App\\Models\\Receipt',1905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',3000.00,NULL,NULL,1,'2023-03-15 17:28:17','2023-03-15 17:28:17',NULL),(2587,7768,40728,13789,3,1906,'App\\Models\\Receipt',1906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',30754.50,NULL,NULL,1,'2023-03-15 17:28:17','2023-03-15 17:28:17',NULL),(2588,7768,40728,13789,3,1907,'App\\Models\\Receipt',1907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',5523.76,NULL,NULL,1,'2023-03-15 17:28:17','2023-03-15 17:28:17',NULL),(2589,7768,40728,13789,3,1908,'App\\Models\\Receipt',1908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',50200.00,NULL,NULL,1,'2023-03-15 17:28:17','2023-03-15 17:28:17',NULL),(2590,7768,40728,13789,3,1909,'App\\Models\\Receipt',1909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',21500.00,NULL,NULL,1,'2023-03-15 17:28:17','2023-03-15 17:28:17',NULL),(2591,7768,40728,13789,3,1910,'App\\Models\\Receipt',1910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',13112.17,NULL,NULL,1,'2023-03-15 17:28:17','2023-03-15 17:28:17',NULL),(2592,7768,40728,13789,3,1911,'App\\Models\\Receipt',1911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',189242.80,NULL,NULL,1,'2023-03-15 17:28:17','2023-03-15 17:28:17',NULL),(2593,7768,40728,13789,3,1912,'App\\Models\\Receipt',1912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',47218.17,NULL,NULL,1,'2023-03-15 17:28:17','2023-03-19 13:00:19','2023-03-19 13:00:19'),(2594,7768,40728,13789,3,1913,'App\\Models\\Receipt',1913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',22000.00,NULL,NULL,1,'2023-03-15 17:28:17','2023-03-15 17:28:17',NULL),(2595,7768,40728,13789,3,1914,'App\\Models\\Receipt',1914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',381150.00,NULL,NULL,1,'2023-03-15 17:28:17','2023-03-15 17:28:17',NULL),(2596,7768,40728,13789,3,1915,'App\\Models\\Receipt',1915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',411400.00,NULL,NULL,1,'2023-03-15 17:28:17','2023-03-15 17:28:17',NULL),(2597,7768,40728,13789,3,1916,'App\\Models\\Receipt',1916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',5977.88,NULL,NULL,1,'2023-03-15 17:28:17','2023-03-19 13:00:39','2023-03-19 13:00:39'),(2598,7768,40728,13789,3,1917,'App\\Models\\Receipt',1917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',3348.80,NULL,NULL,1,'2023-03-15 17:28:17','2023-03-15 17:28:17',NULL),(2599,7768,40728,13789,3,1918,'App\\Models\\Receipt',1918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',7993.03,NULL,NULL,1,'2023-03-15 17:28:17','2023-03-15 17:28:17',NULL),(2600,7768,40728,13789,3,1919,'App\\Models\\Receipt',1919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',2756156.85,NULL,NULL,1,'2023-03-15 17:28:17','2023-03-15 17:28:17',NULL);
INSERT INTO `balance_libro` VALUES (2601,7768,40728,13789,3,1920,'App\\Models\\Receipt',1920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',36571.16,NULL,NULL,1,'2023-03-15 17:28:17','2023-03-15 17:28:17',NULL),(2602,7768,40728,13789,3,1921,'App\\Models\\Receipt',1921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',9300.00,NULL,NULL,1,'2023-03-15 17:28:17','2023-03-15 17:28:17',NULL),(2603,7768,40728,13789,3,1922,'App\\Models\\Receipt',1922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',25000.00,NULL,NULL,1,'2023-03-15 17:28:17','2023-03-15 17:28:17',NULL),(2604,7768,40728,13789,3,1923,'App\\Models\\Receipt',1923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',27305.91,NULL,NULL,1,'2023-03-15 17:28:17','2023-03-15 17:28:17',NULL),(2605,7768,40728,13789,3,1924,'App\\Models\\Receipt',1924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',1000.00,NULL,NULL,1,'2023-03-15 17:28:17','2023-03-15 17:28:17',NULL),(2606,7768,40728,13789,3,1925,'App\\Models\\Receipt',1925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',49687.02,NULL,NULL,1,'2023-03-15 17:28:17','2023-03-19 13:08:11','2023-03-19 13:08:11'),(2607,7768,40728,13789,3,1926,'App\\Models\\Receipt',1926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',146708.58,NULL,NULL,1,'2023-03-15 17:28:17','2023-03-19 13:08:32','2023-03-19 13:08:32'),(2608,7768,40728,13789,3,1927,'App\\Models\\Receipt',1927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',435600.00,NULL,NULL,1,'2023-03-15 17:28:17','2023-03-15 17:28:17',NULL),(2609,7768,40728,13789,3,1928,'App\\Models\\Receipt',1928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',71145.58,NULL,NULL,1,'2023-03-15 17:28:17','2023-03-15 17:28:17',NULL),(2610,7768,40728,13789,3,1929,'App\\Models\\Receipt',1929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',7087.39,NULL,NULL,1,'2023-03-15 17:28:17','2023-03-15 17:28:17',NULL),(2611,7768,40728,13789,3,1930,'App\\Models\\Receipt',1930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',10645.52,NULL,NULL,1,'2023-03-15 17:28:17','2023-03-15 17:28:17',NULL),(2612,7768,40728,13789,3,1931,'App\\Models\\Receipt',1931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',63233.75,NULL,NULL,1,'2023-03-15 17:28:17','2023-03-19 13:08:50','2023-03-19 13:08:50'),(2613,7768,40728,13789,3,1932,'App\\Models\\Receipt',1932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',21889.59,NULL,NULL,1,'2023-03-15 17:28:17','2023-03-19 13:18:24','2023-03-19 13:18:24'),(2614,7768,40728,13789,3,1933,'App\\Models\\Receipt',1933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',12100.00,NULL,NULL,1,'2023-03-15 17:28:18','2023-03-20 11:38:50','2023-03-20 11:38:50'),(2615,7768,40728,13789,3,1934,'App\\Models\\Receipt',1934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',12100.00,NULL,NULL,1,'2023-03-15 17:28:18','2023-03-20 11:38:43','2023-03-20 11:38:43'),(2616,7768,40728,13789,3,1935,'App\\Models\\Receipt',1935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',4632.49,NULL,NULL,1,'2023-03-15 17:28:18','2023-03-15 17:28:18',NULL),(2617,7768,40728,13789,3,1936,'App\\Models\\Receipt',1936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',2625.69,NULL,NULL,1,'2023-03-15 17:28:18','2023-03-15 17:28:18',NULL),(2618,7768,40728,13789,3,1937,'App\\Models\\Receipt',1937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1090.00,NULL,NULL,1,'2023-03-15 17:28:18','2023-03-15 17:28:18',NULL),(2619,7768,40728,13789,3,1938,'App\\Models\\Receipt',1938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',36875.96,NULL,NULL,1,'2023-03-15 17:28:18','2023-03-15 17:28:18',NULL),(2620,7768,40728,13789,3,1939,'App\\Models\\Receipt',1939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',38300.00,NULL,NULL,1,'2023-03-15 17:28:18','2023-03-15 17:28:18',NULL);
INSERT INTO `balance_libro` VALUES (2621,7768,40728,13789,3,1940,'App\\Models\\Receipt',1940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',7800.00,NULL,NULL,1,'2023-03-15 17:28:18','2023-03-15 17:28:18',NULL),(2622,7768,40728,13789,3,1941,'App\\Models\\Receipt',1941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',8060.47,NULL,NULL,1,'2023-03-15 17:28:18','2023-03-19 13:05:16','2023-03-19 13:05:16'),(2623,7768,40728,13776,15,845,'App\\Models\\PeriodLiquidation',NULL,845,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',161174.49,NULL,NULL,1,'2023-03-15 17:29:37','2023-03-15 17:29:37',NULL),(2624,7768,40728,13778,15,915,'App\\Models\\PeriodLiquidation',NULL,915,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',82736.52,NULL,NULL,1,'2023-03-15 17:29:46','2023-04-25 19:22:20','2023-04-25 19:22:20'),(2625,7768,40728,13777,15,815,'App\\Models\\PeriodLiquidation',NULL,815,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',150238.71,NULL,NULL,1,'2023-03-15 17:29:54','2023-03-15 17:29:54',NULL),(2626,7768,40728,13779,15,861,'App\\Models\\PeriodLiquidation',NULL,861,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',197114.03,NULL,NULL,1,'2023-03-15 17:30:11','2023-04-25 19:46:45','2023-04-25 19:46:45'),(2627,7768,40728,13780,15,972,'App\\Models\\PeriodLiquidation',NULL,972,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',275896.91,NULL,NULL,1,'2023-03-15 17:30:20','2023-03-15 17:30:20',NULL),(2628,7768,40728,13781,15,976,'App\\Models\\PeriodLiquidation',NULL,976,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',440155.55,NULL,NULL,1,'2023-03-15 17:30:27','2023-03-15 17:30:27',NULL),(2629,7768,40728,13782,15,986,'App\\Models\\PeriodLiquidation',NULL,986,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',400446.04,NULL,NULL,1,'2023-03-15 17:30:35','2023-03-15 17:30:35',NULL),(2630,7768,40728,13783,15,1099,'App\\Models\\PeriodLiquidation',NULL,1099,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',498859.32,NULL,NULL,1,'2023-03-15 17:30:43','2023-03-15 17:30:43',NULL),(2631,7768,40728,13788,16,1278,'App\\Models\\PeriodLiquidation',NULL,1278,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',130703.95,NULL,NULL,1,'2023-03-15 17:30:49','2023-03-15 17:30:49',NULL),(2632,7768,40728,13788,15,1275,'App\\Models\\PeriodLiquidation',NULL,1275,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1140851.97,NULL,NULL,1,'2023-03-15 17:32:08','2023-03-15 17:32:08',NULL),(2633,7768,40728,13788,16,1285,'App\\Models\\PeriodLiquidation',NULL,1285,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',130703.95,NULL,NULL,1,'2023-03-15 17:32:19','2023-03-15 17:32:19',NULL),(2634,7768,40728,13789,7,1942,'App\\Models\\Receipt',1942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',36494.27,NULL,NULL,1,'2023-03-15 17:36:43','2023-03-15 17:36:43',NULL),(2635,7768,40728,13789,7,1943,'App\\Models\\Receipt',1943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',306552.32,NULL,NULL,1,'2023-03-15 17:37:36','2023-03-15 17:37:36',NULL),(2636,7768,40728,13789,7,1944,'App\\Models\\Receipt',1944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',18247.13,NULL,NULL,1,'2023-03-15 17:38:01','2023-03-15 17:38:01',NULL),(2637,7768,40728,13789,7,1945,'App\\Models\\Receipt',1945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',16677.09,NULL,NULL,1,'2023-03-15 17:38:50','2023-03-15 17:38:50',NULL),(2638,7768,40728,13789,7,1946,'App\\Models\\Receipt',1946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',280175.21,NULL,NULL,1,'2023-03-15 17:39:34','2023-03-15 17:39:34',NULL),(2639,7768,40728,13789,7,1947,'App\\Models\\Receipt',1947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',28874.19,NULL,NULL,1,'2023-03-15 17:40:10','2023-03-15 17:40:10',NULL),(2640,7768,40728,13789,7,1948,'App\\Models\\Receipt',1948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',31403.35,NULL,NULL,1,'2023-03-15 17:44:16','2023-03-15 17:44:16',NULL);
INSERT INTO `balance_libro` VALUES (2641,7768,40728,13789,7,1949,'App\\Models\\Receipt',1949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',263788.16,NULL,NULL,1,'2023-03-15 17:44:46','2023-03-15 17:44:46',NULL),(2642,7768,40728,13789,7,1950,'App\\Models\\Receipt',1950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',15701.68,NULL,NULL,1,'2023-03-15 17:45:09','2023-03-15 17:45:09',NULL),(2643,7768,41322,90376,3,1951,'App\\Models\\Receipt',1951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',23973.69,NULL,NULL,1,'2023-03-17 20:26:28','2023-04-17 10:40:03','2023-04-17 10:40:03'),(2644,7768,41322,90376,3,1952,'App\\Models\\Receipt',1952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',758.00,NULL,NULL,1,'2023-03-17 20:26:28','2023-03-20 09:23:21','2023-03-20 09:23:21'),(2645,7768,41322,90376,3,1953,'App\\Models\\Receipt',1953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',17011.15,NULL,NULL,1,'2023-03-17 20:26:28','2023-04-17 10:39:57','2023-04-17 10:39:57'),(2646,7768,41322,90376,3,1954,'App\\Models\\Receipt',1954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',18838.57,NULL,NULL,1,'2023-03-17 20:26:28','2023-04-17 10:39:51','2023-04-17 10:39:51'),(2647,7768,41322,90376,3,1955,'App\\Models\\Receipt',1955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',15750.00,NULL,NULL,1,'2023-03-17 20:26:28','2023-04-17 10:39:44','2023-04-17 10:39:44'),(2648,7768,41322,90376,3,1956,'App\\Models\\Receipt',1956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',8962.91,NULL,NULL,1,'2023-03-17 20:26:28','2023-03-20 09:24:24','2023-03-20 09:24:24'),(2649,7768,40728,13789,7,1957,'App\\Models\\Receipt',1957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',27161.11,NULL,NULL,1,'2023-03-19 12:55:51','2023-03-19 12:55:51',NULL),(2650,7768,40728,13789,7,1958,'App\\Models\\Receipt',1958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',228153.31,NULL,NULL,1,'2023-03-19 12:56:25','2023-03-19 12:56:25',NULL),(2651,7768,40728,13789,7,1959,'App\\Models\\Receipt',1959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',13580.55,NULL,NULL,1,'2023-03-19 12:56:56','2023-03-19 12:56:56',NULL),(2652,7768,40728,13789,7,1960,'App\\Models\\Receipt',1960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',98840.11,NULL,NULL,1,'2023-03-19 12:58:22','2023-03-19 12:58:22',NULL),(2653,7768,40728,13789,7,1961,'App\\Models\\Receipt',1961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',830258.10,NULL,NULL,1,'2023-03-19 12:58:53','2023-03-19 12:58:53',NULL),(2654,7768,40728,13789,7,1962,'App\\Models\\Receipt',1962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',49420.05,NULL,NULL,1,'2023-03-19 12:59:15','2023-03-19 12:59:15',NULL),(2655,7768,40728,13789,3,1912,'App\\Models\\Receipt',1912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',47218.17,NULL,NULL,1,'2023-03-19 13:00:19','2023-03-19 13:00:19',NULL),(2656,7768,40728,13789,3,1916,'App\\Models\\Receipt',1916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',5977.88,NULL,NULL,1,'2023-03-19 13:00:39','2023-03-19 13:00:39',NULL),(2657,7768,40728,13789,3,1941,'App\\Models\\Receipt',1941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',6266.30,NULL,NULL,1,'2023-03-19 13:05:16','2023-03-19 13:07:11','2023-03-19 13:07:11'),(2658,7768,40728,13789,3,1941,'App\\Models\\Receipt',1941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',6137.95,NULL,NULL,1,'2023-03-19 13:07:11','2023-03-19 13:07:11',NULL),(2659,7768,40728,13789,3,1925,'App\\Models\\Receipt',1925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',49687.02,NULL,NULL,1,'2023-03-19 13:08:11','2023-03-19 13:08:11',NULL),(2660,7768,40728,13789,3,1926,'App\\Models\\Receipt',1926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',146708.58,NULL,NULL,1,'2023-03-19 13:08:32','2023-03-19 13:08:32',NULL);
INSERT INTO `balance_libro` VALUES (2661,7768,40728,13789,3,1931,'App\\Models\\Receipt',1931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',63233.75,NULL,NULL,1,'2023-03-19 13:08:50','2023-03-19 13:08:50',NULL),(2662,7768,40728,13789,3,1932,'App\\Models\\Receipt',1932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',21889.59,NULL,NULL,1,'2023-03-19 13:18:24','2023-03-19 13:18:24',NULL),(2732,7768,41297,87329,2,2032,'App\\Models\\Receipt',2032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',117464.07,NULL,NULL,1,'2023-03-19 16:23:09','2023-03-19 16:23:09',NULL),(2733,7768,41297,87329,2,2033,'App\\Models\\Receipt',2033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',966524.95,NULL,NULL,1,'2023-03-19 16:23:09','2023-03-19 16:23:09',NULL),(2734,7768,41297,87329,2,2034,'App\\Models\\Receipt',2034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',164561.46,NULL,NULL,1,'2023-03-19 16:23:09','2023-03-19 16:23:09',NULL),(2735,7768,41297,87329,2,2035,'App\\Models\\Receipt',2035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',651322.46,NULL,NULL,1,'2023-03-19 16:23:09','2023-03-19 16:23:09',NULL),(2736,7768,41297,87329,2,2036,'App\\Models\\Receipt',2036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',2300314.72,NULL,NULL,1,'2023-03-19 16:23:09','2023-03-19 16:23:09',NULL),(2737,7768,41297,87329,2,2037,'App\\Models\\Receipt',2037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',2476495.34,NULL,NULL,1,'2023-03-19 16:23:09','2023-03-19 16:23:09',NULL),(2738,7768,41297,87329,2,2038,'App\\Models\\Receipt',2038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',2017790.34,NULL,NULL,1,'2023-03-19 16:23:09','2023-03-19 16:23:09',NULL),(2739,7768,41297,87329,2,2039,'App\\Models\\Receipt',2039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',2124038.96,NULL,NULL,1,'2023-03-19 16:23:09','2023-03-19 16:23:09',NULL),(2740,7768,41297,87329,2,2040,'App\\Models\\Receipt',2040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',2436934.90,NULL,NULL,1,'2023-03-19 16:23:10','2023-03-19 16:23:10',NULL),(2741,7768,41297,87329,2,2041,'App\\Models\\Receipt',2041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',360773.09,NULL,NULL,1,'2023-03-19 16:23:10','2023-03-19 16:23:10',NULL),(2742,7768,41297,87329,2,2042,'App\\Models\\Receipt',2042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',1187048.28,NULL,NULL,1,'2023-03-19 16:23:10','2023-03-19 16:23:10',NULL),(2743,7768,41297,87329,2,2043,'App\\Models\\Receipt',2043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',4987262.13,NULL,NULL,1,'2023-03-19 16:23:10','2023-03-19 16:23:10',NULL),(2744,7768,41297,87329,2,2044,'App\\Models\\Receipt',2044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',19138927.09,NULL,NULL,1,'2023-03-19 16:23:10','2023-03-19 16:23:10',NULL),(2745,7768,41297,87329,2,2045,'App\\Models\\Receipt',2045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',5135094.80,NULL,NULL,1,'2023-03-19 16:23:10','2023-03-19 16:23:10',NULL),(2815,7768,41297,87329,3,2115,'App\\Models\\Receipt',2115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',3124.80,NULL,NULL,1,'2023-03-19 16:27:51','2023-03-19 16:27:51',NULL),(2816,7768,41297,87329,3,2116,'App\\Models\\Receipt',2116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',15065.15,NULL,NULL,1,'2023-03-19 16:27:51','2023-03-19 16:27:51',NULL),(2817,7768,41297,87329,3,2117,'App\\Models\\Receipt',2117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',77356.11,NULL,NULL,1,'2023-03-19 16:27:51','2023-03-19 16:27:51',NULL),(2818,7768,41297,87329,3,2118,'App\\Models\\Receipt',2118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',396689.62,NULL,NULL,1,'2023-03-19 16:27:51','2023-03-19 16:27:51',NULL);
INSERT INTO `balance_libro` VALUES (2819,7768,41297,87329,3,2119,'App\\Models\\Receipt',2119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',162523.75,NULL,NULL,1,'2023-03-19 16:27:51','2023-03-19 16:27:51',NULL),(2820,7768,41297,87329,3,2120,'App\\Models\\Receipt',2120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',357201.85,NULL,NULL,1,'2023-03-19 16:27:51','2023-03-19 16:27:51',NULL),(2821,7768,41297,87329,3,2121,'App\\Models\\Receipt',2121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',19410.36,NULL,NULL,1,'2023-03-19 16:27:51','2023-03-19 16:27:51',NULL),(2822,7768,41297,87329,3,2122,'App\\Models\\Receipt',2122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',88889.24,NULL,NULL,1,'2023-03-19 16:27:51','2023-03-19 16:27:51',NULL),(2823,7768,41297,87329,3,2123,'App\\Models\\Receipt',2123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',345749.31,NULL,NULL,1,'2023-03-19 16:27:51','2023-03-19 16:27:51',NULL),(2824,7768,41297,87329,3,2124,'App\\Models\\Receipt',2124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',169136.17,NULL,NULL,1,'2023-03-19 16:27:51','2023-03-19 16:27:51',NULL),(2825,7768,41297,87329,3,2125,'App\\Models\\Receipt',2125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',96879.01,NULL,NULL,1,'2023-03-19 16:27:51','2023-03-19 16:27:51',NULL),(2826,7768,41297,87329,3,2126,'App\\Models\\Receipt',2126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',140035.50,NULL,NULL,1,'2023-03-19 16:27:51','2023-03-19 16:27:51',NULL),(2827,7768,41297,87329,3,2127,'App\\Models\\Receipt',2127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',81196.50,NULL,NULL,1,'2023-03-19 16:27:51','2023-03-19 16:27:51',NULL),(2828,7768,41297,87329,3,2128,'App\\Models\\Receipt',2128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',82251.01,NULL,NULL,1,'2023-03-19 16:27:51','2023-03-19 16:27:51',NULL),(2829,7768,41297,87329,3,2129,'App\\Models\\Receipt',2129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',85871.10,NULL,NULL,1,'2023-03-19 16:27:51','2023-03-19 16:27:51',NULL),(2830,7768,41297,87329,3,2130,'App\\Models\\Receipt',2130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',48995.00,NULL,NULL,1,'2023-03-19 16:27:51','2023-03-19 16:27:51',NULL),(2831,7768,41297,87329,3,2131,'App\\Models\\Receipt',2131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-06','2022-11-06',85968.99,NULL,NULL,1,'2023-03-19 16:27:52','2023-03-19 16:27:52',NULL),(2832,7768,41297,87329,3,2132,'App\\Models\\Receipt',2132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',98987.01,NULL,NULL,1,'2023-03-19 16:27:52','2023-03-19 16:27:52',NULL),(2833,7768,41297,87329,3,2133,'App\\Models\\Receipt',2133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-27','2022-11-27',106800.00,NULL,NULL,1,'2023-03-19 16:27:52','2023-03-19 16:27:52',NULL),(2834,7768,41297,87329,3,2134,'App\\Models\\Receipt',2134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',85463.01,NULL,NULL,1,'2023-03-19 16:27:52','2023-03-19 16:27:52',NULL),(2835,7768,41297,87329,3,2135,'App\\Models\\Receipt',2135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',96939.99,NULL,NULL,1,'2023-03-19 16:27:52','2023-03-19 16:27:52',NULL),(2836,7768,41297,87329,3,2136,'App\\Models\\Receipt',2136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',85326.00,NULL,NULL,1,'2023-03-19 16:27:52','2023-03-19 16:27:52',NULL),(2837,7768,41297,87329,3,2137,'App\\Models\\Receipt',2137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',91629.99,NULL,NULL,1,'2023-03-19 16:27:52','2023-03-19 16:27:52',NULL),(2838,7768,41297,87329,3,2138,'App\\Models\\Receipt',2138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',85650.01,NULL,NULL,1,'2023-03-19 16:27:52','2023-03-19 16:27:52',NULL);
INSERT INTO `balance_libro` VALUES (2839,7768,41297,87329,3,2139,'App\\Models\\Receipt',2139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',100696.20,NULL,NULL,1,'2023-03-19 16:27:52','2023-03-19 16:27:52',NULL),(2840,7768,41297,87329,3,2140,'App\\Models\\Receipt',2140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',117056.23,NULL,NULL,1,'2023-03-19 16:27:52','2023-03-19 16:27:52',NULL),(2841,7768,41297,87329,3,2141,'App\\Models\\Receipt',2141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',73871.09,NULL,NULL,1,'2023-03-19 16:27:52','2023-03-19 16:27:52',NULL),(2842,7768,41297,87329,3,2142,'App\\Models\\Receipt',2142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-18','2022-09-18',92000.00,NULL,NULL,1,'2023-03-19 16:27:52','2023-03-19 16:27:52',NULL),(2843,7768,41297,87329,3,2143,'App\\Models\\Receipt',2143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-25','2022-09-25',93214.00,NULL,NULL,1,'2023-03-19 16:27:52','2023-03-19 16:27:52',NULL),(2844,7768,41297,87329,3,2144,'App\\Models\\Receipt',2144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',98693.00,NULL,NULL,1,'2023-03-19 16:27:52','2023-03-19 16:27:52',NULL),(2845,7768,41297,87329,3,2145,'App\\Models\\Receipt',2145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',114056.61,NULL,NULL,1,'2023-03-19 16:27:52','2023-03-19 16:27:52',NULL),(2846,7768,41297,87329,3,2146,'App\\Models\\Receipt',2146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',121131.00,NULL,NULL,1,'2023-03-19 16:27:52','2023-03-19 16:27:52',NULL),(2847,7768,41297,87329,3,2147,'App\\Models\\Receipt',2147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',66349.50,NULL,NULL,1,'2023-03-19 16:27:52','2023-03-19 16:27:52',NULL),(2848,7768,41297,87329,3,2148,'App\\Models\\Receipt',2148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',86700.00,NULL,NULL,1,'2023-03-19 16:27:52','2023-03-19 16:27:52',NULL),(2849,7768,41297,87329,3,2149,'App\\Models\\Receipt',2149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-15','2022-05-15',79432.50,NULL,NULL,1,'2023-03-19 16:27:52','2023-03-19 16:27:52',NULL),(2850,7768,41297,87329,3,2150,'App\\Models\\Receipt',2150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',123579.20,NULL,NULL,1,'2023-03-19 16:27:52','2023-03-19 16:27:52',NULL),(2851,7768,41297,87329,3,2151,'App\\Models\\Receipt',2151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-24','2022-04-24',58017.00,NULL,NULL,1,'2023-03-19 16:27:52','2023-03-19 16:27:52',NULL),(2852,7768,41297,87329,3,2152,'App\\Models\\Receipt',2152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',55121.50,NULL,NULL,1,'2023-03-19 16:27:52','2023-03-19 16:27:52',NULL),(2853,7768,41297,87329,3,2153,'App\\Models\\Receipt',2153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-16','2022-04-16',13639.51,NULL,NULL,1,'2023-03-19 16:27:52','2023-03-19 16:27:52',NULL),(2854,7768,41297,87329,3,2154,'App\\Models\\Receipt',2154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',84579.01,NULL,NULL,1,'2023-03-19 16:27:52','2023-03-19 16:27:52',NULL),(2855,7768,41297,87329,3,2155,'App\\Models\\Receipt',2155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',112924.91,NULL,NULL,1,'2023-03-19 16:27:52','2023-03-19 16:27:52',NULL),(2856,7768,41297,87329,3,2156,'App\\Models\\Receipt',2156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',80923.20,NULL,NULL,1,'2023-03-19 16:27:52','2023-03-19 16:27:52',NULL),(2857,7768,41297,87329,3,2157,'App\\Models\\Receipt',2157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-26','2022-06-26',132379.80,NULL,NULL,1,'2023-03-19 16:27:52','2023-03-19 16:27:52',NULL),(2858,7768,41297,87329,3,2158,'App\\Models\\Receipt',2158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',118526.10,NULL,NULL,1,'2023-03-19 16:27:53','2023-03-19 16:27:53',NULL);
INSERT INTO `balance_libro` VALUES (2859,7768,41297,87329,3,2159,'App\\Models\\Receipt',2159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-18','2022-06-18',92080.20,NULL,NULL,1,'2023-03-19 16:27:53','2023-03-19 16:27:53',NULL),(2860,7768,41297,87329,3,2160,'App\\Models\\Receipt',2160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-05','2022-06-05',37736.39,NULL,NULL,1,'2023-03-19 16:27:53','2023-03-19 16:27:53',NULL),(2861,7768,41297,87329,3,2161,'App\\Models\\Receipt',2161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-04','2022-06-04',81093.00,NULL,NULL,1,'2023-03-19 16:27:53','2023-03-19 16:27:53',NULL),(2862,7768,41297,87329,3,2162,'App\\Models\\Receipt',2162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',71460.40,NULL,NULL,1,'2023-03-19 16:27:53','2023-03-19 16:27:53',NULL),(2863,7768,41297,87329,3,2163,'App\\Models\\Receipt',2163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',89925.00,NULL,NULL,1,'2023-03-19 16:27:53','2023-03-19 16:27:53',NULL),(2864,7768,41297,87329,3,2164,'App\\Models\\Receipt',2164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',65121.00,NULL,NULL,1,'2023-03-19 16:27:53','2023-03-19 16:27:53',NULL),(2865,7768,41297,87329,3,2165,'App\\Models\\Receipt',2165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-06','2022-03-06',109633.35,NULL,NULL,1,'2023-03-19 16:27:53','2023-03-19 16:27:53',NULL),(2866,7768,41297,87329,3,2166,'App\\Models\\Receipt',2166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',63038.50,NULL,NULL,1,'2023-03-19 16:27:53','2023-03-19 16:27:53',NULL),(2867,7768,41297,87329,3,2167,'App\\Models\\Receipt',2167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',64988.10,NULL,NULL,1,'2023-03-19 16:27:53','2023-03-19 16:27:53',NULL),(2868,7768,41297,87329,3,2168,'App\\Models\\Receipt',2168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',63127.50,NULL,NULL,1,'2023-03-19 16:27:53','2023-03-19 16:27:53',NULL),(2869,7768,41297,87329,3,2169,'App\\Models\\Receipt',2169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',66450.00,NULL,NULL,1,'2023-03-19 16:27:53','2023-03-19 16:27:53',NULL),(2870,7768,41297,87329,3,2170,'App\\Models\\Receipt',2170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-13','2022-02-13',191508.90,NULL,NULL,1,'2023-03-19 16:27:53','2023-03-19 16:27:53',NULL),(2871,7768,41297,87329,3,2171,'App\\Models\\Receipt',2171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',65253.90,NULL,NULL,1,'2023-03-19 16:27:53','2023-03-19 16:27:53',NULL),(2872,7768,41297,87329,3,2172,'App\\Models\\Receipt',2172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',64075.00,NULL,NULL,1,'2023-03-19 16:27:53','2023-03-19 16:27:53',NULL),(2873,7768,41297,87329,3,2173,'App\\Models\\Receipt',2173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',75026.00,NULL,NULL,1,'2023-03-19 16:27:53','2023-03-19 16:27:53',NULL),(2874,7768,41297,87329,3,2174,'App\\Models\\Receipt',2174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-16','2022-01-16',48347.50,NULL,NULL,1,'2023-03-19 16:27:53','2023-03-19 16:27:53',NULL),(2875,7768,41297,87329,3,2175,'App\\Models\\Receipt',2175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',151217.01,NULL,NULL,1,'2023-03-19 16:27:53','2023-03-19 16:27:53',NULL),(2876,7768,41297,87329,3,2176,'App\\Models\\Receipt',2176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',83181.01,NULL,NULL,1,'2023-03-19 16:27:53','2023-03-19 16:27:53',NULL),(2877,7768,41297,87329,3,2177,'App\\Models\\Receipt',2177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-30','2022-01-30',92035.00,NULL,NULL,1,'2023-03-19 16:27:53','2023-03-19 16:27:53',NULL),(2878,7768,41297,87329,3,2178,'App\\Models\\Receipt',2178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',55136.11,NULL,NULL,1,'2023-03-19 16:27:53','2023-03-19 16:27:53',NULL),(2879,7768,41297,87329,3,2179,'App\\Models\\Receipt',2179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',14370.25,NULL,NULL,1,'2023-03-19 16:27:53','2023-03-19 16:27:53',NULL);
INSERT INTO `balance_libro` VALUES (2880,7768,41297,87329,3,2180,'App\\Models\\Receipt',2180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',16555.93,NULL,NULL,1,'2023-03-19 16:27:53','2023-03-19 16:27:53',NULL),(2881,7768,41297,87329,3,2181,'App\\Models\\Receipt',2181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',9466.68,NULL,NULL,1,'2023-03-19 16:27:53','2023-03-19 16:27:53',NULL),(2882,7768,41297,87329,3,2182,'App\\Models\\Receipt',2182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',15192.43,NULL,NULL,1,'2023-03-19 16:27:53','2023-03-19 16:27:53',NULL),(2883,7768,41297,87329,3,2183,'App\\Models\\Receipt',2183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',15192.43,NULL,NULL,1,'2023-03-19 16:27:53','2023-03-19 16:27:53',NULL),(2884,7768,41297,87329,3,2184,'App\\Models\\Receipt',2184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',18403.08,NULL,NULL,1,'2023-03-19 16:27:53','2023-03-19 16:27:53',NULL),(2885,7768,41297,87329,3,2185,'App\\Models\\Receipt',2185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',17656.77,NULL,NULL,1,'2023-03-19 16:27:53','2023-03-19 16:27:53',NULL),(2886,7768,41297,87329,3,2186,'App\\Models\\Receipt',2186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',13892.94,NULL,NULL,1,'2023-03-19 16:27:53','2023-03-19 16:27:53',NULL),(2887,7768,41297,87329,3,2187,'App\\Models\\Receipt',2187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',16501.58,NULL,NULL,1,'2023-03-19 16:27:53','2023-03-19 16:27:53',NULL),(2888,7768,41297,87329,3,2188,'App\\Models\\Receipt',2188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-25','2022-12-25',19701.19,NULL,NULL,1,'2023-03-19 16:27:53','2023-03-19 16:27:53',NULL),(2889,7768,41297,87329,3,2189,'App\\Models\\Receipt',2189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',14930.29,NULL,NULL,1,'2023-03-19 16:27:54','2023-03-19 16:27:54',NULL),(2890,7768,41297,87329,3,2190,'App\\Models\\Receipt',2190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',18202.80,NULL,NULL,1,'2023-03-19 16:27:54','2023-03-19 16:27:54',NULL),(2891,7768,41297,87329,3,2191,'App\\Models\\Receipt',2191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',14240.90,NULL,NULL,1,'2023-03-19 16:27:54','2023-03-19 16:27:54',NULL),(2892,7768,41297,87329,3,2192,'App\\Models\\Receipt',2192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',17190.50,NULL,NULL,1,'2023-03-19 16:27:54','2023-03-19 16:27:54',NULL),(2893,7768,41297,87329,3,2193,'App\\Models\\Receipt',2193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',25147.39,NULL,NULL,1,'2023-03-19 16:27:54','2023-03-19 16:27:54',NULL),(2894,7768,41297,87329,3,2194,'App\\Models\\Receipt',2194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',17651.77,NULL,NULL,1,'2023-03-19 16:27:54','2023-03-19 16:27:54',NULL),(2895,7768,41297,87329,3,2195,'App\\Models\\Receipt',2195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',28192.19,NULL,NULL,1,'2023-03-19 16:27:54','2023-03-19 16:27:54',NULL),(2896,7768,41297,87329,3,2196,'App\\Models\\Receipt',2196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',30960.08,NULL,NULL,1,'2023-03-19 16:27:54','2023-03-19 16:27:54',NULL),(2897,7768,41297,87329,3,2197,'App\\Models\\Receipt',2197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',21150.07,NULL,NULL,1,'2023-03-19 16:27:54','2023-03-19 16:27:54',NULL),(2898,7768,41297,87329,3,2198,'App\\Models\\Receipt',2198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',15780.05,NULL,NULL,1,'2023-03-19 16:27:54','2023-03-19 16:27:54',NULL),(2899,7768,41297,87329,3,2199,'App\\Models\\Receipt',2199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',3018.26,NULL,NULL,1,'2023-03-19 16:27:54','2023-03-19 16:27:54',NULL),(2900,7768,41297,87329,3,2200,'App\\Models\\Receipt',2200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',3869.20,NULL,NULL,1,'2023-03-19 16:27:54','2023-03-19 16:27:54',NULL);
INSERT INTO `balance_libro` VALUES (2901,7768,41297,87329,3,2201,'App\\Models\\Receipt',2201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',46565.08,NULL,NULL,1,'2023-03-19 16:27:54','2023-03-19 16:27:54',NULL),(2902,7768,41297,87329,3,2202,'App\\Models\\Receipt',2202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',50335.27,NULL,NULL,1,'2023-03-19 16:27:54','2023-03-19 16:27:54',NULL),(2903,7768,41297,87329,3,2203,'App\\Models\\Receipt',2203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',40825.30,NULL,NULL,1,'2023-03-19 16:27:54','2023-03-19 16:27:54',NULL),(2904,7768,41297,87329,3,2204,'App\\Models\\Receipt',2204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',43130.45,NULL,NULL,1,'2023-03-19 16:27:54','2023-03-19 16:27:54',NULL),(2905,7768,41297,87329,3,2205,'App\\Models\\Receipt',2205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',49231.01,NULL,NULL,1,'2023-03-19 16:27:54','2023-03-19 16:27:54',NULL),(2906,7768,41297,87329,3,2206,'App\\Models\\Receipt',2206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',62340.78,NULL,NULL,1,'2023-03-19 16:27:54','2023-03-19 16:27:54',NULL),(2907,7768,41297,87329,3,2207,'App\\Models\\Receipt',2207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',239236.59,NULL,NULL,1,'2023-03-19 16:27:54','2023-03-19 16:27:54',NULL),(2908,7768,41297,87329,3,2208,'App\\Models\\Receipt',2208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',7325.34,NULL,NULL,1,'2023-03-19 16:27:54','2023-03-19 16:27:54',NULL),(2909,7768,41297,87329,3,2209,'App\\Models\\Receipt',2209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',4003.15,NULL,NULL,1,'2023-03-19 16:27:54','2023-03-19 16:27:54',NULL),(2910,7768,41297,87329,3,2210,'App\\Models\\Receipt',2210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',14472.70,NULL,NULL,1,'2023-03-19 16:27:54','2023-03-19 16:27:54',NULL),(2911,7768,41297,87329,3,2211,'App\\Models\\Receipt',2211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',5000.00,NULL,NULL,1,'2023-03-19 16:27:54','2023-03-19 16:27:54',NULL),(2912,7768,41297,87329,3,2212,'App\\Models\\Receipt',2212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',32671.95,NULL,NULL,1,'2023-03-19 16:27:54','2023-03-19 16:27:54',NULL),(2913,7768,41297,87329,3,2213,'App\\Models\\Receipt',2213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',117982.04,NULL,NULL,1,'2023-03-19 16:27:54','2023-03-19 16:27:54',NULL),(2914,7768,41297,87329,3,2214,'App\\Models\\Receipt',2214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',99187.04,NULL,NULL,1,'2023-03-19 16:27:54','2023-03-19 16:27:54',NULL),(2915,7768,41297,87329,3,2215,'App\\Models\\Receipt',2215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',64312.22,NULL,NULL,1,'2023-03-19 16:27:54','2023-03-19 16:27:54',NULL),(2916,7768,41297,87329,3,2216,'App\\Models\\Receipt',2216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',5166791.78,NULL,NULL,1,'2023-03-19 16:27:54','2023-03-19 16:27:54',NULL),(2917,7768,41297,87329,3,2217,'App\\Models\\Receipt',2217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',4020.60,NULL,NULL,1,'2023-03-19 16:27:54','2023-03-19 16:27:54',NULL),(2918,7768,41297,87329,3,2218,'App\\Models\\Receipt',2218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',20032.96,NULL,NULL,1,'2023-03-19 16:27:54','2023-03-19 16:27:54',NULL),(2919,7768,41297,87329,3,2219,'App\\Models\\Receipt',2219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',2070499.89,NULL,NULL,1,'2023-03-19 16:27:54','2023-03-19 16:27:54',NULL),(2920,7768,41297,87329,3,2220,'App\\Models\\Receipt',2220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',1040.60,NULL,NULL,1,'2023-03-19 16:27:55','2023-03-19 16:27:55',NULL),(2921,7768,41297,87329,3,2221,'App\\Models\\Receipt',2221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',14935.58,NULL,NULL,1,'2023-03-19 16:27:55','2023-03-19 16:27:55',NULL);
INSERT INTO `balance_libro` VALUES (2922,7768,41297,87329,3,2222,'App\\Models\\Receipt',2222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',2189122.33,NULL,NULL,1,'2023-03-19 16:27:55','2023-03-19 16:27:55',NULL),(2923,7768,41297,87329,3,2223,'App\\Models\\Receipt',2223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',379134.97,NULL,NULL,1,'2023-03-19 16:27:55','2023-03-19 16:27:55',NULL),(2924,7768,41297,87329,3,2224,'App\\Models\\Receipt',2224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',45156.45,NULL,NULL,1,'2023-03-19 16:27:55','2023-03-19 16:27:55',NULL),(2925,7768,41297,87329,3,2225,'App\\Models\\Receipt',2225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',33201.32,NULL,NULL,1,'2023-03-19 16:27:55','2023-03-19 16:27:55',NULL),(2926,7768,41297,87329,3,2226,'App\\Models\\Receipt',2226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',526.33,NULL,NULL,1,'2023-03-19 16:27:55','2023-03-19 16:27:55',NULL),(2927,7768,41297,87329,3,2227,'App\\Models\\Receipt',2227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',5218058.96,NULL,NULL,1,'2023-03-19 16:27:55','2023-03-19 16:27:55',NULL),(2928,7768,41297,87329,3,2228,'App\\Models\\Receipt',2228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',270678.96,NULL,NULL,1,'2023-03-19 16:27:55','2023-03-19 16:27:55',NULL),(2929,7768,41297,87329,3,2229,'App\\Models\\Receipt',2229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',294890.11,NULL,NULL,1,'2023-03-19 16:27:55','2023-03-19 16:27:55',NULL),(2930,7768,41297,87329,3,2230,'App\\Models\\Receipt',2230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',314567.39,NULL,NULL,1,'2023-03-19 16:27:55','2023-03-19 16:27:55',NULL),(2931,7768,41297,87329,3,2231,'App\\Models\\Receipt',2231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',240263.72,NULL,NULL,1,'2023-03-19 16:27:55','2023-03-19 16:27:55',NULL),(2932,7768,41297,87329,3,2232,'App\\Models\\Receipt',2232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',84513.14,NULL,NULL,1,'2023-03-19 16:27:55','2023-03-19 16:27:55',NULL),(2933,7768,41297,87329,3,2233,'App\\Models\\Receipt',2233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1406.82,NULL,NULL,1,'2023-03-19 16:27:55','2023-03-19 16:27:55',NULL),(2934,7768,41297,87329,3,2234,'App\\Models\\Receipt',2234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',45426.21,NULL,NULL,1,'2023-03-19 16:27:55','2023-03-19 16:27:55',NULL),(2935,7768,41297,87329,3,2235,'App\\Models\\Receipt',2235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',91389.41,NULL,NULL,1,'2023-03-19 16:27:55','2023-03-19 16:27:55',NULL),(2936,7768,41297,87329,3,2236,'App\\Models\\Receipt',2236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1879.93,NULL,NULL,1,'2023-03-19 16:27:55','2023-03-19 16:27:55',NULL),(2937,7768,41297,87329,3,2237,'App\\Models\\Receipt',2237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',6200.72,NULL,NULL,1,'2023-03-19 16:27:55','2023-03-19 16:27:55',NULL),(2938,7768,41297,87329,3,2238,'App\\Models\\Receipt',2238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',3782.25,NULL,NULL,1,'2023-03-19 16:27:55','2023-03-19 16:27:55',NULL),(2939,7768,41297,87329,3,2239,'App\\Models\\Receipt',2239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',2532.41,NULL,NULL,1,'2023-03-19 16:27:55','2023-03-19 16:27:55',NULL),(2940,7768,41297,87329,3,2240,'App\\Models\\Receipt',2240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1459.94,NULL,NULL,1,'2023-03-19 16:27:55','2023-03-19 16:27:55',NULL),(2941,7768,41297,87329,3,2241,'App\\Models\\Receipt',2241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',9171.01,NULL,NULL,1,'2023-03-19 16:27:55','2023-03-19 16:27:55',NULL),(2942,7768,41297,87329,3,2242,'App\\Models\\Receipt',2242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',33596.51,NULL,NULL,1,'2023-03-19 16:27:55','2023-03-19 16:27:55',NULL);
INSERT INTO `balance_libro` VALUES (2943,7768,41297,87329,3,2243,'App\\Models\\Receipt',2243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',13640.81,NULL,NULL,1,'2023-03-19 16:27:55','2023-03-19 16:27:55',NULL),(2944,7768,41297,87329,3,2244,'App\\Models\\Receipt',2244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',27484.61,NULL,NULL,1,'2023-03-19 16:27:55','2023-03-19 16:27:55',NULL),(2945,7768,41297,87329,3,2245,'App\\Models\\Receipt',2245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',73848.03,NULL,NULL,1,'2023-03-19 16:27:56','2023-03-19 16:27:56',NULL),(2946,7768,41297,87329,3,2246,'App\\Models\\Receipt',2246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',17904.26,NULL,NULL,1,'2023-03-19 16:27:56','2023-03-19 16:27:56',NULL),(2947,7768,41297,87329,3,2247,'App\\Models\\Receipt',2247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',19791.16,NULL,NULL,1,'2023-03-19 16:27:56','2023-03-19 16:27:56',NULL),(2948,7768,41297,87329,3,2248,'App\\Models\\Receipt',2248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',18026.76,NULL,NULL,1,'2023-03-19 16:27:56','2023-03-19 16:27:56',NULL),(2949,7768,41297,87329,3,2249,'App\\Models\\Receipt',2249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',19426.14,NULL,NULL,1,'2023-03-19 16:27:56','2023-03-19 16:27:56',NULL),(2950,7768,41297,87329,3,2250,'App\\Models\\Receipt',2250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',301442.46,NULL,NULL,1,'2023-03-19 16:27:56','2023-03-19 16:27:56',NULL),(2951,7768,41297,87329,3,2251,'App\\Models\\Receipt',2251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',57698.63,NULL,NULL,1,'2023-03-19 16:27:56','2023-03-19 16:27:56',NULL),(2952,7768,41297,87329,3,2252,'App\\Models\\Receipt',2252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',17857.14,NULL,NULL,1,'2023-03-19 16:27:56','2023-03-19 16:27:56',NULL),(2953,7768,41297,87329,3,2253,'App\\Models\\Receipt',2253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',17673.83,NULL,NULL,1,'2023-03-19 16:27:56','2023-03-19 16:27:56',NULL),(2954,7768,41297,87329,3,2254,'App\\Models\\Receipt',2254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',17857.14,NULL,NULL,1,'2023-03-19 16:27:56','2023-03-19 16:27:56',NULL),(2955,7768,41297,87329,3,2255,'App\\Models\\Receipt',2255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',19999.55,NULL,NULL,1,'2023-03-19 16:27:56','2023-03-19 16:27:56',NULL),(2956,7768,41297,87329,3,2256,'App\\Models\\Receipt',2256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',87028.76,NULL,NULL,1,'2023-03-19 16:27:56','2023-03-19 16:27:56',NULL),(2957,7768,41297,87329,3,2257,'App\\Models\\Receipt',2257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',17857.14,NULL,NULL,1,'2023-03-19 16:27:56','2023-03-19 16:27:56',NULL),(2958,7768,41297,87329,3,2258,'App\\Models\\Receipt',2258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',20059.93,NULL,NULL,1,'2023-03-19 16:27:56','2023-03-19 16:27:56',NULL),(2959,7768,41297,87329,3,2259,'App\\Models\\Receipt',2259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',479570.54,NULL,NULL,1,'2023-03-19 16:27:56','2023-03-19 16:27:56',NULL),(2960,7768,41297,87329,3,2260,'App\\Models\\Receipt',2260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',17857.14,NULL,NULL,1,'2023-03-19 16:27:56','2023-03-19 16:27:56',NULL),(2961,7768,41297,87329,3,2261,'App\\Models\\Receipt',2261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',21054.22,NULL,NULL,1,'2023-03-19 16:27:56','2023-03-19 16:27:56',NULL),(2962,7768,41297,87329,3,2262,'App\\Models\\Receipt',2262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',97984.74,NULL,NULL,1,'2023-03-19 16:27:56','2023-03-19 16:27:56',NULL),(2963,7768,41297,87329,3,2263,'App\\Models\\Receipt',2263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',17857.14,NULL,NULL,1,'2023-03-19 16:27:56','2023-03-19 16:27:56',NULL);
INSERT INTO `balance_libro` VALUES (2964,7768,41297,87329,3,2264,'App\\Models\\Receipt',2264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',21223.97,NULL,NULL,1,'2023-03-19 16:27:56','2023-03-19 16:27:56',NULL),(2965,7768,41297,87329,3,2265,'App\\Models\\Receipt',2265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',17857.14,NULL,NULL,1,'2023-03-19 16:27:56','2023-03-19 16:27:56',NULL),(2966,7768,41297,87329,3,2266,'App\\Models\\Receipt',2266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',22091.90,NULL,NULL,1,'2023-03-19 16:27:56','2023-03-19 16:27:56',NULL),(2967,7768,41297,87329,3,2267,'App\\Models\\Receipt',2267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',17857.14,NULL,NULL,1,'2023-03-19 16:27:56','2023-03-19 16:27:56',NULL),(2968,7768,41297,87329,3,2268,'App\\Models\\Receipt',2268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-02','2022-09-02',23329.17,NULL,NULL,1,'2023-03-19 16:27:56','2023-03-19 16:27:56',NULL),(2969,7768,41297,87329,3,2269,'App\\Models\\Receipt',2269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',17857.14,NULL,NULL,1,'2023-03-19 16:27:56','2023-03-19 16:27:56',NULL),(2970,7768,41297,87329,3,2270,'App\\Models\\Receipt',2270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',24239.24,NULL,NULL,1,'2023-03-19 16:27:56','2023-03-19 16:27:56',NULL),(2971,7768,41297,87329,3,2271,'App\\Models\\Receipt',2271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',17857.14,NULL,NULL,1,'2023-03-19 16:27:56','2023-03-19 16:27:56',NULL),(2972,7768,41297,87329,3,2272,'App\\Models\\Receipt',2272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',27757.29,NULL,NULL,1,'2023-03-19 16:27:56','2023-03-19 16:27:56',NULL),(2973,7768,41297,87329,3,2273,'App\\Models\\Receipt',2273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',17857.14,NULL,NULL,1,'2023-03-19 16:27:57','2023-03-19 16:27:57',NULL),(2974,7768,41297,87329,3,2274,'App\\Models\\Receipt',2274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',28039.73,NULL,NULL,1,'2023-03-19 16:27:57','2023-03-19 16:27:57',NULL),(2975,7768,41297,87329,3,2275,'App\\Models\\Receipt',2275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',147862.00,NULL,NULL,1,'2023-03-19 16:32:55','2023-03-19 16:32:55',NULL),(2976,7768,41297,87329,3,2276,'App\\Models\\Receipt',2276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',3838.79,NULL,NULL,1,'2023-03-19 16:32:55','2023-03-19 16:32:55',NULL),(2977,7768,41297,87329,3,2277,'App\\Models\\Receipt',2277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',5150.75,NULL,NULL,1,'2023-03-19 16:32:55','2023-03-19 16:32:55',NULL),(2978,7768,41297,87329,3,2278,'App\\Models\\Receipt',2278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',10363.97,NULL,NULL,1,'2023-03-19 16:32:55','2023-03-19 16:32:55',NULL),(2979,7768,41297,87329,3,2279,'App\\Models\\Receipt',2279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',4354.85,NULL,NULL,1,'2023-03-19 16:32:55','2023-03-19 16:32:55',NULL),(2980,7768,41297,87329,3,2280,'App\\Models\\Receipt',2280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',30667.99,NULL,NULL,1,'2023-03-19 16:32:55','2023-03-19 16:32:55',NULL),(2981,7768,41297,87329,3,2281,'App\\Models\\Receipt',2281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',732.75,NULL,NULL,1,'2023-03-19 16:32:55','2023-03-19 16:32:55',NULL),(2982,7768,41297,87329,3,2282,'App\\Models\\Receipt',2282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',16439.00,NULL,NULL,1,'2023-03-19 16:32:55','2023-03-19 16:32:55',NULL),(2983,7768,41297,87329,3,2283,'App\\Models\\Receipt',2283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',422947.36,NULL,NULL,1,'2023-03-19 16:32:55','2023-03-19 16:32:55',NULL),(2984,7768,41297,87329,3,2284,'App\\Models\\Receipt',2284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',172686.36,NULL,NULL,1,'2023-03-19 16:32:55','2023-03-19 16:32:55',NULL);
INSERT INTO `balance_libro` VALUES (2985,7768,41297,87329,3,2285,'App\\Models\\Receipt',2285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',19489.98,NULL,NULL,1,'2023-03-19 16:32:55','2023-03-19 16:32:55',NULL),(2986,7768,41297,87329,3,2286,'App\\Models\\Receipt',2286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',473241.68,NULL,NULL,1,'2023-03-19 16:32:55','2023-03-19 16:32:55',NULL),(2987,7768,41297,87329,3,2287,'App\\Models\\Receipt',2287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',5000.05,NULL,NULL,1,'2023-03-19 16:32:55','2023-03-19 16:32:55',NULL),(2988,7768,41297,87329,3,2288,'App\\Models\\Receipt',2288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',65624.23,NULL,NULL,1,'2023-03-19 16:32:55','2023-03-19 16:32:55',NULL),(2989,7768,41297,87329,3,2289,'App\\Models\\Receipt',2289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',22180.00,NULL,NULL,1,'2023-03-19 16:32:55','2023-03-19 16:32:55',NULL),(2990,7768,41297,87329,3,2290,'App\\Models\\Receipt',2290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',118080.00,NULL,NULL,1,'2023-03-19 16:32:55','2023-03-19 16:32:55',NULL),(2991,7768,41297,87329,3,2291,'App\\Models\\Receipt',2291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',24041.20,NULL,NULL,1,'2023-03-19 16:32:55','2023-03-19 16:32:55',NULL),(2992,7768,41297,87329,3,2292,'App\\Models\\Receipt',2292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',2098987.00,NULL,NULL,1,'2023-03-19 16:32:55','2023-03-19 16:32:55',NULL),(2993,7768,41297,87329,3,2293,'App\\Models\\Receipt',2293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',1543405.82,NULL,NULL,1,'2023-03-19 16:32:55','2023-03-19 16:32:55',NULL),(2994,7768,41297,87329,3,2294,'App\\Models\\Receipt',2294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',702166.41,NULL,NULL,1,'2023-03-19 16:32:55','2023-03-19 16:32:55',NULL),(2995,7768,41297,87329,3,2295,'App\\Models\\Receipt',2295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',278784.00,NULL,NULL,1,'2023-03-19 16:32:56','2023-03-19 16:32:56',NULL),(2996,7768,41297,87329,3,2296,'App\\Models\\Receipt',2296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',241000.00,NULL,NULL,1,'2023-03-19 16:32:56','2023-03-19 16:32:56',NULL),(2997,7768,41297,87329,3,2297,'App\\Models\\Receipt',2297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',236300.00,NULL,NULL,1,'2023-03-19 16:32:56','2023-03-19 16:32:56',NULL),(2998,7768,41297,87329,3,2298,'App\\Models\\Receipt',2298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',10000.00,NULL,NULL,1,'2023-03-19 16:32:56','2023-03-19 16:32:56',NULL),(2999,7768,41297,87329,3,2299,'App\\Models\\Receipt',2299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',241000.00,NULL,NULL,1,'2023-03-19 16:32:56','2023-03-19 16:32:56',NULL),(3000,7768,41297,87329,3,2300,'App\\Models\\Receipt',2300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',158026.00,NULL,NULL,1,'2023-03-19 16:32:56','2023-03-19 16:32:56',NULL),(3001,7768,41297,87329,3,2301,'App\\Models\\Receipt',2301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',2235731.90,NULL,NULL,1,'2023-03-19 16:32:56','2023-03-19 16:32:56',NULL),(3002,7768,41297,87329,3,2302,'App\\Models\\Receipt',2302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',783134.77,NULL,NULL,1,'2023-03-19 16:32:56','2023-03-19 16:32:56',NULL),(3003,7768,41297,87329,3,2303,'App\\Models\\Receipt',2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',4079255.08,NULL,NULL,1,'2023-03-19 16:32:56','2023-03-19 16:32:56',NULL),(3004,7768,41297,87329,3,2304,'App\\Models\\Receipt',2304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',20100.00,NULL,NULL,1,'2023-03-19 16:32:56','2023-03-19 16:32:56',NULL);
INSERT INTO `balance_libro` VALUES (3005,7768,41297,87329,3,2305,'App\\Models\\Receipt',2305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',21979.99,NULL,NULL,1,'2023-03-19 16:32:56','2023-03-19 16:32:56',NULL),(3006,7768,41297,87329,3,2306,'App\\Models\\Receipt',2306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',24640.00,NULL,NULL,1,'2023-03-19 16:32:56','2023-03-19 16:32:56',NULL),(3007,7768,41297,87329,3,2307,'App\\Models\\Receipt',2307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',347950.02,NULL,NULL,1,'2023-03-19 16:32:56','2023-03-19 16:32:56',NULL),(3008,7768,41297,87329,3,2308,'App\\Models\\Receipt',2308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',8695.99,NULL,NULL,1,'2023-03-19 16:32:56','2023-03-19 16:32:56',NULL),(3009,7768,41297,87329,3,2309,'App\\Models\\Receipt',2309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',197974.86,NULL,NULL,1,'2023-03-19 16:32:56','2023-03-19 16:32:56',NULL),(3010,7768,41297,87329,3,2310,'App\\Models\\Receipt',2310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',352749.70,NULL,NULL,1,'2023-03-19 16:32:56','2023-03-19 16:32:56',NULL),(3011,7768,41297,87329,3,2311,'App\\Models\\Receipt',2311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',152050.54,NULL,NULL,1,'2023-03-19 16:32:56','2023-03-19 16:32:56',NULL),(3012,7768,41297,87329,3,2312,'App\\Models\\Receipt',2312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',503299.67,NULL,NULL,1,'2023-03-19 16:32:56','2023-03-19 16:32:56',NULL),(3013,7768,41297,87329,3,2313,'App\\Models\\Receipt',2313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',3053.51,NULL,NULL,1,'2023-03-19 16:32:56','2023-03-19 16:32:56',NULL),(3014,7768,41297,87329,3,2314,'App\\Models\\Receipt',2314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',1577962.47,NULL,NULL,1,'2023-03-19 16:32:56','2023-03-19 16:32:56',NULL),(3015,7768,41297,87329,3,2315,'App\\Models\\Receipt',2315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',401248.05,NULL,NULL,1,'2023-03-19 16:32:56','2023-03-19 16:32:56',NULL),(3016,7768,41297,87329,3,2316,'App\\Models\\Receipt',2316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',12562.75,NULL,NULL,1,'2023-03-19 16:32:56','2023-03-19 16:32:56',NULL),(3017,7768,41297,87329,3,2317,'App\\Models\\Receipt',2317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',422246.22,NULL,NULL,1,'2023-03-19 16:32:56','2023-03-19 16:32:56',NULL),(3018,7768,41297,87329,3,2318,'App\\Models\\Receipt',2318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',781431.19,NULL,NULL,1,'2023-03-19 16:32:56','2023-03-19 16:32:56',NULL),(3019,7768,41297,87329,3,2319,'App\\Models\\Receipt',2319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',61640.00,NULL,NULL,1,'2023-03-19 16:32:56','2023-03-19 16:32:56',NULL),(3020,7768,41297,87329,3,2320,'App\\Models\\Receipt',2320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',148843.31,NULL,NULL,1,'2023-03-19 16:32:56','2023-03-19 16:32:56',NULL),(3021,7768,41297,87329,3,2321,'App\\Models\\Receipt',2321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',4743.20,NULL,NULL,1,'2023-03-19 16:32:56','2023-03-19 16:32:56',NULL),(3022,7768,41297,87329,3,2322,'App\\Models\\Receipt',2322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',64865.64,NULL,NULL,1,'2023-03-19 16:32:56','2023-03-19 16:32:56',NULL),(3023,7768,41297,87329,3,2323,'App\\Models\\Receipt',2323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',9021.61,NULL,NULL,1,'2023-03-19 16:32:56','2023-03-19 16:32:56',NULL),(3024,7768,41297,87329,3,2324,'App\\Models\\Receipt',2324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',12661.40,NULL,NULL,1,'2023-03-19 16:32:57','2023-03-19 16:32:57',NULL),(3025,7768,41297,87329,3,2325,'App\\Models\\Receipt',2325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',1.76,NULL,NULL,1,'2023-03-19 16:32:57','2023-03-19 16:32:57',NULL);
INSERT INTO `balance_libro` VALUES (3026,7768,41297,87329,3,2326,'App\\Models\\Receipt',2326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',1977754.46,NULL,NULL,1,'2023-03-19 16:32:57','2023-03-19 16:32:57',NULL),(3027,7768,41297,87329,3,2327,'App\\Models\\Receipt',2327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',42238.32,NULL,NULL,1,'2023-03-19 16:32:57','2023-03-19 16:32:57',NULL),(3028,7768,41297,87329,3,2328,'App\\Models\\Receipt',2328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',312458.30,NULL,NULL,1,'2023-03-19 16:32:57','2023-03-19 16:32:57',NULL),(3029,7768,41297,87329,3,2329,'App\\Models\\Receipt',2329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',307283.25,NULL,NULL,1,'2023-03-19 16:32:57','2023-03-19 16:32:57',NULL),(3030,7768,41297,87329,3,2330,'App\\Models\\Receipt',2330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',90847.28,NULL,NULL,1,'2023-03-19 16:32:57','2023-03-19 16:32:57',NULL),(3031,7768,41297,87329,3,2331,'App\\Models\\Receipt',2331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',377499.74,NULL,NULL,1,'2023-03-19 16:32:57','2023-03-19 16:32:57',NULL),(3032,7768,41297,87329,3,2332,'App\\Models\\Receipt',2332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',23107.97,NULL,NULL,1,'2023-03-19 16:32:57','2023-03-19 16:32:57',NULL),(3033,7768,41297,87329,3,2333,'App\\Models\\Receipt',2333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2999.83,NULL,NULL,1,'2023-03-19 16:32:57','2023-03-19 16:32:57',NULL),(3034,7768,41297,87329,3,2334,'App\\Models\\Receipt',2334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',18382.40,NULL,NULL,1,'2023-03-19 16:32:57','2023-03-19 16:32:57',NULL),(3035,7768,41297,87329,3,2335,'App\\Models\\Receipt',2335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',7000.00,NULL,NULL,1,'2023-03-19 16:32:57','2023-03-19 16:32:57',NULL),(3036,7768,41297,87329,3,2336,'App\\Models\\Receipt',2336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',13770.00,NULL,NULL,1,'2023-03-19 16:32:57','2023-03-19 16:32:57',NULL),(3037,7768,41297,87329,3,2337,'App\\Models\\Receipt',2337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',263238.35,NULL,NULL,1,'2023-03-19 16:32:57','2023-03-19 16:32:57',NULL),(3038,7768,41297,87329,3,2338,'App\\Models\\Receipt',2338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',257856.38,NULL,NULL,1,'2023-03-19 16:32:57','2023-03-19 16:32:57',NULL),(3039,7768,41297,87329,3,2339,'App\\Models\\Receipt',2339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',90000.00,NULL,NULL,1,'2023-03-19 16:32:57','2023-03-19 16:32:57',NULL),(3040,7768,41297,87329,3,2340,'App\\Models\\Receipt',2340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',257856.38,NULL,NULL,1,'2023-03-19 16:32:57','2023-03-19 16:32:57',NULL),(3041,7768,41297,87329,3,2341,'App\\Models\\Receipt',2341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',263238.35,NULL,NULL,1,'2023-03-19 16:32:57','2023-03-19 16:32:57',NULL),(3042,7768,41297,87329,3,2342,'App\\Models\\Receipt',2342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',242774.90,NULL,NULL,1,'2023-03-19 16:32:57','2023-03-19 16:32:57',NULL),(3043,7768,41297,87329,3,2343,'App\\Models\\Receipt',2343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',242774.90,NULL,NULL,1,'2023-03-19 16:32:57','2023-03-19 16:32:57',NULL),(3044,7768,41297,87328,2,2344,'App\\Models\\Receipt',2344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',58096.50,NULL,NULL,1,'2023-03-19 16:36:45','2023-03-19 16:36:45',NULL),(3045,7768,41297,87328,2,2345,'App\\Models\\Receipt',2345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',851774.64,NULL,NULL,1,'2023-03-19 16:36:45','2023-03-19 16:36:45',NULL);
INSERT INTO `balance_libro` VALUES (3046,7768,41297,87328,2,2346,'App\\Models\\Receipt',2346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',5453104.52,NULL,NULL,1,'2023-03-19 16:36:45','2023-03-19 16:36:45',NULL),(3155,7768,41297,87328,3,2455,'App\\Models\\Receipt',2455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',2485.39,NULL,NULL,1,'2023-03-19 16:39:38','2023-03-19 16:39:38',NULL),(3156,7768,41297,87328,3,2456,'App\\Models\\Receipt',2456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',15477.74,NULL,NULL,1,'2023-03-19 16:39:38','2023-03-19 16:39:38',NULL),(3157,7768,41297,87328,3,2457,'App\\Models\\Receipt',2457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',42580.04,NULL,NULL,1,'2023-03-19 16:39:38','2023-03-19 16:39:38',NULL),(3158,7768,41297,87328,3,2458,'App\\Models\\Receipt',2458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',5296.93,NULL,NULL,1,'2023-03-19 16:39:38','2023-03-19 16:39:38',NULL),(3159,7768,41297,87328,3,2459,'App\\Models\\Receipt',2459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',2485.39,NULL,NULL,1,'2023-03-19 16:39:38','2023-03-19 16:39:38',NULL),(3160,7768,41297,87328,3,2460,'App\\Models\\Receipt',2460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',190400.00,NULL,NULL,1,'2023-03-19 16:39:38','2023-03-19 16:39:38',NULL),(3161,7768,41297,87328,3,2461,'App\\Models\\Receipt',2461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',11487.60,NULL,NULL,1,'2023-03-19 16:39:38','2023-03-19 16:39:38',NULL),(3162,7768,41297,87328,3,2462,'App\\Models\\Receipt',2462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',4969.77,NULL,NULL,1,'2023-03-19 16:39:38','2023-03-19 16:39:38',NULL),(3163,7768,41297,87328,3,2463,'App\\Models\\Receipt',2463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',17099.10,NULL,NULL,1,'2023-03-19 16:39:38','2023-03-19 16:39:38',NULL),(3164,7768,41297,87328,3,2464,'App\\Models\\Receipt',2464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',2485.39,NULL,NULL,1,'2023-03-19 16:39:38','2023-03-19 16:39:38',NULL),(3165,7768,41297,87328,3,2465,'App\\Models\\Receipt',2465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',5296.93,NULL,NULL,1,'2023-03-19 16:39:38','2023-03-19 16:39:38',NULL),(3166,7768,41297,87328,3,2466,'App\\Models\\Receipt',2466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',74511.20,NULL,NULL,1,'2023-03-19 16:39:38','2023-03-19 16:39:38',NULL),(3167,7768,41297,87328,3,2467,'App\\Models\\Receipt',2467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',8000.00,NULL,NULL,1,'2023-03-19 16:39:38','2023-03-19 16:39:38',NULL),(3168,7768,41297,87328,3,2468,'App\\Models\\Receipt',2468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',15807.00,NULL,NULL,1,'2023-03-19 16:39:38','2023-03-19 16:39:38',NULL),(3169,7768,41297,87328,3,2469,'App\\Models\\Receipt',2469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',194400.00,NULL,NULL,1,'2023-03-19 16:39:39','2023-03-19 16:39:39',NULL),(3170,7768,41297,87328,3,2470,'App\\Models\\Receipt',2470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',3000.00,NULL,NULL,1,'2023-03-19 16:39:39','2023-03-19 16:39:39',NULL),(3171,7768,41297,87328,3,2471,'App\\Models\\Receipt',2471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',16335.00,NULL,NULL,1,'2023-03-19 16:39:39','2023-03-19 16:39:39',NULL),(3172,7768,41297,87328,3,2472,'App\\Models\\Receipt',2472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',99600.00,NULL,NULL,1,'2023-03-19 16:39:39','2023-03-19 16:39:39',NULL),(3173,7768,41297,87328,3,2473,'App\\Models\\Receipt',2473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',631144.25,NULL,NULL,1,'2023-03-19 16:39:39','2023-03-19 16:39:39',NULL),(3174,7768,41297,87328,3,2474,'App\\Models\\Receipt',2474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',625722.79,NULL,NULL,1,'2023-03-19 16:39:39','2023-03-19 16:39:39',NULL);
INSERT INTO `balance_libro` VALUES (3175,7768,41297,87328,3,2475,'App\\Models\\Receipt',2475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',47323.11,NULL,NULL,1,'2023-03-19 16:39:39','2023-03-19 16:39:39',NULL),(3176,7768,41297,87328,3,2476,'App\\Models\\Receipt',2476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',17637.59,NULL,NULL,1,'2023-03-19 16:39:39','2023-03-19 16:39:39',NULL),(3177,7768,41297,87328,3,2477,'App\\Models\\Receipt',2477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',375826.00,NULL,NULL,1,'2023-03-19 16:39:39','2023-03-19 16:39:39',NULL),(3178,7768,41297,87328,3,2478,'App\\Models\\Receipt',2478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',588495.60,NULL,NULL,1,'2023-03-19 16:39:39','2023-03-19 16:39:39',NULL),(3179,7768,41297,87328,3,2479,'App\\Models\\Receipt',2479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',5876.56,NULL,NULL,1,'2023-03-19 16:39:39','2023-03-19 16:39:39',NULL),(3180,7768,41297,87328,3,2480,'App\\Models\\Receipt',2480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',11037.90,NULL,NULL,1,'2023-03-19 16:39:39','2023-03-19 16:39:39',NULL),(3181,7768,41297,87328,3,2481,'App\\Models\\Receipt',2481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',36300.00,NULL,NULL,1,'2023-03-19 16:39:39','2023-03-19 16:39:39',NULL),(3182,7768,41297,87328,3,2482,'App\\Models\\Receipt',2482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',240886.32,NULL,NULL,1,'2023-03-19 16:39:39','2023-03-19 16:39:39',NULL),(3183,7768,41297,87328,3,2483,'App\\Models\\Receipt',2483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',3147.97,NULL,NULL,1,'2023-03-19 16:39:39','2023-03-19 16:39:39',NULL),(3184,7768,41297,87328,3,2484,'App\\Models\\Receipt',2484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',8844.50,NULL,NULL,1,'2023-03-19 16:39:39','2023-03-19 16:39:39',NULL),(3185,7768,41297,87328,3,2485,'App\\Models\\Receipt',2485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',627414.04,NULL,NULL,1,'2023-03-19 16:39:39','2023-03-19 16:39:39',NULL),(3186,7768,41297,87328,3,2486,'App\\Models\\Receipt',2486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',238868.52,NULL,NULL,1,'2023-03-19 16:39:39','2023-03-19 16:39:39',NULL),(3187,7768,41297,87328,3,2487,'App\\Models\\Receipt',2487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',48950.05,NULL,NULL,1,'2023-03-19 16:39:39','2023-03-19 16:39:39',NULL),(3188,7768,41297,87328,3,2488,'App\\Models\\Receipt',2488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',773500.00,NULL,NULL,1,'2023-03-19 16:39:39','2023-03-19 16:39:39',NULL),(3189,7768,41297,87328,3,2489,'App\\Models\\Receipt',2489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',149991.60,NULL,NULL,1,'2023-03-19 16:39:39','2023-03-19 16:39:39',NULL),(3190,7768,41297,87328,3,2490,'App\\Models\\Receipt',2490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',1560900.00,NULL,NULL,1,'2023-03-19 16:39:39','2023-03-19 16:39:39',NULL),(3191,7768,41297,87328,3,2491,'App\\Models\\Receipt',2491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',15736.53,NULL,NULL,1,'2023-03-19 16:39:39','2023-03-19 16:39:39',NULL),(3192,7768,41297,87328,3,2492,'App\\Models\\Receipt',2492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-27','2022-11-27',9929.64,NULL,NULL,1,'2023-03-19 16:39:39','2023-03-19 16:39:39',NULL),(3193,7768,41297,87328,3,2493,'App\\Models\\Receipt',2493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',3800.00,NULL,NULL,1,'2023-03-19 16:39:39','2023-03-19 16:39:39',NULL),(3194,7768,41297,87328,3,2494,'App\\Models\\Receipt',2494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',51024.63,NULL,NULL,1,'2023-03-19 16:39:39','2023-03-19 16:39:39',NULL);
INSERT INTO `balance_libro` VALUES (3195,7768,41297,87328,3,2495,'App\\Models\\Receipt',2495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',24200.00,NULL,NULL,1,'2023-03-19 16:39:39','2023-03-19 16:39:39',NULL),(3196,7768,41297,87328,3,2496,'App\\Models\\Receipt',2496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',3702.60,NULL,NULL,1,'2023-03-19 16:39:40','2023-03-19 16:39:40',NULL),(3197,7768,41297,87328,3,2497,'App\\Models\\Receipt',2497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',241842.23,NULL,NULL,1,'2023-03-19 16:39:40','2023-03-19 16:39:40',NULL),(3198,7768,41297,87328,3,2498,'App\\Models\\Receipt',2498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',4990.42,NULL,NULL,1,'2023-03-19 16:39:40','2023-03-19 16:39:40',NULL),(3199,7768,41297,87328,3,2499,'App\\Models\\Receipt',2499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',42181.52,NULL,NULL,1,'2023-03-19 16:39:40','2023-03-19 16:39:40',NULL),(3200,7768,41297,87328,3,2500,'App\\Models\\Receipt',2500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',45401.84,NULL,NULL,1,'2023-03-19 16:39:40','2023-03-19 16:39:40',NULL),(3201,7768,41297,87328,3,2501,'App\\Models\\Receipt',2501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',520003.60,NULL,NULL,1,'2023-03-19 16:39:40','2023-03-19 16:39:40',NULL),(3202,7768,41297,87328,3,2502,'App\\Models\\Receipt',2502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',512730.82,NULL,NULL,1,'2023-03-19 16:39:40','2023-03-19 16:39:40',NULL),(3203,7768,41297,87328,3,2503,'App\\Models\\Receipt',2503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',809096.51,NULL,NULL,1,'2023-03-19 16:39:40','2023-03-19 16:39:40',NULL),(3204,7768,41297,87328,3,2504,'App\\Models\\Receipt',2504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',647633.14,NULL,NULL,1,'2023-03-19 16:39:40','2023-03-19 16:39:40',NULL),(3205,7768,41297,87328,3,2505,'App\\Models\\Receipt',2505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',24538.97,NULL,NULL,1,'2023-03-19 16:39:40','2023-03-19 16:39:40',NULL),(3206,7768,41297,87328,3,2506,'App\\Models\\Receipt',2506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',16432.73,NULL,NULL,1,'2023-03-19 16:39:40','2023-03-19 16:39:40',NULL),(3207,7768,41297,87328,3,2507,'App\\Models\\Receipt',2507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',5000.00,NULL,NULL,1,'2023-03-19 16:39:40','2023-03-19 16:39:40',NULL),(3208,7768,41297,87328,3,2508,'App\\Models\\Receipt',2508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',13360.00,NULL,NULL,1,'2023-03-19 16:39:40','2023-03-19 16:39:40',NULL),(3209,7768,41297,87328,3,2509,'App\\Models\\Receipt',2509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',871.45,NULL,NULL,1,'2023-03-19 16:41:05','2023-03-19 16:41:05',NULL),(3210,7768,41297,87328,3,2510,'App\\Models\\Receipt',2510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',12782.00,NULL,NULL,1,'2023-03-19 16:41:05','2023-03-19 16:41:05',NULL),(3211,7768,41297,87328,3,2511,'App\\Models\\Receipt',2511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',19912.98,NULL,NULL,1,'2023-03-19 16:41:05','2023-03-19 16:41:05',NULL),(3212,7768,41297,87328,3,2512,'App\\Models\\Receipt',2512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',28485.03,NULL,NULL,1,'2023-03-19 16:41:05','2023-03-19 16:41:05',NULL),(3213,7768,41297,87328,3,2513,'App\\Models\\Receipt',2513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',24100.18,NULL,NULL,1,'2023-03-19 16:41:05','2023-03-19 16:41:05',NULL),(3214,7768,41297,87328,3,2514,'App\\Models\\Receipt',2514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',31281.99,NULL,NULL,1,'2023-03-19 16:41:05','2023-03-19 16:41:05',NULL),(3215,7768,41297,87328,3,2515,'App\\Models\\Receipt',2515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',24035.20,NULL,NULL,1,'2023-03-19 16:41:05','2023-03-19 16:41:05',NULL);
INSERT INTO `balance_libro` VALUES (3216,7768,41297,87328,3,2516,'App\\Models\\Receipt',2516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',27220.27,NULL,NULL,1,'2023-03-19 16:41:05','2023-03-19 16:41:05',NULL),(3217,7768,41297,87328,3,2517,'App\\Models\\Receipt',2517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',26834.97,NULL,NULL,1,'2023-03-19 16:41:06','2023-03-19 16:41:06',NULL),(3218,7768,41297,87328,3,2518,'App\\Models\\Receipt',2518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',21577.16,NULL,NULL,1,'2023-03-19 16:41:06','2023-03-19 16:41:06',NULL),(3219,7768,41297,87328,3,2519,'App\\Models\\Receipt',2519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',20331.61,NULL,NULL,1,'2023-03-19 16:41:06','2023-03-19 16:41:06',NULL),(3220,7768,41297,87328,3,2520,'App\\Models\\Receipt',2520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1933-02-22','1933-02-22',16482.73,NULL,NULL,1,'2023-03-19 16:41:06','2023-03-19 16:41:06',NULL),(3221,7768,41297,87328,3,2521,'App\\Models\\Receipt',2521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',181234.63,NULL,NULL,1,'2023-03-19 16:41:06','2023-03-19 16:41:06',NULL),(3222,7768,41297,87328,3,2522,'App\\Models\\Receipt',2522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',145990.06,NULL,NULL,1,'2023-03-19 16:41:06','2023-03-19 16:41:06',NULL),(3223,7768,41297,87328,3,2523,'App\\Models\\Receipt',2523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',119078.93,NULL,NULL,1,'2023-03-19 16:41:06','2023-03-19 16:41:06',NULL),(3224,7768,41297,87328,3,2524,'App\\Models\\Receipt',2524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',5000.00,NULL,NULL,1,'2023-03-19 16:41:06','2023-03-19 16:41:06',NULL),(3225,7768,41297,87328,3,2525,'App\\Models\\Receipt',2525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',5002.94,NULL,NULL,1,'2023-03-19 16:41:06','2023-03-19 16:41:06',NULL),(3226,7768,41297,87328,3,2526,'App\\Models\\Receipt',2526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',8998.88,NULL,NULL,1,'2023-03-19 16:41:06','2023-03-19 16:41:06',NULL),(3227,7768,41297,87328,3,2527,'App\\Models\\Receipt',2527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',18805.78,NULL,NULL,1,'2023-03-19 16:41:06','2023-03-19 16:41:06',NULL),(3228,7768,41297,87328,3,2528,'App\\Models\\Receipt',2528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',17397.31,NULL,NULL,1,'2023-03-19 16:41:06','2023-03-19 16:41:06',NULL),(3229,7768,41297,87328,3,2529,'App\\Models\\Receipt',2529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',15895.32,NULL,NULL,1,'2023-03-19 16:41:06','2023-03-19 16:41:06',NULL),(3230,7768,41297,87328,3,2530,'App\\Models\\Receipt',2530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-20','2022-11-20',17403.93,NULL,NULL,1,'2023-03-19 16:41:06','2023-03-19 16:41:06',NULL),(3231,7768,41297,87328,3,2531,'App\\Models\\Receipt',2531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',14100.63,NULL,NULL,1,'2023-03-19 16:41:06','2023-03-19 16:41:06',NULL),(3232,7768,41297,87328,3,2532,'App\\Models\\Receipt',2532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',18208.43,NULL,NULL,1,'2023-03-19 16:41:06','2023-03-19 16:41:06',NULL),(3233,7768,41297,87328,3,2533,'App\\Models\\Receipt',2533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',16716.51,NULL,NULL,1,'2023-03-19 16:41:06','2023-03-19 16:41:06',NULL),(3234,7768,41297,87328,3,2534,'App\\Models\\Receipt',2534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',15002.61,NULL,NULL,1,'2023-03-19 16:41:06','2023-03-19 16:41:06',NULL),(3235,7768,41297,87328,3,2535,'App\\Models\\Receipt',2535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',112328.00,NULL,NULL,1,'2023-03-19 16:41:06','2023-03-19 16:41:06',NULL),(3236,7768,41297,87328,3,2536,'App\\Models\\Receipt',2536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',9205.29,NULL,NULL,1,'2023-03-19 16:41:06','2023-03-19 16:41:06',NULL);
INSERT INTO `balance_libro` VALUES (3237,7768,41297,87328,3,2537,'App\\Models\\Receipt',2537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',15484.95,NULL,NULL,1,'2023-03-19 16:41:06','2023-03-19 16:41:06',NULL),(3238,7768,41297,87328,3,2538,'App\\Models\\Receipt',2538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',82116.18,NULL,NULL,1,'2023-03-19 16:41:06','2023-03-19 16:41:06',NULL),(3239,7768,41297,87328,3,2539,'App\\Models\\Receipt',2539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',297058.42,NULL,NULL,1,'2023-03-19 16:41:06','2023-03-19 16:41:06',NULL),(3240,7768,41297,87328,3,2540,'App\\Models\\Receipt',2540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',197292.65,NULL,NULL,1,'2023-03-19 16:41:07','2023-03-19 16:41:07',NULL),(3241,7768,41297,87328,3,2541,'App\\Models\\Receipt',2541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',3968.00,NULL,NULL,1,'2023-03-19 16:41:07','2023-03-19 16:41:07',NULL),(3242,7768,41297,87328,3,2542,'App\\Models\\Receipt',2542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',25613.59,NULL,NULL,1,'2023-03-19 16:41:07','2023-03-19 16:41:07',NULL),(3243,7768,41297,87328,3,2543,'App\\Models\\Receipt',2543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',42156.01,NULL,NULL,1,'2023-03-19 16:41:07','2023-03-19 16:41:07',NULL),(3244,7768,41297,87328,3,2544,'App\\Models\\Receipt',2544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',1808.76,NULL,NULL,1,'2023-03-19 16:41:07','2023-03-19 16:41:07',NULL),(3245,7768,41297,87328,3,2545,'App\\Models\\Receipt',2545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',560085.62,NULL,NULL,1,'2023-03-19 16:41:07','2023-03-19 16:41:07',NULL),(3246,7768,41297,87318,2,2546,'App\\Models\\Receipt',2546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',6628073.49,NULL,NULL,1,'2023-03-19 16:51:05','2023-03-19 16:51:05',NULL),(3247,7768,41297,87318,2,2547,'App\\Models\\Receipt',2547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',2427080.48,NULL,NULL,1,'2023-03-19 16:51:05','2023-03-19 16:51:05',NULL),(3248,7768,41297,87319,2,2548,'App\\Models\\Receipt',2548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',76331.58,NULL,NULL,1,'2023-03-19 16:51:45','2023-03-19 16:51:45',NULL),(3249,7768,41297,87319,2,2549,'App\\Models\\Receipt',2549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',3269491.68,NULL,NULL,1,'2023-03-19 16:51:45','2023-03-19 16:51:45',NULL),(3250,7768,41297,87319,2,2550,'App\\Models\\Receipt',2550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',2535838.50,NULL,NULL,1,'2023-03-19 16:51:45','2023-03-19 16:51:45',NULL),(3251,7768,41297,87320,2,2551,'App\\Models\\Receipt',2551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',501847.57,NULL,NULL,1,'2023-03-19 16:52:08','2023-03-19 16:52:08',NULL),(3252,7768,41297,87320,2,2552,'App\\Models\\Receipt',2552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',7320258.42,NULL,NULL,1,'2023-03-19 16:52:08','2023-03-19 16:52:08',NULL),(3253,7768,41297,87320,2,2553,'App\\Models\\Receipt',2553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',7267328.64,NULL,NULL,1,'2023-03-19 16:52:08','2023-03-19 16:52:08',NULL),(3254,7768,41297,87320,2,2554,'App\\Models\\Receipt',2554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',19467.90,NULL,NULL,1,'2023-03-19 16:52:08','2023-04-12 22:46:28','2023-04-12 22:46:28'),(3255,7768,41297,87320,2,2555,'App\\Models\\Receipt',2555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',3005167.08,NULL,NULL,1,'2023-03-19 16:52:08','2023-03-19 16:52:08',NULL),(3256,7768,41297,87321,2,2556,'App\\Models\\Receipt',2556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',909641.25,NULL,NULL,1,'2023-03-19 16:52:31','2023-03-19 16:52:31',NULL);
INSERT INTO `balance_libro` VALUES (3257,7768,41297,87321,2,2557,'App\\Models\\Receipt',2557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',8738016.99,NULL,NULL,1,'2023-03-19 16:52:31','2023-03-19 16:52:31',NULL),(3258,7768,41297,87321,2,2558,'App\\Models\\Receipt',2558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',114552.32,NULL,NULL,1,'2023-03-19 16:52:31','2023-03-19 16:52:31',NULL),(3259,7768,41297,87321,2,2559,'App\\Models\\Receipt',2559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',3757823.27,NULL,NULL,1,'2023-03-19 16:52:31','2023-03-19 16:52:31',NULL),(3260,7768,41297,87321,2,2560,'App\\Models\\Receipt',2560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',2954832.05,NULL,NULL,1,'2023-03-19 16:52:31','2023-03-19 16:52:31',NULL),(3261,7768,41297,87322,2,2561,'App\\Models\\Receipt',2561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',2331000.15,NULL,NULL,1,'2023-03-19 16:53:01','2023-03-19 16:53:01',NULL),(3262,7768,41297,87322,2,2562,'App\\Models\\Receipt',2562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',2331000.16,NULL,NULL,1,'2023-03-19 16:53:01','2023-03-19 16:53:01',NULL),(3263,7768,41297,87322,2,2563,'App\\Models\\Receipt',2563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',4160080.24,NULL,NULL,1,'2023-03-19 16:53:01','2023-03-19 16:53:01',NULL),(3264,7768,41297,87322,2,2564,'App\\Models\\Receipt',2564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',890360.05,NULL,NULL,1,'2023-03-19 16:53:01','2023-03-19 16:53:01',NULL),(3265,7768,41297,87322,2,2565,'App\\Models\\Receipt',2565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',5083613.83,NULL,NULL,1,'2023-03-19 16:53:01','2023-03-19 16:53:01',NULL),(3266,7768,41297,87322,2,2566,'App\\Models\\Receipt',2566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',1548732.04,NULL,NULL,1,'2023-03-19 16:53:01','2023-03-19 16:53:01',NULL),(3267,7768,41297,87322,2,2567,'App\\Models\\Receipt',2567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',3309519.41,NULL,NULL,1,'2023-03-19 16:53:01','2023-03-19 16:53:01',NULL),(3268,7768,41297,87323,2,2568,'App\\Models\\Receipt',2568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',264426.26,NULL,NULL,1,'2023-03-19 16:54:08','2023-03-19 16:54:08',NULL),(3269,7768,41297,87323,2,2569,'App\\Models\\Receipt',2569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',279193.36,NULL,NULL,1,'2023-03-19 16:54:08','2023-03-19 16:54:08',NULL),(3270,7768,41297,87323,2,2570,'App\\Models\\Receipt',2570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',1158659.10,NULL,NULL,1,'2023-03-19 16:54:08','2023-03-19 16:54:08',NULL),(3271,7768,41297,87323,2,2571,'App\\Models\\Receipt',2571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',4192851.80,NULL,NULL,1,'2023-03-19 16:54:08','2023-03-19 16:54:08',NULL),(3272,7768,41297,87323,2,2572,'App\\Models\\Receipt',2572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',5086421.17,NULL,NULL,1,'2023-03-19 16:54:08','2023-03-19 16:54:08',NULL),(3273,7768,41297,87323,2,2573,'App\\Models\\Receipt',2573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',1373942.02,NULL,NULL,1,'2023-03-19 16:54:08','2023-03-19 16:54:08',NULL),(3274,7768,41297,87323,2,2574,'App\\Models\\Receipt',2574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',6482548.80,NULL,NULL,1,'2023-03-19 16:54:08','2023-03-19 16:54:08',NULL),(3275,7768,41297,87323,2,2575,'App\\Models\\Receipt',2575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',5528506.14,NULL,NULL,1,'2023-03-19 16:54:08','2023-03-19 16:54:08',NULL),(3276,7768,41297,87323,2,2576,'App\\Models\\Receipt',2576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',3306763.26,NULL,NULL,1,'2023-03-19 16:54:08','2023-03-19 16:54:08',NULL);
INSERT INTO `balance_libro` VALUES (3277,7768,41297,87324,2,2577,'App\\Models\\Receipt',2577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',4148806.50,NULL,NULL,1,'2023-03-19 16:54:39','2023-03-19 16:54:39',NULL),(3278,7768,41297,87324,2,2578,'App\\Models\\Receipt',2578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4170568.74,NULL,NULL,1,'2023-03-19 16:54:39','2023-03-19 16:54:39',NULL),(3279,7768,41297,87324,2,2579,'App\\Models\\Receipt',2579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',4148806.50,NULL,NULL,1,'2023-03-19 16:54:39','2023-03-19 16:54:39',NULL),(3280,7768,41297,87324,2,2580,'App\\Models\\Receipt',2580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',4678625.25,NULL,NULL,1,'2023-03-19 16:54:39','2023-03-19 16:54:39',NULL),(3281,7768,41297,87324,2,2581,'App\\Models\\Receipt',2581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',3119083.50,NULL,NULL,1,'2023-03-19 16:54:39','2023-03-19 16:54:39',NULL),(3282,7768,41297,87324,2,2582,'App\\Models\\Receipt',2582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',7782948.71,NULL,NULL,1,'2023-03-19 16:54:39','2023-03-19 16:54:39',NULL),(3283,7768,41297,87324,2,2583,'App\\Models\\Receipt',2583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',3060882.04,NULL,NULL,1,'2023-03-19 16:54:40','2023-03-19 16:54:40',NULL),(3284,7768,41297,87324,2,2584,'App\\Models\\Receipt',2584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2971168.20,NULL,NULL,1,'2023-03-19 16:54:40','2023-03-19 16:54:40',NULL),(3285,7768,41297,87324,2,2585,'App\\Models\\Receipt',2585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',4764906.43,NULL,NULL,1,'2023-03-19 16:54:40','2023-03-19 16:54:40',NULL),(3286,7768,41297,87325,2,2586,'App\\Models\\Receipt',2586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',346169.45,NULL,NULL,1,'2023-03-19 16:55:14','2023-03-19 16:55:14',NULL),(3287,7768,41297,87325,2,2587,'App\\Models\\Receipt',2587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',558052.62,NULL,NULL,1,'2023-03-19 16:55:14','2023-03-19 16:55:14',NULL),(3288,7768,41297,87325,2,2588,'App\\Models\\Receipt',2588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',1073014.87,NULL,NULL,1,'2023-03-19 16:55:14','2023-03-19 16:55:14',NULL),(3289,7768,41297,87325,2,2589,'App\\Models\\Receipt',2589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',1159897.68,NULL,NULL,1,'2023-03-19 16:55:15','2023-03-19 16:55:15',NULL),(3290,7768,41297,87325,2,2590,'App\\Models\\Receipt',2590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',5032806.24,NULL,NULL,1,'2023-03-19 16:55:15','2023-03-19 16:55:15',NULL),(3291,7768,41297,87326,2,2591,'App\\Models\\Receipt',2591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',1560481.00,NULL,NULL,1,'2023-03-19 16:55:49','2023-03-19 16:55:49',NULL),(3292,7768,41297,87326,2,2592,'App\\Models\\Receipt',2592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',2255526.00,NULL,NULL,1,'2023-03-19 16:55:49','2023-03-19 16:55:49',NULL),(3293,7768,41297,87326,2,2593,'App\\Models\\Receipt',2593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',2288013.00,NULL,NULL,1,'2023-03-19 16:55:49','2023-03-19 16:55:49',NULL),(3294,7768,41297,87326,2,2594,'App\\Models\\Receipt',2594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',2264208.54,NULL,NULL,1,'2023-03-19 16:55:49','2023-03-19 16:55:49',NULL),(3295,7768,41297,87326,2,2595,'App\\Models\\Receipt',2595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',5414587.62,NULL,NULL,1,'2023-03-19 16:55:49','2023-03-19 16:55:49',NULL),(3296,7768,41297,87327,2,2596,'App\\Models\\Receipt',2596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',1072385.92,NULL,NULL,1,'2023-03-19 16:56:01','2023-03-19 16:56:01',NULL);
INSERT INTO `balance_libro` VALUES (3297,7768,41297,87327,2,2597,'App\\Models\\Receipt',2597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1226108.00,NULL,NULL,1,'2023-03-19 16:56:01','2023-03-19 16:56:01',NULL),(3298,7768,41297,87327,2,2598,'App\\Models\\Receipt',2598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',5567502.34,NULL,NULL,1,'2023-03-19 16:56:01','2023-03-19 16:56:01',NULL),(3299,7768,41297,87314,15,1366,'App\\Models\\PeriodLiquidation',NULL,1366,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',4209531.05,NULL,NULL,1,'2023-03-19 16:59:47','2023-04-12 22:05:55','2023-04-12 22:05:55'),(3349,7768,41297,87318,3,2648,'App\\Models\\Receipt',2648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',26349.73,NULL,NULL,1,'2023-03-19 17:01:46','2023-03-19 17:20:35','2023-03-19 17:20:35'),(3350,7768,41297,87318,3,2649,'App\\Models\\Receipt',2649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',146166.45,NULL,NULL,1,'2023-03-19 17:01:46','2023-03-19 17:20:35','2023-03-19 17:20:35'),(3351,7768,41297,87318,3,2650,'App\\Models\\Receipt',2650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',422807.85,NULL,NULL,1,'2023-03-19 17:01:46','2023-03-19 17:20:35','2023-03-19 17:20:35'),(3352,7768,41297,87318,3,2651,'App\\Models\\Receipt',2651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',29829.89,NULL,NULL,1,'2023-03-19 17:01:46','2023-03-19 17:20:35','2023-03-19 17:20:35'),(3353,7768,41297,87318,3,2652,'App\\Models\\Receipt',2652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',1190024.58,NULL,NULL,1,'2023-03-19 17:01:46','2023-03-19 17:20:35','2023-03-19 17:20:35'),(3354,7768,41297,87318,3,2653,'App\\Models\\Receipt',2653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',109674.40,NULL,NULL,1,'2023-03-19 17:01:46','2023-03-19 17:20:35','2023-03-19 17:20:35'),(3355,7768,41297,87318,3,2654,'App\\Models\\Receipt',2654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',121994.64,NULL,NULL,1,'2023-03-19 17:01:46','2023-03-19 17:20:35','2023-03-19 17:20:35'),(3356,7768,41297,87318,3,2655,'App\\Models\\Receipt',2655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',291390.07,NULL,NULL,1,'2023-03-19 17:01:46','2023-03-19 17:20:35','2023-03-19 17:20:35'),(3357,7768,41297,87318,3,2656,'App\\Models\\Receipt',2656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',130975.85,NULL,NULL,1,'2023-03-19 17:01:46','2023-03-19 17:20:35','2023-03-19 17:20:35'),(3358,7768,41297,87318,3,2657,'App\\Models\\Receipt',2657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',12796.80,NULL,NULL,1,'2023-03-19 17:01:46','2023-03-19 17:20:35','2023-03-19 17:20:35'),(3359,7768,41297,87318,3,2658,'App\\Models\\Receipt',2658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',77088.64,NULL,NULL,1,'2023-03-19 17:01:46','2023-03-19 17:20:35','2023-03-19 17:20:35'),(3360,7768,41297,87318,3,2659,'App\\Models\\Receipt',2659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',29951.86,NULL,NULL,1,'2023-03-19 17:01:46','2023-03-19 17:20:35','2023-03-19 17:20:35'),(3361,7768,41297,87318,3,2660,'App\\Models\\Receipt',2660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',88200.00,NULL,NULL,1,'2023-03-19 17:01:46','2023-03-19 17:20:35','2023-03-19 17:20:35'),(3362,7768,41297,87318,3,2661,'App\\Models\\Receipt',2661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',2331799.29,NULL,NULL,1,'2023-03-19 17:01:46','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3363,7768,41297,87318,3,2662,'App\\Models\\Receipt',2662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',288950.42,NULL,NULL,1,'2023-03-19 17:01:46','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3364,7768,41297,87318,3,2663,'App\\Models\\Receipt',2663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',464883.94,NULL,NULL,1,'2023-03-19 17:01:46','2023-03-19 17:20:36','2023-03-19 17:20:36');
INSERT INTO `balance_libro` VALUES (3365,7768,41297,87318,3,2664,'App\\Models\\Receipt',2664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',35912.80,NULL,NULL,1,'2023-03-19 17:01:46','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3366,7768,41297,87318,3,2665,'App\\Models\\Receipt',2665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',22729680.00,NULL,NULL,1,'2023-03-19 17:01:47','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3367,7768,41297,87318,3,2666,'App\\Models\\Receipt',2666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',176800.00,NULL,NULL,1,'2023-03-19 17:01:47','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3368,7768,41297,87318,3,2667,'App\\Models\\Receipt',2667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',308079.55,NULL,NULL,1,'2023-03-19 17:01:47','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3369,7768,41297,87318,3,2668,'App\\Models\\Receipt',2668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',5000.00,NULL,NULL,1,'2023-03-19 17:01:47','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3370,7768,41297,87318,3,2669,'App\\Models\\Receipt',2669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',413802.59,NULL,NULL,1,'2023-03-19 17:01:47','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3371,7768,41297,87318,3,2670,'App\\Models\\Receipt',2670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',209950.00,NULL,NULL,1,'2023-03-19 17:01:47','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3372,7768,41297,87318,3,2671,'App\\Models\\Receipt',2671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',618247.50,NULL,NULL,1,'2023-03-19 17:01:47','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3373,7768,41297,87318,3,2672,'App\\Models\\Receipt',2672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',1046.30,NULL,NULL,1,'2023-03-19 17:01:47','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3374,7768,41297,87318,3,2673,'App\\Models\\Receipt',2673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-22','2022-01-22',9256.50,NULL,NULL,1,'2023-03-19 17:01:47','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3375,7768,41297,87318,3,2674,'App\\Models\\Receipt',2674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',10390.00,NULL,NULL,1,'2023-03-19 17:01:47','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3376,7768,41297,87318,3,2675,'App\\Models\\Receipt',2675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',1900000.00,NULL,NULL,1,'2023-03-19 17:01:47','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3377,7768,41297,87318,3,2676,'App\\Models\\Receipt',2676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',3900.07,NULL,NULL,1,'2023-03-19 17:01:47','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3378,7768,41297,87318,3,2677,'App\\Models\\Receipt',2677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',42831.18,NULL,NULL,1,'2023-03-19 17:01:47','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3379,7768,41297,87318,3,2678,'App\\Models\\Receipt',2678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',34908.84,NULL,NULL,1,'2023-03-19 17:01:47','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3380,7768,41297,87318,3,2679,'App\\Models\\Receipt',2679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',1301137.50,NULL,NULL,1,'2023-03-19 17:01:47','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3381,7768,41297,87318,3,2680,'App\\Models\\Receipt',2680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',5185.04,NULL,NULL,1,'2023-03-19 17:01:47','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3382,7768,41297,87318,3,2681,'App\\Models\\Receipt',2681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',32491.84,NULL,NULL,1,'2023-03-19 17:01:47','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3383,7768,41297,87318,3,2682,'App\\Models\\Receipt',2682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',24650.00,NULL,NULL,1,'2023-03-19 17:01:47','2023-03-19 17:20:36','2023-03-19 17:20:36');
INSERT INTO `balance_libro` VALUES (3384,7768,41297,87318,3,2683,'App\\Models\\Receipt',2683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',376511.95,NULL,NULL,1,'2023-03-19 17:01:48','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3385,7768,41297,87318,3,2684,'App\\Models\\Receipt',2684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',299921.27,NULL,NULL,1,'2023-03-19 17:01:48','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3386,7768,41297,87318,3,2685,'App\\Models\\Receipt',2685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',5106.97,NULL,NULL,1,'2023-03-19 17:01:48','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3387,7768,41297,87318,3,2686,'App\\Models\\Receipt',2686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',726.00,NULL,NULL,1,'2023-03-19 17:01:48','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3388,7768,41297,87318,3,2687,'App\\Models\\Receipt',2687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-30','2022-01-30',87361.30,NULL,NULL,1,'2023-03-19 17:01:48','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3389,7768,41297,87318,3,2688,'App\\Models\\Receipt',2688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',80867.50,NULL,NULL,1,'2023-03-19 17:01:48','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3390,7768,41297,87318,3,2689,'App\\Models\\Receipt',2689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',173077.21,NULL,NULL,1,'2023-03-19 17:01:48','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3391,7768,41297,87318,3,2690,'App\\Models\\Receipt',2690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',10921.86,NULL,NULL,1,'2023-03-19 17:01:48','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3392,7768,41297,87318,3,2691,'App\\Models\\Receipt',2691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',7770.00,NULL,NULL,1,'2023-03-19 17:01:48','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3393,7768,41297,87318,3,2692,'App\\Models\\Receipt',2692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',51757.41,NULL,NULL,1,'2023-03-19 17:01:48','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3394,7768,41297,87318,3,2693,'App\\Models\\Receipt',2693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',17661.37,NULL,NULL,1,'2023-03-19 17:01:48','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3395,7768,41297,87318,3,2694,'App\\Models\\Receipt',2694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',7540.40,NULL,NULL,1,'2023-03-19 17:01:48','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3396,7768,41297,87318,3,2695,'App\\Models\\Receipt',2695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',20000.00,NULL,NULL,1,'2023-03-19 17:01:48','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3397,7768,41297,87318,3,2696,'App\\Models\\Receipt',2696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',4300.00,NULL,NULL,1,'2023-03-19 17:01:48','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3398,7768,41297,87318,3,2697,'App\\Models\\Receipt',2697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',2900.00,NULL,NULL,1,'2023-03-19 17:01:48','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3399,7768,41297,87318,3,2698,'App\\Models\\Receipt',2698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-06','2021-08-06',52308.51,NULL,NULL,1,'2023-03-19 17:03:11','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3400,7768,41297,87318,3,2699,'App\\Models\\Receipt',2699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',43604.99,NULL,NULL,1,'2023-03-19 17:03:11','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3401,7768,41297,87318,3,2700,'App\\Models\\Receipt',2700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',43604.99,NULL,NULL,1,'2023-03-19 17:03:11','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3402,7768,41297,87318,3,2701,'App\\Models\\Receipt',2701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',37791.00,NULL,NULL,1,'2023-03-19 17:03:11','2023-03-19 17:20:36','2023-03-19 17:20:36');
INSERT INTO `balance_libro` VALUES (3403,7768,41297,87318,3,2702,'App\\Models\\Receipt',2702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',65000.00,NULL,NULL,1,'2023-03-19 17:03:11','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3404,7768,41297,87318,3,2703,'App\\Models\\Receipt',2703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-24','2021-08-24',56386.00,NULL,NULL,1,'2023-03-19 17:03:11','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3405,7768,41297,87318,3,2704,'App\\Models\\Receipt',2704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-29','2021-08-29',41474.00,NULL,NULL,1,'2023-03-19 17:03:11','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3406,7768,41297,87318,3,2705,'App\\Models\\Receipt',2705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',55003.11,NULL,NULL,1,'2023-03-19 17:03:11','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3407,7768,41297,87318,3,2706,'App\\Models\\Receipt',2706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',14918.91,NULL,NULL,1,'2023-03-19 17:03:11','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3408,7768,41297,87318,3,2707,'App\\Models\\Receipt',2707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',14499.45,NULL,NULL,1,'2023-03-19 17:03:12','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3409,7768,41297,87318,3,2708,'App\\Models\\Receipt',2708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',11375.88,NULL,NULL,1,'2023-03-19 17:03:12','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3410,7768,41297,87318,3,2709,'App\\Models\\Receipt',2709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-22','2022-01-22',10090.61,NULL,NULL,1,'2023-03-19 17:03:12','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3411,7768,41297,87318,3,2710,'App\\Models\\Receipt',2710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',12877.43,NULL,NULL,1,'2023-03-19 17:03:12','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3412,7768,41297,87318,3,2711,'App\\Models\\Receipt',2711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',7200.33,NULL,NULL,1,'2023-03-19 17:03:12','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3413,7768,41297,87318,3,2712,'App\\Models\\Receipt',2712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',2438.74,NULL,NULL,1,'2023-03-19 17:03:12','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3414,7768,41297,87318,3,2713,'App\\Models\\Receipt',2713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',7701.50,NULL,NULL,1,'2023-03-19 17:03:12','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3415,7768,41297,87318,3,2714,'App\\Models\\Receipt',2714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',1598.85,NULL,NULL,1,'2023-03-19 17:03:12','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3416,7768,41297,87318,3,2715,'App\\Models\\Receipt',2715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',7891.00,NULL,NULL,1,'2023-03-19 17:03:12','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3417,7768,41297,87318,3,2716,'App\\Models\\Receipt',2716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',8257.97,NULL,NULL,1,'2023-03-19 17:03:12','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3418,7768,41297,87318,3,2717,'App\\Models\\Receipt',2717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',7971.15,NULL,NULL,1,'2023-03-19 17:03:12','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3419,7768,41297,87318,3,2718,'App\\Models\\Receipt',2718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',7638.52,NULL,NULL,1,'2023-03-19 17:03:12','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3420,7768,41297,87318,3,2719,'App\\Models\\Receipt',2719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-02','2022-01-02',8030.11,NULL,NULL,1,'2023-03-19 17:03:12','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3421,7768,41297,87318,3,2720,'App\\Models\\Receipt',2720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',7155.01,NULL,NULL,1,'2023-03-19 17:03:12','2023-03-19 17:20:36','2023-03-19 17:20:36');
INSERT INTO `balance_libro` VALUES (3422,7768,41297,87318,3,2721,'App\\Models\\Receipt',2721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',82850.92,NULL,NULL,1,'2023-03-19 17:03:12','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3423,7768,41297,87318,3,2722,'App\\Models\\Receipt',2722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',78621.53,NULL,NULL,1,'2023-03-19 17:03:12','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3424,7768,41297,87318,3,2723,'App\\Models\\Receipt',2723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',489.77,NULL,NULL,1,'2023-03-19 17:03:12','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3425,7768,41297,87318,3,2724,'App\\Models\\Receipt',2724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',454.83,NULL,NULL,1,'2023-03-19 17:03:12','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3426,7768,41297,87318,3,2725,'App\\Models\\Receipt',2725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',508.46,NULL,NULL,1,'2023-03-19 17:03:13','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3427,7768,41297,87318,3,2726,'App\\Models\\Receipt',2726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-29','2021-12-29',12070.03,NULL,NULL,1,'2023-03-19 17:03:13','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3428,7768,41297,87318,3,2727,'App\\Models\\Receipt',2727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',15900.82,NULL,NULL,1,'2023-03-19 17:03:13','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3429,7768,41297,87318,3,2728,'App\\Models\\Receipt',2728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',56126.29,NULL,NULL,1,'2023-03-19 17:03:13','2023-03-19 17:20:36','2023-03-19 17:20:36'),(3430,7768,41297,87318,3,2729,'App\\Models\\Receipt',2729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-06','2021-08-06',52308.51,NULL,NULL,1,'2023-03-19 17:20:56','2023-03-19 17:35:03','2023-03-19 17:35:03'),(3431,7768,41297,87318,3,2730,'App\\Models\\Receipt',2730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',43604.99,NULL,NULL,1,'2023-03-19 17:20:56','2023-03-19 17:35:25','2023-03-19 17:35:25'),(3432,7768,41297,87318,3,2731,'App\\Models\\Receipt',2731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',43604.99,NULL,NULL,1,'2023-03-19 17:20:56','2023-03-19 17:35:54','2023-03-19 17:35:54'),(3433,7768,41297,87318,3,2732,'App\\Models\\Receipt',2732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-13','2021-08-13',37791.00,NULL,NULL,1,'2023-03-19 17:20:56','2023-03-19 17:20:56',NULL),(3434,7768,41297,87318,3,2733,'App\\Models\\Receipt',2733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',65000.00,NULL,NULL,1,'2023-03-19 17:20:56','2023-03-19 17:36:56','2023-03-19 17:36:56'),(3435,7768,41297,87318,3,2734,'App\\Models\\Receipt',2734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-24','2021-08-24',56386.00,NULL,NULL,1,'2023-03-19 17:20:56','2023-03-19 17:20:56',NULL),(3436,7768,41297,87318,3,2735,'App\\Models\\Receipt',2735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-29','2021-08-29',41474.00,NULL,NULL,1,'2023-03-19 17:20:56','2023-03-19 17:20:56',NULL),(3437,7768,41297,87318,3,2736,'App\\Models\\Receipt',2736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',55003.11,NULL,NULL,1,'2023-03-19 17:20:56','2023-03-19 17:20:56',NULL),(3438,7768,41297,87318,3,2737,'App\\Models\\Receipt',2737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',14918.91,NULL,NULL,1,'2023-03-19 17:20:56','2023-03-19 17:20:56',NULL),(3439,7768,41297,87318,3,2738,'App\\Models\\Receipt',2738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',14499.45,NULL,NULL,1,'2023-03-19 17:20:56','2023-03-19 17:20:56',NULL),(3440,7768,41297,87318,3,2739,'App\\Models\\Receipt',2739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',11375.88,NULL,NULL,1,'2023-03-19 17:20:56','2023-03-19 17:20:56',NULL);
INSERT INTO `balance_libro` VALUES (3441,7768,41297,87318,3,2740,'App\\Models\\Receipt',2740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-22','2022-01-22',10090.61,NULL,NULL,1,'2023-03-19 17:20:56','2023-03-19 18:11:53','2023-03-19 18:11:53'),(3442,7768,41297,87318,3,2741,'App\\Models\\Receipt',2741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',12877.43,NULL,NULL,1,'2023-03-19 17:20:56','2023-03-19 17:20:56',NULL),(3443,7768,41297,87318,3,2742,'App\\Models\\Receipt',2742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',7200.33,NULL,NULL,1,'2023-03-19 17:20:56','2023-03-19 17:20:56',NULL),(3444,7768,41297,87318,3,2743,'App\\Models\\Receipt',2743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',2438.74,NULL,NULL,1,'2023-03-19 17:20:56','2023-03-19 17:20:56',NULL),(3445,7768,41297,87318,3,2744,'App\\Models\\Receipt',2744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',7701.50,NULL,NULL,1,'2023-03-19 17:20:56','2023-03-19 17:20:56',NULL),(3446,7768,41297,87318,3,2745,'App\\Models\\Receipt',2745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',1598.85,NULL,NULL,1,'2023-03-19 17:20:56','2023-03-19 17:20:56',NULL),(3447,7768,41297,87318,3,2746,'App\\Models\\Receipt',2746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',7891.00,NULL,NULL,1,'2023-03-19 17:20:56','2023-03-19 17:20:56',NULL),(3448,7768,41297,87318,3,2747,'App\\Models\\Receipt',2747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',8257.97,NULL,NULL,1,'2023-03-19 17:20:56','2023-03-19 17:20:56',NULL),(3449,7768,41297,87318,3,2748,'App\\Models\\Receipt',2748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',7971.15,NULL,NULL,1,'2023-03-19 17:20:56','2023-03-19 17:20:56',NULL),(3450,7768,41297,87318,3,2749,'App\\Models\\Receipt',2749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',7638.52,NULL,NULL,1,'2023-03-19 17:20:56','2023-03-19 17:20:56',NULL),(3451,7768,41297,87318,3,2750,'App\\Models\\Receipt',2750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-02','2022-01-02',8030.11,NULL,NULL,1,'2023-03-19 17:20:57','2023-03-19 17:20:57',NULL),(3452,7768,41297,87318,3,2751,'App\\Models\\Receipt',2751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',7155.01,NULL,NULL,1,'2023-03-19 17:20:57','2023-03-19 17:59:16','2023-03-19 17:59:16'),(3453,7768,41297,87318,3,2752,'App\\Models\\Receipt',2752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',82850.92,NULL,NULL,1,'2023-03-19 17:20:57','2023-03-19 17:20:57',NULL),(3454,7768,41297,87318,3,2753,'App\\Models\\Receipt',2753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',78621.53,NULL,NULL,1,'2023-03-19 17:20:57','2023-03-19 17:20:57',NULL),(3455,7768,41297,87318,3,2754,'App\\Models\\Receipt',2754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',489.77,NULL,NULL,1,'2023-03-19 17:20:57','2023-03-19 17:20:57',NULL),(3456,7768,41297,87318,3,2755,'App\\Models\\Receipt',2755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',454.83,NULL,NULL,1,'2023-03-19 17:20:57','2023-03-19 17:20:57',NULL),(3457,7768,41297,87318,3,2756,'App\\Models\\Receipt',2756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-25','2021-11-25',508.46,NULL,NULL,1,'2023-03-19 17:20:57','2023-03-19 17:20:57',NULL),(3458,7768,41297,87318,3,2757,'App\\Models\\Receipt',2757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-29','2021-12-29',12070.03,NULL,NULL,1,'2023-03-19 17:20:57','2023-03-19 17:20:57',NULL),(3459,7768,41297,87318,3,2758,'App\\Models\\Receipt',2758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',15900.82,NULL,NULL,1,'2023-03-19 17:20:57','2023-03-19 17:20:57',NULL),(3460,7768,41297,87318,3,2759,'App\\Models\\Receipt',2759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',56126.29,NULL,NULL,1,'2023-03-19 17:20:57','2023-03-19 17:20:57',NULL);
INSERT INTO `balance_libro` VALUES (3461,7768,41297,87318,3,2760,'App\\Models\\Receipt',2760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',26349.73,NULL,NULL,1,'2023-03-19 17:22:33','2023-03-19 17:22:33',NULL),(3462,7768,41297,87318,3,2761,'App\\Models\\Receipt',2761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',146166.45,NULL,NULL,1,'2023-03-19 17:22:33','2023-03-19 17:22:33',NULL),(3463,7768,41297,87318,3,2762,'App\\Models\\Receipt',2762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',422807.85,NULL,NULL,1,'2023-03-19 17:22:33','2023-03-19 17:22:33',NULL),(3464,7768,41297,87318,3,2763,'App\\Models\\Receipt',2763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',29829.89,NULL,NULL,1,'2023-03-19 17:22:33','2023-03-19 17:22:33',NULL),(3465,7768,41297,87318,3,2764,'App\\Models\\Receipt',2764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',1190024.58,NULL,NULL,1,'2023-03-19 17:22:33','2023-03-19 17:22:33',NULL),(3466,7768,41297,87318,3,2765,'App\\Models\\Receipt',2765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',109674.40,NULL,NULL,1,'2023-03-19 17:22:33','2023-03-19 17:22:33',NULL),(3467,7768,41297,87318,3,2766,'App\\Models\\Receipt',2766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',121994.64,NULL,NULL,1,'2023-03-19 17:22:33','2023-03-19 17:22:33',NULL),(3468,7768,41297,87318,3,2767,'App\\Models\\Receipt',2767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',291390.07,NULL,NULL,1,'2023-03-19 17:22:33','2023-03-19 17:22:33',NULL),(3469,7768,41297,87318,3,2768,'App\\Models\\Receipt',2768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',130975.85,NULL,NULL,1,'2023-03-19 17:22:33','2023-03-19 17:22:33',NULL),(3470,7768,41297,87318,3,2769,'App\\Models\\Receipt',2769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',12796.80,NULL,NULL,1,'2023-03-19 17:22:33','2023-03-19 17:22:33',NULL),(3471,7768,41297,87318,3,2770,'App\\Models\\Receipt',2770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',77088.64,NULL,NULL,1,'2023-03-19 17:22:34','2023-03-19 17:22:34',NULL),(3472,7768,41297,87318,3,2771,'App\\Models\\Receipt',2771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',29951.86,NULL,NULL,1,'2023-03-19 17:22:34','2023-03-19 17:22:34',NULL),(3473,7768,41297,87318,3,2772,'App\\Models\\Receipt',2772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',88200.00,NULL,NULL,1,'2023-03-19 17:22:34','2023-03-19 17:22:34',NULL),(3474,7768,41297,87318,3,2773,'App\\Models\\Receipt',2773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',2331799.29,NULL,NULL,1,'2023-03-19 17:22:34','2023-03-19 17:22:34',NULL),(3475,7768,41297,87318,3,2774,'App\\Models\\Receipt',2774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',288950.42,NULL,NULL,1,'2023-03-19 17:22:34','2023-03-19 17:22:34',NULL),(3476,7768,41297,87318,3,2775,'App\\Models\\Receipt',2775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',464883.94,NULL,NULL,1,'2023-03-19 17:22:34','2023-03-19 17:22:34',NULL),(3477,7768,41297,87318,3,2776,'App\\Models\\Receipt',2776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',35912.80,NULL,NULL,1,'2023-03-19 17:22:34','2023-03-19 17:22:34',NULL),(3478,7768,41297,87318,3,2777,'App\\Models\\Receipt',2777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',22729680.00,NULL,NULL,1,'2023-03-19 17:22:34','2023-03-19 17:22:34',NULL),(3479,7768,41297,87318,3,2778,'App\\Models\\Receipt',2778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',176800.00,NULL,NULL,1,'2023-03-19 17:22:34','2023-03-19 17:22:34',NULL),(3480,7768,41297,87318,3,2779,'App\\Models\\Receipt',2779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',308079.55,NULL,NULL,1,'2023-03-19 17:22:34','2023-03-19 17:22:34',NULL);
INSERT INTO `balance_libro` VALUES (3481,7768,41297,87318,3,2780,'App\\Models\\Receipt',2780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',5000.00,NULL,NULL,1,'2023-03-19 17:22:34','2023-03-19 17:22:34',NULL),(3482,7768,41297,87318,3,2781,'App\\Models\\Receipt',2781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',413802.59,NULL,NULL,1,'2023-03-19 17:22:34','2023-03-19 17:22:34',NULL),(3483,7768,41297,87318,3,2782,'App\\Models\\Receipt',2782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',209950.00,NULL,NULL,1,'2023-03-19 17:22:34','2023-03-19 17:22:34',NULL),(3484,7768,41297,87318,3,2783,'App\\Models\\Receipt',2783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',618247.50,NULL,NULL,1,'2023-03-19 17:22:34','2023-03-19 17:22:34',NULL),(3485,7768,41297,87318,3,2784,'App\\Models\\Receipt',2784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',1046.30,NULL,NULL,1,'2023-03-19 17:22:34','2023-03-19 17:55:14','2023-03-19 17:55:14'),(3486,7768,41297,87318,3,2785,'App\\Models\\Receipt',2785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-22','2022-01-22',9256.50,NULL,NULL,1,'2023-03-19 17:22:34','2023-03-19 17:22:34',NULL),(3487,7768,41297,87318,3,2786,'App\\Models\\Receipt',2786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',10390.00,NULL,NULL,1,'2023-03-19 17:22:34','2023-03-19 17:22:34',NULL),(3488,7768,41297,87318,3,2787,'App\\Models\\Receipt',2787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',1900000.00,NULL,NULL,1,'2023-03-19 17:22:34','2023-03-19 17:22:34',NULL),(3489,7768,41297,87318,3,2788,'App\\Models\\Receipt',2788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',3900.07,NULL,NULL,1,'2023-03-19 17:22:34','2023-03-19 17:22:34',NULL),(3490,7768,41297,87318,3,2789,'App\\Models\\Receipt',2789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',42831.18,NULL,NULL,1,'2023-03-19 17:22:34','2023-03-19 17:22:34',NULL),(3491,7768,41297,87318,3,2790,'App\\Models\\Receipt',2790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',34908.84,NULL,NULL,1,'2023-03-19 17:22:34','2023-03-19 17:22:34',NULL),(3492,7768,41297,87318,3,2791,'App\\Models\\Receipt',2791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',1301137.50,NULL,NULL,1,'2023-03-19 17:22:34','2023-03-19 17:22:34',NULL),(3493,7768,41297,87318,3,2792,'App\\Models\\Receipt',2792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',5185.04,NULL,NULL,1,'2023-03-19 17:22:34','2023-03-19 17:22:34',NULL),(3494,7768,41297,87318,3,2793,'App\\Models\\Receipt',2793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',32491.84,NULL,NULL,1,'2023-03-19 17:22:34','2023-03-19 17:22:34',NULL),(3495,7768,41297,87318,3,2794,'App\\Models\\Receipt',2794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',24650.00,NULL,NULL,1,'2023-03-19 17:22:34','2023-03-19 17:22:34',NULL),(3496,7768,41297,87318,3,2795,'App\\Models\\Receipt',2795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',376511.95,NULL,NULL,1,'2023-03-19 17:22:34','2023-03-19 17:22:34',NULL),(3497,7768,41297,87318,3,2796,'App\\Models\\Receipt',2796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',299921.27,NULL,NULL,1,'2023-03-19 17:22:34','2023-03-19 17:22:34',NULL),(3498,7768,41297,87318,3,2797,'App\\Models\\Receipt',2797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',5106.97,NULL,NULL,1,'2023-03-19 17:22:34','2023-03-19 17:22:34',NULL),(3499,7768,41297,87318,3,2798,'App\\Models\\Receipt',2798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',726.00,NULL,NULL,1,'2023-03-19 17:22:34','2023-03-19 17:22:34',NULL),(3500,7768,41297,87318,3,2799,'App\\Models\\Receipt',2799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-30','2022-01-30',87361.30,NULL,NULL,1,'2023-03-19 17:22:35','2023-03-19 17:22:35',NULL);
INSERT INTO `balance_libro` VALUES (3501,7768,41297,87318,3,2800,'App\\Models\\Receipt',2800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',80867.50,NULL,NULL,1,'2023-03-19 17:22:35','2023-03-19 17:32:52','2023-03-19 17:32:52'),(3502,7768,41297,87318,3,2801,'App\\Models\\Receipt',2801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',173077.21,NULL,NULL,1,'2023-03-19 17:22:35','2023-03-19 17:22:35',NULL),(3503,7768,41297,87318,3,2802,'App\\Models\\Receipt',2802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',10921.86,NULL,NULL,1,'2023-03-19 17:22:35','2023-03-19 17:22:35',NULL),(3504,7768,41297,87318,3,2803,'App\\Models\\Receipt',2803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',7770.00,NULL,NULL,1,'2023-03-19 17:22:35','2023-03-19 17:22:35',NULL),(3505,7768,41297,87318,3,2804,'App\\Models\\Receipt',2804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',51757.41,NULL,NULL,1,'2023-03-19 17:22:35','2023-03-19 17:22:35',NULL),(3506,7768,41297,87318,3,2805,'App\\Models\\Receipt',2805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',17661.37,NULL,NULL,1,'2023-03-19 17:22:35','2023-03-19 17:22:35',NULL),(3507,7768,41297,87318,3,2806,'App\\Models\\Receipt',2806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',7540.40,NULL,NULL,1,'2023-03-19 17:22:35','2023-03-19 17:22:35',NULL),(3508,7768,41297,87318,3,2807,'App\\Models\\Receipt',2807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',20000.00,NULL,NULL,1,'2023-03-19 17:22:35','2023-03-19 17:22:35',NULL),(3509,7768,41297,87318,3,2808,'App\\Models\\Receipt',2808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',4300.00,NULL,NULL,1,'2023-03-19 17:22:35','2023-03-19 17:22:35',NULL),(3510,7768,41297,87318,3,2809,'App\\Models\\Receipt',2809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',2900.00,NULL,NULL,1,'2023-03-19 17:22:35','2023-03-19 18:01:53','2023-03-19 18:01:53'),(3511,7768,41297,87318,3,2800,'App\\Models\\Receipt',2800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',80867.50,NULL,NULL,1,'2023-03-19 17:32:52','2023-03-19 17:32:52',NULL),(3512,7768,41297,87318,3,2729,'App\\Models\\Receipt',2729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-06','2021-08-06',52308.51,NULL,NULL,1,'2023-03-19 17:35:03','2023-03-19 17:35:03',NULL),(3513,7768,41297,87318,3,2730,'App\\Models\\Receipt',2730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',43604.99,NULL,NULL,1,'2023-03-19 17:35:25','2023-03-19 17:35:38','2023-03-19 17:35:38'),(3514,7768,41297,87318,3,2730,'App\\Models\\Receipt',2730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-19','2021-08-19',43604.99,NULL,NULL,1,'2023-03-19 17:35:38','2023-03-19 17:35:38',NULL),(3515,7768,41297,87318,3,2731,'App\\Models\\Receipt',2731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',43604.99,NULL,NULL,1,'2023-03-19 17:35:54','2023-03-19 17:35:54',NULL),(3516,7768,41297,87318,3,2733,'App\\Models\\Receipt',2733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',65000.00,NULL,NULL,1,'2023-03-19 17:36:56','2023-03-19 17:36:56',NULL),(3517,7768,41297,87318,3,2784,'App\\Models\\Receipt',2784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',1046.30,NULL,NULL,1,'2023-03-19 17:55:14','2023-03-19 17:55:14',NULL),(3518,7768,41297,87318,3,2751,'App\\Models\\Receipt',2751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',7155.01,NULL,NULL,1,'2023-03-19 17:59:16','2023-03-19 17:59:16',NULL),(3519,7768,41297,87318,3,2809,'App\\Models\\Receipt',2809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',2900.00,NULL,NULL,1,'2023-03-19 18:01:53','2023-03-19 18:06:39','2023-03-19 18:06:39'),(3520,7768,41297,87318,3,2809,'App\\Models\\Receipt',2809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',2900.00,NULL,NULL,1,'2023-03-19 18:06:39','2023-03-19 18:06:39',NULL);
INSERT INTO `balance_libro` VALUES (3521,7768,41297,87318,3,2740,'App\\Models\\Receipt',2740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-22','2022-01-22',10090.61,NULL,NULL,1,'2023-03-19 18:11:53','2023-03-19 18:11:53',NULL),(3522,7768,41322,90376,3,1956,'App\\Models\\Receipt',1956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',8962.91,NULL,NULL,1,'2023-03-20 09:24:24','2023-04-17 10:39:38','2023-04-17 10:39:38'),(3523,7768,40728,13789,3,2810,'App\\Models\\Receipt',2810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',5925.10,NULL,NULL,1,'2023-03-20 12:00:11','2023-03-20 12:00:11',NULL),(3524,7768,40728,13789,3,2811,'App\\Models\\Receipt',2811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',3000.01,NULL,NULL,1,'2023-03-20 12:00:11','2023-03-20 12:00:11',NULL),(3525,7768,40728,13789,3,2812,'App\\Models\\Receipt',2812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',9932.86,NULL,NULL,1,'2023-03-20 12:00:11','2023-03-20 12:00:11',NULL),(3526,7768,40728,13789,3,2813,'App\\Models\\Receipt',2813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',187635.77,NULL,NULL,1,'2023-03-20 12:00:11','2023-03-20 12:00:11',NULL),(3527,7768,40728,13789,3,2814,'App\\Models\\Receipt',2814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',648.75,NULL,NULL,1,'2023-03-20 12:00:11','2023-03-20 12:00:11',NULL),(3528,7768,40728,13789,3,2815,'App\\Models\\Receipt',2815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',4653.56,NULL,NULL,1,'2023-03-20 12:00:11','2023-03-20 12:00:11',NULL),(3529,7768,40728,13789,3,2816,'App\\Models\\Receipt',2816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',2214.38,NULL,NULL,1,'2023-03-20 12:00:11','2023-03-20 12:00:11',NULL),(3530,7768,40728,13789,3,2817,'App\\Models\\Receipt',2817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',1372.56,NULL,NULL,1,'2023-03-20 12:00:11','2023-03-20 12:00:11',NULL),(3531,7768,40728,13789,3,2818,'App\\Models\\Receipt',2818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',2276.78,NULL,NULL,1,'2023-03-20 12:00:11','2023-03-20 12:00:11',NULL),(3532,7768,40728,13789,3,2819,'App\\Models\\Receipt',2819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',2999.91,NULL,NULL,1,'2023-03-20 12:00:11','2023-03-20 12:00:11',NULL),(3533,7768,40728,13789,3,2820,'App\\Models\\Receipt',2820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',120720.59,NULL,NULL,1,'2023-03-20 12:00:11','2023-03-20 12:00:11',NULL),(3534,7768,41298,88864,3,2821,'App\\Models\\Receipt',2821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',36000.00,NULL,NULL,1,'2023-03-22 21:42:38','2023-03-22 21:42:38',NULL),(3535,7768,41298,88864,3,2822,'App\\Models\\Receipt',2822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',18900.00,NULL,NULL,1,'2023-03-22 21:42:39','2023-03-22 21:42:39',NULL),(3536,7768,41298,88864,3,2823,'App\\Models\\Receipt',2823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',8826.72,NULL,NULL,1,'2023-03-22 21:42:39','2023-03-22 22:14:55','2023-03-22 22:14:55'),(3537,7768,41298,88864,3,2824,'App\\Models\\Receipt',2824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',21808.88,NULL,NULL,1,'2023-03-22 21:42:39','2023-03-22 21:42:39',NULL),(3538,7768,41298,88864,3,2825,'App\\Models\\Receipt',2825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',17319.06,NULL,NULL,1,'2023-03-22 21:42:39','2023-03-22 21:42:39',NULL),(3539,7768,41298,88864,3,2823,'App\\Models\\Receipt',2823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',8826.72,NULL,NULL,1,'2023-03-22 22:14:55','2023-03-22 22:14:55',NULL),(3540,7768,40728,13790,3,2826,'App\\Models\\Receipt',2826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',5552.70,NULL,NULL,1,'2023-03-25 11:09:20','2023-04-02 19:35:49','2023-04-02 19:35:49');
INSERT INTO `balance_libro` VALUES (3541,7768,40728,13790,3,2827,'App\\Models\\Receipt',2827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',7188.62,NULL,NULL,1,'2023-03-25 11:09:20','2023-04-02 19:35:49','2023-04-02 19:35:49'),(3542,7768,40728,13790,3,2828,'App\\Models\\Receipt',2828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',14641.00,NULL,NULL,1,'2023-03-25 11:09:20','2023-04-02 19:35:49','2023-04-02 19:35:49'),(3543,7768,40728,13790,3,2829,'App\\Models\\Receipt',2829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',2689.35,NULL,NULL,1,'2023-03-25 11:09:20','2023-04-02 19:35:49','2023-04-02 19:35:49'),(3544,7768,40728,13790,3,2830,'App\\Models\\Receipt',2830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',7876.00,NULL,NULL,1,'2023-03-25 11:09:20','2023-04-02 19:35:49','2023-04-02 19:35:49'),(3545,7768,40728,13790,3,2831,'App\\Models\\Receipt',2831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',2859.23,NULL,NULL,1,'2023-03-25 11:09:20','2023-04-02 19:35:49','2023-04-02 19:35:49'),(3546,7768,40728,13790,3,2832,'App\\Models\\Receipt',2832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',3930.95,NULL,NULL,1,'2023-03-25 11:09:21','2023-04-02 19:35:49','2023-04-02 19:35:49'),(3547,7768,40728,13790,3,2833,'App\\Models\\Receipt',2833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',7138.41,NULL,NULL,1,'2023-03-25 11:09:21','2023-04-02 19:35:49','2023-04-02 19:35:49'),(3548,7768,40728,13790,3,2834,'App\\Models\\Receipt',2834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',3640.02,NULL,NULL,1,'2023-03-25 11:09:21','2023-04-02 19:35:49','2023-04-02 19:35:49'),(3549,7768,40728,13790,3,2835,'App\\Models\\Receipt',2835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',15910.76,NULL,NULL,1,'2023-03-25 11:09:21','2023-04-02 19:35:49','2023-04-02 19:35:49'),(3550,7768,40728,13790,3,2836,'App\\Models\\Receipt',2836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',6898.60,NULL,NULL,1,'2023-03-25 11:09:21','2023-04-02 19:35:49','2023-04-02 19:35:49'),(3551,7768,40728,13790,3,2837,'App\\Models\\Receipt',2837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',4975.17,NULL,NULL,1,'2023-03-25 11:09:21','2023-04-02 19:35:49','2023-04-02 19:35:49'),(3552,7768,40728,13790,3,2838,'App\\Models\\Receipt',2838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',25345.00,NULL,NULL,1,'2023-03-25 11:09:21','2023-04-02 19:35:49','2023-04-02 19:35:49'),(3553,7768,40728,13790,3,2839,'App\\Models\\Receipt',2839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',2815.48,NULL,NULL,1,'2023-03-25 11:09:21','2023-04-02 19:35:49','2023-04-02 19:35:49'),(3554,7768,40728,13790,3,2840,'App\\Models\\Receipt',2840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',833855.78,NULL,NULL,1,'2023-03-25 11:09:21','2023-04-02 19:35:49','2023-04-02 19:35:49'),(3555,7768,40728,13790,3,2841,'App\\Models\\Receipt',2841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',2529.47,NULL,NULL,1,'2023-03-25 11:09:21','2023-04-02 19:35:49','2023-04-02 19:35:49'),(3556,7768,40728,13790,3,2842,'App\\Models\\Receipt',2842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',4488.01,NULL,NULL,1,'2023-03-25 11:09:21','2023-04-02 19:35:49','2023-04-02 19:35:49'),(3557,7768,40728,13790,3,2843,'App\\Models\\Receipt',2843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',442.62,NULL,NULL,1,'2023-03-25 11:09:21','2023-04-02 19:35:49','2023-04-02 19:35:49'),(3558,7768,40728,13790,3,2844,'App\\Models\\Receipt',2844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',3094.07,NULL,NULL,1,'2023-03-25 11:09:21','2023-04-02 19:35:49','2023-04-02 19:35:49'),(3559,7768,40728,13790,3,2845,'App\\Models\\Receipt',2845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',22000.00,NULL,NULL,1,'2023-03-25 11:09:21','2023-04-02 19:35:49','2023-04-02 19:35:49');
INSERT INTO `balance_libro` VALUES (3560,7768,40728,13790,3,2846,'App\\Models\\Receipt',2846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',12500.00,NULL,NULL,1,'2023-03-25 11:09:21','2023-04-02 19:35:49','2023-04-02 19:35:49'),(3561,7768,40728,13790,3,2847,'App\\Models\\Receipt',2847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',173235.99,NULL,NULL,1,'2023-03-25 11:09:21','2023-04-02 19:35:49','2023-04-02 19:35:49'),(3562,7768,40728,13790,3,2848,'App\\Models\\Receipt',2848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',4710.00,NULL,NULL,1,'2023-03-25 11:09:21','2023-04-02 19:35:49','2023-04-02 19:35:49'),(3563,7768,40728,13790,3,2849,'App\\Models\\Receipt',2849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',7440.29,NULL,NULL,1,'2023-03-25 11:09:21','2023-04-02 19:35:49','2023-04-02 19:35:49'),(3564,7768,40728,13790,3,2850,'App\\Models\\Receipt',2850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',7809.05,NULL,NULL,1,'2023-03-25 11:09:21','2023-04-02 19:35:49','2023-04-02 19:35:49'),(3565,7768,40728,13790,3,2851,'App\\Models\\Receipt',2851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',2455.48,NULL,NULL,1,'2023-03-25 11:09:21','2023-04-02 19:35:49','2023-04-02 19:35:49'),(3566,7768,40728,13790,3,2852,'App\\Models\\Receipt',2852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',5832.89,NULL,NULL,1,'2023-03-25 11:09:22','2023-04-02 19:35:49','2023-04-02 19:35:49'),(3567,7768,40728,13790,3,2853,'App\\Models\\Receipt',2853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',30700.00,NULL,NULL,1,'2023-03-25 11:09:22','2023-04-02 19:35:49','2023-04-02 19:35:49'),(3568,7768,40728,13790,3,2854,'App\\Models\\Receipt',2854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',12500.51,NULL,NULL,1,'2023-03-25 11:09:22','2023-04-02 19:35:49','2023-04-02 19:35:49'),(3569,7768,40728,13790,3,2855,'App\\Models\\Receipt',2855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',20000.09,NULL,NULL,1,'2023-03-25 11:09:22','2023-04-02 19:35:49','2023-04-02 19:35:49'),(3570,7768,40728,13790,3,2856,'App\\Models\\Receipt',2856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',233261.08,NULL,NULL,1,'2023-03-25 11:09:22','2023-04-02 19:35:49','2023-04-02 19:35:49'),(3571,7768,40728,13790,3,2857,'App\\Models\\Receipt',2857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',67760.00,NULL,NULL,1,'2023-03-25 11:09:22','2023-04-02 19:35:49','2023-04-02 19:35:49'),(3572,7768,40728,13790,3,2858,'App\\Models\\Receipt',2858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',213730.11,NULL,NULL,1,'2023-03-25 11:09:22','2023-04-02 19:35:49','2023-04-02 19:35:49'),(3573,7768,40728,13790,3,2859,'App\\Models\\Receipt',2859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',106480.00,NULL,NULL,1,'2023-03-25 11:09:22','2023-04-02 19:35:49','2023-04-02 19:35:49'),(3574,7768,40728,13790,3,2860,'App\\Models\\Receipt',2860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',21175.63,NULL,NULL,1,'2023-03-25 11:09:22','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3575,7768,40728,13790,3,2861,'App\\Models\\Receipt',2861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',83775.93,NULL,NULL,1,'2023-03-25 11:09:22','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3576,7768,40728,13790,3,2862,'App\\Models\\Receipt',2862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',10788.82,NULL,NULL,1,'2023-03-25 11:09:22','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3577,7768,40728,13790,3,2863,'App\\Models\\Receipt',2863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',26002.98,NULL,NULL,1,'2023-03-25 11:09:22','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3578,7768,40728,13790,3,2864,'App\\Models\\Receipt',2864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',2100.00,NULL,NULL,1,'2023-03-25 11:09:22','2023-04-02 19:35:50','2023-04-02 19:35:50');
INSERT INTO `balance_libro` VALUES (3579,7768,40728,13790,3,2865,'App\\Models\\Receipt',2865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',3306.34,NULL,NULL,1,'2023-03-25 11:09:23','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3580,7768,40728,13790,3,2866,'App\\Models\\Receipt',2866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',1478649.03,NULL,NULL,1,'2023-03-25 11:09:23','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3581,7768,40728,13790,3,2867,'App\\Models\\Receipt',2867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',937.67,NULL,NULL,1,'2023-03-25 11:09:23','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3582,7768,40728,13790,3,2868,'App\\Models\\Receipt',2868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',2509.29,NULL,NULL,1,'2023-03-25 11:09:23','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3583,7768,40728,13790,3,2869,'App\\Models\\Receipt',2869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',11398.20,NULL,NULL,1,'2023-03-25 11:09:23','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3584,7768,40728,13790,3,2870,'App\\Models\\Receipt',2870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',39154.81,NULL,NULL,1,'2023-03-25 11:09:23','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3585,7768,40728,13790,3,2871,'App\\Models\\Receipt',2871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',11900.00,NULL,NULL,1,'2023-03-25 11:09:23','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3586,7768,40728,13790,3,2872,'App\\Models\\Receipt',2872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',10333.56,NULL,NULL,1,'2023-03-25 11:09:23','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3587,7768,40728,13790,3,2873,'App\\Models\\Receipt',2873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',4889.39,NULL,NULL,1,'2023-03-25 11:09:23','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3588,7768,40728,13790,3,2874,'App\\Models\\Receipt',2874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',660.05,NULL,NULL,1,'2023-03-25 11:09:23','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3589,7768,40728,13790,3,2875,'App\\Models\\Receipt',2875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',15273.81,NULL,NULL,1,'2023-03-25 11:09:23','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3590,7768,40728,13790,3,2876,'App\\Models\\Receipt',2876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',61999.00,NULL,NULL,1,'2023-03-25 11:09:23','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3591,7768,40728,13790,3,2877,'App\\Models\\Receipt',2877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',15730.00,NULL,NULL,1,'2023-03-25 11:09:23','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3592,7768,40728,13790,3,2878,'App\\Models\\Receipt',2878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',26862.00,NULL,NULL,1,'2023-03-25 11:09:23','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3593,7768,40728,13790,3,2879,'App\\Models\\Receipt',2879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',7262.54,NULL,NULL,1,'2023-03-25 11:09:24','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3594,7768,40728,13790,3,2880,'App\\Models\\Receipt',2880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',40000.00,NULL,NULL,1,'2023-03-25 11:09:24','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3595,7768,40728,13790,3,2881,'App\\Models\\Receipt',2881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',1500.00,NULL,NULL,1,'2023-03-25 11:09:24','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3596,7768,40728,13790,3,2882,'App\\Models\\Receipt',2882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',4994.42,NULL,NULL,1,'2023-03-25 11:09:24','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3597,7768,40728,13790,3,2883,'App\\Models\\Receipt',2883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',140225.91,NULL,NULL,1,'2023-03-25 11:09:24','2023-04-02 19:35:50','2023-04-02 19:35:50');
INSERT INTO `balance_libro` VALUES (3598,7768,40728,13790,3,2884,'App\\Models\\Receipt',2884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',14312.61,NULL,NULL,1,'2023-03-25 11:09:24','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3599,7768,40728,13790,3,2885,'App\\Models\\Receipt',2885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',447700.00,NULL,NULL,1,'2023-03-25 11:09:24','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3600,7768,40728,13790,3,2886,'App\\Models\\Receipt',2886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',11497.61,NULL,NULL,1,'2023-03-25 11:09:24','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3601,7768,40728,13790,3,2887,'App\\Models\\Receipt',2887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',5077.52,NULL,NULL,1,'2023-03-25 11:09:24','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3602,7768,40728,13790,3,2888,'App\\Models\\Receipt',2888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',18654.05,NULL,NULL,1,'2023-03-25 11:09:24','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3603,7768,40728,13790,3,2889,'App\\Models\\Receipt',2889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',17432.63,NULL,NULL,1,'2023-03-25 11:09:24','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3604,7768,40728,13790,3,2890,'App\\Models\\Receipt',2890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',4004.99,NULL,NULL,1,'2023-03-25 11:09:24','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3605,7768,40728,13790,3,2891,'App\\Models\\Receipt',2891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',2300.20,NULL,NULL,1,'2023-03-25 11:09:24','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3606,7768,40728,13790,3,2892,'App\\Models\\Receipt',2892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',11000.00,NULL,NULL,1,'2023-03-25 11:09:24','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3607,7768,40728,13790,3,2893,'App\\Models\\Receipt',2893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',137360.28,NULL,NULL,1,'2023-03-25 11:09:24','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3608,7768,40728,13790,3,2894,'App\\Models\\Receipt',2894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',115281.30,NULL,NULL,1,'2023-03-25 11:09:24','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3609,7768,40728,13790,3,2895,'App\\Models\\Receipt',2895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',3300.03,NULL,NULL,1,'2023-03-25 11:09:24','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3610,7768,40728,13790,3,2896,'App\\Models\\Receipt',2896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',140225.91,NULL,NULL,1,'2023-03-25 11:09:24','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3611,7768,40728,13790,3,2897,'App\\Models\\Receipt',2897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',3500.00,NULL,NULL,1,'2023-03-25 11:09:24','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3612,7768,40728,13790,3,2898,'App\\Models\\Receipt',2898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',2896.08,NULL,NULL,1,'2023-03-25 11:09:24','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3613,7768,40728,13790,3,2899,'App\\Models\\Receipt',2899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',408035.28,NULL,NULL,1,'2023-03-25 11:09:25','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3614,7768,40728,13790,3,2900,'App\\Models\\Receipt',2900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',9535.99,NULL,NULL,1,'2023-03-25 11:09:25','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3615,7768,40728,13790,3,2901,'App\\Models\\Receipt',2901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',163350.00,NULL,NULL,1,'2023-03-25 11:09:25','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3616,7768,40728,13790,3,2902,'App\\Models\\Receipt',2902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',60500.00,NULL,NULL,1,'2023-03-25 11:09:25','2023-04-02 19:35:50','2023-04-02 19:35:50');
INSERT INTO `balance_libro` VALUES (3617,7768,40728,13790,3,2903,'App\\Models\\Receipt',2903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',417450.00,NULL,NULL,1,'2023-03-25 11:09:25','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3618,7768,40728,13790,3,2904,'App\\Models\\Receipt',2904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',7460.69,NULL,NULL,1,'2023-03-25 11:09:25','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3619,7768,40728,13790,3,2905,'App\\Models\\Receipt',2905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',19508.61,NULL,NULL,1,'2023-03-25 11:09:25','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3620,7768,40728,13790,3,2906,'App\\Models\\Receipt',2906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',39951.49,NULL,NULL,1,'2023-03-25 11:09:25','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3621,7768,40728,13790,3,2907,'App\\Models\\Receipt',2907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',69260.20,NULL,NULL,1,'2023-03-25 11:09:25','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3622,7768,40728,13790,3,2908,'App\\Models\\Receipt',2908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',15000.00,NULL,NULL,1,'2023-03-25 11:09:25','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3623,7768,40728,13790,3,2909,'App\\Models\\Receipt',2909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',1417660.20,NULL,NULL,1,'2023-03-25 11:09:25','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3624,7768,40728,13790,3,2910,'App\\Models\\Receipt',2910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',1887.60,NULL,NULL,1,'2023-03-25 11:09:25','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3625,7768,40728,13790,3,2911,'App\\Models\\Receipt',2911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',163895.04,NULL,NULL,1,'2023-03-25 11:09:25','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3626,7768,40728,13790,3,2912,'App\\Models\\Receipt',2912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',12432.75,NULL,NULL,1,'2023-03-25 11:09:25','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3627,7768,40728,13790,3,2913,'App\\Models\\Receipt',2913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',6140.00,NULL,NULL,1,'2023-03-25 11:09:25','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3628,7768,40728,13790,2,2914,'App\\Models\\Receipt',2914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',315943.10,NULL,NULL,1,'2023-03-25 11:09:38','2023-03-25 11:09:38',NULL),(3629,7768,40728,13790,2,2915,'App\\Models\\Receipt',2915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',332587.13,NULL,NULL,1,'2023-03-25 11:09:38','2023-03-25 11:09:38',NULL),(3630,7768,40728,13790,2,2916,'App\\Models\\Receipt',2916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',112973.76,NULL,NULL,1,'2023-03-25 11:09:38','2023-03-25 11:09:38',NULL),(3631,7768,40728,13790,2,2917,'App\\Models\\Receipt',2917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',9623237.06,NULL,NULL,1,'2023-03-25 11:09:38','2023-04-17 21:06:54','2023-04-17 21:06:54'),(3632,7768,40728,13789,16,1418,'App\\Models\\PeriodLiquidation',NULL,1418,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',194904.26,NULL,NULL,1,'2023-03-28 21:06:22','2023-03-28 21:06:22',NULL),(3633,7768,40728,13789,15,1417,'App\\Models\\PeriodLiquidation',NULL,1417,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3201655.80,NULL,NULL,1,'2023-03-28 21:06:40','2023-03-28 21:06:40',NULL),(3634,7768,41298,88865,2,2918,'App\\Models\\Receipt',2918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',191119.00,NULL,NULL,1,'2023-03-29 10:49:55','2023-03-29 10:49:55',NULL),(3635,7768,41298,88865,2,2919,'App\\Models\\Receipt',2919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',60500.00,NULL,NULL,1,'2023-03-29 10:49:55','2023-03-29 10:49:55',NULL);
INSERT INTO `balance_libro` VALUES (3636,7768,41298,88865,2,2920,'App\\Models\\Receipt',2920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',12100.00,NULL,NULL,1,'2023-03-29 10:49:55','2023-03-29 10:49:55',NULL),(3637,7768,41298,88865,2,2921,'App\\Models\\Receipt',2921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',169400.00,NULL,NULL,1,'2023-03-29 10:49:55','2023-03-29 10:49:55',NULL),(3638,7768,41298,88865,2,2922,'App\\Models\\Receipt',2922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',191119.00,NULL,NULL,1,'2023-03-29 10:49:55','2023-03-29 10:49:55',NULL),(3639,7768,41298,88865,3,2923,'App\\Models\\Receipt',2923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',18000.00,NULL,NULL,1,'2023-03-29 10:50:27','2023-04-20 14:47:57','2023-04-20 14:47:57'),(3640,7768,41298,88865,3,2924,'App\\Models\\Receipt',2924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',36000.00,NULL,NULL,1,'2023-03-29 10:50:27','2023-04-20 14:47:23','2023-04-20 14:47:23'),(3641,7768,41298,88865,3,2925,'App\\Models\\Receipt',2925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',36000.06,NULL,NULL,1,'2023-03-29 10:50:28','2023-03-29 10:50:28',NULL),(3642,7768,41298,88865,3,2926,'App\\Models\\Receipt',2926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',18000.04,NULL,NULL,1,'2023-03-29 10:50:28','2023-03-29 10:50:28',NULL),(3643,7768,41298,88865,3,2927,'App\\Models\\Receipt',2927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',54000.00,NULL,NULL,1,'2023-03-29 10:50:28','2023-04-20 14:47:40','2023-04-20 14:47:40'),(3644,7768,41298,88865,3,2928,'App\\Models\\Receipt',2928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',163999.01,NULL,NULL,1,'2023-03-29 10:50:28','2023-03-29 10:50:28',NULL),(3645,7768,41298,88865,3,2929,'App\\Models\\Receipt',2929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',86260.00,NULL,NULL,1,'2023-03-29 10:50:28','2023-03-29 10:50:28',NULL),(3646,7768,41298,88865,3,2930,'App\\Models\\Receipt',2930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',8000.00,NULL,NULL,1,'2023-03-29 10:50:28','2023-03-29 10:50:28',NULL),(3647,7768,41298,88865,3,2931,'App\\Models\\Receipt',2931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',18900.00,NULL,NULL,1,'2023-03-29 10:50:28','2023-03-29 10:50:28',NULL),(3648,7768,41298,88865,3,2932,'App\\Models\\Receipt',2932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',19140.00,NULL,NULL,1,'2023-03-29 10:50:28','2023-03-29 10:50:28',NULL),(3649,7768,41298,88865,3,2933,'App\\Models\\Receipt',2933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',9076.28,NULL,NULL,1,'2023-03-29 10:50:28','2023-04-18 13:34:33','2023-04-18 13:34:33'),(3650,7768,41298,88865,3,2934,'App\\Models\\Receipt',2934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',9789.38,NULL,NULL,1,'2023-03-29 10:50:28','2023-04-18 13:33:55','2023-04-18 13:33:55'),(3651,7768,41298,88865,3,2935,'App\\Models\\Receipt',2935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',14545.71,NULL,NULL,1,'2023-03-30 11:23:31','2023-03-30 11:23:31',NULL),(3652,7768,41298,88865,3,2936,'App\\Models\\Receipt',2936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',7367.49,NULL,NULL,1,'2023-03-30 11:23:31','2023-03-30 11:23:31',NULL),(3653,7768,41298,88865,3,2937,'App\\Models\\Receipt',2937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',19145.91,NULL,NULL,1,'2023-03-30 11:23:31','2023-04-18 13:32:04','2023-04-18 13:32:04'),(3654,7768,41322,90377,2,2938,'App\\Models\\Receipt',2938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',327834.98,NULL,NULL,1,'2023-03-30 11:33:37','2023-03-30 11:33:37',NULL),(3655,7768,41322,90377,2,2939,'App\\Models\\Receipt',2939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',327834.98,NULL,NULL,1,'2023-03-30 11:33:37','2023-03-30 11:33:37',NULL);
INSERT INTO `balance_libro` VALUES (3656,7768,41322,90377,3,2940,'App\\Models\\Receipt',2940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',16896.49,NULL,NULL,1,'2023-03-30 11:33:50','2023-04-17 10:39:14','2023-04-17 10:39:14'),(3657,7768,41322,90377,3,2941,'App\\Models\\Receipt',2941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',15750.00,NULL,NULL,1,'2023-03-30 11:33:51','2023-04-17 10:39:09','2023-04-17 10:39:09'),(3658,7768,41322,90377,3,2942,'App\\Models\\Receipt',2942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',8962.91,NULL,NULL,1,'2023-03-30 11:33:51','2023-04-17 10:39:01','2023-04-17 10:39:01'),(3659,7768,41322,90377,3,2943,'App\\Models\\Receipt',2943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',19875.99,NULL,NULL,1,'2023-03-30 11:33:51','2023-04-17 10:38:54','2023-04-17 10:38:54'),(3660,7768,41322,90377,3,2944,'App\\Models\\Receipt',2944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',14103.62,NULL,NULL,1,'2023-03-30 11:33:51','2023-04-17 10:38:49','2023-04-17 10:38:49'),(3661,7768,41322,90377,3,2945,'App\\Models\\Receipt',2945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',13583.06,NULL,NULL,1,'2023-03-30 11:33:51','2023-04-17 10:38:41','2023-04-17 10:38:41'),(3662,7768,40728,13790,3,2946,'App\\Models\\Receipt',2946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',90959.06,NULL,NULL,1,'2023-03-30 14:57:12','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3663,7768,40728,13790,3,2947,'App\\Models\\Receipt',2947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',470690.00,NULL,NULL,1,'2023-03-30 14:57:12','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3664,7768,40728,13790,3,2948,'App\\Models\\Receipt',2948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',48171.07,NULL,NULL,1,'2023-03-30 14:57:12','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3665,7768,40728,13790,3,2949,'App\\Models\\Receipt',2949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',729300.00,NULL,NULL,1,'2023-03-30 14:57:12','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3666,7768,40728,13790,3,2950,'App\\Models\\Receipt',2950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',112999.00,NULL,NULL,1,'2023-03-30 14:57:12','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3667,7768,40728,13790,3,2951,'App\\Models\\Receipt',2951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',1272.92,NULL,NULL,1,'2023-03-30 14:57:12','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3668,7768,41737,154274,2,2952,'App\\Models\\Receipt',2952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',70000.00,NULL,NULL,1,'2023-03-30 20:39:35','2023-03-30 20:39:35',NULL),(3669,7768,41737,154273,2,2953,'App\\Models\\Receipt',2953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',157853.00,NULL,NULL,1,'2023-03-30 20:39:59','2023-03-30 20:39:59',NULL),(3670,7768,41737,154273,2,2954,'App\\Models\\Receipt',2954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',40000.00,NULL,NULL,1,'2023-03-30 20:39:59','2023-03-30 20:39:59',NULL),(3671,7768,41737,154272,2,2955,'App\\Models\\Receipt',2955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',194524.00,NULL,NULL,1,'2023-03-30 20:40:48','2023-03-30 20:40:48',NULL),(3672,7768,41737,154268,2,2956,'App\\Models\\Receipt',2956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',295853.22,NULL,NULL,1,'2023-03-30 20:41:20','2023-03-30 20:41:20',NULL),(3673,7768,41737,154268,2,2957,'App\\Models\\Receipt',2957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',47000.00,NULL,NULL,1,'2023-03-30 20:41:21','2023-03-30 20:41:21',NULL),(3674,7768,41737,154268,2,2958,'App\\Models\\Receipt',2958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',44000.00,NULL,NULL,1,'2023-03-30 20:41:21','2023-03-30 20:41:21',NULL);
INSERT INTO `balance_libro` VALUES (3675,7768,41737,154268,2,2959,'App\\Models\\Receipt',2959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',47000.00,NULL,NULL,1,'2023-03-30 20:41:21','2023-03-30 20:41:21',NULL),(3676,7768,41737,154268,2,2960,'App\\Models\\Receipt',2960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',47000.00,NULL,NULL,1,'2023-03-30 20:41:21','2023-03-30 20:41:21',NULL),(3677,7768,41737,154268,2,2961,'App\\Models\\Receipt',2961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',510174.00,NULL,NULL,1,'2023-03-30 20:41:21','2023-03-30 20:41:21',NULL),(3678,7768,41737,154267,2,2962,'App\\Models\\Receipt',2962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',51666.00,NULL,NULL,1,'2023-03-30 20:41:59','2023-03-30 20:41:59',NULL),(3679,7768,41737,154267,2,2963,'App\\Models\\Receipt',2963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',255000.00,NULL,NULL,1,'2023-03-30 20:41:59','2023-03-30 20:41:59',NULL),(3680,7768,41737,154267,2,2964,'App\\Models\\Receipt',2964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',40000.00,NULL,NULL,1,'2023-03-30 20:41:59','2023-03-30 20:41:59',NULL),(3681,7768,41737,154266,2,2965,'App\\Models\\Receipt',2965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',51666.00,NULL,NULL,1,'2023-03-30 20:42:25','2023-03-30 20:42:25',NULL),(3682,7768,41737,154265,2,2966,'App\\Models\\Receipt',2966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-07','2022-09-07',15000.00,NULL,NULL,1,'2023-03-30 20:42:50','2023-03-30 20:42:50',NULL),(3683,7768,41737,154265,2,2967,'App\\Models\\Receipt',2967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',51666.00,NULL,NULL,1,'2023-03-30 20:42:50','2023-03-30 20:42:50',NULL),(3684,7768,41737,154263,2,2968,'App\\Models\\Receipt',2968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',154000.00,NULL,NULL,1,'2023-03-30 20:43:29','2023-03-30 20:43:29',NULL),(3685,7768,41737,154263,2,2969,'App\\Models\\Receipt',2969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',9500.00,NULL,NULL,1,'2023-03-30 20:43:29','2023-03-30 20:43:29',NULL),(3686,7768,41737,154263,2,2970,'App\\Models\\Receipt',2970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',9500.00,NULL,NULL,1,'2023-03-30 20:43:29','2023-03-30 20:43:29',NULL),(3687,7768,41737,154263,2,2971,'App\\Models\\Receipt',2971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',9500.00,NULL,NULL,1,'2023-03-30 20:43:29','2023-03-30 20:43:29',NULL),(3688,7768,41737,154262,2,2972,'App\\Models\\Receipt',2972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',20000.00,NULL,NULL,1,'2023-03-30 20:43:56','2023-03-30 20:43:56',NULL),(3689,7768,41737,154262,2,2973,'App\\Models\\Receipt',2973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',200000.00,NULL,NULL,1,'2023-03-30 20:43:56','2023-03-30 20:43:56',NULL),(3690,7768,41737,154262,2,2974,'App\\Models\\Receipt',2974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',200000.00,NULL,NULL,1,'2023-03-30 20:43:56','2023-03-30 20:43:56',NULL),(3691,7768,41737,154262,2,2975,'App\\Models\\Receipt',2975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',200000.00,NULL,NULL,1,'2023-03-30 20:43:56','2023-03-30 20:43:56',NULL),(3692,7768,41737,154261,2,2976,'App\\Models\\Receipt',2976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',15000.00,NULL,NULL,1,'2023-03-30 20:44:23','2023-03-30 20:44:23',NULL),(3693,7768,41737,154261,2,2977,'App\\Models\\Receipt',2977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',20000.00,NULL,NULL,1,'2023-03-30 20:44:23','2023-03-30 20:44:23',NULL),(3694,7768,41737,154261,2,2978,'App\\Models\\Receipt',2978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',5300.00,NULL,NULL,1,'2023-03-30 20:44:23','2023-03-30 20:44:23',NULL);
INSERT INTO `balance_libro` VALUES (3695,7768,41737,154261,2,2979,'App\\Models\\Receipt',2979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',140000.00,NULL,NULL,1,'2023-03-30 20:44:23','2023-03-30 20:44:23',NULL),(3696,7768,41737,154260,2,2980,'App\\Models\\Receipt',2980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',55000.00,NULL,NULL,1,'2023-03-30 20:44:53','2023-03-30 20:44:53',NULL),(3697,7768,41737,154260,2,2981,'App\\Models\\Receipt',2981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',70000.00,NULL,NULL,1,'2023-03-30 20:44:53','2023-03-30 20:44:53',NULL),(3698,7768,41737,154260,2,2982,'App\\Models\\Receipt',2982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',120000.00,NULL,NULL,1,'2023-03-30 20:44:53','2023-03-30 20:44:53',NULL),(3699,7768,41737,154259,2,2983,'App\\Models\\Receipt',2983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',10500.00,NULL,NULL,1,'2023-03-30 20:45:28','2023-03-30 20:45:28',NULL),(3700,7768,41737,154259,2,2984,'App\\Models\\Receipt',2984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',50000.00,NULL,NULL,1,'2023-03-30 20:45:28','2023-03-30 20:45:28',NULL),(3701,7768,41737,154259,2,2985,'App\\Models\\Receipt',2985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',50000.00,NULL,NULL,1,'2023-03-30 20:45:28','2023-03-30 20:45:28',NULL),(3702,7768,41737,154259,2,2986,'App\\Models\\Receipt',2986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',50000.00,NULL,NULL,1,'2023-03-30 20:45:28','2023-03-30 20:45:28',NULL),(3703,7768,41737,154273,2,2987,'App\\Models\\Receipt',2987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',60000.00,NULL,NULL,1,'2023-03-30 20:47:26','2023-03-30 21:21:50','2023-03-30 21:21:50'),(3704,7768,41737,154272,8,2988,'App\\Models\\Receipt',2988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',11.93,NULL,NULL,1,'2023-03-30 20:56:16','2023-03-30 20:56:30','2023-03-30 20:56:30'),(3705,7768,41737,154272,8,2988,'App\\Models\\Receipt',2988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1193.41,NULL,NULL,1,'2023-03-30 20:56:30','2023-03-30 20:56:30',NULL),(3706,7768,41737,154272,8,2989,'App\\Models\\Receipt',2989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',20.90,NULL,NULL,1,'2023-03-30 20:58:12','2023-03-30 20:58:12',NULL),(3707,7768,41737,154259,16,1451,'App\\Models\\PeriodLiquidation',NULL,1451,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',0.00,NULL,NULL,1,'2023-03-30 20:58:22','2023-03-30 20:58:22',NULL),(3708,7768,41737,154272,16,1455,'App\\Models\\PeriodLiquidation',NULL,1455,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1214.31,NULL,NULL,1,'2023-03-30 20:58:25','2023-03-30 20:59:57','2023-03-30 20:59:57'),(3709,7768,41737,154261,16,1449,'App\\Models\\PeriodLiquidation',NULL,1449,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',0.00,NULL,NULL,1,'2023-03-30 20:58:28','2023-03-30 20:58:28',NULL),(3710,7768,41737,154273,16,1452,'App\\Models\\PeriodLiquidation',NULL,1452,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',0.00,NULL,NULL,1,'2023-03-30 20:58:31','2023-03-30 20:59:10','2023-03-30 20:59:10'),(3711,7768,41737,154262,16,1447,'App\\Models\\PeriodLiquidation',NULL,1447,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',0.00,NULL,NULL,1,'2023-03-30 20:58:36','2023-03-30 20:58:36',NULL),(3712,7768,41737,154263,16,1446,'App\\Models\\PeriodLiquidation',NULL,1446,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',0.00,NULL,NULL,1,'2023-03-30 20:58:40','2023-03-30 20:58:40',NULL),(3713,7768,41737,154260,16,1450,'App\\Models\\PeriodLiquidation',NULL,1450,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',0.00,NULL,NULL,1,'2023-03-30 20:58:43','2023-03-30 20:58:43',NULL),(3714,7768,41737,154265,16,1445,'App\\Models\\PeriodLiquidation',NULL,1445,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',0.00,NULL,NULL,1,'2023-03-30 20:58:47','2023-03-30 20:58:47',NULL);
INSERT INTO `balance_libro` VALUES (3715,7768,41737,154266,16,1444,'App\\Models\\PeriodLiquidation',NULL,1444,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',0.00,NULL,NULL,1,'2023-03-30 20:58:54','2023-03-30 20:58:54',NULL),(3716,7768,41737,154267,16,1443,'App\\Models\\PeriodLiquidation',NULL,1443,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',0.00,NULL,NULL,1,'2023-03-30 20:58:59','2023-03-30 20:58:59',NULL),(3717,7768,41737,154268,16,1442,'App\\Models\\PeriodLiquidation',NULL,1442,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',0.00,NULL,NULL,1,'2023-03-30 20:59:04','2023-03-30 20:59:04',NULL),(3718,7768,41737,154272,16,1458,'App\\Models\\PeriodLiquidation',NULL,1458,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1368.26,NULL,NULL,1,'2023-03-30 21:01:18','2023-03-30 21:01:18',NULL),(3719,7768,41737,154273,8,2990,'App\\Models\\Receipt',2990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1028.12,NULL,NULL,1,'2023-03-30 21:02:13','2023-03-30 21:06:54','2023-03-30 21:06:54'),(3720,7768,41737,154273,7,2991,'App\\Models\\Receipt',2991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',3767.92,NULL,NULL,1,'2023-03-30 21:04:36','2023-03-30 21:15:25','2023-03-30 21:15:25'),(3721,7768,41737,154273,8,2990,'App\\Models\\Receipt',2990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',4796.04,NULL,NULL,1,'2023-03-30 21:06:54','2023-03-30 21:16:24','2023-03-30 21:16:24'),(3722,7768,41737,154273,3,2992,'App\\Models\\Receipt',2992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',65200.00,NULL,NULL,1,'2023-03-30 21:08:28','2023-03-30 21:08:28',NULL),(3723,7768,41737,154273,3,2993,'App\\Models\\Receipt',2993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',176.99,NULL,NULL,1,'2023-03-30 21:08:28','2023-03-30 21:08:28',NULL),(3724,7768,41737,154273,3,2994,'App\\Models\\Receipt',2994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',394.00,NULL,NULL,1,'2023-03-30 21:08:28','2023-03-30 21:08:28',NULL),(3725,7768,41737,154273,3,2995,'App\\Models\\Receipt',2995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',8379.99,NULL,NULL,1,'2023-03-30 21:08:28','2023-03-30 21:08:28',NULL),(3726,7768,41737,154273,3,2996,'App\\Models\\Receipt',2996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',2851.97,NULL,NULL,1,'2023-03-30 21:08:28','2023-03-30 21:08:28',NULL),(3727,7768,41737,154273,3,2997,'App\\Models\\Receipt',2997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',5518.51,NULL,NULL,1,'2023-03-30 21:08:28','2023-03-30 21:08:28',NULL),(3728,7768,41737,154273,3,2998,'App\\Models\\Receipt',2998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',652.00,NULL,NULL,1,'2023-03-30 21:08:28','2023-03-30 21:08:28',NULL),(3729,7768,41737,154273,3,2999,'App\\Models\\Receipt',2999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',57092.52,NULL,NULL,1,'2023-03-30 21:08:28','2023-03-30 21:08:28',NULL),(3730,7768,41737,154273,3,3000,'App\\Models\\Receipt',3000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',8903.95,NULL,NULL,1,'2023-03-30 21:08:28','2023-03-30 21:08:28',NULL),(3731,7768,41737,154273,3,3001,'App\\Models\\Receipt',3001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',530.00,NULL,NULL,1,'2023-03-30 21:08:28','2023-03-30 21:08:28',NULL),(3732,7768,41737,154273,3,3002,'App\\Models\\Receipt',3002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',88.49,NULL,NULL,1,'2023-03-30 21:08:28','2023-03-30 21:08:28',NULL),(3733,7768,41737,154273,3,3003,'App\\Models\\Receipt',3003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',5000.00,NULL,NULL,1,'2023-03-30 21:08:28','2023-03-30 21:08:28',NULL),(3734,7768,41737,154273,7,2991,'App\\Models\\Receipt',2991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',2917.86,NULL,NULL,1,'2023-03-30 21:15:25','2023-03-30 21:15:25',NULL);
INSERT INTO `balance_libro` VALUES (3735,7768,41737,154273,8,2990,'App\\Models\\Receipt',2990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3945.98,NULL,NULL,1,'2023-03-30 21:16:24','2023-03-30 21:20:19','2023-03-30 21:20:19'),(3736,7768,41737,154273,8,2990,'App\\Models\\Receipt',2990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',4796.04,NULL,NULL,1,'2023-03-30 21:20:19','2023-03-30 21:20:19',NULL),(3737,7768,41737,154273,16,1468,'App\\Models\\PeriodLiquidation',NULL,1468,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',7888.75,NULL,NULL,1,'2023-03-30 21:22:57','2023-03-30 21:23:34','2023-03-30 21:23:34'),(3738,7768,41737,154273,16,1468,'App\\Models\\PeriodLiquidation',NULL,1468,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',7888.75,NULL,NULL,1,'2023-03-30 21:24:03','2023-03-30 21:24:03',NULL),(3739,7768,41737,154258,2,3004,'App\\Models\\Receipt',3004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',60000.00,NULL,NULL,1,'2023-03-30 21:24:57','2023-03-30 21:24:57',NULL),(3740,7768,40728,13790,3,3005,'App\\Models\\Receipt',3005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',59807.41,NULL,NULL,1,'2023-03-31 14:24:28','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3741,7768,40728,13790,3,3006,'App\\Models\\Receipt',3006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',5660.04,NULL,NULL,1,'2023-03-31 14:24:28','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3742,7768,40728,13790,3,3007,'App\\Models\\Receipt',3007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',77561.87,NULL,NULL,1,'2023-03-31 14:24:28','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3743,7768,40728,13790,2,3008,'App\\Models\\Receipt',3008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',22902.88,NULL,NULL,1,'2023-03-31 14:24:42','2023-03-31 14:24:42',NULL),(3744,7768,40728,13790,3,3009,'App\\Models\\Receipt',3009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',49420.27,NULL,NULL,1,'2023-04-02 19:32:37','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3745,7768,40728,13790,3,3010,'App\\Models\\Receipt',3010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',8402849.32,NULL,NULL,1,'2023-04-02 19:32:37','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3746,7768,40728,13790,3,3011,'App\\Models\\Receipt',3011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',10097.45,NULL,NULL,1,'2023-04-02 19:32:37','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3747,7768,40728,13790,3,3012,'App\\Models\\Receipt',3012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3100.00,NULL,NULL,1,'2023-04-02 19:32:37','2023-04-02 19:35:50','2023-04-02 19:35:50'),(3748,7768,40728,13790,3,3013,'App\\Models\\Receipt',3013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',5552.70,NULL,NULL,1,'2023-04-02 19:36:32','2023-04-13 21:06:02','2023-04-13 21:06:02'),(3749,7768,40728,13790,3,3014,'App\\Models\\Receipt',3014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',7188.62,NULL,NULL,1,'2023-04-02 19:36:32','2023-04-13 21:06:02','2023-04-13 21:06:02'),(3750,7768,40728,13790,3,3015,'App\\Models\\Receipt',3015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',14641.00,NULL,NULL,1,'2023-04-02 19:36:32','2023-04-13 21:06:02','2023-04-13 21:06:02'),(3751,7768,40728,13790,3,3016,'App\\Models\\Receipt',3016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',2689.35,NULL,NULL,1,'2023-04-02 19:36:32','2023-04-13 21:06:02','2023-04-13 21:06:02'),(3752,7768,40728,13790,3,3017,'App\\Models\\Receipt',3017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',7876.00,NULL,NULL,1,'2023-04-02 19:36:32','2023-04-13 21:06:02','2023-04-13 21:06:02'),(3753,7768,40728,13790,3,3018,'App\\Models\\Receipt',3018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',2859.23,NULL,NULL,1,'2023-04-02 19:36:32','2023-04-13 21:06:02','2023-04-13 21:06:02');
INSERT INTO `balance_libro` VALUES (3754,7768,40728,13790,3,3019,'App\\Models\\Receipt',3019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',3930.95,NULL,NULL,1,'2023-04-02 19:36:32','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3755,7768,40728,13790,3,3020,'App\\Models\\Receipt',3020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',7138.41,NULL,NULL,1,'2023-04-02 19:36:32','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3756,7768,40728,13790,3,3021,'App\\Models\\Receipt',3021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',3640.02,NULL,NULL,1,'2023-04-02 19:36:32','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3757,7768,40728,13790,3,3022,'App\\Models\\Receipt',3022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',15910.76,NULL,NULL,1,'2023-04-02 19:36:32','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3758,7768,40728,13790,3,3023,'App\\Models\\Receipt',3023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',6898.60,NULL,NULL,1,'2023-04-02 19:36:32','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3759,7768,40728,13790,3,3024,'App\\Models\\Receipt',3024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',4975.17,NULL,NULL,1,'2023-04-02 19:36:32','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3760,7768,40728,13790,3,3025,'App\\Models\\Receipt',3025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',25345.00,NULL,NULL,1,'2023-04-02 19:36:32','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3761,7768,40728,13790,3,3026,'App\\Models\\Receipt',3026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',2815.48,NULL,NULL,1,'2023-04-02 19:36:32','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3762,7768,40728,13790,3,3027,'App\\Models\\Receipt',3027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',833855.78,NULL,NULL,1,'2023-04-02 19:36:32','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3763,7768,40728,13790,3,3028,'App\\Models\\Receipt',3028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',2529.47,NULL,NULL,1,'2023-04-02 19:36:32','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3764,7768,40728,13790,3,3029,'App\\Models\\Receipt',3029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',4488.01,NULL,NULL,1,'2023-04-02 19:36:32','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3765,7768,40728,13790,3,3030,'App\\Models\\Receipt',3030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',442.62,NULL,NULL,1,'2023-04-02 19:36:32','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3766,7768,40728,13790,3,3031,'App\\Models\\Receipt',3031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',3094.07,NULL,NULL,1,'2023-04-02 19:36:32','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3767,7768,40728,13790,3,3032,'App\\Models\\Receipt',3032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',22000.00,NULL,NULL,1,'2023-04-02 19:36:32','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3768,7768,40728,13790,3,3033,'App\\Models\\Receipt',3033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',12500.00,NULL,NULL,1,'2023-04-02 19:36:32','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3769,7768,40728,13790,3,3034,'App\\Models\\Receipt',3034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',173235.99,NULL,NULL,1,'2023-04-02 19:36:32','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3770,7768,40728,13790,3,3035,'App\\Models\\Receipt',3035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',4710.00,NULL,NULL,1,'2023-04-02 19:36:32','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3771,7768,40728,13790,3,3036,'App\\Models\\Receipt',3036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',7440.29,NULL,NULL,1,'2023-04-02 19:36:32','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3772,7768,40728,13790,3,3037,'App\\Models\\Receipt',3037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',7809.05,NULL,NULL,1,'2023-04-02 19:36:32','2023-04-13 21:06:03','2023-04-13 21:06:03');
INSERT INTO `balance_libro` VALUES (3773,7768,40728,13790,3,3038,'App\\Models\\Receipt',3038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',2455.48,NULL,NULL,1,'2023-04-02 19:36:33','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3774,7768,40728,13790,3,3039,'App\\Models\\Receipt',3039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',5832.89,NULL,NULL,1,'2023-04-02 19:36:33','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3775,7768,40728,13790,3,3040,'App\\Models\\Receipt',3040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',30700.00,NULL,NULL,1,'2023-04-02 19:36:33','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3776,7768,40728,13790,3,3041,'App\\Models\\Receipt',3041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',12500.51,NULL,NULL,1,'2023-04-02 19:36:33','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3777,7768,40728,13790,3,3042,'App\\Models\\Receipt',3042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',20000.09,NULL,NULL,1,'2023-04-02 19:36:33','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3778,7768,40728,13790,3,3043,'App\\Models\\Receipt',3043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',233261.08,NULL,NULL,1,'2023-04-02 19:36:33','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3779,7768,40728,13790,3,3044,'App\\Models\\Receipt',3044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',67760.00,NULL,NULL,1,'2023-04-02 19:36:33','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3780,7768,40728,13790,3,3045,'App\\Models\\Receipt',3045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',213730.11,NULL,NULL,1,'2023-04-02 19:36:33','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3781,7768,40728,13790,3,3046,'App\\Models\\Receipt',3046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',106480.00,NULL,NULL,1,'2023-04-02 19:36:33','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3782,7768,40728,13790,3,3047,'App\\Models\\Receipt',3047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',21175.63,NULL,NULL,1,'2023-04-02 19:36:33','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3783,7768,40728,13790,3,3048,'App\\Models\\Receipt',3048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',83775.93,NULL,NULL,1,'2023-04-02 19:36:33','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3784,7768,40728,13790,3,3049,'App\\Models\\Receipt',3049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',10788.82,NULL,NULL,1,'2023-04-02 19:36:33','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3785,7768,40728,13790,3,3050,'App\\Models\\Receipt',3050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',26002.98,NULL,NULL,1,'2023-04-02 19:36:33','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3786,7768,40728,13790,3,3051,'App\\Models\\Receipt',3051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',2100.00,NULL,NULL,1,'2023-04-02 19:36:33','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3787,7768,40728,13790,3,3052,'App\\Models\\Receipt',3052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',3306.34,NULL,NULL,1,'2023-04-02 19:36:33','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3788,7768,40728,13790,3,3053,'App\\Models\\Receipt',3053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',1478649.03,NULL,NULL,1,'2023-04-02 19:36:33','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3789,7768,40728,13790,3,3054,'App\\Models\\Receipt',3054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',937.67,NULL,NULL,1,'2023-04-02 19:36:33','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3790,7768,40728,13790,3,3055,'App\\Models\\Receipt',3055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',2509.29,NULL,NULL,1,'2023-04-02 19:36:33','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3791,7768,40728,13790,3,3056,'App\\Models\\Receipt',3056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',11398.20,NULL,NULL,1,'2023-04-02 19:36:33','2023-04-13 21:06:03','2023-04-13 21:06:03');
INSERT INTO `balance_libro` VALUES (3792,7768,40728,13790,3,3057,'App\\Models\\Receipt',3057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',39154.81,NULL,NULL,1,'2023-04-02 19:36:33','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3793,7768,40728,13790,3,3058,'App\\Models\\Receipt',3058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',11900.00,NULL,NULL,1,'2023-04-02 19:36:33','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3794,7768,40728,13790,3,3059,'App\\Models\\Receipt',3059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',10333.56,NULL,NULL,1,'2023-04-02 19:36:33','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3795,7768,40728,13790,3,3060,'App\\Models\\Receipt',3060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',4889.39,NULL,NULL,1,'2023-04-02 19:36:33','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3796,7768,40728,13790,3,3061,'App\\Models\\Receipt',3061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',660.05,NULL,NULL,1,'2023-04-02 19:36:33','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3797,7768,40728,13790,3,3062,'App\\Models\\Receipt',3062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',15273.81,NULL,NULL,1,'2023-04-02 19:36:34','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3798,7768,40728,13790,3,3063,'App\\Models\\Receipt',3063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',61999.00,NULL,NULL,1,'2023-04-02 19:36:34','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3799,7768,40728,13790,3,3064,'App\\Models\\Receipt',3064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',15730.00,NULL,NULL,1,'2023-04-02 19:36:34','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3800,7768,40728,13790,3,3065,'App\\Models\\Receipt',3065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',26862.00,NULL,NULL,1,'2023-04-02 19:36:34','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3801,7768,40728,13790,3,3066,'App\\Models\\Receipt',3066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',7262.54,NULL,NULL,1,'2023-04-02 19:36:34','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3802,7768,40728,13790,3,3067,'App\\Models\\Receipt',3067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',40000.00,NULL,NULL,1,'2023-04-02 19:36:34','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3803,7768,40728,13790,3,3068,'App\\Models\\Receipt',3068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',1500.00,NULL,NULL,1,'2023-04-02 19:36:34','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3804,7768,40728,13790,3,3069,'App\\Models\\Receipt',3069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',4994.42,NULL,NULL,1,'2023-04-02 19:36:34','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3805,7768,40728,13790,3,3070,'App\\Models\\Receipt',3070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',140225.91,NULL,NULL,1,'2023-04-02 19:36:34','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3806,7768,40728,13790,3,3071,'App\\Models\\Receipt',3071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',14312.61,NULL,NULL,1,'2023-04-02 19:36:34','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3807,7768,40728,13790,3,3072,'App\\Models\\Receipt',3072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',447700.00,NULL,NULL,1,'2023-04-02 19:36:34','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3808,7768,40728,13790,3,3073,'App\\Models\\Receipt',3073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',11497.61,NULL,NULL,1,'2023-04-02 19:36:34','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3809,7768,40728,13790,3,3074,'App\\Models\\Receipt',3074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',5077.52,NULL,NULL,1,'2023-04-02 19:36:34','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3810,7768,40728,13790,3,3075,'App\\Models\\Receipt',3075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',18654.05,NULL,NULL,1,'2023-04-02 19:36:34','2023-04-13 21:06:03','2023-04-13 21:06:03');
INSERT INTO `balance_libro` VALUES (3811,7768,40728,13790,3,3076,'App\\Models\\Receipt',3076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',17432.63,NULL,NULL,1,'2023-04-02 19:36:34','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3812,7768,40728,13790,3,3077,'App\\Models\\Receipt',3077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',4004.99,NULL,NULL,1,'2023-04-02 19:36:34','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3813,7768,40728,13790,3,3078,'App\\Models\\Receipt',3078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',2300.20,NULL,NULL,1,'2023-04-02 19:36:34','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3814,7768,40728,13790,3,3079,'App\\Models\\Receipt',3079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',11000.00,NULL,NULL,1,'2023-04-02 19:36:34','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3815,7768,40728,13790,3,3080,'App\\Models\\Receipt',3080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',137360.28,NULL,NULL,1,'2023-04-02 19:36:34','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3816,7768,40728,13790,3,3081,'App\\Models\\Receipt',3081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',115281.30,NULL,NULL,1,'2023-04-02 19:36:34','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3817,7768,40728,13790,3,3082,'App\\Models\\Receipt',3082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',3300.03,NULL,NULL,1,'2023-04-02 19:36:34','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3818,7768,40728,13790,3,3083,'App\\Models\\Receipt',3083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',140225.91,NULL,NULL,1,'2023-04-02 19:36:34','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3819,7768,40728,13790,3,3084,'App\\Models\\Receipt',3084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',3500.00,NULL,NULL,1,'2023-04-02 19:36:34','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3820,7768,40728,13790,3,3085,'App\\Models\\Receipt',3085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',2896.08,NULL,NULL,1,'2023-04-02 19:36:34','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3821,7768,40728,13790,3,3086,'App\\Models\\Receipt',3086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',408035.28,NULL,NULL,1,'2023-04-02 19:36:34','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3822,7768,40728,13790,3,3087,'App\\Models\\Receipt',3087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',9535.99,NULL,NULL,1,'2023-04-02 19:36:34','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3823,7768,40728,13790,3,3088,'App\\Models\\Receipt',3088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',163350.00,NULL,NULL,1,'2023-04-02 19:36:34','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3824,7768,40728,13790,3,3089,'App\\Models\\Receipt',3089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',60500.00,NULL,NULL,1,'2023-04-02 19:36:35','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3825,7768,40728,13790,3,3090,'App\\Models\\Receipt',3090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',417450.00,NULL,NULL,1,'2023-04-02 19:36:35','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3826,7768,40728,13790,3,3091,'App\\Models\\Receipt',3091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',7460.69,NULL,NULL,1,'2023-04-02 19:36:35','2023-04-13 21:06:03','2023-04-13 21:06:03'),(3827,7768,40728,13790,3,3092,'App\\Models\\Receipt',3092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',19508.61,NULL,NULL,1,'2023-04-02 19:36:35','2023-04-13 21:06:04','2023-04-13 21:06:04'),(3828,7768,40728,13790,3,3093,'App\\Models\\Receipt',3093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',39951.49,NULL,NULL,1,'2023-04-02 19:36:35','2023-04-13 21:06:04','2023-04-13 21:06:04'),(3829,7768,40728,13790,3,3094,'App\\Models\\Receipt',3094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',69260.20,NULL,NULL,1,'2023-04-02 19:36:35','2023-04-13 21:06:04','2023-04-13 21:06:04');
INSERT INTO `balance_libro` VALUES (3830,7768,40728,13790,3,3095,'App\\Models\\Receipt',3095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',15000.00,NULL,NULL,1,'2023-04-02 19:36:35','2023-04-13 21:06:04','2023-04-13 21:06:04'),(3831,7768,40728,13790,3,3096,'App\\Models\\Receipt',3096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',1417660.20,NULL,NULL,1,'2023-04-02 19:36:35','2023-04-13 21:06:04','2023-04-13 21:06:04'),(3832,7768,40728,13790,3,3097,'App\\Models\\Receipt',3097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',1887.60,NULL,NULL,1,'2023-04-02 19:36:35','2023-04-13 21:06:04','2023-04-13 21:06:04'),(3833,7768,40728,13790,3,3098,'App\\Models\\Receipt',3098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',163895.04,NULL,NULL,1,'2023-04-02 19:36:35','2023-04-13 21:06:04','2023-04-13 21:06:04'),(3834,7768,40728,13790,3,3099,'App\\Models\\Receipt',3099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',12432.75,NULL,NULL,1,'2023-04-02 19:36:35','2023-04-13 21:06:04','2023-04-13 21:06:04'),(3835,7768,40728,13790,3,3100,'App\\Models\\Receipt',3100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',6140.00,NULL,NULL,1,'2023-04-02 19:36:35','2023-04-13 21:06:04','2023-04-13 21:06:04'),(3836,7768,40728,13790,3,3101,'App\\Models\\Receipt',3101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',0.00,NULL,NULL,1,'2023-04-02 19:36:35','2023-04-13 21:06:04','2023-04-13 21:06:04'),(3837,7768,40728,13790,3,3102,'App\\Models\\Receipt',3102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',0.00,NULL,NULL,1,'2023-04-02 19:36:35','2023-04-13 21:06:04','2023-04-13 21:06:04'),(3838,7768,40728,13790,3,3103,'App\\Models\\Receipt',3103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',12663.06,NULL,NULL,1,'2023-04-02 19:36:35','2023-04-13 21:06:04','2023-04-13 21:06:04'),(3839,7768,40728,13790,3,3104,'App\\Models\\Receipt',3104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',8220.21,NULL,NULL,1,'2023-04-02 19:36:35','2023-04-13 21:06:04','2023-04-13 21:06:04'),(3840,7768,40728,13790,3,3105,'App\\Models\\Receipt',3105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',90959.06,NULL,NULL,1,'2023-04-02 19:36:35','2023-04-13 21:06:04','2023-04-13 21:06:04'),(3841,7768,40728,13790,3,3106,'App\\Models\\Receipt',3106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',470690.00,NULL,NULL,1,'2023-04-02 19:36:35','2023-04-13 21:06:04','2023-04-13 21:06:04'),(3842,7768,40728,13790,3,3107,'App\\Models\\Receipt',3107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',48171.07,NULL,NULL,1,'2023-04-02 19:36:35','2023-04-13 21:06:04','2023-04-13 21:06:04'),(3843,7768,40728,13790,3,3108,'App\\Models\\Receipt',3108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',729300.00,NULL,NULL,1,'2023-04-02 19:36:35','2023-04-13 21:06:04','2023-04-13 21:06:04'),(3844,7768,40728,13790,3,3109,'App\\Models\\Receipt',3109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',112999.00,NULL,NULL,1,'2023-04-02 19:36:35','2023-04-13 21:06:04','2023-04-13 21:06:04'),(3845,7768,40728,13790,3,3110,'App\\Models\\Receipt',3110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',1272.92,NULL,NULL,1,'2023-04-02 19:36:35','2023-04-13 21:06:04','2023-04-13 21:06:04'),(3846,7768,40728,13790,3,3111,'App\\Models\\Receipt',3111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',59807.41,NULL,NULL,1,'2023-04-02 19:36:35','2023-04-13 21:06:04','2023-04-13 21:06:04'),(3847,7768,40728,13790,3,3112,'App\\Models\\Receipt',3112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',5660.04,NULL,NULL,1,'2023-04-02 19:36:36','2023-04-13 21:06:04','2023-04-13 21:06:04'),(3848,7768,40728,13790,3,3113,'App\\Models\\Receipt',3113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',77561.87,NULL,NULL,1,'2023-04-02 19:36:36','2023-04-13 21:06:04','2023-04-13 21:06:04');
INSERT INTO `balance_libro` VALUES (3849,7768,40728,13790,3,3114,'App\\Models\\Receipt',3114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',49420.27,NULL,NULL,1,'2023-04-02 19:36:36','2023-04-13 21:06:04','2023-04-13 21:06:04'),(3850,7768,40728,13790,3,3115,'App\\Models\\Receipt',3115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',8402849.32,NULL,NULL,1,'2023-04-02 19:36:36','2023-04-13 21:06:04','2023-04-13 21:06:04'),(3851,7768,40728,13790,3,3116,'App\\Models\\Receipt',3116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',10097.45,NULL,NULL,1,'2023-04-02 19:36:36','2023-04-13 21:06:04','2023-04-13 21:06:04'),(3852,7768,40728,13790,3,3117,'App\\Models\\Receipt',3117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3100.00,NULL,NULL,1,'2023-04-02 19:36:36','2023-04-13 21:06:04','2023-04-13 21:06:04'),(3908,7768,41297,87319,3,3173,'App\\Models\\Receipt',3173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',7008.60,NULL,NULL,1,'2023-04-12 20:43:44','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3909,7768,41297,87319,3,3174,'App\\Models\\Receipt',3174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',4300.00,NULL,NULL,1,'2023-04-12 20:43:44','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3910,7768,41297,87319,3,3175,'App\\Models\\Receipt',3175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',700.00,NULL,NULL,1,'2023-04-12 20:43:44','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3911,7768,41297,87319,3,3176,'App\\Models\\Receipt',3176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',2401.76,NULL,NULL,1,'2023-04-12 20:43:44','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3912,7768,41297,87319,3,3177,'App\\Models\\Receipt',3177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',2675.68,NULL,NULL,1,'2023-04-12 20:43:44','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3913,7768,41297,87319,3,3178,'App\\Models\\Receipt',3178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',7444.62,NULL,NULL,1,'2023-04-12 20:43:44','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3914,7768,41297,87319,3,3179,'App\\Models\\Receipt',3179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',2288.64,NULL,NULL,1,'2023-04-12 20:43:44','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3915,7768,41297,87319,3,3180,'App\\Models\\Receipt',3180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',87949.50,NULL,NULL,1,'2023-04-12 20:43:44','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3916,7768,41297,87319,3,3181,'App\\Models\\Receipt',3181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',2400.99,NULL,NULL,1,'2023-04-12 20:43:44','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3917,7768,41297,87319,3,3182,'App\\Models\\Receipt',3182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',8258.24,NULL,NULL,1,'2023-04-12 20:43:44','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3918,7768,41297,87319,3,3183,'App\\Models\\Receipt',3183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',7300.90,NULL,NULL,1,'2023-04-12 20:43:44','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3919,7768,41297,87319,3,3184,'App\\Models\\Receipt',3184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',680.01,NULL,NULL,1,'2023-04-12 20:43:44','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3920,7768,41297,87319,3,3185,'App\\Models\\Receipt',3185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',2685.01,NULL,NULL,1,'2023-04-12 20:43:44','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3921,7768,41297,87319,3,3186,'App\\Models\\Receipt',3186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',520.01,NULL,NULL,1,'2023-04-12 20:43:44','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3922,7768,41297,87319,3,3187,'App\\Models\\Receipt',3187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',7300.25,NULL,NULL,1,'2023-04-12 20:43:44','2023-04-12 22:29:43','2023-04-12 22:29:43');
INSERT INTO `balance_libro` VALUES (3923,7768,41297,87319,3,3188,'App\\Models\\Receipt',3188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',1220.01,NULL,NULL,1,'2023-04-12 20:43:44','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3924,7768,41297,87319,3,3189,'App\\Models\\Receipt',3189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',1740.02,NULL,NULL,1,'2023-04-12 20:43:45','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3925,7768,41297,87319,3,3190,'App\\Models\\Receipt',3190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',1137.53,NULL,NULL,1,'2023-04-12 20:43:45','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3926,7768,41297,87319,3,3191,'App\\Models\\Receipt',3191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',2080.01,NULL,NULL,1,'2023-04-12 20:43:45','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3927,7768,41297,87319,3,3192,'App\\Models\\Receipt',3192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',9270.49,NULL,NULL,1,'2023-04-12 20:43:45','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3928,7768,41297,87319,3,3193,'App\\Models\\Receipt',3193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',2585.00,NULL,NULL,1,'2023-04-12 20:43:45','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3929,7768,41297,87319,3,3194,'App\\Models\\Receipt',3194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',2301.18,NULL,NULL,1,'2023-04-12 20:43:45','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3930,7768,41297,87319,3,3195,'App\\Models\\Receipt',3195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',1470.01,NULL,NULL,1,'2023-04-12 20:43:45','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3931,7768,41297,87319,3,3196,'App\\Models\\Receipt',3196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',3320.02,NULL,NULL,1,'2023-04-12 20:43:45','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3932,7768,41297,87319,3,3197,'App\\Models\\Receipt',3197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',400.00,NULL,NULL,1,'2023-04-12 20:43:45','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3933,7768,41297,87319,3,3198,'App\\Models\\Receipt',3198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',1700.01,NULL,NULL,1,'2023-04-12 20:43:45','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3934,7768,41297,87319,3,3199,'App\\Models\\Receipt',3199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',8340.47,NULL,NULL,1,'2023-04-12 20:43:45','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3935,7768,41297,87319,3,3200,'App\\Models\\Receipt',3200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',1600.00,NULL,NULL,1,'2023-04-12 20:43:45','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3936,7768,41297,87319,3,3201,'App\\Models\\Receipt',3201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',2220.00,NULL,NULL,1,'2023-04-12 20:43:45','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3937,7768,41297,87319,3,3202,'App\\Models\\Receipt',3202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',4590.64,NULL,NULL,1,'2023-04-12 20:43:45','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3938,7768,41297,87319,3,3203,'App\\Models\\Receipt',3203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-06','2022-02-06',8300.81,NULL,NULL,1,'2023-04-12 20:43:45','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3939,7768,41297,87319,3,3204,'App\\Models\\Receipt',3204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',7200.35,NULL,NULL,1,'2023-04-12 20:43:45','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3940,7768,41297,87319,3,3205,'App\\Models\\Receipt',3205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',7276.77,NULL,NULL,1,'2023-04-12 20:43:45','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3941,7768,41297,87319,3,3206,'App\\Models\\Receipt',3206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',6848.73,NULL,NULL,1,'2023-04-12 20:43:45','2023-04-12 22:29:43','2023-04-12 22:29:43');
INSERT INTO `balance_libro` VALUES (3942,7768,41297,87319,3,3207,'App\\Models\\Receipt',3207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',6848.73,NULL,NULL,1,'2023-04-12 20:43:45','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3943,7768,41297,87319,3,3208,'App\\Models\\Receipt',3208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',33914.42,NULL,NULL,1,'2023-04-12 20:43:45','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3944,7768,41297,87319,3,3209,'App\\Models\\Receipt',3209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',13452.00,NULL,NULL,1,'2023-04-12 20:43:45','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3945,7768,41297,87319,3,3210,'App\\Models\\Receipt',3210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',19551.98,NULL,NULL,1,'2023-04-12 20:43:45','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3946,7768,41297,87319,3,3211,'App\\Models\\Receipt',3211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',81625.68,NULL,NULL,1,'2023-04-12 20:43:45','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3947,7768,41297,87319,3,3212,'App\\Models\\Receipt',3212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',70773.98,NULL,NULL,1,'2023-04-12 20:43:45','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3948,7768,41297,87319,3,3213,'App\\Models\\Receipt',3213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',65683.16,NULL,NULL,1,'2023-04-12 20:43:45','2023-04-12 22:29:43','2023-04-12 22:29:43'),(3949,7768,41297,87335,3,3214,'App\\Models\\Receipt',3214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',91503.23,NULL,NULL,1,'2023-04-12 21:38:29','2023-04-12 22:24:23','2023-04-12 22:24:23'),(3950,7768,41297,87335,3,3215,'App\\Models\\Receipt',3215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',728338.65,NULL,NULL,1,'2023-04-12 21:38:30','2023-04-12 22:24:23','2023-04-12 22:24:23'),(3951,7768,41297,87335,3,3216,'App\\Models\\Receipt',3216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',12841.39,NULL,NULL,1,'2023-04-12 21:38:30','2023-04-12 22:24:23','2023-04-12 22:24:23'),(3952,7768,41297,87335,3,3217,'App\\Models\\Receipt',3217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',306558.74,NULL,NULL,1,'2023-04-12 21:38:30','2023-04-12 22:24:23','2023-04-12 22:24:23'),(3953,7768,41297,87335,3,3218,'App\\Models\\Receipt',3218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',439.99,NULL,NULL,1,'2023-04-12 21:38:30','2023-04-12 22:24:23','2023-04-12 22:24:23'),(3954,7768,41297,87335,3,3219,'App\\Models\\Receipt',3219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',10476.66,NULL,NULL,1,'2023-04-12 21:38:30','2023-04-12 22:24:23','2023-04-12 22:24:23'),(3955,7768,41297,87335,3,3220,'App\\Models\\Receipt',3220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',2901.25,NULL,NULL,1,'2023-04-12 21:38:30','2023-04-12 22:24:23','2023-04-12 22:24:23'),(3956,7768,41297,87335,3,3221,'App\\Models\\Receipt',3221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',5892.66,NULL,NULL,1,'2023-04-12 21:38:30','2023-04-12 22:24:23','2023-04-12 22:24:23'),(3957,7768,41297,87335,3,3222,'App\\Models\\Receipt',3222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',5456.47,NULL,NULL,1,'2023-04-12 21:38:30','2023-04-12 22:24:23','2023-04-12 22:24:23'),(3958,7768,41297,87335,3,3223,'App\\Models\\Receipt',3223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',8101.64,NULL,NULL,1,'2023-04-12 21:38:30','2023-04-12 22:24:23','2023-04-12 22:24:23'),(3959,7768,41297,87335,3,3224,'App\\Models\\Receipt',3224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',4890.00,NULL,NULL,1,'2023-04-12 21:38:30','2023-04-12 22:24:23','2023-04-12 22:24:23'),(3960,7768,41297,87335,3,3225,'App\\Models\\Receipt',3225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',1800.00,NULL,NULL,1,'2023-04-12 21:38:30','2023-04-12 22:24:23','2023-04-12 22:24:23');
INSERT INTO `balance_libro` VALUES (3961,7768,41297,87335,3,3226,'App\\Models\\Receipt',3226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',553.39,NULL,NULL,1,'2023-04-12 21:38:30','2023-04-12 22:24:23','2023-04-12 22:24:23'),(3962,7768,41297,87335,3,3227,'App\\Models\\Receipt',3227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',10485.96,NULL,NULL,1,'2023-04-12 21:38:30','2023-04-12 22:24:23','2023-04-12 22:24:23'),(3963,7768,41297,87335,3,3228,'App\\Models\\Receipt',3228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',2649.95,NULL,NULL,1,'2023-04-12 21:38:30','2023-04-12 22:24:23','2023-04-12 22:24:23'),(3964,7768,41297,87335,3,3229,'App\\Models\\Receipt',3229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',749.99,NULL,NULL,1,'2023-04-12 21:38:30','2023-04-12 22:24:23','2023-04-12 22:24:23'),(3965,7768,41297,87335,3,3230,'App\\Models\\Receipt',3230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',8500.43,NULL,NULL,1,'2023-04-12 21:38:30','2023-04-12 22:24:23','2023-04-12 22:24:23'),(3966,7768,41297,87335,3,3231,'App\\Models\\Receipt',3231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',730.01,NULL,NULL,1,'2023-04-12 21:38:30','2023-04-12 22:24:23','2023-04-12 22:24:23'),(3967,7768,41297,87335,3,3232,'App\\Models\\Receipt',3232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',1600.00,NULL,NULL,1,'2023-04-12 21:38:30','2023-04-12 22:24:24','2023-04-12 22:24:24'),(3968,7768,41297,87335,3,3233,'App\\Models\\Receipt',3233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',1150.00,NULL,NULL,1,'2023-04-12 21:38:30','2023-04-12 22:24:24','2023-04-12 22:24:24'),(3969,7768,41297,87335,3,3234,'App\\Models\\Receipt',3234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',10000.03,NULL,NULL,1,'2023-04-12 21:38:30','2023-04-12 22:24:24','2023-04-12 22:24:24'),(3970,7768,41297,87335,3,3235,'App\\Models\\Receipt',3235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',2770.81,NULL,NULL,1,'2023-04-12 21:38:30','2023-04-12 22:24:24','2023-04-12 22:24:24'),(3971,7768,41297,87335,3,3236,'App\\Models\\Receipt',3236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',549.99,NULL,NULL,1,'2023-04-12 21:38:30','2023-04-12 22:24:24','2023-04-12 22:24:24'),(3972,7768,41297,87335,3,3237,'App\\Models\\Receipt',3237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',890.02,NULL,NULL,1,'2023-04-12 21:38:30','2023-04-12 22:24:24','2023-04-12 22:24:24'),(3973,7768,41297,87335,3,3238,'App\\Models\\Receipt',3238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',2205.01,NULL,NULL,1,'2023-04-12 21:38:30','2023-04-12 22:24:24','2023-04-12 22:24:24'),(3974,7768,41297,87335,3,3239,'App\\Models\\Receipt',3239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',1500.00,NULL,NULL,1,'2023-04-12 21:38:30','2023-04-12 22:24:24','2023-04-12 22:24:24'),(3975,7768,41297,87335,3,3240,'App\\Models\\Receipt',3240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',1640.00,NULL,NULL,1,'2023-04-12 21:38:30','2023-04-12 22:24:24','2023-04-12 22:24:24'),(3976,7768,41297,87335,3,3241,'App\\Models\\Receipt',3241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',6050.34,NULL,NULL,1,'2023-04-12 21:38:30','2023-04-12 22:24:24','2023-04-12 22:24:24'),(3977,7768,41297,87335,3,3242,'App\\Models\\Receipt',3242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',4800.86,NULL,NULL,1,'2023-04-12 21:38:30','2023-04-12 22:24:24','2023-04-12 22:24:24'),(3978,7768,41297,87335,3,3243,'App\\Models\\Receipt',3243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',2349.99,NULL,NULL,1,'2023-04-12 21:38:31','2023-04-12 22:24:24','2023-04-12 22:24:24'),(3979,7768,41297,87335,3,3244,'App\\Models\\Receipt',3244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',7500.30,NULL,NULL,1,'2023-04-12 21:38:31','2023-04-12 22:24:24','2023-04-12 22:24:24');
INSERT INTO `balance_libro` VALUES (3980,7768,41297,87335,3,3245,'App\\Models\\Receipt',3245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-13','2022-03-13',5538.45,NULL,NULL,1,'2023-04-12 21:38:31','2023-04-12 22:24:24','2023-04-12 22:24:24'),(3981,7768,41297,87335,3,3246,'App\\Models\\Receipt',3246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',5215.77,NULL,NULL,1,'2023-04-12 21:38:31','2023-04-12 22:24:24','2023-04-12 22:24:24'),(3982,7768,41297,87335,3,3247,'App\\Models\\Receipt',3247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',1240.00,NULL,NULL,1,'2023-04-12 21:38:31','2023-04-12 22:24:24','2023-04-12 22:24:24'),(3983,7768,41297,87335,3,3248,'App\\Models\\Receipt',3248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',950.00,NULL,NULL,1,'2023-04-12 21:38:31','2023-04-12 22:24:24','2023-04-12 22:24:24'),(3984,7768,41297,87335,3,3249,'App\\Models\\Receipt',3249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',2801.56,NULL,NULL,1,'2023-04-12 21:38:31','2023-04-12 22:24:24','2023-04-12 22:24:24'),(3985,7768,41297,87335,3,3250,'App\\Models\\Receipt',3250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',1070.00,NULL,NULL,1,'2023-04-12 21:38:31','2023-04-12 22:24:24','2023-04-12 22:24:24'),(3986,7768,41297,87335,3,3251,'App\\Models\\Receipt',3251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',240.00,NULL,NULL,1,'2023-04-12 21:38:31','2023-04-12 22:24:24','2023-04-12 22:24:24'),(3987,7768,41297,87335,3,3252,'App\\Models\\Receipt',3252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',950.00,NULL,NULL,1,'2023-04-12 21:38:31','2023-04-12 22:24:24','2023-04-12 22:24:24'),(3988,7768,41297,87335,3,3253,'App\\Models\\Receipt',3253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',6067.97,NULL,NULL,1,'2023-04-12 21:38:31','2023-04-12 22:24:24','2023-04-12 22:24:24'),(3989,7768,41297,87335,3,3254,'App\\Models\\Receipt',3254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',870.00,NULL,NULL,1,'2023-04-12 21:38:31','2023-04-12 22:24:24','2023-04-12 22:24:24'),(3990,7768,41297,87335,3,3255,'App\\Models\\Receipt',3255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',5100.29,NULL,NULL,1,'2023-04-12 21:38:31','2023-04-12 22:24:24','2023-04-12 22:24:24'),(3991,7768,41297,87335,3,3256,'App\\Models\\Receipt',3256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',93928.97,NULL,NULL,1,'2023-04-12 21:38:31','2023-04-12 22:24:24','2023-04-12 22:24:24'),(3992,7768,41297,87335,3,3257,'App\\Models\\Receipt',3257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',137778.71,NULL,NULL,1,'2023-04-12 21:38:31','2023-04-12 22:24:24','2023-04-12 22:24:24'),(3993,7768,41297,87335,3,3258,'App\\Models\\Receipt',3258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',137962.90,NULL,NULL,1,'2023-04-12 21:38:31','2023-04-12 22:24:24','2023-04-12 22:24:24'),(3994,7768,41297,87335,3,3259,'App\\Models\\Receipt',3259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',113117.74,NULL,NULL,1,'2023-04-12 21:38:31','2023-04-12 22:24:24','2023-04-12 22:24:24'),(3995,7768,41297,87335,3,3260,'App\\Models\\Receipt',3260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',207139.40,NULL,NULL,1,'2023-04-12 21:38:31','2023-04-12 22:24:24','2023-04-12 22:24:24'),(3996,7768,41297,87335,3,3261,'App\\Models\\Receipt',3261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',259514.82,NULL,NULL,1,'2023-04-12 21:38:31','2023-04-12 22:24:24','2023-04-12 22:24:24'),(3997,7768,41297,87335,3,3262,'App\\Models\\Receipt',3262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',360221.83,NULL,NULL,1,'2023-04-12 21:38:31','2023-04-12 22:24:24','2023-04-12 22:24:24'),(3998,7768,41297,87335,3,3263,'App\\Models\\Receipt',3263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',83792.50,NULL,NULL,1,'2023-04-12 21:38:31','2023-04-12 22:24:24','2023-04-12 22:24:24');
INSERT INTO `balance_libro` VALUES (3999,7768,41297,87335,3,3264,'App\\Models\\Receipt',3264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',3044.54,NULL,NULL,1,'2023-04-12 21:38:31','2023-04-12 22:24:24','2023-04-12 22:24:24'),(4000,7768,41297,87335,3,3265,'App\\Models\\Receipt',3265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',9447.77,NULL,NULL,1,'2023-04-12 21:38:31','2023-04-12 22:24:24','2023-04-12 22:24:24'),(4001,7768,41297,87335,3,3266,'App\\Models\\Receipt',3266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',4759.11,NULL,NULL,1,'2023-04-12 21:38:31','2023-04-12 22:24:24','2023-04-12 22:24:24'),(4002,7768,41297,87335,3,3267,'App\\Models\\Receipt',3267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',757.29,NULL,NULL,1,'2023-04-12 21:38:31','2023-04-12 22:24:24','2023-04-12 22:24:24'),(4003,7768,41297,87335,3,3268,'App\\Models\\Receipt',3268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',148.54,NULL,NULL,1,'2023-04-12 21:38:31','2023-04-12 22:24:24','2023-04-12 22:24:24'),(4004,7768,41297,87335,3,3269,'App\\Models\\Receipt',3269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',968.00,NULL,NULL,1,'2023-04-12 21:38:31','2023-04-12 22:24:24','2023-04-12 22:24:24'),(4005,7768,41297,87335,3,3270,'App\\Models\\Receipt',3270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',769368.70,NULL,NULL,1,'2023-04-12 21:38:31','2023-04-12 22:24:24','2023-04-12 22:24:24'),(4006,7768,41297,87335,3,3271,'App\\Models\\Receipt',3271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',244938.86,NULL,NULL,1,'2023-04-12 21:38:31','2023-04-12 22:24:24','2023-04-12 22:24:24'),(4007,7768,41297,87335,3,3272,'App\\Models\\Receipt',3272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',972400.00,NULL,NULL,1,'2023-04-12 21:38:31','2023-04-12 22:24:24','2023-04-12 22:24:24'),(4008,7768,41297,87335,3,3273,'App\\Models\\Receipt',3273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',948403.23,NULL,NULL,1,'2023-04-12 21:38:31','2023-04-12 22:24:24','2023-04-12 22:24:24'),(4009,7768,41297,87335,3,3274,'App\\Models\\Receipt',3274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',315800.00,NULL,NULL,1,'2023-04-12 21:38:32','2023-04-12 22:24:24','2023-04-12 22:24:24'),(4010,7768,41297,87335,3,3275,'App\\Models\\Receipt',3275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',22329.00,NULL,NULL,1,'2023-04-12 21:38:32','2023-04-12 22:24:24','2023-04-12 22:24:24'),(4011,7768,41297,87335,3,3276,'App\\Models\\Receipt',3276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',920.00,NULL,NULL,1,'2023-04-12 21:38:32','2023-04-12 22:24:24','2023-04-12 22:24:24'),(4012,7768,41297,87335,3,3277,'App\\Models\\Receipt',3277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',7008.60,NULL,NULL,1,'2023-04-12 21:38:32','2023-04-12 22:24:24','2023-04-12 22:24:24'),(4013,7768,41297,87335,3,3278,'App\\Models\\Receipt',3278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',237362.55,NULL,NULL,1,'2023-04-12 21:38:32','2023-04-12 22:24:24','2023-04-12 22:24:24'),(4014,7768,41297,87335,3,3279,'App\\Models\\Receipt',3279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',19988.43,NULL,NULL,1,'2023-04-12 21:38:32','2023-04-12 22:24:24','2023-04-12 22:24:24'),(4015,7768,41297,87335,3,3280,'App\\Models\\Receipt',3280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',135710.89,NULL,NULL,1,'2023-04-12 21:38:32','2023-04-12 22:24:24','2023-04-12 22:24:24'),(4016,7768,41297,87335,3,3281,'App\\Models\\Receipt',3281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',1512413.70,NULL,NULL,1,'2023-04-12 21:38:32','2023-04-12 22:24:24','2023-04-12 22:24:24'),(4017,7768,41297,87335,3,3282,'App\\Models\\Receipt',3282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',1387055.71,NULL,NULL,1,'2023-04-12 21:38:32','2023-04-12 22:24:24','2023-04-12 22:24:24');
INSERT INTO `balance_libro` VALUES (4018,7768,41297,87335,3,3283,'App\\Models\\Receipt',3283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',905488.50,NULL,NULL,1,'2023-04-12 21:38:32','2023-04-12 22:24:24','2023-04-12 22:24:24'),(4019,7768,41297,87335,3,3284,'App\\Models\\Receipt',3284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',1786658.60,NULL,NULL,1,'2023-04-12 21:38:32','2023-04-12 22:24:24','2023-04-12 22:24:24'),(4020,7768,41297,87335,3,3285,'App\\Models\\Receipt',3285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',1121148.25,NULL,NULL,1,'2023-04-12 21:38:32','2023-04-12 22:24:24','2023-04-12 22:24:24'),(4021,7768,41297,87335,3,3286,'App\\Models\\Receipt',3286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',71995.00,NULL,NULL,1,'2023-04-12 21:38:32','2023-04-12 22:24:24','2023-04-12 22:24:24'),(4022,7768,41297,87335,3,3287,'App\\Models\\Receipt',3287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',474688.37,NULL,NULL,1,'2023-04-12 21:38:32','2023-04-12 22:24:24','2023-04-12 22:24:24'),(4023,7768,41297,87335,3,3288,'App\\Models\\Receipt',3288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',400912.51,NULL,NULL,1,'2023-04-12 21:38:32','2023-04-12 22:24:24','2023-04-12 22:24:24'),(4024,7768,41297,87335,3,3289,'App\\Models\\Receipt',3289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',251326.68,NULL,NULL,1,'2023-04-12 21:38:32','2023-04-12 22:24:24','2023-04-12 22:24:24'),(4025,7768,41297,87335,3,3290,'App\\Models\\Receipt',3290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',791023.46,NULL,NULL,1,'2023-04-12 21:38:32','2023-04-12 22:24:24','2023-04-12 22:24:24'),(4026,7768,41297,87335,3,3291,'App\\Models\\Receipt',3291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',70470.00,NULL,NULL,1,'2023-04-12 21:38:32','2023-04-12 22:24:24','2023-04-12 22:24:24'),(4027,7768,41297,87335,3,3292,'App\\Models\\Receipt',3292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',91600.00,NULL,NULL,1,'2023-04-12 21:38:32','2023-04-12 22:24:24','2023-04-12 22:24:24'),(4028,7768,41297,87335,3,3293,'App\\Models\\Receipt',3293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',74023.95,NULL,NULL,1,'2023-04-12 21:38:32','2023-04-12 22:24:24','2023-04-12 22:24:24'),(4029,7768,41297,87335,3,3294,'App\\Models\\Receipt',3294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',38588.47,NULL,NULL,1,'2023-04-12 21:38:32','2023-04-12 22:24:24','2023-04-12 22:24:24'),(4030,7768,41297,87335,3,3295,'App\\Models\\Receipt',3295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',11550.00,NULL,NULL,1,'2023-04-12 21:38:32','2023-04-12 22:24:24','2023-04-12 22:24:24'),(4031,7768,41297,87335,3,3296,'App\\Models\\Receipt',3296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',67760.00,NULL,NULL,1,'2023-04-12 21:38:32','2023-04-12 22:24:24','2023-04-12 22:24:24'),(4032,7768,41297,87335,3,3297,'App\\Models\\Receipt',3297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',11550.00,NULL,NULL,1,'2023-04-12 21:38:32','2023-04-12 22:24:24','2023-04-12 22:24:24'),(4033,7768,41297,87335,3,3298,'App\\Models\\Receipt',3298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',4022.09,NULL,NULL,1,'2023-04-12 21:38:32','2023-04-12 22:24:24','2023-04-12 22:24:24'),(4034,7768,41297,87335,3,3299,'App\\Models\\Receipt',3299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',242268.47,NULL,NULL,1,'2023-04-12 21:38:32','2023-04-12 22:24:24','2023-04-12 22:24:24'),(4035,7768,41297,87335,3,3300,'App\\Models\\Receipt',3300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',51408.85,NULL,NULL,1,'2023-04-12 21:38:32','2023-04-12 22:24:24','2023-04-12 22:24:24'),(4036,7768,41297,87335,3,3301,'App\\Models\\Receipt',3301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',6900.00,NULL,NULL,1,'2023-04-12 21:38:32','2023-04-12 22:24:24','2023-04-12 22:24:24');
INSERT INTO `balance_libro` VALUES (4037,7768,41297,87335,3,3302,'App\\Models\\Receipt',3302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',2937.98,NULL,NULL,1,'2023-04-12 21:38:32','2023-04-12 22:24:24','2023-04-12 22:24:24'),(4038,7768,41297,87335,3,3303,'App\\Models\\Receipt',3303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',8445.05,NULL,NULL,1,'2023-04-12 21:38:32','2023-04-12 22:24:25','2023-04-12 22:24:25'),(4039,7768,41297,87335,3,3304,'App\\Models\\Receipt',3304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',859052.68,NULL,NULL,1,'2023-04-12 21:38:32','2023-04-12 22:24:25','2023-04-12 22:24:25'),(4040,7768,41297,87335,3,3305,'App\\Models\\Receipt',3305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',148253.87,NULL,NULL,1,'2023-04-12 21:38:33','2023-04-12 22:24:25','2023-04-12 22:24:25'),(4041,7768,41297,87335,3,3306,'App\\Models\\Receipt',3306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',3582.81,NULL,NULL,1,'2023-04-12 21:38:33','2023-04-12 22:24:25','2023-04-12 22:24:25'),(4042,7768,41297,87335,3,3307,'App\\Models\\Receipt',3307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',409651.67,NULL,NULL,1,'2023-04-12 21:38:33','2023-04-12 22:24:25','2023-04-12 22:24:25'),(4043,7768,41297,87335,3,3308,'App\\Models\\Receipt',3308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',24200.00,NULL,NULL,1,'2023-04-12 21:38:33','2023-04-12 22:24:25','2023-04-12 22:24:25'),(4044,7768,41297,87335,3,3309,'App\\Models\\Receipt',3309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',22152.99,NULL,NULL,1,'2023-04-12 21:38:33','2023-04-12 22:24:25','2023-04-12 22:24:25'),(4045,7768,41297,87335,3,3310,'App\\Models\\Receipt',3310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',13523.25,NULL,NULL,1,'2023-04-12 21:38:33','2023-04-12 22:24:25','2023-04-12 22:24:25'),(4046,7768,41297,87335,3,3311,'App\\Models\\Receipt',3311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',7910.00,NULL,NULL,1,'2023-04-12 21:38:33','2023-04-12 22:24:25','2023-04-12 22:24:25'),(4047,7768,41297,87335,3,3312,'App\\Models\\Receipt',3312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',39754.04,NULL,NULL,1,'2023-04-12 21:38:33','2023-04-12 22:24:25','2023-04-12 22:24:25'),(4048,7768,41297,87335,3,3313,'App\\Models\\Receipt',3313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1426.19,NULL,NULL,1,'2023-04-12 21:38:33','2023-04-12 22:24:25','2023-04-12 22:24:25'),(4049,7768,41297,87335,3,3314,'App\\Models\\Receipt',3314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1530.79,NULL,NULL,1,'2023-04-12 21:38:33','2023-04-12 22:24:25','2023-04-12 22:24:25'),(4050,7768,41297,87335,3,3315,'App\\Models\\Receipt',3315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1901849.61,NULL,NULL,1,'2023-04-12 21:38:33','2023-04-12 22:24:25','2023-04-12 22:24:25'),(4051,7768,41297,87335,3,3316,'App\\Models\\Receipt',3316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',270765.17,NULL,NULL,1,'2023-04-12 21:38:33','2023-04-12 22:24:25','2023-04-12 22:24:25'),(4052,7768,41297,87335,3,3317,'App\\Models\\Receipt',3317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',119984.47,NULL,NULL,1,'2023-04-12 21:38:33','2023-04-12 22:24:25','2023-04-12 22:24:25'),(4053,7768,41297,87335,3,3318,'App\\Models\\Receipt',3318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',74223.76,NULL,NULL,1,'2023-04-12 21:38:33','2023-04-12 22:24:25','2023-04-12 22:24:25'),(4054,7768,41297,87335,3,3319,'App\\Models\\Receipt',3319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',114642.58,NULL,NULL,1,'2023-04-12 21:38:33','2023-04-12 22:24:25','2023-04-12 22:24:25'),(4055,7768,41297,87335,3,3320,'App\\Models\\Receipt',3320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',4300.00,NULL,NULL,1,'2023-04-12 21:38:33','2023-04-12 22:24:25','2023-04-12 22:24:25');
INSERT INTO `balance_libro` VALUES (4056,7768,41297,87335,3,3321,'App\\Models\\Receipt',3321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',119984.47,NULL,NULL,1,'2023-04-12 21:38:33','2023-04-12 22:24:25','2023-04-12 22:24:25'),(4057,7768,41297,87335,3,3322,'App\\Models\\Receipt',3322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',74223.76,NULL,NULL,1,'2023-04-12 21:38:33','2023-04-12 22:24:25','2023-04-12 22:24:25'),(4058,7768,41297,87335,3,3323,'App\\Models\\Receipt',3323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',114642.58,NULL,NULL,1,'2023-04-12 21:38:33','2023-04-12 22:24:25','2023-04-12 22:24:25'),(4059,7768,41297,87335,3,3324,'App\\Models\\Receipt',3324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',5017.91,NULL,NULL,1,'2023-04-12 21:38:33','2023-04-12 22:24:25','2023-04-12 22:24:25'),(4060,7768,41297,87335,3,3325,'App\\Models\\Receipt',3325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',38741.52,NULL,NULL,1,'2023-04-12 21:38:33','2023-04-12 22:24:25','2023-04-12 22:24:25'),(4061,7768,41297,87335,3,3326,'App\\Models\\Receipt',3326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',42898.73,NULL,NULL,1,'2023-04-12 21:38:33','2023-04-12 22:24:25','2023-04-12 22:24:25'),(4108,7768,41297,87321,3,3373,'App\\Models\\Receipt',3373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',40000.00,NULL,NULL,1,'2023-04-12 21:40:21','2023-04-12 21:40:21',NULL),(4109,7768,41297,87321,3,3374,'App\\Models\\Receipt',3374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',20000.00,NULL,NULL,1,'2023-04-12 21:40:21','2023-04-12 21:40:21',NULL),(4110,7768,41297,87321,3,3375,'App\\Models\\Receipt',3375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',4300.00,NULL,NULL,1,'2023-04-12 21:40:21','2023-04-12 21:40:21',NULL),(4111,7768,41297,87321,3,3376,'App\\Models\\Receipt',3376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',875732.44,NULL,NULL,1,'2023-04-12 21:40:21','2023-04-12 21:40:21',NULL),(4112,7768,41297,87321,3,3377,'App\\Models\\Receipt',3377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',11480.54,NULL,NULL,1,'2023-04-12 21:40:21','2023-04-12 21:40:21',NULL),(4113,7768,41297,87321,3,3378,'App\\Models\\Receipt',3378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',269193.24,NULL,NULL,1,'2023-04-12 21:40:21','2023-04-12 21:40:21',NULL),(4114,7768,41297,87321,3,3379,'App\\Models\\Receipt',3379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',2655.13,NULL,NULL,1,'2023-04-12 21:40:21','2023-04-12 21:40:21',NULL),(4115,7768,41297,87321,3,3380,'App\\Models\\Receipt',3380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',4658.50,NULL,NULL,1,'2023-04-12 21:40:22','2023-04-12 21:40:22',NULL),(4116,7768,41297,87321,3,3381,'App\\Models\\Receipt',3381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',3300.63,NULL,NULL,1,'2023-04-12 21:40:22','2023-04-12 21:40:22',NULL),(4117,7768,41297,87321,3,3382,'App\\Models\\Receipt',3382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-16','2022-04-16',520.00,NULL,NULL,1,'2023-04-12 21:40:22','2023-04-12 21:40:22',NULL),(4118,7768,41297,87321,3,3383,'App\\Models\\Receipt',3383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-16','2022-04-16',1100.00,NULL,NULL,1,'2023-04-12 21:40:22','2023-04-12 21:40:22',NULL),(4119,7768,41297,87321,3,3384,'App\\Models\\Receipt',3384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-15','2022-04-15',10047.76,NULL,NULL,1,'2023-04-12 21:40:22','2023-04-12 21:40:22',NULL),(4120,7768,41297,87321,3,3385,'App\\Models\\Receipt',3385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-15','2022-04-15',9000.42,NULL,NULL,1,'2023-04-12 21:40:22','2023-04-12 21:40:22',NULL),(4121,7768,41297,87321,3,3386,'App\\Models\\Receipt',3386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',1100.00,NULL,NULL,1,'2023-04-12 21:40:22','2023-04-12 21:40:22',NULL);
INSERT INTO `balance_libro` VALUES (4122,7768,41297,87321,3,3387,'App\\Models\\Receipt',3387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',1490.01,NULL,NULL,1,'2023-04-12 21:40:22','2023-04-12 21:40:22',NULL),(4123,7768,41297,87321,3,3388,'App\\Models\\Receipt',3388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',2300.01,NULL,NULL,1,'2023-04-12 21:40:22','2023-04-12 21:40:22',NULL),(4124,7768,41297,87321,3,3389,'App\\Models\\Receipt',3389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',4600.00,NULL,NULL,1,'2023-04-12 21:40:22','2023-04-12 21:40:22',NULL),(4125,7768,41297,87321,3,3390,'App\\Models\\Receipt',3390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',11001.09,NULL,NULL,1,'2023-04-12 21:40:22','2023-04-12 21:40:22',NULL),(4126,7768,41297,87321,3,3391,'App\\Models\\Receipt',3391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-24','2022-04-24',12446.57,NULL,NULL,1,'2023-04-12 21:40:22','2023-04-12 21:40:22',NULL),(4127,7768,41297,87321,3,3392,'App\\Models\\Receipt',3392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',94432.50,NULL,NULL,1,'2023-04-12 21:40:22','2023-04-12 21:40:22',NULL),(4128,7768,41297,87321,3,3393,'App\\Models\\Receipt',3393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',10044.46,NULL,NULL,1,'2023-04-12 21:40:22','2023-04-12 21:40:22',NULL),(4129,7768,41297,87321,3,3394,'App\\Models\\Receipt',3394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',7174.62,NULL,NULL,1,'2023-04-12 21:40:22','2023-04-12 21:40:22',NULL),(4130,7768,41297,87321,3,3395,'App\\Models\\Receipt',3395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',11904.78,NULL,NULL,1,'2023-04-12 21:40:22','2023-04-12 21:40:22',NULL),(4131,7768,41297,87321,3,3396,'App\\Models\\Receipt',3396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-16','2022-04-16',7900.43,NULL,NULL,1,'2023-04-12 21:40:22','2023-04-12 21:40:22',NULL),(4132,7768,41297,87321,3,3397,'App\\Models\\Receipt',3397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',2150.00,NULL,NULL,1,'2023-04-12 21:40:22','2023-04-12 21:40:22',NULL),(4133,7768,41297,87321,3,3398,'App\\Models\\Receipt',3398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',3130.00,NULL,NULL,1,'2023-04-12 21:40:22','2023-04-12 21:40:22',NULL),(4134,7768,41297,87321,3,3399,'App\\Models\\Receipt',3399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',3930.00,NULL,NULL,1,'2023-04-12 21:40:22','2023-04-12 21:40:22',NULL),(4135,7768,41297,87321,3,3400,'App\\Models\\Receipt',3400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',2040.00,NULL,NULL,1,'2023-04-12 21:40:22','2023-04-12 21:40:22',NULL),(4136,7768,41297,87321,3,3401,'App\\Models\\Receipt',3401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',2150.00,NULL,NULL,1,'2023-04-12 21:40:22','2023-04-12 21:40:22',NULL),(4137,7768,41297,87321,3,3402,'App\\Models\\Receipt',3402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',9300.50,NULL,NULL,1,'2023-04-12 21:40:22','2023-04-12 21:40:22',NULL),(4138,7768,41297,87321,3,3403,'App\\Models\\Receipt',3403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',40.00,NULL,NULL,1,'2023-04-12 21:40:22','2023-04-12 21:40:22',NULL),(4139,7768,41297,87321,3,3404,'App\\Models\\Receipt',3404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',1950.01,NULL,NULL,1,'2023-04-12 21:40:23','2023-04-12 21:40:23',NULL),(4140,7768,41297,87321,3,3405,'App\\Models\\Receipt',3405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',8348.04,NULL,NULL,1,'2023-04-12 21:40:23','2023-04-12 21:40:23',NULL),(4141,7768,41297,87321,3,3406,'App\\Models\\Receipt',3406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',10734.00,NULL,NULL,1,'2023-04-12 21:40:23','2023-04-12 21:40:23',NULL),(4142,7768,41297,87321,3,3407,'App\\Models\\Receipt',3407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',5949.77,NULL,NULL,1,'2023-04-12 21:40:23','2023-04-12 21:40:23',NULL);
INSERT INTO `balance_libro` VALUES (4143,7768,41297,87321,3,3408,'App\\Models\\Receipt',3408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',750.01,NULL,NULL,1,'2023-04-12 21:40:23','2023-04-12 21:40:23',NULL),(4144,7768,41297,87321,3,3409,'App\\Models\\Receipt',3409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-10','2022-04-10',9804.86,NULL,NULL,1,'2023-04-12 21:40:23','2023-04-12 21:40:23',NULL),(4145,7768,41297,87321,3,3410,'App\\Models\\Receipt',3410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',10153.77,NULL,NULL,1,'2023-04-12 21:40:23','2023-04-12 21:40:23',NULL),(4146,7768,41297,87321,3,3411,'App\\Models\\Receipt',3411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',720.00,NULL,NULL,1,'2023-04-12 21:40:23','2023-04-12 21:40:23',NULL),(4147,7768,41297,87321,3,3412,'App\\Models\\Receipt',3412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',439.99,NULL,NULL,1,'2023-04-12 21:40:23','2023-04-12 21:40:23',NULL),(4148,7768,41297,87321,3,3413,'App\\Models\\Receipt',3413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',287.73,NULL,NULL,1,'2023-04-12 21:40:23','2023-04-12 21:40:23',NULL),(4149,7768,41297,87321,3,3414,'App\\Models\\Receipt',3414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',287.73,NULL,NULL,1,'2023-04-12 21:40:23','2023-04-12 21:40:23',NULL),(4150,7768,41297,87321,3,3415,'App\\Models\\Receipt',3415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',974.57,NULL,NULL,1,'2023-04-12 21:40:23','2023-04-12 21:40:23',NULL),(4151,7768,41297,87321,3,3416,'App\\Models\\Receipt',3416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-01','2022-03-01',8502.24,NULL,NULL,1,'2023-04-12 21:40:23','2023-04-12 21:40:23',NULL),(4152,7768,41297,87321,3,3417,'App\\Models\\Receipt',3417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',3260.00,NULL,NULL,1,'2023-04-12 21:40:23','2023-04-12 21:40:23',NULL),(4153,7768,41297,87321,3,3418,'App\\Models\\Receipt',3418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',50211.17,NULL,NULL,1,'2023-04-12 21:40:23','2023-04-12 21:40:23',NULL),(4154,7768,41297,87321,3,3419,'App\\Models\\Receipt',3419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',192998.46,NULL,NULL,1,'2023-04-12 21:40:23','2023-04-12 21:40:23',NULL),(4155,7768,41297,87321,3,3420,'App\\Models\\Receipt',3420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',147870.97,NULL,NULL,1,'2023-04-12 21:40:23','2023-04-12 21:40:23',NULL),(4156,7768,41297,87321,3,3421,'App\\Models\\Receipt',3421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',27764.39,NULL,NULL,1,'2023-04-12 21:40:23','2023-04-12 21:40:23',NULL),(4157,7768,41297,87321,3,3422,'App\\Models\\Receipt',3422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',40718.78,NULL,NULL,1,'2023-04-12 21:40:23','2023-04-12 21:40:23',NULL),(4158,7768,41297,87321,3,3423,'App\\Models\\Receipt',3423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-03','2022-04-03',81059.66,NULL,NULL,1,'2023-04-12 21:40:23','2023-04-12 21:40:23',NULL),(4159,7768,41297,87321,3,3424,'App\\Models\\Receipt',3424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',80306.70,NULL,NULL,1,'2023-04-12 21:40:23','2023-04-12 21:40:23',NULL),(4160,7768,41297,87321,3,3425,'App\\Models\\Receipt',3425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',21648.11,NULL,NULL,1,'2023-04-12 21:40:23','2023-04-12 21:40:23',NULL),(4161,7768,41297,87321,3,3426,'App\\Models\\Receipt',3426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',13025.99,NULL,NULL,1,'2023-04-12 21:40:23','2023-04-12 21:40:23',NULL),(4162,7768,41297,87321,3,3427,'App\\Models\\Receipt',3427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',22459.13,NULL,NULL,1,'2023-04-12 21:40:23','2023-04-12 21:40:23',NULL),(4248,7768,41297,87323,3,3513,'App\\Models\\Receipt',3513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',4300.00,NULL,NULL,1,'2023-04-12 21:43:58','2023-04-12 21:43:58',NULL);
INSERT INTO `balance_libro` VALUES (4249,7768,41297,87323,3,3514,'App\\Models\\Receipt',3514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',410371.47,NULL,NULL,1,'2023-04-12 21:43:58','2023-04-12 21:43:58',NULL),(4250,7768,41297,87323,3,3515,'App\\Models\\Receipt',3515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',81031.86,NULL,NULL,1,'2023-04-12 21:43:58','2023-04-12 21:43:58',NULL),(4251,7768,41297,87323,3,3516,'App\\Models\\Receipt',3516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',452805.78,NULL,NULL,1,'2023-04-12 21:43:58','2023-04-12 21:43:58',NULL),(4252,7768,41297,87323,3,3517,'App\\Models\\Receipt',3517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',67291.68,NULL,NULL,1,'2023-04-12 21:43:58','2023-04-12 21:43:58',NULL),(4253,7768,41297,87323,3,3518,'App\\Models\\Receipt',3518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',351701.02,NULL,NULL,1,'2023-04-12 21:43:58','2023-04-12 21:43:58',NULL),(4254,7768,41297,87323,3,3519,'App\\Models\\Receipt',3519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',9253.46,NULL,NULL,1,'2023-04-12 21:43:58','2023-04-12 21:43:58',NULL),(4255,7768,41297,87323,3,3520,'App\\Models\\Receipt',3520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',94141.08,NULL,NULL,1,'2023-04-12 21:43:58','2023-04-12 21:43:58',NULL),(4256,7768,41297,87323,3,3521,'App\\Models\\Receipt',3521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',297641.21,NULL,NULL,1,'2023-04-12 21:43:58','2023-04-12 21:43:58',NULL),(4257,7768,41297,87323,3,3522,'App\\Models\\Receipt',3522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',7157.84,NULL,NULL,1,'2023-04-12 21:43:58','2023-04-12 21:43:58',NULL),(4258,7768,41297,87323,3,3523,'App\\Models\\Receipt',3523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',164491.10,NULL,NULL,1,'2023-04-12 21:43:58','2023-04-12 21:43:58',NULL),(4259,7768,41297,87323,3,3524,'App\\Models\\Receipt',3524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',28000.00,NULL,NULL,1,'2023-04-12 21:43:58','2023-04-12 21:43:58',NULL),(4260,7768,41297,87323,3,3525,'App\\Models\\Receipt',3525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',356015.65,NULL,NULL,1,'2023-04-12 21:43:58','2023-04-12 21:43:58',NULL),(4261,7768,41297,87323,3,3526,'App\\Models\\Receipt',3526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',30485.12,NULL,NULL,1,'2023-04-12 21:43:58','2023-04-12 21:43:58',NULL),(4262,7768,41297,87323,3,3527,'App\\Models\\Receipt',3527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',30065.60,NULL,NULL,1,'2023-04-12 21:43:58','2023-04-12 21:43:58',NULL),(4263,7768,41297,87323,3,3528,'App\\Models\\Receipt',3528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',27693.90,NULL,NULL,1,'2023-04-12 21:43:59','2023-04-12 21:43:59',NULL),(4264,7768,41297,87323,3,3529,'App\\Models\\Receipt',3529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',63231.97,NULL,NULL,1,'2023-04-12 21:43:59','2023-04-12 21:43:59',NULL),(4265,7768,41297,87323,3,3530,'App\\Models\\Receipt',3530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',312677.78,NULL,NULL,1,'2023-04-12 21:43:59','2023-04-12 21:43:59',NULL),(4266,7768,41297,87323,3,3531,'App\\Models\\Receipt',3531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',161729.93,NULL,NULL,1,'2023-04-12 21:43:59','2023-04-12 21:43:59',NULL),(4267,7768,41297,87323,3,3532,'App\\Models\\Receipt',3532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',89928.28,NULL,NULL,1,'2023-04-12 21:43:59','2023-04-12 21:43:59',NULL),(4268,7768,41297,87323,3,3533,'App\\Models\\Receipt',3533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',146664.29,NULL,NULL,1,'2023-04-12 21:43:59','2023-04-12 21:43:59',NULL);
INSERT INTO `balance_libro` VALUES (4269,7768,41297,87323,3,3534,'App\\Models\\Receipt',3534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-15','2022-06-15',218418.81,NULL,NULL,1,'2023-04-12 21:43:59','2023-04-12 21:43:59',NULL),(4270,7768,41297,87323,3,3535,'App\\Models\\Receipt',3535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',25492.81,NULL,NULL,1,'2023-04-12 21:43:59','2023-04-12 21:43:59',NULL),(4331,7768,41297,87324,3,3596,'App\\Models\\Receipt',3596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',37139.60,NULL,NULL,1,'2023-04-12 21:46:04','2023-04-12 21:46:04',NULL),(4332,7768,41297,87324,3,3597,'App\\Models\\Receipt',3597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',38261.03,NULL,NULL,1,'2023-04-12 21:46:04','2023-04-12 21:46:04',NULL),(4333,7768,41297,87324,3,3598,'App\\Models\\Receipt',3598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',97286.86,NULL,NULL,1,'2023-04-12 21:46:04','2023-04-12 21:46:04',NULL),(4334,7768,41297,87324,3,3599,'App\\Models\\Receipt',3599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',38988.54,NULL,NULL,1,'2023-04-12 21:46:05','2023-04-12 21:46:05',NULL),(4335,7768,41297,87324,3,3600,'App\\Models\\Receipt',3600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-16','2022-07-16',58482.82,NULL,NULL,1,'2023-04-12 21:46:05','2023-04-12 21:46:05',NULL),(4336,7768,41297,87324,3,3601,'App\\Models\\Receipt',3601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',48329.84,NULL,NULL,1,'2023-04-12 21:46:05','2023-04-12 21:46:05',NULL),(4337,7768,41297,87324,3,3602,'App\\Models\\Receipt',3602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',53923.56,NULL,NULL,1,'2023-04-12 21:46:05','2023-04-12 21:46:05',NULL),(4338,7768,41297,87324,3,3603,'App\\Models\\Receipt',3603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-02','2022-06-02',30027.13,NULL,NULL,1,'2023-04-12 21:46:05','2023-04-12 21:46:05',NULL),(4339,7768,41297,87324,3,3604,'App\\Models\\Receipt',3604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',12851.11,NULL,NULL,1,'2023-04-12 21:46:05','2023-04-12 21:46:05',NULL),(4340,7768,41297,87324,3,3605,'App\\Models\\Receipt',3605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',8205.20,NULL,NULL,1,'2023-04-12 21:46:05','2023-04-12 21:46:05',NULL),(4341,7768,41297,87324,3,3606,'App\\Models\\Receipt',3606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-29','2022-06-29',7802.43,NULL,NULL,1,'2023-04-12 21:46:05','2023-04-12 21:46:05',NULL),(4342,7768,41297,87324,3,3607,'App\\Models\\Receipt',3607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',9700.79,NULL,NULL,1,'2023-04-12 21:46:05','2023-04-12 21:46:05',NULL),(4343,7768,41297,87324,3,3608,'App\\Models\\Receipt',3608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',14547.77,NULL,NULL,1,'2023-04-12 21:46:05','2023-04-12 21:46:05',NULL),(4344,7768,41297,87324,3,3609,'App\\Models\\Receipt',3609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',11911.45,NULL,NULL,1,'2023-04-12 21:46:05','2023-04-12 21:46:05',NULL),(4345,7768,41297,87324,3,3610,'App\\Models\\Receipt',3610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',11025.48,NULL,NULL,1,'2023-04-12 21:46:05','2023-04-12 21:46:05',NULL),(4346,7768,41297,87324,3,3611,'App\\Models\\Receipt',3611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',9523.04,NULL,NULL,1,'2023-04-12 21:46:05','2023-04-12 21:46:05',NULL),(4347,7768,41297,87324,3,3612,'App\\Models\\Receipt',3612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',283600.00,NULL,NULL,1,'2023-04-12 21:46:05','2023-04-12 21:46:05',NULL),(4348,7768,41297,87324,3,3613,'App\\Models\\Receipt',3613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',51772.00,NULL,NULL,1,'2023-04-12 21:46:05','2023-04-12 21:46:05',NULL),(4349,7768,41297,87324,3,3614,'App\\Models\\Receipt',3614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-03','2022-06-03',124990.00,NULL,NULL,1,'2023-04-12 21:46:05','2023-04-12 21:46:05',NULL);
INSERT INTO `balance_libro` VALUES (4350,7768,41297,87324,3,3615,'App\\Models\\Receipt',3615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',12260.79,NULL,NULL,1,'2023-04-12 21:46:05','2023-04-12 21:46:05',NULL),(4351,7768,41297,87324,3,3616,'App\\Models\\Receipt',3616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-24','2022-06-24',12834.43,NULL,NULL,1,'2023-04-12 21:46:05','2023-04-12 21:46:05',NULL),(4352,7768,41297,87324,3,3617,'App\\Models\\Receipt',3617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-14','2022-06-14',11754.98,NULL,NULL,1,'2023-04-12 21:46:05','2023-04-12 21:46:05',NULL),(4353,7768,41297,87324,3,3618,'App\\Models\\Receipt',3618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',16368.40,NULL,NULL,1,'2023-04-12 21:46:05','2023-04-12 21:46:05',NULL),(4354,7768,41297,87324,3,3619,'App\\Models\\Receipt',3619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',12638.49,NULL,NULL,1,'2023-04-12 21:46:05','2023-04-12 21:46:05',NULL),(4355,7768,41297,87324,3,3620,'App\\Models\\Receipt',3620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-01','2022-06-01',13426.01,NULL,NULL,1,'2023-04-12 21:46:05','2023-04-12 21:46:05',NULL),(4356,7768,41297,87324,3,3621,'App\\Models\\Receipt',3621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-27','2022-06-27',13955.26,NULL,NULL,1,'2023-04-12 21:46:05','2023-04-12 21:46:05',NULL),(4357,7768,41297,87324,3,3622,'App\\Models\\Receipt',3622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-20','2022-06-20',13841.47,NULL,NULL,1,'2023-04-12 21:46:05','2023-04-12 21:46:05',NULL),(4358,7768,41297,87324,3,3623,'App\\Models\\Receipt',3623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',9521.37,NULL,NULL,1,'2023-04-12 21:46:06','2023-04-12 21:46:06',NULL),(4359,7768,41297,87324,3,3624,'App\\Models\\Receipt',3624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-04','2022-06-04',3010.00,NULL,NULL,1,'2023-04-12 21:46:06','2023-04-12 21:46:06',NULL),(4360,7768,41297,87324,3,3625,'App\\Models\\Receipt',3625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',29452.42,NULL,NULL,1,'2023-04-12 21:46:06','2023-04-12 21:46:06',NULL),(4361,7768,41297,87324,3,3626,'App\\Models\\Receipt',3626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',15176.13,NULL,NULL,1,'2023-04-12 21:46:06','2023-04-12 21:46:06',NULL),(4362,7768,41297,87324,3,3627,'App\\Models\\Receipt',3627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-09','2022-06-09',18103.07,NULL,NULL,1,'2023-04-12 21:46:06','2023-04-12 21:46:06',NULL),(4363,7768,41297,87324,3,3628,'App\\Models\\Receipt',3628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06','2022-06-06',12562.25,NULL,NULL,1,'2023-04-12 21:46:06','2023-04-12 21:46:06',NULL),(4364,7768,41297,87324,3,3629,'App\\Models\\Receipt',3629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-13','2022-06-13',10269.88,NULL,NULL,1,'2023-04-12 21:46:06','2023-04-12 21:46:06',NULL),(4365,7768,41297,87324,3,3630,'App\\Models\\Receipt',3630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-16','2022-06-16',15345.86,NULL,NULL,1,'2023-04-12 21:46:06','2023-04-12 21:46:06',NULL),(4366,7768,41297,87324,3,3631,'App\\Models\\Receipt',3631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-23','2022-06-23',17813.56,NULL,NULL,1,'2023-04-12 21:46:06','2023-04-12 21:46:06',NULL),(4367,7768,41297,87324,3,3632,'App\\Models\\Receipt',3632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',12379.96,NULL,NULL,1,'2023-04-12 21:46:06','2023-04-12 21:46:06',NULL),(4368,7768,41297,87324,3,3633,'App\\Models\\Receipt',3633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',19284.32,NULL,NULL,1,'2023-04-12 21:46:06','2023-04-12 21:46:06',NULL),(4369,7768,41297,87324,3,3634,'App\\Models\\Receipt',3634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',37134.55,NULL,NULL,1,'2023-04-12 21:46:06','2023-04-12 21:46:06',NULL),(4370,7768,41297,87324,3,3635,'App\\Models\\Receipt',3635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',74858.98,NULL,NULL,1,'2023-04-12 21:46:06','2023-04-12 21:46:06',NULL);
INSERT INTO `balance_libro` VALUES (4371,7768,41297,87324,3,3636,'App\\Models\\Receipt',3636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',10663.59,NULL,NULL,1,'2023-04-12 21:46:06','2023-04-12 21:46:06',NULL),(4372,7768,41297,87324,3,3637,'App\\Models\\Receipt',3637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',92466.12,NULL,NULL,1,'2023-04-12 21:46:06','2023-04-12 21:46:06',NULL),(4373,7768,41297,87324,3,3638,'App\\Models\\Receipt',3638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',44685.34,NULL,NULL,1,'2023-04-12 21:46:06','2023-04-12 21:46:06',NULL),(4374,7768,41297,87324,3,3639,'App\\Models\\Receipt',3639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',173895.52,NULL,NULL,1,'2023-04-12 21:46:06','2023-04-12 21:46:06',NULL),(4375,7768,41297,87324,3,3640,'App\\Models\\Receipt',3640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',2554.74,NULL,NULL,1,'2023-04-12 21:46:06','2023-04-12 21:46:06',NULL),(4376,7768,41297,87324,3,3641,'App\\Models\\Receipt',3641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-28','2022-06-28',51339.00,NULL,NULL,1,'2023-04-12 21:46:06','2023-04-12 21:46:06',NULL),(4377,7768,41297,87324,3,3642,'App\\Models\\Receipt',3642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',8678.52,NULL,NULL,1,'2023-04-12 21:46:06','2023-04-12 21:46:06',NULL),(4378,7768,41297,87324,3,3643,'App\\Models\\Receipt',3643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-21','2022-06-21',1032.59,NULL,NULL,1,'2023-04-12 21:46:06','2023-04-12 21:46:06',NULL),(4379,7768,41297,87324,3,3644,'App\\Models\\Receipt',3644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22','2022-06-22',2176.54,NULL,NULL,1,'2023-04-12 21:46:06','2023-04-12 21:46:06',NULL),(4380,7768,41297,87324,3,3645,'App\\Models\\Receipt',3645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',4108.00,NULL,NULL,1,'2023-04-12 21:46:06','2023-04-12 21:46:06',NULL),(4381,7768,41297,87324,3,3646,'App\\Models\\Receipt',3646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',282798.23,NULL,NULL,1,'2023-04-12 21:46:07','2023-04-12 21:46:07',NULL),(4382,7768,41297,87324,3,3647,'App\\Models\\Receipt',3647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',21473.73,NULL,NULL,1,'2023-04-12 21:46:07','2023-04-12 21:46:07',NULL),(4383,7768,41297,87324,3,3648,'App\\Models\\Receipt',3648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',200905.11,NULL,NULL,1,'2023-04-12 21:46:07','2023-04-12 21:46:07',NULL),(4384,7768,41297,87324,3,3649,'App\\Models\\Receipt',3649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',10239.90,NULL,NULL,1,'2023-04-12 21:46:07','2023-04-12 21:46:07',NULL),(4385,7768,41297,87324,3,3650,'App\\Models\\Receipt',3650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',245121.78,NULL,NULL,1,'2023-04-12 21:46:07','2023-04-12 21:46:07',NULL),(4386,7768,41297,87324,3,3651,'App\\Models\\Receipt',3651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',167467.55,NULL,NULL,1,'2023-04-12 21:46:07','2023-04-12 21:46:07',NULL),(4387,7768,41297,87324,3,3652,'App\\Models\\Receipt',3652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',15112.19,NULL,NULL,1,'2023-04-12 21:46:07','2023-04-12 21:46:07',NULL),(4388,7768,41297,87324,3,3653,'App\\Models\\Receipt',3653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',13088.05,NULL,NULL,1,'2023-04-12 21:46:07','2023-04-12 21:46:07',NULL),(4389,7768,41297,87324,3,3654,'App\\Models\\Receipt',3654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-19','2022-02-19',18184.51,NULL,NULL,1,'2023-04-12 21:46:07','2023-04-12 21:46:07',NULL),(4390,7768,41297,87324,3,3655,'App\\Models\\Receipt',3655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',14175.01,NULL,NULL,1,'2023-04-12 21:46:07','2023-04-12 21:46:07',NULL),(4391,7768,41297,87324,3,3656,'App\\Models\\Receipt',3656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',14219.97,NULL,NULL,1,'2023-04-12 21:46:07','2023-04-12 21:46:07',NULL);
INSERT INTO `balance_libro` VALUES (4392,7768,41297,87324,3,3657,'App\\Models\\Receipt',3657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',23160.81,NULL,NULL,1,'2023-04-12 21:46:07','2023-04-12 21:46:07',NULL),(4393,7768,41297,87324,3,3658,'App\\Models\\Receipt',3658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',16460.11,NULL,NULL,1,'2023-04-12 21:46:07','2023-04-12 21:46:07',NULL),(4394,7768,41297,87324,3,3659,'App\\Models\\Receipt',3659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',20243.63,NULL,NULL,1,'2023-04-12 21:46:07','2023-04-12 21:46:07',NULL),(4395,7768,41297,87324,3,3660,'App\\Models\\Receipt',3660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',16056.51,NULL,NULL,1,'2023-04-12 21:46:07','2023-04-12 21:46:07',NULL),(4396,7768,41297,87324,3,3661,'App\\Models\\Receipt',3661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',15783.40,NULL,NULL,1,'2023-04-12 21:46:07','2023-04-12 21:46:07',NULL),(4397,7768,41297,87324,3,3662,'App\\Models\\Receipt',3662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',12894.72,NULL,NULL,1,'2023-04-12 21:46:07','2023-04-12 21:46:07',NULL),(4398,7768,41297,87324,3,3663,'App\\Models\\Receipt',3663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',18959.97,NULL,NULL,1,'2023-04-12 21:46:07','2023-04-12 21:46:07',NULL),(4399,7768,41297,87324,3,3664,'App\\Models\\Receipt',3664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-16','2022-04-16',16354.17,NULL,NULL,1,'2023-04-12 21:46:07','2023-04-12 21:46:07',NULL),(4400,7768,41297,87324,3,3665,'App\\Models\\Receipt',3665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',17553.67,NULL,NULL,1,'2023-04-12 21:46:07','2023-04-12 21:46:07',NULL),(4460,7768,41297,87325,3,3725,'App\\Models\\Receipt',3725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',18738.35,NULL,NULL,1,'2023-04-12 21:50:03','2023-04-12 21:50:03',NULL),(4461,7768,41297,87325,3,3726,'App\\Models\\Receipt',3726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',101792.30,NULL,NULL,1,'2023-04-12 21:50:03','2023-04-12 21:50:03',NULL),(4462,7768,41297,87325,3,3727,'App\\Models\\Receipt',3727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',4103492.27,NULL,NULL,1,'2023-04-12 21:50:03','2023-04-12 21:50:03',NULL),(4463,7768,41297,87325,3,3728,'App\\Models\\Receipt',3728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',6138410.98,NULL,NULL,1,'2023-04-12 21:50:03','2023-04-12 21:50:03',NULL),(4464,7768,41297,87325,3,3729,'App\\Models\\Receipt',3729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',17398.47,NULL,NULL,1,'2023-04-12 21:50:03','2023-04-12 21:50:03',NULL),(4465,7768,41297,87325,3,3730,'App\\Models\\Receipt',3730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',3550.30,NULL,NULL,1,'2023-04-12 21:50:03','2023-04-12 21:50:03',NULL),(4466,7768,41297,87325,3,3731,'App\\Models\\Receipt',3731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',10418.62,NULL,NULL,1,'2023-04-12 21:50:03','2023-04-12 21:50:03',NULL),(4467,7768,41297,87325,3,3732,'App\\Models\\Receipt',3732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-03','2022-08-03',21144.07,NULL,NULL,1,'2023-04-12 21:50:03','2023-04-12 21:50:03',NULL),(4468,7768,41297,87325,3,3733,'App\\Models\\Receipt',3733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',14148.05,NULL,NULL,1,'2023-04-12 21:50:03','2023-04-12 21:50:03',NULL),(4469,7768,41297,87325,3,3734,'App\\Models\\Receipt',3734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',20872.96,NULL,NULL,1,'2023-04-12 21:50:03','2023-04-12 21:50:03',NULL),(4470,7768,41297,87325,3,3735,'App\\Models\\Receipt',3735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',26398.45,NULL,NULL,1,'2023-04-12 21:50:03','2023-04-12 21:50:03',NULL);
INSERT INTO `balance_libro` VALUES (4471,7768,41297,87325,3,3736,'App\\Models\\Receipt',3736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',14440.48,NULL,NULL,1,'2023-04-12 21:50:03','2023-04-12 21:50:03',NULL),(4472,7768,41297,87325,3,3737,'App\\Models\\Receipt',3737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',14061.84,NULL,NULL,1,'2023-04-12 21:50:03','2023-04-12 21:50:03',NULL),(4473,7768,41297,87325,3,3738,'App\\Models\\Receipt',3738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',32351.94,NULL,NULL,1,'2023-04-12 21:50:03','2023-04-12 21:50:03',NULL),(4474,7768,41297,87325,3,3739,'App\\Models\\Receipt',3739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',14801.24,NULL,NULL,1,'2023-04-12 21:50:03','2023-04-12 21:50:03',NULL),(4475,7768,41297,87325,3,3740,'App\\Models\\Receipt',3740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-20','2022-08-20',12200.86,NULL,NULL,1,'2023-04-12 21:50:03','2023-04-12 21:50:03',NULL),(4476,7768,41297,87325,3,3741,'App\\Models\\Receipt',3741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',12912.64,NULL,NULL,1,'2023-04-12 21:50:03','2023-04-12 21:50:03',NULL),(4477,7768,41297,87325,3,3742,'App\\Models\\Receipt',3742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',22937.40,NULL,NULL,1,'2023-04-12 21:50:03','2023-04-12 21:50:03',NULL),(4478,7768,41297,87325,3,3743,'App\\Models\\Receipt',3743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',13601.05,NULL,NULL,1,'2023-04-12 21:50:04','2023-04-12 21:50:04',NULL),(4479,7768,41297,87325,3,3744,'App\\Models\\Receipt',3744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-23','2022-08-23',31963.71,NULL,NULL,1,'2023-04-12 21:50:04','2023-04-12 21:50:04',NULL),(4480,7768,41297,87325,3,3745,'App\\Models\\Receipt',3745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-09','2022-08-09',9718.55,NULL,NULL,1,'2023-04-12 21:50:04','2023-04-12 21:50:04',NULL),(4481,7768,41297,87325,3,3746,'App\\Models\\Receipt',3746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-02','2022-08-02',191650.00,NULL,NULL,1,'2023-04-12 21:50:04','2023-04-12 21:50:04',NULL),(4482,7768,41297,87325,3,3747,'App\\Models\\Receipt',3747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-01','2022-08-01',13650.03,NULL,NULL,1,'2023-04-12 21:50:04','2023-04-12 21:50:04',NULL),(4483,7768,41297,87325,3,3748,'App\\Models\\Receipt',3748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',10696.07,NULL,NULL,1,'2023-04-12 21:50:04','2023-04-12 21:50:04',NULL),(4484,7768,41297,87325,3,3749,'App\\Models\\Receipt',3749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',14629.05,NULL,NULL,1,'2023-04-12 21:50:04','2023-04-12 21:50:04',NULL),(4485,7768,41297,87325,3,3750,'App\\Models\\Receipt',3750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',140183.50,NULL,NULL,1,'2023-04-12 21:50:04','2023-04-12 21:50:04',NULL),(4486,7768,41297,87325,3,3751,'App\\Models\\Receipt',3751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',12413.30,NULL,NULL,1,'2023-04-12 21:50:04','2023-04-12 21:50:04',NULL),(4487,7768,41297,87325,3,3752,'App\\Models\\Receipt',3752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',7710.11,NULL,NULL,1,'2023-04-12 21:50:04','2023-04-12 21:50:04',NULL),(4488,7768,41297,87325,3,3753,'App\\Models\\Receipt',3753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',11545.11,NULL,NULL,1,'2023-04-12 21:50:04','2023-04-12 21:50:04',NULL),(4489,7768,41297,87325,3,3754,'App\\Models\\Receipt',3754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',56070.00,NULL,NULL,1,'2023-04-12 21:50:04','2023-04-12 21:50:04',NULL),(4490,7768,41297,87325,3,3755,'App\\Models\\Receipt',3755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',20985.06,NULL,NULL,1,'2023-04-12 21:50:04','2023-04-12 21:50:04',NULL),(4491,7768,41297,87325,3,3756,'App\\Models\\Receipt',3756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-05','2022-08-05',15492.60,NULL,NULL,1,'2023-04-12 21:50:04','2023-04-12 21:50:04',NULL);
INSERT INTO `balance_libro` VALUES (4492,7768,41297,87325,3,3757,'App\\Models\\Receipt',3757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-16','2022-08-16',19242.36,NULL,NULL,1,'2023-04-12 21:50:04','2023-04-12 21:50:04',NULL),(4493,7768,41297,87325,3,3758,'App\\Models\\Receipt',3758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-26','2022-08-26',19850.68,NULL,NULL,1,'2023-04-12 21:50:04','2023-04-12 21:50:04',NULL),(4494,7768,41297,87325,3,3759,'App\\Models\\Receipt',3759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-18','2022-08-18',17684.97,NULL,NULL,1,'2023-04-12 21:50:04','2023-04-12 21:50:04',NULL),(4495,7768,41297,87325,3,3760,'App\\Models\\Receipt',3760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',12319.91,NULL,NULL,1,'2023-04-12 21:50:04','2023-04-12 21:50:04',NULL),(4496,7768,41297,87325,3,3761,'App\\Models\\Receipt',3761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-11','2022-08-11',23905.37,NULL,NULL,1,'2023-04-12 21:50:04','2023-04-12 21:50:04',NULL),(4497,7768,41297,87325,3,3762,'App\\Models\\Receipt',3762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',15453.38,NULL,NULL,1,'2023-04-12 21:50:04','2023-04-12 21:50:04',NULL),(4498,7768,41297,87325,3,3763,'App\\Models\\Receipt',3763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',79516.39,NULL,NULL,1,'2023-04-12 21:50:04','2023-04-12 21:50:04',NULL),(4499,7768,41297,87325,3,3764,'App\\Models\\Receipt',3764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',48012.80,NULL,NULL,1,'2023-04-12 21:50:04','2023-04-12 21:50:04',NULL),(4500,7768,41297,87325,3,3765,'App\\Models\\Receipt',3765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',267693.85,NULL,NULL,1,'2023-04-12 21:50:04','2023-04-12 21:50:04',NULL),(4501,7768,41297,87325,3,3766,'App\\Models\\Receipt',3766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',7525.01,NULL,NULL,1,'2023-04-12 21:50:05','2023-04-12 21:50:05',NULL),(4502,7768,41297,87325,3,3767,'App\\Models\\Receipt',3767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-08','2022-08-08',191650.00,NULL,NULL,1,'2023-04-12 21:50:05','2023-04-12 21:50:05',NULL),(4551,7768,41297,87326,3,3816,'App\\Models\\Receipt',3816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',6999.13,NULL,NULL,1,'2023-04-12 21:52:09','2023-04-12 21:52:09',NULL),(4552,7768,41297,87326,3,3817,'App\\Models\\Receipt',3817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',47047.70,NULL,NULL,1,'2023-04-12 21:52:10','2023-04-12 21:52:10',NULL),(4553,7768,41297,87326,3,3818,'App\\Models\\Receipt',3818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',47725.33,NULL,NULL,1,'2023-04-12 21:52:10','2023-04-12 21:52:10',NULL),(4554,7768,41297,87326,3,3819,'App\\Models\\Receipt',3819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',48199.29,NULL,NULL,1,'2023-04-12 21:52:10','2023-04-12 21:52:10',NULL),(4555,7768,41297,87326,3,3820,'App\\Models\\Receipt',3820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-13','2022-09-13',109886.53,NULL,NULL,1,'2023-04-12 21:52:10','2023-04-12 21:52:10',NULL),(4556,7768,41297,87326,3,3821,'App\\Models\\Receipt',3821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',163829.92,NULL,NULL,1,'2023-04-12 21:52:10','2023-04-12 21:52:10',NULL),(4557,7768,41297,87326,3,3822,'App\\Models\\Receipt',3822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',92449.94,NULL,NULL,1,'2023-04-12 21:52:10','2023-04-12 21:52:10',NULL),(4558,7768,41297,87326,3,3823,'App\\Models\\Receipt',3823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',68451.08,NULL,NULL,1,'2023-04-12 21:52:10','2023-04-12 21:52:10',NULL),(4559,7768,41297,87326,3,3824,'App\\Models\\Receipt',3824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',82709.78,NULL,NULL,1,'2023-04-12 21:52:10','2023-04-12 21:52:10',NULL),(4560,7768,41297,87326,3,3825,'App\\Models\\Receipt',3825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-17','2022-08-17',100305.02,NULL,NULL,1,'2023-04-12 21:52:10','2023-04-12 21:52:10',NULL);
INSERT INTO `balance_libro` VALUES (4561,7768,41297,87326,3,3826,'App\\Models\\Receipt',3826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-19','2022-08-19',81000.04,NULL,NULL,1,'2023-04-12 21:52:10','2023-04-12 21:52:10',NULL),(4562,7768,41297,87326,3,3827,'App\\Models\\Receipt',3827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-25','2022-08-25',136482.07,NULL,NULL,1,'2023-04-12 21:52:10','2023-04-12 21:52:10',NULL),(4563,7768,41297,87326,3,3828,'App\\Models\\Receipt',3828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',12300.90,NULL,NULL,1,'2023-04-12 21:52:10','2023-04-12 21:52:10',NULL),(4564,7768,41297,87326,3,3829,'App\\Models\\Receipt',3829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-04','2022-09-04',9837.76,NULL,NULL,1,'2023-04-12 21:52:10','2023-04-12 21:52:10',NULL),(4565,7768,41297,87326,3,3830,'App\\Models\\Receipt',3830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',8782.58,NULL,NULL,1,'2023-04-12 21:52:10','2023-04-12 21:52:10',NULL),(4566,7768,41297,87326,3,3831,'App\\Models\\Receipt',3831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',12780.63,NULL,NULL,1,'2023-04-12 21:52:10','2023-04-12 21:52:10',NULL),(4567,7768,41297,87326,3,3832,'App\\Models\\Receipt',3832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',14422.00,NULL,NULL,1,'2023-04-12 21:52:10','2023-04-12 21:52:10',NULL),(4568,7768,41297,87326,3,3833,'App\\Models\\Receipt',3833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',13007.39,NULL,NULL,1,'2023-04-12 21:52:10','2023-04-12 21:52:10',NULL),(4569,7768,41297,87326,3,3834,'App\\Models\\Receipt',3834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-19','2022-09-19',12901.42,NULL,NULL,1,'2023-04-12 21:52:10','2023-04-12 21:52:10',NULL),(4570,7768,41297,87326,3,3835,'App\\Models\\Receipt',3835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-09','2022-09-09',13121.80,NULL,NULL,1,'2023-04-12 21:52:10','2023-04-12 21:52:10',NULL),(4571,7768,41297,87326,3,3836,'App\\Models\\Receipt',3836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',12968.65,NULL,NULL,1,'2023-04-12 21:52:10','2023-04-12 21:52:10',NULL),(4572,7768,41297,87326,3,3837,'App\\Models\\Receipt',3837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',309824.15,NULL,NULL,1,'2023-04-12 21:52:11','2023-04-12 21:52:11',NULL),(4573,7768,41297,87326,3,3838,'App\\Models\\Receipt',3838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',194518.54,NULL,NULL,1,'2023-04-12 21:52:11','2023-04-12 21:52:11',NULL),(4574,7768,41297,87326,3,3839,'App\\Models\\Receipt',3839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',53866.68,NULL,NULL,1,'2023-04-12 21:52:11','2023-04-12 21:52:11',NULL),(4575,7768,41297,87326,3,3840,'App\\Models\\Receipt',3840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-22','2022-09-22',88935.61,NULL,NULL,1,'2023-04-12 21:52:11','2023-04-12 21:52:11',NULL),(4576,7768,41297,87326,3,3841,'App\\Models\\Receipt',3841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-24','2022-08-24',1520963.09,NULL,NULL,1,'2023-04-12 21:52:11','2023-04-12 21:52:11',NULL),(4577,7768,41297,87326,3,3842,'App\\Models\\Receipt',3842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',2978189.76,NULL,NULL,1,'2023-04-12 21:52:11','2023-04-12 21:52:11',NULL),(4578,7768,41297,87326,3,3843,'App\\Models\\Receipt',3843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',38304.79,NULL,NULL,1,'2023-04-12 21:52:11','2023-04-12 21:52:11',NULL),(4579,7768,41297,87326,3,3844,'App\\Models\\Receipt',3844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-30','2022-08-30',362130.87,NULL,NULL,1,'2023-04-12 21:52:11','2023-04-12 21:52:11',NULL),(4580,7768,41297,87326,3,3845,'App\\Models\\Receipt',3845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-22','2022-08-22',145922.47,NULL,NULL,1,'2023-04-12 21:52:11','2023-04-12 21:52:11',NULL);
INSERT INTO `balance_libro` VALUES (4581,7768,41297,87326,3,3846,'App\\Models\\Receipt',3846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',76158.04,NULL,NULL,1,'2023-04-12 21:52:11','2023-04-12 21:52:11',NULL),(4582,7768,41297,87326,3,3847,'App\\Models\\Receipt',3847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-10','2022-08-10',59173.93,NULL,NULL,1,'2023-04-12 21:52:11','2023-04-12 21:52:11',NULL),(4583,7768,41297,87326,3,3848,'App\\Models\\Receipt',3848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-29','2022-08-29',18110.40,NULL,NULL,1,'2023-04-12 21:52:11','2023-04-12 21:52:11',NULL),(4584,7768,41297,87326,3,3849,'App\\Models\\Receipt',3849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-06','2022-09-06',39682.04,NULL,NULL,1,'2023-04-12 21:52:11','2023-04-12 21:52:11',NULL),(4585,7768,41297,87326,3,3850,'App\\Models\\Receipt',3850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',162887.71,NULL,NULL,1,'2023-04-12 21:52:11','2023-04-12 21:52:11',NULL),(4586,7768,41297,87326,3,3851,'App\\Models\\Receipt',3851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',5864.79,NULL,NULL,1,'2023-04-12 21:52:11','2023-04-12 21:52:11',NULL),(4629,7768,41297,87327,3,3894,'App\\Models\\Receipt',3894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',180151.17,NULL,NULL,1,'2023-04-12 21:53:53','2023-04-12 21:53:53',NULL),(4630,7768,41297,87327,3,3895,'App\\Models\\Receipt',3895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',17957.89,NULL,NULL,1,'2023-04-12 21:53:53','2023-04-12 21:53:53',NULL),(4631,7768,41297,87327,3,3896,'App\\Models\\Receipt',3896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',15902.02,NULL,NULL,1,'2023-04-12 21:53:53','2023-04-12 21:53:53',NULL),(4632,7768,41297,87327,3,3897,'App\\Models\\Receipt',3897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',14157.54,NULL,NULL,1,'2023-04-12 21:53:53','2023-04-12 21:53:53',NULL),(4633,7768,41297,87327,3,3898,'App\\Models\\Receipt',3898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',16192.17,NULL,NULL,1,'2023-04-12 21:53:53','2023-04-12 21:53:53',NULL),(4634,7768,41297,87327,3,3899,'App\\Models\\Receipt',3899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',144422.00,NULL,NULL,1,'2023-04-12 21:53:53','2023-04-12 21:53:53',NULL),(4635,7768,41297,87327,3,3900,'App\\Models\\Receipt',3900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',10000.32,NULL,NULL,1,'2023-04-12 21:53:53','2023-04-12 21:53:53',NULL),(4636,7768,41297,87327,3,3901,'App\\Models\\Receipt',3901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-08','2022-09-08',17291.86,NULL,NULL,1,'2023-04-12 21:53:53','2023-04-12 21:53:53',NULL),(4637,7768,41297,87327,3,3902,'App\\Models\\Receipt',3902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-12','2022-09-12',15283.92,NULL,NULL,1,'2023-04-12 21:53:53','2023-04-12 21:53:53',NULL),(4638,7768,41297,87327,3,3903,'App\\Models\\Receipt',3903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-05','2022-09-05',23717.48,NULL,NULL,1,'2023-04-12 21:53:53','2023-04-12 21:53:53',NULL),(4639,7768,41297,87327,3,3904,'App\\Models\\Receipt',3904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-15','2022-09-15',25350.02,NULL,NULL,1,'2023-04-12 21:53:53','2023-04-12 21:53:53',NULL),(4640,7768,41297,87327,3,3905,'App\\Models\\Receipt',3905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-20','2022-09-20',33263.45,NULL,NULL,1,'2023-04-12 21:53:53','2023-04-12 21:53:53',NULL),(4641,7768,41297,87327,3,3906,'App\\Models\\Receipt',3906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-23','2022-09-23',23010.81,NULL,NULL,1,'2023-04-12 21:53:53','2023-04-12 21:53:53',NULL),(4642,7768,41297,87327,3,3907,'App\\Models\\Receipt',3907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-27','2022-09-27',14551.83,NULL,NULL,1,'2023-04-12 21:53:53','2023-04-12 21:53:53',NULL),(4643,7768,41297,87327,3,3908,'App\\Models\\Receipt',3908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',23082.69,NULL,NULL,1,'2023-04-12 21:53:53','2023-04-12 21:53:53',NULL);
INSERT INTO `balance_libro` VALUES (4644,7768,41297,87327,3,3909,'App\\Models\\Receipt',3909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',44848.65,NULL,NULL,1,'2023-04-12 21:53:53','2023-04-12 21:53:53',NULL),(4645,7768,41297,87327,3,3910,'App\\Models\\Receipt',3910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',66648.14,NULL,NULL,1,'2023-04-12 21:53:53','2023-04-12 21:53:53',NULL),(4646,7768,41297,87327,3,3911,'App\\Models\\Receipt',3911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',55430.89,NULL,NULL,1,'2023-04-12 21:53:53','2023-04-12 21:53:53',NULL),(4647,7768,41297,87327,3,3912,'App\\Models\\Receipt',3912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',15240.62,NULL,NULL,1,'2023-04-12 21:53:53','2023-04-12 21:53:53',NULL),(4648,7768,41297,87327,3,3913,'App\\Models\\Receipt',3913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',3.96,NULL,NULL,1,'2023-04-12 21:53:53','2023-04-12 21:53:53',NULL),(4649,7768,41297,87327,3,3914,'App\\Models\\Receipt',3914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',177176.81,NULL,NULL,1,'2023-04-12 21:53:53','2023-04-12 21:53:53',NULL),(4650,7768,41297,87327,3,3915,'App\\Models\\Receipt',3915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',40044.25,NULL,NULL,1,'2023-04-12 21:53:53','2023-04-12 21:53:53',NULL),(4651,7768,41297,87327,3,3916,'App\\Models\\Receipt',3916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',22688.38,NULL,NULL,1,'2023-04-12 21:53:54','2023-04-12 21:53:54',NULL),(4705,7768,41297,87322,3,3970,'App\\Models\\Receipt',3970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',102943.18,NULL,NULL,1,'2023-04-12 21:56:40','2023-04-12 21:56:40',NULL),(4706,7768,41297,87322,3,3971,'App\\Models\\Receipt',3971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',25492.81,NULL,NULL,1,'2023-04-12 21:56:40','2023-04-12 21:56:40',NULL),(4707,7768,41297,87322,3,3972,'App\\Models\\Receipt',3972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',64822.90,NULL,NULL,1,'2023-04-12 21:56:41','2023-04-12 21:56:41',NULL),(4708,7768,41297,87322,3,3973,'App\\Models\\Receipt',3973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',341493.71,NULL,NULL,1,'2023-04-12 21:56:41','2023-04-12 21:56:41',NULL),(4709,7768,41297,87322,3,3974,'App\\Models\\Receipt',3974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',78683.56,NULL,NULL,1,'2023-04-12 21:56:41','2023-04-12 21:56:41',NULL),(4710,7768,41297,87322,3,3975,'App\\Models\\Receipt',3975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',16701.74,NULL,NULL,1,'2023-04-12 21:56:41','2023-04-12 21:56:41',NULL),(4711,7768,41297,87322,3,3976,'App\\Models\\Receipt',3976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',11790.03,NULL,NULL,1,'2023-04-12 21:56:41','2023-04-12 21:56:41',NULL),(4712,7768,41297,87322,3,3977,'App\\Models\\Receipt',3977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',26075.03,NULL,NULL,1,'2023-04-12 21:56:41','2023-04-12 21:56:41',NULL),(4713,7768,41297,87322,3,3978,'App\\Models\\Receipt',3978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-13','2022-05-13',17094.80,NULL,NULL,1,'2023-04-12 21:56:41','2023-04-12 21:56:41',NULL),(4714,7768,41297,87322,3,3979,'App\\Models\\Receipt',3979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',15645.03,NULL,NULL,1,'2023-04-12 21:56:41','2023-04-12 21:56:41',NULL),(4715,7768,41297,87322,3,3980,'App\\Models\\Receipt',3980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',20508.33,NULL,NULL,1,'2023-04-12 21:56:41','2023-04-12 21:56:41',NULL),(4716,7768,41297,87322,3,3981,'App\\Models\\Receipt',3981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-27','2022-05-27',12715.55,NULL,NULL,1,'2023-04-12 21:56:41','2023-04-12 21:56:41',NULL),(4717,7768,41297,87322,3,3982,'App\\Models\\Receipt',3982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',17242.75,NULL,NULL,1,'2023-04-12 21:56:41','2023-04-12 21:56:41',NULL);
INSERT INTO `balance_libro` VALUES (4718,7768,41297,87322,3,3983,'App\\Models\\Receipt',3983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',1489.99,NULL,NULL,1,'2023-04-12 21:56:41','2023-04-12 21:56:41',NULL),(4719,7768,41297,87322,3,3984,'App\\Models\\Receipt',3984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',680.01,NULL,NULL,1,'2023-04-12 21:56:41','2023-04-12 21:56:41',NULL),(4720,7768,41297,87322,3,3985,'App\\Models\\Receipt',3985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',8296.94,NULL,NULL,1,'2023-04-12 21:56:41','2023-04-12 21:56:41',NULL),(4721,7768,41297,87322,3,3986,'App\\Models\\Receipt',3986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-03','2022-05-03',9999.89,NULL,NULL,1,'2023-04-12 21:56:41','2023-04-12 21:56:41',NULL),(4722,7768,41297,87322,3,3987,'App\\Models\\Receipt',3987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',7400.08,NULL,NULL,1,'2023-04-12 21:56:41','2023-04-12 21:56:41',NULL),(4723,7768,41297,87322,3,3988,'App\\Models\\Receipt',3988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-02','2022-05-02',1125.00,NULL,NULL,1,'2023-04-12 21:56:41','2023-04-12 21:56:41',NULL),(4724,7768,41297,87322,3,3989,'App\\Models\\Receipt',3989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-04','2022-05-04',10101.09,NULL,NULL,1,'2023-04-12 21:56:41','2023-04-12 21:56:41',NULL),(4725,7768,41297,87322,3,3990,'App\\Models\\Receipt',3990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-08','2022-05-08',8500.28,NULL,NULL,1,'2023-04-12 21:56:41','2023-04-12 21:56:41',NULL),(4726,7768,41297,87322,3,3991,'App\\Models\\Receipt',3991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',700.00,NULL,NULL,1,'2023-04-12 21:56:41','2023-04-12 21:56:41',NULL),(4727,7768,41297,87322,3,3992,'App\\Models\\Receipt',3992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-07','2022-05-07',600.00,NULL,NULL,1,'2023-04-12 21:56:41','2023-04-12 21:56:41',NULL),(4728,7768,41297,87322,3,3993,'App\\Models\\Receipt',3993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',10101.25,NULL,NULL,1,'2023-04-12 21:56:41','2023-04-12 21:56:41',NULL),(4729,7768,41297,87322,3,3994,'App\\Models\\Receipt',3994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',9000.35,NULL,NULL,1,'2023-04-12 21:56:41','2023-04-12 21:56:41',NULL),(4730,7768,41297,87322,3,3995,'App\\Models\\Receipt',3995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',2030.01,NULL,NULL,1,'2023-04-12 21:56:41','2023-04-12 21:56:41',NULL),(4731,7768,41297,87322,3,3996,'App\\Models\\Receipt',3996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',3100.01,NULL,NULL,1,'2023-04-12 21:56:41','2023-04-12 21:56:41',NULL),(4732,7768,41297,87322,3,3997,'App\\Models\\Receipt',3997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',280.01,NULL,NULL,1,'2023-04-12 21:56:41','2023-04-12 21:56:41',NULL),(4733,7768,41297,87322,3,3998,'App\\Models\\Receipt',3998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',11338.97,NULL,NULL,1,'2023-04-12 21:56:42','2023-04-12 21:56:42',NULL),(4734,7768,41297,87322,3,3999,'App\\Models\\Receipt',3999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-14','2022-05-14',10725.87,NULL,NULL,1,'2023-04-12 21:56:42','2023-04-12 21:56:42',NULL),(4735,7768,41297,87322,3,4000,'App\\Models\\Receipt',4000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-14','2022-05-14',11430.99,NULL,NULL,1,'2023-04-12 21:56:42','2023-04-12 21:56:42',NULL),(4736,7768,41297,87322,3,4001,'App\\Models\\Receipt',4001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',11184.32,NULL,NULL,1,'2023-04-12 21:56:42','2023-04-12 21:56:42',NULL),(4737,7768,41297,87322,3,4002,'App\\Models\\Receipt',4002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',1729.99,NULL,NULL,1,'2023-04-12 21:56:42','2023-04-12 21:56:42',NULL),(4738,7768,41297,87322,3,4003,'App\\Models\\Receipt',4003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',3600.00,NULL,NULL,1,'2023-04-12 21:56:42','2023-04-12 21:56:42',NULL);
INSERT INTO `balance_libro` VALUES (4739,7768,41297,87322,3,4004,'App\\Models\\Receipt',4004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',9885.11,NULL,NULL,1,'2023-04-12 21:56:42','2023-04-12 21:56:42',NULL),(4740,7768,41297,87322,3,4005,'App\\Models\\Receipt',4005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',300.00,NULL,NULL,1,'2023-04-12 21:56:42','2023-04-12 21:56:42',NULL),(4741,7768,41297,87322,3,4006,'App\\Models\\Receipt',4006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',13103.16,NULL,NULL,1,'2023-04-12 21:56:42','2023-04-12 21:56:42',NULL),(4742,7768,41297,87322,3,4007,'App\\Models\\Receipt',4007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',11600.61,NULL,NULL,1,'2023-04-12 21:56:42','2023-04-12 21:56:42',NULL),(4743,7768,41297,87322,3,4008,'App\\Models\\Receipt',4008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',3580.00,NULL,NULL,1,'2023-04-12 21:56:42','2023-04-12 21:56:42',NULL),(4744,7768,41297,87322,3,4009,'App\\Models\\Receipt',4009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',450.00,NULL,NULL,1,'2023-04-12 21:56:42','2023-04-12 21:56:42',NULL),(4745,7768,41297,87322,3,4010,'App\\Models\\Receipt',4010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',12000.83,NULL,NULL,1,'2023-04-12 21:56:42','2023-04-12 21:56:42',NULL),(4746,7768,41297,87322,3,4011,'App\\Models\\Receipt',4011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-24','2022-05-24',72675.95,NULL,NULL,1,'2023-04-12 21:56:42','2023-04-12 21:56:42',NULL),(4747,7768,41297,87314,15,1366,'App\\Models\\PeriodLiquidation',NULL,1366,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',4617463.79,NULL,NULL,1,'2023-04-12 22:06:37','2023-04-12 22:06:37',NULL),(4748,7768,41297,87318,9,4012,'App\\Models\\Receipt',4012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',726532.10,NULL,NULL,1,'2023-04-12 22:08:57','2023-04-12 22:08:57',NULL),(4749,7768,41297,87318,7,4013,'App\\Models\\Receipt',4013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',316626.51,NULL,NULL,1,'2023-04-12 22:12:02','2023-04-12 22:12:02',NULL),(4750,7768,41297,87318,15,1504,'App\\Models\\PeriodLiquidation',NULL,1504,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',7939579.34,NULL,NULL,1,'2023-04-12 22:15:48','2023-04-12 22:15:48',NULL),(4751,7768,41297,87319,16,1484,'App\\Models\\PeriodLiquidation',NULL,1484,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',0.00,NULL,NULL,1,'2023-04-12 22:16:12','2023-04-12 22:20:42','2023-04-12 22:20:42'),(4752,7768,41297,87318,16,1505,'App\\Models\\PeriodLiquidation',NULL,1505,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',0.00,NULL,NULL,1,'2023-04-12 22:16:18','2023-04-12 22:16:18',NULL),(4753,7768,41297,87319,3,4014,'App\\Models\\Receipt',4014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',51757.41,NULL,NULL,1,'2023-04-12 22:21:33','2023-04-12 22:29:43','2023-04-12 22:29:43'),(4809,7768,41297,87319,3,4070,'App\\Models\\Receipt',4070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',700.00,NULL,NULL,1,'2023-04-12 22:31:58','2023-04-12 22:31:58',NULL),(4810,7768,41297,87319,3,4071,'App\\Models\\Receipt',4071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',2401.76,NULL,NULL,1,'2023-04-12 22:31:58','2023-04-12 22:31:58',NULL),(4811,7768,41297,87319,3,4072,'App\\Models\\Receipt',4072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',2675.68,NULL,NULL,1,'2023-04-12 22:31:58','2023-04-12 22:31:58',NULL),(4812,7768,41297,87319,3,4073,'App\\Models\\Receipt',4073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',7444.62,NULL,NULL,1,'2023-04-12 22:31:58','2023-04-12 22:31:58',NULL),(4813,7768,41297,87319,3,4074,'App\\Models\\Receipt',4074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',2288.64,NULL,NULL,1,'2023-04-12 22:31:58','2023-04-12 22:31:58',NULL);
INSERT INTO `balance_libro` VALUES (4814,7768,41297,87319,3,4075,'App\\Models\\Receipt',4075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',87949.50,NULL,NULL,1,'2023-04-12 22:31:59','2023-04-12 22:31:59',NULL),(4815,7768,41297,87319,3,4076,'App\\Models\\Receipt',4076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',2400.99,NULL,NULL,1,'2023-04-12 22:31:59','2023-04-12 22:31:59',NULL),(4816,7768,41297,87319,3,4077,'App\\Models\\Receipt',4077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',8258.24,NULL,NULL,1,'2023-04-12 22:31:59','2023-04-12 22:31:59',NULL),(4817,7768,41297,87319,3,4078,'App\\Models\\Receipt',4078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',7300.90,NULL,NULL,1,'2023-04-12 22:31:59','2023-04-12 22:31:59',NULL),(4818,7768,41297,87319,3,4079,'App\\Models\\Receipt',4079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',680.01,NULL,NULL,1,'2023-04-12 22:31:59','2023-04-12 22:31:59',NULL),(4819,7768,41297,87319,3,4080,'App\\Models\\Receipt',4080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',2685.01,NULL,NULL,1,'2023-04-12 22:31:59','2023-04-12 22:31:59',NULL),(4820,7768,41297,87319,3,4081,'App\\Models\\Receipt',4081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',520.01,NULL,NULL,1,'2023-04-12 22:31:59','2023-04-12 22:31:59',NULL),(4821,7768,41297,87319,3,4082,'App\\Models\\Receipt',4082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',7300.25,NULL,NULL,1,'2023-04-12 22:31:59','2023-04-12 22:31:59',NULL),(4822,7768,41297,87319,3,4083,'App\\Models\\Receipt',4083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',1220.01,NULL,NULL,1,'2023-04-12 22:31:59','2023-04-12 22:31:59',NULL),(4823,7768,41297,87319,3,4084,'App\\Models\\Receipt',4084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',1740.02,NULL,NULL,1,'2023-04-12 22:31:59','2023-04-12 22:31:59',NULL),(4824,7768,41297,87319,3,4085,'App\\Models\\Receipt',4085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',1137.53,NULL,NULL,1,'2023-04-12 22:31:59','2023-04-12 22:31:59',NULL),(4825,7768,41297,87319,3,4086,'App\\Models\\Receipt',4086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',2080.01,NULL,NULL,1,'2023-04-12 22:31:59','2023-04-12 22:31:59',NULL),(4826,7768,41297,87319,3,4087,'App\\Models\\Receipt',4087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',9270.49,NULL,NULL,1,'2023-04-12 22:31:59','2023-04-12 22:31:59',NULL),(4827,7768,41297,87319,3,4088,'App\\Models\\Receipt',4088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',2585.00,NULL,NULL,1,'2023-04-12 22:31:59','2023-04-12 22:31:59',NULL),(4828,7768,41297,87319,3,4089,'App\\Models\\Receipt',4089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',2301.18,NULL,NULL,1,'2023-04-12 22:31:59','2023-04-12 22:31:59',NULL),(4829,7768,41297,87319,3,4090,'App\\Models\\Receipt',4090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',1470.01,NULL,NULL,1,'2023-04-12 22:31:59','2023-04-12 22:31:59',NULL),(4830,7768,41297,87319,3,4091,'App\\Models\\Receipt',4091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',3320.02,NULL,NULL,1,'2023-04-12 22:31:59','2023-04-12 22:31:59',NULL),(4831,7768,41297,87319,3,4092,'App\\Models\\Receipt',4092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',400.00,NULL,NULL,1,'2023-04-12 22:31:59','2023-04-12 22:31:59',NULL),(4832,7768,41297,87319,3,4093,'App\\Models\\Receipt',4093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',1700.01,NULL,NULL,1,'2023-04-12 22:31:59','2023-04-12 22:31:59',NULL),(4833,7768,41297,87319,3,4094,'App\\Models\\Receipt',4094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',8340.47,NULL,NULL,1,'2023-04-12 22:31:59','2023-04-12 22:31:59',NULL),(4834,7768,41297,87319,3,4095,'App\\Models\\Receipt',4095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',1600.00,NULL,NULL,1,'2023-04-12 22:31:59','2023-04-12 22:31:59',NULL);
INSERT INTO `balance_libro` VALUES (4835,7768,41297,87319,3,4096,'App\\Models\\Receipt',4096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',2220.00,NULL,NULL,1,'2023-04-12 22:31:59','2023-04-12 22:31:59',NULL),(4836,7768,41297,87319,3,4097,'App\\Models\\Receipt',4097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',4590.64,NULL,NULL,1,'2023-04-12 22:31:59','2023-04-12 22:31:59',NULL),(4837,7768,41297,87319,3,4098,'App\\Models\\Receipt',4098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-06','2022-02-06',8300.81,NULL,NULL,1,'2023-04-12 22:31:59','2023-04-12 22:31:59',NULL),(4838,7768,41297,87319,3,4099,'App\\Models\\Receipt',4099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',7200.35,NULL,NULL,1,'2023-04-12 22:31:59','2023-04-12 22:31:59',NULL),(4839,7768,41297,87319,3,4100,'App\\Models\\Receipt',4100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',7276.77,NULL,NULL,1,'2023-04-12 22:32:00','2023-04-12 22:32:00',NULL),(4840,7768,41297,87319,3,4101,'App\\Models\\Receipt',4101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',6848.73,NULL,NULL,1,'2023-04-12 22:32:00','2023-04-12 22:32:00',NULL),(4841,7768,41297,87319,3,4102,'App\\Models\\Receipt',4102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',6848.73,NULL,NULL,1,'2023-04-12 22:32:00','2023-04-12 22:32:00',NULL),(4842,7768,41297,87319,3,4103,'App\\Models\\Receipt',4103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',33914.42,NULL,NULL,1,'2023-04-12 22:32:00','2023-04-12 22:32:00',NULL),(4843,7768,41297,87319,3,4104,'App\\Models\\Receipt',4104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',13452.00,NULL,NULL,1,'2023-04-12 22:32:00','2023-04-12 22:32:00',NULL),(4844,7768,41297,87319,3,4105,'App\\Models\\Receipt',4105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',19551.98,NULL,NULL,1,'2023-04-12 22:32:00','2023-04-12 22:32:00',NULL),(4845,7768,41297,87319,3,4106,'App\\Models\\Receipt',4106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',81625.68,NULL,NULL,1,'2023-04-12 22:32:00','2023-04-12 22:32:00',NULL),(4846,7768,41297,87319,3,4107,'App\\Models\\Receipt',4107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',70773.98,NULL,NULL,1,'2023-04-12 22:32:00','2023-04-12 22:32:00',NULL),(4847,7768,41297,87319,3,4108,'App\\Models\\Receipt',4108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',65683.16,NULL,NULL,1,'2023-04-12 22:32:00','2023-04-12 22:32:00',NULL),(4848,7768,41297,87319,3,4109,'App\\Models\\Receipt',4109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',344693.49,NULL,NULL,1,'2023-04-12 22:35:03','2023-04-12 22:35:03',NULL),(4849,7768,41297,87319,3,4110,'App\\Models\\Receipt',4110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',28117.08,NULL,NULL,1,'2023-04-12 22:35:03','2023-04-12 22:35:03',NULL),(4850,7768,41297,87319,3,4111,'App\\Models\\Receipt',4111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',73.72,NULL,NULL,1,'2023-04-12 22:35:03','2023-04-12 22:35:03',NULL),(4851,7768,41297,87319,3,4112,'App\\Models\\Receipt',4112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',32039.03,NULL,NULL,1,'2023-04-12 22:35:03','2023-04-12 22:35:03',NULL),(4852,7768,41297,87319,3,4113,'App\\Models\\Receipt',4113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',29668.18,NULL,NULL,1,'2023-04-12 22:35:03','2023-04-12 22:35:03',NULL),(4853,7768,41297,87319,3,4114,'App\\Models\\Receipt',4114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',35715.01,NULL,NULL,1,'2023-04-12 22:35:03','2023-04-12 22:35:03',NULL),(4854,7768,41297,87319,3,4115,'App\\Models\\Receipt',4115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',1793.22,NULL,NULL,1,'2023-04-12 22:35:03','2023-04-12 22:35:03',NULL),(4855,7768,41297,87319,3,4116,'App\\Models\\Receipt',4116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',6532.18,NULL,NULL,1,'2023-04-12 22:35:04','2023-04-12 22:35:04',NULL);
INSERT INTO `balance_libro` VALUES (4856,7768,41297,87319,3,4117,'App\\Models\\Receipt',4117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',1865.09,NULL,NULL,1,'2023-04-12 22:35:04','2023-04-12 22:35:04',NULL),(4857,7768,41297,87319,3,4118,'App\\Models\\Receipt',4118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',11000.00,NULL,NULL,1,'2023-04-12 22:35:04','2023-04-12 22:35:04',NULL),(4858,7768,41297,87319,3,4119,'App\\Models\\Receipt',4119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',331512.94,NULL,NULL,1,'2023-04-12 22:35:04','2023-04-12 22:35:04',NULL),(4859,7768,41297,87319,3,4120,'App\\Models\\Receipt',4120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',51757.41,NULL,NULL,1,'2023-04-12 22:35:04','2023-04-12 22:35:04',NULL),(4860,7768,41297,87319,3,4121,'App\\Models\\Receipt',4121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-06','2022-02-06',8300.82,NULL,NULL,1,'2023-04-12 22:35:04','2023-04-12 22:35:04',NULL),(4861,7768,41297,87319,3,4122,'App\\Models\\Receipt',4122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',939511.95,NULL,NULL,1,'2023-04-12 22:35:04','2023-04-12 22:35:04',NULL),(4862,7768,41297,87319,3,4123,'App\\Models\\Receipt',4123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',407274.87,NULL,NULL,1,'2023-04-12 22:35:04','2023-04-12 22:35:04',NULL),(4863,7768,41297,87319,3,4124,'App\\Models\\Receipt',4124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',1200.00,NULL,NULL,1,'2023-04-12 22:35:04','2023-04-12 22:35:04',NULL),(4864,7768,41297,87319,3,4125,'App\\Models\\Receipt',4125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',12147.00,NULL,NULL,1,'2023-04-12 22:35:04','2023-04-12 22:35:04',NULL),(4865,7768,41297,87319,3,4126,'App\\Models\\Receipt',4126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',30900.00,NULL,NULL,1,'2023-04-12 22:35:04','2023-04-12 22:35:04',NULL),(4866,7768,41297,87319,3,4127,'App\\Models\\Receipt',4127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',330027.79,NULL,NULL,1,'2023-04-12 22:35:04','2023-04-12 22:35:04',NULL),(4867,7768,41297,87319,3,4128,'App\\Models\\Receipt',4128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',110000.00,NULL,NULL,1,'2023-04-12 22:35:04','2023-04-12 22:35:04',NULL),(4868,7768,41297,87319,3,4129,'App\\Models\\Receipt',4129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',850.00,NULL,NULL,1,'2023-04-12 22:35:04','2023-04-12 22:35:04',NULL),(4869,7768,41297,87319,3,4130,'App\\Models\\Receipt',4130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',198900.00,NULL,NULL,1,'2023-04-12 22:35:04','2023-04-12 22:35:04',NULL),(4870,7768,41297,87319,3,4131,'App\\Models\\Receipt',4131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',18150.00,NULL,NULL,1,'2023-04-12 22:35:04','2023-04-12 22:35:04',NULL),(4871,7768,41297,87319,3,4132,'App\\Models\\Receipt',4132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-12','2022-02-12',4000.26,NULL,NULL,1,'2023-04-12 22:35:04','2023-04-12 22:35:04',NULL),(4872,7768,41297,87319,3,4133,'App\\Models\\Receipt',4133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',21745.95,NULL,NULL,1,'2023-04-12 22:35:04','2023-04-12 22:35:04',NULL),(4873,7768,41297,87319,3,4134,'App\\Models\\Receipt',4134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',396719.10,NULL,NULL,1,'2023-04-12 22:35:04','2023-04-12 22:35:04',NULL),(4874,7768,41297,87319,3,4135,'App\\Models\\Receipt',4135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',7770.00,NULL,NULL,1,'2023-04-12 22:35:04','2023-04-12 22:35:04',NULL),(4875,7768,41297,87319,3,4136,'App\\Models\\Receipt',4136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',309512.92,NULL,NULL,1,'2023-04-12 22:35:04','2023-04-12 22:35:04',NULL),(4876,7768,41297,87319,3,4137,'App\\Models\\Receipt',4137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',59920.00,NULL,NULL,1,'2023-04-12 22:35:04','2023-04-12 22:35:04',NULL);
INSERT INTO `balance_libro` VALUES (4877,7768,41297,87319,3,4138,'App\\Models\\Receipt',4138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',15435.45,NULL,NULL,1,'2023-04-12 22:35:04','2023-04-12 22:35:04',NULL),(4878,7768,41297,87319,3,4139,'App\\Models\\Receipt',4139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',954.19,NULL,NULL,1,'2023-04-12 22:35:04','2023-04-12 22:35:04',NULL),(4879,7768,41297,87319,3,4140,'App\\Models\\Receipt',4140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',961.95,NULL,NULL,1,'2023-04-12 22:35:04','2023-04-12 22:35:04',NULL),(4880,7768,41297,87319,3,4141,'App\\Models\\Receipt',4141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',72953.46,NULL,NULL,1,'2023-04-12 22:35:05','2023-04-12 22:35:05',NULL),(4881,7768,41297,87319,3,4142,'App\\Models\\Receipt',4142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',9553.77,NULL,NULL,1,'2023-04-12 22:35:05','2023-04-12 22:35:05',NULL),(4882,7768,41297,87319,3,4143,'App\\Models\\Receipt',4143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',143921.37,NULL,NULL,1,'2023-04-12 22:35:05','2023-04-12 22:35:05',NULL),(4883,7768,41297,87319,3,4144,'App\\Models\\Receipt',4144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',66117.99,NULL,NULL,1,'2023-04-12 22:35:05','2023-04-12 22:35:05',NULL),(4884,7768,41297,87319,3,4145,'App\\Models\\Receipt',4145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',296362.88,NULL,NULL,1,'2023-04-12 22:35:05','2023-04-12 22:35:05',NULL),(4885,7768,41297,87319,3,4146,'App\\Models\\Receipt',4146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-19','2022-02-19',36860.00,NULL,NULL,1,'2023-04-12 22:35:05','2023-04-12 22:35:05',NULL),(4886,7768,41297,87319,3,4147,'App\\Models\\Receipt',4147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',67573.59,NULL,NULL,1,'2023-04-12 22:35:05','2023-04-12 22:35:05',NULL),(4887,7768,41297,87319,3,4148,'App\\Models\\Receipt',4148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',85900.00,NULL,NULL,1,'2023-04-12 22:35:05','2023-04-12 22:35:05',NULL),(4888,7768,41297,87319,3,4149,'App\\Models\\Receipt',4149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',5805.58,NULL,NULL,1,'2023-04-12 22:35:05','2023-04-12 22:35:05',NULL),(4889,7768,41297,87319,3,4150,'App\\Models\\Receipt',4150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',8226.33,NULL,NULL,1,'2023-04-12 22:35:05','2023-04-12 22:35:05',NULL),(4890,7768,41297,87319,3,4151,'App\\Models\\Receipt',4151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',142211.20,NULL,NULL,1,'2023-04-12 22:35:05','2023-04-12 22:35:05',NULL),(4891,7768,41297,87319,3,4152,'App\\Models\\Receipt',4152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',29000.00,NULL,NULL,1,'2023-04-12 22:35:05','2023-04-12 22:35:05',NULL),(4892,7768,41297,87319,3,4153,'App\\Models\\Receipt',4153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',4014.88,NULL,NULL,1,'2023-04-12 22:35:05','2023-04-12 22:35:05',NULL),(4893,7768,41297,87319,3,4154,'App\\Models\\Receipt',4154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',44213.40,NULL,NULL,1,'2023-04-12 22:35:05','2023-04-12 22:35:05',NULL),(4894,7768,41297,87319,3,4155,'App\\Models\\Receipt',4155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',76290.50,NULL,NULL,1,'2023-04-12 22:35:05','2023-04-12 22:35:05',NULL),(4895,7768,41297,87319,3,4156,'App\\Models\\Receipt',4156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',18895.02,NULL,NULL,1,'2023-04-12 22:35:05','2023-04-12 22:35:05',NULL),(4896,7768,41297,87319,3,4157,'App\\Models\\Receipt',4157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',260122.64,NULL,NULL,1,'2023-04-12 22:35:05','2023-04-12 22:35:05',NULL),(4897,7768,41297,87319,3,4158,'App\\Models\\Receipt',4158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',11411.29,NULL,NULL,1,'2023-04-12 22:35:05','2023-04-12 22:35:05',NULL);
INSERT INTO `balance_libro` VALUES (4898,7768,41297,87319,3,4159,'App\\Models\\Receipt',4159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',19887.37,NULL,NULL,1,'2023-04-12 22:35:05','2023-04-12 22:35:05',NULL),(4899,7768,41297,87319,3,4160,'App\\Models\\Receipt',4160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',1760.92,NULL,NULL,1,'2023-04-12 22:35:05','2023-04-12 22:35:05',NULL),(4900,7768,41297,87319,3,4161,'App\\Models\\Receipt',4161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',5810.00,NULL,NULL,1,'2023-04-12 22:35:05','2023-04-12 22:35:05',NULL),(4901,7768,41297,87319,3,4162,'App\\Models\\Receipt',4162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',7008.60,NULL,NULL,1,'2023-04-12 22:35:05','2023-04-12 22:35:05',NULL),(4902,7768,41297,87319,3,4163,'App\\Models\\Receipt',4163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',4300.00,NULL,NULL,1,'2023-04-12 22:35:05','2023-04-12 22:35:05',NULL),(4903,7768,41297,87319,9,4164,'App\\Models\\Receipt',4164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',628447.17,NULL,NULL,1,'2023-04-12 22:37:10','2023-04-12 22:37:10',NULL),(4904,7768,41297,87319,7,4165,'App\\Models\\Receipt',4165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',178151.58,NULL,NULL,1,'2023-04-12 22:38:19','2023-04-12 22:39:43','2023-04-12 22:39:43'),(4905,7768,41297,87319,7,4165,'App\\Models\\Receipt',4165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',178151.58,NULL,NULL,1,'2023-04-12 22:39:43','2023-04-12 22:39:43',NULL),(4906,7768,41297,87319,15,1521,'App\\Models\\PeriodLiquidation',NULL,1521,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',7428808.53,NULL,NULL,1,'2023-04-12 22:40:45','2023-04-12 22:40:45',NULL),(4907,7768,41297,87320,3,4166,'App\\Models\\Receipt',4166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',91503.23,NULL,NULL,1,'2023-04-12 22:42:59','2023-04-12 22:42:59',NULL),(4908,7768,41297,87320,3,4167,'App\\Models\\Receipt',4167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',728338.65,NULL,NULL,1,'2023-04-12 22:42:59','2023-04-12 22:42:59',NULL),(4909,7768,41297,87320,3,4168,'App\\Models\\Receipt',4168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',12841.39,NULL,NULL,1,'2023-04-12 22:42:59','2023-04-12 22:42:59',NULL),(4910,7768,41297,87320,3,4169,'App\\Models\\Receipt',4169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',306558.74,NULL,NULL,1,'2023-04-12 22:42:59','2023-04-12 22:42:59',NULL),(4911,7768,41297,87320,3,4170,'App\\Models\\Receipt',4170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',439.99,NULL,NULL,1,'2023-04-12 22:42:59','2023-04-12 22:42:59',NULL),(4912,7768,41297,87320,3,4171,'App\\Models\\Receipt',4171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',10476.66,NULL,NULL,1,'2023-04-12 22:42:59','2023-04-12 22:42:59',NULL),(4913,7768,41297,87320,3,4172,'App\\Models\\Receipt',4172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',2901.25,NULL,NULL,1,'2023-04-12 22:42:59','2023-04-12 22:42:59',NULL),(4914,7768,41297,87320,3,4173,'App\\Models\\Receipt',4173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',5892.66,NULL,NULL,1,'2023-04-12 22:42:59','2023-04-12 22:42:59',NULL),(4915,7768,41297,87320,3,4174,'App\\Models\\Receipt',4174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',5456.47,NULL,NULL,1,'2023-04-12 22:42:59','2023-04-12 22:42:59',NULL),(4916,7768,41297,87320,3,4175,'App\\Models\\Receipt',4175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',8101.64,NULL,NULL,1,'2023-04-12 22:42:59','2023-04-12 22:42:59',NULL),(4917,7768,41297,87320,3,4176,'App\\Models\\Receipt',4176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',4890.00,NULL,NULL,1,'2023-04-12 22:42:59','2023-04-12 22:42:59',NULL);
INSERT INTO `balance_libro` VALUES (4918,7768,41297,87320,3,4177,'App\\Models\\Receipt',4177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',1800.00,NULL,NULL,1,'2023-04-12 22:43:00','2023-04-12 22:43:00',NULL),(4919,7768,41297,87320,3,4178,'App\\Models\\Receipt',4178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',553.39,NULL,NULL,1,'2023-04-12 22:43:00','2023-04-12 22:43:00',NULL),(4920,7768,41297,87320,3,4179,'App\\Models\\Receipt',4179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',10485.96,NULL,NULL,1,'2023-04-12 22:43:00','2023-04-12 22:43:00',NULL),(4921,7768,41297,87320,3,4180,'App\\Models\\Receipt',4180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',2649.95,NULL,NULL,1,'2023-04-12 22:43:00','2023-04-12 22:43:00',NULL),(4922,7768,41297,87320,3,4181,'App\\Models\\Receipt',4181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',749.99,NULL,NULL,1,'2023-04-12 22:43:00','2023-04-12 22:43:00',NULL),(4923,7768,41297,87320,3,4182,'App\\Models\\Receipt',4182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',8500.43,NULL,NULL,1,'2023-04-12 22:43:00','2023-04-12 22:43:00',NULL),(4924,7768,41297,87320,3,4183,'App\\Models\\Receipt',4183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',730.01,NULL,NULL,1,'2023-04-12 22:43:00','2023-04-12 22:43:00',NULL),(4925,7768,41297,87320,3,4184,'App\\Models\\Receipt',4184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',1600.00,NULL,NULL,1,'2023-04-12 22:43:00','2023-04-12 22:43:00',NULL),(4926,7768,41297,87320,3,4185,'App\\Models\\Receipt',4185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',1150.00,NULL,NULL,1,'2023-04-12 22:43:00','2023-04-12 22:43:00',NULL),(4927,7768,41297,87320,3,4186,'App\\Models\\Receipt',4186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',10000.03,NULL,NULL,1,'2023-04-12 22:43:00','2023-04-12 22:43:00',NULL),(4928,7768,41297,87320,3,4187,'App\\Models\\Receipt',4187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',2770.81,NULL,NULL,1,'2023-04-12 22:43:00','2023-04-12 22:43:00',NULL),(4929,7768,41297,87320,3,4188,'App\\Models\\Receipt',4188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',549.99,NULL,NULL,1,'2023-04-12 22:43:00','2023-04-12 22:43:00',NULL),(4930,7768,41297,87320,3,4189,'App\\Models\\Receipt',4189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',890.02,NULL,NULL,1,'2023-04-12 22:43:00','2023-04-12 22:43:00',NULL),(4931,7768,41297,87320,3,4190,'App\\Models\\Receipt',4190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',2205.01,NULL,NULL,1,'2023-04-12 22:43:00','2023-04-12 22:43:00',NULL),(4932,7768,41297,87320,3,4191,'App\\Models\\Receipt',4191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',1500.00,NULL,NULL,1,'2023-04-12 22:43:00','2023-04-12 22:43:00',NULL),(4933,7768,41297,87320,3,4192,'App\\Models\\Receipt',4192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',1640.00,NULL,NULL,1,'2023-04-12 22:43:00','2023-04-12 22:43:00',NULL),(4934,7768,41297,87320,3,4193,'App\\Models\\Receipt',4193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',6050.34,NULL,NULL,1,'2023-04-12 22:43:00','2023-04-12 22:43:00',NULL),(4935,7768,41297,87320,3,4194,'App\\Models\\Receipt',4194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',4800.86,NULL,NULL,1,'2023-04-12 22:43:00','2023-04-12 22:43:00',NULL),(4936,7768,41297,87320,3,4195,'App\\Models\\Receipt',4195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',2349.99,NULL,NULL,1,'2023-04-12 22:43:00','2023-04-12 22:43:00',NULL),(4937,7768,41297,87320,3,4196,'App\\Models\\Receipt',4196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',7500.30,NULL,NULL,1,'2023-04-12 22:43:00','2023-04-12 22:43:00',NULL),(4938,7768,41297,87320,3,4197,'App\\Models\\Receipt',4197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-13','2022-03-13',5538.45,NULL,NULL,1,'2023-04-12 22:43:00','2023-04-12 22:43:00',NULL);
INSERT INTO `balance_libro` VALUES (4939,7768,41297,87320,3,4198,'App\\Models\\Receipt',4198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',5215.77,NULL,NULL,1,'2023-04-12 22:43:00','2023-04-12 22:43:00',NULL),(4940,7768,41297,87320,3,4199,'App\\Models\\Receipt',4199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',1240.00,NULL,NULL,1,'2023-04-12 22:43:01','2023-04-12 22:43:01',NULL),(4941,7768,41297,87320,3,4200,'App\\Models\\Receipt',4200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',950.00,NULL,NULL,1,'2023-04-12 22:43:01','2023-04-12 22:43:01',NULL),(4942,7768,41297,87320,3,4201,'App\\Models\\Receipt',4201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',2801.56,NULL,NULL,1,'2023-04-12 22:43:01','2023-04-12 22:43:01',NULL),(4943,7768,41297,87320,3,4202,'App\\Models\\Receipt',4202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',1070.00,NULL,NULL,1,'2023-04-12 22:43:01','2023-04-12 22:43:01',NULL),(4944,7768,41297,87320,3,4203,'App\\Models\\Receipt',4203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',240.00,NULL,NULL,1,'2023-04-12 22:43:01','2023-04-12 22:43:01',NULL),(4945,7768,41297,87320,3,4204,'App\\Models\\Receipt',4204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',950.00,NULL,NULL,1,'2023-04-12 22:43:01','2023-04-12 22:43:01',NULL),(4946,7768,41297,87320,3,4205,'App\\Models\\Receipt',4205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',6067.97,NULL,NULL,1,'2023-04-12 22:43:01','2023-04-12 22:43:01',NULL),(4947,7768,41297,87320,3,4206,'App\\Models\\Receipt',4206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',870.00,NULL,NULL,1,'2023-04-12 22:43:01','2023-04-12 22:43:01',NULL),(4948,7768,41297,87320,3,4207,'App\\Models\\Receipt',4207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',5100.29,NULL,NULL,1,'2023-04-12 22:43:01','2023-04-12 22:43:01',NULL),(4949,7768,41297,87320,3,4208,'App\\Models\\Receipt',4208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',93928.97,NULL,NULL,1,'2023-04-12 22:43:01','2023-04-12 22:43:01',NULL),(4950,7768,41297,87320,3,4209,'App\\Models\\Receipt',4209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',137778.71,NULL,NULL,1,'2023-04-12 22:43:01','2023-04-12 22:43:01',NULL),(4951,7768,41297,87320,3,4210,'App\\Models\\Receipt',4210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',137962.90,NULL,NULL,1,'2023-04-12 22:43:01','2023-04-12 22:43:01',NULL),(4952,7768,41297,87320,3,4211,'App\\Models\\Receipt',4211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',113117.74,NULL,NULL,1,'2023-04-12 22:43:01','2023-04-12 22:43:01',NULL),(4953,7768,41297,87320,3,4212,'App\\Models\\Receipt',4212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',207139.40,NULL,NULL,1,'2023-04-12 22:43:01','2023-04-12 22:43:01',NULL),(4954,7768,41297,87320,3,4213,'App\\Models\\Receipt',4213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',259514.82,NULL,NULL,1,'2023-04-12 22:43:01','2023-04-12 22:43:01',NULL),(4955,7768,41297,87320,3,4214,'App\\Models\\Receipt',4214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',360221.83,NULL,NULL,1,'2023-04-12 22:43:01','2023-04-12 22:43:01',NULL),(4956,7768,41297,87320,3,4215,'App\\Models\\Receipt',4215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',83792.50,NULL,NULL,1,'2023-04-12 22:43:01','2023-04-12 22:43:01',NULL),(4957,7768,41297,87320,3,4216,'App\\Models\\Receipt',4216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',3044.54,NULL,NULL,1,'2023-04-12 22:43:01','2023-04-12 22:43:01',NULL),(4958,7768,41297,87320,3,4217,'App\\Models\\Receipt',4217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',9447.77,NULL,NULL,1,'2023-04-12 22:43:01','2023-04-12 22:43:01',NULL),(4959,7768,41297,87320,3,4218,'App\\Models\\Receipt',4218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',4759.11,NULL,NULL,1,'2023-04-12 22:43:01','2023-04-12 22:43:01',NULL);
INSERT INTO `balance_libro` VALUES (4960,7768,41297,87320,3,4219,'App\\Models\\Receipt',4219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',757.29,NULL,NULL,1,'2023-04-12 22:43:01','2023-04-12 22:43:01',NULL),(4961,7768,41297,87320,3,4220,'App\\Models\\Receipt',4220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',148.54,NULL,NULL,1,'2023-04-12 22:43:01','2023-04-12 22:43:01',NULL),(4962,7768,41297,87320,3,4221,'App\\Models\\Receipt',4221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',968.00,NULL,NULL,1,'2023-04-12 22:43:01','2023-04-12 22:43:01',NULL),(4963,7768,41297,87320,3,4222,'App\\Models\\Receipt',4222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',769368.70,NULL,NULL,1,'2023-04-12 22:43:01','2023-04-12 22:43:01',NULL),(4964,7768,41297,87320,3,4223,'App\\Models\\Receipt',4223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',244938.86,NULL,NULL,1,'2023-04-12 22:43:01','2023-04-12 22:43:01',NULL),(4965,7768,41297,87320,3,4224,'App\\Models\\Receipt',4224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',972400.00,NULL,NULL,1,'2023-04-12 22:43:02','2023-04-12 22:43:02',NULL),(4966,7768,41297,87320,3,4225,'App\\Models\\Receipt',4225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',948403.23,NULL,NULL,1,'2023-04-12 22:43:02','2023-04-12 22:43:02',NULL),(4967,7768,41297,87320,3,4226,'App\\Models\\Receipt',4226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',315800.00,NULL,NULL,1,'2023-04-12 22:43:02','2023-04-12 22:43:02',NULL),(4968,7768,41297,87320,3,4227,'App\\Models\\Receipt',4227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',22329.00,NULL,NULL,1,'2023-04-12 22:43:02','2023-04-12 22:43:02',NULL),(4969,7768,41297,87320,3,4228,'App\\Models\\Receipt',4228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',920.00,NULL,NULL,1,'2023-04-12 22:43:02','2023-04-12 22:43:02',NULL),(4970,7768,41297,87320,3,4229,'App\\Models\\Receipt',4229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',7008.60,NULL,NULL,1,'2023-04-12 22:43:02','2023-04-12 22:43:02',NULL),(4971,7768,41297,87320,3,4230,'App\\Models\\Receipt',4230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',237362.55,NULL,NULL,1,'2023-04-12 22:43:02','2023-04-12 22:43:02',NULL),(4972,7768,41297,87320,3,4231,'App\\Models\\Receipt',4231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',19988.43,NULL,NULL,1,'2023-04-12 22:43:02','2023-04-12 22:43:02',NULL),(4973,7768,41297,87320,3,4232,'App\\Models\\Receipt',4232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',135710.89,NULL,NULL,1,'2023-04-12 22:43:02','2023-04-12 22:43:02',NULL),(4974,7768,41297,87320,3,4233,'App\\Models\\Receipt',4233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',1512413.70,NULL,NULL,1,'2023-04-12 22:43:02','2023-04-12 22:43:02',NULL),(4975,7768,41297,87320,3,4234,'App\\Models\\Receipt',4234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',1387055.71,NULL,NULL,1,'2023-04-12 22:43:02','2023-04-12 22:43:02',NULL),(4976,7768,41297,87320,3,4235,'App\\Models\\Receipt',4235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',905488.50,NULL,NULL,1,'2023-04-12 22:43:02','2023-04-12 22:43:02',NULL),(4977,7768,41297,87320,3,4236,'App\\Models\\Receipt',4236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',1786658.60,NULL,NULL,1,'2023-04-12 22:43:02','2023-04-12 22:43:02',NULL),(4978,7768,41297,87320,3,4237,'App\\Models\\Receipt',4237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',1121148.25,NULL,NULL,1,'2023-04-12 22:43:02','2023-04-12 22:43:02',NULL),(4979,7768,41297,87320,3,4238,'App\\Models\\Receipt',4238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',71995.00,NULL,NULL,1,'2023-04-12 22:43:02','2023-04-12 22:43:02',NULL);
INSERT INTO `balance_libro` VALUES (4980,7768,41297,87320,3,4239,'App\\Models\\Receipt',4239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',474688.37,NULL,NULL,1,'2023-04-12 22:43:02','2023-04-12 22:43:02',NULL),(4981,7768,41297,87320,3,4240,'App\\Models\\Receipt',4240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',400912.51,NULL,NULL,1,'2023-04-12 22:43:02','2023-04-12 22:43:02',NULL),(4982,7768,41297,87320,3,4241,'App\\Models\\Receipt',4241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',251326.68,NULL,NULL,1,'2023-04-12 22:43:02','2023-04-12 22:43:02',NULL),(4983,7768,41297,87320,3,4242,'App\\Models\\Receipt',4242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',791023.46,NULL,NULL,1,'2023-04-12 22:43:02','2023-04-12 22:43:02',NULL),(4984,7768,41297,87320,3,4243,'App\\Models\\Receipt',4243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',70470.00,NULL,NULL,1,'2023-04-12 22:43:02','2023-04-12 22:43:02',NULL),(4985,7768,41297,87320,3,4244,'App\\Models\\Receipt',4244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',91600.00,NULL,NULL,1,'2023-04-12 22:43:02','2023-04-12 22:43:02',NULL),(4986,7768,41297,87320,3,4245,'App\\Models\\Receipt',4245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',74023.95,NULL,NULL,1,'2023-04-12 22:43:02','2023-04-12 22:43:02',NULL),(4987,7768,41297,87320,3,4246,'App\\Models\\Receipt',4246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',38588.47,NULL,NULL,1,'2023-04-12 22:43:02','2023-04-12 22:43:02',NULL),(4988,7768,41297,87320,3,4247,'App\\Models\\Receipt',4247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',11550.00,NULL,NULL,1,'2023-04-12 22:43:02','2023-04-12 22:43:02',NULL),(4989,7768,41297,87320,3,4248,'App\\Models\\Receipt',4248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',67760.00,NULL,NULL,1,'2023-04-12 22:43:03','2023-04-12 22:43:03',NULL),(4990,7768,41297,87320,3,4249,'App\\Models\\Receipt',4249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',11550.00,NULL,NULL,1,'2023-04-12 22:43:03','2023-04-12 22:43:03',NULL),(4991,7768,41297,87320,3,4250,'App\\Models\\Receipt',4250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',4022.09,NULL,NULL,1,'2023-04-12 22:43:03','2023-04-12 22:43:03',NULL),(4992,7768,41297,87320,3,4251,'App\\Models\\Receipt',4251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',242268.47,NULL,NULL,1,'2023-04-12 22:43:03','2023-04-12 22:43:03',NULL),(4993,7768,41297,87320,3,4252,'App\\Models\\Receipt',4252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',51408.85,NULL,NULL,1,'2023-04-12 22:43:03','2023-04-12 22:43:03',NULL),(4994,7768,41297,87320,3,4253,'App\\Models\\Receipt',4253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',6900.00,NULL,NULL,1,'2023-04-12 22:43:03','2023-04-12 22:43:03',NULL),(4995,7768,41297,87320,3,4254,'App\\Models\\Receipt',4254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',2937.98,NULL,NULL,1,'2023-04-12 22:43:03','2023-04-12 22:43:03',NULL),(4996,7768,41297,87320,3,4255,'App\\Models\\Receipt',4255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',8445.05,NULL,NULL,1,'2023-04-12 22:43:03','2023-04-12 22:43:03',NULL),(4997,7768,41297,87320,3,4256,'App\\Models\\Receipt',4256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',859052.68,NULL,NULL,1,'2023-04-12 22:43:03','2023-04-12 22:43:03',NULL),(4998,7768,41297,87320,3,4257,'App\\Models\\Receipt',4257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',148253.87,NULL,NULL,1,'2023-04-12 22:43:03','2023-04-12 22:43:03',NULL),(4999,7768,41297,87320,3,4258,'App\\Models\\Receipt',4258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',3582.81,NULL,NULL,1,'2023-04-12 22:43:03','2023-04-12 22:43:03',NULL),(5000,7768,41297,87320,3,4259,'App\\Models\\Receipt',4259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',409651.67,NULL,NULL,1,'2023-04-12 22:43:03','2023-04-12 22:43:03',NULL);
INSERT INTO `balance_libro` VALUES (5001,7768,41297,87320,3,4260,'App\\Models\\Receipt',4260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',24200.00,NULL,NULL,1,'2023-04-12 22:43:03','2023-04-12 22:43:03',NULL),(5002,7768,41297,87320,3,4261,'App\\Models\\Receipt',4261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',22152.99,NULL,NULL,1,'2023-04-12 22:43:03','2023-04-12 22:43:03',NULL),(5003,7768,41297,87320,3,4262,'App\\Models\\Receipt',4262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',13523.25,NULL,NULL,1,'2023-04-12 22:43:03','2023-04-12 22:43:03',NULL),(5004,7768,41297,87320,3,4263,'App\\Models\\Receipt',4263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',7910.00,NULL,NULL,1,'2023-04-12 22:43:03','2023-04-12 22:43:03',NULL),(5005,7768,41297,87320,3,4264,'App\\Models\\Receipt',4264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',39754.04,NULL,NULL,1,'2023-04-12 22:43:03','2023-04-12 22:43:03',NULL),(5006,7768,41297,87320,3,4265,'App\\Models\\Receipt',4265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1426.19,NULL,NULL,1,'2023-04-12 22:43:03','2023-04-12 22:43:03',NULL),(5007,7768,41297,87320,3,4266,'App\\Models\\Receipt',4266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1530.79,NULL,NULL,1,'2023-04-12 22:43:03','2023-04-12 22:43:03',NULL),(5008,7768,41297,87320,3,4267,'App\\Models\\Receipt',4267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1901849.61,NULL,NULL,1,'2023-04-12 22:43:03','2023-04-12 22:43:03',NULL),(5009,7768,41297,87320,3,4268,'App\\Models\\Receipt',4268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',270765.17,NULL,NULL,1,'2023-04-12 22:43:03','2023-04-12 22:43:03',NULL),(5010,7768,41297,87320,3,4269,'App\\Models\\Receipt',4269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',119984.47,NULL,NULL,1,'2023-04-12 22:43:03','2023-04-12 22:43:03',NULL),(5011,7768,41297,87320,3,4270,'App\\Models\\Receipt',4270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',74223.76,NULL,NULL,1,'2023-04-12 22:43:03','2023-04-12 22:43:03',NULL),(5012,7768,41297,87320,3,4271,'App\\Models\\Receipt',4271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',114642.58,NULL,NULL,1,'2023-04-12 22:43:03','2023-04-12 22:43:03',NULL),(5013,7768,41297,87320,3,4272,'App\\Models\\Receipt',4272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',4300.00,NULL,NULL,1,'2023-04-12 22:43:03','2023-04-12 22:43:03',NULL),(5014,7768,41297,87320,3,4273,'App\\Models\\Receipt',4273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',119984.47,NULL,NULL,1,'2023-04-12 22:43:03','2023-04-12 22:43:03',NULL),(5015,7768,41297,87320,3,4274,'App\\Models\\Receipt',4274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',74223.76,NULL,NULL,1,'2023-04-12 22:43:04','2023-04-12 22:43:04',NULL),(5016,7768,41297,87320,3,4275,'App\\Models\\Receipt',4275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',114642.58,NULL,NULL,1,'2023-04-12 22:43:04','2023-04-12 22:43:04',NULL),(5017,7768,41297,87320,3,4276,'App\\Models\\Receipt',4276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',5017.91,NULL,NULL,1,'2023-04-12 22:43:04','2023-04-12 22:43:04',NULL),(5018,7768,41297,87320,3,4277,'App\\Models\\Receipt',4277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',38741.52,NULL,NULL,1,'2023-04-12 22:43:04','2023-04-12 22:43:04',NULL),(5019,7768,41297,87320,3,4278,'App\\Models\\Receipt',4278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',42898.73,NULL,NULL,1,'2023-04-12 22:43:04','2023-04-12 22:43:04',NULL),(5020,7768,41297,87320,2,2554,'App\\Models\\Receipt',2554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',19467.90,NULL,NULL,1,'2023-04-12 22:46:28','2023-04-12 22:46:28',NULL),(5021,7768,41297,87320,7,4279,'App\\Models\\Receipt',4279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',651622.83,NULL,NULL,1,'2023-04-12 22:48:44','2023-04-12 22:48:44',NULL);
INSERT INTO `balance_libro` VALUES (5022,7768,41297,87320,9,4280,'App\\Models\\Receipt',4280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',299912.84,NULL,NULL,1,'2023-04-12 22:49:33','2023-04-12 22:49:33',NULL),(5023,7768,40728,13790,3,4281,'App\\Models\\Receipt',4281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',5552.70,NULL,NULL,1,'2023-04-13 21:07:10','2023-04-17 20:51:33','2023-04-17 20:51:33'),(5024,7768,40728,13790,3,4282,'App\\Models\\Receipt',4282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',7188.62,NULL,NULL,1,'2023-04-13 21:07:10','2023-04-17 20:51:33','2023-04-17 20:51:33'),(5025,7768,40728,13790,3,4283,'App\\Models\\Receipt',4283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',14641.00,NULL,NULL,1,'2023-04-13 21:07:10','2023-04-17 20:51:33','2023-04-17 20:51:33'),(5026,7768,40728,13790,3,4284,'App\\Models\\Receipt',4284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',2689.35,NULL,NULL,1,'2023-04-13 21:07:10','2023-04-17 20:51:33','2023-04-17 20:51:33'),(5027,7768,40728,13790,3,4285,'App\\Models\\Receipt',4285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',7876.00,NULL,NULL,1,'2023-04-13 21:07:10','2023-04-17 20:51:33','2023-04-17 20:51:33'),(5028,7768,40728,13790,3,4286,'App\\Models\\Receipt',4286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',2859.23,NULL,NULL,1,'2023-04-13 21:07:11','2023-04-17 20:51:33','2023-04-17 20:51:33'),(5029,7768,40728,13790,3,4287,'App\\Models\\Receipt',4287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',3930.95,NULL,NULL,1,'2023-04-13 21:07:11','2023-04-17 20:51:33','2023-04-17 20:51:33'),(5030,7768,40728,13790,3,4288,'App\\Models\\Receipt',4288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',7138.41,NULL,NULL,1,'2023-04-13 21:07:11','2023-04-17 20:51:33','2023-04-17 20:51:33'),(5031,7768,40728,13790,3,4289,'App\\Models\\Receipt',4289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',3640.02,NULL,NULL,1,'2023-04-13 21:07:11','2023-04-17 20:51:33','2023-04-17 20:51:33'),(5032,7768,40728,13790,3,4290,'App\\Models\\Receipt',4290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',15910.76,NULL,NULL,1,'2023-04-13 21:07:11','2023-04-17 20:51:33','2023-04-17 20:51:33'),(5033,7768,40728,13790,3,4291,'App\\Models\\Receipt',4291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',6898.60,NULL,NULL,1,'2023-04-13 21:07:11','2023-04-17 20:51:33','2023-04-17 20:51:33'),(5034,7768,40728,13790,3,4292,'App\\Models\\Receipt',4292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',4975.17,NULL,NULL,1,'2023-04-13 21:07:11','2023-04-17 20:51:33','2023-04-17 20:51:33'),(5035,7768,40728,13790,3,4293,'App\\Models\\Receipt',4293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',25345.00,NULL,NULL,1,'2023-04-13 21:07:11','2023-04-17 20:51:33','2023-04-17 20:51:33'),(5036,7768,40728,13790,3,4294,'App\\Models\\Receipt',4294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',2815.48,NULL,NULL,1,'2023-04-13 21:07:11','2023-04-17 20:51:33','2023-04-17 20:51:33'),(5037,7768,40728,13790,3,4295,'App\\Models\\Receipt',4295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',833855.78,NULL,NULL,1,'2023-04-13 21:07:11','2023-04-17 20:51:33','2023-04-17 20:51:33'),(5038,7768,40728,13790,3,4296,'App\\Models\\Receipt',4296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',2529.47,NULL,NULL,1,'2023-04-13 21:07:11','2023-04-17 20:51:33','2023-04-17 20:51:33'),(5039,7768,40728,13790,3,4297,'App\\Models\\Receipt',4297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',4488.01,NULL,NULL,1,'2023-04-13 21:07:11','2023-04-17 20:51:33','2023-04-17 20:51:33'),(5040,7768,40728,13790,3,4298,'App\\Models\\Receipt',4298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',442.62,NULL,NULL,1,'2023-04-13 21:07:11','2023-04-17 20:51:33','2023-04-17 20:51:33');
INSERT INTO `balance_libro` VALUES (5041,7768,40728,13790,3,4299,'App\\Models\\Receipt',4299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',3094.07,NULL,NULL,1,'2023-04-13 21:07:11','2023-04-17 20:51:33','2023-04-17 20:51:33'),(5042,7768,40728,13790,3,4300,'App\\Models\\Receipt',4300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',22000.00,NULL,NULL,1,'2023-04-13 21:07:11','2023-04-17 20:51:33','2023-04-17 20:51:33'),(5043,7768,40728,13790,3,4301,'App\\Models\\Receipt',4301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',12500.00,NULL,NULL,1,'2023-04-13 21:07:11','2023-04-17 20:51:33','2023-04-17 20:51:33'),(5044,7768,40728,13790,3,4302,'App\\Models\\Receipt',4302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',173235.99,NULL,NULL,1,'2023-04-13 21:07:11','2023-04-17 20:51:33','2023-04-17 20:51:33'),(5045,7768,40728,13790,3,4303,'App\\Models\\Receipt',4303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',4710.00,NULL,NULL,1,'2023-04-13 21:07:12','2023-04-17 20:51:33','2023-04-17 20:51:33'),(5046,7768,40728,13790,3,4304,'App\\Models\\Receipt',4304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',7440.29,NULL,NULL,1,'2023-04-13 21:07:12','2023-04-17 20:51:33','2023-04-17 20:51:33'),(5047,7768,40728,13790,3,4305,'App\\Models\\Receipt',4305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',7809.05,NULL,NULL,1,'2023-04-13 21:07:12','2023-04-17 20:51:33','2023-04-17 20:51:33'),(5048,7768,40728,13790,3,4306,'App\\Models\\Receipt',4306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',2455.48,NULL,NULL,1,'2023-04-13 21:07:12','2023-04-17 20:51:33','2023-04-17 20:51:33'),(5049,7768,40728,13790,3,4307,'App\\Models\\Receipt',4307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',5832.89,NULL,NULL,1,'2023-04-13 21:07:12','2023-04-17 20:51:33','2023-04-17 20:51:33'),(5050,7768,40728,13790,3,4308,'App\\Models\\Receipt',4308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',30700.00,NULL,NULL,1,'2023-04-13 21:07:12','2023-04-17 20:51:33','2023-04-17 20:51:33'),(5051,7768,40728,13790,3,4309,'App\\Models\\Receipt',4309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',12500.51,NULL,NULL,1,'2023-04-13 21:07:12','2023-04-17 20:51:33','2023-04-17 20:51:33'),(5052,7768,40728,13790,3,4310,'App\\Models\\Receipt',4310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',20000.09,NULL,NULL,1,'2023-04-13 21:07:12','2023-04-17 20:51:33','2023-04-17 20:51:33'),(5053,7768,40728,13790,3,4311,'App\\Models\\Receipt',4311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',233261.08,NULL,NULL,1,'2023-04-13 21:07:12','2023-04-17 20:51:33','2023-04-17 20:51:33'),(5054,7768,40728,13790,3,4312,'App\\Models\\Receipt',4312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',67760.00,NULL,NULL,1,'2023-04-13 21:07:12','2023-04-17 20:51:33','2023-04-17 20:51:33'),(5055,7768,40728,13790,3,4313,'App\\Models\\Receipt',4313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',213730.11,NULL,NULL,1,'2023-04-13 21:07:12','2023-04-17 20:51:33','2023-04-17 20:51:33'),(5056,7768,40728,13790,3,4314,'App\\Models\\Receipt',4314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',106480.00,NULL,NULL,1,'2023-04-13 21:07:12','2023-04-17 20:51:33','2023-04-17 20:51:33'),(5057,7768,40728,13790,3,4315,'App\\Models\\Receipt',4315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',21175.63,NULL,NULL,1,'2023-04-13 21:07:12','2023-04-17 20:51:33','2023-04-17 20:51:33'),(5058,7768,40728,13790,3,4316,'App\\Models\\Receipt',4316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',83775.93,NULL,NULL,1,'2023-04-13 21:07:12','2023-04-17 20:51:33','2023-04-17 20:51:33'),(5059,7768,40728,13790,3,4317,'App\\Models\\Receipt',4317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',10788.82,NULL,NULL,1,'2023-04-13 21:07:12','2023-04-13 21:10:21','2023-04-13 21:10:21');
INSERT INTO `balance_libro` VALUES (5060,7768,40728,13790,3,4318,'App\\Models\\Receipt',4318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',26002.98,NULL,NULL,1,'2023-04-13 21:07:12','2023-04-17 20:51:33','2023-04-17 20:51:33'),(5061,7768,40728,13790,3,4319,'App\\Models\\Receipt',4319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',2100.00,NULL,NULL,1,'2023-04-13 21:07:12','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5062,7768,40728,13790,3,4320,'App\\Models\\Receipt',4320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',3306.34,NULL,NULL,1,'2023-04-13 21:07:12','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5063,7768,40728,13790,3,4321,'App\\Models\\Receipt',4321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',1478649.03,NULL,NULL,1,'2023-04-13 21:07:12','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5064,7768,40728,13790,3,4322,'App\\Models\\Receipt',4322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',937.67,NULL,NULL,1,'2023-04-13 21:07:12','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5065,7768,40728,13790,3,4323,'App\\Models\\Receipt',4323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',2509.29,NULL,NULL,1,'2023-04-13 21:07:12','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5066,7768,40728,13790,3,4324,'App\\Models\\Receipt',4324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',11398.20,NULL,NULL,1,'2023-04-13 21:07:12','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5067,7768,40728,13790,3,4325,'App\\Models\\Receipt',4325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',39154.81,NULL,NULL,1,'2023-04-13 21:07:12','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5068,7768,40728,13790,3,4326,'App\\Models\\Receipt',4326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',11900.00,NULL,NULL,1,'2023-04-13 21:07:13','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5069,7768,40728,13790,3,4327,'App\\Models\\Receipt',4327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',10333.56,NULL,NULL,1,'2023-04-13 21:07:13','2023-04-13 21:10:49','2023-04-13 21:10:49'),(5070,7768,40728,13790,3,4328,'App\\Models\\Receipt',4328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',4889.39,NULL,NULL,1,'2023-04-13 21:07:13','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5071,7768,40728,13790,3,4329,'App\\Models\\Receipt',4329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',660.05,NULL,NULL,1,'2023-04-13 21:07:13','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5072,7768,40728,13790,3,4330,'App\\Models\\Receipt',4330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',15273.81,NULL,NULL,1,'2023-04-13 21:07:13','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5073,7768,40728,13790,3,4331,'App\\Models\\Receipt',4331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',61999.00,NULL,NULL,1,'2023-04-13 21:07:13','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5074,7768,40728,13790,3,4332,'App\\Models\\Receipt',4332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',15730.00,NULL,NULL,1,'2023-04-13 21:07:13','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5075,7768,40728,13790,3,4333,'App\\Models\\Receipt',4333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',26862.00,NULL,NULL,1,'2023-04-13 21:07:13','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5076,7768,40728,13790,3,4334,'App\\Models\\Receipt',4334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',7262.54,NULL,NULL,1,'2023-04-13 21:07:13','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5077,7768,40728,13790,3,4335,'App\\Models\\Receipt',4335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',40000.00,NULL,NULL,1,'2023-04-13 21:07:13','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5078,7768,40728,13790,3,4336,'App\\Models\\Receipt',4336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',1500.00,NULL,NULL,1,'2023-04-13 21:07:13','2023-04-17 20:51:34','2023-04-17 20:51:34');
INSERT INTO `balance_libro` VALUES (5079,7768,40728,13790,3,4337,'App\\Models\\Receipt',4337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',4994.42,NULL,NULL,1,'2023-04-13 21:07:13','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5080,7768,40728,13790,3,4338,'App\\Models\\Receipt',4338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',140225.91,NULL,NULL,1,'2023-04-13 21:07:13','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5081,7768,40728,13790,3,4339,'App\\Models\\Receipt',4339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',14312.61,NULL,NULL,1,'2023-04-13 21:07:13','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5082,7768,40728,13790,3,4340,'App\\Models\\Receipt',4340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',447700.00,NULL,NULL,1,'2023-04-13 21:07:13','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5083,7768,40728,13790,3,4341,'App\\Models\\Receipt',4341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',11497.61,NULL,NULL,1,'2023-04-13 21:07:13','2023-04-13 21:08:44','2023-04-13 21:08:44'),(5084,7768,40728,13790,3,4342,'App\\Models\\Receipt',4342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',5077.52,NULL,NULL,1,'2023-04-13 21:07:13','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5085,7768,40728,13790,3,4343,'App\\Models\\Receipt',4343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',18654.05,NULL,NULL,1,'2023-04-13 21:07:13','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5086,7768,40728,13790,3,4344,'App\\Models\\Receipt',4344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',17432.63,NULL,NULL,1,'2023-04-13 21:07:13','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5087,7768,40728,13790,3,4345,'App\\Models\\Receipt',4345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',4004.99,NULL,NULL,1,'2023-04-13 21:07:13','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5088,7768,40728,13790,3,4346,'App\\Models\\Receipt',4346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',2300.20,NULL,NULL,1,'2023-04-13 21:07:13','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5089,7768,40728,13790,3,4347,'App\\Models\\Receipt',4347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',11000.00,NULL,NULL,1,'2023-04-13 21:07:13','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5090,7768,40728,13790,3,4348,'App\\Models\\Receipt',4348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',137360.28,NULL,NULL,1,'2023-04-13 21:07:13','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5091,7768,40728,13790,3,4349,'App\\Models\\Receipt',4349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',115281.30,NULL,NULL,1,'2023-04-13 21:07:13','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5092,7768,40728,13790,3,4350,'App\\Models\\Receipt',4350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',3300.03,NULL,NULL,1,'2023-04-13 21:07:13','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5093,7768,40728,13790,3,4351,'App\\Models\\Receipt',4351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',140225.91,NULL,NULL,1,'2023-04-13 21:07:13','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5094,7768,40728,13790,3,4352,'App\\Models\\Receipt',4352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',3500.00,NULL,NULL,1,'2023-04-13 21:07:13','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5095,7768,40728,13790,3,4353,'App\\Models\\Receipt',4353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',2896.08,NULL,NULL,1,'2023-04-13 21:07:14','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5096,7768,40728,13790,3,4354,'App\\Models\\Receipt',4354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',408035.28,NULL,NULL,1,'2023-04-13 21:07:14','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5097,7768,40728,13790,3,4355,'App\\Models\\Receipt',4355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',9535.99,NULL,NULL,1,'2023-04-13 21:07:14','2023-04-17 20:51:34','2023-04-17 20:51:34');
INSERT INTO `balance_libro` VALUES (5098,7768,40728,13790,3,4356,'App\\Models\\Receipt',4356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',163350.00,NULL,NULL,1,'2023-04-13 21:07:14','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5099,7768,40728,13790,3,4357,'App\\Models\\Receipt',4357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',60500.00,NULL,NULL,1,'2023-04-13 21:07:14','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5100,7768,40728,13790,3,4358,'App\\Models\\Receipt',4358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',417450.00,NULL,NULL,1,'2023-04-13 21:07:14','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5101,7768,40728,13790,3,4359,'App\\Models\\Receipt',4359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',7460.69,NULL,NULL,1,'2023-04-13 21:07:14','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5102,7768,40728,13790,3,4360,'App\\Models\\Receipt',4360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',19508.61,NULL,NULL,1,'2023-04-13 21:07:14','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5103,7768,40728,13790,3,4361,'App\\Models\\Receipt',4361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',39951.49,NULL,NULL,1,'2023-04-13 21:07:14','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5104,7768,40728,13790,3,4362,'App\\Models\\Receipt',4362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',69260.20,NULL,NULL,1,'2023-04-13 21:07:14','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5105,7768,40728,13790,3,4363,'App\\Models\\Receipt',4363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',15000.00,NULL,NULL,1,'2023-04-13 21:07:14','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5106,7768,40728,13790,3,4364,'App\\Models\\Receipt',4364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',1417660.20,NULL,NULL,1,'2023-04-13 21:07:14','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5107,7768,40728,13790,3,4365,'App\\Models\\Receipt',4365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',1887.60,NULL,NULL,1,'2023-04-13 21:07:14','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5108,7768,40728,13790,3,4366,'App\\Models\\Receipt',4366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',163895.04,NULL,NULL,1,'2023-04-13 21:07:14','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5109,7768,40728,13790,3,4367,'App\\Models\\Receipt',4367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',12432.75,NULL,NULL,1,'2023-04-13 21:07:14','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5110,7768,40728,13790,3,4368,'App\\Models\\Receipt',4368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',6140.00,NULL,NULL,1,'2023-04-13 21:07:14','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5111,7768,40728,13790,3,4369,'App\\Models\\Receipt',4369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',0.00,NULL,NULL,1,'2023-04-13 21:07:14','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5112,7768,40728,13790,3,4370,'App\\Models\\Receipt',4370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',0.00,NULL,NULL,1,'2023-04-13 21:07:14','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5113,7768,40728,13790,3,4371,'App\\Models\\Receipt',4371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',12663.06,NULL,NULL,1,'2023-04-13 21:07:14','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5114,7768,40728,13790,3,4372,'App\\Models\\Receipt',4372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',8220.21,NULL,NULL,1,'2023-04-13 21:07:14','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5115,7768,40728,13790,3,4373,'App\\Models\\Receipt',4373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',90959.06,NULL,NULL,1,'2023-04-13 21:07:14','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5116,7768,40728,13790,3,4374,'App\\Models\\Receipt',4374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',470690.00,NULL,NULL,1,'2023-04-13 21:07:14','2023-04-17 20:51:34','2023-04-17 20:51:34');
INSERT INTO `balance_libro` VALUES (5117,7768,40728,13790,3,4375,'App\\Models\\Receipt',4375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',48171.07,NULL,NULL,1,'2023-04-13 21:07:14','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5118,7768,40728,13790,3,4376,'App\\Models\\Receipt',4376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',729300.00,NULL,NULL,1,'2023-04-13 21:07:14','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5119,7768,40728,13790,3,4377,'App\\Models\\Receipt',4377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',112999.00,NULL,NULL,1,'2023-04-13 21:07:14','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5120,7768,40728,13790,3,4378,'App\\Models\\Receipt',4378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',1272.92,NULL,NULL,1,'2023-04-13 21:07:14','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5121,7768,40728,13790,3,4379,'App\\Models\\Receipt',4379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',59807.41,NULL,NULL,1,'2023-04-13 21:07:14','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5122,7768,40728,13790,3,4380,'App\\Models\\Receipt',4380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',5660.04,NULL,NULL,1,'2023-04-13 21:07:14','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5123,7768,40728,13790,3,4381,'App\\Models\\Receipt',4381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',77561.87,NULL,NULL,1,'2023-04-13 21:07:15','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5124,7768,40728,13790,3,4382,'App\\Models\\Receipt',4382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',49420.27,NULL,NULL,1,'2023-04-13 21:07:15','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5125,7768,40728,13790,3,4383,'App\\Models\\Receipt',4383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',8402849.32,NULL,NULL,1,'2023-04-13 21:07:15','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5126,7768,40728,13790,3,4384,'App\\Models\\Receipt',4384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',10097.45,NULL,NULL,1,'2023-04-13 21:07:15','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5127,7768,40728,13790,3,4385,'App\\Models\\Receipt',4385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3100.00,NULL,NULL,1,'2023-04-13 21:07:15','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5128,7768,40728,13790,3,4386,'App\\Models\\Receipt',4386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',11502.96,NULL,NULL,1,'2023-04-13 21:07:15','2023-04-13 21:09:40','2023-04-13 21:09:40'),(5129,7768,40728,13790,3,4387,'App\\Models\\Receipt',4387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',26675.13,NULL,NULL,1,'2023-04-13 21:07:15','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5130,7768,40728,13790,3,4341,'App\\Models\\Receipt',4341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',9193.42,NULL,NULL,1,'2023-04-13 21:08:44','2023-04-13 21:09:13','2023-04-13 21:09:13'),(5131,7768,40728,13790,3,4341,'App\\Models\\Receipt',4341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',9181.85,NULL,NULL,1,'2023-04-13 21:09:13','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5132,7768,40728,13790,3,4386,'App\\Models\\Receipt',4386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',9205.82,NULL,NULL,1,'2023-04-13 21:09:40','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5133,7768,40728,13790,3,4317,'App\\Models\\Receipt',4317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',8172.80,NULL,NULL,1,'2023-04-13 21:10:21','2023-04-17 20:51:33','2023-04-17 20:51:33'),(5134,7768,40728,13790,3,4327,'App\\Models\\Receipt',4327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',7827.96,NULL,NULL,1,'2023-04-13 21:10:49','2023-04-17 20:51:34','2023-04-17 20:51:34'),(5135,7797,41322,90377,3,4388,'App\\Models\\Receipt',4388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',16896.49,NULL,NULL,1,'2023-04-17 10:42:09','2023-04-17 10:42:09',NULL);
INSERT INTO `balance_libro` VALUES (5136,7797,41322,90377,3,4389,'App\\Models\\Receipt',4389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',15750.00,NULL,NULL,1,'2023-04-17 10:42:09','2023-04-17 10:42:09',NULL),(5137,7797,41322,90377,3,4390,'App\\Models\\Receipt',4390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',8962.91,NULL,NULL,1,'2023-04-17 10:42:09','2023-04-17 13:17:19','2023-04-17 13:17:19'),(5138,7797,41322,90377,3,4391,'App\\Models\\Receipt',4391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',19875.99,NULL,NULL,1,'2023-04-17 10:42:09','2023-04-17 10:42:09',NULL),(5139,7797,41322,90377,3,4392,'App\\Models\\Receipt',4392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',14103.62,NULL,NULL,1,'2023-04-17 10:42:09','2023-04-17 10:42:09',NULL),(5140,7797,41322,90377,3,4393,'App\\Models\\Receipt',4393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',13583.06,NULL,NULL,1,'2023-04-17 10:42:09','2023-04-17 10:42:09',NULL),(5141,7797,41322,90377,3,4394,'App\\Models\\Receipt',4394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',23029.52,NULL,NULL,1,'2023-04-17 10:42:09','2023-04-17 10:42:09',NULL),(5142,7797,41322,90377,3,4395,'App\\Models\\Receipt',4395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',23001.49,NULL,NULL,1,'2023-04-17 10:42:09','2023-04-17 10:42:09',NULL),(5143,7797,41322,90377,3,4396,'App\\Models\\Receipt',4396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',104480.81,NULL,NULL,1,'2023-04-17 10:42:09','2023-04-17 10:42:09',NULL),(5144,7797,41322,90377,3,4397,'App\\Models\\Receipt',4397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',28582.56,NULL,NULL,1,'2023-04-17 10:42:09','2023-04-17 10:42:09',NULL),(5145,7797,41322,90376,3,4398,'App\\Models\\Receipt',4398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',23973.69,NULL,NULL,1,'2023-04-17 12:40:02','2023-04-17 12:40:02',NULL),(5146,7797,41322,90376,3,4399,'App\\Models\\Receipt',4399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',17011.15,NULL,NULL,1,'2023-04-17 12:40:02','2023-04-17 12:40:02',NULL),(5147,7797,41322,90376,3,4400,'App\\Models\\Receipt',4400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',18838.57,NULL,NULL,1,'2023-04-17 12:40:02','2023-04-17 12:40:02',NULL),(5148,7797,41322,90376,3,4401,'App\\Models\\Receipt',4401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',15750.00,NULL,NULL,1,'2023-04-17 12:40:02','2023-04-17 12:40:02',NULL),(5149,7797,41322,90376,3,4402,'App\\Models\\Receipt',4402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',8962.91,NULL,NULL,1,'2023-04-17 12:40:02','2023-04-17 13:09:33','2023-04-17 13:09:33'),(5150,7797,41322,90376,3,4402,'App\\Models\\Receipt',4402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',8962.91,NULL,NULL,1,'2023-04-17 13:09:33','2023-04-17 13:09:33',NULL),(5151,7797,41322,90377,3,4390,'App\\Models\\Receipt',4390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',8962.91,NULL,NULL,1,'2023-04-17 13:17:19','2023-04-17 13:20:59','2023-04-17 13:20:59'),(5152,7797,41322,90377,3,4390,'App\\Models\\Receipt',4390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',8962.91,NULL,NULL,1,'2023-04-17 13:20:59','2023-04-17 13:20:59',NULL),(5153,7797,41322,90376,15,1575,'App\\Models\\PeriodLiquidation',NULL,1575,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',19049.29,NULL,NULL,1,'2023-04-17 13:29:23','2023-04-17 13:29:23',NULL),(5154,7797,41322,90376,16,1576,'App\\Models\\PeriodLiquidation',NULL,1576,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',9895.16,NULL,NULL,1,'2023-04-17 13:30:39','2023-04-17 13:30:39',NULL),(5155,7768,40728,13790,3,4403,'App\\Models\\Receipt',4403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',15730.00,NULL,NULL,1,'2023-04-17 20:55:58','2023-04-17 20:55:58',NULL);
INSERT INTO `balance_libro` VALUES (5156,7768,40728,13790,3,4404,'App\\Models\\Receipt',4404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',1417660.20,NULL,NULL,1,'2023-04-17 20:55:58','2023-04-17 20:55:58',NULL),(5157,7768,40728,13790,3,4405,'App\\Models\\Receipt',4405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',447700.00,NULL,NULL,1,'2023-04-17 20:55:58','2023-04-17 20:55:58',NULL),(5158,7768,40728,13790,3,4406,'App\\Models\\Receipt',4406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',417450.00,NULL,NULL,1,'2023-04-17 20:55:58','2023-04-17 20:55:58',NULL),(5159,7768,40728,13790,3,4407,'App\\Models\\Receipt',4407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',2100.00,NULL,NULL,1,'2023-04-17 20:55:58','2023-04-17 20:55:58',NULL),(5160,7768,40728,13790,3,4408,'App\\Models\\Receipt',4408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',173235.99,NULL,NULL,1,'2023-04-17 20:55:58','2023-04-17 20:55:58',NULL),(5161,7768,40728,13790,3,4409,'App\\Models\\Receipt',4409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',14641.00,NULL,NULL,1,'2023-04-17 20:55:58','2023-04-17 20:55:58',NULL),(5162,7768,40728,13790,3,4410,'App\\Models\\Receipt',4410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',67760.00,NULL,NULL,1,'2023-04-17 20:55:58','2023-04-17 20:55:58',NULL),(5163,7768,40728,13790,3,4411,'App\\Models\\Receipt',4411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',6898.60,NULL,NULL,1,'2023-04-17 20:55:58','2023-04-17 20:55:58',NULL),(5164,7768,40728,13790,3,4412,'App\\Models\\Receipt',4412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',11398.20,NULL,NULL,1,'2023-04-17 20:55:58','2023-04-17 20:55:58',NULL),(5165,7768,40728,13790,3,4413,'App\\Models\\Receipt',4413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',137360.28,NULL,NULL,1,'2023-04-17 20:55:58','2023-04-17 20:55:58',NULL),(5166,7768,40728,13790,3,4414,'App\\Models\\Receipt',4414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',17432.63,NULL,NULL,1,'2023-04-17 20:55:58','2023-04-17 20:55:58',NULL),(5167,7768,40728,13790,3,4415,'App\\Models\\Receipt',4415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',26002.98,NULL,NULL,1,'2023-04-17 20:55:58','2023-04-17 20:55:58',NULL),(5168,7768,40728,13790,3,4416,'App\\Models\\Receipt',4416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',10097.45,NULL,NULL,1,'2023-04-17 20:55:58','2023-04-17 20:55:58',NULL),(5169,7768,40728,13790,3,4417,'App\\Models\\Receipt',4417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',233261.08,NULL,NULL,1,'2023-04-17 20:55:58','2023-04-17 20:55:58',NULL),(5170,7768,40728,13790,3,4418,'App\\Models\\Receipt',4418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',115281.30,NULL,NULL,1,'2023-04-17 20:55:58','2023-04-17 20:55:58',NULL),(5171,7768,40728,13790,3,4419,'App\\Models\\Receipt',4419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',12663.06,NULL,NULL,1,'2023-04-17 20:55:59','2023-04-17 20:55:59',NULL),(5172,7768,40728,13790,3,4420,'App\\Models\\Receipt',4420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',729300.00,NULL,NULL,1,'2023-04-17 20:55:59','2023-04-17 20:55:59',NULL),(5173,7768,40728,13790,3,4421,'App\\Models\\Receipt',4421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',3300.01,NULL,NULL,1,'2023-04-17 20:55:59','2023-04-17 20:55:59',NULL),(5174,7768,40728,13790,3,4422,'App\\Models\\Receipt',4422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',408035.28,NULL,NULL,1,'2023-04-17 20:55:59','2023-04-17 20:55:59',NULL),(5175,7768,40728,13790,3,4423,'App\\Models\\Receipt',4423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',4889.39,NULL,NULL,1,'2023-04-17 20:55:59','2023-04-17 20:55:59',NULL);
INSERT INTO `balance_libro` VALUES (5176,7768,40728,13790,3,4424,'App\\Models\\Receipt',4424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',4994.42,NULL,NULL,1,'2023-04-17 20:55:59','2023-04-17 20:55:59',NULL),(5177,7768,40728,13790,3,4425,'App\\Models\\Receipt',4425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',18654.05,NULL,NULL,1,'2023-04-17 20:55:59','2023-04-17 20:55:59',NULL),(5178,7768,40728,13790,3,4426,'App\\Models\\Receipt',4426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',39951.49,NULL,NULL,1,'2023-04-17 20:55:59','2023-04-17 20:55:59',NULL),(5179,7768,40728,13790,3,4427,'App\\Models\\Receipt',4427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',5832.89,NULL,NULL,1,'2023-04-17 20:55:59','2023-04-17 20:55:59',NULL),(5180,7768,40728,13790,3,4428,'App\\Models\\Receipt',4428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',2300.20,NULL,NULL,1,'2023-04-17 20:55:59','2023-04-17 20:55:59',NULL),(5181,7768,40728,13790,3,4429,'App\\Models\\Receipt',4429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',3306.34,NULL,NULL,1,'2023-04-17 20:55:59','2023-04-17 20:55:59',NULL),(5182,7768,40728,13790,3,4430,'App\\Models\\Receipt',4430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',171617.36,NULL,NULL,1,'2023-04-17 20:55:59','2023-04-17 21:18:43','2023-04-17 21:18:43'),(5183,7768,40728,13790,3,4431,'App\\Models\\Receipt',4431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',4004.99,NULL,NULL,1,'2023-04-17 20:55:59','2023-04-17 20:55:59',NULL),(5184,7768,40728,13790,3,4432,'App\\Models\\Receipt',4432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',106480.00,NULL,NULL,1,'2023-04-17 20:55:59','2023-04-17 20:55:59',NULL),(5185,7768,40728,13790,3,4433,'App\\Models\\Receipt',4433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',26862.00,NULL,NULL,1,'2023-04-17 20:55:59','2023-04-17 20:55:59',NULL),(5186,7768,40728,13790,3,4434,'App\\Models\\Receipt',4434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',2859.23,NULL,NULL,1,'2023-04-17 20:55:59','2023-04-17 20:55:59',NULL),(5187,7768,40728,13790,3,4435,'App\\Models\\Receipt',4435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',7188.62,NULL,NULL,1,'2023-04-17 20:55:59','2023-04-17 20:55:59',NULL),(5188,7768,40728,13790,3,4436,'App\\Models\\Receipt',4436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',4975.17,NULL,NULL,1,'2023-04-17 20:55:59','2023-04-17 20:55:59',NULL),(5189,7768,40728,13790,3,4437,'App\\Models\\Receipt',4437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',4488.01,NULL,NULL,1,'2023-04-17 20:55:59','2023-04-17 20:55:59',NULL),(5190,7768,40728,13790,3,4438,'App\\Models\\Receipt',4438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',7809.05,NULL,NULL,1,'2023-04-17 20:55:59','2023-04-17 20:55:59',NULL),(5191,7768,40728,13790,3,4439,'App\\Models\\Receipt',4439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',2455.48,NULL,NULL,1,'2023-04-17 20:55:59','2023-04-17 20:55:59',NULL),(5192,7768,40728,13790,3,4440,'App\\Models\\Receipt',4440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',21175.63,NULL,NULL,1,'2023-04-17 20:55:59','2023-04-17 20:55:59',NULL),(5193,7768,40728,13790,3,4441,'App\\Models\\Receipt',4441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',2509.29,NULL,NULL,1,'2023-04-17 20:56:00','2023-04-17 20:56:00',NULL),(5194,7768,40728,13790,3,4442,'App\\Models\\Receipt',4442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',15273.81,NULL,NULL,1,'2023-04-17 20:56:00','2023-04-17 20:56:00',NULL),(5195,7768,40728,13790,3,4443,'App\\Models\\Receipt',4443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',7262.54,NULL,NULL,1,'2023-04-17 20:56:00','2023-04-17 20:56:00',NULL);
INSERT INTO `balance_libro` VALUES (5196,7768,40728,13790,3,4444,'App\\Models\\Receipt',4444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',14312.61,NULL,NULL,1,'2023-04-17 20:56:00','2023-04-17 20:56:00',NULL),(5197,7768,40728,13790,3,4445,'App\\Models\\Receipt',4445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',5077.52,NULL,NULL,1,'2023-04-17 20:56:00','2023-04-17 20:56:00',NULL),(5198,7768,40728,13790,3,4446,'App\\Models\\Receipt',4446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',9535.99,NULL,NULL,1,'2023-04-17 20:56:00','2023-04-17 20:56:00',NULL),(5199,7768,40728,13790,3,4447,'App\\Models\\Receipt',4447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',19508.61,NULL,NULL,1,'2023-04-17 20:56:00','2023-04-17 20:56:00',NULL),(5200,7768,40728,13790,3,4448,'App\\Models\\Receipt',4448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',1887.60,NULL,NULL,1,'2023-04-17 20:56:00','2023-04-17 20:56:00',NULL),(5201,7768,40728,13790,3,4449,'App\\Models\\Receipt',4449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',8220.21,NULL,NULL,1,'2023-04-17 20:56:00','2023-04-17 20:56:00',NULL),(5202,7768,40728,13790,3,4450,'App\\Models\\Receipt',4450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',48171.07,NULL,NULL,1,'2023-04-17 20:56:00','2023-04-17 20:56:00',NULL),(5203,7768,40728,13790,3,4451,'App\\Models\\Receipt',4451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',1272.92,NULL,NULL,1,'2023-04-17 20:56:00','2023-04-17 20:56:00',NULL),(5204,7768,40728,13790,3,4452,'App\\Models\\Receipt',4452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',8705.57,NULL,NULL,1,'2023-04-17 20:56:00','2023-04-17 20:56:00',NULL),(5205,7768,40728,13790,3,4453,'App\\Models\\Receipt',4453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',30700.00,NULL,NULL,1,'2023-04-17 20:56:00','2023-04-17 20:56:00',NULL),(5206,7768,40728,13790,3,4454,'App\\Models\\Receipt',4454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',83775.94,NULL,NULL,1,'2023-04-17 20:56:00','2023-04-17 20:56:00',NULL),(5207,7768,40728,13790,3,4455,'App\\Models\\Receipt',4455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',1478649.03,NULL,NULL,1,'2023-04-17 20:56:00','2023-04-17 20:56:00',NULL),(5208,7768,40728,13790,3,4456,'App\\Models\\Receipt',4456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',8402849.32,NULL,NULL,1,'2023-04-17 20:56:00','2023-04-17 20:56:00',NULL),(5209,7768,40728,13790,3,4457,'App\\Models\\Receipt',4457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',7876.00,NULL,NULL,1,'2023-04-17 20:56:00','2023-04-17 20:56:00',NULL),(5210,7768,40728,13790,3,4458,'App\\Models\\Receipt',4458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',25345.91,NULL,NULL,1,'2023-04-17 20:56:00','2023-04-17 20:56:00',NULL),(5211,7768,40728,13790,3,4459,'App\\Models\\Receipt',4459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',12500.51,NULL,NULL,1,'2023-04-17 20:56:00','2023-04-17 20:56:00',NULL),(5212,7768,40728,13790,3,4460,'App\\Models\\Receipt',4460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',20000.09,NULL,NULL,1,'2023-04-17 20:56:00','2023-04-17 20:56:00',NULL),(5213,7768,40728,13790,3,4461,'App\\Models\\Receipt',4461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',213730.10,NULL,NULL,1,'2023-04-17 20:56:00','2023-04-17 20:56:00',NULL),(5214,7768,40728,13790,3,4462,'App\\Models\\Receipt',4462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',660.01,NULL,NULL,1,'2023-04-17 20:56:00','2023-04-17 20:56:00',NULL),(5215,7768,40728,13790,3,4463,'App\\Models\\Receipt',4463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',11000.00,NULL,NULL,1,'2023-04-17 20:56:00','2023-04-17 20:56:00',NULL),(5216,7768,40728,13790,3,4464,'App\\Models\\Receipt',4464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',6140.00,NULL,NULL,1,'2023-04-17 20:56:00','2023-04-17 20:56:00',NULL);
INSERT INTO `balance_libro` VALUES (5217,7768,40728,13790,3,4465,'App\\Models\\Receipt',4465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',5660.02,NULL,NULL,1,'2023-04-17 20:56:01','2023-04-17 20:56:01',NULL),(5218,7768,40728,13790,3,4466,'App\\Models\\Receipt',4466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',12432.75,NULL,NULL,1,'2023-04-17 20:56:01','2023-04-17 20:56:01',NULL),(5219,7768,40728,13790,3,4467,'App\\Models\\Receipt',4467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',90959.06,NULL,NULL,1,'2023-04-17 20:56:01','2023-04-17 20:56:01',NULL),(5220,7768,40728,13790,3,4468,'App\\Models\\Receipt',4468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',59807.41,NULL,NULL,1,'2023-04-17 20:56:01','2023-04-17 20:56:01',NULL),(5221,7768,40728,13790,3,4469,'App\\Models\\Receipt',4469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',49420.27,NULL,NULL,1,'2023-04-17 20:56:01','2023-04-17 20:56:01',NULL),(5222,7768,40728,13790,3,4470,'App\\Models\\Receipt',4470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',26675.13,NULL,NULL,1,'2023-04-17 20:56:01','2023-04-17 20:56:01',NULL),(5223,7768,40728,13790,3,4471,'App\\Models\\Receipt',4471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',9181.85,NULL,NULL,1,'2023-04-17 20:56:01','2023-04-17 20:56:01',NULL),(5224,7768,40728,13790,3,4472,'App\\Models\\Receipt',4472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',9205.86,NULL,NULL,1,'2023-04-17 20:56:01','2023-04-17 20:56:01',NULL),(5225,7768,40728,13790,3,4473,'App\\Models\\Receipt',4473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',2689.35,NULL,NULL,1,'2023-04-17 20:56:01','2023-04-17 20:56:01',NULL),(5226,7768,40728,13790,3,4474,'App\\Models\\Receipt',4474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',5552.70,NULL,NULL,1,'2023-04-17 20:56:01','2023-04-17 20:56:01',NULL),(5227,7768,40728,13790,3,4475,'App\\Models\\Receipt',4475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',7138.41,NULL,NULL,1,'2023-04-17 20:56:01','2023-04-17 20:56:01',NULL),(5228,7768,40728,13790,3,4476,'App\\Models\\Receipt',4476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',3930.95,NULL,NULL,1,'2023-04-17 20:56:01','2023-04-17 20:56:01',NULL),(5229,7768,40728,13790,3,4477,'App\\Models\\Receipt',4477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',3640.02,NULL,NULL,1,'2023-04-17 20:56:01','2023-04-17 20:56:01',NULL),(5230,7768,40728,13790,3,4478,'App\\Models\\Receipt',4478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',3094.07,NULL,NULL,1,'2023-04-17 20:56:01','2023-04-17 20:56:01',NULL),(5231,7768,40728,13790,3,4479,'App\\Models\\Receipt',4479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',937.67,NULL,NULL,1,'2023-04-17 20:56:01','2023-04-17 20:56:01',NULL),(5232,7768,40728,13790,3,4480,'App\\Models\\Receipt',4480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',6140.00,NULL,NULL,1,'2023-04-17 20:56:01','2023-04-17 20:56:01',NULL),(5233,7768,40728,13790,3,4481,'App\\Models\\Receipt',4481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',163350.00,NULL,NULL,1,'2023-04-17 20:56:01','2023-04-17 20:56:01',NULL),(5234,7768,40728,13790,3,4482,'App\\Models\\Receipt',4482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',60500.00,NULL,NULL,1,'2023-04-17 20:56:01','2023-04-17 20:56:01',NULL),(5235,7768,40728,13790,3,4483,'App\\Models\\Receipt',4483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',833855.78,NULL,NULL,1,'2023-04-17 20:56:01','2023-04-17 20:56:01',NULL),(5236,7768,40728,13790,3,4484,'App\\Models\\Receipt',4484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',442.62,NULL,NULL,1,'2023-04-17 20:56:01','2023-04-17 20:56:01',NULL),(5237,7768,40728,13790,3,4485,'App\\Models\\Receipt',4485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',2529.47,NULL,NULL,1,'2023-04-17 20:56:01','2023-04-17 20:56:01',NULL);
INSERT INTO `balance_libro` VALUES (5238,7768,40728,13790,3,4486,'App\\Models\\Receipt',4486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',4710.00,NULL,NULL,1,'2023-04-17 20:56:01','2023-04-17 20:56:01',NULL),(5239,7768,40728,13790,3,4487,'App\\Models\\Receipt',4487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',15910.76,NULL,NULL,1,'2023-04-17 20:56:02','2023-04-17 20:56:02',NULL),(5240,7768,40728,13790,3,4488,'App\\Models\\Receipt',4488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',7440.29,NULL,NULL,1,'2023-04-17 20:56:02','2023-04-17 20:56:02',NULL),(5241,7768,40728,13790,3,4489,'App\\Models\\Receipt',4489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',69260.02,NULL,NULL,1,'2023-04-17 20:56:02','2023-04-17 20:56:02',NULL),(5242,7768,40728,13790,3,4490,'App\\Models\\Receipt',4490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',3860.55,NULL,NULL,1,'2023-04-17 20:56:02','2023-04-17 20:56:02',NULL),(5243,7768,40728,13790,3,4491,'App\\Models\\Receipt',4491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',5000.00,NULL,NULL,1,'2023-04-17 20:56:02','2023-04-17 20:56:02',NULL),(5244,7768,40728,13790,3,4492,'App\\Models\\Receipt',4492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',77561.87,NULL,NULL,1,'2023-04-17 20:56:02','2023-04-17 20:56:02',NULL),(5245,7768,40728,13790,3,4493,'App\\Models\\Receipt',4493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',140225.91,NULL,NULL,1,'2023-04-17 20:56:02','2023-04-17 20:56:02',NULL),(5246,7768,40728,13790,3,4494,'App\\Models\\Receipt',4494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',39154.81,NULL,NULL,1,'2023-04-17 20:56:02','2023-04-17 20:56:02',NULL),(5247,7768,40728,13790,3,4495,'App\\Models\\Receipt',4495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',61999.00,NULL,NULL,1,'2023-04-17 20:56:02','2023-04-17 20:56:02',NULL),(5248,7768,40728,13790,3,4496,'App\\Models\\Receipt',4496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',112999.00,NULL,NULL,1,'2023-04-17 20:56:02','2023-04-17 20:56:02',NULL),(5249,7768,40728,13790,3,4497,'App\\Models\\Receipt',4497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',2896.08,NULL,NULL,1,'2023-04-17 20:56:02','2023-04-17 20:56:02',NULL),(5250,7768,40728,13790,3,4498,'App\\Models\\Receipt',4498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',1500.20,NULL,NULL,1,'2023-04-17 20:56:02','2023-04-17 20:56:02',NULL),(5251,7768,40728,13790,3,4499,'App\\Models\\Receipt',4499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',140225.91,NULL,NULL,1,'2023-04-17 20:56:02','2023-04-17 20:56:02',NULL),(5252,7768,40728,13790,3,4500,'App\\Models\\Receipt',4500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',2815.48,NULL,NULL,1,'2023-04-17 20:56:02','2023-04-17 20:56:02',NULL),(5253,7768,40728,13790,3,4501,'App\\Models\\Receipt',4501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',40000.00,NULL,NULL,1,'2023-04-17 20:56:02','2023-04-17 20:56:02',NULL),(5254,7768,40728,13790,3,4502,'App\\Models\\Receipt',4502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',12500.00,NULL,NULL,1,'2023-04-17 20:56:02','2023-04-17 20:56:02',NULL),(5255,7768,40728,13790,3,4503,'App\\Models\\Receipt',4503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',1500.00,NULL,NULL,1,'2023-04-17 20:56:02','2023-04-17 20:56:02',NULL),(5256,7768,40728,13790,3,4504,'App\\Models\\Receipt',4504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',15000.00,NULL,NULL,1,'2023-04-17 20:56:02','2023-04-17 20:56:02',NULL),(5257,7768,40728,13790,3,4505,'App\\Models\\Receipt',4505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',11900.00,NULL,NULL,1,'2023-04-17 20:56:02','2023-04-17 20:56:02',NULL),(5258,7768,40728,13790,3,4506,'App\\Models\\Receipt',4506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',22000.00,NULL,NULL,1,'2023-04-17 20:56:02','2023-04-17 20:56:02',NULL);
INSERT INTO `balance_libro` VALUES (5259,7768,40728,13790,3,4507,'App\\Models\\Receipt',4507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',3500.00,NULL,NULL,1,'2023-04-17 20:56:02','2023-04-17 20:56:02',NULL),(5260,7768,40728,13790,3,4508,'App\\Models\\Receipt',4508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',3100.00,NULL,NULL,1,'2023-04-17 20:56:02','2023-04-17 20:56:02',NULL),(5261,7768,40728,13790,3,4509,'App\\Models\\Receipt',4509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',8282.82,NULL,NULL,1,'2023-04-17 20:56:02','2023-04-17 20:56:02',NULL),(5262,7768,40728,13790,3,4510,'App\\Models\\Receipt',4510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',8172.80,NULL,NULL,1,'2023-04-17 20:56:03','2023-04-17 20:56:03',NULL),(5263,7768,40728,13790,3,4511,'App\\Models\\Receipt',4511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',7827.92,NULL,NULL,1,'2023-04-17 20:56:03','2023-04-17 20:56:03',NULL),(5264,7768,40728,13790,3,4512,'App\\Models\\Receipt',4512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',6231.91,NULL,NULL,1,'2023-04-17 20:56:03','2023-04-17 20:56:03',NULL),(5265,7768,40728,13790,3,4513,'App\\Models\\Receipt',4513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',6157.97,NULL,NULL,1,'2023-04-17 20:56:03','2023-04-17 20:56:03',NULL),(5266,7768,40728,13790,3,4514,'App\\Models\\Receipt',4514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',1000.00,NULL,NULL,1,'2023-04-17 20:56:03','2023-04-17 20:56:03',NULL),(5267,7768,40728,13790,3,4515,'App\\Models\\Receipt',4515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',7460.69,NULL,NULL,1,'2023-04-17 20:56:03','2023-04-17 20:56:03',NULL),(5268,7768,40728,13790,3,4516,'App\\Models\\Receipt',4516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',81693.58,NULL,NULL,1,'2023-04-17 20:56:03','2023-04-17 20:56:03',NULL),(5269,7768,40728,13790,3,4517,'App\\Models\\Receipt',4517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',186750.57,NULL,NULL,1,'2023-04-17 20:56:03','2023-04-17 20:56:03',NULL),(5270,7768,40728,13790,3,4518,'App\\Models\\Receipt',4518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',2374.36,NULL,NULL,1,'2023-04-17 20:56:03','2023-04-17 20:56:03',NULL),(5271,7768,40728,13790,3,4519,'App\\Models\\Receipt',4519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',470690.00,NULL,NULL,1,'2023-04-17 20:56:03','2023-04-17 20:56:03',NULL),(5272,7768,40728,13790,2,2917,'App\\Models\\Receipt',2917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',9623235.52,NULL,NULL,1,'2023-04-17 21:06:54','2023-04-17 21:07:53','2023-04-17 21:07:53'),(5273,7768,40728,13790,2,2917,'App\\Models\\Receipt',2917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',9623235.70,NULL,NULL,1,'2023-04-17 21:07:53','2023-04-17 21:07:53',NULL),(5274,7768,40728,13790,3,4430,'App\\Models\\Receipt',4430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',171617.34,NULL,NULL,1,'2023-04-17 21:18:43','2023-04-17 21:18:43',NULL),(5275,7768,40728,13790,15,1590,'App\\Models\\PeriodLiquidation',NULL,1590,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',4053953.33,NULL,NULL,1,'2023-04-17 21:29:33','2023-04-17 21:29:33',NULL),(5276,7797,41298,88864,15,1421,'App\\Models\\PeriodLiquidation',NULL,1421,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',15095.16,NULL,NULL,1,'2023-04-18 11:21:48','2023-04-18 11:21:48',NULL),(5277,7797,41298,88865,3,4520,'App\\Models\\Receipt',4520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',8800.59,NULL,NULL,1,'2023-04-18 13:28:16','2023-04-18 13:28:16',NULL),(5278,7797,41298,88865,3,4521,'App\\Models\\Receipt',4521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',8348.33,NULL,NULL,1,'2023-04-18 13:28:16','2023-04-18 13:28:16',NULL);
INSERT INTO `balance_libro` VALUES (5279,7797,41298,88865,3,4522,'App\\Models\\Receipt',4522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',86152.00,NULL,NULL,1,'2023-04-18 13:28:16','2023-04-18 13:28:16',NULL),(5280,7797,41298,88865,3,4523,'App\\Models\\Receipt',4523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',156090.00,NULL,NULL,1,'2023-04-18 13:28:16','2023-04-18 13:28:16',NULL),(5281,7797,41298,88865,3,2937,'App\\Models\\Receipt',2937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',19145.91,NULL,NULL,1,'2023-04-18 13:32:04','2023-04-18 13:32:04',NULL),(5282,7797,41298,88865,3,2934,'App\\Models\\Receipt',2934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',9789.38,NULL,NULL,1,'2023-04-18 13:33:55','2023-04-18 13:33:55',NULL),(5283,7797,41298,88865,3,2933,'App\\Models\\Receipt',2933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',9076.28,NULL,NULL,1,'2023-04-18 13:34:33','2023-04-18 13:34:33',NULL),(5284,7768,40728,13778,3,540,'App\\Models\\Receipt',540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-26','2022-06-26',5535.01,NULL,NULL,1,'2023-04-25 19:23:06','2023-04-25 19:23:06',NULL),(5285,7768,40728,13779,3,342,'App\\Models\\Receipt',342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-17','2022-07-17',6069.81,NULL,NULL,1,'2023-04-25 19:47:40','2023-04-25 19:47:40',NULL),(5286,7768,40728,13791,2,4524,'App\\Models\\Receipt',4524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',3553229.85,NULL,NULL,1,'2023-04-25 21:10:37','2023-04-25 21:10:37',NULL),(5287,7768,40728,13791,2,4525,'App\\Models\\Receipt',4525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',484000.00,NULL,NULL,1,'2023-04-25 21:10:37','2023-04-25 21:10:37',NULL),(5288,7768,40728,13791,2,4526,'App\\Models\\Receipt',4526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',1681930.01,NULL,NULL,1,'2023-04-25 21:10:37','2023-04-25 21:10:37',NULL),(5289,7768,40728,13791,2,4527,'App\\Models\\Receipt',4527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',3611545.85,NULL,NULL,1,'2023-04-25 21:10:37','2023-04-25 21:10:37',NULL),(5290,7768,40728,13791,2,4528,'App\\Models\\Receipt',4528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',2528118.34,NULL,NULL,1,'2023-04-25 21:10:37','2023-04-25 21:10:37',NULL),(5291,7768,40728,13791,2,4529,'App\\Models\\Receipt',4529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',13016.94,NULL,NULL,1,'2023-04-25 21:10:37','2023-04-25 21:10:37',NULL),(5292,7768,40728,13791,2,4530,'App\\Models\\Receipt',4530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',29847.07,NULL,NULL,1,'2023-04-25 21:10:37','2023-04-25 21:10:37',NULL),(5293,7768,40728,13791,3,4531,'App\\Models\\Receipt',4531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',10999.99,NULL,NULL,1,'2023-04-25 21:10:47','2023-04-25 21:10:47',NULL),(5294,7768,40728,13791,3,4532,'App\\Models\\Receipt',4532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',4400.04,NULL,NULL,1,'2023-04-25 21:10:47','2023-04-25 21:10:47',NULL),(5295,7768,40728,13791,3,4533,'App\\Models\\Receipt',4533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',2247.92,NULL,NULL,1,'2023-04-25 21:10:47','2023-04-25 21:10:47',NULL),(5296,7768,40728,13791,3,4534,'App\\Models\\Receipt',4534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',82328.40,NULL,NULL,1,'2023-04-25 21:10:48','2023-04-25 21:10:48',NULL),(5297,7768,40728,13791,3,4535,'App\\Models\\Receipt',4535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',17545.00,NULL,NULL,1,'2023-04-25 21:10:48','2023-04-25 21:10:48',NULL),(5298,7768,40728,13791,3,4536,'App\\Models\\Receipt',4536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',22000.00,NULL,NULL,1,'2023-04-25 21:10:48','2023-04-25 21:10:48',NULL),(5299,7768,40728,13791,3,4537,'App\\Models\\Receipt',4537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',9500.00,NULL,NULL,1,'2023-04-25 21:10:48','2023-04-25 21:10:48',NULL);
INSERT INTO `balance_libro` VALUES (5300,7768,40728,13791,3,4538,'App\\Models\\Receipt',4538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',292336.00,NULL,NULL,1,'2023-04-25 21:10:48','2023-04-25 21:10:48',NULL),(5301,7768,40728,13791,3,4539,'App\\Models\\Receipt',4539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',47897.85,NULL,NULL,1,'2023-04-25 21:10:48','2023-04-25 21:10:48',NULL),(5302,7768,40728,13791,3,4540,'App\\Models\\Receipt',4540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',10000.00,NULL,NULL,1,'2023-04-25 21:10:48','2023-04-25 21:10:48',NULL),(5303,7768,40728,13791,3,4541,'App\\Models\\Receipt',4541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',251680.00,NULL,NULL,1,'2023-04-25 21:10:48','2023-04-25 21:10:48',NULL),(5304,7768,40728,13791,3,4542,'App\\Models\\Receipt',4542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',4000.00,NULL,NULL,1,'2023-04-25 21:10:48','2023-04-25 21:10:48',NULL),(5305,7768,40728,13791,3,4543,'App\\Models\\Receipt',4543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',13507.98,NULL,NULL,1,'2023-04-25 21:10:48','2023-04-25 21:10:48',NULL),(5306,7768,40728,13791,3,4544,'App\\Models\\Receipt',4544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',53784.83,NULL,NULL,1,'2023-04-25 21:10:48','2023-04-25 21:10:48',NULL),(5307,7768,40728,13791,3,4545,'App\\Models\\Receipt',4545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',22848.41,NULL,NULL,1,'2023-04-25 21:10:48','2023-04-25 21:10:48',NULL),(5308,7768,40728,13791,3,4546,'App\\Models\\Receipt',4546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',6700.00,NULL,NULL,1,'2023-04-25 21:10:48','2023-04-25 21:10:48',NULL),(5309,7768,40728,13791,3,4547,'App\\Models\\Receipt',4547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',4008.58,NULL,NULL,1,'2023-04-25 21:10:48','2023-04-25 21:10:48',NULL),(5310,7768,40728,13791,3,4548,'App\\Models\\Receipt',4548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',1792.59,NULL,NULL,1,'2023-04-25 21:10:48','2023-04-25 21:10:48',NULL),(5311,7768,40728,13791,3,4549,'App\\Models\\Receipt',4549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',185810.09,NULL,NULL,1,'2023-04-25 21:10:48','2023-04-25 21:10:48',NULL),(5312,7768,40728,13791,3,4550,'App\\Models\\Receipt',4550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',8639.40,NULL,NULL,1,'2023-04-25 21:10:48','2023-04-25 21:10:48',NULL),(5313,7768,40728,13791,3,4551,'App\\Models\\Receipt',4551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',2080.07,NULL,NULL,1,'2023-04-25 21:10:48','2023-04-25 21:10:48',NULL),(5314,7768,40728,13791,3,4552,'App\\Models\\Receipt',4552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',50820.00,NULL,NULL,1,'2023-04-25 21:10:48','2023-04-25 21:10:48',NULL),(5315,7768,40728,13791,3,4553,'App\\Models\\Receipt',4553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',1200.00,NULL,NULL,1,'2023-04-25 21:10:48','2023-04-25 21:10:48',NULL),(5316,7768,40728,13791,3,4554,'App\\Models\\Receipt',4554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',220220.00,NULL,NULL,1,'2023-04-25 21:10:48','2023-04-25 21:10:48',NULL),(5317,7768,40728,13791,3,4555,'App\\Models\\Receipt',4555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',4146.91,NULL,NULL,1,'2023-04-25 21:10:48','2023-04-25 21:10:48',NULL),(5318,7768,40728,13791,3,4556,'App\\Models\\Receipt',4556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',1050.00,NULL,NULL,1,'2023-04-25 21:10:48','2023-04-25 21:10:48',NULL),(5319,7768,40728,13791,3,4557,'App\\Models\\Receipt',4557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',1954.19,NULL,NULL,1,'2023-04-25 21:10:48','2023-04-25 21:10:48',NULL),(5320,7768,40728,13791,3,4558,'App\\Models\\Receipt',4558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',22935.55,NULL,NULL,1,'2023-04-25 21:10:49','2023-04-25 21:10:49',NULL);
INSERT INTO `balance_libro` VALUES (5321,7768,40728,13791,3,4559,'App\\Models\\Receipt',4559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',2500.00,NULL,NULL,1,'2023-04-25 21:10:49','2023-04-25 21:10:49',NULL),(5322,7768,40728,13791,3,4560,'App\\Models\\Receipt',4560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',2571.01,NULL,NULL,1,'2023-04-25 21:10:49','2023-04-25 21:10:49',NULL),(5323,7768,40728,13791,3,4561,'App\\Models\\Receipt',4561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',2178.00,NULL,NULL,1,'2023-04-25 21:10:49','2023-04-25 21:10:49',NULL),(5324,7768,40728,13791,3,4562,'App\\Models\\Receipt',4562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',9452.82,NULL,NULL,1,'2023-04-25 21:10:49','2023-04-25 21:10:49',NULL),(5325,7768,40728,13791,3,4563,'App\\Models\\Receipt',4563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',4971.76,NULL,NULL,1,'2023-04-25 21:10:49','2023-04-25 21:10:49',NULL),(5326,7768,40728,13791,3,4564,'App\\Models\\Receipt',4564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',3321.66,NULL,NULL,1,'2023-04-25 21:10:49','2023-04-25 21:10:49',NULL),(5327,7768,40728,13791,3,4565,'App\\Models\\Receipt',4565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',5087.81,NULL,NULL,1,'2023-04-25 21:10:49','2023-04-25 21:10:49',NULL),(5328,7768,40728,13791,3,4566,'App\\Models\\Receipt',4566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',18360.14,NULL,NULL,1,'2023-04-25 21:10:49','2023-04-25 21:10:49',NULL),(5329,7768,40728,13791,3,4567,'App\\Models\\Receipt',4567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',135827.92,NULL,NULL,1,'2023-04-25 21:10:49','2023-04-25 21:10:49',NULL),(5330,7768,40728,13791,3,4568,'App\\Models\\Receipt',4568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',55475.62,NULL,NULL,1,'2023-04-25 21:10:49','2023-04-25 21:10:49',NULL),(5331,7768,40728,13791,3,4569,'App\\Models\\Receipt',4569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',4774.22,NULL,NULL,1,'2023-04-25 21:10:49','2023-04-25 21:10:49',NULL),(5332,7768,40728,13791,3,4570,'App\\Models\\Receipt',4570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',64080.72,NULL,NULL,1,'2023-04-25 21:10:49','2023-04-25 21:10:49',NULL),(5333,7768,40728,13791,9,4571,'App\\Models\\Receipt',4571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',61.61,NULL,NULL,1,'2023-04-25 21:15:52','2023-04-25 21:15:52',NULL),(5334,7768,40728,13791,9,4572,'App\\Models\\Receipt',4572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',121.09,NULL,NULL,1,'2023-04-25 21:16:34','2023-04-25 21:16:34',NULL),(5335,7768,40728,13791,9,4573,'App\\Models\\Receipt',4573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',249.53,NULL,NULL,1,'2023-04-25 21:16:48','2023-04-25 21:16:48',NULL),(5336,7768,40728,13791,9,4574,'App\\Models\\Receipt',4574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',206.57,NULL,NULL,1,'2023-04-25 21:17:03','2023-04-25 21:17:03',NULL),(5337,7768,40728,13791,9,4575,'App\\Models\\Receipt',4575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',163.60,NULL,NULL,1,'2023-04-25 21:17:15','2023-04-25 21:17:15',NULL),(5338,7768,40728,13791,9,4576,'App\\Models\\Receipt',4576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',124.89,NULL,NULL,1,'2023-04-25 21:17:28','2023-04-25 21:17:28',NULL),(5339,7768,40728,13791,9,4577,'App\\Models\\Receipt',4577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',95.06,NULL,NULL,1,'2023-04-25 21:17:43','2023-04-25 21:17:43',NULL),(5340,7768,40728,13791,9,4578,'App\\Models\\Receipt',4578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',6224.18,NULL,NULL,1,'2023-04-25 21:19:47','2023-04-25 21:19:47',NULL),(5341,7768,40728,13791,9,4579,'App\\Models\\Receipt',4579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',62.23,NULL,NULL,1,'2023-04-25 21:20:02','2023-04-25 21:20:02',NULL);
INSERT INTO `balance_libro` VALUES (5342,7768,40728,13791,9,4580,'App\\Models\\Receipt',4580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',49621.10,NULL,NULL,1,'2023-04-25 21:20:28','2023-04-25 21:20:28',NULL),(5343,7768,40728,13791,9,4581,'App\\Models\\Receipt',4581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',14713.23,NULL,NULL,1,'2023-04-25 21:20:40','2023-04-25 21:20:40',NULL),(5344,7768,40728,13791,9,4582,'App\\Models\\Receipt',4582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',16533.75,NULL,NULL,1,'2023-04-25 21:20:55','2023-04-25 21:20:55',NULL),(5345,7768,40728,13791,9,4583,'App\\Models\\Receipt',4583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',1820.52,NULL,NULL,1,'2023-04-25 21:21:06','2023-04-25 21:21:06',NULL),(5346,7768,40728,13791,9,4584,'App\\Models\\Receipt',4584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',16533.75,NULL,NULL,1,'2023-04-25 21:21:22','2023-04-25 21:21:22',NULL),(5347,7768,40728,13791,9,4585,'App\\Models\\Receipt',4585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',16533.75,NULL,NULL,1,'2023-04-25 21:21:33','2023-04-25 21:21:33',NULL),(5348,7768,40728,13791,9,4586,'App\\Models\\Receipt',4586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',16533.75,NULL,NULL,1,'2023-04-25 21:21:44','2023-04-25 21:21:44',NULL),(5349,7768,40728,13791,9,4587,'App\\Models\\Receipt',4587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',16533.75,NULL,NULL,1,'2023-04-25 21:21:56','2023-04-25 21:21:56',NULL),(5350,7768,40728,13791,9,4588,'App\\Models\\Receipt',4588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',16533.75,NULL,NULL,1,'2023-04-25 21:22:05','2023-04-25 21:22:05',NULL),(5351,7797,41298,88866,2,4589,'App\\Models\\Receipt',4589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',24200.00,NULL,NULL,1,'2023-04-26 15:05:42','2023-04-26 15:05:42',NULL),(5352,7797,41298,88866,2,4590,'App\\Models\\Receipt',4590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',217800.00,NULL,NULL,1,'2023-04-26 15:05:42','2023-04-26 15:05:42',NULL),(5353,7797,41298,88866,2,4591,'App\\Models\\Receipt',4591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',191119.00,NULL,NULL,1,'2023-04-26 15:05:42','2023-04-26 15:05:42',NULL),(5354,7797,41298,88866,2,4592,'App\\Models\\Receipt',4592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',54450.00,NULL,NULL,1,'2023-04-26 15:05:42','2023-04-26 15:05:42',NULL),(5355,7797,41298,88866,3,4593,'App\\Models\\Receipt',4593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',33200.00,NULL,NULL,1,'2023-04-26 15:12:05','2023-04-26 15:12:05',NULL),(5356,7797,41298,88866,3,4594,'App\\Models\\Receipt',4594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',18900.00,NULL,NULL,1,'2023-04-26 15:12:05','2023-04-26 15:12:05',NULL),(5357,7797,41298,88866,3,4595,'App\\Models\\Receipt',4595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',33700.00,NULL,NULL,1,'2023-04-26 15:12:05','2023-04-26 15:12:05',NULL),(5358,7797,41298,88866,3,4596,'App\\Models\\Receipt',4596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',9400.89,NULL,NULL,1,'2023-04-26 15:12:05','2023-04-26 15:12:05',NULL),(5359,7797,41298,88866,3,4597,'App\\Models\\Receipt',4597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',10572.19,NULL,NULL,1,'2023-04-26 15:12:05','2023-04-26 15:12:05',NULL),(5360,7797,41322,90378,2,4598,'App\\Models\\Receipt',4598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',641068.81,NULL,NULL,1,'2023-04-26 15:18:44','2023-04-26 15:18:44',NULL),(5361,7797,41322,90378,2,4599,'App\\Models\\Receipt',4599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',641068.81,NULL,NULL,1,'2023-04-26 15:18:44','2023-04-26 15:18:44',NULL),(5362,7797,41322,90378,3,4600,'App\\Models\\Receipt',4600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',15750.00,NULL,NULL,1,'2023-04-26 15:25:59','2023-04-26 15:25:59',NULL);
INSERT INTO `balance_libro` VALUES (5363,7797,41322,90378,3,4601,'App\\Models\\Receipt',4601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',4900.00,NULL,NULL,1,'2023-04-26 15:25:59','2023-04-26 15:25:59',NULL),(5364,7797,41322,90378,3,4602,'App\\Models\\Receipt',4602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',9927.29,NULL,NULL,1,'2023-04-26 15:25:59','2023-04-26 15:25:59',NULL),(5365,7797,41322,90378,3,4603,'App\\Models\\Receipt',4603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',1625.00,NULL,NULL,1,'2023-04-26 15:25:59','2023-04-26 15:25:59',NULL),(5366,7797,41322,90378,3,4604,'App\\Models\\Receipt',4604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',2200.00,NULL,NULL,1,'2023-04-26 15:25:59','2023-04-26 15:25:59',NULL),(5367,7797,41322,90378,3,4605,'App\\Models\\Receipt',4605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',810.00,NULL,NULL,1,'2023-04-26 15:25:59','2023-04-26 15:25:59',NULL),(5368,7797,41322,90378,3,4606,'App\\Models\\Receipt',4606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',1625.00,NULL,NULL,1,'2023-04-26 15:25:59','2023-04-26 15:25:59',NULL),(5369,7797,41322,90378,3,4607,'App\\Models\\Receipt',4607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',21473.31,NULL,NULL,1,'2023-04-26 15:25:59','2023-04-26 15:25:59',NULL),(5370,7797,41322,90378,3,4608,'App\\Models\\Receipt',4608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',7529.50,NULL,NULL,1,'2023-04-26 15:25:59','2023-04-26 15:25:59',NULL),(5371,7768,41737,154275,2,4609,'App\\Models\\Receipt',4609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',78000.00,NULL,NULL,1,'2023-04-28 10:21:24','2023-04-28 10:21:24',NULL),(5372,7768,41737,154275,2,4610,'App\\Models\\Receipt',4610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',136000.00,NULL,NULL,1,'2023-04-28 10:21:24','2023-04-28 10:21:24',NULL),(5373,7768,41737,154275,2,4611,'App\\Models\\Receipt',4611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',105000.00,NULL,NULL,1,'2023-04-28 10:21:24','2023-04-28 10:21:24',NULL),(5374,7768,41737,154275,2,4612,'App\\Models\\Receipt',4612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',26400.00,NULL,NULL,1,'2023-04-28 10:24:19','2023-04-28 10:24:19',NULL),(5375,7768,41737,154275,2,4613,'App\\Models\\Receipt',4613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',45900.00,NULL,NULL,1,'2023-04-28 10:24:19','2023-04-28 10:24:19',NULL),(5376,7768,41737,154275,2,4614,'App\\Models\\Receipt',4614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',39000.00,NULL,NULL,1,'2023-04-28 10:24:19','2023-04-28 10:24:19',NULL),(5377,7768,41737,154275,2,4615,'App\\Models\\Receipt',4615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',11900.00,NULL,NULL,1,'2023-04-28 10:24:19','2023-04-28 10:24:19',NULL),(5378,7768,41737,154274,3,4616,'App\\Models\\Receipt',4616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',299.00,NULL,NULL,1,'2023-04-28 10:27:13','2023-04-28 10:27:13',NULL),(5379,7768,41737,154274,3,4617,'App\\Models\\Receipt',4617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',88.49,NULL,NULL,1,'2023-04-28 10:27:13','2023-04-28 10:27:13',NULL),(5380,7768,41737,154274,3,4618,'App\\Models\\Receipt',4618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',163.00,NULL,NULL,1,'2023-04-28 10:27:13','2023-04-28 10:27:13',NULL),(5381,7768,41737,154274,3,4619,'App\\Models\\Receipt',4619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',2068.97,NULL,NULL,1,'2023-04-28 10:27:13','2023-04-28 10:27:13',NULL),(5382,7768,41737,154274,3,4620,'App\\Models\\Receipt',4620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',2851.97,NULL,NULL,1,'2023-04-28 10:27:13','2023-04-28 10:27:13',NULL),(5383,7768,41737,154274,3,4621,'App\\Models\\Receipt',4621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',6114.82,NULL,NULL,1,'2023-04-28 10:27:13','2023-04-28 10:27:13',NULL);
INSERT INTO `balance_libro` VALUES (5384,7768,41737,154274,3,4622,'App\\Models\\Receipt',4622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',107503.23,NULL,NULL,1,'2023-04-28 10:27:13','2023-04-28 10:27:13',NULL),(5385,7768,41737,154274,3,4623,'App\\Models\\Receipt',4623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',68.00,NULL,NULL,1,'2023-04-28 10:27:13','2023-04-28 10:27:13',NULL),(5386,7768,41737,154274,3,4624,'App\\Models\\Receipt',4624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',6240.55,NULL,NULL,1,'2023-04-28 10:27:13','2023-04-28 10:27:13',NULL),(5387,7768,41737,154274,3,4625,'App\\Models\\Receipt',4625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',272.00,NULL,NULL,1,'2023-04-28 10:27:13','2023-04-28 10:27:13',NULL),(5388,7768,41737,154274,3,4626,'App\\Models\\Receipt',4626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',1.20,NULL,NULL,1,'2023-04-28 10:27:13','2023-04-28 10:27:13',NULL),(5389,7768,41737,154274,3,4627,'App\\Models\\Receipt',4627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',14447.28,NULL,NULL,1,'2023-04-28 10:27:13','2023-04-28 10:27:13',NULL),(5390,7768,41737,154274,3,4628,'App\\Models\\Receipt',4628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',6000.00,NULL,NULL,1,'2023-04-28 10:27:13','2023-04-28 10:27:13',NULL),(5391,7768,41737,154274,3,4629,'App\\Models\\Receipt',4629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',14520.00,NULL,NULL,1,'2023-04-28 10:27:13','2023-04-28 10:27:13',NULL),(5392,7768,41737,154275,3,4630,'App\\Models\\Receipt',4630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',128.31,NULL,NULL,1,'2023-04-28 10:27:51','2023-04-28 10:27:51',NULL),(5393,7768,41737,154275,3,4631,'App\\Models\\Receipt',4631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',136.00,NULL,NULL,1,'2023-04-28 10:27:51','2023-04-28 10:27:51',NULL),(5394,7768,41737,154275,3,4632,'App\\Models\\Receipt',4632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',1.20,NULL,NULL,1,'2023-04-28 10:27:51','2023-04-28 10:27:51',NULL),(5395,7768,41737,154275,3,4633,'App\\Models\\Receipt',4633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',2851.97,NULL,NULL,1,'2023-04-28 10:27:51','2023-04-28 10:27:51',NULL),(5396,7768,41737,154275,3,4634,'App\\Models\\Receipt',4634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',18500.00,NULL,NULL,1,'2023-04-28 10:27:51','2023-04-28 10:27:51',NULL),(5397,7768,41737,154275,3,4635,'App\\Models\\Receipt',4635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',2659.97,NULL,NULL,1,'2023-04-28 10:27:51','2023-04-28 10:27:51',NULL),(5398,7768,41737,154275,3,4636,'App\\Models\\Receipt',4636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',51531.87,NULL,NULL,1,'2023-04-28 10:27:51','2023-04-28 10:27:51',NULL),(5399,7768,41737,154275,3,4637,'App\\Models\\Receipt',4637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',197598.91,NULL,NULL,1,'2023-04-28 10:27:51','2023-04-28 10:27:51',NULL),(5400,7768,41737,154275,3,4638,'App\\Models\\Receipt',4638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',204.00,NULL,NULL,1,'2023-04-28 10:27:51','2023-04-28 10:27:51',NULL),(5401,7768,41737,154275,3,4639,'App\\Models\\Receipt',4639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',9600.00,NULL,NULL,1,'2023-04-28 10:27:51','2023-04-28 10:27:51',NULL),(5402,7768,41737,154275,3,4640,'App\\Models\\Receipt',4640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',9000.00,NULL,NULL,1,'2023-04-28 10:27:52','2023-04-28 10:27:52',NULL),(5403,7768,40728,13778,16,1607,'App\\Models\\PeriodLiquidation',NULL,1607,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',23091.78,NULL,NULL,1,'2023-04-30 10:24:24','2023-04-30 10:24:24',NULL);
INSERT INTO `balance_libro` VALUES (5404,7768,40728,13779,16,1609,'App\\Models\\PeriodLiquidation',NULL,1609,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',25079.57,NULL,NULL,1,'2023-04-30 10:24:30','2023-04-30 10:24:30',NULL),(5405,7768,40728,13778,15,1606,'App\\Models\\PeriodLiquidation',NULL,1606,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',82736.52,NULL,NULL,1,'2023-04-30 10:24:47','2023-04-30 10:24:47',NULL),(5406,7768,40728,13779,15,1608,'App\\Models\\PeriodLiquidation',NULL,1608,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',197114.03,NULL,NULL,1,'2023-04-30 10:24:56','2023-04-30 10:24:56',NULL),(5407,7768,42131,155784,2,4641,'App\\Models\\Receipt',4641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',67760.00,NULL,NULL,1,'2023-06-10 13:25:34','2023-06-10 13:25:34',NULL),(5408,7768,42131,155784,2,4642,'App\\Models\\Receipt',4642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',1057540.00,NULL,NULL,1,'2023-06-10 13:25:34','2023-06-10 13:25:34',NULL),(5478,7768,42131,155784,3,4712,'App\\Models\\Receipt',4712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',7014.87,NULL,NULL,1,'2023-06-10 13:27:49','2023-06-15 00:28:41','2023-06-15 00:28:41'),(5479,7768,42131,155784,3,4713,'App\\Models\\Receipt',4713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',1649.80,NULL,NULL,1,'2023-06-10 13:27:49','2023-06-15 00:28:41','2023-06-15 00:28:41'),(5555,7768,42131,155785,3,4789,'App\\Models\\Receipt',4789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',2130.30,NULL,NULL,1,'2023-06-10 13:32:54','2023-06-15 00:34:48','2023-06-15 00:34:48'),(5556,7768,42131,155785,3,4790,'App\\Models\\Receipt',4790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',6337.97,NULL,NULL,1,'2023-06-10 13:32:54','2023-06-15 00:34:48','2023-06-15 00:34:48'),(5557,7768,42131,155785,3,4791,'App\\Models\\Receipt',4791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',2700.00,NULL,NULL,1,'2023-06-10 13:32:54','2023-06-15 00:34:48','2023-06-15 00:34:48'),(5558,7768,42131,155785,3,4792,'App\\Models\\Receipt',4792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',1400.00,NULL,NULL,1,'2023-06-10 13:32:54','2023-06-15 00:34:48','2023-06-15 00:34:48'),(5559,7768,42131,155785,3,4793,'App\\Models\\Receipt',4793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',947.66,NULL,NULL,1,'2023-06-10 13:32:54','2023-06-15 00:34:48','2023-06-15 00:34:48'),(5560,7768,42131,155785,3,4794,'App\\Models\\Receipt',4794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',631.77,NULL,NULL,1,'2023-06-10 13:32:54','2023-06-15 00:34:48','2023-06-15 00:34:48'),(5561,7768,42131,155785,3,4795,'App\\Models\\Receipt',4795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',710.00,NULL,NULL,1,'2023-06-10 13:32:54','2023-06-15 00:34:48','2023-06-15 00:34:48'),(5562,7768,42131,155785,3,4796,'App\\Models\\Receipt',4796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-05','2022-02-05',560.00,NULL,NULL,1,'2023-06-10 13:32:54','2023-06-15 00:34:48','2023-06-15 00:34:48'),(5563,7768,42131,155785,3,4797,'App\\Models\\Receipt',4797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',8335.22,NULL,NULL,1,'2023-06-10 13:32:54','2023-06-15 00:34:48','2023-06-15 00:34:48'),(5564,7768,42131,155785,3,4798,'App\\Models\\Receipt',4798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',14268.00,NULL,NULL,1,'2023-06-10 13:32:54','2023-06-15 00:34:48','2023-06-15 00:34:48'),(5565,7768,42131,155785,3,4799,'App\\Models\\Receipt',4799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',7990.00,NULL,NULL,1,'2023-06-10 13:32:55','2023-06-15 00:34:48','2023-06-15 00:34:48'),(5566,7768,42131,155785,3,4800,'App\\Models\\Receipt',4800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',999.00,NULL,NULL,1,'2023-06-10 13:32:55','2023-06-15 00:34:48','2023-06-15 00:34:48');
INSERT INTO `balance_libro` VALUES (5567,7768,42131,155785,3,4801,'App\\Models\\Receipt',4801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',8608.89,NULL,NULL,1,'2023-06-10 13:32:55','2023-06-15 00:34:48','2023-06-15 00:34:48'),(5568,7768,42131,155785,3,4802,'App\\Models\\Receipt',4802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',4790.00,NULL,NULL,1,'2023-06-10 13:32:55','2023-06-15 00:34:48','2023-06-15 00:34:48'),(5569,7768,42131,155785,3,4803,'App\\Models\\Receipt',4803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',2394.50,NULL,NULL,1,'2023-06-10 13:32:55','2023-06-15 00:34:48','2023-06-15 00:34:48'),(5570,7768,42131,155785,3,4804,'App\\Models\\Receipt',4804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',130.00,NULL,NULL,1,'2023-06-10 13:32:55','2023-06-15 00:34:49','2023-06-15 00:34:49'),(5571,7768,42131,155785,3,4805,'App\\Models\\Receipt',4805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',3837.72,NULL,NULL,1,'2023-06-10 13:32:55','2023-06-15 00:34:49','2023-06-15 00:34:49'),(5572,7768,42131,155785,3,4806,'App\\Models\\Receipt',4806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',500.00,NULL,NULL,1,'2023-06-10 13:32:55','2023-06-15 00:34:49','2023-06-15 00:34:49'),(5573,7768,42131,155785,3,4807,'App\\Models\\Receipt',4807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-19','2022-02-19',632.17,NULL,NULL,1,'2023-06-10 13:32:55','2023-06-15 00:34:49','2023-06-15 00:34:49'),(5574,7768,42131,155785,3,4808,'App\\Models\\Receipt',4808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',160.00,NULL,NULL,1,'2023-06-10 13:32:55','2023-06-15 00:34:49','2023-06-15 00:34:49'),(5575,7768,42131,155785,3,4809,'App\\Models\\Receipt',4809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',350.00,NULL,NULL,1,'2023-06-10 13:32:55','2023-06-15 00:34:49','2023-06-15 00:34:49'),(5576,7768,42131,155785,3,4810,'App\\Models\\Receipt',4810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',920.00,NULL,NULL,1,'2023-06-10 13:32:55','2023-06-15 00:34:49','2023-06-15 00:34:49'),(5577,7768,42131,155785,3,4811,'App\\Models\\Receipt',4811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',510.00,NULL,NULL,1,'2023-06-10 13:32:55','2023-06-15 00:34:49','2023-06-15 00:34:49'),(5578,7768,42131,155785,3,4812,'App\\Models\\Receipt',4812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',260.00,NULL,NULL,1,'2023-06-10 13:32:55','2023-06-15 00:34:49','2023-06-15 00:34:49'),(5579,7768,42131,155785,3,4813,'App\\Models\\Receipt',4813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',419.98,NULL,NULL,1,'2023-06-10 13:32:55','2023-06-15 00:34:49','2023-06-15 00:34:49'),(5580,7768,42131,155785,3,4814,'App\\Models\\Receipt',4814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',640.00,NULL,NULL,1,'2023-06-10 13:32:55','2023-06-15 00:34:49','2023-06-15 00:34:49'),(5581,7768,42131,155785,3,4815,'App\\Models\\Receipt',4815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',21000.00,NULL,NULL,1,'2023-06-10 13:32:55','2023-06-15 00:34:49','2023-06-15 00:34:49'),(5582,7768,42131,155785,3,4816,'App\\Models\\Receipt',4816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',870.00,NULL,NULL,1,'2023-06-10 13:32:55','2023-06-15 00:34:49','2023-06-15 00:34:49'),(5583,7768,42131,155785,3,4817,'App\\Models\\Receipt',4817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',720.00,NULL,NULL,1,'2023-06-10 13:32:55','2023-06-15 00:34:49','2023-06-15 00:34:49'),(5584,7768,42131,155785,3,4818,'App\\Models\\Receipt',4818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',470.00,NULL,NULL,1,'2023-06-10 13:32:55','2023-06-15 00:34:49','2023-06-15 00:34:49'),(5585,7768,42131,155785,3,4819,'App\\Models\\Receipt',4819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',1400.00,NULL,NULL,1,'2023-06-10 13:32:55','2023-06-15 00:34:49','2023-06-15 00:34:49');
INSERT INTO `balance_libro` VALUES (5586,7768,42131,155785,3,4820,'App\\Models\\Receipt',4820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-19','2022-02-19',640.00,NULL,NULL,1,'2023-06-10 13:32:55','2023-06-15 00:34:49','2023-06-15 00:34:49'),(5587,7768,42131,155785,3,4821,'App\\Models\\Receipt',4821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-19','2022-02-19',1100.00,NULL,NULL,1,'2023-06-10 13:32:55','2023-06-15 00:34:49','2023-06-15 00:34:49'),(5588,7768,42131,155785,3,4822,'App\\Models\\Receipt',4822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-19','2022-02-19',830.00,NULL,NULL,1,'2023-06-10 13:32:55','2023-06-15 00:34:49','2023-06-15 00:34:49'),(5589,7768,42131,155785,3,4823,'App\\Models\\Receipt',4823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-19','2022-02-19',500.00,NULL,NULL,1,'2023-06-10 13:32:55','2023-06-15 00:34:49','2023-06-15 00:34:49'),(5590,7768,42131,155785,3,4824,'App\\Models\\Receipt',4824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-20','2022-02-20',1160.00,NULL,NULL,1,'2023-06-10 13:32:56','2023-06-15 00:34:49','2023-06-15 00:34:49'),(5591,7768,42131,155785,3,4825,'App\\Models\\Receipt',4825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',1711.10,NULL,NULL,1,'2023-06-10 13:32:56','2023-06-15 00:34:49','2023-06-15 00:34:49'),(5592,7768,42131,155785,3,4826,'App\\Models\\Receipt',4826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',920.00,NULL,NULL,1,'2023-06-10 13:32:56','2023-06-15 00:34:49','2023-06-15 00:34:49'),(5593,7768,42131,155785,3,4827,'App\\Models\\Receipt',4827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',250.00,NULL,NULL,1,'2023-06-10 13:32:56','2023-06-15 00:34:49','2023-06-15 00:34:49'),(5594,7768,42131,155785,3,4828,'App\\Models\\Receipt',4828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',94585.70,NULL,NULL,1,'2023-06-10 13:32:56','2023-06-15 00:34:49','2023-06-15 00:34:49'),(5595,7768,42131,155785,3,4829,'App\\Models\\Receipt',4829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',94961.60,NULL,NULL,1,'2023-06-10 13:32:56','2023-06-15 00:34:49','2023-06-15 00:34:49'),(5596,7768,42131,155785,3,4830,'App\\Models\\Receipt',4830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',96509.60,NULL,NULL,1,'2023-06-10 13:32:56','2023-06-15 00:34:49','2023-06-15 00:34:49'),(5597,7768,42131,155785,3,4831,'App\\Models\\Receipt',4831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',99534.60,NULL,NULL,1,'2023-06-10 13:32:56','2023-06-15 00:34:49','2023-06-15 00:34:49'),(5598,7768,42131,155785,3,4832,'App\\Models\\Receipt',4832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',5650.20,NULL,NULL,1,'2023-06-10 13:32:56','2023-06-15 00:34:49','2023-06-15 00:34:49'),(5599,7768,42131,155785,3,4833,'App\\Models\\Receipt',4833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',105998.99,NULL,NULL,1,'2023-06-10 13:32:56','2023-06-15 00:34:49','2023-06-15 00:34:49'),(5600,7768,42131,155785,3,4834,'App\\Models\\Receipt',4834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',99999.00,NULL,NULL,1,'2023-06-10 13:32:56','2023-06-15 00:34:49','2023-06-15 00:34:49'),(5601,7768,42131,155785,3,4835,'App\\Models\\Receipt',4835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',52253.85,NULL,NULL,1,'2023-06-10 13:32:56','2023-06-15 00:34:49','2023-06-15 00:34:49'),(5602,7768,42131,155785,3,4836,'App\\Models\\Receipt',4836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',52253.85,NULL,NULL,1,'2023-06-10 13:32:56','2023-06-15 00:34:49','2023-06-15 00:34:49'),(5603,7768,42131,155785,2,4837,'App\\Models\\Receipt',4837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',508200.00,NULL,NULL,1,'2023-06-10 13:33:06','2023-06-10 13:33:06',NULL),(5604,7768,42131,155785,2,4838,'App\\Models\\Receipt',4838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',23595.00,NULL,NULL,1,'2023-06-10 13:33:06','2023-06-10 13:33:06',NULL);
INSERT INTO `balance_libro` VALUES (5605,7768,42131,155785,2,4839,'App\\Models\\Receipt',4839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',278300.00,NULL,NULL,1,'2023-06-10 13:33:06','2023-06-10 13:33:06',NULL),(5606,7768,42131,155785,2,4840,'App\\Models\\Receipt',4840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',242000.00,NULL,NULL,1,'2023-06-10 13:33:06','2023-06-10 13:33:06',NULL),(5607,7768,42131,155786,2,4841,'App\\Models\\Receipt',4841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',101640.00,NULL,NULL,1,'2023-06-10 13:39:08','2023-06-10 13:39:08',NULL),(5608,7768,42131,155786,2,4842,'App\\Models\\Receipt',4842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',36300.00,NULL,NULL,1,'2023-06-10 13:39:08','2023-06-10 13:39:08',NULL),(5609,7768,42131,155786,2,4843,'App\\Models\\Receipt',4843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',99220.00,NULL,NULL,1,'2023-06-10 13:39:08','2023-06-10 13:39:08',NULL),(5610,7768,42131,155786,2,4844,'App\\Models\\Receipt',4844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',38720.00,NULL,NULL,1,'2023-06-10 13:39:08','2023-06-10 13:39:08',NULL),(5611,7768,42131,155786,2,4845,'App\\Models\\Receipt',4845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',115918.00,NULL,NULL,1,'2023-06-10 13:39:08','2023-06-10 13:39:08',NULL),(5612,7768,42131,155786,2,4846,'App\\Models\\Receipt',4846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',750200.00,NULL,NULL,1,'2023-06-10 13:39:08','2023-06-10 13:39:08',NULL),(5613,7768,42131,155786,2,4847,'App\\Models\\Receipt',4847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',64977.00,NULL,NULL,1,'2023-06-10 13:39:08','2023-06-10 13:39:08',NULL),(5697,7768,42131,155786,3,4931,'App\\Models\\Receipt',4931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',1430.00,NULL,NULL,1,'2023-06-10 13:43:24','2023-06-10 13:43:24',NULL),(5698,7768,42131,155786,3,4932,'App\\Models\\Receipt',4932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',300.00,NULL,NULL,1,'2023-06-10 13:43:24','2023-06-10 13:43:24',NULL),(5699,7768,42131,155786,3,4933,'App\\Models\\Receipt',4933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',250.00,NULL,NULL,1,'2023-06-10 13:43:24','2023-06-10 13:43:24',NULL),(5700,7768,42131,155786,3,4934,'App\\Models\\Receipt',4934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',3600.00,NULL,NULL,1,'2023-06-10 13:43:24','2023-06-10 13:43:24',NULL),(5701,7768,42131,155786,3,4935,'App\\Models\\Receipt',4935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',240.00,NULL,NULL,1,'2023-06-10 13:43:24','2023-06-10 13:43:24',NULL),(5702,7768,42131,155786,3,4936,'App\\Models\\Receipt',4936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',300.00,NULL,NULL,1,'2023-06-10 13:43:24','2023-06-10 13:43:24',NULL),(5703,7768,42131,155786,3,4937,'App\\Models\\Receipt',4937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',633.60,NULL,NULL,1,'2023-06-10 13:43:24','2023-06-10 13:43:24',NULL),(5704,7768,42131,155786,3,4938,'App\\Models\\Receipt',4938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',76593.00,NULL,NULL,1,'2023-06-10 13:43:24','2023-06-10 13:43:24',NULL),(5705,7768,42131,155786,3,4939,'App\\Models\\Receipt',4939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',77718.30,NULL,NULL,1,'2023-06-10 13:43:24','2023-06-10 13:43:24',NULL),(5706,7768,42131,155786,3,4940,'App\\Models\\Receipt',4940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',78480.60,NULL,NULL,1,'2023-06-10 13:43:24','2023-06-10 13:43:24',NULL),(5707,7768,42131,155786,3,4941,'App\\Models\\Receipt',4941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',74886.90,NULL,NULL,1,'2023-06-10 13:43:24','2023-06-10 13:43:24',NULL);
INSERT INTO `balance_libro` VALUES (5708,7768,42131,155786,3,4942,'App\\Models\\Receipt',4942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',81675.00,NULL,NULL,1,'2023-06-10 13:43:24','2023-06-10 13:43:24',NULL),(5709,7768,42131,155786,3,4943,'App\\Models\\Receipt',4943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',78053.47,NULL,NULL,1,'2023-06-10 13:43:24','2023-06-10 13:43:24',NULL),(5710,7768,42131,155786,3,4944,'App\\Models\\Receipt',4944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',16787.46,NULL,NULL,1,'2023-06-10 13:43:24','2023-06-10 13:43:24',NULL),(5711,7768,42131,155786,3,4945,'App\\Models\\Receipt',4945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',5340.92,NULL,NULL,1,'2023-06-10 13:43:24','2023-06-10 13:43:24',NULL),(5712,7768,42131,155786,3,4946,'App\\Models\\Receipt',4946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',13023.43,NULL,NULL,1,'2023-06-10 13:43:24','2023-06-10 13:43:24',NULL),(5713,7768,42131,155786,3,4947,'App\\Models\\Receipt',4947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',5701.20,NULL,NULL,1,'2023-06-10 13:43:24','2023-06-10 13:43:24',NULL),(5729,7768,42131,155786,3,4963,'App\\Models\\Receipt',4963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',140587.09,NULL,NULL,1,'2023-06-10 13:44:13','2023-06-10 13:44:13',NULL),(5730,7768,42131,155786,3,4964,'App\\Models\\Receipt',4964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',2106.00,NULL,NULL,1,'2023-06-10 13:44:13','2023-06-10 13:44:13',NULL),(5731,7768,42131,155786,3,4965,'App\\Models\\Receipt',4965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-19','2022-03-19',4243.47,NULL,NULL,1,'2023-06-10 13:44:13','2023-06-10 13:44:13',NULL),(5732,7768,42131,155786,3,4966,'App\\Models\\Receipt',4966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',655.87,NULL,NULL,1,'2023-06-10 13:44:13','2023-06-10 13:44:13',NULL),(5733,7768,42131,155786,3,4967,'App\\Models\\Receipt',4967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',1308.99,NULL,NULL,1,'2023-06-10 13:44:13','2023-06-10 13:44:13',NULL),(5734,7768,42131,155786,3,4968,'App\\Models\\Receipt',4968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-21','2022-03-21',100.00,NULL,NULL,1,'2023-06-10 13:44:14','2023-06-10 13:44:14',NULL),(5735,7768,42131,155786,3,4969,'App\\Models\\Receipt',4969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',140582.85,NULL,NULL,1,'2023-06-10 13:44:14','2023-06-10 13:44:14',NULL),(5736,7768,42131,155786,3,4970,'App\\Models\\Receipt',4970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',140582.85,NULL,NULL,1,'2023-06-10 13:44:14','2023-06-10 13:44:14',NULL),(5737,7768,42131,155786,3,4971,'App\\Models\\Receipt',4971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',27741.22,NULL,NULL,1,'2023-06-10 13:44:14','2023-06-10 13:44:14',NULL),(5738,7768,42131,155786,3,4972,'App\\Models\\Receipt',4972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',200.00,NULL,NULL,1,'2023-06-10 13:44:14','2023-06-10 13:44:14',NULL),(5739,7768,42131,155786,3,4973,'App\\Models\\Receipt',4973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',140587.09,NULL,NULL,1,'2023-06-10 13:44:14','2023-06-10 13:44:14',NULL),(5740,7768,42131,155786,3,4974,'App\\Models\\Receipt',4974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',86000.00,NULL,NULL,1,'2023-06-10 13:44:14','2023-06-10 13:44:14',NULL),(5741,7768,42131,155786,3,4975,'App\\Models\\Receipt',4975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',6080.28,NULL,NULL,1,'2023-06-10 13:44:14','2023-06-10 13:44:14',NULL),(5742,7768,42131,155786,3,4976,'App\\Models\\Receipt',4976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',46562.21,NULL,NULL,1,'2023-06-10 13:44:14','2023-06-10 13:44:14',NULL);
INSERT INTO `balance_libro` VALUES (5743,7768,42131,155786,3,4977,'App\\Models\\Receipt',4977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',4500.50,NULL,NULL,1,'2023-06-10 13:44:14','2023-06-10 13:44:14',NULL),(5744,7768,42131,155786,3,4978,'App\\Models\\Receipt',4978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-24','2022-03-24',117500.00,NULL,NULL,1,'2023-06-10 13:44:14','2023-06-10 13:44:14',NULL),(5745,7768,42131,155786,3,4979,'App\\Models\\Receipt',4979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',939.00,NULL,NULL,1,'2023-06-10 13:44:14','2023-06-10 13:44:14',NULL),(5746,7768,42131,155786,3,4980,'App\\Models\\Receipt',4980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-28','2022-03-28',50820.00,NULL,NULL,1,'2023-06-10 13:44:14','2023-06-10 13:44:14',NULL),(5747,7768,42131,155786,3,4981,'App\\Models\\Receipt',4981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',140582.85,NULL,NULL,1,'2023-06-10 13:44:14','2023-06-10 13:44:14',NULL),(5748,7768,42131,155786,3,4982,'App\\Models\\Receipt',4982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',4382.40,NULL,NULL,1,'2023-06-10 13:44:14','2023-06-10 13:44:14',NULL),(5749,7768,42131,155786,3,4983,'App\\Models\\Receipt',4983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',6100.90,NULL,NULL,1,'2023-06-10 13:44:14','2023-06-10 13:44:14',NULL),(5750,7768,42131,155786,3,4984,'App\\Models\\Receipt',4984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',3618.19,NULL,NULL,1,'2023-06-10 13:44:14','2023-06-10 13:44:14',NULL),(5751,7768,42131,155786,3,4985,'App\\Models\\Receipt',4985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',5701.21,NULL,NULL,1,'2023-06-10 13:44:14','2023-06-10 13:44:14',NULL),(5752,7768,42131,155786,3,4986,'App\\Models\\Receipt',4986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',5601.71,NULL,NULL,1,'2023-06-10 13:44:14','2023-06-10 13:44:14',NULL),(5753,7768,42131,155786,3,4987,'App\\Models\\Receipt',4987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-05','2022-03-05',6299.96,NULL,NULL,1,'2023-06-10 13:44:14','2023-06-10 13:44:14',NULL),(5754,7768,42131,155786,3,4988,'App\\Models\\Receipt',4988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',6190.48,NULL,NULL,1,'2023-06-10 13:44:14','2023-06-10 13:44:14',NULL),(5755,7768,42131,155786,3,4989,'App\\Models\\Receipt',4989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-22','2022-03-22',6999.94,NULL,NULL,1,'2023-06-10 13:44:15','2023-06-10 13:44:15',NULL),(5756,7768,42131,155786,3,4990,'App\\Models\\Receipt',4990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-23','2022-03-23',300.00,NULL,NULL,1,'2023-06-10 13:44:15','2023-06-10 13:44:15',NULL),(5757,7768,42131,155786,3,4991,'App\\Models\\Receipt',4991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-25','2022-03-25',260.00,NULL,NULL,1,'2023-06-10 13:44:15','2023-06-10 13:44:15',NULL),(5758,7768,42131,155786,3,4992,'App\\Models\\Receipt',4992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-26','2022-03-26',320.00,NULL,NULL,1,'2023-06-10 13:44:15','2023-06-10 13:44:15',NULL),(5759,7768,42131,155786,3,4993,'App\\Models\\Receipt',4993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-29','2022-03-29',1290.00,NULL,NULL,1,'2023-06-10 13:44:15','2023-06-10 13:44:15',NULL),(5760,7768,42131,155786,3,4994,'App\\Models\\Receipt',4994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',1960.00,NULL,NULL,1,'2023-06-10 13:44:15','2023-06-10 13:44:15',NULL),(5761,7768,42131,155786,3,4995,'App\\Models\\Receipt',4995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',1907.54,NULL,NULL,1,'2023-06-10 13:44:15','2023-06-10 13:44:15',NULL),(5762,7768,42131,155786,3,4996,'App\\Models\\Receipt',4996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-01','2022-03-01',1246.80,NULL,NULL,1,'2023-06-10 13:44:15','2023-06-10 13:44:15',NULL),(5763,7768,42131,155786,3,4997,'App\\Models\\Receipt',4997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-02','2022-03-02',27057.29,NULL,NULL,1,'2023-06-10 13:44:15','2023-06-10 13:44:15',NULL);
INSERT INTO `balance_libro` VALUES (5764,7768,42131,155786,3,4998,'App\\Models\\Receipt',4998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',91.95,NULL,NULL,1,'2023-06-10 13:44:15','2023-06-10 13:44:15',NULL),(5765,7768,42131,155786,3,4999,'App\\Models\\Receipt',4999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',320.00,NULL,NULL,1,'2023-06-10 13:44:15','2023-06-10 13:44:15',NULL),(5766,7768,42131,155786,3,5000,'App\\Models\\Receipt',5000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',1448.00,NULL,NULL,1,'2023-06-10 13:44:15','2023-06-10 13:44:15',NULL),(5767,7768,42131,155786,3,5001,'App\\Models\\Receipt',5001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',1442.68,NULL,NULL,1,'2023-06-10 13:44:15','2023-06-10 13:44:15',NULL),(5768,7768,42131,155786,3,5002,'App\\Models\\Receipt',5002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-27','2022-03-27',168.00,NULL,NULL,1,'2023-06-10 13:44:15','2023-06-10 13:44:15',NULL),(5769,7768,42131,155786,3,5003,'App\\Models\\Receipt',5003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-27','2022-03-27',335.00,NULL,NULL,1,'2023-06-10 13:44:15','2023-06-10 13:44:15',NULL),(5770,7768,42131,155786,3,5004,'App\\Models\\Receipt',5004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',290.00,NULL,NULL,1,'2023-06-10 13:44:15','2023-06-10 13:44:15',NULL),(5771,7768,42131,155786,3,5005,'App\\Models\\Receipt',5005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-18','2021-12-18',620.00,NULL,NULL,1,'2023-06-10 13:44:15','2023-06-10 13:44:15',NULL),(5772,7768,42131,155786,3,5006,'App\\Models\\Receipt',5006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',672.85,NULL,NULL,1,'2023-06-10 13:44:15','2023-06-10 13:44:15',NULL),(5773,7768,42131,155786,3,5007,'App\\Models\\Receipt',5007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',1135.00,NULL,NULL,1,'2023-06-10 13:44:15','2023-06-10 13:44:15',NULL),(5774,7768,42131,155786,3,5008,'App\\Models\\Receipt',5008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-27','2022-02-27',258.00,NULL,NULL,1,'2023-06-10 13:44:15','2023-06-10 13:44:15',NULL),(5775,7768,42131,155786,3,5009,'App\\Models\\Receipt',5009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',250.00,NULL,NULL,1,'2023-06-10 13:44:15','2023-06-10 13:44:15',NULL),(5776,7768,42131,155786,3,5010,'App\\Models\\Receipt',5010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-01','2022-03-01',2779.99,NULL,NULL,1,'2023-06-10 13:44:15','2023-06-10 13:44:15',NULL),(5777,7768,42131,155786,3,5011,'App\\Models\\Receipt',5011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-01','2022-03-01',420.00,NULL,NULL,1,'2023-06-10 13:44:15','2023-06-10 13:44:15',NULL),(5778,7768,42131,155786,3,5012,'App\\Models\\Receipt',5012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',478.00,NULL,NULL,1,'2023-06-10 13:44:15','2023-06-10 13:44:15',NULL),(5779,7768,42131,155786,3,5013,'App\\Models\\Receipt',5013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',1760.55,NULL,NULL,1,'2023-06-10 13:44:15','2023-06-10 13:44:15',NULL),(5780,7768,42131,155786,3,5014,'App\\Models\\Receipt',5014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',40980.00,NULL,NULL,1,'2023-06-10 13:44:16','2023-06-10 13:44:16',NULL),(5781,7768,42131,155786,3,5015,'App\\Models\\Receipt',5015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',9120.00,NULL,NULL,1,'2023-06-10 13:44:16','2023-06-10 13:44:16',NULL),(5782,7768,42131,155786,3,5016,'App\\Models\\Receipt',5016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',790.00,NULL,NULL,1,'2023-06-10 13:44:16','2023-06-10 13:44:16',NULL),(5783,7768,42131,155786,3,5017,'App\\Models\\Receipt',5017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',920.00,NULL,NULL,1,'2023-06-10 13:44:16','2023-06-10 13:44:16',NULL),(5784,7768,42131,155786,3,5018,'App\\Models\\Receipt',5018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',280.00,NULL,NULL,1,'2023-06-10 13:44:16','2023-06-10 13:44:16',NULL);
INSERT INTO `balance_libro` VALUES (5785,7768,42131,155786,3,5019,'App\\Models\\Receipt',5019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',750.00,NULL,NULL,1,'2023-06-10 13:44:16','2023-06-10 13:44:16',NULL),(5786,7768,42131,155786,3,5020,'App\\Models\\Receipt',5020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',903.00,NULL,NULL,1,'2023-06-10 13:44:16','2023-06-10 13:44:16',NULL),(5787,7768,42131,155786,3,5021,'App\\Models\\Receipt',5021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',6100.21,NULL,NULL,1,'2023-06-10 13:44:16','2023-06-10 13:44:16',NULL),(5788,7768,42131,155786,3,5022,'App\\Models\\Receipt',5022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',227.30,NULL,NULL,1,'2023-06-10 13:44:16','2023-06-10 13:44:16',NULL),(5789,7768,42131,155786,3,5023,'App\\Models\\Receipt',5023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',518.50,NULL,NULL,1,'2023-06-10 13:44:16','2023-06-10 13:44:16',NULL),(5790,7768,42131,155786,3,5024,'App\\Models\\Receipt',5024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',7600.00,NULL,NULL,1,'2023-06-10 13:44:16','2023-06-10 13:44:16',NULL),(5791,7768,42131,155786,3,5025,'App\\Models\\Receipt',5025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',1190.00,NULL,NULL,1,'2023-06-10 13:44:16','2023-06-10 13:44:16',NULL),(5792,7768,42131,155786,3,5026,'App\\Models\\Receipt',5026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',450.00,NULL,NULL,1,'2023-06-10 13:44:16','2023-06-10 13:44:16',NULL),(5832,7768,42131,155786,3,5066,'App\\Models\\Receipt',5066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',35764.38,NULL,NULL,1,'2023-06-10 13:46:48','2023-06-10 13:46:48',NULL),(5833,7768,42131,155786,3,5067,'App\\Models\\Receipt',5067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',1777.45,NULL,NULL,1,'2023-06-10 13:47:06','2023-06-10 13:47:06',NULL),(5834,7768,42131,155786,3,5068,'App\\Models\\Receipt',5068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-06','2022-03-06',1250.00,NULL,NULL,1,'2023-06-10 13:47:06','2023-06-10 13:47:06',NULL),(5835,7768,42131,155786,3,5069,'App\\Models\\Receipt',5069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-06','2022-03-06',2940.00,NULL,NULL,1,'2023-06-10 13:47:06','2023-06-10 13:47:06',NULL),(5836,7768,42131,155786,3,5070,'App\\Models\\Receipt',5070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',6736.50,NULL,NULL,1,'2023-06-10 13:47:06','2023-06-10 13:47:06',NULL),(5837,7768,42131,155786,3,5071,'App\\Models\\Receipt',5071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',18500.00,NULL,NULL,1,'2023-06-10 13:47:06','2023-06-10 13:47:06',NULL),(5838,7768,42131,155786,3,5072,'App\\Models\\Receipt',5072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-08','2022-03-08',300000.00,NULL,NULL,1,'2023-06-10 13:47:06','2023-06-10 13:47:06',NULL),(5839,7768,42131,155786,3,5073,'App\\Models\\Receipt',5073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-09','2022-03-09',22000.00,NULL,NULL,1,'2023-06-10 13:47:07','2023-06-10 13:47:07',NULL),(5840,7768,42131,155786,3,5074,'App\\Models\\Receipt',5074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-10','2022-03-10',3549.96,NULL,NULL,1,'2023-06-10 13:47:07','2023-06-10 13:47:07',NULL),(5841,7768,42131,155786,3,5075,'App\\Models\\Receipt',5075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',281174.17,NULL,NULL,1,'2023-06-10 13:47:07','2023-06-10 13:47:07',NULL),(5856,7768,42131,155786,3,5090,'App\\Models\\Receipt',5090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',5794.90,NULL,NULL,1,'2023-06-10 13:48:17','2023-06-10 13:48:17',NULL),(5860,7768,42131,155786,3,5094,'App\\Models\\Receipt',5094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',119800.16,NULL,NULL,1,'2023-06-10 13:48:49','2023-06-10 13:48:49',NULL);
INSERT INTO `balance_libro` VALUES (5861,7768,42131,155786,3,5095,'App\\Models\\Receipt',5095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-11','2022-03-11',38720.00,NULL,NULL,1,'2023-06-10 13:50:01','2023-06-10 13:50:01',NULL),(5862,7768,42131,155786,3,5096,'App\\Models\\Receipt',5096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-12','2022-03-12',2500.00,NULL,NULL,1,'2023-06-10 13:50:01','2023-06-10 13:50:01',NULL),(5863,7768,42131,155786,3,5097,'App\\Models\\Receipt',5097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-14','2022-03-14',26000.00,NULL,NULL,1,'2023-06-10 13:50:01','2023-06-10 13:50:01',NULL),(5864,7768,42131,155786,3,5098,'App\\Models\\Receipt',5098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',2566.34,NULL,NULL,1,'2023-06-10 13:50:01','2023-06-10 13:50:01',NULL),(5865,7768,42131,155786,3,5099,'App\\Models\\Receipt',5099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-16','2022-03-16',1434.71,NULL,NULL,1,'2023-06-10 13:50:01','2023-06-10 13:50:01',NULL),(5866,7768,42131,155786,3,5100,'App\\Models\\Receipt',5100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-17','2022-03-17',126.42,NULL,NULL,1,'2023-06-10 13:50:01','2023-06-10 13:50:01',NULL),(5867,7768,42131,155786,3,5101,'App\\Models\\Receipt',5101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-18','2022-03-18',33880.00,NULL,NULL,1,'2023-06-10 13:50:02','2023-06-10 13:50:02',NULL),(5868,7768,42131,155786,3,5102,'App\\Models\\Receipt',5102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-04','2022-03-04',82280.00,NULL,NULL,1,'2023-06-10 13:50:02','2023-06-10 13:50:02',NULL),(5922,7768,42131,155787,3,5156,'App\\Models\\Receipt',5156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',23438.37,NULL,NULL,1,'2023-06-10 14:02:38','2023-06-10 14:02:38',NULL),(5923,7768,42131,155787,3,5157,'App\\Models\\Receipt',5157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',4565.00,NULL,NULL,1,'2023-06-10 14:02:38','2023-06-10 14:02:38',NULL),(5924,7768,42131,155787,3,5158,'App\\Models\\Receipt',5158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',9596.56,NULL,NULL,1,'2023-06-10 14:02:38','2023-06-10 14:02:38',NULL),(5925,7768,42131,155787,3,5159,'App\\Models\\Receipt',5159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-10','2022-04-10',7782.79,NULL,NULL,1,'2023-06-10 14:02:38','2023-06-10 14:02:38',NULL),(5926,7768,42131,155787,3,5160,'App\\Models\\Receipt',5160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',3700.63,NULL,NULL,1,'2023-06-10 14:02:38','2023-06-10 14:02:38',NULL),(5927,7768,42131,155787,3,5161,'App\\Models\\Receipt',5161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',2000.00,NULL,NULL,1,'2023-06-10 14:02:38','2023-06-10 14:02:38',NULL),(5928,7768,42131,155787,3,5162,'App\\Models\\Receipt',5162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',5154.13,NULL,NULL,1,'2023-06-10 14:02:38','2023-06-10 14:02:38',NULL),(5929,7768,42131,155787,3,5163,'App\\Models\\Receipt',5163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',8440.64,NULL,NULL,1,'2023-06-10 14:02:38','2023-06-10 14:02:38',NULL),(5930,7768,42131,155787,3,5164,'App\\Models\\Receipt',5164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',5171.00,NULL,NULL,1,'2023-06-10 14:02:38','2023-06-10 14:02:38',NULL),(5931,7768,42131,155787,3,5165,'App\\Models\\Receipt',5165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',469.60,NULL,NULL,1,'2023-06-10 14:02:38','2023-06-10 14:02:38',NULL),(5932,7768,42131,155787,3,5166,'App\\Models\\Receipt',5166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',9240.00,NULL,NULL,1,'2023-06-10 14:02:38','2023-06-10 14:02:38',NULL),(5933,7768,42131,155787,3,5167,'App\\Models\\Receipt',5167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-17','2022-04-17',1140.00,NULL,NULL,1,'2023-06-10 14:02:38','2023-06-10 14:02:38',NULL),(5934,7768,42131,155787,3,5168,'App\\Models\\Receipt',5168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',3223.21,NULL,NULL,1,'2023-06-10 14:02:39','2023-06-10 14:02:39',NULL);
INSERT INTO `balance_libro` VALUES (5935,7768,42131,155787,3,5169,'App\\Models\\Receipt',5169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',264.00,NULL,NULL,1,'2023-06-10 14:02:39','2023-06-10 14:02:39',NULL),(5936,7768,42131,155787,3,5170,'App\\Models\\Receipt',5170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',6512.52,NULL,NULL,1,'2023-06-10 14:02:39','2023-06-10 14:02:39',NULL),(5937,7768,42131,155787,3,5171,'App\\Models\\Receipt',5171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',319.00,NULL,NULL,1,'2023-06-10 14:02:39','2023-06-10 14:02:39',NULL),(5938,7768,42131,155787,3,5172,'App\\Models\\Receipt',5172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',1000.50,NULL,NULL,1,'2023-06-10 14:02:39','2023-06-10 14:02:39',NULL),(5939,7768,42131,155787,3,5173,'App\\Models\\Receipt',5173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',2650.08,NULL,NULL,1,'2023-06-10 14:02:39','2023-06-10 14:02:39',NULL),(5940,7768,42131,155787,3,5174,'App\\Models\\Receipt',5174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',260.00,NULL,NULL,1,'2023-06-10 14:02:39','2023-06-10 14:02:39',NULL),(5941,7768,42131,155787,3,5175,'App\\Models\\Receipt',5175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',930.00,NULL,NULL,1,'2023-06-10 14:02:39','2023-06-10 14:02:39',NULL),(5942,7768,42131,155787,3,5176,'App\\Models\\Receipt',5176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',4795.00,NULL,NULL,1,'2023-06-10 14:02:39','2023-06-10 14:02:39',NULL),(5943,7768,42131,155787,3,5177,'App\\Models\\Receipt',5177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',256.00,NULL,NULL,1,'2023-06-10 14:02:39','2023-06-10 14:02:39',NULL),(5944,7768,42131,155787,3,5178,'App\\Models\\Receipt',5178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',2670.90,NULL,NULL,1,'2023-06-10 14:02:39','2023-06-10 14:02:39',NULL),(5945,7768,42131,155787,3,5179,'App\\Models\\Receipt',5179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-17','2022-04-17',6830.00,NULL,NULL,1,'2023-06-10 14:02:39','2023-06-10 14:02:39',NULL),(5946,7768,42131,155787,3,5180,'App\\Models\\Receipt',5180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-17','2022-04-17',583.50,NULL,NULL,1,'2023-06-10 14:02:39','2023-06-10 14:02:39',NULL),(5947,7768,42131,155787,3,5181,'App\\Models\\Receipt',5181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',5400.00,NULL,NULL,1,'2023-06-10 14:02:39','2023-06-10 14:02:39',NULL),(5948,7768,42131,155787,3,5182,'App\\Models\\Receipt',5182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',3550.00,NULL,NULL,1,'2023-06-10 14:02:39','2023-06-10 14:02:39',NULL),(5949,7768,42131,155787,3,5183,'App\\Models\\Receipt',5183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',6000.00,NULL,NULL,1,'2023-06-10 14:02:39','2023-06-10 14:02:39',NULL),(5950,7768,42131,155787,3,5184,'App\\Models\\Receipt',5184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',6090.00,NULL,NULL,1,'2023-06-10 14:02:39','2023-06-10 14:02:39',NULL),(5951,7768,42131,155787,3,5185,'App\\Models\\Receipt',5185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-24','2022-04-24',994.00,NULL,NULL,1,'2023-06-10 14:02:39','2023-06-10 14:02:39',NULL),(5952,7768,42131,155787,3,5186,'App\\Models\\Receipt',5186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',1000.00,NULL,NULL,1,'2023-06-10 14:02:39','2023-06-10 14:02:39',NULL),(5953,7768,42131,155787,3,5187,'App\\Models\\Receipt',5187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',7600.00,NULL,NULL,1,'2023-06-10 14:02:39','2023-06-10 14:02:39',NULL),(5954,7768,42131,155787,3,5188,'App\\Models\\Receipt',5188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',1900.00,NULL,NULL,1,'2023-06-10 14:02:39','2023-06-10 14:02:39',NULL),(5955,7768,42131,155787,3,5189,'App\\Models\\Receipt',5189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',1205.00,NULL,NULL,1,'2023-06-10 14:02:39','2023-06-10 14:02:39',NULL);
INSERT INTO `balance_libro` VALUES (5956,7768,42131,155787,3,5190,'App\\Models\\Receipt',5190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',350.00,NULL,NULL,1,'2023-06-10 14:02:39','2023-06-10 14:02:39',NULL),(5957,7768,42131,155787,3,5191,'App\\Models\\Receipt',5191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-02','2022-04-02',73780.96,NULL,NULL,1,'2023-06-10 14:02:39','2023-06-10 14:02:39',NULL),(5958,7768,42131,155787,3,5192,'App\\Models\\Receipt',5192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',71995.00,NULL,NULL,1,'2023-06-10 14:02:39','2023-06-10 14:02:39',NULL),(5959,7768,42131,155787,3,5193,'App\\Models\\Receipt',5193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-09','2022-04-09',78625.80,NULL,NULL,1,'2023-06-10 14:02:39','2023-06-10 14:02:39',NULL),(5960,7768,42131,155787,3,5194,'App\\Models\\Receipt',5194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',75721.80,NULL,NULL,1,'2023-06-10 14:02:39','2023-06-10 14:02:39',NULL),(5961,7768,42131,155787,3,5195,'App\\Models\\Receipt',5195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',71298.04,NULL,NULL,1,'2023-06-10 14:02:40','2023-06-10 14:02:40',NULL),(5962,7768,42131,155787,3,5196,'App\\Models\\Receipt',5196,NULL,NULL,NULL