-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db27-33173687-8
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2021-02-23 15:28:04','Actividad Generica 1','000001',NULL),(2,NULL,'2021-02-23 15:28:04','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
INSERT INTO `back_up_claves_details` VALUES (1,NULL,'Nanitas2014',NULL,1,40721,'2021-04-26'),(2,NULL,'Nanitas2014',NULL,1,40721,'2021-04-26'),(3,NULL,'Lucy130417',NULL,1,40720,'2021-08-11'),(4,'0','Fernandez2020','0',3,40847,'2021-08-11'),(5,NULL,'Nanitas2014',NULL,1,40721,'2021-08-12'),(6,'0','Fernandez2020','0',3,40847,'2021-08-12'),(7,'0','Fernandez2020','0',3,40847,'2021-09-09');
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'nanitasdisenio@gmail.com',NULL,'',1,40721,'2021-04-26'),(2,'nanitasdisenio@gmail.com',NULL,'',1,40721,'2021-04-26'),(3,'lupodisenio@gmail.com',NULL,'',1,40720,'2021-08-11'),(4,'inalgeitos@gmail.com','0','0',1,40866,'2021-08-11'),(5,'walteriofer@gmail.com','0','0',11,40847,'2021-08-11'),(6,'nanitasdisenio@gmail.com',NULL,'',1,40721,'2021-08-12'),(7,'walteriofer@gmail.com','0','0',11,40847,'2021-08-12'),(8,'sol.calomino@hotmail.com','0','0',1,40848,'2021-08-12'),(9,'inalgeitos@gmail.com','0','0',1,40866,'2021-08-12'),(10,'sol.calomino@hotmail.com','0','0',1,40848,'2021-09-09'),(11,'walteriofer@gmail.com','0','0',11,40847,'2021-09-09');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12595 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,2978,40721,3044,2,1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',2600.00,NULL,NULL,1,'2021-04-26 19:26:02','2021-04-26 19:26:02',NULL),(2,2978,40721,3044,2,2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',1000.00,NULL,NULL,1,'2021-04-26 19:26:02','2021-04-26 19:26:02',NULL),(3,2978,40721,3044,2,3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',2000.00,NULL,NULL,1,'2021-04-26 19:26:02','2021-04-26 19:26:02',NULL),(4,2978,40721,3044,2,4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',846.00,NULL,NULL,1,'2021-04-26 19:26:02','2021-04-26 19:26:02',NULL),(5,2978,40721,3044,2,5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',9000.00,NULL,NULL,1,'2021-04-26 19:26:02','2021-04-26 19:26:02',NULL),(6,2978,40721,3044,2,6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',2170.00,NULL,NULL,1,'2021-04-26 19:26:02','2021-04-26 19:26:02',NULL),(7,2978,40721,3044,2,7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',2914.00,NULL,NULL,1,'2021-04-26 19:26:02','2021-04-26 19:26:02',NULL),(8,2978,40721,3044,2,8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',3055.00,NULL,NULL,1,'2021-04-26 19:26:02','2021-04-26 19:26:02',NULL),(9,2978,40721,3044,2,9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',2150.00,NULL,NULL,1,'2021-04-26 19:26:02','2021-04-26 19:26:02',NULL),(10,2978,40721,3044,2,10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',2825.00,NULL,NULL,1,'2021-04-26 19:26:02','2021-04-26 19:26:02',NULL),(11,2978,40721,3044,2,11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',4795.00,NULL,NULL,1,'2021-04-26 19:26:02','2021-04-26 19:26:02',NULL),(12,2978,40721,3044,2,12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',7642.99,NULL,NULL,1,'2021-04-26 19:26:02','2021-04-26 19:26:02',NULL),(13,2978,40721,3044,2,13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',1600.00,NULL,NULL,1,'2021-04-26 19:26:02','2021-04-26 19:26:02',NULL),(14,2978,40721,3044,2,14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',2500.00,NULL,NULL,1,'2021-04-26 19:26:02','2021-04-26 19:26:02',NULL),(15,2978,40721,3044,2,15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',2275.00,NULL,NULL,1,'2021-04-26 19:26:02','2021-04-26 19:26:02',NULL),(16,2978,40721,3044,2,16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',1600.00,NULL,NULL,1,'2021-04-26 19:26:02','2021-04-26 19:26:02',NULL),(17,2978,40721,3044,2,17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',1170.00,NULL,NULL,1,'2021-04-26 19:26:02','2021-04-26 19:26:02',NULL),(18,2978,40721,3044,2,18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',814.50,NULL,NULL,1,'2021-04-26 19:26:02','2021-04-26 19:26:02',NULL),(19,2978,40721,3044,2,19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',880.00,NULL,NULL,1,'2021-04-26 19:26:02','2021-04-26 19:26:02',NULL),(20,2978,40721,3044,2,20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',1611.00,NULL,NULL,1,'2021-04-26 19:26:02','2021-04-26 19:26:02',NULL),(21,2978,40721,3044,2,21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',4910.00,NULL,NULL,1,'2021-04-26 19:26:02','2021-04-26 19:26:02',NULL),(22,2978,40721,3043,2,22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-14','2021-02-14',2767.00,NULL,NULL,1,'2021-04-26 21:54:25','2021-04-26 21:54:25',NULL),(23,2978,40721,3043,2,23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-15','2021-02-15',640.00,NULL,NULL,1,'2021-04-26 21:54:25','2021-04-26 21:54:25',NULL),(24,2978,40721,3043,2,24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-15','2021-02-15',880.00,NULL,NULL,1,'2021-04-26 21:54:25','2021-04-26 21:54:25',NULL),(25,2978,40721,3043,2,25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-15','2021-02-15',499.20,NULL,NULL,1,'2021-04-26 21:54:25','2021-04-26 21:54:25',NULL);
INSERT INTO `balance_libro` VALUES (26,2978,40721,3043,2,26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-15','2021-02-15',576.00,NULL,NULL,1,'2021-04-26 21:54:25','2021-04-26 21:54:25',NULL),(27,2978,40721,3042,2,27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-09','2021-01-09',900.02,NULL,NULL,1,'2021-04-26 21:56:06','2021-04-26 21:56:06',NULL),(28,2978,40721,3042,2,28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-09','2021-01-09',780.00,NULL,NULL,1,'2021-04-26 21:56:06','2021-04-26 21:56:06',NULL),(29,2978,40721,3042,2,29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',1250.00,NULL,NULL,1,'2021-04-26 21:56:06','2021-04-26 21:56:06',NULL),(30,2978,40721,3042,2,30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',1215.50,NULL,NULL,1,'2021-04-26 21:56:06','2021-04-26 21:56:06',NULL),(31,2978,40721,3042,2,31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',2539.50,NULL,NULL,1,'2021-04-26 21:56:06','2021-04-26 21:56:06',NULL),(32,2978,40721,4583,2,32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',940.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(33,2978,40721,4583,2,33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',1890.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(34,2978,40721,4583,2,34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',1170.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(35,2978,40721,4583,2,35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',3746.70,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(36,2978,40721,4583,2,36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',940.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(37,2978,40721,4583,2,37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',2836.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(38,2978,40721,4583,2,38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',2745.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(39,2978,40721,4583,2,39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',1170.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(40,2978,40721,4583,2,40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',1018.55,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(41,2978,40721,4583,2,41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',1894.95,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(42,2978,40721,4583,2,42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',3430.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(43,2978,40721,4583,2,43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',3096.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(44,2978,40721,4583,2,44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',1300.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(45,2978,40721,4583,2,45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',1431.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(46,2978,40721,4583,2,46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',620.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(47,2978,40721,4583,2,47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',1800.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(48,2978,40721,4583,2,48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',2900.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(49,2978,40721,4583,2,49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',1399.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(50,2978,40721,4583,2,50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',846.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL);
INSERT INTO `balance_libro` VALUES (51,2978,40721,4583,2,51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',2850.50,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(52,2978,40721,4583,2,52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',940.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(53,2978,40721,4583,2,53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',1890.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(54,2978,40721,4583,2,54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',4870.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(55,2978,40721,4583,2,55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',1760.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(56,2978,40721,4583,2,56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',940.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(57,2978,40721,4583,2,57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',1980.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(58,2978,40721,4583,2,58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',1980.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(59,2978,40721,4583,2,59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',1100.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(60,2978,40721,4583,2,60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',2200.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(61,2978,40721,4583,2,61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',1720.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(62,2978,40721,4583,2,62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',2040.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(63,2978,40721,4583,2,63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',3920.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(64,2978,40721,4583,2,64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',990.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(65,2978,40721,4583,2,65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',1100.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(66,2978,40721,4583,2,66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',2475.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(67,2978,40721,4583,2,67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',2952.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(68,2978,40721,4583,2,68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',940.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(69,2978,40721,4583,2,69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',4491.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(70,2978,40721,4583,2,70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',4790.13,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(71,2978,40721,4583,2,71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',1647.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(72,2978,40721,4583,2,72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',1350.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(73,2978,40721,4583,2,73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',3535.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(74,2978,40721,4583,2,74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',1100.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(75,2978,40721,4583,2,75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',5300.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL);
INSERT INTO `balance_libro` VALUES (76,2978,40721,4583,2,76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',3535.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(77,2978,40721,4583,2,77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',1100.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(78,2978,40721,4583,2,78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',940.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(79,2978,40721,4583,2,79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',1880.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(80,2978,40721,4583,2,80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',585.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(81,2978,40721,4583,2,81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',1818.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(82,2978,40721,4583,2,82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',3370.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(83,2978,40721,4583,2,83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',2110.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(84,2978,40721,4583,2,84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',3400.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(85,2978,40721,4583,2,85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',1300.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(86,2978,40721,4583,2,86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',3110.02,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(87,2978,40721,4583,2,87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',2600.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(88,2978,40721,4583,2,88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',1300.05,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(89,2978,40721,4583,2,89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',2400.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(90,2978,40721,4583,2,90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',2340.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(91,2978,40721,4583,2,91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',880.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(92,2978,40721,4583,2,92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',4500.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(93,2978,40721,4583,2,93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',6000.00,NULL,NULL,1,'2021-04-26 21:56:23','2021-04-26 21:56:23',NULL),(113,2978,40721,4581,2,113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-01','2020-10-01',1080.00,NULL,NULL,1,'2021-04-26 22:01:26','2021-04-26 22:01:26',NULL),(114,2978,40721,4581,2,114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-04','2020-10-04',3200.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(115,2978,40721,4581,2,115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-04','2020-10-04',1491.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(116,2978,40721,4581,2,116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-04','2020-10-04',3030.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(117,2978,40721,4581,2,117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-04','2020-10-04',1200.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(118,2978,40721,4581,2,118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-04','2020-10-04',1495.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(119,2978,40721,4581,2,119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-04','2020-10-04',11470.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL);
INSERT INTO `balance_libro` VALUES (120,2978,40721,4581,2,120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-06','2020-10-06',3235.50,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(121,2978,40721,4581,2,121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-15','2020-10-15',2461.50,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(122,2978,40721,4581,2,122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-15','2020-10-15',1844.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(123,2978,40721,4581,2,123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-15','2020-10-15',850.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(124,2978,40721,4581,2,124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-15','2020-10-15',900.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(125,2978,40721,4581,2,125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-15','2020-10-15',2133.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(126,2978,40721,4581,2,126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-15','2020-10-15',1300.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(127,2978,40721,4581,2,127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-15','2020-10-15',2050.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(128,2978,40721,4581,2,128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-15','2020-10-15',1836.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(129,2978,40721,4581,2,129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-15','2020-10-15',702.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(130,2978,40721,4581,2,130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-15','2020-10-15',2375.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(131,2978,40721,4581,2,131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-15','2020-10-15',4430.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(132,2978,40721,4581,2,132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-15','2020-10-15',1560.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(133,2978,40721,4581,2,133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-15','2020-10-15',2340.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(134,2978,40721,4581,2,134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-15','2020-10-15',2355.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(135,2978,40721,4581,2,135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-15','2020-10-15',3235.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(136,2978,40721,4581,2,136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-15','2020-10-15',1600.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(137,2978,40721,4581,2,137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-15','2020-10-15',3240.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(138,2978,40721,4581,2,138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-16','2020-10-16',6104.99,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(139,2978,40721,4581,2,139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-17','2020-10-17',1008.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(140,2978,40721,4581,2,140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-19','2020-10-19',810.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(141,2978,40721,4581,2,141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-21','2020-10-21',4720.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(142,2978,40721,4581,2,142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-24','2020-10-24',5415.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(143,2978,40721,4581,2,143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-24','2020-10-24',1500.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(144,2978,40721,4581,2,144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-24','2020-10-24',3140.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL);
INSERT INTO `balance_libro` VALUES (145,2978,40721,4581,2,145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-24','2020-10-24',400.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(146,2978,40721,4581,2,146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-24','2020-10-24',3150.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(147,2978,40721,4581,2,147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-26','2020-10-26',950.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(148,2978,40721,4581,2,148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-26','2020-10-26',1960.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(149,2978,40721,4581,2,149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-26','2020-10-26',2870.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(150,2978,40721,4581,2,150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-27','2020-10-27',2115.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(151,2978,40721,4581,2,151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-27','2020-10-27',1150.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(152,2978,40721,4581,2,152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-27','2020-10-27',1150.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(153,2978,40721,4581,2,153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-28','2020-10-28',1980.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(154,2978,40721,4581,2,154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-28','2020-10-28',880.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(155,2978,40721,4581,2,155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-28','2020-10-28',1550.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(156,2978,40721,4581,2,156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-28','2020-10-28',1000.01,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(157,2978,40721,4581,2,157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-28','2020-10-28',6749.85,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(158,2978,40721,4581,2,158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-28','2020-10-28',555.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(159,2978,40721,4581,2,159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-28','2020-10-28',4063.50,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(160,2978,40721,4581,2,160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-28','2020-10-28',2199.97,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(161,2978,40721,4581,2,161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-28','2020-10-28',2460.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(162,2978,40721,4581,2,162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-28','2020-10-28',1260.01,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(163,2978,40721,4581,2,163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-29','2020-10-29',850.02,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(164,2978,40721,4581,2,164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-29','2020-10-29',2704.99,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(165,2978,40721,4581,2,165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-30','2020-10-30',400.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(166,2978,40721,4581,2,166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-30','2020-10-30',1990.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(167,2978,40721,4581,2,167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-30','2020-10-30',2560.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(168,2978,40721,4581,2,168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-30','2020-10-30',1035.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(169,2978,40721,4581,2,169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',3580.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL);
INSERT INTO `balance_libro` VALUES (170,2978,40721,4581,2,170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',1200.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(171,2978,40721,4581,2,171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',1150.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(172,2978,40721,4581,2,172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',1224.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(173,2978,40721,4581,2,173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',1150.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(174,2978,40721,4581,2,174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',2300.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(175,2978,40721,4581,2,175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',1737.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(176,2978,40721,4581,2,176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',1700.00,NULL,NULL,1,'2021-04-26 22:01:27','2021-04-26 22:01:27',NULL),(177,2978,40721,4581,2,177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',1150.00,NULL,NULL,1,'2021-04-26 22:01:28','2021-04-26 22:01:28',NULL),(178,2978,40721,4581,2,178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',2300.00,NULL,NULL,1,'2021-04-26 22:01:28','2021-04-26 22:01:28',NULL),(179,2978,40721,4581,2,179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',1150.00,NULL,NULL,1,'2021-04-26 22:01:28','2021-04-26 22:01:28',NULL),(180,2978,40721,4581,2,180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',1080.00,NULL,NULL,1,'2021-04-26 22:01:28','2021-04-26 22:01:28',NULL),(181,2978,40721,4581,2,181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',1200.00,NULL,NULL,1,'2021-04-26 22:01:28','2021-04-26 22:01:28',NULL),(182,2978,40721,4581,2,182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',1035.00,NULL,NULL,1,'2021-04-26 22:01:28','2021-04-26 22:01:28',NULL),(183,2978,40721,4581,2,183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',4600.00,NULL,NULL,1,'2021-04-26 22:01:28','2021-04-26 22:01:28',NULL),(184,2978,40721,4581,2,184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',1530.00,NULL,NULL,1,'2021-04-26 22:01:28','2021-04-26 22:01:28',NULL),(233,2978,40721,4578,2,233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-03','2020-07-03',2080.00,NULL,NULL,1,'2021-04-26 22:02:58','2021-04-26 22:02:58',NULL),(234,2978,40721,4578,2,234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-03','2020-07-03',1230.00,NULL,NULL,1,'2021-04-26 22:02:58','2021-04-26 22:02:58',NULL),(235,2978,40721,4578,2,235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-03','2020-07-03',1704.99,NULL,NULL,1,'2021-04-26 22:02:58','2021-04-26 22:02:58',NULL),(236,2978,40721,4578,2,236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-03','2020-07-03',830.00,NULL,NULL,1,'2021-04-26 22:02:58','2021-04-26 22:02:58',NULL),(237,2978,40721,4578,2,237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-03','2020-07-03',2130.00,NULL,NULL,1,'2021-04-26 22:02:58','2021-04-26 22:02:58',NULL),(238,2978,40721,4578,2,238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-03','2020-07-03',2539.99,NULL,NULL,1,'2021-04-26 22:02:58','2021-04-26 22:02:58',NULL),(239,2978,40721,4578,2,239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-03','2020-07-03',1975.00,NULL,NULL,1,'2021-04-26 22:02:58','2021-04-26 22:02:58',NULL),(240,2978,40721,4578,2,240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-03','2020-07-03',1625.00,NULL,NULL,1,'2021-04-26 22:02:58','2021-04-26 22:02:58',NULL),(241,2978,40721,4578,2,241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-04','2020-07-04',860.00,NULL,NULL,1,'2021-04-26 22:02:58','2021-04-26 22:02:58',NULL),(242,2978,40721,4578,2,242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-04','2020-07-04',1430.00,NULL,NULL,1,'2021-04-26 22:02:58','2021-04-26 22:02:58',NULL);
INSERT INTO `balance_libro` VALUES (243,2978,40721,4578,2,243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-04','2020-07-04',3260.00,NULL,NULL,1,'2021-04-26 22:02:58','2021-04-26 22:02:58',NULL),(244,2978,40721,4578,2,244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-04','2020-07-04',1154.99,NULL,NULL,1,'2021-04-26 22:02:58','2021-04-26 22:02:58',NULL),(245,2978,40721,4578,2,245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-04','2020-07-04',1120.00,NULL,NULL,1,'2021-04-26 22:02:58','2021-04-26 22:02:58',NULL),(246,2978,40721,4578,2,246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-04','2020-07-04',750.00,NULL,NULL,1,'2021-04-26 22:02:58','2021-04-26 22:02:58',NULL),(247,2978,40721,4578,2,247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-04','2020-07-04',2130.00,NULL,NULL,1,'2021-04-26 22:02:58','2021-04-26 22:02:58',NULL),(248,2978,40721,4578,2,248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-05','2020-07-05',2478.00,NULL,NULL,1,'2021-04-26 22:02:58','2021-04-26 22:02:58',NULL),(249,2978,40721,4578,2,249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-05','2020-07-05',3050.00,NULL,NULL,1,'2021-04-26 22:02:58','2021-04-26 22:02:58',NULL),(250,2978,40721,4578,2,250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-05','2020-07-05',2330.00,NULL,NULL,1,'2021-04-26 22:02:58','2021-04-26 22:02:58',NULL),(251,2978,40721,4578,2,251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-05','2020-07-05',1630.00,NULL,NULL,1,'2021-04-26 22:02:58','2021-04-26 22:02:58',NULL),(252,2978,40721,4578,2,252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-05','2020-07-05',1540.00,NULL,NULL,1,'2021-04-26 22:02:58','2021-04-26 22:02:58',NULL),(253,2978,40721,4578,2,253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-06','2020-07-06',2315.00,NULL,NULL,1,'2021-04-26 22:02:58','2021-04-26 22:02:58',NULL),(254,2978,40721,4578,2,254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-07','2020-07-07',2420.00,NULL,NULL,1,'2021-04-26 22:02:58','2021-04-26 22:02:58',NULL),(255,2978,40721,4578,2,255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-07','2020-07-07',2050.00,NULL,NULL,1,'2021-04-26 22:02:58','2021-04-26 22:02:58',NULL),(256,2978,40721,4578,2,256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-07','2020-07-07',1430.00,NULL,NULL,1,'2021-04-26 22:02:58','2021-04-26 22:02:58',NULL),(257,2978,40721,4578,2,257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-07','2020-07-07',2830.00,NULL,NULL,1,'2021-04-26 22:02:58','2021-04-26 22:02:58',NULL),(258,2978,40721,4578,2,258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-07','2020-07-07',2280.00,NULL,NULL,1,'2021-04-26 22:02:58','2021-04-26 22:02:58',NULL),(259,2978,40721,4578,2,259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-07','2020-07-07',1050.00,NULL,NULL,1,'2021-04-26 22:02:58','2021-04-26 22:02:58',NULL),(260,2978,40721,4578,2,260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-07','2020-07-07',830.00,NULL,NULL,1,'2021-04-26 22:02:58','2021-04-26 22:02:58',NULL),(261,2978,40721,4578,2,261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-08','2020-07-08',1920.00,NULL,NULL,1,'2021-04-26 22:02:58','2021-04-26 22:02:58',NULL),(262,2978,40721,4578,2,262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-08','2020-07-08',1430.00,NULL,NULL,1,'2021-04-26 22:02:58','2021-04-26 22:02:58',NULL),(263,2978,40721,4578,2,263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-08','2020-07-08',1300.00,NULL,NULL,1,'2021-04-26 22:02:58','2021-04-26 22:02:58',NULL),(264,2978,40721,4578,2,264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-09','2020-07-09',1930.00,NULL,NULL,1,'2021-04-26 22:02:58','2021-04-26 22:02:58',NULL),(265,2978,40721,4578,2,265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-30','2020-07-30',1287.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(266,2978,40721,4578,2,266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-30','2020-07-30',450.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(267,2978,40721,4578,2,267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-30','2020-07-30',3770.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL);
INSERT INTO `balance_libro` VALUES (268,2978,40721,4578,2,268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-30','2020-07-30',400.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(269,2978,40721,4578,2,269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-30','2020-07-30',1777.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(270,2978,40721,4578,2,270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-30','2020-07-30',1230.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(271,2978,40721,4578,2,271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-30','2020-07-30',1500.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(272,2978,40721,4578,2,272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-30','2020-07-30',1300.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(273,2978,40721,4578,2,273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-30','2020-07-30',340.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(274,2978,40721,4578,2,274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-30','2020-07-30',3010.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(275,2978,40721,4578,2,275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-30','2020-07-30',930.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(276,2978,40721,4578,2,276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-30','2020-07-30',3057.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(277,2978,40721,4578,2,277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-30','2020-07-30',5587.99,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(278,2978,40721,4578,2,278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',1200.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(279,2978,40721,4578,2,279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',560.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(280,2978,40721,4578,2,280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',1370.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(281,2978,40721,4578,2,281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',940.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(282,2978,40721,4578,2,282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',1186.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(283,2978,40721,4578,2,283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',1696.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(284,2978,40721,4578,2,284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',2645.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(285,2978,40721,4578,2,285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',2080.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(286,2978,40721,4578,2,286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',788.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(287,2978,40721,4578,2,287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',2190.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(288,2978,40721,4578,2,288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',3135.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(289,2978,40721,4578,2,289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',1515.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(290,2978,40721,4578,2,290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',606.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(291,2978,40721,4578,2,291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',2330.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(292,2978,40721,4578,2,292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',1070.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL);
INSERT INTO `balance_libro` VALUES (293,2978,40721,4578,2,293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',1080.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(294,2978,40721,4578,2,294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',1990.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(295,2978,40721,4578,2,295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',160.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(296,2978,40721,4578,2,296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',2330.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(297,2978,40721,4578,2,297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',3906.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(298,2978,40721,4578,2,298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',1493.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(299,2978,40721,4578,2,299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',1860.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(300,2978,40721,4578,2,300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',1500.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(301,2978,40721,4578,2,301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',650.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(302,2978,40721,4578,2,302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',2115.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(303,2978,40721,4578,2,303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',3324.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(304,2978,40721,4578,2,304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',1645.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(305,2978,40721,4578,2,305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',2279.99,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(306,2978,40721,4578,2,306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',1800.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(307,2978,40721,4578,2,307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',2600.05,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(308,2978,40721,4578,2,308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',660.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(309,2978,40721,4578,2,309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',3000.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(310,2978,40721,4578,2,310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',160.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(311,2978,40721,4578,2,311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',1265.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(312,2978,40721,4578,2,312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',2551.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(313,2978,40721,4578,2,313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',3315.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(314,2978,40721,4578,2,314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',650.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(315,2978,40721,4578,2,315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',1760.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(316,2978,40721,4578,2,316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',1460.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(317,2978,40721,4578,2,317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',4270.13,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL);
INSERT INTO `balance_libro` VALUES (318,2978,40721,4578,2,318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',2520.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(319,2978,40721,4578,2,319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',2860.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(320,2978,40721,4578,2,320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',2550.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(321,2978,40721,4578,2,321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',650.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(322,2978,40721,4578,2,322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',1360.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(323,2978,40721,4578,2,323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',1950.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(324,2978,40721,4578,2,324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',2700.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(325,2978,40721,4578,2,325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',1380.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(326,2978,40721,4578,2,326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',300.00,NULL,NULL,1,'2021-04-26 22:02:59','2021-04-26 22:02:59',NULL),(327,2978,40847,4588,2,327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',1800.00,NULL,NULL,1,'2021-07-12 23:43:02','2021-07-12 23:43:02',NULL),(328,2978,40847,4588,2,328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',1800.00,NULL,NULL,1,'2021-07-12 23:43:02','2021-07-12 23:43:02',NULL),(329,2978,40847,4588,2,329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',5400.00,NULL,NULL,1,'2021-07-12 23:43:02','2021-07-12 23:43:02',NULL),(330,2978,40847,4588,2,330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',4088.75,NULL,NULL,1,'2021-07-12 23:43:02','2021-07-12 23:43:02',NULL),(379,2978,40847,4589,2,379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-06','2021-06-06',4500.00,NULL,NULL,1,'2021-07-24 05:47:53','2021-07-24 05:47:53',NULL),(380,2978,40847,4589,2,380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',280.46,NULL,NULL,1,'2021-07-24 05:54:21','2021-07-24 05:54:21',NULL),(381,2978,40847,4589,2,381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',519.36,NULL,NULL,1,'2021-07-24 06:00:34','2021-07-24 06:00:34',NULL),(382,2978,40848,6099,2,382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',44826.00,NULL,NULL,1,'2021-07-24 20:15:40','2021-07-24 20:15:40',NULL),(383,2978,40848,6100,2,383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',44826.00,NULL,NULL,1,'2021-07-24 20:19:13','2021-07-24 20:19:13',NULL),(384,2978,40848,6101,2,384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',44826.00,NULL,NULL,1,'2021-07-24 20:21:32','2021-07-24 20:21:32',NULL),(385,2978,40867,34885,2,385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',45427.00,NULL,NULL,1,'2021-07-24 20:39:19','2021-07-24 20:39:19',NULL),(386,2978,40867,34886,2,386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',45427.00,NULL,NULL,1,'2021-07-24 20:43:01','2021-07-24 20:43:01',NULL),(387,2978,40867,34887,2,387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',4088.00,NULL,NULL,1,'2021-07-24 20:46:51','2021-07-24 20:46:51',NULL),(388,2978,40867,34887,2,388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',49515.00,NULL,NULL,1,'2021-07-24 20:49:12','2021-07-24 20:49:12',NULL),(389,2978,40867,34888,2,389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',49515.00,NULL,NULL,1,'2021-07-24 20:51:46','2021-07-24 20:51:46',NULL),(390,2978,40867,34889,2,390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',49515.00,NULL,NULL,1,'2021-07-24 20:54:28','2021-07-24 20:54:28',NULL);
INSERT INTO `balance_libro` VALUES (391,2978,40868,36402,2,391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',450.00,NULL,NULL,1,'2021-07-24 21:00:29','2021-07-24 21:00:29',NULL),(392,2978,40868,36402,2,392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',600.00,NULL,NULL,1,'2021-07-24 21:02:30','2021-07-24 21:02:30',NULL),(393,2978,40868,36402,2,393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',500.00,NULL,NULL,1,'2021-07-24 21:04:33','2021-07-24 21:04:33',NULL),(394,2978,40868,36402,2,394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',605.00,NULL,NULL,1,'2021-07-24 21:07:03','2021-07-24 21:07:03',NULL),(395,2978,40868,36402,2,395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',660.00,NULL,NULL,1,'2021-07-24 21:08:47','2021-07-24 21:08:47',NULL),(396,2978,40868,36402,2,396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',715.00,NULL,NULL,1,'2021-07-24 21:12:11','2021-07-24 21:12:11',NULL),(397,2978,40868,36402,2,397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',600.00,NULL,NULL,1,'2021-07-24 21:15:51','2021-07-24 21:15:51',NULL),(398,2978,40868,36402,2,398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',500.00,NULL,NULL,1,'2021-07-24 21:18:02','2021-07-24 21:18:02',NULL),(399,2978,40868,36403,2,399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',720.00,NULL,NULL,1,'2021-07-24 21:25:56','2021-07-24 21:25:56',NULL),(400,2978,40868,36403,2,400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',700.00,NULL,NULL,1,'2021-07-24 21:28:08','2021-07-24 21:28:08',NULL),(401,2978,40868,36403,2,401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',600.00,NULL,NULL,1,'2021-07-24 21:31:39','2021-07-24 21:31:39',NULL),(402,2978,40868,36403,2,402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',720.00,NULL,NULL,1,'2021-07-24 21:34:26','2021-07-24 21:34:26',NULL),(403,2978,40868,36403,2,403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',660.00,NULL,NULL,1,'2021-07-24 21:37:02','2021-07-24 21:37:02',NULL),(404,2978,40868,36403,2,404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',660.00,NULL,NULL,1,'2021-07-24 21:40:21','2021-07-24 21:40:21',NULL),(405,2978,40868,36403,2,405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',700.00,NULL,NULL,1,'2021-07-24 21:42:57','2021-07-24 21:42:57',NULL),(406,2978,40868,36403,2,406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',900.00,NULL,NULL,1,'2021-07-24 21:44:35','2021-07-24 21:44:35',NULL),(407,2978,40868,36403,2,407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',600.00,NULL,NULL,1,'2021-07-24 21:47:02','2021-07-24 21:47:02',NULL),(408,2978,40868,36403,2,408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',700.00,NULL,NULL,1,'2021-07-25 04:51:33','2021-07-25 04:51:33',NULL),(409,2978,40868,36403,2,409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',600.00,NULL,NULL,1,'2021-07-25 04:53:30','2021-07-25 04:53:30',NULL),(410,2978,40868,36403,2,410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',500.00,NULL,NULL,1,'2021-07-25 04:55:15','2021-07-25 04:55:15',NULL),(411,2978,40868,36403,2,411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',600.00,NULL,NULL,1,'2021-07-25 04:56:57','2021-07-25 04:56:57',NULL),(412,2978,40868,36403,2,412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',700.00,NULL,NULL,1,'2021-07-25 05:08:15','2021-07-25 05:08:15',NULL),(413,2978,40868,36403,2,413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',60.00,NULL,NULL,1,'2021-07-25 05:09:45','2021-07-25 05:09:45',NULL),(414,2978,40868,36403,2,414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',600.00,NULL,NULL,1,'2021-07-25 05:11:39','2021-07-25 05:11:39',NULL),(415,2978,40868,36403,2,415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',700.00,NULL,NULL,1,'2021-07-25 05:13:37','2021-07-25 05:13:37',NULL);
INSERT INTO `balance_libro` VALUES (416,2978,40868,36403,2,416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',600.00,NULL,NULL,1,'2021-07-25 05:16:23','2021-07-25 05:16:23',NULL),(417,2978,40868,36403,2,417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',700.00,NULL,NULL,1,'2021-07-25 05:18:41','2021-07-25 05:18:41',NULL),(418,2978,40868,36403,2,418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',600.00,NULL,NULL,1,'2021-07-25 05:22:15','2021-07-25 05:22:15',NULL),(419,2978,40868,36403,2,419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',600.00,NULL,NULL,1,'2021-07-25 05:24:18','2021-07-25 05:24:18',NULL),(420,2978,40871,37914,2,423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',40000.00,NULL,NULL,1,'2021-07-27 20:45:46','2021-07-27 20:45:46',NULL),(421,2978,40871,37915,2,424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',40000.00,NULL,NULL,1,'2021-07-27 21:25:54','2021-07-27 21:25:54',NULL),(422,2978,40871,37916,2,425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',40000.00,NULL,NULL,1,'2021-07-27 21:28:47','2021-07-27 21:28:47',NULL),(423,2978,40871,37917,2,426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',40000.00,NULL,NULL,1,'2021-07-27 21:30:41','2021-07-27 21:30:41',NULL),(424,2978,40871,37918,2,427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',10750.00,NULL,NULL,1,'2021-07-27 21:33:30','2021-07-27 21:33:30',NULL),(425,2978,40871,37918,2,428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',40000.00,NULL,NULL,1,'2021-07-27 21:35:12','2021-07-27 21:35:12',NULL),(426,2978,40871,37919,2,429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',40000.00,NULL,NULL,1,'2021-07-27 21:37:19','2021-07-27 21:37:19',NULL),(427,2978,40873,40947,2,430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',10000.00,NULL,NULL,1,'2021-07-27 21:42:28','2021-07-27 21:42:28',NULL),(428,2978,40873,40947,2,431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',4500.00,NULL,NULL,1,'2021-07-27 21:44:03','2021-07-27 21:44:03',NULL),(429,2978,40874,42461,2,432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',136000.00,NULL,NULL,1,'2021-07-27 22:01:56','2021-07-27 22:01:56',NULL),(430,2978,40874,42462,2,433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',96410.00,NULL,NULL,1,'2021-07-27 22:04:43','2021-07-27 22:04:43',NULL),(431,2978,40874,42462,2,434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',15200.00,NULL,NULL,1,'2021-07-27 22:58:28','2021-07-27 22:58:28',NULL),(432,2978,40874,42462,2,435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',4200.00,NULL,NULL,1,'2021-07-27 23:01:03','2021-07-27 23:01:03',NULL),(433,2978,40874,42462,2,436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',100000.00,NULL,NULL,1,'2021-07-27 23:03:48','2021-07-27 23:03:48',NULL),(434,2978,40868,36404,2,437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',800.00,NULL,NULL,1,'2021-07-28 04:54:17','2021-07-28 04:54:17',NULL),(435,2978,40868,36404,2,438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',700.00,NULL,NULL,1,'2021-07-28 04:56:16','2021-07-28 04:56:16',NULL),(436,2978,40868,36404,2,439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',800.00,NULL,NULL,1,'2021-07-28 04:57:51','2021-07-28 04:57:51',NULL),(437,2978,40868,36404,2,440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',800.00,NULL,NULL,1,'2021-07-28 05:00:00','2021-07-28 05:00:00',NULL),(438,2978,40868,36404,2,441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',60.00,NULL,NULL,1,'2021-07-28 05:03:00','2021-07-28 05:03:00',NULL),(439,2978,40868,36404,2,442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',800.00,NULL,NULL,1,'2021-07-28 05:04:32','2021-07-28 05:04:32',NULL),(440,2978,40868,36404,2,443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',800.00,NULL,NULL,1,'2021-07-29 05:00:27','2021-07-29 05:00:27',NULL);
INSERT INTO `balance_libro` VALUES (441,2978,40868,36404,2,444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',700.00,NULL,NULL,1,'2021-07-29 05:01:47','2021-07-29 05:01:47',NULL),(442,2978,40868,36404,2,445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',700.00,NULL,NULL,1,'2021-07-29 05:03:28','2021-07-29 05:03:28',NULL),(443,2978,40868,36404,2,446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',700.00,NULL,NULL,1,'2021-07-29 05:04:54','2021-07-29 05:04:54',NULL),(444,2978,40868,36404,2,447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',700.00,NULL,NULL,1,'2021-07-29 05:06:04','2021-07-29 05:06:04',NULL),(445,2978,40868,36404,2,448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',700.00,NULL,NULL,1,'2021-07-29 05:07:29','2021-07-29 05:07:29',NULL),(446,2978,40868,36404,2,449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',700.00,NULL,NULL,1,'2021-07-29 05:09:08','2021-07-29 05:09:08',NULL),(447,2978,40868,36404,2,450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',700.00,NULL,NULL,1,'2021-07-29 05:10:20','2021-07-29 05:10:20',NULL),(448,2978,40868,36404,2,451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',700.00,NULL,NULL,1,'2021-07-29 05:11:39','2021-07-29 05:11:39',NULL),(449,2978,40868,36404,2,452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',600.00,NULL,NULL,1,'2021-07-29 05:13:02','2021-07-29 05:13:02',NULL),(450,2978,40868,36404,2,453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',700.00,NULL,NULL,1,'2021-07-29 05:14:19','2021-07-29 05:14:19',NULL),(451,2978,40868,36404,2,454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',600.00,NULL,NULL,1,'2021-07-29 05:16:26','2021-07-29 05:16:26',NULL),(452,2978,40868,36404,2,455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',700.00,NULL,NULL,1,'2021-07-29 05:17:44','2021-07-29 05:17:44',NULL),(453,2978,40868,36404,2,456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',700.00,NULL,NULL,1,'2021-07-29 05:19:23','2021-07-29 05:19:23',NULL),(454,2978,40874,42464,2,457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',100000.00,NULL,NULL,1,'2021-07-29 05:23:45','2021-08-20 11:07:19','2021-08-20 11:07:19'),(455,2978,40874,42463,2,458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',109280.00,NULL,NULL,1,'2021-07-29 05:25:53','2021-07-29 05:25:53',NULL),(456,2978,40874,42463,2,459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',187000.00,NULL,NULL,1,'2021-07-29 05:27:50','2021-07-29 05:27:50',NULL),(457,2978,40874,42463,2,460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',25800.00,NULL,NULL,1,'2021-07-29 05:29:31','2021-07-29 05:29:31',NULL),(458,2978,40874,42463,2,461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',3300.00,NULL,NULL,1,'2021-07-29 05:31:29','2021-07-29 05:31:29',NULL),(459,2978,40721,3048,2,462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',2600.01,NULL,NULL,1,'2021-08-03 14:30:15','2021-08-03 14:30:15',NULL),(460,2978,40721,3048,2,463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',3343.19,NULL,NULL,1,'2021-08-03 14:30:15','2021-08-03 14:30:15',NULL),(461,2978,40721,3048,2,464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',3293.98,NULL,NULL,1,'2021-08-03 14:30:15','2021-08-03 14:30:15',NULL),(462,2978,40721,3048,2,465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',2520.00,NULL,NULL,1,'2021-08-03 14:30:15','2021-08-03 14:30:15',NULL),(463,2978,40721,3048,2,466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',5418.26,NULL,NULL,1,'2021-08-03 14:30:15','2021-08-03 14:30:15',NULL),(464,2978,40721,3048,2,467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',2950.00,NULL,NULL,1,'2021-08-03 14:30:15','2021-08-03 14:30:15',NULL),(465,2978,40721,3048,2,468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',1430.00,NULL,NULL,1,'2021-08-03 14:30:16','2021-08-03 14:30:16',NULL);
INSERT INTO `balance_libro` VALUES (466,2978,40721,3048,2,469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',2524.19,NULL,NULL,1,'2021-08-03 14:30:16','2021-08-03 14:30:16',NULL),(467,2978,40721,3048,2,470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',8210.00,NULL,NULL,1,'2021-08-03 14:30:16','2021-08-03 14:30:16',NULL),(468,2978,40721,3048,2,471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',3600.00,NULL,NULL,1,'2021-08-03 14:30:16','2021-08-03 14:30:16',NULL),(469,2978,40721,3048,2,472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',2218.34,NULL,NULL,1,'2021-08-03 14:30:16','2021-08-03 14:30:16',NULL),(470,2978,40721,3048,2,473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',1399.19,NULL,NULL,1,'2021-08-03 14:30:16','2021-08-03 14:30:16',NULL),(480,2978,40720,1535,2,483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',14400.00,NULL,NULL,1,'2021-08-03 16:29:31','2021-08-03 16:29:31',NULL),(481,2978,40720,1535,2,484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',6000.00,NULL,NULL,1,'2021-08-03 16:29:31','2021-08-03 16:29:31',NULL),(482,2978,40720,1535,2,485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',5490.00,NULL,NULL,1,'2021-08-03 16:29:31','2021-08-03 16:29:31',NULL),(483,2978,40720,1535,2,486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',9000.00,NULL,NULL,1,'2021-08-03 16:29:31','2021-08-03 16:29:31',NULL),(484,2978,40720,1535,2,487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',21000.00,NULL,NULL,1,'2021-08-03 16:29:31','2021-08-03 16:29:31',NULL),(485,2978,40720,1535,2,488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',11500.00,NULL,NULL,1,'2021-08-03 16:29:31','2021-08-03 16:29:31',NULL),(486,2978,40720,1535,2,489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',5000.00,NULL,NULL,1,'2021-08-03 16:29:31','2021-08-03 16:29:31',NULL),(487,2978,40720,1534,2,490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',6000.00,NULL,NULL,1,'2021-08-03 16:46:13','2021-08-03 16:46:13',NULL),(488,2978,40720,1534,2,491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',4500.00,NULL,NULL,1,'2021-08-03 16:46:13','2021-08-03 16:46:13',NULL),(489,2978,40720,1534,2,492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',4600.00,NULL,NULL,1,'2021-08-03 16:46:13','2021-08-03 16:46:13',NULL),(490,2978,40720,1534,2,493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',8400.00,NULL,NULL,1,'2021-08-03 16:46:13','2021-08-03 16:46:13',NULL),(491,2978,40720,1534,2,494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',3500.00,NULL,NULL,1,'2021-08-03 16:46:13','2021-08-03 16:46:13',NULL),(492,2978,40720,1534,2,495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',3000.00,NULL,NULL,1,'2021-08-03 16:46:13','2021-08-03 16:46:13',NULL),(493,2978,40720,1534,2,496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',4100.00,NULL,NULL,1,'2021-08-03 16:46:13','2021-08-03 16:46:13',NULL),(494,2978,40720,1534,2,497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',7500.00,NULL,NULL,1,'2021-08-03 16:46:13','2021-08-03 16:46:13',NULL),(495,2978,40720,1533,2,498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',17000.00,NULL,NULL,1,'2021-08-03 17:49:54','2021-08-03 17:49:54',NULL),(496,2978,40720,1533,2,499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',1650.00,NULL,NULL,1,'2021-08-03 17:49:54','2021-08-03 17:49:54',NULL),(497,2978,40720,1533,2,500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',1650.00,NULL,NULL,1,'2021-08-03 17:49:54','2021-08-03 17:49:54',NULL),(498,2978,40720,1533,2,501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',6000.00,NULL,NULL,1,'2021-08-03 17:49:54','2021-08-03 17:49:54',NULL),(499,2978,40720,1533,2,502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',6000.00,NULL,NULL,1,'2021-08-03 17:49:54','2021-08-03 17:49:54',NULL);
INSERT INTO `balance_libro` VALUES (500,2978,40720,1533,2,503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',4018.00,NULL,NULL,1,'2021-08-03 17:49:54','2021-08-03 17:49:54',NULL),(501,2978,40720,1532,2,504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',7200.00,NULL,NULL,1,'2021-08-03 19:08:40','2021-08-03 19:08:40',NULL),(502,2978,40720,1532,2,505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',2500.00,NULL,NULL,1,'2021-08-03 19:08:40','2021-08-03 19:08:40',NULL),(503,2978,40720,1532,2,506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',10000.00,NULL,NULL,1,'2021-08-03 19:08:40','2021-08-03 19:08:40',NULL),(528,2978,40720,1531,2,531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',1500.00,NULL,NULL,1,'2021-08-03 19:23:22','2021-08-03 19:23:22',NULL),(529,2978,40720,1531,2,532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',7500.00,NULL,NULL,1,'2021-08-03 19:26:06','2021-08-03 19:26:06',NULL),(530,2978,40720,1531,2,533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',4000.00,NULL,NULL,1,'2021-08-03 19:28:40','2021-08-03 19:28:40',NULL),(531,2978,40720,1531,2,534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',9500.00,NULL,NULL,1,'2021-08-03 19:31:23','2021-08-03 19:31:23',NULL),(532,2978,40720,1531,2,535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',6500.00,NULL,NULL,1,'2021-08-03 19:33:03','2021-08-03 19:33:03',NULL),(533,2978,40720,1531,2,536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',4900.00,NULL,NULL,1,'2021-08-03 19:35:25','2021-08-03 19:35:25',NULL),(534,2978,40720,1531,2,537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',20400.00,NULL,NULL,1,'2021-08-03 19:37:22','2021-08-03 19:37:22',NULL),(535,2978,40720,1531,2,538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',13000.00,NULL,NULL,1,'2021-08-03 19:39:23','2021-08-03 19:39:23',NULL),(536,2978,40720,1531,2,539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',2200.00,NULL,NULL,1,'2021-08-03 19:41:43','2021-08-03 19:41:43',NULL),(537,2978,40720,1531,2,540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',10800.00,NULL,NULL,1,'2021-08-03 19:43:33','2021-08-03 19:43:33',NULL),(538,2978,40720,1531,2,541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',4420.00,NULL,NULL,1,'2021-08-03 19:46:04','2021-08-03 19:46:04',NULL),(539,2978,40866,33374,2,542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',1800.00,NULL,NULL,1,'2021-08-03 21:34:02','2021-08-03 21:34:02',NULL),(540,2978,40866,33374,2,543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',3200.00,NULL,NULL,1,'2021-08-03 21:34:02','2021-08-03 21:34:02',NULL),(541,2978,40866,33374,2,544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',2800.00,NULL,NULL,1,'2021-08-03 21:34:02','2021-08-03 21:34:02',NULL),(542,2978,40866,33374,2,545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',2800.00,NULL,NULL,1,'2021-08-03 21:34:02','2021-08-03 21:34:02',NULL),(543,2978,40866,33374,2,546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',2800.00,NULL,NULL,1,'2021-08-03 21:34:02','2021-08-03 21:34:02',NULL),(544,2978,40866,33374,2,547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',3200.00,NULL,NULL,1,'2021-08-03 21:34:02','2021-08-03 21:34:02',NULL),(545,2978,40866,33373,2,548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',1800.00,NULL,NULL,1,'2021-08-03 21:42:53','2021-08-03 21:42:53',NULL),(546,2978,40866,33373,2,549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',1800.00,NULL,NULL,1,'2021-08-03 21:42:53','2021-08-03 21:42:53',NULL),(547,2978,40866,33373,2,550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',1800.00,NULL,NULL,1,'2021-08-03 21:42:53','2021-08-03 21:42:53',NULL),(548,2978,40866,33373,2,551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',2800.00,NULL,NULL,1,'2021-08-03 21:42:53','2021-08-03 21:42:53',NULL);
INSERT INTO `balance_libro` VALUES (549,2978,40866,33373,2,552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',3600.00,NULL,NULL,1,'2021-08-03 21:42:53','2021-08-03 21:42:53',NULL),(550,2978,40866,33370,2,553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',80.00,NULL,NULL,1,'2021-08-03 21:45:29','2021-08-03 21:45:29',NULL),(551,2978,40866,33370,2,554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',2450.00,NULL,NULL,1,'2021-08-03 21:45:29','2021-08-03 21:45:29',NULL),(552,2978,40866,33370,2,555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',2450.00,NULL,NULL,1,'2021-08-03 21:45:29','2021-08-03 21:45:29',NULL),(553,2978,40866,33370,2,556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',1400.00,NULL,NULL,1,'2021-08-03 21:45:29','2021-08-03 21:45:29',NULL),(554,2978,40866,33370,2,557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',1400.00,NULL,NULL,1,'2021-08-03 21:45:29','2021-08-03 21:45:29',NULL),(555,2978,40866,33370,2,558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',2400.00,NULL,NULL,1,'2021-08-03 21:45:29','2021-08-03 21:45:29',NULL),(556,2978,40866,33370,2,559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',2800.00,NULL,NULL,1,'2021-08-03 21:45:29','2021-08-03 21:45:29',NULL),(557,2978,40866,33370,2,560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',2800.00,NULL,NULL,1,'2021-08-03 21:45:29','2021-08-03 21:45:29',NULL),(558,2978,40866,33370,2,561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',3200.00,NULL,NULL,1,'2021-08-03 21:45:29','2021-08-03 21:45:29',NULL),(559,2978,40866,33370,2,562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',3400.00,NULL,NULL,1,'2021-08-03 21:45:29','2021-08-03 21:45:29',NULL),(560,2978,40866,33369,2,563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',2300.00,NULL,NULL,1,'2021-08-03 21:47:58','2021-08-03 21:47:58',NULL),(561,2978,40866,33369,2,564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',2450.00,NULL,NULL,1,'2021-08-03 21:47:58','2021-08-03 21:47:58',NULL),(562,2978,40866,33369,2,565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',2450.00,NULL,NULL,1,'2021-08-03 21:47:58','2021-08-03 21:47:58',NULL),(563,2978,40866,33369,2,566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',1400.00,NULL,NULL,1,'2021-08-03 21:47:58','2021-08-03 21:47:58',NULL),(564,2978,40866,33369,2,567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',1400.00,NULL,NULL,1,'2021-08-03 21:47:58','2021-08-03 21:47:58',NULL),(565,2978,40866,33369,2,568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',2450.00,NULL,NULL,1,'2021-08-03 21:47:58','2021-08-03 21:47:58',NULL),(566,2978,40866,33369,2,569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',1800.00,NULL,NULL,1,'2021-08-03 21:47:58','2021-08-03 21:47:58',NULL),(567,2978,40866,33369,2,570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',2400.00,NULL,NULL,1,'2021-08-03 21:47:58','2021-08-03 21:47:58',NULL),(568,2978,40866,33369,2,571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',2400.00,NULL,NULL,1,'2021-08-03 21:47:58','2021-08-03 21:47:58',NULL),(569,2978,40866,33369,2,572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',1400.00,NULL,NULL,1,'2021-08-03 21:47:58','2021-08-03 21:47:58',NULL),(570,2978,40866,33369,2,573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',2450.00,NULL,NULL,1,'2021-08-03 21:47:58','2021-08-03 21:47:58',NULL),(571,2978,40866,33369,2,574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',1800.00,NULL,NULL,1,'2021-08-03 21:47:58','2021-08-03 21:47:58',NULL),(572,2978,40866,33369,2,575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',1400.00,NULL,NULL,1,'2021-08-03 21:47:58','2021-08-03 21:47:58',NULL),(573,2978,40866,33369,2,576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',1800.00,NULL,NULL,1,'2021-08-03 21:47:58','2021-08-03 21:47:58',NULL);
INSERT INTO `balance_libro` VALUES (574,2978,40866,33369,2,577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',2450.00,NULL,NULL,1,'2021-08-03 21:47:58','2021-08-03 21:47:58',NULL),(575,2978,40866,33369,2,578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',2450.00,NULL,NULL,1,'2021-08-03 21:47:58','2021-08-03 21:47:58',NULL),(576,2978,40866,33369,2,579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',2450.00,NULL,NULL,1,'2021-08-03 21:47:58','2021-08-03 21:47:58',NULL),(577,2978,40866,33369,2,580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',1500.00,NULL,NULL,1,'2021-08-03 21:47:59','2021-08-03 21:47:59',NULL),(578,2978,40866,33369,2,581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',1400.00,NULL,NULL,1,'2021-08-03 21:47:59','2021-08-03 21:47:59',NULL),(585,2978,40720,43976,2,588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-12','2020-06-12',5000.00,NULL,NULL,1,'2021-08-11 10:53:52','2021-08-11 10:56:19','2021-08-11 10:56:19'),(586,2978,40720,43976,2,589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',4800.00,NULL,NULL,1,'2021-08-11 10:55:52','2021-08-11 10:55:52',NULL),(587,2978,40720,43976,2,588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-12','2020-06-12',5000.00,NULL,NULL,1,'2021-08-11 10:56:19','2021-08-11 10:56:19',NULL),(588,2978,40720,43976,2,590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',12500.00,NULL,NULL,1,'2021-08-11 10:58:40','2021-08-11 10:58:40',NULL),(589,2978,40720,43976,2,591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',7500.00,NULL,NULL,1,'2021-08-11 11:00:32','2021-08-11 11:00:32',NULL),(590,2978,40720,43976,2,592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',3500.00,NULL,NULL,1,'2021-08-11 11:02:13','2021-08-11 11:02:13',NULL),(591,2978,40720,43976,2,593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',5600.00,NULL,NULL,1,'2021-08-11 11:03:37','2021-08-11 11:03:37',NULL),(592,2978,40720,43977,2,594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-11','2020-07-11',7200.00,NULL,NULL,1,'2021-08-11 11:16:07','2021-08-11 11:16:07',NULL),(593,2978,40720,43977,2,595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-21','2020-07-21',2700.00,NULL,NULL,1,'2021-08-11 11:17:52','2021-08-11 11:17:52',NULL),(594,2978,40720,43977,2,596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',2600.00,NULL,NULL,1,'2021-08-11 13:22:22','2021-08-11 13:22:22',NULL),(595,2978,40720,43977,2,597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',7200.00,NULL,NULL,1,'2021-08-11 13:23:50','2021-08-11 13:23:50',NULL),(596,2978,40720,43977,2,598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',2800.00,NULL,NULL,1,'2021-08-11 13:25:10','2021-08-11 13:25:10',NULL),(597,2978,40720,43977,2,599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',3100.00,NULL,NULL,1,'2021-08-11 13:26:42','2021-08-11 13:26:42',NULL),(598,2978,40720,43977,2,600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',7500.00,NULL,NULL,1,'2021-08-11 13:29:58','2021-08-11 13:29:58',NULL),(599,2978,40720,43978,2,601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',11700.00,NULL,NULL,1,'2021-08-11 14:57:44','2021-08-11 14:57:44',NULL),(600,2978,40720,43978,2,602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',2700.00,NULL,NULL,1,'2021-08-11 14:59:41','2021-08-11 14:59:41',NULL),(601,2978,40720,43978,2,603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',30000.00,NULL,NULL,1,'2021-08-11 15:01:14','2021-08-11 15:01:14',NULL),(602,2978,40720,43979,2,604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-07','2020-09-07',6800.00,NULL,NULL,1,'2021-08-11 15:12:54','2021-08-11 15:12:54',NULL),(603,2978,40720,43979,2,605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-29','2020-09-29',12500.00,NULL,NULL,1,'2021-08-11 15:15:04','2021-08-11 15:15:04',NULL);
INSERT INTO `balance_libro` VALUES (604,2978,40720,43979,2,606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-29','2020-09-29',5000.00,NULL,NULL,1,'2021-08-11 15:16:44','2021-08-11 15:16:44',NULL),(605,2978,40720,43979,2,607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-29','2020-09-29',10000.00,NULL,NULL,1,'2021-08-11 15:20:19','2021-08-11 15:20:19',NULL),(606,2978,40720,43980,2,608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-06','2020-10-06',5500.00,NULL,NULL,1,'2021-08-11 15:28:19','2021-08-11 15:28:19',NULL),(607,2978,40720,43980,2,609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-29','2020-10-29',7500.00,NULL,NULL,1,'2021-08-11 15:30:24','2021-08-11 15:30:24',NULL),(608,2978,40720,43980,2,610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',6000.00,NULL,NULL,1,'2021-08-11 15:33:06','2021-08-11 15:33:06',NULL),(609,2978,40720,43980,2,611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',17000.00,NULL,NULL,1,'2021-08-11 15:35:23','2021-08-11 15:35:23',NULL),(610,2978,40720,43980,2,612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',20000.00,NULL,NULL,1,'2021-08-11 15:37:39','2021-08-11 15:37:39',NULL),(611,2978,40720,43981,2,613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',4500.00,NULL,NULL,1,'2021-08-11 15:42:27','2021-08-11 15:42:27',NULL),(612,2978,40720,43981,2,614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',8500.00,NULL,NULL,1,'2021-08-11 15:44:05','2021-08-11 15:44:05',NULL),(613,2978,40720,43981,2,615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',3500.00,NULL,NULL,1,'2021-08-11 15:45:53','2021-08-11 15:45:53',NULL),(614,2978,40720,43982,2,616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-02','2020-12-02',5500.00,NULL,NULL,1,'2021-08-11 15:48:03','2021-08-11 15:48:03',NULL),(615,2978,40720,43982,2,617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-02','2020-12-02',7500.00,NULL,NULL,1,'2021-08-11 15:49:41','2021-08-11 15:49:41',NULL),(616,2978,40720,43982,2,618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',13500.00,NULL,NULL,1,'2021-08-11 15:51:18','2021-08-11 15:51:18',NULL),(617,2978,40720,43982,2,619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',19200.00,NULL,NULL,1,'2021-08-11 17:24:10','2021-08-11 17:24:10',NULL),(618,2978,40720,43982,2,620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',7000.00,NULL,NULL,1,'2021-08-11 17:26:04','2021-08-11 17:26:04',NULL),(619,2978,40866,43991,2,621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-15','2020-06-15',2000.00,NULL,NULL,1,'2021-08-11 17:39:03','2021-08-11 17:39:03',NULL),(620,2978,40866,43991,2,622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-16','2020-06-16',2200.00,NULL,NULL,1,'2021-08-11 17:39:03','2021-08-11 17:39:03',NULL),(621,2978,40866,43991,2,623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-16','2020-06-16',950.00,NULL,NULL,1,'2021-08-11 17:39:03','2021-08-11 17:39:03',NULL),(622,2978,40866,43991,2,624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-17','2020-06-17',950.00,NULL,NULL,1,'2021-08-11 17:39:03','2021-08-11 17:39:03',NULL),(623,2978,40866,43991,2,625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-17','2020-06-17',1400.00,NULL,NULL,1,'2021-08-11 17:39:03','2021-08-11 17:39:03',NULL),(624,2978,40866,43991,2,626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-19','2020-06-19',5550.00,NULL,NULL,1,'2021-08-11 17:39:03','2021-08-11 17:39:03',NULL),(625,2978,40866,43991,2,627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-19','2020-06-19',2200.00,NULL,NULL,1,'2021-08-11 17:39:03','2021-08-11 17:39:03',NULL),(626,2978,40866,43992,2,628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-30','2020-07-30',2000.00,NULL,NULL,1,'2021-08-11 17:42:19','2021-08-11 17:42:19',NULL),(627,2978,40866,43992,2,629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-30','2020-07-30',2000.00,NULL,NULL,1,'2021-08-11 17:42:19','2021-08-11 17:42:19',NULL),(628,2978,40866,43992,2,630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-30','2020-07-30',950.00,NULL,NULL,1,'2021-08-11 17:42:19','2021-08-11 17:42:19',NULL);
INSERT INTO `balance_libro` VALUES (629,2978,40866,43992,2,631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-30','2020-07-30',4000.00,NULL,NULL,1,'2021-08-11 17:42:19','2021-08-11 17:42:19',NULL),(630,2978,40866,43992,2,632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-30','2020-07-30',300.00,NULL,NULL,1,'2021-08-11 17:42:19','2021-08-11 17:42:19',NULL),(631,2978,40866,43992,2,633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-30','2020-07-30',4000.00,NULL,NULL,1,'2021-08-11 17:42:19','2021-08-11 17:42:19',NULL),(632,2978,40866,43992,2,634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-30','2020-07-30',1900.00,NULL,NULL,1,'2021-08-11 17:42:19','2021-08-11 17:42:19',NULL),(633,2978,40866,43992,2,635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-30','2020-07-30',6600.00,NULL,NULL,1,'2021-08-11 17:42:19','2021-08-11 17:42:19',NULL),(634,2978,40867,44006,2,636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-01','2020-06-01',40560.00,NULL,NULL,1,'2021-08-11 17:51:15','2021-08-11 17:51:15',NULL),(635,2978,40867,44007,2,637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-01','2020-07-01',40560.00,NULL,NULL,1,'2021-08-11 17:53:57','2021-08-11 17:53:57',NULL),(636,2978,40867,44008,2,638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-01','2020-08-01',40560.00,NULL,NULL,1,'2021-08-11 17:56:47','2021-08-11 17:56:47',NULL),(637,2978,40867,44009,2,639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-01','2020-09-01',40560.00,NULL,NULL,1,'2021-08-11 17:58:19','2021-08-11 17:58:19',NULL),(638,2978,40867,44010,2,640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-01','2020-10-01',40560.00,NULL,NULL,1,'2021-08-11 17:59:34','2021-08-11 17:59:34',NULL),(639,2978,40867,44011,2,641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-02','2020-11-02',40560.00,NULL,NULL,1,'2021-08-11 18:01:18','2021-08-11 18:01:18',NULL),(640,2978,40867,44012,2,642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-01','2020-12-01',4867.00,NULL,NULL,1,'2021-08-11 18:04:58','2021-08-11 18:04:58',NULL),(641,2978,40867,44012,2,643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-01','2020-12-01',45427.00,NULL,NULL,1,'2021-08-11 18:04:58','2021-08-11 18:04:58',NULL),(642,2978,40847,44021,2,644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-23','2020-06-23',226.00,NULL,NULL,1,'2021-08-11 18:10:53','2021-08-11 18:10:53',NULL),(643,2978,40847,44021,2,645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-23','2020-06-23',76.00,NULL,NULL,1,'2021-08-11 18:10:53','2021-08-11 18:10:53',NULL),(644,2978,40847,44021,2,646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-23','2020-06-23',204.00,NULL,NULL,1,'2021-08-11 18:10:53','2021-08-11 18:10:53',NULL),(645,2978,40847,44021,2,647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-24','2020-06-24',100.00,NULL,NULL,1,'2021-08-11 18:10:53','2021-08-11 18:10:53',NULL),(646,2978,40847,44021,2,648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-24','2020-06-24',176.00,NULL,NULL,1,'2021-08-11 18:10:53','2021-08-11 18:10:53',NULL),(647,2978,40847,44021,2,649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-24','2020-06-24',187.00,NULL,NULL,1,'2021-08-11 18:10:53','2021-08-11 18:10:53',NULL),(648,2978,40847,44021,2,650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-24','2020-06-24',138.00,NULL,NULL,1,'2021-08-11 18:10:53','2021-08-11 18:10:53',NULL),(649,2978,40847,44021,2,651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-24','2020-06-24',181.00,NULL,NULL,1,'2021-08-11 18:10:53','2021-08-11 18:10:53',NULL),(650,2978,40847,44021,2,652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-25','2020-06-25',132.00,NULL,NULL,1,'2021-08-11 18:10:53','2021-08-11 18:10:53',NULL),(651,2978,40847,44021,2,653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-25','2020-06-25',89.00,NULL,NULL,1,'2021-08-11 18:10:53','2021-08-11 18:10:53',NULL),(652,2978,40847,44021,2,654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-25','2020-06-25',229.00,NULL,NULL,1,'2021-08-11 18:10:53','2021-08-11 18:10:53',NULL),(653,2978,40847,44021,2,655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-25','2020-06-25',114.00,NULL,NULL,1,'2021-08-11 18:10:53','2021-08-11 18:10:53',NULL);
INSERT INTO `balance_libro` VALUES (654,2978,40847,44021,2,656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-26','2020-06-26',240.00,NULL,NULL,1,'2021-08-11 18:10:53','2021-08-11 18:10:53',NULL),(655,2978,40847,44021,2,657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-26','2020-06-26',187.00,NULL,NULL,1,'2021-08-11 18:10:53','2021-08-11 18:10:53',NULL),(656,2978,40847,44021,2,658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-26','2020-06-26',247.00,NULL,NULL,1,'2021-08-11 18:10:53','2021-08-11 18:10:53',NULL),(657,2978,40847,44021,2,659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-26','2020-06-26',168.00,NULL,NULL,1,'2021-08-11 18:10:53','2021-08-11 18:10:53',NULL),(658,2978,40847,44021,2,660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-26','2020-06-26',117.00,NULL,NULL,1,'2021-08-11 18:10:53','2021-08-11 18:10:53',NULL),(659,2978,40847,44021,2,661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-26','2020-06-26',190.00,NULL,NULL,1,'2021-08-11 18:10:53','2021-08-11 18:10:53',NULL),(660,2978,40847,44021,2,662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-26','2020-06-26',185.00,NULL,NULL,1,'2021-08-11 18:10:53','2021-08-11 18:10:53',NULL),(661,2978,40847,44021,2,663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-27','2020-06-27',150.00,NULL,NULL,1,'2021-08-11 18:10:53','2021-08-11 18:10:53',NULL),(662,2978,40847,44021,2,664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-27','2020-06-27',268.00,NULL,NULL,1,'2021-08-11 18:10:53','2021-08-11 18:10:53',NULL),(663,2978,40847,44021,2,665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-27','2020-06-27',40.00,NULL,NULL,1,'2021-08-11 18:10:53','2021-08-11 18:10:53',NULL),(664,2978,40847,44021,2,666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-28','2020-06-28',146.00,NULL,NULL,1,'2021-08-11 18:10:53','2021-08-11 18:10:53',NULL),(665,2978,40847,44021,2,667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-28','2020-06-28',269.00,NULL,NULL,1,'2021-08-11 18:10:53','2021-08-11 18:10:53',NULL),(666,2978,40847,44021,2,668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-28','2020-06-28',126.00,NULL,NULL,1,'2021-08-11 18:10:53','2021-08-11 18:10:53',NULL),(667,2978,40847,44021,2,669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-28','2020-06-28',204.00,NULL,NULL,1,'2021-08-11 18:10:53','2021-08-11 18:10:53',NULL),(668,2978,40847,44021,2,670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-28','2020-06-28',152.00,NULL,NULL,1,'2021-08-11 18:10:54','2021-08-11 18:10:54',NULL),(669,2978,40847,44021,2,671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-28','2020-06-28',165.00,NULL,NULL,1,'2021-08-11 18:10:54','2021-08-11 18:10:54',NULL),(670,2978,40847,44021,2,672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-28','2020-06-28',219.00,NULL,NULL,1,'2021-08-11 18:10:54','2021-08-11 18:10:54',NULL),(671,2978,40847,44021,2,673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-28','2020-06-28',191.00,NULL,NULL,1,'2021-08-11 18:10:54','2021-08-11 18:10:54',NULL),(672,2978,40847,44021,2,674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-28','2020-06-28',350.00,NULL,NULL,1,'2021-08-11 18:10:54','2021-08-11 18:10:54',NULL),(673,2978,40847,44021,2,675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-28','2020-06-28',344.00,NULL,NULL,1,'2021-08-11 18:10:54','2021-08-11 18:10:54',NULL),(674,2978,40847,44021,2,676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-29','2020-06-29',78.00,NULL,NULL,1,'2021-08-11 18:10:54','2021-08-11 18:10:54',NULL),(675,2978,40847,44021,2,677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-29','2020-06-29',170.00,NULL,NULL,1,'2021-08-11 18:10:54','2021-08-11 18:10:54',NULL),(676,2978,40847,44021,2,678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-29','2020-06-29',142.00,NULL,NULL,1,'2021-08-11 18:10:54','2021-08-11 18:10:54',NULL),(677,2978,40847,44021,2,679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-29','2020-06-29',315.00,NULL,NULL,1,'2021-08-11 18:10:54','2021-08-11 18:10:54',NULL),(678,2978,40847,44021,2,680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-29','2020-06-29',111.00,NULL,NULL,1,'2021-08-11 18:10:54','2021-08-11 18:10:54',NULL);
INSERT INTO `balance_libro` VALUES (679,2978,40847,44021,2,681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-29','2020-06-29',149.00,NULL,NULL,1,'2021-08-11 18:10:54','2021-08-11 18:10:54',NULL),(680,2978,40847,44021,2,682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-29','2020-06-29',187.00,NULL,NULL,1,'2021-08-11 18:10:54','2021-08-11 18:10:54',NULL),(701,2978,40720,1536,2,703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',7700.00,NULL,NULL,1,'2021-08-12 15:37:50','2021-08-12 15:37:50',NULL),(702,2978,40720,1536,2,704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',6000.00,NULL,NULL,1,'2021-08-12 15:37:50','2021-08-12 15:37:50',NULL),(703,2978,40720,1536,2,705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',8500.00,NULL,NULL,1,'2021-08-12 15:37:50','2021-08-12 15:37:50',NULL),(704,2978,40720,1536,2,706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',3000.00,NULL,NULL,1,'2021-08-12 15:37:50','2021-08-12 15:37:50',NULL),(705,2978,40720,1536,2,707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',13000.00,NULL,NULL,1,'2021-08-12 15:37:50','2021-08-12 15:37:50',NULL),(706,2978,40720,1536,2,708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',5500.00,NULL,NULL,1,'2021-08-12 15:37:50','2021-08-12 15:37:50',NULL),(707,2978,40847,44022,2,709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-03','2020-07-03',295.00,NULL,NULL,1,'2021-08-12 15:39:48','2021-08-12 15:39:48',NULL),(708,2978,40847,44022,2,710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-03','2020-07-03',199.00,NULL,NULL,1,'2021-08-12 15:39:48','2021-08-12 15:39:48',NULL),(709,2978,40847,44022,2,711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-03','2020-07-03',281.00,NULL,NULL,1,'2021-08-12 15:39:48','2021-08-12 15:39:48',NULL),(710,2978,40847,44022,2,712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-03','2020-07-03',75.00,NULL,NULL,1,'2021-08-12 15:39:48','2021-08-12 15:39:48',NULL),(711,2978,40847,44022,2,713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-03','2020-07-03',40.00,NULL,NULL,1,'2021-08-12 15:39:48','2021-08-12 15:39:48',NULL),(712,2978,40847,44022,2,714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-03','2020-07-03',134.00,NULL,NULL,1,'2021-08-12 15:39:48','2021-08-12 15:39:48',NULL),(713,2978,40847,44022,2,715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-03','2020-07-03',233.00,NULL,NULL,1,'2021-08-12 15:39:48','2021-08-12 15:39:48',NULL),(714,2978,40847,44022,2,716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-04','2020-07-04',216.00,NULL,NULL,1,'2021-08-12 15:39:48','2021-08-12 15:39:48',NULL),(715,2978,40847,44022,2,717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-04','2020-07-04',150.00,NULL,NULL,1,'2021-08-12 15:39:48','2021-08-12 15:39:48',NULL),(716,2978,40847,44022,2,718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-04','2020-07-04',178.00,NULL,NULL,1,'2021-08-12 15:39:48','2021-08-12 15:39:48',NULL),(717,2978,40847,44022,2,719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-04','2020-07-04',125.00,NULL,NULL,1,'2021-08-12 15:39:48','2021-08-12 15:39:48',NULL),(718,2978,40847,44022,2,720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-04','2020-07-04',40.00,NULL,NULL,1,'2021-08-12 15:39:48','2021-08-12 15:39:48',NULL),(719,2978,40847,44022,2,721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-04','2020-07-04',502.00,NULL,NULL,1,'2021-08-12 15:39:48','2021-08-12 15:39:48',NULL),(720,2978,40847,44022,2,722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-04','2020-07-04',268.00,NULL,NULL,1,'2021-08-12 15:39:48','2021-08-12 15:39:48',NULL),(721,2978,40847,44022,2,723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-05','2020-07-05',126.00,NULL,NULL,1,'2021-08-12 15:39:48','2021-08-12 15:39:48',NULL),(722,2978,40847,44022,2,724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-05','2020-07-05',383.00,NULL,NULL,1,'2021-08-12 15:39:48','2021-08-12 15:39:48',NULL),(723,2978,40847,44022,2,725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-05','2020-07-05',85.00,NULL,NULL,1,'2021-08-12 15:39:48','2021-08-12 15:39:48',NULL);
INSERT INTO `balance_libro` VALUES (724,2978,40847,44022,2,726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-05','2020-07-05',77.00,NULL,NULL,1,'2021-08-12 15:39:48','2021-08-12 15:39:48',NULL),(725,2978,40847,44022,2,727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-05','2020-07-05',81.00,NULL,NULL,1,'2021-08-12 15:39:48','2021-08-12 15:39:48',NULL),(726,2978,40847,44022,2,728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-05','2020-07-05',101.00,NULL,NULL,1,'2021-08-12 15:39:48','2021-08-12 15:39:48',NULL),(727,2978,40847,44022,2,729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-05','2020-07-05',126.00,NULL,NULL,1,'2021-08-12 15:39:48','2021-08-12 15:39:48',NULL),(728,2978,40847,44022,2,730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-05','2020-07-05',165.00,NULL,NULL,1,'2021-08-12 15:39:48','2021-08-12 15:39:48',NULL),(729,2978,40847,44022,2,731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-05','2020-07-05',75.00,NULL,NULL,1,'2021-08-12 15:39:48','2021-08-12 15:39:48',NULL),(730,2978,40847,44022,2,732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-05','2020-07-05',394.00,NULL,NULL,1,'2021-08-12 15:39:48','2021-08-12 15:39:48',NULL),(731,2978,40847,44022,2,733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-05','2020-07-05',154.00,NULL,NULL,1,'2021-08-12 15:39:48','2021-08-12 15:39:48',NULL),(732,2978,40847,44022,2,734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-05','2020-07-05',104.00,NULL,NULL,1,'2021-08-12 15:39:48','2021-08-12 15:39:48',NULL),(733,2978,40847,44022,2,735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-05','2020-07-05',141.00,NULL,NULL,1,'2021-08-12 15:39:49','2021-08-12 15:39:49',NULL),(734,2978,40847,44022,2,736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-05','2020-07-05',174.00,NULL,NULL,1,'2021-08-12 15:39:49','2021-08-12 15:39:49',NULL),(735,2978,40847,44022,2,737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-05','2020-07-05',132.00,NULL,NULL,1,'2021-08-12 15:39:49','2021-08-12 15:39:49',NULL),(736,2978,40847,44022,2,738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-05','2020-07-05',78.00,NULL,NULL,1,'2021-08-12 15:39:49','2021-08-12 15:39:49',NULL),(737,2978,40847,44022,2,739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-05','2020-07-05',75.00,NULL,NULL,1,'2021-08-12 15:39:49','2021-08-12 15:39:49',NULL),(738,2978,40847,44022,2,740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-05','2020-07-05',242.00,NULL,NULL,1,'2021-08-12 15:39:49','2021-08-12 15:39:49',NULL),(739,2978,40847,44022,2,741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-05','2020-07-05',89.00,NULL,NULL,1,'2021-08-12 15:39:49','2021-08-12 15:39:49',NULL),(740,2978,40847,44022,2,742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-06','2020-07-06',304.00,NULL,NULL,1,'2021-08-12 15:39:49','2021-08-12 15:39:49',NULL),(741,2978,40847,44022,2,743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-06','2020-07-06',314.00,NULL,NULL,1,'2021-08-12 15:39:49','2021-08-12 15:39:49',NULL),(742,2978,40847,44022,2,744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-06','2020-07-06',95.00,NULL,NULL,1,'2021-08-12 15:39:49','2021-08-12 15:39:49',NULL),(743,2978,40847,44022,2,745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-06','2020-07-06',225.00,NULL,NULL,1,'2021-08-12 15:39:49','2021-08-12 15:39:49',NULL),(744,2978,40847,44022,2,746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-06','2020-07-06',108.00,NULL,NULL,1,'2021-08-12 15:39:49','2021-08-12 15:39:49',NULL),(745,2978,40847,44022,2,747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-07','2020-07-07',116.00,NULL,NULL,1,'2021-08-12 15:39:49','2021-08-12 15:39:49',NULL),(746,2978,40847,44022,2,748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-07','2020-07-07',168.00,NULL,NULL,1,'2021-08-12 15:39:49','2021-08-12 15:39:49',NULL),(747,2978,40847,44022,2,749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-07','2020-07-07',91.00,NULL,NULL,1,'2021-08-12 15:39:49','2021-08-12 15:39:49',NULL),(748,2978,40847,44022,2,750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-07','2020-07-07',210.00,NULL,NULL,1,'2021-08-12 15:39:49','2021-08-12 15:39:49',NULL);
INSERT INTO `balance_libro` VALUES (749,2978,40847,44022,2,751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-07','2020-07-07',186.00,NULL,NULL,1,'2021-08-12 15:39:49','2021-08-12 15:39:49',NULL),(750,2978,40847,44022,2,752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-07','2020-07-07',200.00,NULL,NULL,1,'2021-08-12 15:39:49','2021-08-12 15:39:49',NULL),(751,2978,40847,44022,2,753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-07','2020-07-07',82.00,NULL,NULL,1,'2021-08-12 15:39:49','2021-08-12 15:39:49',NULL),(752,2978,40847,44022,2,754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-07','2020-07-07',75.00,NULL,NULL,1,'2021-08-12 15:39:49','2021-08-12 15:39:49',NULL),(753,2978,40847,44022,2,755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-07','2020-07-07',40.00,NULL,NULL,1,'2021-08-12 15:39:49','2021-08-12 15:39:49',NULL),(754,2978,40847,44022,2,756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-07','2020-07-07',98.00,NULL,NULL,1,'2021-08-12 15:39:49','2021-08-12 15:39:49',NULL),(755,2978,40847,44022,2,757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-07','2020-07-07',125.00,NULL,NULL,1,'2021-08-12 15:39:49','2021-08-12 15:39:49',NULL),(756,2978,40847,44022,2,758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-07','2020-07-07',945.00,NULL,NULL,1,'2021-08-12 15:39:49','2021-08-12 15:39:49',NULL),(757,2978,40847,44022,2,759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-07','2020-07-07',81.00,NULL,NULL,1,'2021-08-12 15:39:49','2021-08-12 15:39:49',NULL),(758,2978,40847,44022,2,760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-08','2020-07-08',140.00,NULL,NULL,1,'2021-08-12 15:39:49','2021-08-12 15:39:49',NULL),(759,2978,40847,44022,2,761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-08','2020-07-08',234.00,NULL,NULL,1,'2021-08-12 15:39:49','2021-08-12 15:39:49',NULL),(760,2978,40847,44022,2,762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-08','2020-07-08',172.00,NULL,NULL,1,'2021-08-12 15:39:49','2021-08-12 15:39:49',NULL),(761,2978,40847,44022,2,763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-08','2020-07-08',77.00,NULL,NULL,1,'2021-08-12 15:39:49','2021-08-12 15:39:49',NULL),(762,2978,40847,44022,2,764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-08','2020-07-08',169.00,NULL,NULL,1,'2021-08-12 15:39:49','2021-08-12 15:39:49',NULL),(763,2978,40847,44022,2,765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-08','2020-07-08',151.00,NULL,NULL,1,'2021-08-12 15:39:49','2021-08-12 15:39:49',NULL),(764,2978,40847,44022,2,766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-08','2020-07-08',272.00,NULL,NULL,1,'2021-08-12 15:39:49','2021-08-12 15:39:49',NULL),(765,2978,40847,44022,2,767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-08','2020-07-08',488.00,NULL,NULL,1,'2021-08-12 15:39:50','2021-08-12 15:39:50',NULL),(766,2978,40847,44022,2,768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-08','2020-07-08',163.00,NULL,NULL,1,'2021-08-12 15:39:50','2021-08-12 15:39:50',NULL),(767,2978,40847,44022,2,769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-08','2020-07-08',293.00,NULL,NULL,1,'2021-08-12 15:39:50','2021-08-12 15:39:50',NULL),(768,2978,40847,44022,2,770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-09','2020-07-09',224.00,NULL,NULL,1,'2021-08-12 15:39:50','2021-08-12 15:39:50',NULL),(769,2978,40847,44022,2,771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-09','2020-07-09',203.00,NULL,NULL,1,'2021-08-12 15:39:50','2021-08-12 15:39:50',NULL),(770,2978,40847,44022,2,772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-09','2020-07-09',215.00,NULL,NULL,1,'2021-08-12 15:39:50','2021-08-12 15:39:50',NULL),(771,2978,40847,44022,2,773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-09','2020-07-09',121.00,NULL,NULL,1,'2021-08-12 15:39:50','2021-08-12 15:39:50',NULL),(772,2978,40847,44022,2,774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-09','2020-07-09',151.00,NULL,NULL,1,'2021-08-12 15:39:50','2021-08-12 15:39:50',NULL),(773,2978,40847,44022,2,775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-09','2020-07-09',119.00,NULL,NULL,1,'2021-08-12 15:39:50','2021-08-12 15:39:50',NULL);
INSERT INTO `balance_libro` VALUES (774,2978,40847,44022,2,776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-09','2020-07-09',105.00,NULL,NULL,1,'2021-08-12 15:39:50','2021-08-12 15:39:50',NULL),(775,2978,40847,44022,2,777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-09','2020-07-09',299.00,NULL,NULL,1,'2021-08-12 15:39:50','2021-08-12 15:39:50',NULL),(776,2978,40847,44022,2,778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-11','2020-07-11',232.00,NULL,NULL,1,'2021-08-12 15:39:50','2021-08-12 15:39:50',NULL),(777,2978,40847,44022,2,779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-11','2020-07-11',170.00,NULL,NULL,1,'2021-08-12 15:39:50','2021-08-12 15:39:50',NULL),(778,2978,40847,44022,2,780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-11','2020-07-11',127.00,NULL,NULL,1,'2021-08-12 15:39:50','2021-08-12 15:39:50',NULL),(779,2978,40847,44022,2,781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-11','2020-07-11',249.00,NULL,NULL,1,'2021-08-12 15:39:50','2021-08-12 15:39:50',NULL),(780,2978,40847,44022,2,782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-11','2020-07-11',157.00,NULL,NULL,1,'2021-08-12 15:39:50','2021-08-12 15:39:50',NULL),(781,2978,40847,44022,2,783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-11','2020-07-11',132.00,NULL,NULL,1,'2021-08-12 15:39:50','2021-08-12 15:39:50',NULL),(782,2978,40847,44022,2,784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-11','2020-07-11',98.00,NULL,NULL,1,'2021-08-12 15:39:50','2021-08-12 15:39:50',NULL),(783,2978,40847,44022,2,785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-11','2020-07-11',99.00,NULL,NULL,1,'2021-08-12 15:39:50','2021-08-12 15:39:50',NULL),(784,2978,40847,44022,2,786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-11','2020-07-11',345.00,NULL,NULL,1,'2021-08-12 15:39:50','2021-08-12 15:39:50',NULL),(785,2978,40847,44022,2,787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-11','2020-07-11',166.00,NULL,NULL,1,'2021-08-12 15:39:50','2021-08-12 15:39:50',NULL),(786,2978,40847,44022,2,788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-11','2020-07-11',169.00,NULL,NULL,1,'2021-08-12 15:39:50','2021-08-12 15:39:50',NULL),(787,2978,40847,44022,2,789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-11','2020-07-11',77.00,NULL,NULL,1,'2021-08-12 15:39:50','2021-08-12 15:39:50',NULL),(788,2978,40847,44022,2,790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-11','2020-07-11',114.00,NULL,NULL,1,'2021-08-12 15:39:50','2021-08-12 15:39:50',NULL),(789,2978,40847,44022,2,791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-11','2020-07-11',382.00,NULL,NULL,1,'2021-08-12 15:39:50','2021-08-12 15:39:50',NULL),(790,2978,40847,44022,2,792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-12','2020-07-12',132.00,NULL,NULL,1,'2021-08-12 15:39:50','2021-08-12 15:39:50',NULL),(791,2978,40847,44022,2,793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-12','2020-07-12',225.00,NULL,NULL,1,'2021-08-12 15:39:50','2021-08-12 15:39:50',NULL),(792,2978,40847,44022,2,794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-12','2020-07-12',370.00,NULL,NULL,1,'2021-08-12 15:39:50','2021-08-12 15:39:50',NULL),(793,2978,40847,44022,2,795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-12','2020-07-12',75.00,NULL,NULL,1,'2021-08-12 15:39:50','2021-08-12 15:39:50',NULL),(794,2978,40847,44022,2,796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-12','2020-07-12',143.00,NULL,NULL,1,'2021-08-12 15:39:51','2021-08-12 15:39:51',NULL),(795,2978,40847,44022,2,797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-13','2020-07-13',134.00,NULL,NULL,1,'2021-08-12 15:39:51','2021-08-12 15:39:51',NULL),(796,2978,40847,44022,2,798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-13','2020-07-13',255.00,NULL,NULL,1,'2021-08-12 15:39:51','2021-08-12 15:39:51',NULL),(797,2978,40847,44022,2,799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-13','2020-07-13',91.00,NULL,NULL,1,'2021-08-12 15:39:51','2021-08-12 15:39:51',NULL),(798,2978,40847,44022,2,800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-13','2020-07-13',295.00,NULL,NULL,1,'2021-08-12 15:39:51','2021-08-12 15:39:51',NULL);
INSERT INTO `balance_libro` VALUES (799,2978,40847,44022,2,801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-13','2020-07-13',200.00,NULL,NULL,1,'2021-08-12 15:39:51','2021-08-12 15:39:51',NULL),(800,2978,40847,44022,2,802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-13','2020-07-13',111.00,NULL,NULL,1,'2021-08-12 15:39:51','2021-08-12 15:39:51',NULL),(801,2978,40847,44022,2,803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-13','2020-07-13',137.00,NULL,NULL,1,'2021-08-12 15:39:51','2021-08-12 15:39:51',NULL),(802,2978,40847,44022,2,804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-13','2020-07-13',183.00,NULL,NULL,1,'2021-08-12 15:39:51','2021-08-12 15:39:51',NULL),(803,2978,40847,44022,2,805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-14','2020-07-14',113.00,NULL,NULL,1,'2021-08-12 15:39:51','2021-08-12 15:39:51',NULL),(804,2978,40847,44022,2,806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-14','2020-07-14',201.00,NULL,NULL,1,'2021-08-12 15:39:51','2021-08-12 15:39:51',NULL),(805,2978,40847,44022,2,807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-14','2020-07-14',161.00,NULL,NULL,1,'2021-08-12 15:39:51','2021-08-12 15:39:51',NULL),(806,2978,40847,44022,2,808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-14','2020-07-14',187.00,NULL,NULL,1,'2021-08-12 15:39:51','2021-08-12 15:39:51',NULL),(807,2978,40847,44022,2,809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-14','2020-07-14',150.00,NULL,NULL,1,'2021-08-12 15:39:51','2021-08-12 15:39:51',NULL),(808,2978,40847,44022,2,810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-14','2020-07-14',115.00,NULL,NULL,1,'2021-08-12 15:39:51','2021-08-12 15:39:51',NULL),(809,2978,40847,44022,2,811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-14','2020-07-14',101.00,NULL,NULL,1,'2021-08-12 15:39:51','2021-08-12 15:39:51',NULL),(810,2978,40847,44022,2,812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-15','2020-07-15',471.00,NULL,NULL,1,'2021-08-12 15:39:51','2021-08-12 15:39:51',NULL),(811,2978,40847,44022,2,813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-15','2020-07-15',101.00,NULL,NULL,1,'2021-08-12 15:39:51','2021-08-12 15:39:51',NULL),(812,2978,40847,44022,2,814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-15','2020-07-15',77.00,NULL,NULL,1,'2021-08-12 15:39:51','2021-08-12 15:39:51',NULL),(813,2978,40847,44022,2,815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-15','2020-07-15',146.00,NULL,NULL,1,'2021-08-12 15:39:51','2021-08-12 15:39:51',NULL),(814,2978,40847,44022,2,816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-15','2020-07-15',132.00,NULL,NULL,1,'2021-08-12 15:39:51','2021-08-12 15:39:51',NULL),(815,2978,40847,44022,2,817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-15','2020-07-15',145.00,NULL,NULL,1,'2021-08-12 15:39:51','2021-08-12 15:39:51',NULL),(816,2978,40847,44022,2,818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-15','2020-07-15',119.00,NULL,NULL,1,'2021-08-12 15:39:51','2021-08-12 15:39:51',NULL),(817,2978,40847,44022,2,819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-15','2020-07-15',84.00,NULL,NULL,1,'2021-08-12 15:39:51','2021-08-12 15:39:51',NULL),(818,2978,40847,44022,2,820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-15','2020-07-15',177.00,NULL,NULL,1,'2021-08-12 15:39:51','2021-08-12 15:39:51',NULL),(819,2978,40847,44022,2,821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-15','2020-07-15',295.00,NULL,NULL,1,'2021-08-12 15:39:51','2021-08-12 15:39:51',NULL),(820,2978,40847,44022,2,822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-15','2020-07-15',368.00,NULL,NULL,1,'2021-08-12 15:39:51','2021-08-12 15:39:51',NULL),(821,2978,40847,44022,2,823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-15','2020-07-15',91.00,NULL,NULL,1,'2021-08-12 15:39:51','2021-08-12 15:39:51',NULL),(822,2978,40847,44022,2,824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-16','2020-07-16',130.00,NULL,NULL,1,'2021-08-12 15:39:51','2021-08-12 15:39:51',NULL),(823,2978,40847,44022,2,825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-16','2020-07-16',40.00,NULL,NULL,1,'2021-08-12 15:39:51','2021-08-12 15:39:51',NULL);
INSERT INTO `balance_libro` VALUES (824,2978,40847,44022,2,826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-16','2020-07-16',301.00,NULL,NULL,1,'2021-08-12 15:39:51','2021-08-12 15:39:51',NULL),(825,2978,40847,44022,2,827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-16','2020-07-16',80.00,NULL,NULL,1,'2021-08-12 15:39:51','2021-08-12 15:39:51',NULL),(826,2978,40847,44022,2,828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-16','2020-07-16',121.00,NULL,NULL,1,'2021-08-12 15:39:52','2021-08-12 15:39:52',NULL),(827,2978,40847,44022,2,829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-16','2020-07-16',175.00,NULL,NULL,1,'2021-08-12 15:39:52','2021-08-12 15:39:52',NULL),(828,2978,40847,44022,2,830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-16','2020-07-16',179.00,NULL,NULL,1,'2021-08-12 15:39:52','2021-08-12 15:39:52',NULL),(829,2978,40847,44022,2,831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-16','2020-07-16',77.00,NULL,NULL,1,'2021-08-12 15:39:52','2021-08-12 15:39:52',NULL),(830,2978,40847,44022,2,832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-16','2020-07-16',88.00,NULL,NULL,1,'2021-08-12 15:39:52','2021-08-12 15:39:52',NULL),(831,2978,40847,44022,2,833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-16','2020-07-16',102.00,NULL,NULL,1,'2021-08-12 15:39:52','2021-08-12 15:39:52',NULL),(832,2978,40847,44022,2,834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-16','2020-07-16',375.00,NULL,NULL,1,'2021-08-12 15:39:52','2021-08-12 15:39:52',NULL),(833,2978,40847,44022,2,835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-17','2020-07-17',195.00,NULL,NULL,1,'2021-08-12 15:39:52','2021-08-12 15:39:52',NULL),(834,2978,40847,44022,2,836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-17','2020-07-17',223.00,NULL,NULL,1,'2021-08-12 15:39:52','2021-08-12 15:39:52',NULL),(835,2978,40847,44022,2,837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-17','2020-07-17',426.00,NULL,NULL,1,'2021-08-12 15:39:52','2021-08-12 15:39:52',NULL),(836,2978,40847,44022,2,838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-17','2020-07-17',201.00,NULL,NULL,1,'2021-08-12 15:39:52','2021-08-12 15:39:52',NULL),(837,2978,40847,44022,2,839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-17','2020-07-17',118.00,NULL,NULL,1,'2021-08-12 15:39:52','2021-08-12 15:39:52',NULL),(838,2978,40847,44022,2,840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-17','2020-07-17',576.00,NULL,NULL,1,'2021-08-12 15:39:52','2021-08-12 15:39:52',NULL),(839,2978,40847,44022,2,841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-17','2020-07-17',403.00,NULL,NULL,1,'2021-08-12 15:39:52','2021-08-12 15:39:52',NULL),(840,2978,40847,44022,2,842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-17','2020-07-17',50.00,NULL,NULL,1,'2021-08-12 15:39:52','2021-08-12 15:39:52',NULL),(841,2978,40847,44022,2,843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-18','2020-07-18',233.00,NULL,NULL,1,'2021-08-12 15:39:52','2021-08-12 15:39:52',NULL),(842,2978,40847,44022,2,844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-18','2020-07-18',183.00,NULL,NULL,1,'2021-08-12 15:39:52','2021-08-12 15:39:52',NULL),(843,2978,40847,44022,2,845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-18','2020-07-18',158.00,NULL,NULL,1,'2021-08-12 15:39:52','2021-08-12 15:39:52',NULL),(844,2978,40847,44022,2,846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-18','2020-07-18',105.00,NULL,NULL,1,'2021-08-12 15:39:52','2021-08-12 15:39:52',NULL),(845,2978,40847,44022,2,847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-19','2020-07-19',181.00,NULL,NULL,1,'2021-08-12 15:39:52','2021-08-12 15:39:52',NULL),(846,2978,40847,44022,2,848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-19','2020-07-19',207.00,NULL,NULL,1,'2021-08-12 15:39:52','2021-08-12 15:39:52',NULL),(847,2978,40847,44022,2,849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-19','2020-07-19',159.00,NULL,NULL,1,'2021-08-12 15:39:52','2021-08-12 15:39:52',NULL),(848,2978,40847,44022,2,850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-19','2020-07-19',133.00,NULL,NULL,1,'2021-08-12 15:39:52','2021-08-12 15:39:52',NULL);
INSERT INTO `balance_libro` VALUES (849,2978,40847,44022,2,851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-19','2020-07-19',262.00,NULL,NULL,1,'2021-08-12 15:39:52','2021-08-12 15:39:52',NULL),(850,2978,40847,44022,2,852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-19','2020-07-19',124.00,NULL,NULL,1,'2021-08-12 15:39:52','2021-08-12 15:39:52',NULL),(851,2978,40847,44022,2,853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-19','2020-07-19',95.00,NULL,NULL,1,'2021-08-12 15:39:52','2021-08-12 15:39:52',NULL),(852,2978,40847,44022,2,854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-19','2020-07-19',82.00,NULL,NULL,1,'2021-08-12 15:39:52','2021-08-12 15:39:52',NULL),(853,2978,40847,44022,2,855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-19','2020-07-19',197.00,NULL,NULL,1,'2021-08-12 15:39:52','2021-08-12 15:39:52',NULL),(854,2978,40847,44022,2,856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-19','2020-07-19',85.00,NULL,NULL,1,'2021-08-12 15:39:52','2021-08-12 15:39:52',NULL),(855,2978,40847,44022,2,857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-19','2020-07-19',323.00,NULL,NULL,1,'2021-08-12 15:39:52','2021-08-12 15:39:52',NULL),(856,2978,40847,44022,2,858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-20','2020-07-20',132.00,NULL,NULL,1,'2021-08-12 15:39:52','2021-08-12 15:39:52',NULL),(857,2978,40847,44022,2,859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-20','2020-07-20',90.00,NULL,NULL,1,'2021-08-12 15:39:52','2021-08-12 15:39:52',NULL),(858,2978,40847,44022,2,860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-20','2020-07-20',149.00,NULL,NULL,1,'2021-08-12 15:39:52','2021-08-12 15:39:52',NULL),(859,2978,40847,44022,2,861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-20','2020-07-20',133.00,NULL,NULL,1,'2021-08-12 15:39:53','2021-08-12 15:39:53',NULL),(860,2978,40847,44022,2,862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-20','2020-07-20',151.00,NULL,NULL,1,'2021-08-12 15:39:53','2021-08-12 15:39:53',NULL),(861,2978,40847,44022,2,863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-20','2020-07-20',518.00,NULL,NULL,1,'2021-08-12 15:39:53','2021-08-12 15:39:53',NULL),(862,2978,40847,44022,2,864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-20','2020-07-20',139.00,NULL,NULL,1,'2021-08-12 15:39:53','2021-08-12 15:39:53',NULL),(863,2978,40847,44022,2,865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-20','2020-07-20',263.00,NULL,NULL,1,'2021-08-12 15:39:53','2021-08-12 15:39:53',NULL),(864,2978,40847,44022,2,866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-20','2020-07-20',270.00,NULL,NULL,1,'2021-08-12 15:39:53','2021-08-12 15:39:53',NULL),(865,2978,40847,44022,2,867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-20','2020-07-20',134.00,NULL,NULL,1,'2021-08-12 15:39:53','2021-08-12 15:39:53',NULL),(866,2978,40847,44022,2,868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-20','2020-07-20',195.00,NULL,NULL,1,'2021-08-12 15:39:53','2021-08-12 15:39:53',NULL),(867,2978,40847,44022,2,869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-20','2020-07-20',206.00,NULL,NULL,1,'2021-08-12 15:39:53','2021-08-12 15:39:53',NULL),(868,2978,40847,44022,2,870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-22','2020-07-22',244.00,NULL,NULL,1,'2021-08-12 15:39:53','2021-08-12 15:39:53',NULL),(869,2978,40847,44022,2,871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-22','2020-07-22',239.00,NULL,NULL,1,'2021-08-12 15:39:53','2021-08-12 15:39:53',NULL),(870,2978,40847,44022,2,872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-22','2020-07-22',132.00,NULL,NULL,1,'2021-08-12 15:39:53','2021-08-12 15:39:53',NULL),(871,2978,40847,44022,2,873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-22','2020-07-22',349.00,NULL,NULL,1,'2021-08-12 15:39:53','2021-08-12 15:39:53',NULL),(872,2978,40847,44022,2,874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-22','2020-07-22',327.00,NULL,NULL,1,'2021-08-12 15:39:53','2021-08-12 15:39:53',NULL),(873,2978,40847,44022,2,875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-22','2020-07-22',320.00,NULL,NULL,1,'2021-08-12 15:39:53','2021-08-12 15:39:53',NULL);
INSERT INTO `balance_libro` VALUES (874,2978,40847,44022,2,876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-22','2020-07-22',241.00,NULL,NULL,1,'2021-08-12 15:39:53','2021-08-12 15:39:53',NULL),(875,2978,40847,44022,2,877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-22','2020-07-22',157.00,NULL,NULL,1,'2021-08-12 15:39:53','2021-08-12 15:39:53',NULL),(876,2978,40847,44022,2,878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-22','2020-07-22',266.00,NULL,NULL,1,'2021-08-12 15:39:53','2021-08-12 15:39:53',NULL),(877,2978,40847,44022,2,879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-23','2020-07-23',144.00,NULL,NULL,1,'2021-08-12 15:39:53','2021-08-12 15:39:53',NULL),(878,2978,40847,44022,2,880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-23','2020-07-23',48.00,NULL,NULL,1,'2021-08-12 15:39:53','2021-08-12 15:39:53',NULL),(879,2978,40847,44022,2,881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-23','2020-07-23',481.00,NULL,NULL,1,'2021-08-12 15:39:53','2021-08-12 15:39:53',NULL),(880,2978,40847,44022,2,882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-23','2020-07-23',185.00,NULL,NULL,1,'2021-08-12 15:39:53','2021-08-12 15:39:53',NULL),(881,2978,40847,44022,2,883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-23','2020-07-23',109.00,NULL,NULL,1,'2021-08-12 15:39:53','2021-08-12 15:39:53',NULL),(882,2978,40847,44022,2,884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-23','2020-07-23',176.00,NULL,NULL,1,'2021-08-12 15:39:53','2021-08-12 15:39:53',NULL),(883,2978,40847,44022,2,885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-23','2020-07-23',343.00,NULL,NULL,1,'2021-08-12 15:39:53','2021-08-12 15:39:53',NULL),(884,2978,40847,44022,2,886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-23','2020-07-23',180.00,NULL,NULL,1,'2021-08-12 15:39:53','2021-08-12 15:39:53',NULL),(885,2978,40847,44022,2,887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-23','2020-07-23',647.00,NULL,NULL,1,'2021-08-12 15:39:53','2021-08-12 15:39:53',NULL),(886,2978,40847,44022,2,888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-24','2020-07-24',235.00,NULL,NULL,1,'2021-08-12 15:39:53','2021-08-12 15:39:53',NULL),(887,2978,40847,44022,2,889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-24','2020-07-24',153.00,NULL,NULL,1,'2021-08-12 15:39:53','2021-08-12 15:39:53',NULL),(888,2978,40847,44022,2,890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-24','2020-07-24',176.00,NULL,NULL,1,'2021-08-12 15:39:53','2021-08-12 15:39:53',NULL),(889,2978,40847,44022,2,891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-25','2020-07-25',347.00,NULL,NULL,1,'2021-08-12 15:39:53','2021-08-12 15:39:53',NULL),(890,2978,40847,44022,2,892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-25','2020-07-25',232.00,NULL,NULL,1,'2021-08-12 15:39:54','2021-08-12 15:39:54',NULL),(891,2978,40847,44022,2,893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-25','2020-07-25',339.00,NULL,NULL,1,'2021-08-12 15:39:54','2021-08-12 15:39:54',NULL),(892,2978,40847,44022,2,894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-25','2020-07-25',135.00,NULL,NULL,1,'2021-08-12 15:39:54','2021-08-12 15:39:54',NULL),(893,2978,40847,44022,2,895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-25','2020-07-25',89.00,NULL,NULL,1,'2021-08-12 15:39:54','2021-08-12 15:39:54',NULL),(894,2978,40847,44022,2,896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-25','2020-07-25',103.00,NULL,NULL,1,'2021-08-12 15:39:54','2021-08-12 15:39:54',NULL),(895,2978,40847,44022,2,897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-25','2020-07-25',228.00,NULL,NULL,1,'2021-08-12 15:39:54','2021-08-12 15:39:54',NULL),(896,2978,40847,44022,2,898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-25','2020-07-25',150.00,NULL,NULL,1,'2021-08-12 15:39:54','2021-08-12 15:39:54',NULL),(897,2978,40847,44022,2,899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-25','2020-07-25',108.00,NULL,NULL,1,'2021-08-12 15:39:54','2021-08-12 15:39:54',NULL),(898,2978,40847,44022,2,900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-25','2020-07-25',277.00,NULL,NULL,1,'2021-08-12 15:39:54','2021-08-12 15:39:54',NULL);
INSERT INTO `balance_libro` VALUES (899,2978,40847,44022,2,901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-26','2020-07-26',120.00,NULL,NULL,1,'2021-08-12 15:39:54','2021-08-12 15:39:54',NULL),(900,2978,40847,44022,2,902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-26','2020-07-26',577.00,NULL,NULL,1,'2021-08-12 15:39:54','2021-08-12 15:39:54',NULL),(901,2978,40847,44022,2,903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-26','2020-07-26',148.00,NULL,NULL,1,'2021-08-12 15:39:54','2021-08-12 15:39:54',NULL),(902,2978,40847,44022,2,904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-26','2020-07-26',453.00,NULL,NULL,1,'2021-08-12 15:39:54','2021-08-12 15:39:54',NULL),(903,2978,40847,44022,2,905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-26','2020-07-26',89.00,NULL,NULL,1,'2021-08-12 15:39:54','2021-08-12 15:39:54',NULL),(904,2978,40847,44022,2,906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-26','2020-07-26',899.00,NULL,NULL,1,'2021-08-12 15:39:54','2021-08-12 15:39:54',NULL),(905,2978,40847,44022,2,907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-26','2020-07-26',105.00,NULL,NULL,1,'2021-08-12 15:39:54','2021-08-12 15:39:54',NULL),(906,2978,40847,44022,2,908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-26','2020-07-26',240.00,NULL,NULL,1,'2021-08-12 15:39:54','2021-08-12 15:39:54',NULL),(907,2978,40847,44022,2,909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-26','2020-07-26',216.00,NULL,NULL,1,'2021-08-12 15:39:54','2021-08-12 15:39:54',NULL),(908,2978,40847,44022,2,910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-26','2020-07-26',239.00,NULL,NULL,1,'2021-08-12 15:39:54','2021-08-12 15:39:54',NULL),(909,2978,40847,44022,2,911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-28','2020-07-28',153.00,NULL,NULL,1,'2021-08-12 15:39:54','2021-08-12 15:39:54',NULL),(910,2978,40847,44022,2,912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-28','2020-07-28',138.00,NULL,NULL,1,'2021-08-12 15:39:54','2021-08-12 15:39:54',NULL),(911,2978,40847,44022,2,913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-28','2020-07-28',183.00,NULL,NULL,1,'2021-08-12 15:39:54','2021-08-12 15:39:54',NULL),(912,2978,40847,44022,2,914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-28','2020-07-28',103.00,NULL,NULL,1,'2021-08-12 15:39:54','2021-08-12 15:39:54',NULL),(913,2978,40847,44022,2,915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-28','2020-07-28',227.00,NULL,NULL,1,'2021-08-12 15:39:54','2021-08-12 15:39:54',NULL),(914,2978,40847,44022,2,916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-28','2020-07-28',108.00,NULL,NULL,1,'2021-08-12 15:39:54','2021-08-12 15:39:54',NULL),(915,2978,40847,44022,2,917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-28','2020-07-28',103.00,NULL,NULL,1,'2021-08-12 15:39:54','2021-08-12 15:39:54',NULL),(916,2978,40847,44022,2,918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-28','2020-07-28',399.00,NULL,NULL,1,'2021-08-12 15:39:54','2021-08-12 15:39:54',NULL),(917,2978,40847,44022,2,919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-28','2020-07-28',112.00,NULL,NULL,1,'2021-08-12 15:39:54','2021-08-12 15:39:54',NULL),(918,2978,40847,44022,2,920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-29','2020-07-29',133.00,NULL,NULL,1,'2021-08-12 15:39:54','2021-08-12 15:39:54',NULL),(919,2978,40847,44022,2,921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-29','2020-07-29',145.00,NULL,NULL,1,'2021-08-12 15:39:54','2021-08-12 15:39:54',NULL),(920,2978,40847,44022,2,922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-29','2020-07-29',122.00,NULL,NULL,1,'2021-08-12 15:39:54','2021-08-12 15:39:54',NULL),(921,2978,40847,44022,2,923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-29','2020-07-29',148.00,NULL,NULL,1,'2021-08-12 15:39:54','2021-08-12 15:39:54',NULL),(922,2978,40847,44022,2,924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-29','2020-07-29',140.00,NULL,NULL,1,'2021-08-12 15:39:54','2021-08-12 15:39:54',NULL),(923,2978,40847,44022,2,925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-29','2020-07-29',212.00,NULL,NULL,1,'2021-08-12 15:39:54','2021-08-12 15:39:54',NULL);
INSERT INTO `balance_libro` VALUES (924,2978,40847,44022,2,926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-29','2020-07-29',138.00,NULL,NULL,1,'2021-08-12 15:39:55','2021-08-12 15:39:55',NULL),(925,2978,40847,44022,2,927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-29','2020-07-29',92.00,NULL,NULL,1,'2021-08-12 15:39:55','2021-08-12 15:39:55',NULL),(926,2978,40847,44022,2,928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-29','2020-07-29',239.00,NULL,NULL,1,'2021-08-12 15:39:55','2021-08-12 15:39:55',NULL),(927,2978,40847,44022,2,929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-29','2020-07-29',194.00,NULL,NULL,1,'2021-08-12 15:39:55','2021-08-12 15:39:55',NULL),(928,2978,40847,44022,2,930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-29','2020-07-29',150.00,NULL,NULL,1,'2021-08-12 15:39:55','2021-08-12 15:39:55',NULL),(929,2978,40847,44022,2,931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-30','2020-07-30',198.00,NULL,NULL,1,'2021-08-12 15:39:55','2021-08-12 15:39:55',NULL),(930,2978,40847,44022,2,932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-30','2020-07-30',562.00,NULL,NULL,1,'2021-08-12 15:39:55','2021-08-12 15:39:55',NULL),(931,2978,40847,44022,2,933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-30','2020-07-30',89.00,NULL,NULL,1,'2021-08-12 15:39:55','2021-08-12 15:39:55',NULL),(932,2978,40847,44022,2,934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-30','2020-07-30',166.00,NULL,NULL,1,'2021-08-12 15:39:55','2021-08-12 15:39:55',NULL),(933,2978,40847,44022,2,935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-30','2020-07-30',89.00,NULL,NULL,1,'2021-08-12 15:39:55','2021-08-12 15:39:55',NULL),(934,2978,40847,44022,2,936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-30','2020-07-30',91.00,NULL,NULL,1,'2021-08-12 15:39:55','2021-08-12 15:39:55',NULL),(935,2978,40847,44022,2,937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',268.00,NULL,NULL,1,'2021-08-12 15:39:55','2021-08-12 15:39:55',NULL),(936,2978,40847,44022,2,938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',89.00,NULL,NULL,1,'2021-08-12 15:39:55','2021-08-12 15:39:55',NULL),(937,2978,40847,44022,2,939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',173.00,NULL,NULL,1,'2021-08-12 15:39:55','2021-08-12 15:39:55',NULL),(938,2978,40847,44022,2,940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',89.00,NULL,NULL,1,'2021-08-12 15:39:55','2021-08-12 15:39:55',NULL),(939,2978,40847,44022,2,941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',149.00,NULL,NULL,1,'2021-08-12 15:39:55','2021-08-12 15:39:55',NULL),(940,2978,40847,44022,2,942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',193.00,NULL,NULL,1,'2021-08-12 15:39:55','2021-08-12 15:39:55',NULL),(941,2978,40847,44022,2,943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',153.00,NULL,NULL,1,'2021-08-12 15:39:55','2021-08-12 15:39:55',NULL),(942,2978,40847,44022,2,944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',163.00,NULL,NULL,1,'2021-08-12 15:39:55','2021-08-12 15:39:55',NULL),(943,2978,40847,44022,2,945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',89.00,NULL,NULL,1,'2021-08-12 15:39:55','2021-08-12 15:39:55',NULL),(944,2978,40847,44022,2,946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',143.00,NULL,NULL,1,'2021-08-12 15:39:55','2021-08-12 15:39:55',NULL),(945,2978,40847,44022,2,947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',257.00,NULL,NULL,1,'2021-08-12 15:39:55','2021-08-12 15:39:55',NULL),(946,2978,40847,44022,2,948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',321.00,NULL,NULL,1,'2021-08-12 15:39:55','2021-08-12 15:39:55',NULL),(947,2978,40847,44022,2,949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',202.00,NULL,NULL,1,'2021-08-12 15:39:55','2021-08-12 15:39:55',NULL),(948,2978,40847,44022,2,950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',98.00,NULL,NULL,1,'2021-08-12 15:39:55','2021-08-12 15:39:55',NULL);
INSERT INTO `balance_libro` VALUES (949,2978,40847,44023,2,951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-01','2020-08-01',91.00,NULL,NULL,1,'2021-08-12 15:41:11','2021-08-12 15:41:11',NULL),(950,2978,40847,44023,2,952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-01','2020-08-01',98.00,NULL,NULL,1,'2021-08-12 15:41:11','2021-08-12 15:41:11',NULL),(951,2978,40847,44023,2,953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-01','2020-08-01',108.00,NULL,NULL,1,'2021-08-12 15:41:11','2021-08-12 15:41:11',NULL),(952,2978,40847,44023,2,954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-01','2020-08-01',89.00,NULL,NULL,1,'2021-08-12 15:41:12','2021-08-12 15:41:12',NULL),(953,2978,40847,44023,2,955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-01','2020-08-01',224.00,NULL,NULL,1,'2021-08-12 15:41:12','2021-08-12 15:41:12',NULL),(954,2978,40847,44023,2,956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-02','2020-08-02',404.00,NULL,NULL,1,'2021-08-12 15:41:12','2021-08-12 15:41:12',NULL),(955,2978,40847,44023,2,957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-02','2020-08-02',531.00,NULL,NULL,1,'2021-08-12 15:41:12','2021-08-12 15:41:12',NULL),(956,2978,40847,44023,2,958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-02','2020-08-02',174.00,NULL,NULL,1,'2021-08-12 15:41:12','2021-08-12 15:41:12',NULL),(957,2978,40847,44023,2,959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-02','2020-08-02',181.00,NULL,NULL,1,'2021-08-12 15:41:12','2021-08-12 15:41:12',NULL),(958,2978,40847,44023,2,960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-02','2020-08-02',377.00,NULL,NULL,1,'2021-08-12 15:41:12','2021-08-12 15:41:12',NULL),(959,2978,40847,44023,2,961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-03','2020-08-03',320.00,NULL,NULL,1,'2021-08-12 15:41:12','2021-08-12 15:41:12',NULL),(960,2978,40847,44023,2,962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-03','2020-08-03',130.00,NULL,NULL,1,'2021-08-12 15:41:12','2021-08-12 15:41:12',NULL),(961,2978,40847,44023,2,963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-03','2020-08-03',154.00,NULL,NULL,1,'2021-08-12 15:41:12','2021-08-12 15:41:12',NULL),(962,2978,40847,44023,2,964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-03','2020-08-03',244.00,NULL,NULL,1,'2021-08-12 15:41:12','2021-08-12 15:41:12',NULL),(963,2978,40847,44023,2,965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-03','2020-08-03',147.00,NULL,NULL,1,'2021-08-12 15:41:12','2021-08-12 15:41:12',NULL),(964,2978,40847,44023,2,966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-03','2020-08-03',143.00,NULL,NULL,1,'2021-08-12 15:41:12','2021-08-12 15:41:12',NULL),(965,2978,40847,44023,2,967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-04','2020-08-04',187.00,NULL,NULL,1,'2021-08-12 15:41:12','2021-08-12 15:41:12',NULL),(966,2978,40847,44023,2,968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-04','2020-08-04',329.00,NULL,NULL,1,'2021-08-12 15:41:12','2021-08-12 15:41:12',NULL),(967,2978,40847,44023,2,969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-04','2020-08-04',294.00,NULL,NULL,1,'2021-08-12 15:41:12','2021-08-12 15:41:12',NULL),(968,2978,40847,44023,2,970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-04','2020-08-04',250.00,NULL,NULL,1,'2021-08-12 15:41:12','2021-08-12 15:41:12',NULL),(969,2978,40847,44023,2,971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-04','2020-08-04',110.00,NULL,NULL,1,'2021-08-12 15:41:12','2021-08-12 15:41:12',NULL),(970,2978,40847,44023,2,972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-04','2020-08-04',207.00,NULL,NULL,1,'2021-08-12 15:41:12','2021-08-12 15:41:12',NULL),(971,2978,40847,44023,2,973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-04','2020-08-04',591.00,NULL,NULL,1,'2021-08-12 15:41:12','2021-08-12 15:41:12',NULL),(972,2978,40847,44023,2,974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-07','2020-08-07',274.00,NULL,NULL,1,'2021-08-12 15:41:12','2021-08-12 15:41:12',NULL),(973,2978,40847,44023,2,975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-07','2020-08-07',104.00,NULL,NULL,1,'2021-08-12 15:41:12','2021-08-12 15:41:12',NULL);
INSERT INTO `balance_libro` VALUES (974,2978,40847,44023,2,976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-07','2020-08-07',338.00,NULL,NULL,1,'2021-08-12 15:41:12','2021-08-12 15:41:12',NULL),(975,2978,40847,44023,2,977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-07','2020-08-07',138.00,NULL,NULL,1,'2021-08-12 15:41:12','2021-08-12 15:41:12',NULL),(976,2978,40847,44023,2,978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-07','2020-08-07',93.00,NULL,NULL,1,'2021-08-12 15:41:12','2021-08-12 15:41:12',NULL),(977,2978,40847,44023,2,979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-07','2020-08-07',268.00,NULL,NULL,1,'2021-08-12 15:41:12','2021-08-12 15:41:12',NULL),(978,2978,40847,44023,2,980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-07','2020-08-07',116.00,NULL,NULL,1,'2021-08-12 15:41:13','2021-08-12 15:41:13',NULL),(979,2978,40847,44023,2,981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-07','2020-08-07',147.00,NULL,NULL,1,'2021-08-12 15:41:13','2021-08-12 15:41:13',NULL),(980,2978,40847,44023,2,982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-07','2020-08-07',108.00,NULL,NULL,1,'2021-08-12 15:41:13','2021-08-12 15:41:13',NULL),(981,2978,40847,44023,2,983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-07','2020-08-07',109.00,NULL,NULL,1,'2021-08-12 15:41:13','2021-08-12 15:41:13',NULL),(982,2978,40847,44023,2,984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-07','2020-08-07',269.00,NULL,NULL,1,'2021-08-12 15:41:13','2021-08-12 15:41:13',NULL),(983,2978,40847,44023,2,985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-07','2020-08-07',328.00,NULL,NULL,1,'2021-08-12 15:41:13','2021-08-12 15:41:13',NULL),(984,2978,40847,44023,2,986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-07','2020-08-07',132.00,NULL,NULL,1,'2021-08-12 15:41:13','2021-08-12 15:41:13',NULL),(985,2978,40847,44023,2,987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-08','2020-08-08',300.00,NULL,NULL,1,'2021-08-12 15:41:13','2021-08-12 15:41:13',NULL),(986,2978,40847,44023,2,988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-08','2020-08-08',219.00,NULL,NULL,1,'2021-08-12 15:41:13','2021-08-12 15:41:13',NULL),(987,2978,40847,44023,2,989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-08','2020-08-08',259.00,NULL,NULL,1,'2021-08-12 15:41:13','2021-08-12 15:41:13',NULL),(988,2978,40847,44023,2,990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-09','2020-08-09',147.00,NULL,NULL,1,'2021-08-12 15:41:13','2021-08-12 15:41:13',NULL),(989,2978,40847,44023,2,991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-09','2020-08-09',165.00,NULL,NULL,1,'2021-08-12 15:41:13','2021-08-12 15:41:13',NULL),(990,2978,40847,44023,2,992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-09','2020-08-09',133.00,NULL,NULL,1,'2021-08-12 15:41:13','2021-08-12 15:41:13',NULL),(991,2978,40847,44023,2,993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-09','2020-08-09',246.00,NULL,NULL,1,'2021-08-12 15:41:13','2021-08-12 15:41:13',NULL),(992,2978,40847,44023,2,994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-09','2020-08-09',161.00,NULL,NULL,1,'2021-08-12 15:41:13','2021-08-12 15:41:13',NULL),(993,2978,40847,44023,2,995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-09','2020-08-09',210.00,NULL,NULL,1,'2021-08-12 15:41:13','2021-08-12 15:41:13',NULL),(994,2978,40847,44023,2,996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-09','2020-08-09',211.00,NULL,NULL,1,'2021-08-12 15:41:13','2021-08-12 15:41:13',NULL),(995,2978,40847,44023,2,997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-09','2020-08-09',60.00,NULL,NULL,1,'2021-08-12 15:41:13','2021-08-12 15:41:13',NULL),(996,2978,40847,44023,2,998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-09','2020-08-09',162.00,NULL,NULL,1,'2021-08-12 15:41:13','2021-08-12 15:41:13',NULL),(997,2978,40847,44023,2,999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-09','2020-08-09',281.00,NULL,NULL,1,'2021-08-12 15:41:13','2021-08-12 15:41:13',NULL),(998,2978,40847,44023,2,1000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-09','2020-08-09',658.00,NULL,NULL,1,'2021-08-12 15:41:13','2021-08-12 15:41:13',NULL);
INSERT INTO `balance_libro` VALUES (999,2978,40847,44023,2,1001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-09','2020-08-09',169.00,NULL,NULL,1,'2021-08-12 15:41:13','2021-08-12 15:41:13',NULL),(1000,2978,40847,44023,2,1002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-09','2020-08-09',275.00,NULL,NULL,1,'2021-08-12 15:41:13','2021-08-12 15:41:13',NULL),(1001,2978,40847,44023,2,1003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-09','2020-08-09',141.00,NULL,NULL,1,'2021-08-12 15:41:13','2021-08-12 15:41:13',NULL),(1002,2978,40847,44023,2,1004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-09','2020-08-09',137.00,NULL,NULL,1,'2021-08-12 15:41:13','2021-08-12 15:41:13',NULL),(1003,2978,40847,44023,2,1005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-10','2020-08-10',255.00,NULL,NULL,1,'2021-08-12 15:41:13','2021-08-12 15:41:13',NULL),(1004,2978,40847,44023,2,1006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-10','2020-08-10',148.00,NULL,NULL,1,'2021-08-12 15:41:13','2021-08-12 15:41:13',NULL),(1005,2978,40847,44023,2,1007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-10','2020-08-10',637.00,NULL,NULL,1,'2021-08-12 15:41:14','2021-08-12 15:41:14',NULL),(1006,2978,40847,44023,2,1008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-10','2020-08-10',1006.00,NULL,NULL,1,'2021-08-12 15:41:14','2021-08-12 15:41:14',NULL),(1007,2978,40847,44023,2,1009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-11','2020-08-11',112.00,NULL,NULL,1,'2021-08-12 15:41:14','2021-08-12 15:41:14',NULL),(1008,2978,40847,44023,2,1010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-11','2020-08-11',121.00,NULL,NULL,1,'2021-08-12 15:41:14','2021-08-12 15:41:14',NULL),(1009,2978,40847,44023,2,1011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-11','2020-08-11',210.00,NULL,NULL,1,'2021-08-12 15:41:14','2021-08-12 15:41:14',NULL),(1010,2978,40847,44023,2,1012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-12','2020-08-12',288.00,NULL,NULL,1,'2021-08-12 15:41:14','2021-08-12 15:41:14',NULL),(1011,2978,40847,44023,2,1013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-12','2020-08-12',340.00,NULL,NULL,1,'2021-08-12 15:41:14','2021-08-12 15:41:14',NULL),(1012,2978,40847,44023,2,1014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-12','2020-08-12',331.00,NULL,NULL,1,'2021-08-12 15:41:14','2021-08-12 15:41:14',NULL),(1013,2978,40847,44023,2,1015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-12','2020-08-12',119.00,NULL,NULL,1,'2021-08-12 15:41:14','2021-08-12 15:41:14',NULL),(1014,2978,40847,44023,2,1016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-12','2020-08-12',116.00,NULL,NULL,1,'2021-08-12 15:41:14','2021-08-12 15:41:14',NULL),(1015,2978,40847,44023,2,1017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-12','2020-08-12',141.00,NULL,NULL,1,'2021-08-12 15:41:14','2021-08-12 15:41:14',NULL),(1016,2978,40847,44023,2,1018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-12','2020-08-12',154.00,NULL,NULL,1,'2021-08-12 15:41:14','2021-08-12 15:41:14',NULL),(1017,2978,40847,44023,2,1019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-12','2020-08-12',158.00,NULL,NULL,1,'2021-08-12 15:41:14','2021-08-12 15:41:14',NULL),(1018,2978,40847,44023,2,1020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-12','2020-08-12',103.00,NULL,NULL,1,'2021-08-12 15:41:14','2021-08-12 15:41:14',NULL),(1019,2978,40847,44023,2,1021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-12','2020-08-12',140.00,NULL,NULL,1,'2021-08-12 15:41:14','2021-08-12 15:41:14',NULL),(1020,2978,40847,44023,2,1022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-13','2020-08-13',349.00,NULL,NULL,1,'2021-08-12 15:41:14','2021-08-12 15:41:14',NULL),(1021,2978,40847,44023,2,1023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-13','2020-08-13',179.00,NULL,NULL,1,'2021-08-12 15:41:14','2021-08-12 15:41:14',NULL),(1022,2978,40847,44023,2,1024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-13','2020-08-13',108.00,NULL,NULL,1,'2021-08-12 15:41:14','2021-08-12 15:41:14',NULL);
INSERT INTO `balance_libro` VALUES (1023,2978,40847,44023,2,1025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-13','2020-08-13',228.00,NULL,NULL,1,'2021-08-12 15:41:14','2021-08-12 15:41:14',NULL),(1024,2978,40847,44023,2,1026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-13','2020-08-13',232.00,NULL,NULL,1,'2021-08-12 15:41:14','2021-08-12 15:41:14',NULL),(1025,2978,40847,44023,2,1027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-13','2020-08-13',163.00,NULL,NULL,1,'2021-08-12 15:41:14','2021-08-12 15:41:14',NULL),(1026,2978,40847,44023,2,1028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-13','2020-08-13',343.00,NULL,NULL,1,'2021-08-12 15:41:14','2021-08-12 15:41:14',NULL),(1027,2978,40847,44023,2,1029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-13','2020-08-13',103.00,NULL,NULL,1,'2021-08-12 15:41:14','2021-08-12 15:41:14',NULL),(1028,2978,40847,44023,2,1030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-13','2020-08-13',89.00,NULL,NULL,1,'2021-08-12 15:41:14','2021-08-12 15:41:14',NULL),(1029,2978,40847,44023,2,1031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-13','2020-08-13',110.00,NULL,NULL,1,'2021-08-12 15:41:14','2021-08-12 15:41:14',NULL),(1030,2978,40847,44023,2,1032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-13','2020-08-13',120.00,NULL,NULL,1,'2021-08-12 15:41:14','2021-08-12 15:41:14',NULL),(1031,2978,40847,44023,2,1033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-13','2020-08-13',131.00,NULL,NULL,1,'2021-08-12 15:41:14','2021-08-12 15:41:14',NULL),(1032,2978,40847,44023,2,1034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-13','2020-08-13',297.00,NULL,NULL,1,'2021-08-12 15:41:14','2021-08-12 15:41:14',NULL),(1033,2978,40847,44023,2,1035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-13','2020-08-13',129.00,NULL,NULL,1,'2021-08-12 15:41:14','2021-08-12 15:41:14',NULL),(1034,2978,40847,44023,2,1036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-14','2020-08-14',253.00,NULL,NULL,1,'2021-08-12 15:41:14','2021-08-12 15:41:14',NULL),(1035,2978,40847,44023,2,1037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-14','2020-08-14',247.00,NULL,NULL,1,'2021-08-12 15:41:15','2021-08-12 15:41:15',NULL),(1036,2978,40847,44023,2,1038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-14','2020-08-14',283.00,NULL,NULL,1,'2021-08-12 15:41:15','2021-08-12 15:41:15',NULL),(1037,2978,40847,44023,2,1039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-14','2020-08-14',126.00,NULL,NULL,1,'2021-08-12 15:41:15','2021-08-12 15:41:15',NULL),(1038,2978,40847,44023,2,1040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-14','2020-08-14',119.00,NULL,NULL,1,'2021-08-12 15:41:15','2021-08-12 15:41:15',NULL),(1039,2978,40847,44023,2,1041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-15','2020-08-15',144.00,NULL,NULL,1,'2021-08-12 15:41:15','2021-08-12 15:41:15',NULL),(1040,2978,40847,44023,2,1042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-15','2020-08-15',146.00,NULL,NULL,1,'2021-08-12 15:41:15','2021-08-12 15:41:15',NULL),(1041,2978,40847,44023,2,1043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-15','2020-08-15',203.00,NULL,NULL,1,'2021-08-12 15:41:15','2021-08-12 15:41:15',NULL),(1042,2978,40847,44023,2,1044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-15','2020-08-15',242.00,NULL,NULL,1,'2021-08-12 15:41:15','2021-08-12 15:41:15',NULL),(1043,2978,40847,44023,2,1045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-16','2020-08-16',332.00,NULL,NULL,1,'2021-08-12 15:41:15','2021-08-12 15:41:15',NULL),(1044,2978,40847,44023,2,1046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-16','2020-08-16',523.00,NULL,NULL,1,'2021-08-12 15:41:15','2021-08-12 15:41:15',NULL),(1045,2978,40847,44023,2,1047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-16','2020-08-16',1009.00,NULL,NULL,1,'2021-08-12 15:41:15','2021-08-12 15:41:15',NULL),(1046,2978,40847,44023,2,1048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-16','2020-08-16',143.00,NULL,NULL,1,'2021-08-12 15:41:15','2021-08-12 15:41:15',NULL);
INSERT INTO `balance_libro` VALUES (1047,2978,40847,44023,2,1049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-16','2020-08-16',134.00,NULL,NULL,1,'2021-08-12 15:41:15','2021-08-12 15:41:15',NULL),(1048,2978,40847,44023,2,1050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-16','2020-08-16',198.00,NULL,NULL,1,'2021-08-12 15:41:15','2021-08-12 15:41:15',NULL),(1049,2978,40847,44023,2,1051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-16','2020-08-16',40.00,NULL,NULL,1,'2021-08-12 15:41:15','2021-08-12 15:41:15',NULL),(1050,2978,40847,44023,2,1052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-16','2020-08-16',197.00,NULL,NULL,1,'2021-08-12 15:41:15','2021-08-12 15:41:15',NULL),(1051,2978,40847,44023,2,1053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-17','2020-08-17',364.00,NULL,NULL,1,'2021-08-12 15:41:15','2021-08-12 15:41:15',NULL),(1052,2978,40847,44023,2,1054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-17','2020-08-17',278.00,NULL,NULL,1,'2021-08-12 15:41:15','2021-08-12 15:41:15',NULL),(1053,2978,40847,44023,2,1055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-17','2020-08-17',390.00,NULL,NULL,1,'2021-08-12 15:41:15','2021-08-12 15:41:15',NULL),(1054,2978,40847,44023,2,1056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-18','2020-08-18',73.00,NULL,NULL,1,'2021-08-12 15:41:15','2021-08-12 15:41:15',NULL),(1055,2978,40847,44023,2,1057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-18','2020-08-18',108.00,NULL,NULL,1,'2021-08-12 15:41:15','2021-08-12 15:41:15',NULL),(1056,2978,40847,44023,2,1058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-18','2020-08-18',169.00,NULL,NULL,1,'2021-08-12 15:41:15','2021-08-12 15:41:15',NULL),(1057,2978,40847,44023,2,1059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-18','2020-08-18',275.00,NULL,NULL,1,'2021-08-12 15:41:15','2021-08-12 15:41:15',NULL),(1058,2978,40847,44023,2,1060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-22','2020-08-22',184.00,NULL,NULL,1,'2021-08-12 15:41:15','2021-08-12 15:41:15',NULL),(1059,2978,40847,44023,2,1061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-22','2020-08-22',962.00,NULL,NULL,1,'2021-08-12 15:41:15','2021-08-12 15:41:15',NULL),(1060,2978,40847,44023,2,1062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-22','2020-08-22',318.00,NULL,NULL,1,'2021-08-12 15:41:15','2021-08-12 15:41:15',NULL),(1061,2978,40847,44023,2,1063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-22','2020-08-22',166.00,NULL,NULL,1,'2021-08-12 15:41:15','2021-08-12 15:41:15',NULL),(1062,2978,40847,44023,2,1064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-22','2020-08-22',89.00,NULL,NULL,1,'2021-08-12 15:41:15','2021-08-12 15:41:15',NULL),(1063,2978,40847,44023,2,1065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-22','2020-08-22',263.00,NULL,NULL,1,'2021-08-12 15:41:15','2021-08-12 15:41:15',NULL),(1064,2978,40847,44023,2,1066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-22','2020-08-22',160.00,NULL,NULL,1,'2021-08-12 15:41:15','2021-08-12 15:41:15',NULL),(1065,2978,40847,44023,2,1067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-22','2020-08-22',222.00,NULL,NULL,1,'2021-08-12 15:41:15','2021-08-12 15:41:15',NULL),(1066,2978,40847,44023,2,1068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-22','2020-08-22',206.00,NULL,NULL,1,'2021-08-12 15:41:16','2021-08-12 15:41:16',NULL),(1067,2978,40847,44023,2,1069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-22','2020-08-22',89.00,NULL,NULL,1,'2021-08-12 15:41:16','2021-08-12 15:41:16',NULL),(1068,2978,40847,44023,2,1070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-22','2020-08-22',264.00,NULL,NULL,1,'2021-08-12 15:41:16','2021-08-12 15:41:16',NULL),(1069,2978,40847,44023,2,1071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-22','2020-08-22',207.00,NULL,NULL,1,'2021-08-12 15:41:16','2021-08-12 15:41:16',NULL),(1070,2978,40847,44023,2,1072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-22','2020-08-22',92.00,NULL,NULL,1,'2021-08-12 15:41:16','2021-08-12 15:41:16',NULL);
INSERT INTO `balance_libro` VALUES (1071,2978,40847,44023,2,1073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-22','2020-08-22',240.00,NULL,NULL,1,'2021-08-12 15:41:16','2021-08-12 15:41:16',NULL),(1072,2978,40847,44023,2,1074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-23','2020-08-23',130.00,NULL,NULL,1,'2021-08-12 15:41:16','2021-08-12 15:41:16',NULL),(1073,2978,40847,44023,2,1075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-23','2020-08-23',123.00,NULL,NULL,1,'2021-08-12 15:41:16','2021-08-12 15:41:16',NULL),(1074,2978,40847,44023,2,1076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-23','2020-08-23',275.00,NULL,NULL,1,'2021-08-12 15:41:16','2021-08-12 15:41:16',NULL),(1075,2978,40847,44023,2,1077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-23','2020-08-23',134.00,NULL,NULL,1,'2021-08-12 15:41:16','2021-08-12 15:41:16',NULL),(1076,2978,40847,44023,2,1078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-23','2020-08-23',473.00,NULL,NULL,1,'2021-08-12 15:41:16','2021-08-12 15:41:16',NULL),(1077,2978,40847,44023,2,1079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-23','2020-08-23',94.00,NULL,NULL,1,'2021-08-12 15:41:16','2021-08-12 15:41:16',NULL),(1078,2978,40847,44023,2,1080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-23','2020-08-23',179.00,NULL,NULL,1,'2021-08-12 15:41:16','2021-08-12 15:41:16',NULL),(1079,2978,40847,44023,2,1081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-23','2020-08-23',398.00,NULL,NULL,1,'2021-08-12 15:41:16','2021-08-12 15:41:16',NULL),(1080,2978,40847,44023,2,1082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-23','2020-08-23',233.00,NULL,NULL,1,'2021-08-12 15:41:16','2021-08-12 15:41:16',NULL),(1081,2978,40847,44023,2,1083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-26','2020-08-26',2050.00,NULL,NULL,1,'2021-08-12 15:41:16','2021-08-12 15:41:16',NULL),(1082,2978,40847,44023,2,1084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-27','2020-08-27',2150.00,NULL,NULL,1,'2021-08-12 15:41:16','2021-08-12 15:41:16',NULL),(1083,2978,40847,44023,2,1085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-27','2020-08-27',112.00,NULL,NULL,1,'2021-08-12 15:41:16','2021-08-12 15:41:16',NULL),(1084,2978,40847,44023,2,1086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-27','2020-08-27',98.00,NULL,NULL,1,'2021-08-12 15:41:16','2021-08-12 15:41:16',NULL),(1085,2978,40847,44023,2,1087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-27','2020-08-27',217.00,NULL,NULL,1,'2021-08-12 15:41:16','2021-08-12 15:41:16',NULL),(1086,2978,40847,44023,2,1088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-27','2020-08-27',89.00,NULL,NULL,1,'2021-08-12 15:41:16','2021-08-12 15:41:16',NULL),(1087,2978,40847,44023,2,1089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-27','2020-08-27',135.00,NULL,NULL,1,'2021-08-12 15:41:16','2021-08-12 15:41:16',NULL),(1088,2978,40847,44023,2,1090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-27','2020-08-27',130.00,NULL,NULL,1,'2021-08-12 15:41:16','2021-08-12 15:41:16',NULL),(1089,2978,40847,44023,2,1091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-27','2020-08-27',102.00,NULL,NULL,1,'2021-08-12 15:41:16','2021-08-12 15:41:16',NULL),(1090,2978,40847,44023,2,1092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-27','2020-08-27',121.00,NULL,NULL,1,'2021-08-12 15:41:16','2021-08-12 15:41:16',NULL),(1091,2978,40847,44023,2,1093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-28','2020-08-28',1950.00,NULL,NULL,1,'2021-08-12 15:41:16','2021-08-12 15:41:16',NULL),(1092,2978,40847,44023,2,1094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-29','2020-08-29',141.00,NULL,NULL,1,'2021-08-12 15:41:16','2021-08-12 15:41:16',NULL),(1093,2978,40847,44023,2,1095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-29','2020-08-29',97.00,NULL,NULL,1,'2021-08-12 15:41:16','2021-08-12 15:41:16',NULL),(1094,2978,40847,44023,2,1096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-29','2020-08-29',199.00,NULL,NULL,1,'2021-08-12 15:41:16','2021-08-12 15:41:16',NULL);
INSERT INTO `balance_libro` VALUES (1095,2978,40847,44023,2,1097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-29','2020-08-29',160.00,NULL,NULL,1,'2021-08-12 15:41:17','2021-08-12 15:41:17',NULL),(1096,2978,40847,44023,2,1098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-29','2020-08-29',189.00,NULL,NULL,1,'2021-08-12 15:41:17','2021-08-12 15:41:17',NULL),(1097,2978,40847,44023,2,1099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-29','2020-08-29',158.00,NULL,NULL,1,'2021-08-12 15:41:17','2021-08-12 15:41:17',NULL),(1098,2978,40847,44023,2,1100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-29','2020-08-29',114.00,NULL,NULL,1,'2021-08-12 15:41:17','2021-08-12 15:41:17',NULL),(1099,2978,40847,44023,2,1101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-29','2020-08-29',108.00,NULL,NULL,1,'2021-08-12 15:41:17','2021-08-12 15:41:17',NULL),(1100,2978,40847,44023,2,1102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-29','2020-08-29',133.00,NULL,NULL,1,'2021-08-12 15:41:17','2021-08-12 15:41:17',NULL),(1101,2978,40847,44023,2,1103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-29','2020-08-29',89.00,NULL,NULL,1,'2021-08-12 15:41:17','2021-08-12 15:41:17',NULL),(1102,2978,40847,44023,2,1104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-29','2020-08-29',144.00,NULL,NULL,1,'2021-08-12 15:41:17','2021-08-12 15:41:17',NULL),(1103,2978,40847,44023,2,1105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-29','2020-08-29',291.00,NULL,NULL,1,'2021-08-12 15:41:17','2021-08-12 15:41:17',NULL),(1104,2978,40847,44023,2,1106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-29','2020-08-29',116.00,NULL,NULL,1,'2021-08-12 15:41:17','2021-08-12 15:41:17',NULL),(1105,2978,40847,44023,2,1107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-29','2020-08-29',89.00,NULL,NULL,1,'2021-08-12 15:41:17','2021-08-12 15:41:17',NULL),(1106,2978,40847,44023,2,1108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-29','2020-08-29',227.00,NULL,NULL,1,'2021-08-12 15:41:17','2021-08-12 15:41:17',NULL),(1107,2978,40847,44023,2,1109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-30','2020-08-30',229.00,NULL,NULL,1,'2021-08-12 15:41:17','2021-08-12 15:41:17',NULL),(1108,2978,40847,44023,2,1110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-30','2020-08-30',131.00,NULL,NULL,1,'2021-08-12 15:41:17','2021-08-12 15:41:17',NULL),(1109,2978,40847,44023,2,1111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',153.00,NULL,NULL,1,'2021-08-12 15:41:17','2021-08-12 15:41:17',NULL),(1110,2978,40847,44023,2,1112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',201.00,NULL,NULL,1,'2021-08-12 15:41:17','2021-08-12 15:41:17',NULL),(1111,2978,40847,44023,2,1113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',357.00,NULL,NULL,1,'2021-08-12 15:41:17','2021-08-12 15:41:17',NULL),(1112,2978,40847,44024,2,1114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-01','2020-09-01',89.00,NULL,NULL,1,'2021-08-12 15:42:28','2021-08-12 15:42:28',NULL),(1113,2978,40847,44024,2,1115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-01','2020-09-01',94.00,NULL,NULL,1,'2021-08-12 15:42:28','2021-08-12 15:42:28',NULL),(1114,2978,40847,44024,2,1116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-01','2020-09-01',118.00,NULL,NULL,1,'2021-08-12 15:42:28','2021-08-12 15:42:28',NULL),(1115,2978,40847,44024,2,1117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-01','2020-09-01',235.00,NULL,NULL,1,'2021-08-12 15:42:28','2021-08-12 15:42:28',NULL),(1116,2978,40847,44024,2,1118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-01','2020-09-01',286.00,NULL,NULL,1,'2021-08-12 15:42:28','2021-08-12 15:42:28',NULL),(1117,2978,40847,44024,2,1119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-01','2020-09-01',191.00,NULL,NULL,1,'2021-08-12 15:42:28','2021-08-12 15:42:28',NULL),(1118,2978,40847,44024,2,1120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-01','2020-09-01',100.00,NULL,NULL,1,'2021-08-12 15:42:28','2021-08-12 15:42:28',NULL);
INSERT INTO `balance_libro` VALUES (1119,2978,40847,44024,2,1121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-01','2020-09-01',239.00,NULL,NULL,1,'2021-08-12 15:42:28','2021-08-12 15:42:28',NULL),(1120,2978,40847,44024,2,1122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-01','2020-09-01',105.00,NULL,NULL,1,'2021-08-12 15:42:28','2021-08-12 15:42:28',NULL),(1121,2978,40847,44024,2,1123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-01','2020-09-01',188.00,NULL,NULL,1,'2021-08-12 15:42:28','2021-08-12 15:42:28',NULL),(1122,2978,40847,44024,2,1124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-01','2020-09-01',181.00,NULL,NULL,1,'2021-08-12 15:42:28','2021-08-12 15:42:28',NULL),(1123,2978,40847,44024,2,1125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-02','2020-09-02',288.00,NULL,NULL,1,'2021-08-12 15:42:28','2021-08-12 15:42:28',NULL),(1124,2978,40847,44024,2,1126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-03','2020-09-03',227.00,NULL,NULL,1,'2021-08-12 15:42:28','2021-08-12 15:42:28',NULL),(1125,2978,40847,44024,2,1127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-03','2020-09-03',181.00,NULL,NULL,1,'2021-08-12 15:42:28','2021-08-12 15:42:28',NULL),(1126,2978,40847,44024,2,1128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-03','2020-09-03',182.00,NULL,NULL,1,'2021-08-12 15:42:28','2021-08-12 15:42:28',NULL),(1127,2978,40847,44024,2,1129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-03','2020-09-03',149.00,NULL,NULL,1,'2021-08-12 15:42:28','2021-08-12 15:42:28',NULL),(1128,2978,40847,44024,2,1130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-03','2020-09-03',105.00,NULL,NULL,1,'2021-08-12 15:42:28','2021-08-12 15:42:28',NULL),(1129,2978,40847,44024,2,1131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-04','2020-09-04',165.00,NULL,NULL,1,'2021-08-12 15:42:28','2021-08-12 15:42:28',NULL),(1130,2978,40847,44024,2,1132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-04','2020-09-04',421.00,NULL,NULL,1,'2021-08-12 15:42:28','2021-08-12 15:42:28',NULL),(1131,2978,40847,44024,2,1133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-04','2020-09-04',142.00,NULL,NULL,1,'2021-08-12 15:42:28','2021-08-12 15:42:28',NULL),(1132,2978,40847,44024,2,1134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-04','2020-09-04',179.00,NULL,NULL,1,'2021-08-12 15:42:28','2021-08-12 15:42:28',NULL),(1133,2978,40847,44024,2,1135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-04','2020-09-04',128.00,NULL,NULL,1,'2021-08-12 15:42:28','2021-08-12 15:42:28',NULL),(1134,2978,40847,44024,2,1136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-04','2020-09-04',225.00,NULL,NULL,1,'2021-08-12 15:42:28','2021-08-12 15:42:28',NULL),(1135,2978,40847,44024,2,1137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-04','2020-09-04',187.00,NULL,NULL,1,'2021-08-12 15:42:28','2021-08-12 15:42:28',NULL),(1136,2978,40847,44024,2,1138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-04','2020-09-04',128.00,NULL,NULL,1,'2021-08-12 15:42:28','2021-08-12 15:42:28',NULL),(1137,2978,40847,44024,2,1139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-04','2020-09-04',121.00,NULL,NULL,1,'2021-08-12 15:42:28','2021-08-12 15:42:28',NULL),(1138,2978,40847,44024,2,1140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-04','2020-09-04',98.00,NULL,NULL,1,'2021-08-12 15:42:29','2021-08-12 15:42:29',NULL),(1139,2978,40847,44024,2,1141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-05','2020-09-05',208.00,NULL,NULL,1,'2021-08-12 15:42:29','2021-08-12 15:42:29',NULL),(1140,2978,40847,44024,2,1142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-05','2020-09-05',314.00,NULL,NULL,1,'2021-08-12 15:42:29','2021-08-12 15:42:29',NULL),(1141,2978,40847,44024,2,1143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-05','2020-09-05',154.00,NULL,NULL,1,'2021-08-12 15:42:29','2021-08-12 15:42:29',NULL),(1142,2978,40847,44024,2,1144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-05','2020-09-05',350.00,NULL,NULL,1,'2021-08-12 15:42:29','2021-08-12 15:42:29',NULL);
INSERT INTO `balance_libro` VALUES (1143,2978,40847,44024,2,1145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-05','2020-09-05',477.00,NULL,NULL,1,'2021-08-12 15:42:29','2021-08-12 15:42:29',NULL),(1144,2978,40847,44024,2,1146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-06','2020-09-06',122.00,NULL,NULL,1,'2021-08-12 15:42:29','2021-08-12 15:42:29',NULL),(1145,2978,40847,44024,2,1147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-06','2020-09-06',478.00,NULL,NULL,1,'2021-08-12 15:42:29','2021-08-12 15:42:29',NULL),(1146,2978,40847,44024,2,1148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-06','2020-09-06',165.00,NULL,NULL,1,'2021-08-12 15:42:29','2021-08-12 15:42:29',NULL),(1147,2978,40847,44024,2,1149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-06','2020-09-06',55.00,NULL,NULL,1,'2021-08-12 15:42:29','2021-08-12 15:42:29',NULL),(1148,2978,40847,44024,2,1150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-06','2020-09-06',236.00,NULL,NULL,1,'2021-08-12 15:42:29','2021-08-12 15:42:29',NULL),(1149,2978,40847,44024,2,1151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-06','2020-09-06',873.00,NULL,NULL,1,'2021-08-12 15:42:29','2021-08-12 15:42:29',NULL),(1150,2978,40847,44024,2,1152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-07','2020-09-07',480.00,NULL,NULL,1,'2021-08-12 15:42:29','2021-08-12 15:42:29',NULL),(1151,2978,40847,44024,2,1153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-07','2020-09-07',525.00,NULL,NULL,1,'2021-08-12 15:42:29','2021-08-12 15:42:29',NULL),(1152,2978,40847,44024,2,1154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-08','2020-09-08',114.00,NULL,NULL,1,'2021-08-12 15:42:29','2021-08-12 15:42:29',NULL),(1153,2978,40847,44024,2,1155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-08','2020-09-08',162.00,NULL,NULL,1,'2021-08-12 15:42:29','2021-08-12 15:42:29',NULL),(1154,2978,40847,44024,2,1156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-08','2020-09-08',98.00,NULL,NULL,1,'2021-08-12 15:42:29','2021-08-12 15:42:29',NULL),(1155,2978,40847,44024,2,1157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-08','2020-09-08',138.00,NULL,NULL,1,'2021-08-12 15:42:29','2021-08-12 15:42:29',NULL),(1156,2978,40847,44024,2,1158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-08','2020-09-08',124.00,NULL,NULL,1,'2021-08-12 15:42:29','2021-08-12 15:42:29',NULL),(1157,2978,40847,44024,2,1159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-08','2020-09-08',117.00,NULL,NULL,1,'2021-08-12 15:42:29','2021-08-12 15:42:29',NULL),(1158,2978,40847,44024,2,1160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-09','2020-09-09',152.00,NULL,NULL,1,'2021-08-12 15:42:29','2021-08-12 15:42:29',NULL),(1159,2978,40847,44024,2,1161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-09','2020-09-09',102.00,NULL,NULL,1,'2021-08-12 15:42:29','2021-08-12 15:42:29',NULL),(1160,2978,40847,44024,2,1162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-09','2020-09-09',130.00,NULL,NULL,1,'2021-08-12 15:42:29','2021-08-12 15:42:29',NULL),(1161,2978,40847,44024,2,1163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-09','2020-09-09',124.00,NULL,NULL,1,'2021-08-12 15:42:29','2021-08-12 15:42:29',NULL),(1162,2978,40847,44024,2,1164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-09','2020-09-09',98.00,NULL,NULL,1,'2021-08-12 15:42:29','2021-08-12 15:42:29',NULL),(1163,2978,40847,44024,2,1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-09','2020-09-09',144.00,NULL,NULL,1,'2021-08-12 15:42:29','2021-08-12 15:42:29',NULL),(1164,2978,40847,44024,2,1166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-09','2020-09-09',129.00,NULL,NULL,1,'2021-08-12 15:42:29','2021-08-12 15:42:29',NULL),(1165,2978,40847,44024,2,1167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-09','2020-09-09',158.00,NULL,NULL,1,'2021-08-12 15:42:29','2021-08-12 15:42:29',NULL),(1166,2978,40847,44024,2,1168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-09','2020-09-09',135.00,NULL,NULL,1,'2021-08-12 15:42:29','2021-08-12 15:42:29',NULL);
INSERT INTO `balance_libro` VALUES (1167,2978,40847,44024,2,1169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-09','2020-09-09',132.00,NULL,NULL,1,'2021-08-12 15:42:30','2021-08-12 15:42:30',NULL),(1168,2978,40847,44024,2,1170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-09','2020-09-09',134.00,NULL,NULL,1,'2021-08-12 15:42:30','2021-08-12 15:42:30',NULL),(1169,2978,40847,44024,2,1171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-09','2020-09-09',98.00,NULL,NULL,1,'2021-08-12 15:42:30','2021-08-12 15:42:30',NULL),(1170,2978,40847,44024,2,1172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-09','2020-09-09',98.00,NULL,NULL,1,'2021-08-12 15:42:30','2021-08-12 15:42:30',NULL),(1171,2978,40847,44024,2,1173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-10','2020-09-10',228.00,NULL,NULL,1,'2021-08-12 15:42:30','2021-08-12 15:42:30',NULL),(1172,2978,40847,44024,2,1174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-10','2020-09-10',151.00,NULL,NULL,1,'2021-08-12 15:42:30','2021-08-12 15:42:30',NULL),(1173,2978,40847,44024,2,1175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-10','2020-09-10',414.00,NULL,NULL,1,'2021-08-12 15:42:30','2021-08-12 15:42:30',NULL),(1174,2978,40847,44024,2,1176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-10','2020-09-10',269.00,NULL,NULL,1,'2021-08-12 15:42:30','2021-08-12 15:42:30',NULL),(1175,2978,40847,44024,2,1177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-10','2020-09-10',335.00,NULL,NULL,1,'2021-08-12 15:42:30','2021-08-12 15:42:30',NULL),(1176,2978,40847,44024,2,1178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-10','2020-09-10',308.00,NULL,NULL,1,'2021-08-12 15:42:30','2021-08-12 15:42:30',NULL),(1177,2978,40847,44024,2,1179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-10','2020-09-10',127.00,NULL,NULL,1,'2021-08-12 15:42:30','2021-08-12 15:42:30',NULL),(1178,2978,40847,44024,2,1180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-10','2020-09-10',956.00,NULL,NULL,1,'2021-08-12 15:42:30','2021-08-12 15:42:30',NULL),(1179,2978,40847,44024,2,1181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-12','2020-09-12',75.00,NULL,NULL,1,'2021-08-12 15:42:30','2021-08-12 15:42:30',NULL),(1180,2978,40847,44024,2,1182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-12','2020-09-12',101.00,NULL,NULL,1,'2021-08-12 15:42:30','2021-08-12 15:42:30',NULL),(1181,2978,40847,44024,2,1183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-12','2020-09-12',98.00,NULL,NULL,1,'2021-08-12 15:42:30','2021-08-12 15:42:30',NULL),(1182,2978,40847,44024,2,1184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-12','2020-09-12',764.00,NULL,NULL,1,'2021-08-12 15:42:30','2021-08-12 15:42:30',NULL),(1183,2978,40847,44024,2,1185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-12','2020-09-12',114.00,NULL,NULL,1,'2021-08-12 15:42:30','2021-08-12 15:42:30',NULL),(1184,2978,40847,44024,2,1186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-15','2020-09-15',224.00,NULL,NULL,1,'2021-08-12 15:42:30','2021-08-12 15:42:30',NULL),(1185,2978,40847,44024,2,1187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-15','2020-09-15',122.00,NULL,NULL,1,'2021-08-12 15:42:30','2021-08-12 15:42:30',NULL),(1186,2978,40847,44024,2,1188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-15','2020-09-15',228.00,NULL,NULL,1,'2021-08-12 15:42:30','2021-08-12 15:42:30',NULL),(1187,2978,40847,44024,2,1189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-15','2020-09-15',417.00,NULL,NULL,1,'2021-08-12 15:42:30','2021-08-12 15:42:30',NULL),(1188,2978,40847,44024,2,1190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-15','2020-09-15',229.00,NULL,NULL,1,'2021-08-12 15:42:30','2021-08-12 15:42:30',NULL),(1189,2978,40847,44024,2,1191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-15','2020-09-15',330.00,NULL,NULL,1,'2021-08-12 15:42:30','2021-08-12 15:42:30',NULL),(1190,2978,40847,44024,2,1192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-15','2020-09-15',160.00,NULL,NULL,1,'2021-08-12 15:42:30','2021-08-12 15:42:30',NULL);
INSERT INTO `balance_libro` VALUES (1191,2978,40847,44024,2,1193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-15','2020-09-15',296.00,NULL,NULL,1,'2021-08-12 15:42:30','2021-08-12 15:42:30',NULL),(1192,2978,40847,44024,2,1194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-15','2020-09-15',118.00,NULL,NULL,1,'2021-08-12 15:42:30','2021-08-12 15:42:30',NULL),(1193,2978,40847,44024,2,1195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-17','2020-09-17',243.00,NULL,NULL,1,'2021-08-12 15:42:30','2021-08-12 15:42:30',NULL),(1194,2978,40847,44024,2,1196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-17','2020-09-17',276.00,NULL,NULL,1,'2021-08-12 15:42:31','2021-08-12 15:42:31',NULL),(1195,2978,40847,44024,2,1197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-17','2020-09-17',129.00,NULL,NULL,1,'2021-08-12 15:42:31','2021-08-12 15:42:31',NULL),(1196,2978,40847,44024,2,1198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-17','2020-09-17',141.00,NULL,NULL,1,'2021-08-12 15:42:31','2021-08-12 15:42:31',NULL),(1197,2978,40847,44024,2,1199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-17','2020-09-17',318.00,NULL,NULL,1,'2021-08-12 15:42:31','2021-08-12 15:42:31',NULL),(1198,2978,40847,44024,2,1200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-17','2020-09-17',165.00,NULL,NULL,1,'2021-08-12 15:42:31','2021-08-12 15:42:31',NULL),(1199,2978,40847,44024,2,1201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-17','2020-09-17',116.00,NULL,NULL,1,'2021-08-12 15:42:31','2021-08-12 15:42:31',NULL),(1200,2978,40847,44024,2,1202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-17','2020-09-17',132.00,NULL,NULL,1,'2021-08-12 15:42:31','2021-08-12 15:42:31',NULL),(1201,2978,40847,44024,2,1203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-17','2020-09-17',174.00,NULL,NULL,1,'2021-08-12 15:42:31','2021-08-12 15:42:31',NULL),(1202,2978,40847,44024,2,1204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-17','2020-09-17',313.00,NULL,NULL,1,'2021-08-12 15:42:31','2021-08-12 15:42:31',NULL),(1203,2978,40847,44024,2,1205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-17','2020-09-17',130.00,NULL,NULL,1,'2021-08-12 15:42:31','2021-08-12 15:42:31',NULL),(1204,2978,40847,44024,2,1206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-17','2020-09-17',287.00,NULL,NULL,1,'2021-08-12 15:42:31','2021-08-12 15:42:31',NULL),(1205,2978,40847,44024,2,1207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-17','2020-09-17',226.00,NULL,NULL,1,'2021-08-12 15:42:31','2021-08-12 15:42:31',NULL),(1206,2978,40847,44024,2,1208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-18','2020-09-18',126.00,NULL,NULL,1,'2021-08-12 15:42:31','2021-08-12 15:42:31',NULL),(1207,2978,40847,44024,2,1209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-18','2020-09-18',154.00,NULL,NULL,1,'2021-08-12 15:42:31','2021-08-12 15:42:31',NULL),(1208,2978,40847,44024,2,1210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-18','2020-09-18',112.00,NULL,NULL,1,'2021-08-12 15:42:31','2021-08-12 15:42:31',NULL),(1209,2978,40847,44024,2,1211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-18','2020-09-18',116.00,NULL,NULL,1,'2021-08-12 15:42:31','2021-08-12 15:42:31',NULL),(1210,2978,40847,44024,2,1212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-18','2020-09-18',389.00,NULL,NULL,1,'2021-08-12 15:42:31','2021-08-12 15:42:31',NULL),(1211,2978,40847,44024,2,1213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-18','2020-09-18',173.00,NULL,NULL,1,'2021-08-12 15:42:31','2021-08-12 15:42:31',NULL),(1212,2978,40847,44024,2,1214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-18','2020-09-18',121.00,NULL,NULL,1,'2021-08-12 15:42:31','2021-08-12 15:42:31',NULL),(1213,2978,40847,44024,2,1215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-20','2020-09-20',392.00,NULL,NULL,1,'2021-08-12 15:42:31','2021-08-12 15:42:31',NULL),(1214,2978,40847,44024,2,1216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-20','2020-09-20',426.00,NULL,NULL,1,'2021-08-12 15:42:31','2021-08-12 15:42:31',NULL);
INSERT INTO `balance_libro` VALUES (1215,2978,40847,44024,2,1217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-20','2020-09-20',258.00,NULL,NULL,1,'2021-08-12 15:42:31','2021-08-12 15:42:31',NULL),(1216,2978,40847,44024,2,1218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-20','2020-09-20',160.00,NULL,NULL,1,'2021-08-12 15:42:31','2021-08-12 15:42:31',NULL),(1217,2978,40847,44024,2,1219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-20','2020-09-20',769.00,NULL,NULL,1,'2021-08-12 15:42:31','2021-08-12 15:42:31',NULL),(1218,2978,40847,44024,2,1220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-24','2020-09-24',100.00,NULL,NULL,1,'2021-08-12 15:42:31','2021-08-12 15:42:31',NULL),(1219,2978,40847,44024,2,1221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-24','2020-09-24',271.00,NULL,NULL,1,'2021-08-12 15:42:31','2021-08-12 15:42:31',NULL),(1220,2978,40847,44024,2,1222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-24','2020-09-24',128.00,NULL,NULL,1,'2021-08-12 15:42:31','2021-08-12 15:42:31',NULL),(1221,2978,40847,44024,2,1223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-24','2020-09-24',165.00,NULL,NULL,1,'2021-08-12 15:42:32','2021-08-12 15:42:32',NULL),(1222,2978,40847,44024,2,1224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-24','2020-09-24',198.00,NULL,NULL,1,'2021-08-12 15:42:32','2021-08-12 15:42:32',NULL),(1223,2978,40847,44024,2,1225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-25','2020-09-25',224.00,NULL,NULL,1,'2021-08-12 15:42:32','2021-08-12 15:42:32',NULL),(1224,2978,40847,44024,2,1226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-25','2020-09-25',162.00,NULL,NULL,1,'2021-08-12 15:42:32','2021-08-12 15:42:32',NULL),(1225,2978,40847,44024,2,1227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-25','2020-09-25',242.00,NULL,NULL,1,'2021-08-12 15:42:32','2021-08-12 15:42:32',NULL),(1226,2978,40847,44024,2,1228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-25','2020-09-25',134.00,NULL,NULL,1,'2021-08-12 15:42:32','2021-08-12 15:42:32',NULL),(1227,2978,40847,44024,2,1229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-25','2020-09-25',191.00,NULL,NULL,1,'2021-08-12 15:42:32','2021-08-12 15:42:32',NULL),(1228,2978,40847,44024,2,1230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-25','2020-09-25',116.00,NULL,NULL,1,'2021-08-12 15:42:32','2021-08-12 15:42:32',NULL),(1229,2978,40847,44024,2,1231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-25','2020-09-25',644.00,NULL,NULL,1,'2021-08-12 15:42:32','2021-08-12 15:42:32',NULL),(1230,2978,40847,44024,2,1232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-26','2020-09-26',155.00,NULL,NULL,1,'2021-08-12 15:42:32','2021-08-12 15:42:32',NULL),(1231,2978,40847,44024,2,1233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-26','2020-09-26',167.00,NULL,NULL,1,'2021-08-12 15:42:32','2021-08-12 15:42:32',NULL),(1232,2978,40847,44024,2,1234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-26','2020-09-26',359.00,NULL,NULL,1,'2021-08-12 15:42:32','2021-08-12 15:42:32',NULL),(1233,2978,40847,44024,2,1235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-27','2020-09-27',85.00,NULL,NULL,1,'2021-08-12 15:42:32','2021-08-12 15:42:32',NULL),(1234,2978,40847,44024,2,1236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-27','2020-09-27',347.00,NULL,NULL,1,'2021-08-12 15:42:32','2021-08-12 15:42:32',NULL),(1235,2978,40847,44024,2,1237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-27','2020-09-27',204.00,NULL,NULL,1,'2021-08-12 15:42:32','2021-08-12 15:42:32',NULL),(1236,2978,40847,44024,2,1238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-27','2020-09-27',102.00,NULL,NULL,1,'2021-08-12 15:42:32','2021-08-12 15:42:32',NULL),(1237,2978,40847,44024,2,1239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-27','2020-09-27',154.00,NULL,NULL,1,'2021-08-12 15:42:32','2021-08-12 15:42:32',NULL),(1238,2978,40847,44024,2,1240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-27','2020-09-27',334.00,NULL,NULL,1,'2021-08-12 15:42:32','2021-08-12 15:42:32',NULL);
INSERT INTO `balance_libro` VALUES (1239,2978,40847,44024,2,1241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-27','2020-09-27',149.00,NULL,NULL,1,'2021-08-12 15:42:32','2021-08-12 15:42:32',NULL),(1240,2978,40847,44024,2,1242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-27','2020-09-27',280.00,NULL,NULL,1,'2021-08-12 15:42:32','2021-08-12 15:42:32',NULL),(1241,2978,40847,44024,2,1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-27','2020-09-27',567.00,NULL,NULL,1,'2021-08-12 15:42:32','2021-08-12 15:42:32',NULL),(1242,2978,40847,44024,2,1244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-28','2020-09-28',900.00,NULL,NULL,1,'2021-08-12 15:42:32','2021-08-12 15:42:32',NULL),(1243,2978,40847,44024,2,1245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-29','2020-09-29',200.00,NULL,NULL,1,'2021-08-12 15:42:32','2021-08-12 15:42:32',NULL),(1244,2978,40847,44024,2,1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-29','2020-09-29',114.00,NULL,NULL,1,'2021-08-12 15:42:32','2021-08-12 15:42:32',NULL),(1245,2978,40847,44024,2,1247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-29','2020-09-29',124.00,NULL,NULL,1,'2021-08-12 15:42:32','2021-08-12 15:42:32',NULL),(1246,2978,40847,44024,2,1248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-29','2020-09-29',144.00,NULL,NULL,1,'2021-08-12 15:42:32','2021-08-12 15:42:32',NULL),(1247,2978,40847,44024,2,1249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-29','2020-09-29',190.00,NULL,NULL,1,'2021-08-12 15:42:33','2021-08-12 15:42:33',NULL),(1248,2978,40847,44024,2,1250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-29','2020-09-29',372.00,NULL,NULL,1,'2021-08-12 15:42:33','2021-08-12 15:42:33',NULL),(1249,2978,40847,44024,2,1251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',400.00,NULL,NULL,1,'2021-08-12 15:42:33','2021-08-12 15:42:33',NULL),(1250,2978,40847,44024,2,1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',98.00,NULL,NULL,1,'2021-08-12 15:42:33','2021-08-12 15:42:33',NULL),(1251,2978,40847,44024,2,1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',143.00,NULL,NULL,1,'2021-08-12 15:42:33','2021-08-12 15:42:33',NULL),(1252,2978,40847,44024,2,1254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',192.00,NULL,NULL,1,'2021-08-12 15:42:33','2021-08-12 15:42:33',NULL),(1253,2978,40847,44024,2,1255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',292.00,NULL,NULL,1,'2021-08-12 15:42:33','2021-08-12 15:42:33',NULL),(1254,2978,40847,44024,2,1256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',99.00,NULL,NULL,1,'2021-08-12 15:42:33','2021-08-12 15:42:33',NULL),(1255,2978,40847,44024,2,1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',98.00,NULL,NULL,1,'2021-08-12 15:42:33','2021-08-12 15:42:33',NULL),(1256,2978,40847,44024,2,1258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',308.00,NULL,NULL,1,'2021-08-12 15:42:33','2021-08-12 15:42:33',NULL),(1257,2978,40847,44024,2,1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',192.00,NULL,NULL,1,'2021-08-12 15:42:33','2021-08-12 15:42:33',NULL),(1258,2978,40847,44024,2,1260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',111.00,NULL,NULL,1,'2021-08-12 15:42:33','2021-08-12 15:42:33',NULL),(1259,2978,40847,44024,2,1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',201.00,NULL,NULL,1,'2021-08-12 15:42:33','2021-08-12 15:42:33',NULL),(1260,2978,40847,44024,2,1262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',325.00,NULL,NULL,1,'2021-08-12 15:42:33','2021-08-12 15:42:33',NULL),(1261,2978,40847,44024,2,1263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',151.00,NULL,NULL,1,'2021-08-12 15:42:33','2021-08-12 15:42:33',NULL),(1262,2978,40847,44025,2,1264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-01','2020-10-01',299.00,NULL,NULL,1,'2021-08-12 15:44:01','2021-08-12 15:44:01',NULL);
INSERT INTO `balance_libro` VALUES (1263,2978,40847,44025,2,1265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-01','2020-10-01',232.00,NULL,NULL,1,'2021-08-12 15:44:01','2021-08-12 15:44:01',NULL),(1264,2978,40847,44025,2,1266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-01','2020-10-01',237.00,NULL,NULL,1,'2021-08-12 15:44:01','2021-08-12 15:44:01',NULL),(1265,2978,40847,44025,2,1267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-01','2020-10-01',98.00,NULL,NULL,1,'2021-08-12 15:44:01','2021-08-12 15:44:01',NULL),(1266,2978,40847,44025,2,1268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-01','2020-10-01',135.00,NULL,NULL,1,'2021-08-12 15:44:01','2021-08-12 15:44:01',NULL),(1267,2978,40847,44025,2,1269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-01','2020-10-01',99.00,NULL,NULL,1,'2021-08-12 15:44:02','2021-08-12 15:44:02',NULL),(1268,2978,40847,44025,2,1270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-01','2020-10-01',206.00,NULL,NULL,1,'2021-08-12 15:44:02','2021-08-12 15:44:02',NULL),(1269,2978,40847,44025,2,1271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-03','2020-10-03',111.00,NULL,NULL,1,'2021-08-12 15:44:02','2021-08-12 15:44:02',NULL),(1270,2978,40847,44025,2,1272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-03','2020-10-03',236.00,NULL,NULL,1,'2021-08-12 15:44:02','2021-08-12 15:44:02',NULL),(1271,2978,40847,44025,2,1273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-03','2020-10-03',176.00,NULL,NULL,1,'2021-08-12 15:44:02','2021-08-12 15:44:02',NULL),(1272,2978,40847,44025,2,1274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-03','2020-10-03',136.00,NULL,NULL,1,'2021-08-12 15:44:02','2021-08-12 15:44:02',NULL),(1273,2978,40847,44025,2,1275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-03','2020-10-03',119.00,NULL,NULL,1,'2021-08-12 15:44:02','2021-08-12 15:44:02',NULL),(1274,2978,40847,44025,2,1276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-03','2020-10-03',109.00,NULL,NULL,1,'2021-08-12 15:44:02','2021-08-12 15:44:02',NULL),(1275,2978,40847,44025,2,1277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-03','2020-10-03',132.00,NULL,NULL,1,'2021-08-12 15:44:02','2021-08-12 15:44:02',NULL),(1276,2978,40847,44025,2,1278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-03','2020-10-03',292.00,NULL,NULL,1,'2021-08-12 15:44:02','2021-08-12 15:44:02',NULL),(1277,2978,40847,44025,2,1279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-03','2020-10-03',337.00,NULL,NULL,1,'2021-08-12 15:44:02','2021-08-12 15:44:02',NULL),(1278,2978,40847,44025,2,1280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-03','2020-10-03',227.00,NULL,NULL,1,'2021-08-12 15:44:02','2021-08-12 15:44:02',NULL),(1279,2978,40847,44025,2,1281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-03','2020-10-03',295.00,NULL,NULL,1,'2021-08-12 15:44:02','2021-08-12 15:44:02',NULL),(1280,2978,40847,44025,2,1282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-03','2020-10-03',98.00,NULL,NULL,1,'2021-08-12 15:44:02','2021-08-12 15:44:02',NULL),(1281,2978,40847,44025,2,1283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-03','2020-10-03',98.00,NULL,NULL,1,'2021-08-12 15:44:02','2021-08-12 15:44:02',NULL),(1282,2978,40847,44025,2,1284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-03','2020-10-03',494.00,NULL,NULL,1,'2021-08-12 15:44:02','2021-08-12 15:44:02',NULL),(1283,2978,40847,44025,2,1285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-04','2020-10-04',325.00,NULL,NULL,1,'2021-08-12 15:44:02','2021-08-12 15:44:02',NULL),(1284,2978,40847,44025,2,1286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-04','2020-10-04',98.00,NULL,NULL,1,'2021-08-12 15:44:02','2021-08-12 15:44:02',NULL),(1285,2978,40847,44025,2,1287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-04','2020-10-04',378.00,NULL,NULL,1,'2021-08-12 15:44:02','2021-08-12 15:44:02',NULL),(1286,2978,40847,44025,2,1288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-04','2020-10-04',154.00,NULL,NULL,1,'2021-08-12 15:44:02','2021-08-12 15:44:02',NULL);
INSERT INTO `balance_libro` VALUES (1287,2978,40847,44025,2,1289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-04','2020-10-04',105.00,NULL,NULL,1,'2021-08-12 15:44:02','2021-08-12 15:44:02',NULL),(1288,2978,40847,44025,2,1290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-04','2020-10-04',635.00,NULL,NULL,1,'2021-08-12 15:44:03','2021-08-12 15:44:03',NULL),(1289,2978,40847,44025,2,1291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-05','2020-10-05',167.00,NULL,NULL,1,'2021-08-12 15:44:03','2021-08-12 15:44:03',NULL),(1290,2978,40847,44025,2,1292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-05','2020-10-05',98.00,NULL,NULL,1,'2021-08-12 15:44:03','2021-08-12 15:44:03',NULL),(1291,2978,40847,44025,2,1293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-05','2020-10-05',296.00,NULL,NULL,1,'2021-08-12 15:44:03','2021-08-12 15:44:03',NULL),(1292,2978,40847,44025,2,1294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-05','2020-10-05',567.00,NULL,NULL,1,'2021-08-12 15:44:03','2021-08-12 15:44:03',NULL),(1293,2978,40847,44025,2,1295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-06','2020-10-06',145.00,NULL,NULL,1,'2021-08-12 15:44:03','2021-08-12 15:44:03',NULL),(1294,2978,40847,44025,2,1296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-06','2020-10-06',153.00,NULL,NULL,1,'2021-08-12 15:44:03','2021-08-12 15:44:03',NULL),(1295,2978,40847,44025,2,1297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-06','2020-10-06',135.00,NULL,NULL,1,'2021-08-12 15:44:03','2021-08-12 15:44:03',NULL),(1296,2978,40847,44025,2,1298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-06','2020-10-06',688.00,NULL,NULL,1,'2021-08-12 15:44:03','2021-08-12 15:44:03',NULL),(1297,2978,40847,44025,2,1299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-06','2020-10-06',342.00,NULL,NULL,1,'2021-08-12 15:44:03','2021-08-12 15:44:03',NULL),(1298,2978,40847,44025,2,1300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-06','2020-10-06',250.00,NULL,NULL,1,'2021-08-12 15:44:03','2021-08-12 15:44:03',NULL),(1299,2978,40847,44025,2,1301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-09','2020-10-09',350.00,NULL,NULL,1,'2021-08-12 15:44:03','2021-08-12 15:44:03',NULL),(1300,2978,40847,44025,2,1302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-09','2020-10-09',216.00,NULL,NULL,1,'2021-08-12 15:44:03','2021-08-12 15:44:03',NULL),(1301,2978,40847,44025,2,1303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-09','2020-10-09',170.00,NULL,NULL,1,'2021-08-12 15:44:03','2021-08-12 15:44:03',NULL),(1302,2978,40847,44025,2,1304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-09','2020-10-09',208.00,NULL,NULL,1,'2021-08-12 15:44:03','2021-08-12 15:44:03',NULL),(1303,2978,40847,44025,2,1305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-09','2020-10-09',128.00,NULL,NULL,1,'2021-08-12 15:44:03','2021-08-12 15:44:03',NULL),(1304,2978,40847,44025,2,1306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-10','2020-10-10',99.00,NULL,NULL,1,'2021-08-12 15:44:03','2021-08-12 15:44:03',NULL),(1305,2978,40847,44025,2,1307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-10','2020-10-10',162.00,NULL,NULL,1,'2021-08-12 15:44:03','2021-08-12 15:44:03',NULL),(1306,2978,40847,44025,2,1308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-10','2020-10-10',412.00,NULL,NULL,1,'2021-08-12 15:44:03','2021-08-12 15:44:03',NULL),(1307,2978,40847,44025,2,1309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-10','2020-10-10',120.00,NULL,NULL,1,'2021-08-12 15:44:03','2021-08-12 15:44:03',NULL),(1308,2978,40847,44025,2,1310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-10','2020-10-10',193.00,NULL,NULL,1,'2021-08-12 15:44:03','2021-08-12 15:44:03',NULL),(1309,2978,40847,44025,2,1311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-10','2020-10-10',172.00,NULL,NULL,1,'2021-08-12 15:44:04','2021-08-12 15:44:04',NULL),(1310,2978,40847,44025,2,1312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-10','2020-10-10',263.00,NULL,NULL,1,'2021-08-12 15:44:04','2021-08-12 15:44:04',NULL);
INSERT INTO `balance_libro` VALUES (1311,2978,40847,44025,2,1313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-10','2020-10-10',423.00,NULL,NULL,1,'2021-08-12 15:44:04','2021-08-12 15:44:04',NULL),(1312,2978,40847,44025,2,1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-12','2020-10-12',368.00,NULL,NULL,1,'2021-08-12 15:44:04','2021-08-12 15:44:04',NULL),(1313,2978,40847,44025,2,1315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-12','2020-10-12',119.00,NULL,NULL,1,'2021-08-12 15:44:04','2021-08-12 15:44:04',NULL),(1314,2978,40847,44025,2,1316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-12','2020-10-12',139.00,NULL,NULL,1,'2021-08-12 15:44:04','2021-08-12 15:44:04',NULL),(1315,2978,40847,44025,2,1317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-12','2020-10-12',134.00,NULL,NULL,1,'2021-08-12 15:44:04','2021-08-12 15:44:04',NULL),(1316,2978,40847,44025,2,1318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-12','2020-10-12',115.00,NULL,NULL,1,'2021-08-12 15:44:04','2021-08-12 15:44:04',NULL),(1317,2978,40847,44025,2,1319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-12','2020-10-12',457.00,NULL,NULL,1,'2021-08-12 15:44:04','2021-08-12 15:44:04',NULL),(1318,2978,40847,44025,2,1320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-12','2020-10-12',97.00,NULL,NULL,1,'2021-08-12 15:44:04','2021-08-12 15:44:04',NULL),(1319,2978,40847,44025,2,1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-12','2020-10-12',234.00,NULL,NULL,1,'2021-08-12 15:44:04','2021-08-12 15:44:04',NULL),(1320,2978,40847,44025,2,1322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-13','2020-10-13',119.00,NULL,NULL,1,'2021-08-12 15:44:04','2021-08-12 15:44:04',NULL),(1321,2978,40847,44025,2,1323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-13','2020-10-13',385.00,NULL,NULL,1,'2021-08-12 15:44:04','2021-08-12 15:44:04',NULL),(1322,2978,40847,44025,2,1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-13','2020-10-13',132.00,NULL,NULL,1,'2021-08-12 15:44:04','2021-08-12 15:44:04',NULL),(1323,2978,40847,44025,2,1325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-13','2020-10-13',205.00,NULL,NULL,1,'2021-08-12 15:44:04','2021-08-12 15:44:04',NULL),(1324,2978,40847,44025,2,1326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-14','2020-10-14',112.00,NULL,NULL,1,'2021-08-12 15:44:05','2021-08-12 15:44:05',NULL),(1325,2978,40847,44025,2,1327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-14','2020-10-14',267.00,NULL,NULL,1,'2021-08-12 15:44:05','2021-08-12 15:44:05',NULL),(1326,2978,40847,44025,2,1328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-14','2020-10-14',164.00,NULL,NULL,1,'2021-08-12 15:44:05','2021-08-12 15:44:05',NULL),(1327,2978,40847,44025,2,1329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-14','2020-10-14',126.00,NULL,NULL,1,'2021-08-12 15:44:05','2021-08-12 15:44:05',NULL),(1328,2978,40847,44025,2,1330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-14','2020-10-14',171.00,NULL,NULL,1,'2021-08-12 15:44:05','2021-08-12 15:44:05',NULL),(1329,2978,40847,44025,2,1331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-14','2020-10-14',212.00,NULL,NULL,1,'2021-08-12 15:44:05','2021-08-12 15:44:05',NULL),(1330,2978,40847,44025,2,1332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-14','2020-10-14',97.00,NULL,NULL,1,'2021-08-12 15:44:05','2021-08-12 15:44:05',NULL),(1331,2978,40847,44025,2,1333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-14','2020-10-14',85.00,NULL,NULL,1,'2021-08-12 15:44:05','2021-08-12 15:44:05',NULL),(1332,2978,40847,44025,2,1334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-14','2020-10-14',527.00,NULL,NULL,1,'2021-08-12 15:44:05','2021-08-12 15:44:05',NULL),(1333,2978,40847,44025,2,1335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-15','2020-10-15',196.00,NULL,NULL,1,'2021-08-12 15:44:05','2021-08-12 15:44:05',NULL),(1334,2978,40847,44025,2,1336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-15','2020-10-15',141.00,NULL,NULL,1,'2021-08-12 15:44:05','2021-08-12 15:44:05',NULL);
INSERT INTO `balance_libro` VALUES (1335,2978,40847,44025,2,1337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-15','2020-10-15',118.00,NULL,NULL,1,'2021-08-12 15:44:05','2021-08-12 15:44:05',NULL),(1336,2978,40847,44025,2,1338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-16','2020-10-16',564.00,NULL,NULL,1,'2021-08-12 15:44:05','2021-08-12 15:44:05',NULL),(1337,2978,40847,44025,2,1339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-20','2020-10-20',181.00,NULL,NULL,1,'2021-08-12 15:44:05','2021-08-12 15:44:05',NULL),(1338,2978,40847,44025,2,1340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-20','2020-10-20',141.00,NULL,NULL,1,'2021-08-12 15:44:05','2021-08-12 15:44:05',NULL),(1339,2978,40847,44025,2,1341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-20','2020-10-20',97.00,NULL,NULL,1,'2021-08-12 15:44:05','2021-08-12 15:44:05',NULL),(1340,2978,40847,44025,2,1342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-20','2020-10-20',408.00,NULL,NULL,1,'2021-08-12 15:44:05','2021-08-12 15:44:05',NULL),(1341,2978,40847,44025,2,1343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-21','2020-10-21',225.00,NULL,NULL,1,'2021-08-12 15:44:05','2021-08-12 15:44:05',NULL),(1342,2978,40847,44025,2,1344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-21','2020-10-21',130.00,NULL,NULL,1,'2021-08-12 15:44:05','2021-08-12 15:44:05',NULL),(1343,2978,40847,44025,2,1345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-21','2020-10-21',134.00,NULL,NULL,1,'2021-08-12 15:44:05','2021-08-12 15:44:05',NULL),(1344,2978,40847,44025,2,1346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-21','2020-10-21',122.00,NULL,NULL,1,'2021-08-12 15:44:06','2021-08-12 15:44:06',NULL),(1345,2978,40847,44025,2,1347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-21','2020-10-21',125.00,NULL,NULL,1,'2021-08-12 15:44:06','2021-08-12 15:44:06',NULL),(1346,2978,40847,44025,2,1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-21','2020-10-21',180.00,NULL,NULL,1,'2021-08-12 15:44:06','2021-08-12 15:44:06',NULL),(1347,2978,40847,44025,2,1349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-21','2020-10-21',97.00,NULL,NULL,1,'2021-08-12 15:44:06','2021-08-12 15:44:06',NULL),(1348,2978,40847,44025,2,1350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-21','2020-10-21',97.00,NULL,NULL,1,'2021-08-12 15:44:06','2021-08-12 15:44:06',NULL),(1349,2978,40847,44025,2,1351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-21','2020-10-21',354.00,NULL,NULL,1,'2021-08-12 15:44:06','2021-08-12 15:44:06',NULL),(1350,2978,40847,44025,2,1352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-22','2020-10-22',173.00,NULL,NULL,1,'2021-08-12 15:44:06','2021-08-12 15:44:06',NULL),(1351,2978,40847,44025,2,1353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-22','2020-10-22',186.00,NULL,NULL,1,'2021-08-12 15:44:06','2021-08-12 15:44:06',NULL),(1352,2978,40847,44025,2,1354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-24','2020-10-24',239.00,NULL,NULL,1,'2021-08-12 15:44:06','2021-08-12 15:44:06',NULL),(1353,2978,40847,44025,2,1355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-24','2020-10-24',342.00,NULL,NULL,1,'2021-08-12 15:44:06','2021-08-12 15:44:06',NULL),(1354,2978,40847,44025,2,1356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-24','2020-10-24',128.00,NULL,NULL,1,'2021-08-12 15:44:06','2021-08-12 15:44:06',NULL),(1355,2978,40847,44025,2,1357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-24','2020-10-24',98.00,NULL,NULL,1,'2021-08-12 15:44:06','2021-08-12 15:44:06',NULL),(1356,2978,40847,44025,2,1358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-24','2020-10-24',172.00,NULL,NULL,1,'2021-08-12 15:44:06','2021-08-12 15:44:06',NULL),(1357,2978,40847,44025,2,1359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-24','2020-10-24',342.00,NULL,NULL,1,'2021-08-12 15:44:06','2021-08-12 15:44:06',NULL),(1358,2978,40847,44025,2,1360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-25','2020-10-25',125.00,NULL,NULL,1,'2021-08-12 15:44:06','2021-08-12 15:44:06',NULL);
INSERT INTO `balance_libro` VALUES (1359,2978,40847,44025,2,1361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-25','2020-10-25',493.00,NULL,NULL,1,'2021-08-12 15:44:06','2021-08-12 15:44:06',NULL),(1360,2978,40847,44025,2,1362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-25','2020-10-25',80.00,NULL,NULL,1,'2021-08-12 15:44:06','2021-08-12 15:44:06',NULL),(1361,2978,40847,44025,2,1363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-25','2020-10-25',128.00,NULL,NULL,1,'2021-08-12 15:44:06','2021-08-12 15:44:06',NULL),(1362,2978,40847,44025,2,1364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-25','2020-10-25',206.00,NULL,NULL,1,'2021-08-12 15:44:06','2021-08-12 15:44:06',NULL),(1363,2978,40847,44025,2,1365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-25','2020-10-25',97.00,NULL,NULL,1,'2021-08-12 15:44:06','2021-08-12 15:44:06',NULL),(1364,2978,40847,44025,2,1366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-25','2020-10-25',97.00,NULL,NULL,1,'2021-08-12 15:44:06','2021-08-12 15:44:06',NULL),(1365,2978,40847,44025,2,1367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-25','2020-10-25',239.00,NULL,NULL,1,'2021-08-12 15:44:06','2021-08-12 15:44:06',NULL),(1366,2978,40847,44025,2,1368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-25','2020-10-25',349.00,NULL,NULL,1,'2021-08-12 15:44:06','2021-08-12 15:44:06',NULL),(1367,2978,40847,44025,2,1369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-26','2020-10-26',117.00,NULL,NULL,1,'2021-08-12 15:44:06','2021-08-12 15:44:06',NULL),(1368,2978,40847,44025,2,1370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-26','2020-10-26',165.00,NULL,NULL,1,'2021-08-12 15:44:06','2021-08-12 15:44:06',NULL),(1369,2978,40847,44025,2,1371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-26','2020-10-26',175.00,NULL,NULL,1,'2021-08-12 15:44:06','2021-08-12 15:44:06',NULL),(1370,2978,40847,44025,2,1372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-26','2020-10-26',151.00,NULL,NULL,1,'2021-08-12 15:44:07','2021-08-12 15:44:07',NULL),(1371,2978,40847,44025,2,1373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-26','2020-10-26',453.12,NULL,NULL,1,'2021-08-12 15:44:07','2021-08-12 15:44:07',NULL),(1372,2978,40847,44025,2,1374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-28','2020-10-28',135.00,NULL,NULL,1,'2021-08-12 15:44:07','2021-08-12 15:44:07',NULL),(1373,2978,40847,44025,2,1375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-28','2020-10-28',408.00,NULL,NULL,1,'2021-08-12 15:44:07','2021-08-12 15:44:07',NULL),(1374,2978,40847,44025,2,1376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-28','2020-10-28',147.00,NULL,NULL,1,'2021-08-12 15:44:07','2021-08-12 15:44:07',NULL),(1375,2978,40847,44025,2,1377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-28','2020-10-28',196.00,NULL,NULL,1,'2021-08-12 15:44:07','2021-08-12 15:44:07',NULL),(1376,2978,40847,44025,2,1378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-28','2020-10-28',193.00,NULL,NULL,1,'2021-08-12 15:44:07','2021-08-12 15:44:07',NULL),(1377,2978,40847,44026,2,1379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-01','2020-11-01',329.00,NULL,NULL,1,'2021-08-12 15:45:42','2021-08-12 15:45:42',NULL),(1378,2978,40847,44026,2,1380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-01','2020-11-01',111.00,NULL,NULL,1,'2021-08-12 15:45:42','2021-08-12 15:45:42',NULL),(1379,2978,40847,44026,2,1381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-01','2020-11-01',415.00,NULL,NULL,1,'2021-08-12 15:45:42','2021-08-12 15:45:42',NULL),(1380,2978,40847,44026,2,1382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-01','2020-11-01',85.00,NULL,NULL,1,'2021-08-12 15:45:42','2021-08-12 15:45:42',NULL),(1381,2978,40847,44026,2,1383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-01','2020-11-01',563.00,NULL,NULL,1,'2021-08-12 15:45:42','2021-08-12 15:45:42',NULL),(1382,2978,40847,44026,2,1384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-03','2020-11-03',103.00,NULL,NULL,1,'2021-08-12 15:45:42','2021-08-12 15:45:42',NULL);
INSERT INTO `balance_libro` VALUES (1383,2978,40847,44026,2,1385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-03','2020-11-03',148.00,NULL,NULL,1,'2021-08-12 15:45:42','2021-08-12 15:45:42',NULL),(1384,2978,40847,44026,2,1386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-03','2020-11-03',120.00,NULL,NULL,1,'2021-08-12 15:45:42','2021-08-12 15:45:42',NULL),(1385,2978,40847,44026,2,1387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-03','2020-11-03',103.00,NULL,NULL,1,'2021-08-12 15:45:42','2021-08-12 15:45:42',NULL),(1386,2978,40847,44026,2,1388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-03','2020-11-03',121.00,NULL,NULL,1,'2021-08-12 15:45:42','2021-08-12 15:45:42',NULL),(1387,2978,40847,44026,2,1389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-03','2020-11-03',219.00,NULL,NULL,1,'2021-08-12 15:45:42','2021-08-12 15:45:42',NULL),(1388,2978,40847,44026,2,1390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-03','2020-11-03',224.00,NULL,NULL,1,'2021-08-12 15:45:42','2021-08-12 15:45:42',NULL),(1389,2978,40847,44026,2,1391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-03','2020-11-03',103.00,NULL,NULL,1,'2021-08-12 15:45:42','2021-08-12 15:45:42',NULL),(1390,2978,40847,44026,2,1392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-03','2020-11-03',177.00,NULL,NULL,1,'2021-08-12 15:45:43','2021-08-12 15:45:43',NULL),(1391,2978,40847,44026,2,1393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-03','2020-11-03',280.00,NULL,NULL,1,'2021-08-12 15:45:43','2021-08-12 15:45:43',NULL),(1392,2978,40847,44026,2,1394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-03','2020-11-03',266.00,NULL,NULL,1,'2021-08-12 15:45:43','2021-08-12 15:45:43',NULL),(1393,2978,40847,44026,2,1395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-03','2020-11-03',103.00,NULL,NULL,1,'2021-08-12 15:45:43','2021-08-12 15:45:43',NULL),(1394,2978,40847,44026,2,1396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-03','2020-11-03',207.00,NULL,NULL,1,'2021-08-12 15:45:43','2021-08-12 15:45:43',NULL),(1395,2978,40847,44026,2,1397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-03','2020-11-03',294.00,NULL,NULL,1,'2021-08-12 15:45:43','2021-08-12 15:45:43',NULL),(1396,2978,40847,44026,2,1398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-04','2020-11-04',103.00,NULL,NULL,1,'2021-08-12 15:45:43','2021-08-12 15:45:43',NULL),(1397,2978,40847,44026,2,1399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-04','2020-11-04',175.00,NULL,NULL,1,'2021-08-12 15:45:43','2021-08-12 15:45:43',NULL),(1398,2978,40847,44026,2,1400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-04','2020-11-04',251.00,NULL,NULL,1,'2021-08-12 15:45:43','2021-08-12 15:45:43',NULL),(1399,2978,40847,44026,2,1401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-04','2020-11-04',377.00,NULL,NULL,1,'2021-08-12 15:45:43','2021-08-12 15:45:43',NULL),(1400,2978,40847,44026,2,1402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-04','2020-11-04',148.00,NULL,NULL,1,'2021-08-12 15:45:43','2021-08-12 15:45:43',NULL),(1401,2978,40847,44026,2,1403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-04','2020-11-04',361.00,NULL,NULL,1,'2021-08-12 15:45:43','2021-08-12 15:45:43',NULL),(1402,2978,40847,44026,2,1404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-05','2020-11-05',540.00,NULL,NULL,1,'2021-08-12 15:45:43','2021-08-12 15:45:43',NULL),(1403,2978,40847,44026,2,1405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-07','2020-11-07',782.00,NULL,NULL,1,'2021-08-12 15:45:43','2021-08-12 15:45:43',NULL),(1404,2978,40847,44026,2,1406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-09','2020-11-09',237.00,NULL,NULL,1,'2021-08-12 15:45:43','2021-08-12 15:45:43',NULL),(1405,2978,40847,44026,2,1407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-09','2020-11-09',625.00,NULL,NULL,1,'2021-08-12 15:45:43','2021-08-12 15:45:43',NULL),(1406,2978,40847,44026,2,1408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-11','2020-11-11',221.00,NULL,NULL,1,'2021-08-12 15:45:43','2021-08-12 15:45:43',NULL);
INSERT INTO `balance_libro` VALUES (1407,2978,40847,44026,2,1409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-11','2020-11-11',542.00,NULL,NULL,1,'2021-08-12 15:45:44','2021-08-12 15:45:44',NULL),(1408,2978,40847,44026,2,1410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-11','2020-11-11',488.00,NULL,NULL,1,'2021-08-12 15:45:44','2021-08-12 15:45:44',NULL),(1409,2978,40847,44026,2,1411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-12','2020-11-12',172.00,NULL,NULL,1,'2021-08-12 15:45:44','2021-08-12 15:45:44',NULL),(1410,2978,40847,44026,2,1412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-12','2020-11-12',259.00,NULL,NULL,1,'2021-08-12 15:45:44','2021-08-12 15:45:44',NULL),(1411,2978,40847,44026,2,1413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-12','2020-11-12',117.00,NULL,NULL,1,'2021-08-12 15:45:44','2021-08-12 15:45:44',NULL),(1412,2978,40847,44026,2,1414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-12','2020-11-12',438.00,NULL,NULL,1,'2021-08-12 15:45:44','2021-08-12 15:45:44',NULL),(1413,2978,40847,44026,2,1415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-15','2020-11-15',442.00,NULL,NULL,1,'2021-08-12 15:45:44','2021-08-12 15:45:44',NULL),(1414,2978,40847,44026,2,1416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-15','2020-11-15',218.00,NULL,NULL,1,'2021-08-12 15:45:44','2021-08-12 15:45:44',NULL),(1415,2978,40847,44026,2,1417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-15','2020-11-15',239.00,NULL,NULL,1,'2021-08-12 15:45:44','2021-08-12 15:45:44',NULL),(1416,2978,40847,44026,2,1418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-15','2020-11-15',156.00,NULL,NULL,1,'2021-08-12 15:45:44','2021-08-12 15:45:44',NULL),(1417,2978,40847,44026,2,1419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-15','2020-11-15',155.00,NULL,NULL,1,'2021-08-12 15:45:44','2021-08-12 15:45:44',NULL),(1418,2978,40847,44026,2,1420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-15','2020-11-15',125.00,NULL,NULL,1,'2021-08-12 15:45:44','2021-08-12 15:45:44',NULL),(1419,2978,40847,44026,2,1421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-15','2020-11-15',630.00,NULL,NULL,1,'2021-08-12 15:45:44','2021-08-12 15:45:44',NULL),(1420,2978,40847,44026,2,1422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-15','2020-11-15',208.00,NULL,NULL,1,'2021-08-12 15:45:44','2021-08-12 15:45:44',NULL),(1421,2978,40847,44026,2,1423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-15','2020-11-15',250.00,NULL,NULL,1,'2021-08-12 15:45:44','2021-08-12 15:45:44',NULL),(1422,2978,40847,44026,2,1424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-15','2020-11-15',378.00,NULL,NULL,1,'2021-08-12 15:45:44','2021-08-12 15:45:44',NULL),(1423,2978,40847,44026,2,1425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-16','2020-11-16',1083.00,NULL,NULL,1,'2021-08-12 15:45:44','2021-08-12 15:45:44',NULL),(1424,2978,40847,44026,2,1426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-17','2020-11-17',183.00,NULL,NULL,1,'2021-08-12 15:45:44','2021-08-12 15:45:44',NULL),(1425,2978,40847,44026,2,1427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-17','2020-11-17',176.00,NULL,NULL,1,'2021-08-12 15:45:44','2021-08-12 15:45:44',NULL),(1426,2978,40847,44026,2,1428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-17','2020-11-17',173.00,NULL,NULL,1,'2021-08-12 15:45:44','2021-08-12 15:45:44',NULL),(1427,2978,40847,44026,2,1429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-18','2020-11-18',211.00,NULL,NULL,1,'2021-08-12 15:45:44','2021-08-12 15:45:44',NULL),(1428,2978,40847,44026,2,1430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-18','2020-11-18',546.00,NULL,NULL,1,'2021-08-12 15:45:44','2021-08-12 15:45:44',NULL),(1429,2978,40847,44026,2,1431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-19','2020-11-19',85.00,NULL,NULL,1,'2021-08-12 15:45:44','2021-08-12 15:45:44',NULL),(1430,2978,40847,44026,2,1432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-19','2020-11-19',147.00,NULL,NULL,1,'2021-08-12 15:45:44','2021-08-12 15:45:44',NULL);
INSERT INTO `balance_libro` VALUES (1431,2978,40847,44026,2,1433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-19','2020-11-19',105.00,NULL,NULL,1,'2021-08-12 15:45:44','2021-08-12 15:45:44',NULL),(1432,2978,40847,44026,2,1434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-19','2020-11-19',694.00,NULL,NULL,1,'2021-08-12 15:45:44','2021-08-12 15:45:44',NULL),(1433,2978,40847,44026,2,1435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-19','2020-11-19',55.00,NULL,NULL,1,'2021-08-12 15:45:45','2021-08-12 15:45:45',NULL),(1434,2978,40847,44026,2,1436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-19','2020-11-19',101.00,NULL,NULL,1,'2021-08-12 15:45:45','2021-08-12 15:45:45',NULL),(1435,2978,40847,44026,2,1437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-19','2020-11-19',153.00,NULL,NULL,1,'2021-08-12 15:45:45','2021-08-12 15:45:45',NULL),(1436,2978,40847,44026,2,1438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-19','2020-11-19',241.00,NULL,NULL,1,'2021-08-12 15:45:45','2021-08-12 15:45:45',NULL),(1437,2978,40847,44026,2,1439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-19','2020-11-19',465.24,NULL,NULL,1,'2021-08-12 15:45:45','2021-08-12 15:45:45',NULL),(1438,2978,40847,44026,2,1440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',165.00,NULL,NULL,1,'2021-08-12 15:45:45','2021-08-12 15:45:45',NULL),(1439,2978,40847,44026,2,1441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',391.00,NULL,NULL,1,'2021-08-12 15:45:45','2021-08-12 15:45:45',NULL),(1440,2978,40847,44026,2,1442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',189.00,NULL,NULL,1,'2021-08-12 15:45:45','2021-08-12 15:45:45',NULL),(1441,2978,40847,44026,2,1443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',107.00,NULL,NULL,1,'2021-08-12 15:45:45','2021-08-12 15:45:45',NULL),(1442,2978,40847,44026,2,1444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',238.00,NULL,NULL,1,'2021-08-12 15:45:45','2021-08-12 15:45:45',NULL),(1443,2978,40847,44026,2,1445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',280.00,NULL,NULL,1,'2021-08-12 15:45:45','2021-08-12 15:45:45',NULL),(1444,2978,40847,44026,2,1446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',487.00,NULL,NULL,1,'2021-08-12 15:45:45','2021-08-12 15:45:45',NULL),(1445,2978,40847,44026,2,1447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',121.00,NULL,NULL,1,'2021-08-12 15:45:45','2021-08-12 15:45:45',NULL),(1446,2978,40847,44026,2,1448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-22','2020-11-22',444.00,NULL,NULL,1,'2021-08-12 15:45:45','2021-08-12 15:45:45',NULL),(1447,2978,40847,44026,2,1449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-22','2020-11-22',156.00,NULL,NULL,1,'2021-08-12 15:45:45','2021-08-12 15:45:45',NULL),(1448,2978,40847,44026,2,1450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-22','2020-11-22',234.00,NULL,NULL,1,'2021-08-12 15:45:45','2021-08-12 15:45:45',NULL),(1449,2978,40847,44026,2,1451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-22','2020-11-22',110.00,NULL,NULL,1,'2021-08-12 15:45:45','2021-08-12 15:45:45',NULL),(1450,2978,40847,44026,2,1452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-22','2020-11-22',499.00,NULL,NULL,1,'2021-08-12 15:45:45','2021-08-12 15:45:45',NULL),(1451,2978,40847,44026,2,1453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-22','2020-11-22',230.00,NULL,NULL,1,'2021-08-12 15:45:45','2021-08-12 15:45:45',NULL),(1452,2978,40847,44026,2,1454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-22','2020-11-22',450.00,NULL,NULL,1,'2021-08-12 15:45:45','2021-08-12 15:45:45',NULL),(1453,2978,40847,44026,2,1455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-22','2020-11-22',288.00,NULL,NULL,1,'2021-08-12 15:45:45','2021-08-12 15:45:45',NULL),(1454,2978,40847,44026,2,1456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-22','2020-11-22',541.00,NULL,NULL,1,'2021-08-12 15:45:45','2021-08-12 15:45:45',NULL);
INSERT INTO `balance_libro` VALUES (1455,2978,40847,44026,2,1457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-23','2020-11-23',157.00,NULL,NULL,1,'2021-08-12 15:45:45','2021-08-12 15:45:45',NULL),(1456,2978,40847,44026,2,1458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-23','2020-11-23',239.00,NULL,NULL,1,'2021-08-12 15:45:45','2021-08-12 15:45:45',NULL),(1457,2978,40847,44026,2,1459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-23','2020-11-23',169.00,NULL,NULL,1,'2021-08-12 15:45:45','2021-08-12 15:45:45',NULL),(1458,2978,40847,44026,2,1460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-23','2020-11-23',227.00,NULL,NULL,1,'2021-08-12 15:45:46','2021-08-12 15:45:46',NULL),(1459,2978,40847,44026,2,1461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-23','2020-11-23',492.00,NULL,NULL,1,'2021-08-12 15:45:46','2021-08-12 15:45:46',NULL),(1460,2978,40847,44026,2,1462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-24','2020-11-24',209.00,NULL,NULL,1,'2021-08-12 15:45:46','2021-08-12 15:45:46',NULL),(1461,2978,40847,44026,2,1463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-24','2020-11-24',112.00,NULL,NULL,1,'2021-08-12 15:45:46','2021-08-12 15:45:46',NULL),(1462,2978,40847,44026,2,1464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-24','2020-11-24',342.00,NULL,NULL,1,'2021-08-12 15:45:46','2021-08-12 15:45:46',NULL),(1463,2978,40847,44026,2,1465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-24','2020-11-24',81.00,NULL,NULL,1,'2021-08-12 15:45:46','2021-08-12 15:45:46',NULL),(1464,2978,40847,44026,2,1466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-24','2020-11-24',136.00,NULL,NULL,1,'2021-08-12 15:45:46','2021-08-12 15:45:46',NULL),(1465,2978,40847,44026,2,1467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-24','2020-11-24',574.00,NULL,NULL,1,'2021-08-12 15:45:46','2021-08-12 15:45:46',NULL),(1466,2978,40847,44026,2,1468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-25','2020-11-25',528.00,NULL,NULL,1,'2021-08-12 15:45:46','2021-08-12 15:45:46',NULL),(1467,2978,40847,44026,2,1469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-25','2020-11-25',112.00,NULL,NULL,1,'2021-08-12 15:45:46','2021-08-12 15:45:46',NULL),(1468,2978,40847,44026,2,1470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-25','2020-11-25',144.00,NULL,NULL,1,'2021-08-12 15:45:46','2021-08-12 15:45:46',NULL),(1469,2978,40847,44026,2,1471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-25','2020-11-25',102.00,NULL,NULL,1,'2021-08-12 15:45:46','2021-08-12 15:45:46',NULL),(1470,2978,40847,44026,2,1472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-25','2020-11-25',142.00,NULL,NULL,1,'2021-08-12 15:45:46','2021-08-12 15:45:46',NULL),(1471,2978,40847,44026,2,1473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-25','2020-11-25',319.00,NULL,NULL,1,'2021-08-12 15:45:46','2021-08-12 15:45:46',NULL),(1472,2978,40847,44026,2,1474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-25','2020-11-25',767.00,NULL,NULL,1,'2021-08-12 15:45:46','2021-08-12 15:45:46',NULL),(1473,2978,40847,44026,2,1475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-25','2020-11-25',478.00,NULL,NULL,1,'2021-08-12 15:45:46','2021-08-12 15:45:46',NULL),(1474,2978,40847,44026,2,1476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-26','2020-11-26',144.00,NULL,NULL,1,'2021-08-12 15:45:46','2021-08-12 15:45:46',NULL),(1475,2978,40847,44026,2,1477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-26','2020-11-26',173.00,NULL,NULL,1,'2021-08-12 15:45:46','2021-08-12 15:45:46',NULL),(1476,2978,40847,44026,2,1478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-26','2020-11-26',277.00,NULL,NULL,1,'2021-08-12 15:45:46','2021-08-12 15:45:46',NULL),(1477,2978,40847,44026,2,1479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-26','2020-11-26',162.00,NULL,NULL,1,'2021-08-12 15:45:46','2021-08-12 15:45:46',NULL),(1478,2978,40847,44026,2,1480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-26','2020-11-26',329.00,NULL,NULL,1,'2021-08-12 15:45:46','2021-08-12 15:45:46',NULL);
INSERT INTO `balance_libro` VALUES (1479,2978,40847,44026,2,1481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-26','2020-11-26',218.00,NULL,NULL,1,'2021-08-12 15:45:46','2021-08-12 15:45:46',NULL),(1480,2978,40847,44026,2,1482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-26','2020-11-26',315.00,NULL,NULL,1,'2021-08-12 15:45:46','2021-08-12 15:45:46',NULL),(1481,2978,40847,44026,2,1483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-29','2020-11-29',391.00,NULL,NULL,1,'2021-08-12 15:45:46','2021-08-12 15:45:46',NULL),(1482,2978,40847,44026,2,1484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-29','2020-11-29',450.00,NULL,NULL,1,'2021-08-12 15:45:46','2021-08-12 15:45:46',NULL),(1483,2978,40847,44026,2,1485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-29','2020-11-29',493.00,NULL,NULL,1,'2021-08-12 15:45:46','2021-08-12 15:45:46',NULL),(1484,2978,40847,44026,2,1486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',170.00,NULL,NULL,1,'2021-08-12 15:45:46','2021-08-12 15:45:46',NULL),(1485,2978,40847,44026,2,1487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',259.00,NULL,NULL,1,'2021-08-12 15:45:46','2021-08-12 15:45:46',NULL),(1486,2978,40847,44027,2,1488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-01','2020-12-01',322.00,NULL,NULL,1,'2021-08-12 15:47:55','2021-08-12 15:47:55',NULL),(1487,2978,40847,44027,2,1489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-01','2020-12-01',41.00,NULL,NULL,1,'2021-08-12 15:47:55','2021-08-12 15:47:55',NULL),(1488,2978,40847,44027,2,1490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-01','2020-12-01',322.00,NULL,NULL,1,'2021-08-12 15:47:55','2021-08-12 15:47:55',NULL),(1489,2978,40847,44027,2,1491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-01','2020-12-01',97.00,NULL,NULL,1,'2021-08-12 15:47:55','2021-08-12 15:47:55',NULL),(1490,2978,40847,44027,2,1492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-01','2020-12-01',255.00,NULL,NULL,1,'2021-08-12 15:47:55','2021-08-12 15:47:55',NULL),(1491,2978,40847,44027,2,1493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-01','2020-12-01',149.00,NULL,NULL,1,'2021-08-12 15:47:56','2021-08-12 15:47:56',NULL),(1492,2978,40847,44027,2,1494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-02','2020-12-02',314.00,NULL,NULL,1,'2021-08-12 15:47:56','2021-08-12 15:47:56',NULL),(1493,2978,40847,44027,2,1495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-04','2020-12-04',151.00,NULL,NULL,1,'2021-08-12 15:47:56','2021-08-12 15:47:56',NULL),(1494,2978,40847,44027,2,1496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-04','2020-12-04',198.00,NULL,NULL,1,'2021-08-12 15:47:56','2021-08-12 15:47:56',NULL),(1495,2978,40847,44027,2,1497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-04','2020-12-04',152.00,NULL,NULL,1,'2021-08-12 15:47:56','2021-08-12 15:47:56',NULL),(1496,2978,40847,44027,2,1498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-04','2020-12-04',216.00,NULL,NULL,1,'2021-08-12 15:47:56','2021-08-12 15:47:56',NULL),(1497,2978,40847,44027,2,1499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-04','2020-12-04',111.00,NULL,NULL,1,'2021-08-12 15:47:56','2021-08-12 15:47:56',NULL),(1498,2978,40847,44027,2,1500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-04','2020-12-04',162.00,NULL,NULL,1,'2021-08-12 15:47:56','2021-08-12 15:47:56',NULL),(1499,2978,40847,44027,2,1501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-04','2020-12-04',118.00,NULL,NULL,1,'2021-08-12 15:47:56','2021-08-12 15:47:56',NULL),(1500,2978,40847,44027,2,1502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-04','2020-12-04',220.00,NULL,NULL,1,'2021-08-12 15:47:56','2021-08-12 15:47:56',NULL),(1501,2978,40847,44027,2,1503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-05','2020-12-05',422.00,NULL,NULL,1,'2021-08-12 15:47:56','2021-08-12 15:47:56',NULL),(1502,2978,40847,44027,2,1504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-05','2020-12-05',165.00,NULL,NULL,1,'2021-08-12 15:47:56','2021-08-12 15:47:56',NULL);
INSERT INTO `balance_libro` VALUES (1503,2978,40847,44027,2,1505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-05','2020-12-05',193.00,NULL,NULL,1,'2021-08-12 15:47:56','2021-08-12 15:47:56',NULL),(1504,2978,40847,44027,2,1506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-05','2020-12-05',178.00,NULL,NULL,1,'2021-08-12 15:47:56','2021-08-12 15:47:56',NULL),(1505,2978,40847,44027,2,1507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-05','2020-12-05',554.00,NULL,NULL,1,'2021-08-12 15:47:56','2021-08-12 15:47:56',NULL),(1506,2978,40847,44027,2,1508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-05','2020-12-05',242.00,NULL,NULL,1,'2021-08-12 15:47:56','2021-08-12 15:47:56',NULL),(1507,2978,40847,44027,2,1509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-05','2020-12-05',244.00,NULL,NULL,1,'2021-08-12 15:47:56','2021-08-12 15:47:56',NULL),(1508,2978,40847,44027,2,1510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-05','2020-12-05',170.00,NULL,NULL,1,'2021-08-12 15:47:56','2021-08-12 15:47:56',NULL),(1509,2978,40847,44027,2,1511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-05','2020-12-05',352.00,NULL,NULL,1,'2021-08-12 15:47:56','2021-08-12 15:47:56',NULL),(1510,2978,40847,44027,2,1512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-07','2020-12-07',142.00,NULL,NULL,1,'2021-08-12 15:47:56','2021-08-12 15:47:56',NULL),(1511,2978,40847,44027,2,1513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-07','2020-12-07',515.00,NULL,NULL,1,'2021-08-12 15:47:56','2021-08-12 15:47:56',NULL),(1512,2978,40847,44027,2,1514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-07','2020-12-07',112.00,NULL,NULL,1,'2021-08-12 15:47:56','2021-08-12 15:47:56',NULL),(1513,2978,40847,44027,2,1515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-07','2020-12-07',733.00,NULL,NULL,1,'2021-08-12 15:47:56','2021-08-12 15:47:56',NULL),(1514,2978,40847,44027,2,1516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-07','2020-12-07',200.00,NULL,NULL,1,'2021-08-12 15:47:56','2021-08-12 15:47:56',NULL),(1515,2978,40847,44027,2,1517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-07','2020-12-07',246.00,NULL,NULL,1,'2021-08-12 15:47:56','2021-08-12 15:47:56',NULL),(1516,2978,40847,44027,2,1518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-07','2020-12-07',85.00,NULL,NULL,1,'2021-08-12 15:47:56','2021-08-12 15:47:56',NULL),(1517,2978,40847,44027,2,1519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-08','2020-12-08',146.00,NULL,NULL,1,'2021-08-12 15:47:56','2021-08-12 15:47:56',NULL),(1518,2978,40847,44027,2,1520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-08','2020-12-08',277.00,NULL,NULL,1,'2021-08-12 15:47:56','2021-08-12 15:47:56',NULL),(1519,2978,40847,44027,2,1521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-08','2020-12-08',190.00,NULL,NULL,1,'2021-08-12 15:47:56','2021-08-12 15:47:56',NULL),(1520,2978,40847,44027,2,1522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-08','2020-12-08',162.00,NULL,NULL,1,'2021-08-12 15:47:57','2021-08-12 15:47:57',NULL),(1521,2978,40847,44027,2,1523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-08','2020-12-08',158.00,NULL,NULL,1,'2021-08-12 15:47:57','2021-08-12 15:47:57',NULL),(1522,2978,40847,44027,2,1524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-08','2020-12-08',1608.00,NULL,NULL,1,'2021-08-12 15:47:57','2021-08-12 15:47:57',NULL),(1523,2978,40847,44027,2,1525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',258.00,NULL,NULL,1,'2021-08-12 15:47:57','2021-08-12 15:47:57',NULL),(1524,2978,40847,44027,2,1526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',142.00,NULL,NULL,1,'2021-08-12 15:47:57','2021-08-12 15:47:57',NULL),(1525,2978,40847,44027,2,1527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-10','2020-12-10',769.00,NULL,NULL,1,'2021-08-12 15:47:57','2021-08-12 15:47:57',NULL),(1526,2978,40847,44027,2,1528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-11','2020-12-11',170.00,NULL,NULL,1,'2021-08-12 15:47:57','2021-08-12 15:47:57',NULL);
INSERT INTO `balance_libro` VALUES (1527,2978,40847,44027,2,1529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-11','2020-12-11',279.00,NULL,NULL,1,'2021-08-12 15:47:57','2021-08-12 15:47:57',NULL),(1528,2978,40847,44027,2,1530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-11','2020-12-11',171.00,NULL,NULL,1,'2021-08-12 15:47:57','2021-08-12 15:47:57',NULL),(1529,2978,40847,44027,2,1531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-11','2020-12-11',503.00,NULL,NULL,1,'2021-08-12 15:47:57','2021-08-12 15:47:57',NULL),(1530,2978,40847,44027,2,1532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-13','2020-12-13',384.00,NULL,NULL,1,'2021-08-12 15:47:57','2021-08-12 15:47:57',NULL),(1531,2978,40847,44027,2,1533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-13','2020-12-13',464.00,NULL,NULL,1,'2021-08-12 15:47:57','2021-08-12 15:47:57',NULL),(1532,2978,40847,44027,2,1534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-14','2020-12-14',295.00,NULL,NULL,1,'2021-08-12 15:47:57','2021-08-12 15:47:57',NULL),(1533,2978,40847,44027,2,1535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-14','2020-12-14',162.00,NULL,NULL,1,'2021-08-12 15:47:57','2021-08-12 15:47:57',NULL),(1534,2978,40847,44027,2,1536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-14','2020-12-14',109.00,NULL,NULL,1,'2021-08-12 15:47:57','2021-08-12 15:47:57',NULL),(1535,2978,40847,44027,2,1537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-14','2020-12-14',371.00,NULL,NULL,1,'2021-08-12 15:47:57','2021-08-12 15:47:57',NULL),(1536,2978,40847,44027,2,1538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-14','2020-12-14',132.00,NULL,NULL,1,'2021-08-12 15:47:57','2021-08-12 15:47:57',NULL),(1537,2978,40847,44027,2,1539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-14','2020-12-14',694.00,NULL,NULL,1,'2021-08-12 15:47:57','2021-08-12 15:47:57',NULL),(1538,2978,40847,44027,2,1540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-15','2020-12-15',189.00,NULL,NULL,1,'2021-08-12 15:47:57','2021-08-12 15:47:57',NULL),(1539,2978,40847,44027,2,1541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-15','2020-12-15',684.00,NULL,NULL,1,'2021-08-12 15:47:57','2021-08-12 15:47:57',NULL),(1548,2978,40721,4579,2,1550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-04','2020-08-04',1238.00,NULL,NULL,1,'2021-08-12 16:14:33','2021-08-12 16:14:33',NULL),(1549,2978,40721,4579,2,1551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-04','2020-08-04',5147.50,NULL,NULL,1,'2021-08-12 16:14:33','2021-08-12 16:14:33',NULL),(1550,2978,40721,4579,2,1552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-18','2020-08-18',1500.00,NULL,NULL,1,'2021-08-12 16:14:33','2021-08-12 16:14:33',NULL),(1551,2978,40721,4579,2,1553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-18','2020-08-18',1826.00,NULL,NULL,1,'2021-08-12 16:14:33','2021-08-12 16:14:33',NULL),(1552,2978,40721,4579,2,1554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-18','2020-08-18',1670.40,NULL,NULL,1,'2021-08-12 16:14:33','2021-08-12 16:14:33',NULL),(1553,2978,40721,4579,2,1555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-18','2020-08-18',1360.00,NULL,NULL,1,'2021-08-12 16:14:33','2021-08-12 16:14:33',NULL),(1554,2978,40721,4579,2,1556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-18','2020-08-18',1224.00,NULL,NULL,1,'2021-08-12 16:14:33','2021-08-12 16:14:33',NULL),(1555,2978,40721,4579,2,1557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-18','2020-08-18',1730.00,NULL,NULL,1,'2021-08-12 16:14:33','2021-08-12 16:14:33',NULL),(1556,2978,40721,4579,2,1558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-18','2020-08-18',2998.99,NULL,NULL,1,'2021-08-12 16:14:33','2021-08-12 16:14:33',NULL),(1557,2978,40721,4579,2,1559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-18','2020-08-18',1756.98,NULL,NULL,1,'2021-08-12 16:14:33','2021-08-12 16:14:33',NULL),(1558,2978,40721,4579,2,1560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-18','2020-08-18',2720.00,NULL,NULL,1,'2021-08-12 16:14:33','2021-08-12 16:14:33',NULL);
INSERT INTO `balance_libro` VALUES (1559,2978,40721,4579,2,1561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-18','2020-08-18',1506.00,NULL,NULL,1,'2021-08-12 16:14:33','2021-08-12 16:14:33',NULL),(1560,2978,40721,4579,2,1562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-18','2020-08-18',1107.00,NULL,NULL,1,'2021-08-12 16:14:33','2021-08-12 16:14:33',NULL),(1561,2978,40721,4579,2,1563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-18','2020-08-18',3170.00,NULL,NULL,1,'2021-08-12 16:14:33','2021-08-12 16:14:33',NULL),(1562,2978,40721,4579,2,1564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-18','2020-08-18',1170.00,NULL,NULL,1,'2021-08-12 16:14:33','2021-08-12 16:14:33',NULL),(1563,2978,40721,4579,2,1565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-18','2020-08-18',2318.40,NULL,NULL,1,'2021-08-12 16:14:33','2021-08-12 16:14:33',NULL),(1564,2978,40721,4579,2,1566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-18','2020-08-18',1360.00,NULL,NULL,1,'2021-08-12 16:14:33','2021-08-12 16:14:33',NULL),(1565,2978,40721,4579,2,1567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-18','2020-08-18',450.00,NULL,NULL,1,'2021-08-12 16:14:33','2021-08-12 16:14:33',NULL),(1566,2978,40721,4579,2,1568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-18','2020-08-18',1584.20,NULL,NULL,1,'2021-08-12 16:14:33','2021-08-12 16:14:33',NULL),(1567,2978,40721,4579,2,1569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-18','2020-08-18',2326.00,NULL,NULL,1,'2021-08-12 16:14:33','2021-08-12 16:14:33',NULL),(1568,2978,40721,4579,2,1570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-19','2020-08-19',2500.00,NULL,NULL,1,'2021-08-12 16:14:33','2021-08-12 16:14:33',NULL),(1569,2978,40721,4579,2,1571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-19','2020-08-19',783.00,NULL,NULL,1,'2021-08-12 16:14:33','2021-08-12 16:14:33',NULL),(1570,2978,40721,4579,2,1572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-19','2020-08-19',2772.00,NULL,NULL,1,'2021-08-12 16:14:33','2021-08-12 16:14:33',NULL),(1571,2978,40721,4579,2,1573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-19','2020-08-19',2908.00,NULL,NULL,1,'2021-08-12 16:14:34','2021-08-12 16:14:34',NULL),(1572,2978,40721,4579,2,1574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-19','2020-08-19',2845.98,NULL,NULL,1,'2021-08-12 16:14:34','2021-08-12 16:14:34',NULL),(1573,2978,40721,4579,2,1575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-20','2020-08-20',1246.00,NULL,NULL,1,'2021-08-12 16:14:34','2021-08-12 16:14:34',NULL),(1574,2978,40721,4579,2,1576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-20','2020-08-20',1656.00,NULL,NULL,1,'2021-08-12 16:14:34','2021-08-12 16:14:34',NULL),(1575,2978,40721,4579,2,1577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-20','2020-08-20',2808.00,NULL,NULL,1,'2021-08-12 16:14:34','2021-08-12 16:14:34',NULL),(1576,2978,40721,4579,2,1578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-24','2020-08-24',812.00,NULL,NULL,1,'2021-08-12 16:14:34','2021-08-12 16:14:34',NULL),(1577,2978,40721,4579,2,1579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-24','2020-08-24',3000.91,NULL,NULL,1,'2021-08-12 16:14:34','2021-08-12 16:14:34',NULL),(1578,2978,40721,4579,2,1580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-24','2020-08-24',3210.00,NULL,NULL,1,'2021-08-12 16:14:34','2021-08-12 16:14:34',NULL),(1579,2978,40721,4579,2,1581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-24','2020-08-24',4562.00,NULL,NULL,1,'2021-08-12 16:14:34','2021-08-12 16:14:34',NULL),(1580,2978,40721,4579,2,1582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-24','2020-08-24',612.00,NULL,NULL,1,'2021-08-12 16:14:34','2021-08-12 16:14:34',NULL),(1581,2978,40721,4579,2,1583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-24','2020-08-24',1818.00,NULL,NULL,1,'2021-08-12 16:14:34','2021-08-12 16:14:34',NULL),(1582,2978,40721,4579,2,1584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-24','2020-08-24',7483.00,NULL,NULL,1,'2021-08-12 16:14:34','2021-08-12 16:14:34',NULL);
INSERT INTO `balance_libro` VALUES (1583,2978,40721,4579,2,1585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-24','2020-08-24',713.00,NULL,NULL,1,'2021-08-12 16:14:34','2021-08-12 16:14:34',NULL),(1584,2978,40721,4579,2,1586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-24','2020-08-24',713.00,NULL,NULL,1,'2021-08-12 16:14:34','2021-08-12 16:14:34',NULL),(1585,2978,40721,4579,2,1587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-24','2020-08-24',2562.00,NULL,NULL,1,'2021-08-12 16:14:34','2021-08-12 16:14:34',NULL),(1586,2978,40721,4579,2,1588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-24','2020-08-24',1238.00,NULL,NULL,1,'2021-08-12 16:14:34','2021-08-12 16:14:34',NULL),(1587,2978,40721,4579,2,1589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-24','2020-08-24',450.00,NULL,NULL,1,'2021-08-12 16:14:34','2021-08-12 16:14:34',NULL),(1588,2978,40721,4579,2,1590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-24','2020-08-24',1843.00,NULL,NULL,1,'2021-08-12 16:14:34','2021-08-12 16:14:34',NULL),(1589,2978,40721,4579,2,1591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-24','2020-08-24',1726.00,NULL,NULL,1,'2021-08-12 16:14:34','2021-08-12 16:14:34',NULL),(1590,2978,40721,4579,2,1592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-24','2020-08-24',3726.00,NULL,NULL,1,'2021-08-12 16:14:34','2021-08-12 16:14:34',NULL),(1591,2978,40721,4579,2,1593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-24','2020-08-24',2040.00,NULL,NULL,1,'2021-08-12 16:14:34','2021-08-12 16:14:34',NULL),(1592,2978,40721,4579,2,1594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-25','2020-08-25',2483.10,NULL,NULL,1,'2021-08-12 16:14:34','2021-08-12 16:14:34',NULL),(1593,2978,40721,4579,2,1595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-25','2020-08-25',2073.00,NULL,NULL,1,'2021-08-12 16:14:34','2021-08-12 16:14:34',NULL),(1594,2978,40721,4579,2,1596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-25','2020-08-25',1580.00,NULL,NULL,1,'2021-08-12 16:14:34','2021-08-12 16:14:34',NULL),(1595,2978,40721,4579,2,1597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-25','2020-08-25',2476.00,NULL,NULL,1,'2021-08-12 16:14:34','2021-08-12 16:14:34',NULL),(1596,2978,40721,4579,2,1598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-26','2020-08-26',1566.00,NULL,NULL,1,'2021-08-12 16:14:34','2021-08-12 16:14:34',NULL),(1597,2978,40721,4579,2,1599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-26','2020-08-26',2778.20,NULL,NULL,1,'2021-08-12 16:14:34','2021-08-12 16:14:34',NULL),(1598,2978,40721,4579,2,1600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-26','2020-08-26',960.00,NULL,NULL,1,'2021-08-12 16:14:34','2021-08-12 16:14:34',NULL),(1599,2978,40721,4579,2,1601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-26','2020-08-26',1465.02,NULL,NULL,1,'2021-08-12 16:14:34','2021-08-12 16:14:34',NULL),(1600,2978,40721,4579,2,1602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-27','2020-08-27',680.00,NULL,NULL,1,'2021-08-12 16:14:34','2021-08-12 16:14:34',NULL),(1601,2978,40721,4579,2,1603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-27','2020-08-27',254.00,NULL,NULL,1,'2021-08-12 16:14:34','2021-08-12 16:14:34',NULL),(1602,2978,40721,4579,2,1604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-27','2020-08-27',1360.00,NULL,NULL,1,'2021-08-12 16:14:34','2021-08-12 16:14:34',NULL),(1603,2978,40721,4579,2,1605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-28','2020-08-28',404.99,NULL,NULL,1,'2021-08-12 16:14:34','2021-08-12 16:14:34',NULL),(1604,2978,40721,4579,2,1606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-28','2020-08-28',612.00,NULL,NULL,1,'2021-08-12 16:14:35','2021-08-12 16:14:35',NULL),(1605,2978,40721,4579,2,1607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-30','2020-08-30',1080.00,NULL,NULL,1,'2021-08-12 16:14:35','2021-08-12 16:14:35',NULL),(1606,2978,40721,4579,2,1608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-30','2020-08-30',7150.00,NULL,NULL,1,'2021-08-12 16:14:35','2021-08-12 16:14:35',NULL);
INSERT INTO `balance_libro` VALUES (1653,2978,40721,4580,2,1655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-16','2020-09-16',1827.83,NULL,NULL,1,'2021-08-12 16:26:02','2021-08-12 16:26:02',NULL),(1654,2978,40721,4580,2,1656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-16','2020-09-16',2720.00,NULL,NULL,1,'2021-08-12 16:26:02','2021-08-12 16:26:02',NULL),(1655,2978,40721,4580,2,1657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-16','2020-09-16',2704.30,NULL,NULL,1,'2021-08-12 16:26:02','2021-08-12 16:26:02',NULL),(1656,2978,40721,4580,2,1658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-16','2020-09-16',612.00,NULL,NULL,1,'2021-08-12 16:26:02','2021-08-12 16:26:02',NULL),(1657,2978,40721,4580,2,1659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-16','2020-09-16',1360.00,NULL,NULL,1,'2021-08-12 16:26:02','2021-08-12 16:26:02',NULL),(1658,2978,40721,4580,2,1660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-16','2020-09-16',1358.30,NULL,NULL,1,'2021-08-12 16:26:02','2021-08-12 16:26:02',NULL),(1659,2978,40721,4580,2,1661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-16','2020-09-16',2153.00,NULL,NULL,1,'2021-08-12 16:26:02','2021-08-12 16:26:02',NULL),(1660,2978,40721,4580,2,1662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-16','2020-09-16',1800.00,NULL,NULL,1,'2021-08-12 16:26:02','2021-08-12 16:26:02',NULL),(1661,2978,40721,4580,2,1663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-16','2020-09-16',1597.50,NULL,NULL,1,'2021-08-12 16:26:02','2021-08-12 16:26:02',NULL),(1662,2978,40721,4580,2,1664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-16','2020-09-16',680.00,NULL,NULL,1,'2021-08-12 16:26:02','2021-08-12 16:26:02',NULL),(1663,2978,40721,4580,2,1665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-16','2020-09-16',520.70,NULL,NULL,1,'2021-08-12 16:26:02','2021-08-12 16:26:02',NULL),(1664,2978,40721,4580,2,1666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-16','2020-09-16',1906.03,NULL,NULL,1,'2021-08-12 16:26:02','2021-08-12 16:26:02',NULL),(1665,2978,40721,4580,2,1667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-16','2020-09-16',3156.00,NULL,NULL,1,'2021-08-12 16:26:02','2021-08-12 16:26:02',NULL),(1666,2978,40721,4580,2,1668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-16','2020-09-16',4328.00,NULL,NULL,1,'2021-08-12 16:26:02','2021-08-12 16:26:02',NULL),(1667,2978,40721,4580,2,1669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-16','2020-09-16',678.30,NULL,NULL,1,'2021-08-12 16:26:02','2021-08-12 16:26:02',NULL),(1668,2978,40721,4580,2,1670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-16','2020-09-16',1883.29,NULL,NULL,1,'2021-08-12 16:26:02','2021-08-12 16:26:02',NULL),(1669,2978,40721,4580,2,1671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-16','2020-09-16',1283.40,NULL,NULL,1,'2021-08-12 16:26:02','2021-08-12 16:26:02',NULL),(1670,2978,40721,4580,2,1672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-16','2020-09-16',1210.50,NULL,NULL,1,'2021-08-12 16:26:02','2021-08-12 16:26:02',NULL),(1671,2978,40721,4580,2,1673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-16','2020-09-16',680.00,NULL,NULL,1,'2021-08-12 16:26:02','2021-08-12 16:26:02',NULL),(1672,2978,40721,4580,2,1674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-16','2020-09-16',694.99,NULL,NULL,1,'2021-08-12 16:26:02','2021-08-12 16:26:02',NULL),(1673,2978,40721,4580,2,1675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-16','2020-09-16',702.00,NULL,NULL,1,'2021-08-12 16:26:02','2021-08-12 16:26:02',NULL),(1674,2978,40721,4580,2,1676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-16','2020-09-16',1809.00,NULL,NULL,1,'2021-08-12 16:26:03','2021-08-12 16:26:03',NULL),(1675,2978,40721,4580,2,1677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-17','2020-09-17',1470.00,NULL,NULL,1,'2021-08-12 16:26:03','2021-08-12 16:26:03',NULL),(1676,2978,40721,4580,2,1678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-18','2020-09-18',1874.97,NULL,NULL,1,'2021-08-12 16:26:03','2021-08-12 16:26:03',NULL);
INSERT INTO `balance_libro` VALUES (1677,2978,40721,4580,2,1679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-18','2020-09-18',1360.00,NULL,NULL,1,'2021-08-12 16:26:03','2021-08-12 16:26:03',NULL),(1678,2978,40721,4580,2,1680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-18','2020-09-18',702.00,NULL,NULL,1,'2021-08-12 16:26:03','2021-08-12 16:26:03',NULL),(1679,2978,40721,4580,2,1681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-18','2020-09-18',641.70,NULL,NULL,1,'2021-08-12 16:26:03','2021-08-12 16:26:03',NULL),(1680,2978,40721,4580,2,1682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-19','2020-09-19',2470.00,NULL,NULL,1,'2021-08-12 16:26:03','2021-08-12 16:26:03',NULL),(1681,2978,40721,4580,2,1683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-19','2020-09-19',1224.00,NULL,NULL,1,'2021-08-12 16:26:03','2021-08-12 16:26:03',NULL),(1682,2978,40721,4580,2,1684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-19','2020-09-19',1360.00,NULL,NULL,1,'2021-08-12 16:26:03','2021-08-12 16:26:03',NULL),(1683,2978,40721,4580,2,1685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-19','2020-09-19',720.00,NULL,NULL,1,'2021-08-12 16:26:03','2021-08-12 16:26:03',NULL),(1684,2978,40721,4580,2,1686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1925.10,NULL,NULL,1,'2021-08-12 16:26:03','2021-08-12 16:26:03',NULL),(1685,2978,40721,4580,2,1687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',610.00,NULL,NULL,1,'2021-08-12 16:26:03','2021-08-12 16:26:03',NULL),(1686,2978,40721,4580,2,1688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',3110.00,NULL,NULL,1,'2021-08-12 16:26:03','2021-08-12 16:26:03',NULL),(1687,2978,40721,4580,2,1689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',380.00,NULL,NULL,1,'2021-08-12 16:26:03','2021-08-12 16:26:03',NULL),(1688,2978,40721,4580,2,1690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',200.00,NULL,NULL,1,'2021-08-12 16:26:03','2021-08-12 16:26:03',NULL),(1689,2978,40721,4580,2,1691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1560.00,NULL,NULL,1,'2021-08-12 16:26:03','2021-08-12 16:26:03',NULL),(1690,2978,40721,4580,2,1692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',2160.90,NULL,NULL,1,'2021-08-12 16:26:03','2021-08-12 16:26:03',NULL),(1691,2978,40721,4580,2,1693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1110.00,NULL,NULL,1,'2021-08-12 16:26:03','2021-08-12 16:26:03',NULL),(1692,2978,40721,4580,2,1694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1810.00,NULL,NULL,1,'2021-08-12 16:26:03','2021-08-12 16:26:03',NULL),(1693,2978,40721,4580,2,1695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',2609.00,NULL,NULL,1,'2021-08-12 16:26:03','2021-08-12 16:26:03',NULL),(1694,2978,40721,4580,2,1696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1749.50,NULL,NULL,1,'2021-08-12 16:26:03','2021-08-12 16:26:03',NULL),(1695,2978,40721,4580,2,1697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',864.00,NULL,NULL,1,'2021-08-12 16:26:03','2021-08-12 16:26:03',NULL),(1696,2978,40721,4580,2,1698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1530.00,NULL,NULL,1,'2021-08-12 16:26:03','2021-08-12 16:26:03',NULL),(1697,2978,40721,4580,2,1699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',4845.00,NULL,NULL,1,'2021-08-12 16:26:03','2021-08-12 16:26:03',NULL),(1698,2978,40721,4580,2,1700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',2430.00,NULL,NULL,1,'2021-08-12 16:26:03','2021-08-12 16:26:03',NULL),(1699,2978,40721,4580,2,1701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1287.00,NULL,NULL,1,'2021-08-12 16:26:03','2021-08-12 16:26:03',NULL),(1700,2978,40721,4580,2,1702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1719.00,NULL,NULL,1,'2021-08-12 16:26:04','2021-08-12 16:26:04',NULL);
INSERT INTO `balance_libro` VALUES (1701,2978,40721,4580,2,1703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1134.00,NULL,NULL,1,'2021-08-12 16:26:04','2021-08-12 16:26:04',NULL),(1702,2978,40721,4580,2,1704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',2880.00,NULL,NULL,1,'2021-08-12 16:26:04','2021-08-12 16:26:04',NULL),(1703,2978,40721,4580,2,1705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',2230.47,NULL,NULL,1,'2021-08-12 16:26:04','2021-08-12 16:26:04',NULL),(1704,2978,40721,4580,2,1706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1300.00,NULL,NULL,1,'2021-08-12 16:26:04','2021-08-12 16:26:04',NULL),(1705,2978,40721,4580,2,1707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1430.00,NULL,NULL,1,'2021-08-12 16:26:04','2021-08-12 16:26:04',NULL),(1706,2978,40721,4580,2,1708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1962.00,NULL,NULL,1,'2021-08-12 16:26:04','2021-08-12 16:26:04',NULL),(1707,2978,40721,4580,2,1709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',3445.00,NULL,NULL,1,'2021-08-12 16:26:04','2021-08-12 16:26:04',NULL),(1708,2978,40721,4580,2,1710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1917.00,NULL,NULL,1,'2021-08-12 16:26:04','2021-08-12 16:26:04',NULL),(1709,2978,40721,4580,2,1711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',450.00,NULL,NULL,1,'2021-08-12 16:26:04','2021-08-12 16:26:04',NULL),(1710,2978,40721,4580,2,1712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',380.00,NULL,NULL,1,'2021-08-12 16:26:04','2021-08-12 16:26:04',NULL),(1711,2978,40721,4580,2,1713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1880.06,NULL,NULL,1,'2021-08-12 16:26:04','2021-08-12 16:26:04',NULL),(1712,2978,40721,4580,2,1714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',380.00,NULL,NULL,1,'2021-08-12 16:26:04','2021-08-12 16:26:04',NULL),(1713,2978,40721,4580,2,1715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',2394.00,NULL,NULL,1,'2021-08-12 16:26:04','2021-08-12 16:26:04',NULL),(1714,2978,40721,4580,2,1716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1330.00,NULL,NULL,1,'2021-08-12 16:26:04','2021-08-12 16:26:04',NULL),(1715,2978,40721,4580,2,1717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1700.00,NULL,NULL,1,'2021-08-12 16:26:04','2021-08-12 16:26:04',NULL),(1716,2978,40721,4582,2,1718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-01','2020-11-01',1150.00,NULL,NULL,1,'2021-08-12 16:31:19','2021-08-12 16:31:19',NULL),(1717,2978,40721,4582,2,1719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-01','2020-11-01',1150.00,NULL,NULL,1,'2021-08-12 16:31:19','2021-08-12 16:31:19',NULL),(1718,2978,40721,4582,2,1720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-01','2020-11-01',1200.00,NULL,NULL,1,'2021-08-12 16:31:19','2021-08-12 16:31:19',NULL),(1719,2978,40721,4582,2,1721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-01','2020-11-01',1150.00,NULL,NULL,1,'2021-08-12 16:31:19','2021-08-12 16:31:19',NULL),(1720,2978,40721,4582,2,1722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-01','2020-11-01',1665.00,NULL,NULL,1,'2021-08-12 16:31:19','2021-08-12 16:31:19',NULL),(1721,2978,40721,4582,2,1723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-01','2020-11-01',3120.00,NULL,NULL,1,'2021-08-12 16:31:19','2021-08-12 16:31:19',NULL),(1722,2978,40721,4582,2,1724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-01','2020-11-01',1150.00,NULL,NULL,1,'2021-08-12 16:31:19','2021-08-12 16:31:19',NULL),(1723,2978,40721,4582,2,1725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-01','2020-11-01',2400.00,NULL,NULL,1,'2021-08-12 16:31:19','2021-08-12 16:31:19',NULL),(1724,2978,40721,4582,2,1726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-01','2020-11-01',1080.00,NULL,NULL,1,'2021-08-12 16:31:19','2021-08-12 16:31:19',NULL);
INSERT INTO `balance_libro` VALUES (1725,2978,40721,4582,2,1727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-01','2020-11-01',4250.00,NULL,NULL,1,'2021-08-12 16:31:19','2021-08-12 16:31:19',NULL),(1726,2978,40721,4582,2,1728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-01','2020-11-01',2781.00,NULL,NULL,1,'2021-08-12 16:31:19','2021-08-12 16:31:19',NULL),(1727,2978,40721,4582,2,1729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-01','2020-11-01',2300.00,NULL,NULL,1,'2021-08-12 16:31:19','2021-08-12 16:31:19',NULL),(1728,2978,40721,4582,2,1730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-01','2020-11-01',1150.00,NULL,NULL,1,'2021-08-12 16:31:19','2021-08-12 16:31:19',NULL),(1729,2978,40721,4582,2,1731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-01','2020-11-01',2025.00,NULL,NULL,1,'2021-08-12 16:31:19','2021-08-12 16:31:19',NULL),(1730,2978,40721,4582,2,1732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-01','2020-11-01',1150.00,NULL,NULL,1,'2021-08-12 16:31:19','2021-08-12 16:31:19',NULL),(1731,2978,40721,4582,2,1733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-13','2020-11-13',2530.00,NULL,NULL,1,'2021-08-12 16:31:19','2021-08-12 16:31:19',NULL),(1732,2978,40721,4582,2,1734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-17','2020-11-17',1200.00,NULL,NULL,1,'2021-08-12 16:31:19','2021-08-12 16:31:19',NULL),(1733,2978,40721,4582,2,1735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-17','2020-11-17',1150.00,NULL,NULL,1,'2021-08-12 16:31:20','2021-08-12 16:31:20',NULL),(1734,2978,40721,4582,2,1736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-17','2020-11-17',940.00,NULL,NULL,1,'2021-08-12 16:31:20','2021-08-12 16:31:20',NULL),(1735,2978,40721,4582,2,1737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-17','2020-11-17',2736.00,NULL,NULL,1,'2021-08-12 16:31:20','2021-08-12 16:31:20',NULL),(1736,2978,40721,4582,2,1738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-17','2020-11-17',1150.00,NULL,NULL,1,'2021-08-12 16:31:20','2021-08-12 16:31:20',NULL),(1737,2978,40721,4582,2,1739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-17','2020-11-17',2820.00,NULL,NULL,1,'2021-08-12 16:31:20','2021-08-12 16:31:20',NULL),(1738,2978,40721,4582,2,1740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-17','2020-11-17',1629.00,NULL,NULL,1,'2021-08-12 16:31:20','2021-08-12 16:31:20',NULL),(1739,2978,40721,4582,2,1741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-17','2020-11-17',1830.00,NULL,NULL,1,'2021-08-12 16:31:20','2021-08-12 16:31:20',NULL),(1740,2978,40721,4582,2,1742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-17','2020-11-17',1035.00,NULL,NULL,1,'2021-08-12 16:31:20','2021-08-12 16:31:20',NULL),(1741,2978,40721,4582,2,1743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-17','2020-11-17',940.00,NULL,NULL,1,'2021-08-12 16:31:20','2021-08-12 16:31:20',NULL),(1742,2978,40721,4582,2,1744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-17','2020-11-17',1880.00,NULL,NULL,1,'2021-08-12 16:31:20','2021-08-12 16:31:20',NULL),(1743,2978,40721,4582,2,1745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-17','2020-11-17',1521.00,NULL,NULL,1,'2021-08-12 16:31:20','2021-08-12 16:31:20',NULL),(1744,2978,40721,4582,2,1746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-17','2020-11-17',4935.00,NULL,NULL,1,'2021-08-12 16:31:20','2021-08-12 16:31:20',NULL),(1745,2978,40721,4582,2,1747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-17','2020-11-17',820.00,NULL,NULL,1,'2021-08-12 16:31:20','2021-08-12 16:31:20',NULL),(1746,2978,40721,4582,2,1748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-17','2020-11-17',1880.00,NULL,NULL,1,'2021-08-12 16:31:20','2021-08-12 16:31:20',NULL),(1747,2978,40721,4582,2,1749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-17','2020-11-17',1120.00,NULL,NULL,1,'2021-08-12 16:31:20','2021-08-12 16:31:20',NULL),(1748,2978,40721,4582,2,1750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-17','2020-11-17',940.00,NULL,NULL,1,'2021-08-12 16:31:20','2021-08-12 16:31:20',NULL);
INSERT INTO `balance_libro` VALUES (1749,2978,40721,4582,2,1751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-17','2020-11-17',2080.00,NULL,NULL,1,'2021-08-12 16:31:20','2021-08-12 16:31:20',NULL),(1750,2978,40721,4582,2,1752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-17','2020-11-17',1720.00,NULL,NULL,1,'2021-08-12 16:31:20','2021-08-12 16:31:20',NULL),(1751,2978,40721,4582,2,1753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-17','2020-11-17',1800.00,NULL,NULL,1,'2021-08-12 16:31:20','2021-08-12 16:31:20',NULL),(1752,2978,40721,4582,2,1754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-17','2020-11-17',2394.00,NULL,NULL,1,'2021-08-12 16:31:20','2021-08-12 16:31:20',NULL),(1753,2978,40721,4582,2,1755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-17','2020-11-17',1880.00,NULL,NULL,1,'2021-08-12 16:31:20','2021-08-12 16:31:20',NULL),(1754,2978,40721,4582,2,1756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-17','2020-11-17',820.00,NULL,NULL,1,'2021-08-12 16:31:20','2021-08-12 16:31:20',NULL),(1755,2978,40721,4582,2,1757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-17','2020-11-17',900.00,NULL,NULL,1,'2021-08-12 16:31:20','2021-08-12 16:31:20',NULL),(1756,2978,40721,4582,2,1758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-19','2020-11-19',5539.50,NULL,NULL,1,'2021-08-12 16:31:20','2021-08-12 16:31:20',NULL),(1757,2978,40721,4582,2,1759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',1560.00,NULL,NULL,1,'2021-08-12 16:31:20','2021-08-12 16:31:20',NULL),(1758,2978,40721,4582,2,1760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',738.00,NULL,NULL,1,'2021-08-12 16:31:20','2021-08-12 16:31:20',NULL),(1759,2978,40721,4582,2,1761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-22','2020-11-22',1602.00,NULL,NULL,1,'2021-08-12 16:31:20','2021-08-12 16:31:20',NULL),(1760,2978,40721,4582,2,1762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-22','2020-11-22',800.01,NULL,NULL,1,'2021-08-12 16:31:20','2021-08-12 16:31:20',NULL),(1761,2978,40721,4582,2,1763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-22','2020-11-22',2000.00,NULL,NULL,1,'2021-08-12 16:31:20','2021-08-12 16:31:20',NULL),(1762,2978,40721,4582,2,1764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-22','2020-11-22',1560.00,NULL,NULL,1,'2021-08-12 16:31:20','2021-08-12 16:31:20',NULL),(1763,2978,40721,4582,2,1765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-23','2020-11-23',1683.00,NULL,NULL,1,'2021-08-12 16:31:20','2021-08-12 16:31:20',NULL),(1764,2978,40721,4582,2,1766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-23','2020-11-23',1660.00,NULL,NULL,1,'2021-08-12 16:31:20','2021-08-12 16:31:20',NULL),(1765,2978,40721,4582,2,1767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-24','2020-11-24',3900.00,NULL,NULL,1,'2021-08-12 16:31:20','2021-08-12 16:31:20',NULL),(1766,2978,40721,4582,2,1768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-26','2020-11-26',1300.00,NULL,NULL,1,'2021-08-12 16:31:21','2021-08-12 16:31:21',NULL),(1767,2978,40721,4582,2,1769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-28','2020-11-28',1665.00,NULL,NULL,1,'2021-08-12 16:31:21','2021-08-12 16:31:21',NULL),(1768,2978,40721,4582,2,1770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-28','2020-11-28',2660.00,NULL,NULL,1,'2021-08-12 16:31:21','2021-08-12 16:31:21',NULL),(1769,2978,40721,4582,2,1771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-28','2020-11-28',4450.16,NULL,NULL,1,'2021-08-12 16:31:21','2021-08-12 16:31:21',NULL),(1770,2978,40721,4582,2,1772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-28','2020-11-28',3995.00,NULL,NULL,1,'2021-08-12 16:31:21','2021-08-12 16:31:21',NULL),(1771,2978,40721,4582,2,1773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',3333.50,NULL,NULL,1,'2021-08-12 16:31:21','2021-08-12 16:31:21',NULL),(1772,2978,40721,4582,2,1774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',1470.00,NULL,NULL,1,'2021-08-12 16:31:21','2021-08-12 16:31:21',NULL);
INSERT INTO `balance_libro` VALUES (1773,2978,40721,4577,2,1775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-01','2020-06-01',2510.00,NULL,NULL,1,'2021-08-12 16:43:48','2021-08-12 16:43:48',NULL),(1774,2978,40721,4577,2,1776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-01','2020-06-01',2753.00,NULL,NULL,1,'2021-08-12 16:43:48','2021-08-12 16:43:48',NULL),(1775,2978,40721,4577,2,1777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-01','2020-06-01',1080.00,NULL,NULL,1,'2021-08-12 16:43:48','2021-08-12 16:43:48',NULL),(1776,2978,40721,4577,2,1778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-08','2020-06-08',4251.99,NULL,NULL,1,'2021-08-12 16:43:48','2021-08-12 16:43:48',NULL),(1777,2978,40721,4577,2,1779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-08','2020-06-08',650.00,NULL,NULL,1,'2021-08-12 16:43:48','2021-08-12 16:43:48',NULL),(1778,2978,40721,4577,2,1780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-08','2020-06-08',830.00,NULL,NULL,1,'2021-08-12 16:43:48','2021-08-12 16:43:48',NULL),(1779,2978,40721,4577,2,1781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-08','2020-06-08',2077.00,NULL,NULL,1,'2021-08-12 16:43:48','2021-08-12 16:43:48',NULL),(1780,2978,40721,4577,2,1782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-09','2020-06-09',2557.00,NULL,NULL,1,'2021-08-12 16:43:48','2021-08-12 16:43:48',NULL),(1781,2978,40721,4577,2,1783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-10','2020-06-10',500.00,NULL,NULL,1,'2021-08-12 16:43:48','2021-08-12 16:43:48',NULL),(1782,2978,40721,4577,2,1784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-10','2020-06-10',1110.00,NULL,NULL,1,'2021-08-12 16:43:48','2021-08-12 16:43:48',NULL),(1783,2978,40721,4577,2,1785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-10','2020-06-10',3320.00,NULL,NULL,1,'2021-08-12 16:43:48','2021-08-12 16:43:48',NULL),(1784,2978,40721,4577,2,1786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-11','2020-06-11',1740.00,NULL,NULL,1,'2021-08-12 16:43:48','2021-08-12 16:43:48',NULL),(1785,2978,40721,4577,2,1787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-11','2020-06-11',820.00,NULL,NULL,1,'2021-08-12 16:43:48','2021-08-12 16:43:48',NULL),(1786,2978,40721,4577,2,1788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-12','2020-06-12',1510.00,NULL,NULL,1,'2021-08-12 16:43:48','2021-08-12 16:43:48',NULL),(1787,2978,40721,4577,2,1789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-14','2020-06-14',1714.00,NULL,NULL,1,'2021-08-12 16:43:48','2021-08-12 16:43:48',NULL),(1788,2978,40721,4577,2,1790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-15','2020-06-15',780.00,NULL,NULL,1,'2021-08-12 16:43:48','2021-08-12 16:43:48',NULL),(1789,2978,40721,4577,2,1791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-15','2020-06-15',1484.99,NULL,NULL,1,'2021-08-12 16:43:48','2021-08-12 16:43:48',NULL),(1790,2978,40721,4577,2,1792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-15','2020-06-15',1679.99,NULL,NULL,1,'2021-08-12 16:43:48','2021-08-12 16:43:48',NULL),(1791,2978,40721,4577,2,1793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-15','2020-06-15',2323.99,NULL,NULL,1,'2021-08-12 16:43:48','2021-08-12 16:43:48',NULL),(1792,2978,40721,4577,2,1794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-15','2020-06-15',2186.00,NULL,NULL,1,'2021-08-12 16:43:49','2021-08-12 16:43:49',NULL),(1793,2978,40721,4577,2,1795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-15','2020-06-15',340.00,NULL,NULL,1,'2021-08-12 16:43:49','2021-08-12 16:43:49',NULL),(1794,2978,40721,4577,2,1796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-16','2020-06-16',1470.00,NULL,NULL,1,'2021-08-12 16:43:49','2021-08-12 16:43:49',NULL),(1795,2978,40721,4577,2,1797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-16','2020-06-16',2360.00,NULL,NULL,1,'2021-08-12 16:43:49','2021-08-12 16:43:49',NULL),(1796,2978,40721,4577,2,1798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-16','2020-06-16',1644.99,NULL,NULL,1,'2021-08-12 16:43:49','2021-08-12 16:43:49',NULL);
INSERT INTO `balance_libro` VALUES (1797,2978,40721,4577,2,1799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-17','2020-06-17',2516.99,NULL,NULL,1,'2021-08-12 16:43:49','2021-08-12 16:43:49',NULL),(1798,2978,40721,4577,2,1800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-17','2020-06-17',5649.99,NULL,NULL,1,'2021-08-12 16:43:49','2021-08-12 16:43:49',NULL),(1799,2978,40721,4577,2,1801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-18','2020-06-18',900.00,NULL,NULL,1,'2021-08-12 16:43:49','2021-08-12 16:43:49',NULL),(1800,2978,40721,4577,2,1802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-20','2020-06-20',1380.00,NULL,NULL,1,'2021-08-12 16:43:49','2021-08-12 16:43:49',NULL),(1801,2978,40721,4577,2,1803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-21','2020-06-21',1691.99,NULL,NULL,1,'2021-08-12 16:43:49','2021-08-12 16:43:49',NULL),(1802,2978,40721,4577,2,1804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-21','2020-06-21',1431.00,NULL,NULL,1,'2021-08-12 16:43:49','2021-08-12 16:43:49',NULL),(1803,2978,40721,4577,2,1805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-23','2020-06-23',2350.00,NULL,NULL,1,'2021-08-12 16:43:49','2021-08-12 16:43:49',NULL),(1804,2978,40721,4577,2,1806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',2080.03,NULL,NULL,1,'2021-08-12 16:43:49','2021-08-12 16:43:49',NULL),(1805,2978,40721,4577,2,1807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',320.00,NULL,NULL,1,'2021-08-12 16:43:49','2021-08-12 16:43:49',NULL),(1806,2978,40721,4577,2,1808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',1000.00,NULL,NULL,1,'2021-08-12 16:43:49','2021-08-12 16:43:49',NULL),(1807,2978,40721,4577,2,1809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',2080.00,NULL,NULL,1,'2021-08-12 16:43:49','2021-08-12 16:43:49',NULL),(1808,2978,40721,4577,2,1810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',2992.00,NULL,NULL,1,'2021-08-12 16:43:49','2021-08-12 16:43:49',NULL),(1810,2978,40721,3045,2,1812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',2997.00,NULL,NULL,1,'2021-08-12 16:58:06','2021-08-12 16:58:06',NULL),(1811,2978,40721,3045,2,1813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',3969.00,NULL,NULL,1,'2021-08-12 16:58:06','2021-08-12 16:58:06',NULL),(1812,2978,40721,3045,2,1814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',2520.00,NULL,NULL,1,'2021-08-12 16:58:06','2021-08-12 16:58:06',NULL),(1813,2978,40721,3045,2,1815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',2388.60,NULL,NULL,1,'2021-08-12 16:58:06','2021-08-12 16:58:06',NULL),(1814,2978,40721,3045,2,1816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',2105.00,NULL,NULL,1,'2021-08-12 16:58:06','2021-08-12 16:58:06',NULL),(1815,2978,40721,3045,2,1817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',1062.00,NULL,NULL,1,'2021-08-12 16:58:06','2021-08-12 16:58:06',NULL),(1816,2978,40721,3045,2,1818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',3030.00,NULL,NULL,1,'2021-08-12 16:58:06','2021-08-12 16:58:06',NULL),(1817,2978,40721,3045,2,1819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',1000.00,NULL,NULL,1,'2021-08-12 16:58:06','2021-08-12 16:58:06',NULL),(1818,2978,40721,3045,2,1820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',750.00,NULL,NULL,1,'2021-08-12 16:58:06','2021-08-12 16:58:06',NULL),(1819,2978,40721,3045,2,1821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',4199.85,NULL,NULL,1,'2021-08-12 16:58:06','2021-08-12 16:58:06',NULL),(1820,2978,40721,3045,2,1822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',621.00,NULL,NULL,1,'2021-08-12 16:58:06','2021-08-12 16:58:06',NULL),(1821,2978,40721,3045,2,1823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',2446.20,NULL,NULL,1,'2021-08-12 16:58:06','2021-08-12 16:58:06',NULL);
INSERT INTO `balance_libro` VALUES (1822,2978,40721,3045,2,1824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',1644.30,NULL,NULL,1,'2021-08-12 16:58:06','2021-08-12 16:58:06',NULL),(1823,2978,40721,3045,2,1825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',1296.00,NULL,NULL,1,'2021-08-12 16:58:06','2021-08-12 16:58:06',NULL),(1824,2978,40721,3045,2,1826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',1929.60,NULL,NULL,1,'2021-08-12 16:58:06','2021-08-12 16:58:06',NULL),(1825,2978,40721,3045,2,1827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',1154.99,NULL,NULL,1,'2021-08-12 16:58:06','2021-08-12 16:58:06',NULL),(1826,2978,40721,3045,2,1828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',1219.50,NULL,NULL,1,'2021-08-12 16:58:07','2021-08-12 16:58:07',NULL),(1827,2978,40721,3045,2,1829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',3222.18,NULL,NULL,1,'2021-08-12 16:58:07','2021-08-12 16:58:07',NULL),(1828,2978,40721,3045,2,1830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-18','2021-04-18',3559.99,NULL,NULL,1,'2021-08-12 16:58:07','2021-08-12 16:58:07',NULL),(1829,2978,40721,3045,2,1831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-18','2021-04-18',2180.00,NULL,NULL,1,'2021-08-12 16:58:07','2021-08-12 16:58:07',NULL),(1830,2978,40721,3045,2,1832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-18','2021-04-18',1460.00,NULL,NULL,1,'2021-08-12 16:58:07','2021-08-12 16:58:07',NULL),(1831,2978,40721,3045,2,1833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-18','2021-04-18',2180.00,NULL,NULL,1,'2021-08-12 16:58:07','2021-08-12 16:58:07',NULL),(1832,2978,40721,3045,2,1834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',1750.00,NULL,NULL,1,'2021-08-12 16:58:07','2021-08-12 16:58:07',NULL),(1833,2978,40721,3045,2,1835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',1300.00,NULL,NULL,1,'2021-08-12 16:58:07','2021-08-12 16:58:07',NULL),(1834,2978,40721,3045,2,1836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',3654.00,NULL,NULL,1,'2021-08-12 16:58:07','2021-08-12 16:58:07',NULL),(1835,2978,40721,3045,2,1837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',5830.00,NULL,NULL,1,'2021-08-12 16:58:07','2021-08-12 16:58:07',NULL),(1836,2978,40721,3045,2,1838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',1170.00,NULL,NULL,1,'2021-08-12 16:58:07','2021-08-12 16:58:07',NULL),(1837,2978,40721,3045,2,1839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',2610.00,NULL,NULL,1,'2021-08-12 16:58:07','2021-08-12 16:58:07',NULL),(1838,2978,40721,3045,2,1840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',4720.00,NULL,NULL,1,'2021-08-12 16:58:07','2021-08-12 16:58:07',NULL),(1839,2978,40721,3045,2,1841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-25','2021-04-25',1170.00,NULL,NULL,1,'2021-08-12 16:58:07','2021-08-12 16:58:07',NULL),(1840,2978,40721,3045,2,1842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-25','2021-04-25',2840.00,NULL,NULL,1,'2021-08-12 16:58:07','2021-08-12 16:58:07',NULL),(1841,2978,40721,3045,2,1843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',2244.60,NULL,NULL,1,'2021-08-12 16:58:07','2021-08-12 16:58:07',NULL),(1842,2978,40721,3045,2,1844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',1440.00,NULL,NULL,1,'2021-08-12 16:58:07','2021-08-12 16:58:07',NULL),(1843,2978,40721,3045,2,1845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',1440.00,NULL,NULL,1,'2021-08-12 16:58:07','2021-08-12 16:58:07',NULL),(1844,2978,40721,3045,2,1846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',2071.98,NULL,NULL,1,'2021-08-12 16:58:07','2021-08-12 16:58:07',NULL),(1845,2978,40721,3046,2,1847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',1440.00,NULL,NULL,1,'2021-08-12 17:00:13','2021-08-12 17:00:13',NULL);
INSERT INTO `balance_libro` VALUES (1846,2978,40721,3046,2,1848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',4050.00,NULL,NULL,1,'2021-08-12 17:00:13','2021-08-12 17:00:13',NULL),(1847,2978,40721,3046,2,1849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',1440.00,NULL,NULL,1,'2021-08-12 17:00:13','2021-08-12 17:00:13',NULL),(1848,2978,40721,3046,2,1850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',585.00,NULL,NULL,1,'2021-08-12 17:00:13','2021-08-12 17:00:13',NULL),(1849,2978,40721,3046,2,1851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',750.00,NULL,NULL,1,'2021-08-12 17:00:13','2021-08-12 17:00:13',NULL),(1850,2978,40721,3046,2,1852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',2115.00,NULL,NULL,1,'2021-08-12 17:00:13','2021-08-12 17:00:13',NULL),(1851,2978,40721,3046,2,1853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',850.00,NULL,NULL,1,'2021-08-12 17:00:13','2021-08-12 17:00:13',NULL),(1852,2978,40721,3046,2,1854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',2727.00,NULL,NULL,1,'2021-08-12 17:00:13','2021-08-12 17:00:13',NULL),(1853,2978,40721,3046,2,1855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',1693.98,NULL,NULL,1,'2021-08-12 17:00:13','2021-08-12 17:00:13',NULL),(1854,2978,40721,3046,2,1856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-09','2021-05-09',3525.54,NULL,NULL,1,'2021-08-12 17:00:13','2021-08-12 17:00:13',NULL),(1855,2978,40721,3046,2,1857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',1440.00,NULL,NULL,1,'2021-08-12 17:00:13','2021-08-12 17:00:13',NULL),(1856,2978,40721,3046,2,1858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',1630.98,NULL,NULL,1,'2021-08-12 17:00:13','2021-08-12 17:00:13',NULL),(1857,2978,40721,3046,2,1859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',2180.00,NULL,NULL,1,'2021-08-12 17:00:13','2021-08-12 17:00:13',NULL),(1858,2978,40721,3046,2,1860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',1512.00,NULL,NULL,1,'2021-08-12 17:00:13','2021-08-12 17:00:13',NULL),(1859,2978,40721,3046,2,1861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',4233.98,NULL,NULL,1,'2021-08-12 17:00:14','2021-08-12 17:00:14',NULL),(1860,2978,40721,3046,2,1862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',2215.98,NULL,NULL,1,'2021-08-12 17:00:14','2021-08-12 17:00:14',NULL),(1861,2978,40721,3046,2,1863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',1962.00,NULL,NULL,1,'2021-08-12 17:00:14','2021-08-12 17:00:14',NULL),(1862,2978,40721,3046,2,1864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',2630.00,NULL,NULL,1,'2021-08-12 17:00:14','2021-08-12 17:00:14',NULL),(1863,2978,40721,3046,2,1865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',3205.13,NULL,NULL,1,'2021-08-12 17:00:14','2021-08-12 17:00:14',NULL),(1864,2978,40721,3046,2,1866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',3480.00,NULL,NULL,1,'2021-08-12 17:00:14','2021-08-12 17:00:14',NULL),(1865,2978,40721,3046,2,1867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',1430.00,NULL,NULL,1,'2021-08-12 17:00:14','2021-08-12 17:00:14',NULL),(1866,2978,40721,3046,2,1868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',850.00,NULL,NULL,1,'2021-08-12 17:00:14','2021-08-12 17:00:14',NULL),(1867,2978,40721,3046,2,1869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',2030.00,NULL,NULL,1,'2021-08-12 17:00:14','2021-08-12 17:00:14',NULL),(1868,2978,40721,3046,2,1870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',750.00,NULL,NULL,1,'2021-08-12 17:00:14','2021-08-12 17:00:14',NULL),(1869,2978,40721,3046,2,1871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',2409.19,NULL,NULL,1,'2021-08-12 17:00:14','2021-08-12 17:00:14',NULL);
INSERT INTO `balance_libro` VALUES (1870,2978,40721,3046,2,1872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',4329.00,NULL,NULL,1,'2021-08-12 17:00:14','2021-08-12 17:00:14',NULL),(1871,2978,40721,3046,2,1873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',3680.50,NULL,NULL,1,'2021-08-12 17:00:14','2021-08-12 17:00:14',NULL),(1872,2978,40721,3046,2,1874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',5660.00,NULL,NULL,1,'2021-08-12 17:00:14','2021-08-12 17:00:14',NULL),(1873,2978,40721,3047,2,1875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',2520.00,NULL,NULL,1,'2021-08-12 17:03:21','2021-08-12 17:03:21',NULL),(1874,2978,40721,3047,2,1876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',2655.00,NULL,NULL,1,'2021-08-12 17:03:21','2021-08-12 17:03:21',NULL),(1875,2978,40721,3047,2,1877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',2655.00,NULL,NULL,1,'2021-08-12 17:03:21','2021-08-12 17:03:21',NULL),(1876,2978,40721,3047,2,1878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',6220.00,NULL,NULL,1,'2021-08-12 17:03:21','2021-08-12 17:03:21',NULL),(1877,2978,40721,3047,2,1879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',6007.50,NULL,NULL,1,'2021-08-12 17:03:21','2021-08-12 17:03:21',NULL),(1878,2978,40721,3047,2,1880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',3580.00,NULL,NULL,1,'2021-08-12 17:03:21','2021-08-12 17:03:21',NULL),(1879,2978,40721,3047,2,1881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',2389.50,NULL,NULL,1,'2021-08-12 17:03:21','2021-08-12 17:03:21',NULL),(1880,2978,40721,3047,2,1882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',2389.50,NULL,NULL,1,'2021-08-12 17:03:21','2021-08-12 17:03:21',NULL),(1881,2978,40721,3047,2,1883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',6529.50,NULL,NULL,1,'2021-08-12 17:03:21','2021-08-12 17:03:21',NULL),(1882,2978,40721,3047,2,1884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',2733.48,NULL,NULL,1,'2021-08-12 17:03:21','2021-08-12 17:03:21',NULL),(1883,2978,40721,3047,2,1885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',2227.50,NULL,NULL,1,'2021-08-12 17:03:21','2021-08-12 17:03:21',NULL),(1884,2978,40721,3047,2,1886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',2655.00,NULL,NULL,1,'2021-08-12 17:03:21','2021-08-12 17:03:21',NULL),(1885,2978,40721,3047,2,1887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',5508.00,NULL,NULL,1,'2021-08-12 17:03:21','2021-08-12 17:03:21',NULL),(1886,2978,40721,3047,2,1888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',2733.48,NULL,NULL,1,'2021-08-12 17:03:21','2021-08-12 17:03:21',NULL),(1887,2978,40721,3047,2,1889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',1197.00,NULL,NULL,1,'2021-08-12 17:03:21','2021-08-12 17:03:21',NULL),(1888,2978,40721,3047,2,1890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',2922.34,NULL,NULL,1,'2021-08-12 17:03:21','2021-08-12 17:03:21',NULL),(1889,2978,40721,3047,2,1891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',1170.00,NULL,NULL,1,'2021-08-12 17:03:21','2021-08-12 17:03:21',NULL),(1890,2978,40721,3047,2,1892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',2800.00,NULL,NULL,1,'2021-08-12 17:03:21','2021-08-12 17:03:21',NULL),(1891,2978,40721,3047,2,1893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',4020.48,NULL,NULL,1,'2021-08-12 17:03:21','2021-08-12 17:03:21',NULL),(1892,2978,40721,3047,2,1894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',3213.00,NULL,NULL,1,'2021-08-12 17:03:21','2021-08-12 17:03:21',NULL),(1893,2978,40721,3047,2,1895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',2550.00,NULL,NULL,1,'2021-08-12 17:03:21','2021-08-12 17:03:21',NULL);
INSERT INTO `balance_libro` VALUES (1894,2978,40721,3047,2,1896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',3650.00,NULL,NULL,1,'2021-08-12 17:03:21','2021-08-12 17:03:21',NULL),(1895,2978,40721,3047,2,1897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',1500.00,NULL,NULL,1,'2021-08-12 17:03:21','2021-08-12 17:03:21',NULL),(1896,2978,40721,3047,2,1898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',2655.00,NULL,NULL,1,'2021-08-12 17:03:22','2021-08-12 17:03:22',NULL),(1897,2978,40721,3047,2,1899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',2475.00,NULL,NULL,1,'2021-08-12 17:03:22','2021-08-12 17:03:22',NULL),(1898,2978,40721,3047,2,1900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',2250.00,NULL,NULL,1,'2021-08-12 17:03:22','2021-08-12 17:03:22',NULL),(1899,2978,40721,3047,2,1901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',1924.00,NULL,NULL,1,'2021-08-12 17:03:22','2021-08-12 17:03:22',NULL),(1900,2978,40721,3047,2,1902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3420.00,NULL,NULL,1,'2021-08-12 17:03:22','2021-08-12 17:03:22',NULL),(1901,2978,40721,3047,2,1903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',2655.00,NULL,NULL,1,'2021-08-12 17:03:22','2021-08-12 17:03:22',NULL),(1902,2978,40721,3047,2,1904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',2655.00,NULL,NULL,1,'2021-08-12 17:03:22','2021-08-12 17:03:22',NULL),(1903,2978,40721,3047,2,1905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',4230.00,NULL,NULL,1,'2021-08-12 17:03:22','2021-08-12 17:03:22',NULL),(1904,2978,40721,3047,2,1906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3150.00,NULL,NULL,1,'2021-08-12 17:03:22','2021-08-12 17:03:22',NULL),(1905,2978,40721,3047,2,1907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',2950.00,NULL,NULL,1,'2021-08-12 17:03:22','2021-08-12 17:03:22',NULL),(1906,2978,40721,3047,2,1908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',2412.00,NULL,NULL,1,'2021-08-12 17:03:22','2021-08-12 17:03:22',NULL),(1907,2978,40721,3047,2,1909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3325.54,NULL,NULL,1,'2021-08-12 17:03:22','2021-08-12 17:03:22',NULL),(1908,2978,40721,3047,2,1910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',2655.00,NULL,NULL,1,'2021-08-12 17:03:22','2021-08-12 17:03:22',NULL),(1909,2978,40721,3047,2,1911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',2830.00,NULL,NULL,1,'2021-08-12 17:03:22','2021-08-12 17:03:22',NULL),(1910,2978,40721,3047,2,1912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',5780.00,NULL,NULL,1,'2021-08-12 17:03:22','2021-08-12 17:03:22',NULL),(1911,2978,40721,3047,2,1913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',2950.00,NULL,NULL,1,'2021-08-12 17:03:22','2021-08-12 17:03:22',NULL),(1912,2978,40721,3047,2,1914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',1935.00,NULL,NULL,1,'2021-08-12 17:03:22','2021-08-12 17:03:22',NULL),(1913,2978,40721,3047,2,1915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',2950.00,NULL,NULL,1,'2021-08-12 17:03:22','2021-08-12 17:03:22',NULL),(1914,2978,40721,3047,2,1916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',8250.00,NULL,NULL,1,'2021-08-12 17:03:22','2021-08-12 17:03:22',NULL),(1915,2978,40721,3047,2,1917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',3400.00,NULL,NULL,1,'2021-08-12 17:03:22','2021-08-12 17:03:22',NULL),(1916,2978,40721,3047,2,1918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',3143.98,NULL,NULL,1,'2021-08-12 17:03:22','2021-08-12 17:03:22',NULL),(1917,2978,40721,3047,2,1919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',1602.00,NULL,NULL,1,'2021-08-12 17:03:22','2021-08-12 17:03:22',NULL);
INSERT INTO `balance_libro` VALUES (1918,2978,40721,3047,2,1920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',1300.00,NULL,NULL,1,'2021-08-12 17:03:22','2021-08-12 17:03:22',NULL),(1919,2978,40721,3047,2,1921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',11420.11,NULL,NULL,1,'2021-08-12 17:03:22','2021-08-12 17:03:22',NULL),(1920,2978,40721,3047,2,1922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',2750.00,NULL,NULL,1,'2021-08-12 17:03:22','2021-08-12 17:03:22',NULL),(1921,2978,40721,3047,2,1923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',5700.00,NULL,NULL,1,'2021-08-12 17:03:22','2021-08-12 17:03:22',NULL),(1922,2978,40721,3047,2,1924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',4580.00,NULL,NULL,1,'2021-08-12 17:03:22','2021-08-12 17:03:22',NULL),(1923,2978,40721,3047,2,1925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',1287.00,NULL,NULL,1,'2021-08-12 17:03:22','2021-08-12 17:03:22',NULL),(1924,2978,40721,3047,2,1926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',1430.00,NULL,NULL,1,'2021-08-12 17:03:23','2021-08-12 17:03:23',NULL),(1925,2978,40721,3047,2,1927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',3555.00,NULL,NULL,1,'2021-08-12 17:03:23','2021-08-12 17:03:23',NULL),(1926,2978,40721,3047,2,1928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',8255.00,NULL,NULL,1,'2021-08-12 17:03:23','2021-08-12 17:03:23',NULL),(1927,2978,40721,3047,2,1929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',5200.00,NULL,NULL,1,'2021-08-12 17:03:23','2021-08-12 17:03:23',NULL),(1928,2978,40721,3047,2,1930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',6550.00,NULL,NULL,1,'2021-08-12 17:03:23','2021-08-12 17:03:23',NULL),(1929,2978,40721,3047,2,1931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',3580.00,NULL,NULL,1,'2021-08-12 17:03:23','2021-08-12 17:03:23',NULL),(1930,2978,40721,3047,2,1932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',4930.00,NULL,NULL,1,'2021-08-12 17:03:23','2021-08-12 17:03:23',NULL),(1931,2978,40721,3047,2,1933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',2654.99,NULL,NULL,1,'2021-08-12 17:03:23','2021-08-12 17:03:23',NULL),(1932,2978,40721,3047,2,1934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',5660.00,NULL,NULL,1,'2021-08-12 17:03:23','2021-08-12 17:03:23',NULL),(1933,2978,40721,3047,2,1935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',3510.00,NULL,NULL,1,'2021-08-12 17:03:23','2021-08-12 17:03:23',NULL),(1934,2978,40721,3047,2,1936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',2677.50,NULL,NULL,1,'2021-08-12 17:03:23','2021-08-12 17:03:23',NULL),(1935,2978,40721,3047,2,1937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',2860.00,NULL,NULL,1,'2021-08-12 17:03:23','2021-08-12 17:03:23',NULL),(1936,2978,40721,3047,2,1938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',2146.50,NULL,NULL,1,'2021-08-12 17:03:23','2021-08-12 17:03:23',NULL),(1937,2978,40721,3047,2,1939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',1287.00,NULL,NULL,1,'2021-08-12 17:03:23','2021-08-12 17:03:23',NULL),(1938,2978,40721,3047,2,1940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',5835.00,NULL,NULL,1,'2021-08-12 17:03:23','2021-08-12 17:03:23',NULL),(1939,2978,40721,3047,2,1941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',1827.00,NULL,NULL,1,'2021-08-12 17:03:23','2021-08-12 17:03:23',NULL),(1940,2978,40721,3047,2,1942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',1800.00,NULL,NULL,1,'2021-08-12 17:03:23','2021-08-12 17:03:23',NULL),(1941,2978,40721,3047,2,1943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',2950.00,NULL,NULL,1,'2021-08-12 17:03:23','2021-08-12 17:03:23',NULL);
INSERT INTO `balance_libro` VALUES (1942,2978,40871,44036,2,1944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',40000.00,NULL,NULL,1,'2021-08-12 18:00:38','2021-08-12 18:00:38',NULL),(1943,2978,40871,44037,2,1945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',40000.00,NULL,NULL,1,'2021-08-12 18:06:47','2021-08-12 18:06:47',NULL),(1944,2978,40871,44039,2,1946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',40000.00,NULL,NULL,1,'2021-08-12 18:24:33','2021-08-12 18:24:33',NULL),(1945,2978,40871,44040,2,1947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-30','2020-10-30',40000.00,NULL,NULL,1,'2021-08-12 19:00:13','2021-08-12 19:00:13',NULL),(1946,2978,40871,44041,2,1948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',40000.00,NULL,NULL,1,'2021-08-12 19:01:50','2021-08-12 19:01:50',NULL),(1947,2978,40871,44042,2,1949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-21','2020-12-21',40000.00,NULL,NULL,1,'2021-08-12 19:05:00','2021-08-12 19:05:00',NULL),(1948,2978,40871,37920,2,1950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',40000.00,NULL,NULL,1,'2021-08-12 19:09:07','2021-08-12 19:09:07',NULL),(1949,2978,41300,44068,2,1951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-01','2020-08-01',250.00,NULL,NULL,1,'2021-08-12 20:00:20','2021-08-12 20:00:20',NULL),(1950,2978,41300,44068,2,1952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-04','2020-08-04',200.00,NULL,NULL,1,'2021-08-12 20:00:20','2021-08-12 20:00:20',NULL),(1951,2978,41300,44068,2,1953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-04','2020-08-04',300.00,NULL,NULL,1,'2021-08-12 20:00:20','2021-08-12 20:00:20',NULL),(1952,2978,41300,44068,2,1954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-04','2020-08-04',450.00,NULL,NULL,1,'2021-08-12 20:00:20','2021-08-12 20:00:20',NULL),(1953,2978,41300,44068,2,1955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-05','2020-08-05',100.00,NULL,NULL,1,'2021-08-12 20:00:21','2021-08-12 20:00:21',NULL),(1954,2978,41300,44068,2,1956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-05','2020-08-05',350.00,NULL,NULL,1,'2021-08-12 20:00:21','2021-08-12 20:00:21',NULL),(1955,2978,41300,44071,2,1957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-03','2020-11-03',300.00,NULL,NULL,1,'2021-08-12 20:01:53','2021-08-12 20:01:53',NULL),(1956,2978,41300,44071,2,1958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-10','2020-11-10',300.00,NULL,NULL,1,'2021-08-12 20:01:53','2021-08-12 20:01:53',NULL),(1957,2978,41300,44071,2,1959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-19','2020-11-19',730.00,NULL,NULL,1,'2021-08-12 20:01:53','2021-08-12 20:01:53',NULL),(1958,2978,41300,44071,2,1960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-27','2020-11-27',350.00,NULL,NULL,1,'2021-08-12 20:01:53','2021-08-12 20:01:53',NULL),(1959,2978,41300,44071,2,1961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-27','2020-11-27',800.00,NULL,NULL,1,'2021-08-12 20:01:53','2021-08-12 20:01:53',NULL),(1960,2978,41300,44071,2,1962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-28','2020-11-28',1650.00,NULL,NULL,1,'2021-08-12 20:01:53','2021-08-12 20:01:53',NULL),(1961,2978,41300,44071,2,1963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-28','2020-11-28',100.00,NULL,NULL,1,'2021-08-12 20:01:53','2021-08-12 20:01:53',NULL),(1962,2978,41300,44071,2,1964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-28','2020-11-28',850.00,NULL,NULL,1,'2021-08-12 20:01:54','2021-08-12 20:01:54',NULL),(1963,2978,41300,44071,2,1965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-28','2020-11-28',1900.00,NULL,NULL,1,'2021-08-12 20:01:54','2021-08-12 20:01:54',NULL),(1964,2978,41300,44072,2,1966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-03','2020-12-03',500.00,NULL,NULL,1,'2021-08-12 20:02:51','2021-08-12 20:02:51',NULL),(1965,2978,41300,44072,2,1967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-03','2020-12-03',550.00,NULL,NULL,1,'2021-08-12 20:02:51','2021-08-12 20:02:51',NULL);
INSERT INTO `balance_libro` VALUES (1966,2978,41300,44072,2,1968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-05','2020-12-05',1500.00,NULL,NULL,1,'2021-08-12 20:02:51','2021-08-12 20:02:51',NULL),(1967,2978,41300,44072,2,1969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-08','2020-12-08',900.00,NULL,NULL,1,'2021-08-12 20:02:51','2021-08-12 20:02:51',NULL),(1968,2978,41300,44072,2,1970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-08','2020-12-08',1000.00,NULL,NULL,1,'2021-08-12 20:02:51','2021-08-12 20:02:51',NULL),(1969,2978,41300,44072,2,1971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-14','2020-12-14',300.00,NULL,NULL,1,'2021-08-12 20:02:52','2021-08-12 20:02:52',NULL),(1970,2978,41300,44072,2,1972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-16','2020-12-16',350.00,NULL,NULL,1,'2021-08-12 20:02:52','2021-08-12 20:02:52',NULL),(1971,2978,41300,44072,2,1973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-17','2020-12-17',450.00,NULL,NULL,1,'2021-08-12 20:02:52','2021-08-12 20:02:52',NULL),(1972,2978,41300,44072,2,1974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-19','2020-12-19',480.00,NULL,NULL,1,'2021-08-12 20:02:52','2021-08-12 20:02:52',NULL),(1973,2978,41300,44072,2,1975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',450.00,NULL,NULL,1,'2021-08-12 20:02:52','2021-08-12 20:02:52',NULL),(1974,2978,41300,44076,2,1976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',360.00,NULL,NULL,1,'2021-08-12 20:12:35','2021-08-12 20:12:35',NULL),(1975,2978,41300,44076,2,1977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',400.00,NULL,NULL,1,'2021-08-12 20:12:35','2021-08-12 20:12:35',NULL),(1976,2978,41300,44077,2,1978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',400.00,NULL,NULL,1,'2021-08-12 20:13:41','2021-08-12 20:13:41',NULL),(1977,2978,41300,44077,2,1979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',500.00,NULL,NULL,1,'2021-08-12 20:13:41','2021-08-12 20:13:41',NULL),(1978,2978,41300,44078,2,1980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',500.00,NULL,NULL,1,'2021-08-12 20:14:53','2021-08-12 20:14:53',NULL),(1979,2978,41300,44079,2,1981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',400.00,NULL,NULL,1,'2021-08-12 20:22:44','2021-08-12 20:22:44',NULL),(1980,2978,41300,44079,2,1982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',500.00,NULL,NULL,1,'2021-08-12 20:22:44','2021-08-12 20:22:44',NULL),(1981,2978,41300,44079,2,1983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',2150.00,NULL,NULL,1,'2021-08-12 20:22:44','2021-08-12 20:22:44',NULL),(1982,2978,41300,44079,2,1984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',1200.00,NULL,NULL,1,'2021-08-12 20:22:44','2021-08-12 20:22:44',NULL),(1983,2978,41300,44079,2,1985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',650.00,NULL,NULL,1,'2021-08-12 20:22:44','2021-08-12 20:22:44',NULL),(1984,2978,41300,44079,2,1986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',1600.00,NULL,NULL,1,'2021-08-12 20:22:44','2021-08-12 20:22:44',NULL),(1985,2978,41300,44079,2,1987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',1650.00,NULL,NULL,1,'2021-08-12 20:22:44','2021-08-12 20:22:44',NULL),(1986,2978,41300,44079,2,1988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',1300.00,NULL,NULL,1,'2021-08-12 20:22:44','2021-08-12 20:22:44',NULL),(1987,2978,41300,44079,2,1989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',1200.00,NULL,NULL,1,'2021-08-12 20:22:44','2021-08-12 20:22:44',NULL),(1988,2978,41300,44080,2,1990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',800.00,NULL,NULL,1,'2021-08-12 20:24:24','2021-08-12 20:24:24',NULL),(1989,2978,41300,44080,2,1991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',500.00,NULL,NULL,1,'2021-08-12 20:24:24','2021-08-12 20:24:24',NULL);
INSERT INTO `balance_libro` VALUES (1990,2978,41300,44080,2,1992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',800.00,NULL,NULL,1,'2021-08-12 20:24:24','2021-08-12 20:24:24',NULL),(1991,2978,41300,44080,2,1993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',1200.00,NULL,NULL,1,'2021-08-12 20:24:24','2021-08-12 20:24:24',NULL),(1992,2978,41300,44081,2,1994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',300.00,NULL,NULL,1,'2021-08-12 20:25:32','2021-08-12 20:25:32',NULL),(1993,2978,41300,44081,2,1995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',400.00,NULL,NULL,1,'2021-08-12 20:25:32','2021-08-12 20:25:32',NULL),(1994,2978,41300,44081,2,1996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',400.00,NULL,NULL,1,'2021-08-12 20:25:32','2021-08-12 20:25:32',NULL),(1995,2978,41300,44081,2,1997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',600.00,NULL,NULL,1,'2021-08-12 20:25:32','2021-08-12 20:25:32',NULL),(1996,2978,41300,44082,2,1998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',400.00,NULL,NULL,1,'2021-08-12 20:26:48','2021-08-12 20:26:48',NULL),(1997,2978,41300,44082,2,1999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',400.00,NULL,NULL,1,'2021-08-12 20:26:48','2021-08-12 20:26:48',NULL),(1998,2978,41300,44082,2,2000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',500.00,NULL,NULL,1,'2021-08-12 20:26:48','2021-08-12 20:26:48',NULL),(1999,2978,41348,107261,3,2001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-01','2021-01-01',1300.00,NULL,NULL,1,'2021-08-17 18:27:23','2021-08-17 18:27:23',NULL),(2000,2978,41348,107261,3,2002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-02','2021-01-02',9000.00,NULL,NULL,1,'2021-08-17 18:27:23','2021-08-17 18:27:23',NULL),(2001,2978,41348,107261,3,2003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-03','2021-01-03',2437.74,NULL,NULL,1,'2021-08-17 18:27:23','2021-08-17 18:27:23',NULL),(2002,2978,41348,107261,3,2004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',866.72,NULL,NULL,1,'2021-08-17 18:27:23','2021-08-17 18:27:23',NULL),(2003,2978,41348,107261,3,2005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',1530.32,NULL,NULL,1,'2021-08-17 18:27:24','2021-08-17 18:27:24',NULL),(2004,2978,41348,107261,3,2006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',142228.19,NULL,NULL,1,'2021-08-17 18:27:24','2021-08-17 18:27:24',NULL),(2005,2978,41348,107261,3,2007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',8038.00,NULL,NULL,1,'2021-08-17 18:27:24','2021-08-17 18:27:24',NULL),(2006,2978,41348,107261,3,2008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',8600.00,NULL,NULL,1,'2021-08-17 18:27:24','2021-08-17 18:27:24',NULL),(2007,2978,41348,107261,3,2009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',8600.00,NULL,NULL,1,'2021-08-17 18:27:24','2021-08-17 18:27:24',NULL),(2008,2978,41348,107261,3,2010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',447.82,NULL,NULL,1,'2021-08-17 18:27:24','2021-08-17 18:27:24',NULL),(2009,2978,41348,107261,3,2011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-10','2021-01-10',54.00,NULL,NULL,1,'2021-08-17 18:27:24','2021-08-17 18:27:24',NULL),(2010,2978,41348,107261,3,2012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',534.02,NULL,NULL,1,'2021-08-17 18:27:24','2021-08-17 18:27:24',NULL),(2011,2978,41348,107261,3,2013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',2237.60,NULL,NULL,1,'2021-08-17 18:27:24','2021-08-17 18:27:24',NULL),(2012,2978,41348,107261,3,2014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',7606.93,NULL,NULL,1,'2021-08-17 18:27:24','2021-08-17 18:27:24',NULL),(2013,2978,41348,107261,3,2015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',91997.04,NULL,NULL,1,'2021-08-17 18:27:24','2021-08-17 18:27:24',NULL);
INSERT INTO `balance_libro` VALUES (2014,2978,41348,107261,3,2016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',10743.20,NULL,NULL,1,'2021-08-17 18:27:24','2021-08-17 18:27:24',NULL),(2015,2978,41348,107261,3,2017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-16','2021-01-16',4145.01,NULL,NULL,1,'2021-08-17 18:27:24','2021-08-17 18:27:24',NULL),(2016,2978,41348,107261,3,2018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',22000.00,NULL,NULL,1,'2021-08-17 18:27:24','2021-08-17 18:27:24',NULL),(2017,2978,41348,107261,3,2019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',36537.66,NULL,NULL,1,'2021-08-17 18:27:24','2021-08-17 18:27:24',NULL),(2018,2978,41348,107261,3,2020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',216800.00,NULL,NULL,1,'2021-08-17 18:27:24','2021-08-17 18:27:24',NULL),(2019,2978,41348,107261,3,2021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',5711.08,NULL,NULL,1,'2021-08-17 18:27:24','2021-08-17 18:27:24',NULL),(2020,2978,41348,107261,3,2022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',14706.23,NULL,NULL,1,'2021-08-17 18:27:24','2021-08-17 18:27:24',NULL),(2021,2978,41348,107261,3,2023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',5168.77,NULL,NULL,1,'2021-08-17 18:27:24','2021-08-17 18:27:24',NULL),(2022,2978,41348,107261,3,2024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',20163.30,NULL,NULL,1,'2021-08-17 18:27:24','2021-08-17 18:27:24',NULL),(2023,2978,41348,107261,3,2025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',497.60,NULL,NULL,1,'2021-08-17 18:27:24','2021-08-17 18:27:24',NULL),(2024,2978,41348,107261,3,2026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',7200.00,NULL,NULL,1,'2021-08-17 18:27:24','2021-08-17 18:27:24',NULL),(2025,2978,41348,107261,3,2027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',150.51,NULL,NULL,1,'2021-08-17 18:27:24','2021-08-17 18:27:24',NULL),(2026,2978,41348,107261,3,2028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',2923.02,NULL,NULL,1,'2021-08-17 18:27:24','2021-08-17 18:27:24',NULL),(2027,2978,41348,107261,3,2029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',1613.10,NULL,NULL,1,'2021-08-17 18:27:24','2021-08-17 18:27:24',NULL),(2028,2978,41348,107261,3,2030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',79203.39,NULL,NULL,1,'2021-08-17 18:27:24','2021-08-17 18:27:24',NULL),(2029,2978,41348,107261,3,2031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',31379.82,NULL,NULL,1,'2021-08-17 18:27:24','2021-08-17 18:27:24',NULL),(2030,2978,41348,107261,3,2032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',48601.40,NULL,NULL,1,'2021-08-17 18:27:24','2021-08-17 18:27:24',NULL),(2031,2978,41348,107262,3,2033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',2386.60,NULL,NULL,1,'2021-08-17 18:30:03','2021-08-17 18:30:03',NULL),(2032,2978,41348,107262,3,2034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',1300.00,NULL,NULL,1,'2021-08-17 18:30:03','2021-08-17 18:30:03',NULL),(2033,2978,41348,107262,3,2035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',9170.01,NULL,NULL,1,'2021-08-17 18:30:03','2021-08-17 18:30:03',NULL),(2034,2978,41348,107262,3,2036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',2669.81,NULL,NULL,1,'2021-08-17 18:30:03','2021-08-17 18:30:03',NULL),(2035,2978,41348,107262,3,2037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',41761.34,NULL,NULL,1,'2021-08-17 18:30:03','2021-08-17 18:30:03',NULL),(2036,2978,41348,107262,3,2038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',3888.12,NULL,NULL,1,'2021-08-17 18:30:03','2021-08-17 18:30:03',NULL),(2037,2978,41348,107262,3,2039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',3502.45,NULL,NULL,1,'2021-08-17 18:30:04','2021-08-17 18:30:04',NULL);
INSERT INTO `balance_libro` VALUES (2038,2978,41348,107262,3,2040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',15354.91,NULL,NULL,1,'2021-08-17 18:30:04','2021-08-17 18:30:04',NULL),(2039,2978,41348,107262,3,2041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',12977.08,NULL,NULL,1,'2021-08-17 18:30:04','2021-08-17 18:30:04',NULL),(2040,2978,41348,107262,3,2042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',5711.08,NULL,NULL,1,'2021-08-17 18:30:04','2021-08-17 18:30:04',NULL),(2041,2978,41348,107262,3,2043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',6972.36,NULL,NULL,1,'2021-08-17 18:30:04','2021-08-17 18:30:04',NULL),(2042,2978,41348,107262,3,2044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-06','2021-02-06',10830.00,NULL,NULL,1,'2021-08-17 18:30:04','2021-08-17 18:30:04',NULL),(2043,2978,41348,107262,3,2045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',12973.62,NULL,NULL,1,'2021-08-17 18:30:04','2021-08-17 18:30:04',NULL),(2044,2978,41348,107262,3,2046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',2415.77,NULL,NULL,1,'2021-08-17 18:30:04','2021-08-17 18:30:04',NULL),(2045,2978,41348,107262,3,2047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',152968.64,NULL,NULL,1,'2021-08-17 18:30:04','2021-08-17 18:30:04',NULL),(2046,2978,41348,107262,3,2048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',2510.42,NULL,NULL,1,'2021-08-17 18:30:04','2021-08-17 18:30:04',NULL),(2047,2978,41348,107262,3,2049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',2933.81,NULL,NULL,1,'2021-08-17 18:30:04','2021-08-17 18:30:04',NULL),(2048,2978,41348,107262,3,2050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',4325.69,NULL,NULL,1,'2021-08-17 18:30:04','2021-08-17 18:30:04',NULL),(2049,2978,41348,107262,3,2051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',8651.38,NULL,NULL,1,'2021-08-17 18:30:04','2021-08-17 18:30:04',NULL),(2050,2978,41348,107262,3,2052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',117.00,NULL,NULL,1,'2021-08-17 18:30:04','2021-08-17 18:30:04',NULL),(2051,2978,41348,107262,3,2053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',35925.07,NULL,NULL,1,'2021-08-17 18:30:04','2021-08-17 18:30:04',NULL),(2052,2978,41348,107262,3,2054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',3075.13,NULL,NULL,1,'2021-08-17 18:30:04','2021-08-17 18:30:04',NULL),(2053,2978,41348,107262,3,2055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',3328.85,NULL,NULL,1,'2021-08-17 18:30:04','2021-08-17 18:30:04',NULL),(2054,2978,41348,107262,3,2056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',949.00,NULL,NULL,1,'2021-08-17 18:30:04','2021-08-17 18:30:04',NULL),(2055,2978,41348,107262,3,2057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',2874.00,NULL,NULL,1,'2021-08-17 18:30:04','2021-08-17 18:30:04',NULL),(2056,2978,41348,107262,3,2058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',73.20,NULL,NULL,1,'2021-08-17 18:30:04','2021-08-17 18:30:04',NULL),(2057,2978,41348,107262,3,2059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',105.96,NULL,NULL,1,'2021-08-17 18:30:04','2021-08-17 18:30:04',NULL),(2058,2978,41348,107262,3,2060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',866.72,NULL,NULL,1,'2021-08-17 18:30:04','2021-08-17 18:30:04',NULL),(2059,2978,41348,107262,3,2061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',35.00,NULL,NULL,1,'2021-08-17 18:30:04','2021-08-17 18:30:04',NULL),(2060,2978,41348,107262,3,2062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',6336.29,NULL,NULL,1,'2021-08-17 18:30:04','2021-08-17 18:30:04',NULL),(2061,2978,41348,107262,3,2063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',93302.49,NULL,NULL,1,'2021-08-17 18:30:04','2021-08-17 18:30:04',NULL);
INSERT INTO `balance_libro` VALUES (2062,2978,41348,107262,3,2064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',67431.06,NULL,NULL,1,'2021-08-17 18:30:04','2021-08-17 18:30:04',NULL),(2063,2978,41348,107262,3,2065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',41503.03,NULL,NULL,1,'2021-08-17 18:30:04','2021-08-17 18:30:04',NULL),(2064,2978,41348,107262,3,2066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',2633.93,NULL,NULL,1,'2021-08-17 18:30:04','2021-08-17 18:30:04',NULL),(2065,2978,41348,107263,3,2067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',6732.00,NULL,NULL,1,'2021-08-17 18:31:53','2021-08-17 18:31:53',NULL),(2066,2978,41348,107263,3,2068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',9900.00,NULL,NULL,1,'2021-08-17 18:31:53','2021-08-17 18:31:53',NULL),(2067,2978,41348,107263,3,2069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',3425.69,NULL,NULL,1,'2021-08-17 18:31:53','2021-08-17 18:31:53',NULL),(2068,2978,41348,107263,3,2070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1300.00,NULL,NULL,1,'2021-08-17 18:31:53','2021-08-17 18:31:53',NULL),(2069,2978,41348,107263,3,2071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',1055.12,NULL,NULL,1,'2021-08-17 18:31:53','2021-08-17 18:31:53',NULL),(2070,2978,41348,107263,3,2072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',2388.09,NULL,NULL,1,'2021-08-17 18:31:53','2021-08-17 18:31:53',NULL),(2071,2978,41348,107263,3,2073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',8796.43,NULL,NULL,1,'2021-08-17 18:31:53','2021-08-17 18:31:53',NULL),(2072,2978,41348,107263,3,2074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',16178.98,NULL,NULL,1,'2021-08-17 18:31:53','2021-08-17 18:31:53',NULL),(2073,2978,41348,107263,3,2075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',2461.22,NULL,NULL,1,'2021-08-17 18:31:53','2021-08-17 18:31:53',NULL),(2074,2978,41348,107263,3,2076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',74.93,NULL,NULL,1,'2021-08-17 18:31:53','2021-08-17 18:31:53',NULL),(2075,2978,41348,107263,3,2077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',108.59,NULL,NULL,1,'2021-08-17 18:31:53','2021-08-17 18:31:53',NULL),(2076,2978,41348,107263,3,2078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',18600.96,NULL,NULL,1,'2021-08-17 18:31:53','2021-08-17 18:31:53',NULL),(2077,2978,41348,107263,3,2079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',43872.54,NULL,NULL,1,'2021-08-17 18:31:53','2021-08-17 18:31:53',NULL),(2078,2978,41348,107263,3,2080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',131741.41,NULL,NULL,1,'2021-08-17 18:31:54','2021-08-17 18:31:54',NULL),(2079,2978,41348,107263,3,2081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',29.28,NULL,NULL,1,'2021-08-17 18:31:54','2021-08-17 18:31:54',NULL),(2080,2978,41348,107263,3,2082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',105.96,NULL,NULL,1,'2021-08-17 18:31:54','2021-08-17 18:31:54',NULL),(2081,2978,41348,107263,3,2083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',73.47,NULL,NULL,1,'2021-08-17 18:31:54','2021-08-17 18:31:54',NULL),(2082,2978,41348,107263,3,2084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',108.59,NULL,NULL,1,'2021-08-17 18:31:54','2021-08-17 18:31:54',NULL),(2083,2978,41348,107263,3,2085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',51348.01,NULL,NULL,1,'2021-08-17 18:31:54','2021-08-17 18:31:54',NULL),(2084,2978,41348,107263,3,2086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1574.30,NULL,NULL,1,'2021-08-17 18:31:54','2021-08-17 18:31:54',NULL),(2085,2978,41348,107263,3,2087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',8600.00,NULL,NULL,1,'2021-08-17 18:31:54','2021-08-17 18:31:54',NULL);
INSERT INTO `balance_libro` VALUES (2086,2978,41348,107263,3,2088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',8600.00,NULL,NULL,1,'2021-08-17 18:31:54','2021-08-17 18:31:54',NULL),(2087,2978,41348,107263,3,2089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',2862.40,NULL,NULL,1,'2021-08-17 18:31:54','2021-08-17 18:31:54',NULL),(2088,2978,41348,107263,3,2090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',19941.59,NULL,NULL,1,'2021-08-17 18:31:54','2021-08-17 18:31:54',NULL),(2089,2978,41348,107263,3,2091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',169885.38,NULL,NULL,1,'2021-08-17 18:31:54','2021-08-17 18:31:54',NULL),(2090,2978,41348,107263,3,2092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',5407.10,NULL,NULL,1,'2021-08-17 18:31:54','2021-08-17 18:31:54',NULL),(2091,2978,41348,107263,3,2093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',1574.30,NULL,NULL,1,'2021-08-17 18:31:54','2021-08-17 18:31:54',NULL),(2092,2978,41348,107263,3,2094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',83.70,NULL,NULL,1,'2021-08-17 18:31:54','2021-08-17 18:31:54',NULL),(2093,2978,41348,107263,3,2095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',13920.45,NULL,NULL,1,'2021-08-17 18:31:54','2021-08-17 18:31:54',NULL),(2094,2978,41348,107263,3,2096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',131765.40,NULL,NULL,1,'2021-08-17 18:31:54','2021-08-17 18:31:54',NULL),(2095,2978,41348,107263,3,2097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',35.00,NULL,NULL,1,'2021-08-17 18:31:54','2021-08-17 18:31:54',NULL),(2096,2978,41348,107263,3,2098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',73752.44,NULL,NULL,1,'2021-08-17 18:31:54','2021-08-17 18:31:54',NULL),(2097,2978,41348,107263,3,2099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',93730.09,NULL,NULL,1,'2021-08-17 18:31:54','2021-08-17 18:31:54',NULL),(2098,2978,41348,107263,3,2100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',37588.76,NULL,NULL,1,'2021-08-17 18:31:54','2021-08-17 18:31:54',NULL),(2099,2978,41348,107263,3,2101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',75624.17,NULL,NULL,1,'2021-08-17 18:31:54','2021-08-17 18:31:54',NULL),(2100,2978,41348,107263,3,2102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',31359.33,NULL,NULL,1,'2021-08-17 18:31:54','2021-08-17 18:31:54',NULL),(2101,2978,41348,107263,3,2103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',4326.98,NULL,NULL,1,'2021-08-17 18:31:54','2021-08-17 18:31:54',NULL),(2102,2978,41348,107263,3,2104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',67933.18,NULL,NULL,1,'2021-08-17 18:31:54','2021-08-17 18:31:54',NULL),(2103,2978,41348,107263,3,2105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',134181.63,NULL,NULL,1,'2021-08-17 18:31:54','2021-08-17 18:31:54',NULL),(2104,2978,41348,107263,3,2106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',364706.03,NULL,NULL,1,'2021-08-17 18:31:54','2021-08-17 18:31:54',NULL),(2105,2978,41348,107263,3,2107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',37831.24,NULL,NULL,1,'2021-08-17 18:31:54','2021-08-17 18:31:54',NULL),(2106,2978,41348,107264,3,2108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',6732.00,NULL,NULL,1,'2021-08-17 18:34:48','2021-08-17 18:34:48',NULL),(2107,2978,41348,107264,3,2109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',9900.00,NULL,NULL,1,'2021-08-17 18:34:48','2021-08-17 18:34:48',NULL),(2108,2978,41348,107264,3,2110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',1350.00,NULL,NULL,1,'2021-08-17 18:34:48','2021-08-17 18:34:48',NULL),(2109,2978,41348,107264,3,2111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',2643.19,NULL,NULL,1,'2021-08-17 18:34:48','2021-08-17 18:34:48',NULL);
INSERT INTO `balance_libro` VALUES (2110,2978,41348,107264,3,2112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-04','2021-04-04',10092.00,NULL,NULL,1,'2021-08-17 18:34:48','2021-08-17 18:34:48',NULL),(2111,2978,41348,107264,3,2113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',140147.54,NULL,NULL,1,'2021-08-17 18:34:48','2021-08-17 18:34:48',NULL),(2112,2978,41348,107264,3,2114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',64653.39,NULL,NULL,1,'2021-08-17 18:34:48','2021-08-17 18:34:48',NULL),(2113,2978,41348,107264,3,2115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',16784.52,NULL,NULL,1,'2021-08-17 18:34:48','2021-08-17 18:34:48',NULL),(2114,2978,41348,107264,3,2116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',5434.65,NULL,NULL,1,'2021-08-17 18:34:48','2021-08-17 18:34:48',NULL),(2115,2978,41348,107264,3,2117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',10505.52,NULL,NULL,1,'2021-08-17 18:34:48','2021-08-17 18:34:48',NULL),(2116,2978,41348,107264,3,2118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',179176.80,NULL,NULL,1,'2021-08-17 18:34:48','2021-08-17 18:34:48',NULL),(2117,2978,41348,107264,3,2119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',2578.14,NULL,NULL,1,'2021-08-17 18:34:48','2021-08-17 18:34:48',NULL),(2118,2978,41348,107264,3,2120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',5900.20,NULL,NULL,1,'2021-08-17 18:34:49','2021-08-17 18:34:49',NULL),(2119,2978,41348,107264,3,2121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',89999.98,NULL,NULL,1,'2021-08-17 18:34:49','2021-08-17 18:34:49',NULL),(2120,2978,41348,107264,3,2122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',5199.98,NULL,NULL,1,'2021-08-17 18:34:49','2021-08-17 18:34:49',NULL),(2121,2978,41348,107264,3,2123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',12000.01,NULL,NULL,1,'2021-08-17 18:34:49','2021-08-17 18:34:49',NULL),(2122,2978,41348,107264,3,2124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',18659.09,NULL,NULL,1,'2021-08-17 18:34:49','2021-08-17 18:34:49',NULL),(2123,2978,41348,107264,3,2125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',17743.57,NULL,NULL,1,'2021-08-17 18:34:49','2021-08-17 18:34:49',NULL),(2124,2978,41348,107264,3,2126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',16130.52,NULL,NULL,1,'2021-08-17 18:34:49','2021-08-17 18:34:49',NULL),(2125,2978,41348,107264,3,2127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',83.70,NULL,NULL,1,'2021-08-17 18:34:49','2021-08-17 18:34:49',NULL),(2126,2978,41348,107264,3,2128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',108802.24,NULL,NULL,1,'2021-08-17 18:34:49','2021-08-17 18:34:49',NULL),(2127,2978,41348,107264,3,2129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',8600.00,NULL,NULL,1,'2021-08-17 18:34:49','2021-08-17 18:34:49',NULL),(2128,2978,41348,107264,3,2130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',23.27,NULL,NULL,1,'2021-08-17 18:34:49','2021-08-17 18:34:49',NULL),(2129,2978,41348,107264,3,2131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',35.57,NULL,NULL,1,'2021-08-17 18:34:49','2021-08-17 18:34:49',NULL),(2130,2978,41348,107264,3,2132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',31.76,NULL,NULL,1,'2021-08-17 18:34:49','2021-08-17 18:34:49',NULL),(2131,2978,41348,107264,3,2133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',250005.41,NULL,NULL,1,'2021-08-17 18:34:49','2021-08-17 18:34:49',NULL),(2132,2978,41348,107264,3,2134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',103861.44,NULL,NULL,1,'2021-08-17 18:34:49','2021-08-17 18:34:49',NULL),(2133,2978,41348,107264,3,2135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',73121.27,NULL,NULL,1,'2021-08-17 18:34:49','2021-08-17 18:34:49',NULL);
INSERT INTO `balance_libro` VALUES (2134,2978,41348,107264,3,2136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',91389.86,NULL,NULL,1,'2021-08-17 18:34:49','2021-08-17 18:34:49',NULL),(2135,2978,41348,107264,3,2137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',40452.02,NULL,NULL,1,'2021-08-17 18:34:49','2021-08-17 18:34:49',NULL),(2136,2978,41348,107264,3,2138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',35.57,NULL,NULL,1,'2021-08-17 18:34:49','2021-08-17 18:34:49',NULL),(2137,2978,41348,107264,3,2139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',23.27,NULL,NULL,1,'2021-08-17 18:34:49','2021-08-17 18:34:49',NULL),(2138,2978,41348,107264,3,2140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',9300.48,NULL,NULL,1,'2021-08-17 18:34:49','2021-08-17 18:34:49',NULL),(2139,2978,41348,107265,3,2141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-01','2021-05-01',11220.00,NULL,NULL,1,'2021-08-17 18:43:39','2021-08-17 18:43:39',NULL),(2140,2978,41348,107265,3,2142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-01','2021-05-01',7667.00,NULL,NULL,1,'2021-08-17 18:43:39','2021-08-17 18:43:39',NULL),(2141,2978,41348,107265,3,2143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-01','2021-05-01',1649.99,NULL,NULL,1,'2021-08-17 18:43:39','2021-08-17 18:43:39',NULL),(2142,2978,41348,107265,3,2144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',2570.90,NULL,NULL,1,'2021-08-17 18:43:39','2021-08-17 18:43:39',NULL),(2143,2978,41348,107265,3,2145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',357.48,NULL,NULL,1,'2021-08-17 18:43:39','2021-08-17 18:43:39',NULL),(2144,2978,41348,107265,3,2146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',10092.00,NULL,NULL,1,'2021-08-17 18:43:39','2021-08-17 18:43:39',NULL),(2145,2978,41348,107265,3,2147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',197062.39,NULL,NULL,1,'2021-08-17 18:43:39','2021-08-17 18:43:39',NULL),(2146,2978,41348,107265,3,2148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',7311.20,NULL,NULL,1,'2021-08-17 18:43:39','2021-08-17 18:43:39',NULL),(2147,2978,41348,107265,3,2149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',10230.53,NULL,NULL,1,'2021-08-17 18:43:39','2021-08-17 18:43:39',NULL),(2148,2978,41348,107265,3,2150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',8600.00,NULL,NULL,1,'2021-08-17 18:43:40','2021-08-17 18:43:40',NULL),(2149,2978,41348,107265,3,2151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',17395.12,NULL,NULL,1,'2021-08-17 18:43:40','2021-08-17 18:43:40',NULL),(2150,2978,41348,107265,3,2152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',3266.07,NULL,NULL,1,'2021-08-17 18:43:40','2021-08-17 18:43:40',NULL),(2151,2978,41348,107265,3,2153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',5423.13,NULL,NULL,1,'2021-08-17 18:43:40','2021-08-17 18:43:40',NULL),(2152,2978,41348,107265,3,2154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',98531.19,NULL,NULL,1,'2021-08-17 18:43:40','2021-08-17 18:43:40',NULL),(2153,2978,41348,107265,3,2155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',2608.01,NULL,NULL,1,'2021-08-17 18:43:40','2021-08-17 18:43:40',NULL),(2154,2978,41348,107265,3,2156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',35138.38,NULL,NULL,1,'2021-08-17 18:43:40','2021-08-17 18:43:40',NULL),(2155,2978,41348,107265,3,2157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',13601.95,NULL,NULL,1,'2021-08-17 18:43:40','2021-08-17 18:43:40',NULL),(2156,2978,41348,107265,3,2158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',16944.31,NULL,NULL,1,'2021-08-17 18:43:40','2021-08-17 18:43:40',NULL),(2157,2978,41348,107265,3,2159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',64059.78,NULL,NULL,1,'2021-08-17 18:43:40','2021-08-17 18:43:40',NULL);
INSERT INTO `balance_libro` VALUES (2158,2978,41348,107265,3,2160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',10230.53,NULL,NULL,1,'2021-08-17 18:43:40','2021-08-17 18:43:40',NULL),(2159,2978,41348,107265,3,2161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',9798.20,NULL,NULL,1,'2021-08-17 18:43:40','2021-08-17 18:43:40',NULL),(2160,2978,41348,107265,3,2162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',8201.58,NULL,NULL,1,'2021-08-17 18:43:40','2021-08-17 18:43:40',NULL),(2161,2978,41348,107265,3,2163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',31.76,NULL,NULL,1,'2021-08-17 18:43:40','2021-08-17 18:43:40',NULL),(2162,2978,41348,107265,3,2164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',25980.64,NULL,NULL,1,'2021-08-17 18:43:40','2021-08-17 18:43:40',NULL),(2163,2978,41348,107265,3,2165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',37986.65,NULL,NULL,1,'2021-08-17 18:43:40','2021-08-17 18:43:40',NULL),(2164,2978,41348,107265,3,2166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',61106.26,NULL,NULL,1,'2021-08-17 18:43:40','2021-08-17 18:43:40',NULL),(2165,2978,41348,107265,3,2167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',56804.28,NULL,NULL,1,'2021-08-17 18:43:40','2021-08-17 18:43:40',NULL),(2166,2978,41348,107265,3,2168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',47351.65,NULL,NULL,1,'2021-08-17 18:43:40','2021-08-17 18:43:40',NULL),(2167,2978,41348,107265,3,2169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',74509.20,NULL,NULL,1,'2021-08-17 18:43:40','2021-08-17 18:43:40',NULL),(2168,2978,41348,107265,3,2170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',23071.07,NULL,NULL,1,'2021-08-17 18:43:40','2021-08-17 18:43:40',NULL),(2169,2978,41348,107265,3,2171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',147384.56,NULL,NULL,1,'2021-08-17 18:43:40','2021-08-17 18:43:40',NULL),(2170,2978,41348,107265,3,2172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',64723.10,NULL,NULL,1,'2021-08-17 18:43:40','2021-08-17 18:43:40',NULL),(2171,2978,41348,107266,3,2173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',11220.00,NULL,NULL,1,'2021-08-17 18:45:17','2021-08-17 18:45:17',NULL),(2172,2978,41348,107266,3,2174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',7667.00,NULL,NULL,1,'2021-08-17 18:45:17','2021-08-17 18:45:17',NULL),(2173,2978,41348,107266,3,2175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',3708.81,NULL,NULL,1,'2021-08-17 18:45:17','2021-08-17 18:45:17',NULL),(2174,2978,41348,107266,3,2176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',1649.99,NULL,NULL,1,'2021-08-17 18:45:17','2021-08-17 18:45:17',NULL),(2175,2978,41348,107266,3,2177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',147796.79,NULL,NULL,1,'2021-08-17 18:45:17','2021-08-17 18:45:17',NULL),(2176,2978,41348,107266,3,2178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',2936.29,NULL,NULL,1,'2021-08-17 18:45:17','2021-08-17 18:45:17',NULL),(2177,2978,41348,107266,3,2179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',27885.92,NULL,NULL,1,'2021-08-17 18:45:17','2021-08-17 18:45:17',NULL),(2178,2978,41348,107266,3,2180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',15313.10,NULL,NULL,1,'2021-08-17 18:45:17','2021-08-17 18:45:17',NULL),(2179,2978,41348,107266,3,2181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',13636.46,NULL,NULL,1,'2021-08-17 18:45:17','2021-08-17 18:45:17',NULL),(2180,2978,41348,107266,3,2182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',54897.70,NULL,NULL,1,'2021-08-17 18:45:17','2021-08-17 18:45:17',NULL),(2181,2978,41348,107266,3,2183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',128296.30,NULL,NULL,1,'2021-08-17 18:45:17','2021-08-17 18:45:17',NULL);
INSERT INTO `balance_libro` VALUES (2182,2978,41348,107266,3,2184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',68607.00,NULL,NULL,1,'2021-08-17 18:45:17','2021-08-17 18:45:17',NULL),(2183,2978,41348,107266,3,2185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',68607.00,NULL,NULL,1,'2021-08-17 18:45:17','2021-08-17 18:45:17',NULL),(2184,2978,41348,107266,3,2186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',68607.00,NULL,NULL,1,'2021-08-17 18:45:17','2021-08-17 18:45:17',NULL),(2185,2978,41348,107266,3,2187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',3371.42,NULL,NULL,1,'2021-08-17 18:45:17','2021-08-17 18:45:17',NULL),(2186,2978,41348,107266,3,2188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',2894.00,NULL,NULL,1,'2021-08-17 18:45:17','2021-08-17 18:45:17',NULL),(2187,2978,41348,107266,3,2189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',7564.06,NULL,NULL,1,'2021-08-17 18:45:17','2021-08-17 18:45:17',NULL),(2188,2978,41348,107266,3,2190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',8915.38,NULL,NULL,1,'2021-08-17 18:45:17','2021-08-17 18:45:17',NULL),(2189,2978,41348,107266,3,2191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',30626.19,NULL,NULL,1,'2021-08-17 18:45:17','2021-08-17 18:45:17',NULL),(2190,2978,41348,107266,3,2192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2924.06,NULL,NULL,1,'2021-08-17 18:45:17','2021-08-17 18:45:17',NULL),(2191,2978,41348,107266,3,2193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',113845.00,NULL,NULL,1,'2021-08-17 18:45:17','2021-08-17 18:45:17',NULL),(2192,2978,41348,107266,3,2194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',3369.41,NULL,NULL,1,'2021-08-17 18:45:17','2021-08-17 18:45:17',NULL),(2193,2978,41348,107266,3,2195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',2328.59,NULL,NULL,1,'2021-08-17 18:45:17','2021-08-17 18:45:17',NULL),(2194,2978,41348,107266,3,2196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',107.08,NULL,NULL,1,'2021-08-17 18:45:17','2021-08-17 18:45:17',NULL),(2195,2978,41348,107266,3,2197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',1040.00,NULL,NULL,1,'2021-08-17 18:45:17','2021-08-17 18:45:17',NULL),(2196,2978,41348,107266,3,2198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',70134.44,NULL,NULL,1,'2021-08-17 18:45:17','2021-08-17 18:45:17',NULL),(2197,2978,41348,107266,3,2199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',71230.00,NULL,NULL,1,'2021-08-17 18:45:18','2021-08-17 18:45:18',NULL),(2198,2978,41348,107266,3,2200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',152496.30,NULL,NULL,1,'2021-08-17 18:45:18','2021-08-17 18:45:18',NULL),(2199,2978,41348,107266,3,2201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',84118.48,NULL,NULL,1,'2021-08-17 18:45:18','2021-08-17 18:45:18',NULL),(2200,2978,41348,107266,3,2202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',5841.86,NULL,NULL,1,'2021-08-17 18:45:18','2021-08-17 18:45:18',NULL),(2201,2978,41348,107266,3,2203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',16954.00,NULL,NULL,1,'2021-08-17 18:45:18','2021-08-17 18:45:18',NULL),(2202,2978,41348,107266,3,2204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',900.00,NULL,NULL,1,'2021-08-17 18:45:18','2021-08-17 18:45:18',NULL),(2203,2978,41348,107266,3,2205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',54749.02,NULL,NULL,1,'2021-08-17 18:45:18','2021-08-17 18:45:18',NULL),(2204,2978,41348,107266,3,2206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',130422.74,NULL,NULL,1,'2021-08-17 18:45:18','2021-08-17 18:45:18',NULL),(2205,2978,41348,107266,3,2207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',64885.45,NULL,NULL,1,'2021-08-17 18:45:18','2021-08-17 18:45:18',NULL);
INSERT INTO `balance_libro` VALUES (2206,2978,41348,107266,3,2208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',5841.86,NULL,NULL,1,'2021-08-17 18:45:18','2021-08-17 18:45:18',NULL),(2207,2978,41348,107266,3,2209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',1314.74,NULL,NULL,1,'2021-08-17 18:45:18','2021-08-17 18:45:18',NULL),(2208,2978,41348,107266,3,2210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',97246.24,NULL,NULL,1,'2021-08-17 18:45:18','2021-08-17 18:45:18',NULL),(2209,2978,41348,107266,3,2211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',74212.74,NULL,NULL,1,'2021-08-17 18:45:18','2021-08-17 18:45:18',NULL),(2210,2978,41348,107266,3,2212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',90990.89,NULL,NULL,1,'2021-08-17 18:45:18','2021-08-17 18:45:18',NULL),(2211,2978,41348,107266,3,2213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',94430.00,NULL,NULL,1,'2021-08-17 18:45:18','2021-08-17 18:45:18',NULL),(2212,2978,41348,107266,3,2214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',95267.66,NULL,NULL,1,'2021-08-17 18:45:18','2021-08-17 18:45:18',NULL),(2213,2978,41348,107266,3,2215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',5841.86,NULL,NULL,1,'2021-08-17 18:45:18','2021-08-17 18:45:18',NULL),(2214,2978,41348,107266,3,2216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',80000.00,NULL,NULL,1,'2021-08-17 18:45:18','2021-08-17 18:45:18',NULL),(2215,2978,41348,107266,3,2217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',151404.96,NULL,NULL,1,'2021-08-17 18:45:18','2021-08-17 18:45:18',NULL),(2216,2978,41348,107266,3,2218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',8600.00,NULL,NULL,1,'2021-08-17 18:45:18','2021-08-17 18:45:18',NULL),(2217,2978,41348,107266,3,2219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',300273.60,NULL,NULL,1,'2021-08-17 18:45:18','2021-08-17 18:45:18',NULL),(2218,2978,41348,107267,3,2220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',7667.00,NULL,NULL,1,'2021-08-17 18:52:44','2021-08-17 18:52:44',NULL),(2219,2978,41348,107267,3,2221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',11220.00,NULL,NULL,1,'2021-08-17 18:52:44','2021-08-17 18:52:44',NULL),(2220,2978,41348,107267,3,2222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',1699.99,NULL,NULL,1,'2021-08-17 18:52:44','2021-08-17 18:52:44',NULL),(2221,2978,41348,107267,3,2223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',3235.92,NULL,NULL,1,'2021-08-17 18:52:44','2021-08-17 18:52:44',NULL),(2222,2978,41348,107267,3,2224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',1450.06,NULL,NULL,1,'2021-08-17 18:52:44','2021-08-17 18:52:44',NULL),(2223,2978,41348,107267,3,2225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',86307.99,NULL,NULL,1,'2021-08-17 18:52:44','2021-08-17 18:52:44',NULL),(2224,2978,41348,107267,3,2226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',38470.74,NULL,NULL,1,'2021-08-17 18:52:44','2021-08-17 18:52:44',NULL),(2225,2978,41348,107267,3,2227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',3402.25,NULL,NULL,1,'2021-08-17 18:52:44','2021-08-17 18:52:44',NULL),(2226,2978,41348,107267,3,2228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',40765.31,NULL,NULL,1,'2021-08-17 18:52:44','2021-08-17 18:52:44',NULL),(2227,2978,41348,107267,3,2229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',5098.49,NULL,NULL,1,'2021-08-17 18:52:44','2021-08-17 18:52:44',NULL),(2228,2978,41348,107267,3,2230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',6552.72,NULL,NULL,1,'2021-08-17 18:52:44','2021-08-17 18:52:44',NULL),(2229,2978,41348,107267,3,2231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',102502.29,NULL,NULL,1,'2021-08-17 18:52:45','2021-08-17 18:52:45',NULL);
INSERT INTO `balance_libro` VALUES (2230,2978,41348,107267,3,2232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',14407.47,NULL,NULL,1,'2021-08-17 18:52:45','2021-08-17 18:52:45',NULL),(2231,2978,41348,107267,3,2233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',18120.96,NULL,NULL,1,'2021-08-17 18:52:45','2021-08-17 18:52:45',NULL),(2232,2978,41348,107267,3,2234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',37056.45,NULL,NULL,1,'2021-08-17 18:52:45','2021-08-17 18:52:45',NULL),(2233,2978,41348,107267,3,2235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',1770.00,NULL,NULL,1,'2021-08-17 18:52:45','2021-08-17 18:52:45',NULL),(2234,2978,41348,107267,3,2236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',1636.16,NULL,NULL,1,'2021-08-17 18:52:45','2021-08-17 18:52:45',NULL),(2235,2978,41348,107267,3,2237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',29499.80,NULL,NULL,1,'2021-08-17 18:52:45','2021-08-17 18:52:45',NULL),(2236,2978,41348,107267,3,2238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',16886.18,NULL,NULL,1,'2021-08-17 18:52:45','2021-08-17 18:52:45',NULL),(2237,2978,41348,107267,3,2239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',48840.33,NULL,NULL,1,'2021-08-17 18:52:45','2021-08-17 18:52:45',NULL),(2238,2978,41348,107267,3,2240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',512.30,NULL,NULL,1,'2021-08-17 18:52:45','2021-08-17 18:52:45',NULL),(2239,2978,41348,107267,3,2241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',8730.10,NULL,NULL,1,'2021-08-17 18:52:45','2021-08-17 18:52:45',NULL),(2240,2978,41348,107267,3,2242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',2961.08,NULL,NULL,1,'2021-08-17 18:52:45','2021-08-17 18:52:45',NULL),(2241,2978,41348,107267,3,2243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',9179.38,NULL,NULL,1,'2021-08-17 18:52:45','2021-08-17 18:52:45',NULL),(2242,2978,41348,107267,3,2244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',54200.00,NULL,NULL,1,'2021-08-17 18:52:45','2021-08-17 18:52:45',NULL),(2243,2978,41348,107267,3,2245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',114050.00,NULL,NULL,1,'2021-08-17 18:52:45','2021-08-17 18:52:45',NULL),(2244,2978,41348,107267,3,2246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',138707.14,NULL,NULL,1,'2021-08-17 18:52:45','2021-08-17 18:52:45',NULL),(2245,2978,41348,107267,3,2247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',12119.36,NULL,NULL,1,'2021-08-17 18:52:45','2021-08-17 18:52:45',NULL),(2246,2978,41348,107267,3,2248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',7130.77,NULL,NULL,1,'2021-08-17 18:52:45','2021-08-17 18:52:45',NULL),(2247,2978,41348,107267,3,2249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',8600.00,NULL,NULL,1,'2021-08-17 18:52:45','2021-08-17 18:52:45',NULL),(2248,2978,41348,107267,3,2250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',3909.78,NULL,NULL,1,'2021-08-17 18:52:45','2021-08-17 18:52:45',NULL),(2249,2978,41348,107267,3,2251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',2501.13,NULL,NULL,1,'2021-08-17 18:52:45','2021-08-17 18:52:45',NULL),(2250,2978,41348,107267,3,2252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',1088.69,NULL,NULL,1,'2021-08-17 18:52:45','2021-08-17 18:52:45',NULL),(2251,2978,41348,107267,3,2253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',5800.74,NULL,NULL,1,'2021-08-17 18:52:45','2021-08-17 18:52:45',NULL),(2252,2978,41348,107267,3,2254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',49432.05,NULL,NULL,1,'2021-08-17 18:52:45','2021-08-17 18:52:45',NULL),(2253,2978,41348,107267,3,2255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',85209.11,NULL,NULL,1,'2021-08-17 18:52:45','2021-08-17 18:52:45',NULL);
INSERT INTO `balance_libro` VALUES (2254,2978,41348,107267,3,2256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',6828.49,NULL,NULL,1,'2021-08-17 18:52:45','2021-08-17 18:52:45',NULL),(2255,2978,41348,107267,3,2257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',5628.73,NULL,NULL,1,'2021-08-17 18:52:45','2021-08-17 18:52:45',NULL),(2256,2978,41348,107267,3,2258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',93247.00,NULL,NULL,1,'2021-08-17 18:52:45','2021-08-17 18:52:45',NULL),(2257,2978,41348,107267,3,2259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',41804.93,NULL,NULL,1,'2021-08-17 18:52:45','2021-08-17 18:52:45',NULL),(2258,2978,41348,107267,3,2260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',66012.22,NULL,NULL,1,'2021-08-17 18:52:45','2021-08-17 18:52:45',NULL),(2259,2978,41348,107267,3,2261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',11059.99,NULL,NULL,1,'2021-08-17 18:52:46','2021-08-17 18:52:46',NULL),(2260,2978,41348,107267,3,2262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',55902.00,NULL,NULL,1,'2021-08-17 18:52:46','2021-08-17 18:52:46',NULL),(2261,2978,41348,107267,3,2263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',108977.10,NULL,NULL,1,'2021-08-17 18:52:46','2021-08-17 18:52:46',NULL),(2262,2978,41348,107267,3,2264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',53050.52,NULL,NULL,1,'2021-08-17 18:52:46','2021-08-17 18:52:46',NULL),(2263,2978,41348,107267,3,2265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',94512.86,NULL,NULL,1,'2021-08-17 18:52:46','2021-08-17 18:52:46',NULL),(2264,2978,41348,107255,2,2266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-22','2020-10-22',1300.00,NULL,NULL,1,'2021-08-17 19:06:48','2021-08-17 19:06:48',NULL),(2265,2978,41348,107257,2,2267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-23','2020-12-23',1100.00,NULL,NULL,1,'2021-08-17 19:10:05','2021-08-17 19:10:05',NULL),(2266,2978,41348,107263,2,2268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',6150.01,NULL,NULL,1,'2021-08-17 19:11:23','2021-08-17 19:11:23',NULL),(2267,2978,41348,107263,2,2269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',18337.50,NULL,NULL,1,'2021-08-17 19:11:23','2021-08-17 19:11:23',NULL),(2268,2978,41348,107263,2,2270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',18337.50,NULL,NULL,1,'2021-08-17 19:11:23','2021-08-17 19:11:23',NULL),(2269,2978,41348,107263,2,2271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',21500.00,NULL,NULL,1,'2021-08-17 19:11:23','2021-08-17 19:11:23',NULL),(2270,2978,41348,107263,2,2272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',21500.00,NULL,NULL,1,'2021-08-17 19:11:23','2021-08-17 19:11:23',NULL),(2271,2978,40874,71606,2,2273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-01','2020-06-01',11500.00,NULL,NULL,1,'2021-08-18 12:15:19','2021-08-18 12:15:19',NULL),(2272,2978,40874,71606,2,2274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-19','2020-06-19',9900.00,NULL,NULL,1,'2021-08-18 12:15:19','2021-08-18 12:15:19',NULL),(2273,2978,40874,71607,2,2275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-03','2020-07-03',11500.00,NULL,NULL,1,'2021-08-18 12:17:48','2021-08-18 12:17:48',NULL),(2274,2978,40874,71607,2,2276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-07','2020-07-07',11950.00,NULL,NULL,1,'2021-08-18 12:17:48','2021-08-18 12:17:48',NULL),(2275,2978,40874,71607,2,2277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-15','2020-07-15',20000.00,NULL,NULL,1,'2021-08-18 12:17:48','2021-08-18 12:17:48',NULL),(2276,2978,40874,71607,2,2278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-29','2020-07-29',7000.00,NULL,NULL,1,'2021-08-18 12:17:48','2021-08-18 12:17:48',NULL),(2277,2978,40874,71607,2,2279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-29','2020-07-29',18900.00,NULL,NULL,1,'2021-08-18 12:17:48','2021-08-18 12:17:48',NULL);
INSERT INTO `balance_libro` VALUES (2278,2978,40874,71607,2,2280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-29','2020-07-29',5900.00,NULL,NULL,1,'2021-08-18 12:17:48','2021-08-18 12:17:48',NULL),(2279,2978,40874,71607,2,2281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-30','2020-07-30',300.00,NULL,NULL,1,'2021-08-18 12:17:48','2021-08-18 12:17:48',NULL),(2280,2978,40874,71608,2,2282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-20','2020-08-20',4000.00,NULL,NULL,1,'2021-08-18 12:18:55','2021-08-18 12:18:55',NULL),(2281,2978,40874,71608,2,2283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-20','2020-08-20',41600.00,NULL,NULL,1,'2021-08-18 12:18:55','2021-08-18 12:18:55',NULL),(2282,2978,40874,71608,2,2284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-20','2020-08-20',11200.00,NULL,NULL,1,'2021-08-18 12:18:55','2021-08-18 12:18:55',NULL),(2283,2978,40874,71608,2,2285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-20','2020-08-20',24300.00,NULL,NULL,1,'2021-08-18 12:18:55','2021-08-18 12:18:55',NULL),(2284,2978,40874,71608,2,2286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-20','2020-08-20',4000.00,NULL,NULL,1,'2021-08-18 12:18:55','2021-08-18 12:18:55',NULL),(2285,2978,40874,71609,2,2287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-11','2020-09-11',9000.00,NULL,NULL,1,'2021-08-18 12:20:09','2021-08-18 12:20:09',NULL),(2286,2978,40874,71609,2,2288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-24','2020-09-24',111000.00,NULL,NULL,1,'2021-08-18 12:20:09','2021-08-18 12:20:09',NULL),(2287,2978,40874,71609,2,2289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-24','2020-09-24',21600.00,NULL,NULL,1,'2021-08-18 12:20:09','2021-08-18 12:20:09',NULL),(2288,2978,40874,71611,2,2290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-05','2020-11-05',14300.00,NULL,NULL,1,'2021-08-18 12:22:35','2021-08-18 12:22:35',NULL),(2289,2978,40874,42465,2,2291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',25920.00,NULL,NULL,1,'2021-08-18 12:24:52','2021-08-18 12:24:52',NULL),(2290,2978,40874,42465,2,2292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',109280.00,NULL,NULL,1,'2021-08-18 12:24:52','2021-08-18 12:24:52',NULL),(2291,2978,40874,42465,2,2293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',54830.00,NULL,NULL,1,'2021-08-18 12:24:52','2021-08-18 12:24:52',NULL),(2292,2978,40874,42465,2,2294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',6500.00,NULL,NULL,1,'2021-08-18 12:24:52','2021-08-18 12:24:52',NULL),(2293,2978,40874,42465,2,2295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',63240.00,NULL,NULL,1,'2021-08-18 12:24:52','2021-08-18 12:24:52',NULL),(2294,2978,40874,42465,2,2296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',11200.00,NULL,NULL,1,'2021-08-18 12:24:52','2021-08-18 12:24:52',NULL),(2295,2978,40874,42465,2,2297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',16500.00,NULL,NULL,1,'2021-08-18 12:24:52','2021-08-18 12:24:52',NULL),(2296,2978,40720,1535,3,2298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',650.00,NULL,NULL,1,'2021-08-19 18:40:54','2021-08-19 18:40:54',NULL),(2297,2978,40720,1535,3,2299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',1880.00,NULL,NULL,1,'2021-08-19 18:40:55','2021-08-19 18:40:55',NULL),(2298,2978,40720,1530,3,2300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-03','2021-01-03',400.00,NULL,NULL,1,'2021-08-19 18:59:53','2021-08-19 18:59:53',NULL),(2299,2978,40720,1530,3,2301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',18525.71,NULL,NULL,1,'2021-08-19 18:59:53','2021-08-19 18:59:53',NULL),(2300,2978,40720,1530,3,2302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',680.00,NULL,NULL,1,'2021-08-19 18:59:53','2021-08-19 18:59:53',NULL),(2301,2978,40720,1530,3,2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',4999.00,NULL,NULL,1,'2021-08-19 18:59:53','2021-08-19 18:59:53',NULL);
INSERT INTO `balance_libro` VALUES (2302,2978,40720,1531,3,2304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-07','2021-02-07',500.00,NULL,NULL,1,'2021-08-19 19:02:40','2021-08-19 19:02:40',NULL),(2303,2978,40720,1532,3,2305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',500.00,NULL,NULL,1,'2021-08-19 19:03:37','2021-08-19 19:03:37',NULL),(2304,2978,40720,1532,3,2306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',3030.00,NULL,NULL,1,'2021-08-19 19:03:37','2021-08-19 19:03:37',NULL),(2305,2978,40720,1533,3,2307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',4250.00,NULL,NULL,1,'2021-08-19 19:05:38','2021-08-19 19:05:38',NULL),(2306,2978,40720,1533,3,2308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',2540.58,NULL,NULL,1,'2021-08-19 19:05:38','2021-08-19 19:05:38',NULL),(2307,2978,40720,1533,3,2309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',2540.58,NULL,NULL,1,'2021-08-19 19:05:38','2021-08-19 19:05:38',NULL),(2308,2978,40720,1533,3,2310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',500.00,NULL,NULL,1,'2021-08-19 19:05:38','2021-08-19 19:05:38',NULL),(2309,2978,40720,1534,3,2311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',650.00,NULL,NULL,1,'2021-08-19 19:06:40','2021-08-19 19:06:40',NULL),(2310,2978,40720,1534,3,2312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',2540.58,NULL,NULL,1,'2021-08-19 19:06:40','2021-08-19 19:06:40',NULL),(2311,2978,40720,1534,3,2313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',4392.00,NULL,NULL,1,'2021-08-19 19:06:40','2021-08-19 19:06:40',NULL),(2312,2978,40720,1536,3,2314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',2770.00,NULL,NULL,1,'2021-08-19 19:10:15','2021-08-19 19:10:15',NULL),(2313,2978,40720,1536,3,2315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',6195.10,NULL,NULL,1,'2021-08-19 19:10:16','2021-08-19 19:10:16',NULL),(2314,2978,40720,1536,3,2316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',8685.69,NULL,NULL,1,'2021-08-19 19:10:16','2021-08-19 19:10:16',NULL),(2315,2978,40720,1536,3,2317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',10490.00,NULL,NULL,1,'2021-08-19 19:10:16','2021-08-19 19:10:16',NULL),(2316,2978,40720,1536,3,2318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',4390.00,NULL,NULL,1,'2021-08-19 19:10:16','2021-08-19 19:10:16',NULL),(2317,2978,40720,1536,3,2319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',650.00,NULL,NULL,1,'2021-08-19 19:10:16','2021-08-19 19:10:16',NULL),(2318,2978,40874,42464,2,457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',100000.00,NULL,NULL,1,'2021-08-20 11:07:19','2021-08-20 11:14:30','2021-08-20 11:14:30'),(2319,2978,40874,42463,2,457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',100000.00,NULL,NULL,1,'2021-08-20 11:14:30','2021-08-20 11:14:30',NULL),(2320,2978,40721,4578,3,2320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-01','2020-07-01',3617.90,NULL,NULL,1,'2021-08-20 13:08:10','2021-08-20 13:08:10',NULL),(2321,2978,40721,4578,3,2321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-01','2020-07-01',12962.72,NULL,NULL,1,'2021-08-20 13:08:10','2021-08-20 13:08:10',NULL),(2322,2978,40721,4578,3,2322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-27','2020-07-27',10214.76,NULL,NULL,1,'2021-08-20 13:08:10','2021-08-20 13:08:10',NULL),(2323,2978,40721,4578,3,2323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',4870.00,NULL,NULL,1,'2021-08-20 13:08:10','2021-08-20 13:08:10',NULL),(2324,2978,40721,4578,3,2324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',2800.00,NULL,NULL,1,'2021-08-20 13:08:10','2021-08-20 13:08:10',NULL),(2325,2978,40721,4579,3,2325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-01','2020-08-01',4580.00,NULL,NULL,1,'2021-08-20 13:13:17','2021-08-20 13:13:17',NULL);
INSERT INTO `balance_libro` VALUES (2326,2978,40721,4579,3,2326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-04','2020-08-04',3617.90,NULL,NULL,1,'2021-08-20 13:13:17','2021-08-20 13:13:17',NULL),(2327,2978,40721,4579,3,2327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-05','2020-08-05',29355.60,NULL,NULL,1,'2021-08-20 13:13:17','2021-08-20 13:13:17',NULL),(2328,2978,40721,4579,3,2328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-11','2020-08-11',6610.00,NULL,NULL,1,'2021-08-20 13:13:17','2021-08-20 13:13:17',NULL),(2329,2978,40721,4579,3,2329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-16','2020-08-16',9489.80,NULL,NULL,1,'2021-08-20 13:13:17','2021-08-20 13:13:17',NULL),(2330,2978,40721,4579,3,2330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-19','2020-08-19',14448.29,NULL,NULL,1,'2021-08-20 13:13:17','2021-08-20 13:13:17',NULL),(2331,2978,40721,4579,3,2331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-20','2020-08-20',5000.00,NULL,NULL,1,'2021-08-20 13:13:17','2021-08-20 13:13:17',NULL),(2332,2978,40721,4579,3,2332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-21','2020-08-21',1000.00,NULL,NULL,1,'2021-08-20 13:13:17','2021-08-20 13:13:17',NULL),(2333,2978,40721,4579,3,2333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-29','2020-08-29',1050.00,NULL,NULL,1,'2021-08-20 13:13:17','2021-08-20 13:13:17',NULL),(2334,2978,40721,4579,3,2334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',5760.00,NULL,NULL,1,'2021-08-20 13:13:17','2021-08-20 13:13:17',NULL),(2335,2978,40721,4580,3,2335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-01','2020-09-01',4598.00,NULL,NULL,1,'2021-08-20 13:16:06','2021-08-20 13:16:06',NULL),(2336,2978,40721,4580,3,2336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-01','2020-09-01',14957.53,NULL,NULL,1,'2021-08-20 13:16:06','2021-08-20 13:16:06',NULL),(2337,2978,40721,4580,3,2337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-03','2020-09-03',2600.00,NULL,NULL,1,'2021-08-20 13:16:06','2021-08-20 13:16:06',NULL),(2338,2978,40721,4580,3,2338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-09','2020-09-09',8190.00,NULL,NULL,1,'2021-08-20 13:16:06','2021-08-20 13:16:06',NULL),(2339,2978,40721,4580,3,2339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-09','2020-09-09',19858.20,NULL,NULL,1,'2021-08-20 13:16:06','2021-08-20 13:16:06',NULL),(2340,2978,40721,4580,3,2340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-16','2020-09-16',9442.51,NULL,NULL,1,'2021-08-20 13:16:06','2021-08-20 13:16:06',NULL),(2341,2978,40721,4580,3,2341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-29','2020-09-29',4600.00,NULL,NULL,1,'2021-08-20 13:16:06','2021-08-20 13:16:06',NULL),(2342,2978,40721,4580,3,2342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1075.00,NULL,NULL,1,'2021-08-20 13:16:07','2021-08-20 13:16:07',NULL),(2343,2978,40721,4580,3,2343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',709.90,NULL,NULL,1,'2021-08-20 13:16:07','2021-08-20 13:16:07',NULL),(2344,2978,40721,4580,3,2344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1275.12,NULL,NULL,1,'2021-08-20 13:16:07','2021-08-20 13:16:07',NULL),(2345,2978,40721,4581,3,2345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-01','2020-10-01',13520.00,NULL,NULL,1,'2021-08-20 13:17:00','2021-08-20 13:17:00',NULL),(2346,2978,40721,4581,3,2346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-01','2020-10-01',4222.90,NULL,NULL,1,'2021-08-20 13:17:00','2021-08-20 13:17:00',NULL),(2347,2978,40721,4581,3,2347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-01','2020-10-01',6416.46,NULL,NULL,1,'2021-08-20 13:17:00','2021-08-20 13:17:00',NULL),(2348,2978,40721,4581,3,2348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-18','2020-10-18',5859.86,NULL,NULL,1,'2021-08-20 13:17:00','2021-08-20 13:17:00',NULL),(2349,2978,40721,4581,3,2349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-20','2020-10-20',15863.65,NULL,NULL,1,'2021-08-20 13:17:00','2021-08-20 13:17:00',NULL);
INSERT INTO `balance_libro` VALUES (2350,2978,40721,4581,3,2350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-26','2020-10-26',5250.00,NULL,NULL,1,'2021-08-20 13:17:00','2021-08-20 13:17:00',NULL),(2351,2978,40721,4581,3,2351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',265.50,NULL,NULL,1,'2021-08-20 13:17:00','2021-08-20 13:17:00',NULL),(2352,2978,40721,4581,3,2352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',818.49,NULL,NULL,1,'2021-08-20 13:17:00','2021-08-20 13:17:00',NULL),(2353,2978,40721,4581,3,2353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',2330.30,NULL,NULL,1,'2021-08-20 13:17:00','2021-08-20 13:17:00',NULL),(2354,2978,40721,4582,3,2354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-01','2020-11-01',4222.90,NULL,NULL,1,'2021-08-20 14:00:07','2021-08-20 14:00:07',NULL),(2355,2978,40721,4582,3,2355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-04','2020-11-04',6024.39,NULL,NULL,1,'2021-08-20 14:00:07','2021-08-20 14:00:07',NULL),(2356,2978,40721,4582,3,2356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-16','2020-11-16',10069.76,NULL,NULL,1,'2021-08-20 14:00:07','2021-08-20 14:00:07',NULL),(2357,2978,40721,4582,3,2357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-16','2020-11-16',12583.37,NULL,NULL,1,'2021-08-20 14:00:07','2021-08-20 14:00:07',NULL),(2358,2978,40721,4582,3,2358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',203.00,NULL,NULL,1,'2021-08-20 14:00:07','2021-08-20 14:00:07',NULL),(2359,2978,40721,4582,3,2359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',1635.00,NULL,NULL,1,'2021-08-20 14:00:07','2021-08-20 14:00:07',NULL),(2360,2978,40721,4582,3,2360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',3500.00,NULL,NULL,1,'2021-08-20 14:00:07','2021-08-20 14:00:07',NULL),(2361,2978,40721,4582,3,2361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',2037.45,NULL,NULL,1,'2021-08-20 14:00:07','2021-08-20 14:00:07',NULL),(2362,2978,40721,4582,3,2362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',1440.47,NULL,NULL,1,'2021-08-20 14:00:07','2021-08-20 14:00:07',NULL),(2363,2978,40721,4582,3,2363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',1440.47,NULL,NULL,1,'2021-08-20 14:00:07','2021-08-20 14:00:07',NULL),(2364,2978,40721,4582,3,2364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',2037.45,NULL,NULL,1,'2021-08-20 14:00:07','2021-08-20 14:00:07',NULL),(2365,2978,40721,4582,3,2365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',470.88,NULL,NULL,1,'2021-08-20 14:00:07','2021-08-20 14:00:07',NULL),(2366,2978,40721,4582,3,2366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',470.88,NULL,NULL,1,'2021-08-20 14:00:07','2021-08-20 14:00:07',NULL),(2367,2978,40721,4583,3,2367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-01','2020-12-01',5311.90,NULL,NULL,1,'2021-08-20 14:03:10','2021-08-20 14:03:10',NULL),(2368,2978,40721,4583,3,2368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-03','2020-12-03',2975.00,NULL,NULL,1,'2021-08-20 14:03:10','2021-08-20 14:03:10',NULL),(2369,2978,40721,4583,3,2369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',1440.47,NULL,NULL,1,'2021-08-20 14:03:10','2021-08-20 14:03:10',NULL),(2370,2978,40721,4583,3,2370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',470.88,NULL,NULL,1,'2021-08-20 14:03:10','2021-08-20 14:03:10',NULL),(2371,2978,40721,4583,3,2371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-09','2020-12-09',2037.45,NULL,NULL,1,'2021-08-20 14:03:10','2021-08-20 14:03:10',NULL),(2372,2978,40721,4583,3,2372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-13','2020-12-13',5215.08,NULL,NULL,1,'2021-08-20 14:03:10','2021-08-20 14:03:10',NULL),(2373,2978,40721,4583,3,2373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-16','2020-12-16',5449.87,NULL,NULL,1,'2021-08-20 14:03:10','2021-08-20 14:03:10',NULL);
INSERT INTO `balance_libro` VALUES (2374,2978,40721,4583,3,2374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-16','2020-12-16',4798.46,NULL,NULL,1,'2021-08-20 14:03:10','2021-08-20 14:03:10',NULL),(2375,2978,40721,4583,3,2375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-20','2020-12-20',13555.45,NULL,NULL,1,'2021-08-20 14:03:10','2021-08-20 14:03:10',NULL),(2376,2978,40721,4583,3,2376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',679.95,NULL,NULL,1,'2021-08-20 14:03:10','2021-08-20 14:03:10',NULL),(2377,2978,40721,4583,3,2377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',1306.73,NULL,NULL,1,'2021-08-20 14:03:10','2021-08-20 14:03:10',NULL),(2378,2978,40721,3042,3,2378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-01','2021-01-01',4706.90,NULL,NULL,1,'2021-08-20 14:04:50','2021-08-20 14:04:50',NULL),(2379,2978,40721,3042,3,2379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-01','2021-01-01',4560.53,NULL,NULL,1,'2021-08-20 14:04:50','2021-08-20 14:04:50',NULL),(2380,2978,40721,3042,3,2380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',4798.46,NULL,NULL,1,'2021-08-20 14:04:51','2021-08-20 14:04:51',NULL),(2381,2978,40721,3042,3,2381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-16','2021-01-16',2869.93,NULL,NULL,1,'2021-08-20 14:04:51','2021-08-20 14:04:51',NULL),(2382,2978,40721,3042,3,2382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',11576.85,NULL,NULL,1,'2021-08-20 14:04:51','2021-08-20 14:04:51',NULL),(2383,2978,40721,3042,3,2383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',1960.00,NULL,NULL,1,'2021-08-20 14:04:51','2021-08-20 14:04:51',NULL),(2384,2978,40721,3042,3,2384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',49.31,NULL,NULL,1,'2021-08-20 14:04:51','2021-08-20 14:04:51',NULL),(2385,2978,40721,3042,3,2385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',810.41,NULL,NULL,1,'2021-08-20 14:04:51','2021-08-20 14:04:51',NULL),(2386,2978,40721,3043,3,2386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',4767.65,NULL,NULL,1,'2021-08-20 14:07:46','2021-08-20 14:07:46',NULL),(2387,2978,40721,3043,3,2387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',4798.46,NULL,NULL,1,'2021-08-20 14:07:46','2021-08-20 14:07:46',NULL),(2388,2978,40721,3043,3,2388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',4706.90,NULL,NULL,1,'2021-08-20 14:07:46','2021-08-20 14:07:46',NULL),(2389,2978,40721,3043,3,2389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',3969.00,NULL,NULL,1,'2021-08-20 14:07:46','2021-08-20 14:07:46',NULL),(2390,2978,40721,3043,3,2390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',2547.44,NULL,NULL,1,'2021-08-20 14:07:46','2021-08-20 14:07:46',NULL),(2391,2978,40721,3043,3,2391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',18801.75,NULL,NULL,1,'2021-08-20 14:07:46','2021-08-20 14:07:46',NULL),(2392,2978,40721,3043,3,2392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',10800.00,NULL,NULL,1,'2021-08-20 14:07:47','2021-08-20 14:07:47',NULL),(2393,2978,40721,3043,3,2393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',42.78,NULL,NULL,1,'2021-08-20 14:07:47','2021-08-20 14:07:47',NULL),(2394,2978,40721,3043,3,2394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',511.74,NULL,NULL,1,'2021-08-20 14:07:47','2021-08-20 14:07:47',NULL),(2395,2978,40721,3044,3,2395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',4706.90,NULL,NULL,1,'2021-08-20 14:08:29','2021-08-20 14:08:29',NULL),(2396,2978,40721,3044,3,2396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',6411.88,NULL,NULL,1,'2021-08-20 14:08:29','2021-08-20 14:08:29',NULL),(2397,2978,40721,3044,3,2397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',4965.87,NULL,NULL,1,'2021-08-20 14:08:29','2021-08-20 14:08:29',NULL);
INSERT INTO `balance_libro` VALUES (2398,2978,40721,3044,3,2398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',830.00,NULL,NULL,1,'2021-08-20 14:08:29','2021-08-20 14:08:29',NULL),(2399,2978,40721,3044,3,2399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',800.00,NULL,NULL,1,'2021-08-20 14:08:29','2021-08-20 14:08:29',NULL),(2400,2978,40721,3044,3,2400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',560.00,NULL,NULL,1,'2021-08-20 14:08:29','2021-08-20 14:08:29',NULL),(2401,2978,40721,3044,3,2401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',270.00,NULL,NULL,1,'2021-08-20 14:08:29','2021-08-20 14:08:29',NULL),(2402,2978,40721,3044,3,2402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',7019.87,NULL,NULL,1,'2021-08-20 14:08:29','2021-08-20 14:08:29',NULL),(2403,2978,40721,3044,3,2403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',9722.51,NULL,NULL,1,'2021-08-20 14:08:29','2021-08-20 14:08:29',NULL),(2404,2978,40721,3044,3,2404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',480.00,NULL,NULL,1,'2021-08-20 14:08:29','2021-08-20 14:08:29',NULL),(2405,2978,40721,3045,3,2405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',3158.10,NULL,NULL,1,'2021-08-20 14:09:18','2021-08-20 14:09:18',NULL),(2406,2978,40721,3045,3,2406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',1165.39,NULL,NULL,1,'2021-08-20 14:09:19','2021-08-20 14:09:19',NULL),(2407,2978,40721,3045,3,2407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',1637.36,NULL,NULL,1,'2021-08-20 14:09:19','2021-08-20 14:09:19',NULL),(2408,2978,40721,3045,3,2408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-04','2021-04-04',3090.68,NULL,NULL,1,'2021-08-20 14:09:19','2021-08-20 14:09:19',NULL),(2409,2978,40721,3045,3,2409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',4965.87,NULL,NULL,1,'2021-08-20 14:09:19','2021-08-20 14:09:19',NULL),(2410,2978,40721,3045,3,2410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',179.37,NULL,NULL,1,'2021-08-20 14:09:19','2021-08-20 14:09:19',NULL),(2411,2978,40721,3045,3,2411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',373.67,NULL,NULL,1,'2021-08-20 14:09:19','2021-08-20 14:09:19',NULL),(2412,2978,40721,3045,3,2412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',4610.00,NULL,NULL,1,'2021-08-20 14:09:19','2021-08-20 14:09:19',NULL),(2413,2978,40721,3045,3,2413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',800.00,NULL,NULL,1,'2021-08-20 14:09:19','2021-08-20 14:09:19',NULL),(2414,2978,40721,3045,3,2414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',439.86,NULL,NULL,1,'2021-08-20 14:09:19','2021-08-20 14:09:19',NULL),(2415,2978,40721,3045,3,2415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',4895.15,NULL,NULL,1,'2021-08-20 14:09:19','2021-08-20 14:09:19',NULL),(2416,2978,40721,3045,3,2416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',6299.58,NULL,NULL,1,'2021-08-20 14:09:19','2021-08-20 14:09:19',NULL),(2417,2978,40721,3046,3,2417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-01','2021-05-01',3158.10,NULL,NULL,1,'2021-08-20 14:09:58','2021-08-20 14:09:58',NULL),(2418,2978,40721,3046,3,2418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',5699.32,NULL,NULL,1,'2021-08-20 14:09:58','2021-08-20 14:09:58',NULL),(2419,2978,40721,3046,3,2419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',1076.74,NULL,NULL,1,'2021-08-20 14:09:58','2021-08-20 14:09:58',NULL),(2420,2978,40721,3046,3,2420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',343.98,NULL,NULL,1,'2021-08-20 14:09:58','2021-08-20 14:09:58',NULL),(2421,2978,40721,3046,3,2421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',836.76,NULL,NULL,1,'2021-08-20 14:09:58','2021-08-20 14:09:58',NULL);
INSERT INTO `balance_libro` VALUES (2422,2978,40721,3046,3,2422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',375.54,NULL,NULL,1,'2021-08-20 14:09:58','2021-08-20 14:09:58',NULL),(2423,2978,40721,3046,3,2423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',900.00,NULL,NULL,1,'2021-08-20 14:09:58','2021-08-20 14:09:58',NULL),(2424,2978,40721,3046,3,2424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',4610.00,NULL,NULL,1,'2021-08-20 14:09:58','2021-08-20 14:09:58',NULL),(2425,2978,40721,3046,3,2425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',2547.45,NULL,NULL,1,'2021-08-20 14:09:58','2021-08-20 14:09:58',NULL),(2426,2978,40721,3046,3,2426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',1458.00,NULL,NULL,1,'2021-08-20 14:09:58','2021-08-20 14:09:58',NULL),(2427,2978,40721,3046,3,2427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',418.50,NULL,NULL,1,'2021-08-20 14:09:58','2021-08-20 14:09:58',NULL),(2428,2978,40721,3046,3,2428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',2143.96,NULL,NULL,1,'2021-08-20 14:09:58','2021-08-20 14:09:58',NULL),(2429,2978,40721,3046,3,2429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',8783.03,NULL,NULL,1,'2021-08-20 14:09:58','2021-08-20 14:09:58',NULL),(2430,2978,40721,3046,3,2430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',917.14,NULL,NULL,1,'2021-08-20 14:09:58','2021-08-20 14:09:58',NULL),(2431,2978,40721,3046,3,2431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',2748.00,NULL,NULL,1,'2021-08-20 14:09:58','2021-08-20 14:09:58',NULL),(2432,2978,40721,3047,3,2432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',5417.50,NULL,NULL,1,'2021-08-20 14:19:10','2021-08-20 14:19:10',NULL),(2433,2978,40721,3047,3,2433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',5475.56,NULL,NULL,1,'2021-08-20 14:19:10','2021-08-20 14:19:10',NULL),(2434,2978,40721,3047,3,2434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',4706.90,NULL,NULL,1,'2021-08-20 14:19:10','2021-08-20 14:19:10',NULL),(2435,2978,40721,3047,3,2435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',970.75,NULL,NULL,1,'2021-08-20 14:19:10','2021-08-20 14:19:10',NULL),(2436,2978,40721,3047,3,2436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',694.79,NULL,NULL,1,'2021-08-20 14:19:10','2021-08-20 14:19:10',NULL),(2437,2978,40721,3047,3,2437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',1200.00,NULL,NULL,1,'2021-08-20 14:19:10','2021-08-20 14:19:10',NULL),(2438,2978,40721,3047,3,2438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',4610.00,NULL,NULL,1,'2021-08-20 14:19:10','2021-08-20 14:19:10',NULL),(2439,2978,40721,3047,3,2439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',687.96,NULL,NULL,1,'2021-08-20 14:19:10','2021-08-20 14:19:10',NULL),(2440,2978,40721,3047,3,2440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',612.32,NULL,NULL,1,'2021-08-20 14:19:10','2021-08-20 14:19:10',NULL),(2441,2978,40721,3047,3,2441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',3158.10,NULL,NULL,1,'2021-08-20 14:19:10','2021-08-20 14:19:10',NULL),(2442,2978,40721,3047,3,2442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',600.00,NULL,NULL,1,'2021-08-20 14:19:10','2021-08-20 14:19:10',NULL),(2443,2978,40721,3047,3,2443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',1021.00,NULL,NULL,1,'2021-08-20 14:19:10','2021-08-20 14:19:10',NULL),(2444,2978,40721,3047,3,2444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',548.58,NULL,NULL,1,'2021-08-20 14:19:10','2021-08-20 14:19:10',NULL),(2445,2978,40721,3047,3,2445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-20','2021-06-20',5595.00,NULL,NULL,1,'2021-08-20 14:19:10','2021-08-20 14:19:10',NULL);
INSERT INTO `balance_libro` VALUES (2446,2978,40721,3047,3,2446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-20','2021-06-20',550.67,NULL,NULL,1,'2021-08-20 14:19:10','2021-08-20 14:19:10',NULL),(2447,2978,40721,3047,3,2447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',751.07,NULL,NULL,1,'2021-08-20 14:19:10','2021-08-20 14:19:10',NULL),(2448,2978,40721,3047,3,2448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',1214.40,NULL,NULL,1,'2021-08-20 14:19:10','2021-08-20 14:19:10',NULL),(2449,2978,40721,3047,3,2449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',290.61,NULL,NULL,1,'2021-08-20 14:19:10','2021-08-20 14:19:10',NULL),(2450,2978,40721,3047,3,2450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',16674.51,NULL,NULL,1,'2021-08-20 14:19:10','2021-08-20 14:19:10',NULL),(2451,2978,40721,3047,3,2451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',2080.21,NULL,NULL,1,'2021-08-20 14:19:10','2021-08-20 14:19:10',NULL),(2452,2978,40721,3048,3,2452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',0.00,NULL,NULL,1,'2021-08-20 14:21:20','2021-08-20 14:21:20',NULL),(2453,2978,40721,3048,3,2453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',5503.57,NULL,NULL,1,'2021-08-20 14:21:20','2021-08-20 14:21:20',NULL),(2454,2978,40721,3048,3,2454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',687.96,NULL,NULL,1,'2021-08-20 14:21:20','2021-08-20 14:21:20',NULL),(2455,2978,40721,3048,3,2455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',5475.56,NULL,NULL,1,'2021-08-20 14:21:20','2021-08-20 14:21:20',NULL),(2456,2978,40721,3048,3,2456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',1065.90,NULL,NULL,1,'2021-08-20 14:21:20','2021-08-20 14:21:20',NULL),(2457,2978,40721,3048,3,2457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',978.30,NULL,NULL,1,'2021-08-20 14:21:20','2021-08-20 14:21:20',NULL),(2458,2978,40721,3048,3,2458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',1200.00,NULL,NULL,1,'2021-08-20 14:21:20','2021-08-20 14:21:20',NULL),(2459,2978,40721,3048,3,2459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',5050.00,NULL,NULL,1,'2021-08-20 14:21:20','2021-08-20 14:21:20',NULL),(2460,2978,40721,3048,3,2460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',5300.00,NULL,NULL,1,'2021-08-20 14:21:20','2021-08-20 14:21:20',NULL),(2461,2978,40721,3048,3,2461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',3102.21,NULL,NULL,1,'2021-08-20 14:21:20','2021-08-20 14:21:20',NULL),(2462,2978,40721,3048,3,2462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',51079.01,NULL,NULL,1,'2021-08-20 14:21:20','2021-08-20 14:21:20',NULL),(2463,2978,40721,3048,3,2463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',917.14,NULL,NULL,1,'2021-08-20 14:21:20','2021-08-20 14:21:20',NULL),(2464,2978,40721,3048,3,2464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',719.51,NULL,NULL,1,'2021-08-20 14:21:21','2021-08-20 14:21:21',NULL),(2465,2978,40721,3048,3,2465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',627.00,NULL,NULL,1,'2021-08-20 14:21:21','2021-08-20 14:21:21',NULL),(2466,2978,40721,3048,3,2466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',900.00,NULL,NULL,1,'2021-08-20 14:21:21','2021-08-20 14:21:21',NULL),(2467,2978,40721,3048,3,2467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',1109.67,NULL,NULL,1,'2021-08-20 14:21:21','2021-08-20 14:21:21',NULL),(2468,2978,40721,3048,3,2468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',1774.00,NULL,NULL,1,'2021-08-20 14:21:21','2021-08-20 14:21:21',NULL),(2469,2978,40721,3048,3,2469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',9027.60,NULL,NULL,1,'2021-08-20 14:21:21','2021-08-20 14:21:21',NULL);
INSERT INTO `balance_libro` VALUES (2470,2978,40721,3048,3,2470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',1906.95,NULL,NULL,1,'2021-08-20 14:21:21','2021-08-20 14:21:21',NULL),(2471,2978,40721,3048,3,2471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',7700.00,NULL,NULL,1,'2021-08-20 14:21:21','2021-08-20 14:21:21',NULL),(2472,2978,40874,71607,3,2472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-09','2020-07-09',396.00,NULL,NULL,1,'2021-08-20 14:45:34','2021-08-20 14:45:34',NULL),(2473,2978,40874,71607,3,2473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-19','2020-07-19',4252.00,NULL,NULL,1,'2021-08-20 14:45:34','2021-08-20 14:45:34',NULL),(2474,2978,40874,71607,3,2474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-19','2020-07-19',622.00,NULL,NULL,1,'2021-08-20 14:45:34','2021-08-20 14:45:34',NULL),(2475,2978,40874,71607,3,2475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-24','2020-07-24',18199.00,NULL,NULL,1,'2021-08-20 14:45:34','2021-08-20 14:45:34',NULL),(2476,2978,40874,71608,3,2476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-22','2020-08-22',4252.00,NULL,NULL,1,'2021-08-20 14:46:55','2021-08-20 14:46:55',NULL),(2477,2978,40874,71608,3,2477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-22','2020-08-22',622.00,NULL,NULL,1,'2021-08-20 14:46:55','2021-08-20 14:46:55',NULL),(2478,2978,40874,42467,3,2478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-21','2020-09-21',170.00,NULL,NULL,1,'2021-08-20 14:49:01','2021-08-20 14:49:01',NULL),(2479,2978,40874,42467,3,2479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',4252.00,NULL,NULL,1,'2021-08-20 14:49:01','2021-08-20 14:49:01',NULL),(2480,2978,40874,42467,3,2480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',622.00,NULL,NULL,1,'2021-08-20 14:49:01','2021-08-20 14:49:01',NULL),(2481,2978,40874,71610,3,2481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-27','2020-10-27',799.00,NULL,NULL,1,'2021-08-20 15:01:53','2021-08-20 15:01:53',NULL),(2482,2978,40874,71610,3,2482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-27','2020-10-27',5319.00,NULL,NULL,1,'2021-08-20 15:01:53','2021-08-20 15:01:53',NULL),(2483,2978,40874,71610,3,2483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-29','2020-10-29',21000.00,NULL,NULL,1,'2021-08-20 15:01:53','2021-08-20 15:01:53',NULL),(2484,2978,40874,71610,3,2484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-29','2020-10-29',1050.00,NULL,NULL,1,'2021-08-20 15:01:53','2021-08-20 15:01:53',NULL),(2485,2978,40874,71611,3,2485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-03','2020-11-03',2257.99,NULL,NULL,1,'2021-08-20 15:03:02','2021-08-20 15:03:02',NULL),(2486,2978,40874,71611,3,2486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-15','2020-11-15',45.05,NULL,NULL,1,'2021-08-20 15:03:02','2021-08-20 15:03:02',NULL),(2487,2978,40874,71611,3,2487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-15','2020-11-15',157.60,NULL,NULL,1,'2021-08-20 15:03:02','2021-08-20 15:03:02',NULL),(2488,2978,40874,71611,3,2488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',468.60,NULL,NULL,1,'2021-08-20 15:03:02','2021-08-20 15:03:02',NULL),(2489,2978,40874,71611,3,2489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-24','2020-11-24',31.92,NULL,NULL,1,'2021-08-20 15:03:02','2021-08-20 15:03:02',NULL),(2490,2978,40874,71611,3,2490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-25','2020-11-25',0.00,NULL,NULL,1,'2021-08-20 15:03:02','2021-08-20 15:03:02',NULL),(2491,2978,40874,71611,3,2491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-28','2020-11-28',799.00,NULL,NULL,1,'2021-08-20 15:03:02','2021-08-20 15:03:02',NULL),(2492,2978,40874,71611,3,2492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-28','2020-11-28',5319.00,NULL,NULL,1,'2021-08-20 15:03:02','2021-08-20 15:03:02',NULL),(2493,2978,40874,71611,3,2493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',117.00,NULL,NULL,1,'2021-08-20 15:03:02','2021-08-20 15:03:02',NULL);
INSERT INTO `balance_libro` VALUES (2494,2978,40874,71612,3,2494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-02','2020-12-02',0.00,NULL,NULL,1,'2021-08-20 17:22:43','2021-08-20 17:22:43',NULL),(2495,2978,40874,71612,3,2495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-03','2020-12-03',7682.55,NULL,NULL,1,'2021-08-20 17:22:43','2021-08-20 17:22:43',NULL),(2496,2978,40874,71612,3,2496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-18','2020-12-18',45.05,NULL,NULL,1,'2021-08-20 17:22:43','2021-08-20 17:22:43',NULL),(2497,2978,40874,71612,3,2497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-18','2020-12-18',54.00,NULL,NULL,1,'2021-08-20 17:22:43','2021-08-20 17:22:43',NULL),(2498,2978,40874,71612,3,2498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-18','2020-12-18',326.65,NULL,NULL,1,'2021-08-20 17:22:43','2021-08-20 17:22:43',NULL),(2499,2978,40874,71612,3,2499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-22','2020-12-22',575.70,NULL,NULL,1,'2021-08-20 17:22:43','2021-08-20 17:22:43',NULL),(2500,2978,40874,71612,3,2500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-23','2020-12-23',799.00,NULL,NULL,1,'2021-08-20 17:22:43','2021-08-20 17:22:43',NULL),(2501,2978,40874,71612,3,2501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-23','2020-12-23',5319.00,NULL,NULL,1,'2021-08-20 17:22:43','2021-08-20 17:22:43',NULL),(2502,2978,40874,71612,3,2502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',117.00,NULL,NULL,1,'2021-08-20 17:22:43','2021-08-20 17:22:43',NULL),(2503,2978,40874,42459,3,2503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',325.80,NULL,NULL,1,'2021-08-20 17:23:30','2021-08-20 17:23:30',NULL),(2504,2978,40874,42459,3,2504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-10','2021-01-10',54.00,NULL,NULL,1,'2021-08-20 17:23:30','2021-08-20 17:23:30',NULL),(2505,2978,40874,42459,3,2505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',234.06,NULL,NULL,1,'2021-08-20 17:23:31','2021-08-20 17:23:31',NULL),(2506,2978,40874,42459,3,2506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',799.00,NULL,NULL,1,'2021-08-20 17:23:31','2021-08-20 17:23:31',NULL),(2507,2978,40874,42459,3,2507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',5319.00,NULL,NULL,1,'2021-08-20 17:23:31','2021-08-20 17:23:31',NULL),(2508,2978,40874,42459,3,2508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',89.10,NULL,NULL,1,'2021-08-20 17:23:31','2021-08-20 17:23:31',NULL),(2509,2978,40874,42459,3,2509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',1071.00,NULL,NULL,1,'2021-08-20 17:23:31','2021-08-20 17:23:31',NULL),(2510,2978,40874,42460,3,2510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',123.50,NULL,NULL,1,'2021-08-20 17:27:45','2021-08-20 17:27:45',NULL),(2511,2978,40874,42460,3,2511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',118.58,NULL,NULL,1,'2021-08-20 17:27:45','2021-08-20 17:27:45',NULL),(2512,2978,40874,42460,3,2512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-13','2021-02-13',32900.00,NULL,NULL,1,'2021-08-20 17:27:45','2021-08-20 17:27:45',NULL),(2513,2978,40874,42460,3,2513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-13','2021-02-13',4510.00,NULL,NULL,1,'2021-08-20 17:27:45','2021-08-20 17:27:45',NULL),(2514,2978,40874,42460,3,2514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',106.80,NULL,NULL,1,'2021-08-20 17:27:45','2021-08-20 17:27:45',NULL),(2515,2978,40874,42460,3,2515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',257.40,NULL,NULL,1,'2021-08-20 17:27:45','2021-08-20 17:27:45',NULL),(2516,2978,40874,42460,3,2516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',649.20,NULL,NULL,1,'2021-08-20 17:27:46','2021-08-20 17:27:46',NULL),(2517,2978,40874,42460,3,2517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',78.02,NULL,NULL,1,'2021-08-20 17:27:46','2021-08-20 17:27:46',NULL);
INSERT INTO `balance_libro` VALUES (2518,2978,40874,42460,3,2518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',80.00,NULL,NULL,1,'2021-08-20 17:27:46','2021-08-20 17:27:46',NULL),(2519,2978,40874,42461,3,2519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',5880.30,NULL,NULL,1,'2021-08-20 17:28:45','2021-08-20 17:28:45',NULL),(2520,2978,40874,42461,3,2520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',257.25,NULL,NULL,1,'2021-08-20 17:28:45','2021-08-20 17:28:45',NULL),(2521,2978,40874,42461,3,2521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',237.16,NULL,NULL,1,'2021-08-20 17:28:45','2021-08-20 17:28:45',NULL),(2522,2978,40874,42461,3,2522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',5880.00,NULL,NULL,1,'2021-08-20 17:28:45','2021-08-20 17:28:45',NULL),(2523,2978,40874,42461,3,2523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',106.80,NULL,NULL,1,'2021-08-20 17:28:45','2021-08-20 17:28:45',NULL),(2524,2978,40874,42461,3,2524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',752.35,NULL,NULL,1,'2021-08-20 17:28:45','2021-08-20 17:28:45',NULL),(2525,2978,40874,42461,3,2525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',108.00,NULL,NULL,1,'2021-08-20 17:28:45','2021-08-20 17:28:45',NULL),(2526,2978,40874,42461,3,2526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',396.00,NULL,NULL,1,'2021-08-20 17:28:45','2021-08-20 17:28:45',NULL),(2527,2978,40874,42462,3,2527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',638.40,NULL,NULL,1,'2021-08-20 17:29:26','2021-08-20 17:29:26',NULL),(2528,2978,40874,42462,3,2528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',223.22,NULL,NULL,1,'2021-08-20 17:29:26','2021-08-20 17:29:26',NULL),(2529,2978,40874,42462,3,2529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',4135.56,NULL,NULL,1,'2021-08-20 17:29:26','2021-08-20 17:29:26',NULL),(2530,2978,40874,42462,3,2530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',6710.29,NULL,NULL,1,'2021-08-20 17:29:26','2021-08-20 17:29:26',NULL),(2531,2978,40874,42462,3,2531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',237.15,NULL,NULL,1,'2021-08-20 17:29:26','2021-08-20 17:29:26',NULL),(2532,2978,40874,42462,3,2532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',309.38,NULL,NULL,1,'2021-08-20 17:29:26','2021-08-20 17:29:26',NULL),(2533,2978,40874,42462,3,2533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',378.00,NULL,NULL,1,'2021-08-20 17:29:26','2021-08-20 17:29:26',NULL),(2534,2978,40874,42462,3,2534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',156.04,NULL,NULL,1,'2021-08-20 17:29:26','2021-08-20 17:29:26',NULL),(2535,2978,40874,42463,3,2535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',3832.68,NULL,NULL,1,'2021-08-20 17:30:02','2021-08-20 17:30:02',NULL),(2536,2978,40874,42463,3,2536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',148.22,NULL,NULL,1,'2021-08-20 17:30:02','2021-08-20 17:30:02',NULL),(2537,2978,40874,42463,3,2537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',362.20,NULL,NULL,1,'2021-08-20 17:30:02','2021-08-20 17:30:02',NULL),(2538,2978,40874,42463,3,2538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',609.05,NULL,NULL,1,'2021-08-20 17:30:02','2021-08-20 17:30:02',NULL),(2539,2978,40874,42463,3,2539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',1980.00,NULL,NULL,1,'2021-08-20 17:30:02','2021-08-20 17:30:02',NULL),(2540,2978,40874,42463,3,2540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',191.81,NULL,NULL,1,'2021-08-20 17:30:02','2021-08-20 17:30:02',NULL),(2541,2978,40874,42463,3,2541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',290.39,NULL,NULL,1,'2021-08-20 17:30:03','2021-08-20 17:30:03',NULL);
INSERT INTO `balance_libro` VALUES (2542,2978,40874,42463,3,2542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',103.55,NULL,NULL,1,'2021-08-20 17:30:03','2021-08-20 17:30:03',NULL),(2543,2978,40874,42463,3,2543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',849.25,NULL,NULL,1,'2021-08-20 17:30:03','2021-08-20 17:30:03',NULL),(2544,2978,40874,42463,3,2544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',162.00,NULL,NULL,1,'2021-08-20 17:30:03','2021-08-20 17:30:03',NULL),(2545,2978,40874,42463,3,2545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',354.00,NULL,NULL,1,'2021-08-20 17:30:03','2021-08-20 17:30:03',NULL),(2546,2978,40874,42463,3,2546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',3256.00,NULL,NULL,1,'2021-08-20 17:30:03','2021-08-20 17:30:03',NULL),(2547,2978,40874,42464,3,2547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',313.88,NULL,NULL,1,'2021-08-20 17:35:01','2021-08-20 17:35:01',NULL),(2548,2978,40874,42464,3,2548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',3975.00,NULL,NULL,1,'2021-08-20 17:35:01','2021-08-20 17:35:01',NULL),(2549,2978,40874,42464,3,2549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',207.10,NULL,NULL,1,'2021-08-20 17:35:01','2021-08-20 17:35:01',NULL),(2550,2978,40874,42464,3,2550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',499.05,NULL,NULL,1,'2021-08-20 17:35:01','2021-08-20 17:35:01',NULL),(2551,2978,40874,42464,3,2551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',610.32,NULL,NULL,1,'2021-08-20 17:35:01','2021-08-20 17:35:01',NULL),(2552,2978,40874,42464,3,2552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',61.75,NULL,NULL,1,'2021-08-20 17:35:01','2021-08-20 17:35:01',NULL),(2553,2978,40874,42464,3,2553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',466.55,NULL,NULL,1,'2021-08-20 17:35:01','2021-08-20 17:35:01',NULL),(2554,2978,40874,42464,3,2554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-20','2021-06-20',108.00,NULL,NULL,1,'2021-08-20 17:35:01','2021-08-20 17:35:01',NULL),(2555,2978,40874,42464,3,2555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',171.51,NULL,NULL,1,'2021-08-20 17:35:01','2021-08-20 17:35:01',NULL),(2556,2978,40874,42464,3,2556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',204.00,NULL,NULL,1,'2021-08-20 17:35:01','2021-08-20 17:35:01',NULL),(2557,2978,40874,42464,3,2557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',2699.99,NULL,NULL,1,'2021-08-20 17:35:01','2021-08-20 17:35:01',NULL),(2558,2978,40848,6100,3,2558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',44826.00,NULL,NULL,1,'2021-08-20 17:46:30','2021-08-20 17:46:30',NULL),(2559,2978,40848,6101,3,2559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',2649.50,NULL,NULL,1,'2021-08-20 17:48:27','2021-08-20 17:48:27',NULL),(2560,2978,40848,6101,3,2560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',1889.99,NULL,NULL,1,'2021-08-20 17:48:27','2021-08-20 17:48:27',NULL),(2561,2978,40848,6101,3,2561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',1599.00,NULL,NULL,1,'2021-08-20 17:48:27','2021-08-20 17:48:27',NULL),(2562,2978,40848,6101,3,2562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',581.01,NULL,NULL,1,'2021-08-20 17:48:27','2021-08-20 17:48:27',NULL),(2563,2978,40848,6099,3,2563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',4000.00,NULL,NULL,1,'2021-08-20 17:50:27','2021-08-20 17:50:27',NULL),(2564,2978,40848,6099,3,2564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',581.01,NULL,NULL,1,'2021-08-20 17:50:27','2021-08-20 17:50:27',NULL),(2565,2978,40848,6102,3,2565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',1583.24,NULL,NULL,1,'2021-08-20 17:51:30','2021-08-20 17:51:30',NULL);
INSERT INTO `balance_libro` VALUES (2566,2978,40848,6102,3,2566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',639.00,NULL,NULL,1,'2021-08-20 17:51:30','2021-08-20 17:51:30',NULL),(2567,2978,40847,44022,3,2567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-23','2020-07-23',400.00,NULL,NULL,1,'2021-08-20 17:58:43','2021-08-20 17:58:43',NULL),(2568,2978,40847,44023,3,2568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-23','2020-08-23',400.00,NULL,NULL,1,'2021-08-20 17:59:59','2021-08-20 17:59:59',NULL),(2569,2978,40847,44024,3,2569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-22','2020-09-22',400.00,NULL,NULL,1,'2021-08-20 18:01:11','2021-08-20 18:01:11',NULL),(2570,2978,40847,44024,3,2570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-24','2020-09-24',1915.00,NULL,NULL,1,'2021-08-20 18:01:11','2021-08-20 18:01:11',NULL),(2571,2978,40847,44025,3,2571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-22','2020-10-22',400.00,NULL,NULL,1,'2021-08-20 18:02:15','2021-08-20 18:02:15',NULL),(2572,2978,40847,44025,3,2572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-30','2020-10-30',16000.22,NULL,NULL,1,'2021-08-20 18:02:15','2021-08-20 18:02:15',NULL),(2573,2978,40847,44026,3,2573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',1164092.00,NULL,NULL,1,'2021-08-20 18:03:02','2021-08-20 18:03:02',NULL),(2574,2978,40847,44026,3,2574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-21','2020-11-21',400.00,NULL,NULL,1,'2021-08-20 18:03:02','2021-08-20 18:03:02',NULL),(2575,2978,40847,44027,3,2575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-21','2020-12-21',400.00,NULL,NULL,1,'2021-08-20 18:08:04','2021-08-20 18:08:04',NULL),(2576,2978,40847,4584,3,2576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-01','2021-01-01',2850.12,NULL,NULL,1,'2021-08-20 18:10:36','2021-08-20 18:10:36',NULL),(2577,2978,40847,4584,3,2577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',1800.00,NULL,NULL,1,'2021-08-20 18:10:36','2021-08-20 18:10:36',NULL),(2578,2978,40847,4584,3,2578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',500.00,NULL,NULL,1,'2021-08-20 18:10:36','2021-08-20 18:10:36',NULL),(2579,2978,40847,4585,3,2579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',1057.26,NULL,NULL,1,'2021-08-20 18:11:13','2021-08-20 18:11:13',NULL),(2580,2978,40847,4585,3,2580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',1379.04,NULL,NULL,1,'2021-08-20 18:11:13','2021-08-20 18:11:13',NULL),(2581,2978,40847,4585,3,2581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',500.00,NULL,NULL,1,'2021-08-20 18:11:13','2021-08-20 18:11:13',NULL),(2582,2978,40847,4586,3,2582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1408.08,NULL,NULL,1,'2021-08-20 18:12:19','2021-08-20 18:12:19',NULL),(2583,2978,40847,4586,3,2583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',500.00,NULL,NULL,1,'2021-08-20 18:12:19','2021-08-20 18:12:19',NULL),(2584,2978,40847,4587,3,2584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',1408.08,NULL,NULL,1,'2021-08-20 18:13:19','2021-08-20 18:13:19',NULL),(2585,2978,40847,4587,3,2585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',500.00,NULL,NULL,1,'2021-08-20 18:13:19','2021-08-20 18:13:19',NULL),(2586,2978,40847,4588,3,2586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-01','2021-05-01',1611.18,NULL,NULL,1,'2021-08-20 18:14:06','2021-08-20 18:14:06',NULL),(2587,2978,40847,4588,3,2587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',650.00,NULL,NULL,1,'2021-08-20 18:14:06','2021-08-20 18:14:06',NULL),(2588,2978,40847,44021,3,2588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-23','2020-06-23',400.00,NULL,NULL,1,'2021-08-20 18:15:12','2021-08-20 18:15:12',NULL),(2589,2978,40847,4589,3,2589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',1611.18,NULL,NULL,1,'2021-08-20 18:19:45','2021-08-20 18:19:45',NULL);
INSERT INTO `balance_libro` VALUES (2590,2978,40847,4589,3,2590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',650.00,NULL,NULL,1,'2021-08-20 18:19:45','2021-08-20 18:19:45',NULL),(2591,2978,40847,4590,3,2591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',1611.18,NULL,NULL,1,'2021-08-20 18:20:29','2021-08-20 18:20:29',NULL),(2592,2978,40847,4590,3,2592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',650.00,NULL,NULL,1,'2021-08-20 18:20:29','2021-08-20 18:20:29',NULL),(2593,2978,41300,44067,3,2593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-01','2020-07-01',26.20,NULL,NULL,1,'2021-08-20 18:27:17','2021-08-20 18:27:17',NULL),(2594,2978,41300,44067,3,2594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-01','2020-07-01',50.27,NULL,NULL,1,'2021-08-20 18:27:17','2021-08-20 18:27:17',NULL),(2595,2978,41300,44067,3,2595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-01','2020-07-01',3893.91,NULL,NULL,1,'2021-08-20 18:27:17','2021-08-20 18:27:17',NULL),(2596,2978,41300,44067,3,2596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-04','2020-07-04',28.65,NULL,NULL,1,'2021-08-20 18:27:17','2021-08-20 18:27:17',NULL),(2597,2978,41300,44067,3,2597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-17','2020-07-17',2390.93,NULL,NULL,1,'2021-08-20 18:27:17','2021-08-20 18:27:17',NULL),(2598,2978,41300,44067,3,2598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-21','2020-07-21',19.36,NULL,NULL,1,'2021-08-20 18:27:17','2021-08-20 18:27:17',NULL),(2599,2978,41300,44067,3,2599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-21','2020-07-21',26.44,NULL,NULL,1,'2021-08-20 18:27:17','2021-08-20 18:27:17',NULL),(2600,2978,41300,44067,3,2600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-21','2020-07-21',30.50,NULL,NULL,1,'2021-08-20 18:27:17','2021-08-20 18:27:17',NULL),(2601,2978,41300,44068,3,2601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-07','2020-08-07',4381.24,NULL,NULL,1,'2021-08-20 18:29:13','2021-08-20 18:29:13',NULL),(2602,2978,41300,44068,3,2602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-12','2020-08-12',21020.00,NULL,NULL,1,'2021-08-20 18:29:13','2021-08-20 18:29:13',NULL),(2603,2978,41300,44068,3,2603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-13','2020-08-13',52.74,NULL,NULL,1,'2021-08-20 18:29:13','2021-08-20 18:29:13',NULL),(2604,2978,41300,44068,3,2604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-27','2020-08-27',557.00,NULL,NULL,1,'2021-08-20 18:29:13','2021-08-20 18:29:13',NULL),(2605,2978,41300,44068,3,2605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-29','2020-08-29',3411.36,NULL,NULL,1,'2021-08-20 18:29:13','2021-08-20 18:29:13',NULL),(2606,2978,41300,44069,3,2606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-09','2020-09-09',4408.50,NULL,NULL,1,'2021-08-20 18:30:05','2021-08-20 18:30:05',NULL),(2607,2978,41300,44069,3,2607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-18','2020-09-18',7241.62,NULL,NULL,1,'2021-08-20 18:30:05','2021-08-20 18:30:05',NULL),(2608,2978,41300,44069,3,2608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-25','2020-09-25',1490.00,NULL,NULL,1,'2021-08-20 18:30:05','2021-08-20 18:30:05',NULL),(2609,2978,41300,44069,3,2609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-25','2020-09-25',9769.01,NULL,NULL,1,'2021-08-20 18:30:05','2021-08-20 18:30:05',NULL),(2610,2978,41300,44069,3,2610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-28','2020-09-28',18.83,NULL,NULL,1,'2021-08-20 18:30:05','2021-08-20 18:30:05',NULL),(2611,2978,41300,44069,3,2611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-28','2020-09-28',119.87,NULL,NULL,1,'2021-08-20 18:30:05','2021-08-20 18:30:05',NULL),(2612,2978,41300,44070,3,2612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-01','2020-10-01',3248.07,NULL,NULL,1,'2021-08-20 18:31:09','2021-08-20 18:31:09',NULL),(2613,2978,41300,44070,3,2613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-05','2020-10-05',5360.40,NULL,NULL,1,'2021-08-20 18:31:10','2021-08-20 18:31:10',NULL);
INSERT INTO `balance_libro` VALUES (2614,2978,41300,44070,3,2614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-16','2020-10-16',8508.30,NULL,NULL,1,'2021-08-20 18:31:10','2021-08-20 18:31:10',NULL),(2615,2978,41300,44070,3,2615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-29','2020-10-29',8990.00,NULL,NULL,1,'2021-08-20 18:31:10','2021-08-20 18:31:10',NULL),(2616,2978,41300,44071,3,2616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-02','2020-11-02',6930.98,NULL,NULL,1,'2021-08-20 18:33:20','2021-08-20 18:33:20',NULL),(2617,2978,41300,44071,3,2617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-02','2020-11-02',4626.76,NULL,NULL,1,'2021-08-20 18:33:20','2021-08-20 18:33:20',NULL),(2618,2978,41300,44071,3,2618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-05','2020-11-05',4898.40,NULL,NULL,1,'2021-08-20 18:33:20','2021-08-20 18:33:20',NULL),(2619,2978,41300,44071,3,2619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-06','2020-11-06',5890.00,NULL,NULL,1,'2021-08-20 18:33:20','2021-08-20 18:33:20',NULL),(2620,2978,41300,44071,3,2620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-13','2020-11-13',8747.01,NULL,NULL,1,'2021-08-20 18:33:20','2021-08-20 18:33:20',NULL),(2621,2978,41300,44072,3,2621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-11','2020-12-11',4296.40,NULL,NULL,1,'2021-08-20 18:36:39','2021-08-20 18:36:39',NULL),(2622,2978,41300,44072,3,2622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-16','2020-12-16',10761.00,NULL,NULL,1,'2021-08-20 18:36:39','2021-08-20 18:36:39',NULL),(2623,2978,41300,44072,3,2623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-22','2020-12-22',6069.00,NULL,NULL,1,'2021-08-20 18:36:39','2021-08-20 18:36:39',NULL),(2624,2978,41300,44076,3,2624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-02','2021-01-02',6126.79,NULL,NULL,1,'2021-08-20 18:37:58','2021-08-20 18:37:58',NULL),(2625,2978,41300,44076,3,2625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-02','2021-01-02',36.16,NULL,NULL,1,'2021-08-20 18:37:58','2021-08-20 18:37:58',NULL),(2626,2978,41300,44076,3,2626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-02','2021-01-02',16.32,NULL,NULL,1,'2021-08-20 18:37:58','2021-08-20 18:37:58',NULL),(2627,2978,41300,44076,3,2627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-02','2021-01-02',114.93,NULL,NULL,1,'2021-08-20 18:37:58','2021-08-20 18:37:58',NULL),(2628,2978,41300,44076,3,2628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-02','2021-01-02',114.94,NULL,NULL,1,'2021-08-20 18:37:58','2021-08-20 18:37:58',NULL),(2629,2978,41300,44076,3,2629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',24.81,NULL,NULL,1,'2021-08-20 18:37:58','2021-08-20 18:37:58',NULL),(2630,2978,41300,44076,3,2630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',24.80,NULL,NULL,1,'2021-08-20 18:37:58','2021-08-20 18:37:58',NULL),(2631,2978,41300,44076,3,2631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',7.79,NULL,NULL,1,'2021-08-20 18:37:58','2021-08-20 18:37:58',NULL),(2632,2978,41300,44076,3,2632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',7.80,NULL,NULL,1,'2021-08-20 18:37:58','2021-08-20 18:37:58',NULL),(2633,2978,41300,44076,3,2633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',22.09,NULL,NULL,1,'2021-08-20 18:37:58','2021-08-20 18:37:58',NULL),(2634,2978,41300,44076,3,2634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',29.39,NULL,NULL,1,'2021-08-20 18:37:58','2021-08-20 18:37:58',NULL),(2635,2978,41300,44076,3,2635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',9.49,NULL,NULL,1,'2021-08-20 18:37:58','2021-08-20 18:37:58',NULL),(2636,2978,41300,44077,3,2636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',2800.00,NULL,NULL,1,'2021-08-20 18:38:54','2021-08-20 18:38:54',NULL),(2637,2978,41300,44077,3,2637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',15900.00,NULL,NULL,1,'2021-08-20 18:38:54','2021-08-20 18:38:54',NULL);
INSERT INTO `balance_libro` VALUES (2638,2978,41300,44077,3,2638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-14','2021-02-14',24999.00,NULL,NULL,1,'2021-08-20 18:38:54','2021-08-20 18:38:54',NULL),(2639,2978,41300,44077,3,2639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-14','2021-02-14',39999.00,NULL,NULL,1,'2021-08-20 18:38:54','2021-08-20 18:38:54',NULL),(2640,2978,41300,44077,3,2640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',5783.21,NULL,NULL,1,'2021-08-20 18:38:54','2021-08-20 18:38:54',NULL),(2641,2978,41300,44077,3,2641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',26999.00,NULL,NULL,1,'2021-08-20 18:38:54','2021-08-20 18:38:54',NULL),(2642,2978,41300,44077,3,2642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',16999.00,NULL,NULL,1,'2021-08-20 18:38:54','2021-08-20 18:38:54',NULL),(2643,2978,41300,44077,3,2643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',5815.56,NULL,NULL,1,'2021-08-20 18:38:54','2021-08-20 18:38:54',NULL),(2644,2978,41300,44077,3,2644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',1800.00,NULL,NULL,1,'2021-08-20 18:38:54','2021-08-20 18:38:54',NULL),(2645,2978,41300,44077,3,2645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',8200.00,NULL,NULL,1,'2021-08-20 18:38:54','2021-08-20 18:38:54',NULL),(2646,2978,41300,44078,3,2646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',6152.00,NULL,NULL,1,'2021-08-20 18:39:55','2021-08-20 18:39:55',NULL),(2647,2978,41300,44078,3,2647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',3999.00,NULL,NULL,1,'2021-08-20 18:39:55','2021-08-20 18:39:55',NULL),(2648,2978,41300,44078,3,2648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',111.16,NULL,NULL,1,'2021-08-20 18:39:55','2021-08-20 18:39:55',NULL),(2649,2978,41300,44078,3,2649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',219.38,NULL,NULL,1,'2021-08-20 18:39:55','2021-08-20 18:39:55',NULL),(2650,2978,41300,44078,3,2650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',1352.00,NULL,NULL,1,'2021-08-20 18:39:55','2021-08-20 18:39:55',NULL),(2651,2978,41300,44078,3,2651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',5398.00,NULL,NULL,1,'2021-08-20 18:39:55','2021-08-20 18:39:55',NULL),(2652,2978,41300,44078,3,2652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',2500.00,NULL,NULL,1,'2021-08-20 18:39:55','2021-08-20 18:39:55',NULL),(2653,2978,41300,44078,3,2653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',9452.62,NULL,NULL,1,'2021-08-20 18:39:55','2021-08-20 18:39:55',NULL),(2654,2978,41300,44079,3,2654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',1849.00,NULL,NULL,1,'2021-08-20 18:40:51','2021-08-20 18:40:51',NULL),(2655,2978,41300,44080,3,2655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',777.00,NULL,NULL,1,'2021-08-20 18:41:56','2021-08-20 18:41:56',NULL),(2656,2978,41300,44080,3,2656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',4950.00,NULL,NULL,1,'2021-08-20 18:41:56','2021-08-20 18:41:56',NULL),(2657,2978,41300,44080,3,2657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',8317.29,NULL,NULL,1,'2021-08-20 18:41:56','2021-08-20 18:41:56',NULL),(2658,2978,41300,44080,3,2658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',2800.00,NULL,NULL,1,'2021-08-20 18:41:56','2021-08-20 18:41:56',NULL),(2659,2978,41300,44080,3,2659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',23753.58,NULL,NULL,1,'2021-08-20 18:41:56','2021-08-20 18:41:56',NULL),(2660,2978,41300,44066,3,2660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-06','2020-06-06',5222.50,NULL,NULL,1,'2021-08-20 18:45:21','2021-08-20 18:45:21',NULL),(2661,2978,41300,44066,3,2661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-12','2020-06-12',5823.80,NULL,NULL,1,'2021-08-20 18:45:21','2021-08-20 18:45:21',NULL);
INSERT INTO `balance_libro` VALUES (2662,2978,41300,44081,3,2662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',12157.50,NULL,NULL,1,'2021-08-20 18:46:27','2021-08-20 18:46:27',NULL),(2663,2978,41300,44081,3,2663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',6175.30,NULL,NULL,1,'2021-08-20 18:46:27','2021-08-20 18:46:27',NULL),(2664,2978,41300,44081,3,2664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',400.01,NULL,NULL,1,'2021-08-20 18:46:27','2021-08-20 18:46:27',NULL),(2665,2978,41300,44082,3,2665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',1510.00,NULL,NULL,1,'2021-08-20 18:47:22','2021-08-20 18:47:22',NULL),(2666,2978,41300,44082,3,2666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',5199.35,NULL,NULL,1,'2021-08-20 18:47:22','2021-08-20 18:47:22',NULL),(2667,2978,41300,44082,3,2667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',900.00,NULL,NULL,1,'2021-08-20 18:47:22','2021-08-20 18:47:22',NULL),(2668,2978,40866,43993,3,2668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-12','2020-08-12',6095.74,NULL,NULL,1,'2021-08-20 19:00:57','2021-08-20 19:00:57',NULL),(2669,2978,40866,43993,3,2669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',3238.47,NULL,NULL,1,'2021-08-20 19:00:57','2021-08-20 19:00:57',NULL),(2670,2978,40866,43994,3,2670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-12','2020-09-12',2251.88,NULL,NULL,1,'2021-08-20 19:01:44','2021-08-20 19:01:44',NULL),(2671,2978,40866,43994,3,2671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-12','2020-09-12',4865.31,NULL,NULL,1,'2021-08-20 19:01:44','2021-08-20 19:01:44',NULL),(2672,2978,40866,43995,3,2672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-12','2020-10-12',2573.67,NULL,NULL,1,'2021-08-20 19:02:36','2021-08-20 19:02:36',NULL),(2673,2978,40866,43995,3,2673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-12','2020-10-12',4038.25,NULL,NULL,1,'2021-08-20 19:02:36','2021-08-20 19:02:36',NULL),(2674,2978,40866,43995,3,2674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-14','2020-10-14',5758.84,NULL,NULL,1,'2021-08-20 19:02:36','2021-08-20 19:02:36',NULL),(2675,2978,40866,43995,3,2675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-29','2020-10-29',2865.00,NULL,NULL,1,'2021-08-20 19:02:36','2021-08-20 19:02:36',NULL),(2676,2978,40866,43996,3,2676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-06','2020-11-06',790.00,NULL,NULL,1,'2021-08-20 19:03:30','2021-08-20 19:03:30',NULL),(2677,2978,40866,43996,3,2677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-11','2020-11-11',3000.00,NULL,NULL,1,'2021-08-20 19:03:30','2021-08-20 19:03:30',NULL),(2678,2978,40866,43996,3,2678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-12','2020-11-12',5051.25,NULL,NULL,1,'2021-08-20 19:03:30','2021-08-20 19:03:30',NULL),(2679,2978,40866,43996,3,2679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-12','2020-11-12',8106.95,NULL,NULL,1,'2021-08-20 19:03:30','2021-08-20 19:03:30',NULL),(2680,2978,40866,43992,3,2680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-13','2020-07-13',3315.26,NULL,NULL,1,'2021-08-20 19:04:32','2021-08-20 19:04:32',NULL),(2681,2978,40866,43997,3,2681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-12','2020-12-12',3079.25,NULL,NULL,1,'2021-08-20 19:05:49','2021-08-20 19:05:49',NULL),(2682,2978,40866,43997,3,2682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-12','2020-12-12',2318.34,NULL,NULL,1,'2021-08-20 19:05:49','2021-08-20 19:05:49',NULL),(2683,2978,40866,33369,3,2683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',4400.77,NULL,NULL,1,'2021-08-20 19:13:11','2021-08-20 19:13:11',NULL),(2684,2978,40866,33369,3,2684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',8076.32,NULL,NULL,1,'2021-08-20 19:13:11','2021-08-20 19:13:11',NULL),(2685,2978,40866,33370,3,2685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-06','2021-02-06',3002.49,NULL,NULL,1,'2021-08-20 19:22:41','2021-08-20 19:22:41',NULL);
INSERT INTO `balance_libro` VALUES (2686,2978,40866,33370,3,2686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-16','2021-02-16',12542.70,NULL,NULL,1,'2021-08-20 19:22:41','2021-08-20 19:22:41',NULL),(2687,2978,40866,33370,3,2687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',6715.34,NULL,NULL,1,'2021-08-20 19:22:41','2021-08-20 19:22:41',NULL),(2688,2978,40866,33370,3,2688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',2589.06,NULL,NULL,1,'2021-08-20 19:22:41','2021-08-20 19:22:41',NULL),(2689,2978,40866,33370,3,2689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',3156.84,NULL,NULL,1,'2021-08-20 19:22:41','2021-08-20 19:22:41',NULL),(2690,2978,40866,33371,3,2690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',2104.14,NULL,NULL,1,'2021-08-20 19:24:06','2021-08-20 19:24:06',NULL),(2691,2978,40866,33371,3,2691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',499.00,NULL,NULL,1,'2021-08-20 19:24:06','2021-08-20 19:24:06',NULL),(2692,2978,40866,33371,3,2692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',13319.88,NULL,NULL,1,'2021-08-20 19:24:06','2021-08-20 19:24:06',NULL),(2693,2978,40866,33371,3,2693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',8111.20,NULL,NULL,1,'2021-08-20 19:24:06','2021-08-20 19:24:06',NULL),(2694,2978,40866,33372,3,2694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',6057.52,NULL,NULL,1,'2021-08-20 19:31:19','2021-08-20 19:31:19',NULL),(2695,2978,40866,33372,3,2695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',3557.51,NULL,NULL,1,'2021-08-20 19:31:19','2021-08-20 19:31:19',NULL),(2696,2978,40866,33373,3,2696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',836.94,NULL,NULL,1,'2021-08-20 19:35:37','2021-08-20 19:35:37',NULL),(2697,2978,40866,33374,3,2697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',7442.03,NULL,NULL,1,'2021-08-20 19:40:06','2021-08-20 19:40:06',NULL),(2698,2978,40866,33374,3,2698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',4893.05,NULL,NULL,1,'2021-08-20 19:40:06','2021-08-20 19:40:06',NULL),(2699,2978,40866,33375,3,2699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',1308.62,NULL,NULL,1,'2021-08-20 19:41:30','2021-08-20 19:41:30',NULL),(2700,2978,40866,33375,3,2700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',300.00,NULL,NULL,1,'2021-08-20 19:41:30','2021-08-20 19:41:30',NULL),(2701,2978,40866,33375,3,2701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',6022.41,NULL,NULL,1,'2021-08-20 19:41:30','2021-08-20 19:41:30',NULL),(2702,2978,40866,33375,3,2702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',7640.78,NULL,NULL,1,'2021-08-20 19:41:30','2021-08-20 19:41:30',NULL),(2703,2978,40866,33375,2,2703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',2500.00,NULL,NULL,1,'2021-08-20 19:45:36','2021-08-20 19:45:36',NULL),(2704,2978,40866,33375,2,2704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',2800.00,NULL,NULL,1,'2021-08-20 19:45:36','2021-08-20 19:45:36',NULL),(2705,2978,40866,33375,2,2705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',3450.00,NULL,NULL,1,'2021-08-20 19:45:36','2021-08-20 19:45:36',NULL),(2706,2978,40866,33375,2,2706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',3450.00,NULL,NULL,1,'2021-08-20 19:45:36','2021-08-20 19:45:36',NULL),(2707,2978,40866,33375,2,2707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',2500.00,NULL,NULL,1,'2021-08-20 19:45:36','2021-08-20 19:45:36',NULL),(2708,2978,40866,33375,2,2708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',3200.00,NULL,NULL,1,'2021-08-20 19:45:36','2021-08-20 19:45:36',NULL),(2709,2978,40866,33375,2,2709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',2500.00,NULL,NULL,1,'2021-08-20 19:45:36','2021-08-20 19:45:36',NULL);
INSERT INTO `balance_libro` VALUES (2710,2978,40866,33375,2,2710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',3200.00,NULL,NULL,1,'2021-08-20 19:45:36','2021-08-20 19:45:36',NULL),(2711,2978,40866,33375,2,2711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',3200.00,NULL,NULL,1,'2021-08-20 19:45:36','2021-08-20 19:45:36',NULL),(2712,2978,40866,33375,2,2712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',3200.00,NULL,NULL,1,'2021-08-20 19:45:36','2021-08-20 19:45:36',NULL),(2713,2978,40866,33375,2,2713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',2200.00,NULL,NULL,1,'2021-08-20 19:45:36','2021-08-20 19:45:36',NULL),(2714,2978,40866,33375,2,2714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',2200.00,NULL,NULL,1,'2021-08-20 19:45:36','2021-08-20 19:45:36',NULL),(2715,2978,40866,33375,2,2715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',2200.00,NULL,NULL,1,'2021-08-20 19:45:36','2021-08-20 19:45:36',NULL),(2716,2978,40866,33375,2,2716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',3450.00,NULL,NULL,1,'2021-08-20 19:45:36','2021-08-20 19:45:36',NULL),(2717,2978,40866,33375,2,2717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',2800.00,NULL,NULL,1,'2021-08-20 19:45:36','2021-08-20 19:45:36',NULL),(2718,2978,40867,34890,2,2718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',49515.00,NULL,NULL,1,'2021-08-24 16:08:11','2021-08-24 16:08:11',NULL),(2719,2978,40867,44008,3,2719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-05','2020-08-05',29999.00,NULL,NULL,1,'2021-08-24 16:12:52','2021-08-24 16:12:52',NULL),(2720,2978,40867,44008,3,2720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-24','2020-08-24',8889.00,NULL,NULL,1,'2021-08-24 16:12:52','2021-08-24 16:12:52',NULL),(2721,2978,40867,44009,3,2721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-14','2020-09-14',4220.93,NULL,NULL,1,'2021-08-24 16:13:35','2021-08-24 16:13:35',NULL),(2722,2978,40867,44009,3,2722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-16','2020-09-16',503.70,NULL,NULL,1,'2021-08-24 16:13:35','2021-08-24 16:13:35',NULL),(2723,2978,40867,44009,3,2723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-18','2020-09-18',1156.35,NULL,NULL,1,'2021-08-24 16:13:35','2021-08-24 16:13:35',NULL),(2724,2978,40867,44009,3,2724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-24','2020-09-24',950.00,NULL,NULL,1,'2021-08-24 16:13:35','2021-08-24 16:13:35',NULL),(2725,2978,40867,44009,3,2725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-24','2020-09-24',950.00,NULL,NULL,1,'2021-08-24 16:13:35','2021-08-24 16:13:35',NULL),(2726,2978,40867,44009,3,2726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-25','2020-09-25',465.00,NULL,NULL,1,'2021-08-24 16:13:35','2021-08-24 16:13:35',NULL),(2727,2978,40867,44010,3,2727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-14','2020-10-14',771.25,NULL,NULL,1,'2021-08-24 16:14:34','2021-08-24 16:14:34',NULL),(2728,2978,40867,44012,3,2728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-28','2020-12-28',9000.00,NULL,NULL,1,'2021-08-24 16:16:19','2021-08-24 16:16:19',NULL),(2729,2978,40867,44011,3,2729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-02','2020-11-02',2029.99,NULL,NULL,1,'2021-08-24 16:20:32','2021-08-24 16:20:32',NULL),(2730,2978,40867,44011,3,2730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-05','2020-11-05',259.00,NULL,NULL,1,'2021-08-24 16:20:32','2021-08-24 16:20:32',NULL),(2731,2978,40867,44011,3,2731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-06','2020-11-06',4998.00,NULL,NULL,1,'2021-08-24 16:20:32','2021-08-24 16:20:32',NULL),(2732,2978,40867,44011,3,2732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-08','2020-11-08',125.01,NULL,NULL,1,'2021-08-24 16:20:32','2021-08-24 16:20:32',NULL),(2733,2978,40867,44011,3,2733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-09','2020-11-09',1859.77,NULL,NULL,1,'2021-08-24 16:20:32','2021-08-24 16:20:32',NULL);
INSERT INTO `balance_libro` VALUES (2734,2978,40867,44011,3,2734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-11','2020-11-11',1290.00,NULL,NULL,1,'2021-08-24 16:20:32','2021-08-24 16:20:32',NULL),(2735,2978,40867,44011,3,2735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-23','2020-11-23',4681.17,NULL,NULL,1,'2021-08-24 16:20:32','2021-08-24 16:20:32',NULL),(2736,2978,40867,34884,3,2736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',5999.00,NULL,NULL,1,'2021-08-24 19:37:39','2021-08-24 19:37:39',NULL),(2737,2978,40867,34885,3,2737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',8452.56,NULL,NULL,1,'2021-08-24 19:38:27','2021-08-24 19:38:27',NULL),(2738,2978,40867,34885,3,2738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-15','2021-02-15',6140.96,NULL,NULL,1,'2021-08-24 19:38:27','2021-08-24 19:38:27',NULL),(2739,2978,40867,34886,3,2739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',4698.98,NULL,NULL,1,'2021-08-24 19:39:52','2021-08-24 19:39:52',NULL),(2740,2978,40867,34886,3,2740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',0.57,NULL,NULL,1,'2021-08-24 19:39:52','2021-08-24 19:39:52',NULL),(2741,2978,40867,34887,3,2741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',2590.00,NULL,NULL,1,'2021-08-24 19:40:41','2021-08-24 19:40:41',NULL),(2742,2978,40867,34887,3,2742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',427.77,NULL,NULL,1,'2021-08-24 19:40:41','2021-08-24 19:40:41',NULL),(2743,2978,40867,34887,3,2743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',1472.80,NULL,NULL,1,'2021-08-24 19:40:41','2021-08-24 19:40:41',NULL),(2744,2978,40867,34887,3,2744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',2099.00,NULL,NULL,1,'2021-08-24 19:40:41','2021-08-24 19:40:41',NULL),(2745,2978,40867,34889,3,2745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',5651.66,NULL,NULL,1,'2021-08-24 19:45:07','2021-08-24 19:45:07',NULL),(2746,2978,40867,34890,3,2746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',6199.00,NULL,NULL,1,'2021-08-24 19:47:12','2021-08-24 19:47:12',NULL),(2747,2978,40867,34890,3,2747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',1998.00,NULL,NULL,1,'2021-08-24 19:47:12','2021-08-24 19:47:12',NULL),(2748,2978,40871,44037,3,2748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-09','2020-07-09',4045.00,NULL,NULL,1,'2021-08-24 19:54:38','2021-08-24 19:54:38',NULL),(2749,2978,40871,44037,3,2749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-22','2020-07-22',120.00,NULL,NULL,1,'2021-08-24 19:54:38','2021-08-24 19:54:38',NULL),(2750,2978,40871,44037,3,2750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-22','2020-07-22',460.00,NULL,NULL,1,'2021-08-24 19:54:38','2021-08-24 19:54:38',NULL),(2751,2978,40871,44037,3,2751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-22','2020-07-22',598.20,NULL,NULL,1,'2021-08-24 19:54:38','2021-08-24 19:54:38',NULL),(2752,2978,40871,44037,3,2752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-23','2020-07-23',31.92,NULL,NULL,1,'2021-08-24 19:54:38','2021-08-24 19:54:38',NULL),(2753,2978,40871,44037,3,2753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-26','2020-07-26',10101.00,NULL,NULL,1,'2021-08-24 19:54:38','2021-08-24 19:54:38',NULL),(2754,2978,40871,44037,3,2754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-27','2020-07-27',7747.86,NULL,NULL,1,'2021-08-24 19:54:38','2021-08-24 19:54:38',NULL),(2755,2978,40871,44037,3,2755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',710.00,NULL,NULL,1,'2021-08-24 19:54:38','2021-08-24 19:54:38',NULL),(2756,2978,40871,44037,3,2756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',940.00,NULL,NULL,1,'2021-08-24 19:54:38','2021-08-24 19:54:38',NULL),(2757,2978,40871,44038,3,2757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-03','2020-08-03',20000.00,NULL,NULL,1,'2021-08-24 19:55:17','2021-08-24 19:55:17',NULL);
INSERT INTO `balance_libro` VALUES (2758,2978,40871,44038,3,2758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-05','2020-08-05',857.00,NULL,NULL,1,'2021-08-24 19:55:17','2021-08-24 19:55:17',NULL),(2759,2978,40871,44038,3,2759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-10','2020-08-10',0.00,NULL,NULL,1,'2021-08-24 19:55:17','2021-08-24 19:55:17',NULL),(2760,2978,40871,44038,3,2760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-10','2020-08-10',0.00,NULL,NULL,1,'2021-08-24 19:55:17','2021-08-24 19:55:17',NULL),(2761,2978,40871,44038,3,2761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-10','2020-08-10',0.00,NULL,NULL,1,'2021-08-24 19:55:17','2021-08-24 19:55:17',NULL),(2762,2978,40871,44038,3,2762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-10','2020-08-10',0.00,NULL,NULL,1,'2021-08-24 19:55:17','2021-08-24 19:55:17',NULL),(2763,2978,40871,44038,3,2763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-10','2020-08-10',0.00,NULL,NULL,1,'2021-08-24 19:55:18','2021-08-24 19:55:18',NULL),(2764,2978,40871,44038,3,2764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-10','2020-08-10',0.00,NULL,NULL,1,'2021-08-24 19:55:18','2021-08-24 19:55:18',NULL),(2765,2978,40871,44038,3,2765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-10','2020-08-10',5292.27,NULL,NULL,1,'2021-08-24 19:55:18','2021-08-24 19:55:18',NULL),(2766,2978,40871,44038,3,2766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-10','2020-08-10',5292.27,NULL,NULL,1,'2021-08-24 19:55:18','2021-08-24 19:55:18',NULL),(2767,2978,40871,44038,3,2767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-10','2020-08-10',5292.27,NULL,NULL,1,'2021-08-24 19:55:18','2021-08-24 19:55:18',NULL),(2768,2978,40871,44038,3,2768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-11','2020-08-11',1060.00,NULL,NULL,1,'2021-08-24 19:55:18','2021-08-24 19:55:18',NULL),(2769,2978,40871,44038,3,2769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-18','2020-08-18',2935.52,NULL,NULL,1,'2021-08-24 19:55:18','2021-08-24 19:55:18',NULL),(2770,2978,40871,44038,3,2770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-20','2020-08-20',120.00,NULL,NULL,1,'2021-08-24 19:55:18','2021-08-24 19:55:18',NULL),(2771,2978,40871,44038,3,2771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-20','2020-08-20',460.00,NULL,NULL,1,'2021-08-24 19:55:18','2021-08-24 19:55:18',NULL),(2772,2978,40871,44038,3,2772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-20','2020-08-20',474.00,NULL,NULL,1,'2021-08-24 19:55:18','2021-08-24 19:55:18',NULL),(2773,2978,40871,44038,3,2773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-21','2020-08-21',1000.00,NULL,NULL,1,'2021-08-24 19:55:18','2021-08-24 19:55:18',NULL),(2774,2978,40871,44038,3,2774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-21','2020-08-21',1439.17,NULL,NULL,1,'2021-08-24 19:55:18','2021-08-24 19:55:18',NULL),(2775,2978,40871,44038,3,2775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-25','2020-08-25',2190.00,NULL,NULL,1,'2021-08-24 19:55:18','2021-08-24 19:55:18',NULL),(2776,2978,40871,44038,3,2776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-25','2020-08-25',490.66,NULL,NULL,1,'2021-08-24 19:55:18','2021-08-24 19:55:18',NULL),(2777,2978,40871,44038,3,2777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-26','2020-08-26',11674.48,NULL,NULL,1,'2021-08-24 19:55:18','2021-08-24 19:55:18',NULL),(2778,2978,40871,44038,3,2778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-27','2020-08-27',11212.00,NULL,NULL,1,'2021-08-24 19:55:18','2021-08-24 19:55:18',NULL),(2779,2978,40871,44038,3,2779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',2590.00,NULL,NULL,1,'2021-08-24 19:55:18','2021-08-24 19:55:18',NULL),(2780,2978,40871,44038,3,2780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',630.00,NULL,NULL,1,'2021-08-24 19:55:18','2021-08-24 19:55:18',NULL),(2781,2978,40871,44038,3,2781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',2130.00,NULL,NULL,1,'2021-08-24 19:55:18','2021-08-24 19:55:18',NULL);
INSERT INTO `balance_libro` VALUES (2782,2978,40871,44038,3,2782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',1446.70,NULL,NULL,1,'2021-08-24 19:55:18','2021-08-24 19:55:18',NULL),(2783,2978,40871,44039,3,2783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-02','2020-09-02',38610.00,NULL,NULL,1,'2021-08-24 19:56:05','2021-08-24 19:56:05',NULL),(2784,2978,40871,44039,3,2784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-02','2020-09-02',55800.00,NULL,NULL,1,'2021-08-24 19:56:05','2021-08-24 19:56:05',NULL),(2785,2978,40871,44039,3,2785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-09','2020-09-09',7351.60,NULL,NULL,1,'2021-08-24 19:56:05','2021-08-24 19:56:05',NULL),(2786,2978,40871,44039,3,2786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-11','2020-09-11',990.00,NULL,NULL,1,'2021-08-24 19:56:05','2021-08-24 19:56:05',NULL),(2787,2978,40871,44039,3,2787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-12','2020-09-12',1627.82,NULL,NULL,1,'2021-08-24 19:56:05','2021-08-24 19:56:05',NULL),(2788,2978,40871,44039,3,2788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-14','2020-09-14',172.10,NULL,NULL,1,'2021-08-24 19:56:05','2021-08-24 19:56:05',NULL),(2789,2978,40871,44039,3,2789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-16','2020-09-16',3481.52,NULL,NULL,1,'2021-08-24 19:56:05','2021-08-24 19:56:05',NULL),(2790,2978,40871,44039,3,2790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-16','2020-09-16',2585.04,NULL,NULL,1,'2021-08-24 19:56:05','2021-08-24 19:56:05',NULL),(2791,2978,40871,44039,3,2791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-17','2020-09-17',229.51,NULL,NULL,1,'2021-08-24 19:56:05','2021-08-24 19:56:05',NULL),(2792,2978,40871,44039,3,2792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-17','2020-09-17',5466.16,NULL,NULL,1,'2021-08-24 19:56:05','2021-08-24 19:56:05',NULL),(2793,2978,40871,44039,3,2793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-18','2020-09-18',12366.48,NULL,NULL,1,'2021-08-24 19:56:05','2021-08-24 19:56:05',NULL),(2794,2978,40871,44039,3,2794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-21','2020-09-21',15031.00,NULL,NULL,1,'2021-08-24 19:56:05','2021-08-24 19:56:05',NULL),(2795,2978,40871,44039,3,2795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-21','2020-09-21',938.89,NULL,NULL,1,'2021-08-24 19:56:05','2021-08-24 19:56:05',NULL),(2796,2978,40871,44039,3,2796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-22','2020-09-22',120.00,NULL,NULL,1,'2021-08-24 19:56:05','2021-08-24 19:56:05',NULL),(2797,2978,40871,44039,3,2797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-22','2020-09-22',99.00,NULL,NULL,1,'2021-08-24 19:56:05','2021-08-24 19:56:05',NULL),(2798,2978,40871,44039,3,2798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-22','2020-09-22',622.50,NULL,NULL,1,'2021-08-24 19:56:06','2021-08-24 19:56:06',NULL),(2799,2978,40871,44039,3,2799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-23','2020-09-23',4592.50,NULL,NULL,1,'2021-08-24 19:56:06','2021-08-24 19:56:06',NULL),(2800,2978,40871,44039,3,2800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-24','2020-09-24',9524.00,NULL,NULL,1,'2021-08-24 19:56:06','2021-08-24 19:56:06',NULL),(2801,2978,40871,44039,3,2801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-24','2020-09-24',1067.24,NULL,NULL,1,'2021-08-24 19:56:06','2021-08-24 19:56:06',NULL),(2802,2978,40871,44039,3,2802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-24','2020-09-24',1698.20,NULL,NULL,1,'2021-08-24 19:56:06','2021-08-24 19:56:06',NULL),(2803,2978,40871,44039,3,2803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-26','2020-09-26',500.00,NULL,NULL,1,'2021-08-24 19:56:06','2021-08-24 19:56:06',NULL),(2804,2978,40871,44039,3,2804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-26','2020-09-26',23435.98,NULL,NULL,1,'2021-08-24 19:56:06','2021-08-24 19:56:06',NULL),(2805,2978,40871,44039,3,2805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-28','2020-09-28',11888.25,NULL,NULL,1,'2021-08-24 19:56:06','2021-08-24 19:56:06',NULL);
INSERT INTO `balance_libro` VALUES (2806,2978,40871,44039,3,2806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-29','2020-09-29',2014.17,NULL,NULL,1,'2021-08-24 19:56:06','2021-08-24 19:56:06',NULL),(2807,2978,40871,44039,3,2807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-29','2020-09-29',2281.00,NULL,NULL,1,'2021-08-24 19:56:06','2021-08-24 19:56:06',NULL),(2808,2978,40871,44039,3,2808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',550.00,NULL,NULL,1,'2021-08-24 19:56:06','2021-08-24 19:56:06',NULL),(2809,2978,40871,44039,3,2809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',4629.91,NULL,NULL,1,'2021-08-24 19:56:06','2021-08-24 19:56:06',NULL),(2810,2978,40871,44040,3,2810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-05','2020-10-05',4000.00,NULL,NULL,1,'2021-08-24 19:56:54','2021-08-24 19:56:54',NULL),(2811,2978,40871,44040,3,2811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-14','2020-10-14',4219.28,NULL,NULL,1,'2021-08-24 19:56:54','2021-08-24 19:56:54',NULL),(2812,2978,40871,44040,3,2812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-15','2020-10-15',800.00,NULL,NULL,1,'2021-08-24 19:56:54','2021-08-24 19:56:54',NULL),(2813,2978,40871,44040,3,2813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-15','2020-10-15',2612.15,NULL,NULL,1,'2021-08-24 19:56:54','2021-08-24 19:56:54',NULL),(2814,2978,40871,44040,3,2814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-16','2020-10-16',1853.22,NULL,NULL,1,'2021-08-24 19:56:54','2021-08-24 19:56:54',NULL),(2815,2978,40871,44040,3,2815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-18','2020-10-18',547.51,NULL,NULL,1,'2021-08-24 19:56:54','2021-08-24 19:56:54',NULL),(2816,2978,40871,44040,3,2816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-19','2020-10-19',1800.00,NULL,NULL,1,'2021-08-24 19:56:54','2021-08-24 19:56:54',NULL),(2817,2978,40871,44040,3,2817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-20','2020-10-20',268.80,NULL,NULL,1,'2021-08-24 19:56:54','2021-08-24 19:56:54',NULL),(2818,2978,40871,44040,3,2818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-20','2020-10-20',2329.99,NULL,NULL,1,'2021-08-24 19:56:54','2021-08-24 19:56:54',NULL),(2819,2978,40871,44040,3,2819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-20','2020-10-20',3720.97,NULL,NULL,1,'2021-08-24 19:56:54','2021-08-24 19:56:54',NULL),(2820,2978,40871,44040,3,2820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-21','2020-10-21',120.00,NULL,NULL,1,'2021-08-24 19:56:55','2021-08-24 19:56:55',NULL),(2821,2978,40871,44040,3,2821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-21','2020-10-21',99.00,NULL,NULL,1,'2021-08-24 19:56:55','2021-08-24 19:56:55',NULL),(2822,2978,40871,44040,3,2822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-22','2020-10-22',1666.59,NULL,NULL,1,'2021-08-24 19:56:55','2021-08-24 19:56:55',NULL),(2823,2978,40871,44040,3,2823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-24','2020-10-24',1582.10,NULL,NULL,1,'2021-08-24 19:56:55','2021-08-24 19:56:55',NULL),(2824,2978,40871,44040,3,2824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-26','2020-10-26',32167.05,NULL,NULL,1,'2021-08-24 19:56:55','2021-08-24 19:56:55',NULL),(2825,2978,40871,44040,3,2825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-27','2020-10-27',10656.75,NULL,NULL,1,'2021-08-24 19:56:55','2021-08-24 19:56:55',NULL),(2826,2978,40871,44040,3,2826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-28','2020-10-28',500.00,NULL,NULL,1,'2021-08-24 19:56:55','2021-08-24 19:56:55',NULL),(2827,2978,40871,44040,3,2827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-30','2020-10-30',9312.05,NULL,NULL,1,'2021-08-24 19:56:55','2021-08-24 19:56:55',NULL),(2828,2978,40871,44040,3,2828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',630.00,NULL,NULL,1,'2021-08-24 19:56:55','2021-08-24 19:56:55',NULL),(2829,2978,40871,44040,3,2829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',1726.00,NULL,NULL,1,'2021-08-24 19:56:55','2021-08-24 19:56:55',NULL);
INSERT INTO `balance_libro` VALUES (2830,2978,40871,44041,3,2830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-02','2020-11-02',3999.00,NULL,NULL,1,'2021-08-24 19:57:37','2021-08-24 19:57:37',NULL),(2831,2978,40871,44041,3,2831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-02','2020-11-02',5299.00,NULL,NULL,1,'2021-08-24 19:57:37','2021-08-24 19:57:37',NULL),(2832,2978,40871,44041,3,2832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-02','2020-11-02',6311.58,NULL,NULL,1,'2021-08-24 19:57:37','2021-08-24 19:57:37',NULL),(2833,2978,40871,44041,3,2833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-05','2020-11-05',1108.12,NULL,NULL,1,'2021-08-24 19:57:37','2021-08-24 19:57:37',NULL),(2834,2978,40871,44041,3,2834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-09','2020-11-09',3568.44,NULL,NULL,1,'2021-08-24 19:57:37','2021-08-24 19:57:37',NULL),(2835,2978,40871,44041,3,2835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-11','2020-11-11',3720.00,NULL,NULL,1,'2021-08-24 19:57:37','2021-08-24 19:57:37',NULL),(2836,2978,40871,44041,3,2836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-12','2020-11-12',3610.21,NULL,NULL,1,'2021-08-24 19:57:37','2021-08-24 19:57:37',NULL),(2837,2978,40871,44041,3,2837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-16','2020-11-16',2235.18,NULL,NULL,1,'2021-08-24 19:57:37','2021-08-24 19:57:37',NULL),(2838,2978,40871,44041,3,2838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-16','2020-11-16',5509.86,NULL,NULL,1,'2021-08-24 19:57:37','2021-08-24 19:57:37',NULL),(2839,2978,40871,44041,3,2839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-17','2020-11-17',217.80,NULL,NULL,1,'2021-08-24 19:57:37','2021-08-24 19:57:37',NULL),(2840,2978,40871,44041,3,2840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-18','2020-11-18',525.00,NULL,NULL,1,'2021-08-24 19:57:37','2021-08-24 19:57:37',NULL),(2841,2978,40871,44041,3,2841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',217.50,NULL,NULL,1,'2021-08-24 19:57:37','2021-08-24 19:57:37',NULL),(2842,2978,40871,44041,3,2842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-21','2020-11-21',120.00,NULL,NULL,1,'2021-08-24 19:57:37','2021-08-24 19:57:37',NULL),(2843,2978,40871,44041,3,2843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-21','2020-11-21',99.00,NULL,NULL,1,'2021-08-24 19:57:37','2021-08-24 19:57:37',NULL),(2844,2978,40871,44041,3,2844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-23','2020-11-23',5266.20,NULL,NULL,1,'2021-08-24 19:57:37','2021-08-24 19:57:37',NULL),(2845,2978,40871,44041,3,2845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-24','2020-11-24',1201.20,NULL,NULL,1,'2021-08-24 19:57:37','2021-08-24 19:57:37',NULL),(2846,2978,40871,44041,3,2846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-24','2020-11-24',1197.66,NULL,NULL,1,'2021-08-24 19:57:37','2021-08-24 19:57:37',NULL),(2847,2978,40871,44041,3,2847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-25','2020-11-25',499.00,NULL,NULL,1,'2021-08-24 19:57:37','2021-08-24 19:57:37',NULL),(2848,2978,40871,44041,3,2848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-27','2020-11-27',10656.75,NULL,NULL,1,'2021-08-24 19:57:37','2021-08-24 19:57:37',NULL),(2849,2978,40871,44041,3,2849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-27','2020-11-27',5000.00,NULL,NULL,1,'2021-08-24 19:57:37','2021-08-24 19:57:37',NULL),(2850,2978,40871,44041,3,2850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',690.00,NULL,NULL,1,'2021-08-24 19:57:37','2021-08-24 19:57:37',NULL),(2851,2978,40871,44041,3,2851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',1231.00,NULL,NULL,1,'2021-08-24 19:57:37','2021-08-24 19:57:37',NULL),(2852,2978,40871,44041,3,2852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',7691.01,NULL,NULL,1,'2021-08-24 19:57:37','2021-08-24 19:57:37',NULL),(2853,2978,40871,44042,3,2853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-02','2020-12-02',1054.49,NULL,NULL,1,'2021-08-24 20:00:44','2021-08-24 20:00:44',NULL);
INSERT INTO `balance_libro` VALUES (2854,2978,40871,44042,3,2854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-03','2020-12-03',8525.04,NULL,NULL,1,'2021-08-24 20:00:44','2021-08-24 20:00:44',NULL),(2855,2978,40871,44042,3,2855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-05','2020-12-05',502.88,NULL,NULL,1,'2021-08-24 20:00:44','2021-08-24 20:00:44',NULL),(2856,2978,40871,44042,3,2856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-07','2020-12-07',6637.77,NULL,NULL,1,'2021-08-24 20:00:44','2021-08-24 20:00:44',NULL),(2857,2978,40871,44042,3,2857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-14','2020-12-14',199.65,NULL,NULL,1,'2021-08-24 20:00:45','2021-08-24 20:00:45',NULL),(2858,2978,40871,44042,3,2858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-14','2020-12-14',4016.46,NULL,NULL,1,'2021-08-24 20:00:45','2021-08-24 20:00:45',NULL),(2859,2978,40871,44042,3,2859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-15','2020-12-15',614.00,NULL,NULL,1,'2021-08-24 20:00:45','2021-08-24 20:00:45',NULL),(2860,2978,40871,44042,3,2860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-15','2020-12-15',2253.07,NULL,NULL,1,'2021-08-24 20:00:45','2021-08-24 20:00:45',NULL),(2861,2978,40871,44042,3,2861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-16','2020-12-16',6493.50,NULL,NULL,1,'2021-08-24 20:00:45','2021-08-24 20:00:45',NULL),(2862,2978,40871,44042,3,2862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-18','2020-12-18',140.00,NULL,NULL,1,'2021-08-24 20:00:45','2021-08-24 20:00:45',NULL),(2863,2978,40871,44042,3,2863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-18','2020-12-18',99.00,NULL,NULL,1,'2021-08-24 20:00:45','2021-08-24 20:00:45',NULL),(2864,2978,40871,44042,3,2864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-18','2020-12-18',932.99,NULL,NULL,1,'2021-08-24 20:00:45','2021-08-24 20:00:45',NULL),(2865,2978,40871,44042,3,2865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-18','2020-12-18',11680.00,NULL,NULL,1,'2021-08-24 20:00:45','2021-08-24 20:00:45',NULL),(2866,2978,40871,44042,3,2866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-18','2020-12-18',6353.81,NULL,NULL,1,'2021-08-24 20:00:45','2021-08-24 20:00:45',NULL),(2867,2978,40871,44042,3,2867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-21','2020-12-21',897.82,NULL,NULL,1,'2021-08-24 20:00:45','2021-08-24 20:00:45',NULL),(2868,2978,40871,44042,3,2868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-21','2020-12-21',8976.12,NULL,NULL,1,'2021-08-24 20:00:45','2021-08-24 20:00:45',NULL),(2869,2978,40871,44042,3,2869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-22','2020-12-22',797.90,NULL,NULL,1,'2021-08-24 20:00:45','2021-08-24 20:00:45',NULL),(2870,2978,40871,44042,3,2870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-28','2020-12-28',62488.10,NULL,NULL,1,'2021-08-24 20:00:45','2021-08-24 20:00:45',NULL),(2871,2978,40871,44042,3,2871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-28','2020-12-28',33.80,NULL,NULL,1,'2021-08-24 20:00:45','2021-08-24 20:00:45',NULL),(2872,2978,40871,44042,3,2872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-28','2020-12-28',12062.00,NULL,NULL,1,'2021-08-24 20:00:45','2021-08-24 20:00:45',NULL),(2873,2978,40871,44042,3,2873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-28','2020-12-28',9860.37,NULL,NULL,1,'2021-08-24 20:00:45','2021-08-24 20:00:45',NULL),(2874,2978,40871,44042,3,2874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-29','2020-12-29',33.80,NULL,NULL,1,'2021-08-24 20:00:45','2021-08-24 20:00:45',NULL),(2875,2978,40871,44042,3,2875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',9990.14,NULL,NULL,1,'2021-08-24 20:00:45','2021-08-24 20:00:45',NULL),(2876,2978,40871,44042,3,2876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',780.00,NULL,NULL,1,'2021-08-24 20:00:45','2021-08-24 20:00:45',NULL),(2877,2978,40871,44042,3,2877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',1499.00,NULL,NULL,1,'2021-08-24 20:00:45','2021-08-24 20:00:45',NULL);
INSERT INTO `balance_libro` VALUES (2878,2978,40871,37914,3,2878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',165.30,NULL,NULL,1,'2021-08-24 20:05:01','2021-08-24 20:05:01',NULL),(2879,2978,40871,37914,3,2879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',57.00,NULL,NULL,1,'2021-08-24 20:05:01','2021-08-24 20:05:01',NULL),(2880,2978,40871,37914,3,2880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',2204.73,NULL,NULL,1,'2021-08-24 20:05:01','2021-08-24 20:05:01',NULL),(2881,2978,40871,37914,3,2881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',898.99,NULL,NULL,1,'2021-08-24 20:05:01','2021-08-24 20:05:01',NULL),(2882,2978,40871,37914,3,2882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',500.00,NULL,NULL,1,'2021-08-24 20:05:01','2021-08-24 20:05:01',NULL),(2883,2978,40871,37914,3,2883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-10','2021-01-10',2185.00,NULL,NULL,1,'2021-08-24 20:05:02','2021-08-24 20:05:02',NULL),(2884,2978,40871,37914,3,2884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-10','2021-01-10',824.98,NULL,NULL,1,'2021-08-24 20:05:02','2021-08-24 20:05:02',NULL),(2885,2978,40871,37914,3,2885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',3450.00,NULL,NULL,1,'2021-08-24 20:05:02','2021-08-24 20:05:02',NULL),(2886,2978,40871,37914,3,2886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',206.26,NULL,NULL,1,'2021-08-24 20:05:02','2021-08-24 20:05:02',NULL),(2887,2978,40871,37914,3,2887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',786.26,NULL,NULL,1,'2021-08-24 20:05:02','2021-08-24 20:05:02',NULL),(2888,2978,40871,37914,3,2888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',6928.59,NULL,NULL,1,'2021-08-24 20:05:02','2021-08-24 20:05:02',NULL),(2889,2978,40871,37914,3,2889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',1822.64,NULL,NULL,1,'2021-08-24 20:05:02','2021-08-24 20:05:02',NULL),(2890,2978,40871,37914,3,2890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',3099.00,NULL,NULL,1,'2021-08-24 20:05:02','2021-08-24 20:05:02',NULL),(2891,2978,40871,37914,3,2891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',6896.40,NULL,NULL,1,'2021-08-24 20:05:02','2021-08-24 20:05:02',NULL),(2892,2978,40871,37914,3,2892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',118.50,NULL,NULL,1,'2021-08-24 20:05:02','2021-08-24 20:05:02',NULL),(2893,2978,40871,37914,3,2893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',6732.09,NULL,NULL,1,'2021-08-24 20:05:02','2021-08-24 20:05:02',NULL),(2894,2978,40871,37914,3,2894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',1369.66,NULL,NULL,1,'2021-08-24 20:05:02','2021-08-24 20:05:02',NULL),(2895,2978,40871,37914,3,2895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',1269.00,NULL,NULL,1,'2021-08-24 20:05:02','2021-08-24 20:05:02',NULL),(2896,2978,40871,37914,3,2896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',140.00,NULL,NULL,1,'2021-08-24 20:05:02','2021-08-24 20:05:02',NULL),(2897,2978,40871,37914,3,2897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',99.00,NULL,NULL,1,'2021-08-24 20:05:02','2021-08-24 20:05:02',NULL),(2898,2978,40871,37914,3,2898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',312.08,NULL,NULL,1,'2021-08-24 20:05:02','2021-08-24 20:05:02',NULL),(2899,2978,40871,37914,3,2899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',3630.00,NULL,NULL,1,'2021-08-24 20:05:02','2021-08-24 20:05:02',NULL),(2900,2978,40871,37914,3,2900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',333.96,NULL,NULL,1,'2021-08-24 20:05:02','2021-08-24 20:05:02',NULL),(2901,2978,40871,37914,3,2901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',3799.00,NULL,NULL,1,'2021-08-24 20:05:02','2021-08-24 20:05:02',NULL);
INSERT INTO `balance_libro` VALUES (2902,2978,40871,37914,3,2902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',352.20,NULL,NULL,1,'2021-08-24 20:05:02','2021-08-24 20:05:02',NULL),(2903,2978,40871,37914,3,2903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',13293.00,NULL,NULL,1,'2021-08-24 20:05:02','2021-08-24 20:05:02',NULL),(2904,2978,40871,37914,3,2904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',6610.26,NULL,NULL,1,'2021-08-24 20:05:02','2021-08-24 20:05:02',NULL),(2905,2978,40871,37914,3,2905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',594.00,NULL,NULL,1,'2021-08-24 20:05:02','2021-08-24 20:05:02',NULL),(2906,2978,40871,37915,3,2906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',1439.99,NULL,NULL,1,'2021-08-24 20:05:41','2021-08-24 20:05:41',NULL),(2907,2978,40871,37915,3,2907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',8213.70,NULL,NULL,1,'2021-08-24 20:05:41','2021-08-24 20:05:41',NULL),(2908,2978,40871,37915,3,2908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',1986.98,NULL,NULL,1,'2021-08-24 20:05:41','2021-08-24 20:05:41',NULL),(2909,2978,40871,37915,3,2909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',500.00,NULL,NULL,1,'2021-08-24 20:05:41','2021-08-24 20:05:41',NULL),(2910,2978,40871,37915,3,2910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',536.76,NULL,NULL,1,'2021-08-24 20:05:41','2021-08-24 20:05:41',NULL),(2911,2978,40871,37915,3,2911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',5415.54,NULL,NULL,1,'2021-08-24 20:05:42','2021-08-24 20:05:42',NULL),(2912,2978,40871,37915,3,2912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',2034.64,NULL,NULL,1,'2021-08-24 20:05:42','2021-08-24 20:05:42',NULL),(2913,2978,40871,37915,3,2913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-14','2021-02-14',5329.97,NULL,NULL,1,'2021-08-24 20:05:42','2021-08-24 20:05:42',NULL),(2914,2978,40871,37915,3,2914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-15','2021-02-15',79728.75,NULL,NULL,1,'2021-08-24 20:05:42','2021-08-24 20:05:42',NULL),(2915,2978,40871,37915,3,2915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-15','2021-02-15',6209.40,NULL,NULL,1,'2021-08-24 20:05:42','2021-08-24 20:05:42',NULL),(2916,2978,40871,37915,3,2916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',90.10,NULL,NULL,1,'2021-08-24 20:05:42','2021-08-24 20:05:42',NULL),(2917,2978,40871,37915,3,2917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',2189.26,NULL,NULL,1,'2021-08-24 20:05:42','2021-08-24 20:05:42',NULL),(2918,2978,40871,37915,3,2918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-21','2021-02-21',514.80,NULL,NULL,1,'2021-08-24 20:05:42','2021-08-24 20:05:42',NULL),(2919,2978,40871,37915,3,2919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',140.00,NULL,NULL,1,'2021-08-24 20:05:42','2021-08-24 20:05:42',NULL),(2920,2978,40871,37915,3,2920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',99.00,NULL,NULL,1,'2021-08-24 20:05:42','2021-08-24 20:05:42',NULL),(2921,2978,40871,37915,3,2921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',4429.11,NULL,NULL,1,'2021-08-24 20:05:42','2021-08-24 20:05:42',NULL),(2922,2978,40871,37915,3,2922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',27253.12,NULL,NULL,1,'2021-08-24 20:05:42','2021-08-24 20:05:42',NULL),(2923,2978,40871,37915,3,2923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',1477.65,NULL,NULL,1,'2021-08-24 20:05:42','2021-08-24 20:05:42',NULL),(2924,2978,40871,37915,3,2924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',1249.98,NULL,NULL,1,'2021-08-24 20:05:42','2021-08-24 20:05:42',NULL),(2925,2978,40871,37915,3,2925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',12062.00,NULL,NULL,1,'2021-08-24 20:05:42','2021-08-24 20:05:42',NULL);
INSERT INTO `balance_libro` VALUES (2926,2978,40871,37915,3,2926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',890.00,NULL,NULL,1,'2021-08-24 20:05:42','2021-08-24 20:05:42',NULL),(2927,2978,40871,37915,3,2927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',313.00,NULL,NULL,1,'2021-08-24 20:05:42','2021-08-24 20:05:42',NULL),(2928,2978,40871,37916,3,2928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',4906.94,NULL,NULL,1,'2021-08-24 20:06:45','2021-08-24 20:06:45',NULL),(2929,2978,40871,37916,3,2929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',6111.15,NULL,NULL,1,'2021-08-24 20:06:45','2021-08-24 20:06:45',NULL),(2930,2978,40871,37916,3,2930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',1243.20,NULL,NULL,1,'2021-08-24 20:06:45','2021-08-24 20:06:45',NULL),(2931,2978,40871,37916,3,2931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',1547.53,NULL,NULL,1,'2021-08-24 20:06:45','2021-08-24 20:06:45',NULL),(2932,2978,40871,37916,3,2932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',3900.00,NULL,NULL,1,'2021-08-24 20:06:45','2021-08-24 20:06:45',NULL),(2933,2978,40871,37916,3,2933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',3957.51,NULL,NULL,1,'2021-08-24 20:06:45','2021-08-24 20:06:45',NULL),(2934,2978,40871,37916,3,2934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',209.58,NULL,NULL,1,'2021-08-24 20:06:45','2021-08-24 20:06:45',NULL),(2935,2978,40871,37916,3,2935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',61.04,NULL,NULL,1,'2021-08-24 20:06:45','2021-08-24 20:06:45',NULL),(2936,2978,40871,37916,3,2936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',302.99,NULL,NULL,1,'2021-08-24 20:06:45','2021-08-24 20:06:45',NULL),(2937,2978,40871,37916,3,2937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-14','2021-03-14',1096.54,NULL,NULL,1,'2021-08-24 20:06:45','2021-08-24 20:06:45',NULL),(2938,2978,40871,37916,3,2938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-14','2021-03-14',5340.00,NULL,NULL,1,'2021-08-24 20:06:45','2021-08-24 20:06:45',NULL),(2939,2978,40871,37916,3,2939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',1717.41,NULL,NULL,1,'2021-08-24 20:06:45','2021-08-24 20:06:45',NULL),(2940,2978,40871,37916,3,2940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',1120.63,NULL,NULL,1,'2021-08-24 20:06:45','2021-08-24 20:06:45',NULL),(2941,2978,40871,37916,3,2941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',75.00,NULL,NULL,1,'2021-08-24 20:06:45','2021-08-24 20:06:45',NULL),(2942,2978,40871,37916,3,2942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',6374.46,NULL,NULL,1,'2021-08-24 20:06:45','2021-08-24 20:06:45',NULL),(2943,2978,40871,37916,3,2943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',140.00,NULL,NULL,1,'2021-08-24 20:06:45','2021-08-24 20:06:45',NULL),(2944,2978,40871,37916,3,2944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',540.00,NULL,NULL,1,'2021-08-24 20:06:45','2021-08-24 20:06:45',NULL),(2945,2978,40871,37916,3,2945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',1798.00,NULL,NULL,1,'2021-08-24 20:06:45','2021-08-24 20:06:45',NULL),(2946,2978,40871,37916,3,2946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',3375.87,NULL,NULL,1,'2021-08-24 20:06:45','2021-08-24 20:06:45',NULL),(2947,2978,40871,37916,3,2947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',790.00,NULL,NULL,1,'2021-08-24 20:06:45','2021-08-24 20:06:45',NULL),(2948,2978,40871,37916,3,2948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',1626.97,NULL,NULL,1,'2021-08-24 20:06:45','2021-08-24 20:06:45',NULL),(2949,2978,40871,37916,3,2949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',1321.32,NULL,NULL,1,'2021-08-24 20:06:45','2021-08-24 20:06:45',NULL);
INSERT INTO `balance_libro` VALUES (2950,2978,40871,37916,3,2950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',1418.00,NULL,NULL,1,'2021-08-24 20:06:45','2021-08-24 20:06:45',NULL),(2951,2978,40871,37917,3,2951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-04','2021-04-04',1469.00,NULL,NULL,1,'2021-08-24 20:07:24','2021-08-24 20:07:24',NULL),(2952,2978,40871,37917,3,2952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',103.55,NULL,NULL,1,'2021-08-24 20:07:24','2021-08-24 20:07:24',NULL),(2953,2978,40871,37917,3,2953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',7946.46,NULL,NULL,1,'2021-08-24 20:07:24','2021-08-24 20:07:24',NULL),(2954,2978,40871,37917,3,2954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',1243.20,NULL,NULL,1,'2021-08-24 20:07:24','2021-08-24 20:07:24',NULL),(2955,2978,40871,37917,3,2955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',1575.39,NULL,NULL,1,'2021-08-24 20:07:25','2021-08-24 20:07:25',NULL),(2956,2978,40871,37917,3,2956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',3797.99,NULL,NULL,1,'2021-08-24 20:07:25','2021-08-24 20:07:25',NULL),(2957,2978,40871,37917,3,2957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',5832.00,NULL,NULL,1,'2021-08-24 20:07:25','2021-08-24 20:07:25',NULL),(2958,2978,40871,37917,3,2958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',4346.58,NULL,NULL,1,'2021-08-24 20:07:25','2021-08-24 20:07:25',NULL),(2959,2978,40871,37917,3,2959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',5553.48,NULL,NULL,1,'2021-08-24 20:07:25','2021-08-24 20:07:25',NULL),(2960,2978,40871,37917,3,2960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',661.66,NULL,NULL,1,'2021-08-24 20:07:25','2021-08-24 20:07:25',NULL),(2961,2978,40871,37917,3,2961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',96.05,NULL,NULL,1,'2021-08-24 20:07:25','2021-08-24 20:07:25',NULL),(2962,2978,40871,37917,3,2962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',8708.88,NULL,NULL,1,'2021-08-24 20:07:25','2021-08-24 20:07:25',NULL),(2963,2978,40871,37917,3,2963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',140.00,NULL,NULL,1,'2021-08-24 20:07:25','2021-08-24 20:07:25',NULL),(2964,2978,40871,37917,3,2964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',280.00,NULL,NULL,1,'2021-08-24 20:07:25','2021-08-24 20:07:25',NULL),(2965,2978,40871,37917,3,2965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',540.00,NULL,NULL,1,'2021-08-24 20:07:25','2021-08-24 20:07:25',NULL),(2966,2978,40871,37917,3,2966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',189.00,NULL,NULL,1,'2021-08-24 20:07:25','2021-08-24 20:07:25',NULL),(2967,2978,40871,37917,3,2967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',314.60,NULL,NULL,1,'2021-08-24 20:07:25','2021-08-24 20:07:25',NULL),(2968,2978,40871,37917,3,2968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',500.00,NULL,NULL,1,'2021-08-24 20:07:25','2021-08-24 20:07:25',NULL),(2969,2978,40871,37917,3,2969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',1015.19,NULL,NULL,1,'2021-08-24 20:07:25','2021-08-24 20:07:25',NULL),(2970,2978,40871,37917,3,2970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',2161.75,NULL,NULL,1,'2021-08-24 20:07:25','2021-08-24 20:07:25',NULL),(2971,2978,40871,37917,3,2971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',4837.83,NULL,NULL,1,'2021-08-24 20:07:25','2021-08-24 20:07:25',NULL),(2972,2978,40871,37917,3,2972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',40500.34,NULL,NULL,1,'2021-08-24 20:07:25','2021-08-24 20:07:25',NULL),(2973,2978,40871,37917,3,2973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',1231.00,NULL,NULL,1,'2021-08-24 20:07:25','2021-08-24 20:07:25',NULL);
INSERT INTO `balance_libro` VALUES (2974,2978,40871,37917,3,2974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',1477.80,NULL,NULL,1,'2021-08-24 20:07:25','2021-08-24 20:07:25',NULL),(2975,2978,40871,37917,3,2975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',3993.00,NULL,NULL,1,'2021-08-24 20:07:25','2021-08-24 20:07:25',NULL),(2976,2978,40871,37917,3,2976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',1243.20,NULL,NULL,1,'2021-08-24 20:07:25','2021-08-24 20:07:25',NULL),(2977,2978,40871,37917,3,2977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',790.00,NULL,NULL,1,'2021-08-24 20:07:25','2021-08-24 20:07:25',NULL),(2978,2978,40871,37917,3,2978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',1097.00,NULL,NULL,1,'2021-08-24 20:07:25','2021-08-24 20:07:25',NULL),(2979,2978,40871,37918,3,2979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',5093.28,NULL,NULL,1,'2021-08-24 20:09:22','2021-08-24 20:09:22',NULL),(2980,2978,40871,37918,3,2980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',570.08,NULL,NULL,1,'2021-08-24 20:09:22','2021-08-24 20:09:22',NULL),(2981,2978,40871,37918,3,2981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',103.55,NULL,NULL,1,'2021-08-24 20:09:23','2021-08-24 20:09:23',NULL),(2982,2978,40871,37918,3,2982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',1430.00,NULL,NULL,1,'2021-08-24 20:09:23','2021-08-24 20:09:23',NULL),(2983,2978,40871,37918,3,2983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',7600.62,NULL,NULL,1,'2021-08-24 20:09:23','2021-08-24 20:09:23',NULL),(2984,2978,40871,37918,3,2984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',8786.90,NULL,NULL,1,'2021-08-24 20:09:23','2021-08-24 20:09:23',NULL),(2985,2978,40871,37918,3,2985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',66999.00,NULL,NULL,1,'2021-08-24 20:09:23','2021-08-24 20:09:23',NULL),(2986,2978,40871,37918,3,2986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',1759.10,NULL,NULL,1,'2021-08-24 20:09:23','2021-08-24 20:09:23',NULL),(2987,2978,40871,37918,3,2987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',1470.60,NULL,NULL,1,'2021-08-24 20:09:23','2021-08-24 20:09:23',NULL),(2988,2978,40871,37918,3,2988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',650.00,NULL,NULL,1,'2021-08-24 20:09:23','2021-08-24 20:09:23',NULL),(2989,2978,40871,37918,3,2989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',30.30,NULL,NULL,1,'2021-08-24 20:09:23','2021-08-24 20:09:23',NULL),(2990,2978,40871,37918,3,2990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',4983.24,NULL,NULL,1,'2021-08-24 20:09:23','2021-08-24 20:09:23',NULL),(2991,2978,40871,37918,3,2991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',1906.70,NULL,NULL,1,'2021-08-24 20:09:23','2021-08-24 20:09:23',NULL),(2992,2978,40871,37918,3,2992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',1414.83,NULL,NULL,1,'2021-08-24 20:09:23','2021-08-24 20:09:23',NULL),(2993,2978,40871,37918,3,2993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',6853.00,NULL,NULL,1,'2021-08-24 20:09:23','2021-08-24 20:09:23',NULL),(2994,2978,40871,37918,3,2994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',310.00,NULL,NULL,1,'2021-08-24 20:09:23','2021-08-24 20:09:23',NULL),(2995,2978,40871,37918,3,2995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',540.00,NULL,NULL,1,'2021-08-24 20:09:23','2021-08-24 20:09:23',NULL),(2996,2978,40871,37918,3,2996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',140.00,NULL,NULL,1,'2021-08-24 20:09:23','2021-08-24 20:09:23',NULL),(2997,2978,40871,37918,3,2997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',4063.00,NULL,NULL,1,'2021-08-24 20:09:23','2021-08-24 20:09:23',NULL);
INSERT INTO `balance_libro` VALUES (2998,2978,40871,37918,3,2998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',315.00,NULL,NULL,1,'2021-08-24 20:09:23','2021-08-24 20:09:23',NULL),(2999,2978,40871,37918,3,2999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',2226.94,NULL,NULL,1,'2021-08-24 20:09:23','2021-08-24 20:09:23',NULL),(3000,2978,40871,37918,3,3000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',5627.76,NULL,NULL,1,'2021-08-24 20:09:23','2021-08-24 20:09:23',NULL),(3001,2978,40871,37918,3,3001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',1243.20,NULL,NULL,1,'2021-08-24 20:09:23','2021-08-24 20:09:23',NULL),(3002,2978,40871,37918,3,3002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',1391.50,NULL,NULL,1,'2021-08-24 20:09:23','2021-08-24 20:09:23',NULL),(3003,2978,40871,37918,3,3003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',1235.00,NULL,NULL,1,'2021-08-24 20:09:23','2021-08-24 20:09:23',NULL),(3004,2978,40871,37918,3,3004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',1030.00,NULL,NULL,1,'2021-08-24 20:09:23','2021-08-24 20:09:23',NULL),(3005,2978,40871,37918,3,3005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',6625.98,NULL,NULL,1,'2021-08-24 20:09:23','2021-08-24 20:09:23',NULL),(3006,2978,40871,44036,3,3006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-03','2020-06-03',6660.00,NULL,NULL,1,'2021-08-24 20:11:38','2021-08-24 20:11:38',NULL),(3007,2978,40871,44036,3,3007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-03','2020-06-03',3996.00,NULL,NULL,1,'2021-08-24 20:11:38','2021-08-24 20:11:38',NULL),(3008,2978,40871,44036,3,3008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-13','2020-06-13',200.00,NULL,NULL,1,'2021-08-24 20:11:38','2021-08-24 20:11:38',NULL),(3009,2978,40871,44036,3,3009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-18','2020-06-18',98.10,NULL,NULL,1,'2021-08-24 20:11:38','2021-08-24 20:11:38',NULL),(3010,2978,40871,44036,3,3010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-23','2020-06-23',714.30,NULL,NULL,1,'2021-08-24 20:11:38','2021-08-24 20:11:38',NULL),(3011,2978,40871,44036,3,3011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-24','2020-06-24',80.00,NULL,NULL,1,'2021-08-24 20:11:38','2021-08-24 20:11:38',NULL),(3012,2978,40871,44036,3,3012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-24','2020-06-24',460.00,NULL,NULL,1,'2021-08-24 20:11:38','2021-08-24 20:11:38',NULL),(3013,2978,40871,44036,3,3013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-25','2020-06-25',10041.00,NULL,NULL,1,'2021-08-24 20:11:38','2021-08-24 20:11:38',NULL),(3014,2978,40871,44036,3,3014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-28','2020-06-28',500.00,NULL,NULL,1,'2021-08-24 20:11:38','2021-08-24 20:11:38',NULL),(3015,2978,40871,44036,3,3015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',630.00,NULL,NULL,1,'2021-08-24 20:11:38','2021-08-24 20:11:38',NULL),(3016,2978,40871,37919,3,3016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',1679.99,NULL,NULL,1,'2021-08-24 20:18:48','2021-08-24 20:18:48',NULL),(3017,2978,40871,37919,3,3017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',1084.16,NULL,NULL,1,'2021-08-24 20:18:48','2021-08-24 20:18:48',NULL),(3018,2978,40871,37919,3,3018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',1097.47,NULL,NULL,1,'2021-08-24 20:18:48','2021-08-24 20:18:48',NULL),(3019,2978,40871,37919,3,3019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',90.10,NULL,NULL,1,'2021-08-24 20:18:48','2021-08-24 20:18:48',NULL),(3020,2978,40871,37919,3,3020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',7050.42,NULL,NULL,1,'2021-08-24 20:18:48','2021-08-24 20:18:48',NULL),(3021,2978,40871,37919,3,3021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',6570.36,NULL,NULL,1,'2021-08-24 20:18:48','2021-08-24 20:18:48',NULL);
INSERT INTO `balance_libro` VALUES (3022,2978,40871,37919,3,3022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',3297.27,NULL,NULL,1,'2021-08-24 20:18:48','2021-08-24 20:18:48',NULL),(3023,2978,40871,37919,3,3023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',2005.07,NULL,NULL,1,'2021-08-24 20:18:48','2021-08-24 20:18:48',NULL),(3024,2978,40871,37919,3,3024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',2796.02,NULL,NULL,1,'2021-08-24 20:18:48','2021-08-24 20:18:48',NULL),(3025,2978,40871,37919,3,3025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',650.00,NULL,NULL,1,'2021-08-24 20:18:48','2021-08-24 20:18:48',NULL),(3026,2978,40871,37919,3,3026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',170.00,NULL,NULL,1,'2021-08-24 20:18:48','2021-08-24 20:18:48',NULL),(3027,2978,40871,37919,3,3027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',540.00,NULL,NULL,1,'2021-08-24 20:18:48','2021-08-24 20:18:48',NULL),(3028,2978,40871,37919,3,3028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',103.55,NULL,NULL,1,'2021-08-24 20:18:48','2021-08-24 20:18:48',NULL),(3029,2978,40871,37919,3,3029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',6890.00,NULL,NULL,1,'2021-08-24 20:18:48','2021-08-24 20:18:48',NULL),(3030,2978,40871,37919,3,3030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',3654.90,NULL,NULL,1,'2021-08-24 20:18:48','2021-08-24 20:18:48',NULL),(3031,2978,40871,37919,3,3031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',1157.08,NULL,NULL,1,'2021-08-24 20:18:48','2021-08-24 20:18:48',NULL),(3032,2978,40871,37919,3,3032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',50.28,NULL,NULL,1,'2021-08-24 20:18:48','2021-08-24 20:18:48',NULL),(3033,2978,40871,37919,3,3033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',133.62,NULL,NULL,1,'2021-08-24 20:18:49','2021-08-24 20:18:49',NULL),(3034,2978,40871,37919,3,3034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',630.00,NULL,NULL,1,'2021-08-24 20:18:49','2021-08-24 20:18:49',NULL),(3035,2978,40871,37919,3,3035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',1439.99,NULL,NULL,1,'2021-08-24 20:18:49','2021-08-24 20:18:49',NULL),(3036,2978,40871,37919,3,3036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',1243.20,NULL,NULL,1,'2021-08-24 20:18:49','2021-08-24 20:18:49',NULL),(3037,2978,40871,37919,3,3037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',100.00,NULL,NULL,1,'2021-08-24 20:18:49','2021-08-24 20:18:49',NULL),(3038,2978,40871,37919,3,3038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',3108.63,NULL,NULL,1,'2021-08-24 20:18:49','2021-08-24 20:18:49',NULL),(3039,2978,40871,37919,3,3039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',910.00,NULL,NULL,1,'2021-08-24 20:18:49','2021-08-24 20:18:49',NULL),(3040,2978,40871,37919,3,3040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',513.00,NULL,NULL,1,'2021-08-24 20:18:49','2021-08-24 20:18:49',NULL),(3041,2978,40871,37920,3,3041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',2883.22,NULL,NULL,1,'2021-08-24 20:19:39','2021-08-24 20:19:39',NULL),(3042,2978,40871,37920,3,3042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',1540.56,NULL,NULL,1,'2021-08-24 20:19:39','2021-08-24 20:19:39',NULL),(3043,2978,40871,37920,3,3043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',5680.95,NULL,NULL,1,'2021-08-24 20:19:39','2021-08-24 20:19:39',NULL),(3044,2978,40871,37920,3,3044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',9.76,NULL,NULL,1,'2021-08-24 20:19:39','2021-08-24 20:19:39',NULL),(3045,2978,40871,37920,3,3045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',4806.39,NULL,NULL,1,'2021-08-24 20:19:39','2021-08-24 20:19:39',NULL);
INSERT INTO `balance_libro` VALUES (3046,2978,40871,37920,3,3046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',99.00,NULL,NULL,1,'2021-08-24 20:19:39','2021-08-24 20:19:39',NULL),(3047,2978,40871,37920,3,3047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',1904.20,NULL,NULL,1,'2021-08-24 20:19:39','2021-08-24 20:19:39',NULL),(3048,2978,40871,37920,3,3048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',113.20,NULL,NULL,1,'2021-08-24 20:19:39','2021-08-24 20:19:39',NULL),(3049,2978,40871,37920,3,3049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',2142.12,NULL,NULL,1,'2021-08-24 20:19:39','2021-08-24 20:19:39',NULL),(3050,2978,40871,37920,3,3050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',129.90,NULL,NULL,1,'2021-08-24 20:19:39','2021-08-24 20:19:39',NULL),(3051,2978,40871,37920,3,3051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',4574.52,NULL,NULL,1,'2021-08-24 20:19:39','2021-08-24 20:19:39',NULL),(3052,2978,40871,37920,3,3052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',170.00,NULL,NULL,1,'2021-08-24 20:19:39','2021-08-24 20:19:39',NULL),(3053,2978,40871,37920,3,3053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',590.00,NULL,NULL,1,'2021-08-24 20:19:39','2021-08-24 20:19:39',NULL),(3054,2978,40871,37920,3,3054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',2725.52,NULL,NULL,1,'2021-08-24 20:19:39','2021-08-24 20:19:39',NULL),(3055,2978,40871,37920,3,3055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',1358.72,NULL,NULL,1,'2021-08-24 20:19:39','2021-08-24 20:19:39',NULL),(3056,2978,40871,37920,3,3056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',181.82,NULL,NULL,1,'2021-08-24 20:19:39','2021-08-24 20:19:39',NULL),(3057,2978,40871,37920,3,3057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',8649.93,NULL,NULL,1,'2021-08-24 20:19:39','2021-08-24 20:19:39',NULL),(3058,2978,40871,37920,3,3058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',44889.00,NULL,NULL,1,'2021-08-24 20:19:39','2021-08-24 20:19:39',NULL),(3059,2978,40871,37920,3,3059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',1789.99,NULL,NULL,1,'2021-08-24 20:19:39','2021-08-24 20:19:39',NULL),(3060,2978,40871,37920,3,3060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1772.40,NULL,NULL,1,'2021-08-24 20:19:40','2021-08-24 20:19:40',NULL),(3061,2978,40871,37920,3,3061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',161.00,NULL,NULL,1,'2021-08-24 20:19:40','2021-08-24 20:19:40',NULL),(3062,2978,40871,37920,3,3062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',910.00,NULL,NULL,1,'2021-08-24 20:19:40','2021-08-24 20:19:40',NULL),(3063,2978,40873,40945,3,3063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',500.00,NULL,NULL,1,'2021-08-24 20:26:19','2021-08-24 20:26:19',NULL),(3064,2978,40873,40945,3,3064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',19250.00,NULL,NULL,1,'2021-08-24 20:26:19','2021-08-24 20:26:19',NULL),(3065,2978,40873,40945,3,3065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',500.00,NULL,NULL,1,'2021-08-24 20:26:19','2021-08-24 20:26:19',NULL),(3066,2978,40873,40946,3,3066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',300.00,NULL,NULL,1,'2021-08-24 20:27:15','2021-08-24 20:27:15',NULL),(3067,2978,40873,40946,3,3067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',180.00,NULL,NULL,1,'2021-08-24 20:27:15','2021-08-24 20:27:15',NULL),(3068,2978,40873,40946,3,3068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',500.00,NULL,NULL,1,'2021-08-24 20:27:15','2021-08-24 20:27:15',NULL),(3069,2978,40873,40946,3,3069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',500.00,NULL,NULL,1,'2021-08-24 20:27:15','2021-08-24 20:27:15',NULL);
INSERT INTO `balance_libro` VALUES (3070,2978,40873,40947,3,3070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',2922.75,NULL,NULL,1,'2021-08-24 20:28:47','2021-08-24 20:28:47',NULL),(3071,2978,40873,40947,3,3071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',189.00,NULL,NULL,1,'2021-08-24 20:28:47','2021-08-24 20:28:47',NULL),(3072,2978,40873,40948,3,3072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',316.00,NULL,NULL,1,'2021-08-24 20:30:30','2021-08-24 20:30:30',NULL),(3073,2978,40873,40948,3,3073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',645.00,NULL,NULL,1,'2021-08-24 20:30:30','2021-08-24 20:30:30',NULL),(3074,2978,40873,40948,3,3074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',500.00,NULL,NULL,1,'2021-08-24 20:30:30','2021-08-24 20:30:30',NULL),(3075,2978,40873,40948,3,3075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',5113.68,NULL,NULL,1,'2021-08-24 20:30:30','2021-08-24 20:30:30',NULL),(3076,2978,40873,40948,3,3076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',2557.89,NULL,NULL,1,'2021-08-24 20:30:31','2021-08-24 20:30:31',NULL),(3077,2978,40873,40948,3,3077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',200.00,NULL,NULL,1,'2021-08-24 20:30:31','2021-08-24 20:30:31',NULL),(3078,2978,40873,40944,3,3078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-01','2021-01-01',5754.86,NULL,NULL,1,'2021-08-24 20:31:52','2021-08-24 20:31:52',NULL),(3079,2978,40873,40944,3,3079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-23','2021-01-23',54.18,NULL,NULL,1,'2021-08-24 20:31:52','2021-08-24 20:31:52',NULL),(3080,2978,40873,40944,3,3080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',500.00,NULL,NULL,1,'2021-08-24 20:31:52','2021-08-24 20:31:52',NULL),(3081,2978,40873,40949,3,3081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',447.63,NULL,NULL,1,'2021-08-24 20:35:02','2021-08-24 20:35:02',NULL),(3082,2978,40873,40949,3,3082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',650.00,NULL,NULL,1,'2021-08-24 20:35:02','2021-08-24 20:35:02',NULL),(3083,2978,40873,40949,3,3083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',90.00,NULL,NULL,1,'2021-08-24 20:35:02','2021-08-24 20:35:02',NULL),(3084,2978,40873,40949,3,3084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',60.00,NULL,NULL,1,'2021-08-24 20:35:02','2021-08-24 20:35:02',NULL),(3085,2978,40873,40949,3,3085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',60.00,NULL,NULL,1,'2021-08-24 20:35:02','2021-08-24 20:35:02',NULL),(3086,2978,40873,40949,3,3086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',90.00,NULL,NULL,1,'2021-08-24 20:35:02','2021-08-24 20:35:02',NULL),(3087,2978,40873,40950,3,3087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',60.00,NULL,NULL,1,'2021-08-24 20:35:47','2021-08-24 20:35:47',NULL),(3088,2978,40873,40950,3,3088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',60.00,NULL,NULL,1,'2021-08-24 20:35:47','2021-08-24 20:35:47',NULL),(3089,2978,40873,40950,3,3089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',60.00,NULL,NULL,1,'2021-08-24 20:35:47','2021-08-24 20:35:47',NULL),(3090,2978,40873,40950,3,3090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',150.00,NULL,NULL,1,'2021-08-24 20:35:47','2021-08-24 20:35:47',NULL),(3091,2978,40873,40950,3,3091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',649.00,NULL,NULL,1,'2021-08-24 20:35:47','2021-08-24 20:35:47',NULL),(3092,2978,40873,40950,3,3092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',400.00,NULL,NULL,1,'2021-08-24 20:35:47','2021-08-24 20:35:47',NULL),(3093,2978,40873,40950,3,3093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',650.00,NULL,NULL,1,'2021-08-24 20:35:47','2021-08-24 20:35:47',NULL);
INSERT INTO `balance_libro` VALUES (3094,2978,40720,43976,3,3094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-03','2020-06-03',25546.00,NULL,NULL,1,'2021-08-24 20:58:53','2021-08-24 20:58:53',NULL),(3095,2978,40720,43976,3,3095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-08','2020-06-08',500.00,NULL,NULL,1,'2021-08-24 20:58:54','2021-08-24 20:58:54',NULL),(3096,2978,40720,43976,3,3096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-17','2020-06-17',2042.00,NULL,NULL,1,'2021-08-24 20:58:54','2021-08-24 20:58:54',NULL),(3097,2978,40720,43977,3,3097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-08','2020-07-08',1307.00,NULL,NULL,1,'2021-08-24 20:59:28','2021-08-24 20:59:28',NULL),(3098,2978,40720,43977,3,3098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-16','2020-07-16',2999.00,NULL,NULL,1,'2021-08-24 20:59:28','2021-08-24 20:59:28',NULL),(3099,2978,40720,43977,3,3099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-20','2020-07-20',400.00,NULL,NULL,1,'2021-08-24 20:59:28','2021-08-24 20:59:28',NULL),(3100,2978,40720,43978,3,3100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-26','2020-08-26',400.00,NULL,NULL,1,'2021-08-24 21:00:06','2021-08-24 21:00:06',NULL),(3101,2978,40720,43979,3,3101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-01','2020-09-01',1186.15,NULL,NULL,1,'2021-08-24 21:00:46','2021-08-24 21:00:46',NULL),(3102,2978,40720,43979,3,3102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-21','2020-09-21',400.00,NULL,NULL,1,'2021-08-24 21:00:46','2021-08-24 21:00:46',NULL),(3103,2978,40720,43979,3,3103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-24','2020-09-24',3390.00,NULL,NULL,1,'2021-08-24 21:00:46','2021-08-24 21:00:46',NULL),(3104,2978,40720,43980,3,3104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-30','2020-10-30',4199.99,NULL,NULL,1,'2021-08-24 21:01:37','2021-08-24 21:01:37',NULL),(3105,2978,40720,43981,3,3105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-02','2020-11-02',3838.74,NULL,NULL,1,'2021-08-24 21:03:09','2021-08-24 21:03:09',NULL),(3106,2978,40720,43981,3,3106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-04','2020-11-04',19999.00,NULL,NULL,1,'2021-08-24 21:03:09','2021-08-24 21:03:09',NULL),(3107,2978,40720,43981,3,3107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-04','2020-11-04',400.00,NULL,NULL,1,'2021-08-24 21:03:09','2021-08-24 21:03:09',NULL),(3108,2978,40720,43981,3,3108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-11','2020-11-11',5299.00,NULL,NULL,1,'2021-08-24 21:03:09','2021-08-24 21:03:09',NULL),(3109,2978,40720,43981,3,3109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-20','2020-11-20',3312.00,NULL,NULL,1,'2021-08-24 21:03:09','2021-08-24 21:03:09',NULL),(3110,2978,40720,43982,3,3110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-02','2020-12-02',6749.00,NULL,NULL,1,'2021-08-24 21:04:59','2021-08-24 21:04:59',NULL),(3111,2978,40720,43982,3,3111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-07','2020-12-07',400.00,NULL,NULL,1,'2021-08-24 21:04:59','2021-08-24 21:04:59',NULL),(3112,2978,40720,43982,3,3112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-24','2020-12-24',1699.00,NULL,NULL,1,'2021-08-24 21:04:59','2021-08-24 21:04:59',NULL),(3113,2978,40720,43982,3,3113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-30','2020-12-30',4261.34,NULL,NULL,1,'2021-08-24 21:04:59','2021-08-24 21:04:59',NULL),(3114,2978,40720,43982,3,3114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',1264.99,NULL,NULL,1,'2021-08-24 21:04:59','2021-08-24 21:04:59',NULL),(3115,2978,40720,43982,3,3115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',5790.00,NULL,NULL,1,'2021-08-24 21:04:59','2021-08-24 21:04:59',NULL),(3116,2978,41711,303845,3,3116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-01','2019-02-01',123.70,NULL,NULL,1,'2021-08-27 11:16:23','2021-08-27 11:16:23',NULL),(3117,2978,41711,303845,3,3117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-01','2019-02-01',1244.18,NULL,NULL,1,'2021-08-27 11:16:23','2021-08-27 11:16:23',NULL);
INSERT INTO `balance_libro` VALUES (3118,2978,41711,303845,3,3118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-02','2019-02-02',1527.64,NULL,NULL,1,'2021-08-27 11:16:24','2021-08-27 11:16:24',NULL),(3119,2978,41711,303845,3,3119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-02','2019-02-02',703.01,NULL,NULL,1,'2021-08-27 11:16:24','2021-08-27 11:16:24',NULL),(3120,2978,41711,303845,3,3120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-04','2019-02-04',250.00,NULL,NULL,1,'2021-08-27 11:16:24','2021-08-27 11:16:24',NULL),(3121,2978,41711,303845,3,3121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-04','2019-02-04',1060.99,NULL,NULL,1,'2021-08-27 11:16:24','2021-08-27 11:16:24',NULL),(3122,2978,41711,303845,3,3122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-04','2019-02-04',326.92,NULL,NULL,1,'2021-08-27 11:16:24','2021-08-27 11:16:24',NULL),(3123,2978,41711,303845,3,3123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-04','2019-02-04',808.16,NULL,NULL,1,'2021-08-27 11:16:24','2021-08-27 11:16:24',NULL),(3124,2978,41711,303845,3,3124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-04','2019-02-04',1963.65,NULL,NULL,1,'2021-08-27 11:16:24','2021-08-27 11:16:24',NULL),(3125,2978,41711,303845,3,3125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-05','2019-02-05',1968.15,NULL,NULL,1,'2021-08-27 11:16:24','2021-08-27 11:16:24',NULL),(3126,2978,41711,303845,3,3126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-05','2019-02-05',545.51,NULL,NULL,1,'2021-08-27 11:16:24','2021-08-27 11:16:24',NULL),(3127,2978,41711,303845,3,3127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-07','2019-02-07',173.56,NULL,NULL,1,'2021-08-27 11:16:24','2021-08-27 11:16:24',NULL),(3128,2978,41711,303845,3,3128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-07','2019-02-07',2489.95,NULL,NULL,1,'2021-08-27 11:16:24','2021-08-27 11:16:24',NULL),(3129,2978,41711,303845,3,3129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-07','2019-02-07',101.05,NULL,NULL,1,'2021-08-27 11:16:24','2021-08-27 11:16:24',NULL),(3130,2978,41711,303845,3,3130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-07','2019-02-07',1730.04,NULL,NULL,1,'2021-08-27 11:16:24','2021-08-27 11:16:24',NULL),(3131,2978,41711,303845,3,3131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-07','2019-02-07',495.08,NULL,NULL,1,'2021-08-27 11:16:24','2021-08-27 11:16:24',NULL),(3132,2978,41711,303845,3,3132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-08','2019-02-08',770.69,NULL,NULL,1,'2021-08-27 11:16:24','2021-08-27 11:16:24',NULL),(3133,2978,41711,303845,3,3133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-08','2019-02-08',945.75,NULL,NULL,1,'2021-08-27 11:16:24','2021-08-27 11:16:24',NULL),(3134,2978,41711,303845,3,3134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-09','2019-02-09',666.57,NULL,NULL,1,'2021-08-27 11:16:24','2021-08-27 11:16:24',NULL),(3135,2978,41711,303845,3,3135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-09','2019-02-09',1085.77,NULL,NULL,1,'2021-08-27 11:16:24','2021-08-27 11:16:24',NULL),(3136,2978,41711,303845,3,3136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-11','2019-02-11',1458.32,NULL,NULL,1,'2021-08-27 11:16:24','2021-08-27 11:16:24',NULL),(3137,2978,41711,303845,3,3137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-12','2019-02-12',1901.38,NULL,NULL,1,'2021-08-27 11:16:24','2021-08-27 11:16:24',NULL),(3138,2978,41711,303845,3,3138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-12','2019-02-12',30.58,NULL,NULL,1,'2021-08-27 11:16:24','2021-08-27 11:16:24',NULL),(3139,2978,41711,303845,3,3139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-12','2019-02-12',48.32,NULL,NULL,1,'2021-08-27 11:16:24','2021-08-27 11:16:24',NULL),(3140,2978,41711,303845,3,3140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-12','2019-02-12',957.08,NULL,NULL,1,'2021-08-27 11:16:24','2021-08-27 11:16:24',NULL),(3141,2978,41711,303845,3,3141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-13','2019-02-13',414.76,NULL,NULL,1,'2021-08-27 11:16:24','2021-08-27 11:16:24',NULL);
INSERT INTO `balance_libro` VALUES (3142,2978,41711,303845,3,3142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-13','2019-02-13',354.09,NULL,NULL,1,'2021-08-27 11:16:24','2021-08-27 11:16:24',NULL),(3143,2978,41711,303845,3,3143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-13','2019-02-13',99.85,NULL,NULL,1,'2021-08-27 11:16:24','2021-08-27 11:16:24',NULL),(3144,2978,41711,303845,3,3144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-13','2019-02-13',684.22,NULL,NULL,1,'2021-08-27 11:16:24','2021-08-27 11:16:24',NULL),(3145,2978,41711,303845,3,3145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-14','2019-02-14',2821.82,NULL,NULL,1,'2021-08-27 11:16:24','2021-08-27 11:16:24',NULL),(3146,2978,41711,303845,3,3146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-14','2019-02-14',495.11,NULL,NULL,1,'2021-08-27 11:16:25','2021-08-27 11:16:25',NULL),(3147,2978,41711,303845,3,3147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-14','2019-02-14',80.05,NULL,NULL,1,'2021-08-27 11:16:25','2021-08-27 11:16:25',NULL),(3148,2978,41711,303845,3,3148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-15','2019-02-15',1152.59,NULL,NULL,1,'2021-08-27 11:16:25','2021-08-27 11:16:25',NULL),(3149,2978,41711,303845,3,3149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-15','2019-02-15',259.50,NULL,NULL,1,'2021-08-27 11:16:25','2021-08-27 11:16:25',NULL),(3150,2978,41711,303845,3,3150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-15','2019-02-15',671.27,NULL,NULL,1,'2021-08-27 11:16:25','2021-08-27 11:16:25',NULL),(3151,2978,41711,303845,3,3151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-15','2019-02-15',301.98,NULL,NULL,1,'2021-08-27 11:16:25','2021-08-27 11:16:25',NULL),(3152,2978,41711,303845,3,3152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-18','2019-02-18',95.59,NULL,NULL,1,'2021-08-27 11:16:25','2021-08-27 11:16:25',NULL),(3153,2978,41711,303845,3,3153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-18','2019-02-18',76.10,NULL,NULL,1,'2021-08-27 11:16:25','2021-08-27 11:16:25',NULL),(3154,2978,41711,303845,3,3154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-18','2019-02-18',1107.21,NULL,NULL,1,'2021-08-27 11:16:25','2021-08-27 11:16:25',NULL),(3155,2978,41711,303845,3,3155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-18','2019-02-18',210.94,NULL,NULL,1,'2021-08-27 11:16:25','2021-08-27 11:16:25',NULL),(3156,2978,41711,303845,3,3156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-19','2019-02-19',1160.91,NULL,NULL,1,'2021-08-27 11:16:25','2021-08-27 11:16:25',NULL),(3157,2978,41711,303845,3,3157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-19','2019-02-19',134.31,NULL,NULL,1,'2021-08-27 11:16:25','2021-08-27 11:16:25',NULL),(3158,2978,41711,303845,3,3158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-20','2019-02-20',150.25,NULL,NULL,1,'2021-08-27 11:16:25','2021-08-27 11:16:25',NULL),(3159,2978,41711,303845,3,3159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-20','2019-02-20',91.70,NULL,NULL,1,'2021-08-27 11:16:25','2021-08-27 11:16:25',NULL),(3160,2978,41711,303845,3,3160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-20','2019-02-20',748.32,NULL,NULL,1,'2021-08-27 11:16:25','2021-08-27 11:16:25',NULL),(3161,2978,41711,303845,3,3161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-20','2019-02-20',241.64,NULL,NULL,1,'2021-08-27 11:16:25','2021-08-27 11:16:25',NULL),(3162,2978,41711,303845,3,3162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-21','2019-02-21',1193.72,NULL,NULL,1,'2021-08-27 11:16:25','2021-08-27 11:16:25',NULL),(3163,2978,41711,303845,3,3163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-21','2019-02-21',379.37,NULL,NULL,1,'2021-08-27 11:16:25','2021-08-27 11:16:25',NULL),(3164,2978,41711,303845,3,3164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-21','2019-02-21',156.20,NULL,NULL,1,'2021-08-27 11:16:25','2021-08-27 11:16:25',NULL),(3165,2978,41711,303845,3,3165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-21','2019-02-21',114.72,NULL,NULL,1,'2021-08-27 11:16:25','2021-08-27 11:16:25',NULL);
INSERT INTO `balance_libro` VALUES (3166,2978,41711,303845,3,3166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-21','2019-02-21',69.28,NULL,NULL,1,'2021-08-27 11:16:25','2021-08-27 11:16:25',NULL),(3167,2978,41711,303845,3,3167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-21','2019-02-21',69.28,NULL,NULL,1,'2021-08-27 11:16:25','2021-08-27 11:16:25',NULL),(3168,2978,41711,303845,3,3168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-21','2019-02-21',465.51,NULL,NULL,1,'2021-08-27 11:16:25','2021-08-27 11:16:25',NULL),(3169,2978,41711,303845,3,3169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-21','2019-02-21',345.80,NULL,NULL,1,'2021-08-27 11:16:25','2021-08-27 11:16:25',NULL),(3170,2978,41711,303845,3,3170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-21','2019-02-21',279.73,NULL,NULL,1,'2021-08-27 11:16:25','2021-08-27 11:16:25',NULL),(3171,2978,41711,303845,3,3171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-21','2019-02-21',3992.91,NULL,NULL,1,'2021-08-27 11:16:25','2021-08-27 11:16:25',NULL),(3172,2978,41711,303845,3,3172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-21','2019-02-21',977.36,NULL,NULL,1,'2021-08-27 11:16:26','2021-08-27 11:16:26',NULL),(3173,2978,41711,303845,3,3173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-22','2019-02-22',56.63,NULL,NULL,1,'2021-08-27 11:16:26','2021-08-27 11:16:26',NULL),(3174,2978,41711,303845,3,3174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-22','2019-02-22',175.69,NULL,NULL,1,'2021-08-27 11:16:26','2021-08-27 11:16:26',NULL),(3175,2978,41711,303845,3,3175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-22','2019-02-22',976.78,NULL,NULL,1,'2021-08-27 11:16:26','2021-08-27 11:16:26',NULL),(3176,2978,41711,303845,3,3176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-22','2019-02-22',174.05,NULL,NULL,1,'2021-08-27 11:16:26','2021-08-27 11:16:26',NULL),(3177,2978,41711,303845,3,3177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-24','2019-02-24',1299.36,NULL,NULL,1,'2021-08-27 11:16:26','2021-08-27 11:16:26',NULL),(3178,2978,41711,303845,3,3178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-25','2019-02-25',1260.02,NULL,NULL,1,'2021-08-27 11:16:26','2021-08-27 11:16:26',NULL),(3179,2978,41711,303845,3,3179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-25','2019-02-25',107.32,NULL,NULL,1,'2021-08-27 11:16:26','2021-08-27 11:16:26',NULL),(3180,2978,41711,303845,3,3180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-25','2019-02-25',1460.88,NULL,NULL,1,'2021-08-27 11:16:26','2021-08-27 11:16:26',NULL),(3181,2978,41711,303845,3,3181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-26','2019-02-26',484.92,NULL,NULL,1,'2021-08-27 11:16:26','2021-08-27 11:16:26',NULL),(3182,2978,41711,303845,3,3182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-26','2019-02-26',174.90,NULL,NULL,1,'2021-08-27 11:16:26','2021-08-27 11:16:26',NULL),(3183,2978,41711,303845,3,3183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-26','2019-02-26',937.69,NULL,NULL,1,'2021-08-27 11:16:26','2021-08-27 11:16:26',NULL),(3184,2978,41711,303845,3,3184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-26','2019-02-26',50.46,NULL,NULL,1,'2021-08-27 11:16:26','2021-08-27 11:16:26',NULL),(3185,2978,41711,303845,3,3185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-26','2019-02-26',213.52,NULL,NULL,1,'2021-08-27 11:16:26','2021-08-27 11:16:26',NULL),(3186,2978,41711,303845,3,3186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-27','2019-02-27',1187.45,NULL,NULL,1,'2021-08-27 11:16:26','2021-08-27 11:16:26',NULL),(3187,2978,41711,303845,3,3187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-27','2019-02-27',326.83,NULL,NULL,1,'2021-08-27 11:16:26','2021-08-27 11:16:26',NULL),(3188,2978,41711,303845,3,3188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-27','2019-02-27',921.43,NULL,NULL,1,'2021-08-27 11:16:26','2021-08-27 11:16:26',NULL),(3189,2978,41711,303845,3,3189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-27','2019-02-27',102.28,NULL,NULL,1,'2021-08-27 11:16:26','2021-08-27 11:16:26',NULL);
INSERT INTO `balance_libro` VALUES (3190,2978,41711,303845,3,3190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-27','2019-02-27',334.04,NULL,NULL,1,'2021-08-27 11:16:26','2021-08-27 11:16:26',NULL),(3191,2978,41711,303845,3,3191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-28','2019-02-28',157.06,NULL,NULL,1,'2021-08-27 11:16:26','2021-08-27 11:16:26',NULL),(3192,2978,41711,303845,3,3192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-28','2019-02-28',89.45,NULL,NULL,1,'2021-08-27 11:16:26','2021-08-27 11:16:26',NULL),(3193,2978,41711,303845,3,3193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-28','2019-02-28',89.92,NULL,NULL,1,'2021-08-27 11:16:26','2021-08-27 11:16:26',NULL),(3194,2978,41711,303845,3,3194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-28','2019-02-28',266.76,NULL,NULL,1,'2021-08-27 11:16:26','2021-08-27 11:16:26',NULL),(3195,2978,41711,303845,3,3195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-02-28','2019-02-28',1123.85,NULL,NULL,1,'2021-08-27 11:16:26','2021-08-27 11:16:26',NULL),(3196,2978,41711,303846,3,3196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-01','2019-03-01',1255.72,NULL,NULL,1,'2021-08-27 11:35:02','2021-08-27 11:35:02',NULL),(3197,2978,41711,303846,3,3197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-01','2019-03-01',52.42,NULL,NULL,1,'2021-08-27 11:35:02','2021-08-27 11:35:02',NULL),(3198,2978,41711,303846,3,3198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-01','2019-03-01',246.40,NULL,NULL,1,'2021-08-27 11:35:02','2021-08-27 11:35:02',NULL),(3199,2978,41711,303846,3,3199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-01','2019-03-01',726.07,NULL,NULL,1,'2021-08-27 11:35:02','2021-08-27 11:35:02',NULL),(3200,2978,41711,303846,3,3200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-01','2019-03-01',1271.84,NULL,NULL,1,'2021-08-27 11:35:02','2021-08-27 11:35:02',NULL),(3201,2978,41711,303846,3,3201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-01','2019-03-01',1191.80,NULL,NULL,1,'2021-08-27 11:35:02','2021-08-27 11:35:02',NULL),(3202,2978,41711,303846,3,3202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-03','2019-03-03',485.47,NULL,NULL,1,'2021-08-27 11:35:02','2021-08-27 11:35:02',NULL),(3203,2978,41711,303846,3,3203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-03','2019-03-03',317.40,NULL,NULL,1,'2021-08-27 11:35:02','2021-08-27 11:35:02',NULL),(3204,2978,41711,303846,3,3204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-04','2019-03-04',818.67,NULL,NULL,1,'2021-08-27 11:35:02','2021-08-27 11:35:02',NULL),(3205,2978,41711,303846,3,3205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-04','2019-03-04',215.18,NULL,NULL,1,'2021-08-27 11:35:02','2021-08-27 11:35:02',NULL),(3206,2978,41711,303846,3,3206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-04','2019-03-04',148.60,NULL,NULL,1,'2021-08-27 11:35:03','2021-08-27 11:35:03',NULL),(3207,2978,41711,303846,3,3207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-06','2019-03-06',2322.58,NULL,NULL,1,'2021-08-27 11:35:03','2021-08-27 11:35:03',NULL),(3208,2978,41711,303846,3,3208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-06','2019-03-06',303.70,NULL,NULL,1,'2021-08-27 11:35:03','2021-08-27 11:35:03',NULL),(3209,2978,41711,303846,3,3209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-06','2019-03-06',221.85,NULL,NULL,1,'2021-08-27 11:35:03','2021-08-27 11:35:03',NULL),(3210,2978,41711,303846,3,3210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-06','2019-03-06',472.26,NULL,NULL,1,'2021-08-27 11:35:03','2021-08-27 11:35:03',NULL),(3211,2978,41711,303846,3,3211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-06','2019-03-06',570.00,NULL,NULL,1,'2021-08-27 11:35:03','2021-08-27 11:35:03',NULL),(3212,2978,41711,303846,3,3212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-06','2019-03-06',1963.65,NULL,NULL,1,'2021-08-27 11:35:03','2021-08-27 11:35:03',NULL),(3213,2978,41711,303846,3,3213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-07','2019-03-07',1058.15,NULL,NULL,1,'2021-08-27 11:35:03','2021-08-27 11:35:03',NULL);
INSERT INTO `balance_libro` VALUES (3214,2978,41711,303846,3,3214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-07','2019-03-07',1138.36,NULL,NULL,1,'2021-08-27 11:35:03','2021-08-27 11:35:03',NULL),(3215,2978,41711,303846,3,3215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-07','2019-03-07',168.67,NULL,NULL,1,'2021-08-27 11:35:03','2021-08-27 11:35:03',NULL),(3216,2978,41711,303846,3,3216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-07','2019-03-07',731.50,NULL,NULL,1,'2021-08-27 11:35:03','2021-08-27 11:35:03',NULL),(3217,2978,41711,303846,3,3217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-07','2019-03-07',598.95,NULL,NULL,1,'2021-08-27 11:35:03','2021-08-27 11:35:03',NULL),(3218,2978,41711,303846,3,3218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-08','2019-03-08',495.93,NULL,NULL,1,'2021-08-27 11:35:03','2021-08-27 11:35:03',NULL),(3219,2978,41711,303846,3,3219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-08','2019-03-08',355.68,NULL,NULL,1,'2021-08-27 11:35:03','2021-08-27 11:35:03',NULL),(3220,2978,41711,303846,3,3220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-08','2019-03-08',104.92,NULL,NULL,1,'2021-08-27 11:35:03','2021-08-27 11:35:03',NULL),(3221,2978,41711,303846,3,3221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-08','2019-03-08',250.00,NULL,NULL,1,'2021-08-27 11:35:03','2021-08-27 11:35:03',NULL),(3222,2978,41711,303846,3,3222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-08','2019-03-08',805.68,NULL,NULL,1,'2021-08-27 11:35:03','2021-08-27 11:35:03',NULL),(3223,2978,41711,303846,3,3223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-08','2019-03-08',4199.72,NULL,NULL,1,'2021-08-27 11:35:03','2021-08-27 11:35:03',NULL),(3224,2978,41711,303846,3,3224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-08','2019-03-08',977.48,NULL,NULL,1,'2021-08-27 11:35:03','2021-08-27 11:35:03',NULL),(3225,2978,41711,303846,3,3225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-08','2019-03-08',50.42,NULL,NULL,1,'2021-08-27 11:35:03','2021-08-27 11:35:03',NULL),(3226,2978,41711,303846,3,3226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-09','2019-03-09',351.96,NULL,NULL,1,'2021-08-27 11:35:03','2021-08-27 11:35:03',NULL),(3227,2978,41711,303846,3,3227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-11','2019-03-11',4366.54,NULL,NULL,1,'2021-08-27 11:35:03','2021-08-27 11:35:03',NULL),(3228,2978,41711,303846,3,3228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-11','2019-03-11',242.38,NULL,NULL,1,'2021-08-27 11:35:03','2021-08-27 11:35:03',NULL),(3229,2978,41711,303846,3,3229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-11','2019-03-11',95.25,NULL,NULL,1,'2021-08-27 11:35:03','2021-08-27 11:35:03',NULL),(3230,2978,41711,303846,3,3230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-11','2019-03-11',403.29,NULL,NULL,1,'2021-08-27 11:35:03','2021-08-27 11:35:03',NULL),(3231,2978,41711,303846,3,3231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-11','2019-03-11',449.05,NULL,NULL,1,'2021-08-27 11:35:03','2021-08-27 11:35:03',NULL),(3232,2978,41711,303846,3,3232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-11','2019-03-11',4010.83,NULL,NULL,1,'2021-08-27 11:35:04','2021-08-27 11:35:04',NULL),(3233,2978,41711,303846,3,3233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-11','2019-03-11',457.15,NULL,NULL,1,'2021-08-27 11:35:04','2021-08-27 11:35:04',NULL),(3234,2978,41711,303846,3,3234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-12','2019-03-12',80.55,NULL,NULL,1,'2021-08-27 11:35:04','2021-08-27 11:35:04',NULL),(3235,2978,41711,303846,3,3235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-12','2019-03-12',1197.31,NULL,NULL,1,'2021-08-27 11:35:04','2021-08-27 11:35:04',NULL),(3236,2978,41711,303846,3,3236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-12','2019-03-12',25.05,NULL,NULL,1,'2021-08-27 11:35:04','2021-08-27 11:35:04',NULL),(3237,2978,41711,303846,3,3237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-12','2019-03-12',1316.36,NULL,NULL,1,'2021-08-27 11:35:04','2021-08-27 11:35:04',NULL);
INSERT INTO `balance_libro` VALUES (3238,2978,41711,303846,3,3238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-12','2019-03-12',173.45,NULL,NULL,1,'2021-08-27 11:35:04','2021-08-27 11:35:04',NULL),(3239,2978,41711,303846,3,3239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-12','2019-03-12',583.47,NULL,NULL,1,'2021-08-27 11:35:04','2021-08-27 11:35:04',NULL),(3240,2978,41711,303846,3,3240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-12','2019-03-12',179.84,NULL,NULL,1,'2021-08-27 11:35:04','2021-08-27 11:35:04',NULL),(3241,2978,41711,303846,3,3241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-12','2019-03-12',43.67,NULL,NULL,1,'2021-08-27 11:35:04','2021-08-27 11:35:04',NULL),(3242,2978,41711,303846,3,3242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-12','2019-03-12',803.55,NULL,NULL,1,'2021-08-27 11:35:04','2021-08-27 11:35:04',NULL),(3243,2978,41711,303846,3,3243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-13','2019-03-13',1684.32,NULL,NULL,1,'2021-08-27 11:35:04','2021-08-27 11:35:04',NULL),(3244,2978,41711,303846,3,3244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-13','2019-03-13',216.76,NULL,NULL,1,'2021-08-27 11:35:04','2021-08-27 11:35:04',NULL),(3245,2978,41711,303846,3,3245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-13','2019-03-13',520.76,NULL,NULL,1,'2021-08-27 11:35:04','2021-08-27 11:35:04',NULL),(3246,2978,41711,303846,3,3246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-13','2019-03-13',104.92,NULL,NULL,1,'2021-08-27 11:35:04','2021-08-27 11:35:04',NULL),(3247,2978,41711,303846,3,3247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-13','2019-03-13',507.25,NULL,NULL,1,'2021-08-27 11:35:04','2021-08-27 11:35:04',NULL),(3248,2978,41711,303846,3,3248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-13','2019-03-13',859.46,NULL,NULL,1,'2021-08-27 11:35:04','2021-08-27 11:35:04',NULL),(3249,2978,41711,303846,3,3249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-14','2019-03-14',0.01,NULL,NULL,1,'2021-08-27 11:35:04','2021-08-27 11:35:04',NULL),(3250,2978,41711,303846,3,3250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-14','2019-03-14',165.98,NULL,NULL,1,'2021-08-27 11:35:04','2021-08-27 11:35:04',NULL),(3251,2978,41711,303846,3,3251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-14','2019-03-14',323.66,NULL,NULL,1,'2021-08-27 11:35:04','2021-08-27 11:35:04',NULL),(3252,2978,41711,303846,3,3252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-14','2019-03-14',174.24,NULL,NULL,1,'2021-08-27 11:35:04','2021-08-27 11:35:04',NULL),(3253,2978,41711,303846,3,3253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-14','2019-03-14',331.09,NULL,NULL,1,'2021-08-27 11:35:04','2021-08-27 11:35:04',NULL),(3254,2978,41711,303846,3,3254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-14','2019-03-14',902.49,NULL,NULL,1,'2021-08-27 11:35:04','2021-08-27 11:35:04',NULL),(3255,2978,41711,303846,3,3255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-14','2019-03-14',174.24,NULL,NULL,1,'2021-08-27 11:35:04','2021-08-27 11:35:04',NULL),(3256,2978,41711,303846,3,3256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-14','2019-03-14',549.48,NULL,NULL,1,'2021-08-27 11:35:04','2021-08-27 11:35:04',NULL),(3257,2978,41711,303846,3,3257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-14','2019-03-14',508.92,NULL,NULL,1,'2021-08-27 11:35:04','2021-08-27 11:35:04',NULL),(3258,2978,41711,303846,3,3258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-14','2019-03-14',202.73,NULL,NULL,1,'2021-08-27 11:35:04','2021-08-27 11:35:04',NULL),(3259,2978,41711,303846,3,3259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-15','2019-03-15',413.72,NULL,NULL,1,'2021-08-27 11:35:05','2021-08-27 11:35:05',NULL),(3260,2978,41711,303846,3,3260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-15','2019-03-15',132.19,NULL,NULL,1,'2021-08-27 11:35:05','2021-08-27 11:35:05',NULL),(3261,2978,41711,303846,3,3261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-15','2019-03-15',121.22,NULL,NULL,1,'2021-08-27 11:35:05','2021-08-27 11:35:05',NULL);
INSERT INTO `balance_libro` VALUES (3262,2978,41711,303846,3,3262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-15','2019-03-15',263.53,NULL,NULL,1,'2021-08-27 11:35:05','2021-08-27 11:35:05',NULL),(3263,2978,41711,303846,3,3263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-15','2019-03-15',77.67,NULL,NULL,1,'2021-08-27 11:35:05','2021-08-27 11:35:05',NULL),(3264,2978,41711,303846,3,3264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-15','2019-03-15',527.88,NULL,NULL,1,'2021-08-27 11:35:05','2021-08-27 11:35:05',NULL),(3265,2978,41711,303846,3,3265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-15','2019-03-15',633.05,NULL,NULL,1,'2021-08-27 11:35:05','2021-08-27 11:35:05',NULL),(3266,2978,41711,303846,3,3266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-17','2019-03-17',1310.83,NULL,NULL,1,'2021-08-27 11:35:05','2021-08-27 11:35:05',NULL),(3267,2978,41711,303846,3,3267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-18','2019-03-18',209.75,NULL,NULL,1,'2021-08-27 11:35:05','2021-08-27 11:35:05',NULL),(3268,2978,41711,303846,3,3268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-18','2019-03-18',394.23,NULL,NULL,1,'2021-08-27 11:35:05','2021-08-27 11:35:05',NULL),(3269,2978,41711,303846,3,3269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-18','2019-03-18',445.86,NULL,NULL,1,'2021-08-27 11:35:05','2021-08-27 11:35:05',NULL),(3270,2978,41711,303846,3,3270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-18','2019-03-18',404.04,NULL,NULL,1,'2021-08-27 11:35:05','2021-08-27 11:35:05',NULL),(3271,2978,41711,303846,3,3271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-18','2019-03-18',481.43,NULL,NULL,1,'2021-08-27 11:35:05','2021-08-27 11:35:05',NULL),(3272,2978,41711,303846,3,3272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-18','2019-03-18',2895.99,NULL,NULL,1,'2021-08-27 11:35:05','2021-08-27 11:35:05',NULL),(3273,2978,41711,303846,3,3273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-18','2019-03-18',1308.92,NULL,NULL,1,'2021-08-27 11:35:05','2021-08-27 11:35:05',NULL),(3274,2978,41711,303846,3,3274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-18','2019-03-18',1202.86,NULL,NULL,1,'2021-08-27 11:35:05','2021-08-27 11:35:05',NULL),(3275,2978,41711,303846,3,3275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-18','2019-03-18',1270.00,NULL,NULL,1,'2021-08-27 11:35:05','2021-08-27 11:35:05',NULL),(3276,2978,41711,303846,3,3276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-19','2019-03-19',368.40,NULL,NULL,1,'2021-08-27 11:35:05','2021-08-27 11:35:05',NULL),(3277,2978,41711,303846,3,3277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-19','2019-03-19',124.27,NULL,NULL,1,'2021-08-27 11:35:05','2021-08-27 11:35:05',NULL),(3278,2978,41711,303846,3,3278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-19','2019-03-19',554.95,NULL,NULL,1,'2021-08-27 11:35:05','2021-08-27 11:35:05',NULL),(3279,2978,41711,303846,3,3279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-19','2019-03-19',135.25,NULL,NULL,1,'2021-08-27 11:35:05','2021-08-27 11:35:05',NULL),(3280,2978,41711,303846,3,3280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-19','2019-03-19',795.51,NULL,NULL,1,'2021-08-27 11:35:05','2021-08-27 11:35:05',NULL),(3281,2978,41711,303846,3,3281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-20','2019-03-20',1455.82,NULL,NULL,1,'2021-08-27 11:35:06','2021-08-27 11:35:06',NULL),(3282,2978,41711,303846,3,3282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-20','2019-03-20',265.77,NULL,NULL,1,'2021-08-27 11:35:06','2021-08-27 11:35:06',NULL),(3283,2978,41711,303846,3,3283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-20','2019-03-20',172.20,NULL,NULL,1,'2021-08-27 11:35:06','2021-08-27 11:35:06',NULL),(3284,2978,41711,303846,3,3284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-20','2019-03-20',237.42,NULL,NULL,1,'2021-08-27 11:35:06','2021-08-27 11:35:06',NULL),(3285,2978,41711,303846,3,3285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-21','2019-03-21',2216.93,NULL,NULL,1,'2021-08-27 11:35:06','2021-08-27 11:35:06',NULL);
INSERT INTO `balance_libro` VALUES (3286,2978,41711,303846,3,3286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-21','2019-03-21',345.80,NULL,NULL,1,'2021-08-27 11:35:06','2021-08-27 11:35:06',NULL),(3287,2978,41711,303846,3,3287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-21','2019-03-21',1246.21,NULL,NULL,1,'2021-08-27 11:35:06','2021-08-27 11:35:06',NULL),(3288,2978,41711,303846,3,3288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-21','2019-03-21',348.46,NULL,NULL,1,'2021-08-27 11:35:06','2021-08-27 11:35:06',NULL),(3289,2978,41711,303846,3,3289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-21','2019-03-21',1382.33,NULL,NULL,1,'2021-08-27 11:35:06','2021-08-27 11:35:06',NULL),(3290,2978,41711,303846,3,3290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-21','2019-03-21',784.86,NULL,NULL,1,'2021-08-27 11:35:06','2021-08-27 11:35:06',NULL),(3291,2978,41711,303846,3,3291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-21','2019-03-21',472.20,NULL,NULL,1,'2021-08-27 11:35:06','2021-08-27 11:35:06',NULL),(3292,2978,41711,303846,3,3292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-22','2019-03-22',56.75,NULL,NULL,1,'2021-08-27 11:35:06','2021-08-27 11:35:06',NULL),(3293,2978,41711,303846,3,3293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-22','2019-03-22',75.75,NULL,NULL,1,'2021-08-27 11:35:06','2021-08-27 11:35:06',NULL),(3294,2978,41711,303846,3,3294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-22','2019-03-22',137.88,NULL,NULL,1,'2021-08-27 11:35:06','2021-08-27 11:35:06',NULL),(3295,2978,41711,303846,3,3295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-22','2019-03-22',277.10,NULL,NULL,1,'2021-08-27 11:35:06','2021-08-27 11:35:06',NULL),(3296,2978,41711,303846,3,3296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-23','2019-03-23',194.94,NULL,NULL,1,'2021-08-27 11:35:06','2021-08-27 11:35:06',NULL),(3297,2978,41711,303846,3,3297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-23','2019-03-23',6141.98,NULL,NULL,1,'2021-08-27 11:35:06','2021-08-27 11:35:06',NULL),(3298,2978,41711,303846,3,3298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-25','2019-03-25',641.76,NULL,NULL,1,'2021-08-27 11:35:06','2021-08-27 11:35:06',NULL),(3299,2978,41711,303846,3,3299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-25','2019-03-25',211.59,NULL,NULL,1,'2021-08-27 11:35:06','2021-08-27 11:35:06',NULL),(3300,2978,41711,303846,3,3300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-26','2019-03-26',600.38,NULL,NULL,1,'2021-08-27 11:35:06','2021-08-27 11:35:06',NULL),(3301,2978,41711,303846,3,3301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-26','2019-03-26',88.13,NULL,NULL,1,'2021-08-27 11:35:06','2021-08-27 11:35:06',NULL),(3302,2978,41711,303846,3,3302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-26','2019-03-26',894.81,NULL,NULL,1,'2021-08-27 11:35:06','2021-08-27 11:35:06',NULL),(3303,2978,41711,303846,3,3303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-27','2019-03-27',216.59,NULL,NULL,1,'2021-08-27 11:35:06','2021-08-27 11:35:06',NULL),(3304,2978,41711,303846,3,3304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-27','2019-03-27',717.50,NULL,NULL,1,'2021-08-27 11:35:06','2021-08-27 11:35:06',NULL),(3305,2978,41711,303846,3,3305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-28','2019-03-28',228.35,NULL,NULL,1,'2021-08-27 11:35:07','2021-08-27 11:35:07',NULL),(3306,2978,41711,303846,3,3306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-28','2019-03-28',307.79,NULL,NULL,1,'2021-08-27 11:35:07','2021-08-27 11:35:07',NULL),(3307,2978,41711,303846,3,3307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-28','2019-03-28',388.03,NULL,NULL,1,'2021-08-27 11:35:07','2021-08-27 11:35:07',NULL),(3308,2978,41711,303846,3,3308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-28','2019-03-28',184.49,NULL,NULL,1,'2021-08-27 11:35:07','2021-08-27 11:35:07',NULL),(3309,2978,41711,303846,3,3309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-29','2019-03-29',444.07,NULL,NULL,1,'2021-08-27 11:35:07','2021-08-27 11:35:07',NULL);
INSERT INTO `balance_libro` VALUES (3310,2978,41711,303846,3,3310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-29','2019-03-29',145.24,NULL,NULL,1,'2021-08-27 11:35:07','2021-08-27 11:35:07',NULL),(3311,2978,41711,303846,3,3311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-29','2019-03-29',658.37,NULL,NULL,1,'2021-08-27 11:35:07','2021-08-27 11:35:07',NULL),(3312,2978,41711,303846,3,3312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-31','2019-03-31',272.99,NULL,NULL,1,'2021-08-27 11:35:07','2021-08-27 11:35:07',NULL),(3313,2978,41711,303846,3,3313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-31','2019-03-31',145.24,NULL,NULL,1,'2021-08-27 11:35:07','2021-08-27 11:35:07',NULL),(3314,2978,41711,303846,3,3314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-03-31','2019-03-31',1123.85,NULL,NULL,1,'2021-08-27 11:35:07','2021-08-27 11:35:07',NULL),(3315,2978,41711,303847,3,3315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-01','2019-04-01',675.86,NULL,NULL,1,'2021-08-27 11:36:04','2021-08-27 11:36:04',NULL),(3316,2978,41711,303847,3,3316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-01','2019-04-01',104.44,NULL,NULL,1,'2021-08-27 11:36:04','2021-08-27 11:36:04',NULL),(3317,2978,41711,303847,3,3317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-01','2019-04-01',626.79,NULL,NULL,1,'2021-08-27 11:36:04','2021-08-27 11:36:04',NULL),(3318,2978,41711,303847,3,3318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-01','2019-04-01',217.00,NULL,NULL,1,'2021-08-27 11:36:04','2021-08-27 11:36:04',NULL),(3319,2978,41711,303847,3,3319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-01','2019-04-01',1228.15,NULL,NULL,1,'2021-08-27 11:36:04','2021-08-27 11:36:04',NULL),(3320,2978,41711,303847,3,3320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-02','2019-04-02',285.54,NULL,NULL,1,'2021-08-27 11:36:04','2021-08-27 11:36:04',NULL),(3321,2978,41711,303847,3,3321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-03','2019-04-03',1484.31,NULL,NULL,1,'2021-08-27 11:36:04','2021-08-27 11:36:04',NULL),(3322,2978,41711,303847,3,3322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-03','2019-04-03',421.85,NULL,NULL,1,'2021-08-27 11:36:04','2021-08-27 11:36:04',NULL),(3323,2978,41711,303847,3,3323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-03','2019-04-03',521.93,NULL,NULL,1,'2021-08-27 11:36:04','2021-08-27 11:36:04',NULL),(3324,2978,41711,303847,3,3324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-03','2019-04-03',1603.37,NULL,NULL,1,'2021-08-27 11:36:04','2021-08-27 11:36:04',NULL),(3325,2978,41711,303847,3,3325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-04','2019-04-04',1073.27,NULL,NULL,1,'2021-08-27 11:36:04','2021-08-27 11:36:04',NULL),(3326,2978,41711,303847,3,3326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-04','2019-04-04',402.47,NULL,NULL,1,'2021-08-27 11:36:04','2021-08-27 11:36:04',NULL),(3327,2978,41711,303847,3,3327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-04','2019-04-04',396.59,NULL,NULL,1,'2021-08-27 11:36:04','2021-08-27 11:36:04',NULL),(3328,2978,41711,303847,3,3328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-05','2019-04-05',250.00,NULL,NULL,1,'2021-08-27 11:36:05','2021-08-27 11:36:05',NULL),(3329,2978,41711,303847,3,3329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-05','2019-04-05',381.49,NULL,NULL,1,'2021-08-27 11:36:05','2021-08-27 11:36:05',NULL),(3330,2978,41711,303847,3,3330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-05','2019-04-05',949.15,NULL,NULL,1,'2021-08-27 11:36:05','2021-08-27 11:36:05',NULL),(3331,2978,41711,303847,3,3331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-05','2019-04-05',267.02,NULL,NULL,1,'2021-08-27 11:36:05','2021-08-27 11:36:05',NULL),(3332,2978,41711,303847,3,3332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-05','2019-04-05',1963.65,NULL,NULL,1,'2021-08-27 11:36:05','2021-08-27 11:36:05',NULL),(3333,2978,41711,303847,3,3333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-06','2019-04-06',1528.87,NULL,NULL,1,'2021-08-27 11:36:05','2021-08-27 11:36:05',NULL);
INSERT INTO `balance_libro` VALUES (3334,2978,41711,303847,3,3334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-08','2019-04-08',1932.04,NULL,NULL,1,'2021-08-27 11:36:05','2021-08-27 11:36:05',NULL),(3335,2978,41711,303847,3,3335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-08','2019-04-08',1075.71,NULL,NULL,1,'2021-08-27 11:36:05','2021-08-27 11:36:05',NULL),(3336,2978,41711,303847,3,3336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-08','2019-04-08',741.32,NULL,NULL,1,'2021-08-27 11:36:05','2021-08-27 11:36:05',NULL),(3337,2978,41711,303847,3,3337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-08','2019-04-08',590.48,NULL,NULL,1,'2021-08-27 11:36:05','2021-08-27 11:36:05',NULL),(3338,2978,41711,303847,3,3338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-09','2019-04-09',150.77,NULL,NULL,1,'2021-08-27 11:36:05','2021-08-27 11:36:05',NULL),(3339,2978,41711,303847,3,3339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-09','2019-04-09',568.85,NULL,NULL,1,'2021-08-27 11:36:05','2021-08-27 11:36:05',NULL),(3340,2978,41711,303847,3,3340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-09','2019-04-09',1353.64,NULL,NULL,1,'2021-08-27 11:36:05','2021-08-27 11:36:05',NULL),(3341,2978,41711,303847,3,3341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-10','2019-04-10',409.22,NULL,NULL,1,'2021-08-27 11:36:05','2021-08-27 11:36:05',NULL),(3342,2978,41711,303847,3,3342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-10','2019-04-10',535.28,NULL,NULL,1,'2021-08-27 11:36:05','2021-08-27 11:36:05',NULL),(3343,2978,41711,303847,3,3343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-10','2019-04-10',248.07,NULL,NULL,1,'2021-08-27 11:36:05','2021-08-27 11:36:05',NULL),(3344,2978,41711,303847,3,3344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-11','2019-04-11',1413.98,NULL,NULL,1,'2021-08-27 11:36:05','2021-08-27 11:36:05',NULL),(3345,2978,41711,303847,3,3345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-11','2019-04-11',84.60,NULL,NULL,1,'2021-08-27 11:36:05','2021-08-27 11:36:05',NULL),(3346,2978,41711,303847,3,3346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-11','2019-04-11',159.62,NULL,NULL,1,'2021-08-27 11:36:05','2021-08-27 11:36:05',NULL),(3347,2978,41711,303847,3,3347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-11','2019-04-11',23.83,NULL,NULL,1,'2021-08-27 11:36:05','2021-08-27 11:36:05',NULL),(3348,2978,41711,303847,3,3348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-11','2019-04-11',34.11,NULL,NULL,1,'2021-08-27 11:36:05','2021-08-27 11:36:05',NULL),(3349,2978,41711,303847,3,3349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-11','2019-04-11',302.50,NULL,NULL,1,'2021-08-27 11:36:05','2021-08-27 11:36:05',NULL),(3350,2978,41711,303847,3,3350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-11','2019-04-11',858.48,NULL,NULL,1,'2021-08-27 11:36:05','2021-08-27 11:36:05',NULL),(3351,2978,41711,303847,3,3351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-11','2019-04-11',3033.93,NULL,NULL,1,'2021-08-27 11:36:05','2021-08-27 11:36:05',NULL),(3352,2978,41711,303847,3,3352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-11','2019-04-11',84.66,NULL,NULL,1,'2021-08-27 11:36:05','2021-08-27 11:36:05',NULL),(3353,2978,41711,303847,3,3353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-12','2019-04-12',186.32,NULL,NULL,1,'2021-08-27 11:36:05','2021-08-27 11:36:05',NULL),(3354,2978,41711,303847,3,3354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-12','2019-04-12',622.48,NULL,NULL,1,'2021-08-27 11:36:05','2021-08-27 11:36:05',NULL),(3355,2978,41711,303847,3,3355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-12','2019-04-12',252.56,NULL,NULL,1,'2021-08-27 11:36:05','2021-08-27 11:36:05',NULL),(3356,2978,41711,303847,3,3356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-12','2019-04-12',340.38,NULL,NULL,1,'2021-08-27 11:36:06','2021-08-27 11:36:06',NULL),(3357,2978,41711,303847,3,3357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-12','2019-04-12',748.52,NULL,NULL,1,'2021-08-27 11:36:06','2021-08-27 11:36:06',NULL);
INSERT INTO `balance_libro` VALUES (3358,2978,41711,303847,3,3358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-12','2019-04-12',323.22,NULL,NULL,1,'2021-08-27 11:36:06','2021-08-27 11:36:06',NULL),(3359,2978,41711,303847,3,3359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-12','2019-04-12',1033.20,NULL,NULL,1,'2021-08-27 11:36:06','2021-08-27 11:36:06',NULL),(3360,2978,41711,303847,3,3360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-13','2019-04-13',531.59,NULL,NULL,1,'2021-08-27 11:36:06','2021-08-27 11:36:06',NULL),(3361,2978,41711,303847,3,3361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-13','2019-04-13',425.17,NULL,NULL,1,'2021-08-27 11:36:06','2021-08-27 11:36:06',NULL),(3362,2978,41711,303847,3,3362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-15','2019-04-15',926.62,NULL,NULL,1,'2021-08-27 11:36:06','2021-08-27 11:36:06',NULL),(3363,2978,41711,303847,3,3363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-15','2019-04-15',475.32,NULL,NULL,1,'2021-08-27 11:36:06','2021-08-27 11:36:06',NULL),(3364,2978,41711,303847,3,3364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-15','2019-04-15',308.14,NULL,NULL,1,'2021-08-27 11:36:06','2021-08-27 11:36:06',NULL),(3365,2978,41711,303847,3,3365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-15','2019-04-15',1386.80,NULL,NULL,1,'2021-08-27 11:36:06','2021-08-27 11:36:06',NULL),(3366,2978,41711,303847,3,3366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-15','2019-04-15',190.90,NULL,NULL,1,'2021-08-27 11:36:06','2021-08-27 11:36:06',NULL),(3367,2978,41711,303847,3,3367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-15','2019-04-15',72.05,NULL,NULL,1,'2021-08-27 11:36:06','2021-08-27 11:36:06',NULL),(3368,2978,41711,303847,3,3368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-15','2019-04-15',1238.00,NULL,NULL,1,'2021-08-27 11:36:06','2021-08-27 11:36:06',NULL),(3369,2978,41711,303847,3,3369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-16','2019-04-16',1135.47,NULL,NULL,1,'2021-08-27 11:36:06','2021-08-27 11:36:06',NULL),(3370,2978,41711,303847,3,3370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-16','2019-04-16',317.08,NULL,NULL,1,'2021-08-27 11:36:06','2021-08-27 11:36:06',NULL),(3371,2978,41711,303847,3,3371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-17','2019-04-17',4323.03,NULL,NULL,1,'2021-08-27 11:36:06','2021-08-27 11:36:06',NULL),(3372,2978,41711,303847,3,3372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-17','2019-04-17',1380.46,NULL,NULL,1,'2021-08-27 11:36:06','2021-08-27 11:36:06',NULL),(3373,2978,41711,303847,3,3373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-17','2019-04-17',104.85,NULL,NULL,1,'2021-08-27 11:36:06','2021-08-27 11:36:06',NULL),(3374,2978,41711,303847,3,3374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-17','2019-04-17',800.80,NULL,NULL,1,'2021-08-27 11:36:06','2021-08-27 11:36:06',NULL),(3375,2978,41711,303847,3,3375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-17','2019-04-17',1564.15,NULL,NULL,1,'2021-08-27 11:36:06','2021-08-27 11:36:06',NULL),(3376,2978,41711,303847,3,3376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-18','2019-04-18',1320.91,NULL,NULL,1,'2021-08-27 11:36:06','2021-08-27 11:36:06',NULL),(3377,2978,41711,303847,3,3377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-18','2019-04-18',750.27,NULL,NULL,1,'2021-08-27 11:36:06','2021-08-27 11:36:06',NULL),(3378,2978,41711,303847,3,3378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-18','2019-04-18',345.80,NULL,NULL,1,'2021-08-27 11:36:06','2021-08-27 11:36:06',NULL),(3379,2978,41711,303847,3,3379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-18','2019-04-18',137.29,NULL,NULL,1,'2021-08-27 11:36:06','2021-08-27 11:36:06',NULL),(3380,2978,41711,303847,3,3380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-21','2019-04-21',1075.40,NULL,NULL,1,'2021-08-27 11:36:06','2021-08-27 11:36:06',NULL),(3381,2978,41711,303847,3,3381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-22','2019-04-22',291.99,NULL,NULL,1,'2021-08-27 11:36:06','2021-08-27 11:36:06',NULL);
INSERT INTO `balance_libro` VALUES (3382,2978,41711,303847,3,3382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-22','2019-04-22',1853.21,NULL,NULL,1,'2021-08-27 11:36:06','2021-08-27 11:36:06',NULL),(3383,2978,41711,303847,3,3383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-22','2019-04-22',43.30,NULL,NULL,1,'2021-08-27 11:36:07','2021-08-27 11:36:07',NULL),(3384,2978,41711,303847,3,3384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-22','2019-04-22',51.63,NULL,NULL,1,'2021-08-27 11:36:07','2021-08-27 11:36:07',NULL),(3385,2978,41711,303847,3,3385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-23','2019-04-23',472.71,NULL,NULL,1,'2021-08-27 11:36:07','2021-08-27 11:36:07',NULL),(3386,2978,41711,303847,3,3386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-23','2019-04-23',957.61,NULL,NULL,1,'2021-08-27 11:36:07','2021-08-27 11:36:07',NULL),(3387,2978,41711,303847,3,3387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-23','2019-04-23',524.87,NULL,NULL,1,'2021-08-27 11:36:07','2021-08-27 11:36:07',NULL),(3388,2978,41711,303847,3,3388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-23','2019-04-23',476.87,NULL,NULL,1,'2021-08-27 11:36:07','2021-08-27 11:36:07',NULL),(3389,2978,41711,303847,3,3389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-23','2019-04-23',47.30,NULL,NULL,1,'2021-08-27 11:36:07','2021-08-27 11:36:07',NULL),(3390,2978,41711,303847,3,3390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-23','2019-04-23',533.15,NULL,NULL,1,'2021-08-27 11:36:07','2021-08-27 11:36:07',NULL),(3391,2978,41711,303847,3,3391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-23','2019-04-23',38.96,NULL,NULL,1,'2021-08-27 11:36:07','2021-08-27 11:36:07',NULL),(3392,2978,41711,303847,3,3392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-24','2019-04-24',381.39,NULL,NULL,1,'2021-08-27 11:36:07','2021-08-27 11:36:07',NULL),(3393,2978,41711,303847,3,3393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-24','2019-04-24',216.37,NULL,NULL,1,'2021-08-27 11:36:07','2021-08-27 11:36:07',NULL),(3394,2978,41711,303847,3,3394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-24','2019-04-24',207.13,NULL,NULL,1,'2021-08-27 11:36:07','2021-08-27 11:36:07',NULL),(3395,2978,41711,303847,3,3395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-24','2019-04-24',834.95,NULL,NULL,1,'2021-08-27 11:36:07','2021-08-27 11:36:07',NULL),(3396,2978,41711,303847,3,3396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-25','2019-04-25',1025.90,NULL,NULL,1,'2021-08-27 11:36:07','2021-08-27 11:36:07',NULL),(3397,2978,41711,303847,3,3397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-25','2019-04-25',1120.67,NULL,NULL,1,'2021-08-27 11:36:07','2021-08-27 11:36:07',NULL),(3398,2978,41711,303847,3,3398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-25','2019-04-25',106.33,NULL,NULL,1,'2021-08-27 11:36:07','2021-08-27 11:36:07',NULL),(3399,2978,41711,303847,3,3399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-25','2019-04-25',1419.08,NULL,NULL,1,'2021-08-27 11:36:07','2021-08-27 11:36:07',NULL),(3400,2978,41711,303847,3,3400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-25','2019-04-25',44.95,NULL,NULL,1,'2021-08-27 11:36:07','2021-08-27 11:36:07',NULL),(3401,2978,41711,303847,3,3401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-25','2019-04-25',2872.87,NULL,NULL,1,'2021-08-27 11:36:07','2021-08-27 11:36:07',NULL),(3402,2978,41711,303847,3,3402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-26','2019-04-26',182.41,NULL,NULL,1,'2021-08-27 11:36:07','2021-08-27 11:36:07',NULL),(3403,2978,41711,303847,3,3403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-26','2019-04-26',247.49,NULL,NULL,1,'2021-08-27 11:36:07','2021-08-27 11:36:07',NULL),(3404,2978,41711,303847,3,3404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-26','2019-04-26',3537.75,NULL,NULL,1,'2021-08-27 11:36:07','2021-08-27 11:36:07',NULL),(3405,2978,41711,303847,3,3405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-26','2019-04-26',1082.40,NULL,NULL,1,'2021-08-27 11:36:07','2021-08-27 11:36:07',NULL);
INSERT INTO `balance_libro` VALUES (3406,2978,41711,303847,3,3406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-27','2019-04-27',1709.19,NULL,NULL,1,'2021-08-27 11:36:07','2021-08-27 11:36:07',NULL),(3407,2978,41711,303847,3,3407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-27','2019-04-27',384.34,NULL,NULL,1,'2021-08-27 11:36:07','2021-08-27 11:36:07',NULL),(3408,2978,41711,303847,3,3408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-29','2019-04-29',2080.58,NULL,NULL,1,'2021-08-27 11:36:07','2021-08-27 11:36:07',NULL),(3409,2978,41711,303847,3,3409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-29','2019-04-29',503.97,NULL,NULL,1,'2021-08-27 11:36:08','2021-08-27 11:36:08',NULL),(3410,2978,41711,303847,3,3410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-29','2019-04-29',3139.00,NULL,NULL,1,'2021-08-27 11:36:08','2021-08-27 11:36:08',NULL),(3411,2978,41711,303847,3,3411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-30','2019-04-30',1123.85,NULL,NULL,1,'2021-08-27 11:36:08','2021-08-27 11:36:08',NULL),(3412,2978,41711,303848,3,3412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-01','2019-05-01',896.00,NULL,NULL,1,'2021-08-27 11:37:01','2021-08-27 11:37:01',NULL),(3413,2978,41711,303848,3,3413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-01','2019-05-01',1484.19,NULL,NULL,1,'2021-08-27 11:37:01','2021-08-27 11:37:01',NULL),(3414,2978,41711,303848,3,3414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-02','2019-05-02',667.56,NULL,NULL,1,'2021-08-27 11:37:01','2021-08-27 11:37:01',NULL),(3415,2978,41711,303848,3,3415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-02','2019-05-02',811.32,NULL,NULL,1,'2021-08-27 11:37:01','2021-08-27 11:37:01',NULL),(3416,2978,41711,303848,3,3416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-02','2019-05-02',205.39,NULL,NULL,1,'2021-08-27 11:37:01','2021-08-27 11:37:01',NULL),(3417,2978,41711,303848,3,3417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-02','2019-05-02',472.24,NULL,NULL,1,'2021-08-27 11:37:01','2021-08-27 11:37:01',NULL),(3418,2978,41711,303848,3,3418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-03','2019-05-03',180.46,NULL,NULL,1,'2021-08-27 11:37:02','2021-08-27 11:37:02',NULL),(3419,2978,41711,303848,3,3419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-03','2019-05-03',342.79,NULL,NULL,1,'2021-08-27 11:37:02','2021-08-27 11:37:02',NULL),(3420,2978,41711,303848,3,3420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-03','2019-05-03',1918.56,NULL,NULL,1,'2021-08-27 11:37:02','2021-08-27 11:37:02',NULL),(3421,2978,41711,303848,3,3421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-03','2019-05-03',208.26,NULL,NULL,1,'2021-08-27 11:37:02','2021-08-27 11:37:02',NULL),(3422,2978,41711,303848,3,3422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-03','2019-05-03',512.47,NULL,NULL,1,'2021-08-27 11:37:02','2021-08-27 11:37:02',NULL),(3423,2978,41711,303848,3,3423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-03','2019-05-03',250.00,NULL,NULL,1,'2021-08-27 11:37:02','2021-08-27 11:37:02',NULL),(3424,2978,41711,303848,3,3424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-03','2019-05-03',1260.50,NULL,NULL,1,'2021-08-27 11:37:02','2021-08-27 11:37:02',NULL),(3425,2978,41711,303848,3,3425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-03','2019-05-03',1963.65,NULL,NULL,1,'2021-08-27 11:37:02','2021-08-27 11:37:02',NULL),(3426,2978,41711,303848,3,3426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-04','2019-05-04',2267.30,NULL,NULL,1,'2021-08-27 11:37:02','2021-08-27 11:37:02',NULL),(3427,2978,41711,303848,3,3427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-05','2019-05-05',1422.51,NULL,NULL,1,'2021-08-27 11:37:02','2021-08-27 11:37:02',NULL),(3428,2978,41711,303848,3,3428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-05','2019-05-05',1088.28,NULL,NULL,1,'2021-08-27 11:37:02','2021-08-27 11:37:02',NULL),(3429,2978,41711,303848,3,3429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-06','2019-05-06',677.89,NULL,NULL,1,'2021-08-27 11:37:02','2021-08-27 11:37:02',NULL);
INSERT INTO `balance_libro` VALUES (3430,2978,41711,303848,3,3430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-06','2019-05-06',158.83,NULL,NULL,1,'2021-08-27 11:37:02','2021-08-27 11:37:02',NULL),(3431,2978,41711,303848,3,3431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-06','2019-05-06',395.53,NULL,NULL,1,'2021-08-27 11:37:02','2021-08-27 11:37:02',NULL),(3432,2978,41711,303848,3,3432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-06','2019-05-06',161.61,NULL,NULL,1,'2021-08-27 11:37:02','2021-08-27 11:37:02',NULL),(3433,2978,41711,303848,3,3433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-06','2019-05-06',171.55,NULL,NULL,1,'2021-08-27 11:37:02','2021-08-27 11:37:02',NULL),(3434,2978,41711,303848,3,3434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-06','2019-05-06',1428.71,NULL,NULL,1,'2021-08-27 11:37:02','2021-08-27 11:37:02',NULL),(3435,2978,41711,303848,3,3435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-07','2019-05-07',308.89,NULL,NULL,1,'2021-08-27 11:37:02','2021-08-27 11:37:02',NULL),(3436,2978,41711,303848,3,3436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-07','2019-05-07',119.01,NULL,NULL,1,'2021-08-27 11:37:02','2021-08-27 11:37:02',NULL),(3437,2978,41711,303848,3,3437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-07','2019-05-07',390.29,NULL,NULL,1,'2021-08-27 11:37:02','2021-08-27 11:37:02',NULL),(3438,2978,41711,303848,3,3438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-07','2019-05-07',292.56,NULL,NULL,1,'2021-08-27 11:37:02','2021-08-27 11:37:02',NULL),(3439,2978,41711,303848,3,3439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-07','2019-05-07',167.58,NULL,NULL,1,'2021-08-27 11:37:02','2021-08-27 11:37:02',NULL),(3440,2978,41711,303848,3,3440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-07','2019-05-07',193.17,NULL,NULL,1,'2021-08-27 11:37:02','2021-08-27 11:37:02',NULL),(3441,2978,41711,303848,3,3441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-07','2019-05-07',1556.81,NULL,NULL,1,'2021-08-27 11:37:02','2021-08-27 11:37:02',NULL),(3442,2978,41711,303848,3,3442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-07','2019-05-07',326.92,NULL,NULL,1,'2021-08-27 11:37:02','2021-08-27 11:37:02',NULL),(3443,2978,41711,303848,3,3443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-07','2019-05-07',222.19,NULL,NULL,1,'2021-08-27 11:37:03','2021-08-27 11:37:03',NULL),(3444,2978,41711,303848,3,3444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-07','2019-05-07',660.10,NULL,NULL,1,'2021-08-27 11:37:03','2021-08-27 11:37:03',NULL),(3445,2978,41711,303848,3,3445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-08','2019-05-08',1066.58,NULL,NULL,1,'2021-08-27 11:37:03','2021-08-27 11:37:03',NULL),(3446,2978,41711,303848,3,3446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-08','2019-05-08',672.19,NULL,NULL,1,'2021-08-27 11:37:03','2021-08-27 11:37:03',NULL),(3447,2978,41711,303848,3,3447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-08','2019-05-08',1732.41,NULL,NULL,1,'2021-08-27 11:37:03','2021-08-27 11:37:03',NULL),(3448,2978,41711,303848,3,3448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-08','2019-05-08',316.76,NULL,NULL,1,'2021-08-27 11:37:03','2021-08-27 11:37:03',NULL),(3449,2978,41711,303848,3,3449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-08','2019-05-08',342.63,NULL,NULL,1,'2021-08-27 11:37:03','2021-08-27 11:37:03',NULL),(3450,2978,41711,303848,3,3450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-08','2019-05-08',0.01,NULL,NULL,1,'2021-08-27 11:37:03','2021-08-27 11:37:03',NULL),(3451,2978,41711,303848,3,3451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-08','2019-05-08',2208.88,NULL,NULL,1,'2021-08-27 11:37:03','2021-08-27 11:37:03',NULL),(3452,2978,41711,303848,3,3452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-09','2019-05-09',758.49,NULL,NULL,1,'2021-08-27 11:37:03','2021-08-27 11:37:03',NULL),(3453,2978,41711,303848,3,3453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-09','2019-05-09',1726.95,NULL,NULL,1,'2021-08-27 11:37:03','2021-08-27 11:37:03',NULL);
INSERT INTO `balance_libro` VALUES (3454,2978,41711,303848,3,3454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-09','2019-05-09',319.47,NULL,NULL,1,'2021-08-27 11:37:03','2021-08-27 11:37:03',NULL),(3455,2978,41711,303848,3,3455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-09','2019-05-09',904.95,NULL,NULL,1,'2021-08-27 11:37:03','2021-08-27 11:37:03',NULL),(3456,2978,41711,303848,3,3456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-09','2019-05-09',499.77,NULL,NULL,1,'2021-08-27 11:37:03','2021-08-27 11:37:03',NULL),(3457,2978,41711,303848,3,3457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-10','2019-05-10',4739.76,NULL,NULL,1,'2021-08-27 11:37:03','2021-08-27 11:37:03',NULL),(3458,2978,41711,303848,3,3458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-10','2019-05-10',603.86,NULL,NULL,1,'2021-08-27 11:37:03','2021-08-27 11:37:03',NULL),(3459,2978,41711,303848,3,3459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-10','2019-05-10',1071.94,NULL,NULL,1,'2021-08-27 11:37:03','2021-08-27 11:37:03',NULL),(3460,2978,41711,303848,3,3460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-10','2019-05-10',1071.53,NULL,NULL,1,'2021-08-27 11:37:03','2021-08-27 11:37:03',NULL),(3461,2978,41711,303848,3,3461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-13','2019-05-13',1047.08,NULL,NULL,1,'2021-08-27 11:37:03','2021-08-27 11:37:03',NULL),(3462,2978,41711,303848,3,3462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-13','2019-05-13',79.61,NULL,NULL,1,'2021-08-27 11:37:04','2021-08-27 11:37:04',NULL),(3463,2978,41711,303848,3,3463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-13','2019-05-13',634.92,NULL,NULL,1,'2021-08-27 11:37:04','2021-08-27 11:37:04',NULL),(3464,2978,41711,303848,3,3464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-14','2019-05-14',593.03,NULL,NULL,1,'2021-08-27 11:37:04','2021-08-27 11:37:04',NULL),(3465,2978,41711,303848,3,3465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-14','2019-05-14',1619.54,NULL,NULL,1,'2021-08-27 11:37:04','2021-08-27 11:37:04',NULL),(3466,2978,41711,303848,3,3466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-14','2019-05-14',98.70,NULL,NULL,1,'2021-08-27 11:37:04','2021-08-27 11:37:04',NULL),(3467,2978,41711,303848,3,3467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-14','2019-05-14',184.50,NULL,NULL,1,'2021-08-27 11:37:04','2021-08-27 11:37:04',NULL),(3468,2978,41711,303848,3,3468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-14','2019-05-14',232.98,NULL,NULL,1,'2021-08-27 11:37:04','2021-08-27 11:37:04',NULL),(3469,2978,41711,303848,3,3469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-14','2019-05-14',415.41,NULL,NULL,1,'2021-08-27 11:37:04','2021-08-27 11:37:04',NULL),(3470,2978,41711,303848,3,3470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-14','2019-05-14',210.99,NULL,NULL,1,'2021-08-27 11:37:04','2021-08-27 11:37:04',NULL),(3471,2978,41711,303848,3,3471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-14','2019-05-14',693.86,NULL,NULL,1,'2021-08-27 11:37:04','2021-08-27 11:37:04',NULL),(3472,2978,41711,303848,3,3472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-14','2019-05-14',193.17,NULL,NULL,1,'2021-08-27 11:37:04','2021-08-27 11:37:04',NULL),(3473,2978,41711,303848,3,3473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-14','2019-05-14',172.85,NULL,NULL,1,'2021-08-27 11:37:04','2021-08-27 11:37:04',NULL),(3474,2978,41711,303848,3,3474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-14','2019-05-14',519.89,NULL,NULL,1,'2021-08-27 11:37:04','2021-08-27 11:37:04',NULL),(3475,2978,41711,303848,3,3475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-14','2019-05-14',140.13,NULL,NULL,1,'2021-08-27 11:37:04','2021-08-27 11:37:04',NULL),(3476,2978,41711,303848,3,3476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-15','2019-05-15',683.89,NULL,NULL,1,'2021-08-27 11:37:04','2021-08-27 11:37:04',NULL),(3477,2978,41711,303848,3,3477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-15','2019-05-15',1774.99,NULL,NULL,1,'2021-08-27 11:37:04','2021-08-27 11:37:04',NULL);
INSERT INTO `balance_libro` VALUES (3478,2978,41711,303848,3,3478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-15','2019-05-15',193.17,NULL,NULL,1,'2021-08-27 11:37:04','2021-08-27 11:37:04',NULL),(3479,2978,41711,303848,3,3479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-16','2019-05-16',2482.53,NULL,NULL,1,'2021-08-27 11:37:04','2021-08-27 11:37:04',NULL),(3480,2978,41711,303848,3,3480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-16','2019-05-16',65.24,NULL,NULL,1,'2021-08-27 11:37:04','2021-08-27 11:37:04',NULL),(3481,2978,41711,303848,3,3481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-16','2019-05-16',215.41,NULL,NULL,1,'2021-08-27 11:37:04','2021-08-27 11:37:04',NULL),(3482,2978,41711,303848,3,3482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-16','2019-05-16',763.55,NULL,NULL,1,'2021-08-27 11:37:04','2021-08-27 11:37:04',NULL),(3483,2978,41711,303848,3,3483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-16','2019-05-16',399.67,NULL,NULL,1,'2021-08-27 11:37:04','2021-08-27 11:37:04',NULL),(3484,2978,41711,303848,3,3484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-16','2019-05-16',816.44,NULL,NULL,1,'2021-08-27 11:37:04','2021-08-27 11:37:04',NULL),(3485,2978,41711,303848,3,3485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-16','2019-05-16',656.00,NULL,NULL,1,'2021-08-27 11:37:04','2021-08-27 11:37:04',NULL),(3486,2978,41711,303848,3,3486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-17','2019-05-17',593.80,NULL,NULL,1,'2021-08-27 11:37:05','2021-08-27 11:37:05',NULL),(3487,2978,41711,303848,3,3487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-17','2019-05-17',201.93,NULL,NULL,1,'2021-08-27 11:37:05','2021-08-27 11:37:05',NULL),(3488,2978,41711,303848,3,3488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-17','2019-05-17',849.44,NULL,NULL,1,'2021-08-27 11:37:05','2021-08-27 11:37:05',NULL),(3489,2978,41711,303848,3,3489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-17','2019-05-17',552.22,NULL,NULL,1,'2021-08-27 11:37:05','2021-08-27 11:37:05',NULL),(3490,2978,41711,303848,3,3490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-17','2019-05-17',575.23,NULL,NULL,1,'2021-08-27 11:37:05','2021-08-27 11:37:05',NULL),(3491,2978,41711,303848,3,3491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-17','2019-05-17',345.80,NULL,NULL,1,'2021-08-27 11:37:05','2021-08-27 11:37:05',NULL),(3492,2978,41711,303848,3,3492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-17','2019-05-17',659.84,NULL,NULL,1,'2021-08-27 11:37:05','2021-08-27 11:37:05',NULL),(3493,2978,41711,303848,3,3493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-17','2019-05-17',1968.00,NULL,NULL,1,'2021-08-27 11:37:05','2021-08-27 11:37:05',NULL),(3494,2978,41711,303848,3,3494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-18','2019-05-18',1155.73,NULL,NULL,1,'2021-08-27 11:37:05','2021-08-27 11:37:05',NULL),(3495,2978,41711,303848,3,3495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-19','2019-05-19',176.24,NULL,NULL,1,'2021-08-27 11:37:05','2021-08-27 11:37:05',NULL),(3496,2978,41711,303848,3,3496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-20','2019-05-20',579.53,NULL,NULL,1,'2021-08-27 11:37:05','2021-08-27 11:37:05',NULL),(3497,2978,41711,303848,3,3497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-20','2019-05-20',201.86,NULL,NULL,1,'2021-08-27 11:37:05','2021-08-27 11:37:05',NULL),(3498,2978,41711,303848,3,3498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-20','2019-05-20',69.14,NULL,NULL,1,'2021-08-27 11:37:05','2021-08-27 11:37:05',NULL),(3499,2978,41711,303848,3,3499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-20','2019-05-20',413.69,NULL,NULL,1,'2021-08-27 11:37:05','2021-08-27 11:37:05',NULL),(3500,2978,41711,303848,3,3500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-20','2019-05-20',325.05,NULL,NULL,1,'2021-08-27 11:37:05','2021-08-27 11:37:05',NULL),(3501,2978,41711,303848,3,3501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-20','2019-05-20',1033.56,NULL,NULL,1,'2021-08-27 11:37:05','2021-08-27 11:37:05',NULL);
INSERT INTO `balance_libro` VALUES (3502,2978,41711,303848,3,3502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-20','2019-05-20',1454.26,NULL,NULL,1,'2021-08-27 11:37:05','2021-08-27 11:37:05',NULL),(3503,2978,41711,303848,3,3503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-20','2019-05-20',169.18,NULL,NULL,1,'2021-08-27 11:37:05','2021-08-27 11:37:05',NULL),(3504,2978,41711,303848,3,3504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-21','2019-05-21',564.21,NULL,NULL,1,'2021-08-27 11:37:05','2021-08-27 11:37:05',NULL),(3505,2978,41711,303848,3,3505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-21','2019-05-21',1305.00,NULL,NULL,1,'2021-08-27 11:37:06','2021-08-27 11:37:06',NULL),(3506,2978,41711,303848,3,3506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-21','2019-05-21',55.40,NULL,NULL,1,'2021-08-27 11:37:06','2021-08-27 11:37:06',NULL),(3507,2978,41711,303848,3,3507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-22','2019-05-22',1311.66,NULL,NULL,1,'2021-08-27 11:37:06','2021-08-27 11:37:06',NULL),(3508,2978,41711,303848,3,3508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-22','2019-05-22',524.88,NULL,NULL,1,'2021-08-27 11:37:06','2021-08-27 11:37:06',NULL),(3509,2978,41711,303848,3,3509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-22','2019-05-22',254.76,NULL,NULL,1,'2021-08-27 11:37:06','2021-08-27 11:37:06',NULL),(3510,2978,41711,303848,3,3510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-23','2019-05-23',839.03,NULL,NULL,1,'2021-08-27 11:37:06','2021-08-27 11:37:06',NULL),(3511,2978,41711,303848,3,3511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-23','2019-05-23',161.61,NULL,NULL,1,'2021-08-27 11:37:06','2021-08-27 11:37:06',NULL),(3512,2978,41711,303848,3,3512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-23','2019-05-23',149.79,NULL,NULL,1,'2021-08-27 11:37:06','2021-08-27 11:37:06',NULL),(3513,2978,41711,303848,3,3513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-23','2019-05-23',480.92,NULL,NULL,1,'2021-08-27 11:37:06','2021-08-27 11:37:06',NULL),(3514,2978,41711,303848,3,3514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-23','2019-05-23',325.11,NULL,NULL,1,'2021-08-27 11:37:06','2021-08-27 11:37:06',NULL),(3515,2978,41711,303848,3,3515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-23','2019-05-23',1829.88,NULL,NULL,1,'2021-08-27 11:37:06','2021-08-27 11:37:06',NULL),(3516,2978,41711,303848,3,3516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-23','2019-05-23',274.20,NULL,NULL,1,'2021-08-27 11:37:06','2021-08-27 11:37:06',NULL),(3517,2978,41711,303848,3,3517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-24','2019-05-24',308.44,NULL,NULL,1,'2021-08-27 11:37:06','2021-08-27 11:37:06',NULL),(3518,2978,41711,303848,3,3518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-24','2019-05-24',150.90,NULL,NULL,1,'2021-08-27 11:37:06','2021-08-27 11:37:06',NULL),(3519,2978,41711,303848,3,3519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-24','2019-05-24',1486.86,NULL,NULL,1,'2021-08-27 11:37:06','2021-08-27 11:37:06',NULL),(3520,2978,41711,303848,3,3520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-24','2019-05-24',286.24,NULL,NULL,1,'2021-08-27 11:37:06','2021-08-27 11:37:06',NULL),(3521,2978,41711,303848,3,3521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-24','2019-05-24',47.68,NULL,NULL,1,'2021-08-27 11:37:06','2021-08-27 11:37:06',NULL),(3522,2978,41711,303848,3,3522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-24','2019-05-24',71.07,NULL,NULL,1,'2021-08-27 11:37:06','2021-08-27 11:37:06',NULL),(3523,2978,41711,303848,3,3523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-25','2019-05-25',1251.92,NULL,NULL,1,'2021-08-27 11:37:06','2021-08-27 11:37:06',NULL),(3524,2978,41711,303848,3,3524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-25','2019-05-25',106.61,NULL,NULL,1,'2021-08-27 11:37:06','2021-08-27 11:37:06',NULL),(3525,2978,41711,303848,3,3525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-27','2019-05-27',674.67,NULL,NULL,1,'2021-08-27 11:37:06','2021-08-27 11:37:06',NULL);
INSERT INTO `balance_libro` VALUES (3526,2978,41711,303848,3,3526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-27','2019-05-27',189.53,NULL,NULL,1,'2021-08-27 11:37:06','2021-08-27 11:37:06',NULL),(3527,2978,41711,303848,3,3527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-27','2019-05-27',1964.95,NULL,NULL,1,'2021-08-27 11:37:06','2021-08-27 11:37:06',NULL),(3528,2978,41711,303848,3,3528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-27','2019-05-27',1495.92,NULL,NULL,1,'2021-08-27 11:37:06','2021-08-27 11:37:06',NULL),(3529,2978,41711,303848,3,3529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-27','2019-05-27',2422.34,NULL,NULL,1,'2021-08-27 11:37:07','2021-08-27 11:37:07',NULL),(3530,2978,41711,303848,3,3530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-27','2019-05-27',274.61,NULL,NULL,1,'2021-08-27 11:37:07','2021-08-27 11:37:07',NULL),(3531,2978,41711,303848,3,3531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-27','2019-05-27',1970.05,NULL,NULL,1,'2021-08-27 11:37:07','2021-08-27 11:37:07',NULL),(3532,2978,41711,303848,3,3532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-28','2019-05-28',5144.51,NULL,NULL,1,'2021-08-27 11:37:07','2021-08-27 11:37:07',NULL),(3533,2978,41711,303848,3,3533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-28','2019-05-28',698.74,NULL,NULL,1,'2021-08-27 11:37:07','2021-08-27 11:37:07',NULL),(3534,2978,41711,303848,3,3534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-28','2019-05-28',237.31,NULL,NULL,1,'2021-08-27 11:37:07','2021-08-27 11:37:07',NULL),(3535,2978,41711,303848,3,3535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-29','2019-05-29',417.62,NULL,NULL,1,'2021-08-27 11:37:07','2021-08-27 11:37:07',NULL),(3536,2978,41711,303848,3,3536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-29','2019-05-29',616.69,NULL,NULL,1,'2021-08-27 11:37:07','2021-08-27 11:37:07',NULL),(3537,2978,41711,303848,3,3537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-29','2019-05-29',369.99,NULL,NULL,1,'2021-08-27 11:37:07','2021-08-27 11:37:07',NULL),(3538,2978,41711,303848,3,3538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-29','2019-05-29',5166.43,NULL,NULL,1,'2021-08-27 11:37:07','2021-08-27 11:37:07',NULL),(3539,2978,41711,303848,3,3539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-30','2019-05-30',593.75,NULL,NULL,1,'2021-08-27 11:37:07','2021-08-27 11:37:07',NULL),(3540,2978,41711,303848,3,3540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-30','2019-05-30',129.46,NULL,NULL,1,'2021-08-27 11:37:07','2021-08-27 11:37:07',NULL),(3541,2978,41711,303848,3,3541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-30','2019-05-30',756.11,NULL,NULL,1,'2021-08-27 11:37:07','2021-08-27 11:37:07',NULL),(3542,2978,41711,303848,3,3542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-30','2019-05-30',586.33,NULL,NULL,1,'2021-08-27 11:37:07','2021-08-27 11:37:07',NULL),(3543,2978,41711,303848,3,3543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-31','2019-05-31',1300.65,NULL,NULL,1,'2021-08-27 11:37:07','2021-08-27 11:37:07',NULL),(3544,2978,41711,303848,3,3544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-31','2019-05-31',1644.19,NULL,NULL,1,'2021-08-27 11:37:07','2021-08-27 11:37:07',NULL),(3545,2978,41711,303848,3,3545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-31','2019-05-31',171.08,NULL,NULL,1,'2021-08-27 11:37:07','2021-08-27 11:37:07',NULL),(3546,2978,41711,303848,3,3546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-31','2019-05-31',329.52,NULL,NULL,1,'2021-08-27 11:37:07','2021-08-27 11:37:07',NULL),(3547,2978,41711,303848,3,3547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-31','2019-05-31',6067.68,NULL,NULL,1,'2021-08-27 11:37:07','2021-08-27 11:37:07',NULL),(3548,2978,41711,303848,3,3548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-05-31','2019-05-31',1123.85,NULL,NULL,1,'2021-08-27 11:37:07','2021-08-27 11:37:07',NULL),(3549,2978,41711,303844,3,3549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-01','2019-01-01',1228.15,NULL,NULL,1,'2021-08-27 11:38:56','2021-08-27 11:38:56',NULL);
INSERT INTO `balance_libro` VALUES (3550,2978,41711,303844,3,3550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-02','2019-01-02',1654.74,NULL,NULL,1,'2021-08-27 11:38:56','2021-08-27 11:38:56',NULL),(3551,2978,41711,303844,3,3551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-02','2019-01-02',3100.63,NULL,NULL,1,'2021-08-27 11:38:56','2021-08-27 11:38:56',NULL),(3552,2978,41711,303844,3,3552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-02','2019-01-02',790.06,NULL,NULL,1,'2021-08-27 11:38:56','2021-08-27 11:38:56',NULL),(3553,2978,41711,303844,3,3553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-02','2019-01-02',209.26,NULL,NULL,1,'2021-08-27 11:38:56','2021-08-27 11:38:56',NULL),(3554,2978,41711,303844,3,3554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-03','2019-01-03',748.42,NULL,NULL,1,'2021-08-27 11:38:56','2021-08-27 11:38:56',NULL),(3555,2978,41711,303844,3,3555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-03','2019-01-03',610.41,NULL,NULL,1,'2021-08-27 11:38:56','2021-08-27 11:38:56',NULL),(3556,2978,41711,303844,3,3556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-03','2019-01-03',790.46,NULL,NULL,1,'2021-08-27 11:38:56','2021-08-27 11:38:56',NULL),(3557,2978,41711,303844,3,3557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-03','2019-01-03',370.05,NULL,NULL,1,'2021-08-27 11:38:56','2021-08-27 11:38:56',NULL),(3558,2978,41711,303844,3,3558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-04','2019-01-04',627.90,NULL,NULL,1,'2021-08-27 11:38:56','2021-08-27 11:38:56',NULL),(3559,2978,41711,303844,3,3559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-04','2019-01-04',89.17,NULL,NULL,1,'2021-08-27 11:38:56','2021-08-27 11:38:56',NULL),(3560,2978,41711,303844,3,3560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-04','2019-01-04',1349.01,NULL,NULL,1,'2021-08-27 11:38:56','2021-08-27 11:38:56',NULL),(3561,2978,41711,303844,3,3561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-04','2019-01-04',164.23,NULL,NULL,1,'2021-08-27 11:38:56','2021-08-27 11:38:56',NULL),(3562,2978,41711,303844,3,3562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-04','2019-01-04',878.43,NULL,NULL,1,'2021-08-27 11:38:56','2021-08-27 11:38:56',NULL),(3563,2978,41711,303844,3,3563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-04','2019-01-04',2046.18,NULL,NULL,1,'2021-08-27 11:38:56','2021-08-27 11:38:56',NULL),(3564,2978,41711,303844,3,3564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-04','2019-01-04',800.47,NULL,NULL,1,'2021-08-27 11:38:56','2021-08-27 11:38:56',NULL),(3565,2978,41711,303844,3,3565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-04','2019-01-04',1918.75,NULL,NULL,1,'2021-08-27 11:38:56','2021-08-27 11:38:56',NULL),(3566,2978,41711,303844,3,3566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-07','2019-01-07',159.02,NULL,NULL,1,'2021-08-27 11:38:56','2021-08-27 11:38:56',NULL),(3567,2978,41711,303844,3,3567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-07','2019-01-07',232.78,NULL,NULL,1,'2021-08-27 11:38:56','2021-08-27 11:38:56',NULL),(3568,2978,41711,303844,3,3568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-07','2019-01-07',681.15,NULL,NULL,1,'2021-08-27 11:38:56','2021-08-27 11:38:56',NULL),(3569,2978,41711,303844,3,3569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-07','2019-01-07',465.09,NULL,NULL,1,'2021-08-27 11:38:57','2021-08-27 11:38:57',NULL),(3570,2978,41711,303844,3,3570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-07','2019-01-07',250.00,NULL,NULL,1,'2021-08-27 11:38:57','2021-08-27 11:38:57',NULL),(3571,2978,41711,303844,3,3571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-07','2019-01-07',223.25,NULL,NULL,1,'2021-08-27 11:38:57','2021-08-27 11:38:57',NULL),(3572,2978,41711,303844,3,3572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-07','2019-01-07',860.44,NULL,NULL,1,'2021-08-27 11:38:57','2021-08-27 11:38:57',NULL),(3573,2978,41711,303844,3,3573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-07','2019-01-07',64.29,NULL,NULL,1,'2021-08-27 11:38:57','2021-08-27 11:38:57',NULL);
INSERT INTO `balance_libro` VALUES (3574,2978,41711,303844,3,3574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-08','2019-01-08',1128.33,NULL,NULL,1,'2021-08-27 11:38:57','2021-08-27 11:38:57',NULL),(3575,2978,41711,303844,3,3575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-08','2019-01-08',786.91,NULL,NULL,1,'2021-08-27 11:38:57','2021-08-27 11:38:57',NULL),(3576,2978,41711,303844,3,3576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-09','2019-01-09',737.61,NULL,NULL,1,'2021-08-27 11:38:57','2021-08-27 11:38:57',NULL),(3577,2978,41711,303844,3,3577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-09','2019-01-09',366.79,NULL,NULL,1,'2021-08-27 11:38:57','2021-08-27 11:38:57',NULL),(3578,2978,41711,303844,3,3578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-09','2019-01-09',984.97,NULL,NULL,1,'2021-08-27 11:38:57','2021-08-27 11:38:57',NULL),(3579,2978,41711,303844,3,3579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-09','2019-01-09',304.06,NULL,NULL,1,'2021-08-27 11:38:57','2021-08-27 11:38:57',NULL),(3580,2978,41711,303844,3,3580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-09','2019-01-09',675.59,NULL,NULL,1,'2021-08-27 11:38:57','2021-08-27 11:38:57',NULL),(3581,2978,41711,303844,3,3581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-10','2019-01-10',68.77,NULL,NULL,1,'2021-08-27 11:38:57','2021-08-27 11:38:57',NULL),(3582,2978,41711,303844,3,3582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-10','2019-01-10',48.91,NULL,NULL,1,'2021-08-27 11:38:57','2021-08-27 11:38:57',NULL),(3583,2978,41711,303844,3,3583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-10','2019-01-10',148.14,NULL,NULL,1,'2021-08-27 11:38:57','2021-08-27 11:38:57',NULL),(3584,2978,41711,303844,3,3584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-10','2019-01-10',702.60,NULL,NULL,1,'2021-08-27 11:38:57','2021-08-27 11:38:57',NULL),(3585,2978,41711,303844,3,3585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-11','2019-01-11',582.17,NULL,NULL,1,'2021-08-27 11:38:57','2021-08-27 11:38:57',NULL),(3586,2978,41711,303844,3,3586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-11','2019-01-11',267.11,NULL,NULL,1,'2021-08-27 11:38:57','2021-08-27 11:38:57',NULL),(3587,2978,41711,303844,3,3587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-11','2019-01-11',590.99,NULL,NULL,1,'2021-08-27 11:38:57','2021-08-27 11:38:57',NULL),(3588,2978,41711,303844,3,3588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-14','2019-01-14',76.99,NULL,NULL,1,'2021-08-27 11:38:57','2021-08-27 11:38:57',NULL),(3589,2978,41711,303844,3,3589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-14','2019-01-14',880.54,NULL,NULL,1,'2021-08-27 11:38:57','2021-08-27 11:38:57',NULL),(3590,2978,41711,303844,3,3590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-14','2019-01-14',2466.02,NULL,NULL,1,'2021-08-27 11:38:57','2021-08-27 11:38:57',NULL),(3591,2978,41711,303844,3,3591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-15','2019-01-15',695.36,NULL,NULL,1,'2021-08-27 11:38:57','2021-08-27 11:38:57',NULL),(3592,2978,41711,303844,3,3592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-15','2019-01-15',60.46,NULL,NULL,1,'2021-08-27 11:38:57','2021-08-27 11:38:57',NULL),(3593,2978,41711,303844,3,3593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-15','2019-01-15',973.61,NULL,NULL,1,'2021-08-27 11:38:57','2021-08-27 11:38:57',NULL),(3594,2978,41711,303844,3,3594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-16','2019-01-16',1453.72,NULL,NULL,1,'2021-08-27 11:38:57','2021-08-27 11:38:57',NULL),(3595,2978,41711,303844,3,3595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-16','2019-01-16',227.31,NULL,NULL,1,'2021-08-27 11:38:57','2021-08-27 11:38:57',NULL),(3596,2978,41711,303844,3,3596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-17','2019-01-17',611.66,NULL,NULL,1,'2021-08-27 11:38:58','2021-08-27 11:38:58',NULL),(3597,2978,41711,303844,3,3597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-17','2019-01-17',583.08,NULL,NULL,1,'2021-08-27 11:38:58','2021-08-27 11:38:58',NULL);
INSERT INTO `balance_libro` VALUES (3598,2978,41711,303844,3,3598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-17','2019-01-17',800.86,NULL,NULL,1,'2021-08-27 11:38:58','2021-08-27 11:38:58',NULL),(3599,2978,41711,303844,3,3599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-17','2019-01-17',492.37,NULL,NULL,1,'2021-08-27 11:38:58','2021-08-27 11:38:58',NULL),(3600,2978,41711,303844,3,3600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-18','2019-01-18',132.03,NULL,NULL,1,'2021-08-27 11:38:58','2021-08-27 11:38:58',NULL),(3601,2978,41711,303844,3,3601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-18','2019-01-18',164.23,NULL,NULL,1,'2021-08-27 11:38:58','2021-08-27 11:38:58',NULL),(3602,2978,41711,303844,3,3602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-18','2019-01-18',806.59,NULL,NULL,1,'2021-08-27 11:38:58','2021-08-27 11:38:58',NULL),(3603,2978,41711,303844,3,3603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-21','2019-01-21',1242.83,NULL,NULL,1,'2021-08-27 11:38:58','2021-08-27 11:38:58',NULL),(3604,2978,41711,303844,3,3604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-21','2019-01-21',181.42,NULL,NULL,1,'2021-08-27 11:38:58','2021-08-27 11:38:58',NULL),(3605,2978,41711,303844,3,3605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-21','2019-01-21',1636.03,NULL,NULL,1,'2021-08-27 11:38:58','2021-08-27 11:38:58',NULL),(3606,2978,41711,303844,3,3606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-21','2019-01-21',466.59,NULL,NULL,1,'2021-08-27 11:38:58','2021-08-27 11:38:58',NULL),(3607,2978,41711,303844,3,3607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-22','2019-01-22',1760.65,NULL,NULL,1,'2021-08-27 11:38:58','2021-08-27 11:38:58',NULL),(3608,2978,41711,303844,3,3608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-22','2019-01-22',345.80,NULL,NULL,1,'2021-08-27 11:38:58','2021-08-27 11:38:58',NULL),(3609,2978,41711,303844,3,3609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-23','2019-01-23',492.32,NULL,NULL,1,'2021-08-27 11:38:58','2021-08-27 11:38:58',NULL),(3610,2978,41711,303844,3,3610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-23','2019-01-23',2017.44,NULL,NULL,1,'2021-08-27 11:38:58','2021-08-27 11:38:58',NULL),(3611,2978,41711,303844,3,3611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-23','2019-01-23',465.09,NULL,NULL,1,'2021-08-27 11:38:58','2021-08-27 11:38:58',NULL),(3612,2978,41711,303844,3,3612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-23','2019-01-23',62.37,NULL,NULL,1,'2021-08-27 11:38:58','2021-08-27 11:38:58',NULL),(3613,2978,41711,303844,3,3613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-23','2019-01-23',453.66,NULL,NULL,1,'2021-08-27 11:38:58','2021-08-27 11:38:58',NULL),(3614,2978,41711,303844,3,3614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-24','2019-01-24',728.22,NULL,NULL,1,'2021-08-27 11:38:58','2021-08-27 11:38:58',NULL),(3615,2978,41711,303844,3,3615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-24','2019-01-24',346.57,NULL,NULL,1,'2021-08-27 11:38:58','2021-08-27 11:38:58',NULL),(3616,2978,41711,303844,3,3616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-24','2019-01-24',346.86,NULL,NULL,1,'2021-08-27 11:38:58','2021-08-27 11:38:58',NULL),(3617,2978,41711,303844,3,3617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-25','2019-01-25',230.33,NULL,NULL,1,'2021-08-27 11:38:58','2021-08-27 11:38:58',NULL),(3618,2978,41711,303844,3,3618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-25','2019-01-25',181.42,NULL,NULL,1,'2021-08-27 11:38:58','2021-08-27 11:38:58',NULL),(3619,2978,41711,303844,3,3619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-26','2019-01-26',122.38,NULL,NULL,1,'2021-08-27 11:38:58','2021-08-27 11:38:58',NULL),(3620,2978,41711,303844,3,3620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-26','2019-01-26',181.42,NULL,NULL,1,'2021-08-27 11:38:58','2021-08-27 11:38:58',NULL),(3621,2978,41711,303844,3,3621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-28','2019-01-28',3965.60,NULL,NULL,1,'2021-08-27 11:38:58','2021-08-27 11:38:58',NULL);
INSERT INTO `balance_libro` VALUES (3622,2978,41711,303844,3,3622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-28','2019-01-28',241.05,NULL,NULL,1,'2021-08-27 11:38:59','2021-08-27 11:38:59',NULL),(3623,2978,41711,303844,3,3623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-29','2019-01-29',1146.96,NULL,NULL,1,'2021-08-27 11:38:59','2021-08-27 11:38:59',NULL),(3624,2978,41711,303844,3,3624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-29','2019-01-29',247.15,NULL,NULL,1,'2021-08-27 11:38:59','2021-08-27 11:38:59',NULL),(3625,2978,41711,303844,3,3625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-29','2019-01-29',505.81,NULL,NULL,1,'2021-08-27 11:38:59','2021-08-27 11:38:59',NULL),(3626,2978,41711,303844,3,3626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-29','2019-01-29',75.61,NULL,NULL,1,'2021-08-27 11:38:59','2021-08-27 11:38:59',NULL),(3627,2978,41711,303844,3,3627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-30','2019-01-30',369.96,NULL,NULL,1,'2021-08-27 11:38:59','2021-08-27 11:38:59',NULL),(3628,2978,41711,303844,3,3628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-30','2019-01-30',345.85,NULL,NULL,1,'2021-08-27 11:38:59','2021-08-27 11:38:59',NULL),(3629,2978,41711,303844,3,3629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-31','2019-01-31',610.99,NULL,NULL,1,'2021-08-27 11:38:59','2021-08-27 11:38:59',NULL),(3630,2978,41711,303844,3,3630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-01-31','2019-01-31',1125.00,NULL,NULL,1,'2021-08-27 11:38:59','2021-08-27 11:38:59',NULL),(3631,2978,41711,303849,3,3631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-01','2019-06-01',1473.78,NULL,NULL,1,'2021-08-27 12:25:53','2021-08-27 12:25:53',NULL),(3632,2978,41711,303849,3,3632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-01','2019-06-01',1776.28,NULL,NULL,1,'2021-08-27 12:25:53','2021-08-27 12:25:53',NULL),(3633,2978,41711,303849,3,3633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-01','2019-06-01',1776.28,NULL,NULL,1,'2021-08-27 12:25:53','2021-08-27 12:25:53',NULL),(3634,2978,41711,303849,3,3634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-03','2019-06-03',116.94,NULL,NULL,1,'2021-08-27 12:25:53','2021-08-27 12:25:53',NULL),(3635,2978,41711,303849,3,3635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-03','2019-06-03',1297.66,NULL,NULL,1,'2021-08-27 12:25:53','2021-08-27 12:25:53',NULL),(3636,2978,41711,303849,3,3636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-03','2019-06-03',617.31,NULL,NULL,1,'2021-08-27 12:25:53','2021-08-27 12:25:53',NULL),(3637,2978,41711,303849,3,3637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-03','2019-06-03',194.40,NULL,NULL,1,'2021-08-27 12:25:54','2021-08-27 12:25:54',NULL),(3638,2978,41711,303849,3,3638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-04','2019-06-04',1002.83,NULL,NULL,1,'2021-08-27 12:25:54','2021-08-27 12:25:54',NULL),(3639,2978,41711,303849,3,3639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-04','2019-06-04',1321.47,NULL,NULL,1,'2021-08-27 12:25:54','2021-08-27 12:25:54',NULL),(3640,2978,41711,303849,3,3640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-04','2019-06-04',212.12,NULL,NULL,1,'2021-08-27 12:25:54','2021-08-27 12:25:54',NULL),(3641,2978,41711,303849,3,3641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-04','2019-06-04',106.84,NULL,NULL,1,'2021-08-27 12:25:54','2021-08-27 12:25:54',NULL),(3642,2978,41711,303849,3,3642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-04','2019-06-04',197.48,NULL,NULL,1,'2021-08-27 12:25:54','2021-08-27 12:25:54',NULL),(3643,2978,41711,303849,3,3643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-04','2019-06-04',2151.87,NULL,NULL,1,'2021-08-27 12:25:54','2021-08-27 12:25:54',NULL),(3644,2978,41711,303849,3,3644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-04','2019-06-04',521.88,NULL,NULL,1,'2021-08-27 12:25:54','2021-08-27 12:25:54',NULL),(3645,2978,41711,303849,3,3645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-04','2019-06-04',424.35,NULL,NULL,1,'2021-08-27 12:25:54','2021-08-27 12:25:54',NULL);
INSERT INTO `balance_libro` VALUES (3646,2978,41711,303849,3,3646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-05','2019-06-05',101.38,NULL,NULL,1,'2021-08-27 12:25:54','2021-08-27 12:25:54',NULL),(3647,2978,41711,303849,3,3647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-05','2019-06-05',2133.08,NULL,NULL,1,'2021-08-27 12:25:54','2021-08-27 12:25:54',NULL),(3648,2978,41711,303849,3,3648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-05','2019-06-05',2198.30,NULL,NULL,1,'2021-08-27 12:25:54','2021-08-27 12:25:54',NULL),(3649,2978,41711,303849,3,3649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-05','2019-06-05',837.01,NULL,NULL,1,'2021-08-27 12:25:54','2021-08-27 12:25:54',NULL),(3650,2978,41711,303849,3,3650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-05','2019-06-05',215.15,NULL,NULL,1,'2021-08-27 12:25:54','2021-08-27 12:25:54',NULL),(3651,2978,41711,303849,3,3651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-05','2019-06-05',116.45,NULL,NULL,1,'2021-08-27 12:25:54','2021-08-27 12:25:54',NULL),(3652,2978,41711,303849,3,3652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-05','2019-06-05',662.32,NULL,NULL,1,'2021-08-27 12:25:54','2021-08-27 12:25:54',NULL),(3653,2978,41711,303849,3,3653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-05','2019-06-05',251.82,NULL,NULL,1,'2021-08-27 12:25:54','2021-08-27 12:25:54',NULL),(3654,2978,41711,303849,3,3654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-05','2019-06-05',105.06,NULL,NULL,1,'2021-08-27 12:25:54','2021-08-27 12:25:54',NULL),(3655,2978,41711,303849,3,3655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-06','2019-06-06',2500.61,NULL,NULL,1,'2021-08-27 12:25:54','2021-08-27 12:25:54',NULL),(3656,2978,41711,303849,3,3656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-06','2019-06-06',92.75,NULL,NULL,1,'2021-08-27 12:25:54','2021-08-27 12:25:54',NULL),(3657,2978,41711,303849,3,3657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-06','2019-06-06',2000.93,NULL,NULL,1,'2021-08-27 12:25:54','2021-08-27 12:25:54',NULL),(3658,2978,41711,303849,3,3658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-06','2019-06-06',500.81,NULL,NULL,1,'2021-08-27 12:25:54','2021-08-27 12:25:54',NULL),(3659,2978,41711,303849,3,3659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-06','2019-06-06',366.90,NULL,NULL,1,'2021-08-27 12:25:55','2021-08-27 12:25:55',NULL),(3660,2978,41711,303849,3,3660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-07','2019-06-07',1476.67,NULL,NULL,1,'2021-08-27 12:25:55','2021-08-27 12:25:55',NULL),(3661,2978,41711,303849,3,3661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-07','2019-06-07',276.87,NULL,NULL,1,'2021-08-27 12:25:55','2021-08-27 12:25:55',NULL),(3662,2978,41711,303849,3,3662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-07','2019-06-07',511.85,NULL,NULL,1,'2021-08-27 12:25:55','2021-08-27 12:25:55',NULL),(3663,2978,41711,303849,3,3663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-07','2019-06-07',475.39,NULL,NULL,1,'2021-08-27 12:25:55','2021-08-27 12:25:55',NULL),(3664,2978,41711,303849,3,3664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-07','2019-06-07',330.30,NULL,NULL,1,'2021-08-27 12:25:55','2021-08-27 12:25:55',NULL),(3665,2978,41711,303849,3,3665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-07','2019-06-07',0.01,NULL,NULL,1,'2021-08-27 12:25:55','2021-08-27 12:25:55',NULL),(3666,2978,41711,303849,3,3666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-07','2019-06-07',250.00,NULL,NULL,1,'2021-08-27 12:25:55','2021-08-27 12:25:55',NULL),(3667,2978,41711,303849,3,3667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-07','2019-06-07',476.63,NULL,NULL,1,'2021-08-27 12:25:55','2021-08-27 12:25:55',NULL),(3668,2978,41711,303849,3,3668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-07','2019-06-07',819.11,NULL,NULL,1,'2021-08-27 12:25:55','2021-08-27 12:25:55',NULL),(3669,2978,41711,303849,3,3669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-07','2019-06-07',3439.82,NULL,NULL,1,'2021-08-27 12:25:55','2021-08-27 12:25:55',NULL);
INSERT INTO `balance_libro` VALUES (3670,2978,41711,303849,3,3670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-08','2019-06-08',1025.99,NULL,NULL,1,'2021-08-27 12:25:55','2021-08-27 12:25:55',NULL),(3671,2978,41711,303849,3,3671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-10','2019-06-10',653.72,NULL,NULL,1,'2021-08-27 12:25:55','2021-08-27 12:25:55',NULL),(3672,2978,41711,303849,3,3672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-10','2019-06-10',635.48,NULL,NULL,1,'2021-08-27 12:25:55','2021-08-27 12:25:55',NULL),(3673,2978,41711,303849,3,3673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-10','2019-06-10',246.54,NULL,NULL,1,'2021-08-27 12:25:55','2021-08-27 12:25:55',NULL),(3674,2978,41711,303849,3,3674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-10','2019-06-10',3075.20,NULL,NULL,1,'2021-08-27 12:25:55','2021-08-27 12:25:55',NULL),(3675,2978,41711,303849,3,3675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-10','2019-06-10',705.59,NULL,NULL,1,'2021-08-27 12:25:55','2021-08-27 12:25:55',NULL),(3676,2978,41711,303849,3,3676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-11','2019-06-11',285.68,NULL,NULL,1,'2021-08-27 12:25:55','2021-08-27 12:25:55',NULL),(3677,2978,41711,303849,3,3677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-11','2019-06-11',718.51,NULL,NULL,1,'2021-08-27 12:25:55','2021-08-27 12:25:55',NULL),(3678,2978,41711,303849,3,3678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-11','2019-06-11',1003.14,NULL,NULL,1,'2021-08-27 12:25:55','2021-08-27 12:25:55',NULL),(3679,2978,41711,303849,3,3679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-11','2019-06-11',143.41,NULL,NULL,1,'2021-08-27 12:25:55','2021-08-27 12:25:55',NULL),(3680,2978,41711,303849,3,3680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-11','2019-06-11',493.06,NULL,NULL,1,'2021-08-27 12:25:55','2021-08-27 12:25:55',NULL),(3681,2978,41711,303849,3,3681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-12','2019-06-12',1164.26,NULL,NULL,1,'2021-08-27 12:25:55','2021-08-27 12:25:55',NULL),(3682,2978,41711,303849,3,3682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-12','2019-06-12',1391.08,NULL,NULL,1,'2021-08-27 12:25:55','2021-08-27 12:25:55',NULL),(3683,2978,41711,303849,3,3683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-12','2019-06-12',153.27,NULL,NULL,1,'2021-08-27 12:25:55','2021-08-27 12:25:55',NULL),(3684,2978,41711,303849,3,3684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-12','2019-06-12',1120.69,NULL,NULL,1,'2021-08-27 12:25:55','2021-08-27 12:25:55',NULL),(3685,2978,41711,303849,3,3685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-13','2019-06-13',395.57,NULL,NULL,1,'2021-08-27 12:25:56','2021-08-27 12:25:56',NULL),(3686,2978,41711,303849,3,3686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-13','2019-06-13',306.92,NULL,NULL,1,'2021-08-27 12:25:56','2021-08-27 12:25:56',NULL),(3687,2978,41711,303849,3,3687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-13','2019-06-13',297.56,NULL,NULL,1,'2021-08-27 12:25:56','2021-08-27 12:25:56',NULL),(3688,2978,41711,303849,3,3688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-13','2019-06-13',325.32,NULL,NULL,1,'2021-08-27 12:25:56','2021-08-27 12:25:56',NULL),(3689,2978,41711,303849,3,3689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-14','2019-06-14',1096.54,NULL,NULL,1,'2021-08-27 12:25:56','2021-08-27 12:25:56',NULL),(3690,2978,41711,303849,3,3690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-14','2019-06-14',2474.37,NULL,NULL,1,'2021-08-27 12:25:56','2021-08-27 12:25:56',NULL),(3691,2978,41711,303849,3,3691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-14','2019-06-14',237.12,NULL,NULL,1,'2021-08-27 12:25:56','2021-08-27 12:25:56',NULL),(3692,2978,41711,303849,3,3692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-14','2019-06-14',1694.14,NULL,NULL,1,'2021-08-27 12:25:56','2021-08-27 12:25:56',NULL),(3693,2978,41711,303849,3,3693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-17','2019-06-17',1636.71,NULL,NULL,1,'2021-08-27 12:25:56','2021-08-27 12:25:56',NULL);
INSERT INTO `balance_libro` VALUES (3694,2978,41711,303849,3,3694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-17','2019-06-17',45.11,NULL,NULL,1,'2021-08-27 12:25:56','2021-08-27 12:25:56',NULL),(3695,2978,41711,303849,3,3695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-18','2019-06-18',1915.53,NULL,NULL,1,'2021-08-27 12:25:56','2021-08-27 12:25:56',NULL),(3696,2978,41711,303849,3,3696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-18','2019-06-18',76.15,NULL,NULL,1,'2021-08-27 12:25:56','2021-08-27 12:25:56',NULL),(3697,2978,41711,303849,3,3697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-18','2019-06-18',2181.09,NULL,NULL,1,'2021-08-27 12:25:56','2021-08-27 12:25:56',NULL),(3698,2978,41711,303849,3,3698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-19','2019-06-19',1789.73,NULL,NULL,1,'2021-08-27 12:25:56','2021-08-27 12:25:56',NULL),(3699,2978,41711,303849,3,3699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-19','2019-06-19',488.62,NULL,NULL,1,'2021-08-27 12:25:56','2021-08-27 12:25:56',NULL),(3700,2978,41711,303849,3,3700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-19','2019-06-19',1106.78,NULL,NULL,1,'2021-08-27 12:25:56','2021-08-27 12:25:56',NULL),(3701,2978,41711,303849,3,3701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-19','2019-06-19',76.15,NULL,NULL,1,'2021-08-27 12:25:56','2021-08-27 12:25:56',NULL),(3702,2978,41711,303849,3,3702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-19','2019-06-19',4260.51,NULL,NULL,1,'2021-08-27 12:25:56','2021-08-27 12:25:56',NULL),(3703,2978,41711,303849,3,3703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-19','2019-06-19',103.91,NULL,NULL,1,'2021-08-27 12:25:56','2021-08-27 12:25:56',NULL),(3704,2978,41711,303849,3,3704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-21','2019-06-21',2304.85,NULL,NULL,1,'2021-08-27 12:25:56','2021-08-27 12:25:56',NULL),(3705,2978,41711,303849,3,3705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-21','2019-06-21',984.01,NULL,NULL,1,'2021-08-27 12:25:56','2021-08-27 12:25:56',NULL),(3706,2978,41711,303849,3,3706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-21','2019-06-21',345.80,NULL,NULL,1,'2021-08-27 12:25:56','2021-08-27 12:25:56',NULL),(3707,2978,41711,303849,3,3707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-21','2019-06-21',1032.38,NULL,NULL,1,'2021-08-27 12:25:56','2021-08-27 12:25:56',NULL),(3708,2978,41711,303849,3,3708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-21','2019-06-21',674.28,NULL,NULL,1,'2021-08-27 12:25:56','2021-08-27 12:25:56',NULL),(3709,2978,41711,303849,3,3709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-21','2019-06-21',1614.53,NULL,NULL,1,'2021-08-27 12:25:56','2021-08-27 12:25:56',NULL),(3710,2978,41711,303849,3,3710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-21','2019-06-21',201.86,NULL,NULL,1,'2021-08-27 12:25:57','2021-08-27 12:25:57',NULL),(3711,2978,41711,303849,3,3711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-21','2019-06-21',558.52,NULL,NULL,1,'2021-08-27 12:25:57','2021-08-27 12:25:57',NULL),(3712,2978,41711,303849,3,3712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-21','2019-06-21',94.55,NULL,NULL,1,'2021-08-27 12:25:57','2021-08-27 12:25:57',NULL),(3713,2978,41711,303849,3,3713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-24','2019-06-24',204.24,NULL,NULL,1,'2021-08-27 12:25:57','2021-08-27 12:25:57',NULL),(3714,2978,41711,303849,3,3714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-24','2019-06-24',413.05,NULL,NULL,1,'2021-08-27 12:25:57','2021-08-27 12:25:57',NULL),(3715,2978,41711,303849,3,3715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-25','2019-06-25',1226.03,NULL,NULL,1,'2021-08-27 12:25:57','2021-08-27 12:25:57',NULL),(3716,2978,41711,303849,3,3716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-25','2019-06-25',183.15,NULL,NULL,1,'2021-08-27 12:25:57','2021-08-27 12:25:57',NULL),(3717,2978,41711,303849,3,3717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-26','2019-06-26',312.19,NULL,NULL,1,'2021-08-27 12:25:57','2021-08-27 12:25:57',NULL);
INSERT INTO `balance_libro` VALUES (3718,2978,41711,303849,3,3718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-26','2019-06-26',1327.24,NULL,NULL,1,'2021-08-27 12:25:57','2021-08-27 12:25:57',NULL),(3719,2978,41711,303849,3,3719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-26','2019-06-26',167.28,NULL,NULL,1,'2021-08-27 12:25:57','2021-08-27 12:25:57',NULL),(3720,2978,41711,303849,3,3720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-26','2019-06-26',75.64,NULL,NULL,1,'2021-08-27 12:25:57','2021-08-27 12:25:57',NULL),(3721,2978,41711,303849,3,3721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-26','2019-06-26',203.79,NULL,NULL,1,'2021-08-27 12:25:57','2021-08-27 12:25:57',NULL),(3722,2978,41711,303849,3,3722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-26','2019-06-26',604.30,NULL,NULL,1,'2021-08-27 12:25:57','2021-08-27 12:25:57',NULL),(3723,2978,41711,303849,3,3723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-26','2019-06-26',222.39,NULL,NULL,1,'2021-08-27 12:25:57','2021-08-27 12:25:57',NULL),(3724,2978,41711,303849,3,3724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-27','2019-06-27',379.62,NULL,NULL,1,'2021-08-27 12:25:57','2021-08-27 12:25:57',NULL),(3725,2978,41711,303849,3,3725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-27','2019-06-27',5053.00,NULL,NULL,1,'2021-08-27 12:25:57','2021-08-27 12:25:57',NULL),(3726,2978,41711,303849,3,3726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-27','2019-06-27',1658.49,NULL,NULL,1,'2021-08-27 12:25:57','2021-08-27 12:25:57',NULL),(3727,2978,41711,303849,3,3727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-27','2019-06-27',90.27,NULL,NULL,1,'2021-08-27 12:25:57','2021-08-27 12:25:57',NULL),(3728,2978,41711,303849,3,3728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-28','2019-06-28',641.09,NULL,NULL,1,'2021-08-27 12:25:57','2021-08-27 12:25:57',NULL),(3729,2978,41711,303849,3,3729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-28','2019-06-28',2805.16,NULL,NULL,1,'2021-08-27 12:25:57','2021-08-27 12:25:57',NULL),(3730,2978,41711,303849,3,3730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-28','2019-06-28',53.19,NULL,NULL,1,'2021-08-27 12:25:57','2021-08-27 12:25:57',NULL),(3731,2978,41711,303849,3,3731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-29','2019-06-29',717.98,NULL,NULL,1,'2021-08-27 12:25:57','2021-08-27 12:25:57',NULL),(3732,2978,41711,303849,3,3732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-06-30','2019-06-30',1123.85,NULL,NULL,1,'2021-08-27 12:25:57','2021-08-27 12:25:57',NULL),(3733,2978,41711,303850,3,3733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-01','2019-07-01',1015.34,NULL,NULL,1,'2021-08-27 12:26:50','2021-08-27 12:26:50',NULL),(3734,2978,41711,303850,3,3734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-01','2019-07-01',529.29,NULL,NULL,1,'2021-08-27 12:26:50','2021-08-27 12:26:50',NULL),(3735,2978,41711,303850,3,3735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-01','2019-07-01',1473.78,NULL,NULL,1,'2021-08-27 12:26:50','2021-08-27 12:26:50',NULL),(3736,2978,41711,303850,3,3736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-02','2019-07-02',987.43,NULL,NULL,1,'2021-08-27 12:26:51','2021-08-27 12:26:51',NULL),(3737,2978,41711,303850,3,3737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-02','2019-07-02',3220.77,NULL,NULL,1,'2021-08-27 12:26:51','2021-08-27 12:26:51',NULL),(3738,2978,41711,303850,3,3738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-02','2019-07-02',312.71,NULL,NULL,1,'2021-08-27 12:26:51','2021-08-27 12:26:51',NULL),(3739,2978,41711,303850,3,3739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-02','2019-07-02',468.37,NULL,NULL,1,'2021-08-27 12:26:51','2021-08-27 12:26:51',NULL),(3740,2978,41711,303850,3,3740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-02','2019-07-02',1200.80,NULL,NULL,1,'2021-08-27 12:26:51','2021-08-27 12:26:51',NULL),(3741,2978,41711,303850,3,3741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-02','2019-07-02',1881.98,NULL,NULL,1,'2021-08-27 12:26:51','2021-08-27 12:26:51',NULL);
INSERT INTO `balance_libro` VALUES (3742,2978,41711,303850,3,3742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-03','2019-07-03',2843.21,NULL,NULL,1,'2021-08-27 12:26:51','2021-08-27 12:26:51',NULL),(3743,2978,41711,303850,3,3743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-03','2019-07-03',613.43,NULL,NULL,1,'2021-08-27 12:26:51','2021-08-27 12:26:51',NULL),(3744,2978,41711,303850,3,3744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-03','2019-07-03',1200.34,NULL,NULL,1,'2021-08-27 12:26:51','2021-08-27 12:26:51',NULL),(3745,2978,41711,303850,3,3745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-03','2019-07-03',2139.37,NULL,NULL,1,'2021-08-27 12:26:51','2021-08-27 12:26:51',NULL),(3746,2978,41711,303850,3,3746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-03','2019-07-03',207.78,NULL,NULL,1,'2021-08-27 12:26:51','2021-08-27 12:26:51',NULL),(3747,2978,41711,303850,3,3747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-04','2019-07-04',576.80,NULL,NULL,1,'2021-08-27 12:26:51','2021-08-27 12:26:51',NULL),(3748,2978,41711,303850,3,3748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-04','2019-07-04',2827.09,NULL,NULL,1,'2021-08-27 12:26:51','2021-08-27 12:26:51',NULL),(3749,2978,41711,303850,3,3749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-04','2019-07-04',634.68,NULL,NULL,1,'2021-08-27 12:26:51','2021-08-27 12:26:51',NULL),(3750,2978,41711,303850,3,3750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-04','2019-07-04',5006.23,NULL,NULL,1,'2021-08-27 12:26:51','2021-08-27 12:26:51',NULL),(3751,2978,41711,303850,3,3751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-04','2019-07-04',2667.41,NULL,NULL,1,'2021-08-27 12:26:51','2021-08-27 12:26:51',NULL),(3752,2978,41711,303850,3,3752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-04','2019-07-04',250.00,NULL,NULL,1,'2021-08-27 12:26:51','2021-08-27 12:26:51',NULL),(3753,2978,41711,303850,3,3753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-04','2019-07-04',2198.30,NULL,NULL,1,'2021-08-27 12:26:51','2021-08-27 12:26:51',NULL),(3754,2978,41711,303850,3,3754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-05','2019-07-05',867.39,NULL,NULL,1,'2021-08-27 12:26:51','2021-08-27 12:26:51',NULL),(3755,2978,41711,303850,3,3755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-05','2019-07-05',375.98,NULL,NULL,1,'2021-08-27 12:26:51','2021-08-27 12:26:51',NULL),(3756,2978,41711,303850,3,3756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-05','2019-07-05',148.43,NULL,NULL,1,'2021-08-27 12:26:51','2021-08-27 12:26:51',NULL),(3757,2978,41711,303850,3,3757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-05','2019-07-05',1446.34,NULL,NULL,1,'2021-08-27 12:26:52','2021-08-27 12:26:52',NULL),(3758,2978,41711,303850,3,3758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-05','2019-07-05',4775.38,NULL,NULL,1,'2021-08-27 12:26:52','2021-08-27 12:26:52',NULL),(3759,2978,41711,303850,3,3759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-05','2019-07-05',177.23,NULL,NULL,1,'2021-08-27 12:26:52','2021-08-27 12:26:52',NULL),(3760,2978,41711,303850,3,3760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-06','2019-07-06',1310.79,NULL,NULL,1,'2021-08-27 12:26:52','2021-08-27 12:26:52',NULL),(3761,2978,41711,303850,3,3761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-08','2019-07-08',400.20,NULL,NULL,1,'2021-08-27 12:26:52','2021-08-27 12:26:52',NULL),(3762,2978,41711,303850,3,3762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-10','2019-07-10',3942.69,NULL,NULL,1,'2021-08-27 12:26:52','2021-08-27 12:26:52',NULL),(3763,2978,41711,303850,3,3763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-10','2019-07-10',1100.80,NULL,NULL,1,'2021-08-27 12:26:52','2021-08-27 12:26:52',NULL),(3764,2978,41711,303850,3,3764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-10','2019-07-10',3966.95,NULL,NULL,1,'2021-08-27 12:26:52','2021-08-27 12:26:52',NULL),(3765,2978,41711,303850,3,3765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-10','2019-07-10',167.86,NULL,NULL,1,'2021-08-27 12:26:52','2021-08-27 12:26:52',NULL);
INSERT INTO `balance_libro` VALUES (3766,2978,41711,303850,3,3766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-10','2019-07-10',835.87,NULL,NULL,1,'2021-08-27 12:26:52','2021-08-27 12:26:52',NULL),(3767,2978,41711,303850,3,3767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-10','2019-07-10',961.80,NULL,NULL,1,'2021-08-27 12:26:52','2021-08-27 12:26:52',NULL),(3768,2978,41711,303850,3,3768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-10','2019-07-10',547.75,NULL,NULL,1,'2021-08-27 12:26:52','2021-08-27 12:26:52',NULL),(3769,2978,41711,303850,3,3769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-10','2019-07-10',352.02,NULL,NULL,1,'2021-08-27 12:26:52','2021-08-27 12:26:52',NULL),(3770,2978,41711,303850,3,3770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-10','2019-07-10',540.93,NULL,NULL,1,'2021-08-27 12:26:52','2021-08-27 12:26:52',NULL),(3771,2978,41711,303850,3,3771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-11','2019-07-11',1184.29,NULL,NULL,1,'2021-08-27 12:26:52','2021-08-27 12:26:52',NULL),(3772,2978,41711,303850,3,3772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-11','2019-07-11',5455.43,NULL,NULL,1,'2021-08-27 12:26:53','2021-08-27 12:26:53',NULL),(3773,2978,41711,303850,3,3773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-11','2019-07-11',936.53,NULL,NULL,1,'2021-08-27 12:26:53','2021-08-27 12:26:53',NULL),(3774,2978,41711,303850,3,3774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-11','2019-07-11',772.24,NULL,NULL,1,'2021-08-27 12:26:53','2021-08-27 12:26:53',NULL),(3775,2978,41711,303850,3,3775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-11','2019-07-11',668.98,NULL,NULL,1,'2021-08-27 12:26:53','2021-08-27 12:26:53',NULL),(3776,2978,41711,303850,3,3776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-11','2019-07-11',2145.28,NULL,NULL,1,'2021-08-27 12:26:53','2021-08-27 12:26:53',NULL),(3777,2978,41711,303850,3,3777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-11','2019-07-11',874.24,NULL,NULL,1,'2021-08-27 12:26:53','2021-08-27 12:26:53',NULL),(3778,2978,41711,303850,3,3778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-12','2019-07-12',1408.02,NULL,NULL,1,'2021-08-27 12:26:53','2021-08-27 12:26:53',NULL),(3779,2978,41711,303850,3,3779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-12','2019-07-12',111.10,NULL,NULL,1,'2021-08-27 12:26:53','2021-08-27 12:26:53',NULL),(3780,2978,41711,303850,3,3780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-12','2019-07-12',545.77,NULL,NULL,1,'2021-08-27 12:26:53','2021-08-27 12:26:53',NULL),(3781,2978,41711,303850,3,3781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-12','2019-07-12',691.84,NULL,NULL,1,'2021-08-27 12:26:53','2021-08-27 12:26:53',NULL),(3782,2978,41711,303850,3,3782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-12','2019-07-12',189.12,NULL,NULL,1,'2021-08-27 12:26:53','2021-08-27 12:26:53',NULL),(3783,2978,41711,303850,3,3783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-12','2019-07-12',677.47,NULL,NULL,1,'2021-08-27 12:26:53','2021-08-27 12:26:53',NULL),(3784,2978,41711,303850,3,3784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-12','2019-07-12',698.56,NULL,NULL,1,'2021-08-27 12:26:53','2021-08-27 12:26:53',NULL),(3785,2978,41711,303850,3,3785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-13','2019-07-13',741.35,NULL,NULL,1,'2021-08-27 12:26:53','2021-08-27 12:26:53',NULL),(3786,2978,41711,303850,3,3786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-15','2019-07-15',896.48,NULL,NULL,1,'2021-08-27 12:26:53','2021-08-27 12:26:53',NULL),(3787,2978,41711,303850,3,3787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-15','2019-07-15',1620.61,NULL,NULL,1,'2021-08-27 12:26:53','2021-08-27 12:26:53',NULL),(3788,2978,41711,303850,3,3788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-15','2019-07-15',2650.82,NULL,NULL,1,'2021-08-27 12:26:53','2021-08-27 12:26:53',NULL),(3789,2978,41711,303850,3,3789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-15','2019-07-15',174.98,NULL,NULL,1,'2021-08-27 12:26:53','2021-08-27 12:26:53',NULL);
INSERT INTO `balance_libro` VALUES (3790,2978,41711,303850,3,3790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-15','2019-07-15',968.74,NULL,NULL,1,'2021-08-27 12:26:53','2021-08-27 12:26:53',NULL),(3791,2978,41711,303850,3,3791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-16','2019-07-16',3400.83,NULL,NULL,1,'2021-08-27 12:26:53','2021-08-27 12:26:53',NULL),(3792,2978,41711,303850,3,3792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-16','2019-07-16',384.72,NULL,NULL,1,'2021-08-27 12:26:53','2021-08-27 12:26:53',NULL),(3793,2978,41711,303850,3,3793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-16','2019-07-16',492.49,NULL,NULL,1,'2021-08-27 12:26:53','2021-08-27 12:26:53',NULL),(3794,2978,41711,303850,3,3794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-16','2019-07-16',179.84,NULL,NULL,1,'2021-08-27 12:26:54','2021-08-27 12:26:54',NULL),(3795,2978,41711,303850,3,3795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-16','2019-07-16',692.86,NULL,NULL,1,'2021-08-27 12:26:54','2021-08-27 12:26:54',NULL),(3796,2978,41711,303850,3,3796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-16','2019-07-16',1304.64,NULL,NULL,1,'2021-08-27 12:26:54','2021-08-27 12:26:54',NULL),(3797,2978,41711,303850,3,3797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-17','2019-07-17',6713.88,NULL,NULL,1,'2021-08-27 12:26:54','2021-08-27 12:26:54',NULL),(3798,2978,41711,303850,3,3798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-17','2019-07-17',733.65,NULL,NULL,1,'2021-08-27 12:26:54','2021-08-27 12:26:54',NULL),(3799,2978,41711,303850,3,3799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-17','2019-07-17',2282.82,NULL,NULL,1,'2021-08-27 12:26:54','2021-08-27 12:26:54',NULL),(3800,2978,41711,303850,3,3800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-17','2019-07-17',118.56,NULL,NULL,1,'2021-08-27 12:26:54','2021-08-27 12:26:54',NULL),(3801,2978,41711,303850,3,3801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-17','2019-07-17',798.50,NULL,NULL,1,'2021-08-27 12:26:54','2021-08-27 12:26:54',NULL),(3802,2978,41711,303850,3,3802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-18','2019-07-18',393.15,NULL,NULL,1,'2021-08-27 12:26:54','2021-08-27 12:26:54',NULL),(3803,2978,41711,303850,3,3803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-18','2019-07-18',2923.44,NULL,NULL,1,'2021-08-27 12:26:54','2021-08-27 12:26:54',NULL),(3804,2978,41711,303850,3,3804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-18','2019-07-18',4215.19,NULL,NULL,1,'2021-08-27 12:26:54','2021-08-27 12:26:54',NULL),(3805,2978,41711,303850,3,3805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-18','2019-07-18',1046.37,NULL,NULL,1,'2021-08-27 12:26:54','2021-08-27 12:26:54',NULL),(3806,2978,41711,303850,3,3806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-18','2019-07-18',896.30,NULL,NULL,1,'2021-08-27 12:26:54','2021-08-27 12:26:54',NULL),(3807,2978,41711,303850,3,3807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-19','2019-07-19',1281.82,NULL,NULL,1,'2021-08-27 12:26:54','2021-08-27 12:26:54',NULL),(3808,2978,41711,303850,3,3808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-19','2019-07-19',1245.55,NULL,NULL,1,'2021-08-27 12:26:54','2021-08-27 12:26:54',NULL),(3809,2978,41711,303850,3,3809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-19','2019-07-19',88.68,NULL,NULL,1,'2021-08-27 12:26:54','2021-08-27 12:26:54',NULL),(3810,2978,41711,303850,3,3810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-19','2019-07-19',2695.27,NULL,NULL,1,'2021-08-27 12:26:54','2021-08-27 12:26:54',NULL),(3811,2978,41711,303850,3,3811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-19','2019-07-19',295.05,NULL,NULL,1,'2021-08-27 12:26:54','2021-08-27 12:26:54',NULL),(3812,2978,41711,303850,3,3812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-19','2019-07-19',1035.73,NULL,NULL,1,'2021-08-27 12:26:54','2021-08-27 12:26:54',NULL),(3813,2978,41711,303850,3,3813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-19','2019-07-19',179.39,NULL,NULL,1,'2021-08-27 12:26:54','2021-08-27 12:26:54',NULL);
INSERT INTO `balance_libro` VALUES (3814,2978,41711,303850,3,3814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-19','2019-07-19',145.62,NULL,NULL,1,'2021-08-27 12:26:54','2021-08-27 12:26:54',NULL),(3815,2978,41711,303850,3,3815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-19','2019-07-19',1775.12,NULL,NULL,1,'2021-08-27 12:26:54','2021-08-27 12:26:54',NULL),(3816,2978,41711,303850,3,3816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-19','2019-07-19',2774.15,NULL,NULL,1,'2021-08-27 12:26:54','2021-08-27 12:26:54',NULL),(3817,2978,41711,303850,3,3817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-20','2019-07-20',345.80,NULL,NULL,1,'2021-08-27 12:26:54','2021-08-27 12:26:54',NULL),(3818,2978,41711,303850,3,3818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-20','2019-07-20',1533.70,NULL,NULL,1,'2021-08-27 12:26:55','2021-08-27 12:26:55',NULL),(3819,2978,41711,303850,3,3819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-21','2019-07-21',1477.22,NULL,NULL,1,'2021-08-27 12:26:55','2021-08-27 12:26:55',NULL),(3820,2978,41711,303850,3,3820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-21','2019-07-21',779.31,NULL,NULL,1,'2021-08-27 12:26:55','2021-08-27 12:26:55',NULL),(3821,2978,41711,303850,3,3821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-22','2019-07-22',913.39,NULL,NULL,1,'2021-08-27 12:26:55','2021-08-27 12:26:55',NULL),(3822,2978,41711,303850,3,3822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-22','2019-07-22',160.07,NULL,NULL,1,'2021-08-27 12:26:55','2021-08-27 12:26:55',NULL),(3823,2978,41711,303850,3,3823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-22','2019-07-22',2004.41,NULL,NULL,1,'2021-08-27 12:26:55','2021-08-27 12:26:55',NULL),(3824,2978,41711,303850,3,3824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-22','2019-07-22',371.47,NULL,NULL,1,'2021-08-27 12:26:55','2021-08-27 12:26:55',NULL),(3825,2978,41711,303850,3,3825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-22','2019-07-22',294.82,NULL,NULL,1,'2021-08-27 12:26:55','2021-08-27 12:26:55',NULL),(3826,2978,41711,303850,3,3826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-22','2019-07-22',208.63,NULL,NULL,1,'2021-08-27 12:26:55','2021-08-27 12:26:55',NULL),(3827,2978,41711,303850,3,3827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-23','2019-07-23',880.94,NULL,NULL,1,'2021-08-27 12:26:55','2021-08-27 12:26:55',NULL),(3828,2978,41711,303850,3,3828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-23','2019-07-23',209.50,NULL,NULL,1,'2021-08-27 12:26:55','2021-08-27 12:26:55',NULL),(3829,2978,41711,303850,3,3829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-24','2019-07-24',224.94,NULL,NULL,1,'2021-08-27 12:26:55','2021-08-27 12:26:55',NULL),(3830,2978,41711,303850,3,3830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-24','2019-07-24',1712.11,NULL,NULL,1,'2021-08-27 12:26:55','2021-08-27 12:26:55',NULL),(3831,2978,41711,303850,3,3831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-24','2019-07-24',1175.95,NULL,NULL,1,'2021-08-27 12:26:55','2021-08-27 12:26:55',NULL),(3832,2978,41711,303850,3,3832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-24','2019-07-24',162.54,NULL,NULL,1,'2021-08-27 12:26:55','2021-08-27 12:26:55',NULL),(3833,2978,41711,303850,3,3833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-24','2019-07-24',449.99,NULL,NULL,1,'2021-08-27 12:26:55','2021-08-27 12:26:55',NULL),(3834,2978,41711,303850,3,3834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-24','2019-07-24',379.60,NULL,NULL,1,'2021-08-27 12:26:55','2021-08-27 12:26:55',NULL),(3835,2978,41711,303850,3,3835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-24','2019-07-24',292.81,NULL,NULL,1,'2021-08-27 12:26:55','2021-08-27 12:26:55',NULL),(3836,2978,41711,303850,3,3836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-24','2019-07-24',322.31,NULL,NULL,1,'2021-08-27 12:26:55','2021-08-27 12:26:55',NULL),(3837,2978,41711,303850,3,3837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-24','2019-07-24',570.37,NULL,NULL,1,'2021-08-27 12:26:55','2021-08-27 12:26:55',NULL);
INSERT INTO `balance_libro` VALUES (3838,2978,41711,303850,3,3838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-25','2019-07-25',3353.55,NULL,NULL,1,'2021-08-27 12:26:55','2021-08-27 12:26:55',NULL),(3839,2978,41711,303850,3,3839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-25','2019-07-25',22.25,NULL,NULL,1,'2021-08-27 12:26:55','2021-08-27 12:26:55',NULL),(3840,2978,41711,303850,3,3840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-25','2019-07-25',1491.23,NULL,NULL,1,'2021-08-27 12:26:55','2021-08-27 12:26:55',NULL),(3841,2978,41711,303850,3,3841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-26','2019-07-26',209.48,NULL,NULL,1,'2021-08-27 12:26:55','2021-08-27 12:26:55',NULL),(3842,2978,41711,303850,3,3842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-26','2019-07-26',5560.23,NULL,NULL,1,'2021-08-27 12:26:55','2021-08-27 12:26:55',NULL),(3843,2978,41711,303850,3,3843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-26','2019-07-26',709.30,NULL,NULL,1,'2021-08-27 12:26:55','2021-08-27 12:26:55',NULL),(3844,2978,41711,303850,3,3844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-26','2019-07-26',867.15,NULL,NULL,1,'2021-08-27 12:26:55','2021-08-27 12:26:55',NULL),(3845,2978,41711,303850,3,3845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-26','2019-07-26',990.15,NULL,NULL,1,'2021-08-27 12:26:55','2021-08-27 12:26:55',NULL),(3846,2978,41711,303850,3,3846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-26','2019-07-26',990.15,NULL,NULL,1,'2021-08-27 12:26:56','2021-08-27 12:26:56',NULL),(3847,2978,41711,303850,3,3847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-26','2019-07-26',709.30,NULL,NULL,1,'2021-08-27 12:26:56','2021-08-27 12:26:56',NULL),(3848,2978,41711,303850,3,3848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-26','2019-07-26',867.15,NULL,NULL,1,'2021-08-27 12:26:56','2021-08-27 12:26:56',NULL),(3849,2978,41711,303850,3,3849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-29','2019-07-29',4102.77,NULL,NULL,1,'2021-08-27 12:26:56','2021-08-27 12:26:56',NULL),(3850,2978,41711,303850,3,3850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-29','2019-07-29',591.30,NULL,NULL,1,'2021-08-27 12:26:56','2021-08-27 12:26:56',NULL),(3851,2978,41711,303850,3,3851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-29','2019-07-29',1211.16,NULL,NULL,1,'2021-08-27 12:26:56','2021-08-27 12:26:56',NULL),(3852,2978,41711,303850,3,3852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-30','2019-07-30',1518.86,NULL,NULL,1,'2021-08-27 12:26:56','2021-08-27 12:26:56',NULL),(3853,2978,41711,303850,3,3853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-30','2019-07-30',192.12,NULL,NULL,1,'2021-08-27 12:26:56','2021-08-27 12:26:56',NULL),(3854,2978,41711,303850,3,3854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-31','2019-07-31',864.55,NULL,NULL,1,'2021-08-27 12:26:56','2021-08-27 12:26:56',NULL),(3855,2978,41711,303850,3,3855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-31','2019-07-31',1222.12,NULL,NULL,1,'2021-08-27 12:26:56','2021-08-27 12:26:56',NULL),(3856,2978,41711,303850,3,3856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-31','2019-07-31',1214.86,NULL,NULL,1,'2021-08-27 12:26:56','2021-08-27 12:26:56',NULL),(3857,2978,41711,303850,3,3857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-31','2019-07-31',1773.26,NULL,NULL,1,'2021-08-27 12:26:56','2021-08-27 12:26:56',NULL),(3858,2978,41711,303850,3,3858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-31','2019-07-31',162.54,NULL,NULL,1,'2021-08-27 12:26:56','2021-08-27 12:26:56',NULL),(3859,2978,41711,303850,3,3859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-07-31','2019-07-31',1123.85,NULL,NULL,1,'2021-08-27 12:26:56','2021-08-27 12:26:56',NULL),(3860,2978,41711,303851,3,3860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-01','2019-08-01',467.58,NULL,NULL,1,'2021-08-27 12:28:14','2021-08-27 12:28:14',NULL),(3861,2978,41711,303851,3,3861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-01','2019-08-01',1946.19,NULL,NULL,1,'2021-08-27 12:28:14','2021-08-27 12:28:14',NULL);
INSERT INTO `balance_libro` VALUES (3862,2978,41711,303851,3,3862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-01','2019-08-01',1365.62,NULL,NULL,1,'2021-08-27 12:28:14','2021-08-27 12:28:14',NULL),(3863,2978,41711,303851,3,3863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-01','2019-08-01',100.22,NULL,NULL,1,'2021-08-27 12:28:14','2021-08-27 12:28:14',NULL),(3864,2978,41711,303851,3,3864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-01','2019-08-01',1005.35,NULL,NULL,1,'2021-08-27 12:28:14','2021-08-27 12:28:14',NULL),(3865,2978,41711,303851,3,3865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-01','2019-08-01',491.42,NULL,NULL,1,'2021-08-27 12:28:14','2021-08-27 12:28:14',NULL),(3866,2978,41711,303851,3,3866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-01','2019-08-01',1546.19,NULL,NULL,1,'2021-08-27 12:28:14','2021-08-27 12:28:14',NULL),(3867,2978,41711,303851,3,3867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-01','2019-08-01',717.68,NULL,NULL,1,'2021-08-27 12:28:14','2021-08-27 12:28:14',NULL),(3868,2978,41711,303851,3,3868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-02','2019-08-02',1867.86,NULL,NULL,1,'2021-08-27 12:28:15','2021-08-27 12:28:15',NULL),(3869,2978,41711,303851,3,3869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-02','2019-08-02',1671.87,NULL,NULL,1,'2021-08-27 12:28:15','2021-08-27 12:28:15',NULL),(3870,2978,41711,303851,3,3870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-02','2019-08-02',2971.76,NULL,NULL,1,'2021-08-27 12:28:15','2021-08-27 12:28:15',NULL),(3871,2978,41711,303851,3,3871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-03','2019-08-03',268.80,NULL,NULL,1,'2021-08-27 12:28:15','2021-08-27 12:28:15',NULL),(3872,2978,41711,303851,3,3872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-03','2019-08-03',312.38,NULL,NULL,1,'2021-08-27 12:28:15','2021-08-27 12:28:15',NULL),(3873,2978,41711,303851,3,3873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-05','2019-08-05',931.88,NULL,NULL,1,'2021-08-27 12:28:15','2021-08-27 12:28:15',NULL),(3874,2978,41711,303851,3,3874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-05','2019-08-05',352.35,NULL,NULL,1,'2021-08-27 12:28:15','2021-08-27 12:28:15',NULL),(3875,2978,41711,303851,3,3875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-05','2019-08-05',771.87,NULL,NULL,1,'2021-08-27 12:28:15','2021-08-27 12:28:15',NULL),(3876,2978,41711,303851,3,3876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-05','2019-08-05',250.00,NULL,NULL,1,'2021-08-27 12:28:15','2021-08-27 12:28:15',NULL),(3877,2978,41711,303851,3,3877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-05','2019-08-05',720.62,NULL,NULL,1,'2021-08-27 12:28:15','2021-08-27 12:28:15',NULL),(3878,2978,41711,303851,3,3878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-05','2019-08-05',2198.30,NULL,NULL,1,'2021-08-27 12:28:15','2021-08-27 12:28:15',NULL),(3879,2978,41711,303851,3,3879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-06','2019-08-06',1417.46,NULL,NULL,1,'2021-08-27 12:28:15','2021-08-27 12:28:15',NULL),(3880,2978,41711,303851,3,3880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-06','2019-08-06',228.01,NULL,NULL,1,'2021-08-27 12:28:15','2021-08-27 12:28:15',NULL),(3881,2978,41711,303851,3,3881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-06','2019-08-06',1017.05,NULL,NULL,1,'2021-08-27 12:28:15','2021-08-27 12:28:15',NULL),(3882,2978,41711,303851,3,3882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-06','2019-08-06',743.57,NULL,NULL,1,'2021-08-27 12:28:15','2021-08-27 12:28:15',NULL),(3883,2978,41711,303851,3,3883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-06','2019-08-06',1131.93,NULL,NULL,1,'2021-08-27 12:28:15','2021-08-27 12:28:15',NULL),(3884,2978,41711,303851,3,3884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-06','2019-08-06',211.77,NULL,NULL,1,'2021-08-27 12:28:15','2021-08-27 12:28:15',NULL),(3885,2978,41711,303851,3,3885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-07','2019-08-07',361.53,NULL,NULL,1,'2021-08-27 12:28:15','2021-08-27 12:28:15',NULL);
INSERT INTO `balance_libro` VALUES (3886,2978,41711,303851,3,3886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-07','2019-08-07',55.55,NULL,NULL,1,'2021-08-27 12:28:15','2021-08-27 12:28:15',NULL),(3887,2978,41711,303851,3,3887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-07','2019-08-07',816.28,NULL,NULL,1,'2021-08-27 12:28:15','2021-08-27 12:28:15',NULL),(3888,2978,41711,303851,3,3888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-07','2019-08-07',4038.45,NULL,NULL,1,'2021-08-27 12:28:15','2021-08-27 12:28:15',NULL),(3889,2978,41711,303851,3,3889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-08','2019-08-08',394.07,NULL,NULL,1,'2021-08-27 12:28:15','2021-08-27 12:28:15',NULL),(3890,2978,41711,303851,3,3890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-08','2019-08-08',354.45,NULL,NULL,1,'2021-08-27 12:28:15','2021-08-27 12:28:15',NULL),(3891,2978,41711,303851,3,3891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-08','2019-08-08',1014.99,NULL,NULL,1,'2021-08-27 12:28:15','2021-08-27 12:28:15',NULL),(3892,2978,41711,303851,3,3892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-08','2019-08-08',837.51,NULL,NULL,1,'2021-08-27 12:28:15','2021-08-27 12:28:15',NULL),(3893,2978,41711,303851,3,3893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-09','2019-08-09',257.47,NULL,NULL,1,'2021-08-27 12:28:15','2021-08-27 12:28:15',NULL),(3894,2978,41711,303851,3,3894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-09','2019-08-09',2193.07,NULL,NULL,1,'2021-08-27 12:28:15','2021-08-27 12:28:15',NULL),(3895,2978,41711,303851,3,3895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-09','2019-08-09',1272.11,NULL,NULL,1,'2021-08-27 12:28:15','2021-08-27 12:28:15',NULL),(3896,2978,41711,303851,3,3896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-09','2019-08-09',356.77,NULL,NULL,1,'2021-08-27 12:28:16','2021-08-27 12:28:16',NULL),(3897,2978,41711,303851,3,3897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-09','2019-08-09',785.84,NULL,NULL,1,'2021-08-27 12:28:16','2021-08-27 12:28:16',NULL),(3898,2978,41711,303851,3,3898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-12','2019-08-12',3778.39,NULL,NULL,1,'2021-08-27 12:28:16','2021-08-27 12:28:16',NULL),(3899,2978,41711,303851,3,3899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-12','2019-08-12',412.70,NULL,NULL,1,'2021-08-27 12:28:16','2021-08-27 12:28:16',NULL),(3900,2978,41711,303851,3,3900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-12','2019-08-12',724.49,NULL,NULL,1,'2021-08-27 12:28:16','2021-08-27 12:28:16',NULL),(3901,2978,41711,303851,3,3901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-12','2019-08-12',9396.00,NULL,NULL,1,'2021-08-27 12:28:16','2021-08-27 12:28:16',NULL),(3902,2978,41711,303851,3,3902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-13','2019-08-13',122.24,NULL,NULL,1,'2021-08-27 12:28:16','2021-08-27 12:28:16',NULL),(3903,2978,41711,303851,3,3903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-13','2019-08-13',461.42,NULL,NULL,1,'2021-08-27 12:28:16','2021-08-27 12:28:16',NULL),(3904,2978,41711,303851,3,3904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-13','2019-08-13',2502.24,NULL,NULL,1,'2021-08-27 12:28:16','2021-08-27 12:28:16',NULL),(3905,2978,41711,303851,3,3905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-13','2019-08-13',784.75,NULL,NULL,1,'2021-08-27 12:28:16','2021-08-27 12:28:16',NULL),(3906,2978,41711,303851,3,3906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-13','2019-08-13',9810.35,NULL,NULL,1,'2021-08-27 12:28:16','2021-08-27 12:28:16',NULL),(3907,2978,41711,303851,3,3907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-13','2019-08-13',1348.38,NULL,NULL,1,'2021-08-27 12:28:16','2021-08-27 12:28:16',NULL),(3908,2978,41711,303851,3,3908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-13','2019-08-13',537.97,NULL,NULL,1,'2021-08-27 12:28:16','2021-08-27 12:28:16',NULL),(3909,2978,41711,303851,3,3909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-13','2019-08-13',388.71,NULL,NULL,1,'2021-08-27 12:28:16','2021-08-27 12:28:16',NULL);
INSERT INTO `balance_libro` VALUES (3910,2978,41711,303851,3,3910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-13','2019-08-13',405.84,NULL,NULL,1,'2021-08-27 12:28:16','2021-08-27 12:28:16',NULL),(3911,2978,41711,303851,3,3911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-13','2019-08-13',211.31,NULL,NULL,1,'2021-08-27 12:28:16','2021-08-27 12:28:16',NULL),(3912,2978,41711,303851,3,3912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-13','2019-08-13',1276.58,NULL,NULL,1,'2021-08-27 12:28:16','2021-08-27 12:28:16',NULL),(3913,2978,41711,303851,3,3913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-13','2019-08-13',317.84,NULL,NULL,1,'2021-08-27 12:28:16','2021-08-27 12:28:16',NULL),(3914,2978,41711,303851,3,3914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-14','2019-08-14',307.02,NULL,NULL,1,'2021-08-27 12:28:16','2021-08-27 12:28:16',NULL),(3915,2978,41711,303851,3,3915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-14','2019-08-14',304.73,NULL,NULL,1,'2021-08-27 12:28:16','2021-08-27 12:28:16',NULL),(3916,2978,41711,303851,3,3916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-14','2019-08-14',46.97,NULL,NULL,1,'2021-08-27 12:28:16','2021-08-27 12:28:16',NULL),(3917,2978,41711,303851,3,3917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-14','2019-08-14',1025.72,NULL,NULL,1,'2021-08-27 12:28:16','2021-08-27 12:28:16',NULL),(3918,2978,41711,303851,3,3918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-15','2019-08-15',1227.35,NULL,NULL,1,'2021-08-27 12:28:16','2021-08-27 12:28:16',NULL),(3919,2978,41711,303851,3,3919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-15','2019-08-15',179.39,NULL,NULL,1,'2021-08-27 12:28:16','2021-08-27 12:28:16',NULL),(3920,2978,41711,303851,3,3920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-15','2019-08-15',281.41,NULL,NULL,1,'2021-08-27 12:28:16','2021-08-27 12:28:16',NULL),(3921,2978,41711,303851,3,3921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-15','2019-08-15',3485.90,NULL,NULL,1,'2021-08-27 12:28:16','2021-08-27 12:28:16',NULL),(3922,2978,41711,303851,3,3922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-15','2019-08-15',214.15,NULL,NULL,1,'2021-08-27 12:28:16','2021-08-27 12:28:16',NULL),(3923,2978,41711,303851,3,3923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-15','2019-08-15',57.68,NULL,NULL,1,'2021-08-27 12:28:16','2021-08-27 12:28:16',NULL),(3924,2978,41711,303851,3,3924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-15','2019-08-15',344.69,NULL,NULL,1,'2021-08-27 12:28:16','2021-08-27 12:28:16',NULL),(3925,2978,41711,303851,3,3925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-15','2019-08-15',1323.86,NULL,NULL,1,'2021-08-27 12:28:17','2021-08-27 12:28:17',NULL),(3926,2978,41711,303851,3,3926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-16','2019-08-16',171.70,NULL,NULL,1,'2021-08-27 12:28:17','2021-08-27 12:28:17',NULL),(3927,2978,41711,303851,3,3927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-16','2019-08-16',388.75,NULL,NULL,1,'2021-08-27 12:28:17','2021-08-27 12:28:17',NULL),(3928,2978,41711,303851,3,3928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-16','2019-08-16',390.88,NULL,NULL,1,'2021-08-27 12:28:17','2021-08-27 12:28:17',NULL),(3929,2978,41711,303851,3,3929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-19','2019-08-19',1775.31,NULL,NULL,1,'2021-08-27 12:28:17','2021-08-27 12:28:17',NULL),(3930,2978,41711,303851,3,3930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-19','2019-08-19',2200.40,NULL,NULL,1,'2021-08-27 12:28:17','2021-08-27 12:28:17',NULL),(3931,2978,41711,303851,3,3931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-19','2019-08-19',345.80,NULL,NULL,1,'2021-08-27 12:28:17','2021-08-27 12:28:17',NULL),(3932,2978,41711,303851,3,3932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-20','2019-08-20',838.62,NULL,NULL,1,'2021-08-27 12:28:17','2021-08-27 12:28:17',NULL),(3933,2978,41711,303851,3,3933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-20','2019-08-20',214.15,NULL,NULL,1,'2021-08-27 12:28:17','2021-08-27 12:28:17',NULL);
INSERT INTO `balance_libro` VALUES (3934,2978,41711,303851,3,3934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-20','2019-08-20',699.63,NULL,NULL,1,'2021-08-27 12:28:17','2021-08-27 12:28:17',NULL),(3935,2978,41711,303851,3,3935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-20','2019-08-20',828.84,NULL,NULL,1,'2021-08-27 12:28:17','2021-08-27 12:28:17',NULL),(3936,2978,41711,303851,3,3936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-21','2019-08-21',386.54,NULL,NULL,1,'2021-08-27 12:28:17','2021-08-27 12:28:17',NULL),(3937,2978,41711,303851,3,3937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-21','2019-08-21',228.60,NULL,NULL,1,'2021-08-27 12:28:17','2021-08-27 12:28:17',NULL),(3938,2978,41711,303851,3,3938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-21','2019-08-21',2523.75,NULL,NULL,1,'2021-08-27 12:28:17','2021-08-27 12:28:17',NULL),(3939,2978,41711,303851,3,3939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-22','2019-08-22',1036.37,NULL,NULL,1,'2021-08-27 12:28:17','2021-08-27 12:28:17',NULL),(3940,2978,41711,303851,3,3940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-22','2019-08-22',2080.26,NULL,NULL,1,'2021-08-27 12:28:17','2021-08-27 12:28:17',NULL),(3941,2978,41711,303851,3,3941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-23','2019-08-23',2024.28,NULL,NULL,1,'2021-08-27 12:28:17','2021-08-27 12:28:17',NULL),(3942,2978,41711,303851,3,3942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-23','2019-08-23',450.50,NULL,NULL,1,'2021-08-27 12:28:17','2021-08-27 12:28:17',NULL),(3943,2978,41711,303851,3,3943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-23','2019-08-23',4679.16,NULL,NULL,1,'2021-08-27 12:28:17','2021-08-27 12:28:17',NULL),(3944,2978,41711,303851,3,3944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-23','2019-08-23',360.30,NULL,NULL,1,'2021-08-27 12:28:17','2021-08-27 12:28:17',NULL),(3945,2978,41711,303851,3,3945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-23','2019-08-23',1534.40,NULL,NULL,1,'2021-08-27 12:28:17','2021-08-27 12:28:17',NULL),(3946,2978,41711,303851,3,3946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-23','2019-08-23',104.74,NULL,NULL,1,'2021-08-27 12:28:17','2021-08-27 12:28:17',NULL),(3947,2978,41711,303851,3,3947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-23','2019-08-23',354.65,NULL,NULL,1,'2021-08-27 12:28:17','2021-08-27 12:28:17',NULL),(3948,2978,41711,303851,3,3948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-26','2019-08-26',4176.38,NULL,NULL,1,'2021-08-27 12:28:17','2021-08-27 12:28:17',NULL),(3949,2978,41711,303851,3,3949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-26','2019-08-26',86.47,NULL,NULL,1,'2021-08-27 12:28:17','2021-08-27 12:28:17',NULL),(3950,2978,41711,303851,3,3950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-26','2019-08-26',690.08,NULL,NULL,1,'2021-08-27 12:28:17','2021-08-27 12:28:17',NULL),(3951,2978,41711,303851,3,3951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-26','2019-08-26',1442.20,NULL,NULL,1,'2021-08-27 12:28:17','2021-08-27 12:28:17',NULL),(3952,2978,41711,303851,3,3952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-26','2019-08-26',236.64,NULL,NULL,1,'2021-08-27 12:28:17','2021-08-27 12:28:17',NULL),(3953,2978,41711,303851,3,3953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-26','2019-08-26',270.38,NULL,NULL,1,'2021-08-27 12:28:17','2021-08-27 12:28:17',NULL),(3954,2978,41711,303851,3,3954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-27','2019-08-27',6409.39,NULL,NULL,1,'2021-08-27 12:28:18','2021-08-27 12:28:18',NULL),(3955,2978,41711,303851,3,3955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-27','2019-08-27',214.15,NULL,NULL,1,'2021-08-27 12:28:18','2021-08-27 12:28:18',NULL),(3956,2978,41711,303851,3,3956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-27','2019-08-27',315.53,NULL,NULL,1,'2021-08-27 12:28:18','2021-08-27 12:28:18',NULL),(3957,2978,41711,303851,3,3957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-28','2019-08-28',962.96,NULL,NULL,1,'2021-08-27 12:28:18','2021-08-27 12:28:18',NULL);
INSERT INTO `balance_libro` VALUES (3958,2978,41711,303851,3,3958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-28','2019-08-28',330.79,NULL,NULL,1,'2021-08-27 12:28:18','2021-08-27 12:28:18',NULL),(3959,2978,41711,303851,3,3959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-28','2019-08-28',368.84,NULL,NULL,1,'2021-08-27 12:28:18','2021-08-27 12:28:18',NULL),(3960,2978,41711,303851,3,3960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-28','2019-08-28',177.23,NULL,NULL,1,'2021-08-27 12:28:18','2021-08-27 12:28:18',NULL),(3961,2978,41711,303851,3,3961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-29','2019-08-29',555.02,NULL,NULL,1,'2021-08-27 12:28:18','2021-08-27 12:28:18',NULL),(3962,2978,41711,303851,3,3962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-29','2019-08-29',784.10,NULL,NULL,1,'2021-08-27 12:28:18','2021-08-27 12:28:18',NULL),(3963,2978,41711,303851,3,3963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-29','2019-08-29',959.83,NULL,NULL,1,'2021-08-27 12:28:18','2021-08-27 12:28:18',NULL),(3964,2978,41711,303851,3,3964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-29','2019-08-29',307.50,NULL,NULL,1,'2021-08-27 12:28:18','2021-08-27 12:28:18',NULL),(3965,2978,41711,303851,3,3965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-29','2019-08-29',5123.06,NULL,NULL,1,'2021-08-27 12:28:18','2021-08-27 12:28:18',NULL),(3966,2978,41711,303851,3,3966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-29','2019-08-29',7.81,NULL,NULL,1,'2021-08-27 12:28:18','2021-08-27 12:28:18',NULL),(3967,2978,41711,303851,3,3967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-29','2019-08-29',2470.25,NULL,NULL,1,'2021-08-27 12:28:18','2021-08-27 12:28:18',NULL),(3968,2978,41711,303851,3,3968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-29','2019-08-29',2993.00,NULL,NULL,1,'2021-08-27 12:28:18','2021-08-27 12:28:18',NULL),(3969,2978,41711,303851,3,3969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-30','2019-08-30',1040.10,NULL,NULL,1,'2021-08-27 12:28:18','2021-08-27 12:28:18',NULL),(3970,2978,41711,303851,3,3970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-31','2019-08-31',1867.80,NULL,NULL,1,'2021-08-27 12:28:18','2021-08-27 12:28:18',NULL),(3971,2978,41711,303851,3,3971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-08-31','2019-08-31',1204.13,NULL,NULL,1,'2021-08-27 12:28:18','2021-08-27 12:28:18',NULL),(3972,2978,41711,303852,3,3972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-01','2019-09-01',1492.11,NULL,NULL,1,'2021-08-27 12:29:06','2021-08-27 12:29:06',NULL),(3973,2978,41711,303852,3,3973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-02','2019-09-02',519.77,NULL,NULL,1,'2021-08-27 12:29:06','2021-08-27 12:29:06',NULL),(3974,2978,41711,303852,3,3974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-02','2019-09-02',755.63,NULL,NULL,1,'2021-08-27 12:29:07','2021-08-27 12:29:07',NULL),(3975,2978,41711,303852,3,3975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-03','2019-09-03',0.01,NULL,NULL,1,'2021-08-27 12:29:07','2021-08-27 12:29:07',NULL),(3976,2978,41711,303852,3,3976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-03','2019-09-03',1498.44,NULL,NULL,1,'2021-08-27 12:29:07','2021-08-27 12:29:07',NULL),(3977,2978,41711,303852,3,3977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-04','2019-09-04',1672.02,NULL,NULL,1,'2021-08-27 12:29:07','2021-08-27 12:29:07',NULL),(3978,2978,41711,303852,3,3978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-04','2019-09-04',164.50,NULL,NULL,1,'2021-08-27 12:29:07','2021-08-27 12:29:07',NULL),(3979,2978,41711,303852,3,3979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-04','2019-09-04',2198.30,NULL,NULL,1,'2021-08-27 12:29:07','2021-08-27 12:29:07',NULL),(3980,2978,41711,303852,3,3980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-05','2019-09-05',2612.58,NULL,NULL,1,'2021-08-27 12:29:07','2021-08-27 12:29:07',NULL),(3981,2978,41711,303852,3,3981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-05','2019-09-05',455.03,NULL,NULL,1,'2021-08-27 12:29:07','2021-08-27 12:29:07',NULL);
INSERT INTO `balance_libro` VALUES (3982,2978,41711,303852,3,3982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-05','2019-09-05',349.42,NULL,NULL,1,'2021-08-27 12:29:07','2021-08-27 12:29:07',NULL),(3983,2978,41711,303852,3,3983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-06','2019-09-06',250.00,NULL,NULL,1,'2021-08-27 12:29:07','2021-08-27 12:29:07',NULL),(3984,2978,41711,303852,3,3984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-06','2019-09-06',2086.72,NULL,NULL,1,'2021-08-27 12:29:07','2021-08-27 12:29:07',NULL),(3985,2978,41711,303852,3,3985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-06','2019-09-06',3022.04,NULL,NULL,1,'2021-08-27 12:29:07','2021-08-27 12:29:07',NULL),(3986,2978,41711,303852,3,3986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-08','2019-09-08',55.76,NULL,NULL,1,'2021-08-27 12:29:07','2021-08-27 12:29:07',NULL),(3987,2978,41711,303852,3,3987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-08','2019-09-08',737.55,NULL,NULL,1,'2021-08-27 12:29:07','2021-08-27 12:29:07',NULL),(3988,2978,41711,303852,3,3988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-09','2019-09-09',10380.99,NULL,NULL,1,'2021-08-27 12:29:08','2021-08-27 12:29:08',NULL),(3989,2978,41711,303852,3,3989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-09','2019-09-09',2735.80,NULL,NULL,1,'2021-08-27 12:29:08','2021-08-27 12:29:08',NULL),(3990,2978,41711,303852,3,3990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-09','2019-09-09',563.09,NULL,NULL,1,'2021-08-27 12:29:08','2021-08-27 12:29:08',NULL),(3991,2978,41711,303852,3,3991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-10','2019-09-10',3575.11,NULL,NULL,1,'2021-08-27 12:29:08','2021-08-27 12:29:08',NULL),(3992,2978,41711,303852,3,3992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-10','2019-09-10',515.38,NULL,NULL,1,'2021-08-27 12:29:08','2021-08-27 12:29:08',NULL),(3993,2978,41711,303852,3,3993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-10','2019-09-10',515.38,NULL,NULL,1,'2021-08-27 12:29:08','2021-08-27 12:29:08',NULL),(3994,2978,41711,303852,3,3994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-10','2019-09-10',597.00,NULL,NULL,1,'2021-08-27 12:29:08','2021-08-27 12:29:08',NULL),(3995,2978,41711,303852,3,3995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-10','2019-09-10',1002.10,NULL,NULL,1,'2021-08-27 12:29:08','2021-08-27 12:29:08',NULL),(3996,2978,41711,303852,3,3996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-11','2019-09-11',1498.42,NULL,NULL,1,'2021-08-27 12:29:08','2021-08-27 12:29:08',NULL),(3997,2978,41711,303852,3,3997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-11','2019-09-11',271.89,NULL,NULL,1,'2021-08-27 12:29:08','2021-08-27 12:29:08',NULL),(3998,2978,41711,303852,3,3998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-11','2019-09-11',364.67,NULL,NULL,1,'2021-08-27 12:29:08','2021-08-27 12:29:08',NULL),(3999,2978,41711,303852,3,3999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-11','2019-09-11',1802.73,NULL,NULL,1,'2021-08-27 12:29:08','2021-08-27 12:29:08',NULL),(4000,2978,41711,303852,3,4000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-12','2019-09-12',3518.21,NULL,NULL,1,'2021-08-27 12:29:08','2021-08-27 12:29:08',NULL),(4001,2978,41711,303852,3,4001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-12','2019-09-12',2646.83,NULL,NULL,1,'2021-08-27 12:29:08','2021-08-27 12:29:08',NULL),(4002,2978,41711,303852,3,4002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-12','2019-09-12',97.52,NULL,NULL,1,'2021-08-27 12:29:08','2021-08-27 12:29:08',NULL),(4003,2978,41711,303852,3,4003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-12','2019-09-12',0.01,NULL,NULL,1,'2021-08-27 12:29:09','2021-08-27 12:29:09',NULL),(4004,2978,41711,303852,3,4004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-13','2019-09-13',2235.78,NULL,NULL,1,'2021-08-27 12:29:09','2021-08-27 12:29:09',NULL),(4005,2978,41711,303852,3,4005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-13','2019-09-13',137.19,NULL,NULL,1,'2021-08-27 12:29:09','2021-08-27 12:29:09',NULL);
INSERT INTO `balance_libro` VALUES (4006,2978,41711,303852,3,4006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-15','2019-09-15',3296.70,NULL,NULL,1,'2021-08-27 12:29:09','2021-08-27 12:29:09',NULL),(4007,2978,41711,303852,3,4007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-15','2019-09-15',74.53,NULL,NULL,1,'2021-08-27 12:29:09','2021-08-27 12:29:09',NULL),(4008,2978,41711,303852,3,4008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-15','2019-09-15',1414.80,NULL,NULL,1,'2021-08-27 12:29:09','2021-08-27 12:29:09',NULL),(4009,2978,41711,303852,3,4009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-15','2019-09-15',2154.94,NULL,NULL,1,'2021-08-27 12:29:09','2021-08-27 12:29:09',NULL),(4010,2978,41711,303852,3,4010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-16','2019-09-16',2065.62,NULL,NULL,1,'2021-08-27 12:29:09','2021-08-27 12:29:09',NULL),(4011,2978,41711,303852,3,4011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-16','2019-09-16',499.61,NULL,NULL,1,'2021-08-27 12:29:09','2021-08-27 12:29:09',NULL),(4012,2978,41711,303852,3,4012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-16','2019-09-16',310.33,NULL,NULL,1,'2021-08-27 12:29:09','2021-08-27 12:29:09',NULL),(4013,2978,41711,303852,3,4013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-16','2019-09-16',275.19,NULL,NULL,1,'2021-08-27 12:29:09','2021-08-27 12:29:09',NULL),(4014,2978,41711,303852,3,4014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-16','2019-09-16',2509.86,NULL,NULL,1,'2021-08-27 12:29:09','2021-08-27 12:29:09',NULL),(4015,2978,41711,303852,3,4015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-16','2019-09-16',139.03,NULL,NULL,1,'2021-08-27 12:29:09','2021-08-27 12:29:09',NULL),(4016,2978,41711,303852,3,4016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-16','2019-09-16',696.49,NULL,NULL,1,'2021-08-27 12:29:10','2021-08-27 12:29:10',NULL),(4017,2978,41711,303852,3,4017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-16','2019-09-16',1843.94,NULL,NULL,1,'2021-08-27 12:29:10','2021-08-27 12:29:10',NULL),(4018,2978,41711,303852,3,4018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-16','2019-09-16',139.03,NULL,NULL,1,'2021-08-27 12:29:10','2021-08-27 12:29:10',NULL),(4019,2978,41711,303852,3,4019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-16','2019-09-16',358.81,NULL,NULL,1,'2021-08-27 12:29:10','2021-08-27 12:29:10',NULL),(4020,2978,41711,303852,3,4020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-17','2019-09-17',260.45,NULL,NULL,1,'2021-08-27 12:29:10','2021-08-27 12:29:10',NULL),(4021,2978,41711,303852,3,4021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-17','2019-09-17',1199.06,NULL,NULL,1,'2021-08-27 12:29:10','2021-08-27 12:29:10',NULL),(4022,2978,41711,303852,3,4022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-17','2019-09-17',214.15,NULL,NULL,1,'2021-08-27 12:29:10','2021-08-27 12:29:10',NULL),(4023,2978,41711,303852,3,4023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-17','2019-09-17',663.56,NULL,NULL,1,'2021-08-27 12:29:10','2021-08-27 12:29:10',NULL),(4024,2978,41711,303852,3,4024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-17','2019-09-17',410.38,NULL,NULL,1,'2021-08-27 12:29:10','2021-08-27 12:29:10',NULL),(4025,2978,41711,303852,3,4025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-17','2019-09-17',1637.57,NULL,NULL,1,'2021-08-27 12:29:10','2021-08-27 12:29:10',NULL),(4026,2978,41711,303852,3,4026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-18','2019-09-18',411.23,NULL,NULL,1,'2021-08-27 12:29:10','2021-08-27 12:29:10',NULL),(4027,2978,41711,303852,3,4027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-18','2019-09-18',1860.39,NULL,NULL,1,'2021-08-27 12:29:10','2021-08-27 12:29:10',NULL),(4028,2978,41711,303852,3,4028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-18','2019-09-18',358.81,NULL,NULL,1,'2021-08-27 12:29:10','2021-08-27 12:29:10',NULL),(4029,2978,41711,303852,3,4029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-19','2019-09-19',689.38,NULL,NULL,1,'2021-08-27 12:29:10','2021-08-27 12:29:10',NULL);
INSERT INTO `balance_libro` VALUES (4030,2978,41711,303852,3,4030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-19','2019-09-19',63.06,NULL,NULL,1,'2021-08-27 12:29:10','2021-08-27 12:29:10',NULL),(4031,2978,41711,303852,3,4031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-19','2019-09-19',284.18,NULL,NULL,1,'2021-08-27 12:29:10','2021-08-27 12:29:10',NULL),(4032,2978,41711,303852,3,4032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-20','2019-09-20',1918.85,NULL,NULL,1,'2021-08-27 12:29:10','2021-08-27 12:29:10',NULL),(4033,2978,41711,303852,3,4033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-20','2019-09-20',431.70,NULL,NULL,1,'2021-08-27 12:29:10','2021-08-27 12:29:10',NULL),(4034,2978,41711,303852,3,4034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-20','2019-09-20',4649.71,NULL,NULL,1,'2021-08-27 12:29:10','2021-08-27 12:29:10',NULL),(4035,2978,41711,303852,3,4035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-20','2019-09-20',1964.97,NULL,NULL,1,'2021-08-27 12:29:10','2021-08-27 12:29:10',NULL),(4036,2978,41711,303852,3,4036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-21','2019-09-21',614.78,NULL,NULL,1,'2021-08-27 12:29:10','2021-08-27 12:29:10',NULL),(4037,2978,41711,303852,3,4037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-21','2019-09-21',135.95,NULL,NULL,1,'2021-08-27 12:29:10','2021-08-27 12:29:10',NULL),(4038,2978,41711,303852,3,4038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-23','2019-09-23',170.29,NULL,NULL,1,'2021-08-27 12:29:10','2021-08-27 12:29:10',NULL),(4039,2978,41711,303852,3,4039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-23','2019-09-23',81.17,NULL,NULL,1,'2021-08-27 12:29:11','2021-08-27 12:29:11',NULL),(4040,2978,41711,303852,3,4040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-23','2019-09-23',226.93,NULL,NULL,1,'2021-08-27 12:29:11','2021-08-27 12:29:11',NULL),(4041,2978,41711,303852,3,4041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-23','2019-09-23',801.75,NULL,NULL,1,'2021-08-27 12:29:11','2021-08-27 12:29:11',NULL),(4042,2978,41711,303852,3,4042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-23','2019-09-23',321.26,NULL,NULL,1,'2021-08-27 12:29:11','2021-08-27 12:29:11',NULL),(4043,2978,41711,303852,3,4043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-23','2019-09-23',941.52,NULL,NULL,1,'2021-08-27 12:29:11','2021-08-27 12:29:11',NULL),(4044,2978,41711,303852,3,4044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-23','2019-09-23',345.80,NULL,NULL,1,'2021-08-27 12:29:11','2021-08-27 12:29:11',NULL),(4045,2978,41711,303852,3,4045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-24','2019-09-24',1023.91,NULL,NULL,1,'2021-08-27 12:29:11','2021-08-27 12:29:11',NULL),(4046,2978,41711,303852,3,4046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-24','2019-09-24',1299.53,NULL,NULL,1,'2021-08-27 12:29:11','2021-08-27 12:29:11',NULL),(4047,2978,41711,303852,3,4047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-24','2019-09-24',139.03,NULL,NULL,1,'2021-08-27 12:29:11','2021-08-27 12:29:11',NULL),(4048,2978,41711,303852,3,4048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-24','2019-09-24',380.67,NULL,NULL,1,'2021-08-27 12:29:11','2021-08-27 12:29:11',NULL),(4049,2978,41711,303852,3,4049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-24','2019-09-24',124.51,NULL,NULL,1,'2021-08-27 12:29:11','2021-08-27 12:29:11',NULL),(4050,2978,41711,303852,3,4050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-24','2019-09-24',696.49,NULL,NULL,1,'2021-08-27 12:29:11','2021-08-27 12:29:11',NULL),(4051,2978,41711,303852,3,4051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-24','2019-09-24',1031.51,NULL,NULL,1,'2021-08-27 12:29:11','2021-08-27 12:29:11',NULL),(4052,2978,41711,303852,3,4052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-24','2019-09-24',1636.01,NULL,NULL,1,'2021-08-27 12:29:11','2021-08-27 12:29:11',NULL),(4053,2978,41711,303852,3,4053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-24','2019-09-24',1501.22,NULL,NULL,1,'2021-08-27 12:29:11','2021-08-27 12:29:11',NULL);
INSERT INTO `balance_libro` VALUES (4054,2978,41711,303852,3,4054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-24','2019-09-24',656.00,NULL,NULL,1,'2021-08-27 12:29:11','2021-08-27 12:29:11',NULL),(4055,2978,41711,303852,3,4055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-24','2019-09-24',1160.30,NULL,NULL,1,'2021-08-27 12:29:11','2021-08-27 12:29:11',NULL),(4056,2978,41711,303852,3,4056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-24','2019-09-24',308.14,NULL,NULL,1,'2021-08-27 12:29:11','2021-08-27 12:29:11',NULL),(4057,2978,41711,303852,3,4057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-25','2019-09-25',1147.36,NULL,NULL,1,'2021-08-27 12:29:11','2021-08-27 12:29:11',NULL),(4058,2978,41711,303852,3,4058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-25','2019-09-25',311.99,NULL,NULL,1,'2021-08-27 12:29:11','2021-08-27 12:29:11',NULL),(4059,2978,41711,303852,3,4059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-26','2019-09-26',7730.95,NULL,NULL,1,'2021-08-27 12:29:11','2021-08-27 12:29:11',NULL),(4060,2978,41711,303852,3,4060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-26','2019-09-26',1746.23,NULL,NULL,1,'2021-08-27 12:29:11','2021-08-27 12:29:11',NULL),(4061,2978,41711,303852,3,4061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-26','2019-09-26',122.97,NULL,NULL,1,'2021-08-27 12:29:11','2021-08-27 12:29:11',NULL),(4062,2978,41711,303852,3,4062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-26','2019-09-26',1945.03,NULL,NULL,1,'2021-08-27 12:29:11','2021-08-27 12:29:11',NULL),(4063,2978,41711,303852,3,4063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-27','2019-09-27',519.51,NULL,NULL,1,'2021-08-27 12:29:11','2021-08-27 12:29:11',NULL),(4064,2978,41711,303852,3,4064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-27','2019-09-27',135.95,NULL,NULL,1,'2021-08-27 12:29:12','2021-08-27 12:29:12',NULL),(4065,2978,41711,303852,3,4065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-27','2019-09-27',1384.98,NULL,NULL,1,'2021-08-27 12:29:12','2021-08-27 12:29:12',NULL),(4066,2978,41711,303852,3,4066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-27','2019-09-27',850.06,NULL,NULL,1,'2021-08-27 12:29:12','2021-08-27 12:29:12',NULL),(4067,2978,41711,303852,3,4067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-27','2019-09-27',170.27,NULL,NULL,1,'2021-08-27 12:29:12','2021-08-27 12:29:12',NULL),(4068,2978,41711,303852,3,4068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-28','2019-09-28',1247.44,NULL,NULL,1,'2021-08-27 12:29:12','2021-08-27 12:29:12',NULL),(4069,2978,41711,303852,3,4069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-28','2019-09-28',156.50,NULL,NULL,1,'2021-08-27 12:29:12','2021-08-27 12:29:12',NULL),(4070,2978,41711,303852,3,4070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-29','2019-09-29',536.64,NULL,NULL,1,'2021-08-27 12:29:12','2021-08-27 12:29:12',NULL),(4071,2978,41711,303852,3,4071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-30','2019-09-30',5561.03,NULL,NULL,1,'2021-08-27 12:29:12','2021-08-27 12:29:12',NULL),(4072,2978,41711,303852,3,4072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-30','2019-09-30',1071.28,NULL,NULL,1,'2021-08-27 12:29:12','2021-08-27 12:29:12',NULL),(4073,2978,41711,303852,3,4073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-30','2019-09-30',886.22,NULL,NULL,1,'2021-08-27 12:29:12','2021-08-27 12:29:12',NULL),(4074,2978,41711,303852,3,4074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-09-30','2019-09-30',1204.13,NULL,NULL,1,'2021-08-27 12:29:12','2021-08-27 12:29:12',NULL),(4075,2978,41711,303854,3,4075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-01','2019-11-01',891.94,NULL,NULL,1,'2021-08-27 12:35:35','2021-08-27 12:35:35',NULL),(4076,2978,41711,303854,3,4076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-01','2019-11-01',738.17,NULL,NULL,1,'2021-08-27 12:35:35','2021-08-27 12:35:35',NULL),(4077,2978,41711,303854,3,4077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-01','2019-11-01',1767.81,NULL,NULL,1,'2021-08-27 12:35:35','2021-08-27 12:35:35',NULL);
INSERT INTO `balance_libro` VALUES (4078,2978,41711,303854,3,4078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-02','2019-11-02',3759.55,NULL,NULL,1,'2021-08-27 12:35:35','2021-08-27 12:35:35',NULL),(4079,2978,41711,303854,3,4079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-02','2019-11-02',84.19,NULL,NULL,1,'2021-08-27 12:35:36','2021-08-27 12:35:36',NULL),(4080,2978,41711,303854,3,4080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-04','2019-11-04',3562.29,NULL,NULL,1,'2021-08-27 12:35:36','2021-08-27 12:35:36',NULL),(4081,2978,41711,303854,3,4081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-04','2019-11-04',123.57,NULL,NULL,1,'2021-08-27 12:35:36','2021-08-27 12:35:36',NULL),(4082,2978,41711,303854,3,4082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-04','2019-11-04',244.66,NULL,NULL,1,'2021-08-27 12:35:36','2021-08-27 12:35:36',NULL),(4083,2978,41711,303854,3,4083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-04','2019-11-04',3323.42,NULL,NULL,1,'2021-08-27 12:35:36','2021-08-27 12:35:36',NULL),(4084,2978,41711,303854,3,4084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-04','2019-11-04',348.75,NULL,NULL,1,'2021-08-27 12:35:36','2021-08-27 12:35:36',NULL),(4085,2978,41711,303854,3,4085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-04','2019-11-04',2198.30,NULL,NULL,1,'2021-08-27 12:35:36','2021-08-27 12:35:36',NULL),(4086,2978,41711,303854,3,4086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-05','2019-11-05',436.93,NULL,NULL,1,'2021-08-27 12:35:36','2021-08-27 12:35:36',NULL),(4087,2978,41711,303854,3,4087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-05','2019-11-05',568.30,NULL,NULL,1,'2021-08-27 12:35:36','2021-08-27 12:35:36',NULL),(4088,2978,41711,303854,3,4088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-05','2019-11-05',101.89,NULL,NULL,1,'2021-08-27 12:35:36','2021-08-27 12:35:36',NULL),(4089,2978,41711,303854,3,4089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-05','2019-11-05',766.09,NULL,NULL,1,'2021-08-27 12:35:36','2021-08-27 12:35:36',NULL),(4090,2978,41711,303854,3,4090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-05','2019-11-05',956.98,NULL,NULL,1,'2021-08-27 12:35:36','2021-08-27 12:35:36',NULL),(4091,2978,41711,303854,3,4091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-06','2019-11-06',3686.17,NULL,NULL,1,'2021-08-27 12:35:36','2021-08-27 12:35:36',NULL),(4092,2978,41711,303854,3,4092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-06','2019-11-06',2101.19,NULL,NULL,1,'2021-08-27 12:35:36','2021-08-27 12:35:36',NULL),(4093,2978,41711,303854,3,4093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-06','2019-11-06',597.34,NULL,NULL,1,'2021-08-27 12:35:36','2021-08-27 12:35:36',NULL),(4094,2978,41711,303854,3,4094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-06','2019-11-06',621.61,NULL,NULL,1,'2021-08-27 12:35:36','2021-08-27 12:35:36',NULL),(4095,2978,41711,303854,3,4095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-06','2019-11-06',101.89,NULL,NULL,1,'2021-08-27 12:35:36','2021-08-27 12:35:36',NULL),(4096,2978,41711,303854,3,4096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-06','2019-11-06',441.32,NULL,NULL,1,'2021-08-27 12:35:36','2021-08-27 12:35:36',NULL),(4097,2978,41711,303854,3,4097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-07','2019-11-07',1266.20,NULL,NULL,1,'2021-08-27 12:35:36','2021-08-27 12:35:36',NULL),(4098,2978,41711,303854,3,4098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-07','2019-11-07',952.61,NULL,NULL,1,'2021-08-27 12:35:36','2021-08-27 12:35:36',NULL),(4099,2978,41711,303854,3,4099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-07','2019-11-07',262.86,NULL,NULL,1,'2021-08-27 12:35:36','2021-08-27 12:35:36',NULL),(4100,2978,41711,303854,3,4100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-08','2019-11-08',73.32,NULL,NULL,1,'2021-08-27 12:35:36','2021-08-27 12:35:36',NULL),(4101,2978,41711,303854,3,4101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-08','2019-11-08',2129.39,NULL,NULL,1,'2021-08-27 12:35:36','2021-08-27 12:35:36',NULL);
INSERT INTO `balance_libro` VALUES (4102,2978,41711,303854,3,4102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-08','2019-11-08',222.90,NULL,NULL,1,'2021-08-27 12:35:36','2021-08-27 12:35:36',NULL),(4103,2978,41711,303854,3,4103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-08','2019-11-08',3340.76,NULL,NULL,1,'2021-08-27 12:35:37','2021-08-27 12:35:37',NULL),(4104,2978,41711,303854,3,4104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-11','2019-11-11',2727.60,NULL,NULL,1,'2021-08-27 12:35:37','2021-08-27 12:35:37',NULL),(4105,2978,41711,303854,3,4105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-11','2019-11-11',1952.89,NULL,NULL,1,'2021-08-27 12:35:37','2021-08-27 12:35:37',NULL),(4106,2978,41711,303854,3,4106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-11','2019-11-11',131.43,NULL,NULL,1,'2021-08-27 12:35:37','2021-08-27 12:35:37',NULL),(4107,2978,41711,303854,3,4107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-11','2019-11-11',250.00,NULL,NULL,1,'2021-08-27 12:35:37','2021-08-27 12:35:37',NULL),(4108,2978,41711,303854,3,4108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-12','2019-11-12',66.95,NULL,NULL,1,'2021-08-27 12:35:37','2021-08-27 12:35:37',NULL),(4109,2978,41711,303854,3,4109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-12','2019-11-12',608.36,NULL,NULL,1,'2021-08-27 12:35:37','2021-08-27 12:35:37',NULL),(4110,2978,41711,303854,3,4110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-12','2019-11-12',825.08,NULL,NULL,1,'2021-08-27 12:35:37','2021-08-27 12:35:37',NULL),(4111,2978,41711,303854,3,4111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-12','2019-11-12',535.82,NULL,NULL,1,'2021-08-27 12:35:37','2021-08-27 12:35:37',NULL),(4112,2978,41711,303854,3,4112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-13','2019-11-13',587.77,NULL,NULL,1,'2021-08-27 12:35:37','2021-08-27 12:35:37',NULL),(4113,2978,41711,303854,3,4113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-13','2019-11-13',1402.73,NULL,NULL,1,'2021-08-27 12:35:37','2021-08-27 12:35:37',NULL),(4114,2978,41711,303854,3,4114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-13','2019-11-13',2209.66,NULL,NULL,1,'2021-08-27 12:35:37','2021-08-27 12:35:37',NULL),(4115,2978,41711,303854,3,4115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-14','2019-11-14',9009.03,NULL,NULL,1,'2021-08-27 12:35:37','2021-08-27 12:35:37',NULL),(4116,2978,41711,303854,3,4116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-15','2019-11-15',3413.22,NULL,NULL,1,'2021-08-27 12:35:37','2021-08-27 12:35:37',NULL),(4117,2978,41711,303854,3,4117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-15','2019-11-15',949.26,NULL,NULL,1,'2021-08-27 12:35:37','2021-08-27 12:35:37',NULL),(4118,2978,41711,303854,3,4118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-15','2019-11-15',765.55,NULL,NULL,1,'2021-08-27 12:35:37','2021-08-27 12:35:37',NULL),(4119,2978,41711,303854,3,4119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-15','2019-11-15',858.42,NULL,NULL,1,'2021-08-27 12:35:37','2021-08-27 12:35:37',NULL),(4120,2978,41711,303854,3,4120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-15','2019-11-15',314.46,NULL,NULL,1,'2021-08-27 12:35:37','2021-08-27 12:35:37',NULL),(4121,2978,41711,303854,3,4121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-18','2019-11-18',997.25,NULL,NULL,1,'2021-08-27 12:35:37','2021-08-27 12:35:37',NULL),(4122,2978,41711,303854,3,4122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-18','2019-11-18',257.80,NULL,NULL,1,'2021-08-27 12:35:37','2021-08-27 12:35:37',NULL),(4123,2978,41711,303854,3,4123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-19','2019-11-19',345.80,NULL,NULL,1,'2021-08-27 12:35:37','2021-08-27 12:35:37',NULL),(4124,2978,41711,303854,3,4124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-19','2019-11-19',143.23,NULL,NULL,1,'2021-08-27 12:35:37','2021-08-27 12:35:37',NULL),(4125,2978,41711,303854,3,4125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-19','2019-11-19',1118.61,NULL,NULL,1,'2021-08-27 12:35:38','2021-08-27 12:35:38',NULL);
INSERT INTO `balance_libro` VALUES (4126,2978,41711,303854,3,4126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-19','2019-11-19',225.75,NULL,NULL,1,'2021-08-27 12:35:38','2021-08-27 12:35:38',NULL),(4127,2978,41711,303854,3,4127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-20','2019-11-20',787.13,NULL,NULL,1,'2021-08-27 12:35:38','2021-08-27 12:35:38',NULL),(4128,2978,41711,303854,3,4128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-20','2019-11-20',270.34,NULL,NULL,1,'2021-08-27 12:35:38','2021-08-27 12:35:38',NULL),(4129,2978,41711,303854,3,4129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-20','2019-11-20',309.49,NULL,NULL,1,'2021-08-27 12:35:38','2021-08-27 12:35:38',NULL),(4130,2978,41711,303854,3,4130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-21','2019-11-21',1305.72,NULL,NULL,1,'2021-08-27 12:35:38','2021-08-27 12:35:38',NULL),(4131,2978,41711,303854,3,4131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-21','2019-11-21',494.23,NULL,NULL,1,'2021-08-27 12:35:38','2021-08-27 12:35:38',NULL),(4132,2978,41711,303854,3,4132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-21','2019-11-21',1557.62,NULL,NULL,1,'2021-08-27 12:35:38','2021-08-27 12:35:38',NULL),(4133,2978,41711,303854,3,4133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-21','2019-11-21',1899.98,NULL,NULL,1,'2021-08-27 12:35:38','2021-08-27 12:35:38',NULL),(4134,2978,41711,303854,3,4134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-22','2019-11-22',983.93,NULL,NULL,1,'2021-08-27 12:35:38','2021-08-27 12:35:38',NULL),(4135,2978,41711,303854,3,4135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-22','2019-11-22',739.20,NULL,NULL,1,'2021-08-27 12:35:38','2021-08-27 12:35:38',NULL),(4136,2978,41711,303854,3,4136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-22','2019-11-22',406.15,NULL,NULL,1,'2021-08-27 12:35:38','2021-08-27 12:35:38',NULL),(4137,2978,41711,303854,3,4137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-22','2019-11-22',770.82,NULL,NULL,1,'2021-08-27 12:35:38','2021-08-27 12:35:38',NULL),(4138,2978,41711,303854,3,4138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-22','2019-11-22',453.84,NULL,NULL,1,'2021-08-27 12:35:38','2021-08-27 12:35:38',NULL),(4139,2978,41711,303854,3,4139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-22','2019-11-22',1975.43,NULL,NULL,1,'2021-08-27 12:35:38','2021-08-27 12:35:38',NULL),(4140,2978,41711,303854,3,4140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-22','2019-11-22',357.61,NULL,NULL,1,'2021-08-27 12:35:38','2021-08-27 12:35:38',NULL),(4141,2978,41711,303854,3,4141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-24','2019-11-24',2096.73,NULL,NULL,1,'2021-08-27 12:35:38','2021-08-27 12:35:38',NULL),(4142,2978,41711,303854,3,4142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-25','2019-11-25',2371.32,NULL,NULL,1,'2021-08-27 12:35:38','2021-08-27 12:35:38',NULL),(4143,2978,41711,303854,3,4143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-25','2019-11-25',589.04,NULL,NULL,1,'2021-08-27 12:35:38','2021-08-27 12:35:38',NULL),(4144,2978,41711,303854,3,4144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-26','2019-11-26',3940.50,NULL,NULL,1,'2021-08-27 12:35:38','2021-08-27 12:35:38',NULL),(4145,2978,41711,303854,3,4145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-26','2019-11-26',536.80,NULL,NULL,1,'2021-08-27 12:35:38','2021-08-27 12:35:38',NULL),(4146,2978,41711,303854,3,4146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-26','2019-11-26',1625.18,NULL,NULL,1,'2021-08-27 12:35:38','2021-08-27 12:35:38',NULL),(4147,2978,41711,303854,3,4147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-26','2019-11-26',946.28,NULL,NULL,1,'2021-08-27 12:35:39','2021-08-27 12:35:39',NULL),(4148,2978,41711,303854,3,4148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-28','2019-11-28',270.38,NULL,NULL,1,'2021-08-27 12:35:39','2021-08-27 12:35:39',NULL),(4149,2978,41711,303854,3,4149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-28','2019-11-28',2024.14,NULL,NULL,1,'2021-08-27 12:35:39','2021-08-27 12:35:39',NULL);
INSERT INTO `balance_libro` VALUES (4150,2978,41711,303854,3,4150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-29','2019-11-29',918.37,NULL,NULL,1,'2021-08-27 12:35:39','2021-08-27 12:35:39',NULL),(4151,2978,41711,303854,3,4151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-11-30','2019-11-30',1204.13,NULL,NULL,1,'2021-08-27 12:35:39','2021-08-27 12:35:39',NULL),(4152,2978,41711,303855,3,4152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-01','2019-12-01',424.70,NULL,NULL,1,'2021-08-27 12:50:16','2021-08-27 12:50:16',NULL),(4153,2978,41711,303855,3,4153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-01','2019-12-01',1767.81,NULL,NULL,1,'2021-08-27 12:50:16','2021-08-27 12:50:16',NULL),(4154,2978,41711,303855,3,4154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-02','2019-12-02',2152.74,NULL,NULL,1,'2021-08-27 12:50:16','2021-08-27 12:50:16',NULL),(4155,2978,41711,303855,3,4155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-02','2019-12-02',170.68,NULL,NULL,1,'2021-08-27 12:50:16','2021-08-27 12:50:16',NULL),(4156,2978,41711,303855,3,4156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-03','2019-12-03',4090.26,NULL,NULL,1,'2021-08-27 12:50:16','2021-08-27 12:50:16',NULL),(4157,2978,41711,303855,3,4157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-03','2019-12-03',412.55,NULL,NULL,1,'2021-08-27 12:50:17','2021-08-27 12:50:17',NULL),(4158,2978,41711,303855,3,4158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-03','2019-12-03',380.61,NULL,NULL,1,'2021-08-27 12:50:17','2021-08-27 12:50:17',NULL),(4159,2978,41711,303855,3,4159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-03','2019-12-03',171.10,NULL,NULL,1,'2021-08-27 12:50:17','2021-08-27 12:50:17',NULL),(4160,2978,41711,303855,3,4160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-03','2019-12-03',144.49,NULL,NULL,1,'2021-08-27 12:50:17','2021-08-27 12:50:17',NULL),(4161,2978,41711,303855,3,4161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-03','2019-12-03',227.95,NULL,NULL,1,'2021-08-27 12:50:17','2021-08-27 12:50:17',NULL),(4162,2978,41711,303855,3,4162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-03','2019-12-03',2768.34,NULL,NULL,1,'2021-08-27 12:50:17','2021-08-27 12:50:17',NULL),(4163,2978,41711,303855,3,4163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-04','2019-12-04',416.64,NULL,NULL,1,'2021-08-27 12:50:17','2021-08-27 12:50:17',NULL),(4164,2978,41711,303855,3,4164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-04','2019-12-04',119.40,NULL,NULL,1,'2021-08-27 12:50:17','2021-08-27 12:50:17',NULL),(4165,2978,41711,303855,3,4165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-04','2019-12-04',159.32,NULL,NULL,1,'2021-08-27 12:50:17','2021-08-27 12:50:17',NULL),(4166,2978,41711,303855,3,4166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-04','2019-12-04',167.07,NULL,NULL,1,'2021-08-27 12:50:17','2021-08-27 12:50:17',NULL),(4167,2978,41711,303855,3,4167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-04','2019-12-04',2643.85,NULL,NULL,1,'2021-08-27 12:50:17','2021-08-27 12:50:17',NULL),(4168,2978,41711,303855,3,4168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-06','2019-12-06',1384.65,NULL,NULL,1,'2021-08-27 12:50:18','2021-08-27 12:50:18',NULL),(4169,2978,41711,303855,3,4169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-06','2019-12-06',1726.77,NULL,NULL,1,'2021-08-27 12:50:18','2021-08-27 12:50:18',NULL),(4170,2978,41711,303855,3,4170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-06','2019-12-06',1582.62,NULL,NULL,1,'2021-08-27 12:50:18','2021-08-27 12:50:18',NULL),(4171,2978,41711,303855,3,4171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-06','2019-12-06',130.34,NULL,NULL,1,'2021-08-27 12:50:18','2021-08-27 12:50:18',NULL),(4172,2978,41711,303855,3,4172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-06','2019-12-06',2213.80,NULL,NULL,1,'2021-08-27 12:50:18','2021-08-27 12:50:18',NULL),(4173,2978,41711,303855,3,4173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-07','2019-12-07',806.71,NULL,NULL,1,'2021-08-27 12:50:18','2021-08-27 12:50:18',NULL);
INSERT INTO `balance_libro` VALUES (4174,2978,41711,303855,3,4174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-08','2019-12-08',1041.18,NULL,NULL,1,'2021-08-27 12:50:18','2021-08-27 12:50:18',NULL),(4175,2978,41711,303855,3,4175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-08','2019-12-08',1124.54,NULL,NULL,1,'2021-08-27 12:50:18','2021-08-27 12:50:18',NULL),(4176,2978,41711,303855,3,4176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-08','2019-12-08',333.52,NULL,NULL,1,'2021-08-27 12:50:18','2021-08-27 12:50:18',NULL),(4177,2978,41711,303855,3,4177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-09','2019-12-09',621.86,NULL,NULL,1,'2021-08-27 12:50:18','2021-08-27 12:50:18',NULL),(4178,2978,41711,303855,3,4178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-09','2019-12-09',842.26,NULL,NULL,1,'2021-08-27 12:50:18','2021-08-27 12:50:18',NULL),(4179,2978,41711,303855,3,4179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-09','2019-12-09',239.26,NULL,NULL,1,'2021-08-27 12:50:18','2021-08-27 12:50:18',NULL),(4180,2978,41711,303855,3,4180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-09','2019-12-09',1578.95,NULL,NULL,1,'2021-08-27 12:50:18','2021-08-27 12:50:18',NULL),(4181,2978,41711,303855,3,4181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-09','2019-12-09',139.71,NULL,NULL,1,'2021-08-27 12:50:18','2021-08-27 12:50:18',NULL),(4182,2978,41711,303855,3,4182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-09','2019-12-09',562.51,NULL,NULL,1,'2021-08-27 12:50:18','2021-08-27 12:50:18',NULL),(4183,2978,41711,303855,3,4183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-09','2019-12-09',2773.82,NULL,NULL,1,'2021-08-27 12:50:19','2021-08-27 12:50:19',NULL),(4184,2978,41711,303855,3,4184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-09','2019-12-09',121.95,NULL,NULL,1,'2021-08-27 12:50:19','2021-08-27 12:50:19',NULL),(4185,2978,41711,303855,3,4185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-09','2019-12-09',250.00,NULL,NULL,1,'2021-08-27 12:50:19','2021-08-27 12:50:19',NULL),(4186,2978,41711,303855,3,4186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-09','2019-12-09',141.72,NULL,NULL,1,'2021-08-27 12:50:19','2021-08-27 12:50:19',NULL),(4187,2978,41711,303855,3,4187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-10','2019-12-10',3791.25,NULL,NULL,1,'2021-08-27 12:50:19','2021-08-27 12:50:19',NULL),(4188,2978,41711,303855,3,4188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-10','2019-12-10',181.23,NULL,NULL,1,'2021-08-27 12:50:19','2021-08-27 12:50:19',NULL),(4189,2978,41711,303855,3,4189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-11','2019-12-11',2855.87,NULL,NULL,1,'2021-08-27 12:50:19','2021-08-27 12:50:19',NULL),(4190,2978,41711,303855,3,4190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-11','2019-12-11',3248.46,NULL,NULL,1,'2021-08-27 12:50:19','2021-08-27 12:50:19',NULL),(4191,2978,41711,303855,3,4191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-11','2019-12-11',513.84,NULL,NULL,1,'2021-08-27 12:50:19','2021-08-27 12:50:19',NULL),(4192,2978,41711,303855,3,4192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-11','2019-12-11',521.05,NULL,NULL,1,'2021-08-27 12:50:19','2021-08-27 12:50:19',NULL),(4193,2978,41711,303855,3,4193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-12','2019-12-12',7999.08,NULL,NULL,1,'2021-08-27 12:50:19','2021-08-27 12:50:19',NULL),(4194,2978,41711,303855,3,4194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-12','2019-12-12',526.59,NULL,NULL,1,'2021-08-27 12:50:19','2021-08-27 12:50:19',NULL),(4195,2978,41711,303855,3,4195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-12','2019-12-12',328.22,NULL,NULL,1,'2021-08-27 12:50:19','2021-08-27 12:50:19',NULL),(4196,2978,41711,303855,3,4196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-12','2019-12-12',788.61,NULL,NULL,1,'2021-08-27 12:50:19','2021-08-27 12:50:19',NULL),(4197,2978,41711,303855,3,4197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-12','2019-12-12',210.37,NULL,NULL,1,'2021-08-27 12:50:19','2021-08-27 12:50:19',NULL);
INSERT INTO `balance_libro` VALUES (4198,2978,41711,303855,3,4198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-12','2019-12-12',5807.76,NULL,NULL,1,'2021-08-27 12:50:19','2021-08-27 12:50:19',NULL),(4199,2978,41711,303855,3,4199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-12','2019-12-12',177.60,NULL,NULL,1,'2021-08-27 12:50:19','2021-08-27 12:50:19',NULL),(4200,2978,41711,303855,3,4200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-13','2019-12-13',841.89,NULL,NULL,1,'2021-08-27 12:50:20','2021-08-27 12:50:20',NULL),(4201,2978,41711,303855,3,4201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-16','2019-12-16',1776.24,NULL,NULL,1,'2021-08-27 12:50:20','2021-08-27 12:50:20',NULL),(4202,2978,41711,303855,3,4202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-16','2019-12-16',1813.96,NULL,NULL,1,'2021-08-27 12:50:20','2021-08-27 12:50:20',NULL),(4203,2978,41711,303855,3,4203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-17','2019-12-17',5534.03,NULL,NULL,1,'2021-08-27 12:50:20','2021-08-27 12:50:20',NULL),(4204,2978,41711,303855,3,4204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-18','2019-12-18',2275.17,NULL,NULL,1,'2021-08-27 12:50:20','2021-08-27 12:50:20',NULL),(4205,2978,41711,303855,3,4205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-18','2019-12-18',207.43,NULL,NULL,1,'2021-08-27 12:50:20','2021-08-27 12:50:20',NULL),(4206,2978,41711,303855,3,4206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-18','2019-12-18',5435.06,NULL,NULL,1,'2021-08-27 12:50:20','2021-08-27 12:50:20',NULL),(4207,2978,41711,303855,3,4207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-19','2019-12-19',345.80,NULL,NULL,1,'2021-08-27 12:50:20','2021-08-27 12:50:20',NULL),(4208,2978,41711,303855,3,4208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-19','2019-12-19',8433.86,NULL,NULL,1,'2021-08-27 12:50:20','2021-08-27 12:50:20',NULL),(4209,2978,41711,303855,3,4209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-19','2019-12-19',334.54,NULL,NULL,1,'2021-08-27 12:50:20','2021-08-27 12:50:20',NULL),(4210,2978,41711,303855,3,4210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-19','2019-12-19',545.72,NULL,NULL,1,'2021-08-27 12:50:20','2021-08-27 12:50:20',NULL),(4211,2978,41711,303855,3,4211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-19','2019-12-19',668.60,NULL,NULL,1,'2021-08-27 12:50:20','2021-08-27 12:50:20',NULL),(4212,2978,41711,303855,3,4212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-20','2019-12-20',225.34,NULL,NULL,1,'2021-08-27 12:50:20','2021-08-27 12:50:20',NULL),(4213,2978,41711,303855,3,4213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-20','2019-12-20',157.81,NULL,NULL,1,'2021-08-27 12:50:20','2021-08-27 12:50:20',NULL),(4214,2978,41711,303855,3,4214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-20','2019-12-20',117.08,NULL,NULL,1,'2021-08-27 12:50:20','2021-08-27 12:50:20',NULL),(4215,2978,41711,303855,3,4215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-20','2019-12-20',150.05,NULL,NULL,1,'2021-08-27 12:50:20','2021-08-27 12:50:20',NULL),(4216,2978,41711,303855,3,4216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-23','2019-12-23',817.37,NULL,NULL,1,'2021-08-27 12:50:20','2021-08-27 12:50:20',NULL),(4217,2978,41711,303855,3,4217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-23','2019-12-23',3624.77,NULL,NULL,1,'2021-08-27 12:50:21','2021-08-27 12:50:21',NULL),(4218,2978,41711,303855,3,4218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-23','2019-12-23',2076.26,NULL,NULL,1,'2021-08-27 12:50:21','2021-08-27 12:50:21',NULL),(4219,2978,41711,303855,3,4219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-26','2019-12-26',2247.48,NULL,NULL,1,'2021-08-27 12:50:21','2021-08-27 12:50:21',NULL),(4220,2978,41711,303855,3,4220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-26','2019-12-26',213.59,NULL,NULL,1,'2021-08-27 12:50:21','2021-08-27 12:50:21',NULL),(4221,2978,41711,303855,3,4221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-26','2019-12-26',267.47,NULL,NULL,1,'2021-08-27 12:50:21','2021-08-27 12:50:21',NULL);
INSERT INTO `balance_libro` VALUES (4222,2978,41711,303855,3,4222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-26','2019-12-26',1204.10,NULL,NULL,1,'2021-08-27 12:50:21','2021-08-27 12:50:21',NULL),(4223,2978,41711,303855,3,4223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-26','2019-12-26',374.95,NULL,NULL,1,'2021-08-27 12:50:21','2021-08-27 12:50:21',NULL),(4224,2978,41711,303855,3,4224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-26','2019-12-26',1385.79,NULL,NULL,1,'2021-08-27 12:50:21','2021-08-27 12:50:21',NULL),(4225,2978,41711,303855,3,4225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-26','2019-12-26',682.00,NULL,NULL,1,'2021-08-27 12:50:21','2021-08-27 12:50:21',NULL),(4226,2978,41711,303855,3,4226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-27','2019-12-27',1441.98,NULL,NULL,1,'2021-08-27 12:50:21','2021-08-27 12:50:21',NULL),(4227,2978,41711,303855,3,4227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-27','2019-12-27',242.23,NULL,NULL,1,'2021-08-27 12:50:21','2021-08-27 12:50:21',NULL),(4228,2978,41711,303855,3,4228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-27','2019-12-27',130.34,NULL,NULL,1,'2021-08-27 12:50:21','2021-08-27 12:50:21',NULL),(4229,2978,41711,303855,3,4229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-28','2019-12-28',1444.06,NULL,NULL,1,'2021-08-27 12:50:21','2021-08-27 12:50:21',NULL),(4230,2978,41711,303855,3,4230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-28','2019-12-28',312.52,NULL,NULL,1,'2021-08-27 12:50:21','2021-08-27 12:50:21',NULL),(4231,2978,41711,303855,3,4231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-29','2019-12-29',4726.32,NULL,NULL,1,'2021-08-27 12:50:22','2021-08-27 12:50:22',NULL),(4232,2978,41711,303855,3,4232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-30','2019-12-30',112.67,NULL,NULL,1,'2021-08-27 12:50:22','2021-08-27 12:50:22',NULL),(4233,2978,41711,303855,3,4233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-30','2019-12-30',307.44,NULL,NULL,1,'2021-08-27 12:50:22','2021-08-27 12:50:22',NULL),(4234,2978,41711,303855,3,4234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-30','2019-12-30',951.61,NULL,NULL,1,'2021-08-27 12:50:22','2021-08-27 12:50:22',NULL),(4235,2978,41711,303855,3,4235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-12-31','2019-12-31',1204.13,NULL,NULL,1,'2021-08-27 12:50:22','2021-08-27 12:50:22',NULL),(4236,2978,41711,303859,3,4236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-01','2020-01-01',1767.81,NULL,NULL,1,'2021-08-27 12:51:26','2021-08-27 12:51:26',NULL),(4237,2978,41711,303859,3,4237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-02','2020-01-02',389.91,NULL,NULL,1,'2021-08-27 12:51:26','2021-08-27 12:51:26',NULL),(4238,2978,41711,303859,3,4238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-02','2020-01-02',107.09,NULL,NULL,1,'2021-08-27 12:51:26','2021-08-27 12:51:26',NULL),(4239,2978,41711,303859,3,4239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-02','2020-01-02',901.01,NULL,NULL,1,'2021-08-27 12:51:26','2021-08-27 12:51:26',NULL),(4240,2978,41711,303859,3,4240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-02','2020-01-02',893.80,NULL,NULL,1,'2021-08-27 12:51:26','2021-08-27 12:51:26',NULL),(4241,2978,41711,303859,3,4241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-02','2020-01-02',93.31,NULL,NULL,1,'2021-08-27 12:51:26','2021-08-27 12:51:26',NULL),(4242,2978,41711,303859,3,4242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-03','2020-01-03',2180.45,NULL,NULL,1,'2021-08-27 12:51:27','2021-08-27 12:51:27',NULL),(4243,2978,41711,303859,3,4243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-03','2020-01-03',250.00,NULL,NULL,1,'2021-08-27 12:51:27','2021-08-27 12:51:27',NULL),(4244,2978,41711,303859,3,4244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-03','2020-01-03',4685.16,NULL,NULL,1,'2021-08-27 12:51:27','2021-08-27 12:51:27',NULL),(4245,2978,41711,303859,3,4245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-03','2020-01-03',360.27,NULL,NULL,1,'2021-08-27 12:51:27','2021-08-27 12:51:27',NULL);
INSERT INTO `balance_libro` VALUES (4246,2978,41711,303859,3,4246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-03','2020-01-03',393.23,NULL,NULL,1,'2021-08-27 12:51:27','2021-08-27 12:51:27',NULL),(4247,2978,41711,303859,3,4247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-03','2020-01-03',2643.85,NULL,NULL,1,'2021-08-27 12:51:27','2021-08-27 12:51:27',NULL),(4248,2978,41711,303859,3,4248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-06','2020-01-06',6634.15,NULL,NULL,1,'2021-08-27 12:51:27','2021-08-27 12:51:27',NULL),(4249,2978,41711,303859,3,4249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-06','2020-01-06',991.92,NULL,NULL,1,'2021-08-27 12:51:27','2021-08-27 12:51:27',NULL),(4250,2978,41711,303859,3,4250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-06','2020-01-06',718.16,NULL,NULL,1,'2021-08-27 12:51:27','2021-08-27 12:51:27',NULL),(4251,2978,41711,303859,3,4251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-06','2020-01-06',1322.17,NULL,NULL,1,'2021-08-27 12:51:27','2021-08-27 12:51:27',NULL),(4252,2978,41711,303859,3,4252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-07','2020-01-07',1987.26,NULL,NULL,1,'2021-08-27 12:51:27','2021-08-27 12:51:27',NULL),(4253,2978,41711,303859,3,4253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-07','2020-01-07',2242.02,NULL,NULL,1,'2021-08-27 12:51:27','2021-08-27 12:51:27',NULL),(4254,2978,41711,303859,3,4254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-07','2020-01-07',2473.52,NULL,NULL,1,'2021-08-27 12:51:27','2021-08-27 12:51:27',NULL),(4255,2978,41711,303859,3,4255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-07','2020-01-07',753.06,NULL,NULL,1,'2021-08-27 12:51:27','2021-08-27 12:51:27',NULL),(4256,2978,41711,303859,3,4256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-08','2020-01-08',328.75,NULL,NULL,1,'2021-08-27 12:51:27','2021-08-27 12:51:27',NULL),(4257,2978,41711,303859,3,4257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-08','2020-01-08',4540.68,NULL,NULL,1,'2021-08-27 12:51:27','2021-08-27 12:51:27',NULL),(4258,2978,41711,303859,3,4258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-08','2020-01-08',261.31,NULL,NULL,1,'2021-08-27 12:51:27','2021-08-27 12:51:27',NULL),(4259,2978,41711,303859,3,4259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-08','2020-01-08',717.28,NULL,NULL,1,'2021-08-27 12:51:27','2021-08-27 12:51:27',NULL),(4260,2978,41711,303859,3,4260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-08','2020-01-08',7243.58,NULL,NULL,1,'2021-08-27 12:51:27','2021-08-27 12:51:27',NULL),(4261,2978,41711,303859,3,4261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-08','2020-01-08',3660.44,NULL,NULL,1,'2021-08-27 12:51:27','2021-08-27 12:51:27',NULL),(4262,2978,41711,303859,3,4262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-08','2020-01-08',2736.59,NULL,NULL,1,'2021-08-27 12:51:27','2021-08-27 12:51:27',NULL),(4263,2978,41711,303859,3,4263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-08','2020-01-08',288.86,NULL,NULL,1,'2021-08-27 12:51:27','2021-08-27 12:51:27',NULL),(4264,2978,41711,303859,3,4264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-09','2020-01-09',292.52,NULL,NULL,1,'2021-08-27 12:51:27','2021-08-27 12:51:27',NULL),(4265,2978,41711,303859,3,4265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-09','2020-01-09',1263.82,NULL,NULL,1,'2021-08-27 12:51:27','2021-08-27 12:51:27',NULL),(4266,2978,41711,303859,3,4266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-09','2020-01-09',1574.17,NULL,NULL,1,'2021-08-27 12:51:28','2021-08-27 12:51:28',NULL),(4267,2978,41711,303859,3,4267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-09','2020-01-09',99.21,NULL,NULL,1,'2021-08-27 12:51:28','2021-08-27 12:51:28',NULL),(4268,2978,41711,303859,3,4268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-09','2020-01-09',3775.24,NULL,NULL,1,'2021-08-27 12:51:28','2021-08-27 12:51:28',NULL),(4269,2978,41711,303859,3,4269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-10','2020-01-10',464.80,NULL,NULL,1,'2021-08-27 12:51:28','2021-08-27 12:51:28',NULL);
INSERT INTO `balance_libro` VALUES (4270,2978,41711,303859,3,4270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-10','2020-01-10',267.47,NULL,NULL,1,'2021-08-27 12:51:28','2021-08-27 12:51:28',NULL),(4271,2978,41711,303859,3,4271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-10','2020-01-10',876.57,NULL,NULL,1,'2021-08-27 12:51:28','2021-08-27 12:51:28',NULL),(4272,2978,41711,303859,3,4272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-10','2020-01-10',0.01,NULL,NULL,1,'2021-08-27 12:51:28','2021-08-27 12:51:28',NULL),(4273,2978,41711,303859,3,4273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-10','2020-01-10',782.27,NULL,NULL,1,'2021-08-27 12:51:28','2021-08-27 12:51:28',NULL),(4274,2978,41711,303859,3,4274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-10','2020-01-10',3159.67,NULL,NULL,1,'2021-08-27 12:51:28','2021-08-27 12:51:28',NULL),(4275,2978,41711,303859,3,4275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-13','2020-01-13',922.07,NULL,NULL,1,'2021-08-27 12:51:28','2021-08-27 12:51:28',NULL),(4276,2978,41711,303859,3,4276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-14','2020-01-14',2734.50,NULL,NULL,1,'2021-08-27 12:51:28','2021-08-27 12:51:28',NULL),(4277,2978,41711,303859,3,4277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-14','2020-01-14',109.25,NULL,NULL,1,'2021-08-27 12:51:28','2021-08-27 12:51:28',NULL),(4278,2978,41711,303859,3,4278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-15','2020-01-15',1320.32,NULL,NULL,1,'2021-08-27 12:51:28','2021-08-27 12:51:28',NULL),(4279,2978,41711,303859,3,4279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-15','2020-01-15',225.78,NULL,NULL,1,'2021-08-27 12:51:28','2021-08-27 12:51:28',NULL),(4280,2978,41711,303859,3,4280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-15','2020-01-15',926.96,NULL,NULL,1,'2021-08-27 12:51:28','2021-08-27 12:51:28',NULL),(4281,2978,41711,303859,3,4281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-16','2020-01-16',336.54,NULL,NULL,1,'2021-08-27 12:51:28','2021-08-27 12:51:28',NULL),(4282,2978,41711,303859,3,4282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-16','2020-01-16',312.38,NULL,NULL,1,'2021-08-27 12:51:28','2021-08-27 12:51:28',NULL),(4283,2978,41711,303859,3,4283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-16','2020-01-16',121.45,NULL,NULL,1,'2021-08-27 12:51:28','2021-08-27 12:51:28',NULL),(4284,2978,41711,303859,3,4284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-16','2020-01-16',1830.46,NULL,NULL,1,'2021-08-27 12:51:28','2021-08-27 12:51:28',NULL),(4285,2978,41711,303859,3,4285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-16','2020-01-16',206.52,NULL,NULL,1,'2021-08-27 12:51:28','2021-08-27 12:51:28',NULL),(4286,2978,41711,303859,3,4286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-17','2020-01-17',774.07,NULL,NULL,1,'2021-08-27 12:51:28','2021-08-27 12:51:28',NULL),(4287,2978,41711,303859,3,4287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-17','2020-01-17',267.84,NULL,NULL,1,'2021-08-27 12:51:28','2021-08-27 12:51:28',NULL),(4288,2978,41711,303859,3,4288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-17','2020-01-17',1978.77,NULL,NULL,1,'2021-08-27 12:51:29','2021-08-27 12:51:29',NULL),(4289,2978,41711,303859,3,4289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-17','2020-01-17',345.80,NULL,NULL,1,'2021-08-27 12:51:29','2021-08-27 12:51:29',NULL),(4290,2978,41711,303859,3,4290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-20','2020-01-20',708.52,NULL,NULL,1,'2021-08-27 12:51:29','2021-08-27 12:51:29',NULL),(4291,2978,41711,303859,3,4291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-20','2020-01-20',3231.72,NULL,NULL,1,'2021-08-27 12:51:29','2021-08-27 12:51:29',NULL),(4292,2978,41711,303859,3,4292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-20','2020-01-20',77.92,NULL,NULL,1,'2021-08-27 12:51:29','2021-08-27 12:51:29',NULL),(4293,2978,41711,303859,3,4293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-20','2020-01-20',7867.57,NULL,NULL,1,'2021-08-27 12:51:29','2021-08-27 12:51:29',NULL);
INSERT INTO `balance_libro` VALUES (4294,2978,41711,303859,3,4294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-20','2020-01-20',98.64,NULL,NULL,1,'2021-08-27 12:51:29','2021-08-27 12:51:29',NULL),(4295,2978,41711,303859,3,4295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-20','2020-01-20',573.10,NULL,NULL,1,'2021-08-27 12:51:29','2021-08-27 12:51:29',NULL),(4296,2978,41711,303859,3,4296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-21','2020-01-21',268.55,NULL,NULL,1,'2021-08-27 12:51:29','2021-08-27 12:51:29',NULL),(4297,2978,41711,303859,3,4297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-21','2020-01-21',771.69,NULL,NULL,1,'2021-08-27 12:51:29','2021-08-27 12:51:29',NULL),(4298,2978,41711,303859,3,4298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-21','2020-01-21',905.82,NULL,NULL,1,'2021-08-27 12:51:29','2021-08-27 12:51:29',NULL),(4299,2978,41711,303859,3,4299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-22','2020-01-22',3215.76,NULL,NULL,1,'2021-08-27 12:51:29','2021-08-27 12:51:29',NULL),(4300,2978,41711,303859,3,4300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-23','2020-01-23',1054.31,NULL,NULL,1,'2021-08-27 12:51:29','2021-08-27 12:51:29',NULL),(4301,2978,41711,303859,3,4301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-23','2020-01-23',394.49,NULL,NULL,1,'2021-08-27 12:51:29','2021-08-27 12:51:29',NULL),(4302,2978,41711,303859,3,4302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-23','2020-01-23',274.89,NULL,NULL,1,'2021-08-27 12:51:29','2021-08-27 12:51:29',NULL),(4303,2978,41711,303859,3,4303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-23','2020-01-23',722.48,NULL,NULL,1,'2021-08-27 12:51:29','2021-08-27 12:51:29',NULL),(4304,2978,41711,303859,3,4304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-23','2020-01-23',210.48,NULL,NULL,1,'2021-08-27 12:51:29','2021-08-27 12:51:29',NULL),(4305,2978,41711,303859,3,4305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-23','2020-01-23',1561.92,NULL,NULL,1,'2021-08-27 12:51:29','2021-08-27 12:51:29',NULL),(4306,2978,41711,303859,3,4306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-24','2020-01-24',1975.96,NULL,NULL,1,'2021-08-27 12:51:29','2021-08-27 12:51:29',NULL),(4307,2978,41711,303859,3,4307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-24','2020-01-24',1540.51,NULL,NULL,1,'2021-08-27 12:51:29','2021-08-27 12:51:29',NULL),(4308,2978,41711,303859,3,4308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-24','2020-01-24',1130.65,NULL,NULL,1,'2021-08-27 12:51:29','2021-08-27 12:51:29',NULL),(4309,2978,41711,303859,3,4309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-25','2020-01-25',1921.40,NULL,NULL,1,'2021-08-27 12:51:29','2021-08-27 12:51:29',NULL),(4310,2978,41711,303859,3,4310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-25','2020-01-25',193.76,NULL,NULL,1,'2021-08-27 12:51:29','2021-08-27 12:51:29',NULL),(4311,2978,41711,303859,3,4311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-26','2020-01-26',91.79,NULL,NULL,1,'2021-08-27 12:51:29','2021-08-27 12:51:29',NULL),(4312,2978,41711,303859,3,4312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-26','2020-01-26',877.16,NULL,NULL,1,'2021-08-27 12:51:30','2021-08-27 12:51:30',NULL),(4313,2978,41711,303859,3,4313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-26','2020-01-26',1035.20,NULL,NULL,1,'2021-08-27 12:51:30','2021-08-27 12:51:30',NULL),(4314,2978,41711,303859,3,4314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-26','2020-01-26',462.32,NULL,NULL,1,'2021-08-27 12:51:30','2021-08-27 12:51:30',NULL),(4315,2978,41711,303859,3,4315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-26','2020-01-26',977.88,NULL,NULL,1,'2021-08-27 12:51:30','2021-08-27 12:51:30',NULL),(4316,2978,41711,303859,3,4316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-27','2020-01-27',1002.51,NULL,NULL,1,'2021-08-27 12:51:30','2021-08-27 12:51:30',NULL),(4317,2978,41711,303859,3,4317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-27','2020-01-27',243.21,NULL,NULL,1,'2021-08-27 12:51:30','2021-08-27 12:51:30',NULL);
INSERT INTO `balance_libro` VALUES (4318,2978,41711,303859,3,4318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-27','2020-01-27',58.07,NULL,NULL,1,'2021-08-27 12:51:30','2021-08-27 12:51:30',NULL),(4319,2978,41711,303859,3,4319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-27','2020-01-27',207.88,NULL,NULL,1,'2021-08-27 12:51:30','2021-08-27 12:51:30',NULL),(4320,2978,41711,303859,3,4320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-28','2020-01-28',927.32,NULL,NULL,1,'2021-08-27 12:51:30','2021-08-27 12:51:30',NULL),(4321,2978,41711,303859,3,4321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-28','2020-01-28',507.61,NULL,NULL,1,'2021-08-27 12:51:30','2021-08-27 12:51:30',NULL),(4322,2978,41711,303859,3,4322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-28','2020-01-28',457.73,NULL,NULL,1,'2021-08-27 12:51:30','2021-08-27 12:51:30',NULL),(4323,2978,41711,303859,3,4323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-28','2020-01-28',482.18,NULL,NULL,1,'2021-08-27 12:51:30','2021-08-27 12:51:30',NULL),(4324,2978,41711,303859,3,4324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-28','2020-01-28',910.10,NULL,NULL,1,'2021-08-27 12:51:30','2021-08-27 12:51:30',NULL),(4325,2978,41711,303859,3,4325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-29','2020-01-29',2138.34,NULL,NULL,1,'2021-08-27 12:51:30','2021-08-27 12:51:30',NULL),(4326,2978,41711,303859,3,4326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-29','2020-01-29',744.91,NULL,NULL,1,'2021-08-27 12:51:30','2021-08-27 12:51:30',NULL),(4327,2978,41711,303859,3,4327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-30','2020-01-30',585.99,NULL,NULL,1,'2021-08-27 12:51:30','2021-08-27 12:51:30',NULL),(4328,2978,41711,303859,3,4328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-30','2020-01-30',158.65,NULL,NULL,1,'2021-08-27 12:51:30','2021-08-27 12:51:30',NULL),(4329,2978,41711,303859,3,4329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-30','2020-01-30',382.50,NULL,NULL,1,'2021-08-27 12:51:30','2021-08-27 12:51:30',NULL),(4330,2978,41711,303859,3,4330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-30','2020-01-30',1892.72,NULL,NULL,1,'2021-08-27 12:51:30','2021-08-27 12:51:30',NULL),(4331,2978,41711,303859,3,4331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',635.71,NULL,NULL,1,'2021-08-27 12:51:30','2021-08-27 12:51:30',NULL),(4332,2978,41711,303859,3,4332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',747.52,NULL,NULL,1,'2021-08-27 12:51:31','2021-08-27 12:51:31',NULL),(4333,2978,41711,303859,3,4333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',712.66,NULL,NULL,1,'2021-08-27 12:51:31','2021-08-27 12:51:31',NULL),(4334,2978,41711,303859,3,4334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',491.74,NULL,NULL,1,'2021-08-27 12:51:31','2021-08-27 12:51:31',NULL),(4335,2978,41711,303859,3,4335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',1162.56,NULL,NULL,1,'2021-08-27 12:51:31','2021-08-27 12:51:31',NULL),(4336,2978,41711,303859,3,4336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',268.89,NULL,NULL,1,'2021-08-27 12:51:31','2021-08-27 12:51:31',NULL),(4337,2978,41711,303859,3,4337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',966.07,NULL,NULL,1,'2021-08-27 12:51:31','2021-08-27 12:51:31',NULL),(4338,2978,41711,303859,3,4338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-01-31','2020-01-31',1519.05,NULL,NULL,1,'2021-08-27 12:51:31','2021-08-27 12:51:31',NULL),(4552,2978,41711,303861,3,4552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-01','2020-03-01',2119.92,NULL,NULL,1,'2021-08-27 12:59:25','2021-08-27 12:59:25',NULL),(4553,2978,41711,303861,3,4553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-03','2020-03-03',2643.85,NULL,NULL,1,'2021-08-27 12:59:25','2021-08-27 12:59:25',NULL),(4554,2978,41711,303861,3,4554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-05','2020-03-05',0.09,NULL,NULL,1,'2021-08-27 12:59:25','2021-08-27 12:59:25',NULL);
INSERT INTO `balance_libro` VALUES (4555,2978,41711,303861,3,4555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-06','2020-03-06',250.00,NULL,NULL,1,'2021-08-27 12:59:25','2021-08-27 12:59:25',NULL),(4556,2978,41711,303861,3,4556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-09','2020-03-09',3094.45,NULL,NULL,1,'2021-08-27 12:59:25','2021-08-27 12:59:25',NULL),(4557,2978,41711,303861,3,4557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-09','2020-03-09',13120.60,NULL,NULL,1,'2021-08-27 12:59:25','2021-08-27 12:59:25',NULL),(4558,2978,41711,303861,3,4558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-09','2020-03-09',518.81,NULL,NULL,1,'2021-08-27 12:59:25','2021-08-27 12:59:25',NULL),(4559,2978,41711,303861,3,4559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-10','2020-03-10',3252.01,NULL,NULL,1,'2021-08-27 12:59:25','2021-08-27 12:59:25',NULL),(4560,2978,41711,303861,3,4560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-10','2020-03-10',760.33,NULL,NULL,1,'2021-08-27 12:59:25','2021-08-27 12:59:25',NULL),(4561,2978,41711,303861,3,4561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-10','2020-03-10',1167.24,NULL,NULL,1,'2021-08-27 12:59:25','2021-08-27 12:59:25',NULL),(4562,2978,41711,303861,3,4562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-11','2020-03-11',2578.20,NULL,NULL,1,'2021-08-27 12:59:25','2021-08-27 12:59:25',NULL),(4563,2978,41711,303861,3,4563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-11','2020-03-11',222.45,NULL,NULL,1,'2021-08-27 12:59:25','2021-08-27 12:59:25',NULL),(4564,2978,41711,303861,3,4564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-11','2020-03-11',303.07,NULL,NULL,1,'2021-08-27 12:59:25','2021-08-27 12:59:25',NULL),(4565,2978,41711,303861,3,4565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-11','2020-03-11',592.58,NULL,NULL,1,'2021-08-27 12:59:26','2021-08-27 12:59:26',NULL),(4566,2978,41711,303861,3,4566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-11','2020-03-11',739.13,NULL,NULL,1,'2021-08-27 12:59:26','2021-08-27 12:59:26',NULL),(4567,2978,41711,303861,3,4567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-12','2020-03-12',403.40,NULL,NULL,1,'2021-08-27 12:59:26','2021-08-27 12:59:26',NULL),(4568,2978,41711,303861,3,4568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-12','2020-03-12',744.45,NULL,NULL,1,'2021-08-27 12:59:26','2021-08-27 12:59:26',NULL),(4569,2978,41711,303861,3,4569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-12','2020-03-12',592.87,NULL,NULL,1,'2021-08-27 12:59:26','2021-08-27 12:59:26',NULL),(4570,2978,41711,303861,3,4570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-12','2020-03-12',349.26,NULL,NULL,1,'2021-08-27 12:59:26','2021-08-27 12:59:26',NULL),(4571,2978,41711,303861,3,4571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-12','2020-03-12',151.68,NULL,NULL,1,'2021-08-27 12:59:26','2021-08-27 12:59:26',NULL),(4572,2978,41711,303861,3,4572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-12','2020-03-12',349.26,NULL,NULL,1,'2021-08-27 12:59:26','2021-08-27 12:59:26',NULL),(4573,2978,41711,303861,3,4573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-12','2020-03-12',109.25,NULL,NULL,1,'2021-08-27 12:59:26','2021-08-27 12:59:26',NULL),(4574,2978,41711,303861,3,4574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-13','2020-03-13',1861.44,NULL,NULL,1,'2021-08-27 12:59:26','2021-08-27 12:59:26',NULL),(4575,2978,41711,303861,3,4575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-13','2020-03-13',2083.66,NULL,NULL,1,'2021-08-27 12:59:26','2021-08-27 12:59:26',NULL),(4576,2978,41711,303861,3,4576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-13','2020-03-13',412.89,NULL,NULL,1,'2021-08-27 12:59:26','2021-08-27 12:59:26',NULL),(4577,2978,41711,303861,3,4577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-13','2020-03-13',4050.28,NULL,NULL,1,'2021-08-27 12:59:26','2021-08-27 12:59:26',NULL),(4578,2978,41711,303861,3,4578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-16','2020-03-16',1490.94,NULL,NULL,1,'2021-08-27 12:59:26','2021-08-27 12:59:26',NULL);
INSERT INTO `balance_libro` VALUES (4579,2978,41711,303861,3,4579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-16','2020-03-16',352.59,NULL,NULL,1,'2021-08-27 12:59:26','2021-08-27 12:59:26',NULL),(4580,2978,41711,303861,3,4580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-16','2020-03-16',160.39,NULL,NULL,1,'2021-08-27 12:59:26','2021-08-27 12:59:26',NULL),(4581,2978,41711,303861,3,4581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-16','2020-03-16',330.27,NULL,NULL,1,'2021-08-27 12:59:26','2021-08-27 12:59:26',NULL),(4582,2978,41711,303861,3,4582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-16','2020-03-16',342.56,NULL,NULL,1,'2021-08-27 12:59:26','2021-08-27 12:59:26',NULL),(4583,2978,41711,303861,3,4583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-16','2020-03-16',553.34,NULL,NULL,1,'2021-08-27 12:59:26','2021-08-27 12:59:26',NULL),(4584,2978,41711,303861,3,4584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-16','2020-03-16',603.80,NULL,NULL,1,'2021-08-27 12:59:27','2021-08-27 12:59:27',NULL),(4585,2978,41711,303861,3,4585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-16','2020-03-16',447.03,NULL,NULL,1,'2021-08-27 12:59:27','2021-08-27 12:59:27',NULL),(4586,2978,41711,303861,3,4586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-16','2020-03-16',91.79,NULL,NULL,1,'2021-08-27 12:59:27','2021-08-27 12:59:27',NULL),(4587,2978,41711,303861,3,4587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-17','2020-03-17',95.86,NULL,NULL,1,'2021-08-27 12:59:27','2021-08-27 12:59:27',NULL),(4588,2978,41711,303861,3,4588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-17','2020-03-17',368.43,NULL,NULL,1,'2021-08-27 12:59:27','2021-08-27 12:59:27',NULL),(4589,2978,41711,303861,3,4589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-17','2020-03-17',3553.13,NULL,NULL,1,'2021-08-27 12:59:27','2021-08-27 12:59:27',NULL),(4590,2978,41711,303861,3,4590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-17','2020-03-17',225.34,NULL,NULL,1,'2021-08-27 12:59:27','2021-08-27 12:59:27',NULL),(4591,2978,41711,303861,3,4591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-17','2020-03-17',9453.19,NULL,NULL,1,'2021-08-27 12:59:27','2021-08-27 12:59:27',NULL),(4592,2978,41711,303861,3,4592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-18','2020-03-18',285.55,NULL,NULL,1,'2021-08-27 12:59:27','2021-08-27 12:59:27',NULL),(4593,2978,41711,303861,3,4593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-18','2020-03-18',36.64,NULL,NULL,1,'2021-08-27 12:59:27','2021-08-27 12:59:27',NULL),(4594,2978,41711,303861,3,4594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-18','2020-03-18',2348.65,NULL,NULL,1,'2021-08-27 12:59:27','2021-08-27 12:59:27',NULL),(4595,2978,41711,303861,3,4595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-18','2020-03-18',88.14,NULL,NULL,1,'2021-08-27 12:59:27','2021-08-27 12:59:27',NULL),(4596,2978,41711,303861,3,4596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-18','2020-03-18',95.86,NULL,NULL,1,'2021-08-27 12:59:27','2021-08-27 12:59:27',NULL),(4597,2978,41711,303861,3,4597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-18','2020-03-18',1916.71,NULL,NULL,1,'2021-08-27 12:59:27','2021-08-27 12:59:27',NULL),(4598,2978,41711,303861,3,4598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-18','2020-03-18',291.17,NULL,NULL,1,'2021-08-27 12:59:27','2021-08-27 12:59:27',NULL),(4599,2978,41711,303861,3,4599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-18','2020-03-18',424.29,NULL,NULL,1,'2021-08-27 12:59:27','2021-08-27 12:59:27',NULL),(4600,2978,41711,303861,3,4600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-18','2020-03-18',46.12,NULL,NULL,1,'2021-08-27 12:59:27','2021-08-27 12:59:27',NULL),(4601,2978,41711,303861,3,4601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-19','2020-03-19',948.28,NULL,NULL,1,'2021-08-27 12:59:27','2021-08-27 12:59:27',NULL),(4602,2978,41711,303861,3,4602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-19','2020-03-19',307.44,NULL,NULL,1,'2021-08-27 12:59:27','2021-08-27 12:59:27',NULL);
INSERT INTO `balance_libro` VALUES (4603,2978,41711,303861,3,4603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-19','2020-03-19',95.86,NULL,NULL,1,'2021-08-27 12:59:28','2021-08-27 12:59:28',NULL),(4604,2978,41711,303861,3,4604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-19','2020-03-19',317.63,NULL,NULL,1,'2021-08-27 12:59:28','2021-08-27 12:59:28',NULL),(4605,2978,41711,303861,3,4605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-19','2020-03-19',307.44,NULL,NULL,1,'2021-08-27 12:59:28','2021-08-27 12:59:28',NULL),(4606,2978,41711,303861,3,4606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-19','2020-03-19',3772.10,NULL,NULL,1,'2021-08-27 12:59:28','2021-08-27 12:59:28',NULL),(4607,2978,41711,303861,3,4607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-19','2020-03-19',595.48,NULL,NULL,1,'2021-08-27 12:59:28','2021-08-27 12:59:28',NULL),(4608,2978,41711,303861,3,4608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-19','2020-03-19',95.86,NULL,NULL,1,'2021-08-27 12:59:28','2021-08-27 12:59:28',NULL),(4609,2978,41711,303861,3,4609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-19','2020-03-19',345.80,NULL,NULL,1,'2021-08-27 12:59:28','2021-08-27 12:59:28',NULL),(4610,2978,41711,303861,3,4610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-19','2020-03-19',740.23,NULL,NULL,1,'2021-08-27 12:59:28','2021-08-27 12:59:28',NULL),(4611,2978,41711,303861,3,4611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-19','2020-03-19',165.76,NULL,NULL,1,'2021-08-27 12:59:28','2021-08-27 12:59:28',NULL),(4612,2978,41711,303861,3,4612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-19','2020-03-19',243.83,NULL,NULL,1,'2021-08-27 12:59:28','2021-08-27 12:59:28',NULL),(4613,2978,41711,303861,3,4613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-20','2020-03-20',3209.94,NULL,NULL,1,'2021-08-27 12:59:28','2021-08-27 12:59:28',NULL),(4614,2978,41711,303861,3,4614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-20','2020-03-20',5024.19,NULL,NULL,1,'2021-08-27 12:59:28','2021-08-27 12:59:28',NULL),(4615,2978,41711,303861,3,4615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-20','2020-03-20',153.02,NULL,NULL,1,'2021-08-27 12:59:28','2021-08-27 12:59:28',NULL),(4616,2978,41711,303861,3,4616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-20','2020-03-20',3716.70,NULL,NULL,1,'2021-08-27 12:59:29','2021-08-27 12:59:29',NULL),(4617,2978,41711,303861,3,4617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-20','2020-03-20',230.13,NULL,NULL,1,'2021-08-27 12:59:29','2021-08-27 12:59:29',NULL),(4618,2978,41711,303861,3,4618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-20','2020-03-20',207.70,NULL,NULL,1,'2021-08-27 12:59:29','2021-08-27 12:59:29',NULL),(4619,2978,41711,303861,3,4619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-20','2020-03-20',109.93,NULL,NULL,1,'2021-08-27 12:59:29','2021-08-27 12:59:29',NULL),(4620,2978,41711,303861,3,4620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-22','2020-03-22',4417.94,NULL,NULL,1,'2021-08-27 12:59:29','2021-08-27 12:59:29',NULL),(4621,2978,41711,303861,3,4621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-22','2020-03-22',75.78,NULL,NULL,1,'2021-08-27 12:59:29','2021-08-27 12:59:29',NULL),(4622,2978,41711,303861,3,4622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-23','2020-03-23',3938.95,NULL,NULL,1,'2021-08-27 12:59:29','2021-08-27 12:59:29',NULL),(4623,2978,41711,303861,3,4623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-23','2020-03-23',1205.32,NULL,NULL,1,'2021-08-27 12:59:29','2021-08-27 12:59:29',NULL),(4624,2978,41711,303861,3,4624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-23','2020-03-23',205.50,NULL,NULL,1,'2021-08-27 12:59:29','2021-08-27 12:59:29',NULL),(4625,2978,41711,303861,3,4625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-23','2020-03-23',1210.21,NULL,NULL,1,'2021-08-27 12:59:29','2021-08-27 12:59:29',NULL),(4626,2978,41711,303861,3,4626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-24','2020-03-24',890.75,NULL,NULL,1,'2021-08-27 12:59:29','2021-08-27 12:59:29',NULL);
INSERT INTO `balance_libro` VALUES (4627,2978,41711,303861,3,4627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-25','2020-03-25',0.02,NULL,NULL,1,'2021-08-27 12:59:29','2021-08-27 12:59:29',NULL),(4628,2978,41711,303861,3,4628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-25','2020-03-25',1385.40,NULL,NULL,1,'2021-08-27 12:59:29','2021-08-27 12:59:29',NULL),(4629,2978,41711,303861,3,4629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-25','2020-03-25',2827.59,NULL,NULL,1,'2021-08-27 12:59:29','2021-08-27 12:59:29',NULL),(4630,2978,41711,303861,3,4630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-26','2020-03-26',1099.71,NULL,NULL,1,'2021-08-27 12:59:29','2021-08-27 12:59:29',NULL),(4631,2978,41711,303861,3,4631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-26','2020-03-26',95.86,NULL,NULL,1,'2021-08-27 12:59:30','2021-08-27 12:59:30',NULL),(4632,2978,41711,303861,3,4632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-26','2020-03-26',4082.74,NULL,NULL,1,'2021-08-27 12:59:30','2021-08-27 12:59:30',NULL),(4633,2978,41711,303861,3,4633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-26','2020-03-26',117.46,NULL,NULL,1,'2021-08-27 12:59:30','2021-08-27 12:59:30',NULL),(4634,2978,41711,303861,3,4634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-27','2020-03-27',109.25,NULL,NULL,1,'2021-08-27 12:59:30','2021-08-27 12:59:30',NULL),(4635,2978,41711,303861,3,4635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-27','2020-03-27',598.27,NULL,NULL,1,'2021-08-27 12:59:30','2021-08-27 12:59:30',NULL),(4636,2978,41711,303861,3,4636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-27','2020-03-27',890.37,NULL,NULL,1,'2021-08-27 12:59:30','2021-08-27 12:59:30',NULL),(4637,2978,41711,303861,3,4637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-27','2020-03-27',95.86,NULL,NULL,1,'2021-08-27 12:59:30','2021-08-27 12:59:30',NULL),(4638,2978,41711,303861,3,4638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-27','2020-03-27',2931.59,NULL,NULL,1,'2021-08-27 12:59:30','2021-08-27 12:59:30',NULL),(4639,2978,41711,303861,3,4639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-27','2020-03-27',4648.02,NULL,NULL,1,'2021-08-27 12:59:30','2021-08-27 12:59:30',NULL),(4640,2978,41711,303861,3,4640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-27','2020-03-27',883.05,NULL,NULL,1,'2021-08-27 12:59:30','2021-08-27 12:59:30',NULL),(4641,2978,41711,303861,3,4641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-27','2020-03-27',95.86,NULL,NULL,1,'2021-08-27 12:59:30','2021-08-27 12:59:30',NULL),(4642,2978,41711,303861,3,4642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-29','2020-03-29',828.21,NULL,NULL,1,'2021-08-27 12:59:30','2021-08-27 12:59:30',NULL),(4643,2978,41711,303861,3,4643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-30','2020-03-30',7134.40,NULL,NULL,1,'2021-08-27 12:59:30','2021-08-27 12:59:30',NULL),(4644,2978,41711,303861,3,4644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-30','2020-03-30',482.76,NULL,NULL,1,'2021-08-27 12:59:30','2021-08-27 12:59:30',NULL),(4645,2978,41711,303861,3,4645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-30','2020-03-30',132.27,NULL,NULL,1,'2021-08-27 12:59:30','2021-08-27 12:59:30',NULL),(4646,2978,41711,303861,3,4646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-30','2020-03-30',677.02,NULL,NULL,1,'2021-08-27 12:59:30','2021-08-27 12:59:30',NULL),(4647,2978,41711,303861,3,4647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-30','2020-03-30',1668.16,NULL,NULL,1,'2021-08-27 12:59:30','2021-08-27 12:59:30',NULL),(4648,2978,41711,303861,3,4648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-30','2020-03-30',7466.10,NULL,NULL,1,'2021-08-27 12:59:31','2021-08-27 12:59:31',NULL),(4649,2978,41711,303861,3,4649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',1877.70,NULL,NULL,1,'2021-08-27 12:59:31','2021-08-27 12:59:31',NULL),(4650,2978,41711,303861,3,4650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-03-31','2020-03-31',227.96,NULL,NULL,1,'2021-08-27 12:59:31','2021-08-27 12:59:31',NULL);
INSERT INTO `balance_libro` VALUES (4651,2978,41711,303862,3,4651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-01','2020-04-01',1764.86,NULL,NULL,1,'2021-08-27 13:00:13','2021-08-27 13:00:13',NULL),(4652,2978,41711,303862,3,4652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-01','2020-04-01',8949.96,NULL,NULL,1,'2021-08-27 13:00:13','2021-08-27 13:00:13',NULL),(4653,2978,41711,303862,3,4653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-01','2020-04-01',2764.49,NULL,NULL,1,'2021-08-27 13:00:13','2021-08-27 13:00:13',NULL),(4654,2978,41711,303862,3,4654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-01','2020-04-01',2242.70,NULL,NULL,1,'2021-08-27 13:00:13','2021-08-27 13:00:13',NULL),(4655,2978,41711,303862,3,4655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-01','2020-04-01',7477.08,NULL,NULL,1,'2021-08-27 13:00:13','2021-08-27 13:00:13',NULL),(4656,2978,41711,303862,3,4656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-02','2020-04-02',7116.22,NULL,NULL,1,'2021-08-27 13:00:13','2021-08-27 13:00:13',NULL),(4657,2978,41711,303862,3,4657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-02','2020-04-02',5988.82,NULL,NULL,1,'2021-08-27 13:00:13','2021-08-27 13:00:13',NULL),(4658,2978,41711,303862,3,4658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-02','2020-04-02',971.70,NULL,NULL,1,'2021-08-27 13:00:13','2021-08-27 13:00:13',NULL),(4659,2978,41711,303862,3,4659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-02','2020-04-02',1925.79,NULL,NULL,1,'2021-08-27 13:00:14','2021-08-27 13:00:14',NULL),(4660,2978,41711,303862,3,4660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-02','2020-04-02',165.61,NULL,NULL,1,'2021-08-27 13:00:14','2021-08-27 13:00:14',NULL),(4661,2978,41711,303862,3,4661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-02','2020-04-02',135.11,NULL,NULL,1,'2021-08-27 13:00:14','2021-08-27 13:00:14',NULL),(4662,2978,41711,303862,3,4662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-02','2020-04-02',2923.30,NULL,NULL,1,'2021-08-27 13:00:14','2021-08-27 13:00:14',NULL),(4663,2978,41711,303862,3,4663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-03','2020-04-03',389.78,NULL,NULL,1,'2021-08-27 13:00:14','2021-08-27 13:00:14',NULL),(4664,2978,41711,303862,3,4664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-03','2020-04-03',300.00,NULL,NULL,1,'2021-08-27 13:00:14','2021-08-27 13:00:14',NULL),(4665,2978,41711,303862,3,4665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-03','2020-04-03',6347.43,NULL,NULL,1,'2021-08-27 13:00:14','2021-08-27 13:00:14',NULL),(4666,2978,41711,303862,3,4666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-03','2020-04-03',144.51,NULL,NULL,1,'2021-08-27 13:00:14','2021-08-27 13:00:14',NULL),(4667,2978,41711,303862,3,4667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-03','2020-04-03',4558.53,NULL,NULL,1,'2021-08-27 13:00:14','2021-08-27 13:00:14',NULL),(4668,2978,41711,303862,3,4668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-03','2020-04-03',990.15,NULL,NULL,1,'2021-08-27 13:00:14','2021-08-27 13:00:14',NULL),(4669,2978,41711,303862,3,4669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-03','2020-04-03',2908.24,NULL,NULL,1,'2021-08-27 13:00:14','2021-08-27 13:00:14',NULL),(4670,2978,41711,303862,3,4670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-05','2020-04-05',2211.05,NULL,NULL,1,'2021-08-27 13:00:14','2021-08-27 13:00:14',NULL),(4671,2978,41711,303862,3,4671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-05','2020-04-05',1282.04,NULL,NULL,1,'2021-08-27 13:00:14','2021-08-27 13:00:14',NULL),(4672,2978,41711,303862,3,4672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-05','2020-04-05',294.60,NULL,NULL,1,'2021-08-27 13:00:14','2021-08-27 13:00:14',NULL),(4673,2978,41711,303862,3,4673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-05','2020-04-05',1269.51,NULL,NULL,1,'2021-08-27 13:00:14','2021-08-27 13:00:14',NULL),(4674,2978,41711,303862,3,4674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-06','2020-04-06',538.62,NULL,NULL,1,'2021-08-27 13:00:14','2021-08-27 13:00:14',NULL);
INSERT INTO `balance_libro` VALUES (4675,2978,41711,303862,3,4675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-06','2020-04-06',7361.90,NULL,NULL,1,'2021-08-27 13:00:14','2021-08-27 13:00:14',NULL),(4676,2978,41711,303862,3,4676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-06','2020-04-06',1577.24,NULL,NULL,1,'2021-08-27 13:00:14','2021-08-27 13:00:14',NULL),(4677,2978,41711,303862,3,4677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-06','2020-04-06',2007.18,NULL,NULL,1,'2021-08-27 13:00:15','2021-08-27 13:00:15',NULL),(4678,2978,41711,303862,3,4678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-06','2020-04-06',225.79,NULL,NULL,1,'2021-08-27 13:00:15','2021-08-27 13:00:15',NULL),(4679,2978,41711,303862,3,4679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-07','2020-04-07',3249.05,NULL,NULL,1,'2021-08-27 13:00:15','2021-08-27 13:00:15',NULL),(4680,2978,41711,303862,3,4680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-07','2020-04-07',1200.14,NULL,NULL,1,'2021-08-27 13:00:15','2021-08-27 13:00:15',NULL),(4681,2978,41711,303862,3,4681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-07','2020-04-07',2139.81,NULL,NULL,1,'2021-08-27 13:00:15','2021-08-27 13:00:15',NULL),(4682,2978,41711,303862,3,4682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-07','2020-04-07',171.47,NULL,NULL,1,'2021-08-27 13:00:15','2021-08-27 13:00:15',NULL),(4683,2978,41711,303862,3,4683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-07','2020-04-07',1933.26,NULL,NULL,1,'2021-08-27 13:00:15','2021-08-27 13:00:15',NULL),(4684,2978,41711,303862,3,4684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-07','2020-04-07',4120.50,NULL,NULL,1,'2021-08-27 13:00:15','2021-08-27 13:00:15',NULL),(4685,2978,41711,303862,3,4685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-07','2020-04-07',4628.12,NULL,NULL,1,'2021-08-27 13:00:15','2021-08-27 13:00:15',NULL),(4686,2978,41711,303862,3,4686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-07','2020-04-07',134.01,NULL,NULL,1,'2021-08-27 13:00:15','2021-08-27 13:00:15',NULL),(4687,2978,41711,303862,3,4687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-07','2020-04-07',134.01,NULL,NULL,1,'2021-08-27 13:00:15','2021-08-27 13:00:15',NULL),(4688,2978,41711,303862,3,4688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-08','2020-04-08',1644.02,NULL,NULL,1,'2021-08-27 13:00:15','2021-08-27 13:00:15',NULL),(4689,2978,41711,303862,3,4689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-08','2020-04-08',897.74,NULL,NULL,1,'2021-08-27 13:00:15','2021-08-27 13:00:15',NULL),(4690,2978,41711,303862,3,4690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-08','2020-04-08',5346.57,NULL,NULL,1,'2021-08-27 13:00:15','2021-08-27 13:00:15',NULL),(4691,2978,41711,303862,3,4691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-08','2020-04-08',229.87,NULL,NULL,1,'2021-08-27 13:00:15','2021-08-27 13:00:15',NULL),(4692,2978,41711,303862,3,4692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-08','2020-04-08',2370.85,NULL,NULL,1,'2021-08-27 13:00:15','2021-08-27 13:00:15',NULL),(4693,2978,41711,303862,3,4693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-08','2020-04-08',1951.16,NULL,NULL,1,'2021-08-27 13:00:15','2021-08-27 13:00:15',NULL),(4694,2978,41711,303862,3,4694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-08','2020-04-08',394.35,NULL,NULL,1,'2021-08-27 13:00:15','2021-08-27 13:00:15',NULL),(4695,2978,41711,303862,3,4695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-08','2020-04-08',479.72,NULL,NULL,1,'2021-08-27 13:00:15','2021-08-27 13:00:15',NULL),(4696,2978,41711,303862,3,4696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-08','2020-04-08',5310.49,NULL,NULL,1,'2021-08-27 13:00:15','2021-08-27 13:00:15',NULL),(4697,2978,41711,303862,3,4697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-08','2020-04-08',174.89,NULL,NULL,1,'2021-08-27 13:00:15','2021-08-27 13:00:15',NULL),(4698,2978,41711,303862,3,4698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-08','2020-04-08',396.57,NULL,NULL,1,'2021-08-27 13:00:16','2021-08-27 13:00:16',NULL);
INSERT INTO `balance_libro` VALUES (4699,2978,41711,303862,3,4699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-08','2020-04-08',229.87,NULL,NULL,1,'2021-08-27 13:00:16','2021-08-27 13:00:16',NULL),(4700,2978,41711,303862,3,4700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-09','2020-04-09',3267.87,NULL,NULL,1,'2021-08-27 13:00:16','2021-08-27 13:00:16',NULL),(4701,2978,41711,303862,3,4701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-09','2020-04-09',360.27,NULL,NULL,1,'2021-08-27 13:00:16','2021-08-27 13:00:16',NULL),(4702,2978,41711,303862,3,4702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-09','2020-04-09',645.06,NULL,NULL,1,'2021-08-27 13:00:16','2021-08-27 13:00:16',NULL),(4703,2978,41711,303862,3,4703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-11','2020-04-11',3540.78,NULL,NULL,1,'2021-08-27 13:00:16','2021-08-27 13:00:16',NULL),(4704,2978,41711,303862,3,4704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-11','2020-04-11',306.17,NULL,NULL,1,'2021-08-27 13:00:16','2021-08-27 13:00:16',NULL),(4705,2978,41711,303862,3,4705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-11','2020-04-11',7210.07,NULL,NULL,1,'2021-08-27 13:00:16','2021-08-27 13:00:16',NULL),(4706,2978,41711,303862,3,4706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-13','2020-04-13',3480.69,NULL,NULL,1,'2021-08-27 13:00:16','2021-08-27 13:00:16',NULL),(4707,2978,41711,303862,3,4707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-13','2020-04-13',1701.22,NULL,NULL,1,'2021-08-27 13:00:16','2021-08-27 13:00:16',NULL),(4708,2978,41711,303862,3,4708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-13','2020-04-13',479.30,NULL,NULL,1,'2021-08-27 13:00:16','2021-08-27 13:00:16',NULL),(4709,2978,41711,303862,3,4709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-13','2020-04-13',5856.49,NULL,NULL,1,'2021-08-27 13:00:16','2021-08-27 13:00:16',NULL),(4710,2978,41711,303862,3,4710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-13','2020-04-13',1857.67,NULL,NULL,1,'2021-08-27 13:00:16','2021-08-27 13:00:16',NULL),(4711,2978,41711,303862,3,4711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-13','2020-04-13',1312.95,NULL,NULL,1,'2021-08-27 13:00:16','2021-08-27 13:00:16',NULL),(4712,2978,41711,303862,3,4712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-13','2020-04-13',8919.77,NULL,NULL,1,'2021-08-27 13:00:16','2021-08-27 13:00:16',NULL),(4713,2978,41711,303862,3,4713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-13','2020-04-13',352.59,NULL,NULL,1,'2021-08-27 13:00:16','2021-08-27 13:00:16',NULL),(4714,2978,41711,303862,3,4714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-13','2020-04-13',4266.05,NULL,NULL,1,'2021-08-27 13:00:16','2021-08-27 13:00:16',NULL),(4715,2978,41711,303862,3,4715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-14','2020-04-14',352.59,NULL,NULL,1,'2021-08-27 13:00:16','2021-08-27 13:00:16',NULL),(4716,2978,41711,303862,3,4716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-14','2020-04-14',6284.25,NULL,NULL,1,'2021-08-27 13:00:16','2021-08-27 13:00:16',NULL),(4717,2978,41711,303862,3,4717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-14','2020-04-14',1160.30,NULL,NULL,1,'2021-08-27 13:00:16','2021-08-27 13:00:16',NULL),(4718,2978,41711,303862,3,4718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-15','2020-04-15',583.80,NULL,NULL,1,'2021-08-27 13:00:16','2021-08-27 13:00:16',NULL),(4719,2978,41711,303862,3,4719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-15','2020-04-15',297.09,NULL,NULL,1,'2021-08-27 13:00:17','2021-08-27 13:00:17',NULL),(4720,2978,41711,303862,3,4720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-15','2020-04-15',248.01,NULL,NULL,1,'2021-08-27 13:00:17','2021-08-27 13:00:17',NULL),(4721,2978,41711,303862,3,4721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-15','2020-04-15',1855.85,NULL,NULL,1,'2021-08-27 13:00:17','2021-08-27 13:00:17',NULL),(4722,2978,41711,303862,3,4722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-15','2020-04-15',0.07,NULL,NULL,1,'2021-08-27 13:00:17','2021-08-27 13:00:17',NULL);
INSERT INTO `balance_libro` VALUES (4723,2978,41711,303862,3,4723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-16','2020-04-16',3438.87,NULL,NULL,1,'2021-08-27 13:00:17','2021-08-27 13:00:17',NULL),(4724,2978,41711,303862,3,4724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-16','2020-04-16',11612.80,NULL,NULL,1,'2021-08-27 13:00:17','2021-08-27 13:00:17',NULL),(4725,2978,41711,303862,3,4725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-16','2020-04-16',1324.82,NULL,NULL,1,'2021-08-27 13:00:17','2021-08-27 13:00:17',NULL),(4726,2978,41711,303862,3,4726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-16','2020-04-16',0.02,NULL,NULL,1,'2021-08-27 13:00:17','2021-08-27 13:00:17',NULL),(4727,2978,41711,303862,3,4727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-17','2020-04-17',3597.37,NULL,NULL,1,'2021-08-27 13:00:17','2021-08-27 13:00:17',NULL),(4728,2978,41711,303862,3,4728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-17','2020-04-17',5344.27,NULL,NULL,1,'2021-08-27 13:00:17','2021-08-27 13:00:17',NULL),(4729,2978,41711,303862,3,4729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-17','2020-04-17',632.26,NULL,NULL,1,'2021-08-27 13:00:17','2021-08-27 13:00:17',NULL),(4730,2978,41711,303862,3,4730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-17','2020-04-17',1357.96,NULL,NULL,1,'2021-08-27 13:00:17','2021-08-27 13:00:17',NULL),(4731,2978,41711,303862,3,4731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-17','2020-04-17',697.19,NULL,NULL,1,'2021-08-27 13:00:17','2021-08-27 13:00:17',NULL),(4732,2978,41711,303862,3,4732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-17','2020-04-17',1393.05,NULL,NULL,1,'2021-08-27 13:00:17','2021-08-27 13:00:17',NULL),(4733,2978,41711,303862,3,4733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-17','2020-04-17',767.56,NULL,NULL,1,'2021-08-27 13:00:17','2021-08-27 13:00:17',NULL),(4734,2978,41711,303862,3,4734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-17','2020-04-17',504.96,NULL,NULL,1,'2021-08-27 13:00:17','2021-08-27 13:00:17',NULL),(4735,2978,41711,303862,3,4735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-17','2020-04-17',139.40,NULL,NULL,1,'2021-08-27 13:00:17','2021-08-27 13:00:17',NULL),(4736,2978,41711,303862,3,4736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-19','2020-04-19',8283.94,NULL,NULL,1,'2021-08-27 13:00:17','2021-08-27 13:00:17',NULL),(4737,2978,41711,303862,3,4737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-20','2020-04-20',2939.26,NULL,NULL,1,'2021-08-27 13:00:17','2021-08-27 13:00:17',NULL),(4738,2978,41711,303862,3,4738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-20','2020-04-20',8823.57,NULL,NULL,1,'2021-08-27 13:00:17','2021-08-27 13:00:17',NULL),(4739,2978,41711,303862,3,4739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-20','2020-04-20',19546.20,NULL,NULL,1,'2021-08-27 13:00:17','2021-08-27 13:00:17',NULL),(4740,2978,41711,303862,3,4740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-20','2020-04-20',216.05,NULL,NULL,1,'2021-08-27 13:00:17','2021-08-27 13:00:17',NULL),(4741,2978,41711,303862,3,4741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-20','2020-04-20',289.41,NULL,NULL,1,'2021-08-27 13:00:17','2021-08-27 13:00:17',NULL),(4742,2978,41711,303862,3,4742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-20','2020-04-20',5921.73,NULL,NULL,1,'2021-08-27 13:00:18','2021-08-27 13:00:18',NULL),(4743,2978,41711,303862,3,4743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-20','2020-04-20',6959.44,NULL,NULL,1,'2021-08-27 13:00:18','2021-08-27 13:00:18',NULL),(4744,2978,41711,303862,3,4744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-20','2020-04-20',199.18,NULL,NULL,1,'2021-08-27 13:00:18','2021-08-27 13:00:18',NULL),(4745,2978,41711,303862,3,4745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-21','2020-04-21',1125.93,NULL,NULL,1,'2021-08-27 13:00:18','2021-08-27 13:00:18',NULL),(4746,2978,41711,303862,3,4746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-21','2020-04-21',5117.48,NULL,NULL,1,'2021-08-27 13:00:18','2021-08-27 13:00:18',NULL);
INSERT INTO `balance_libro` VALUES (4747,2978,41711,303862,3,4747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-21','2020-04-21',1801.94,NULL,NULL,1,'2021-08-27 13:00:18','2021-08-27 13:00:18',NULL),(4748,2978,41711,303862,3,4748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-21','2020-04-21',434.24,NULL,NULL,1,'2021-08-27 13:00:18','2021-08-27 13:00:18',NULL),(4749,2978,41711,303862,3,4749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-21','2020-04-21',1946.64,NULL,NULL,1,'2021-08-27 13:00:18','2021-08-27 13:00:18',NULL),(4750,2978,41711,303862,3,4750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-21','2020-04-21',2212.09,NULL,NULL,1,'2021-08-27 13:00:18','2021-08-27 13:00:18',NULL),(4751,2978,41711,303862,3,4751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-22','2020-04-22',2404.98,NULL,NULL,1,'2021-08-27 13:00:18','2021-08-27 13:00:18',NULL),(4752,2978,41711,303862,3,4752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-22','2020-04-22',57.53,NULL,NULL,1,'2021-08-27 13:00:18','2021-08-27 13:00:18',NULL),(4753,2978,41711,303862,3,4753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-22','2020-04-22',860.85,NULL,NULL,1,'2021-08-27 13:00:18','2021-08-27 13:00:18',NULL),(4754,2978,41711,303862,3,4754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-22','2020-04-22',577.98,NULL,NULL,1,'2021-08-27 13:00:18','2021-08-27 13:00:18',NULL),(4755,2978,41711,303862,3,4755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-22','2020-04-22',1475.05,NULL,NULL,1,'2021-08-27 13:00:18','2021-08-27 13:00:18',NULL),(4756,2978,41711,303862,3,4756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-22','2020-04-22',1877.26,NULL,NULL,1,'2021-08-27 13:00:18','2021-08-27 13:00:18',NULL),(4757,2978,41711,303862,3,4757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-22','2020-04-22',1857.67,NULL,NULL,1,'2021-08-27 13:00:18','2021-08-27 13:00:18',NULL),(4758,2978,41711,303862,3,4758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-23','2020-04-23',1159.68,NULL,NULL,1,'2021-08-27 13:00:18','2021-08-27 13:00:18',NULL),(4759,2978,41711,303862,3,4759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-23','2020-04-23',104.06,NULL,NULL,1,'2021-08-27 13:00:18','2021-08-27 13:00:18',NULL),(4760,2978,41711,303862,3,4760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-23','2020-04-23',2681.58,NULL,NULL,1,'2021-08-27 13:00:18','2021-08-27 13:00:18',NULL),(4761,2978,41711,303862,3,4761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-23','2020-04-23',6504.04,NULL,NULL,1,'2021-08-27 13:00:18','2021-08-27 13:00:18',NULL),(4762,2978,41711,303862,3,4762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-23','2020-04-23',843.06,NULL,NULL,1,'2021-08-27 13:00:18','2021-08-27 13:00:18',NULL),(4763,2978,41711,303862,3,4763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-23','2020-04-23',340.92,NULL,NULL,1,'2021-08-27 13:00:18','2021-08-27 13:00:18',NULL),(4764,2978,41711,303862,3,4764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-23','2020-04-23',6063.47,NULL,NULL,1,'2021-08-27 13:00:18','2021-08-27 13:00:18',NULL),(4765,2978,41711,303862,3,4765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-24','2020-04-24',7448.01,NULL,NULL,1,'2021-08-27 13:00:19','2021-08-27 13:00:19',NULL),(4766,2978,41711,303862,3,4766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-24','2020-04-24',153.04,NULL,NULL,1,'2021-08-27 13:00:19','2021-08-27 13:00:19',NULL),(4767,2978,41711,303862,3,4767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-24','2020-04-24',345.80,NULL,NULL,1,'2021-08-27 13:00:19','2021-08-27 13:00:19',NULL),(4768,2978,41711,303862,3,4768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-24','2020-04-24',1030.64,NULL,NULL,1,'2021-08-27 13:00:19','2021-08-27 13:00:19',NULL),(4769,2978,41711,303862,3,4769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-24','2020-04-24',3066.61,NULL,NULL,1,'2021-08-27 13:00:19','2021-08-27 13:00:19',NULL),(4770,2978,41711,303862,3,4770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-24','2020-04-24',1432.74,NULL,NULL,1,'2021-08-27 13:00:19','2021-08-27 13:00:19',NULL);
INSERT INTO `balance_libro` VALUES (4771,2978,41711,303862,3,4771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-26','2020-04-26',749.04,NULL,NULL,1,'2021-08-27 13:00:19','2021-08-27 13:00:19',NULL),(4772,2978,41711,303862,3,4772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-26','2020-04-26',2319.65,NULL,NULL,1,'2021-08-27 13:00:19','2021-08-27 13:00:19',NULL),(4773,2978,41711,303862,3,4773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-26','2020-04-26',146.90,NULL,NULL,1,'2021-08-27 13:00:19','2021-08-27 13:00:19',NULL),(4774,2978,41711,303862,3,4774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-27','2020-04-27',709.39,NULL,NULL,1,'2021-08-27 13:00:19','2021-08-27 13:00:19',NULL),(4775,2978,41711,303862,3,4775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-27','2020-04-27',165.76,NULL,NULL,1,'2021-08-27 13:00:19','2021-08-27 13:00:19',NULL),(4776,2978,41711,303862,3,4776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-27','2020-04-27',428.48,NULL,NULL,1,'2021-08-27 13:00:19','2021-08-27 13:00:19',NULL),(4777,2978,41711,303862,3,4777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-27','2020-04-27',1615.80,NULL,NULL,1,'2021-08-27 13:00:19','2021-08-27 13:00:19',NULL),(4778,2978,41711,303862,3,4778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-27','2020-04-27',1840.37,NULL,NULL,1,'2021-08-27 13:00:19','2021-08-27 13:00:19',NULL),(4779,2978,41711,303862,3,4779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-27','2020-04-27',373.00,NULL,NULL,1,'2021-08-27 13:00:19','2021-08-27 13:00:19',NULL),(4780,2978,41711,303862,3,4780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-27','2020-04-27',2003.88,NULL,NULL,1,'2021-08-27 13:00:19','2021-08-27 13:00:19',NULL),(4781,2978,41711,303862,3,4781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-28','2020-04-28',8336.83,NULL,NULL,1,'2021-08-27 13:00:19','2021-08-27 13:00:19',NULL),(4782,2978,41711,303862,3,4782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-28','2020-04-28',1753.39,NULL,NULL,1,'2021-08-27 13:00:19','2021-08-27 13:00:19',NULL),(4783,2978,41711,303862,3,4783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-28','2020-04-28',148.69,NULL,NULL,1,'2021-08-27 13:00:19','2021-08-27 13:00:19',NULL),(4784,2978,41711,303862,3,4784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-28','2020-04-28',285.01,NULL,NULL,1,'2021-08-27 13:00:19','2021-08-27 13:00:19',NULL),(4785,2978,41711,303862,3,4785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-28','2020-04-28',3957.71,NULL,NULL,1,'2021-08-27 13:00:19','2021-08-27 13:00:19',NULL),(4786,2978,41711,303862,3,4786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-28','2020-04-28',1562.87,NULL,NULL,1,'2021-08-27 13:00:19','2021-08-27 13:00:19',NULL),(4787,2978,41711,303862,3,4787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-28','2020-04-28',1263.11,NULL,NULL,1,'2021-08-27 13:00:19','2021-08-27 13:00:19',NULL),(4788,2978,41711,303862,3,4788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-28','2020-04-28',6785.89,NULL,NULL,1,'2021-08-27 13:00:19','2021-08-27 13:00:19',NULL),(4789,2978,41711,303862,3,4789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-28','2020-04-28',341.17,NULL,NULL,1,'2021-08-27 13:00:20','2021-08-27 13:00:20',NULL),(4790,2978,41711,303862,3,4790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-28','2020-04-28',5977.08,NULL,NULL,1,'2021-08-27 13:00:20','2021-08-27 13:00:20',NULL),(4791,2978,41711,303862,3,4791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-28','2020-04-28',3944.10,NULL,NULL,1,'2021-08-27 13:00:20','2021-08-27 13:00:20',NULL),(4792,2978,41711,303862,3,4792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-29','2020-04-29',6287.54,NULL,NULL,1,'2021-08-27 13:00:20','2021-08-27 13:00:20',NULL),(4793,2978,41711,303862,3,4793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-29','2020-04-29',1158.08,NULL,NULL,1,'2021-08-27 13:00:20','2021-08-27 13:00:20',NULL),(4794,2978,41711,303862,3,4794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',528.76,NULL,NULL,1,'2021-08-27 13:00:20','2021-08-27 13:00:20',NULL);
INSERT INTO `balance_libro` VALUES (4795,2978,41711,303862,3,4795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',632.26,NULL,NULL,1,'2021-08-27 13:00:20','2021-08-27 13:00:20',NULL),(4796,2978,41711,303862,3,4796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',825.14,NULL,NULL,1,'2021-08-27 13:00:20','2021-08-27 13:00:20',NULL),(4797,2978,41711,303862,3,4797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',757.08,NULL,NULL,1,'2021-08-27 13:00:20','2021-08-27 13:00:20',NULL),(4798,2978,41711,303862,3,4798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',25084.12,NULL,NULL,1,'2021-08-27 13:00:20','2021-08-27 13:00:20',NULL),(4799,2978,41711,303862,3,4799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',164.48,NULL,NULL,1,'2021-08-27 13:00:20','2021-08-27 13:00:20',NULL),(4800,2978,41711,303862,3,4800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',1840.80,NULL,NULL,1,'2021-08-27 13:00:20','2021-08-27 13:00:20',NULL),(4801,2978,41711,303862,3,4801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',364.90,NULL,NULL,1,'2021-08-27 13:00:20','2021-08-27 13:00:20',NULL),(4802,2978,41711,303862,3,4802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',498.20,NULL,NULL,1,'2021-08-27 13:00:20','2021-08-27 13:00:20',NULL),(4803,2978,41711,303862,3,4803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',1088.55,NULL,NULL,1,'2021-08-27 13:00:20','2021-08-27 13:00:20',NULL),(4804,2978,41711,303862,3,4804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',4250.00,NULL,NULL,1,'2021-08-27 13:00:21','2021-08-27 13:00:21',NULL),(4805,2978,41711,303862,3,4805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-04-30','2020-04-30',1500.53,NULL,NULL,1,'2021-08-27 13:00:21','2021-08-27 13:00:21',NULL),(4806,2978,41711,303863,3,4806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-01','2020-05-01',2408.72,NULL,NULL,1,'2021-08-27 13:39:40','2021-08-27 13:39:40',NULL),(4807,2978,41711,303863,3,4807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-03','2020-05-03',2468.76,NULL,NULL,1,'2021-08-27 13:39:40','2021-08-27 13:39:40',NULL),(4808,2978,41711,303863,3,4808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-04','2020-05-04',5630.99,NULL,NULL,1,'2021-08-27 13:39:40','2021-08-27 13:39:40',NULL),(4809,2978,41711,303863,3,4809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-04','2020-05-04',230.26,NULL,NULL,1,'2021-08-27 13:39:41','2021-08-27 13:39:41',NULL),(4810,2978,41711,303863,3,4810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-04','2020-05-04',464.84,NULL,NULL,1,'2021-08-27 13:39:41','2021-08-27 13:39:41',NULL),(4811,2978,41711,303863,3,4811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-04','2020-05-04',11352.79,NULL,NULL,1,'2021-08-27 13:39:41','2021-08-27 13:39:41',NULL),(4812,2978,41711,303863,3,4812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-04','2020-05-04',370.61,NULL,NULL,1,'2021-08-27 13:39:41','2021-08-27 13:39:41',NULL),(4813,2978,41711,303863,3,4813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-04','2020-05-04',2027.47,NULL,NULL,1,'2021-08-27 13:39:41','2021-08-27 13:39:41',NULL),(4814,2978,41711,303863,3,4814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-04','2020-05-04',183.57,NULL,NULL,1,'2021-08-27 13:39:41','2021-08-27 13:39:41',NULL),(4815,2978,41711,303863,3,4815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-04','2020-05-04',865.26,NULL,NULL,1,'2021-08-27 13:39:41','2021-08-27 13:39:41',NULL),(4816,2978,41711,303863,3,4816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-04','2020-05-04',447.54,NULL,NULL,1,'2021-08-27 13:39:41','2021-08-27 13:39:41',NULL),(4817,2978,41711,303863,3,4817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-04','2020-05-04',3181.94,NULL,NULL,1,'2021-08-27 13:39:41','2021-08-27 13:39:41',NULL),(4818,2978,41711,303863,3,4818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-04','2020-05-04',2908.24,NULL,NULL,1,'2021-08-27 13:39:41','2021-08-27 13:39:41',NULL);
INSERT INTO `balance_libro` VALUES (4819,2978,41711,303863,3,4819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-05','2020-05-05',162.25,NULL,NULL,1,'2021-08-27 13:39:41','2021-08-27 13:39:41',NULL),(4820,2978,41711,303863,3,4820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-05','2020-05-05',3892.15,NULL,NULL,1,'2021-08-27 13:39:41','2021-08-27 13:39:41',NULL),(4821,2978,41711,303863,3,4821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-05','2020-05-05',733.60,NULL,NULL,1,'2021-08-27 13:39:41','2021-08-27 13:39:41',NULL),(4822,2978,41711,303863,3,4822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-05','2020-05-05',7586.74,NULL,NULL,1,'2021-08-27 13:39:41','2021-08-27 13:39:41',NULL),(4823,2978,41711,303863,3,4823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-05','2020-05-05',1857.67,NULL,NULL,1,'2021-08-27 13:39:41','2021-08-27 13:39:41',NULL),(4824,2978,41711,303863,3,4824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-05','2020-05-05',357.33,NULL,NULL,1,'2021-08-27 13:39:41','2021-08-27 13:39:41',NULL),(4825,2978,41711,303863,3,4825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-05','2020-05-05',2113.29,NULL,NULL,1,'2021-08-27 13:39:41','2021-08-27 13:39:41',NULL),(4826,2978,41711,303863,3,4826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-05','2020-05-05',3162.13,NULL,NULL,1,'2021-08-27 13:39:41','2021-08-27 13:39:41',NULL),(4827,2978,41711,303863,3,4827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-05','2020-05-05',3836.57,NULL,NULL,1,'2021-08-27 13:39:41','2021-08-27 13:39:41',NULL),(4828,2978,41711,303863,3,4828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-06','2020-05-06',672.08,NULL,NULL,1,'2021-08-27 13:39:41','2021-08-27 13:39:41',NULL),(4829,2978,41711,303863,3,4829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-06','2020-05-06',11098.85,NULL,NULL,1,'2021-08-27 13:39:41','2021-08-27 13:39:41',NULL),(4830,2978,41711,303863,3,4830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-06','2020-05-06',3788.57,NULL,NULL,1,'2021-08-27 13:39:41','2021-08-27 13:39:41',NULL),(4831,2978,41711,303863,3,4831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-06','2020-05-06',262.44,NULL,NULL,1,'2021-08-27 13:39:41','2021-08-27 13:39:41',NULL),(4832,2978,41711,303863,3,4832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-06','2020-05-06',454.37,NULL,NULL,1,'2021-08-27 13:39:41','2021-08-27 13:39:41',NULL),(4833,2978,41711,303863,3,4833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-06','2020-05-06',1924.65,NULL,NULL,1,'2021-08-27 13:39:42','2021-08-27 13:39:42',NULL),(4834,2978,41711,303863,3,4834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-07','2020-05-07',2100.83,NULL,NULL,1,'2021-08-27 13:39:42','2021-08-27 13:39:42',NULL),(4835,2978,41711,303863,3,4835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-07','2020-05-07',1860.22,NULL,NULL,1,'2021-08-27 13:39:42','2021-08-27 13:39:42',NULL),(4836,2978,41711,303863,3,4836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-07','2020-05-07',3382.16,NULL,NULL,1,'2021-08-27 13:39:42','2021-08-27 13:39:42',NULL),(4837,2978,41711,303863,3,4837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-08','2020-05-08',1919.18,NULL,NULL,1,'2021-08-27 13:39:42','2021-08-27 13:39:42',NULL),(4838,2978,41711,303863,3,4838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-08','2020-05-08',1308.38,NULL,NULL,1,'2021-08-27 13:39:42','2021-08-27 13:39:42',NULL),(4839,2978,41711,303863,3,4839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-08','2020-05-08',311.93,NULL,NULL,1,'2021-08-27 13:39:42','2021-08-27 13:39:42',NULL),(4840,2978,41711,303863,3,4840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-08','2020-05-08',872.38,NULL,NULL,1,'2021-08-27 13:39:42','2021-08-27 13:39:42',NULL),(4841,2978,41711,303863,3,4841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-08','2020-05-08',646.28,NULL,NULL,1,'2021-08-27 13:39:42','2021-08-27 13:39:42',NULL),(4842,2978,41711,303863,3,4842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-08','2020-05-08',330.79,NULL,NULL,1,'2021-08-27 13:39:42','2021-08-27 13:39:42',NULL);
INSERT INTO `balance_libro` VALUES (4843,2978,41711,303863,3,4843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-08','2020-05-08',753.16,NULL,NULL,1,'2021-08-27 13:39:42','2021-08-27 13:39:42',NULL),(4844,2978,41711,303863,3,4844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-08','2020-05-08',1807.93,NULL,NULL,1,'2021-08-27 13:39:42','2021-08-27 13:39:42',NULL),(4845,2978,41711,303863,3,4845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-08','2020-05-08',300.00,NULL,NULL,1,'2021-08-27 13:39:42','2021-08-27 13:39:42',NULL),(4846,2978,41711,303863,3,4846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-10','2020-05-10',1707.45,NULL,NULL,1,'2021-08-27 13:39:42','2021-08-27 13:39:42',NULL),(4847,2978,41711,303863,3,4847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-10','2020-05-10',1180.00,NULL,NULL,1,'2021-08-27 13:39:42','2021-08-27 13:39:42',NULL),(4848,2978,41711,303863,3,4848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-11','2020-05-11',365.98,NULL,NULL,1,'2021-08-27 13:39:42','2021-08-27 13:39:42',NULL),(4849,2978,41711,303863,3,4849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-11','2020-05-11',353.50,NULL,NULL,1,'2021-08-27 13:39:42','2021-08-27 13:39:42',NULL),(4850,2978,41711,303863,3,4850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-11','2020-05-11',299.62,NULL,NULL,1,'2021-08-27 13:39:42','2021-08-27 13:39:42',NULL),(4851,2978,41711,303863,3,4851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-11','2020-05-11',3218.11,NULL,NULL,1,'2021-08-27 13:39:42','2021-08-27 13:39:42',NULL),(4852,2978,41711,303863,3,4852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-11','2020-05-11',1031.59,NULL,NULL,1,'2021-08-27 13:39:42','2021-08-27 13:39:42',NULL),(4853,2978,41711,303863,3,4853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-11','2020-05-11',1034.00,NULL,NULL,1,'2021-08-27 13:39:42','2021-08-27 13:39:42',NULL),(4854,2978,41711,303863,3,4854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-11','2020-05-11',13867.10,NULL,NULL,1,'2021-08-27 13:39:42','2021-08-27 13:39:42',NULL),(4855,2978,41711,303863,3,4855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-11','2020-05-11',1226.02,NULL,NULL,1,'2021-08-27 13:39:42','2021-08-27 13:39:42',NULL),(4856,2978,41711,303863,3,4856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-11','2020-05-11',2296.94,NULL,NULL,1,'2021-08-27 13:39:43','2021-08-27 13:39:43',NULL),(4857,2978,41711,303863,3,4857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-11','2020-05-11',437.84,NULL,NULL,1,'2021-08-27 13:39:43','2021-08-27 13:39:43',NULL),(4858,2978,41711,303863,3,4858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-11','2020-05-11',1894.26,NULL,NULL,1,'2021-08-27 13:39:43','2021-08-27 13:39:43',NULL),(4859,2978,41711,303863,3,4859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-11','2020-05-11',871.50,NULL,NULL,1,'2021-08-27 13:39:43','2021-08-27 13:39:43',NULL),(4860,2978,41711,303863,3,4860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-12','2020-05-12',1145.37,NULL,NULL,1,'2021-08-27 13:39:43','2021-08-27 13:39:43',NULL),(4861,2978,41711,303863,3,4861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-12','2020-05-12',275.39,NULL,NULL,1,'2021-08-27 13:39:43','2021-08-27 13:39:43',NULL),(4862,2978,41711,303863,3,4862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-12','2020-05-12',690.44,NULL,NULL,1,'2021-08-27 13:39:43','2021-08-27 13:39:43',NULL),(4863,2978,41711,303863,3,4863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-12','2020-05-12',4047.14,NULL,NULL,1,'2021-08-27 13:39:43','2021-08-27 13:39:43',NULL),(4864,2978,41711,303863,3,4864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-13','2020-05-13',4601.26,NULL,NULL,1,'2021-08-27 13:39:43','2021-08-27 13:39:43',NULL),(4865,2978,41711,303863,3,4865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-13','2020-05-13',2707.89,NULL,NULL,1,'2021-08-27 13:39:43','2021-08-27 13:39:43',NULL),(4866,2978,41711,303863,3,4866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-13','2020-05-13',162.72,NULL,NULL,1,'2021-08-27 13:39:43','2021-08-27 13:39:43',NULL);
INSERT INTO `balance_libro` VALUES (4867,2978,41711,303863,3,4867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-13','2020-05-13',0.02,NULL,NULL,1,'2021-08-27 13:39:43','2021-08-27 13:39:43',NULL),(4868,2978,41711,303863,3,4868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-13','2020-05-13',1632.12,NULL,NULL,1,'2021-08-27 13:39:43','2021-08-27 13:39:43',NULL),(4869,2978,41711,303863,3,4869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-14','2020-05-14',2269.66,NULL,NULL,1,'2021-08-27 13:39:43','2021-08-27 13:39:43',NULL),(4870,2978,41711,303863,3,4870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-14','2020-05-14',1044.94,NULL,NULL,1,'2021-08-27 13:39:43','2021-08-27 13:39:43',NULL),(4871,2978,41711,303863,3,4871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-14','2020-05-14',9739.82,NULL,NULL,1,'2021-08-27 13:39:43','2021-08-27 13:39:43',NULL),(4872,2978,41711,303863,3,4872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-14','2020-05-14',202.22,NULL,NULL,1,'2021-08-27 13:39:43','2021-08-27 13:39:43',NULL),(4873,2978,41711,303863,3,4873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-14','2020-05-14',1136.82,NULL,NULL,1,'2021-08-27 13:39:43','2021-08-27 13:39:43',NULL),(4874,2978,41711,303863,3,4874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-14','2020-05-14',9640.78,NULL,NULL,1,'2021-08-27 13:39:43','2021-08-27 13:39:43',NULL),(4875,2978,41711,303863,3,4875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-14','2020-05-14',376.62,NULL,NULL,1,'2021-08-27 13:39:43','2021-08-27 13:39:43',NULL),(4876,2978,41711,303863,3,4876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-14','2020-05-14',1080.63,NULL,NULL,1,'2021-08-27 13:39:43','2021-08-27 13:39:43',NULL),(4877,2978,41711,303863,3,4877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-15','2020-05-15',669.25,NULL,NULL,1,'2021-08-27 13:39:44','2021-08-27 13:39:44',NULL),(4878,2978,41711,303863,3,4878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-15','2020-05-15',2687.14,NULL,NULL,1,'2021-08-27 13:39:44','2021-08-27 13:39:44',NULL),(4879,2978,41711,303863,3,4879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-15','2020-05-15',646.27,NULL,NULL,1,'2021-08-27 13:39:44','2021-08-27 13:39:44',NULL),(4880,2978,41711,303863,3,4880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-15','2020-05-15',1175.73,NULL,NULL,1,'2021-08-27 13:39:44','2021-08-27 13:39:44',NULL),(4881,2978,41711,303863,3,4881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-15','2020-05-15',2531.04,NULL,NULL,1,'2021-08-27 13:39:44','2021-08-27 13:39:44',NULL),(4882,2978,41711,303863,3,4882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-15','2020-05-15',375.84,NULL,NULL,1,'2021-08-27 13:39:44','2021-08-27 13:39:44',NULL),(4883,2978,41711,303863,3,4883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-15','2020-05-15',912.03,NULL,NULL,1,'2021-08-27 13:39:44','2021-08-27 13:39:44',NULL),(4884,2978,41711,303863,3,4884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-18','2020-05-18',2022.34,NULL,NULL,1,'2021-08-27 13:39:44','2021-08-27 13:39:44',NULL),(4885,2978,41711,303863,3,4885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-18','2020-05-18',10429.92,NULL,NULL,1,'2021-08-27 13:39:44','2021-08-27 13:39:44',NULL),(4886,2978,41711,303863,3,4886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-18','2020-05-18',6054.64,NULL,NULL,1,'2021-08-27 13:39:44','2021-08-27 13:39:44',NULL),(4887,2978,41711,303863,3,4887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-18','2020-05-18',1155.87,NULL,NULL,1,'2021-08-27 13:39:44','2021-08-27 13:39:44',NULL),(4888,2978,41711,303863,3,4888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-18','2020-05-18',4587.22,NULL,NULL,1,'2021-08-27 13:39:44','2021-08-27 13:39:44',NULL),(4889,2978,41711,303863,3,4889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-18','2020-05-18',2499.47,NULL,NULL,1,'2021-08-27 13:39:44','2021-08-27 13:39:44',NULL),(4890,2978,41711,303863,3,4890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-19','2020-05-19',2044.78,NULL,NULL,1,'2021-08-27 13:39:44','2021-08-27 13:39:44',NULL);
INSERT INTO `balance_libro` VALUES (4891,2978,41711,303863,3,4891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-19','2020-05-19',7259.96,NULL,NULL,1,'2021-08-27 13:39:44','2021-08-27 13:39:44',NULL),(4892,2978,41711,303863,3,4892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-19','2020-05-19',833.41,NULL,NULL,1,'2021-08-27 13:39:44','2021-08-27 13:39:44',NULL),(4893,2978,41711,303863,3,4893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-19','2020-05-19',9258.89,NULL,NULL,1,'2021-08-27 13:39:44','2021-08-27 13:39:44',NULL),(4894,2978,41711,303863,3,4894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-19','2020-05-19',1410.86,NULL,NULL,1,'2021-08-27 13:39:44','2021-08-27 13:39:44',NULL),(4895,2978,41711,303863,3,4895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-19','2020-05-19',381.24,NULL,NULL,1,'2021-08-27 13:39:44','2021-08-27 13:39:44',NULL),(4896,2978,41711,303863,3,4896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-20','2020-05-20',1421.36,NULL,NULL,1,'2021-08-27 13:39:44','2021-08-27 13:39:44',NULL),(4897,2978,41711,303863,3,4897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-20','2020-05-20',9052.41,NULL,NULL,1,'2021-08-27 13:39:44','2021-08-27 13:39:44',NULL),(4898,2978,41711,303863,3,4898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-20','2020-05-20',746.44,NULL,NULL,1,'2021-08-27 13:39:44','2021-08-27 13:39:44',NULL),(4899,2978,41711,303863,3,4899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-20','2020-05-20',347.73,NULL,NULL,1,'2021-08-27 13:39:45','2021-08-27 13:39:45',NULL),(4900,2978,41711,303863,3,4900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-20','2020-05-20',517.68,NULL,NULL,1,'2021-08-27 13:39:45','2021-08-27 13:39:45',NULL),(4901,2978,41711,303863,3,4901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-20','2020-05-20',4451.95,NULL,NULL,1,'2021-08-27 13:39:45','2021-08-27 13:39:45',NULL),(4902,2978,41711,303863,3,4902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-21','2020-05-21',959.92,NULL,NULL,1,'2021-08-27 13:39:45','2021-08-27 13:39:45',NULL),(4903,2978,41711,303863,3,4903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-21','2020-05-21',345.80,NULL,NULL,1,'2021-08-27 13:39:45','2021-08-27 13:39:45',NULL),(4904,2978,41711,303863,3,4904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-21','2020-05-21',2967.74,NULL,NULL,1,'2021-08-27 13:39:45','2021-08-27 13:39:45',NULL),(4905,2978,41711,303863,3,4905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-21','2020-05-21',146.63,NULL,NULL,1,'2021-08-27 13:39:45','2021-08-27 13:39:45',NULL),(4906,2978,41711,303863,3,4906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-21','2020-05-21',3189.45,NULL,NULL,1,'2021-08-27 13:39:45','2021-08-27 13:39:45',NULL),(4907,2978,41711,303863,3,4907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-22','2020-05-22',1857.67,NULL,NULL,1,'2021-08-27 13:39:45','2021-08-27 13:39:45',NULL),(4908,2978,41711,303863,3,4908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-22','2020-05-22',93.86,NULL,NULL,1,'2021-08-27 13:39:45','2021-08-27 13:39:45',NULL),(4909,2978,41711,303863,3,4909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-22','2020-05-22',2998.58,NULL,NULL,1,'2021-08-27 13:39:45','2021-08-27 13:39:45',NULL),(4910,2978,41711,303863,3,4910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-22','2020-05-22',187.91,NULL,NULL,1,'2021-08-27 13:39:45','2021-08-27 13:39:45',NULL),(4911,2978,41711,303863,3,4911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-22','2020-05-22',144.51,NULL,NULL,1,'2021-08-27 13:39:45','2021-08-27 13:39:45',NULL),(4912,2978,41711,303863,3,4912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-22','2020-05-22',615.98,NULL,NULL,1,'2021-08-27 13:39:45','2021-08-27 13:39:45',NULL),(4913,2978,41711,303863,3,4913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-22','2020-05-22',1991.69,NULL,NULL,1,'2021-08-27 13:39:45','2021-08-27 13:39:45',NULL),(4914,2978,41711,303863,3,4914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-22','2020-05-22',6254.80,NULL,NULL,1,'2021-08-27 13:39:45','2021-08-27 13:39:45',NULL);
INSERT INTO `balance_libro` VALUES (4915,2978,41711,303863,3,4915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-24','2020-05-24',7995.14,NULL,NULL,1,'2021-08-27 13:39:45','2021-08-27 13:39:45',NULL),(4916,2978,41711,303863,3,4916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-24','2020-05-24',290.09,NULL,NULL,1,'2021-08-27 13:39:45','2021-08-27 13:39:45',NULL),(4917,2978,41711,303863,3,4917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-26','2020-05-26',670.90,NULL,NULL,1,'2021-08-27 13:39:45','2021-08-27 13:39:45',NULL),(4918,2978,41711,303863,3,4918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-26','2020-05-26',108.03,NULL,NULL,1,'2021-08-27 13:39:45','2021-08-27 13:39:45',NULL),(4919,2978,41711,303863,3,4919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-26','2020-05-26',325.69,NULL,NULL,1,'2021-08-27 13:39:45','2021-08-27 13:39:45',NULL),(4920,2978,41711,303863,3,4920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-26','2020-05-26',986.00,NULL,NULL,1,'2021-08-27 13:39:45','2021-08-27 13:39:45',NULL),(4921,2978,41711,303863,3,4921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-26','2020-05-26',51.17,NULL,NULL,1,'2021-08-27 13:39:46','2021-08-27 13:39:46',NULL),(4922,2978,41711,303863,3,4922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-26','2020-05-26',315.16,NULL,NULL,1,'2021-08-27 13:39:46','2021-08-27 13:39:46',NULL),(4923,2978,41711,303863,3,4923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-26','2020-05-26',3815.01,NULL,NULL,1,'2021-08-27 13:39:46','2021-08-27 13:39:46',NULL),(4924,2978,41711,303863,3,4924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-27','2020-05-27',4148.28,NULL,NULL,1,'2021-08-27 13:39:46','2021-08-27 13:39:46',NULL),(4925,2978,41711,303863,3,4925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-27','2020-05-27',62.46,NULL,NULL,1,'2021-08-27 13:39:46','2021-08-27 13:39:46',NULL),(4926,2978,41711,303863,3,4926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-27','2020-05-27',2516.85,NULL,NULL,1,'2021-08-27 13:39:46','2021-08-27 13:39:46',NULL),(4927,2978,41711,303863,3,4927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-27','2020-05-27',1282.92,NULL,NULL,1,'2021-08-27 13:39:46','2021-08-27 13:39:46',NULL),(4928,2978,41711,303863,3,4928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-27','2020-05-27',133.12,NULL,NULL,1,'2021-08-27 13:39:46','2021-08-27 13:39:46',NULL),(4929,2978,41711,303863,3,4929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-27','2020-05-27',1843.22,NULL,NULL,1,'2021-08-27 13:39:46','2021-08-27 13:39:46',NULL),(4930,2978,41711,303863,3,4930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-27','2020-05-27',17157.02,NULL,NULL,1,'2021-08-27 13:39:46','2021-08-27 13:39:46',NULL),(4931,2978,41711,303863,3,4931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-27','2020-05-27',435.75,NULL,NULL,1,'2021-08-27 13:39:46','2021-08-27 13:39:46',NULL),(4932,2978,41711,303863,3,4932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-27','2020-05-27',1130.56,NULL,NULL,1,'2021-08-27 13:39:46','2021-08-27 13:39:46',NULL),(4933,2978,41711,303863,3,4933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-27','2020-05-27',1182.34,NULL,NULL,1,'2021-08-27 13:39:46','2021-08-27 13:39:46',NULL),(4934,2978,41711,303863,3,4934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-28','2020-05-28',6685.99,NULL,NULL,1,'2021-08-27 13:39:46','2021-08-27 13:39:46',NULL),(4935,2978,41711,303863,3,4935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-28','2020-05-28',918.22,NULL,NULL,1,'2021-08-27 13:39:46','2021-08-27 13:39:46',NULL),(4936,2978,41711,303863,3,4936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-28','2020-05-28',403.34,NULL,NULL,1,'2021-08-27 13:39:46','2021-08-27 13:39:46',NULL),(4937,2978,41711,303863,3,4937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-28','2020-05-28',524.28,NULL,NULL,1,'2021-08-27 13:39:46','2021-08-27 13:39:46',NULL),(4938,2978,41711,303863,3,4938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-28','2020-05-28',1372.83,NULL,NULL,1,'2021-08-27 13:39:46','2021-08-27 13:39:46',NULL);
INSERT INTO `balance_libro` VALUES (4939,2978,41711,303863,3,4939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-28','2020-05-28',149.78,NULL,NULL,1,'2021-08-27 13:39:46','2021-08-27 13:39:46',NULL),(4940,2978,41711,303863,3,4940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-28','2020-05-28',8241.31,NULL,NULL,1,'2021-08-27 13:39:46','2021-08-27 13:39:46',NULL),(4941,2978,41711,303863,3,4941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-28','2020-05-28',65.80,NULL,NULL,1,'2021-08-27 13:39:46','2021-08-27 13:39:46',NULL),(4942,2978,41711,303863,3,4942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-28','2020-05-28',2074.55,NULL,NULL,1,'2021-08-27 13:39:46','2021-08-27 13:39:46',NULL),(4943,2978,41711,303863,3,4943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-29','2020-05-29',360.43,NULL,NULL,1,'2021-08-27 13:39:47','2021-08-27 13:39:47',NULL),(4944,2978,41711,303863,3,4944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-29','2020-05-29',34.57,NULL,NULL,1,'2021-08-27 13:39:47','2021-08-27 13:39:47',NULL),(4945,2978,41711,303863,3,4945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-29','2020-05-29',696.61,NULL,NULL,1,'2021-08-27 13:39:47','2021-08-27 13:39:47',NULL),(4946,2978,41711,303863,3,4946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-29','2020-05-29',5626.87,NULL,NULL,1,'2021-08-27 13:39:47','2021-08-27 13:39:47',NULL),(4947,2978,41711,303863,3,4947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-29','2020-05-29',196.78,NULL,NULL,1,'2021-08-27 13:39:47','2021-08-27 13:39:47',NULL),(4948,2978,41711,303863,3,4948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-29','2020-05-29',1266.71,NULL,NULL,1,'2021-08-27 13:39:47','2021-08-27 13:39:47',NULL),(4949,2978,41711,303863,3,4949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-29','2020-05-29',784.84,NULL,NULL,1,'2021-08-27 13:39:47','2021-08-27 13:39:47',NULL),(4950,2978,41711,303863,3,4950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-29','2020-05-29',4227.23,NULL,NULL,1,'2021-08-27 13:39:47','2021-08-27 13:39:47',NULL),(4951,2978,41711,303863,3,4951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-29','2020-05-29',227.12,NULL,NULL,1,'2021-08-27 13:39:47','2021-08-27 13:39:47',NULL),(4952,2978,41711,303863,3,4952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',5439.29,NULL,NULL,1,'2021-08-27 13:39:47','2021-08-27 13:39:47',NULL),(4953,2978,41711,303863,3,4953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',161.86,NULL,NULL,1,'2021-08-27 13:39:47','2021-08-27 13:39:47',NULL),(4954,2978,41711,303863,3,4954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-05-31','2020-05-31',1071.94,NULL,NULL,1,'2021-08-27 13:39:47','2021-08-27 13:39:47',NULL),(4955,2978,41711,303864,3,4955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-01','2020-06-01',5958.74,NULL,NULL,1,'2021-08-27 13:52:07','2021-08-27 13:52:07',NULL),(4956,2978,41711,303864,3,4956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-01','2020-06-01',180.85,NULL,NULL,1,'2021-08-27 13:52:07','2021-08-27 13:52:07',NULL),(4957,2978,41711,303864,3,4957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-01','2020-06-01',3000.78,NULL,NULL,1,'2021-08-27 13:52:07','2021-08-27 13:52:07',NULL),(4958,2978,41711,303864,3,4958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-01','2020-06-01',19944.72,NULL,NULL,1,'2021-08-27 13:52:07','2021-08-27 13:52:07',NULL),(4959,2978,41711,303864,3,4959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-01','2020-06-01',296.58,NULL,NULL,1,'2021-08-27 13:52:07','2021-08-27 13:52:07',NULL),(4960,2978,41711,303864,3,4960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-01','2020-06-01',2119.92,NULL,NULL,1,'2021-08-27 13:52:07','2021-08-27 13:52:07',NULL),(4961,2978,41711,303864,3,4961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-02','2020-06-02',931.68,NULL,NULL,1,'2021-08-27 13:52:07','2021-08-27 13:52:07',NULL),(4962,2978,41711,303864,3,4962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-02','2020-06-02',13716.55,NULL,NULL,1,'2021-08-27 13:52:08','2021-08-27 13:52:08',NULL);
INSERT INTO `balance_libro` VALUES (4963,2978,41711,303864,3,4963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-02','2020-06-02',549.19,NULL,NULL,1,'2021-08-27 13:52:08','2021-08-27 13:52:08',NULL),(4964,2978,41711,303864,3,4964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-02','2020-06-02',3155.01,NULL,NULL,1,'2021-08-27 13:52:08','2021-08-27 13:52:08',NULL),(4965,2978,41711,303864,3,4965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-02','2020-06-02',7826.46,NULL,NULL,1,'2021-08-27 13:52:08','2021-08-27 13:52:08',NULL),(4966,2978,41711,303864,3,4966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-02','2020-06-02',1442.42,NULL,NULL,1,'2021-08-27 13:52:08','2021-08-27 13:52:08',NULL),(4967,2978,41711,303864,3,4967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-02','2020-06-02',254.07,NULL,NULL,1,'2021-08-27 13:52:08','2021-08-27 13:52:08',NULL),(4968,2978,41711,303864,3,4968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-02','2020-06-02',361.55,NULL,NULL,1,'2021-08-27 13:52:08','2021-08-27 13:52:08',NULL),(4969,2978,41711,303864,3,4969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-02','2020-06-02',2016.35,NULL,NULL,1,'2021-08-27 13:52:08','2021-08-27 13:52:08',NULL),(4970,2978,41711,303864,3,4970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-02','2020-06-02',1689.80,NULL,NULL,1,'2021-08-27 13:52:08','2021-08-27 13:52:08',NULL),(4971,2978,41711,303864,3,4971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-03','2020-06-03',699.49,NULL,NULL,1,'2021-08-27 13:52:08','2021-08-27 13:52:08',NULL),(4972,2978,41711,303864,3,4972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-03','2020-06-03',587.17,NULL,NULL,1,'2021-08-27 13:52:08','2021-08-27 13:52:08',NULL),(4973,2978,41711,303864,3,4973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-03','2020-06-03',4221.96,NULL,NULL,1,'2021-08-27 13:52:08','2021-08-27 13:52:08',NULL),(4974,2978,41711,303864,3,4974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-03','2020-06-03',314.24,NULL,NULL,1,'2021-08-27 13:52:08','2021-08-27 13:52:08',NULL),(4975,2978,41711,303864,3,4975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-03','2020-06-03',57.20,NULL,NULL,1,'2021-08-27 13:52:08','2021-08-27 13:52:08',NULL),(4976,2978,41711,303864,3,4976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-03','2020-06-03',1532.24,NULL,NULL,1,'2021-08-27 13:52:08','2021-08-27 13:52:08',NULL),(4977,2978,41711,303864,3,4977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-03','2020-06-03',61.74,NULL,NULL,1,'2021-08-27 13:52:08','2021-08-27 13:52:08',NULL),(4978,2978,41711,303864,3,4978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-03','2020-06-03',3354.82,NULL,NULL,1,'2021-08-27 13:52:08','2021-08-27 13:52:08',NULL),(4979,2978,41711,303864,3,4979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-03','2020-06-03',424.49,NULL,NULL,1,'2021-08-27 13:52:08','2021-08-27 13:52:08',NULL),(4980,2978,41711,303864,3,4980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-03','2020-06-03',5001.11,NULL,NULL,1,'2021-08-27 13:52:08','2021-08-27 13:52:08',NULL),(4981,2978,41711,303864,3,4981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-03','2020-06-03',314.21,NULL,NULL,1,'2021-08-27 13:52:08','2021-08-27 13:52:08',NULL),(4982,2978,41711,303864,3,4982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-03','2020-06-03',66.39,NULL,NULL,1,'2021-08-27 13:52:08','2021-08-27 13:52:08',NULL),(4983,2978,41711,303864,3,4983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-03','2020-06-03',2908.24,NULL,NULL,1,'2021-08-27 13:52:08','2021-08-27 13:52:08',NULL),(4984,2978,41711,303864,3,4984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-04','2020-06-04',2776.84,NULL,NULL,1,'2021-08-27 13:52:08','2021-08-27 13:52:08',NULL),(4985,2978,41711,303864,3,4985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-04','2020-06-04',337.08,NULL,NULL,1,'2021-08-27 13:52:08','2021-08-27 13:52:08',NULL),(4986,2978,41711,303864,3,4986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-04','2020-06-04',890.91,NULL,NULL,1,'2021-08-27 13:52:08','2021-08-27 13:52:08',NULL);
INSERT INTO `balance_libro` VALUES (4987,2978,41711,303864,3,4987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-04','2020-06-04',4800.65,NULL,NULL,1,'2021-08-27 13:52:09','2021-08-27 13:52:09',NULL),(4988,2978,41711,303864,3,4988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-04','2020-06-04',749.81,NULL,NULL,1,'2021-08-27 13:52:09','2021-08-27 13:52:09',NULL),(4989,2978,41711,303864,3,4989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-05','2020-06-05',7308.32,NULL,NULL,1,'2021-08-27 13:52:09','2021-08-27 13:52:09',NULL),(4990,2978,41711,303864,3,4990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-05','2020-06-05',1020.82,NULL,NULL,1,'2021-08-27 13:52:09','2021-08-27 13:52:09',NULL),(4991,2978,41711,303864,3,4991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-05','2020-06-05',732.15,NULL,NULL,1,'2021-08-27 13:52:09','2021-08-27 13:52:09',NULL),(4992,2978,41711,303864,3,4992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-05','2020-06-05',251.83,NULL,NULL,1,'2021-08-27 13:52:09','2021-08-27 13:52:09',NULL),(4993,2978,41711,303864,3,4993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-05','2020-06-05',300.00,NULL,NULL,1,'2021-08-27 13:52:09','2021-08-27 13:52:09',NULL),(4994,2978,41711,303864,3,4994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-05','2020-06-05',846.87,NULL,NULL,1,'2021-08-27 13:52:09','2021-08-27 13:52:09',NULL),(4995,2978,41711,303864,3,4995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-07','2020-06-07',628.49,NULL,NULL,1,'2021-08-27 13:52:09','2021-08-27 13:52:09',NULL),(4996,2978,41711,303864,3,4996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-07','2020-06-07',889.74,NULL,NULL,1,'2021-08-27 13:52:09','2021-08-27 13:52:09',NULL),(4997,2978,41711,303864,3,4997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-07','2020-06-07',6029.06,NULL,NULL,1,'2021-08-27 13:52:09','2021-08-27 13:52:09',NULL),(4998,2978,41711,303864,3,4998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-08','2020-06-08',1951.02,NULL,NULL,1,'2021-08-27 13:52:09','2021-08-27 13:52:09',NULL),(4999,2978,41711,303864,3,4999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-08','2020-06-08',15139.06,NULL,NULL,1,'2021-08-27 13:52:09','2021-08-27 13:52:09',NULL),(5000,2978,41711,303864,3,5000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-08','2020-06-08',195.20,NULL,NULL,1,'2021-08-27 13:52:09','2021-08-27 13:52:09',NULL),(5001,2978,41711,303864,3,5001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-08','2020-06-08',1839.10,NULL,NULL,1,'2021-08-27 13:52:09','2021-08-27 13:52:09',NULL),(5002,2978,41711,303864,3,5002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-08','2020-06-08',4519.08,NULL,NULL,1,'2021-08-27 13:52:09','2021-08-27 13:52:09',NULL),(5003,2978,41711,303864,3,5003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-09','2020-06-09',739.92,NULL,NULL,1,'2021-08-27 13:52:09','2021-08-27 13:52:09',NULL),(5004,2978,41711,303864,3,5004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-09','2020-06-09',3887.03,NULL,NULL,1,'2021-08-27 13:52:09','2021-08-27 13:52:09',NULL),(5005,2978,41711,303864,3,5005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-09','2020-06-09',506.16,NULL,NULL,1,'2021-08-27 13:52:09','2021-08-27 13:52:09',NULL),(5006,2978,41711,303864,3,5006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-09','2020-06-09',6040.55,NULL,NULL,1,'2021-08-27 13:52:09','2021-08-27 13:52:09',NULL),(5007,2978,41711,303864,3,5007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-09','2020-06-09',13237.80,NULL,NULL,1,'2021-08-27 13:52:09','2021-08-27 13:52:09',NULL),(5008,2978,41711,303864,3,5008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-09','2020-06-09',435.75,NULL,NULL,1,'2021-08-27 13:52:09','2021-08-27 13:52:09',NULL),(5009,2978,41711,303864,3,5009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-10','2020-06-10',523.84,NULL,NULL,1,'2021-08-27 13:52:09','2021-08-27 13:52:09',NULL),(5010,2978,41711,303864,3,5010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-10','2020-06-10',4937.18,NULL,NULL,1,'2021-08-27 13:52:10','2021-08-27 13:52:10',NULL);
INSERT INTO `balance_libro` VALUES (5011,2978,41711,303864,3,5011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-10','2020-06-10',5323.95,NULL,NULL,1,'2021-08-27 13:52:10','2021-08-27 13:52:10',NULL),(5012,2978,41711,303864,3,5012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-10','2020-06-10',381.75,NULL,NULL,1,'2021-08-27 13:52:10','2021-08-27 13:52:10',NULL),(5013,2978,41711,303864,3,5013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-10','2020-06-10',395.71,NULL,NULL,1,'2021-08-27 13:52:10','2021-08-27 13:52:10',NULL),(5014,2978,41711,303864,3,5014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-11','2020-06-11',1589.37,NULL,NULL,1,'2021-08-27 13:52:10','2021-08-27 13:52:10',NULL),(5015,2978,41711,303864,3,5015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-11','2020-06-11',140.43,NULL,NULL,1,'2021-08-27 13:52:10','2021-08-27 13:52:10',NULL),(5016,2978,41711,303864,3,5016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-11','2020-06-11',4780.32,NULL,NULL,1,'2021-08-27 13:52:10','2021-08-27 13:52:10',NULL),(5017,2978,41711,303864,3,5017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-11','2020-06-11',197.11,NULL,NULL,1,'2021-08-27 13:52:10','2021-08-27 13:52:10',NULL),(5018,2978,41711,303864,3,5018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-11','2020-06-11',346.91,NULL,NULL,1,'2021-08-27 13:52:10','2021-08-27 13:52:10',NULL),(5019,2978,41711,303864,3,5019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-11','2020-06-11',269.86,NULL,NULL,1,'2021-08-27 13:52:10','2021-08-27 13:52:10',NULL),(5020,2978,41711,303864,3,5020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-12','2020-06-12',7296.88,NULL,NULL,1,'2021-08-27 13:52:10','2021-08-27 13:52:10',NULL),(5021,2978,41711,303864,3,5021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-12','2020-06-12',138.68,NULL,NULL,1,'2021-08-27 13:52:10','2021-08-27 13:52:10',NULL),(5022,2978,41711,303864,3,5022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-12','2020-06-12',140.43,NULL,NULL,1,'2021-08-27 13:52:10','2021-08-27 13:52:10',NULL),(5023,2978,41711,303864,3,5023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-12','2020-06-12',5340.20,NULL,NULL,1,'2021-08-27 13:52:10','2021-08-27 13:52:10',NULL),(5024,2978,41711,303864,3,5024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-12','2020-06-12',239.91,NULL,NULL,1,'2021-08-27 13:52:10','2021-08-27 13:52:10',NULL),(5025,2978,41711,303864,3,5025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-12','2020-06-12',2701.24,NULL,NULL,1,'2021-08-27 13:52:10','2021-08-27 13:52:10',NULL),(5026,2978,41711,303864,3,5026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-12','2020-06-12',278.54,NULL,NULL,1,'2021-08-27 13:52:10','2021-08-27 13:52:10',NULL),(5027,2978,41711,303864,3,5027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-12','2020-06-12',4250.00,NULL,NULL,1,'2021-08-27 13:52:10','2021-08-27 13:52:10',NULL),(5028,2978,41711,303864,3,5028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-12','2020-06-12',128.51,NULL,NULL,1,'2021-08-27 13:52:10','2021-08-27 13:52:10',NULL),(5029,2978,41711,303864,3,5029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-12','2020-06-12',2720.35,NULL,NULL,1,'2021-08-27 13:52:10','2021-08-27 13:52:10',NULL),(5030,2978,41711,303864,3,5030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-12','2020-06-12',1860.95,NULL,NULL,1,'2021-08-27 13:52:10','2021-08-27 13:52:10',NULL),(5031,2978,41711,303864,3,5031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-12','2020-06-12',746.71,NULL,NULL,1,'2021-08-27 13:52:10','2021-08-27 13:52:10',NULL),(5032,2978,41711,303864,3,5032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-14','2020-06-14',7876.54,NULL,NULL,1,'2021-08-27 13:52:10','2021-08-27 13:52:10',NULL),(5033,2978,41711,303864,3,5033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-15','2020-06-15',2499.62,NULL,NULL,1,'2021-08-27 13:52:11','2021-08-27 13:52:11',NULL),(5034,2978,41711,303864,3,5034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-16','2020-06-16',10380.23,NULL,NULL,1,'2021-08-27 13:52:11','2021-08-27 13:52:11',NULL);
INSERT INTO `balance_libro` VALUES (5035,2978,41711,303864,3,5035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-16','2020-06-16',75.56,NULL,NULL,1,'2021-08-27 13:52:11','2021-08-27 13:52:11',NULL),(5036,2978,41711,303864,3,5036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-16','2020-06-16',13273.16,NULL,NULL,1,'2021-08-27 13:52:11','2021-08-27 13:52:11',NULL),(5037,2978,41711,303864,3,5037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-16','2020-06-16',450.73,NULL,NULL,1,'2021-08-27 13:52:11','2021-08-27 13:52:11',NULL),(5038,2978,41711,303864,3,5038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-16','2020-06-16',800.36,NULL,NULL,1,'2021-08-27 13:52:11','2021-08-27 13:52:11',NULL),(5039,2978,41711,303864,3,5039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-16','2020-06-16',106.46,NULL,NULL,1,'2021-08-27 13:52:11','2021-08-27 13:52:11',NULL),(5040,2978,41711,303864,3,5040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-16','2020-06-16',2360.03,NULL,NULL,1,'2021-08-27 13:52:11','2021-08-27 13:52:11',NULL),(5041,2978,41711,303864,3,5041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-17','2020-06-17',2508.81,NULL,NULL,1,'2021-08-27 13:52:11','2021-08-27 13:52:11',NULL),(5042,2978,41711,303864,3,5042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-17','2020-06-17',1323.10,NULL,NULL,1,'2021-08-27 13:52:11','2021-08-27 13:52:11',NULL),(5043,2978,41711,303864,3,5043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-17','2020-06-17',113.45,NULL,NULL,1,'2021-08-27 13:52:11','2021-08-27 13:52:11',NULL),(5044,2978,41711,303864,3,5044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-17','2020-06-17',3908.94,NULL,NULL,1,'2021-08-27 13:52:11','2021-08-27 13:52:11',NULL),(5045,2978,41711,303864,3,5045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-17','2020-06-17',698.83,NULL,NULL,1,'2021-08-27 13:52:11','2021-08-27 13:52:11',NULL),(5046,2978,41711,303864,3,5046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-17','2020-06-17',7852.67,NULL,NULL,1,'2021-08-27 13:52:11','2021-08-27 13:52:11',NULL),(5047,2978,41711,303864,3,5047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-17','2020-06-17',578.99,NULL,NULL,1,'2021-08-27 13:52:11','2021-08-27 13:52:11',NULL),(5048,2978,41711,303864,3,5048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-18','2020-06-18',735.58,NULL,NULL,1,'2021-08-27 13:52:11','2021-08-27 13:52:11',NULL),(5049,2978,41711,303864,3,5049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-18','2020-06-18',12678.86,NULL,NULL,1,'2021-08-27 13:52:11','2021-08-27 13:52:11',NULL),(5050,2978,41711,303864,3,5050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-18','2020-06-18',9195.21,NULL,NULL,1,'2021-08-27 13:52:11','2021-08-27 13:52:11',NULL),(5051,2978,41711,303864,3,5051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-19','2020-06-19',186.49,NULL,NULL,1,'2021-08-27 13:52:11','2021-08-27 13:52:11',NULL),(5052,2978,41711,303864,3,5052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-19','2020-06-19',1912.68,NULL,NULL,1,'2021-08-27 13:52:11','2021-08-27 13:52:11',NULL),(5053,2978,41711,303864,3,5053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-19','2020-06-19',299.64,NULL,NULL,1,'2021-08-27 13:52:11','2021-08-27 13:52:11',NULL),(5054,2978,41711,303864,3,5054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-19','2020-06-19',12547.96,NULL,NULL,1,'2021-08-27 13:52:11','2021-08-27 13:52:11',NULL),(5055,2978,41711,303864,3,5055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-19','2020-06-19',1606.95,NULL,NULL,1,'2021-08-27 13:52:11','2021-08-27 13:52:11',NULL),(5056,2978,41711,303864,3,5056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-19','2020-06-19',45.72,NULL,NULL,1,'2021-08-27 13:52:12','2021-08-27 13:52:12',NULL),(5057,2978,41711,303864,3,5057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-19','2020-06-19',331.15,NULL,NULL,1,'2021-08-27 13:52:12','2021-08-27 13:52:12',NULL),(5058,2978,41711,303864,3,5058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-21','2020-06-21',3797.69,NULL,NULL,1,'2021-08-27 13:52:12','2021-08-27 13:52:12',NULL);
INSERT INTO `balance_libro` VALUES (5059,2978,41711,303864,3,5059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-21','2020-06-21',190.90,NULL,NULL,1,'2021-08-27 13:52:12','2021-08-27 13:52:12',NULL),(5060,2978,41711,303864,3,5060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-21','2020-06-21',384.61,NULL,NULL,1,'2021-08-27 13:52:12','2021-08-27 13:52:12',NULL),(5061,2978,41711,303864,3,5061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-21','2020-06-21',1090.53,NULL,NULL,1,'2021-08-27 13:52:12','2021-08-27 13:52:12',NULL),(5062,2978,41711,303864,3,5062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-21','2020-06-21',106.47,NULL,NULL,1,'2021-08-27 13:52:12','2021-08-27 13:52:12',NULL),(5063,2978,41711,303864,3,5063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-22','2020-06-22',456.95,NULL,NULL,1,'2021-08-27 13:52:12','2021-08-27 13:52:12',NULL),(5064,2978,41711,303864,3,5064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-22','2020-06-22',16116.99,NULL,NULL,1,'2021-08-27 13:52:12','2021-08-27 13:52:12',NULL),(5065,2978,41711,303864,3,5065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-22','2020-06-22',9243.57,NULL,NULL,1,'2021-08-27 13:52:12','2021-08-27 13:52:12',NULL),(5066,2978,41711,303864,3,5066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-22','2020-06-22',644.96,NULL,NULL,1,'2021-08-27 13:52:12','2021-08-27 13:52:12',NULL),(5067,2978,41711,303864,3,5067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-22','2020-06-22',2705.40,NULL,NULL,1,'2021-08-27 13:52:12','2021-08-27 13:52:12',NULL),(5068,2978,41711,303864,3,5068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-22','2020-06-22',2604.27,NULL,NULL,1,'2021-08-27 13:52:12','2021-08-27 13:52:12',NULL),(5069,2978,41711,303864,3,5069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-22','2020-06-22',318.58,NULL,NULL,1,'2021-08-27 13:52:12','2021-08-27 13:52:12',NULL),(5070,2978,41711,303864,3,5070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-22','2020-06-22',576.30,NULL,NULL,1,'2021-08-27 13:52:12','2021-08-27 13:52:12',NULL),(5071,2978,41711,303864,3,5071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-22','2020-06-22',2791.56,NULL,NULL,1,'2021-08-27 13:52:12','2021-08-27 13:52:12',NULL),(5072,2978,41711,303864,3,5072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-23','2020-06-23',426.95,NULL,NULL,1,'2021-08-27 13:52:12','2021-08-27 13:52:12',NULL),(5073,2978,41711,303864,3,5073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-23','2020-06-23',2839.26,NULL,NULL,1,'2021-08-27 13:52:12','2021-08-27 13:52:12',NULL),(5074,2978,41711,303864,3,5074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-23','2020-06-23',1912.68,NULL,NULL,1,'2021-08-27 13:52:12','2021-08-27 13:52:12',NULL),(5075,2978,41711,303864,3,5075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-23','2020-06-23',126.97,NULL,NULL,1,'2021-08-27 13:52:12','2021-08-27 13:52:12',NULL),(5076,2978,41711,303864,3,5076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-23','2020-06-23',3905.91,NULL,NULL,1,'2021-08-27 13:52:12','2021-08-27 13:52:12',NULL),(5077,2978,41711,303864,3,5077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-23','2020-06-23',3644.22,NULL,NULL,1,'2021-08-27 13:52:12','2021-08-27 13:52:12',NULL),(5078,2978,41711,303864,3,5078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-23','2020-06-23',479.89,NULL,NULL,1,'2021-08-27 13:52:12','2021-08-27 13:52:12',NULL),(5079,2978,41711,303864,3,5079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-23','2020-06-23',4017.36,NULL,NULL,1,'2021-08-27 13:52:13','2021-08-27 13:52:13',NULL),(5080,2978,41711,303864,3,5080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-23','2020-06-23',11653.11,NULL,NULL,1,'2021-08-27 13:52:13','2021-08-27 13:52:13',NULL),(5081,2978,41711,303864,3,5081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-23','2020-06-23',19634.39,NULL,NULL,1,'2021-08-27 13:52:13','2021-08-27 13:52:13',NULL),(5082,2978,41711,303864,3,5082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-24','2020-06-24',1301.14,NULL,NULL,1,'2021-08-27 13:52:13','2021-08-27 13:52:13',NULL);
INSERT INTO `balance_libro` VALUES (5083,2978,41711,303864,3,5083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-24','2020-06-24',4914.60,NULL,NULL,1,'2021-08-27 13:52:13','2021-08-27 13:52:13',NULL),(5084,2978,41711,303864,3,5084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-24','2020-06-24',4003.48,NULL,NULL,1,'2021-08-27 13:52:13','2021-08-27 13:52:13',NULL),(5085,2978,41711,303864,3,5085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-24','2020-06-24',98.56,NULL,NULL,1,'2021-08-27 13:52:13','2021-08-27 13:52:13',NULL),(5086,2978,41711,303864,3,5086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-24','2020-06-24',5633.92,NULL,NULL,1,'2021-08-27 13:52:13','2021-08-27 13:52:13',NULL),(5087,2978,41711,303864,3,5087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-24','2020-06-24',449.76,NULL,NULL,1,'2021-08-27 13:52:13','2021-08-27 13:52:13',NULL),(5088,2978,41711,303864,3,5088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-24','2020-06-24',428.13,NULL,NULL,1,'2021-08-27 13:52:13','2021-08-27 13:52:13',NULL),(5089,2978,41711,303864,3,5089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-25','2020-06-25',915.35,NULL,NULL,1,'2021-08-27 13:52:13','2021-08-27 13:52:13',NULL),(5090,2978,41711,303864,3,5090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-25','2020-06-25',225.20,NULL,NULL,1,'2021-08-27 13:52:13','2021-08-27 13:52:13',NULL),(5091,2978,41711,303864,3,5091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-25','2020-06-25',6938.60,NULL,NULL,1,'2021-08-27 13:52:13','2021-08-27 13:52:13',NULL),(5092,2978,41711,303864,3,5092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-25','2020-06-25',111.92,NULL,NULL,1,'2021-08-27 13:52:13','2021-08-27 13:52:13',NULL),(5093,2978,41711,303864,3,5093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-25','2020-06-25',279.95,NULL,NULL,1,'2021-08-27 13:52:13','2021-08-27 13:52:13',NULL),(5094,2978,41711,303864,3,5094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-25','2020-06-25',791.24,NULL,NULL,1,'2021-08-27 13:52:13','2021-08-27 13:52:13',NULL),(5095,2978,41711,303864,3,5095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-25','2020-06-25',6651.04,NULL,NULL,1,'2021-08-27 13:52:13','2021-08-27 13:52:13',NULL),(5096,2978,41711,303864,3,5096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-26','2020-06-26',2150.91,NULL,NULL,1,'2021-08-27 13:52:13','2021-08-27 13:52:13',NULL),(5097,2978,41711,303864,3,5097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-26','2020-06-26',469.71,NULL,NULL,1,'2021-08-27 13:52:13','2021-08-27 13:52:13',NULL),(5098,2978,41711,303864,3,5098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-26','2020-06-26',4361.40,NULL,NULL,1,'2021-08-27 13:52:13','2021-08-27 13:52:13',NULL),(5099,2978,41711,303864,3,5099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-26','2020-06-26',923.66,NULL,NULL,1,'2021-08-27 13:52:13','2021-08-27 13:52:13',NULL),(5100,2978,41711,303864,3,5100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-26','2020-06-26',468.05,NULL,NULL,1,'2021-08-27 13:52:13','2021-08-27 13:52:13',NULL),(5101,2978,41711,303864,3,5101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-26','2020-06-26',0.02,NULL,NULL,1,'2021-08-27 13:52:13','2021-08-27 13:52:13',NULL),(5102,2978,41711,303864,3,5102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-26','2020-06-26',529.94,NULL,NULL,1,'2021-08-27 13:52:13','2021-08-27 13:52:13',NULL),(5103,2978,41711,303864,3,5103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-28','2020-06-28',4089.62,NULL,NULL,1,'2021-08-27 13:52:13','2021-08-27 13:52:13',NULL),(5104,2978,41711,303864,3,5104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-28','2020-06-28',1932.14,NULL,NULL,1,'2021-08-27 13:52:14','2021-08-27 13:52:14',NULL),(5105,2978,41711,303864,3,5105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-28','2020-06-28',18221.47,NULL,NULL,1,'2021-08-27 13:52:14','2021-08-27 13:52:14',NULL),(5106,2978,41711,303864,3,5106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-28','2020-06-28',1099.81,NULL,NULL,1,'2021-08-27 13:52:14','2021-08-27 13:52:14',NULL);
INSERT INTO `balance_libro` VALUES (5107,2978,41711,303864,3,5107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-28','2020-06-28',577.98,NULL,NULL,1,'2021-08-27 13:52:14','2021-08-27 13:52:14',NULL),(5108,2978,41711,303864,3,5108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-29','2020-06-29',1030.52,NULL,NULL,1,'2021-08-27 13:52:14','2021-08-27 13:52:14',NULL),(5109,2978,41711,303864,3,5109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-29','2020-06-29',5100.47,NULL,NULL,1,'2021-08-27 13:52:14','2021-08-27 13:52:14',NULL),(5110,2978,41711,303864,3,5110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-29','2020-06-29',618.31,NULL,NULL,1,'2021-08-27 13:52:14','2021-08-27 13:52:14',NULL),(5111,2978,41711,303864,3,5111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-29','2020-06-29',5863.87,NULL,NULL,1,'2021-08-27 13:52:14','2021-08-27 13:52:14',NULL),(5112,2978,41711,303864,3,5112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-29','2020-06-29',297.77,NULL,NULL,1,'2021-08-27 13:52:14','2021-08-27 13:52:14',NULL),(5113,2978,41711,303864,3,5113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-29','2020-06-29',239.16,NULL,NULL,1,'2021-08-27 13:52:14','2021-08-27 13:52:14',NULL),(5114,2978,41711,303864,3,5114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-29','2020-06-29',1359.37,NULL,NULL,1,'2021-08-27 13:52:14','2021-08-27 13:52:14',NULL),(5115,2978,41711,303864,3,5115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-29','2020-06-29',3201.57,NULL,NULL,1,'2021-08-27 13:52:14','2021-08-27 13:52:14',NULL),(5116,2978,41711,303864,3,5116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',7247.09,NULL,NULL,1,'2021-08-27 13:52:14','2021-08-27 13:52:14',NULL),(5117,2978,41711,303864,3,5117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',4157.57,NULL,NULL,1,'2021-08-27 13:52:14','2021-08-27 13:52:14',NULL),(5118,2978,41711,303864,3,5118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',1515.46,NULL,NULL,1,'2021-08-27 13:52:14','2021-08-27 13:52:14',NULL),(5119,2978,41711,303864,3,5119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',7423.05,NULL,NULL,1,'2021-08-27 13:52:14','2021-08-27 13:52:14',NULL),(5120,2978,41711,303864,3,5120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-06-30','2020-06-30',1519.05,NULL,NULL,1,'2021-08-27 13:52:14','2021-08-27 13:52:14',NULL),(5121,2978,41711,303865,3,5121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-01','2020-07-01',2461.27,NULL,NULL,1,'2021-08-27 13:53:06','2021-08-27 13:53:06',NULL),(5122,2978,41711,303865,3,5122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-01','2020-07-01',16266.21,NULL,NULL,1,'2021-08-27 13:53:06','2021-08-27 13:53:06',NULL),(5123,2978,41711,303865,3,5123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-01','2020-07-01',513.91,NULL,NULL,1,'2021-08-27 13:53:06','2021-08-27 13:53:06',NULL),(5124,2978,41711,303865,3,5124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-01','2020-07-01',16787.05,NULL,NULL,1,'2021-08-27 13:53:06','2021-08-27 13:53:06',NULL),(5125,2978,41711,303865,3,5125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-01','2020-07-01',2119.92,NULL,NULL,1,'2021-08-27 13:53:06','2021-08-27 13:53:06',NULL),(5126,2978,41711,303865,3,5126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-02','2020-07-02',9278.17,NULL,NULL,1,'2021-08-27 13:53:07','2021-08-27 13:53:07',NULL),(5127,2978,41711,303865,3,5127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-02','2020-07-02',9760.60,NULL,NULL,1,'2021-08-27 13:53:07','2021-08-27 13:53:07',NULL),(5128,2978,41711,303865,3,5128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-02','2020-07-02',177.55,NULL,NULL,1,'2021-08-27 13:53:07','2021-08-27 13:53:07',NULL),(5129,2978,41711,303865,3,5129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-02','2020-07-02',7505.61,NULL,NULL,1,'2021-08-27 13:53:07','2021-08-27 13:53:07',NULL),(5130,2978,41711,303865,3,5130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-02','2020-07-02',741.10,NULL,NULL,1,'2021-08-27 13:53:07','2021-08-27 13:53:07',NULL);
INSERT INTO `balance_libro` VALUES (5131,2978,41711,303865,3,5131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-02','2020-07-02',802.75,NULL,NULL,1,'2021-08-27 13:53:07','2021-08-27 13:53:07',NULL),(5132,2978,41711,303865,3,5132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-02','2020-07-02',123.50,NULL,NULL,1,'2021-08-27 13:53:07','2021-08-27 13:53:07',NULL),(5133,2978,41711,303865,3,5133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-02','2020-07-02',770.03,NULL,NULL,1,'2021-08-27 13:53:07','2021-08-27 13:53:07',NULL),(5134,2978,41711,303865,3,5134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-03','2020-07-03',300.00,NULL,NULL,1,'2021-08-27 13:53:07','2021-08-27 13:53:07',NULL),(5135,2978,41711,303865,3,5135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-03','2020-07-03',11987.14,NULL,NULL,1,'2021-08-27 13:53:07','2021-08-27 13:53:07',NULL),(5136,2978,41711,303865,3,5136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-03','2020-07-03',8415.09,NULL,NULL,1,'2021-08-27 13:53:07','2021-08-27 13:53:07',NULL),(5137,2978,41711,303865,3,5137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-03','2020-07-03',98.39,NULL,NULL,1,'2021-08-27 13:53:07','2021-08-27 13:53:07',NULL),(5138,2978,41711,303865,3,5138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-03','2020-07-03',1400.89,NULL,NULL,1,'2021-08-27 13:53:07','2021-08-27 13:53:07',NULL),(5139,2978,41711,303865,3,5139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-03','2020-07-03',2000.26,NULL,NULL,1,'2021-08-27 13:53:07','2021-08-27 13:53:07',NULL),(5140,2978,41711,303865,3,5140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-03','2020-07-03',2908.24,NULL,NULL,1,'2021-08-27 13:53:07','2021-08-27 13:53:07',NULL),(5141,2978,41711,303865,3,5141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-05','2020-07-05',16750.44,NULL,NULL,1,'2021-08-27 13:53:07','2021-08-27 13:53:07',NULL),(5142,2978,41711,303865,3,5142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-05','2020-07-05',1110.08,NULL,NULL,1,'2021-08-27 13:53:07','2021-08-27 13:53:07',NULL),(5143,2978,41711,303865,3,5143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-06','2020-07-06',2969.74,NULL,NULL,1,'2021-08-27 13:53:07','2021-08-27 13:53:07',NULL),(5144,2978,41711,303865,3,5144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-06','2020-07-06',1350.96,NULL,NULL,1,'2021-08-27 13:53:07','2021-08-27 13:53:07',NULL),(5145,2978,41711,303865,3,5145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-06','2020-07-06',1837.68,NULL,NULL,1,'2021-08-27 13:53:07','2021-08-27 13:53:07',NULL),(5146,2978,41711,303865,3,5146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-06','2020-07-06',512.22,NULL,NULL,1,'2021-08-27 13:53:07','2021-08-27 13:53:07',NULL),(5147,2978,41711,303865,3,5147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-06','2020-07-06',13114.54,NULL,NULL,1,'2021-08-27 13:53:08','2021-08-27 13:53:08',NULL),(5148,2978,41711,303865,3,5148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-06','2020-07-06',1932.00,NULL,NULL,1,'2021-08-27 13:53:08','2021-08-27 13:53:08',NULL),(5149,2978,41711,303865,3,5149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-06','2020-07-06',225.07,NULL,NULL,1,'2021-08-27 13:53:08','2021-08-27 13:53:08',NULL),(5150,2978,41711,303865,3,5150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-06','2020-07-06',218.02,NULL,NULL,1,'2021-08-27 13:53:08','2021-08-27 13:53:08',NULL),(5151,2978,41711,303865,3,5151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-06','2020-07-06',2824.60,NULL,NULL,1,'2021-08-27 13:53:08','2021-08-27 13:53:08',NULL),(5152,2978,41711,303865,3,5152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-06','2020-07-06',640.33,NULL,NULL,1,'2021-08-27 13:53:08','2021-08-27 13:53:08',NULL),(5153,2978,41711,303865,3,5153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-07','2020-07-07',336.11,NULL,NULL,1,'2021-08-27 13:53:08','2021-08-27 13:53:08',NULL),(5154,2978,41711,303865,3,5154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-07','2020-07-07',2441.60,NULL,NULL,1,'2021-08-27 13:53:08','2021-08-27 13:53:08',NULL);
INSERT INTO `balance_libro` VALUES (5155,2978,41711,303865,3,5155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-07','2020-07-07',12425.90,NULL,NULL,1,'2021-08-27 13:53:08','2021-08-27 13:53:08',NULL),(5156,2978,41711,303865,3,5156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-07','2020-07-07',330.79,NULL,NULL,1,'2021-08-27 13:53:08','2021-08-27 13:53:08',NULL),(5157,2978,41711,303865,3,5157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-07','2020-07-07',69.14,NULL,NULL,1,'2021-08-27 13:53:08','2021-08-27 13:53:08',NULL),(5158,2978,41711,303865,3,5158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-07','2020-07-07',1949.32,NULL,NULL,1,'2021-08-27 13:53:08','2021-08-27 13:53:08',NULL),(5159,2978,41711,303865,3,5159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-07','2020-07-07',2788.62,NULL,NULL,1,'2021-08-27 13:53:08','2021-08-27 13:53:08',NULL),(5160,2978,41711,303865,3,5160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-08','2020-07-08',571.29,NULL,NULL,1,'2021-08-27 13:53:08','2021-08-27 13:53:08',NULL),(5161,2978,41711,303865,3,5161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-08','2020-07-08',1932.00,NULL,NULL,1,'2021-08-27 13:53:08','2021-08-27 13:53:08',NULL),(5162,2978,41711,303865,3,5162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-08','2020-07-08',392.05,NULL,NULL,1,'2021-08-27 13:53:08','2021-08-27 13:53:08',NULL),(5163,2978,41711,303865,3,5163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-08','2020-07-08',416.44,NULL,NULL,1,'2021-08-27 13:53:08','2021-08-27 13:53:08',NULL),(5164,2978,41711,303865,3,5164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-08','2020-07-08',5594.29,NULL,NULL,1,'2021-08-27 13:53:08','2021-08-27 13:53:08',NULL),(5165,2978,41711,303865,3,5165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-08','2020-07-08',685.65,NULL,NULL,1,'2021-08-27 13:53:08','2021-08-27 13:53:08',NULL),(5166,2978,41711,303865,3,5166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-08','2020-07-08',19358.86,NULL,NULL,1,'2021-08-27 13:53:08','2021-08-27 13:53:08',NULL),(5167,2978,41711,303865,3,5167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-08','2020-07-08',18882.24,NULL,NULL,1,'2021-08-27 13:53:08','2021-08-27 13:53:08',NULL),(5168,2978,41711,303865,3,5168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-08','2020-07-08',9139.82,NULL,NULL,1,'2021-08-27 13:53:08','2021-08-27 13:53:08',NULL),(5169,2978,41711,303865,3,5169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-08','2020-07-08',1340.79,NULL,NULL,1,'2021-08-27 13:53:08','2021-08-27 13:53:08',NULL),(5170,2978,41711,303865,3,5170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-08','2020-07-08',755.02,NULL,NULL,1,'2021-08-27 13:53:09','2021-08-27 13:53:09',NULL),(5171,2978,41711,303865,3,5171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-09','2020-07-09',1698.99,NULL,NULL,1,'2021-08-27 13:53:09','2021-08-27 13:53:09',NULL),(5172,2978,41711,303865,3,5172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-09','2020-07-09',2037.69,NULL,NULL,1,'2021-08-27 13:53:09','2021-08-27 13:53:09',NULL),(5173,2978,41711,303865,3,5173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-09','2020-07-09',324.10,NULL,NULL,1,'2021-08-27 13:53:09','2021-08-27 13:53:09',NULL),(5174,2978,41711,303865,3,5174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-10','2020-07-10',1694.03,NULL,NULL,1,'2021-08-27 13:53:09','2021-08-27 13:53:09',NULL),(5175,2978,41711,303865,3,5175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-10','2020-07-10',25087.06,NULL,NULL,1,'2021-08-27 13:53:09','2021-08-27 13:53:09',NULL),(5176,2978,41711,303865,3,5176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-10','2020-07-10',69.14,NULL,NULL,1,'2021-08-27 13:53:09','2021-08-27 13:53:09',NULL),(5177,2978,41711,303865,3,5177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-10','2020-07-10',1124.49,NULL,NULL,1,'2021-08-27 13:53:09','2021-08-27 13:53:09',NULL),(5178,2978,41711,303865,3,5178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-11','2020-07-11',867.44,NULL,NULL,1,'2021-08-27 13:53:09','2021-08-27 13:53:09',NULL);
INSERT INTO `balance_libro` VALUES (5179,2978,41711,303865,3,5179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-11','2020-07-11',849.48,NULL,NULL,1,'2021-08-27 13:53:09','2021-08-27 13:53:09',NULL),(5180,2978,41711,303865,3,5180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-12','2020-07-12',9451.36,NULL,NULL,1,'2021-08-27 13:53:09','2021-08-27 13:53:09',NULL),(5181,2978,41711,303865,3,5181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-12','2020-07-12',462.37,NULL,NULL,1,'2021-08-27 13:53:09','2021-08-27 13:53:09',NULL),(5182,2978,41711,303865,3,5182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-13','2020-07-13',3051.81,NULL,NULL,1,'2021-08-27 13:53:09','2021-08-27 13:53:09',NULL),(5183,2978,41711,303865,3,5183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-13','2020-07-13',833.48,NULL,NULL,1,'2021-08-27 13:53:09','2021-08-27 13:53:09',NULL),(5184,2978,41711,303865,3,5184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-13','2020-07-13',299.62,NULL,NULL,1,'2021-08-27 13:53:09','2021-08-27 13:53:09',NULL),(5185,2978,41711,303865,3,5185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-13','2020-07-13',8869.08,NULL,NULL,1,'2021-08-27 13:53:09','2021-08-27 13:53:09',NULL),(5186,2978,41711,303865,3,5186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-13','2020-07-13',10675.06,NULL,NULL,1,'2021-08-27 13:53:09','2021-08-27 13:53:09',NULL),(5187,2978,41711,303865,3,5187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-13','2020-07-13',2482.84,NULL,NULL,1,'2021-08-27 13:53:09','2021-08-27 13:53:09',NULL),(5188,2978,41711,303865,3,5188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-13','2020-07-13',3463.37,NULL,NULL,1,'2021-08-27 13:53:09','2021-08-27 13:53:09',NULL),(5189,2978,41711,303865,3,5189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-14','2020-07-14',1838.30,NULL,NULL,1,'2021-08-27 13:53:09','2021-08-27 13:53:09',NULL),(5190,2978,41711,303865,3,5190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-14','2020-07-14',4042.38,NULL,NULL,1,'2021-08-27 13:53:09','2021-08-27 13:53:09',NULL),(5191,2978,41711,303865,3,5191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-14','2020-07-14',689.79,NULL,NULL,1,'2021-08-27 13:53:09','2021-08-27 13:53:09',NULL),(5192,2978,41711,303865,3,5192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-14','2020-07-14',560.58,NULL,NULL,1,'2021-08-27 13:53:09','2021-08-27 13:53:09',NULL),(5193,2978,41711,303865,3,5193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-14','2020-07-14',8584.10,NULL,NULL,1,'2021-08-27 13:53:10','2021-08-27 13:53:10',NULL),(5194,2978,41711,303865,3,5194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-14','2020-07-14',312.33,NULL,NULL,1,'2021-08-27 13:53:10','2021-08-27 13:53:10',NULL),(5195,2978,41711,303865,3,5195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-14','2020-07-14',610.38,NULL,NULL,1,'2021-08-27 13:53:10','2021-08-27 13:53:10',NULL),(5196,2978,41711,303865,3,5196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-15','2020-07-15',1716.34,NULL,NULL,1,'2021-08-27 13:53:10','2021-08-27 13:53:10',NULL),(5197,2978,41711,303865,3,5197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-15','2020-07-15',975.33,NULL,NULL,1,'2021-08-27 13:53:10','2021-08-27 13:53:10',NULL),(5198,2978,41711,303865,3,5198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-15','2020-07-15',159.44,NULL,NULL,1,'2021-08-27 13:53:10','2021-08-27 13:53:10',NULL),(5199,2978,41711,303865,3,5199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-15','2020-07-15',1088.21,NULL,NULL,1,'2021-08-27 13:53:10','2021-08-27 13:53:10',NULL),(5200,2978,41711,303865,3,5200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-15','2020-07-15',4499.71,NULL,NULL,1,'2021-08-27 13:53:10','2021-08-27 13:53:10',NULL),(5201,2978,41711,303865,3,5201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-15','2020-07-15',7310.05,NULL,NULL,1,'2021-08-27 13:53:10','2021-08-27 13:53:10',NULL),(5202,2978,41711,303865,3,5202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-16','2020-07-16',196.29,NULL,NULL,1,'2021-08-27 13:53:10','2021-08-27 13:53:10',NULL);
INSERT INTO `balance_libro` VALUES (5203,2978,41711,303865,3,5203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-16','2020-07-16',258.34,NULL,NULL,1,'2021-08-27 13:53:10','2021-08-27 13:53:10',NULL),(5204,2978,41711,303865,3,5204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-16','2020-07-16',2279.25,NULL,NULL,1,'2021-08-27 13:53:10','2021-08-27 13:53:10',NULL),(5205,2978,41711,303865,3,5205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-16','2020-07-16',625.58,NULL,NULL,1,'2021-08-27 13:53:10','2021-08-27 13:53:10',NULL),(5206,2978,41711,303865,3,5206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-16','2020-07-16',978.88,NULL,NULL,1,'2021-08-27 13:53:10','2021-08-27 13:53:10',NULL),(5207,2978,41711,303865,3,5207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-16','2020-07-16',4636.25,NULL,NULL,1,'2021-08-27 13:53:10','2021-08-27 13:53:10',NULL),(5208,2978,41711,303865,3,5208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-16','2020-07-16',5279.64,NULL,NULL,1,'2021-08-27 13:53:10','2021-08-27 13:53:10',NULL),(5209,2978,41711,303865,3,5209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-16','2020-07-16',147.81,NULL,NULL,1,'2021-08-27 13:53:10','2021-08-27 13:53:10',NULL),(5210,2978,41711,303865,3,5210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-17','2020-07-17',6549.75,NULL,NULL,1,'2021-08-27 13:53:10','2021-08-27 13:53:10',NULL),(5211,2978,41711,303865,3,5211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-17','2020-07-17',5795.99,NULL,NULL,1,'2021-08-27 13:53:10','2021-08-27 13:53:10',NULL),(5212,2978,41711,303865,3,5212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-17','2020-07-17',8526.69,NULL,NULL,1,'2021-08-27 13:53:10','2021-08-27 13:53:10',NULL),(5213,2978,41711,303865,3,5213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-17','2020-07-17',1061.27,NULL,NULL,1,'2021-08-27 13:53:10','2021-08-27 13:53:10',NULL),(5214,2978,41711,303865,3,5214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-17','2020-07-17',456.95,NULL,NULL,1,'2021-08-27 13:53:10','2021-08-27 13:53:10',NULL),(5215,2978,41711,303865,3,5215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-17','2020-07-17',8327.27,NULL,NULL,1,'2021-08-27 13:53:11','2021-08-27 13:53:11',NULL),(5216,2978,41711,303865,3,5216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-17','2020-07-17',6118.75,NULL,NULL,1,'2021-08-27 13:53:11','2021-08-27 13:53:11',NULL),(5217,2978,41711,303865,3,5217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-17','2020-07-17',1827.62,NULL,NULL,1,'2021-08-27 13:53:11','2021-08-27 13:53:11',NULL),(5218,2978,41711,303865,3,5218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-19','2020-07-19',5925.53,NULL,NULL,1,'2021-08-27 13:53:11','2021-08-27 13:53:11',NULL),(5219,2978,41711,303865,3,5219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-19','2020-07-19',1932.00,NULL,NULL,1,'2021-08-27 13:53:11','2021-08-27 13:53:11',NULL),(5220,2978,41711,303865,3,5220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-19','2020-07-19',4198.72,NULL,NULL,1,'2021-08-27 13:53:11','2021-08-27 13:53:11',NULL),(5221,2978,41711,303865,3,5221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-20','2020-07-20',764.48,NULL,NULL,1,'2021-08-27 13:53:11','2021-08-27 13:53:11',NULL),(5222,2978,41711,303865,3,5222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-20','2020-07-20',10957.34,NULL,NULL,1,'2021-08-27 13:53:11','2021-08-27 13:53:11',NULL),(5223,2978,41711,303865,3,5223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-20','2020-07-20',1191.06,NULL,NULL,1,'2021-08-27 13:53:11','2021-08-27 13:53:11',NULL),(5224,2978,41711,303865,3,5224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-20','2020-07-20',16843.96,NULL,NULL,1,'2021-08-27 13:53:11','2021-08-27 13:53:11',NULL),(5225,2978,41711,303865,3,5225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-20','2020-07-20',502.68,NULL,NULL,1,'2021-08-27 13:53:11','2021-08-27 13:53:11',NULL),(5226,2978,41711,303865,3,5226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-20','2020-07-20',3677.33,NULL,NULL,1,'2021-08-27 13:53:11','2021-08-27 13:53:11',NULL);
INSERT INTO `balance_libro` VALUES (5227,2978,41711,303865,3,5227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-20','2020-07-20',2147.67,NULL,NULL,1,'2021-08-27 13:53:11','2021-08-27 13:53:11',NULL),(5228,2978,41711,303865,3,5228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-21','2020-07-21',6711.98,NULL,NULL,1,'2021-08-27 13:53:11','2021-08-27 13:53:11',NULL),(5229,2978,41711,303865,3,5229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-21','2020-07-21',3861.38,NULL,NULL,1,'2021-08-27 13:53:11','2021-08-27 13:53:11',NULL),(5230,2978,41711,303865,3,5230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-21','2020-07-21',1932.00,NULL,NULL,1,'2021-08-27 13:53:11','2021-08-27 13:53:11',NULL),(5231,2978,41711,303865,3,5231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-21','2020-07-21',1149.49,NULL,NULL,1,'2021-08-27 13:53:11','2021-08-27 13:53:11',NULL),(5232,2978,41711,303865,3,5232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-21','2020-07-21',891.25,NULL,NULL,1,'2021-08-27 13:53:11','2021-08-27 13:53:11',NULL),(5233,2978,41711,303865,3,5233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-21','2020-07-21',1434.53,NULL,NULL,1,'2021-08-27 13:53:11','2021-08-27 13:53:11',NULL),(5234,2978,41711,303865,3,5234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-22','2020-07-22',0.02,NULL,NULL,1,'2021-08-27 13:53:11','2021-08-27 13:53:11',NULL),(5235,2978,41711,303865,3,5235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-22','2020-07-22',12928.17,NULL,NULL,1,'2021-08-27 13:53:11','2021-08-27 13:53:11',NULL),(5236,2978,41711,303865,3,5236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-22','2020-07-22',125.57,NULL,NULL,1,'2021-08-27 13:53:11','2021-08-27 13:53:11',NULL),(5237,2978,41711,303865,3,5237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-22','2020-07-22',3036.34,NULL,NULL,1,'2021-08-27 13:53:12','2021-08-27 13:53:12',NULL),(5238,2978,41711,303865,3,5238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-22','2020-07-22',7774.93,NULL,NULL,1,'2021-08-27 13:53:12','2021-08-27 13:53:12',NULL),(5239,2978,41711,303865,3,5239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-22','2020-07-22',681.64,NULL,NULL,1,'2021-08-27 13:53:12','2021-08-27 13:53:12',NULL),(5240,2978,41711,303865,3,5240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-22','2020-07-22',2274.34,NULL,NULL,1,'2021-08-27 13:53:12','2021-08-27 13:53:12',NULL),(5241,2978,41711,303865,3,5241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-23','2020-07-23',39291.46,NULL,NULL,1,'2021-08-27 13:53:12','2021-08-27 13:53:12',NULL),(5242,2978,41711,303865,3,5242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-23','2020-07-23',3799.87,NULL,NULL,1,'2021-08-27 13:53:12','2021-08-27 13:53:12',NULL),(5243,2978,41711,303865,3,5243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-23','2020-07-23',1221.96,NULL,NULL,1,'2021-08-27 13:53:12','2021-08-27 13:53:12',NULL),(5244,2978,41711,303865,3,5244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-23','2020-07-23',2358.68,NULL,NULL,1,'2021-08-27 13:53:12','2021-08-27 13:53:12',NULL),(5245,2978,41711,303865,3,5245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-24','2020-07-24',835.85,NULL,NULL,1,'2021-08-27 13:53:12','2021-08-27 13:53:12',NULL),(5246,2978,41711,303865,3,5246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-24','2020-07-24',1932.00,NULL,NULL,1,'2021-08-27 13:53:12','2021-08-27 13:53:12',NULL),(5247,2978,41711,303865,3,5247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-24','2020-07-24',4742.73,NULL,NULL,1,'2021-08-27 13:53:12','2021-08-27 13:53:12',NULL),(5248,2978,41711,303865,3,5248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-24','2020-07-24',370.45,NULL,NULL,1,'2021-08-27 13:53:12','2021-08-27 13:53:12',NULL),(5249,2978,41711,303865,3,5249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-24','2020-07-24',7760.35,NULL,NULL,1,'2021-08-27 13:53:12','2021-08-27 13:53:12',NULL),(5250,2978,41711,303865,3,5250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-24','2020-07-24',905.51,NULL,NULL,1,'2021-08-27 13:53:12','2021-08-27 13:53:12',NULL);
INSERT INTO `balance_libro` VALUES (5251,2978,41711,303865,3,5251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-26','2020-07-26',4171.88,NULL,NULL,1,'2021-08-27 13:53:12','2021-08-27 13:53:12',NULL),(5252,2978,41711,303865,3,5252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-26','2020-07-26',78.74,NULL,NULL,1,'2021-08-27 13:53:12','2021-08-27 13:53:12',NULL),(5253,2978,41711,303865,3,5253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-27','2020-07-27',6275.14,NULL,NULL,1,'2021-08-27 13:53:12','2021-08-27 13:53:12',NULL),(5254,2978,41711,303865,3,5254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-27','2020-07-27',12511.53,NULL,NULL,1,'2021-08-27 13:53:12','2021-08-27 13:53:12',NULL),(5255,2978,41711,303865,3,5255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-27','2020-07-27',182.59,NULL,NULL,1,'2021-08-27 13:53:12','2021-08-27 13:53:12',NULL),(5256,2978,41711,303865,3,5256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-28','2020-07-28',8081.16,NULL,NULL,1,'2021-08-27 13:53:12','2021-08-27 13:53:12',NULL),(5257,2978,41711,303865,3,5257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-28','2020-07-28',741.88,NULL,NULL,1,'2021-08-27 13:53:12','2021-08-27 13:53:12',NULL),(5258,2978,41711,303865,3,5258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-28','2020-07-28',2762.17,NULL,NULL,1,'2021-08-27 13:53:12','2021-08-27 13:53:12',NULL),(5259,2978,41711,303865,3,5259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-28','2020-07-28',336.67,NULL,NULL,1,'2021-08-27 13:53:12','2021-08-27 13:53:12',NULL),(5260,2978,41711,303865,3,5260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-28','2020-07-28',360.33,NULL,NULL,1,'2021-08-27 13:53:13','2021-08-27 13:53:13',NULL),(5261,2978,41711,303865,3,5261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-29','2020-07-29',11501.09,NULL,NULL,1,'2021-08-27 13:53:13','2021-08-27 13:53:13',NULL),(5262,2978,41711,303865,3,5262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-29','2020-07-29',392.05,NULL,NULL,1,'2021-08-27 13:53:13','2021-08-27 13:53:13',NULL),(5263,2978,41711,303865,3,5263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-29','2020-07-29',1375.61,NULL,NULL,1,'2021-08-27 13:53:13','2021-08-27 13:53:13',NULL),(5264,2978,41711,303865,3,5264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-29','2020-07-29',5380.34,NULL,NULL,1,'2021-08-27 13:53:13','2021-08-27 13:53:13',NULL),(5265,2978,41711,303865,3,5265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-29','2020-07-29',1364.57,NULL,NULL,1,'2021-08-27 13:53:13','2021-08-27 13:53:13',NULL),(5266,2978,41711,303865,3,5266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-29','2020-07-29',295.18,NULL,NULL,1,'2021-08-27 13:53:13','2021-08-27 13:53:13',NULL),(5267,2978,41711,303865,3,5267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-29','2020-07-29',552.92,NULL,NULL,1,'2021-08-27 13:53:13','2021-08-27 13:53:13',NULL),(5268,2978,41711,303865,3,5268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-29','2020-07-29',2861.65,NULL,NULL,1,'2021-08-27 13:53:13','2021-08-27 13:53:13',NULL),(5269,2978,41711,303865,3,5269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-30','2020-07-30',2350.87,NULL,NULL,1,'2021-08-27 13:53:13','2021-08-27 13:53:13',NULL),(5270,2978,41711,303865,3,5270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-30','2020-07-30',0.01,NULL,NULL,1,'2021-08-27 13:53:13','2021-08-27 13:53:13',NULL),(5271,2978,41711,303865,3,5271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-30','2020-07-30',7529.15,NULL,NULL,1,'2021-08-27 13:53:13','2021-08-27 13:53:13',NULL),(5272,2978,41711,303865,3,5272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-30','2020-07-30',661.90,NULL,NULL,1,'2021-08-27 13:53:13','2021-08-27 13:53:13',NULL),(5273,2978,41711,303865,3,5273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-30','2020-07-30',12540.44,NULL,NULL,1,'2021-08-27 13:53:13','2021-08-27 13:53:13',NULL),(5274,2978,41711,303865,3,5274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-30','2020-07-30',1082.98,NULL,NULL,1,'2021-08-27 13:53:13','2021-08-27 13:53:13',NULL);
INSERT INTO `balance_libro` VALUES (5275,2978,41711,303865,3,5275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',80.15,NULL,NULL,1,'2021-08-27 13:53:13','2021-08-27 13:53:13',NULL),(5276,2978,41711,303865,3,5276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',6123.58,NULL,NULL,1,'2021-08-27 13:53:13','2021-08-27 13:53:13',NULL),(5277,2978,41711,303865,3,5277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',1191.06,NULL,NULL,1,'2021-08-27 13:53:13','2021-08-27 13:53:13',NULL),(5278,2978,41711,303865,3,5278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',1225.47,NULL,NULL,1,'2021-08-27 13:53:13','2021-08-27 13:53:13',NULL),(5279,2978,41711,303865,3,5279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',11394.75,NULL,NULL,1,'2021-08-27 13:53:13','2021-08-27 13:53:13',NULL),(5280,2978,41711,303865,3,5280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',432.25,NULL,NULL,1,'2021-08-27 13:53:13','2021-08-27 13:53:13',NULL),(5281,2978,41711,303865,3,5281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',2157.97,NULL,NULL,1,'2021-08-27 13:53:13','2021-08-27 13:53:13',NULL),(5282,2978,41711,303865,3,5282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',634.00,NULL,NULL,1,'2021-08-27 13:53:13','2021-08-27 13:53:13',NULL),(5283,2978,41711,303865,3,5283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',8500.00,NULL,NULL,1,'2021-08-27 13:53:14','2021-08-27 13:53:14',NULL),(5284,2978,41711,303865,3,5284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-07-31','2020-07-31',1704.30,NULL,NULL,1,'2021-08-27 13:53:14','2021-08-27 13:53:14',NULL),(5285,2978,41711,303866,3,5285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-01','2020-08-01',2119.92,NULL,NULL,1,'2021-08-27 13:53:57','2021-08-27 13:53:57',NULL),(5286,2978,41711,303866,3,5286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-03','2020-08-03',913.18,NULL,NULL,1,'2021-08-27 13:53:57','2021-08-27 13:53:57',NULL),(5287,2978,41711,303866,3,5287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-03','2020-08-03',98.10,NULL,NULL,1,'2021-08-27 13:53:57','2021-08-27 13:53:57',NULL),(5288,2978,41711,303866,3,5288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-03','2020-08-03',6879.59,NULL,NULL,1,'2021-08-27 13:53:57','2021-08-27 13:53:57',NULL),(5289,2978,41711,303866,3,5289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-03','2020-08-03',7182.18,NULL,NULL,1,'2021-08-27 13:53:57','2021-08-27 13:53:57',NULL),(5290,2978,41711,303866,3,5290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-03','2020-08-03',3583.53,NULL,NULL,1,'2021-08-27 13:53:57','2021-08-27 13:53:57',NULL),(5291,2978,41711,303866,3,5291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-03','2020-08-03',156.95,NULL,NULL,1,'2021-08-27 13:53:58','2021-08-27 13:53:58',NULL),(5292,2978,41711,303866,3,5292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-04','2020-08-04',720.00,NULL,NULL,1,'2021-08-27 13:53:58','2021-08-27 13:53:58',NULL),(5293,2978,41711,303866,3,5293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-04','2020-08-04',12169.94,NULL,NULL,1,'2021-08-27 13:53:58','2021-08-27 13:53:58',NULL),(5294,2978,41711,303866,3,5294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-04','2020-08-04',404.54,NULL,NULL,1,'2021-08-27 13:53:58','2021-08-27 13:53:58',NULL),(5295,2978,41711,303866,3,5295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-04','2020-08-04',21138.18,NULL,NULL,1,'2021-08-27 13:53:58','2021-08-27 13:53:58',NULL),(5296,2978,41711,303866,3,5296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-04','2020-08-04',4707.02,NULL,NULL,1,'2021-08-27 13:53:58','2021-08-27 13:53:58',NULL),(5297,2978,41711,303866,3,5297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-04','2020-08-04',1101.50,NULL,NULL,1,'2021-08-27 13:53:58','2021-08-27 13:53:58',NULL),(5298,2978,41711,303866,3,5298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-04','2020-08-04',330.85,NULL,NULL,1,'2021-08-27 13:53:58','2021-08-27 13:53:58',NULL);
INSERT INTO `balance_libro` VALUES (5299,2978,41711,303866,3,5299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-04','2020-08-04',266.29,NULL,NULL,1,'2021-08-27 13:53:58','2021-08-27 13:53:58',NULL),(5300,2978,41711,303866,3,5300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-04','2020-08-04',241.85,NULL,NULL,1,'2021-08-27 13:53:58','2021-08-27 13:53:58',NULL),(5301,2978,41711,303866,3,5301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-04','2020-08-04',186.48,NULL,NULL,1,'2021-08-27 13:53:58','2021-08-27 13:53:58',NULL),(5302,2978,41711,303866,3,5302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-04','2020-08-04',43452.67,NULL,NULL,1,'2021-08-27 13:53:58','2021-08-27 13:53:58',NULL),(5303,2978,41711,303866,3,5303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-04','2020-08-04',158.53,NULL,NULL,1,'2021-08-27 13:53:58','2021-08-27 13:53:58',NULL),(5304,2978,41711,303866,3,5304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-04','2020-08-04',189.61,NULL,NULL,1,'2021-08-27 13:53:58','2021-08-27 13:53:58',NULL),(5305,2978,41711,303866,3,5305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-04','2020-08-04',615.37,NULL,NULL,1,'2021-08-27 13:53:58','2021-08-27 13:53:58',NULL),(5306,2978,41711,303866,3,5306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-04','2020-08-04',162.14,NULL,NULL,1,'2021-08-27 13:53:58','2021-08-27 13:53:58',NULL),(5307,2978,41711,303866,3,5307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-04','2020-08-04',1911.92,NULL,NULL,1,'2021-08-27 13:53:58','2021-08-27 13:53:58',NULL),(5308,2978,41711,303866,3,5308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-04','2020-08-04',1443.82,NULL,NULL,1,'2021-08-27 13:53:58','2021-08-27 13:53:58',NULL),(5309,2978,41711,303866,3,5309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-04','2020-08-04',15376.96,NULL,NULL,1,'2021-08-27 13:53:58','2021-08-27 13:53:58',NULL),(5310,2978,41711,303866,3,5310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-04','2020-08-04',3186.12,NULL,NULL,1,'2021-08-27 13:53:58','2021-08-27 13:53:58',NULL),(5311,2978,41711,303866,3,5311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-04','2020-08-04',2965.71,NULL,NULL,1,'2021-08-27 13:53:58','2021-08-27 13:53:58',NULL),(5312,2978,41711,303866,3,5312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-05','2020-08-05',14546.00,NULL,NULL,1,'2021-08-27 13:53:58','2021-08-27 13:53:58',NULL),(5313,2978,41711,303866,3,5313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-05','2020-08-05',1979.85,NULL,NULL,1,'2021-08-27 13:53:58','2021-08-27 13:53:58',NULL),(5314,2978,41711,303866,3,5314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-05','2020-08-05',333.45,NULL,NULL,1,'2021-08-27 13:53:58','2021-08-27 13:53:58',NULL),(5315,2978,41711,303866,3,5315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-05','2020-08-05',78.55,NULL,NULL,1,'2021-08-27 13:53:58','2021-08-27 13:53:58',NULL),(5316,2978,41711,303866,3,5316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-05','2020-08-05',113.71,NULL,NULL,1,'2021-08-27 13:53:58','2021-08-27 13:53:58',NULL),(5317,2978,41711,303866,3,5317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-05','2020-08-05',324.56,NULL,NULL,1,'2021-08-27 13:53:59','2021-08-27 13:53:59',NULL),(5318,2978,41711,303866,3,5318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-05','2020-08-05',13394.17,NULL,NULL,1,'2021-08-27 13:53:59','2021-08-27 13:53:59',NULL),(5319,2978,41711,303866,3,5319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-05','2020-08-05',4018.98,NULL,NULL,1,'2021-08-27 13:53:59','2021-08-27 13:53:59',NULL),(5320,2978,41711,303866,3,5320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-06','2020-08-06',2476.00,NULL,NULL,1,'2021-08-27 13:53:59','2021-08-27 13:53:59',NULL),(5321,2978,41711,303866,3,5321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-06','2020-08-06',7923.69,NULL,NULL,1,'2021-08-27 13:53:59','2021-08-27 13:53:59',NULL),(5322,2978,41711,303866,3,5322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-07','2020-08-07',17672.80,NULL,NULL,1,'2021-08-27 13:53:59','2021-08-27 13:53:59',NULL);
INSERT INTO `balance_libro` VALUES (5323,2978,41711,303866,3,5323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-07','2020-08-07',432.25,NULL,NULL,1,'2021-08-27 13:53:59','2021-08-27 13:53:59',NULL),(5324,2978,41711,303866,3,5324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-07','2020-08-07',713.47,NULL,NULL,1,'2021-08-27 13:53:59','2021-08-27 13:53:59',NULL),(5325,2978,41711,303866,3,5325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-07','2020-08-07',274.96,NULL,NULL,1,'2021-08-27 13:53:59','2021-08-27 13:53:59',NULL),(5326,2978,41711,303866,3,5326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-07','2020-08-07',300.00,NULL,NULL,1,'2021-08-27 13:53:59','2021-08-27 13:53:59',NULL),(5327,2978,41711,303866,3,5327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-07','2020-08-07',45.29,NULL,NULL,1,'2021-08-27 13:53:59','2021-08-27 13:53:59',NULL),(5328,2978,41711,303866,3,5328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-07','2020-08-07',3779.76,NULL,NULL,1,'2021-08-27 13:53:59','2021-08-27 13:53:59',NULL),(5329,2978,41711,303866,3,5329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-07','2020-08-07',540.01,NULL,NULL,1,'2021-08-27 13:53:59','2021-08-27 13:53:59',NULL),(5330,2978,41711,303866,3,5330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-09','2020-08-09',8197.79,NULL,NULL,1,'2021-08-27 13:53:59','2021-08-27 13:53:59',NULL),(5331,2978,41711,303866,3,5331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-09','2020-08-09',1993.41,NULL,NULL,1,'2021-08-27 13:53:59','2021-08-27 13:53:59',NULL),(5332,2978,41711,303866,3,5332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-09','2020-08-09',767.28,NULL,NULL,1,'2021-08-27 13:53:59','2021-08-27 13:53:59',NULL),(5333,2978,41711,303866,3,5333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-09','2020-08-09',982.12,NULL,NULL,1,'2021-08-27 13:53:59','2021-08-27 13:53:59',NULL),(5334,2978,41711,303866,3,5334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-10','2020-08-10',7323.22,NULL,NULL,1,'2021-08-27 13:53:59','2021-08-27 13:53:59',NULL),(5335,2978,41711,303866,3,5335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-10','2020-08-10',6791.54,NULL,NULL,1,'2021-08-27 13:53:59','2021-08-27 13:53:59',NULL),(5336,2978,41711,303866,3,5336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-10','2020-08-10',2587.96,NULL,NULL,1,'2021-08-27 13:53:59','2021-08-27 13:53:59',NULL),(5337,2978,41711,303866,3,5337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-10','2020-08-10',29903.11,NULL,NULL,1,'2021-08-27 13:53:59','2021-08-27 13:53:59',NULL),(5338,2978,41711,303866,3,5338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-10','2020-08-10',13081.95,NULL,NULL,1,'2021-08-27 13:53:59','2021-08-27 13:53:59',NULL),(5339,2978,41711,303866,3,5339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-10','2020-08-10',154.85,NULL,NULL,1,'2021-08-27 13:53:59','2021-08-27 13:53:59',NULL),(5340,2978,41711,303866,3,5340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-10','2020-08-10',472.62,NULL,NULL,1,'2021-08-27 13:53:59','2021-08-27 13:53:59',NULL),(5341,2978,41711,303866,3,5341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-10','2020-08-10',863.70,NULL,NULL,1,'2021-08-27 13:54:00','2021-08-27 13:54:00',NULL),(5342,2978,41711,303866,3,5342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-10','2020-08-10',8034.73,NULL,NULL,1,'2021-08-27 13:54:00','2021-08-27 13:54:00',NULL),(5343,2978,41711,303866,3,5343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-10','2020-08-10',30590.00,NULL,NULL,1,'2021-08-27 13:54:00','2021-08-27 13:54:00',NULL),(5344,2978,41711,303866,3,5344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-10','2020-08-10',2473.54,NULL,NULL,1,'2021-08-27 13:54:00','2021-08-27 13:54:00',NULL),(5345,2978,41711,303866,3,5345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-10','2020-08-10',2666.16,NULL,NULL,1,'2021-08-27 13:54:00','2021-08-27 13:54:00',NULL),(5346,2978,41711,303866,3,5346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-11','2020-08-11',1114.58,NULL,NULL,1,'2021-08-27 13:54:00','2021-08-27 13:54:00',NULL);
INSERT INTO `balance_libro` VALUES (5347,2978,41711,303866,3,5347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-11','2020-08-11',374.92,NULL,NULL,1,'2021-08-27 13:54:00','2021-08-27 13:54:00',NULL),(5348,2978,41711,303866,3,5348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-11','2020-08-11',17018.44,NULL,NULL,1,'2021-08-27 13:54:00','2021-08-27 13:54:00',NULL),(5349,2978,41711,303866,3,5349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-11','2020-08-11',327.97,NULL,NULL,1,'2021-08-27 13:54:00','2021-08-27 13:54:00',NULL),(5350,2978,41711,303866,3,5350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-11','2020-08-11',601.75,NULL,NULL,1,'2021-08-27 13:54:00','2021-08-27 13:54:00',NULL),(5351,2978,41711,303866,3,5351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-11','2020-08-11',317.15,NULL,NULL,1,'2021-08-27 13:54:00','2021-08-27 13:54:00',NULL),(5352,2978,41711,303866,3,5352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-11','2020-08-11',601.67,NULL,NULL,1,'2021-08-27 13:54:00','2021-08-27 13:54:00',NULL),(5353,2978,41711,303866,3,5353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-11','2020-08-11',521.48,NULL,NULL,1,'2021-08-27 13:54:00','2021-08-27 13:54:00',NULL),(5354,2978,41711,303866,3,5354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-11','2020-08-11',380.69,NULL,NULL,1,'2021-08-27 13:54:00','2021-08-27 13:54:00',NULL),(5355,2978,41711,303866,3,5355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-11','2020-08-11',9453.06,NULL,NULL,1,'2021-08-27 13:54:00','2021-08-27 13:54:00',NULL),(5356,2978,41711,303866,3,5356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-11','2020-08-11',3237.87,NULL,NULL,1,'2021-08-27 13:54:00','2021-08-27 13:54:00',NULL),(5357,2978,41711,303866,3,5357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-11','2020-08-11',2997.08,NULL,NULL,1,'2021-08-27 13:54:00','2021-08-27 13:54:00',NULL),(5358,2978,41711,303866,3,5358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-11','2020-08-11',2315.20,NULL,NULL,1,'2021-08-27 13:54:00','2021-08-27 13:54:00',NULL),(5359,2978,41711,303866,3,5359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-12','2020-08-12',12797.68,NULL,NULL,1,'2021-08-27 13:54:00','2021-08-27 13:54:00',NULL),(5360,2978,41711,303866,3,5360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-12','2020-08-12',867.51,NULL,NULL,1,'2021-08-27 13:54:00','2021-08-27 13:54:00',NULL),(5361,2978,41711,303866,3,5361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-12','2020-08-12',1874.26,NULL,NULL,1,'2021-08-27 13:54:00','2021-08-27 13:54:00',NULL),(5362,2978,41711,303866,3,5362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-12','2020-08-12',1230.36,NULL,NULL,1,'2021-08-27 13:54:00','2021-08-27 13:54:00',NULL),(5363,2978,41711,303866,3,5363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-12','2020-08-12',958.05,NULL,NULL,1,'2021-08-27 13:54:00','2021-08-27 13:54:00',NULL),(5364,2978,41711,303866,3,5364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-12','2020-08-12',9805.69,NULL,NULL,1,'2021-08-27 13:54:00','2021-08-27 13:54:00',NULL),(5365,2978,41711,303866,3,5365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-12','2020-08-12',1237.30,NULL,NULL,1,'2021-08-27 13:54:01','2021-08-27 13:54:01',NULL),(5366,2978,41711,303866,3,5366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-12','2020-08-12',3084.90,NULL,NULL,1,'2021-08-27 13:54:01','2021-08-27 13:54:01',NULL),(5367,2978,41711,303866,3,5367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-13','2020-08-13',1174.20,NULL,NULL,1,'2021-08-27 13:54:01','2021-08-27 13:54:01',NULL),(5368,2978,41711,303866,3,5368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-13','2020-08-13',5711.88,NULL,NULL,1,'2021-08-27 13:54:01','2021-08-27 13:54:01',NULL),(5369,2978,41711,303866,3,5369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-13','2020-08-13',724.92,NULL,NULL,1,'2021-08-27 13:54:01','2021-08-27 13:54:01',NULL),(5370,2978,41711,303866,3,5370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-13','2020-08-13',17672.26,NULL,NULL,1,'2021-08-27 13:54:01','2021-08-27 13:54:01',NULL);
INSERT INTO `balance_libro` VALUES (5371,2978,41711,303866,3,5371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-13','2020-08-13',901.73,NULL,NULL,1,'2021-08-27 13:54:01','2021-08-27 13:54:01',NULL),(5372,2978,41711,303866,3,5372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-14','2020-08-14',151.16,NULL,NULL,1,'2021-08-27 13:54:01','2021-08-27 13:54:01',NULL),(5373,2978,41711,303866,3,5373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-14','2020-08-14',476.60,NULL,NULL,1,'2021-08-27 13:54:01','2021-08-27 13:54:01',NULL),(5374,2978,41711,303866,3,5374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-14','2020-08-14',3035.38,NULL,NULL,1,'2021-08-27 13:54:01','2021-08-27 13:54:01',NULL),(5375,2978,41711,303866,3,5375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-14','2020-08-14',13270.61,NULL,NULL,1,'2021-08-27 13:54:01','2021-08-27 13:54:01',NULL),(5376,2978,41711,303866,3,5376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-14','2020-08-14',362.79,NULL,NULL,1,'2021-08-27 13:54:01','2021-08-27 13:54:01',NULL),(5377,2978,41711,303866,3,5377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-14','2020-08-14',242.65,NULL,NULL,1,'2021-08-27 13:54:01','2021-08-27 13:54:01',NULL),(5378,2978,41711,303866,3,5378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-14','2020-08-14',80.58,NULL,NULL,1,'2021-08-27 13:54:01','2021-08-27 13:54:01',NULL),(5379,2978,41711,303866,3,5379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-14','2020-08-14',535.12,NULL,NULL,1,'2021-08-27 13:54:01','2021-08-27 13:54:01',NULL),(5380,2978,41711,303866,3,5380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-17','2020-08-17',4316.04,NULL,NULL,1,'2021-08-27 13:54:01','2021-08-27 13:54:01',NULL),(5381,2978,41711,303866,3,5381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-17','2020-08-17',1240.62,NULL,NULL,1,'2021-08-27 13:54:01','2021-08-27 13:54:01',NULL),(5382,2978,41711,303866,3,5382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-18','2020-08-18',639.20,NULL,NULL,1,'2021-08-27 13:54:01','2021-08-27 13:54:01',NULL),(5383,2978,41711,303866,3,5383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-18','2020-08-18',2033.71,NULL,NULL,1,'2021-08-27 13:54:01','2021-08-27 13:54:01',NULL),(5384,2978,41711,303866,3,5384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-18','2020-08-18',723.70,NULL,NULL,1,'2021-08-27 13:54:01','2021-08-27 13:54:01',NULL),(5385,2978,41711,303866,3,5385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-18','2020-08-18',8296.53,NULL,NULL,1,'2021-08-27 13:54:01','2021-08-27 13:54:01',NULL),(5386,2978,41711,303866,3,5386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-18','2020-08-18',1932.00,NULL,NULL,1,'2021-08-27 13:54:02','2021-08-27 13:54:02',NULL),(5387,2978,41711,303866,3,5387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-18','2020-08-18',10952.82,NULL,NULL,1,'2021-08-27 13:54:02','2021-08-27 13:54:02',NULL),(5388,2978,41711,303866,3,5388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-18','2020-08-18',1191.06,NULL,NULL,1,'2021-08-27 13:54:02','2021-08-27 13:54:02',NULL),(5389,2978,41711,303866,3,5389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-18','2020-08-18',17259.16,NULL,NULL,1,'2021-08-27 13:54:02','2021-08-27 13:54:02',NULL),(5390,2978,41711,303866,3,5390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-18','2020-08-18',235.42,NULL,NULL,1,'2021-08-27 13:54:02','2021-08-27 13:54:02',NULL),(5391,2978,41711,303866,3,5391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-19','2020-08-19',3765.12,NULL,NULL,1,'2021-08-27 13:54:02','2021-08-27 13:54:02',NULL),(5392,2978,41711,303866,3,5392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-19','2020-08-19',1085.68,NULL,NULL,1,'2021-08-27 13:54:02','2021-08-27 13:54:02',NULL),(5393,2978,41711,303866,3,5393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-19','2020-08-19',11084.28,NULL,NULL,1,'2021-08-27 13:54:02','2021-08-27 13:54:02',NULL),(5394,2978,41711,303866,3,5394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-19','2020-08-19',432.25,NULL,NULL,1,'2021-08-27 13:54:02','2021-08-27 13:54:02',NULL);
INSERT INTO `balance_libro` VALUES (5395,2978,41711,303866,3,5395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-19','2020-08-19',450.78,NULL,NULL,1,'2021-08-27 13:54:02','2021-08-27 13:54:02',NULL),(5396,2978,41711,303866,3,5396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-19','2020-08-19',891.25,NULL,NULL,1,'2021-08-27 13:54:02','2021-08-27 13:54:02',NULL),(5397,2978,41711,303866,3,5397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-19','2020-08-19',504.00,NULL,NULL,1,'2021-08-27 13:54:02','2021-08-27 13:54:02',NULL),(5398,2978,41711,303866,3,5398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-19','2020-08-19',504.00,NULL,NULL,1,'2021-08-27 13:54:02','2021-08-27 13:54:02',NULL),(5399,2978,41711,303866,3,5399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-20','2020-08-20',978.21,NULL,NULL,1,'2021-08-27 13:54:02','2021-08-27 13:54:02',NULL),(5400,2978,41711,303866,3,5400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-20','2020-08-20',7141.00,NULL,NULL,1,'2021-08-27 13:54:02','2021-08-27 13:54:02',NULL),(5401,2978,41711,303866,3,5401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-20','2020-08-20',511.23,NULL,NULL,1,'2021-08-27 13:54:02','2021-08-27 13:54:02',NULL),(5402,2978,41711,303866,3,5402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-20','2020-08-20',9356.98,NULL,NULL,1,'2021-08-27 13:54:02','2021-08-27 13:54:02',NULL),(5403,2978,41711,303866,3,5403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-20','2020-08-20',3376.00,NULL,NULL,1,'2021-08-27 13:54:02','2021-08-27 13:54:02',NULL),(5404,2978,41711,303866,3,5404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-21','2020-08-21',456.95,NULL,NULL,1,'2021-08-27 13:54:02','2021-08-27 13:54:02',NULL),(5405,2978,41711,303866,3,5405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-21','2020-08-21',3676.47,NULL,NULL,1,'2021-08-27 13:54:02','2021-08-27 13:54:02',NULL),(5406,2978,41711,303866,3,5406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-21','2020-08-21',19185.65,NULL,NULL,1,'2021-08-27 13:54:03','2021-08-27 13:54:03',NULL),(5407,2978,41711,303866,3,5407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-21','2020-08-21',6343.47,NULL,NULL,1,'2021-08-27 13:54:03','2021-08-27 13:54:03',NULL),(5408,2978,41711,303866,3,5408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-21','2020-08-21',1932.00,NULL,NULL,1,'2021-08-27 13:54:03','2021-08-27 13:54:03',NULL),(5409,2978,41711,303866,3,5409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-21','2020-08-21',462.01,NULL,NULL,1,'2021-08-27 13:54:03','2021-08-27 13:54:03',NULL),(5410,2978,41711,303866,3,5410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-21','2020-08-21',8494.27,NULL,NULL,1,'2021-08-27 13:54:03','2021-08-27 13:54:03',NULL),(5411,2978,41711,303866,3,5411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-21','2020-08-21',8059.09,NULL,NULL,1,'2021-08-27 13:54:03','2021-08-27 13:54:03',NULL),(5412,2978,41711,303866,3,5412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-23','2020-08-23',15833.83,NULL,NULL,1,'2021-08-27 13:54:03','2021-08-27 13:54:03',NULL),(5413,2978,41711,303866,3,5413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-23','2020-08-23',620.96,NULL,NULL,1,'2021-08-27 13:54:03','2021-08-27 13:54:03',NULL),(5414,2978,41711,303866,3,5414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-23','2020-08-23',3864.00,NULL,NULL,1,'2021-08-27 13:54:03','2021-08-27 13:54:03',NULL),(5415,2978,41711,303866,3,5415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-23','2020-08-23',147.52,NULL,NULL,1,'2021-08-27 13:54:03','2021-08-27 13:54:03',NULL),(5416,2978,41711,303866,3,5416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-24','2020-08-24',5542.00,NULL,NULL,1,'2021-08-27 13:54:03','2021-08-27 13:54:03',NULL),(5417,2978,41711,303866,3,5417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-24','2020-08-24',518.70,NULL,NULL,1,'2021-08-27 13:54:03','2021-08-27 13:54:03',NULL),(5418,2978,41711,303866,3,5418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-24','2020-08-24',197.62,NULL,NULL,1,'2021-08-27 13:54:03','2021-08-27 13:54:03',NULL);
INSERT INTO `balance_libro` VALUES (5419,2978,41711,303866,3,5419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-24','2020-08-24',4324.69,NULL,NULL,1,'2021-08-27 13:54:03','2021-08-27 13:54:03',NULL),(5420,2978,41711,303866,3,5420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-24','2020-08-24',680.89,NULL,NULL,1,'2021-08-27 13:54:03','2021-08-27 13:54:03',NULL),(5421,2978,41711,303866,3,5421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-24','2020-08-24',6021.97,NULL,NULL,1,'2021-08-27 13:54:03','2021-08-27 13:54:03',NULL),(5422,2978,41711,303866,3,5422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-24','2020-08-24',1558.63,NULL,NULL,1,'2021-08-27 13:54:03','2021-08-27 13:54:03',NULL),(5423,2978,41711,303866,3,5423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-24','2020-08-24',212.23,NULL,NULL,1,'2021-08-27 13:54:03','2021-08-27 13:54:03',NULL),(5424,2978,41711,303866,3,5424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-24','2020-08-24',4571.91,NULL,NULL,1,'2021-08-27 13:54:03','2021-08-27 13:54:03',NULL),(5425,2978,41711,303866,3,5425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-24','2020-08-24',300.71,NULL,NULL,1,'2021-08-27 13:54:03','2021-08-27 13:54:03',NULL),(5426,2978,41711,303866,3,5426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-24','2020-08-24',232.75,NULL,NULL,1,'2021-08-27 13:54:03','2021-08-27 13:54:03',NULL),(5427,2978,41711,303866,3,5427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-25','2020-08-25',6434.13,NULL,NULL,1,'2021-08-27 13:54:03','2021-08-27 13:54:03',NULL),(5428,2978,41711,303866,3,5428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-25','2020-08-25',757.24,NULL,NULL,1,'2021-08-27 13:54:04','2021-08-27 13:54:04',NULL),(5429,2978,41711,303866,3,5429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-25','2020-08-25',278.48,NULL,NULL,1,'2021-08-27 13:54:04','2021-08-27 13:54:04',NULL),(5430,2978,41711,303866,3,5430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-25','2020-08-25',395.92,NULL,NULL,1,'2021-08-27 13:54:04','2021-08-27 13:54:04',NULL),(5431,2978,41711,303866,3,5431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-26','2020-08-26',5549.74,NULL,NULL,1,'2021-08-27 13:54:04','2021-08-27 13:54:04',NULL),(5432,2978,41711,303866,3,5432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-26','2020-08-26',9406.42,NULL,NULL,1,'2021-08-27 13:54:04','2021-08-27 13:54:04',NULL),(5433,2978,41711,303866,3,5433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-26','2020-08-26',1828.35,NULL,NULL,1,'2021-08-27 13:54:04','2021-08-27 13:54:04',NULL),(5434,2978,41711,303866,3,5434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-26','2020-08-26',1061.58,NULL,NULL,1,'2021-08-27 13:54:04','2021-08-27 13:54:04',NULL),(5435,2978,41711,303866,3,5435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-26','2020-08-26',4840.27,NULL,NULL,1,'2021-08-27 13:54:04','2021-08-27 13:54:04',NULL),(5436,2978,41711,303866,3,5436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-26','2020-08-26',4324.69,NULL,NULL,1,'2021-08-27 13:54:04','2021-08-27 13:54:04',NULL),(5437,2978,41711,303866,3,5437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-26','2020-08-26',1857.45,NULL,NULL,1,'2021-08-27 13:54:04','2021-08-27 13:54:04',NULL),(5438,2978,41711,303866,3,5438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-27','2020-08-27',2837.92,NULL,NULL,1,'2021-08-27 13:54:04','2021-08-27 13:54:04',NULL),(5439,2978,41711,303866,3,5439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-27','2020-08-27',263.14,NULL,NULL,1,'2021-08-27 13:54:04','2021-08-27 13:54:04',NULL),(5440,2978,41711,303866,3,5440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-27','2020-08-27',317.29,NULL,NULL,1,'2021-08-27 13:54:04','2021-08-27 13:54:04',NULL),(5441,2978,41711,303866,3,5441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-27','2020-08-27',662.94,NULL,NULL,1,'2021-08-27 13:54:04','2021-08-27 13:54:04',NULL),(5442,2978,41711,303866,3,5442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-27','2020-08-27',1499.41,NULL,NULL,1,'2021-08-27 13:54:04','2021-08-27 13:54:04',NULL);
INSERT INTO `balance_libro` VALUES (5443,2978,41711,303866,3,5443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-27','2020-08-27',8663.47,NULL,NULL,1,'2021-08-27 13:54:04','2021-08-27 13:54:04',NULL),(5444,2978,41711,303866,3,5444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-27','2020-08-27',206.02,NULL,NULL,1,'2021-08-27 13:54:04','2021-08-27 13:54:04',NULL),(5445,2978,41711,303866,3,5445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-27','2020-08-27',406.55,NULL,NULL,1,'2021-08-27 13:54:04','2021-08-27 13:54:04',NULL),(5446,2978,41711,303866,3,5446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-27','2020-08-27',1568.73,NULL,NULL,1,'2021-08-27 13:54:04','2021-08-27 13:54:04',NULL),(5447,2978,41711,303866,3,5447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-27','2020-08-27',508.59,NULL,NULL,1,'2021-08-27 13:54:04','2021-08-27 13:54:04',NULL),(5448,2978,41711,303866,3,5448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-27','2020-08-27',327.20,NULL,NULL,1,'2021-08-27 13:54:04','2021-08-27 13:54:04',NULL),(5449,2978,41711,303866,3,5449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-27','2020-08-27',1364.27,NULL,NULL,1,'2021-08-27 13:54:04','2021-08-27 13:54:04',NULL),(5450,2978,41711,303866,3,5450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-27','2020-08-27',31807.93,NULL,NULL,1,'2021-08-27 13:54:04','2021-08-27 13:54:04',NULL),(5451,2978,41711,303866,3,5451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-27','2020-08-27',571.83,NULL,NULL,1,'2021-08-27 13:54:04','2021-08-27 13:54:04',NULL),(5452,2978,41711,303866,3,5452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-27','2020-08-27',34021.59,NULL,NULL,1,'2021-08-27 13:54:05','2021-08-27 13:54:05',NULL),(5453,2978,41711,303866,3,5453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-27','2020-08-27',518.70,NULL,NULL,1,'2021-08-27 13:54:05','2021-08-27 13:54:05',NULL),(5454,2978,41711,303866,3,5454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-27','2020-08-27',4248.32,NULL,NULL,1,'2021-08-27 13:54:05','2021-08-27 13:54:05',NULL),(5455,2978,41711,303866,3,5455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-28','2020-08-28',6015.18,NULL,NULL,1,'2021-08-27 13:54:05','2021-08-27 13:54:05',NULL),(5456,2978,41711,303866,3,5456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-28','2020-08-28',1940.19,NULL,NULL,1,'2021-08-27 13:54:05','2021-08-27 13:54:05',NULL),(5457,2978,41711,303866,3,5457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-28','2020-08-28',1457.81,NULL,NULL,1,'2021-08-27 13:54:05','2021-08-27 13:54:05',NULL),(5458,2978,41711,303866,3,5458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-28','2020-08-28',115.81,NULL,NULL,1,'2021-08-27 13:54:05','2021-08-27 13:54:05',NULL),(5459,2978,41711,303866,3,5459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-28','2020-08-28',3932.86,NULL,NULL,1,'2021-08-27 13:54:05','2021-08-27 13:54:05',NULL),(5460,2978,41711,303866,3,5460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-28','2020-08-28',2603.42,NULL,NULL,1,'2021-08-27 13:54:05','2021-08-27 13:54:05',NULL),(5461,2978,41711,303866,3,5461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-28','2020-08-28',1224.18,NULL,NULL,1,'2021-08-27 13:54:05','2021-08-27 13:54:05',NULL),(5462,2978,41711,303866,3,5462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-30','2020-08-30',748.12,NULL,NULL,1,'2021-08-27 13:54:05','2021-08-27 13:54:05',NULL),(5463,2978,41711,303866,3,5463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-30','2020-08-30',7439.05,NULL,NULL,1,'2021-08-27 13:54:05','2021-08-27 13:54:05',NULL),(5464,2978,41711,303866,3,5464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',385.30,NULL,NULL,1,'2021-08-27 13:54:05','2021-08-27 13:54:05',NULL),(5465,2978,41711,303866,3,5465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',1252.98,NULL,NULL,1,'2021-08-27 13:54:05','2021-08-27 13:54:05',NULL),(5466,2978,41711,303866,3,5466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',11155.70,NULL,NULL,1,'2021-08-27 13:54:05','2021-08-27 13:54:05',NULL);
INSERT INTO `balance_libro` VALUES (5467,2978,41711,303866,3,5467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',622.95,NULL,NULL,1,'2021-08-27 13:54:05','2021-08-27 13:54:05',NULL),(5468,2978,41711,303866,3,5468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',9728.34,NULL,NULL,1,'2021-08-27 13:54:05','2021-08-27 13:54:05',NULL),(5469,2978,41711,303866,3,5469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',907.20,NULL,NULL,1,'2021-08-27 13:54:05','2021-08-27 13:54:05',NULL),(5470,2978,41711,303866,3,5470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',1738.80,NULL,NULL,1,'2021-08-27 13:54:05','2021-08-27 13:54:05',NULL),(5471,2978,41711,303867,3,5471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-01','2020-09-01',4818.13,NULL,NULL,1,'2021-08-27 13:54:48','2021-08-27 13:54:48',NULL),(5472,2978,41711,303867,3,5472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-01','2020-09-01',19991.72,NULL,NULL,1,'2021-08-27 13:54:48','2021-08-27 13:54:48',NULL),(5473,2978,41711,303867,3,5473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-01','2020-09-01',2093.08,NULL,NULL,1,'2021-08-27 13:54:48','2021-08-27 13:54:48',NULL),(5474,2978,41711,303867,3,5474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-01','2020-09-01',290.04,NULL,NULL,1,'2021-08-27 13:54:48','2021-08-27 13:54:48',NULL),(5475,2978,41711,303867,3,5475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-01','2020-09-01',345.80,NULL,NULL,1,'2021-08-27 13:54:48','2021-08-27 13:54:48',NULL),(5476,2978,41711,303867,3,5476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-01','2020-09-01',98.39,NULL,NULL,1,'2021-08-27 13:54:48','2021-08-27 13:54:48',NULL),(5477,2978,41711,303867,3,5477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-01','2020-09-01',2188.15,NULL,NULL,1,'2021-08-27 13:54:48','2021-08-27 13:54:48',NULL),(5478,2978,41711,303867,3,5478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-01','2020-09-01',324.03,NULL,NULL,1,'2021-08-27 13:54:48','2021-08-27 13:54:48',NULL),(5479,2978,41711,303867,3,5479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-02','2020-09-02',2704.37,NULL,NULL,1,'2021-08-27 13:54:48','2021-08-27 13:54:48',NULL),(5480,2978,41711,303867,3,5480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-02','2020-09-02',23544.12,NULL,NULL,1,'2021-08-27 13:54:48','2021-08-27 13:54:48',NULL),(5481,2978,41711,303867,3,5481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-02','2020-09-02',518.05,NULL,NULL,1,'2021-08-27 13:54:48','2021-08-27 13:54:48',NULL),(5482,2978,41711,303867,3,5482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-02','2020-09-02',7900.00,NULL,NULL,1,'2021-08-27 13:54:48','2021-08-27 13:54:48',NULL),(5483,2978,41711,303867,3,5483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-03','2020-09-03',845.34,NULL,NULL,1,'2021-08-27 13:54:48','2021-08-27 13:54:48',NULL),(5484,2978,41711,303867,3,5484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-03','2020-09-03',184.85,NULL,NULL,1,'2021-08-27 13:54:48','2021-08-27 13:54:48',NULL),(5485,2978,41711,303867,3,5485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-03','2020-09-03',6157.59,NULL,NULL,1,'2021-08-27 13:54:48','2021-08-27 13:54:48',NULL),(5486,2978,41711,303867,3,5486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-04','2020-09-04',300.00,NULL,NULL,1,'2021-08-27 13:54:48','2021-08-27 13:54:48',NULL),(5487,2978,41711,303867,3,5487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-04','2020-09-04',1535.97,NULL,NULL,1,'2021-08-27 13:54:48','2021-08-27 13:54:48',NULL),(5488,2978,41711,303867,3,5488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-04','2020-09-04',535.79,NULL,NULL,1,'2021-08-27 13:54:48','2021-08-27 13:54:48',NULL),(5489,2978,41711,303867,3,5489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-04','2020-09-04',4236.48,NULL,NULL,1,'2021-08-27 13:54:49','2021-08-27 13:54:49',NULL),(5490,2978,41711,303867,3,5490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-04','2020-09-04',256.06,NULL,NULL,1,'2021-08-27 13:54:49','2021-08-27 13:54:49',NULL);
INSERT INTO `balance_libro` VALUES (5491,2978,41711,303867,3,5491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-04','2020-09-04',2490.14,NULL,NULL,1,'2021-08-27 13:54:49','2021-08-27 13:54:49',NULL),(5492,2978,41711,303867,3,5492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-04','2020-09-04',518.70,NULL,NULL,1,'2021-08-27 13:54:49','2021-08-27 13:54:49',NULL),(5493,2978,41711,303867,3,5493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-04','2020-09-04',500.56,NULL,NULL,1,'2021-08-27 13:54:49','2021-08-27 13:54:49',NULL),(5494,2978,41711,303867,3,5494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-04','2020-09-04',3224.26,NULL,NULL,1,'2021-08-27 13:54:49','2021-08-27 13:54:49',NULL),(5495,2978,41711,303867,3,5495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-06','2020-09-06',7306.55,NULL,NULL,1,'2021-08-27 13:54:49','2021-08-27 13:54:49',NULL),(5496,2978,41711,303867,3,5496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-06','2020-09-06',113.40,NULL,NULL,1,'2021-08-27 13:54:49','2021-08-27 13:54:49',NULL),(5497,2978,41711,303867,3,5497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-06','2020-09-06',575.79,NULL,NULL,1,'2021-08-27 13:54:49','2021-08-27 13:54:49',NULL),(5498,2978,41711,303867,3,5498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-07','2020-09-07',99.55,NULL,NULL,1,'2021-08-27 13:54:49','2021-08-27 13:54:49',NULL),(5499,2978,41711,303867,3,5499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-07','2020-09-07',4436.56,NULL,NULL,1,'2021-08-27 13:54:49','2021-08-27 13:54:49',NULL),(5500,2978,41711,303867,3,5500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-07','2020-09-07',1338.85,NULL,NULL,1,'2021-08-27 13:54:49','2021-08-27 13:54:49',NULL),(5501,2978,41711,303867,3,5501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-07','2020-09-07',311.97,NULL,NULL,1,'2021-08-27 13:54:49','2021-08-27 13:54:49',NULL),(5502,2978,41711,303867,3,5502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-07','2020-09-07',125.57,NULL,NULL,1,'2021-08-27 13:54:49','2021-08-27 13:54:49',NULL),(5503,2978,41711,303867,3,5503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-07','2020-09-07',765.05,NULL,NULL,1,'2021-08-27 13:54:49','2021-08-27 13:54:49',NULL),(5504,2978,41711,303867,3,5504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-07','2020-09-07',258.77,NULL,NULL,1,'2021-08-27 13:54:49','2021-08-27 13:54:49',NULL),(5505,2978,41711,303867,3,5505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-08','2020-09-08',5687.94,NULL,NULL,1,'2021-08-27 13:54:49','2021-08-27 13:54:49',NULL),(5506,2978,41711,303867,3,5506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-08','2020-09-08',1909.91,NULL,NULL,1,'2021-08-27 13:54:49','2021-08-27 13:54:49',NULL),(5507,2978,41711,303867,3,5507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-08','2020-09-08',43.40,NULL,NULL,1,'2021-08-27 13:54:49','2021-08-27 13:54:49',NULL),(5508,2978,41711,303867,3,5508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-08','2020-09-08',1440.80,NULL,NULL,1,'2021-08-27 13:54:49','2021-08-27 13:54:49',NULL),(5509,2978,41711,303867,3,5509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-08','2020-09-08',639.20,NULL,NULL,1,'2021-08-27 13:54:49','2021-08-27 13:54:49',NULL),(5510,2978,41711,303867,3,5510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-08','2020-09-08',1832.67,NULL,NULL,1,'2021-08-27 13:54:49','2021-08-27 13:54:49',NULL),(5511,2978,41711,303867,3,5511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-08','2020-09-08',1451.33,NULL,NULL,1,'2021-08-27 13:54:50','2021-08-27 13:54:50',NULL),(5512,2978,41711,303867,3,5512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-08','2020-09-08',1244.62,NULL,NULL,1,'2021-08-27 13:54:50','2021-08-27 13:54:50',NULL),(5513,2978,41711,303867,3,5513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-09','2020-09-09',13144.38,NULL,NULL,1,'2021-08-27 13:54:50','2021-08-27 13:54:50',NULL),(5514,2978,41711,303867,3,5514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-09','2020-09-09',1167.01,NULL,NULL,1,'2021-08-27 13:54:50','2021-08-27 13:54:50',NULL);
INSERT INTO `balance_libro` VALUES (5515,2978,41711,303867,3,5515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-09','2020-09-09',28105.62,NULL,NULL,1,'2021-08-27 13:54:50','2021-08-27 13:54:50',NULL),(5516,2978,41711,303867,3,5516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-09','2020-09-09',11403.64,NULL,NULL,1,'2021-08-27 13:54:50','2021-08-27 13:54:50',NULL),(5517,2978,41711,303867,3,5517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-09','2020-09-09',2797.15,NULL,NULL,1,'2021-08-27 13:54:50','2021-08-27 13:54:50',NULL),(5518,2978,41711,303867,3,5518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-09','2020-09-09',25323.29,NULL,NULL,1,'2021-08-27 13:54:50','2021-08-27 13:54:50',NULL),(5519,2978,41711,303867,3,5519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-09','2020-09-09',5248.81,NULL,NULL,1,'2021-08-27 13:54:50','2021-08-27 13:54:50',NULL),(5520,2978,41711,303867,3,5520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-09','2020-09-09',2545.80,NULL,NULL,1,'2021-08-27 13:54:50','2021-08-27 13:54:50',NULL),(5521,2978,41711,303867,3,5521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-09','2020-09-09',2432.28,NULL,NULL,1,'2021-08-27 13:54:50','2021-08-27 13:54:50',NULL),(5522,2978,41711,303867,3,5522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-09','2020-09-09',14088.22,NULL,NULL,1,'2021-08-27 13:54:50','2021-08-27 13:54:50',NULL),(5523,2978,41711,303867,3,5523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-09','2020-09-09',391.25,NULL,NULL,1,'2021-08-27 13:54:50','2021-08-27 13:54:50',NULL),(5524,2978,41711,303867,3,5524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-09','2020-09-09',77.58,NULL,NULL,1,'2021-08-27 13:54:50','2021-08-27 13:54:50',NULL),(5525,2978,41711,303867,3,5525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-09','2020-09-09',273.46,NULL,NULL,1,'2021-08-27 13:54:50','2021-08-27 13:54:50',NULL),(5526,2978,41711,303867,3,5526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-09','2020-09-09',2077.50,NULL,NULL,1,'2021-08-27 13:54:50','2021-08-27 13:54:50',NULL),(5527,2978,41711,303867,3,5527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-10','2020-09-10',1419.91,NULL,NULL,1,'2021-08-27 13:54:50','2021-08-27 13:54:50',NULL),(5528,2978,41711,303867,3,5528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-10','2020-09-10',1231.02,NULL,NULL,1,'2021-08-27 13:54:50','2021-08-27 13:54:50',NULL),(5529,2978,41711,303867,3,5529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-10','2020-09-10',473.35,NULL,NULL,1,'2021-08-27 13:54:50','2021-08-27 13:54:50',NULL),(5530,2978,41711,303867,3,5530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-10','2020-09-10',461.77,NULL,NULL,1,'2021-08-27 13:54:50','2021-08-27 13:54:50',NULL),(5531,2978,41711,303867,3,5531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-10','2020-09-10',7291.91,NULL,NULL,1,'2021-08-27 13:54:50','2021-08-27 13:54:50',NULL),(5532,2978,41711,303867,3,5532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-10','2020-09-10',15235.38,NULL,NULL,1,'2021-08-27 13:54:50','2021-08-27 13:54:50',NULL),(5533,2978,41711,303867,3,5533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-10','2020-09-10',2845.63,NULL,NULL,1,'2021-08-27 13:54:51','2021-08-27 13:54:51',NULL),(5534,2978,41711,303867,3,5534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-10','2020-09-10',627.64,NULL,NULL,1,'2021-08-27 13:54:51','2021-08-27 13:54:51',NULL),(5535,2978,41711,303867,3,5535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-10','2020-09-10',280.85,NULL,NULL,1,'2021-08-27 13:54:51','2021-08-27 13:54:51',NULL),(5536,2978,41711,303867,3,5536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-10','2020-09-10',258.77,NULL,NULL,1,'2021-08-27 13:54:51','2021-08-27 13:54:51',NULL),(5537,2978,41711,303867,3,5537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-10','2020-09-10',691.60,NULL,NULL,1,'2021-08-27 13:54:51','2021-08-27 13:54:51',NULL),(5538,2978,41711,303867,3,5538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-10','2020-09-10',534.70,NULL,NULL,1,'2021-08-27 13:54:51','2021-08-27 13:54:51',NULL);
INSERT INTO `balance_libro` VALUES (5539,2978,41711,303867,3,5539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-10','2020-09-10',1227.12,NULL,NULL,1,'2021-08-27 13:54:51','2021-08-27 13:54:51',NULL),(5540,2978,41711,303867,3,5540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-10','2020-09-10',558.66,NULL,NULL,1,'2021-08-27 13:54:51','2021-08-27 13:54:51',NULL),(5541,2978,41711,303867,3,5541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-10','2020-09-10',1020.86,NULL,NULL,1,'2021-08-27 13:54:51','2021-08-27 13:54:51',NULL),(5542,2978,41711,303867,3,5542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-11','2020-09-11',14502.74,NULL,NULL,1,'2021-08-27 13:54:51','2021-08-27 13:54:51',NULL),(5543,2978,41711,303867,3,5543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-11','2020-09-11',19178.89,NULL,NULL,1,'2021-08-27 13:54:51','2021-08-27 13:54:51',NULL),(5544,2978,41711,303867,3,5544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-11','2020-09-11',2509.84,NULL,NULL,1,'2021-08-27 13:54:51','2021-08-27 13:54:51',NULL),(5545,2978,41711,303867,3,5545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-11','2020-09-11',227.41,NULL,NULL,1,'2021-08-27 13:54:51','2021-08-27 13:54:51',NULL),(5546,2978,41711,303867,3,5546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-11','2020-09-11',2038.79,NULL,NULL,1,'2021-08-27 13:54:51','2021-08-27 13:54:51',NULL),(5547,2978,41711,303867,3,5547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-11','2020-09-11',471.94,NULL,NULL,1,'2021-08-27 13:54:51','2021-08-27 13:54:51',NULL),(5548,2978,41711,303867,3,5548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-11','2020-09-11',633.51,NULL,NULL,1,'2021-08-27 13:54:51','2021-08-27 13:54:51',NULL),(5549,2978,41711,303867,3,5549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-11','2020-09-11',796.69,NULL,NULL,1,'2021-08-27 13:54:51','2021-08-27 13:54:51',NULL),(5550,2978,41711,303867,3,5550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-11','2020-09-11',1134.28,NULL,NULL,1,'2021-08-27 13:54:51','2021-08-27 13:54:51',NULL),(5551,2978,41711,303867,3,5551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-11','2020-09-11',886.83,NULL,NULL,1,'2021-08-27 13:54:51','2021-08-27 13:54:51',NULL),(5552,2978,41711,303867,3,5552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-11','2020-09-11',2400.24,NULL,NULL,1,'2021-08-27 13:54:51','2021-08-27 13:54:51',NULL),(5553,2978,41711,303867,3,5553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-13','2020-09-13',16407.43,NULL,NULL,1,'2021-08-27 13:54:51','2021-08-27 13:54:51',NULL),(5554,2978,41711,303867,3,5554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-13','2020-09-13',191.32,NULL,NULL,1,'2021-08-27 13:54:52','2021-08-27 13:54:52',NULL),(5555,2978,41711,303867,3,5555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-14','2020-09-14',2017.15,NULL,NULL,1,'2021-08-27 13:54:52','2021-08-27 13:54:52',NULL),(5556,2978,41711,303867,3,5556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-14','2020-09-14',22209.71,NULL,NULL,1,'2021-08-27 13:54:52','2021-08-27 13:54:52',NULL),(5557,2978,41711,303867,3,5557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-14','2020-09-14',2085.81,NULL,NULL,1,'2021-08-27 13:54:52','2021-08-27 13:54:52',NULL),(5558,2978,41711,303867,3,5558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-14','2020-09-14',2699.72,NULL,NULL,1,'2021-08-27 13:54:52','2021-08-27 13:54:52',NULL),(5559,2978,41711,303867,3,5559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-14','2020-09-14',158.56,NULL,NULL,1,'2021-08-27 13:54:52','2021-08-27 13:54:52',NULL),(5560,2978,41711,303867,3,5560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-14','2020-09-14',183.21,NULL,NULL,1,'2021-08-27 13:54:52','2021-08-27 13:54:52',NULL),(5561,2978,41711,303867,3,5561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-14','2020-09-14',611.84,NULL,NULL,1,'2021-08-27 13:54:52','2021-08-27 13:54:52',NULL),(5562,2978,41711,303867,3,5562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-14','2020-09-14',1094.28,NULL,NULL,1,'2021-08-27 13:54:52','2021-08-27 13:54:52',NULL);
INSERT INTO `balance_libro` VALUES (5563,2978,41711,303867,3,5563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-15','2020-09-15',619.56,NULL,NULL,1,'2021-08-27 13:54:52','2021-08-27 13:54:52',NULL),(5564,2978,41711,303867,3,5564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-15','2020-09-15',11267.23,NULL,NULL,1,'2021-08-27 13:54:52','2021-08-27 13:54:52',NULL),(5565,2978,41711,303867,3,5565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-15','2020-09-15',1037.40,NULL,NULL,1,'2021-08-27 13:54:52','2021-08-27 13:54:52',NULL),(5566,2978,41711,303867,3,5566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-15','2020-09-15',6005.31,NULL,NULL,1,'2021-08-27 13:54:52','2021-08-27 13:54:52',NULL),(5567,2978,41711,303867,3,5567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-15','2020-09-15',7999.17,NULL,NULL,1,'2021-08-27 13:54:52','2021-08-27 13:54:52',NULL),(5568,2978,41711,303867,3,5568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-15','2020-09-15',530.31,NULL,NULL,1,'2021-08-27 13:54:52','2021-08-27 13:54:52',NULL),(5569,2978,41711,303867,3,5569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-15','2020-09-15',1306.13,NULL,NULL,1,'2021-08-27 13:54:52','2021-08-27 13:54:52',NULL),(5570,2978,41711,303867,3,5570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-15','2020-09-15',987.10,NULL,NULL,1,'2021-08-27 13:54:52','2021-08-27 13:54:52',NULL),(5571,2978,41711,303867,3,5571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-16','2020-09-16',15797.00,NULL,NULL,1,'2021-08-27 13:54:52','2021-08-27 13:54:52',NULL),(5572,2978,41711,303867,3,5572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-16','2020-09-16',1794.33,NULL,NULL,1,'2021-08-27 13:54:52','2021-08-27 13:54:52',NULL),(5573,2978,41711,303867,3,5573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-16','2020-09-16',12617.55,NULL,NULL,1,'2021-08-27 13:54:52','2021-08-27 13:54:52',NULL),(5574,2978,41711,303867,3,5574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-16','2020-09-16',234.43,NULL,NULL,1,'2021-08-27 13:54:53','2021-08-27 13:54:53',NULL),(5575,2978,41711,303867,3,5575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-17','2020-09-17',7183.67,NULL,NULL,1,'2021-08-27 13:54:53','2021-08-27 13:54:53',NULL),(5576,2978,41711,303867,3,5576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-17','2020-09-17',6106.07,NULL,NULL,1,'2021-08-27 13:54:53','2021-08-27 13:54:53',NULL),(5577,2978,41711,303867,3,5577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-17','2020-09-17',2086.28,NULL,NULL,1,'2021-08-27 13:54:53','2021-08-27 13:54:53',NULL),(5578,2978,41711,303867,3,5578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-17','2020-09-17',155.16,NULL,NULL,1,'2021-08-27 13:54:53','2021-08-27 13:54:53',NULL),(5579,2978,41711,303867,3,5579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-17','2020-09-17',994.49,NULL,NULL,1,'2021-08-27 13:54:53','2021-08-27 13:54:53',NULL),(5580,2978,41711,303867,3,5580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-17','2020-09-17',898.09,NULL,NULL,1,'2021-08-27 13:54:53','2021-08-27 13:54:53',NULL),(5581,2978,41711,303867,3,5581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-18','2020-09-18',4155.26,NULL,NULL,1,'2021-08-27 13:54:53','2021-08-27 13:54:53',NULL),(5582,2978,41711,303867,3,5582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-18','2020-09-18',136.73,NULL,NULL,1,'2021-08-27 13:54:53','2021-08-27 13:54:53',NULL),(5583,2978,41711,303867,3,5583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-18','2020-09-18',1700.13,NULL,NULL,1,'2021-08-27 13:54:53','2021-08-27 13:54:53',NULL),(5584,2978,41711,303867,3,5584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-18','2020-09-18',510.25,NULL,NULL,1,'2021-08-27 13:54:53','2021-08-27 13:54:53',NULL),(5585,2978,41711,303867,3,5585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-18','2020-09-18',9043.47,NULL,NULL,1,'2021-08-27 13:54:53','2021-08-27 13:54:53',NULL),(5586,2978,41711,303867,3,5586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-18','2020-09-18',1221.20,NULL,NULL,1,'2021-08-27 13:54:53','2021-08-27 13:54:53',NULL);
INSERT INTO `balance_libro` VALUES (5587,2978,41711,303867,3,5587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-20','2020-09-20',7153.00,NULL,NULL,1,'2021-08-27 13:54:53','2021-08-27 13:54:53',NULL),(5588,2978,41711,303867,3,5588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-22','2020-09-22',6162.97,NULL,NULL,1,'2021-08-27 13:54:53','2021-08-27 13:54:53',NULL),(5589,2978,41711,303867,3,5589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-22','2020-09-22',422.00,NULL,NULL,1,'2021-08-27 13:54:53','2021-08-27 13:54:53',NULL),(5590,2978,41711,303867,3,5590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-22','2020-09-22',835.82,NULL,NULL,1,'2021-08-27 13:54:53','2021-08-27 13:54:53',NULL),(5591,2978,41711,303867,3,5591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-22','2020-09-22',85.51,NULL,NULL,1,'2021-08-27 13:54:53','2021-08-27 13:54:53',NULL),(5592,2978,41711,303867,3,5592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-22','2020-09-22',518.70,NULL,NULL,1,'2021-08-27 13:54:54','2021-08-27 13:54:54',NULL),(5593,2978,41711,303867,3,5593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-22','2020-09-22',531.05,NULL,NULL,1,'2021-08-27 13:54:54','2021-08-27 13:54:54',NULL),(5594,2978,41711,303867,3,5594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-22','2020-09-22',25207.57,NULL,NULL,1,'2021-08-27 13:54:54','2021-08-27 13:54:54',NULL),(5595,2978,41711,303867,3,5595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-22','2020-09-22',10904.08,NULL,NULL,1,'2021-08-27 13:54:54','2021-08-27 13:54:54',NULL),(5596,2978,41711,303867,3,5596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-22','2020-09-22',8345.14,NULL,NULL,1,'2021-08-27 13:54:54','2021-08-27 13:54:54',NULL),(5597,2978,41711,303867,3,5597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-22','2020-09-22',8749.09,NULL,NULL,1,'2021-08-27 13:54:54','2021-08-27 13:54:54',NULL),(5598,2978,41711,303867,3,5598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-22','2020-09-22',87.56,NULL,NULL,1,'2021-08-27 13:54:54','2021-08-27 13:54:54',NULL),(5599,2978,41711,303867,3,5599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-22','2020-09-22',1353.16,NULL,NULL,1,'2021-08-27 13:54:54','2021-08-27 13:54:54',NULL),(5600,2978,41711,303867,3,5600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-22','2020-09-22',157.21,NULL,NULL,1,'2021-08-27 13:54:54','2021-08-27 13:54:54',NULL),(5601,2978,41711,303867,3,5601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-22','2020-09-22',318.68,NULL,NULL,1,'2021-08-27 13:54:54','2021-08-27 13:54:54',NULL),(5602,2978,41711,303867,3,5602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-22','2020-09-22',392.56,NULL,NULL,1,'2021-08-27 13:54:54','2021-08-27 13:54:54',NULL),(5603,2978,41711,303867,3,5603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-23','2020-09-23',4444.88,NULL,NULL,1,'2021-08-27 13:54:54','2021-08-27 13:54:54',NULL),(5604,2978,41711,303867,3,5604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-23','2020-09-23',183.89,NULL,NULL,1,'2021-08-27 13:54:54','2021-08-27 13:54:54',NULL),(5605,2978,41711,303867,3,5605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-23','2020-09-23',6859.82,NULL,NULL,1,'2021-08-27 13:54:54','2021-08-27 13:54:54',NULL),(5606,2978,41711,303867,3,5606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-23','2020-09-23',45429.63,NULL,NULL,1,'2021-08-27 13:54:54','2021-08-27 13:54:54',NULL),(5607,2978,41711,303867,3,5607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-23','2020-09-23',1763.98,NULL,NULL,1,'2021-08-27 13:54:55','2021-08-27 13:54:55',NULL),(5608,2978,41711,303867,3,5608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-23','2020-09-23',4904.06,NULL,NULL,1,'2021-08-27 13:54:55','2021-08-27 13:54:55',NULL),(5609,2978,41711,303867,3,5609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-23','2020-09-23',36185.72,NULL,NULL,1,'2021-08-27 13:54:55','2021-08-27 13:54:55',NULL),(5610,2978,41711,303867,3,5610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-23','2020-09-23',1434.15,NULL,NULL,1,'2021-08-27 13:54:55','2021-08-27 13:54:55',NULL);
INSERT INTO `balance_libro` VALUES (5611,2978,41711,303867,3,5611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-24','2020-09-24',3156.13,NULL,NULL,1,'2021-08-27 13:54:55','2021-08-27 13:54:55',NULL),(5612,2978,41711,303867,3,5612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-24','2020-09-24',13083.73,NULL,NULL,1,'2021-08-27 13:54:55','2021-08-27 13:54:55',NULL),(5613,2978,41711,303867,3,5613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-24','2020-09-24',429.17,NULL,NULL,1,'2021-08-27 13:54:55','2021-08-27 13:54:55',NULL),(5614,2978,41711,303867,3,5614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-24','2020-09-24',117.45,NULL,NULL,1,'2021-08-27 13:54:55','2021-08-27 13:54:55',NULL),(5615,2978,41711,303867,3,5615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-24','2020-09-24',16291.23,NULL,NULL,1,'2021-08-27 13:54:55','2021-08-27 13:54:55',NULL),(5616,2978,41711,303867,3,5616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-24','2020-09-24',162.32,NULL,NULL,1,'2021-08-27 13:54:55','2021-08-27 13:54:55',NULL),(5617,2978,41711,303867,3,5617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-24','2020-09-24',1217.18,NULL,NULL,1,'2021-08-27 13:54:55','2021-08-27 13:54:55',NULL),(5618,2978,41711,303867,3,5618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-24','2020-09-24',480.69,NULL,NULL,1,'2021-08-27 13:54:55','2021-08-27 13:54:55',NULL),(5619,2978,41711,303867,3,5619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-24','2020-09-24',486.37,NULL,NULL,1,'2021-08-27 13:54:55','2021-08-27 13:54:55',NULL),(5620,2978,41711,303867,3,5620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-24','2020-09-24',434.37,NULL,NULL,1,'2021-08-27 13:54:55','2021-08-27 13:54:55',NULL),(5621,2978,41711,303867,3,5621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-24','2020-09-24',978.93,NULL,NULL,1,'2021-08-27 13:54:55','2021-08-27 13:54:55',NULL),(5622,2978,41711,303867,3,5622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-24','2020-09-24',1143.19,NULL,NULL,1,'2021-08-27 13:54:55','2021-08-27 13:54:55',NULL),(5623,2978,41711,303867,3,5623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-24','2020-09-24',937.60,NULL,NULL,1,'2021-08-27 13:54:55','2021-08-27 13:54:55',NULL),(5624,2978,41711,303867,3,5624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-24','2020-09-24',1902.19,NULL,NULL,1,'2021-08-27 13:54:55','2021-08-27 13:54:55',NULL),(5625,2978,41711,303867,3,5625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-25','2020-09-25',518.70,NULL,NULL,1,'2021-08-27 13:54:55','2021-08-27 13:54:55',NULL),(5626,2978,41711,303867,3,5626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-25','2020-09-25',2191.10,NULL,NULL,1,'2021-08-27 13:54:55','2021-08-27 13:54:55',NULL),(5627,2978,41711,303867,3,5627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-25','2020-09-25',4092.64,NULL,NULL,1,'2021-08-27 13:54:55','2021-08-27 13:54:55',NULL),(5628,2978,41711,303867,3,5628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-25','2020-09-25',212.37,NULL,NULL,1,'2021-08-27 13:54:55','2021-08-27 13:54:55',NULL),(5629,2978,41711,303867,3,5629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-25','2020-09-25',7293.53,NULL,NULL,1,'2021-08-27 13:54:56','2021-08-27 13:54:56',NULL),(5630,2978,41711,303867,3,5630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-25','2020-09-25',4243.34,NULL,NULL,1,'2021-08-27 13:54:56','2021-08-27 13:54:56',NULL),(5631,2978,41711,303867,3,5631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-25','2020-09-25',285.91,NULL,NULL,1,'2021-08-27 13:54:56','2021-08-27 13:54:56',NULL),(5632,2978,41711,303867,3,5632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-27','2020-09-27',4094.66,NULL,NULL,1,'2021-08-27 13:54:56','2021-08-27 13:54:56',NULL),(5633,2978,41711,303867,3,5633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-28','2020-09-28',1212.65,NULL,NULL,1,'2021-08-27 13:54:56','2021-08-27 13:54:56',NULL),(5634,2978,41711,303867,3,5634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-28','2020-09-28',9478.91,NULL,NULL,1,'2021-08-27 13:54:56','2021-08-27 13:54:56',NULL);
INSERT INTO `balance_libro` VALUES (5635,2978,41711,303867,3,5635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-28','2020-09-28',578.90,NULL,NULL,1,'2021-08-27 13:54:56','2021-08-27 13:54:56',NULL),(5636,2978,41711,303867,3,5636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-28','2020-09-28',2337.28,NULL,NULL,1,'2021-08-27 13:54:56','2021-08-27 13:54:56',NULL),(5637,2978,41711,303867,3,5637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-28','2020-09-28',255.03,NULL,NULL,1,'2021-08-27 13:54:56','2021-08-27 13:54:56',NULL),(5638,2978,41711,303867,3,5638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-29','2020-09-29',3470.54,NULL,NULL,1,'2021-08-27 13:54:56','2021-08-27 13:54:56',NULL),(5639,2978,41711,303867,3,5639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-29','2020-09-29',117.45,NULL,NULL,1,'2021-08-27 13:54:56','2021-08-27 13:54:56',NULL),(5640,2978,41711,303867,3,5640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-29','2020-09-29',1545.92,NULL,NULL,1,'2021-08-27 13:54:56','2021-08-27 13:54:56',NULL),(5641,2978,41711,303867,3,5641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-29','2020-09-29',6944.01,NULL,NULL,1,'2021-08-27 13:54:56','2021-08-27 13:54:56',NULL),(5642,2978,41711,303867,3,5642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-29','2020-09-29',227.12,NULL,NULL,1,'2021-08-27 13:54:56','2021-08-27 13:54:56',NULL),(5643,2978,41711,303867,3,5643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-29','2020-09-29',1199.36,NULL,NULL,1,'2021-08-27 13:54:56','2021-08-27 13:54:56',NULL),(5644,2978,41711,303867,3,5644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',798.62,NULL,NULL,1,'2021-08-27 13:54:56','2021-08-27 13:54:56',NULL),(5645,2978,41711,303867,3,5645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',4696.25,NULL,NULL,1,'2021-08-27 13:54:56','2021-08-27 13:54:56',NULL),(5646,2978,41711,303867,3,5646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1578.95,NULL,NULL,1,'2021-08-27 13:54:56','2021-08-27 13:54:56',NULL),(5647,2978,41711,303867,3,5647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',1669.94,NULL,NULL,1,'2021-08-27 13:54:57','2021-08-27 13:54:57',NULL),(5648,2978,41711,303868,3,5648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-01','2020-10-01',6237.99,NULL,NULL,1,'2021-08-27 13:56:14','2021-08-27 13:56:14',NULL),(5649,2978,41711,303868,3,5649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-01','2020-10-01',2119.92,NULL,NULL,1,'2021-08-27 13:56:14','2021-08-27 13:56:14',NULL),(5650,2978,41711,303868,3,5650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-02','2020-10-02',1580.39,NULL,NULL,1,'2021-08-27 13:56:14','2021-08-27 13:56:14',NULL),(5651,2978,41711,303868,3,5651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-02','2020-10-02',862.85,NULL,NULL,1,'2021-08-27 13:56:14','2021-08-27 13:56:14',NULL),(5652,2978,41711,303868,3,5652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-02','2020-10-02',3556.49,NULL,NULL,1,'2021-08-27 13:56:14','2021-08-27 13:56:14',NULL),(5653,2978,41711,303868,3,5653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-02','2020-10-02',3650.00,NULL,NULL,1,'2021-08-27 13:56:14','2021-08-27 13:56:14',NULL),(5654,2978,41711,303868,3,5654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-04','2020-10-04',10542.65,NULL,NULL,1,'2021-08-27 13:56:14','2021-08-27 13:56:14',NULL),(5655,2978,41711,303868,3,5655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-05','2020-10-05',21723.92,NULL,NULL,1,'2021-08-27 13:56:15','2021-08-27 13:56:15',NULL),(5656,2978,41711,303868,3,5656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-05','2020-10-05',1216.31,NULL,NULL,1,'2021-08-27 13:56:15','2021-08-27 13:56:15',NULL),(5657,2978,41711,303868,3,5657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-05','2020-10-05',433.33,NULL,NULL,1,'2021-08-27 13:56:15','2021-08-27 13:56:15',NULL),(5658,2978,41711,303868,3,5658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-05','2020-10-05',1387.60,NULL,NULL,1,'2021-08-27 13:56:15','2021-08-27 13:56:15',NULL);
INSERT INTO `balance_libro` VALUES (5659,2978,41711,303868,3,5659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-05','2020-10-05',9778.52,NULL,NULL,1,'2021-08-27 13:56:15','2021-08-27 13:56:15',NULL),(5660,2978,41711,303868,3,5660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-05','2020-10-05',300.00,NULL,NULL,1,'2021-08-27 13:56:15','2021-08-27 13:56:15',NULL),(5661,2978,41711,303868,3,5661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-05','2020-10-05',2533.53,NULL,NULL,1,'2021-08-27 13:56:15','2021-08-27 13:56:15',NULL),(5662,2978,41711,303868,3,5662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-06','2020-10-06',915.95,NULL,NULL,1,'2021-08-27 13:56:15','2021-08-27 13:56:15',NULL),(5663,2978,41711,303868,3,5663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-06','2020-10-06',2638.76,NULL,NULL,1,'2021-08-27 13:56:15','2021-08-27 13:56:15',NULL),(5664,2978,41711,303868,3,5664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-06','2020-10-06',586.01,NULL,NULL,1,'2021-08-27 13:56:15','2021-08-27 13:56:15',NULL),(5665,2978,41711,303868,3,5665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-06','2020-10-06',26437.47,NULL,NULL,1,'2021-08-27 13:56:15','2021-08-27 13:56:15',NULL),(5666,2978,41711,303868,3,5666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-06','2020-10-06',422.58,NULL,NULL,1,'2021-08-27 13:56:15','2021-08-27 13:56:15',NULL),(5667,2978,41711,303868,3,5667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-06','2020-10-06',12363.23,NULL,NULL,1,'2021-08-27 13:56:15','2021-08-27 13:56:15',NULL),(5668,2978,41711,303868,3,5668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-06','2020-10-06',460.71,NULL,NULL,1,'2021-08-27 13:56:15','2021-08-27 13:56:15',NULL),(5669,2978,41711,303868,3,5669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-06','2020-10-06',1170.47,NULL,NULL,1,'2021-08-27 13:56:15','2021-08-27 13:56:15',NULL),(5670,2978,41711,303868,3,5670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-06','2020-10-06',295.19,NULL,NULL,1,'2021-08-27 13:56:15','2021-08-27 13:56:15',NULL),(5671,2978,41711,303868,3,5671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-06','2020-10-06',3226.60,NULL,NULL,1,'2021-08-27 13:56:15','2021-08-27 13:56:15',NULL),(5672,2978,41711,303868,3,5672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-07','2020-10-07',18444.09,NULL,NULL,1,'2021-08-27 13:56:15','2021-08-27 13:56:15',NULL),(5673,2978,41711,303868,3,5673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-07','2020-10-07',9935.50,NULL,NULL,1,'2021-08-27 13:56:15','2021-08-27 13:56:15',NULL),(5674,2978,41711,303868,3,5674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-07','2020-10-07',142.10,NULL,NULL,1,'2021-08-27 13:56:15','2021-08-27 13:56:15',NULL),(5675,2978,41711,303868,3,5675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-07','2020-10-07',927.46,NULL,NULL,1,'2021-08-27 13:56:15','2021-08-27 13:56:15',NULL),(5676,2978,41711,303868,3,5676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-07','2020-10-07',12147.81,NULL,NULL,1,'2021-08-27 13:56:15','2021-08-27 13:56:15',NULL),(5677,2978,41711,303868,3,5677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-07','2020-10-07',1271.48,NULL,NULL,1,'2021-08-27 13:56:15','2021-08-27 13:56:15',NULL),(5678,2978,41711,303868,3,5678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-07','2020-10-07',162.13,NULL,NULL,1,'2021-08-27 13:56:16','2021-08-27 13:56:16',NULL),(5679,2978,41711,303868,3,5679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-08','2020-10-08',25557.22,NULL,NULL,1,'2021-08-27 13:56:16','2021-08-27 13:56:16',NULL),(5680,2978,41711,303868,3,5680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-08','2020-10-08',3674.35,NULL,NULL,1,'2021-08-27 13:56:16','2021-08-27 13:56:16',NULL),(5681,2978,41711,303868,3,5681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-08','2020-10-08',1715.48,NULL,NULL,1,'2021-08-27 13:56:16','2021-08-27 13:56:16',NULL),(5682,2978,41711,303868,3,5682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-08','2020-10-08',37267.21,NULL,NULL,1,'2021-08-27 13:56:16','2021-08-27 13:56:16',NULL);
INSERT INTO `balance_libro` VALUES (5